{"vars":[{"line":81,"name":"vars","kind":2,"containerName":""},{"line":93,"kind":2,"containerName":"","name":"base"},{"line":97,"range":{"start":{"line":97,"character":0},"end":{"character":9999,"line":102}},"kind":12,"signature":{"label":"new($class,@args)","documentation":" _initialize is where the heavy stuff will happen when new is called","parameters":[{"label":"$class"},{"label":"@args"}]},"children":[{"definition":"my","line":98,"name":"$class","localvar":"my","containerName":"new","kind":13},{"line":98,"name":"@args","kind":13,"containerName":"new"},{"definition":"my","line":99,"name":"$self","localvar":"my","kind":13,"containerName":"new"},{"line":99,"containerName":"new","kind":13,"name":"$class"},{"line":100,"name":"$self","kind":13,"containerName":"new"},{"name":"_initialize","kind":12,"containerName":"new","line":100},{"line":100,"containerName":"new","kind":13,"name":"@args"},{"containerName":"new","kind":13,"name":"$self","line":101}],"name":"new","containerName":"main::","definition":"sub","detail":"($class,@args)"},{"range":{"end":{"line":107,"character":9999},"start":{"character":0,"line":104}},"kind":12,"line":104,"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"","label":"_initialize($self,@args)"},"name":"_initialize","containerName":"main::","children":[{"line":105,"localvar":"my","containerName":"_initialize","kind":13,"name":"$self","definition":"my"},{"name":"@args","containerName":"_initialize","kind":13,"line":105},{"line":106,"name":"$self","containerName":"_initialize","kind":13},{"line":106,"name":"@args","containerName":"_initialize","kind":13}],"detail":"($self,@args)","definition":"sub"},{"line":106,"kind":12,"containerName":"_initialize","name":"SUPER"},{"signature":{"documentation":"1;\n# $Id: xml.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::Variation::IO::xml\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::IO::xml - XML sequence variation input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::Variation::IO class.\n\n=head1 DESCRIPTION\n\nThis object can transform L<Bio::Variation::SeqDiff> objects to and from XML\nfile databases.\n\nThe XML format, although consistent, is still evolving. The current\nDTD for it is at L<http://www.ebi.ac.uk/mutations/DTDE/seqDiff.dtd>.\n\n=head1 REQUIREMENTS\n\nTo use this code you need the module L<XML::Twig> which creates an\ninterface to L<XML::Parser> to read XML and modules L<XML::Writer> and\nL<IO::String> to write XML out.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Variation::IO::xml;\n\nuse vars qw($seqdiff $var $prevdnaobj $prevrnaobj $prevaaobj);\nuse strict;\n\nuse XML::Twig;\nuse XML::Writer 0.4;\nuse IO::String;\nuse Bio::Variation::SeqDiff;\nuse Bio::Variation::DNAMutation;\nuse Bio::Variation::RNAChange;\nuse Bio::Variation::AAChange;\nuse Bio::Variation::Allele;\n\nuse base qw(Bio::Variation::IO);\n\n# _initialize is where the heavy stuff will happen when new is called\n\nsub new {\n    my ($class,@args) = @_;\n    my $self = bless {}, $class;\n    $self->_initialize(@args);\n    return $self;\n}\n\nsub _initialize {\n  my($self,@args) = @_;\n  return unless $self->SUPER::_initialize(@args);\n}\n\n=head2 next\n\n Title   : next\n Usage   : $haplo = $stream->next()\n Function: returns the next seqDiff in the stream\n Returns : Bio::Variation::SeqDiff object\n Args    : NONE","parameters":[{"label":"$t"},{"label":"$term"}],"label":"_seqDiff($t,$term)"},"line":120,"kind":12,"range":{"start":{"line":120,"character":0},"end":{"line":129,"character":9999}},"definition":"sub","detail":"($t,$term)","children":[{"line":121,"containerName":"_seqDiff","localvar":"my","kind":13,"name":"$t","definition":"my"},{"line":121,"name":"$term","kind":13,"containerName":"_seqDiff"},{"line":122,"name":"$seqdiff","containerName":"_seqDiff","kind":13},{"containerName":"_seqDiff","kind":12,"name":"id","line":122},{"line":122,"name":"$term","kind":13,"containerName":"_seqDiff"},{"kind":12,"containerName":"_seqDiff","name":"att","line":122},{"kind":13,"containerName":"_seqDiff","name":"$seqdiff","line":123},{"line":123,"containerName":"_seqDiff","kind":12,"name":"alphabet"},{"kind":13,"containerName":"_seqDiff","name":"$term","line":123},{"containerName":"_seqDiff","kind":12,"name":"att","line":123},{"line":124,"kind":13,"containerName":"_seqDiff","name":"$seqdiff"},{"containerName":"_seqDiff","kind":12,"name":"offset","line":124},{"kind":13,"containerName":"_seqDiff","name":"$term","line":124},{"line":124,"containerName":"_seqDiff","kind":12,"name":"att"},{"definition":"my","name":"$child","localvar":"my","containerName":"_seqDiff","kind":13,"line":126},{"line":126,"name":"$term","kind":13,"containerName":"_seqDiff"},{"kind":12,"containerName":"_seqDiff","name":"children","line":126},{"line":127,"kind":13,"containerName":"_seqDiff","name":"$t"},{"line":127,"name":"$child","containerName":"_seqDiff","kind":13}],"containerName":"main::","name":"_seqDiff"},{"kind":12,"name":"_variant","line":127},{"definition":"sub","detail":"($t,$term)","children":[{"definition":"my","line":132,"name":"$t","localvar":"my","containerName":"_variant","kind":13},{"name":"$term","containerName":"_variant","kind":13,"line":132},{"definition":"my","localvar":"my","kind":13,"containerName":"_variant","name":"$var","line":133},{"line":134,"containerName":"_variant","localvar":"my","kind":13,"name":"$att","definition":"my"},{"kind":13,"containerName":"_variant","name":"$term","line":134},{"kind":12,"containerName":"_variant","name":"atts","line":134},{"definition":"my","line":135,"name":"$variation_number","containerName":"_variant","localvar":"my","kind":13},{"name":"$change_number","kind":13,"containerName":"_variant","line":135},{"line":135,"containerName":"_variant","kind":13,"name":"$att"},{"line":138,"kind":13,"containerName":"_variant","name":"$variation_number"},{"line":138,"containerName":"_variant","kind":13,"name":"$change_number"},{"line":138,"kind":13,"containerName":"_variant","name":"$change_number"},{"definition":"my","line":139,"containerName":"_variant","localvar":"my","kind":13,"name":"$a3"},{"name":"new","kind":12,"containerName":"_variant","line":139},{"line":140,"name":"$a3","containerName":"_variant","kind":13},{"name":"seq","containerName":"_variant","kind":12,"line":140},{"line":140,"kind":13,"containerName":"_variant","name":"$term"},{"name":"first_child_text","containerName":"_variant","kind":12,"line":140},{"containerName":"_variant","kind":13,"name":"$term","line":141},{"line":141,"name":"first_child_text","containerName":"_variant","kind":12},{"name":"$term","kind":13,"containerName":"_variant","line":142},{"containerName":"_variant","kind":12,"name":"gi","line":142},{"name":"$prevdnaobj","kind":13,"containerName":"_variant","line":143},{"line":143,"name":"add_Allele","kind":12,"containerName":"_variant"},{"containerName":"_variant","kind":13,"name":"$a3","line":143},{"kind":13,"containerName":"_variant","name":"$term","line":145},{"line":145,"kind":12,"containerName":"_variant","name":"gi"},{"kind":13,"containerName":"_variant","name":"$prevrnaobj","line":146},{"kind":12,"containerName":"_variant","name":"add_Allele","line":146},{"line":146,"name":"$a3","containerName":"_variant","kind":13},{"line":148,"containerName":"_variant","kind":13,"name":"$prevaaobj"},{"line":148,"containerName":"_variant","kind":12,"name":"add_Allele"},{"name":"$a3","kind":13,"containerName":"_variant","line":148},{"line":151,"name":"$term","containerName":"_variant","kind":13},{"line":151,"name":"gi","kind":12,"containerName":"_variant"},{"name":"$var","kind":13,"containerName":"_variant","line":152},{"name":"new","containerName":"_variant","kind":12,"line":152},{"kind":13,"containerName":"_variant","name":"$term","line":154},{"line":154,"containerName":"_variant","kind":12,"name":"gi"},{"line":155,"name":"$var","kind":13,"containerName":"_variant"},{"kind":12,"containerName":"_variant","name":"new","line":155},{"containerName":"_variant","kind":13,"name":"$var","line":157},{"name":"new","kind":12,"containerName":"_variant","line":157},{"name":"$var","kind":13,"containerName":"_variant","line":161},{"line":161,"kind":12,"containerName":"_variant","name":"start"},{"line":161,"name":"$att","containerName":"_variant","kind":13},{"kind":13,"containerName":"_variant","name":"$var","line":162},{"line":162,"containerName":"_variant","kind":12,"name":"end"},{"kind":13,"containerName":"_variant","name":"$att","line":162},{"kind":13,"containerName":"_variant","name":"$var","line":163},{"line":163,"name":"length","kind":12,"containerName":"_variant"},{"line":163,"name":"$att","containerName":"_variant","kind":13},{"containerName":"_variant","kind":13,"name":"$var","line":164},{"line":164,"name":"mut_number","kind":12,"containerName":"_variant"},{"line":164,"containerName":"_variant","kind":13,"name":"$att"},{"name":"$var","containerName":"_variant","kind":13,"line":165},{"line":165,"name":"upStreamSeq","kind":12,"containerName":"_variant"},{"line":165,"containerName":"_variant","kind":13,"name":"$term"},{"line":165,"kind":12,"containerName":"_variant","name":"first_child_text"},{"line":166,"name":"$var","containerName":"_variant","kind":13},{"containerName":"_variant","kind":12,"name":"dnStreamSeq","line":166},{"kind":13,"containerName":"_variant","name":"$term","line":166},{"line":166,"name":"first_child_text","kind":12,"containerName":"_variant"},{"line":167,"name":"$var","kind":13,"containerName":"_variant"},{"line":167,"name":"proof","containerName":"_variant","kind":12},{"line":167,"kind":13,"containerName":"_variant","name":"$term"},{"line":167,"name":"first_child_text","kind":12,"containerName":"_variant"},{"definition":"my","line":170,"name":"$region","containerName":"_variant","localvar":"my","kind":13},{"line":170,"containerName":"_variant","kind":13,"name":"$term"},{"name":"first_child","kind":12,"containerName":"_variant","line":170},{"containerName":"_variant","kind":13,"name":"$region","line":171},{"kind":13,"containerName":"_variant","name":"$var","line":172},{"name":"region","containerName":"_variant","kind":12,"line":172},{"line":172,"name":"$region","kind":13,"containerName":"_variant"},{"line":172,"containerName":"_variant","kind":12,"name":"text"},{"name":"$region_atts","containerName":"_variant","localvar":"my","kind":13,"line":173,"definition":"my"},{"name":"$region","containerName":"_variant","kind":13,"line":173},{"name":"atts","containerName":"_variant","kind":12,"line":173},{"line":174,"containerName":"_variant","kind":13,"name":"$var"},{"kind":12,"containerName":"_variant","name":"region_value","line":174},{"line":174,"name":"$region_atts","containerName":"_variant","kind":13},{"kind":13,"containerName":"_variant","name":"$region_atts","line":175},{"name":"$var","kind":13,"containerName":"_variant","line":176},{"containerName":"_variant","kind":12,"name":"region_dist","line":176},{"name":"$region_atts","kind":13,"containerName":"_variant","line":176},{"name":"$region_atts","kind":13,"containerName":"_variant","line":177},{"line":181,"name":"$a1","kind":13,"localvar":"my","containerName":"_variant","definition":"my"},{"name":"new","containerName":"_variant","kind":12,"line":181},{"name":"$a1","containerName":"_variant","kind":13,"line":182},{"line":182,"name":"seq","kind":12,"containerName":"_variant"},{"line":182,"name":"$term","containerName":"_variant","kind":13},{"line":182,"kind":12,"containerName":"_variant","name":"first_child_text"},{"line":183,"name":"$term","kind":13,"containerName":"_variant"},{"line":183,"name":"first_child_text","kind":12,"containerName":"_variant"},{"containerName":"_variant","kind":13,"name":"$var","line":184},{"line":184,"name":"allele_ori","kind":12,"containerName":"_variant"},{"containerName":"_variant","kind":13,"name":"$a1","line":184},{"definition":"my","line":185,"name":"$a2","kind":13,"localvar":"my","containerName":"_variant"},{"line":185,"name":"new","containerName":"_variant","kind":12},{"line":186,"containerName":"_variant","kind":13,"name":"$a2"},{"line":186,"name":"seq","kind":12,"containerName":"_variant"},{"name":"$term","kind":13,"containerName":"_variant","line":186},{"line":186,"name":"first_child_text","kind":12,"containerName":"_variant"},{"line":187,"containerName":"_variant","kind":13,"name":"$term"},{"line":187,"kind":12,"containerName":"_variant","name":"first_child_text"},{"line":188,"containerName":"_variant","kind":13,"name":"$var"},{"kind":12,"containerName":"_variant","name":"isMutation","line":188},{"line":188,"kind":13,"containerName":"_variant","name":"$term"},{"line":188,"name":"att","kind":12,"containerName":"_variant"},{"name":"$var","containerName":"_variant","kind":13,"line":189},{"containerName":"_variant","kind":12,"name":"allele_mut","line":189},{"line":189,"kind":13,"containerName":"_variant","name":"$a2"},{"line":190,"containerName":"_variant","kind":13,"name":"$var"},{"containerName":"_variant","kind":12,"name":"add_Allele","line":190},{"line":190,"kind":13,"containerName":"_variant","name":"$a2"},{"containerName":"_variant","kind":13,"name":"$var","line":191},{"kind":12,"containerName":"_variant","name":"length","line":191},{"line":191,"name":"$term","containerName":"_variant","kind":13},{"name":"att","containerName":"_variant","kind":12,"line":191},{"line":192,"name":"$seqdiff","kind":13,"containerName":"_variant"},{"line":192,"name":"add_Variant","kind":12,"containerName":"_variant"},{"line":192,"kind":13,"containerName":"_variant","name":"$var"},{"name":"$term","containerName":"_variant","kind":13,"line":195},{"line":195,"name":"gi","kind":12,"containerName":"_variant"},{"kind":13,"containerName":"_variant","name":"$prevdnaobj","line":196},{"line":196,"containerName":"_variant","kind":13,"name":"$var"},{"line":198,"name":"$term","kind":13,"containerName":"_variant"},{"line":198,"name":"gi","containerName":"_variant","kind":12},{"definition":"my","name":"$codon","localvar":"my","kind":13,"containerName":"_variant","line":199},{"name":"$term","kind":13,"containerName":"_variant","line":199},{"name":"first_child","containerName":"_variant","kind":12,"line":199},{"line":200,"kind":13,"containerName":"_variant","name":"$codon"},{"name":"$codon_atts","localvar":"my","containerName":"_variant","kind":13,"line":201,"definition":"my"},{"line":201,"name":"$codon","kind":13,"containerName":"_variant"},{"containerName":"_variant","kind":12,"name":"atts","line":201},{"name":"$var","containerName":"_variant","kind":13,"line":202},{"line":202,"containerName":"_variant","kind":12,"name":"codon_table"},{"line":202,"name":"$codon","kind":13,"containerName":"_variant"},{"line":202,"name":"att","containerName":"_variant","kind":12},{"line":203,"name":"$codon_atts","kind":13,"containerName":"_variant"},{"kind":13,"containerName":"_variant","name":"$codon_atts","line":203},{"containerName":"_variant","kind":13,"name":"$var","line":204},{"line":204,"name":"codon_pos","kind":12,"containerName":"_variant"},{"line":204,"name":"$codon","kind":13,"containerName":"_variant"},{"name":"att","kind":12,"containerName":"_variant","line":204},{"kind":13,"containerName":"_variant","name":"$codon_atts","line":205},{"containerName":"_variant","kind":13,"name":"$prevdnaobj","line":207},{"line":207,"name":"RNAChange","containerName":"_variant","kind":12},{"line":207,"containerName":"_variant","kind":13,"name":"$var"},{"kind":13,"containerName":"_variant","name":"$var","line":208},{"containerName":"_variant","kind":12,"name":"DNAMutation","line":208},{"line":208,"kind":13,"containerName":"_variant","name":"$prevdnaobj"},{"line":209,"kind":13,"containerName":"_variant","name":"$prevrnaobj"},{"name":"$var","kind":13,"containerName":"_variant","line":209},{"name":"$prevrnaobj","containerName":"_variant","kind":13,"line":211},{"kind":12,"containerName":"_variant","name":"AAChange","line":211},{"line":211,"containerName":"_variant","kind":13,"name":"$var"},{"name":"$var","kind":13,"containerName":"_variant","line":212},{"kind":12,"containerName":"_variant","name":"RNAChange","line":212},{"line":212,"kind":13,"containerName":"_variant","name":"$prevrnaobj"},{"containerName":"_variant","kind":13,"name":"$prevaaobj","line":213},{"line":213,"containerName":"_variant","kind":13,"name":"$var"}],"name":"_variant","containerName":"main::","signature":{"parameters":[{"label":"$t"},{"label":"$term"}],"documentation":"","label":"_variant($t,$term)"},"line":131,"range":{"start":{"character":0,"line":131},"end":{"character":9999,"line":216}},"kind":12},{"kind":12,"name":"number","line":135},{"containerName":"Variation::Allele","kind":12,"name":"Bio","line":139},{"kind":12,"containerName":"Variation::DNAMutation","name":"Bio","line":152},{"line":155,"name":"Bio","kind":12,"containerName":"Variation::RNAChange"},{"containerName":"Variation::AAChange","kind":12,"name":"Bio","line":157},{"line":161,"kind":12,"name":"start"},{"kind":12,"name":"end","line":162},{"kind":12,"name":"len","line":163},{"line":164,"name":"number","kind":12},{"line":174,"name":"value","kind":12},{"kind":12,"name":"value","line":175},{"line":176,"name":"dist","kind":12},{"kind":12,"name":"dist","line":177},{"name":"Bio","containerName":"Variation::Allele","kind":12,"line":181},{"name":"Bio","kind":12,"containerName":"Variation::Allele","line":185},{"name":"codon_table","kind":12,"line":203},{"line":203,"name":"codon_table","kind":12},{"line":205,"kind":12,"name":"codon_pos"},{"containerName":"main::","name":"next","children":[{"line":219,"name":"$self","localvar":"my","kind":13,"containerName":"next","definition":"my"},{"line":222,"name":"$entry","localvar":"my","kind":13,"containerName":"next","definition":"my"},{"line":222,"containerName":"next","kind":13,"name":"$self"},{"line":222,"kind":12,"containerName":"next","name":"_readline"},{"line":224,"name":"$entry","containerName":"next","kind":13},{"containerName":"next","kind":13,"name":"$seqdiff","line":226},{"name":"new","containerName":"next","kind":12,"line":226},{"definition":"my","name":"$twig_handlers","localvar":"my","kind":13,"containerName":"next","line":229},{"containerName":"next","localvar":"my","kind":13,"name":"$t","line":230,"definition":"my"},{"line":230,"name":"$twig_handlers","kind":13,"containerName":"next"},{"line":232,"containerName":"next","kind":13,"name":"$t"},{"kind":12,"containerName":"next","name":"parse","line":232},{"line":232,"name":"$entry","kind":13,"containerName":"next"},{"line":234,"name":"$seqdiff","containerName":"next","kind":13}],"detail":"($self)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":218},"end":{"line":235,"character":9999}},"line":218,"signature":{"label":"next($self)","documentation":"","parameters":[{"label":"$self"}]}},{"line":226,"kind":12,"containerName":"Variation::SeqDiff","name":"Bio"},{"kind":12,"containerName":"Twig","name":"XML","line":230},{"line":230,"kind":12,"name":"TwigHandlers"},{"kind":12,"name":"KeepEncoding","line":231},{"signature":{"label":"write($self,@h)","parameters":[{"label":"$self"},{"label":"@h"}],"documentation":"1;\n# $Id: xml.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::Variation::IO::xml\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::IO::xml - XML sequence variation input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::Variation::IO class.\n\n=head1 DESCRIPTION\n\nThis object can transform L<Bio::Variation::SeqDiff> objects to and from XML\nfile databases.\n\nThe XML format, although consistent, is still evolving. The current\nDTD for it is at L<http://www.ebi.ac.uk/mutations/DTDE/seqDiff.dtd>.\n\n=head1 REQUIREMENTS\n\nTo use this code you need the module L<XML::Twig> which creates an\ninterface to L<XML::Parser> to read XML and modules L<XML::Writer> and\nL<IO::String> to write XML out.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Variation::IO::xml;\n\nuse vars qw($seqdiff $var $prevdnaobj $prevrnaobj $prevaaobj);\nuse strict;\n\nuse XML::Twig;\nuse XML::Writer 0.4;\nuse IO::String;\nuse Bio::Variation::SeqDiff;\nuse Bio::Variation::DNAMutation;\nuse Bio::Variation::RNAChange;\nuse Bio::Variation::AAChange;\nuse Bio::Variation::Allele;\n\nuse base qw(Bio::Variation::IO);\n\n# _initialize is where the heavy stuff will happen when new is called\n\nsub new {\n    my ($class,@args) = @_;\n    my $self = bless {}, $class;\n    $self->_initialize(@args);\n    return $self;\n}\n\nsub _initialize {\n  my($self,@args) = @_;\n  return unless $self->SUPER::_initialize(@args);\n}\n\n=head2 next\n\n Title   : next\n Usage   : $haplo = $stream->next()\n Function: returns the next seqDiff in the stream\n Returns : Bio::Variation::SeqDiff object\n Args    : NONE\n\n\n\nsub _seqDiff {\n    my ($t, $term)= @_;\n    $seqdiff->id( $term->att('id') );\n    $seqdiff->alphabet( $term->att('moltype') );\n    $seqdiff->offset( $term->att('offset') );\n\n    foreach my $child ($term->children) {\n\t _variant($t, $child);\n    }\n}\n\nsub _variant {\n    my ($t, $term)= @_;\n    my $var;\n    my $att = $term->atts();\n    my ($variation_number, $change_number) = split /\\./,  $att->{number}; \n    \n    # if more than two alleles\n    if ($variation_number and $change_number and $change_number > 1 ) {\n\tmy $a3 = Bio::Variation::Allele->new;\n\t$a3->seq( $term->first_child_text('allele_mut') ) \n\t    if $term->first_child_text('allele_mut');\n\tif ($term->gi eq 'DNA') {\n\t    $prevdnaobj->add_Allele($a3);\n\t}\n\telsif ($term->gi eq 'RNA') {\n\t    $prevrnaobj->add_Allele($a3);\n\t} else { # AA\n\t    $prevaaobj->add_Allele($a3);\n\t}\n    } else { # create new variants\n\tif ($term->gi eq 'DNA') {\n\t    $var = Bio::Variation::DNAMutation->new();\n\t}\n\telsif ($term->gi eq 'RNA') {\n\t    $var = Bio::Variation::RNAChange->new();\n\t} else { # AA\n\t    $var = Bio::Variation::AAChange->new();\n\t}\n\n\t# these are always present\n\t$var->start( $att->{start} );\n\t$var->end( $att->{end});\n\t$var->length($att->{len});\n\t$var->mut_number( $att->{number});\n\t$var->upStreamSeq($term->first_child_text('upFlank'));\n\t$var->dnStreamSeq($term->first_child_text('dnFlank'));\n\t$var->proof($term->first_child_text('proof'));\n\n\t# region\n\tmy $region = $term->first_child('region');\n\tif ($region) {\n\t    $var->region($region->text);\n\t    my $region_atts = $region->atts;\n\t    $var->region_value( $region_atts->{value} ) \n\t\tif $region_atts->{value};\n\t    $var->region_dist( $region_atts->{dist} ) \n\t\tif $region_atts->{dist};\n\t}\n\t\n\t# alleles\n\tmy $a1 = Bio::Variation::Allele->new;\n\t$a1->seq($term->first_child_text('allele_ori') ) \n\t    if $term->first_child_text('allele_ori');\n\t$var->allele_ori($a1);\n\tmy $a2 = Bio::Variation::Allele->new;\n\t$a2->seq($term->first_child_text('allele_mut') ) \n\t    if $term->first_child_text('allele_mut');\n\t$var->isMutation(1) if $term->att('isMutation');\n\t$var->allele_mut($a2);\t\n\t$var->add_Allele($a2);\n\t$var->length( $term->att('length') );\n\t$seqdiff->add_Variant($var);\n\n\t# variant specific code\n\tif ($term->gi eq 'DNA') {\n\t    $prevdnaobj = $var;\n\t}\n\telsif ($term->gi eq 'RNA') {\n\t    my $codon = $term->first_child('codon');\n\t    if ($codon) {\n\t\tmy $codon_atts = $codon->atts;\n\t\t$var->codon_table( $codon->att('codon_table') ) \n\t\t    if $codon_atts->{codon_table} and $codon_atts->{codon_table} != 1;\n\t\t$var->codon_pos( $codon->att('codon_pos') ) \n\t\t    if $codon_atts->{codon_pos};\n\t    }\n\t    $prevdnaobj->RNAChange($var);\n\t    $var->DNAMutation($prevdnaobj);\n\t    $prevrnaobj = $var;\n\t} else {\n\t    $prevrnaobj->AAChange($var);\n\t    $var->RNAChange($prevrnaobj);\n\t    $prevaaobj = $var;\n\t}\n    }\n}\n\nsub next {\n    my( $self ) = @_;\n\n    local $/ = \"</seqDiff>\\n\";\n    return unless my $entry = $self->_readline;\n#    print  STDERR \"|$entry|\";\n    return unless $entry =~ /^\\W*<seqDiff/;\n\n    $seqdiff = Bio::Variation::SeqDiff->new;\n\n    # create new parser object\n    my $twig_handlers = {'seqDiff' =>  \\&_seqDiff };\n    my $t = new XML::Twig ( TwigHandlers => $twig_handlers,\n\t\t\t    KeepEncoding => 1 );\n    $t->parse($entry);\n\n    return $seqdiff;\n}\n\n=head2 write\n\n Title   : write\n Usage   : $stream->write(@haplos)\n Function: writes the $seqDiff objects into the stream\n Returns : 1 for success and 0 for error\n Args    : Bio::Variation::SeqDiff object"},"line":247,"kind":12,"range":{"end":{"character":9999,"line":556},"start":{"character":0,"line":247}},"definition":"sub","detail":"($self,@h)","children":[{"line":248,"localvar":"my","kind":13,"containerName":"write","name":"$self","definition":"my"},{"kind":13,"containerName":"write","name":"@h","line":248},{"kind":13,"containerName":"write","name":"$h","line":250},{"name":"$self","kind":13,"containerName":"write","line":251},{"line":251,"containerName":"write","kind":12,"name":"throw"},{"definition":"my","line":253,"name":"$str","localvar":"my","containerName":"write","kind":13},{"name":"$output","containerName":"write","localvar":"my","kind":13,"line":254,"definition":"my"},{"containerName":"write","kind":12,"name":"new","line":254},{"kind":13,"containerName":"write","name":"$str","line":254},{"line":255,"kind":13,"localvar":"my","containerName":"write","name":"$w","definition":"my"},{"line":255,"kind":13,"containerName":"write","name":"$output"},{"definition":"my","line":257,"localvar":"my","kind":13,"containerName":"write","name":"$h"},{"line":257,"containerName":"write","kind":13,"name":"@h"},{"containerName":"write","kind":13,"name":"$h","line":261},{"kind":12,"containerName":"write","name":"alphabet","line":261},{"line":261,"name":"$self","kind":13,"containerName":"write"},{"name":"throw","kind":12,"containerName":"write","line":261},{"definition":"my","line":262,"name":"$hasAA","localvar":"my","containerName":"write","kind":13},{"definition":"my","localvar":"my","kind":13,"containerName":"write","name":"$mut","line":263},{"line":263,"kind":13,"containerName":"write","name":"$h"},{"line":263,"name":"each_Variant","kind":12,"containerName":"write"},{"line":264,"containerName":"write","kind":13,"name":"$hasAA"},{"name":"$mut","containerName":"write","kind":13,"line":264},{"name":"isa","containerName":"write","kind":12,"line":264},{"line":266,"kind":13,"containerName":"write","name":"$hasAA"},{"containerName":"write","kind":13,"name":"$w","line":267},{"line":267,"name":"startTag","containerName":"write","kind":12},{"containerName":"write","kind":13,"name":"$h","line":268},{"line":268,"name":"id","containerName":"write","kind":12},{"name":"$h","containerName":"write","kind":13,"line":269},{"containerName":"write","kind":12,"name":"alphabet","line":269},{"line":270,"kind":13,"containerName":"write","name":"$h"},{"line":270,"name":"offset","containerName":"write","kind":12},{"line":271,"containerName":"write","kind":13,"name":"$h"},{"containerName":"write","kind":12,"name":"sysname","line":271},{"line":272,"kind":13,"containerName":"write","name":"$h"},{"line":273,"name":"trivname","kind":12,"containerName":"write"},{"name":"$w","kind":13,"containerName":"write","line":275},{"name":"startTag","kind":12,"containerName":"write","line":275},{"line":276,"name":"$h","containerName":"write","kind":13},{"name":"id","containerName":"write","kind":12,"line":276},{"line":277,"name":"$h","containerName":"write","kind":13},{"name":"alphabet","kind":12,"containerName":"write","line":277},{"name":"$h","containerName":"write","kind":13,"line":278},{"line":278,"containerName":"write","kind":12,"name":"offset"},{"line":279,"name":"$h","kind":13,"containerName":"write"},{"kind":12,"containerName":"write","name":"sysname","line":280},{"line":282,"name":"@allvariants","containerName":"write","localvar":"my","kind":13,"definition":"my"},{"containerName":"write","kind":13,"name":"$h","line":282},{"line":282,"name":"each_Variant","kind":12,"containerName":"write"},{"definition":"my","line":284,"localvar":"my","containerName":"write","kind":13,"name":"%variants"},{"definition":"my","kind":13,"localvar":"my","containerName":"write","name":"$mut","line":285},{"containerName":"write","kind":13,"name":"$h","line":285},{"name":"each_Variant","containerName":"write","kind":12,"line":285},{"line":288,"name":"$variants","containerName":"write","kind":13},{"line":288,"name":"$mut","kind":13,"containerName":"write"},{"name":"mut_number","kind":12,"containerName":"write","line":288},{"containerName":"write","kind":13,"name":"$mut","line":288},{"definition":"my","line":290,"localvar":"my","containerName":"write","kind":13,"name":"$var"},{"line":290,"containerName":"write","kind":13,"name":"%variants"},{"definition":"my","name":"$mut","kind":13,"localvar":"my","containerName":"write","line":291},{"name":"$variants","containerName":"write","kind":13,"line":291},{"name":"$var","kind":13,"containerName":"write","line":291},{"name":"$mut","kind":13,"containerName":"write","line":295},{"line":295,"kind":12,"containerName":"write","name":"isa"},{"kind":13,"containerName":"write","name":"$mut","line":296},{"kind":12,"containerName":"write","name":"isMutation","line":296},{"kind":13,"containerName":"write","name":"$mut","line":296},{"name":"isMutation","containerName":"write","kind":12,"line":296},{"line":297,"localvar":"my","containerName":"write","kind":13,"name":"@alleles","definition":"my"},{"line":297,"kind":13,"containerName":"write","name":"$mut"},{"line":297,"kind":12,"containerName":"write","name":"each_Allele"},{"line":298,"localvar":"my","kind":13,"containerName":"write","name":"$count","definition":"my"},{"definition":"my","line":299,"containerName":"write","localvar":"my","kind":13,"name":"$allele"},{"name":"@alleles","containerName":"write","kind":13,"line":299},{"name":"$count","kind":13,"containerName":"write","line":300},{"definition":"my","name":"$variation_number","localvar":"my","kind":13,"containerName":"write","line":301},{"line":301,"name":"$change_number","containerName":"write","kind":13},{"line":301,"name":"$mut","containerName":"write","kind":13},{"line":301,"name":"mut_number","kind":12,"containerName":"write"},{"name":"$change_number","containerName":"write","kind":13,"line":302},{"line":302,"name":"$change_number","containerName":"write","kind":13},{"line":302,"containerName":"write","kind":13,"name":"$count"},{"line":303,"containerName":"write","kind":13,"name":"$mut"},{"containerName":"write","kind":12,"name":"mut_number","line":303},{"line":305,"containerName":"write","kind":13,"name":"$mut"},{"line":305,"name":"allele_mut","kind":12,"containerName":"write"},{"name":"$allele","containerName":"write","kind":13,"line":305},{"line":306,"name":"$w","containerName":"write","kind":13},{"name":"startTag","containerName":"write","kind":12,"line":306},{"line":307,"kind":13,"containerName":"write","name":"$mut"},{"kind":12,"containerName":"write","name":"mut_number","line":307},{"line":308,"kind":13,"containerName":"write","name":"$mut"},{"line":308,"kind":12,"containerName":"write","name":"start"},{"name":"$mut","containerName":"write","kind":13,"line":309},{"line":309,"containerName":"write","kind":12,"name":"end"},{"containerName":"write","kind":13,"name":"$mut","line":310},{"name":"length","kind":12,"containerName":"write","line":310},{"line":311,"containerName":"write","kind":13,"name":"$mut"},{"line":312,"containerName":"write","kind":12,"name":"isMutation"},{"kind":13,"containerName":"write","name":"$mut","line":313},{"line":313,"kind":12,"containerName":"write","name":"label"},{"line":314,"containerName":"write","localvar":"my","kind":13,"name":"$label","definition":"my"},{"line":314,"containerName":"write","kind":13,"name":"$mut"},{"kind":12,"containerName":"write","name":"label","line":314},{"line":315,"containerName":"write","kind":13,"name":"$w"},{"name":"startTag","containerName":"write","kind":12,"line":315},{"name":"$w","kind":13,"containerName":"write","line":316},{"kind":12,"containerName":"write","name":"characters","line":316},{"name":"$label","containerName":"write","kind":13,"line":316},{"name":"$w","containerName":"write","kind":13,"line":317},{"line":317,"containerName":"write","kind":12,"name":"endTag"},{"line":320,"kind":13,"containerName":"write","name":"$mut"},{"name":"proof","kind":12,"containerName":"write","line":320},{"name":"$w","containerName":"write","kind":13,"line":321},{"line":321,"containerName":"write","kind":12,"name":"startTag"},{"line":322,"name":"$w","containerName":"write","kind":13},{"line":322,"name":"characters","containerName":"write","kind":12},{"name":"$mut","kind":13,"containerName":"write","line":322},{"kind":12,"containerName":"write","name":"proof","line":322},{"containerName":"write","kind":13,"name":"$w","line":323},{"kind":12,"containerName":"write","name":"endTag","line":323},{"line":325,"kind":13,"containerName":"write","name":"$mut"},{"line":325,"name":"upStreamSeq","kind":12,"containerName":"write"},{"line":326,"kind":13,"containerName":"write","name":"$w"},{"kind":12,"containerName":"write","name":"startTag","line":326},{"kind":13,"containerName":"write","name":"$w","line":327},{"name":"characters","containerName":"write","kind":12,"line":327},{"name":"$mut","containerName":"write","kind":13,"line":327},{"line":327,"containerName":"write","kind":12,"name":"upStreamSeq"},{"name":"$w","kind":13,"containerName":"write","line":328},{"name":"endTag","kind":12,"containerName":"write","line":328},{"line":332,"name":"$w","kind":13,"containerName":"write"},{"containerName":"write","kind":12,"name":"startTag","line":332},{"line":333,"containerName":"write","kind":13,"name":"$w"},{"line":333,"kind":12,"containerName":"write","name":"characters"},{"line":333,"containerName":"write","kind":13,"name":"$mut"},{"kind":12,"containerName":"write","name":"allele_ori","line":333},{"line":333,"name":"seq","kind":12,"containerName":"write"},{"line":333,"containerName":"write","kind":13,"name":"$mut"},{"line":333,"containerName":"write","kind":12,"name":"allele_ori"},{"line":333,"name":"seq","containerName":"write","kind":12},{"kind":13,"containerName":"write","name":"$w","line":334},{"line":334,"containerName":"write","kind":12,"name":"endTag"},{"line":337,"name":"$w","containerName":"write","kind":13},{"name":"startTag","containerName":"write","kind":12,"line":337},{"line":338,"name":"$w","containerName":"write","kind":13},{"line":338,"containerName":"write","kind":12,"name":"characters"},{"containerName":"write","kind":13,"name":"$mut","line":338},{"line":338,"kind":12,"containerName":"write","name":"allele_mut"},{"name":"seq","containerName":"write","kind":12,"line":338},{"line":338,"name":"$mut","containerName":"write","kind":13},{"name":"allele_mut","containerName":"write","kind":12,"line":338},{"name":"seq","kind":12,"containerName":"write","line":338},{"kind":13,"containerName":"write","name":"$w","line":339},{"kind":12,"containerName":"write","name":"endTag","line":339},{"name":"$mut","kind":13,"containerName":"write","line":342},{"containerName":"write","kind":12,"name":"dnStreamSeq","line":342},{"name":"$w","containerName":"write","kind":13,"line":343},{"line":343,"name":"startTag","containerName":"write","kind":12},{"line":344,"name":"$w","kind":13,"containerName":"write"},{"line":344,"containerName":"write","kind":12,"name":"characters"},{"containerName":"write","kind":13,"name":"$mut","line":344},{"kind":12,"containerName":"write","name":"dnStreamSeq","line":344},{"line":345,"kind":13,"containerName":"write","name":"$w"},{"line":345,"containerName":"write","kind":12,"name":"endTag"},{"line":347,"kind":13,"containerName":"write","name":"$mut"},{"line":347,"name":"restriction_changes","containerName":"write","kind":12},{"kind":13,"containerName":"write","name":"$w","line":348},{"line":348,"containerName":"write","kind":12,"name":"startTag"},{"name":"$w","containerName":"write","kind":13,"line":349},{"line":349,"kind":12,"containerName":"write","name":"characters"},{"line":349,"kind":13,"containerName":"write","name":"$mut"},{"line":349,"name":"restriction_changes","containerName":"write","kind":12},{"line":350,"containerName":"write","kind":13,"name":"$w"},{"containerName":"write","kind":12,"name":"endTag","line":350},{"kind":13,"containerName":"write","name":"$mut","line":352},{"line":352,"name":"region","kind":12,"containerName":"write"},{"line":353,"containerName":"write","kind":13,"name":"$mut"},{"containerName":"write","kind":12,"name":"region_value","line":353},{"containerName":"write","kind":13,"name":"$mut","line":353},{"containerName":"write","kind":12,"name":"region_dist","line":353},{"line":354,"kind":13,"containerName":"write","name":"$w"},{"line":354,"kind":12,"containerName":"write","name":"startTag"},{"name":"$mut","containerName":"write","kind":13,"line":355},{"line":355,"kind":12,"containerName":"write","name":"region_value"},{"kind":13,"containerName":"write","name":"$mut","line":356},{"kind":12,"containerName":"write","name":"region_dist","line":357},{"name":"$mut","kind":13,"containerName":"write","line":359},{"name":"region_value","kind":12,"containerName":"write","line":359},{"line":360,"name":"$w","kind":13,"containerName":"write"},{"line":360,"name":"startTag","containerName":"write","kind":12},{"line":361,"containerName":"write","kind":13,"name":"$mut"},{"name":"region_value","containerName":"write","kind":12,"line":362},{"kind":13,"containerName":"write","name":"$mut","line":364},{"line":364,"name":"region_dist","kind":12,"containerName":"write"},{"line":365,"kind":13,"containerName":"write","name":"$w"},{"name":"startTag","containerName":"write","kind":12,"line":365},{"name":"$mut","containerName":"write","kind":13,"line":366},{"kind":12,"containerName":"write","name":"region_dist","line":367},{"line":369,"containerName":"write","kind":13,"name":"$w"},{"line":369,"kind":12,"containerName":"write","name":"startTag"},{"line":371,"name":"$w","kind":13,"containerName":"write"},{"name":"characters","containerName":"write","kind":12,"line":371},{"line":371,"containerName":"write","kind":13,"name":"$mut"},{"line":371,"name":"region","containerName":"write","kind":12},{"line":372,"kind":13,"containerName":"write","name":"$w"},{"containerName":"write","kind":12,"name":"endTag","line":372},{"containerName":"write","kind":13,"name":"$w","line":374},{"line":374,"containerName":"write","kind":12,"name":"endTag"},{"name":"$mut","containerName":"write","kind":13,"line":380},{"containerName":"write","kind":12,"name":"isa","line":380},{"line":381,"name":"$mut","containerName":"write","kind":13},{"line":381,"kind":12,"containerName":"write","name":"isMutation"},{"line":381,"containerName":"write","kind":13,"name":"$mut"},{"name":"isMutation","containerName":"write","kind":12,"line":381},{"line":382,"containerName":"write","localvar":"my","kind":13,"name":"@alleles","definition":"my"},{"name":"$mut","kind":13,"containerName":"write","line":382},{"line":382,"kind":12,"containerName":"write","name":"each_Allele"},{"definition":"my","line":383,"localvar":"my","kind":13,"containerName":"write","name":"$count"},{"definition":"my","line":384,"name":"$allele","localvar":"my","containerName":"write","kind":13},{"line":384,"name":"@alleles","kind":13,"containerName":"write"},{"containerName":"write","kind":13,"name":"$count","line":385},{"definition":"my","name":"$variation_number","containerName":"write","localvar":"my","kind":13,"line":386},{"kind":13,"containerName":"write","name":"$change_number","line":386},{"containerName":"write","kind":13,"name":"$mut","line":386},{"kind":12,"containerName":"write","name":"mut_number","line":386},{"line":387,"containerName":"write","kind":13,"name":"$change_number"},{"line":387,"name":"$change_number","kind":13,"containerName":"write"},{"line":387,"name":"$count","containerName":"write","kind":13},{"line":388,"containerName":"write","kind":13,"name":"$mut"},{"name":"mut_number","kind":12,"containerName":"write","line":388},{"line":390,"name":"$mut","kind":13,"containerName":"write"},{"line":390,"name":"allele_mut","containerName":"write","kind":12},{"line":390,"name":"$allele","containerName":"write","kind":13},{"containerName":"write","kind":13,"name":"$w","line":391},{"kind":12,"containerName":"write","name":"startTag","line":391},{"line":392,"name":"$mut","kind":13,"containerName":"write"},{"name":"mut_number","containerName":"write","kind":12,"line":392},{"containerName":"write","kind":13,"name":"$mut","line":393},{"name":"start","containerName":"write","kind":12,"line":393},{"name":"$mut","containerName":"write","kind":13,"line":394},{"line":394,"kind":12,"containerName":"write","name":"end"},{"line":395,"name":"$mut","kind":13,"containerName":"write"},{"line":395,"name":"length","containerName":"write","kind":12},{"name":"$mut","kind":13,"containerName":"write","line":396},{"line":397,"name":"isMutation","kind":12,"containerName":"write"},{"kind":13,"containerName":"write","name":"$mut","line":399},{"kind":12,"containerName":"write","name":"label","line":399},{"name":"$label","kind":13,"localvar":"my","containerName":"write","line":400,"definition":"my"},{"line":400,"name":"$mut","containerName":"write","kind":13},{"line":400,"containerName":"write","kind":12,"name":"label"},{"name":"$w","containerName":"write","kind":13,"line":401},{"line":401,"kind":12,"containerName":"write","name":"startTag"},{"line":402,"kind":13,"containerName":"write","name":"$w"},{"kind":12,"containerName":"write","name":"characters","line":402},{"line":402,"containerName":"write","kind":13,"name":"$label"},{"line":403,"name":"$w","containerName":"write","kind":13},{"kind":12,"containerName":"write","name":"endTag","line":403},{"line":406,"containerName":"write","kind":13,"name":"$mut"},{"line":406,"name":"proof","kind":12,"containerName":"write"},{"name":"$w","kind":13,"containerName":"write","line":407},{"line":407,"name":"startTag","containerName":"write","kind":12},{"line":408,"containerName":"write","kind":13,"name":"$w"},{"name":"characters","containerName":"write","kind":12,"line":408},{"line":408,"name":"$mut","kind":13,"containerName":"write"},{"line":408,"name":"proof","containerName":"write","kind":12},{"name":"$w","containerName":"write","kind":13,"line":409},{"name":"endTag","containerName":"write","kind":12,"line":409},{"name":"$mut","containerName":"write","kind":13,"line":411},{"line":411,"name":"upStreamSeq","containerName":"write","kind":12},{"line":412,"name":"$w","containerName":"write","kind":13},{"kind":12,"containerName":"write","name":"startTag","line":412},{"line":413,"name":"$w","containerName":"write","kind":13},{"containerName":"write","kind":12,"name":"characters","line":413},{"line":413,"containerName":"write","kind":13,"name":"$mut"},{"line":413,"kind":12,"containerName":"write","name":"upStreamSeq"},{"kind":13,"containerName":"write","name":"$w","line":414},{"line":414,"kind":12,"containerName":"write","name":"endTag"},{"kind":13,"containerName":"write","name":"$mut","line":417},{"containerName":"write","kind":12,"name":"allele_ori","line":417},{"name":"$w","containerName":"write","kind":13,"line":418},{"line":418,"containerName":"write","kind":12,"name":"startTag"},{"line":419,"name":"$w","kind":13,"containerName":"write"},{"line":419,"name":"characters","containerName":"write","kind":12},{"line":419,"name":"$mut","containerName":"write","kind":13},{"line":419,"kind":12,"containerName":"write","name":"allele_ori"},{"kind":12,"containerName":"write","name":"seq","line":419},{"name":"$mut","containerName":"write","kind":13,"line":419},{"name":"allele_ori","kind":12,"containerName":"write","line":419},{"line":419,"containerName":"write","kind":12,"name":"seq"},{"name":"$w","kind":13,"containerName":"write","line":420},{"containerName":"write","kind":12,"name":"endTag","line":420},{"name":"$mut","containerName":"write","kind":13,"line":422},{"line":422,"name":"allele_mut","kind":12,"containerName":"write"},{"line":423,"kind":13,"containerName":"write","name":"$w"},{"line":423,"containerName":"write","kind":12,"name":"startTag"},{"line":424,"containerName":"write","kind":13,"name":"$w"},{"line":424,"containerName":"write","kind":12,"name":"characters"},{"name":"$mut","kind":13,"containerName":"write","line":424},{"name":"allele_mut","kind":12,"containerName":"write","line":424},{"name":"seq","containerName":"write","kind":12,"line":424},{"line":424,"containerName":"write","kind":13,"name":"$mut"},{"line":424,"containerName":"write","kind":12,"name":"allele_mut"},{"name":"seq","containerName":"write","kind":12,"line":424},{"line":425,"kind":13,"containerName":"write","name":"$w"},{"line":425,"kind":12,"containerName":"write","name":"endTag"},{"line":428,"containerName":"write","kind":13,"name":"$mut"},{"line":428,"kind":12,"containerName":"write","name":"dnStreamSeq"},{"kind":13,"containerName":"write","name":"$w","line":429},{"line":429,"name":"startTag","kind":12,"containerName":"write"},{"name":"$w","kind":13,"containerName":"write","line":430},{"line":430,"name":"characters","kind":12,"containerName":"write"},{"name":"$mut","kind":13,"containerName":"write","line":430},{"line":430,"containerName":"write","kind":12,"name":"dnStreamSeq"},{"line":431,"containerName":"write","kind":13,"name":"$w"},{"containerName":"write","kind":12,"name":"endTag","line":431},{"kind":13,"containerName":"write","name":"$mut","line":433},{"kind":12,"containerName":"write","name":"region","line":433},{"name":"$mut","kind":13,"containerName":"write","line":434},{"line":434,"name":"codon_mut","containerName":"write","kind":12},{"name":"$w","containerName":"write","kind":13,"line":435},{"name":"startTag","kind":12,"containerName":"write","line":435},{"line":436,"containerName":"write","kind":13,"name":"$mut"},{"name":"codon_ori","kind":12,"containerName":"write","line":436},{"name":"$mut","kind":13,"containerName":"write","line":437},{"line":438,"name":"codon_pos","containerName":"write","kind":12},{"line":440,"name":"$w","containerName":"write","kind":13},{"name":"startTag","containerName":"write","kind":12,"line":440},{"line":441,"kind":13,"containerName":"write","name":"$mut"},{"containerName":"write","kind":12,"name":"codon_ori","line":441},{"line":442,"name":"$mut","containerName":"write","kind":13},{"line":442,"containerName":"write","kind":12,"name":"codon_mut"},{"line":443,"name":"$mut","containerName":"write","kind":13},{"line":444,"name":"codon_pos","containerName":"write","kind":12},{"line":446,"containerName":"write","kind":13,"name":"$w"},{"kind":12,"containerName":"write","name":"endTag","line":446},{"name":"$mut","containerName":"write","kind":13,"line":448},{"containerName":"write","kind":12,"name":"codon_table","line":448},{"line":449,"containerName":"write","kind":13,"name":"$w"},{"kind":12,"containerName":"write","name":"startTag","line":449},{"line":450,"name":"$w","kind":13,"containerName":"write"},{"line":450,"name":"characters","kind":12,"containerName":"write"},{"name":"$mut","kind":13,"containerName":"write","line":450},{"name":"codon_table","containerName":"write","kind":12,"line":450},{"line":451,"name":"$w","containerName":"write","kind":13},{"containerName":"write","kind":12,"name":"endTag","line":451},{"line":454,"name":"$mut","kind":13,"containerName":"write"},{"line":454,"containerName":"write","kind":12,"name":"restriction_changes"},{"line":455,"name":"$w","containerName":"write","kind":13},{"line":455,"kind":12,"containerName":"write","name":"startTag"},{"kind":13,"containerName":"write","name":"$w","line":456},{"line":456,"containerName":"write","kind":12,"name":"characters"},{"kind":13,"containerName":"write","name":"$mut","line":456},{"line":456,"containerName":"write","kind":12,"name":"restriction_changes"},{"name":"$w","kind":13,"containerName":"write","line":457},{"name":"endTag","containerName":"write","kind":12,"line":457},{"name":"$mut","containerName":"write","kind":13,"line":459},{"line":459,"kind":12,"containerName":"write","name":"region"},{"kind":13,"containerName":"write","name":"$mut","line":460},{"name":"region_value","containerName":"write","kind":12,"line":460},{"containerName":"write","kind":13,"name":"$mut","line":460},{"name":"region_dist","containerName":"write","kind":12,"line":460},{"line":461,"name":"$w","kind":13,"containerName":"write"},{"kind":12,"containerName":"write","name":"startTag","line":461},{"line":462,"name":"$mut","containerName":"write","kind":13},{"name":"region_value","containerName":"write","kind":12,"line":462},{"line":463,"name":"$mut","containerName":"write","kind":13},{"line":464,"name":"region_dist","containerName":"write","kind":12},{"name":"$mut","kind":13,"containerName":"write","line":466},{"line":466,"name":"region_value","kind":12,"containerName":"write"},{"name":"$w","containerName":"write","kind":13,"line":467},{"name":"startTag","kind":12,"containerName":"write","line":467},{"kind":13,"containerName":"write","name":"$mut","line":468},{"kind":12,"containerName":"write","name":"region_value","line":469},{"line":471,"name":"$mut","kind":13,"containerName":"write"},{"kind":12,"containerName":"write","name":"region_dist","line":471},{"name":"$w","kind":13,"containerName":"write","line":472},{"containerName":"write","kind":12,"name":"startTag","line":472},{"line":473,"name":"$mut","containerName":"write","kind":13},{"line":474,"name":"region_dist","containerName":"write","kind":12},{"name":"$w","kind":13,"containerName":"write","line":476},{"line":476,"name":"startTag","kind":12,"containerName":"write"},{"line":478,"name":"$w","kind":13,"containerName":"write"},{"line":478,"containerName":"write","kind":12,"name":"characters"},{"line":478,"containerName":"write","kind":13,"name":"$mut"},{"line":478,"name":"region","kind":12,"containerName":"write"},{"line":479,"containerName":"write","kind":13,"name":"$w"},{"name":"endTag","kind":12,"containerName":"write","line":479},{"line":481,"name":"$w","kind":13,"containerName":"write"},{"containerName":"write","kind":12,"name":"endTag","line":481},{"containerName":"write","kind":13,"name":"$mut","line":487},{"line":487,"name":"isa","containerName":"write","kind":12},{"line":488,"name":"$mut","kind":13,"containerName":"write"},{"line":488,"containerName":"write","kind":12,"name":"isMutation"},{"containerName":"write","kind":13,"name":"$mut","line":488},{"line":488,"containerName":"write","kind":12,"name":"isMutation"},{"definition":"my","name":"@alleles","localvar":"my","containerName":"write","kind":13,"line":489},{"containerName":"write","kind":13,"name":"$mut","line":489},{"line":489,"kind":12,"containerName":"write","name":"each_Allele"},{"definition":"my","line":490,"localvar":"my","containerName":"write","kind":13,"name":"$count"},{"containerName":"write","localvar":"my","kind":13,"name":"$allele","line":491,"definition":"my"},{"line":491,"name":"@alleles","kind":13,"containerName":"write"},{"line":492,"name":"$count","kind":13,"containerName":"write"},{"name":"$variation_number","localvar":"my","kind":13,"containerName":"write","line":493,"definition":"my"},{"name":"$change_number","containerName":"write","kind":13,"line":493},{"line":493,"containerName":"write","kind":13,"name":"$mut"},{"line":493,"kind":12,"containerName":"write","name":"mut_number"},{"containerName":"write","kind":13,"name":"$change_number","line":494},{"line":494,"containerName":"write","kind":13,"name":"$change_number"},{"name":"$count","kind":13,"containerName":"write","line":494},{"line":495,"name":"$mut","kind":13,"containerName":"write"},{"line":495,"containerName":"write","kind":12,"name":"mut_number"},{"line":497,"name":"$mut","kind":13,"containerName":"write"},{"line":497,"name":"allele_mut","containerName":"write","kind":12},{"kind":13,"containerName":"write","name":"$allele","line":497},{"name":"$w","containerName":"write","kind":13,"line":498},{"line":498,"name":"startTag","containerName":"write","kind":12},{"line":499,"name":"$mut","kind":13,"containerName":"write"},{"line":499,"kind":12,"containerName":"write","name":"mut_number"},{"name":"$mut","containerName":"write","kind":13,"line":500},{"line":500,"name":"start","containerName":"write","kind":12},{"line":501,"name":"$mut","containerName":"write","kind":13},{"line":501,"kind":12,"containerName":"write","name":"end"},{"line":502,"kind":13,"containerName":"write","name":"$mut"},{"line":502,"containerName":"write","kind":12,"name":"length"},{"containerName":"write","kind":13,"name":"$mut","line":503},{"name":"isMutation","containerName":"write","kind":12,"line":504},{"line":506,"name":"$mut","containerName":"write","kind":13},{"name":"label","kind":12,"containerName":"write","line":506},{"definition":"my","line":507,"localvar":"my","kind":13,"containerName":"write","name":"$label"},{"kind":13,"containerName":"write","name":"$mut","line":507},{"line":507,"name":"label","kind":12,"containerName":"write"},{"name":"$w","kind":13,"containerName":"write","line":508},{"name":"startTag","kind":12,"containerName":"write","line":508},{"line":509,"kind":13,"containerName":"write","name":"$w"},{"line":509,"name":"characters","kind":12,"containerName":"write"},{"containerName":"write","kind":13,"name":"$label","line":509},{"containerName":"write","kind":13,"name":"$w","line":510},{"name":"endTag","containerName":"write","kind":12,"line":510},{"line":513,"kind":13,"containerName":"write","name":"$mut"},{"line":513,"name":"proof","kind":12,"containerName":"write"},{"name":"$w","kind":13,"containerName":"write","line":514},{"line":514,"name":"startTag","containerName":"write","kind":12},{"line":515,"name":"$w","containerName":"write","kind":13},{"name":"characters","kind":12,"containerName":"write","line":515},{"name":"$mut","containerName":"write","kind":13,"line":515},{"kind":12,"containerName":"write","name":"proof","line":515},{"line":516,"name":"$w","kind":13,"containerName":"write"},{"line":516,"containerName":"write","kind":12,"name":"endTag"},{"line":519,"name":"$mut","containerName":"write","kind":13},{"name":"allele_ori","containerName":"write","kind":12,"line":519},{"name":"$w","kind":13,"containerName":"write","line":520},{"containerName":"write","kind":12,"name":"startTag","line":520},{"containerName":"write","kind":13,"name":"$w","line":521},{"containerName":"write","kind":12,"name":"characters","line":521},{"line":521,"containerName":"write","kind":13,"name":"$mut"},{"line":521,"containerName":"write","kind":12,"name":"allele_ori"},{"name":"seq","containerName":"write","kind":12,"line":521},{"kind":13,"containerName":"write","name":"$mut","line":521},{"line":521,"containerName":"write","kind":12,"name":"allele_ori"},{"name":"seq","containerName":"write","kind":12,"line":521},{"containerName":"write","kind":13,"name":"$w","line":522},{"kind":12,"containerName":"write","name":"endTag","line":522},{"kind":13,"containerName":"write","name":"$mut","line":524},{"line":524,"kind":12,"containerName":"write","name":"allele_mut"},{"kind":13,"containerName":"write","name":"$w","line":525},{"line":525,"containerName":"write","kind":12,"name":"startTag"},{"line":526,"name":"$w","containerName":"write","kind":13},{"name":"characters","containerName":"write","kind":12,"line":526},{"name":"$mut","kind":13,"containerName":"write","line":526},{"containerName":"write","kind":12,"name":"allele_mut","line":526},{"containerName":"write","kind":12,"name":"seq","line":526},{"kind":13,"containerName":"write","name":"$mut","line":526},{"line":526,"kind":12,"containerName":"write","name":"allele_mut"},{"line":526,"name":"seq","containerName":"write","kind":12},{"name":"$w","kind":13,"containerName":"write","line":527},{"line":527,"name":"endTag","containerName":"write","kind":12},{"kind":13,"containerName":"write","name":"$mut","line":530},{"containerName":"write","kind":12,"name":"region","line":530},{"line":531,"containerName":"write","kind":13,"name":"$mut"},{"line":531,"name":"region_value","kind":12,"containerName":"write"},{"line":531,"name":"$mut","kind":13,"containerName":"write"},{"line":531,"containerName":"write","kind":12,"name":"region_dist"},{"line":532,"containerName":"write","kind":13,"name":"$w"},{"containerName":"write","kind":12,"name":"startTag","line":532},{"line":533,"name":"$mut","kind":13,"containerName":"write"},{"line":533,"kind":12,"containerName":"write","name":"region_value"},{"name":"$mut","containerName":"write","kind":13,"line":534},{"containerName":"write","kind":12,"name":"region_dist","line":535},{"name":"$mut","containerName":"write","kind":13,"line":537},{"line":537,"name":"region_value","containerName":"write","kind":12},{"name":"$w","kind":13,"containerName":"write","line":538},{"kind":12,"containerName":"write","name":"startTag","line":538},{"line":539,"containerName":"write","kind":13,"name":"$mut"},{"name":"region_value","kind":12,"containerName":"write","line":540},{"name":"$mut","kind":13,"containerName":"write","line":542},{"kind":12,"containerName":"write","name":"region_dist","line":542},{"line":543,"kind":13,"containerName":"write","name":"$w"},{"line":543,"kind":12,"containerName":"write","name":"startTag"},{"kind":13,"containerName":"write","name":"$mut","line":544},{"line":545,"name":"region_dist","containerName":"write","kind":12},{"line":547,"containerName":"write","kind":13,"name":"$w"},{"containerName":"write","kind":12,"name":"startTag","line":547},{"line":549,"kind":13,"containerName":"write","name":"$w"},{"line":549,"kind":12,"containerName":"write","name":"characters"},{"name":"$mut","kind":13,"containerName":"write","line":549},{"containerName":"write","kind":12,"name":"region","line":549},{"line":550,"containerName":"write","kind":13,"name":"$w"},{"kind":12,"containerName":"write","name":"endTag","line":550},{"name":"$w","containerName":"write","kind":13,"line":552},{"kind":12,"containerName":"write","name":"endTag","line":552}],"containerName":"main::","name":"write"},{"kind":12,"containerName":"String","name":"IO","line":254},{"name":"XML","kind":12,"containerName":"Writer","line":255},{"kind":12,"name":"OUTPUT","line":255},{"kind":12,"name":"DATA_MODE","line":255},{"line":255,"name":"DATA_INDENT","kind":12},{"name":"$w","kind":13,"containerName":null,"line":558},{"line":558,"name":"endTag","containerName":"main::","kind":12},{"line":561,"name":"$w","containerName":null,"kind":13},{"name":"end","containerName":"main::","kind":12,"line":561},{"line":562,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","kind":12,"name":"_print","line":562},{"name":"$str","containerName":null,"kind":13,"line":562},{"line":563,"name":"$output","containerName":null,"kind":13}],"version":5}