{"version":5,"vars":[{"line":89,"kind":2,"containerName":"","name":"base"},{"children":[{"line":92,"name":"$self","localvar":"my","containerName":"_initialize","kind":13,"definition":"my"},{"line":92,"kind":13,"containerName":"_initialize","name":"%args"},{"name":"$args","kind":13,"containerName":"_initialize","line":93},{"kind":13,"containerName":"_initialize","name":"$self","line":94},{"line":94,"name":"%args","containerName":"_initialize","kind":13}],"containerName":"main::","name":"_initialize","definition":"sub","detail":"($self,%args)","line":91,"kind":12,"range":{"end":{"character":9999,"line":95},"start":{"character":0,"line":91}},"signature":{"parameters":[{"label":"$self"},{"label":"%args"}],"documentation":"","label":"_initialize($self,%args)"}},{"line":94,"name":"SUPER","kind":12,"containerName":"_initialize"},{"signature":{"label":"next_tree($self)","documentation":"1;\n# $Id: nhx.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO::nhx\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Aaron Mackey <amackey@virginia.edu>\n#\n# Copyright Aaron Mackey\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO::nhx - TreeIO implementation for parsing \n    Newick/New Hampshire eXtendend (NHX) format.\n\n=head1 SYNOPSIS\n\n  # do not use this module directly\n  use Bio::TreeIO;\n  my $treeio = Bio::TreeIO->new(-format => 'nhx', -file => 'tree.dnd');\n  my $tree = $treeio->next_tree;\n\n=head1 DESCRIPTION\n\nThis module handles parsing and writing of Newick/New Hampshire eXtended (NHX) format.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted viax the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Aaron Mackey\n\nEmail amackey-at-virginia.edu\n\n=head1 CONTRIBUTORS\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO::nhx;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Tree::NodeNHX;\nuse Bio::Event::EventGeneratorI;\n#use XML::Handler::Subs;\n\n\nuse base qw(Bio::TreeIO);\n\nsub _initialize {\n  my($self, %args) = @_;\n  $args{-nodetype} ||= 'Bio::Tree::NodeNHX';\n  $self->SUPER::_initialize(%args);\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $treeio->next_tree\n Function: Gets the next tree in the stream\n Returns : Bio::Tree::TreeI\n Args    : none","parameters":[{"label":"$self"}]},"line":108,"kind":12,"range":{"start":{"line":108,"character":0},"end":{"line":263,"character":9999}},"definition":"sub","detail":"($self)","children":[{"definition":"my","line":109,"name":"$self","containerName":"next_tree","localvar":"my","kind":13},{"line":111,"name":"$self","containerName":"next_tree","kind":13},{"line":111,"containerName":"next_tree","kind":12,"name":"_readline"},{"line":113,"name":"$self","kind":13,"containerName":"next_tree"},{"name":"debug","kind":12,"containerName":"next_tree","line":113},{"definition":"my","name":"$chars","localvar":"my","containerName":"next_tree","kind":13,"line":114},{"containerName":"next_tree","kind":13,"name":"$self","line":115},{"name":"_eventHandler","kind":12,"containerName":"next_tree","line":115},{"line":115,"kind":12,"containerName":"next_tree","name":"start_document"},{"definition":"my","line":116,"containerName":"next_tree","localvar":"my","kind":13,"name":"$prev_event"},{"line":116,"name":"$lastevent","kind":13,"containerName":"next_tree"},{"line":116,"kind":13,"containerName":"next_tree","name":"$last_leaf_event"},{"name":"@ch","localvar":"my","containerName":"next_tree","kind":13,"line":117,"definition":"my"},{"definition":"my","line":118,"localvar":"my","kind":13,"containerName":"next_tree","name":"$ch"},{"line":118,"name":"@ch","containerName":"next_tree","kind":13},{"line":119,"name":"$ch","containerName":"next_tree","kind":13},{"name":"$self","kind":13,"containerName":"next_tree","line":120},{"line":120,"name":"_eventHandler","containerName":"next_tree","kind":12},{"name":"in_element","containerName":"next_tree","kind":12,"line":120},{"containerName":"next_tree","kind":13,"name":"$self","line":121},{"kind":12,"containerName":"next_tree","name":"_eventHandler","line":121},{"kind":12,"containerName":"next_tree","name":"end_element","line":121},{"line":122,"containerName":"next_tree","kind":13,"name":"$self"},{"line":122,"kind":12,"containerName":"next_tree","name":"_eventHandler"},{"containerName":"next_tree","kind":12,"name":"end_document","line":122},{"name":"$ch","containerName":"next_tree","kind":13,"line":123},{"containerName":"next_tree","kind":13,"name":"$chars","line":124},{"line":125,"name":"$lastevent","kind":13,"containerName":"next_tree"},{"line":126,"containerName":"next_tree","kind":13,"name":"$self"},{"kind":12,"containerName":"next_tree","name":"_eventHandler","line":126},{"containerName":"next_tree","kind":12,"name":"start_element","line":126},{"name":"$self","containerName":"next_tree","kind":13,"line":127},{"name":"_eventHandler","containerName":"next_tree","kind":12,"line":127},{"name":"characters","kind":12,"containerName":"next_tree","line":127},{"name":"$chars","containerName":"next_tree","kind":13,"line":127},{"line":128,"name":"$self","containerName":"next_tree","kind":13},{"name":"_eventHandler","kind":12,"containerName":"next_tree","line":128},{"line":128,"name":"end_element","kind":12,"containerName":"next_tree"},{"line":129,"name":"$lastevent","containerName":"next_tree","kind":13},{"name":"$prev_event","kind":13,"containerName":"next_tree","line":129},{"line":131,"name":"$self","kind":13,"containerName":"next_tree"},{"line":131,"name":"debug","kind":12,"containerName":"next_tree"},{"line":132,"containerName":"next_tree","kind":13,"name":"$self"},{"containerName":"next_tree","kind":12,"name":"_eventHandler","line":132},{"containerName":"next_tree","kind":12,"name":"start_element","line":132},{"line":133,"name":"$self","containerName":"next_tree","kind":13},{"line":133,"name":"_eventHandler","containerName":"next_tree","kind":12},{"name":"start_element","kind":12,"containerName":"next_tree","line":133},{"name":"$self","containerName":"next_tree","kind":13,"line":134},{"name":"_eventHandler","kind":12,"containerName":"next_tree","line":134},{"kind":12,"containerName":"next_tree","name":"characters","line":134},{"line":134,"kind":13,"containerName":"next_tree","name":"$chars"},{"name":"$self","kind":13,"containerName":"next_tree","line":135},{"line":135,"name":"_eventHandler","kind":12,"containerName":"next_tree"},{"line":135,"kind":12,"containerName":"next_tree","name":"end_element"},{"line":138,"name":"$self","containerName":"next_tree","kind":13},{"line":138,"kind":12,"containerName":"next_tree","name":"_eventHandler"},{"line":138,"name":"start_element","kind":12,"containerName":"next_tree"},{"line":140,"localvar":"my","containerName":"next_tree","kind":13,"name":"$leafstatus","definition":"my"},{"kind":13,"containerName":"next_tree","name":"$last_leaf_event","line":140},{"name":"$self","containerName":"next_tree","kind":13,"line":141},{"line":141,"name":"_eventHandler","containerName":"next_tree","kind":12},{"line":141,"name":"start_element","kind":12,"containerName":"next_tree"},{"kind":13,"containerName":"next_tree","name":"$self","line":142},{"line":142,"containerName":"next_tree","kind":12,"name":"_eventHandler"},{"line":142,"containerName":"next_tree","kind":12,"name":"characters"},{"line":142,"name":"$leafstatus","containerName":"next_tree","kind":13},{"line":143,"name":"$self","kind":13,"containerName":"next_tree"},{"line":143,"kind":12,"containerName":"next_tree","name":"_eventHandler"},{"line":143,"containerName":"next_tree","kind":12,"name":"end_element"},{"name":"$chars","kind":13,"containerName":"next_tree","line":144},{"line":146,"name":"$self","kind":13,"containerName":"next_tree"},{"name":"_eventHandler","kind":12,"containerName":"next_tree","line":146},{"containerName":"next_tree","kind":12,"name":"start_element","line":146},{"containerName":"next_tree","kind":13,"name":"$ch","line":147},{"line":148,"name":"$chars","kind":13,"containerName":"next_tree"},{"containerName":"next_tree","kind":13,"name":"$self","line":149},{"containerName":"next_tree","kind":12,"name":"_eventHandler","line":149},{"line":149,"containerName":"next_tree","kind":12,"name":"start_element"},{"line":150,"kind":13,"containerName":"next_tree","name":"$ch"},{"containerName":"next_tree","kind":13,"name":"$chars","line":151},{"name":"$lastevent","containerName":"next_tree","kind":13,"line":152},{"containerName":"next_tree","kind":13,"name":"$self","line":153},{"line":153,"name":"_eventHandler","kind":12,"containerName":"next_tree"},{"line":153,"kind":12,"containerName":"next_tree","name":"within_element"},{"name":"$self","containerName":"next_tree","kind":13,"line":154},{"line":154,"name":"_eventHandler","kind":12,"containerName":"next_tree"},{"containerName":"next_tree","kind":12,"name":"start_element","line":154},{"line":155,"name":"$self","containerName":"next_tree","kind":13},{"name":"_eventHandler","containerName":"next_tree","kind":12,"line":155},{"line":155,"kind":12,"containerName":"next_tree","name":"characters"},{"name":"$chars","containerName":"next_tree","kind":13,"line":155},{"kind":13,"containerName":"next_tree","name":"$self","line":156},{"line":156,"containerName":"next_tree","kind":12,"name":"_eventHandler"},{"name":"end_element","containerName":"next_tree","kind":12,"line":156},{"name":"$self","containerName":"next_tree","kind":13,"line":158},{"name":"throw","kind":12,"containerName":"next_tree","line":158},{"line":161,"containerName":"next_tree","kind":13,"name":"$self"},{"line":161,"name":"debug","containerName":"next_tree","kind":12},{"name":"$self","kind":13,"containerName":"next_tree","line":162},{"line":162,"kind":12,"containerName":"next_tree","name":"_eventHandler"},{"line":162,"containerName":"next_tree","kind":12,"name":"start_element"},{"line":163,"name":"$self","kind":13,"containerName":"next_tree"},{"kind":12,"containerName":"next_tree","name":"_eventHandler","line":163},{"line":163,"name":"start_element","kind":12,"containerName":"next_tree"},{"name":"$self","containerName":"next_tree","kind":13,"line":164},{"line":164,"containerName":"next_tree","kind":12,"name":"_eventHandler"},{"containerName":"next_tree","kind":12,"name":"characters","line":164},{"name":"$chars","containerName":"next_tree","kind":13,"line":164},{"line":165,"name":"$self","containerName":"next_tree","kind":13},{"kind":12,"containerName":"next_tree","name":"_eventHandler","line":165},{"containerName":"next_tree","kind":12,"name":"end_element","line":165},{"line":167,"name":"$lastevent","kind":13,"containerName":"next_tree"},{"name":"$self","kind":13,"containerName":"next_tree","line":168},{"kind":12,"containerName":"next_tree","name":"_eventHandler","line":168},{"kind":12,"containerName":"next_tree","name":"start_element","line":168},{"definition":"my","line":175,"kind":13,"localvar":"my","containerName":"next_tree","name":"$leafstatus"},{"name":"$last_leaf_event","containerName":"next_tree","kind":13,"line":175},{"line":176,"name":"$self","kind":13,"containerName":"next_tree"},{"line":176,"kind":12,"containerName":"next_tree","name":"_eventHandler"},{"containerName":"next_tree","kind":12,"name":"start_element","line":176},{"line":177,"containerName":"next_tree","kind":13,"name":"$self"},{"kind":12,"containerName":"next_tree","name":"_eventHandler","line":177},{"containerName":"next_tree","kind":12,"name":"characters","line":177},{"line":177,"containerName":"next_tree","kind":13,"name":"$leafstatus"},{"line":178,"name":"$self","kind":13,"containerName":"next_tree"},{"kind":12,"containerName":"next_tree","name":"_eventHandler","line":178},{"name":"end_element","containerName":"next_tree","kind":12,"line":178},{"line":180,"containerName":"next_tree","kind":13,"name":"$self"},{"line":180,"containerName":"next_tree","kind":12,"name":"_eventHandler"},{"line":180,"kind":12,"containerName":"next_tree","name":"end_element"},{"name":"$self","kind":13,"containerName":"next_tree","line":181},{"line":181,"name":"_eventHandler","containerName":"next_tree","kind":12},{"kind":12,"containerName":"next_tree","name":"end_element","line":181},{"kind":13,"containerName":"next_tree","name":"$chars","line":182},{"name":"$last_leaf_event","kind":13,"containerName":"next_tree","line":183},{"name":"$ch","containerName":"next_tree","kind":13,"line":183},{"name":"$ch","containerName":"next_tree","kind":13,"line":185},{"name":"$chars","kind":13,"containerName":"next_tree","line":186},{"name":"$lastevent","containerName":"next_tree","kind":13,"line":187},{"line":188,"name":"$self","containerName":"next_tree","kind":13},{"containerName":"next_tree","kind":12,"name":"_eventHandler","line":188},{"kind":12,"containerName":"next_tree","name":"start_element","line":188},{"containerName":"next_tree","kind":13,"name":"$self","line":189},{"line":189,"name":"_eventHandler","containerName":"next_tree","kind":12},{"line":189,"name":"characters","containerName":"next_tree","kind":12},{"name":"$chars","kind":13,"containerName":"next_tree","line":189},{"name":"$self","kind":13,"containerName":"next_tree","line":190},{"line":190,"name":"_eventHandler","containerName":"next_tree","kind":12},{"name":"end_element","kind":12,"containerName":"next_tree","line":190},{"containerName":"next_tree","kind":13,"name":"$lastevent","line":191},{"line":191,"name":"$prev_event","containerName":"next_tree","kind":13},{"line":193,"name":"$self","containerName":"next_tree","kind":13},{"line":193,"kind":12,"containerName":"next_tree","name":"debug"},{"line":194,"name":"$self","containerName":"next_tree","kind":13},{"name":"_eventHandler","kind":12,"containerName":"next_tree","line":194},{"line":194,"name":"start_element","containerName":"next_tree","kind":12},{"name":"$self","containerName":"next_tree","kind":13,"line":195},{"line":195,"containerName":"next_tree","kind":12,"name":"_eventHandler"},{"line":195,"kind":12,"containerName":"next_tree","name":"start_element"},{"name":"$self","containerName":"next_tree","kind":13,"line":196},{"containerName":"next_tree","kind":12,"name":"_eventHandler","line":196},{"line":196,"name":"characters","kind":12,"containerName":"next_tree"},{"name":"$chars","kind":13,"containerName":"next_tree","line":196},{"line":197,"containerName":"next_tree","kind":13,"name":"$self"},{"line":197,"name":"_eventHandler","kind":12,"containerName":"next_tree"},{"line":197,"kind":12,"containerName":"next_tree","name":"end_element"},{"line":199,"kind":13,"containerName":"next_tree","name":"$lastevent"},{"line":200,"name":"$self","containerName":"next_tree","kind":13},{"name":"_eventHandler","containerName":"next_tree","kind":12,"line":200},{"name":"start_element","containerName":"next_tree","kind":12,"line":200},{"containerName":"next_tree","kind":13,"name":"$self","line":202},{"containerName":"next_tree","kind":12,"name":"_eventHandler","line":202},{"name":"end_element","kind":12,"containerName":"next_tree","line":202},{"line":203,"name":"$chars","containerName":"next_tree","kind":13},{"kind":13,"containerName":"next_tree","name":"$last_leaf_event","line":204},{"line":204,"name":"$ch","kind":13,"containerName":"next_tree"},{"line":205,"kind":13,"containerName":"next_tree","name":"$ch"},{"line":206,"kind":13,"containerName":"next_tree","name":"$self"},{"line":206,"name":"_eventHandler","kind":12,"containerName":"next_tree"},{"kind":12,"containerName":"next_tree","name":"within_element","line":206},{"line":207,"name":"$lastevent","containerName":"next_tree","kind":13},{"name":"$self","kind":13,"containerName":"next_tree","line":208},{"line":208,"name":"_eventHandler","kind":12,"containerName":"next_tree"},{"name":"start_element","containerName":"next_tree","kind":12,"line":208},{"line":209,"name":"$self","containerName":"next_tree","kind":13},{"line":209,"kind":12,"containerName":"next_tree","name":"_eventHandler"},{"line":209,"containerName":"next_tree","kind":12,"name":"characters"},{"name":"$chars","containerName":"next_tree","kind":13,"line":209},{"kind":13,"containerName":"next_tree","name":"$self","line":210},{"line":210,"kind":12,"containerName":"next_tree","name":"_eventHandler"},{"name":"end_element","containerName":"next_tree","kind":12,"line":210},{"containerName":"next_tree","kind":13,"name":"$chars","line":211},{"name":"$chars","containerName":"next_tree","kind":13,"line":213},{"name":"$chars","kind":13,"containerName":"next_tree","line":214},{"line":216,"kind":13,"containerName":"next_tree","name":"$self"},{"line":216,"name":"throw","containerName":"next_tree","kind":12},{"kind":13,"containerName":"next_tree","name":"$lastevent","line":219},{"name":"$self","kind":13,"containerName":"next_tree","line":220},{"line":220,"name":"debug","kind":12,"containerName":"next_tree"},{"containerName":"next_tree","kind":13,"name":"$self","line":221},{"line":221,"name":"_eventHandler","containerName":"next_tree","kind":12},{"name":"start_element","kind":12,"containerName":"next_tree","line":221},{"name":"$self","containerName":"next_tree","kind":13,"line":222},{"line":222,"name":"_eventHandler","containerName":"next_tree","kind":12},{"name":"start_element","containerName":"next_tree","kind":12,"line":222},{"line":223,"name":"$self","kind":13,"containerName":"next_tree"},{"line":223,"name":"_eventHandler","containerName":"next_tree","kind":12},{"line":223,"name":"characters","containerName":"next_tree","kind":12},{"line":223,"name":"$chars","containerName":"next_tree","kind":13},{"kind":13,"containerName":"next_tree","name":"$self","line":224},{"line":224,"name":"_eventHandler","kind":12,"containerName":"next_tree"},{"containerName":"next_tree","kind":12,"name":"end_element","line":224},{"name":"$chars","kind":13,"containerName":"next_tree","line":225},{"line":227,"containerName":"next_tree","kind":13,"name":"$ch"},{"name":"$self","containerName":"next_tree","kind":13,"line":228},{"line":228,"containerName":"next_tree","kind":12,"name":"_eventHandler"},{"line":228,"kind":12,"containerName":"next_tree","name":"within_element"},{"name":"$self","containerName":"next_tree","kind":13,"line":229},{"line":229,"name":"_eventHandler","kind":12,"containerName":"next_tree"},{"name":"start_element","containerName":"next_tree","kind":12,"line":229},{"line":230,"name":"$self","containerName":"next_tree","kind":13},{"line":230,"containerName":"next_tree","kind":12,"name":"_eventHandler"},{"line":230,"kind":12,"containerName":"next_tree","name":"characters"},{"line":230,"name":"$chars","containerName":"next_tree","kind":13},{"name":"$self","containerName":"next_tree","kind":13,"line":231},{"kind":12,"containerName":"next_tree","name":"_eventHandler","line":231},{"kind":12,"containerName":"next_tree","name":"end_element","line":231},{"containerName":"next_tree","kind":13,"name":"$chars","line":232},{"line":234,"kind":13,"containerName":"next_tree","name":"$chars"},{"kind":13,"containerName":"next_tree","name":"$ch","line":234},{"line":236,"kind":13,"containerName":"next_tree","name":"$ch"},{"line":237,"containerName":"next_tree","kind":13,"name":"$self"},{"name":"_eventHandler","containerName":"next_tree","kind":12,"line":237},{"containerName":"next_tree","kind":12,"name":"within_element","line":237},{"containerName":"next_tree","kind":13,"name":"$lastevent","line":238},{"containerName":"next_tree","kind":13,"name":"$self","line":239},{"line":239,"kind":12,"containerName":"next_tree","name":"_eventHandler"},{"name":"start_element","containerName":"next_tree","kind":12,"line":239},{"kind":13,"containerName":"next_tree","name":"$self","line":240},{"kind":12,"containerName":"next_tree","name":"_eventHandler","line":240},{"kind":12,"containerName":"next_tree","name":"characters","line":240},{"line":240,"kind":13,"containerName":"next_tree","name":"$chars"},{"line":241,"kind":13,"containerName":"next_tree","name":"$self"},{"kind":12,"containerName":"next_tree","name":"_eventHandler","line":241},{"line":241,"name":"end_element","containerName":"next_tree","kind":12},{"kind":13,"containerName":"next_tree","name":"$chars","line":242},{"name":"$self","kind":13,"containerName":"next_tree","line":243},{"line":243,"name":"_eventHandler","containerName":"next_tree","kind":12},{"name":"end_element","containerName":"next_tree","kind":12,"line":243},{"name":"$chars","kind":13,"containerName":"next_tree","line":245},{"line":246,"containerName":"next_tree","kind":13,"name":"$self"},{"line":246,"name":"throw","containerName":"next_tree","kind":12},{"name":"$chars","kind":13,"containerName":"next_tree","line":248},{"line":249,"name":"$self","kind":13,"containerName":"next_tree"},{"line":249,"containerName":"next_tree","kind":12,"name":"_eventHandler"},{"line":249,"name":"end_element","containerName":"next_tree","kind":12},{"containerName":"next_tree","kind":13,"name":"$chars","line":252},{"line":252,"name":"$ch","kind":13,"containerName":"next_tree"},{"name":"$chars","kind":13,"containerName":"next_tree","line":256},{"containerName":"next_tree","kind":13,"name":"$ch","line":256},{"kind":13,"containerName":"next_tree","name":"$prev_event","line":259},{"kind":13,"containerName":"next_tree","name":"$lastevent","line":259},{"line":260,"name":"$lastevent","kind":13,"containerName":"next_tree"},{"line":260,"name":"$ch","containerName":"next_tree","kind":13}],"containerName":"main::","name":"next_tree"},{"name":"Name","kind":12,"line":126},{"line":128,"name":"Name","kind":12},{"line":138,"kind":12,"name":"Name"},{"kind":12,"name":"Name","line":146},{"name":"Name","kind":12,"line":208},{"line":210,"name":"Name","kind":12},{"line":229,"name":"Name","kind":12},{"name":"Name","kind":12,"line":231},{"line":239,"kind":12,"name":"Name"},{"kind":12,"name":"Name","line":241},{"line":243,"kind":12,"name":"Name"},{"line":249,"kind":12,"name":"Name"},{"signature":{"parameters":[{"label":"$self"},{"label":"@trees"}],"documentation":"1;\n# $Id: nhx.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO::nhx\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Aaron Mackey <amackey@virginia.edu>\n#\n# Copyright Aaron Mackey\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO::nhx - TreeIO implementation for parsing \n    Newick/New Hampshire eXtendend (NHX) format.\n\n=head1 SYNOPSIS\n\n  # do not use this module directly\n  use Bio::TreeIO;\n  my $treeio = Bio::TreeIO->new(-format => 'nhx', -file => 'tree.dnd');\n  my $tree = $treeio->next_tree;\n\n=head1 DESCRIPTION\n\nThis module handles parsing and writing of Newick/New Hampshire eXtended (NHX) format.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted viax the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Aaron Mackey\n\nEmail amackey-at-virginia.edu\n\n=head1 CONTRIBUTORS\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO::nhx;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Tree::NodeNHX;\nuse Bio::Event::EventGeneratorI;\n#use XML::Handler::Subs;\n\n\nuse base qw(Bio::TreeIO);\n\nsub _initialize {\n  my($self, %args) = @_;\n  $args{-nodetype} ||= 'Bio::Tree::NodeNHX';\n  $self->SUPER::_initialize(%args);\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $treeio->next_tree\n Function: Gets the next tree in the stream\n Returns : Bio::Tree::TreeI\n Args    : none\n\n\n\nsub next_tree{\n    my ($self) = @_;\n    local $/ = \";\\n\";\n    return unless $_ = $self->_readline;\n    s/\\s+//g;\n    $self->debug(\"entry is $_\\n\");\n    my $chars = '';\n    $self->_eventHandler->start_document;\n    my ($prev_event,$lastevent,$last_leaf_event) = ('','','');\n    my @ch = split(//, $_);\n    foreach my $ch  (@ch) {\n\tif( $ch eq ';' ) { \t   \n\t    $self->_eventHandler->in_element('node') && \n\t\t$self->_eventHandler->end_element( {'Name' => 'node'});\n\t    return $self->_eventHandler->end_document;\n\t} elsif ($ch eq '[') {\n\t    if ( length $chars ) {\n\t\tif ( $lastevent eq ':' ) {\n\t\t    $self->_eventHandler->start_element( { Name => 'branch_length' } );\n\t\t    $self->_eventHandler->characters($chars);\n\t\t    $self->_eventHandler->end_element( { Name => 'branch_length' });\n\t\t    $lastevent = $prev_event;\n\t\t} else {\n\t\t    $self->debug(\"id with no branchlength is $chars\\n\");\n\t\t    $self->_eventHandler->start_element( { 'Name' => 'node' } );\n\t\t    $self->_eventHandler->start_element( { 'Name' => 'id' } );\n\t\t    $self->_eventHandler->characters($chars);\n\t\t    $self->_eventHandler->end_element( { 'Name' => 'id' } );\t\t   \n\t\t}\n\t    } else {\n\t\t$self->_eventHandler->start_element( { Name => 'node' } );\n\t    }\n\t    my $leafstatus = ( $last_leaf_event ne ')' ) ? 1 : 0;\n\t    $self->_eventHandler->start_element({'Name' => 'leaf'});\n\t    $self->_eventHandler->characters($leafstatus);\n\t    $self->_eventHandler->end_element({'Name' => 'leaf'});\t   \n\t    $chars = '';\n\t    \n\t    $self->_eventHandler->start_element( { Name => 'nhx_tag' });\n\t} elsif( $ch eq '(' ) {\n\t    $chars = '';\n\t    $self->_eventHandler->start_element( {'Name' => 'tree'} );\n\t} elsif($ch eq ')' ) {\n\t    if( length $chars ) {\n\t\tif( $lastevent eq ':') {\n\t\t    unless ($self->_eventHandler->within_element('nhx_tag')) {\n\t\t\t$self->_eventHandler->start_element( { 'Name' => 'branch_length'});\n\t\t\t$self->_eventHandler->characters($chars);\n\t\t\t$self->_eventHandler->end_element( {'Name' => 'branch_length'});\n\t\t    } else {\n\t\t\t$self->throw(\"malformed input; end of node ) before ] found\");\n\t\t    }\n\t\t} else { \n\t\t    $self->debug(\"id with no branchlength is '$chars'\\n\");\n\t\t    $self->_eventHandler->start_element( { 'Name' => 'node' } );\n\t\t    $self->_eventHandler->start_element( { 'Name' => 'id' } );\n\t\t    $self->_eventHandler->characters($chars);\n\t\t    $self->_eventHandler->end_element( { 'Name' => 'id' } );\n\t\t}\n\t    } elsif ( $lastevent ne ']' ) {\n\t\t$self->_eventHandler->start_element( {'Name' => 'node'} );\n\t    }\n\t    # problem here is that we need to detect if we coming up on\n\t    # the end of a leaf node or a labeled internal node\n\t    # each can have [] and each can have :, but only leaves are \n\t    # NOT proceeded by a ')'\n\t    # the [] events throw us off\n\t    my $leafstatus = ( $last_leaf_event ne ')' ) ? 1 : 0;\n\t    $self->_eventHandler->start_element({'Name' => 'leaf'});\n\t    $self->_eventHandler->characters($leafstatus);\n\t    $self->_eventHandler->end_element({'Name' => 'leaf'});\t   \n\t    \n\t    $self->_eventHandler->end_element( {'Name' => 'node'} );\n\t    $self->_eventHandler->end_element( {'Name' => 'tree'} );\n\t    $chars = '';\n\t    $last_leaf_event = $ch;\n\n\t} elsif ( $ch eq ',' ) {\n\t    if( length $chars ) {\n\t\tif( $lastevent eq ':' ) {\n\t\t    $self->_eventHandler->start_element( { 'Name' => 'branch_length'});\n\t\t    $self->_eventHandler->characters($chars);\n\t\t    $self->_eventHandler->end_element( {'Name' => 'branch_length'});\n\t\t    $lastevent = $prev_event;\n\t\t} else { \n\t\t    $self->debug(\"id with no branchlength is $chars, last event was $lastevent\\n\");\n\t\t    $self->_eventHandler->start_element( { 'Name' => 'node' } );\n\t\t    $self->_eventHandler->start_element( { 'Name' => 'id' } );\n\t\t    $self->_eventHandler->characters($chars);\n\t\t    $self->_eventHandler->end_element( { 'Name' => 'id' } );\n\t\t}   \n\t    } elsif ( $lastevent ne ']' ) {\n\t\t$self->_eventHandler->start_element( { 'Name' => 'node' } );\n\t    }\n\t    $self->_eventHandler->end_element( {'Name' => 'node'} );\n\t    $chars = '';\n\t    $last_leaf_event = $ch;\n\t} elsif( $ch eq ':' ) {\n\t    if ($self->_eventHandler->within_element('nhx_tag')) {\n\t\tif ($lastevent eq '=') {\n\t\t    $self->_eventHandler->start_element( { Name => 'tag_value' } );\n\t\t    $self->_eventHandler->characters($chars);\n\t\t    $self->_eventHandler->end_element( { Name => 'tag_value' } );\n\t\t    $chars = '';\n\t\t} else {\n\t\t    if ($chars eq '&&NHX') {\n\t\t\t$chars = ''; # get rid of &&NHX:\n\t\t    } else {\n\t\t\t$self->throw(\"Unrecognized, non \\&\\&NHX string: >>$chars<<; lastevent is $lastevent\");\n\t\t    }\n\t\t}\n\t    } elsif ($lastevent ne ']') {\n\t\t$self->debug(\"id with a branchlength coming is $chars\\n\");\n\t\t$self->_eventHandler->start_element( { 'Name' => 'node' } );\n\t\t$self->_eventHandler->start_element( { 'Name' => 'id' } );\n\t\t$self->_eventHandler->characters($chars);\n\t\t$self->_eventHandler->end_element( { 'Name' => 'id' } );\n\t\t$chars = '';\n\t    }\n\t} elsif ( $ch eq '=' ) {\n\t    if ($self->_eventHandler->within_element('nhx_tag')) {\n\t\t$self->_eventHandler->start_element( { Name => 'tag_name' } );\n\t\t$self->_eventHandler->characters($chars);\n\t\t$self->_eventHandler->end_element( { Name => 'tag_name' } );\n\t\t$chars = '';\n\t    } else {\n\t\t$chars .= $ch;\n\t    }\n\t} elsif ( $ch eq ']' ) {\n\t    if ($self->_eventHandler->within_element('nhx_tag') ) {\n\t\tif( $lastevent eq '=' ) {\n\t\t    $self->_eventHandler->start_element( { Name => 'tag_value' } );\n\t\t    $self->_eventHandler->characters($chars);\n\t\t    $self->_eventHandler->end_element( { Name => 'tag_value' } );\t\t    \n\t\t    $chars = '';\n\t\t    $self->_eventHandler->end_element( { Name => 'nhx_tag' } );\n\t\t} else {\n\t\t    if ($chars ne '&&NHX') {\n\t\t\t$self->throw(\"Unrecognized, non \\&\\&NHX string: >>$chars<<; lastevent is $lastevent\");\n\t\t    }\n\t\t    $chars = '';\n\t\t    $self->_eventHandler->end_element( { Name => 'nhx_tag' } );\n\t\t}\n\t    } else {\n\t\t$chars .= $ch;\n\t\tnext;\n\t    }\n\t} else { \t   \n\t    $chars .= $ch;\n\t    next;\n\t}\n\t$prev_event = $lastevent;\n\t$lastevent = $ch;\n    }       \n    return;\n}\n\n=head2 write_tree\n\n Title   : write_tree\n Usage   : $treeio->write_tree($tree);\n Function: Write a tree out to data stream in nhx format\n Returns : none\n Args    : Bio::Tree::TreeI object","label":"write_tree($self,@trees)"},"line":275,"kind":12,"range":{"start":{"line":275,"character":0},"end":{"line":295,"character":9999}},"definition":"sub","detail":"($self,@trees)","children":[{"definition":"my","line":276,"name":"$self","localvar":"my","containerName":"write_tree","kind":13},{"line":276,"containerName":"write_tree","kind":13,"name":"@trees"},{"kind":13,"localvar":"my","containerName":"write_tree","name":"$nl","line":277,"definition":"my"},{"name":"$self","containerName":"write_tree","kind":13,"line":277},{"line":277,"name":"newline_each_node","kind":12,"containerName":"write_tree"},{"definition":"my","line":278,"name":"$tree","localvar":"my","containerName":"write_tree","kind":13},{"line":278,"name":"@trees","containerName":"write_tree","kind":13},{"name":"@data","localvar":"my","kind":13,"containerName":"write_tree","line":279,"definition":"my"},{"name":"$tree","kind":13,"containerName":"write_tree","line":279},{"containerName":"write_tree","kind":12,"name":"get_root_node","line":279},{"line":279,"containerName":"write_tree","kind":13,"name":"$nl"},{"line":283,"name":"$data","containerName":"write_tree","kind":13},{"name":"$data","kind":13,"containerName":"write_tree","line":284},{"line":286,"name":"$nl","containerName":"write_tree","kind":13},{"name":"$data","containerName":"write_tree","kind":13,"line":287},{"line":288,"kind":13,"containerName":"write_tree","name":"$self"},{"line":288,"kind":12,"containerName":"write_tree","name":"_print"},{"containerName":"write_tree","kind":13,"name":"@data","line":288},{"kind":13,"containerName":"write_tree","name":"$self","line":290},{"line":290,"name":"_print","kind":12,"containerName":"write_tree"},{"name":"@data","kind":13,"containerName":"write_tree","line":290},{"line":293,"name":"$self","containerName":"write_tree","kind":13},{"line":293,"containerName":"write_tree","kind":12,"name":"flush"},{"line":293,"containerName":"write_tree","kind":13,"name":"$self"},{"containerName":"write_tree","kind":12,"name":"_flush_on_write","line":293},{"line":293,"containerName":"write_tree","kind":13,"name":"$self"},{"name":"_fh","kind":12,"containerName":"write_tree","line":293}],"containerName":"main::","name":"write_tree"},{"name":"_write_tree_Helper","kind":12,"line":279},{"signature":{"documentation":"","parameters":[{"label":"$node"},{"label":"$nl"}],"label":"_write_tree_Helper($node,$nl)"},"line":297,"range":{"start":{"character":0,"line":297},"end":{"line":343,"character":9999}},"kind":12,"definition":"sub","detail":"($node,$nl)","children":[{"definition":"my","line":298,"localvar":"my","kind":13,"containerName":"_write_tree_Helper","name":"$node"},{"name":"$nl","containerName":"_write_tree_Helper","kind":13,"line":298},{"line":299,"containerName":"_write_tree_Helper","kind":13,"name":"$node"},{"line":301,"name":"$node","kind":13,"containerName":"_write_tree_Helper"},{"line":301,"name":"$node","containerName":"_write_tree_Helper","kind":13},{"containerName":"_write_tree_Helper","localvar":"my","kind":13,"name":"@data","line":302,"definition":"my"},{"line":304,"name":"$n","localvar":"my","kind":13,"containerName":"_write_tree_Helper","definition":"my"},{"name":"$node","containerName":"_write_tree_Helper","kind":13,"line":304},{"line":304,"name":"each_Descendent","kind":12,"containerName":"_write_tree_Helper"},{"line":305,"kind":13,"containerName":"_write_tree_Helper","name":"@data"},{"containerName":"_write_tree_Helper","kind":13,"name":"$n","line":305},{"containerName":"_write_tree_Helper","kind":13,"name":"$nl","line":305},{"kind":13,"containerName":"_write_tree_Helper","name":"@data","line":308},{"line":309,"name":"$nl","containerName":"_write_tree_Helper","kind":13},{"line":310,"name":"$data","containerName":"_write_tree_Helper","kind":13},{"line":310,"name":"$data","containerName":"_write_tree_Helper","kind":13},{"name":"$data","kind":13,"containerName":"_write_tree_Helper","line":311},{"name":"$data","containerName":"_write_tree_Helper","kind":13,"line":313},{"line":313,"containerName":"_write_tree_Helper","kind":13,"name":"$data"},{"containerName":"_write_tree_Helper","kind":13,"name":"$data","line":314},{"name":"$id","localvar":"my","kind":13,"containerName":"_write_tree_Helper","line":317,"definition":"my"},{"name":"$node","kind":13,"containerName":"_write_tree_Helper","line":317},{"line":317,"containerName":"_write_tree_Helper","kind":12,"name":"id"},{"line":318,"kind":13,"containerName":"_write_tree_Helper","name":"$data"},{"line":318,"name":"$id","containerName":"_write_tree_Helper","kind":13},{"line":318,"name":"$id","kind":13,"containerName":"_write_tree_Helper"},{"name":"$blen","localvar":"my","containerName":"_write_tree_Helper","kind":13,"line":319,"definition":"my"},{"line":319,"containerName":"_write_tree_Helper","kind":13,"name":"$node"},{"kind":12,"containerName":"_write_tree_Helper","name":"branch_length","line":319},{"containerName":"_write_tree_Helper","kind":13,"name":"$data","line":320},{"name":"$blen","kind":13,"containerName":"_write_tree_Helper","line":320},{"line":320,"name":"$blen","containerName":"_write_tree_Helper","kind":13},{"line":323,"kind":13,"localvar":"my","containerName":"_write_tree_Helper","name":"@tags","definition":"my"},{"name":"$node","kind":13,"containerName":"_write_tree_Helper","line":323},{"name":"get_all_tags","kind":12,"containerName":"_write_tree_Helper","line":323},{"kind":13,"containerName":"_write_tree_Helper","name":"$node","line":324},{"line":324,"name":"ancestor","containerName":"_write_tree_Helper","kind":12},{"name":"@tags","containerName":"_write_tree_Helper","kind":13,"line":324},{"kind":13,"containerName":"_write_tree_Helper","name":"$data","line":325},{"line":327,"name":"$node","kind":13,"containerName":"_write_tree_Helper"},{"containerName":"_write_tree_Helper","kind":12,"name":"get_tag_values","line":327},{"line":328,"kind":13,"containerName":"_write_tree_Helper","name":"@tags"},{"line":331,"name":"$nl","containerName":"_write_tree_Helper","kind":13},{"name":"$data","containerName":"_write_tree_Helper","kind":13,"line":332},{"kind":13,"containerName":"_write_tree_Helper","name":"$data","line":332},{"line":333,"name":"$data","containerName":"_write_tree_Helper","kind":13},{"line":335,"containerName":"_write_tree_Helper","kind":13,"name":"$data"},{"containerName":"_write_tree_Helper","kind":13,"name":"$data","line":335},{"name":"$data","kind":13,"containerName":"_write_tree_Helper","line":336},{"containerName":"_write_tree_Helper","kind":13,"name":"@data","line":340},{"line":340,"containerName":"_write_tree_Helper","kind":13,"name":"$node"},{"line":340,"name":"to_string","kind":12,"containerName":"_write_tree_Helper"},{"name":"@data","containerName":"_write_tree_Helper","kind":13,"line":342}],"name":"_write_tree_Helper","containerName":"main::"}]}