{"version":5,"vars":[{"line":90,"name":"base","containerName":"","kind":2},{"range":{"start":{"character":0,"line":102},"end":{"character":9999,"line":114}},"kind":12,"line":102,"containerName":"main::","name":"_initialize","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"_initialize","name":"$self","line":103},{"line":104,"kind":13,"containerName":"_initialize","name":"$self"},{"line":105,"localvar":"my","kind":13,"containerName":"_initialize","name":"$hdr","definition":"my"},{"name":"$trans","containerName":"_initialize","kind":13,"line":105},{"name":"$self","containerName":"_initialize","kind":13,"line":105},{"kind":12,"containerName":"_initialize","name":"_rearrange","line":105},{"name":"$self","containerName":"_initialize","kind":13,"line":112},{"line":112,"name":"header","containerName":"_initialize","kind":12},{"line":112,"name":"$hdr","containerName":"_initialize","kind":13},{"containerName":"_initialize","kind":13,"name":"$hdr","line":112},{"name":"$self","containerName":"_initialize","kind":13,"line":113},{"line":113,"containerName":"_initialize","kind":12,"name":"translate_node"},{"line":113,"name":"$trans","containerName":"_initialize","kind":13},{"line":113,"containerName":"_initialize","kind":13,"name":"$trans"}],"definition":"sub"},{"containerName":"_initialize","kind":12,"name":"SUPER","line":104},{"line":127,"range":{"start":{"character":0,"line":127},"end":{"line":133,"character":9999}},"kind":12,"signature":{"label":"next_tree($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: nexus.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO::nexus\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-open-bio-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO::nexus - A TreeIO driver module for parsing Nexus tree output from PAUP\n\n=head1 SYNOPSIS\n\n  use Bio::TreeIO;\n  my $in = Bio::TreeIO->new(-file => 't/data/cat_tre.tre');\n  while( my $tree = $in->next_tree ) {\n  }\n\n=head1 DESCRIPTION\n\nThis is a driver module for parsing PAUP Nexus tree format which\nbasically is just a remapping of trees.\n\n=head2 Comments\n\nThe nexus format allows node comments that are placed inside square\nbrackets. Usually the comments (implemented as tags for nodes) are\nused to give a name for an internal node or record the bootstap value,\nbut other uses are possible.\n\nThe FigTree program by Andrew Rambaut adds various rendering\nparameters inside comments and flags these comments by starting them\nwith '&!'. The parameters implemented here are 'label' and 'color'.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-open-bio-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::TreeIO::nexus;\nuse strict;\n\nuse Bio::Event::EventGeneratorI;\nuse IO::String;\n\nuse base qw(Bio::TreeIO);\n\n=head2 new\n\n Title   : new\n Args    : -header    => boolean  default is true \n                         print/do not print #NEXUS header\n           -translate => boolean default is true\n                         print/do not print Node Id translation to a number\n\n\nsub _initialize {\n    my $self = shift;\n    $self->SUPER::_initialize(@_);\n    my ( $hdr, $trans ) = $self->_rearrange(\n        [\n            qw(HEADER\n              TRANSLATE)\n        ],\n        @_\n    );\n    $self->header( defined $hdr           ? $hdr   : 1 );\n    $self->translate_node( defined $trans ? $trans : 1 );\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $treeio->next_tree\n Function: Gets the next tree in the stream\n Returns : Bio::Tree::TreeI\n Args    : none"},"children":[{"line":128,"containerName":"next_tree","localvar":"my","kind":13,"name":"$self","definition":"my"},{"name":"$self","kind":13,"containerName":"next_tree","line":129},{"line":130,"name":"$self","kind":13,"containerName":"next_tree"},{"name":"_parse","kind":12,"containerName":"next_tree","line":130},{"containerName":"next_tree","kind":13,"name":"$self","line":132},{"line":132,"containerName":"next_tree","kind":13,"name":"$self"}],"containerName":"main::","name":"next_tree","definition":"sub","detail":"($self)"},{"kind":12,"range":{"start":{"line":135,"character":0},"end":{"character":9999,"line":137}},"line":135,"definition":"sub","containerName":"main::","name":"rewind","children":[]},{"line":139,"kind":12,"range":{"start":{"line":139,"character":0},"end":{"line":217,"character":9999}},"signature":{"label":"_parse($self)","parameters":[{"label":"$self"}],"documentation":""},"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"_parse","line":140,"definition":"my"},{"line":142,"name":"$self","containerName":"_parse","kind":13},{"name":"$self","containerName":"_parse","kind":13,"line":143},{"name":"$self","containerName":"_parse","kind":13,"line":145},{"line":145,"name":"_readline","containerName":"_parse","kind":12},{"line":152,"name":"$self","kind":13,"containerName":"_parse"},{"name":"warn","containerName":"_parse","kind":12,"line":152},{"definition":"my","localvar":"my","kind":13,"containerName":"_parse","name":"$line","line":156},{"name":"$self","kind":13,"containerName":"_parse","line":157},{"line":157,"containerName":"_parse","kind":12,"name":"_readline"},{"line":158,"kind":13,"containerName":"_parse","name":"$line"},{"definition":"my","line":160,"name":"@sections","localvar":"my","containerName":"_parse","kind":13},{"name":"$line","kind":13,"containerName":"_parse","line":160},{"name":"$s","localvar":"my","kind":13,"containerName":"_parse","line":161,"definition":"my"},{"line":161,"name":"@sections","kind":13,"containerName":"_parse"},{"definition":"my","name":"%translate","localvar":"my","containerName":"_parse","kind":13,"line":162},{"name":"$self","kind":13,"containerName":"_parse","line":163},{"line":163,"name":"verbose","containerName":"_parse","kind":12},{"name":"$s","kind":13,"containerName":"_parse","line":164},{"name":"$self","kind":13,"containerName":"_parse","line":165},{"name":"debug","containerName":"_parse","kind":12,"line":165},{"kind":13,"containerName":"_parse","name":"$s","line":169},{"line":172,"kind":13,"containerName":"_parse","name":"$s"},{"definition":"my","kind":13,"localvar":"my","containerName":"_parse","name":"$trees","line":173},{"line":174,"kind":13,"containerName":"_parse","name":"$trees"},{"line":175,"kind":13,"localvar":"my","containerName":"_parse","name":"@trans","definition":"my"},{"definition":"my","name":"$tr","localvar":"my","containerName":"_parse","kind":13,"line":176},{"kind":13,"containerName":"_parse","name":"$tr","line":178},{"line":179,"name":"@trans","containerName":"_parse","kind":13},{"localvar":"my","kind":13,"containerName":"_parse","name":"$n","line":181,"definition":"my"},{"containerName":"_parse","kind":13,"name":"@trans","line":181},{"line":182,"name":"$n","kind":13,"containerName":"_parse"},{"definition":"my","name":"$id","localvar":"my","containerName":"_parse","kind":13,"line":183},{"line":183,"name":"$tag","containerName":"_parse","kind":13},{"kind":13,"containerName":"_parse","name":"$tag","line":184},{"line":185,"name":"$translate","kind":13,"containerName":"_parse"},{"line":185,"containerName":"_parse","kind":13,"name":"$id"},{"containerName":"_parse","kind":13,"name":"$tag","line":185},{"line":190,"kind":13,"containerName":"_parse","name":"$self"},{"name":"debug","containerName":"_parse","kind":12,"line":190},{"name":"$trees","containerName":"_parse","kind":13,"line":192},{"definition":"my","line":195,"containerName":"_parse","localvar":"my","kind":13,"name":"$tree_name"},{"line":195,"containerName":"_parse","kind":13,"name":"$tree_str"},{"name":"$buf","localvar":"my","kind":13,"containerName":"_parse","line":199,"definition":"my"},{"line":199,"name":"new","containerName":"_parse","kind":12},{"line":199,"name":"$tree_str","kind":13,"containerName":"_parse"},{"line":200,"kind":13,"localvar":"my","containerName":"_parse","name":"$treeio","definition":"my"},{"name":"new","containerName":"_parse","kind":12,"line":200},{"line":203,"name":"$buf","kind":13,"containerName":"_parse"},{"definition":"my","name":"$tree","localvar":"my","kind":13,"containerName":"_parse","line":204},{"containerName":"_parse","kind":13,"name":"$treeio","line":204},{"line":204,"name":"next_tree","containerName":"_parse","kind":12},{"definition":"my","line":205,"name":"$node","localvar":"my","containerName":"_parse","kind":13},{"kind":12,"containerName":"_parse","name":"is_Leaf","line":205},{"line":205,"name":"$tree","containerName":"_parse","kind":13},{"line":205,"kind":12,"containerName":"_parse","name":"get_nodes"},{"definition":"my","line":206,"name":"$id","containerName":"_parse","localvar":"my","kind":13},{"line":206,"name":"$node","containerName":"_parse","kind":13},{"kind":12,"containerName":"_parse","name":"id","line":206},{"localvar":"my","containerName":"_parse","kind":13,"name":"$lookup","line":207,"definition":"my"},{"name":"$translate","kind":13,"containerName":"_parse","line":207},{"line":207,"kind":13,"containerName":"_parse","name":"$id"},{"containerName":"_parse","kind":13,"name":"$node","line":208},{"line":208,"name":"id","kind":12,"containerName":"_parse"},{"name":"$lookup","containerName":"_parse","kind":13,"line":208},{"containerName":"_parse","kind":13,"name":"$id","line":208},{"line":210,"name":"$tree","kind":13,"containerName":"_parse"},{"line":210,"containerName":"_parse","kind":12,"name":"id"},{"line":210,"kind":13,"containerName":"_parse","name":"$tree_name"},{"name":"$tree_name","kind":13,"containerName":"_parse","line":210},{"name":"$self","containerName":"_parse","kind":13,"line":211},{"line":211,"name":"$tree","kind":13,"containerName":"_parse"},{"line":215,"kind":13,"containerName":"_parse","name":"$self"},{"line":215,"kind":12,"containerName":"_parse","name":"debug"}],"name":"_parse","containerName":"main::","definition":"sub","detail":"($self)"},{"line":199,"kind":12,"containerName":"String","name":"IO"},{"line":200,"containerName":"TreeIO","kind":12,"name":"Bio"},{"line":218,"kind":13,"containerName":null,"name":"@sections"},{"line":219,"name":"$self","kind":13,"containerName":null},{"line":219,"name":"debug","kind":12,"containerName":"main::"},{"containerName":"main::","name":"write_tree","children":[{"definition":"my","name":"$self","containerName":"write_tree","localvar":"my","kind":13,"line":235},{"line":235,"containerName":"write_tree","kind":13,"name":"@trees"},{"line":236,"containerName":"write_tree","kind":13,"name":"$self"},{"line":236,"containerName":"write_tree","kind":12,"name":"header"},{"line":237,"containerName":"write_tree","kind":13,"name":"$self"},{"line":237,"name":"_print","kind":12,"containerName":"write_tree"},{"line":239,"localvar":"my","kind":13,"containerName":"write_tree","name":"$translate","definition":"my"},{"containerName":"write_tree","kind":13,"name":"$self","line":239},{"line":239,"kind":12,"containerName":"write_tree","name":"translate_node"},{"localvar":"my","containerName":"write_tree","kind":13,"name":"$time","line":240,"definition":"my"},{"line":241,"name":"$self","containerName":"write_tree","kind":13},{"line":241,"name":"_print","kind":12,"containerName":"write_tree"},{"line":241,"name":"$time","containerName":"write_tree","kind":13},{"line":243,"name":"$first","localvar":"my","kind":13,"containerName":"write_tree","definition":"my"},{"line":243,"name":"$nodecter","kind":13,"containerName":"write_tree"},{"line":243,"containerName":"write_tree","kind":13,"name":"%node2num"},{"definition":"my","line":244,"kind":13,"localvar":"my","containerName":"write_tree","name":"$tree"},{"kind":13,"containerName":"write_tree","name":"@trees","line":244},{"name":"$first","containerName":"write_tree","kind":13,"line":246},{"containerName":"write_tree","kind":13,"name":"$translate","line":247},{"line":249,"name":"$self","kind":13,"containerName":"write_tree"},{"line":249,"kind":12,"containerName":"write_tree","name":"_print"},{"line":250,"containerName":"write_tree","kind":13,"name":"$self"},{"containerName":"write_tree","kind":12,"name":"_print","line":250},{"containerName":"write_tree","kind":13,"name":"$node2num","line":254},{"name":"id","containerName":"write_tree","kind":12,"line":254},{"line":254,"name":"$nodecter","kind":13,"containerName":"write_tree"},{"kind":13,"containerName":"write_tree","name":"$nodecter","line":255},{"name":"id","containerName":"write_tree","kind":12,"line":255},{"line":257,"containerName":"write_tree","kind":12,"name":"is_Leaf"},{"kind":13,"containerName":"write_tree","name":"$tree","line":257},{"containerName":"write_tree","kind":12,"name":"get_nodes","line":258},{"localvar":"my","containerName":"write_tree","kind":13,"name":"@data","line":262,"definition":"my"},{"name":"$tree","kind":13,"containerName":"write_tree","line":262},{"line":262,"name":"get_root_node","kind":12,"containerName":"write_tree"},{"name":"%node2num","kind":13,"containerName":"write_tree","line":262},{"line":263,"kind":13,"containerName":"write_tree","name":"$data"},{"line":264,"kind":13,"containerName":"write_tree","name":"$data"},{"line":264,"kind":13,"containerName":"write_tree","name":"$data"},{"kind":13,"containerName":"write_tree","name":"$data","line":265},{"line":270,"name":"$self","containerName":"write_tree","kind":13},{"name":"_print","kind":12,"containerName":"write_tree","line":270},{"kind":13,"containerName":"write_tree","name":"$tree","line":273},{"containerName":"write_tree","kind":12,"name":"id","line":273},{"line":273,"kind":13,"containerName":"write_tree","name":"$first"},{"name":"$tree","kind":13,"containerName":"write_tree","line":274},{"line":274,"name":"get_root_node","containerName":"write_tree","kind":12},{"kind":13,"containerName":"write_tree","name":"@data","line":275},{"name":"$first","kind":13,"containerName":"write_tree","line":278},{"name":"$self","kind":13,"containerName":"write_tree","line":280},{"line":280,"containerName":"write_tree","kind":12,"name":"_print"},{"line":281,"name":"$self","containerName":"write_tree","kind":13},{"line":281,"name":"flush","containerName":"write_tree","kind":12},{"line":281,"kind":13,"containerName":"write_tree","name":"$self"},{"containerName":"write_tree","kind":12,"name":"_flush_on_write","line":281},{"name":"$self","containerName":"write_tree","kind":13,"line":281},{"line":281,"name":"_fh","containerName":"write_tree","kind":12}],"detail":"($self,@trees)","definition":"sub","range":{"end":{"character":9999,"line":283},"start":{"line":234,"character":0}},"kind":12,"line":234,"signature":{"documentation":"1;\n# $Id: nexus.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO::nexus\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-open-bio-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO::nexus - A TreeIO driver module for parsing Nexus tree output from PAUP\n\n=head1 SYNOPSIS\n\n  use Bio::TreeIO;\n  my $in = Bio::TreeIO->new(-file => 't/data/cat_tre.tre');\n  while( my $tree = $in->next_tree ) {\n  }\n\n=head1 DESCRIPTION\n\nThis is a driver module for parsing PAUP Nexus tree format which\nbasically is just a remapping of trees.\n\n=head2 Comments\n\nThe nexus format allows node comments that are placed inside square\nbrackets. Usually the comments (implemented as tags for nodes) are\nused to give a name for an internal node or record the bootstap value,\nbut other uses are possible.\n\nThe FigTree program by Andrew Rambaut adds various rendering\nparameters inside comments and flags these comments by starting them\nwith '&!'. The parameters implemented here are 'label' and 'color'.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-open-bio-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::TreeIO::nexus;\nuse strict;\n\nuse Bio::Event::EventGeneratorI;\nuse IO::String;\n\nuse base qw(Bio::TreeIO);\n\n=head2 new\n\n Title   : new\n Args    : -header    => boolean  default is true \n                         print/do not print #NEXUS header\n           -translate => boolean default is true\n                         print/do not print Node Id translation to a number\n\n\nsub _initialize {\n    my $self = shift;\n    $self->SUPER::_initialize(@_);\n    my ( $hdr, $trans ) = $self->_rearrange(\n        [\n            qw(HEADER\n              TRANSLATE)\n        ],\n        @_\n    );\n    $self->header( defined $hdr           ? $hdr   : 1 );\n    $self->translate_node( defined $trans ? $trans : 1 );\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $treeio->next_tree\n Function: Gets the next tree in the stream\n Returns : Bio::Tree::TreeI\n Args    : none\n\n\n\nsub next_tree {\n    my ($self) = @_;\n    unless ( $self->{'_parsed'} ) {\n        $self->_parse;\n    }\n    return $self->{'_trees'}->[ $self->{'_treeiter'}++ ];\n}\n\nsub rewind {\n    shift->{'_treeiter'} = 0;\n}\n\nsub _parse {\n    my ($self) = @_;\n\n    $self->{'_parsed'}   = 1;\n    $self->{'_treeiter'} = 0;\n\n    while ( defined( $_ = $self->_readline ) ) {\n        next if /^\\s+$/;\n        last;\n    }\n    return unless ( defined $_ );\n\n    unless (/^\\#NEXUS/i) {\n        $self->warn(\"File does not start with #NEXUS\");    #'\n        return;\n    }\n\n    my $line;\n    while ( defined( $_ = $self->_readline ) ) {\n        $line .= $_;\n    }\n    my @sections = split( /#NEXUS/i, $line );\n    for my $s (@sections) {\n        my %translate;        \n        if ( $self->verbose > 0 ) {\n            while ( $s =~ s/(\\[[^\\]]+\\])// ) {\n                $self->debug(\"removing comment $1\\n\");\n            }\n        }\n        else {\n            $s =~ s/(\\[[^\\]]+\\])//g;\n        }\n        \n        if ( $s =~ /begin trees;(.+)(end;)?/si ) {\n            my $trees = $1;\n            if ( $trees =~ s/\\s+translate\\s+([^;]+);//i ) {\n                my @trans;\n                my $tr = $1;\n\n                while ($tr =~ m{\\s*([^,\\s]+?\\s+(?:'[^']+'|[^'\\s]+)),?}gc) {\n\t            push @trans, $1;\n                }\n                for my $n ( @trans ) {\n                    if ($n  =~ /^\\s*(\\S+)\\s+(.+)$/) {\n                        my ($id,$tag) = ($1,$2);\n                        $tag =~ s/[\\s,]+$//;  # remove the extra spaces of the last taxon\n                        $translate{$id} = $tag;\n                    }                    \n                }\n            }\n            else {\n                $self->debug(\"no translate in: $trees\\n\");\n            }\n            while ($trees =~ /\\s+tree\\s+\\*?\\s*(\\S+)\\s*\\=\n             \\s*(?:\\[\\S+\\])?\\s*([^\\;]+;)/igx)\n            {\n                my ( $tree_name, $tree_str ) = ( $1, $2 );\n\n                # MrBayes does not print colons for node label\n                # $tree_str =~ s/\\)(\\d*\\.\\d+)\\)/:$1/g;\n                my $buf    = IO::String->new($tree_str);\n                my $treeio = Bio::TreeIO->new(\n                    -format => 'newick',\n                    -fh     => $buf\n                );\n                my $tree = $treeio->next_tree;\n                foreach my $node ( grep { $_->is_Leaf } $tree->get_nodes ) {\n                    my $id     = $node->id;\n                    my $lookup = $translate{$id};\n                    $node->id( $lookup || $id );\n                }\n                $tree->id($tree_name) if defined $tree_name;\n                push @{ $self->{'_trees'} }, $tree;\n            }\n        }\n        else {\n            $self->debug(\"begin_trees failed: $s\\n\");\n        }\n    }\n    if ( !@sections ) {\n        $self->debug(\"warn no sections: $line\\n\");\n    }\n}\n\n=head2 write_tree\n\n Title   : write_tree\n Usage   : $treeio->write_tree($tree);\n Function: Writes a tree onto the stream\n Returns : none\n Args    : Bio::Tree::TreeI","parameters":[{"label":"$self"},{"label":"@trees"}],"label":"write_tree($self,@trees)"}},{"line":262,"kind":12,"name":"_write_tree_Helper"},{"children":[{"definition":"my","line":286,"name":"$node","containerName":"_write_tree_Helper","localvar":"my","kind":13},{"name":"$node2num","containerName":"_write_tree_Helper","kind":13,"line":286},{"containerName":"_write_tree_Helper","kind":13,"name":"$node","line":287},{"definition":"my","line":288,"containerName":"_write_tree_Helper","localvar":"my","kind":13,"name":"@data"},{"name":"$n","localvar":"my","containerName":"_write_tree_Helper","kind":13,"line":290,"definition":"my"},{"line":290,"name":"$node","containerName":"_write_tree_Helper","kind":13},{"line":290,"name":"each_Descendent","kind":12,"containerName":"_write_tree_Helper"},{"name":"@data","containerName":"_write_tree_Helper","kind":13,"line":291},{"kind":13,"containerName":"_write_tree_Helper","name":"$n","line":291},{"line":291,"name":"$node2num","containerName":"_write_tree_Helper","kind":13},{"line":293,"name":"@data","kind":13,"containerName":"_write_tree_Helper"},{"line":294,"name":"$data","containerName":"_write_tree_Helper","kind":13},{"line":294,"name":"$data","kind":13,"containerName":"_write_tree_Helper"},{"line":295,"name":"$data","kind":13,"containerName":"_write_tree_Helper"},{"definition":"my","line":298,"localvar":"my","kind":13,"containerName":"_write_tree_Helper","name":"$b"},{"containerName":"_write_tree_Helper","localvar":"my","kind":13,"name":"$bl","line":300,"definition":"my"},{"line":300,"kind":13,"containerName":"_write_tree_Helper","name":"$node"},{"line":300,"name":"branch_length","containerName":"_write_tree_Helper","kind":12},{"line":301,"name":"$bl","containerName":"_write_tree_Helper","kind":13},{"line":303,"containerName":"_write_tree_Helper","kind":13,"name":"$bl"},{"line":304,"name":"$data","containerName":"_write_tree_Helper","kind":13},{"line":304,"name":"$bl","kind":13,"containerName":"_write_tree_Helper"},{"name":"$data","kind":13,"containerName":"_write_tree_Helper","line":307},{"name":"$b","containerName":"_write_tree_Helper","kind":13,"line":309},{"name":"$node","containerName":"_write_tree_Helper","kind":13,"line":309},{"kind":12,"containerName":"_write_tree_Helper","name":"bootstrap","line":309},{"line":310,"kind":13,"containerName":"_write_tree_Helper","name":"$data"},{"containerName":"_write_tree_Helper","kind":13,"name":"$b","line":310},{"line":312,"kind":13,"containerName":"_write_tree_Helper","name":"$b"},{"line":312,"containerName":"_write_tree_Helper","kind":13,"name":"$node"},{"kind":12,"containerName":"_write_tree_Helper","name":"id","line":312},{"line":313,"name":"$b","kind":13,"containerName":"_write_tree_Helper"},{"line":313,"name":"$node2num","containerName":"_write_tree_Helper","kind":13},{"kind":13,"containerName":"_write_tree_Helper","name":"$b","line":313},{"line":313,"name":"$node2num","containerName":"_write_tree_Helper","kind":13},{"line":313,"name":"$b","containerName":"_write_tree_Helper","kind":13},{"line":314,"kind":13,"containerName":"_write_tree_Helper","name":"$data"},{"line":314,"containerName":"_write_tree_Helper","kind":13,"name":"$b"},{"kind":13,"containerName":"_write_tree_Helper","name":"$b","line":314},{"definition":"my","line":318,"containerName":"_write_tree_Helper","localvar":"my","kind":13,"name":"$comment_flag"},{"name":"$comment_flag","containerName":"_write_tree_Helper","kind":13,"line":319},{"line":320,"name":"$node","kind":13,"containerName":"_write_tree_Helper"},{"line":320,"name":"has_tag","containerName":"_write_tree_Helper","kind":12},{"line":320,"kind":13,"containerName":"_write_tree_Helper","name":"$node"},{"line":320,"name":"has_tag","kind":12,"containerName":"_write_tree_Helper"},{"line":322,"name":"$data","containerName":"_write_tree_Helper","kind":13},{"name":"$comment_flag","containerName":"_write_tree_Helper","kind":13,"line":322},{"kind":13,"containerName":"_write_tree_Helper","name":"$node","line":324},{"containerName":"_write_tree_Helper","kind":12,"name":"has_tag","line":324},{"definition":"my","localvar":"my","kind":13,"containerName":"_write_tree_Helper","name":"$color","line":325},{"line":325,"kind":13,"containerName":"_write_tree_Helper","name":"$node"},{"line":325,"kind":12,"containerName":"_write_tree_Helper","name":"get_tag_values"},{"line":326,"name":"$data","containerName":"_write_tree_Helper","kind":13},{"kind":13,"containerName":"_write_tree_Helper","name":"$comment_flag","line":327},{"name":"$node","containerName":"_write_tree_Helper","kind":13,"line":329},{"line":329,"kind":12,"containerName":"_write_tree_Helper","name":"has_tag"},{"definition":"my","name":"$label","containerName":"_write_tree_Helper","localvar":"my","kind":13,"line":330},{"line":330,"name":"$node","kind":13,"containerName":"_write_tree_Helper"},{"line":330,"kind":12,"containerName":"_write_tree_Helper","name":"get_tag_values"},{"containerName":"_write_tree_Helper","kind":13,"name":"$data","line":331},{"line":331,"containerName":"_write_tree_Helper","kind":13,"name":"$comment_flag"},{"kind":13,"containerName":"_write_tree_Helper","name":"$data","line":332},{"line":332,"containerName":"_write_tree_Helper","kind":13,"name":"$label"},{"name":"$data","containerName":"_write_tree_Helper","kind":13,"line":334},{"name":"$comment_flag","containerName":"_write_tree_Helper","kind":13,"line":334},{"line":340,"kind":13,"containerName":"_write_tree_Helper","name":"$node"},{"line":340,"containerName":"_write_tree_Helper","kind":12,"name":"id"},{"line":340,"kind":13,"containerName":"_write_tree_Helper","name":"$node"},{"line":340,"containerName":"_write_tree_Helper","kind":12,"name":"branch_length"},{"definition":"my","localvar":"my","kind":13,"containerName":"_write_tree_Helper","name":"$id","line":341},{"line":341,"kind":13,"containerName":"_write_tree_Helper","name":"$node"},{"name":"id","kind":12,"containerName":"_write_tree_Helper","line":341},{"name":"$node","kind":13,"containerName":"_write_tree_Helper","line":341},{"name":"id","containerName":"_write_tree_Helper","kind":12,"line":341},{"line":342,"name":"$id","containerName":"_write_tree_Helper","kind":13},{"line":342,"kind":13,"containerName":"_write_tree_Helper","name":"$node2num"},{"name":"$id","kind":13,"containerName":"_write_tree_Helper","line":342},{"line":343,"containerName":"_write_tree_Helper","kind":13,"name":"$id"},{"containerName":"_write_tree_Helper","kind":13,"name":"$node2num","line":343},{"line":343,"name":"$id","containerName":"_write_tree_Helper","kind":13},{"line":345,"name":"$node","containerName":"_write_tree_Helper","kind":13},{"line":345,"name":"has_tag","kind":12,"containerName":"_write_tree_Helper"},{"definition":"my","localvar":"my","kind":13,"containerName":"_write_tree_Helper","name":"$color","line":346},{"containerName":"_write_tree_Helper","kind":13,"name":"$node","line":346},{"kind":12,"containerName":"_write_tree_Helper","name":"get_tag_values","line":346},{"kind":13,"containerName":"_write_tree_Helper","name":"$id","line":347},{"line":349,"containerName":"_write_tree_Helper","kind":13,"name":"@data"},{"line":351,"name":"$id","kind":13,"containerName":"_write_tree_Helper"},{"containerName":"_write_tree_Helper","kind":13,"name":"$node","line":352},{"line":353,"name":"branch_length","kind":12,"containerName":"_write_tree_Helper"},{"kind":13,"containerName":"_write_tree_Helper","name":"$node","line":353},{"line":354,"name":"branch_length","containerName":"_write_tree_Helper","kind":12},{"line":357,"kind":13,"containerName":"_write_tree_Helper","name":"@data"}],"name":"_write_tree_Helper","containerName":"main::","definition":"sub","detail":"($node,$node2num)","line":285,"range":{"start":{"line":285,"character":0},"end":{"character":9999,"line":358}},"kind":12,"signature":{"documentation":"","parameters":[{"label":"$node"},{"label":"$node2num"}],"label":"_write_tree_Helper($node,$node2num)"}},{"definition":"sub","children":[{"line":373,"name":"$self","localvar":"my","kind":13,"containerName":"header","definition":"my"},{"name":"$self","kind":13,"containerName":"header","line":375},{"containerName":"header","kind":13,"name":"$self","line":376}],"containerName":"main::","name":"header","line":372,"range":{"start":{"line":372,"character":0},"end":{"line":377,"character":9999}},"kind":12},{"definition":"sub","name":"translate_node","containerName":"main::","children":[{"definition":"my","line":392,"name":"$self","localvar":"my","kind":13,"containerName":"translate_node"},{"containerName":"translate_node","kind":13,"name":"$self","line":394},{"name":"$self","kind":13,"containerName":"translate_node","line":395}],"kind":12,"range":{"start":{"character":0,"line":391},"end":{"line":396,"character":9999}},"line":391}]}