{"version":5,"vars":[{"name":"base","kind":2,"containerName":"","line":91},{"children":[{"line":106,"containerName":"_initialize","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":107,"name":"$self","containerName":"_initialize","kind":13},{"containerName":"_initialize","kind":13,"name":"$self","line":107},{"name":"$self","kind":13,"containerName":"_initialize","line":108},{"line":108,"containerName":"_initialize","kind":13,"name":"$self"},{"line":108,"name":"_rearrange","kind":12,"containerName":"_initialize"},{"line":111,"name":"$self","kind":13,"containerName":"_initialize"}],"containerName":"main::","name":"_initialize","definition":"sub","line":105,"range":{"start":{"character":0,"line":105},"end":{"character":9999,"line":112}},"kind":12},{"line":107,"name":"_result","kind":12},{"name":"_linkdist","kind":12,"line":107},{"name":"_labels","kind":12,"line":108},{"line":111,"name":"SUPER","containerName":"_initialize","kind":12},{"signature":{"label":"next_tree($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: cluster.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO::cluster\n#\n# Contributed by Guillaume Rousse <Guillaume-dot-Rousse-at-inria-dot-fr>\n#\n# Copyright INRIA\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO::cluster - A TreeIO driver module for parsing Algorithm::Cluster::treecluster() output\n\n=head1 SYNOPSIS\n\n  # do not use this module directly\n  use Bio::TreeIO;\n  use Algorithm::Cluster;\n  my ($result, $linkdist) = Algorithm::Cluster::treecluster(\n    distances => $matrix\n  );\n  my $treeio = Bio::TreeIO->new(\n    -format   => 'cluster',\n    -result   =>  $result,\n    -linkdist =>  $linkdist,\n    -labels   =>  $labels\n  );\n  my $tree = $treeio->next_tree;\n\n=head1 DESCRIPTION\n\nThis is a driver module for parsing Algorithm::Cluster::treecluster() output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Guillaume Rousse\n\nEmail Guillaume-dot-Rousse-at-inria-dot-fr\n\n=head1 CONTRIBUTORS\n\nJason Stajich - jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO::cluster;\nuse strict;\n\nuse Bio::Event::EventGeneratorI;\nuse IO::String;\n\nuse base qw(Bio::TreeIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::TreeIO::cluster->new();\n Function: Builds a new Bio::TreeIO::cluster object for reading Algorithm::Cluster::treecluster output\n Returns : Bio::TreeIO::cluster\n Args    :-result   => Algorithm::Cluster result\n          -linkdist => distance between links\n          -labels   => node labels\n\n\nsub _initialize {\n  my $self = shift;\n  ($self->{_result},$self->{_linkdist},\n   $self->{_labels}) = $self->_rearrange([qw\n\t\t\t\t\t  (RESULT LINKDIST LABELS)],\n\t\t\t\t\t @_);\n  $self->SUPER::_initialize(@_);\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $treeio->next_tree\n Function: Gets the next tree in the stream\n Returns : Bio::Tree::TreeI\n Args    : none"},"line":125,"range":{"start":{"character":0,"line":125},"end":{"line":140,"character":9999}},"kind":12,"definition":"sub","detail":"($self)","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"next_tree","name":"$self","line":126},{"name":"$self","kind":13,"containerName":"next_tree","line":127},{"line":128,"name":"$self","containerName":"next_tree","kind":13},{"line":128,"containerName":"next_tree","kind":12,"name":"warn"},{"line":131,"name":"$self","kind":13,"containerName":"next_tree"},{"line":131,"name":"_eventHandler","kind":12,"containerName":"next_tree"},{"line":131,"name":"start_document","containerName":"next_tree","kind":12},{"name":"$self","containerName":"next_tree","kind":13,"line":134},{"line":134,"kind":12,"containerName":"next_tree","name":"_eventHandler"},{"name":"start_element","containerName":"next_tree","kind":12,"line":134},{"name":"$self","containerName":"next_tree","kind":13,"line":135},{"line":135,"name":"_recurse","containerName":"next_tree","kind":12},{"kind":13,"containerName":"next_tree","name":"$self","line":136},{"name":"_recurse","kind":12,"containerName":"next_tree","line":136},{"line":137,"name":"$self","kind":13,"containerName":"next_tree"},{"line":137,"name":"_eventHandler","containerName":"next_tree","kind":12},{"name":"end_element","containerName":"next_tree","kind":12,"line":137},{"name":"$self","containerName":"next_tree","kind":13,"line":139},{"name":"_eventHandler","kind":12,"containerName":"next_tree","line":139},{"kind":12,"containerName":"next_tree","name":"end_document","line":139}],"name":"next_tree","containerName":"main::"},{"name":"_result","kind":12,"line":127},{"line":134,"kind":12,"name":"Name"},{"line":137,"name":"Name","kind":12},{"line":142,"kind":12,"range":{"start":{"character":0,"line":142},"end":{"character":9999,"line":181}},"signature":{"label":"_recurse($self,$line,$column)","parameters":[{"label":"$self"},{"label":"$line"},{"label":"$column"}],"documentation":""},"children":[{"name":"$self","containerName":"_recurse","localvar":"my","kind":13,"line":143,"definition":"my"},{"line":143,"containerName":"_recurse","kind":13,"name":"$line"},{"line":143,"kind":13,"containerName":"_recurse","name":"$column"},{"definition":"my","line":145,"kind":13,"localvar":"my","containerName":"_recurse","name":"$id"},{"name":"$self","kind":13,"containerName":"_recurse","line":145},{"line":145,"name":"$line","containerName":"_recurse","kind":13},{"line":145,"name":"$column","kind":13,"containerName":"_recurse"},{"kind":13,"containerName":"_recurse","name":"$id","line":146},{"name":"$self","kind":13,"containerName":"_recurse","line":148},{"line":148,"name":"debug","containerName":"_recurse","kind":12},{"name":"$self","containerName":"_recurse","kind":13,"line":149},{"name":"debug","containerName":"_recurse","kind":12,"line":149},{"kind":13,"containerName":"_recurse","name":"$self","line":150},{"name":"debug","containerName":"_recurse","kind":12,"line":150},{"line":151,"name":"$self","kind":13,"containerName":"_recurse"},{"kind":12,"containerName":"_recurse","name":"_eventHandler","line":151},{"containerName":"_recurse","kind":12,"name":"start_element","line":151},{"name":"$self","kind":13,"containerName":"_recurse","line":152},{"line":152,"name":"_eventHandler","kind":12,"containerName":"_recurse"},{"line":152,"kind":12,"containerName":"_recurse","name":"start_element"},{"kind":13,"containerName":"_recurse","name":"$self","line":153},{"containerName":"_recurse","kind":12,"name":"_eventHandler","line":153},{"line":153,"name":"characters","containerName":"_recurse","kind":12},{"line":153,"name":"$self","containerName":"_recurse","kind":13},{"line":153,"containerName":"_recurse","kind":13,"name":"$line"},{"line":154,"containerName":"_recurse","kind":13,"name":"$self"},{"line":154,"name":"_eventHandler","containerName":"_recurse","kind":12},{"line":154,"name":"end_element","kind":12,"containerName":"_recurse"},{"line":155,"name":"$self","kind":13,"containerName":"_recurse"},{"name":"_eventHandler","kind":12,"containerName":"_recurse","line":155},{"line":155,"kind":12,"containerName":"_recurse","name":"start_element"},{"line":156,"name":"$self","containerName":"_recurse","kind":13},{"containerName":"_recurse","kind":12,"name":"_eventHandler","line":156},{"name":"characters","containerName":"_recurse","kind":12,"line":156},{"containerName":"_recurse","kind":13,"name":"$self","line":156},{"line":156,"name":"$id","kind":13,"containerName":"_recurse"},{"line":157,"containerName":"_recurse","kind":13,"name":"$self"},{"name":"_eventHandler","containerName":"_recurse","kind":12,"line":157},{"line":157,"kind":12,"containerName":"_recurse","name":"end_element"},{"containerName":"_recurse","kind":13,"name":"$self","line":158},{"line":158,"name":"_eventHandler","containerName":"_recurse","kind":12},{"name":"start_element","kind":12,"containerName":"_recurse","line":158},{"kind":13,"containerName":"_recurse","name":"$self","line":159},{"name":"_eventHandler","containerName":"_recurse","kind":12,"line":159},{"line":159,"kind":12,"containerName":"_recurse","name":"characters"},{"line":160,"containerName":"_recurse","kind":13,"name":"$self"},{"kind":12,"containerName":"_recurse","name":"_eventHandler","line":160},{"containerName":"_recurse","kind":12,"name":"end_element","line":160},{"name":"$self","containerName":"_recurse","kind":13,"line":161},{"containerName":"_recurse","kind":12,"name":"_eventHandler","line":161},{"line":161,"kind":12,"containerName":"_recurse","name":"end_element"},{"kind":13,"containerName":"_recurse","name":"$self","line":164},{"line":164,"containerName":"_recurse","kind":12,"name":"debug"},{"containerName":"_recurse","kind":13,"name":"$self","line":165},{"name":"debug","containerName":"_recurse","kind":12,"line":165},{"line":166,"containerName":"_recurse","kind":13,"name":"$self"},{"name":"_eventHandler","containerName":"_recurse","kind":12,"line":166},{"name":"start_element","kind":12,"containerName":"_recurse","line":166},{"line":167,"name":"$self","containerName":"_recurse","kind":13},{"containerName":"_recurse","kind":12,"name":"_eventHandler","line":167},{"line":167,"containerName":"_recurse","kind":12,"name":"start_element"},{"kind":13,"containerName":"_recurse","name":"$self","line":168},{"line":168,"name":"_eventHandler","kind":12,"containerName":"_recurse"},{"line":168,"name":"characters","containerName":"_recurse","kind":12},{"containerName":"_recurse","kind":13,"name":"$self","line":168},{"line":168,"name":"$line","containerName":"_recurse","kind":13},{"line":169,"kind":13,"containerName":"_recurse","name":"$self"},{"name":"_eventHandler","kind":12,"containerName":"_recurse","line":169},{"name":"end_element","kind":12,"containerName":"_recurse","line":169},{"name":"$self","containerName":"_recurse","kind":13,"line":170},{"kind":12,"containerName":"_recurse","name":"_eventHandler","line":170},{"line":170,"name":"start_element","kind":12,"containerName":"_recurse"},{"name":"$self","kind":13,"containerName":"_recurse","line":171},{"name":"_eventHandler","containerName":"_recurse","kind":12,"line":171},{"containerName":"_recurse","kind":12,"name":"characters","line":171},{"line":172,"containerName":"_recurse","kind":13,"name":"$self"},{"name":"_eventHandler","kind":12,"containerName":"_recurse","line":172},{"line":172,"name":"end_element","containerName":"_recurse","kind":12},{"name":"$self","kind":13,"containerName":"_recurse","line":173},{"kind":12,"containerName":"_recurse","name":"_eventHandler","line":173},{"line":173,"name":"start_element","containerName":"_recurse","kind":12},{"kind":13,"localvar":"my","containerName":"_recurse","name":"$child_id","line":174,"definition":"my"},{"kind":13,"containerName":"_recurse","name":"$id","line":174},{"name":"$self","kind":13,"containerName":"_recurse","line":175},{"line":175,"containerName":"_recurse","kind":12,"name":"_recurse"},{"containerName":"_recurse","kind":13,"name":"$child_id","line":175},{"line":176,"name":"$self","containerName":"_recurse","kind":13},{"line":176,"containerName":"_recurse","kind":12,"name":"_recurse"},{"line":176,"containerName":"_recurse","kind":13,"name":"$child_id"},{"line":177,"containerName":"_recurse","kind":13,"name":"$self"},{"line":177,"kind":12,"containerName":"_recurse","name":"_eventHandler"},{"line":177,"name":"end_element","kind":12,"containerName":"_recurse"},{"line":178,"name":"$self","kind":13,"containerName":"_recurse"},{"line":178,"kind":12,"containerName":"_recurse","name":"_eventHandler"},{"line":178,"name":"end_element","containerName":"_recurse","kind":12}],"name":"_recurse","containerName":"main::","definition":"sub","detail":"($self,$line,$column)"},{"kind":12,"name":"_result","line":145},{"kind":12,"name":"Name","line":151},{"kind":12,"name":"Name","line":152},{"line":153,"kind":12,"name":"_linkdist"},{"line":154,"kind":12,"name":"Name"},{"line":155,"kind":12,"name":"Name"},{"line":156,"kind":12,"name":"_labels"},{"line":157,"name":"Name","kind":12},{"name":"Name","kind":12,"line":158},{"name":"Name","kind":12,"line":160},{"line":161,"name":"Name","kind":12},{"line":166,"kind":12,"name":"Name"},{"name":"Name","kind":12,"line":167},{"name":"_linkdist","kind":12,"line":168},{"line":169,"name":"Name","kind":12},{"line":170,"name":"Name","kind":12},{"line":172,"name":"Name","kind":12},{"line":173,"kind":12,"name":"Name"},{"line":177,"kind":12,"name":"Name"},{"line":178,"kind":12,"name":"Name"},{"definition":"sub","name":"write_tree","containerName":"main::","children":[{"line":195,"name":"throw","containerName":"write_tree","kind":12}],"kind":12,"range":{"start":{"character":0,"line":194},"end":{"character":9999,"line":196}},"line":194}]}