{"version":5,"vars":[{"line":79,"name":"base","containerName":"","kind":2},{"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: TreeEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO::TreeEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO::TreeEventBuilder - Build Bio::Tree::Tree's and \n  Bio::Tree::Node's from Events \n\n=head1 SYNOPSIS\n\n# internal use only\n\n=head1 DESCRIPTION\n\nThis object will take events and build a Bio::Tree::TreeI compliant\nobject makde up of Bio::Tree::NodeI objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO::TreeEventBuilder;\nuse strict;\n\nuse Bio::Tree::Tree;\nuse Bio::Tree::Node;\n\nuse base qw(Bio::Root::Root Bio::Event::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::TreeIO::TreeEventBuilder->new();\n Function: Builds a new Bio::TreeIO::TreeEventBuilder object \n Returns : Bio::TreeIO::TreeEventBuilder\n Args    :","label":"new($class,@args)"},"line":92,"range":{"start":{"line":92,"character":0},"end":{"character":9999,"line":113}},"kind":12,"definition":"sub","detail":"($class,@args)","children":[{"definition":"my","localvar":"my","containerName":"new","kind":13,"name":"$class","line":93},{"line":93,"kind":13,"containerName":"new","name":"@args"},{"line":95,"localvar":"my","kind":13,"containerName":"new","name":"$self","definition":"my"},{"kind":13,"containerName":"new","name":"$class","line":95},{"line":95,"containerName":"new","kind":13,"name":"@args"},{"line":96,"name":"$treetype","localvar":"my","containerName":"new","kind":13,"definition":"my"},{"name":"$nodetype","containerName":"new","kind":13,"line":96},{"line":96,"kind":13,"containerName":"new","name":"$self"},{"line":96,"containerName":"new","kind":12,"name":"_rearrange"},{"name":"@args","containerName":"new","kind":13,"line":97},{"line":98,"name":"$treetype","containerName":"new","kind":13},{"name":"$nodetype","kind":13,"containerName":"new","line":99},{"line":102,"name":"$self","containerName":"new","kind":13},{"line":102,"name":"_load_module","containerName":"new","kind":12},{"kind":13,"containerName":"new","name":"$treetype","line":102},{"line":103,"name":"$self","containerName":"new","kind":13},{"line":103,"name":"_load_module","containerName":"new","kind":12},{"name":"$nodetype","containerName":"new","kind":13,"line":103},{"line":107,"containerName":"new","kind":13,"name":"$self"},{"line":107,"name":"throw","kind":12,"containerName":"new"},{"line":109,"name":"$self","kind":13,"containerName":"new"},{"line":109,"containerName":"new","kind":12,"name":"treetype"},{"name":"$treetype","kind":13,"containerName":"new","line":109},{"line":110,"kind":13,"containerName":"new","name":"$self"},{"line":110,"name":"nodetype","kind":12,"containerName":"new"},{"kind":13,"containerName":"new","name":"$nodetype","line":110},{"containerName":"new","kind":13,"name":"$self","line":111},{"line":112,"name":"$self","kind":13,"containerName":"new"}],"containerName":"main::","name":"new"},{"line":95,"name":"SUPER","containerName":"new","kind":12},{"range":{"start":{"line":126,"character":0},"end":{"character":9999,"line":132}},"kind":12,"line":126,"signature":{"documentation":"1;\n# $Id: TreeEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO::TreeEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO::TreeEventBuilder - Build Bio::Tree::Tree's and \n  Bio::Tree::Node's from Events \n\n=head1 SYNOPSIS\n\n# internal use only\n\n=head1 DESCRIPTION\n\nThis object will take events and build a Bio::Tree::TreeI compliant\nobject makde up of Bio::Tree::NodeI objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO::TreeEventBuilder;\nuse strict;\n\nuse Bio::Tree::Tree;\nuse Bio::Tree::Node;\n\nuse base qw(Bio::Root::Root Bio::Event::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::TreeIO::TreeEventBuilder->new();\n Function: Builds a new Bio::TreeIO::TreeEventBuilder object \n Returns : Bio::TreeIO::TreeEventBuilder\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($treetype, $nodetype) = $self->_rearrange([qw(TREETYPE \n\t\t\t\t\t\t    NODETYPE)], @args);\n  $treetype ||= 'Bio::Tree::Tree';\n  $nodetype ||= 'Bio::Tree::Node';\n\n  eval { \n      $self->_load_module($treetype);\n      $self->_load_module($nodetype);\n  };\n\n  if( $@ ) {\n      $self->throw(\"Could not load module $treetype or $nodetype. \\n$@\\n\")\n  }\n  $self->treetype($treetype);\n  $self->nodetype($nodetype);\n  $self->{'_treelevel'} = 0;\n  return $self;\n}\n\n=head2 treetype\n\n Title   : treetype\n Usage   : $obj->treetype($newval)\n Function: \n Returns : value of treetype\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"treetype($self,$value)"},"name":"treetype","containerName":"main::","children":[{"line":127,"name":"$self","localvar":"my","kind":13,"containerName":"treetype","definition":"my"},{"containerName":"treetype","kind":13,"name":"$value","line":127},{"line":128,"name":"$value","containerName":"treetype","kind":13},{"line":129,"name":"$self","kind":13,"containerName":"treetype"},{"line":129,"kind":13,"containerName":"treetype","name":"$value"},{"line":131,"name":"$self","kind":13,"containerName":"treetype"}],"detail":"($self,$value)","definition":"sub"},{"line":145,"kind":12,"range":{"start":{"line":145,"character":0},"end":{"line":151,"character":9999}},"signature":{"label":"nodetype($self,$value)","documentation":"1;\n# $Id: TreeEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO::TreeEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO::TreeEventBuilder - Build Bio::Tree::Tree's and \n  Bio::Tree::Node's from Events \n\n=head1 SYNOPSIS\n\n# internal use only\n\n=head1 DESCRIPTION\n\nThis object will take events and build a Bio::Tree::TreeI compliant\nobject makde up of Bio::Tree::NodeI objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO::TreeEventBuilder;\nuse strict;\n\nuse Bio::Tree::Tree;\nuse Bio::Tree::Node;\n\nuse base qw(Bio::Root::Root Bio::Event::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::TreeIO::TreeEventBuilder->new();\n Function: Builds a new Bio::TreeIO::TreeEventBuilder object \n Returns : Bio::TreeIO::TreeEventBuilder\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($treetype, $nodetype) = $self->_rearrange([qw(TREETYPE \n\t\t\t\t\t\t    NODETYPE)], @args);\n  $treetype ||= 'Bio::Tree::Tree';\n  $nodetype ||= 'Bio::Tree::Node';\n\n  eval { \n      $self->_load_module($treetype);\n      $self->_load_module($nodetype);\n  };\n\n  if( $@ ) {\n      $self->throw(\"Could not load module $treetype or $nodetype. \\n$@\\n\")\n  }\n  $self->treetype($treetype);\n  $self->nodetype($nodetype);\n  $self->{'_treelevel'} = 0;\n  return $self;\n}\n\n=head2 treetype\n\n Title   : treetype\n Usage   : $obj->treetype($newval)\n Function: \n Returns : value of treetype\n Args    : newvalue (optional)\n\n\n\nsub treetype{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'treetype'} = $value;\n    }\n    return $self->{'treetype'};\n}\n\n=head2 nodetype\n\n Title   : nodetype\n Usage   : $obj->nodetype($newval)\n Function: \n Returns : value of nodetype\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}]},"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"nodetype","line":146,"definition":"my"},{"line":146,"name":"$value","kind":13,"containerName":"nodetype"},{"line":147,"containerName":"nodetype","kind":13,"name":"$value"},{"line":148,"name":"$self","containerName":"nodetype","kind":13},{"name":"$value","containerName":"nodetype","kind":13,"line":148},{"line":150,"containerName":"nodetype","kind":13,"name":"$self"}],"containerName":"main::","name":"nodetype","definition":"sub","detail":"($self,$value)"},{"signature":{"documentation":"1;\n# $Id: TreeEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO::TreeEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO::TreeEventBuilder - Build Bio::Tree::Tree's and \n  Bio::Tree::Node's from Events \n\n=head1 SYNOPSIS\n\n# internal use only\n\n=head1 DESCRIPTION\n\nThis object will take events and build a Bio::Tree::TreeI compliant\nobject makde up of Bio::Tree::NodeI objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO::TreeEventBuilder;\nuse strict;\n\nuse Bio::Tree::Tree;\nuse Bio::Tree::Node;\n\nuse base qw(Bio::Root::Root Bio::Event::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::TreeIO::TreeEventBuilder->new();\n Function: Builds a new Bio::TreeIO::TreeEventBuilder object \n Returns : Bio::TreeIO::TreeEventBuilder\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($treetype, $nodetype) = $self->_rearrange([qw(TREETYPE \n\t\t\t\t\t\t    NODETYPE)], @args);\n  $treetype ||= 'Bio::Tree::Tree';\n  $nodetype ||= 'Bio::Tree::Node';\n\n  eval { \n      $self->_load_module($treetype);\n      $self->_load_module($nodetype);\n  };\n\n  if( $@ ) {\n      $self->throw(\"Could not load module $treetype or $nodetype. \\n$@\\n\")\n  }\n  $self->treetype($treetype);\n  $self->nodetype($nodetype);\n  $self->{'_treelevel'} = 0;\n  return $self;\n}\n\n=head2 treetype\n\n Title   : treetype\n Usage   : $obj->treetype($newval)\n Function: \n Returns : value of treetype\n Args    : newvalue (optional)\n\n\n\nsub treetype{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'treetype'} = $value;\n    }\n    return $self->{'treetype'};\n}\n\n=head2 nodetype\n\n Title   : nodetype\n Usage   : $obj->nodetype($newval)\n Function: \n Returns : value of nodetype\n Args    : newvalue (optional)\n\n\n\nsub nodetype{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'nodetype'} = $value;\n    }\n    return $self->{'nodetype'};\n}\n\n\n=head2 SAX methods\n\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $handler->start_document\n Function: Begins a Tree event cycle\n Returns : none \n Args    : none","parameters":[{"label":"$self"}],"label":"start_document($self)"},"range":{"end":{"character":9999,"line":174},"start":{"character":0,"line":168}},"kind":12,"line":168,"detail":"($self)","definition":"sub","name":"start_document","containerName":"main::","children":[{"definition":"my","line":169,"name":"$self","localvar":"my","containerName":"start_document","kind":13},{"name":"$self","containerName":"start_document","kind":13,"line":170},{"kind":13,"containerName":"start_document","name":"$self","line":171},{"line":172,"name":"$self","containerName":"start_document","kind":13}]},{"detail":"($self,$label)","definition":"sub","containerName":"main::","name":"end_document","children":[{"definition":"my","line":187,"name":"$self","localvar":"my","kind":13,"containerName":"end_document"},{"name":"$label","containerName":"end_document","kind":13,"line":187},{"line":188,"name":"$root","localvar":"my","kind":13,"containerName":"end_document","definition":"my"},{"line":188,"name":"$self","kind":13,"containerName":"end_document"},{"line":188,"containerName":"end_document","kind":12,"name":"nodetype"},{"containerName":"end_document","kind":12,"name":"new","line":188},{"line":189,"name":"$label","containerName":"end_document","kind":13},{"line":190,"containerName":"end_document","kind":13,"name":"$self"},{"line":190,"kind":12,"containerName":"end_document","name":"verbose"},{"name":"$self","containerName":"end_document","kind":13,"line":192}],"signature":{"documentation":"1;\n# $Id: TreeEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO::TreeEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO::TreeEventBuilder - Build Bio::Tree::Tree's and \n  Bio::Tree::Node's from Events \n\n=head1 SYNOPSIS\n\n# internal use only\n\n=head1 DESCRIPTION\n\nThis object will take events and build a Bio::Tree::TreeI compliant\nobject makde up of Bio::Tree::NodeI objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO::TreeEventBuilder;\nuse strict;\n\nuse Bio::Tree::Tree;\nuse Bio::Tree::Node;\n\nuse base qw(Bio::Root::Root Bio::Event::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::TreeIO::TreeEventBuilder->new();\n Function: Builds a new Bio::TreeIO::TreeEventBuilder object \n Returns : Bio::TreeIO::TreeEventBuilder\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($treetype, $nodetype) = $self->_rearrange([qw(TREETYPE \n\t\t\t\t\t\t    NODETYPE)], @args);\n  $treetype ||= 'Bio::Tree::Tree';\n  $nodetype ||= 'Bio::Tree::Node';\n\n  eval { \n      $self->_load_module($treetype);\n      $self->_load_module($nodetype);\n  };\n\n  if( $@ ) {\n      $self->throw(\"Could not load module $treetype or $nodetype. \\n$@\\n\")\n  }\n  $self->treetype($treetype);\n  $self->nodetype($nodetype);\n  $self->{'_treelevel'} = 0;\n  return $self;\n}\n\n=head2 treetype\n\n Title   : treetype\n Usage   : $obj->treetype($newval)\n Function: \n Returns : value of treetype\n Args    : newvalue (optional)\n\n\n\nsub treetype{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'treetype'} = $value;\n    }\n    return $self->{'treetype'};\n}\n\n=head2 nodetype\n\n Title   : nodetype\n Usage   : $obj->nodetype($newval)\n Function: \n Returns : value of nodetype\n Args    : newvalue (optional)\n\n\n\nsub nodetype{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'nodetype'} = $value;\n    }\n    return $self->{'nodetype'};\n}\n\n\n=head2 SAX methods\n\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $handler->start_document\n Function: Begins a Tree event cycle\n Returns : none \n Args    : none\n\n\nsub start_document {\n   my ($self) = @_;   \n   $self->{'_lastitem'} = {};\n   $self->{'_currentitems'} = [];\n   $self->{'_currentnodes'} = [];\n   return;\n}\n\n=head2 end_document\n\n Title   : end_document\n Usage   : my @trees = $parser->end_document\n Function: Finishes a Phylogeny cycle\n Returns : An array  Bio::Tree::TreeI\n Args    : none","parameters":[{"label":"$self"},{"label":"$label"}],"label":"end_document($self,$label)"},"range":{"start":{"character":0,"line":186},"end":{"line":192,"character":9999}},"kind":12,"line":186},{"definition":"my","name":"$node","localvar":"my","containerName":null,"kind":13,"line":193},{"kind":13,"containerName":null,"name":"%self","line":193},{"kind":13,"containerName":null,"name":"$root","line":194},{"kind":12,"containerName":"main::","name":"add_Descendent","line":194},{"line":194,"name":"$node","kind":13,"containerName":null},{"line":197,"containerName":null,"kind":13,"name":"$self"},{"name":"debug","containerName":"main::","kind":12,"line":197},{"name":"$root","kind":13,"containerName":null,"line":197},{"kind":12,"containerName":"main::","name":"to_string","line":197},{"line":198,"name":"$self","containerName":null,"kind":13},{"containerName":"main::","kind":12,"name":"verbose","line":198},{"line":199,"name":"$node","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"line":199,"kind":13,"containerName":null,"name":"$root"},{"name":"get_Descendents","kind":12,"containerName":"main::","line":199},{"line":200,"name":"$self","containerName":null,"kind":13},{"line":200,"kind":12,"containerName":"main::","name":"debug"},{"kind":13,"containerName":null,"name":"$node","line":200},{"name":"to_string","kind":12,"containerName":"main::","line":200},{"name":"$tree","kind":13,"localvar":"my","containerName":null,"line":203,"definition":"my"},{"name":"$self","containerName":null,"kind":13,"line":203},{"name":"treetype","containerName":"main::","kind":12,"line":203},{"line":203,"name":"new","containerName":"main::","kind":12},{"line":203,"name":"$self","kind":13,"containerName":null},{"kind":12,"containerName":"main::","name":"verbose","line":203},{"line":204,"name":"$root","containerName":null,"kind":13},{"name":"$tree","containerName":null,"kind":13,"line":205},{"line":219,"kind":12,"range":{"end":{"line":224,"character":9999},"start":{"line":219,"character":0}},"signature":{"parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: TreeEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO::TreeEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO::TreeEventBuilder - Build Bio::Tree::Tree's and \n  Bio::Tree::Node's from Events \n\n=head1 SYNOPSIS\n\n# internal use only\n\n=head1 DESCRIPTION\n\nThis object will take events and build a Bio::Tree::TreeI compliant\nobject makde up of Bio::Tree::NodeI objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO::TreeEventBuilder;\nuse strict;\n\nuse Bio::Tree::Tree;\nuse Bio::Tree::Node;\n\nuse base qw(Bio::Root::Root Bio::Event::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::TreeIO::TreeEventBuilder->new();\n Function: Builds a new Bio::TreeIO::TreeEventBuilder object \n Returns : Bio::TreeIO::TreeEventBuilder\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($treetype, $nodetype) = $self->_rearrange([qw(TREETYPE \n\t\t\t\t\t\t    NODETYPE)], @args);\n  $treetype ||= 'Bio::Tree::Tree';\n  $nodetype ||= 'Bio::Tree::Node';\n\n  eval { \n      $self->_load_module($treetype);\n      $self->_load_module($nodetype);\n  };\n\n  if( $@ ) {\n      $self->throw(\"Could not load module $treetype or $nodetype. \\n$@\\n\")\n  }\n  $self->treetype($treetype);\n  $self->nodetype($nodetype);\n  $self->{'_treelevel'} = 0;\n  return $self;\n}\n\n=head2 treetype\n\n Title   : treetype\n Usage   : $obj->treetype($newval)\n Function: \n Returns : value of treetype\n Args    : newvalue (optional)\n\n\n\nsub treetype{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'treetype'} = $value;\n    }\n    return $self->{'treetype'};\n}\n\n=head2 nodetype\n\n Title   : nodetype\n Usage   : $obj->nodetype($newval)\n Function: \n Returns : value of nodetype\n Args    : newvalue (optional)\n\n\n\nsub nodetype{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'nodetype'} = $value;\n    }\n    return $self->{'nodetype'};\n}\n\n\n=head2 SAX methods\n\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $handler->start_document\n Function: Begins a Tree event cycle\n Returns : none \n Args    : none\n\n\nsub start_document {\n   my ($self) = @_;   \n   $self->{'_lastitem'} = {};\n   $self->{'_currentitems'} = [];\n   $self->{'_currentnodes'} = [];\n   return;\n}\n\n=head2 end_document\n\n Title   : end_document\n Usage   : my @trees = $parser->end_document\n Function: Finishes a Phylogeny cycle\n Returns : An array  Bio::Tree::TreeI\n Args    : none\n\n\nsub end_document {\n    my ($self,$label) = @_; \n    my $root = $self->nodetype->new(\n\t-id => $label,\n\t-verbose => $self->verbose);\n    # aggregate the nodes into trees basically ad-hoc.\n    while ( @{$self->{'_currentnodes'}} ) {\t\n\tmy ($node) = ( shift @{$self->{'_currentnodes'}});\n\t$root->add_Descendent($node);\n    }\n\n    $self->debug(\"Root node is \" . $root->to_string().\"\\n\");\n    if( $self->verbose > 0 ) { \n\tforeach my $node ( $root->get_Descendents  ) {\n\t    $self->debug(\"node is \". $node->to_string(). \"\\n\");\n\t}\n    }\n    my $tree = $self->treetype->new(-verbose => $self->verbose,\n\t\t\t\t    -root => $root);\n    return $tree;       \n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   :\n Function:\n Example :\n Returns : \n Args    : $data => hashref with key 'Name'","label":"start_element($self,$data)"},"children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"start_element","line":220},{"containerName":"start_element","kind":13,"name":"$data","line":220},{"containerName":"start_element","kind":13,"name":"$self","line":221},{"line":221,"containerName":"start_element","kind":13,"name":"$data"},{"line":223,"name":"$self","kind":13,"containerName":"start_element"},{"name":"debug","kind":12,"containerName":"start_element","line":223},{"kind":13,"containerName":"start_element","name":"$self","line":224}],"name":"start_element","containerName":"main::","definition":"sub","detail":"($self,$data)"},{"containerName":null,"kind":13,"name":"%data","line":224},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"%data","line":226},{"kind":13,"containerName":null,"name":"%data","line":228},{"kind":13,"containerName":null,"name":"%self","line":229},{"kind":13,"containerName":null,"name":"%data","line":229},{"line":230,"containerName":null,"kind":13,"name":"%data"},{"line":230,"name":"Name","kind":12},{"line":231,"kind":13,"containerName":null,"name":"%self"},{"kind":12,"range":{"end":{"line":250,"character":9999},"start":{"line":245,"character":0}},"line":245,"signature":{"label":"end_element($self,$data)","parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: TreeEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO::TreeEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO::TreeEventBuilder - Build Bio::Tree::Tree's and \n  Bio::Tree::Node's from Events \n\n=head1 SYNOPSIS\n\n# internal use only\n\n=head1 DESCRIPTION\n\nThis object will take events and build a Bio::Tree::TreeI compliant\nobject makde up of Bio::Tree::NodeI objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO::TreeEventBuilder;\nuse strict;\n\nuse Bio::Tree::Tree;\nuse Bio::Tree::Node;\n\nuse base qw(Bio::Root::Root Bio::Event::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::TreeIO::TreeEventBuilder->new();\n Function: Builds a new Bio::TreeIO::TreeEventBuilder object \n Returns : Bio::TreeIO::TreeEventBuilder\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($treetype, $nodetype) = $self->_rearrange([qw(TREETYPE \n\t\t\t\t\t\t    NODETYPE)], @args);\n  $treetype ||= 'Bio::Tree::Tree';\n  $nodetype ||= 'Bio::Tree::Node';\n\n  eval { \n      $self->_load_module($treetype);\n      $self->_load_module($nodetype);\n  };\n\n  if( $@ ) {\n      $self->throw(\"Could not load module $treetype or $nodetype. \\n$@\\n\")\n  }\n  $self->treetype($treetype);\n  $self->nodetype($nodetype);\n  $self->{'_treelevel'} = 0;\n  return $self;\n}\n\n=head2 treetype\n\n Title   : treetype\n Usage   : $obj->treetype($newval)\n Function: \n Returns : value of treetype\n Args    : newvalue (optional)\n\n\n\nsub treetype{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'treetype'} = $value;\n    }\n    return $self->{'treetype'};\n}\n\n=head2 nodetype\n\n Title   : nodetype\n Usage   : $obj->nodetype($newval)\n Function: \n Returns : value of nodetype\n Args    : newvalue (optional)\n\n\n\nsub nodetype{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'nodetype'} = $value;\n    }\n    return $self->{'nodetype'};\n}\n\n\n=head2 SAX methods\n\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $handler->start_document\n Function: Begins a Tree event cycle\n Returns : none \n Args    : none\n\n\nsub start_document {\n   my ($self) = @_;   \n   $self->{'_lastitem'} = {};\n   $self->{'_currentitems'} = [];\n   $self->{'_currentnodes'} = [];\n   return;\n}\n\n=head2 end_document\n\n Title   : end_document\n Usage   : my @trees = $parser->end_document\n Function: Finishes a Phylogeny cycle\n Returns : An array  Bio::Tree::TreeI\n Args    : none\n\n\nsub end_document {\n    my ($self,$label) = @_; \n    my $root = $self->nodetype->new(\n\t-id => $label,\n\t-verbose => $self->verbose);\n    # aggregate the nodes into trees basically ad-hoc.\n    while ( @{$self->{'_currentnodes'}} ) {\t\n\tmy ($node) = ( shift @{$self->{'_currentnodes'}});\n\t$root->add_Descendent($node);\n    }\n\n    $self->debug(\"Root node is \" . $root->to_string().\"\\n\");\n    if( $self->verbose > 0 ) { \n\tforeach my $node ( $root->get_Descendents  ) {\n\t    $self->debug(\"node is \". $node->to_string(). \"\\n\");\n\t}\n    }\n    my $tree = $self->treetype->new(-verbose => $self->verbose,\n\t\t\t\t    -root => $root);\n    return $tree;       \n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   :\n Function:\n Example :\n Returns : \n Args    : $data => hashref with key 'Name'\n\n\nsub start_element{\n   my ($self,$data) =@_;\n   $self->{'_lastitem'}->{$data->{'Name'}}++;   \n\n   $self->debug(\"starting element: $data->{Name}\\n\");   \n   push @{$self->{'_lastitem'}->{'current'}},$data->{'Name'};\n   \n   my %data;\n   \n   if( $data->{'Name'} eq 'node' ) {\n       push @{$self->{'_currentitems'}}, \\%data; \n   } elsif ( $data->{Name} eq 'tree' ) {\n       $self->{'_treelevel'}++;\n   }\n}\n\n=head2 end_element\n\n Title   : end_element\n Usage   : \n Function:\n Returns : none\n Args    : $data => hashref with key 'Name'"},"name":"end_element","containerName":"main::","children":[{"line":246,"name":"$self","containerName":"end_element","localvar":"my","kind":13,"definition":"my"},{"name":"$data","kind":13,"containerName":"end_element","line":246},{"containerName":"end_element","kind":13,"name":"$self","line":248},{"containerName":"end_element","kind":12,"name":"debug","line":248},{"name":"$curcount","localvar":"my","kind":13,"containerName":"end_element","line":250,"definition":"my"},{"containerName":"end_element","kind":13,"name":"$self","line":250}],"detail":"($self,$data)","definition":"sub"},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"$level","line":251},{"containerName":null,"kind":13,"name":"%self","line":251},{"definition":"my","line":252,"name":"$levelct","kind":13,"localvar":"my","containerName":null},{"line":252,"containerName":null,"kind":13,"name":"%self"},{"kind":13,"containerName":null,"name":"%self","line":252},{"kind":13,"containerName":null,"name":"%data","line":254},{"definition":"my","line":255,"name":"$tnode","localvar":"my","containerName":null,"kind":13},{"kind":13,"localvar":"my","containerName":null,"name":"$node","line":256,"definition":"my"},{"name":"%self","containerName":null,"kind":13,"line":256},{"line":258,"name":"$tnode","containerName":null,"kind":13},{"name":"$self","kind":13,"containerName":null,"line":258},{"line":258,"kind":12,"containerName":"main::","name":"nodetype"},{"line":258,"containerName":"main::","kind":12,"name":"new"},{"line":258,"name":"$self","containerName":null,"kind":13},{"line":258,"containerName":"main::","kind":12,"name":"verbose"},{"kind":13,"containerName":null,"name":"$node","line":259},{"containerName":null,"kind":13,"name":"$self","line":260},{"containerName":"main::","kind":12,"name":"debug","line":260},{"containerName":null,"kind":13,"name":"$tnode","line":260},{"line":260,"containerName":"main::","kind":12,"name":"to_string"},{"containerName":null,"kind":13,"name":"%node","line":261},{"line":261,"containerName":null,"kind":13,"name":"%levelct"},{"containerName":null,"kind":13,"name":"$self","line":262},{"containerName":"main::","kind":12,"name":"debug","line":262},{"line":262,"name":"to_string","containerName":"main::","kind":12},{"name":"%self","kind":13,"containerName":null,"line":263},{"line":264,"name":"$self","containerName":null,"kind":13},{"kind":12,"containerName":"main::","name":"throw","line":264},{"line":267,"name":"$levelct","containerName":null,"kind":13},{"name":"$curcount","kind":13,"containerName":null,"line":267},{"line":268,"kind":13,"containerName":null,"name":"%self"},{"name":"%levelct","containerName":null,"kind":13,"line":268},{"line":269,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"containerName":"main::","name":"debug","line":269},{"containerName":"main::","kind":12,"name":"to_string","line":269},{"line":270,"name":"$tnode","kind":13,"containerName":null},{"line":270,"name":"add_Descendent","containerName":"main::","kind":12},{"line":272,"kind":13,"containerName":null,"name":"%self"},{"kind":13,"containerName":null,"name":"%self","line":272},{"line":274,"containerName":null,"kind":13,"name":"%self"},{"kind":13,"containerName":null,"name":"$tnode","line":274},{"containerName":null,"kind":13,"name":"%self","line":275},{"containerName":null,"kind":13,"name":"%self","line":275},{"line":277,"containerName":null,"kind":13,"name":"$self"},{"line":277,"kind":12,"containerName":"main::","name":"debug"},{"line":279,"kind":13,"containerName":null,"name":"%data"},{"name":"$self","containerName":null,"kind":13,"line":280},{"line":280,"name":"debug","containerName":"main::","kind":12},{"name":"%self","kind":13,"containerName":null,"line":281},{"kind":13,"containerName":null,"name":"%self","line":284},{"line":284,"name":"%data","containerName":null,"kind":13},{"line":286,"kind":13,"containerName":null,"name":"%self"},{"kind":12,"range":{"start":{"line":302,"character":0},"end":{"character":9999,"line":309}},"line":302,"signature":{"label":"in_element($self,$e)","documentation":"1;\n# $Id: TreeEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO::TreeEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO::TreeEventBuilder - Build Bio::Tree::Tree's and \n  Bio::Tree::Node's from Events \n\n=head1 SYNOPSIS\n\n# internal use only\n\n=head1 DESCRIPTION\n\nThis object will take events and build a Bio::Tree::TreeI compliant\nobject makde up of Bio::Tree::NodeI objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO::TreeEventBuilder;\nuse strict;\n\nuse Bio::Tree::Tree;\nuse Bio::Tree::Node;\n\nuse base qw(Bio::Root::Root Bio::Event::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::TreeIO::TreeEventBuilder->new();\n Function: Builds a new Bio::TreeIO::TreeEventBuilder object \n Returns : Bio::TreeIO::TreeEventBuilder\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($treetype, $nodetype) = $self->_rearrange([qw(TREETYPE \n\t\t\t\t\t\t    NODETYPE)], @args);\n  $treetype ||= 'Bio::Tree::Tree';\n  $nodetype ||= 'Bio::Tree::Node';\n\n  eval { \n      $self->_load_module($treetype);\n      $self->_load_module($nodetype);\n  };\n\n  if( $@ ) {\n      $self->throw(\"Could not load module $treetype or $nodetype. \\n$@\\n\")\n  }\n  $self->treetype($treetype);\n  $self->nodetype($nodetype);\n  $self->{'_treelevel'} = 0;\n  return $self;\n}\n\n=head2 treetype\n\n Title   : treetype\n Usage   : $obj->treetype($newval)\n Function: \n Returns : value of treetype\n Args    : newvalue (optional)\n\n\n\nsub treetype{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'treetype'} = $value;\n    }\n    return $self->{'treetype'};\n}\n\n=head2 nodetype\n\n Title   : nodetype\n Usage   : $obj->nodetype($newval)\n Function: \n Returns : value of nodetype\n Args    : newvalue (optional)\n\n\n\nsub nodetype{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'nodetype'} = $value;\n    }\n    return $self->{'nodetype'};\n}\n\n\n=head2 SAX methods\n\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $handler->start_document\n Function: Begins a Tree event cycle\n Returns : none \n Args    : none\n\n\nsub start_document {\n   my ($self) = @_;   \n   $self->{'_lastitem'} = {};\n   $self->{'_currentitems'} = [];\n   $self->{'_currentnodes'} = [];\n   return;\n}\n\n=head2 end_document\n\n Title   : end_document\n Usage   : my @trees = $parser->end_document\n Function: Finishes a Phylogeny cycle\n Returns : An array  Bio::Tree::TreeI\n Args    : none\n\n\nsub end_document {\n    my ($self,$label) = @_; \n    my $root = $self->nodetype->new(\n\t-id => $label,\n\t-verbose => $self->verbose);\n    # aggregate the nodes into trees basically ad-hoc.\n    while ( @{$self->{'_currentnodes'}} ) {\t\n\tmy ($node) = ( shift @{$self->{'_currentnodes'}});\n\t$root->add_Descendent($node);\n    }\n\n    $self->debug(\"Root node is \" . $root->to_string().\"\\n\");\n    if( $self->verbose > 0 ) { \n\tforeach my $node ( $root->get_Descendents  ) {\n\t    $self->debug(\"node is \". $node->to_string(). \"\\n\");\n\t}\n    }\n    my $tree = $self->treetype->new(-verbose => $self->verbose,\n\t\t\t\t    -root => $root);\n    return $tree;       \n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   :\n Function:\n Example :\n Returns : \n Args    : $data => hashref with key 'Name'\n\n\nsub start_element{\n   my ($self,$data) =@_;\n   $self->{'_lastitem'}->{$data->{'Name'}}++;   \n\n   $self->debug(\"starting element: $data->{Name}\\n\");   \n   push @{$self->{'_lastitem'}->{'current'}},$data->{'Name'};\n   \n   my %data;\n   \n   if( $data->{'Name'} eq 'node' ) {\n       push @{$self->{'_currentitems'}}, \\%data; \n   } elsif ( $data->{Name} eq 'tree' ) {\n       $self->{'_treelevel'}++;\n   }\n}\n\n=head2 end_element\n\n Title   : end_element\n Usage   : \n Function:\n Returns : none\n Args    : $data => hashref with key 'Name'\n\n\nsub end_element{\n   my ($self,$data) = @_;   \n\n   $self->debug(\"end of element: $data->{Name}\\n\");\n   # this is the stack where we push/pop items from it\n   my $curcount = scalar @{$self->{'_currentnodes'}};\n   my $level   = $self->{'_treelevel'};\n   my $levelct = $self->{'_nodect'}->[$self->{'_treelevel'}+1] || 0;\n\n   if( $data->{'Name'} eq 'node' ) {\n       my $tnode;\n       my $node = pop @{$self->{'_currentitems'}};\t   \n\n       $tnode = $self->nodetype->new( -verbose => $self->verbose,\n\t\t\t\t      %{$node});       \n       $self->debug( \"new node will be \".$tnode->to_string.\"\\n\");\n       if ( !$node->{'-leaf'} && $levelct > 0) {\n\t   $self->debug(join(',', map { $_->to_string } \n\t\t\t     @{$self->{'_currentnodes'}}). \"\\n\");\n\t   $self->throw(\"something wrong with event construction treelevel \".\n\t\t\t\"$level is recorded as having $levelct nodes  \".\n\t\t\t\"but current nodes at this level is $curcount\\n\")\n\t       if( $levelct > $curcount);\t\n\t   for ( splice( @{$self->{'_currentnodes'}}, - $levelct)) {\n\t       $self->debug(\"adding desc: \" . $_->to_string . \"\\n\");\n\t       $tnode->add_Descendent($_);\n\t   }\n\t   $self->{'_nodect'}->[$self->{'_treelevel'}+1] = 0;\n       }\n       push @{$self->{'_currentnodes'}}, $tnode;\n       $self->{'_nodect'}->[$self->{'_treelevel'}]++;\n       \n       $self->debug (\"added node: nodes in stack is $curcount, treelevel: $level, nodect: $levelct\\n\");\n       \n   } elsif(  $data->{'Name'} eq 'tree' ) { \n       $self->debug(\"end of tree: nodes in stack is $curcount\\n\");\n       $self->{'_treelevel'}--;\n   }\n\n   $self->{'_lastitem'}->{ $data->{'Name'} }--; \n   \n   pop @{$self->{'_lastitem'}->{'current'}};\n}\n\n\n=head2 in_element\n\n Title   : in_element\n Usage   :\n Function:\n Example :\n Returns : \n Args    :","parameters":[{"label":"$self"},{"label":"$e"}]},"containerName":"main::","name":"in_element","children":[{"localvar":"my","containerName":"in_element","kind":13,"name":"$self","line":303,"definition":"my"},{"name":"$e","containerName":"in_element","kind":13,"line":303},{"name":"$self","containerName":"in_element","kind":13,"line":305},{"containerName":"in_element","kind":13,"name":"$self","line":306},{"line":307,"name":"$e","kind":13,"containerName":"in_element"},{"line":307,"kind":13,"containerName":"in_element","name":"$self"}],"detail":"($self,$e)","definition":"sub"},{"detail":"($self,$e)","definition":"sub","name":"within_element","containerName":"main::","children":[{"line":324,"localvar":"my","kind":13,"containerName":"within_element","name":"$self","definition":"my"},{"line":324,"containerName":"within_element","kind":13,"name":"$e"},{"kind":13,"containerName":"within_element","name":"$self","line":325},{"line":325,"name":"$e","kind":13,"containerName":"within_element"}],"signature":{"parameters":[{"label":"$self"},{"label":"$e"}],"documentation":"1;\n# $Id: TreeEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO::TreeEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO::TreeEventBuilder - Build Bio::Tree::Tree's and \n  Bio::Tree::Node's from Events \n\n=head1 SYNOPSIS\n\n# internal use only\n\n=head1 DESCRIPTION\n\nThis object will take events and build a Bio::Tree::TreeI compliant\nobject makde up of Bio::Tree::NodeI objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO::TreeEventBuilder;\nuse strict;\n\nuse Bio::Tree::Tree;\nuse Bio::Tree::Node;\n\nuse base qw(Bio::Root::Root Bio::Event::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::TreeIO::TreeEventBuilder->new();\n Function: Builds a new Bio::TreeIO::TreeEventBuilder object \n Returns : Bio::TreeIO::TreeEventBuilder\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($treetype, $nodetype) = $self->_rearrange([qw(TREETYPE \n\t\t\t\t\t\t    NODETYPE)], @args);\n  $treetype ||= 'Bio::Tree::Tree';\n  $nodetype ||= 'Bio::Tree::Node';\n\n  eval { \n      $self->_load_module($treetype);\n      $self->_load_module($nodetype);\n  };\n\n  if( $@ ) {\n      $self->throw(\"Could not load module $treetype or $nodetype. \\n$@\\n\")\n  }\n  $self->treetype($treetype);\n  $self->nodetype($nodetype);\n  $self->{'_treelevel'} = 0;\n  return $self;\n}\n\n=head2 treetype\n\n Title   : treetype\n Usage   : $obj->treetype($newval)\n Function: \n Returns : value of treetype\n Args    : newvalue (optional)\n\n\n\nsub treetype{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'treetype'} = $value;\n    }\n    return $self->{'treetype'};\n}\n\n=head2 nodetype\n\n Title   : nodetype\n Usage   : $obj->nodetype($newval)\n Function: \n Returns : value of nodetype\n Args    : newvalue (optional)\n\n\n\nsub nodetype{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'nodetype'} = $value;\n    }\n    return $self->{'nodetype'};\n}\n\n\n=head2 SAX methods\n\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $handler->start_document\n Function: Begins a Tree event cycle\n Returns : none \n Args    : none\n\n\nsub start_document {\n   my ($self) = @_;   \n   $self->{'_lastitem'} = {};\n   $self->{'_currentitems'} = [];\n   $self->{'_currentnodes'} = [];\n   return;\n}\n\n=head2 end_document\n\n Title   : end_document\n Usage   : my @trees = $parser->end_document\n Function: Finishes a Phylogeny cycle\n Returns : An array  Bio::Tree::TreeI\n Args    : none\n\n\nsub end_document {\n    my ($self,$label) = @_; \n    my $root = $self->nodetype->new(\n\t-id => $label,\n\t-verbose => $self->verbose);\n    # aggregate the nodes into trees basically ad-hoc.\n    while ( @{$self->{'_currentnodes'}} ) {\t\n\tmy ($node) = ( shift @{$self->{'_currentnodes'}});\n\t$root->add_Descendent($node);\n    }\n\n    $self->debug(\"Root node is \" . $root->to_string().\"\\n\");\n    if( $self->verbose > 0 ) { \n\tforeach my $node ( $root->get_Descendents  ) {\n\t    $self->debug(\"node is \". $node->to_string(). \"\\n\");\n\t}\n    }\n    my $tree = $self->treetype->new(-verbose => $self->verbose,\n\t\t\t\t    -root => $root);\n    return $tree;       \n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   :\n Function:\n Example :\n Returns : \n Args    : $data => hashref with key 'Name'\n\n\nsub start_element{\n   my ($self,$data) =@_;\n   $self->{'_lastitem'}->{$data->{'Name'}}++;   \n\n   $self->debug(\"starting element: $data->{Name}\\n\");   \n   push @{$self->{'_lastitem'}->{'current'}},$data->{'Name'};\n   \n   my %data;\n   \n   if( $data->{'Name'} eq 'node' ) {\n       push @{$self->{'_currentitems'}}, \\%data; \n   } elsif ( $data->{Name} eq 'tree' ) {\n       $self->{'_treelevel'}++;\n   }\n}\n\n=head2 end_element\n\n Title   : end_element\n Usage   : \n Function:\n Returns : none\n Args    : $data => hashref with key 'Name'\n\n\nsub end_element{\n   my ($self,$data) = @_;   \n\n   $self->debug(\"end of element: $data->{Name}\\n\");\n   # this is the stack where we push/pop items from it\n   my $curcount = scalar @{$self->{'_currentnodes'}};\n   my $level   = $self->{'_treelevel'};\n   my $levelct = $self->{'_nodect'}->[$self->{'_treelevel'}+1] || 0;\n\n   if( $data->{'Name'} eq 'node' ) {\n       my $tnode;\n       my $node = pop @{$self->{'_currentitems'}};\t   \n\n       $tnode = $self->nodetype->new( -verbose => $self->verbose,\n\t\t\t\t      %{$node});       \n       $self->debug( \"new node will be \".$tnode->to_string.\"\\n\");\n       if ( !$node->{'-leaf'} && $levelct > 0) {\n\t   $self->debug(join(',', map { $_->to_string } \n\t\t\t     @{$self->{'_currentnodes'}}). \"\\n\");\n\t   $self->throw(\"something wrong with event construction treelevel \".\n\t\t\t\"$level is recorded as having $levelct nodes  \".\n\t\t\t\"but current nodes at this level is $curcount\\n\")\n\t       if( $levelct > $curcount);\t\n\t   for ( splice( @{$self->{'_currentnodes'}}, - $levelct)) {\n\t       $self->debug(\"adding desc: \" . $_->to_string . \"\\n\");\n\t       $tnode->add_Descendent($_);\n\t   }\n\t   $self->{'_nodect'}->[$self->{'_treelevel'}+1] = 0;\n       }\n       push @{$self->{'_currentnodes'}}, $tnode;\n       $self->{'_nodect'}->[$self->{'_treelevel'}]++;\n       \n       $self->debug (\"added node: nodes in stack is $curcount, treelevel: $level, nodect: $levelct\\n\");\n       \n   } elsif(  $data->{'Name'} eq 'tree' ) { \n       $self->debug(\"end of tree: nodes in stack is $curcount\\n\");\n       $self->{'_treelevel'}--;\n   }\n\n   $self->{'_lastitem'}->{ $data->{'Name'} }--; \n   \n   pop @{$self->{'_lastitem'}->{'current'}};\n}\n\n\n=head2 in_element\n\n Title   : in_element\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub in_element{\n   my ($self,$e) = @_;\n\n   return 0 if ! defined $self->{'_lastitem'} || \n       ! defined $self->{'_lastitem'}->{'current'}->[-1];\n   return ($e eq $self->{'_lastitem'}->{'current'}->[-1]);\n\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   :\n Function:\n Example :\n Returns : \n Args    :","label":"within_element($self,$e)"},"kind":12,"range":{"start":{"character":0,"line":323},"end":{"character":9999,"line":326}},"line":323},{"signature":{"label":"characters($self,$ch)","parameters":[{"label":"$self"},{"label":"$ch"}],"documentation":"1;\n# $Id: TreeEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO::TreeEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO::TreeEventBuilder - Build Bio::Tree::Tree's and \n  Bio::Tree::Node's from Events \n\n=head1 SYNOPSIS\n\n# internal use only\n\n=head1 DESCRIPTION\n\nThis object will take events and build a Bio::Tree::TreeI compliant\nobject makde up of Bio::Tree::NodeI objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO::TreeEventBuilder;\nuse strict;\n\nuse Bio::Tree::Tree;\nuse Bio::Tree::Node;\n\nuse base qw(Bio::Root::Root Bio::Event::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::TreeIO::TreeEventBuilder->new();\n Function: Builds a new Bio::TreeIO::TreeEventBuilder object \n Returns : Bio::TreeIO::TreeEventBuilder\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($treetype, $nodetype) = $self->_rearrange([qw(TREETYPE \n\t\t\t\t\t\t    NODETYPE)], @args);\n  $treetype ||= 'Bio::Tree::Tree';\n  $nodetype ||= 'Bio::Tree::Node';\n\n  eval { \n      $self->_load_module($treetype);\n      $self->_load_module($nodetype);\n  };\n\n  if( $@ ) {\n      $self->throw(\"Could not load module $treetype or $nodetype. \\n$@\\n\")\n  }\n  $self->treetype($treetype);\n  $self->nodetype($nodetype);\n  $self->{'_treelevel'} = 0;\n  return $self;\n}\n\n=head2 treetype\n\n Title   : treetype\n Usage   : $obj->treetype($newval)\n Function: \n Returns : value of treetype\n Args    : newvalue (optional)\n\n\n\nsub treetype{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'treetype'} = $value;\n    }\n    return $self->{'treetype'};\n}\n\n=head2 nodetype\n\n Title   : nodetype\n Usage   : $obj->nodetype($newval)\n Function: \n Returns : value of nodetype\n Args    : newvalue (optional)\n\n\n\nsub nodetype{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'nodetype'} = $value;\n    }\n    return $self->{'nodetype'};\n}\n\n\n=head2 SAX methods\n\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $handler->start_document\n Function: Begins a Tree event cycle\n Returns : none \n Args    : none\n\n\nsub start_document {\n   my ($self) = @_;   \n   $self->{'_lastitem'} = {};\n   $self->{'_currentitems'} = [];\n   $self->{'_currentnodes'} = [];\n   return;\n}\n\n=head2 end_document\n\n Title   : end_document\n Usage   : my @trees = $parser->end_document\n Function: Finishes a Phylogeny cycle\n Returns : An array  Bio::Tree::TreeI\n Args    : none\n\n\nsub end_document {\n    my ($self,$label) = @_; \n    my $root = $self->nodetype->new(\n\t-id => $label,\n\t-verbose => $self->verbose);\n    # aggregate the nodes into trees basically ad-hoc.\n    while ( @{$self->{'_currentnodes'}} ) {\t\n\tmy ($node) = ( shift @{$self->{'_currentnodes'}});\n\t$root->add_Descendent($node);\n    }\n\n    $self->debug(\"Root node is \" . $root->to_string().\"\\n\");\n    if( $self->verbose > 0 ) { \n\tforeach my $node ( $root->get_Descendents  ) {\n\t    $self->debug(\"node is \". $node->to_string(). \"\\n\");\n\t}\n    }\n    my $tree = $self->treetype->new(-verbose => $self->verbose,\n\t\t\t\t    -root => $root);\n    return $tree;       \n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   :\n Function:\n Example :\n Returns : \n Args    : $data => hashref with key 'Name'\n\n\nsub start_element{\n   my ($self,$data) =@_;\n   $self->{'_lastitem'}->{$data->{'Name'}}++;   \n\n   $self->debug(\"starting element: $data->{Name}\\n\");   \n   push @{$self->{'_lastitem'}->{'current'}},$data->{'Name'};\n   \n   my %data;\n   \n   if( $data->{'Name'} eq 'node' ) {\n       push @{$self->{'_currentitems'}}, \\%data; \n   } elsif ( $data->{Name} eq 'tree' ) {\n       $self->{'_treelevel'}++;\n   }\n}\n\n=head2 end_element\n\n Title   : end_element\n Usage   : \n Function:\n Returns : none\n Args    : $data => hashref with key 'Name'\n\n\nsub end_element{\n   my ($self,$data) = @_;   \n\n   $self->debug(\"end of element: $data->{Name}\\n\");\n   # this is the stack where we push/pop items from it\n   my $curcount = scalar @{$self->{'_currentnodes'}};\n   my $level   = $self->{'_treelevel'};\n   my $levelct = $self->{'_nodect'}->[$self->{'_treelevel'}+1] || 0;\n\n   if( $data->{'Name'} eq 'node' ) {\n       my $tnode;\n       my $node = pop @{$self->{'_currentitems'}};\t   \n\n       $tnode = $self->nodetype->new( -verbose => $self->verbose,\n\t\t\t\t      %{$node});       \n       $self->debug( \"new node will be \".$tnode->to_string.\"\\n\");\n       if ( !$node->{'-leaf'} && $levelct > 0) {\n\t   $self->debug(join(',', map { $_->to_string } \n\t\t\t     @{$self->{'_currentnodes'}}). \"\\n\");\n\t   $self->throw(\"something wrong with event construction treelevel \".\n\t\t\t\"$level is recorded as having $levelct nodes  \".\n\t\t\t\"but current nodes at this level is $curcount\\n\")\n\t       if( $levelct > $curcount);\t\n\t   for ( splice( @{$self->{'_currentnodes'}}, - $levelct)) {\n\t       $self->debug(\"adding desc: \" . $_->to_string . \"\\n\");\n\t       $tnode->add_Descendent($_);\n\t   }\n\t   $self->{'_nodect'}->[$self->{'_treelevel'}+1] = 0;\n       }\n       push @{$self->{'_currentnodes'}}, $tnode;\n       $self->{'_nodect'}->[$self->{'_treelevel'}]++;\n       \n       $self->debug (\"added node: nodes in stack is $curcount, treelevel: $level, nodect: $levelct\\n\");\n       \n   } elsif(  $data->{'Name'} eq 'tree' ) { \n       $self->debug(\"end of tree: nodes in stack is $curcount\\n\");\n       $self->{'_treelevel'}--;\n   }\n\n   $self->{'_lastitem'}->{ $data->{'Name'} }--; \n   \n   pop @{$self->{'_lastitem'}->{'current'}};\n}\n\n\n=head2 in_element\n\n Title   : in_element\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub in_element{\n   my ($self,$e) = @_;\n\n   return 0 if ! defined $self->{'_lastitem'} || \n       ! defined $self->{'_lastitem'}->{'current'}->[-1];\n   return ($e eq $self->{'_lastitem'}->{'current'}->[-1]);\n\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub within_element{\n   my ($self,$e) = @_;\n   return $self->{'_lastitem'}->{$e};\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $handler->characters($text);\n Function: Processes characters \n Returns : none\n Args    : text string"},"kind":12,"range":{"end":{"line":363,"character":9999},"start":{"line":339,"character":0}},"line":339,"detail":"($self,$ch)","definition":"sub","name":"characters","containerName":"main::","children":[{"definition":"my","line":340,"containerName":"characters","localvar":"my","kind":13,"name":"$self"},{"line":340,"containerName":"characters","kind":13,"name":"$ch"},{"line":341,"name":"$self","containerName":"characters","kind":13},{"name":"within_element","containerName":"characters","kind":12,"line":341},{"name":"$hash","containerName":"characters","localvar":"my","kind":13,"line":342,"definition":"my"},{"containerName":"characters","kind":13,"name":"$self","line":342},{"line":343,"containerName":"characters","kind":13,"name":"$self"},{"line":343,"containerName":"characters","kind":12,"name":"in_element"},{"kind":13,"containerName":"characters","name":"$ch","line":345},{"line":345,"name":"$ch","containerName":"characters","kind":13},{"name":"$hash","containerName":"characters","kind":13,"line":346},{"line":346,"name":"$ch","containerName":"characters","kind":13},{"line":347,"kind":13,"containerName":"characters","name":"$self"},{"name":"in_element","containerName":"characters","kind":12,"line":347},{"name":"$ch","kind":13,"containerName":"characters","line":349},{"name":"$ch","kind":13,"containerName":"characters","line":349},{"line":350,"name":"$hash","kind":13,"containerName":"characters"},{"kind":13,"containerName":"characters","name":"$ch","line":350},{"name":"$self","containerName":"characters","kind":13,"line":351},{"kind":12,"containerName":"characters","name":"in_element","line":351},{"name":"$hash","kind":13,"containerName":"characters","line":352},{"line":352,"name":"$ch","containerName":"characters","kind":13},{"line":353,"name":"$self","containerName":"characters","kind":13},{"line":353,"name":"in_element","containerName":"characters","kind":12},{"kind":13,"containerName":"characters","name":"$hash","line":354},{"containerName":"characters","kind":13,"name":"$ch","line":354},{"name":"$self","kind":13,"containerName":"characters","line":355},{"line":355,"name":"in_element","kind":12,"containerName":"characters"},{"line":356,"containerName":"characters","kind":13,"name":"$hash"},{"line":356,"name":"$ch","containerName":"characters","kind":13},{"name":"$self","containerName":"characters","kind":13,"line":357},{"line":357,"name":"in_element","kind":12,"containerName":"characters"},{"line":358,"name":"$hash","kind":13,"containerName":"characters"},{"line":358,"kind":13,"containerName":"characters","name":"$hash"},{"line":358,"name":"$ch","containerName":"characters","kind":13},{"line":359,"kind":13,"containerName":"characters","name":"$hash"},{"line":360,"containerName":"characters","kind":13,"name":"$self"},{"kind":12,"containerName":"characters","name":"in_element","line":360},{"line":361,"kind":13,"containerName":"characters","name":"$hash"},{"line":361,"name":"$ch","containerName":"characters","kind":13},{"name":"$self","kind":13,"containerName":"characters","line":363}]},{"line":363,"name":"$hash","containerName":null,"kind":13},{"name":"$self","kind":13,"containerName":null,"line":365},{"line":365,"kind":12,"containerName":"main::","name":"debug"}]}