{"version":5,"vars":[{"line":88,"containerName":"","kind":2,"name":"base"},{"children":[{"containerName":"get_nodes","localvar":"my","kind":13,"name":"$self","line":102,"definition":"my"},{"name":"$self","kind":13,"containerName":"get_nodes","line":103},{"line":103,"kind":12,"containerName":"get_nodes","name":"throw_not_implemented"}],"name":"get_nodes","containerName":"main::","definition":"sub","detail":"($self)","line":101,"range":{"end":{"line":104,"character":9999},"start":{"line":101,"character":0}},"kind":12,"signature":{"documentation":"1;\n# $Id: TreeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::TreeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::TreeI - A Tree object suitable for lots of things, designed\n  originally for Phylogenetic Trees.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Tree::TreeI somehow\n  # like from a TreeIO\n  my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n  my $tree   = $treeio->next_tree;\n  my @nodes  = $tree->get_nodes;\n  my @leaves = $tree->get_leaf_nodes;\n  my $root   = $tree->get_root_node;\n\n=head1 DESCRIPTION\n\nThis object holds a pointer to the Root of a Tree which is a\nBio::Tree::NodeI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey, amackey@virginia.edu\nElia Stupka,  elia@fugu-sg.org\nSendu Bala,   bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::TreeI;\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Tree::NodeI objects\n Returns : array of Tree::NodeI objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order","parameters":[{"label":"$self"}],"label":"get_nodes($self)"}},{"signature":{"label":"get_root_node($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: TreeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::TreeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::TreeI - A Tree object suitable for lots of things, designed\n  originally for Phylogenetic Trees.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Tree::TreeI somehow\n  # like from a TreeIO\n  my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n  my $tree   = $treeio->next_tree;\n  my @nodes  = $tree->get_nodes;\n  my @leaves = $tree->get_leaf_nodes;\n  my $root   = $tree->get_root_node;\n\n=head1 DESCRIPTION\n\nThis object holds a pointer to the Root of a Tree which is a\nBio::Tree::NodeI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey, amackey@virginia.edu\nElia Stupka,  elia@fugu-sg.org\nSendu Bala,   bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::TreeI;\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Tree::NodeI objects\n Returns : array of Tree::NodeI objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Tree::NodeI object\n Args    : none"},"range":{"start":{"line":117,"character":0},"end":{"line":120,"character":9999}},"kind":12,"line":117,"detail":"($self)","definition":"sub","containerName":"main::","name":"get_root_node","children":[{"localvar":"my","containerName":"get_root_node","kind":13,"name":"$self","line":118,"definition":"my"},{"name":"$self","containerName":"get_root_node","kind":13,"line":119},{"name":"throw_not_implemented","kind":12,"containerName":"get_root_node","line":119}]},{"line":132,"range":{"end":{"line":139,"character":9999},"start":{"character":0,"line":132}},"kind":12,"signature":{"label":"number_nodes($self)","documentation":"1;\n# $Id: TreeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::TreeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::TreeI - A Tree object suitable for lots of things, designed\n  originally for Phylogenetic Trees.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Tree::TreeI somehow\n  # like from a TreeIO\n  my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n  my $tree   = $treeio->next_tree;\n  my @nodes  = $tree->get_nodes;\n  my @leaves = $tree->get_leaf_nodes;\n  my $root   = $tree->get_root_node;\n\n=head1 DESCRIPTION\n\nThis object holds a pointer to the Root of a Tree which is a\nBio::Tree::NodeI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey, amackey@virginia.edu\nElia Stupka,  elia@fugu-sg.org\nSendu Bala,   bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::TreeI;\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Tree::NodeI objects\n Returns : array of Tree::NodeI objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Tree::NodeI object\n Args    : none\n\n\nsub get_root_node{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 number_nodes\n\n Title   : number_nodes\n Usage   : my $size = $tree->number_nodes\n Function: Find the number of nodes in the tree.\n Returns : int\n Args    : none","parameters":[{"label":"$self"}]},"children":[{"definition":"my","line":133,"containerName":"number_nodes","localvar":"my","kind":13,"name":"$self"},{"definition":"my","localvar":"my","containerName":"number_nodes","kind":13,"name":"$root","line":134},{"line":134,"kind":13,"containerName":"number_nodes","name":"$self"},{"line":134,"containerName":"number_nodes","kind":12,"name":"get_root_node"},{"containerName":"number_nodes","kind":13,"name":"$root","line":135},{"name":"$root","containerName":"number_nodes","kind":13,"line":135},{"kind":12,"containerName":"number_nodes","name":"isa","line":135},{"name":"$root","containerName":"number_nodes","kind":13,"line":136},{"line":136,"name":"descendent_count","kind":12,"containerName":"number_nodes"}],"name":"number_nodes","containerName":"main::","definition":"sub","detail":"($self)"},{"detail":"($self)","definition":"sub","name":"total_branch_length","containerName":"main::","children":[{"name":"$self","localvar":"my","containerName":"total_branch_length","kind":13,"line":152,"definition":"my"},{"line":153,"kind":13,"containerName":"total_branch_length","name":"$self"},{"line":153,"kind":12,"containerName":"total_branch_length","name":"throw_not_implemented"}],"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: TreeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::TreeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::TreeI - A Tree object suitable for lots of things, designed\n  originally for Phylogenetic Trees.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Tree::TreeI somehow\n  # like from a TreeIO\n  my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n  my $tree   = $treeio->next_tree;\n  my @nodes  = $tree->get_nodes;\n  my @leaves = $tree->get_leaf_nodes;\n  my $root   = $tree->get_root_node;\n\n=head1 DESCRIPTION\n\nThis object holds a pointer to the Root of a Tree which is a\nBio::Tree::NodeI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey, amackey@virginia.edu\nElia Stupka,  elia@fugu-sg.org\nSendu Bala,   bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::TreeI;\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Tree::NodeI objects\n Returns : array of Tree::NodeI objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Tree::NodeI object\n Args    : none\n\n\nsub get_root_node{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 number_nodes\n\n Title   : number_nodes\n Usage   : my $size = $tree->number_nodes\n Function: Find the number of nodes in the tree.\n Returns : int\n Args    : none\n\n\nsub number_nodes{\n   my ($self) = @_;\n   my $root = $self->get_root_node;\n   if( defined $root && $root->isa('Bio::Tree::NodeI'))  {\n       return ($root->descendent_count + 1);\n   }\n   return 0;\n}\n\n=head2 total_branch_length\n\n Title   : total_branch_length\n Usage   : my $size = $tree->total_branch_length\n Function: Returns the sum of the length of all branches\n Returns : integer\n Args    : none","label":"total_branch_length($self)"},"range":{"start":{"character":0,"line":151},"end":{"character":9999,"line":154}},"kind":12,"line":151},{"kind":12,"range":{"start":{"line":169,"character":0},"end":{"character":9999,"line":174}},"line":169,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: TreeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::TreeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::TreeI - A Tree object suitable for lots of things, designed\n  originally for Phylogenetic Trees.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Tree::TreeI somehow\n  # like from a TreeIO\n  my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n  my $tree   = $treeio->next_tree;\n  my @nodes  = $tree->get_nodes;\n  my @leaves = $tree->get_leaf_nodes;\n  my $root   = $tree->get_root_node;\n\n=head1 DESCRIPTION\n\nThis object holds a pointer to the Root of a Tree which is a\nBio::Tree::NodeI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey, amackey@virginia.edu\nElia Stupka,  elia@fugu-sg.org\nSendu Bala,   bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::TreeI;\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Tree::NodeI objects\n Returns : array of Tree::NodeI objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Tree::NodeI object\n Args    : none\n\n\nsub get_root_node{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 number_nodes\n\n Title   : number_nodes\n Usage   : my $size = $tree->number_nodes\n Function: Find the number of nodes in the tree.\n Returns : int\n Args    : none\n\n\nsub number_nodes{\n   my ($self) = @_;\n   my $root = $self->get_root_node;\n   if( defined $root && $root->isa('Bio::Tree::NodeI'))  {\n       return ($root->descendent_count + 1);\n   }\n   return 0;\n}\n\n=head2 total_branch_length\n\n Title   : total_branch_length\n Usage   : my $size = $tree->total_branch_length\n Function: Returns the sum of the length of all branches\n Returns : integer\n Args    : none\n\n\nsub total_branch_length {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 height\n\n Title   : height\n Usage   : my $height = $tree->height\n Function: Gets the height of tree - this LOG_2($number_nodes)\n           WARNING: this is only true for strict binary trees.  The TreeIO\n           system is capable of building non-binary trees, for which this\n           method will currently return an incorrect value!!\n Returns : integer\n Args    : none","label":"height($self)"},"containerName":"main::","name":"height","children":[{"localvar":"my","kind":13,"containerName":"height","name":"$self","line":170,"definition":"my"},{"line":171,"localvar":"my","containerName":"height","kind":13,"name":"$nodect","definition":"my"},{"line":171,"name":"$self","containerName":"height","kind":13},{"line":171,"containerName":"height","kind":12,"name":"number_nodes"},{"containerName":"height","kind":13,"name":"$nodect","line":172},{"kind":13,"containerName":"height","name":"$nodect","line":173}],"detail":"($self)","definition":"sub"},{"detail":"($self,@args)","definition":"sub","containerName":"main::","name":"id","children":[{"definition":"my","line":188,"localvar":"my","containerName":"id","kind":13,"name":"$self"},{"kind":13,"containerName":"id","name":"@args","line":188},{"name":"$self","containerName":"id","kind":13,"line":189},{"line":189,"name":"throw_not_implemented","containerName":"id","kind":12}],"signature":{"label":"id($self,@args)","documentation":"1;\n# $Id: TreeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::TreeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::TreeI - A Tree object suitable for lots of things, designed\n  originally for Phylogenetic Trees.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Tree::TreeI somehow\n  # like from a TreeIO\n  my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n  my $tree   = $treeio->next_tree;\n  my @nodes  = $tree->get_nodes;\n  my @leaves = $tree->get_leaf_nodes;\n  my $root   = $tree->get_root_node;\n\n=head1 DESCRIPTION\n\nThis object holds a pointer to the Root of a Tree which is a\nBio::Tree::NodeI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey, amackey@virginia.edu\nElia Stupka,  elia@fugu-sg.org\nSendu Bala,   bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::TreeI;\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Tree::NodeI objects\n Returns : array of Tree::NodeI objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Tree::NodeI object\n Args    : none\n\n\nsub get_root_node{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 number_nodes\n\n Title   : number_nodes\n Usage   : my $size = $tree->number_nodes\n Function: Find the number of nodes in the tree.\n Returns : int\n Args    : none\n\n\nsub number_nodes{\n   my ($self) = @_;\n   my $root = $self->get_root_node;\n   if( defined $root && $root->isa('Bio::Tree::NodeI'))  {\n       return ($root->descendent_count + 1);\n   }\n   return 0;\n}\n\n=head2 total_branch_length\n\n Title   : total_branch_length\n Usage   : my $size = $tree->total_branch_length\n Function: Returns the sum of the length of all branches\n Returns : integer\n Args    : none\n\n\nsub total_branch_length {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 height\n\n Title   : height\n Usage   : my $height = $tree->height\n Function: Gets the height of tree - this LOG_2($number_nodes)\n           WARNING: this is only true for strict binary trees.  The TreeIO\n           system is capable of building non-binary trees, for which this\n           method will currently return an incorrect value!!\n Returns : integer\n Args    : none\n\n\nsub height{\n   my ($self) = @_;\n   my $nodect =  $self->number_nodes;\n   return 0 if( ! $nodect ); \n   return log($nodect) / log(2);\n}\n\n=head2 id\n\n Title   : id\n Usage   : my $id = $tree->id();\n Function: An id value for the tree\n Returns : scalar\n Args    : ","parameters":[{"label":"$self"},{"label":"@args"}]},"kind":12,"range":{"start":{"character":0,"line":187},"end":{"character":9999,"line":190}},"line":187},{"detail":"($self,$value)","definition":"sub","name":"score","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"score","line":206},{"line":206,"containerName":"score","kind":13,"name":"$value"},{"name":"$self","containerName":"score","kind":13,"line":207},{"containerName":"score","kind":12,"name":"throw_not_implemented","line":207}],"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: TreeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::TreeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::TreeI - A Tree object suitable for lots of things, designed\n  originally for Phylogenetic Trees.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Tree::TreeI somehow\n  # like from a TreeIO\n  my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n  my $tree   = $treeio->next_tree;\n  my @nodes  = $tree->get_nodes;\n  my @leaves = $tree->get_leaf_nodes;\n  my $root   = $tree->get_root_node;\n\n=head1 DESCRIPTION\n\nThis object holds a pointer to the Root of a Tree which is a\nBio::Tree::NodeI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey, amackey@virginia.edu\nElia Stupka,  elia@fugu-sg.org\nSendu Bala,   bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::TreeI;\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Tree::NodeI objects\n Returns : array of Tree::NodeI objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Tree::NodeI object\n Args    : none\n\n\nsub get_root_node{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 number_nodes\n\n Title   : number_nodes\n Usage   : my $size = $tree->number_nodes\n Function: Find the number of nodes in the tree.\n Returns : int\n Args    : none\n\n\nsub number_nodes{\n   my ($self) = @_;\n   my $root = $self->get_root_node;\n   if( defined $root && $root->isa('Bio::Tree::NodeI'))  {\n       return ($root->descendent_count + 1);\n   }\n   return 0;\n}\n\n=head2 total_branch_length\n\n Title   : total_branch_length\n Usage   : my $size = $tree->total_branch_length\n Function: Returns the sum of the length of all branches\n Returns : integer\n Args    : none\n\n\nsub total_branch_length {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 height\n\n Title   : height\n Usage   : my $height = $tree->height\n Function: Gets the height of tree - this LOG_2($number_nodes)\n           WARNING: this is only true for strict binary trees.  The TreeIO\n           system is capable of building non-binary trees, for which this\n           method will currently return an incorrect value!!\n Returns : integer\n Args    : none\n\n\nsub height{\n   my ($self) = @_;\n   my $nodect =  $self->number_nodes;\n   return 0 if( ! $nodect ); \n   return log($nodect) / log(2);\n}\n\n=head2 id\n\n Title   : id\n Usage   : my $id = $tree->id();\n Function: An id value for the tree\n Returns : scalar\n Args    : \n\n\n\nsub id{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 score\n\n Title   : score\n Usage   : $obj->score($newval)\n Function: Sets the associated score with this tree\n           This is a generic slot which is probably best used \n           for log likelihood or other overall tree score\n Returns : value of score\n Args    : newvalue (optional)","label":"score($self,$value)"},"range":{"start":{"character":0,"line":205},"end":{"line":208,"character":9999}},"kind":12,"line":205},{"children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"get_leaf_nodes","line":222},{"kind":12,"containerName":"get_leaf_nodes","name":"is_Leaf","line":223},{"name":"$self","kind":13,"containerName":"get_leaf_nodes","line":223},{"line":223,"kind":12,"containerName":"get_leaf_nodes","name":"get_nodes"}],"containerName":"main::","name":"get_leaf_nodes","definition":"sub","detail":"($self)","line":221,"kind":12,"range":{"start":{"character":0,"line":221},"end":{"character":9999,"line":224}},"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: TreeI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::TreeI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::TreeI - A Tree object suitable for lots of things, designed\n  originally for Phylogenetic Trees.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Tree::TreeI somehow\n  # like from a TreeIO\n  my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n  my $tree   = $treeio->next_tree;\n  my @nodes  = $tree->get_nodes;\n  my @leaves = $tree->get_leaf_nodes;\n  my $root   = $tree->get_root_node;\n\n=head1 DESCRIPTION\n\nThis object holds a pointer to the Root of a Tree which is a\nBio::Tree::NodeI.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey, amackey@virginia.edu\nElia Stupka,  elia@fugu-sg.org\nSendu Bala,   bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::TreeI;\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Tree::NodeI objects\n Returns : array of Tree::NodeI objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Tree::NodeI object\n Args    : none\n\n\nsub get_root_node{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 number_nodes\n\n Title   : number_nodes\n Usage   : my $size = $tree->number_nodes\n Function: Find the number of nodes in the tree.\n Returns : int\n Args    : none\n\n\nsub number_nodes{\n   my ($self) = @_;\n   my $root = $self->get_root_node;\n   if( defined $root && $root->isa('Bio::Tree::NodeI'))  {\n       return ($root->descendent_count + 1);\n   }\n   return 0;\n}\n\n=head2 total_branch_length\n\n Title   : total_branch_length\n Usage   : my $size = $tree->total_branch_length\n Function: Returns the sum of the length of all branches\n Returns : integer\n Args    : none\n\n\nsub total_branch_length {\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 height\n\n Title   : height\n Usage   : my $height = $tree->height\n Function: Gets the height of tree - this LOG_2($number_nodes)\n           WARNING: this is only true for strict binary trees.  The TreeIO\n           system is capable of building non-binary trees, for which this\n           method will currently return an incorrect value!!\n Returns : integer\n Args    : none\n\n\nsub height{\n   my ($self) = @_;\n   my $nodect =  $self->number_nodes;\n   return 0 if( ! $nodect ); \n   return log($nodect) / log(2);\n}\n\n=head2 id\n\n Title   : id\n Usage   : my $id = $tree->id();\n Function: An id value for the tree\n Returns : scalar\n Args    : \n\n\n\nsub id{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 score\n\n Title   : score\n Usage   : $obj->score($newval)\n Function: Sets the associated score with this tree\n           This is a generic slot which is probably best used \n           for log likelihood or other overall tree score\n Returns : value of score\n Args    : newvalue (optional)\n\n\n\nsub score{\n   my ($self,$value) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 get_leaf_nodes\n\n Title   : get_leaf_nodes\n Usage   : my @leaves = $tree->get_leaf_nodes()\n Function: Returns the leaves (tips) of the tree\n Returns : Array of Bio::Tree::NodeI objects\n Args    : none","label":"get_leaf_nodes($self)"}},{"line":243,"range":{"end":{"character":9999,"line":245},"start":{"character":0,"line":243}},"kind":12,"children":[{"kind":12,"containerName":"set_tag_value","name":"throw_not_implemented","line":244}],"name":"set_tag_value","containerName":"main::","definition":"sub"},{"line":259,"range":{"end":{"line":261,"character":9999},"start":{"character":0,"line":259}},"kind":12,"children":[{"containerName":"add_tag_value","kind":12,"name":"throw_not_implemented","line":260}],"name":"add_tag_value","containerName":"main::","definition":"sub"},{"line":274,"range":{"end":{"line":276,"character":9999},"start":{"line":274,"character":0}},"kind":12,"definition":"sub","children":[{"name":"throw_not_implemented","kind":12,"containerName":"remove_tag","line":275}],"name":"remove_tag","containerName":"main::"},{"kind":12,"range":{"end":{"character":9999,"line":291},"start":{"character":0,"line":289}},"line":289,"definition":"sub","containerName":"main::","name":"remove_all_tags","children":[{"line":290,"containerName":"remove_all_tags","kind":12,"name":"throw_not_implemented"}]},{"line":304,"range":{"start":{"character":0,"line":304},"end":{"line":306,"character":9999}},"kind":12,"definition":"sub","children":[{"containerName":"get_all_tags","kind":12,"name":"throw_not_implemented","line":305}],"name":"get_all_tags","containerName":"main::"},{"children":[{"line":320,"kind":12,"containerName":"get_tag_values","name":"throw_not_implemented"}],"containerName":"main::","name":"get_tag_values","definition":"sub","line":319,"kind":12,"range":{"start":{"line":319,"character":0},"end":{"character":9999,"line":321}}},{"kind":12,"range":{"end":{"character":9999,"line":336},"start":{"line":334,"character":0}},"line":334,"definition":"sub","containerName":"main::","name":"has_tag","children":[{"name":"throw_not_implemented","containerName":"has_tag","kind":12,"line":335}]}]}