{"version":5,"vars":[{"line":110,"containerName":"","kind":2,"name":"base"},{"definition":"sub","detail":"($class,@args)","children":[{"definition":"my","name":"$class","kind":13,"localvar":"my","containerName":"new","line":132},{"line":132,"containerName":"new","kind":13,"name":"@args"},{"line":134,"name":"$self","kind":13,"localvar":"my","containerName":"new","definition":"my"},{"name":"$class","containerName":"new","kind":13,"line":134},{"name":"@args","containerName":"new","kind":13,"line":134},{"line":135,"name":"$self","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$self","line":136},{"name":"$self","containerName":"new","kind":13,"line":137},{"line":137,"name":"_register_for_cleanup","containerName":"new","kind":12},{"line":138,"name":"$root","localvar":"my","kind":13,"containerName":"new","definition":"my"},{"line":138,"kind":13,"containerName":"new","name":"$node"},{"line":138,"kind":13,"containerName":"new","name":"$nodel"},{"name":"$id","containerName":"new","kind":13,"line":138},{"name":"$score","kind":13,"containerName":"new","line":138},{"line":138,"kind":13,"containerName":"new","name":"$self"},{"line":138,"name":"_rearrange","kind":12,"containerName":"new"},{"name":"@args","kind":13,"containerName":"new","line":139},{"kind":13,"containerName":"new","name":"$node","line":141},{"name":"$root","kind":13,"containerName":"new","line":141},{"name":"$self","kind":13,"containerName":"new","line":142},{"kind":12,"containerName":"new","name":"throw","line":142},{"line":142,"kind":13,"containerName":"new","name":"$node"},{"containerName":"new","kind":13,"name":"$node","line":142},{"line":142,"name":"isa","containerName":"new","kind":12},{"definition":"my","line":143,"kind":13,"localvar":"my","containerName":"new","name":"@lineage"},{"line":143,"kind":13,"containerName":"new","name":"$self"},{"line":143,"kind":12,"containerName":"new","name":"get_lineage_nodes"},{"line":143,"name":"$node","containerName":"new","kind":13},{"line":144,"name":"$root","kind":13,"containerName":"new"},{"line":144,"kind":13,"containerName":"new","name":"@lineage"},{"line":144,"kind":13,"containerName":"new","name":"$node"},{"kind":13,"containerName":"new","name":"$node","line":148},{"name":"isa","kind":12,"containerName":"new","line":148},{"line":149,"kind":13,"containerName":"new","name":"@lineage"},{"name":"$node","containerName":"new","kind":13,"line":149},{"name":"$node","kind":13,"containerName":"new","line":149},{"kind":13,"containerName":"new","name":"$root","line":149},{"definition":"my","kind":13,"localvar":"my","containerName":"new","name":"$ancestor","line":150},{"line":150,"name":"$root","kind":13,"containerName":"new"},{"kind":13,"localvar":"my","containerName":"new","name":"$lineage_node","line":151,"definition":"my"},{"line":151,"name":"@lineage","containerName":"new","kind":13},{"line":152,"name":"$lineage_node","kind":13,"containerName":"new"},{"line":152,"containerName":"new","kind":12,"name":"ancestor"},{"containerName":"new","kind":13,"name":"$ancestor","line":152},{"kind":13,"containerName":"new","name":"$ancestor","line":153},{"kind":13,"containerName":"new","name":"$lineage_node","line":153},{"kind":13,"containerName":"new","name":"$root","line":156},{"kind":13,"containerName":"new","name":"$self","line":157},{"kind":12,"containerName":"new","name":"set_root_node","line":157},{"name":"$root","containerName":"new","kind":13,"line":157},{"line":160,"kind":13,"containerName":"new","name":"$self"},{"line":160,"name":"nodelete","kind":12,"containerName":"new"},{"line":160,"containerName":"new","kind":13,"name":"$nodel"},{"name":"$self","kind":13,"containerName":"new","line":161},{"line":161,"name":"id","containerName":"new","kind":12},{"containerName":"new","kind":13,"name":"$id","line":161},{"containerName":"new","kind":13,"name":"$id","line":161},{"line":162,"containerName":"new","kind":13,"name":"$self"},{"containerName":"new","kind":12,"name":"score","line":162},{"containerName":"new","kind":13,"name":"$score","line":162},{"kind":13,"containerName":"new","name":"$score","line":162},{"line":163,"name":"$self","kind":13,"containerName":"new"}],"containerName":"main::","name":"new","signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Tree.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::Tree - An Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Nodes which make up a tree.\n\n=head1 IMPLEMENTATION NOTE\n\nThis implementation of Bio::Tree::Tree contains Bio::Tree:::NodeI; mainly linked\nvia the root node. As NodeI can potentially contain circular references (as\nnodes will need to refer to both parent and child nodes), Bio::Tree::Tree will\nremove those circular references when the object is garbage-collected. This has\nsome side effects; primarily, one must keep the Tree in scope or have at least\none reference to it if working with nodes. The fix is to count the references to\nthe nodes and if it is greater than expected retain all of them, but it requires\nan additional prereq and thus may not be worth the effort.  This only shows up\nin minor edge cases, though (see Bug #2869).\n\nExample of issue:\n\n  # tree is not assigned to a variable, so passes from memory after\n  # root node is passed\n  my $root = Bio::TreeIO->new(-format => 'newick', -file => 'foo.txt')->next_tree\n\t\t ->get_root_node;\n  \n  # gets nothing, as all Node links are broken when Tree is garbage-collected above\n  my @descendents = $root->get_all_Descendents;\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\nSendu Bala   bix@sendu.me.uk\nMark A. Jensen maj@fortinbras.us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::Tree->new();\n Function: Builds a new Bio::Tree::Tree object \n Returns : Bio::Tree::Tree\n Args    : -root     => L<Bio::Tree::NodeI> object which is the root\n             OR\n           -node     => L<Bio::Tree::NodeI> object from which the root will be\n                        determined\n\n           -nodelete => boolean, whether or not to try and cleanup all\n                                 the nodes when this this tree goes out\n                                 of scope.\n           -id       => optional tree ID\n           -score    => optional tree score value","label":"new($class,@args)"},"line":131,"kind":12,"range":{"start":{"line":131,"character":0},"end":{"character":9999,"line":164}}},{"name":"SUPER","kind":12,"containerName":"new","line":134},{"kind":12,"name":"cleanup_tree","line":137},{"name":"nodelete","containerName":"main::","children":[{"definition":"my","line":180,"localvar":"my","containerName":"nodelete","kind":13,"name":"$self"},{"name":"$self","kind":13,"containerName":"nodelete","line":181},{"line":182,"name":"$self","containerName":"nodelete","kind":13}],"definition":"sub","kind":12,"range":{"end":{"line":183,"character":9999},"start":{"line":179,"character":0}},"line":179},{"kind":12,"range":{"start":{"character":0,"line":196},"end":{"line":216,"character":9999}},"line":196,"signature":{"label":"get_nodes($self,@args)","documentation":"1;\n# $Id: Tree.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::Tree - An Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Nodes which make up a tree.\n\n=head1 IMPLEMENTATION NOTE\n\nThis implementation of Bio::Tree::Tree contains Bio::Tree:::NodeI; mainly linked\nvia the root node. As NodeI can potentially contain circular references (as\nnodes will need to refer to both parent and child nodes), Bio::Tree::Tree will\nremove those circular references when the object is garbage-collected. This has\nsome side effects; primarily, one must keep the Tree in scope or have at least\none reference to it if working with nodes. The fix is to count the references to\nthe nodes and if it is greater than expected retain all of them, but it requires\nan additional prereq and thus may not be worth the effort.  This only shows up\nin minor edge cases, though (see Bug #2869).\n\nExample of issue:\n\n  # tree is not assigned to a variable, so passes from memory after\n  # root node is passed\n  my $root = Bio::TreeIO->new(-format => 'newick', -file => 'foo.txt')->next_tree\n\t\t ->get_root_node;\n  \n  # gets nothing, as all Node links are broken when Tree is garbage-collected above\n  my @descendents = $root->get_all_Descendents;\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\nSendu Bala   bix@sendu.me.uk\nMark A. Jensen maj@fortinbras.us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::Tree->new();\n Function: Builds a new Bio::Tree::Tree object \n Returns : Bio::Tree::Tree\n Args    : -root     => L<Bio::Tree::NodeI> object which is the root\n             OR\n           -node     => L<Bio::Tree::NodeI> object from which the root will be\n                        determined\n\n           -nodelete => boolean, whether or not to try and cleanup all\n                                 the nodes when this this tree goes out\n                                 of scope.\n           -id       => optional tree ID\n           -score    => optional tree score value\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n  $self->{'_rootnode'} = undef;\n  $self->{'_maxbranchlen'} = 0;\n  $self->_register_for_cleanup(\\&cleanup_tree);\n  my ($root,$node,$nodel,$id,$score)= $self->_rearrange([qw(ROOT NODE NODELETE \n                              ID SCORE)], @args);\n  \n  if ($node && ! $root) {\n    $self->throw(\"Must supply a Bio::Tree::NodeI\") unless ref($node) && $node->isa('Bio::Tree::NodeI');\n    my @lineage = $self->get_lineage_nodes($node);\n    $root = shift(@lineage) || $node;\n    \n    # to stop us pulling in entire database of a Bio::Taxon when we later do\n    # get_nodes() or similar, specifically set ancestor() for each node\n    if ($node->isa('Bio::Taxon')) {\n      push(@lineage, $node) unless $node eq $root;\n      my $ancestor = $root;\n      foreach my $lineage_node (@lineage) {\n        $lineage_node->ancestor($ancestor);\n      } continue { $ancestor = $lineage_node; }\n    }\n  }\n  if ($root) {\n    $self->set_root_node($root);\n  }\n  \n  $self->nodelete($nodel || 0);\n  $self->id($id)       if defined $id;\n  $self->score($score) if defined $score;\n  return $self;\n}\n\n\n=head2 nodelete\n\n Title   : nodelete\n Usage   : $obj->nodelete($newval)\n Function: Get/Set Boolean whether or not to delete the underlying\n           nodes when it goes out of scope.  By default this is false\n           meaning trees are cleaned up.\n Returns : boolean\n Args    : on set, new boolean value\n\n\nsub nodelete{\n    my $self = shift;\n    return $self->{'nodelete'} = shift if @_;\n    return $self->{'nodelete'};\n}\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Bio::Tree::NodeI objects\n Returns : array of Bio::Tree::NodeI objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order","parameters":[{"label":"$self"},{"label":"@args"}]},"containerName":"main::","name":"get_nodes","children":[{"definition":"my","containerName":"get_nodes","localvar":"my","kind":13,"name":"$self","line":197},{"kind":13,"containerName":"get_nodes","name":"@args","line":197},{"kind":13,"localvar":"my","containerName":"get_nodes","name":"$order","line":199,"definition":"my"},{"line":199,"kind":13,"containerName":"get_nodes","name":"$sortby"},{"containerName":"get_nodes","kind":13,"name":"$self","line":199},{"name":"_rearrange","containerName":"get_nodes","kind":12,"line":199},{"line":199,"kind":13,"containerName":"get_nodes","name":"@args"},{"line":200,"kind":13,"containerName":"get_nodes","name":"$order"},{"name":"$sortby","kind":13,"containerName":"get_nodes","line":201},{"definition":"my","name":"$node","localvar":"my","kind":13,"containerName":"get_nodes","line":202},{"line":202,"name":"$self","kind":13,"containerName":"get_nodes"},{"line":202,"name":"get_root_node","kind":12,"containerName":"get_nodes"},{"line":203,"kind":13,"containerName":"get_nodes","name":"$order"},{"kind":13,"localvar":"my","containerName":"get_nodes","name":"@children","line":204,"definition":"my"},{"name":"$node","kind":13,"containerName":"get_nodes","line":204},{"line":205,"kind":13,"containerName":"get_nodes","name":"@children"},{"line":206,"name":"@children","containerName":"get_nodes","kind":13},{"name":"each_Descendent","containerName":"get_nodes","kind":12,"line":206},{"line":206,"containerName":"get_nodes","kind":13,"name":"$sortby"},{"containerName":"get_nodes","kind":13,"name":"@children","line":208},{"name":"$order","containerName":"get_nodes","kind":13,"line":211},{"definition":"my","line":213,"localvar":"my","kind":13,"containerName":"get_nodes","name":"@children"},{"name":"$node","kind":13,"containerName":"get_nodes","line":213},{"containerName":"get_nodes","kind":13,"name":"$node","line":213},{"line":213,"name":"get_all_Descendents","kind":12,"containerName":"get_nodes"},{"line":213,"name":"$sortby","containerName":"get_nodes","kind":13},{"line":214,"name":"@children","containerName":"get_nodes","kind":13}],"detail":"($self,@args)","definition":"sub"},{"containerName":"main::","name":"get_root_node","children":[{"line":231,"name":"$self","localvar":"my","containerName":"get_root_node","kind":13,"definition":"my"},{"kind":13,"containerName":"get_root_node","name":"$self","line":232}],"detail":"($self)","definition":"sub","range":{"end":{"character":9999,"line":233},"start":{"character":0,"line":230}},"kind":12,"line":230,"signature":{"documentation":"1;\n# $Id: Tree.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::Tree - An Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Nodes which make up a tree.\n\n=head1 IMPLEMENTATION NOTE\n\nThis implementation of Bio::Tree::Tree contains Bio::Tree:::NodeI; mainly linked\nvia the root node. As NodeI can potentially contain circular references (as\nnodes will need to refer to both parent and child nodes), Bio::Tree::Tree will\nremove those circular references when the object is garbage-collected. This has\nsome side effects; primarily, one must keep the Tree in scope or have at least\none reference to it if working with nodes. The fix is to count the references to\nthe nodes and if it is greater than expected retain all of them, but it requires\nan additional prereq and thus may not be worth the effort.  This only shows up\nin minor edge cases, though (see Bug #2869).\n\nExample of issue:\n\n  # tree is not assigned to a variable, so passes from memory after\n  # root node is passed\n  my $root = Bio::TreeIO->new(-format => 'newick', -file => 'foo.txt')->next_tree\n\t\t ->get_root_node;\n  \n  # gets nothing, as all Node links are broken when Tree is garbage-collected above\n  my @descendents = $root->get_all_Descendents;\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\nSendu Bala   bix@sendu.me.uk\nMark A. Jensen maj@fortinbras.us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::Tree->new();\n Function: Builds a new Bio::Tree::Tree object \n Returns : Bio::Tree::Tree\n Args    : -root     => L<Bio::Tree::NodeI> object which is the root\n             OR\n           -node     => L<Bio::Tree::NodeI> object from which the root will be\n                        determined\n\n           -nodelete => boolean, whether or not to try and cleanup all\n                                 the nodes when this this tree goes out\n                                 of scope.\n           -id       => optional tree ID\n           -score    => optional tree score value\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n  $self->{'_rootnode'} = undef;\n  $self->{'_maxbranchlen'} = 0;\n  $self->_register_for_cleanup(\\&cleanup_tree);\n  my ($root,$node,$nodel,$id,$score)= $self->_rearrange([qw(ROOT NODE NODELETE \n                              ID SCORE)], @args);\n  \n  if ($node && ! $root) {\n    $self->throw(\"Must supply a Bio::Tree::NodeI\") unless ref($node) && $node->isa('Bio::Tree::NodeI');\n    my @lineage = $self->get_lineage_nodes($node);\n    $root = shift(@lineage) || $node;\n    \n    # to stop us pulling in entire database of a Bio::Taxon when we later do\n    # get_nodes() or similar, specifically set ancestor() for each node\n    if ($node->isa('Bio::Taxon')) {\n      push(@lineage, $node) unless $node eq $root;\n      my $ancestor = $root;\n      foreach my $lineage_node (@lineage) {\n        $lineage_node->ancestor($ancestor);\n      } continue { $ancestor = $lineage_node; }\n    }\n  }\n  if ($root) {\n    $self->set_root_node($root);\n  }\n  \n  $self->nodelete($nodel || 0);\n  $self->id($id)       if defined $id;\n  $self->score($score) if defined $score;\n  return $self;\n}\n\n\n=head2 nodelete\n\n Title   : nodelete\n Usage   : $obj->nodelete($newval)\n Function: Get/Set Boolean whether or not to delete the underlying\n           nodes when it goes out of scope.  By default this is false\n           meaning trees are cleaned up.\n Returns : boolean\n Args    : on set, new boolean value\n\n\nsub nodelete{\n    my $self = shift;\n    return $self->{'nodelete'} = shift if @_;\n    return $self->{'nodelete'};\n}\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Bio::Tree::NodeI objects\n Returns : array of Bio::Tree::NodeI objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self, @args) = @_;\n   \n   my ($order, $sortby) = $self->_rearrange([qw(ORDER SORTBY)],@args);\n   $order ||= 'depth';\n   $sortby ||= 'none';\n   my $node = $self->get_root_node || return;\n   if ($order =~ m/^b|(breadth)$/oi) {\n       my @children = ($node);\n       for (@children) {\n        push @children, $_->each_Descendent($sortby);\n       }\n       return @children;\n   }\n\n   if ($order =~ m/^d|(depth)$/oi) {\n       # this is depth-first search I believe\n       my @children = ($node,$node->get_all_Descendents($sortby));\n       return @children;\n   }\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Tree::NodeI object\n Args    : none","parameters":[{"label":"$self"}],"label":"get_root_node($self)"}},{"range":{"start":{"character":0,"line":245},"end":{"character":9999,"line":257}},"kind":12,"line":245,"name":"set_root_node","containerName":"main::","children":[{"definition":"my","line":246,"kind":13,"localvar":"my","containerName":"set_root_node","name":"$self"},{"definition":"my","name":"$value","containerName":"set_root_node","localvar":"my","kind":13,"line":248},{"line":249,"kind":13,"containerName":"set_root_node","name":"$value"},{"kind":13,"containerName":"set_root_node","name":"$value","line":250},{"containerName":"set_root_node","kind":12,"name":"isa","line":250},{"line":251,"kind":13,"containerName":"set_root_node","name":"$self"},{"name":"warn","containerName":"set_root_node","kind":12,"line":251},{"line":252,"name":"$self","containerName":"set_root_node","kind":13},{"line":252,"name":"get_root_node","containerName":"set_root_node","kind":12},{"line":254,"kind":13,"containerName":"set_root_node","name":"$self"},{"line":254,"name":"$value","containerName":"set_root_node","kind":13},{"line":256,"containerName":"set_root_node","kind":13,"name":"$self"},{"line":256,"name":"get_root_node","containerName":"set_root_node","kind":12}],"definition":"sub"},{"children":[{"containerName":"total_branch_length","kind":12,"name":"subtree_length","line":269}],"containerName":"main::","name":"total_branch_length","definition":"sub","line":269,"range":{"end":{"character":9999,"line":269},"start":{"character":0,"line":269}},"kind":12},{"definition":"sub","containerName":"main::","name":"subtree_length","children":[{"line":284,"kind":13,"localvar":"my","containerName":"subtree_length","name":"$tree","definition":"my"},{"definition":"my","name":"$node","localvar":"my","kind":13,"containerName":"subtree_length","line":285},{"containerName":"subtree_length","kind":13,"name":"$tree","line":285},{"line":285,"name":"get_root_node","containerName":"subtree_length","kind":12},{"kind":13,"containerName":"subtree_length","name":"$node","line":286},{"name":"$sum","localvar":"my","kind":13,"containerName":"subtree_length","line":287,"definition":"my"},{"containerName":"subtree_length","kind":13,"name":"$node","line":288},{"line":288,"kind":12,"containerName":"subtree_length","name":"get_all_Descendents"},{"line":289,"name":"$sum","kind":13,"containerName":"subtree_length"},{"containerName":"subtree_length","kind":12,"name":"branch_length","line":289},{"containerName":"subtree_length","kind":13,"name":"$sum","line":291}],"range":{"end":{"character":9999,"line":292},"start":{"character":0,"line":283}},"kind":12,"line":283},{"containerName":"main::","name":"id","children":[{"line":307,"localvar":"my","containerName":"id","kind":13,"name":"$self","definition":"my"},{"line":307,"containerName":"id","kind":13,"name":"$val"},{"line":308,"kind":13,"containerName":"id","name":"$val"},{"line":309,"name":"$self","kind":13,"containerName":"id"},{"line":309,"kind":13,"containerName":"id","name":"$val"},{"line":311,"containerName":"id","kind":13,"name":"$self"}],"detail":"($self,$val)","definition":"sub","kind":12,"range":{"start":{"line":306,"character":0},"end":{"line":312,"character":9999}},"line":306,"signature":{"label":"id($self,$val)","parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"1;\n# $Id: Tree.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::Tree - An Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Nodes which make up a tree.\n\n=head1 IMPLEMENTATION NOTE\n\nThis implementation of Bio::Tree::Tree contains Bio::Tree:::NodeI; mainly linked\nvia the root node. As NodeI can potentially contain circular references (as\nnodes will need to refer to both parent and child nodes), Bio::Tree::Tree will\nremove those circular references when the object is garbage-collected. This has\nsome side effects; primarily, one must keep the Tree in scope or have at least\none reference to it if working with nodes. The fix is to count the references to\nthe nodes and if it is greater than expected retain all of them, but it requires\nan additional prereq and thus may not be worth the effort.  This only shows up\nin minor edge cases, though (see Bug #2869).\n\nExample of issue:\n\n  # tree is not assigned to a variable, so passes from memory after\n  # root node is passed\n  my $root = Bio::TreeIO->new(-format => 'newick', -file => 'foo.txt')->next_tree\n\t\t ->get_root_node;\n  \n  # gets nothing, as all Node links are broken when Tree is garbage-collected above\n  my @descendents = $root->get_all_Descendents;\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\nSendu Bala   bix@sendu.me.uk\nMark A. Jensen maj@fortinbras.us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::Tree->new();\n Function: Builds a new Bio::Tree::Tree object \n Returns : Bio::Tree::Tree\n Args    : -root     => L<Bio::Tree::NodeI> object which is the root\n             OR\n           -node     => L<Bio::Tree::NodeI> object from which the root will be\n                        determined\n\n           -nodelete => boolean, whether or not to try and cleanup all\n                                 the nodes when this this tree goes out\n                                 of scope.\n           -id       => optional tree ID\n           -score    => optional tree score value\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n  $self->{'_rootnode'} = undef;\n  $self->{'_maxbranchlen'} = 0;\n  $self->_register_for_cleanup(\\&cleanup_tree);\n  my ($root,$node,$nodel,$id,$score)= $self->_rearrange([qw(ROOT NODE NODELETE \n                              ID SCORE)], @args);\n  \n  if ($node && ! $root) {\n    $self->throw(\"Must supply a Bio::Tree::NodeI\") unless ref($node) && $node->isa('Bio::Tree::NodeI');\n    my @lineage = $self->get_lineage_nodes($node);\n    $root = shift(@lineage) || $node;\n    \n    # to stop us pulling in entire database of a Bio::Taxon when we later do\n    # get_nodes() or similar, specifically set ancestor() for each node\n    if ($node->isa('Bio::Taxon')) {\n      push(@lineage, $node) unless $node eq $root;\n      my $ancestor = $root;\n      foreach my $lineage_node (@lineage) {\n        $lineage_node->ancestor($ancestor);\n      } continue { $ancestor = $lineage_node; }\n    }\n  }\n  if ($root) {\n    $self->set_root_node($root);\n  }\n  \n  $self->nodelete($nodel || 0);\n  $self->id($id)       if defined $id;\n  $self->score($score) if defined $score;\n  return $self;\n}\n\n\n=head2 nodelete\n\n Title   : nodelete\n Usage   : $obj->nodelete($newval)\n Function: Get/Set Boolean whether or not to delete the underlying\n           nodes when it goes out of scope.  By default this is false\n           meaning trees are cleaned up.\n Returns : boolean\n Args    : on set, new boolean value\n\n\nsub nodelete{\n    my $self = shift;\n    return $self->{'nodelete'} = shift if @_;\n    return $self->{'nodelete'};\n}\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Bio::Tree::NodeI objects\n Returns : array of Bio::Tree::NodeI objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self, @args) = @_;\n   \n   my ($order, $sortby) = $self->_rearrange([qw(ORDER SORTBY)],@args);\n   $order ||= 'depth';\n   $sortby ||= 'none';\n   my $node = $self->get_root_node || return;\n   if ($order =~ m/^b|(breadth)$/oi) {\n       my @children = ($node);\n       for (@children) {\n        push @children, $_->each_Descendent($sortby);\n       }\n       return @children;\n   }\n\n   if ($order =~ m/^d|(depth)$/oi) {\n       # this is depth-first search I believe\n       my @children = ($node,$node->get_all_Descendents($sortby));\n       return @children;\n   }\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Tree::NodeI object\n Args    : none\n\n\n\nsub get_root_node{\n   my ($self) = @_;\n   return $self->{'_rootnode'};\n}\n\n=head2 set_root_node\n\n Title   : set_root_node\n Usage   : $tree->set_root_node($node)\n Function: Set the Root Node for the Tree\n Returns : Bio::Tree::NodeI\n Args    : Bio::Tree::NodeI\n\n\nsub set_root_node{\n   my $self = shift;\n   if( @_ ) { \n       my $value = shift;\n       if( defined $value && \n       ! $value->isa('Bio::Tree::NodeI') ) { \n       $self->warn(\"Trying to set the root node to $value which is not a Bio::Tree::NodeI\");\n       return $self->get_root_node;\n       }\n       $self->{'_rootnode'} = $value;\n   } \n   return $self->get_root_node;\n}\n\n=head2 total_branch_length\n\n Title   : total_branch_length\n Usage   : my $size = $tree->total_branch_length\n Function: Returns the sum of the length of all branches\n Returns : real\n Args    : none\n\n\nsub total_branch_length { shift->subtree_length }\n\n=head2 subtree_length\n\n Title   : subtree_length\n Usage   : my $subtree_size = $tree->subtree_length($internal_node)\n Function: Returns the sum of the length of all branches in a subtree\n           under the node. Calculates the size of the whole tree\n           without an argument (but only if root node is defined)\n Returns : real or undef\n Args    : Bio::Tree::NodeI object, defaults to the root node\n\n\nsub subtree_length {\n    my $tree = shift;\n    my $node = shift || $tree->get_root_node;\n    return unless $node;\n    my $sum = 0;\n    for ( $node->get_all_Descendents ) {\n    $sum += $_->branch_length || 0;\n    }\n    return $sum;\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : my $id = $tree->id();\n Function: An id value for the tree\n Returns : scalar\n Args    : [optional] new value to set"}},{"detail":"($self,$val)","definition":"sub","containerName":"main::","name":"score","children":[{"line":328,"kind":13,"localvar":"my","containerName":"score","name":"$self","definition":"my"},{"line":328,"name":"$val","containerName":"score","kind":13},{"line":329,"name":"$val","kind":13,"containerName":"score"},{"line":330,"kind":13,"containerName":"score","name":"$self"},{"kind":13,"containerName":"score","name":"$val","line":330},{"name":"$self","kind":13,"containerName":"score","line":332}],"signature":{"parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"1;\n# $Id: Tree.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::Tree - An Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Nodes which make up a tree.\n\n=head1 IMPLEMENTATION NOTE\n\nThis implementation of Bio::Tree::Tree contains Bio::Tree:::NodeI; mainly linked\nvia the root node. As NodeI can potentially contain circular references (as\nnodes will need to refer to both parent and child nodes), Bio::Tree::Tree will\nremove those circular references when the object is garbage-collected. This has\nsome side effects; primarily, one must keep the Tree in scope or have at least\none reference to it if working with nodes. The fix is to count the references to\nthe nodes and if it is greater than expected retain all of them, but it requires\nan additional prereq and thus may not be worth the effort.  This only shows up\nin minor edge cases, though (see Bug #2869).\n\nExample of issue:\n\n  # tree is not assigned to a variable, so passes from memory after\n  # root node is passed\n  my $root = Bio::TreeIO->new(-format => 'newick', -file => 'foo.txt')->next_tree\n\t\t ->get_root_node;\n  \n  # gets nothing, as all Node links are broken when Tree is garbage-collected above\n  my @descendents = $root->get_all_Descendents;\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\nSendu Bala   bix@sendu.me.uk\nMark A. Jensen maj@fortinbras.us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::Tree->new();\n Function: Builds a new Bio::Tree::Tree object \n Returns : Bio::Tree::Tree\n Args    : -root     => L<Bio::Tree::NodeI> object which is the root\n             OR\n           -node     => L<Bio::Tree::NodeI> object from which the root will be\n                        determined\n\n           -nodelete => boolean, whether or not to try and cleanup all\n                                 the nodes when this this tree goes out\n                                 of scope.\n           -id       => optional tree ID\n           -score    => optional tree score value\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n  $self->{'_rootnode'} = undef;\n  $self->{'_maxbranchlen'} = 0;\n  $self->_register_for_cleanup(\\&cleanup_tree);\n  my ($root,$node,$nodel,$id,$score)= $self->_rearrange([qw(ROOT NODE NODELETE \n                              ID SCORE)], @args);\n  \n  if ($node && ! $root) {\n    $self->throw(\"Must supply a Bio::Tree::NodeI\") unless ref($node) && $node->isa('Bio::Tree::NodeI');\n    my @lineage = $self->get_lineage_nodes($node);\n    $root = shift(@lineage) || $node;\n    \n    # to stop us pulling in entire database of a Bio::Taxon when we later do\n    # get_nodes() or similar, specifically set ancestor() for each node\n    if ($node->isa('Bio::Taxon')) {\n      push(@lineage, $node) unless $node eq $root;\n      my $ancestor = $root;\n      foreach my $lineage_node (@lineage) {\n        $lineage_node->ancestor($ancestor);\n      } continue { $ancestor = $lineage_node; }\n    }\n  }\n  if ($root) {\n    $self->set_root_node($root);\n  }\n  \n  $self->nodelete($nodel || 0);\n  $self->id($id)       if defined $id;\n  $self->score($score) if defined $score;\n  return $self;\n}\n\n\n=head2 nodelete\n\n Title   : nodelete\n Usage   : $obj->nodelete($newval)\n Function: Get/Set Boolean whether or not to delete the underlying\n           nodes when it goes out of scope.  By default this is false\n           meaning trees are cleaned up.\n Returns : boolean\n Args    : on set, new boolean value\n\n\nsub nodelete{\n    my $self = shift;\n    return $self->{'nodelete'} = shift if @_;\n    return $self->{'nodelete'};\n}\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Bio::Tree::NodeI objects\n Returns : array of Bio::Tree::NodeI objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self, @args) = @_;\n   \n   my ($order, $sortby) = $self->_rearrange([qw(ORDER SORTBY)],@args);\n   $order ||= 'depth';\n   $sortby ||= 'none';\n   my $node = $self->get_root_node || return;\n   if ($order =~ m/^b|(breadth)$/oi) {\n       my @children = ($node);\n       for (@children) {\n        push @children, $_->each_Descendent($sortby);\n       }\n       return @children;\n   }\n\n   if ($order =~ m/^d|(depth)$/oi) {\n       # this is depth-first search I believe\n       my @children = ($node,$node->get_all_Descendents($sortby));\n       return @children;\n   }\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Tree::NodeI object\n Args    : none\n\n\n\nsub get_root_node{\n   my ($self) = @_;\n   return $self->{'_rootnode'};\n}\n\n=head2 set_root_node\n\n Title   : set_root_node\n Usage   : $tree->set_root_node($node)\n Function: Set the Root Node for the Tree\n Returns : Bio::Tree::NodeI\n Args    : Bio::Tree::NodeI\n\n\nsub set_root_node{\n   my $self = shift;\n   if( @_ ) { \n       my $value = shift;\n       if( defined $value && \n       ! $value->isa('Bio::Tree::NodeI') ) { \n       $self->warn(\"Trying to set the root node to $value which is not a Bio::Tree::NodeI\");\n       return $self->get_root_node;\n       }\n       $self->{'_rootnode'} = $value;\n   } \n   return $self->get_root_node;\n}\n\n=head2 total_branch_length\n\n Title   : total_branch_length\n Usage   : my $size = $tree->total_branch_length\n Function: Returns the sum of the length of all branches\n Returns : real\n Args    : none\n\n\nsub total_branch_length { shift->subtree_length }\n\n=head2 subtree_length\n\n Title   : subtree_length\n Usage   : my $subtree_size = $tree->subtree_length($internal_node)\n Function: Returns the sum of the length of all branches in a subtree\n           under the node. Calculates the size of the whole tree\n           without an argument (but only if root node is defined)\n Returns : real or undef\n Args    : Bio::Tree::NodeI object, defaults to the root node\n\n\nsub subtree_length {\n    my $tree = shift;\n    my $node = shift || $tree->get_root_node;\n    return unless $node;\n    my $sum = 0;\n    for ( $node->get_all_Descendents ) {\n    $sum += $_->branch_length || 0;\n    }\n    return $sum;\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : my $id = $tree->id();\n Function: An id value for the tree\n Returns : scalar\n Args    : [optional] new value to set\n\n\n\nsub id{\n   my ($self,$val) = @_;\n   if( defined $val ) { \n       $self->{'_treeid'} = $val;\n   }\n   return $self->{'_treeid'};\n}\n\n=head2 score\n\n Title   : score\n Usage   : $obj->score($newval)\n Function: Sets the associated score with this tree\n           This is a generic slot which is probably best used \n           for log likelihood or other overall tree score\n Returns : value of score\n Args    : newvalue (optional)","label":"score($self,$val)"},"kind":12,"range":{"start":{"character":0,"line":327},"end":{"character":9999,"line":333}},"line":327},{"line":375,"range":{"end":{"character":9999,"line":413},"start":{"line":375,"character":0}},"kind":12,"children":[{"definition":"my","localvar":"my","kind":13,"containerName":"as_text","name":"$self","line":376},{"definition":"my","kind":13,"localvar":"my","containerName":"as_text","name":"$format","line":377},{"localvar":"my","containerName":"as_text","kind":13,"name":"@parms","line":378,"definition":"my"},{"line":379,"containerName":"as_text","localvar":"my","kind":13,"name":"$iomod","definition":"my"},{"line":380,"kind":13,"containerName":"as_text","name":"$self"},{"name":"_load_module","containerName":"as_text","kind":12,"line":380},{"line":380,"containerName":"as_text","kind":13,"name":"$iomod"},{"line":382,"localvar":"my","containerName":"as_text","kind":13,"name":"$io","definition":"my"},{"kind":13,"containerName":"as_text","name":"$iomod","line":382},{"name":"new","kind":12,"containerName":"as_text","line":382},{"name":"$format","kind":13,"containerName":"as_text","line":382},{"line":382,"name":"devnull","kind":12,"containerName":"as_text"},{"name":"$iowtH","kind":13,"localvar":"my","containerName":"as_text","line":384,"definition":"my"},{"line":384,"containerName":"as_text","kind":13,"name":"$iomod"},{"line":386,"name":"$format","containerName":"as_text","kind":13},{"name":"@parms","containerName":"as_text","kind":13,"line":388},{"kind":13,"containerName":"as_text","name":"$io","line":388},{"line":388,"containerName":"as_text","kind":12,"name":"bootstrap_style"},{"line":388,"name":"$io","kind":13,"containerName":"as_text"},{"line":388,"name":"order_by","containerName":"as_text","kind":12},{"containerName":"as_text","kind":13,"name":"@parms","line":392},{"line":396,"name":"@parms","containerName":"as_text","kind":13},{"name":"$self","kind":13,"containerName":"as_text","line":400},{"containerName":"as_text","kind":12,"name":"throw","line":400},{"definition":"my","line":405,"name":"$data","localvar":"my","containerName":"as_text","kind":13},{"line":405,"name":"$iowtH","containerName":"as_text","kind":13},{"name":"$self","kind":13,"containerName":"as_text","line":405},{"line":405,"kind":12,"containerName":"as_text","name":"get_root_node"},{"name":"@parms","containerName":"as_text","kind":13,"line":405},{"line":407,"name":"$format","kind":13,"containerName":"as_text"},{"line":411,"kind":13,"containerName":"as_text","name":"$data"}],"containerName":"main::","name":"as_text","definition":"sub"},{"kind":12,"containerName":"Spec","name":"File","line":382},{"line":383,"kind":12,"name":"strict"},{"name":"CODE","kind":12,"line":384},{"line":386,"name":"strict","containerName":"","kind":2},{"line":408,"name":"data","kind":12},{"definition":"sub","detail":"($self,$tag,@values)","children":[{"localvar":"my","containerName":"set_tag_value","kind":13,"name":"$self","line":432,"definition":"my"},{"containerName":"set_tag_value","kind":13,"name":"$tag","line":432},{"containerName":"set_tag_value","kind":13,"name":"@values","line":432},{"containerName":"set_tag_value","kind":13,"name":"$tag","line":433},{"containerName":"set_tag_value","kind":13,"name":"@values","line":433},{"name":"$self","containerName":"set_tag_value","kind":13,"line":434},{"line":434,"containerName":"set_tag_value","kind":12,"name":"warn"},{"line":436,"name":"$self","containerName":"set_tag_value","kind":13},{"line":436,"name":"remove_tag","kind":12,"containerName":"set_tag_value"},{"kind":13,"containerName":"set_tag_value","name":"$tag","line":436},{"name":"$self","kind":13,"containerName":"set_tag_value","line":437},{"line":437,"name":"$tag","kind":13,"containerName":"set_tag_value"}],"containerName":"main::","name":"set_tag_value","signature":{"documentation":"1;\n# $Id: Tree.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::Tree - An Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Nodes which make up a tree.\n\n=head1 IMPLEMENTATION NOTE\n\nThis implementation of Bio::Tree::Tree contains Bio::Tree:::NodeI; mainly linked\nvia the root node. As NodeI can potentially contain circular references (as\nnodes will need to refer to both parent and child nodes), Bio::Tree::Tree will\nremove those circular references when the object is garbage-collected. This has\nsome side effects; primarily, one must keep the Tree in scope or have at least\none reference to it if working with nodes. The fix is to count the references to\nthe nodes and if it is greater than expected retain all of them, but it requires\nan additional prereq and thus may not be worth the effort.  This only shows up\nin minor edge cases, though (see Bug #2869).\n\nExample of issue:\n\n  # tree is not assigned to a variable, so passes from memory after\n  # root node is passed\n  my $root = Bio::TreeIO->new(-format => 'newick', -file => 'foo.txt')->next_tree\n\t\t ->get_root_node;\n  \n  # gets nothing, as all Node links are broken when Tree is garbage-collected above\n  my @descendents = $root->get_all_Descendents;\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\nSendu Bala   bix@sendu.me.uk\nMark A. Jensen maj@fortinbras.us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::Tree->new();\n Function: Builds a new Bio::Tree::Tree object \n Returns : Bio::Tree::Tree\n Args    : -root     => L<Bio::Tree::NodeI> object which is the root\n             OR\n           -node     => L<Bio::Tree::NodeI> object from which the root will be\n                        determined\n\n           -nodelete => boolean, whether or not to try and cleanup all\n                                 the nodes when this this tree goes out\n                                 of scope.\n           -id       => optional tree ID\n           -score    => optional tree score value\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n  $self->{'_rootnode'} = undef;\n  $self->{'_maxbranchlen'} = 0;\n  $self->_register_for_cleanup(\\&cleanup_tree);\n  my ($root,$node,$nodel,$id,$score)= $self->_rearrange([qw(ROOT NODE NODELETE \n                              ID SCORE)], @args);\n  \n  if ($node && ! $root) {\n    $self->throw(\"Must supply a Bio::Tree::NodeI\") unless ref($node) && $node->isa('Bio::Tree::NodeI');\n    my @lineage = $self->get_lineage_nodes($node);\n    $root = shift(@lineage) || $node;\n    \n    # to stop us pulling in entire database of a Bio::Taxon when we later do\n    # get_nodes() or similar, specifically set ancestor() for each node\n    if ($node->isa('Bio::Taxon')) {\n      push(@lineage, $node) unless $node eq $root;\n      my $ancestor = $root;\n      foreach my $lineage_node (@lineage) {\n        $lineage_node->ancestor($ancestor);\n      } continue { $ancestor = $lineage_node; }\n    }\n  }\n  if ($root) {\n    $self->set_root_node($root);\n  }\n  \n  $self->nodelete($nodel || 0);\n  $self->id($id)       if defined $id;\n  $self->score($score) if defined $score;\n  return $self;\n}\n\n\n=head2 nodelete\n\n Title   : nodelete\n Usage   : $obj->nodelete($newval)\n Function: Get/Set Boolean whether or not to delete the underlying\n           nodes when it goes out of scope.  By default this is false\n           meaning trees are cleaned up.\n Returns : boolean\n Args    : on set, new boolean value\n\n\nsub nodelete{\n    my $self = shift;\n    return $self->{'nodelete'} = shift if @_;\n    return $self->{'nodelete'};\n}\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Bio::Tree::NodeI objects\n Returns : array of Bio::Tree::NodeI objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self, @args) = @_;\n   \n   my ($order, $sortby) = $self->_rearrange([qw(ORDER SORTBY)],@args);\n   $order ||= 'depth';\n   $sortby ||= 'none';\n   my $node = $self->get_root_node || return;\n   if ($order =~ m/^b|(breadth)$/oi) {\n       my @children = ($node);\n       for (@children) {\n        push @children, $_->each_Descendent($sortby);\n       }\n       return @children;\n   }\n\n   if ($order =~ m/^d|(depth)$/oi) {\n       # this is depth-first search I believe\n       my @children = ($node,$node->get_all_Descendents($sortby));\n       return @children;\n   }\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Tree::NodeI object\n Args    : none\n\n\n\nsub get_root_node{\n   my ($self) = @_;\n   return $self->{'_rootnode'};\n}\n\n=head2 set_root_node\n\n Title   : set_root_node\n Usage   : $tree->set_root_node($node)\n Function: Set the Root Node for the Tree\n Returns : Bio::Tree::NodeI\n Args    : Bio::Tree::NodeI\n\n\nsub set_root_node{\n   my $self = shift;\n   if( @_ ) { \n       my $value = shift;\n       if( defined $value && \n       ! $value->isa('Bio::Tree::NodeI') ) { \n       $self->warn(\"Trying to set the root node to $value which is not a Bio::Tree::NodeI\");\n       return $self->get_root_node;\n       }\n       $self->{'_rootnode'} = $value;\n   } \n   return $self->get_root_node;\n}\n\n=head2 total_branch_length\n\n Title   : total_branch_length\n Usage   : my $size = $tree->total_branch_length\n Function: Returns the sum of the length of all branches\n Returns : real\n Args    : none\n\n\nsub total_branch_length { shift->subtree_length }\n\n=head2 subtree_length\n\n Title   : subtree_length\n Usage   : my $subtree_size = $tree->subtree_length($internal_node)\n Function: Returns the sum of the length of all branches in a subtree\n           under the node. Calculates the size of the whole tree\n           without an argument (but only if root node is defined)\n Returns : real or undef\n Args    : Bio::Tree::NodeI object, defaults to the root node\n\n\nsub subtree_length {\n    my $tree = shift;\n    my $node = shift || $tree->get_root_node;\n    return unless $node;\n    my $sum = 0;\n    for ( $node->get_all_Descendents ) {\n    $sum += $_->branch_length || 0;\n    }\n    return $sum;\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : my $id = $tree->id();\n Function: An id value for the tree\n Returns : scalar\n Args    : [optional] new value to set\n\n\n\nsub id{\n   my ($self,$val) = @_;\n   if( defined $val ) { \n       $self->{'_treeid'} = $val;\n   }\n   return $self->{'_treeid'};\n}\n\n=head2 score\n\n Title   : score\n Usage   : $obj->score($newval)\n Function: Sets the associated score with this tree\n           This is a generic slot which is probably best used \n           for log likelihood or other overall tree score\n Returns : value of score\n Args    : newvalue (optional)\n\n\n\nsub score{\n   my ($self,$val) = @_;\n   if( defined $val ) { \n       $self->{'_score'} = $val;\n   }\n   return $self->{'_score'};\n}\n\n\n# decorated interface TreeI Implements this\n\n=head2 height\n\n Title   : height\n Usage   : my $height = $tree->height\n Function: Gets the height of tree - this LOG_2($number_nodes)\n           WARNING: this is only true for strict binary trees.  The TreeIO\n           system is capable of building non-binary trees, for which this\n           method will currently return an incorrect value!!\n Returns : integer\n Args    : none\n\n=head2 number_nodes\n\n Title   : number_nodes\n Usage   : my $size = $tree->number_nodes\n Function: Returns the number of nodes in the tree\n Returns : integer\n Args    : none\n\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   : my $tree_as_string = $tree->as_text($format)\n Function: Returns the tree as a string representation in the \n           desired format (currently 'newick', 'nhx', or \n           'tabtree')\n Returns : scalar string\n Args    : format type as specified by Bio::TreeIO\n Note    : This method loads the Bio::TreeIO::$format module\n           on the fly, and commandeers the _write_tree_Helper\n           routine therein to create the tree string. \n\n\nsub as_text {\n    my $self = shift;\n    my $format = shift;\n    my @parms;\n    my $iomod = \"Bio::TreeIO::$format\";\n    $self->_load_module($iomod);\n    # following currently not really necessary, but who knows?\n    my $io = $iomod->new(-format=>$format, -file=>File::Spec->devnull());\n    no strict \"refs\";\n    my $iowtH = *{$iomod.\"::_write_tree_Helper\"}{CODE};\n    use strict \"refs\";\n    for ($format) {\n\t/newick/ && do {\n\t    @parms = ( $io->bootstrap_style, $io->order_by, 0 );\n\t    last;\n\t};\n\t/nhx/ && do {\n\t    @parms = ( 0 );\n\t    last;\n\t};\n\t/tabtree/ && do {\n\t    @parms = ( \"\" );\n\t    last;\n\t};\n\t# default\n\t$self->throw(\"as_text does not allow format '$format'\") \n    }\n\t\n\n    # newline_each_node...\n    my $data = [$iowtH->($self->get_root_node, @parms)];\n\n    if ($format eq 'tabtree') {\n\treturn $$data[0].\"\\n\";\n    }\n    else {\n\treturn join(\",\", @$data).\";\\n\";\n    }\n}\n\n=head2 Methods for associating Tag/Values with a Tree\n\nThese methods associate tag/value pairs with a Tree\n\n=head2 set_tag_value\n\n Title   : set_tag_value\n Usage   : $tree->set_tag_value($tag,$value)\n           $tree->set_tag_value($tag,@values)\n Function: Sets a tag value(s) to a tree. Replaces old values.\n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag","parameters":[{"label":"$self"},{"label":"$tag"},{"label":"@values"}],"label":"set_tag_value($self,$tag,@values)"},"line":431,"kind":12,"range":{"start":{"character":0,"line":431},"end":{"line":437,"character":9999}}},{"kind":13,"containerName":null,"name":"@values","line":437},{"name":"%self","kind":13,"containerName":null,"line":438},{"line":438,"name":"$tag","kind":13,"containerName":null},{"containerName":"main::","name":"add_tag_value","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"add_tag_value","name":"$self","line":453},{"containerName":"add_tag_value","kind":13,"name":"$tag","line":453},{"line":453,"containerName":"add_tag_value","kind":13,"name":"$value"},{"line":454,"name":"$tag","kind":13,"containerName":"add_tag_value"},{"name":"$value","containerName":"add_tag_value","kind":13,"line":454},{"name":"$self","containerName":"add_tag_value","kind":13,"line":455},{"containerName":"add_tag_value","kind":12,"name":"warn","line":455},{"name":"$self","containerName":"add_tag_value","kind":13,"line":457},{"line":457,"name":"$tag","containerName":"add_tag_value","kind":13}],"detail":"($self,$tag,$value)","definition":"sub","range":{"start":{"line":452,"character":0},"end":{"line":457,"character":9999}},"kind":12,"line":452,"signature":{"documentation":"1;\n# $Id: Tree.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::Tree - An Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Nodes which make up a tree.\n\n=head1 IMPLEMENTATION NOTE\n\nThis implementation of Bio::Tree::Tree contains Bio::Tree:::NodeI; mainly linked\nvia the root node. As NodeI can potentially contain circular references (as\nnodes will need to refer to both parent and child nodes), Bio::Tree::Tree will\nremove those circular references when the object is garbage-collected. This has\nsome side effects; primarily, one must keep the Tree in scope or have at least\none reference to it if working with nodes. The fix is to count the references to\nthe nodes and if it is greater than expected retain all of them, but it requires\nan additional prereq and thus may not be worth the effort.  This only shows up\nin minor edge cases, though (see Bug #2869).\n\nExample of issue:\n\n  # tree is not assigned to a variable, so passes from memory after\n  # root node is passed\n  my $root = Bio::TreeIO->new(-format => 'newick', -file => 'foo.txt')->next_tree\n\t\t ->get_root_node;\n  \n  # gets nothing, as all Node links are broken when Tree is garbage-collected above\n  my @descendents = $root->get_all_Descendents;\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\nSendu Bala   bix@sendu.me.uk\nMark A. Jensen maj@fortinbras.us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::Tree->new();\n Function: Builds a new Bio::Tree::Tree object \n Returns : Bio::Tree::Tree\n Args    : -root     => L<Bio::Tree::NodeI> object which is the root\n             OR\n           -node     => L<Bio::Tree::NodeI> object from which the root will be\n                        determined\n\n           -nodelete => boolean, whether or not to try and cleanup all\n                                 the nodes when this this tree goes out\n                                 of scope.\n           -id       => optional tree ID\n           -score    => optional tree score value\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n  $self->{'_rootnode'} = undef;\n  $self->{'_maxbranchlen'} = 0;\n  $self->_register_for_cleanup(\\&cleanup_tree);\n  my ($root,$node,$nodel,$id,$score)= $self->_rearrange([qw(ROOT NODE NODELETE \n                              ID SCORE)], @args);\n  \n  if ($node && ! $root) {\n    $self->throw(\"Must supply a Bio::Tree::NodeI\") unless ref($node) && $node->isa('Bio::Tree::NodeI');\n    my @lineage = $self->get_lineage_nodes($node);\n    $root = shift(@lineage) || $node;\n    \n    # to stop us pulling in entire database of a Bio::Taxon when we later do\n    # get_nodes() or similar, specifically set ancestor() for each node\n    if ($node->isa('Bio::Taxon')) {\n      push(@lineage, $node) unless $node eq $root;\n      my $ancestor = $root;\n      foreach my $lineage_node (@lineage) {\n        $lineage_node->ancestor($ancestor);\n      } continue { $ancestor = $lineage_node; }\n    }\n  }\n  if ($root) {\n    $self->set_root_node($root);\n  }\n  \n  $self->nodelete($nodel || 0);\n  $self->id($id)       if defined $id;\n  $self->score($score) if defined $score;\n  return $self;\n}\n\n\n=head2 nodelete\n\n Title   : nodelete\n Usage   : $obj->nodelete($newval)\n Function: Get/Set Boolean whether or not to delete the underlying\n           nodes when it goes out of scope.  By default this is false\n           meaning trees are cleaned up.\n Returns : boolean\n Args    : on set, new boolean value\n\n\nsub nodelete{\n    my $self = shift;\n    return $self->{'nodelete'} = shift if @_;\n    return $self->{'nodelete'};\n}\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Bio::Tree::NodeI objects\n Returns : array of Bio::Tree::NodeI objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self, @args) = @_;\n   \n   my ($order, $sortby) = $self->_rearrange([qw(ORDER SORTBY)],@args);\n   $order ||= 'depth';\n   $sortby ||= 'none';\n   my $node = $self->get_root_node || return;\n   if ($order =~ m/^b|(breadth)$/oi) {\n       my @children = ($node);\n       for (@children) {\n        push @children, $_->each_Descendent($sortby);\n       }\n       return @children;\n   }\n\n   if ($order =~ m/^d|(depth)$/oi) {\n       # this is depth-first search I believe\n       my @children = ($node,$node->get_all_Descendents($sortby));\n       return @children;\n   }\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Tree::NodeI object\n Args    : none\n\n\n\nsub get_root_node{\n   my ($self) = @_;\n   return $self->{'_rootnode'};\n}\n\n=head2 set_root_node\n\n Title   : set_root_node\n Usage   : $tree->set_root_node($node)\n Function: Set the Root Node for the Tree\n Returns : Bio::Tree::NodeI\n Args    : Bio::Tree::NodeI\n\n\nsub set_root_node{\n   my $self = shift;\n   if( @_ ) { \n       my $value = shift;\n       if( defined $value && \n       ! $value->isa('Bio::Tree::NodeI') ) { \n       $self->warn(\"Trying to set the root node to $value which is not a Bio::Tree::NodeI\");\n       return $self->get_root_node;\n       }\n       $self->{'_rootnode'} = $value;\n   } \n   return $self->get_root_node;\n}\n\n=head2 total_branch_length\n\n Title   : total_branch_length\n Usage   : my $size = $tree->total_branch_length\n Function: Returns the sum of the length of all branches\n Returns : real\n Args    : none\n\n\nsub total_branch_length { shift->subtree_length }\n\n=head2 subtree_length\n\n Title   : subtree_length\n Usage   : my $subtree_size = $tree->subtree_length($internal_node)\n Function: Returns the sum of the length of all branches in a subtree\n           under the node. Calculates the size of the whole tree\n           without an argument (but only if root node is defined)\n Returns : real or undef\n Args    : Bio::Tree::NodeI object, defaults to the root node\n\n\nsub subtree_length {\n    my $tree = shift;\n    my $node = shift || $tree->get_root_node;\n    return unless $node;\n    my $sum = 0;\n    for ( $node->get_all_Descendents ) {\n    $sum += $_->branch_length || 0;\n    }\n    return $sum;\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : my $id = $tree->id();\n Function: An id value for the tree\n Returns : scalar\n Args    : [optional] new value to set\n\n\n\nsub id{\n   my ($self,$val) = @_;\n   if( defined $val ) { \n       $self->{'_treeid'} = $val;\n   }\n   return $self->{'_treeid'};\n}\n\n=head2 score\n\n Title   : score\n Usage   : $obj->score($newval)\n Function: Sets the associated score with this tree\n           This is a generic slot which is probably best used \n           for log likelihood or other overall tree score\n Returns : value of score\n Args    : newvalue (optional)\n\n\n\nsub score{\n   my ($self,$val) = @_;\n   if( defined $val ) { \n       $self->{'_score'} = $val;\n   }\n   return $self->{'_score'};\n}\n\n\n# decorated interface TreeI Implements this\n\n=head2 height\n\n Title   : height\n Usage   : my $height = $tree->height\n Function: Gets the height of tree - this LOG_2($number_nodes)\n           WARNING: this is only true for strict binary trees.  The TreeIO\n           system is capable of building non-binary trees, for which this\n           method will currently return an incorrect value!!\n Returns : integer\n Args    : none\n\n=head2 number_nodes\n\n Title   : number_nodes\n Usage   : my $size = $tree->number_nodes\n Function: Returns the number of nodes in the tree\n Returns : integer\n Args    : none\n\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   : my $tree_as_string = $tree->as_text($format)\n Function: Returns the tree as a string representation in the \n           desired format (currently 'newick', 'nhx', or \n           'tabtree')\n Returns : scalar string\n Args    : format type as specified by Bio::TreeIO\n Note    : This method loads the Bio::TreeIO::$format module\n           on the fly, and commandeers the _write_tree_Helper\n           routine therein to create the tree string. \n\n\nsub as_text {\n    my $self = shift;\n    my $format = shift;\n    my @parms;\n    my $iomod = \"Bio::TreeIO::$format\";\n    $self->_load_module($iomod);\n    # following currently not really necessary, but who knows?\n    my $io = $iomod->new(-format=>$format, -file=>File::Spec->devnull());\n    no strict \"refs\";\n    my $iowtH = *{$iomod.\"::_write_tree_Helper\"}{CODE};\n    use strict \"refs\";\n    for ($format) {\n\t/newick/ && do {\n\t    @parms = ( $io->bootstrap_style, $io->order_by, 0 );\n\t    last;\n\t};\n\t/nhx/ && do {\n\t    @parms = ( 0 );\n\t    last;\n\t};\n\t/tabtree/ && do {\n\t    @parms = ( \"\" );\n\t    last;\n\t};\n\t# default\n\t$self->throw(\"as_text does not allow format '$format'\") \n    }\n\t\n\n    # newline_each_node...\n    my $data = [$iowtH->($self->get_root_node, @parms)];\n\n    if ($format eq 'tabtree') {\n\treturn $$data[0].\"\\n\";\n    }\n    else {\n\treturn join(\",\", @$data).\";\\n\";\n    }\n}\n\n=head2 Methods for associating Tag/Values with a Tree\n\nThese methods associate tag/value pairs with a Tree\n\n=head2 set_tag_value\n\n Title   : set_tag_value\n Usage   : $tree->set_tag_value($tag,$value)\n           $tree->set_tag_value($tag,@values)\n Function: Sets a tag value(s) to a tree. Replaces old values.\n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag\n\n\nsub set_tag_value{\n    my ($self,$tag,@values) = @_;\n    if( ! defined $tag || ! scalar @values ) {\n    $self->warn(\"cannot call set_tag_value with an undefined value\");\n    }\n    $self->remove_tag ($tag);\n    map { push @{$self->{'_tags'}->{$tag}}, $_ } @values;\n    return scalar @{$self->{'_tags'}->{$tag}};\n}\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $tree->add_tag_value($tag,$value)\n Function: Adds a tag value to a tree \n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag","parameters":[{"label":"$self"},{"label":"$tag"},{"label":"$value"}],"label":"add_tag_value($self,$tag,$value)"}},{"name":"$value","containerName":null,"kind":13,"line":457},{"containerName":null,"kind":13,"name":"%self","line":458},{"containerName":null,"kind":13,"name":"$tag","line":458},{"detail":"($self,$tag)","definition":"sub","containerName":"main::","name":"remove_tag","children":[{"definition":"my","name":"$self","containerName":"remove_tag","localvar":"my","kind":13,"line":473},{"name":"$tag","containerName":"remove_tag","kind":13,"line":473},{"line":474,"name":"$self","kind":13,"containerName":"remove_tag"},{"name":"$tag","kind":13,"containerName":"remove_tag","line":474},{"line":475,"name":"$self","containerName":"remove_tag","kind":13},{"line":475,"kind":13,"containerName":"remove_tag","name":"$tag"},{"line":476,"containerName":"remove_tag","kind":13,"name":"$self"},{"kind":13,"containerName":"remove_tag","name":"$tag","line":476}],"signature":{"documentation":"1;\n# $Id: Tree.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::Tree - An Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Nodes which make up a tree.\n\n=head1 IMPLEMENTATION NOTE\n\nThis implementation of Bio::Tree::Tree contains Bio::Tree:::NodeI; mainly linked\nvia the root node. As NodeI can potentially contain circular references (as\nnodes will need to refer to both parent and child nodes), Bio::Tree::Tree will\nremove those circular references when the object is garbage-collected. This has\nsome side effects; primarily, one must keep the Tree in scope or have at least\none reference to it if working with nodes. The fix is to count the references to\nthe nodes and if it is greater than expected retain all of them, but it requires\nan additional prereq and thus may not be worth the effort.  This only shows up\nin minor edge cases, though (see Bug #2869).\n\nExample of issue:\n\n  # tree is not assigned to a variable, so passes from memory after\n  # root node is passed\n  my $root = Bio::TreeIO->new(-format => 'newick', -file => 'foo.txt')->next_tree\n\t\t ->get_root_node;\n  \n  # gets nothing, as all Node links are broken when Tree is garbage-collected above\n  my @descendents = $root->get_all_Descendents;\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\nSendu Bala   bix@sendu.me.uk\nMark A. Jensen maj@fortinbras.us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::Tree->new();\n Function: Builds a new Bio::Tree::Tree object \n Returns : Bio::Tree::Tree\n Args    : -root     => L<Bio::Tree::NodeI> object which is the root\n             OR\n           -node     => L<Bio::Tree::NodeI> object from which the root will be\n                        determined\n\n           -nodelete => boolean, whether or not to try and cleanup all\n                                 the nodes when this this tree goes out\n                                 of scope.\n           -id       => optional tree ID\n           -score    => optional tree score value\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n  $self->{'_rootnode'} = undef;\n  $self->{'_maxbranchlen'} = 0;\n  $self->_register_for_cleanup(\\&cleanup_tree);\n  my ($root,$node,$nodel,$id,$score)= $self->_rearrange([qw(ROOT NODE NODELETE \n                              ID SCORE)], @args);\n  \n  if ($node && ! $root) {\n    $self->throw(\"Must supply a Bio::Tree::NodeI\") unless ref($node) && $node->isa('Bio::Tree::NodeI');\n    my @lineage = $self->get_lineage_nodes($node);\n    $root = shift(@lineage) || $node;\n    \n    # to stop us pulling in entire database of a Bio::Taxon when we later do\n    # get_nodes() or similar, specifically set ancestor() for each node\n    if ($node->isa('Bio::Taxon')) {\n      push(@lineage, $node) unless $node eq $root;\n      my $ancestor = $root;\n      foreach my $lineage_node (@lineage) {\n        $lineage_node->ancestor($ancestor);\n      } continue { $ancestor = $lineage_node; }\n    }\n  }\n  if ($root) {\n    $self->set_root_node($root);\n  }\n  \n  $self->nodelete($nodel || 0);\n  $self->id($id)       if defined $id;\n  $self->score($score) if defined $score;\n  return $self;\n}\n\n\n=head2 nodelete\n\n Title   : nodelete\n Usage   : $obj->nodelete($newval)\n Function: Get/Set Boolean whether or not to delete the underlying\n           nodes when it goes out of scope.  By default this is false\n           meaning trees are cleaned up.\n Returns : boolean\n Args    : on set, new boolean value\n\n\nsub nodelete{\n    my $self = shift;\n    return $self->{'nodelete'} = shift if @_;\n    return $self->{'nodelete'};\n}\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Bio::Tree::NodeI objects\n Returns : array of Bio::Tree::NodeI objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self, @args) = @_;\n   \n   my ($order, $sortby) = $self->_rearrange([qw(ORDER SORTBY)],@args);\n   $order ||= 'depth';\n   $sortby ||= 'none';\n   my $node = $self->get_root_node || return;\n   if ($order =~ m/^b|(breadth)$/oi) {\n       my @children = ($node);\n       for (@children) {\n        push @children, $_->each_Descendent($sortby);\n       }\n       return @children;\n   }\n\n   if ($order =~ m/^d|(depth)$/oi) {\n       # this is depth-first search I believe\n       my @children = ($node,$node->get_all_Descendents($sortby));\n       return @children;\n   }\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Tree::NodeI object\n Args    : none\n\n\n\nsub get_root_node{\n   my ($self) = @_;\n   return $self->{'_rootnode'};\n}\n\n=head2 set_root_node\n\n Title   : set_root_node\n Usage   : $tree->set_root_node($node)\n Function: Set the Root Node for the Tree\n Returns : Bio::Tree::NodeI\n Args    : Bio::Tree::NodeI\n\n\nsub set_root_node{\n   my $self = shift;\n   if( @_ ) { \n       my $value = shift;\n       if( defined $value && \n       ! $value->isa('Bio::Tree::NodeI') ) { \n       $self->warn(\"Trying to set the root node to $value which is not a Bio::Tree::NodeI\");\n       return $self->get_root_node;\n       }\n       $self->{'_rootnode'} = $value;\n   } \n   return $self->get_root_node;\n}\n\n=head2 total_branch_length\n\n Title   : total_branch_length\n Usage   : my $size = $tree->total_branch_length\n Function: Returns the sum of the length of all branches\n Returns : real\n Args    : none\n\n\nsub total_branch_length { shift->subtree_length }\n\n=head2 subtree_length\n\n Title   : subtree_length\n Usage   : my $subtree_size = $tree->subtree_length($internal_node)\n Function: Returns the sum of the length of all branches in a subtree\n           under the node. Calculates the size of the whole tree\n           without an argument (but only if root node is defined)\n Returns : real or undef\n Args    : Bio::Tree::NodeI object, defaults to the root node\n\n\nsub subtree_length {\n    my $tree = shift;\n    my $node = shift || $tree->get_root_node;\n    return unless $node;\n    my $sum = 0;\n    for ( $node->get_all_Descendents ) {\n    $sum += $_->branch_length || 0;\n    }\n    return $sum;\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : my $id = $tree->id();\n Function: An id value for the tree\n Returns : scalar\n Args    : [optional] new value to set\n\n\n\nsub id{\n   my ($self,$val) = @_;\n   if( defined $val ) { \n       $self->{'_treeid'} = $val;\n   }\n   return $self->{'_treeid'};\n}\n\n=head2 score\n\n Title   : score\n Usage   : $obj->score($newval)\n Function: Sets the associated score with this tree\n           This is a generic slot which is probably best used \n           for log likelihood or other overall tree score\n Returns : value of score\n Args    : newvalue (optional)\n\n\n\nsub score{\n   my ($self,$val) = @_;\n   if( defined $val ) { \n       $self->{'_score'} = $val;\n   }\n   return $self->{'_score'};\n}\n\n\n# decorated interface TreeI Implements this\n\n=head2 height\n\n Title   : height\n Usage   : my $height = $tree->height\n Function: Gets the height of tree - this LOG_2($number_nodes)\n           WARNING: this is only true for strict binary trees.  The TreeIO\n           system is capable of building non-binary trees, for which this\n           method will currently return an incorrect value!!\n Returns : integer\n Args    : none\n\n=head2 number_nodes\n\n Title   : number_nodes\n Usage   : my $size = $tree->number_nodes\n Function: Returns the number of nodes in the tree\n Returns : integer\n Args    : none\n\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   : my $tree_as_string = $tree->as_text($format)\n Function: Returns the tree as a string representation in the \n           desired format (currently 'newick', 'nhx', or \n           'tabtree')\n Returns : scalar string\n Args    : format type as specified by Bio::TreeIO\n Note    : This method loads the Bio::TreeIO::$format module\n           on the fly, and commandeers the _write_tree_Helper\n           routine therein to create the tree string. \n\n\nsub as_text {\n    my $self = shift;\n    my $format = shift;\n    my @parms;\n    my $iomod = \"Bio::TreeIO::$format\";\n    $self->_load_module($iomod);\n    # following currently not really necessary, but who knows?\n    my $io = $iomod->new(-format=>$format, -file=>File::Spec->devnull());\n    no strict \"refs\";\n    my $iowtH = *{$iomod.\"::_write_tree_Helper\"}{CODE};\n    use strict \"refs\";\n    for ($format) {\n\t/newick/ && do {\n\t    @parms = ( $io->bootstrap_style, $io->order_by, 0 );\n\t    last;\n\t};\n\t/nhx/ && do {\n\t    @parms = ( 0 );\n\t    last;\n\t};\n\t/tabtree/ && do {\n\t    @parms = ( \"\" );\n\t    last;\n\t};\n\t# default\n\t$self->throw(\"as_text does not allow format '$format'\") \n    }\n\t\n\n    # newline_each_node...\n    my $data = [$iowtH->($self->get_root_node, @parms)];\n\n    if ($format eq 'tabtree') {\n\treturn $$data[0].\"\\n\";\n    }\n    else {\n\treturn join(\",\", @$data).\";\\n\";\n    }\n}\n\n=head2 Methods for associating Tag/Values with a Tree\n\nThese methods associate tag/value pairs with a Tree\n\n=head2 set_tag_value\n\n Title   : set_tag_value\n Usage   : $tree->set_tag_value($tag,$value)\n           $tree->set_tag_value($tag,@values)\n Function: Sets a tag value(s) to a tree. Replaces old values.\n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag\n\n\nsub set_tag_value{\n    my ($self,$tag,@values) = @_;\n    if( ! defined $tag || ! scalar @values ) {\n    $self->warn(\"cannot call set_tag_value with an undefined value\");\n    }\n    $self->remove_tag ($tag);\n    map { push @{$self->{'_tags'}->{$tag}}, $_ } @values;\n    return scalar @{$self->{'_tags'}->{$tag}};\n}\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $tree->add_tag_value($tag,$value)\n Function: Adds a tag value to a tree \n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag\n\n\nsub add_tag_value{\n    my ($self,$tag,$value) = @_;\n    if( ! defined $tag || ! defined $value ) {\n    $self->warn(\"cannot call add_tag_value with an undefined value\");\n    }\n    push @{$self->{'_tags'}->{$tag}}, $value;\n    return scalar @{$self->{'_tags'}->{$tag}};\n}\n\n=head2 remove_tag\n\n Title   : remove_tag\n Usage   : $tree->remove_tag($tag)\n Function: Remove the tag and all values for this tag\n Returns : boolean representing success (0 if tag does not exist)\n Args    : $tag - tagname to remove","parameters":[{"label":"$self"},{"label":"$tag"}],"label":"remove_tag($self,$tag)"},"range":{"start":{"line":472,"character":0},"end":{"line":480,"character":9999}},"kind":12,"line":472},{"range":{"start":{"line":492,"character":0},"end":{"character":9999,"line":496}},"kind":12,"line":492,"signature":{"label":"remove_all_tags($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Tree.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::Tree - An Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Nodes which make up a tree.\n\n=head1 IMPLEMENTATION NOTE\n\nThis implementation of Bio::Tree::Tree contains Bio::Tree:::NodeI; mainly linked\nvia the root node. As NodeI can potentially contain circular references (as\nnodes will need to refer to both parent and child nodes), Bio::Tree::Tree will\nremove those circular references when the object is garbage-collected. This has\nsome side effects; primarily, one must keep the Tree in scope or have at least\none reference to it if working with nodes. The fix is to count the references to\nthe nodes and if it is greater than expected retain all of them, but it requires\nan additional prereq and thus may not be worth the effort.  This only shows up\nin minor edge cases, though (see Bug #2869).\n\nExample of issue:\n\n  # tree is not assigned to a variable, so passes from memory after\n  # root node is passed\n  my $root = Bio::TreeIO->new(-format => 'newick', -file => 'foo.txt')->next_tree\n\t\t ->get_root_node;\n  \n  # gets nothing, as all Node links are broken when Tree is garbage-collected above\n  my @descendents = $root->get_all_Descendents;\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\nSendu Bala   bix@sendu.me.uk\nMark A. Jensen maj@fortinbras.us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::Tree->new();\n Function: Builds a new Bio::Tree::Tree object \n Returns : Bio::Tree::Tree\n Args    : -root     => L<Bio::Tree::NodeI> object which is the root\n             OR\n           -node     => L<Bio::Tree::NodeI> object from which the root will be\n                        determined\n\n           -nodelete => boolean, whether or not to try and cleanup all\n                                 the nodes when this this tree goes out\n                                 of scope.\n           -id       => optional tree ID\n           -score    => optional tree score value\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n  $self->{'_rootnode'} = undef;\n  $self->{'_maxbranchlen'} = 0;\n  $self->_register_for_cleanup(\\&cleanup_tree);\n  my ($root,$node,$nodel,$id,$score)= $self->_rearrange([qw(ROOT NODE NODELETE \n                              ID SCORE)], @args);\n  \n  if ($node && ! $root) {\n    $self->throw(\"Must supply a Bio::Tree::NodeI\") unless ref($node) && $node->isa('Bio::Tree::NodeI');\n    my @lineage = $self->get_lineage_nodes($node);\n    $root = shift(@lineage) || $node;\n    \n    # to stop us pulling in entire database of a Bio::Taxon when we later do\n    # get_nodes() or similar, specifically set ancestor() for each node\n    if ($node->isa('Bio::Taxon')) {\n      push(@lineage, $node) unless $node eq $root;\n      my $ancestor = $root;\n      foreach my $lineage_node (@lineage) {\n        $lineage_node->ancestor($ancestor);\n      } continue { $ancestor = $lineage_node; }\n    }\n  }\n  if ($root) {\n    $self->set_root_node($root);\n  }\n  \n  $self->nodelete($nodel || 0);\n  $self->id($id)       if defined $id;\n  $self->score($score) if defined $score;\n  return $self;\n}\n\n\n=head2 nodelete\n\n Title   : nodelete\n Usage   : $obj->nodelete($newval)\n Function: Get/Set Boolean whether or not to delete the underlying\n           nodes when it goes out of scope.  By default this is false\n           meaning trees are cleaned up.\n Returns : boolean\n Args    : on set, new boolean value\n\n\nsub nodelete{\n    my $self = shift;\n    return $self->{'nodelete'} = shift if @_;\n    return $self->{'nodelete'};\n}\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Bio::Tree::NodeI objects\n Returns : array of Bio::Tree::NodeI objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self, @args) = @_;\n   \n   my ($order, $sortby) = $self->_rearrange([qw(ORDER SORTBY)],@args);\n   $order ||= 'depth';\n   $sortby ||= 'none';\n   my $node = $self->get_root_node || return;\n   if ($order =~ m/^b|(breadth)$/oi) {\n       my @children = ($node);\n       for (@children) {\n        push @children, $_->each_Descendent($sortby);\n       }\n       return @children;\n   }\n\n   if ($order =~ m/^d|(depth)$/oi) {\n       # this is depth-first search I believe\n       my @children = ($node,$node->get_all_Descendents($sortby));\n       return @children;\n   }\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Tree::NodeI object\n Args    : none\n\n\n\nsub get_root_node{\n   my ($self) = @_;\n   return $self->{'_rootnode'};\n}\n\n=head2 set_root_node\n\n Title   : set_root_node\n Usage   : $tree->set_root_node($node)\n Function: Set the Root Node for the Tree\n Returns : Bio::Tree::NodeI\n Args    : Bio::Tree::NodeI\n\n\nsub set_root_node{\n   my $self = shift;\n   if( @_ ) { \n       my $value = shift;\n       if( defined $value && \n       ! $value->isa('Bio::Tree::NodeI') ) { \n       $self->warn(\"Trying to set the root node to $value which is not a Bio::Tree::NodeI\");\n       return $self->get_root_node;\n       }\n       $self->{'_rootnode'} = $value;\n   } \n   return $self->get_root_node;\n}\n\n=head2 total_branch_length\n\n Title   : total_branch_length\n Usage   : my $size = $tree->total_branch_length\n Function: Returns the sum of the length of all branches\n Returns : real\n Args    : none\n\n\nsub total_branch_length { shift->subtree_length }\n\n=head2 subtree_length\n\n Title   : subtree_length\n Usage   : my $subtree_size = $tree->subtree_length($internal_node)\n Function: Returns the sum of the length of all branches in a subtree\n           under the node. Calculates the size of the whole tree\n           without an argument (but only if root node is defined)\n Returns : real or undef\n Args    : Bio::Tree::NodeI object, defaults to the root node\n\n\nsub subtree_length {\n    my $tree = shift;\n    my $node = shift || $tree->get_root_node;\n    return unless $node;\n    my $sum = 0;\n    for ( $node->get_all_Descendents ) {\n    $sum += $_->branch_length || 0;\n    }\n    return $sum;\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : my $id = $tree->id();\n Function: An id value for the tree\n Returns : scalar\n Args    : [optional] new value to set\n\n\n\nsub id{\n   my ($self,$val) = @_;\n   if( defined $val ) { \n       $self->{'_treeid'} = $val;\n   }\n   return $self->{'_treeid'};\n}\n\n=head2 score\n\n Title   : score\n Usage   : $obj->score($newval)\n Function: Sets the associated score with this tree\n           This is a generic slot which is probably best used \n           for log likelihood or other overall tree score\n Returns : value of score\n Args    : newvalue (optional)\n\n\n\nsub score{\n   my ($self,$val) = @_;\n   if( defined $val ) { \n       $self->{'_score'} = $val;\n   }\n   return $self->{'_score'};\n}\n\n\n# decorated interface TreeI Implements this\n\n=head2 height\n\n Title   : height\n Usage   : my $height = $tree->height\n Function: Gets the height of tree - this LOG_2($number_nodes)\n           WARNING: this is only true for strict binary trees.  The TreeIO\n           system is capable of building non-binary trees, for which this\n           method will currently return an incorrect value!!\n Returns : integer\n Args    : none\n\n=head2 number_nodes\n\n Title   : number_nodes\n Usage   : my $size = $tree->number_nodes\n Function: Returns the number of nodes in the tree\n Returns : integer\n Args    : none\n\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   : my $tree_as_string = $tree->as_text($format)\n Function: Returns the tree as a string representation in the \n           desired format (currently 'newick', 'nhx', or \n           'tabtree')\n Returns : scalar string\n Args    : format type as specified by Bio::TreeIO\n Note    : This method loads the Bio::TreeIO::$format module\n           on the fly, and commandeers the _write_tree_Helper\n           routine therein to create the tree string. \n\n\nsub as_text {\n    my $self = shift;\n    my $format = shift;\n    my @parms;\n    my $iomod = \"Bio::TreeIO::$format\";\n    $self->_load_module($iomod);\n    # following currently not really necessary, but who knows?\n    my $io = $iomod->new(-format=>$format, -file=>File::Spec->devnull());\n    no strict \"refs\";\n    my $iowtH = *{$iomod.\"::_write_tree_Helper\"}{CODE};\n    use strict \"refs\";\n    for ($format) {\n\t/newick/ && do {\n\t    @parms = ( $io->bootstrap_style, $io->order_by, 0 );\n\t    last;\n\t};\n\t/nhx/ && do {\n\t    @parms = ( 0 );\n\t    last;\n\t};\n\t/tabtree/ && do {\n\t    @parms = ( \"\" );\n\t    last;\n\t};\n\t# default\n\t$self->throw(\"as_text does not allow format '$format'\") \n    }\n\t\n\n    # newline_each_node...\n    my $data = [$iowtH->($self->get_root_node, @parms)];\n\n    if ($format eq 'tabtree') {\n\treturn $$data[0].\"\\n\";\n    }\n    else {\n\treturn join(\",\", @$data).\";\\n\";\n    }\n}\n\n=head2 Methods for associating Tag/Values with a Tree\n\nThese methods associate tag/value pairs with a Tree\n\n=head2 set_tag_value\n\n Title   : set_tag_value\n Usage   : $tree->set_tag_value($tag,$value)\n           $tree->set_tag_value($tag,@values)\n Function: Sets a tag value(s) to a tree. Replaces old values.\n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag\n\n\nsub set_tag_value{\n    my ($self,$tag,@values) = @_;\n    if( ! defined $tag || ! scalar @values ) {\n    $self->warn(\"cannot call set_tag_value with an undefined value\");\n    }\n    $self->remove_tag ($tag);\n    map { push @{$self->{'_tags'}->{$tag}}, $_ } @values;\n    return scalar @{$self->{'_tags'}->{$tag}};\n}\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $tree->add_tag_value($tag,$value)\n Function: Adds a tag value to a tree \n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag\n\n\nsub add_tag_value{\n    my ($self,$tag,$value) = @_;\n    if( ! defined $tag || ! defined $value ) {\n    $self->warn(\"cannot call add_tag_value with an undefined value\");\n    }\n    push @{$self->{'_tags'}->{$tag}}, $value;\n    return scalar @{$self->{'_tags'}->{$tag}};\n}\n\n=head2 remove_tag\n\n Title   : remove_tag\n Usage   : $tree->remove_tag($tag)\n Function: Remove the tag and all values for this tag\n Returns : boolean representing success (0 if tag does not exist)\n Args    : $tag - tagname to remove\n\n\n\nsub remove_tag {\n   my ($self,$tag) = @_;\n   if( exists $self->{'_tags'}->{$tag} ) {\n       $self->{'_tags'}->{$tag} = undef;\n       delete $self->{'_tags'}->{$tag};\n       return 1;\n   }\n   return 0;\n}\n\n=head2 remove_all_tags\n\n Title   : remove_all_tags\n Usage   : $tree->remove_all_tags()\n Function: Removes all tags \n Returns : None\n Args    : None"},"name":"remove_all_tags","containerName":"main::","children":[{"kind":13,"localvar":"my","containerName":"remove_all_tags","name":"$self","line":493,"definition":"my"},{"kind":13,"containerName":"remove_all_tags","name":"$self","line":494}],"detail":"($self)","definition":"sub"},{"line":508,"range":{"end":{"character":9999,"line":510},"start":{"character":0,"line":508}},"kind":12,"signature":{"label":"get_all_tags($self)","documentation":"1;\n# $Id: Tree.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::Tree - An Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Nodes which make up a tree.\n\n=head1 IMPLEMENTATION NOTE\n\nThis implementation of Bio::Tree::Tree contains Bio::Tree:::NodeI; mainly linked\nvia the root node. As NodeI can potentially contain circular references (as\nnodes will need to refer to both parent and child nodes), Bio::Tree::Tree will\nremove those circular references when the object is garbage-collected. This has\nsome side effects; primarily, one must keep the Tree in scope or have at least\none reference to it if working with nodes. The fix is to count the references to\nthe nodes and if it is greater than expected retain all of them, but it requires\nan additional prereq and thus may not be worth the effort.  This only shows up\nin minor edge cases, though (see Bug #2869).\n\nExample of issue:\n\n  # tree is not assigned to a variable, so passes from memory after\n  # root node is passed\n  my $root = Bio::TreeIO->new(-format => 'newick', -file => 'foo.txt')->next_tree\n\t\t ->get_root_node;\n  \n  # gets nothing, as all Node links are broken when Tree is garbage-collected above\n  my @descendents = $root->get_all_Descendents;\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\nSendu Bala   bix@sendu.me.uk\nMark A. Jensen maj@fortinbras.us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::Tree->new();\n Function: Builds a new Bio::Tree::Tree object \n Returns : Bio::Tree::Tree\n Args    : -root     => L<Bio::Tree::NodeI> object which is the root\n             OR\n           -node     => L<Bio::Tree::NodeI> object from which the root will be\n                        determined\n\n           -nodelete => boolean, whether or not to try and cleanup all\n                                 the nodes when this this tree goes out\n                                 of scope.\n           -id       => optional tree ID\n           -score    => optional tree score value\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n  $self->{'_rootnode'} = undef;\n  $self->{'_maxbranchlen'} = 0;\n  $self->_register_for_cleanup(\\&cleanup_tree);\n  my ($root,$node,$nodel,$id,$score)= $self->_rearrange([qw(ROOT NODE NODELETE \n                              ID SCORE)], @args);\n  \n  if ($node && ! $root) {\n    $self->throw(\"Must supply a Bio::Tree::NodeI\") unless ref($node) && $node->isa('Bio::Tree::NodeI');\n    my @lineage = $self->get_lineage_nodes($node);\n    $root = shift(@lineage) || $node;\n    \n    # to stop us pulling in entire database of a Bio::Taxon when we later do\n    # get_nodes() or similar, specifically set ancestor() for each node\n    if ($node->isa('Bio::Taxon')) {\n      push(@lineage, $node) unless $node eq $root;\n      my $ancestor = $root;\n      foreach my $lineage_node (@lineage) {\n        $lineage_node->ancestor($ancestor);\n      } continue { $ancestor = $lineage_node; }\n    }\n  }\n  if ($root) {\n    $self->set_root_node($root);\n  }\n  \n  $self->nodelete($nodel || 0);\n  $self->id($id)       if defined $id;\n  $self->score($score) if defined $score;\n  return $self;\n}\n\n\n=head2 nodelete\n\n Title   : nodelete\n Usage   : $obj->nodelete($newval)\n Function: Get/Set Boolean whether or not to delete the underlying\n           nodes when it goes out of scope.  By default this is false\n           meaning trees are cleaned up.\n Returns : boolean\n Args    : on set, new boolean value\n\n\nsub nodelete{\n    my $self = shift;\n    return $self->{'nodelete'} = shift if @_;\n    return $self->{'nodelete'};\n}\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Bio::Tree::NodeI objects\n Returns : array of Bio::Tree::NodeI objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self, @args) = @_;\n   \n   my ($order, $sortby) = $self->_rearrange([qw(ORDER SORTBY)],@args);\n   $order ||= 'depth';\n   $sortby ||= 'none';\n   my $node = $self->get_root_node || return;\n   if ($order =~ m/^b|(breadth)$/oi) {\n       my @children = ($node);\n       for (@children) {\n        push @children, $_->each_Descendent($sortby);\n       }\n       return @children;\n   }\n\n   if ($order =~ m/^d|(depth)$/oi) {\n       # this is depth-first search I believe\n       my @children = ($node,$node->get_all_Descendents($sortby));\n       return @children;\n   }\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Tree::NodeI object\n Args    : none\n\n\n\nsub get_root_node{\n   my ($self) = @_;\n   return $self->{'_rootnode'};\n}\n\n=head2 set_root_node\n\n Title   : set_root_node\n Usage   : $tree->set_root_node($node)\n Function: Set the Root Node for the Tree\n Returns : Bio::Tree::NodeI\n Args    : Bio::Tree::NodeI\n\n\nsub set_root_node{\n   my $self = shift;\n   if( @_ ) { \n       my $value = shift;\n       if( defined $value && \n       ! $value->isa('Bio::Tree::NodeI') ) { \n       $self->warn(\"Trying to set the root node to $value which is not a Bio::Tree::NodeI\");\n       return $self->get_root_node;\n       }\n       $self->{'_rootnode'} = $value;\n   } \n   return $self->get_root_node;\n}\n\n=head2 total_branch_length\n\n Title   : total_branch_length\n Usage   : my $size = $tree->total_branch_length\n Function: Returns the sum of the length of all branches\n Returns : real\n Args    : none\n\n\nsub total_branch_length { shift->subtree_length }\n\n=head2 subtree_length\n\n Title   : subtree_length\n Usage   : my $subtree_size = $tree->subtree_length($internal_node)\n Function: Returns the sum of the length of all branches in a subtree\n           under the node. Calculates the size of the whole tree\n           without an argument (but only if root node is defined)\n Returns : real or undef\n Args    : Bio::Tree::NodeI object, defaults to the root node\n\n\nsub subtree_length {\n    my $tree = shift;\n    my $node = shift || $tree->get_root_node;\n    return unless $node;\n    my $sum = 0;\n    for ( $node->get_all_Descendents ) {\n    $sum += $_->branch_length || 0;\n    }\n    return $sum;\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : my $id = $tree->id();\n Function: An id value for the tree\n Returns : scalar\n Args    : [optional] new value to set\n\n\n\nsub id{\n   my ($self,$val) = @_;\n   if( defined $val ) { \n       $self->{'_treeid'} = $val;\n   }\n   return $self->{'_treeid'};\n}\n\n=head2 score\n\n Title   : score\n Usage   : $obj->score($newval)\n Function: Sets the associated score with this tree\n           This is a generic slot which is probably best used \n           for log likelihood or other overall tree score\n Returns : value of score\n Args    : newvalue (optional)\n\n\n\nsub score{\n   my ($self,$val) = @_;\n   if( defined $val ) { \n       $self->{'_score'} = $val;\n   }\n   return $self->{'_score'};\n}\n\n\n# decorated interface TreeI Implements this\n\n=head2 height\n\n Title   : height\n Usage   : my $height = $tree->height\n Function: Gets the height of tree - this LOG_2($number_nodes)\n           WARNING: this is only true for strict binary trees.  The TreeIO\n           system is capable of building non-binary trees, for which this\n           method will currently return an incorrect value!!\n Returns : integer\n Args    : none\n\n=head2 number_nodes\n\n Title   : number_nodes\n Usage   : my $size = $tree->number_nodes\n Function: Returns the number of nodes in the tree\n Returns : integer\n Args    : none\n\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   : my $tree_as_string = $tree->as_text($format)\n Function: Returns the tree as a string representation in the \n           desired format (currently 'newick', 'nhx', or \n           'tabtree')\n Returns : scalar string\n Args    : format type as specified by Bio::TreeIO\n Note    : This method loads the Bio::TreeIO::$format module\n           on the fly, and commandeers the _write_tree_Helper\n           routine therein to create the tree string. \n\n\nsub as_text {\n    my $self = shift;\n    my $format = shift;\n    my @parms;\n    my $iomod = \"Bio::TreeIO::$format\";\n    $self->_load_module($iomod);\n    # following currently not really necessary, but who knows?\n    my $io = $iomod->new(-format=>$format, -file=>File::Spec->devnull());\n    no strict \"refs\";\n    my $iowtH = *{$iomod.\"::_write_tree_Helper\"}{CODE};\n    use strict \"refs\";\n    for ($format) {\n\t/newick/ && do {\n\t    @parms = ( $io->bootstrap_style, $io->order_by, 0 );\n\t    last;\n\t};\n\t/nhx/ && do {\n\t    @parms = ( 0 );\n\t    last;\n\t};\n\t/tabtree/ && do {\n\t    @parms = ( \"\" );\n\t    last;\n\t};\n\t# default\n\t$self->throw(\"as_text does not allow format '$format'\") \n    }\n\t\n\n    # newline_each_node...\n    my $data = [$iowtH->($self->get_root_node, @parms)];\n\n    if ($format eq 'tabtree') {\n\treturn $$data[0].\"\\n\";\n    }\n    else {\n\treturn join(\",\", @$data).\";\\n\";\n    }\n}\n\n=head2 Methods for associating Tag/Values with a Tree\n\nThese methods associate tag/value pairs with a Tree\n\n=head2 set_tag_value\n\n Title   : set_tag_value\n Usage   : $tree->set_tag_value($tag,$value)\n           $tree->set_tag_value($tag,@values)\n Function: Sets a tag value(s) to a tree. Replaces old values.\n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag\n\n\nsub set_tag_value{\n    my ($self,$tag,@values) = @_;\n    if( ! defined $tag || ! scalar @values ) {\n    $self->warn(\"cannot call set_tag_value with an undefined value\");\n    }\n    $self->remove_tag ($tag);\n    map { push @{$self->{'_tags'}->{$tag}}, $_ } @values;\n    return scalar @{$self->{'_tags'}->{$tag}};\n}\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $tree->add_tag_value($tag,$value)\n Function: Adds a tag value to a tree \n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag\n\n\nsub add_tag_value{\n    my ($self,$tag,$value) = @_;\n    if( ! defined $tag || ! defined $value ) {\n    $self->warn(\"cannot call add_tag_value with an undefined value\");\n    }\n    push @{$self->{'_tags'}->{$tag}}, $value;\n    return scalar @{$self->{'_tags'}->{$tag}};\n}\n\n=head2 remove_tag\n\n Title   : remove_tag\n Usage   : $tree->remove_tag($tag)\n Function: Remove the tag and all values for this tag\n Returns : boolean representing success (0 if tag does not exist)\n Args    : $tag - tagname to remove\n\n\n\nsub remove_tag {\n   my ($self,$tag) = @_;\n   if( exists $self->{'_tags'}->{$tag} ) {\n       $self->{'_tags'}->{$tag} = undef;\n       delete $self->{'_tags'}->{$tag};\n       return 1;\n   }\n   return 0;\n}\n\n=head2 remove_all_tags\n\n Title   : remove_all_tags\n Usage   : $tree->remove_all_tags()\n Function: Removes all tags \n Returns : None\n Args    : None\n\n\nsub remove_all_tags{\n   my ($self) = @_;\n   $self->{'_tags'} = {};\n   return;\n}\n\n=head2 get_all_tags\n\n Title   : get_all_tags\n Usage   : my @tags = $tree->get_all_tags()\n Function: Gets all the tag names for this Tree\n Returns : Array of tagnames\n Args    : None","parameters":[{"label":"$self"}]},"children":[{"line":509,"name":"$self","containerName":"get_all_tags","localvar":"my","kind":13,"definition":"my"},{"definition":"my","line":510,"localvar":"my","containerName":"get_all_tags","kind":13,"name":"@tags"},{"line":510,"name":"$self","containerName":"get_all_tags","kind":13}],"containerName":"main::","name":"get_all_tags","definition":"sub","detail":"($self)"},{"line":511,"containerName":null,"kind":13,"name":"@tags"},{"range":{"end":{"character":9999,"line":526},"start":{"character":0,"line":524}},"kind":12,"line":524,"signature":{"label":"get_tag_values($self,$tag)","parameters":[{"label":"$self"},{"label":"$tag"}],"documentation":"1;\n# $Id: Tree.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::Tree - An Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Nodes which make up a tree.\n\n=head1 IMPLEMENTATION NOTE\n\nThis implementation of Bio::Tree::Tree contains Bio::Tree:::NodeI; mainly linked\nvia the root node. As NodeI can potentially contain circular references (as\nnodes will need to refer to both parent and child nodes), Bio::Tree::Tree will\nremove those circular references when the object is garbage-collected. This has\nsome side effects; primarily, one must keep the Tree in scope or have at least\none reference to it if working with nodes. The fix is to count the references to\nthe nodes and if it is greater than expected retain all of them, but it requires\nan additional prereq and thus may not be worth the effort.  This only shows up\nin minor edge cases, though (see Bug #2869).\n\nExample of issue:\n\n  # tree is not assigned to a variable, so passes from memory after\n  # root node is passed\n  my $root = Bio::TreeIO->new(-format => 'newick', -file => 'foo.txt')->next_tree\n\t\t ->get_root_node;\n  \n  # gets nothing, as all Node links are broken when Tree is garbage-collected above\n  my @descendents = $root->get_all_Descendents;\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\nSendu Bala   bix@sendu.me.uk\nMark A. Jensen maj@fortinbras.us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::Tree->new();\n Function: Builds a new Bio::Tree::Tree object \n Returns : Bio::Tree::Tree\n Args    : -root     => L<Bio::Tree::NodeI> object which is the root\n             OR\n           -node     => L<Bio::Tree::NodeI> object from which the root will be\n                        determined\n\n           -nodelete => boolean, whether or not to try and cleanup all\n                                 the nodes when this this tree goes out\n                                 of scope.\n           -id       => optional tree ID\n           -score    => optional tree score value\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n  $self->{'_rootnode'} = undef;\n  $self->{'_maxbranchlen'} = 0;\n  $self->_register_for_cleanup(\\&cleanup_tree);\n  my ($root,$node,$nodel,$id,$score)= $self->_rearrange([qw(ROOT NODE NODELETE \n                              ID SCORE)], @args);\n  \n  if ($node && ! $root) {\n    $self->throw(\"Must supply a Bio::Tree::NodeI\") unless ref($node) && $node->isa('Bio::Tree::NodeI');\n    my @lineage = $self->get_lineage_nodes($node);\n    $root = shift(@lineage) || $node;\n    \n    # to stop us pulling in entire database of a Bio::Taxon when we later do\n    # get_nodes() or similar, specifically set ancestor() for each node\n    if ($node->isa('Bio::Taxon')) {\n      push(@lineage, $node) unless $node eq $root;\n      my $ancestor = $root;\n      foreach my $lineage_node (@lineage) {\n        $lineage_node->ancestor($ancestor);\n      } continue { $ancestor = $lineage_node; }\n    }\n  }\n  if ($root) {\n    $self->set_root_node($root);\n  }\n  \n  $self->nodelete($nodel || 0);\n  $self->id($id)       if defined $id;\n  $self->score($score) if defined $score;\n  return $self;\n}\n\n\n=head2 nodelete\n\n Title   : nodelete\n Usage   : $obj->nodelete($newval)\n Function: Get/Set Boolean whether or not to delete the underlying\n           nodes when it goes out of scope.  By default this is false\n           meaning trees are cleaned up.\n Returns : boolean\n Args    : on set, new boolean value\n\n\nsub nodelete{\n    my $self = shift;\n    return $self->{'nodelete'} = shift if @_;\n    return $self->{'nodelete'};\n}\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Bio::Tree::NodeI objects\n Returns : array of Bio::Tree::NodeI objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self, @args) = @_;\n   \n   my ($order, $sortby) = $self->_rearrange([qw(ORDER SORTBY)],@args);\n   $order ||= 'depth';\n   $sortby ||= 'none';\n   my $node = $self->get_root_node || return;\n   if ($order =~ m/^b|(breadth)$/oi) {\n       my @children = ($node);\n       for (@children) {\n        push @children, $_->each_Descendent($sortby);\n       }\n       return @children;\n   }\n\n   if ($order =~ m/^d|(depth)$/oi) {\n       # this is depth-first search I believe\n       my @children = ($node,$node->get_all_Descendents($sortby));\n       return @children;\n   }\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Tree::NodeI object\n Args    : none\n\n\n\nsub get_root_node{\n   my ($self) = @_;\n   return $self->{'_rootnode'};\n}\n\n=head2 set_root_node\n\n Title   : set_root_node\n Usage   : $tree->set_root_node($node)\n Function: Set the Root Node for the Tree\n Returns : Bio::Tree::NodeI\n Args    : Bio::Tree::NodeI\n\n\nsub set_root_node{\n   my $self = shift;\n   if( @_ ) { \n       my $value = shift;\n       if( defined $value && \n       ! $value->isa('Bio::Tree::NodeI') ) { \n       $self->warn(\"Trying to set the root node to $value which is not a Bio::Tree::NodeI\");\n       return $self->get_root_node;\n       }\n       $self->{'_rootnode'} = $value;\n   } \n   return $self->get_root_node;\n}\n\n=head2 total_branch_length\n\n Title   : total_branch_length\n Usage   : my $size = $tree->total_branch_length\n Function: Returns the sum of the length of all branches\n Returns : real\n Args    : none\n\n\nsub total_branch_length { shift->subtree_length }\n\n=head2 subtree_length\n\n Title   : subtree_length\n Usage   : my $subtree_size = $tree->subtree_length($internal_node)\n Function: Returns the sum of the length of all branches in a subtree\n           under the node. Calculates the size of the whole tree\n           without an argument (but only if root node is defined)\n Returns : real or undef\n Args    : Bio::Tree::NodeI object, defaults to the root node\n\n\nsub subtree_length {\n    my $tree = shift;\n    my $node = shift || $tree->get_root_node;\n    return unless $node;\n    my $sum = 0;\n    for ( $node->get_all_Descendents ) {\n    $sum += $_->branch_length || 0;\n    }\n    return $sum;\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : my $id = $tree->id();\n Function: An id value for the tree\n Returns : scalar\n Args    : [optional] new value to set\n\n\n\nsub id{\n   my ($self,$val) = @_;\n   if( defined $val ) { \n       $self->{'_treeid'} = $val;\n   }\n   return $self->{'_treeid'};\n}\n\n=head2 score\n\n Title   : score\n Usage   : $obj->score($newval)\n Function: Sets the associated score with this tree\n           This is a generic slot which is probably best used \n           for log likelihood or other overall tree score\n Returns : value of score\n Args    : newvalue (optional)\n\n\n\nsub score{\n   my ($self,$val) = @_;\n   if( defined $val ) { \n       $self->{'_score'} = $val;\n   }\n   return $self->{'_score'};\n}\n\n\n# decorated interface TreeI Implements this\n\n=head2 height\n\n Title   : height\n Usage   : my $height = $tree->height\n Function: Gets the height of tree - this LOG_2($number_nodes)\n           WARNING: this is only true for strict binary trees.  The TreeIO\n           system is capable of building non-binary trees, for which this\n           method will currently return an incorrect value!!\n Returns : integer\n Args    : none\n\n=head2 number_nodes\n\n Title   : number_nodes\n Usage   : my $size = $tree->number_nodes\n Function: Returns the number of nodes in the tree\n Returns : integer\n Args    : none\n\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   : my $tree_as_string = $tree->as_text($format)\n Function: Returns the tree as a string representation in the \n           desired format (currently 'newick', 'nhx', or \n           'tabtree')\n Returns : scalar string\n Args    : format type as specified by Bio::TreeIO\n Note    : This method loads the Bio::TreeIO::$format module\n           on the fly, and commandeers the _write_tree_Helper\n           routine therein to create the tree string. \n\n\nsub as_text {\n    my $self = shift;\n    my $format = shift;\n    my @parms;\n    my $iomod = \"Bio::TreeIO::$format\";\n    $self->_load_module($iomod);\n    # following currently not really necessary, but who knows?\n    my $io = $iomod->new(-format=>$format, -file=>File::Spec->devnull());\n    no strict \"refs\";\n    my $iowtH = *{$iomod.\"::_write_tree_Helper\"}{CODE};\n    use strict \"refs\";\n    for ($format) {\n\t/newick/ && do {\n\t    @parms = ( $io->bootstrap_style, $io->order_by, 0 );\n\t    last;\n\t};\n\t/nhx/ && do {\n\t    @parms = ( 0 );\n\t    last;\n\t};\n\t/tabtree/ && do {\n\t    @parms = ( \"\" );\n\t    last;\n\t};\n\t# default\n\t$self->throw(\"as_text does not allow format '$format'\") \n    }\n\t\n\n    # newline_each_node...\n    my $data = [$iowtH->($self->get_root_node, @parms)];\n\n    if ($format eq 'tabtree') {\n\treturn $$data[0].\"\\n\";\n    }\n    else {\n\treturn join(\",\", @$data).\";\\n\";\n    }\n}\n\n=head2 Methods for associating Tag/Values with a Tree\n\nThese methods associate tag/value pairs with a Tree\n\n=head2 set_tag_value\n\n Title   : set_tag_value\n Usage   : $tree->set_tag_value($tag,$value)\n           $tree->set_tag_value($tag,@values)\n Function: Sets a tag value(s) to a tree. Replaces old values.\n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag\n\n\nsub set_tag_value{\n    my ($self,$tag,@values) = @_;\n    if( ! defined $tag || ! scalar @values ) {\n    $self->warn(\"cannot call set_tag_value with an undefined value\");\n    }\n    $self->remove_tag ($tag);\n    map { push @{$self->{'_tags'}->{$tag}}, $_ } @values;\n    return scalar @{$self->{'_tags'}->{$tag}};\n}\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $tree->add_tag_value($tag,$value)\n Function: Adds a tag value to a tree \n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag\n\n\nsub add_tag_value{\n    my ($self,$tag,$value) = @_;\n    if( ! defined $tag || ! defined $value ) {\n    $self->warn(\"cannot call add_tag_value with an undefined value\");\n    }\n    push @{$self->{'_tags'}->{$tag}}, $value;\n    return scalar @{$self->{'_tags'}->{$tag}};\n}\n\n=head2 remove_tag\n\n Title   : remove_tag\n Usage   : $tree->remove_tag($tag)\n Function: Remove the tag and all values for this tag\n Returns : boolean representing success (0 if tag does not exist)\n Args    : $tag - tagname to remove\n\n\n\nsub remove_tag {\n   my ($self,$tag) = @_;\n   if( exists $self->{'_tags'}->{$tag} ) {\n       $self->{'_tags'}->{$tag} = undef;\n       delete $self->{'_tags'}->{$tag};\n       return 1;\n   }\n   return 0;\n}\n\n=head2 remove_all_tags\n\n Title   : remove_all_tags\n Usage   : $tree->remove_all_tags()\n Function: Removes all tags \n Returns : None\n Args    : None\n\n\nsub remove_all_tags{\n   my ($self) = @_;\n   $self->{'_tags'} = {};\n   return;\n}\n\n=head2 get_all_tags\n\n Title   : get_all_tags\n Usage   : my @tags = $tree->get_all_tags()\n Function: Gets all the tag names for this Tree\n Returns : Array of tagnames\n Args    : None\n\n\nsub get_all_tags{\n   my ($self) = @_;\n   my @tags = sort keys %{$self->{'_tags'} || {}};\n   return @tags;\n}\n\n=head2 get_tag_values\n\n Title   : get_tag_values\n Usage   : my @values = $tree->get_tag_values($tag)\n Function: Gets the values for given tag ($tag)\n Returns : Array of values or empty list if tag does not exist\n Args    : $tag - tag name"},"containerName":"main::","name":"get_tag_values","children":[{"containerName":"get_tag_values","localvar":"my","kind":13,"name":"$self","line":525,"definition":"my"},{"line":525,"name":"$tag","kind":13,"containerName":"get_tag_values"},{"line":526,"containerName":"get_tag_values","kind":13,"name":"$self"},{"containerName":"get_tag_values","kind":13,"name":"$tag","line":526}],"detail":"($self,$tag)","definition":"sub"},{"line":527,"kind":13,"containerName":null,"name":"%self"},{"containerName":null,"kind":13,"name":"@tag","line":527},{"signature":{"label":"has_tag($self,$tag)","documentation":"1;\n# $Id: Tree.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::Tree - An Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Nodes which make up a tree.\n\n=head1 IMPLEMENTATION NOTE\n\nThis implementation of Bio::Tree::Tree contains Bio::Tree:::NodeI; mainly linked\nvia the root node. As NodeI can potentially contain circular references (as\nnodes will need to refer to both parent and child nodes), Bio::Tree::Tree will\nremove those circular references when the object is garbage-collected. This has\nsome side effects; primarily, one must keep the Tree in scope or have at least\none reference to it if working with nodes. The fix is to count the references to\nthe nodes and if it is greater than expected retain all of them, but it requires\nan additional prereq and thus may not be worth the effort.  This only shows up\nin minor edge cases, though (see Bug #2869).\n\nExample of issue:\n\n  # tree is not assigned to a variable, so passes from memory after\n  # root node is passed\n  my $root = Bio::TreeIO->new(-format => 'newick', -file => 'foo.txt')->next_tree\n\t\t ->get_root_node;\n  \n  # gets nothing, as all Node links are broken when Tree is garbage-collected above\n  my @descendents = $root->get_all_Descendents;\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nAaron Mackey amackey@virginia.edu\nSendu Bala   bix@sendu.me.uk\nMark A. Jensen maj@fortinbras.us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::Tree->new();\n Function: Builds a new Bio::Tree::Tree object \n Returns : Bio::Tree::Tree\n Args    : -root     => L<Bio::Tree::NodeI> object which is the root\n             OR\n           -node     => L<Bio::Tree::NodeI> object from which the root will be\n                        determined\n\n           -nodelete => boolean, whether or not to try and cleanup all\n                                 the nodes when this this tree goes out\n                                 of scope.\n           -id       => optional tree ID\n           -score    => optional tree score value\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n  $self->{'_rootnode'} = undef;\n  $self->{'_maxbranchlen'} = 0;\n  $self->_register_for_cleanup(\\&cleanup_tree);\n  my ($root,$node,$nodel,$id,$score)= $self->_rearrange([qw(ROOT NODE NODELETE \n                              ID SCORE)], @args);\n  \n  if ($node && ! $root) {\n    $self->throw(\"Must supply a Bio::Tree::NodeI\") unless ref($node) && $node->isa('Bio::Tree::NodeI');\n    my @lineage = $self->get_lineage_nodes($node);\n    $root = shift(@lineage) || $node;\n    \n    # to stop us pulling in entire database of a Bio::Taxon when we later do\n    # get_nodes() or similar, specifically set ancestor() for each node\n    if ($node->isa('Bio::Taxon')) {\n      push(@lineage, $node) unless $node eq $root;\n      my $ancestor = $root;\n      foreach my $lineage_node (@lineage) {\n        $lineage_node->ancestor($ancestor);\n      } continue { $ancestor = $lineage_node; }\n    }\n  }\n  if ($root) {\n    $self->set_root_node($root);\n  }\n  \n  $self->nodelete($nodel || 0);\n  $self->id($id)       if defined $id;\n  $self->score($score) if defined $score;\n  return $self;\n}\n\n\n=head2 nodelete\n\n Title   : nodelete\n Usage   : $obj->nodelete($newval)\n Function: Get/Set Boolean whether or not to delete the underlying\n           nodes when it goes out of scope.  By default this is false\n           meaning trees are cleaned up.\n Returns : boolean\n Args    : on set, new boolean value\n\n\nsub nodelete{\n    my $self = shift;\n    return $self->{'nodelete'} = shift if @_;\n    return $self->{'nodelete'};\n}\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Bio::Tree::NodeI objects\n Returns : array of Bio::Tree::NodeI objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self, @args) = @_;\n   \n   my ($order, $sortby) = $self->_rearrange([qw(ORDER SORTBY)],@args);\n   $order ||= 'depth';\n   $sortby ||= 'none';\n   my $node = $self->get_root_node || return;\n   if ($order =~ m/^b|(breadth)$/oi) {\n       my @children = ($node);\n       for (@children) {\n        push @children, $_->each_Descendent($sortby);\n       }\n       return @children;\n   }\n\n   if ($order =~ m/^d|(depth)$/oi) {\n       # this is depth-first search I believe\n       my @children = ($node,$node->get_all_Descendents($sortby));\n       return @children;\n   }\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Tree::NodeI object\n Args    : none\n\n\n\nsub get_root_node{\n   my ($self) = @_;\n   return $self->{'_rootnode'};\n}\n\n=head2 set_root_node\n\n Title   : set_root_node\n Usage   : $tree->set_root_node($node)\n Function: Set the Root Node for the Tree\n Returns : Bio::Tree::NodeI\n Args    : Bio::Tree::NodeI\n\n\nsub set_root_node{\n   my $self = shift;\n   if( @_ ) { \n       my $value = shift;\n       if( defined $value && \n       ! $value->isa('Bio::Tree::NodeI') ) { \n       $self->warn(\"Trying to set the root node to $value which is not a Bio::Tree::NodeI\");\n       return $self->get_root_node;\n       }\n       $self->{'_rootnode'} = $value;\n   } \n   return $self->get_root_node;\n}\n\n=head2 total_branch_length\n\n Title   : total_branch_length\n Usage   : my $size = $tree->total_branch_length\n Function: Returns the sum of the length of all branches\n Returns : real\n Args    : none\n\n\nsub total_branch_length { shift->subtree_length }\n\n=head2 subtree_length\n\n Title   : subtree_length\n Usage   : my $subtree_size = $tree->subtree_length($internal_node)\n Function: Returns the sum of the length of all branches in a subtree\n           under the node. Calculates the size of the whole tree\n           without an argument (but only if root node is defined)\n Returns : real or undef\n Args    : Bio::Tree::NodeI object, defaults to the root node\n\n\nsub subtree_length {\n    my $tree = shift;\n    my $node = shift || $tree->get_root_node;\n    return unless $node;\n    my $sum = 0;\n    for ( $node->get_all_Descendents ) {\n    $sum += $_->branch_length || 0;\n    }\n    return $sum;\n}\n\n\n=head2 id\n\n Title   : id\n Usage   : my $id = $tree->id();\n Function: An id value for the tree\n Returns : scalar\n Args    : [optional] new value to set\n\n\n\nsub id{\n   my ($self,$val) = @_;\n   if( defined $val ) { \n       $self->{'_treeid'} = $val;\n   }\n   return $self->{'_treeid'};\n}\n\n=head2 score\n\n Title   : score\n Usage   : $obj->score($newval)\n Function: Sets the associated score with this tree\n           This is a generic slot which is probably best used \n           for log likelihood or other overall tree score\n Returns : value of score\n Args    : newvalue (optional)\n\n\n\nsub score{\n   my ($self,$val) = @_;\n   if( defined $val ) { \n       $self->{'_score'} = $val;\n   }\n   return $self->{'_score'};\n}\n\n\n# decorated interface TreeI Implements this\n\n=head2 height\n\n Title   : height\n Usage   : my $height = $tree->height\n Function: Gets the height of tree - this LOG_2($number_nodes)\n           WARNING: this is only true for strict binary trees.  The TreeIO\n           system is capable of building non-binary trees, for which this\n           method will currently return an incorrect value!!\n Returns : integer\n Args    : none\n\n=head2 number_nodes\n\n Title   : number_nodes\n Usage   : my $size = $tree->number_nodes\n Function: Returns the number of nodes in the tree\n Returns : integer\n Args    : none\n\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   : my $tree_as_string = $tree->as_text($format)\n Function: Returns the tree as a string representation in the \n           desired format (currently 'newick', 'nhx', or \n           'tabtree')\n Returns : scalar string\n Args    : format type as specified by Bio::TreeIO\n Note    : This method loads the Bio::TreeIO::$format module\n           on the fly, and commandeers the _write_tree_Helper\n           routine therein to create the tree string. \n\n\nsub as_text {\n    my $self = shift;\n    my $format = shift;\n    my @parms;\n    my $iomod = \"Bio::TreeIO::$format\";\n    $self->_load_module($iomod);\n    # following currently not really necessary, but who knows?\n    my $io = $iomod->new(-format=>$format, -file=>File::Spec->devnull());\n    no strict \"refs\";\n    my $iowtH = *{$iomod.\"::_write_tree_Helper\"}{CODE};\n    use strict \"refs\";\n    for ($format) {\n\t/newick/ && do {\n\t    @parms = ( $io->bootstrap_style, $io->order_by, 0 );\n\t    last;\n\t};\n\t/nhx/ && do {\n\t    @parms = ( 0 );\n\t    last;\n\t};\n\t/tabtree/ && do {\n\t    @parms = ( \"\" );\n\t    last;\n\t};\n\t# default\n\t$self->throw(\"as_text does not allow format '$format'\") \n    }\n\t\n\n    # newline_each_node...\n    my $data = [$iowtH->($self->get_root_node, @parms)];\n\n    if ($format eq 'tabtree') {\n\treturn $$data[0].\"\\n\";\n    }\n    else {\n\treturn join(\",\", @$data).\";\\n\";\n    }\n}\n\n=head2 Methods for associating Tag/Values with a Tree\n\nThese methods associate tag/value pairs with a Tree\n\n=head2 set_tag_value\n\n Title   : set_tag_value\n Usage   : $tree->set_tag_value($tag,$value)\n           $tree->set_tag_value($tag,@values)\n Function: Sets a tag value(s) to a tree. Replaces old values.\n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag\n\n\nsub set_tag_value{\n    my ($self,$tag,@values) = @_;\n    if( ! defined $tag || ! scalar @values ) {\n    $self->warn(\"cannot call set_tag_value with an undefined value\");\n    }\n    $self->remove_tag ($tag);\n    map { push @{$self->{'_tags'}->{$tag}}, $_ } @values;\n    return scalar @{$self->{'_tags'}->{$tag}};\n}\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $tree->add_tag_value($tag,$value)\n Function: Adds a tag value to a tree \n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag\n\n\nsub add_tag_value{\n    my ($self,$tag,$value) = @_;\n    if( ! defined $tag || ! defined $value ) {\n    $self->warn(\"cannot call add_tag_value with an undefined value\");\n    }\n    push @{$self->{'_tags'}->{$tag}}, $value;\n    return scalar @{$self->{'_tags'}->{$tag}};\n}\n\n=head2 remove_tag\n\n Title   : remove_tag\n Usage   : $tree->remove_tag($tag)\n Function: Remove the tag and all values for this tag\n Returns : boolean representing success (0 if tag does not exist)\n Args    : $tag - tagname to remove\n\n\n\nsub remove_tag {\n   my ($self,$tag) = @_;\n   if( exists $self->{'_tags'}->{$tag} ) {\n       $self->{'_tags'}->{$tag} = undef;\n       delete $self->{'_tags'}->{$tag};\n       return 1;\n   }\n   return 0;\n}\n\n=head2 remove_all_tags\n\n Title   : remove_all_tags\n Usage   : $tree->remove_all_tags()\n Function: Removes all tags \n Returns : None\n Args    : None\n\n\nsub remove_all_tags{\n   my ($self) = @_;\n   $self->{'_tags'} = {};\n   return;\n}\n\n=head2 get_all_tags\n\n Title   : get_all_tags\n Usage   : my @tags = $tree->get_all_tags()\n Function: Gets all the tag names for this Tree\n Returns : Array of tagnames\n Args    : None\n\n\nsub get_all_tags{\n   my ($self) = @_;\n   my @tags = sort keys %{$self->{'_tags'} || {}};\n   return @tags;\n}\n\n=head2 get_tag_values\n\n Title   : get_tag_values\n Usage   : my @values = $tree->get_tag_values($tag)\n Function: Gets the values for given tag ($tag)\n Returns : Array of values or empty list if tag does not exist\n Args    : $tag - tag name\n\n\nsub get_tag_values{\n   my ($self,$tag) = @_;\n   return wantarray ? @{$self->{'_tags'}->{$tag} || []} :\n                     (@{$self->{'_tags'}->{$tag} || []})[0];\n}\n\n=head2 has_tag\n\n Title   : has_tag\n Usage   : $tree->has_tag($tag)\n Function: Boolean test if tag exists in the Tree\n Returns : Boolean\n Args    : $tag - tagname","parameters":[{"label":"$self"},{"label":"$tag"}]},"kind":12,"range":{"end":{"line":543,"character":9999},"start":{"character":0,"line":540}},"line":540,"detail":"($self,$tag)","definition":"sub","name":"has_tag","containerName":"main::","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"has_tag","name":"$self","line":541},{"line":541,"name":"$tag","containerName":"has_tag","kind":13},{"name":"$self","kind":13,"containerName":"has_tag","line":542},{"containerName":"has_tag","kind":13,"name":"$tag","line":542}]},{"containerName":"main::","name":"cleanup_tree","children":[{"name":"$self","localvar":"my","containerName":"cleanup_tree","kind":13,"line":548,"definition":"my"},{"line":549,"kind":13,"containerName":"cleanup_tree","name":"$self"},{"name":"nodelete","containerName":"cleanup_tree","kind":12,"line":549},{"name":"$node","localvar":"my","kind":13,"containerName":"cleanup_tree","line":550,"definition":"my"},{"containerName":"cleanup_tree","kind":13,"name":"$self","line":550},{"line":550,"kind":12,"containerName":"cleanup_tree","name":"get_nodes"},{"kind":13,"containerName":"cleanup_tree","name":"$node","line":553},{"line":553,"kind":12,"containerName":"cleanup_tree","name":"node_cleanup"},{"line":554,"name":"$node","containerName":"cleanup_tree","kind":13},{"name":"$self","kind":13,"containerName":"cleanup_tree","line":557}],"definition":"sub","kind":12,"range":{"start":{"character":0,"line":547},"end":{"line":558,"character":9999}},"line":547}]}