{"version":5,"vars":[{"containerName":"","kind":2,"name":"vars","line":106},{"line":109,"name":"$PRECISION_DIGITS","kind":13,"containerName":null},{"line":109,"kind":2,"containerName":"","name":"strict"},{"name":"$DefaultNodeType","kind":13,"containerName":null,"line":110},{"name":"%Defaults","kind":13,"containerName":null,"line":111},{"line":119,"containerName":"","kind":2,"name":"base"},{"children":[{"definition":"my","name":"$class","localvar":"my","kind":13,"containerName":"new","line":144},{"line":144,"name":"@args","containerName":"new","kind":13},{"name":"$self","localvar":"my","kind":13,"containerName":"new","line":145,"definition":"my"},{"kind":13,"containerName":"new","name":"$class","line":145},{"name":"@args","kind":13,"containerName":"new","line":145},{"line":147,"name":"$self","kind":13,"containerName":"new"},{"line":148,"kind":13,"containerName":"new","name":"$self"},{"localvar":"my","kind":13,"containerName":"new","name":"$nodetype","line":149,"definition":"my"},{"name":"$randtype","kind":13,"containerName":"new","line":149},{"kind":13,"containerName":"new","name":"$maxcount","line":150},{"line":150,"kind":13,"containerName":"new","name":"$samps"},{"line":150,"name":"$samplesize","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$taxa","line":151},{"name":"$num_taxa","containerName":"new","kind":13,"line":151},{"line":151,"kind":13,"containerName":"new","name":"$self"},{"line":151,"name":"_rearrange","containerName":"new","kind":12},{"line":158,"containerName":"new","kind":13,"name":"@args"},{"definition":"my","name":"@taxa","containerName":"new","localvar":"my","kind":13,"line":159},{"name":"$nodetype","kind":13,"containerName":"new","line":160},{"containerName":"new","kind":13,"name":"$DefaultNodeType","line":160},{"kind":13,"containerName":"new","name":"$self","line":161},{"line":161,"name":"nodetype","containerName":"new","kind":12},{"kind":13,"containerName":"new","name":"$nodetype","line":161},{"line":162,"kind":13,"containerName":"new","name":"$taxa"},{"kind":13,"containerName":"new","name":"$samps","line":162},{"kind":13,"containerName":"new","name":"$samps","line":162},{"line":162,"kind":13,"containerName":"new","name":"$taxa"},{"line":163,"name":"$num_taxa","containerName":"new","kind":13},{"line":163,"name":"$samplesize","containerName":"new","kind":13},{"line":163,"containerName":"new","kind":13,"name":"$samplesize"},{"containerName":"new","kind":13,"name":"$num_taxa","line":163},{"name":"$taxa","kind":13,"containerName":"new","line":164},{"line":165,"containerName":"new","kind":13,"name":"$num_taxa"},{"line":165,"name":"$num_taxa","kind":13,"containerName":"new"},{"line":166,"kind":13,"containerName":"new","name":"$self"},{"line":166,"name":"throw","kind":12,"containerName":"new"},{"line":168,"name":"$num_taxa","containerName":"new","kind":13},{"line":168,"name":"@taxa","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$taxa","line":170},{"containerName":"new","kind":13,"name":"$self","line":171},{"line":171,"name":"throw","kind":12,"containerName":"new"},{"name":"@taxa","kind":13,"containerName":"new","line":173},{"line":173,"containerName":"new","kind":13,"name":"$taxa"},{"name":"$self","containerName":"new","kind":13,"line":176},{"line":176,"containerName":"new","kind":12,"name":"taxa"},{"line":176,"kind":13,"containerName":"new","name":"@taxa"},{"name":"$maxcount","kind":13,"containerName":"new","line":177},{"line":177,"name":"$self","kind":13,"containerName":"new"},{"line":177,"kind":12,"containerName":"new","name":"maxcount"},{"name":"$maxcount","kind":13,"containerName":"new","line":177},{"line":178,"containerName":"new","kind":13,"name":"$self"},{"kind":13,"containerName":"new","name":"$self","line":179}],"name":"new","containerName":"main::","definition":"sub","detail":"($class,@args)","line":143,"kind":12,"range":{"end":{"line":180,"character":9999},"start":{"line":143,"character":0}},"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: RandomFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::RandomFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::RandomFactory - TreeFactory for generating Random Trees\n\n=head1 SYNOPSIS\n\n  use Bio::Tree::RandomFactory\n  my @taxonnames;\n  my $factory = Bio::Tree::RandomFactory->new( -taxa => \\@taxonnames,\n  \t\t\t\t\t      -maxcount => 10);\n\n  # or for anonymous samples\n\n  my $factory = Bio::Tree::RandomFactory->new( -num_taxa => 6,\n\t\t\t\t\t      -maxcount => 50);\n\n\n  my $tree = $factory->next_tree;\n\n=head1 DESCRIPTION\n\nBuilds a random tree every time next_tree is called or up to -maxcount times.\n\nThis module was originally written for Coalescent simulations see\nL<Bio::PopGen::Simulation::Coalescent>.  I've left the next_tree\nmethod intact although it is not generating random trees in the\nphylogenetic sense.  I would be happy for someone to provide\nalternative implementations which can be used here.  As written it\nwill generate random topologies but the branch lengths are built from\nassumptions in the coalescent and are not appropriate for phylogenetic\nanalyses.\n\nThis algorithm is based on the make_tree algorithm from Richard Hudson 1990.\n\nHudson, R. R. 1990. Gene genealogies and the coalescent\n       process. Pp. 1-44 in D. Futuyma and J.  Antonovics, eds. Oxford\n       surveys in evolutionary biology. Vol. 7. Oxford University\n       Press, New York\n\nSanderson, M ... \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, E<lt>matthew.hahn@duke.eduE<gt>\nMike Sanderson \n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::RandomFactory;\nuse vars qw($PRECISION_DIGITS $DefaultNodeType %Defaults);\nuse strict;\n\n$PRECISION_DIGITS = 3; # Precision for the branchlength\n$DefaultNodeType = 'Bio::Tree::Node';\n%Defaults = ('YuleRate'          => 1.0, # as set by Sanderson in Rates\n\t     'Speciation'        => 1.0, #\n\t     'DefaultTreeMethod' => 'yule',\n\t     );\n\nuse Bio::Tools::RandomDistFunctions;\nuse Bio::Tree::Tree;\n\nuse base qw(Bio::Root::Root Bio::Factory::TreeFactoryI);\n\n=head2 new\n\n Title   : new\n Usage   : my $factory = Bio::Tree::RandomFactory->new(-samples => \\@samples,\n\t\t\t\t\t\t      -maxcount=> $N);\n Function: Initializes a Bio::Tree::RandomFactory object\n Returns : Bio::Tree::RandomFactory\n Args    : -nodetype => Type of Nodes to create [default Bio::Tree::Node]\n           -maxcount => [optional] Maximum num trees to create\n           -randtype => Type of random trees so far support\n               - yule/backward_yule/BY [default]\n               - forward_yule/FY\n               - birthdeath_forward/BDF\n               - birthdeath_backwards/BDB\n\n\n          ONE of the following must be specified\n           -taxa     => $arrayref of taxa names\n           -num_taxa => integer indicating number of taxa in the tree"}},{"line":145,"kind":12,"containerName":"new","name":"SUPER"},{"line":197,"kind":12,"range":{"start":{"line":197,"character":0},"end":{"character":9999,"line":228}},"signature":{"parameters":[{"label":"$self"},{"label":"%options"}],"documentation":"1;\n# $Id: RandomFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::RandomFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::RandomFactory - TreeFactory for generating Random Trees\n\n=head1 SYNOPSIS\n\n  use Bio::Tree::RandomFactory\n  my @taxonnames;\n  my $factory = Bio::Tree::RandomFactory->new( -taxa => \\@taxonnames,\n  \t\t\t\t\t      -maxcount => 10);\n\n  # or for anonymous samples\n\n  my $factory = Bio::Tree::RandomFactory->new( -num_taxa => 6,\n\t\t\t\t\t      -maxcount => 50);\n\n\n  my $tree = $factory->next_tree;\n\n=head1 DESCRIPTION\n\nBuilds a random tree every time next_tree is called or up to -maxcount times.\n\nThis module was originally written for Coalescent simulations see\nL<Bio::PopGen::Simulation::Coalescent>.  I've left the next_tree\nmethod intact although it is not generating random trees in the\nphylogenetic sense.  I would be happy for someone to provide\nalternative implementations which can be used here.  As written it\nwill generate random topologies but the branch lengths are built from\nassumptions in the coalescent and are not appropriate for phylogenetic\nanalyses.\n\nThis algorithm is based on the make_tree algorithm from Richard Hudson 1990.\n\nHudson, R. R. 1990. Gene genealogies and the coalescent\n       process. Pp. 1-44 in D. Futuyma and J.  Antonovics, eds. Oxford\n       surveys in evolutionary biology. Vol. 7. Oxford University\n       Press, New York\n\nSanderson, M ... \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, E<lt>matthew.hahn@duke.eduE<gt>\nMike Sanderson \n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::RandomFactory;\nuse vars qw($PRECISION_DIGITS $DefaultNodeType %Defaults);\nuse strict;\n\n$PRECISION_DIGITS = 3; # Precision for the branchlength\n$DefaultNodeType = 'Bio::Tree::Node';\n%Defaults = ('YuleRate'          => 1.0, # as set by Sanderson in Rates\n\t     'Speciation'        => 1.0, #\n\t     'DefaultTreeMethod' => 'yule',\n\t     );\n\nuse Bio::Tools::RandomDistFunctions;\nuse Bio::Tree::Tree;\n\nuse base qw(Bio::Root::Root Bio::Factory::TreeFactoryI);\n\n=head2 new\n\n Title   : new\n Usage   : my $factory = Bio::Tree::RandomFactory->new(-samples => \\@samples,\n\t\t\t\t\t\t      -maxcount=> $N);\n Function: Initializes a Bio::Tree::RandomFactory object\n Returns : Bio::Tree::RandomFactory\n Args    : -nodetype => Type of Nodes to create [default Bio::Tree::Node]\n           -maxcount => [optional] Maximum num trees to create\n           -randtype => Type of random trees so far support\n               - yule/backward_yule/BY [default]\n               - forward_yule/FY\n               - birthdeath_forward/BDF\n               - birthdeath_backwards/BDB\n\n\n          ONE of the following must be specified\n           -taxa     => $arrayref of taxa names\n           -num_taxa => integer indicating number of taxa in the tree\n\n\nsub new{\n   my ($class,@args) = @_;\n   my $self = $class->SUPER::new(@args);\n   \n   $self->{'_treecounter'} = 0;\n   $self->{'_maxcount'} = 0;\n   my ($nodetype,$randtype,\n       $maxcount, $samps,$samplesize,\n       $taxa, $num_taxa) = $self->_rearrange([qw(NODETYPE\n\t\t\t\t\t\t RANDTYPE\n\t\t\t\t\t\t MAXCOUNT\n\t\t\t\t\t\t SAMPLES\n\t\t\t\t\t\t SAMPLE_SIZE\n\t\t\t\t\t\t TAXA\n\t\t\t\t\t\t NUM_TAXA)],\n\t\t\t\t\t     @args);\n   my @taxa;\n   $nodetype ||= $DefaultNodeType;\n   $self->nodetype($nodetype);\n   $taxa = $samps if defined $samps && ! defined $taxa;\n   $num_taxa = $samplesize if $samplesize && ! $num_taxa;\n   if( ! defined $taxa ) { \n       if( ! defined $num_taxa || $num_taxa <= 0 ) { \n\t   $self->throw(\"Must specify a valid num_taxa if parameter -TAXA is not specified\");\n       }\n       foreach ( 1..$num_taxa ) { push @taxa, \"Taxon$_\"; }      \n   } else { \n       if( ref($taxa) !~ /ARRAY/i ) { \n\t   $self->throw(\"Must specify a valid ARRAY reference to the parameter -TAXA, did you forget a leading '\\\\'? for $taxa\");\n       }\n       @taxa = @$taxa;\n   }\n   \n   $self->taxa(\\@taxa);\n   defined $maxcount && $self->maxcount($maxcount);   \n   $self->{'_count'} = 0;\n   return $self;\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $factory->next_tree\n Function: Returns a random tree based on the initialized number of nodes\n           NOTE: if maxcount is not specified on initialization or\n                 set to a valid integer, subsequent calls to next_tree will \n                 continue to return random trees and never return undef\n\n Returns : Bio::Tree::TreeI object\n Args    : none","label":"next_tree($self,%options)"},"children":[{"line":198,"localvar":"my","kind":13,"containerName":"next_tree","name":"$self","definition":"my"},{"line":198,"name":"%options","containerName":"next_tree","kind":13},{"containerName":"next_tree","kind":13,"name":"$self","line":199},{"name":"maxcount","kind":12,"containerName":"next_tree","line":199},{"containerName":"next_tree","kind":13,"name":"$self","line":200},{"line":200,"kind":13,"containerName":"next_tree","name":"$self"},{"line":200,"name":"maxcount","kind":12,"containerName":"next_tree"},{"kind":13,"localvar":"my","containerName":"next_tree","name":"$rand_type","line":201,"definition":"my"},{"line":201,"name":"$options","kind":13,"containerName":"next_tree"},{"kind":13,"containerName":"next_tree","name":"$self","line":201},{"containerName":"next_tree","kind":12,"name":"random_tree_method","line":201},{"name":"$nodetype","kind":13,"localvar":"my","containerName":"next_tree","line":202,"definition":"my"},{"line":202,"kind":13,"containerName":"next_tree","name":"$self"},{"kind":12,"containerName":"next_tree","name":"nodetype","line":202},{"definition":"my","line":203,"localvar":"my","kind":13,"containerName":"next_tree","name":"$treearray"},{"line":205,"kind":13,"containerName":"next_tree","name":"$rand_type"},{"line":207,"containerName":"next_tree","kind":13,"name":"$rand_type"},{"line":208,"containerName":"next_tree","kind":13,"name":"$treearray"},{"containerName":"next_tree","kind":13,"name":"$self","line":208},{"line":208,"kind":12,"containerName":"next_tree","name":"rand_birthdeath_backwards_tree"},{"line":209,"name":"$rand_type","kind":13,"containerName":"next_tree"},{"line":210,"containerName":"next_tree","kind":13,"name":"$rand_type"},{"definition":"my","kind":13,"localvar":"my","containerName":"next_tree","name":"$speciation","line":211},{"line":211,"name":"$options","containerName":"next_tree","kind":13},{"line":212,"name":"$treearray","containerName":"next_tree","kind":13},{"name":"$self","containerName":"next_tree","kind":13,"line":212},{"name":"rand_yule_c_tree","containerName":"next_tree","kind":12,"line":212},{"name":"$speciation","containerName":"next_tree","kind":13,"line":212},{"line":214,"name":"$self","kind":13,"containerName":"next_tree"},{"line":214,"containerName":"next_tree","kind":12,"name":"warn"},{"definition":"my","kind":13,"localvar":"my","containerName":"next_tree","name":"@nodes","line":217},{"line":218,"name":"$n","containerName":"next_tree","localvar":"my","kind":13,"definition":"my"},{"containerName":"next_tree","kind":13,"name":"$treearray","line":218},{"name":"$k","containerName":"next_tree","localvar":"my","kind":13,"line":219,"definition":"my"},{"name":"$n","kind":13,"containerName":"next_tree","line":220},{"line":220,"containerName":"next_tree","kind":13,"name":"$k"},{"line":221,"containerName":"next_tree","kind":13,"name":"$n"},{"name":"$nodes","containerName":"next_tree","kind":13,"line":221},{"line":221,"name":"$n","kind":13,"containerName":"next_tree"},{"name":"$k","kind":13,"containerName":"next_tree","line":221},{"line":223,"containerName":"next_tree","kind":13,"name":"@nodes"},{"containerName":"next_tree","kind":13,"name":"$nodetype","line":224},{"line":224,"name":"new","containerName":"next_tree","kind":12},{"line":224,"containerName":"next_tree","kind":13,"name":"$n"},{"line":225,"name":"$n","containerName":"next_tree","kind":13},{"line":226,"name":"$n","kind":13,"containerName":"next_tree"}],"name":"next_tree","containerName":"main::","definition":"sub","detail":"($self,%options)"},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"$T","line":229},{"line":229,"name":"Bio","kind":12,"containerName":"Tree::Tree"},{"line":229,"kind":12,"containerName":"main::","name":"new"},{"containerName":null,"kind":13,"name":"@nodes","line":229},{"kind":13,"containerName":null,"name":"$T","line":230},{"signature":{"documentation":"1;\n# $Id: RandomFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::RandomFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::RandomFactory - TreeFactory for generating Random Trees\n\n=head1 SYNOPSIS\n\n  use Bio::Tree::RandomFactory\n  my @taxonnames;\n  my $factory = Bio::Tree::RandomFactory->new( -taxa => \\@taxonnames,\n  \t\t\t\t\t      -maxcount => 10);\n\n  # or for anonymous samples\n\n  my $factory = Bio::Tree::RandomFactory->new( -num_taxa => 6,\n\t\t\t\t\t      -maxcount => 50);\n\n\n  my $tree = $factory->next_tree;\n\n=head1 DESCRIPTION\n\nBuilds a random tree every time next_tree is called or up to -maxcount times.\n\nThis module was originally written for Coalescent simulations see\nL<Bio::PopGen::Simulation::Coalescent>.  I've left the next_tree\nmethod intact although it is not generating random trees in the\nphylogenetic sense.  I would be happy for someone to provide\nalternative implementations which can be used here.  As written it\nwill generate random topologies but the branch lengths are built from\nassumptions in the coalescent and are not appropriate for phylogenetic\nanalyses.\n\nThis algorithm is based on the make_tree algorithm from Richard Hudson 1990.\n\nHudson, R. R. 1990. Gene genealogies and the coalescent\n       process. Pp. 1-44 in D. Futuyma and J.  Antonovics, eds. Oxford\n       surveys in evolutionary biology. Vol. 7. Oxford University\n       Press, New York\n\nSanderson, M ... \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, E<lt>matthew.hahn@duke.eduE<gt>\nMike Sanderson \n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::RandomFactory;\nuse vars qw($PRECISION_DIGITS $DefaultNodeType %Defaults);\nuse strict;\n\n$PRECISION_DIGITS = 3; # Precision for the branchlength\n$DefaultNodeType = 'Bio::Tree::Node';\n%Defaults = ('YuleRate'          => 1.0, # as set by Sanderson in Rates\n\t     'Speciation'        => 1.0, #\n\t     'DefaultTreeMethod' => 'yule',\n\t     );\n\nuse Bio::Tools::RandomDistFunctions;\nuse Bio::Tree::Tree;\n\nuse base qw(Bio::Root::Root Bio::Factory::TreeFactoryI);\n\n=head2 new\n\n Title   : new\n Usage   : my $factory = Bio::Tree::RandomFactory->new(-samples => \\@samples,\n\t\t\t\t\t\t      -maxcount=> $N);\n Function: Initializes a Bio::Tree::RandomFactory object\n Returns : Bio::Tree::RandomFactory\n Args    : -nodetype => Type of Nodes to create [default Bio::Tree::Node]\n           -maxcount => [optional] Maximum num trees to create\n           -randtype => Type of random trees so far support\n               - yule/backward_yule/BY [default]\n               - forward_yule/FY\n               - birthdeath_forward/BDF\n               - birthdeath_backwards/BDB\n\n\n          ONE of the following must be specified\n           -taxa     => $arrayref of taxa names\n           -num_taxa => integer indicating number of taxa in the tree\n\n\nsub new{\n   my ($class,@args) = @_;\n   my $self = $class->SUPER::new(@args);\n   \n   $self->{'_treecounter'} = 0;\n   $self->{'_maxcount'} = 0;\n   my ($nodetype,$randtype,\n       $maxcount, $samps,$samplesize,\n       $taxa, $num_taxa) = $self->_rearrange([qw(NODETYPE\n\t\t\t\t\t\t RANDTYPE\n\t\t\t\t\t\t MAXCOUNT\n\t\t\t\t\t\t SAMPLES\n\t\t\t\t\t\t SAMPLE_SIZE\n\t\t\t\t\t\t TAXA\n\t\t\t\t\t\t NUM_TAXA)],\n\t\t\t\t\t     @args);\n   my @taxa;\n   $nodetype ||= $DefaultNodeType;\n   $self->nodetype($nodetype);\n   $taxa = $samps if defined $samps && ! defined $taxa;\n   $num_taxa = $samplesize if $samplesize && ! $num_taxa;\n   if( ! defined $taxa ) { \n       if( ! defined $num_taxa || $num_taxa <= 0 ) { \n\t   $self->throw(\"Must specify a valid num_taxa if parameter -TAXA is not specified\");\n       }\n       foreach ( 1..$num_taxa ) { push @taxa, \"Taxon$_\"; }      \n   } else { \n       if( ref($taxa) !~ /ARRAY/i ) { \n\t   $self->throw(\"Must specify a valid ARRAY reference to the parameter -TAXA, did you forget a leading '\\\\'? for $taxa\");\n       }\n       @taxa = @$taxa;\n   }\n   \n   $self->taxa(\\@taxa);\n   defined $maxcount && $self->maxcount($maxcount);   \n   $self->{'_count'} = 0;\n   return $self;\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $factory->next_tree\n Function: Returns a random tree based on the initialized number of nodes\n           NOTE: if maxcount is not specified on initialization or\n                 set to a valid integer, subsequent calls to next_tree will \n                 continue to return random trees and never return undef\n\n Returns : Bio::Tree::TreeI object\n Args    : none\n\n\n\nsub next_tree{\n   my ($self,%options) = @_;\n   return if $self->maxcount && \n       $self->{'_count'}++ >= $self->maxcount;\n   my $rand_type = $options{'randtype'} || $self->random_tree_method;\n   my $nodetype = $self->nodetype;\n   my $treearray;\n\n   if( $rand_type =~ /(birthdeath_forward|birth|BDF)/i ) {\n\n   } elsif ( $rand_type =~ /(birthdeath_backward|BDB)/i ) {\n       $treearray = $self->rand_birthdeath_backwards_tree;       \n   } elsif( $rand_type =~ /(BY|backwards_yule)/i || \n\t    $rand_type =~ /^yule/i ) {\n       my $speciation = $options{'speciation'}; # can be undef\n       $treearray = $self->rand_yule_c_tree($speciation);       \n   } else { \n       $self->warn(\"unrecognized random type $rand_type\");\n   }\n   \n   my @nodes = ();   \n   foreach my $n ( @$treearray ) { \n       for my $k ( qw(desc1 desc2) ) {\n\t   next unless defined $n->{$k};\n\t   push @{$n->{'descendents'}}, $nodes[$n->{$k}];\n       }\n       push @nodes, \n       $nodetype->new(-id            => $n->{'nodenum'},\n\t\t      -branch_length => $n->{'time'},\n\t\t      -descendents   => $n->{'descendents'},\n\t\t      );\n   }\n   my $T = Bio::Tree::Tree->new(-root => pop @nodes );\n   return $T;\n}\n\n\n=head2 maxcount\n\n Title   : maxcount\n Usage   : $obj->maxcount($newval)\n Function: \n Returns : Maxcount value\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"maxcount($self,$value)"},"kind":12,"range":{"start":{"line":245,"character":0},"end":{"character":9999,"line":256}},"line":245,"detail":"($self,$value)","definition":"sub","name":"maxcount","containerName":"main::","children":[{"definition":"my","line":246,"name":"$self","localvar":"my","containerName":"maxcount","kind":13},{"line":246,"kind":13,"containerName":"maxcount","name":"$value"},{"line":247,"containerName":"maxcount","kind":13,"name":"$value"},{"kind":13,"containerName":"maxcount","name":"$value","line":248},{"kind":13,"containerName":"maxcount","name":"$self","line":249},{"line":251,"name":"$self","kind":13,"containerName":"maxcount"},{"line":251,"name":"warn","kind":12,"containerName":"maxcount"},{"name":"$self","kind":13,"containerName":"maxcount","line":252},{"kind":13,"containerName":"maxcount","name":"$self","line":255}]},{"line":270,"range":{"end":{"character":9999,"line":272},"start":{"line":270,"character":0}},"kind":12,"children":[],"containerName":"main::","name":"reset_count","definition":"sub"},{"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: RandomFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::RandomFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::RandomFactory - TreeFactory for generating Random Trees\n\n=head1 SYNOPSIS\n\n  use Bio::Tree::RandomFactory\n  my @taxonnames;\n  my $factory = Bio::Tree::RandomFactory->new( -taxa => \\@taxonnames,\n  \t\t\t\t\t      -maxcount => 10);\n\n  # or for anonymous samples\n\n  my $factory = Bio::Tree::RandomFactory->new( -num_taxa => 6,\n\t\t\t\t\t      -maxcount => 50);\n\n\n  my $tree = $factory->next_tree;\n\n=head1 DESCRIPTION\n\nBuilds a random tree every time next_tree is called or up to -maxcount times.\n\nThis module was originally written for Coalescent simulations see\nL<Bio::PopGen::Simulation::Coalescent>.  I've left the next_tree\nmethod intact although it is not generating random trees in the\nphylogenetic sense.  I would be happy for someone to provide\nalternative implementations which can be used here.  As written it\nwill generate random topologies but the branch lengths are built from\nassumptions in the coalescent and are not appropriate for phylogenetic\nanalyses.\n\nThis algorithm is based on the make_tree algorithm from Richard Hudson 1990.\n\nHudson, R. R. 1990. Gene genealogies and the coalescent\n       process. Pp. 1-44 in D. Futuyma and J.  Antonovics, eds. Oxford\n       surveys in evolutionary biology. Vol. 7. Oxford University\n       Press, New York\n\nSanderson, M ... \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, E<lt>matthew.hahn@duke.eduE<gt>\nMike Sanderson \n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::RandomFactory;\nuse vars qw($PRECISION_DIGITS $DefaultNodeType %Defaults);\nuse strict;\n\n$PRECISION_DIGITS = 3; # Precision for the branchlength\n$DefaultNodeType = 'Bio::Tree::Node';\n%Defaults = ('YuleRate'          => 1.0, # as set by Sanderson in Rates\n\t     'Speciation'        => 1.0, #\n\t     'DefaultTreeMethod' => 'yule',\n\t     );\n\nuse Bio::Tools::RandomDistFunctions;\nuse Bio::Tree::Tree;\n\nuse base qw(Bio::Root::Root Bio::Factory::TreeFactoryI);\n\n=head2 new\n\n Title   : new\n Usage   : my $factory = Bio::Tree::RandomFactory->new(-samples => \\@samples,\n\t\t\t\t\t\t      -maxcount=> $N);\n Function: Initializes a Bio::Tree::RandomFactory object\n Returns : Bio::Tree::RandomFactory\n Args    : -nodetype => Type of Nodes to create [default Bio::Tree::Node]\n           -maxcount => [optional] Maximum num trees to create\n           -randtype => Type of random trees so far support\n               - yule/backward_yule/BY [default]\n               - forward_yule/FY\n               - birthdeath_forward/BDF\n               - birthdeath_backwards/BDB\n\n\n          ONE of the following must be specified\n           -taxa     => $arrayref of taxa names\n           -num_taxa => integer indicating number of taxa in the tree\n\n\nsub new{\n   my ($class,@args) = @_;\n   my $self = $class->SUPER::new(@args);\n   \n   $self->{'_treecounter'} = 0;\n   $self->{'_maxcount'} = 0;\n   my ($nodetype,$randtype,\n       $maxcount, $samps,$samplesize,\n       $taxa, $num_taxa) = $self->_rearrange([qw(NODETYPE\n\t\t\t\t\t\t RANDTYPE\n\t\t\t\t\t\t MAXCOUNT\n\t\t\t\t\t\t SAMPLES\n\t\t\t\t\t\t SAMPLE_SIZE\n\t\t\t\t\t\t TAXA\n\t\t\t\t\t\t NUM_TAXA)],\n\t\t\t\t\t     @args);\n   my @taxa;\n   $nodetype ||= $DefaultNodeType;\n   $self->nodetype($nodetype);\n   $taxa = $samps if defined $samps && ! defined $taxa;\n   $num_taxa = $samplesize if $samplesize && ! $num_taxa;\n   if( ! defined $taxa ) { \n       if( ! defined $num_taxa || $num_taxa <= 0 ) { \n\t   $self->throw(\"Must specify a valid num_taxa if parameter -TAXA is not specified\");\n       }\n       foreach ( 1..$num_taxa ) { push @taxa, \"Taxon$_\"; }      \n   } else { \n       if( ref($taxa) !~ /ARRAY/i ) { \n\t   $self->throw(\"Must specify a valid ARRAY reference to the parameter -TAXA, did you forget a leading '\\\\'? for $taxa\");\n       }\n       @taxa = @$taxa;\n   }\n   \n   $self->taxa(\\@taxa);\n   defined $maxcount && $self->maxcount($maxcount);   \n   $self->{'_count'} = 0;\n   return $self;\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $factory->next_tree\n Function: Returns a random tree based on the initialized number of nodes\n           NOTE: if maxcount is not specified on initialization or\n                 set to a valid integer, subsequent calls to next_tree will \n                 continue to return random trees and never return undef\n\n Returns : Bio::Tree::TreeI object\n Args    : none\n\n\n\nsub next_tree{\n   my ($self,%options) = @_;\n   return if $self->maxcount && \n       $self->{'_count'}++ >= $self->maxcount;\n   my $rand_type = $options{'randtype'} || $self->random_tree_method;\n   my $nodetype = $self->nodetype;\n   my $treearray;\n\n   if( $rand_type =~ /(birthdeath_forward|birth|BDF)/i ) {\n\n   } elsif ( $rand_type =~ /(birthdeath_backward|BDB)/i ) {\n       $treearray = $self->rand_birthdeath_backwards_tree;       \n   } elsif( $rand_type =~ /(BY|backwards_yule)/i || \n\t    $rand_type =~ /^yule/i ) {\n       my $speciation = $options{'speciation'}; # can be undef\n       $treearray = $self->rand_yule_c_tree($speciation);       \n   } else { \n       $self->warn(\"unrecognized random type $rand_type\");\n   }\n   \n   my @nodes = ();   \n   foreach my $n ( @$treearray ) { \n       for my $k ( qw(desc1 desc2) ) {\n\t   next unless defined $n->{$k};\n\t   push @{$n->{'descendents'}}, $nodes[$n->{$k}];\n       }\n       push @nodes, \n       $nodetype->new(-id            => $n->{'nodenum'},\n\t\t      -branch_length => $n->{'time'},\n\t\t      -descendents   => $n->{'descendents'},\n\t\t      );\n   }\n   my $T = Bio::Tree::Tree->new(-root => pop @nodes );\n   return $T;\n}\n\n\n=head2 maxcount\n\n Title   : maxcount\n Usage   : $obj->maxcount($newval)\n Function: \n Returns : Maxcount value\n Args    : newvalue (optional)\n\n\n\nsub maxcount{\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if( $value =~ /^(\\d+)/ ) { \n\t   $self->{'_maxcount'} = $1;\n       } else { \n\t   $self->warn(\"Must specify a valid Positive integer to maxcount\");\n\t   $self->{'_maxcount'} = 0;\n       }\n  }\n   return $self->{'_maxcount'};\n}\n\n\n=head2 reset_tree_count\n\n Title   : reset_tree_count\n Usage   : $factory->reset_tree_count;\n Function: Reset the tree counter\n Returns : none\n Args    : none\n\n\n\nsub reset_count{\n    shift->{'_count'} = 0;\n}\n\n=head2 taxa\n\n Title   : taxa\n Usage   : $obj->taxa($newval)\n Function: Set the leaf node names\n Returns : value of taxa\n Args    : Arrayref of Taxon names","label":"taxa($self,$value)"},"range":{"start":{"line":285,"character":0},"end":{"line":297,"character":9999}},"kind":12,"line":285,"detail":"($self,$value)","definition":"sub","name":"taxa","containerName":"main::","children":[{"line":286,"localvar":"my","kind":13,"containerName":"taxa","name":"$self","definition":"my"},{"name":"$value","containerName":"taxa","kind":13,"line":286},{"line":287,"name":"$value","kind":13,"containerName":"taxa"},{"line":288,"name":"$value","kind":13,"containerName":"taxa"},{"name":"$self","containerName":"taxa","kind":13,"line":289},{"line":289,"containerName":"taxa","kind":12,"name":"warn"},{"line":290,"name":"$value","containerName":"taxa","kind":13},{"name":"$self","containerName":"taxa","kind":13,"line":292},{"line":292,"name":"$value","containerName":"taxa","kind":13},{"line":293,"name":"$self","kind":13,"containerName":"taxa"},{"kind":13,"containerName":"taxa","name":"$value","line":293},{"kind":13,"containerName":"taxa","name":"$self","line":295}]},{"children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"num_taxa","line":311},{"kind":13,"containerName":"num_taxa","name":"$self","line":312}],"name":"num_taxa","containerName":"main::","definition":"sub","detail":"($self)","line":310,"kind":12,"range":{"start":{"line":310,"character":0},"end":{"line":313,"character":9999}},"signature":{"documentation":"1;\n# $Id: RandomFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::RandomFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::RandomFactory - TreeFactory for generating Random Trees\n\n=head1 SYNOPSIS\n\n  use Bio::Tree::RandomFactory\n  my @taxonnames;\n  my $factory = Bio::Tree::RandomFactory->new( -taxa => \\@taxonnames,\n  \t\t\t\t\t      -maxcount => 10);\n\n  # or for anonymous samples\n\n  my $factory = Bio::Tree::RandomFactory->new( -num_taxa => 6,\n\t\t\t\t\t      -maxcount => 50);\n\n\n  my $tree = $factory->next_tree;\n\n=head1 DESCRIPTION\n\nBuilds a random tree every time next_tree is called or up to -maxcount times.\n\nThis module was originally written for Coalescent simulations see\nL<Bio::PopGen::Simulation::Coalescent>.  I've left the next_tree\nmethod intact although it is not generating random trees in the\nphylogenetic sense.  I would be happy for someone to provide\nalternative implementations which can be used here.  As written it\nwill generate random topologies but the branch lengths are built from\nassumptions in the coalescent and are not appropriate for phylogenetic\nanalyses.\n\nThis algorithm is based on the make_tree algorithm from Richard Hudson 1990.\n\nHudson, R. R. 1990. Gene genealogies and the coalescent\n       process. Pp. 1-44 in D. Futuyma and J.  Antonovics, eds. Oxford\n       surveys in evolutionary biology. Vol. 7. Oxford University\n       Press, New York\n\nSanderson, M ... \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, E<lt>matthew.hahn@duke.eduE<gt>\nMike Sanderson \n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::RandomFactory;\nuse vars qw($PRECISION_DIGITS $DefaultNodeType %Defaults);\nuse strict;\n\n$PRECISION_DIGITS = 3; # Precision for the branchlength\n$DefaultNodeType = 'Bio::Tree::Node';\n%Defaults = ('YuleRate'          => 1.0, # as set by Sanderson in Rates\n\t     'Speciation'        => 1.0, #\n\t     'DefaultTreeMethod' => 'yule',\n\t     );\n\nuse Bio::Tools::RandomDistFunctions;\nuse Bio::Tree::Tree;\n\nuse base qw(Bio::Root::Root Bio::Factory::TreeFactoryI);\n\n=head2 new\n\n Title   : new\n Usage   : my $factory = Bio::Tree::RandomFactory->new(-samples => \\@samples,\n\t\t\t\t\t\t      -maxcount=> $N);\n Function: Initializes a Bio::Tree::RandomFactory object\n Returns : Bio::Tree::RandomFactory\n Args    : -nodetype => Type of Nodes to create [default Bio::Tree::Node]\n           -maxcount => [optional] Maximum num trees to create\n           -randtype => Type of random trees so far support\n               - yule/backward_yule/BY [default]\n               - forward_yule/FY\n               - birthdeath_forward/BDF\n               - birthdeath_backwards/BDB\n\n\n          ONE of the following must be specified\n           -taxa     => $arrayref of taxa names\n           -num_taxa => integer indicating number of taxa in the tree\n\n\nsub new{\n   my ($class,@args) = @_;\n   my $self = $class->SUPER::new(@args);\n   \n   $self->{'_treecounter'} = 0;\n   $self->{'_maxcount'} = 0;\n   my ($nodetype,$randtype,\n       $maxcount, $samps,$samplesize,\n       $taxa, $num_taxa) = $self->_rearrange([qw(NODETYPE\n\t\t\t\t\t\t RANDTYPE\n\t\t\t\t\t\t MAXCOUNT\n\t\t\t\t\t\t SAMPLES\n\t\t\t\t\t\t SAMPLE_SIZE\n\t\t\t\t\t\t TAXA\n\t\t\t\t\t\t NUM_TAXA)],\n\t\t\t\t\t     @args);\n   my @taxa;\n   $nodetype ||= $DefaultNodeType;\n   $self->nodetype($nodetype);\n   $taxa = $samps if defined $samps && ! defined $taxa;\n   $num_taxa = $samplesize if $samplesize && ! $num_taxa;\n   if( ! defined $taxa ) { \n       if( ! defined $num_taxa || $num_taxa <= 0 ) { \n\t   $self->throw(\"Must specify a valid num_taxa if parameter -TAXA is not specified\");\n       }\n       foreach ( 1..$num_taxa ) { push @taxa, \"Taxon$_\"; }      \n   } else { \n       if( ref($taxa) !~ /ARRAY/i ) { \n\t   $self->throw(\"Must specify a valid ARRAY reference to the parameter -TAXA, did you forget a leading '\\\\'? for $taxa\");\n       }\n       @taxa = @$taxa;\n   }\n   \n   $self->taxa(\\@taxa);\n   defined $maxcount && $self->maxcount($maxcount);   \n   $self->{'_count'} = 0;\n   return $self;\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $factory->next_tree\n Function: Returns a random tree based on the initialized number of nodes\n           NOTE: if maxcount is not specified on initialization or\n                 set to a valid integer, subsequent calls to next_tree will \n                 continue to return random trees and never return undef\n\n Returns : Bio::Tree::TreeI object\n Args    : none\n\n\n\nsub next_tree{\n   my ($self,%options) = @_;\n   return if $self->maxcount && \n       $self->{'_count'}++ >= $self->maxcount;\n   my $rand_type = $options{'randtype'} || $self->random_tree_method;\n   my $nodetype = $self->nodetype;\n   my $treearray;\n\n   if( $rand_type =~ /(birthdeath_forward|birth|BDF)/i ) {\n\n   } elsif ( $rand_type =~ /(birthdeath_backward|BDB)/i ) {\n       $treearray = $self->rand_birthdeath_backwards_tree;       \n   } elsif( $rand_type =~ /(BY|backwards_yule)/i || \n\t    $rand_type =~ /^yule/i ) {\n       my $speciation = $options{'speciation'}; # can be undef\n       $treearray = $self->rand_yule_c_tree($speciation);       \n   } else { \n       $self->warn(\"unrecognized random type $rand_type\");\n   }\n   \n   my @nodes = ();   \n   foreach my $n ( @$treearray ) { \n       for my $k ( qw(desc1 desc2) ) {\n\t   next unless defined $n->{$k};\n\t   push @{$n->{'descendents'}}, $nodes[$n->{$k}];\n       }\n       push @nodes, \n       $nodetype->new(-id            => $n->{'nodenum'},\n\t\t      -branch_length => $n->{'time'},\n\t\t      -descendents   => $n->{'descendents'},\n\t\t      );\n   }\n   my $T = Bio::Tree::Tree->new(-root => pop @nodes );\n   return $T;\n}\n\n\n=head2 maxcount\n\n Title   : maxcount\n Usage   : $obj->maxcount($newval)\n Function: \n Returns : Maxcount value\n Args    : newvalue (optional)\n\n\n\nsub maxcount{\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if( $value =~ /^(\\d+)/ ) { \n\t   $self->{'_maxcount'} = $1;\n       } else { \n\t   $self->warn(\"Must specify a valid Positive integer to maxcount\");\n\t   $self->{'_maxcount'} = 0;\n       }\n  }\n   return $self->{'_maxcount'};\n}\n\n\n=head2 reset_tree_count\n\n Title   : reset_tree_count\n Usage   : $factory->reset_tree_count;\n Function: Reset the tree counter\n Returns : none\n Args    : none\n\n\n\nsub reset_count{\n    shift->{'_count'} = 0;\n}\n\n=head2 taxa\n\n Title   : taxa\n Usage   : $obj->taxa($newval)\n Function: Set the leaf node names\n Returns : value of taxa\n Args    : Arrayref of Taxon names\n\n\n\nsub taxa {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif( ref($value) !~ /ARRAY/i ) { \n\t    $self->warn(\"Must specify a valid array ref to the method 'taxa'\");\n\t    $value = [];\n\t} \n\t$self->{'_taxa'} = $value;\n\t$self->{'_num_taxa'} = scalar @$value;\n    }\n    return $self->{'_taxa'};\n\n}\n\n=head2 num_taxa\n\n Title   : num_taxa\n Usage   : $obj->num_taxa($newval)\n Function: Get the number of Taxa\n Returns : value of num_taxa\n Args    : none","parameters":[{"label":"$self"}],"label":"num_taxa($self)"}},{"signature":{"documentation":"1;\n# $Id: RandomFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::RandomFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::RandomFactory - TreeFactory for generating Random Trees\n\n=head1 SYNOPSIS\n\n  use Bio::Tree::RandomFactory\n  my @taxonnames;\n  my $factory = Bio::Tree::RandomFactory->new( -taxa => \\@taxonnames,\n  \t\t\t\t\t      -maxcount => 10);\n\n  # or for anonymous samples\n\n  my $factory = Bio::Tree::RandomFactory->new( -num_taxa => 6,\n\t\t\t\t\t      -maxcount => 50);\n\n\n  my $tree = $factory->next_tree;\n\n=head1 DESCRIPTION\n\nBuilds a random tree every time next_tree is called or up to -maxcount times.\n\nThis module was originally written for Coalescent simulations see\nL<Bio::PopGen::Simulation::Coalescent>.  I've left the next_tree\nmethod intact although it is not generating random trees in the\nphylogenetic sense.  I would be happy for someone to provide\nalternative implementations which can be used here.  As written it\nwill generate random topologies but the branch lengths are built from\nassumptions in the coalescent and are not appropriate for phylogenetic\nanalyses.\n\nThis algorithm is based on the make_tree algorithm from Richard Hudson 1990.\n\nHudson, R. R. 1990. Gene genealogies and the coalescent\n       process. Pp. 1-44 in D. Futuyma and J.  Antonovics, eds. Oxford\n       surveys in evolutionary biology. Vol. 7. Oxford University\n       Press, New York\n\nSanderson, M ... \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, E<lt>matthew.hahn@duke.eduE<gt>\nMike Sanderson \n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::RandomFactory;\nuse vars qw($PRECISION_DIGITS $DefaultNodeType %Defaults);\nuse strict;\n\n$PRECISION_DIGITS = 3; # Precision for the branchlength\n$DefaultNodeType = 'Bio::Tree::Node';\n%Defaults = ('YuleRate'          => 1.0, # as set by Sanderson in Rates\n\t     'Speciation'        => 1.0, #\n\t     'DefaultTreeMethod' => 'yule',\n\t     );\n\nuse Bio::Tools::RandomDistFunctions;\nuse Bio::Tree::Tree;\n\nuse base qw(Bio::Root::Root Bio::Factory::TreeFactoryI);\n\n=head2 new\n\n Title   : new\n Usage   : my $factory = Bio::Tree::RandomFactory->new(-samples => \\@samples,\n\t\t\t\t\t\t      -maxcount=> $N);\n Function: Initializes a Bio::Tree::RandomFactory object\n Returns : Bio::Tree::RandomFactory\n Args    : -nodetype => Type of Nodes to create [default Bio::Tree::Node]\n           -maxcount => [optional] Maximum num trees to create\n           -randtype => Type of random trees so far support\n               - yule/backward_yule/BY [default]\n               - forward_yule/FY\n               - birthdeath_forward/BDF\n               - birthdeath_backwards/BDB\n\n\n          ONE of the following must be specified\n           -taxa     => $arrayref of taxa names\n           -num_taxa => integer indicating number of taxa in the tree\n\n\nsub new{\n   my ($class,@args) = @_;\n   my $self = $class->SUPER::new(@args);\n   \n   $self->{'_treecounter'} = 0;\n   $self->{'_maxcount'} = 0;\n   my ($nodetype,$randtype,\n       $maxcount, $samps,$samplesize,\n       $taxa, $num_taxa) = $self->_rearrange([qw(NODETYPE\n\t\t\t\t\t\t RANDTYPE\n\t\t\t\t\t\t MAXCOUNT\n\t\t\t\t\t\t SAMPLES\n\t\t\t\t\t\t SAMPLE_SIZE\n\t\t\t\t\t\t TAXA\n\t\t\t\t\t\t NUM_TAXA)],\n\t\t\t\t\t     @args);\n   my @taxa;\n   $nodetype ||= $DefaultNodeType;\n   $self->nodetype($nodetype);\n   $taxa = $samps if defined $samps && ! defined $taxa;\n   $num_taxa = $samplesize if $samplesize && ! $num_taxa;\n   if( ! defined $taxa ) { \n       if( ! defined $num_taxa || $num_taxa <= 0 ) { \n\t   $self->throw(\"Must specify a valid num_taxa if parameter -TAXA is not specified\");\n       }\n       foreach ( 1..$num_taxa ) { push @taxa, \"Taxon$_\"; }      \n   } else { \n       if( ref($taxa) !~ /ARRAY/i ) { \n\t   $self->throw(\"Must specify a valid ARRAY reference to the parameter -TAXA, did you forget a leading '\\\\'? for $taxa\");\n       }\n       @taxa = @$taxa;\n   }\n   \n   $self->taxa(\\@taxa);\n   defined $maxcount && $self->maxcount($maxcount);   \n   $self->{'_count'} = 0;\n   return $self;\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $factory->next_tree\n Function: Returns a random tree based on the initialized number of nodes\n           NOTE: if maxcount is not specified on initialization or\n                 set to a valid integer, subsequent calls to next_tree will \n                 continue to return random trees and never return undef\n\n Returns : Bio::Tree::TreeI object\n Args    : none\n\n\n\nsub next_tree{\n   my ($self,%options) = @_;\n   return if $self->maxcount && \n       $self->{'_count'}++ >= $self->maxcount;\n   my $rand_type = $options{'randtype'} || $self->random_tree_method;\n   my $nodetype = $self->nodetype;\n   my $treearray;\n\n   if( $rand_type =~ /(birthdeath_forward|birth|BDF)/i ) {\n\n   } elsif ( $rand_type =~ /(birthdeath_backward|BDB)/i ) {\n       $treearray = $self->rand_birthdeath_backwards_tree;       \n   } elsif( $rand_type =~ /(BY|backwards_yule)/i || \n\t    $rand_type =~ /^yule/i ) {\n       my $speciation = $options{'speciation'}; # can be undef\n       $treearray = $self->rand_yule_c_tree($speciation);       \n   } else { \n       $self->warn(\"unrecognized random type $rand_type\");\n   }\n   \n   my @nodes = ();   \n   foreach my $n ( @$treearray ) { \n       for my $k ( qw(desc1 desc2) ) {\n\t   next unless defined $n->{$k};\n\t   push @{$n->{'descendents'}}, $nodes[$n->{$k}];\n       }\n       push @nodes, \n       $nodetype->new(-id            => $n->{'nodenum'},\n\t\t      -branch_length => $n->{'time'},\n\t\t      -descendents   => $n->{'descendents'},\n\t\t      );\n   }\n   my $T = Bio::Tree::Tree->new(-root => pop @nodes );\n   return $T;\n}\n\n\n=head2 maxcount\n\n Title   : maxcount\n Usage   : $obj->maxcount($newval)\n Function: \n Returns : Maxcount value\n Args    : newvalue (optional)\n\n\n\nsub maxcount{\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if( $value =~ /^(\\d+)/ ) { \n\t   $self->{'_maxcount'} = $1;\n       } else { \n\t   $self->warn(\"Must specify a valid Positive integer to maxcount\");\n\t   $self->{'_maxcount'} = 0;\n       }\n  }\n   return $self->{'_maxcount'};\n}\n\n\n=head2 reset_tree_count\n\n Title   : reset_tree_count\n Usage   : $factory->reset_tree_count;\n Function: Reset the tree counter\n Returns : none\n Args    : none\n\n\n\nsub reset_count{\n    shift->{'_count'} = 0;\n}\n\n=head2 taxa\n\n Title   : taxa\n Usage   : $obj->taxa($newval)\n Function: Set the leaf node names\n Returns : value of taxa\n Args    : Arrayref of Taxon names\n\n\n\nsub taxa {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif( ref($value) !~ /ARRAY/i ) { \n\t    $self->warn(\"Must specify a valid array ref to the method 'taxa'\");\n\t    $value = [];\n\t} \n\t$self->{'_taxa'} = $value;\n\t$self->{'_num_taxa'} = scalar @$value;\n    }\n    return $self->{'_taxa'};\n\n}\n\n=head2 num_taxa\n\n Title   : num_taxa\n Usage   : $obj->num_taxa($newval)\n Function: Get the number of Taxa\n Returns : value of num_taxa\n Args    : none\n\n\n\nsub num_taxa {\n    my ($self) = @_;\n    return  $self->{'_num_taxa'};\n}\n\n# alias old methods\n*num_samples = \\&num_taxa;\n*samples = \\&taxa;\n\n=head2 random\n\n Title   : random\n Usage   : my $rfloat = $node->random($size)\n Function: Generates a random number between 0 and $size\n           This is abstracted so that someone can override and provide their\n           own special RNG.  This is expected to be a uniform RNG.\n Returns : Floating point random\n Args    : $maximum size for random number (defaults to 1)","parameters":[{"label":"$self"},{"label":"$max"}],"label":"random($self,$max)"},"line":332,"kind":12,"range":{"end":{"line":335,"character":9999},"start":{"character":0,"line":332}},"definition":"sub","detail":"($self,$max)","children":[{"containerName":"random","localvar":"my","kind":13,"name":"$self","line":333,"definition":"my"},{"line":333,"name":"$max","kind":13,"containerName":"random"},{"kind":13,"containerName":"random","name":"$max","line":334}],"containerName":"main::","name":"random"},{"line":350,"range":{"start":{"line":350,"character":0},"end":{"character":9999,"line":355}},"kind":12,"definition":"sub","children":[{"line":351,"name":"$self","kind":13,"localvar":"my","containerName":"random_tree_method","definition":"my"},{"line":353,"name":"$self","containerName":"random_tree_method","kind":13},{"name":"$self","containerName":"random_tree_method","kind":13,"line":354},{"containerName":"random_tree_method","kind":13,"name":"$Defaults","line":354}],"name":"random_tree_method","containerName":"main::"},{"signature":{"label":"nodetype($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: RandomFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::RandomFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::RandomFactory - TreeFactory for generating Random Trees\n\n=head1 SYNOPSIS\n\n  use Bio::Tree::RandomFactory\n  my @taxonnames;\n  my $factory = Bio::Tree::RandomFactory->new( -taxa => \\@taxonnames,\n  \t\t\t\t\t      -maxcount => 10);\n\n  # or for anonymous samples\n\n  my $factory = Bio::Tree::RandomFactory->new( -num_taxa => 6,\n\t\t\t\t\t      -maxcount => 50);\n\n\n  my $tree = $factory->next_tree;\n\n=head1 DESCRIPTION\n\nBuilds a random tree every time next_tree is called or up to -maxcount times.\n\nThis module was originally written for Coalescent simulations see\nL<Bio::PopGen::Simulation::Coalescent>.  I've left the next_tree\nmethod intact although it is not generating random trees in the\nphylogenetic sense.  I would be happy for someone to provide\nalternative implementations which can be used here.  As written it\nwill generate random topologies but the branch lengths are built from\nassumptions in the coalescent and are not appropriate for phylogenetic\nanalyses.\n\nThis algorithm is based on the make_tree algorithm from Richard Hudson 1990.\n\nHudson, R. R. 1990. Gene genealogies and the coalescent\n       process. Pp. 1-44 in D. Futuyma and J.  Antonovics, eds. Oxford\n       surveys in evolutionary biology. Vol. 7. Oxford University\n       Press, New York\n\nSanderson, M ... \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-AT-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, E<lt>matthew.hahn@duke.eduE<gt>\nMike Sanderson \n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::RandomFactory;\nuse vars qw($PRECISION_DIGITS $DefaultNodeType %Defaults);\nuse strict;\n\n$PRECISION_DIGITS = 3; # Precision for the branchlength\n$DefaultNodeType = 'Bio::Tree::Node';\n%Defaults = ('YuleRate'          => 1.0, # as set by Sanderson in Rates\n\t     'Speciation'        => 1.0, #\n\t     'DefaultTreeMethod' => 'yule',\n\t     );\n\nuse Bio::Tools::RandomDistFunctions;\nuse Bio::Tree::Tree;\n\nuse base qw(Bio::Root::Root Bio::Factory::TreeFactoryI);\n\n=head2 new\n\n Title   : new\n Usage   : my $factory = Bio::Tree::RandomFactory->new(-samples => \\@samples,\n\t\t\t\t\t\t      -maxcount=> $N);\n Function: Initializes a Bio::Tree::RandomFactory object\n Returns : Bio::Tree::RandomFactory\n Args    : -nodetype => Type of Nodes to create [default Bio::Tree::Node]\n           -maxcount => [optional] Maximum num trees to create\n           -randtype => Type of random trees so far support\n               - yule/backward_yule/BY [default]\n               - forward_yule/FY\n               - birthdeath_forward/BDF\n               - birthdeath_backwards/BDB\n\n\n          ONE of the following must be specified\n           -taxa     => $arrayref of taxa names\n           -num_taxa => integer indicating number of taxa in the tree\n\n\nsub new{\n   my ($class,@args) = @_;\n   my $self = $class->SUPER::new(@args);\n   \n   $self->{'_treecounter'} = 0;\n   $self->{'_maxcount'} = 0;\n   my ($nodetype,$randtype,\n       $maxcount, $samps,$samplesize,\n       $taxa, $num_taxa) = $self->_rearrange([qw(NODETYPE\n\t\t\t\t\t\t RANDTYPE\n\t\t\t\t\t\t MAXCOUNT\n\t\t\t\t\t\t SAMPLES\n\t\t\t\t\t\t SAMPLE_SIZE\n\t\t\t\t\t\t TAXA\n\t\t\t\t\t\t NUM_TAXA)],\n\t\t\t\t\t     @args);\n   my @taxa;\n   $nodetype ||= $DefaultNodeType;\n   $self->nodetype($nodetype);\n   $taxa = $samps if defined $samps && ! defined $taxa;\n   $num_taxa = $samplesize if $samplesize && ! $num_taxa;\n   if( ! defined $taxa ) { \n       if( ! defined $num_taxa || $num_taxa <= 0 ) { \n\t   $self->throw(\"Must specify a valid num_taxa if parameter -TAXA is not specified\");\n       }\n       foreach ( 1..$num_taxa ) { push @taxa, \"Taxon$_\"; }      \n   } else { \n       if( ref($taxa) !~ /ARRAY/i ) { \n\t   $self->throw(\"Must specify a valid ARRAY reference to the parameter -TAXA, did you forget a leading '\\\\'? for $taxa\");\n       }\n       @taxa = @$taxa;\n   }\n   \n   $self->taxa(\\@taxa);\n   defined $maxcount && $self->maxcount($maxcount);   \n   $self->{'_count'} = 0;\n   return $self;\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $factory->next_tree\n Function: Returns a random tree based on the initialized number of nodes\n           NOTE: if maxcount is not specified on initialization or\n                 set to a valid integer, subsequent calls to next_tree will \n                 continue to return random trees and never return undef\n\n Returns : Bio::Tree::TreeI object\n Args    : none\n\n\n\nsub next_tree{\n   my ($self,%options) = @_;\n   return if $self->maxcount && \n       $self->{'_count'}++ >= $self->maxcount;\n   my $rand_type = $options{'randtype'} || $self->random_tree_method;\n   my $nodetype = $self->nodetype;\n   my $treearray;\n\n   if( $rand_type =~ /(birthdeath_forward|birth|BDF)/i ) {\n\n   } elsif ( $rand_type =~ /(birthdeath_backward|BDB)/i ) {\n       $treearray = $self->rand_birthdeath_backwards_tree;       \n   } elsif( $rand_type =~ /(BY|backwards_yule)/i || \n\t    $rand_type =~ /^yule/i ) {\n       my $speciation = $options{'speciation'}; # can be undef\n       $treearray = $self->rand_yule_c_tree($speciation);       \n   } else { \n       $self->warn(\"unrecognized random type $rand_type\");\n   }\n   \n   my @nodes = ();   \n   foreach my $n ( @$treearray ) { \n       for my $k ( qw(desc1 desc2) ) {\n\t   next unless defined $n->{$k};\n\t   push @{$n->{'descendents'}}, $nodes[$n->{$k}];\n       }\n       push @nodes, \n       $nodetype->new(-id            => $n->{'nodenum'},\n\t\t      -branch_length => $n->{'time'},\n\t\t      -descendents   => $n->{'descendents'},\n\t\t      );\n   }\n   my $T = Bio::Tree::Tree->new(-root => pop @nodes );\n   return $T;\n}\n\n\n=head2 maxcount\n\n Title   : maxcount\n Usage   : $obj->maxcount($newval)\n Function: \n Returns : Maxcount value\n Args    : newvalue (optional)\n\n\n\nsub maxcount{\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if( $value =~ /^(\\d+)/ ) { \n\t   $self->{'_maxcount'} = $1;\n       } else { \n\t   $self->warn(\"Must specify a valid Positive integer to maxcount\");\n\t   $self->{'_maxcount'} = 0;\n       }\n  }\n   return $self->{'_maxcount'};\n}\n\n\n=head2 reset_tree_count\n\n Title   : reset_tree_count\n Usage   : $factory->reset_tree_count;\n Function: Reset the tree counter\n Returns : none\n Args    : none\n\n\n\nsub reset_count{\n    shift->{'_count'} = 0;\n}\n\n=head2 taxa\n\n Title   : taxa\n Usage   : $obj->taxa($newval)\n Function: Set the leaf node names\n Returns : value of taxa\n Args    : Arrayref of Taxon names\n\n\n\nsub taxa {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif( ref($value) !~ /ARRAY/i ) { \n\t    $self->warn(\"Must specify a valid array ref to the method 'taxa'\");\n\t    $value = [];\n\t} \n\t$self->{'_taxa'} = $value;\n\t$self->{'_num_taxa'} = scalar @$value;\n    }\n    return $self->{'_taxa'};\n\n}\n\n=head2 num_taxa\n\n Title   : num_taxa\n Usage   : $obj->num_taxa($newval)\n Function: Get the number of Taxa\n Returns : value of num_taxa\n Args    : none\n\n\n\nsub num_taxa {\n    my ($self) = @_;\n    return  $self->{'_num_taxa'};\n}\n\n# alias old methods\n*num_samples = \\&num_taxa;\n*samples = \\&taxa;\n\n=head2 random\n\n Title   : random\n Usage   : my $rfloat = $node->random($size)\n Function: Generates a random number between 0 and $size\n           This is abstracted so that someone can override and provide their\n           own special RNG.  This is expected to be a uniform RNG.\n Returns : Floating point random\n Args    : $maximum size for random number (defaults to 1)\n\n\n\nsub random{\n   my ($self,$max) = @_;\n   return rand($max);\n}\n\n\n=head2 random_tree_method\n\n Title   : random_tree_method\n Usage   : $obj->random_tree_method($newval)\n Function: \n Example : \n Returns : value of random_tree_method (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub random_tree_method{\n    my $self = shift;\n\n    return $self->{'random_tree_method'} = shift if @_;\n    return $self->{'random_tree_method'} || $Defaults{'DefaultTreeMethod'};\n}\n\n=head2 nodetype\n\n Title   : nodetype\n Usage   : $obj->nodetype($newval)\n Function: \n Example : \n Returns : value of nodetype (a scalar)\n Args    : on set, new value (a scalar or undef, optional)"},"kind":12,"range":{"start":{"character":0,"line":369},"end":{"character":9999,"line":383}},"line":369,"detail":"($self,$value)","definition":"sub","name":"nodetype","containerName":"main::","children":[{"definition":"my","line":370,"localvar":"my","kind":13,"containerName":"nodetype","name":"$self"},{"name":"$value","kind":13,"containerName":"nodetype","line":370},{"line":371,"containerName":"nodetype","kind":13,"name":"$value"},{"name":"$self","kind":13,"containerName":"nodetype","line":373},{"name":"throw","containerName":"nodetype","kind":12,"line":373},{"line":373,"kind":13,"containerName":"nodetype","name":"$self"},{"definition":"my","name":"$a","localvar":"my","kind":13,"containerName":"nodetype","line":376},{"line":376,"kind":13,"containerName":"nodetype","name":"$value"},{"line":377,"name":"$a","containerName":"nodetype","kind":13},{"name":"isa","containerName":"nodetype","kind":12,"line":377},{"line":378,"name":"$self","containerName":"nodetype","kind":13},{"kind":12,"containerName":"nodetype","name":"throw","line":378},{"line":380,"containerName":"nodetype","kind":13,"name":"$self"},{"line":380,"name":"$value","kind":13,"containerName":"nodetype"},{"line":382,"containerName":"nodetype","kind":13,"name":"$self"}]},{"signature":{"label":"rand_yule_c_tree($self,$speciation)","parameters":[{"label":"$self"},{"label":"$speciation"}],"documentation":" The assignment of times are based on Mike Sanderson's r8s code\n The topology assignment code is based on Richard Hudson's\n make_trees"},"line":391,"kind":12,"range":{"end":{"character":9999,"line":441},"start":{"line":391,"character":0}},"definition":"sub","detail":"($self,$speciation)","children":[{"line":392,"name":"$self","localvar":"my","containerName":"rand_yule_c_tree","kind":13,"definition":"my"},{"line":392,"name":"$speciation","containerName":"rand_yule_c_tree","kind":13},{"name":"$speciation","containerName":"rand_yule_c_tree","kind":13,"line":393},{"line":393,"kind":13,"containerName":"rand_yule_c_tree","name":"$Defaults"},{"line":394,"localvar":"my","kind":13,"containerName":"rand_yule_c_tree","name":"$n_taxa","definition":"my"},{"name":"$self","kind":13,"containerName":"rand_yule_c_tree","line":394},{"line":394,"name":"num_taxa","kind":12,"containerName":"rand_yule_c_tree"},{"definition":"my","containerName":"rand_yule_c_tree","localvar":"my","kind":13,"name":"$taxa","line":395},{"line":395,"name":"$self","containerName":"rand_yule_c_tree","kind":13},{"line":395,"kind":12,"containerName":"rand_yule_c_tree","name":"taxa"},{"line":396,"containerName":"rand_yule_c_tree","localvar":"my","kind":13,"name":"$nodetype","definition":"my"},{"containerName":"rand_yule_c_tree","kind":13,"name":"$self","line":396},{"line":396,"containerName":"rand_yule_c_tree","kind":12,"name":"nodetype"},{"localvar":"my","kind":13,"containerName":"rand_yule_c_tree","name":"$randfuncs","line":398,"definition":"my"},{"line":398,"kind":12,"containerName":"rand_yule_c_tree","name":"new"},{"name":"$rate","containerName":"rand_yule_c_tree","localvar":"my","kind":13,"line":399,"definition":"my"},{"line":399,"name":"$Defaults","containerName":"rand_yule_c_tree","kind":13},{"line":400,"localvar":"my","containerName":"rand_yule_c_tree","kind":13,"name":"@tree","definition":"my"},{"name":"@list","kind":13,"containerName":"rand_yule_c_tree","line":400},{"line":400,"kind":13,"containerName":"rand_yule_c_tree","name":"@times"},{"line":400,"name":"$i","containerName":"rand_yule_c_tree","kind":13},{"kind":13,"containerName":"rand_yule_c_tree","name":"$in","line":400},{"line":401,"localvar":"my","kind":13,"containerName":"rand_yule_c_tree","name":"$max","definition":"my"},{"line":401,"containerName":"rand_yule_c_tree","kind":13,"name":"$n_taxa"},{"line":402,"name":"$in","containerName":"rand_yule_c_tree","kind":13},{"line":402,"name":"$in","kind":13,"containerName":"rand_yule_c_tree"},{"kind":13,"containerName":"rand_yule_c_tree","name":"$max","line":402},{"line":402,"name":"$in","kind":13,"containerName":"rand_yule_c_tree"},{"line":403,"name":"@tree","kind":13,"containerName":"rand_yule_c_tree"},{"line":406,"kind":13,"containerName":"rand_yule_c_tree","name":"$in"},{"name":"$in","kind":13,"containerName":"rand_yule_c_tree","line":406},{"line":406,"containerName":"rand_yule_c_tree","kind":13,"name":"$n_taxa"},{"line":406,"containerName":"rand_yule_c_tree","kind":13,"name":"$in"},{"line":407,"kind":13,"containerName":"rand_yule_c_tree","name":"$tree"},{"line":407,"kind":13,"containerName":"rand_yule_c_tree","name":"$in"},{"containerName":"rand_yule_c_tree","kind":13,"name":"$tree","line":408},{"line":408,"name":"$in","containerName":"rand_yule_c_tree","kind":13},{"containerName":"rand_yule_c_tree","kind":13,"name":"$tree","line":409},{"line":409,"name":"$in","kind":13,"containerName":"rand_yule_c_tree"},{"line":410,"kind":13,"localvar":"my","containerName":"rand_yule_c_tree","name":"$r","definition":"my"},{"containerName":"rand_yule_c_tree","kind":13,"name":"$taxa","line":410},{"line":410,"kind":13,"containerName":"rand_yule_c_tree","name":"$in"},{"line":411,"kind":13,"containerName":"rand_yule_c_tree","name":"$tree"},{"line":411,"kind":13,"containerName":"rand_yule_c_tree","name":"$in"},{"line":411,"name":"$r","containerName":"rand_yule_c_tree","kind":13},{"line":413,"kind":13,"containerName":"rand_yule_c_tree","name":"@list"},{"containerName":"rand_yule_c_tree","kind":13,"name":"$in","line":413},{"line":416,"name":"$i","kind":13,"containerName":"rand_yule_c_tree"},{"name":"$i","containerName":"rand_yule_c_tree","kind":13,"line":416},{"name":"$n_taxa","kind":13,"containerName":"rand_yule_c_tree","line":416},{"line":416,"kind":13,"containerName":"rand_yule_c_tree","name":"$i"},{"containerName":"rand_yule_c_tree","kind":13,"name":"@times","line":418},{"name":"$randfuncs","containerName":"rand_yule_c_tree","kind":13,"line":418},{"line":418,"name":"rand_birth_distribution","containerName":"rand_yule_c_tree","kind":12},{"containerName":"rand_yule_c_tree","kind":13,"name":"$speciation","line":418},{"line":421,"name":"@times","kind":13,"containerName":"rand_yule_c_tree"},{"containerName":"rand_yule_c_tree","kind":13,"name":"$a","line":421},{"name":"$b","containerName":"rand_yule_c_tree","kind":13,"line":421},{"line":421,"kind":13,"containerName":"rand_yule_c_tree","name":"@times"},{"kind":13,"containerName":"rand_yule_c_tree","name":"$in","line":423},{"name":"$n_taxa","containerName":"rand_yule_c_tree","kind":13,"line":423},{"line":423,"kind":13,"containerName":"rand_yule_c_tree","name":"$in"},{"name":"$in","kind":13,"containerName":"rand_yule_c_tree","line":423},{"line":424,"containerName":"rand_yule_c_tree","localvar":"my","kind":13,"name":"$time","definition":"my"},{"line":424,"containerName":"rand_yule_c_tree","kind":13,"name":"@times"},{"name":"$pick","localvar":"my","kind":13,"containerName":"rand_yule_c_tree","line":426,"definition":"my"},{"name":"$self","kind":13,"containerName":"rand_yule_c_tree","line":426},{"line":426,"containerName":"rand_yule_c_tree","kind":12,"name":"random"},{"containerName":"rand_yule_c_tree","kind":13,"name":"$in","line":426},{"definition":"my","name":"$nodeindex","localvar":"my","kind":13,"containerName":"rand_yule_c_tree","line":427},{"line":427,"name":"$list","containerName":"rand_yule_c_tree","kind":13},{"line":427,"kind":13,"containerName":"rand_yule_c_tree","name":"$pick"},{"line":428,"containerName":"rand_yule_c_tree","kind":13,"name":"$tree"},{"line":428,"kind":13,"containerName":"rand_yule_c_tree","name":"$list"},{"name":"$pick","containerName":"rand_yule_c_tree","kind":13,"line":428},{"name":"$time","containerName":"rand_yule_c_tree","kind":13,"line":428},{"definition":"my","containerName":"rand_yule_c_tree","localvar":"my","kind":13,"name":"$swap","line":429},{"kind":13,"containerName":"rand_yule_c_tree","name":"$n_taxa","line":429},{"name":"$in","containerName":"rand_yule_c_tree","kind":13,"line":429},{"line":430,"kind":13,"containerName":"rand_yule_c_tree","name":"$tree"},{"line":430,"name":"$swap","kind":13,"containerName":"rand_yule_c_tree"},{"line":430,"containerName":"rand_yule_c_tree","kind":13,"name":"$nodeindex"},{"line":431,"containerName":"rand_yule_c_tree","kind":13,"name":"$list"},{"containerName":"rand_yule_c_tree","kind":13,"name":"$pick","line":431},{"line":431,"kind":13,"containerName":"rand_yule_c_tree","name":"$list"},{"line":431,"kind":13,"containerName":"rand_yule_c_tree","name":"$in"},{"line":433,"name":"$pick","kind":13,"containerName":"rand_yule_c_tree"},{"line":433,"kind":13,"containerName":"rand_yule_c_tree","name":"$in"},{"line":434,"kind":13,"containerName":"rand_yule_c_tree","name":"$nodeindex"},{"name":"$list","kind":13,"containerName":"rand_yule_c_tree","line":434},{"line":434,"name":"$pick","containerName":"rand_yule_c_tree","kind":13},{"name":"$tree","containerName":"rand_yule_c_tree","kind":13,"line":435},{"line":435,"name":"$list","kind":13,"containerName":"rand_yule_c_tree"},{"line":435,"kind":13,"containerName":"rand_yule_c_tree","name":"$pick"},{"line":435,"containerName":"rand_yule_c_tree","kind":13,"name":"$time"},{"line":436,"name":"$tree","containerName":"rand_yule_c_tree","kind":13},{"containerName":"rand_yule_c_tree","kind":13,"name":"$swap","line":436},{"kind":13,"containerName":"rand_yule_c_tree","name":"$nodeindex","line":436},{"kind":13,"containerName":"rand_yule_c_tree","name":"$list","line":437},{"line":437,"kind":13,"containerName":"rand_yule_c_tree","name":"$pick"},{"containerName":"rand_yule_c_tree","kind":13,"name":"$swap","line":437},{"line":439,"kind":13,"containerName":"rand_yule_c_tree","name":"$tree"},{"line":439,"name":"@times","kind":13,"containerName":"rand_yule_c_tree"},{"line":440,"kind":13,"containerName":"rand_yule_c_tree","name":"@tree"}],"containerName":"main::","name":"rand_yule_c_tree"},{"name":"Bio","containerName":"Tools::RandomDistFunctions","kind":12,"line":398},{"definition":"sub","detail":"($self)","children":[{"definition":"my","line":446,"containerName":"rand_birthdeath_backwards_tree","localvar":"my","kind":13,"name":"$self"},{"name":"$n_taxa","localvar":"my","containerName":"rand_birthdeath_backwards_tree","kind":13,"line":447,"definition":"my"},{"line":447,"containerName":"rand_birthdeath_backwards_tree","kind":13,"name":"$self"},{"line":447,"name":"num_taxa","kind":12,"containerName":"rand_birthdeath_backwards_tree"},{"name":"$taxa","localvar":"my","containerName":"rand_birthdeath_backwards_tree","kind":13,"line":448,"definition":"my"},{"line":448,"kind":13,"containerName":"rand_birthdeath_backwards_tree","name":"$self"},{"line":448,"kind":12,"containerName":"rand_birthdeath_backwards_tree","name":"taxa"},{"definition":"my","name":"$randfuncs","containerName":"rand_birthdeath_backwards_tree","localvar":"my","kind":13,"line":450},{"line":450,"name":"new","containerName":"rand_birthdeath_backwards_tree","kind":12},{"localvar":"my","kind":13,"containerName":"rand_birthdeath_backwards_tree","name":"$rate","line":451,"definition":"my"},{"line":451,"kind":13,"containerName":"rand_birthdeath_backwards_tree","name":"$Defaults"},{"line":452,"name":"@tree","containerName":"rand_birthdeath_backwards_tree","localvar":"my","kind":13,"definition":"my"},{"line":452,"name":"@list","containerName":"rand_birthdeath_backwards_tree","kind":13},{"name":"@times","containerName":"rand_birthdeath_backwards_tree","kind":13,"line":452},{"line":452,"kind":13,"containerName":"rand_birthdeath_backwards_tree","name":"$i"},{"name":"$in","containerName":"rand_birthdeath_backwards_tree","kind":13,"line":452},{"name":"$max","containerName":"rand_birthdeath_backwards_tree","localvar":"my","kind":13,"line":453,"definition":"my"},{"name":"$n_taxa","containerName":"rand_birthdeath_backwards_tree","kind":13,"line":453},{"kind":13,"containerName":"rand_birthdeath_backwards_tree","name":"$in","line":454},{"line":454,"name":"$in","containerName":"rand_birthdeath_backwards_tree","kind":13},{"line":454,"name":"$max","containerName":"rand_birthdeath_backwards_tree","kind":13},{"name":"$in","containerName":"rand_birthdeath_backwards_tree","kind":13,"line":454},{"line":455,"name":"@tree","kind":13,"containerName":"rand_birthdeath_backwards_tree"},{"kind":13,"containerName":"rand_birthdeath_backwards_tree","name":"$in","line":458},{"name":"$in","kind":13,"containerName":"rand_birthdeath_backwards_tree","line":458},{"line":458,"name":"$n_taxa","kind":13,"containerName":"rand_birthdeath_backwards_tree"},{"containerName":"rand_birthdeath_backwards_tree","kind":13,"name":"$in","line":458},{"containerName":"rand_birthdeath_backwards_tree","kind":13,"name":"$tree","line":459},{"line":459,"name":"$in","kind":13,"containerName":"rand_birthdeath_backwards_tree"},{"line":460,"kind":13,"containerName":"rand_birthdeath_backwards_tree","name":"$tree"},{"name":"$in","containerName":"rand_birthdeath_backwards_tree","kind":13,"line":460},{"name":"$tree","containerName":"rand_birthdeath_backwards_tree","kind":13,"line":461},{"name":"$in","containerName":"rand_birthdeath_backwards_tree","kind":13,"line":461},{"kind":13,"localvar":"my","containerName":"rand_birthdeath_backwards_tree","name":"$r","line":462,"definition":"my"},{"containerName":"rand_birthdeath_backwards_tree","kind":13,"name":"$taxa","line":462},{"name":"$in","kind":13,"containerName":"rand_birthdeath_backwards_tree","line":462},{"containerName":"rand_birthdeath_backwards_tree","kind":13,"name":"$tree","line":464},{"name":"$in","kind":13,"containerName":"rand_birthdeath_backwards_tree","line":464},{"name":"$r","kind":13,"containerName":"rand_birthdeath_backwards_tree","line":464},{"line":466,"name":"@list","kind":13,"containerName":"rand_birthdeath_backwards_tree"},{"containerName":"rand_birthdeath_backwards_tree","kind":13,"name":"$in","line":466},{"definition":"my","name":"$time","localvar":"my","kind":13,"containerName":"rand_birthdeath_backwards_tree","line":468},{"line":471,"kind":13,"containerName":"rand_birthdeath_backwards_tree","name":"$in"},{"line":471,"containerName":"rand_birthdeath_backwards_tree","kind":13,"name":"$n_taxa"},{"kind":13,"containerName":"rand_birthdeath_backwards_tree","name":"$in","line":471},{"name":"$in","containerName":"rand_birthdeath_backwards_tree","kind":13,"line":471},{"line":472,"kind":13,"localvar":"my","containerName":"rand_birthdeath_backwards_tree","name":"$pick","definition":"my"},{"containerName":"rand_birthdeath_backwards_tree","kind":13,"name":"$self","line":472},{"name":"random","kind":12,"containerName":"rand_birthdeath_backwards_tree","line":472},{"containerName":"rand_birthdeath_backwards_tree","kind":13,"name":"$in","line":472},{"line":473,"name":"$nodeindex","localvar":"my","kind":13,"containerName":"rand_birthdeath_backwards_tree","definition":"my"},{"line":473,"containerName":"rand_birthdeath_backwards_tree","kind":13,"name":"$list"},{"line":473,"kind":13,"containerName":"rand_birthdeath_backwards_tree","name":"$pick"},{"definition":"my","localvar":"my","containerName":"rand_birthdeath_backwards_tree","kind":13,"name":"$swap","line":474},{"containerName":"rand_birthdeath_backwards_tree","kind":13,"name":"$n_taxa","line":474},{"containerName":"rand_birthdeath_backwards_tree","kind":13,"name":"$in","line":474},{"kind":13,"containerName":"rand_birthdeath_backwards_tree","name":"$time","line":475},{"line":475,"name":"$randfuncs","containerName":"rand_birthdeath_backwards_tree","kind":13},{"line":475,"containerName":"rand_birthdeath_backwards_tree","kind":12,"name":"rand_geometric_distribution"},{"name":"$n_taxa","kind":13,"containerName":"rand_birthdeath_backwards_tree","line":475},{"line":475,"kind":13,"containerName":"rand_birthdeath_backwards_tree","name":"$rate"},{"line":476,"name":"$tree","containerName":"rand_birthdeath_backwards_tree","kind":13},{"name":"$list","kind":13,"containerName":"rand_birthdeath_backwards_tree","line":476},{"line":476,"kind":13,"containerName":"rand_birthdeath_backwards_tree","name":"$pick"},{"line":476,"name":"$time","containerName":"rand_birthdeath_backwards_tree","kind":13},{"kind":13,"containerName":"rand_birthdeath_backwards_tree","name":"$tree","line":477},{"name":"$swap","containerName":"rand_birthdeath_backwards_tree","kind":13,"line":477},{"line":477,"kind":13,"containerName":"rand_birthdeath_backwards_tree","name":"$nodeindex"},{"name":"$list","containerName":"rand_birthdeath_backwards_tree","kind":13,"line":478},{"line":478,"name":"$pick","kind":13,"containerName":"rand_birthdeath_backwards_tree"},{"line":478,"containerName":"rand_birthdeath_backwards_tree","kind":13,"name":"$list"},{"line":478,"name":"$in","containerName":"rand_birthdeath_backwards_tree","kind":13},{"line":480,"kind":13,"containerName":"rand_birthdeath_backwards_tree","name":"$pick"},{"containerName":"rand_birthdeath_backwards_tree","kind":13,"name":"$in","line":480},{"line":481,"name":"$nodeindex","containerName":"rand_birthdeath_backwards_tree","kind":13},{"name":"$list","kind":13,"containerName":"rand_birthdeath_backwards_tree","line":481},{"name":"$pick","containerName":"rand_birthdeath_backwards_tree","kind":13,"line":481},{"kind":13,"containerName":"rand_birthdeath_backwards_tree","name":"$tree","line":482},{"line":482,"name":"$list","containerName":"rand_birthdeath_backwards_tree","kind":13},{"line":482,"name":"$pick","containerName":"rand_birthdeath_backwards_tree","kind":13},{"line":482,"containerName":"rand_birthdeath_backwards_tree","kind":13,"name":"$time"},{"kind":13,"containerName":"rand_birthdeath_backwards_tree","name":"$tree","line":483},{"line":483,"kind":13,"containerName":"rand_birthdeath_backwards_tree","name":"$swap"},{"line":483,"name":"$nodeindex","kind":13,"containerName":"rand_birthdeath_backwards_tree"},{"kind":13,"containerName":"rand_birthdeath_backwards_tree","name":"$list","line":484},{"line":484,"name":"$pick","containerName":"rand_birthdeath_backwards_tree","kind":13},{"line":484,"name":"$swap","containerName":"rand_birthdeath_backwards_tree","kind":13},{"kind":13,"localvar":"my","containerName":"rand_birthdeath_backwards_tree","name":"$root","line":486,"definition":"my"},{"line":486,"containerName":"rand_birthdeath_backwards_tree","kind":13,"name":"$tree"},{"line":487,"name":"$time","containerName":"rand_birthdeath_backwards_tree","kind":13},{"line":487,"containerName":"rand_birthdeath_backwards_tree","kind":13,"name":"$randfuncs"},{"kind":12,"containerName":"rand_birthdeath_backwards_tree","name":"rand_geometric_distribution","line":487},{"line":487,"kind":13,"containerName":"rand_birthdeath_backwards_tree","name":"$n_taxa"},{"name":"$rate","containerName":"rand_birthdeath_backwards_tree","kind":13,"line":487},{"line":488,"kind":13,"containerName":"rand_birthdeath_backwards_tree","name":"$root"},{"name":"$time","containerName":"rand_birthdeath_backwards_tree","kind":13,"line":488},{"name":"$node","kind":13,"localvar":"my","containerName":"rand_birthdeath_backwards_tree","line":491,"definition":"my"},{"line":491,"kind":13,"containerName":"rand_birthdeath_backwards_tree","name":"@tree"},{"line":492,"containerName":"rand_birthdeath_backwards_tree","kind":13,"name":"$node"},{"line":492,"name":"$root","kind":13,"containerName":"rand_birthdeath_backwards_tree"},{"containerName":"rand_birthdeath_backwards_tree","kind":13,"name":"@tree","line":494}],"containerName":"main::","name":"rand_birthdeath_backwards_tree","signature":{"label":"rand_birthdeath_backwards_tree($self)","parameters":[{"label":"$self"}],"documentation":""},"line":445,"range":{"start":{"line":445,"character":0},"end":{"line":495,"character":9999}},"kind":12},{"line":450,"name":"Bio","kind":12,"containerName":"Tools::RandomDistFunctions"},{"line":502,"kind":12,"range":{"start":{"character":0,"line":502},"end":{"line":543,"character":9999}},"children":[],"containerName":"main::","name":"rand_birth_death_tree","definition":"sub"}]}