{"vars":[{"containerName":"","kind":2,"name":"base","line":127},{"name":"%xx","containerName":null,"localvar":"my","kind":13,"line":132,"definition":"my"},{"line":133,"name":"%yy","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"$t1","line":134},{"line":135,"localvar":"my","containerName":null,"kind":13,"name":"$t2","definition":"my"},{"definition":"my","line":136,"containerName":null,"localvar":"my","kind":13,"name":"$font"},{"name":"$size","kind":13,"localvar":"my","containerName":null,"line":137,"definition":"my"},{"name":"$width","localvar":"my","kind":13,"containerName":null,"line":138,"definition":"my"},{"line":139,"name":"$height","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"line":140,"name":"$xstep","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"$tip","line":141},{"localvar":"my","kind":13,"containerName":null,"name":"$tipwidth1","line":142,"definition":"my"},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"$tipwidth2","line":143},{"name":"$compact","kind":13,"localvar":"my","containerName":null,"line":144,"definition":"my"},{"definition":"my","line":145,"name":"$ratio","localvar":"my","containerName":null,"kind":13},{"line":146,"localvar":"my","kind":13,"containerName":null,"name":"$colors","definition":"my"},{"definition":"my","name":"%Rcolor","localvar":"my","kind":13,"containerName":null,"line":147},{"line":148,"kind":13,"localvar":"my","containerName":null,"name":"%Gcolor","definition":"my"},{"line":149,"name":"%Bcolor","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"name":"$bootstrap","containerName":null,"localvar":"my","kind":13,"line":150,"definition":"my"},{"kind":12,"range":{"start":{"character":0,"line":175},"end":{"line":420,"character":9999}},"line":175,"signature":{"documentation":"1;\n# $Id: Cladogram.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Cladogram\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Valiente <valiente@lsi.upc.edu>\n#\n# Copyright Gabriel Valiente\n#\n# You may distribute this module under the same terms as Perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::Draw::Cladogram - Drawing phylogenetic trees in\nEncapsulated PostScript (EPS) format.\n\n=head1 SYNOPSIS\n\n  use Bio::Tree::Draw::Cladogram;\n  use Bio::TreeIO;\n  my $treeio = Bio::TreeIO->new('-format' => 'newick',\n  \t\t\t       '-file'   => 'input.nwk');\n  my $t1 = $treeio->next_tree;\n  my $t2 = $treeio->next_tree;\n\n  my $obj1 = Bio::Tree::Draw::Cladogram->new(-tree => $t1);\n  $obj1->print(-file => 'cladogram.eps');\n\n  if ($t2) {\n    my $obj2 = Bio::Tree::Draw::Cladogram->new(-tree => $t1, -second => $t2);\n    $obj2->print(-file => 'tanglegram.eps');\n  }\n\n=head1 DESCRIPTION\n\nBio::Tree::Draw::Cladogram is a Perl tool for drawing Bio::Tree::Tree\nobjects in Encapsulated PostScript (EPS) format. It can be utilized\nboth for displaying a single phylogenetic tree (a cladogram) and for\nthe comparative display of two phylogenetic trees (a tanglegram) such\nas a gene tree and a species tree, a host tree and a parasite tree,\ntwo alternative trees for the same set of taxa, or two alternative\ntrees for overlapping sets of taxa.\n\nPhylogenetic trees are drawn as rectangular cladograms, with\nhorizontal orientation and ancestral nodes centered over their\ndescendents. The font used for taxa is Courier at 10 pt. A single\nBio::Tree::Tree object is drawn with ancestors to the left and taxa\nflushed to the right. Two Bio::Tree::Tree objects are drawn with the\nfirst tree oriented left-to-right and the second tree oriented\nright-to-left, and with corresponding taxa connected by straight lines\nin a shade of gray. Each correspondence between a $taxon1 of the first\ntree and a $taxon2 of the second tree is established by setting\n$taxon1-E<gt>add_tag_value('connection',$taxon2). Thus, a taxon of the\nfirst tree can be connected to more than one taxon of the second tree,\nand vice versa.\n\nThe branch from the parent to a child $node, as well as the child\nlabel, can be colored by setting $node-E<gt>add_tag_value('Rcolor',$r),\n$node-E<gt>add_tag_value('Gcolor',$g), and\n$node-E<gt>add_tag_value('Bcolor',$b), where $r, $g, and $b are the\ndesired values for red, green, and blue (zero for lowest, one for\nhighest intensity).\n\nThis is a preliminary release of Bio::Tree::Draw::Cladogram. Future\nimprovements include an option to output phylograms instead of\ncladograms. Beware that cladograms are automatically scaled according\nto branch lengths, but the current release has only been tested with\ntrees having unit branch lengths.\n\nThe print method could be extended to output graphic formats other\nthan EPS, although there are many graphics conversion programs around\nthat accept EPS input. For instance, most Linux distributions include\nepstopdf, a Perl script that together with Ghostscript, converts EPS\nto PDF.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gabriel Valiente\n\nEmail valiente@lsi.upc.edu\n\nCode for coloring branches contributed by Georgii A Bazykin\n(gbazykin@princeton.edu).\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tree::Draw::Cladogram;\nuse strict;\n\nuse PostScript::TextBlock;\n\nuse base qw(Bio::Root::Root);\n\n# The following private package variables are set by the new method\n# and used by the print method.\n\nmy %xx;        # horizontal coordinate for each node\nmy %yy;        # vertical coordinate for each node\nmy $t1;        # first Bio::Tree::Tree object\nmy $t2;        # second Bio::Tree::Tree object\nmy $font;      # font name\nmy $size;      # font size\nmy $width;     # total drawing width\nmy $height;    # total drawing height\nmy $xstep;     # branch length in drawing\nmy $tip;       # extra space between tip and label\nmy $tipwidth1; # width of longest label among $t1 taxa\nmy $tipwidth2; # width of longest label among $t2 taxa\nmy $compact;   # whether or not to ignore branch lengths\nmy $ratio;     # horizontal to vertical ratio\nmy $colors;    # use colors to color edges\nmy %Rcolor;    # red color for each node\nmy %Gcolor;    # green color for each node\nmy %Bcolor;    # blue color for each node\nmy $bootstrap; # Draw Bootstrap boolean\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::Draw::Cladogram->new();\n Function: Builds a new Bio::Tree::Draw::Cladogram object \n Returns : Bio::Tree::Draw::Cladogram\n Args    : -tree => Bio::Tree::Tree object\n           -second => Bio::Tree::Tree object (optional)\n           -font => font name [string] (optional)\n           -size => font size [integer] (optional)\n           -top => top margin [integer] (optional)\n           -bottom => bottom margin [integer] (optional)\n           -left => left margin [integer] (optional)\n           -right => right margin [integer] (optional)\n           -tip => extra tip space [integer] (optional)\n           -column => extra space between cladograms [integer] (optional)\n           -compact => ignore branch lengths [boolean] (optional)\n           -ratio => horizontal to vertical ratio [integer] (optional)\n           -colors => use colors to color edges [boolean] (optional)\n           -bootstrap => draw bootstrap or internal ids [boolean]","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"name":"new","containerName":"main::","children":[{"line":176,"localvar":"my","containerName":"new","kind":13,"name":"$class","definition":"my"},{"name":"@args","containerName":"new","kind":13,"line":176},{"localvar":"my","kind":13,"containerName":"new","name":"$self","line":178,"definition":"my"},{"line":178,"name":"$class","containerName":"new","kind":13},{"line":178,"name":"@args","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$t1","line":179},{"line":179,"name":"$t2","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$font","line":179},{"line":179,"kind":13,"containerName":"new","name":"$size"},{"definition":"my","line":179,"name":"$top","localvar":"my","containerName":"new","kind":13},{"definition":"my","line":179,"name":"$bottom","localvar":"my","containerName":"new","kind":13},{"definition":"my","name":"$left","kind":13,"localvar":"my","containerName":"new","line":179},{"definition":"my","line":179,"name":"$right","localvar":"my","kind":13,"containerName":"new"},{"line":180,"containerName":"new","kind":13,"name":"$tip"},{"definition":"my","localvar":"my","kind":13,"containerName":"new","name":"$column","line":180},{"name":"$compact","kind":13,"containerName":"new","line":180},{"line":180,"name":"$ratio","containerName":"new","kind":13},{"name":"$colors","containerName":"new","kind":13,"line":180},{"name":"$bootstrap","containerName":"new","kind":13,"line":180},{"line":181,"containerName":"new","kind":13,"name":"$self"},{"line":181,"kind":12,"containerName":"new","name":"_rearrange"},{"name":"@args","containerName":"new","kind":13,"line":183},{"line":184,"name":"$font","containerName":"new","kind":13},{"name":"$size","containerName":"new","kind":13,"line":185},{"line":186,"containerName":"new","kind":13,"name":"$top"},{"name":"$bottom","containerName":"new","kind":13,"line":187},{"line":188,"name":"$left","kind":13,"containerName":"new"},{"line":189,"kind":13,"containerName":"new","name":"$right"},{"line":190,"name":"$tip","kind":13,"containerName":"new"},{"line":191,"kind":13,"containerName":"new","name":"$column"},{"name":"$compact","kind":13,"containerName":"new","line":192},{"line":193,"name":"$ratio","kind":13,"containerName":"new"},{"line":194,"name":"$colors","kind":13,"containerName":"new"},{"line":195,"kind":13,"containerName":"new","name":"$bootstrap"},{"definition":"my","name":"@taxa1","localvar":"my","containerName":"new","kind":13,"line":241},{"kind":13,"containerName":"new","name":"$t1","line":241},{"line":241,"containerName":"new","kind":12,"name":"get_leaf_nodes"},{"line":242,"name":"$root1","localvar":"my","kind":13,"containerName":"new","definition":"my"},{"kind":13,"containerName":"new","name":"$t1","line":242},{"line":242,"name":"get_root_node","containerName":"new","kind":12},{"line":244,"containerName":"new","kind":13,"name":"$tipwidth1"},{"localvar":"my","containerName":"new","kind":13,"name":"$taxon","line":245,"definition":"my"},{"line":245,"containerName":"new","kind":13,"name":"@taxa1"},{"localvar":"my","containerName":"new","kind":13,"name":"$w","line":246,"definition":"my"},{"line":246,"kind":13,"containerName":"new","name":"$taxon"},{"containerName":"new","kind":12,"name":"id","line":246},{"line":246,"name":"$font","containerName":"new","kind":13},{"line":246,"kind":13,"containerName":"new","name":"$size"},{"line":247,"name":"$w","kind":13,"containerName":"new"},{"line":247,"kind":13,"containerName":"new","name":"$tipwidth1"},{"containerName":"new","kind":13,"name":"$tipwidth1","line":247},{"name":"$w","containerName":"new","kind":13,"line":247},{"definition":"my","name":"@taxa2","kind":13,"localvar":"my","containerName":"new","line":250},{"definition":"my","localvar":"my","kind":13,"containerName":"new","name":"$root2","line":251},{"name":"$ystep","containerName":"new","localvar":"my","kind":13,"line":253,"definition":"my"},{"name":"$t2","containerName":"new","kind":13,"line":255},{"line":256,"containerName":"new","kind":13,"name":"@taxa2"},{"line":256,"kind":13,"containerName":"new","name":"$t2"},{"kind":12,"containerName":"new","name":"get_leaf_nodes","line":256},{"line":257,"name":"$root2","kind":13,"containerName":"new"},{"line":257,"containerName":"new","kind":13,"name":"$t2"},{"name":"get_root_node","containerName":"new","kind":12,"line":257},{"line":258,"containerName":"new","kind":13,"name":"$tipwidth2"},{"line":259,"name":"$taxon","containerName":"new","localvar":"my","kind":13,"definition":"my"},{"name":"@taxa2","kind":13,"containerName":"new","line":259},{"definition":"my","localvar":"my","kind":13,"containerName":"new","name":"$w","line":260},{"name":"$taxon","kind":13,"containerName":"new","line":260},{"name":"id","containerName":"new","kind":12,"line":260},{"kind":13,"containerName":"new","name":"$font","line":260},{"line":260,"containerName":"new","kind":13,"name":"$size"},{"line":261,"containerName":"new","kind":13,"name":"$w"},{"name":"$tipwidth2","containerName":"new","kind":13,"line":261},{"containerName":"new","kind":13,"name":"$tipwidth2","line":261},{"line":261,"kind":13,"containerName":"new","name":"$w"},{"line":265,"name":"$stems","localvar":"my","containerName":"new","kind":13,"definition":"my"},{"name":"$root1","containerName":"new","kind":13,"line":265},{"containerName":"new","kind":12,"name":"height","line":265},{"name":"$t2","containerName":"new","kind":13,"line":266},{"line":266,"name":"$stems","kind":13,"containerName":"new"},{"name":"$root2","kind":13,"containerName":"new","line":266},{"line":266,"kind":12,"containerName":"new","name":"height"},{"definition":"my","name":"$labels","kind":13,"localvar":"my","containerName":"new","line":267},{"kind":13,"containerName":"new","name":"$tipwidth1","line":267},{"name":"$t2","kind":13,"containerName":"new","line":268},{"name":"$labels","kind":13,"containerName":"new","line":268},{"name":"$tipwidth2","containerName":"new","kind":13,"line":268},{"line":269,"name":"$xstep","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$width","line":270},{"line":270,"containerName":"new","kind":13,"name":"$left"},{"line":270,"name":"$stems","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$xstep","line":270},{"name":"$tip","kind":13,"containerName":"new","line":270},{"line":270,"name":"$labels","containerName":"new","kind":13},{"name":"$right","containerName":"new","kind":13,"line":270},{"line":271,"containerName":"new","kind":13,"name":"$t2"},{"line":271,"name":"$width","containerName":"new","kind":13},{"line":271,"name":"$tip","containerName":"new","kind":13},{"line":271,"name":"$column","containerName":"new","kind":13},{"line":271,"name":"$tip","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$tip","line":271},{"kind":13,"containerName":"new","name":"$height","line":272},{"line":272,"name":"$bottom","containerName":"new","kind":13},{"name":"$ystep","containerName":"new","kind":13,"line":272},{"line":272,"name":"@taxa1","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$top","line":272},{"line":273,"name":"$t2","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"@taxa2","line":274},{"containerName":"new","kind":13,"name":"@taxa1","line":274},{"kind":13,"containerName":"new","name":"$height","line":275},{"line":275,"name":"$bottom","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$ystep","line":275},{"containerName":"new","kind":13,"name":"@taxa2","line":275},{"containerName":"new","kind":13,"name":"$top","line":275},{"definition":"my","line":278,"name":"$ystep1","localvar":"my","kind":13,"containerName":"new"},{"line":278,"containerName":"new","kind":13,"name":"$height"},{"line":278,"name":"@taxa1","kind":13,"containerName":"new"},{"definition":"my","name":"$ystep2","kind":13,"localvar":"my","containerName":"new","line":279},{"line":280,"containerName":"new","kind":13,"name":"$t2"},{"line":281,"containerName":"new","kind":13,"name":"$ystep2"},{"containerName":"new","kind":13,"name":"$height","line":281},{"line":281,"containerName":"new","kind":13,"name":"@taxa2"},{"definition":"my","name":"$x","kind":13,"localvar":"my","containerName":"new","line":284},{"kind":13,"containerName":"new","name":"$left","line":284},{"name":"$xstep","containerName":"new","kind":13,"line":284},{"name":"$root1","containerName":"new","kind":13,"line":284},{"name":"height","kind":12,"containerName":"new","line":284},{"containerName":"new","kind":13,"name":"$tip","line":284},{"line":285,"localvar":"my","kind":13,"containerName":"new","name":"$y","definition":"my"},{"name":"$bottom","containerName":"new","kind":13,"line":285},{"name":"$taxon","localvar":"my","containerName":"new","kind":13,"line":287,"definition":"my"},{"line":287,"kind":13,"containerName":"new","name":"@taxa1"},{"line":288,"containerName":"new","kind":13,"name":"$xx"},{"name":"$taxon","containerName":"new","kind":13,"line":288},{"line":288,"name":"$x","containerName":"new","kind":13},{"line":288,"containerName":"new","kind":13,"name":"$tip"},{"line":289,"name":"$yy","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$taxon","line":289},{"kind":13,"containerName":"new","name":"$y","line":289},{"line":290,"name":"$y","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$ystep1","line":290},{"kind":13,"containerName":"new","name":"$x","line":292},{"kind":13,"containerName":"new","name":"$xstep","line":292},{"line":294,"kind":13,"localvar":"my","containerName":"new","name":"@stack","definition":"my"},{"line":295,"localvar":"my","containerName":"new","kind":13,"name":"@queue","definition":"my"},{"line":296,"kind":13,"containerName":"new","name":"@stack"},{"containerName":"new","kind":13,"name":"$t1","line":296},{"line":296,"kind":12,"containerName":"new","name":"get_root_node"},{"line":297,"containerName":"new","kind":13,"name":"@stack"},{"definition":"my","localvar":"my","kind":13,"containerName":"new","name":"$node","line":298},{"line":298,"name":"@stack","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"@queue","line":299},{"containerName":"new","kind":13,"name":"$node","line":299},{"localvar":"my","containerName":"new","kind":13,"name":"$child","line":300,"definition":"my"},{"containerName":"new","kind":13,"name":"$node","line":300},{"containerName":"new","kind":12,"name":"each_Descendent","line":300},{"name":"@stack","kind":13,"containerName":"new","line":301},{"line":301,"containerName":"new","kind":13,"name":"$child"},{"containerName":"new","kind":13,"name":"@queue","line":304},{"name":"@queue","kind":13,"containerName":"new","line":304},{"line":306,"kind":13,"localvar":"my","containerName":"new","name":"$node","definition":"my"},{"name":"@queue","containerName":"new","kind":13,"line":306},{"line":307,"name":"$node","containerName":"new","kind":13},{"line":307,"kind":12,"containerName":"new","name":"is_Leaf"},{"definition":"my","line":308,"name":"@children","kind":13,"localvar":"my","containerName":"new"},{"line":308,"containerName":"new","kind":13,"name":"$node"},{"line":308,"containerName":"new","kind":12,"name":"each_Descendent"},{"line":309,"name":"$child","localvar":"my","kind":13,"containerName":"new","definition":"my"},{"name":"@children","containerName":"new","kind":13,"line":309},{"definition":"my","line":310,"kind":13,"localvar":"my","containerName":"new","name":"$xmin"},{"kind":13,"containerName":"new","name":"$xx","line":310},{"containerName":"new","kind":13,"name":"$child","line":310},{"definition":"my","localvar":"my","containerName":"new","kind":13,"name":"$ymin","line":311},{"definition":"my","name":"$ymax","containerName":"new","localvar":"my","kind":13,"line":311},{"line":311,"name":"$yy","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$child","line":311},{"line":312,"name":"$child","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"@children","line":312},{"line":313,"name":"$xmin","kind":13,"containerName":"new"},{"line":313,"containerName":"new","kind":13,"name":"$xx"},{"kind":13,"containerName":"new","name":"$child","line":313},{"line":313,"containerName":"new","kind":13,"name":"$xx"},{"line":313,"containerName":"new","kind":13,"name":"$child"},{"containerName":"new","kind":13,"name":"$xmin","line":313},{"line":314,"name":"$ymax","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$yy","line":314},{"containerName":"new","kind":13,"name":"$child","line":314},{"line":314,"name":"$yy","containerName":"new","kind":13},{"line":314,"containerName":"new","kind":13,"name":"$child"},{"line":314,"containerName":"new","kind":13,"name":"$ymax"},{"line":315,"containerName":"new","kind":13,"name":"$ymin"},{"name":"$yy","kind":13,"containerName":"new","line":315},{"kind":13,"containerName":"new","name":"$child","line":315},{"name":"$yy","kind":13,"containerName":"new","line":315},{"kind":13,"containerName":"new","name":"$child","line":315},{"line":315,"kind":13,"containerName":"new","name":"$ymin"},{"line":317,"name":"$xx","kind":13,"containerName":"new"},{"line":317,"name":"$node","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$xmin","line":317},{"name":"$xstep","containerName":"new","kind":13,"line":317},{"name":"$yy","containerName":"new","kind":13,"line":318},{"name":"$node","kind":13,"containerName":"new","line":318},{"name":"$ymin","containerName":"new","kind":13,"line":318},{"line":318,"name":"$ymax","kind":13,"containerName":"new"},{"line":322,"containerName":"new","kind":13,"name":"$xx"},{"line":322,"kind":13,"containerName":"new","name":"$t1"},{"line":322,"containerName":"new","kind":12,"name":"get_root_node"},{"line":322,"containerName":"new","kind":13,"name":"$left"},{"name":"$xstep","containerName":"new","kind":13,"line":322},{"line":324,"name":"@preorder","localvar":"my","containerName":"new","kind":13,"definition":"my"},{"line":324,"containerName":"new","kind":13,"name":"$t1"},{"name":"get_nodes","containerName":"new","kind":12,"line":324},{"definition":"my","name":"$node","containerName":"new","localvar":"my","kind":13,"line":326},{"containerName":"new","kind":13,"name":"@preorder","line":326},{"name":"$colors","containerName":"new","kind":13,"line":328},{"name":"$node","kind":13,"containerName":"new","line":329},{"name":"has_tag","kind":12,"containerName":"new","line":329},{"line":330,"kind":13,"containerName":"new","name":"$Rcolor"},{"name":"$node","containerName":"new","kind":13,"line":330},{"line":330,"name":"$node","containerName":"new","kind":13},{"kind":12,"containerName":"new","name":"get_tag_values","line":330},{"kind":13,"containerName":"new","name":"$Rcolor","line":332},{"name":"$node","kind":13,"containerName":"new","line":332},{"line":334,"name":"$node","containerName":"new","kind":13},{"line":334,"containerName":"new","kind":12,"name":"has_tag"},{"kind":13,"containerName":"new","name":"$Gcolor","line":335},{"containerName":"new","kind":13,"name":"$node","line":335},{"line":335,"containerName":"new","kind":13,"name":"$node"},{"line":335,"name":"get_tag_values","kind":12,"containerName":"new"},{"name":"$Gcolor","kind":13,"containerName":"new","line":337},{"name":"$node","kind":13,"containerName":"new","line":337},{"containerName":"new","kind":13,"name":"$node","line":339},{"name":"has_tag","containerName":"new","kind":12,"line":339},{"line":340,"name":"$Bcolor","containerName":"new","kind":13},{"line":340,"containerName":"new","kind":13,"name":"$node"},{"line":340,"name":"$node","kind":13,"containerName":"new"},{"line":340,"kind":12,"containerName":"new","name":"get_tag_values"},{"line":342,"name":"$Bcolor","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$node","line":342},{"line":348,"containerName":"new","kind":13,"name":"$compact"},{"name":"$width","kind":13,"containerName":"new","line":350},{"line":351,"containerName":"new","kind":13,"name":"@preorder"},{"name":"$node","localvar":"my","kind":13,"containerName":"new","line":352,"definition":"my"},{"containerName":"new","kind":13,"name":"@preorder","line":352},{"name":"$xx","containerName":"new","kind":13,"line":353},{"name":"$node","containerName":"new","kind":13,"line":353},{"name":"$xx","kind":13,"containerName":"new","line":353},{"line":353,"containerName":"new","kind":13,"name":"$node"},{"line":353,"containerName":"new","kind":12,"name":"ancestor"},{"name":"$xstep","containerName":"new","kind":13,"line":353},{"name":"$width","containerName":"new","kind":13,"line":354},{"containerName":"new","kind":13,"name":"$xx","line":354},{"line":354,"kind":13,"containerName":"new","name":"$node"},{"line":354,"name":"$xx","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$node","line":354},{"line":354,"kind":13,"containerName":"new","name":"$width"},{"line":356,"kind":13,"containerName":"new","name":"$width"},{"line":356,"name":"$tip","kind":13,"containerName":"new"},{"line":356,"name":"$tipwidth1","kind":13,"containerName":"new"},{"name":"$right","kind":13,"containerName":"new","line":356},{"line":360,"name":"$total_height","localvar":"my","containerName":"new","kind":13,"definition":"my"},{"line":360,"kind":13,"containerName":"new","name":"$t1"},{"containerName":"new","kind":12,"name":"get_leaf_nodes","line":360},{"line":360,"name":"$ystep","kind":13,"containerName":"new"},{"containerName":"new","localvar":"my","kind":13,"name":"$scale_factor","line":361,"definition":"my"},{"line":361,"containerName":"new","kind":13,"name":"$total_height"},{"line":361,"containerName":"new","kind":13,"name":"$ratio"},{"line":361,"containerName":"new","kind":13,"name":"$t1"},{"containerName":"new","kind":12,"name":"get_root_node","line":361},{"containerName":"new","kind":12,"name":"height","line":361},{"line":363,"name":"$width","containerName":"new","kind":13},{"line":363,"name":"$t1","containerName":"new","kind":13},{"containerName":"new","kind":12,"name":"get_root_node","line":363},{"line":363,"name":"height","kind":12,"containerName":"new"},{"line":363,"name":"$scale_factor","containerName":"new","kind":13},{"line":364,"containerName":"new","kind":13,"name":"$width"},{"line":364,"kind":13,"containerName":"new","name":"$left"},{"name":"$xstep","kind":13,"containerName":"new","line":364},{"line":365,"name":"$width","kind":13,"containerName":"new"},{"line":365,"containerName":"new","kind":13,"name":"$tip"},{"containerName":"new","kind":13,"name":"$tipwidth1","line":365},{"line":365,"name":"$right","kind":13,"containerName":"new"},{"line":367,"name":"@preorder","kind":13,"containerName":"new"},{"definition":"my","line":368,"name":"$node","localvar":"my","kind":13,"containerName":"new"},{"name":"@preorder","containerName":"new","kind":13,"line":368},{"definition":"my","line":369,"name":"$bl","localvar":"my","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$node","line":369},{"name":"branch_length","kind":12,"containerName":"new","line":369},{"line":370,"kind":13,"containerName":"new","name":"$bl"},{"line":370,"name":"$bl","kind":13,"containerName":"new"},{"name":"$bl","containerName":"new","kind":13,"line":370},{"containerName":"new","kind":13,"name":"$xx","line":371},{"name":"$node","containerName":"new","kind":13,"line":371},{"line":371,"name":"$xx","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$node","line":371},{"line":371,"name":"ancestor","kind":12,"containerName":"new"},{"kind":13,"containerName":"new","name":"$bl","line":371},{"line":371,"containerName":"new","kind":13,"name":"$scale_factor"},{"line":376,"name":"$t2","containerName":"new","kind":13},{"line":378,"name":"$x","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$left","line":378},{"kind":13,"containerName":"new","name":"$xstep","line":378},{"line":378,"containerName":"new","kind":13,"name":"$root1"},{"name":"height","containerName":"new","kind":12,"line":378},{"containerName":"new","kind":13,"name":"$tip","line":378},{"containerName":"new","kind":13,"name":"$x","line":379},{"kind":13,"containerName":"new","name":"$tipwidth1","line":379},{"line":379,"containerName":"new","kind":13,"name":"$tip"},{"line":379,"name":"$column","containerName":"new","kind":13},{"line":379,"name":"$tip","containerName":"new","kind":13},{"definition":"my","name":"$y","localvar":"my","containerName":"new","kind":13,"line":380},{"name":"$bottom","kind":13,"containerName":"new","line":380},{"line":382,"kind":13,"localvar":"my","containerName":"new","name":"$taxon","definition":"my"},{"name":"@taxa2","kind":13,"containerName":"new","line":382},{"name":"$xx","kind":13,"containerName":"new","line":383},{"kind":13,"containerName":"new","name":"$taxon","line":383},{"line":383,"kind":13,"containerName":"new","name":"$x"},{"name":"$tipwidth2","kind":13,"containerName":"new","line":383},{"name":"$tip","containerName":"new","kind":13,"line":383},{"line":384,"name":"$yy","containerName":"new","kind":13},{"line":384,"name":"$taxon","kind":13,"containerName":"new"},{"line":384,"containerName":"new","kind":13,"name":"$y"},{"kind":13,"containerName":"new","name":"$y","line":385},{"line":385,"containerName":"new","kind":13,"name":"$ystep2"},{"kind":13,"containerName":"new","name":"$x","line":387},{"containerName":"new","kind":13,"name":"$xstep","line":387},{"name":"@stack","localvar":"my","containerName":"new","kind":13,"line":389,"definition":"my"},{"line":390,"name":"@queue","localvar":"my","containerName":"new","kind":13,"definition":"my"},{"containerName":"new","kind":13,"name":"@stack","line":391},{"name":"$t2","containerName":"new","kind":13,"line":391},{"name":"get_root_node","containerName":"new","kind":12,"line":391},{"line":392,"kind":13,"containerName":"new","name":"@stack"},{"line":393,"name":"$node","localvar":"my","containerName":"new","kind":13,"definition":"my"},{"line":393,"kind":13,"containerName":"new","name":"@stack"},{"name":"@queue","kind":13,"containerName":"new","line":394},{"name":"$node","kind":13,"containerName":"new","line":394},{"name":"$child","localvar":"my","containerName":"new","kind":13,"line":395,"definition":"my"},{"kind":13,"containerName":"new","name":"$node","line":395},{"line":395,"name":"each_Descendent","kind":12,"containerName":"new"},{"kind":13,"containerName":"new","name":"@stack","line":396},{"line":396,"containerName":"new","kind":13,"name":"$child"},{"containerName":"new","kind":13,"name":"@queue","line":399},{"line":399,"kind":13,"containerName":"new","name":"@queue"},{"line":401,"localvar":"my","containerName":"new","kind":13,"name":"$node","definition":"my"},{"kind":13,"containerName":"new","name":"@queue","line":401},{"line":402,"name":"$node","kind":13,"containerName":"new"},{"line":402,"name":"is_Leaf","kind":12,"containerName":"new"},{"localvar":"my","containerName":"new","kind":13,"name":"@children","line":403,"definition":"my"},{"containerName":"new","kind":13,"name":"$node","line":403},{"line":403,"name":"each_Descendent","containerName":"new","kind":12},{"definition":"my","name":"$child","kind":13,"localvar":"my","containerName":"new","line":404},{"line":404,"kind":13,"containerName":"new","name":"@children"},{"definition":"my","name":"$xmax","localvar":"my","containerName":"new","kind":13,"line":405},{"line":405,"kind":13,"containerName":"new","name":"$xx"},{"line":405,"name":"$child","containerName":"new","kind":13},{"definition":"my","name":"$ymin","localvar":"my","kind":13,"containerName":"new","line":406},{"definition":"my","line":406,"localvar":"my","containerName":"new","kind":13,"name":"$ymax"},{"line":406,"containerName":"new","kind":13,"name":"$yy"},{"line":406,"name":"$child","kind":13,"containerName":"new"},{"name":"$child","containerName":"new","kind":13,"line":407},{"line":407,"name":"@children","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$xmax","line":408},{"containerName":"new","kind":13,"name":"$xx","line":408},{"name":"$child","containerName":"new","kind":13,"line":408},{"line":408,"name":"$xx","kind":13,"containerName":"new"},{"line":408,"kind":13,"containerName":"new","name":"$child"},{"name":"$xmax","kind":13,"containerName":"new","line":408},{"name":"$ymax","kind":13,"containerName":"new","line":409},{"line":409,"name":"$yy","kind":13,"containerName":"new"},{"line":409,"name":"$child","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$yy","line":409},{"line":409,"kind":13,"containerName":"new","name":"$child"},{"line":409,"name":"$ymax","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$ymin","line":410},{"line":410,"name":"$yy","kind":13,"containerName":"new"},{"name":"$child","containerName":"new","kind":13,"line":410},{"line":410,"kind":13,"containerName":"new","name":"$yy"},{"name":"$child","containerName":"new","kind":13,"line":410},{"line":410,"name":"$ymin","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$xx","line":412},{"name":"$node","containerName":"new","kind":13,"line":412},{"containerName":"new","kind":13,"name":"$xmax","line":412},{"name":"$xstep","containerName":"new","kind":13,"line":412},{"containerName":"new","kind":13,"name":"$yy","line":413},{"line":413,"name":"$node","containerName":"new","kind":13},{"name":"$ymin","containerName":"new","kind":13,"line":413},{"line":413,"name":"$ymax","containerName":"new","kind":13},{"line":419,"name":"$self","kind":13,"containerName":"new"}],"detail":"($class,@args)","definition":"sub"},{"line":178,"name":"SUPER","kind":12,"containerName":"new"},{"name":"PostScript","containerName":"Metrics::stringwidth","kind":12,"line":246},{"containerName":"Metrics::stringwidth","kind":12,"name":"PostScript","line":260},{"name":"print","containerName":"main::","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"print","line":433},{"line":433,"kind":13,"containerName":"print","name":"@args"},{"line":435,"name":"$file","localvar":"my","kind":13,"containerName":"print","definition":"my"},{"containerName":"print","kind":13,"name":"$self","line":435},{"name":"_rearrange","kind":12,"containerName":"print","line":435},{"line":435,"containerName":"print","kind":13,"name":"@args"},{"line":436,"name":"$file","containerName":"print","kind":13},{"line":438,"kind":13,"localvar":"my","containerName":"print","name":"$INFO","definition":"my"},{"kind":13,"containerName":"print","name":"$file","line":438},{"line":439,"containerName":"print","kind":13,"name":"$INFO"},{"line":440,"containerName":"print","kind":13,"name":"$INFO"},{"line":440,"name":"$width","containerName":"print","kind":13},{"name":"$height","containerName":"print","kind":13,"line":440},{"kind":13,"containerName":"print","name":"$INFO","line":441},{"line":442,"name":"$INFO","kind":13,"containerName":"print"},{"line":443,"name":"$INFO","kind":13,"containerName":"print"},{"line":444,"containerName":"print","kind":13,"name":"$INFO"},{"line":448,"containerName":"print","localvar":"my","kind":13,"name":"$taxon","definition":"my"},{"containerName":"print","kind":13,"name":"$t1","line":448},{"line":448,"kind":12,"containerName":"print","name":"get_leaf_nodes"},{"name":"$colors","containerName":"print","kind":13,"line":449},{"line":450,"containerName":"print","kind":13,"name":"$INFO"},{"line":450,"name":"$Rcolor","containerName":"print","kind":13},{"line":450,"containerName":"print","kind":13,"name":"$taxon"},{"line":450,"kind":13,"containerName":"print","name":"$Gcolor"},{"line":450,"containerName":"print","kind":13,"name":"$taxon"},{"line":450,"containerName":"print","kind":13,"name":"$Bcolor"},{"line":450,"kind":13,"containerName":"print","name":"$taxon"},{"line":452,"containerName":"print","kind":13,"name":"$INFO"},{"line":452,"kind":13,"containerName":"print","name":"$xx"},{"containerName":"print","kind":13,"name":"$taxon","line":452},{"line":452,"name":"$tip","containerName":"print","kind":13},{"kind":13,"containerName":"print","name":"$yy","line":452},{"name":"$taxon","containerName":"print","kind":13,"line":452},{"line":452,"containerName":"print","kind":13,"name":"$size"},{"kind":13,"containerName":"print","name":"$INFO","line":453},{"name":"$taxon","containerName":"print","kind":13,"line":453},{"name":"id","kind":12,"containerName":"print","line":453},{"definition":"my","line":456,"kind":13,"localvar":"my","containerName":"print","name":"$root1"},{"line":456,"containerName":"print","kind":13,"name":"$t1"},{"line":456,"name":"get_root_node","containerName":"print","kind":12},{"line":457,"name":"$node","localvar":"my","containerName":"print","kind":13,"definition":"my"},{"line":457,"name":"$t1","kind":13,"containerName":"print"},{"kind":12,"containerName":"print","name":"get_nodes","line":457},{"line":458,"containerName":"print","kind":13,"name":"$node"},{"kind":12,"containerName":"print","name":"ancestor","line":458},{"line":461,"name":"$colors","containerName":"print","kind":13},{"name":"$INFO","containerName":"print","kind":13,"line":462},{"name":"$INFO","containerName":"print","kind":13,"line":463},{"containerName":"print","kind":13,"name":"$Rcolor","line":463},{"containerName":"print","kind":13,"name":"$node","line":463},{"kind":13,"containerName":"print","name":"$Gcolor","line":463},{"line":463,"kind":13,"containerName":"print","name":"$node"},{"kind":13,"containerName":"print","name":"$Bcolor","line":464},{"containerName":"print","kind":13,"name":"$node","line":464},{"name":"$INFO","kind":13,"containerName":"print","line":466},{"name":"$xx","containerName":"print","kind":13,"line":466},{"line":466,"name":"$node","containerName":"print","kind":13},{"kind":13,"containerName":"print","name":"$yy","line":466},{"name":"$node","kind":13,"containerName":"print","line":466},{"name":"$INFO","kind":13,"containerName":"print","line":467},{"line":467,"kind":13,"containerName":"print","name":"$xx"},{"line":467,"containerName":"print","kind":13,"name":"$node"},{"line":467,"name":"ancestor","containerName":"print","kind":12},{"kind":13,"containerName":"print","name":"$yy","line":467},{"line":467,"name":"$node","containerName":"print","kind":13},{"containerName":"print","kind":13,"name":"$bootstrap","line":468},{"name":"$INFO","kind":13,"containerName":"print","line":469},{"name":"$xx","kind":13,"containerName":"print","line":469},{"line":469,"name":"$node","kind":13,"containerName":"print"},{"containerName":"print","kind":12,"name":"ancestor","line":469},{"name":"$size","containerName":"print","kind":13,"line":469},{"containerName":"print","kind":13,"name":"$yy","line":469},{"name":"$node","containerName":"print","kind":13,"line":469},{"line":469,"kind":12,"containerName":"print","name":"ancestor"},{"name":"$size","kind":13,"containerName":"print","line":469},{"kind":13,"containerName":"print","name":"$INFO","line":470},{"line":470,"name":"$node","containerName":"print","kind":13},{"line":470,"containerName":"print","kind":12,"name":"ancestor"},{"line":470,"kind":12,"containerName":"print","name":"id"},{"containerName":"print","kind":13,"name":"$INFO","line":471},{"line":471,"name":"$xx","kind":13,"containerName":"print"},{"line":471,"containerName":"print","kind":13,"name":"$node"},{"containerName":"print","kind":12,"name":"ancestor","line":471},{"name":"$yy","containerName":"print","kind":13,"line":471},{"containerName":"print","kind":13,"name":"$node","line":471},{"name":"$INFO","kind":13,"containerName":"print","line":473},{"line":473,"containerName":"print","kind":13,"name":"$xx"},{"containerName":"print","kind":13,"name":"$node","line":473},{"line":473,"kind":12,"containerName":"print","name":"ancestor"},{"name":"$yy","containerName":"print","kind":13,"line":473},{"line":473,"name":"$node","kind":13,"containerName":"print"},{"name":"ancestor","containerName":"print","kind":12,"line":473},{"definition":"my","containerName":"print","localvar":"my","kind":13,"name":"$ymin","line":478},{"line":478,"name":"$yy","containerName":"print","kind":13},{"line":478,"name":"$root1","containerName":"print","kind":13},{"line":479,"localvar":"my","kind":13,"containerName":"print","name":"$ymax","definition":"my"},{"line":479,"kind":13,"containerName":"print","name":"$yy"},{"line":479,"kind":13,"containerName":"print","name":"$root1"},{"localvar":"my","kind":13,"containerName":"print","name":"$child","line":480,"definition":"my"},{"line":480,"name":"$root1","containerName":"print","kind":13},{"line":480,"name":"each_Descendent","containerName":"print","kind":12},{"name":"$ymax","containerName":"print","kind":13,"line":481},{"name":"$yy","kind":13,"containerName":"print","line":481},{"line":481,"kind":13,"containerName":"print","name":"$child"},{"line":481,"containerName":"print","kind":13,"name":"$yy"},{"name":"$child","kind":13,"containerName":"print","line":481},{"containerName":"print","kind":13,"name":"$ymax","line":481},{"containerName":"print","kind":13,"name":"$ymin","line":482},{"containerName":"print","kind":13,"name":"$yy","line":482},{"name":"$child","containerName":"print","kind":13,"line":482},{"line":482,"containerName":"print","kind":13,"name":"$yy"},{"kind":13,"containerName":"print","name":"$child","line":482},{"line":482,"kind":13,"containerName":"print","name":"$ymin"},{"name":"$zz","localvar":"my","kind":13,"containerName":"print","line":484,"definition":"my"},{"kind":13,"containerName":"print","name":"$ymin","line":484},{"line":484,"containerName":"print","kind":13,"name":"$ymax"},{"line":485,"name":"$colors","containerName":"print","kind":13},{"name":"$INFO","kind":13,"containerName":"print","line":486},{"name":"$INFO","kind":13,"containerName":"print","line":487},{"line":487,"kind":13,"containerName":"print","name":"$Rcolor"},{"line":487,"name":"$root1","kind":13,"containerName":"print"},{"containerName":"print","kind":13,"name":"$Gcolor","line":487},{"line":487,"containerName":"print","kind":13,"name":"$root1"},{"line":487,"kind":13,"containerName":"print","name":"$Bcolor"},{"containerName":"print","kind":13,"name":"$root1","line":487},{"line":489,"containerName":"print","kind":13,"name":"$INFO"},{"line":489,"kind":13,"containerName":"print","name":"$xx"},{"line":489,"kind":13,"containerName":"print","name":"$root1"},{"kind":13,"containerName":"print","name":"$zz","line":489},{"line":490,"name":"$INFO","containerName":"print","kind":13},{"line":490,"containerName":"print","kind":13,"name":"$xx"},{"name":"$root1","containerName":"print","kind":13,"line":490},{"name":"$xstep","containerName":"print","kind":13,"line":490},{"line":490,"kind":13,"containerName":"print","name":"$zz"},{"line":492,"kind":13,"containerName":"print","name":"$t2"},{"name":"$taxon","localvar":"my","kind":13,"containerName":"print","line":494,"definition":"my"},{"name":"$t2","containerName":"print","kind":13,"line":494},{"name":"get_leaf_nodes","kind":12,"containerName":"print","line":494},{"definition":"my","name":"$tiplen2","containerName":"print","localvar":"my","kind":13,"line":495},{"line":495,"containerName":"print","kind":13,"name":"$taxon"},{"name":"id","containerName":"print","kind":12,"line":495},{"name":"$font","containerName":"print","kind":13,"line":495},{"line":495,"kind":13,"containerName":"print","name":"$size"},{"containerName":"print","kind":13,"name":"$INFO","line":496},{"name":"$xx","containerName":"print","kind":13,"line":496},{"line":496,"name":"$taxon","kind":13,"containerName":"print"},{"line":496,"name":"$tiplen2","containerName":"print","kind":13},{"line":496,"kind":13,"containerName":"print","name":"$tip"},{"line":497,"name":"$yy","containerName":"print","kind":13},{"name":"$taxon","containerName":"print","kind":13,"line":497},{"line":497,"kind":13,"containerName":"print","name":"$size"},{"containerName":"print","kind":13,"name":"$INFO","line":498},{"line":498,"name":"$taxon","containerName":"print","kind":13},{"line":498,"name":"id","kind":12,"containerName":"print"},{"name":"$node","containerName":"print","localvar":"my","kind":13,"line":501,"definition":"my"},{"line":501,"kind":13,"containerName":"print","name":"$t2"},{"name":"get_nodes","kind":12,"containerName":"print","line":501},{"containerName":"print","kind":13,"name":"$node","line":502},{"containerName":"print","kind":12,"name":"ancestor","line":502},{"name":"$INFO","containerName":"print","kind":13,"line":503},{"name":"$xx","containerName":"print","kind":13,"line":503},{"line":503,"kind":13,"containerName":"print","name":"$node"},{"name":"$yy","kind":13,"containerName":"print","line":503},{"line":503,"name":"$node","containerName":"print","kind":13},{"line":504,"kind":13,"containerName":"print","name":"$INFO"},{"name":"$xx","containerName":"print","kind":13,"line":504},{"line":504,"containerName":"print","kind":13,"name":"$node"},{"line":504,"containerName":"print","kind":12,"name":"ancestor"},{"name":"$yy","containerName":"print","kind":13,"line":504},{"line":504,"containerName":"print","kind":13,"name":"$node"},{"name":"$INFO","kind":13,"containerName":"print","line":505},{"line":505,"kind":13,"containerName":"print","name":"$xx"},{"line":505,"name":"$node","kind":13,"containerName":"print"},{"line":505,"name":"ancestor","containerName":"print","kind":12},{"name":"$yy","kind":13,"containerName":"print","line":506},{"line":506,"name":"$node","containerName":"print","kind":13},{"line":506,"name":"ancestor","containerName":"print","kind":12},{"line":510,"kind":13,"localvar":"my","containerName":"print","name":"$root2","definition":"my"},{"line":510,"name":"$t2","kind":13,"containerName":"print"},{"line":510,"name":"get_root_node","kind":12,"containerName":"print"},{"line":511,"name":"$ymin","localvar":"my","containerName":"print","kind":13,"definition":"my"},{"line":511,"name":"$yy","kind":13,"containerName":"print"},{"line":511,"name":"$root2","containerName":"print","kind":13},{"line":512,"name":"$ymax","containerName":"print","localvar":"my","kind":13,"definition":"my"},{"line":512,"name":"$yy","kind":13,"containerName":"print"},{"line":512,"name":"$root2","kind":13,"containerName":"print"},{"line":513,"localvar":"my","containerName":"print","kind":13,"name":"$child2","definition":"my"},{"name":"$root2","containerName":"print","kind":13,"line":513},{"name":"each_Descendent","containerName":"print","kind":12,"line":513},{"name":"$ymax","kind":13,"containerName":"print","line":514},{"name":"$yy","kind":13,"containerName":"print","line":514},{"name":"$child2","kind":13,"containerName":"print","line":514},{"name":"$yy","containerName":"print","kind":13,"line":514},{"line":514,"name":"$child2","containerName":"print","kind":13},{"line":514,"kind":13,"containerName":"print","name":"$ymax"},{"name":"$ymin","containerName":"print","kind":13,"line":515},{"kind":13,"containerName":"print","name":"$yy","line":515},{"line":515,"name":"$child2","containerName":"print","kind":13},{"name":"$yy","containerName":"print","kind":13,"line":515},{"name":"$child2","containerName":"print","kind":13,"line":515},{"name":"$ymin","containerName":"print","kind":13,"line":515},{"name":"$zz","localvar":"my","kind":13,"containerName":"print","line":517,"definition":"my"},{"line":517,"containerName":"print","kind":13,"name":"$ymin"},{"line":517,"name":"$ymax","kind":13,"containerName":"print"},{"name":"$INFO","containerName":"print","kind":13,"line":518},{"kind":13,"containerName":"print","name":"$xx","line":518},{"line":518,"name":"$root2","containerName":"print","kind":13},{"name":"$zz","containerName":"print","kind":13,"line":518},{"name":"$INFO","kind":13,"containerName":"print","line":519},{"line":519,"containerName":"print","kind":13,"name":"$xx"},{"line":519,"name":"$root2","containerName":"print","kind":13},{"line":519,"name":"$xstep","kind":13,"containerName":"print"},{"containerName":"print","kind":13,"name":"$zz","line":519},{"kind":13,"localvar":"my","containerName":"print","name":"@taxa1","line":521,"definition":"my"},{"name":"$t1","kind":13,"containerName":"print","line":521},{"name":"get_leaf_nodes","containerName":"print","kind":12,"line":521},{"definition":"my","line":522,"name":"@taxa2","localvar":"my","containerName":"print","kind":13},{"line":522,"containerName":"print","kind":13,"name":"$t2"},{"name":"get_leaf_nodes","kind":12,"containerName":"print","line":522},{"definition":"my","line":527,"name":"$taxon1","localvar":"my","kind":13,"containerName":"print"},{"name":"@taxa1","kind":13,"containerName":"print","line":527},{"localvar":"my","containerName":"print","kind":13,"name":"$taxon2","line":528,"definition":"my"},{"name":"@taxa2","containerName":"print","kind":13,"line":528},{"line":529,"containerName":"print","kind":13,"name":"$taxon1"},{"containerName":"print","kind":12,"name":"id","line":529},{"line":529,"kind":13,"containerName":"print","name":"$taxon2"},{"line":529,"kind":12,"containerName":"print","name":"id"},{"line":530,"name":"$taxon1","kind":13,"containerName":"print"},{"line":530,"containerName":"print","kind":12,"name":"add_tag_value"},{"kind":13,"containerName":"print","name":"$taxon2","line":530},{"name":"$INFO","containerName":"print","kind":13,"line":538},{"name":"$INFO","containerName":"print","kind":13,"line":539},{"kind":13,"localvar":"my","containerName":"print","name":"$taxon1","line":541,"definition":"my"},{"line":541,"kind":13,"containerName":"print","name":"@taxa1"},{"definition":"my","name":"@match","localvar":"my","kind":13,"containerName":"print","line":542},{"line":542,"name":"$taxon1","containerName":"print","kind":13},{"line":542,"name":"get_tag_values","kind":12,"containerName":"print"},{"line":543,"localvar":"my","containerName":"print","kind":13,"name":"$taxon2","definition":"my"},{"kind":13,"containerName":"print","name":"@match","line":543},{"definition":"my","kind":13,"localvar":"my","containerName":"print","name":"$x0","line":544},{"line":544,"containerName":"print","kind":13,"name":"$xx"},{"containerName":"print","kind":13,"name":"$taxon1","line":544},{"containerName":"print","kind":13,"name":"$tip","line":545},{"kind":13,"containerName":"print","name":"$taxon1","line":545},{"name":"id","kind":12,"containerName":"print","line":545},{"name":"$font","kind":13,"containerName":"print","line":545},{"line":545,"name":"$size","containerName":"print","kind":13},{"name":"$tip","containerName":"print","kind":13,"line":545},{"definition":"my","localvar":"my","kind":13,"containerName":"print","name":"$x1","line":546},{"name":"$xx","kind":13,"containerName":"print","line":546},{"name":"$taxon1","containerName":"print","kind":13,"line":546},{"line":546,"containerName":"print","kind":13,"name":"$tip"},{"containerName":"print","kind":13,"name":"$tipwidth1","line":546},{"line":546,"containerName":"print","kind":13,"name":"$tip"},{"name":"$y1","localvar":"my","kind":13,"containerName":"print","line":547,"definition":"my"},{"name":"$yy","containerName":"print","kind":13,"line":547},{"kind":13,"containerName":"print","name":"$taxon1","line":547},{"containerName":"print","localvar":"my","kind":13,"name":"$x2","line":548,"definition":"my"},{"line":548,"containerName":"print","kind":13,"name":"$xx"},{"containerName":"print","kind":13,"name":"$taxon2","line":548},{"line":548,"kind":13,"containerName":"print","name":"$tip"},{"name":"$tipwidth2","containerName":"print","kind":13,"line":548},{"containerName":"print","kind":13,"name":"$tip","line":548},{"name":"$x3","localvar":"my","kind":13,"containerName":"print","line":549,"definition":"my"},{"line":549,"name":"$xx","kind":13,"containerName":"print"},{"name":"$taxon2","kind":13,"containerName":"print","line":549},{"kind":13,"containerName":"print","name":"$tip","line":550},{"line":550,"name":"$taxon2","containerName":"print","kind":13},{"containerName":"print","kind":12,"name":"id","line":550},{"containerName":"print","kind":13,"name":"$font","line":550},{"kind":13,"containerName":"print","name":"$size","line":550},{"line":550,"name":"$tip","kind":13,"containerName":"print"},{"line":551,"containerName":"print","localvar":"my","kind":13,"name":"$y2","definition":"my"},{"line":551,"containerName":"print","kind":13,"name":"$yy"},{"containerName":"print","kind":13,"name":"$taxon2","line":551},{"line":552,"containerName":"print","kind":13,"name":"$INFO"},{"line":552,"name":"$x0","containerName":"print","kind":13},{"name":"$y1","containerName":"print","kind":13,"line":552},{"line":553,"name":"$INFO","kind":13,"containerName":"print"},{"kind":13,"containerName":"print","name":"$x1","line":553},{"kind":13,"containerName":"print","name":"$y1","line":553},{"name":"$INFO","containerName":"print","kind":13,"line":554},{"name":"$x2","kind":13,"containerName":"print","line":554},{"name":"$y2","containerName":"print","kind":13,"line":554},{"containerName":"print","kind":13,"name":"$INFO","line":555},{"line":555,"kind":13,"containerName":"print","name":"$x3"},{"kind":13,"containerName":"print","name":"$y2","line":555},{"line":561,"kind":13,"containerName":"print","name":"$INFO"},{"name":"$INFO","kind":13,"containerName":"print","line":562}],"detail":"($self,@args)","definition":"sub","range":{"start":{"line":432,"character":0},"end":{"character":9999,"line":563}},"kind":12,"line":432,"signature":{"label":"print($self,@args)","documentation":"1;\n# $Id: Cladogram.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Cladogram\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Valiente <valiente@lsi.upc.edu>\n#\n# Copyright Gabriel Valiente\n#\n# You may distribute this module under the same terms as Perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::Draw::Cladogram - Drawing phylogenetic trees in\nEncapsulated PostScript (EPS) format.\n\n=head1 SYNOPSIS\n\n  use Bio::Tree::Draw::Cladogram;\n  use Bio::TreeIO;\n  my $treeio = Bio::TreeIO->new('-format' => 'newick',\n  \t\t\t       '-file'   => 'input.nwk');\n  my $t1 = $treeio->next_tree;\n  my $t2 = $treeio->next_tree;\n\n  my $obj1 = Bio::Tree::Draw::Cladogram->new(-tree => $t1);\n  $obj1->print(-file => 'cladogram.eps');\n\n  if ($t2) {\n    my $obj2 = Bio::Tree::Draw::Cladogram->new(-tree => $t1, -second => $t2);\n    $obj2->print(-file => 'tanglegram.eps');\n  }\n\n=head1 DESCRIPTION\n\nBio::Tree::Draw::Cladogram is a Perl tool for drawing Bio::Tree::Tree\nobjects in Encapsulated PostScript (EPS) format. It can be utilized\nboth for displaying a single phylogenetic tree (a cladogram) and for\nthe comparative display of two phylogenetic trees (a tanglegram) such\nas a gene tree and a species tree, a host tree and a parasite tree,\ntwo alternative trees for the same set of taxa, or two alternative\ntrees for overlapping sets of taxa.\n\nPhylogenetic trees are drawn as rectangular cladograms, with\nhorizontal orientation and ancestral nodes centered over their\ndescendents. The font used for taxa is Courier at 10 pt. A single\nBio::Tree::Tree object is drawn with ancestors to the left and taxa\nflushed to the right. Two Bio::Tree::Tree objects are drawn with the\nfirst tree oriented left-to-right and the second tree oriented\nright-to-left, and with corresponding taxa connected by straight lines\nin a shade of gray. Each correspondence between a $taxon1 of the first\ntree and a $taxon2 of the second tree is established by setting\n$taxon1-E<gt>add_tag_value('connection',$taxon2). Thus, a taxon of the\nfirst tree can be connected to more than one taxon of the second tree,\nand vice versa.\n\nThe branch from the parent to a child $node, as well as the child\nlabel, can be colored by setting $node-E<gt>add_tag_value('Rcolor',$r),\n$node-E<gt>add_tag_value('Gcolor',$g), and\n$node-E<gt>add_tag_value('Bcolor',$b), where $r, $g, and $b are the\ndesired values for red, green, and blue (zero for lowest, one for\nhighest intensity).\n\nThis is a preliminary release of Bio::Tree::Draw::Cladogram. Future\nimprovements include an option to output phylograms instead of\ncladograms. Beware that cladograms are automatically scaled according\nto branch lengths, but the current release has only been tested with\ntrees having unit branch lengths.\n\nThe print method could be extended to output graphic formats other\nthan EPS, although there are many graphics conversion programs around\nthat accept EPS input. For instance, most Linux distributions include\nepstopdf, a Perl script that together with Ghostscript, converts EPS\nto PDF.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gabriel Valiente\n\nEmail valiente@lsi.upc.edu\n\nCode for coloring branches contributed by Georgii A Bazykin\n(gbazykin@princeton.edu).\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tree::Draw::Cladogram;\nuse strict;\n\nuse PostScript::TextBlock;\n\nuse base qw(Bio::Root::Root);\n\n# The following private package variables are set by the new method\n# and used by the print method.\n\nmy %xx;        # horizontal coordinate for each node\nmy %yy;        # vertical coordinate for each node\nmy $t1;        # first Bio::Tree::Tree object\nmy $t2;        # second Bio::Tree::Tree object\nmy $font;      # font name\nmy $size;      # font size\nmy $width;     # total drawing width\nmy $height;    # total drawing height\nmy $xstep;     # branch length in drawing\nmy $tip;       # extra space between tip and label\nmy $tipwidth1; # width of longest label among $t1 taxa\nmy $tipwidth2; # width of longest label among $t2 taxa\nmy $compact;   # whether or not to ignore branch lengths\nmy $ratio;     # horizontal to vertical ratio\nmy $colors;    # use colors to color edges\nmy %Rcolor;    # red color for each node\nmy %Gcolor;    # green color for each node\nmy %Bcolor;    # blue color for each node\nmy $bootstrap; # Draw Bootstrap boolean\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::Draw::Cladogram->new();\n Function: Builds a new Bio::Tree::Draw::Cladogram object \n Returns : Bio::Tree::Draw::Cladogram\n Args    : -tree => Bio::Tree::Tree object\n           -second => Bio::Tree::Tree object (optional)\n           -font => font name [string] (optional)\n           -size => font size [integer] (optional)\n           -top => top margin [integer] (optional)\n           -bottom => bottom margin [integer] (optional)\n           -left => left margin [integer] (optional)\n           -right => right margin [integer] (optional)\n           -tip => extra tip space [integer] (optional)\n           -column => extra space between cladograms [integer] (optional)\n           -compact => ignore branch lengths [boolean] (optional)\n           -ratio => horizontal to vertical ratio [integer] (optional)\n           -colors => use colors to color edges [boolean] (optional)\n           -bootstrap => draw bootstrap or internal ids [boolean]\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  ($t1, $t2, $font, $size, my $top, my $bottom, my $left, my $right,\n    $tip, my $column, $compact, $ratio, $colors,$bootstrap) = \n\t$self->_rearrange([qw(TREE SECOND FONT SIZE TOP BOTTOM LEFT RIGHT \n\t\t\t      TIP COLUMN COMPACT RATIO COLORS BOOTSTRAP)], \n\t\t\t\t   @args);\n  $font ||= \"Helvetica-Narrow\";\n  $size ||= 12;\n  $top ||= 10;\n  $bottom ||= 10;\n  $left ||= 10;\n  $right ||= 10;\n  $tip ||= 5;\n  $column ||= 60;\n  $compact ||= 0;\n  $ratio ||= 1 / 1.6180339887;\n  $colors ||= 0;\n  $bootstrap ||= 0;\n\n  # Roughly, a cladogram is set according to the following parameters.\n\n  #################################\n  #                           # T #   $top (T, top margin)\n  #        +---------+ XXX    #   #   $bottom (B, bottom margin)\n  #        |                  #   #   $left (L, left margin)\n  #        |                  #   #   $right (R, right margin)\n  #   +----+                  #   #   $tip (X, extra tip space)\n  #        |    +----+ XXXX   #   #   $width (total drawing width)\n  #        |    |             #   #   $height (total drawing height)\n  #        +----+             # Y #   $xstep (S, stem length)\n  #             |             #   #   $ystep (Y, space between taxa)\n  #             +----+ XX     #   #   $tiplen (string length of longest name)\n  #                           # B #   $tipwidth (N, size of longest name)\n  #################################\n  # L         S       X  N  R #\n  #############################\n\n  # A tanglegram is roughly set as follows. The only additional\n  # parameter is $column (C, length of connection lines between taxa\n  # of the two trees), but $tip occurs four times, and $tiplen and\n  # $tipwidth differ for the first and the second tree.\n\n  ###########################################################\n  #                                                         #\n  #        +---------+ XXX  ----- XXXXXX +----+             #\n  #        |                                  |             #\n  #        |                                  +----+        #\n  #   +----+                                  |    |        #\n  #        |    +----+ XXXX -----    XXX +----+    |        #\n  #        |    |                                  +----+   #\n  #        +----+                                  |        #\n  #             |                                  |        #\n  #             +----+ XX   -----   XXXX +---------+        #\n  #                                                         #\n  ###########################################################\n  # L                 X    X  C  X      X                 R #\n  ###########################################################\n\n  # An alternative would be to let the user set $width and $height in\n  # points and to scale down everything to fit the desired\n  # dimensions. However, the final EPS can later be scaled down to any\n  # desired size anyway.\n\n  my @taxa1 = $t1->get_leaf_nodes;\n  my $root1 = $t1->get_root_node;\n\n  $tipwidth1 = 0;\n  foreach my $taxon (@taxa1) {\n    my $w = PostScript::Metrics::stringwidth($taxon->id,$font,$size);\n    if ($w > $tipwidth1) { $tipwidth1 = $w; }\n  }\n\n  my @taxa2;\n  my $root2;\n\n  my $ystep = 20;\n\n  if ($t2) {\n    @taxa2 = $t2->get_leaf_nodes;\n    $root2 = $t2->get_root_node;\n    $tipwidth2 = 0;\n    foreach my $taxon (@taxa2) {\n      my $w = PostScript::Metrics::stringwidth($taxon->id,$font,$size);\n      if ($w > $tipwidth2) { $tipwidth2 = $w; }\n    }\n  }\n\n  my $stems = $root1->height + 1;\n  if ($t2) { $stems += $root2->height + 1; }\n  my $labels = $tipwidth1;\n  if ($t2) { $labels += $tipwidth2; }\n  $xstep = 20;\n  $width = $left + $stems * $xstep + $tip + $labels + $right;\n  if ($t2) { $width += $tip + $column + $tip + $tip; }\n  $height = $bottom + $ystep * (@taxa1 - 1) + $top;\n  if ($t2) {\n    if ( scalar(@taxa2) > scalar(@taxa1) ) {\n      $height = $bottom + $ystep * (@taxa2 - 1) + $top;\n    }\n  }\n  my $ystep1 = $height / scalar(@taxa1);\n  my $ystep2;\n  if ($t2) {\n    $ystep2 = $height / scalar(@taxa2);\n  }\n\n  my $x = $left + $xstep * ($root1->height + 1) + $tip;\n  my $y = $bottom;\n\n  for my $taxon (reverse @taxa1) {\n    $xx{$taxon} = $x - $tip;\n    $yy{$taxon} = $y;\n    $y += $ystep1;\n  }\n  $x -= $xstep;\n\n  my @stack;\n  my @queue; # postorder traversal\n  push @stack, $t1->get_root_node;\n  while (@stack) {\n    my $node = pop @stack;\n    push @queue, $node;\n    foreach my $child ($node->each_Descendent(-sortby => 'internal_id')) {\n      push @stack, $child;\n    }\n  }\n  @queue = reverse @queue;\n\n  for my $node (@queue) {\n    if (!$node->is_Leaf) {\n      my @children = $node->each_Descendent;\n      my $child = shift @children;\n      my $xmin = $xx{$child};\n      my $ymin = my $ymax = $yy{$child};\n      foreach $child (@children) {\n\t$xmin = $xx{$child} if $xx{$child} < $xmin;\n\t$ymax = $yy{$child} if $yy{$child} > $ymax;\n\t$ymin = $yy{$child} if $yy{$child} < $ymin;\n      }\n      $xx{$node} = $xmin - $xstep;\n      $yy{$node} = ($ymin + $ymax)/2;\n    }\n  }\n\n  $xx{$t1->get_root_node} = $left + $xstep;\n\n  my @preorder = $t1->get_nodes(-order => 'depth');\n\n  for my $node (@preorder) {\n    #print \"\\n$node\";\n    if ($colors) {\n      if ($node->has_tag('Rcolor')) {\n        $Rcolor{$node} = $node->get_tag_values('Rcolor')\n      } else {\n        $Rcolor{$node} = 0\n      }\n      if ($node->has_tag('Gcolor')) {\n        $Gcolor{$node} = $node->get_tag_values('Gcolor')\n      } else {\n        $Gcolor{$node} = 0\n      }\n      if ($node->has_tag('Bcolor')) {\n        $Bcolor{$node} = $node->get_tag_values('Bcolor')\n      } else {\n        $Bcolor{$node} = 0\n      }\n      #print \"\\t$Rcolor{$node}\\t$Gcolor{$node}\\t$Bcolor{$node}\";\n    }\n  }\n\n  if ($compact) { # ragged right, ignoring branch lengths\n\n    $width = 0;\n    shift @preorder; # skip root\n    for my $node (@preorder) {\n      $xx{$node} = $xx{$node->ancestor} + $xstep;\n      $width = $xx{$node} if $xx{$node} > $width;\n    }\n    $width += $tip + $tipwidth1 + $right;\n\n  } else { # set to aspect ratio and use branch lengths if available\n\n    my $total_height = (scalar($t1->get_leaf_nodes) - 1) * $ystep;\n    my $scale_factor = $total_height * $ratio / $t1->get_root_node->height;    \n\n    $width = $t1->get_root_node->height * $scale_factor;\n    $width += $left + $xstep;\n    $width += $tip + $tipwidth1 + $right;\n\n    shift @preorder; # skip root\n    for my $node (@preorder) {\n      my $bl = $node->branch_length;\n      $bl = 1 unless (defined $bl && $bl =~ /^\\-?\\d+(\\.\\d+)?$/);\n      $xx{$node} = $xx{$node->ancestor} + $bl * $scale_factor;\n    }\n\n  }\n\n  if ($t2) {\n\n    $x = $left + $xstep * ($root1->height + 1) + $tip;\n    $x += $tipwidth1 + $tip + $column + $tip;\n    my $y = $bottom;\n\n    for my $taxon (reverse @taxa2) {\n      $xx{$taxon} = $x + $tipwidth2 + $tip;\n      $yy{$taxon} = $y;\n      $y += $ystep2;\n    }\n    $x += $xstep;\n\n    my @stack;\n    my @queue; # postorder traversal\n    push @stack, $t2->get_root_node;\n    while (@stack) {\n      my $node = pop @stack;\n      push @queue, $node;\n      foreach my $child ($node->each_Descendent(-sortby => 'internal_id')) {\n\tpush @stack, $child;\n      }\n    }\n    @queue = reverse @queue;\n\n    for my $node (@queue) {\n      if (!$node->is_Leaf) {\n\tmy @children = $node->each_Descendent;\n\tmy $child = shift @children;\n\tmy $xmax = $xx{$child};\n\tmy $ymin = my $ymax = $yy{$child};\n\tforeach $child (@children) {\n\t  $xmax = $xx{$child} if $xx{$child} > $xmax;\n\t  $ymax = $yy{$child} if $yy{$child} > $ymax;\n\t  $ymin = $yy{$child} if $yy{$child} < $ymin;\n\t}\n\t$xx{$node} = $xmax + $xstep;\n\t$yy{$node} = ($ymin + $ymax)/2;\n      }\n    }\n\n  }\n\n  return $self;\n}\n\n=head2 print\n\n Title   : print\n Usage   : $obj->print();\n Function: Outputs $obj in Encapsulated PostScript (EPS) format \n Returns : \n Args    : -file => filename (optional)","parameters":[{"label":"$self"},{"label":"@args"}]}},{"line":495,"containerName":"Metrics::stringwidth","kind":12,"name":"PostScript"},{"line":545,"containerName":"Metrics::stringwidth","kind":12,"name":"PostScript"},{"line":550,"name":"PostScript","containerName":"Metrics::stringwidth","kind":12}],"version":5}