{"version":5,"vars":[{"containerName":"","kind":2,"name":"vars","line":97},{"containerName":null,"kind":13,"name":"$DefaultMethod","line":101},{"kind":2,"containerName":"","name":"strict","line":101},{"name":"$Precision","kind":13,"containerName":null,"line":102},{"name":"base","kind":2,"containerName":"","line":107},{"definition":"sub","detail":"($class,@args)","children":[{"containerName":"new","localvar":"my","kind":13,"name":"$class","line":121,"definition":"my"},{"line":121,"name":"@args","containerName":"new","kind":13},{"definition":"my","line":122,"kind":13,"localvar":"my","containerName":"new","name":"$self"},{"name":"$class","kind":13,"containerName":"new","line":122},{"line":122,"containerName":"new","kind":13,"name":"@args"},{"definition":"my","line":124,"localvar":"my","kind":13,"containerName":"new","name":"$method"},{"line":124,"name":"$self","containerName":"new","kind":13},{"line":124,"name":"_rearrange","containerName":"new","kind":12},{"name":"@args","containerName":"new","kind":13,"line":125},{"line":126,"kind":13,"containerName":"new","name":"$self"},{"line":126,"name":"method","kind":12,"containerName":"new"},{"line":126,"kind":13,"containerName":"new","name":"$method"},{"name":"$DefaultMethod","kind":13,"containerName":"new","line":126},{"line":127,"name":"$self","kind":13,"containerName":"new"}],"name":"new","containerName":"main::","signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: DistanceFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::DistanceFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::DistanceFactory - Construct a tree using distance based methods\n\n=head1 SYNOPSIS\n\n  use Bio::Tree::DistanceFactory;\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n  my $tfactory = Bio::Tree::DistanceFactory->new(-method => \"NJ\");\n  my $stats    = Bio::Align::DNAStatistics->new();\n\n  my $alnin    = Bio::AlignIO->new(-format => 'clustalw',\n                                   -file   => 'file.aln');\n  my $aln = $alnin->next_aln;\n  # Of course matrix can come from a different place\n  # like PHYLIP if you prefer, Bio::Matrix::IO should be able\n  # to parse many things\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n  my $tree = $tfactory->make_tree($jcmatrix);\n\n\n=head1 DESCRIPTION\n\nThis is a factory which will construct a phylogenetic tree based on\nthe pairwise sequence distances for a set of sequences.  Currently\nUPGMA (Sokal and Michener 1958) and NJ (Saitou and Nei 1987) tree\nconstruction methods are implemented.\n\n=head1 REFERENCES\n\nEddy SR, Durbin R, Krogh A, Mitchison G, (1998) \"Biological Sequence Analysis\",\nCambridge Univ Press, Cambridge, UK.\n\nHowe K, Bateman A, Durbin R, (2002) \"QuickTree: building huge\nNeighbour-Joining trees of protein sequences.\" Bioinformatics\n18(11):1546-1547.\n\nSaitou N and Nei M, (1987) \"The neighbor-joining method: a new method\nfor reconstructing phylogenetic trees.\" Mol Biol Evol 4(4):406-25.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tree::DistanceFactory;\nuse vars qw($DefaultMethod $Precision);\nuse strict;\n\n# some defaults\n$DefaultMethod = 'UPGMA';\n$Precision = 5;\n\nuse Bio::Tree::Node;\nuse Bio::Tree::Tree;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::DistanceFactory->new();\n Function: Builds a new Bio::Tree::DistanceFactory object \n Returns : an instance of Bio::Tree::DistanceFactory\n Args    : -method => 'NJ' or 'UPGMA'","label":"new($class,@args)"},"line":120,"kind":12,"range":{"end":{"line":128,"character":9999},"start":{"character":0,"line":120}}},{"name":"SUPER","kind":12,"containerName":"new","line":122},{"kind":12,"range":{"end":{"line":159,"character":9999},"start":{"line":141,"character":0}},"line":141,"signature":{"documentation":"1;\n# $Id: DistanceFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::DistanceFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::DistanceFactory - Construct a tree using distance based methods\n\n=head1 SYNOPSIS\n\n  use Bio::Tree::DistanceFactory;\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n  my $tfactory = Bio::Tree::DistanceFactory->new(-method => \"NJ\");\n  my $stats    = Bio::Align::DNAStatistics->new();\n\n  my $alnin    = Bio::AlignIO->new(-format => 'clustalw',\n                                   -file   => 'file.aln');\n  my $aln = $alnin->next_aln;\n  # Of course matrix can come from a different place\n  # like PHYLIP if you prefer, Bio::Matrix::IO should be able\n  # to parse many things\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n  my $tree = $tfactory->make_tree($jcmatrix);\n\n\n=head1 DESCRIPTION\n\nThis is a factory which will construct a phylogenetic tree based on\nthe pairwise sequence distances for a set of sequences.  Currently\nUPGMA (Sokal and Michener 1958) and NJ (Saitou and Nei 1987) tree\nconstruction methods are implemented.\n\n=head1 REFERENCES\n\nEddy SR, Durbin R, Krogh A, Mitchison G, (1998) \"Biological Sequence Analysis\",\nCambridge Univ Press, Cambridge, UK.\n\nHowe K, Bateman A, Durbin R, (2002) \"QuickTree: building huge\nNeighbour-Joining trees of protein sequences.\" Bioinformatics\n18(11):1546-1547.\n\nSaitou N and Nei M, (1987) \"The neighbor-joining method: a new method\nfor reconstructing phylogenetic trees.\" Mol Biol Evol 4(4):406-25.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tree::DistanceFactory;\nuse vars qw($DefaultMethod $Precision);\nuse strict;\n\n# some defaults\n$DefaultMethod = 'UPGMA';\n$Precision = 5;\n\nuse Bio::Tree::Node;\nuse Bio::Tree::Tree;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::DistanceFactory->new();\n Function: Builds a new Bio::Tree::DistanceFactory object \n Returns : an instance of Bio::Tree::DistanceFactory\n Args    : -method => 'NJ' or 'UPGMA'\n\n\n\nsub new {\n  my($class,@args) = @_;  \n  my $self = $class->SUPER::new(@args);\n\n  my ($method) = $self->_rearrange([qw(METHOD)],\n\t\t\t\t   @args);\n  $self->method($method || $DefaultMethod);\n  return $self;\n}\n\n=head2 make_tree\n\n Title   : make_tree\n Usage   : my $tree = $disttreefact->make_tree($matrix);\n Function: Build a Tree based on a distance matrix\n Returns : L<Bio::Tree::TreeI>\n Args    : L<Bio::Matrix::MatrixI> object","parameters":[{"label":"$self"},{"label":"$matrix"}],"label":"make_tree($self,$matrix)"},"containerName":"main::","name":"make_tree","children":[{"definition":"my","line":142,"name":"$self","localvar":"my","kind":13,"containerName":"make_tree"},{"line":142,"containerName":"make_tree","kind":13,"name":"$matrix"},{"line":143,"kind":13,"containerName":"make_tree","name":"$matrix"},{"name":"$matrix","kind":13,"containerName":"make_tree","line":143},{"line":144,"name":"$matrix","containerName":"make_tree","kind":13},{"line":144,"containerName":"make_tree","kind":12,"name":"isa"},{"line":145,"name":"$self","containerName":"make_tree","kind":13},{"kind":12,"containerName":"make_tree","name":"warn","line":145},{"line":149,"name":"$method","localvar":"my","kind":13,"containerName":"make_tree","definition":"my"},{"name":"$self","kind":13,"containerName":"make_tree","line":149},{"line":149,"kind":12,"containerName":"make_tree","name":"method"},{"line":150,"containerName":"make_tree","kind":13,"name":"$method"},{"line":151,"kind":13,"containerName":"make_tree","name":"$self"},{"kind":12,"containerName":"make_tree","name":"_nj","line":151},{"kind":13,"containerName":"make_tree","name":"$matrix","line":151},{"name":"$method","kind":13,"containerName":"make_tree","line":152},{"line":153,"name":"$self","containerName":"make_tree","kind":13},{"kind":12,"containerName":"make_tree","name":"_upgma","line":153},{"line":153,"name":"$matrix","containerName":"make_tree","kind":13},{"line":155,"kind":13,"containerName":"make_tree","name":"$self"},{"line":155,"kind":12,"containerName":"make_tree","name":"warn"}],"detail":"($self,$matrix)","definition":"sub"},{"signature":{"label":"_nj($self,$distmat)","parameters":[{"label":"$self"},{"label":"$distmat"}],"documentation":"1;\n# $Id: DistanceFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::DistanceFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::DistanceFactory - Construct a tree using distance based methods\n\n=head1 SYNOPSIS\n\n  use Bio::Tree::DistanceFactory;\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n  my $tfactory = Bio::Tree::DistanceFactory->new(-method => \"NJ\");\n  my $stats    = Bio::Align::DNAStatistics->new();\n\n  my $alnin    = Bio::AlignIO->new(-format => 'clustalw',\n                                   -file   => 'file.aln');\n  my $aln = $alnin->next_aln;\n  # Of course matrix can come from a different place\n  # like PHYLIP if you prefer, Bio::Matrix::IO should be able\n  # to parse many things\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n  my $tree = $tfactory->make_tree($jcmatrix);\n\n\n=head1 DESCRIPTION\n\nThis is a factory which will construct a phylogenetic tree based on\nthe pairwise sequence distances for a set of sequences.  Currently\nUPGMA (Sokal and Michener 1958) and NJ (Saitou and Nei 1987) tree\nconstruction methods are implemented.\n\n=head1 REFERENCES\n\nEddy SR, Durbin R, Krogh A, Mitchison G, (1998) \"Biological Sequence Analysis\",\nCambridge Univ Press, Cambridge, UK.\n\nHowe K, Bateman A, Durbin R, (2002) \"QuickTree: building huge\nNeighbour-Joining trees of protein sequences.\" Bioinformatics\n18(11):1546-1547.\n\nSaitou N and Nei M, (1987) \"The neighbor-joining method: a new method\nfor reconstructing phylogenetic trees.\" Mol Biol Evol 4(4):406-25.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tree::DistanceFactory;\nuse vars qw($DefaultMethod $Precision);\nuse strict;\n\n# some defaults\n$DefaultMethod = 'UPGMA';\n$Precision = 5;\n\nuse Bio::Tree::Node;\nuse Bio::Tree::Tree;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::DistanceFactory->new();\n Function: Builds a new Bio::Tree::DistanceFactory object \n Returns : an instance of Bio::Tree::DistanceFactory\n Args    : -method => 'NJ' or 'UPGMA'\n\n\n\nsub new {\n  my($class,@args) = @_;  \n  my $self = $class->SUPER::new(@args);\n\n  my ($method) = $self->_rearrange([qw(METHOD)],\n\t\t\t\t   @args);\n  $self->method($method || $DefaultMethod);\n  return $self;\n}\n\n=head2 make_tree\n\n Title   : make_tree\n Usage   : my $tree = $disttreefact->make_tree($matrix);\n Function: Build a Tree based on a distance matrix\n Returns : L<Bio::Tree::TreeI>\n Args    : L<Bio::Matrix::MatrixI> object\n\n\n\nsub make_tree{\n   my ($self,$matrix) = @_;\n   if( ! defined $matrix || !ref($matrix) || \n       ! $matrix->isa('Bio::Matrix::MatrixI') ) {\n       $self->warn(\"Need to provide a valid Bio::Matrix::MatrixI object to make_tree\");\n       return;\n   }\n\n   my $method = uc ($self->method);\n   if( $method =~ /NJ/i ) {\n       return $self->_nj($matrix);\n   } elsif( $method =~ /UPGMA/i ) {\n       return $self->_upgma($matrix);\n   } else { \n       $self->warn(\"Unknown tree construction method '$method'.  Cannot run.\");\n       return;\n   }\n   \n}\n\n\n=head2 _nj\n\n Title   : _nj\n Usage   : my $tree = $disttreefact->_nj($matrix);\n Function: Construct a tree based on distance matrix using the \n           Neighbor Joining algorithm (Saitou and Nei, 1987)\n           Implementation based on Kevin Howe's Quicktree implementation\n           and uses his tricks (some based on Bill Bruno's work) to eliminate\n           negative branch lengths\n Returns : L<Bio::Tree::TreeI>\n Args    : L<Bio::Matrix::MatrixI> object"},"line":176,"range":{"end":{"character":9999,"line":360},"start":{"character":0,"line":176}},"kind":12,"definition":"sub","detail":"($self,$distmat)","children":[{"line":177,"name":"$self","localvar":"my","kind":13,"containerName":"_nj","definition":"my"},{"line":177,"kind":13,"containerName":"_nj","name":"$distmat"},{"definition":"my","line":184,"name":"$precisionstr","kind":13,"localvar":"my","containerName":"_nj"},{"definition":"my","line":186,"localvar":"my","kind":13,"containerName":"_nj","name":"@names"},{"name":"$distmat","containerName":"_nj","kind":13,"line":186},{"name":"column_names","kind":12,"containerName":"_nj","line":186},{"line":187,"localvar":"my","containerName":"_nj","kind":13,"name":"$N","definition":"my"},{"kind":13,"containerName":"_nj","name":"@names","line":187},{"name":"$i","containerName":"_nj","localvar":"my","kind":13,"line":188,"definition":"my"},{"line":188,"containerName":"_nj","kind":13,"name":"$j"},{"line":188,"name":"$m","kind":13,"containerName":"_nj"},{"name":"@nodes","kind":13,"containerName":"_nj","line":188},{"containerName":"_nj","kind":13,"name":"$mat","line":188},{"line":188,"name":"@r","containerName":"_nj","kind":13},{"line":189,"localvar":"my","kind":13,"containerName":"_nj","name":"$L","definition":"my"},{"line":189,"name":"$N","containerName":"_nj","kind":13},{"name":"$N","containerName":"_nj","kind":13,"line":191},{"containerName":"_nj","kind":13,"name":"$self","line":192},{"name":"warn","kind":12,"containerName":"_nj","line":192},{"name":"$N","containerName":"_nj","kind":13,"line":194},{"line":195,"containerName":"_nj","kind":13,"name":"$i"},{"line":196,"name":"$d","localvar":"my","containerName":"_nj","kind":13,"definition":"my"},{"line":196,"containerName":"_nj","kind":13,"name":"$precisionstr"},{"name":"$distmat","containerName":"_nj","kind":13,"line":197},{"name":"get_entry","containerName":"_nj","kind":12,"line":197},{"name":"$names","containerName":"_nj","kind":13,"line":197},{"line":197,"kind":13,"containerName":"_nj","name":"$names"},{"definition":"my","line":198,"containerName":"_nj","localvar":"my","kind":13,"name":"$root"},{"line":198,"name":"new","containerName":"_nj","kind":12},{"line":199,"name":"$nm","kind":13,"localvar":"my","containerName":"_nj","definition":"my"},{"kind":13,"containerName":"_nj","name":"@names","line":199},{"containerName":"_nj","kind":13,"name":"$root","line":200},{"line":200,"name":"add_Descendents","containerName":"_nj","kind":12},{"line":200,"name":"new","kind":12,"containerName":"_nj"},{"kind":13,"containerName":"_nj","name":"$nm","line":200},{"line":201,"name":"$d","kind":13,"containerName":"_nj"},{"line":203,"name":"$root","kind":13,"containerName":"_nj"},{"containerName":"_nj","localvar":"my","kind":13,"name":"$c","line":205,"definition":"my"},{"containerName":"_nj","kind":13,"name":"$i","line":207},{"line":207,"name":"$i","containerName":"_nj","kind":13},{"kind":13,"containerName":"_nj","name":"$N","line":207},{"kind":13,"containerName":"_nj","name":"$i","line":207},{"line":208,"name":"@nodes","containerName":"_nj","kind":13},{"name":"new","kind":12,"containerName":"_nj","line":208},{"containerName":"_nj","kind":13,"name":"$names","line":208},{"name":"$i","containerName":"_nj","kind":13,"line":208},{"definition":"my","line":209,"containerName":"_nj","localvar":"my","kind":13,"name":"$ri"},{"kind":13,"containerName":"_nj","name":"$j","line":210},{"line":210,"kind":13,"containerName":"_nj","name":"$j"},{"line":210,"name":"$N","containerName":"_nj","kind":13},{"line":210,"kind":13,"containerName":"_nj","name":"$j"},{"name":"$mat","containerName":"_nj","kind":13,"line":211},{"line":211,"kind":13,"containerName":"_nj","name":"$i"},{"line":211,"kind":13,"containerName":"_nj","name":"$j"},{"line":211,"kind":13,"containerName":"_nj","name":"$distmat"},{"line":211,"containerName":"_nj","kind":12,"name":"get_entry"},{"line":211,"containerName":"_nj","kind":13,"name":"$names"},{"line":211,"kind":13,"containerName":"_nj","name":"$i"},{"line":211,"name":"$names","containerName":"_nj","kind":13},{"name":"$j","containerName":"_nj","kind":13,"line":211},{"name":"$ri","kind":13,"containerName":"_nj","line":212},{"line":212,"name":"$mat","containerName":"_nj","kind":13},{"line":212,"kind":13,"containerName":"_nj","name":"$i"},{"containerName":"_nj","kind":13,"name":"$j","line":212},{"name":"$r","kind":13,"containerName":"_nj","line":214},{"line":214,"kind":13,"containerName":"_nj","name":"$i"},{"containerName":"_nj","kind":13,"name":"$ri","line":214},{"containerName":"_nj","kind":13,"name":"$L","line":214},{"definition":"my","line":217,"localvar":"my","kind":13,"containerName":"_nj","name":"$nodecount"},{"line":217,"containerName":"_nj","kind":13,"name":"$nodecount"},{"line":217,"containerName":"_nj","kind":13,"name":"$N"},{"name":"$nodecount","containerName":"_nj","kind":13,"line":217},{"definition":"my","localvar":"my","kind":13,"containerName":"_nj","name":"$mini","line":218},{"line":218,"containerName":"_nj","kind":13,"name":"$minj"},{"line":218,"containerName":"_nj","kind":13,"name":"$min"},{"containerName":"_nj","kind":13,"name":"$i","line":219},{"containerName":"_nj","kind":13,"name":"$i","line":219},{"containerName":"_nj","kind":13,"name":"$N","line":219},{"containerName":"_nj","kind":13,"name":"$i","line":219},{"line":220,"containerName":"_nj","kind":13,"name":"$nodes"},{"name":"$i","kind":13,"containerName":"_nj","line":220},{"line":221,"containerName":"_nj","kind":13,"name":"$j"},{"line":221,"name":"$j","kind":13,"containerName":"_nj"},{"line":221,"name":"$i","kind":13,"containerName":"_nj"},{"containerName":"_nj","kind":13,"name":"$j","line":221},{"line":222,"kind":13,"containerName":"_nj","name":"$nodes"},{"name":"$j","kind":13,"containerName":"_nj","line":222},{"definition":"my","name":"$dist","localvar":"my","kind":13,"containerName":"_nj","line":223},{"name":"$mat","containerName":"_nj","kind":13,"line":223},{"line":223,"containerName":"_nj","kind":13,"name":"$i"},{"kind":13,"containerName":"_nj","name":"$j","line":223},{"kind":13,"containerName":"_nj","name":"$r","line":223},{"kind":13,"containerName":"_nj","name":"$i","line":223},{"line":223,"containerName":"_nj","kind":13,"name":"$r"},{"name":"$j","kind":13,"containerName":"_nj","line":223},{"line":224,"name":"$min","containerName":"_nj","kind":13},{"line":225,"kind":13,"containerName":"_nj","name":"$dist"},{"name":"$min","containerName":"_nj","kind":13,"line":225},{"name":"$mini","containerName":"_nj","kind":13,"line":226},{"name":"$minj","kind":13,"containerName":"_nj","line":226},{"line":226,"kind":13,"containerName":"_nj","name":"$min"},{"line":226,"containerName":"_nj","kind":13,"name":"$i"},{"line":226,"name":"$j","containerName":"_nj","kind":13},{"kind":13,"containerName":"_nj","name":"$dist","line":226},{"definition":"my","line":230,"name":"$dij","localvar":"my","containerName":"_nj","kind":13},{"containerName":"_nj","kind":13,"name":"$mat","line":230},{"line":230,"kind":13,"containerName":"_nj","name":"$mini"},{"line":230,"kind":13,"containerName":"_nj","name":"$minj"},{"line":231,"localvar":"my","kind":13,"containerName":"_nj","name":"$dist_i","definition":"my"},{"line":231,"name":"$dij","kind":13,"containerName":"_nj"},{"containerName":"_nj","kind":13,"name":"$r","line":231},{"kind":13,"containerName":"_nj","name":"$mini","line":231},{"name":"$r","kind":13,"containerName":"_nj","line":231},{"kind":13,"containerName":"_nj","name":"$minj","line":231},{"line":232,"name":"$dist_j","localvar":"my","containerName":"_nj","kind":13,"definition":"my"},{"line":232,"kind":13,"containerName":"_nj","name":"$dij"},{"name":"$dist_i","containerName":"_nj","kind":13,"line":232},{"line":236,"name":"$dist_i","containerName":"_nj","kind":13},{"kind":13,"containerName":"_nj","name":"$dist_i","line":237},{"line":238,"name":"$dist_j","containerName":"_nj","kind":13},{"line":238,"name":"$dij","kind":13,"containerName":"_nj"},{"line":239,"name":"$dist_j","containerName":"_nj","kind":13},{"kind":13,"containerName":"_nj","name":"$dist_j","line":239},{"name":"$dist_j","kind":13,"containerName":"_nj","line":240},{"line":241,"name":"$dist_j","containerName":"_nj","kind":13},{"name":"$dist_i","containerName":"_nj","kind":13,"line":242},{"line":242,"kind":13,"containerName":"_nj","name":"$dij"},{"line":243,"name":"$dist_i","containerName":"_nj","kind":13},{"line":243,"name":"$dist_i","containerName":"_nj","kind":13},{"name":"$nodes","containerName":"_nj","kind":13,"line":246},{"name":"$mini","containerName":"_nj","kind":13,"line":246},{"line":246,"name":"branch_length","kind":12,"containerName":"_nj"},{"containerName":"_nj","kind":13,"name":"$precisionstr","line":246},{"line":246,"containerName":"_nj","kind":13,"name":"$dist_i"},{"line":247,"containerName":"_nj","kind":13,"name":"$nodes"},{"name":"$minj","containerName":"_nj","kind":13,"line":247},{"containerName":"_nj","kind":12,"name":"branch_length","line":247},{"name":"$precisionstr","containerName":"_nj","kind":13,"line":247},{"name":"$dist_j","containerName":"_nj","kind":13,"line":247},{"name":"$newnode","containerName":"_nj","localvar":"my","kind":13,"line":249,"definition":"my"},{"line":249,"name":"new","kind":12,"containerName":"_nj"},{"line":249,"kind":13,"containerName":"_nj","name":"$nodes"},{"containerName":"_nj","kind":13,"name":"$mini","line":249},{"line":250,"name":"$nodes","kind":13,"containerName":"_nj"},{"name":"$minj","kind":13,"containerName":"_nj","line":250},{"kind":13,"containerName":"_nj","name":"$nodes","line":252},{"line":252,"name":"$mini","containerName":"_nj","kind":13},{"line":252,"containerName":"_nj","kind":13,"name":"$newnode"},{"line":253,"name":"$nodes","containerName":"_nj","kind":13},{"line":253,"name":"$minj","kind":13,"containerName":"_nj"},{"name":"$r","kind":13,"containerName":"_nj","line":256},{"line":256,"kind":13,"containerName":"_nj","name":"$mini"},{"definition":"my","line":257,"name":"$dmi","containerName":"_nj","localvar":"my","kind":13},{"line":257,"name":"$dmj","containerName":"_nj","kind":13},{"kind":13,"containerName":"_nj","name":"$m","line":258},{"containerName":"_nj","kind":13,"name":"$m","line":258},{"name":"$N","containerName":"_nj","kind":13,"line":258},{"line":258,"name":"$m","kind":13,"containerName":"_nj"},{"line":259,"name":"$nodes","kind":13,"containerName":"_nj"},{"line":259,"name":"$m","containerName":"_nj","kind":13},{"line":260,"name":"$m","containerName":"_nj","kind":13},{"line":260,"kind":13,"containerName":"_nj","name":"$mini"},{"name":"$dmj","containerName":"_nj","kind":13,"line":261},{"line":261,"name":"$mat","containerName":"_nj","kind":13},{"line":261,"containerName":"_nj","kind":13,"name":"$m"},{"line":261,"name":"$minj","kind":13,"containerName":"_nj"},{"line":263,"name":"$row","kind":13,"localvar":"my","containerName":"_nj","definition":"my"},{"containerName":"_nj","kind":13,"name":"$col","line":263},{"line":264,"kind":13,"containerName":"_nj","name":"$row"},{"containerName":"_nj","kind":13,"name":"$col","line":264},{"name":"$m","kind":13,"containerName":"_nj","line":264},{"line":264,"kind":13,"containerName":"_nj","name":"$mini"},{"name":"$dmi","kind":13,"containerName":"_nj","line":265},{"containerName":"_nj","kind":13,"name":"$mat","line":265},{"line":265,"name":"$row","containerName":"_nj","kind":13},{"name":"$col","kind":13,"containerName":"_nj","line":265},{"name":"$dmk","localvar":"my","containerName":"_nj","kind":13,"line":281,"definition":"my"},{"name":"$mat","kind":13,"containerName":"_nj","line":281},{"line":281,"containerName":"_nj","kind":13,"name":"$row"},{"kind":13,"containerName":"_nj","name":"$col","line":281},{"line":281,"containerName":"_nj","kind":13,"name":"$mat"},{"line":281,"kind":13,"containerName":"_nj","name":"$col"},{"line":281,"kind":13,"containerName":"_nj","name":"$row"},{"containerName":"_nj","kind":13,"name":"$dmi","line":282},{"name":"$dmj","containerName":"_nj","kind":13,"line":282},{"line":282,"kind":13,"containerName":"_nj","name":"$dij"},{"name":"$r","containerName":"_nj","kind":13,"line":288},{"line":288,"name":"$m","containerName":"_nj","kind":13},{"line":288,"containerName":"_nj","kind":13,"name":"$r"},{"containerName":"_nj","kind":13,"name":"$m","line":288},{"line":288,"name":"$L","kind":13,"containerName":"_nj"},{"line":288,"name":"$dmi","containerName":"_nj","kind":13},{"containerName":"_nj","kind":13,"name":"$dmj","line":288},{"containerName":"_nj","kind":13,"name":"$mat","line":289},{"line":289,"name":"$row","containerName":"_nj","kind":13},{"line":289,"name":"$col","containerName":"_nj","kind":13},{"line":289,"name":"$L","containerName":"_nj","kind":13},{"line":290,"name":"$r","containerName":"_nj","kind":13},{"containerName":"_nj","kind":13,"name":"$mini","line":290},{"name":"$dmk","kind":13,"containerName":"_nj","line":290},{"line":293,"containerName":"_nj","kind":13,"name":"$L"},{"name":"$r","kind":13,"containerName":"_nj","line":294},{"line":294,"name":"$mini","kind":13,"containerName":"_nj"},{"line":294,"name":"$L","containerName":"_nj","kind":13},{"definition":"my","line":298,"kind":13,"localvar":"my","containerName":"_nj","name":"@leftovernodes"},{"name":"@leftovers","kind":13,"containerName":"_nj","line":298},{"line":299,"name":"$k","localvar":"my","containerName":"_nj","kind":13,"definition":"my"},{"name":"$k","containerName":"_nj","kind":13,"line":299},{"line":299,"kind":13,"containerName":"_nj","name":"$N"},{"name":"$k","kind":13,"containerName":"_nj","line":299},{"kind":13,"containerName":"_nj","name":"$nodes","line":300},{"name":"$k","containerName":"_nj","kind":13,"line":300},{"kind":13,"containerName":"_nj","name":"@leftovers","line":301},{"containerName":"_nj","kind":13,"name":"$k","line":301},{"name":"@leftovernodes","kind":13,"containerName":"_nj","line":302},{"name":"$nodes","containerName":"_nj","kind":13,"line":302},{"containerName":"_nj","kind":13,"name":"$k","line":302},{"definition":"my","name":"$l_0","kind":13,"localvar":"my","containerName":"_nj","line":305},{"containerName":"_nj","kind":13,"name":"$l_1","line":305},{"line":305,"containerName":"_nj","kind":13,"name":"$l_2"},{"line":305,"name":"@leftovers","kind":13,"containerName":"_nj"},{"definition":"my","name":"$dist_i","localvar":"my","containerName":"_nj","kind":13,"line":307},{"name":"$mat","containerName":"_nj","kind":13,"line":307},{"kind":13,"containerName":"_nj","name":"$l_1","line":307},{"line":307,"name":"$l_0","kind":13,"containerName":"_nj"},{"name":"$mat","kind":13,"containerName":"_nj","line":307},{"line":307,"containerName":"_nj","kind":13,"name":"$l_2"},{"line":307,"kind":13,"containerName":"_nj","name":"$l_0"},{"containerName":"_nj","kind":13,"name":"$mat","line":308},{"name":"$l_2","kind":13,"containerName":"_nj","line":308},{"name":"$l_1","kind":13,"containerName":"_nj","line":308},{"definition":"my","localvar":"my","kind":13,"containerName":"_nj","name":"$dist_j","line":310},{"name":"$mat","containerName":"_nj","kind":13,"line":310},{"line":310,"name":"$l_1","kind":13,"containerName":"_nj"},{"line":310,"containerName":"_nj","kind":13,"name":"$l_0"},{"containerName":"_nj","kind":13,"name":"$dist_i","line":310},{"definition":"my","line":311,"name":"$dist_k","localvar":"my","kind":13,"containerName":"_nj"},{"line":311,"kind":13,"containerName":"_nj","name":"$mat"},{"line":311,"containerName":"_nj","kind":13,"name":"$l_2"},{"name":"$l_0","kind":13,"containerName":"_nj","line":311},{"kind":13,"containerName":"_nj","name":"$dist_i","line":311},{"containerName":"_nj","kind":13,"name":"$dist_i","line":314},{"name":"$dist_i","containerName":"_nj","kind":13,"line":315},{"name":"$dist_j","kind":13,"containerName":"_nj","line":316},{"line":316,"name":"$mat","containerName":"_nj","kind":13},{"line":316,"name":"$l_1","containerName":"_nj","kind":13},{"line":316,"containerName":"_nj","kind":13,"name":"$l_0"},{"containerName":"_nj","kind":13,"name":"$dist_k","line":317},{"name":"$mat","kind":13,"containerName":"_nj","line":317},{"line":317,"containerName":"_nj","kind":13,"name":"$l_2"},{"name":"$l_0","containerName":"_nj","kind":13,"line":317},{"line":318,"containerName":"_nj","kind":13,"name":"$dist_j"},{"containerName":"_nj","kind":13,"name":"$dist_j","line":319},{"line":320,"containerName":"_nj","kind":13,"name":"$dist_k"},{"line":320,"containerName":"_nj","kind":13,"name":"$mat"},{"line":320,"name":"$l_2","containerName":"_nj","kind":13},{"name":"$l_0","containerName":"_nj","kind":13,"line":320},{"kind":13,"containerName":"_nj","name":"$mat","line":320},{"name":"$l_2","containerName":"_nj","kind":13,"line":320},{"line":320,"name":"$l_1","kind":13,"containerName":"_nj"},{"name":"$dist_k","kind":13,"containerName":"_nj","line":321},{"line":321,"containerName":"_nj","kind":13,"name":"$dist_k"},{"line":322,"kind":13,"containerName":"_nj","name":"$dist_k"},{"kind":13,"containerName":"_nj","name":"$dist_k","line":323},{"line":324,"kind":13,"containerName":"_nj","name":"$dist_j"},{"name":"$mat","containerName":"_nj","kind":13,"line":324},{"line":324,"containerName":"_nj","kind":13,"name":"$l_1"},{"line":324,"name":"$l_0","containerName":"_nj","kind":13},{"name":"$mat","kind":13,"containerName":"_nj","line":324},{"name":"$l_2","kind":13,"containerName":"_nj","line":324},{"line":324,"kind":13,"containerName":"_nj","name":"$l_1"},{"containerName":"_nj","kind":13,"name":"$dist_j","line":325},{"line":325,"name":"$dist_j","kind":13,"containerName":"_nj"},{"containerName":"_nj","kind":13,"name":"$dist_j","line":327},{"line":328,"name":"$dist_j","kind":13,"containerName":"_nj"},{"line":329,"name":"$dist_i","containerName":"_nj","kind":13},{"name":"$mat","containerName":"_nj","kind":13,"line":329},{"kind":13,"containerName":"_nj","name":"$l_1","line":329},{"kind":13,"containerName":"_nj","name":"$l_0","line":329},{"line":330,"containerName":"_nj","kind":13,"name":"$dist_k"},{"line":330,"name":"$mat","containerName":"_nj","kind":13},{"kind":13,"containerName":"_nj","name":"$l_2","line":330},{"name":"$l_1","containerName":"_nj","kind":13,"line":330},{"containerName":"_nj","kind":13,"name":"$dist_i","line":331},{"line":332,"name":"$dist_i","containerName":"_nj","kind":13},{"line":333,"name":"$dist_k","kind":13,"containerName":"_nj"},{"line":333,"kind":13,"containerName":"_nj","name":"$mat"},{"name":"$l_2","kind":13,"containerName":"_nj","line":333},{"line":333,"containerName":"_nj","kind":13,"name":"$l_0"},{"kind":13,"containerName":"_nj","name":"$mat","line":333},{"line":333,"name":"$l_2","containerName":"_nj","kind":13},{"name":"$l_1","kind":13,"containerName":"_nj","line":333},{"name":"$dist_k","kind":13,"containerName":"_nj","line":334},{"kind":13,"containerName":"_nj","name":"$dist_k","line":334},{"containerName":"_nj","kind":13,"name":"$dist_k","line":335},{"name":"$dist_k","containerName":"_nj","kind":13,"line":336},{"name":"$dist_i","kind":13,"containerName":"_nj","line":337},{"name":"$mat","containerName":"_nj","kind":13,"line":337},{"name":"$l_1","containerName":"_nj","kind":13,"line":337},{"name":"$l_0","kind":13,"containerName":"_nj","line":337},{"line":337,"name":"$mat","containerName":"_nj","kind":13},{"line":337,"kind":13,"containerName":"_nj","name":"$l_2"},{"line":337,"name":"$l_0","containerName":"_nj","kind":13},{"kind":13,"containerName":"_nj","name":"$dist_i","line":338},{"line":338,"name":"$dist_i","kind":13,"containerName":"_nj"},{"containerName":"_nj","kind":13,"name":"$dist_k","line":340},{"line":341,"containerName":"_nj","kind":13,"name":"$dist_k"},{"line":342,"kind":13,"containerName":"_nj","name":"$dist_i"},{"containerName":"_nj","kind":13,"name":"$mat","line":342},{"containerName":"_nj","kind":13,"name":"$l_2","line":342},{"line":342,"name":"$l_0","containerName":"_nj","kind":13},{"line":343,"containerName":"_nj","kind":13,"name":"$dist_j"},{"kind":13,"containerName":"_nj","name":"$mat","line":343},{"containerName":"_nj","kind":13,"name":"$l_2","line":343},{"line":343,"name":"$l_1","containerName":"_nj","kind":13},{"line":344,"name":"$dist_i","containerName":"_nj","kind":13},{"containerName":"_nj","kind":13,"name":"$dist_i","line":345},{"name":"$dist_j","containerName":"_nj","kind":13,"line":346},{"line":346,"name":"$mat","containerName":"_nj","kind":13},{"line":346,"name":"$l_1","containerName":"_nj","kind":13},{"containerName":"_nj","kind":13,"name":"$l_0","line":346},{"name":"$mat","kind":13,"containerName":"_nj","line":346},{"line":346,"containerName":"_nj","kind":13,"name":"$l_2"},{"kind":13,"containerName":"_nj","name":"$l_1","line":346},{"line":347,"name":"$dist_j","kind":13,"containerName":"_nj"},{"name":"$dist_j","containerName":"_nj","kind":13,"line":347},{"kind":13,"containerName":"_nj","name":"$dist_j","line":348},{"line":349,"name":"$dist_j","kind":13,"containerName":"_nj"},{"name":"$dist_i","kind":13,"containerName":"_nj","line":350},{"line":350,"containerName":"_nj","kind":13,"name":"$mat"},{"line":350,"containerName":"_nj","kind":13,"name":"$l_1"},{"name":"$l_0","containerName":"_nj","kind":13,"line":350},{"name":"$mat","kind":13,"containerName":"_nj","line":350},{"line":350,"name":"$l_2","kind":13,"containerName":"_nj"},{"line":350,"name":"$l_0","kind":13,"containerName":"_nj"},{"name":"$dist_i","containerName":"_nj","kind":13,"line":351},{"name":"$dist_i","kind":13,"containerName":"_nj","line":351},{"containerName":"_nj","kind":13,"name":"$leftovernodes","line":354},{"kind":12,"containerName":"_nj","name":"branch_length","line":354},{"containerName":"_nj","kind":13,"name":"$precisionstr","line":354},{"line":354,"name":"$dist_i","containerName":"_nj","kind":13},{"line":355,"name":"$leftovernodes","kind":13,"containerName":"_nj"},{"name":"branch_length","kind":12,"containerName":"_nj","line":355},{"line":355,"containerName":"_nj","kind":13,"name":"$precisionstr"},{"line":355,"name":"$dist_j","containerName":"_nj","kind":13},{"name":"$leftovernodes","kind":13,"containerName":"_nj","line":356},{"containerName":"_nj","kind":12,"name":"branch_length","line":356},{"line":356,"containerName":"_nj","kind":13,"name":"$precisionstr"},{"line":356,"name":"$dist_k","containerName":"_nj","kind":13},{"name":"new","kind":12,"containerName":"_nj","line":358},{"containerName":"_nj","kind":12,"name":"new","line":359},{"name":"@leftovernodes","kind":13,"containerName":"_nj","line":359}],"name":"_nj","containerName":"main::"},{"line":198,"name":"Bio","kind":12,"containerName":"Tree::Node"},{"containerName":"Tree::Node","kind":12,"name":"Bio","line":200},{"containerName":"Tree::Tree","kind":12,"name":"Bio","line":203},{"line":208,"containerName":"Tree::Node","kind":12,"name":"Bio"},{"name":"Bio","containerName":"Tree::Node","kind":12,"line":249},{"kind":12,"containerName":"Tree::Tree","name":"Bio","line":358},{"line":358,"name":"Bio","kind":12,"containerName":"Tree::Node"},{"name":"_upgma","containerName":"main::","children":[{"definition":"my","line":374,"kind":13,"localvar":"my","containerName":"_upgma","name":"$self"},{"line":374,"name":"$distmat","containerName":"_upgma","kind":13},{"name":"$precisionstr","localvar":"my","kind":13,"containerName":"_upgma","line":382,"definition":"my"},{"line":384,"name":"$i","localvar":"my","kind":13,"containerName":"_upgma","definition":"my"},{"line":384,"kind":13,"containerName":"_upgma","name":"$j"},{"kind":13,"containerName":"_upgma","name":"$x","line":384},{"line":384,"containerName":"_upgma","kind":13,"name":"$y"},{"name":"@dmat","containerName":"_upgma","kind":13,"line":384},{"kind":13,"containerName":"_upgma","name":"@orig","line":384},{"line":384,"containerName":"_upgma","kind":13,"name":"@nodes"},{"localvar":"my","containerName":"_upgma","kind":13,"name":"@names","line":386,"definition":"my"},{"line":386,"name":"$distmat","containerName":"_upgma","kind":13},{"kind":12,"containerName":"_upgma","name":"column_names","line":386},{"definition":"my","localvar":"my","containerName":"_upgma","kind":13,"name":"$c","line":387},{"definition":"my","localvar":"my","containerName":"_upgma","kind":13,"name":"@clusters","line":388},{"line":389,"localvar":"my","containerName":"_upgma","kind":13,"name":"$r","definition":"my"},{"containerName":"_upgma","kind":13,"name":"$c","line":389},{"line":391,"name":"$c","containerName":"_upgma","kind":13},{"line":393,"name":"$c","kind":13,"containerName":"_upgma"},{"line":394,"containerName":"_upgma","kind":13,"name":"$r"},{"line":395,"name":"@names","kind":13,"containerName":"_upgma"},{"line":397,"kind":13,"localvar":"my","containerName":"_upgma","name":"$K","definition":"my"},{"line":397,"containerName":"_upgma","kind":13,"name":"@clusters"},{"definition":"my","line":398,"name":"@mins","localvar":"my","containerName":"_upgma","kind":13},{"kind":13,"containerName":"_upgma","name":"$min","line":398},{"kind":13,"containerName":"_upgma","name":"$i","line":399},{"name":"$i","kind":13,"containerName":"_upgma","line":399},{"kind":13,"containerName":"_upgma","name":"$K","line":399},{"line":399,"name":"$i","containerName":"_upgma","kind":13},{"kind":13,"containerName":"_upgma","name":"$j","line":400},{"line":400,"containerName":"_upgma","kind":13,"name":"$i"},{"name":"$j","kind":13,"containerName":"_upgma","line":400},{"name":"$K","containerName":"_upgma","kind":13,"line":400},{"name":"$j","containerName":"_upgma","kind":13,"line":400},{"name":"$d","containerName":"_upgma","localvar":"my","kind":13,"line":401,"definition":"my"},{"name":"$distmat","kind":13,"containerName":"_upgma","line":401},{"kind":12,"containerName":"_upgma","name":"get_entry","line":401},{"name":"$names","kind":13,"containerName":"_upgma","line":401},{"line":401,"containerName":"_upgma","kind":13,"name":"$i"},{"line":401,"kind":13,"containerName":"_upgma","name":"$names"},{"line":401,"kind":13,"containerName":"_upgma","name":"$j"},{"line":403,"name":"$dmat","containerName":"_upgma","kind":13},{"name":"$j","containerName":"_upgma","kind":13,"line":403},{"line":403,"kind":13,"containerName":"_upgma","name":"$i"},{"line":403,"name":"$dmat","kind":13,"containerName":"_upgma"},{"line":403,"containerName":"_upgma","kind":13,"name":"$i"},{"containerName":"_upgma","kind":13,"name":"$j","line":403},{"line":403,"containerName":"_upgma","kind":13,"name":"$d"},{"name":"$orig","containerName":"_upgma","kind":13,"line":404},{"line":404,"containerName":"_upgma","kind":13,"name":"$i"},{"line":404,"name":"$j","containerName":"_upgma","kind":13},{"name":"$orig","containerName":"_upgma","kind":13,"line":404},{"line":404,"containerName":"_upgma","kind":13,"name":"$j"},{"line":404,"containerName":"_upgma","kind":13,"name":"$i"},{"line":404,"name":"$d","containerName":"_upgma","kind":13},{"line":405,"containerName":"_upgma","kind":13,"name":"$min"},{"line":405,"name":"$d","containerName":"_upgma","kind":13},{"kind":13,"containerName":"_upgma","name":"$min","line":405},{"name":"$min","containerName":"_upgma","kind":13,"line":406},{"name":"$min","kind":13,"containerName":"_upgma","line":406},{"line":406,"containerName":"_upgma","kind":13,"name":"$d"},{"name":"@mins","kind":13,"containerName":"_upgma","line":407},{"name":"$i","kind":13,"containerName":"_upgma","line":407},{"name":"$j","containerName":"_upgma","kind":13,"line":407},{"line":409,"containerName":"_upgma","kind":13,"name":"@mins"},{"name":"$i","kind":13,"containerName":"_upgma","line":409},{"containerName":"_upgma","kind":13,"name":"$j","line":409},{"line":410,"name":"$min","containerName":"_upgma","kind":13},{"line":410,"name":"$d","containerName":"_upgma","kind":13},{"line":417,"containerName":"_upgma","kind":13,"name":"$K"},{"line":420,"name":"$min","kind":13,"containerName":"_upgma"},{"name":"$i","containerName":"_upgma","kind":13,"line":421},{"containerName":"_upgma","kind":13,"name":"$i","line":421},{"line":421,"containerName":"_upgma","kind":13,"name":"$K"},{"line":421,"name":"$i","containerName":"_upgma","kind":13},{"line":422,"containerName":"_upgma","kind":13,"name":"$j"},{"containerName":"_upgma","kind":13,"name":"$i","line":422},{"line":422,"name":"$j","containerName":"_upgma","kind":13},{"line":422,"containerName":"_upgma","kind":13,"name":"$K"},{"kind":13,"containerName":"_upgma","name":"$j","line":422},{"containerName":"_upgma","localvar":"my","kind":13,"name":"$dij","line":423,"definition":"my"},{"line":423,"kind":13,"containerName":"_upgma","name":"$dmat"},{"line":423,"name":"$i","kind":13,"containerName":"_upgma"},{"containerName":"_upgma","kind":13,"name":"$j","line":423},{"line":424,"name":"$min","containerName":"_upgma","kind":13},{"line":425,"containerName":"_upgma","kind":13,"name":"$dij"},{"line":425,"kind":13,"containerName":"_upgma","name":"$min"},{"name":"$min","kind":13,"containerName":"_upgma","line":426},{"line":427,"name":"$min","kind":13,"containerName":"_upgma"},{"kind":13,"containerName":"_upgma","name":"$dij","line":427},{"line":428,"containerName":"_upgma","kind":13,"name":"@mins"},{"line":428,"name":"$i","kind":13,"containerName":"_upgma"},{"line":428,"containerName":"_upgma","kind":13,"name":"$j"},{"name":"@mins","kind":13,"containerName":"_upgma","line":430},{"name":"$i","containerName":"_upgma","kind":13,"line":430},{"line":430,"containerName":"_upgma","kind":13,"name":"$j"},{"line":431,"containerName":"_upgma","kind":13,"name":"$min"},{"line":431,"name":"$dij","kind":13,"containerName":"_upgma"},{"line":438,"kind":13,"containerName":"_upgma","name":"$x"},{"line":438,"kind":13,"containerName":"_upgma","name":"$y"},{"line":438,"kind":13,"containerName":"_upgma","name":"$mins"},{"name":"@mins","containerName":"_upgma","kind":13,"line":438},{"line":442,"kind":13,"localvar":"my","containerName":"_upgma","name":"$node","definition":"my"},{"name":"new","containerName":"_upgma","kind":12,"line":442},{"kind":13,"localvar":"my","containerName":"_upgma","name":"@subids","line":443,"definition":"my"},{"definition":"my","localvar":"my","containerName":"_upgma","kind":13,"name":"$cid","line":444},{"line":444,"name":"$x","containerName":"_upgma","kind":13},{"line":444,"name":"$y","containerName":"_upgma","kind":13},{"line":445,"localvar":"my","containerName":"_upgma","kind":13,"name":"$nid","definition":"my"},{"name":"$clusters","containerName":"_upgma","kind":13,"line":445},{"line":445,"name":"$cid","containerName":"_upgma","kind":13},{"name":"$nodes","containerName":"_upgma","kind":13,"line":446},{"name":"$nid","containerName":"_upgma","kind":13,"line":446},{"line":447,"containerName":"_upgma","kind":13,"name":"$nodes"},{"containerName":"_upgma","kind":13,"name":"$nid","line":447},{"name":"new","containerName":"_upgma","kind":12,"line":447},{"name":"$names","kind":13,"containerName":"_upgma","line":447},{"containerName":"_upgma","kind":13,"name":"$nid","line":447},{"line":449,"kind":13,"containerName":"_upgma","name":"$nodes"},{"line":449,"kind":13,"containerName":"_upgma","name":"$nid"},{"name":"branch_length","containerName":"_upgma","kind":12,"line":450},{"name":"$precisionstr","containerName":"_upgma","kind":13,"line":450},{"name":"$min","kind":13,"containerName":"_upgma","line":450},{"containerName":"_upgma","kind":13,"name":"$clusters","line":450},{"line":450,"containerName":"_upgma","kind":13,"name":"$cid"},{"line":451,"name":"$node","containerName":"_upgma","kind":13},{"line":451,"containerName":"_upgma","kind":12,"name":"add_Descendent"},{"line":451,"kind":13,"containerName":"_upgma","name":"$nodes"},{"name":"$nid","containerName":"_upgma","kind":13,"line":451},{"line":452,"containerName":"_upgma","kind":13,"name":"@subids"},{"line":452,"containerName":"_upgma","kind":13,"name":"$clusters"},{"name":"$cid","containerName":"_upgma","kind":13,"line":452}],"detail":"($self,$distmat)","definition":"sub","kind":12,"range":{"end":{"line":453,"character":9999},"start":{"character":0,"line":373}},"line":373,"signature":{"parameters":[{"label":"$self"},{"label":"$distmat"}],"documentation":"1;\n# $Id: DistanceFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::DistanceFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::DistanceFactory - Construct a tree using distance based methods\n\n=head1 SYNOPSIS\n\n  use Bio::Tree::DistanceFactory;\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n  my $tfactory = Bio::Tree::DistanceFactory->new(-method => \"NJ\");\n  my $stats    = Bio::Align::DNAStatistics->new();\n\n  my $alnin    = Bio::AlignIO->new(-format => 'clustalw',\n                                   -file   => 'file.aln');\n  my $aln = $alnin->next_aln;\n  # Of course matrix can come from a different place\n  # like PHYLIP if you prefer, Bio::Matrix::IO should be able\n  # to parse many things\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n  my $tree = $tfactory->make_tree($jcmatrix);\n\n\n=head1 DESCRIPTION\n\nThis is a factory which will construct a phylogenetic tree based on\nthe pairwise sequence distances for a set of sequences.  Currently\nUPGMA (Sokal and Michener 1958) and NJ (Saitou and Nei 1987) tree\nconstruction methods are implemented.\n\n=head1 REFERENCES\n\nEddy SR, Durbin R, Krogh A, Mitchison G, (1998) \"Biological Sequence Analysis\",\nCambridge Univ Press, Cambridge, UK.\n\nHowe K, Bateman A, Durbin R, (2002) \"QuickTree: building huge\nNeighbour-Joining trees of protein sequences.\" Bioinformatics\n18(11):1546-1547.\n\nSaitou N and Nei M, (1987) \"The neighbor-joining method: a new method\nfor reconstructing phylogenetic trees.\" Mol Biol Evol 4(4):406-25.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tree::DistanceFactory;\nuse vars qw($DefaultMethod $Precision);\nuse strict;\n\n# some defaults\n$DefaultMethod = 'UPGMA';\n$Precision = 5;\n\nuse Bio::Tree::Node;\nuse Bio::Tree::Tree;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::DistanceFactory->new();\n Function: Builds a new Bio::Tree::DistanceFactory object \n Returns : an instance of Bio::Tree::DistanceFactory\n Args    : -method => 'NJ' or 'UPGMA'\n\n\n\nsub new {\n  my($class,@args) = @_;  \n  my $self = $class->SUPER::new(@args);\n\n  my ($method) = $self->_rearrange([qw(METHOD)],\n\t\t\t\t   @args);\n  $self->method($method || $DefaultMethod);\n  return $self;\n}\n\n=head2 make_tree\n\n Title   : make_tree\n Usage   : my $tree = $disttreefact->make_tree($matrix);\n Function: Build a Tree based on a distance matrix\n Returns : L<Bio::Tree::TreeI>\n Args    : L<Bio::Matrix::MatrixI> object\n\n\n\nsub make_tree{\n   my ($self,$matrix) = @_;\n   if( ! defined $matrix || !ref($matrix) || \n       ! $matrix->isa('Bio::Matrix::MatrixI') ) {\n       $self->warn(\"Need to provide a valid Bio::Matrix::MatrixI object to make_tree\");\n       return;\n   }\n\n   my $method = uc ($self->method);\n   if( $method =~ /NJ/i ) {\n       return $self->_nj($matrix);\n   } elsif( $method =~ /UPGMA/i ) {\n       return $self->_upgma($matrix);\n   } else { \n       $self->warn(\"Unknown tree construction method '$method'.  Cannot run.\");\n       return;\n   }\n   \n}\n\n\n=head2 _nj\n\n Title   : _nj\n Usage   : my $tree = $disttreefact->_nj($matrix);\n Function: Construct a tree based on distance matrix using the \n           Neighbor Joining algorithm (Saitou and Nei, 1987)\n           Implementation based on Kevin Howe's Quicktree implementation\n           and uses his tricks (some based on Bill Bruno's work) to eliminate\n           negative branch lengths\n Returns : L<Bio::Tree::TreeI>\n Args    : L<Bio::Matrix::MatrixI> object\n\n\nsub _nj {\n   my ($self,$distmat) = @_;\n\n   # we assume type checking of $aln has already been done\n   # client shouldn't be calling this directly anyways, using the\n   # make_tree method is preferred\n   \n   # so that we can trim the number of digits shown as the branch length\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   my @names =  $distmat->column_names;\n   my $N = scalar @names;\n   my ($i,$j,$m,@nodes,$mat,@r);\n   my $L = $N;\n\n   if( $N < 2 ) {\n       $self->warn(\"Can only perform NJ treebuilding on sets of 2 or more species\\n\");\n       return;\n   } elsif( $N == 2 ) {\n       $i = 0;\n       my $d = sprintf($precisionstr,\n\t\t       $distmat->get_entry($names[0],$names[1]) / 2);\n       my $root = Bio::Tree::Node->new();\n       for my $nm ( @names ) {\n\t   $root->add_Descendents( Bio::Tree::Node->new(-id => $nm,\n\t\t\t\t\t\t\t-branch_length => $d));\n       }\n       return Bio::Tree::Tree(-root => $root);\n   }\n   my $c = 0;\n   \n   for ( $i = 0; $i < $N; $i++ ) {\n       push @nodes, Bio::Tree::Node->new(-id => $names[$i]);\n       my $ri = 0;\n       for( $j = 0; $j < $N; $j++ ) {\n\t   $mat->[$i][$j] = $distmat->get_entry($names[$i],$names[$j]);\n\t   $ri += $mat->[$i][$j];\n       }\n       $r[$i] = $ri / ($L -2);\n   }\n   \n   for( my $nodecount = 0; $nodecount < $N-3; $nodecount++) {\n       my ($mini,$minj,$min);\n       for($i = 0; $i < $N; $i++ ) {\n\t   next unless defined $nodes[$i];\n\t   for( $j = 0; $j < $i; $j++ ) {\n\t       next unless defined $nodes[$j];\n\t       my $dist = $mat->[$i][$j] - ($r[$i] + $r[$j]);\n\t       if( ! defined $min ||\n\t\t   $dist <= $min) {\n\t\t   ($mini,$minj,$min) = ($i,$j,$dist);\n\t       }\n\t   }\n       }\n       my $dij    = $mat->[$mini][$minj];\n       my $dist_i = ($dij + $r[$mini] - $r[$minj]) / 2;\n       my $dist_j = $dij - $dist_i;\n       \n       # deal with negative branch lengths\n       # per code in K.Howe's quicktree\n       if( $dist_i < 0 ) {\n\t   $dist_i = 0;\n\t   $dist_j = $dij;\n\t   $dist_j = 0 if( $dist_j < 0 );\n       } elsif( $dist_j < 0 ) { \n\t   $dist_j = 0;\n\t   $dist_i = $dij;\n\t   $dist_i = 0 if( $dist_i < 0 );\n       }\n       \n       $nodes[$mini]->branch_length(sprintf($precisionstr,$dist_i));\n       $nodes[$minj]->branch_length(sprintf($precisionstr,$dist_j));\n       \n       my $newnode = Bio::Tree::Node->new(-descendents => [ $nodes[$mini],\n\t\t\t\t\t\t\t    $nodes[$minj] ]);\n\n       $nodes[$mini] = $newnode;\n       delete $nodes[$minj];\n       \n       # update the distance matrix\n       $r[$mini] = 0;\n       my ($dmi,$dmj);\n       for( $m = 0; $m < $N; $m++ ) {\t   \n\t   next unless defined $nodes[$m];\n\t   if( $m != $mini ) {\n\t       $dmj = $mat->[$m][$minj];\n\t       \n\t       my ($row,$col);\n\t       ($row,$col) = ($m,$mini);\n\t       $dmi = $mat->[$row][$col];\n\t       \n\t       # from K.Howe's notes in quicktree\n\t       # we can actually adjust r[m] here, by using the form:\n\t       # rm = ((rm * numseqs) - dmi - dmj + dmk) / (numseqs-1)\n\n\t       # Note: in Bill Bruno's method for negative branch\n\t       # elimination, then if either dist_i is positive and\n\t       # dist_j is 0, or dist_i is zero and dist_j is positive\n\t       # (after adjustment) then the matrix entry is formed\n\t       # from the distance to the node in question (m) to the\n\t       # node with the zero branch length (whichever it was).\n\t       # I think my code already has the same effect; this is\n\t       # certainly true if dij is equal to dist_i + dist_j,\n\t       # which it should have been fixed to\n\n\t       my $dmk = $mat->[$row][$col] = $mat->[$col][$row] = \n\t\t   ($dmi + $dmj - $dij) / 2;\n\t       \n\t       # If we don't want to try and correct negative brlens\n\t       # this is essentially what is in Edddy et al, BSA book.\n\t       # $r[$m] = (($r[$m] * $L) - $dmi - $dmj + $dmk) / ($L-1);\n\t       # \n\t       $r[$m] = (($r[$m] * ($L - 2)) - $dmi - $dmj + \n\t\t\t $mat->[$row][$col]) / ( $L - 3);\n\t       $r[$mini] += $dmk;\n\t   }\n       }\n       $L--;\n       $r[$mini] /= $L - 2;\n   }\n   \n   # should be 3 nodes left\n   my (@leftovernodes,@leftovers);\n   for( my $k = 0; $k < $N; $k++ ) {\n       if( defined $nodes[$k] ) {\n\t   push @leftovers, $k;\n\t   push @leftovernodes, $nodes[$k];\n       }\n   }\n   my ($l_0,$l_1,$l_2) = @leftovers;\n   \n   my $dist_i = ( $mat->[$l_1][$l_0] + $mat->[$l_2][$l_0] -\n\t\t  $mat->[$l_2][$l_1] ) / 2;\n   \n   my $dist_j = ( $mat->[$l_1][$l_0] - $dist_i);\n   my $dist_k = ( $mat->[$l_2][$l_0] - $dist_i);\n\n   # This is Kev's code to get rid of negative branch lengths\n   if( $dist_i < 0 ) { \n       $dist_i = 0;\n       $dist_j = $mat->[$l_1][$l_0];\n       $dist_k = $mat->[$l_2][$l_0];\n       if( $dist_j < 0 ) { \n\t   $dist_j = 0;\n\t   $dist_k = ( $mat->[$l_2][$l_0] + $mat->[$l_2][$l_1] ) / 2;\n\t   $dist_k = 0 if( $dist_k < 0 );\n       } elsif( $dist_k < 0 ) {\n\t   $dist_k = 0;\n\t   $dist_j = ($mat->[$l_1][$l_0] + $mat->[$l_2][$l_1]) / 2;\n\t   $dist_j = 0 if( $dist_j < 0 );\n       }\n   } elsif( $dist_j < 0 ) {\n       $dist_j = 0;\n       $dist_i = $mat->[$l_1][$l_0];\n       $dist_k = $mat->[$l_2][$l_1];\n       if( $dist_i < 0 ) { \n\t   $dist_i = 0;\n\t   $dist_k = ( $mat->[$l_2][$l_0] + $mat->[$l_2][$l_1]) / 2;\n\t   $dist_k = 0 if( $dist_k  < 0 );\n       } elsif( $dist_k < 0 ) { \n\t   $dist_k = 0;\n\t   $dist_i = ( $mat->[$l_1][$l_0] + $mat->[$l_2][$l_0]) / 2;\n\t   $dist_i = 0 if( $dist_i < 0 );\n       }\n   } elsif( $dist_k < 0 ) {\n       $dist_k = 0;\n       $dist_i = $mat->[$l_2][$l_0];\n       $dist_j = $mat->[$l_2][$l_1];\n       if( $dist_i < 0 ) { \n\t   $dist_i = 0;\n\t   $dist_j = ( $mat->[$l_1][$l_0] + $mat->[$l_2][$l_1] ) / 2;\n\t   $dist_j = 0 if $dist_j < 0;\n       } elsif( $dist_j < 0  ) {\n\t   $dist_j = 0;\n\t   $dist_i = ($mat->[$l_1][$l_0] + $mat->[$l_2][$l_0]) / 2;\n\t   $dist_i = 0 if $dist_i < 0;\n       }\n   }\n   $leftovernodes[0]->branch_length(sprintf($precisionstr,$dist_i));\n   $leftovernodes[1]->branch_length(sprintf($precisionstr,$dist_j));\n   $leftovernodes[2]->branch_length(sprintf($precisionstr,$dist_k));\n\n   Bio::Tree::Tree->new(-root => Bio::Tree::Node->new\n\t\t\t(-descendents => \\@leftovernodes));\n}\n\n=head2 _upgma\n\n Title   : _upgma\n Usage   : my $tree = $disttreefact->_upgma($matrix);\n Function: Construct a tree based on alignment using UPGMA\n Returns : L<Bio::Tree::TreeI>\n Args    : L<Bio::Matrix::MatrixI> object","label":"_upgma($self,$distmat)"}},{"containerName":"Tree::Node","kind":12,"name":"Bio","line":442},{"line":447,"name":"Bio","kind":12,"containerName":"Tree::Node"},{"name":"%cluster","localvar":"my","containerName":null,"kind":13,"line":454,"definition":"my"},{"containerName":null,"kind":13,"name":"$c","line":454},{"line":455,"containerName":null,"kind":13,"name":"@min"},{"name":"@subids","kind":13,"containerName":null,"line":456},{"line":459,"name":"$K","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"@nodes","line":460},{"name":"%cluster","kind":13,"containerName":null,"line":460},{"kind":13,"containerName":null,"name":"$node","line":460},{"name":"$y","containerName":null,"kind":13,"line":461},{"name":"%K","containerName":null,"kind":13,"line":461},{"name":"@clusters","containerName":null,"kind":13,"line":462},{"kind":13,"containerName":null,"name":"$y","line":462},{"line":462,"kind":13,"containerName":null,"name":"@clusters"},{"line":462,"kind":13,"containerName":null,"name":"$K"},{"name":"@dmat","kind":13,"containerName":null,"line":463},{"name":"$y","containerName":null,"kind":13,"line":463},{"line":463,"name":"@dmat","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$K","line":463},{"line":464,"name":"$i","kind":13,"containerName":null},{"line":464,"containerName":null,"kind":13,"name":"$i"},{"name":"$K","containerName":null,"kind":13,"line":464},{"containerName":null,"kind":13,"name":"%i","line":464},{"line":465,"kind":13,"containerName":null,"name":"@dmat"},{"line":465,"kind":13,"containerName":null,"name":"@i"},{"name":"$y","kind":13,"containerName":null,"line":465},{"line":465,"name":"@dmat","kind":13,"containerName":null},{"name":"@y","containerName":null,"kind":13,"line":465},{"line":465,"name":"$i","kind":13,"containerName":null},{"line":468,"kind":13,"containerName":null,"name":"@clusters"},{"containerName":null,"kind":13,"name":"$K","line":468},{"containerName":null,"kind":13,"name":"@clusters","line":469},{"line":469,"name":"$x","kind":13,"containerName":null},{"line":469,"kind":13,"containerName":null,"name":"$cluster"},{"line":471,"name":"$i","containerName":null,"kind":13},{"line":471,"name":"$i","containerName":null,"kind":13},{"name":"$K","containerName":null,"kind":13,"line":471},{"name":"%i","containerName":null,"kind":13,"line":471},{"containerName":null,"kind":13,"name":"$i","line":472},{"name":"%x","containerName":null,"kind":13,"line":472},{"line":473,"containerName":null,"kind":13,"name":"@dmat"},{"line":473,"containerName":null,"kind":13,"name":"@i"},{"containerName":null,"kind":13,"name":"$x","line":473},{"line":473,"containerName":null,"kind":13,"name":"@dmat"},{"name":"@x","containerName":null,"kind":13,"line":473},{"name":"$i","containerName":null,"kind":13,"line":473},{"kind":12,"name":"_upgma_distance","line":474},{"kind":13,"containerName":null,"name":"@clusters","line":474},{"line":474,"containerName":null,"kind":13,"name":"$i"},{"line":474,"kind":13,"containerName":null,"name":"@clusters"},{"line":474,"name":"$x","containerName":null,"kind":13},{"line":474,"name":"@orig","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"@dmat","line":476},{"name":"@i","containerName":null,"kind":13,"line":476},{"containerName":null,"kind":13,"name":"$i","line":476},{"line":481,"name":"@mins","kind":13,"containerName":null},{"name":"$min","containerName":null,"kind":13,"line":482},{"line":484,"containerName":"Tree::Tree","kind":12,"name":"Bio"},{"containerName":"main::","kind":12,"name":"new","line":484},{"name":"@nodes","containerName":null,"kind":13,"line":484},{"containerName":"main::","name":"_upgma_distance","children":[{"definition":"my","line":495,"localvar":"my","containerName":"_upgma_distance","kind":13,"name":"$cluster_i"},{"name":"$cluster_j","containerName":"_upgma_distance","kind":13,"line":495},{"containerName":"_upgma_distance","kind":13,"name":"$distances","line":495},{"containerName":"_upgma_distance","localvar":"my","kind":13,"name":"$ilen","line":496,"definition":"my"},{"line":496,"name":"$cluster_i","kind":13,"containerName":"_upgma_distance"}],"detail":"($cluster_i,$cluster_j,$distances)","definition":"sub","kind":12,"range":{"start":{"line":494,"character":0},"end":{"line":496,"character":9999}},"line":494,"signature":{"label":"_upgma_distance($cluster_i,$cluster_j,$distances)","documentation":" calculate avg distance between clusters - be they\n single sequences or the combination of multiple seqences\n $cluster_i and $cluster_j are the clusters to operate on\n and $distances is a matrix (arrayref of arrayrefs) of pairwise\n differences indexed on the sequence ids -\n so $distances->[0][1] is the distance between sequences 0 and 1","parameters":[{"label":"$cluster_i"},{"label":"$cluster_j"},{"label":"$distances"}]}},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"$jlen","line":497},{"line":497,"name":"%cluster_j","containerName":null,"kind":13},{"definition":"my","name":"$d","containerName":null,"localvar":"my","kind":13,"line":498},{"kind":13,"containerName":null,"name":"$count","line":498},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"$i","line":499},{"containerName":null,"kind":13,"name":"$i","line":499},{"kind":13,"containerName":null,"name":"$ilen","line":499},{"line":499,"containerName":null,"kind":13,"name":"%i"},{"line":500,"name":"$i_id","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"containerName":null,"kind":13,"name":"%cluster_i","line":500},{"name":"$i","containerName":null,"kind":13,"line":500},{"kind":13,"localvar":"my","containerName":null,"name":"$j","line":501,"definition":"my"},{"name":"$j","kind":13,"containerName":null,"line":501},{"kind":13,"containerName":null,"name":"$jlen","line":501},{"line":501,"containerName":null,"kind":13,"name":"%j"},{"definition":"my","name":"$j_id","kind":13,"localvar":"my","containerName":null,"line":502},{"name":"%cluster_j","containerName":null,"kind":13,"line":502},{"name":"$j","containerName":null,"kind":13,"line":502},{"line":503,"kind":13,"containerName":null,"name":"@distances"},{"kind":13,"containerName":null,"name":"@i_id","line":503},{"line":503,"kind":13,"containerName":null,"name":"%j_id"},{"name":"$d","containerName":null,"kind":13,"line":506},{"line":506,"name":"@distances","containerName":null,"kind":13},{"name":"@i_id","kind":13,"containerName":null,"line":506},{"line":506,"name":"$j_id","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$count","line":508},{"name":"$d","containerName":null,"kind":13,"line":511},{"line":511,"kind":13,"containerName":null,"name":"$count"},{"children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"method","line":527},{"line":528,"name":"$self","containerName":"method","kind":13},{"line":529,"name":"$self","containerName":"method","kind":13}],"name":"method","containerName":"main::","definition":"sub","line":526,"kind":12,"range":{"start":{"character":0,"line":526},"end":{"line":530,"character":9999}}},{"children":[{"definition":"my","line":551,"kind":13,"localvar":"my","containerName":"check_additivity","name":"$self"},{"line":551,"name":"$matrix","kind":13,"containerName":"check_additivity"},{"line":552,"containerName":"check_additivity","localvar":"my","kind":13,"name":"@names","definition":"my"},{"containerName":"check_additivity","kind":13,"name":"$matrix","line":552},{"name":"column_names","kind":12,"containerName":"check_additivity","line":552},{"definition":"my","line":553,"kind":13,"localvar":"my","containerName":"check_additivity","name":"$len"},{"name":"@names","kind":13,"containerName":"check_additivity","line":553},{"containerName":"check_additivity","kind":13,"name":"$len","line":554},{"definition":"my","localvar":"my","kind":13,"containerName":"check_additivity","name":"$i","line":556},{"line":556,"name":"$i","kind":13,"containerName":"check_additivity"},{"line":556,"kind":13,"containerName":"check_additivity","name":"$len"},{"name":"$i","kind":13,"containerName":"check_additivity","line":556},{"localvar":"my","containerName":"check_additivity","kind":13,"name":"$j","line":557,"definition":"my"},{"line":557,"containerName":"check_additivity","kind":13,"name":"$i"},{"line":557,"name":"$j","kind":13,"containerName":"check_additivity"},{"line":557,"name":"$len","kind":13,"containerName":"check_additivity"},{"name":"$j","kind":13,"containerName":"check_additivity","line":557},{"line":558,"name":"$k","kind":13,"localvar":"my","containerName":"check_additivity","definition":"my"},{"kind":13,"containerName":"check_additivity","name":"$j","line":558},{"name":"$k","containerName":"check_additivity","kind":13,"line":558},{"kind":13,"containerName":"check_additivity","name":"$len","line":558},{"name":"$k","kind":13,"containerName":"check_additivity","line":558},{"definition":"my","name":"$m","localvar":"my","kind":13,"containerName":"check_additivity","line":559},{"line":559,"containerName":"check_additivity","kind":13,"name":"$k"},{"line":559,"name":"$m","containerName":"check_additivity","kind":13},{"line":559,"name":"$len","kind":13,"containerName":"check_additivity"},{"line":559,"name":"$m","containerName":"check_additivity","kind":13},{"definition":"my","localvar":"my","kind":13,"containerName":"check_additivity","name":"$DijDkm","line":560},{"line":560,"kind":13,"containerName":"check_additivity","name":"$matrix"},{"name":"get_entry","kind":12,"containerName":"check_additivity","line":560},{"line":560,"containerName":"check_additivity","kind":13,"name":"$names"},{"name":"$i","containerName":"check_additivity","kind":13,"line":560},{"name":"$names","containerName":"check_additivity","kind":13,"line":560},{"name":"$j","kind":13,"containerName":"check_additivity","line":560},{"containerName":"check_additivity","kind":13,"name":"$matrix","line":561},{"name":"get_entry","kind":12,"containerName":"check_additivity","line":561},{"containerName":"check_additivity","kind":13,"name":"$names","line":561},{"containerName":"check_additivity","kind":13,"name":"$k","line":561},{"line":561,"name":"$names","kind":13,"containerName":"check_additivity"},{"line":561,"name":"$m","kind":13,"containerName":"check_additivity"},{"kind":13,"localvar":"my","containerName":"check_additivity","name":"$DikDjm","line":562,"definition":"my"},{"name":"$matrix","kind":13,"containerName":"check_additivity","line":562},{"kind":12,"containerName":"check_additivity","name":"get_entry","line":562},{"name":"$names","containerName":"check_additivity","kind":13,"line":562},{"line":562,"kind":13,"containerName":"check_additivity","name":"$i"},{"name":"$names","kind":13,"containerName":"check_additivity","line":562},{"name":"$k","kind":13,"containerName":"check_additivity","line":562},{"line":563,"name":"$matrix","containerName":"check_additivity","kind":13},{"line":563,"containerName":"check_additivity","kind":12,"name":"get_entry"},{"containerName":"check_additivity","kind":13,"name":"$names","line":563},{"containerName":"check_additivity","kind":13,"name":"$j","line":563},{"containerName":"check_additivity","kind":13,"name":"$names","line":563},{"line":563,"kind":13,"containerName":"check_additivity","name":"$m"},{"line":564,"name":"$DimDjk","kind":13,"localvar":"my","containerName":"check_additivity","definition":"my"},{"line":564,"name":"$matrix","kind":13,"containerName":"check_additivity"},{"name":"get_entry","kind":12,"containerName":"check_additivity","line":564},{"kind":13,"containerName":"check_additivity","name":"$names","line":564},{"name":"$i","containerName":"check_additivity","kind":13,"line":564},{"kind":13,"containerName":"check_additivity","name":"$names","line":564},{"containerName":"check_additivity","kind":13,"name":"$m","line":564},{"kind":13,"containerName":"check_additivity","name":"$matrix","line":565},{"name":"get_entry","kind":12,"containerName":"check_additivity","line":565},{"line":565,"kind":13,"containerName":"check_additivity","name":"$names"},{"name":"$j","kind":13,"containerName":"check_additivity","line":565},{"line":565,"containerName":"check_additivity","kind":13,"name":"$names"},{"kind":13,"containerName":"check_additivity","name":"$k","line":565},{"line":566,"containerName":"check_additivity","kind":13,"name":"$DijDkm"},{"line":566,"name":"$DikDjm","kind":13,"containerName":"check_additivity"},{"kind":13,"containerName":"check_additivity","name":"$DijDkm","line":566},{"kind":13,"containerName":"check_additivity","name":"$DimDjk","line":566},{"name":"$DijDkm","containerName":"check_additivity","kind":13,"line":567},{"line":567,"name":"$DimDjk","containerName":"check_additivity","kind":13},{"line":567,"containerName":"check_additivity","kind":13,"name":"$DijDkm"},{"name":"$DikDjm","kind":13,"containerName":"check_additivity","line":567},{"line":568,"name":"$DikDjm","kind":13,"containerName":"check_additivity"},{"line":568,"name":"$DimDjk","kind":13,"containerName":"check_additivity"},{"name":"$DikDjm","kind":13,"containerName":"check_additivity","line":568},{"line":568,"name":"$DijDkm","kind":13,"containerName":"check_additivity"}],"name":"check_additivity","containerName":"main::","definition":"sub","detail":"($self,$matrix)","line":550,"kind":12,"range":{"start":{"line":550,"character":0},"end":{"line":576,"character":9999}},"signature":{"documentation":"1;\n# $Id: DistanceFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::DistanceFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::DistanceFactory - Construct a tree using distance based methods\n\n=head1 SYNOPSIS\n\n  use Bio::Tree::DistanceFactory;\n  use Bio::AlignIO;\n  use Bio::Align::DNAStatistics;\n  my $tfactory = Bio::Tree::DistanceFactory->new(-method => \"NJ\");\n  my $stats    = Bio::Align::DNAStatistics->new();\n\n  my $alnin    = Bio::AlignIO->new(-format => 'clustalw',\n                                   -file   => 'file.aln');\n  my $aln = $alnin->next_aln;\n  # Of course matrix can come from a different place\n  # like PHYLIP if you prefer, Bio::Matrix::IO should be able\n  # to parse many things\n  my $jcmatrix = $stats->distance(-align => $aln, \n                                  -method => 'Jukes-Cantor');\n  my $tree = $tfactory->make_tree($jcmatrix);\n\n\n=head1 DESCRIPTION\n\nThis is a factory which will construct a phylogenetic tree based on\nthe pairwise sequence distances for a set of sequences.  Currently\nUPGMA (Sokal and Michener 1958) and NJ (Saitou and Nei 1987) tree\nconstruction methods are implemented.\n\n=head1 REFERENCES\n\nEddy SR, Durbin R, Krogh A, Mitchison G, (1998) \"Biological Sequence Analysis\",\nCambridge Univ Press, Cambridge, UK.\n\nHowe K, Bateman A, Durbin R, (2002) \"QuickTree: building huge\nNeighbour-Joining trees of protein sequences.\" Bioinformatics\n18(11):1546-1547.\n\nSaitou N and Nei M, (1987) \"The neighbor-joining method: a new method\nfor reconstructing phylogenetic trees.\" Mol Biol Evol 4(4):406-25.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tree::DistanceFactory;\nuse vars qw($DefaultMethod $Precision);\nuse strict;\n\n# some defaults\n$DefaultMethod = 'UPGMA';\n$Precision = 5;\n\nuse Bio::Tree::Node;\nuse Bio::Tree::Tree;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::DistanceFactory->new();\n Function: Builds a new Bio::Tree::DistanceFactory object \n Returns : an instance of Bio::Tree::DistanceFactory\n Args    : -method => 'NJ' or 'UPGMA'\n\n\n\nsub new {\n  my($class,@args) = @_;  \n  my $self = $class->SUPER::new(@args);\n\n  my ($method) = $self->_rearrange([qw(METHOD)],\n\t\t\t\t   @args);\n  $self->method($method || $DefaultMethod);\n  return $self;\n}\n\n=head2 make_tree\n\n Title   : make_tree\n Usage   : my $tree = $disttreefact->make_tree($matrix);\n Function: Build a Tree based on a distance matrix\n Returns : L<Bio::Tree::TreeI>\n Args    : L<Bio::Matrix::MatrixI> object\n\n\n\nsub make_tree{\n   my ($self,$matrix) = @_;\n   if( ! defined $matrix || !ref($matrix) || \n       ! $matrix->isa('Bio::Matrix::MatrixI') ) {\n       $self->warn(\"Need to provide a valid Bio::Matrix::MatrixI object to make_tree\");\n       return;\n   }\n\n   my $method = uc ($self->method);\n   if( $method =~ /NJ/i ) {\n       return $self->_nj($matrix);\n   } elsif( $method =~ /UPGMA/i ) {\n       return $self->_upgma($matrix);\n   } else { \n       $self->warn(\"Unknown tree construction method '$method'.  Cannot run.\");\n       return;\n   }\n   \n}\n\n\n=head2 _nj\n\n Title   : _nj\n Usage   : my $tree = $disttreefact->_nj($matrix);\n Function: Construct a tree based on distance matrix using the \n           Neighbor Joining algorithm (Saitou and Nei, 1987)\n           Implementation based on Kevin Howe's Quicktree implementation\n           and uses his tricks (some based on Bill Bruno's work) to eliminate\n           negative branch lengths\n Returns : L<Bio::Tree::TreeI>\n Args    : L<Bio::Matrix::MatrixI> object\n\n\nsub _nj {\n   my ($self,$distmat) = @_;\n\n   # we assume type checking of $aln has already been done\n   # client shouldn't be calling this directly anyways, using the\n   # make_tree method is preferred\n   \n   # so that we can trim the number of digits shown as the branch length\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   my @names =  $distmat->column_names;\n   my $N = scalar @names;\n   my ($i,$j,$m,@nodes,$mat,@r);\n   my $L = $N;\n\n   if( $N < 2 ) {\n       $self->warn(\"Can only perform NJ treebuilding on sets of 2 or more species\\n\");\n       return;\n   } elsif( $N == 2 ) {\n       $i = 0;\n       my $d = sprintf($precisionstr,\n\t\t       $distmat->get_entry($names[0],$names[1]) / 2);\n       my $root = Bio::Tree::Node->new();\n       for my $nm ( @names ) {\n\t   $root->add_Descendents( Bio::Tree::Node->new(-id => $nm,\n\t\t\t\t\t\t\t-branch_length => $d));\n       }\n       return Bio::Tree::Tree(-root => $root);\n   }\n   my $c = 0;\n   \n   for ( $i = 0; $i < $N; $i++ ) {\n       push @nodes, Bio::Tree::Node->new(-id => $names[$i]);\n       my $ri = 0;\n       for( $j = 0; $j < $N; $j++ ) {\n\t   $mat->[$i][$j] = $distmat->get_entry($names[$i],$names[$j]);\n\t   $ri += $mat->[$i][$j];\n       }\n       $r[$i] = $ri / ($L -2);\n   }\n   \n   for( my $nodecount = 0; $nodecount < $N-3; $nodecount++) {\n       my ($mini,$minj,$min);\n       for($i = 0; $i < $N; $i++ ) {\n\t   next unless defined $nodes[$i];\n\t   for( $j = 0; $j < $i; $j++ ) {\n\t       next unless defined $nodes[$j];\n\t       my $dist = $mat->[$i][$j] - ($r[$i] + $r[$j]);\n\t       if( ! defined $min ||\n\t\t   $dist <= $min) {\n\t\t   ($mini,$minj,$min) = ($i,$j,$dist);\n\t       }\n\t   }\n       }\n       my $dij    = $mat->[$mini][$minj];\n       my $dist_i = ($dij + $r[$mini] - $r[$minj]) / 2;\n       my $dist_j = $dij - $dist_i;\n       \n       # deal with negative branch lengths\n       # per code in K.Howe's quicktree\n       if( $dist_i < 0 ) {\n\t   $dist_i = 0;\n\t   $dist_j = $dij;\n\t   $dist_j = 0 if( $dist_j < 0 );\n       } elsif( $dist_j < 0 ) { \n\t   $dist_j = 0;\n\t   $dist_i = $dij;\n\t   $dist_i = 0 if( $dist_i < 0 );\n       }\n       \n       $nodes[$mini]->branch_length(sprintf($precisionstr,$dist_i));\n       $nodes[$minj]->branch_length(sprintf($precisionstr,$dist_j));\n       \n       my $newnode = Bio::Tree::Node->new(-descendents => [ $nodes[$mini],\n\t\t\t\t\t\t\t    $nodes[$minj] ]);\n\n       $nodes[$mini] = $newnode;\n       delete $nodes[$minj];\n       \n       # update the distance matrix\n       $r[$mini] = 0;\n       my ($dmi,$dmj);\n       for( $m = 0; $m < $N; $m++ ) {\t   \n\t   next unless defined $nodes[$m];\n\t   if( $m != $mini ) {\n\t       $dmj = $mat->[$m][$minj];\n\t       \n\t       my ($row,$col);\n\t       ($row,$col) = ($m,$mini);\n\t       $dmi = $mat->[$row][$col];\n\t       \n\t       # from K.Howe's notes in quicktree\n\t       # we can actually adjust r[m] here, by using the form:\n\t       # rm = ((rm * numseqs) - dmi - dmj + dmk) / (numseqs-1)\n\n\t       # Note: in Bill Bruno's method for negative branch\n\t       # elimination, then if either dist_i is positive and\n\t       # dist_j is 0, or dist_i is zero and dist_j is positive\n\t       # (after adjustment) then the matrix entry is formed\n\t       # from the distance to the node in question (m) to the\n\t       # node with the zero branch length (whichever it was).\n\t       # I think my code already has the same effect; this is\n\t       # certainly true if dij is equal to dist_i + dist_j,\n\t       # which it should have been fixed to\n\n\t       my $dmk = $mat->[$row][$col] = $mat->[$col][$row] = \n\t\t   ($dmi + $dmj - $dij) / 2;\n\t       \n\t       # If we don't want to try and correct negative brlens\n\t       # this is essentially what is in Edddy et al, BSA book.\n\t       # $r[$m] = (($r[$m] * $L) - $dmi - $dmj + $dmk) / ($L-1);\n\t       # \n\t       $r[$m] = (($r[$m] * ($L - 2)) - $dmi - $dmj + \n\t\t\t $mat->[$row][$col]) / ( $L - 3);\n\t       $r[$mini] += $dmk;\n\t   }\n       }\n       $L--;\n       $r[$mini] /= $L - 2;\n   }\n   \n   # should be 3 nodes left\n   my (@leftovernodes,@leftovers);\n   for( my $k = 0; $k < $N; $k++ ) {\n       if( defined $nodes[$k] ) {\n\t   push @leftovers, $k;\n\t   push @leftovernodes, $nodes[$k];\n       }\n   }\n   my ($l_0,$l_1,$l_2) = @leftovers;\n   \n   my $dist_i = ( $mat->[$l_1][$l_0] + $mat->[$l_2][$l_0] -\n\t\t  $mat->[$l_2][$l_1] ) / 2;\n   \n   my $dist_j = ( $mat->[$l_1][$l_0] - $dist_i);\n   my $dist_k = ( $mat->[$l_2][$l_0] - $dist_i);\n\n   # This is Kev's code to get rid of negative branch lengths\n   if( $dist_i < 0 ) { \n       $dist_i = 0;\n       $dist_j = $mat->[$l_1][$l_0];\n       $dist_k = $mat->[$l_2][$l_0];\n       if( $dist_j < 0 ) { \n\t   $dist_j = 0;\n\t   $dist_k = ( $mat->[$l_2][$l_0] + $mat->[$l_2][$l_1] ) / 2;\n\t   $dist_k = 0 if( $dist_k < 0 );\n       } elsif( $dist_k < 0 ) {\n\t   $dist_k = 0;\n\t   $dist_j = ($mat->[$l_1][$l_0] + $mat->[$l_2][$l_1]) / 2;\n\t   $dist_j = 0 if( $dist_j < 0 );\n       }\n   } elsif( $dist_j < 0 ) {\n       $dist_j = 0;\n       $dist_i = $mat->[$l_1][$l_0];\n       $dist_k = $mat->[$l_2][$l_1];\n       if( $dist_i < 0 ) { \n\t   $dist_i = 0;\n\t   $dist_k = ( $mat->[$l_2][$l_0] + $mat->[$l_2][$l_1]) / 2;\n\t   $dist_k = 0 if( $dist_k  < 0 );\n       } elsif( $dist_k < 0 ) { \n\t   $dist_k = 0;\n\t   $dist_i = ( $mat->[$l_1][$l_0] + $mat->[$l_2][$l_0]) / 2;\n\t   $dist_i = 0 if( $dist_i < 0 );\n       }\n   } elsif( $dist_k < 0 ) {\n       $dist_k = 0;\n       $dist_i = $mat->[$l_2][$l_0];\n       $dist_j = $mat->[$l_2][$l_1];\n       if( $dist_i < 0 ) { \n\t   $dist_i = 0;\n\t   $dist_j = ( $mat->[$l_1][$l_0] + $mat->[$l_2][$l_1] ) / 2;\n\t   $dist_j = 0 if $dist_j < 0;\n       } elsif( $dist_j < 0  ) {\n\t   $dist_j = 0;\n\t   $dist_i = ($mat->[$l_1][$l_0] + $mat->[$l_2][$l_0]) / 2;\n\t   $dist_i = 0 if $dist_i < 0;\n       }\n   }\n   $leftovernodes[0]->branch_length(sprintf($precisionstr,$dist_i));\n   $leftovernodes[1]->branch_length(sprintf($precisionstr,$dist_j));\n   $leftovernodes[2]->branch_length(sprintf($precisionstr,$dist_k));\n\n   Bio::Tree::Tree->new(-root => Bio::Tree::Node->new\n\t\t\t(-descendents => \\@leftovernodes));\n}\n\n=head2 _upgma\n\n Title   : _upgma\n Usage   : my $tree = $disttreefact->_upgma($matrix);\n Function: Construct a tree based on alignment using UPGMA\n Returns : L<Bio::Tree::TreeI>\n Args    : L<Bio::Matrix::MatrixI> object\n\n\n\nsub _upgma{\n   my ($self,$distmat) = @_;\n   # we assume type checking of $matrix has already been done\n   # client shouldn't be calling this directly anyways, using the\n   # make_tree method is preferred\n   \n   # algorithm, from Eddy, Durbin, Krogh, Mitchison, 1998\n   # originally by Sokal and Michener 1956\n\n   my $precisionstr = \"%.$Precision\".\"f\";\n   \n   my ($i,$j,$x,$y,@dmat,@orig,@nodes);\n\n   my @names = $distmat->column_names;\n   my $c = 0;\n   my @clusters = map { \n       my $r = { 'id'        => $c,\n\t\t 'height'    => 0,\n\t\t 'contains'  => [$c],\n\t     };\n       $c++;\n       $r;\n   } @names;\n\n   my $K = scalar @clusters;\n   my (@mins,$min);\n   for ( $i = 0; $i < $K; $i++ ) {\n       for( $j = $i+1; $j < $K; $j++ ) {\n\t   my $d =  $distmat->get_entry($names[$i],$names[$j]);\n\t   # get Min here on first time around, save 1 cycle\n\t   $dmat[$j][$i] = $dmat[$i][$j] = $d;\n\t   $orig[$i][$j] = $orig[$j][$i] = $d;\n\t   if ( ! defined $min || $d <= $min ) {\n\t       if( defined $min && $min == $d ) { \n\t\t   push @mins, [$i,$j];\n\t       } else { \n\t\t   @mins = [$i,$j];\n\t\t   $min  = $d;\n\t       }\n\t   }\n       }\n   }\n   # distance between each cluster is avg distance\n   # between pairs of sequences from each cluster\n   while( $K > 1 ) {       \n       # fencepost - we already have found the $min\n       # so very first time loop is executed we can skip checking\n       unless( defined $min ) {\n\t   for($i = 0; $i < $K; $i++ ) {\n\t       for( $j = $i+1; $j < $K; $j++ ) {\n\t\t   my $dij = $dmat[$i][$j];\n\t\t   if( ! defined $min ||\n\t\t       $dij <= $min) {\n\t\t       if( defined $min &&\n\t\t\t   $min == $dij ) { \n\t\t\t   push @mins, [$i,$j];\n\t\t       } else { \n\t\t\t   @mins = [ $i,$j ];\n\t\t\t   $min = $dij;\n\t\t       }\n\t\t   }\n\t       }\n\t   }\n       }\n       # randomly break ties\n       ($x,$y) = @{ $mins[int(rand(scalar @mins))] };   \n\n       # now we are going to join clusters x and y, make a new cluster\n\n       my $node = Bio::Tree::Node->new();   \n       my @subids;\n       for my $cid ( $x,$y ) {\n\t   my $nid = $clusters[$cid]->{'id'};\n\t   if( ! defined $nodes[$nid] ) {\n\t       $nodes[$nid] = Bio::Tree::Node->new(-id => $names[$nid]);\n\t   }\n\t   $nodes[$nid]->branch_length\n\t       (sprintf($precisionstr,$min/2 - $clusters[$cid]->{'height'}));\n\t   $node->add_Descendent($nodes[$nid]);\n\t   push @subids, @{ $clusters[$cid]->{'contains'} };\n       }\n       my $cluster = { 'id'       => $c++,\n\t\t       'height'   => $min / 2,\n\t\t       'contains' => [@subids],\n\t\t   };\n\n       $K--; # we are going to drop the last node so go ahead and decrement K\n       $nodes[$cluster->{'id'}] = $node;\n       if ( $y != $K ) {\n\t   $clusters[$y] = $clusters[$K];\n\t   $dmat[$y] = $dmat[$K];\n\t   for ( $i = 0; $i < $K; $i++ ) {\n\t       $dmat[$i][$y] = $dmat[$y][$i];\n\t   }\n       }\n       delete $clusters[$K];\n       $clusters[$x] = $cluster;\n       # now recalculate @dmat\n       for( $i = 0; $i < $K; $i++ ) {\t   \n\t   if( $i != $x) {\n\t       $dmat[$i][$x] = $dmat[$x][$i] = \n\t\t   &_upgma_distance($clusters[$i],$clusters[$x],\\@orig);\n\t   } else { \n\t       $dmat[$i][$i] = 0;\n\t   }\n       }\n       # reset so next loop iteration\n       # we will find minimum distance\n       @mins = ();\n       $min = undef;\n   }\n   Bio::Tree::Tree->new(-root => $nodes[-1]);\n}\n\n# calculate avg distance between clusters - be they\n# single sequences or the combination of multiple seqences\n# $cluster_i and $cluster_j are the clusters to operate on\n# and $distances is a matrix (arrayref of arrayrefs) of pairwise \n# differences indexed on the sequence ids - \n# so $distances->[0][1] is the distance between sequences 0 and 1\n\nsub _upgma_distance { \n    my ($cluster_i, $cluster_j, $distances) = @_;\n    my $ilen = scalar @{ $cluster_i->{'contains'} };\n    my $jlen = scalar @{ $cluster_j->{'contains'} };\n    my ($d,$count);\n    for( my $i = 0; $i < $ilen; $i++ ) {\n\tmy $i_id = $cluster_i->{'contains'}->[$i];\n\tfor( my $j = 0; $j < $jlen; $j++) {\t    \n\t    my $j_id = $cluster_j->{'contains'}->[$j];\n\t    if( ! defined $distances->[$i_id][$j_id] ) {\n\t\twarn(\"no value for $i_id $j_id\\n\");\n\t    } else { \n\t\t$d += $distances->[$i_id][$j_id];\n\t    }\n\t    $count++;\n\t}\n    }\n    return $d / $count;\n}\n\n=head2 method\n\n Title   : method\n Usage   : $obj->method($newval)\n Function: \n Example : \n Returns : value of method (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub method{\n    my $self = shift;\n    return $self->{'_method'} = shift if @_;\n    return $self->{'_method'};\n}\n\n\n=head2 check_additivity\n\n Title     : check_additivity\n Usage     : if( $distance->check_additivity($matrix) ) {\n             }\n Function  : See if matrix obeys additivity principal\n Returns   : boolean\n Args      : Bio::Matrix::MatrixI \n References: Based on a Java implementation by\n             Peter Sestoft, sestoft@dina.kvl.dk 1999-12-07 version 0.3\n             http://www.dina.kvl.dk/~sestoft/bsa.html\n             which in turn is based on algorithms described in \n             R. Durbin, S. Eddy, A. Krogh, G. Mitchison. \n             Biological Sequence Analysis CUP 1998, Chapter 7.","parameters":[{"label":"$self"},{"label":"$matrix"}],"label":"check_additivity($self,$matrix)"}}]}