{"version":5,"vars":[{"kind":2,"containerName":"","name":"base","line":89},{"detail":"($class,@args)","definition":"sub","name":"new","containerName":"main::","children":[{"containerName":"new","localvar":"my","kind":13,"name":"$class","line":102,"definition":"my"},{"line":102,"name":"@args","containerName":"new","kind":13},{"name":"$self","localvar":"my","containerName":"new","kind":13,"line":103,"definition":"my"},{"containerName":"new","kind":13,"name":"$class","line":103},{"line":103,"kind":13,"containerName":"new","name":"@args"},{"name":"$to_string_cb","localvar":"my","kind":13,"containerName":"new","line":104,"definition":"my"},{"line":104,"containerName":"new","kind":13,"name":"$self"},{"line":104,"name":"_rearrange","kind":12,"containerName":"new"},{"name":"@args","containerName":"new","kind":13,"line":104},{"line":105,"name":"$to_string_cb","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$self","line":106},{"kind":12,"containerName":"new","name":"to_string_callback","line":106},{"line":106,"kind":13,"containerName":"new","name":"$to_string_cb"},{"kind":13,"containerName":"new","name":"$self","line":108}],"signature":{"documentation":"1;\n# BioPerl module for Bio::Tree::AnnotatableNode\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Mira Han <mirhan@indiana.edu>\n#\n# Copyright Mira Han\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::AnnotatableNode - A Tree Node with support for annotation\n\n=head1 SYNOPSIS\n\n    use Bio::Tree::AnnotatableNode;\n    my $nodeA = Bio::Tree::AnnotatableNode->new();\n    my $nodeL = Bio::Tree::AnnotatableNode->new();\n    my $nodeR = Bio::Tree::AnnotatableNode->new();\n\n    my $node = Bio::Tree::AnnotatableNode->new();\n    $node->add_Descendents($nodeL);\n    $node->add_Descendents($nodeR);\n\n    print \"node is not a leaf \\n\" if( $node->is_leaf);\n\n    # $node is-a Bio::AnnotatableI, hence:\n    my $ann_coll = $node->annotation();\n    # $ann_coll is-a Bio::AnnotationCollectionI, hence:\n    my @all_anns = $ann_coll->get_Annotations();\n    # do something with the annotation objects\n\n=head1 DESCRIPTION\n\nMakes a Tree Node with Annotations, suitable for building a Tree.  See\nL<Bio::Tree::Node> for a full list of functionality.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mira Han\n\nEmail mirhan@indiana.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tree::AnnotatableNode;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Seq;\nuse base qw(Bio::Tree::Node Bio::AnnotatableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::AnnotatableNode->new();\n Function: Builds a new Bio::Tree::AnnotatableNode object\n Returns : Bio::Tree::AnnotatableNode\n Args    : -tostring => code reference to the tostring callback function (optional)","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"range":{"end":{"character":9999,"line":109},"start":{"line":101,"character":0}},"kind":12,"line":101},{"line":103,"kind":12,"containerName":"new","name":"SUPER"},{"signature":{"label":"DESTROY($self)","documentation":"","parameters":[{"label":"$self"}]},"line":111,"range":{"end":{"line":115,"character":9999},"start":{"character":0,"line":111}},"kind":12,"definition":"sub","detail":"($self)","children":[{"definition":"my","line":112,"name":"$self","localvar":"my","kind":13,"containerName":"DESTROY"},{"line":114,"kind":13,"containerName":"DESTROY","name":"$self"}],"name":"DESTROY","containerName":"main::"},{"line":114,"name":"SUPER","containerName":"DESTROY","kind":12},{"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# BioPerl module for Bio::Tree::AnnotatableNode\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Mira Han <mirhan@indiana.edu>\n#\n# Copyright Mira Han\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::AnnotatableNode - A Tree Node with support for annotation\n\n=head1 SYNOPSIS\n\n    use Bio::Tree::AnnotatableNode;\n    my $nodeA = Bio::Tree::AnnotatableNode->new();\n    my $nodeL = Bio::Tree::AnnotatableNode->new();\n    my $nodeR = Bio::Tree::AnnotatableNode->new();\n\n    my $node = Bio::Tree::AnnotatableNode->new();\n    $node->add_Descendents($nodeL);\n    $node->add_Descendents($nodeR);\n\n    print \"node is not a leaf \\n\" if( $node->is_leaf);\n\n    # $node is-a Bio::AnnotatableI, hence:\n    my $ann_coll = $node->annotation();\n    # $ann_coll is-a Bio::AnnotationCollectionI, hence:\n    my @all_anns = $ann_coll->get_Annotations();\n    # do something with the annotation objects\n\n=head1 DESCRIPTION\n\nMakes a Tree Node with Annotations, suitable for building a Tree.  See\nL<Bio::Tree::Node> for a full list of functionality.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mira Han\n\nEmail mirhan@indiana.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tree::AnnotatableNode;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Seq;\nuse base qw(Bio::Tree::Node Bio::AnnotatableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::AnnotatableNode->new();\n Function: Builds a new Bio::Tree::AnnotatableNode object\n Returns : Bio::Tree::AnnotatableNode\n Args    : -tostring => code reference to the tostring callback function (optional)\n\n\nsub new {\n  my ($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my $to_string_cb = $self->_rearrange([qw(TOSTRING)], @args);\n  if ($to_string_cb) {\n    $self->to_string_callback($to_string_cb);\n  }\n  return $self;\n}\n\nsub DESTROY {\n    my ($self) = @_;\n    # try to insure that everything is cleaned up\n    $self->SUPER::DESTROY();\n}\n\n=head1 Methods for implementing Bio::AnnotatableI\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $ann = $node->annotation or \n           $node->annotation($ann)\n Function: Gets or sets the annotation\n Returns : Bio::AnnotationCollectionI object\n Args    : None or Bio::AnnotationCollectionI object\nSee L<Bio::AnnotationCollectionI> and L<Bio::Annotation::Collection>\nfor more information","label":"annotation($self,$value)"},"range":{"start":{"character":0,"line":134},"end":{"character":9999,"line":147}},"kind":12,"line":134,"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"annotation","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"annotation","line":136},{"name":"$value","containerName":"annotation","kind":13,"line":136},{"name":"$value","containerName":"annotation","kind":13,"line":137},{"line":138,"name":"$self","kind":13,"containerName":"annotation"},{"line":138,"name":"throw","containerName":"annotation","kind":12},{"line":138,"name":"$value","kind":13,"containerName":"annotation"},{"line":139,"name":"$value","containerName":"annotation","kind":13},{"line":139,"name":"isa","containerName":"annotation","kind":12},{"line":140,"kind":13,"containerName":"annotation","name":"$self"},{"kind":13,"containerName":"annotation","name":"$value","line":140},{"containerName":"annotation","kind":13,"name":"$self","line":142},{"line":144,"name":"$self","containerName":"annotation","kind":13},{"line":144,"name":"new","kind":12,"containerName":"annotation"},{"name":"$self","containerName":"annotation","kind":13,"line":146}]},{"kind":12,"containerName":"Annotation::Collection","name":"Bio","line":144},{"signature":{"parameters":[{"label":"$self"},{"label":"$tag"},{"label":"$value"}],"documentation":"1;\n# BioPerl module for Bio::Tree::AnnotatableNode\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Mira Han <mirhan@indiana.edu>\n#\n# Copyright Mira Han\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::AnnotatableNode - A Tree Node with support for annotation\n\n=head1 SYNOPSIS\n\n    use Bio::Tree::AnnotatableNode;\n    my $nodeA = Bio::Tree::AnnotatableNode->new();\n    my $nodeL = Bio::Tree::AnnotatableNode->new();\n    my $nodeR = Bio::Tree::AnnotatableNode->new();\n\n    my $node = Bio::Tree::AnnotatableNode->new();\n    $node->add_Descendents($nodeL);\n    $node->add_Descendents($nodeR);\n\n    print \"node is not a leaf \\n\" if( $node->is_leaf);\n\n    # $node is-a Bio::AnnotatableI, hence:\n    my $ann_coll = $node->annotation();\n    # $ann_coll is-a Bio::AnnotationCollectionI, hence:\n    my @all_anns = $ann_coll->get_Annotations();\n    # do something with the annotation objects\n\n=head1 DESCRIPTION\n\nMakes a Tree Node with Annotations, suitable for building a Tree.  See\nL<Bio::Tree::Node> for a full list of functionality.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mira Han\n\nEmail mirhan@indiana.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tree::AnnotatableNode;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Seq;\nuse base qw(Bio::Tree::Node Bio::AnnotatableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::AnnotatableNode->new();\n Function: Builds a new Bio::Tree::AnnotatableNode object\n Returns : Bio::Tree::AnnotatableNode\n Args    : -tostring => code reference to the tostring callback function (optional)\n\n\nsub new {\n  my ($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my $to_string_cb = $self->_rearrange([qw(TOSTRING)], @args);\n  if ($to_string_cb) {\n    $self->to_string_callback($to_string_cb);\n  }\n  return $self;\n}\n\nsub DESTROY {\n    my ($self) = @_;\n    # try to insure that everything is cleaned up\n    $self->SUPER::DESTROY();\n}\n\n=head1 Methods for implementing Bio::AnnotatableI\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $ann = $node->annotation or \n           $node->annotation($ann)\n Function: Gets or sets the annotation\n Returns : Bio::AnnotationCollectionI object\n Args    : None or Bio::AnnotationCollectionI object\nSee L<Bio::AnnotationCollectionI> and L<Bio::Annotation::Collection>\nfor more information\n\n\nsub annotation \n{\n  my ($self,$value) = @_;\n  if( defined $value ) {\n    $self->throw(\"object of class \".ref($value).\" does not implement \".\n        \"Bio::AnnotationCollectionI. Too bad.\")      unless $value->isa(\"Bio::AnnotationCollectionI\");\n    $self->{'_annotation'} = $value;\n  } \n  elsif( ! defined $self->{'_annotation'}) \n  {\n    $self->{'_annotation'} = Bio::Annotation::Collection->new();\n  }\n  return $self->{'_annotation'};\n}\n\n\n=head1 Methods for implementing tag access through Annotation::SimpleValue\n\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $node->add_tag_value($tag,$value)\n Function: Adds a tag value to a node \n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag","label":"add_tag_value($self,$tag,$value)"},"range":{"end":{"character":9999,"line":175},"start":{"line":165,"character":0}},"kind":12,"line":165,"detail":"($self,$tag,$value)","definition":"sub","name":"add_tag_value","containerName":"main::","children":[{"line":167,"name":"$self","kind":13,"localvar":"my","containerName":"add_tag_value","definition":"my"},{"line":167,"name":"$tag","kind":13,"containerName":"add_tag_value"},{"name":"$value","kind":13,"containerName":"add_tag_value","line":167},{"line":168,"name":"$tag","containerName":"add_tag_value","kind":13},{"line":168,"name":"$value","kind":13,"containerName":"add_tag_value"},{"line":169,"kind":13,"containerName":"add_tag_value","name":"$self"},{"line":169,"name":"warn","kind":12,"containerName":"add_tag_value"},{"definition":"my","name":"$ac","kind":13,"localvar":"my","containerName":"add_tag_value","line":171},{"line":171,"name":"$self","containerName":"add_tag_value","kind":13},{"line":171,"kind":12,"containerName":"add_tag_value","name":"annotation"},{"definition":"my","name":"$sv","localvar":"my","kind":13,"containerName":"add_tag_value","line":172},{"line":172,"kind":12,"containerName":"add_tag_value","name":"new"},{"name":"$value","kind":13,"containerName":"add_tag_value","line":172},{"name":"$ac","containerName":"add_tag_value","kind":13,"line":173},{"containerName":"add_tag_value","kind":12,"name":"add_Annotation","line":173},{"line":173,"name":"$tag","containerName":"add_tag_value","kind":13},{"containerName":"add_tag_value","kind":13,"name":"$sv","line":173},{"line":174,"name":"$ac","kind":13,"containerName":"add_tag_value"},{"line":174,"name":"get_Annotations","kind":12,"containerName":"add_tag_value"},{"line":174,"kind":13,"containerName":"add_tag_value","name":"$tag"}]},{"name":"Bio","kind":12,"containerName":"Annotation::SimpleValue","line":172},{"signature":{"label":"remove_tag($self,$tag)","documentation":"1;\n# BioPerl module for Bio::Tree::AnnotatableNode\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Mira Han <mirhan@indiana.edu>\n#\n# Copyright Mira Han\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::AnnotatableNode - A Tree Node with support for annotation\n\n=head1 SYNOPSIS\n\n    use Bio::Tree::AnnotatableNode;\n    my $nodeA = Bio::Tree::AnnotatableNode->new();\n    my $nodeL = Bio::Tree::AnnotatableNode->new();\n    my $nodeR = Bio::Tree::AnnotatableNode->new();\n\n    my $node = Bio::Tree::AnnotatableNode->new();\n    $node->add_Descendents($nodeL);\n    $node->add_Descendents($nodeR);\n\n    print \"node is not a leaf \\n\" if( $node->is_leaf);\n\n    # $node is-a Bio::AnnotatableI, hence:\n    my $ann_coll = $node->annotation();\n    # $ann_coll is-a Bio::AnnotationCollectionI, hence:\n    my @all_anns = $ann_coll->get_Annotations();\n    # do something with the annotation objects\n\n=head1 DESCRIPTION\n\nMakes a Tree Node with Annotations, suitable for building a Tree.  See\nL<Bio::Tree::Node> for a full list of functionality.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mira Han\n\nEmail mirhan@indiana.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tree::AnnotatableNode;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Seq;\nuse base qw(Bio::Tree::Node Bio::AnnotatableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::AnnotatableNode->new();\n Function: Builds a new Bio::Tree::AnnotatableNode object\n Returns : Bio::Tree::AnnotatableNode\n Args    : -tostring => code reference to the tostring callback function (optional)\n\n\nsub new {\n  my ($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my $to_string_cb = $self->_rearrange([qw(TOSTRING)], @args);\n  if ($to_string_cb) {\n    $self->to_string_callback($to_string_cb);\n  }\n  return $self;\n}\n\nsub DESTROY {\n    my ($self) = @_;\n    # try to insure that everything is cleaned up\n    $self->SUPER::DESTROY();\n}\n\n=head1 Methods for implementing Bio::AnnotatableI\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $ann = $node->annotation or \n           $node->annotation($ann)\n Function: Gets or sets the annotation\n Returns : Bio::AnnotationCollectionI object\n Args    : None or Bio::AnnotationCollectionI object\nSee L<Bio::AnnotationCollectionI> and L<Bio::Annotation::Collection>\nfor more information\n\n\nsub annotation \n{\n  my ($self,$value) = @_;\n  if( defined $value ) {\n    $self->throw(\"object of class \".ref($value).\" does not implement \".\n        \"Bio::AnnotationCollectionI. Too bad.\")      unless $value->isa(\"Bio::AnnotationCollectionI\");\n    $self->{'_annotation'} = $value;\n  } \n  elsif( ! defined $self->{'_annotation'}) \n  {\n    $self->{'_annotation'} = Bio::Annotation::Collection->new();\n  }\n  return $self->{'_annotation'};\n}\n\n\n=head1 Methods for implementing tag access through Annotation::SimpleValue\n\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $node->add_tag_value($tag,$value)\n Function: Adds a tag value to a node \n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag\n\n\nsub add_tag_value \n{\n  my ($self,$tag,$value) = @_;\n  if( ! defined $tag || ! defined $value ) {\n    $self->warn(\"cannot call add_tag_value with an undefined value\");\n  }\n  my $ac = $self->annotation();\n  my $sv = Bio::Annotation::SimpleValue->new(-value => $value);\n  $ac->add_Annotation($tag, $sv); \n  return scalar $ac->get_Annotations($tag);\n}\n\n=head2 remove_tag\n\n Title   : remove_tag\n Usage   : $node->remove_tag($tag)\n Function: Remove the tag and all values for this tag\n Returns : boolean representing success (0 if tag does not exist)\n Args    : $tag - tagname to remove","parameters":[{"label":"$self"},{"label":"$tag"}]},"range":{"end":{"line":192,"character":9999},"start":{"character":0,"line":188}},"kind":12,"line":188,"detail":"($self,$tag)","definition":"sub","containerName":"main::","name":"remove_tag","children":[{"line":190,"localvar":"my","kind":13,"containerName":"remove_tag","name":"$self","definition":"my"},{"line":190,"kind":13,"containerName":"remove_tag","name":"$tag"},{"line":191,"kind":13,"localvar":"my","containerName":"remove_tag","name":"$ac","definition":"my"},{"name":"$self","kind":13,"containerName":"remove_tag","line":191},{"name":"annotation","containerName":"remove_tag","kind":12,"line":191},{"line":192,"containerName":"remove_tag","kind":13,"name":"$ac"},{"line":192,"name":"get_Annotations","containerName":"remove_tag","kind":12},{"line":192,"kind":13,"containerName":"remove_tag","name":"$tag"}]},{"line":193,"kind":13,"containerName":null,"name":"$ac"},{"line":193,"name":"remove_Annotations","kind":12,"containerName":"main::"},{"containerName":null,"kind":13,"name":"$tag","line":193},{"detail":"($self)","definition":"sub","containerName":"main::","name":"remove_all_tags","children":[{"line":211,"name":"$self","containerName":"remove_all_tags","localvar":"my","kind":13,"definition":"my"},{"definition":"my","line":212,"kind":13,"localvar":"my","containerName":"remove_all_tags","name":"$ac"},{"line":212,"kind":13,"containerName":"remove_all_tags","name":"$self"},{"name":"annotation","containerName":"remove_all_tags","kind":12,"line":212},{"line":213,"name":"$ac","containerName":"remove_all_tags","kind":13},{"name":"remove_Annotations","containerName":"remove_all_tags","kind":12,"line":213}],"signature":{"label":"remove_all_tags($self)","documentation":"1;\n# BioPerl module for Bio::Tree::AnnotatableNode\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Mira Han <mirhan@indiana.edu>\n#\n# Copyright Mira Han\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::AnnotatableNode - A Tree Node with support for annotation\n\n=head1 SYNOPSIS\n\n    use Bio::Tree::AnnotatableNode;\n    my $nodeA = Bio::Tree::AnnotatableNode->new();\n    my $nodeL = Bio::Tree::AnnotatableNode->new();\n    my $nodeR = Bio::Tree::AnnotatableNode->new();\n\n    my $node = Bio::Tree::AnnotatableNode->new();\n    $node->add_Descendents($nodeL);\n    $node->add_Descendents($nodeR);\n\n    print \"node is not a leaf \\n\" if( $node->is_leaf);\n\n    # $node is-a Bio::AnnotatableI, hence:\n    my $ann_coll = $node->annotation();\n    # $ann_coll is-a Bio::AnnotationCollectionI, hence:\n    my @all_anns = $ann_coll->get_Annotations();\n    # do something with the annotation objects\n\n=head1 DESCRIPTION\n\nMakes a Tree Node with Annotations, suitable for building a Tree.  See\nL<Bio::Tree::Node> for a full list of functionality.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mira Han\n\nEmail mirhan@indiana.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tree::AnnotatableNode;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Seq;\nuse base qw(Bio::Tree::Node Bio::AnnotatableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::AnnotatableNode->new();\n Function: Builds a new Bio::Tree::AnnotatableNode object\n Returns : Bio::Tree::AnnotatableNode\n Args    : -tostring => code reference to the tostring callback function (optional)\n\n\nsub new {\n  my ($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my $to_string_cb = $self->_rearrange([qw(TOSTRING)], @args);\n  if ($to_string_cb) {\n    $self->to_string_callback($to_string_cb);\n  }\n  return $self;\n}\n\nsub DESTROY {\n    my ($self) = @_;\n    # try to insure that everything is cleaned up\n    $self->SUPER::DESTROY();\n}\n\n=head1 Methods for implementing Bio::AnnotatableI\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $ann = $node->annotation or \n           $node->annotation($ann)\n Function: Gets or sets the annotation\n Returns : Bio::AnnotationCollectionI object\n Args    : None or Bio::AnnotationCollectionI object\nSee L<Bio::AnnotationCollectionI> and L<Bio::Annotation::Collection>\nfor more information\n\n\nsub annotation \n{\n  my ($self,$value) = @_;\n  if( defined $value ) {\n    $self->throw(\"object of class \".ref($value).\" does not implement \".\n        \"Bio::AnnotationCollectionI. Too bad.\")      unless $value->isa(\"Bio::AnnotationCollectionI\");\n    $self->{'_annotation'} = $value;\n  } \n  elsif( ! defined $self->{'_annotation'}) \n  {\n    $self->{'_annotation'} = Bio::Annotation::Collection->new();\n  }\n  return $self->{'_annotation'};\n}\n\n\n=head1 Methods for implementing tag access through Annotation::SimpleValue\n\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $node->add_tag_value($tag,$value)\n Function: Adds a tag value to a node \n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag\n\n\nsub add_tag_value \n{\n  my ($self,$tag,$value) = @_;\n  if( ! defined $tag || ! defined $value ) {\n    $self->warn(\"cannot call add_tag_value with an undefined value\");\n  }\n  my $ac = $self->annotation();\n  my $sv = Bio::Annotation::SimpleValue->new(-value => $value);\n  $ac->add_Annotation($tag, $sv); \n  return scalar $ac->get_Annotations($tag);\n}\n\n=head2 remove_tag\n\n Title   : remove_tag\n Usage   : $node->remove_tag($tag)\n Function: Remove the tag and all values for this tag\n Returns : boolean representing success (0 if tag does not exist)\n Args    : $tag - tagname to remove\n\n\n\nsub remove_tag \n{\n  my ($self,$tag) = @_;\n  my $ac = $self->annotation();\n  if( @{$ac->get_Annotations($tag)} ) {\n    $ac->remove_Annotations($tag);\n    return 1;\n  }\n  return 0;\n}\n\n=head2 remove_all_tags\n\n Title   : remove_all_tags\n Usage   : $node->remove_all_tags()\n Function: Removes all tags \n Returns : None\n Args    : None","parameters":[{"label":"$self"}]},"kind":12,"range":{"end":{"character":9999,"line":215},"start":{"character":0,"line":209}},"line":209},{"line":227,"range":{"start":{"character":0,"line":227},"end":{"line":233,"character":9999}},"kind":12,"signature":{"label":"get_all_tags($self)","documentation":"1;\n# BioPerl module for Bio::Tree::AnnotatableNode\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Mira Han <mirhan@indiana.edu>\n#\n# Copyright Mira Han\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::AnnotatableNode - A Tree Node with support for annotation\n\n=head1 SYNOPSIS\n\n    use Bio::Tree::AnnotatableNode;\n    my $nodeA = Bio::Tree::AnnotatableNode->new();\n    my $nodeL = Bio::Tree::AnnotatableNode->new();\n    my $nodeR = Bio::Tree::AnnotatableNode->new();\n\n    my $node = Bio::Tree::AnnotatableNode->new();\n    $node->add_Descendents($nodeL);\n    $node->add_Descendents($nodeR);\n\n    print \"node is not a leaf \\n\" if( $node->is_leaf);\n\n    # $node is-a Bio::AnnotatableI, hence:\n    my $ann_coll = $node->annotation();\n    # $ann_coll is-a Bio::AnnotationCollectionI, hence:\n    my @all_anns = $ann_coll->get_Annotations();\n    # do something with the annotation objects\n\n=head1 DESCRIPTION\n\nMakes a Tree Node with Annotations, suitable for building a Tree.  See\nL<Bio::Tree::Node> for a full list of functionality.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mira Han\n\nEmail mirhan@indiana.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tree::AnnotatableNode;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Seq;\nuse base qw(Bio::Tree::Node Bio::AnnotatableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::AnnotatableNode->new();\n Function: Builds a new Bio::Tree::AnnotatableNode object\n Returns : Bio::Tree::AnnotatableNode\n Args    : -tostring => code reference to the tostring callback function (optional)\n\n\nsub new {\n  my ($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my $to_string_cb = $self->_rearrange([qw(TOSTRING)], @args);\n  if ($to_string_cb) {\n    $self->to_string_callback($to_string_cb);\n  }\n  return $self;\n}\n\nsub DESTROY {\n    my ($self) = @_;\n    # try to insure that everything is cleaned up\n    $self->SUPER::DESTROY();\n}\n\n=head1 Methods for implementing Bio::AnnotatableI\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $ann = $node->annotation or \n           $node->annotation($ann)\n Function: Gets or sets the annotation\n Returns : Bio::AnnotationCollectionI object\n Args    : None or Bio::AnnotationCollectionI object\nSee L<Bio::AnnotationCollectionI> and L<Bio::Annotation::Collection>\nfor more information\n\n\nsub annotation \n{\n  my ($self,$value) = @_;\n  if( defined $value ) {\n    $self->throw(\"object of class \".ref($value).\" does not implement \".\n        \"Bio::AnnotationCollectionI. Too bad.\")      unless $value->isa(\"Bio::AnnotationCollectionI\");\n    $self->{'_annotation'} = $value;\n  } \n  elsif( ! defined $self->{'_annotation'}) \n  {\n    $self->{'_annotation'} = Bio::Annotation::Collection->new();\n  }\n  return $self->{'_annotation'};\n}\n\n\n=head1 Methods for implementing tag access through Annotation::SimpleValue\n\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $node->add_tag_value($tag,$value)\n Function: Adds a tag value to a node \n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag\n\n\nsub add_tag_value \n{\n  my ($self,$tag,$value) = @_;\n  if( ! defined $tag || ! defined $value ) {\n    $self->warn(\"cannot call add_tag_value with an undefined value\");\n  }\n  my $ac = $self->annotation();\n  my $sv = Bio::Annotation::SimpleValue->new(-value => $value);\n  $ac->add_Annotation($tag, $sv); \n  return scalar $ac->get_Annotations($tag);\n}\n\n=head2 remove_tag\n\n Title   : remove_tag\n Usage   : $node->remove_tag($tag)\n Function: Remove the tag and all values for this tag\n Returns : boolean representing success (0 if tag does not exist)\n Args    : $tag - tagname to remove\n\n\n\nsub remove_tag \n{\n  my ($self,$tag) = @_;\n  my $ac = $self->annotation();\n  if( @{$ac->get_Annotations($tag)} ) {\n    $ac->remove_Annotations($tag);\n    return 1;\n  }\n  return 0;\n}\n\n=head2 remove_all_tags\n\n Title   : remove_all_tags\n Usage   : $node->remove_all_tags()\n Function: Removes all tags \n Returns : None\n Args    : None\n\n\nsub remove_all_tags\n{\n  my ($self) = @_;\n  my $ac = $self->annotation();\n  $ac->remove_Annotations();\n  return;\n}\n\n=head2 get_all_tags\n\n Title   : get_all_tags\n Usage   : my @tags = $node->get_all_tags()\n Function: Gets all the tag names for this Node\n Returns : Array of tagnames\n Args    : None","parameters":[{"label":"$self"}]},"children":[{"definition":"my","containerName":"get_all_tags","localvar":"my","kind":13,"name":"$self","line":228},{"line":229,"name":"$ac","localvar":"my","kind":13,"containerName":"get_all_tags","definition":"my"},{"line":229,"name":"$self","containerName":"get_all_tags","kind":13},{"name":"annotation","containerName":"get_all_tags","kind":12,"line":229},{"name":"@tags","containerName":"get_all_tags","localvar":"my","kind":13,"line":230,"definition":"my"},{"line":230,"containerName":"get_all_tags","kind":13,"name":"$ac"},{"name":"get_all_annotation_keys","kind":12,"containerName":"get_all_tags","line":230},{"line":232,"kind":13,"containerName":"get_all_tags","name":"@tags"}],"name":"get_all_tags","containerName":"main::","definition":"sub","detail":"($self)"},{"detail":"($self,$tag)","definition":"sub","name":"get_tag_values","containerName":"main::","children":[{"line":246,"localvar":"my","kind":13,"containerName":"get_tag_values","name":"$self","definition":"my"},{"line":246,"kind":13,"containerName":"get_tag_values","name":"$tag"},{"line":247,"name":"$ac","localvar":"my","containerName":"get_tag_values","kind":13,"definition":"my"},{"line":247,"kind":13,"containerName":"get_tag_values","name":"$self"},{"name":"annotation","containerName":"get_tag_values","kind":12,"line":247},{"definition":"my","localvar":"my","containerName":"get_tag_values","kind":13,"name":"@values","line":248},{"line":248,"name":"value","kind":12,"containerName":"get_tag_values"},{"name":"$ac","containerName":"get_tag_values","kind":13,"line":248},{"kind":12,"containerName":"get_tag_values","name":"get_Annotations","line":248},{"line":248,"name":"$tag","kind":13,"containerName":"get_tag_values"},{"containerName":"get_tag_values","kind":13,"name":"@values","line":249}],"signature":{"documentation":"1;\n# BioPerl module for Bio::Tree::AnnotatableNode\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Mira Han <mirhan@indiana.edu>\n#\n# Copyright Mira Han\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::AnnotatableNode - A Tree Node with support for annotation\n\n=head1 SYNOPSIS\n\n    use Bio::Tree::AnnotatableNode;\n    my $nodeA = Bio::Tree::AnnotatableNode->new();\n    my $nodeL = Bio::Tree::AnnotatableNode->new();\n    my $nodeR = Bio::Tree::AnnotatableNode->new();\n\n    my $node = Bio::Tree::AnnotatableNode->new();\n    $node->add_Descendents($nodeL);\n    $node->add_Descendents($nodeR);\n\n    print \"node is not a leaf \\n\" if( $node->is_leaf);\n\n    # $node is-a Bio::AnnotatableI, hence:\n    my $ann_coll = $node->annotation();\n    # $ann_coll is-a Bio::AnnotationCollectionI, hence:\n    my @all_anns = $ann_coll->get_Annotations();\n    # do something with the annotation objects\n\n=head1 DESCRIPTION\n\nMakes a Tree Node with Annotations, suitable for building a Tree.  See\nL<Bio::Tree::Node> for a full list of functionality.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mira Han\n\nEmail mirhan@indiana.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tree::AnnotatableNode;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Seq;\nuse base qw(Bio::Tree::Node Bio::AnnotatableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::AnnotatableNode->new();\n Function: Builds a new Bio::Tree::AnnotatableNode object\n Returns : Bio::Tree::AnnotatableNode\n Args    : -tostring => code reference to the tostring callback function (optional)\n\n\nsub new {\n  my ($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my $to_string_cb = $self->_rearrange([qw(TOSTRING)], @args);\n  if ($to_string_cb) {\n    $self->to_string_callback($to_string_cb);\n  }\n  return $self;\n}\n\nsub DESTROY {\n    my ($self) = @_;\n    # try to insure that everything is cleaned up\n    $self->SUPER::DESTROY();\n}\n\n=head1 Methods for implementing Bio::AnnotatableI\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $ann = $node->annotation or \n           $node->annotation($ann)\n Function: Gets or sets the annotation\n Returns : Bio::AnnotationCollectionI object\n Args    : None or Bio::AnnotationCollectionI object\nSee L<Bio::AnnotationCollectionI> and L<Bio::Annotation::Collection>\nfor more information\n\n\nsub annotation \n{\n  my ($self,$value) = @_;\n  if( defined $value ) {\n    $self->throw(\"object of class \".ref($value).\" does not implement \".\n        \"Bio::AnnotationCollectionI. Too bad.\")      unless $value->isa(\"Bio::AnnotationCollectionI\");\n    $self->{'_annotation'} = $value;\n  } \n  elsif( ! defined $self->{'_annotation'}) \n  {\n    $self->{'_annotation'} = Bio::Annotation::Collection->new();\n  }\n  return $self->{'_annotation'};\n}\n\n\n=head1 Methods for implementing tag access through Annotation::SimpleValue\n\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $node->add_tag_value($tag,$value)\n Function: Adds a tag value to a node \n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag\n\n\nsub add_tag_value \n{\n  my ($self,$tag,$value) = @_;\n  if( ! defined $tag || ! defined $value ) {\n    $self->warn(\"cannot call add_tag_value with an undefined value\");\n  }\n  my $ac = $self->annotation();\n  my $sv = Bio::Annotation::SimpleValue->new(-value => $value);\n  $ac->add_Annotation($tag, $sv); \n  return scalar $ac->get_Annotations($tag);\n}\n\n=head2 remove_tag\n\n Title   : remove_tag\n Usage   : $node->remove_tag($tag)\n Function: Remove the tag and all values for this tag\n Returns : boolean representing success (0 if tag does not exist)\n Args    : $tag - tagname to remove\n\n\n\nsub remove_tag \n{\n  my ($self,$tag) = @_;\n  my $ac = $self->annotation();\n  if( @{$ac->get_Annotations($tag)} ) {\n    $ac->remove_Annotations($tag);\n    return 1;\n  }\n  return 0;\n}\n\n=head2 remove_all_tags\n\n Title   : remove_all_tags\n Usage   : $node->remove_all_tags()\n Function: Removes all tags \n Returns : None\n Args    : None\n\n\nsub remove_all_tags\n{\n  my ($self) = @_;\n  my $ac = $self->annotation();\n  $ac->remove_Annotations();\n  return;\n}\n\n=head2 get_all_tags\n\n Title   : get_all_tags\n Usage   : my @tags = $node->get_all_tags()\n Function: Gets all the tag names for this Node\n Returns : Array of tagnames\n Args    : None\n\n\nsub get_all_tags{\n  my ($self) = @_;\n  my $ac = $self->annotation();\n  my @tags = sort $ac->get_all_annotation_keys(); \n  # how to restrict it to SimpleValues?\n  return @tags;\n}\n\n=head2 get_tag_values\n\n Title   : get_tag_values\n Usage   : my @values = $node->get_tag_value($tag)\n Function: Gets the values for given tag ($tag)\n Returns : Array of values or empty list if tag does not exist\n Args    : $tag - tag name","parameters":[{"label":"$self"},{"label":"$tag"}],"label":"get_tag_values($self,$tag)"},"kind":12,"range":{"start":{"line":245,"character":0},"end":{"character":9999,"line":250}},"line":245},{"range":{"start":{"line":262,"character":0},"end":{"line":266,"character":9999}},"kind":12,"line":262,"signature":{"parameters":[{"label":"$self"},{"label":"$tag"}],"documentation":"1;\n# BioPerl module for Bio::Tree::AnnotatableNode\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Mira Han <mirhan@indiana.edu>\n#\n# Copyright Mira Han\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::AnnotatableNode - A Tree Node with support for annotation\n\n=head1 SYNOPSIS\n\n    use Bio::Tree::AnnotatableNode;\n    my $nodeA = Bio::Tree::AnnotatableNode->new();\n    my $nodeL = Bio::Tree::AnnotatableNode->new();\n    my $nodeR = Bio::Tree::AnnotatableNode->new();\n\n    my $node = Bio::Tree::AnnotatableNode->new();\n    $node->add_Descendents($nodeL);\n    $node->add_Descendents($nodeR);\n\n    print \"node is not a leaf \\n\" if( $node->is_leaf);\n\n    # $node is-a Bio::AnnotatableI, hence:\n    my $ann_coll = $node->annotation();\n    # $ann_coll is-a Bio::AnnotationCollectionI, hence:\n    my @all_anns = $ann_coll->get_Annotations();\n    # do something with the annotation objects\n\n=head1 DESCRIPTION\n\nMakes a Tree Node with Annotations, suitable for building a Tree.  See\nL<Bio::Tree::Node> for a full list of functionality.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mira Han\n\nEmail mirhan@indiana.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tree::AnnotatableNode;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Seq;\nuse base qw(Bio::Tree::Node Bio::AnnotatableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::AnnotatableNode->new();\n Function: Builds a new Bio::Tree::AnnotatableNode object\n Returns : Bio::Tree::AnnotatableNode\n Args    : -tostring => code reference to the tostring callback function (optional)\n\n\nsub new {\n  my ($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my $to_string_cb = $self->_rearrange([qw(TOSTRING)], @args);\n  if ($to_string_cb) {\n    $self->to_string_callback($to_string_cb);\n  }\n  return $self;\n}\n\nsub DESTROY {\n    my ($self) = @_;\n    # try to insure that everything is cleaned up\n    $self->SUPER::DESTROY();\n}\n\n=head1 Methods for implementing Bio::AnnotatableI\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $ann = $node->annotation or \n           $node->annotation($ann)\n Function: Gets or sets the annotation\n Returns : Bio::AnnotationCollectionI object\n Args    : None or Bio::AnnotationCollectionI object\nSee L<Bio::AnnotationCollectionI> and L<Bio::Annotation::Collection>\nfor more information\n\n\nsub annotation \n{\n  my ($self,$value) = @_;\n  if( defined $value ) {\n    $self->throw(\"object of class \".ref($value).\" does not implement \".\n        \"Bio::AnnotationCollectionI. Too bad.\")      unless $value->isa(\"Bio::AnnotationCollectionI\");\n    $self->{'_annotation'} = $value;\n  } \n  elsif( ! defined $self->{'_annotation'}) \n  {\n    $self->{'_annotation'} = Bio::Annotation::Collection->new();\n  }\n  return $self->{'_annotation'};\n}\n\n\n=head1 Methods for implementing tag access through Annotation::SimpleValue\n\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $node->add_tag_value($tag,$value)\n Function: Adds a tag value to a node \n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag\n\n\nsub add_tag_value \n{\n  my ($self,$tag,$value) = @_;\n  if( ! defined $tag || ! defined $value ) {\n    $self->warn(\"cannot call add_tag_value with an undefined value\");\n  }\n  my $ac = $self->annotation();\n  my $sv = Bio::Annotation::SimpleValue->new(-value => $value);\n  $ac->add_Annotation($tag, $sv); \n  return scalar $ac->get_Annotations($tag);\n}\n\n=head2 remove_tag\n\n Title   : remove_tag\n Usage   : $node->remove_tag($tag)\n Function: Remove the tag and all values for this tag\n Returns : boolean representing success (0 if tag does not exist)\n Args    : $tag - tagname to remove\n\n\n\nsub remove_tag \n{\n  my ($self,$tag) = @_;\n  my $ac = $self->annotation();\n  if( @{$ac->get_Annotations($tag)} ) {\n    $ac->remove_Annotations($tag);\n    return 1;\n  }\n  return 0;\n}\n\n=head2 remove_all_tags\n\n Title   : remove_all_tags\n Usage   : $node->remove_all_tags()\n Function: Removes all tags \n Returns : None\n Args    : None\n\n\nsub remove_all_tags\n{\n  my ($self) = @_;\n  my $ac = $self->annotation();\n  $ac->remove_Annotations();\n  return;\n}\n\n=head2 get_all_tags\n\n Title   : get_all_tags\n Usage   : my @tags = $node->get_all_tags()\n Function: Gets all the tag names for this Node\n Returns : Array of tagnames\n Args    : None\n\n\nsub get_all_tags{\n  my ($self) = @_;\n  my $ac = $self->annotation();\n  my @tags = sort $ac->get_all_annotation_keys(); \n  # how to restrict it to SimpleValues?\n  return @tags;\n}\n\n=head2 get_tag_values\n\n Title   : get_tag_values\n Usage   : my @values = $node->get_tag_value($tag)\n Function: Gets the values for given tag ($tag)\n Returns : Array of values or empty list if tag does not exist\n Args    : $tag - tag name\n\n\nsub get_tag_values{\n  my ($self,$tag) = @_;\n  my $ac = $self->annotation();\n  my @values = map {$_->value()} $ac->get_Annotations($tag);\n  return @values;\n}\n\n=head2 has_tag\n\n Title   : has_tag\n Usage   : $node->has_tag($tag)\n Function: Boolean test if tag exists in the Node\n Returns : Boolean\n Args    : $tag - tagname","label":"has_tag($self,$tag)"},"containerName":"main::","name":"has_tag","children":[{"line":263,"localvar":"my","kind":13,"containerName":"has_tag","name":"$self","definition":"my"},{"line":263,"kind":13,"containerName":"has_tag","name":"$tag"},{"line":264,"name":"$ac","kind":13,"localvar":"my","containerName":"has_tag","definition":"my"},{"line":264,"containerName":"has_tag","kind":13,"name":"$self"},{"name":"annotation","kind":12,"containerName":"has_tag","line":264},{"line":265,"containerName":"has_tag","kind":13,"name":"$ac"},{"line":265,"name":"get_Annotations","containerName":"has_tag","kind":12},{"line":265,"name":"$tag","containerName":"has_tag","kind":13}],"detail":"($self,$tag)","definition":"sub"},{"definition":"sub","detail":"($self,$foo)","children":[{"line":285,"kind":13,"localvar":"my","containerName":"to_string_callback","name":"$self","definition":"my"},{"line":285,"name":"$foo","containerName":"to_string_callback","kind":13},{"line":286,"name":"$foo","kind":13,"containerName":"to_string_callback"},{"kind":13,"containerName":"to_string_callback","name":"$self","line":288},{"line":288,"kind":13,"containerName":"to_string_callback","name":"$foo"},{"name":"$self","kind":13,"containerName":"to_string_callback","line":291},{"containerName":"to_string_callback","kind":13,"name":"$self","line":292},{"kind":13,"containerName":"to_string_callback","name":"$self","line":295}],"containerName":"main::","name":"to_string_callback","signature":{"parameters":[{"label":"$self"},{"label":"$foo"}],"documentation":"1;\n# BioPerl module for Bio::Tree::AnnotatableNode\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Mira Han <mirhan@indiana.edu>\n#\n# Copyright Mira Han\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::AnnotatableNode - A Tree Node with support for annotation\n\n=head1 SYNOPSIS\n\n    use Bio::Tree::AnnotatableNode;\n    my $nodeA = Bio::Tree::AnnotatableNode->new();\n    my $nodeL = Bio::Tree::AnnotatableNode->new();\n    my $nodeR = Bio::Tree::AnnotatableNode->new();\n\n    my $node = Bio::Tree::AnnotatableNode->new();\n    $node->add_Descendents($nodeL);\n    $node->add_Descendents($nodeR);\n\n    print \"node is not a leaf \\n\" if( $node->is_leaf);\n\n    # $node is-a Bio::AnnotatableI, hence:\n    my $ann_coll = $node->annotation();\n    # $ann_coll is-a Bio::AnnotationCollectionI, hence:\n    my @all_anns = $ann_coll->get_Annotations();\n    # do something with the annotation objects\n\n=head1 DESCRIPTION\n\nMakes a Tree Node with Annotations, suitable for building a Tree.  See\nL<Bio::Tree::Node> for a full list of functionality.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mira Han\n\nEmail mirhan@indiana.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tree::AnnotatableNode;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Seq;\nuse base qw(Bio::Tree::Node Bio::AnnotatableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::AnnotatableNode->new();\n Function: Builds a new Bio::Tree::AnnotatableNode object\n Returns : Bio::Tree::AnnotatableNode\n Args    : -tostring => code reference to the tostring callback function (optional)\n\n\nsub new {\n  my ($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my $to_string_cb = $self->_rearrange([qw(TOSTRING)], @args);\n  if ($to_string_cb) {\n    $self->to_string_callback($to_string_cb);\n  }\n  return $self;\n}\n\nsub DESTROY {\n    my ($self) = @_;\n    # try to insure that everything is cleaned up\n    $self->SUPER::DESTROY();\n}\n\n=head1 Methods for implementing Bio::AnnotatableI\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $ann = $node->annotation or \n           $node->annotation($ann)\n Function: Gets or sets the annotation\n Returns : Bio::AnnotationCollectionI object\n Args    : None or Bio::AnnotationCollectionI object\nSee L<Bio::AnnotationCollectionI> and L<Bio::Annotation::Collection>\nfor more information\n\n\nsub annotation \n{\n  my ($self,$value) = @_;\n  if( defined $value ) {\n    $self->throw(\"object of class \".ref($value).\" does not implement \".\n        \"Bio::AnnotationCollectionI. Too bad.\")      unless $value->isa(\"Bio::AnnotationCollectionI\");\n    $self->{'_annotation'} = $value;\n  } \n  elsif( ! defined $self->{'_annotation'}) \n  {\n    $self->{'_annotation'} = Bio::Annotation::Collection->new();\n  }\n  return $self->{'_annotation'};\n}\n\n\n=head1 Methods for implementing tag access through Annotation::SimpleValue\n\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $node->add_tag_value($tag,$value)\n Function: Adds a tag value to a node \n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag\n\n\nsub add_tag_value \n{\n  my ($self,$tag,$value) = @_;\n  if( ! defined $tag || ! defined $value ) {\n    $self->warn(\"cannot call add_tag_value with an undefined value\");\n  }\n  my $ac = $self->annotation();\n  my $sv = Bio::Annotation::SimpleValue->new(-value => $value);\n  $ac->add_Annotation($tag, $sv); \n  return scalar $ac->get_Annotations($tag);\n}\n\n=head2 remove_tag\n\n Title   : remove_tag\n Usage   : $node->remove_tag($tag)\n Function: Remove the tag and all values for this tag\n Returns : boolean representing success (0 if tag does not exist)\n Args    : $tag - tagname to remove\n\n\n\nsub remove_tag \n{\n  my ($self,$tag) = @_;\n  my $ac = $self->annotation();\n  if( @{$ac->get_Annotations($tag)} ) {\n    $ac->remove_Annotations($tag);\n    return 1;\n  }\n  return 0;\n}\n\n=head2 remove_all_tags\n\n Title   : remove_all_tags\n Usage   : $node->remove_all_tags()\n Function: Removes all tags \n Returns : None\n Args    : None\n\n\nsub remove_all_tags\n{\n  my ($self) = @_;\n  my $ac = $self->annotation();\n  $ac->remove_Annotations();\n  return;\n}\n\n=head2 get_all_tags\n\n Title   : get_all_tags\n Usage   : my @tags = $node->get_all_tags()\n Function: Gets all the tag names for this Node\n Returns : Array of tagnames\n Args    : None\n\n\nsub get_all_tags{\n  my ($self) = @_;\n  my $ac = $self->annotation();\n  my @tags = sort $ac->get_all_annotation_keys(); \n  # how to restrict it to SimpleValues?\n  return @tags;\n}\n\n=head2 get_tag_values\n\n Title   : get_tag_values\n Usage   : my @values = $node->get_tag_value($tag)\n Function: Gets the values for given tag ($tag)\n Returns : Array of values or empty list if tag does not exist\n Args    : $tag - tag name\n\n\nsub get_tag_values{\n  my ($self,$tag) = @_;\n  my $ac = $self->annotation();\n  my @values = map {$_->value()} $ac->get_Annotations($tag);\n  return @values;\n}\n\n=head2 has_tag\n\n Title   : has_tag\n Usage   : $node->has_tag($tag)\n Function: Boolean test if tag exists in the Node\n Returns : Boolean\n Args    : $tag - tagname\n\n\nsub has_tag {\n  my ($self,$tag) = @_;\n  my $ac = $self->annotation();\n  return ( scalar $ac->get_Annotations($tag) > 0);\n}\n\n\n=head1 Methods for implementing to_string\n\n\n=head2 to_string_callback\n\n Title   : to_string_callback\n Usage   : $node->to_string_callback(\\&func)\n Function: get/set callback for to_string\n Returns : code reference for the to_string callback function\n Args    : \\&func - code reference to be set as the callback function","label":"to_string_callback($self,$foo)"},"line":283,"kind":12,"range":{"start":{"line":283,"character":0},"end":{"line":296,"character":9999}}},{"name":"Bio","kind":12,"containerName":"Tree::NodeI::to_string","line":295},{"line":298,"range":{"end":{"character":9999,"line":302},"start":{"line":298,"character":0}},"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"","label":"to_string($self)"},"children":[{"kind":13,"localvar":"my","containerName":"to_string","name":"$self","line":299,"definition":"my"},{"definition":"my","line":300,"localvar":"my","containerName":"to_string","kind":13,"name":"$cb"},{"line":300,"kind":13,"containerName":"to_string","name":"$self"},{"name":"to_string_callback","kind":12,"containerName":"to_string","line":300},{"line":301,"name":"$cb","kind":13,"containerName":"to_string"},{"name":"$self","containerName":"to_string","kind":13,"line":301}],"containerName":"main::","name":"to_string","definition":"sub","detail":"($self)"},{"detail":"($self,$value)","definition":"sub","name":"sequence","containerName":"main::","children":[{"definition":"my","localvar":"my","containerName":"sequence","kind":13,"name":"$self","line":323},{"line":323,"containerName":"sequence","kind":13,"name":"$value"},{"line":324,"containerName":"sequence","kind":13,"name":"$value"},{"kind":13,"containerName":"sequence","name":"$self","line":325},{"name":"throw","containerName":"sequence","kind":12,"line":325},{"line":325,"containerName":"sequence","kind":13,"name":"$value"},{"containerName":"sequence","kind":13,"name":"$value","line":326},{"containerName":"sequence","kind":12,"name":"isa","line":326},{"line":327,"containerName":"sequence","kind":13,"name":"$self"},{"line":327,"kind":13,"containerName":"sequence","name":"$value"}],"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# BioPerl module for Bio::Tree::AnnotatableNode\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Mira Han <mirhan@indiana.edu>\n#\n# Copyright Mira Han\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::AnnotatableNode - A Tree Node with support for annotation\n\n=head1 SYNOPSIS\n\n    use Bio::Tree::AnnotatableNode;\n    my $nodeA = Bio::Tree::AnnotatableNode->new();\n    my $nodeL = Bio::Tree::AnnotatableNode->new();\n    my $nodeR = Bio::Tree::AnnotatableNode->new();\n\n    my $node = Bio::Tree::AnnotatableNode->new();\n    $node->add_Descendents($nodeL);\n    $node->add_Descendents($nodeR);\n\n    print \"node is not a leaf \\n\" if( $node->is_leaf);\n\n    # $node is-a Bio::AnnotatableI, hence:\n    my $ann_coll = $node->annotation();\n    # $ann_coll is-a Bio::AnnotationCollectionI, hence:\n    my @all_anns = $ann_coll->get_Annotations();\n    # do something with the annotation objects\n\n=head1 DESCRIPTION\n\nMakes a Tree Node with Annotations, suitable for building a Tree.  See\nL<Bio::Tree::Node> for a full list of functionality.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mira Han\n\nEmail mirhan@indiana.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tree::AnnotatableNode;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Seq;\nuse base qw(Bio::Tree::Node Bio::AnnotatableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::AnnotatableNode->new();\n Function: Builds a new Bio::Tree::AnnotatableNode object\n Returns : Bio::Tree::AnnotatableNode\n Args    : -tostring => code reference to the tostring callback function (optional)\n\n\nsub new {\n  my ($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my $to_string_cb = $self->_rearrange([qw(TOSTRING)], @args);\n  if ($to_string_cb) {\n    $self->to_string_callback($to_string_cb);\n  }\n  return $self;\n}\n\nsub DESTROY {\n    my ($self) = @_;\n    # try to insure that everything is cleaned up\n    $self->SUPER::DESTROY();\n}\n\n=head1 Methods for implementing Bio::AnnotatableI\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $ann = $node->annotation or \n           $node->annotation($ann)\n Function: Gets or sets the annotation\n Returns : Bio::AnnotationCollectionI object\n Args    : None or Bio::AnnotationCollectionI object\nSee L<Bio::AnnotationCollectionI> and L<Bio::Annotation::Collection>\nfor more information\n\n\nsub annotation \n{\n  my ($self,$value) = @_;\n  if( defined $value ) {\n    $self->throw(\"object of class \".ref($value).\" does not implement \".\n        \"Bio::AnnotationCollectionI. Too bad.\")      unless $value->isa(\"Bio::AnnotationCollectionI\");\n    $self->{'_annotation'} = $value;\n  } \n  elsif( ! defined $self->{'_annotation'}) \n  {\n    $self->{'_annotation'} = Bio::Annotation::Collection->new();\n  }\n  return $self->{'_annotation'};\n}\n\n\n=head1 Methods for implementing tag access through Annotation::SimpleValue\n\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $node->add_tag_value($tag,$value)\n Function: Adds a tag value to a node \n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag\n\n\nsub add_tag_value \n{\n  my ($self,$tag,$value) = @_;\n  if( ! defined $tag || ! defined $value ) {\n    $self->warn(\"cannot call add_tag_value with an undefined value\");\n  }\n  my $ac = $self->annotation();\n  my $sv = Bio::Annotation::SimpleValue->new(-value => $value);\n  $ac->add_Annotation($tag, $sv); \n  return scalar $ac->get_Annotations($tag);\n}\n\n=head2 remove_tag\n\n Title   : remove_tag\n Usage   : $node->remove_tag($tag)\n Function: Remove the tag and all values for this tag\n Returns : boolean representing success (0 if tag does not exist)\n Args    : $tag - tagname to remove\n\n\n\nsub remove_tag \n{\n  my ($self,$tag) = @_;\n  my $ac = $self->annotation();\n  if( @{$ac->get_Annotations($tag)} ) {\n    $ac->remove_Annotations($tag);\n    return 1;\n  }\n  return 0;\n}\n\n=head2 remove_all_tags\n\n Title   : remove_all_tags\n Usage   : $node->remove_all_tags()\n Function: Removes all tags \n Returns : None\n Args    : None\n\n\nsub remove_all_tags\n{\n  my ($self) = @_;\n  my $ac = $self->annotation();\n  $ac->remove_Annotations();\n  return;\n}\n\n=head2 get_all_tags\n\n Title   : get_all_tags\n Usage   : my @tags = $node->get_all_tags()\n Function: Gets all the tag names for this Node\n Returns : Array of tagnames\n Args    : None\n\n\nsub get_all_tags{\n  my ($self) = @_;\n  my $ac = $self->annotation();\n  my @tags = sort $ac->get_all_annotation_keys(); \n  # how to restrict it to SimpleValues?\n  return @tags;\n}\n\n=head2 get_tag_values\n\n Title   : get_tag_values\n Usage   : my @values = $node->get_tag_value($tag)\n Function: Gets the values for given tag ($tag)\n Returns : Array of values or empty list if tag does not exist\n Args    : $tag - tag name\n\n\nsub get_tag_values{\n  my ($self,$tag) = @_;\n  my $ac = $self->annotation();\n  my @values = map {$_->value()} $ac->get_Annotations($tag);\n  return @values;\n}\n\n=head2 has_tag\n\n Title   : has_tag\n Usage   : $node->has_tag($tag)\n Function: Boolean test if tag exists in the Node\n Returns : Boolean\n Args    : $tag - tagname\n\n\nsub has_tag {\n  my ($self,$tag) = @_;\n  my $ac = $self->annotation();\n  return ( scalar $ac->get_Annotations($tag) > 0);\n}\n\n\n=head1 Methods for implementing to_string\n\n\n=head2 to_string_callback\n\n Title   : to_string_callback\n Usage   : $node->to_string_callback(\\&func)\n Function: get/set callback for to_string\n Returns : code reference for the to_string callback function\n Args    : \\&func - code reference to be set as the callback function\n\n\nsub to_string_callback {\n    # get/set callback, using $DEFAULT_CB if nothing is set\n    my ($self, $foo) = @_;\n    if ($foo) {\n      # $foo is callback code ref, self as first arg (so you have access to object data)\n      $self->{'_to_string_cb'} = $foo;\n    }\n    else {\n      if (! defined $self->{'_to_string_cb'}) {\n        $self->{'_to_string_cb'} = \\&Bio::Tree::NodeI::to_string;\n      }\n    }\n    return $self->{'_to_string_cb'};\n}\n\nsub to_string {\n  my ($self) = @_;\n  my $cb = $self->to_string_callback();\n  return $cb->($self);\n}\n\n=head1 Methods for accessing Bio::Seq\n\n\n=head2 sequence\n\n Title   : sequence\n Usage   : $ann = $node->sequence or \n           $node->sequence($seq)\n Function: Gets or sets the sequence\n Returns : array reference of Bio::SeqI objects\n Args    : None or Bio::SeqI object\nSee L<Bio::SeqI> and L<Bio::Seq>\nfor more information","label":"sequence($self,$value)"},"kind":12,"range":{"start":{"character":0,"line":321},"end":{"character":9999,"line":328}},"line":321},{"line":333,"kind":13,"containerName":null,"name":"%self"},{"signature":{"documentation":"1;\n# BioPerl module for Bio::Tree::AnnotatableNode\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Mira Han <mirhan@indiana.edu>\n#\n# Copyright Mira Han\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::AnnotatableNode - A Tree Node with support for annotation\n\n=head1 SYNOPSIS\n\n    use Bio::Tree::AnnotatableNode;\n    my $nodeA = Bio::Tree::AnnotatableNode->new();\n    my $nodeL = Bio::Tree::AnnotatableNode->new();\n    my $nodeR = Bio::Tree::AnnotatableNode->new();\n\n    my $node = Bio::Tree::AnnotatableNode->new();\n    $node->add_Descendents($nodeL);\n    $node->add_Descendents($nodeR);\n\n    print \"node is not a leaf \\n\" if( $node->is_leaf);\n\n    # $node is-a Bio::AnnotatableI, hence:\n    my $ann_coll = $node->annotation();\n    # $ann_coll is-a Bio::AnnotationCollectionI, hence:\n    my @all_anns = $ann_coll->get_Annotations();\n    # do something with the annotation objects\n\n=head1 DESCRIPTION\n\nMakes a Tree Node with Annotations, suitable for building a Tree.  See\nL<Bio::Tree::Node> for a full list of functionality.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mira Han\n\nEmail mirhan@indiana.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tree::AnnotatableNode;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Seq;\nuse base qw(Bio::Tree::Node Bio::AnnotatableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::AnnotatableNode->new();\n Function: Builds a new Bio::Tree::AnnotatableNode object\n Returns : Bio::Tree::AnnotatableNode\n Args    : -tostring => code reference to the tostring callback function (optional)\n\n\nsub new {\n  my ($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my $to_string_cb = $self->_rearrange([qw(TOSTRING)], @args);\n  if ($to_string_cb) {\n    $self->to_string_callback($to_string_cb);\n  }\n  return $self;\n}\n\nsub DESTROY {\n    my ($self) = @_;\n    # try to insure that everything is cleaned up\n    $self->SUPER::DESTROY();\n}\n\n=head1 Methods for implementing Bio::AnnotatableI\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $ann = $node->annotation or \n           $node->annotation($ann)\n Function: Gets or sets the annotation\n Returns : Bio::AnnotationCollectionI object\n Args    : None or Bio::AnnotationCollectionI object\nSee L<Bio::AnnotationCollectionI> and L<Bio::Annotation::Collection>\nfor more information\n\n\nsub annotation \n{\n  my ($self,$value) = @_;\n  if( defined $value ) {\n    $self->throw(\"object of class \".ref($value).\" does not implement \".\n        \"Bio::AnnotationCollectionI. Too bad.\")      unless $value->isa(\"Bio::AnnotationCollectionI\");\n    $self->{'_annotation'} = $value;\n  } \n  elsif( ! defined $self->{'_annotation'}) \n  {\n    $self->{'_annotation'} = Bio::Annotation::Collection->new();\n  }\n  return $self->{'_annotation'};\n}\n\n\n=head1 Methods for implementing tag access through Annotation::SimpleValue\n\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $node->add_tag_value($tag,$value)\n Function: Adds a tag value to a node \n Returns : number of values stored for this tag\n Args    : $tag   - tag name\n           $value - value to store for the tag\n\n\nsub add_tag_value \n{\n  my ($self,$tag,$value) = @_;\n  if( ! defined $tag || ! defined $value ) {\n    $self->warn(\"cannot call add_tag_value with an undefined value\");\n  }\n  my $ac = $self->annotation();\n  my $sv = Bio::Annotation::SimpleValue->new(-value => $value);\n  $ac->add_Annotation($tag, $sv); \n  return scalar $ac->get_Annotations($tag);\n}\n\n=head2 remove_tag\n\n Title   : remove_tag\n Usage   : $node->remove_tag($tag)\n Function: Remove the tag and all values for this tag\n Returns : boolean representing success (0 if tag does not exist)\n Args    : $tag - tagname to remove\n\n\n\nsub remove_tag \n{\n  my ($self,$tag) = @_;\n  my $ac = $self->annotation();\n  if( @{$ac->get_Annotations($tag)} ) {\n    $ac->remove_Annotations($tag);\n    return 1;\n  }\n  return 0;\n}\n\n=head2 remove_all_tags\n\n Title   : remove_all_tags\n Usage   : $node->remove_all_tags()\n Function: Removes all tags \n Returns : None\n Args    : None\n\n\nsub remove_all_tags\n{\n  my ($self) = @_;\n  my $ac = $self->annotation();\n  $ac->remove_Annotations();\n  return;\n}\n\n=head2 get_all_tags\n\n Title   : get_all_tags\n Usage   : my @tags = $node->get_all_tags()\n Function: Gets all the tag names for this Node\n Returns : Array of tagnames\n Args    : None\n\n\nsub get_all_tags{\n  my ($self) = @_;\n  my $ac = $self->annotation();\n  my @tags = sort $ac->get_all_annotation_keys(); \n  # how to restrict it to SimpleValues?\n  return @tags;\n}\n\n=head2 get_tag_values\n\n Title   : get_tag_values\n Usage   : my @values = $node->get_tag_value($tag)\n Function: Gets the values for given tag ($tag)\n Returns : Array of values or empty list if tag does not exist\n Args    : $tag - tag name\n\n\nsub get_tag_values{\n  my ($self,$tag) = @_;\n  my $ac = $self->annotation();\n  my @values = map {$_->value()} $ac->get_Annotations($tag);\n  return @values;\n}\n\n=head2 has_tag\n\n Title   : has_tag\n Usage   : $node->has_tag($tag)\n Function: Boolean test if tag exists in the Node\n Returns : Boolean\n Args    : $tag - tagname\n\n\nsub has_tag {\n  my ($self,$tag) = @_;\n  my $ac = $self->annotation();\n  return ( scalar $ac->get_Annotations($tag) > 0);\n}\n\n\n=head1 Methods for implementing to_string\n\n\n=head2 to_string_callback\n\n Title   : to_string_callback\n Usage   : $node->to_string_callback(\\&func)\n Function: get/set callback for to_string\n Returns : code reference for the to_string callback function\n Args    : \\&func - code reference to be set as the callback function\n\n\nsub to_string_callback {\n    # get/set callback, using $DEFAULT_CB if nothing is set\n    my ($self, $foo) = @_;\n    if ($foo) {\n      # $foo is callback code ref, self as first arg (so you have access to object data)\n      $self->{'_to_string_cb'} = $foo;\n    }\n    else {\n      if (! defined $self->{'_to_string_cb'}) {\n        $self->{'_to_string_cb'} = \\&Bio::Tree::NodeI::to_string;\n      }\n    }\n    return $self->{'_to_string_cb'};\n}\n\nsub to_string {\n  my ($self) = @_;\n  my $cb = $self->to_string_callback();\n  return $cb->($self);\n}\n\n=head1 Methods for accessing Bio::Seq\n\n\n=head2 sequence\n\n Title   : sequence\n Usage   : $ann = $node->sequence or \n           $node->sequence($seq)\n Function: Gets or sets the sequence\n Returns : array reference of Bio::SeqI objects\n Args    : None or Bio::SeqI object\nSee L<Bio::SeqI> and L<Bio::Seq>\nfor more information\n\n\nsub sequence\n{\n  my ($self,$value) = @_;\n  if( defined $value ) {\n    $self->throw(\"object of class \".ref($value).\" does not implement \".\n        \"Bio::SeqI. Too bad.\")      unless $value->isa(\"Bio::SeqI\");\n    push (@{$self->{'_sequence'}}, $value);\n  } \n  #elsif( ! defined $self->{'_sequence'}) \n  #{\n  #  $self->{'_sequence'} = Bio::Seq->new();\n  #}\n  return $self->{'_sequence'};\n}\n\n=head2 has_sequence\n\n Title   : has_sequence\n Usage   : if( $node->has_sequence) { # do something } \n Function: tells if node has sequence attached\n Returns : Boolean for whether or not node has Bio::SeqI attached.\n Args    : None ","parameters":[{"label":"$self"}],"label":"has_sequence($self)"},"line":346,"kind":12,"range":{"start":{"character":0,"line":346},"end":{"line":349,"character":9999}},"definition":"sub","detail":"($self)","children":[{"line":348,"kind":13,"localvar":"my","containerName":"has_sequence","name":"$self","definition":"my"},{"line":349,"containerName":"has_sequence","kind":13,"name":"$self"},{"name":"$self","kind":13,"containerName":"has_sequence","line":349}],"containerName":"main::","name":"has_sequence"}]}