{"vars":[{"line":103,"name":"base","kind":2,"containerName":""},{"line":138,"kind":12,"range":{"start":{"line":138,"character":0},"end":{"character":9999,"line":152}},"signature":{"documentation":"1;\n# $Id: isPcr.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::isPcr\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# Copyright Sheldon McKay\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::isPcr - Parse isPcr output and make features\n\n=head1 SYNOPSIS\n\n    # A simple annotation pipeline wrapper for isPcr data\n    # assuming isPcr data is already generated in file seq1.isPcr\n    # and sequence data is in fasta format in file called seq1.fa\n\n    # Note: this parser is meant for the default fasta output from\n    # isPcr.  bed and psl output formats are not supported.\n\n    use Bio::Tools::IsPcr;\n    use Bio::SeqIO;\n    my $parser = Bio::Tools::isPcr->new(-file => 'seq1.isPcr');\n    my $seqio = Bio::SeqIO->new(-format => 'fasta', -file => 'seq1.fa');\n    my $seq = $seqio->next_seq || die(\"cannot get a seq object from SeqIO\");\n\n    while( my $feat = $parser->next_feature ) {\n\t# add isPcr annotation to a sequence\n\t$seq->add_SeqFeature($feat);\n    }\n    my $seqout = Bio::SeqIO->new(-format => 'embl');\n    $seqout->write_seq($seq);\n\n\n=head1 DESCRIPTION\n\nThis object serves as a parser for isPcr data (in the default fasta\nformat), creating a Bio::SeqFeatureI for each isPcr hit.  \nThese can be processed or added as annotation to an existing\nBio::SeqI object for the purposes of automated annotation.\n\nThis module is adapted from the Bio::Tools::EPCR module\nwritten by Jason Stajich (jason-at-bioperl.org).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::isPcr;\nuse strict;\n\nuse Bio::SeqIO;\nuse Bio::SeqFeature::Generic;\n\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $ispcr = Bio::Tools::isPcr->new( -file => $file,\n\t\t\t\t\t      -primary => $fprimary, \n\t\t\t\t\t      -source => $fsource,\n\t\t\t\t\t      -groupclass => $fgroupclass);\n\n Function: Initializes a new isPcr parser\n Returns : Bio::Tools::isPcr\n Args    : -fh   => filehandle\n           OR\n           -file => filename\n\n           -primary => a string to be used as the common value for\n                       each features '-primary' tag.  Defaults to\n                       the sequence ontology term 'PCR_product'.  \n                       (This in turn maps to the GFF 'type'\n                       tag (aka 'method')).\n\n            -source => a string to be used as the common value for\n                       each features '-source' tag.  Defaults to\n                       'isPcr'. (This in turn maps to the GFF 'source'\n                       tag)\n\n            -groupclass => a string to be used as the name of the tag\n                           which will hold the sts marker namefirst\n                           attribute.  Defaults to 'name'.","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"children":[{"definition":"my","line":139,"name":"$class","localvar":"my","kind":13,"containerName":"new"},{"name":"@args","containerName":"new","kind":13,"line":139},{"kind":13,"localvar":"my","containerName":"new","name":"$self","line":141,"definition":"my"},{"containerName":"new","kind":13,"name":"$class","line":141},{"name":"@args","containerName":"new","kind":13,"line":141},{"line":142,"name":"$primary","kind":13,"localvar":"my","containerName":"new","definition":"my"},{"name":"$source","kind":13,"containerName":"new","line":142},{"containerName":"new","kind":13,"name":"$groupclass","line":142},{"name":"$self","kind":13,"containerName":"new","line":143},{"line":143,"kind":12,"containerName":"new","name":"_rearrange"},{"line":143,"containerName":"new","kind":13,"name":"@args"},{"name":"$self","containerName":"new","kind":13,"line":144},{"name":"primary","kind":12,"containerName":"new","line":144},{"line":144,"containerName":"new","kind":13,"name":"$primary"},{"name":"$primary","kind":13,"containerName":"new","line":144},{"kind":13,"containerName":"new","name":"$self","line":145},{"containerName":"new","kind":12,"name":"source","line":145},{"name":"$source","kind":13,"containerName":"new","line":145},{"kind":13,"containerName":"new","name":"$source","line":145},{"line":146,"kind":13,"containerName":"new","name":"$self"},{"name":"groupclass","kind":12,"containerName":"new","line":146},{"line":146,"name":"$groupclass","kind":13,"containerName":"new"},{"name":"$groupclass","containerName":"new","kind":13,"line":146},{"line":149,"containerName":"new","kind":13,"name":"$self"},{"containerName":"new","kind":12,"name":"new","line":149},{"containerName":"new","kind":13,"name":"@args","line":149},{"name":"$self","kind":13,"containerName":"new","line":151}],"containerName":"main::","name":"new","definition":"sub","detail":"($class,@args)"},{"line":141,"name":"SUPER","kind":12,"containerName":"new"},{"line":149,"name":"io","kind":12},{"line":149,"name":"Bio","containerName":"SeqIO","kind":12},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: isPcr.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::isPcr\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# Copyright Sheldon McKay\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::isPcr - Parse isPcr output and make features\n\n=head1 SYNOPSIS\n\n    # A simple annotation pipeline wrapper for isPcr data\n    # assuming isPcr data is already generated in file seq1.isPcr\n    # and sequence data is in fasta format in file called seq1.fa\n\n    # Note: this parser is meant for the default fasta output from\n    # isPcr.  bed and psl output formats are not supported.\n\n    use Bio::Tools::IsPcr;\n    use Bio::SeqIO;\n    my $parser = Bio::Tools::isPcr->new(-file => 'seq1.isPcr');\n    my $seqio = Bio::SeqIO->new(-format => 'fasta', -file => 'seq1.fa');\n    my $seq = $seqio->next_seq || die(\"cannot get a seq object from SeqIO\");\n\n    while( my $feat = $parser->next_feature ) {\n\t# add isPcr annotation to a sequence\n\t$seq->add_SeqFeature($feat);\n    }\n    my $seqout = Bio::SeqIO->new(-format => 'embl');\n    $seqout->write_seq($seq);\n\n\n=head1 DESCRIPTION\n\nThis object serves as a parser for isPcr data (in the default fasta\nformat), creating a Bio::SeqFeatureI for each isPcr hit.  \nThese can be processed or added as annotation to an existing\nBio::SeqI object for the purposes of automated annotation.\n\nThis module is adapted from the Bio::Tools::EPCR module\nwritten by Jason Stajich (jason-at-bioperl.org).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::isPcr;\nuse strict;\n\nuse Bio::SeqIO;\nuse Bio::SeqFeature::Generic;\n\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $ispcr = Bio::Tools::isPcr->new( -file => $file,\n\t\t\t\t\t      -primary => $fprimary, \n\t\t\t\t\t      -source => $fsource,\n\t\t\t\t\t      -groupclass => $fgroupclass);\n\n Function: Initializes a new isPcr parser\n Returns : Bio::Tools::isPcr\n Args    : -fh   => filehandle\n           OR\n           -file => filename\n\n           -primary => a string to be used as the common value for\n                       each features '-primary' tag.  Defaults to\n                       the sequence ontology term 'PCR_product'.  \n                       (This in turn maps to the GFF 'type'\n                       tag (aka 'method')).\n\n            -source => a string to be used as the common value for\n                       each features '-source' tag.  Defaults to\n                       'isPcr'. (This in turn maps to the GFF 'source'\n                       tag)\n\n            -groupclass => a string to be used as the name of the tag\n                           which will hold the sts marker namefirst\n                           attribute.  Defaults to 'name'.\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($primary,$source,$groupclass) = \n      $self->_rearrange([qw/PRIMARY SOURCE GROUPCLASS/],@args);\n  $self->primary(defined $primary ? $primary : 'PCR_product');\n  $self->source(defined $source ? $source : 'isPcr');\n  $self->groupclass(defined $groupclass ? $groupclass : 'name');\n\n  # default output for isPcr is fasta format\n  $self->{io} = Bio::SeqIO->new(-format => 'fasta', @args);\n\n  return $self;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : $seqfeature = $obj->next_feature();\n Function: Returns the next feature available in the analysis result, or\n           undef if there are no more features.\n Example :\n Returns : A Bio::SeqFeatureI implementing object, or undef if there are no\n           more features.\n Args    : none    ","label":"next_feature($self)"},"line":167,"range":{"end":{"line":201,"character":9999},"start":{"line":167,"character":0}},"kind":12,"definition":"sub","detail":"($self)","children":[{"definition":"my","containerName":"next_feature","localvar":"my","kind":13,"name":"$self","line":168},{"name":"$result","localvar":"my","kind":13,"containerName":"next_feature","line":169,"definition":"my"},{"name":"$self","kind":13,"containerName":"next_feature","line":169},{"containerName":"next_feature","kind":12,"name":"next_seq","line":169},{"line":170,"name":"$result","kind":13,"containerName":"next_feature"},{"line":172,"name":"$seqname","containerName":"next_feature","localvar":"my","kind":13,"definition":"my"},{"name":"$location","kind":13,"containerName":"next_feature","line":172},{"line":172,"kind":13,"containerName":"next_feature","name":"$result"},{"line":172,"name":"primary_id","kind":12,"containerName":"next_feature"},{"definition":"my","line":173,"localvar":"my","kind":13,"containerName":"next_feature","name":"$pcrname"},{"line":173,"kind":13,"containerName":"next_feature","name":"$left"},{"name":"$right","containerName":"next_feature","kind":13,"line":173},{"containerName":"next_feature","kind":13,"name":"$result","line":173},{"name":"desc","containerName":"next_feature","kind":12,"line":173},{"definition":"my","name":"$start","localvar":"my","kind":13,"containerName":"next_feature","line":174},{"name":"$strand","containerName":"next_feature","kind":13,"line":174},{"name":"$end","kind":13,"containerName":"next_feature","line":174},{"line":174,"name":"$location","containerName":"next_feature","kind":13},{"line":175,"localvar":"my","containerName":"next_feature","kind":13,"name":"$amplicon","definition":"my"},{"line":175,"containerName":"next_feature","kind":13,"name":"$result"},{"name":"seq","containerName":"next_feature","kind":12,"line":175},{"line":179,"containerName":"next_feature","kind":13,"name":"$self"},{"line":179,"name":"$pcrname","containerName":"next_feature","kind":13},{"name":"$pcrname","containerName":"next_feature","kind":13,"line":180},{"localvar":"my","containerName":"next_feature","kind":13,"name":"$tags","line":183,"definition":"my"},{"line":184,"kind":13,"containerName":"next_feature","name":"$self"},{"containerName":"next_feature","kind":12,"name":"groupclass","line":184},{"containerName":"next_feature","kind":13,"name":"$pcrname","line":184},{"line":185,"name":"$amplicon","containerName":"next_feature","kind":13},{"containerName":"next_feature","kind":13,"name":"$left","line":186},{"line":188,"containerName":"next_feature","kind":13,"name":"$right"},{"line":190,"localvar":"my","kind":13,"containerName":"next_feature","name":"$markerfeature","definition":"my"},{"line":190,"name":"new","kind":12,"containerName":"next_feature"},{"containerName":"next_feature","kind":13,"name":"$start","line":191},{"line":192,"name":"$end","kind":13,"containerName":"next_feature"},{"line":193,"kind":13,"containerName":"next_feature","name":"$strand"},{"name":"$self","containerName":"next_feature","kind":13,"line":194},{"containerName":"next_feature","kind":12,"name":"source","line":194},{"line":195,"name":"$self","kind":13,"containerName":"next_feature"},{"line":195,"containerName":"next_feature","kind":12,"name":"primary"},{"line":196,"name":"$seqname","kind":13,"containerName":"next_feature"},{"name":"$tags","kind":13,"containerName":"next_feature","line":198},{"containerName":"next_feature","kind":13,"name":"$markerfeature","line":200}],"name":"next_feature","containerName":"main::"},{"kind":12,"name":"io","line":169},{"line":179,"name":"seen","kind":12},{"line":185,"name":"amplicon","kind":12},{"line":186,"name":"left_primer","kind":12},{"name":"right_primer","kind":12,"line":187},{"name":"Bio","kind":12,"containerName":"SeqFeature::Generic","line":190},{"range":{"start":{"line":215,"character":0},"end":{"character":9999,"line":219}},"kind":12,"line":215,"containerName":"main::","name":"source","children":[{"localvar":"my","kind":13,"containerName":"source","name":"$self","line":216,"definition":"my"},{"kind":13,"containerName":"source","name":"$self","line":217},{"containerName":"source","kind":13,"name":"$self","line":218}],"definition":"sub"},{"children":[{"line":234,"name":"$self","containerName":"primary","localvar":"my","kind":13,"definition":"my"},{"line":235,"containerName":"primary","kind":13,"name":"$self"},{"kind":13,"containerName":"primary","name":"$self","line":236}],"name":"primary","containerName":"main::","definition":"sub","line":233,"kind":12,"range":{"start":{"line":233,"character":0},"end":{"line":237,"character":9999}}},{"line":251,"kind":12,"range":{"end":{"character":9999,"line":256},"start":{"character":0,"line":251}},"definition":"sub","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"groupclass","line":252,"definition":"my"},{"kind":13,"containerName":"groupclass","name":"$self","line":254},{"name":"$self","kind":13,"containerName":"groupclass","line":255}],"containerName":"main::","name":"groupclass"}],"version":5}