{"vars":[{"kind":2,"containerName":"","name":"base","line":108},{"name":"%PATTERNS","containerName":"main::","kind":13,"line":110,"definition":"our"},{"kind":12,"name":"Pol3","line":113},{"line":116,"kind":13,"containerName":"main::","name":"$DEFAULT_CUTOFF","definition":"our"},{"definition":"sub","detail":"($proto,%args)","children":[{"definition":"my","line":128,"localvar":"my","containerName":"new","kind":13,"name":"$proto"},{"line":128,"containerName":"new","kind":13,"name":"%args"},{"line":129,"name":"$class","localvar":"my","kind":13,"containerName":"new","definition":"my"},{"name":"$proto","kind":13,"containerName":"new","line":129},{"line":129,"kind":13,"containerName":"new","name":"$proto"},{"containerName":"new","kind":13,"name":"$args","line":131},{"line":133,"kind":13,"containerName":"new","name":"$class"},{"name":"%args","containerName":"new","kind":13,"line":133}],"containerName":"main::","name":"new","signature":{"parameters":[{"label":"$proto"},{"label":"%args"}],"documentation":"1;\n#\n#\n# BioPerl module for Bio::Tools::SiRNA::Ruleset::tuschl\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::SiRNA::Ruleset::tuschl - Perl object implementing the\ntuschl group's rules for designing small inhibitory RNAs\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Instead, use Bio::Tools::SiRNA and\nspecify the tuschl ruleset:\n\n  use Bio::Tools::SiRNA;\n\n  my $sirna_designer = Bio::Tools::SiRNA->new( -target => $bio_seq,\n                                               -rules  => 'tuschl'\n    );\n  my @pairs = $sirna_designer->design;\n\n  foreach $pair (@pairs) {\n      my $sense_oligo_sequence = $pair->sense->seq;\n      my $antisense_oligo_sequence = $pair->antisense->seq;\n\n      # print out results\n      print join (\"\\t\", $pair->start, $pair->end, $pair->rank,\n                  $sense_oligo_sequence, $antisense_oligo_sequence), \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis package implements the rules for designing siRNA reagents\ndeveloped by Tuschl and colleagues (see\nhttp://www.rockefeller.edu/labheads/tuschl/sirna.html). It looks for\noligos that match the following patterns in the target sequence:\n\n  1. AA(N19)TT (rank 1)\n  2. AA(N21) (rank 2)\n  3. NA(N21) (rank 3)\n\nThe package also supports selection of siRNA seqences that can be\ntranscribed by pol3:\n\n    A[A,G]N17[C,T]\n\n=head1 SEE ALSO\n\nL<Bio::Tools::SiRNA>, L<Bio::SeqFeature::SiRNA::Pair>,\nL<Bio::SeqFeature::SiRNA::Oligo>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nDonald Jackson (donald.jackson@bms.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\npackage Bio::Tools::SiRNA::Ruleset::tuschl;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Tools::SiRNA);\n\nour %PATTERNS = ( 1 \t=> '(AA.{19}TT)',\n\t\t  2 \t=> '(AA.{19}[ACG][ACG])',\n\t\t  3 \t=> '([CGT]A.{21})',\n\t\t  Pol3\t=> '(.A[AG].{17}[CT]..)'\n\t\t  );\n\nour $DEFAULT_CUTOFF = 2;\n\n=head2 new\n\n  Title\t: new\n  Usage\t: Do not call directly - use Bio::Tools::SiRNA->new instead.\n  Returns : Bio::Tools::SiRNA::Ruleset::saigo object\n  Args\t: none","label":"new($proto,%args)"},"line":127,"kind":12,"range":{"end":{"character":9999,"line":134},"start":{"character":0,"line":127}}},{"line":133,"containerName":"new","kind":12,"name":"SUPER"},{"definition":"sub","detail":"($self,$rank)","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"_regex","name":"$self","line":137},{"name":"$rank","kind":13,"containerName":"_regex","line":137},{"line":138,"name":"$PATTERNS","containerName":"_regex","kind":13},{"containerName":"_regex","kind":13,"name":"$rank","line":138}],"name":"_regex","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$rank"}],"documentation":"","label":"_regex($self,$rank)"},"line":136,"range":{"end":{"line":139,"character":9999},"start":{"character":0,"line":136}},"kind":12},{"definition":"sub","detail":"($self,$cutoff)","children":[{"containerName":"cutoff","localvar":"my","kind":13,"name":"$self","line":142,"definition":"my"},{"line":142,"kind":13,"containerName":"cutoff","name":"$cutoff"},{"name":"$cutoff","kind":13,"containerName":"cutoff","line":143},{"line":144,"kind":13,"containerName":"cutoff","name":"$self"},{"containerName":"cutoff","kind":13,"name":"$cutoff","line":144},{"name":"$self","kind":13,"containerName":"cutoff","line":146},{"containerName":"cutoff","kind":13,"name":"$self","line":147},{"name":"$DEFAULT_CUTOFF","containerName":"cutoff","kind":13,"line":147},{"kind":13,"containerName":"cutoff","name":"$self","line":149}],"containerName":"main::","name":"cutoff","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$cutoff"}],"label":"cutoff($self,$cutoff)"},"line":141,"range":{"end":{"character":9999,"line":150},"start":{"character":0,"line":141}},"kind":12},{"children":[{"definition":"my","line":155,"localvar":"my","kind":13,"containerName":"_get_oligos","name":"$self"},{"definition":"my","line":157,"name":"@ranks","containerName":"_get_oligos","localvar":"my","kind":13},{"line":158,"containerName":"_get_oligos","kind":13,"name":"$self"},{"line":158,"containerName":"_get_oligos","kind":12,"name":"cutoff"},{"line":159,"name":"@ranks","kind":13,"containerName":"_get_oligos"},{"line":162,"kind":13,"containerName":"_get_oligos","name":"@ranks"},{"kind":13,"containerName":"_get_oligos","name":"$self","line":162},{"name":"cutoff","kind":12,"containerName":"_get_oligos","line":162},{"localvar":"my","kind":13,"containerName":"_get_oligos","name":"$rank","line":165,"definition":"my"},{"line":165,"name":"@ranks","kind":13,"containerName":"_get_oligos"},{"line":166,"name":"$regex","kind":13,"localvar":"my","containerName":"_get_oligos","definition":"my"},{"line":166,"containerName":"_get_oligos","kind":13,"name":"$self"},{"name":"_regex","kind":12,"containerName":"_get_oligos","line":166},{"name":"$rank","kind":13,"containerName":"_get_oligos","line":166},{"line":174,"localvar":"my","containerName":"_get_oligos","kind":13,"name":"$seq","definition":"my"},{"line":174,"containerName":"_get_oligos","kind":13,"name":"$targstart"},{"line":174,"name":"$self","kind":13,"containerName":"_get_oligos"},{"line":174,"containerName":"_get_oligos","kind":12,"name":"_get_targetregion"},{"line":176,"name":"$seq","kind":13,"containerName":"_get_oligos"},{"line":177,"kind":13,"localvar":"my","containerName":"_get_oligos","name":"$target","definition":"my"},{"name":"$target","kind":13,"containerName":"_get_oligos","line":180},{"line":181,"containerName":"_get_oligos","kind":13,"name":"$target"},{"kind":13,"containerName":"_get_oligos","name":"$target","line":183},{"definition":"my","name":"$start","localvar":"my","kind":13,"containerName":"_get_oligos","line":185},{"line":185,"name":"$targstart","containerName":"_get_oligos","kind":13},{"line":186,"name":"$stop","localvar":"my","kind":13,"containerName":"_get_oligos","definition":"my"},{"line":186,"containerName":"_get_oligos","kind":13,"name":"$start"},{"line":186,"kind":13,"containerName":"_get_oligos","name":"$target"},{"line":188,"kind":13,"localvar":"my","containerName":"_get_oligos","name":"@gc","definition":"my"},{"name":"$target","containerName":"_get_oligos","kind":13,"line":188},{"definition":"my","localvar":"my","containerName":"_get_oligos","kind":13,"name":"$fxGC","line":189},{"name":"@gc","containerName":"_get_oligos","kind":13,"line":189},{"name":"$target","kind":13,"containerName":"_get_oligos","line":189},{"line":190,"name":"$fxGC","containerName":"_get_oligos","kind":13},{"line":190,"name":"$self","containerName":"_get_oligos","kind":13},{"line":190,"name":"min_gc","kind":12,"containerName":"_get_oligos"},{"containerName":"_get_oligos","kind":13,"name":"$fxGC","line":191},{"containerName":"_get_oligos","kind":13,"name":"$self","line":191},{"name":"max_gc","kind":12,"containerName":"_get_oligos","line":191},{"line":193,"name":"$self","kind":13,"containerName":"_get_oligos"},{"line":193,"kind":12,"containerName":"_get_oligos","name":"add_oligos"},{"containerName":"_get_oligos","kind":13,"name":"$target","line":193},{"name":"$start","kind":13,"containerName":"_get_oligos","line":193},{"line":193,"kind":13,"containerName":"_get_oligos","name":"$rank"}],"containerName":"main::","name":"_get_oligos","definition":"sub","detail":"($self)","line":153,"kind":12,"range":{"end":{"character":9999,"line":196},"start":{"line":153,"character":0}},"signature":{"label":"_get_oligos($self)","parameters":[{"label":"$self"}],"documentation":""}},{"detail":"($self,$target)","definition":"sub","containerName":"main::","name":"_get_sense","children":[{"line":200,"containerName":"_get_sense","localvar":"my","kind":13,"name":"$self","definition":"my"},{"name":"$target","containerName":"_get_sense","kind":13,"line":200},{"line":202,"name":"$target","kind":13,"containerName":"_get_sense"},{"name":"$target","containerName":"_get_sense","kind":13,"line":204},{"line":206,"name":"$target","containerName":"_get_sense","kind":13},{"name":"$target","containerName":"_get_sense","kind":13,"line":208}],"signature":{"label":"_get_sense($self,$target)","documentation":"","parameters":[{"label":"$self"},{"label":"$target"}]},"kind":12,"range":{"start":{"character":0,"line":199},"end":{"line":209,"character":9999}},"line":199},{"signature":{"parameters":[{"label":"$self"},{"label":"$target"}],"documentation":"","label":"_get_anti($self,$target)"},"line":211,"kind":12,"range":{"end":{"line":228,"character":9999},"start":{"character":0,"line":211}},"definition":"sub","detail":"($self,$target)","children":[{"line":212,"name":"$self","containerName":"_get_anti","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"_get_anti","name":"$target","line":212},{"definition":"my","line":213,"kind":13,"localvar":"my","containerName":"_get_anti","name":"@target"},{"name":"$target","kind":13,"containerName":"_get_anti","line":213},{"line":214,"containerName":"_get_anti","localvar":"my","kind":13,"name":"$nt","definition":"my"},{"name":"@antitarget","kind":13,"containerName":"_get_anti","line":214},{"line":216,"containerName":"_get_anti","kind":13,"name":"$nt"},{"containerName":"_get_anti","kind":13,"name":"@target","line":216},{"line":217,"name":"@antitarget","containerName":"_get_anti","kind":13},{"line":217,"kind":13,"containerName":"_get_anti","name":"$self"},{"line":217,"name":"_comp","containerName":"_get_anti","kind":12},{"name":"$nt","kind":13,"containerName":"_get_anti","line":217},{"line":219,"name":"$anti","kind":13,"localvar":"my","containerName":"_get_anti","definition":"my"},{"line":219,"kind":13,"containerName":"_get_anti","name":"@antitarget"},{"line":221,"name":"$anti","kind":13,"containerName":"_get_anti"},{"line":223,"containerName":"_get_anti","kind":13,"name":"$anti"},{"name":"$anti","kind":13,"containerName":"_get_anti","line":225},{"containerName":"_get_anti","kind":13,"name":"$anti","line":227}],"name":"_get_anti","containerName":"main::"}],"version":5}