{"version":5,"vars":[{"name":"vars","containerName":"","kind":2,"line":134},{"line":142,"kind":2,"containerName":"","name":"base"},{"name":"%COMP","kind":13,"containerName":"main::","line":145,"definition":"our"},{"containerName":"main::","kind":13,"name":"@ARGNAMES","line":152,"definition":"our"},{"range":{"start":{"line":181,"character":0},"end":{"character":9999,"line":212}},"kind":12,"line":181,"signature":{"label":"new($proto,@args)","documentation":"1;\n# $Id: SiRNA.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::SiRNA\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nSiRNA - Perl object for designing small inhibitory RNAs.\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::SiRNA;\n\n  my $sirna_designer = Bio::Tools::SiRNA->new( -target => $bio_seq,\n                                               -rules  => 'saigo'\n    );\n  my @pairs = $sirna_designer->design;\n\n  foreach $pair (@pairs) {\n      my $sense_oligo_sequence = $pair->sense->seq;\n      my $antisense_oligo_sequence = $pair->antisense->seq;\n\n      # print out results\n      print join (\"\\t\", $pair->start, $pair->end, $pair->rank,\n                  $sense_oligo_sequence, $antisense_oligo_sequence), \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nPackage for designing siRNA reagents.\n\nInput is a L<Bio::SeqI>-compliant object (the target).\n\nOutput is a list of Bio::SeqFeature::SiRNA::Pair objects, which are\nadded to the feature table of the target sequence.  Each\nBio::SeqFeature::SiRNA::Pair contains two subfeatures\n(Bio::SeqFeature::Oligo objects) which correspond to the individual\noligos.  These objects provide accessors for the information on the\nindividual reagent pairs.\n\nThis verion of Bio::Tools::SiRNA represents a major change in architecture.\nSpecific 'rulesets' for siRNA selection as developed by various groups are\nimplemented as Bio::Tools::SiRNA::Ruleset objects, which inherit from\nBio::Tools::SiRNA.  This will make it easier to add new rule sets or modify\nexisting approaches. Currently the Tuschl and Ui-Tei (2004) rules are \nimplemented. For consistency, the Tuschl rules are implemented by default.\n\nIn addition, this module provides three 'extra' rules which can be added\nabove and beyond any ruleset.\n\n=over 3\n\n* 1.\n\nSiRNAs that overlap known SNPs (identified as SeqFeatures with \nprimary tag = variation) can be avoided.\n\n* 2.\n\nOther regions (with primary tag = 'Excluded') can also be skipped.  I\nuse this with Bio::Tools::Run::Mdust to avoid low-complexity regions\n(must be run separately), but other programs could also be used.\n\n* 3.\n\nSiRNAs may also be selected in the 3 prime UTR of a gene by setting\n$sirna_designer-E<gt>include_3pr() to true.\n\n\n=head2 EXPORT\n\nNone.\n\n=head1 SEE ALSO\n\nL<Bio::Tools::Run::Mdust>, L<Bio::SeqFeature::SiRNA::Pair>,\nL<Bio::SeqFeature::SiRNA::Oligo>..\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nDonald Jackson (donald.jackson@bms.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::SiRNA;\n\nuse strict;\nuse warnings;\n\nuse vars qw($AUTOLOAD);\n\nuse Bio::Seq::RichSeq;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::SiRNA::Oligo;\nuse Bio::SeqFeature::SiRNA::Pair;\n\n\nuse base qw(Bio::Root::Root);\n\n\nour %COMP = ( A => 'T',\n\t      T => 'A',\n\t      C => 'G',\n\t      G => 'C',\n\t      N => 'N',\n\t      );\n\nour @ARGNAMES = qw(RULES START_PAD END_PAD MIN_GC CUTOFF OLIGOS AVOID_SNPS\n\t\t   GSTRING TMPDIR TARGET DEBUG);\n\n\n=head2 new\n\n Title\t\t: new\n Usage\t\t: my $sirna_designer = Bio::Tools::SiRNA->new();\n Function\t: Constructor for designer object\n Returns\t: Bio::Tools::SiRNA object\n Args\t\t: target - the target sequence for the SiRNAs as a Bio::Seq::RichSeq\n                  start_pad - distance from the CDS start to skip (default 75)\n                  end_pad - distance from the CDS end to skip (default 50)\n                  include_3pr - set to true to include SiRNAs in the 3prime UTR (default false)\n                  rules - rules for selecting siRNAs, currently supporting saigo and tuschl\n                  min_gc - minimum GC fraction (NOT percent) (default 0.4)\n                  max_gc - maximum GC fraction (NOT percent) (default 0.6)\n                  cutoff - worst 'rank' accepted(default 3)\n                  avoid_snps - boolean - reject oligos that overlap a variation\n                     SeqFeature in the target (default true)\n                  gstring - maximum allowed consecutive Gs.\n                     Too many can cause problems in synthesis (default 4)\n  Note\t\t: All arguments can also be changed/accessed using autoloaded \n                 methods such as:\n\n    my $start_pad = $sirna_designer->start_pad().","parameters":[{"label":"$proto"},{"label":"@args"}]},"name":"new","containerName":"main::","children":[{"kind":13,"localvar":"my","containerName":"new","name":"$proto","line":182,"definition":"my"},{"line":182,"name":"@args","containerName":"new","kind":13},{"definition":"my","line":183,"name":"$pkg","kind":13,"localvar":"my","containerName":"new"},{"line":183,"name":"$proto","containerName":"new","kind":13},{"line":183,"containerName":"new","kind":13,"name":"$proto"},{"definition":"my","name":"$self","containerName":"new","localvar":"my","kind":13,"line":185},{"line":186,"kind":13,"containerName":"new","name":"$self"},{"name":"$pkg","kind":13,"containerName":"new","line":186},{"name":"%args","kind":13,"localvar":"my","containerName":"new","line":188,"definition":"my"},{"name":"@args","kind":13,"containerName":"new","line":190},{"containerName":"new","kind":13,"name":"@ARGNAMES","line":190},{"name":"$self","containerName":"new","kind":13,"line":190},{"kind":12,"containerName":"new","name":"_rearrange","line":190},{"name":"@ARGNAMES","containerName":"new","kind":13,"line":190},{"line":190,"kind":13,"containerName":"new","name":"@args"},{"containerName":"new","kind":13,"name":"$args","line":192},{"name":"$self","kind":13,"containerName":"new","line":193},{"line":193,"name":"rules","containerName":"new","kind":12},{"line":193,"kind":13,"containerName":"new","name":"$args"},{"name":"$self","containerName":"new","kind":13,"line":196},{"name":"$args","kind":13,"containerName":"new","line":196},{"line":197,"kind":13,"containerName":"new","name":"$self"},{"line":197,"containerName":"new","kind":13,"name":"$args"},{"line":198,"kind":13,"containerName":"new","name":"$self"},{"line":198,"name":"$args","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$self","line":199},{"line":199,"containerName":"new","kind":13,"name":"$args"},{"line":200,"kind":13,"containerName":"new","name":"$self"},{"name":"$args","containerName":"new","kind":13,"line":200},{"line":201,"name":"$self","kind":13,"containerName":"new"},{"line":201,"name":"$args","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$self","line":202},{"line":203,"containerName":"new","kind":13,"name":"$args"},{"line":203,"containerName":"new","kind":13,"name":"$self"},{"containerName":"new","kind":13,"name":"$args","line":203},{"line":204,"name":"$self","kind":13,"containerName":"new"},{"line":205,"name":"$self","kind":13,"containerName":"new"},{"line":205,"kind":13,"containerName":"new","name":"$args"},{"kind":13,"containerName":"new","name":"$self","line":206},{"line":206,"containerName":"new","kind":13,"name":"$args"},{"containerName":"new","kind":13,"name":"$ENV","line":206},{"line":206,"kind":13,"containerName":"new","name":"$ENV"},{"line":207,"name":"$self","kind":13,"containerName":"new"},{"line":207,"containerName":"new","kind":13,"name":"$args"},{"kind":13,"containerName":"new","name":"$self","line":209},{"line":209,"name":"target","containerName":"new","kind":12},{"line":209,"kind":13,"containerName":"new","name":"$args"},{"containerName":"new","kind":13,"name":"$args","line":209},{"kind":13,"containerName":"new","name":"$self","line":211}],"detail":"($proto,@args)","definition":"sub"},{"line":227,"range":{"start":{"character":0,"line":227},"end":{"character":9999,"line":258}},"kind":12,"signature":{"label":"target($self,$target)","documentation":"1;\n# $Id: SiRNA.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::SiRNA\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nSiRNA - Perl object for designing small inhibitory RNAs.\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::SiRNA;\n\n  my $sirna_designer = Bio::Tools::SiRNA->new( -target => $bio_seq,\n                                               -rules  => 'saigo'\n    );\n  my @pairs = $sirna_designer->design;\n\n  foreach $pair (@pairs) {\n      my $sense_oligo_sequence = $pair->sense->seq;\n      my $antisense_oligo_sequence = $pair->antisense->seq;\n\n      # print out results\n      print join (\"\\t\", $pair->start, $pair->end, $pair->rank,\n                  $sense_oligo_sequence, $antisense_oligo_sequence), \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nPackage for designing siRNA reagents.\n\nInput is a L<Bio::SeqI>-compliant object (the target).\n\nOutput is a list of Bio::SeqFeature::SiRNA::Pair objects, which are\nadded to the feature table of the target sequence.  Each\nBio::SeqFeature::SiRNA::Pair contains two subfeatures\n(Bio::SeqFeature::Oligo objects) which correspond to the individual\noligos.  These objects provide accessors for the information on the\nindividual reagent pairs.\n\nThis verion of Bio::Tools::SiRNA represents a major change in architecture.\nSpecific 'rulesets' for siRNA selection as developed by various groups are\nimplemented as Bio::Tools::SiRNA::Ruleset objects, which inherit from\nBio::Tools::SiRNA.  This will make it easier to add new rule sets or modify\nexisting approaches. Currently the Tuschl and Ui-Tei (2004) rules are \nimplemented. For consistency, the Tuschl rules are implemented by default.\n\nIn addition, this module provides three 'extra' rules which can be added\nabove and beyond any ruleset.\n\n=over 3\n\n* 1.\n\nSiRNAs that overlap known SNPs (identified as SeqFeatures with \nprimary tag = variation) can be avoided.\n\n* 2.\n\nOther regions (with primary tag = 'Excluded') can also be skipped.  I\nuse this with Bio::Tools::Run::Mdust to avoid low-complexity regions\n(must be run separately), but other programs could also be used.\n\n* 3.\n\nSiRNAs may also be selected in the 3 prime UTR of a gene by setting\n$sirna_designer-E<gt>include_3pr() to true.\n\n\n=head2 EXPORT\n\nNone.\n\n=head1 SEE ALSO\n\nL<Bio::Tools::Run::Mdust>, L<Bio::SeqFeature::SiRNA::Pair>,\nL<Bio::SeqFeature::SiRNA::Oligo>..\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nDonald Jackson (donald.jackson@bms.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::SiRNA;\n\nuse strict;\nuse warnings;\n\nuse vars qw($AUTOLOAD);\n\nuse Bio::Seq::RichSeq;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::SiRNA::Oligo;\nuse Bio::SeqFeature::SiRNA::Pair;\n\n\nuse base qw(Bio::Root::Root);\n\n\nour %COMP = ( A => 'T',\n\t      T => 'A',\n\t      C => 'G',\n\t      G => 'C',\n\t      N => 'N',\n\t      );\n\nour @ARGNAMES = qw(RULES START_PAD END_PAD MIN_GC CUTOFF OLIGOS AVOID_SNPS\n\t\t   GSTRING TMPDIR TARGET DEBUG);\n\n\n=head2 new\n\n Title\t\t: new\n Usage\t\t: my $sirna_designer = Bio::Tools::SiRNA->new();\n Function\t: Constructor for designer object\n Returns\t: Bio::Tools::SiRNA object\n Args\t\t: target - the target sequence for the SiRNAs as a Bio::Seq::RichSeq\n                  start_pad - distance from the CDS start to skip (default 75)\n                  end_pad - distance from the CDS end to skip (default 50)\n                  include_3pr - set to true to include SiRNAs in the 3prime UTR (default false)\n                  rules - rules for selecting siRNAs, currently supporting saigo and tuschl\n                  min_gc - minimum GC fraction (NOT percent) (default 0.4)\n                  max_gc - maximum GC fraction (NOT percent) (default 0.6)\n                  cutoff - worst 'rank' accepted(default 3)\n                  avoid_snps - boolean - reject oligos that overlap a variation\n                     SeqFeature in the target (default true)\n                  gstring - maximum allowed consecutive Gs.\n                     Too many can cause problems in synthesis (default 4)\n  Note\t\t: All arguments can also be changed/accessed using autoloaded \n                 methods such as:\n\n    my $start_pad = $sirna_designer->start_pad().\n\n\nsub new {\n    my ($proto, @args) = @_;\n    my $pkg = ref($proto) || $proto;\n\n    my $self = {};\n    bless ($self, $pkg);\n\n    my %args;\n\n    @args{@ARGNAMES} = $self->_rearrange(\\@ARGNAMES, @args); \n    \n    if ($args{'RULES'}) {\n\t$self->rules($args{'RULES'});\n    }\n\n    $self->{'start_pad'} = $args{'START_PAD'} || 75; # nt from start to mask\n    $self->{'end_pad'} = $args{'END_PAD'} || 50; # nt from end to mask\n    $self->{'include_3pr'} = $args{'INCLUDE_3PR'} || 0; # look for oligos in 3prime UTR\n    $self->{'min_gc'} = $args{'MIN_GC'} || 0.40;\n    $self->{'max_gc'} = $args{'MAX_GC'} || 0.60;\n    $self->{'cutoff'} = $args{'CUTOFF'} || 3; # highest (worst) rank wanted\n    $self->{'oligos'} = [];\n    defined($args{'AVOID_SNPS'}) ? $self->{'avoid_snps'} = $args{'AVOID_SNPS'} :  \n\t$self->{'avoid_snps'} = 1; # (t/f to avoid or include reagents that cover SNPs)\n    $self->{'gstring'} = $args{'GSTRING'} || 4; # maximum allowed consecutive Gs - too many can cause problems in oligo synthesis\n    $self->{'tmpdir'} = $args{'TMPDIR'}  || $ENV{'TMPDIR'} || $ENV{'TMP'} || '';\n    $self->{'debug'} = $args{'DEBUG'} || 0;\n\n    $self->target($args{'TARGET'}) if ($args{'TARGET'});\n\n    return $self;\n}\n\n\n=head2 target \n\n  Title\t\t: target\n  Usage\t\t: my $target_seq = $sirna_designer->target(); # get the current target\n                  OR \n                  $sirna_designer->target($new_target_seq); # set a new target \n  Function\t: Set/get the target as a Bio::SeqI-compliant object\n  Returns\t: a Bio::SeqI-compliant object\n  Args\t\t: a Bio::SeqI-compliant object (optional)","parameters":[{"label":"$self"},{"label":"$target"}]},"children":[{"definition":"my","localvar":"my","containerName":"target","kind":13,"name":"$self","line":228},{"line":228,"name":"$target","containerName":"target","kind":13},{"containerName":"target","kind":13,"name":"$target","line":230},{"line":231,"name":"$target","kind":13,"containerName":"target"},{"kind":12,"containerName":"target","name":"isa","line":231},{"line":232,"kind":13,"containerName":"target","name":"$self"},{"name":"throw","kind":12,"containerName":"target","line":232},{"line":235,"kind":13,"containerName":"target","name":"$target"},{"line":235,"name":"can","kind":12,"containerName":"target"},{"line":236,"containerName":"target","kind":13,"name":"$target"},{"line":236,"containerName":"target","kind":12,"name":"molecule"},{"containerName":"target","kind":13,"name":"$self","line":237},{"name":"throw","kind":12,"containerName":"target","line":237},{"kind":13,"containerName":"target","name":"$target","line":238},{"line":238,"name":"molecule","kind":12,"containerName":"target"},{"line":242,"name":"$target","kind":13,"containerName":"target"},{"name":"alphabet","kind":12,"containerName":"target","line":242},{"name":"$self","kind":13,"containerName":"target","line":243},{"line":243,"containerName":"target","kind":12,"name":"throw"},{"name":"$target","containerName":"target","kind":13,"line":244},{"name":"alphabet","kind":12,"containerName":"target","line":244},{"line":248,"name":"$self","containerName":"target","kind":13},{"name":"$target","kind":13,"containerName":"target","line":248},{"containerName":"target","kind":13,"name":"$self","line":252},{"line":253,"name":"$self","kind":13,"containerName":"target"},{"line":256,"containerName":"target","kind":13,"name":"$self"},{"kind":12,"containerName":"target","name":"throw","line":256}],"name":"target","containerName":"main::","definition":"sub","detail":"($self,$target)"},{"line":271,"kind":12,"range":{"start":{"character":0,"line":271},"end":{"character":9999,"line":282}},"signature":{"label":"rules($self,$rules)","documentation":"1;\n# $Id: SiRNA.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::SiRNA\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nSiRNA - Perl object for designing small inhibitory RNAs.\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::SiRNA;\n\n  my $sirna_designer = Bio::Tools::SiRNA->new( -target => $bio_seq,\n                                               -rules  => 'saigo'\n    );\n  my @pairs = $sirna_designer->design;\n\n  foreach $pair (@pairs) {\n      my $sense_oligo_sequence = $pair->sense->seq;\n      my $antisense_oligo_sequence = $pair->antisense->seq;\n\n      # print out results\n      print join (\"\\t\", $pair->start, $pair->end, $pair->rank,\n                  $sense_oligo_sequence, $antisense_oligo_sequence), \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nPackage for designing siRNA reagents.\n\nInput is a L<Bio::SeqI>-compliant object (the target).\n\nOutput is a list of Bio::SeqFeature::SiRNA::Pair objects, which are\nadded to the feature table of the target sequence.  Each\nBio::SeqFeature::SiRNA::Pair contains two subfeatures\n(Bio::SeqFeature::Oligo objects) which correspond to the individual\noligos.  These objects provide accessors for the information on the\nindividual reagent pairs.\n\nThis verion of Bio::Tools::SiRNA represents a major change in architecture.\nSpecific 'rulesets' for siRNA selection as developed by various groups are\nimplemented as Bio::Tools::SiRNA::Ruleset objects, which inherit from\nBio::Tools::SiRNA.  This will make it easier to add new rule sets or modify\nexisting approaches. Currently the Tuschl and Ui-Tei (2004) rules are \nimplemented. For consistency, the Tuschl rules are implemented by default.\n\nIn addition, this module provides three 'extra' rules which can be added\nabove and beyond any ruleset.\n\n=over 3\n\n* 1.\n\nSiRNAs that overlap known SNPs (identified as SeqFeatures with \nprimary tag = variation) can be avoided.\n\n* 2.\n\nOther regions (with primary tag = 'Excluded') can also be skipped.  I\nuse this with Bio::Tools::Run::Mdust to avoid low-complexity regions\n(must be run separately), but other programs could also be used.\n\n* 3.\n\nSiRNAs may also be selected in the 3 prime UTR of a gene by setting\n$sirna_designer-E<gt>include_3pr() to true.\n\n\n=head2 EXPORT\n\nNone.\n\n=head1 SEE ALSO\n\nL<Bio::Tools::Run::Mdust>, L<Bio::SeqFeature::SiRNA::Pair>,\nL<Bio::SeqFeature::SiRNA::Oligo>..\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nDonald Jackson (donald.jackson@bms.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::SiRNA;\n\nuse strict;\nuse warnings;\n\nuse vars qw($AUTOLOAD);\n\nuse Bio::Seq::RichSeq;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::SiRNA::Oligo;\nuse Bio::SeqFeature::SiRNA::Pair;\n\n\nuse base qw(Bio::Root::Root);\n\n\nour %COMP = ( A => 'T',\n\t      T => 'A',\n\t      C => 'G',\n\t      G => 'C',\n\t      N => 'N',\n\t      );\n\nour @ARGNAMES = qw(RULES START_PAD END_PAD MIN_GC CUTOFF OLIGOS AVOID_SNPS\n\t\t   GSTRING TMPDIR TARGET DEBUG);\n\n\n=head2 new\n\n Title\t\t: new\n Usage\t\t: my $sirna_designer = Bio::Tools::SiRNA->new();\n Function\t: Constructor for designer object\n Returns\t: Bio::Tools::SiRNA object\n Args\t\t: target - the target sequence for the SiRNAs as a Bio::Seq::RichSeq\n                  start_pad - distance from the CDS start to skip (default 75)\n                  end_pad - distance from the CDS end to skip (default 50)\n                  include_3pr - set to true to include SiRNAs in the 3prime UTR (default false)\n                  rules - rules for selecting siRNAs, currently supporting saigo and tuschl\n                  min_gc - minimum GC fraction (NOT percent) (default 0.4)\n                  max_gc - maximum GC fraction (NOT percent) (default 0.6)\n                  cutoff - worst 'rank' accepted(default 3)\n                  avoid_snps - boolean - reject oligos that overlap a variation\n                     SeqFeature in the target (default true)\n                  gstring - maximum allowed consecutive Gs.\n                     Too many can cause problems in synthesis (default 4)\n  Note\t\t: All arguments can also be changed/accessed using autoloaded \n                 methods such as:\n\n    my $start_pad = $sirna_designer->start_pad().\n\n\nsub new {\n    my ($proto, @args) = @_;\n    my $pkg = ref($proto) || $proto;\n\n    my $self = {};\n    bless ($self, $pkg);\n\n    my %args;\n\n    @args{@ARGNAMES} = $self->_rearrange(\\@ARGNAMES, @args); \n    \n    if ($args{'RULES'}) {\n\t$self->rules($args{'RULES'});\n    }\n\n    $self->{'start_pad'} = $args{'START_PAD'} || 75; # nt from start to mask\n    $self->{'end_pad'} = $args{'END_PAD'} || 50; # nt from end to mask\n    $self->{'include_3pr'} = $args{'INCLUDE_3PR'} || 0; # look for oligos in 3prime UTR\n    $self->{'min_gc'} = $args{'MIN_GC'} || 0.40;\n    $self->{'max_gc'} = $args{'MAX_GC'} || 0.60;\n    $self->{'cutoff'} = $args{'CUTOFF'} || 3; # highest (worst) rank wanted\n    $self->{'oligos'} = [];\n    defined($args{'AVOID_SNPS'}) ? $self->{'avoid_snps'} = $args{'AVOID_SNPS'} :  \n\t$self->{'avoid_snps'} = 1; # (t/f to avoid or include reagents that cover SNPs)\n    $self->{'gstring'} = $args{'GSTRING'} || 4; # maximum allowed consecutive Gs - too many can cause problems in oligo synthesis\n    $self->{'tmpdir'} = $args{'TMPDIR'}  || $ENV{'TMPDIR'} || $ENV{'TMP'} || '';\n    $self->{'debug'} = $args{'DEBUG'} || 0;\n\n    $self->target($args{'TARGET'}) if ($args{'TARGET'});\n\n    return $self;\n}\n\n\n=head2 target \n\n  Title\t\t: target\n  Usage\t\t: my $target_seq = $sirna_designer->target(); # get the current target\n                  OR \n                  $sirna_designer->target($new_target_seq); # set a new target \n  Function\t: Set/get the target as a Bio::SeqI-compliant object\n  Returns\t: a Bio::SeqI-compliant object\n  Args\t\t: a Bio::SeqI-compliant object (optional)\n\n\nsub target {\n    my ($self, $target) = @_;\n\n    if ($target) {\n\tunless ($target->isa('Bio::SeqI')) {\n\t    $self->throw(  -class => 'Bio::Root::BadParameter',\n\t\t\t   -text  => \"Target must be passed as a Bio::Seq object\" );\n\t}\n\tif ($target->can('molecule')) {\n\t    ( grep { uc($target->molecule) eq $_ } qw(DNA MRNA CDNA)) or\n\t\t$self->throw(  -class => 'Bio::Root::BadParameter',\n\t\t\t       -text  =>  \"Sequences of type \". $target->molecule. \" are not supported\"\n\t\t\t       );\n\t}\n\telse {\n\t    ($target->alphabet eq 'dna') or \n\t\t$self->throw(  -class => 'Bio::Root::BadParameter',\n\t\t\t       -text  =>  \"Sequences of alphabet \". $target->alphabet. \" are not supported\"\n\t\t\t       );\n\t}\n\t\n\t$self->{'target'} = $target;\n\treturn 1;\n\n    }\n    elsif ($self->{'target'}) {\n\treturn $self->{'target'};\n    }\n    else {\n\t$self->throw(\"Target sequence not defined\");\n    }\n}\n\n=head2 rules\n\n    Title\t: rules\n    Usage\t: $sirna->rules('ruleset')\n    Purpose\t: set/get ruleset to use for selecting SiRNA oligo pairs.\n    Returns\t: not sure yet\n    Args\t: a ruleset name (currently supported: Tuschl, Saigo)\n                  or a Bio::Tools::SiRNA::RulesetI compliant object","parameters":[{"label":"$self"},{"label":"$rules"}]},"children":[{"line":272,"localvar":"my","kind":13,"containerName":"rules","name":"$self","definition":"my"},{"line":272,"kind":13,"containerName":"rules","name":"$rules"},{"line":274,"name":"$rules","kind":13,"containerName":"rules"},{"containerName":"rules","kind":13,"name":"$self","line":275},{"line":275,"name":"_load_ruleset","containerName":"rules","kind":12},{"containerName":"rules","kind":13,"name":"$rules","line":275},{"line":278,"kind":13,"containerName":"rules","name":"$self"},{"name":"$self","kind":13,"containerName":"rules","line":279},{"name":"_load_ruleset","containerName":"rules","kind":12,"line":279},{"line":281,"name":"$self","containerName":"rules","kind":13}],"containerName":"main::","name":"rules","definition":"sub","detail":"($self,$rules)"},{"name":"_rules","kind":12,"line":278},{"name":"_rules","kind":12,"line":281},{"definition":"sub","detail":"($self,$ruleset)","children":[{"line":285,"name":"$self","kind":13,"localvar":"my","containerName":"_load_ruleset","definition":"my"},{"line":285,"kind":13,"containerName":"_load_ruleset","name":"$ruleset"},{"definition":"my","localvar":"my","containerName":"_load_ruleset","kind":13,"name":"$rule_module","line":287},{"kind":13,"containerName":"_load_ruleset","name":"$self","line":287},{"line":287,"containerName":"_load_ruleset","kind":13,"name":"$ruleset"},{"name":"$self","containerName":"_load_ruleset","kind":13,"line":293},{"line":293,"name":"throw","containerName":"_load_ruleset","kind":12},{"line":298,"name":"$self","kind":13,"containerName":"_load_ruleset"},{"name":"$rule_module","containerName":"_load_ruleset","kind":13,"line":298},{"name":"$self","containerName":"_load_ruleset","kind":13,"line":299},{"line":299,"name":"$rule_module","kind":13,"containerName":"_load_ruleset"}],"containerName":"main::","name":"_load_ruleset","signature":{"label":"_load_ruleset($self,$ruleset)","parameters":[{"label":"$self"},{"label":"$ruleset"}],"documentation":""},"line":284,"range":{"start":{"line":284,"character":0},"end":{"character":9999,"line":303}},"kind":12},{"line":298,"kind":12,"name":"_rules"},{"children":[{"line":316,"containerName":"design","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":318,"containerName":"design","kind":13,"name":"$self"},{"name":"rules","containerName":"design","kind":12,"line":318},{"kind":13,"containerName":"design","name":"$self","line":318},{"line":318,"name":"throw","kind":12,"containerName":"design"},{"definition":"my","line":324,"name":"@oligos","localvar":"my","kind":13,"containerName":"design"},{"name":"$self","kind":13,"containerName":"design","line":324},{"line":324,"name":"_get_oligos","containerName":"design","kind":12},{"name":"isa","containerName":"design","kind":12,"line":326},{"line":326,"name":"$self","containerName":"design","kind":13},{"name":"target","containerName":"design","kind":12,"line":326},{"line":326,"name":"top_SeqFeatures","containerName":"design","kind":12}],"containerName":"main::","name":"design","definition":"sub","detail":"($self)","line":315,"kind":12,"range":{"start":{"character":0,"line":315},"end":{"character":9999,"line":327}},"signature":{"documentation":"1;\n# $Id: SiRNA.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::SiRNA\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nSiRNA - Perl object for designing small inhibitory RNAs.\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::SiRNA;\n\n  my $sirna_designer = Bio::Tools::SiRNA->new( -target => $bio_seq,\n                                               -rules  => 'saigo'\n    );\n  my @pairs = $sirna_designer->design;\n\n  foreach $pair (@pairs) {\n      my $sense_oligo_sequence = $pair->sense->seq;\n      my $antisense_oligo_sequence = $pair->antisense->seq;\n\n      # print out results\n      print join (\"\\t\", $pair->start, $pair->end, $pair->rank,\n                  $sense_oligo_sequence, $antisense_oligo_sequence), \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nPackage for designing siRNA reagents.\n\nInput is a L<Bio::SeqI>-compliant object (the target).\n\nOutput is a list of Bio::SeqFeature::SiRNA::Pair objects, which are\nadded to the feature table of the target sequence.  Each\nBio::SeqFeature::SiRNA::Pair contains two subfeatures\n(Bio::SeqFeature::Oligo objects) which correspond to the individual\noligos.  These objects provide accessors for the information on the\nindividual reagent pairs.\n\nThis verion of Bio::Tools::SiRNA represents a major change in architecture.\nSpecific 'rulesets' for siRNA selection as developed by various groups are\nimplemented as Bio::Tools::SiRNA::Ruleset objects, which inherit from\nBio::Tools::SiRNA.  This will make it easier to add new rule sets or modify\nexisting approaches. Currently the Tuschl and Ui-Tei (2004) rules are \nimplemented. For consistency, the Tuschl rules are implemented by default.\n\nIn addition, this module provides three 'extra' rules which can be added\nabove and beyond any ruleset.\n\n=over 3\n\n* 1.\n\nSiRNAs that overlap known SNPs (identified as SeqFeatures with \nprimary tag = variation) can be avoided.\n\n* 2.\n\nOther regions (with primary tag = 'Excluded') can also be skipped.  I\nuse this with Bio::Tools::Run::Mdust to avoid low-complexity regions\n(must be run separately), but other programs could also be used.\n\n* 3.\n\nSiRNAs may also be selected in the 3 prime UTR of a gene by setting\n$sirna_designer-E<gt>include_3pr() to true.\n\n\n=head2 EXPORT\n\nNone.\n\n=head1 SEE ALSO\n\nL<Bio::Tools::Run::Mdust>, L<Bio::SeqFeature::SiRNA::Pair>,\nL<Bio::SeqFeature::SiRNA::Oligo>..\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nDonald Jackson (donald.jackson@bms.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::SiRNA;\n\nuse strict;\nuse warnings;\n\nuse vars qw($AUTOLOAD);\n\nuse Bio::Seq::RichSeq;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::SiRNA::Oligo;\nuse Bio::SeqFeature::SiRNA::Pair;\n\n\nuse base qw(Bio::Root::Root);\n\n\nour %COMP = ( A => 'T',\n\t      T => 'A',\n\t      C => 'G',\n\t      G => 'C',\n\t      N => 'N',\n\t      );\n\nour @ARGNAMES = qw(RULES START_PAD END_PAD MIN_GC CUTOFF OLIGOS AVOID_SNPS\n\t\t   GSTRING TMPDIR TARGET DEBUG);\n\n\n=head2 new\n\n Title\t\t: new\n Usage\t\t: my $sirna_designer = Bio::Tools::SiRNA->new();\n Function\t: Constructor for designer object\n Returns\t: Bio::Tools::SiRNA object\n Args\t\t: target - the target sequence for the SiRNAs as a Bio::Seq::RichSeq\n                  start_pad - distance from the CDS start to skip (default 75)\n                  end_pad - distance from the CDS end to skip (default 50)\n                  include_3pr - set to true to include SiRNAs in the 3prime UTR (default false)\n                  rules - rules for selecting siRNAs, currently supporting saigo and tuschl\n                  min_gc - minimum GC fraction (NOT percent) (default 0.4)\n                  max_gc - maximum GC fraction (NOT percent) (default 0.6)\n                  cutoff - worst 'rank' accepted(default 3)\n                  avoid_snps - boolean - reject oligos that overlap a variation\n                     SeqFeature in the target (default true)\n                  gstring - maximum allowed consecutive Gs.\n                     Too many can cause problems in synthesis (default 4)\n  Note\t\t: All arguments can also be changed/accessed using autoloaded \n                 methods such as:\n\n    my $start_pad = $sirna_designer->start_pad().\n\n\nsub new {\n    my ($proto, @args) = @_;\n    my $pkg = ref($proto) || $proto;\n\n    my $self = {};\n    bless ($self, $pkg);\n\n    my %args;\n\n    @args{@ARGNAMES} = $self->_rearrange(\\@ARGNAMES, @args); \n    \n    if ($args{'RULES'}) {\n\t$self->rules($args{'RULES'});\n    }\n\n    $self->{'start_pad'} = $args{'START_PAD'} || 75; # nt from start to mask\n    $self->{'end_pad'} = $args{'END_PAD'} || 50; # nt from end to mask\n    $self->{'include_3pr'} = $args{'INCLUDE_3PR'} || 0; # look for oligos in 3prime UTR\n    $self->{'min_gc'} = $args{'MIN_GC'} || 0.40;\n    $self->{'max_gc'} = $args{'MAX_GC'} || 0.60;\n    $self->{'cutoff'} = $args{'CUTOFF'} || 3; # highest (worst) rank wanted\n    $self->{'oligos'} = [];\n    defined($args{'AVOID_SNPS'}) ? $self->{'avoid_snps'} = $args{'AVOID_SNPS'} :  \n\t$self->{'avoid_snps'} = 1; # (t/f to avoid or include reagents that cover SNPs)\n    $self->{'gstring'} = $args{'GSTRING'} || 4; # maximum allowed consecutive Gs - too many can cause problems in oligo synthesis\n    $self->{'tmpdir'} = $args{'TMPDIR'}  || $ENV{'TMPDIR'} || $ENV{'TMP'} || '';\n    $self->{'debug'} = $args{'DEBUG'} || 0;\n\n    $self->target($args{'TARGET'}) if ($args{'TARGET'});\n\n    return $self;\n}\n\n\n=head2 target \n\n  Title\t\t: target\n  Usage\t\t: my $target_seq = $sirna_designer->target(); # get the current target\n                  OR \n                  $sirna_designer->target($new_target_seq); # set a new target \n  Function\t: Set/get the target as a Bio::SeqI-compliant object\n  Returns\t: a Bio::SeqI-compliant object\n  Args\t\t: a Bio::SeqI-compliant object (optional)\n\n\nsub target {\n    my ($self, $target) = @_;\n\n    if ($target) {\n\tunless ($target->isa('Bio::SeqI')) {\n\t    $self->throw(  -class => 'Bio::Root::BadParameter',\n\t\t\t   -text  => \"Target must be passed as a Bio::Seq object\" );\n\t}\n\tif ($target->can('molecule')) {\n\t    ( grep { uc($target->molecule) eq $_ } qw(DNA MRNA CDNA)) or\n\t\t$self->throw(  -class => 'Bio::Root::BadParameter',\n\t\t\t       -text  =>  \"Sequences of type \". $target->molecule. \" are not supported\"\n\t\t\t       );\n\t}\n\telse {\n\t    ($target->alphabet eq 'dna') or \n\t\t$self->throw(  -class => 'Bio::Root::BadParameter',\n\t\t\t       -text  =>  \"Sequences of alphabet \". $target->alphabet. \" are not supported\"\n\t\t\t       );\n\t}\n\t\n\t$self->{'target'} = $target;\n\treturn 1;\n\n    }\n    elsif ($self->{'target'}) {\n\treturn $self->{'target'};\n    }\n    else {\n\t$self->throw(\"Target sequence not defined\");\n    }\n}\n\n=head2 rules\n\n    Title\t: rules\n    Usage\t: $sirna->rules('ruleset')\n    Purpose\t: set/get ruleset to use for selecting SiRNA oligo pairs.\n    Returns\t: not sure yet\n    Args\t: a ruleset name (currently supported: Tuschl, Saigo)\n                  or a Bio::Tools::SiRNA::RulesetI compliant object\n\n\nsub rules {\n    my ($self, $rules) = @_;\n\n    if ($rules) {\n\t$self->_load_ruleset($rules);\n    }\n    # default: use tuschl rules\n    unless ($self->{_rules}) {\n\t$self->_load_ruleset('tuschl');\n    }\n    return $self->{_rules};\n}\n\nsub _load_ruleset {\n    my ($self, $ruleset) = @_;\n\n    my $rule_module = join('::', ref($self), 'Ruleset', lc($ruleset));\n\n    eval \"require $rule_module\";\n    \n    if ($@) {\n\t#warn join(\"\\n\", '@INC contains:', @INC, undef);\n\t$self->throw(\"Unable to load $rule_module: $@\");\n\treturn;\n    }\n\n    else {\n\t$self->{_rules} = $rule_module;\n\tbless($self, $rule_module); # recast as subclass\n    }\n\t\n    return 1;\n}\n\n=head2 design\n\n  Title\t\t: design\n  Usage\t\t: my @pairs = $sirna_designer->design();\n  Purpose\t: Design SiRNA oligo pairs.  \n  Returns\t: A list of SiRNA pairs as Bio::SeqFeature::SiRNA::Pair objects\n  Args\t\t: none","parameters":[{"label":"$self"}],"label":"design($self)"}},{"definition":"sub","detail":"($self)","children":[{"definition":"my","localvar":"my","containerName":"_define_target","kind":13,"name":"$self","line":330},{"line":331,"kind":13,"localvar":"my","containerName":"_define_target","name":"$feat","definition":"my"},{"containerName":"_define_target","kind":13,"name":"$cds","line":331},{"line":331,"name":"$left","kind":13,"containerName":"_define_target"},{"kind":13,"containerName":"_define_target","name":"$right","line":331},{"definition":"my","line":333,"localvar":"my","kind":13,"containerName":"_define_target","name":"$target"},{"name":"$self","containerName":"_define_target","kind":13,"line":333},{"line":333,"name":"target","kind":12,"containerName":"_define_target"},{"line":334,"name":"$self","kind":13,"containerName":"_define_target"},{"name":"throw","kind":12,"containerName":"_define_target","line":334},{"line":336,"containerName":"_define_target","kind":13,"name":"$cds"},{"name":"primary_tag","containerName":"_define_target","kind":12,"line":336},{"line":336,"kind":13,"containerName":"_define_target","name":"$target"},{"line":336,"name":"top_SeqFeatures","containerName":"_define_target","kind":12},{"line":336,"containerName":"_define_target","kind":13,"name":"$target"},{"line":336,"containerName":"_define_target","kind":12,"name":"can"},{"containerName":"_define_target","kind":13,"name":"$cds","line":338},{"name":"$left","containerName":"_define_target","kind":13,"line":339},{"name":"$cds","containerName":"_define_target","kind":13,"line":339},{"line":339,"kind":12,"containerName":"_define_target","name":"start"},{"line":339,"name":"$self","containerName":"_define_target","kind":13},{"line":339,"containerName":"_define_target","kind":12,"name":"start_pad"},{"line":340,"name":"$self","kind":13,"containerName":"_define_target"},{"line":340,"containerName":"_define_target","kind":12,"name":"include_3pr"},{"line":341,"containerName":"_define_target","kind":13,"name":"$right"},{"line":341,"name":"$cds","kind":13,"containerName":"_define_target"},{"line":341,"kind":12,"containerName":"_define_target","name":"end"},{"line":341,"kind":13,"containerName":"_define_target","name":"$self"},{"name":"end_pad","kind":12,"containerName":"_define_target","line":341},{"line":344,"containerName":"_define_target","kind":13,"name":"$right"},{"line":344,"containerName":"_define_target","kind":13,"name":"$target"},{"name":"length","kind":12,"containerName":"_define_target","line":344},{"line":344,"kind":13,"containerName":"_define_target","name":"$self"},{"containerName":"_define_target","kind":12,"name":"end_pad","line":344},{"line":348,"name":"$left","containerName":"_define_target","kind":13},{"line":348,"containerName":"_define_target","kind":13,"name":"$self"},{"line":348,"name":"start_pad","containerName":"_define_target","kind":12},{"line":349,"name":"$right","containerName":"_define_target","kind":13},{"line":349,"name":"$target","kind":13,"containerName":"_define_target"},{"name":"length","containerName":"_define_target","kind":12,"line":349},{"name":"$self","kind":13,"containerName":"_define_target","line":349},{"line":349,"name":"end_pad","containerName":"_define_target","kind":12},{"name":"$right","containerName":"_define_target","kind":13,"line":354},{"line":354,"kind":13,"containerName":"_define_target","name":"$left"},{"line":355,"name":"$self","kind":13,"containerName":"_define_target"},{"name":"throw","kind":12,"containerName":"_define_target","line":355},{"line":358,"localvar":"my","kind":13,"containerName":"_define_target","name":"$targregion","definition":"my"},{"containerName":"_define_target","kind":12,"name":"new","line":358},{"kind":13,"containerName":"_define_target","name":"$left","line":358},{"line":359,"kind":13,"containerName":"_define_target","name":"$right"},{"kind":13,"containerName":"_define_target","name":"$self","line":361},{"line":361,"kind":12,"containerName":"_define_target","name":"target"},{"line":361,"containerName":"_define_target","kind":12,"name":"add_SeqFeature"},{"name":"$targregion","containerName":"_define_target","kind":13,"line":361},{"containerName":"_define_target","localvar":"my","kind":13,"name":"@excluded","line":364,"definition":"my"},{"line":364,"containerName":"_define_target","kind":12,"name":"primary_tag"},{"name":"$self","kind":13,"containerName":"_define_target","line":364},{"line":364,"name":"target","kind":12,"containerName":"_define_target"},{"line":364,"containerName":"_define_target","kind":12,"name":"top_SeqFeatures"},{"line":366,"name":"$self","kind":13,"containerName":"_define_target"},{"line":366,"name":"avoid_snps","kind":12,"containerName":"_define_target"},{"definition":"my","line":367,"localvar":"my","kind":13,"containerName":"_define_target","name":"@snps"},{"line":367,"kind":12,"containerName":"_define_target","name":"primary_tag"},{"kind":13,"containerName":"_define_target","name":"$self","line":367},{"line":367,"kind":12,"containerName":"_define_target","name":"target"},{"line":367,"containerName":"_define_target","kind":12,"name":"top_SeqFeatures"},{"containerName":"_define_target","kind":13,"name":"@excluded","line":368},{"name":"@snps","kind":13,"containerName":"_define_target","line":368},{"kind":13,"containerName":"_define_target","name":"$self","line":371},{"line":371,"name":"excluded","kind":12,"containerName":"_define_target"},{"line":371,"containerName":"_define_target","kind":13,"name":"@excluded"},{"name":"$targregion","containerName":"_define_target","kind":13,"line":373}],"name":"_define_target","containerName":"main::","signature":{"label":"_define_target($self)","documentation":"","parameters":[{"label":"$self"}]},"line":329,"kind":12,"range":{"end":{"line":374,"character":9999},"start":{"line":329,"character":0}}},{"line":358,"containerName":"SeqFeature::Generic","kind":12,"name":"Bio"},{"signature":{"label":"_get_targetregion($self)","documentation":"","parameters":[{"label":"$self"}]},"line":376,"kind":12,"range":{"end":{"line":389,"character":9999},"start":{"character":0,"line":376}},"definition":"sub","detail":"($self)","children":[{"name":"$self","localvar":"my","containerName":"_get_targetregion","kind":13,"line":377,"definition":"my"},{"definition":"my","line":379,"name":"$targregion","localvar":"my","containerName":"_get_targetregion","kind":13},{"line":379,"kind":12,"containerName":"_get_targetregion","name":"primary_tag"},{"line":379,"name":"$self","containerName":"_get_targetregion","kind":13},{"containerName":"_get_targetregion","kind":12,"name":"target","line":379},{"line":379,"kind":12,"containerName":"_get_targetregion","name":"top_SeqFeatures"},{"line":380,"name":"$targregion","kind":13,"containerName":"_get_targetregion"},{"line":380,"name":"$self","kind":13,"containerName":"_get_targetregion"},{"line":380,"kind":12,"containerName":"_get_targetregion","name":"_define_target"},{"containerName":"_get_targetregion","kind":13,"name":"$self","line":382},{"line":382,"containerName":"_get_targetregion","kind":12,"name":"throw"},{"line":382,"kind":13,"containerName":"_get_targetregion","name":"$targregion"},{"definition":"my","line":384,"localvar":"my","kind":13,"containerName":"_get_targetregion","name":"$seq"},{"name":"$targregion","containerName":"_get_targetregion","kind":13,"line":384},{"line":384,"name":"seq","containerName":"_get_targetregion","kind":12},{"containerName":"_get_targetregion","kind":12,"name":"seq","line":384},{"name":"$targstart","containerName":"_get_targetregion","localvar":"my","kind":13,"line":386,"definition":"my"},{"containerName":"_get_targetregion","kind":13,"name":"$targregion","line":386},{"name":"start","kind":12,"containerName":"_get_targetregion","line":386},{"containerName":"_get_targetregion","kind":13,"name":"$seq","line":388},{"line":388,"name":"$targstart","containerName":"_get_targetregion","kind":13}],"name":"_get_targetregion","containerName":"main::"},{"children":[{"definition":"my","line":473,"name":"$self","kind":13,"localvar":"my","containerName":"add_oligos"},{"containerName":"add_oligos","kind":13,"name":"$seq","line":473},{"containerName":"add_oligos","kind":13,"name":"$start","line":473},{"line":473,"kind":13,"containerName":"add_oligos","name":"$rank"},{"kind":13,"containerName":"add_oligos","name":"$seq","line":475},{"kind":13,"containerName":"add_oligos","name":"$start","line":476},{"line":478,"localvar":"my","kind":13,"containerName":"add_oligos","name":"$end","definition":"my"},{"name":"$start","containerName":"add_oligos","kind":13,"line":478},{"line":478,"kind":13,"containerName":"add_oligos","name":"$seq"},{"definition":"my","line":480,"containerName":"add_oligos","localvar":"my","kind":13,"name":"$sseq"},{"containerName":"add_oligos","kind":13,"name":"$self","line":480},{"name":"_get_sense","containerName":"add_oligos","kind":12,"line":480},{"kind":13,"containerName":"add_oligos","name":"$seq","line":480},{"line":481,"containerName":"add_oligos","localvar":"my","kind":13,"name":"$sense","definition":"my"},{"line":481,"containerName":"add_oligos","kind":12,"name":"new"},{"containerName":"add_oligos","kind":13,"name":"$start","line":481},{"line":482,"containerName":"add_oligos","kind":13,"name":"$start"},{"line":482,"name":"$sseq","kind":13,"containerName":"add_oligos"},{"line":484,"kind":13,"containerName":"add_oligos","name":"$sseq"},{"line":485,"kind":13,"containerName":"add_oligos","name":"$self"},{"localvar":"my","kind":13,"containerName":"add_oligos","name":"$aseq","line":488,"definition":"my"},{"line":488,"containerName":"add_oligos","kind":13,"name":"$self"},{"kind":12,"containerName":"add_oligos","name":"_get_anti","line":488},{"name":"$seq","kind":13,"containerName":"add_oligos","line":488},{"definition":"my","kind":13,"localvar":"my","containerName":"add_oligos","name":"$asense","line":489},{"line":489,"kind":12,"containerName":"add_oligos","name":"new"},{"name":"$end","containerName":"add_oligos","kind":13,"line":489},{"containerName":"add_oligos","kind":13,"name":"$end","line":490},{"line":490,"kind":13,"containerName":"add_oligos","name":"$aseq"},{"kind":13,"containerName":"add_oligos","name":"$aseq","line":492},{"containerName":"add_oligos","kind":13,"name":"$self","line":493},{"line":496,"localvar":"my","kind":13,"containerName":"add_oligos","name":"$sirna","definition":"my"},{"line":496,"name":"new","containerName":"add_oligos","kind":12},{"containerName":"add_oligos","kind":13,"name":"$rank","line":496},{"line":498,"containerName":"add_oligos","kind":13,"name":"$sense"},{"line":499,"name":"$asense","kind":13,"containerName":"add_oligos"},{"line":500,"kind":13,"containerName":"add_oligos","name":"$self"},{"line":503,"name":"$self","containerName":"add_oligos","kind":13},{"line":503,"kind":12,"containerName":"add_oligos","name":"_has_overlap"},{"line":503,"kind":13,"containerName":"add_oligos","name":"$sirna"},{"kind":13,"containerName":"add_oligos","name":"$self","line":503},{"containerName":"add_oligos","kind":12,"name":"excluded","line":503},{"line":504,"containerName":"add_oligos","kind":13,"name":"$self"},{"kind":12,"containerName":"add_oligos","name":"target","line":504},{"containerName":"add_oligos","kind":12,"name":"add_SeqFeature","line":504},{"name":"$sirna","containerName":"add_oligos","kind":13,"line":504}],"name":"add_oligos","containerName":"main::","definition":"sub","detail":"($self,$seq,$start,$rank)","line":472,"range":{"start":{"character":0,"line":472},"end":{"character":9999,"line":506}},"kind":12,"signature":{"label":"add_oligos($self,$seq,$start,$rank)","documentation":"1;\n# $Id: SiRNA.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::SiRNA\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nSiRNA - Perl object for designing small inhibitory RNAs.\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::SiRNA;\n\n  my $sirna_designer = Bio::Tools::SiRNA->new( -target => $bio_seq,\n                                               -rules  => 'saigo'\n    );\n  my @pairs = $sirna_designer->design;\n\n  foreach $pair (@pairs) {\n      my $sense_oligo_sequence = $pair->sense->seq;\n      my $antisense_oligo_sequence = $pair->antisense->seq;\n\n      # print out results\n      print join (\"\\t\", $pair->start, $pair->end, $pair->rank,\n                  $sense_oligo_sequence, $antisense_oligo_sequence), \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nPackage for designing siRNA reagents.\n\nInput is a L<Bio::SeqI>-compliant object (the target).\n\nOutput is a list of Bio::SeqFeature::SiRNA::Pair objects, which are\nadded to the feature table of the target sequence.  Each\nBio::SeqFeature::SiRNA::Pair contains two subfeatures\n(Bio::SeqFeature::Oligo objects) which correspond to the individual\noligos.  These objects provide accessors for the information on the\nindividual reagent pairs.\n\nThis verion of Bio::Tools::SiRNA represents a major change in architecture.\nSpecific 'rulesets' for siRNA selection as developed by various groups are\nimplemented as Bio::Tools::SiRNA::Ruleset objects, which inherit from\nBio::Tools::SiRNA.  This will make it easier to add new rule sets or modify\nexisting approaches. Currently the Tuschl and Ui-Tei (2004) rules are \nimplemented. For consistency, the Tuschl rules are implemented by default.\n\nIn addition, this module provides three 'extra' rules which can be added\nabove and beyond any ruleset.\n\n=over 3\n\n* 1.\n\nSiRNAs that overlap known SNPs (identified as SeqFeatures with \nprimary tag = variation) can be avoided.\n\n* 2.\n\nOther regions (with primary tag = 'Excluded') can also be skipped.  I\nuse this with Bio::Tools::Run::Mdust to avoid low-complexity regions\n(must be run separately), but other programs could also be used.\n\n* 3.\n\nSiRNAs may also be selected in the 3 prime UTR of a gene by setting\n$sirna_designer-E<gt>include_3pr() to true.\n\n\n=head2 EXPORT\n\nNone.\n\n=head1 SEE ALSO\n\nL<Bio::Tools::Run::Mdust>, L<Bio::SeqFeature::SiRNA::Pair>,\nL<Bio::SeqFeature::SiRNA::Oligo>..\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nDonald Jackson (donald.jackson@bms.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::SiRNA;\n\nuse strict;\nuse warnings;\n\nuse vars qw($AUTOLOAD);\n\nuse Bio::Seq::RichSeq;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::SiRNA::Oligo;\nuse Bio::SeqFeature::SiRNA::Pair;\n\n\nuse base qw(Bio::Root::Root);\n\n\nour %COMP = ( A => 'T',\n\t      T => 'A',\n\t      C => 'G',\n\t      G => 'C',\n\t      N => 'N',\n\t      );\n\nour @ARGNAMES = qw(RULES START_PAD END_PAD MIN_GC CUTOFF OLIGOS AVOID_SNPS\n\t\t   GSTRING TMPDIR TARGET DEBUG);\n\n\n=head2 new\n\n Title\t\t: new\n Usage\t\t: my $sirna_designer = Bio::Tools::SiRNA->new();\n Function\t: Constructor for designer object\n Returns\t: Bio::Tools::SiRNA object\n Args\t\t: target - the target sequence for the SiRNAs as a Bio::Seq::RichSeq\n                  start_pad - distance from the CDS start to skip (default 75)\n                  end_pad - distance from the CDS end to skip (default 50)\n                  include_3pr - set to true to include SiRNAs in the 3prime UTR (default false)\n                  rules - rules for selecting siRNAs, currently supporting saigo and tuschl\n                  min_gc - minimum GC fraction (NOT percent) (default 0.4)\n                  max_gc - maximum GC fraction (NOT percent) (default 0.6)\n                  cutoff - worst 'rank' accepted(default 3)\n                  avoid_snps - boolean - reject oligos that overlap a variation\n                     SeqFeature in the target (default true)\n                  gstring - maximum allowed consecutive Gs.\n                     Too many can cause problems in synthesis (default 4)\n  Note\t\t: All arguments can also be changed/accessed using autoloaded \n                 methods such as:\n\n    my $start_pad = $sirna_designer->start_pad().\n\n\nsub new {\n    my ($proto, @args) = @_;\n    my $pkg = ref($proto) || $proto;\n\n    my $self = {};\n    bless ($self, $pkg);\n\n    my %args;\n\n    @args{@ARGNAMES} = $self->_rearrange(\\@ARGNAMES, @args); \n    \n    if ($args{'RULES'}) {\n\t$self->rules($args{'RULES'});\n    }\n\n    $self->{'start_pad'} = $args{'START_PAD'} || 75; # nt from start to mask\n    $self->{'end_pad'} = $args{'END_PAD'} || 50; # nt from end to mask\n    $self->{'include_3pr'} = $args{'INCLUDE_3PR'} || 0; # look for oligos in 3prime UTR\n    $self->{'min_gc'} = $args{'MIN_GC'} || 0.40;\n    $self->{'max_gc'} = $args{'MAX_GC'} || 0.60;\n    $self->{'cutoff'} = $args{'CUTOFF'} || 3; # highest (worst) rank wanted\n    $self->{'oligos'} = [];\n    defined($args{'AVOID_SNPS'}) ? $self->{'avoid_snps'} = $args{'AVOID_SNPS'} :  \n\t$self->{'avoid_snps'} = 1; # (t/f to avoid or include reagents that cover SNPs)\n    $self->{'gstring'} = $args{'GSTRING'} || 4; # maximum allowed consecutive Gs - too many can cause problems in oligo synthesis\n    $self->{'tmpdir'} = $args{'TMPDIR'}  || $ENV{'TMPDIR'} || $ENV{'TMP'} || '';\n    $self->{'debug'} = $args{'DEBUG'} || 0;\n\n    $self->target($args{'TARGET'}) if ($args{'TARGET'});\n\n    return $self;\n}\n\n\n=head2 target \n\n  Title\t\t: target\n  Usage\t\t: my $target_seq = $sirna_designer->target(); # get the current target\n                  OR \n                  $sirna_designer->target($new_target_seq); # set a new target \n  Function\t: Set/get the target as a Bio::SeqI-compliant object\n  Returns\t: a Bio::SeqI-compliant object\n  Args\t\t: a Bio::SeqI-compliant object (optional)\n\n\nsub target {\n    my ($self, $target) = @_;\n\n    if ($target) {\n\tunless ($target->isa('Bio::SeqI')) {\n\t    $self->throw(  -class => 'Bio::Root::BadParameter',\n\t\t\t   -text  => \"Target must be passed as a Bio::Seq object\" );\n\t}\n\tif ($target->can('molecule')) {\n\t    ( grep { uc($target->molecule) eq $_ } qw(DNA MRNA CDNA)) or\n\t\t$self->throw(  -class => 'Bio::Root::BadParameter',\n\t\t\t       -text  =>  \"Sequences of type \". $target->molecule. \" are not supported\"\n\t\t\t       );\n\t}\n\telse {\n\t    ($target->alphabet eq 'dna') or \n\t\t$self->throw(  -class => 'Bio::Root::BadParameter',\n\t\t\t       -text  =>  \"Sequences of alphabet \". $target->alphabet. \" are not supported\"\n\t\t\t       );\n\t}\n\t\n\t$self->{'target'} = $target;\n\treturn 1;\n\n    }\n    elsif ($self->{'target'}) {\n\treturn $self->{'target'};\n    }\n    else {\n\t$self->throw(\"Target sequence not defined\");\n    }\n}\n\n=head2 rules\n\n    Title\t: rules\n    Usage\t: $sirna->rules('ruleset')\n    Purpose\t: set/get ruleset to use for selecting SiRNA oligo pairs.\n    Returns\t: not sure yet\n    Args\t: a ruleset name (currently supported: Tuschl, Saigo)\n                  or a Bio::Tools::SiRNA::RulesetI compliant object\n\n\nsub rules {\n    my ($self, $rules) = @_;\n\n    if ($rules) {\n\t$self->_load_ruleset($rules);\n    }\n    # default: use tuschl rules\n    unless ($self->{_rules}) {\n\t$self->_load_ruleset('tuschl');\n    }\n    return $self->{_rules};\n}\n\nsub _load_ruleset {\n    my ($self, $ruleset) = @_;\n\n    my $rule_module = join('::', ref($self), 'Ruleset', lc($ruleset));\n\n    eval \"require $rule_module\";\n    \n    if ($@) {\n\t#warn join(\"\\n\", '@INC contains:', @INC, undef);\n\t$self->throw(\"Unable to load $rule_module: $@\");\n\treturn;\n    }\n\n    else {\n\t$self->{_rules} = $rule_module;\n\tbless($self, $rule_module); # recast as subclass\n    }\n\t\n    return 1;\n}\n\n=head2 design\n\n  Title\t\t: design\n  Usage\t\t: my @pairs = $sirna_designer->design();\n  Purpose\t: Design SiRNA oligo pairs.  \n  Returns\t: A list of SiRNA pairs as Bio::SeqFeature::SiRNA::Pair objects\n  Args\t\t: none\n\n\nsub design {\t\n    my ($self) = @_;\n\n    ($self->rules) or $self->throw('Unable to design siRNAs: no rule set specified');\n\n#     unless ( grep { $_->primary_tag eq 'Target' } $self->target->top_SeqFeatures ) {\n# \t$self->_define_target();\n#     }\n\n    my @oligos = $self->_get_oligos();\n       \n    return ( grep { $_->isa('Bio::SeqFeature::SiRNA::Pair') } $self->target->top_SeqFeatures );\n}\n    \nsub _define_target {\n    my ($self) = @_;\n    my ($feat, $cds, $left, $right);\n\n    my $target = $self->target or \n\t$self->throw(\"Unable to design oligos - no target provided\");\n\n    ($cds) = grep { $_->primary_tag eq 'CDS' } $target->top_SeqFeatures if ($target->can('top_SeqFeatures'));\n    \n    if ($cds) {\n\t$left = $cds->start + $self->start_pad;\n\tif (!$self->include_3pr) {\n\t    $right = $cds->end - $self->end_pad;\n\t}\n\telse {\n\t    $right = $target->length - $self->end_pad;\n\t}\n    }\n    else {\n\t$left = 0 + $self->start_pad;\n\t$right = $target->length - $self->end_pad;\n    }\n\n\n    # is there anything left?\n    if (($right - $left) < 20) {\n\t$self->throw(\"There isn't enough sequence to design oligos.  Please reduce start_pad and end_pad or supply more sequence\");\n    }\n    # define target region \n    my $targregion = Bio::SeqFeature::Generic->new( -start \t\t=> $left,\n\t\t\t\t\t\t    -end \t\t=> $right,\n\t\t\t\t\t\t    -primary\t\t=> 'Target' );\n    $self->target->add_SeqFeature($targregion);\n\n    # locate excluded regions\n    my @excluded = grep { $_->primary_tag eq 'Excluded' } $self->target->top_SeqFeatures;\n\n    if ($self->avoid_snps) {\n\tmy @snps =  grep { $_->primary_tag eq 'variation' } $self->target->top_SeqFeatures;\n\tpush(@excluded, @snps);\n    }\n    \n    $self->excluded(\\@excluded);\n\n    return $targregion;\n}\n\nsub _get_targetregion {\n    my ($self) = @_;\n    \n    my ($targregion) = grep { $_->primary_tag eq 'Target' } $self->target->top_SeqFeatures;\n    $targregion ||= $self->_define_target;\n\n    $self->throw(\"Target region for SiRNA design not defined\") unless ($targregion);\n\n    my $seq = $targregion->seq->seq;\n    # but this way I loose start info\n     my $targstart = $targregion->start;\n\n    return ($seq, $targstart);\n}   \n\n# MOVE to SiRNA::Ruleset::tuschl\n# sub _regex {\n#     my ($self, $rank) = @_;\n#     return $PATTERNS{$rank};\n# }\n\n# sub _get_oligos {\n#     # use regular expressions to pull out oligos\n\n#     my ($self, $rank) = @_;\n#     my $regex = $self->_regex($rank);\n#     my @exclude;\n\n\n#     my ($targregion) = grep { $_->primary_tag eq 'Target' } $self->target->top_SeqFeatures;\n#     my $seq = $targregion->seq->seq;\n#     # but this way I loose start info\n#     my $targstart = $targregion->start;\n    \n#     # exclude masked region\n#     push(@exclude, grep { $_->primary_tag eq 'Excluded' } $self->target->top_SeqFeatures);\n\n#     # add SNP checking\n#     if ($self->avoid_snps) {\n# \tmy @snps =  grep { $_->primary_tag eq 'variation' } $self->target->top_SeqFeatures;\n# \tpush(@exclude, @snps);\n#     }\n\n#     while ( $seq =~ /$regex/gi ) {\n# \tmy $target = $1;\n\n# \t# check for too many Gs (or Cs on the other strand)\n# \tnext if ( $target =~ /G{ $self->gstring,}/io );\n# \tnext if ( $target =~ /C{ $self->gstring,}/io );\n# \t# skip Ns (for filtering)\n# \tnext if ( $target =~ /N/i);\n\n# \tmy $start = length($`) + $targstart;\n# \tmy $stop = $start + length($target) -1;\n\n# \tmy @gc = ( $target =~ /G|C/gi);\n# \tmy $fxGC = sprintf(\"%2.2f\", (scalar(@gc) / length($target)));\n# \tnext if ($fxGC < $self->min_gc);\n# \tnext if ($fxGC > $self->max_gc);\n\n# \tmy $sense = Bio::SeqFeature::SiRNA::Oligo->new( -start \t\t=> $start,\n# \t\t\t\t\t\t\t-end \t\t=> $stop,\n# \t\t\t\t\t\t\t-strand \t=> 1,\n# \t\t\t\t\t\t\t-seq \t\t=> _get_sense($target),\n# \t\t\t\t\t\t\t-source_tag\t=> ref($self),\n# \t\t\t\t\t\t       );\t\n\n# \tmy $asense = Bio::SeqFeature::SiRNA::Oligo->new( -start \t=> $start,\n# \t\t\t\t\t\t\t -end\t\t=> $stop,\n# \t\t\t\t\t\t\t -strand\t=> -1,\n# \t\t\t\t\t\t\t -seq \t\t=> _get_anti($target), \n# \t\t\t\t\t\t\t -source_tag\t=> ref($self),\n# \t\t\t\t\t\t\t );\n\n#   \tmy $sirna = Bio::SeqFeature::SiRNA::Pair->new( -rank \t\t=> $rank,\n# \t\t\t\t\t\t       -fxGC\t\t=> $fxGC,\n# \t\t\t\t\t\t       -sense \t\t=> $sense,\n# \t\t\t\t\t\t       -antisense \t=> $asense,     \n# \t\t\t\t\t\t       -source_tag\t=> ref($self),\n# \t\t\t\t\t\t       );\n\n# \tunless ($self->_has_overlap($sirna, \\@exclude)) {\n# \t    $self->target->add_SeqFeature($sirna);\n# \t}\n#     }\n# }    \n\n=head2 add_oligos\n\n  Title\t\t: add_oligos\n  Usage\t \t: $sirna_designer->add_oligos($sequence, $start, $rank);\n  Purpose\t: Add SiRNA olgos to target Bio::Seq as Bio::SeqFeature::SiRNA::Pair objects\n  Args\t\t: Oligo sequence and start position (required), rank/score (optional)","parameters":[{"label":"$self"},{"label":"$seq"},{"label":"$start"},{"label":"$rank"}]}},{"name":"throw","kind":12,"line":475},{"line":476,"name":"throw","kind":12},{"line":481,"containerName":"SeqFeature::SiRNA::Oligo","kind":12,"name":"Bio"},{"kind":12,"containerName":"SeqFeature::SiRNA::Oligo","name":"Bio","line":489},{"line":496,"name":"Bio","containerName":"SeqFeature::SiRNA::Pair","kind":12},{"signature":{"parameters":[{"label":"$self"},{"label":"$test"},{"label":"$flist"}],"documentation":"","label":"_has_overlap($self,$test,$flist)"},"line":508,"kind":12,"range":{"end":{"character":9999,"line":524},"start":{"character":0,"line":508}},"definition":"sub","detail":"($self,$test,$flist)","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"_has_overlap","line":512,"definition":"my"},{"line":512,"name":"$test","containerName":"_has_overlap","kind":13},{"line":512,"name":"$flist","kind":13,"containerName":"_has_overlap"},{"containerName":"_has_overlap","kind":13,"name":"$test","line":513},{"name":"start","kind":12,"containerName":"_has_overlap","line":513},{"name":"$test","kind":13,"containerName":"_has_overlap","line":513},{"line":513,"name":"end","kind":12,"containerName":"_has_overlap"},{"line":514,"kind":13,"containerName":"_has_overlap","name":"$self"},{"line":514,"name":"debug","kind":12,"containerName":"_has_overlap"},{"line":516,"name":"$feat","localvar":"my","containerName":"_has_overlap","kind":13,"definition":"my"},{"name":"$flist","kind":13,"containerName":"_has_overlap","line":516},{"name":"$test","containerName":"_has_overlap","kind":13,"line":517},{"line":517,"kind":12,"containerName":"_has_overlap","name":"start"},{"line":517,"containerName":"_has_overlap","kind":13,"name":"$feat"},{"containerName":"_has_overlap","kind":12,"name":"end","line":517},{"line":517,"kind":13,"containerName":"_has_overlap","name":"$test"},{"line":517,"name":"end","containerName":"_has_overlap","kind":12},{"line":517,"name":"$feat","kind":13,"containerName":"_has_overlap"},{"line":517,"containerName":"_has_overlap","kind":12,"name":"start"},{"name":"$feat","containerName":"_has_overlap","kind":13,"line":518},{"containerName":"_has_overlap","kind":12,"name":"primary_tag","line":518},{"name":"$feat","containerName":"_has_overlap","kind":13,"line":519},{"line":519,"kind":12,"containerName":"_has_overlap","name":"start"},{"line":519,"kind":13,"containerName":"_has_overlap","name":"$feat"},{"kind":12,"containerName":"_has_overlap","name":"end","line":519},{"line":519,"kind":13,"containerName":"_has_overlap","name":"$self"},{"name":"debug","containerName":"_has_overlap","kind":12,"line":519}],"containerName":"main::","name":"_has_overlap"},{"detail":"($self,$value)","definition":"sub","name":"AUTOLOAD","containerName":"main::","children":[{"localvar":"my","containerName":"AUTOLOAD","kind":13,"name":"$self","line":561,"definition":"my"},{"kind":13,"containerName":"AUTOLOAD","name":"$value","line":561},{"name":"$name","localvar":"my","containerName":"AUTOLOAD","kind":13,"line":562,"definition":"my"},{"kind":13,"containerName":"AUTOLOAD","name":"$AUTOLOAD","line":562},{"line":563,"name":"$name","containerName":"AUTOLOAD","kind":13},{"line":565,"name":"$name","kind":13,"containerName":"AUTOLOAD"},{"line":568,"containerName":"AUTOLOAD","kind":13,"name":"$value"},{"name":"$self","containerName":"AUTOLOAD","kind":13,"line":569},{"line":569,"containerName":"AUTOLOAD","kind":13,"name":"$name"},{"containerName":"AUTOLOAD","kind":13,"name":"$value","line":569},{"containerName":"AUTOLOAD","kind":13,"name":"$self","line":572},{"line":572,"containerName":"AUTOLOAD","kind":13,"name":"$name"},{"kind":13,"containerName":"AUTOLOAD","name":"$self","line":573},{"line":573,"name":"throw","containerName":"AUTOLOAD","kind":12},{"name":"$self","containerName":"AUTOLOAD","kind":13,"line":573},{"containerName":"AUTOLOAD","kind":13,"name":"$self","line":576},{"line":576,"name":"$name","containerName":"AUTOLOAD","kind":13}],"signature":{"documentation":" MOVE to SiRNA::Ruleset::tuschl\n sub _get_sense {\n     my ($target) = @_;\n     # trim off 1st 2 nt to get overhang\n     $target =~ s/^..//;\n     # convert T's to U's (transcribe)\n     $target =~ s/T/U/gi;\n     # force last 2 nt to be T's\n     $target =~ s/..$/TT/;\n     return $target;\n }\n sub _get_anti {\n     my ($target) = @_;\n     my @target = split(//, $target);\n     my ($nt,@antitarget);\n     while ($nt = pop @target) {\n \tpush(@antitarget, $COMP{$nt});\n     }\n     my $anti = join('', @antitarget);\n     # trim off 1st 2 nt to get overhang\n     $anti =~ s/^..//;\n     # convert T's to U's\n     $anti =~ s/T/U/gi;\n     # convert last 2 NT's to T\n     $anti =~ s/..$/TT/;\n     return $anti;\n }","parameters":[{"label":"$self"},{"label":"$value"}],"label":"AUTOLOAD($self,$value)"},"kind":12,"range":{"start":{"line":560,"character":0},"end":{"character":9999,"line":577}},"line":560},{"name":"_comp","containerName":"main::","children":[{"line":580,"name":"$self","kind":13,"localvar":"my","containerName":"_comp","definition":"my"},{"name":"$char","kind":13,"containerName":"_comp","line":580},{"name":"$char","containerName":"_comp","kind":13,"line":582},{"line":583,"name":"$char","containerName":"_comp","kind":13},{"line":583,"kind":13,"containerName":"_comp","name":"$char"},{"kind":13,"containerName":"_comp","name":"$COMP","line":584},{"line":584,"name":"$char","containerName":"_comp","kind":13}],"detail":"($self,$char)","definition":"sub","kind":12,"range":{"end":{"line":585,"character":9999},"start":{"line":579,"character":0}},"line":579,"signature":{"parameters":[{"label":"$self"},{"label":"$char"}],"documentation":"","label":"_comp($self,$char)"}}]}