{"vars":[{"line":206,"name":"base","kind":2,"containerName":""},{"line":208,"containerName":"","kind":2,"name":"vars"},{"name":"$ID","kind":13,"containerName":null,"line":209},{"definition":"my","line":213,"name":"$PURINES","containerName":null,"localvar":"my","kind":13},{"line":214,"name":"$PYRIMIDINES","localvar":"my","containerName":null,"kind":13,"definition":"my"},{"line":215,"name":"$BEE","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"definition":"my","name":"$ZED","containerName":null,"localvar":"my","kind":13,"line":216},{"definition":"my","name":"$Regexp_chars","kind":13,"localvar":"my","containerName":null,"line":217},{"line":220,"name":"%Processed_braces","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"name":"%Processed_asterics","kind":13,"containerName":null,"line":220},{"kind":12,"range":{"start":{"character":0,"line":244},"end":{"character":9999,"line":264}},"line":244,"signature":{"parameters":[{"label":"$class"},{"label":"%param"}],"documentation":"# $Id: SeqPattern.pm 16139 2009-09-18 21:11:23Z cjfields $\n#\n# bioperl module for Bio::Tools::SeqPattern\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by  Steve Chervitz  (sac-at-bioperl.org)\n#\n# Copyright  Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::SeqPattern - represent a sequence pattern or motif\n\n=head1 SYNOPSIS\n\n use Bio::Tools::SeqPattern;\n\n my $pat1     = 'T[GA]AA...TAAT';\n my $pattern1 = Bio::Tools::SeqPattern->new(-SEQ =>$pat1, -TYPE =>'Dna');\n\n my $pat2     = '[VILM]R(GXX){3,2}...[^PG]';\n my $pattern2 = Bio::Tools::SeqPattern->new(-SEQ =>$pat2, -TYPE =>'Amino');\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::SeqPattern> module encapsulates generic data and\nmethods for manipulating regular expressions describing nucleic or\namino acid sequence patterns (a.k.a, \"motifs\").\n\nL<Bio::Tools::SeqPattern> is a concrete class that inherits from L<Bio::Seq>.\n\nThis class grew out of a need to have a standard module for doing routine\ntasks with sequence patterns such as:\n\n  -- Forming a reverse-complement version of a nucleotide sequence pattern\n  -- Expanding patterns containing ambiguity codes\n  -- Checking for invalid regexp characters\n  -- Untainting yet preserving special characters in the pattern\n\nOther features to look for in the future:\n\n  -- Full pattern syntax checking\n  -- Conversion between expanded and condensed forms of the pattern\n\n=head1 MOTIVATIONS\n\nA key motivation for L<Bio::Tools::SeqPattern> is to have a way to\ngenerate a reverse complement of a nucleotide sequence pattern.\nThis makes possible simultaneous pattern matching on both sense and\nanti-sense strands of a query sequence.\n\nIn principle, one could do such a search more inefficiently by testing\nagainst both sense and anti-sense versions of a sequence.\nIt is entirely equivalent to test a regexp containing both sense and\nanti-sense versions of the *pattern* against one copy of the sequence.\nThe latter approach is much more efficient since:\n\n   1) You need only one copy of the sequence.\n   2) Only one regexp is executed.\n   3) Regexp patterns are typically much smaller than sequences.\n\nPatterns can be quite complex and it is often difficult to\ngenerate the reverse complement pattern. The Bioperl SeqPattern.pm\naddresses this problem, providing a convenient set of tools\nfor working with biological sequence regular expressions.\n\nNot all patterns have been tested. If you discover a pattern that\nis not handled properly by Bio::Tools::SeqPattern.pm, please\nsend me some email (sac@bioperl.org). Thanks.\n\n=head1 OTHER FEATURES\n\n=head2 Extended Alphabet Support\n\nThis module supports the same set of ambiguity codes for nucleotide\nsequences as supported by L<Bio::Seq>. These ambiguity codes\ndefine the behavior or the L<expand> method.\n\n ------------------------------------------\n Symbol       Meaning      Nucleic Acid\n ------------------------------------------\n  A            A           (A)denine\n  C            C           (C)ytosine\n  G            G           (G)uanine\n  T            T           (T)hymine\n  U            U           (U)racil\n  M          A or C        a(M)ino group\n  R          A or G        pu(R)ine\n  W          A or T        (W)eak bond\n  S          C or G        (S)trong bond\n  Y          C or T        p(Y)rimidine\n  K          G or T        (K)eto group\n  V        A or C or G\n  H        A or C or T\n  D        A or G or T\n  B        C or G or T\n  X      G or A or T or C\n  N      G or A or T or C\n  .      G or A or T or C\n\n\n\n ------------------------------------------\n Symbol           Meaning\n ------------------------------------------\n A        Alanine\n C        Cysteine\n D        Aspartic Acid\n E        Glutamic Acid\n F        Phenylalanine\n G        Glycine\n H        Histidine\n I        Isoleucine\n K        Lysine\n L        Leucine\n M        Methionine\n N        Asparagine\n P        Proline\n Q        Glutamine\n R        Arginine\n S        Serine\n T        Threonine\n V        Valine\n W        Tryptophan\n Y        Tyrosine\n\n B        Aspartic Acid, Asparagine\n Z        Glutamic Acid, Glutamine\n X        Any amino acid\n .        Any amino acid\n\n\n=head2 Multiple Format Support\n\nUltimately, this module should be able to build SeqPattern.pm objects\nusing a variety of pattern formats such as ProSite, Blocks, Prints, GCG, etc.\nCurrently, this module only supports patterns using a grep-like syntax.\n\n=head1 USAGE\n\nA simple demo script called seq_pattern.pl is included in the examples/\ndirectory of the central Bioperl distribution.\n\n=head1 SEE ALSO\n\nL<Bio::Seq> - Lightweight sequence object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz, sac-at-bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 1997-8 Steve Chervitz. All Rights Reserved.\nThis module is free software; you can redistribute it and/or\nmodify it under the same terms as Perl itself.\n\n\n#\n##\n###\n#### END of main POD documentation.\n###\n##\n#'\n# CREATED : 28 Aug 1997\n\n\npackage Bio::Tools::SeqPattern;\n\nuse base qw(Bio::Root::Root);\nuse strict;\nuse vars qw ($ID);\n$ID  = 'Bio::Tools::SeqPattern';\n\n## These constants may be more appropriate in a Bio::Dictionary.pm\n## type of class.\nmy $PURINES      = 'AG';\nmy $PYRIMIDINES  = 'CT';\nmy $BEE      = 'DN';\nmy $ZED      = 'EQ';\nmy $Regexp_chars = '\\w,.\\*()\\[\\]<>\\{\\}^\\$';  # quoted for use in regexps\n\n## Package variables used in reverse complementing.\nmy (%Processed_braces, %Processed_asterics);\n\n#####################################################################################\n##                                 CONSTRUCTOR                                     ##\n#####################################################################################\n\n=head1 new\n\n Title     : new\n Usage     : my $seqpat = Bio::Tools::SeqPattern->new();\n Purpose   : Verifies that the type is correct for superclass (Bio::Seq.pm)\n           : and calls superclass constructor last.\n Returns   : n/a\n Argument  : Parameters passed to new()\n Throws    : Exception if the pattern string (seq) is empty.\n Comments  : The process of creating a new SeqPattern.pm object\n           : ensures that the pattern string is untained.\n\nSee Also   : L<Bio::Root::Root::new>,\n             L<Bio::Seq::_initialize>","label":"new($class,%param)"},"name":"new","containerName":"main::","children":[{"kind":13,"localvar":"my","containerName":"new","name":"$class","line":246,"definition":"my"},{"containerName":"new","kind":13,"name":"%param","line":246},{"definition":"my","line":248,"name":"$self","localvar":"my","kind":13,"containerName":"new"},{"line":248,"kind":13,"containerName":"new","name":"$class"},{"line":248,"kind":13,"containerName":"new","name":"%param"},{"definition":"my","line":249,"localvar":"my","containerName":"new","kind":13,"name":"$seq"},{"containerName":"new","kind":13,"name":"$type","line":249},{"containerName":"new","kind":13,"name":"$self","line":249},{"line":249,"containerName":"new","kind":12,"name":"_rearrange"},{"line":249,"name":"%param","containerName":"new","kind":13},{"name":"$seq","containerName":"new","kind":13,"line":251},{"line":251,"name":"$self","kind":13,"containerName":"new"},{"name":"throw","containerName":"new","kind":12,"line":251},{"definition":"my","localvar":"my","containerName":"new","kind":13,"name":"$t","line":252},{"line":254,"kind":13,"containerName":"new","name":"$type"},{"name":"$t","containerName":"new","kind":13,"line":255},{"containerName":"new","kind":13,"name":"$type","line":256},{"name":"$t","containerName":"new","kind":13,"line":257},{"line":259,"name":"$seq","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$self","line":260},{"name":"str","kind":12,"containerName":"new","line":260},{"kind":13,"containerName":"new","name":"$seq","line":260},{"kind":13,"containerName":"new","name":"$self","line":261},{"line":261,"kind":12,"containerName":"new","name":"type"},{"line":261,"name":"$t","containerName":"new","kind":13},{"name":"$self","containerName":"new","kind":13,"line":263}],"detail":"($class,%param)","definition":"sub"},{"name":"SUPER","kind":12,"containerName":"new","line":248},{"definition":"sub","detail":"($self)","children":[{"localvar":"my","kind":13,"containerName":"alphabet_ok","name":"$self","line":289,"definition":"my"},{"kind":13,"containerName":"alphabet_ok","name":"$self","line":291},{"line":293,"containerName":"alphabet_ok","kind":13,"name":"$self"},{"localvar":"my","containerName":"alphabet_ok","kind":13,"name":"$pat","line":295,"definition":"my"},{"containerName":"alphabet_ok","kind":13,"name":"$self","line":295},{"name":"seq","kind":12,"containerName":"alphabet_ok","line":295},{"name":"$pat","kind":13,"containerName":"alphabet_ok","line":297},{"line":298,"containerName":"alphabet_ok","kind":13,"name":"$self"},{"line":298,"name":"throw","containerName":"alphabet_ok","kind":12},{"containerName":"alphabet_ok","kind":13,"name":"$pat","line":303},{"name":"$self","containerName":"alphabet_ok","kind":13,"line":304},{"line":304,"kind":12,"containerName":"alphabet_ok","name":"setseq"}],"containerName":"main::","name":"alphabet_ok","signature":{"label":"alphabet_ok($self)","parameters":[{"label":"$self"}],"documentation":"# $Id: SeqPattern.pm 16139 2009-09-18 21:11:23Z cjfields $\n#\n# bioperl module for Bio::Tools::SeqPattern\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by  Steve Chervitz  (sac-at-bioperl.org)\n#\n# Copyright  Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::SeqPattern - represent a sequence pattern or motif\n\n=head1 SYNOPSIS\n\n use Bio::Tools::SeqPattern;\n\n my $pat1     = 'T[GA]AA...TAAT';\n my $pattern1 = Bio::Tools::SeqPattern->new(-SEQ =>$pat1, -TYPE =>'Dna');\n\n my $pat2     = '[VILM]R(GXX){3,2}...[^PG]';\n my $pattern2 = Bio::Tools::SeqPattern->new(-SEQ =>$pat2, -TYPE =>'Amino');\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::SeqPattern> module encapsulates generic data and\nmethods for manipulating regular expressions describing nucleic or\namino acid sequence patterns (a.k.a, \"motifs\").\n\nL<Bio::Tools::SeqPattern> is a concrete class that inherits from L<Bio::Seq>.\n\nThis class grew out of a need to have a standard module for doing routine\ntasks with sequence patterns such as:\n\n  -- Forming a reverse-complement version of a nucleotide sequence pattern\n  -- Expanding patterns containing ambiguity codes\n  -- Checking for invalid regexp characters\n  -- Untainting yet preserving special characters in the pattern\n\nOther features to look for in the future:\n\n  -- Full pattern syntax checking\n  -- Conversion between expanded and condensed forms of the pattern\n\n=head1 MOTIVATIONS\n\nA key motivation for L<Bio::Tools::SeqPattern> is to have a way to\ngenerate a reverse complement of a nucleotide sequence pattern.\nThis makes possible simultaneous pattern matching on both sense and\nanti-sense strands of a query sequence.\n\nIn principle, one could do such a search more inefficiently by testing\nagainst both sense and anti-sense versions of a sequence.\nIt is entirely equivalent to test a regexp containing both sense and\nanti-sense versions of the *pattern* against one copy of the sequence.\nThe latter approach is much more efficient since:\n\n   1) You need only one copy of the sequence.\n   2) Only one regexp is executed.\n   3) Regexp patterns are typically much smaller than sequences.\n\nPatterns can be quite complex and it is often difficult to\ngenerate the reverse complement pattern. The Bioperl SeqPattern.pm\naddresses this problem, providing a convenient set of tools\nfor working with biological sequence regular expressions.\n\nNot all patterns have been tested. If you discover a pattern that\nis not handled properly by Bio::Tools::SeqPattern.pm, please\nsend me some email (sac@bioperl.org). Thanks.\n\n=head1 OTHER FEATURES\n\n=head2 Extended Alphabet Support\n\nThis module supports the same set of ambiguity codes for nucleotide\nsequences as supported by L<Bio::Seq>. These ambiguity codes\ndefine the behavior or the L<expand> method.\n\n ------------------------------------------\n Symbol       Meaning      Nucleic Acid\n ------------------------------------------\n  A            A           (A)denine\n  C            C           (C)ytosine\n  G            G           (G)uanine\n  T            T           (T)hymine\n  U            U           (U)racil\n  M          A or C        a(M)ino group\n  R          A or G        pu(R)ine\n  W          A or T        (W)eak bond\n  S          C or G        (S)trong bond\n  Y          C or T        p(Y)rimidine\n  K          G or T        (K)eto group\n  V        A or C or G\n  H        A or C or T\n  D        A or G or T\n  B        C or G or T\n  X      G or A or T or C\n  N      G or A or T or C\n  .      G or A or T or C\n\n\n\n ------------------------------------------\n Symbol           Meaning\n ------------------------------------------\n A        Alanine\n C        Cysteine\n D        Aspartic Acid\n E        Glutamic Acid\n F        Phenylalanine\n G        Glycine\n H        Histidine\n I        Isoleucine\n K        Lysine\n L        Leucine\n M        Methionine\n N        Asparagine\n P        Proline\n Q        Glutamine\n R        Arginine\n S        Serine\n T        Threonine\n V        Valine\n W        Tryptophan\n Y        Tyrosine\n\n B        Aspartic Acid, Asparagine\n Z        Glutamic Acid, Glutamine\n X        Any amino acid\n .        Any amino acid\n\n\n=head2 Multiple Format Support\n\nUltimately, this module should be able to build SeqPattern.pm objects\nusing a variety of pattern formats such as ProSite, Blocks, Prints, GCG, etc.\nCurrently, this module only supports patterns using a grep-like syntax.\n\n=head1 USAGE\n\nA simple demo script called seq_pattern.pl is included in the examples/\ndirectory of the central Bioperl distribution.\n\n=head1 SEE ALSO\n\nL<Bio::Seq> - Lightweight sequence object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz, sac-at-bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 1997-8 Steve Chervitz. All Rights Reserved.\nThis module is free software; you can redistribute it and/or\nmodify it under the same terms as Perl itself.\n\n\n#\n##\n###\n#### END of main POD documentation.\n###\n##\n#'\n# CREATED : 28 Aug 1997\n\n\npackage Bio::Tools::SeqPattern;\n\nuse base qw(Bio::Root::Root);\nuse strict;\nuse vars qw ($ID);\n$ID  = 'Bio::Tools::SeqPattern';\n\n## These constants may be more appropriate in a Bio::Dictionary.pm\n## type of class.\nmy $PURINES      = 'AG';\nmy $PYRIMIDINES  = 'CT';\nmy $BEE      = 'DN';\nmy $ZED      = 'EQ';\nmy $Regexp_chars = '\\w,.\\*()\\[\\]<>\\{\\}^\\$';  # quoted for use in regexps\n\n## Package variables used in reverse complementing.\nmy (%Processed_braces, %Processed_asterics);\n\n#####################################################################################\n##                                 CONSTRUCTOR                                     ##\n#####################################################################################\n\n=head1 new\n\n Title     : new\n Usage     : my $seqpat = Bio::Tools::SeqPattern->new();\n Purpose   : Verifies that the type is correct for superclass (Bio::Seq.pm)\n           : and calls superclass constructor last.\n Returns   : n/a\n Argument  : Parameters passed to new()\n Throws    : Exception if the pattern string (seq) is empty.\n Comments  : The process of creating a new SeqPattern.pm object\n           : ensures that the pattern string is untained.\n\nSee Also   : L<Bio::Root::Root::new>,\n             L<Bio::Seq::_initialize>\n\n\n#----------------\nsub new {\n#----------------\n    my($class, %param) = @_;\n\n    my $self = $class->SUPER::new(%param);\n    my ($seq,$type) = $self->_rearrange([qw(SEQ TYPE)], %param);\n\n    $seq || $self->throw(\"Empty pattern.\");\n    my $t;\n    # Get the type ready for Bio::Seq.pm\n    if ($type =~ /nuc|[dr]na/i) {\n\t$t = 'Dna';\n    } elsif ($type =~ /amino|pep|prot/i) {\n\t$t = 'Amino';\n    }\n    $seq =~ tr/a-z/A-Z/;  #ps 8/8/00 Canonicalize to upper case\n    $self->str($seq);\n    $self->type($t);\n\n    return $self;\n}\n\n\n=head1 alphabet_ok\n\n Title     : alphabet_ok\n Usage     : $mypat->alphabet_ok;\n Purpose   : Checks for invalid regexp characters.\n           : Overrides Bio::Seq::alphabet_ok() to allow\n           : additional regexp characters ,.*()[]<>{}^$\n           : in addition to the standard genetic alphabet.\n           : Also untaints the pattern and sets the sequence\n           : object's sequence to the untained string.\n Returns   : Boolean (1 | 0)\n Argument  : n/a\n Throws    : Exception if the pattern contains invalid characters.\n Comments  : Does not call the superclass method.\n           : Actually permits any alphanumeric, not just the\n           : standard genetic alphabet.\n\n----------------'"},"line":287,"kind":12,"range":{"start":{"character":0,"line":287},"end":{"line":307,"character":9999}}},{"line":325,"kind":12,"range":{"start":{"line":325,"character":0},"end":{"line":334,"character":9999}},"children":[{"definition":"my","kind":13,"localvar":"my","containerName":"expand","name":"$self","line":327},{"line":329,"name":"$self","containerName":"expand","kind":13},{"kind":12,"containerName":"expand","name":"type","line":329},{"kind":13,"containerName":"expand","name":"$self","line":329},{"name":"_expand_nuc","containerName":"expand","kind":12,"line":329},{"line":330,"name":"$self","kind":13,"containerName":"expand"},{"line":330,"containerName":"expand","kind":12,"name":"type"},{"name":"$self","containerName":"expand","kind":13,"line":330},{"line":330,"kind":12,"containerName":"expand","name":"_expand_pep"},{"line":332,"name":"$self","kind":13,"containerName":"expand"},{"containerName":"expand","kind":12,"name":"throw","line":332}],"containerName":"main::","name":"expand","definition":"sub"},{"kind":12,"range":{"end":{"character":9999,"line":374},"start":{"line":351,"character":0}},"line":351,"signature":{"label":"_expand_pep($self,$pat)","documentation":"# $Id: SeqPattern.pm 16139 2009-09-18 21:11:23Z cjfields $\n#\n# bioperl module for Bio::Tools::SeqPattern\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by  Steve Chervitz  (sac-at-bioperl.org)\n#\n# Copyright  Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::SeqPattern - represent a sequence pattern or motif\n\n=head1 SYNOPSIS\n\n use Bio::Tools::SeqPattern;\n\n my $pat1     = 'T[GA]AA...TAAT';\n my $pattern1 = Bio::Tools::SeqPattern->new(-SEQ =>$pat1, -TYPE =>'Dna');\n\n my $pat2     = '[VILM]R(GXX){3,2}...[^PG]';\n my $pattern2 = Bio::Tools::SeqPattern->new(-SEQ =>$pat2, -TYPE =>'Amino');\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::SeqPattern> module encapsulates generic data and\nmethods for manipulating regular expressions describing nucleic or\namino acid sequence patterns (a.k.a, \"motifs\").\n\nL<Bio::Tools::SeqPattern> is a concrete class that inherits from L<Bio::Seq>.\n\nThis class grew out of a need to have a standard module for doing routine\ntasks with sequence patterns such as:\n\n  -- Forming a reverse-complement version of a nucleotide sequence pattern\n  -- Expanding patterns containing ambiguity codes\n  -- Checking for invalid regexp characters\n  -- Untainting yet preserving special characters in the pattern\n\nOther features to look for in the future:\n\n  -- Full pattern syntax checking\n  -- Conversion between expanded and condensed forms of the pattern\n\n=head1 MOTIVATIONS\n\nA key motivation for L<Bio::Tools::SeqPattern> is to have a way to\ngenerate a reverse complement of a nucleotide sequence pattern.\nThis makes possible simultaneous pattern matching on both sense and\nanti-sense strands of a query sequence.\n\nIn principle, one could do such a search more inefficiently by testing\nagainst both sense and anti-sense versions of a sequence.\nIt is entirely equivalent to test a regexp containing both sense and\nanti-sense versions of the *pattern* against one copy of the sequence.\nThe latter approach is much more efficient since:\n\n   1) You need only one copy of the sequence.\n   2) Only one regexp is executed.\n   3) Regexp patterns are typically much smaller than sequences.\n\nPatterns can be quite complex and it is often difficult to\ngenerate the reverse complement pattern. The Bioperl SeqPattern.pm\naddresses this problem, providing a convenient set of tools\nfor working with biological sequence regular expressions.\n\nNot all patterns have been tested. If you discover a pattern that\nis not handled properly by Bio::Tools::SeqPattern.pm, please\nsend me some email (sac@bioperl.org). Thanks.\n\n=head1 OTHER FEATURES\n\n=head2 Extended Alphabet Support\n\nThis module supports the same set of ambiguity codes for nucleotide\nsequences as supported by L<Bio::Seq>. These ambiguity codes\ndefine the behavior or the L<expand> method.\n\n ------------------------------------------\n Symbol       Meaning      Nucleic Acid\n ------------------------------------------\n  A            A           (A)denine\n  C            C           (C)ytosine\n  G            G           (G)uanine\n  T            T           (T)hymine\n  U            U           (U)racil\n  M          A or C        a(M)ino group\n  R          A or G        pu(R)ine\n  W          A or T        (W)eak bond\n  S          C or G        (S)trong bond\n  Y          C or T        p(Y)rimidine\n  K          G or T        (K)eto group\n  V        A or C or G\n  H        A or C or T\n  D        A or G or T\n  B        C or G or T\n  X      G or A or T or C\n  N      G or A or T or C\n  .      G or A or T or C\n\n\n\n ------------------------------------------\n Symbol           Meaning\n ------------------------------------------\n A        Alanine\n C        Cysteine\n D        Aspartic Acid\n E        Glutamic Acid\n F        Phenylalanine\n G        Glycine\n H        Histidine\n I        Isoleucine\n K        Lysine\n L        Leucine\n M        Methionine\n N        Asparagine\n P        Proline\n Q        Glutamine\n R        Arginine\n S        Serine\n T        Threonine\n V        Valine\n W        Tryptophan\n Y        Tyrosine\n\n B        Aspartic Acid, Asparagine\n Z        Glutamic Acid, Glutamine\n X        Any amino acid\n .        Any amino acid\n\n\n=head2 Multiple Format Support\n\nUltimately, this module should be able to build SeqPattern.pm objects\nusing a variety of pattern formats such as ProSite, Blocks, Prints, GCG, etc.\nCurrently, this module only supports patterns using a grep-like syntax.\n\n=head1 USAGE\n\nA simple demo script called seq_pattern.pl is included in the examples/\ndirectory of the central Bioperl distribution.\n\n=head1 SEE ALSO\n\nL<Bio::Seq> - Lightweight sequence object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz, sac-at-bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 1997-8 Steve Chervitz. All Rights Reserved.\nThis module is free software; you can redistribute it and/or\nmodify it under the same terms as Perl itself.\n\n\n#\n##\n###\n#### END of main POD documentation.\n###\n##\n#'\n# CREATED : 28 Aug 1997\n\n\npackage Bio::Tools::SeqPattern;\n\nuse base qw(Bio::Root::Root);\nuse strict;\nuse vars qw ($ID);\n$ID  = 'Bio::Tools::SeqPattern';\n\n## These constants may be more appropriate in a Bio::Dictionary.pm\n## type of class.\nmy $PURINES      = 'AG';\nmy $PYRIMIDINES  = 'CT';\nmy $BEE      = 'DN';\nmy $ZED      = 'EQ';\nmy $Regexp_chars = '\\w,.\\*()\\[\\]<>\\{\\}^\\$';  # quoted for use in regexps\n\n## Package variables used in reverse complementing.\nmy (%Processed_braces, %Processed_asterics);\n\n#####################################################################################\n##                                 CONSTRUCTOR                                     ##\n#####################################################################################\n\n=head1 new\n\n Title     : new\n Usage     : my $seqpat = Bio::Tools::SeqPattern->new();\n Purpose   : Verifies that the type is correct for superclass (Bio::Seq.pm)\n           : and calls superclass constructor last.\n Returns   : n/a\n Argument  : Parameters passed to new()\n Throws    : Exception if the pattern string (seq) is empty.\n Comments  : The process of creating a new SeqPattern.pm object\n           : ensures that the pattern string is untained.\n\nSee Also   : L<Bio::Root::Root::new>,\n             L<Bio::Seq::_initialize>\n\n\n#----------------\nsub new {\n#----------------\n    my($class, %param) = @_;\n\n    my $self = $class->SUPER::new(%param);\n    my ($seq,$type) = $self->_rearrange([qw(SEQ TYPE)], %param);\n\n    $seq || $self->throw(\"Empty pattern.\");\n    my $t;\n    # Get the type ready for Bio::Seq.pm\n    if ($type =~ /nuc|[dr]na/i) {\n\t$t = 'Dna';\n    } elsif ($type =~ /amino|pep|prot/i) {\n\t$t = 'Amino';\n    }\n    $seq =~ tr/a-z/A-Z/;  #ps 8/8/00 Canonicalize to upper case\n    $self->str($seq);\n    $self->type($t);\n\n    return $self;\n}\n\n\n=head1 alphabet_ok\n\n Title     : alphabet_ok\n Usage     : $mypat->alphabet_ok;\n Purpose   : Checks for invalid regexp characters.\n           : Overrides Bio::Seq::alphabet_ok() to allow\n           : additional regexp characters ,.*()[]<>{}^$\n           : in addition to the standard genetic alphabet.\n           : Also untaints the pattern and sets the sequence\n           : object's sequence to the untained string.\n Returns   : Boolean (1 | 0)\n Argument  : n/a\n Throws    : Exception if the pattern contains invalid characters.\n Comments  : Does not call the superclass method.\n           : Actually permits any alphanumeric, not just the\n           : standard genetic alphabet.\n\n\n#----------------'\nsub alphabet_ok {\n#----------------\n    my( $self) = @_;\n\n    return 1 if $self->{'_alphabet_checked'};\n\n    $self->{'_alphabet_checked'} = 1;\n\n    my $pat = $self->seq();\n\n    if($pat =~ /[^$Regexp_chars]/io) {\n\t$self->throw(\"Pattern contains invalid characters: $pat\",\n\t\t     'Legal characters: a-z,A-Z,0-9,,.*()[]<>{}^$ ');\n    }\n\n    # Untaint pattern (makes code taint-safe).\n    $pat  =~ /([$Regexp_chars]+)/io;\n    $self->setseq(uc($1));\n#    print STDERR \"\\npattern ok: $pat\\n\";\n    1;\n}\n\n=head1 expand\n\n Title     : expand\n Usage     : $seqpat_object->expand();\n Purpose   : Expands the sequence pattern using special ambiguity codes.\n Example   : $pat = $seq_pat->expand();\n Returns   : String containing fully expanded sequence pattern\n Argument  : n/a\n Throws    : Exception if sequence type is not recognized\n           : (i.e., is not one of [DR]NA, Amino)\n\nSee Also   : L<Extended Alphabet Support>, L<_expand_pep>(), L<_expand_nuc>()\n\n\n#----------\nsub expand {\n#----------\n    my $self = shift;\n\n    if($self->type =~ /[DR]na/i) { $self->_expand_nuc(); }\n    elsif($self->type =~ /Amino/i) { $self->_expand_pep(); }\n    else{\n\t$self->throw(\"Don't know how to expand ${\\$self->type} patterns.\\n\");\n    }\n}\n\n\n=head1 _expand_pep\n\n Title     : _expand_pep\n Usage     : n/a; automatically called by expand()\n Purpose   : Expands peptide patterns\n Returns   : String (the expanded pattern)\n Argument  : String (the unexpanded pattern)\n Throws    : n/a\n\nSee Also   : L<expand>(), L<_expand_nuc>()","parameters":[{"label":"$self"},{"label":"$pat"}]},"name":"_expand_pep","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"_expand_pep","localvar":"my","kind":13,"line":353},{"line":353,"containerName":"_expand_pep","kind":13,"name":"$pat"},{"containerName":"_expand_pep","kind":13,"name":"$pat","line":354},{"name":"$self","containerName":"_expand_pep","kind":13,"line":354},{"kind":12,"containerName":"_expand_pep","name":"str","line":354},{"name":"$pat","kind":13,"containerName":"_expand_pep","line":355},{"line":356,"name":"$pat","kind":13,"containerName":"_expand_pep"},{"line":357,"kind":13,"containerName":"_expand_pep","name":"$pat"},{"containerName":"_expand_pep","kind":13,"name":"$pat","line":361},{"line":362,"name":"$pat","kind":13,"containerName":"_expand_pep"},{"line":363,"containerName":"_expand_pep","kind":13,"name":"$pat"},{"line":364,"kind":13,"containerName":"_expand_pep","name":"$pat"},{"kind":13,"containerName":"_expand_pep","name":"$pat","line":365},{"containerName":"_expand_pep","kind":13,"name":"$pat","line":367},{"line":368,"containerName":"_expand_pep","kind":13,"name":"$pat"},{"name":"$pat","kind":13,"containerName":"_expand_pep","line":370},{"line":371,"name":"$pat","kind":13,"containerName":"_expand_pep"},{"kind":13,"containerName":"_expand_pep","name":"$pat","line":373}],"detail":"($self,$pat)","definition":"sub"},{"range":{"start":{"line":391,"character":0},"end":{"character":9999,"line":442}},"kind":12,"line":391,"signature":{"parameters":[{"label":"$self"},{"label":"$pat"}],"documentation":"# $Id: SeqPattern.pm 16139 2009-09-18 21:11:23Z cjfields $\n#\n# bioperl module for Bio::Tools::SeqPattern\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by  Steve Chervitz  (sac-at-bioperl.org)\n#\n# Copyright  Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::SeqPattern - represent a sequence pattern or motif\n\n=head1 SYNOPSIS\n\n use Bio::Tools::SeqPattern;\n\n my $pat1     = 'T[GA]AA...TAAT';\n my $pattern1 = Bio::Tools::SeqPattern->new(-SEQ =>$pat1, -TYPE =>'Dna');\n\n my $pat2     = '[VILM]R(GXX){3,2}...[^PG]';\n my $pattern2 = Bio::Tools::SeqPattern->new(-SEQ =>$pat2, -TYPE =>'Amino');\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::SeqPattern> module encapsulates generic data and\nmethods for manipulating regular expressions describing nucleic or\namino acid sequence patterns (a.k.a, \"motifs\").\n\nL<Bio::Tools::SeqPattern> is a concrete class that inherits from L<Bio::Seq>.\n\nThis class grew out of a need to have a standard module for doing routine\ntasks with sequence patterns such as:\n\n  -- Forming a reverse-complement version of a nucleotide sequence pattern\n  -- Expanding patterns containing ambiguity codes\n  -- Checking for invalid regexp characters\n  -- Untainting yet preserving special characters in the pattern\n\nOther features to look for in the future:\n\n  -- Full pattern syntax checking\n  -- Conversion between expanded and condensed forms of the pattern\n\n=head1 MOTIVATIONS\n\nA key motivation for L<Bio::Tools::SeqPattern> is to have a way to\ngenerate a reverse complement of a nucleotide sequence pattern.\nThis makes possible simultaneous pattern matching on both sense and\nanti-sense strands of a query sequence.\n\nIn principle, one could do such a search more inefficiently by testing\nagainst both sense and anti-sense versions of a sequence.\nIt is entirely equivalent to test a regexp containing both sense and\nanti-sense versions of the *pattern* against one copy of the sequence.\nThe latter approach is much more efficient since:\n\n   1) You need only one copy of the sequence.\n   2) Only one regexp is executed.\n   3) Regexp patterns are typically much smaller than sequences.\n\nPatterns can be quite complex and it is often difficult to\ngenerate the reverse complement pattern. The Bioperl SeqPattern.pm\naddresses this problem, providing a convenient set of tools\nfor working with biological sequence regular expressions.\n\nNot all patterns have been tested. If you discover a pattern that\nis not handled properly by Bio::Tools::SeqPattern.pm, please\nsend me some email (sac@bioperl.org). Thanks.\n\n=head1 OTHER FEATURES\n\n=head2 Extended Alphabet Support\n\nThis module supports the same set of ambiguity codes for nucleotide\nsequences as supported by L<Bio::Seq>. These ambiguity codes\ndefine the behavior or the L<expand> method.\n\n ------------------------------------------\n Symbol       Meaning      Nucleic Acid\n ------------------------------------------\n  A            A           (A)denine\n  C            C           (C)ytosine\n  G            G           (G)uanine\n  T            T           (T)hymine\n  U            U           (U)racil\n  M          A or C        a(M)ino group\n  R          A or G        pu(R)ine\n  W          A or T        (W)eak bond\n  S          C or G        (S)trong bond\n  Y          C or T        p(Y)rimidine\n  K          G or T        (K)eto group\n  V        A or C or G\n  H        A or C or T\n  D        A or G or T\n  B        C or G or T\n  X      G or A or T or C\n  N      G or A or T or C\n  .      G or A or T or C\n\n\n\n ------------------------------------------\n Symbol           Meaning\n ------------------------------------------\n A        Alanine\n C        Cysteine\n D        Aspartic Acid\n E        Glutamic Acid\n F        Phenylalanine\n G        Glycine\n H        Histidine\n I        Isoleucine\n K        Lysine\n L        Leucine\n M        Methionine\n N        Asparagine\n P        Proline\n Q        Glutamine\n R        Arginine\n S        Serine\n T        Threonine\n V        Valine\n W        Tryptophan\n Y        Tyrosine\n\n B        Aspartic Acid, Asparagine\n Z        Glutamic Acid, Glutamine\n X        Any amino acid\n .        Any amino acid\n\n\n=head2 Multiple Format Support\n\nUltimately, this module should be able to build SeqPattern.pm objects\nusing a variety of pattern formats such as ProSite, Blocks, Prints, GCG, etc.\nCurrently, this module only supports patterns using a grep-like syntax.\n\n=head1 USAGE\n\nA simple demo script called seq_pattern.pl is included in the examples/\ndirectory of the central Bioperl distribution.\n\n=head1 SEE ALSO\n\nL<Bio::Seq> - Lightweight sequence object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz, sac-at-bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 1997-8 Steve Chervitz. All Rights Reserved.\nThis module is free software; you can redistribute it and/or\nmodify it under the same terms as Perl itself.\n\n\n#\n##\n###\n#### END of main POD documentation.\n###\n##\n#'\n# CREATED : 28 Aug 1997\n\n\npackage Bio::Tools::SeqPattern;\n\nuse base qw(Bio::Root::Root);\nuse strict;\nuse vars qw ($ID);\n$ID  = 'Bio::Tools::SeqPattern';\n\n## These constants may be more appropriate in a Bio::Dictionary.pm\n## type of class.\nmy $PURINES      = 'AG';\nmy $PYRIMIDINES  = 'CT';\nmy $BEE      = 'DN';\nmy $ZED      = 'EQ';\nmy $Regexp_chars = '\\w,.\\*()\\[\\]<>\\{\\}^\\$';  # quoted for use in regexps\n\n## Package variables used in reverse complementing.\nmy (%Processed_braces, %Processed_asterics);\n\n#####################################################################################\n##                                 CONSTRUCTOR                                     ##\n#####################################################################################\n\n=head1 new\n\n Title     : new\n Usage     : my $seqpat = Bio::Tools::SeqPattern->new();\n Purpose   : Verifies that the type is correct for superclass (Bio::Seq.pm)\n           : and calls superclass constructor last.\n Returns   : n/a\n Argument  : Parameters passed to new()\n Throws    : Exception if the pattern string (seq) is empty.\n Comments  : The process of creating a new SeqPattern.pm object\n           : ensures that the pattern string is untained.\n\nSee Also   : L<Bio::Root::Root::new>,\n             L<Bio::Seq::_initialize>\n\n\n#----------------\nsub new {\n#----------------\n    my($class, %param) = @_;\n\n    my $self = $class->SUPER::new(%param);\n    my ($seq,$type) = $self->_rearrange([qw(SEQ TYPE)], %param);\n\n    $seq || $self->throw(\"Empty pattern.\");\n    my $t;\n    # Get the type ready for Bio::Seq.pm\n    if ($type =~ /nuc|[dr]na/i) {\n\t$t = 'Dna';\n    } elsif ($type =~ /amino|pep|prot/i) {\n\t$t = 'Amino';\n    }\n    $seq =~ tr/a-z/A-Z/;  #ps 8/8/00 Canonicalize to upper case\n    $self->str($seq);\n    $self->type($t);\n\n    return $self;\n}\n\n\n=head1 alphabet_ok\n\n Title     : alphabet_ok\n Usage     : $mypat->alphabet_ok;\n Purpose   : Checks for invalid regexp characters.\n           : Overrides Bio::Seq::alphabet_ok() to allow\n           : additional regexp characters ,.*()[]<>{}^$\n           : in addition to the standard genetic alphabet.\n           : Also untaints the pattern and sets the sequence\n           : object's sequence to the untained string.\n Returns   : Boolean (1 | 0)\n Argument  : n/a\n Throws    : Exception if the pattern contains invalid characters.\n Comments  : Does not call the superclass method.\n           : Actually permits any alphanumeric, not just the\n           : standard genetic alphabet.\n\n\n#----------------'\nsub alphabet_ok {\n#----------------\n    my( $self) = @_;\n\n    return 1 if $self->{'_alphabet_checked'};\n\n    $self->{'_alphabet_checked'} = 1;\n\n    my $pat = $self->seq();\n\n    if($pat =~ /[^$Regexp_chars]/io) {\n\t$self->throw(\"Pattern contains invalid characters: $pat\",\n\t\t     'Legal characters: a-z,A-Z,0-9,,.*()[]<>{}^$ ');\n    }\n\n    # Untaint pattern (makes code taint-safe).\n    $pat  =~ /([$Regexp_chars]+)/io;\n    $self->setseq(uc($1));\n#    print STDERR \"\\npattern ok: $pat\\n\";\n    1;\n}\n\n=head1 expand\n\n Title     : expand\n Usage     : $seqpat_object->expand();\n Purpose   : Expands the sequence pattern using special ambiguity codes.\n Example   : $pat = $seq_pat->expand();\n Returns   : String containing fully expanded sequence pattern\n Argument  : n/a\n Throws    : Exception if sequence type is not recognized\n           : (i.e., is not one of [DR]NA, Amino)\n\nSee Also   : L<Extended Alphabet Support>, L<_expand_pep>(), L<_expand_nuc>()\n\n\n#----------\nsub expand {\n#----------\n    my $self = shift;\n\n    if($self->type =~ /[DR]na/i) { $self->_expand_nuc(); }\n    elsif($self->type =~ /Amino/i) { $self->_expand_pep(); }\n    else{\n\t$self->throw(\"Don't know how to expand ${\\$self->type} patterns.\\n\");\n    }\n}\n\n\n=head1 _expand_pep\n\n Title     : _expand_pep\n Usage     : n/a; automatically called by expand()\n Purpose   : Expands peptide patterns\n Returns   : String (the expanded pattern)\n Argument  : String (the unexpanded pattern)\n Throws    : n/a\n\nSee Also   : L<expand>(), L<_expand_nuc>()\n\n\n#----------------\nsub _expand_pep {\n#----------------\n    my ($self,$pat) = @_;\n    $pat ||= $self->str;\n    $pat =~ s/X/./g;\n    $pat =~ s/^</\\^/;\n    $pat =~ s/>$/\\$/;\n\n    ## Avoid nested situations: [bmnq] --/--> [[$ZED]mnq]\n    ## Yet correctly deal with: fze[bmnq] ---> f[$BEE]e[$ZEDmnq]\n    if($pat =~ /\\[\\w*[BZ]\\w*\\]/) {\n\t$pat =~ s/\\[(\\w*)B(\\w*)\\]/\\[$1$ZED$2\\]/g;\n\t$pat =~ s/\\[(\\w*)Z(\\w*)\\]/\\[$1$BEE$2\\]/g;\n\t$pat =~ s/B/\\[$ZED\\]/g;\n\t$pat =~ s/Z/\\[$BEE\\]/g;\n    } else {\n\t$pat =~ s/B/\\[$ZED\\]/g;\n\t$pat =~ s/Z/\\[$BEE\\]/g;\n    }\n    $pat =~ s/\\((.)\\)/$1/g;  ## Doing these last since:\n    $pat =~ s/\\[(.)\\]/$1/g;  ## Pattern could contain [B] (for example)\n\n    return $pat;\n}\n\n\n\n=head1 _expand_nuc\n\n Title     : _expand_nuc\n Purpose   : Expands nucleotide patterns\n Returns   : String (the expanded pattern)\n Argument  : String (the unexpanded pattern)\n Throws    : n/a\n\nSee Also   : L<expand>(), L<_expand_pep>()","label":"_expand_nuc($self,$pat)"},"name":"_expand_nuc","containerName":"main::","children":[{"line":393,"kind":13,"localvar":"my","containerName":"_expand_nuc","name":"$self","definition":"my"},{"containerName":"_expand_nuc","kind":13,"name":"$pat","line":393},{"name":"$pat","containerName":"_expand_nuc","kind":13,"line":395},{"kind":13,"containerName":"_expand_nuc","name":"$self","line":395},{"name":"str","kind":12,"containerName":"_expand_nuc","line":395},{"name":"$pat","containerName":"_expand_nuc","kind":13,"line":396},{"line":397,"containerName":"_expand_nuc","kind":13,"name":"$pat"},{"line":398,"containerName":"_expand_nuc","kind":13,"name":"$pat"},{"line":399,"kind":13,"containerName":"_expand_nuc","name":"$pat"},{"containerName":"_expand_nuc","kind":13,"name":"$pat","line":400},{"containerName":"_expand_nuc","kind":13,"name":"$pat","line":401},{"line":405,"kind":13,"containerName":"_expand_nuc","name":"$pat"},{"kind":13,"containerName":"_expand_nuc","name":"$pat","line":406},{"line":407,"containerName":"_expand_nuc","kind":13,"name":"$pat"},{"line":408,"name":"$pat","kind":13,"containerName":"_expand_nuc"},{"name":"$pat","kind":13,"containerName":"_expand_nuc","line":409},{"line":410,"name":"$pat","kind":13,"containerName":"_expand_nuc"},{"containerName":"_expand_nuc","kind":13,"name":"$pat","line":411},{"kind":13,"containerName":"_expand_nuc","name":"$pat","line":412},{"line":413,"containerName":"_expand_nuc","kind":13,"name":"$pat"},{"name":"$pat","containerName":"_expand_nuc","kind":13,"line":414},{"line":415,"kind":13,"containerName":"_expand_nuc","name":"$pat"},{"line":416,"name":"$pat","containerName":"_expand_nuc","kind":13},{"kind":13,"containerName":"_expand_nuc","name":"$pat","line":417},{"containerName":"_expand_nuc","kind":13,"name":"$pat","line":418},{"line":419,"kind":13,"containerName":"_expand_nuc","name":"$pat"},{"line":420,"name":"$pat","kind":13,"containerName":"_expand_nuc"},{"containerName":"_expand_nuc","kind":13,"name":"$pat","line":421},{"kind":13,"containerName":"_expand_nuc","name":"$pat","line":422},{"containerName":"_expand_nuc","kind":13,"name":"$pat","line":423},{"containerName":"_expand_nuc","kind":13,"name":"$pat","line":424},{"line":425,"name":"$pat","kind":13,"containerName":"_expand_nuc"},{"line":427,"name":"$pat","containerName":"_expand_nuc","kind":13},{"line":428,"kind":13,"containerName":"_expand_nuc","name":"$pat"},{"line":429,"name":"$pat","kind":13,"containerName":"_expand_nuc"},{"containerName":"_expand_nuc","kind":13,"name":"$pat","line":430},{"containerName":"_expand_nuc","kind":13,"name":"$pat","line":431},{"line":432,"kind":13,"containerName":"_expand_nuc","name":"$pat"},{"containerName":"_expand_nuc","kind":13,"name":"$pat","line":433},{"line":434,"containerName":"_expand_nuc","kind":13,"name":"$pat"},{"line":435,"name":"$pat","kind":13,"containerName":"_expand_nuc"},{"kind":13,"containerName":"_expand_nuc","name":"$pat","line":436},{"name":"$pat","kind":13,"containerName":"_expand_nuc","line":438},{"kind":13,"containerName":"_expand_nuc","name":"$pat","line":439},{"line":441,"name":"$pat","containerName":"_expand_nuc","kind":13}],"detail":"($self,$pat)","definition":"sub"},{"children":[{"localvar":"my","kind":13,"containerName":"revcom","name":"$self","line":475,"definition":"my"},{"kind":13,"containerName":"revcom","name":"$expand","line":475},{"name":"$self","containerName":"revcom","kind":13,"line":477},{"name":"type","containerName":"revcom","kind":12,"line":477},{"line":478,"containerName":"revcom","kind":13,"name":"$self"},{"line":478,"kind":12,"containerName":"revcom","name":"throw"},{"line":482,"kind":13,"containerName":"revcom","name":"$expand"},{"line":483,"localvar":"my","kind":13,"containerName":"revcom","name":"$str","definition":"my"},{"name":"$self","kind":13,"containerName":"revcom","line":483},{"name":"str","containerName":"revcom","kind":12,"line":483},{"kind":13,"containerName":"revcom","name":"$str","line":484},{"line":485,"name":"$rev","localvar":"my","kind":13,"containerName":"revcom","definition":"my"},{"containerName":"revcom","kind":13,"name":"$str","line":485},{"kind":13,"containerName":"revcom","name":"$rev","line":486},{"name":"$expand","containerName":"revcom","kind":13,"line":488},{"containerName":"revcom","kind":13,"name":"$rev","line":489},{"line":489,"containerName":"revcom","kind":13,"name":"$self"},{"name":"_expand_nuc","kind":12,"containerName":"revcom","line":489},{"line":489,"containerName":"revcom","kind":13,"name":"$rev"},{"line":493,"name":"%Processed_braces","containerName":"revcom","kind":13},{"name":"%Processed_asterics","kind":13,"containerName":"revcom","line":494},{"definition":"my","line":496,"localvar":"my","kind":13,"containerName":"revcom","name":"$fixrev"},{"kind":13,"containerName":"revcom","name":"$rev","line":496},{"kind":13,"containerName":"revcom","name":"$fixrev","line":499},{"kind":13,"containerName":"revcom","name":"$fixrev","line":499},{"containerName":"revcom","kind":13,"name":"$fixrev","line":502},{"line":502,"name":"$fixrev","kind":13,"containerName":"revcom"},{"kind":13,"containerName":"revcom","name":"$fixrev","line":505},{"line":505,"name":"$fixrev","kind":13,"containerName":"revcom"},{"containerName":"revcom","kind":13,"name":"$fixrev","line":508},{"name":"$fixrev","kind":13,"containerName":"revcom","line":508},{"kind":13,"containerName":"revcom","name":"$fixrev","line":512},{"line":512,"kind":13,"containerName":"revcom","name":"$fixrev"},{"name":"$fixrev","containerName":"revcom","kind":13,"line":517},{"name":"$self","kind":13,"containerName":"revcom","line":517},{"kind":12,"containerName":"revcom","name":"type","line":517}],"containerName":"main::","name":"revcom","definition":"sub","detail":"($self,$expand)","line":473,"range":{"end":{"line":518,"character":9999},"start":{"character":0,"line":473}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$expand"}],"documentation":"# $Id: SeqPattern.pm 16139 2009-09-18 21:11:23Z cjfields $\n#\n# bioperl module for Bio::Tools::SeqPattern\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by  Steve Chervitz  (sac-at-bioperl.org)\n#\n# Copyright  Steve Chervitz\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::SeqPattern - represent a sequence pattern or motif\n\n=head1 SYNOPSIS\n\n use Bio::Tools::SeqPattern;\n\n my $pat1     = 'T[GA]AA...TAAT';\n my $pattern1 = Bio::Tools::SeqPattern->new(-SEQ =>$pat1, -TYPE =>'Dna');\n\n my $pat2     = '[VILM]R(GXX){3,2}...[^PG]';\n my $pattern2 = Bio::Tools::SeqPattern->new(-SEQ =>$pat2, -TYPE =>'Amino');\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::SeqPattern> module encapsulates generic data and\nmethods for manipulating regular expressions describing nucleic or\namino acid sequence patterns (a.k.a, \"motifs\").\n\nL<Bio::Tools::SeqPattern> is a concrete class that inherits from L<Bio::Seq>.\n\nThis class grew out of a need to have a standard module for doing routine\ntasks with sequence patterns such as:\n\n  -- Forming a reverse-complement version of a nucleotide sequence pattern\n  -- Expanding patterns containing ambiguity codes\n  -- Checking for invalid regexp characters\n  -- Untainting yet preserving special characters in the pattern\n\nOther features to look for in the future:\n\n  -- Full pattern syntax checking\n  -- Conversion between expanded and condensed forms of the pattern\n\n=head1 MOTIVATIONS\n\nA key motivation for L<Bio::Tools::SeqPattern> is to have a way to\ngenerate a reverse complement of a nucleotide sequence pattern.\nThis makes possible simultaneous pattern matching on both sense and\nanti-sense strands of a query sequence.\n\nIn principle, one could do such a search more inefficiently by testing\nagainst both sense and anti-sense versions of a sequence.\nIt is entirely equivalent to test a regexp containing both sense and\nanti-sense versions of the *pattern* against one copy of the sequence.\nThe latter approach is much more efficient since:\n\n   1) You need only one copy of the sequence.\n   2) Only one regexp is executed.\n   3) Regexp patterns are typically much smaller than sequences.\n\nPatterns can be quite complex and it is often difficult to\ngenerate the reverse complement pattern. The Bioperl SeqPattern.pm\naddresses this problem, providing a convenient set of tools\nfor working with biological sequence regular expressions.\n\nNot all patterns have been tested. If you discover a pattern that\nis not handled properly by Bio::Tools::SeqPattern.pm, please\nsend me some email (sac@bioperl.org). Thanks.\n\n=head1 OTHER FEATURES\n\n=head2 Extended Alphabet Support\n\nThis module supports the same set of ambiguity codes for nucleotide\nsequences as supported by L<Bio::Seq>. These ambiguity codes\ndefine the behavior or the L<expand> method.\n\n ------------------------------------------\n Symbol       Meaning      Nucleic Acid\n ------------------------------------------\n  A            A           (A)denine\n  C            C           (C)ytosine\n  G            G           (G)uanine\n  T            T           (T)hymine\n  U            U           (U)racil\n  M          A or C        a(M)ino group\n  R          A or G        pu(R)ine\n  W          A or T        (W)eak bond\n  S          C or G        (S)trong bond\n  Y          C or T        p(Y)rimidine\n  K          G or T        (K)eto group\n  V        A or C or G\n  H        A or C or T\n  D        A or G or T\n  B        C or G or T\n  X      G or A or T or C\n  N      G or A or T or C\n  .      G or A or T or C\n\n\n\n ------------------------------------------\n Symbol           Meaning\n ------------------------------------------\n A        Alanine\n C        Cysteine\n D        Aspartic Acid\n E        Glutamic Acid\n F        Phenylalanine\n G        Glycine\n H        Histidine\n I        Isoleucine\n K        Lysine\n L        Leucine\n M        Methionine\n N        Asparagine\n P        Proline\n Q        Glutamine\n R        Arginine\n S        Serine\n T        Threonine\n V        Valine\n W        Tryptophan\n Y        Tyrosine\n\n B        Aspartic Acid, Asparagine\n Z        Glutamic Acid, Glutamine\n X        Any amino acid\n .        Any amino acid\n\n\n=head2 Multiple Format Support\n\nUltimately, this module should be able to build SeqPattern.pm objects\nusing a variety of pattern formats such as ProSite, Blocks, Prints, GCG, etc.\nCurrently, this module only supports patterns using a grep-like syntax.\n\n=head1 USAGE\n\nA simple demo script called seq_pattern.pl is included in the examples/\ndirectory of the central Bioperl distribution.\n\n=head1 SEE ALSO\n\nL<Bio::Seq> - Lightweight sequence object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nSteve Chervitz, sac-at-bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 1997-8 Steve Chervitz. All Rights Reserved.\nThis module is free software; you can redistribute it and/or\nmodify it under the same terms as Perl itself.\n\n\n#\n##\n###\n#### END of main POD documentation.\n###\n##\n#'\n# CREATED : 28 Aug 1997\n\n\npackage Bio::Tools::SeqPattern;\n\nuse base qw(Bio::Root::Root);\nuse strict;\nuse vars qw ($ID);\n$ID  = 'Bio::Tools::SeqPattern';\n\n## These constants may be more appropriate in a Bio::Dictionary.pm\n## type of class.\nmy $PURINES      = 'AG';\nmy $PYRIMIDINES  = 'CT';\nmy $BEE      = 'DN';\nmy $ZED      = 'EQ';\nmy $Regexp_chars = '\\w,.\\*()\\[\\]<>\\{\\}^\\$';  # quoted for use in regexps\n\n## Package variables used in reverse complementing.\nmy (%Processed_braces, %Processed_asterics);\n\n#####################################################################################\n##                                 CONSTRUCTOR                                     ##\n#####################################################################################\n\n=head1 new\n\n Title     : new\n Usage     : my $seqpat = Bio::Tools::SeqPattern->new();\n Purpose   : Verifies that the type is correct for superclass (Bio::Seq.pm)\n           : and calls superclass constructor last.\n Returns   : n/a\n Argument  : Parameters passed to new()\n Throws    : Exception if the pattern string (seq) is empty.\n Comments  : The process of creating a new SeqPattern.pm object\n           : ensures that the pattern string is untained.\n\nSee Also   : L<Bio::Root::Root::new>,\n             L<Bio::Seq::_initialize>\n\n\n#----------------\nsub new {\n#----------------\n    my($class, %param) = @_;\n\n    my $self = $class->SUPER::new(%param);\n    my ($seq,$type) = $self->_rearrange([qw(SEQ TYPE)], %param);\n\n    $seq || $self->throw(\"Empty pattern.\");\n    my $t;\n    # Get the type ready for Bio::Seq.pm\n    if ($type =~ /nuc|[dr]na/i) {\n\t$t = 'Dna';\n    } elsif ($type =~ /amino|pep|prot/i) {\n\t$t = 'Amino';\n    }\n    $seq =~ tr/a-z/A-Z/;  #ps 8/8/00 Canonicalize to upper case\n    $self->str($seq);\n    $self->type($t);\n\n    return $self;\n}\n\n\n=head1 alphabet_ok\n\n Title     : alphabet_ok\n Usage     : $mypat->alphabet_ok;\n Purpose   : Checks for invalid regexp characters.\n           : Overrides Bio::Seq::alphabet_ok() to allow\n           : additional regexp characters ,.*()[]<>{}^$\n           : in addition to the standard genetic alphabet.\n           : Also untaints the pattern and sets the sequence\n           : object's sequence to the untained string.\n Returns   : Boolean (1 | 0)\n Argument  : n/a\n Throws    : Exception if the pattern contains invalid characters.\n Comments  : Does not call the superclass method.\n           : Actually permits any alphanumeric, not just the\n           : standard genetic alphabet.\n\n\n#----------------'\nsub alphabet_ok {\n#----------------\n    my( $self) = @_;\n\n    return 1 if $self->{'_alphabet_checked'};\n\n    $self->{'_alphabet_checked'} = 1;\n\n    my $pat = $self->seq();\n\n    if($pat =~ /[^$Regexp_chars]/io) {\n\t$self->throw(\"Pattern contains invalid characters: $pat\",\n\t\t     'Legal characters: a-z,A-Z,0-9,,.*()[]<>{}^$ ');\n    }\n\n    # Untaint pattern (makes code taint-safe).\n    $pat  =~ /([$Regexp_chars]+)/io;\n    $self->setseq(uc($1));\n#    print STDERR \"\\npattern ok: $pat\\n\";\n    1;\n}\n\n=head1 expand\n\n Title     : expand\n Usage     : $seqpat_object->expand();\n Purpose   : Expands the sequence pattern using special ambiguity codes.\n Example   : $pat = $seq_pat->expand();\n Returns   : String containing fully expanded sequence pattern\n Argument  : n/a\n Throws    : Exception if sequence type is not recognized\n           : (i.e., is not one of [DR]NA, Amino)\n\nSee Also   : L<Extended Alphabet Support>, L<_expand_pep>(), L<_expand_nuc>()\n\n\n#----------\nsub expand {\n#----------\n    my $self = shift;\n\n    if($self->type =~ /[DR]na/i) { $self->_expand_nuc(); }\n    elsif($self->type =~ /Amino/i) { $self->_expand_pep(); }\n    else{\n\t$self->throw(\"Don't know how to expand ${\\$self->type} patterns.\\n\");\n    }\n}\n\n\n=head1 _expand_pep\n\n Title     : _expand_pep\n Usage     : n/a; automatically called by expand()\n Purpose   : Expands peptide patterns\n Returns   : String (the expanded pattern)\n Argument  : String (the unexpanded pattern)\n Throws    : n/a\n\nSee Also   : L<expand>(), L<_expand_nuc>()\n\n\n#----------------\nsub _expand_pep {\n#----------------\n    my ($self,$pat) = @_;\n    $pat ||= $self->str;\n    $pat =~ s/X/./g;\n    $pat =~ s/^</\\^/;\n    $pat =~ s/>$/\\$/;\n\n    ## Avoid nested situations: [bmnq] --/--> [[$ZED]mnq]\n    ## Yet correctly deal with: fze[bmnq] ---> f[$BEE]e[$ZEDmnq]\n    if($pat =~ /\\[\\w*[BZ]\\w*\\]/) {\n\t$pat =~ s/\\[(\\w*)B(\\w*)\\]/\\[$1$ZED$2\\]/g;\n\t$pat =~ s/\\[(\\w*)Z(\\w*)\\]/\\[$1$BEE$2\\]/g;\n\t$pat =~ s/B/\\[$ZED\\]/g;\n\t$pat =~ s/Z/\\[$BEE\\]/g;\n    } else {\n\t$pat =~ s/B/\\[$ZED\\]/g;\n\t$pat =~ s/Z/\\[$BEE\\]/g;\n    }\n    $pat =~ s/\\((.)\\)/$1/g;  ## Doing these last since:\n    $pat =~ s/\\[(.)\\]/$1/g;  ## Pattern could contain [B] (for example)\n\n    return $pat;\n}\n\n\n\n=head1 _expand_nuc\n\n Title     : _expand_nuc\n Purpose   : Expands nucleotide patterns\n Returns   : String (the expanded pattern)\n Argument  : String (the unexpanded pattern)\n Throws    : n/a\n\nSee Also   : L<expand>(), L<_expand_pep>()\n\n\n#---------------\nsub _expand_nuc {\n#---------------\n    my ($self,$pat) = @_;\n\n    $pat ||= $self->str;\n    $pat =~ s/N|X/./g;\n    $pat =~ s/pu/R/ig;\n    $pat =~ s/py/Y/ig;\n    $pat =~ s/U/T/g;\n    $pat =~ s/^</\\^/;\n    $pat =~ s/>$/\\$/;\n\n    ## Avoid nested situations: [ya] --/--> [[ct]a]\n    ## Yet correctly deal with: sg[ya] ---> [gc]g[cta]\n    if($pat =~ /\\[\\w*[RYSWMK]\\w*\\]/) {\n\t$pat =~ s/\\[(\\w*)R(\\w*)\\]/\\[$1$PURINES$2\\]/g;\n\t$pat =~ s/\\[(\\w*)Y(\\w*)\\]/\\[$1$PYRIMIDINES$2\\]/g;\n\t$pat =~ s/\\[(\\w*)S(\\w*)\\]/\\[$1GC$2\\]/g;\n\t$pat =~ s/\\[(\\w*)W(\\w*)\\]/\\[$1AT$2\\]/g;\n\t$pat =~ s/\\[(\\w*)M(\\w*)\\]/\\[$1AC$2\\]/g;\n\t$pat =~ s/\\[(\\w*)K(\\w*)\\]/\\[$1GT$2\\]/g;\n\t$pat =~ s/\\[(\\w*)V(\\w*)\\]/\\[$1ACG$2\\]/g;\n\t$pat =~ s/\\[(\\w*)H(\\w*)\\]/\\[$1ACT$2\\]/g;\n\t$pat =~ s/\\[(\\w*)D(\\w*)\\]/\\[$1AGT$2\\]/g;\n\t$pat =~ s/\\[(\\w*)B(\\w*)\\]/\\[$1CGT$2\\]/g;\n\t$pat =~ s/R/\\[$PURINES\\]/g;\n\t$pat =~ s/Y/\\[$PYRIMIDINES\\]/g;\n\t$pat =~ s/S/\\[GC\\]/g;\n\t$pat =~ s/W/\\[AT\\]/g;\n\t$pat =~ s/M/\\[AC\\]/g;\n\t$pat =~ s/K/\\[GT\\]/g;\n\t$pat =~ s/V/\\[ACG\\]/g;\n\t$pat =~ s/H/\\[ACT\\]/g;\n\t$pat =~ s/D/\\[AGT\\]/g;\n\t$pat =~ s/B/\\[CGT\\]/g;\n    } else {\n\t$pat =~ s/R/\\[$PURINES\\]/g;\n\t$pat =~ s/Y/\\[$PYRIMIDINES\\]/g;\n\t$pat =~ s/S/\\[GC\\]/g;\n\t$pat =~ s/W/\\[AT\\]/g;\n\t$pat =~ s/M/\\[AC\\]/g;\n\t$pat =~ s/K/\\[GT\\]/g;\n\t$pat =~ s/V/\\[ACG\\]/g;\n\t$pat =~ s/H/\\[ACT\\]/g;\n\t$pat =~ s/D/\\[AGT\\]/g;\n\t$pat =~ s/B/\\[CGT\\]/g;\n    }\n    $pat =~ s/\\((.)\\)/$1/g;  ## Doing thses last since:\n    $pat =~ s/\\[(.)\\]/$1/g;  ## Pattern could contain [y] (for example)\n\n    return $pat;\n}\n\n\n\n=head1 revcom\n\n Title     : revcom\n Usage     : revcom([1]);\n Purpose   : Forms a pattern capable of recognizing the reverse complement\n           : version of a nucleotide sequence pattern.\n Example   : $pattern_object->revcom();\n           : $pattern_object->revcom(1); ## returns expanded rev complement pattern.\n Returns   : Object reference for a new Bio::Tools::SeqPattern containing\n           : the revcom of the current pattern as its sequence.\n Argument  : (1) boolean (optional) (default= false)\n           :     true : expand the pattern before rev-complementing.\n           :     false: don't expand pattern before or after rev-complementing.\n Throws    : Exception if called for amino acid sequence pattern.\n Comments  : This method permits the simultaneous searching of both\n           : sense and anti-sense versions of a nucleotide pattern\n           : by means of a grep-type of functionality in which any\n           : number of patterns may be or-ed into the recognition\n           : pattern.\n           : Overrides Bio::Seq::revcom() and calls it first thing.\n           : The order of _fixpat() calls is critical.\n\nSee Also   : L<Bio::Seq::revcom>, L</_fixpat_1>, L</_fixpat_2>, L</_fixpat_3>, L</_fixpat_4>, L</_fixpat_5>\n\n-----------'","label":"revcom($self,$expand)"}},{"name":"CORE","kind":12,"containerName":"reverse","line":486},{"name":"_fixpat_1","kind":12,"line":496},{"kind":12,"name":"_fixpat_2","line":499},{"line":502,"kind":12,"name":"_fixpat_3"},{"name":"_fixpat_4","kind":12,"line":505},{"kind":12,"name":"_fixpat_5","line":508},{"line":512,"kind":12,"name":"_fixpat_6"},{"kind":12,"containerName":"Tools::SeqPattern","name":"Bio","line":517},{"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"backtranslate","line":534,"definition":"my"},{"line":537,"name":"$self","kind":13,"containerName":"backtranslate"},{"containerName":"backtranslate","kind":12,"name":"_load_module","line":537},{"kind":12,"containerName":"backtranslate","name":"import","line":538},{"line":540,"containerName":"backtranslate","kind":13,"name":"$self"},{"containerName":"backtranslate","kind":12,"name":"type","line":540},{"name":"$self","containerName":"backtranslate","kind":13,"line":541},{"kind":12,"containerName":"backtranslate","name":"throw","line":541},{"containerName":"backtranslate","kind":12,"name":"new","line":546},{"line":547,"name":"$self","kind":13,"containerName":"backtranslate"},{"line":547,"name":"str","containerName":"backtranslate","kind":12}],"containerName":"main::","name":"backtranslate","definition":"sub","line":533,"kind":12,"range":{"end":{"line":550,"character":9999},"start":{"character":0,"line":533}}},{"kind":12,"containerName":"Tools::SeqPattern::Backtranslate","name":"Bio","line":538},{"name":"_reverse_translate_motif","kind":12,"line":547},{"definition":"sub","children":[{"definition":"my","name":"$pat","kind":13,"localvar":"my","containerName":"_fixpat_1","line":571},{"definition":"my","name":"@done","kind":13,"localvar":"my","containerName":"_fixpat_1","line":574},{"line":574,"containerName":"_fixpat_1","kind":13,"name":"@parts"},{"containerName":"_fixpat_1","kind":13,"name":"$pat","line":576},{"line":576,"name":"@done","containerName":"_fixpat_1","kind":13},{"name":"$pat","containerName":"_fixpat_1","kind":13,"line":576},{"line":577,"kind":13,"containerName":"_fixpat_1","name":"$pat"},{"name":"@parts","kind":13,"containerName":"_fixpat_1","line":580},{"line":580,"name":"$pat","kind":13,"containerName":"_fixpat_1"},{"containerName":"_fixpat_1","kind":13,"name":"@done","line":581},{"kind":13,"containerName":"_fixpat_1","name":"$parts","line":581},{"line":582,"name":"$pat","containerName":"_fixpat_1","kind":13},{"line":582,"name":"$parts","kind":13,"containerName":"_fixpat_1"},{"line":584,"kind":13,"containerName":"_fixpat_1","name":"$pat"},{"line":586,"containerName":"_fixpat_1","kind":13,"name":"$pat"},{"line":586,"name":"@done","containerName":"_fixpat_1","kind":13},{"line":589,"kind":13,"containerName":"_fixpat_1","name":"@done"},{"kind":13,"containerName":"_fixpat_1","name":"$pat","line":591},{"line":591,"name":"@done","containerName":"_fixpat_1","kind":13},{"name":"$pat","containerName":"_fixpat_1","kind":13,"line":591},{"containerName":"_fixpat_1","kind":13,"name":"$pat","line":592},{"name":"@parts","kind":13,"containerName":"_fixpat_1","line":595},{"containerName":"_fixpat_1","kind":13,"name":"$pat","line":595},{"containerName":"_fixpat_1","kind":13,"name":"@done","line":596},{"name":"$parts","kind":13,"containerName":"_fixpat_1","line":596},{"line":597,"kind":13,"containerName":"_fixpat_1","name":"$pat"},{"name":"$parts","kind":13,"containerName":"_fixpat_1","line":597},{"line":599,"name":"$pat","kind":13,"containerName":"_fixpat_1"},{"kind":13,"containerName":"_fixpat_1","name":"$pat","line":601},{"name":"@done","containerName":"_fixpat_1","kind":13,"line":601},{"name":"@done","kind":13,"containerName":"_fixpat_1","line":604},{"containerName":"_fixpat_1","kind":13,"name":"$pat","line":606},{"line":606,"kind":13,"containerName":"_fixpat_1","name":"@done"},{"name":"$pat","containerName":"_fixpat_1","kind":13,"line":606},{"containerName":"_fixpat_1","kind":13,"name":"$pat","line":607},{"name":"$Processed_asterics","kind":13,"containerName":"_fixpat_1","line":608},{"name":"@parts","kind":13,"containerName":"_fixpat_1","line":611},{"containerName":"_fixpat_1","kind":13,"name":"$pat","line":611},{"kind":13,"containerName":"_fixpat_1","name":"@done","line":612},{"line":612,"kind":13,"containerName":"_fixpat_1","name":"$parts"},{"line":613,"containerName":"_fixpat_1","kind":13,"name":"$pat"},{"line":613,"kind":13,"containerName":"_fixpat_1","name":"$parts"},{"line":615,"kind":13,"containerName":"_fixpat_1","name":"$pat"},{"line":617,"containerName":"_fixpat_1","kind":13,"name":"@done"}],"name":"_fixpat_1","containerName":"main::","line":569,"kind":12,"range":{"start":{"character":0,"line":569},"end":{"line":619,"character":9999}}},{"line":638,"range":{"start":{"character":0,"line":638},"end":{"character":9999,"line":658}},"kind":12,"definition":"sub","children":[{"definition":"my","line":640,"localvar":"my","kind":13,"containerName":"_fixpat_2","name":"$pat"},{"line":643,"localvar":"my","kind":13,"containerName":"_fixpat_2","name":"@done","definition":"my"},{"line":643,"kind":13,"containerName":"_fixpat_2","name":"@parts"},{"line":643,"name":"$braces","containerName":"_fixpat_2","kind":13},{"line":646,"kind":13,"containerName":"_fixpat_2","name":"$pat"},{"name":"@done","containerName":"_fixpat_2","kind":13,"line":646},{"name":"$pat","containerName":"_fixpat_2","kind":13,"line":646},{"line":647,"containerName":"_fixpat_2","kind":13,"name":"$braces"},{"kind":13,"containerName":"_fixpat_2","name":"$braces","line":648},{"containerName":"_fixpat_2","kind":13,"name":"$Processed_braces","line":649},{"containerName":"_fixpat_2","kind":13,"name":"@parts","line":651},{"line":651,"name":"$pat","kind":13,"containerName":"_fixpat_2"},{"kind":13,"containerName":"_fixpat_2","name":"@done","line":652},{"kind":13,"containerName":"_fixpat_2","name":"$parts","line":652},{"line":653,"name":"$pat","kind":13,"containerName":"_fixpat_2"},{"line":653,"name":"$parts","containerName":"_fixpat_2","kind":13},{"containerName":"_fixpat_2","kind":13,"name":"$pat","line":655},{"name":"@done","containerName":"_fixpat_2","kind":13,"line":657}],"containerName":"main::","name":"_fixpat_2"},{"kind":12,"range":{"end":{"line":708,"character":9999},"start":{"line":676,"character":0}},"line":676,"name":"_fixpat_3","containerName":"main::","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"_fixpat_3","name":"$pat","line":678},{"name":"@done","kind":13,"localvar":"my","containerName":"_fixpat_3","line":680,"definition":"my"},{"line":680,"name":"@parts","kind":13,"containerName":"_fixpat_3"},{"containerName":"_fixpat_3","kind":13,"name":"$braces","line":680},{"line":680,"name":"$newpat","containerName":"_fixpat_3","kind":13},{"line":680,"name":"$oldpat","kind":13,"containerName":"_fixpat_3"},{"line":683,"kind":13,"containerName":"_fixpat_3","name":"$pat"},{"line":684,"name":"$newpat","kind":13,"containerName":"_fixpat_3"},{"name":"$pat","containerName":"_fixpat_3","kind":13,"line":694},{"line":694,"kind":13,"containerName":"_fixpat_3","name":"$newpat"},{"containerName":"_fixpat_3","kind":13,"name":"$pat","line":696},{"line":697,"kind":13,"containerName":"_fixpat_3","name":"$pat"},{"containerName":"_fixpat_3","kind":13,"name":"@done","line":699},{"containerName":"_fixpat_3","kind":13,"name":"$pat","line":699},{"kind":13,"containerName":"_fixpat_3","name":"@parts","line":701},{"kind":13,"containerName":"_fixpat_3","name":"$pat","line":701},{"containerName":"_fixpat_3","kind":13,"name":"@done","line":702},{"line":702,"containerName":"_fixpat_3","kind":13,"name":"$parts"},{"line":703,"name":"$pat","containerName":"_fixpat_3","kind":13},{"name":"$parts","containerName":"_fixpat_3","kind":13,"line":703},{"name":"$pat","containerName":"_fixpat_3","kind":13,"line":705},{"kind":13,"containerName":"_fixpat_3","name":"@done","line":707}],"definition":"sub"},{"containerName":"main::","name":"_fixpat_4","children":[{"definition":"my","line":728,"kind":13,"localvar":"my","containerName":"_fixpat_4","name":"$pat"},{"name":"@done","kind":13,"localvar":"my","containerName":"_fixpat_4","line":730,"definition":"my"},{"kind":13,"containerName":"_fixpat_4","name":"@parts","line":730},{"line":730,"kind":13,"containerName":"_fixpat_4","name":"$braces"},{"line":730,"name":"$newpat","containerName":"_fixpat_4","kind":13},{"kind":13,"containerName":"_fixpat_4","name":"$oldpat","line":730},{"name":"$pat","containerName":"_fixpat_4","kind":13,"line":734},{"line":735,"name":"$newpat","containerName":"_fixpat_4","kind":13},{"line":736,"name":"$oldpat","kind":13,"containerName":"_fixpat_4"},{"line":738,"kind":13,"containerName":"_fixpat_4","name":"$braces"},{"name":"$braces","kind":13,"containerName":"_fixpat_4","line":739},{"containerName":"_fixpat_4","kind":13,"name":"$braces","line":740},{"line":741,"name":"$Processed_braces","kind":13,"containerName":"_fixpat_4"},{"kind":13,"containerName":"_fixpat_4","name":"$Processed_asterics","line":741},{"line":742,"name":"$pat","containerName":"_fixpat_4","kind":13},{"line":742,"name":"$oldpat","kind":13,"containerName":"_fixpat_4"},{"kind":13,"containerName":"_fixpat_4","name":"$pat","line":745},{"line":745,"containerName":"_fixpat_4","kind":13,"name":"$newpat"},{"line":748,"containerName":"_fixpat_4","kind":13,"name":"$pat"},{"name":"$pat","containerName":"_fixpat_4","kind":13,"line":749},{"line":751,"containerName":"_fixpat_4","kind":13,"name":"@done"},{"name":"$pat","containerName":"_fixpat_4","kind":13,"line":751},{"line":754,"kind":13,"containerName":"_fixpat_4","name":"@parts"},{"containerName":"_fixpat_4","kind":13,"name":"$pat","line":754},{"name":"@done","containerName":"_fixpat_4","kind":13,"line":755},{"name":"$parts","kind":13,"containerName":"_fixpat_4","line":755},{"containerName":"_fixpat_4","kind":13,"name":"$pat","line":756},{"name":"$parts","kind":13,"containerName":"_fixpat_4","line":756},{"name":"$pat","containerName":"_fixpat_4","kind":13,"line":758},{"name":"@done","kind":13,"containerName":"_fixpat_4","line":760}],"definition":"sub","kind":12,"range":{"start":{"line":726,"character":0},"end":{"line":761,"character":9999}},"line":726},{"name":"_fixpat_5","containerName":"main::","children":[{"line":782,"name":"$pat","localvar":"my","kind":13,"containerName":"_fixpat_5","definition":"my"},{"definition":"my","name":"@done","localvar":"my","containerName":"_fixpat_5","kind":13,"line":784},{"name":"@parts","kind":13,"containerName":"_fixpat_5","line":784},{"containerName":"_fixpat_5","kind":13,"name":"$newpat","line":784},{"line":784,"name":"$oldpat","containerName":"_fixpat_5","kind":13},{"name":"$pat","containerName":"_fixpat_5","kind":13,"line":788},{"line":789,"name":"$newpat","containerName":"_fixpat_5","kind":13},{"line":790,"name":"$oldpat","kind":13,"containerName":"_fixpat_5"},{"containerName":"_fixpat_5","kind":13,"name":"$Processed_asterics","line":792},{"line":793,"kind":13,"containerName":"_fixpat_5","name":"$pat"},{"name":"$oldpat","containerName":"_fixpat_5","kind":13,"line":793},{"name":"$pat","kind":13,"containerName":"_fixpat_5","line":796},{"line":796,"kind":13,"containerName":"_fixpat_5","name":"$newpat"},{"kind":13,"containerName":"_fixpat_5","name":"$pat","line":799},{"name":"$pat","kind":13,"containerName":"_fixpat_5","line":800},{"kind":13,"containerName":"_fixpat_5","name":"@done","line":802},{"line":802,"kind":13,"containerName":"_fixpat_5","name":"$pat"},{"line":805,"name":"@parts","kind":13,"containerName":"_fixpat_5"},{"line":805,"name":"$pat","containerName":"_fixpat_5","kind":13},{"line":806,"kind":13,"containerName":"_fixpat_5","name":"@done"},{"kind":13,"containerName":"_fixpat_5","name":"$parts","line":806},{"containerName":"_fixpat_5","kind":13,"name":"$pat","line":807},{"name":"$parts","kind":13,"containerName":"_fixpat_5","line":807},{"line":809,"name":"$pat","kind":13,"containerName":"_fixpat_5"},{"name":"@done","containerName":"_fixpat_5","kind":13,"line":811}],"definition":"sub","kind":12,"range":{"start":{"character":0,"line":780},"end":{"character":9999,"line":812}},"line":780},{"name":"_fixpat_6","containerName":"main::","children":[{"definition":"my","line":843,"kind":13,"localvar":"my","containerName":"_fixpat_6","name":"$pat"},{"line":844,"localvar":"my","containerName":"_fixpat_6","kind":13,"name":"@done","definition":"my"},{"name":"@parts","kind":13,"containerName":"_fixpat_6","line":844},{"line":846,"containerName":"_fixpat_6","kind":13,"name":"@done"},{"line":848,"name":"$pat","kind":13,"containerName":"_fixpat_6"},{"line":848,"name":"@done","kind":13,"containerName":"_fixpat_6"},{"name":"$pat","kind":13,"containerName":"_fixpat_6","line":848},{"definition":"my","line":849,"name":"$quantifier","containerName":"_fixpat_6","localvar":"my","kind":13},{"line":850,"name":"$pat","kind":13,"containerName":"_fixpat_6"},{"line":850,"name":"$quantifier","kind":13,"containerName":"_fixpat_6"},{"kind":13,"containerName":"_fixpat_6","name":"@parts","line":855},{"line":855,"name":"$pat","containerName":"_fixpat_6","kind":13},{"name":"@done","containerName":"_fixpat_6","kind":13,"line":856},{"line":856,"name":"$parts","containerName":"_fixpat_6","kind":13},{"line":857,"name":"$pat","kind":13,"containerName":"_fixpat_6"},{"name":"$parts","kind":13,"containerName":"_fixpat_6","line":857},{"line":859,"kind":13,"containerName":"_fixpat_6","name":"$pat"},{"name":"@done","kind":13,"containerName":"_fixpat_6","line":861}],"definition":"sub","kind":12,"range":{"end":{"character":9999,"line":863},"start":{"line":841,"character":0}},"line":841},{"line":876,"range":{"start":{"line":876,"character":0},"end":{"line":884,"character":9999}},"kind":12,"children":[{"definition":"my","line":877,"localvar":"my","kind":13,"containerName":"str","name":"$obj"},{"line":879,"localvar":"my","kind":13,"containerName":"str","name":"$value","definition":"my"},{"line":880,"name":"$obj","containerName":"str","kind":13},{"containerName":"str","kind":13,"name":"$value","line":880},{"name":"$obj","containerName":"str","kind":13,"line":882}],"name":"str","containerName":"main::","definition":"sub"},{"line":897,"kind":12,"range":{"end":{"line":905,"character":9999},"start":{"character":0,"line":897}},"children":[{"definition":"my","line":898,"name":"$obj","containerName":"type","localvar":"my","kind":13},{"containerName":"type","localvar":"my","kind":13,"name":"$value","line":900,"definition":"my"},{"line":901,"name":"$obj","containerName":"type","kind":13},{"containerName":"type","kind":13,"name":"$value","line":901},{"line":903,"name":"$obj","containerName":"type","kind":13}],"containerName":"main::","name":"type","definition":"sub"}],"version":5}