{"vars":[{"name":"vars","kind":2,"containerName":"","line":89},{"line":95,"containerName":"","kind":2,"name":"base"},{"signature":{"parameters":[{"label":"$self"},{"label":"$lambda"}],"documentation":"1;\n# $Id: RandomDistFunctions.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::RandomDistFunctions\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::RandomDistFunctions - A set of routines useful for\ngenerating random data in different distributions\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::RandomDistFunctions;\n  my $dist = Bio::Tools::RandomDistFunctions->new();\n  for my $v ( 1..1000 ) { \n    my $birth_dist = $dist->rand_birth_distribution($lambda);\n    # ... do something with the variable\n  }\n\n=head1 DESCRIPTION\n\nMost of the code is based on the C implementation of these routines in\nMike Sanderson's r8s's package.  See http://loco.biosci.arizona.edu/r8s/ for\ninformation on his software.\n\nThis code tries to be fast and use available faster BigInt and GMP\nlibrary methods when those modules are available.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nThanks to Mike Sanderson for assistance in the getting this\nimplementation together.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::RandomDistFunctions;\nrequire Exporter;\nuse vars qw(%LOADED @EXPORT_OK); use strict;\n\n#use Math::BigFloat lib => 'GMP,Bit::Vector';\n#use Math::BigInt lib  => 'GMP,Bit::Vector';\nuse POSIX;\n\nuse base qw(Bio::Root::Root);\n\n=head2 birth_distribution\n\n Title   : rand_birth_distribution\n Usage   : my $randvar = $dist->\n            rand_birth_distribution($lambda);\n Function: Returns a random number from a birth process waiting \n           time with a fixed interval\n           1.0.  Times are measured from 0=present,1=root;\n Returns : floating point number\n Args    : $lambda ( > 0 )\n References : This is based on code by Mike Sanders in r8s.\n              Ross, Stochastic Processes, p. 145 for the density","label":"rand_birth_distribution($self,$lambda)"},"range":{"end":{"character":9999,"line":122},"start":{"line":112,"character":0}},"kind":12,"line":112,"detail":"($self,$lambda)","definition":"sub","name":"rand_birth_distribution","containerName":"main::","children":[{"line":113,"kind":13,"localvar":"my","containerName":"rand_birth_distribution","name":"$self","definition":"my"},{"line":113,"name":"$lambda","containerName":"rand_birth_distribution","kind":13},{"kind":13,"containerName":"rand_birth_distribution","name":"$self","line":114},{"line":115,"name":"$self","kind":13,"containerName":"rand_birth_distribution"},{"line":116,"name":"$lambda","kind":13,"containerName":"rand_birth_distribution"},{"line":116,"containerName":"rand_birth_distribution","kind":13,"name":"$self"},{"name":"$lambda","containerName":"rand_birth_distribution","kind":13,"line":118},{"name":"$self","kind":13,"containerName":"rand_birth_distribution","line":119},{"containerName":"rand_birth_distribution","kind":12,"name":"throw","line":119},{"containerName":"rand_birth_distribution","kind":13,"name":"$lambda","line":121},{"kind":13,"containerName":"rand_birth_distribution","name":"$lambda","line":121}]},{"detail":"($self,$param)","definition":"sub","containerName":"main::","name":"rand_geometric_distribution","children":[{"line":139,"name":"$self","containerName":"rand_geometric_distribution","localvar":"my","kind":13,"definition":"my"},{"containerName":"rand_geometric_distribution","kind":13,"name":"$param","line":139},{"line":140,"name":"$self","containerName":"rand_geometric_distribution","kind":13},{"line":141,"kind":13,"containerName":"rand_geometric_distribution","name":"$self"},{"line":142,"name":"$param","kind":13,"containerName":"rand_geometric_distribution"},{"line":142,"containerName":"rand_geometric_distribution","kind":13,"name":"$self"},{"line":144,"name":"$param","kind":13,"containerName":"rand_geometric_distribution"},{"line":145,"name":"$self","containerName":"rand_geometric_distribution","kind":13},{"line":145,"containerName":"rand_geometric_distribution","kind":12,"name":"throw"},{"definition":"my","line":148,"containerName":"rand_geometric_distribution","localvar":"my","kind":13,"name":"$den"},{"kind":13,"containerName":"rand_geometric_distribution","name":"$param","line":149},{"line":150,"name":"$den","containerName":"rand_geometric_distribution","kind":13},{"line":150,"kind":13,"containerName":"rand_geometric_distribution","name":"$param"},{"name":"$param","containerName":"rand_geometric_distribution","kind":13,"line":150},{"line":150,"name":"$param","containerName":"rand_geometric_distribution","kind":13},{"line":152,"name":"$den","containerName":"rand_geometric_distribution","kind":13},{"kind":13,"containerName":"rand_geometric_distribution","name":"$param","line":152},{"containerName":"rand_geometric_distribution","localvar":"my","kind":13,"name":"$z","line":154,"definition":"my"},{"name":"$den","containerName":"rand_geometric_distribution","kind":13,"line":154},{"line":155,"name":"$z","containerName":"rand_geometric_distribution","kind":13}],"signature":{"label":"rand_geometric_distribution($self,$param)","parameters":[{"label":"$self"},{"label":"$param"}],"documentation":"1;\n# $Id: RandomDistFunctions.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::RandomDistFunctions\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::RandomDistFunctions - A set of routines useful for\ngenerating random data in different distributions\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::RandomDistFunctions;\n  my $dist = Bio::Tools::RandomDistFunctions->new();\n  for my $v ( 1..1000 ) { \n    my $birth_dist = $dist->rand_birth_distribution($lambda);\n    # ... do something with the variable\n  }\n\n=head1 DESCRIPTION\n\nMost of the code is based on the C implementation of these routines in\nMike Sanderson's r8s's package.  See http://loco.biosci.arizona.edu/r8s/ for\ninformation on his software.\n\nThis code tries to be fast and use available faster BigInt and GMP\nlibrary methods when those modules are available.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nThanks to Mike Sanderson for assistance in the getting this\nimplementation together.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::RandomDistFunctions;\nrequire Exporter;\nuse vars qw(%LOADED @EXPORT_OK); use strict;\n\n#use Math::BigFloat lib => 'GMP,Bit::Vector';\n#use Math::BigInt lib  => 'GMP,Bit::Vector';\nuse POSIX;\n\nuse base qw(Bio::Root::Root);\n\n=head2 birth_distribution\n\n Title   : rand_birth_distribution\n Usage   : my $randvar = $dist->\n            rand_birth_distribution($lambda);\n Function: Returns a random number from a birth process waiting \n           time with a fixed interval\n           1.0.  Times are measured from 0=present,1=root;\n Returns : floating point number\n Args    : $lambda ( > 0 )\n References : This is based on code by Mike Sanders in r8s.\n              Ross, Stochastic Processes, p. 145 for the density\n\n\nsub rand_birth_distribution{\n   my ($self,$lambda) = @_;\n   if( ! ref($self) && \n       $self !~ /RandomDistFunctions/ ) { \n       $lambda = $self;\n   }\n   unless( $lambda ) { \n       $self->throw(\"Cannot call birth_distribution without a valid lambda value (>0)\");\n   }\n   return 1 - (log(rand(1) * (exp($lambda) - 1)+1)/ $lambda); \n}\n\n\n=head2 rand_geometric_distribution\n\n Title   : rand_geometric_distribution\n Usage   : my $randvar = $dist->rand_geometric_distribution($param);\n Function: Returns a random geometric variate distributed with \n           paramater $param, according to\n           c.d.f. 1 - ( 1- param) ^ n \n Returns : integer\n Args    : $param ( 0 > $param < 1 )"},"kind":12,"range":{"start":{"character":0,"line":138},"end":{"character":9999,"line":163}},"line":138},{"name":"POSIX","kind":12,"containerName":"floor","line":155},{"detail":"($self,$param)","definition":"sub","containerName":"main::","name":"rand_exponentional_distribution","children":[{"name":"$self","containerName":"rand_exponentional_distribution","localvar":"my","kind":13,"line":178,"definition":"my"},{"name":"$param","kind":13,"containerName":"rand_exponentional_distribution","line":178},{"line":179,"kind":13,"containerName":"rand_exponentional_distribution","name":"$self"},{"containerName":"rand_exponentional_distribution","kind":13,"name":"$self","line":180},{"containerName":"rand_exponentional_distribution","kind":13,"name":"$param","line":181},{"name":"$self","kind":13,"containerName":"rand_exponentional_distribution","line":181},{"line":183,"name":"$param","kind":13,"containerName":"rand_exponentional_distribution"},{"line":184,"kind":13,"containerName":"rand_exponentional_distribution","name":"$self"},{"line":184,"containerName":"rand_exponentional_distribution","kind":12,"name":"throw"},{"line":186,"name":"$param","kind":13,"containerName":"rand_exponentional_distribution"}],"signature":{"parameters":[{"label":"$self"},{"label":"$param"}],"documentation":"1;\n# $Id: RandomDistFunctions.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::RandomDistFunctions\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::RandomDistFunctions - A set of routines useful for\ngenerating random data in different distributions\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::RandomDistFunctions;\n  my $dist = Bio::Tools::RandomDistFunctions->new();\n  for my $v ( 1..1000 ) { \n    my $birth_dist = $dist->rand_birth_distribution($lambda);\n    # ... do something with the variable\n  }\n\n=head1 DESCRIPTION\n\nMost of the code is based on the C implementation of these routines in\nMike Sanderson's r8s's package.  See http://loco.biosci.arizona.edu/r8s/ for\ninformation on his software.\n\nThis code tries to be fast and use available faster BigInt and GMP\nlibrary methods when those modules are available.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nThanks to Mike Sanderson for assistance in the getting this\nimplementation together.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::RandomDistFunctions;\nrequire Exporter;\nuse vars qw(%LOADED @EXPORT_OK); use strict;\n\n#use Math::BigFloat lib => 'GMP,Bit::Vector';\n#use Math::BigInt lib  => 'GMP,Bit::Vector';\nuse POSIX;\n\nuse base qw(Bio::Root::Root);\n\n=head2 birth_distribution\n\n Title   : rand_birth_distribution\n Usage   : my $randvar = $dist->\n            rand_birth_distribution($lambda);\n Function: Returns a random number from a birth process waiting \n           time with a fixed interval\n           1.0.  Times are measured from 0=present,1=root;\n Returns : floating point number\n Args    : $lambda ( > 0 )\n References : This is based on code by Mike Sanders in r8s.\n              Ross, Stochastic Processes, p. 145 for the density\n\n\nsub rand_birth_distribution{\n   my ($self,$lambda) = @_;\n   if( ! ref($self) && \n       $self !~ /RandomDistFunctions/ ) { \n       $lambda = $self;\n   }\n   unless( $lambda ) { \n       $self->throw(\"Cannot call birth_distribution without a valid lambda value (>0)\");\n   }\n   return 1 - (log(rand(1) * (exp($lambda) - 1)+1)/ $lambda); \n}\n\n\n=head2 rand_geometric_distribution\n\n Title   : rand_geometric_distribution\n Usage   : my $randvar = $dist->rand_geometric_distribution($param);\n Function: Returns a random geometric variate distributed with \n           paramater $param, according to\n           c.d.f. 1 - ( 1- param) ^ n \n Returns : integer\n Args    : $param ( 0 > $param < 1 )\n\n\n\nsub rand_geometric_distribution{\n   my ($self,$param) = @_;\n   if( ! ref($self) && \n       $self !~ /RandomDistFunctions/ ) { \n       $param = $self;\n   }\n   unless( $param ) { \n       $self->throw(\"Cannot call rand_geometric_distribution without a valid param value (>0)\");\n   }\n\n   my $den;\n   if( $param < 1e-8) { \n       $den = (-1 * $param) - ( $param * $param ) / 2;\n   } else { \n       $den = log(1 - $param);\n   }\n   my $z = log(1 - rand(1)) / $den;\n   return POSIX::floor($z) + 1;\n   # MSanderson comments from r8s code\n   # Is this the right truncation of the real-valued expression above?\n   # YES\n   # Checked by reference to the expected mean of the distribution in\n   # 100,000 replicates\n   # EX = 1/param Var = (1-param)/param^2 See Olkin, Gleser, and\n   # Derman, p. 193ff. Probability Models and Applications, 1980.\n}\n\n=head2 rand_exponentional_distribution\n\n Title   : rand_exponentional_distribution\n Usage   : my $var = $dist->rand_exponentional_distribution($param);\n Function: Returns a random exponential variate distributed with parameter\n           $param, according to c.d.f 1 - e^(-param * x)\n Returns : floating point number \n Args    : $param ( > 0 )","label":"rand_exponentional_distribution($self,$param)"},"range":{"start":{"line":177,"character":0},"end":{"character":9999,"line":187}},"kind":12,"line":177},{"children":[{"localvar":"my","kind":13,"containerName":"rand_normal_distribution","name":"$gset","line":201,"definition":"my"},{"containerName":"rand_normal_distribution","localvar":"my","kind":13,"name":"$rsq","line":202,"definition":"my"},{"kind":13,"containerName":"rand_normal_distribution","name":"$v1","line":202},{"kind":13,"containerName":"rand_normal_distribution","name":"$v2","line":202},{"name":"$v1","containerName":"rand_normal_distribution","kind":13,"line":204},{"containerName":"rand_normal_distribution","kind":13,"name":"$v2","line":205},{"line":206,"name":"$rsq","containerName":"rand_normal_distribution","kind":13},{"name":"$v1","containerName":"rand_normal_distribution","kind":13,"line":206},{"name":"$v2","containerName":"rand_normal_distribution","kind":13,"line":206},{"containerName":"rand_normal_distribution","kind":13,"name":"$rsq","line":207},{"line":207,"name":"$rsq","containerName":"rand_normal_distribution","kind":13},{"line":208,"localvar":"my","kind":13,"containerName":"rand_normal_distribution","name":"$fac","definition":"my"},{"line":208,"name":"$rsq","containerName":"rand_normal_distribution","kind":13},{"line":208,"kind":13,"containerName":"rand_normal_distribution","name":"$rsq"},{"name":"$gset","containerName":"rand_normal_distribution","kind":13,"line":209},{"containerName":"rand_normal_distribution","kind":13,"name":"$v1","line":209},{"kind":13,"containerName":"rand_normal_distribution","name":"$fac","line":209},{"kind":13,"containerName":"rand_normal_distribution","name":"$v2","line":210},{"line":210,"kind":13,"containerName":"rand_normal_distribution","name":"$fac"}],"containerName":"main::","name":"rand_normal_distribution","definition":"sub","line":200,"kind":12,"range":{"start":{"character":0,"line":200},"end":{"line":211,"character":9999}}}],"version":5}