{"version":5,"vars":[{"line":159,"name":"base","kind":2,"containerName":""},{"definition":"our","name":"$MotifTag","containerName":"main::","kind":13,"line":161},{"line":161,"name":"$SrcTag","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$DescTag","line":161},{"signature":{"label":"_initialize($self,@args)","documentation":"1;\n# $Id: RNAMotif.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::RNAMotif\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::RNAMotif - A parser for RNAMotif output\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::RNAMotif;\n  my $parser = Bio::Tools::RNAMotif->new(-file => $rna_output,\n                                        -motiftag => 'protein_bind'\n                                        -desctag => 'TRAP_binding');\n  #parse the results\n  while( my $motif = $parser->next_prediction) {\n    # do something here\n  }\n\n=head1 DESCRIPTION\n\nParses raw RNAMotif output.  RNAMotif uses a RNA profile, consisting\nof sequence and structural elements stored in a descriptor file, to\nsearch for potential motifs in a DNA sequence file.  For more\ninformation, see:\n\nMacke TJ, Ecker DJ, Gutell RR, Gautheret D, Case DA, Sampath R. \nRNAMotif, an RNA secondary structure definition and search algorithm.\nNucleic Acids Res. 2001 Nov 15;29(22):4724-35. \nhttp://www.scripps.edu/mb/case/casegr-sh-3.5.html.\n\nThis module is not currently complete.  As is, it will parse raw\nRNAMotif output (i.e. information not passed through the secondary\nprograms rmfmt or rm2ct) and pack information into\nBio::SeqFeature::Generic objects.  Currently, parsing extra output\nutilized by the sprintf() function in an RNAMotif descriptor is not\nimplemented; this information is instead packed into the score tag,\nwhich can be accessed by using the following:\n\n  my ($score) = $feature->score; \n\nIf the score contains anything besides a digit, it will throw a\nwarning that sprintf() may have been used.\nSeveral values have also been added in the 'tag' hash.  These can be\naccessed using the following syntax:\n\n  my ($entry) = $feature->get_Annotations('secstructure');\n\nAdded tags are : \n\n   descline     - entire description line (in case the regex used for\n                  sequence ID doesn't adequately catch the name\n   descfile     - name of the descriptor file (may include path to file)\n   secstrucure  - contains structural information from the descriptor\n                  used as a query\n   sequence     - sequence of motif, separated by spaces according to\n                  matches to the structure in the descriptor (in\n                  SecStructure).\n\nSee t/RNAMotif.t for example usage.\n\nThe clean_features method can also be used to return a list of seqfeatures (in a\nBio::SeqFeature::Collection object) that are within a particular region.   RNAMotif\nis prone with some descriptors to returning redundant hits; an attempt to rectify\nthis problem is attempted with RNAMotif's companion program rmprune, which returns\nthe structure with the longest helices (and theoretically the best scoring structure).\nHowever, this doesn't take into account alternative foldings which may score better.\nThis method adds a bit more flexibility, giving the user the ability to screen folds\nbased on where the feature is found and the score.  Passing a positive integer x\nscreens SeqFeatures based on the highest score within x bp, while a negative integer\nscreens based on the lowest score. So, to return the highest scoring values within\n20 bp (likely using an arbitrary scroing system in the SCORE section of a descriptor\nfile), one could use:\n\n  $list = $obj->clean_features(20); \n\n... and returning the lowest scoring structures within the same region (when the\nscore is based on calculated free energies from efn2) can be accomplished\nby the following:\n\n  $list = $obj->clean_features(-20);\n\nIf you wanted the best feature in a sequence, you could set this to a large number,\npreferrably on that exceeds the bases in a sequence\n\n  $list = $obj->clean_features(10000000);\n\nEach seqfeature in the collection can then be acted upon:\n\n  @sf = $list->get_all_features;\n  for my $f (@sf) {\n    # do crazy things here\n  }\n\nAt some point a more complicated feature object may be used to support\nthis data rather than forcing most of the information into tag/value\npairs in a SeqFeature::Generic.  This will hopefully allow for more\nflexible analysis of data (specifically RNA secondary structural\ndata).  It works for now...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::RNAMotif;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Collection;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nour($MotifTag,$SrcTag,$DescTag) = qw(misc_binding RNAMotif rnamotif);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::RNAMotif->new();\n Function: Builds a new Bio::Tools::RNAMotif object \n Returns : an instance of Bio::Tools::RNAMotif\n Args    : -fh/-file for input filename\n           -motiftag => primary tag used in gene features (default 'misc_binding')\n           -desctag => tag used for display_name name (default 'rnamotif')\n           -srctag  => source tag used in all features (default 'RNAMotif')","parameters":[{"label":"$self"},{"label":"@args"}]},"range":{"end":{"line":190,"character":9999},"start":{"character":0,"line":176}},"kind":12,"line":176,"detail":"($self,@args)","definition":"sub","containerName":"main::","name":"_initialize","children":[{"definition":"my","line":177,"kind":13,"localvar":"my","containerName":"_initialize","name":"$self"},{"line":177,"containerName":"_initialize","kind":13,"name":"@args"},{"line":178,"kind":13,"containerName":"_initialize","name":"$self"},{"line":178,"name":"warn","kind":12,"containerName":"_initialize"},{"line":179,"name":"$self","kind":13,"containerName":"_initialize"},{"line":179,"kind":13,"containerName":"_initialize","name":"@args"},{"definition":"my","line":180,"localvar":"my","containerName":"_initialize","kind":13,"name":"$motiftag"},{"line":180,"kind":13,"containerName":"_initialize","name":"$desctag"},{"name":"$srctag","containerName":"_initialize","kind":13,"line":180},{"line":180,"containerName":"_initialize","kind":13,"name":"$self"},{"line":184,"kind":13,"containerName":"_initialize","name":"@args"},{"name":"$self","kind":13,"containerName":"_initialize","line":185},{"name":"motif_tag","containerName":"_initialize","kind":12,"line":185},{"containerName":"_initialize","kind":13,"name":"$motiftag","line":185},{"line":185,"name":"$motiftag","kind":13,"containerName":"_initialize"},{"name":"$MotifTag","kind":13,"containerName":"_initialize","line":185},{"line":186,"kind":13,"containerName":"_initialize","name":"$self"},{"name":"source_tag","kind":12,"containerName":"_initialize","line":186},{"name":"$srctag","containerName":"_initialize","kind":13,"line":186},{"containerName":"_initialize","kind":13,"name":"$srctag","line":186},{"name":"$SrcTag","kind":13,"containerName":"_initialize","line":186},{"kind":13,"containerName":"_initialize","name":"$self","line":187},{"containerName":"_initialize","kind":12,"name":"desc_tag","line":187},{"line":187,"name":"$desctag","kind":13,"containerName":"_initialize"},{"line":187,"kind":13,"containerName":"_initialize","name":"$desctag"},{"line":187,"name":"$DescTag","containerName":"_initialize","kind":13},{"containerName":"_initialize","kind":13,"name":"$self","line":188}]},{"kind":12,"containerName":"_initialize","name":"SUPER","line":179},{"kind":12,"containerName":"_rearrange","name":"SUPER","line":180},{"name":"motif_tag","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"motif_tag","name":"$self","line":212,"definition":"my"},{"line":214,"name":"$self","kind":13,"containerName":"motif_tag"},{"line":215,"kind":13,"containerName":"motif_tag","name":"$self"}],"definition":"sub","kind":12,"range":{"start":{"line":211,"character":0},"end":{"character":9999,"line":216}},"line":211},{"children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"source_tag","line":231},{"line":233,"containerName":"source_tag","kind":13,"name":"$self"},{"line":234,"containerName":"source_tag","kind":13,"name":"$self"}],"name":"source_tag","containerName":"main::","definition":"sub","line":230,"kind":12,"range":{"start":{"line":230,"character":0},"end":{"character":9999,"line":235}}},{"line":253,"range":{"start":{"character":0,"line":253},"end":{"character":9999,"line":258}},"kind":12,"children":[{"line":254,"containerName":"desc_tag","localvar":"my","kind":13,"name":"$self","definition":"my"},{"name":"$self","kind":13,"containerName":"desc_tag","line":256},{"containerName":"desc_tag","kind":13,"name":"$self","line":257}],"name":"desc_tag","containerName":"main::","definition":"sub"},{"containerName":"main::","name":"analysis_method","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"analysis_method","line":273,"definition":"my"},{"line":273,"containerName":"analysis_method","kind":13,"name":"$method"},{"line":274,"name":"$method","containerName":"analysis_method","kind":13},{"containerName":"analysis_method","kind":13,"name":"$method","line":274},{"line":275,"name":"$self","containerName":"analysis_method","kind":13},{"line":275,"name":"throw","kind":12,"containerName":"analysis_method"},{"line":275,"containerName":"analysis_method","kind":13,"name":"$self"},{"kind":13,"containerName":"analysis_method","name":"$self","line":277},{"kind":13,"containerName":"analysis_method","name":"$method","line":277}],"detail":"($self,$method)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":271},"end":{"line":278,"character":9999}},"line":271,"signature":{"label":"analysis_method($self,$method)","parameters":[{"label":"$self"},{"label":"$method"}],"documentation":"1;\n# $Id: RNAMotif.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::RNAMotif\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::RNAMotif - A parser for RNAMotif output\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::RNAMotif;\n  my $parser = Bio::Tools::RNAMotif->new(-file => $rna_output,\n                                        -motiftag => 'protein_bind'\n                                        -desctag => 'TRAP_binding');\n  #parse the results\n  while( my $motif = $parser->next_prediction) {\n    # do something here\n  }\n\n=head1 DESCRIPTION\n\nParses raw RNAMotif output.  RNAMotif uses a RNA profile, consisting\nof sequence and structural elements stored in a descriptor file, to\nsearch for potential motifs in a DNA sequence file.  For more\ninformation, see:\n\nMacke TJ, Ecker DJ, Gutell RR, Gautheret D, Case DA, Sampath R. \nRNAMotif, an RNA secondary structure definition and search algorithm.\nNucleic Acids Res. 2001 Nov 15;29(22):4724-35. \nhttp://www.scripps.edu/mb/case/casegr-sh-3.5.html.\n\nThis module is not currently complete.  As is, it will parse raw\nRNAMotif output (i.e. information not passed through the secondary\nprograms rmfmt or rm2ct) and pack information into\nBio::SeqFeature::Generic objects.  Currently, parsing extra output\nutilized by the sprintf() function in an RNAMotif descriptor is not\nimplemented; this information is instead packed into the score tag,\nwhich can be accessed by using the following:\n\n  my ($score) = $feature->score; \n\nIf the score contains anything besides a digit, it will throw a\nwarning that sprintf() may have been used.\nSeveral values have also been added in the 'tag' hash.  These can be\naccessed using the following syntax:\n\n  my ($entry) = $feature->get_Annotations('secstructure');\n\nAdded tags are : \n\n   descline     - entire description line (in case the regex used for\n                  sequence ID doesn't adequately catch the name\n   descfile     - name of the descriptor file (may include path to file)\n   secstrucure  - contains structural information from the descriptor\n                  used as a query\n   sequence     - sequence of motif, separated by spaces according to\n                  matches to the structure in the descriptor (in\n                  SecStructure).\n\nSee t/RNAMotif.t for example usage.\n\nThe clean_features method can also be used to return a list of seqfeatures (in a\nBio::SeqFeature::Collection object) that are within a particular region.   RNAMotif\nis prone with some descriptors to returning redundant hits; an attempt to rectify\nthis problem is attempted with RNAMotif's companion program rmprune, which returns\nthe structure with the longest helices (and theoretically the best scoring structure).\nHowever, this doesn't take into account alternative foldings which may score better.\nThis method adds a bit more flexibility, giving the user the ability to screen folds\nbased on where the feature is found and the score.  Passing a positive integer x\nscreens SeqFeatures based on the highest score within x bp, while a negative integer\nscreens based on the lowest score. So, to return the highest scoring values within\n20 bp (likely using an arbitrary scroing system in the SCORE section of a descriptor\nfile), one could use:\n\n  $list = $obj->clean_features(20); \n\n... and returning the lowest scoring structures within the same region (when the\nscore is based on calculated free energies from efn2) can be accomplished\nby the following:\n\n  $list = $obj->clean_features(-20);\n\nIf you wanted the best feature in a sequence, you could set this to a large number,\npreferrably on that exceeds the bases in a sequence\n\n  $list = $obj->clean_features(10000000);\n\nEach seqfeature in the collection can then be acted upon:\n\n  @sf = $list->get_all_features;\n  for my $f (@sf) {\n    # do crazy things here\n  }\n\nAt some point a more complicated feature object may be used to support\nthis data rather than forcing most of the information into tag/value\npairs in a SeqFeature::Generic.  This will hopefully allow for more\nflexible analysis of data (specifically RNA secondary structural\ndata).  It works for now...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::RNAMotif;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Collection;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nour($MotifTag,$SrcTag,$DescTag) = qw(misc_binding RNAMotif rnamotif);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::RNAMotif->new();\n Function: Builds a new Bio::Tools::RNAMotif object \n Returns : an instance of Bio::Tools::RNAMotif\n Args    : -fh/-file for input filename\n           -motiftag => primary tag used in gene features (default 'misc_binding')\n           -desctag => tag used for display_name name (default 'rnamotif')\n           -srctag  => source tag used in all features (default 'RNAMotif')\n\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->warn('Use of this module is deprecated.  Use Bio::SearchIO::rnamotif instead');\n  $self->SUPER::_initialize(@args);\n  my ($motiftag,$desctag,$srctag) =  $self->SUPER::_rearrange([qw(MOTIFTAG\n                                                                  DESCTAG\n                                                                  SRCTAG\n                                 )],\n                                  @args);\n  $self->motif_tag(defined $motiftag ? $motiftag : $MotifTag);\n  $self->source_tag(defined $srctag ? $srctag : $SrcTag);\n  $self->desc_tag(defined $desctag ? $desctag : $DescTag);\n  $self->{'_sec_structure' => '',\n          '_dfile' => ''};\n}\n\n=head2 motif_tag\n\n Title   : motif_tag\n Usage   : $obj->motif_tag($newval)\n Function: Get/Set the value used for 'motif_tag', which is used for setting the\n           primary_tag.\n           Default is 'misc_binding' as set by the global $MotifTag.\n           'misc_binding' is used here because a conserved RNA motif is capable\n           of binding proteins (regulatory proteins), antisense RNA (siRNA),\n           small molecules (riboswitches), or nothing at all (tRNA,\n           terminators, etc.).  It is recommended that this be changed to other\n           tags ('misc_RNA', 'protein_binding', 'tRNA', etc.) where appropriate.\n           For more information, see:\n           http://www.ncbi.nlm.nih.gov/collab/FT/index.html\n Returns : value of motif_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub motif_tag{\n    my $self = shift;\n\n    return $self->{'motif_tag'} = shift if @_;\n    return $self->{'motif_tag'};\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $obj->source_tag($newval)\n Function: Get/Set the value used for the 'source_tag'.\n           Default is 'RNAMotif' as set by the global $SrcTag\n Returns : value of source_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub source_tag{\n    my $self = shift;\n\n    return $self->{'source_tag'} = shift if @_;\n    return $self->{'source_tag'};\n}\n\n\n=head2 desc_tag\n\n Title   : desc_tag\n Usage   : $obj->desc_tag($newval)\n Function: Get/Set the value used for the query motif.  This will be placed in\n           the tag '-display_name'.  Default is 'rnamotif' as set by the global\n           $DescTag.  Use this to manually set the descriptor (motif searched for).\n           Since there is no way for this module to tell what the motif is from the\n           name of the descriptor file or the RNAMotif output, this should\n           be set every time an RNAMotif object is instantiated for clarity\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub desc_tag{\n    my $self = shift;\n\n    return $self->{'desc_tag'} = shift if @_;\n    return $self->{'desc_tag'};\n}\n\n=head2 analysis_method\n\n Usage     : $obj->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /RNAMotif/i.\n Returns   : String\n Argument  : n/a"}},{"kind":12,"containerName":"analysis_method","name":"SUPER","line":277},{"children":[{"definition":"my","containerName":"next_feature","localvar":"my","kind":13,"name":"$self","line":298},{"line":298,"containerName":"next_feature","kind":13,"name":"@args"},{"containerName":"next_feature","kind":13,"name":"$self","line":302},{"name":"next_prediction","kind":12,"containerName":"next_feature","line":302},{"line":302,"kind":13,"containerName":"next_feature","name":"@args"}],"name":"next_feature","containerName":"main::","definition":"sub","detail":"($self,@args)","line":297,"range":{"end":{"line":303,"character":9999},"start":{"line":297,"character":0}},"kind":12,"signature":{"documentation":"1;\n# $Id: RNAMotif.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::RNAMotif\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::RNAMotif - A parser for RNAMotif output\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::RNAMotif;\n  my $parser = Bio::Tools::RNAMotif->new(-file => $rna_output,\n                                        -motiftag => 'protein_bind'\n                                        -desctag => 'TRAP_binding');\n  #parse the results\n  while( my $motif = $parser->next_prediction) {\n    # do something here\n  }\n\n=head1 DESCRIPTION\n\nParses raw RNAMotif output.  RNAMotif uses a RNA profile, consisting\nof sequence and structural elements stored in a descriptor file, to\nsearch for potential motifs in a DNA sequence file.  For more\ninformation, see:\n\nMacke TJ, Ecker DJ, Gutell RR, Gautheret D, Case DA, Sampath R. \nRNAMotif, an RNA secondary structure definition and search algorithm.\nNucleic Acids Res. 2001 Nov 15;29(22):4724-35. \nhttp://www.scripps.edu/mb/case/casegr-sh-3.5.html.\n\nThis module is not currently complete.  As is, it will parse raw\nRNAMotif output (i.e. information not passed through the secondary\nprograms rmfmt or rm2ct) and pack information into\nBio::SeqFeature::Generic objects.  Currently, parsing extra output\nutilized by the sprintf() function in an RNAMotif descriptor is not\nimplemented; this information is instead packed into the score tag,\nwhich can be accessed by using the following:\n\n  my ($score) = $feature->score; \n\nIf the score contains anything besides a digit, it will throw a\nwarning that sprintf() may have been used.\nSeveral values have also been added in the 'tag' hash.  These can be\naccessed using the following syntax:\n\n  my ($entry) = $feature->get_Annotations('secstructure');\n\nAdded tags are : \n\n   descline     - entire description line (in case the regex used for\n                  sequence ID doesn't adequately catch the name\n   descfile     - name of the descriptor file (may include path to file)\n   secstrucure  - contains structural information from the descriptor\n                  used as a query\n   sequence     - sequence of motif, separated by spaces according to\n                  matches to the structure in the descriptor (in\n                  SecStructure).\n\nSee t/RNAMotif.t for example usage.\n\nThe clean_features method can also be used to return a list of seqfeatures (in a\nBio::SeqFeature::Collection object) that are within a particular region.   RNAMotif\nis prone with some descriptors to returning redundant hits; an attempt to rectify\nthis problem is attempted with RNAMotif's companion program rmprune, which returns\nthe structure with the longest helices (and theoretically the best scoring structure).\nHowever, this doesn't take into account alternative foldings which may score better.\nThis method adds a bit more flexibility, giving the user the ability to screen folds\nbased on where the feature is found and the score.  Passing a positive integer x\nscreens SeqFeatures based on the highest score within x bp, while a negative integer\nscreens based on the lowest score. So, to return the highest scoring values within\n20 bp (likely using an arbitrary scroing system in the SCORE section of a descriptor\nfile), one could use:\n\n  $list = $obj->clean_features(20); \n\n... and returning the lowest scoring structures within the same region (when the\nscore is based on calculated free energies from efn2) can be accomplished\nby the following:\n\n  $list = $obj->clean_features(-20);\n\nIf you wanted the best feature in a sequence, you could set this to a large number,\npreferrably on that exceeds the bases in a sequence\n\n  $list = $obj->clean_features(10000000);\n\nEach seqfeature in the collection can then be acted upon:\n\n  @sf = $list->get_all_features;\n  for my $f (@sf) {\n    # do crazy things here\n  }\n\nAt some point a more complicated feature object may be used to support\nthis data rather than forcing most of the information into tag/value\npairs in a SeqFeature::Generic.  This will hopefully allow for more\nflexible analysis of data (specifically RNA secondary structural\ndata).  It works for now...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::RNAMotif;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Collection;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nour($MotifTag,$SrcTag,$DescTag) = qw(misc_binding RNAMotif rnamotif);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::RNAMotif->new();\n Function: Builds a new Bio::Tools::RNAMotif object \n Returns : an instance of Bio::Tools::RNAMotif\n Args    : -fh/-file for input filename\n           -motiftag => primary tag used in gene features (default 'misc_binding')\n           -desctag => tag used for display_name name (default 'rnamotif')\n           -srctag  => source tag used in all features (default 'RNAMotif')\n\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->warn('Use of this module is deprecated.  Use Bio::SearchIO::rnamotif instead');\n  $self->SUPER::_initialize(@args);\n  my ($motiftag,$desctag,$srctag) =  $self->SUPER::_rearrange([qw(MOTIFTAG\n                                                                  DESCTAG\n                                                                  SRCTAG\n                                 )],\n                                  @args);\n  $self->motif_tag(defined $motiftag ? $motiftag : $MotifTag);\n  $self->source_tag(defined $srctag ? $srctag : $SrcTag);\n  $self->desc_tag(defined $desctag ? $desctag : $DescTag);\n  $self->{'_sec_structure' => '',\n          '_dfile' => ''};\n}\n\n=head2 motif_tag\n\n Title   : motif_tag\n Usage   : $obj->motif_tag($newval)\n Function: Get/Set the value used for 'motif_tag', which is used for setting the\n           primary_tag.\n           Default is 'misc_binding' as set by the global $MotifTag.\n           'misc_binding' is used here because a conserved RNA motif is capable\n           of binding proteins (regulatory proteins), antisense RNA (siRNA),\n           small molecules (riboswitches), or nothing at all (tRNA,\n           terminators, etc.).  It is recommended that this be changed to other\n           tags ('misc_RNA', 'protein_binding', 'tRNA', etc.) where appropriate.\n           For more information, see:\n           http://www.ncbi.nlm.nih.gov/collab/FT/index.html\n Returns : value of motif_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub motif_tag{\n    my $self = shift;\n\n    return $self->{'motif_tag'} = shift if @_;\n    return $self->{'motif_tag'};\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $obj->source_tag($newval)\n Function: Get/Set the value used for the 'source_tag'.\n           Default is 'RNAMotif' as set by the global $SrcTag\n Returns : value of source_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub source_tag{\n    my $self = shift;\n\n    return $self->{'source_tag'} = shift if @_;\n    return $self->{'source_tag'};\n}\n\n\n=head2 desc_tag\n\n Title   : desc_tag\n Usage   : $obj->desc_tag($newval)\n Function: Get/Set the value used for the query motif.  This will be placed in\n           the tag '-display_name'.  Default is 'rnamotif' as set by the global\n           $DescTag.  Use this to manually set the descriptor (motif searched for).\n           Since there is no way for this module to tell what the motif is from the\n           name of the descriptor file or the RNAMotif output, this should\n           be set every time an RNAMotif object is instantiated for clarity\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub desc_tag{\n    my $self = shift;\n\n    return $self->{'desc_tag'} = shift if @_;\n    return $self->{'desc_tag'};\n}\n\n=head2 analysis_method\n\n Usage     : $obj->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /RNAMotif/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /RNAMotif/i)) {\n    $self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $obj->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the RNAMotif result\n           file. Call this method repeatedly until FALSE is returned.\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    : None (at present)","parameters":[{"label":"$self"},{"label":"@args"}],"label":"next_feature($self,@args)"}},{"definition":"sub","detail":"($self)","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"next_prediction","line":319,"definition":"my"},{"line":320,"localvar":"my","kind":13,"containerName":"next_prediction","name":"$motiftag","definition":"my"},{"line":320,"name":"$srctag","kind":13,"containerName":"next_prediction"},{"line":320,"containerName":"next_prediction","kind":13,"name":"$desctag"},{"line":320,"kind":13,"containerName":"next_prediction","name":"$self"},{"line":320,"name":"motif_tag","kind":12,"containerName":"next_prediction"},{"line":321,"name":"$self","containerName":"next_prediction","kind":13},{"name":"source_tag","kind":12,"containerName":"next_prediction","line":321},{"name":"$self","kind":13,"containerName":"next_prediction","line":322},{"name":"desc_tag","kind":12,"containerName":"next_prediction","line":322},{"line":323,"name":"$score","localvar":"my","kind":13,"containerName":"next_prediction","definition":"my"},{"containerName":"next_prediction","kind":13,"name":"$strand","line":323},{"line":323,"name":"$start","containerName":"next_prediction","kind":13},{"line":323,"name":"$length","kind":13,"containerName":"next_prediction"},{"line":323,"name":"$sequence","kind":13,"containerName":"next_prediction"},{"line":323,"containerName":"next_prediction","kind":13,"name":"$end"},{"line":323,"kind":13,"containerName":"next_prediction","name":"$seqid"},{"line":323,"kind":13,"containerName":"next_prediction","name":"$description"},{"name":"$self","kind":13,"containerName":"next_prediction","line":324},{"kind":12,"containerName":"next_prediction","name":"_readline","line":324},{"name":"$self","containerName":"next_prediction","kind":13,"line":327},{"kind":13,"containerName":"next_prediction","name":"$self","line":330},{"kind":13,"containerName":"next_prediction","name":"$self","line":332},{"line":332,"kind":12,"containerName":"next_prediction","name":"_readline"},{"line":335,"containerName":"next_prediction","kind":13,"name":"$seqid"},{"name":"$description","containerName":"next_prediction","kind":13,"line":336},{"line":337,"name":"$seqid","kind":13,"containerName":"next_prediction"},{"kind":13,"containerName":"next_prediction","name":"$seqid","line":338},{"kind":13,"containerName":"next_prediction","name":"$score","line":350},{"line":350,"name":"$strand","containerName":"next_prediction","kind":13},{"line":350,"name":"$start","kind":13,"containerName":"next_prediction"},{"line":350,"name":"$length","kind":13,"containerName":"next_prediction"},{"line":350,"containerName":"next_prediction","kind":13,"name":"$sequence"},{"name":"$end","containerName":"next_prediction","kind":13,"line":350},{"line":352,"kind":13,"containerName":"next_prediction","name":"$strand"},{"line":353,"name":"$end","containerName":"next_prediction","kind":13},{"containerName":"next_prediction","kind":13,"name":"$start","line":353},{"line":353,"name":"$length","containerName":"next_prediction","kind":13},{"line":354,"name":"$strand","kind":13,"containerName":"next_prediction"},{"name":"$end","containerName":"next_prediction","kind":13,"line":356},{"name":"$start","kind":13,"containerName":"next_prediction","line":356},{"kind":13,"containerName":"next_prediction","name":"$length","line":356},{"line":357,"name":"$start","kind":13,"containerName":"next_prediction"},{"line":357,"containerName":"next_prediction","kind":13,"name":"$end"},{"line":357,"name":"$strand","kind":13,"containerName":"next_prediction"},{"name":"$end","containerName":"next_prediction","kind":13,"line":357},{"line":357,"containerName":"next_prediction","kind":13,"name":"$start"},{"name":"$gene","kind":13,"localvar":"my","containerName":"next_prediction","line":359,"definition":"my"},{"name":"new","containerName":"next_prediction","kind":12,"line":359},{"kind":13,"containerName":"next_prediction","name":"$seqid","line":359},{"containerName":"next_prediction","kind":13,"name":"$start","line":360},{"line":361,"name":"$end","containerName":"next_prediction","kind":13},{"name":"$strand","kind":13,"containerName":"next_prediction","line":362},{"line":363,"name":"$score","containerName":"next_prediction","kind":13},{"containerName":"next_prediction","kind":13,"name":"$motiftag","line":364},{"name":"$srctag","containerName":"next_prediction","kind":13,"line":365},{"name":"$desctag","containerName":"next_prediction","kind":13,"line":366},{"kind":13,"containerName":"next_prediction","name":"$description","line":368},{"kind":13,"containerName":"next_prediction","name":"$self","line":369},{"kind":13,"containerName":"next_prediction","name":"$self","line":370},{"name":"$sequence","containerName":"next_prediction","kind":13,"line":371},{"line":372,"name":"$gene","kind":13,"containerName":"next_prediction"}],"containerName":"main::","name":"next_prediction","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: RNAMotif.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::RNAMotif\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::RNAMotif - A parser for RNAMotif output\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::RNAMotif;\n  my $parser = Bio::Tools::RNAMotif->new(-file => $rna_output,\n                                        -motiftag => 'protein_bind'\n                                        -desctag => 'TRAP_binding');\n  #parse the results\n  while( my $motif = $parser->next_prediction) {\n    # do something here\n  }\n\n=head1 DESCRIPTION\n\nParses raw RNAMotif output.  RNAMotif uses a RNA profile, consisting\nof sequence and structural elements stored in a descriptor file, to\nsearch for potential motifs in a DNA sequence file.  For more\ninformation, see:\n\nMacke TJ, Ecker DJ, Gutell RR, Gautheret D, Case DA, Sampath R. \nRNAMotif, an RNA secondary structure definition and search algorithm.\nNucleic Acids Res. 2001 Nov 15;29(22):4724-35. \nhttp://www.scripps.edu/mb/case/casegr-sh-3.5.html.\n\nThis module is not currently complete.  As is, it will parse raw\nRNAMotif output (i.e. information not passed through the secondary\nprograms rmfmt or rm2ct) and pack information into\nBio::SeqFeature::Generic objects.  Currently, parsing extra output\nutilized by the sprintf() function in an RNAMotif descriptor is not\nimplemented; this information is instead packed into the score tag,\nwhich can be accessed by using the following:\n\n  my ($score) = $feature->score; \n\nIf the score contains anything besides a digit, it will throw a\nwarning that sprintf() may have been used.\nSeveral values have also been added in the 'tag' hash.  These can be\naccessed using the following syntax:\n\n  my ($entry) = $feature->get_Annotations('secstructure');\n\nAdded tags are : \n\n   descline     - entire description line (in case the regex used for\n                  sequence ID doesn't adequately catch the name\n   descfile     - name of the descriptor file (may include path to file)\n   secstrucure  - contains structural information from the descriptor\n                  used as a query\n   sequence     - sequence of motif, separated by spaces according to\n                  matches to the structure in the descriptor (in\n                  SecStructure).\n\nSee t/RNAMotif.t for example usage.\n\nThe clean_features method can also be used to return a list of seqfeatures (in a\nBio::SeqFeature::Collection object) that are within a particular region.   RNAMotif\nis prone with some descriptors to returning redundant hits; an attempt to rectify\nthis problem is attempted with RNAMotif's companion program rmprune, which returns\nthe structure with the longest helices (and theoretically the best scoring structure).\nHowever, this doesn't take into account alternative foldings which may score better.\nThis method adds a bit more flexibility, giving the user the ability to screen folds\nbased on where the feature is found and the score.  Passing a positive integer x\nscreens SeqFeatures based on the highest score within x bp, while a negative integer\nscreens based on the lowest score. So, to return the highest scoring values within\n20 bp (likely using an arbitrary scroing system in the SCORE section of a descriptor\nfile), one could use:\n\n  $list = $obj->clean_features(20); \n\n... and returning the lowest scoring structures within the same region (when the\nscore is based on calculated free energies from efn2) can be accomplished\nby the following:\n\n  $list = $obj->clean_features(-20);\n\nIf you wanted the best feature in a sequence, you could set this to a large number,\npreferrably on that exceeds the bases in a sequence\n\n  $list = $obj->clean_features(10000000);\n\nEach seqfeature in the collection can then be acted upon:\n\n  @sf = $list->get_all_features;\n  for my $f (@sf) {\n    # do crazy things here\n  }\n\nAt some point a more complicated feature object may be used to support\nthis data rather than forcing most of the information into tag/value\npairs in a SeqFeature::Generic.  This will hopefully allow for more\nflexible analysis of data (specifically RNA secondary structural\ndata).  It works for now...\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::RNAMotif;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Collection;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nour($MotifTag,$SrcTag,$DescTag) = qw(misc_binding RNAMotif rnamotif);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::RNAMotif->new();\n Function: Builds a new Bio::Tools::RNAMotif object \n Returns : an instance of Bio::Tools::RNAMotif\n Args    : -fh/-file for input filename\n           -motiftag => primary tag used in gene features (default 'misc_binding')\n           -desctag => tag used for display_name name (default 'rnamotif')\n           -srctag  => source tag used in all features (default 'RNAMotif')\n\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->warn('Use of this module is deprecated.  Use Bio::SearchIO::rnamotif instead');\n  $self->SUPER::_initialize(@args);\n  my ($motiftag,$desctag,$srctag) =  $self->SUPER::_rearrange([qw(MOTIFTAG\n                                                                  DESCTAG\n                                                                  SRCTAG\n                                 )],\n                                  @args);\n  $self->motif_tag(defined $motiftag ? $motiftag : $MotifTag);\n  $self->source_tag(defined $srctag ? $srctag : $SrcTag);\n  $self->desc_tag(defined $desctag ? $desctag : $DescTag);\n  $self->{'_sec_structure' => '',\n          '_dfile' => ''};\n}\n\n=head2 motif_tag\n\n Title   : motif_tag\n Usage   : $obj->motif_tag($newval)\n Function: Get/Set the value used for 'motif_tag', which is used for setting the\n           primary_tag.\n           Default is 'misc_binding' as set by the global $MotifTag.\n           'misc_binding' is used here because a conserved RNA motif is capable\n           of binding proteins (regulatory proteins), antisense RNA (siRNA),\n           small molecules (riboswitches), or nothing at all (tRNA,\n           terminators, etc.).  It is recommended that this be changed to other\n           tags ('misc_RNA', 'protein_binding', 'tRNA', etc.) where appropriate.\n           For more information, see:\n           http://www.ncbi.nlm.nih.gov/collab/FT/index.html\n Returns : value of motif_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub motif_tag{\n    my $self = shift;\n\n    return $self->{'motif_tag'} = shift if @_;\n    return $self->{'motif_tag'};\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $obj->source_tag($newval)\n Function: Get/Set the value used for the 'source_tag'.\n           Default is 'RNAMotif' as set by the global $SrcTag\n Returns : value of source_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub source_tag{\n    my $self = shift;\n\n    return $self->{'source_tag'} = shift if @_;\n    return $self->{'source_tag'};\n}\n\n\n=head2 desc_tag\n\n Title   : desc_tag\n Usage   : $obj->desc_tag($newval)\n Function: Get/Set the value used for the query motif.  This will be placed in\n           the tag '-display_name'.  Default is 'rnamotif' as set by the global\n           $DescTag.  Use this to manually set the descriptor (motif searched for).\n           Since there is no way for this module to tell what the motif is from the\n           name of the descriptor file or the RNAMotif output, this should\n           be set every time an RNAMotif object is instantiated for clarity\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub desc_tag{\n    my $self = shift;\n\n    return $self->{'desc_tag'} = shift if @_;\n    return $self->{'desc_tag'};\n}\n\n=head2 analysis_method\n\n Usage     : $obj->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /RNAMotif/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /RNAMotif/i)) {\n    $self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $obj->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the RNAMotif result\n           file. Call this method repeatedly until FALSE is returned.\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    : None (at present)\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $obj->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the RNAMotif result\n           file. Call this method repeatedly until FALSE is returned.\n Returns : A Bio::SeqFeature::Generic object\n Args    : None (at present)","label":"next_prediction($self)"},"line":318,"range":{"end":{"line":375,"character":9999},"start":{"line":318,"character":0}},"kind":12},{"kind":12,"containerName":"SeqFeature::Generic","name":"Bio","line":359},{"range":{"end":{"line":425,"character":9999},"start":{"character":0,"line":388}},"kind":12,"line":388,"name":"clean_features","containerName":"main::","children":[{"definition":"my","line":389,"name":"$self","containerName":"clean_features","localvar":"my","kind":13},{"definition":"my","line":390,"localvar":"my","kind":13,"containerName":"clean_features","name":"$bp"},{"kind":13,"containerName":"clean_features","name":"$self","line":391},{"kind":12,"containerName":"clean_features","name":"throw","line":391},{"line":391,"kind":13,"containerName":"clean_features","name":"$bp"},{"name":"$self","kind":13,"containerName":"clean_features","line":392},{"line":392,"name":"throw","containerName":"clean_features","kind":12},{"line":392,"containerName":"clean_features","kind":13,"name":"$bp"},{"line":392,"containerName":"clean_features","kind":13,"name":"$bp"},{"definition":"my","line":393,"name":"$b","kind":13,"localvar":"my","containerName":"clean_features"},{"line":393,"containerName":"clean_features","kind":13,"name":"$sf2"},{"definition":"my","line":394,"kind":13,"localvar":"my","containerName":"clean_features","name":"@list"},{"definition":"my","line":395,"kind":13,"localvar":"my","containerName":"clean_features","name":"@features"},{"line":396,"containerName":"clean_features","localvar":"my","kind":13,"name":"$pred","definition":"my"},{"kind":13,"containerName":"clean_features","name":"$self","line":396},{"kind":12,"containerName":"clean_features","name":"next_prediction","line":396},{"containerName":"clean_features","kind":13,"name":"@features","line":397},{"name":"$pred","containerName":"clean_features","kind":13,"line":397},{"name":"@features","kind":13,"containerName":"clean_features","line":399},{"name":"$b","kind":13,"containerName":"clean_features","line":400},{"name":"@features","kind":13,"containerName":"clean_features","line":400},{"name":"$b","containerName":"clean_features","kind":13,"line":400},{"kind":13,"containerName":"clean_features","name":"$sf2","line":401},{"kind":13,"containerName":"clean_features","name":"@features","line":401},{"name":"$sf2","containerName":"clean_features","kind":13,"line":403},{"line":404,"containerName":"clean_features","kind":13,"name":"$b"},{"name":"seq_id","kind":12,"containerName":"clean_features","line":404},{"line":404,"name":"$sf2","containerName":"clean_features","kind":13},{"name":"seq_id","containerName":"clean_features","kind":12,"line":404},{"line":406,"containerName":"clean_features","kind":13,"name":"$b"},{"name":"start","kind":12,"containerName":"clean_features","line":406},{"line":406,"containerName":"clean_features","kind":13,"name":"$sf2"},{"line":406,"kind":12,"containerName":"clean_features","name":"start"},{"line":406,"name":"$bp","kind":13,"containerName":"clean_features"},{"name":"$bp","kind":13,"containerName":"clean_features","line":408},{"name":"$b","containerName":"clean_features","kind":13,"line":408},{"line":408,"name":"score","kind":12,"containerName":"clean_features"},{"line":408,"containerName":"clean_features","kind":13,"name":"$sf2"},{"line":408,"containerName":"clean_features","kind":12,"name":"score"},{"line":409,"kind":13,"containerName":"clean_features","name":"$bp"},{"kind":13,"containerName":"clean_features","name":"$b","line":409},{"line":409,"kind":12,"containerName":"clean_features","name":"score"},{"containerName":"clean_features","kind":13,"name":"$sf2","line":409},{"line":409,"name":"score","kind":12,"containerName":"clean_features"},{"name":"$b","containerName":"clean_features","kind":13,"line":410},{"containerName":"clean_features","kind":13,"name":"$sf2","line":410},{"line":416,"name":"@list","kind":13,"containerName":"clean_features"},{"line":416,"name":"$b","containerName":"clean_features","kind":13},{"name":"$b","containerName":"clean_features","kind":13,"line":417},{"name":"$sf2","containerName":"clean_features","kind":13,"line":417},{"name":"@list","containerName":"clean_features","kind":13,"line":421},{"line":421,"name":"$b","kind":13,"containerName":"clean_features"},{"name":"$b","kind":13,"containerName":"clean_features","line":421},{"line":422,"name":"$col","localvar":"my","kind":13,"containerName":"clean_features","definition":"my"},{"containerName":"clean_features","kind":12,"name":"new","line":422},{"name":"$col","kind":13,"containerName":"clean_features","line":423},{"line":423,"name":"add_features","containerName":"clean_features","kind":12},{"name":"@list","kind":13,"containerName":"clean_features","line":423},{"line":424,"kind":13,"containerName":"clean_features","name":"$col"}],"definition":"sub"},{"line":422,"kind":12,"containerName":"SeqFeature::Collection","name":"Bio"}]}