{"vars":[{"containerName":"","kind":2,"name":"base","line":89},{"detail":"($class,@args)","definition":"sub","name":"new","containerName":"main::","children":[{"definition":"my","line":107,"containerName":"new","localvar":"my","kind":13,"name":"$class"},{"line":107,"name":"@args","kind":13,"containerName":"new"},{"name":"@args","containerName":"new","kind":13,"line":110},{"containerName":"new","kind":13,"name":"@args","line":110},{"definition":"my","line":112,"name":"$self","localvar":"my","containerName":"new","kind":13},{"line":112,"containerName":"new","kind":13,"name":"$class"},{"line":112,"containerName":"new","kind":13,"name":"@args"},{"definition":"my","localvar":"my","containerName":"new","kind":13,"name":"$url","line":114},{"name":"$seq","kind":13,"containerName":"new","line":114},{"name":"$form","kind":13,"containerName":"new","line":114},{"line":114,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"containerName":"new","name":"_rearrange","line":114},{"name":"@args","kind":13,"containerName":"new","line":114},{"definition":"my","containerName":"new","localvar":"my","kind":13,"name":"$browser","line":116},{"line":116,"name":"new","kind":12,"containerName":"new"},{"definition":"my","name":"$response","localvar":"my","containerName":"new","kind":13,"line":117},{"line":120,"kind":13,"containerName":"new","name":"$response"},{"line":120,"containerName":"new","kind":13,"name":"$browser"},{"containerName":"new","kind":12,"name":"post","line":120},{"line":120,"name":"$url","containerName":"new","kind":13},{"line":122,"kind":13,"containerName":"new","name":"$form"},{"name":"$seq","kind":13,"containerName":"new","line":123},{"containerName":"new","kind":13,"name":"$self","line":128},{"name":"throw","kind":12,"containerName":"new","line":128},{"name":"$response","kind":13,"containerName":"new","line":128},{"line":128,"name":"status_line","kind":12,"containerName":"new"},{"line":128,"name":"$response","kind":13,"containerName":"new"},{"kind":12,"containerName":"new","name":"is_success","line":128},{"line":129,"kind":13,"containerName":"new","name":"$self"},{"name":"throw","containerName":"new","kind":12,"line":129},{"line":129,"kind":13,"containerName":"new","name":"$response"},{"name":"content_type","kind":12,"containerName":"new","line":129},{"line":129,"containerName":"new","kind":13,"name":"$response"},{"line":129,"name":"content_type","kind":12,"containerName":"new"},{"definition":"my","line":131,"kind":13,"localvar":"my","containerName":"new","name":"$protParamOutput"},{"name":"$response","containerName":"new","kind":13,"line":131},{"line":131,"containerName":"new","kind":12,"name":"decoded_content"},{"name":"$self","containerName":"new","kind":13,"line":133},{"name":"$protParamOutput","kind":13,"containerName":"new","line":133},{"name":"$self","containerName":"new","kind":13,"line":135},{"line":135,"kind":13,"containerName":"new","name":"$class"}],"signature":{"documentation":"# $Id: Protparam.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Tools::Protparam\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Richard Dobson, r.j.dobson at qmul dot ac dot uk\n#\n# Copyright Richard Dobson\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Protparam - submit to and parse output from protparam ;\n\n=head1 SYNOPSIS\n\n  my $gb = new Bio::DB::GenBank(-retrievaltype => 'tempfile' , \n                                -format => 'Fasta');\n  my @ids=qw(O14521 O43709 O43826);\n  my $seqio = $gb->get_Stream_by_acc(\\@ids );\n\n  while( my $seq =  $seqio->next_seq ) {\n\n\tmy $pp = Protparam->new(seq=>$seq->seq);\n\n\tprint \n\t\"ID : \", $seq->display_id,\"\\n\",\n\t\"Amino acid number : \",$pp->amino_acid_number(),\"\\n\",\n\t\"Number of negative amino acids : \",$pp->num_neg(),\"\\n\",\n\t\"Number of positive amino acids : \",$pp->num_pos(),\"\\n\",\n\t\"Molecular weight : \",$pp->molecular_weight(),\"\\n\",\n\t\"Theoretical pI : \",$pp->theoretical_pI(),\"\\n\",\n\t\"Total number of atoms : \", $pp->total_atoms(),\"\\n\",\n\t\"Number of carbon atoms : \",$pp->num_carbon(),\"\\n\",\n\t\"Number of hydrogen atoms : \",$pp->num_hydrogen(),\"\\n\",\n\t\"Number of nitrogen atoms : \",$pp->num_nitro(),\"\\n\",\n\t\"Number of oxygen atoms : \",$pp->num_oxygen(),\"\\n\",\n\t\"Number of sulphur atoms : \",$pp->num_sulphur(),\"\\n\",\n\t\"Half life : \", $pp->half_life(),\"\\n\",\n\t\"Instability Index : \", $pp->instability_index(),\"\\n\",\n\t\"Stability class : \", $pp->stability(),\"\\n\",\n\t\"Aliphatic_index : \",$pp->aliphatic_index(),\"\\n\",\n\t\"Gravy : \", $pp->gravy(),\"\\n\",\n\t\"Composition of A : \", $pp->AA_comp('A'),\"\\n\",\n\t\"Composition of R : \", $pp->AA_comp('R'),\"\\n\",\n\t\"Composition of N : \", $pp->AA_comp('N'),\"\\n\",\n\t\"Composition of D : \", $pp->AA_comp('D'),\"\\n\",\n\t\"Composition of C : \", $pp->AA_comp('C'),\"\\n\",\n\t\"Composition of Q : \", $pp->AA_comp('Q'),\"\\n\",\n\t\"Composition of E : \", $pp->AA_comp('E'),\"\\n\",\n\t\"Composition of G : \", $pp->AA_comp('G'),\"\\n\",\n\t\"Composition of H : \", $pp->AA_comp('H'),\"\\n\",\n\t\"Composition of I : \", $pp->AA_comp('I'),\"\\n\",\n\t\"Composition of L : \", $pp->AA_comp('L'),\"\\n\",\n\t\"Composition of K : \", $pp->AA_comp('K'),\"\\n\",\n\t\"Composition of M : \", $pp->AA_comp('M'),\"\\n\",\n\t\"Composition of F : \", $pp->AA_comp('F'),\"\\n\",\n\t\"Composition of P : \", $pp->AA_comp('P'),\"\\n\",\n\t\"Composition of S : \", $pp->AA_comp('S'),\"\\n\",\n\t\"Composition of T : \", $pp->AA_comp('T'),\"\\n\",\n\t\"Composition of W : \", $pp->AA_comp('W'),\"\\n\",\n\t\"Composition of Y : \", $pp->AA_comp('Y'),\"\\n\",\n\t\"Composition of V : \", $pp->AA_comp('V'),\"\\n\",\n\t\"Composition of B : \", $pp->AA_comp('B'),\"\\n\",\n\t\"Composition of Z : \", $pp->AA_comp('Z'),\"\\n\",\n\t\"Composition of X : \", $pp->AA_comp('X'),\"\\n\";\n}\n\n=head1 DESCRIPTION\n\nThis module takes an amino acid sequence and submits it to the\nProtparam program at www.expasy.org/cgi-bin/protparam.  Many\nproperties of the submitted sequence are returned.\n\n=head1 AUTHOR\n\nRichard Dobson, r.j.dobson at qmul dot ac dot uk\n\n\n# Let the code begin...\n\npackage Bio::Tools::Protparam;\n\nuse strict;\nuse base qw(Bio::Root::Root);\nuse LWP 5.64;\n\n=head2 new\n\n  Title    : new\n  Usage    : $pp = Protparam->new(seq=>$seq->seq);\n  Function : Creates a new Protparam object\n  Returns  : A Protparam object\n  Args     : A sequence","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"range":{"end":{"line":137,"character":9999},"start":{"character":0,"line":104}},"kind":12,"line":104},{"containerName":"","kind":2,"name":"LWP","line":107},{"line":112,"containerName":"new","kind":12,"name":"SUPER"},{"name":"LWP","kind":12,"containerName":"UserAgent","line":116},{"kind":12,"range":{"end":{"line":160,"character":9999},"start":{"character":0,"line":151}},"line":151,"definition":"sub","containerName":"main::","name":"num_neg","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"num_neg","name":"$self","line":153},{"name":"$self","containerName":"num_neg","kind":13,"line":155},{"name":"$self","kind":13,"containerName":"num_neg","line":155},{"containerName":"num_neg","kind":13,"name":"$self","line":157}]},{"children":[{"localvar":"my","containerName":"num_pos","kind":13,"name":"$self","line":175,"definition":"my"},{"line":177,"kind":13,"containerName":"num_pos","name":"$self"},{"name":"$self","containerName":"num_pos","kind":13,"line":177},{"kind":13,"containerName":"num_pos","name":"$self","line":179}],"containerName":"main::","name":"num_pos","definition":"sub","line":173,"range":{"end":{"character":9999,"line":182},"start":{"line":173,"character":0}},"kind":12},{"line":194,"range":{"start":{"character":0,"line":194},"end":{"line":200,"character":9999}},"kind":12,"definition":"sub","children":[{"line":195,"name":"$self","localvar":"my","containerName":"amino_acid_number","kind":13,"definition":"my"},{"line":197,"name":"$self","containerName":"amino_acid_number","kind":13},{"line":197,"name":"$self","containerName":"amino_acid_number","kind":13},{"name":"$self","containerName":"amino_acid_number","kind":13,"line":199}],"containerName":"main::","name":"amino_acid_number"},{"children":[{"name":"$self","containerName":"total_atoms","localvar":"my","kind":13,"line":214,"definition":"my"},{"line":216,"kind":13,"containerName":"total_atoms","name":"$self"},{"line":216,"kind":13,"containerName":"total_atoms","name":"$self"},{"containerName":"total_atoms","kind":13,"name":"$self","line":218}],"containerName":"main::","name":"total_atoms","definition":"sub","line":213,"kind":12,"range":{"start":{"line":213,"character":0},"end":{"line":219,"character":9999}}},{"definition":"sub","containerName":"main::","name":"molecular_weight","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"molecular_weight","line":233},{"line":234,"kind":13,"containerName":"molecular_weight","name":"$self"},{"name":"$self","containerName":"molecular_weight","kind":13,"line":234},{"line":235,"kind":13,"containerName":"molecular_weight","name":"$self"}],"range":{"end":{"character":9999,"line":237},"start":{"character":0,"line":232}},"kind":12,"line":232},{"definition":"sub","children":[{"localvar":"my","containerName":"theoretical_pI","kind":13,"name":"$self","line":251,"definition":"my"},{"line":252,"kind":13,"containerName":"theoretical_pI","name":"$self"},{"kind":13,"containerName":"theoretical_pI","name":"$self","line":252},{"name":"$self","containerName":"theoretical_pI","kind":13,"line":253}],"containerName":"main::","name":"theoretical_pI","line":250,"range":{"end":{"line":254,"character":9999},"start":{"character":0,"line":250}},"kind":12},{"definition":"sub","containerName":"main::","name":"num_carbon","children":[{"definition":"my","localvar":"my","containerName":"num_carbon","kind":13,"name":"$self","line":268},{"containerName":"num_carbon","kind":13,"name":"$self","line":270},{"containerName":"num_carbon","kind":13,"name":"$self","line":270},{"name":"$self","containerName":"num_carbon","kind":13,"line":272}],"range":{"start":{"character":0,"line":267},"end":{"line":274,"character":9999}},"kind":12,"line":267},{"definition":"sub","containerName":"main::","name":"num_hydrogen","children":[{"localvar":"my","kind":13,"containerName":"num_hydrogen","name":"$self","line":288,"definition":"my"},{"line":290,"name":"$self","kind":13,"containerName":"num_hydrogen"},{"line":290,"name":"$self","kind":13,"containerName":"num_hydrogen"},{"kind":13,"containerName":"num_hydrogen","name":"$self","line":292}],"range":{"start":{"character":0,"line":287},"end":{"line":294,"character":9999}},"kind":12,"line":287},{"definition":"sub","children":[{"definition":"my","name":"$self","containerName":"num_nitro","localvar":"my","kind":13,"line":308},{"line":310,"containerName":"num_nitro","kind":13,"name":"$self"},{"name":"$self","containerName":"num_nitro","kind":13,"line":310},{"line":313,"containerName":"num_nitro","kind":13,"name":"$self"}],"name":"num_nitro","containerName":"main::","line":307,"kind":12,"range":{"end":{"line":315,"character":9999},"start":{"line":307,"character":0}}},{"range":{"start":{"line":328,"character":0},"end":{"line":335,"character":9999}},"kind":12,"line":328,"definition":"sub","containerName":"main::","name":"num_oxygen","children":[{"localvar":"my","containerName":"num_oxygen","kind":13,"name":"$self","line":329,"definition":"my"},{"name":"$self","containerName":"num_oxygen","kind":13,"line":331},{"name":"$self","containerName":"num_oxygen","kind":13,"line":331},{"line":333,"name":"$self","containerName":"num_oxygen","kind":13}]},{"name":"num_sulphur","containerName":"main::","children":[{"definition":"my","line":349,"name":"$self","localvar":"my","kind":13,"containerName":"num_sulphur"},{"line":351,"kind":13,"containerName":"num_sulphur","name":"$self"},{"kind":13,"containerName":"num_sulphur","name":"$self","line":351},{"line":353,"containerName":"num_sulphur","kind":13,"name":"$self"}],"definition":"sub","range":{"start":{"line":348,"character":0},"end":{"character":9999,"line":354}},"kind":12,"line":348},{"kind":12,"range":{"start":{"character":0,"line":367},"end":{"line":373,"character":9999}},"line":367,"containerName":"main::","name":"half_life","children":[{"line":368,"name":"$self","localvar":"my","containerName":"half_life","kind":13,"definition":"my"},{"line":370,"name":"$self","containerName":"half_life","kind":13},{"line":370,"containerName":"half_life","kind":13,"name":"$self"},{"line":372,"name":"$self","containerName":"half_life","kind":13}],"definition":"sub"},{"line":386,"range":{"start":{"line":386,"character":0},"end":{"line":391,"character":9999}},"kind":12,"definition":"sub","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"instability_index","name":"$self","line":387},{"name":"$self","containerName":"instability_index","kind":13,"line":389},{"name":"$self","containerName":"instability_index","kind":13,"line":389},{"name":"$self","containerName":"instability_index","kind":13,"line":390}],"name":"instability_index","containerName":"main::"},{"containerName":"main::","name":"stability","children":[{"name":"$self","containerName":"stability","localvar":"my","kind":13,"line":405,"definition":"my"},{"containerName":"stability","kind":13,"name":"$self","line":407},{"line":407,"containerName":"stability","kind":13,"name":"$self"},{"name":"$self","containerName":"stability","kind":13,"line":409}],"definition":"sub","range":{"start":{"character":0,"line":404},"end":{"character":9999,"line":411}},"kind":12,"line":404},{"containerName":"main::","name":"aliphatic_index","children":[{"definition":"my","containerName":"aliphatic_index","localvar":"my","kind":13,"name":"$self","line":426},{"containerName":"aliphatic_index","kind":13,"name":"$self","line":427},{"containerName":"aliphatic_index","kind":13,"name":"$self","line":427},{"name":"$self","kind":13,"containerName":"aliphatic_index","line":428}],"definition":"sub","kind":12,"range":{"end":{"character":9999,"line":430},"start":{"character":0,"line":424}},"line":424},{"line":443,"range":{"start":{"line":443,"character":0},"end":{"line":448,"character":9999}},"kind":12,"definition":"sub","children":[{"definition":"my","line":444,"kind":13,"localvar":"my","containerName":"gravy","name":"$self"},{"kind":13,"containerName":"gravy","name":"$self","line":446},{"containerName":"gravy","kind":13,"name":"$self","line":446},{"line":447,"containerName":"gravy","kind":13,"name":"$self"}],"containerName":"main::","name":"gravy"},{"line":461,"range":{"start":{"line":461,"character":0},"end":{"line":473,"character":9999}},"kind":12,"children":[{"line":463,"name":"$self","containerName":"AA_comp","localvar":"my","kind":13,"definition":"my"},{"definition":"my","name":"$aa","kind":13,"localvar":"my","containerName":"AA_comp","line":464},{"line":466,"name":"$aa","containerName":"AA_comp","kind":13},{"name":"$aa","containerName":"AA_comp","kind":13,"line":466},{"name":"$AA","kind":13,"localvar":"my","containerName":"AA_comp","line":468,"definition":"my"},{"containerName":"AA_comp","kind":13,"name":"$self","line":470},{"line":470,"containerName":"AA_comp","kind":13,"name":"$aa"},{"line":470,"name":"$self","kind":13,"containerName":"AA_comp"},{"line":472,"containerName":"AA_comp","kind":13,"name":"$self"},{"containerName":"AA_comp","kind":13,"name":"$aa","line":472}],"containerName":"main::","name":"AA_comp","definition":"sub"}],"version":5}