{"version":5,"vars":[{"name":"Clone","kind":2,"containerName":"","line":132},{"name":"vars","kind":2,"containerName":"","line":134},{"line":137,"name":"@PRIMER3_PARAMS","kind":13,"containerName":null},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"$attr","line":139},{"line":139,"kind":13,"containerName":null,"name":"@PRIMER3_PARAMS"},{"line":139,"containerName":null,"kind":13,"name":"%OK_FIELD"},{"kind":13,"containerName":null,"name":"$attr","line":139},{"kind":2,"containerName":"","name":"base","line":143},{"line":146,"kind":12,"range":{"end":{"line":153,"character":9999},"start":{"line":146,"character":0}},"definition":"sub","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"AUTOLOAD","line":147,"definition":"my"},{"localvar":"my","kind":13,"containerName":"AUTOLOAD","name":"$attr","line":148,"definition":"my"},{"line":148,"kind":13,"containerName":"AUTOLOAD","name":"$AUTOLOAD"},{"line":149,"kind":13,"containerName":"AUTOLOAD","name":"$attr"},{"containerName":"AUTOLOAD","kind":13,"name":"$self","line":150},{"line":150,"name":"throw","containerName":"AUTOLOAD","kind":12},{"containerName":"AUTOLOAD","kind":13,"name":"$OK_FIELD","line":150},{"kind":13,"containerName":"AUTOLOAD","name":"$attr","line":150},{"line":151,"name":"$self","containerName":"AUTOLOAD","kind":13},{"containerName":"AUTOLOAD","kind":13,"name":"$attr","line":151},{"name":"$self","kind":13,"containerName":"AUTOLOAD","line":152},{"containerName":"AUTOLOAD","kind":13,"name":"$attr","line":152}],"name":"AUTOLOAD","containerName":"main::"},{"line":155,"containerName":null,"kind":13,"name":"$ID"},{"name":"new","containerName":"main::","children":[{"localvar":"my","containerName":"new","kind":13,"name":"$class","line":173,"definition":"my"},{"name":"%args","kind":13,"containerName":"new","line":173},{"definition":"my","line":174,"containerName":"new","localvar":"my","kind":13,"name":"$self"},{"name":"$class","kind":13,"containerName":"new","line":174},{"kind":13,"containerName":"new","name":"%args","line":174},{"line":176,"kind":13,"containerName":"new","name":"$args"},{"name":"$self","containerName":"new","kind":13,"line":176},{"name":"_readfile","kind":12,"containerName":"new","line":176},{"line":176,"kind":13,"containerName":"new","name":"$args"},{"line":177,"containerName":"new","kind":13,"name":"$args"},{"name":"$self","kind":13,"containerName":"new","line":177},{"line":178,"containerName":"new","kind":13,"name":"$self"}],"detail":"($class,%args)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":179},"start":{"character":0,"line":172}},"line":172,"signature":{"label":"new($class,%args)","parameters":[{"label":"$class"},{"label":"%args"}],"documentation":"__END__\n# $Id: Primer3.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Primer3\n#\n# Copyright (c) 2003 bioperl, Rob Edwards. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Rob Edwards\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Primer3 - Create input for and work with the output from\nthe program primer3\n\n=head1 SYNOPSIS\n\n # parse primer3 output to get some data\n # this is also called from Bio::Tools::Run::Primer3\n use Bio::Tools::Primer3;\n\n # read a primer3 output file\n my $p3 = Bio::Tools::Primer3->new(-file=>\"data/primer3_output.txt\");\n\n # how many results were there?\n my $num = $p3->number_of_results;\n print \"There were $num results\\n\";\n\n # get all the results\n my $all_results = $p3->all_results;\n print \"ALL the results\\n\";\n foreach my $key (keys %{$all_results}) {\n    print \"$key\\t${$all_results}{$key}\\n\";\n }\n\n # get specific results\n my $result1 = $p3->primer_results(1);\n print \"The first primer is\\n\";\n foreach my $key (keys %{$result1}) {\n    print \"$key\\t${$result1}{$key}\\n\";\n }\n\n # get the results as a Bio::Seq::PrimedSeq stream\n my $primer = $p3->next_primer;\n print \"The left primer in the stream is \",\n   $primer->get_primer('-left_primer')->seq->seq, \"\\n\";\n\n=head1 DESCRIPTION\n\nBio::Tools::Primer3 creates the input files needed to design primers using\nprimer3 and provides mechanisms to access data in the primer3 output files.\n\nThis module provides a bioperl interface to the program primer3. See\nhttp://www-genome.wi.mit.edu/genome_software/other/primer3.html\nfor details and to download the software.\n\nThis module is based on one written by Chad Matsalla\n(bioinformatics1@dieselwurks.com)\n\nI have ripped some of his code, and added a lot of my own. I hope he\nis not mad at me!\n\nThis is probably best run in one of the two following ways:\n\n  i. To parse the output from Bio::Tools::Run::Primer3.\n     You will most likely just use next_primer to get the results from\n     Bio::Tools::Run::Primer3.\n  ii. To parse the output of primer3 handed to it as a file name.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR -\n\n  Rob Edwards\n\n  redwards@utmem.edu\n\n  Based heavily on work of\n\n  Chad Matsalla\n\n  bioinformatics1@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\n  Brian Osborne bosborne at alum.mit.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::Primer3;\n\nuse strict;\nuse Bio::Seq;\nuse Bio::Seq::PrimedSeq;\nuse Bio::SeqFeature::Primer;\nuse Clone qw(clone);\n\nuse vars qw($AUTOLOAD @PRIMER3_PARAMS %OK_FIELD $ID);\n\nBEGIN {\n @PRIMER3_PARAMS=qw(results seqobject);\n\n foreach my $attr (@PRIMER3_PARAMS) {$OK_FIELD{$attr}++}\n}\n\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\nsub AUTOLOAD {\n my $self = shift;\n my $attr = $AUTOLOAD;\n $attr =~ s/.*:://;\n $self->throw(\"Unallowed parameter: $attr !\") unless $OK_FIELD{$attr};\n $self->{$attr} = shift if @_;\n return $self->{$attr};\n}\n\n$ID = 'Bio::Tools::Primer3';\n\n=head2 new\n\n  Title   : new()\n  Usage   : my $primer3 = Bio::Tools::Primer3->new(-file=>$file)\n            to read a primer3 output file.\n  Function: Parse primer3 output\n  Returns : Does not return anything. If called with a filename will\n            allow you to retrieve the results\n  Args    : -file (optional) file of primer3 results to parse -verbose\n            (optional) set verbose output\n  Notes   :"}},{"line":174,"containerName":"new","kind":12,"name":"SUPER"},{"range":{"start":{"character":0,"line":196},"end":{"line":199,"character":9999}},"kind":12,"line":196,"name":"number_of_results","containerName":"main::","children":[{"definition":"my","line":197,"localvar":"my","kind":13,"containerName":"number_of_results","name":"$self"},{"name":"$self","containerName":"number_of_results","kind":13,"line":198}],"definition":"sub"},{"signature":{"label":"all_results($self,@results)","documentation":"__END__\n# $Id: Primer3.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Primer3\n#\n# Copyright (c) 2003 bioperl, Rob Edwards. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Rob Edwards\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Primer3 - Create input for and work with the output from\nthe program primer3\n\n=head1 SYNOPSIS\n\n # parse primer3 output to get some data\n # this is also called from Bio::Tools::Run::Primer3\n use Bio::Tools::Primer3;\n\n # read a primer3 output file\n my $p3 = Bio::Tools::Primer3->new(-file=>\"data/primer3_output.txt\");\n\n # how many results were there?\n my $num = $p3->number_of_results;\n print \"There were $num results\\n\";\n\n # get all the results\n my $all_results = $p3->all_results;\n print \"ALL the results\\n\";\n foreach my $key (keys %{$all_results}) {\n    print \"$key\\t${$all_results}{$key}\\n\";\n }\n\n # get specific results\n my $result1 = $p3->primer_results(1);\n print \"The first primer is\\n\";\n foreach my $key (keys %{$result1}) {\n    print \"$key\\t${$result1}{$key}\\n\";\n }\n\n # get the results as a Bio::Seq::PrimedSeq stream\n my $primer = $p3->next_primer;\n print \"The left primer in the stream is \",\n   $primer->get_primer('-left_primer')->seq->seq, \"\\n\";\n\n=head1 DESCRIPTION\n\nBio::Tools::Primer3 creates the input files needed to design primers using\nprimer3 and provides mechanisms to access data in the primer3 output files.\n\nThis module provides a bioperl interface to the program primer3. See\nhttp://www-genome.wi.mit.edu/genome_software/other/primer3.html\nfor details and to download the software.\n\nThis module is based on one written by Chad Matsalla\n(bioinformatics1@dieselwurks.com)\n\nI have ripped some of his code, and added a lot of my own. I hope he\nis not mad at me!\n\nThis is probably best run in one of the two following ways:\n\n  i. To parse the output from Bio::Tools::Run::Primer3.\n     You will most likely just use next_primer to get the results from\n     Bio::Tools::Run::Primer3.\n  ii. To parse the output of primer3 handed to it as a file name.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR -\n\n  Rob Edwards\n\n  redwards@utmem.edu\n\n  Based heavily on work of\n\n  Chad Matsalla\n\n  bioinformatics1@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\n  Brian Osborne bosborne at alum.mit.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::Primer3;\n\nuse strict;\nuse Bio::Seq;\nuse Bio::Seq::PrimedSeq;\nuse Bio::SeqFeature::Primer;\nuse Clone qw(clone);\n\nuse vars qw($AUTOLOAD @PRIMER3_PARAMS %OK_FIELD $ID);\n\nBEGIN {\n @PRIMER3_PARAMS=qw(results seqobject);\n\n foreach my $attr (@PRIMER3_PARAMS) {$OK_FIELD{$attr}++}\n}\n\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\nsub AUTOLOAD {\n my $self = shift;\n my $attr = $AUTOLOAD;\n $attr =~ s/.*:://;\n $self->throw(\"Unallowed parameter: $attr !\") unless $OK_FIELD{$attr};\n $self->{$attr} = shift if @_;\n return $self->{$attr};\n}\n\n$ID = 'Bio::Tools::Primer3';\n\n=head2 new\n\n  Title   : new()\n  Usage   : my $primer3 = Bio::Tools::Primer3->new(-file=>$file)\n            to read a primer3 output file.\n  Function: Parse primer3 output\n  Returns : Does not return anything. If called with a filename will\n            allow you to retrieve the results\n  Args    : -file (optional) file of primer3 results to parse -verbose\n            (optional) set verbose output\n  Notes   :\n\n\n\nsub new {\n my($class,%args) = @_;\n my $self = $class->SUPER::new(%args);\n\n if ($args{'-file'}) {$self->_readfile($args{'-file'})}\n if ($args{'-verbose'}) {$self->{'verbose'}=1}\n return $self;\n}\n\n\n=head2 number_of_results\n\n  Title   : number_of_results()\n  Usage   : $primer3->number_of_results()\n  Function: Retrieve the number of primers returned from Primer3.\n  Returns : A scalar\n  Args    : None\n  Notes   : This returns the count of the primers returned by Primer3\n             (aka how many of them there are).\n             This is one more than the maximum offset into the zero\n             based list of primers that is accessed by primer_results().\n\n\nsub number_of_results {\n my $self=shift;\n return $self->{'maximum_primers_returned'} + 1;\n}\n\n\n=head2 all_results\n\n  Title   : all_results()\n  Usage   : $primer3->all_results() to print all results or\n            $primer3->all_results('primer3 result name',\n            'other results') to return a specific result\n  Function: Retrieve the results returned from Primer3.\n  Returns : A reference to a hash\n  Args    : Optional array of results to retrieve","parameters":[{"label":"$self"},{"label":"@results"}]},"line":214,"kind":12,"range":{"end":{"character":9999,"line":224},"start":{"character":0,"line":214}},"definition":"sub","detail":"($self,@results)","children":[{"line":215,"kind":13,"localvar":"my","containerName":"all_results","name":"$self","definition":"my"},{"name":"@results","kind":13,"containerName":"all_results","line":215},{"definition":"my","name":"%hash","localvar":"my","containerName":"all_results","kind":13,"line":216},{"line":217,"containerName":"all_results","kind":13,"name":"@results"},{"definition":"my","kind":13,"localvar":"my","containerName":"all_results","name":"$result","line":219},{"kind":13,"containerName":"all_results","name":"@results","line":219},{"line":219,"name":"$hash","containerName":"all_results","kind":13},{"line":219,"name":"$result","containerName":"all_results","kind":13},{"containerName":"all_results","kind":13,"name":"$self","line":219},{"line":219,"kind":13,"containerName":"all_results","name":"$result"},{"definition":"my","localvar":"my","kind":13,"containerName":"all_results","name":"$result","line":221},{"line":221,"name":"$self","containerName":"all_results","kind":13},{"kind":13,"containerName":"all_results","name":"$hash","line":222},{"name":"$result","kind":13,"containerName":"all_results","line":222},{"line":222,"name":"$self","kind":13,"containerName":"all_results"},{"name":"$result","kind":13,"containerName":"all_results","line":222}],"containerName":"main::","name":"all_results"},{"line":226,"kind":13,"containerName":null,"name":"%hash"},{"detail":"($self,$toget)","definition":"sub","name":"primer_results","containerName":"main::","children":[{"definition":"my","line":242,"name":"$self","containerName":"primer_results","localvar":"my","kind":13},{"name":"$toget","containerName":"primer_results","kind":13,"line":242},{"line":243,"name":"$toget","kind":13,"containerName":"primer_results"},{"line":243,"kind":13,"containerName":"primer_results","name":"$self"},{"kind":13,"containerName":"primer_results","name":"$self","line":244},{"containerName":"primer_results","kind":12,"name":"warn","line":244},{"kind":13,"containerName":"primer_results","name":"$self","line":248},{"name":"$toget","containerName":"primer_results","kind":13,"line":248}],"signature":{"label":"primer_results($self,$toget)","parameters":[{"label":"$self"},{"label":"$toget"}],"documentation":"__END__\n# $Id: Primer3.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Primer3\n#\n# Copyright (c) 2003 bioperl, Rob Edwards. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Rob Edwards\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Primer3 - Create input for and work with the output from\nthe program primer3\n\n=head1 SYNOPSIS\n\n # parse primer3 output to get some data\n # this is also called from Bio::Tools::Run::Primer3\n use Bio::Tools::Primer3;\n\n # read a primer3 output file\n my $p3 = Bio::Tools::Primer3->new(-file=>\"data/primer3_output.txt\");\n\n # how many results were there?\n my $num = $p3->number_of_results;\n print \"There were $num results\\n\";\n\n # get all the results\n my $all_results = $p3->all_results;\n print \"ALL the results\\n\";\n foreach my $key (keys %{$all_results}) {\n    print \"$key\\t${$all_results}{$key}\\n\";\n }\n\n # get specific results\n my $result1 = $p3->primer_results(1);\n print \"The first primer is\\n\";\n foreach my $key (keys %{$result1}) {\n    print \"$key\\t${$result1}{$key}\\n\";\n }\n\n # get the results as a Bio::Seq::PrimedSeq stream\n my $primer = $p3->next_primer;\n print \"The left primer in the stream is \",\n   $primer->get_primer('-left_primer')->seq->seq, \"\\n\";\n\n=head1 DESCRIPTION\n\nBio::Tools::Primer3 creates the input files needed to design primers using\nprimer3 and provides mechanisms to access data in the primer3 output files.\n\nThis module provides a bioperl interface to the program primer3. See\nhttp://www-genome.wi.mit.edu/genome_software/other/primer3.html\nfor details and to download the software.\n\nThis module is based on one written by Chad Matsalla\n(bioinformatics1@dieselwurks.com)\n\nI have ripped some of his code, and added a lot of my own. I hope he\nis not mad at me!\n\nThis is probably best run in one of the two following ways:\n\n  i. To parse the output from Bio::Tools::Run::Primer3.\n     You will most likely just use next_primer to get the results from\n     Bio::Tools::Run::Primer3.\n  ii. To parse the output of primer3 handed to it as a file name.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR -\n\n  Rob Edwards\n\n  redwards@utmem.edu\n\n  Based heavily on work of\n\n  Chad Matsalla\n\n  bioinformatics1@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\n  Brian Osborne bosborne at alum.mit.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::Primer3;\n\nuse strict;\nuse Bio::Seq;\nuse Bio::Seq::PrimedSeq;\nuse Bio::SeqFeature::Primer;\nuse Clone qw(clone);\n\nuse vars qw($AUTOLOAD @PRIMER3_PARAMS %OK_FIELD $ID);\n\nBEGIN {\n @PRIMER3_PARAMS=qw(results seqobject);\n\n foreach my $attr (@PRIMER3_PARAMS) {$OK_FIELD{$attr}++}\n}\n\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\nsub AUTOLOAD {\n my $self = shift;\n my $attr = $AUTOLOAD;\n $attr =~ s/.*:://;\n $self->throw(\"Unallowed parameter: $attr !\") unless $OK_FIELD{$attr};\n $self->{$attr} = shift if @_;\n return $self->{$attr};\n}\n\n$ID = 'Bio::Tools::Primer3';\n\n=head2 new\n\n  Title   : new()\n  Usage   : my $primer3 = Bio::Tools::Primer3->new(-file=>$file)\n            to read a primer3 output file.\n  Function: Parse primer3 output\n  Returns : Does not return anything. If called with a filename will\n            allow you to retrieve the results\n  Args    : -file (optional) file of primer3 results to parse -verbose\n            (optional) set verbose output\n  Notes   :\n\n\n\nsub new {\n my($class,%args) = @_;\n my $self = $class->SUPER::new(%args);\n\n if ($args{'-file'}) {$self->_readfile($args{'-file'})}\n if ($args{'-verbose'}) {$self->{'verbose'}=1}\n return $self;\n}\n\n\n=head2 number_of_results\n\n  Title   : number_of_results()\n  Usage   : $primer3->number_of_results()\n  Function: Retrieve the number of primers returned from Primer3.\n  Returns : A scalar\n  Args    : None\n  Notes   : This returns the count of the primers returned by Primer3\n             (aka how many of them there are).\n             This is one more than the maximum offset into the zero\n             based list of primers that is accessed by primer_results().\n\n\nsub number_of_results {\n my $self=shift;\n return $self->{'maximum_primers_returned'} + 1;\n}\n\n\n=head2 all_results\n\n  Title   : all_results()\n  Usage   : $primer3->all_results() to print all results or\n            $primer3->all_results('primer3 result name',\n            'other results') to return a specific result\n  Function: Retrieve the results returned from Primer3.\n  Returns : A reference to a hash\n  Args    : Optional array of results to retrieve\n\n\nsub all_results {\n\tmy ($self, @results) = @_;\n\tmy %hash;\n\tif (@results) {\n\t\t# we only want a few things\n\t\tforeach my $result (@results) {$hash{$result}=$self->{'results'}->$result}\n\t} else {\n\t\tforeach my $result (keys %{$self->{'results'}}) {\n\t\t\t$hash{$result}=$self->{'results'}->{$result};\n\t\t}\n\t}\n\n\treturn \\%hash;\n}\n\n\n=head2 primer_results\n\n  Title   : primer_results()\n  Usage   : $primer3->primer_results(2) to print results for the third\n            choice primer (indexed on 0)\n  Function: Retrieve the results returned from Primer3 for specific primer pairs.\n  Returns : A reference to a hash\n  Args    : A number between 0 and the maximum number of primers to retrieve"},"range":{"end":{"character":9999,"line":249},"start":{"line":241,"character":0}},"kind":12,"line":241},{"line":263,"range":{"start":{"line":263,"character":0},"end":{"line":285,"character":9999}},"kind":12,"signature":{"documentation":"__END__\n# $Id: Primer3.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Primer3\n#\n# Copyright (c) 2003 bioperl, Rob Edwards. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Rob Edwards\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Primer3 - Create input for and work with the output from\nthe program primer3\n\n=head1 SYNOPSIS\n\n # parse primer3 output to get some data\n # this is also called from Bio::Tools::Run::Primer3\n use Bio::Tools::Primer3;\n\n # read a primer3 output file\n my $p3 = Bio::Tools::Primer3->new(-file=>\"data/primer3_output.txt\");\n\n # how many results were there?\n my $num = $p3->number_of_results;\n print \"There were $num results\\n\";\n\n # get all the results\n my $all_results = $p3->all_results;\n print \"ALL the results\\n\";\n foreach my $key (keys %{$all_results}) {\n    print \"$key\\t${$all_results}{$key}\\n\";\n }\n\n # get specific results\n my $result1 = $p3->primer_results(1);\n print \"The first primer is\\n\";\n foreach my $key (keys %{$result1}) {\n    print \"$key\\t${$result1}{$key}\\n\";\n }\n\n # get the results as a Bio::Seq::PrimedSeq stream\n my $primer = $p3->next_primer;\n print \"The left primer in the stream is \",\n   $primer->get_primer('-left_primer')->seq->seq, \"\\n\";\n\n=head1 DESCRIPTION\n\nBio::Tools::Primer3 creates the input files needed to design primers using\nprimer3 and provides mechanisms to access data in the primer3 output files.\n\nThis module provides a bioperl interface to the program primer3. See\nhttp://www-genome.wi.mit.edu/genome_software/other/primer3.html\nfor details and to download the software.\n\nThis module is based on one written by Chad Matsalla\n(bioinformatics1@dieselwurks.com)\n\nI have ripped some of his code, and added a lot of my own. I hope he\nis not mad at me!\n\nThis is probably best run in one of the two following ways:\n\n  i. To parse the output from Bio::Tools::Run::Primer3.\n     You will most likely just use next_primer to get the results from\n     Bio::Tools::Run::Primer3.\n  ii. To parse the output of primer3 handed to it as a file name.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR -\n\n  Rob Edwards\n\n  redwards@utmem.edu\n\n  Based heavily on work of\n\n  Chad Matsalla\n\n  bioinformatics1@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\n  Brian Osborne bosborne at alum.mit.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::Primer3;\n\nuse strict;\nuse Bio::Seq;\nuse Bio::Seq::PrimedSeq;\nuse Bio::SeqFeature::Primer;\nuse Clone qw(clone);\n\nuse vars qw($AUTOLOAD @PRIMER3_PARAMS %OK_FIELD $ID);\n\nBEGIN {\n @PRIMER3_PARAMS=qw(results seqobject);\n\n foreach my $attr (@PRIMER3_PARAMS) {$OK_FIELD{$attr}++}\n}\n\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\nsub AUTOLOAD {\n my $self = shift;\n my $attr = $AUTOLOAD;\n $attr =~ s/.*:://;\n $self->throw(\"Unallowed parameter: $attr !\") unless $OK_FIELD{$attr};\n $self->{$attr} = shift if @_;\n return $self->{$attr};\n}\n\n$ID = 'Bio::Tools::Primer3';\n\n=head2 new\n\n  Title   : new()\n  Usage   : my $primer3 = Bio::Tools::Primer3->new(-file=>$file)\n            to read a primer3 output file.\n  Function: Parse primer3 output\n  Returns : Does not return anything. If called with a filename will\n            allow you to retrieve the results\n  Args    : -file (optional) file of primer3 results to parse -verbose\n            (optional) set verbose output\n  Notes   :\n\n\n\nsub new {\n my($class,%args) = @_;\n my $self = $class->SUPER::new(%args);\n\n if ($args{'-file'}) {$self->_readfile($args{'-file'})}\n if ($args{'-verbose'}) {$self->{'verbose'}=1}\n return $self;\n}\n\n\n=head2 number_of_results\n\n  Title   : number_of_results()\n  Usage   : $primer3->number_of_results()\n  Function: Retrieve the number of primers returned from Primer3.\n  Returns : A scalar\n  Args    : None\n  Notes   : This returns the count of the primers returned by Primer3\n             (aka how many of them there are).\n             This is one more than the maximum offset into the zero\n             based list of primers that is accessed by primer_results().\n\n\nsub number_of_results {\n my $self=shift;\n return $self->{'maximum_primers_returned'} + 1;\n}\n\n\n=head2 all_results\n\n  Title   : all_results()\n  Usage   : $primer3->all_results() to print all results or\n            $primer3->all_results('primer3 result name',\n            'other results') to return a specific result\n  Function: Retrieve the results returned from Primer3.\n  Returns : A reference to a hash\n  Args    : Optional array of results to retrieve\n\n\nsub all_results {\n\tmy ($self, @results) = @_;\n\tmy %hash;\n\tif (@results) {\n\t\t# we only want a few things\n\t\tforeach my $result (@results) {$hash{$result}=$self->{'results'}->$result}\n\t} else {\n\t\tforeach my $result (keys %{$self->{'results'}}) {\n\t\t\t$hash{$result}=$self->{'results'}->{$result};\n\t\t}\n\t}\n\n\treturn \\%hash;\n}\n\n\n=head2 primer_results\n\n  Title   : primer_results()\n  Usage   : $primer3->primer_results(2) to print results for the third\n            choice primer (indexed on 0)\n  Function: Retrieve the results returned from Primer3 for specific primer pairs.\n  Returns : A reference to a hash\n  Args    : A number between 0 and the maximum number of primers to retrieve\n\n\nsub primer_results {\n\tmy ($self, $toget) = @_;\n\tif ($toget > $self->{'maximum_primers_returned'}) {\n\t\t$self->warn(\"Didn't get any results for $toget\");\n\t\treturn 0;\n\t}\n\telse {\n\t\treturn \\%{$self->{'results_by_number'}->{$toget}};\n\t}\n}\n\n=head2 _readfile\n\n  Title   : _readfile()\n  Usage   : $self->_readfile();\n  Function: An internal function that reads a file and sets up the results\n  Returns : Nothing.\n  Args    : None\n  Notes   :","parameters":[{"label":"$self"},{"label":"$file"}],"label":"_readfile($self,$file)"},"children":[{"name":"$self","containerName":"_readfile","localvar":"my","kind":13,"line":264,"definition":"my"},{"line":264,"name":"$file","kind":13,"containerName":"_readfile"},{"line":265,"containerName":"_readfile","kind":13,"name":"$self"},{"name":"_initialize_io","containerName":"_readfile","kind":12,"line":265},{"name":"$file","containerName":"_readfile","kind":13,"line":265},{"definition":"my","line":266,"localvar":"my","containerName":"_readfile","kind":13,"name":"$line"},{"name":"$id","kind":13,"localvar":"my","containerName":"_readfile","line":267,"definition":"my"},{"line":268,"name":"$line","kind":13,"containerName":"_readfile"},{"name":"$self","containerName":"_readfile","kind":13,"line":268},{"line":268,"kind":12,"containerName":"_readfile","name":"_readline"},{"line":269,"name":"$line","containerName":"_readfile","kind":13},{"containerName":"_readfile","kind":13,"name":"$line","line":270},{"definition":"my","name":"$return","localvar":"my","containerName":"_readfile","kind":13,"line":271},{"line":271,"name":"$value","kind":13,"containerName":"_readfile"},{"line":271,"name":"$line","kind":13,"containerName":"_readfile"},{"kind":13,"containerName":"_readfile","name":"$return","line":272},{"line":273,"name":"$self","kind":13,"containerName":"_readfile"},{"line":273,"kind":12,"containerName":"_readfile","name":"new"},{"line":273,"name":"$value","containerName":"_readfile","kind":13},{"name":"$id","kind":13,"containerName":"_readfile","line":273},{"containerName":"_readfile","kind":13,"name":"$id","line":273},{"line":276,"kind":13,"containerName":"_readfile","name":"$return"},{"name":"$self","containerName":"_readfile","kind":13,"line":277},{"containerName":"_readfile","kind":13,"name":"$self","line":277},{"containerName":"_readfile","kind":12,"name":"id","line":277},{"line":277,"kind":13,"containerName":"_readfile","name":"$value"},{"name":"$id","kind":13,"containerName":"_readfile","line":277},{"line":277,"containerName":"_readfile","kind":13,"name":"$value"},{"line":280,"kind":13,"containerName":"_readfile","name":"$self"},{"name":"$return","kind":13,"containerName":"_readfile","line":280},{"line":280,"kind":13,"containerName":"_readfile","name":"$value"},{"line":284,"containerName":"_readfile","kind":13,"name":"$self"},{"kind":12,"containerName":"_readfile","name":"_separate","line":284}],"name":"_readfile","containerName":"main::","definition":"sub","detail":"($self,$file)"},{"line":273,"kind":12,"name":"seqobject"},{"line":273,"name":"Bio","containerName":"Seq","kind":12},{"line":277,"name":"seqobject","kind":12},{"line":277,"name":"seqobject","kind":12},{"definition":"sub","name":"next_primer","containerName":"main::","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"next_primer","name":"$self","line":300},{"line":307,"kind":13,"containerName":"next_primer","name":"$self"},{"containerName":"next_primer","kind":12,"name":"warn","line":307},{"line":307,"name":"$self","kind":13,"containerName":"next_primer"},{"kind":13,"containerName":"next_primer","name":"$self","line":308},{"line":308,"name":"number_of_results","kind":12,"containerName":"next_primer"},{"line":310,"name":"$self","kind":13,"containerName":"next_primer"},{"name":"$self","kind":13,"containerName":"next_primer","line":310},{"name":"$self","containerName":"next_primer","kind":13,"line":311},{"name":"$self","kind":13,"containerName":"next_primer","line":311},{"kind":12,"containerName":"next_primer","name":"number_of_results","line":311},{"definition":"my","line":312,"name":"$results","localvar":"my","containerName":"next_primer","kind":13},{"name":"$self","containerName":"next_primer","kind":13,"line":312},{"line":312,"name":"primer_results","kind":12,"containerName":"next_primer"},{"kind":13,"containerName":"next_primer","name":"$self","line":312},{"name":"$self","kind":13,"containerName":"next_primer","line":314},{"line":314,"containerName":"next_primer","kind":12,"name":"throw"},{"containerName":"next_primer","kind":13,"name":"$results","line":314}],"kind":12,"range":{"start":{"character":0,"line":299},"end":{"line":314,"character":9999}},"line":299},{"line":315,"name":"$self","containerName":null,"kind":13},{"line":315,"containerName":"main::","kind":12,"name":"throw"},{"name":"%results","kind":13,"containerName":null,"line":315},{"kind":13,"containerName":null,"name":"$self","line":316},{"containerName":"main::","kind":12,"name":"throw","line":316},{"name":"%self","containerName":null,"kind":13,"line":316},{"definition":"my","line":318,"name":"$left_seq","localvar":"my","containerName":null,"kind":13},{"containerName":"SeqFeature::Primer","kind":12,"name":"Bio","line":318},{"kind":12,"containerName":"main::","name":"new","line":318},{"line":320,"name":"%results","kind":13,"containerName":null},{"line":321,"name":"%self","kind":13,"containerName":null},{"containerName":null,"localvar":"my","kind":13,"name":"$right_seq","line":322,"definition":"my"},{"line":322,"name":"Bio","containerName":"SeqFeature::Primer","kind":12},{"name":"new","containerName":"main::","kind":12,"line":322},{"line":324,"name":"%results","containerName":null,"kind":13},{"line":325,"name":"%self","containerName":null,"kind":13},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"$key","line":328},{"name":"%results","kind":13,"containerName":null,"line":328},{"name":"$key","kind":13,"containerName":null,"line":330},{"line":331,"containerName":null,"kind":13,"name":"%key"},{"kind":13,"containerName":null,"name":"$left_seq","line":332},{"line":332,"name":"add_tag_value","containerName":"main::","kind":12},{"name":"$key","kind":13,"containerName":null,"line":332},{"line":332,"kind":12,"name":"results"},{"containerName":null,"kind":13,"name":"$key","line":332},{"kind":13,"containerName":null,"name":"%key","line":333},{"line":334,"name":"$right_seq","containerName":null,"kind":13},{"name":"add_tag_value","containerName":"main::","kind":12,"line":334},{"name":"$key","kind":13,"containerName":null,"line":334},{"name":"results","kind":12,"line":334},{"line":334,"containerName":null,"kind":13,"name":"$key"},{"line":338,"name":"$primed_seq","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"line":338,"name":"Bio","containerName":"Seq::PrimedSeq","kind":12},{"line":338,"kind":12,"containerName":"main::","name":"new"},{"name":"clone","kind":12,"line":338},{"kind":13,"containerName":null,"name":"%self","line":338},{"line":339,"kind":13,"containerName":null,"name":"$left_seq"},{"name":"$right_seq","containerName":null,"kind":13,"line":340},{"name":"$key","localvar":"my","kind":13,"containerName":null,"line":343,"definition":"my"},{"line":343,"containerName":null,"kind":13,"name":"%results"},{"line":344,"name":"$key","containerName":null,"kind":13},{"name":"$primed_seq","kind":13,"containerName":null,"line":345},{"line":345,"name":"add_tag_value","containerName":"main::","kind":12},{"line":345,"name":"$key","containerName":null,"kind":13},{"name":"results","kind":12,"line":345},{"name":"$key","containerName":null,"kind":13,"line":345},{"kind":13,"containerName":null,"name":"%self","line":348},{"line":349,"name":"$primed_seq","kind":13,"containerName":null},{"line":364,"kind":12,"range":{"start":{"line":364,"character":0},"end":{"line":368,"character":9999}},"children":[{"name":"$self","localvar":"my","containerName":"primer_stream","kind":13,"line":365,"definition":"my"},{"line":366,"localvar":"my","containerName":"primer_stream","kind":13,"name":"$primedseq","definition":"my"},{"line":366,"name":"$self","kind":13,"containerName":"primer_stream"},{"name":"next_primer","kind":12,"containerName":"primer_stream","line":366},{"kind":13,"containerName":"primer_stream","name":"$primedseq","line":367}],"name":"primer_stream","containerName":"main::","definition":"sub"},{"children":[{"line":383,"name":"$self","localvar":"my","containerName":"_separate","kind":13,"definition":"my"},{"name":"%results","containerName":"_separate","localvar":"my","kind":13,"line":384,"definition":"my"},{"line":385,"name":"$maxlocation","localvar":"my","kind":13,"containerName":"_separate","definition":"my"},{"name":"$key","localvar":"my","containerName":"_separate","kind":13,"line":386,"definition":"my"},{"name":"$self","containerName":"_separate","kind":13,"line":386}],"name":"_separate","containerName":"main::","definition":"sub","line":382,"range":{"end":{"line":386,"character":9999},"start":{"character":0,"line":382}},"kind":12},{"line":387,"name":"%self","kind":13,"containerName":null},{"line":387,"containerName":null,"kind":13,"name":"$key"},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"$location","line":389},{"definition":"my","line":393,"name":"$tempkey","localvar":"my","containerName":null,"kind":13},{"line":393,"containerName":null,"kind":13,"name":"$key"},{"line":394,"name":"%tempkey","kind":13,"containerName":null},{"line":395,"kind":13,"containerName":null,"name":"$location"},{"line":396,"name":"$location","kind":13,"containerName":null},{"name":"%maxlocation","kind":13,"containerName":null,"line":396},{"line":396,"name":"$maxlocation","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$location","line":396},{"name":"%tempkey","containerName":null,"kind":13,"line":397},{"line":399,"kind":13,"containerName":null,"name":"$location"},{"name":"$location","containerName":null,"kind":13,"line":400},{"line":400,"kind":13,"containerName":null,"name":"%maxlocation"},{"kind":13,"containerName":null,"name":"$maxlocation","line":400},{"line":400,"kind":13,"containerName":null,"name":"%location"},{"line":402,"containerName":null,"kind":13,"name":"$location"},{"name":"%results","kind":13,"containerName":null,"line":405},{"line":405,"containerName":null,"kind":13,"name":"%location"},{"line":405,"containerName":null,"kind":13,"name":"$tempkey"},{"line":405,"kind":13,"containerName":null,"name":"%self"},{"kind":13,"containerName":null,"name":"$key","line":405},{"name":"%self","kind":13,"containerName":null,"line":407},{"line":407,"containerName":null,"kind":13,"name":"%results"},{"line":408,"kind":13,"containerName":null,"name":"%self"},{"line":408,"kind":13,"containerName":null,"name":"$maxlocation"},{"kind":12,"range":{"end":{"character":9999,"line":426},"start":{"character":0,"line":422}},"line":422,"signature":{"label":"_set_variable($self,$name,$value)","documentation":"__END__\n# $Id: Primer3.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Primer3\n#\n# Copyright (c) 2003 bioperl, Rob Edwards. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Rob Edwards\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Primer3 - Create input for and work with the output from\nthe program primer3\n\n=head1 SYNOPSIS\n\n # parse primer3 output to get some data\n # this is also called from Bio::Tools::Run::Primer3\n use Bio::Tools::Primer3;\n\n # read a primer3 output file\n my $p3 = Bio::Tools::Primer3->new(-file=>\"data/primer3_output.txt\");\n\n # how many results were there?\n my $num = $p3->number_of_results;\n print \"There were $num results\\n\";\n\n # get all the results\n my $all_results = $p3->all_results;\n print \"ALL the results\\n\";\n foreach my $key (keys %{$all_results}) {\n    print \"$key\\t${$all_results}{$key}\\n\";\n }\n\n # get specific results\n my $result1 = $p3->primer_results(1);\n print \"The first primer is\\n\";\n foreach my $key (keys %{$result1}) {\n    print \"$key\\t${$result1}{$key}\\n\";\n }\n\n # get the results as a Bio::Seq::PrimedSeq stream\n my $primer = $p3->next_primer;\n print \"The left primer in the stream is \",\n   $primer->get_primer('-left_primer')->seq->seq, \"\\n\";\n\n=head1 DESCRIPTION\n\nBio::Tools::Primer3 creates the input files needed to design primers using\nprimer3 and provides mechanisms to access data in the primer3 output files.\n\nThis module provides a bioperl interface to the program primer3. See\nhttp://www-genome.wi.mit.edu/genome_software/other/primer3.html\nfor details and to download the software.\n\nThis module is based on one written by Chad Matsalla\n(bioinformatics1@dieselwurks.com)\n\nI have ripped some of his code, and added a lot of my own. I hope he\nis not mad at me!\n\nThis is probably best run in one of the two following ways:\n\n  i. To parse the output from Bio::Tools::Run::Primer3.\n     You will most likely just use next_primer to get the results from\n     Bio::Tools::Run::Primer3.\n  ii. To parse the output of primer3 handed to it as a file name.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR -\n\n  Rob Edwards\n\n  redwards@utmem.edu\n\n  Based heavily on work of\n\n  Chad Matsalla\n\n  bioinformatics1@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\n  Brian Osborne bosborne at alum.mit.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::Primer3;\n\nuse strict;\nuse Bio::Seq;\nuse Bio::Seq::PrimedSeq;\nuse Bio::SeqFeature::Primer;\nuse Clone qw(clone);\n\nuse vars qw($AUTOLOAD @PRIMER3_PARAMS %OK_FIELD $ID);\n\nBEGIN {\n @PRIMER3_PARAMS=qw(results seqobject);\n\n foreach my $attr (@PRIMER3_PARAMS) {$OK_FIELD{$attr}++}\n}\n\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\nsub AUTOLOAD {\n my $self = shift;\n my $attr = $AUTOLOAD;\n $attr =~ s/.*:://;\n $self->throw(\"Unallowed parameter: $attr !\") unless $OK_FIELD{$attr};\n $self->{$attr} = shift if @_;\n return $self->{$attr};\n}\n\n$ID = 'Bio::Tools::Primer3';\n\n=head2 new\n\n  Title   : new()\n  Usage   : my $primer3 = Bio::Tools::Primer3->new(-file=>$file)\n            to read a primer3 output file.\n  Function: Parse primer3 output\n  Returns : Does not return anything. If called with a filename will\n            allow you to retrieve the results\n  Args    : -file (optional) file of primer3 results to parse -verbose\n            (optional) set verbose output\n  Notes   :\n\n\n\nsub new {\n my($class,%args) = @_;\n my $self = $class->SUPER::new(%args);\n\n if ($args{'-file'}) {$self->_readfile($args{'-file'})}\n if ($args{'-verbose'}) {$self->{'verbose'}=1}\n return $self;\n}\n\n\n=head2 number_of_results\n\n  Title   : number_of_results()\n  Usage   : $primer3->number_of_results()\n  Function: Retrieve the number of primers returned from Primer3.\n  Returns : A scalar\n  Args    : None\n  Notes   : This returns the count of the primers returned by Primer3\n             (aka how many of them there are).\n             This is one more than the maximum offset into the zero\n             based list of primers that is accessed by primer_results().\n\n\nsub number_of_results {\n my $self=shift;\n return $self->{'maximum_primers_returned'} + 1;\n}\n\n\n=head2 all_results\n\n  Title   : all_results()\n  Usage   : $primer3->all_results() to print all results or\n            $primer3->all_results('primer3 result name',\n            'other results') to return a specific result\n  Function: Retrieve the results returned from Primer3.\n  Returns : A reference to a hash\n  Args    : Optional array of results to retrieve\n\n\nsub all_results {\n\tmy ($self, @results) = @_;\n\tmy %hash;\n\tif (@results) {\n\t\t# we only want a few things\n\t\tforeach my $result (@results) {$hash{$result}=$self->{'results'}->$result}\n\t} else {\n\t\tforeach my $result (keys %{$self->{'results'}}) {\n\t\t\t$hash{$result}=$self->{'results'}->{$result};\n\t\t}\n\t}\n\n\treturn \\%hash;\n}\n\n\n=head2 primer_results\n\n  Title   : primer_results()\n  Usage   : $primer3->primer_results(2) to print results for the third\n            choice primer (indexed on 0)\n  Function: Retrieve the results returned from Primer3 for specific primer pairs.\n  Returns : A reference to a hash\n  Args    : A number between 0 and the maximum number of primers to retrieve\n\n\nsub primer_results {\n\tmy ($self, $toget) = @_;\n\tif ($toget > $self->{'maximum_primers_returned'}) {\n\t\t$self->warn(\"Didn't get any results for $toget\");\n\t\treturn 0;\n\t}\n\telse {\n\t\treturn \\%{$self->{'results_by_number'}->{$toget}};\n\t}\n}\n\n=head2 _readfile\n\n  Title   : _readfile()\n  Usage   : $self->_readfile();\n  Function: An internal function that reads a file and sets up the results\n  Returns : Nothing.\n  Args    : None\n  Notes   :\n\n\nsub _readfile {\n\tmy ($self, $file) = @_;\n\t$self->_initialize_io(-file=>$file);\n\tmy $line;\n\tmy $id='primer 3 parsed results'; # hopefully we'll get this, but we can set a temp id in case not.\n\twhile (defined($line=$self->_readline()) ) {\n\t\tchomp $line;\n\t\tnext unless ($line);\n\t\tmy ($return, $value) = split /=/, $line;\n\t\tif (uc($return) eq \"SEQUENCE\") {\n\t\t\t$self->{seqobject}=Bio::Seq->new(-seq=>$value, $id=>$id);\n\t\t\tnext;\n\t\t}\n\t\tif (uc($return) eq \"PRIMER_SEQUENCE_ID\") {\n\t\t\tif ($self->{seqobject}) {$self->{seqobject}->id($value)} else {$id=$value}\n\t\t}\n\n\t\t$self->{'results'}->{$return} = $value;\n\t}\n\n\t# convert the results to individual results\n\t$self->_separate();\n}\n\n=head2 next_primer\n\n  Title   : next_primer()\n  Usage   : while (my $primed_seq  = $primer3->next_primer()) {\n  Function: Retrieve the primed sequence and a primer pair, one at a time\n  Returns : Returns a Bio::Seq::PrimedSeq feature, one at a time\n  Args    : None\n  Notes   : Use $primed_seq->annotated_seq to get an annotated sequence\n            object you can write out.\n\n\nsub next_primer {\n\tmy $self = shift;\n\t# here we are going to convert the primers to Bio::SeqFeature::Primer objects\n\t# and the primer/sequence to Bio::Seq::PrimedSeq objects\n\t# the problem at the moment is that PrimedSeq can only take one sequence/primer pair, and\n\t# yet for each sequence we can have lots of primer pairs. We need a way to overcome this.\n\t# at the moment we can do this as a stream, I guess.\n\n\t$self->warn(\"No primers were found for: \".$self->{'seqobject'}->{'primary_id'})\n\t  if (! $self->number_of_results);\n\n\t$self->{'next_to_return'} = 0 unless ($self->{'next_to_return'});\n\treturn if ($self->{'next_to_return'} >= $self->number_of_results);\n\tmy $results = $self->primer_results($self->{'next_to_return'});\n\n\t$self->throw(\"No left primer sequence\") unless (${$results}{'PRIMER_LEFT_SEQUENCE'});\n\t$self->throw(\"No right primer sequence\") unless (${$results}{'PRIMER_RIGHT_SEQUENCE'});\n\t$self->throw(\"No target sequence\") unless ($self->{'seqobject'});\n\n\tmy $left_seq  = Bio::SeqFeature::Primer->new(\n                                   -primer_sequence_id => \"left_primer\",\n\t\t\t\t\t\t\t\t\t\t\t  -sequence => ${$results}{'PRIMER_LEFT_SEQUENCE'},\n\t\t\t\t\t\t\t\t\t\t\t  -display_id => ($self->{'next_to_return'} + 1) );\n\tmy $right_seq = Bio::SeqFeature::Primer->new(\n\t\t\t\t\t\t\t\t\t\t\t  -primer_sequence_id => \"right_primer\",\n\t\t\t\t\t\t\t\t\t\t\t  -sequence => ${$results}{'PRIMER_RIGHT_SEQUENCE'},\n\t\t\t\t\t\t\t\t\t\t\t  -display_id => ($self->{'next_to_return'} + 1) );\n\n\t# add data to the Primer objects\n\tfor my $key (%$results) {\n\t\t# skip the primer sequence data, already added above\n\t\tnext if ($key =~ /PRIMER_(LEFT|RIGHT)_SEQUENCE/i );\n\t\tif ($key =~ /PRIMER_LEFT/i) {\n\t\t\t$left_seq->add_tag_value($key, $$results{$key});\n\t\t} elsif ($key =~ /PRIMER_RIGHT/i) {\n\t\t\t$right_seq->add_tag_value($key, $$results{$key});\n\t\t}\n\t}\n\n\tmy $primed_seq = Bio::Seq::PrimedSeq->new(-target_sequence => clone($self->{'seqobject'}),\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-left_primer => $left_seq,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-right_primer => $right_seq);\n\n\t# add data to the the PrimedSeq object that's not specific to the Primers\n\tfor my $key (%$results) {\n\t\tnext if ($key =~ /PRIMER_(LEFT|RIGHT)/i );\n\t\t\t$primed_seq->add_tag_value($key, $$results{$key});\n\t}\n\n\t$self->{'next_to_return'}++;\n\treturn $primed_seq;\n}\n\n\n=head2 primer_stream\n\n  Title   : primer_stream()\n  Usage   : while (my $primed_seq  = $primer3->primer_stream()) {\n  Function: Retrieve the primer/sequences one at a time\n  Returns : Returns a Bio::Seq::PrimedSeq feature, one at a time\n  Args    : None\n  Notes   : Deprecated, just a link to next_primer\n\n\nsub primer_stream {\n\tmy $self=shift;\n\tmy $primedseq = $self->next_primer;\n\treturn $primedseq;\n}\n\n=head2 _separate\n\n  Title   : _separate()\n  Usage   : $self->_separate();\n  Function: An internal function that groups the results by number\n            (e.g. primer pair 1, etc)\n  Returns : Nothing.\n  Args    : None\n  Notes   :\n\n\nsub _separate {\n\tmy $self = shift;\n\tmy %results; # the results that we find\n\tmy $maxlocation = -1; # the maximum number of primers returned\n\tforeach my $key (keys %{$self->{'results'}}) {\n\t\tnext if (${$self->{'input_options'}}{$key}); # don't process it if it is an input key\n\n\t\tmy $location; # the number of the primer pair\n\t\t# names will have values like\n\t\t# PRIMER_RIGHT_SEQUENCE, PRIMER_RIGHT_2_SEQUENCE, PRIMER_PRODUCT_SIZE, and\n\t\t# PRIMER_PRODUCT_SIZE_3 hence we need to find and remove the number\n\t\tmy $tempkey=$key;\n\t\tif ($tempkey =~ s/_(\\d+)//) {\n\t\t\t$location=$1;\n\t\t\tif ($location > $maxlocation) {$maxlocation = $location}\n\t\t} elsif ( $tempkey =~ /PRIMER_(RIGHT|LEFT)_SEQUENCE/ ) {\n\t\t\t# first primers reported without a number, therefore set $location to 0\n\t\t\t$location = 0;\n\t\t\tif ($location > $maxlocation) {$maxlocation = $location}\n\t\t} else {\n\t\t\t$location = 0;\n\t\t}\n\t\t# we will hash the results by number, and then by name\n\t\t${$results{$location}}{$tempkey}=${$self->{'results'}}{$key};\n\t}\n\t$self->{'results_by_number'}=\\%results;\n\t$self->{'maximum_primers_returned'}=$maxlocation;\n}\n\n=head2 _set_variable\n\n  Title   : _set_variable()\n  Usage   : $self->_set_variable('variable name', 'value');\n  Function: An internal function that sets a variable\n  Returns : Nothing.\n  Args    : None\n  Notes   : Used to set $self->{results} and $self->seqobject","parameters":[{"label":"$self"},{"label":"$name"},{"label":"$value"}]},"name":"_set_variable","containerName":"main::","children":[{"definition":"my","line":423,"name":"$self","localvar":"my","containerName":"_set_variable","kind":13},{"name":"$name","containerName":"_set_variable","kind":13,"line":423},{"line":423,"containerName":"_set_variable","kind":13,"name":"$value"},{"containerName":"_set_variable","kind":13,"name":"$name","line":424},{"line":425,"name":"$self","containerName":"_set_variable","kind":13},{"kind":13,"containerName":"_set_variable","name":"$name","line":425},{"kind":13,"containerName":"_set_variable","name":"$value","line":425}],"detail":"($self,$name,$value)","definition":"sub"}]}