{"version":5,"vars":[{"name":"base","containerName":"","kind":2,"line":87},{"detail":"($class,@args)","definition":"sub","containerName":"main::","name":"new","children":[{"line":90,"name":"$class","containerName":"new","localvar":"my","kind":13,"definition":"my"},{"containerName":"new","kind":13,"name":"@args","line":90},{"line":92,"containerName":"new","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":92,"name":"$class","kind":13,"containerName":"new"},{"line":92,"kind":13,"containerName":"new","name":"@args"},{"line":94,"kind":13,"localvar":"my","containerName":"new","name":"$primary","definition":"my"},{"line":94,"kind":13,"containerName":"new","name":"$ptag"},{"kind":13,"containerName":"new","name":"$self","line":94},{"name":"_rearrange","kind":12,"containerName":"new","line":94},{"line":94,"containerName":"new","kind":13,"name":"@args"},{"name":"$self","kind":13,"containerName":"new","line":95},{"kind":12,"containerName":"new","name":"primary_tag","line":95},{"line":95,"name":"$primary","kind":13,"containerName":"new"},{"line":95,"name":"$ptag","containerName":"new","kind":13},{"line":97,"name":"$self","kind":13,"containerName":"new"}],"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":""},"range":{"end":{"character":9999,"line":98},"start":{"line":89,"character":0}},"kind":12,"line":89},{"line":92,"kind":12,"containerName":"new","name":"SUPER"},{"definition":"sub","detail":"($self,$cds)","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"predicted_cds","kind":13,"line":122},{"line":122,"containerName":"predicted_cds","kind":13,"name":"$cds"},{"line":124,"name":"$cds","kind":13,"containerName":"predicted_cds"},{"line":125,"containerName":"predicted_cds","kind":13,"name":"$self"},{"name":"$cds","kind":13,"containerName":"predicted_cds","line":125},{"line":127,"name":"$self","kind":13,"containerName":"predicted_cds"}],"name":"predicted_cds","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$cds"}],"documentation":"1;\n# $Id: Gene.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Prediction::Gene\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Prediction::Gene - a predicted gene structure feature\n\n=head1 SYNOPSIS\n\n  #See documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing a predicted gene structure. This class actually\ninherits off Bio::SeqFeature::Gene::Transcript and therefore has all that\nfunctionality, plus a few methods supporting predicted sequence features,\nlike a predicted CDS and a predicted translation.\n\nExons held by an instance of this class will usually be instances of\nBio::Tools::Prediction::Exon, although they do not have to be. Refer to the\ndocumentation of the class that produced the instance.\n\nNormally, you will not want to create an instance of this class yourself.\nInstead, classes representing the results of gene structure prediction\nprograms will do that.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net or hilmar.lapp-at-pharma.novartis.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Prediction::Gene;\nuse strict;\n\n\n\nuse base qw(Bio::SeqFeature::Gene::Transcript);\n\nsub new {\n    my($class,@args) = @_;\n    \n    my $self = $class->SUPER::new(@args);\n\n    my ($primary,$ptag) = $self->_rearrange([qw(PRIMARY PRIMARY_TAG)],@args);\n    $self->primary_tag('predicted_gene') unless $primary || $ptag;\n\n    return $self; \n}\n\n\n=head2 predicted_cds\n\n Title   : predicted_cds\n Usage   : $predicted_cds_dna = $gene->predicted_cds();\n           $gene->predicted_cds($predicted_cds_dna);\n Function: Get/Set the CDS (coding sequence) as predicted by a program.\n\n           This method is independent of an attached_seq. There is no\n           guarantee whatsoever that the returned CDS has anything to do\n           (e.g., matches) with the sequence covered by the exons as annotated\n           through this object.\n\n Example :\n Returns : A Bio::PrimarySeqI implementing object holding the DNA sequence\n           defined as coding by a prediction of a program.\n Args    : On set, a Bio::PrimarySeqI implementing object holding the DNA \n           sequence defined as coding by a prediction of a program.","label":"predicted_cds($self,$cds)"},"line":121,"range":{"end":{"line":128,"character":9999},"start":{"character":0,"line":121}},"kind":12},{"containerName":"main::","name":"predicted_protein","children":[{"definition":"my","localvar":"my","containerName":"predicted_protein","kind":13,"name":"$self","line":152},{"name":"$aa","kind":13,"containerName":"predicted_protein","line":152},{"containerName":"predicted_protein","kind":13,"name":"$aa","line":154},{"line":155,"name":"$self","kind":13,"containerName":"predicted_protein"},{"name":"$aa","containerName":"predicted_protein","kind":13,"line":155},{"name":"$self","kind":13,"containerName":"predicted_protein","line":157}],"detail":"($self,$aa)","definition":"sub","range":{"end":{"line":158,"character":9999},"start":{"line":151,"character":0}},"kind":12,"line":151,"signature":{"documentation":"1;\n# $Id: Gene.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Prediction::Gene\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Prediction::Gene - a predicted gene structure feature\n\n=head1 SYNOPSIS\n\n  #See documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing a predicted gene structure. This class actually\ninherits off Bio::SeqFeature::Gene::Transcript and therefore has all that\nfunctionality, plus a few methods supporting predicted sequence features,\nlike a predicted CDS and a predicted translation.\n\nExons held by an instance of this class will usually be instances of\nBio::Tools::Prediction::Exon, although they do not have to be. Refer to the\ndocumentation of the class that produced the instance.\n\nNormally, you will not want to create an instance of this class yourself.\nInstead, classes representing the results of gene structure prediction\nprograms will do that.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net or hilmar.lapp-at-pharma.novartis.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Prediction::Gene;\nuse strict;\n\n\n\nuse base qw(Bio::SeqFeature::Gene::Transcript);\n\nsub new {\n    my($class,@args) = @_;\n    \n    my $self = $class->SUPER::new(@args);\n\n    my ($primary,$ptag) = $self->_rearrange([qw(PRIMARY PRIMARY_TAG)],@args);\n    $self->primary_tag('predicted_gene') unless $primary || $ptag;\n\n    return $self; \n}\n\n\n=head2 predicted_cds\n\n Title   : predicted_cds\n Usage   : $predicted_cds_dna = $gene->predicted_cds();\n           $gene->predicted_cds($predicted_cds_dna);\n Function: Get/Set the CDS (coding sequence) as predicted by a program.\n\n           This method is independent of an attached_seq. There is no\n           guarantee whatsoever that the returned CDS has anything to do\n           (e.g., matches) with the sequence covered by the exons as annotated\n           through this object.\n\n Example :\n Returns : A Bio::PrimarySeqI implementing object holding the DNA sequence\n           defined as coding by a prediction of a program.\n Args    : On set, a Bio::PrimarySeqI implementing object holding the DNA \n           sequence defined as coding by a prediction of a program.\n\n\nsub predicted_cds {\n    my ($self, $cds) = @_;\n\n    if(defined($cds)) {\n\t$self->{'_predicted_cds'} = $cds;\n    }\n    return $self->{'_predicted_cds'};\n}\n\n=head2 predicted_protein\n\n Title   : predicted_protein\n Usage   : $predicted_protein_seq = $gene->predicted_protein();\n           $gene->predicted_protein($predicted_protein_seq);\n Function: Get/Set the protein translation as predicted by a program.\n\n           This method is independent of an attached_seq. There is no\n           guarantee whatsoever that the returned translation has anything to\n           do with the sequence covered by the exons as annotated\n           through this object, or the sequence returned by predicted_cds(),\n           although it should usually be just the standard translation.\n\n Example :\n Returns : A Bio::PrimarySeqI implementing object holding the protein \n           translation as predicted by a program.\n Args    : On set, a Bio::PrimarySeqI implementing object holding the protein \n           translation as predicted by a program.","parameters":[{"label":"$self"},{"label":"$aa"}],"label":"predicted_protein($self,$aa)"}}]}