{"vars":[{"line":81,"containerName":"","kind":2,"name":"base"},{"detail":"($class,@args)","definition":"sub","containerName":"main::","name":"new","children":[{"containerName":"new","localvar":"my","kind":13,"name":"$class","line":84,"definition":"my"},{"kind":13,"containerName":"new","name":"@args","line":84},{"name":"$self","localvar":"my","kind":13,"containerName":"new","line":86,"definition":"my"},{"name":"$class","containerName":"new","kind":13,"line":86},{"name":"@args","containerName":"new","kind":13,"line":86},{"line":88,"kind":13,"containerName":"new","name":"$self"}],"signature":{"label":"new($class,@args)","documentation":"","parameters":[{"label":"$class"},{"label":"@args"}]},"range":{"end":{"character":9999,"line":89},"start":{"character":0,"line":83}},"kind":12,"line":83},{"containerName":"new","kind":12,"name":"SUPER","line":86},{"name":"predicted_cds","containerName":"main::","children":[{"kind":13,"localvar":"my","containerName":"predicted_cds","name":"$self","line":113,"definition":"my"},{"line":113,"kind":13,"containerName":"predicted_cds","name":"$cds"},{"line":115,"containerName":"predicted_cds","kind":13,"name":"$cds"},{"containerName":"predicted_cds","kind":13,"name":"$self","line":116},{"kind":13,"containerName":"predicted_cds","name":"$cds","line":116},{"line":118,"containerName":"predicted_cds","kind":13,"name":"$self"}],"detail":"($self,$cds)","definition":"sub","range":{"start":{"line":112,"character":0},"end":{"character":9999,"line":119}},"kind":12,"line":112,"signature":{"label":"predicted_cds($self,$cds)","documentation":"1;\n# $Id: Exon.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Prediction::Exon\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Prediction::Exon - A predicted exon feature\n\n=head1 SYNOPSIS\n\n  # See documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing a predicted exon. This class actually inherits\noff Bio::SeqFeature::Gene::Exon and therefore has all that\nfunctionality (also implements Bio::SeqFeatureI), plus a few methods\nsupporting predicted features, like various scores and a\nsignificance. Even though these were inspired by GenScan results, at\nleast a subset should be generally useable for exon prediction\nresults.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Prediction::Exon;\nuse strict;\n\n\nuse base qw(Bio::SeqFeature::Gene::Exon);\n\nsub new {\n    my($class,@args) = @_;\n    \n    my $self = $class->SUPER::new(@args);\n\n    return $self;\n}\n\n\n=head2 predicted_cds\n\n Title   : predicted_cds\n Usage   : $predicted_cds_dna = $exon->predicted_cds();\n           $exon->predicted_cds($predicted_cds_dna);\n Function: Get/Set the CDS (coding sequence) as predicted by a program.\n\n           This method is independent of an attached_seq. There is no\n           guarantee whatsoever that the returned CDS has anything to do\n           (e.g., matches) with the sequence covered by the exons as annotated\n           through this object.\n\n Example :\n Returns : A Bio::PrimarySeqI implementing object holding the DNA sequence\n           defined as coding by a prediction of a program.\n Args    : On set, a Bio::PrimarySeqI implementing object holding the DNA \n           sequence defined as coding by a prediction of a program.","parameters":[{"label":"$self"},{"label":"$cds"}]}},{"detail":"($self,$aa)","definition":"sub","containerName":"main::","name":"predicted_protein","children":[{"name":"$self","containerName":"predicted_protein","localvar":"my","kind":13,"line":143,"definition":"my"},{"line":143,"containerName":"predicted_protein","kind":13,"name":"$aa"},{"line":145,"containerName":"predicted_protein","kind":13,"name":"$aa"},{"name":"$self","kind":13,"containerName":"predicted_protein","line":146},{"line":146,"name":"$aa","kind":13,"containerName":"predicted_protein"},{"line":148,"name":"$self","kind":13,"containerName":"predicted_protein"}],"signature":{"label":"predicted_protein($self,$aa)","parameters":[{"label":"$self"},{"label":"$aa"}],"documentation":"1;\n# $Id: Exon.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Prediction::Exon\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Prediction::Exon - A predicted exon feature\n\n=head1 SYNOPSIS\n\n  # See documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing a predicted exon. This class actually inherits\noff Bio::SeqFeature::Gene::Exon and therefore has all that\nfunctionality (also implements Bio::SeqFeatureI), plus a few methods\nsupporting predicted features, like various scores and a\nsignificance. Even though these were inspired by GenScan results, at\nleast a subset should be generally useable for exon prediction\nresults.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Prediction::Exon;\nuse strict;\n\n\nuse base qw(Bio::SeqFeature::Gene::Exon);\n\nsub new {\n    my($class,@args) = @_;\n    \n    my $self = $class->SUPER::new(@args);\n\n    return $self;\n}\n\n\n=head2 predicted_cds\n\n Title   : predicted_cds\n Usage   : $predicted_cds_dna = $exon->predicted_cds();\n           $exon->predicted_cds($predicted_cds_dna);\n Function: Get/Set the CDS (coding sequence) as predicted by a program.\n\n           This method is independent of an attached_seq. There is no\n           guarantee whatsoever that the returned CDS has anything to do\n           (e.g., matches) with the sequence covered by the exons as annotated\n           through this object.\n\n Example :\n Returns : A Bio::PrimarySeqI implementing object holding the DNA sequence\n           defined as coding by a prediction of a program.\n Args    : On set, a Bio::PrimarySeqI implementing object holding the DNA \n           sequence defined as coding by a prediction of a program.\n\n\nsub predicted_cds {\n    my ($self, $cds) = @_;\n\n    if(defined($cds)) {\n\t$self->{'_predicted_cds'} = $cds;\n    }\n    return $self->{'_predicted_cds'};\n}\n\n=head2 predicted_protein\n\n Title   : predicted_protein\n Usage   : $predicted_protein_seq = $exon->predicted_protein();\n           $exon->predicted_protein($predicted_protein_seq);\n Function: Get/Set the protein translation as predicted by a program.\n\n           This method is independent of an attached_seq. There is no\n           guarantee whatsoever that the returned translation has anything to\n           do with the sequence covered by the exons as annotated\n           through this object, or the sequence returned by predicted_cds(),\n           although it should usually be just the standard translation.\n\n Example :\n Returns : A Bio::PrimarySeqI implementing object holding the protein \n           translation as predicted by a program.\n Args    : On set, a Bio::PrimarySeqI implementing object holding the protein \n           translation as predicted by a program."},"kind":12,"range":{"start":{"character":0,"line":142},"end":{"line":149,"character":9999}},"line":142},{"children":[{"line":164,"containerName":"significance","kind":12,"name":"_tag_value"}],"containerName":"main::","name":"significance","definition":"sub","line":163,"kind":12,"range":{"end":{"line":165,"character":9999},"start":{"character":0,"line":163}}},{"definition":"sub","containerName":"main::","name":"start_signal_score","children":[{"containerName":"start_signal_score","kind":12,"name":"_tag_value","line":181}],"kind":12,"range":{"end":{"character":9999,"line":182},"start":{"character":0,"line":180}},"line":180},{"definition":"sub","name":"end_signal_score","containerName":"main::","children":[{"name":"_tag_value","kind":12,"containerName":"end_signal_score","line":198}],"range":{"start":{"line":197,"character":0},"end":{"character":9999,"line":199}},"kind":12,"line":197},{"range":{"end":{"character":9999,"line":215},"start":{"line":213,"character":0}},"kind":12,"line":213,"definition":"sub","containerName":"main::","name":"coding_signal_score","children":[{"kind":12,"containerName":"coding_signal_score","name":"_tag_value","line":214}]}],"version":5}