{"version":5,"vars":[{"line":136,"containerName":"","kind":2,"name":"base"},{"children":[{"line":140,"name":"$class","localvar":"my","kind":13,"containerName":"new","definition":"my"},{"line":140,"name":"@args","containerName":"new","kind":13},{"line":142,"localvar":"my","containerName":"new","kind":13,"name":"$self","definition":"my"},{"name":"$class","containerName":"new","kind":13,"line":142},{"name":"@args","containerName":"new","kind":13,"line":142},{"definition":"my","localvar":"my","containerName":"new","kind":13,"name":"$seqobj","line":144},{"line":144,"name":"$self","kind":13,"containerName":"new"},{"line":144,"containerName":"new","kind":12,"name":"_rearrange"},{"line":144,"name":"@args","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$seqobj","line":145},{"kind":13,"containerName":"new","name":"@args","line":145},{"line":145,"name":"$args","kind":13,"containerName":"new"},{"line":147,"name":"$seqobj","kind":13,"containerName":"new"},{"line":147,"kind":13,"containerName":"new","name":"$args"},{"name":"$seqobj","containerName":"new","kind":13,"line":149},{"name":"isa","containerName":"new","kind":12,"line":149},{"line":151,"kind":13,"containerName":"new","name":"$self"},{"line":151,"kind":12,"containerName":"new","name":"throw"},{"name":"$self","kind":13,"containerName":"new","line":154},{"kind":13,"containerName":"new","name":"$seqobj","line":154},{"name":"$self","kind":13,"containerName":"new","line":156}],"containerName":"main::","name":"new","definition":"sub","detail":"($class,@args)","line":138,"range":{"start":{"character":0,"line":138},"end":{"character":9999,"line":157}},"kind":12,"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":""}},{"line":142,"containerName":"new","kind":12,"name":"SUPER"},{"name":"structural","containerName":"main::","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"structural","line":173,"definition":"my"},{"definition":"my","line":174,"localvar":"my","kind":13,"containerName":"structural","name":"$seqstring"},{"line":174,"containerName":"structural","kind":13,"name":"$self"},{"line":178,"name":"$seqstring","containerName":"structural","kind":13},{"line":179,"containerName":"structural","kind":13,"name":"$seqstring"},{"containerName":"structural","kind":13,"name":"$seqstring","line":180},{"name":"$seqstring","containerName":"structural","kind":13,"line":181},{"name":"$seqstring","kind":13,"containerName":"structural","line":182},{"kind":13,"containerName":"structural","name":"$seqstring","line":183},{"line":185,"name":"$seqstring","kind":13,"containerName":"structural"}],"detail":"()","definition":"sub","range":{"end":{"line":188,"character":9999},"start":{"character":0,"line":171}},"kind":12,"line":171,"signature":{"documentation":"1;\n#$Id: OddCodes.pm 16123 2009-09-17 12:57:27Z cjfields $\n#-----------------------------------------------------------------------------\n# PACKAGE    : OddCodes.pm\n# PURPOSE    : To write amino acid sequences in alternative alphabets\n# AUTHOR     : Derek Gatherer (D.Gatherer@organon.nhe.akzonobel.nl)\n# SOURCE     :\n# CREATED    : 8th July 2000\n# MODIFIED   :\n# DISCLAIMER : I am employed in the pharmaceutical industry but my\n#            : employers do not endorse or sponsor this module\n#            : in any way whatsoever.  The above email address is\n#            : given purely for the purpose of easy communication\n#            : with the author, and does not imply any connection\n#\t     : between my employers and anything written below.\n# LICENCE    : You may distribute this module under the same terms\n#\t     : as the rest of BioPerl.\n#----------------------------------------------------------------------------\n\n=head1 NAME\n\nBio::Tools::OddCodes - Object holding alternative alphabet coding for\none protein sequence\n\n=head1 SYNOPSIS\n\n  # Take a sequence object from eg, an inputstream, and creates an\n  # object for the purposes of rewriting that sequence in another\n  # alphabet.  These are abbreviated amino acid sequence alphabets,\n  # designed to simplify the statistical aspects of analysing protein\n  # sequences, by reducing the combinatorial explosion of the\n  # 20-letter alphabet.  These abbreviated alphabets range in size\n  # from 2 to 8.\n\n  # Creating the OddCodes object, eg:\n\n\tmy $inputstream = Bio::SeqIO->new( '-file' => \"seqfile\",\n                                           '-format' => 'Fasta');\n\tmy $seqobj = $inputstream->next_seq();\n\tmy $oddcode_obj = Bio::Tools::Oddcodes->new(-seq => $seqobj);\n\n  # or:\n\n\tmy $seqobj = Bio::PrimarySeq->new\n              (-seq=>'[cut and paste a sequence here]',\n               -alphabet => 'protein',\n               -id => 'test');\n\tmy $oddcode_obj  =  Bio::Tools::OddCodes->new(-seq => $seqobj);\n\n  # do the alternative coding, returning the answer as a reference to\n  # a string\n\n\tmy $output = $oddcode_obj->structural();\n\tmy $output = $oddcode_obj->chemical();\n\tmy $output = $oddcode_obj->functional();\n\tmy $output = $oddcode_obj->charge();\n\tmy $output = $oddcode_obj->hydrophobic();\n\tmy $output = $oddcode_obj->Dayhoff();\n\tmy $output = $oddcode_obj->Sneath();\n\tmy $output = $oddcode_obj->Stanfel();\n\n\n  # display sequence in new form, eg:\n\n\tmy $new_coding = $$output;\n\tprint \"\\n$new_coding\";\n\n=head1 DESCRIPTION\n\nBio::Tools::Oddcodes is a welterweight object for rewriting a protein\nsequence in an alternative alphabet.  Eight of these are provided, ranging\nfrom the the 2-letter hydrophobic alphabet, to the 8-letter chemical\nalphabet.  These are useful for the statistical analysis of protein\nsequences since they can partially avoid the combinatorial explosion\nproduced by the full 20-letter alphabet (eg. 400 dimers, 8000 trimers\netc.)\n\nThe objects will print out a warning if the input sequence is not a\nprotein. If you know what you are doing, you can silence the warning\nby setting verbose() to a negative value.\n\nSee SYNOPSIS above for object creation code.\n\n=head1 REFERENCES\n\nStanfel LE (1996) A new approach to clustering the amino acids.  J. theor.\nBiol. 183, 195-205.\n\nKarlin S, Ost F and Blaisdell BE (1989)  Patterns in DNA and amino acid\nsequences and their statistical significance.  Chapter 6 of: Mathematical\nMethods for DNA Sequences.  Waterman MS (ed.)  CRC Press, Boca Raton , FL.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nDerek Gatherer\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::OddCodes;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nsub new\n{\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($seqobj) = $self->_rearrange([qw(SEQ)],@args);\n    if((! defined($seqobj)) && @args && ref($args[0])) {\n\t# parameter not passed as named parameter?\n\t$seqobj = $args[0];\n    }\n    unless  ($seqobj->isa(\"Bio::PrimarySeqI\"))\n    {\n        $self->throw(\"Bio::Tools::OddCodes only works on PrimarySeqI objects\");\n    }\n\n    $self->{'_seqref'} = $seqobj;\n\n    return $self;\n}\n\n=head2 structural\n\n Title   : structural\n Usage   : $output = $oddcode_obj->structural();\n Function: turns amino acid sequence into 3-letter structural alphabet\n\t : A (ambivalent), E (external), I (internal)\n Example : a sequence ACDEFGH will become AAEEIAE\n Returns : Reference to the new sequence string\n Args    : none","parameters":[],"label":"structural()"}},{"line":174,"name":"_pullseq","kind":12},{"containerName":"main::","name":"functional","children":[{"definition":"my","line":204,"name":"$self","containerName":"functional","localvar":"my","kind":13},{"definition":"my","name":"$seqstring","localvar":"my","containerName":"functional","kind":13,"line":205},{"line":205,"name":"$self","kind":13,"containerName":"functional"},{"name":"$seqstring","kind":13,"containerName":"functional","line":209},{"line":210,"name":"$seqstring","containerName":"functional","kind":13},{"containerName":"functional","kind":13,"name":"$seqstring","line":211},{"line":212,"kind":13,"containerName":"functional","name":"$seqstring"},{"line":213,"name":"$seqstring","kind":13,"containerName":"functional"},{"line":214,"containerName":"functional","kind":13,"name":"$seqstring"},{"containerName":"functional","kind":13,"name":"$seqstring","line":215},{"containerName":"functional","kind":13,"name":"$seqstring","line":216},{"name":"$seqstring","containerName":"functional","kind":13,"line":218}],"detail":"()","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":221},"start":{"character":0,"line":202}},"line":202,"signature":{"label":"functional()","parameters":[],"documentation":"1;\n#$Id: OddCodes.pm 16123 2009-09-17 12:57:27Z cjfields $\n#-----------------------------------------------------------------------------\n# PACKAGE    : OddCodes.pm\n# PURPOSE    : To write amino acid sequences in alternative alphabets\n# AUTHOR     : Derek Gatherer (D.Gatherer@organon.nhe.akzonobel.nl)\n# SOURCE     :\n# CREATED    : 8th July 2000\n# MODIFIED   :\n# DISCLAIMER : I am employed in the pharmaceutical industry but my\n#            : employers do not endorse or sponsor this module\n#            : in any way whatsoever.  The above email address is\n#            : given purely for the purpose of easy communication\n#            : with the author, and does not imply any connection\n#\t     : between my employers and anything written below.\n# LICENCE    : You may distribute this module under the same terms\n#\t     : as the rest of BioPerl.\n#----------------------------------------------------------------------------\n\n=head1 NAME\n\nBio::Tools::OddCodes - Object holding alternative alphabet coding for\none protein sequence\n\n=head1 SYNOPSIS\n\n  # Take a sequence object from eg, an inputstream, and creates an\n  # object for the purposes of rewriting that sequence in another\n  # alphabet.  These are abbreviated amino acid sequence alphabets,\n  # designed to simplify the statistical aspects of analysing protein\n  # sequences, by reducing the combinatorial explosion of the\n  # 20-letter alphabet.  These abbreviated alphabets range in size\n  # from 2 to 8.\n\n  # Creating the OddCodes object, eg:\n\n\tmy $inputstream = Bio::SeqIO->new( '-file' => \"seqfile\",\n                                           '-format' => 'Fasta');\n\tmy $seqobj = $inputstream->next_seq();\n\tmy $oddcode_obj = Bio::Tools::Oddcodes->new(-seq => $seqobj);\n\n  # or:\n\n\tmy $seqobj = Bio::PrimarySeq->new\n              (-seq=>'[cut and paste a sequence here]',\n               -alphabet => 'protein',\n               -id => 'test');\n\tmy $oddcode_obj  =  Bio::Tools::OddCodes->new(-seq => $seqobj);\n\n  # do the alternative coding, returning the answer as a reference to\n  # a string\n\n\tmy $output = $oddcode_obj->structural();\n\tmy $output = $oddcode_obj->chemical();\n\tmy $output = $oddcode_obj->functional();\n\tmy $output = $oddcode_obj->charge();\n\tmy $output = $oddcode_obj->hydrophobic();\n\tmy $output = $oddcode_obj->Dayhoff();\n\tmy $output = $oddcode_obj->Sneath();\n\tmy $output = $oddcode_obj->Stanfel();\n\n\n  # display sequence in new form, eg:\n\n\tmy $new_coding = $$output;\n\tprint \"\\n$new_coding\";\n\n=head1 DESCRIPTION\n\nBio::Tools::Oddcodes is a welterweight object for rewriting a protein\nsequence in an alternative alphabet.  Eight of these are provided, ranging\nfrom the the 2-letter hydrophobic alphabet, to the 8-letter chemical\nalphabet.  These are useful for the statistical analysis of protein\nsequences since they can partially avoid the combinatorial explosion\nproduced by the full 20-letter alphabet (eg. 400 dimers, 8000 trimers\netc.)\n\nThe objects will print out a warning if the input sequence is not a\nprotein. If you know what you are doing, you can silence the warning\nby setting verbose() to a negative value.\n\nSee SYNOPSIS above for object creation code.\n\n=head1 REFERENCES\n\nStanfel LE (1996) A new approach to clustering the amino acids.  J. theor.\nBiol. 183, 195-205.\n\nKarlin S, Ost F and Blaisdell BE (1989)  Patterns in DNA and amino acid\nsequences and their statistical significance.  Chapter 6 of: Mathematical\nMethods for DNA Sequences.  Waterman MS (ed.)  CRC Press, Boca Raton , FL.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nDerek Gatherer\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::OddCodes;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nsub new\n{\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($seqobj) = $self->_rearrange([qw(SEQ)],@args);\n    if((! defined($seqobj)) && @args && ref($args[0])) {\n\t# parameter not passed as named parameter?\n\t$seqobj = $args[0];\n    }\n    unless  ($seqobj->isa(\"Bio::PrimarySeqI\"))\n    {\n        $self->throw(\"Bio::Tools::OddCodes only works on PrimarySeqI objects\");\n    }\n\n    $self->{'_seqref'} = $seqobj;\n\n    return $self;\n}\n\n=head2 structural\n\n Title   : structural\n Usage   : $output = $oddcode_obj->structural();\n Function: turns amino acid sequence into 3-letter structural alphabet\n\t : A (ambivalent), E (external), I (internal)\n Example : a sequence ACDEFGH will become AAEEIAE\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub structural()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\t# see _pullseq() below\n\n# now the real business\n\n\t$seqstring =~ tr/[ACGPSTWY]/1/;\n\t$seqstring =~ tr/[RNDQEHK]/2/;\n\t$seqstring =~ tr/[ILMFV]/3/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/E/;\n\t$seqstring =~ tr/3/I/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 functional\n\n Title   : functional\n Usage   : $output = $oddcode_obj->functional();\n Function: turns amino acid sequence into 4-letter functional alphabet\n\t : A (acidic), C (basic), H (hydrophobic), P (polar)\n Example : a sequence ACDEFGH will become HPAAHHC\n Returns : Reference to the new sequence string\n Args    : none"}},{"kind":12,"name":"_pullseq","line":205},{"line":235,"kind":12,"range":{"end":{"character":9999,"line":250},"start":{"line":235,"character":0}},"signature":{"label":"hydrophobic()","parameters":[],"documentation":"1;\n#$Id: OddCodes.pm 16123 2009-09-17 12:57:27Z cjfields $\n#-----------------------------------------------------------------------------\n# PACKAGE    : OddCodes.pm\n# PURPOSE    : To write amino acid sequences in alternative alphabets\n# AUTHOR     : Derek Gatherer (D.Gatherer@organon.nhe.akzonobel.nl)\n# SOURCE     :\n# CREATED    : 8th July 2000\n# MODIFIED   :\n# DISCLAIMER : I am employed in the pharmaceutical industry but my\n#            : employers do not endorse or sponsor this module\n#            : in any way whatsoever.  The above email address is\n#            : given purely for the purpose of easy communication\n#            : with the author, and does not imply any connection\n#\t     : between my employers and anything written below.\n# LICENCE    : You may distribute this module under the same terms\n#\t     : as the rest of BioPerl.\n#----------------------------------------------------------------------------\n\n=head1 NAME\n\nBio::Tools::OddCodes - Object holding alternative alphabet coding for\none protein sequence\n\n=head1 SYNOPSIS\n\n  # Take a sequence object from eg, an inputstream, and creates an\n  # object for the purposes of rewriting that sequence in another\n  # alphabet.  These are abbreviated amino acid sequence alphabets,\n  # designed to simplify the statistical aspects of analysing protein\n  # sequences, by reducing the combinatorial explosion of the\n  # 20-letter alphabet.  These abbreviated alphabets range in size\n  # from 2 to 8.\n\n  # Creating the OddCodes object, eg:\n\n\tmy $inputstream = Bio::SeqIO->new( '-file' => \"seqfile\",\n                                           '-format' => 'Fasta');\n\tmy $seqobj = $inputstream->next_seq();\n\tmy $oddcode_obj = Bio::Tools::Oddcodes->new(-seq => $seqobj);\n\n  # or:\n\n\tmy $seqobj = Bio::PrimarySeq->new\n              (-seq=>'[cut and paste a sequence here]',\n               -alphabet => 'protein',\n               -id => 'test');\n\tmy $oddcode_obj  =  Bio::Tools::OddCodes->new(-seq => $seqobj);\n\n  # do the alternative coding, returning the answer as a reference to\n  # a string\n\n\tmy $output = $oddcode_obj->structural();\n\tmy $output = $oddcode_obj->chemical();\n\tmy $output = $oddcode_obj->functional();\n\tmy $output = $oddcode_obj->charge();\n\tmy $output = $oddcode_obj->hydrophobic();\n\tmy $output = $oddcode_obj->Dayhoff();\n\tmy $output = $oddcode_obj->Sneath();\n\tmy $output = $oddcode_obj->Stanfel();\n\n\n  # display sequence in new form, eg:\n\n\tmy $new_coding = $$output;\n\tprint \"\\n$new_coding\";\n\n=head1 DESCRIPTION\n\nBio::Tools::Oddcodes is a welterweight object for rewriting a protein\nsequence in an alternative alphabet.  Eight of these are provided, ranging\nfrom the the 2-letter hydrophobic alphabet, to the 8-letter chemical\nalphabet.  These are useful for the statistical analysis of protein\nsequences since they can partially avoid the combinatorial explosion\nproduced by the full 20-letter alphabet (eg. 400 dimers, 8000 trimers\netc.)\n\nThe objects will print out a warning if the input sequence is not a\nprotein. If you know what you are doing, you can silence the warning\nby setting verbose() to a negative value.\n\nSee SYNOPSIS above for object creation code.\n\n=head1 REFERENCES\n\nStanfel LE (1996) A new approach to clustering the amino acids.  J. theor.\nBiol. 183, 195-205.\n\nKarlin S, Ost F and Blaisdell BE (1989)  Patterns in DNA and amino acid\nsequences and their statistical significance.  Chapter 6 of: Mathematical\nMethods for DNA Sequences.  Waterman MS (ed.)  CRC Press, Boca Raton , FL.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nDerek Gatherer\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::OddCodes;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nsub new\n{\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($seqobj) = $self->_rearrange([qw(SEQ)],@args);\n    if((! defined($seqobj)) && @args && ref($args[0])) {\n\t# parameter not passed as named parameter?\n\t$seqobj = $args[0];\n    }\n    unless  ($seqobj->isa(\"Bio::PrimarySeqI\"))\n    {\n        $self->throw(\"Bio::Tools::OddCodes only works on PrimarySeqI objects\");\n    }\n\n    $self->{'_seqref'} = $seqobj;\n\n    return $self;\n}\n\n=head2 structural\n\n Title   : structural\n Usage   : $output = $oddcode_obj->structural();\n Function: turns amino acid sequence into 3-letter structural alphabet\n\t : A (ambivalent), E (external), I (internal)\n Example : a sequence ACDEFGH will become AAEEIAE\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub structural()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\t# see _pullseq() below\n\n# now the real business\n\n\t$seqstring =~ tr/[ACGPSTWY]/1/;\n\t$seqstring =~ tr/[RNDQEHK]/2/;\n\t$seqstring =~ tr/[ILMFV]/3/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/E/;\n\t$seqstring =~ tr/3/I/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 functional\n\n Title   : functional\n Usage   : $output = $oddcode_obj->functional();\n Function: turns amino acid sequence into 4-letter functional alphabet\n\t : A (acidic), C (basic), H (hydrophobic), P (polar)\n Example : a sequence ACDEFGH will become HPAAHHC\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub functional()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\n\n# now the real business\n\n\t$seqstring =~ tr/[DE]/1/;\n\t$seqstring =~ tr/[HKR]/2/;\n\t$seqstring =~ tr/[AFILMPVW]/3/;\n\t$seqstring =~ tr/[CGNQSTY]/4/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/C/;\n\t$seqstring =~ tr/3/H/;\n\t$seqstring =~ tr/4/P/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 hydrophobic\n\n Title   : hydrophobic\n Usage   : $output = $oddcode_obj->hydrophobic();\n Function: turns amino acid sequence into 2-letter hydrophobicity alphabet\n\t : O (hydrophobic), I (hydrophilic)\n Example : a sequence ACDEFGH will become OIIIOII\n Returns : Reference to the new sequence string\n Args    : none"},"children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"hydrophobic","line":237},{"definition":"my","line":238,"name":"$seqstring","localvar":"my","kind":13,"containerName":"hydrophobic"},{"line":238,"kind":13,"containerName":"hydrophobic","name":"$self"},{"name":"$seqstring","containerName":"hydrophobic","kind":13,"line":242},{"name":"$seqstring","kind":13,"containerName":"hydrophobic","line":243},{"line":244,"name":"$seqstring","kind":13,"containerName":"hydrophobic"},{"line":245,"name":"$seqstring","containerName":"hydrophobic","kind":13},{"line":247,"name":"$seqstring","containerName":"hydrophobic","kind":13}],"name":"hydrophobic","containerName":"main::","definition":"sub","detail":"()"},{"kind":12,"name":"_pullseq","line":238},{"line":265,"kind":12,"range":{"end":{"line":288,"character":9999},"start":{"line":265,"character":0}},"signature":{"label":"Dayhoff()","parameters":[],"documentation":"1;\n#$Id: OddCodes.pm 16123 2009-09-17 12:57:27Z cjfields $\n#-----------------------------------------------------------------------------\n# PACKAGE    : OddCodes.pm\n# PURPOSE    : To write amino acid sequences in alternative alphabets\n# AUTHOR     : Derek Gatherer (D.Gatherer@organon.nhe.akzonobel.nl)\n# SOURCE     :\n# CREATED    : 8th July 2000\n# MODIFIED   :\n# DISCLAIMER : I am employed in the pharmaceutical industry but my\n#            : employers do not endorse or sponsor this module\n#            : in any way whatsoever.  The above email address is\n#            : given purely for the purpose of easy communication\n#            : with the author, and does not imply any connection\n#\t     : between my employers and anything written below.\n# LICENCE    : You may distribute this module under the same terms\n#\t     : as the rest of BioPerl.\n#----------------------------------------------------------------------------\n\n=head1 NAME\n\nBio::Tools::OddCodes - Object holding alternative alphabet coding for\none protein sequence\n\n=head1 SYNOPSIS\n\n  # Take a sequence object from eg, an inputstream, and creates an\n  # object for the purposes of rewriting that sequence in another\n  # alphabet.  These are abbreviated amino acid sequence alphabets,\n  # designed to simplify the statistical aspects of analysing protein\n  # sequences, by reducing the combinatorial explosion of the\n  # 20-letter alphabet.  These abbreviated alphabets range in size\n  # from 2 to 8.\n\n  # Creating the OddCodes object, eg:\n\n\tmy $inputstream = Bio::SeqIO->new( '-file' => \"seqfile\",\n                                           '-format' => 'Fasta');\n\tmy $seqobj = $inputstream->next_seq();\n\tmy $oddcode_obj = Bio::Tools::Oddcodes->new(-seq => $seqobj);\n\n  # or:\n\n\tmy $seqobj = Bio::PrimarySeq->new\n              (-seq=>'[cut and paste a sequence here]',\n               -alphabet => 'protein',\n               -id => 'test');\n\tmy $oddcode_obj  =  Bio::Tools::OddCodes->new(-seq => $seqobj);\n\n  # do the alternative coding, returning the answer as a reference to\n  # a string\n\n\tmy $output = $oddcode_obj->structural();\n\tmy $output = $oddcode_obj->chemical();\n\tmy $output = $oddcode_obj->functional();\n\tmy $output = $oddcode_obj->charge();\n\tmy $output = $oddcode_obj->hydrophobic();\n\tmy $output = $oddcode_obj->Dayhoff();\n\tmy $output = $oddcode_obj->Sneath();\n\tmy $output = $oddcode_obj->Stanfel();\n\n\n  # display sequence in new form, eg:\n\n\tmy $new_coding = $$output;\n\tprint \"\\n$new_coding\";\n\n=head1 DESCRIPTION\n\nBio::Tools::Oddcodes is a welterweight object for rewriting a protein\nsequence in an alternative alphabet.  Eight of these are provided, ranging\nfrom the the 2-letter hydrophobic alphabet, to the 8-letter chemical\nalphabet.  These are useful for the statistical analysis of protein\nsequences since they can partially avoid the combinatorial explosion\nproduced by the full 20-letter alphabet (eg. 400 dimers, 8000 trimers\netc.)\n\nThe objects will print out a warning if the input sequence is not a\nprotein. If you know what you are doing, you can silence the warning\nby setting verbose() to a negative value.\n\nSee SYNOPSIS above for object creation code.\n\n=head1 REFERENCES\n\nStanfel LE (1996) A new approach to clustering the amino acids.  J. theor.\nBiol. 183, 195-205.\n\nKarlin S, Ost F and Blaisdell BE (1989)  Patterns in DNA and amino acid\nsequences and their statistical significance.  Chapter 6 of: Mathematical\nMethods for DNA Sequences.  Waterman MS (ed.)  CRC Press, Boca Raton , FL.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nDerek Gatherer\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::OddCodes;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nsub new\n{\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($seqobj) = $self->_rearrange([qw(SEQ)],@args);\n    if((! defined($seqobj)) && @args && ref($args[0])) {\n\t# parameter not passed as named parameter?\n\t$seqobj = $args[0];\n    }\n    unless  ($seqobj->isa(\"Bio::PrimarySeqI\"))\n    {\n        $self->throw(\"Bio::Tools::OddCodes only works on PrimarySeqI objects\");\n    }\n\n    $self->{'_seqref'} = $seqobj;\n\n    return $self;\n}\n\n=head2 structural\n\n Title   : structural\n Usage   : $output = $oddcode_obj->structural();\n Function: turns amino acid sequence into 3-letter structural alphabet\n\t : A (ambivalent), E (external), I (internal)\n Example : a sequence ACDEFGH will become AAEEIAE\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub structural()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\t# see _pullseq() below\n\n# now the real business\n\n\t$seqstring =~ tr/[ACGPSTWY]/1/;\n\t$seqstring =~ tr/[RNDQEHK]/2/;\n\t$seqstring =~ tr/[ILMFV]/3/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/E/;\n\t$seqstring =~ tr/3/I/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 functional\n\n Title   : functional\n Usage   : $output = $oddcode_obj->functional();\n Function: turns amino acid sequence into 4-letter functional alphabet\n\t : A (acidic), C (basic), H (hydrophobic), P (polar)\n Example : a sequence ACDEFGH will become HPAAHHC\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub functional()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\n\n# now the real business\n\n\t$seqstring =~ tr/[DE]/1/;\n\t$seqstring =~ tr/[HKR]/2/;\n\t$seqstring =~ tr/[AFILMPVW]/3/;\n\t$seqstring =~ tr/[CGNQSTY]/4/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/C/;\n\t$seqstring =~ tr/3/H/;\n\t$seqstring =~ tr/4/P/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 hydrophobic\n\n Title   : hydrophobic\n Usage   : $output = $oddcode_obj->hydrophobic();\n Function: turns amino acid sequence into 2-letter hydrophobicity alphabet\n\t : O (hydrophobic), I (hydrophilic)\n Example : a sequence ACDEFGH will become OIIIOII\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub hydrophobic()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\n\n# now the real business\n\n\t$seqstring =~ tr/[AFILMPVW]/1/;\n\t$seqstring =~ tr/[CDEGHKNQRSTY]/2/;\n\t$seqstring =~ tr/1/I/;\n\t$seqstring =~ tr/2/O/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 Dayhoff\n\n Title   : Dayhoff\n Usage   : $output = $oddcode_obj->Dayhoff();\n Function: turns amino acid sequence into 6-letter Dayhoff alphabet\n Example : a sequence ACDEFGH will become CADDGCE\n         : A (=C),   C (=AGPST), D (=DENQ),\n         : E (=HKR), F (=ILMV),  G (=FWY)\n Returns : Reference to the new sequence string\n Args    : none"},"children":[{"containerName":"Dayhoff","localvar":"my","kind":13,"name":"$self","line":267,"definition":"my"},{"line":268,"kind":13,"localvar":"my","containerName":"Dayhoff","name":"$seqstring","definition":"my"},{"name":"$self","kind":13,"containerName":"Dayhoff","line":268},{"kind":13,"containerName":"Dayhoff","name":"$seqstring","line":272},{"line":273,"containerName":"Dayhoff","kind":13,"name":"$seqstring"},{"containerName":"Dayhoff","kind":13,"name":"$seqstring","line":274},{"line":275,"kind":13,"containerName":"Dayhoff","name":"$seqstring"},{"kind":13,"containerName":"Dayhoff","name":"$seqstring","line":276},{"line":277,"name":"$seqstring","containerName":"Dayhoff","kind":13},{"name":"$seqstring","kind":13,"containerName":"Dayhoff","line":278},{"line":279,"name":"$seqstring","kind":13,"containerName":"Dayhoff"},{"name":"$seqstring","containerName":"Dayhoff","kind":13,"line":280},{"line":281,"containerName":"Dayhoff","kind":13,"name":"$seqstring"},{"line":282,"kind":13,"containerName":"Dayhoff","name":"$seqstring"},{"line":283,"kind":13,"containerName":"Dayhoff","name":"$seqstring"},{"name":"$seqstring","kind":13,"containerName":"Dayhoff","line":285}],"containerName":"main::","name":"Dayhoff","definition":"sub","detail":"()"},{"line":268,"name":"_pullseq","kind":12},{"children":[{"definition":"my","line":305,"name":"$self","localvar":"my","kind":13,"containerName":"Sneath"},{"localvar":"my","containerName":"Sneath","kind":13,"name":"$seqstring","line":306,"definition":"my"},{"containerName":"Sneath","kind":13,"name":"$self","line":306},{"line":310,"name":"$seqstring","containerName":"Sneath","kind":13},{"line":311,"containerName":"Sneath","kind":13,"name":"$seqstring"},{"line":312,"name":"$seqstring","containerName":"Sneath","kind":13},{"containerName":"Sneath","kind":13,"name":"$seqstring","line":313},{"kind":13,"containerName":"Sneath","name":"$seqstring","line":314},{"kind":13,"containerName":"Sneath","name":"$seqstring","line":315},{"line":316,"name":"$seqstring","containerName":"Sneath","kind":13},{"line":317,"containerName":"Sneath","kind":13,"name":"$seqstring"},{"line":318,"containerName":"Sneath","kind":13,"name":"$seqstring"},{"name":"$seqstring","kind":13,"containerName":"Sneath","line":319},{"containerName":"Sneath","kind":13,"name":"$seqstring","line":320},{"line":321,"containerName":"Sneath","kind":13,"name":"$seqstring"},{"name":"$seqstring","containerName":"Sneath","kind":13,"line":322},{"line":323,"name":"$seqstring","containerName":"Sneath","kind":13},{"line":325,"name":"$seqstring","containerName":"Sneath","kind":13}],"name":"Sneath","containerName":"main::","definition":"sub","detail":"()","line":303,"kind":12,"range":{"start":{"line":303,"character":0},"end":{"line":328,"character":9999}},"signature":{"label":"Sneath()","parameters":[],"documentation":"1;\n#$Id: OddCodes.pm 16123 2009-09-17 12:57:27Z cjfields $\n#-----------------------------------------------------------------------------\n# PACKAGE    : OddCodes.pm\n# PURPOSE    : To write amino acid sequences in alternative alphabets\n# AUTHOR     : Derek Gatherer (D.Gatherer@organon.nhe.akzonobel.nl)\n# SOURCE     :\n# CREATED    : 8th July 2000\n# MODIFIED   :\n# DISCLAIMER : I am employed in the pharmaceutical industry but my\n#            : employers do not endorse or sponsor this module\n#            : in any way whatsoever.  The above email address is\n#            : given purely for the purpose of easy communication\n#            : with the author, and does not imply any connection\n#\t     : between my employers and anything written below.\n# LICENCE    : You may distribute this module under the same terms\n#\t     : as the rest of BioPerl.\n#----------------------------------------------------------------------------\n\n=head1 NAME\n\nBio::Tools::OddCodes - Object holding alternative alphabet coding for\none protein sequence\n\n=head1 SYNOPSIS\n\n  # Take a sequence object from eg, an inputstream, and creates an\n  # object for the purposes of rewriting that sequence in another\n  # alphabet.  These are abbreviated amino acid sequence alphabets,\n  # designed to simplify the statistical aspects of analysing protein\n  # sequences, by reducing the combinatorial explosion of the\n  # 20-letter alphabet.  These abbreviated alphabets range in size\n  # from 2 to 8.\n\n  # Creating the OddCodes object, eg:\n\n\tmy $inputstream = Bio::SeqIO->new( '-file' => \"seqfile\",\n                                           '-format' => 'Fasta');\n\tmy $seqobj = $inputstream->next_seq();\n\tmy $oddcode_obj = Bio::Tools::Oddcodes->new(-seq => $seqobj);\n\n  # or:\n\n\tmy $seqobj = Bio::PrimarySeq->new\n              (-seq=>'[cut and paste a sequence here]',\n               -alphabet => 'protein',\n               -id => 'test');\n\tmy $oddcode_obj  =  Bio::Tools::OddCodes->new(-seq => $seqobj);\n\n  # do the alternative coding, returning the answer as a reference to\n  # a string\n\n\tmy $output = $oddcode_obj->structural();\n\tmy $output = $oddcode_obj->chemical();\n\tmy $output = $oddcode_obj->functional();\n\tmy $output = $oddcode_obj->charge();\n\tmy $output = $oddcode_obj->hydrophobic();\n\tmy $output = $oddcode_obj->Dayhoff();\n\tmy $output = $oddcode_obj->Sneath();\n\tmy $output = $oddcode_obj->Stanfel();\n\n\n  # display sequence in new form, eg:\n\n\tmy $new_coding = $$output;\n\tprint \"\\n$new_coding\";\n\n=head1 DESCRIPTION\n\nBio::Tools::Oddcodes is a welterweight object for rewriting a protein\nsequence in an alternative alphabet.  Eight of these are provided, ranging\nfrom the the 2-letter hydrophobic alphabet, to the 8-letter chemical\nalphabet.  These are useful for the statistical analysis of protein\nsequences since they can partially avoid the combinatorial explosion\nproduced by the full 20-letter alphabet (eg. 400 dimers, 8000 trimers\netc.)\n\nThe objects will print out a warning if the input sequence is not a\nprotein. If you know what you are doing, you can silence the warning\nby setting verbose() to a negative value.\n\nSee SYNOPSIS above for object creation code.\n\n=head1 REFERENCES\n\nStanfel LE (1996) A new approach to clustering the amino acids.  J. theor.\nBiol. 183, 195-205.\n\nKarlin S, Ost F and Blaisdell BE (1989)  Patterns in DNA and amino acid\nsequences and their statistical significance.  Chapter 6 of: Mathematical\nMethods for DNA Sequences.  Waterman MS (ed.)  CRC Press, Boca Raton , FL.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nDerek Gatherer\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::OddCodes;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nsub new\n{\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($seqobj) = $self->_rearrange([qw(SEQ)],@args);\n    if((! defined($seqobj)) && @args && ref($args[0])) {\n\t# parameter not passed as named parameter?\n\t$seqobj = $args[0];\n    }\n    unless  ($seqobj->isa(\"Bio::PrimarySeqI\"))\n    {\n        $self->throw(\"Bio::Tools::OddCodes only works on PrimarySeqI objects\");\n    }\n\n    $self->{'_seqref'} = $seqobj;\n\n    return $self;\n}\n\n=head2 structural\n\n Title   : structural\n Usage   : $output = $oddcode_obj->structural();\n Function: turns amino acid sequence into 3-letter structural alphabet\n\t : A (ambivalent), E (external), I (internal)\n Example : a sequence ACDEFGH will become AAEEIAE\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub structural()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\t# see _pullseq() below\n\n# now the real business\n\n\t$seqstring =~ tr/[ACGPSTWY]/1/;\n\t$seqstring =~ tr/[RNDQEHK]/2/;\n\t$seqstring =~ tr/[ILMFV]/3/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/E/;\n\t$seqstring =~ tr/3/I/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 functional\n\n Title   : functional\n Usage   : $output = $oddcode_obj->functional();\n Function: turns amino acid sequence into 4-letter functional alphabet\n\t : A (acidic), C (basic), H (hydrophobic), P (polar)\n Example : a sequence ACDEFGH will become HPAAHHC\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub functional()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\n\n# now the real business\n\n\t$seqstring =~ tr/[DE]/1/;\n\t$seqstring =~ tr/[HKR]/2/;\n\t$seqstring =~ tr/[AFILMPVW]/3/;\n\t$seqstring =~ tr/[CGNQSTY]/4/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/C/;\n\t$seqstring =~ tr/3/H/;\n\t$seqstring =~ tr/4/P/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 hydrophobic\n\n Title   : hydrophobic\n Usage   : $output = $oddcode_obj->hydrophobic();\n Function: turns amino acid sequence into 2-letter hydrophobicity alphabet\n\t : O (hydrophobic), I (hydrophilic)\n Example : a sequence ACDEFGH will become OIIIOII\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub hydrophobic()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\n\n# now the real business\n\n\t$seqstring =~ tr/[AFILMPVW]/1/;\n\t$seqstring =~ tr/[CDEGHKNQRSTY]/2/;\n\t$seqstring =~ tr/1/I/;\n\t$seqstring =~ tr/2/O/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 Dayhoff\n\n Title   : Dayhoff\n Usage   : $output = $oddcode_obj->Dayhoff();\n Function: turns amino acid sequence into 6-letter Dayhoff alphabet\n Example : a sequence ACDEFGH will become CADDGCE\n         : A (=C),   C (=AGPST), D (=DENQ),\n         : E (=HKR), F (=ILMV),  G (=FWY)\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub Dayhoff()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\n\n# now the real business\n\n\t$seqstring =~ tr/[C]/1/;\n\t$seqstring =~ tr/[AGPST]/2/;\n\t$seqstring =~ tr/[DENQ]/3/;\n\t$seqstring =~ tr/[HKR]/4/;\n\t$seqstring =~ tr/[ILMV]/5/;\n\t$seqstring =~ tr/[FWY]/6/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/C/;\n\t$seqstring =~ tr/3/D/;\n\t$seqstring =~ tr/4/E/;\n\t$seqstring =~ tr/5/F/;\n\t$seqstring =~ tr/6/G/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 Sneath\n\n Title   : Sneath\n Usage   : $output = $oddcode_obj->Sneath();\n Function: turns amino acid sequence into 7-letter Sneath alphabet\n Example : a sequence ACDEFGH will become CEFFHCF\n         : A (=ILV), C (=AGP), D (=MNQ), E (=CST),\n         : F (=DE),  G (=KR),  H (=FHWY)\n Returns : Reference to the new sequence string\n Args    : none"}},{"kind":12,"name":"_pullseq","line":306},{"definition":"sub","detail":"()","children":[{"line":344,"name":"$self","kind":13,"localvar":"my","containerName":"Stanfel","definition":"my"},{"definition":"my","containerName":"Stanfel","localvar":"my","kind":13,"name":"$seqstring","line":345},{"line":345,"kind":13,"containerName":"Stanfel","name":"$self"},{"line":349,"containerName":"Stanfel","kind":13,"name":"$seqstring"},{"kind":13,"containerName":"Stanfel","name":"$seqstring","line":350},{"line":351,"name":"$seqstring","containerName":"Stanfel","kind":13},{"kind":13,"containerName":"Stanfel","name":"$seqstring","line":352},{"kind":13,"containerName":"Stanfel","name":"$seqstring","line":353},{"name":"$seqstring","containerName":"Stanfel","kind":13,"line":354},{"name":"$seqstring","containerName":"Stanfel","kind":13,"line":355},{"containerName":"Stanfel","kind":13,"name":"$seqstring","line":356},{"containerName":"Stanfel","kind":13,"name":"$seqstring","line":358}],"name":"Stanfel","containerName":"main::","signature":{"parameters":[],"documentation":"1;\n#$Id: OddCodes.pm 16123 2009-09-17 12:57:27Z cjfields $\n#-----------------------------------------------------------------------------\n# PACKAGE    : OddCodes.pm\n# PURPOSE    : To write amino acid sequences in alternative alphabets\n# AUTHOR     : Derek Gatherer (D.Gatherer@organon.nhe.akzonobel.nl)\n# SOURCE     :\n# CREATED    : 8th July 2000\n# MODIFIED   :\n# DISCLAIMER : I am employed in the pharmaceutical industry but my\n#            : employers do not endorse or sponsor this module\n#            : in any way whatsoever.  The above email address is\n#            : given purely for the purpose of easy communication\n#            : with the author, and does not imply any connection\n#\t     : between my employers and anything written below.\n# LICENCE    : You may distribute this module under the same terms\n#\t     : as the rest of BioPerl.\n#----------------------------------------------------------------------------\n\n=head1 NAME\n\nBio::Tools::OddCodes - Object holding alternative alphabet coding for\none protein sequence\n\n=head1 SYNOPSIS\n\n  # Take a sequence object from eg, an inputstream, and creates an\n  # object for the purposes of rewriting that sequence in another\n  # alphabet.  These are abbreviated amino acid sequence alphabets,\n  # designed to simplify the statistical aspects of analysing protein\n  # sequences, by reducing the combinatorial explosion of the\n  # 20-letter alphabet.  These abbreviated alphabets range in size\n  # from 2 to 8.\n\n  # Creating the OddCodes object, eg:\n\n\tmy $inputstream = Bio::SeqIO->new( '-file' => \"seqfile\",\n                                           '-format' => 'Fasta');\n\tmy $seqobj = $inputstream->next_seq();\n\tmy $oddcode_obj = Bio::Tools::Oddcodes->new(-seq => $seqobj);\n\n  # or:\n\n\tmy $seqobj = Bio::PrimarySeq->new\n              (-seq=>'[cut and paste a sequence here]',\n               -alphabet => 'protein',\n               -id => 'test');\n\tmy $oddcode_obj  =  Bio::Tools::OddCodes->new(-seq => $seqobj);\n\n  # do the alternative coding, returning the answer as a reference to\n  # a string\n\n\tmy $output = $oddcode_obj->structural();\n\tmy $output = $oddcode_obj->chemical();\n\tmy $output = $oddcode_obj->functional();\n\tmy $output = $oddcode_obj->charge();\n\tmy $output = $oddcode_obj->hydrophobic();\n\tmy $output = $oddcode_obj->Dayhoff();\n\tmy $output = $oddcode_obj->Sneath();\n\tmy $output = $oddcode_obj->Stanfel();\n\n\n  # display sequence in new form, eg:\n\n\tmy $new_coding = $$output;\n\tprint \"\\n$new_coding\";\n\n=head1 DESCRIPTION\n\nBio::Tools::Oddcodes is a welterweight object for rewriting a protein\nsequence in an alternative alphabet.  Eight of these are provided, ranging\nfrom the the 2-letter hydrophobic alphabet, to the 8-letter chemical\nalphabet.  These are useful for the statistical analysis of protein\nsequences since they can partially avoid the combinatorial explosion\nproduced by the full 20-letter alphabet (eg. 400 dimers, 8000 trimers\netc.)\n\nThe objects will print out a warning if the input sequence is not a\nprotein. If you know what you are doing, you can silence the warning\nby setting verbose() to a negative value.\n\nSee SYNOPSIS above for object creation code.\n\n=head1 REFERENCES\n\nStanfel LE (1996) A new approach to clustering the amino acids.  J. theor.\nBiol. 183, 195-205.\n\nKarlin S, Ost F and Blaisdell BE (1989)  Patterns in DNA and amino acid\nsequences and their statistical significance.  Chapter 6 of: Mathematical\nMethods for DNA Sequences.  Waterman MS (ed.)  CRC Press, Boca Raton , FL.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nDerek Gatherer\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::OddCodes;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nsub new\n{\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($seqobj) = $self->_rearrange([qw(SEQ)],@args);\n    if((! defined($seqobj)) && @args && ref($args[0])) {\n\t# parameter not passed as named parameter?\n\t$seqobj = $args[0];\n    }\n    unless  ($seqobj->isa(\"Bio::PrimarySeqI\"))\n    {\n        $self->throw(\"Bio::Tools::OddCodes only works on PrimarySeqI objects\");\n    }\n\n    $self->{'_seqref'} = $seqobj;\n\n    return $self;\n}\n\n=head2 structural\n\n Title   : structural\n Usage   : $output = $oddcode_obj->structural();\n Function: turns amino acid sequence into 3-letter structural alphabet\n\t : A (ambivalent), E (external), I (internal)\n Example : a sequence ACDEFGH will become AAEEIAE\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub structural()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\t# see _pullseq() below\n\n# now the real business\n\n\t$seqstring =~ tr/[ACGPSTWY]/1/;\n\t$seqstring =~ tr/[RNDQEHK]/2/;\n\t$seqstring =~ tr/[ILMFV]/3/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/E/;\n\t$seqstring =~ tr/3/I/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 functional\n\n Title   : functional\n Usage   : $output = $oddcode_obj->functional();\n Function: turns amino acid sequence into 4-letter functional alphabet\n\t : A (acidic), C (basic), H (hydrophobic), P (polar)\n Example : a sequence ACDEFGH will become HPAAHHC\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub functional()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\n\n# now the real business\n\n\t$seqstring =~ tr/[DE]/1/;\n\t$seqstring =~ tr/[HKR]/2/;\n\t$seqstring =~ tr/[AFILMPVW]/3/;\n\t$seqstring =~ tr/[CGNQSTY]/4/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/C/;\n\t$seqstring =~ tr/3/H/;\n\t$seqstring =~ tr/4/P/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 hydrophobic\n\n Title   : hydrophobic\n Usage   : $output = $oddcode_obj->hydrophobic();\n Function: turns amino acid sequence into 2-letter hydrophobicity alphabet\n\t : O (hydrophobic), I (hydrophilic)\n Example : a sequence ACDEFGH will become OIIIOII\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub hydrophobic()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\n\n# now the real business\n\n\t$seqstring =~ tr/[AFILMPVW]/1/;\n\t$seqstring =~ tr/[CDEGHKNQRSTY]/2/;\n\t$seqstring =~ tr/1/I/;\n\t$seqstring =~ tr/2/O/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 Dayhoff\n\n Title   : Dayhoff\n Usage   : $output = $oddcode_obj->Dayhoff();\n Function: turns amino acid sequence into 6-letter Dayhoff alphabet\n Example : a sequence ACDEFGH will become CADDGCE\n         : A (=C),   C (=AGPST), D (=DENQ),\n         : E (=HKR), F (=ILMV),  G (=FWY)\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub Dayhoff()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\n\n# now the real business\n\n\t$seqstring =~ tr/[C]/1/;\n\t$seqstring =~ tr/[AGPST]/2/;\n\t$seqstring =~ tr/[DENQ]/3/;\n\t$seqstring =~ tr/[HKR]/4/;\n\t$seqstring =~ tr/[ILMV]/5/;\n\t$seqstring =~ tr/[FWY]/6/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/C/;\n\t$seqstring =~ tr/3/D/;\n\t$seqstring =~ tr/4/E/;\n\t$seqstring =~ tr/5/F/;\n\t$seqstring =~ tr/6/G/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 Sneath\n\n Title   : Sneath\n Usage   : $output = $oddcode_obj->Sneath();\n Function: turns amino acid sequence into 7-letter Sneath alphabet\n Example : a sequence ACDEFGH will become CEFFHCF\n         : A (=ILV), C (=AGP), D (=MNQ), E (=CST),\n         : F (=DE),  G (=KR),  H (=FHWY)\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub Sneath()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\n\n# now the real business\n\n\t$seqstring =~ tr/[ILV]/1/;\n\t$seqstring =~ tr/[AGP]/2/;\n\t$seqstring =~ tr/[MNQ]/3/;\n\t$seqstring =~ tr/[CST]/4/;\n\t$seqstring =~ tr/[DE]/5/;\n\t$seqstring =~ tr/[KR]/6/;\n\t$seqstring =~ tr/[FHWY]/7/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/C/;\n\t$seqstring =~ tr/3/D/;\n\t$seqstring =~ tr/4/E/;\n\t$seqstring =~ tr/5/F/;\n\t$seqstring =~ tr/6/G/;\n\t$seqstring =~ tr/7/H/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 Stanfel\n\n Title   : Stanfel\n Usage   : $output = $oddcode_obj->Stanfel();\n Function: turns amino acid sequence into 4-letter Stanfel alphabet\n Example : a sequence ACDEFGH will become AACCDAE\n         : A (=ACGILMPSTV), C (=DENQ), D (=FWY), E (=HKR)\n Returns : Reference to the new sequence string\n Args    : none","label":"Stanfel()"},"line":342,"range":{"start":{"character":0,"line":342},"end":{"line":361,"character":9999}},"kind":12},{"line":345,"kind":12,"name":"_pullseq"},{"children":[{"definition":"my","localvar":"my","containerName":"chemical","kind":13,"name":"$self","line":378},{"line":379,"containerName":"chemical","localvar":"my","kind":13,"name":"$seqstring","definition":"my"},{"kind":13,"containerName":"chemical","name":"$self","line":379},{"name":"$seqstring","kind":13,"containerName":"chemical","line":383},{"line":384,"containerName":"chemical","kind":13,"name":"$seqstring"},{"line":385,"name":"$seqstring","containerName":"chemical","kind":13},{"line":386,"containerName":"chemical","kind":13,"name":"$seqstring"},{"kind":13,"containerName":"chemical","name":"$seqstring","line":387},{"line":388,"name":"$seqstring","containerName":"chemical","kind":13},{"name":"$seqstring","kind":13,"containerName":"chemical","line":389},{"line":390,"name":"$seqstring","containerName":"chemical","kind":13},{"line":391,"name":"$seqstring","kind":13,"containerName":"chemical"},{"kind":13,"containerName":"chemical","name":"$seqstring","line":392},{"containerName":"chemical","kind":13,"name":"$seqstring","line":393},{"name":"$seqstring","kind":13,"containerName":"chemical","line":394},{"line":395,"name":"$seqstring","containerName":"chemical","kind":13},{"containerName":"chemical","kind":13,"name":"$seqstring","line":396},{"name":"$seqstring","containerName":"chemical","kind":13,"line":397},{"line":398,"name":"$seqstring","containerName":"chemical","kind":13},{"line":400,"kind":13,"containerName":"chemical","name":"$seqstring"}],"name":"chemical","containerName":"main::","definition":"sub","detail":"()","line":376,"kind":12,"range":{"end":{"character":9999,"line":403},"start":{"line":376,"character":0}},"signature":{"label":"chemical()","parameters":[],"documentation":"1;\n#$Id: OddCodes.pm 16123 2009-09-17 12:57:27Z cjfields $\n#-----------------------------------------------------------------------------\n# PACKAGE    : OddCodes.pm\n# PURPOSE    : To write amino acid sequences in alternative alphabets\n# AUTHOR     : Derek Gatherer (D.Gatherer@organon.nhe.akzonobel.nl)\n# SOURCE     :\n# CREATED    : 8th July 2000\n# MODIFIED   :\n# DISCLAIMER : I am employed in the pharmaceutical industry but my\n#            : employers do not endorse or sponsor this module\n#            : in any way whatsoever.  The above email address is\n#            : given purely for the purpose of easy communication\n#            : with the author, and does not imply any connection\n#\t     : between my employers and anything written below.\n# LICENCE    : You may distribute this module under the same terms\n#\t     : as the rest of BioPerl.\n#----------------------------------------------------------------------------\n\n=head1 NAME\n\nBio::Tools::OddCodes - Object holding alternative alphabet coding for\none protein sequence\n\n=head1 SYNOPSIS\n\n  # Take a sequence object from eg, an inputstream, and creates an\n  # object for the purposes of rewriting that sequence in another\n  # alphabet.  These are abbreviated amino acid sequence alphabets,\n  # designed to simplify the statistical aspects of analysing protein\n  # sequences, by reducing the combinatorial explosion of the\n  # 20-letter alphabet.  These abbreviated alphabets range in size\n  # from 2 to 8.\n\n  # Creating the OddCodes object, eg:\n\n\tmy $inputstream = Bio::SeqIO->new( '-file' => \"seqfile\",\n                                           '-format' => 'Fasta');\n\tmy $seqobj = $inputstream->next_seq();\n\tmy $oddcode_obj = Bio::Tools::Oddcodes->new(-seq => $seqobj);\n\n  # or:\n\n\tmy $seqobj = Bio::PrimarySeq->new\n              (-seq=>'[cut and paste a sequence here]',\n               -alphabet => 'protein',\n               -id => 'test');\n\tmy $oddcode_obj  =  Bio::Tools::OddCodes->new(-seq => $seqobj);\n\n  # do the alternative coding, returning the answer as a reference to\n  # a string\n\n\tmy $output = $oddcode_obj->structural();\n\tmy $output = $oddcode_obj->chemical();\n\tmy $output = $oddcode_obj->functional();\n\tmy $output = $oddcode_obj->charge();\n\tmy $output = $oddcode_obj->hydrophobic();\n\tmy $output = $oddcode_obj->Dayhoff();\n\tmy $output = $oddcode_obj->Sneath();\n\tmy $output = $oddcode_obj->Stanfel();\n\n\n  # display sequence in new form, eg:\n\n\tmy $new_coding = $$output;\n\tprint \"\\n$new_coding\";\n\n=head1 DESCRIPTION\n\nBio::Tools::Oddcodes is a welterweight object for rewriting a protein\nsequence in an alternative alphabet.  Eight of these are provided, ranging\nfrom the the 2-letter hydrophobic alphabet, to the 8-letter chemical\nalphabet.  These are useful for the statistical analysis of protein\nsequences since they can partially avoid the combinatorial explosion\nproduced by the full 20-letter alphabet (eg. 400 dimers, 8000 trimers\netc.)\n\nThe objects will print out a warning if the input sequence is not a\nprotein. If you know what you are doing, you can silence the warning\nby setting verbose() to a negative value.\n\nSee SYNOPSIS above for object creation code.\n\n=head1 REFERENCES\n\nStanfel LE (1996) A new approach to clustering the amino acids.  J. theor.\nBiol. 183, 195-205.\n\nKarlin S, Ost F and Blaisdell BE (1989)  Patterns in DNA and amino acid\nsequences and their statistical significance.  Chapter 6 of: Mathematical\nMethods for DNA Sequences.  Waterman MS (ed.)  CRC Press, Boca Raton , FL.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nDerek Gatherer\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::OddCodes;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nsub new\n{\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($seqobj) = $self->_rearrange([qw(SEQ)],@args);\n    if((! defined($seqobj)) && @args && ref($args[0])) {\n\t# parameter not passed as named parameter?\n\t$seqobj = $args[0];\n    }\n    unless  ($seqobj->isa(\"Bio::PrimarySeqI\"))\n    {\n        $self->throw(\"Bio::Tools::OddCodes only works on PrimarySeqI objects\");\n    }\n\n    $self->{'_seqref'} = $seqobj;\n\n    return $self;\n}\n\n=head2 structural\n\n Title   : structural\n Usage   : $output = $oddcode_obj->structural();\n Function: turns amino acid sequence into 3-letter structural alphabet\n\t : A (ambivalent), E (external), I (internal)\n Example : a sequence ACDEFGH will become AAEEIAE\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub structural()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\t# see _pullseq() below\n\n# now the real business\n\n\t$seqstring =~ tr/[ACGPSTWY]/1/;\n\t$seqstring =~ tr/[RNDQEHK]/2/;\n\t$seqstring =~ tr/[ILMFV]/3/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/E/;\n\t$seqstring =~ tr/3/I/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 functional\n\n Title   : functional\n Usage   : $output = $oddcode_obj->functional();\n Function: turns amino acid sequence into 4-letter functional alphabet\n\t : A (acidic), C (basic), H (hydrophobic), P (polar)\n Example : a sequence ACDEFGH will become HPAAHHC\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub functional()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\n\n# now the real business\n\n\t$seqstring =~ tr/[DE]/1/;\n\t$seqstring =~ tr/[HKR]/2/;\n\t$seqstring =~ tr/[AFILMPVW]/3/;\n\t$seqstring =~ tr/[CGNQSTY]/4/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/C/;\n\t$seqstring =~ tr/3/H/;\n\t$seqstring =~ tr/4/P/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 hydrophobic\n\n Title   : hydrophobic\n Usage   : $output = $oddcode_obj->hydrophobic();\n Function: turns amino acid sequence into 2-letter hydrophobicity alphabet\n\t : O (hydrophobic), I (hydrophilic)\n Example : a sequence ACDEFGH will become OIIIOII\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub hydrophobic()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\n\n# now the real business\n\n\t$seqstring =~ tr/[AFILMPVW]/1/;\n\t$seqstring =~ tr/[CDEGHKNQRSTY]/2/;\n\t$seqstring =~ tr/1/I/;\n\t$seqstring =~ tr/2/O/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 Dayhoff\n\n Title   : Dayhoff\n Usage   : $output = $oddcode_obj->Dayhoff();\n Function: turns amino acid sequence into 6-letter Dayhoff alphabet\n Example : a sequence ACDEFGH will become CADDGCE\n         : A (=C),   C (=AGPST), D (=DENQ),\n         : E (=HKR), F (=ILMV),  G (=FWY)\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub Dayhoff()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\n\n# now the real business\n\n\t$seqstring =~ tr/[C]/1/;\n\t$seqstring =~ tr/[AGPST]/2/;\n\t$seqstring =~ tr/[DENQ]/3/;\n\t$seqstring =~ tr/[HKR]/4/;\n\t$seqstring =~ tr/[ILMV]/5/;\n\t$seqstring =~ tr/[FWY]/6/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/C/;\n\t$seqstring =~ tr/3/D/;\n\t$seqstring =~ tr/4/E/;\n\t$seqstring =~ tr/5/F/;\n\t$seqstring =~ tr/6/G/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 Sneath\n\n Title   : Sneath\n Usage   : $output = $oddcode_obj->Sneath();\n Function: turns amino acid sequence into 7-letter Sneath alphabet\n Example : a sequence ACDEFGH will become CEFFHCF\n         : A (=ILV), C (=AGP), D (=MNQ), E (=CST),\n         : F (=DE),  G (=KR),  H (=FHWY)\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub Sneath()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\n\n# now the real business\n\n\t$seqstring =~ tr/[ILV]/1/;\n\t$seqstring =~ tr/[AGP]/2/;\n\t$seqstring =~ tr/[MNQ]/3/;\n\t$seqstring =~ tr/[CST]/4/;\n\t$seqstring =~ tr/[DE]/5/;\n\t$seqstring =~ tr/[KR]/6/;\n\t$seqstring =~ tr/[FHWY]/7/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/C/;\n\t$seqstring =~ tr/3/D/;\n\t$seqstring =~ tr/4/E/;\n\t$seqstring =~ tr/5/F/;\n\t$seqstring =~ tr/6/G/;\n\t$seqstring =~ tr/7/H/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 Stanfel\n\n Title   : Stanfel\n Usage   : $output = $oddcode_obj->Stanfel();\n Function: turns amino acid sequence into 4-letter Stanfel alphabet\n Example : a sequence ACDEFGH will become AACCDAE\n         : A (=ACGILMPSTV), C (=DENQ), D (=FWY), E (=HKR)\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub Stanfel()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\n\n# now the real business\n\n\t$seqstring =~ tr/[ACGILMPSTV]/1/;\n\t$seqstring =~ tr/[DENQ]/2/;\n\t$seqstring =~ tr/[FWY]/3/;\n\t$seqstring =~ tr/[HKR]/4/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/C/;\n\t$seqstring =~ tr/3/D/;\n\t$seqstring =~ tr/4/E/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 chemical\n\n Title   : chemical\n Usage   : $output = $oddcode_obj->chemical();\n Function: turns amino acid sequence into 8-letter chemical alphabet\n\t : A (acidic), L (aliphatic), M (amide), R (aromatic)\n\t : C (basic),  H (hydroxyl),  I (imino), S (sulphur)\n Example : a sequence ACDEFGH will become LSAARAC\n Returns : Reference to the new sequence string\n Args    : none"}},{"line":379,"kind":12,"name":"_pullseq"},{"line":417,"range":{"start":{"line":417,"character":0},"end":{"line":434,"character":9999}},"kind":12,"signature":{"documentation":"1;\n#$Id: OddCodes.pm 16123 2009-09-17 12:57:27Z cjfields $\n#-----------------------------------------------------------------------------\n# PACKAGE    : OddCodes.pm\n# PURPOSE    : To write amino acid sequences in alternative alphabets\n# AUTHOR     : Derek Gatherer (D.Gatherer@organon.nhe.akzonobel.nl)\n# SOURCE     :\n# CREATED    : 8th July 2000\n# MODIFIED   :\n# DISCLAIMER : I am employed in the pharmaceutical industry but my\n#            : employers do not endorse or sponsor this module\n#            : in any way whatsoever.  The above email address is\n#            : given purely for the purpose of easy communication\n#            : with the author, and does not imply any connection\n#\t     : between my employers and anything written below.\n# LICENCE    : You may distribute this module under the same terms\n#\t     : as the rest of BioPerl.\n#----------------------------------------------------------------------------\n\n=head1 NAME\n\nBio::Tools::OddCodes - Object holding alternative alphabet coding for\none protein sequence\n\n=head1 SYNOPSIS\n\n  # Take a sequence object from eg, an inputstream, and creates an\n  # object for the purposes of rewriting that sequence in another\n  # alphabet.  These are abbreviated amino acid sequence alphabets,\n  # designed to simplify the statistical aspects of analysing protein\n  # sequences, by reducing the combinatorial explosion of the\n  # 20-letter alphabet.  These abbreviated alphabets range in size\n  # from 2 to 8.\n\n  # Creating the OddCodes object, eg:\n\n\tmy $inputstream = Bio::SeqIO->new( '-file' => \"seqfile\",\n                                           '-format' => 'Fasta');\n\tmy $seqobj = $inputstream->next_seq();\n\tmy $oddcode_obj = Bio::Tools::Oddcodes->new(-seq => $seqobj);\n\n  # or:\n\n\tmy $seqobj = Bio::PrimarySeq->new\n              (-seq=>'[cut and paste a sequence here]',\n               -alphabet => 'protein',\n               -id => 'test');\n\tmy $oddcode_obj  =  Bio::Tools::OddCodes->new(-seq => $seqobj);\n\n  # do the alternative coding, returning the answer as a reference to\n  # a string\n\n\tmy $output = $oddcode_obj->structural();\n\tmy $output = $oddcode_obj->chemical();\n\tmy $output = $oddcode_obj->functional();\n\tmy $output = $oddcode_obj->charge();\n\tmy $output = $oddcode_obj->hydrophobic();\n\tmy $output = $oddcode_obj->Dayhoff();\n\tmy $output = $oddcode_obj->Sneath();\n\tmy $output = $oddcode_obj->Stanfel();\n\n\n  # display sequence in new form, eg:\n\n\tmy $new_coding = $$output;\n\tprint \"\\n$new_coding\";\n\n=head1 DESCRIPTION\n\nBio::Tools::Oddcodes is a welterweight object for rewriting a protein\nsequence in an alternative alphabet.  Eight of these are provided, ranging\nfrom the the 2-letter hydrophobic alphabet, to the 8-letter chemical\nalphabet.  These are useful for the statistical analysis of protein\nsequences since they can partially avoid the combinatorial explosion\nproduced by the full 20-letter alphabet (eg. 400 dimers, 8000 trimers\netc.)\n\nThe objects will print out a warning if the input sequence is not a\nprotein. If you know what you are doing, you can silence the warning\nby setting verbose() to a negative value.\n\nSee SYNOPSIS above for object creation code.\n\n=head1 REFERENCES\n\nStanfel LE (1996) A new approach to clustering the amino acids.  J. theor.\nBiol. 183, 195-205.\n\nKarlin S, Ost F and Blaisdell BE (1989)  Patterns in DNA and amino acid\nsequences and their statistical significance.  Chapter 6 of: Mathematical\nMethods for DNA Sequences.  Waterman MS (ed.)  CRC Press, Boca Raton , FL.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nDerek Gatherer\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::OddCodes;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nsub new\n{\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($seqobj) = $self->_rearrange([qw(SEQ)],@args);\n    if((! defined($seqobj)) && @args && ref($args[0])) {\n\t# parameter not passed as named parameter?\n\t$seqobj = $args[0];\n    }\n    unless  ($seqobj->isa(\"Bio::PrimarySeqI\"))\n    {\n        $self->throw(\"Bio::Tools::OddCodes only works on PrimarySeqI objects\");\n    }\n\n    $self->{'_seqref'} = $seqobj;\n\n    return $self;\n}\n\n=head2 structural\n\n Title   : structural\n Usage   : $output = $oddcode_obj->structural();\n Function: turns amino acid sequence into 3-letter structural alphabet\n\t : A (ambivalent), E (external), I (internal)\n Example : a sequence ACDEFGH will become AAEEIAE\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub structural()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\t# see _pullseq() below\n\n# now the real business\n\n\t$seqstring =~ tr/[ACGPSTWY]/1/;\n\t$seqstring =~ tr/[RNDQEHK]/2/;\n\t$seqstring =~ tr/[ILMFV]/3/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/E/;\n\t$seqstring =~ tr/3/I/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 functional\n\n Title   : functional\n Usage   : $output = $oddcode_obj->functional();\n Function: turns amino acid sequence into 4-letter functional alphabet\n\t : A (acidic), C (basic), H (hydrophobic), P (polar)\n Example : a sequence ACDEFGH will become HPAAHHC\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub functional()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\n\n# now the real business\n\n\t$seqstring =~ tr/[DE]/1/;\n\t$seqstring =~ tr/[HKR]/2/;\n\t$seqstring =~ tr/[AFILMPVW]/3/;\n\t$seqstring =~ tr/[CGNQSTY]/4/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/C/;\n\t$seqstring =~ tr/3/H/;\n\t$seqstring =~ tr/4/P/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 hydrophobic\n\n Title   : hydrophobic\n Usage   : $output = $oddcode_obj->hydrophobic();\n Function: turns amino acid sequence into 2-letter hydrophobicity alphabet\n\t : O (hydrophobic), I (hydrophilic)\n Example : a sequence ACDEFGH will become OIIIOII\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub hydrophobic()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\n\n# now the real business\n\n\t$seqstring =~ tr/[AFILMPVW]/1/;\n\t$seqstring =~ tr/[CDEGHKNQRSTY]/2/;\n\t$seqstring =~ tr/1/I/;\n\t$seqstring =~ tr/2/O/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 Dayhoff\n\n Title   : Dayhoff\n Usage   : $output = $oddcode_obj->Dayhoff();\n Function: turns amino acid sequence into 6-letter Dayhoff alphabet\n Example : a sequence ACDEFGH will become CADDGCE\n         : A (=C),   C (=AGPST), D (=DENQ),\n         : E (=HKR), F (=ILMV),  G (=FWY)\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub Dayhoff()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\n\n# now the real business\n\n\t$seqstring =~ tr/[C]/1/;\n\t$seqstring =~ tr/[AGPST]/2/;\n\t$seqstring =~ tr/[DENQ]/3/;\n\t$seqstring =~ tr/[HKR]/4/;\n\t$seqstring =~ tr/[ILMV]/5/;\n\t$seqstring =~ tr/[FWY]/6/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/C/;\n\t$seqstring =~ tr/3/D/;\n\t$seqstring =~ tr/4/E/;\n\t$seqstring =~ tr/5/F/;\n\t$seqstring =~ tr/6/G/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 Sneath\n\n Title   : Sneath\n Usage   : $output = $oddcode_obj->Sneath();\n Function: turns amino acid sequence into 7-letter Sneath alphabet\n Example : a sequence ACDEFGH will become CEFFHCF\n         : A (=ILV), C (=AGP), D (=MNQ), E (=CST),\n         : F (=DE),  G (=KR),  H (=FHWY)\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub Sneath()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\n\n# now the real business\n\n\t$seqstring =~ tr/[ILV]/1/;\n\t$seqstring =~ tr/[AGP]/2/;\n\t$seqstring =~ tr/[MNQ]/3/;\n\t$seqstring =~ tr/[CST]/4/;\n\t$seqstring =~ tr/[DE]/5/;\n\t$seqstring =~ tr/[KR]/6/;\n\t$seqstring =~ tr/[FHWY]/7/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/C/;\n\t$seqstring =~ tr/3/D/;\n\t$seqstring =~ tr/4/E/;\n\t$seqstring =~ tr/5/F/;\n\t$seqstring =~ tr/6/G/;\n\t$seqstring =~ tr/7/H/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 Stanfel\n\n Title   : Stanfel\n Usage   : $output = $oddcode_obj->Stanfel();\n Function: turns amino acid sequence into 4-letter Stanfel alphabet\n Example : a sequence ACDEFGH will become AACCDAE\n         : A (=ACGILMPSTV), C (=DENQ), D (=FWY), E (=HKR)\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub Stanfel()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\n\n# now the real business\n\n\t$seqstring =~ tr/[ACGILMPSTV]/1/;\n\t$seqstring =~ tr/[DENQ]/2/;\n\t$seqstring =~ tr/[FWY]/3/;\n\t$seqstring =~ tr/[HKR]/4/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/C/;\n\t$seqstring =~ tr/3/D/;\n\t$seqstring =~ tr/4/E/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 chemical\n\n Title   : chemical\n Usage   : $output = $oddcode_obj->chemical();\n Function: turns amino acid sequence into 8-letter chemical alphabet\n\t : A (acidic), L (aliphatic), M (amide), R (aromatic)\n\t : C (basic),  H (hydroxyl),  I (imino), S (sulphur)\n Example : a sequence ACDEFGH will become LSAARAC\n Returns : Reference to the new sequence string\n Args    : none\n\n\nsub chemical()\n{\n\tmy $self = $_[0];\n\tmy $seqstring = &_pullseq($self);\n\n# now the real business\n\n\t$seqstring =~ tr/[DE]/1/;\n\t$seqstring =~ tr/[AGILV]/2/;\n\t$seqstring =~ tr/[NQ]/3/;\n\t$seqstring =~ tr/[FWY]/4/;\n\t$seqstring =~ tr/[RHK]/5/;\n\t$seqstring =~ tr/[ST]/6/;\n\t$seqstring =~ tr/P/7/;\n\t$seqstring =~ tr/[CM]/8/;\n\t$seqstring =~ tr/1/A/;\n\t$seqstring =~ tr/2/L/;\n\t$seqstring =~ tr/3/M/;\n\t$seqstring =~ tr/4/R/;\n\t$seqstring =~ tr/5/C/;\n\t$seqstring =~ tr/6/H/;\n\t$seqstring =~ tr/7/I/;\n\t$seqstring =~ tr/8/S/;\n\n\treturn \\$seqstring;\n\n# and that's that one\n}\n\n=head2 charge\n\n Title   : charge\n Usage   : $output = $oddcode_obj->charge();\n Function: turns amino acid sequence into 3-letter charge alphabet\n Example : a sequence ACDEFGH will become NNAANNC\n         : A (negative; NOT anode), C (positive; NOT cathode), N (neutral)\n Returns : Reference to the new sequence string\n Args    : none","parameters":[],"label":"charge()"},"children":[{"definition":"my","line":419,"containerName":"charge","localvar":"my","kind":13,"name":"$self"},{"name":"$seqstring","localvar":"my","containerName":"charge","kind":13,"line":420,"definition":"my"},{"line":420,"containerName":"charge","kind":13,"name":"$self"},{"containerName":"charge","kind":13,"name":"$seqstring","line":424},{"name":"$seqstring","kind":13,"containerName":"charge","line":425},{"line":426,"name":"$seqstring","kind":13,"containerName":"charge"},{"kind":13,"containerName":"charge","name":"$seqstring","line":427},{"line":428,"name":"$seqstring","containerName":"charge","kind":13},{"line":429,"name":"$seqstring","containerName":"charge","kind":13},{"kind":13,"containerName":"charge","name":"$seqstring","line":431}],"name":"charge","containerName":"main::","definition":"sub","detail":"()"},{"kind":12,"name":"_pullseq","line":420},{"line":439,"kind":12,"range":{"end":{"character":9999,"line":460},"start":{"line":439,"character":0}},"children":[{"line":441,"name":"$self","kind":13,"localvar":"my","containerName":"_pullseq","definition":"my"},{"definition":"my","name":"$seqobj","localvar":"my","containerName":"_pullseq","kind":13,"line":443},{"line":443,"containerName":"_pullseq","kind":13,"name":"$self"},{"kind":13,"containerName":"_pullseq","name":"$seqobj","line":445},{"name":"isa","kind":12,"containerName":"_pullseq","line":445},{"containerName":"_pullseq","kind":13,"name":"$self","line":447},{"line":447,"containerName":"_pullseq","kind":12,"name":"throw"},{"containerName":"_pullseq","kind":13,"name":"$self","line":449},{"line":449,"name":"warn","containerName":"_pullseq","kind":12},{"kind":13,"containerName":"_pullseq","name":"$seqobj","line":450},{"kind":12,"containerName":"_pullseq","name":"id","line":450},{"name":"$seqobj","kind":13,"containerName":"_pullseq","line":451},{"name":"alphabet","containerName":"_pullseq","kind":12,"line":451},{"kind":13,"containerName":"_pullseq","name":"$self","line":451},{"kind":12,"containerName":"_pullseq","name":"verbose","line":451},{"line":453,"name":"$seqstring","localvar":"my","kind":13,"containerName":"_pullseq","definition":"my"},{"line":453,"name":"$seqobj","kind":13,"containerName":"_pullseq"},{"line":453,"containerName":"_pullseq","kind":12,"name":"seq"},{"kind":13,"containerName":"_pullseq","name":"$seqstring","line":455},{"containerName":"_pullseq","kind":13,"name":"$self","line":457},{"containerName":"_pullseq","kind":12,"name":"throw","line":457},{"name":"$seqstring","kind":13,"containerName":"_pullseq","line":459}],"name":"_pullseq","containerName":"main::","definition":"sub"}]}