{"version":5,"vars":[{"kind":2,"containerName":"","name":"base","line":75},{"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Hmmpfam.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::Tools::Hmmpfam\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by  Balamurugan Kumarasamy\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n#\n\n=head1 NAME\n\nBio::Tools::Hmmpfam - Parser for Hmmpfam program\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Hmmpfam;\n  my @hmmpfam_feat;\n  my $hmmpfam_parser = Bio::Tools::Hmmpfam->new(-fh =>$filehandle );\n  while( my $hmmpfam_feat = $hmmpfam_parser->next_result ) {\n        push @hmmpfam_feat, $hmmpfam_feat;\n  }\n\n=head1 DESCRIPTION\n\nParser for Hmmpfam  program.  See also L<Bio::SearchIO::hmmer>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n User feedback is an integral part of the evolution of this and other\n Bioperl modules. Send your comments and suggestions preferably to\n the Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Balamurugan Kumarasamy\n\n Email: fugui@worf.fugu-sg.org\n\n=head1 APPENDIX\n\n The rest of the documentation details each of the object methods.\n Internal methods are usually preceded with a _\n\n\n\npackage Bio::Tools::Hmmpfam;\nuse strict;\n\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Generic;\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Hmmpfam->new(-fh=>$filehandle);\n Function: Builds a new Bio::Tools::Hmmpfam object\n Returns : Bio::Tools::Hmmpfam\n Args    : -filename\n           -fh (filehandle)","label":"new($class,@args)"},"range":{"start":{"line":90,"character":0},"end":{"character":9999,"line":97}},"kind":12,"line":90,"detail":"($class,@args)","definition":"sub","name":"new","containerName":"main::","children":[{"definition":"my","line":91,"name":"$class","containerName":"new","localvar":"my","kind":13},{"name":"@args","containerName":"new","kind":13,"line":91},{"definition":"my","line":93,"kind":13,"localvar":"my","containerName":"new","name":"$self"},{"name":"$class","containerName":"new","kind":13,"line":93},{"name":"@args","containerName":"new","kind":13,"line":93},{"name":"$self","kind":13,"containerName":"new","line":94},{"line":94,"kind":12,"containerName":"new","name":"_initialize_io"},{"line":94,"kind":13,"containerName":"new","name":"@args"},{"line":96,"name":"$self","containerName":"new","kind":13}]},{"line":93,"kind":12,"containerName":"new","name":"SUPER"},{"definition":"sub","detail":"($self)","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"next_result","line":111,"definition":"my"},{"line":112,"name":"$filehandle","containerName":"next_result","localvar":"my","kind":13,"definition":"my"},{"definition":"my","name":"$line","kind":13,"localvar":"my","containerName":"next_result","line":114},{"definition":"my","line":116,"name":"$id","localvar":"my","containerName":"next_result","kind":13},{"line":117,"name":"$self","kind":13,"containerName":"next_result"},{"line":117,"name":"_readline","containerName":"next_result","kind":12},{"containerName":"next_result","kind":13,"name":"$line","line":118},{"line":119,"name":"$line","kind":13,"containerName":"next_result"},{"line":121,"kind":13,"containerName":"next_result","name":"$line"},{"line":122,"containerName":"next_result","localvar":"my","kind":13,"name":"$rest","definition":"my"},{"line":122,"containerName":"next_result","kind":13,"name":"$self"},{"line":122,"name":"_readline","kind":12,"containerName":"next_result"},{"line":122,"name":"$rest","kind":13,"containerName":"next_result"},{"line":125,"kind":13,"containerName":"next_result","name":"$line"},{"kind":13,"containerName":"next_result","name":"$line","line":127},{"containerName":"next_result","kind":13,"name":"$id","line":128},{"kind":13,"containerName":"next_result","name":"$self","line":129},{"line":129,"name":"seqname","kind":12,"containerName":"next_result"},{"kind":13,"containerName":"next_result","name":"$id","line":129},{"line":132,"localvar":"my","containerName":"next_result","kind":13,"name":"$hid","definition":"my"},{"name":"$start","kind":13,"containerName":"next_result","line":132},{"line":132,"name":"$end","kind":13,"containerName":"next_result"},{"line":132,"name":"$hstart","kind":13,"containerName":"next_result"},{"line":132,"containerName":"next_result","kind":13,"name":"$hend"},{"line":132,"kind":13,"containerName":"next_result","name":"$score"},{"name":"$evalue","kind":13,"containerName":"next_result","line":132},{"containerName":"next_result","kind":13,"name":"$line","line":132},{"definition":"my","line":133,"localvar":"my","containerName":"next_result","kind":13,"name":"%feature"},{"line":135,"containerName":"next_result","kind":13,"name":"$feature"},{"line":135,"name":"$self","containerName":"next_result","kind":13},{"line":135,"name":"seqname","containerName":"next_result","kind":12},{"name":"$feature","kind":13,"containerName":"next_result","line":136},{"kind":13,"containerName":"next_result","name":"$score","line":136},{"line":137,"name":"$feature","containerName":"next_result","kind":13},{"line":137,"name":"$evalue","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"$feature","line":138},{"line":138,"name":"$feature","containerName":"next_result","kind":13},{"containerName":"next_result","kind":13,"name":"$feature","line":139},{"line":139,"containerName":"next_result","kind":13,"name":"$start"},{"line":140,"kind":13,"containerName":"next_result","name":"$feature"},{"line":140,"containerName":"next_result","kind":13,"name":"$end"},{"line":141,"containerName":"next_result","kind":13,"name":"$feature"},{"containerName":"next_result","kind":13,"name":"$hid","line":141},{"kind":13,"containerName":"next_result","name":"$feature","line":142},{"kind":13,"containerName":"next_result","name":"$hstart","line":142},{"line":143,"containerName":"next_result","kind":13,"name":"$feature"},{"name":"$hend","kind":13,"containerName":"next_result","line":143},{"name":"$feature","containerName":"next_result","kind":13,"line":144},{"name":"$feature","kind":13,"containerName":"next_result","line":145},{"line":145,"name":"$hid","kind":13,"containerName":"next_result"},{"line":146,"containerName":"next_result","kind":13,"name":"$feature"},{"containerName":"next_result","kind":13,"name":"$feature","line":147},{"name":"$feature","kind":13,"containerName":"next_result","line":148},{"definition":"my","line":149,"localvar":"my","kind":13,"containerName":"next_result","name":"$new_feat"},{"kind":13,"containerName":"next_result","name":"$self","line":149},{"containerName":"next_result","kind":12,"name":"create_feature","line":149},{"name":"%feature","containerName":"next_result","kind":13,"line":149},{"line":151,"name":"$new_feat","containerName":"next_result","kind":13}],"containerName":"main::","name":"next_result","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Hmmpfam.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::Tools::Hmmpfam\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by  Balamurugan Kumarasamy\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n#\n\n=head1 NAME\n\nBio::Tools::Hmmpfam - Parser for Hmmpfam program\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Hmmpfam;\n  my @hmmpfam_feat;\n  my $hmmpfam_parser = Bio::Tools::Hmmpfam->new(-fh =>$filehandle );\n  while( my $hmmpfam_feat = $hmmpfam_parser->next_result ) {\n        push @hmmpfam_feat, $hmmpfam_feat;\n  }\n\n=head1 DESCRIPTION\n\nParser for Hmmpfam  program.  See also L<Bio::SearchIO::hmmer>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n User feedback is an integral part of the evolution of this and other\n Bioperl modules. Send your comments and suggestions preferably to\n the Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Balamurugan Kumarasamy\n\n Email: fugui@worf.fugu-sg.org\n\n=head1 APPENDIX\n\n The rest of the documentation details each of the object methods.\n Internal methods are usually preceded with a _\n\n\n\npackage Bio::Tools::Hmmpfam;\nuse strict;\n\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Generic;\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Hmmpfam->new(-fh=>$filehandle);\n Function: Builds a new Bio::Tools::Hmmpfam object\n Returns : Bio::Tools::Hmmpfam\n Args    : -filename\n           -fh (filehandle)\n\n\nsub new {\n      my($class,@args) = @_;\n\n      my $self = $class->SUPER::new(@args);\n      $self->_initialize_io(@args);\n\n      return $self;\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $feat = $hmmpfam_parser->next_result\n Function: Get the next result set from parser data\n Returns : L<Bio::SeqFeature::Generic>\n Args    : none","label":"next_result($self)"},"line":110,"kind":12,"range":{"start":{"line":110,"character":0},"end":{"character":9999,"line":157}}},{"line":135,"name":"name","kind":12},{"kind":12,"name":"raw_score","line":136},{"line":137,"kind":12,"name":"p_value"},{"line":138,"name":"score","kind":12},{"line":138,"name":"p_value","kind":12},{"line":139,"kind":12,"name":"start"},{"kind":12,"name":"end","line":140},{"name":"hname","kind":12,"line":141},{"name":"hstart","kind":12,"line":142},{"line":143,"kind":12,"name":"hend"},{"line":144,"kind":12,"name":"source"},{"kind":12,"name":"primary","line":145},{"name":"program","kind":12,"line":146},{"kind":12,"name":"db","line":147},{"name":"logic_name","kind":12,"line":148},{"kind":12,"range":{"start":{"line":170,"character":0},"end":{"line":202,"character":9999}},"line":170,"signature":{"label":"create_feature($self,$feat)","parameters":[{"label":"$self"},{"label":"$feat"}],"documentation":"1;\n# $Id: Hmmpfam.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::Tools::Hmmpfam\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by  Balamurugan Kumarasamy\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n#\n\n=head1 NAME\n\nBio::Tools::Hmmpfam - Parser for Hmmpfam program\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Hmmpfam;\n  my @hmmpfam_feat;\n  my $hmmpfam_parser = Bio::Tools::Hmmpfam->new(-fh =>$filehandle );\n  while( my $hmmpfam_feat = $hmmpfam_parser->next_result ) {\n        push @hmmpfam_feat, $hmmpfam_feat;\n  }\n\n=head1 DESCRIPTION\n\nParser for Hmmpfam  program.  See also L<Bio::SearchIO::hmmer>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n User feedback is an integral part of the evolution of this and other\n Bioperl modules. Send your comments and suggestions preferably to\n the Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Balamurugan Kumarasamy\n\n Email: fugui@worf.fugu-sg.org\n\n=head1 APPENDIX\n\n The rest of the documentation details each of the object methods.\n Internal methods are usually preceded with a _\n\n\n\npackage Bio::Tools::Hmmpfam;\nuse strict;\n\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Generic;\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Hmmpfam->new(-fh=>$filehandle);\n Function: Builds a new Bio::Tools::Hmmpfam object\n Returns : Bio::Tools::Hmmpfam\n Args    : -filename\n           -fh (filehandle)\n\n\nsub new {\n      my($class,@args) = @_;\n\n      my $self = $class->SUPER::new(@args);\n      $self->_initialize_io(@args);\n\n      return $self;\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $feat = $hmmpfam_parser->next_result\n Function: Get the next result set from parser data\n Returns : L<Bio::SeqFeature::Generic>\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $filehandle;\n    \n my $line;\n\n    my $id;\n    while ($_=$self->_readline()) {\n         $line = $_;\n         chomp $line;\n    \n        if ( $line=~m/^Alignments of top-scoring domains/ ) {\n          while( my $rest = $self->_readline() ) { last if $rest =~ m!^//! }\n        }\n\n        next if ($line=~m/^Model/ || /^\\-/ || /^$/);\n        \n        if ($line=~m/^Query sequence:\\s+(\\S+)/) {\n           $id = $1;\n           $self->seqname($id);\n        }\n       \n       if (my ($hid, $start, $end, $hstart, $hend, $score, $evalue) = $line=~m/^(\\S+)\\s+\\S+\\s+(\\d+)\\s+(\\d+)\\s+\\S+\\s+(\\d+)\\s+(\\d+)\\s+\\S+\\s+(\\S+)\\s+(\\S+)/) {\n            my %feature;\n            \n            ($feature{name}) = $self->seqname;\n            $feature{raw_score} = $score;\n            $feature{p_value} = sprintf (\"%.3e\", $evalue);\n            $feature{score} = $feature{p_value};\n            $feature{start} = $start;\n            $feature{end} = $end;\n            $feature{hname} = $hid;\n            $feature{hstart} = $hstart;\n            $feature{hend} = $hend;\n            ($feature{source}) = 'pfam';\n            $feature{primary} = $hid;\n            ($feature{program}) = 'pfam';\n            ($feature{db}) = 'db1';\n            ($feature{logic_name}) = 'hmmpfam';\n            my $new_feat = $self->create_feature (\\%feature);\n            return $new_feat\n        \n        }\n        next;\n\n    }\n    return;\n}\n\n=head2 create_feature\n\n Title   : create_feature\n Usage   : my $feat=$hmmpfam_parser->create_feature($feature,$seqname)\n Function: creates a SeqFeature Generic object\n Returns : L<Bio::SeqFeature::Generic>\n Args    :"},"name":"create_feature","containerName":"main::","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"create_feature","line":171},{"line":171,"name":"$feat","containerName":"create_feature","kind":13},{"name":"$feature1","kind":13,"localvar":"my","containerName":"create_feature","line":175,"definition":"my"},{"line":175,"kind":12,"containerName":"create_feature","name":"new"},{"containerName":"create_feature","kind":13,"name":"$feat","line":175},{"kind":13,"containerName":"create_feature","name":"$feat","line":176},{"line":177,"kind":13,"containerName":"create_feature","name":"$feat"},{"kind":13,"containerName":"create_feature","name":"$feat","line":178},{"name":"$feat","kind":13,"containerName":"create_feature","line":179},{"line":180,"containerName":"create_feature","kind":13,"name":"$feat"},{"kind":13,"localvar":"my","containerName":"create_feature","name":"$feature2","line":185,"definition":"my"},{"containerName":"create_feature","kind":12,"name":"new","line":185},{"line":186,"containerName":"create_feature","kind":13,"name":"$feat"},{"line":187,"kind":13,"containerName":"create_feature","name":"$feat"},{"kind":13,"localvar":"my","containerName":"create_feature","name":"$featurepair","line":193,"definition":"my"},{"kind":12,"containerName":"create_feature","name":"new","line":193},{"name":"$featurepair","kind":13,"containerName":"create_feature","line":194},{"containerName":"create_feature","kind":12,"name":"feature1","line":194},{"line":194,"containerName":"create_feature","kind":13,"name":"$feature1"},{"name":"$featurepair","containerName":"create_feature","kind":13,"line":195},{"line":195,"containerName":"create_feature","kind":12,"name":"feature2"},{"line":195,"name":"$feature2","containerName":"create_feature","kind":13},{"line":197,"containerName":"create_feature","kind":13,"name":"$featurepair"},{"line":197,"name":"add_tag_value","kind":12,"containerName":"create_feature"},{"line":197,"kind":13,"containerName":"create_feature","name":"$feat"},{"name":"$featurepair","kind":13,"containerName":"create_feature","line":198},{"name":"add_tag_value","kind":12,"containerName":"create_feature","line":198},{"name":"$featurepair","kind":13,"containerName":"create_feature","line":199},{"line":199,"kind":12,"containerName":"create_feature","name":"add_tag_value"},{"kind":13,"containerName":"create_feature","name":"$feat","line":199},{"name":"$featurepair","containerName":"create_feature","kind":13,"line":200}],"detail":"($self,$feat)","definition":"sub"},{"name":"Bio","containerName":"SeqFeature::Generic","kind":12,"line":175},{"line":175,"kind":12,"name":"name"},{"name":"start","kind":12,"line":176},{"line":177,"kind":12,"name":"end"},{"name":"score","kind":12,"line":178},{"name":"source","kind":12,"line":179},{"name":"primary","kind":12,"line":180},{"line":185,"kind":12,"containerName":"SeqFeature::Generic","name":"Bio"},{"kind":12,"name":"hstart","line":186},{"line":187,"kind":12,"name":"hend"},{"containerName":"SeqFeature::FeaturePair","kind":12,"name":"Bio","line":193},{"line":197,"kind":12,"name":"p_value"},{"kind":12,"name":"primary","line":199},{"line":214,"kind":12,"range":{"end":{"line":224,"character":9999},"start":{"character":0,"line":214}},"signature":{"documentation":"1;\n# $Id: Hmmpfam.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::Tools::Hmmpfam\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by  Balamurugan Kumarasamy\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n#\n\n=head1 NAME\n\nBio::Tools::Hmmpfam - Parser for Hmmpfam program\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Hmmpfam;\n  my @hmmpfam_feat;\n  my $hmmpfam_parser = Bio::Tools::Hmmpfam->new(-fh =>$filehandle );\n  while( my $hmmpfam_feat = $hmmpfam_parser->next_result ) {\n        push @hmmpfam_feat, $hmmpfam_feat;\n  }\n\n=head1 DESCRIPTION\n\nParser for Hmmpfam  program.  See also L<Bio::SearchIO::hmmer>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n User feedback is an integral part of the evolution of this and other\n Bioperl modules. Send your comments and suggestions preferably to\n the Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Balamurugan Kumarasamy\n\n Email: fugui@worf.fugu-sg.org\n\n=head1 APPENDIX\n\n The rest of the documentation details each of the object methods.\n Internal methods are usually preceded with a _\n\n\n\npackage Bio::Tools::Hmmpfam;\nuse strict;\n\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Generic;\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Hmmpfam->new(-fh=>$filehandle);\n Function: Builds a new Bio::Tools::Hmmpfam object\n Returns : Bio::Tools::Hmmpfam\n Args    : -filename\n           -fh (filehandle)\n\n\nsub new {\n      my($class,@args) = @_;\n\n      my $self = $class->SUPER::new(@args);\n      $self->_initialize_io(@args);\n\n      return $self;\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $feat = $hmmpfam_parser->next_result\n Function: Get the next result set from parser data\n Returns : L<Bio::SeqFeature::Generic>\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $filehandle;\n    \n my $line;\n\n    my $id;\n    while ($_=$self->_readline()) {\n         $line = $_;\n         chomp $line;\n    \n        if ( $line=~m/^Alignments of top-scoring domains/ ) {\n          while( my $rest = $self->_readline() ) { last if $rest =~ m!^//! }\n        }\n\n        next if ($line=~m/^Model/ || /^\\-/ || /^$/);\n        \n        if ($line=~m/^Query sequence:\\s+(\\S+)/) {\n           $id = $1;\n           $self->seqname($id);\n        }\n       \n       if (my ($hid, $start, $end, $hstart, $hend, $score, $evalue) = $line=~m/^(\\S+)\\s+\\S+\\s+(\\d+)\\s+(\\d+)\\s+\\S+\\s+(\\d+)\\s+(\\d+)\\s+\\S+\\s+(\\S+)\\s+(\\S+)/) {\n            my %feature;\n            \n            ($feature{name}) = $self->seqname;\n            $feature{raw_score} = $score;\n            $feature{p_value} = sprintf (\"%.3e\", $evalue);\n            $feature{score} = $feature{p_value};\n            $feature{start} = $start;\n            $feature{end} = $end;\n            $feature{hname} = $hid;\n            $feature{hstart} = $hstart;\n            $feature{hend} = $hend;\n            ($feature{source}) = 'pfam';\n            $feature{primary} = $hid;\n            ($feature{program}) = 'pfam';\n            ($feature{db}) = 'db1';\n            ($feature{logic_name}) = 'hmmpfam';\n            my $new_feat = $self->create_feature (\\%feature);\n            return $new_feat\n        \n        }\n        next;\n\n    }\n    return;\n}\n\n=head2 create_feature\n\n Title   : create_feature\n Usage   : my $feat=$hmmpfam_parser->create_feature($feature,$seqname)\n Function: creates a SeqFeature Generic object\n Returns : L<Bio::SeqFeature::Generic>\n Args    :\n\n\n\nsub create_feature {\n    my ($self, $feat) = @_;\n\n\n\n    my $feature1= Bio::SeqFeature::Generic->new( -seq_id  =>$feat->{name},\n                                                -start      =>$feat->{start},\n                                                -end        =>$feat->{end},\n                                                -score      =>$feat->{score},\n                                                -source     =>$feat->{source},\n                                                -primary    =>$feat->{primary},\n                                                   );\n    \n\n\n    my $feature2= Bio::SeqFeature::Generic->new(\n                                                 -start      =>$feat->{hstart},\n                                                 -end        =>$feat->{hend},\n                                                  );\n\n\n\n\n    my $featurepair = Bio::SeqFeature::FeaturePair->new;\n    $featurepair->feature1 ($feature1);\n    $featurepair->feature2 ($feature2);\n   \n   $featurepair->add_tag_value('evalue',$feat->{p_value});\n   $featurepair->add_tag_value('percent_id','NULL');\n   $featurepair->add_tag_value(\"hid\",$feat->{primary});\n    return  $featurepair; \n        \n}\n\n=head2 seqname\n\n Title   :   seqname\n Usage   :   obj->seqname($seqname)\n Function:   Internal(not to be used directly)\n Returns :\n Args    :   seqname","parameters":[{"label":"$self"},{"label":"$seqname"}],"label":"seqname($self,$seqname)"},"children":[{"line":215,"name":"$self","localvar":"my","kind":13,"containerName":"seqname","definition":"my"},{"name":"$seqname","kind":13,"containerName":"seqname","line":215},{"line":217,"name":"$seqname","kind":13,"containerName":"seqname"},{"line":219,"name":"$self","containerName":"seqname","kind":13},{"line":219,"kind":13,"containerName":"seqname","name":"$seqname"},{"line":222,"kind":13,"containerName":"seqname","name":"$self"}],"name":"seqname","containerName":"main::","definition":"sub","detail":"($self,$seqname)"}]}