{"vars":[{"line":82,"name":"vars","kind":2,"containerName":""},{"kind":2,"containerName":"","name":"base","line":93},{"line":94,"name":"$Srctag","kind":13,"containerName":null},{"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Genewise.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Genewise\n#\n# Copyright Fugu Team \n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Genewise - Results of one Genewise run\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Genewise;\n  my $gw = Bio::Tools::Genewise(-file=>\"genewise.out\");\n\n  while (my $gene = $gw->next_prediction){\n    my @transcripts = $gene->transcripts;\n      foreach my $t(@transcripts){\n        my @exons =  $t->exons;\n        foreach my $e(@exons){\n            print $e->start.\" \".$e->end.\"\\n\";\n        }\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis is the parser for the output of Genewise. It takes either a file\nhandle or a file name and returns a \nBio::SeqFeature::Gene::GeneStructure object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Fugu Team, Jason Stajich \n\n Email: fugui@worf.fugu-sg.org\n Email: jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Genewise;\nuse vars qw($Srctag);\nuse strict;\nuse Symbol;\n\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Gene::Exon;\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Gene::Transcript;\nuse Bio::SeqFeature::Gene::GeneStructure;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n$Srctag = 'genewise';\n\n=head2 new\n\n Title   : new\n Usage   : $obj->new(-file=>\"genewise.out\");\n           $obj->new(-fh=>\\*GW);\n Function: Constructor for genewise wrapper. Takes either a file or filehandle\n Example :\n Returns : Bio::Tools::Genewise object\n\nSee L<Bio::Tools::Genewise>"},"line":109,"range":{"start":{"line":109,"character":0},"end":{"character":9999,"line":114}},"kind":12,"definition":"sub","detail":"($class,@args)","children":[{"name":"$class","kind":13,"localvar":"my","containerName":"new","line":110,"definition":"my"},{"line":110,"containerName":"new","kind":13,"name":"@args"},{"kind":13,"localvar":"my","containerName":"new","name":"$self","line":111,"definition":"my"},{"line":111,"kind":13,"containerName":"new","name":"$class"},{"kind":13,"containerName":"new","name":"@args","line":111},{"name":"$self","containerName":"new","kind":13,"line":112},{"name":"_initialize_io","kind":12,"containerName":"new","line":112},{"line":112,"containerName":"new","kind":13,"name":"@args"},{"line":113,"kind":13,"containerName":"new","name":"$self"}],"containerName":"main::","name":"new"},{"line":111,"name":"SUPER","containerName":"new","kind":12},{"range":{"start":{"line":127,"character":0},"end":{"line":142,"character":9999}},"kind":12,"line":127,"signature":{"documentation":"1;\n# $Id: Genewise.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Genewise\n#\n# Copyright Fugu Team \n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Genewise - Results of one Genewise run\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Genewise;\n  my $gw = Bio::Tools::Genewise(-file=>\"genewise.out\");\n\n  while (my $gene = $gw->next_prediction){\n    my @transcripts = $gene->transcripts;\n      foreach my $t(@transcripts){\n        my @exons =  $t->exons;\n        foreach my $e(@exons){\n            print $e->start.\" \".$e->end.\"\\n\";\n        }\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis is the parser for the output of Genewise. It takes either a file\nhandle or a file name and returns a \nBio::SeqFeature::Gene::GeneStructure object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Fugu Team, Jason Stajich \n\n Email: fugui@worf.fugu-sg.org\n Email: jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Genewise;\nuse vars qw($Srctag);\nuse strict;\nuse Symbol;\n\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Gene::Exon;\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Gene::Transcript;\nuse Bio::SeqFeature::Gene::GeneStructure;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n$Srctag = 'genewise';\n\n=head2 new\n\n Title   : new\n Usage   : $obj->new(-file=>\"genewise.out\");\n           $obj->new(-fh=>\\*GW);\n Function: Constructor for genewise wrapper. Takes either a file or filehandle\n Example :\n Returns : Bio::Tools::Genewise object\n\nSee L<Bio::Tools::Genewise>\n\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  $self->_initialize_io(@args);\n  return $self;\n}\n\n=head2 _get_strand\n\n Title   : _get_strand\n Usage   : $obj->_get_strand\n Function: takes start and end values, swap them if start>end and \n           returns end\n Example :\n Returns :$start,$end,$strand","parameters":[{"label":"$self"},{"label":"$start"},{"label":"$end"}],"label":"_get_strand($self,$start,$end)"},"name":"_get_strand","containerName":"main::","children":[{"line":128,"containerName":"_get_strand","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":128,"name":"$start","containerName":"_get_strand","kind":13},{"line":128,"name":"$end","containerName":"_get_strand","kind":13},{"line":129,"kind":13,"containerName":"_get_strand","name":"$start"},{"name":"$self","kind":13,"containerName":"_get_strand","line":129},{"line":129,"containerName":"_get_strand","kind":12,"name":"throw"},{"name":"$end","containerName":"_get_strand","kind":13,"line":130},{"kind":13,"containerName":"_get_strand","name":"$self","line":130},{"name":"throw","kind":12,"containerName":"_get_strand","line":130},{"name":"$strand","localvar":"my","containerName":"_get_strand","kind":13,"line":131,"definition":"my"},{"kind":13,"containerName":"_get_strand","name":"$start","line":132},{"kind":13,"containerName":"_get_strand","name":"$end","line":132},{"line":133,"kind":13,"localvar":"my","containerName":"_get_strand","name":"$tmp","definition":"my"},{"kind":13,"containerName":"_get_strand","name":"$start","line":133},{"line":134,"containerName":"_get_strand","kind":13,"name":"$start"},{"line":134,"kind":13,"containerName":"_get_strand","name":"$end"},{"line":135,"containerName":"_get_strand","kind":13,"name":"$end"},{"line":135,"kind":13,"containerName":"_get_strand","name":"$tmp"},{"line":136,"kind":13,"containerName":"_get_strand","name":"$strand"},{"line":139,"kind":13,"containerName":"_get_strand","name":"$strand"},{"name":"$start","kind":13,"containerName":"_get_strand","line":141},{"line":141,"name":"$end","kind":13,"containerName":"_get_strand"},{"line":141,"name":"$strand","containerName":"_get_strand","kind":13}],"detail":"($self,$start,$end)","definition":"sub"},{"kind":12,"range":{"end":{"character":9999,"line":157},"start":{"character":0,"line":153}},"line":153,"definition":"sub","name":"_score","containerName":"main::","children":[{"name":"$self","containerName":"_score","localvar":"my","kind":13,"line":154,"definition":"my"},{"line":155,"containerName":"_score","kind":13,"name":"$self"},{"line":156,"containerName":"_score","kind":13,"name":"$self"}]},{"containerName":"main::","name":"_prot_id","children":[{"localvar":"my","kind":13,"containerName":"_prot_id","name":"$self","line":169,"definition":"my"},{"name":"$self","kind":13,"containerName":"_prot_id","line":170},{"line":171,"containerName":"_prot_id","kind":13,"name":"$self"}],"definition":"sub","range":{"end":{"line":172,"character":9999},"start":{"character":0,"line":168}},"kind":12,"line":168},{"kind":12,"range":{"end":{"line":188,"character":9999},"start":{"line":184,"character":0}},"line":184,"name":"_target_id","containerName":"main::","children":[{"localvar":"my","containerName":"_target_id","kind":13,"name":"$self","line":185,"definition":"my"},{"name":"$self","containerName":"_target_id","kind":13,"line":186},{"name":"$self","kind":13,"containerName":"_target_id","line":187}],"definition":"sub"},{"definition":"sub","detail":"($self)","children":[{"localvar":"my","containerName":"next_prediction","kind":13,"name":"$self","line":210,"definition":"my"},{"name":"$self","kind":13,"containerName":"next_prediction","line":212},{"containerName":"next_prediction","kind":12,"name":"parsed","line":212},{"name":"$self","containerName":"next_prediction","kind":13,"line":213},{"containerName":"next_prediction","kind":12,"name":"_parse_genes","line":213},{"line":214,"name":"$self","containerName":"next_prediction","kind":13},{"kind":12,"containerName":"next_prediction","name":"parsed","line":214},{"line":216,"kind":13,"containerName":"next_prediction","name":"$self"}],"containerName":"main::","name":"next_prediction","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Genewise.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Genewise\n#\n# Copyright Fugu Team \n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Genewise - Results of one Genewise run\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Genewise;\n  my $gw = Bio::Tools::Genewise(-file=>\"genewise.out\");\n\n  while (my $gene = $gw->next_prediction){\n    my @transcripts = $gene->transcripts;\n      foreach my $t(@transcripts){\n        my @exons =  $t->exons;\n        foreach my $e(@exons){\n            print $e->start.\" \".$e->end.\"\\n\";\n        }\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis is the parser for the output of Genewise. It takes either a file\nhandle or a file name and returns a \nBio::SeqFeature::Gene::GeneStructure object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Fugu Team, Jason Stajich \n\n Email: fugui@worf.fugu-sg.org\n Email: jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Genewise;\nuse vars qw($Srctag);\nuse strict;\nuse Symbol;\n\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Gene::Exon;\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Gene::Transcript;\nuse Bio::SeqFeature::Gene::GeneStructure;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n$Srctag = 'genewise';\n\n=head2 new\n\n Title   : new\n Usage   : $obj->new(-file=>\"genewise.out\");\n           $obj->new(-fh=>\\*GW);\n Function: Constructor for genewise wrapper. Takes either a file or filehandle\n Example :\n Returns : Bio::Tools::Genewise object\n\nSee L<Bio::Tools::Genewise>\n\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  $self->_initialize_io(@args);\n  return $self;\n}\n\n=head2 _get_strand\n\n Title   : _get_strand\n Usage   : $obj->_get_strand\n Function: takes start and end values, swap them if start>end and \n           returns end\n Example :\n Returns :$start,$end,$strand\n\n\nsub _get_strand {\n  my ($self,$start,$end) = @_;\n  defined($start) || $self->throw(\"Need a start\");\n  defined($end)   || $self->throw(\"Need an end\");\n  my $strand;\n  if ($start > $end) {\n    my $tmp = $start;\n    $start = $end;\n    $end = $tmp;\n    $strand = -1;\n  }\n  else {\n    $strand = 1;\n  }\n  return ($start,$end,$strand);\n}\n\n=head2 _score\n\n Title   : _score\n Usage   : $obj->_score\n Function: get/set for score info\n Returns : a score value\n\n\nsub _score {\n    my $self = shift;\n    return $self->{'_score'} = shift if @_;\n    return $self->{'_score'};\n}\n\n=head2 _prot_id\n\n Title   : _prot_id\n Usage   : $obj->_prot_id\n Function: get/set for protein id \n Returns :a protein id\n\n\nsub _prot_id {\n    my $self = shift;\n    return $self->{'_prot_id'} = shift if @_;\n    return $self->{'_prot_id'};\n}\n\n=head2 _target_id\n\n Title   : _target_id\n Usage   : $obj->_target_id\n Function: get/set for genomic sequence id\n Example :\n Returns :a target id\n\n\nsub _target_id {\n    my $self = shift;\n    return $self->{'_target_id'} = shift if @_;\n    return $self->{'_target_id'};\n}\n\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $genewise->next_prediction()) {\n                  # do something\n           }\n Function: Returns the gene structure prediction of the Genewise result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : a Bio::SeqFeature::Gene::GeneStructure object\n Args    :\n\nSee L<Bio::SeqFeature::Gene::GeneStructure>","label":"next_prediction($self)"},"line":209,"range":{"end":{"character":9999,"line":216},"start":{"line":209,"character":0}},"kind":12},{"definition":"sub","name":"parsed","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"parsed","line":220},{"line":221,"kind":13,"containerName":"parsed","name":"$self"},{"name":"$self","kind":13,"containerName":"parsed","line":222}],"kind":12,"range":{"end":{"line":223,"character":9999},"start":{"character":0,"line":219}},"line":219},{"name":"_parse_genes","containerName":"main::","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"_parse_genes","line":226},{"name":"@alignments","kind":13,"localvar":"my","containerName":"_parse_genes","line":227,"definition":"my"},{"name":"@genes","containerName":"_parse_genes","kind":13,"line":227},{"kind":13,"containerName":"_parse_genes","name":"$self","line":230},{"name":"_readline","kind":12,"containerName":"_parse_genes","line":230},{"line":231,"name":"$self","containerName":"_parse_genes","kind":13},{"line":231,"name":"debug","containerName":"_parse_genes","kind":12},{"name":"$alignments","containerName":"_parse_genes","kind":13,"line":233},{"containerName":"_parse_genes","kind":13,"name":"$self","line":236},{"line":236,"kind":12,"containerName":"_parse_genes","name":"_score"},{"kind":13,"containerName":"_parse_genes","name":"$self","line":240},{"name":"_prot_id","kind":12,"containerName":"_parse_genes","line":240},{"containerName":"_parse_genes","kind":13,"name":"$self","line":244},{"line":244,"name":"_target_id","containerName":"_parse_genes","kind":12},{"kind":13,"localvar":"my","containerName":"_parse_genes","name":"@genes_txt","line":248,"definition":"my"},{"line":249,"name":"@genes_txt","kind":13,"containerName":"_parse_genes"},{"definition":"my","line":250,"name":"$gene_num","localvar":"my","containerName":"_parse_genes","kind":13},{"localvar":"my","kind":13,"containerName":"_parse_genes","name":"$gene_txt","line":251,"definition":"my"},{"line":251,"containerName":"_parse_genes","kind":13,"name":"@genes_txt"},{"line":252,"localvar":"my","containerName":"_parse_genes","kind":13,"name":"$score","definition":"my"},{"line":252,"name":"$alignments","kind":13,"containerName":"_parse_genes"},{"line":252,"name":"$gene_num","containerName":"_parse_genes","kind":13},{"definition":"my","line":255,"kind":13,"localvar":"my","containerName":"_parse_genes","name":"$g_start"},{"containerName":"_parse_genes","kind":13,"name":"$g_end","line":255},{"line":255,"kind":13,"containerName":"_parse_genes","name":"$type"},{"containerName":"_parse_genes","kind":13,"name":"$gene_txt","line":256},{"definition":"my","line":261,"containerName":"_parse_genes","localvar":"my","kind":13,"name":"$g_strand"},{"containerName":"_parse_genes","localvar":"my","kind":13,"name":"$source_tag","line":262,"definition":"my"},{"name":"$type","kind":13,"containerName":"_parse_genes","line":262},{"name":"$Srctag","kind":13,"containerName":"_parse_genes","line":262},{"line":263,"name":"$genes","localvar":"my","kind":13,"containerName":"_parse_genes","definition":"my"},{"name":"new","kind":12,"containerName":"_parse_genes","line":264},{"kind":13,"containerName":"_parse_genes","name":"$source_tag","line":264},{"name":"$self","containerName":"_parse_genes","kind":13,"line":265},{"line":265,"name":"_score","containerName":"_parse_genes","kind":12},{"name":"$genes","containerName":"_parse_genes","kind":13,"line":267},{"line":267,"name":"add_tag_value","containerName":"_parse_genes","kind":12},{"line":267,"containerName":"_parse_genes","kind":13,"name":"$self"},{"containerName":"_parse_genes","kind":12,"name":"_prot_id","line":267},{"line":268,"name":"$transcript","localvar":"my","containerName":"_parse_genes","kind":13,"definition":"my"},{"name":"new","containerName":"_parse_genes","kind":12,"line":269},{"line":269,"name":"$source_tag","kind":13,"containerName":"_parse_genes"},{"line":270,"kind":13,"containerName":"_parse_genes","name":"$score"},{"line":271,"containerName":"_parse_genes","kind":13,"name":"$g_start"},{"line":271,"name":"$g_end","kind":13,"containerName":"_parse_genes"},{"line":271,"name":"$g_strand","kind":13,"containerName":"_parse_genes"},{"kind":13,"containerName":"_parse_genes","name":"$self","line":271},{"name":"_get_strand","containerName":"_parse_genes","kind":12,"line":271},{"line":271,"kind":13,"containerName":"_parse_genes","name":"$g_start"},{"line":271,"name":"$g_end","kind":13,"containerName":"_parse_genes"},{"containerName":"_parse_genes","kind":13,"name":"$genes","line":272},{"line":272,"containerName":"_parse_genes","kind":12,"name":"strand"},{"line":272,"containerName":"_parse_genes","kind":13,"name":"$g_strand"},{"definition":"my","line":275,"name":"@exons","kind":13,"localvar":"my","containerName":"_parse_genes"},{"name":"@exons","containerName":"_parse_genes","kind":13,"line":276},{"name":"$gene_txt","kind":13,"containerName":"_parse_genes","line":276},{"name":"@exons","kind":13,"containerName":"_parse_genes","line":277},{"line":277,"containerName":"_parse_genes","kind":13,"name":"$gene_txt"},{"definition":"my","name":"$nbr","localvar":"my","containerName":"_parse_genes","kind":13,"line":279},{"name":"$e","containerName":"_parse_genes","localvar":"my","kind":13,"line":282,"definition":"my"},{"name":"@exons","kind":13,"containerName":"_parse_genes","line":282},{"definition":"my","line":283,"localvar":"my","kind":13,"containerName":"_parse_genes","name":"$e_start"},{"name":"$e_end","containerName":"_parse_genes","kind":13,"line":283},{"kind":13,"containerName":"_parse_genes","name":"$phase","line":283},{"name":"$e","kind":13,"containerName":"_parse_genes","line":284},{"line":289,"name":"$e_strand","localvar":"my","kind":13,"containerName":"_parse_genes","definition":"my"},{"containerName":"_parse_genes","kind":13,"name":"$e_start","line":290},{"kind":13,"containerName":"_parse_genes","name":"$e_end","line":290},{"containerName":"_parse_genes","kind":13,"name":"$e_strand","line":290},{"name":"$self","containerName":"_parse_genes","kind":13,"line":290},{"line":290,"name":"_get_strand","containerName":"_parse_genes","kind":12},{"containerName":"_parse_genes","kind":13,"name":"$e_start","line":290},{"kind":13,"containerName":"_parse_genes","name":"$e_end","line":291},{"name":"$transcript","containerName":"_parse_genes","kind":13,"line":292},{"line":292,"name":"strand","kind":12,"containerName":"_parse_genes"},{"line":292,"name":"$e_strand","kind":13,"containerName":"_parse_genes"},{"line":292,"name":"$transcript","containerName":"_parse_genes","kind":13},{"line":292,"name":"strand","kind":12,"containerName":"_parse_genes"},{"name":"$exon","localvar":"my","containerName":"_parse_genes","kind":13,"line":293,"definition":"my"},{"containerName":"_parse_genes","kind":12,"name":"new","line":294},{"kind":13,"containerName":"_parse_genes","name":"$self","line":294},{"line":294,"name":"_target_id","kind":12,"containerName":"_parse_genes"},{"line":295,"kind":13,"containerName":"_parse_genes","name":"$source_tag"},{"line":296,"kind":13,"containerName":"_parse_genes","name":"$e_start"},{"line":297,"containerName":"_parse_genes","kind":13,"name":"$e_end"},{"line":298,"containerName":"_parse_genes","kind":13,"name":"$score"},{"line":300,"kind":13,"containerName":"_parse_genes","name":"$e_strand"},{"line":302,"name":"$exon","kind":13,"containerName":"_parse_genes"},{"containerName":"_parse_genes","kind":12,"name":"add_tag_value","line":302},{"containerName":"_parse_genes","kind":13,"name":"$phase","line":302},{"containerName":"_parse_genes","kind":13,"name":"$exon","line":303},{"containerName":"_parse_genes","kind":12,"name":"is_coding","line":303},{"name":"$self","containerName":"_parse_genes","kind":13,"line":304},{"line":304,"name":"_prot_id","containerName":"_parse_genes","kind":12},{"line":305,"name":"$exon","containerName":"_parse_genes","kind":13},{"line":305,"containerName":"_parse_genes","kind":12,"name":"add_tag_value"},{"kind":13,"containerName":"_parse_genes","name":"$self","line":305},{"name":"_prot_id","containerName":"_parse_genes","kind":12,"line":305},{"line":307,"name":"$exon","kind":13,"containerName":"_parse_genes"},{"name":"add_tag_value","kind":12,"containerName":"_parse_genes","line":307},{"line":307,"containerName":"_parse_genes","kind":13,"name":"$nbr"},{"line":308,"kind":13,"containerName":"_parse_genes","name":"$e"},{"line":309,"kind":13,"localvar":"my","containerName":"_parse_genes","name":"$geno_start","definition":"my"},{"line":309,"containerName":"_parse_genes","kind":13,"name":"$geno_end"},{"line":310,"kind":13,"containerName":"_parse_genes","name":"$prot_start"},{"line":310,"kind":13,"containerName":"_parse_genes","name":"$prot_end"},{"line":311,"name":"$prot_strand","localvar":"my","containerName":"_parse_genes","kind":13,"definition":"my"},{"line":312,"name":"$prot_start","containerName":"_parse_genes","kind":13},{"line":312,"kind":13,"containerName":"_parse_genes","name":"$prot_end"},{"name":"$prot_strand","kind":13,"containerName":"_parse_genes","line":313},{"line":313,"name":"$self","containerName":"_parse_genes","kind":13},{"kind":12,"containerName":"_parse_genes","name":"_get_strand","line":313},{"name":"$prot_start","kind":13,"containerName":"_parse_genes","line":313},{"name":"$prot_end","containerName":"_parse_genes","kind":13,"line":313},{"definition":"my","localvar":"my","containerName":"_parse_genes","kind":13,"name":"$pf","line":314},{"line":315,"kind":12,"containerName":"_parse_genes","name":"new"},{"name":"$prot_start","kind":13,"containerName":"_parse_genes","line":315},{"kind":13,"containerName":"_parse_genes","name":"$prot_end","line":316},{"line":317,"name":"$self","containerName":"_parse_genes","kind":13},{"name":"_prot_id","containerName":"_parse_genes","kind":12,"line":317},{"name":"$score","kind":13,"containerName":"_parse_genes","line":318},{"name":"$prot_strand","kind":13,"containerName":"_parse_genes","line":319},{"line":320,"kind":13,"containerName":"_parse_genes","name":"$source_tag"},{"name":"$geno_strand","localvar":"my","containerName":"_parse_genes","kind":13,"line":322,"definition":"my"},{"line":323,"kind":13,"containerName":"_parse_genes","name":"$geno_start"},{"line":323,"name":"$geno_end","containerName":"_parse_genes","kind":13},{"line":324,"containerName":"_parse_genes","kind":13,"name":"$geno_strand"},{"containerName":"_parse_genes","kind":13,"name":"$self","line":324},{"line":324,"containerName":"_parse_genes","kind":12,"name":"_get_strand"},{"name":"$geno_start","kind":13,"containerName":"_parse_genes","line":324},{"name":"$geno_end","containerName":"_parse_genes","kind":13,"line":324},{"definition":"my","kind":13,"localvar":"my","containerName":"_parse_genes","name":"$gf","line":325},{"name":"new","kind":12,"containerName":"_parse_genes","line":325},{"name":"$geno_start","containerName":"_parse_genes","kind":13,"line":326},{"name":"$geno_end","containerName":"_parse_genes","kind":13,"line":327},{"line":328,"kind":13,"containerName":"_parse_genes","name":"$self"},{"line":328,"name":"_target_id","containerName":"_parse_genes","kind":12},{"kind":13,"containerName":"_parse_genes","name":"$score","line":329},{"line":330,"name":"$geno_strand","kind":13,"containerName":"_parse_genes"},{"line":331,"kind":13,"containerName":"_parse_genes","name":"$source_tag"},{"definition":"my","line":333,"name":"$fp","localvar":"my","kind":13,"containerName":"_parse_genes"},{"kind":12,"containerName":"_parse_genes","name":"new","line":334},{"kind":13,"containerName":"_parse_genes","name":"$gf","line":334},{"containerName":"_parse_genes","kind":13,"name":"$pf","line":335},{"name":"$exon","containerName":"_parse_genes","kind":13,"line":336},{"line":336,"name":"add_tag_value","containerName":"_parse_genes","kind":12},{"containerName":"_parse_genes","kind":13,"name":"$fp","line":336},{"name":"$self","containerName":"_parse_genes","kind":13,"line":337},{"line":337,"containerName":"_parse_genes","kind":12,"name":"_prot_id"},{"line":338,"name":"$exon","containerName":"_parse_genes","kind":13},{"containerName":"_parse_genes","kind":12,"name":"add_tag_value","line":338},{"name":"$self","kind":13,"containerName":"_parse_genes","line":338},{"line":338,"containerName":"_parse_genes","kind":12,"name":"_prot_id"},{"kind":13,"containerName":"_parse_genes","name":"$exon","line":339},{"kind":12,"containerName":"_parse_genes","name":"add_tag_value","line":339},{"name":"$prot_start","containerName":"_parse_genes","kind":13,"line":339},{"name":"$exon","kind":13,"containerName":"_parse_genes","line":340},{"name":"add_tag_value","kind":12,"containerName":"_parse_genes","line":340},{"line":340,"name":"$prot_end","kind":13,"containerName":"_parse_genes"},{"line":343,"containerName":"_parse_genes","kind":13,"name":"$transcript"},{"line":343,"kind":12,"containerName":"_parse_genes","name":"add_exon"},{"line":343,"name":"$exon","kind":13,"containerName":"_parse_genes"},{"name":"$transcript","containerName":"_parse_genes","kind":13,"line":345},{"containerName":"_parse_genes","kind":12,"name":"seq_id","line":345},{"name":"$self","containerName":"_parse_genes","kind":13,"line":345},{"line":345,"kind":12,"containerName":"_parse_genes","name":"_target_id"},{"line":346,"kind":13,"containerName":"_parse_genes","name":"$transcript"},{"name":"add_tag_value","containerName":"_parse_genes","kind":12,"line":346},{"line":346,"kind":13,"containerName":"_parse_genes","name":"$self"},{"name":"_prot_id","kind":12,"containerName":"_parse_genes","line":346},{"name":"$transcript","containerName":"_parse_genes","kind":13,"line":347},{"line":347,"containerName":"_parse_genes","kind":12,"name":"add_tag_value"},{"line":347,"name":"$self","containerName":"_parse_genes","kind":13},{"line":347,"name":"_prot_id","containerName":"_parse_genes","kind":12},{"kind":13,"containerName":"_parse_genes","name":"$genes","line":348},{"line":348,"name":"add_transcript","kind":12,"containerName":"_parse_genes"},{"name":"$transcript","kind":13,"containerName":"_parse_genes","line":348},{"line":349,"containerName":"_parse_genes","kind":13,"name":"$genes"},{"line":349,"name":"seq_id","containerName":"_parse_genes","kind":12},{"line":349,"name":"$self","kind":13,"containerName":"_parse_genes"},{"line":349,"name":"_target_id","kind":12,"containerName":"_parse_genes"},{"line":350,"kind":13,"containerName":"_parse_genes","name":"@genes"},{"line":350,"name":"$genes","containerName":"_parse_genes","kind":13},{"line":351,"name":"$gene_num","containerName":"_parse_genes","kind":13},{"name":"$self","kind":13,"containerName":"_parse_genes","line":354},{"line":354,"containerName":"_parse_genes","kind":13,"name":"@genes"}],"detail":"($self)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":225},"end":{"line":355,"character":9999}},"line":225,"signature":{"parameters":[{"label":"$self"}],"documentation":"","label":"_parse_genes($self)"}},{"name":"Bio","containerName":"SeqFeature::Gene::GeneStructure","kind":12,"line":263},{"kind":12,"containerName":"SeqFeature::Gene::Transcript","name":"Bio","line":268},{"name":"Bio","kind":12,"containerName":"SeqFeature::Gene::Exon","line":293},{"line":314,"containerName":"SeqFeature::Generic","kind":12,"name":"Bio"},{"line":325,"containerName":"SeqFeature::Generic","kind":12,"name":"Bio"},{"line":333,"containerName":"SeqFeature::FeaturePair","kind":12,"name":"Bio"}],"version":5}