{"vars":[{"kind":2,"containerName":"","name":"base","line":103},{"containerName":"main::","name":"new","children":[{"localvar":"my","kind":13,"containerName":"new","name":"$class","line":118,"definition":"my"},{"line":118,"containerName":"new","kind":13,"name":"@args"},{"definition":"my","line":120,"name":"$self","kind":13,"localvar":"my","containerName":"new"},{"line":120,"name":"$class","kind":13,"containerName":"new"},{"name":"@args","kind":13,"containerName":"new","line":120},{"definition":"my","name":"$seqs","localvar":"my","kind":13,"containerName":"new","line":121},{"name":"$dilate","kind":13,"containerName":"new","line":121},{"line":121,"kind":13,"containerName":"new","name":"$self"},{"line":121,"name":"_rearrange","kind":12,"containerName":"new"},{"containerName":"new","kind":13,"name":"@args","line":122},{"name":"$seqs","containerName":"new","kind":13,"line":123},{"line":124,"containerName":"new","kind":13,"name":"$self"},{"line":124,"containerName":"new","kind":12,"name":"add_band"},{"line":124,"containerName":"new","kind":13,"name":"$seqs"},{"line":125,"containerName":"new","kind":13,"name":"$seqs"},{"containerName":"new","kind":13,"name":"$seqs","line":126},{"line":126,"containerName":"new","kind":12,"name":"isa"},{"name":"$self","kind":13,"containerName":"new","line":127},{"line":127,"name":"add_band","kind":12,"containerName":"new"},{"line":127,"name":"$seqs","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$self","line":129},{"containerName":"new","kind":12,"name":"dilate","line":129},{"name":"$dilate","containerName":"new","kind":13,"line":129},{"line":131,"kind":13,"containerName":"new","name":"$self"}],"detail":"($class,@args)","definition":"sub","range":{"start":{"character":0,"line":117},"end":{"character":9999,"line":132}},"kind":12,"line":117,"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Gel.pm 16123 2009-09-17 12:57:27Z cjfields $\n# \n# BioPerl module for Bio::Tools::Gel\n# Copyright Allen Day <allenday@ucla.edu>\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Gel - Calculates relative electrophoretic migration distances\n\n=head1 SYNOPSIS\n\n    use Bio::PrimarySeq;\n    use Bio::Restriction::Analysis;\n    use Bio::Tools::Gel;\n\n    # get a sequence\n    my $d = 'AAAAAAAAAGAATTCTTTTTTTTTTTTTTGAATTCGGGGGGGGGGGGGGGGGGGG';\n    my $seq1 = Bio::Seq->new(-id=>'groundhog day',-seq=>$d);\n\n    # cut it with an enzyme\n    my $ra=Bio::Restriction::Analysis->new(-seq=>$seq1);\n    @cuts = $ra->fragments('EcoRI'), 3;\n\n    # analyse the fragments in a gel\n    my $gel = Bio::Tools::Gel->new(-seq=>\\@cuts,-dilate=>10);\n    my %bands = $gel->bands;\n    foreach my $band (sort {$b <=> $a} keys %bands){\n      print $band,\"\\t\", sprintf(\"%.1f\", $bands{$band}),\"\\n\";\n    }\n\n    #prints:\n    #20   27.0\n    #25   26.0\n    #10   30.0\n\n\n=head1 DESCRIPTION\n\nThis takes a set of sequences or Bio::Seq objects, and calculates their\nrespective migration distances using:\n    distance = dilation * (4 - log10(length(dna));\n\nSource: Molecular Cloning, a Laboratory Manual. Sambrook, Fritsch, Maniatis. \nCSHL Press, 1989.\n\nBio::Tools::Gel currently calculates migration distances based solely on\nthe length of the nucleotide sequence.  Secondary or tertiary structure, \ncurvature, and other biophysical attributes of a sequence are currently \nnot considered.  Polypeptide migration is currently not supported.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nEmail allenday@ucla.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Gel;\nuse strict;\n\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $gel = Bio::Tools::Gel->new(-seq => $sequence,-dilate => 3);\n Function: Initializes a new Gel\n Returns : Bio::Tools::Gel\n Args    : -seq      => Bio::Seq(s), scalar(s) or list of either/both \n                        (default: none)\n           -dilate   => Expand band migration distances (default: 1)","label":"new($class,@args)"}},{"line":120,"name":"SUPER","kind":12,"containerName":"new"},{"children":[{"definition":"my","line":146,"localvar":"my","kind":13,"containerName":"add_band","name":"$self"},{"name":"$args","kind":13,"containerName":"add_band","line":146},{"kind":13,"localvar":"my","containerName":"add_band","name":"$arg","line":148,"definition":"my"},{"kind":13,"containerName":"add_band","name":"$args","line":148},{"definition":"my","line":149,"localvar":"my","containerName":"add_band","kind":13,"name":"$seq"},{"containerName":"add_band","kind":13,"name":"$arg","line":150},{"line":151,"name":"$arg","kind":13,"containerName":"add_band"},{"line":152,"containerName":"add_band","kind":13,"name":"$seq"},{"name":"new","containerName":"add_band","kind":12,"line":152},{"kind":13,"containerName":"add_band","name":"$arg","line":152},{"line":152,"containerName":"add_band","kind":13,"name":"$arg"},{"kind":13,"containerName":"add_band","name":"$seq","line":154},{"kind":12,"containerName":"add_band","name":"new","line":154},{"line":154,"containerName":"add_band","kind":13,"name":"$arg"},{"name":"$arg","kind":13,"containerName":"add_band","line":154},{"kind":13,"containerName":"add_band","name":"$arg","line":156},{"kind":12,"containerName":"add_band","name":"isa","line":156},{"name":"$seq","kind":13,"containerName":"add_band","line":157},{"line":157,"containerName":"add_band","kind":13,"name":"$arg"},{"line":160,"name":"$seq","containerName":"add_band","kind":13},{"name":"validate_seq","kind":12,"containerName":"add_band","line":160},{"line":160,"name":"$seq","kind":13,"containerName":"add_band"},{"kind":12,"containerName":"add_band","name":"throw","line":160},{"kind":13,"containerName":"add_band","name":"$seq","line":160},{"line":160,"name":"seq","kind":12,"containerName":"add_band"},{"line":161,"containerName":"add_band","kind":13,"name":"$self"},{"line":161,"kind":12,"containerName":"add_band","name":"_add_band"},{"name":"$seq","kind":13,"containerName":"add_band","line":161}],"containerName":"main::","name":"add_band","definition":"sub","detail":"($self,$args)","line":145,"kind":12,"range":{"end":{"character":9999,"line":163},"start":{"line":145,"character":0}},"signature":{"documentation":"1;\n# $Id: Gel.pm 16123 2009-09-17 12:57:27Z cjfields $\n# \n# BioPerl module for Bio::Tools::Gel\n# Copyright Allen Day <allenday@ucla.edu>\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Gel - Calculates relative electrophoretic migration distances\n\n=head1 SYNOPSIS\n\n    use Bio::PrimarySeq;\n    use Bio::Restriction::Analysis;\n    use Bio::Tools::Gel;\n\n    # get a sequence\n    my $d = 'AAAAAAAAAGAATTCTTTTTTTTTTTTTTGAATTCGGGGGGGGGGGGGGGGGGGG';\n    my $seq1 = Bio::Seq->new(-id=>'groundhog day',-seq=>$d);\n\n    # cut it with an enzyme\n    my $ra=Bio::Restriction::Analysis->new(-seq=>$seq1);\n    @cuts = $ra->fragments('EcoRI'), 3;\n\n    # analyse the fragments in a gel\n    my $gel = Bio::Tools::Gel->new(-seq=>\\@cuts,-dilate=>10);\n    my %bands = $gel->bands;\n    foreach my $band (sort {$b <=> $a} keys %bands){\n      print $band,\"\\t\", sprintf(\"%.1f\", $bands{$band}),\"\\n\";\n    }\n\n    #prints:\n    #20   27.0\n    #25   26.0\n    #10   30.0\n\n\n=head1 DESCRIPTION\n\nThis takes a set of sequences or Bio::Seq objects, and calculates their\nrespective migration distances using:\n    distance = dilation * (4 - log10(length(dna));\n\nSource: Molecular Cloning, a Laboratory Manual. Sambrook, Fritsch, Maniatis. \nCSHL Press, 1989.\n\nBio::Tools::Gel currently calculates migration distances based solely on\nthe length of the nucleotide sequence.  Secondary or tertiary structure, \ncurvature, and other biophysical attributes of a sequence are currently \nnot considered.  Polypeptide migration is currently not supported.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nEmail allenday@ucla.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Gel;\nuse strict;\n\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $gel = Bio::Tools::Gel->new(-seq => $sequence,-dilate => 3);\n Function: Initializes a new Gel\n Returns : Bio::Tools::Gel\n Args    : -seq      => Bio::Seq(s), scalar(s) or list of either/both \n                        (default: none)\n           -dilate   => Expand band migration distances (default: 1)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($seqs,$dilate) = $self->_rearrange([qw(SEQ DILATE)],\n\t\t\t\t\t  @args);\n  if( ! ref($seqs)  ) {\n      $self->add_band([$seqs]);\n  } elsif( ref($seqs) =~ /array/i ||\n\t   $seqs->isa('Bio::PrimarySeqI') ) {\n      $self->add_band($seqs);\n  } \n  $self->dilate($dilate || 1);\n  \n  return $self;\n}\n\n\n=head2 add_band\n\n Title   : add_band\n Usage   : $gel->add_band($seq);\n Function: Calls _add_band with a (possibly created) Bio::Seq object.\n Returns : \n Args    : Bio::Seq, scalar sequence, or list of either/both.","parameters":[{"label":"$self"},{"label":"$args"}],"label":"add_band($self,$args)"}},{"line":152,"kind":12,"containerName":"PrimarySeq","name":"Bio"},{"containerName":"PrimarySeq","kind":12,"name":"Bio","line":154},{"definition":"sub","detail":"($self,$arg)","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"_add_band","line":176},{"line":176,"kind":13,"containerName":"_add_band","name":"$arg"},{"line":177,"kind":13,"containerName":"_add_band","name":"$arg"},{"line":178,"containerName":"_add_band","kind":13,"name":"$self"},{"line":178,"name":"$arg","kind":13,"containerName":"_add_band"}],"name":"_add_band","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$arg"}],"documentation":"1;\n# $Id: Gel.pm 16123 2009-09-17 12:57:27Z cjfields $\n# \n# BioPerl module for Bio::Tools::Gel\n# Copyright Allen Day <allenday@ucla.edu>\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Gel - Calculates relative electrophoretic migration distances\n\n=head1 SYNOPSIS\n\n    use Bio::PrimarySeq;\n    use Bio::Restriction::Analysis;\n    use Bio::Tools::Gel;\n\n    # get a sequence\n    my $d = 'AAAAAAAAAGAATTCTTTTTTTTTTTTTTGAATTCGGGGGGGGGGGGGGGGGGGG';\n    my $seq1 = Bio::Seq->new(-id=>'groundhog day',-seq=>$d);\n\n    # cut it with an enzyme\n    my $ra=Bio::Restriction::Analysis->new(-seq=>$seq1);\n    @cuts = $ra->fragments('EcoRI'), 3;\n\n    # analyse the fragments in a gel\n    my $gel = Bio::Tools::Gel->new(-seq=>\\@cuts,-dilate=>10);\n    my %bands = $gel->bands;\n    foreach my $band (sort {$b <=> $a} keys %bands){\n      print $band,\"\\t\", sprintf(\"%.1f\", $bands{$band}),\"\\n\";\n    }\n\n    #prints:\n    #20   27.0\n    #25   26.0\n    #10   30.0\n\n\n=head1 DESCRIPTION\n\nThis takes a set of sequences or Bio::Seq objects, and calculates their\nrespective migration distances using:\n    distance = dilation * (4 - log10(length(dna));\n\nSource: Molecular Cloning, a Laboratory Manual. Sambrook, Fritsch, Maniatis. \nCSHL Press, 1989.\n\nBio::Tools::Gel currently calculates migration distances based solely on\nthe length of the nucleotide sequence.  Secondary or tertiary structure, \ncurvature, and other biophysical attributes of a sequence are currently \nnot considered.  Polypeptide migration is currently not supported.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nEmail allenday@ucla.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Gel;\nuse strict;\n\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $gel = Bio::Tools::Gel->new(-seq => $sequence,-dilate => 3);\n Function: Initializes a new Gel\n Returns : Bio::Tools::Gel\n Args    : -seq      => Bio::Seq(s), scalar(s) or list of either/both \n                        (default: none)\n           -dilate   => Expand band migration distances (default: 1)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($seqs,$dilate) = $self->_rearrange([qw(SEQ DILATE)],\n\t\t\t\t\t  @args);\n  if( ! ref($seqs)  ) {\n      $self->add_band([$seqs]);\n  } elsif( ref($seqs) =~ /array/i ||\n\t   $seqs->isa('Bio::PrimarySeqI') ) {\n      $self->add_band($seqs);\n  } \n  $self->dilate($dilate || 1);\n  \n  return $self;\n}\n\n\n=head2 add_band\n\n Title   : add_band\n Usage   : $gel->add_band($seq);\n Function: Calls _add_band with a (possibly created) Bio::Seq object.\n Returns : \n Args    : Bio::Seq, scalar sequence, or list of either/both.\n\n\nsub add_band {\n  my($self,$args) = @_;\n\n  foreach my $arg (@$args){\n      my $seq;\n      if( ! ref($arg) ) {\n\t  if( $arg =~ /^\\d+/ ) {\n\t      $seq= Bio::PrimarySeq->new(-seq=>\"N\"x$arg, -id => $arg);\n\t  } else {\n\t      $seq= Bio::PrimarySeq->new(-seq=>$arg,-id=>length($arg));\n\t  }\n      } elsif( $arg->isa('Bio::PrimarySeqI') ) {\n\t  $seq = $arg;\n      } \n\n    $seq->validate_seq or $seq->throw(\"invalid symbol in sequence\".$seq->seq().\"\\n\");\n    $self->_add_band($seq);\n  }\n}\n\n=head2 _add_band\n\n Title   : _add_band\n Usage   : $gel->_add_band($seq);\n Function: Adds a new band to the gel.\n Returns : \n Args    : Bio::Seq object","label":"_add_band($self,$arg)"},"line":175,"kind":12,"range":{"start":{"line":175,"character":0},"end":{"line":179,"character":9999}}},{"signature":{"parameters":[{"label":"$self"},{"label":"$arg"}],"documentation":"1;\n# $Id: Gel.pm 16123 2009-09-17 12:57:27Z cjfields $\n# \n# BioPerl module for Bio::Tools::Gel\n# Copyright Allen Day <allenday@ucla.edu>\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Gel - Calculates relative electrophoretic migration distances\n\n=head1 SYNOPSIS\n\n    use Bio::PrimarySeq;\n    use Bio::Restriction::Analysis;\n    use Bio::Tools::Gel;\n\n    # get a sequence\n    my $d = 'AAAAAAAAAGAATTCTTTTTTTTTTTTTTGAATTCGGGGGGGGGGGGGGGGGGGG';\n    my $seq1 = Bio::Seq->new(-id=>'groundhog day',-seq=>$d);\n\n    # cut it with an enzyme\n    my $ra=Bio::Restriction::Analysis->new(-seq=>$seq1);\n    @cuts = $ra->fragments('EcoRI'), 3;\n\n    # analyse the fragments in a gel\n    my $gel = Bio::Tools::Gel->new(-seq=>\\@cuts,-dilate=>10);\n    my %bands = $gel->bands;\n    foreach my $band (sort {$b <=> $a} keys %bands){\n      print $band,\"\\t\", sprintf(\"%.1f\", $bands{$band}),\"\\n\";\n    }\n\n    #prints:\n    #20   27.0\n    #25   26.0\n    #10   30.0\n\n\n=head1 DESCRIPTION\n\nThis takes a set of sequences or Bio::Seq objects, and calculates their\nrespective migration distances using:\n    distance = dilation * (4 - log10(length(dna));\n\nSource: Molecular Cloning, a Laboratory Manual. Sambrook, Fritsch, Maniatis. \nCSHL Press, 1989.\n\nBio::Tools::Gel currently calculates migration distances based solely on\nthe length of the nucleotide sequence.  Secondary or tertiary structure, \ncurvature, and other biophysical attributes of a sequence are currently \nnot considered.  Polypeptide migration is currently not supported.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nEmail allenday@ucla.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Gel;\nuse strict;\n\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $gel = Bio::Tools::Gel->new(-seq => $sequence,-dilate => 3);\n Function: Initializes a new Gel\n Returns : Bio::Tools::Gel\n Args    : -seq      => Bio::Seq(s), scalar(s) or list of either/both \n                        (default: none)\n           -dilate   => Expand band migration distances (default: 1)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($seqs,$dilate) = $self->_rearrange([qw(SEQ DILATE)],\n\t\t\t\t\t  @args);\n  if( ! ref($seqs)  ) {\n      $self->add_band([$seqs]);\n  } elsif( ref($seqs) =~ /array/i ||\n\t   $seqs->isa('Bio::PrimarySeqI') ) {\n      $self->add_band($seqs);\n  } \n  $self->dilate($dilate || 1);\n  \n  return $self;\n}\n\n\n=head2 add_band\n\n Title   : add_band\n Usage   : $gel->add_band($seq);\n Function: Calls _add_band with a (possibly created) Bio::Seq object.\n Returns : \n Args    : Bio::Seq, scalar sequence, or list of either/both.\n\n\nsub add_band {\n  my($self,$args) = @_;\n\n  foreach my $arg (@$args){\n      my $seq;\n      if( ! ref($arg) ) {\n\t  if( $arg =~ /^\\d+/ ) {\n\t      $seq= Bio::PrimarySeq->new(-seq=>\"N\"x$arg, -id => $arg);\n\t  } else {\n\t      $seq= Bio::PrimarySeq->new(-seq=>$arg,-id=>length($arg));\n\t  }\n      } elsif( $arg->isa('Bio::PrimarySeqI') ) {\n\t  $seq = $arg;\n      } \n\n    $seq->validate_seq or $seq->throw(\"invalid symbol in sequence\".$seq->seq().\"\\n\");\n    $self->_add_band($seq);\n  }\n}\n\n=head2 _add_band\n\n Title   : _add_band\n Usage   : $gel->_add_band($seq);\n Function: Adds a new band to the gel.\n Returns : \n Args    : Bio::Seq object\n\n\nsub _add_band {\n  my($self,$arg) = @_;  \n  if( defined $arg) {\n      push (@{$self->{'bands'}},$arg);\n  }\n}\n\n=head2 dilate\n\n Title   : dilate\n Usage   : $gel->dilate(1);\n Function: Sets/retrieves the dilation factor.\n Returns : dilation factor \n Args    : Float or none","label":"dilate($self,$arg)"},"kind":12,"range":{"end":{"character":9999,"line":198},"start":{"line":192,"character":0}},"line":192,"detail":"($self,$arg)","definition":"sub","containerName":"main::","name":"dilate","children":[{"name":"$self","containerName":"dilate","localvar":"my","kind":13,"line":193,"definition":"my"},{"line":193,"name":"$arg","kind":13,"containerName":"dilate"},{"line":194,"name":"$self","containerName":"dilate","kind":13},{"name":"$arg","kind":13,"containerName":"dilate","line":194},{"line":195,"name":"$self","containerName":"dilate","kind":13},{"line":195,"kind":12,"containerName":"dilate","name":"throw"},{"line":195,"containerName":"dilate","kind":13,"name":"$arg"},{"line":195,"containerName":"dilate","kind":13,"name":"$arg"},{"line":196,"kind":13,"containerName":"dilate","name":"$self"},{"line":196,"kind":13,"containerName":"dilate","name":"$arg"},{"containerName":"dilate","kind":13,"name":"$self","line":197}]},{"line":194,"kind":12,"name":"dilate"},{"name":"dilate","kind":12,"line":196},{"line":197,"name":"dilate","kind":12},{"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$arg"}],"label":"migrate($self,$arg)"},"kind":12,"range":{"end":{"line":206,"character":9999},"start":{"character":0,"line":200}},"line":200,"detail":"($self,$arg)","definition":"sub","name":"migrate","containerName":"main::","children":[{"definition":"my","line":201,"name":"$self","containerName":"migrate","localvar":"my","kind":13},{"line":201,"kind":13,"containerName":"migrate","name":"$arg"},{"name":"$arg","kind":13,"containerName":"migrate","line":202},{"line":202,"name":"$self","kind":13,"containerName":"migrate"},{"name":"$arg","containerName":"migrate","kind":13,"line":202},{"name":"$arg","kind":13,"containerName":"migrate","line":203},{"line":204,"containerName":"migrate","kind":13,"name":"$arg"}]},{"line":204,"name":"log10","kind":12},{"name":"bands","containerName":"main::","children":[{"kind":13,"localvar":"my","containerName":"bands","name":"$self","line":219,"definition":"my"},{"line":220,"containerName":"bands","kind":13,"name":"$self"},{"line":220,"name":"throw","containerName":"bands","kind":12},{"line":222,"name":"%bands","localvar":"my","containerName":"bands","kind":13,"definition":"my"},{"definition":"my","line":224,"name":"$band","kind":13,"localvar":"my","containerName":"bands"},{"line":224,"name":"$self","kind":13,"containerName":"bands"}],"definition":"sub","kind":12,"range":{"end":{"character":9999,"line":224},"start":{"line":218,"character":0}},"line":218},{"kind":12,"name":"bands","line":224},{"localvar":"my","containerName":null,"kind":13,"name":"$distance","line":225,"definition":"my"},{"line":225,"name":"$self","kind":13,"containerName":null},{"kind":12,"containerName":"main::","name":"dilate","line":225},{"line":225,"name":"$band","kind":13,"containerName":null},{"line":225,"kind":12,"containerName":"main::","name":"length"},{"line":226,"name":"%bands","kind":13,"containerName":null},{"line":226,"containerName":null,"kind":13,"name":"$band"},{"kind":12,"containerName":"main::","name":"id","line":226},{"name":"$distance","kind":13,"containerName":null,"line":226},{"kind":13,"containerName":null,"name":"%bands","line":229},{"definition":"sub","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"log10","name":"$n","line":244},{"line":245,"kind":13,"containerName":"log10","name":"$n"}],"name":"log10","containerName":"main::","line":243,"range":{"end":{"character":9999,"line":246},"start":{"character":0,"line":243}},"kind":12}],"version":5}