{"version":5,"vars":[{"name":"base","kind":2,"containerName":"","line":97},{"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Est2Genome.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Est2Genome\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Est2Genome - Parse est2genome output, makes simple Bio::SeqFeature::Generic objects\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Est2Genome;\n\n  my $featureiter = Bio::Tools::Est2Genome->new(-file => 'output.est2genome');\n\n  # This is going to be fixed to use the SeqAnalysisI next_feature\n  # Method eventually when we have the objects to put the data in\n  # properly\n  while( my $f = $featureiter->parse_next_gene ) {\n   # process Bio::SeqFeature::Generic objects here\n  }\n\n=head1 DESCRIPTION\n\nThis module is a parser for C<est2genome> [EMBOSS] alignments of est/cdna\nsequence to genomic DNA.  This is generally accepted as the best\nprogram for predicting splice sites based on est/dnas (as far as I know).\n\nThis module currently does not try pull out the ungapped alignments\n(Segment) but may in the future.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Est2Genome;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Root::Root;\nuse Bio::SeqFeature::Gene::Exon;\nuse Bio::SeqFeature::Gene::Transcript;\nuse Bio::SeqFeature::Gene::Intron;\nuse Bio::SeqFeature::Gene::GeneStructure;\nuse Bio::SeqFeature::SimilarityPair;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Est2Genome->new();\n Function: Builds a new Bio::Tools::Est2Genome object\n Returns : an instance of Bio::Tools::Est2Genome\n Args    : -file => 'output.est2genome' or\n           -fh   => \\*EST2GENOMEOUTPUT\n           -genomefirst => 1  # genome was the first input (not standard)","label":"_initialize_state($self,@args)"},"line":111,"range":{"end":{"line":122,"character":9999},"start":{"character":0,"line":111}},"kind":12,"definition":"sub","detail":"($self,@args)","children":[{"line":112,"kind":13,"localvar":"my","containerName":"_initialize_state","name":"$self","definition":"my"},{"name":"@args","kind":13,"containerName":"_initialize_state","line":112},{"containerName":"_initialize_state","localvar":"my","kind":13,"name":"$make","line":115,"definition":"my"},{"containerName":"_initialize_state","kind":13,"name":"$self","line":115},{"kind":13,"containerName":"_initialize_state","name":"@args","line":115},{"definition":"my","line":117,"name":"$genome_is_first","containerName":"_initialize_state","localvar":"my","kind":13},{"line":117,"containerName":"_initialize_state","kind":13,"name":"$self"},{"name":"_rearrange","kind":12,"containerName":"_initialize_state","line":117},{"line":117,"kind":13,"containerName":"_initialize_state","name":"@args"},{"line":119,"containerName":"_initialize_state","kind":13,"name":"$self"},{"line":120,"kind":13,"containerName":"_initialize_state","name":"$self"},{"name":"$genome_is_first","containerName":"_initialize_state","kind":13,"line":120},{"line":120,"kind":13,"containerName":"_initialize_state","name":"$genome_is_first"},{"kind":13,"containerName":"_initialize_state","name":"$self","line":121},{"kind":12,"containerName":"_initialize_state","name":"analysis_method","line":121}],"containerName":"main::","name":"_initialize_state"},{"containerName":"_initialize_state","kind":12,"name":"SUPER","line":115},{"definition":"sub","detail":"($self,$method)","children":[{"line":137,"name":"$self","localvar":"my","kind":13,"containerName":"analysis_method","definition":"my"},{"containerName":"analysis_method","kind":13,"name":"$method","line":137},{"kind":13,"containerName":"analysis_method","name":"$method","line":138},{"line":138,"kind":13,"containerName":"analysis_method","name":"$method"},{"kind":13,"containerName":"analysis_method","name":"$self","line":139},{"line":139,"containerName":"analysis_method","kind":12,"name":"throw"},{"line":139,"kind":13,"containerName":"analysis_method","name":"$self"},{"line":141,"kind":13,"containerName":"analysis_method","name":"$self"},{"line":141,"kind":13,"containerName":"analysis_method","name":"$method"}],"containerName":"main::","name":"analysis_method","signature":{"documentation":"1;\n# $Id: Est2Genome.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Est2Genome\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Est2Genome - Parse est2genome output, makes simple Bio::SeqFeature::Generic objects\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Est2Genome;\n\n  my $featureiter = Bio::Tools::Est2Genome->new(-file => 'output.est2genome');\n\n  # This is going to be fixed to use the SeqAnalysisI next_feature\n  # Method eventually when we have the objects to put the data in\n  # properly\n  while( my $f = $featureiter->parse_next_gene ) {\n   # process Bio::SeqFeature::Generic objects here\n  }\n\n=head1 DESCRIPTION\n\nThis module is a parser for C<est2genome> [EMBOSS] alignments of est/cdna\nsequence to genomic DNA.  This is generally accepted as the best\nprogram for predicting splice sites based on est/dnas (as far as I know).\n\nThis module currently does not try pull out the ungapped alignments\n(Segment) but may in the future.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Est2Genome;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Root::Root;\nuse Bio::SeqFeature::Gene::Exon;\nuse Bio::SeqFeature::Gene::Transcript;\nuse Bio::SeqFeature::Gene::Intron;\nuse Bio::SeqFeature::Gene::GeneStructure;\nuse Bio::SeqFeature::SimilarityPair;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Est2Genome->new();\n Function: Builds a new Bio::Tools::Est2Genome object\n Returns : an instance of Bio::Tools::Est2Genome\n Args    : -file => 'output.est2genome' or\n           -fh   => \\*EST2GENOMEOUTPUT\n           -genomefirst => 1  # genome was the first input (not standard)\n\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # call the inherited method first\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    my ($genome_is_first) = $self->_rearrange([qw(GENOMEFIRST)], @args);\n\n    delete($self->{'_genome_is_first'});\n    $self->{'_genome_is_first'} = $genome_is_first if(defined($genome_is_first));\n    $self->analysis_method(\"est2genome\");\n}\n\n=head2 analysis_method\n\n Usage     : $sim4->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /est2genome/i.\n Returns   : String\n Argument  : n/a","parameters":[{"label":"$self"},{"label":"$method"}],"label":"analysis_method($self,$method)"},"line":135,"range":{"start":{"character":0,"line":135},"end":{"character":9999,"line":142}},"kind":12},{"containerName":"analysis_method","kind":12,"name":"SUPER","line":141},{"name":"parse_next_gene","containerName":"main::","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"parse_next_gene","name":"$self","line":171},{"line":171,"kind":13,"containerName":"parse_next_gene","name":"$return_gene"},{"name":"$self","containerName":"parse_next_gene","kind":13,"line":172},{"line":172,"kind":12,"containerName":"parse_next_gene","name":"_parse_gene_struct"},{"kind":13,"containerName":"parse_next_gene","name":"$return_gene","line":172},{"kind":13,"localvar":"my","containerName":"parse_next_gene","name":"$seensegment","line":173,"definition":"my"},{"kind":13,"localvar":"my","containerName":"parse_next_gene","name":"@features","line":174,"definition":"my"},{"definition":"my","line":175,"name":"$qstrand","kind":13,"localvar":"my","containerName":"parse_next_gene"},{"name":"$hstrand","containerName":"parse_next_gene","kind":13,"line":175},{"definition":"my","line":176,"localvar":"my","kind":13,"containerName":"parse_next_gene","name":"$lasthseqname"},{"kind":13,"containerName":"parse_next_gene","name":"$self","line":177},{"line":177,"name":"_readline","kind":12,"containerName":"parse_next_gene"},{"line":179,"name":"$seensegment","kind":13,"containerName":"parse_next_gene"},{"line":180,"name":"$self","containerName":"parse_next_gene","kind":13},{"line":180,"containerName":"parse_next_gene","kind":12,"name":"_pushback"},{"line":181,"kind":13,"containerName":"parse_next_gene","name":"@features"},{"line":181,"name":"@features","kind":13,"containerName":"parse_next_gene"},{"line":183,"kind":13,"containerName":"parse_next_gene","name":"$hstrand"},{"kind":13,"containerName":"parse_next_gene","name":"$qstrand","line":184},{"definition":"my","name":"$name","localvar":"my","containerName":"parse_next_gene","kind":13,"line":188},{"line":188,"name":"$len","containerName":"parse_next_gene","kind":13},{"kind":13,"containerName":"parse_next_gene","name":"$score","line":188},{"name":"$qstart","containerName":"parse_next_gene","kind":13,"line":188},{"line":188,"containerName":"parse_next_gene","kind":13,"name":"$qend"},{"name":"$qseqname","kind":13,"containerName":"parse_next_gene","line":188},{"line":189,"containerName":"parse_next_gene","kind":13,"name":"$hstart"},{"kind":13,"containerName":"parse_next_gene","name":"$hend","line":189},{"name":"$hseqname","kind":13,"containerName":"parse_next_gene","line":189},{"line":190,"name":"$lasthseqname","containerName":"parse_next_gene","kind":13},{"name":"$hseqname","containerName":"parse_next_gene","kind":13,"line":190},{"definition":"my","kind":13,"localvar":"my","containerName":"parse_next_gene","name":"$query","line":191},{"name":"new","containerName":"parse_next_gene","kind":12,"line":191},{"name":"$name","kind":13,"containerName":"parse_next_gene","line":191},{"containerName":"parse_next_gene","kind":13,"name":"$self","line":192},{"name":"analysis_method","containerName":"parse_next_gene","kind":12,"line":192},{"line":193,"name":"$qseqname","kind":13,"containerName":"parse_next_gene"},{"line":194,"name":"$qstart","kind":13,"containerName":"parse_next_gene"},{"line":195,"name":"$qend","containerName":"parse_next_gene","kind":13},{"line":196,"name":"$qstrand","containerName":"parse_next_gene","kind":13},{"line":197,"kind":13,"containerName":"parse_next_gene","name":"$score"},{"line":203,"name":"$hit","localvar":"my","containerName":"parse_next_gene","kind":13,"definition":"my"},{"line":203,"name":"new","containerName":"parse_next_gene","kind":12},{"line":204,"name":"$self","kind":13,"containerName":"parse_next_gene"},{"name":"analysis_method","kind":12,"containerName":"parse_next_gene","line":204},{"kind":13,"containerName":"parse_next_gene","name":"$hseqname","line":205},{"name":"$hstart","containerName":"parse_next_gene","kind":13,"line":206},{"line":207,"kind":13,"containerName":"parse_next_gene","name":"$hend"},{"line":208,"name":"$hstrand","kind":13,"containerName":"parse_next_gene"},{"kind":13,"containerName":"parse_next_gene","name":"$score","line":209},{"line":216,"kind":13,"containerName":"parse_next_gene","name":"@features"},{"line":217,"name":"new","containerName":"parse_next_gene","kind":12},{"kind":13,"containerName":"parse_next_gene","name":"$query","line":217},{"name":"$hit","kind":13,"containerName":"parse_next_gene","line":218},{"line":219,"kind":13,"containerName":"parse_next_gene","name":"$self"},{"line":219,"kind":12,"containerName":"parse_next_gene","name":"analysis_method"},{"definition":"my","line":221,"localvar":"my","containerName":"parse_next_gene","kind":13,"name":"$name"},{"kind":13,"containerName":"parse_next_gene","name":"$len","line":221},{"line":221,"name":"$score","kind":13,"containerName":"parse_next_gene"},{"name":"$qstart","kind":13,"containerName":"parse_next_gene","line":221},{"name":"$qend","kind":13,"containerName":"parse_next_gene","line":221},{"line":221,"name":"$qseqname","kind":13,"containerName":"parse_next_gene"},{"line":222,"name":"@features","kind":13,"containerName":"parse_next_gene"},{"line":222,"kind":12,"containerName":"parse_next_gene","name":"new"},{"containerName":"parse_next_gene","kind":13,"name":"$self","line":223},{"name":"analysis_method","kind":12,"containerName":"parse_next_gene","line":223},{"line":224,"name":"$qstart","containerName":"parse_next_gene","kind":13},{"line":225,"name":"$qend","kind":13,"containerName":"parse_next_gene"},{"kind":13,"containerName":"parse_next_gene","name":"$qstrand","line":226},{"kind":13,"containerName":"parse_next_gene","name":"$score","line":227},{"line":228,"name":"$qseqname","containerName":"parse_next_gene","kind":13},{"line":230,"name":"$lasthseqname","containerName":"parse_next_gene","kind":13},{"line":233,"name":"$seensegment","kind":13,"containerName":"parse_next_gene"},{"name":"$self","kind":13,"containerName":"parse_next_gene","line":236},{"name":"warn","kind":12,"containerName":"parse_next_gene","line":236},{"line":239,"kind":13,"containerName":"parse_next_gene","name":"@features"},{"line":240,"containerName":"parse_next_gene","kind":13,"name":"@features"},{"line":240,"containerName":"parse_next_gene","kind":13,"name":"@features"}],"detail":"($self,$return_gene)","definition":"sub","range":{"start":{"character":0,"line":170},"end":{"character":9999,"line":241}},"kind":12,"line":170,"signature":{"label":"parse_next_gene($self,$return_gene)","parameters":[{"label":"$self"},{"label":"$return_gene"}],"documentation":"1;\n# $Id: Est2Genome.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Est2Genome\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Est2Genome - Parse est2genome output, makes simple Bio::SeqFeature::Generic objects\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Est2Genome;\n\n  my $featureiter = Bio::Tools::Est2Genome->new(-file => 'output.est2genome');\n\n  # This is going to be fixed to use the SeqAnalysisI next_feature\n  # Method eventually when we have the objects to put the data in\n  # properly\n  while( my $f = $featureiter->parse_next_gene ) {\n   # process Bio::SeqFeature::Generic objects here\n  }\n\n=head1 DESCRIPTION\n\nThis module is a parser for C<est2genome> [EMBOSS] alignments of est/cdna\nsequence to genomic DNA.  This is generally accepted as the best\nprogram for predicting splice sites based on est/dnas (as far as I know).\n\nThis module currently does not try pull out the ungapped alignments\n(Segment) but may in the future.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Est2Genome;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Root::Root;\nuse Bio::SeqFeature::Gene::Exon;\nuse Bio::SeqFeature::Gene::Transcript;\nuse Bio::SeqFeature::Gene::Intron;\nuse Bio::SeqFeature::Gene::GeneStructure;\nuse Bio::SeqFeature::SimilarityPair;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Est2Genome->new();\n Function: Builds a new Bio::Tools::Est2Genome object\n Returns : an instance of Bio::Tools::Est2Genome\n Args    : -file => 'output.est2genome' or\n           -fh   => \\*EST2GENOMEOUTPUT\n           -genomefirst => 1  # genome was the first input (not standard)\n\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # call the inherited method first\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    my ($genome_is_first) = $self->_rearrange([qw(GENOMEFIRST)], @args);\n\n    delete($self->{'_genome_is_first'});\n    $self->{'_genome_is_first'} = $genome_is_first if(defined($genome_is_first));\n    $self->analysis_method(\"est2genome\");\n}\n\n=head2 analysis_method\n\n Usage     : $sim4->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /est2genome/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method {\n#-------------\n    my ($self, $method) = @_;\n    if($method && ($method !~ /est2genome/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 parse_next_gene\n\n Title   : parse_next_gene\n Usage   : @gene = $est2genome_result->parse_next_gene;\n           foreach $exon (@exons) {\n               # do something\n           }\n\n Function: Parses the next alignments of the est2genome result file and\n           returns the found exons as an array of\n           Bio::SeqFeature::SimilarityPair objects. Call\n           this method repeatedly until an empty array is returned to get the\n           results for all alignments.\n\n           The $exon->seq_id() attribute will be set to the identifier of the\n           respective sequence for both sequences.\n           The length is accessible via the seqlength()\n           attribute of $exon->query() and\n           $exon->est_hit().\n Returns : An array (or array reference) of Bio::SeqFeature::SimilarityPair and Bio::SeqFeature::Generic objects\n           or Bio::SeqFeature::Gene::GeneStructure\n Args    : flag(1/0) indicating to return Bio::SeqFeature::Gene::GeneStructure or Bio::SeqFeature::SimilarityPair\n           defaults to 0"}},{"line":191,"containerName":"SeqFeature::Similarity","kind":12,"name":"Bio"},{"kind":12,"containerName":"SeqFeature::Similarity","name":"Bio","line":203},{"line":216,"name":"Bio","kind":12,"containerName":"SeqFeature::SimilarityPair"},{"kind":12,"containerName":"SeqFeature::Generic","name":"Bio","line":222},{"range":{"end":{"line":334,"character":9999},"start":{"line":243,"character":0}},"kind":12,"line":243,"signature":{"label":"_parse_gene_struct($self)","documentation":"","parameters":[{"label":"$self"}]},"name":"_parse_gene_struct","containerName":"main::","children":[{"line":244,"localvar":"my","containerName":"_parse_gene_struct","kind":13,"name":"$self","definition":"my"},{"line":245,"name":"$seensegment","localvar":"my","containerName":"_parse_gene_struct","kind":13,"definition":"my"},{"line":246,"name":"@features","kind":13,"localvar":"my","containerName":"_parse_gene_struct","definition":"my"},{"line":247,"name":"$qstrand","localvar":"my","containerName":"_parse_gene_struct","kind":13,"definition":"my"},{"line":247,"kind":13,"containerName":"_parse_gene_struct","name":"$hstrand"},{"name":"$lasthseqname","localvar":"my","containerName":"_parse_gene_struct","kind":13,"line":248,"definition":"my"},{"definition":"my","name":"$gene","kind":13,"localvar":"my","containerName":"_parse_gene_struct","line":249},{"line":249,"containerName":"_parse_gene_struct","kind":12,"name":"new"},{"line":249,"name":"$self","kind":13,"containerName":"_parse_gene_struct"},{"line":249,"containerName":"_parse_gene_struct","kind":12,"name":"analysis_method"},{"definition":"my","line":250,"name":"$transcript","containerName":"_parse_gene_struct","localvar":"my","kind":13},{"name":"new","kind":12,"containerName":"_parse_gene_struct","line":250},{"kind":13,"containerName":"_parse_gene_struct","name":"$self","line":250},{"kind":12,"containerName":"_parse_gene_struct","name":"analysis_method","line":250},{"containerName":"_parse_gene_struct","localvar":"my","kind":13,"name":"@suppf","line":251,"definition":"my"},{"definition":"my","line":252,"name":"@exon","kind":13,"localvar":"my","containerName":"_parse_gene_struct"},{"name":"$self","kind":13,"containerName":"_parse_gene_struct","line":253},{"kind":12,"containerName":"_parse_gene_struct","name":"_readline","line":253},{"kind":13,"containerName":"_parse_gene_struct","name":"$seensegment","line":255},{"containerName":"_parse_gene_struct","kind":13,"name":"$self","line":256},{"name":"_pushback","kind":12,"containerName":"_parse_gene_struct","line":256},{"line":257,"containerName":"_parse_gene_struct","kind":13,"name":"$gene"},{"name":"$hstrand","kind":13,"containerName":"_parse_gene_struct","line":259},{"line":260,"name":"$qstrand","kind":13,"containerName":"_parse_gene_struct"},{"definition":"my","localvar":"my","kind":13,"containerName":"_parse_gene_struct","name":"$name","line":263},{"line":263,"kind":13,"containerName":"_parse_gene_struct","name":"$len"},{"line":263,"containerName":"_parse_gene_struct","kind":13,"name":"$score"},{"name":"$qstart","kind":13,"containerName":"_parse_gene_struct","line":263},{"name":"$qend","kind":13,"containerName":"_parse_gene_struct","line":263},{"line":263,"kind":13,"containerName":"_parse_gene_struct","name":"$qseqname"},{"name":"$hstart","containerName":"_parse_gene_struct","kind":13,"line":263},{"name":"$hend","kind":13,"containerName":"_parse_gene_struct","line":263},{"kind":13,"containerName":"_parse_gene_struct","name":"$hseqname","line":263},{"line":264,"name":"$lasthseqname","kind":13,"containerName":"_parse_gene_struct"},{"name":"$hseqname","kind":13,"containerName":"_parse_gene_struct","line":264},{"localvar":"my","kind":13,"containerName":"_parse_gene_struct","name":"$exon","line":265,"definition":"my"},{"name":"new","containerName":"_parse_gene_struct","kind":12,"line":265},{"name":"$name","kind":13,"containerName":"_parse_gene_struct","line":265},{"name":"$self","containerName":"_parse_gene_struct","kind":13,"line":266},{"line":266,"name":"analysis_method","kind":12,"containerName":"_parse_gene_struct"},{"containerName":"_parse_gene_struct","kind":13,"name":"$qseqname","line":267},{"line":268,"name":"$qstart","kind":13,"containerName":"_parse_gene_struct"},{"line":269,"containerName":"_parse_gene_struct","kind":13,"name":"$qend"},{"name":"$qstrand","containerName":"_parse_gene_struct","kind":13,"line":270},{"name":"$score","kind":13,"containerName":"_parse_gene_struct","line":271},{"line":277,"name":"$transcript","kind":13,"containerName":"_parse_gene_struct"},{"line":277,"containerName":"_parse_gene_struct","kind":12,"name":"seq_id"},{"name":"$qseqname","kind":13,"containerName":"_parse_gene_struct","line":277},{"line":277,"name":"$transcript","containerName":"_parse_gene_struct","kind":13},{"line":277,"kind":12,"containerName":"_parse_gene_struct","name":"seq_id"},{"line":278,"name":"$exon","kind":13,"containerName":"_parse_gene_struct"},{"kind":12,"containerName":"_parse_gene_struct","name":"add_tag_value","line":278},{"line":279,"containerName":"_parse_gene_struct","kind":13,"name":"@exon"},{"containerName":"_parse_gene_struct","kind":13,"name":"$exon","line":279},{"line":285,"kind":13,"localvar":"my","containerName":"_parse_gene_struct","name":"$name","definition":"my"},{"name":"$len","containerName":"_parse_gene_struct","kind":13,"line":285},{"name":"$score","containerName":"_parse_gene_struct","kind":13,"line":285},{"line":285,"kind":13,"containerName":"_parse_gene_struct","name":"$qstart"},{"containerName":"_parse_gene_struct","kind":13,"name":"$qend","line":285},{"containerName":"_parse_gene_struct","kind":13,"name":"$qseqname","line":285},{"kind":13,"containerName":"_parse_gene_struct","name":"$hstart","line":285},{"kind":13,"containerName":"_parse_gene_struct","name":"$hend","line":285},{"name":"$hseqname","containerName":"_parse_gene_struct","kind":13,"line":285},{"definition":"my","line":286,"name":"$query","containerName":"_parse_gene_struct","localvar":"my","kind":13},{"containerName":"_parse_gene_struct","kind":12,"name":"new","line":286},{"kind":13,"containerName":"_parse_gene_struct","name":"$name","line":286},{"line":287,"containerName":"_parse_gene_struct","kind":13,"name":"$self"},{"name":"analysis_method","kind":12,"containerName":"_parse_gene_struct","line":287},{"line":288,"name":"$qseqname","kind":13,"containerName":"_parse_gene_struct"},{"kind":13,"containerName":"_parse_gene_struct","name":"$qstart","line":289},{"line":290,"containerName":"_parse_gene_struct","kind":13,"name":"$qend"},{"line":291,"kind":13,"containerName":"_parse_gene_struct","name":"$qstrand"},{"line":292,"name":"$score","kind":13,"containerName":"_parse_gene_struct"},{"name":"$hit","kind":13,"localvar":"my","containerName":"_parse_gene_struct","line":298,"definition":"my"},{"kind":12,"containerName":"_parse_gene_struct","name":"new","line":298},{"name":"$self","containerName":"_parse_gene_struct","kind":13,"line":299},{"name":"analysis_method","kind":12,"containerName":"_parse_gene_struct","line":299},{"name":"$hseqname","containerName":"_parse_gene_struct","kind":13,"line":300},{"kind":13,"containerName":"_parse_gene_struct","name":"$hstart","line":301},{"name":"$hend","kind":13,"containerName":"_parse_gene_struct","line":302},{"line":303,"kind":13,"containerName":"_parse_gene_struct","name":"$hstrand"},{"containerName":"_parse_gene_struct","kind":13,"name":"$score","line":304},{"localvar":"my","kind":13,"containerName":"_parse_gene_struct","name":"$support","line":310,"definition":"my"},{"line":310,"kind":12,"containerName":"_parse_gene_struct","name":"new"},{"name":"$query","kind":13,"containerName":"_parse_gene_struct","line":310},{"line":311,"name":"$hit","containerName":"_parse_gene_struct","kind":13},{"kind":13,"containerName":"_parse_gene_struct","name":"$self","line":312},{"line":312,"kind":12,"containerName":"_parse_gene_struct","name":"analysis_method"},{"line":313,"name":"@suppf","kind":13,"containerName":"_parse_gene_struct"},{"kind":13,"containerName":"_parse_gene_struct","name":"$support","line":313},{"kind":13,"containerName":"_parse_gene_struct","name":"$self","line":316},{"containerName":"_parse_gene_struct","kind":12,"name":"warn","line":316},{"definition":"my","localvar":"my","kind":13,"containerName":"_parse_gene_struct","name":"$e","line":320},{"kind":13,"containerName":"_parse_gene_struct","name":"@exon","line":320},{"line":321,"containerName":"_parse_gene_struct","localvar":"my","kind":13,"name":"@add","definition":"my"},{"name":"$sf","containerName":"_parse_gene_struct","localvar":"my","kind":13,"line":322,"definition":"my"},{"line":322,"name":"@suppf","containerName":"_parse_gene_struct","kind":13},{"line":323,"containerName":"_parse_gene_struct","kind":13,"name":"$sf"},{"line":323,"kind":12,"containerName":"_parse_gene_struct","name":"overlaps"},{"kind":13,"containerName":"_parse_gene_struct","name":"$e","line":323},{"line":324,"name":"@add","containerName":"_parse_gene_struct","kind":13},{"name":"$sf","kind":13,"containerName":"_parse_gene_struct","line":324},{"containerName":"_parse_gene_struct","kind":13,"name":"$e","line":327},{"line":327,"name":"add_tag_value","kind":12,"containerName":"_parse_gene_struct"},{"line":327,"kind":13,"containerName":"_parse_gene_struct","name":"@add"},{"line":328,"name":"$transcript","kind":13,"containerName":"_parse_gene_struct"},{"containerName":"_parse_gene_struct","kind":12,"name":"add_exon","line":328},{"containerName":"_parse_gene_struct","kind":13,"name":"$e","line":328},{"name":"$gene","kind":13,"containerName":"_parse_gene_struct","line":331},{"kind":12,"containerName":"_parse_gene_struct","name":"add_transcript","line":331},{"containerName":"_parse_gene_struct","kind":13,"name":"$transcript","line":331},{"name":"$gene","containerName":"_parse_gene_struct","kind":13,"line":332},{"kind":12,"containerName":"_parse_gene_struct","name":"seq_id","line":332},{"containerName":"_parse_gene_struct","kind":13,"name":"$transcript","line":332},{"containerName":"_parse_gene_struct","kind":12,"name":"seq_id","line":332},{"kind":13,"containerName":"_parse_gene_struct","name":"$gene","line":333}],"detail":"($self)","definition":"sub"},{"line":249,"name":"Bio","containerName":"SeqFeature::Gene::GeneStructure","kind":12},{"line":250,"name":"Bio","containerName":"SeqFeature::Gene::Transcript","kind":12},{"kind":12,"containerName":"SeqFeature::Gene::Exon","name":"Bio","line":265},{"line":286,"containerName":"SeqFeature::Similarity","kind":12,"name":"Bio"},{"name":"Bio","kind":12,"containerName":"SeqFeature::Similarity","line":298},{"line":310,"name":"Bio","kind":12,"containerName":"SeqFeature::SimilarityPair"},{"line":319,"kind":12,"name":"exon"},{"line":349,"kind":12,"range":{"end":{"character":9999,"line":352},"start":{"character":0,"line":349}},"children":[{"line":350,"name":"$self","containerName":"next_feature","localvar":"my","kind":13,"definition":"my"},{"name":"$self","containerName":"next_feature","kind":13,"line":351},{"line":351,"containerName":"next_feature","kind":12,"name":"throw"}],"name":"next_feature","containerName":"main::","definition":"sub"}]}