{"vars":[{"line":79,"name":"base","containerName":"","kind":2},{"kind":12,"range":{"start":{"line":93,"character":0},"end":{"character":9999,"line":101}},"line":93,"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: DocSum.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::EUtilities::Summary::DocSum\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n# \n# Part of the EUtilities BioPerl package\n\n=head1 NAME\n\nBio::Tools::EUtilities::Summary::DocSum - data object for document summary data\nfrom esummary\n\n=head1 SYNOPSIS\n\n    ****MISSING SECTION****\n\n=head1 DESCRIPTION\n\n    ****MISSING SECTION****\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the\nevolution of this and other Bioperl modules. Send\nyour comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation\nis much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to\nhelp us keep track the bugs and their resolution.\nBug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chris Fields\n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the\nobject methods. Internal methods are usually\npreceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::EUtilities::Summary::DocSum;\n\nuse strict;\nuse warnings;\nuse base qw(Bio::Root::Root Bio::Tools::EUtilities::Summary::ItemContainerI);\n\nuse Bio::Tools::EUtilities::Summary::Item;\n\n=head2 new\n\n Title    : new\n Usage    : \n Function : \n Returns  : \n Args     : ","label":"new($class,@args)"},"containerName":"main::","name":"new","children":[{"definition":"my","line":94,"name":"$class","kind":13,"localvar":"my","containerName":"new"},{"line":94,"containerName":"new","kind":13,"name":"@args"},{"definition":"my","line":95,"name":"$self","localvar":"my","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$class","line":95},{"line":95,"kind":13,"containerName":"new","name":"@args"},{"line":96,"localvar":"my","containerName":"new","kind":13,"name":"$type","definition":"my"},{"line":96,"name":"$self","containerName":"new","kind":13},{"line":96,"kind":12,"containerName":"new","name":"_rearrange"},{"line":96,"name":"@args","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$type","line":97},{"name":"$self","kind":13,"containerName":"new","line":98},{"line":98,"containerName":"new","kind":12,"name":"eutil"},{"line":99,"name":"$self","kind":13,"containerName":"new"},{"line":99,"kind":12,"containerName":"new","name":"datatype"},{"name":"$type","kind":13,"containerName":"new","line":99},{"line":100,"name":"$self","containerName":"new","kind":13}],"detail":"($class,@args)","definition":"sub"},{"line":94,"name":"Item","containerName":"Bio::Tools::EUtilities::Summary","kind":2},{"kind":12,"containerName":"new","name":"SUPER","line":95},{"range":{"end":{"character":9999,"line":119},"start":{"character":0,"line":116}},"kind":12,"line":116,"containerName":"main::","name":"get_ids","children":[{"definition":"my","line":117,"name":"$self","localvar":"my","kind":13,"containerName":"get_ids"},{"line":118,"name":"$self","containerName":"get_ids","kind":13},{"line":118,"containerName":"get_ids","kind":13,"name":"$self"}],"definition":"sub"},{"definition":"sub","containerName":"main::","name":"get_id","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"get_id","line":132},{"kind":13,"containerName":"get_id","name":"$self","line":133}],"kind":12,"range":{"start":{"character":0,"line":131},"end":{"character":9999,"line":134}},"line":131},{"line":238,"kind":12,"range":{"start":{"line":238,"character":0},"end":{"line":244,"character":9999}},"signature":{"parameters":[{"label":"$self"},{"label":"$request"}],"documentation":"1;\n# $Id: DocSum.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::EUtilities::Summary::DocSum\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n# \n# Part of the EUtilities BioPerl package\n\n=head1 NAME\n\nBio::Tools::EUtilities::Summary::DocSum - data object for document summary data\nfrom esummary\n\n=head1 SYNOPSIS\n\n    ****MISSING SECTION****\n\n=head1 DESCRIPTION\n\n    ****MISSING SECTION****\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the\nevolution of this and other Bioperl modules. Send\nyour comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation\nis much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to\nhelp us keep track the bugs and their resolution.\nBug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chris Fields\n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the\nobject methods. Internal methods are usually\npreceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::EUtilities::Summary::DocSum;\n\nuse strict;\nuse warnings;\nuse base qw(Bio::Root::Root Bio::Tools::EUtilities::Summary::ItemContainerI);\n\nuse Bio::Tools::EUtilities::Summary::Item;\n\n=head2 new\n\n Title    : new\n Usage    : \n Function : \n Returns  : \n Args     : \n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($type) = $self->_rearrange(['DATATYPE'],@args);\n    $type ||= 'docsum';\n    $self->eutil('esummary');\n    $self->datatype($type);\n    return $self;\n}\n\n=head2 get_ids\n\n Title    : get_ids\n Usage    : my ($id) = $item->get_ids;\n Function : returns array or array ref with id\n Returns  : array or array ref\n Args     : none\n Note     : the behavior of this method remains consistent with other\n            implementations of get_ids(). To retrieve the single DocSum ID\n            use get_id()\n\n\nsub get_ids {\n    my $self = shift;\n    return wantarray ? $self->{'_id'} : [$self->{'_id'}];\n}\n\n=head2 get_id\n\n Title    : get_id\n Usage    : my ($id) = $item->get_id;\n Function : returns UID of record\n Returns  : integer\n Args     : none\n\n\nsub get_id {\n    my $self = shift;\n    return $self->{'_id'};\n}\n\n=head1 ItemContainerI methods\n\n\n=head2 next_Item\n\n Title    : next_Item\n Usage    : while (my $item = $docsum->next_Item) {...}\n Function : iterates through Items (nested layer of Item)\n Returns  : single Item\n Args     : [optional] single arg (string)\n            'flatten' - iterates through a flattened list ala\n                          get_all_DocSum_Items()\n\n\n=head2 get_Items\n\n Title    : get_Items\n Usage    : my @items = $docsum->get_Items\n Function : returns list of, well, Items\n Returns  : array of Items\n Args     : none\n\n\n=head2 get_all_Items\n\n Title    : get_all_Items\n Usage    : my @items = $docsum->get_all_Items\n Function : returns flattened list of all Item objects (Items, ListItems,\n            StructureItems)\n Returns  : array of Items\n Args     : none\n Note     : items are added top-down (similar order to using nested calls)\n            in original list order.\n\n             1         2        7        8\n           Item  -   Item  -  Item  -  Item ...\n                     |\n                    | 3        6\n                 ListItem - ListItem\n                   |\n                  | 4          5\n               Structure - Structure\n\n\n=head2 get_all_names\n\n Title    : get_all_names\n Usage    : my @names = get_all_names()\n Function : Returns an array of names for all Item(s) in DocSum.\n Returns  : array of unique strings\n Args     : none\n\n\n=head2 get_Items_by_name\n\n Title    : get_Items_by_name\n Usage    : my @items = get_Items_by_name('CreateDate')\n Function : Returns named Item(s) in DocSum (indicated by passed argument)\n Returns  : array of Item objects\n Args     : string (Item name)\n\n\n=head2 get_contents_by_name\n\n Title    : get_contents_by_name\n Usage    : my ($data) = get_contents_by_name('CreateDate')\n Function : Returns content for named Item(s) in DocSum (indicated by\n            passed argument)\n Returns  : array of values (type varies per Item)\n Args     : string (Item name)\n\n\n=head2 get_type_by_name\n\n Title    : get_type_by_name\n Usage    : my $data = get_type_by_name('CreateDate')\n Function : Returns data type for named Item in DocSum (indicated by\n            passed argument)\n Returns  : scalar value (string) if present\n Args     : string (Item name)\n\n\n=head2 rewind\n\n Title    : rewind\n Usage    : $docsum->rewind();\n Function : rewinds DocSum iterator\n Returns  : none\n Args     : [optional]\n           'recursive' - rewind all DocSum object layers\n                         (Items, ListItems, StructureItems)","label":"rewind($self,$request)"},"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"rewind","line":239,"definition":"my"},{"line":239,"containerName":"rewind","kind":13,"name":"$request"},{"line":240,"name":"$request","containerName":"rewind","kind":13},{"line":240,"name":"$request","kind":13,"containerName":"rewind"},{"line":241,"name":"rewind","kind":12,"containerName":"rewind"},{"line":241,"name":"$self","kind":13,"containerName":"rewind"},{"kind":12,"containerName":"rewind","name":"get_Items","line":241},{"name":"$self","kind":13,"containerName":"rewind","line":243}],"name":"rewind","containerName":"main::","definition":"sub","detail":"($self,$request)"},{"range":{"end":{"line":259,"character":9999},"start":{"character":0,"line":248}},"kind":12,"line":248,"signature":{"parameters":[{"label":"$self"},{"label":"$data"}],"documentation":" private EUtilDataI method","label":"_add_data($self,$data)"},"containerName":"main::","name":"_add_data","children":[{"definition":"my","line":249,"name":"$self","localvar":"my","kind":13,"containerName":"_add_data"},{"name":"$data","kind":13,"containerName":"_add_data","line":249},{"kind":13,"containerName":"_add_data","name":"$data","line":250},{"containerName":"_add_data","kind":13,"name":"$self","line":251},{"kind":13,"containerName":"_add_data","name":"$data","line":251},{"line":251,"containerName":"_add_data","kind":13,"name":"$data"},{"localvar":"my","containerName":"_add_data","kind":13,"name":"$sd","line":252,"definition":"my"},{"line":252,"name":"$data","kind":13,"containerName":"_add_data"},{"line":253,"name":"$sd","kind":13,"containerName":"_add_data"},{"containerName":"_add_data","kind":13,"name":"$data","line":253},{"line":253,"containerName":"_add_data","kind":13,"name":"$data"},{"name":"$subdoc","localvar":"my","kind":13,"containerName":"_add_data","line":254,"definition":"my"},{"line":255,"containerName":"_add_data","kind":12,"name":"new"},{"kind":13,"containerName":"_add_data","name":"$self","line":256},{"containerName":"_add_data","kind":12,"name":"verbose","line":256},{"line":257,"name":"$subdoc","containerName":"_add_data","kind":13},{"kind":12,"containerName":"_add_data","name":"_add_data","line":257},{"line":257,"containerName":"_add_data","kind":13,"name":"$sd"},{"line":258,"containerName":"_add_data","kind":13,"name":"$self"},{"containerName":"_add_data","kind":13,"name":"$subdoc","line":258}],"detail":"($self,$data)","definition":"sub"},{"name":"Item","kind":12,"line":250},{"line":251,"name":"Id","kind":12},{"name":"Id","kind":12,"line":251},{"line":252,"name":"Item","kind":12},{"line":253,"kind":12,"name":"Id"},{"kind":12,"name":"Id","line":253},{"kind":12,"name":"Id","line":253},{"name":"Bio","containerName":"Tools::EUtilities::Summary::Item","kind":12,"line":255},{"containerName":null,"kind":13,"name":"%self","line":261},{"name":"%data","kind":13,"containerName":null,"line":261},{"line":261,"name":"Id","kind":12},{"line":261,"name":"%data","kind":13,"containerName":null},{"name":"Id","kind":12,"line":261},{"children":[{"line":276,"containerName":"to_string","localvar":"my","kind":13,"name":"$self","definition":"my"},{"definition":"my","name":"$string","localvar":"my","containerName":"to_string","kind":13,"line":277},{"name":"$self","kind":13,"containerName":"to_string","line":277},{"name":"get_id","kind":12,"containerName":"to_string","line":277},{"definition":"my","name":"$item","containerName":"to_string","localvar":"my","kind":13,"line":278},{"line":278,"name":"$self","containerName":"to_string","kind":13},{"name":"next_Item","kind":12,"containerName":"to_string","line":278},{"line":279,"kind":13,"containerName":"to_string","name":"$string"},{"kind":13,"containerName":"to_string","name":"$item","line":279},{"containerName":"to_string","kind":12,"name":"to_string","line":279},{"containerName":"to_string","kind":13,"name":"$string","line":281}],"name":"to_string","containerName":"main::","definition":"sub","line":275,"kind":12,"range":{"start":{"character":0,"line":275},"end":{"character":9999,"line":282}}}],"version":5}