{"vars":[{"name":"base","containerName":"","kind":2,"line":109},{"line":111,"range":{"end":{"line":116,"character":9999},"start":{"line":111,"character":0}},"kind":12,"signature":{"documentation":"","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"children":[{"definition":"my","localvar":"my","containerName":"new","kind":13,"name":"$class","line":112},{"name":"@args","containerName":"new","kind":13,"line":112},{"name":"$self","localvar":"my","containerName":"new","kind":13,"line":113,"definition":"my"},{"name":"$class","kind":13,"containerName":"new","line":113},{"name":"@args","kind":13,"containerName":"new","line":113},{"line":114,"name":"$self","kind":13,"containerName":"new"},{"kind":12,"containerName":"new","name":"_initialize","line":114},{"line":114,"kind":13,"containerName":"new","name":"@args"},{"line":115,"kind":13,"containerName":"new","name":"$self"}],"name":"new","containerName":"main::","definition":"sub","detail":"($class,@args)"},{"line":113,"kind":12,"containerName":"new","name":"SUPER"},{"definition":"sub","detail":"($self,@args)","children":[{"definition":"my","line":119,"name":"$self","containerName":"_initialize","localvar":"my","kind":13},{"name":"@args","containerName":"_initialize","kind":13,"line":119},{"line":121,"kind":13,"localvar":"my","containerName":"_initialize","name":"$make","definition":"my"},{"line":121,"name":"$self","kind":13,"containerName":"_initialize"},{"line":121,"containerName":"_initialize","kind":13,"name":"@args"},{"name":"$self","kind":13,"containerName":"_initialize","line":123},{"line":123,"name":"_initialize_state","kind":12,"containerName":"_initialize"},{"name":"@args","kind":13,"containerName":"_initialize","line":123},{"name":"$make","kind":13,"containerName":"_initialize","line":124}],"containerName":"main::","name":"_initialize","signature":{"label":"_initialize($self,@args)","documentation":"","parameters":[{"label":"$self"},{"label":"@args"}]},"line":118,"range":{"end":{"character":9999,"line":125},"start":{"line":118,"character":0}},"kind":12},{"line":121,"name":"SUPER","kind":12,"containerName":"_initialize"},{"line":164,"kind":12,"range":{"start":{"character":0,"line":164},"end":{"line":177,"character":9999}},"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: AnalysisResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::AnalysisResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp-at-gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::AnalysisResult - Base class for analysis result objects and parsers\n\n=head1 SYNOPSIS\n\n    # obtain a AnalysisResult derived object somehow\n\n    print \"Method \", $result->analysis_method(),\n          \", version \", $result->analysis_method_version(),\n          \", performed on \", $result->analysis_date(), \"\\n\";\n\n    # annotate a sequence utilizing SeqAnalysisParserI methods\n    while($feat = $result->next_feature()) {\n\t$seq->add_SeqFeature($feat);\n    }\n    $result->close();\n\n    # query object, e.g. a Bio::SeqI implementing object\n    $queryseq = $result->analysis_query();\n\n    # Subject of the analysis -- may be undefined. Refer to derived module\n    # to find out what is returned.\n    $subject = $result->analysis_subject();\n\n=head1 DESCRIPTION\n\nThe AnalysisResult module is supposed to be the base class for modules\nencapsulating parsers and interpreters for the result of a analysis\nthat was carried out with a query sequence.\n\nThe notion of an analysis represented by this base class is that of a\nunary or binary operator, taking either one query or a query and a\nsubject and producing a result. The query is e.g. a sequence, and a\nsubject is either a sequence, too, or a database of sequences.\n\nThis module also implements the Bio::SeqAnalysisParserI interface, and\nthus can be used wherever such an object fits.  See\nL<Bio::SeqAnalysisParserI>.  Developers will\nfind a ready-to-use B<parse()> method, but need to implement\nB<next_feature()> in an inheriting class. Support for initialization\nwith input file names and reading from streams is also ready to use.\n\nNote that this module does not provide support for B<running> an\nanalysis.  Rather, it is positioned in the subsequent parsing step\n(concerned with turning raw results into BioPerl objects).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::AnalysisResult;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::SeqAnalysisParserI Bio::AnalysisResultI Bio::Root::IO);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    $self->_initialize(@args);\n    return $self;\n}\n\nsub _initialize {\n  my($self,@args) = @_;\n\n  my $make = $self->SUPER::_initialize(@args);\n\n  $self->_initialize_state(@args);\n  return $make; # success - we hope!\n}\n\n=head2 _initialize_state\n\n Title   : _initialize_state\n Usage   : n/a; usually called by _initialize()\n Function: This method is for BioPerl B<developers> only, as indicated by the\n           leading underscore in its name.\n\n           Performs initialization or reset of the state of this object. The\n           difference to _initialize() is that it may be called at any time,\n           and repeatedly within the lifetime of this object. B<Note>, however,\n           that this is potentially dangerous in a multi-threading\n           environment. In general, calling this method twice is discouraged\n           for this reason.\n\n           This method is supposed to reset the state such that any 'history'\n           is lost. State information that does not change during object\n           lifetime is not considered as history, e.g. parent, name, etc shall\n           not be reset. An inheriting object should only be concerned with\n           state information it introduces itself, and for everything else\n           call SUPER::_initialize_state(@args).\n\n           An example is parsing an input file: a state reset implies\n           discarding any unread input, and the actual input itself, followed\n           by setting the new input.\n\n           The argument syntax is the same as for L<new()|new> and L<_initialize()|_initialize>,\n           i.e., named parameters following the -name=>$value convention.\n           The following parameters are dealt with by the implementation\n           provided here:\n              -INPUT, -FH, -FILE\n           (tags are case-insensitive).\n Example :\n Returns :\n Args    :","label":"_initialize_state($self,@args)"},"children":[{"definition":"my","line":165,"containerName":"_initialize_state","localvar":"my","kind":13,"name":"$self"},{"containerName":"_initialize_state","kind":13,"name":"@args","line":165},{"name":"$self","kind":13,"containerName":"_initialize_state","line":167},{"kind":12,"containerName":"_initialize_state","name":"close","line":167},{"containerName":"_initialize_state","kind":13,"name":"$self","line":168},{"containerName":"_initialize_state","kind":12,"name":"_initialize_io","line":168},{"line":168,"containerName":"_initialize_state","kind":13,"name":"@args"},{"line":170,"name":"$self","containerName":"_initialize_state","kind":13},{"line":171,"kind":13,"containerName":"_initialize_state","name":"$self"},{"name":"$self","containerName":"_initialize_state","kind":13,"line":172},{"line":173,"containerName":"_initialize_state","kind":13,"name":"$self"},{"line":174,"containerName":"_initialize_state","kind":13,"name":"$self"}],"containerName":"main::","name":"_initialize_state","definition":"sub","detail":"($self,@args)"},{"detail":"($self,@args)","definition":"sub","containerName":"main::","name":"parse","children":[{"definition":"my","line":205,"localvar":"my","kind":13,"containerName":"parse","name":"$self"},{"line":205,"containerName":"parse","kind":13,"name":"@args"},{"name":"$input","kind":13,"localvar":"my","containerName":"parse","line":207,"definition":"my"},{"line":207,"name":"$params","containerName":"parse","kind":13},{"name":"$method","containerName":"parse","kind":13,"line":207},{"kind":13,"containerName":"parse","name":"$self","line":208},{"containerName":"parse","kind":12,"name":"_rearrange","line":208},{"kind":13,"containerName":"parse","name":"@args","line":212},{"containerName":"parse","kind":13,"name":"$params","line":215},{"name":"$self","kind":13,"containerName":"parse","line":216},{"line":216,"kind":12,"containerName":"parse","name":"_initialize_state"},{"kind":13,"containerName":"parse","name":"$input","line":216},{"name":"$params","containerName":"parse","kind":13,"line":216},{"name":"$self","containerName":"parse","kind":13,"line":218},{"kind":12,"containerName":"parse","name":"_initialize_state","line":218},{"line":218,"containerName":"parse","kind":13,"name":"$input"},{"line":220,"kind":13,"containerName":"parse","name":"$self"},{"line":220,"containerName":"parse","kind":12,"name":"analysis_method"},{"line":220,"kind":13,"containerName":"parse","name":"$method"},{"name":"$method","kind":13,"containerName":"parse","line":220}],"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"  =head2 parse\n\n   Title   : parse\n   Usage   : $obj->parse(-input=>$inputobj, [ -params=>[@params] ],\n  \t\t       [ -method => $method ] )\n   Function: Sets up parsing for feature retrieval from an analysis file,\n             or object.\n\n             This method was originally required by SeqAnalysisParserI, but\n             is now discouraged due to potential problems in a multi-\n             threading environment (CORBA!). If called only once, it doesn't\n             add any functionality to calling new() with the same\n             parameters.\n\n             The implementation provided here calls automatically\n             _initialize_state() and passes on -input=>$inputobj and\n             @params as final arguments.\n   Example :\n   Returns : void\n   Args    : B<input>  - object/file where analysis are coming from\n  \t   B<params> - parameter to use when parsing/running analysis\n  \t   B<method> - method of analysis\n\n  =cut","label":"parse($self,@args)"},"range":{"start":{"line":204,"character":0},"end":{"character":9999,"line":221}},"kind":12,"line":204},{"signature":{"label":"analysis_query($self,$obj)","documentation":"1;\n# $Id: AnalysisResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::AnalysisResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp-at-gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::AnalysisResult - Base class for analysis result objects and parsers\n\n=head1 SYNOPSIS\n\n    # obtain a AnalysisResult derived object somehow\n\n    print \"Method \", $result->analysis_method(),\n          \", version \", $result->analysis_method_version(),\n          \", performed on \", $result->analysis_date(), \"\\n\";\n\n    # annotate a sequence utilizing SeqAnalysisParserI methods\n    while($feat = $result->next_feature()) {\n\t$seq->add_SeqFeature($feat);\n    }\n    $result->close();\n\n    # query object, e.g. a Bio::SeqI implementing object\n    $queryseq = $result->analysis_query();\n\n    # Subject of the analysis -- may be undefined. Refer to derived module\n    # to find out what is returned.\n    $subject = $result->analysis_subject();\n\n=head1 DESCRIPTION\n\nThe AnalysisResult module is supposed to be the base class for modules\nencapsulating parsers and interpreters for the result of a analysis\nthat was carried out with a query sequence.\n\nThe notion of an analysis represented by this base class is that of a\nunary or binary operator, taking either one query or a query and a\nsubject and producing a result. The query is e.g. a sequence, and a\nsubject is either a sequence, too, or a database of sequences.\n\nThis module also implements the Bio::SeqAnalysisParserI interface, and\nthus can be used wherever such an object fits.  See\nL<Bio::SeqAnalysisParserI>.  Developers will\nfind a ready-to-use B<parse()> method, but need to implement\nB<next_feature()> in an inheriting class. Support for initialization\nwith input file names and reading from streams is also ready to use.\n\nNote that this module does not provide support for B<running> an\nanalysis.  Rather, it is positioned in the subsequent parsing step\n(concerned with turning raw results into BioPerl objects).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::AnalysisResult;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::SeqAnalysisParserI Bio::AnalysisResultI Bio::Root::IO);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    $self->_initialize(@args);\n    return $self;\n}\n\nsub _initialize {\n  my($self,@args) = @_;\n\n  my $make = $self->SUPER::_initialize(@args);\n\n  $self->_initialize_state(@args);\n  return $make; # success - we hope!\n}\n\n=head2 _initialize_state\n\n Title   : _initialize_state\n Usage   : n/a; usually called by _initialize()\n Function: This method is for BioPerl B<developers> only, as indicated by the\n           leading underscore in its name.\n\n           Performs initialization or reset of the state of this object. The\n           difference to _initialize() is that it may be called at any time,\n           and repeatedly within the lifetime of this object. B<Note>, however,\n           that this is potentially dangerous in a multi-threading\n           environment. In general, calling this method twice is discouraged\n           for this reason.\n\n           This method is supposed to reset the state such that any 'history'\n           is lost. State information that does not change during object\n           lifetime is not considered as history, e.g. parent, name, etc shall\n           not be reset. An inheriting object should only be concerned with\n           state information it introduces itself, and for everything else\n           call SUPER::_initialize_state(@args).\n\n           An example is parsing an input file: a state reset implies\n           discarding any unread input, and the actual input itself, followed\n           by setting the new input.\n\n           The argument syntax is the same as for L<new()|new> and L<_initialize()|_initialize>,\n           i.e., named parameters following the -name=>$value convention.\n           The following parameters are dealt with by the implementation\n           provided here:\n              -INPUT, -FH, -FILE\n           (tags are case-insensitive).\n Example :\n Returns :\n Args    :\n\n\nsub _initialize_state {\n    my ($self,@args) = @_;\n\n    $self->close();\n    $self->_initialize_io(@args);\n\n    $self->{'_analysis_sbjct'} = undef;\n    $self->{'_analysis_query'} = undef;\n    $self->{'_analysis_prog'} = undef;\n    $self->{'_analysis_progVersion'} = undef;\n    $self->{'_analysis_date'} = undef;\n\n    return 1;\n}\n\n#  =head2 parse\n#\n#   Title   : parse\n#   Usage   : $obj->parse(-input=>$inputobj, [ -params=>[@params] ],\n#  \t\t       [ -method => $method ] )\n#   Function: Sets up parsing for feature retrieval from an analysis file,\n#             or object.\n#\n#             This method was originally required by SeqAnalysisParserI, but\n#             is now discouraged due to potential problems in a multi-\n#             threading environment (CORBA!). If called only once, it doesn't\n#             add any functionality to calling new() with the same\n#             parameters.\n#\n#             The implementation provided here calls automatically\n#             _initialize_state() and passes on -input=>$inputobj and\n#             @params as final arguments.\n#   Example :\n#   Returns : void\n#   Args    : B<input>  - object/file where analysis are coming from\n#  \t   B<params> - parameter to use when parsing/running analysis\n#  \t   B<method> - method of analysis\n#\n#  =cut\n\nsub parse {\n    my ($self, @args) = @_;\n\n    my ($input, $params, $method) =\n\t$self->_rearrange([qw(INPUT\n\t\t\t      PARAMS\n\t\t\t      METHOD\n\t\t\t      )],\n\t\t\t  @args);\n\n    # initialize with new input\n    if($params) {\n\t$self->_initialize_state('-input' => $input, @$params);\n    } else {\n\t$self->_initialize_state('-input' => $input);\n    }\n    $self->analysis_method($method) if $method;\n}\n\n=head2 analysis_query\n\n Usage     : $query_obj = $result->analysis_query();\n Purpose   : Set/Get the name of the query used to generate the result, that\n             is, the entity on which the analysis was performed. Will mostly\n             be a sequence object (Bio::PrimarySeq compatible).\n Argument  :\n Returns   : The object set before. Mostly a Bio::PrimarySeq compatible object.","parameters":[{"label":"$self"},{"label":"$obj"}]},"kind":12,"range":{"start":{"line":235,"character":0},"end":{"character":9999,"line":241}},"line":235,"detail":"($self,$obj)","definition":"sub","name":"analysis_query","containerName":"main::","children":[{"definition":"my","line":236,"name":"$self","localvar":"my","containerName":"analysis_query","kind":13},{"line":236,"kind":13,"containerName":"analysis_query","name":"$obj"},{"kind":13,"containerName":"analysis_query","name":"$obj","line":237},{"line":238,"containerName":"analysis_query","kind":13,"name":"$self"},{"name":"$obj","containerName":"analysis_query","kind":13,"line":238},{"name":"$self","kind":13,"containerName":"analysis_query","line":240}]},{"definition":"sub","detail":"($self,$sbjct_obj)","children":[{"line":260,"name":"$self","kind":13,"localvar":"my","containerName":"analysis_subject","definition":"my"},{"line":260,"kind":13,"containerName":"analysis_subject","name":"$sbjct_obj"},{"name":"$sbjct_obj","kind":13,"containerName":"analysis_subject","line":261},{"line":262,"kind":13,"containerName":"analysis_subject","name":"$self"},{"containerName":"analysis_subject","kind":13,"name":"$sbjct_obj","line":262},{"kind":13,"containerName":"analysis_subject","name":"$self","line":264}],"containerName":"main::","name":"analysis_subject","signature":{"parameters":[{"label":"$self"},{"label":"$sbjct_obj"}],"documentation":"1;\n# $Id: AnalysisResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::AnalysisResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp-at-gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::AnalysisResult - Base class for analysis result objects and parsers\n\n=head1 SYNOPSIS\n\n    # obtain a AnalysisResult derived object somehow\n\n    print \"Method \", $result->analysis_method(),\n          \", version \", $result->analysis_method_version(),\n          \", performed on \", $result->analysis_date(), \"\\n\";\n\n    # annotate a sequence utilizing SeqAnalysisParserI methods\n    while($feat = $result->next_feature()) {\n\t$seq->add_SeqFeature($feat);\n    }\n    $result->close();\n\n    # query object, e.g. a Bio::SeqI implementing object\n    $queryseq = $result->analysis_query();\n\n    # Subject of the analysis -- may be undefined. Refer to derived module\n    # to find out what is returned.\n    $subject = $result->analysis_subject();\n\n=head1 DESCRIPTION\n\nThe AnalysisResult module is supposed to be the base class for modules\nencapsulating parsers and interpreters for the result of a analysis\nthat was carried out with a query sequence.\n\nThe notion of an analysis represented by this base class is that of a\nunary or binary operator, taking either one query or a query and a\nsubject and producing a result. The query is e.g. a sequence, and a\nsubject is either a sequence, too, or a database of sequences.\n\nThis module also implements the Bio::SeqAnalysisParserI interface, and\nthus can be used wherever such an object fits.  See\nL<Bio::SeqAnalysisParserI>.  Developers will\nfind a ready-to-use B<parse()> method, but need to implement\nB<next_feature()> in an inheriting class. Support for initialization\nwith input file names and reading from streams is also ready to use.\n\nNote that this module does not provide support for B<running> an\nanalysis.  Rather, it is positioned in the subsequent parsing step\n(concerned with turning raw results into BioPerl objects).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::AnalysisResult;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::SeqAnalysisParserI Bio::AnalysisResultI Bio::Root::IO);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    $self->_initialize(@args);\n    return $self;\n}\n\nsub _initialize {\n  my($self,@args) = @_;\n\n  my $make = $self->SUPER::_initialize(@args);\n\n  $self->_initialize_state(@args);\n  return $make; # success - we hope!\n}\n\n=head2 _initialize_state\n\n Title   : _initialize_state\n Usage   : n/a; usually called by _initialize()\n Function: This method is for BioPerl B<developers> only, as indicated by the\n           leading underscore in its name.\n\n           Performs initialization or reset of the state of this object. The\n           difference to _initialize() is that it may be called at any time,\n           and repeatedly within the lifetime of this object. B<Note>, however,\n           that this is potentially dangerous in a multi-threading\n           environment. In general, calling this method twice is discouraged\n           for this reason.\n\n           This method is supposed to reset the state such that any 'history'\n           is lost. State information that does not change during object\n           lifetime is not considered as history, e.g. parent, name, etc shall\n           not be reset. An inheriting object should only be concerned with\n           state information it introduces itself, and for everything else\n           call SUPER::_initialize_state(@args).\n\n           An example is parsing an input file: a state reset implies\n           discarding any unread input, and the actual input itself, followed\n           by setting the new input.\n\n           The argument syntax is the same as for L<new()|new> and L<_initialize()|_initialize>,\n           i.e., named parameters following the -name=>$value convention.\n           The following parameters are dealt with by the implementation\n           provided here:\n              -INPUT, -FH, -FILE\n           (tags are case-insensitive).\n Example :\n Returns :\n Args    :\n\n\nsub _initialize_state {\n    my ($self,@args) = @_;\n\n    $self->close();\n    $self->_initialize_io(@args);\n\n    $self->{'_analysis_sbjct'} = undef;\n    $self->{'_analysis_query'} = undef;\n    $self->{'_analysis_prog'} = undef;\n    $self->{'_analysis_progVersion'} = undef;\n    $self->{'_analysis_date'} = undef;\n\n    return 1;\n}\n\n#  =head2 parse\n#\n#   Title   : parse\n#   Usage   : $obj->parse(-input=>$inputobj, [ -params=>[@params] ],\n#  \t\t       [ -method => $method ] )\n#   Function: Sets up parsing for feature retrieval from an analysis file,\n#             or object.\n#\n#             This method was originally required by SeqAnalysisParserI, but\n#             is now discouraged due to potential problems in a multi-\n#             threading environment (CORBA!). If called only once, it doesn't\n#             add any functionality to calling new() with the same\n#             parameters.\n#\n#             The implementation provided here calls automatically\n#             _initialize_state() and passes on -input=>$inputobj and\n#             @params as final arguments.\n#   Example :\n#   Returns : void\n#   Args    : B<input>  - object/file where analysis are coming from\n#  \t   B<params> - parameter to use when parsing/running analysis\n#  \t   B<method> - method of analysis\n#\n#  =cut\n\nsub parse {\n    my ($self, @args) = @_;\n\n    my ($input, $params, $method) =\n\t$self->_rearrange([qw(INPUT\n\t\t\t      PARAMS\n\t\t\t      METHOD\n\t\t\t      )],\n\t\t\t  @args);\n\n    # initialize with new input\n    if($params) {\n\t$self->_initialize_state('-input' => $input, @$params);\n    } else {\n\t$self->_initialize_state('-input' => $input);\n    }\n    $self->analysis_method($method) if $method;\n}\n\n=head2 analysis_query\n\n Usage     : $query_obj = $result->analysis_query();\n Purpose   : Set/Get the name of the query used to generate the result, that\n             is, the entity on which the analysis was performed. Will mostly\n             be a sequence object (Bio::PrimarySeq compatible).\n Argument  :\n Returns   : The object set before. Mostly a Bio::PrimarySeq compatible object.\n\n\n#--------\nsub analysis_query {\n    my ($self, $obj) = @_;\n    if($obj) {\n\t$self->{'_analysis_query'} = $obj;\n    }\n    return $self->{'_analysis_query'};\n}\n#--------\n\n=head2 analysis_subject\n\n Usage     : $result->analyis_subject();\n Purpose   : Set/Get the subject of the analysis against which it was\n             performed. For similarity searches it will probably be a database,\n             and for sequence feature predictions (exons, promoters, etc) it\n             may be a collection of models or homologous sequences that were\n             used, or undefined.\n Returns   : The object that was set before, or undef.\n Argument  :","label":"analysis_subject($self,$sbjct_obj)"},"line":258,"range":{"start":{"character":0,"line":258},"end":{"character":9999,"line":265}},"kind":12},{"definition":"sub","detail":"($self,$date)","children":[{"definition":"my","localvar":"my","containerName":"analysis_date","kind":13,"name":"$self","line":280},{"line":280,"kind":13,"containerName":"analysis_date","name":"$date"},{"containerName":"analysis_date","kind":13,"name":"$date","line":281},{"name":"$self","containerName":"analysis_date","kind":13,"line":282},{"line":282,"name":"$date","kind":13,"containerName":"analysis_date"},{"line":284,"containerName":"analysis_date","kind":13,"name":"$self"}],"name":"analysis_date","containerName":"main::","signature":{"label":"analysis_date($self,$date)","parameters":[{"label":"$self"},{"label":"$date"}],"documentation":"1;\n# $Id: AnalysisResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::AnalysisResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp-at-gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::AnalysisResult - Base class for analysis result objects and parsers\n\n=head1 SYNOPSIS\n\n    # obtain a AnalysisResult derived object somehow\n\n    print \"Method \", $result->analysis_method(),\n          \", version \", $result->analysis_method_version(),\n          \", performed on \", $result->analysis_date(), \"\\n\";\n\n    # annotate a sequence utilizing SeqAnalysisParserI methods\n    while($feat = $result->next_feature()) {\n\t$seq->add_SeqFeature($feat);\n    }\n    $result->close();\n\n    # query object, e.g. a Bio::SeqI implementing object\n    $queryseq = $result->analysis_query();\n\n    # Subject of the analysis -- may be undefined. Refer to derived module\n    # to find out what is returned.\n    $subject = $result->analysis_subject();\n\n=head1 DESCRIPTION\n\nThe AnalysisResult module is supposed to be the base class for modules\nencapsulating parsers and interpreters for the result of a analysis\nthat was carried out with a query sequence.\n\nThe notion of an analysis represented by this base class is that of a\nunary or binary operator, taking either one query or a query and a\nsubject and producing a result. The query is e.g. a sequence, and a\nsubject is either a sequence, too, or a database of sequences.\n\nThis module also implements the Bio::SeqAnalysisParserI interface, and\nthus can be used wherever such an object fits.  See\nL<Bio::SeqAnalysisParserI>.  Developers will\nfind a ready-to-use B<parse()> method, but need to implement\nB<next_feature()> in an inheriting class. Support for initialization\nwith input file names and reading from streams is also ready to use.\n\nNote that this module does not provide support for B<running> an\nanalysis.  Rather, it is positioned in the subsequent parsing step\n(concerned with turning raw results into BioPerl objects).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::AnalysisResult;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::SeqAnalysisParserI Bio::AnalysisResultI Bio::Root::IO);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    $self->_initialize(@args);\n    return $self;\n}\n\nsub _initialize {\n  my($self,@args) = @_;\n\n  my $make = $self->SUPER::_initialize(@args);\n\n  $self->_initialize_state(@args);\n  return $make; # success - we hope!\n}\n\n=head2 _initialize_state\n\n Title   : _initialize_state\n Usage   : n/a; usually called by _initialize()\n Function: This method is for BioPerl B<developers> only, as indicated by the\n           leading underscore in its name.\n\n           Performs initialization or reset of the state of this object. The\n           difference to _initialize() is that it may be called at any time,\n           and repeatedly within the lifetime of this object. B<Note>, however,\n           that this is potentially dangerous in a multi-threading\n           environment. In general, calling this method twice is discouraged\n           for this reason.\n\n           This method is supposed to reset the state such that any 'history'\n           is lost. State information that does not change during object\n           lifetime is not considered as history, e.g. parent, name, etc shall\n           not be reset. An inheriting object should only be concerned with\n           state information it introduces itself, and for everything else\n           call SUPER::_initialize_state(@args).\n\n           An example is parsing an input file: a state reset implies\n           discarding any unread input, and the actual input itself, followed\n           by setting the new input.\n\n           The argument syntax is the same as for L<new()|new> and L<_initialize()|_initialize>,\n           i.e., named parameters following the -name=>$value convention.\n           The following parameters are dealt with by the implementation\n           provided here:\n              -INPUT, -FH, -FILE\n           (tags are case-insensitive).\n Example :\n Returns :\n Args    :\n\n\nsub _initialize_state {\n    my ($self,@args) = @_;\n\n    $self->close();\n    $self->_initialize_io(@args);\n\n    $self->{'_analysis_sbjct'} = undef;\n    $self->{'_analysis_query'} = undef;\n    $self->{'_analysis_prog'} = undef;\n    $self->{'_analysis_progVersion'} = undef;\n    $self->{'_analysis_date'} = undef;\n\n    return 1;\n}\n\n#  =head2 parse\n#\n#   Title   : parse\n#   Usage   : $obj->parse(-input=>$inputobj, [ -params=>[@params] ],\n#  \t\t       [ -method => $method ] )\n#   Function: Sets up parsing for feature retrieval from an analysis file,\n#             or object.\n#\n#             This method was originally required by SeqAnalysisParserI, but\n#             is now discouraged due to potential problems in a multi-\n#             threading environment (CORBA!). If called only once, it doesn't\n#             add any functionality to calling new() with the same\n#             parameters.\n#\n#             The implementation provided here calls automatically\n#             _initialize_state() and passes on -input=>$inputobj and\n#             @params as final arguments.\n#   Example :\n#   Returns : void\n#   Args    : B<input>  - object/file where analysis are coming from\n#  \t   B<params> - parameter to use when parsing/running analysis\n#  \t   B<method> - method of analysis\n#\n#  =cut\n\nsub parse {\n    my ($self, @args) = @_;\n\n    my ($input, $params, $method) =\n\t$self->_rearrange([qw(INPUT\n\t\t\t      PARAMS\n\t\t\t      METHOD\n\t\t\t      )],\n\t\t\t  @args);\n\n    # initialize with new input\n    if($params) {\n\t$self->_initialize_state('-input' => $input, @$params);\n    } else {\n\t$self->_initialize_state('-input' => $input);\n    }\n    $self->analysis_method($method) if $method;\n}\n\n=head2 analysis_query\n\n Usage     : $query_obj = $result->analysis_query();\n Purpose   : Set/Get the name of the query used to generate the result, that\n             is, the entity on which the analysis was performed. Will mostly\n             be a sequence object (Bio::PrimarySeq compatible).\n Argument  :\n Returns   : The object set before. Mostly a Bio::PrimarySeq compatible object.\n\n\n#--------\nsub analysis_query {\n    my ($self, $obj) = @_;\n    if($obj) {\n\t$self->{'_analysis_query'} = $obj;\n    }\n    return $self->{'_analysis_query'};\n}\n#--------\n\n=head2 analysis_subject\n\n Usage     : $result->analyis_subject();\n Purpose   : Set/Get the subject of the analysis against which it was\n             performed. For similarity searches it will probably be a database,\n             and for sequence feature predictions (exons, promoters, etc) it\n             may be a collection of models or homologous sequences that were\n             used, or undefined.\n Returns   : The object that was set before, or undef.\n Argument  :\n\n\n#---------------\nsub analysis_subject {\n#---------------\n    my ($self, $sbjct_obj) = @_;\n    if($sbjct_obj) {\n\t$self->{'_analysis_sbjct'} = $sbjct_obj;\n    }\n    return $self->{'_analysis_sbjct'};\n}\n\n\n=head2 analysis_date\n\n Usage     : $result->analysis_date();\n Purpose   : Set/Get the date on which the analysis was performed.\n Returns   : String\n Argument  :\n Comments  :"},"line":279,"range":{"end":{"character":9999,"line":285},"start":{"character":0,"line":279}},"kind":12},{"detail":"($self,$method)","definition":"sub","name":"analysis_method","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"analysis_method","kind":13,"line":302},{"name":"$method","containerName":"analysis_method","kind":13,"line":302},{"line":303,"name":"$method","containerName":"analysis_method","kind":13},{"line":304,"name":"$self","containerName":"analysis_method","kind":13},{"kind":13,"containerName":"analysis_method","name":"$method","line":304},{"line":306,"containerName":"analysis_method","kind":13,"name":"$self"}],"signature":{"parameters":[{"label":"$self"},{"label":"$method"}],"documentation":"1;\n# $Id: AnalysisResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::AnalysisResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp-at-gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::AnalysisResult - Base class for analysis result objects and parsers\n\n=head1 SYNOPSIS\n\n    # obtain a AnalysisResult derived object somehow\n\n    print \"Method \", $result->analysis_method(),\n          \", version \", $result->analysis_method_version(),\n          \", performed on \", $result->analysis_date(), \"\\n\";\n\n    # annotate a sequence utilizing SeqAnalysisParserI methods\n    while($feat = $result->next_feature()) {\n\t$seq->add_SeqFeature($feat);\n    }\n    $result->close();\n\n    # query object, e.g. a Bio::SeqI implementing object\n    $queryseq = $result->analysis_query();\n\n    # Subject of the analysis -- may be undefined. Refer to derived module\n    # to find out what is returned.\n    $subject = $result->analysis_subject();\n\n=head1 DESCRIPTION\n\nThe AnalysisResult module is supposed to be the base class for modules\nencapsulating parsers and interpreters for the result of a analysis\nthat was carried out with a query sequence.\n\nThe notion of an analysis represented by this base class is that of a\nunary or binary operator, taking either one query or a query and a\nsubject and producing a result. The query is e.g. a sequence, and a\nsubject is either a sequence, too, or a database of sequences.\n\nThis module also implements the Bio::SeqAnalysisParserI interface, and\nthus can be used wherever such an object fits.  See\nL<Bio::SeqAnalysisParserI>.  Developers will\nfind a ready-to-use B<parse()> method, but need to implement\nB<next_feature()> in an inheriting class. Support for initialization\nwith input file names and reading from streams is also ready to use.\n\nNote that this module does not provide support for B<running> an\nanalysis.  Rather, it is positioned in the subsequent parsing step\n(concerned with turning raw results into BioPerl objects).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::AnalysisResult;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::SeqAnalysisParserI Bio::AnalysisResultI Bio::Root::IO);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    $self->_initialize(@args);\n    return $self;\n}\n\nsub _initialize {\n  my($self,@args) = @_;\n\n  my $make = $self->SUPER::_initialize(@args);\n\n  $self->_initialize_state(@args);\n  return $make; # success - we hope!\n}\n\n=head2 _initialize_state\n\n Title   : _initialize_state\n Usage   : n/a; usually called by _initialize()\n Function: This method is for BioPerl B<developers> only, as indicated by the\n           leading underscore in its name.\n\n           Performs initialization or reset of the state of this object. The\n           difference to _initialize() is that it may be called at any time,\n           and repeatedly within the lifetime of this object. B<Note>, however,\n           that this is potentially dangerous in a multi-threading\n           environment. In general, calling this method twice is discouraged\n           for this reason.\n\n           This method is supposed to reset the state such that any 'history'\n           is lost. State information that does not change during object\n           lifetime is not considered as history, e.g. parent, name, etc shall\n           not be reset. An inheriting object should only be concerned with\n           state information it introduces itself, and for everything else\n           call SUPER::_initialize_state(@args).\n\n           An example is parsing an input file: a state reset implies\n           discarding any unread input, and the actual input itself, followed\n           by setting the new input.\n\n           The argument syntax is the same as for L<new()|new> and L<_initialize()|_initialize>,\n           i.e., named parameters following the -name=>$value convention.\n           The following parameters are dealt with by the implementation\n           provided here:\n              -INPUT, -FH, -FILE\n           (tags are case-insensitive).\n Example :\n Returns :\n Args    :\n\n\nsub _initialize_state {\n    my ($self,@args) = @_;\n\n    $self->close();\n    $self->_initialize_io(@args);\n\n    $self->{'_analysis_sbjct'} = undef;\n    $self->{'_analysis_query'} = undef;\n    $self->{'_analysis_prog'} = undef;\n    $self->{'_analysis_progVersion'} = undef;\n    $self->{'_analysis_date'} = undef;\n\n    return 1;\n}\n\n#  =head2 parse\n#\n#   Title   : parse\n#   Usage   : $obj->parse(-input=>$inputobj, [ -params=>[@params] ],\n#  \t\t       [ -method => $method ] )\n#   Function: Sets up parsing for feature retrieval from an analysis file,\n#             or object.\n#\n#             This method was originally required by SeqAnalysisParserI, but\n#             is now discouraged due to potential problems in a multi-\n#             threading environment (CORBA!). If called only once, it doesn't\n#             add any functionality to calling new() with the same\n#             parameters.\n#\n#             The implementation provided here calls automatically\n#             _initialize_state() and passes on -input=>$inputobj and\n#             @params as final arguments.\n#   Example :\n#   Returns : void\n#   Args    : B<input>  - object/file where analysis are coming from\n#  \t   B<params> - parameter to use when parsing/running analysis\n#  \t   B<method> - method of analysis\n#\n#  =cut\n\nsub parse {\n    my ($self, @args) = @_;\n\n    my ($input, $params, $method) =\n\t$self->_rearrange([qw(INPUT\n\t\t\t      PARAMS\n\t\t\t      METHOD\n\t\t\t      )],\n\t\t\t  @args);\n\n    # initialize with new input\n    if($params) {\n\t$self->_initialize_state('-input' => $input, @$params);\n    } else {\n\t$self->_initialize_state('-input' => $input);\n    }\n    $self->analysis_method($method) if $method;\n}\n\n=head2 analysis_query\n\n Usage     : $query_obj = $result->analysis_query();\n Purpose   : Set/Get the name of the query used to generate the result, that\n             is, the entity on which the analysis was performed. Will mostly\n             be a sequence object (Bio::PrimarySeq compatible).\n Argument  :\n Returns   : The object set before. Mostly a Bio::PrimarySeq compatible object.\n\n\n#--------\nsub analysis_query {\n    my ($self, $obj) = @_;\n    if($obj) {\n\t$self->{'_analysis_query'} = $obj;\n    }\n    return $self->{'_analysis_query'};\n}\n#--------\n\n=head2 analysis_subject\n\n Usage     : $result->analyis_subject();\n Purpose   : Set/Get the subject of the analysis against which it was\n             performed. For similarity searches it will probably be a database,\n             and for sequence feature predictions (exons, promoters, etc) it\n             may be a collection of models or homologous sequences that were\n             used, or undefined.\n Returns   : The object that was set before, or undef.\n Argument  :\n\n\n#---------------\nsub analysis_subject {\n#---------------\n    my ($self, $sbjct_obj) = @_;\n    if($sbjct_obj) {\n\t$self->{'_analysis_sbjct'} = $sbjct_obj;\n    }\n    return $self->{'_analysis_sbjct'};\n}\n\n\n=head2 analysis_date\n\n Usage     : $result->analysis_date();\n Purpose   : Set/Get the date on which the analysis was performed.\n Returns   : String\n Argument  :\n Comments  :\n\n\n#----------\nsub analysis_date {\n    my ($self, $date) = @_;\n    if($date) {\n\t$self->{'_analysis_date'} = $date;\n    }\n    return $self->{'_analysis_date'};\n}\n#----------\n\n=head2 analysis_method\n\n Usage     : $result->analysis_method();\n Purpose   : Set/Get the name of the sequence analysis method that was used\n             to produce this result (BLASTP, FASTA, etc.). May also be the\n             actual name of a program.\n Returns   : String\n Argument  : n/a","label":"analysis_method($self,$method)"},"kind":12,"range":{"end":{"character":9999,"line":307},"start":{"character":0,"line":300}},"line":300},{"containerName":"main::","name":"analysis_method_version","children":[{"definition":"my","line":322,"name":"$self","localvar":"my","kind":13,"containerName":"analysis_method_version"},{"line":322,"kind":13,"containerName":"analysis_method_version","name":"$version"},{"name":"$version","kind":13,"containerName":"analysis_method_version","line":323},{"line":324,"kind":13,"containerName":"analysis_method_version","name":"$self"},{"name":"$version","kind":13,"containerName":"analysis_method_version","line":324},{"containerName":"analysis_method_version","kind":13,"name":"$self","line":326}],"detail":"($self,$version)","definition":"sub","range":{"end":{"character":9999,"line":327},"start":{"line":320,"character":0}},"kind":12,"line":320,"signature":{"label":"analysis_method_version($self,$version)","documentation":"1;\n# $Id: AnalysisResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::AnalysisResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp-at-gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::AnalysisResult - Base class for analysis result objects and parsers\n\n=head1 SYNOPSIS\n\n    # obtain a AnalysisResult derived object somehow\n\n    print \"Method \", $result->analysis_method(),\n          \", version \", $result->analysis_method_version(),\n          \", performed on \", $result->analysis_date(), \"\\n\";\n\n    # annotate a sequence utilizing SeqAnalysisParserI methods\n    while($feat = $result->next_feature()) {\n\t$seq->add_SeqFeature($feat);\n    }\n    $result->close();\n\n    # query object, e.g. a Bio::SeqI implementing object\n    $queryseq = $result->analysis_query();\n\n    # Subject of the analysis -- may be undefined. Refer to derived module\n    # to find out what is returned.\n    $subject = $result->analysis_subject();\n\n=head1 DESCRIPTION\n\nThe AnalysisResult module is supposed to be the base class for modules\nencapsulating parsers and interpreters for the result of a analysis\nthat was carried out with a query sequence.\n\nThe notion of an analysis represented by this base class is that of a\nunary or binary operator, taking either one query or a query and a\nsubject and producing a result. The query is e.g. a sequence, and a\nsubject is either a sequence, too, or a database of sequences.\n\nThis module also implements the Bio::SeqAnalysisParserI interface, and\nthus can be used wherever such an object fits.  See\nL<Bio::SeqAnalysisParserI>.  Developers will\nfind a ready-to-use B<parse()> method, but need to implement\nB<next_feature()> in an inheriting class. Support for initialization\nwith input file names and reading from streams is also ready to use.\n\nNote that this module does not provide support for B<running> an\nanalysis.  Rather, it is positioned in the subsequent parsing step\n(concerned with turning raw results into BioPerl objects).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::AnalysisResult;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::SeqAnalysisParserI Bio::AnalysisResultI Bio::Root::IO);\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    $self->_initialize(@args);\n    return $self;\n}\n\nsub _initialize {\n  my($self,@args) = @_;\n\n  my $make = $self->SUPER::_initialize(@args);\n\n  $self->_initialize_state(@args);\n  return $make; # success - we hope!\n}\n\n=head2 _initialize_state\n\n Title   : _initialize_state\n Usage   : n/a; usually called by _initialize()\n Function: This method is for BioPerl B<developers> only, as indicated by the\n           leading underscore in its name.\n\n           Performs initialization or reset of the state of this object. The\n           difference to _initialize() is that it may be called at any time,\n           and repeatedly within the lifetime of this object. B<Note>, however,\n           that this is potentially dangerous in a multi-threading\n           environment. In general, calling this method twice is discouraged\n           for this reason.\n\n           This method is supposed to reset the state such that any 'history'\n           is lost. State information that does not change during object\n           lifetime is not considered as history, e.g. parent, name, etc shall\n           not be reset. An inheriting object should only be concerned with\n           state information it introduces itself, and for everything else\n           call SUPER::_initialize_state(@args).\n\n           An example is parsing an input file: a state reset implies\n           discarding any unread input, and the actual input itself, followed\n           by setting the new input.\n\n           The argument syntax is the same as for L<new()|new> and L<_initialize()|_initialize>,\n           i.e., named parameters following the -name=>$value convention.\n           The following parameters are dealt with by the implementation\n           provided here:\n              -INPUT, -FH, -FILE\n           (tags are case-insensitive).\n Example :\n Returns :\n Args    :\n\n\nsub _initialize_state {\n    my ($self,@args) = @_;\n\n    $self->close();\n    $self->_initialize_io(@args);\n\n    $self->{'_analysis_sbjct'} = undef;\n    $self->{'_analysis_query'} = undef;\n    $self->{'_analysis_prog'} = undef;\n    $self->{'_analysis_progVersion'} = undef;\n    $self->{'_analysis_date'} = undef;\n\n    return 1;\n}\n\n#  =head2 parse\n#\n#   Title   : parse\n#   Usage   : $obj->parse(-input=>$inputobj, [ -params=>[@params] ],\n#  \t\t       [ -method => $method ] )\n#   Function: Sets up parsing for feature retrieval from an analysis file,\n#             or object.\n#\n#             This method was originally required by SeqAnalysisParserI, but\n#             is now discouraged due to potential problems in a multi-\n#             threading environment (CORBA!). If called only once, it doesn't\n#             add any functionality to calling new() with the same\n#             parameters.\n#\n#             The implementation provided here calls automatically\n#             _initialize_state() and passes on -input=>$inputobj and\n#             @params as final arguments.\n#   Example :\n#   Returns : void\n#   Args    : B<input>  - object/file where analysis are coming from\n#  \t   B<params> - parameter to use when parsing/running analysis\n#  \t   B<method> - method of analysis\n#\n#  =cut\n\nsub parse {\n    my ($self, @args) = @_;\n\n    my ($input, $params, $method) =\n\t$self->_rearrange([qw(INPUT\n\t\t\t      PARAMS\n\t\t\t      METHOD\n\t\t\t      )],\n\t\t\t  @args);\n\n    # initialize with new input\n    if($params) {\n\t$self->_initialize_state('-input' => $input, @$params);\n    } else {\n\t$self->_initialize_state('-input' => $input);\n    }\n    $self->analysis_method($method) if $method;\n}\n\n=head2 analysis_query\n\n Usage     : $query_obj = $result->analysis_query();\n Purpose   : Set/Get the name of the query used to generate the result, that\n             is, the entity on which the analysis was performed. Will mostly\n             be a sequence object (Bio::PrimarySeq compatible).\n Argument  :\n Returns   : The object set before. Mostly a Bio::PrimarySeq compatible object.\n\n\n#--------\nsub analysis_query {\n    my ($self, $obj) = @_;\n    if($obj) {\n\t$self->{'_analysis_query'} = $obj;\n    }\n    return $self->{'_analysis_query'};\n}\n#--------\n\n=head2 analysis_subject\n\n Usage     : $result->analyis_subject();\n Purpose   : Set/Get the subject of the analysis against which it was\n             performed. For similarity searches it will probably be a database,\n             and for sequence feature predictions (exons, promoters, etc) it\n             may be a collection of models or homologous sequences that were\n             used, or undefined.\n Returns   : The object that was set before, or undef.\n Argument  :\n\n\n#---------------\nsub analysis_subject {\n#---------------\n    my ($self, $sbjct_obj) = @_;\n    if($sbjct_obj) {\n\t$self->{'_analysis_sbjct'} = $sbjct_obj;\n    }\n    return $self->{'_analysis_sbjct'};\n}\n\n\n=head2 analysis_date\n\n Usage     : $result->analysis_date();\n Purpose   : Set/Get the date on which the analysis was performed.\n Returns   : String\n Argument  :\n Comments  :\n\n\n#----------\nsub analysis_date {\n    my ($self, $date) = @_;\n    if($date) {\n\t$self->{'_analysis_date'} = $date;\n    }\n    return $self->{'_analysis_date'};\n}\n#----------\n\n=head2 analysis_method\n\n Usage     : $result->analysis_method();\n Purpose   : Set/Get the name of the sequence analysis method that was used\n             to produce this result (BLASTP, FASTA, etc.). May also be the\n             actual name of a program.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method {\n#-------------\n    my ($self, $method) = @_;\n    if($method) {\n\t$self->{'_analysis_prog'} = $method;\n    }\n    return $self->{'_analysis_prog'};\n}\n\n=head2 analysis_method_version\n\n Usage     : $result->analysis_method_version();\n Purpose   : Set/Get the version string of the analysis program.\n           : (e.g., 1.4.9MP, 2.0a19MP-WashU).\n Returns   : String\n Argument  : n/a","parameters":[{"label":"$self"},{"label":"$version"}]}}],"version":5}