{"version":5,"vars":[{"containerName":"strict::Bio::Tools::Analysis::Protein::HNN::IO::String::Bio::SeqIO::HTTP::Request","kind":2,"name":"Common","line":153},{"line":158,"name":"base","containerName":"","kind":2},{"definition":"my","line":162,"name":"$URL","kind":13,"localvar":"my","containerName":null},{"line":163,"localvar":"my","kind":13,"containerName":null,"name":"$ANALYSIS_NAME","definition":"my"},{"name":"%ANALYSIS_SPEC","localvar":"my","kind":13,"containerName":null,"line":164,"definition":"my"},{"line":164,"name":"name","kind":12},{"line":164,"name":"type","kind":12},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"@INPUT_SPEC","line":165},{"line":166,"kind":12,"name":"mandatory"},{"kind":12,"name":"type","line":167},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"%RESULT_SPEC","line":171},{"line":175,"name":"raw","kind":12},{"kind":12,"name":"meta","line":176},{"name":"MIN_STRUC_LEN","containerName":"main::","kind":14,"line":178,"definition":1},{"containerName":"main::","name":"_init","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"_init","line":181},{"kind":13,"containerName":"_init","name":"$self","line":182},{"name":"url","containerName":"_init","kind":12,"line":182},{"name":"$URL","containerName":"_init","kind":13,"line":182},{"name":"$self","containerName":"_init","kind":13,"line":183},{"kind":13,"containerName":"_init","name":"$ANALYSIS_SPEC","line":183},{"name":"$self","containerName":"_init","kind":13,"line":184},{"name":"$INPUT_SPEC","kind":13,"containerName":"_init","line":184},{"name":"$self","kind":13,"containerName":"_init","line":185},{"containerName":"_init","kind":13,"name":"$RESULT_SPEC","line":185},{"line":186,"kind":13,"containerName":"_init","name":"$self"},{"name":"$ANALYSIS_NAME","containerName":"_init","kind":13,"line":186},{"containerName":"_init","kind":13,"name":"$self","line":187}],"definition":"sub","range":{"end":{"line":188,"character":9999},"start":{"character":0,"line":180}},"kind":12,"line":180},{"kind":12,"range":{"start":{"character":0,"line":191},"end":{"line":214,"character":9999}},"line":191,"containerName":"main::","name":"_run","children":[{"definition":"my","line":192,"localvar":"my","kind":13,"containerName":"_run","name":"$self"},{"kind":13,"containerName":"_run","name":"$self","line":193},{"kind":12,"containerName":"_run","name":"delay","line":193},{"kind":13,"containerName":"_run","name":"$self","line":195},{"line":195,"name":"sleep","containerName":"_run","kind":12},{"name":"$self","kind":13,"containerName":"_run","line":196},{"kind":12,"containerName":"_run","name":"status","line":196},{"line":197,"containerName":"_run","localvar":"my","kind":13,"name":"$request","definition":"my"},{"kind":13,"containerName":"_run","name":"$self","line":200},{"name":"seq","kind":12,"containerName":"_run","line":200},{"kind":12,"containerName":"_run","name":"seq","line":200},{"definition":"my","line":204,"name":"$text","containerName":"_run","localvar":"my","kind":13},{"containerName":"_run","kind":13,"name":"$self","line":204},{"line":204,"kind":12,"containerName":"_run","name":"request"},{"line":204,"name":"$request","kind":13,"containerName":"_run"},{"name":"content","kind":12,"containerName":"_run","line":204},{"kind":13,"containerName":"_run","name":"$text","line":205},{"definition":"my","localvar":"my","containerName":"_run","kind":13,"name":"$next","line":206},{"line":206,"kind":13,"containerName":"_run","name":"$text"},{"line":207,"name":"$next","containerName":"_run","kind":13},{"line":208,"name":"$out","localvar":"my","containerName":"_run","kind":13,"definition":"my"},{"line":208,"name":"$next","containerName":"_run","kind":13},{"kind":13,"localvar":"my","containerName":"_run","name":"$req2","line":209,"definition":"my"},{"name":"new","kind":12,"containerName":"_run","line":209},{"name":"$out","containerName":"_run","kind":13,"line":209},{"definition":"my","localvar":"my","containerName":"_run","kind":13,"name":"$resp2","line":210},{"name":"$self","containerName":"_run","kind":13,"line":210},{"kind":12,"containerName":"_run","name":"request","line":210},{"line":210,"name":"$req2","containerName":"_run","kind":13},{"kind":13,"containerName":"_run","name":"$self","line":211},{"line":211,"name":"status","containerName":"_run","kind":12},{"line":211,"kind":13,"containerName":"_run","name":"$resp2"},{"line":212,"name":"$self","kind":13,"containerName":"_run"},{"containerName":"_run","kind":13,"name":"$resp2","line":212},{"line":212,"name":"content","kind":12,"containerName":"_run"},{"kind":13,"containerName":"_run","name":"$self","line":213}],"definition":"sub"},{"line":197,"kind":12,"name":"POST"},{"line":198,"kind":12,"name":"Content_Type"},{"name":"Content","kind":12,"line":199},{"line":199,"name":"title","kind":12},{"line":200,"kind":12,"name":"notice"},{"name":"ali_width","kind":12,"line":201},{"containerName":"Request","kind":12,"name":"HTTP","line":209},{"line":209,"kind":12,"name":"GET"},{"children":[{"definition":"my","line":262,"name":"$self","localvar":"my","containerName":"result","kind":13},{"kind":13,"containerName":"result","name":"$value","line":262},{"definition":"my","name":"@scores","containerName":"result","localvar":"my","kind":13,"line":264},{"definition":"my","localvar":"my","containerName":"result","kind":13,"name":"@fts","line":265},{"line":267,"name":"$value","containerName":"result","kind":13},{"line":269,"containerName":"result","kind":13,"name":"$self"},{"definition":"my","kind":13,"localvar":"my","containerName":"result","name":"$result","line":270},{"containerName":"result","kind":12,"name":"new","line":270},{"kind":13,"containerName":"result","name":"$self","line":270},{"line":271,"kind":13,"localvar":"my","containerName":"result","name":"$line","definition":"my"},{"line":271,"containerName":"result","kind":13,"name":"$result"},{"line":272,"kind":13,"containerName":"result","name":"$line"},{"line":273,"name":"$line","kind":13,"containerName":"result"},{"name":"@scores","containerName":"result","kind":13,"line":274},{"line":280,"name":"$self","kind":13,"containerName":"result"},{"name":"@scores","kind":13,"containerName":"result","line":280},{"line":282,"kind":13,"containerName":"result","name":"$value"},{"name":"$self","kind":13,"containerName":"result","line":283},{"name":"_get_2ary_coords","kind":12,"containerName":"result","line":283},{"definition":"my","localvar":"my","kind":13,"containerName":"result","name":"$type","line":284},{"kind":13,"containerName":"result","name":"$self","line":284},{"name":"$type","kind":13,"containerName":"result","line":285},{"definition":"my","line":286,"name":"$loc","containerName":"result","localvar":"my","kind":13},{"line":286,"name":"$self","containerName":"result","kind":13},{"line":286,"kind":13,"containerName":"result","name":"$type"},{"containerName":"result","kind":13,"name":"@fts","line":287},{"name":"new","containerName":"result","kind":12,"line":288},{"line":288,"name":"$loc","kind":13,"containerName":"result"},{"line":289,"name":"$loc","containerName":"result","kind":13},{"containerName":"result","kind":13,"name":"$type","line":293},{"name":"$self","containerName":"result","kind":13,"line":294},{"name":"analysis_name","kind":12,"containerName":"result","line":294},{"kind":13,"containerName":"result","name":"$self","line":298},{"name":"@fts","containerName":"result","kind":13,"line":299}],"containerName":"main::","name":"result","definition":"sub","detail":"($self,$value)","line":261,"kind":12,"range":{"start":{"character":0,"line":261},"end":{"line":300,"character":9999}},"signature":{"label":"result($self,$value)","documentation":"1;\n# $Id: HNN.pm,v 1.0 2003/07/ 11\n#\n# BioPerl module for Bio::Tools::Analysis::Protein::HNN\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n\n=head1 NAME\n\nBio::Tools::Analysis::Protein::HNN - a wrapper around the HNN protein\nsecondary structure prediction server\n\n=head1  SYNOPSIS\n\n  use\tBio::Tools::Analysis::Protein::HNN;\n  #get a Bio::Seq or Bio::PrimarySeq\n  use Bio::PrimarySeq;\n  my $seq = Bio::PrimarySeq->new\n      (-seq=>'IKLCVHHJHJHJHJHJHJHNLAILAKAHLIELALAL',\n       -primary_id=>'test'); # a Bio::PrimarySeqI object\n\n  my $hnn = Bio::Tools::Analysis::Protein::HNN->new (-seq=>$seq);\n  $hnn->run;\n  print $hnn->result;# #raw text to standard error\n\n=head1  DESCRIPTION\t\n\nA module to remotely retrieve predictions of protein secondary\nstructure.  Each residue in the protein receives a score representing\nthe likelihood of existing in each of three different states (helix,\ncoil or sheet), e.g.:\n\n  my $analysis_object = Bio::Tools::SimpleAnalysis::Protein::HNN->new\n     (-seq => $seq);\n\ncreates a new object\n\n  $analysis_object->run;\n\nsubmits the query to the server and obtains raw text output.\n\nGiven an amino acid sequence the results can be obtained in 4 formats,\ndetermined by the argument to the result method:\n\n=over 4\n\n* 1\n\nThe raw text of the program output.\n\n  my $rawdata = $analysis_object->result;\t\t\t\t\n\n* 2\n\nA reference to an array of hashes of scores for each state and the\nassigned state.\n\n  my $data_ref = $analysis_object->result('parsed');\t\t\t\t\t\n  print \"score for helix at residue 2 is $data_ref->[1]{'helix'}\\n\";\t\n  print \"predicted struc  at residue 2 is $data_ref->[1]{'struc}\\n\";\n\n* 3\n\nAn array of Bio::SeqFeature::Generic objects where each feature is a\npredicted unit of secondary structure. Only stretches of helix/sheet\npredictions for longer than 4 residues are defined as helices.\n\n  my @fts = $analysis_object->result(Bio::SeqFeatureI);\n  for my $ft (@fts) {\t\t\n      print \" From \",  $ft->start, \" to  \",$ft->end, \" struc: \" ,\n             ($ft->each_tag_value('type'))[0]  ,\"\\n\";\n  }\n\n* 4\n\nA Bio::Seq::Meta::Array implementing sequence.\n\nThis is a Bio::Seq object that can also hold data about each residue\nin the sequence In this case, the sequence can be associated with a\nsingle array of HNN prediction scores.  e.g.,\n\n  my $meta_sequence = $analysis_object->result('meta');\n\n  print \"helix scores from residues 10-20 are \",\n      $meta_sequence->named_submeta_text(\"HNN_helix\",10,20), \"\\n\";\n\nMeta sequence default names are : HNN_helix, HNN_sheet, HNN_coil,\nHNN_struc, representing the scores for each residue.\n\nMany methods common to all analyses are inherited from\nL<Bio::Tools::Analysis::SimpleAnalysisBase>.\n\n\n=head1 SEE ALSO\n\nL<Bio::SimpleAnalysisI>, \nL<Bio::Tools::Analysis::SimpleAnalysisBase>, \nL<Bio::Seq::Meta::Array>, \nL<Bio::WebAgent>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk,\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\nuse strict;\n\npackage Bio::Tools::Analysis::Protein::HNN;\n\nuse IO::String;\nuse Bio::SeqIO;\nuse HTTP::Request::Common qw (POST);\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq::Meta::Array;\n\n\nuse base qw(Bio::Tools::Analysis::SimpleAnalysisBase);\n\n#extends array for 2struc.\n\nmy $URL = 'http://npsa-pbil.ibcp.fr/cgi-bin/secpred_hnn.pl';\nmy $ANALYSIS_NAME= 'HNN';\nmy $ANALYSIS_SPEC= {name => 'HNN', type => 'Protein'};\nmy $INPUT_SPEC = [\n                  { mandatory => 'true',\n                    type      => 'Bio::PrimarySeqI',\n                    'name'    => 'seq',\n                  },\n                 ];\nmy  $RESULT_SPEC =\n    {\n     ''                 => 'bulk',  # same as undef\n     'Bio::SeqFeatureI' => 'ARRAY of Bio::SeqFeature::Generic',\n     raw                => '[ {helix=>, sheet=>, struc=>, coil=>}]',\n     meta               => 'Bio::Seq::Meta::Array object',\n    };\nuse constant MIN_STRUC_LEN => 3; \n\nsub _init {\n    my $self = shift;\n    $self->url($URL);\n    $self->{'_ANALYSIS_SPEC'} = $ANALYSIS_SPEC;\n    $self->{'_INPUT_SPEC'}    = $INPUT_SPEC;\n    $self->{'_RESULT_SPEC'}   = $RESULT_SPEC;\n    $self->{'_ANALYSIS_NAME'} = $ANALYSIS_NAME;\n    return $self;\n}\n\n\nsub  _run {\n    my $self  = shift;\n    $self->delay(1);\n    # delay repeated calls by default by 3 sec, set delay() to change\n    $self->sleep;\n    $self->status('TERMINATED_BY_ERROR');\n    my $request = POST 'http://npsa-pbil.ibcp.fr/cgi-bin/secpred_hnn.pl',\n        Content_Type => 'form-data',\n            Content  => [title => \"\",\n                         notice => $self->seq->seq,\n                         ali_width => 70,\n                        ];\n\n    my $text = $self->request($request)->content;\n    return unless $text;\n    my ($next) = $text =~ /Prediction.*?=(.*?)>/;\n    return unless $next;\n    my $out = \"http://npsa-pbil.ibcp.fr/\".$next;\n    my $req2 = HTTP::Request->new(GET=>$out);\n    my $resp2 = $self->request ($req2);\n\t$self->status('COMPLETED') if $resp2 ne '';\n    $self->{'_result'} = $resp2->content;\n\treturn $self;\n}\n\n\n=head2 result\n\n NAme    : result\n Usage   : $job->result (...)\n Returns : a result created by running an analysis\n Args    : see keys of $INPUT_SPEC\n\nThe method returns a result of an executed job. If the job was\nterminated by an error the result may contain an error message instead\nof the real data.\n\nThis implementation returns differently processed data depending on\nargument:\n\n=over 3\n\n* undef\n\nReturns the raw ASCII data stream but without HTML tags.\n\n* 'Bio::SeqFeatureI'\n\nThe argument string defines the type of bioperl objects returned in an\narray.  The objects are L<Bio::SeqFeature::Generic>.  Feature primary\ntag is \"2ary\".  Feature tags are \"type\" (which can be helix, sheet or\ncoil) \"method\" (HNN).\n\n* 'parsed'\n\nArray of hash references of scores/structure assignations { helix =E<gt>,\nsheet =E<gt> , coil =E<gt> , struc=E<gt>}.\n\n* 'all'\n\nA Bio::Seq::Meta::Array object. Scores can be accessed using methods\nfrom this class. Meta sequence names are HNN_helix, HNN_sheet,\nHNN_coil, HNN_struc.","parameters":[{"label":"$self"},{"label":"$value"}]}},{"line":270,"kind":12,"containerName":"String","name":"IO"},{"name":"struc","kind":12,"line":274},{"kind":12,"name":"helix","line":275},{"kind":12,"name":"sheet","line":276},{"name":"coil","kind":12,"line":277},{"kind":12,"containerName":"SeqFeature::Generic","name":"Bio","line":287},{"kind":12,"name":"type","line":293},{"line":294,"kind":12,"name":"method"},{"line":302,"name":"%value","kind":13,"containerName":null},{"line":304,"name":"%type_scores","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"definition":"my","name":"$aa","kind":13,"localvar":"my","containerName":null,"line":305},{"line":305,"name":"%self","kind":13,"containerName":null},{"line":306,"kind":13,"containerName":null,"name":"%type_scores"},{"name":"%aa","kind":13,"containerName":null,"line":306},{"line":307,"kind":13,"containerName":null,"name":"%type_scores"},{"containerName":null,"kind":13,"name":"%aa","line":307},{"line":308,"kind":13,"containerName":null,"name":"%type_scores"},{"line":308,"name":"%aa","containerName":null,"kind":13},{"name":"%type_scores","containerName":null,"kind":13,"line":309},{"line":309,"name":"%aa","containerName":null,"kind":13},{"name":"$self","containerName":null,"kind":13,"line":313},{"kind":12,"containerName":"main::","name":"seq","line":313},{"kind":12,"containerName":"main::","name":"isa","line":313},{"containerName":null,"kind":13,"name":"$self","line":314},{"kind":12,"containerName":"main::","name":"seq","line":314},{"line":316,"name":"$self","containerName":null,"kind":13},{"line":316,"kind":12,"containerName":"main::","name":"seq"},{"name":"isa","containerName":"main::","kind":12,"line":316},{"name":"$self","containerName":null,"kind":13,"line":317},{"kind":12,"containerName":"main::","name":"throw","line":317},{"containerName":null,"kind":13,"name":"$Bio","line":320},{"kind":12,"containerName":"Meta::Array::DEFAULT_NAME","name":"Seq","line":320},{"line":321,"name":"$struc_type","localvar":"my","containerName":null,"kind":13,"definition":"my"},{"name":"%type_scores","containerName":null,"kind":13,"line":321},{"definition":"my","line":322,"containerName":null,"localvar":"my","kind":13,"name":"$meta_name"},{"kind":13,"localvar":"my","containerName":null,"name":"@meta","line":323,"definition":"my"},{"name":"$struc_type","containerName":null,"kind":13,"line":323},{"kind":13,"containerName":null,"name":"%self","line":323},{"name":"$meta_name","kind":13,"containerName":null,"line":324},{"line":324,"name":"$self","kind":13,"containerName":null},{"name":"seq","containerName":"main::","kind":12,"line":324},{"line":324,"kind":12,"containerName":"main::","name":"meta_names"},{"kind":13,"containerName":null,"name":"$self","line":325},{"line":325,"containerName":"main::","kind":12,"name":"warn"},{"kind":13,"containerName":null,"name":"$self","line":328},{"line":328,"name":"seq","kind":12,"containerName":"main::"},{"name":"named_meta","kind":12,"containerName":"main::","line":328},{"name":"$meta_name","kind":13,"containerName":null,"line":328},{"line":328,"name":"@meta","kind":13,"containerName":null},{"line":331,"kind":13,"containerName":null,"name":"$self"},{"line":331,"name":"seq","containerName":"main::","kind":12},{"name":"%self","kind":13,"containerName":null,"line":336},{"line":341,"kind":13,"containerName":null,"name":"%self"},{"kind":12,"range":{"end":{"character":9999,"line":352},"start":{"line":345,"character":0}},"line":345,"signature":{"label":"_get_2ary_coords($self)","documentation":"","parameters":[{"label":"$self"}]},"containerName":"main::","name":"_get_2ary_coords","children":[{"line":351,"name":"$self","containerName":"_get_2ary_coords","localvar":"my","kind":13,"definition":"my"},{"name":"@prot","localvar":"my","containerName":"_get_2ary_coords","kind":13,"line":352,"definition":"my"},{"name":"$self","containerName":"_get_2ary_coords","kind":13,"line":352}],"detail":"($self)","definition":"sub"},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"%Result","line":353},{"name":"$index","containerName":null,"localvar":"my","kind":13,"line":354,"definition":"my"},{"line":354,"name":"$index","containerName":null,"kind":13},{"name":"prot","kind":12,"line":354},{"name":"%index","kind":13,"containerName":null,"line":354},{"line":355,"name":"$type","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"name":"@prot","kind":13,"containerName":null,"line":355},{"line":355,"kind":13,"containerName":null,"name":"%index"},{"kind":13,"containerName":null,"name":"$type","line":356},{"line":357,"localvar":"my","kind":13,"containerName":null,"name":"$length","definition":"my"},{"line":358,"localvar":"my","kind":13,"containerName":null,"name":"$j","definition":"my"},{"line":358,"name":"$index","containerName":null,"kind":13},{"line":358,"containerName":null,"kind":13,"name":"$j"},{"name":"prot","kind":12,"line":358},{"line":358,"name":"%j","containerName":null,"kind":13},{"line":359,"name":"$test","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"containerName":null,"kind":13,"name":"@prot","line":359},{"name":"$j","kind":13,"containerName":null,"line":359},{"line":360,"containerName":null,"kind":13,"name":"%test"},{"kind":13,"containerName":null,"name":"%type","line":360},{"name":"$length","containerName":null,"kind":13,"line":361},{"name":"$length","kind":13,"containerName":null,"line":362},{"kind":12,"name":"MIN_STRUC_LEN","line":362},{"name":"$length","kind":13,"containerName":null,"line":363},{"line":363,"name":"MIN_STRUC_LEN","kind":12},{"line":363,"kind":13,"containerName":null,"name":"%type"},{"line":364,"containerName":null,"kind":13,"name":"%Result"},{"line":364,"name":"%type","containerName":null,"kind":13},{"name":"start","kind":12,"line":364},{"name":"$index","containerName":null,"kind":13,"line":364},{"name":"end","kind":12,"line":364},{"line":364,"name":"$j","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$index","line":365},{"name":"%length","kind":13,"containerName":null,"line":365},{"name":"$index","kind":13,"containerName":null,"line":368},{"line":368,"containerName":null,"kind":13,"name":"$length"},{"line":373,"name":"%self","containerName":null,"kind":13},{"line":373,"containerName":null,"kind":13,"name":"%Result"}]}