{"vars":[{"name":"Common","containerName":"strict::Bio::Tools::Analysis::Protein::GOR4::IO::String::Bio::SeqIO::HTTP::Request","kind":2,"line":152},{"line":157,"kind":2,"containerName":"","name":"base"},{"line":159,"name":"MIN_STRUC_LEN","containerName":"main::","kind":14,"definition":1},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"$URL","line":160},{"line":161,"name":"$ANALYSIS_NAME","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"line":162,"name":"%ANALYSIS_SPEC","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"line":162,"kind":12,"name":"name"},{"line":162,"kind":12,"name":"type"},{"definition":"my","line":163,"localvar":"my","containerName":null,"kind":13,"name":"@INPUT_SPEC"},{"line":164,"name":"mandatory","kind":12},{"kind":12,"name":"type","line":165},{"definition":"my","line":169,"name":"%RESULT_SPEC","containerName":null,"localvar":"my","kind":13},{"name":"raw","kind":12,"line":173},{"line":174,"name":"meta","kind":12},{"children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"result","line":222},{"kind":13,"containerName":"result","name":"$value","line":222},{"line":224,"localvar":"my","kind":13,"containerName":"result","name":"@scores","definition":"my"},{"name":"@fts","localvar":"my","kind":13,"containerName":"result","line":225,"definition":"my"},{"name":"$value","kind":13,"containerName":"result","line":227},{"name":"$self","kind":13,"containerName":"result","line":229},{"kind":13,"localvar":"my","containerName":"result","name":"$result","line":230,"definition":"my"},{"line":230,"name":"new","containerName":"result","kind":12},{"line":230,"name":"$self","containerName":"result","kind":13},{"name":"$line","localvar":"my","kind":13,"containerName":"result","line":231,"definition":"my"},{"line":231,"name":"$result","kind":13,"containerName":"result"},{"line":232,"name":"$line","kind":13,"containerName":"result"},{"line":233,"name":"$line","kind":13,"containerName":"result"},{"kind":13,"containerName":"result","name":"@scores","line":234},{"name":"$self","kind":13,"containerName":"result","line":240},{"containerName":"result","kind":13,"name":"@scores","line":240},{"name":"$value","kind":13,"containerName":"result","line":242},{"line":243,"kind":13,"containerName":"result","name":"$self"},{"line":243,"containerName":"result","kind":12,"name":"_get_2ary_coords"},{"definition":"my","name":"$type","localvar":"my","kind":13,"containerName":"result","line":244},{"line":244,"name":"$self","kind":13,"containerName":"result"},{"containerName":"result","kind":13,"name":"$type","line":245},{"line":246,"localvar":"my","containerName":"result","kind":13,"name":"$loc","definition":"my"},{"name":"$self","containerName":"result","kind":13,"line":246},{"line":246,"name":"$type","containerName":"result","kind":13},{"line":247,"containerName":"result","kind":13,"name":"@fts"},{"line":248,"containerName":"result","kind":12,"name":"new"},{"containerName":"result","kind":13,"name":"$loc","line":248},{"line":249,"containerName":"result","kind":13,"name":"$loc"},{"name":"$type","containerName":"result","kind":13,"line":253},{"line":254,"containerName":"result","kind":13,"name":"$self"},{"kind":12,"containerName":"result","name":"analysis_name","line":254},{"name":"$self","kind":13,"containerName":"result","line":258},{"line":259,"containerName":"result","kind":13,"name":"@fts"}],"name":"result","containerName":"main::","definition":"sub","detail":"($self,$value)","line":221,"kind":12,"range":{"start":{"character":0,"line":221},"end":{"character":9999,"line":260}},"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GOR4.pm,v 1.0 2003/07/ 11\n#\n# BioPerl module for Bio::Tools::Analysis::Protein::GOR4\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1  NAME\n\nBio::Tools::Analysis::Protein::GOR4 - a wrapper around GOR4 protein\nsecondary structure prediction server\n\n=head1  SYNOPSIS\n\n  use Bio::Tools::Analysis::Protein::GOR4;\n  #get a Bio::Seq or Bio::PrimarySeq\n  use Bio::PrimarySeq;\n  $seq = Bio::PrimarySeq->new\n    (-seq=>'IKLCVHHJHJHJHJHJHJHNLAILAKAHLIELALAL',\n     -primary_id=>'test'); # a Bio::PrimarySeqI object\n\n  my $gor4 = Bio::Tools::Analysis::Protein::GOR4->new (-seq=>$seq);\n  $gor4->run;\n  print $gor4->result;# #raw text to standard error\n\n=head1  DESCRIPTION\n\nA module to remotely retrieve predictions of protein secondary\nstructure.  Each residue in the protein receives a score representing\nthe likelihood of existing in each of three different states (helix,\ncoil or sheet), e.g.,\n\n  my $analysis_object = Bio::Tools::SimpleAnalysis::Protein::GOR4->\n      new(-seq => $seq);\n\ncreates a new object\n\n  $analysis_object->run;\n\nsubmits the query to the server and obtains raw text output\n\nGiven an amino acid sequence the results can be obtained in 4 formats,\ndetermined by the argument to the result method\n\n=over 4\n\n* 1\n\nThe raw text of the program output\n\n  my $rawdata = $analysis_object->result;\n\n* 2\n\nAn reference to an array of hashes of scores for each state and the\nassigned state.\n\n  my $data_ref = $analysis_object->result('parsed');\n  print \"score for helix at residue 2 is $data_ref->[1]{'helix'}\\n\";\n  print \"predicted struc  at residue 2 is $data_ref->[1]{'struc}\\n\";\n\n* 3\n\nAn array of Bio::SeqFeature::Generic objects where each feature is a\npredicted unit of secondary structure. Only stretches of helix/sheet\npredictions for longer than 4 residues are defined as helices. See \nBio::Tools::Analysis::Domcut.pm for examples of how to add sequence\nfeatures.\n\n  my @fts = $analysis_object->result(Bio::SeqFeatureI);\n  for my $ft (@fts) {\n      print \" From \",  $ft->start, \" to  \",$ft->end, \" struc: \" ,\n             ($ft->each_tag_value('type'))[0]  ,\"\\n\";\n  }\n\n* 4\n\nA Bio::Seq::Meta::Array implementing sequence.\n\nThis is a Bio::Seq object that can also hold data about each residue\nin the sequence In this case, the sequence can be associated with a\nsingle array of GOR4 prediction scores.  e.g.,\n\n  my $meta_sequence = $analysis_object->result('all');\n  print \"helix scores from residues 10-20 are \",\n      $meta_sequence->named_submeta_text(\"GOR4_helix\",10,20), \"\\n\";\n\nMeta sequence names are : GOR4_helix, GOR4_sheet, GOR4_coil,\nGOR4_struc, representing the scores for each residue.\n\nMany methods common to all analyses are inherited from\nBio::Tools::Analysis::SimpleAnalysisBase.\n\n\n=head1 SEE ALSO\n\nL<Bio::SimpleAnalysisI>, \nL<Bio::Tools::Analysis::SimpleAnalysisBase>, \nL<Bio::Seq::Meta::Array>, \nL<Bio::WebAgent>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk,\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\nuse strict;\n\npackage Bio::Tools::Analysis::Protein::GOR4;\n\nuse IO::String;\nuse Bio::SeqIO;\nuse HTTP::Request::Common qw(POST);\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq::Meta::Array;\n\n\nuse base qw(Bio::Tools::Analysis::SimpleAnalysisBase);\n\nuse constant MIN_STRUC_LEN => 3;\nmy $URL = 'http://npsa-pbil.ibcp.fr/cgi-bin/secpred_gor4.pl';\nmy $ANALYSIS_NAME = 'GOR4';\nmy $ANALYSIS_SPEC = {name => 'Gor4', type => 'Protein'};\nmy $INPUT_SPEC    = [\n                     {mandatory =>'true',\n                      type      => 'Bio::PrimarySeqI',\n                      'name'    => 'seq',\n                  },\n                 ];\nmy  $RESULT_SPEC =\n    {\n     ''                 => 'bulk',              # same as undef\n     'Bio::SeqFeatureI' => 'ARRAY of Bio::SeqFeature::Generic',\n     raw                => '[ {struc =>, helix=> ,sheet=>, coil=>}]',\n     meta                => 'Bio::Seq::Meta::Array object',\n    };\n\n=head2 result\n\n Name    : result\n Usage   : $job->result (...)\n Returns : a result created by running an analysis\n Args    : see keys of $RESULT_SPEC\n\nThe method returns a result of an executed job. If the job was\nterminated by an error the result may contain an error message instead\nof the real data.\n\nThis implementation returns differently processed data depending on\nargument:\n\n=over 3\n\n* undef\n\nReturns the raw ASCII data stream but without HTML tags\n\n* 'Bio::SeqFeatureI'\n\nThe argument string defines the type of bioperl objects returned in an\narray.  The objects are L<Bio::SeqFeature::Generic>.  Feature primary\ntag is \"2ary\".  Feature tags are \"type\" (which can be helix, sheet or\ncoil) \"method\" (GOR4).\n\n* 'parsed'\n\nArray of hash references of { helix =E<gt>, sheet =E<gt> , coil =E<gt> , struc=E<gt>}.\n\n* 'meta'\n\nA Bio::Seq::Meta::Array object. Scores can be accessed using methods\nfrom this class. Meta sequence names are GOR4_helix, GOR4_sheet,\nGOR4_coil, GOR4_struc.","label":"result($self,$value)"}},{"name":"IO","kind":12,"containerName":"String","line":230},{"kind":12,"name":"struc","line":234},{"line":235,"name":"helix","kind":12},{"name":"sheet","kind":12,"line":236},{"name":"coil","kind":12,"line":237},{"line":247,"containerName":"SeqFeature::Generic","kind":12,"name":"Bio"},{"name":"type","kind":12,"line":253},{"kind":12,"name":"method","line":254},{"name":"%value","containerName":null,"kind":13,"line":262},{"definition":"my","line":264,"containerName":null,"localvar":"my","kind":13,"name":"%type_scores"},{"line":265,"name":"$aa","localvar":"my","containerName":null,"kind":13,"definition":"my"},{"name":"%self","containerName":null,"kind":13,"line":265},{"name":"%type_scores","containerName":null,"kind":13,"line":266},{"line":266,"containerName":null,"kind":13,"name":"%aa"},{"containerName":null,"kind":13,"name":"%type_scores","line":267},{"line":267,"name":"%aa","containerName":null,"kind":13},{"line":268,"containerName":null,"kind":13,"name":"%type_scores"},{"name":"%aa","containerName":null,"kind":13,"line":268},{"line":269,"kind":13,"containerName":null,"name":"%type_scores"},{"name":"%aa","containerName":null,"kind":13,"line":269},{"line":273,"name":"$self","containerName":null,"kind":13},{"line":273,"kind":12,"containerName":"main::","name":"seq"},{"name":"isa","containerName":"main::","kind":12,"line":273},{"line":274,"name":"$self","kind":13,"containerName":null},{"kind":12,"containerName":"main::","name":"seq","line":274},{"line":276,"name":"$self","kind":13,"containerName":null},{"line":276,"kind":12,"containerName":"main::","name":"seq"},{"line":276,"name":"isa","kind":12,"containerName":"main::"},{"name":"$self","containerName":null,"kind":13,"line":277},{"name":"throw","containerName":"main::","kind":12,"line":277},{"line":278,"kind":13,"containerName":null,"name":"$Bio"},{"line":278,"containerName":"Meta::Array::DEFAULT_NAME","kind":12,"name":"Seq"},{"definition":"my","line":281,"localvar":"my","kind":13,"containerName":null,"name":"$struc_type"},{"line":281,"kind":13,"containerName":null,"name":"%type_scores"},{"definition":"my","line":282,"name":"$meta_name","kind":13,"localvar":"my","containerName":null},{"definition":"my","line":283,"kind":13,"localvar":"my","containerName":null,"name":"@meta"},{"line":283,"containerName":null,"kind":13,"name":"$struc_type"},{"name":"%self","containerName":null,"kind":13,"line":283},{"kind":13,"containerName":null,"name":"$meta_name","line":284},{"containerName":null,"kind":13,"name":"$self","line":284},{"name":"seq","kind":12,"containerName":"main::","line":284},{"name":"meta_names","kind":12,"containerName":"main::","line":284},{"line":285,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"containerName":"main::","name":"warn","line":285},{"kind":13,"containerName":null,"name":"$self","line":288},{"line":288,"name":"seq","containerName":"main::","kind":12},{"kind":12,"containerName":"main::","name":"named_meta","line":288},{"name":"$meta_name","kind":13,"containerName":null,"line":288},{"name":"@meta","containerName":null,"kind":13,"line":288},{"line":291,"name":"$self","kind":13,"containerName":null},{"containerName":"main::","kind":12,"name":"seq","line":291},{"kind":13,"containerName":null,"name":"%self","line":295},{"containerName":null,"kind":13,"name":"%self","line":300},{"name":"_get_2ary_coords","containerName":"main::","children":[{"definition":"my","line":310,"name":"$self","localvar":"my","containerName":"_get_2ary_coords","kind":13},{"line":311,"name":"@prot","localvar":"my","containerName":"_get_2ary_coords","kind":13,"definition":"my"},{"name":"$self","containerName":"_get_2ary_coords","kind":13,"line":311}],"detail":"($self)","definition":"sub","kind":12,"range":{"end":{"line":311,"character":9999},"start":{"character":0,"line":303}},"line":303,"signature":{"label":"_get_2ary_coords($self)","parameters":[{"label":"$self"}],"documentation":""}},{"kind":13,"localvar":"my","containerName":null,"name":"%Result","line":312,"definition":"my"},{"line":313,"name":"$index","localvar":"my","containerName":null,"kind":13,"definition":"my"},{"containerName":null,"kind":13,"name":"$index","line":313},{"kind":12,"name":"prot","line":313},{"name":"%index","kind":13,"containerName":null,"line":313},{"definition":"my","line":315,"name":"$type","localvar":"my","containerName":null,"kind":13},{"line":315,"name":"@prot","containerName":null,"kind":13},{"line":315,"containerName":null,"kind":13,"name":"%index"},{"line":316,"name":"$type","containerName":null,"kind":13},{"name":"$length","localvar":"my","containerName":null,"kind":13,"line":317,"definition":"my"},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"$j","line":318},{"line":318,"name":"$index","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$j","line":318},{"line":318,"kind":12,"name":"prot"},{"containerName":null,"kind":13,"name":"%j","line":318},{"definition":"my","name":"$test","localvar":"my","kind":13,"containerName":null,"line":319},{"kind":13,"containerName":null,"name":"@prot","line":319},{"name":"$j","kind":13,"containerName":null,"line":319},{"line":320,"kind":13,"containerName":null,"name":"%test"},{"line":320,"name":"%type","kind":13,"containerName":null},{"line":321,"name":"$length","kind":13,"containerName":null},{"name":"$length","containerName":null,"kind":13,"line":322},{"line":322,"name":"MIN_STRUC_LEN","kind":12},{"kind":13,"containerName":null,"name":"$length","line":323},{"line":323,"kind":12,"name":"MIN_STRUC_LEN"},{"name":"%type","kind":13,"containerName":null,"line":323},{"name":"%Result","kind":13,"containerName":null,"line":324},{"name":"%type","containerName":null,"kind":13,"line":324},{"kind":12,"name":"start","line":324},{"name":"$index","kind":13,"containerName":null,"line":324},{"line":324,"name":"end","kind":12},{"name":"$j","kind":13,"containerName":null,"line":324},{"line":325,"name":"$index","containerName":null,"kind":13},{"line":325,"kind":13,"containerName":null,"name":"%length"},{"name":"$index","containerName":null,"kind":13,"line":328},{"line":328,"containerName":null,"kind":13,"name":"$length"},{"kind":13,"containerName":null,"name":"%self","line":333},{"name":"%Result","kind":13,"containerName":null,"line":333},{"line":336,"kind":12,"range":{"start":{"character":0,"line":336},"end":{"line":344,"character":9999}},"children":[{"definition":"my","name":"$self","localvar":"my","containerName":"_init","kind":13,"line":337},{"line":338,"name":"$self","containerName":"_init","kind":13},{"name":"url","containerName":"_init","kind":12,"line":338},{"containerName":"_init","kind":13,"name":"$URL","line":338},{"kind":13,"containerName":"_init","name":"$self","line":339},{"name":"$ANALYSIS_SPEC","containerName":"_init","kind":13,"line":339},{"containerName":"_init","kind":13,"name":"$self","line":340},{"line":340,"name":"$INPUT_SPEC","kind":13,"containerName":"_init"},{"containerName":"_init","kind":13,"name":"$self","line":341},{"line":341,"containerName":"_init","kind":13,"name":"$RESULT_SPEC"},{"name":"$self","containerName":"_init","kind":13,"line":342},{"line":342,"kind":13,"containerName":"_init","name":"$ANALYSIS_NAME"},{"line":343,"containerName":"_init","kind":13,"name":"$self"}],"containerName":"main::","name":"_init","definition":"sub"},{"name":"_run","containerName":"main::","children":[{"definition":"my","line":348,"localvar":"my","containerName":"_run","kind":13,"name":"$self"},{"line":349,"name":"$self","containerName":"_run","kind":13},{"containerName":"_run","kind":12,"name":"delay","line":349},{"line":351,"containerName":"_run","kind":13,"name":"$self"},{"line":351,"name":"sleep","kind":12,"containerName":"_run"},{"name":"$self","kind":13,"containerName":"_run","line":352},{"containerName":"_run","kind":12,"name":"status","line":352},{"line":353,"localvar":"my","containerName":"_run","kind":13,"name":"$request","definition":"my"},{"name":"$self","kind":13,"containerName":"_run","line":353},{"line":353,"containerName":"_run","kind":12,"name":"url"},{"containerName":"_run","kind":13,"name":"$self","line":356},{"name":"seq","containerName":"_run","kind":12,"line":356},{"name":"seq","containerName":"_run","kind":12,"line":356},{"line":360,"localvar":"my","containerName":"_run","kind":13,"name":"$content","definition":"my"},{"line":360,"containerName":"_run","kind":13,"name":"$self"},{"name":"request","containerName":"_run","kind":12,"line":360},{"name":"$request","containerName":"_run","kind":13,"line":360},{"name":"$text","localvar":"my","kind":13,"containerName":"_run","line":361,"definition":"my"},{"name":"$content","containerName":"_run","kind":13,"line":361},{"line":361,"kind":12,"containerName":"_run","name":"content"},{"line":362,"kind":13,"containerName":"_run","name":"$text"},{"line":363,"name":"$next","localvar":"my","containerName":"_run","kind":13,"definition":"my"},{"containerName":"_run","kind":13,"name":"$text","line":363},{"name":"$next","kind":13,"containerName":"_run","line":364},{"name":"$out","kind":13,"localvar":"my","containerName":"_run","line":365,"definition":"my"},{"line":365,"containerName":"_run","kind":13,"name":"$next"},{"name":"$req2","localvar":"my","kind":13,"containerName":"_run","line":366,"definition":"my"},{"line":366,"containerName":"_run","kind":12,"name":"new"},{"name":"$out","containerName":"_run","kind":13,"line":366},{"definition":"my","containerName":"_run","localvar":"my","kind":13,"name":"$resp2","line":367},{"line":367,"containerName":"_run","kind":13,"name":"$self"},{"name":"request","kind":12,"containerName":"_run","line":367},{"line":367,"name":"$req2","kind":13,"containerName":"_run"},{"kind":13,"containerName":"_run","name":"$self","line":368},{"name":"status","kind":12,"containerName":"_run","line":368},{"name":"$resp2","kind":13,"containerName":"_run","line":368},{"name":"$self","kind":13,"containerName":"_run","line":369},{"line":369,"name":"$resp2","kind":13,"containerName":"_run"},{"name":"content","containerName":"_run","kind":12,"line":369}],"definition":"sub","range":{"start":{"character":0,"line":347},"end":{"line":370,"character":9999}},"kind":12,"line":347},{"line":353,"name":"POST","kind":12},{"line":354,"kind":12,"name":"Content_Type"},{"line":355,"kind":12,"name":"Content"},{"line":355,"name":"title","kind":12},{"name":"notice","kind":12,"line":356},{"line":357,"name":"ali_width","kind":12},{"name":"HTTP","containerName":"Request","kind":12,"line":366},{"kind":12,"name":"GET","line":366}],"version":5}