{"vars":[{"line":154,"name":"base","kind":2,"containerName":""},{"detail":"($class,@args)","definition":"sub","name":"new","containerName":"main::","children":[{"line":181,"localvar":"my","kind":13,"containerName":"new","name":"$class","definition":"my"},{"line":181,"kind":13,"containerName":"new","name":"@args"},{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"new","line":182},{"line":182,"name":"$class","containerName":"new","kind":13},{"line":182,"name":"@args","containerName":"new","kind":13},{"definition":"my","name":"$name","localvar":"my","containerName":"new","kind":13,"line":183},{"kind":13,"containerName":"new","name":"$id","line":183},{"line":183,"kind":13,"containerName":"new","name":"$objid"},{"line":183,"name":"$rank","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$div","line":183},{"name":"$dbh","kind":13,"containerName":"new","line":183},{"line":183,"name":"$ncbitaxid","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$commonname","line":183},{"name":"$commonnames","containerName":"new","kind":13,"line":184},{"containerName":"new","kind":13,"name":"$gcode","line":184},{"line":184,"name":"$mitocode","kind":13,"containerName":"new"},{"name":"$createdate","containerName":"new","kind":13,"line":184},{"line":184,"containerName":"new","kind":13,"name":"$updatedate"},{"name":"$pubdate","containerName":"new","kind":13,"line":184},{"line":185,"kind":13,"containerName":"new","name":"$parent_id"},{"name":"$self","containerName":"new","kind":13,"line":185},{"line":185,"name":"_rearrange","kind":12,"containerName":"new"},{"kind":13,"containerName":"new","name":"@args","line":189},{"line":191,"name":"$id","kind":13,"containerName":"new"},{"line":191,"kind":13,"containerName":"new","name":"$ncbitaxid"},{"line":191,"name":"$ncbitaxid","kind":13,"containerName":"new"},{"line":191,"containerName":"new","kind":13,"name":"$id"},{"name":"$objid","kind":13,"containerName":"new","line":191},{"line":191,"kind":13,"containerName":"new","name":"$objid"},{"containerName":"new","kind":13,"name":"$id","line":191},{"containerName":"new","kind":13,"name":"$self","line":192},{"name":"warn","kind":12,"containerName":"new","line":192},{"line":194,"name":"$id","kind":13,"containerName":"new"},{"line":195,"containerName":"new","kind":13,"name":"$id"},{"line":195,"name":"$objid","kind":13,"containerName":"new"},{"line":195,"kind":13,"containerName":"new","name":"$ncbitaxid"},{"name":"$id","kind":13,"containerName":"new","line":197},{"line":197,"kind":13,"containerName":"new","name":"$self"},{"line":197,"containerName":"new","kind":12,"name":"id"},{"name":"$id","containerName":"new","kind":13,"line":197},{"name":"$self","kind":13,"containerName":"new","line":198},{"kind":13,"containerName":"new","name":"$ncbitaxid","line":198},{"line":200,"containerName":"new","kind":13,"name":"$rank"},{"line":200,"name":"$self","containerName":"new","kind":13},{"name":"rank","kind":12,"containerName":"new","line":200},{"name":"$rank","containerName":"new","kind":13,"line":200},{"kind":13,"containerName":"new","name":"$name","line":201},{"line":201,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"containerName":"new","name":"node_name","line":201},{"line":201,"name":"$name","kind":13,"containerName":"new"},{"line":203,"name":"@common_names","localvar":"my","containerName":"new","kind":13,"definition":"my"},{"kind":13,"containerName":"new","name":"$commonnames","line":204},{"containerName":"new","kind":13,"name":"$self","line":205},{"containerName":"new","kind":12,"name":"throw","line":205},{"line":206,"name":"$commonnames","kind":13,"containerName":"new"},{"line":206,"name":"$commonnames","containerName":"new","kind":13},{"line":207,"name":"@common_names","containerName":"new","kind":13},{"name":"$commonnames","containerName":"new","kind":13,"line":207}],"signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: Taxon.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Taxon\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala, based heavily on a module by Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxon - A node in a represented taxonomy\n\n=head1 SYNOPSIS\n\n  use Bio::Taxon;\n\n  # Typically you will get a Taxon from a Bio::DB::Taxonomy object\n  # but here is how you initialize one\n  my $taxon = Bio::Taxon->new(-name      => $name,\n                             -id        => $id,\n                             -rank      => $rank,\n                             -division  => $div);\n\n  # Get one from a database\n  my $dbh = Bio::DB::Taxonomy->new(-source   => 'flatfile',\n                                  -directory=> '/tmp',\n                                  -nodesfile=> '/path/to/nodes.dmp',\n                                  -namesfile=> '/path/to/names.dmp');\n  my $human = $dbh->get_taxon(-name => 'Homo sapiens');\n  $human = $dbh->get_taxon(-taxonid => '9606');\n\n  print \"id is \", $human->id, \"\\n\"; # 9606\n  print \"rank is \", $human->rank, \"\\n\"; # species\n  print \"scientific name is \", $human->scientific_name, \"\\n\"; # Homo sapiens\n  print \"division is \", $human->division, \"\\n\"; # Primates\n\n  my $mouse = $dbh->get_taxon(-name => 'Mus musculus');\n\n  # You can quickly make your own lineages with the list database\n  my @ranks = qw(superkingdom class genus species);\n  my @h_lineage = ('Eukaryota', 'Mammalia', 'Homo', 'Homo sapiens');\n  my $list_dbh = Bio::DB::Taxonomy->new(-source => 'list', -names => \\@h_lineage,\n                                                          -ranks => \\@ranks);\n  $human = $list_dbh->get_taxon(-name => 'Homo sapiens');\n  my @names = $human->common_names; # @names is empty\n  $human->common_names('woman');\n  @names = $human->common_names; # @names contains woman\n\n  # You can switch to another database when you need more information\n  my $entrez_dbh = Bio::DB::Taxonomy->new(-source => 'entrez');\n  $human->db_handle($entrez_dbh);\n  @names = $human->common_names; # @names contains woman, human, man\n\n  # Since Bio::Taxon implements Bio::Tree::NodeI, we have access to those\n  # methods (and can manually create our own taxa and taxonomy without the use\n  # of any database)\n  my $homo = $human->ancestor;\n\n  # Though be careful with each_Descendent - unless you add_Descendent()\n  # yourself, you won't get an answer because unlike for ancestor(), Bio::Taxon\n  # does not ask the database for the answer. You can ask the database yourself\n  # using the same method:\n  ($human) = $homo->db_handle->each_Descendent($homo);\n\n  # We can also take advantage of Bio::Tree::Tree* methods:\n  # a) some methods are available with just an empty tree object\n  use Bio::Tree::Tree;\n  my $tree_functions = Bio::Tree::Tree->new();\n  my @lineage = $tree_functions->get_lineage_nodes($human);\n  my $lca = $tree_functions->get_lca($human, $mouse);\n\n  # b) for other methods, create a tree using your Taxon object\n  my $tree = Bio::Tree::Tree->new(-node => $human);\n  my @taxa = $tree->get_nodes;\n  $homo = $tree->find_node(-rank => 'genus');\n\n  # Normally you can't get the lca of a list-database derived Taxon and an\n  # entrez or flatfile-derived one because the two different databases might\n  # have different roots and different numbers of ranks between the root and the\n  # taxa of interest. To solve this, make a tree of the Taxon with the more\n  # detailed lineage and splice out all the taxa that won't be in the lineage of\n  # your other Taxon:\n  my $entrez_mouse = $entrez_dbh->get_taxon(-name => 'Mus musculus');\n  my $list_human = $list_dbh->get_taxon(-name => 'Homo sapiens');\n  my $mouse_tree = Bio::Tree::Tree->new(-node => $entrez_mouse);\n  $mouse_tree->splice(-keep_rank => \\@ranks);\n  $lca = $mouse_tree->get_lca($entrez_mouse, $list_human);\n\n=head1 DESCRIPTION\n\nThis is the next generation (for Bioperl) of representing Taxonomy\ninformation. Previously all information was managed by a single\nobject called Bio::Species. This new implementation allows\nrepresentation of the intermediate nodes not just the species nodes\nand can relate their connections.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich,    jason-at-bioperl-dot-org (original Bio::Taxonomy::Node)\nJuguang Xiao,     juguang@tll.org.sg\nGabriel Valiente, valiente@lsi.upc.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Taxon;\nuse strict;\n\nuse Bio::DB::Taxonomy;\n\nuse base qw(Bio::Tree::Node Bio::IdentifiableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Node->new();\n Function: Builds a new Bio::Taxonomy::Node object \n Returns : an instance of Bio::Taxonomy::Node\n Args    : -dbh               => a reference to a Bio::DB::Taxonomy object\n                                 [no default]\n           -name              => a string representing the taxon name\n                                 (scientific name)\n           -id                => human readable id - typically NCBI taxid\n           -ncbi_taxid        => same as -id, but explicitely say that it is an\n                                 NCBI taxid\n           -rank              => node rank (one of 'species', 'genus', etc)\n           -common_names      => array ref of all common names\n           -division          => 'Primates', 'Rodents', etc\n           -genetic_code      => genetic code table number\n           -mito_genetic_code => mitochondrial genetic code table number\n           -create_date       => date created in database\n           -update_date       => date last updated in database\n           -pub_date          => date published in database","parameters":[{"label":"$class"},{"label":"@args"}]},"range":{"start":{"character":0,"line":180},"end":{"line":208,"character":9999}},"kind":12,"line":180},{"line":182,"name":"SUPER","containerName":"new","kind":12},{"name":"_ncbi_tax_id_provided","kind":12,"line":198},{"line":209,"name":"%commonname","kind":13,"containerName":null},{"definition":"my","line":210,"containerName":null,"localvar":"my","kind":13,"name":"%c_names"},{"line":210,"kind":13,"containerName":null,"name":"@common_names"},{"line":211,"kind":13,"containerName":null,"name":"%c_names"},{"name":"%commonname","kind":13,"containerName":null,"line":211},{"containerName":null,"kind":13,"name":"@common_names","line":212},{"line":212,"containerName":null,"kind":13,"name":"$commonname"},{"line":215,"containerName":null,"kind":13,"name":"@common_names"},{"name":"$self","containerName":null,"kind":13,"line":215},{"line":215,"containerName":"main::","kind":12,"name":"common_names"},{"name":"@common_names","kind":13,"containerName":null,"line":215},{"line":217,"name":"$gcode","kind":13,"containerName":null},{"name":"$self","containerName":null,"kind":13,"line":217},{"line":217,"name":"genetic_code","containerName":"main::","kind":12},{"name":"$gcode","kind":13,"containerName":null,"line":217},{"line":218,"kind":13,"containerName":null,"name":"$mitocode"},{"name":"$self","containerName":null,"kind":13,"line":218},{"containerName":"main::","kind":12,"name":"mitochondrial_genetic_code","line":218},{"containerName":null,"kind":13,"name":"$mitocode","line":218},{"line":219,"kind":13,"containerName":null,"name":"$createdate"},{"line":219,"containerName":null,"kind":13,"name":"$self"},{"line":219,"name":"create_date","containerName":"main::","kind":12},{"line":219,"name":"$createdate","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$updatedate","line":220},{"name":"$self","containerName":null,"kind":13,"line":220},{"line":220,"name":"update_date","kind":12,"containerName":"main::"},{"name":"$updatedate","kind":13,"containerName":null,"line":220},{"name":"$pubdate","kind":13,"containerName":null,"line":221},{"name":"$self","kind":13,"containerName":null,"line":221},{"name":"pub_date","kind":12,"containerName":"main::","line":221},{"line":221,"name":"$pubdate","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$div","line":222},{"kind":13,"containerName":null,"name":"$self","line":222},{"line":222,"name":"division","containerName":"main::","kind":12},{"name":"$div","containerName":null,"kind":13,"line":222},{"line":223,"name":"$dbh","kind":13,"containerName":null},{"line":223,"kind":13,"containerName":null,"name":"$self"},{"name":"db_handle","containerName":"main::","kind":12,"line":223},{"line":223,"kind":13,"containerName":null,"name":"$dbh"},{"line":227,"kind":13,"containerName":null,"name":"$parent_id"},{"line":227,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"containerName":"main::","name":"parent_id","line":227},{"line":227,"containerName":null,"kind":13,"name":"$parent_id"},{"line":231,"name":"%self","containerName":null,"kind":13},{"name":"_root_cleanup_methods","kind":12,"line":231},{"kind":13,"containerName":null,"name":"$self","line":233},{"line":249,"kind":12,"range":{"start":{"character":0,"line":249},"end":{"line":253,"character":9999}},"children":[{"definition":"my","line":250,"name":"$self","containerName":"version","localvar":"my","kind":13},{"containerName":"version","kind":13,"name":"$self","line":251},{"line":252,"kind":13,"containerName":"version","name":"$self"}],"containerName":"main::","name":"version","definition":"sub"},{"line":264,"kind":12,"range":{"start":{"character":0,"line":264},"end":{"line":268,"character":9999}},"definition":"sub","children":[{"localvar":"my","kind":13,"containerName":"authority","name":"$self","line":265,"definition":"my"},{"line":266,"name":"$self","containerName":"authority","kind":13},{"line":267,"kind":13,"containerName":"authority","name":"$self"}],"containerName":"main::","name":"authority"},{"line":279,"kind":12,"range":{"end":{"line":283,"character":9999},"start":{"line":279,"character":0}},"definition":"sub","children":[{"kind":13,"localvar":"my","containerName":"namespace","name":"$self","line":280,"definition":"my"},{"kind":13,"containerName":"namespace","name":"$self","line":281},{"name":"$self","kind":13,"containerName":"namespace","line":282}],"name":"namespace","containerName":"main::"},{"children":[{"line":300,"kind":13,"localvar":"my","containerName":"db_handle","name":"$self","definition":"my"},{"definition":"my","localvar":"my","containerName":"db_handle","kind":13,"name":"$db","line":302},{"line":304,"name":"$db","kind":13,"containerName":"db_handle"},{"kind":13,"containerName":"db_handle","name":"$db","line":304},{"line":304,"name":"isa","containerName":"db_handle","kind":12},{"containerName":"db_handle","kind":13,"name":"$self","line":305},{"line":305,"containerName":"db_handle","kind":12,"name":"throw"},{"name":"$self","kind":13,"containerName":"db_handle","line":307},{"line":307,"name":"$self","containerName":"db_handle","kind":13},{"line":307,"kind":13,"containerName":"db_handle","name":"$self"},{"name":"$db","containerName":"db_handle","kind":13,"line":307},{"name":"$new_self","containerName":"db_handle","localvar":"my","kind":13,"line":308,"definition":"my"},{"name":"$self","kind":13,"containerName":"db_handle","line":308},{"line":308,"name":"_get_similar_taxon_from_db","containerName":"db_handle","kind":12},{"line":308,"containerName":"db_handle","kind":13,"name":"$self"},{"kind":13,"containerName":"db_handle","name":"$db","line":308},{"name":"$self","kind":13,"containerName":"db_handle","line":309},{"containerName":"db_handle","kind":12,"name":"_merge_taxa","line":309},{"line":309,"kind":13,"containerName":"db_handle","name":"$new_self"},{"name":"$new_self","containerName":"db_handle","kind":13,"line":309},{"name":"$self","kind":13,"containerName":"db_handle","line":314},{"kind":13,"containerName":"db_handle","name":"$db","line":314},{"kind":13,"containerName":"db_handle","name":"$self","line":316}],"containerName":"main::","name":"db_handle","definition":"sub","line":299,"kind":12,"range":{"start":{"character":0,"line":299},"end":{"line":317,"character":9999}}},{"containerName":"main::","name":"rank","children":[{"line":330,"name":"$self","kind":13,"localvar":"my","containerName":"rank","definition":"my"},{"line":331,"name":"$self","containerName":"rank","kind":13},{"kind":13,"containerName":"rank","name":"$self","line":332}],"definition":"sub","range":{"end":{"line":333,"character":9999},"start":{"line":329,"character":0}},"kind":12,"line":329},{"kind":12,"range":{"end":{"line":349,"character":9999},"start":{"line":346,"character":0}},"line":346,"name":"id","containerName":"main::","children":[{"definition":"my","line":347,"localvar":"my","kind":13,"containerName":"id","name":"$self"},{"line":348,"name":"$self","kind":13,"containerName":"id"}],"definition":"sub"},{"line":348,"kind":12,"containerName":"id","name":"SUPER"},{"definition":"sub","detail":"($self,$id)","children":[{"line":366,"name":"$self","localvar":"my","kind":13,"containerName":"ncbi_taxid","definition":"my"},{"line":366,"kind":13,"containerName":"ncbi_taxid","name":"$id"},{"line":368,"containerName":"ncbi_taxid","kind":13,"name":"$id"},{"line":369,"containerName":"ncbi_taxid","kind":13,"name":"$self"},{"line":370,"containerName":"ncbi_taxid","kind":13,"name":"$self"},{"line":370,"name":"$id","containerName":"ncbi_taxid","kind":13},{"line":373,"name":"$self","kind":13,"containerName":"ncbi_taxid"},{"name":"$self","kind":13,"containerName":"ncbi_taxid","line":374}],"name":"ncbi_taxid","containerName":"main::","signature":{"label":"ncbi_taxid($self,$id)","documentation":"1;\n# $Id: Taxon.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Taxon\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala, based heavily on a module by Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxon - A node in a represented taxonomy\n\n=head1 SYNOPSIS\n\n  use Bio::Taxon;\n\n  # Typically you will get a Taxon from a Bio::DB::Taxonomy object\n  # but here is how you initialize one\n  my $taxon = Bio::Taxon->new(-name      => $name,\n                             -id        => $id,\n                             -rank      => $rank,\n                             -division  => $div);\n\n  # Get one from a database\n  my $dbh = Bio::DB::Taxonomy->new(-source   => 'flatfile',\n                                  -directory=> '/tmp',\n                                  -nodesfile=> '/path/to/nodes.dmp',\n                                  -namesfile=> '/path/to/names.dmp');\n  my $human = $dbh->get_taxon(-name => 'Homo sapiens');\n  $human = $dbh->get_taxon(-taxonid => '9606');\n\n  print \"id is \", $human->id, \"\\n\"; # 9606\n  print \"rank is \", $human->rank, \"\\n\"; # species\n  print \"scientific name is \", $human->scientific_name, \"\\n\"; # Homo sapiens\n  print \"division is \", $human->division, \"\\n\"; # Primates\n\n  my $mouse = $dbh->get_taxon(-name => 'Mus musculus');\n\n  # You can quickly make your own lineages with the list database\n  my @ranks = qw(superkingdom class genus species);\n  my @h_lineage = ('Eukaryota', 'Mammalia', 'Homo', 'Homo sapiens');\n  my $list_dbh = Bio::DB::Taxonomy->new(-source => 'list', -names => \\@h_lineage,\n                                                          -ranks => \\@ranks);\n  $human = $list_dbh->get_taxon(-name => 'Homo sapiens');\n  my @names = $human->common_names; # @names is empty\n  $human->common_names('woman');\n  @names = $human->common_names; # @names contains woman\n\n  # You can switch to another database when you need more information\n  my $entrez_dbh = Bio::DB::Taxonomy->new(-source => 'entrez');\n  $human->db_handle($entrez_dbh);\n  @names = $human->common_names; # @names contains woman, human, man\n\n  # Since Bio::Taxon implements Bio::Tree::NodeI, we have access to those\n  # methods (and can manually create our own taxa and taxonomy without the use\n  # of any database)\n  my $homo = $human->ancestor;\n\n  # Though be careful with each_Descendent - unless you add_Descendent()\n  # yourself, you won't get an answer because unlike for ancestor(), Bio::Taxon\n  # does not ask the database for the answer. You can ask the database yourself\n  # using the same method:\n  ($human) = $homo->db_handle->each_Descendent($homo);\n\n  # We can also take advantage of Bio::Tree::Tree* methods:\n  # a) some methods are available with just an empty tree object\n  use Bio::Tree::Tree;\n  my $tree_functions = Bio::Tree::Tree->new();\n  my @lineage = $tree_functions->get_lineage_nodes($human);\n  my $lca = $tree_functions->get_lca($human, $mouse);\n\n  # b) for other methods, create a tree using your Taxon object\n  my $tree = Bio::Tree::Tree->new(-node => $human);\n  my @taxa = $tree->get_nodes;\n  $homo = $tree->find_node(-rank => 'genus');\n\n  # Normally you can't get the lca of a list-database derived Taxon and an\n  # entrez or flatfile-derived one because the two different databases might\n  # have different roots and different numbers of ranks between the root and the\n  # taxa of interest. To solve this, make a tree of the Taxon with the more\n  # detailed lineage and splice out all the taxa that won't be in the lineage of\n  # your other Taxon:\n  my $entrez_mouse = $entrez_dbh->get_taxon(-name => 'Mus musculus');\n  my $list_human = $list_dbh->get_taxon(-name => 'Homo sapiens');\n  my $mouse_tree = Bio::Tree::Tree->new(-node => $entrez_mouse);\n  $mouse_tree->splice(-keep_rank => \\@ranks);\n  $lca = $mouse_tree->get_lca($entrez_mouse, $list_human);\n\n=head1 DESCRIPTION\n\nThis is the next generation (for Bioperl) of representing Taxonomy\ninformation. Previously all information was managed by a single\nobject called Bio::Species. This new implementation allows\nrepresentation of the intermediate nodes not just the species nodes\nand can relate their connections.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich,    jason-at-bioperl-dot-org (original Bio::Taxonomy::Node)\nJuguang Xiao,     juguang@tll.org.sg\nGabriel Valiente, valiente@lsi.upc.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Taxon;\nuse strict;\n\nuse Bio::DB::Taxonomy;\n\nuse base qw(Bio::Tree::Node Bio::IdentifiableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Node->new();\n Function: Builds a new Bio::Taxonomy::Node object \n Returns : an instance of Bio::Taxonomy::Node\n Args    : -dbh               => a reference to a Bio::DB::Taxonomy object\n                                 [no default]\n           -name              => a string representing the taxon name\n                                 (scientific name)\n           -id                => human readable id - typically NCBI taxid\n           -ncbi_taxid        => same as -id, but explicitely say that it is an\n                                 NCBI taxid\n           -rank              => node rank (one of 'species', 'genus', etc)\n           -common_names      => array ref of all common names\n           -division          => 'Primates', 'Rodents', etc\n           -genetic_code      => genetic code table number\n           -mito_genetic_code => mitochondrial genetic code table number\n           -create_date       => date created in database\n           -update_date       => date last updated in database\n           -pub_date          => date published in database\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($name, $id, $objid, $rank, $div, $dbh, $ncbitaxid, $commonname,\n        $commonnames, $gcode, $mitocode, $createdate, $updatedate, $pubdate,\n        $parent_id) = $self->_rearrange([qw(NAME ID OBJECT_ID RANK DIVISION DBH\n                                            NCBI_TAXID COMMON_NAME COMMON_NAMES\n                                            GENETIC_CODE MITO_GENETIC_CODE\n                                            CREATE_DATE UPDATE_DATE PUB_DATE\n                                            PARENT_ID)], @args);\n    \n    if (defined $id && (defined $ncbitaxid && $ncbitaxid ne $id || defined $objid && $objid ne $id)) {\n        $self->warn(\"Only provide one of -id, -object_id or -ncbi_taxid, using $id\\n\");\n    }\n    elsif(!defined $id) { \n        $id = $objid || $ncbitaxid;\n    }\n    defined $id && $self->id($id);\n    $self->{_ncbi_tax_id_provided} = 1 if $ncbitaxid;\n    \n    defined $rank && $self->rank($rank);\n    defined $name && $self->node_name($name);\n    \n    my @common_names;\n    if ($commonnames) {\n        $self->throw(\"-common_names takes only an array reference\") unless $commonnames\n            && ref($commonnames) eq 'ARRAY';\n        @common_names = @{$commonnames};\n    }\n    if ($commonname) {\n        my %c_names = map { $_ => 1 } @common_names;\n        unless (exists $c_names{$commonname}) {\n            unshift(@common_names, $commonname);\n        }\n    }\n    @common_names > 0 && $self->common_names(@common_names);\n    \n    defined $gcode      && $self->genetic_code($gcode);\n    defined $mitocode   && $self->mitochondrial_genetic_code($mitocode);\n    defined $createdate && $self->create_date($createdate);\n    defined $updatedate && $self->update_date($updatedate);\n    defined $pubdate    && $self->pub_date($pubdate);\n    defined $div        && $self->division($div);\n    defined $dbh        && $self->db_handle($dbh);\n    \n    # deprecated and will issue a warning when method called,\n    # eventually to be removed completely as option\n    defined $parent_id  && $self->parent_id($parent_id);\n    \n    # some things want to freeze/thaw Bio::Species objects, but\n    # _root_cleanup_methods contains a CODE ref, delete it.\n    delete $self->{_root_cleanup_methods};\n    \n    return $self;\n}\n\n=head1 Bio::IdentifiableI interface \n\nAlso see L<Bio::IdentifiableI>\n\n=head2 version\n\n Title   : version\n Usage   : $taxon->version($newval)\n Returns : value of version (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub version {\n    my $self = shift;\n    return $self->{'version'} = shift if @_;\n    return $self->{'version'};\n}\n\n=head2 authority\n\n Title   : authority\n Usage   : $taxon->authority($newval)\n Returns : value of authority (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub authority {\n    my $self = shift;\n    return $self->{'authority'} = shift if @_;\n    return $self->{'authority'};\n}\n\n=head2 namespace\n\n Title   : namespace\n Usage   : $taxon->namespace($newval)\n Returns : value of namespace (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub namespace {\n    my $self = shift;\n    return $self->{'namespace'} = shift if @_;\n    return $self->{'namespace'};\n}\n\n=head1 Bio::Taxonomy::Node implementation\n\n=head2 db_handle\n\n Title   : db_handle\n Usage   : $taxon->db_handle($newval)\n Function: Get/Set Bio::DB::Taxonomy Handle\n Returns : value of db_handle (a scalar) (Bio::DB::Taxonomy object)\n Args    : on set, new value (a scalar, optional) Bio::DB::Taxonomy object\n\nAlso see L<Bio::DB::Taxonomy>\n\n\nsub db_handle {\n    my $self = shift;\n    if (@_) {\n        my $db = shift;\n        \n        if (! ref($db) || ! $db->isa('Bio::DB::Taxonomy')) {\n            $self->throw(\"Must provide a valid Bio::DB::Taxonomy object to db_handle()\");\n        }\n        if (!$self->{'db_handle'} || ($self->{'db_handle'} && $self->{'db_handle'} ne $db)) {\n            my $new_self = $self->_get_similar_taxon_from_db($self, $db);\n            $self->_merge_taxa($new_self) if $new_self;\n        }\n        \n        # NB: The Bio::DB::Taxonomy modules access this data member directly\n        # to avoid calling this method and going infinite\n        $self->{'db_handle'} = $db;\n    }\n    return $self->{'db_handle'};\n}\n\n=head2 rank\n\n Title   : rank\n Usage   : $taxon->rank($newval)\n Function: Get/set rank of this Taxon, 'species', 'genus', 'order', etc...\n Returns : value of rank (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub rank {\n    my $self = shift;\n    return $self->{'rank'} = shift if @_;\n    return $self->{'rank'};\n}\n\n=head2 id\n\n Title   : id\n Usage   : $taxon->id($newval)\n Function: Get/Set id (NCBI Taxonomy ID in most cases); object_id() and\n           ncbi_taxid() are synonyms of this method.\n Returns : id (a scalar)\n Args    : none to get, OR scalar to set\n\n\nsub id {\n    my $self = shift;\n    return $self->SUPER::id(@_);\n}\n\n*object_id = \\&id;\n\n=head2 ncbi_taxid\n\n Title   : ncbi_taxid\n Usage   : $taxon->ncbi_taxid($newval)\n Function: Get/Set the NCBI Taxonomy ID; This actually sets the id() but only\n           returns an id when ncbi_taxid has been explictely set with this\n           method.\n Returns : id (a scalar)\n Args    : none to get, OR scalar to set","parameters":[{"label":"$self"},{"label":"$id"}]},"line":365,"kind":12,"range":{"end":{"character":9999,"line":377},"start":{"character":0,"line":365}}},{"line":369,"kind":12,"name":"_ncbi_tax_id_provided"},{"line":370,"name":"SUPER","kind":12,"containerName":"id"},{"kind":12,"name":"_ncbi_tax_id_provided","line":373},{"definition":"sub","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"parent_id","name":"$self","line":392},{"name":"$self","containerName":"parent_id","kind":13,"line":394},{"name":"warn","containerName":"parent_id","kind":12,"line":394},{"line":396,"localvar":"my","kind":13,"containerName":"parent_id","name":"$ancestor","definition":"my"},{"name":"$self","containerName":"parent_id","kind":13,"line":396},{"name":"ancestor","containerName":"parent_id","kind":12,"line":396},{"containerName":"parent_id","kind":13,"name":"$ancestor","line":397},{"line":397,"name":"id","containerName":"parent_id","kind":12}],"name":"parent_id","containerName":"main::","line":391,"kind":12,"range":{"start":{"line":391,"character":0},"end":{"character":9999,"line":398}}},{"name":"SUPER","containerName":"id","kind":12,"line":392},{"line":412,"kind":12,"range":{"end":{"character":9999,"line":416},"start":{"line":412,"character":0}},"children":[{"name":"$self","localvar":"my","kind":13,"containerName":"genetic_code","line":413,"definition":"my"},{"line":414,"name":"$self","kind":13,"containerName":"genetic_code"},{"name":"$self","kind":13,"containerName":"genetic_code","line":415}],"containerName":"main::","name":"genetic_code","definition":"sub"},{"children":[{"definition":"my","line":429,"name":"$self","localvar":"my","containerName":"mitochondrial_genetic_code","kind":13},{"line":430,"name":"$self","kind":13,"containerName":"mitochondrial_genetic_code"},{"containerName":"mitochondrial_genetic_code","kind":13,"name":"$self","line":431}],"name":"mitochondrial_genetic_code","containerName":"main::","definition":"sub","line":428,"kind":12,"range":{"end":{"line":432,"character":9999},"start":{"character":0,"line":428}}},{"definition":"sub","children":[{"definition":"my","line":445,"localvar":"my","kind":13,"containerName":"create_date","name":"$self"},{"containerName":"create_date","kind":13,"name":"$self","line":446},{"line":447,"kind":13,"containerName":"create_date","name":"$self"}],"name":"create_date","containerName":"main::","line":444,"kind":12,"range":{"start":{"character":0,"line":444},"end":{"line":448,"character":9999}}},{"containerName":"main::","name":"update_date","children":[{"name":"$self","localvar":"my","containerName":"update_date","kind":13,"line":461,"definition":"my"},{"line":462,"name":"$self","kind":13,"containerName":"update_date"},{"line":463,"name":"$self","containerName":"update_date","kind":13}],"definition":"sub","kind":12,"range":{"start":{"line":460,"character":0},"end":{"character":9999,"line":464}},"line":460},{"definition":"sub","name":"pub_date","containerName":"main::","children":[{"line":477,"localvar":"my","kind":13,"containerName":"pub_date","name":"$self","definition":"my"},{"name":"$self","kind":13,"containerName":"pub_date","line":478},{"line":479,"name":"$self","kind":13,"containerName":"pub_date"}],"range":{"end":{"character":9999,"line":480},"start":{"character":0,"line":476}},"kind":12,"line":476},{"children":[{"line":503,"localvar":"my","kind":13,"containerName":"ancestor","name":"$self","definition":"my"},{"definition":"my","kind":13,"localvar":"my","containerName":"ancestor","name":"$ancestor","line":504},{"name":"$self","kind":13,"containerName":"ancestor","line":504},{"name":"$dbh","localvar":"my","containerName":"ancestor","kind":13,"line":505,"definition":"my"},{"containerName":"ancestor","kind":13,"name":"$self","line":505},{"line":505,"name":"db_handle","containerName":"ancestor","kind":12},{"name":"$ancestor","containerName":"ancestor","kind":13,"line":505},{"containerName":"ancestor","kind":13,"name":"$ancestor","line":507},{"name":"$ancestor","containerName":"ancestor","kind":13,"line":508},{"line":513,"name":"$definitely_from_dbh","containerName":"ancestor","localvar":"my","kind":13,"definition":"my"},{"containerName":"ancestor","kind":13,"name":"$self","line":513},{"line":513,"name":"_get_similar_taxon_from_db","containerName":"ancestor","kind":12},{"containerName":"ancestor","kind":13,"name":"$self","line":513},{"line":514,"name":"$dbh","kind":13,"containerName":"ancestor"},{"line":514,"name":"ancestor","kind":12,"containerName":"ancestor"},{"line":514,"kind":13,"containerName":"ancestor","name":"$definitely_from_dbh"}],"name":"ancestor","containerName":"main::","definition":"sub","line":502,"kind":12,"range":{"end":{"character":9999,"line":516},"start":{"character":0,"line":502}}},{"line":504,"kind":12,"containerName":"ancestor","name":"SUPER"},{"kind":12,"range":{"start":{"character":0,"line":526},"end":{"character":9999,"line":530}},"line":526,"definition":"sub","name":"get_Parent_Node","containerName":"main::","children":[{"definition":"my","line":527,"name":"$self","localvar":"my","containerName":"get_Parent_Node","kind":13},{"name":"$self","containerName":"get_Parent_Node","kind":13,"line":528},{"line":528,"kind":12,"containerName":"get_Parent_Node","name":"warn"},{"line":529,"name":"$self","containerName":"get_Parent_Node","kind":13},{"name":"ancestor","containerName":"get_Parent_Node","kind":12,"line":529}]},{"definition":"sub","name":"get_Children_Nodes","containerName":"main::","children":[{"definition":"my","containerName":"get_Children_Nodes","localvar":"my","kind":13,"name":"$self","line":566},{"line":567,"containerName":"get_Children_Nodes","kind":13,"name":"$self"},{"line":567,"name":"warn","containerName":"get_Children_Nodes","kind":12},{"line":568,"containerName":"get_Children_Nodes","kind":13,"name":"$self"},{"line":568,"kind":12,"containerName":"get_Children_Nodes","name":"each_Descendent"}],"range":{"end":{"character":9999,"line":569},"start":{"line":565,"character":0}},"kind":12,"line":565},{"children":[{"definition":"my","line":591,"kind":13,"localvar":"my","containerName":"name","name":"$self"},{"kind":13,"containerName":"name","name":"$name_class","line":591},{"line":591,"kind":13,"containerName":"name","name":"@names"},{"name":"$self","containerName":"name","kind":13,"line":592},{"containerName":"name","kind":12,"name":"throw","line":592},{"name":"$name_class","kind":13,"containerName":"name","line":592},{"line":594,"containerName":"name","kind":13,"name":"@names"},{"containerName":"name","kind":13,"name":"$name_class","line":595},{"line":596,"name":"$self","containerName":"name","kind":13},{"line":596,"containerName":"name","kind":13,"name":"$name_class"},{"line":597,"name":"@names","kind":13,"containerName":"name"},{"kind":13,"containerName":"name","name":"@names","line":597},{"line":599,"kind":13,"containerName":"name","name":"$self"},{"containerName":"name","kind":13,"name":"$name_class","line":599},{"line":599,"name":"@names","kind":13,"containerName":"name"}],"name":"name","containerName":"main::","definition":"sub","detail":"($self,$name_class,@names)","line":590,"range":{"start":{"line":590,"character":0},"end":{"character":9999,"line":600}},"kind":12,"signature":{"documentation":"1;\n# $Id: Taxon.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Taxon\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala, based heavily on a module by Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxon - A node in a represented taxonomy\n\n=head1 SYNOPSIS\n\n  use Bio::Taxon;\n\n  # Typically you will get a Taxon from a Bio::DB::Taxonomy object\n  # but here is how you initialize one\n  my $taxon = Bio::Taxon->new(-name      => $name,\n                             -id        => $id,\n                             -rank      => $rank,\n                             -division  => $div);\n\n  # Get one from a database\n  my $dbh = Bio::DB::Taxonomy->new(-source   => 'flatfile',\n                                  -directory=> '/tmp',\n                                  -nodesfile=> '/path/to/nodes.dmp',\n                                  -namesfile=> '/path/to/names.dmp');\n  my $human = $dbh->get_taxon(-name => 'Homo sapiens');\n  $human = $dbh->get_taxon(-taxonid => '9606');\n\n  print \"id is \", $human->id, \"\\n\"; # 9606\n  print \"rank is \", $human->rank, \"\\n\"; # species\n  print \"scientific name is \", $human->scientific_name, \"\\n\"; # Homo sapiens\n  print \"division is \", $human->division, \"\\n\"; # Primates\n\n  my $mouse = $dbh->get_taxon(-name => 'Mus musculus');\n\n  # You can quickly make your own lineages with the list database\n  my @ranks = qw(superkingdom class genus species);\n  my @h_lineage = ('Eukaryota', 'Mammalia', 'Homo', 'Homo sapiens');\n  my $list_dbh = Bio::DB::Taxonomy->new(-source => 'list', -names => \\@h_lineage,\n                                                          -ranks => \\@ranks);\n  $human = $list_dbh->get_taxon(-name => 'Homo sapiens');\n  my @names = $human->common_names; # @names is empty\n  $human->common_names('woman');\n  @names = $human->common_names; # @names contains woman\n\n  # You can switch to another database when you need more information\n  my $entrez_dbh = Bio::DB::Taxonomy->new(-source => 'entrez');\n  $human->db_handle($entrez_dbh);\n  @names = $human->common_names; # @names contains woman, human, man\n\n  # Since Bio::Taxon implements Bio::Tree::NodeI, we have access to those\n  # methods (and can manually create our own taxa and taxonomy without the use\n  # of any database)\n  my $homo = $human->ancestor;\n\n  # Though be careful with each_Descendent - unless you add_Descendent()\n  # yourself, you won't get an answer because unlike for ancestor(), Bio::Taxon\n  # does not ask the database for the answer. You can ask the database yourself\n  # using the same method:\n  ($human) = $homo->db_handle->each_Descendent($homo);\n\n  # We can also take advantage of Bio::Tree::Tree* methods:\n  # a) some methods are available with just an empty tree object\n  use Bio::Tree::Tree;\n  my $tree_functions = Bio::Tree::Tree->new();\n  my @lineage = $tree_functions->get_lineage_nodes($human);\n  my $lca = $tree_functions->get_lca($human, $mouse);\n\n  # b) for other methods, create a tree using your Taxon object\n  my $tree = Bio::Tree::Tree->new(-node => $human);\n  my @taxa = $tree->get_nodes;\n  $homo = $tree->find_node(-rank => 'genus');\n\n  # Normally you can't get the lca of a list-database derived Taxon and an\n  # entrez or flatfile-derived one because the two different databases might\n  # have different roots and different numbers of ranks between the root and the\n  # taxa of interest. To solve this, make a tree of the Taxon with the more\n  # detailed lineage and splice out all the taxa that won't be in the lineage of\n  # your other Taxon:\n  my $entrez_mouse = $entrez_dbh->get_taxon(-name => 'Mus musculus');\n  my $list_human = $list_dbh->get_taxon(-name => 'Homo sapiens');\n  my $mouse_tree = Bio::Tree::Tree->new(-node => $entrez_mouse);\n  $mouse_tree->splice(-keep_rank => \\@ranks);\n  $lca = $mouse_tree->get_lca($entrez_mouse, $list_human);\n\n=head1 DESCRIPTION\n\nThis is the next generation (for Bioperl) of representing Taxonomy\ninformation. Previously all information was managed by a single\nobject called Bio::Species. This new implementation allows\nrepresentation of the intermediate nodes not just the species nodes\nand can relate their connections.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich,    jason-at-bioperl-dot-org (original Bio::Taxonomy::Node)\nJuguang Xiao,     juguang@tll.org.sg\nGabriel Valiente, valiente@lsi.upc.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Taxon;\nuse strict;\n\nuse Bio::DB::Taxonomy;\n\nuse base qw(Bio::Tree::Node Bio::IdentifiableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Node->new();\n Function: Builds a new Bio::Taxonomy::Node object \n Returns : an instance of Bio::Taxonomy::Node\n Args    : -dbh               => a reference to a Bio::DB::Taxonomy object\n                                 [no default]\n           -name              => a string representing the taxon name\n                                 (scientific name)\n           -id                => human readable id - typically NCBI taxid\n           -ncbi_taxid        => same as -id, but explicitely say that it is an\n                                 NCBI taxid\n           -rank              => node rank (one of 'species', 'genus', etc)\n           -common_names      => array ref of all common names\n           -division          => 'Primates', 'Rodents', etc\n           -genetic_code      => genetic code table number\n           -mito_genetic_code => mitochondrial genetic code table number\n           -create_date       => date created in database\n           -update_date       => date last updated in database\n           -pub_date          => date published in database\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($name, $id, $objid, $rank, $div, $dbh, $ncbitaxid, $commonname,\n        $commonnames, $gcode, $mitocode, $createdate, $updatedate, $pubdate,\n        $parent_id) = $self->_rearrange([qw(NAME ID OBJECT_ID RANK DIVISION DBH\n                                            NCBI_TAXID COMMON_NAME COMMON_NAMES\n                                            GENETIC_CODE MITO_GENETIC_CODE\n                                            CREATE_DATE UPDATE_DATE PUB_DATE\n                                            PARENT_ID)], @args);\n    \n    if (defined $id && (defined $ncbitaxid && $ncbitaxid ne $id || defined $objid && $objid ne $id)) {\n        $self->warn(\"Only provide one of -id, -object_id or -ncbi_taxid, using $id\\n\");\n    }\n    elsif(!defined $id) { \n        $id = $objid || $ncbitaxid;\n    }\n    defined $id && $self->id($id);\n    $self->{_ncbi_tax_id_provided} = 1 if $ncbitaxid;\n    \n    defined $rank && $self->rank($rank);\n    defined $name && $self->node_name($name);\n    \n    my @common_names;\n    if ($commonnames) {\n        $self->throw(\"-common_names takes only an array reference\") unless $commonnames\n            && ref($commonnames) eq 'ARRAY';\n        @common_names = @{$commonnames};\n    }\n    if ($commonname) {\n        my %c_names = map { $_ => 1 } @common_names;\n        unless (exists $c_names{$commonname}) {\n            unshift(@common_names, $commonname);\n        }\n    }\n    @common_names > 0 && $self->common_names(@common_names);\n    \n    defined $gcode      && $self->genetic_code($gcode);\n    defined $mitocode   && $self->mitochondrial_genetic_code($mitocode);\n    defined $createdate && $self->create_date($createdate);\n    defined $updatedate && $self->update_date($updatedate);\n    defined $pubdate    && $self->pub_date($pubdate);\n    defined $div        && $self->division($div);\n    defined $dbh        && $self->db_handle($dbh);\n    \n    # deprecated and will issue a warning when method called,\n    # eventually to be removed completely as option\n    defined $parent_id  && $self->parent_id($parent_id);\n    \n    # some things want to freeze/thaw Bio::Species objects, but\n    # _root_cleanup_methods contains a CODE ref, delete it.\n    delete $self->{_root_cleanup_methods};\n    \n    return $self;\n}\n\n=head1 Bio::IdentifiableI interface \n\nAlso see L<Bio::IdentifiableI>\n\n=head2 version\n\n Title   : version\n Usage   : $taxon->version($newval)\n Returns : value of version (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub version {\n    my $self = shift;\n    return $self->{'version'} = shift if @_;\n    return $self->{'version'};\n}\n\n=head2 authority\n\n Title   : authority\n Usage   : $taxon->authority($newval)\n Returns : value of authority (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub authority {\n    my $self = shift;\n    return $self->{'authority'} = shift if @_;\n    return $self->{'authority'};\n}\n\n=head2 namespace\n\n Title   : namespace\n Usage   : $taxon->namespace($newval)\n Returns : value of namespace (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub namespace {\n    my $self = shift;\n    return $self->{'namespace'} = shift if @_;\n    return $self->{'namespace'};\n}\n\n=head1 Bio::Taxonomy::Node implementation\n\n=head2 db_handle\n\n Title   : db_handle\n Usage   : $taxon->db_handle($newval)\n Function: Get/Set Bio::DB::Taxonomy Handle\n Returns : value of db_handle (a scalar) (Bio::DB::Taxonomy object)\n Args    : on set, new value (a scalar, optional) Bio::DB::Taxonomy object\n\nAlso see L<Bio::DB::Taxonomy>\n\n\nsub db_handle {\n    my $self = shift;\n    if (@_) {\n        my $db = shift;\n        \n        if (! ref($db) || ! $db->isa('Bio::DB::Taxonomy')) {\n            $self->throw(\"Must provide a valid Bio::DB::Taxonomy object to db_handle()\");\n        }\n        if (!$self->{'db_handle'} || ($self->{'db_handle'} && $self->{'db_handle'} ne $db)) {\n            my $new_self = $self->_get_similar_taxon_from_db($self, $db);\n            $self->_merge_taxa($new_self) if $new_self;\n        }\n        \n        # NB: The Bio::DB::Taxonomy modules access this data member directly\n        # to avoid calling this method and going infinite\n        $self->{'db_handle'} = $db;\n    }\n    return $self->{'db_handle'};\n}\n\n=head2 rank\n\n Title   : rank\n Usage   : $taxon->rank($newval)\n Function: Get/set rank of this Taxon, 'species', 'genus', 'order', etc...\n Returns : value of rank (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub rank {\n    my $self = shift;\n    return $self->{'rank'} = shift if @_;\n    return $self->{'rank'};\n}\n\n=head2 id\n\n Title   : id\n Usage   : $taxon->id($newval)\n Function: Get/Set id (NCBI Taxonomy ID in most cases); object_id() and\n           ncbi_taxid() are synonyms of this method.\n Returns : id (a scalar)\n Args    : none to get, OR scalar to set\n\n\nsub id {\n    my $self = shift;\n    return $self->SUPER::id(@_);\n}\n\n*object_id = \\&id;\n\n=head2 ncbi_taxid\n\n Title   : ncbi_taxid\n Usage   : $taxon->ncbi_taxid($newval)\n Function: Get/Set the NCBI Taxonomy ID; This actually sets the id() but only\n           returns an id when ncbi_taxid has been explictely set with this\n           method.\n Returns : id (a scalar)\n Args    : none to get, OR scalar to set\n\n\nsub ncbi_taxid {\n    my ($self, $id) = @_;\n    \n    if ($id) {\n        $self->{_ncbi_tax_id_provided} = 1;\n        return $self->SUPER::id($id);\n    }\n    \n    if ($self->{_ncbi_tax_id_provided}) {\n        return $self->SUPER::id;\n    }\n    return;\n}\n\n=head2 parent_id\n\n Title   : parent_id\n Usage   : $taxon->parent_id()\n Function: Get parent ID, (NCBI Taxonomy ID in most cases);\n           parent_taxon_id() is a synonym of this method.\n Returns : value of parent_id (a scalar)\n Args    : none\n Status  : deprecated\n\n\nsub parent_id {\n    my $self = shift;\n    if (@_) {\n        $self->warn(\"You can no longer set the parent_id - use ancestor() instead\");\n    }\n    my $ancestor = $self->ancestor() || return;\n    return $ancestor->id;\n}\n\n*parent_taxon_id = \\&parent_id;\n\n=head2 genetic_code\n\n Title   : genetic_code\n Usage   : $taxon->genetic_code($newval)\n Function: Get/set genetic code table\n Returns : value of genetic_code (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub genetic_code {\n    my $self = shift;\n    return $self->{'genetic_code'} = shift if @_;\n    return $self->{'genetic_code'};\n}\n\n=head2 mitochondrial_genetic_code\n\n Title   : mitochondrial_genetic_code\n Usage   : $taxon->mitochondrial_genetic_code($newval)\n Function: Get/set mitochondrial genetic code table\n Returns : value of mitochondrial_genetic_code (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub mitochondrial_genetic_code {\n    my $self = shift;\n    return $self->{'mitochondrial_genetic_code'} = shift if @_;\n    return $self->{'mitochondrial_genetic_code'};\n}\n\n=head2 create_date\n\n Title   : create_date\n Usage   : $taxon->create_date($newval)\n Function: Get/Set Date this node was created (in the database)\n Returns : value of create_date (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub create_date {\n    my $self = shift;\n    return $self->{'create_date'} = shift if @_;\n    return $self->{'create_date'};\n}\n\n=head2 update_date\n\n Title   : update_date\n Usage   : $taxon->update_date($newval)\n Function: Get/Set Date this node was updated (in the database)\n Returns : value of update_date (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub update_date {\n    my $self = shift;\n    return $self->{'update_date'} = shift if @_;\n    return $self->{'update_date'};\n}\n\n=head2 pub_date\n\n Title   : pub_date\n Usage   : $taxon->pub_date($newval)\n Function: Get/Set Date this node was published (in the database)\n Returns : value of pub_date (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub pub_date {\n    my $self = shift;\n    return $self->{'pub_date'} = shift if @_;\n    return $self->{'pub_date'};\n}\n\n=head2 ancestor\n\n Title   : ancestor\n Usage   : my $ancestor_taxon = $taxon->ancestor()\n Function: Retrieve the ancestor taxon. Normally the database is asked what the\n           ancestor is.\n\n           If you manually set the ancestor (or you make a Bio::Tree::Tree with\n           this object as an argument to new()), the database (if any) will not\n           be used for the purposes of this method.\n\n           To restore normal database behaviour, call ancestor(undef) (which\n           would remove this object from the tree), or request this taxon again\n           as a new Taxon object from the database.\n\n Returns : Bio::Taxon\n Args    : none\n\n\nsub ancestor {\n    my $self = shift;\n    my $ancestor = $self->SUPER::ancestor(@_);\n    my $dbh = $self->db_handle || return $ancestor;\n    \n    if ($ancestor) {\n        return $ancestor;\n    }\n    else {\n        #*** could avoid the db lookup if we knew our current id was definitely\n        #    information from the db...\n        my $definitely_from_dbh = $self->_get_similar_taxon_from_db($self);\n        return $dbh->ancestor($definitely_from_dbh);\n    }\n}\n\n=head2 get_Parent_Node\n\n Title   : get_Parent_Node\n Function: Synonym of ancestor()\n Status  : deprecated\n\n\nsub get_Parent_Node {\n    my $self = shift;\n    $self->warn(\"get_Parent_Node is deprecated, use ancestor() instead\");\n    return $self->ancestor(@_);\n}\n\n=head2 each_Descendent\n\n Title   : each_Descendent\n Usage   : my @taxa = $taxon->each_Descendent();\n Function: Get all the descendents for this Taxon (but not their descendents,\n           ie. not a recursive fetchall). get_Children_Nodes() is a synonym of\n           this method.\n\n           Note that this method never asks the database for the descendents;\n           it will only return objects you have manually set with\n           add_Descendent(), or where this was done for you by making a\n           Bio::Tree::Tree with this object as an argument to new().\n\n           To get the database descendents use\n           $taxon->db_handle->each_Descendent($taxon).\n\n Returns : Array of Bio::Taxon objects\n Args    : optionally, when you have set your own descendents, the string\n           \"height\", \"creation\", \"alpha\", \"revalpha\", or coderef to be used to\n           sort the order of children nodes.\n\n\n# implemented by Bio::Tree::Node\n\n=head2 get_Children_Nodes\n\n Title   : get_Children_Nodes\n Function: Synonym of each_Descendent()\n Status  : deprecated\n\n\nsub get_Children_Nodes {\n    my $self = shift;\n    $self->warn(\"get_Children_Nodes is deprecated, use each_Descendent() instead\");\n    return $self->each_Descendent(@_);\n}\n\n=head2 name\n\n  Title:    name\n  Usage:    $taxon->name('scientific', 'Homo sapiens');\n            $taxon->name('common', 'human', 'man');\n            my @names = @{$taxon->name('common')};\n  Function: Get/set the names. node_name(), scientific_name() and common_names()\n            are shorthands to name('scientific'), name('scientific') and\n            name('common') respectively.\n  Returns:  names (a array reference)\n  Args:     Arg1 => the name_class. You can assign any text, but the words\n                'scientific' and 'common' have the special meaning, as\n                scientific name and common name, respectively. 'scientific' and\n                'division' are treated specially, allowing only the first value\n                in the Arg2 list to be set.\n            Arg2 .. => list of names","parameters":[{"label":"$self"},{"label":"$name_class"},{"label":"@names"}],"label":"name($self,$name_class,@names)"}},{"name":"%self","kind":13,"containerName":null,"line":601},{"line":601,"name":"$name_class","containerName":null,"kind":13},{"definition":"sub","containerName":"main::","name":"node_name","children":[{"name":"$self","localvar":"my","containerName":"node_name","kind":13,"line":617,"definition":"my"},{"definition":"my","localvar":"my","containerName":"node_name","kind":13,"name":"@v","line":618},{"kind":13,"containerName":"node_name","name":"$self","line":618},{"name":"name","containerName":"node_name","kind":12,"line":618}],"range":{"end":{"line":618,"character":9999},"start":{"line":616,"character":0}},"kind":12,"line":616},{"line":619,"name":"@v","kind":13,"containerName":null},{"line":636,"range":{"end":{"line":638,"character":9999},"start":{"line":636,"character":0}},"kind":12,"children":[{"name":"$self","localvar":"my","kind":13,"containerName":"common_names","line":637,"definition":"my"},{"line":638,"name":"@v","kind":13,"localvar":"my","containerName":"common_names","definition":"my"},{"line":638,"kind":13,"containerName":"common_names","name":"$self"},{"name":"name","kind":12,"containerName":"common_names","line":638}],"containerName":"main::","name":"common_names","definition":"sub"},{"line":639,"name":"@v","kind":13,"containerName":null},{"line":639,"name":"@v","kind":13,"containerName":null},{"definition":"sub","children":[{"line":656,"name":"$self","localvar":"my","kind":13,"containerName":"division","definition":"my"},{"localvar":"my","containerName":"division","kind":13,"name":"@v","line":657,"definition":"my"},{"line":657,"containerName":"division","kind":13,"name":"$self"},{"line":657,"name":"name","kind":12,"containerName":"division"}],"containerName":"main::","name":"division","line":655,"kind":12,"range":{"end":{"character":9999,"line":657},"start":{"line":655,"character":0}}},{"containerName":null,"kind":13,"name":"@v","line":658},{"name":"_get_similar_taxon_from_db","containerName":"main::","children":[{"localvar":"my","containerName":"_get_similar_taxon_from_db","kind":13,"name":"$self","line":665,"definition":"my"},{"name":"$taxon","kind":13,"containerName":"_get_similar_taxon_from_db","line":665},{"line":665,"kind":13,"containerName":"_get_similar_taxon_from_db","name":"$db"},{"kind":13,"containerName":"_get_similar_taxon_from_db","name":"$self","line":666},{"name":"throw","containerName":"_get_similar_taxon_from_db","kind":12,"line":666},{"line":666,"containerName":"_get_similar_taxon_from_db","kind":13,"name":"$taxon"},{"name":"$taxon","kind":13,"containerName":"_get_similar_taxon_from_db","line":666},{"containerName":"_get_similar_taxon_from_db","kind":12,"name":"isa","line":666},{"name":"$self","kind":13,"containerName":"_get_similar_taxon_from_db","line":667},{"line":667,"name":"id","kind":12,"containerName":"_get_similar_taxon_from_db"},{"line":667,"kind":13,"containerName":"_get_similar_taxon_from_db","name":"$self"},{"name":"node_name","kind":12,"containerName":"_get_similar_taxon_from_db","line":667},{"name":"$db","containerName":"_get_similar_taxon_from_db","kind":13,"line":668},{"line":668,"containerName":"_get_similar_taxon_from_db","kind":13,"name":"$self"},{"kind":12,"containerName":"_get_similar_taxon_from_db","name":"db_handle","line":668},{"definition":"my","line":670,"localvar":"my","containerName":"_get_similar_taxon_from_db","kind":13,"name":"$db_taxon"},{"line":670,"kind":13,"containerName":"_get_similar_taxon_from_db","name":"$db"},{"containerName":"_get_similar_taxon_from_db","kind":12,"name":"get_taxon","line":670},{"line":670,"kind":13,"containerName":"_get_similar_taxon_from_db","name":"$taxon"},{"line":670,"name":"id","kind":12,"containerName":"_get_similar_taxon_from_db"},{"line":670,"name":"$taxon","containerName":"_get_similar_taxon_from_db","kind":13},{"line":670,"name":"id","containerName":"_get_similar_taxon_from_db","kind":12},{"containerName":"_get_similar_taxon_from_db","kind":13,"name":"$db_taxon","line":671},{"definition":"my","kind":13,"localvar":"my","containerName":"_get_similar_taxon_from_db","name":"@try_ids","line":672},{"line":672,"containerName":"_get_similar_taxon_from_db","kind":13,"name":"$db"},{"name":"get_taxonids","containerName":"_get_similar_taxon_from_db","kind":12,"line":672},{"kind":13,"containerName":"_get_similar_taxon_from_db","name":"$taxon","line":672},{"line":672,"containerName":"_get_similar_taxon_from_db","kind":12,"name":"node_name"},{"line":672,"name":"$taxon","kind":13,"containerName":"_get_similar_taxon_from_db"},{"line":672,"kind":12,"containerName":"_get_similar_taxon_from_db","name":"node_name"},{"name":"$own_rank","localvar":"my","containerName":"_get_similar_taxon_from_db","kind":13,"line":674,"definition":"my"},{"name":"$taxon","containerName":"_get_similar_taxon_from_db","kind":13,"line":674},{"line":674,"name":"rank","kind":12,"containerName":"_get_similar_taxon_from_db"},{"line":675,"containerName":"_get_similar_taxon_from_db","localvar":"my","kind":13,"name":"$try_id","definition":"my"},{"line":675,"name":"@try_ids","kind":13,"containerName":"_get_similar_taxon_from_db"},{"line":676,"localvar":"my","containerName":"_get_similar_taxon_from_db","kind":13,"name":"$try","definition":"my"},{"name":"$db","kind":13,"containerName":"_get_similar_taxon_from_db","line":676},{"line":676,"kind":12,"containerName":"_get_similar_taxon_from_db","name":"get_taxon"},{"kind":13,"containerName":"_get_similar_taxon_from_db","name":"$try_id","line":676},{"definition":"my","line":677,"name":"$try_rank","containerName":"_get_similar_taxon_from_db","localvar":"my","kind":13},{"name":"$try","containerName":"_get_similar_taxon_from_db","kind":13,"line":677},{"line":677,"kind":12,"containerName":"_get_similar_taxon_from_db","name":"rank"},{"containerName":"_get_similar_taxon_from_db","kind":13,"name":"$own_rank","line":678},{"name":"$try_rank","containerName":"_get_similar_taxon_from_db","kind":13,"line":678},{"line":678,"containerName":"_get_similar_taxon_from_db","kind":13,"name":"$own_rank"},{"name":"$try_rank","containerName":"_get_similar_taxon_from_db","kind":13,"line":678},{"line":679,"name":"$db_taxon","containerName":"_get_similar_taxon_from_db","kind":13},{"line":679,"containerName":"_get_similar_taxon_from_db","kind":13,"name":"$try"},{"line":685,"kind":13,"containerName":"_get_similar_taxon_from_db","name":"$db_taxon"}],"detail":"($self,$taxon,$db)","definition":"sub","range":{"end":{"line":686,"character":9999},"start":{"character":0,"line":662}},"kind":12,"line":662,"signature":{"parameters":[{"label":"$self"},{"label":"$taxon"},{"label":"$db"}],"documentation":" get a node from the database that is like the supplied node","label":"_get_similar_taxon_from_db($self,$taxon,$db)"}},{"definition":"sub","detail":"($self,$taxon)","children":[{"definition":"my","localvar":"my","containerName":"_merge_taxa","kind":13,"name":"$self","line":690},{"kind":13,"containerName":"_merge_taxa","name":"$taxon","line":690},{"name":"$self","kind":13,"containerName":"_merge_taxa","line":691},{"line":691,"kind":12,"containerName":"_merge_taxa","name":"throw"},{"name":"$taxon","containerName":"_merge_taxa","kind":13,"line":691},{"name":"$taxon","kind":13,"containerName":"_merge_taxa","line":691},{"containerName":"_merge_taxa","kind":12,"name":"isa","line":691},{"line":692,"containerName":"_merge_taxa","kind":13,"name":"$taxon"},{"line":692,"name":"$self","kind":13,"containerName":"_merge_taxa"},{"definition":"my","containerName":"_merge_taxa","localvar":"my","kind":13,"name":"$attrib","line":694},{"definition":"my","kind":13,"localvar":"my","containerName":"_merge_taxa","name":"$own","line":695},{"line":695,"name":"$self","kind":13,"containerName":"_merge_taxa"},{"name":"$attrib","containerName":"_merge_taxa","kind":13,"line":695},{"line":696,"containerName":"_merge_taxa","localvar":"my","kind":13,"name":"$his","definition":"my"},{"containerName":"_merge_taxa","kind":13,"name":"$taxon","line":696},{"containerName":"_merge_taxa","kind":13,"name":"$attrib","line":696},{"name":"$own","kind":13,"containerName":"_merge_taxa","line":697},{"line":697,"containerName":"_merge_taxa","kind":13,"name":"$his"},{"name":"$self","kind":13,"containerName":"_merge_taxa","line":698},{"line":698,"name":"$attrib","kind":13,"containerName":"_merge_taxa"},{"line":698,"name":"$his","containerName":"_merge_taxa","kind":13},{"line":702,"localvar":"my","containerName":"_merge_taxa","kind":13,"name":"$own","definition":"my"},{"kind":13,"containerName":"_merge_taxa","name":"$self","line":702},{"kind":12,"containerName":"_merge_taxa","name":"rank","line":702},{"definition":"my","containerName":"_merge_taxa","localvar":"my","kind":13,"name":"$his","line":703},{"name":"$taxon","containerName":"_merge_taxa","kind":13,"line":703},{"kind":12,"containerName":"_merge_taxa","name":"rank","line":703},{"containerName":"_merge_taxa","kind":13,"name":"$own","line":704},{"containerName":"_merge_taxa","kind":13,"name":"$his","line":704},{"line":705,"containerName":"_merge_taxa","kind":13,"name":"$self"},{"line":705,"containerName":"_merge_taxa","kind":12,"name":"rank"},{"line":705,"containerName":"_merge_taxa","kind":13,"name":"$his"},{"line":708,"localvar":"my","kind":13,"containerName":"_merge_taxa","name":"%own_cnames","definition":"my"},{"name":"$self","kind":13,"containerName":"_merge_taxa","line":708},{"line":708,"kind":12,"containerName":"_merge_taxa","name":"common_names"},{"definition":"my","line":709,"name":"%his_cnames","kind":13,"localvar":"my","containerName":"_merge_taxa"},{"line":709,"name":"$taxon","containerName":"_merge_taxa","kind":13},{"line":709,"containerName":"_merge_taxa","kind":12,"name":"common_names"},{"kind":13,"containerName":"_merge_taxa","name":"%his_cnames","line":710},{"containerName":"_merge_taxa","kind":13,"name":"$own_cnames","line":711},{"line":712,"containerName":"_merge_taxa","kind":13,"name":"$self"},{"kind":12,"containerName":"_merge_taxa","name":"common_names","line":712}],"containerName":"main::","name":"_merge_taxa","signature":{"label":"_merge_taxa($self,$taxon)","documentation":" merge data from supplied Taxon into self","parameters":[{"label":"$self"},{"label":"$taxon"}]},"line":689,"kind":12,"range":{"start":{"line":689,"character":0},"end":{"line":717,"character":9999}}},{"children":[{"definition":"my","line":733,"containerName":"remove_Descendent","localvar":"my","kind":13,"name":"$self"},{"containerName":"remove_Descendent","kind":13,"name":"@nodes","line":733},{"definition":"my","line":734,"name":"$c","containerName":"remove_Descendent","localvar":"my","kind":13},{"definition":"my","line":735,"containerName":"remove_Descendent","localvar":"my","kind":13,"name":"$n"},{"name":"@nodes","kind":13,"containerName":"remove_Descendent","line":735},{"name":"$self","kind":13,"containerName":"remove_Descendent","line":736},{"line":736,"containerName":"remove_Descendent","kind":13,"name":"$n"},{"name":"internal_id","kind":12,"containerName":"remove_Descendent","line":736},{"line":737,"name":"$self","kind":13,"containerName":"remove_Descendent"},{"kind":13,"containerName":"remove_Descendent","name":"$n","line":738},{"line":738,"name":"ancestor","containerName":"remove_Descendent","kind":12},{"line":739,"name":"$self","kind":13,"containerName":"remove_Descendent"},{"containerName":"remove_Descendent","kind":13,"name":"$self","line":740},{"line":740,"containerName":"remove_Descendent","kind":13,"name":"$n"},{"line":740,"name":"internal_id","kind":12,"containerName":"remove_Descendent"},{"containerName":"remove_Descendent","kind":12,"name":"ancestor","line":740},{"kind":13,"containerName":"remove_Descendent","name":"$self","line":741},{"line":741,"name":"$n","kind":13,"containerName":"remove_Descendent"},{"line":741,"name":"internal_id","kind":12,"containerName":"remove_Descendent"},{"line":742,"name":"$c","kind":13,"containerName":"remove_Descendent"},{"line":745,"name":"$c","containerName":"remove_Descendent","kind":13}],"name":"remove_Descendent","containerName":"main::","definition":"sub","detail":"($self,@nodes)","line":730,"kind":12,"range":{"end":{"character":9999,"line":746},"start":{"line":730,"character":0}},"signature":{"documentation":"1;\n# $Id: Taxon.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Taxon\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala, based heavily on a module by Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxon - A node in a represented taxonomy\n\n=head1 SYNOPSIS\n\n  use Bio::Taxon;\n\n  # Typically you will get a Taxon from a Bio::DB::Taxonomy object\n  # but here is how you initialize one\n  my $taxon = Bio::Taxon->new(-name      => $name,\n                             -id        => $id,\n                             -rank      => $rank,\n                             -division  => $div);\n\n  # Get one from a database\n  my $dbh = Bio::DB::Taxonomy->new(-source   => 'flatfile',\n                                  -directory=> '/tmp',\n                                  -nodesfile=> '/path/to/nodes.dmp',\n                                  -namesfile=> '/path/to/names.dmp');\n  my $human = $dbh->get_taxon(-name => 'Homo sapiens');\n  $human = $dbh->get_taxon(-taxonid => '9606');\n\n  print \"id is \", $human->id, \"\\n\"; # 9606\n  print \"rank is \", $human->rank, \"\\n\"; # species\n  print \"scientific name is \", $human->scientific_name, \"\\n\"; # Homo sapiens\n  print \"division is \", $human->division, \"\\n\"; # Primates\n\n  my $mouse = $dbh->get_taxon(-name => 'Mus musculus');\n\n  # You can quickly make your own lineages with the list database\n  my @ranks = qw(superkingdom class genus species);\n  my @h_lineage = ('Eukaryota', 'Mammalia', 'Homo', 'Homo sapiens');\n  my $list_dbh = Bio::DB::Taxonomy->new(-source => 'list', -names => \\@h_lineage,\n                                                          -ranks => \\@ranks);\n  $human = $list_dbh->get_taxon(-name => 'Homo sapiens');\n  my @names = $human->common_names; # @names is empty\n  $human->common_names('woman');\n  @names = $human->common_names; # @names contains woman\n\n  # You can switch to another database when you need more information\n  my $entrez_dbh = Bio::DB::Taxonomy->new(-source => 'entrez');\n  $human->db_handle($entrez_dbh);\n  @names = $human->common_names; # @names contains woman, human, man\n\n  # Since Bio::Taxon implements Bio::Tree::NodeI, we have access to those\n  # methods (and can manually create our own taxa and taxonomy without the use\n  # of any database)\n  my $homo = $human->ancestor;\n\n  # Though be careful with each_Descendent - unless you add_Descendent()\n  # yourself, you won't get an answer because unlike for ancestor(), Bio::Taxon\n  # does not ask the database for the answer. You can ask the database yourself\n  # using the same method:\n  ($human) = $homo->db_handle->each_Descendent($homo);\n\n  # We can also take advantage of Bio::Tree::Tree* methods:\n  # a) some methods are available with just an empty tree object\n  use Bio::Tree::Tree;\n  my $tree_functions = Bio::Tree::Tree->new();\n  my @lineage = $tree_functions->get_lineage_nodes($human);\n  my $lca = $tree_functions->get_lca($human, $mouse);\n\n  # b) for other methods, create a tree using your Taxon object\n  my $tree = Bio::Tree::Tree->new(-node => $human);\n  my @taxa = $tree->get_nodes;\n  $homo = $tree->find_node(-rank => 'genus');\n\n  # Normally you can't get the lca of a list-database derived Taxon and an\n  # entrez or flatfile-derived one because the two different databases might\n  # have different roots and different numbers of ranks between the root and the\n  # taxa of interest. To solve this, make a tree of the Taxon with the more\n  # detailed lineage and splice out all the taxa that won't be in the lineage of\n  # your other Taxon:\n  my $entrez_mouse = $entrez_dbh->get_taxon(-name => 'Mus musculus');\n  my $list_human = $list_dbh->get_taxon(-name => 'Homo sapiens');\n  my $mouse_tree = Bio::Tree::Tree->new(-node => $entrez_mouse);\n  $mouse_tree->splice(-keep_rank => \\@ranks);\n  $lca = $mouse_tree->get_lca($entrez_mouse, $list_human);\n\n=head1 DESCRIPTION\n\nThis is the next generation (for Bioperl) of representing Taxonomy\ninformation. Previously all information was managed by a single\nobject called Bio::Species. This new implementation allows\nrepresentation of the intermediate nodes not just the species nodes\nand can relate their connections.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich,    jason-at-bioperl-dot-org (original Bio::Taxonomy::Node)\nJuguang Xiao,     juguang@tll.org.sg\nGabriel Valiente, valiente@lsi.upc.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Taxon;\nuse strict;\n\nuse Bio::DB::Taxonomy;\n\nuse base qw(Bio::Tree::Node Bio::IdentifiableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Node->new();\n Function: Builds a new Bio::Taxonomy::Node object \n Returns : an instance of Bio::Taxonomy::Node\n Args    : -dbh               => a reference to a Bio::DB::Taxonomy object\n                                 [no default]\n           -name              => a string representing the taxon name\n                                 (scientific name)\n           -id                => human readable id - typically NCBI taxid\n           -ncbi_taxid        => same as -id, but explicitely say that it is an\n                                 NCBI taxid\n           -rank              => node rank (one of 'species', 'genus', etc)\n           -common_names      => array ref of all common names\n           -division          => 'Primates', 'Rodents', etc\n           -genetic_code      => genetic code table number\n           -mito_genetic_code => mitochondrial genetic code table number\n           -create_date       => date created in database\n           -update_date       => date last updated in database\n           -pub_date          => date published in database\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($name, $id, $objid, $rank, $div, $dbh, $ncbitaxid, $commonname,\n        $commonnames, $gcode, $mitocode, $createdate, $updatedate, $pubdate,\n        $parent_id) = $self->_rearrange([qw(NAME ID OBJECT_ID RANK DIVISION DBH\n                                            NCBI_TAXID COMMON_NAME COMMON_NAMES\n                                            GENETIC_CODE MITO_GENETIC_CODE\n                                            CREATE_DATE UPDATE_DATE PUB_DATE\n                                            PARENT_ID)], @args);\n    \n    if (defined $id && (defined $ncbitaxid && $ncbitaxid ne $id || defined $objid && $objid ne $id)) {\n        $self->warn(\"Only provide one of -id, -object_id or -ncbi_taxid, using $id\\n\");\n    }\n    elsif(!defined $id) { \n        $id = $objid || $ncbitaxid;\n    }\n    defined $id && $self->id($id);\n    $self->{_ncbi_tax_id_provided} = 1 if $ncbitaxid;\n    \n    defined $rank && $self->rank($rank);\n    defined $name && $self->node_name($name);\n    \n    my @common_names;\n    if ($commonnames) {\n        $self->throw(\"-common_names takes only an array reference\") unless $commonnames\n            && ref($commonnames) eq 'ARRAY';\n        @common_names = @{$commonnames};\n    }\n    if ($commonname) {\n        my %c_names = map { $_ => 1 } @common_names;\n        unless (exists $c_names{$commonname}) {\n            unshift(@common_names, $commonname);\n        }\n    }\n    @common_names > 0 && $self->common_names(@common_names);\n    \n    defined $gcode      && $self->genetic_code($gcode);\n    defined $mitocode   && $self->mitochondrial_genetic_code($mitocode);\n    defined $createdate && $self->create_date($createdate);\n    defined $updatedate && $self->update_date($updatedate);\n    defined $pubdate    && $self->pub_date($pubdate);\n    defined $div        && $self->division($div);\n    defined $dbh        && $self->db_handle($dbh);\n    \n    # deprecated and will issue a warning when method called,\n    # eventually to be removed completely as option\n    defined $parent_id  && $self->parent_id($parent_id);\n    \n    # some things want to freeze/thaw Bio::Species objects, but\n    # _root_cleanup_methods contains a CODE ref, delete it.\n    delete $self->{_root_cleanup_methods};\n    \n    return $self;\n}\n\n=head1 Bio::IdentifiableI interface \n\nAlso see L<Bio::IdentifiableI>\n\n=head2 version\n\n Title   : version\n Usage   : $taxon->version($newval)\n Returns : value of version (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub version {\n    my $self = shift;\n    return $self->{'version'} = shift if @_;\n    return $self->{'version'};\n}\n\n=head2 authority\n\n Title   : authority\n Usage   : $taxon->authority($newval)\n Returns : value of authority (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub authority {\n    my $self = shift;\n    return $self->{'authority'} = shift if @_;\n    return $self->{'authority'};\n}\n\n=head2 namespace\n\n Title   : namespace\n Usage   : $taxon->namespace($newval)\n Returns : value of namespace (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub namespace {\n    my $self = shift;\n    return $self->{'namespace'} = shift if @_;\n    return $self->{'namespace'};\n}\n\n=head1 Bio::Taxonomy::Node implementation\n\n=head2 db_handle\n\n Title   : db_handle\n Usage   : $taxon->db_handle($newval)\n Function: Get/Set Bio::DB::Taxonomy Handle\n Returns : value of db_handle (a scalar) (Bio::DB::Taxonomy object)\n Args    : on set, new value (a scalar, optional) Bio::DB::Taxonomy object\n\nAlso see L<Bio::DB::Taxonomy>\n\n\nsub db_handle {\n    my $self = shift;\n    if (@_) {\n        my $db = shift;\n        \n        if (! ref($db) || ! $db->isa('Bio::DB::Taxonomy')) {\n            $self->throw(\"Must provide a valid Bio::DB::Taxonomy object to db_handle()\");\n        }\n        if (!$self->{'db_handle'} || ($self->{'db_handle'} && $self->{'db_handle'} ne $db)) {\n            my $new_self = $self->_get_similar_taxon_from_db($self, $db);\n            $self->_merge_taxa($new_self) if $new_self;\n        }\n        \n        # NB: The Bio::DB::Taxonomy modules access this data member directly\n        # to avoid calling this method and going infinite\n        $self->{'db_handle'} = $db;\n    }\n    return $self->{'db_handle'};\n}\n\n=head2 rank\n\n Title   : rank\n Usage   : $taxon->rank($newval)\n Function: Get/set rank of this Taxon, 'species', 'genus', 'order', etc...\n Returns : value of rank (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub rank {\n    my $self = shift;\n    return $self->{'rank'} = shift if @_;\n    return $self->{'rank'};\n}\n\n=head2 id\n\n Title   : id\n Usage   : $taxon->id($newval)\n Function: Get/Set id (NCBI Taxonomy ID in most cases); object_id() and\n           ncbi_taxid() are synonyms of this method.\n Returns : id (a scalar)\n Args    : none to get, OR scalar to set\n\n\nsub id {\n    my $self = shift;\n    return $self->SUPER::id(@_);\n}\n\n*object_id = \\&id;\n\n=head2 ncbi_taxid\n\n Title   : ncbi_taxid\n Usage   : $taxon->ncbi_taxid($newval)\n Function: Get/Set the NCBI Taxonomy ID; This actually sets the id() but only\n           returns an id when ncbi_taxid has been explictely set with this\n           method.\n Returns : id (a scalar)\n Args    : none to get, OR scalar to set\n\n\nsub ncbi_taxid {\n    my ($self, $id) = @_;\n    \n    if ($id) {\n        $self->{_ncbi_tax_id_provided} = 1;\n        return $self->SUPER::id($id);\n    }\n    \n    if ($self->{_ncbi_tax_id_provided}) {\n        return $self->SUPER::id;\n    }\n    return;\n}\n\n=head2 parent_id\n\n Title   : parent_id\n Usage   : $taxon->parent_id()\n Function: Get parent ID, (NCBI Taxonomy ID in most cases);\n           parent_taxon_id() is a synonym of this method.\n Returns : value of parent_id (a scalar)\n Args    : none\n Status  : deprecated\n\n\nsub parent_id {\n    my $self = shift;\n    if (@_) {\n        $self->warn(\"You can no longer set the parent_id - use ancestor() instead\");\n    }\n    my $ancestor = $self->ancestor() || return;\n    return $ancestor->id;\n}\n\n*parent_taxon_id = \\&parent_id;\n\n=head2 genetic_code\n\n Title   : genetic_code\n Usage   : $taxon->genetic_code($newval)\n Function: Get/set genetic code table\n Returns : value of genetic_code (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub genetic_code {\n    my $self = shift;\n    return $self->{'genetic_code'} = shift if @_;\n    return $self->{'genetic_code'};\n}\n\n=head2 mitochondrial_genetic_code\n\n Title   : mitochondrial_genetic_code\n Usage   : $taxon->mitochondrial_genetic_code($newval)\n Function: Get/set mitochondrial genetic code table\n Returns : value of mitochondrial_genetic_code (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub mitochondrial_genetic_code {\n    my $self = shift;\n    return $self->{'mitochondrial_genetic_code'} = shift if @_;\n    return $self->{'mitochondrial_genetic_code'};\n}\n\n=head2 create_date\n\n Title   : create_date\n Usage   : $taxon->create_date($newval)\n Function: Get/Set Date this node was created (in the database)\n Returns : value of create_date (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub create_date {\n    my $self = shift;\n    return $self->{'create_date'} = shift if @_;\n    return $self->{'create_date'};\n}\n\n=head2 update_date\n\n Title   : update_date\n Usage   : $taxon->update_date($newval)\n Function: Get/Set Date this node was updated (in the database)\n Returns : value of update_date (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub update_date {\n    my $self = shift;\n    return $self->{'update_date'} = shift if @_;\n    return $self->{'update_date'};\n}\n\n=head2 pub_date\n\n Title   : pub_date\n Usage   : $taxon->pub_date($newval)\n Function: Get/Set Date this node was published (in the database)\n Returns : value of pub_date (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub pub_date {\n    my $self = shift;\n    return $self->{'pub_date'} = shift if @_;\n    return $self->{'pub_date'};\n}\n\n=head2 ancestor\n\n Title   : ancestor\n Usage   : my $ancestor_taxon = $taxon->ancestor()\n Function: Retrieve the ancestor taxon. Normally the database is asked what the\n           ancestor is.\n\n           If you manually set the ancestor (or you make a Bio::Tree::Tree with\n           this object as an argument to new()), the database (if any) will not\n           be used for the purposes of this method.\n\n           To restore normal database behaviour, call ancestor(undef) (which\n           would remove this object from the tree), or request this taxon again\n           as a new Taxon object from the database.\n\n Returns : Bio::Taxon\n Args    : none\n\n\nsub ancestor {\n    my $self = shift;\n    my $ancestor = $self->SUPER::ancestor(@_);\n    my $dbh = $self->db_handle || return $ancestor;\n    \n    if ($ancestor) {\n        return $ancestor;\n    }\n    else {\n        #*** could avoid the db lookup if we knew our current id was definitely\n        #    information from the db...\n        my $definitely_from_dbh = $self->_get_similar_taxon_from_db($self);\n        return $dbh->ancestor($definitely_from_dbh);\n    }\n}\n\n=head2 get_Parent_Node\n\n Title   : get_Parent_Node\n Function: Synonym of ancestor()\n Status  : deprecated\n\n\nsub get_Parent_Node {\n    my $self = shift;\n    $self->warn(\"get_Parent_Node is deprecated, use ancestor() instead\");\n    return $self->ancestor(@_);\n}\n\n=head2 each_Descendent\n\n Title   : each_Descendent\n Usage   : my @taxa = $taxon->each_Descendent();\n Function: Get all the descendents for this Taxon (but not their descendents,\n           ie. not a recursive fetchall). get_Children_Nodes() is a synonym of\n           this method.\n\n           Note that this method never asks the database for the descendents;\n           it will only return objects you have manually set with\n           add_Descendent(), or where this was done for you by making a\n           Bio::Tree::Tree with this object as an argument to new().\n\n           To get the database descendents use\n           $taxon->db_handle->each_Descendent($taxon).\n\n Returns : Array of Bio::Taxon objects\n Args    : optionally, when you have set your own descendents, the string\n           \"height\", \"creation\", \"alpha\", \"revalpha\", or coderef to be used to\n           sort the order of children nodes.\n\n\n# implemented by Bio::Tree::Node\n\n=head2 get_Children_Nodes\n\n Title   : get_Children_Nodes\n Function: Synonym of each_Descendent()\n Status  : deprecated\n\n\nsub get_Children_Nodes {\n    my $self = shift;\n    $self->warn(\"get_Children_Nodes is deprecated, use each_Descendent() instead\");\n    return $self->each_Descendent(@_);\n}\n\n=head2 name\n\n  Title:    name\n  Usage:    $taxon->name('scientific', 'Homo sapiens');\n            $taxon->name('common', 'human', 'man');\n            my @names = @{$taxon->name('common')};\n  Function: Get/set the names. node_name(), scientific_name() and common_names()\n            are shorthands to name('scientific'), name('scientific') and\n            name('common') respectively.\n  Returns:  names (a array reference)\n  Args:     Arg1 => the name_class. You can assign any text, but the words\n                'scientific' and 'common' have the special meaning, as\n                scientific name and common name, respectively. 'scientific' and\n                'division' are treated specially, allowing only the first value\n                in the Arg2 list to be set.\n            Arg2 .. => list of names\n\n\nsub name {\n    my ($self, $name_class, @names) = @_;\n    $self->throw('No name class specified') unless defined $name_class;\n    \n    if (@names) {\n        if ($name_class =~ /scientific|division/i) {\n            delete $self->{'_names_hash'}->{$name_class};\n            @names = (shift(@names));\n        }\n        push @{$self->{'_names_hash'}->{$name_class}}, @names;\n    }\n    return $self->{'_names_hash'}->{$name_class} || return;\n}\n\n=head2 node_name\n\n Title   : node_name\n Usage   : $taxon->node_name($newval)\n Function: Get/set the name of this taxon (node), typically the scientific name\n           of the taxon, eg. 'Primate' or 'Homo'; scientific_name() is a synonym\n           of this method.\n Returns : value of node_name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub node_name {\n    my $self = shift;\n    my @v = @{$self->name('scientific', @_) || []};\n    return pop @v;\n}\n\n*scientific_name = \\&node_name;\n\n=head2 common_names\n\n Title   : common_names\n Usage   : $taxon->common_names($newval)\n Function: Get/add the other names of this taxon, typically the genbank common\n           name and others, eg. 'Human' and 'man'. common_name() is a synonym\n           of this method.\n Returns : array of names in list context, one of those names in scalar context\n Args    : on add, new list of names (scalars, optional)\n\n\nsub common_names {\n    my $self = shift;\n    my @v = @{$self->name('common', @_) || []};\n    return ( wantarray ) ? @v : pop @v;\n}\n\n*common_name = \\&common_names;\n\n=head2 division\n\n Title   : division\n Usage   : $taxon->division($newval)\n Function: Get/set the division this taxon belongs to, eg. 'Primates' or\n           'Bacteria'.\n Returns : value of division (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub division {\n    my $self = shift;\n    my @v = @{$self->name('division',@_) || []};\n    return pop @v;\n}\n\n# get a node from the database that is like the supplied node\nsub _get_similar_taxon_from_db {\n    #*** not really happy with this having to be called so much; there must be\n    #    a better way...\n    my ($self, $taxon, $db) = @_;\n    $self->throw(\"Must supply a Bio::Taxon\") unless ref($taxon) && $taxon->isa(\"Bio::Taxon\");\n    ($self->id || $self->node_name) || return;\n    $db ||= $self->db_handle || return;\n    \n    my $db_taxon = $db->get_taxon(-taxonid => $taxon->id) if $taxon->id;\n    unless ($db_taxon) {\n        my @try_ids = $db->get_taxonids($taxon->node_name) if $taxon->node_name;\n        \n        my $own_rank = $taxon->rank || 'no rank';\n        foreach my $try_id (@try_ids) {\n            my $try = $db->get_taxon(-taxonid => $try_id);\n            my $try_rank = $try->rank || 'no rank';\n            if ($own_rank eq 'no rank' || $try_rank eq 'no rank' || $own_rank eq $try_rank) {\n                $db_taxon = $try;\n                last;\n            }\n        }\n    }\n    \n    return $db_taxon;\n}\n\n# merge data from supplied Taxon into self\nsub _merge_taxa {\n    my ($self, $taxon) = @_;\n    $self->throw(\"Must supply a Bio::Taxon object\") unless ref($taxon) && $taxon->isa('Bio::Taxon');\n    return if ($taxon eq $self);\n    \n    foreach my $attrib (qw(scientific_name version authority namespace genetic_code mitochondrial_genetic_code create_date update_date pub_date division id)) {\n        my $own = $self->$attrib();\n        my $his = $taxon->$attrib();\n        if (!$own && $his) {\n            $self->$attrib($his);\n        }\n    }\n    \n    my $own = $self->rank || 'no rank';\n    my $his = $taxon->rank || 'no rank';\n    if ($own eq 'no rank' && $his ne 'no rank') {\n        $self->rank($his);\n    }\n    \n    my %own_cnames = map { $_ => 1 } $self->common_names;\n    my %his_cnames = map { $_ => 1 } $taxon->common_names;\n    foreach (keys %his_cnames) {\n        unless (exists $own_cnames{$_}) {\n            $self->common_names($_);\n        }\n    }\n    \n    #*** haven't merged the other things in names() hash, could do above much easier with direct access to object data\n}\n\n=head2 remove_Descendent\n\n Title   : remove_Descendent\n Usage   : $node->remove_Descedent($node_foo);\n Function: Removes a specific node from being a Descendent of this node\n Returns : nothing\n Args    : An array of Bio::Node::NodeI objects which have been previously\n           passed to the add_Descendent call of this object.","parameters":[{"label":"$self"},{"label":"@nodes"}],"label":"remove_Descendent($self,@nodes)"}},{"kind":12,"name":"_removing_descendent","line":737},{"line":739,"name":"_removing_descendent","kind":12}],"version":5}