{"version":5,"vars":[{"line":86,"name":"base","containerName":"","kind":2},{"detail":"($self,@args)","definition":"sub","name":"name","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"name","localvar":"my","kind":13,"line":103},{"line":103,"kind":13,"containerName":"name","name":"@args"},{"line":104,"kind":13,"containerName":"name","name":"$self"},{"line":104,"name":"throw_not_implemented","containerName":"name","kind":12}],"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: SymbolI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Symbol::SymbolI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Symbol::SymbolI - Interface for a Symbol\n\n=head1 SYNOPSIS\n\n    # get a Bio::Symbol::SymbolI object somehow\n\n    my ($name,$token) = ($symbol->name, $symbol->token);\n    my @symbols       = $symbol->symbols;\n    my $matches       = $symbol->matches;\n\n=head1 DESCRIPTION\n\nSymbol represents a single token in the sequence. Symbol can have\nmultiple synonyms or matches within the same Alphabet, which\nmakes possible to represent ambiguity codes and gaps.\n\nSymbols can be also composed from ordered list other symbols. For\nexample, codons can be represented by single Symbol using a\ncompound Alphabet made from three DNA Alphabets.\n\nThis module was implemented for the purposes of meeting the\nBSANE/BioCORBA spec 0.3 only.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Symbol::SymbolI;\nuse strict;\nuse base qw(Bio::Root::RootI);\n\n=head2 Bio::Symbol::SymbolI interface methods\n\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $symbol->name();\n Function: Get/Set Descriptive name for Symbol\n Returns : string\n Args    : (optional) string","label":"name($self,@args)"},"range":{"end":{"line":105,"character":9999},"start":{"character":0,"line":102}},"kind":12,"line":102},{"line":118,"kind":12,"range":{"end":{"character":9999,"line":121},"start":{"line":118,"character":0}},"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: SymbolI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Symbol::SymbolI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Symbol::SymbolI - Interface for a Symbol\n\n=head1 SYNOPSIS\n\n    # get a Bio::Symbol::SymbolI object somehow\n\n    my ($name,$token) = ($symbol->name, $symbol->token);\n    my @symbols       = $symbol->symbols;\n    my $matches       = $symbol->matches;\n\n=head1 DESCRIPTION\n\nSymbol represents a single token in the sequence. Symbol can have\nmultiple synonyms or matches within the same Alphabet, which\nmakes possible to represent ambiguity codes and gaps.\n\nSymbols can be also composed from ordered list other symbols. For\nexample, codons can be represented by single Symbol using a\ncompound Alphabet made from three DNA Alphabets.\n\nThis module was implemented for the purposes of meeting the\nBSANE/BioCORBA spec 0.3 only.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Symbol::SymbolI;\nuse strict;\nuse base qw(Bio::Root::RootI);\n\n=head2 Bio::Symbol::SymbolI interface methods\n\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $symbol->name();\n Function: Get/Set Descriptive name for Symbol\n Returns : string\n Args    : (optional) string\n\n\nsub name{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 token\n\n Title   : token\n Usage   : my $token = $self->token();\n Function: Get/Set token for this symbol\n Example : Letter A,C,G,or T for a DNA alphabet Symbol\n Returns : string\n Args    : (optional) string","label":"token($self,@args)"},"children":[{"line":119,"containerName":"token","localvar":"my","kind":13,"name":"$self","definition":"my"},{"name":"@args","containerName":"token","kind":13,"line":119},{"line":120,"containerName":"token","kind":13,"name":"$self"},{"line":120,"name":"throw_not_implemented","kind":12,"containerName":"token"}],"name":"token","containerName":"main::","definition":"sub","detail":"($self,@args)"},{"line":135,"kind":12,"range":{"start":{"line":135,"character":0},"end":{"line":138,"character":9999}},"signature":{"documentation":"1;\n# $Id: SymbolI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Symbol::SymbolI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Symbol::SymbolI - Interface for a Symbol\n\n=head1 SYNOPSIS\n\n    # get a Bio::Symbol::SymbolI object somehow\n\n    my ($name,$token) = ($symbol->name, $symbol->token);\n    my @symbols       = $symbol->symbols;\n    my $matches       = $symbol->matches;\n\n=head1 DESCRIPTION\n\nSymbol represents a single token in the sequence. Symbol can have\nmultiple synonyms or matches within the same Alphabet, which\nmakes possible to represent ambiguity codes and gaps.\n\nSymbols can be also composed from ordered list other symbols. For\nexample, codons can be represented by single Symbol using a\ncompound Alphabet made from three DNA Alphabets.\n\nThis module was implemented for the purposes of meeting the\nBSANE/BioCORBA spec 0.3 only.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Symbol::SymbolI;\nuse strict;\nuse base qw(Bio::Root::RootI);\n\n=head2 Bio::Symbol::SymbolI interface methods\n\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $symbol->name();\n Function: Get/Set Descriptive name for Symbol\n Returns : string\n Args    : (optional) string\n\n\nsub name{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 token\n\n Title   : token\n Usage   : my $token = $self->token();\n Function: Get/Set token for this symbol\n Example : Letter A,C,G,or T for a DNA alphabet Symbol\n Returns : string\n Args    : (optional) string\n\n\nsub token{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 symbols\n\n Title   : symbols\n Usage   : my @symbols = $self->symbols();\n Function: Get/Set Symbols this Symbol is composed from\n Example : A codon is composed of 3 DNA symbols\n Returns : Array of Bio::Symbol::SymbolI objects\n Args    : (optional) Array of Bio::Symbol::SymbolI objects","parameters":[{"label":"$self"},{"label":"@args"}],"label":"symbols($self,@args)"},"children":[{"line":136,"name":"$self","containerName":"symbols","localvar":"my","kind":13,"definition":"my"},{"name":"@args","kind":13,"containerName":"symbols","line":136},{"name":"$self","containerName":"symbols","kind":13,"line":137},{"kind":12,"containerName":"symbols","name":"throw_not_implemented","line":137}],"containerName":"main::","name":"symbols","definition":"sub","detail":"($self,@args)"},{"signature":{"label":"matches($self,@args)","documentation":"1;\n# $Id: SymbolI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Symbol::SymbolI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Symbol::SymbolI - Interface for a Symbol\n\n=head1 SYNOPSIS\n\n    # get a Bio::Symbol::SymbolI object somehow\n\n    my ($name,$token) = ($symbol->name, $symbol->token);\n    my @symbols       = $symbol->symbols;\n    my $matches       = $symbol->matches;\n\n=head1 DESCRIPTION\n\nSymbol represents a single token in the sequence. Symbol can have\nmultiple synonyms or matches within the same Alphabet, which\nmakes possible to represent ambiguity codes and gaps.\n\nSymbols can be also composed from ordered list other symbols. For\nexample, codons can be represented by single Symbol using a\ncompound Alphabet made from three DNA Alphabets.\n\nThis module was implemented for the purposes of meeting the\nBSANE/BioCORBA spec 0.3 only.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Symbol::SymbolI;\nuse strict;\nuse base qw(Bio::Root::RootI);\n\n=head2 Bio::Symbol::SymbolI interface methods\n\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $symbol->name();\n Function: Get/Set Descriptive name for Symbol\n Returns : string\n Args    : (optional) string\n\n\nsub name{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 token\n\n Title   : token\n Usage   : my $token = $self->token();\n Function: Get/Set token for this symbol\n Example : Letter A,C,G,or T for a DNA alphabet Symbol\n Returns : string\n Args    : (optional) string\n\n\nsub token{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 symbols\n\n Title   : symbols\n Usage   : my @symbols = $self->symbols();\n Function: Get/Set Symbols this Symbol is composed from\n Example : A codon is composed of 3 DNA symbols\n Returns : Array of Bio::Symbol::SymbolI objects\n Args    : (optional) Array of Bio::Symbol::SymbolI objects\n\n\n\nsub symbols{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 matches\n\n Title   : matches\n Usage   : my $matchalphabet = $symbol->matches();\n Function: Get/Set (Sub) alphabet of symbols matched by this symbol\n           including the symbol itself (i.e. if symbol is DNA\n           ambiguity code W then the matches contains symbols for W\n           and T)\n Returns : Bio::Symbol::AlphabetI\n Args    : (optional) Bio::Symbol::AlphabetI","parameters":[{"label":"$self"},{"label":"@args"}]},"line":153,"range":{"end":{"character":9999,"line":156},"start":{"line":153,"character":0}},"kind":12,"definition":"sub","detail":"($self,@args)","children":[{"line":154,"name":"$self","containerName":"matches","localvar":"my","kind":13,"definition":"my"},{"line":154,"name":"@args","containerName":"matches","kind":13},{"kind":13,"containerName":"matches","name":"$self","line":155},{"kind":12,"containerName":"matches","name":"throw_not_implemented","line":155}],"name":"matches","containerName":"main::"},{"signature":{"documentation":"1;\n# $Id: SymbolI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Symbol::SymbolI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Symbol::SymbolI - Interface for a Symbol\n\n=head1 SYNOPSIS\n\n    # get a Bio::Symbol::SymbolI object somehow\n\n    my ($name,$token) = ($symbol->name, $symbol->token);\n    my @symbols       = $symbol->symbols;\n    my $matches       = $symbol->matches;\n\n=head1 DESCRIPTION\n\nSymbol represents a single token in the sequence. Symbol can have\nmultiple synonyms or matches within the same Alphabet, which\nmakes possible to represent ambiguity codes and gaps.\n\nSymbols can be also composed from ordered list other symbols. For\nexample, codons can be represented by single Symbol using a\ncompound Alphabet made from three DNA Alphabets.\n\nThis module was implemented for the purposes of meeting the\nBSANE/BioCORBA spec 0.3 only.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Symbol::SymbolI;\nuse strict;\nuse base qw(Bio::Root::RootI);\n\n=head2 Bio::Symbol::SymbolI interface methods\n\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $symbol->name();\n Function: Get/Set Descriptive name for Symbol\n Returns : string\n Args    : (optional) string\n\n\nsub name{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 token\n\n Title   : token\n Usage   : my $token = $self->token();\n Function: Get/Set token for this symbol\n Example : Letter A,C,G,or T for a DNA alphabet Symbol\n Returns : string\n Args    : (optional) string\n\n\nsub token{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 symbols\n\n Title   : symbols\n Usage   : my @symbols = $self->symbols();\n Function: Get/Set Symbols this Symbol is composed from\n Example : A codon is composed of 3 DNA symbols\n Returns : Array of Bio::Symbol::SymbolI objects\n Args    : (optional) Array of Bio::Symbol::SymbolI objects\n\n\n\nsub symbols{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 matches\n\n Title   : matches\n Usage   : my $matchalphabet = $symbol->matches();\n Function: Get/Set (Sub) alphabet of symbols matched by this symbol\n           including the symbol itself (i.e. if symbol is DNA\n           ambiguity code W then the matches contains symbols for W\n           and T)\n Returns : Bio::Symbol::AlphabetI\n Args    : (optional) Bio::Symbol::AlphabetI\n\n\nsub matches{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();   \n}\n\n=head2 equals\n\n Title   : equals\n Usage   : if( $symbol->equals($symbol2) ) { }\n Function: Tests if a symbol is equal to another \n Returns : Boolean\n Args    : Bio::Symbol::SymbolI","parameters":[{"label":"$self"},{"label":"@args"}],"label":"equals($self,@args)"},"kind":12,"range":{"start":{"character":0,"line":168},"end":{"line":171,"character":9999}},"line":168,"detail":"($self,@args)","definition":"sub","containerName":"main::","name":"equals","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"equals","line":169,"definition":"my"},{"kind":13,"containerName":"equals","name":"@args","line":169},{"kind":13,"containerName":"equals","name":"$self","line":170},{"name":"throw_not_implemented","kind":12,"containerName":"equals","line":170}]}]}