{"vars":[{"name":"base","kind":2,"containerName":"","line":92},{"range":{"end":{"line":105,"character":9999},"start":{"line":94,"character":0}},"kind":12,"line":94,"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"@args"}],"label":"_initialize($self,@args)"},"name":"_initialize","containerName":"main::","children":[{"definition":"my","line":95,"name":"$self","localvar":"my","kind":13,"containerName":"_initialize"},{"line":95,"containerName":"_initialize","kind":13,"name":"@args"},{"line":97,"containerName":"_initialize","kind":13,"name":"$self"},{"name":"@args","containerName":"_initialize","kind":13,"line":97},{"line":99,"name":"$self","kind":13,"containerName":"_initialize"},{"name":"sequence_factory","containerName":"_initialize","kind":12,"line":99},{"line":100,"name":"$self","kind":13,"containerName":"_initialize"},{"name":"sequence_factory","kind":12,"containerName":"_initialize","line":100},{"line":100,"name":"new","kind":12,"containerName":"_initialize"},{"line":103,"name":"$self","containerName":"_initialize","kind":13},{"containerName":"_initialize","kind":13,"name":"$self","line":104}],"detail":"($self,@args)","definition":"sub"},{"line":97,"name":"SUPER","kind":12,"containerName":"_initialize"},{"name":"Bio","containerName":"Seq::SeqFastaSpeedFactory","kind":12,"line":100},{"name":"_parsed","kind":12,"line":104},{"signature":{"label":"next_seq($self)","parameters":[{"label":"$self"}],"documentation":"__END__\n# BioPerl module for Bio::SeqIO::tinyseq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::tinyseq - reading/writing sequences in NCBI TinySeq format\n\n=head1 SYNOPSIS\n\nDo not use this module directly; use the SeqIO handler system:\n\n  $stream = Bio::SeqIO->new( -file => $filename, -format => 'tinyseq' );\n\n  while ( my $seq = $stream->next_seq ) {\n    ....\n  }\n\n=head1 DESCRIPTION\n\nThis object reads and writes Bio::Seq objects to and from TinySeq XML\nformat.  A TinySeq is a lightweight XML file of sequence information,\nanalgous to FASTA format.\n\nSee L<http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.mod.dtd> for the DTD.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.bioperl.org\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO>, L<Bio::Seq>.\n\n=head1 AUTHOR\n\nDonald Jackson, E<lt>donald.jackson@bms.comE<gt>\n\nParts of this module and the test script were patterned after Sheldon\nMcKay's L<Bio::SeqIO::game>.  If it breaks, however, it's my fault not\nhis ;).\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::tinyseq;\n\nuse strict;\nuse Bio::Seq::SeqFastaSpeedFactory;\nuse Bio::Species;\nuse Bio::SeqIO::tinyseq::tinyseqHandler;\nuse XML::Parser::PerlSAX;\nuse XML::Writer;\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n    my ($self, @args) = @_;\n\n    $self->SUPER::_initialize(@args);\n\n    unless (defined $self->sequence_factory) {\n\t$self->sequence_factory(Bio::Seq::SeqFastaSpeedFactory->new());\n    }\n\n    $self->{'_species_objects'} = {};\n    $self->{_parsed} = 0;\n}\n\n=head2 next_seq\n\n  Title\t\t: next_seq\n  Usage\t\t: $seq = $stream->next_seq()\n  Function\t: returns the next sequence in the stream\n  Returns\t: Bio::Seq object\n  Args\t\t: NONE"},"line":117,"kind":12,"range":{"start":{"line":117,"character":0},"end":{"character":9999,"line":122}},"definition":"sub","detail":"($self)","children":[{"definition":"my","containerName":"next_seq","localvar":"my","kind":13,"name":"$self","line":118},{"name":"$self","kind":13,"containerName":"next_seq","line":120},{"line":120,"name":"_get_seqs","kind":12,"containerName":"next_seq"},{"line":120,"name":"$self","containerName":"next_seq","kind":13},{"line":122,"containerName":"next_seq","kind":13,"name":"$self"}],"name":"next_seq","containerName":"main::"},{"name":"_parsed","kind":12,"line":120},{"name":"_seqlist","kind":12,"line":122},{"definition":"sub","detail":"($self,@seqobjs)","children":[{"line":141,"localvar":"my","containerName":"write_seq","kind":13,"name":"$self","definition":"my"},{"kind":13,"containerName":"write_seq","name":"@seqobjs","line":141},{"containerName":"write_seq","kind":13,"name":"$self","line":143},{"kind":12,"containerName":"write_seq","name":"throw","line":143},{"line":144,"name":"@seqobjs","kind":13,"containerName":"write_seq"},{"name":"$seqobjs","kind":13,"containerName":"write_seq","line":144},{"name":"isa","containerName":"write_seq","kind":12,"line":144},{"line":144,"name":"$seqobjs","kind":13,"containerName":"write_seq"},{"line":144,"containerName":"write_seq","kind":12,"name":"isa"},{"definition":"my","line":146,"localvar":"my","kind":13,"containerName":"write_seq","name":"$writer"},{"line":146,"name":"$self","kind":13,"containerName":"write_seq"},{"line":146,"name":"_get_writer","kind":12,"containerName":"write_seq"},{"definition":"my","containerName":"write_seq","localvar":"my","kind":13,"name":"$seqobj","line":148},{"line":148,"containerName":"write_seq","kind":13,"name":"@seqobjs"},{"definition":"my","name":"$id_element","localvar":"my","containerName":"write_seq","kind":13,"line":149},{"line":149,"kind":13,"containerName":"write_seq","name":"$id_value"},{"line":149,"name":"$self","kind":13,"containerName":"write_seq"},{"line":149,"containerName":"write_seq","kind":12,"name":"_get_idstring"},{"line":149,"name":"$seqobj","kind":13,"containerName":"write_seq"},{"line":150,"kind":13,"containerName":"write_seq","name":"$writer"},{"line":150,"kind":12,"containerName":"write_seq","name":"startTag"},{"containerName":"write_seq","kind":13,"name":"$writer","line":151},{"name":"emptyTag","kind":12,"containerName":"write_seq","line":151},{"containerName":"write_seq","kind":13,"name":"$self","line":151},{"line":151,"containerName":"write_seq","kind":12,"name":"_convert_seqtype"},{"line":151,"name":"$seqobj","kind":13,"containerName":"write_seq"},{"containerName":"write_seq","kind":13,"name":"$writer","line":152},{"kind":12,"containerName":"write_seq","name":"dataElement","line":152},{"containerName":"write_seq","kind":13,"name":"$seqobj","line":152},{"kind":12,"containerName":"write_seq","name":"primary_id","line":152},{"kind":13,"containerName":"write_seq","name":"$writer","line":153},{"name":"dataElement","containerName":"write_seq","kind":12,"line":153},{"name":"$id_element","kind":13,"containerName":"write_seq","line":153},{"line":153,"kind":13,"containerName":"write_seq","name":"$id_value"},{"kind":13,"containerName":"write_seq","name":"$writer","line":155},{"name":"dataElement","containerName":"write_seq","kind":12,"line":155},{"line":155,"containerName":"write_seq","kind":13,"name":"$seqobj"},{"line":155,"name":"desc","kind":12,"containerName":"write_seq"},{"kind":13,"containerName":"write_seq","name":"$writer","line":156},{"line":156,"containerName":"write_seq","kind":12,"name":"dataElement"},{"name":"$seqobj","containerName":"write_seq","kind":13,"line":156},{"name":"length","kind":12,"containerName":"write_seq","line":156},{"name":"$writer","kind":13,"containerName":"write_seq","line":157},{"line":157,"name":"dataElement","kind":12,"containerName":"write_seq"},{"name":"$seqobj","kind":13,"containerName":"write_seq","line":157},{"name":"seq","containerName":"write_seq","kind":12,"line":157},{"line":159,"name":"$seqobj","containerName":"write_seq","kind":13},{"kind":12,"containerName":"write_seq","name":"can","line":159},{"line":159,"name":"$seqobj","kind":13,"containerName":"write_seq"},{"line":159,"kind":12,"containerName":"write_seq","name":"species"},{"name":"$self","kind":13,"containerName":"write_seq","line":160},{"line":160,"containerName":"write_seq","kind":12,"name":"_write_species"},{"line":160,"name":"$writer","kind":13,"containerName":"write_seq"},{"line":160,"containerName":"write_seq","kind":13,"name":"$seqobj"},{"kind":12,"containerName":"write_seq","name":"species","line":160},{"name":"$writer","kind":13,"containerName":"write_seq","line":163},{"line":163,"containerName":"write_seq","kind":12,"name":"endTag"}],"containerName":"main::","name":"write_seq","signature":{"parameters":[{"label":"$self"},{"label":"@seqobjs"}],"documentation":"__END__\n# BioPerl module for Bio::SeqIO::tinyseq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::tinyseq - reading/writing sequences in NCBI TinySeq format\n\n=head1 SYNOPSIS\n\nDo not use this module directly; use the SeqIO handler system:\n\n  $stream = Bio::SeqIO->new( -file => $filename, -format => 'tinyseq' );\n\n  while ( my $seq = $stream->next_seq ) {\n    ....\n  }\n\n=head1 DESCRIPTION\n\nThis object reads and writes Bio::Seq objects to and from TinySeq XML\nformat.  A TinySeq is a lightweight XML file of sequence information,\nanalgous to FASTA format.\n\nSee L<http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.mod.dtd> for the DTD.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.bioperl.org\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO>, L<Bio::Seq>.\n\n=head1 AUTHOR\n\nDonald Jackson, E<lt>donald.jackson@bms.comE<gt>\n\nParts of this module and the test script were patterned after Sheldon\nMcKay's L<Bio::SeqIO::game>.  If it breaks, however, it's my fault not\nhis ;).\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::tinyseq;\n\nuse strict;\nuse Bio::Seq::SeqFastaSpeedFactory;\nuse Bio::Species;\nuse Bio::SeqIO::tinyseq::tinyseqHandler;\nuse XML::Parser::PerlSAX;\nuse XML::Writer;\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n    my ($self, @args) = @_;\n\n    $self->SUPER::_initialize(@args);\n\n    unless (defined $self->sequence_factory) {\n\t$self->sequence_factory(Bio::Seq::SeqFastaSpeedFactory->new());\n    }\n\n    $self->{'_species_objects'} = {};\n    $self->{_parsed} = 0;\n}\n\n=head2 next_seq\n\n  Title\t\t: next_seq\n  Usage\t\t: $seq = $stream->next_seq()\n  Function\t: returns the next sequence in the stream\n  Returns\t: Bio::Seq object\n  Args\t\t: NONE\n\n\nsub next_seq {\n    my ($self) = @_;\n\n    $self->_get_seqs() unless ($self->{_parsed});\n\n    return shift @{$self->{_seqlist}};\n}\n\n=head2 write_seq\n\n  Title\t\t: write_seq\n  Usage\t\t: $seq = $stream->write_seq(@sequence_objects); undef $stream\n  Function\t: outputs one or more sequence objects as TinySeq XML\n  Returns\t: 1 on success\n  Args\t\t: one or more sequence objects as TinySeq XML\n\nBecause the TSeq dtd includes closing tags after all sets are written,\nthe output will not be complete until the program terminates or the\nobject is forced out of scope (see close_writer()).  May not perfectly\nreproduce TSeq_sid element for all sequences","label":"write_seq($self,@seqobjs)"},"line":140,"kind":12,"range":{"end":{"character":9999,"line":166},"start":{"line":140,"character":0}}},{"line":151,"name":"value","kind":12},{"children":[{"kind":13,"localvar":"my","containerName":"_get_seqs","name":"$self","line":182,"definition":"my"},{"definition":"my","name":"$fh","kind":13,"localvar":"my","containerName":"_get_seqs","line":184},{"line":184,"containerName":"_get_seqs","kind":13,"name":"$self"},{"line":184,"kind":12,"containerName":"_get_seqs","name":"_fh"},{"line":186,"containerName":"_get_seqs","localvar":"my","kind":13,"name":"$handler","definition":"my"},{"line":186,"name":"new","kind":12,"containerName":"_get_seqs"},{"line":187,"localvar":"my","kind":13,"containerName":"_get_seqs","name":"$parser","definition":"my"},{"line":187,"name":"new","containerName":"_get_seqs","kind":12},{"name":"$handler","containerName":"_get_seqs","kind":13,"line":187},{"definition":"my","containerName":"_get_seqs","localvar":"my","kind":13,"name":"@seqatts","line":189},{"line":189,"name":"$parser","kind":13,"containerName":"_get_seqs"},{"name":"parse","containerName":"_get_seqs","kind":12,"line":189},{"kind":13,"containerName":"_get_seqs","name":"$fh","line":189},{"kind":13,"localvar":"my","containerName":"_get_seqs","name":"$factory","line":191,"definition":"my"},{"line":191,"containerName":"_get_seqs","kind":13,"name":"$self"},{"line":191,"kind":12,"containerName":"_get_seqs","name":"sequence_factory"},{"containerName":"_get_seqs","kind":13,"name":"$self","line":193},{"definition":"my","containerName":"_get_seqs","localvar":"my","kind":13,"name":"$seqatt","line":194},{"line":194,"containerName":"_get_seqs","kind":13,"name":"@seqatts"},{"definition":"my","line":195,"kind":13,"localvar":"my","containerName":"_get_seqs","name":"$subatt"},{"line":195,"containerName":"_get_seqs","kind":13,"name":"$seqatt"},{"line":196,"name":"$seqobj","containerName":"_get_seqs","localvar":"my","kind":13,"definition":"my"},{"line":196,"name":"$factory","containerName":"_get_seqs","kind":13},{"kind":12,"containerName":"_get_seqs","name":"create","line":196},{"name":"$subatt","kind":13,"containerName":"_get_seqs","line":196},{"line":197,"containerName":"_get_seqs","kind":13,"name":"$self"},{"containerName":"_get_seqs","kind":12,"name":"_assign_identifier","line":197},{"line":197,"name":"$seqobj","containerName":"_get_seqs","kind":13},{"line":197,"containerName":"_get_seqs","kind":13,"name":"$subatt"},{"line":199,"name":"$seqobj","kind":13,"containerName":"_get_seqs"},{"name":"can","kind":12,"containerName":"_get_seqs","line":199},{"line":203,"localvar":"my","containerName":"_get_seqs","kind":13,"name":"$species","definition":"my"},{"containerName":"_get_seqs","kind":13,"name":"$self","line":203},{"line":203,"name":"_get_species","kind":12,"containerName":"_get_seqs"},{"line":203,"kind":13,"containerName":"_get_seqs","name":"$subatt"},{"line":203,"name":"$subatt","containerName":"_get_seqs","kind":13},{"name":"$seqobj","kind":13,"containerName":"_get_seqs","line":204},{"kind":12,"containerName":"_get_seqs","name":"species","line":204},{"containerName":"_get_seqs","kind":13,"name":"$species","line":204},{"line":204,"containerName":"_get_seqs","kind":13,"name":"$species"},{"containerName":"_get_seqs","kind":13,"name":"$self","line":207},{"name":"$seqobj","containerName":"_get_seqs","kind":13,"line":207}],"containerName":"main::","name":"_get_seqs","definition":"sub","detail":"($self)","line":181,"range":{"start":{"character":0,"line":181},"end":{"line":209,"character":9999}},"kind":12,"signature":{"label":"_get_seqs($self)","documentation":"__END__\n# BioPerl module for Bio::SeqIO::tinyseq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::tinyseq - reading/writing sequences in NCBI TinySeq format\n\n=head1 SYNOPSIS\n\nDo not use this module directly; use the SeqIO handler system:\n\n  $stream = Bio::SeqIO->new( -file => $filename, -format => 'tinyseq' );\n\n  while ( my $seq = $stream->next_seq ) {\n    ....\n  }\n\n=head1 DESCRIPTION\n\nThis object reads and writes Bio::Seq objects to and from TinySeq XML\nformat.  A TinySeq is a lightweight XML file of sequence information,\nanalgous to FASTA format.\n\nSee L<http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.mod.dtd> for the DTD.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.bioperl.org\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO>, L<Bio::Seq>.\n\n=head1 AUTHOR\n\nDonald Jackson, E<lt>donald.jackson@bms.comE<gt>\n\nParts of this module and the test script were patterned after Sheldon\nMcKay's L<Bio::SeqIO::game>.  If it breaks, however, it's my fault not\nhis ;).\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::tinyseq;\n\nuse strict;\nuse Bio::Seq::SeqFastaSpeedFactory;\nuse Bio::Species;\nuse Bio::SeqIO::tinyseq::tinyseqHandler;\nuse XML::Parser::PerlSAX;\nuse XML::Writer;\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n    my ($self, @args) = @_;\n\n    $self->SUPER::_initialize(@args);\n\n    unless (defined $self->sequence_factory) {\n\t$self->sequence_factory(Bio::Seq::SeqFastaSpeedFactory->new());\n    }\n\n    $self->{'_species_objects'} = {};\n    $self->{_parsed} = 0;\n}\n\n=head2 next_seq\n\n  Title\t\t: next_seq\n  Usage\t\t: $seq = $stream->next_seq()\n  Function\t: returns the next sequence in the stream\n  Returns\t: Bio::Seq object\n  Args\t\t: NONE\n\n\nsub next_seq {\n    my ($self) = @_;\n\n    $self->_get_seqs() unless ($self->{_parsed});\n\n    return shift @{$self->{_seqlist}};\n}\n\n=head2 write_seq\n\n  Title\t\t: write_seq\n  Usage\t\t: $seq = $stream->write_seq(@sequence_objects); undef $stream\n  Function\t: outputs one or more sequence objects as TinySeq XML\n  Returns\t: 1 on success\n  Args\t\t: one or more sequence objects as TinySeq XML\n\nBecause the TSeq dtd includes closing tags after all sets are written,\nthe output will not be complete until the program terminates or the\nobject is forced out of scope (see close_writer()).  May not perfectly\nreproduce TSeq_sid element for all sequences\n\n\nsub write_seq {\n    my ($self, @seqobjs) = @_;\n\n    $self->throw('write_seq must be called with at least one  Bio::SeqI or Bio::PrimarySeqI compliant object')\n\tunless (@seqobjs and ( $seqobjs[0]->isa('Bio::SeqI') || $seqobjs[0]->isa('Bio::PrimarySeqI')));\n\n    my $writer = $self->_get_writer;\n\n    foreach my $seqobj (@seqobjs) {\n\tmy ($id_element, $id_value) = $self->_get_idstring($seqobj);\n \t$writer->startTag('TSeq');\n\t$writer->emptyTag('TSeq_seqtype', value => $self->_convert_seqtype($seqobj));\n\t$writer->dataElement('TSeq_gi', $seqobj->primary_id || '');\n\t$writer->dataElement($id_element, $id_value);\n\t#$writer->dataElement('TSeq_orgname', $seqobj->taxid) if ($seqobj->can('taxid'); # just a placeholder\n\t$writer->dataElement('TSeq_defline', $seqobj->desc);\n\t$writer->dataElement('TSeq_length', $seqobj->length);\n\t$writer->dataElement('TSeq_sequence', $seqobj->seq);\n\n\tif ($seqobj->can('species') && $seqobj->species) {\n\t    $self->_write_species($writer, $seqobj->species);\n\t}\n\n\t$writer->endTag('TSeq');\n    }\n    1;\n}\n\n=head2 _get_seqs\n\n  Title\t\t: _get_seqs\n  Usage\t\t: Internal function - use next_seq() instead\n  Function\t: parses the XML and creates Bio::Seq objects\n  Returns\t: 1 on success\n  Args\t\t: NONE\n\nCurrently stores all sequence objects into memory.  I will work on do\nmore of a stream-based approach","parameters":[{"label":"$self"}]}},{"containerName":"SeqIO::tinyseq::tinyseqHandler","kind":12,"name":"Bio","line":186},{"line":187,"name":"XML","kind":12,"containerName":"Parser::PerlSAX"},{"name":"Handler","kind":12,"line":187},{"kind":12,"name":"Source","line":189},{"line":189,"kind":12,"name":"ByteStream"},{"name":"_seqlist","kind":12,"line":193},{"line":207,"kind":12,"name":"_seqlist"},{"line":210,"containerName":null,"kind":13,"name":"%self"},{"line":210,"kind":12,"name":"_parsed"},{"signature":{"parameters":[{"label":"$self"},{"label":"$orgname"},{"label":"$taxid"}],"documentation":"__END__\n# BioPerl module for Bio::SeqIO::tinyseq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::tinyseq - reading/writing sequences in NCBI TinySeq format\n\n=head1 SYNOPSIS\n\nDo not use this module directly; use the SeqIO handler system:\n\n  $stream = Bio::SeqIO->new( -file => $filename, -format => 'tinyseq' );\n\n  while ( my $seq = $stream->next_seq ) {\n    ....\n  }\n\n=head1 DESCRIPTION\n\nThis object reads and writes Bio::Seq objects to and from TinySeq XML\nformat.  A TinySeq is a lightweight XML file of sequence information,\nanalgous to FASTA format.\n\nSee L<http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.mod.dtd> for the DTD.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.bioperl.org\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO>, L<Bio::Seq>.\n\n=head1 AUTHOR\n\nDonald Jackson, E<lt>donald.jackson@bms.comE<gt>\n\nParts of this module and the test script were patterned after Sheldon\nMcKay's L<Bio::SeqIO::game>.  If it breaks, however, it's my fault not\nhis ;).\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::tinyseq;\n\nuse strict;\nuse Bio::Seq::SeqFastaSpeedFactory;\nuse Bio::Species;\nuse Bio::SeqIO::tinyseq::tinyseqHandler;\nuse XML::Parser::PerlSAX;\nuse XML::Writer;\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n    my ($self, @args) = @_;\n\n    $self->SUPER::_initialize(@args);\n\n    unless (defined $self->sequence_factory) {\n\t$self->sequence_factory(Bio::Seq::SeqFastaSpeedFactory->new());\n    }\n\n    $self->{'_species_objects'} = {};\n    $self->{_parsed} = 0;\n}\n\n=head2 next_seq\n\n  Title\t\t: next_seq\n  Usage\t\t: $seq = $stream->next_seq()\n  Function\t: returns the next sequence in the stream\n  Returns\t: Bio::Seq object\n  Args\t\t: NONE\n\n\nsub next_seq {\n    my ($self) = @_;\n\n    $self->_get_seqs() unless ($self->{_parsed});\n\n    return shift @{$self->{_seqlist}};\n}\n\n=head2 write_seq\n\n  Title\t\t: write_seq\n  Usage\t\t: $seq = $stream->write_seq(@sequence_objects); undef $stream\n  Function\t: outputs one or more sequence objects as TinySeq XML\n  Returns\t: 1 on success\n  Args\t\t: one or more sequence objects as TinySeq XML\n\nBecause the TSeq dtd includes closing tags after all sets are written,\nthe output will not be complete until the program terminates or the\nobject is forced out of scope (see close_writer()).  May not perfectly\nreproduce TSeq_sid element for all sequences\n\n\nsub write_seq {\n    my ($self, @seqobjs) = @_;\n\n    $self->throw('write_seq must be called with at least one  Bio::SeqI or Bio::PrimarySeqI compliant object')\n\tunless (@seqobjs and ( $seqobjs[0]->isa('Bio::SeqI') || $seqobjs[0]->isa('Bio::PrimarySeqI')));\n\n    my $writer = $self->_get_writer;\n\n    foreach my $seqobj (@seqobjs) {\n\tmy ($id_element, $id_value) = $self->_get_idstring($seqobj);\n \t$writer->startTag('TSeq');\n\t$writer->emptyTag('TSeq_seqtype', value => $self->_convert_seqtype($seqobj));\n\t$writer->dataElement('TSeq_gi', $seqobj->primary_id || '');\n\t$writer->dataElement($id_element, $id_value);\n\t#$writer->dataElement('TSeq_orgname', $seqobj->taxid) if ($seqobj->can('taxid'); # just a placeholder\n\t$writer->dataElement('TSeq_defline', $seqobj->desc);\n\t$writer->dataElement('TSeq_length', $seqobj->length);\n\t$writer->dataElement('TSeq_sequence', $seqobj->seq);\n\n\tif ($seqobj->can('species') && $seqobj->species) {\n\t    $self->_write_species($writer, $seqobj->species);\n\t}\n\n\t$writer->endTag('TSeq');\n    }\n    1;\n}\n\n=head2 _get_seqs\n\n  Title\t\t: _get_seqs\n  Usage\t\t: Internal function - use next_seq() instead\n  Function\t: parses the XML and creates Bio::Seq objects\n  Returns\t: 1 on success\n  Args\t\t: NONE\n\nCurrently stores all sequence objects into memory.  I will work on do\nmore of a stream-based approach\n\n\nsub _get_seqs {\n    my ($self) = @_;\n\n    my $fh = $self->_fh;\n\n    my $handler = Bio::SeqIO::tinyseq::tinyseqHandler->new();\n    my $parser = XML::Parser::PerlSAX->new( Handler => $handler );\n\n    my @seqatts = $parser->parse( Source => { ByteStream => $fh });\n\n    my $factory = $self->sequence_factory;\n\n    $self->{_seqlist} ||= [];\n    foreach my $seqatt(@seqatts) {\n\tforeach my $subatt(@$seqatt) { # why are there two hashes?\n\t    my $seqobj = $factory->create(%$subatt);\n\t    $self->_assign_identifier($seqobj, $subatt);\n\n\t    if ($seqobj->can('species')) {\n# \t\tmy $class = [reverse(split(/ /, $subatt->{'-organism'}))];\n# \t\tmy $species = Bio::Species->new( -classification\t=> $class,\n# \t\t\t\t\t\t -ncbi_taxid\t\t=> $subatt->{'-taxid'} );\n\t\tmy $species = $self->_get_species($subatt->{'-organism'}, $subatt->{'-taxid'});\n\t\t$seqobj->species($species) if ($species);\n\t    }\n\n\t    push(@{$self->{_seqlist}}, $seqobj);\n\t}\n    }\n    $self->{_parsed} = 1;\n}\n\n=head2 _get_species\n\n  Title\t\t: _get_species\n  Usage\t\t: Internal function\n  Function\t: gets a Bio::Species object from cache or creates as needed\n  Returns\t: a Bio::Species object on success, undef on failure\n  Args\t\t: a classification string (eg 'Homo sapiens') and\n                  a NCBI taxon id (optional)\n\nObjects are cached for parsing multiple sequence files.","label":"_get_species($self,$orgname,$taxid)"},"line":226,"kind":12,"range":{"start":{"line":226,"character":0},"end":{"character":9999,"line":234}},"definition":"sub","detail":"($self,$orgname,$taxid)","children":[{"line":227,"kind":13,"localvar":"my","containerName":"_get_species","name":"$self","definition":"my"},{"name":"$orgname","containerName":"_get_species","kind":13,"line":227},{"line":227,"containerName":"_get_species","kind":13,"name":"$taxid"},{"name":"$self","kind":13,"containerName":"_get_species","line":229},{"line":229,"name":"$orgname","kind":13,"containerName":"_get_species"},{"definition":"my","localvar":"my","kind":13,"containerName":"_get_species","name":"$species","line":230},{"name":"$self","kind":13,"containerName":"_get_species","line":230},{"line":230,"name":"_create_species","containerName":"_get_species","kind":12},{"line":230,"name":"$orgname","kind":13,"containerName":"_get_species"},{"line":230,"name":"$taxid","containerName":"_get_species","kind":13},{"line":231,"name":"$self","kind":13,"containerName":"_get_species"},{"kind":13,"containerName":"_get_species","name":"$orgname","line":231},{"name":"$species","containerName":"_get_species","kind":13,"line":231},{"name":"$self","kind":13,"containerName":"_get_species","line":233},{"name":"$orgname","containerName":"_get_species","kind":13,"line":233}],"containerName":"main::","name":"_get_species"},{"kind":12,"range":{"end":{"character":9999,"line":259},"start":{"line":247,"character":0}},"line":247,"signature":{"label":"_create_species($self,$orgname,$taxid)","documentation":"__END__\n# BioPerl module for Bio::SeqIO::tinyseq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::tinyseq - reading/writing sequences in NCBI TinySeq format\n\n=head1 SYNOPSIS\n\nDo not use this module directly; use the SeqIO handler system:\n\n  $stream = Bio::SeqIO->new( -file => $filename, -format => 'tinyseq' );\n\n  while ( my $seq = $stream->next_seq ) {\n    ....\n  }\n\n=head1 DESCRIPTION\n\nThis object reads and writes Bio::Seq objects to and from TinySeq XML\nformat.  A TinySeq is a lightweight XML file of sequence information,\nanalgous to FASTA format.\n\nSee L<http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.mod.dtd> for the DTD.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.bioperl.org\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO>, L<Bio::Seq>.\n\n=head1 AUTHOR\n\nDonald Jackson, E<lt>donald.jackson@bms.comE<gt>\n\nParts of this module and the test script were patterned after Sheldon\nMcKay's L<Bio::SeqIO::game>.  If it breaks, however, it's my fault not\nhis ;).\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::tinyseq;\n\nuse strict;\nuse Bio::Seq::SeqFastaSpeedFactory;\nuse Bio::Species;\nuse Bio::SeqIO::tinyseq::tinyseqHandler;\nuse XML::Parser::PerlSAX;\nuse XML::Writer;\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n    my ($self, @args) = @_;\n\n    $self->SUPER::_initialize(@args);\n\n    unless (defined $self->sequence_factory) {\n\t$self->sequence_factory(Bio::Seq::SeqFastaSpeedFactory->new());\n    }\n\n    $self->{'_species_objects'} = {};\n    $self->{_parsed} = 0;\n}\n\n=head2 next_seq\n\n  Title\t\t: next_seq\n  Usage\t\t: $seq = $stream->next_seq()\n  Function\t: returns the next sequence in the stream\n  Returns\t: Bio::Seq object\n  Args\t\t: NONE\n\n\nsub next_seq {\n    my ($self) = @_;\n\n    $self->_get_seqs() unless ($self->{_parsed});\n\n    return shift @{$self->{_seqlist}};\n}\n\n=head2 write_seq\n\n  Title\t\t: write_seq\n  Usage\t\t: $seq = $stream->write_seq(@sequence_objects); undef $stream\n  Function\t: outputs one or more sequence objects as TinySeq XML\n  Returns\t: 1 on success\n  Args\t\t: one or more sequence objects as TinySeq XML\n\nBecause the TSeq dtd includes closing tags after all sets are written,\nthe output will not be complete until the program terminates or the\nobject is forced out of scope (see close_writer()).  May not perfectly\nreproduce TSeq_sid element for all sequences\n\n\nsub write_seq {\n    my ($self, @seqobjs) = @_;\n\n    $self->throw('write_seq must be called with at least one  Bio::SeqI or Bio::PrimarySeqI compliant object')\n\tunless (@seqobjs and ( $seqobjs[0]->isa('Bio::SeqI') || $seqobjs[0]->isa('Bio::PrimarySeqI')));\n\n    my $writer = $self->_get_writer;\n\n    foreach my $seqobj (@seqobjs) {\n\tmy ($id_element, $id_value) = $self->_get_idstring($seqobj);\n \t$writer->startTag('TSeq');\n\t$writer->emptyTag('TSeq_seqtype', value => $self->_convert_seqtype($seqobj));\n\t$writer->dataElement('TSeq_gi', $seqobj->primary_id || '');\n\t$writer->dataElement($id_element, $id_value);\n\t#$writer->dataElement('TSeq_orgname', $seqobj->taxid) if ($seqobj->can('taxid'); # just a placeholder\n\t$writer->dataElement('TSeq_defline', $seqobj->desc);\n\t$writer->dataElement('TSeq_length', $seqobj->length);\n\t$writer->dataElement('TSeq_sequence', $seqobj->seq);\n\n\tif ($seqobj->can('species') && $seqobj->species) {\n\t    $self->_write_species($writer, $seqobj->species);\n\t}\n\n\t$writer->endTag('TSeq');\n    }\n    1;\n}\n\n=head2 _get_seqs\n\n  Title\t\t: _get_seqs\n  Usage\t\t: Internal function - use next_seq() instead\n  Function\t: parses the XML and creates Bio::Seq objects\n  Returns\t: 1 on success\n  Args\t\t: NONE\n\nCurrently stores all sequence objects into memory.  I will work on do\nmore of a stream-based approach\n\n\nsub _get_seqs {\n    my ($self) = @_;\n\n    my $fh = $self->_fh;\n\n    my $handler = Bio::SeqIO::tinyseq::tinyseqHandler->new();\n    my $parser = XML::Parser::PerlSAX->new( Handler => $handler );\n\n    my @seqatts = $parser->parse( Source => { ByteStream => $fh });\n\n    my $factory = $self->sequence_factory;\n\n    $self->{_seqlist} ||= [];\n    foreach my $seqatt(@seqatts) {\n\tforeach my $subatt(@$seqatt) { # why are there two hashes?\n\t    my $seqobj = $factory->create(%$subatt);\n\t    $self->_assign_identifier($seqobj, $subatt);\n\n\t    if ($seqobj->can('species')) {\n# \t\tmy $class = [reverse(split(/ /, $subatt->{'-organism'}))];\n# \t\tmy $species = Bio::Species->new( -classification\t=> $class,\n# \t\t\t\t\t\t -ncbi_taxid\t\t=> $subatt->{'-taxid'} );\n\t\tmy $species = $self->_get_species($subatt->{'-organism'}, $subatt->{'-taxid'});\n\t\t$seqobj->species($species) if ($species);\n\t    }\n\n\t    push(@{$self->{_seqlist}}, $seqobj);\n\t}\n    }\n    $self->{_parsed} = 1;\n}\n\n=head2 _get_species\n\n  Title\t\t: _get_species\n  Usage\t\t: Internal function\n  Function\t: gets a Bio::Species object from cache or creates as needed\n  Returns\t: a Bio::Species object on success, undef on failure\n  Args\t\t: a classification string (eg 'Homo sapiens') and\n                  a NCBI taxon id (optional)\n\nObjects are cached for parsing multiple sequence files.\n\n\nsub _get_species {\n     my ($self, $orgname, $taxid) = @_;\n\n     unless ($self->{'_species_objects'}->{$orgname}) {\n\t my $species = $self->_create_species($orgname, $taxid);\n\t $self->{'_species_objects'}->{$orgname} = $species;\n     }\n     return $self->{'_species_objects'}->{$orgname};\n}\n\n=head2 _create_species\n\n  Title\t\t: _create_species\n  Usage\t\t: Internal function\n  Function\t: creates a Bio::Species object\n  Returns\t: a Bio::Species object on success, undef on failure\n  Args\t\t: a classification string (eg 'Homo sapiens') and\n                  a NCBI taxon id (optional)","parameters":[{"label":"$self"},{"label":"$orgname"},{"label":"$taxid"}]},"name":"_create_species","containerName":"main::","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"_create_species","name":"$self","line":248},{"containerName":"_create_species","kind":13,"name":"$orgname","line":248},{"line":248,"name":"$taxid","kind":13,"containerName":"_create_species"},{"line":249,"name":"$orgname","containerName":"_create_species","kind":13},{"line":251,"name":"%params","containerName":"_create_species","localvar":"my","kind":13,"definition":"my"},{"line":252,"containerName":"_create_species","kind":13,"name":"$params"},{"line":252,"kind":13,"containerName":"_create_species","name":"$orgname"},{"line":253,"name":"$params","kind":13,"containerName":"_create_species"},{"name":"$taxid","kind":13,"containerName":"_create_species","line":253},{"line":253,"name":"$taxid","kind":13,"containerName":"_create_species"},{"kind":13,"localvar":"my","containerName":"_create_species","name":"$species","line":255,"definition":"my"},{"line":255,"kind":12,"containerName":"_create_species","name":"new"},{"line":255,"name":"%params","kind":13,"containerName":"_create_species"},{"line":258,"containerName":"_create_species","kind":13,"name":"$species"}],"detail":"($self,$orgname,$taxid)","definition":"sub"},{"kind":12,"containerName":"Species","name":"Bio","line":255},{"definition":"sub","detail":"($self,$seqobj,$atts)","children":[{"name":"$self","containerName":"_assign_identifier","localvar":"my","kind":13,"line":275,"definition":"my"},{"line":275,"containerName":"_assign_identifier","kind":13,"name":"$seqobj"},{"name":"$atts","kind":13,"containerName":"_assign_identifier","line":275},{"localvar":"my","kind":13,"containerName":"_assign_identifier","name":"$accession","line":276,"definition":"my"},{"name":"$version","containerName":"_assign_identifier","kind":13,"line":276},{"line":278,"containerName":"_assign_identifier","kind":13,"name":"$atts"},{"name":"$accession","containerName":"_assign_identifier","kind":13,"line":279},{"line":279,"name":"$version","containerName":"_assign_identifier","kind":13},{"line":279,"containerName":"_assign_identifier","kind":13,"name":"$atts"},{"name":"$atts","kind":13,"containerName":"_assign_identifier","line":281},{"localvar":"my","kind":13,"containerName":"_assign_identifier","name":"$sidstring","line":282,"definition":"my"},{"line":282,"containerName":"_assign_identifier","kind":13,"name":"$atts"},{"line":283,"kind":13,"containerName":"_assign_identifier","name":"$sidstring"},{"name":"$sidstring","containerName":"_assign_identifier","kind":13,"line":284},{"kind":13,"containerName":"_assign_identifier","name":"$accession","line":285},{"line":285,"containerName":"_assign_identifier","kind":13,"name":"$version"},{"kind":13,"containerName":"_assign_identifier","name":"$sidstring","line":285},{"containerName":"_assign_identifier","kind":13,"name":"$self","line":288},{"containerName":"_assign_identifier","kind":12,"name":"throw","line":288},{"line":290,"name":"$seqobj","kind":13,"containerName":"_assign_identifier"},{"name":"accession_number","containerName":"_assign_identifier","kind":12,"line":290},{"line":290,"containerName":"_assign_identifier","kind":13,"name":"$accession"},{"line":290,"name":"$seqobj","containerName":"_assign_identifier","kind":13},{"containerName":"_assign_identifier","kind":12,"name":"can","line":290},{"line":291,"kind":13,"containerName":"_assign_identifier","name":"$seqobj"},{"line":291,"name":"version","kind":12,"containerName":"_assign_identifier"},{"containerName":"_assign_identifier","kind":13,"name":"$version","line":291},{"line":291,"kind":13,"containerName":"_assign_identifier","name":"$seqobj"},{"line":291,"containerName":"_assign_identifier","kind":12,"name":"can"}],"containerName":"main::","name":"_assign_identifier","signature":{"label":"_assign_identifier($self,$seqobj,$atts)","parameters":[{"label":"$self"},{"label":"$seqobj"},{"label":"$atts"}],"documentation":"__END__\n# BioPerl module for Bio::SeqIO::tinyseq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::tinyseq - reading/writing sequences in NCBI TinySeq format\n\n=head1 SYNOPSIS\n\nDo not use this module directly; use the SeqIO handler system:\n\n  $stream = Bio::SeqIO->new( -file => $filename, -format => 'tinyseq' );\n\n  while ( my $seq = $stream->next_seq ) {\n    ....\n  }\n\n=head1 DESCRIPTION\n\nThis object reads and writes Bio::Seq objects to and from TinySeq XML\nformat.  A TinySeq is a lightweight XML file of sequence information,\nanalgous to FASTA format.\n\nSee L<http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.mod.dtd> for the DTD.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.bioperl.org\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO>, L<Bio::Seq>.\n\n=head1 AUTHOR\n\nDonald Jackson, E<lt>donald.jackson@bms.comE<gt>\n\nParts of this module and the test script were patterned after Sheldon\nMcKay's L<Bio::SeqIO::game>.  If it breaks, however, it's my fault not\nhis ;).\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::tinyseq;\n\nuse strict;\nuse Bio::Seq::SeqFastaSpeedFactory;\nuse Bio::Species;\nuse Bio::SeqIO::tinyseq::tinyseqHandler;\nuse XML::Parser::PerlSAX;\nuse XML::Writer;\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n    my ($self, @args) = @_;\n\n    $self->SUPER::_initialize(@args);\n\n    unless (defined $self->sequence_factory) {\n\t$self->sequence_factory(Bio::Seq::SeqFastaSpeedFactory->new());\n    }\n\n    $self->{'_species_objects'} = {};\n    $self->{_parsed} = 0;\n}\n\n=head2 next_seq\n\n  Title\t\t: next_seq\n  Usage\t\t: $seq = $stream->next_seq()\n  Function\t: returns the next sequence in the stream\n  Returns\t: Bio::Seq object\n  Args\t\t: NONE\n\n\nsub next_seq {\n    my ($self) = @_;\n\n    $self->_get_seqs() unless ($self->{_parsed});\n\n    return shift @{$self->{_seqlist}};\n}\n\n=head2 write_seq\n\n  Title\t\t: write_seq\n  Usage\t\t: $seq = $stream->write_seq(@sequence_objects); undef $stream\n  Function\t: outputs one or more sequence objects as TinySeq XML\n  Returns\t: 1 on success\n  Args\t\t: one or more sequence objects as TinySeq XML\n\nBecause the TSeq dtd includes closing tags after all sets are written,\nthe output will not be complete until the program terminates or the\nobject is forced out of scope (see close_writer()).  May not perfectly\nreproduce TSeq_sid element for all sequences\n\n\nsub write_seq {\n    my ($self, @seqobjs) = @_;\n\n    $self->throw('write_seq must be called with at least one  Bio::SeqI or Bio::PrimarySeqI compliant object')\n\tunless (@seqobjs and ( $seqobjs[0]->isa('Bio::SeqI') || $seqobjs[0]->isa('Bio::PrimarySeqI')));\n\n    my $writer = $self->_get_writer;\n\n    foreach my $seqobj (@seqobjs) {\n\tmy ($id_element, $id_value) = $self->_get_idstring($seqobj);\n \t$writer->startTag('TSeq');\n\t$writer->emptyTag('TSeq_seqtype', value => $self->_convert_seqtype($seqobj));\n\t$writer->dataElement('TSeq_gi', $seqobj->primary_id || '');\n\t$writer->dataElement($id_element, $id_value);\n\t#$writer->dataElement('TSeq_orgname', $seqobj->taxid) if ($seqobj->can('taxid'); # just a placeholder\n\t$writer->dataElement('TSeq_defline', $seqobj->desc);\n\t$writer->dataElement('TSeq_length', $seqobj->length);\n\t$writer->dataElement('TSeq_sequence', $seqobj->seq);\n\n\tif ($seqobj->can('species') && $seqobj->species) {\n\t    $self->_write_species($writer, $seqobj->species);\n\t}\n\n\t$writer->endTag('TSeq');\n    }\n    1;\n}\n\n=head2 _get_seqs\n\n  Title\t\t: _get_seqs\n  Usage\t\t: Internal function - use next_seq() instead\n  Function\t: parses the XML and creates Bio::Seq objects\n  Returns\t: 1 on success\n  Args\t\t: NONE\n\nCurrently stores all sequence objects into memory.  I will work on do\nmore of a stream-based approach\n\n\nsub _get_seqs {\n    my ($self) = @_;\n\n    my $fh = $self->_fh;\n\n    my $handler = Bio::SeqIO::tinyseq::tinyseqHandler->new();\n    my $parser = XML::Parser::PerlSAX->new( Handler => $handler );\n\n    my @seqatts = $parser->parse( Source => { ByteStream => $fh });\n\n    my $factory = $self->sequence_factory;\n\n    $self->{_seqlist} ||= [];\n    foreach my $seqatt(@seqatts) {\n\tforeach my $subatt(@$seqatt) { # why are there two hashes?\n\t    my $seqobj = $factory->create(%$subatt);\n\t    $self->_assign_identifier($seqobj, $subatt);\n\n\t    if ($seqobj->can('species')) {\n# \t\tmy $class = [reverse(split(/ /, $subatt->{'-organism'}))];\n# \t\tmy $species = Bio::Species->new( -classification\t=> $class,\n# \t\t\t\t\t\t -ncbi_taxid\t\t=> $subatt->{'-taxid'} );\n\t\tmy $species = $self->_get_species($subatt->{'-organism'}, $subatt->{'-taxid'});\n\t\t$seqobj->species($species) if ($species);\n\t    }\n\n\t    push(@{$self->{_seqlist}}, $seqobj);\n\t}\n    }\n    $self->{_parsed} = 1;\n}\n\n=head2 _get_species\n\n  Title\t\t: _get_species\n  Usage\t\t: Internal function\n  Function\t: gets a Bio::Species object from cache or creates as needed\n  Returns\t: a Bio::Species object on success, undef on failure\n  Args\t\t: a classification string (eg 'Homo sapiens') and\n                  a NCBI taxon id (optional)\n\nObjects are cached for parsing multiple sequence files.\n\n\nsub _get_species {\n     my ($self, $orgname, $taxid) = @_;\n\n     unless ($self->{'_species_objects'}->{$orgname}) {\n\t my $species = $self->_create_species($orgname, $taxid);\n\t $self->{'_species_objects'}->{$orgname} = $species;\n     }\n     return $self->{'_species_objects'}->{$orgname};\n}\n\n=head2 _create_species\n\n  Title\t\t: _create_species\n  Usage\t\t: Internal function\n  Function\t: creates a Bio::Species object\n  Returns\t: a Bio::Species object on success, undef on failure\n  Args\t\t: a classification string (eg 'Homo sapiens') and\n                  a NCBI taxon id (optional)\n\n\nsub _create_species {\n    my ($self, $orgname, $taxid) = @_;\n    return unless ($orgname); # not required in TinySeq dtd so don't throw an error\n\n    my %params;\n    $params{'-classification'} = [reverse(split(/ /, $orgname))];\n    $params{'-ncbi_taxid'} = $taxid if ($taxid);\n\n    my $species = Bio::Species->new(%params)\n\tor return;\n\n    return $species;\n}\n\n\n=head2 _assign_identifier\n\n  Title\t\t: _assign_identifier\n  Usage\t\t: Internal function\n  Function\t: looks for sequence accession\n  Returns\t: 1 on success\n  Args\t\t: NONE\n\nNCBI puts refseq accessions in TSeq_sid, others in TSeq_accver."},"line":274,"range":{"end":{"character":9999,"line":293},"start":{"character":0,"line":274}},"kind":12},{"definition":"sub","detail":"($self,$seqobj)","children":[{"localvar":"my","kind":13,"containerName":"_convert_seqtype","name":"$self","line":305,"definition":"my"},{"line":305,"name":"$seqobj","containerName":"_convert_seqtype","kind":13},{"line":307,"name":"$seqobj","kind":13,"containerName":"_convert_seqtype"},{"line":307,"containerName":"_convert_seqtype","kind":12,"name":"alphabet"},{"line":308,"name":"$seqobj","containerName":"_convert_seqtype","kind":13},{"line":308,"kind":12,"containerName":"_convert_seqtype","name":"alphabet"},{"line":309,"containerName":"_convert_seqtype","kind":13,"name":"$seqobj"},{"line":309,"name":"alphabet","containerName":"_convert_seqtype","kind":12},{"line":312,"name":"$self","kind":13,"containerName":"_convert_seqtype"},{"name":"throw","containerName":"_convert_seqtype","kind":12,"line":312}],"name":"_convert_seqtype","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$seqobj"}],"documentation":"__END__\n# BioPerl module for Bio::SeqIO::tinyseq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::tinyseq - reading/writing sequences in NCBI TinySeq format\n\n=head1 SYNOPSIS\n\nDo not use this module directly; use the SeqIO handler system:\n\n  $stream = Bio::SeqIO->new( -file => $filename, -format => 'tinyseq' );\n\n  while ( my $seq = $stream->next_seq ) {\n    ....\n  }\n\n=head1 DESCRIPTION\n\nThis object reads and writes Bio::Seq objects to and from TinySeq XML\nformat.  A TinySeq is a lightweight XML file of sequence information,\nanalgous to FASTA format.\n\nSee L<http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.mod.dtd> for the DTD.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.bioperl.org\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO>, L<Bio::Seq>.\n\n=head1 AUTHOR\n\nDonald Jackson, E<lt>donald.jackson@bms.comE<gt>\n\nParts of this module and the test script were patterned after Sheldon\nMcKay's L<Bio::SeqIO::game>.  If it breaks, however, it's my fault not\nhis ;).\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::tinyseq;\n\nuse strict;\nuse Bio::Seq::SeqFastaSpeedFactory;\nuse Bio::Species;\nuse Bio::SeqIO::tinyseq::tinyseqHandler;\nuse XML::Parser::PerlSAX;\nuse XML::Writer;\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n    my ($self, @args) = @_;\n\n    $self->SUPER::_initialize(@args);\n\n    unless (defined $self->sequence_factory) {\n\t$self->sequence_factory(Bio::Seq::SeqFastaSpeedFactory->new());\n    }\n\n    $self->{'_species_objects'} = {};\n    $self->{_parsed} = 0;\n}\n\n=head2 next_seq\n\n  Title\t\t: next_seq\n  Usage\t\t: $seq = $stream->next_seq()\n  Function\t: returns the next sequence in the stream\n  Returns\t: Bio::Seq object\n  Args\t\t: NONE\n\n\nsub next_seq {\n    my ($self) = @_;\n\n    $self->_get_seqs() unless ($self->{_parsed});\n\n    return shift @{$self->{_seqlist}};\n}\n\n=head2 write_seq\n\n  Title\t\t: write_seq\n  Usage\t\t: $seq = $stream->write_seq(@sequence_objects); undef $stream\n  Function\t: outputs one or more sequence objects as TinySeq XML\n  Returns\t: 1 on success\n  Args\t\t: one or more sequence objects as TinySeq XML\n\nBecause the TSeq dtd includes closing tags after all sets are written,\nthe output will not be complete until the program terminates or the\nobject is forced out of scope (see close_writer()).  May not perfectly\nreproduce TSeq_sid element for all sequences\n\n\nsub write_seq {\n    my ($self, @seqobjs) = @_;\n\n    $self->throw('write_seq must be called with at least one  Bio::SeqI or Bio::PrimarySeqI compliant object')\n\tunless (@seqobjs and ( $seqobjs[0]->isa('Bio::SeqI') || $seqobjs[0]->isa('Bio::PrimarySeqI')));\n\n    my $writer = $self->_get_writer;\n\n    foreach my $seqobj (@seqobjs) {\n\tmy ($id_element, $id_value) = $self->_get_idstring($seqobj);\n \t$writer->startTag('TSeq');\n\t$writer->emptyTag('TSeq_seqtype', value => $self->_convert_seqtype($seqobj));\n\t$writer->dataElement('TSeq_gi', $seqobj->primary_id || '');\n\t$writer->dataElement($id_element, $id_value);\n\t#$writer->dataElement('TSeq_orgname', $seqobj->taxid) if ($seqobj->can('taxid'); # just a placeholder\n\t$writer->dataElement('TSeq_defline', $seqobj->desc);\n\t$writer->dataElement('TSeq_length', $seqobj->length);\n\t$writer->dataElement('TSeq_sequence', $seqobj->seq);\n\n\tif ($seqobj->can('species') && $seqobj->species) {\n\t    $self->_write_species($writer, $seqobj->species);\n\t}\n\n\t$writer->endTag('TSeq');\n    }\n    1;\n}\n\n=head2 _get_seqs\n\n  Title\t\t: _get_seqs\n  Usage\t\t: Internal function - use next_seq() instead\n  Function\t: parses the XML and creates Bio::Seq objects\n  Returns\t: 1 on success\n  Args\t\t: NONE\n\nCurrently stores all sequence objects into memory.  I will work on do\nmore of a stream-based approach\n\n\nsub _get_seqs {\n    my ($self) = @_;\n\n    my $fh = $self->_fh;\n\n    my $handler = Bio::SeqIO::tinyseq::tinyseqHandler->new();\n    my $parser = XML::Parser::PerlSAX->new( Handler => $handler );\n\n    my @seqatts = $parser->parse( Source => { ByteStream => $fh });\n\n    my $factory = $self->sequence_factory;\n\n    $self->{_seqlist} ||= [];\n    foreach my $seqatt(@seqatts) {\n\tforeach my $subatt(@$seqatt) { # why are there two hashes?\n\t    my $seqobj = $factory->create(%$subatt);\n\t    $self->_assign_identifier($seqobj, $subatt);\n\n\t    if ($seqobj->can('species')) {\n# \t\tmy $class = [reverse(split(/ /, $subatt->{'-organism'}))];\n# \t\tmy $species = Bio::Species->new( -classification\t=> $class,\n# \t\t\t\t\t\t -ncbi_taxid\t\t=> $subatt->{'-taxid'} );\n\t\tmy $species = $self->_get_species($subatt->{'-organism'}, $subatt->{'-taxid'});\n\t\t$seqobj->species($species) if ($species);\n\t    }\n\n\t    push(@{$self->{_seqlist}}, $seqobj);\n\t}\n    }\n    $self->{_parsed} = 1;\n}\n\n=head2 _get_species\n\n  Title\t\t: _get_species\n  Usage\t\t: Internal function\n  Function\t: gets a Bio::Species object from cache or creates as needed\n  Returns\t: a Bio::Species object on success, undef on failure\n  Args\t\t: a classification string (eg 'Homo sapiens') and\n                  a NCBI taxon id (optional)\n\nObjects are cached for parsing multiple sequence files.\n\n\nsub _get_species {\n     my ($self, $orgname, $taxid) = @_;\n\n     unless ($self->{'_species_objects'}->{$orgname}) {\n\t my $species = $self->_create_species($orgname, $taxid);\n\t $self->{'_species_objects'}->{$orgname} = $species;\n     }\n     return $self->{'_species_objects'}->{$orgname};\n}\n\n=head2 _create_species\n\n  Title\t\t: _create_species\n  Usage\t\t: Internal function\n  Function\t: creates a Bio::Species object\n  Returns\t: a Bio::Species object on success, undef on failure\n  Args\t\t: a classification string (eg 'Homo sapiens') and\n                  a NCBI taxon id (optional)\n\n\nsub _create_species {\n    my ($self, $orgname, $taxid) = @_;\n    return unless ($orgname); # not required in TinySeq dtd so don't throw an error\n\n    my %params;\n    $params{'-classification'} = [reverse(split(/ /, $orgname))];\n    $params{'-ncbi_taxid'} = $taxid if ($taxid);\n\n    my $species = Bio::Species->new(%params)\n\tor return;\n\n    return $species;\n}\n\n\n=head2 _assign_identifier\n\n  Title\t\t: _assign_identifier\n  Usage\t\t: Internal function\n  Function\t: looks for sequence accession\n  Returns\t: 1 on success\n  Args\t\t: NONE\n\nNCBI puts refseq accessions in TSeq_sid, others in TSeq_accver.\n\n\nsub _assign_identifier {\n    my ($self, $seqobj, $atts) = @_;\n    my ($accession, $version);\n\n   if ($atts->{'-accver'}) {\n\t($accession, $version) = split(/\\./, $atts->{'-accver'});;\n    }\n    elsif ($atts->{'-sid'}) {\n\tmy $sidstring =$atts->{'-sid'};\n\t$sidstring =~ s/^.+?\\|//;\n\t$sidstring =~ s/\\|[^\\|]*//;\n\t($accession, $version) = split(/\\./, $sidstring);;\n    }\n    else {\n\t$self->throw('NO accession information found for this sequence');\n    }\n    $seqobj->accession_number($accession) if ($seqobj->can('accession_number'));\n    $seqobj->version($version) if ($seqobj->can('version'));\n\n}\n\n=head2 _convert_seqtype\n\n  Title\t\t: _convert_seqtype\n  Usage\t\t: Internal function\n  Function\t: maps Bio::Seq::alphabet() values [dna/rna/protein] onto\n                  TSeq_seqtype values [protein/nucleotide]","label":"_convert_seqtype($self,$seqobj)"},"line":304,"kind":12,"range":{"start":{"character":0,"line":304},"end":{"line":313,"character":9999}}},{"line":324,"kind":12,"range":{"start":{"line":324,"character":0},"end":{"line":335,"character":9999}},"signature":{"label":"_get_idstring($self,$seqobj)","documentation":"__END__\n# BioPerl module for Bio::SeqIO::tinyseq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::tinyseq - reading/writing sequences in NCBI TinySeq format\n\n=head1 SYNOPSIS\n\nDo not use this module directly; use the SeqIO handler system:\n\n  $stream = Bio::SeqIO->new( -file => $filename, -format => 'tinyseq' );\n\n  while ( my $seq = $stream->next_seq ) {\n    ....\n  }\n\n=head1 DESCRIPTION\n\nThis object reads and writes Bio::Seq objects to and from TinySeq XML\nformat.  A TinySeq is a lightweight XML file of sequence information,\nanalgous to FASTA format.\n\nSee L<http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.mod.dtd> for the DTD.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.bioperl.org\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO>, L<Bio::Seq>.\n\n=head1 AUTHOR\n\nDonald Jackson, E<lt>donald.jackson@bms.comE<gt>\n\nParts of this module and the test script were patterned after Sheldon\nMcKay's L<Bio::SeqIO::game>.  If it breaks, however, it's my fault not\nhis ;).\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::tinyseq;\n\nuse strict;\nuse Bio::Seq::SeqFastaSpeedFactory;\nuse Bio::Species;\nuse Bio::SeqIO::tinyseq::tinyseqHandler;\nuse XML::Parser::PerlSAX;\nuse XML::Writer;\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n    my ($self, @args) = @_;\n\n    $self->SUPER::_initialize(@args);\n\n    unless (defined $self->sequence_factory) {\n\t$self->sequence_factory(Bio::Seq::SeqFastaSpeedFactory->new());\n    }\n\n    $self->{'_species_objects'} = {};\n    $self->{_parsed} = 0;\n}\n\n=head2 next_seq\n\n  Title\t\t: next_seq\n  Usage\t\t: $seq = $stream->next_seq()\n  Function\t: returns the next sequence in the stream\n  Returns\t: Bio::Seq object\n  Args\t\t: NONE\n\n\nsub next_seq {\n    my ($self) = @_;\n\n    $self->_get_seqs() unless ($self->{_parsed});\n\n    return shift @{$self->{_seqlist}};\n}\n\n=head2 write_seq\n\n  Title\t\t: write_seq\n  Usage\t\t: $seq = $stream->write_seq(@sequence_objects); undef $stream\n  Function\t: outputs one or more sequence objects as TinySeq XML\n  Returns\t: 1 on success\n  Args\t\t: one or more sequence objects as TinySeq XML\n\nBecause the TSeq dtd includes closing tags after all sets are written,\nthe output will not be complete until the program terminates or the\nobject is forced out of scope (see close_writer()).  May not perfectly\nreproduce TSeq_sid element for all sequences\n\n\nsub write_seq {\n    my ($self, @seqobjs) = @_;\n\n    $self->throw('write_seq must be called with at least one  Bio::SeqI or Bio::PrimarySeqI compliant object')\n\tunless (@seqobjs and ( $seqobjs[0]->isa('Bio::SeqI') || $seqobjs[0]->isa('Bio::PrimarySeqI')));\n\n    my $writer = $self->_get_writer;\n\n    foreach my $seqobj (@seqobjs) {\n\tmy ($id_element, $id_value) = $self->_get_idstring($seqobj);\n \t$writer->startTag('TSeq');\n\t$writer->emptyTag('TSeq_seqtype', value => $self->_convert_seqtype($seqobj));\n\t$writer->dataElement('TSeq_gi', $seqobj->primary_id || '');\n\t$writer->dataElement($id_element, $id_value);\n\t#$writer->dataElement('TSeq_orgname', $seqobj->taxid) if ($seqobj->can('taxid'); # just a placeholder\n\t$writer->dataElement('TSeq_defline', $seqobj->desc);\n\t$writer->dataElement('TSeq_length', $seqobj->length);\n\t$writer->dataElement('TSeq_sequence', $seqobj->seq);\n\n\tif ($seqobj->can('species') && $seqobj->species) {\n\t    $self->_write_species($writer, $seqobj->species);\n\t}\n\n\t$writer->endTag('TSeq');\n    }\n    1;\n}\n\n=head2 _get_seqs\n\n  Title\t\t: _get_seqs\n  Usage\t\t: Internal function - use next_seq() instead\n  Function\t: parses the XML and creates Bio::Seq objects\n  Returns\t: 1 on success\n  Args\t\t: NONE\n\nCurrently stores all sequence objects into memory.  I will work on do\nmore of a stream-based approach\n\n\nsub _get_seqs {\n    my ($self) = @_;\n\n    my $fh = $self->_fh;\n\n    my $handler = Bio::SeqIO::tinyseq::tinyseqHandler->new();\n    my $parser = XML::Parser::PerlSAX->new( Handler => $handler );\n\n    my @seqatts = $parser->parse( Source => { ByteStream => $fh });\n\n    my $factory = $self->sequence_factory;\n\n    $self->{_seqlist} ||= [];\n    foreach my $seqatt(@seqatts) {\n\tforeach my $subatt(@$seqatt) { # why are there two hashes?\n\t    my $seqobj = $factory->create(%$subatt);\n\t    $self->_assign_identifier($seqobj, $subatt);\n\n\t    if ($seqobj->can('species')) {\n# \t\tmy $class = [reverse(split(/ /, $subatt->{'-organism'}))];\n# \t\tmy $species = Bio::Species->new( -classification\t=> $class,\n# \t\t\t\t\t\t -ncbi_taxid\t\t=> $subatt->{'-taxid'} );\n\t\tmy $species = $self->_get_species($subatt->{'-organism'}, $subatt->{'-taxid'});\n\t\t$seqobj->species($species) if ($species);\n\t    }\n\n\t    push(@{$self->{_seqlist}}, $seqobj);\n\t}\n    }\n    $self->{_parsed} = 1;\n}\n\n=head2 _get_species\n\n  Title\t\t: _get_species\n  Usage\t\t: Internal function\n  Function\t: gets a Bio::Species object from cache or creates as needed\n  Returns\t: a Bio::Species object on success, undef on failure\n  Args\t\t: a classification string (eg 'Homo sapiens') and\n                  a NCBI taxon id (optional)\n\nObjects are cached for parsing multiple sequence files.\n\n\nsub _get_species {\n     my ($self, $orgname, $taxid) = @_;\n\n     unless ($self->{'_species_objects'}->{$orgname}) {\n\t my $species = $self->_create_species($orgname, $taxid);\n\t $self->{'_species_objects'}->{$orgname} = $species;\n     }\n     return $self->{'_species_objects'}->{$orgname};\n}\n\n=head2 _create_species\n\n  Title\t\t: _create_species\n  Usage\t\t: Internal function\n  Function\t: creates a Bio::Species object\n  Returns\t: a Bio::Species object on success, undef on failure\n  Args\t\t: a classification string (eg 'Homo sapiens') and\n                  a NCBI taxon id (optional)\n\n\nsub _create_species {\n    my ($self, $orgname, $taxid) = @_;\n    return unless ($orgname); # not required in TinySeq dtd so don't throw an error\n\n    my %params;\n    $params{'-classification'} = [reverse(split(/ /, $orgname))];\n    $params{'-ncbi_taxid'} = $taxid if ($taxid);\n\n    my $species = Bio::Species->new(%params)\n\tor return;\n\n    return $species;\n}\n\n\n=head2 _assign_identifier\n\n  Title\t\t: _assign_identifier\n  Usage\t\t: Internal function\n  Function\t: looks for sequence accession\n  Returns\t: 1 on success\n  Args\t\t: NONE\n\nNCBI puts refseq accessions in TSeq_sid, others in TSeq_accver.\n\n\nsub _assign_identifier {\n    my ($self, $seqobj, $atts) = @_;\n    my ($accession, $version);\n\n   if ($atts->{'-accver'}) {\n\t($accession, $version) = split(/\\./, $atts->{'-accver'});;\n    }\n    elsif ($atts->{'-sid'}) {\n\tmy $sidstring =$atts->{'-sid'};\n\t$sidstring =~ s/^.+?\\|//;\n\t$sidstring =~ s/\\|[^\\|]*//;\n\t($accession, $version) = split(/\\./, $sidstring);;\n    }\n    else {\n\t$self->throw('NO accession information found for this sequence');\n    }\n    $seqobj->accession_number($accession) if ($seqobj->can('accession_number'));\n    $seqobj->version($version) if ($seqobj->can('version'));\n\n}\n\n=head2 _convert_seqtype\n\n  Title\t\t: _convert_seqtype\n  Usage\t\t: Internal function\n  Function\t: maps Bio::Seq::alphabet() values [dna/rna/protein] onto\n                  TSeq_seqtype values [protein/nucleotide]\n\n\nsub _convert_seqtype {\n    my ($self, $seqobj) = @_;\n\n    return 'protein' \tif ($seqobj->alphabet eq 'protein');\n    return 'nucleotide' if ($seqobj->alphabet eq 'dna');\n    return 'nucleotide' if ($seqobj->alphabet eq 'rna');\n\n    # if we get here there's a problem!\n    $self->throw(\"Alphabet not defined, can't assign type for $seqobj\");\n}\n\n=head2 _get_idstring\n\n  Title\t\t: _get_idstring\n  Usage\t\t: Internal function\n  Function\t: parse accession and version info from TSeq_accver\n                  or TSeq_sid","parameters":[{"label":"$self"},{"label":"$seqobj"}]},"children":[{"line":326,"name":"$self","containerName":"_get_idstring","localvar":"my","kind":13,"definition":"my"},{"line":326,"kind":13,"containerName":"_get_idstring","name":"$seqobj"},{"definition":"my","line":327,"localvar":"my","kind":13,"containerName":"_get_idstring","name":"$accver"},{"containerName":"_get_idstring","kind":13,"name":"$seqobj","line":327},{"name":"accession_number","kind":12,"containerName":"_get_idstring","line":327},{"line":328,"name":"$accver","kind":13,"containerName":"_get_idstring"},{"line":328,"name":"$seqobj","containerName":"_get_idstring","kind":13},{"line":328,"name":"version","containerName":"_get_idstring","kind":12},{"name":"$seqobj","kind":13,"containerName":"_get_idstring","line":328},{"name":"can","containerName":"_get_idstring","kind":12,"line":328},{"line":328,"name":"$seqobj","containerName":"_get_idstring","kind":13},{"line":328,"name":"version","kind":12,"containerName":"_get_idstring"},{"name":"$accver","containerName":"_get_idstring","kind":13,"line":329},{"line":330,"kind":13,"containerName":"_get_idstring","name":"$accver"},{"line":333,"name":"$accver","kind":13,"containerName":"_get_idstring"}],"name":"_get_idstring","containerName":"main::","definition":"sub","detail":"($self,$seqobj)"},{"containerName":"main::","name":"_get_writer","children":[{"definition":"my","line":348,"localvar":"my","containerName":"_get_writer","kind":13,"name":"$self"},{"name":"$self","kind":13,"containerName":"_get_writer","line":350},{"line":351,"kind":13,"localvar":"my","containerName":"_get_writer","name":"$fh","definition":"my"},{"kind":13,"containerName":"_get_writer","name":"$self","line":351},{"line":351,"name":"_fh","containerName":"_get_writer","kind":12},{"line":352,"name":"$writer","kind":13,"localvar":"my","containerName":"_get_writer","definition":"my"},{"name":"new","containerName":"_get_writer","kind":12,"line":352},{"line":352,"name":"$fh","containerName":"_get_writer","kind":13},{"name":"$writer","kind":13,"containerName":"_get_writer","line":357},{"name":"doctype","containerName":"_get_writer","kind":12,"line":357},{"line":359,"name":"$writer","kind":13,"containerName":"_get_writer"},{"line":359,"name":"comment","kind":12,"containerName":"_get_writer"},{"line":359,"containerName":"_get_writer","kind":13,"name":"$Bio"},{"kind":13,"containerName":"_get_writer","name":"$writer","line":361},{"name":"startTag","kind":12,"containerName":"_get_writer","line":361},{"name":"$self","kind":13,"containerName":"_get_writer","line":363},{"kind":13,"containerName":"_get_writer","name":"$writer","line":363},{"line":365,"name":"$self","kind":13,"containerName":"_get_writer"}],"detail":"($self)","definition":"sub","range":{"end":{"character":9999,"line":366},"start":{"character":0,"line":346}},"kind":12,"line":346,"signature":{"parameters":[{"label":"$self"}],"documentation":"__END__\n# BioPerl module for Bio::SeqIO::tinyseq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::tinyseq - reading/writing sequences in NCBI TinySeq format\n\n=head1 SYNOPSIS\n\nDo not use this module directly; use the SeqIO handler system:\n\n  $stream = Bio::SeqIO->new( -file => $filename, -format => 'tinyseq' );\n\n  while ( my $seq = $stream->next_seq ) {\n    ....\n  }\n\n=head1 DESCRIPTION\n\nThis object reads and writes Bio::Seq objects to and from TinySeq XML\nformat.  A TinySeq is a lightweight XML file of sequence information,\nanalgous to FASTA format.\n\nSee L<http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.mod.dtd> for the DTD.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.bioperl.org\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO>, L<Bio::Seq>.\n\n=head1 AUTHOR\n\nDonald Jackson, E<lt>donald.jackson@bms.comE<gt>\n\nParts of this module and the test script were patterned after Sheldon\nMcKay's L<Bio::SeqIO::game>.  If it breaks, however, it's my fault not\nhis ;).\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::tinyseq;\n\nuse strict;\nuse Bio::Seq::SeqFastaSpeedFactory;\nuse Bio::Species;\nuse Bio::SeqIO::tinyseq::tinyseqHandler;\nuse XML::Parser::PerlSAX;\nuse XML::Writer;\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n    my ($self, @args) = @_;\n\n    $self->SUPER::_initialize(@args);\n\n    unless (defined $self->sequence_factory) {\n\t$self->sequence_factory(Bio::Seq::SeqFastaSpeedFactory->new());\n    }\n\n    $self->{'_species_objects'} = {};\n    $self->{_parsed} = 0;\n}\n\n=head2 next_seq\n\n  Title\t\t: next_seq\n  Usage\t\t: $seq = $stream->next_seq()\n  Function\t: returns the next sequence in the stream\n  Returns\t: Bio::Seq object\n  Args\t\t: NONE\n\n\nsub next_seq {\n    my ($self) = @_;\n\n    $self->_get_seqs() unless ($self->{_parsed});\n\n    return shift @{$self->{_seqlist}};\n}\n\n=head2 write_seq\n\n  Title\t\t: write_seq\n  Usage\t\t: $seq = $stream->write_seq(@sequence_objects); undef $stream\n  Function\t: outputs one or more sequence objects as TinySeq XML\n  Returns\t: 1 on success\n  Args\t\t: one or more sequence objects as TinySeq XML\n\nBecause the TSeq dtd includes closing tags after all sets are written,\nthe output will not be complete until the program terminates or the\nobject is forced out of scope (see close_writer()).  May not perfectly\nreproduce TSeq_sid element for all sequences\n\n\nsub write_seq {\n    my ($self, @seqobjs) = @_;\n\n    $self->throw('write_seq must be called with at least one  Bio::SeqI or Bio::PrimarySeqI compliant object')\n\tunless (@seqobjs and ( $seqobjs[0]->isa('Bio::SeqI') || $seqobjs[0]->isa('Bio::PrimarySeqI')));\n\n    my $writer = $self->_get_writer;\n\n    foreach my $seqobj (@seqobjs) {\n\tmy ($id_element, $id_value) = $self->_get_idstring($seqobj);\n \t$writer->startTag('TSeq');\n\t$writer->emptyTag('TSeq_seqtype', value => $self->_convert_seqtype($seqobj));\n\t$writer->dataElement('TSeq_gi', $seqobj->primary_id || '');\n\t$writer->dataElement($id_element, $id_value);\n\t#$writer->dataElement('TSeq_orgname', $seqobj->taxid) if ($seqobj->can('taxid'); # just a placeholder\n\t$writer->dataElement('TSeq_defline', $seqobj->desc);\n\t$writer->dataElement('TSeq_length', $seqobj->length);\n\t$writer->dataElement('TSeq_sequence', $seqobj->seq);\n\n\tif ($seqobj->can('species') && $seqobj->species) {\n\t    $self->_write_species($writer, $seqobj->species);\n\t}\n\n\t$writer->endTag('TSeq');\n    }\n    1;\n}\n\n=head2 _get_seqs\n\n  Title\t\t: _get_seqs\n  Usage\t\t: Internal function - use next_seq() instead\n  Function\t: parses the XML and creates Bio::Seq objects\n  Returns\t: 1 on success\n  Args\t\t: NONE\n\nCurrently stores all sequence objects into memory.  I will work on do\nmore of a stream-based approach\n\n\nsub _get_seqs {\n    my ($self) = @_;\n\n    my $fh = $self->_fh;\n\n    my $handler = Bio::SeqIO::tinyseq::tinyseqHandler->new();\n    my $parser = XML::Parser::PerlSAX->new( Handler => $handler );\n\n    my @seqatts = $parser->parse( Source => { ByteStream => $fh });\n\n    my $factory = $self->sequence_factory;\n\n    $self->{_seqlist} ||= [];\n    foreach my $seqatt(@seqatts) {\n\tforeach my $subatt(@$seqatt) { # why are there two hashes?\n\t    my $seqobj = $factory->create(%$subatt);\n\t    $self->_assign_identifier($seqobj, $subatt);\n\n\t    if ($seqobj->can('species')) {\n# \t\tmy $class = [reverse(split(/ /, $subatt->{'-organism'}))];\n# \t\tmy $species = Bio::Species->new( -classification\t=> $class,\n# \t\t\t\t\t\t -ncbi_taxid\t\t=> $subatt->{'-taxid'} );\n\t\tmy $species = $self->_get_species($subatt->{'-organism'}, $subatt->{'-taxid'});\n\t\t$seqobj->species($species) if ($species);\n\t    }\n\n\t    push(@{$self->{_seqlist}}, $seqobj);\n\t}\n    }\n    $self->{_parsed} = 1;\n}\n\n=head2 _get_species\n\n  Title\t\t: _get_species\n  Usage\t\t: Internal function\n  Function\t: gets a Bio::Species object from cache or creates as needed\n  Returns\t: a Bio::Species object on success, undef on failure\n  Args\t\t: a classification string (eg 'Homo sapiens') and\n                  a NCBI taxon id (optional)\n\nObjects are cached for parsing multiple sequence files.\n\n\nsub _get_species {\n     my ($self, $orgname, $taxid) = @_;\n\n     unless ($self->{'_species_objects'}->{$orgname}) {\n\t my $species = $self->_create_species($orgname, $taxid);\n\t $self->{'_species_objects'}->{$orgname} = $species;\n     }\n     return $self->{'_species_objects'}->{$orgname};\n}\n\n=head2 _create_species\n\n  Title\t\t: _create_species\n  Usage\t\t: Internal function\n  Function\t: creates a Bio::Species object\n  Returns\t: a Bio::Species object on success, undef on failure\n  Args\t\t: a classification string (eg 'Homo sapiens') and\n                  a NCBI taxon id (optional)\n\n\nsub _create_species {\n    my ($self, $orgname, $taxid) = @_;\n    return unless ($orgname); # not required in TinySeq dtd so don't throw an error\n\n    my %params;\n    $params{'-classification'} = [reverse(split(/ /, $orgname))];\n    $params{'-ncbi_taxid'} = $taxid if ($taxid);\n\n    my $species = Bio::Species->new(%params)\n\tor return;\n\n    return $species;\n}\n\n\n=head2 _assign_identifier\n\n  Title\t\t: _assign_identifier\n  Usage\t\t: Internal function\n  Function\t: looks for sequence accession\n  Returns\t: 1 on success\n  Args\t\t: NONE\n\nNCBI puts refseq accessions in TSeq_sid, others in TSeq_accver.\n\n\nsub _assign_identifier {\n    my ($self, $seqobj, $atts) = @_;\n    my ($accession, $version);\n\n   if ($atts->{'-accver'}) {\n\t($accession, $version) = split(/\\./, $atts->{'-accver'});;\n    }\n    elsif ($atts->{'-sid'}) {\n\tmy $sidstring =$atts->{'-sid'};\n\t$sidstring =~ s/^.+?\\|//;\n\t$sidstring =~ s/\\|[^\\|]*//;\n\t($accession, $version) = split(/\\./, $sidstring);;\n    }\n    else {\n\t$self->throw('NO accession information found for this sequence');\n    }\n    $seqobj->accession_number($accession) if ($seqobj->can('accession_number'));\n    $seqobj->version($version) if ($seqobj->can('version'));\n\n}\n\n=head2 _convert_seqtype\n\n  Title\t\t: _convert_seqtype\n  Usage\t\t: Internal function\n  Function\t: maps Bio::Seq::alphabet() values [dna/rna/protein] onto\n                  TSeq_seqtype values [protein/nucleotide]\n\n\nsub _convert_seqtype {\n    my ($self, $seqobj) = @_;\n\n    return 'protein' \tif ($seqobj->alphabet eq 'protein');\n    return 'nucleotide' if ($seqobj->alphabet eq 'dna');\n    return 'nucleotide' if ($seqobj->alphabet eq 'rna');\n\n    # if we get here there's a problem!\n    $self->throw(\"Alphabet not defined, can't assign type for $seqobj\");\n}\n\n=head2 _get_idstring\n\n  Title\t\t: _get_idstring\n  Usage\t\t: Internal function\n  Function\t: parse accession and version info from TSeq_accver\n                  or TSeq_sid\n\n\nsub _get_idstring {\n    # NCBI puts refseq ids in TSeq_sid, others in TSeq_accver.  No idea why.\n    my ($self, $seqobj) = @_;\n    my $accver = $seqobj->accession_number;\n    $accver .= '.' . $seqobj->version if ($seqobj->can('version') and $seqobj->version);\n    if ($accver =~ /^(NM_|NP_|XM_|XP_|NT_|NC_|NG_)/) {\n\treturn ('TSeq_sid', join('|', 'ref', $accver, ''));\n    }\n    else {\n\treturn ('TSeq_accver', $accver);\n    }\n}\n\n=head2 _get_writer\n\n  Title\t\t: _get_writer\n  Usage\t\t: Internal function\n  Function\t: instantiate XML::Writer object if needed,\n                  output initial XML","label":"_get_writer($self)"}},{"kind":12,"name":"_writer","line":350},{"name":"XML","kind":12,"containerName":"Writer","line":352},{"kind":12,"name":"OUTPUT","line":352},{"kind":12,"name":"DATA_MODE","line":353},{"line":354,"name":"DATA_INDENT","kind":12},{"kind":12,"name":"NEWLINE","line":355},{"name":"SeqIO","kind":12,"containerName":"tinyseq::VERSION","line":359},{"line":363,"kind":12,"name":"_writer"},{"kind":12,"name":"_writer","line":365},{"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"close_writer","line":382,"definition":"my"},{"line":383,"name":"$self","kind":13,"containerName":"close_writer"},{"line":384,"localvar":"my","containerName":"close_writer","kind":13,"name":"$writer","definition":"my"},{"line":384,"containerName":"close_writer","kind":13,"name":"$self"},{"name":"$writer","kind":13,"containerName":"close_writer","line":385},{"containerName":"close_writer","kind":12,"name":"endTag","line":385},{"name":"$writer","containerName":"close_writer","kind":13,"line":386},{"line":386,"name":"end","containerName":"close_writer","kind":12},{"line":387,"name":"$writer","containerName":"close_writer","kind":13},{"line":389,"name":"$self","containerName":"close_writer","kind":13},{"containerName":"close_writer","kind":12,"name":"_fh","line":389},{"line":389,"kind":13,"containerName":"close_writer","name":"$self"},{"containerName":"close_writer","kind":12,"name":"_fh","line":389}],"containerName":"main::","name":"close_writer","definition":"sub","detail":"($self)","line":380,"range":{"start":{"character":0,"line":380},"end":{"line":391,"character":9999}},"kind":12,"signature":{"label":"close_writer($self)","documentation":"__END__\n# BioPerl module for Bio::SeqIO::tinyseq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::tinyseq - reading/writing sequences in NCBI TinySeq format\n\n=head1 SYNOPSIS\n\nDo not use this module directly; use the SeqIO handler system:\n\n  $stream = Bio::SeqIO->new( -file => $filename, -format => 'tinyseq' );\n\n  while ( my $seq = $stream->next_seq ) {\n    ....\n  }\n\n=head1 DESCRIPTION\n\nThis object reads and writes Bio::Seq objects to and from TinySeq XML\nformat.  A TinySeq is a lightweight XML file of sequence information,\nanalgous to FASTA format.\n\nSee L<http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.mod.dtd> for the DTD.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.bioperl.org\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO>, L<Bio::Seq>.\n\n=head1 AUTHOR\n\nDonald Jackson, E<lt>donald.jackson@bms.comE<gt>\n\nParts of this module and the test script were patterned after Sheldon\nMcKay's L<Bio::SeqIO::game>.  If it breaks, however, it's my fault not\nhis ;).\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::tinyseq;\n\nuse strict;\nuse Bio::Seq::SeqFastaSpeedFactory;\nuse Bio::Species;\nuse Bio::SeqIO::tinyseq::tinyseqHandler;\nuse XML::Parser::PerlSAX;\nuse XML::Writer;\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n    my ($self, @args) = @_;\n\n    $self->SUPER::_initialize(@args);\n\n    unless (defined $self->sequence_factory) {\n\t$self->sequence_factory(Bio::Seq::SeqFastaSpeedFactory->new());\n    }\n\n    $self->{'_species_objects'} = {};\n    $self->{_parsed} = 0;\n}\n\n=head2 next_seq\n\n  Title\t\t: next_seq\n  Usage\t\t: $seq = $stream->next_seq()\n  Function\t: returns the next sequence in the stream\n  Returns\t: Bio::Seq object\n  Args\t\t: NONE\n\n\nsub next_seq {\n    my ($self) = @_;\n\n    $self->_get_seqs() unless ($self->{_parsed});\n\n    return shift @{$self->{_seqlist}};\n}\n\n=head2 write_seq\n\n  Title\t\t: write_seq\n  Usage\t\t: $seq = $stream->write_seq(@sequence_objects); undef $stream\n  Function\t: outputs one or more sequence objects as TinySeq XML\n  Returns\t: 1 on success\n  Args\t\t: one or more sequence objects as TinySeq XML\n\nBecause the TSeq dtd includes closing tags after all sets are written,\nthe output will not be complete until the program terminates or the\nobject is forced out of scope (see close_writer()).  May not perfectly\nreproduce TSeq_sid element for all sequences\n\n\nsub write_seq {\n    my ($self, @seqobjs) = @_;\n\n    $self->throw('write_seq must be called with at least one  Bio::SeqI or Bio::PrimarySeqI compliant object')\n\tunless (@seqobjs and ( $seqobjs[0]->isa('Bio::SeqI') || $seqobjs[0]->isa('Bio::PrimarySeqI')));\n\n    my $writer = $self->_get_writer;\n\n    foreach my $seqobj (@seqobjs) {\n\tmy ($id_element, $id_value) = $self->_get_idstring($seqobj);\n \t$writer->startTag('TSeq');\n\t$writer->emptyTag('TSeq_seqtype', value => $self->_convert_seqtype($seqobj));\n\t$writer->dataElement('TSeq_gi', $seqobj->primary_id || '');\n\t$writer->dataElement($id_element, $id_value);\n\t#$writer->dataElement('TSeq_orgname', $seqobj->taxid) if ($seqobj->can('taxid'); # just a placeholder\n\t$writer->dataElement('TSeq_defline', $seqobj->desc);\n\t$writer->dataElement('TSeq_length', $seqobj->length);\n\t$writer->dataElement('TSeq_sequence', $seqobj->seq);\n\n\tif ($seqobj->can('species') && $seqobj->species) {\n\t    $self->_write_species($writer, $seqobj->species);\n\t}\n\n\t$writer->endTag('TSeq');\n    }\n    1;\n}\n\n=head2 _get_seqs\n\n  Title\t\t: _get_seqs\n  Usage\t\t: Internal function - use next_seq() instead\n  Function\t: parses the XML and creates Bio::Seq objects\n  Returns\t: 1 on success\n  Args\t\t: NONE\n\nCurrently stores all sequence objects into memory.  I will work on do\nmore of a stream-based approach\n\n\nsub _get_seqs {\n    my ($self) = @_;\n\n    my $fh = $self->_fh;\n\n    my $handler = Bio::SeqIO::tinyseq::tinyseqHandler->new();\n    my $parser = XML::Parser::PerlSAX->new( Handler => $handler );\n\n    my @seqatts = $parser->parse( Source => { ByteStream => $fh });\n\n    my $factory = $self->sequence_factory;\n\n    $self->{_seqlist} ||= [];\n    foreach my $seqatt(@seqatts) {\n\tforeach my $subatt(@$seqatt) { # why are there two hashes?\n\t    my $seqobj = $factory->create(%$subatt);\n\t    $self->_assign_identifier($seqobj, $subatt);\n\n\t    if ($seqobj->can('species')) {\n# \t\tmy $class = [reverse(split(/ /, $subatt->{'-organism'}))];\n# \t\tmy $species = Bio::Species->new( -classification\t=> $class,\n# \t\t\t\t\t\t -ncbi_taxid\t\t=> $subatt->{'-taxid'} );\n\t\tmy $species = $self->_get_species($subatt->{'-organism'}, $subatt->{'-taxid'});\n\t\t$seqobj->species($species) if ($species);\n\t    }\n\n\t    push(@{$self->{_seqlist}}, $seqobj);\n\t}\n    }\n    $self->{_parsed} = 1;\n}\n\n=head2 _get_species\n\n  Title\t\t: _get_species\n  Usage\t\t: Internal function\n  Function\t: gets a Bio::Species object from cache or creates as needed\n  Returns\t: a Bio::Species object on success, undef on failure\n  Args\t\t: a classification string (eg 'Homo sapiens') and\n                  a NCBI taxon id (optional)\n\nObjects are cached for parsing multiple sequence files.\n\n\nsub _get_species {\n     my ($self, $orgname, $taxid) = @_;\n\n     unless ($self->{'_species_objects'}->{$orgname}) {\n\t my $species = $self->_create_species($orgname, $taxid);\n\t $self->{'_species_objects'}->{$orgname} = $species;\n     }\n     return $self->{'_species_objects'}->{$orgname};\n}\n\n=head2 _create_species\n\n  Title\t\t: _create_species\n  Usage\t\t: Internal function\n  Function\t: creates a Bio::Species object\n  Returns\t: a Bio::Species object on success, undef on failure\n  Args\t\t: a classification string (eg 'Homo sapiens') and\n                  a NCBI taxon id (optional)\n\n\nsub _create_species {\n    my ($self, $orgname, $taxid) = @_;\n    return unless ($orgname); # not required in TinySeq dtd so don't throw an error\n\n    my %params;\n    $params{'-classification'} = [reverse(split(/ /, $orgname))];\n    $params{'-ncbi_taxid'} = $taxid if ($taxid);\n\n    my $species = Bio::Species->new(%params)\n\tor return;\n\n    return $species;\n}\n\n\n=head2 _assign_identifier\n\n  Title\t\t: _assign_identifier\n  Usage\t\t: Internal function\n  Function\t: looks for sequence accession\n  Returns\t: 1 on success\n  Args\t\t: NONE\n\nNCBI puts refseq accessions in TSeq_sid, others in TSeq_accver.\n\n\nsub _assign_identifier {\n    my ($self, $seqobj, $atts) = @_;\n    my ($accession, $version);\n\n   if ($atts->{'-accver'}) {\n\t($accession, $version) = split(/\\./, $atts->{'-accver'});;\n    }\n    elsif ($atts->{'-sid'}) {\n\tmy $sidstring =$atts->{'-sid'};\n\t$sidstring =~ s/^.+?\\|//;\n\t$sidstring =~ s/\\|[^\\|]*//;\n\t($accession, $version) = split(/\\./, $sidstring);;\n    }\n    else {\n\t$self->throw('NO accession information found for this sequence');\n    }\n    $seqobj->accession_number($accession) if ($seqobj->can('accession_number'));\n    $seqobj->version($version) if ($seqobj->can('version'));\n\n}\n\n=head2 _convert_seqtype\n\n  Title\t\t: _convert_seqtype\n  Usage\t\t: Internal function\n  Function\t: maps Bio::Seq::alphabet() values [dna/rna/protein] onto\n                  TSeq_seqtype values [protein/nucleotide]\n\n\nsub _convert_seqtype {\n    my ($self, $seqobj) = @_;\n\n    return 'protein' \tif ($seqobj->alphabet eq 'protein');\n    return 'nucleotide' if ($seqobj->alphabet eq 'dna');\n    return 'nucleotide' if ($seqobj->alphabet eq 'rna');\n\n    # if we get here there's a problem!\n    $self->throw(\"Alphabet not defined, can't assign type for $seqobj\");\n}\n\n=head2 _get_idstring\n\n  Title\t\t: _get_idstring\n  Usage\t\t: Internal function\n  Function\t: parse accession and version info from TSeq_accver\n                  or TSeq_sid\n\n\nsub _get_idstring {\n    # NCBI puts refseq ids in TSeq_sid, others in TSeq_accver.  No idea why.\n    my ($self, $seqobj) = @_;\n    my $accver = $seqobj->accession_number;\n    $accver .= '.' . $seqobj->version if ($seqobj->can('version') and $seqobj->version);\n    if ($accver =~ /^(NM_|NP_|XM_|XP_|NT_|NC_|NG_)/) {\n\treturn ('TSeq_sid', join('|', 'ref', $accver, ''));\n    }\n    else {\n\treturn ('TSeq_accver', $accver);\n    }\n}\n\n=head2 _get_writer\n\n  Title\t\t: _get_writer\n  Usage\t\t: Internal function\n  Function\t: instantiate XML::Writer object if needed,\n                  output initial XML\n\n\nsub _get_writer {\n    # initialize writer, start doc so write_seq can work one at a time\n    my ($self) = @_;\n\n    unless ($self->{_writer}) {\n\tmy $fh = $self->_fh;\n\tmy $writer = XML::Writer->new(OUTPUT \t\t=> $fh,\n\t\t\t\t      DATA_MODE\t\t=> 1,\n\t\t\t\t      DATA_INDENT\t=> 2,\n\t\t\t\t      NEWLINE\t\t=> 1,\n\t\t\t\t      );\n\t$writer->doctype('TSeqSet', '-//NCBI//NCBI TSeq/EN', 'http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.dtd');\n\n\t$writer->comment(\"Generated by Bio::SeqIO::tinyseq VERSION \".$Bio::SeqIO::tinyseq::VERSION);\n\n\t$writer->startTag('TSeqSet');\n\n\t$self->{_writer} = $writer;\n    }\n    return $self->{_writer};\n}\n\n=head2 close_writer\n\n  Title\t\t: close_writer\n  Usage\t\t: $self->close_writer()\n  Function\t: terminate XML output\n  Args\t\t: NONE\n  Returns\t: 1 on success\n\nCalled automatically by DESTROY when object goes out of scope","parameters":[{"label":"$self"}]}},{"line":383,"name":"_writer","kind":12},{"line":384,"kind":12,"name":"_writer"},{"signature":{"parameters":[{"label":"$self"},{"label":"$writer"},{"label":"$species"}],"documentation":"","label":"_write_species($self,$writer,$species)"},"line":393,"range":{"start":{"line":393,"character":0},"end":{"character":9999,"line":398}},"kind":12,"definition":"sub","detail":"($self,$writer,$species)","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"_write_species","name":"$self","line":394},{"line":394,"name":"$writer","kind":13,"containerName":"_write_species"},{"name":"$species","kind":13,"containerName":"_write_species","line":394},{"kind":13,"containerName":"_write_species","name":"$writer","line":395},{"kind":12,"containerName":"_write_species","name":"dataElement","line":395},{"containerName":"_write_species","kind":13,"name":"$species","line":395},{"name":"binomial","containerName":"_write_species","kind":12,"line":395},{"line":396,"name":"$writer","kind":13,"containerName":"_write_species"},{"line":396,"name":"dataElement","containerName":"_write_species","kind":12},{"line":396,"kind":13,"containerName":"_write_species","name":"$species"},{"line":396,"name":"ncbi_taxid","containerName":"_write_species","kind":12},{"containerName":"_write_species","kind":13,"name":"$species","line":397},{"line":397,"containerName":"_write_species","kind":12,"name":"ncbi_taxid"}],"name":"_write_species","containerName":"main::"},{"signature":{"parameters":[{"label":"$self"}],"documentation":"","label":"DESTROY($self)"},"line":400,"range":{"start":{"line":400,"character":0},"end":{"character":9999,"line":405}},"kind":12,"definition":"sub","detail":"($self)","children":[{"line":402,"containerName":"DESTROY","localvar":"my","kind":13,"name":"$self","definition":"my"},{"name":"$self","containerName":"DESTROY","kind":13,"line":403},{"line":403,"name":"close_writer","kind":12,"containerName":"DESTROY"},{"containerName":"DESTROY","kind":13,"name":"$self","line":404}],"name":"DESTROY","containerName":"main::"}],"version":5}