{"vars":[{"name":"vars","containerName":"","kind":2,"line":195},{"line":209,"kind":2,"containerName":"","name":"base"},{"definition":"our","kind":13,"containerName":"main::","name":"$LINE_LENGTH","line":211},{"line":214,"name":"@Unknown_names","containerName":null,"kind":13},{"line":222,"containerName":null,"kind":13,"name":"@Unknown_genus"},{"definition":"our","name":"@GENE_NAME_ORDER","containerName":"main::","kind":13,"line":225},{"children":[{"line":228,"name":"$self","localvar":"my","containerName":"_initialize","kind":13,"definition":"my"},{"line":228,"name":"@args","containerName":"_initialize","kind":13},{"line":229,"name":"$self","kind":13,"containerName":"_initialize"},{"kind":13,"containerName":"_initialize","name":"@args","line":229},{"containerName":"_initialize","kind":13,"name":"$self","line":231},{"line":233,"containerName":"_initialize","kind":13,"name":"$self"},{"line":233,"name":"_show_dna","containerName":"_initialize","kind":12},{"line":234,"containerName":"_initialize","kind":13,"name":"$self"},{"line":234,"name":"sequence_factory","kind":12,"containerName":"_initialize"},{"line":235,"containerName":"_initialize","kind":13,"name":"$self"},{"kind":12,"containerName":"_initialize","name":"sequence_factory","line":235},{"name":"new","containerName":"_initialize","kind":12,"line":236},{"line":236,"name":"$self","kind":13,"containerName":"_initialize"},{"name":"verbose","kind":12,"containerName":"_initialize","line":236}],"name":"_initialize","containerName":"main::","definition":"sub","detail":"($self,@args)","line":227,"range":{"start":{"character":0,"line":227},"end":{"character":9999,"line":239}},"kind":12,"signature":{"label":"_initialize($self,@args)","documentation":"","parameters":[{"label":"$self"},{"label":"@args"}]}},{"name":"SUPER","containerName":"_initialize","kind":12,"line":229},{"kind":12,"containerName":"Seq::SeqFactory","name":"Bio","line":235},{"kind":12,"range":{"end":{"line":334,"character":9999},"start":{"line":251,"character":0}},"line":251,"signature":{"label":"next_seq($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: swiss.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::swiss\n#\n# Copyright Elia Stupka\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::swiss - Swissprot sequence input/output stream\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system:\n\n    use Bio::SeqIO;\n\n    $stream = Bio::SeqIO->new(-file => $filename,\n                              -format => 'swiss');\n\n    while ( my $seq = $stream->next_seq() ) {\n       # do something with $seq\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from Swiss-Pprot flat\nfile databases.\n\nThere is a lot of flexibility here about how to dump things which needs\nto be documented.\n\n=head2 GN (Gene name) line management details\n\nA Uniprot/Swiss-Prot entry holds information on one protein\nsequence. If that sequence is identical across genes and species, they\nare all merged into one entry. This creates complex needs for several\nannotation fields in swiss-prot format.\n\nThe latest syntax for GN line is described in the user manual:\n\n  http://www.expasy.ch/sprot/userman.html#GN_line\n\nEach of the possibly multiple genes in an entry can have Name,\nSynonyms (only if there is a name), OrderedLocusNames (names from\ngenomic sequences) and ORFNames (temporary or cosmid names). \"Name\"\nhere really means \"symbol\". This complexity is now dealt with the\nfollowing way:\n\nA new Bio::AnnotationI class was created in order to store the\ndata in tag-value pairs.  This class (Bio::Annotation::TagTree)\nis stored in the Bio::Annotation::Collection object and is\naccessed like all other annotations. The tag name is 'gene_name'.\n\nThere is a single Bio::Annotation::TagTree per sequence record, which\ncorresponds to the original class that stored this data\n(Bio::Annotation::StructuredValue).  Depending on how we progress\nthis may change to represent each group of gene names.\n\nFor now, to access the gene name tree annotation, one uses the below method:\n\n   my ($gene) = $seq->annotation->get_Annotations('gene_name');\n\nIf you are only interested in displaying the values, value() returns a\nstring with similar formatting.\n\nThere are several ways to get directly at the information you want if you\nknow the element (tag) for the data.  For gene names all data is stored with\nthe element-tag pairs:\n\n  \"element1=tag1, tag2, tag3; element2=tag4, tag5;\"\n\nThis normally means the element will be 'Name', 'Synonyms', etc. and the\ngene names the values.  Using findval(), you can do the following:\n\n  # grab a flattened list of all gene names\n  my @names = $ann->findval('Name');\n\n  # or iterated through the nodes and grab the name for each group\n  for my $node ($ann->findnode('gene_name')) {\n     my @names = $node->findval('Name');\n  }\n\nThe current method for parsing gene name data (and reconstructing gene name\noutput) is very generic. This is somewhat preemptive if, for instance, UniProt\ndecides to update and add another element name to the current ones using the\nsame formatting layout. Under those circumstances, one can iterate through the\ntag tree in a safe way and retrieve all node data like so.\n\n  # retrieve the gene name nodes (groups like names, synonyms, etc).\n  for my $ann ($seq->annotation->get_Annotations('gene_name')) {\n\n      # each gene name group\n      for my $node ($ann->findnode('gene_name')) {\n          print \"Gene name:\\n\";\n\n          # each gene name node (tag => value pair)\n          for my $n ($node->children) {\n              print \"\\t\".$n->element.\": \".$n->children.\"\\n\";\n          }\n      }\n  }\n\nFor more uses see Bio::Annotation::TagTree.\n\nSince Uniprot/Swiss-Prot format have been around for quite some time, the\nparser is also able to read in the older GN line syntax where genes\nare separated by AND and various symbols by OR. The first symbol is\ntaken to be the 'Name' and the remaining ones are stored as 'Synonyms'.\n\n=head2 Optional functions\n\n=over 3\n\n* _show_dna()\n\n(output only) shows the dna or not\n\n* _post_sort()\n\n(output only) provides a sorting func which is applied to the FTHelpers\nbefore printing\n\n* _id_generation_func()\n\nThis is function which is called as\n\n   print \"ID   \", $func($seq), \"\\n\";\n\nTo generate the ID line. If it is not there, it generates a sensible ID\nline using a number of tools.\n\nIf you want to output annotations in Swissprot format they need to be\nstored in a Bio::Annotation::Collection object which is accessible\nthrough the Bio::SeqI interface method L<annotation()|annotation>.\n\nThe following are the names of the keys which are polled from a\nL<Bio::Annotation::Collection> object.\n\n reference   - Should contain Bio::Annotation::Reference objects\n comment     - Should contain Bio::Annotation::Comment objects\n dblink      - Should contain Bio::Annotation::DBLink objects\n gene_name   - Should contain Bio::Annotation::SimpleValue object\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions,\npreferably to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Elia Stupka\n\nEmail elia@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::swiss;\nuse vars qw(@Unknown_names @Unknown_genus);\nuse strict;\nuse Bio::SeqIO::FTHelper;\nuse Bio::SeqFeature::Generic;\nuse Bio::Species;\nuse Bio::Tools::SeqStats;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::Comment;\nuse Bio::Annotation::Reference;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::TagTree;\n\nuse base qw(Bio::SeqIO);\n\nour $LINE_LENGTH = 76;\n\n# this is for doing species name parsing\n@Unknown_names=('other', 'unidentified',\n                'unknown organism', 'not specified',\n                'not shown', 'Unspecified', 'Unknown',\n                'None', 'unclassified', 'unidentified organism',\n                'not supplied'\n               );\n# dictionary of synonyms for taxid 32644\n# all above can be part of valid species name\n@Unknown_genus = qw(unknown unclassified uncultured unidentified);\n\n# if there are any other gene name tags, they are added to the end\nour @GENE_NAME_ORDER = qw(Name Synonyms OrderedLocusNames ORFNames);\n\nsub _initialize {\n    my($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    # hash for functions for decoding keys.\n    $self->{'_func_ftunit_hash'} = {};\n    # sets this to one by default. People can change it\n    $self->_show_dna(1);\n    if ( ! defined $self->sequence_factory ) {\n        $self->sequence_factory(Bio::Seq::SeqFactory->new\n                                (-verbose => $self->verbose(),\n                                 -type => 'Bio::Seq::RichSeq'));\n    }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    :"},"name":"next_seq","containerName":"main::","children":[{"line":252,"kind":13,"localvar":"my","containerName":"next_seq","name":"$self","definition":"my"},{"name":"@args","containerName":"next_seq","kind":13,"line":252},{"name":"$pseq","kind":13,"localvar":"my","containerName":"next_seq","line":253,"definition":"my"},{"line":253,"kind":13,"containerName":"next_seq","name":"$c"},{"containerName":"next_seq","kind":13,"name":"$line","line":253},{"containerName":"next_seq","kind":13,"name":"$name","line":253},{"line":253,"name":"$desc","containerName":"next_seq","kind":13},{"line":253,"kind":13,"containerName":"next_seq","name":"$acc"},{"line":253,"name":"$seqc","containerName":"next_seq","kind":13},{"name":"$mol","kind":13,"containerName":"next_seq","line":253},{"line":253,"containerName":"next_seq","kind":13,"name":"$div"},{"kind":13,"containerName":"next_seq","name":"$sptr","line":253},{"line":253,"kind":13,"containerName":"next_seq","name":"$seq_div"},{"kind":13,"containerName":"next_seq","name":"$date","line":254},{"line":254,"containerName":"next_seq","kind":13,"name":"$comment"},{"line":254,"kind":13,"containerName":"next_seq","name":"@date_arr"},{"definition":"my","kind":13,"localvar":"my","containerName":"next_seq","name":"$genename","line":255},{"definition":"my","name":"$annotation","containerName":"next_seq","localvar":"my","kind":13,"line":256},{"name":"%params","kind":13,"containerName":"next_seq","line":256},{"name":"@features","kind":13,"containerName":"next_seq","line":256},{"line":256,"name":"new","kind":12,"containerName":"next_seq"},{"line":260,"name":"$self","kind":13,"containerName":"next_seq"},{"name":"_readline","containerName":"next_seq","kind":12,"line":260},{"name":"$self","kind":13,"containerName":"next_seq","line":280},{"line":280,"name":"throw","kind":12,"containerName":"next_seq"},{"line":282,"name":"$name","containerName":"next_seq","kind":13},{"line":282,"name":"$seq_div","containerName":"next_seq","kind":13},{"kind":13,"containerName":"next_seq","name":"$params","line":283},{"line":284,"name":"$seq_div","kind":13,"containerName":"next_seq"},{"line":284,"name":"$seq_div","kind":13,"containerName":"next_seq"},{"name":"$seq_div","kind":13,"containerName":"next_seq","line":285},{"line":285,"kind":13,"containerName":"next_seq","name":"$seq_div"},{"name":"$seq_div","containerName":"next_seq","kind":13,"line":286},{"definition":"my","line":288,"name":"$junk","localvar":"my","containerName":"next_seq","kind":13},{"containerName":"next_seq","kind":13,"name":"$division","line":288},{"line":288,"name":"$name","containerName":"next_seq","kind":13},{"containerName":"next_seq","kind":13,"name":"$params","line":289},{"line":289,"containerName":"next_seq","kind":13,"name":"$division"},{"name":"$params","containerName":"next_seq","kind":13,"line":290},{"containerName":"next_seq","kind":13,"name":"$params","line":293},{"line":293,"containerName":"next_seq","kind":13,"name":"$name"},{"name":"$self","containerName":"next_seq","kind":13,"line":296},{"line":296,"containerName":"next_seq","kind":12,"name":"_readline"},{"line":303,"name":"$desc","kind":13,"containerName":"next_seq"},{"containerName":"next_seq","kind":13,"name":"$desc","line":303},{"line":307,"name":"$genename","kind":13,"containerName":"next_seq"},{"kind":13,"containerName":"next_seq","name":"$genename","line":307},{"name":"$genename","kind":13,"containerName":"next_seq","line":308},{"definition":"my","localvar":"my","kind":13,"containerName":"next_seq","name":"@accs","line":312},{"line":313,"name":"$params","kind":13,"containerName":"next_seq"},{"name":"@accs","containerName":"next_seq","kind":13,"line":314},{"name":"$params","kind":13,"containerName":"next_seq","line":314},{"line":315,"containerName":"next_seq","kind":13,"name":"$params"},{"line":315,"kind":13,"containerName":"next_seq","name":"@accs"},{"line":319,"localvar":"my","containerName":"next_seq","kind":13,"name":"$line","definition":"my"},{"definition":"my","line":320,"name":"$date","kind":13,"localvar":"my","containerName":"next_seq"},{"containerName":"next_seq","kind":13,"name":"$version","line":320},{"containerName":"next_seq","kind":13,"name":"$line","line":320},{"line":321,"name":"$date","kind":13,"containerName":"next_seq"},{"kind":13,"containerName":"next_seq","name":"$version","line":322},{"name":"$update","localvar":"my","kind":13,"containerName":"next_seq","line":324,"definition":"my"},{"line":325,"name":"new","containerName":"next_seq","kind":12},{"line":328,"name":"$annotation","kind":13,"containerName":"next_seq"},{"line":328,"containerName":"next_seq","kind":12,"name":"add_Annotation"},{"line":328,"kind":13,"containerName":"next_seq","name":"$update"},{"line":329,"containerName":"next_seq","kind":13,"name":"$version"},{"kind":13,"containerName":"next_seq","name":"$params","line":331},{"line":333,"name":"$params","kind":13,"containerName":"next_seq"},{"line":333,"kind":13,"containerName":"next_seq","name":"$date"}],"detail":"($self,@args)","definition":"sub"},{"line":256,"containerName":"Annotation::Collection","kind":12,"name":"Bio"},{"name":"BEFORE_FEATURE_TABLE","kind":12,"line":295},{"containerName":"Annotation::SimpleValue","kind":12,"name":"Bio","line":324},{"line":337,"containerName":null,"localvar":"my","kind":13,"name":"$line","definition":"my"},{"name":"$line","kind":13,"containerName":null,"line":338},{"definition":"my","line":339,"localvar":"my","kind":13,"containerName":null,"name":"$evidence"},{"name":"Bio","kind":12,"containerName":"Annotation::SimpleValue","line":339},{"line":340,"kind":12,"containerName":"main::","name":"new"},{"line":342,"name":"$line","kind":13,"containerName":null},{"line":343,"containerName":null,"kind":13,"name":"$annotation"},{"line":343,"name":"add_Annotation","kind":12,"containerName":"main::"},{"line":343,"name":"%evidence","kind":13,"containerName":null},{"definition":"my","line":347,"containerName":null,"localvar":"my","kind":13,"name":"$species"},{"kind":13,"containerName":null,"name":"$self","line":347},{"line":347,"name":"_read_swissprot_Species","containerName":"main::","kind":12},{"name":"%params","containerName":null,"kind":13,"line":348},{"line":348,"name":"%species","kind":13,"containerName":null},{"name":"$refs","kind":13,"localvar":"my","containerName":null,"line":354,"definition":"my"},{"kind":13,"containerName":null,"name":"$self","line":354},{"kind":12,"containerName":"main::","name":"_read_swissprot_References","line":354},{"line":355,"localvar":"my","containerName":null,"kind":13,"name":"$r","definition":"my"},{"line":355,"name":"%refs","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$annotation","line":356},{"line":356,"containerName":"main::","kind":12,"name":"add_Annotation"},{"line":356,"containerName":null,"kind":13,"name":"%r"},{"containerName":null,"kind":13,"name":"$comment","line":361},{"line":362,"name":"$comment","containerName":null,"kind":13},{"name":"$self","containerName":null,"kind":13,"line":363},{"containerName":"main::","kind":12,"name":"_readline","line":363},{"containerName":null,"kind":13,"name":"$comment","line":364},{"name":"$commobj","containerName":null,"localvar":"my","kind":13,"line":370,"definition":"my"},{"containerName":"Annotation::Comment","kind":12,"name":"Bio","line":370},{"line":370,"kind":12,"containerName":"main::","name":"new"},{"kind":13,"containerName":null,"name":"$comment","line":371},{"kind":13,"containerName":null,"name":"$annotation","line":372},{"kind":12,"containerName":"main::","name":"add_Annotation","line":372},{"containerName":null,"kind":13,"name":"$commobj","line":372},{"line":373,"kind":13,"containerName":null,"name":"$comment"},{"line":374,"containerName":null,"kind":13,"name":"$self"},{"line":374,"kind":12,"containerName":"main::","name":"_pushback"},{"containerName":null,"localvar":"my","kind":13,"name":"$database","line":381,"definition":"my"},{"name":"$primaryid","containerName":null,"kind":13,"line":381},{"containerName":null,"kind":13,"name":"$optional","line":381},{"kind":13,"containerName":null,"name":"$comment","line":381},{"kind":13,"containerName":null,"name":"$comment","line":384},{"containerName":null,"kind":13,"name":"$comment","line":385},{"name":"$dblinkobj","containerName":null,"localvar":"my","kind":13,"line":387,"definition":"my"},{"line":387,"name":"Bio","kind":12,"containerName":"Annotation::DBLink"},{"line":388,"name":"new","kind":12,"containerName":"main::"},{"name":"$database","containerName":null,"kind":13,"line":388},{"name":"$primaryid","containerName":null,"kind":13,"line":389},{"line":390,"containerName":null,"kind":13,"name":"$optional"},{"line":391,"kind":13,"containerName":null,"name":"$comment"},{"name":"$annotation","containerName":null,"kind":13,"line":395},{"name":"add_Annotation","kind":12,"containerName":"main::","line":395},{"name":"%dblinkobj","containerName":null,"kind":13,"line":395},{"name":"@kw","kind":13,"localvar":"my","containerName":null,"line":399,"definition":"my"},{"kind":13,"containerName":null,"name":"@kw","line":400},{"containerName":null,"kind":13,"name":"@kw","line":400},{"line":401,"name":"%params","kind":13,"containerName":null},{"name":"@kw","kind":13,"containerName":null,"line":401},{"line":408,"kind":13,"containerName":null,"name":"%genename"},{"line":409,"name":"@stags","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"name":"%genename","kind":13,"containerName":null,"line":410},{"definition":"my","name":"$n","localvar":"my","kind":13,"containerName":null,"line":412},{"line":412,"name":"%genename","kind":13,"containerName":null},{"definition":"my","line":413,"localvar":"my","kind":13,"containerName":null,"name":"@genenames"},{"line":414,"name":"$section","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"name":"%n","containerName":null,"kind":13,"line":414},{"definition":"my","name":"$tag","containerName":null,"localvar":"my","kind":13,"line":415},{"kind":13,"containerName":null,"name":"$rest","line":415},{"line":415,"name":"$section","kind":13,"containerName":null},{"line":416,"name":"$rest","kind":13,"containerName":null},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"$val","line":417},{"line":417,"containerName":null,"kind":13,"name":"%rest"},{"line":418,"name":"@genenames","containerName":null,"kind":13},{"name":"$tag","containerName":null,"kind":13,"line":418},{"containerName":null,"kind":13,"name":"$val","line":418},{"containerName":null,"kind":13,"name":"@stags","line":421},{"containerName":null,"kind":13,"name":"@genenames","line":421},{"line":425,"name":"$section","localvar":"my","containerName":null,"kind":13,"definition":"my"},{"name":"%genename","containerName":null,"kind":13,"line":425},{"definition":"my","line":426,"localvar":"my","containerName":null,"kind":13,"name":"@genenames"},{"kind":13,"containerName":null,"name":"$section","line":427},{"line":428,"containerName":null,"localvar":"my","kind":13,"name":"@names","definition":"my"},{"line":428,"name":"$section","kind":13,"containerName":null},{"name":"@genenames","kind":13,"containerName":null,"line":429},{"name":"@names","kind":13,"containerName":null,"line":429},{"line":430,"name":"@genenames","containerName":null,"kind":13},{"name":"@names","kind":13,"containerName":null,"line":430},{"line":431,"name":"@stags","containerName":null,"kind":13},{"line":431,"kind":13,"containerName":null,"name":"@genenames"},{"name":"$gn","containerName":null,"localvar":"my","kind":13,"line":434,"definition":"my"},{"containerName":"Annotation::TagTree","kind":12,"name":"Bio","line":434},{"containerName":"main::","kind":12,"name":"new","line":434},{"kind":13,"containerName":null,"name":"@stags","line":435},{"line":436,"kind":13,"containerName":null,"name":"$annotation"},{"containerName":"main::","kind":12,"name":"add_Annotation","line":436},{"line":436,"containerName":null,"kind":13,"name":"$gn"},{"line":439,"name":"FEATURE_TABLE","kind":12},{"definition":"my","line":443,"name":"$ftunit","kind":13,"localvar":"my","containerName":null},{"name":"$self","kind":13,"containerName":null,"line":443},{"line":443,"name":"_read_FTHelper_swissprot","containerName":"main::","kind":12},{"name":"%ftunit","containerName":null,"kind":13,"line":447},{"name":"@features","containerName":null,"kind":13,"line":448},{"kind":13,"containerName":null,"name":"$ftunit","line":449},{"containerName":"main::","kind":12,"name":"_generic_seqfeature","line":449},{"line":449,"name":"$self","kind":13,"containerName":null},{"line":449,"containerName":"main::","kind":12,"name":"location_factory"},{"line":450,"name":"%params","kind":13,"containerName":null},{"line":452,"name":"$self","kind":13,"containerName":null},{"kind":12,"containerName":"main::","name":"warn","line":452},{"name":"%params","containerName":null,"kind":13,"line":453},{"line":455,"name":"$self","kind":13,"containerName":null},{"line":455,"kind":12,"containerName":"main::","name":"_readline"},{"name":"$self","kind":13,"containerName":null,"line":458},{"line":458,"name":"_readline","containerName":"main::","kind":12},{"line":460,"name":"$seqc","kind":13,"containerName":null},{"line":461,"kind":13,"containerName":null,"name":"$self"},{"line":461,"kind":12,"containerName":"main::","name":"_readline"},{"name":"$seqc","containerName":null,"kind":13,"line":464},{"kind":13,"localvar":"my","containerName":null,"name":"$seq","line":467,"definition":"my"},{"containerName":null,"kind":13,"name":"$self","line":467},{"line":467,"name":"sequence_factory","kind":12,"containerName":"main::"},{"line":468,"name":"create","kind":12,"containerName":"main::"},{"name":"$self","containerName":null,"kind":13,"line":468},{"name":"verbose","containerName":"main::","kind":12,"line":468},{"line":469,"kind":13,"containerName":null,"name":"%params"},{"line":470,"name":"$seqc","kind":13,"containerName":null},{"name":"$desc","kind":13,"containerName":null,"line":471},{"line":472,"kind":13,"containerName":null,"name":"@features"},{"kind":13,"containerName":null,"name":"$annotation","line":473},{"name":"$seq","containerName":null,"kind":13,"line":477},{"containerName":"main::","kind":12,"name":"annotation","line":477},{"line":477,"name":"$annotation","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$seq","line":479},{"containerName":"main::","name":"write_seq","children":[{"definition":"my","line":494,"localvar":"my","containerName":"write_seq","kind":13,"name":"$self"},{"containerName":"write_seq","kind":13,"name":"@seqs","line":494},{"line":495,"name":"$seq","containerName":"write_seq","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"write_seq","name":"@seqs","line":495},{"kind":13,"containerName":"write_seq","name":"$self","line":496},{"kind":12,"containerName":"write_seq","name":"throw","line":496},{"line":496,"name":"$seq","containerName":"write_seq","kind":13},{"name":"$seq","kind":13,"containerName":"write_seq","line":498},{"containerName":"write_seq","kind":13,"name":"$seq","line":498},{"name":"isa","kind":12,"containerName":"write_seq","line":498},{"containerName":"write_seq","kind":13,"name":"$self","line":499},{"line":499,"name":"warn","kind":12,"containerName":"write_seq"},{"name":"$i","localvar":"my","containerName":"write_seq","kind":13,"line":502,"definition":"my"},{"line":503,"name":"$str","kind":13,"localvar":"my","containerName":"write_seq","definition":"my"},{"name":"$seq","containerName":"write_seq","kind":13,"line":503},{"line":503,"containerName":"write_seq","kind":12,"name":"seq"},{"definition":"my","line":505,"name":"$div","kind":13,"localvar":"my","containerName":"write_seq"},{"line":506,"localvar":"my","kind":13,"containerName":"write_seq","name":"$ns","definition":"my"},{"name":"$seq","containerName":"write_seq","kind":13,"line":506},{"line":506,"name":"can","containerName":"write_seq","kind":12},{"kind":13,"containerName":"write_seq","name":"$seq","line":506},{"line":506,"containerName":"write_seq","kind":12,"name":"namespace"},{"name":"$len","kind":13,"localvar":"my","containerName":"write_seq","line":507,"definition":"my"},{"line":507,"containerName":"write_seq","kind":13,"name":"$seq"},{"name":"length","containerName":"write_seq","kind":12,"line":507},{"line":509,"containerName":"write_seq","kind":13,"name":"$seq"},{"line":509,"name":"can","containerName":"write_seq","kind":12},{"kind":13,"containerName":"write_seq","name":"$div","line":509},{"containerName":"write_seq","kind":13,"name":"$seq","line":509},{"line":509,"kind":12,"containerName":"write_seq","name":"division"},{"line":510,"name":"$div","kind":13,"containerName":"write_seq"},{"line":514,"kind":13,"containerName":"write_seq","name":"$ns"},{"line":515,"containerName":"write_seq","kind":13,"name":"$div"},{"name":"$ns","kind":13,"containerName":"write_seq","line":515},{"name":"$ns","kind":13,"containerName":"write_seq","line":516},{"name":"$ns","kind":13,"containerName":"write_seq","line":517},{"line":519,"name":"$ns","kind":13,"containerName":"write_seq"},{"name":"$self","kind":13,"containerName":"write_seq","line":523},{"containerName":"write_seq","kind":12,"name":"warn","line":523},{"line":523,"name":"$seq","kind":13,"containerName":"write_seq"},{"line":523,"containerName":"write_seq","kind":12,"name":"display_id"},{"line":524,"containerName":"write_seq","kind":13,"name":"$seq"},{"line":524,"containerName":"write_seq","kind":12,"name":"display_id"},{"line":526,"name":"$temp_line","kind":13,"localvar":"my","containerName":"write_seq","definition":"my"},{"containerName":"write_seq","kind":13,"name":"$self","line":527},{"line":527,"name":"_id_generation_func","kind":12,"containerName":"write_seq"},{"line":528,"name":"$temp_line","containerName":"write_seq","kind":13},{"containerName":"write_seq","kind":13,"name":"$self","line":528},{"line":528,"name":"_id_generation_func","containerName":"write_seq","kind":12},{"name":"$seq","kind":13,"containerName":"write_seq","line":528},{"line":540,"name":"$temp_line","kind":13,"containerName":"write_seq"},{"line":541,"containerName":"write_seq","kind":13,"name":"$seq"},{"containerName":"write_seq","kind":12,"name":"display_id","line":541},{"kind":13,"containerName":"write_seq","name":"$div","line":541},{"containerName":"write_seq","kind":13,"name":"$len","line":541},{"kind":13,"containerName":"write_seq","name":"$self","line":544},{"name":"_print","kind":12,"containerName":"write_seq","line":544},{"line":549,"containerName":"write_seq","kind":13,"name":"$self"},{"line":549,"kind":12,"containerName":"write_seq","name":"_ac_generation_func"},{"line":550,"name":"$temp_line","containerName":"write_seq","kind":13},{"line":550,"name":"$self","kind":13,"containerName":"write_seq"},{"line":550,"kind":12,"containerName":"write_seq","name":"_ac_generation_func"},{"line":550,"kind":13,"containerName":"write_seq","name":"$seq"},{"kind":13,"containerName":"write_seq","name":"$self","line":551},{"containerName":"write_seq","kind":12,"name":"_print","line":551}],"detail":"($self,@seqs)","definition":"sub","kind":12,"range":{"end":{"line":552,"character":9999},"start":{"line":493,"character":0}},"line":493,"signature":{"label":"write_seq($self,@seqs)","documentation":"1;\n# $Id: swiss.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::swiss\n#\n# Copyright Elia Stupka\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::swiss - Swissprot sequence input/output stream\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system:\n\n    use Bio::SeqIO;\n\n    $stream = Bio::SeqIO->new(-file => $filename,\n                              -format => 'swiss');\n\n    while ( my $seq = $stream->next_seq() ) {\n       # do something with $seq\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from Swiss-Pprot flat\nfile databases.\n\nThere is a lot of flexibility here about how to dump things which needs\nto be documented.\n\n=head2 GN (Gene name) line management details\n\nA Uniprot/Swiss-Prot entry holds information on one protein\nsequence. If that sequence is identical across genes and species, they\nare all merged into one entry. This creates complex needs for several\nannotation fields in swiss-prot format.\n\nThe latest syntax for GN line is described in the user manual:\n\n  http://www.expasy.ch/sprot/userman.html#GN_line\n\nEach of the possibly multiple genes in an entry can have Name,\nSynonyms (only if there is a name), OrderedLocusNames (names from\ngenomic sequences) and ORFNames (temporary or cosmid names). \"Name\"\nhere really means \"symbol\". This complexity is now dealt with the\nfollowing way:\n\nA new Bio::AnnotationI class was created in order to store the\ndata in tag-value pairs.  This class (Bio::Annotation::TagTree)\nis stored in the Bio::Annotation::Collection object and is\naccessed like all other annotations. The tag name is 'gene_name'.\n\nThere is a single Bio::Annotation::TagTree per sequence record, which\ncorresponds to the original class that stored this data\n(Bio::Annotation::StructuredValue).  Depending on how we progress\nthis may change to represent each group of gene names.\n\nFor now, to access the gene name tree annotation, one uses the below method:\n\n   my ($gene) = $seq->annotation->get_Annotations('gene_name');\n\nIf you are only interested in displaying the values, value() returns a\nstring with similar formatting.\n\nThere are several ways to get directly at the information you want if you\nknow the element (tag) for the data.  For gene names all data is stored with\nthe element-tag pairs:\n\n  \"element1=tag1, tag2, tag3; element2=tag4, tag5;\"\n\nThis normally means the element will be 'Name', 'Synonyms', etc. and the\ngene names the values.  Using findval(), you can do the following:\n\n  # grab a flattened list of all gene names\n  my @names = $ann->findval('Name');\n\n  # or iterated through the nodes and grab the name for each group\n  for my $node ($ann->findnode('gene_name')) {\n     my @names = $node->findval('Name');\n  }\n\nThe current method for parsing gene name data (and reconstructing gene name\noutput) is very generic. This is somewhat preemptive if, for instance, UniProt\ndecides to update and add another element name to the current ones using the\nsame formatting layout. Under those circumstances, one can iterate through the\ntag tree in a safe way and retrieve all node data like so.\n\n  # retrieve the gene name nodes (groups like names, synonyms, etc).\n  for my $ann ($seq->annotation->get_Annotations('gene_name')) {\n\n      # each gene name group\n      for my $node ($ann->findnode('gene_name')) {\n          print \"Gene name:\\n\";\n\n          # each gene name node (tag => value pair)\n          for my $n ($node->children) {\n              print \"\\t\".$n->element.\": \".$n->children.\"\\n\";\n          }\n      }\n  }\n\nFor more uses see Bio::Annotation::TagTree.\n\nSince Uniprot/Swiss-Prot format have been around for quite some time, the\nparser is also able to read in the older GN line syntax where genes\nare separated by AND and various symbols by OR. The first symbol is\ntaken to be the 'Name' and the remaining ones are stored as 'Synonyms'.\n\n=head2 Optional functions\n\n=over 3\n\n* _show_dna()\n\n(output only) shows the dna or not\n\n* _post_sort()\n\n(output only) provides a sorting func which is applied to the FTHelpers\nbefore printing\n\n* _id_generation_func()\n\nThis is function which is called as\n\n   print \"ID   \", $func($seq), \"\\n\";\n\nTo generate the ID line. If it is not there, it generates a sensible ID\nline using a number of tools.\n\nIf you want to output annotations in Swissprot format they need to be\nstored in a Bio::Annotation::Collection object which is accessible\nthrough the Bio::SeqI interface method L<annotation()|annotation>.\n\nThe following are the names of the keys which are polled from a\nL<Bio::Annotation::Collection> object.\n\n reference   - Should contain Bio::Annotation::Reference objects\n comment     - Should contain Bio::Annotation::Comment objects\n dblink      - Should contain Bio::Annotation::DBLink objects\n gene_name   - Should contain Bio::Annotation::SimpleValue object\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions,\npreferably to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Elia Stupka\n\nEmail elia@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::swiss;\nuse vars qw(@Unknown_names @Unknown_genus);\nuse strict;\nuse Bio::SeqIO::FTHelper;\nuse Bio::SeqFeature::Generic;\nuse Bio::Species;\nuse Bio::Tools::SeqStats;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::Comment;\nuse Bio::Annotation::Reference;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::TagTree;\n\nuse base qw(Bio::SeqIO);\n\nour $LINE_LENGTH = 76;\n\n# this is for doing species name parsing\n@Unknown_names=('other', 'unidentified',\n                'unknown organism', 'not specified',\n                'not shown', 'Unspecified', 'Unknown',\n                'None', 'unclassified', 'unidentified organism',\n                'not supplied'\n               );\n# dictionary of synonyms for taxid 32644\n# all above can be part of valid species name\n@Unknown_genus = qw(unknown unclassified uncultured unidentified);\n\n# if there are any other gene name tags, they are added to the end\nour @GENE_NAME_ORDER = qw(Name Synonyms OrderedLocusNames ORFNames);\n\nsub _initialize {\n    my($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    # hash for functions for decoding keys.\n    $self->{'_func_ftunit_hash'} = {};\n    # sets this to one by default. People can change it\n    $self->_show_dna(1);\n    if ( ! defined $self->sequence_factory ) {\n        $self->sequence_factory(Bio::Seq::SeqFactory->new\n                                (-verbose => $self->verbose(),\n                                 -type => 'Bio::Seq::RichSeq'));\n    }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    :\n\n\nsub next_seq {\n    my ($self,@args) = @_;\n    my ($pseq,$c,$line,$name,$desc,$acc,$seqc,$mol,$div, $sptr,$seq_div,\n        $date,$comment,@date_arr);\n    my $genename = \"\";\n    my ($annotation, %params, @features) = ( Bio::Annotation::Collection->new());\n\n    local $_;\n\n    1 while defined($_ = $self->_readline) && /^\\s+$/;\n    return unless defined $_ && /^ID\\s/;\n\n    # fixed to allow _DIVISION to be optional for bug #946\n    # see bug report for more information\n    #\n    # 9/6/06 Note: Swiss/TrEMBL sequences have no division acc. to UniProt\n    # release notes; this is fixed to simplify the regex parsing\n    # STANDARD (SwissProt) and PRELIMINARY (TrEMBL) added to namespace()\n    unless(  m{^\n               ID              \\s+     #\n               (\\S+)           \\s+     #  $1  entryname\n               ([^\\s;]+);      \\s+     #  $2  DataClass\n               (?:PRT;)?       \\s+     #  Molecule Type (optional)\n               [0-9]+[ ]AA     \\.      #  Sequencelength (capture?)\n               $\n           }ox ) {\n            # I couldn't find any new current UniProt sequences\n            # that matched this format:\n            # || m/^ID\\s+(\\S+)\\s+(_([^\\s_]+))? /ox ) {\n        $self->throw(\"swissprot stream with no ID. Not swissprot in my book\");\n    }\n    ($name, $seq_div) = ($1, $2);\n    $params{'-namespace'} =\n        ($seq_div eq 'Reviewed'   || $seq_div eq 'STANDARD')     ? 'Swiss-Prot' :\n        ($seq_div eq 'Unreviewed' || $seq_div eq 'PRELIMINARY')  ? 'TrEMBL'     :\n         $seq_div;\n    # we shouldn't be setting the division, but for now...\n    my ($junk, $division) = split q(_), $name;\n    $params{'-division'} = $division;\n    $params{'-alphabet'} = 'protein';\n    # this is important to have the id for display in e.g. FTHelper, otherwise\n    # you won't know which entry caused an error\n    $params{'-display_id'} = $name;\n\n    BEFORE_FEATURE_TABLE :\n          while ( defined($_ = $self->_readline) ) {\n              # Exit at start of Feature table and at the sequence at the\n              # latest HL 05/11/2000\n              last if( /^(FT|SQ)/ );\n\n              # Description line(s)\n              if (/^DE\\s+(\\S.*\\S)/) {\n                  $desc .= $desc ? \" $1\" : $1;\n              }\n              #Gene name\n              elsif (/^GN\\s+(.*)/) {\n                  $genename .= \" \" if $genename;\n                  $genename .= $1;\n              }\n              #accession number(s)\n              elsif ( /^AC\\s+(.+)/) {\n                  my @accs = split(/[; ]+/, $1); # allow space in addition\n                  $params{'-accession_number'} = shift @accs\n                      unless defined $params{'-accession_number'};\n                  push @{$params{'-secondary_accessions'}}, @accs;\n              }\n              #date and sequence version\n              elsif ( /^DT\\s+(.*)/ ) {\n                  my $line = $1;\n                  my ($date, $version) = split(' ', $line, 2);\n                  $date =~ tr/,//d; # remove comma if new version\n                  if ($version =~ /\\(Rel\\. (\\d+), Last sequence update\\)/ || # old\n                      /sequence version (\\d+)/) { #new\n                      my $update = Bio::Annotation::SimpleValue->new\n                          (-tagname    => 'seq_update',\n                           -value      => $1\n                          );\n                      $annotation->add_Annotation($update);\n                  } elsif ($version =~ /\\(Rel\\. (\\d+), Last annotation update\\)/ || #old\n                           /entry version (\\d+)/) { #new\n                      $params{'-version'} = $1;\n                  }\n                  push @{$params{'-dates'}}, $date;\n              }\n              # Evidence level\n              elsif ( /^PE\\s+(.*)/ ) {\n                  my $line = $1;\n                  $line =~ s/;\\s*//; # trim trailing semicolon and any spaces at the end of the line\n                  my $evidence = Bio::Annotation::SimpleValue->new\n                      (-tagname   => 'evidence',\n                       -value     => $line\n                      );\n                  $annotation->add_Annotation($evidence);\n              }\n              # Organism name and phylogenetic information\n              elsif (/^O[SCG]/) {\n                  my $species = $self->_read_swissprot_Species($_);\n                  $params{'-species'}= $species;\n                  # now we are one line ahead -- so continue without reading the next\n                  # line   HL 05/11/2000\n              }\n              # References\n              elsif (/^R/) {\n                  my $refs = $self->_read_swissprot_References($_);\n                  foreach my $r (@$refs) {\n                      $annotation->add_Annotation('reference',$r);\n                  }\n              }\n              # Comments\n              elsif (/^CC\\s{3}(.*)/) {\n                  $comment .= $1;\n                  $comment .= \"\\n\";\n                  while (defined ($_ = $self->_readline) && /^CC\\s{3}(.*)/ ) {\n                      $comment .= $1 . \"\\n\";\n                  }\n\n                  # note: don't try to process comments here -- they may contain\n                  # structure. LP 07/30/2000\n\n                  my $commobj = Bio::Annotation::Comment->new(-tagname => 'comment',\n                                                              -text    => $comment);\n                  $annotation->add_Annotation('comment',$commobj);\n                  $comment = \"\";\n                  $self->_pushback($_);\n              }\n              #DBLinks\n              # old regexp\n              # /^DR\\s+(\\S+)\\;\\s+(\\S+)\\;\\s+(\\S+)[\\;\\.](.*)$/) {\n              # new regexp from Andreas Kahari  bug #1584\n              elsif (/^DR\\s+(\\S+)\\;\\s+(\\S+)\\;\\s+([^;]+)[\\;\\.](.*)$/) {\n                  my ($database,$primaryid,$optional,$comment) = ($1,$2,$3,$4);\n\n                  # drop leading and training spaces and trailing .\n                  $comment =~ s/\\.\\s*$//;\n                  $comment =~ s/^\\s+//;\n\n                  my $dblinkobj =  Bio::Annotation::DBLink->new\n                      (-database    => $database,\n                       -primary_id  => $primaryid,\n                       -optional_id => $optional,\n                       -comment     => $comment,\n                       -tagname     => 'dblink',\n                      );\n\n                  $annotation->add_Annotation('dblink',$dblinkobj);\n              }\n              #keywords\n              elsif ( /^KW\\s+(.*)$/ ) {\n                  my @kw = split(/\\s*\\;\\s*/,$1);\n                  defined $kw[-1] && $kw[-1] =~ s/\\.$//;\n                  push @{$params{'-keywords'}}, @kw;\n              }\n          }\n    # process and parse the gene name line if there was one (note: we\n    # can't do this above b/c GN may be multi-line and we can't\n    # unequivocally determine whether we've seen the last GN line in\n    # the new format)\n    if ($genename) {\n        my @stags;\n        if ($genename =~ /\\w=\\w/) {\n            # new format (e.g., Name=RCHY1; Synonyms=ZNF363, CHIMP)\n            for my $n (split(m{\\s+and\\s+},$genename)) {\n                my @genenames;\n                for my $section (split(m{\\s*;\\s*},$n)) {\n                    my ($tag, $rest) = split(\"=\",$section);\n                    $rest ||= '';\n                    for my $val (split(m{\\s*,\\s*},$rest)) {\n                        push @genenames, [$tag => $val];\n                    }\n                }\n                push @stags, ['gene_name' => \\@genenames];\n            }\n        } else {\n            # old format\n            for my $section (split(/ AND /, $genename)) {\n                my @genenames;\n                $section =~ s/[\\(\\)\\.]//g;\n                my @names = split(m{\\s+OR\\s+}, $section);\n                push @genenames, ['Name' => shift @names];\n                push @genenames, map {['Synonyms' => $_]} @names;\n                push @stags, ['gene_name' => \\@genenames]            \n            }\n        } #use Data::Dumper; print Dumper $gn, $genename;# exit;\n        my $gn = Bio::Annotation::TagTree->new(-tagname => 'gene_name',\n                                               -value => ['gene_names' => \\@stags]);\n        $annotation->add_Annotation('gene_name', $gn);\n    }\n\n    FEATURE_TABLE :\n          # if there is no feature table, or if we've got beyond, exit loop or don't\n          # even enter    HL 05/11/2000\n          while (defined $_ && /^FT/ ) {\n              my $ftunit = $self->_read_FTHelper_swissprot($_);\n\n              # process ftunit\n              # when parsing of the line fails we get undef returned\n              if ($ftunit) {\n                  push(@features,\n                       $ftunit->_generic_seqfeature($self->location_factory(),\n                                                    $params{'-seqid'}, \"SwissProt\"));\n              } else {\n                  $self->warn(\"failed to parse feature table line for seq \" .\n                              $params{'-display_id'}. \"\\n$_\");\n              }\n              $_ = $self->_readline;\n          }\n    while ( defined($_) && ! /^SQ/ ) {\n        $_ = $self->_readline;\n    }\n    $seqc = \"\";\n    while ( defined ($_ = $self->_readline) ) {\n        last if m{^//};\n        s/[^A-Za-z]//g;\n        $seqc .= uc($_);\n    }\n\n    my $seq=  $self->sequence_factory->create\n        (-verbose  => $self->verbose,\n         %params,\n         -seq      => $seqc,\n         -desc     => $desc,\n         -features => \\@features,\n         -annotation => $annotation,\n        );\n\n    # The annotation doesn't get added by the contructor\n    $seq->annotation($annotation);\n\n    return $seq;\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq($seq)\n Function: writes the $seq object (must be seq) to the stream\n Returns : 1 for success and 0 for error\n Args    : array of 1 to n Bio::SeqI objects","parameters":[{"label":"$self"},{"label":"@seqs"}]}},{"line":553,"kind":13,"containerName":null,"name":"$seq"},{"containerName":"main::","kind":12,"name":"can","line":553},{"line":554,"name":"$ac_line","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"name":"$seq","kind":13,"containerName":null,"line":554},{"containerName":"main::","kind":12,"name":"accession_number","line":554},{"name":"$seq","containerName":null,"kind":13,"line":555},{"line":555,"kind":12,"containerName":"main::","name":"can"},{"line":556,"localvar":"my","kind":13,"containerName":null,"name":"$sacc","definition":"my"},{"containerName":null,"kind":13,"name":"$seq","line":556},{"line":556,"kind":12,"containerName":"main::","name":"get_secondary_accessions"},{"line":557,"kind":13,"containerName":null,"name":"$ac_line"},{"kind":13,"containerName":null,"name":"$sacc","line":557},{"containerName":null,"kind":13,"name":"$ac_line","line":559},{"line":562,"containerName":null,"kind":13,"name":"$self"},{"containerName":"main::","kind":12,"name":"_write_line_swissprot_regex","line":562},{"kind":13,"containerName":null,"name":"$ac_line","line":562},{"containerName":null,"kind":13,"name":"$LINE_LENGTH","line":563},{"name":"$seq","kind":13,"containerName":null,"line":570},{"line":570,"kind":12,"containerName":"main::","name":"can"},{"localvar":"my","containerName":null,"kind":13,"name":"@dates","line":571,"definition":"my"},{"containerName":null,"kind":13,"name":"$seq","line":571},{"line":571,"name":"get_dates","containerName":"main::","kind":12},{"line":572,"name":"$ct","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"line":573,"kind":13,"localvar":"my","containerName":null,"name":"$seq_version","definition":"my"},{"line":573,"kind":13,"containerName":null,"name":"$seq"},{"line":573,"containerName":"main::","kind":12,"name":"version"},{"definition":"my","name":"$update_version","kind":13,"localvar":"my","containerName":null,"line":574},{"name":"$seq","kind":13,"containerName":null,"line":574},{"line":574,"name":"annotation","kind":12,"containerName":"main::"},{"line":574,"name":"get_Annotations","kind":12,"containerName":"main::"},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"$dt","line":575},{"line":575,"name":"@dates","containerName":null,"kind":13},{"line":576,"name":"$self","containerName":null,"kind":13},{"name":"_write_line_swissprot_regex","containerName":"main::","kind":12,"line":576},{"line":577,"kind":13,"containerName":null,"name":"$dt"},{"name":"$ns","kind":13,"containerName":null,"line":577},{"containerName":null,"kind":13,"name":"$LINE_LENGTH","line":578},{"name":"$ct","kind":13,"containerName":null,"line":578},{"line":579,"name":"$self","containerName":null,"kind":13},{"containerName":"main::","kind":12,"name":"_write_line_swissprot_regex","line":579},{"line":580,"containerName":null,"kind":13,"name":"$dt"},{"name":"$update_version","kind":13,"containerName":null,"line":580},{"line":580,"kind":12,"containerName":"main::","name":"display_text"},{"name":"$LINE_LENGTH","containerName":null,"kind":13,"line":581},{"containerName":null,"kind":13,"name":"$ct","line":581},{"name":"$self","kind":13,"containerName":null,"line":582},{"name":"_write_line_swissprot_regex","containerName":"main::","kind":12,"line":582},{"line":583,"kind":13,"containerName":null,"name":"$dt"},{"line":584,"name":"$LINE_LENGTH","kind":13,"containerName":null},{"name":"$ct","containerName":null,"kind":13,"line":584},{"line":585,"kind":13,"containerName":null,"name":"$ct"},{"name":"$self","containerName":null,"kind":13,"line":590},{"line":590,"kind":12,"containerName":"main::","name":"_write_line_swissprot_regex"},{"line":590,"name":"$seq","kind":13,"containerName":null},{"line":590,"name":"desc","kind":12,"containerName":"main::"},{"line":590,"kind":13,"containerName":null,"name":"$LINE_LENGTH"},{"line":593,"name":"$gene","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"line":593,"containerName":null,"localvar":"my","kind":13,"name":"@genes","definition":"my"},{"containerName":null,"kind":13,"name":"$seq","line":593},{"line":593,"kind":12,"containerName":"main::","name":"annotation"},{"containerName":"main::","kind":12,"name":"get_Annotations","line":593},{"name":"@genelines","containerName":null,"localvar":"my","kind":13,"line":595,"definition":"my"},{"line":596,"name":"$node","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"name":"$gene","containerName":null,"kind":13,"line":596},{"name":"findnode","kind":12,"containerName":"main::","line":596},{"definition":"my","name":"$geneline","kind":13,"localvar":"my","containerName":null,"line":598},{"line":599,"localvar":"my","containerName":null,"kind":13,"name":"%genedata","definition":"my"},{"name":"$node","containerName":null,"kind":13,"line":599},{"line":599,"kind":12,"containerName":"main::","name":"hash"},{"definition":"my","name":"$tag","containerName":null,"localvar":"my","kind":13,"line":600},{"line":600,"kind":13,"containerName":null,"name":"@GENE_NAME_ORDER"},{"name":"%genedata","containerName":null,"kind":13,"line":601},{"name":"%tag","containerName":null,"kind":13,"line":601},{"name":"$geneline","containerName":null,"kind":13,"line":602},{"containerName":null,"kind":13,"name":"%genedata","line":602},{"kind":13,"containerName":null,"name":"$tag","line":602},{"line":603,"containerName":null,"kind":13,"name":"%genedata"},{"kind":13,"containerName":null,"name":"$tag","line":603},{"line":605,"name":"%genedata","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$tag","line":605},{"containerName":null,"localvar":"my","kind":13,"name":"$tag","line":609,"definition":"my"},{"line":609,"kind":13,"containerName":null,"name":"%genedata"},{"kind":13,"containerName":null,"name":"$geneline","line":610},{"name":"%genedata","kind":13,"containerName":null,"line":610},{"line":610,"name":"$tag","kind":13,"containerName":null},{"line":611,"name":"%genedata","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$tag","line":611},{"containerName":null,"kind":13,"name":"%genedata","line":613},{"name":"$tag","containerName":null,"kind":13,"line":613},{"name":"@genelines","containerName":null,"kind":13,"line":615},{"line":617,"name":"$self","kind":13,"containerName":null},{"line":617,"kind":12,"containerName":"main::","name":"_print"},{"line":617,"name":"@genelines","containerName":null,"kind":13},{"line":621,"kind":13,"containerName":null,"name":"$seq"},{"name":"can","containerName":"main::","kind":12,"line":621},{"definition":"my","line":621,"localvar":"my","containerName":null,"kind":13,"name":"$spec"},{"name":"$seq","kind":13,"containerName":null,"line":621},{"kind":12,"containerName":"main::","name":"species","line":621},{"definition":"my","line":622,"localvar":"my","containerName":null,"kind":13,"name":"@class"},{"line":622,"name":"$spec","kind":13,"containerName":null},{"line":622,"containerName":"main::","kind":12,"name":"classification"},{"kind":13,"containerName":null,"name":"@class","line":623},{"definition":"my","line":624,"localvar":"my","kind":13,"containerName":null,"name":"$species"},{"kind":13,"containerName":null,"name":"$spec","line":624},{"line":624,"containerName":"main::","kind":12,"name":"species"},{"definition":"my","name":"$genus","kind":13,"localvar":"my","containerName":null,"line":625},{"name":"$spec","kind":13,"containerName":null,"line":625},{"kind":12,"containerName":"main::","name":"genus","line":625},{"definition":"my","line":626,"name":"$OS","containerName":null,"localvar":"my","kind":13},{"line":626,"name":"$spec","containerName":null,"kind":13},{"line":626,"name":"scientific_name","kind":12,"containerName":"main::"},{"line":627,"containerName":null,"kind":13,"name":"@class"},{"line":628,"name":"$OS","kind":13,"containerName":null},{"line":628,"name":"$species","containerName":null,"kind":13},{"name":"$OS","containerName":null,"kind":13,"line":629},{"name":"$spec","kind":13,"containerName":null,"line":629},{"line":629,"kind":12,"containerName":"main::","name":"sub_species"},{"name":"$spec","containerName":null,"kind":13,"line":629},{"containerName":"main::","kind":12,"name":"sub_species","line":629},{"kind":13,"containerName":null,"name":"$spec","line":631},{"line":631,"kind":12,"containerName":"main::","name":"variant"},{"line":631,"kind":13,"containerName":null,"name":"$spec"},{"containerName":"main::","kind":12,"name":"common_name","line":631},{"line":632,"containerName":null,"kind":13,"name":"$OS"},{"line":634,"containerName":null,"kind":13,"name":"$self"},{"kind":12,"containerName":"main::","name":"_print","line":634},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"$OC","line":635},{"name":"@class","kind":13,"containerName":null,"line":635},{"name":"$self","containerName":null,"kind":13,"line":636},{"line":636,"containerName":"main::","kind":12,"name":"_write_line_swissprot_regex"},{"line":636,"containerName":null,"kind":13,"name":"$OC"},{"line":636,"name":"$LINE_LENGTH","containerName":null,"kind":13},{"line":637,"kind":13,"containerName":null,"name":"$spec"},{"name":"organelle","containerName":"main::","kind":12,"line":637},{"line":638,"name":"$self","kind":13,"containerName":null},{"line":638,"name":"_write_line_swissprot_regex","kind":12,"containerName":"main::"},{"kind":13,"containerName":null,"name":"$spec","line":638},{"containerName":"main::","kind":12,"name":"organelle","line":638},{"line":638,"kind":13,"containerName":null,"name":"$LINE_LENGTH"},{"line":640,"kind":13,"containerName":null,"name":"$spec"},{"kind":12,"containerName":"main::","name":"ncbi_taxid","line":640},{"line":641,"name":"$self","kind":13,"containerName":null},{"line":641,"name":"_print","kind":12,"containerName":"main::"},{"containerName":null,"kind":13,"name":"$spec","line":641},{"name":"ncbi_taxid","kind":12,"containerName":"main::","line":641},{"definition":"my","line":646,"name":"$t","localvar":"my","containerName":null,"kind":13},{"definition":"my","line":647,"containerName":null,"localvar":"my","kind":13,"name":"$ref"},{"kind":13,"containerName":null,"name":"$seq","line":647},{"line":647,"name":"annotation","containerName":"main::","kind":12},{"kind":12,"containerName":"main::","name":"get_Annotations","line":647},{"line":648,"name":"$self","containerName":null,"kind":13},{"name":"_print","containerName":"main::","kind":12,"line":648},{"line":652,"containerName":null,"kind":13,"name":"$ref"},{"name":"rp","kind":12,"containerName":"main::","line":652},{"line":653,"name":"$self","kind":13,"containerName":null},{"containerName":"main::","kind":12,"name":"_write_line_swissprot_regex","line":653},{"line":653,"name":"$ref","containerName":null,"kind":13},{"kind":12,"containerName":"main::","name":"rp","line":653},{"line":654,"name":"$LINE_LENGTH","containerName":null,"kind":13},{"name":"$ref","kind":13,"containerName":null,"line":656},{"name":"comment","kind":12,"containerName":"main::","line":656},{"line":657,"containerName":null,"kind":13,"name":"$self"},{"kind":12,"containerName":"main::","name":"_write_line_swissprot_regex","line":657},{"line":657,"name":"$ref","containerName":null,"kind":13},{"line":657,"name":"comment","kind":12,"containerName":"main::"},{"name":"$LINE_LENGTH","kind":13,"containerName":null,"line":658},{"name":"$ref","kind":13,"containerName":null,"line":660},{"name":"medline","kind":12,"containerName":"main::","line":660},{"name":"$ref","containerName":null,"kind":13,"line":660},{"kind":12,"containerName":"main::","name":"pubmed","line":660},{"name":"$ref","containerName":null,"kind":13,"line":660},{"kind":12,"containerName":"main::","name":"doi","line":660},{"name":"$line","containerName":null,"localvar":"my","kind":13,"line":664,"definition":"my"},{"line":665,"name":"$line","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$ref","line":665},{"line":665,"kind":12,"containerName":"main::","name":"medline"},{"kind":13,"containerName":null,"name":"$ref","line":665},{"containerName":"main::","kind":12,"name":"medline","line":665},{"line":666,"containerName":null,"kind":13,"name":"$line"},{"line":666,"name":"$ref","kind":13,"containerName":null},{"line":666,"name":"pubmed","kind":12,"containerName":"main::"},{"line":666,"kind":13,"containerName":null,"name":"$ref"},{"containerName":"main::","kind":12,"name":"pubmed","line":666},{"line":667,"name":"$line","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$ref","line":667},{"line":667,"kind":12,"containerName":"main::","name":"doi"},{"containerName":null,"kind":13,"name":"$ref","line":667},{"line":667,"kind":12,"containerName":"main::","name":"doi"},{"line":668,"name":"$line","kind":13,"containerName":null},{"line":670,"name":"$self","containerName":null,"kind":13},{"containerName":"main::","kind":12,"name":"_write_line_swissprot_regex","line":670},{"line":671,"containerName":null,"kind":13,"name":"$line"},{"line":672,"containerName":null,"kind":13,"name":"$LINE_LENGTH"},{"definition":"my","line":675,"name":"$author","localvar":"my","kind":13,"containerName":null},{"name":"$ref","kind":13,"containerName":null,"line":675},{"line":675,"name":"authors","kind":12,"containerName":"main::"},{"kind":13,"containerName":null,"name":"$ref","line":675},{"line":675,"containerName":"main::","kind":12,"name":"authors"},{"definition":"my","line":676,"kind":13,"localvar":"my","containerName":null,"name":"$title"},{"line":676,"kind":13,"containerName":null,"name":"$ref"},{"kind":12,"containerName":"main::","name":"title","line":676},{"line":676,"kind":13,"containerName":null,"name":"$ref"},{"containerName":"main::","kind":12,"name":"title","line":676},{"definition":"my","line":677,"localvar":"my","kind":13,"containerName":null,"name":"$rg"},{"containerName":null,"kind":13,"name":"$ref","line":677},{"name":"rg","containerName":"main::","kind":12,"line":677},{"line":677,"kind":13,"containerName":null,"name":"$ref"},{"line":677,"name":"rg","kind":12,"containerName":"main::"},{"line":678,"name":"$author","containerName":null,"kind":13},{"name":"$self","kind":13,"containerName":null,"line":680},{"containerName":"main::","kind":12,"name":"_write_line_swissprot_regex","line":680},{"containerName":null,"kind":13,"name":"$rg","line":680},{"line":680,"name":"$LINE_LENGTH","containerName":null,"kind":13},{"line":680,"kind":13,"containerName":null,"name":"$rg"},{"kind":13,"containerName":null,"name":"$self","line":681},{"line":681,"name":"_write_line_swissprot_regex","containerName":"main::","kind":12},{"line":681,"name":"$author","containerName":null,"kind":13},{"line":681,"kind":13,"containerName":null,"name":"$LINE_LENGTH"},{"containerName":null,"kind":13,"name":"$author","line":681},{"line":682,"kind":13,"containerName":null,"name":"$self"},{"name":"_write_line_swissprot_regex","kind":12,"containerName":"main::","line":682},{"line":682,"containerName":null,"kind":13,"name":"$title"},{"line":682,"name":"$LINE_LENGTH","kind":13,"containerName":null},{"name":"$title","containerName":null,"kind":13,"line":682},{"line":683,"name":"$self","kind":13,"containerName":null},{"name":"_write_line_swissprot_regex","kind":12,"containerName":"main::","line":683},{"kind":13,"containerName":null,"name":"$ref","line":683},{"line":683,"name":"location","kind":12,"containerName":"main::"},{"line":683,"name":"$LINE_LENGTH","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$t","line":684},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"$comment","line":689},{"line":689,"containerName":null,"kind":13,"name":"$seq"},{"line":689,"name":"annotation","kind":12,"containerName":"main::"},{"line":689,"name":"get_Annotations","containerName":"main::","kind":12},{"line":690,"containerName":null,"localvar":"my","kind":13,"name":"$cline","definition":"my"},{"kind":13,"containerName":null,"name":"$comment","line":690},{"line":690,"name":"text","containerName":"main::","kind":12},{"line":691,"name":"%cline","containerName":null,"kind":13},{"line":692,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"containerName":"main::","name":"_print","line":692},{"line":692,"name":"$cline","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$cline","line":693},{"line":693,"name":"$cline","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$self","line":695},{"name":"_print","kind":12,"containerName":"main::","line":695},{"name":"$cline","containerName":null,"kind":13,"line":695},{"line":701,"kind":13,"localvar":"my","containerName":null,"name":"$dblink","definition":"my"},{"containerName":null,"kind":13,"name":"$seq","line":701},{"line":701,"name":"annotation","containerName":"main::","kind":12},{"line":701,"name":"get_Annotations","containerName":"main::","kind":12},{"definition":"my","name":"$primary_id","containerName":null,"localvar":"my","kind":13,"line":702},{"name":"$dblink","containerName":null,"kind":13,"line":702},{"line":702,"name":"primary_id","kind":12,"containerName":"main::"},{"name":"$dblink","kind":13,"containerName":null,"line":704},{"line":704,"kind":12,"containerName":"main::","name":"comment"},{"line":704,"name":"$dblink","containerName":null,"kind":13},{"line":704,"kind":12,"containerName":"main::","name":"comment"},{"line":705,"kind":13,"containerName":null,"name":"$self"},{"line":705,"kind":12,"containerName":"main::","name":"_print"},{"line":705,"kind":13,"containerName":null,"name":"$dblink"},{"name":"database","kind":12,"containerName":"main::","line":705},{"line":705,"name":"$primary_id","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$dblink","line":706},{"line":706,"containerName":"main::","kind":12,"name":"optional_id"},{"name":"$dblink","containerName":null,"kind":13,"line":706},{"name":"comment","containerName":"main::","kind":12,"line":706},{"line":707,"name":"$dblink","kind":13,"containerName":null},{"line":707,"kind":12,"containerName":"main::","name":"optional_id"},{"containerName":null,"kind":13,"name":"$self","line":708},{"name":"_print","kind":12,"containerName":"main::","line":708},{"containerName":null,"kind":13,"name":"$dblink","line":708},{"containerName":"main::","kind":12,"name":"database","line":708},{"name":"$primary_id","containerName":null,"kind":13,"line":709},{"line":710,"name":"$dblink","kind":13,"containerName":null},{"line":710,"kind":12,"containerName":"main::","name":"optional_id"},{"line":712,"containerName":null,"kind":13,"name":"$self"},{"line":712,"containerName":"main::","kind":12,"name":"_print"},{"line":712,"kind":13,"containerName":null,"name":"$dblink"},{"containerName":"main::","kind":12,"name":"database","line":712},{"kind":13,"containerName":null,"name":"$primary_id","line":713},{"definition":"my","line":719,"name":"$evidence","localvar":"my","kind":13,"containerName":null},{"name":"$seq","kind":13,"containerName":null,"line":719},{"name":"annotation","containerName":"main::","kind":12,"line":719},{"line":719,"name":"get_Annotations","kind":12,"containerName":"main::"},{"name":"$self","kind":13,"containerName":null,"line":720},{"line":720,"kind":12,"containerName":"main::","name":"_print"},{"kind":13,"containerName":null,"name":"$evidence","line":720},{"line":720,"name":"value","containerName":"main::","kind":12},{"definition":"my","line":725,"localvar":"my","kind":13,"containerName":null,"name":"$kw"},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"$func","line":726},{"line":726,"name":"$self","kind":13,"containerName":null},{"line":726,"containerName":"main::","kind":12,"name":"_kw_generation_func"},{"line":727,"name":"$kw","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$func","line":727},{"kind":13,"containerName":null,"name":"$seq","line":727},{"line":728,"name":"$seq","containerName":null,"kind":13},{"name":"can","containerName":"main::","kind":12,"line":728},{"name":"$kw","kind":13,"containerName":null,"line":729},{"line":729,"kind":13,"containerName":null,"name":"$seq"},{"kind":12,"containerName":"main::","name":"keywords","line":729},{"name":"%kw","containerName":null,"kind":13,"line":730},{"line":731,"name":"$kw","containerName":null,"kind":13},{"name":"$kw","containerName":null,"kind":13,"line":731},{"kind":13,"containerName":null,"name":"$kw","line":733},{"containerName":null,"kind":13,"name":"$kw","line":733},{"name":"$kw","kind":13,"containerName":null,"line":733},{"line":735,"kind":13,"containerName":null,"name":"$kw"},{"containerName":null,"kind":13,"name":"$self","line":736},{"containerName":"main::","kind":12,"name":"_write_line_swissprot_regex","line":736},{"line":737,"name":"$kw","containerName":null,"kind":13},{"line":737,"name":"$LINE_LENGTH","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$kw","line":738},{"name":"@feats","containerName":null,"localvar":"my","kind":13,"line":742,"definition":"my"},{"kind":13,"containerName":null,"name":"$seq","line":742},{"line":742,"name":"can","kind":12,"containerName":"main::"},{"name":"$seq","containerName":null,"kind":13,"line":742},{"line":742,"name":"top_SeqFeatures","kind":12,"containerName":"main::"},{"line":743,"name":"@feats","kind":13,"containerName":null},{"line":744,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"containerName":"main::","name":"_post_sort","line":744},{"name":"$post_sort_func","localvar":"my","kind":13,"containerName":null,"line":748,"definition":"my"},{"line":748,"name":"$self","kind":13,"containerName":null},{"name":"_post_sort","containerName":"main::","kind":12,"line":748},{"definition":"my","name":"@fth","localvar":"my","containerName":null,"kind":13,"line":749},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"$sf","line":751},{"line":751,"name":"@feats","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"@fth","line":752},{"containerName":"SeqIO::FTHelper::from_SeqFeature","kind":12,"name":"Bio","line":752},{"line":752,"name":"$sf","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$seq","line":752},{"line":754,"name":"@fth","kind":13,"containerName":null},{"line":754,"name":"post_sort_func","kind":12},{"name":"$a","kind":13,"containerName":null,"line":754},{"containerName":null,"kind":13,"name":"$b","line":754},{"containerName":null,"kind":13,"name":"@fth","line":754},{"definition":"my","name":"$fth","localvar":"my","kind":13,"containerName":null,"line":756},{"kind":13,"containerName":null,"name":"@fth","line":756},{"name":"$self","kind":13,"containerName":null,"line":757},{"name":"_print_swissprot_FTHelper","containerName":"main::","kind":12,"line":757},{"name":"%fth","kind":13,"containerName":null,"line":757},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"$sf","line":763},{"line":763,"name":"@feats","kind":13,"containerName":null},{"definition":"my","line":764,"kind":13,"localvar":"my","containerName":null,"name":"@fth"},{"line":764,"containerName":"SeqIO::FTHelper::from_SeqFeature","kind":12,"name":"Bio"},{"name":"$sf","kind":13,"containerName":null,"line":764},{"line":764,"containerName":null,"kind":13,"name":"$seq"},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"$fth","line":765},{"line":765,"name":"@fth","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$fth","line":766},{"line":766,"containerName":"main::","kind":12,"name":"isa"},{"line":767,"name":"$sf","kind":13,"containerName":null},{"line":767,"kind":12,"containerName":"main::","name":"throw"},{"containerName":null,"kind":13,"name":"$self","line":769},{"containerName":"main::","kind":12,"name":"_print_swissprot_FTHelper","line":769},{"name":"$fth","kind":13,"containerName":null,"line":769},{"line":774,"kind":13,"containerName":null,"name":"$self"},{"name":"_show_dna","kind":12,"containerName":"main::","line":774},{"localvar":"my","containerName":null,"kind":13,"name":"$mw","line":781,"definition":"my"},{"line":781,"name":"Bio","containerName":"Tools::SeqStats","kind":12},{"name":"get_mol_wt","kind":12,"containerName":"main::","line":781},{"name":"$seq","containerName":null,"kind":13,"line":781},{"line":781,"kind":12,"containerName":"main::","name":"primary_seq"},{"definition":"my","name":"$crc64","localvar":"my","kind":13,"containerName":null,"line":784},{"line":784,"name":"$self","containerName":null,"kind":13},{"name":"_crc64","containerName":"main::","kind":12,"line":784},{"name":"$str","containerName":null,"kind":13,"line":784},{"line":785,"kind":13,"containerName":null,"name":"$self"},{"line":785,"containerName":"main::","kind":12,"name":"_print"},{"kind":13,"containerName":null,"name":"$len","line":786},{"name":"$mw","kind":13,"containerName":null,"line":786},{"kind":13,"containerName":null,"name":"$crc64","line":786},{"containerName":null,"kind":13,"name":"$self","line":787},{"line":787,"kind":12,"containerName":"main::","name":"_print"},{"definition":"my","line":788,"kind":13,"localvar":"my","containerName":null,"name":"$linepos"},{"kind":13,"containerName":null,"name":"$i","line":789},{"name":"$i","kind":13,"containerName":null,"line":789},{"name":"$str","containerName":null,"kind":13,"line":789},{"kind":13,"containerName":null,"name":"%i","line":789},{"containerName":null,"kind":13,"name":"$self","line":790},{"line":790,"containerName":"main::","kind":12,"name":"_print"},{"name":"$str","containerName":null,"kind":13,"line":790},{"kind":13,"containerName":null,"name":"$i","line":790},{"line":791,"name":"$linepos","kind":13,"containerName":null},{"line":792,"containerName":null,"kind":13,"name":"$i"},{"kind":13,"containerName":null,"name":"%60","line":792},{"line":792,"containerName":null,"kind":13,"name":"$i"},{"line":792,"containerName":null,"kind":13,"name":"%str"},{"line":793,"containerName":null,"kind":13,"name":"$self"},{"name":"_print","kind":12,"containerName":"main::","line":793},{"name":"$self","kind":13,"containerName":null,"line":796},{"line":796,"name":"_print","containerName":"main::","kind":12},{"line":798,"name":"$self","containerName":null,"kind":13},{"line":798,"kind":12,"containerName":"main::","name":"flush"},{"name":"$self","containerName":null,"kind":13,"line":798},{"name":"_flush_on_write","kind":12,"containerName":"main::","line":798},{"name":"$self","kind":13,"containerName":null,"line":798},{"containerName":"main::","kind":12,"name":"_fh","line":798},{"definition":"sub","name":"_generateCRCTable","containerName":"main::","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"_generateCRCTable","name":"$poly","line":820},{"name":"$self","kind":13,"localvar":"my","containerName":"_generateCRCTable","line":821,"definition":"my"},{"line":823,"containerName":"_generateCRCTable","kind":13,"name":"$self"},{"definition":"my","localvar":"my","kind":13,"containerName":"_generateCRCTable","name":"$i","line":824},{"definition":"my","line":825,"localvar":"my","kind":13,"containerName":"_generateCRCTable","name":"$crc"},{"line":825,"kind":13,"containerName":"_generateCRCTable","name":"$i"},{"localvar":"my","containerName":"_generateCRCTable","kind":13,"name":"$j","line":826,"definition":"my"},{"kind":13,"containerName":"_generateCRCTable","name":"$j","line":826},{"kind":13,"containerName":"_generateCRCTable","name":"$j","line":826},{"containerName":"_generateCRCTable","kind":13,"name":"$crc","line":827},{"containerName":"_generateCRCTable","kind":13,"name":"$crc","line":828},{"line":828,"name":"$crc","kind":13,"containerName":"_generateCRCTable"},{"line":828,"kind":13,"containerName":"_generateCRCTable","name":"$poly"},{"name":"$crc","kind":13,"containerName":"_generateCRCTable","line":830},{"line":833,"name":"$self","containerName":"_generateCRCTable","kind":13},{"containerName":"_generateCRCTable","kind":13,"name":"$i","line":833},{"containerName":"_generateCRCTable","kind":13,"name":"$crc","line":833}],"kind":12,"range":{"start":{"line":817,"character":0},"end":{"character":9999,"line":834}},"line":817},{"definition":"sub","detail":"($self,$str)","children":[{"localvar":"my","containerName":"_crc32","kind":13,"name":"$self","line":851,"definition":"my"},{"containerName":"_crc32","kind":13,"name":"$str","line":851},{"kind":13,"containerName":"_crc32","name":"$self","line":853},{"line":853,"name":"throw","containerName":"_crc32","kind":12},{"name":"$str","kind":13,"containerName":"_crc32","line":854},{"name":"$self","kind":13,"containerName":"_crc32","line":856},{"kind":12,"containerName":"_crc32","name":"_generateCRCTable","line":856},{"line":856,"kind":13,"containerName":"_crc32","name":"$self"},{"definition":"my","localvar":"my","kind":13,"containerName":"_crc32","name":"$len","line":858},{"line":860,"localvar":"my","kind":13,"containerName":"_crc32","name":"$crc","definition":"my"},{"line":861,"localvar":"my","containerName":"_crc32","kind":13,"name":"$i","definition":"my"},{"kind":13,"containerName":"_crc32","name":"$i","line":861},{"kind":13,"containerName":"_crc32","name":"$len","line":861},{"containerName":"_crc32","kind":13,"name":"$i","line":861},{"definition":"my","name":"$int","localvar":"my","kind":13,"containerName":"_crc32","line":863},{"name":"$i","containerName":"_crc32","kind":13,"line":863},{"containerName":"_crc32","kind":13,"name":"$crc","line":864},{"line":864,"name":"$crc","kind":13,"containerName":"_crc32"},{"line":865,"kind":13,"containerName":"_crc32","name":"$self"},{"kind":13,"containerName":"_crc32","name":"$crc","line":865},{"line":865,"name":"$int","containerName":"_crc32","kind":13}],"containerName":"main::","name":"_crc32","signature":{"documentation":"1;\n# $Id: swiss.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::swiss\n#\n# Copyright Elia Stupka\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::swiss - Swissprot sequence input/output stream\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system:\n\n    use Bio::SeqIO;\n\n    $stream = Bio::SeqIO->new(-file => $filename,\n                              -format => 'swiss');\n\n    while ( my $seq = $stream->next_seq() ) {\n       # do something with $seq\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from Swiss-Pprot flat\nfile databases.\n\nThere is a lot of flexibility here about how to dump things which needs\nto be documented.\n\n=head2 GN (Gene name) line management details\n\nA Uniprot/Swiss-Prot entry holds information on one protein\nsequence. If that sequence is identical across genes and species, they\nare all merged into one entry. This creates complex needs for several\nannotation fields in swiss-prot format.\n\nThe latest syntax for GN line is described in the user manual:\n\n  http://www.expasy.ch/sprot/userman.html#GN_line\n\nEach of the possibly multiple genes in an entry can have Name,\nSynonyms (only if there is a name), OrderedLocusNames (names from\ngenomic sequences) and ORFNames (temporary or cosmid names). \"Name\"\nhere really means \"symbol\". This complexity is now dealt with the\nfollowing way:\n\nA new Bio::AnnotationI class was created in order to store the\ndata in tag-value pairs.  This class (Bio::Annotation::TagTree)\nis stored in the Bio::Annotation::Collection object and is\naccessed like all other annotations. The tag name is 'gene_name'.\n\nThere is a single Bio::Annotation::TagTree per sequence record, which\ncorresponds to the original class that stored this data\n(Bio::Annotation::StructuredValue).  Depending on how we progress\nthis may change to represent each group of gene names.\n\nFor now, to access the gene name tree annotation, one uses the below method:\n\n   my ($gene) = $seq->annotation->get_Annotations('gene_name');\n\nIf you are only interested in displaying the values, value() returns a\nstring with similar formatting.\n\nThere are several ways to get directly at the information you want if you\nknow the element (tag) for the data.  For gene names all data is stored with\nthe element-tag pairs:\n\n  \"element1=tag1, tag2, tag3; element2=tag4, tag5;\"\n\nThis normally means the element will be 'Name', 'Synonyms', etc. and the\ngene names the values.  Using findval(), you can do the following:\n\n  # grab a flattened list of all gene names\n  my @names = $ann->findval('Name');\n\n  # or iterated through the nodes and grab the name for each group\n  for my $node ($ann->findnode('gene_name')) {\n     my @names = $node->findval('Name');\n  }\n\nThe current method for parsing gene name data (and reconstructing gene name\noutput) is very generic. This is somewhat preemptive if, for instance, UniProt\ndecides to update and add another element name to the current ones using the\nsame formatting layout. Under those circumstances, one can iterate through the\ntag tree in a safe way and retrieve all node data like so.\n\n  # retrieve the gene name nodes (groups like names, synonyms, etc).\n  for my $ann ($seq->annotation->get_Annotations('gene_name')) {\n\n      # each gene name group\n      for my $node ($ann->findnode('gene_name')) {\n          print \"Gene name:\\n\";\n\n          # each gene name node (tag => value pair)\n          for my $n ($node->children) {\n              print \"\\t\".$n->element.\": \".$n->children.\"\\n\";\n          }\n      }\n  }\n\nFor more uses see Bio::Annotation::TagTree.\n\nSince Uniprot/Swiss-Prot format have been around for quite some time, the\nparser is also able to read in the older GN line syntax where genes\nare separated by AND and various symbols by OR. The first symbol is\ntaken to be the 'Name' and the remaining ones are stored as 'Synonyms'.\n\n=head2 Optional functions\n\n=over 3\n\n* _show_dna()\n\n(output only) shows the dna or not\n\n* _post_sort()\n\n(output only) provides a sorting func which is applied to the FTHelpers\nbefore printing\n\n* _id_generation_func()\n\nThis is function which is called as\n\n   print \"ID   \", $func($seq), \"\\n\";\n\nTo generate the ID line. If it is not there, it generates a sensible ID\nline using a number of tools.\n\nIf you want to output annotations in Swissprot format they need to be\nstored in a Bio::Annotation::Collection object which is accessible\nthrough the Bio::SeqI interface method L<annotation()|annotation>.\n\nThe following are the names of the keys which are polled from a\nL<Bio::Annotation::Collection> object.\n\n reference   - Should contain Bio::Annotation::Reference objects\n comment     - Should contain Bio::Annotation::Comment objects\n dblink      - Should contain Bio::Annotation::DBLink objects\n gene_name   - Should contain Bio::Annotation::SimpleValue object\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions,\npreferably to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Elia Stupka\n\nEmail elia@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::swiss;\nuse vars qw(@Unknown_names @Unknown_genus);\nuse strict;\nuse Bio::SeqIO::FTHelper;\nuse Bio::SeqFeature::Generic;\nuse Bio::Species;\nuse Bio::Tools::SeqStats;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::Comment;\nuse Bio::Annotation::Reference;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::TagTree;\n\nuse base qw(Bio::SeqIO);\n\nour $LINE_LENGTH = 76;\n\n# this is for doing species name parsing\n@Unknown_names=('other', 'unidentified',\n                'unknown organism', 'not specified',\n                'not shown', 'Unspecified', 'Unknown',\n                'None', 'unclassified', 'unidentified organism',\n                'not supplied'\n               );\n# dictionary of synonyms for taxid 32644\n# all above can be part of valid species name\n@Unknown_genus = qw(unknown unclassified uncultured unidentified);\n\n# if there are any other gene name tags, they are added to the end\nour @GENE_NAME_ORDER = qw(Name Synonyms OrderedLocusNames ORFNames);\n\nsub _initialize {\n    my($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    # hash for functions for decoding keys.\n    $self->{'_func_ftunit_hash'} = {};\n    # sets this to one by default. People can change it\n    $self->_show_dna(1);\n    if ( ! defined $self->sequence_factory ) {\n        $self->sequence_factory(Bio::Seq::SeqFactory->new\n                                (-verbose => $self->verbose(),\n                                 -type => 'Bio::Seq::RichSeq'));\n    }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    :\n\n\nsub next_seq {\n    my ($self,@args) = @_;\n    my ($pseq,$c,$line,$name,$desc,$acc,$seqc,$mol,$div, $sptr,$seq_div,\n        $date,$comment,@date_arr);\n    my $genename = \"\";\n    my ($annotation, %params, @features) = ( Bio::Annotation::Collection->new());\n\n    local $_;\n\n    1 while defined($_ = $self->_readline) && /^\\s+$/;\n    return unless defined $_ && /^ID\\s/;\n\n    # fixed to allow _DIVISION to be optional for bug #946\n    # see bug report for more information\n    #\n    # 9/6/06 Note: Swiss/TrEMBL sequences have no division acc. to UniProt\n    # release notes; this is fixed to simplify the regex parsing\n    # STANDARD (SwissProt) and PRELIMINARY (TrEMBL) added to namespace()\n    unless(  m{^\n               ID              \\s+     #\n               (\\S+)           \\s+     #  $1  entryname\n               ([^\\s;]+);      \\s+     #  $2  DataClass\n               (?:PRT;)?       \\s+     #  Molecule Type (optional)\n               [0-9]+[ ]AA     \\.      #  Sequencelength (capture?)\n               $\n           }ox ) {\n            # I couldn't find any new current UniProt sequences\n            # that matched this format:\n            # || m/^ID\\s+(\\S+)\\s+(_([^\\s_]+))? /ox ) {\n        $self->throw(\"swissprot stream with no ID. Not swissprot in my book\");\n    }\n    ($name, $seq_div) = ($1, $2);\n    $params{'-namespace'} =\n        ($seq_div eq 'Reviewed'   || $seq_div eq 'STANDARD')     ? 'Swiss-Prot' :\n        ($seq_div eq 'Unreviewed' || $seq_div eq 'PRELIMINARY')  ? 'TrEMBL'     :\n         $seq_div;\n    # we shouldn't be setting the division, but for now...\n    my ($junk, $division) = split q(_), $name;\n    $params{'-division'} = $division;\n    $params{'-alphabet'} = 'protein';\n    # this is important to have the id for display in e.g. FTHelper, otherwise\n    # you won't know which entry caused an error\n    $params{'-display_id'} = $name;\n\n    BEFORE_FEATURE_TABLE :\n          while ( defined($_ = $self->_readline) ) {\n              # Exit at start of Feature table and at the sequence at the\n              # latest HL 05/11/2000\n              last if( /^(FT|SQ)/ );\n\n              # Description line(s)\n              if (/^DE\\s+(\\S.*\\S)/) {\n                  $desc .= $desc ? \" $1\" : $1;\n              }\n              #Gene name\n              elsif (/^GN\\s+(.*)/) {\n                  $genename .= \" \" if $genename;\n                  $genename .= $1;\n              }\n              #accession number(s)\n              elsif ( /^AC\\s+(.+)/) {\n                  my @accs = split(/[; ]+/, $1); # allow space in addition\n                  $params{'-accession_number'} = shift @accs\n                      unless defined $params{'-accession_number'};\n                  push @{$params{'-secondary_accessions'}}, @accs;\n              }\n              #date and sequence version\n              elsif ( /^DT\\s+(.*)/ ) {\n                  my $line = $1;\n                  my ($date, $version) = split(' ', $line, 2);\n                  $date =~ tr/,//d; # remove comma if new version\n                  if ($version =~ /\\(Rel\\. (\\d+), Last sequence update\\)/ || # old\n                      /sequence version (\\d+)/) { #new\n                      my $update = Bio::Annotation::SimpleValue->new\n                          (-tagname    => 'seq_update',\n                           -value      => $1\n                          );\n                      $annotation->add_Annotation($update);\n                  } elsif ($version =~ /\\(Rel\\. (\\d+), Last annotation update\\)/ || #old\n                           /entry version (\\d+)/) { #new\n                      $params{'-version'} = $1;\n                  }\n                  push @{$params{'-dates'}}, $date;\n              }\n              # Evidence level\n              elsif ( /^PE\\s+(.*)/ ) {\n                  my $line = $1;\n                  $line =~ s/;\\s*//; # trim trailing semicolon and any spaces at the end of the line\n                  my $evidence = Bio::Annotation::SimpleValue->new\n                      (-tagname   => 'evidence',\n                       -value     => $line\n                      );\n                  $annotation->add_Annotation($evidence);\n              }\n              # Organism name and phylogenetic information\n              elsif (/^O[SCG]/) {\n                  my $species = $self->_read_swissprot_Species($_);\n                  $params{'-species'}= $species;\n                  # now we are one line ahead -- so continue without reading the next\n                  # line   HL 05/11/2000\n              }\n              # References\n              elsif (/^R/) {\n                  my $refs = $self->_read_swissprot_References($_);\n                  foreach my $r (@$refs) {\n                      $annotation->add_Annotation('reference',$r);\n                  }\n              }\n              # Comments\n              elsif (/^CC\\s{3}(.*)/) {\n                  $comment .= $1;\n                  $comment .= \"\\n\";\n                  while (defined ($_ = $self->_readline) && /^CC\\s{3}(.*)/ ) {\n                      $comment .= $1 . \"\\n\";\n                  }\n\n                  # note: don't try to process comments here -- they may contain\n                  # structure. LP 07/30/2000\n\n                  my $commobj = Bio::Annotation::Comment->new(-tagname => 'comment',\n                                                              -text    => $comment);\n                  $annotation->add_Annotation('comment',$commobj);\n                  $comment = \"\";\n                  $self->_pushback($_);\n              }\n              #DBLinks\n              # old regexp\n              # /^DR\\s+(\\S+)\\;\\s+(\\S+)\\;\\s+(\\S+)[\\;\\.](.*)$/) {\n              # new regexp from Andreas Kahari  bug #1584\n              elsif (/^DR\\s+(\\S+)\\;\\s+(\\S+)\\;\\s+([^;]+)[\\;\\.](.*)$/) {\n                  my ($database,$primaryid,$optional,$comment) = ($1,$2,$3,$4);\n\n                  # drop leading and training spaces and trailing .\n                  $comment =~ s/\\.\\s*$//;\n                  $comment =~ s/^\\s+//;\n\n                  my $dblinkobj =  Bio::Annotation::DBLink->new\n                      (-database    => $database,\n                       -primary_id  => $primaryid,\n                       -optional_id => $optional,\n                       -comment     => $comment,\n                       -tagname     => 'dblink',\n                      );\n\n                  $annotation->add_Annotation('dblink',$dblinkobj);\n              }\n              #keywords\n              elsif ( /^KW\\s+(.*)$/ ) {\n                  my @kw = split(/\\s*\\;\\s*/,$1);\n                  defined $kw[-1] && $kw[-1] =~ s/\\.$//;\n                  push @{$params{'-keywords'}}, @kw;\n              }\n          }\n    # process and parse the gene name line if there was one (note: we\n    # can't do this above b/c GN may be multi-line and we can't\n    # unequivocally determine whether we've seen the last GN line in\n    # the new format)\n    if ($genename) {\n        my @stags;\n        if ($genename =~ /\\w=\\w/) {\n            # new format (e.g., Name=RCHY1; Synonyms=ZNF363, CHIMP)\n            for my $n (split(m{\\s+and\\s+},$genename)) {\n                my @genenames;\n                for my $section (split(m{\\s*;\\s*},$n)) {\n                    my ($tag, $rest) = split(\"=\",$section);\n                    $rest ||= '';\n                    for my $val (split(m{\\s*,\\s*},$rest)) {\n                        push @genenames, [$tag => $val];\n                    }\n                }\n                push @stags, ['gene_name' => \\@genenames];\n            }\n        } else {\n            # old format\n            for my $section (split(/ AND /, $genename)) {\n                my @genenames;\n                $section =~ s/[\\(\\)\\.]//g;\n                my @names = split(m{\\s+OR\\s+}, $section);\n                push @genenames, ['Name' => shift @names];\n                push @genenames, map {['Synonyms' => $_]} @names;\n                push @stags, ['gene_name' => \\@genenames]            \n            }\n        } #use Data::Dumper; print Dumper $gn, $genename;# exit;\n        my $gn = Bio::Annotation::TagTree->new(-tagname => 'gene_name',\n                                               -value => ['gene_names' => \\@stags]);\n        $annotation->add_Annotation('gene_name', $gn);\n    }\n\n    FEATURE_TABLE :\n          # if there is no feature table, or if we've got beyond, exit loop or don't\n          # even enter    HL 05/11/2000\n          while (defined $_ && /^FT/ ) {\n              my $ftunit = $self->_read_FTHelper_swissprot($_);\n\n              # process ftunit\n              # when parsing of the line fails we get undef returned\n              if ($ftunit) {\n                  push(@features,\n                       $ftunit->_generic_seqfeature($self->location_factory(),\n                                                    $params{'-seqid'}, \"SwissProt\"));\n              } else {\n                  $self->warn(\"failed to parse feature table line for seq \" .\n                              $params{'-display_id'}. \"\\n$_\");\n              }\n              $_ = $self->_readline;\n          }\n    while ( defined($_) && ! /^SQ/ ) {\n        $_ = $self->_readline;\n    }\n    $seqc = \"\";\n    while ( defined ($_ = $self->_readline) ) {\n        last if m{^//};\n        s/[^A-Za-z]//g;\n        $seqc .= uc($_);\n    }\n\n    my $seq=  $self->sequence_factory->create\n        (-verbose  => $self->verbose,\n         %params,\n         -seq      => $seqc,\n         -desc     => $desc,\n         -features => \\@features,\n         -annotation => $annotation,\n        );\n\n    # The annotation doesn't get added by the contructor\n    $seq->annotation($annotation);\n\n    return $seq;\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq($seq)\n Function: writes the $seq object (must be seq) to the stream\n Returns : 1 for success and 0 for error\n Args    : array of 1 to n Bio::SeqI objects\n\n\n\nsub write_seq {\n    my ($self,@seqs) = @_;\n    foreach my $seq ( @seqs ) {\n        $self->throw(\"Attempting to write with no seq!\") unless defined $seq;\n\n        if ( ! ref $seq || ! $seq->isa('Bio::SeqI') ) {\n            $self->warn(\" $seq is not a SeqI compliant module. Attempting to dump, but may fail!\");\n        }\n\n        my $i;\n        my $str = $seq->seq;\n\n        my $div;\n        my $ns = ($seq->can('namespace')) && $seq->namespace();\n        my $len = $seq->length();\n\n        if ( !$seq->can('division') || ! defined ($div = $seq->division()) ) {\n            $div = 'UNK';\n        }\n\n        # namespace dictates database, takes precedent over division. Sorry!\n        if (defined($ns)) {\n            $div = ($ns eq 'Swiss-Prot') ? 'Reviewed'    :\n                ($ns eq 'TrEMBL')     ? 'Unreviewed' :\n                    $ns;\n        } else {\n            $ns = 'Swiss-Prot';\n            # division not reset; acts as fallback\n        }\n\n        $self->warn(\"No whitespace allowed in SWISS-PROT display id [\". $seq->display_id. \"]\")\n            if $seq->display_id =~ /\\s/;\n\n        my $temp_line;\n        if ( $self->_id_generation_func ) {\n            $temp_line = &{$self->_id_generation_func}($seq);\n        } else {\n            #$temp_line = sprintf (\"%10s     STANDARD;      %3s;   %d AA.\",\n            #            $seq->primary_id().\"_\".$div,$mol,$len);\n            # Reconstructing the ID relies heavily upon the input source having\n            # been in a format that is parsed as this routine expects it -- that is,\n            # by this module itself. This is bad, I think, and immediately breaks\n            # if e.g. the Bio::DB::GenPept module is used as input.\n            # Hence, switch to display_id(); _every_ sequence is supposed to have\n            # this. HL 2000/09/03\n            # Changed to reflect ID line changes in UniProt\n            # Oct 2006 - removal of molecule type - see bug 2134\n            $temp_line = sprintf (\"%-24s%-12s%9d AA.\",\n                                  $seq->display_id(), $div.';', $len);\n        }\n\n        $self->_print( \"ID   $temp_line\\n\");\n\n        # if there, write the accession line\n        local($^W) = 0;         # supressing warnings about uninitialized fields\n\n        if ( $self->_ac_generation_func ) {\n            $temp_line = &{$self->_ac_generation_func}($seq);\n            $self->_print( \"AC   $temp_line\\n\");\n        }\n        elsif ($seq->can('accession_number') ) {\n            my $ac_line = $seq->accession_number;\n            if ($seq->can('get_secondary_accessions') ) {\n                foreach my $sacc ($seq->get_secondary_accessions) {\n                    $ac_line .= \"; \". $sacc;;\n                }\n                $ac_line .= \";\";\n            }\n\n            $self->_write_line_swissprot_regex(\"AC   \",\"AC   \",$ac_line,\n                                               \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n        }\n        # otherwise - cannot print <sigh>\n\n\n        # Date lines and sequence versions (changed 6/15/2006)\n        # This is rebuilt from scratch using the current SwissProt/UniProt format\n        if ( $seq->can('get_dates') ) {\n            my @dates =  $seq->get_dates();\n            my $ct = 1;\n            my $seq_version = $seq->version;\n            my ($update_version) = $seq->annotation->get_Annotations(\"seq_update\");\n            foreach my $dt (@dates) {\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.', integrated into UniProtKB/'.$ns.'.',\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 1;\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.\", sequence version \".$update_version->display_text.'.',\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 2;\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.\", entry version $seq_version.\",\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 3;\n                $ct++;\n            }\n        }\n\n        #Definition lines\n        $self->_write_line_swissprot_regex(\"DE   \",\"DE   \",$seq->desc(),\"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n\n        #Gene name; print out new format\n        foreach my $gene ( my @genes = $seq->annotation->get_Annotations('gene_name') ) {\n            # gene is a Bio::Annotation::TagTree;\n            my @genelines;\n            for my $node ($gene->findnode('gene_name')) {\n                # check for Name and Synonym first, then the rest get tagged on\n                my $geneline = \"GN   \";\n                my %genedata = $node->hash;\n                for my $tag (@GENE_NAME_ORDER) {\n                    if (exists $genedata{$tag}) {\n                        $geneline .= (ref $genedata{$tag} eq 'ARRAY') ?\n                            \"$tag=\".join(', ',@{$genedata{$tag}}).\"; \" :\n                            \"$tag=$genedata{$tag}; \";\n                        delete $genedata{$tag};\n                    }\n                }\n                # add rest\n                for my $tag (sort keys %genedata) {\n                    $geneline .= (ref $genedata{$tag} eq 'ARRAY') ?\n                        \"$tag=\".join(', ',@{$genedata{$tag}}).\"; \" :\n                        \"$tag=$genedata{$tag}; \";\n                    delete $genedata{$tag};\n                }\n                push @genelines, \"$geneline\\n\";\n            }\n            $self->_print(join(\"GN   and\\n\",@genelines));\n        }\n\n        # Organism lines\n        if ($seq->can('species') && (my $spec = $seq->species)) {\n            my @class = $spec->classification();\n            shift(@class);\n            my $species = $spec->species;\n            my $genus = $spec->genus;\n            my $OS = $spec->scientific_name;\n            if ($class[-1] =~ /viruses/i) {\n                $OS = $species;\n                $OS .=  \" \". $spec->sub_species if $spec->sub_species;\n            }\n            foreach (($spec->variant, $spec->common_name)) {\n                $OS .= \" ($_)\" if $_;\n            }\n            $self->_print( \"OS   $OS.\\n\");\n            my $OC = join('; ', reverse(@class)) .'.';\n            $self->_write_line_swissprot_regex(\"OC   \",\"OC   \",$OC,\"\\; \\|\\$\",$LINE_LENGTH);\n            if ($spec->organelle) {\n                $self->_write_line_swissprot_regex(\"OG   \",\"OG   \",$spec->organelle,\"\\; \\|\\$\",$LINE_LENGTH);\n            }\n            if ($spec->ncbi_taxid) {\n                $self->_print(\"OX   NCBI_TaxID=\".$spec->ncbi_taxid.\";\\n\");\n            }\n        }\n\n        # Reference lines\n        my $t = 1;\n        foreach my $ref ( $seq->annotation->get_Annotations('reference') ) {\n            $self->_print( \"RN   [$t]\\n\");\n            # changed by lorenz 08/03/00\n            # j.gilbert and h.lapp agreed that the rp line in swissprot seems\n            # more like a comment than a parseable value, so print it as is\n            if ($ref->rp) {\n                $self->_write_line_swissprot_regex(\"RP   \",\"RP   \",$ref->rp,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            }\n            if ($ref->comment) {\n                $self->_write_line_swissprot_regex(\"RC   \",\"RC   \",$ref->comment,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            }\n            if ($ref->medline or $ref->pubmed or $ref->doi) {\n                # new RX format in swissprot LP 09/17/00\n                # RX line can now have a DOI, Heikki 13 Feb 2008\n\n                my $line;\n                $line .= \"MEDLINE=\". $ref->medline. '; ' if $ref->medline;\n                $line .= \"PubMed=\". $ref->pubmed. '; ' if $ref->pubmed;\n                $line .= \"DOI=\". $ref->doi. '; ' if $ref->doi;\n                chop $line;\n\n                $self->_write_line_swissprot_regex(\"RX   \",\"RX   \",\n                                                   $line,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n\n            }\n            my $author = $ref->authors .';' if($ref->authors);\n            my $title = $ref->title .';' if( $ref->title);\n            my $rg = $ref->rg . ';' if $ref->rg;\n            $author =~ s/([\\w\\.]) (\\w)/$1#$2/g;  # add word wrap protection char '#'\n\n            $self->_write_line_swissprot_regex(\"RG   \",\"RG   \",$rg,\"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $rg;\n            $self->_write_line_swissprot_regex(\"RA   \",\"RA   \",$author,\"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $author;\n            $self->_write_line_swissprot_regex(\"RT   \",\"RT   \",$title,'[\\s\\-]+|$',$LINE_LENGTH) if $title;\n            $self->_write_line_swissprot_regex(\"RL   \",\"RL   \",$ref->location,\"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            $t++;\n        }\n\n        # Comment lines\n\n        foreach my $comment ( $seq->annotation->get_Annotations('comment') ) {\n            foreach my $cline (split (\"\\n\", $comment->text)) {\n                while (length $cline > 74) {\n                    $self->_print(\"CC   \",(substr $cline,0,74),\"\\n\");\n                    $cline = substr $cline,74;\n                }\n                $self->_print(\"CC   \",$cline,\"\\n\");\n            }\n        }\n\n        # Database xref lines\n\n        foreach my $dblink ( $seq->annotation->get_Annotations('dblink') ) {\n            my ($primary_id) = $dblink->primary_id;\n\t\n            if (defined($dblink->comment) && ($dblink->comment) ) {\n                $self->_print(\"DR   \",$dblink->database,\"; \",$primary_id,\"; \",\n                              $dblink->optional_id,\"; \",$dblink->comment,\".\\n\");\n            } elsif ($dblink->optional_id) {\n                $self->_print(\"DR   \",$dblink->database,\"; \",\n                              $primary_id,\"; \",\n                              $dblink->optional_id,\".\\n\");\n            } else {\n                $self->_print(\"DR   \",$dblink->database,\n                              \"; \",$primary_id,\"; \",\"-.\\n\");\n            }\n        }\n\n        # Evidence lines\n\n        foreach my $evidence ( $seq->annotation->get_Annotations('evidence') ) {\n            $self->_print(\"PE   \",$evidence->value,\";\\n\");\n        }\n\n        # if there, write the kw line\n        {\n            my $kw;\n            if ( my $func = $self->_kw_generation_func ) {\n                $kw = &{$func}($seq);\n            } elsif ( $seq->can('keywords') ) {\n                $kw = $seq->keywords;\n                if ( ref($kw) =~ /ARRAY/i ) {\n                    $kw = join(\"; \", @$kw);\n                }\n                $kw .= '.' if $kw and $kw !~ /\\.$/ ;\n            }\n            $kw =~ s/([\\w\\.]) (\\w)/$1#$2/g;  # add word wrap protection char '#'\n            $self->_write_line_swissprot_regex(\"KW   \",\"KW   \",\n                                               $kw, \"\\\\s\\+\\|\\$\",$LINE_LENGTH)\n                if $kw;\n        }\n\n        #Check if there is seqfeatures before printing the FT line\n        my @feats = $seq->can('top_SeqFeatures') ? $seq->top_SeqFeatures : ();\n        if ($feats[0]) {\n            if ( defined $self->_post_sort ) {\n\n                # we need to read things into an array. Process. Sort them. Print 'em\n\n                my $post_sort_func = $self->_post_sort();\n                my @fth;\n\n                foreach my $sf ( @feats ) {\n                    push(@fth,Bio::SeqIO::FTHelper::from_SeqFeature($sf,$seq));\n                }\n                @fth = sort { &$post_sort_func($a,$b) } @fth;\n\n                foreach my $fth ( @fth ) {\n                    $self->_print_swissprot_FTHelper($fth);\n                }\n            } else {\n                # not post sorted. And so we can print as we get them.\n                # lower memory load...\n\n                foreach my $sf ( @feats ) {\n                    my @fth = Bio::SeqIO::FTHelper::from_SeqFeature($sf,$seq);\n                    foreach my $fth ( @fth ) {\n                        if ( ! $fth->isa('Bio::SeqIO::FTHelper') ) {\n                            $sf->throw(\"Cannot process FTHelper... $fth\");\n                        }\n                        $self->_print_swissprot_FTHelper($fth);\n                    }\n                }\n            }\n\n            if ( $self->_show_dna() == 0 ) {\n                return;\n            }\n        }\n        # finished printing features.\n\n        # molecular weight\n        my $mw = ${Bio::Tools::SeqStats->get_mol_wt($seq->primary_seq)}[0];\n        # checksum\n        # was crc32 checksum, changed it to crc64\n        my $crc64 = $self->_crc64(\\$str);\n        $self->_print( sprintf(\"SQ   SEQUENCE  %4d AA;  %d MW;  %16s CRC64;\\n\",\n                               $len,$mw,$crc64));\n        $self->_print( \"    \");\n        my $linepos;\n        for ($i = 0; $i < length($str); $i += 10) {\n            $self->_print( \" \", substr($str,$i,10));\n            $linepos += 11;\n            if ( ($i+10)%60 == 0 && (($i+10) < length($str))) {\n                $self->_print( \"\\n    \");\n            }\n        }\n        $self->_print( \"\\n//\\n\");\n\n        $self->flush if $self->_flush_on_write && defined $self->_fh;\n        return 1;\n    }\n}\n\n# Thanks to James Gilbert for the following two. LP 08/01/2000\n\n=head2 _generateCRCTable\n\n Title   : _generateCRCTable\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _generateCRCTable {\n  # 10001000001010010010001110000100\n  # 32\n    my $poly = 0xEDB88320;\n    my ($self) = shift;\n\n    $self->{'_crcTable'} = [];\n    foreach my $i (0..255) {\n        my $crc = $i;\n        for (my $j=8; $j > 0; $j--) {\n            if ($crc & 1) {\n                $crc = ($crc >> 1) ^ $poly;\n            } else {\n                $crc >>= 1;\n            }\n        }\n        ${$self->{'_crcTable'}}[$i] = $crc;\n    }\n}\n\n\n=head2 _crc32\n\n Title   : _crc32\n Usage   :\n Function:\n Example :\n Returns :\n Args    :","parameters":[{"label":"$self"},{"label":"$str"}],"label":"_crc32($self,$str)"},"line":850,"kind":12,"range":{"end":{"character":9999,"line":866},"start":{"line":850,"character":0}}},{"name":"str","kind":12,"line":858},{"line":863,"kind":12,"name":"str"},{"line":867,"containerName":null,"kind":13,"name":"$crc"},{"definition":"sub","detail":"($self,$sequence)","children":[{"kind":13,"localvar":"my","containerName":"_crc64","name":"$self","line":883,"definition":"my"},{"line":883,"kind":13,"containerName":"_crc64","name":"$sequence"},{"line":884,"kind":13,"localvar":"my","containerName":"_crc64","name":"$POLY64REVh","definition":"my"},{"name":"@CRCTableh","kind":13,"localvar":"my","containerName":"_crc64","line":885,"definition":"my"},{"definition":"my","line":886,"kind":13,"localvar":"my","containerName":"_crc64","name":"@CRCTablel"},{"line":887,"localvar":"my","kind":13,"containerName":"_crc64","name":"$initialized","definition":"my"},{"line":889,"localvar":"my","containerName":"_crc64","kind":13,"name":"$seq","definition":"my"},{"definition":"my","name":"$crcl","localvar":"my","kind":13,"containerName":"_crc64","line":891},{"line":892,"localvar":"my","kind":13,"containerName":"_crc64","name":"$crch","definition":"my"},{"kind":13,"containerName":"_crc64","name":"$initialized","line":893},{"line":894,"containerName":"_crc64","kind":13,"name":"$initialized"},{"line":895,"name":"$i","localvar":"my","kind":13,"containerName":"_crc64","definition":"my"},{"name":"$i","containerName":"_crc64","kind":13,"line":895},{"line":895,"kind":13,"containerName":"_crc64","name":"$i"},{"name":"$partl","localvar":"my","containerName":"_crc64","kind":13,"line":896,"definition":"my"},{"containerName":"_crc64","kind":13,"name":"$i","line":896},{"definition":"my","line":897,"name":"$parth","containerName":"_crc64","localvar":"my","kind":13},{"definition":"my","line":898,"localvar":"my","kind":13,"containerName":"_crc64","name":"$j"},{"line":898,"containerName":"_crc64","kind":13,"name":"$j"},{"line":898,"containerName":"_crc64","kind":13,"name":"$j"},{"definition":"my","line":899,"localvar":"my","containerName":"_crc64","kind":13,"name":"$rflag"},{"name":"$partl","containerName":"_crc64","kind":13,"line":899},{"line":900,"kind":13,"containerName":"_crc64","name":"$partl"},{"line":901,"containerName":"_crc64","kind":13,"name":"$partl"},{"name":"$parth","kind":13,"containerName":"_crc64","line":901},{"line":902,"kind":13,"containerName":"_crc64","name":"$parth"},{"line":903,"containerName":"_crc64","kind":13,"name":"$parth"},{"line":903,"name":"$POLY64REVh","kind":13,"containerName":"_crc64"},{"line":903,"kind":13,"containerName":"_crc64","name":"$rflag"},{"line":905,"containerName":"_crc64","kind":13,"name":"$CRCTableh"},{"line":905,"name":"$i","containerName":"_crc64","kind":13},{"line":905,"containerName":"_crc64","kind":13,"name":"$parth"},{"line":906,"name":"$CRCTablel","containerName":"_crc64","kind":13},{"kind":13,"containerName":"_crc64","name":"$i","line":906},{"line":906,"kind":13,"containerName":"_crc64","name":"$partl"},{"kind":13,"containerName":"_crc64","name":"$seq","line":910},{"definition":"my","name":"$shr","localvar":"my","kind":13,"containerName":"_crc64","line":911},{"containerName":"_crc64","kind":13,"name":"$crch","line":911},{"definition":"my","name":"$temp1h","kind":13,"localvar":"my","containerName":"_crc64","line":912},{"line":912,"kind":13,"containerName":"_crc64","name":"$crch"},{"kind":13,"localvar":"my","containerName":"_crc64","name":"$temp1l","line":913,"definition":"my"},{"line":913,"kind":13,"containerName":"_crc64","name":"$crcl"},{"line":913,"kind":13,"containerName":"_crc64","name":"$shr"},{"definition":"my","name":"$tableindex","containerName":"_crc64","localvar":"my","kind":13,"line":914},{"line":914,"name":"$crcl","kind":13,"containerName":"_crc64"},{"kind":13,"containerName":"_crc64","name":"$crch","line":915},{"line":915,"containerName":"_crc64","kind":13,"name":"$temp1h"},{"containerName":"_crc64","kind":13,"name":"$CRCTableh","line":915},{"kind":13,"containerName":"_crc64","name":"$tableindex","line":915},{"line":916,"name":"$crcl","kind":13,"containerName":"_crc64"},{"line":916,"name":"$temp1l","kind":13,"containerName":"_crc64"},{"line":916,"name":"$CRCTablel","kind":13,"containerName":"_crc64"},{"name":"$tableindex","kind":13,"containerName":"_crc64","line":916},{"line":918,"name":"$crc64","kind":13,"localvar":"my","containerName":"_crc64","definition":"my"},{"line":918,"name":"$crch","kind":13,"containerName":"_crc64"},{"line":918,"name":"$crcl","kind":13,"containerName":"_crc64"},{"name":"$crc64","containerName":"_crc64","kind":13,"line":919}],"containerName":"main::","name":"_crc64","signature":{"label":"_crc64($self,$sequence)","documentation":"1;\n# $Id: swiss.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::swiss\n#\n# Copyright Elia Stupka\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::swiss - Swissprot sequence input/output stream\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system:\n\n    use Bio::SeqIO;\n\n    $stream = Bio::SeqIO->new(-file => $filename,\n                              -format => 'swiss');\n\n    while ( my $seq = $stream->next_seq() ) {\n       # do something with $seq\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from Swiss-Pprot flat\nfile databases.\n\nThere is a lot of flexibility here about how to dump things which needs\nto be documented.\n\n=head2 GN (Gene name) line management details\n\nA Uniprot/Swiss-Prot entry holds information on one protein\nsequence. If that sequence is identical across genes and species, they\nare all merged into one entry. This creates complex needs for several\nannotation fields in swiss-prot format.\n\nThe latest syntax for GN line is described in the user manual:\n\n  http://www.expasy.ch/sprot/userman.html#GN_line\n\nEach of the possibly multiple genes in an entry can have Name,\nSynonyms (only if there is a name), OrderedLocusNames (names from\ngenomic sequences) and ORFNames (temporary or cosmid names). \"Name\"\nhere really means \"symbol\". This complexity is now dealt with the\nfollowing way:\n\nA new Bio::AnnotationI class was created in order to store the\ndata in tag-value pairs.  This class (Bio::Annotation::TagTree)\nis stored in the Bio::Annotation::Collection object and is\naccessed like all other annotations. The tag name is 'gene_name'.\n\nThere is a single Bio::Annotation::TagTree per sequence record, which\ncorresponds to the original class that stored this data\n(Bio::Annotation::StructuredValue).  Depending on how we progress\nthis may change to represent each group of gene names.\n\nFor now, to access the gene name tree annotation, one uses the below method:\n\n   my ($gene) = $seq->annotation->get_Annotations('gene_name');\n\nIf you are only interested in displaying the values, value() returns a\nstring with similar formatting.\n\nThere are several ways to get directly at the information you want if you\nknow the element (tag) for the data.  For gene names all data is stored with\nthe element-tag pairs:\n\n  \"element1=tag1, tag2, tag3; element2=tag4, tag5;\"\n\nThis normally means the element will be 'Name', 'Synonyms', etc. and the\ngene names the values.  Using findval(), you can do the following:\n\n  # grab a flattened list of all gene names\n  my @names = $ann->findval('Name');\n\n  # or iterated through the nodes and grab the name for each group\n  for my $node ($ann->findnode('gene_name')) {\n     my @names = $node->findval('Name');\n  }\n\nThe current method for parsing gene name data (and reconstructing gene name\noutput) is very generic. This is somewhat preemptive if, for instance, UniProt\ndecides to update and add another element name to the current ones using the\nsame formatting layout. Under those circumstances, one can iterate through the\ntag tree in a safe way and retrieve all node data like so.\n\n  # retrieve the gene name nodes (groups like names, synonyms, etc).\n  for my $ann ($seq->annotation->get_Annotations('gene_name')) {\n\n      # each gene name group\n      for my $node ($ann->findnode('gene_name')) {\n          print \"Gene name:\\n\";\n\n          # each gene name node (tag => value pair)\n          for my $n ($node->children) {\n              print \"\\t\".$n->element.\": \".$n->children.\"\\n\";\n          }\n      }\n  }\n\nFor more uses see Bio::Annotation::TagTree.\n\nSince Uniprot/Swiss-Prot format have been around for quite some time, the\nparser is also able to read in the older GN line syntax where genes\nare separated by AND and various symbols by OR. The first symbol is\ntaken to be the 'Name' and the remaining ones are stored as 'Synonyms'.\n\n=head2 Optional functions\n\n=over 3\n\n* _show_dna()\n\n(output only) shows the dna or not\n\n* _post_sort()\n\n(output only) provides a sorting func which is applied to the FTHelpers\nbefore printing\n\n* _id_generation_func()\n\nThis is function which is called as\n\n   print \"ID   \", $func($seq), \"\\n\";\n\nTo generate the ID line. If it is not there, it generates a sensible ID\nline using a number of tools.\n\nIf you want to output annotations in Swissprot format they need to be\nstored in a Bio::Annotation::Collection object which is accessible\nthrough the Bio::SeqI interface method L<annotation()|annotation>.\n\nThe following are the names of the keys which are polled from a\nL<Bio::Annotation::Collection> object.\n\n reference   - Should contain Bio::Annotation::Reference objects\n comment     - Should contain Bio::Annotation::Comment objects\n dblink      - Should contain Bio::Annotation::DBLink objects\n gene_name   - Should contain Bio::Annotation::SimpleValue object\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions,\npreferably to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Elia Stupka\n\nEmail elia@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::swiss;\nuse vars qw(@Unknown_names @Unknown_genus);\nuse strict;\nuse Bio::SeqIO::FTHelper;\nuse Bio::SeqFeature::Generic;\nuse Bio::Species;\nuse Bio::Tools::SeqStats;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::Comment;\nuse Bio::Annotation::Reference;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::TagTree;\n\nuse base qw(Bio::SeqIO);\n\nour $LINE_LENGTH = 76;\n\n# this is for doing species name parsing\n@Unknown_names=('other', 'unidentified',\n                'unknown organism', 'not specified',\n                'not shown', 'Unspecified', 'Unknown',\n                'None', 'unclassified', 'unidentified organism',\n                'not supplied'\n               );\n# dictionary of synonyms for taxid 32644\n# all above can be part of valid species name\n@Unknown_genus = qw(unknown unclassified uncultured unidentified);\n\n# if there are any other gene name tags, they are added to the end\nour @GENE_NAME_ORDER = qw(Name Synonyms OrderedLocusNames ORFNames);\n\nsub _initialize {\n    my($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    # hash for functions for decoding keys.\n    $self->{'_func_ftunit_hash'} = {};\n    # sets this to one by default. People can change it\n    $self->_show_dna(1);\n    if ( ! defined $self->sequence_factory ) {\n        $self->sequence_factory(Bio::Seq::SeqFactory->new\n                                (-verbose => $self->verbose(),\n                                 -type => 'Bio::Seq::RichSeq'));\n    }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    :\n\n\nsub next_seq {\n    my ($self,@args) = @_;\n    my ($pseq,$c,$line,$name,$desc,$acc,$seqc,$mol,$div, $sptr,$seq_div,\n        $date,$comment,@date_arr);\n    my $genename = \"\";\n    my ($annotation, %params, @features) = ( Bio::Annotation::Collection->new());\n\n    local $_;\n\n    1 while defined($_ = $self->_readline) && /^\\s+$/;\n    return unless defined $_ && /^ID\\s/;\n\n    # fixed to allow _DIVISION to be optional for bug #946\n    # see bug report for more information\n    #\n    # 9/6/06 Note: Swiss/TrEMBL sequences have no division acc. to UniProt\n    # release notes; this is fixed to simplify the regex parsing\n    # STANDARD (SwissProt) and PRELIMINARY (TrEMBL) added to namespace()\n    unless(  m{^\n               ID              \\s+     #\n               (\\S+)           \\s+     #  $1  entryname\n               ([^\\s;]+);      \\s+     #  $2  DataClass\n               (?:PRT;)?       \\s+     #  Molecule Type (optional)\n               [0-9]+[ ]AA     \\.      #  Sequencelength (capture?)\n               $\n           }ox ) {\n            # I couldn't find any new current UniProt sequences\n            # that matched this format:\n            # || m/^ID\\s+(\\S+)\\s+(_([^\\s_]+))? /ox ) {\n        $self->throw(\"swissprot stream with no ID. Not swissprot in my book\");\n    }\n    ($name, $seq_div) = ($1, $2);\n    $params{'-namespace'} =\n        ($seq_div eq 'Reviewed'   || $seq_div eq 'STANDARD')     ? 'Swiss-Prot' :\n        ($seq_div eq 'Unreviewed' || $seq_div eq 'PRELIMINARY')  ? 'TrEMBL'     :\n         $seq_div;\n    # we shouldn't be setting the division, but for now...\n    my ($junk, $division) = split q(_), $name;\n    $params{'-division'} = $division;\n    $params{'-alphabet'} = 'protein';\n    # this is important to have the id for display in e.g. FTHelper, otherwise\n    # you won't know which entry caused an error\n    $params{'-display_id'} = $name;\n\n    BEFORE_FEATURE_TABLE :\n          while ( defined($_ = $self->_readline) ) {\n              # Exit at start of Feature table and at the sequence at the\n              # latest HL 05/11/2000\n              last if( /^(FT|SQ)/ );\n\n              # Description line(s)\n              if (/^DE\\s+(\\S.*\\S)/) {\n                  $desc .= $desc ? \" $1\" : $1;\n              }\n              #Gene name\n              elsif (/^GN\\s+(.*)/) {\n                  $genename .= \" \" if $genename;\n                  $genename .= $1;\n              }\n              #accession number(s)\n              elsif ( /^AC\\s+(.+)/) {\n                  my @accs = split(/[; ]+/, $1); # allow space in addition\n                  $params{'-accession_number'} = shift @accs\n                      unless defined $params{'-accession_number'};\n                  push @{$params{'-secondary_accessions'}}, @accs;\n              }\n              #date and sequence version\n              elsif ( /^DT\\s+(.*)/ ) {\n                  my $line = $1;\n                  my ($date, $version) = split(' ', $line, 2);\n                  $date =~ tr/,//d; # remove comma if new version\n                  if ($version =~ /\\(Rel\\. (\\d+), Last sequence update\\)/ || # old\n                      /sequence version (\\d+)/) { #new\n                      my $update = Bio::Annotation::SimpleValue->new\n                          (-tagname    => 'seq_update',\n                           -value      => $1\n                          );\n                      $annotation->add_Annotation($update);\n                  } elsif ($version =~ /\\(Rel\\. (\\d+), Last annotation update\\)/ || #old\n                           /entry version (\\d+)/) { #new\n                      $params{'-version'} = $1;\n                  }\n                  push @{$params{'-dates'}}, $date;\n              }\n              # Evidence level\n              elsif ( /^PE\\s+(.*)/ ) {\n                  my $line = $1;\n                  $line =~ s/;\\s*//; # trim trailing semicolon and any spaces at the end of the line\n                  my $evidence = Bio::Annotation::SimpleValue->new\n                      (-tagname   => 'evidence',\n                       -value     => $line\n                      );\n                  $annotation->add_Annotation($evidence);\n              }\n              # Organism name and phylogenetic information\n              elsif (/^O[SCG]/) {\n                  my $species = $self->_read_swissprot_Species($_);\n                  $params{'-species'}= $species;\n                  # now we are one line ahead -- so continue without reading the next\n                  # line   HL 05/11/2000\n              }\n              # References\n              elsif (/^R/) {\n                  my $refs = $self->_read_swissprot_References($_);\n                  foreach my $r (@$refs) {\n                      $annotation->add_Annotation('reference',$r);\n                  }\n              }\n              # Comments\n              elsif (/^CC\\s{3}(.*)/) {\n                  $comment .= $1;\n                  $comment .= \"\\n\";\n                  while (defined ($_ = $self->_readline) && /^CC\\s{3}(.*)/ ) {\n                      $comment .= $1 . \"\\n\";\n                  }\n\n                  # note: don't try to process comments here -- they may contain\n                  # structure. LP 07/30/2000\n\n                  my $commobj = Bio::Annotation::Comment->new(-tagname => 'comment',\n                                                              -text    => $comment);\n                  $annotation->add_Annotation('comment',$commobj);\n                  $comment = \"\";\n                  $self->_pushback($_);\n              }\n              #DBLinks\n              # old regexp\n              # /^DR\\s+(\\S+)\\;\\s+(\\S+)\\;\\s+(\\S+)[\\;\\.](.*)$/) {\n              # new regexp from Andreas Kahari  bug #1584\n              elsif (/^DR\\s+(\\S+)\\;\\s+(\\S+)\\;\\s+([^;]+)[\\;\\.](.*)$/) {\n                  my ($database,$primaryid,$optional,$comment) = ($1,$2,$3,$4);\n\n                  # drop leading and training spaces and trailing .\n                  $comment =~ s/\\.\\s*$//;\n                  $comment =~ s/^\\s+//;\n\n                  my $dblinkobj =  Bio::Annotation::DBLink->new\n                      (-database    => $database,\n                       -primary_id  => $primaryid,\n                       -optional_id => $optional,\n                       -comment     => $comment,\n                       -tagname     => 'dblink',\n                      );\n\n                  $annotation->add_Annotation('dblink',$dblinkobj);\n              }\n              #keywords\n              elsif ( /^KW\\s+(.*)$/ ) {\n                  my @kw = split(/\\s*\\;\\s*/,$1);\n                  defined $kw[-1] && $kw[-1] =~ s/\\.$//;\n                  push @{$params{'-keywords'}}, @kw;\n              }\n          }\n    # process and parse the gene name line if there was one (note: we\n    # can't do this above b/c GN may be multi-line and we can't\n    # unequivocally determine whether we've seen the last GN line in\n    # the new format)\n    if ($genename) {\n        my @stags;\n        if ($genename =~ /\\w=\\w/) {\n            # new format (e.g., Name=RCHY1; Synonyms=ZNF363, CHIMP)\n            for my $n (split(m{\\s+and\\s+},$genename)) {\n                my @genenames;\n                for my $section (split(m{\\s*;\\s*},$n)) {\n                    my ($tag, $rest) = split(\"=\",$section);\n                    $rest ||= '';\n                    for my $val (split(m{\\s*,\\s*},$rest)) {\n                        push @genenames, [$tag => $val];\n                    }\n                }\n                push @stags, ['gene_name' => \\@genenames];\n            }\n        } else {\n            # old format\n            for my $section (split(/ AND /, $genename)) {\n                my @genenames;\n                $section =~ s/[\\(\\)\\.]//g;\n                my @names = split(m{\\s+OR\\s+}, $section);\n                push @genenames, ['Name' => shift @names];\n                push @genenames, map {['Synonyms' => $_]} @names;\n                push @stags, ['gene_name' => \\@genenames]            \n            }\n        } #use Data::Dumper; print Dumper $gn, $genename;# exit;\n        my $gn = Bio::Annotation::TagTree->new(-tagname => 'gene_name',\n                                               -value => ['gene_names' => \\@stags]);\n        $annotation->add_Annotation('gene_name', $gn);\n    }\n\n    FEATURE_TABLE :\n          # if there is no feature table, or if we've got beyond, exit loop or don't\n          # even enter    HL 05/11/2000\n          while (defined $_ && /^FT/ ) {\n              my $ftunit = $self->_read_FTHelper_swissprot($_);\n\n              # process ftunit\n              # when parsing of the line fails we get undef returned\n              if ($ftunit) {\n                  push(@features,\n                       $ftunit->_generic_seqfeature($self->location_factory(),\n                                                    $params{'-seqid'}, \"SwissProt\"));\n              } else {\n                  $self->warn(\"failed to parse feature table line for seq \" .\n                              $params{'-display_id'}. \"\\n$_\");\n              }\n              $_ = $self->_readline;\n          }\n    while ( defined($_) && ! /^SQ/ ) {\n        $_ = $self->_readline;\n    }\n    $seqc = \"\";\n    while ( defined ($_ = $self->_readline) ) {\n        last if m{^//};\n        s/[^A-Za-z]//g;\n        $seqc .= uc($_);\n    }\n\n    my $seq=  $self->sequence_factory->create\n        (-verbose  => $self->verbose,\n         %params,\n         -seq      => $seqc,\n         -desc     => $desc,\n         -features => \\@features,\n         -annotation => $annotation,\n        );\n\n    # The annotation doesn't get added by the contructor\n    $seq->annotation($annotation);\n\n    return $seq;\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq($seq)\n Function: writes the $seq object (must be seq) to the stream\n Returns : 1 for success and 0 for error\n Args    : array of 1 to n Bio::SeqI objects\n\n\n\nsub write_seq {\n    my ($self,@seqs) = @_;\n    foreach my $seq ( @seqs ) {\n        $self->throw(\"Attempting to write with no seq!\") unless defined $seq;\n\n        if ( ! ref $seq || ! $seq->isa('Bio::SeqI') ) {\n            $self->warn(\" $seq is not a SeqI compliant module. Attempting to dump, but may fail!\");\n        }\n\n        my $i;\n        my $str = $seq->seq;\n\n        my $div;\n        my $ns = ($seq->can('namespace')) && $seq->namespace();\n        my $len = $seq->length();\n\n        if ( !$seq->can('division') || ! defined ($div = $seq->division()) ) {\n            $div = 'UNK';\n        }\n\n        # namespace dictates database, takes precedent over division. Sorry!\n        if (defined($ns)) {\n            $div = ($ns eq 'Swiss-Prot') ? 'Reviewed'    :\n                ($ns eq 'TrEMBL')     ? 'Unreviewed' :\n                    $ns;\n        } else {\n            $ns = 'Swiss-Prot';\n            # division not reset; acts as fallback\n        }\n\n        $self->warn(\"No whitespace allowed in SWISS-PROT display id [\". $seq->display_id. \"]\")\n            if $seq->display_id =~ /\\s/;\n\n        my $temp_line;\n        if ( $self->_id_generation_func ) {\n            $temp_line = &{$self->_id_generation_func}($seq);\n        } else {\n            #$temp_line = sprintf (\"%10s     STANDARD;      %3s;   %d AA.\",\n            #            $seq->primary_id().\"_\".$div,$mol,$len);\n            # Reconstructing the ID relies heavily upon the input source having\n            # been in a format that is parsed as this routine expects it -- that is,\n            # by this module itself. This is bad, I think, and immediately breaks\n            # if e.g. the Bio::DB::GenPept module is used as input.\n            # Hence, switch to display_id(); _every_ sequence is supposed to have\n            # this. HL 2000/09/03\n            # Changed to reflect ID line changes in UniProt\n            # Oct 2006 - removal of molecule type - see bug 2134\n            $temp_line = sprintf (\"%-24s%-12s%9d AA.\",\n                                  $seq->display_id(), $div.';', $len);\n        }\n\n        $self->_print( \"ID   $temp_line\\n\");\n\n        # if there, write the accession line\n        local($^W) = 0;         # supressing warnings about uninitialized fields\n\n        if ( $self->_ac_generation_func ) {\n            $temp_line = &{$self->_ac_generation_func}($seq);\n            $self->_print( \"AC   $temp_line\\n\");\n        }\n        elsif ($seq->can('accession_number') ) {\n            my $ac_line = $seq->accession_number;\n            if ($seq->can('get_secondary_accessions') ) {\n                foreach my $sacc ($seq->get_secondary_accessions) {\n                    $ac_line .= \"; \". $sacc;;\n                }\n                $ac_line .= \";\";\n            }\n\n            $self->_write_line_swissprot_regex(\"AC   \",\"AC   \",$ac_line,\n                                               \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n        }\n        # otherwise - cannot print <sigh>\n\n\n        # Date lines and sequence versions (changed 6/15/2006)\n        # This is rebuilt from scratch using the current SwissProt/UniProt format\n        if ( $seq->can('get_dates') ) {\n            my @dates =  $seq->get_dates();\n            my $ct = 1;\n            my $seq_version = $seq->version;\n            my ($update_version) = $seq->annotation->get_Annotations(\"seq_update\");\n            foreach my $dt (@dates) {\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.', integrated into UniProtKB/'.$ns.'.',\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 1;\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.\", sequence version \".$update_version->display_text.'.',\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 2;\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.\", entry version $seq_version.\",\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 3;\n                $ct++;\n            }\n        }\n\n        #Definition lines\n        $self->_write_line_swissprot_regex(\"DE   \",\"DE   \",$seq->desc(),\"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n\n        #Gene name; print out new format\n        foreach my $gene ( my @genes = $seq->annotation->get_Annotations('gene_name') ) {\n            # gene is a Bio::Annotation::TagTree;\n            my @genelines;\n            for my $node ($gene->findnode('gene_name')) {\n                # check for Name and Synonym first, then the rest get tagged on\n                my $geneline = \"GN   \";\n                my %genedata = $node->hash;\n                for my $tag (@GENE_NAME_ORDER) {\n                    if (exists $genedata{$tag}) {\n                        $geneline .= (ref $genedata{$tag} eq 'ARRAY') ?\n                            \"$tag=\".join(', ',@{$genedata{$tag}}).\"; \" :\n                            \"$tag=$genedata{$tag}; \";\n                        delete $genedata{$tag};\n                    }\n                }\n                # add rest\n                for my $tag (sort keys %genedata) {\n                    $geneline .= (ref $genedata{$tag} eq 'ARRAY') ?\n                        \"$tag=\".join(', ',@{$genedata{$tag}}).\"; \" :\n                        \"$tag=$genedata{$tag}; \";\n                    delete $genedata{$tag};\n                }\n                push @genelines, \"$geneline\\n\";\n            }\n            $self->_print(join(\"GN   and\\n\",@genelines));\n        }\n\n        # Organism lines\n        if ($seq->can('species') && (my $spec = $seq->species)) {\n            my @class = $spec->classification();\n            shift(@class);\n            my $species = $spec->species;\n            my $genus = $spec->genus;\n            my $OS = $spec->scientific_name;\n            if ($class[-1] =~ /viruses/i) {\n                $OS = $species;\n                $OS .=  \" \". $spec->sub_species if $spec->sub_species;\n            }\n            foreach (($spec->variant, $spec->common_name)) {\n                $OS .= \" ($_)\" if $_;\n            }\n            $self->_print( \"OS   $OS.\\n\");\n            my $OC = join('; ', reverse(@class)) .'.';\n            $self->_write_line_swissprot_regex(\"OC   \",\"OC   \",$OC,\"\\; \\|\\$\",$LINE_LENGTH);\n            if ($spec->organelle) {\n                $self->_write_line_swissprot_regex(\"OG   \",\"OG   \",$spec->organelle,\"\\; \\|\\$\",$LINE_LENGTH);\n            }\n            if ($spec->ncbi_taxid) {\n                $self->_print(\"OX   NCBI_TaxID=\".$spec->ncbi_taxid.\";\\n\");\n            }\n        }\n\n        # Reference lines\n        my $t = 1;\n        foreach my $ref ( $seq->annotation->get_Annotations('reference') ) {\n            $self->_print( \"RN   [$t]\\n\");\n            # changed by lorenz 08/03/00\n            # j.gilbert and h.lapp agreed that the rp line in swissprot seems\n            # more like a comment than a parseable value, so print it as is\n            if ($ref->rp) {\n                $self->_write_line_swissprot_regex(\"RP   \",\"RP   \",$ref->rp,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            }\n            if ($ref->comment) {\n                $self->_write_line_swissprot_regex(\"RC   \",\"RC   \",$ref->comment,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            }\n            if ($ref->medline or $ref->pubmed or $ref->doi) {\n                # new RX format in swissprot LP 09/17/00\n                # RX line can now have a DOI, Heikki 13 Feb 2008\n\n                my $line;\n                $line .= \"MEDLINE=\". $ref->medline. '; ' if $ref->medline;\n                $line .= \"PubMed=\". $ref->pubmed. '; ' if $ref->pubmed;\n                $line .= \"DOI=\". $ref->doi. '; ' if $ref->doi;\n                chop $line;\n\n                $self->_write_line_swissprot_regex(\"RX   \",\"RX   \",\n                                                   $line,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n\n            }\n            my $author = $ref->authors .';' if($ref->authors);\n            my $title = $ref->title .';' if( $ref->title);\n            my $rg = $ref->rg . ';' if $ref->rg;\n            $author =~ s/([\\w\\.]) (\\w)/$1#$2/g;  # add word wrap protection char '#'\n\n            $self->_write_line_swissprot_regex(\"RG   \",\"RG   \",$rg,\"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $rg;\n            $self->_write_line_swissprot_regex(\"RA   \",\"RA   \",$author,\"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $author;\n            $self->_write_line_swissprot_regex(\"RT   \",\"RT   \",$title,'[\\s\\-]+|$',$LINE_LENGTH) if $title;\n            $self->_write_line_swissprot_regex(\"RL   \",\"RL   \",$ref->location,\"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            $t++;\n        }\n\n        # Comment lines\n\n        foreach my $comment ( $seq->annotation->get_Annotations('comment') ) {\n            foreach my $cline (split (\"\\n\", $comment->text)) {\n                while (length $cline > 74) {\n                    $self->_print(\"CC   \",(substr $cline,0,74),\"\\n\");\n                    $cline = substr $cline,74;\n                }\n                $self->_print(\"CC   \",$cline,\"\\n\");\n            }\n        }\n\n        # Database xref lines\n\n        foreach my $dblink ( $seq->annotation->get_Annotations('dblink') ) {\n            my ($primary_id) = $dblink->primary_id;\n\t\n            if (defined($dblink->comment) && ($dblink->comment) ) {\n                $self->_print(\"DR   \",$dblink->database,\"; \",$primary_id,\"; \",\n                              $dblink->optional_id,\"; \",$dblink->comment,\".\\n\");\n            } elsif ($dblink->optional_id) {\n                $self->_print(\"DR   \",$dblink->database,\"; \",\n                              $primary_id,\"; \",\n                              $dblink->optional_id,\".\\n\");\n            } else {\n                $self->_print(\"DR   \",$dblink->database,\n                              \"; \",$primary_id,\"; \",\"-.\\n\");\n            }\n        }\n\n        # Evidence lines\n\n        foreach my $evidence ( $seq->annotation->get_Annotations('evidence') ) {\n            $self->_print(\"PE   \",$evidence->value,\";\\n\");\n        }\n\n        # if there, write the kw line\n        {\n            my $kw;\n            if ( my $func = $self->_kw_generation_func ) {\n                $kw = &{$func}($seq);\n            } elsif ( $seq->can('keywords') ) {\n                $kw = $seq->keywords;\n                if ( ref($kw) =~ /ARRAY/i ) {\n                    $kw = join(\"; \", @$kw);\n                }\n                $kw .= '.' if $kw and $kw !~ /\\.$/ ;\n            }\n            $kw =~ s/([\\w\\.]) (\\w)/$1#$2/g;  # add word wrap protection char '#'\n            $self->_write_line_swissprot_regex(\"KW   \",\"KW   \",\n                                               $kw, \"\\\\s\\+\\|\\$\",$LINE_LENGTH)\n                if $kw;\n        }\n\n        #Check if there is seqfeatures before printing the FT line\n        my @feats = $seq->can('top_SeqFeatures') ? $seq->top_SeqFeatures : ();\n        if ($feats[0]) {\n            if ( defined $self->_post_sort ) {\n\n                # we need to read things into an array. Process. Sort them. Print 'em\n\n                my $post_sort_func = $self->_post_sort();\n                my @fth;\n\n                foreach my $sf ( @feats ) {\n                    push(@fth,Bio::SeqIO::FTHelper::from_SeqFeature($sf,$seq));\n                }\n                @fth = sort { &$post_sort_func($a,$b) } @fth;\n\n                foreach my $fth ( @fth ) {\n                    $self->_print_swissprot_FTHelper($fth);\n                }\n            } else {\n                # not post sorted. And so we can print as we get them.\n                # lower memory load...\n\n                foreach my $sf ( @feats ) {\n                    my @fth = Bio::SeqIO::FTHelper::from_SeqFeature($sf,$seq);\n                    foreach my $fth ( @fth ) {\n                        if ( ! $fth->isa('Bio::SeqIO::FTHelper') ) {\n                            $sf->throw(\"Cannot process FTHelper... $fth\");\n                        }\n                        $self->_print_swissprot_FTHelper($fth);\n                    }\n                }\n            }\n\n            if ( $self->_show_dna() == 0 ) {\n                return;\n            }\n        }\n        # finished printing features.\n\n        # molecular weight\n        my $mw = ${Bio::Tools::SeqStats->get_mol_wt($seq->primary_seq)}[0];\n        # checksum\n        # was crc32 checksum, changed it to crc64\n        my $crc64 = $self->_crc64(\\$str);\n        $self->_print( sprintf(\"SQ   SEQUENCE  %4d AA;  %d MW;  %16s CRC64;\\n\",\n                               $len,$mw,$crc64));\n        $self->_print( \"    \");\n        my $linepos;\n        for ($i = 0; $i < length($str); $i += 10) {\n            $self->_print( \" \", substr($str,$i,10));\n            $linepos += 11;\n            if ( ($i+10)%60 == 0 && (($i+10) < length($str))) {\n                $self->_print( \"\\n    \");\n            }\n        }\n        $self->_print( \"\\n//\\n\");\n\n        $self->flush if $self->_flush_on_write && defined $self->_fh;\n        return 1;\n    }\n}\n\n# Thanks to James Gilbert for the following two. LP 08/01/2000\n\n=head2 _generateCRCTable\n\n Title   : _generateCRCTable\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _generateCRCTable {\n  # 10001000001010010010001110000100\n  # 32\n    my $poly = 0xEDB88320;\n    my ($self) = shift;\n\n    $self->{'_crcTable'} = [];\n    foreach my $i (0..255) {\n        my $crc = $i;\n        for (my $j=8; $j > 0; $j--) {\n            if ($crc & 1) {\n                $crc = ($crc >> 1) ^ $poly;\n            } else {\n                $crc >>= 1;\n            }\n        }\n        ${$self->{'_crcTable'}}[$i] = $crc;\n    }\n}\n\n\n=head2 _crc32\n\n Title   : _crc32\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _crc32 {\n    my( $self, $str ) = @_;\n\n    $self->throw(\"Argument to crc32() must be ref to scalar\")\n        unless ref($str) eq 'SCALAR';\n\n    $self->_generateCRCTable() unless exists $self->{'_crcTable'};\n\n    my $len = length($$str);\n\n    my $crc = 0xFFFFFFFF;\n    for (my $i = 0; $i < $len; $i++) {\n        # Get upper case value of each letter\n        my $int = ord uc substr $$str, $i, 1;\n        $crc = (($crc >> 8) & 0x00FFFFFF) ^\n            ${$self->{'_crcTable'}}[ ($crc ^ $int) & 0xFF ];\n    }\n    return $crc;\n}\n\n=head2 _crc64\n\n Title   : _crc64\n Usage   :\n Function:\n Example :\n Returns :\n Args    :","parameters":[{"label":"$self"},{"label":"$sequence"}]},"line":882,"range":{"end":{"character":9999,"line":920},"start":{"character":0,"line":882}},"kind":12},{"line":889,"name":"sequence","kind":12},{"definition":"sub","detail":"($self,$fth,$always_quote)","children":[{"definition":"my","line":935,"name":"$self","localvar":"my","kind":13,"containerName":"_print_swissprot_FTHelper"},{"line":935,"kind":13,"containerName":"_print_swissprot_FTHelper","name":"$fth"},{"name":"$always_quote","containerName":"_print_swissprot_FTHelper","kind":13,"line":935},{"name":"$always_quote","containerName":"_print_swissprot_FTHelper","kind":13,"line":936},{"definition":"my","name":"$start","localvar":"my","kind":13,"containerName":"_print_swissprot_FTHelper","line":937},{"name":"$end","containerName":"_print_swissprot_FTHelper","kind":13,"line":937},{"line":939,"name":"$fth","containerName":"_print_swissprot_FTHelper","kind":13},{"containerName":"_print_swissprot_FTHelper","kind":13,"name":"$fth","line":939},{"line":939,"name":"isa","kind":12,"containerName":"_print_swissprot_FTHelper"},{"line":940,"name":"$fth","kind":13,"containerName":"_print_swissprot_FTHelper"},{"containerName":"_print_swissprot_FTHelper","kind":12,"name":"warn","line":940},{"name":"$desc","localvar":"my","containerName":"_print_swissprot_FTHelper","kind":13,"line":943,"definition":"my"},{"definition":"my","line":945,"localvar":"my","containerName":"_print_swissprot_FTHelper","kind":13,"name":"$tag"},{"line":946,"containerName":"_print_swissprot_FTHelper","kind":13,"name":"$fth"},{"kind":12,"containerName":"_print_swissprot_FTHelper","name":"field","line":946},{"name":"$tag","containerName":"_print_swissprot_FTHelper","kind":13,"line":946},{"line":947,"kind":13,"containerName":"_print_swissprot_FTHelper","name":"$desc"},{"name":"$fth","kind":13,"containerName":"_print_swissprot_FTHelper","line":947},{"containerName":"_print_swissprot_FTHelper","kind":12,"name":"field","line":947},{"kind":13,"containerName":"_print_swissprot_FTHelper","name":"$tag","line":947}],"containerName":"main::","name":"_print_swissprot_FTHelper","signature":{"parameters":[{"label":"$self"},{"label":"$fth"},{"label":"$always_quote"}],"documentation":"1;\n# $Id: swiss.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::swiss\n#\n# Copyright Elia Stupka\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::swiss - Swissprot sequence input/output stream\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system:\n\n    use Bio::SeqIO;\n\n    $stream = Bio::SeqIO->new(-file => $filename,\n                              -format => 'swiss');\n\n    while ( my $seq = $stream->next_seq() ) {\n       # do something with $seq\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from Swiss-Pprot flat\nfile databases.\n\nThere is a lot of flexibility here about how to dump things which needs\nto be documented.\n\n=head2 GN (Gene name) line management details\n\nA Uniprot/Swiss-Prot entry holds information on one protein\nsequence. If that sequence is identical across genes and species, they\nare all merged into one entry. This creates complex needs for several\nannotation fields in swiss-prot format.\n\nThe latest syntax for GN line is described in the user manual:\n\n  http://www.expasy.ch/sprot/userman.html#GN_line\n\nEach of the possibly multiple genes in an entry can have Name,\nSynonyms (only if there is a name), OrderedLocusNames (names from\ngenomic sequences) and ORFNames (temporary or cosmid names). \"Name\"\nhere really means \"symbol\". This complexity is now dealt with the\nfollowing way:\n\nA new Bio::AnnotationI class was created in order to store the\ndata in tag-value pairs.  This class (Bio::Annotation::TagTree)\nis stored in the Bio::Annotation::Collection object and is\naccessed like all other annotations. The tag name is 'gene_name'.\n\nThere is a single Bio::Annotation::TagTree per sequence record, which\ncorresponds to the original class that stored this data\n(Bio::Annotation::StructuredValue).  Depending on how we progress\nthis may change to represent each group of gene names.\n\nFor now, to access the gene name tree annotation, one uses the below method:\n\n   my ($gene) = $seq->annotation->get_Annotations('gene_name');\n\nIf you are only interested in displaying the values, value() returns a\nstring with similar formatting.\n\nThere are several ways to get directly at the information you want if you\nknow the element (tag) for the data.  For gene names all data is stored with\nthe element-tag pairs:\n\n  \"element1=tag1, tag2, tag3; element2=tag4, tag5;\"\n\nThis normally means the element will be 'Name', 'Synonyms', etc. and the\ngene names the values.  Using findval(), you can do the following:\n\n  # grab a flattened list of all gene names\n  my @names = $ann->findval('Name');\n\n  # or iterated through the nodes and grab the name for each group\n  for my $node ($ann->findnode('gene_name')) {\n     my @names = $node->findval('Name');\n  }\n\nThe current method for parsing gene name data (and reconstructing gene name\noutput) is very generic. This is somewhat preemptive if, for instance, UniProt\ndecides to update and add another element name to the current ones using the\nsame formatting layout. Under those circumstances, one can iterate through the\ntag tree in a safe way and retrieve all node data like so.\n\n  # retrieve the gene name nodes (groups like names, synonyms, etc).\n  for my $ann ($seq->annotation->get_Annotations('gene_name')) {\n\n      # each gene name group\n      for my $node ($ann->findnode('gene_name')) {\n          print \"Gene name:\\n\";\n\n          # each gene name node (tag => value pair)\n          for my $n ($node->children) {\n              print \"\\t\".$n->element.\": \".$n->children.\"\\n\";\n          }\n      }\n  }\n\nFor more uses see Bio::Annotation::TagTree.\n\nSince Uniprot/Swiss-Prot format have been around for quite some time, the\nparser is also able to read in the older GN line syntax where genes\nare separated by AND and various symbols by OR. The first symbol is\ntaken to be the 'Name' and the remaining ones are stored as 'Synonyms'.\n\n=head2 Optional functions\n\n=over 3\n\n* _show_dna()\n\n(output only) shows the dna or not\n\n* _post_sort()\n\n(output only) provides a sorting func which is applied to the FTHelpers\nbefore printing\n\n* _id_generation_func()\n\nThis is function which is called as\n\n   print \"ID   \", $func($seq), \"\\n\";\n\nTo generate the ID line. If it is not there, it generates a sensible ID\nline using a number of tools.\n\nIf you want to output annotations in Swissprot format they need to be\nstored in a Bio::Annotation::Collection object which is accessible\nthrough the Bio::SeqI interface method L<annotation()|annotation>.\n\nThe following are the names of the keys which are polled from a\nL<Bio::Annotation::Collection> object.\n\n reference   - Should contain Bio::Annotation::Reference objects\n comment     - Should contain Bio::Annotation::Comment objects\n dblink      - Should contain Bio::Annotation::DBLink objects\n gene_name   - Should contain Bio::Annotation::SimpleValue object\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions,\npreferably to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Elia Stupka\n\nEmail elia@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::swiss;\nuse vars qw(@Unknown_names @Unknown_genus);\nuse strict;\nuse Bio::SeqIO::FTHelper;\nuse Bio::SeqFeature::Generic;\nuse Bio::Species;\nuse Bio::Tools::SeqStats;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::Comment;\nuse Bio::Annotation::Reference;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::TagTree;\n\nuse base qw(Bio::SeqIO);\n\nour $LINE_LENGTH = 76;\n\n# this is for doing species name parsing\n@Unknown_names=('other', 'unidentified',\n                'unknown organism', 'not specified',\n                'not shown', 'Unspecified', 'Unknown',\n                'None', 'unclassified', 'unidentified organism',\n                'not supplied'\n               );\n# dictionary of synonyms for taxid 32644\n# all above can be part of valid species name\n@Unknown_genus = qw(unknown unclassified uncultured unidentified);\n\n# if there are any other gene name tags, they are added to the end\nour @GENE_NAME_ORDER = qw(Name Synonyms OrderedLocusNames ORFNames);\n\nsub _initialize {\n    my($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    # hash for functions for decoding keys.\n    $self->{'_func_ftunit_hash'} = {};\n    # sets this to one by default. People can change it\n    $self->_show_dna(1);\n    if ( ! defined $self->sequence_factory ) {\n        $self->sequence_factory(Bio::Seq::SeqFactory->new\n                                (-verbose => $self->verbose(),\n                                 -type => 'Bio::Seq::RichSeq'));\n    }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    :\n\n\nsub next_seq {\n    my ($self,@args) = @_;\n    my ($pseq,$c,$line,$name,$desc,$acc,$seqc,$mol,$div, $sptr,$seq_div,\n        $date,$comment,@date_arr);\n    my $genename = \"\";\n    my ($annotation, %params, @features) = ( Bio::Annotation::Collection->new());\n\n    local $_;\n\n    1 while defined($_ = $self->_readline) && /^\\s+$/;\n    return unless defined $_ && /^ID\\s/;\n\n    # fixed to allow _DIVISION to be optional for bug #946\n    # see bug report for more information\n    #\n    # 9/6/06 Note: Swiss/TrEMBL sequences have no division acc. to UniProt\n    # release notes; this is fixed to simplify the regex parsing\n    # STANDARD (SwissProt) and PRELIMINARY (TrEMBL) added to namespace()\n    unless(  m{^\n               ID              \\s+     #\n               (\\S+)           \\s+     #  $1  entryname\n               ([^\\s;]+);      \\s+     #  $2  DataClass\n               (?:PRT;)?       \\s+     #  Molecule Type (optional)\n               [0-9]+[ ]AA     \\.      #  Sequencelength (capture?)\n               $\n           }ox ) {\n            # I couldn't find any new current UniProt sequences\n            # that matched this format:\n            # || m/^ID\\s+(\\S+)\\s+(_([^\\s_]+))? /ox ) {\n        $self->throw(\"swissprot stream with no ID. Not swissprot in my book\");\n    }\n    ($name, $seq_div) = ($1, $2);\n    $params{'-namespace'} =\n        ($seq_div eq 'Reviewed'   || $seq_div eq 'STANDARD')     ? 'Swiss-Prot' :\n        ($seq_div eq 'Unreviewed' || $seq_div eq 'PRELIMINARY')  ? 'TrEMBL'     :\n         $seq_div;\n    # we shouldn't be setting the division, but for now...\n    my ($junk, $division) = split q(_), $name;\n    $params{'-division'} = $division;\n    $params{'-alphabet'} = 'protein';\n    # this is important to have the id for display in e.g. FTHelper, otherwise\n    # you won't know which entry caused an error\n    $params{'-display_id'} = $name;\n\n    BEFORE_FEATURE_TABLE :\n          while ( defined($_ = $self->_readline) ) {\n              # Exit at start of Feature table and at the sequence at the\n              # latest HL 05/11/2000\n              last if( /^(FT|SQ)/ );\n\n              # Description line(s)\n              if (/^DE\\s+(\\S.*\\S)/) {\n                  $desc .= $desc ? \" $1\" : $1;\n              }\n              #Gene name\n              elsif (/^GN\\s+(.*)/) {\n                  $genename .= \" \" if $genename;\n                  $genename .= $1;\n              }\n              #accession number(s)\n              elsif ( /^AC\\s+(.+)/) {\n                  my @accs = split(/[; ]+/, $1); # allow space in addition\n                  $params{'-accession_number'} = shift @accs\n                      unless defined $params{'-accession_number'};\n                  push @{$params{'-secondary_accessions'}}, @accs;\n              }\n              #date and sequence version\n              elsif ( /^DT\\s+(.*)/ ) {\n                  my $line = $1;\n                  my ($date, $version) = split(' ', $line, 2);\n                  $date =~ tr/,//d; # remove comma if new version\n                  if ($version =~ /\\(Rel\\. (\\d+), Last sequence update\\)/ || # old\n                      /sequence version (\\d+)/) { #new\n                      my $update = Bio::Annotation::SimpleValue->new\n                          (-tagname    => 'seq_update',\n                           -value      => $1\n                          );\n                      $annotation->add_Annotation($update);\n                  } elsif ($version =~ /\\(Rel\\. (\\d+), Last annotation update\\)/ || #old\n                           /entry version (\\d+)/) { #new\n                      $params{'-version'} = $1;\n                  }\n                  push @{$params{'-dates'}}, $date;\n              }\n              # Evidence level\n              elsif ( /^PE\\s+(.*)/ ) {\n                  my $line = $1;\n                  $line =~ s/;\\s*//; # trim trailing semicolon and any spaces at the end of the line\n                  my $evidence = Bio::Annotation::SimpleValue->new\n                      (-tagname   => 'evidence',\n                       -value     => $line\n                      );\n                  $annotation->add_Annotation($evidence);\n              }\n              # Organism name and phylogenetic information\n              elsif (/^O[SCG]/) {\n                  my $species = $self->_read_swissprot_Species($_);\n                  $params{'-species'}= $species;\n                  # now we are one line ahead -- so continue without reading the next\n                  # line   HL 05/11/2000\n              }\n              # References\n              elsif (/^R/) {\n                  my $refs = $self->_read_swissprot_References($_);\n                  foreach my $r (@$refs) {\n                      $annotation->add_Annotation('reference',$r);\n                  }\n              }\n              # Comments\n              elsif (/^CC\\s{3}(.*)/) {\n                  $comment .= $1;\n                  $comment .= \"\\n\";\n                  while (defined ($_ = $self->_readline) && /^CC\\s{3}(.*)/ ) {\n                      $comment .= $1 . \"\\n\";\n                  }\n\n                  # note: don't try to process comments here -- they may contain\n                  # structure. LP 07/30/2000\n\n                  my $commobj = Bio::Annotation::Comment->new(-tagname => 'comment',\n                                                              -text    => $comment);\n                  $annotation->add_Annotation('comment',$commobj);\n                  $comment = \"\";\n                  $self->_pushback($_);\n              }\n              #DBLinks\n              # old regexp\n              # /^DR\\s+(\\S+)\\;\\s+(\\S+)\\;\\s+(\\S+)[\\;\\.](.*)$/) {\n              # new regexp from Andreas Kahari  bug #1584\n              elsif (/^DR\\s+(\\S+)\\;\\s+(\\S+)\\;\\s+([^;]+)[\\;\\.](.*)$/) {\n                  my ($database,$primaryid,$optional,$comment) = ($1,$2,$3,$4);\n\n                  # drop leading and training spaces and trailing .\n                  $comment =~ s/\\.\\s*$//;\n                  $comment =~ s/^\\s+//;\n\n                  my $dblinkobj =  Bio::Annotation::DBLink->new\n                      (-database    => $database,\n                       -primary_id  => $primaryid,\n                       -optional_id => $optional,\n                       -comment     => $comment,\n                       -tagname     => 'dblink',\n                      );\n\n                  $annotation->add_Annotation('dblink',$dblinkobj);\n              }\n              #keywords\n              elsif ( /^KW\\s+(.*)$/ ) {\n                  my @kw = split(/\\s*\\;\\s*/,$1);\n                  defined $kw[-1] && $kw[-1] =~ s/\\.$//;\n                  push @{$params{'-keywords'}}, @kw;\n              }\n          }\n    # process and parse the gene name line if there was one (note: we\n    # can't do this above b/c GN may be multi-line and we can't\n    # unequivocally determine whether we've seen the last GN line in\n    # the new format)\n    if ($genename) {\n        my @stags;\n        if ($genename =~ /\\w=\\w/) {\n            # new format (e.g., Name=RCHY1; Synonyms=ZNF363, CHIMP)\n            for my $n (split(m{\\s+and\\s+},$genename)) {\n                my @genenames;\n                for my $section (split(m{\\s*;\\s*},$n)) {\n                    my ($tag, $rest) = split(\"=\",$section);\n                    $rest ||= '';\n                    for my $val (split(m{\\s*,\\s*},$rest)) {\n                        push @genenames, [$tag => $val];\n                    }\n                }\n                push @stags, ['gene_name' => \\@genenames];\n            }\n        } else {\n            # old format\n            for my $section (split(/ AND /, $genename)) {\n                my @genenames;\n                $section =~ s/[\\(\\)\\.]//g;\n                my @names = split(m{\\s+OR\\s+}, $section);\n                push @genenames, ['Name' => shift @names];\n                push @genenames, map {['Synonyms' => $_]} @names;\n                push @stags, ['gene_name' => \\@genenames]            \n            }\n        } #use Data::Dumper; print Dumper $gn, $genename;# exit;\n        my $gn = Bio::Annotation::TagTree->new(-tagname => 'gene_name',\n                                               -value => ['gene_names' => \\@stags]);\n        $annotation->add_Annotation('gene_name', $gn);\n    }\n\n    FEATURE_TABLE :\n          # if there is no feature table, or if we've got beyond, exit loop or don't\n          # even enter    HL 05/11/2000\n          while (defined $_ && /^FT/ ) {\n              my $ftunit = $self->_read_FTHelper_swissprot($_);\n\n              # process ftunit\n              # when parsing of the line fails we get undef returned\n              if ($ftunit) {\n                  push(@features,\n                       $ftunit->_generic_seqfeature($self->location_factory(),\n                                                    $params{'-seqid'}, \"SwissProt\"));\n              } else {\n                  $self->warn(\"failed to parse feature table line for seq \" .\n                              $params{'-display_id'}. \"\\n$_\");\n              }\n              $_ = $self->_readline;\n          }\n    while ( defined($_) && ! /^SQ/ ) {\n        $_ = $self->_readline;\n    }\n    $seqc = \"\";\n    while ( defined ($_ = $self->_readline) ) {\n        last if m{^//};\n        s/[^A-Za-z]//g;\n        $seqc .= uc($_);\n    }\n\n    my $seq=  $self->sequence_factory->create\n        (-verbose  => $self->verbose,\n         %params,\n         -seq      => $seqc,\n         -desc     => $desc,\n         -features => \\@features,\n         -annotation => $annotation,\n        );\n\n    # The annotation doesn't get added by the contructor\n    $seq->annotation($annotation);\n\n    return $seq;\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq($seq)\n Function: writes the $seq object (must be seq) to the stream\n Returns : 1 for success and 0 for error\n Args    : array of 1 to n Bio::SeqI objects\n\n\n\nsub write_seq {\n    my ($self,@seqs) = @_;\n    foreach my $seq ( @seqs ) {\n        $self->throw(\"Attempting to write with no seq!\") unless defined $seq;\n\n        if ( ! ref $seq || ! $seq->isa('Bio::SeqI') ) {\n            $self->warn(\" $seq is not a SeqI compliant module. Attempting to dump, but may fail!\");\n        }\n\n        my $i;\n        my $str = $seq->seq;\n\n        my $div;\n        my $ns = ($seq->can('namespace')) && $seq->namespace();\n        my $len = $seq->length();\n\n        if ( !$seq->can('division') || ! defined ($div = $seq->division()) ) {\n            $div = 'UNK';\n        }\n\n        # namespace dictates database, takes precedent over division. Sorry!\n        if (defined($ns)) {\n            $div = ($ns eq 'Swiss-Prot') ? 'Reviewed'    :\n                ($ns eq 'TrEMBL')     ? 'Unreviewed' :\n                    $ns;\n        } else {\n            $ns = 'Swiss-Prot';\n            # division not reset; acts as fallback\n        }\n\n        $self->warn(\"No whitespace allowed in SWISS-PROT display id [\". $seq->display_id. \"]\")\n            if $seq->display_id =~ /\\s/;\n\n        my $temp_line;\n        if ( $self->_id_generation_func ) {\n            $temp_line = &{$self->_id_generation_func}($seq);\n        } else {\n            #$temp_line = sprintf (\"%10s     STANDARD;      %3s;   %d AA.\",\n            #            $seq->primary_id().\"_\".$div,$mol,$len);\n            # Reconstructing the ID relies heavily upon the input source having\n            # been in a format that is parsed as this routine expects it -- that is,\n            # by this module itself. This is bad, I think, and immediately breaks\n            # if e.g. the Bio::DB::GenPept module is used as input.\n            # Hence, switch to display_id(); _every_ sequence is supposed to have\n            # this. HL 2000/09/03\n            # Changed to reflect ID line changes in UniProt\n            # Oct 2006 - removal of molecule type - see bug 2134\n            $temp_line = sprintf (\"%-24s%-12s%9d AA.\",\n                                  $seq->display_id(), $div.';', $len);\n        }\n\n        $self->_print( \"ID   $temp_line\\n\");\n\n        # if there, write the accession line\n        local($^W) = 0;         # supressing warnings about uninitialized fields\n\n        if ( $self->_ac_generation_func ) {\n            $temp_line = &{$self->_ac_generation_func}($seq);\n            $self->_print( \"AC   $temp_line\\n\");\n        }\n        elsif ($seq->can('accession_number') ) {\n            my $ac_line = $seq->accession_number;\n            if ($seq->can('get_secondary_accessions') ) {\n                foreach my $sacc ($seq->get_secondary_accessions) {\n                    $ac_line .= \"; \". $sacc;;\n                }\n                $ac_line .= \";\";\n            }\n\n            $self->_write_line_swissprot_regex(\"AC   \",\"AC   \",$ac_line,\n                                               \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n        }\n        # otherwise - cannot print <sigh>\n\n\n        # Date lines and sequence versions (changed 6/15/2006)\n        # This is rebuilt from scratch using the current SwissProt/UniProt format\n        if ( $seq->can('get_dates') ) {\n            my @dates =  $seq->get_dates();\n            my $ct = 1;\n            my $seq_version = $seq->version;\n            my ($update_version) = $seq->annotation->get_Annotations(\"seq_update\");\n            foreach my $dt (@dates) {\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.', integrated into UniProtKB/'.$ns.'.',\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 1;\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.\", sequence version \".$update_version->display_text.'.',\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 2;\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.\", entry version $seq_version.\",\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 3;\n                $ct++;\n            }\n        }\n\n        #Definition lines\n        $self->_write_line_swissprot_regex(\"DE   \",\"DE   \",$seq->desc(),\"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n\n        #Gene name; print out new format\n        foreach my $gene ( my @genes = $seq->annotation->get_Annotations('gene_name') ) {\n            # gene is a Bio::Annotation::TagTree;\n            my @genelines;\n            for my $node ($gene->findnode('gene_name')) {\n                # check for Name and Synonym first, then the rest get tagged on\n                my $geneline = \"GN   \";\n                my %genedata = $node->hash;\n                for my $tag (@GENE_NAME_ORDER) {\n                    if (exists $genedata{$tag}) {\n                        $geneline .= (ref $genedata{$tag} eq 'ARRAY') ?\n                            \"$tag=\".join(', ',@{$genedata{$tag}}).\"; \" :\n                            \"$tag=$genedata{$tag}; \";\n                        delete $genedata{$tag};\n                    }\n                }\n                # add rest\n                for my $tag (sort keys %genedata) {\n                    $geneline .= (ref $genedata{$tag} eq 'ARRAY') ?\n                        \"$tag=\".join(', ',@{$genedata{$tag}}).\"; \" :\n                        \"$tag=$genedata{$tag}; \";\n                    delete $genedata{$tag};\n                }\n                push @genelines, \"$geneline\\n\";\n            }\n            $self->_print(join(\"GN   and\\n\",@genelines));\n        }\n\n        # Organism lines\n        if ($seq->can('species') && (my $spec = $seq->species)) {\n            my @class = $spec->classification();\n            shift(@class);\n            my $species = $spec->species;\n            my $genus = $spec->genus;\n            my $OS = $spec->scientific_name;\n            if ($class[-1] =~ /viruses/i) {\n                $OS = $species;\n                $OS .=  \" \". $spec->sub_species if $spec->sub_species;\n            }\n            foreach (($spec->variant, $spec->common_name)) {\n                $OS .= \" ($_)\" if $_;\n            }\n            $self->_print( \"OS   $OS.\\n\");\n            my $OC = join('; ', reverse(@class)) .'.';\n            $self->_write_line_swissprot_regex(\"OC   \",\"OC   \",$OC,\"\\; \\|\\$\",$LINE_LENGTH);\n            if ($spec->organelle) {\n                $self->_write_line_swissprot_regex(\"OG   \",\"OG   \",$spec->organelle,\"\\; \\|\\$\",$LINE_LENGTH);\n            }\n            if ($spec->ncbi_taxid) {\n                $self->_print(\"OX   NCBI_TaxID=\".$spec->ncbi_taxid.\";\\n\");\n            }\n        }\n\n        # Reference lines\n        my $t = 1;\n        foreach my $ref ( $seq->annotation->get_Annotations('reference') ) {\n            $self->_print( \"RN   [$t]\\n\");\n            # changed by lorenz 08/03/00\n            # j.gilbert and h.lapp agreed that the rp line in swissprot seems\n            # more like a comment than a parseable value, so print it as is\n            if ($ref->rp) {\n                $self->_write_line_swissprot_regex(\"RP   \",\"RP   \",$ref->rp,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            }\n            if ($ref->comment) {\n                $self->_write_line_swissprot_regex(\"RC   \",\"RC   \",$ref->comment,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            }\n            if ($ref->medline or $ref->pubmed or $ref->doi) {\n                # new RX format in swissprot LP 09/17/00\n                # RX line can now have a DOI, Heikki 13 Feb 2008\n\n                my $line;\n                $line .= \"MEDLINE=\". $ref->medline. '; ' if $ref->medline;\n                $line .= \"PubMed=\". $ref->pubmed. '; ' if $ref->pubmed;\n                $line .= \"DOI=\". $ref->doi. '; ' if $ref->doi;\n                chop $line;\n\n                $self->_write_line_swissprot_regex(\"RX   \",\"RX   \",\n                                                   $line,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n\n            }\n            my $author = $ref->authors .';' if($ref->authors);\n            my $title = $ref->title .';' if( $ref->title);\n            my $rg = $ref->rg . ';' if $ref->rg;\n            $author =~ s/([\\w\\.]) (\\w)/$1#$2/g;  # add word wrap protection char '#'\n\n            $self->_write_line_swissprot_regex(\"RG   \",\"RG   \",$rg,\"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $rg;\n            $self->_write_line_swissprot_regex(\"RA   \",\"RA   \",$author,\"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $author;\n            $self->_write_line_swissprot_regex(\"RT   \",\"RT   \",$title,'[\\s\\-]+|$',$LINE_LENGTH) if $title;\n            $self->_write_line_swissprot_regex(\"RL   \",\"RL   \",$ref->location,\"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            $t++;\n        }\n\n        # Comment lines\n\n        foreach my $comment ( $seq->annotation->get_Annotations('comment') ) {\n            foreach my $cline (split (\"\\n\", $comment->text)) {\n                while (length $cline > 74) {\n                    $self->_print(\"CC   \",(substr $cline,0,74),\"\\n\");\n                    $cline = substr $cline,74;\n                }\n                $self->_print(\"CC   \",$cline,\"\\n\");\n            }\n        }\n\n        # Database xref lines\n\n        foreach my $dblink ( $seq->annotation->get_Annotations('dblink') ) {\n            my ($primary_id) = $dblink->primary_id;\n\t\n            if (defined($dblink->comment) && ($dblink->comment) ) {\n                $self->_print(\"DR   \",$dblink->database,\"; \",$primary_id,\"; \",\n                              $dblink->optional_id,\"; \",$dblink->comment,\".\\n\");\n            } elsif ($dblink->optional_id) {\n                $self->_print(\"DR   \",$dblink->database,\"; \",\n                              $primary_id,\"; \",\n                              $dblink->optional_id,\".\\n\");\n            } else {\n                $self->_print(\"DR   \",$dblink->database,\n                              \"; \",$primary_id,\"; \",\"-.\\n\");\n            }\n        }\n\n        # Evidence lines\n\n        foreach my $evidence ( $seq->annotation->get_Annotations('evidence') ) {\n            $self->_print(\"PE   \",$evidence->value,\";\\n\");\n        }\n\n        # if there, write the kw line\n        {\n            my $kw;\n            if ( my $func = $self->_kw_generation_func ) {\n                $kw = &{$func}($seq);\n            } elsif ( $seq->can('keywords') ) {\n                $kw = $seq->keywords;\n                if ( ref($kw) =~ /ARRAY/i ) {\n                    $kw = join(\"; \", @$kw);\n                }\n                $kw .= '.' if $kw and $kw !~ /\\.$/ ;\n            }\n            $kw =~ s/([\\w\\.]) (\\w)/$1#$2/g;  # add word wrap protection char '#'\n            $self->_write_line_swissprot_regex(\"KW   \",\"KW   \",\n                                               $kw, \"\\\\s\\+\\|\\$\",$LINE_LENGTH)\n                if $kw;\n        }\n\n        #Check if there is seqfeatures before printing the FT line\n        my @feats = $seq->can('top_SeqFeatures') ? $seq->top_SeqFeatures : ();\n        if ($feats[0]) {\n            if ( defined $self->_post_sort ) {\n\n                # we need to read things into an array. Process. Sort them. Print 'em\n\n                my $post_sort_func = $self->_post_sort();\n                my @fth;\n\n                foreach my $sf ( @feats ) {\n                    push(@fth,Bio::SeqIO::FTHelper::from_SeqFeature($sf,$seq));\n                }\n                @fth = sort { &$post_sort_func($a,$b) } @fth;\n\n                foreach my $fth ( @fth ) {\n                    $self->_print_swissprot_FTHelper($fth);\n                }\n            } else {\n                # not post sorted. And so we can print as we get them.\n                # lower memory load...\n\n                foreach my $sf ( @feats ) {\n                    my @fth = Bio::SeqIO::FTHelper::from_SeqFeature($sf,$seq);\n                    foreach my $fth ( @fth ) {\n                        if ( ! $fth->isa('Bio::SeqIO::FTHelper') ) {\n                            $sf->throw(\"Cannot process FTHelper... $fth\");\n                        }\n                        $self->_print_swissprot_FTHelper($fth);\n                    }\n                }\n            }\n\n            if ( $self->_show_dna() == 0 ) {\n                return;\n            }\n        }\n        # finished printing features.\n\n        # molecular weight\n        my $mw = ${Bio::Tools::SeqStats->get_mol_wt($seq->primary_seq)}[0];\n        # checksum\n        # was crc32 checksum, changed it to crc64\n        my $crc64 = $self->_crc64(\\$str);\n        $self->_print( sprintf(\"SQ   SEQUENCE  %4d AA;  %d MW;  %16s CRC64;\\n\",\n                               $len,$mw,$crc64));\n        $self->_print( \"    \");\n        my $linepos;\n        for ($i = 0; $i < length($str); $i += 10) {\n            $self->_print( \" \", substr($str,$i,10));\n            $linepos += 11;\n            if ( ($i+10)%60 == 0 && (($i+10) < length($str))) {\n                $self->_print( \"\\n    \");\n            }\n        }\n        $self->_print( \"\\n//\\n\");\n\n        $self->flush if $self->_flush_on_write && defined $self->_fh;\n        return 1;\n    }\n}\n\n# Thanks to James Gilbert for the following two. LP 08/01/2000\n\n=head2 _generateCRCTable\n\n Title   : _generateCRCTable\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _generateCRCTable {\n  # 10001000001010010010001110000100\n  # 32\n    my $poly = 0xEDB88320;\n    my ($self) = shift;\n\n    $self->{'_crcTable'} = [];\n    foreach my $i (0..255) {\n        my $crc = $i;\n        for (my $j=8; $j > 0; $j--) {\n            if ($crc & 1) {\n                $crc = ($crc >> 1) ^ $poly;\n            } else {\n                $crc >>= 1;\n            }\n        }\n        ${$self->{'_crcTable'}}[$i] = $crc;\n    }\n}\n\n\n=head2 _crc32\n\n Title   : _crc32\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _crc32 {\n    my( $self, $str ) = @_;\n\n    $self->throw(\"Argument to crc32() must be ref to scalar\")\n        unless ref($str) eq 'SCALAR';\n\n    $self->_generateCRCTable() unless exists $self->{'_crcTable'};\n\n    my $len = length($$str);\n\n    my $crc = 0xFFFFFFFF;\n    for (my $i = 0; $i < $len; $i++) {\n        # Get upper case value of each letter\n        my $int = ord uc substr $$str, $i, 1;\n        $crc = (($crc >> 8) & 0x00FFFFFF) ^\n            ${$self->{'_crcTable'}}[ ($crc ^ $int) & 0xFF ];\n    }\n    return $crc;\n}\n\n=head2 _crc64\n\n Title   : _crc64\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _crc64{\n    my ($self, $sequence) = @_;\n    my $POLY64REVh = 0xd8000000;\n    my @CRCTableh = 256;\n    my @CRCTablel = 256;\n    my $initialized;\n\n    my $seq = $$sequence;\n\n    my $crcl = 0;\n    my $crch = 0;\n    if (!$initialized) {\n        $initialized = 1;\n        for (my $i=0; $i<256; $i++) {\n            my $partl = $i;\n            my $parth = 0;\n            for (my $j=0; $j<8; $j++) {\n                my $rflag = $partl & 1;\n                $partl >>= 1;\n                $partl |= (1 << 31) if $parth & 1;\n                $parth >>= 1;\n                $parth ^= $POLY64REVh if $rflag;\n            }\n            $CRCTableh[$i] = $parth;\n            $CRCTablel[$i] = $partl;\n        }\n    }\n\n    foreach (split '', $seq) {\n        my $shr = ($crch & 0xFF) << 24;\n        my $temp1h = $crch >> 8;\n        my $temp1l = ($crcl >> 8) | $shr;\n        my $tableindex = ($crcl ^ (unpack \"C\", $_)) & 0xFF;\n        $crch = $temp1h ^ $CRCTableh[$tableindex];\n        $crcl = $temp1l ^ $CRCTablel[$tableindex];\n    }\n    my $crc64 = sprintf(\"%08X%08X\", $crch, $crcl);\n    return $crc64;\n}\n\n=head2 _print_swissprot_FTHelper\n\n Title   : _print_swissprot_FTHelper\n Usage   :\n Function:\n Example :\n Returns :\n Args    :","label":"_print_swissprot_FTHelper($self,$fth,$always_quote)"},"line":934,"range":{"start":{"character":0,"line":934},"end":{"line":950,"character":9999}},"kind":12},{"line":951,"kind":13,"containerName":null,"name":"$desc"},{"line":953,"name":"$ftid","localvar":"my","containerName":null,"kind":13,"definition":"my"},{"containerName":null,"kind":13,"name":"$fth","line":954},{"line":954,"name":"field","containerName":"main::","kind":12},{"line":955,"kind":13,"containerName":null,"name":"$ftid"},{"name":"$fth","kind":13,"containerName":null,"line":955},{"line":955,"kind":12,"containerName":"main::","name":"field"},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"$key","line":958},{"line":958,"containerName":null,"kind":13,"name":"$fth"},{"line":958,"kind":12,"containerName":"main::","name":"key"},{"line":959,"localvar":"my","containerName":null,"kind":13,"name":"$loc","definition":"my"},{"line":959,"name":"$fth","containerName":null,"kind":13},{"name":"loc","containerName":"main::","kind":12,"line":959},{"line":960,"name":"%loc","containerName":null,"kind":13},{"name":"$start","kind":13,"containerName":null,"line":961},{"line":962,"kind":13,"containerName":null,"name":"$end"},{"name":"%loc","containerName":null,"kind":13,"line":966},{"localvar":"my","containerName":null,"kind":13,"name":"@y","line":967,"definition":"my"},{"line":968,"name":"%m","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"line":969,"kind":13,"containerName":null,"name":"$m"},{"line":970,"kind":13,"containerName":null,"name":"@y"},{"kind":13,"containerName":null,"name":"$m","line":970},{"line":972,"kind":13,"localvar":"my","containerName":null,"name":"$x","definition":"my"},{"name":"@y","containerName":null,"kind":13,"line":972},{"containerName":null,"kind":13,"name":"$self","line":973},{"containerName":"main::","kind":12,"name":"_write_line_swissprot_regex","line":973},{"kind":13,"containerName":null,"name":"$key","line":975},{"line":976,"kind":13,"containerName":null,"name":"$x"},{"kind":13,"containerName":null,"name":"$x","line":976},{"line":978,"kind":13,"containerName":null,"name":"$desc"},{"name":"%LINE_LENGTH","containerName":null,"kind":13,"line":978},{"name":"$start","kind":13,"containerName":null,"line":982},{"line":982,"name":"$end","containerName":null,"kind":13},{"name":"$fth","containerName":null,"kind":13,"line":982},{"line":982,"kind":12,"containerName":"main::","name":"loc"},{"line":984,"name":"%desc","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$self","line":985},{"line":985,"name":"_write_line_swissprot_regex","containerName":"main::","kind":12},{"line":986,"name":"$key","containerName":null,"kind":13},{"name":"$start","kind":13,"containerName":null,"line":987},{"line":987,"containerName":null,"kind":13,"name":"$end"},{"name":"$desc","containerName":null,"kind":13,"line":989},{"line":989,"containerName":null,"kind":13,"name":"%LINE_LENGTH"},{"line":991,"containerName":null,"kind":13,"name":"$self"},{"name":"_write_line_swissprot_regex","kind":12,"containerName":"main::","line":991},{"name":"$key","kind":13,"containerName":null,"line":992},{"line":993,"name":"$start","containerName":null,"kind":13},{"line":993,"name":"$end","containerName":null,"kind":13},{"line":995,"name":"$LINE_LENGTH","containerName":null,"kind":13},{"line":999,"containerName":null,"kind":13,"name":"%ftid"},{"name":"$self","containerName":null,"kind":13,"line":1000},{"containerName":"main::","kind":12,"name":"_write_line_swissprot_regex","line":1000},{"line":1002,"name":"$LINE_LENGTH","kind":13,"containerName":null},{"detail":"($self,$line)","definition":"sub","name":"_read_swissprot_References","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"_read_swissprot_References","name":"$self","line":1022,"definition":"my"},{"line":1022,"kind":13,"containerName":"_read_swissprot_References","name":"$line"},{"line":1023,"name":"$b1","containerName":"_read_swissprot_References","localvar":"my","kind":13,"definition":"my"},{"name":"$b2","kind":13,"containerName":"_read_swissprot_References","line":1023},{"line":1023,"name":"$rp","kind":13,"containerName":"_read_swissprot_References"},{"line":1023,"kind":13,"containerName":"_read_swissprot_References","name":"$rg"},{"name":"$title","kind":13,"containerName":"_read_swissprot_References","line":1023},{"name":"$loc","containerName":"_read_swissprot_References","kind":13,"line":1023},{"line":1023,"kind":13,"containerName":"_read_swissprot_References","name":"$au"},{"name":"$med","containerName":"_read_swissprot_References","kind":13,"line":1023},{"line":1023,"containerName":"_read_swissprot_References","kind":13,"name":"$com"},{"line":1023,"name":"$pubmed","containerName":"_read_swissprot_References","kind":13},{"name":"$doi","containerName":"_read_swissprot_References","kind":13,"line":1023},{"containerName":"_read_swissprot_References","localvar":"my","kind":13,"name":"@refs","line":1024,"definition":"my"},{"kind":13,"containerName":"_read_swissprot_References","name":"$line","line":1025},{"name":"$rp","containerName":"_read_swissprot_References","kind":13,"line":1028},{"name":"$rg","containerName":"_read_swissprot_References","kind":13,"line":1029},{"line":1029,"name":"$rg","containerName":"_read_swissprot_References","kind":13},{"name":"$au","kind":13,"containerName":"_read_swissprot_References","line":1030},{"line":1031,"name":"$au","kind":13,"containerName":"_read_swissprot_References"},{"name":"$au","kind":13,"containerName":"_read_swissprot_References","line":1033},{"line":1033,"name":"$rg","kind":13,"containerName":"_read_swissprot_References"},{"kind":13,"containerName":"_read_swissprot_References","name":"$title","line":1035},{"line":1035,"name":"$title","kind":13,"containerName":"_read_swissprot_References"},{"kind":13,"containerName":"_read_swissprot_References","name":"@refs","line":1036},{"line":1037,"name":"new","containerName":"_read_swissprot_References","kind":12},{"line":1037,"name":"$title","kind":13,"containerName":"_read_swissprot_References"},{"line":1038,"containerName":"_read_swissprot_References","kind":13,"name":"$b1"},{"line":1039,"containerName":"_read_swissprot_References","kind":13,"name":"$b2"},{"line":1040,"name":"$au","kind":13,"containerName":"_read_swissprot_References"},{"name":"$loc","kind":13,"containerName":"_read_swissprot_References","line":1041},{"line":1042,"containerName":"_read_swissprot_References","kind":13,"name":"$med"},{"line":1043,"containerName":"_read_swissprot_References","kind":13,"name":"$pubmed"},{"name":"$doi","kind":13,"containerName":"_read_swissprot_References","line":1044},{"name":"$com","kind":13,"containerName":"_read_swissprot_References","line":1045},{"line":1046,"name":"$rp","containerName":"_read_swissprot_References","kind":13},{"line":1047,"kind":13,"containerName":"_read_swissprot_References","name":"$rg"},{"kind":13,"containerName":"_read_swissprot_References","name":"$rp","line":1051},{"line":1054,"kind":13,"containerName":"_read_swissprot_References","name":"$self"},{"containerName":"_read_swissprot_References","kind":12,"name":"_pushback","line":1054},{"line":1058,"kind":13,"containerName":"_read_swissprot_References","name":"$b1"},{"name":"$b2","kind":13,"containerName":"_read_swissprot_References","line":1058},{"line":1058,"containerName":"_read_swissprot_References","kind":13,"name":"$rg"},{"line":1058,"name":"$med","kind":13,"containerName":"_read_swissprot_References"},{"name":"$com","kind":13,"containerName":"_read_swissprot_References","line":1058},{"line":1058,"name":"$pubmed","kind":13,"containerName":"_read_swissprot_References"},{"line":1058,"name":"$doi","containerName":"_read_swissprot_References","kind":13},{"name":"$title","containerName":"_read_swissprot_References","kind":13,"line":1059},{"kind":13,"containerName":"_read_swissprot_References","name":"$loc","line":1059},{"name":"$au","kind":13,"containerName":"_read_swissprot_References","line":1059},{"line":1061,"name":"$rp","containerName":"_read_swissprot_References","kind":13},{"line":1062,"name":"$b1","kind":13,"containerName":"_read_swissprot_References"},{"line":1063,"kind":13,"containerName":"_read_swissprot_References","name":"$b2"},{"kind":13,"containerName":"_read_swissprot_References","name":"$rp","line":1065},{"line":1066,"kind":13,"containerName":"_read_swissprot_References","name":"$rp"},{"kind":13,"containerName":"_read_swissprot_References","name":"$rp","line":1068},{"definition":"my","line":1071,"kind":13,"localvar":"my","containerName":"_read_swissprot_References","name":"$line"},{"name":"$med","kind":13,"containerName":"_read_swissprot_References","line":1072},{"line":1072,"name":"$line","containerName":"_read_swissprot_References","kind":13},{"line":1073,"name":"$pubmed","kind":13,"containerName":"_read_swissprot_References"},{"name":"$line","containerName":"_read_swissprot_References","kind":13,"line":1073},{"containerName":"_read_swissprot_References","kind":13,"name":"$doi","line":1074},{"containerName":"_read_swissprot_References","kind":13,"name":"$line","line":1074},{"kind":13,"containerName":"_read_swissprot_References","name":"$au","line":1076},{"name":"$au","kind":13,"containerName":"_read_swissprot_References","line":1076},{"line":1078,"name":"$rg","kind":13,"containerName":"_read_swissprot_References"},{"line":1078,"name":"$rg","kind":13,"containerName":"_read_swissprot_References"},{"name":"$title","kind":13,"containerName":"_read_swissprot_References","line":1080},{"line":1081,"name":"$tline","containerName":"_read_swissprot_References","localvar":"my","kind":13,"definition":"my"},{"containerName":"_read_swissprot_References","kind":13,"name":"$title","line":1082},{"containerName":"_read_swissprot_References","kind":13,"name":"$title","line":1082},{"name":"$tline","containerName":"_read_swissprot_References","kind":13,"line":1082},{"containerName":"_read_swissprot_References","kind":13,"name":"$title","line":1084},{"line":1087,"name":"$loc","containerName":"_read_swissprot_References","kind":13},{"line":1087,"name":"$loc","kind":13,"containerName":"_read_swissprot_References"},{"line":1089,"name":"$com","kind":13,"containerName":"_read_swissprot_References"},{"name":"$com","containerName":"_read_swissprot_References","kind":13,"line":1089},{"containerName":"_read_swissprot_References","kind":13,"name":"$self","line":1091},{"containerName":"_read_swissprot_References","kind":12,"name":"_readline","line":1091},{"line":1093,"name":"@refs","kind":13,"containerName":"_read_swissprot_References"}],"signature":{"label":"_read_swissprot_References($self,$line)","parameters":[{"label":"$self"},{"label":"$line"}],"documentation":"1;\n# $Id: swiss.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::swiss\n#\n# Copyright Elia Stupka\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::swiss - Swissprot sequence input/output stream\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system:\n\n    use Bio::SeqIO;\n\n    $stream = Bio::SeqIO->new(-file => $filename,\n                              -format => 'swiss');\n\n    while ( my $seq = $stream->next_seq() ) {\n       # do something with $seq\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from Swiss-Pprot flat\nfile databases.\n\nThere is a lot of flexibility here about how to dump things which needs\nto be documented.\n\n=head2 GN (Gene name) line management details\n\nA Uniprot/Swiss-Prot entry holds information on one protein\nsequence. If that sequence is identical across genes and species, they\nare all merged into one entry. This creates complex needs for several\nannotation fields in swiss-prot format.\n\nThe latest syntax for GN line is described in the user manual:\n\n  http://www.expasy.ch/sprot/userman.html#GN_line\n\nEach of the possibly multiple genes in an entry can have Name,\nSynonyms (only if there is a name), OrderedLocusNames (names from\ngenomic sequences) and ORFNames (temporary or cosmid names). \"Name\"\nhere really means \"symbol\". This complexity is now dealt with the\nfollowing way:\n\nA new Bio::AnnotationI class was created in order to store the\ndata in tag-value pairs.  This class (Bio::Annotation::TagTree)\nis stored in the Bio::Annotation::Collection object and is\naccessed like all other annotations. The tag name is 'gene_name'.\n\nThere is a single Bio::Annotation::TagTree per sequence record, which\ncorresponds to the original class that stored this data\n(Bio::Annotation::StructuredValue).  Depending on how we progress\nthis may change to represent each group of gene names.\n\nFor now, to access the gene name tree annotation, one uses the below method:\n\n   my ($gene) = $seq->annotation->get_Annotations('gene_name');\n\nIf you are only interested in displaying the values, value() returns a\nstring with similar formatting.\n\nThere are several ways to get directly at the information you want if you\nknow the element (tag) for the data.  For gene names all data is stored with\nthe element-tag pairs:\n\n  \"element1=tag1, tag2, tag3; element2=tag4, tag5;\"\n\nThis normally means the element will be 'Name', 'Synonyms', etc. and the\ngene names the values.  Using findval(), you can do the following:\n\n  # grab a flattened list of all gene names\n  my @names = $ann->findval('Name');\n\n  # or iterated through the nodes and grab the name for each group\n  for my $node ($ann->findnode('gene_name')) {\n     my @names = $node->findval('Name');\n  }\n\nThe current method for parsing gene name data (and reconstructing gene name\noutput) is very generic. This is somewhat preemptive if, for instance, UniProt\ndecides to update and add another element name to the current ones using the\nsame formatting layout. Under those circumstances, one can iterate through the\ntag tree in a safe way and retrieve all node data like so.\n\n  # retrieve the gene name nodes (groups like names, synonyms, etc).\n  for my $ann ($seq->annotation->get_Annotations('gene_name')) {\n\n      # each gene name group\n      for my $node ($ann->findnode('gene_name')) {\n          print \"Gene name:\\n\";\n\n          # each gene name node (tag => value pair)\n          for my $n ($node->children) {\n              print \"\\t\".$n->element.\": \".$n->children.\"\\n\";\n          }\n      }\n  }\n\nFor more uses see Bio::Annotation::TagTree.\n\nSince Uniprot/Swiss-Prot format have been around for quite some time, the\nparser is also able to read in the older GN line syntax where genes\nare separated by AND and various symbols by OR. The first symbol is\ntaken to be the 'Name' and the remaining ones are stored as 'Synonyms'.\n\n=head2 Optional functions\n\n=over 3\n\n* _show_dna()\n\n(output only) shows the dna or not\n\n* _post_sort()\n\n(output only) provides a sorting func which is applied to the FTHelpers\nbefore printing\n\n* _id_generation_func()\n\nThis is function which is called as\n\n   print \"ID   \", $func($seq), \"\\n\";\n\nTo generate the ID line. If it is not there, it generates a sensible ID\nline using a number of tools.\n\nIf you want to output annotations in Swissprot format they need to be\nstored in a Bio::Annotation::Collection object which is accessible\nthrough the Bio::SeqI interface method L<annotation()|annotation>.\n\nThe following are the names of the keys which are polled from a\nL<Bio::Annotation::Collection> object.\n\n reference   - Should contain Bio::Annotation::Reference objects\n comment     - Should contain Bio::Annotation::Comment objects\n dblink      - Should contain Bio::Annotation::DBLink objects\n gene_name   - Should contain Bio::Annotation::SimpleValue object\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions,\npreferably to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Elia Stupka\n\nEmail elia@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::swiss;\nuse vars qw(@Unknown_names @Unknown_genus);\nuse strict;\nuse Bio::SeqIO::FTHelper;\nuse Bio::SeqFeature::Generic;\nuse Bio::Species;\nuse Bio::Tools::SeqStats;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::Comment;\nuse Bio::Annotation::Reference;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::TagTree;\n\nuse base qw(Bio::SeqIO);\n\nour $LINE_LENGTH = 76;\n\n# this is for doing species name parsing\n@Unknown_names=('other', 'unidentified',\n                'unknown organism', 'not specified',\n                'not shown', 'Unspecified', 'Unknown',\n                'None', 'unclassified', 'unidentified organism',\n                'not supplied'\n               );\n# dictionary of synonyms for taxid 32644\n# all above can be part of valid species name\n@Unknown_genus = qw(unknown unclassified uncultured unidentified);\n\n# if there are any other gene name tags, they are added to the end\nour @GENE_NAME_ORDER = qw(Name Synonyms OrderedLocusNames ORFNames);\n\nsub _initialize {\n    my($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    # hash for functions for decoding keys.\n    $self->{'_func_ftunit_hash'} = {};\n    # sets this to one by default. People can change it\n    $self->_show_dna(1);\n    if ( ! defined $self->sequence_factory ) {\n        $self->sequence_factory(Bio::Seq::SeqFactory->new\n                                (-verbose => $self->verbose(),\n                                 -type => 'Bio::Seq::RichSeq'));\n    }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    :\n\n\nsub next_seq {\n    my ($self,@args) = @_;\n    my ($pseq,$c,$line,$name,$desc,$acc,$seqc,$mol,$div, $sptr,$seq_div,\n        $date,$comment,@date_arr);\n    my $genename = \"\";\n    my ($annotation, %params, @features) = ( Bio::Annotation::Collection->new());\n\n    local $_;\n\n    1 while defined($_ = $self->_readline) && /^\\s+$/;\n    return unless defined $_ && /^ID\\s/;\n\n    # fixed to allow _DIVISION to be optional for bug #946\n    # see bug report for more information\n    #\n    # 9/6/06 Note: Swiss/TrEMBL sequences have no division acc. to UniProt\n    # release notes; this is fixed to simplify the regex parsing\n    # STANDARD (SwissProt) and PRELIMINARY (TrEMBL) added to namespace()\n    unless(  m{^\n               ID              \\s+     #\n               (\\S+)           \\s+     #  $1  entryname\n               ([^\\s;]+);      \\s+     #  $2  DataClass\n               (?:PRT;)?       \\s+     #  Molecule Type (optional)\n               [0-9]+[ ]AA     \\.      #  Sequencelength (capture?)\n               $\n           }ox ) {\n            # I couldn't find any new current UniProt sequences\n            # that matched this format:\n            # || m/^ID\\s+(\\S+)\\s+(_([^\\s_]+))? /ox ) {\n        $self->throw(\"swissprot stream with no ID. Not swissprot in my book\");\n    }\n    ($name, $seq_div) = ($1, $2);\n    $params{'-namespace'} =\n        ($seq_div eq 'Reviewed'   || $seq_div eq 'STANDARD')     ? 'Swiss-Prot' :\n        ($seq_div eq 'Unreviewed' || $seq_div eq 'PRELIMINARY')  ? 'TrEMBL'     :\n         $seq_div;\n    # we shouldn't be setting the division, but for now...\n    my ($junk, $division) = split q(_), $name;\n    $params{'-division'} = $division;\n    $params{'-alphabet'} = 'protein';\n    # this is important to have the id for display in e.g. FTHelper, otherwise\n    # you won't know which entry caused an error\n    $params{'-display_id'} = $name;\n\n    BEFORE_FEATURE_TABLE :\n          while ( defined($_ = $self->_readline) ) {\n              # Exit at start of Feature table and at the sequence at the\n              # latest HL 05/11/2000\n              last if( /^(FT|SQ)/ );\n\n              # Description line(s)\n              if (/^DE\\s+(\\S.*\\S)/) {\n                  $desc .= $desc ? \" $1\" : $1;\n              }\n              #Gene name\n              elsif (/^GN\\s+(.*)/) {\n                  $genename .= \" \" if $genename;\n                  $genename .= $1;\n              }\n              #accession number(s)\n              elsif ( /^AC\\s+(.+)/) {\n                  my @accs = split(/[; ]+/, $1); # allow space in addition\n                  $params{'-accession_number'} = shift @accs\n                      unless defined $params{'-accession_number'};\n                  push @{$params{'-secondary_accessions'}}, @accs;\n              }\n              #date and sequence version\n              elsif ( /^DT\\s+(.*)/ ) {\n                  my $line = $1;\n                  my ($date, $version) = split(' ', $line, 2);\n                  $date =~ tr/,//d; # remove comma if new version\n                  if ($version =~ /\\(Rel\\. (\\d+), Last sequence update\\)/ || # old\n                      /sequence version (\\d+)/) { #new\n                      my $update = Bio::Annotation::SimpleValue->new\n                          (-tagname    => 'seq_update',\n                           -value      => $1\n                          );\n                      $annotation->add_Annotation($update);\n                  } elsif ($version =~ /\\(Rel\\. (\\d+), Last annotation update\\)/ || #old\n                           /entry version (\\d+)/) { #new\n                      $params{'-version'} = $1;\n                  }\n                  push @{$params{'-dates'}}, $date;\n              }\n              # Evidence level\n              elsif ( /^PE\\s+(.*)/ ) {\n                  my $line = $1;\n                  $line =~ s/;\\s*//; # trim trailing semicolon and any spaces at the end of the line\n                  my $evidence = Bio::Annotation::SimpleValue->new\n                      (-tagname   => 'evidence',\n                       -value     => $line\n                      );\n                  $annotation->add_Annotation($evidence);\n              }\n              # Organism name and phylogenetic information\n              elsif (/^O[SCG]/) {\n                  my $species = $self->_read_swissprot_Species($_);\n                  $params{'-species'}= $species;\n                  # now we are one line ahead -- so continue without reading the next\n                  # line   HL 05/11/2000\n              }\n              # References\n              elsif (/^R/) {\n                  my $refs = $self->_read_swissprot_References($_);\n                  foreach my $r (@$refs) {\n                      $annotation->add_Annotation('reference',$r);\n                  }\n              }\n              # Comments\n              elsif (/^CC\\s{3}(.*)/) {\n                  $comment .= $1;\n                  $comment .= \"\\n\";\n                  while (defined ($_ = $self->_readline) && /^CC\\s{3}(.*)/ ) {\n                      $comment .= $1 . \"\\n\";\n                  }\n\n                  # note: don't try to process comments here -- they may contain\n                  # structure. LP 07/30/2000\n\n                  my $commobj = Bio::Annotation::Comment->new(-tagname => 'comment',\n                                                              -text    => $comment);\n                  $annotation->add_Annotation('comment',$commobj);\n                  $comment = \"\";\n                  $self->_pushback($_);\n              }\n              #DBLinks\n              # old regexp\n              # /^DR\\s+(\\S+)\\;\\s+(\\S+)\\;\\s+(\\S+)[\\;\\.](.*)$/) {\n              # new regexp from Andreas Kahari  bug #1584\n              elsif (/^DR\\s+(\\S+)\\;\\s+(\\S+)\\;\\s+([^;]+)[\\;\\.](.*)$/) {\n                  my ($database,$primaryid,$optional,$comment) = ($1,$2,$3,$4);\n\n                  # drop leading and training spaces and trailing .\n                  $comment =~ s/\\.\\s*$//;\n                  $comment =~ s/^\\s+//;\n\n                  my $dblinkobj =  Bio::Annotation::DBLink->new\n                      (-database    => $database,\n                       -primary_id  => $primaryid,\n                       -optional_id => $optional,\n                       -comment     => $comment,\n                       -tagname     => 'dblink',\n                      );\n\n                  $annotation->add_Annotation('dblink',$dblinkobj);\n              }\n              #keywords\n              elsif ( /^KW\\s+(.*)$/ ) {\n                  my @kw = split(/\\s*\\;\\s*/,$1);\n                  defined $kw[-1] && $kw[-1] =~ s/\\.$//;\n                  push @{$params{'-keywords'}}, @kw;\n              }\n          }\n    # process and parse the gene name line if there was one (note: we\n    # can't do this above b/c GN may be multi-line and we can't\n    # unequivocally determine whether we've seen the last GN line in\n    # the new format)\n    if ($genename) {\n        my @stags;\n        if ($genename =~ /\\w=\\w/) {\n            # new format (e.g., Name=RCHY1; Synonyms=ZNF363, CHIMP)\n            for my $n (split(m{\\s+and\\s+},$genename)) {\n                my @genenames;\n                for my $section (split(m{\\s*;\\s*},$n)) {\n                    my ($tag, $rest) = split(\"=\",$section);\n                    $rest ||= '';\n                    for my $val (split(m{\\s*,\\s*},$rest)) {\n                        push @genenames, [$tag => $val];\n                    }\n                }\n                push @stags, ['gene_name' => \\@genenames];\n            }\n        } else {\n            # old format\n            for my $section (split(/ AND /, $genename)) {\n                my @genenames;\n                $section =~ s/[\\(\\)\\.]//g;\n                my @names = split(m{\\s+OR\\s+}, $section);\n                push @genenames, ['Name' => shift @names];\n                push @genenames, map {['Synonyms' => $_]} @names;\n                push @stags, ['gene_name' => \\@genenames]            \n            }\n        } #use Data::Dumper; print Dumper $gn, $genename;# exit;\n        my $gn = Bio::Annotation::TagTree->new(-tagname => 'gene_name',\n                                               -value => ['gene_names' => \\@stags]);\n        $annotation->add_Annotation('gene_name', $gn);\n    }\n\n    FEATURE_TABLE :\n          # if there is no feature table, or if we've got beyond, exit loop or don't\n          # even enter    HL 05/11/2000\n          while (defined $_ && /^FT/ ) {\n              my $ftunit = $self->_read_FTHelper_swissprot($_);\n\n              # process ftunit\n              # when parsing of the line fails we get undef returned\n              if ($ftunit) {\n                  push(@features,\n                       $ftunit->_generic_seqfeature($self->location_factory(),\n                                                    $params{'-seqid'}, \"SwissProt\"));\n              } else {\n                  $self->warn(\"failed to parse feature table line for seq \" .\n                              $params{'-display_id'}. \"\\n$_\");\n              }\n              $_ = $self->_readline;\n          }\n    while ( defined($_) && ! /^SQ/ ) {\n        $_ = $self->_readline;\n    }\n    $seqc = \"\";\n    while ( defined ($_ = $self->_readline) ) {\n        last if m{^//};\n        s/[^A-Za-z]//g;\n        $seqc .= uc($_);\n    }\n\n    my $seq=  $self->sequence_factory->create\n        (-verbose  => $self->verbose,\n         %params,\n         -seq      => $seqc,\n         -desc     => $desc,\n         -features => \\@features,\n         -annotation => $annotation,\n        );\n\n    # The annotation doesn't get added by the contructor\n    $seq->annotation($annotation);\n\n    return $seq;\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq($seq)\n Function: writes the $seq object (must be seq) to the stream\n Returns : 1 for success and 0 for error\n Args    : array of 1 to n Bio::SeqI objects\n\n\n\nsub write_seq {\n    my ($self,@seqs) = @_;\n    foreach my $seq ( @seqs ) {\n        $self->throw(\"Attempting to write with no seq!\") unless defined $seq;\n\n        if ( ! ref $seq || ! $seq->isa('Bio::SeqI') ) {\n            $self->warn(\" $seq is not a SeqI compliant module. Attempting to dump, but may fail!\");\n        }\n\n        my $i;\n        my $str = $seq->seq;\n\n        my $div;\n        my $ns = ($seq->can('namespace')) && $seq->namespace();\n        my $len = $seq->length();\n\n        if ( !$seq->can('division') || ! defined ($div = $seq->division()) ) {\n            $div = 'UNK';\n        }\n\n        # namespace dictates database, takes precedent over division. Sorry!\n        if (defined($ns)) {\n            $div = ($ns eq 'Swiss-Prot') ? 'Reviewed'    :\n                ($ns eq 'TrEMBL')     ? 'Unreviewed' :\n                    $ns;\n        } else {\n            $ns = 'Swiss-Prot';\n            # division not reset; acts as fallback\n        }\n\n        $self->warn(\"No whitespace allowed in SWISS-PROT display id [\". $seq->display_id. \"]\")\n            if $seq->display_id =~ /\\s/;\n\n        my $temp_line;\n        if ( $self->_id_generation_func ) {\n            $temp_line = &{$self->_id_generation_func}($seq);\n        } else {\n            #$temp_line = sprintf (\"%10s     STANDARD;      %3s;   %d AA.\",\n            #            $seq->primary_id().\"_\".$div,$mol,$len);\n            # Reconstructing the ID relies heavily upon the input source having\n            # been in a format that is parsed as this routine expects it -- that is,\n            # by this module itself. This is bad, I think, and immediately breaks\n            # if e.g. the Bio::DB::GenPept module is used as input.\n            # Hence, switch to display_id(); _every_ sequence is supposed to have\n            # this. HL 2000/09/03\n            # Changed to reflect ID line changes in UniProt\n            # Oct 2006 - removal of molecule type - see bug 2134\n            $temp_line = sprintf (\"%-24s%-12s%9d AA.\",\n                                  $seq->display_id(), $div.';', $len);\n        }\n\n        $self->_print( \"ID   $temp_line\\n\");\n\n        # if there, write the accession line\n        local($^W) = 0;         # supressing warnings about uninitialized fields\n\n        if ( $self->_ac_generation_func ) {\n            $temp_line = &{$self->_ac_generation_func}($seq);\n            $self->_print( \"AC   $temp_line\\n\");\n        }\n        elsif ($seq->can('accession_number') ) {\n            my $ac_line = $seq->accession_number;\n            if ($seq->can('get_secondary_accessions') ) {\n                foreach my $sacc ($seq->get_secondary_accessions) {\n                    $ac_line .= \"; \". $sacc;;\n                }\n                $ac_line .= \";\";\n            }\n\n            $self->_write_line_swissprot_regex(\"AC   \",\"AC   \",$ac_line,\n                                               \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n        }\n        # otherwise - cannot print <sigh>\n\n\n        # Date lines and sequence versions (changed 6/15/2006)\n        # This is rebuilt from scratch using the current SwissProt/UniProt format\n        if ( $seq->can('get_dates') ) {\n            my @dates =  $seq->get_dates();\n            my $ct = 1;\n            my $seq_version = $seq->version;\n            my ($update_version) = $seq->annotation->get_Annotations(\"seq_update\");\n            foreach my $dt (@dates) {\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.', integrated into UniProtKB/'.$ns.'.',\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 1;\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.\", sequence version \".$update_version->display_text.'.',\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 2;\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.\", entry version $seq_version.\",\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 3;\n                $ct++;\n            }\n        }\n\n        #Definition lines\n        $self->_write_line_swissprot_regex(\"DE   \",\"DE   \",$seq->desc(),\"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n\n        #Gene name; print out new format\n        foreach my $gene ( my @genes = $seq->annotation->get_Annotations('gene_name') ) {\n            # gene is a Bio::Annotation::TagTree;\n            my @genelines;\n            for my $node ($gene->findnode('gene_name')) {\n                # check for Name and Synonym first, then the rest get tagged on\n                my $geneline = \"GN   \";\n                my %genedata = $node->hash;\n                for my $tag (@GENE_NAME_ORDER) {\n                    if (exists $genedata{$tag}) {\n                        $geneline .= (ref $genedata{$tag} eq 'ARRAY') ?\n                            \"$tag=\".join(', ',@{$genedata{$tag}}).\"; \" :\n                            \"$tag=$genedata{$tag}; \";\n                        delete $genedata{$tag};\n                    }\n                }\n                # add rest\n                for my $tag (sort keys %genedata) {\n                    $geneline .= (ref $genedata{$tag} eq 'ARRAY') ?\n                        \"$tag=\".join(', ',@{$genedata{$tag}}).\"; \" :\n                        \"$tag=$genedata{$tag}; \";\n                    delete $genedata{$tag};\n                }\n                push @genelines, \"$geneline\\n\";\n            }\n            $self->_print(join(\"GN   and\\n\",@genelines));\n        }\n\n        # Organism lines\n        if ($seq->can('species') && (my $spec = $seq->species)) {\n            my @class = $spec->classification();\n            shift(@class);\n            my $species = $spec->species;\n            my $genus = $spec->genus;\n            my $OS = $spec->scientific_name;\n            if ($class[-1] =~ /viruses/i) {\n                $OS = $species;\n                $OS .=  \" \". $spec->sub_species if $spec->sub_species;\n            }\n            foreach (($spec->variant, $spec->common_name)) {\n                $OS .= \" ($_)\" if $_;\n            }\n            $self->_print( \"OS   $OS.\\n\");\n            my $OC = join('; ', reverse(@class)) .'.';\n            $self->_write_line_swissprot_regex(\"OC   \",\"OC   \",$OC,\"\\; \\|\\$\",$LINE_LENGTH);\n            if ($spec->organelle) {\n                $self->_write_line_swissprot_regex(\"OG   \",\"OG   \",$spec->organelle,\"\\; \\|\\$\",$LINE_LENGTH);\n            }\n            if ($spec->ncbi_taxid) {\n                $self->_print(\"OX   NCBI_TaxID=\".$spec->ncbi_taxid.\";\\n\");\n            }\n        }\n\n        # Reference lines\n        my $t = 1;\n        foreach my $ref ( $seq->annotation->get_Annotations('reference') ) {\n            $self->_print( \"RN   [$t]\\n\");\n            # changed by lorenz 08/03/00\n            # j.gilbert and h.lapp agreed that the rp line in swissprot seems\n            # more like a comment than a parseable value, so print it as is\n            if ($ref->rp) {\n                $self->_write_line_swissprot_regex(\"RP   \",\"RP   \",$ref->rp,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            }\n            if ($ref->comment) {\n                $self->_write_line_swissprot_regex(\"RC   \",\"RC   \",$ref->comment,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            }\n            if ($ref->medline or $ref->pubmed or $ref->doi) {\n                # new RX format in swissprot LP 09/17/00\n                # RX line can now have a DOI, Heikki 13 Feb 2008\n\n                my $line;\n                $line .= \"MEDLINE=\". $ref->medline. '; ' if $ref->medline;\n                $line .= \"PubMed=\". $ref->pubmed. '; ' if $ref->pubmed;\n                $line .= \"DOI=\". $ref->doi. '; ' if $ref->doi;\n                chop $line;\n\n                $self->_write_line_swissprot_regex(\"RX   \",\"RX   \",\n                                                   $line,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n\n            }\n            my $author = $ref->authors .';' if($ref->authors);\n            my $title = $ref->title .';' if( $ref->title);\n            my $rg = $ref->rg . ';' if $ref->rg;\n            $author =~ s/([\\w\\.]) (\\w)/$1#$2/g;  # add word wrap protection char '#'\n\n            $self->_write_line_swissprot_regex(\"RG   \",\"RG   \",$rg,\"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $rg;\n            $self->_write_line_swissprot_regex(\"RA   \",\"RA   \",$author,\"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $author;\n            $self->_write_line_swissprot_regex(\"RT   \",\"RT   \",$title,'[\\s\\-]+|$',$LINE_LENGTH) if $title;\n            $self->_write_line_swissprot_regex(\"RL   \",\"RL   \",$ref->location,\"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            $t++;\n        }\n\n        # Comment lines\n\n        foreach my $comment ( $seq->annotation->get_Annotations('comment') ) {\n            foreach my $cline (split (\"\\n\", $comment->text)) {\n                while (length $cline > 74) {\n                    $self->_print(\"CC   \",(substr $cline,0,74),\"\\n\");\n                    $cline = substr $cline,74;\n                }\n                $self->_print(\"CC   \",$cline,\"\\n\");\n            }\n        }\n\n        # Database xref lines\n\n        foreach my $dblink ( $seq->annotation->get_Annotations('dblink') ) {\n            my ($primary_id) = $dblink->primary_id;\n\t\n            if (defined($dblink->comment) && ($dblink->comment) ) {\n                $self->_print(\"DR   \",$dblink->database,\"; \",$primary_id,\"; \",\n                              $dblink->optional_id,\"; \",$dblink->comment,\".\\n\");\n            } elsif ($dblink->optional_id) {\n                $self->_print(\"DR   \",$dblink->database,\"; \",\n                              $primary_id,\"; \",\n                              $dblink->optional_id,\".\\n\");\n            } else {\n                $self->_print(\"DR   \",$dblink->database,\n                              \"; \",$primary_id,\"; \",\"-.\\n\");\n            }\n        }\n\n        # Evidence lines\n\n        foreach my $evidence ( $seq->annotation->get_Annotations('evidence') ) {\n            $self->_print(\"PE   \",$evidence->value,\";\\n\");\n        }\n\n        # if there, write the kw line\n        {\n            my $kw;\n            if ( my $func = $self->_kw_generation_func ) {\n                $kw = &{$func}($seq);\n            } elsif ( $seq->can('keywords') ) {\n                $kw = $seq->keywords;\n                if ( ref($kw) =~ /ARRAY/i ) {\n                    $kw = join(\"; \", @$kw);\n                }\n                $kw .= '.' if $kw and $kw !~ /\\.$/ ;\n            }\n            $kw =~ s/([\\w\\.]) (\\w)/$1#$2/g;  # add word wrap protection char '#'\n            $self->_write_line_swissprot_regex(\"KW   \",\"KW   \",\n                                               $kw, \"\\\\s\\+\\|\\$\",$LINE_LENGTH)\n                if $kw;\n        }\n\n        #Check if there is seqfeatures before printing the FT line\n        my @feats = $seq->can('top_SeqFeatures') ? $seq->top_SeqFeatures : ();\n        if ($feats[0]) {\n            if ( defined $self->_post_sort ) {\n\n                # we need to read things into an array. Process. Sort them. Print 'em\n\n                my $post_sort_func = $self->_post_sort();\n                my @fth;\n\n                foreach my $sf ( @feats ) {\n                    push(@fth,Bio::SeqIO::FTHelper::from_SeqFeature($sf,$seq));\n                }\n                @fth = sort { &$post_sort_func($a,$b) } @fth;\n\n                foreach my $fth ( @fth ) {\n                    $self->_print_swissprot_FTHelper($fth);\n                }\n            } else {\n                # not post sorted. And so we can print as we get them.\n                # lower memory load...\n\n                foreach my $sf ( @feats ) {\n                    my @fth = Bio::SeqIO::FTHelper::from_SeqFeature($sf,$seq);\n                    foreach my $fth ( @fth ) {\n                        if ( ! $fth->isa('Bio::SeqIO::FTHelper') ) {\n                            $sf->throw(\"Cannot process FTHelper... $fth\");\n                        }\n                        $self->_print_swissprot_FTHelper($fth);\n                    }\n                }\n            }\n\n            if ( $self->_show_dna() == 0 ) {\n                return;\n            }\n        }\n        # finished printing features.\n\n        # molecular weight\n        my $mw = ${Bio::Tools::SeqStats->get_mol_wt($seq->primary_seq)}[0];\n        # checksum\n        # was crc32 checksum, changed it to crc64\n        my $crc64 = $self->_crc64(\\$str);\n        $self->_print( sprintf(\"SQ   SEQUENCE  %4d AA;  %d MW;  %16s CRC64;\\n\",\n                               $len,$mw,$crc64));\n        $self->_print( \"    \");\n        my $linepos;\n        for ($i = 0; $i < length($str); $i += 10) {\n            $self->_print( \" \", substr($str,$i,10));\n            $linepos += 11;\n            if ( ($i+10)%60 == 0 && (($i+10) < length($str))) {\n                $self->_print( \"\\n    \");\n            }\n        }\n        $self->_print( \"\\n//\\n\");\n\n        $self->flush if $self->_flush_on_write && defined $self->_fh;\n        return 1;\n    }\n}\n\n# Thanks to James Gilbert for the following two. LP 08/01/2000\n\n=head2 _generateCRCTable\n\n Title   : _generateCRCTable\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _generateCRCTable {\n  # 10001000001010010010001110000100\n  # 32\n    my $poly = 0xEDB88320;\n    my ($self) = shift;\n\n    $self->{'_crcTable'} = [];\n    foreach my $i (0..255) {\n        my $crc = $i;\n        for (my $j=8; $j > 0; $j--) {\n            if ($crc & 1) {\n                $crc = ($crc >> 1) ^ $poly;\n            } else {\n                $crc >>= 1;\n            }\n        }\n        ${$self->{'_crcTable'}}[$i] = $crc;\n    }\n}\n\n\n=head2 _crc32\n\n Title   : _crc32\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _crc32 {\n    my( $self, $str ) = @_;\n\n    $self->throw(\"Argument to crc32() must be ref to scalar\")\n        unless ref($str) eq 'SCALAR';\n\n    $self->_generateCRCTable() unless exists $self->{'_crcTable'};\n\n    my $len = length($$str);\n\n    my $crc = 0xFFFFFFFF;\n    for (my $i = 0; $i < $len; $i++) {\n        # Get upper case value of each letter\n        my $int = ord uc substr $$str, $i, 1;\n        $crc = (($crc >> 8) & 0x00FFFFFF) ^\n            ${$self->{'_crcTable'}}[ ($crc ^ $int) & 0xFF ];\n    }\n    return $crc;\n}\n\n=head2 _crc64\n\n Title   : _crc64\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _crc64{\n    my ($self, $sequence) = @_;\n    my $POLY64REVh = 0xd8000000;\n    my @CRCTableh = 256;\n    my @CRCTablel = 256;\n    my $initialized;\n\n    my $seq = $$sequence;\n\n    my $crcl = 0;\n    my $crch = 0;\n    if (!$initialized) {\n        $initialized = 1;\n        for (my $i=0; $i<256; $i++) {\n            my $partl = $i;\n            my $parth = 0;\n            for (my $j=0; $j<8; $j++) {\n                my $rflag = $partl & 1;\n                $partl >>= 1;\n                $partl |= (1 << 31) if $parth & 1;\n                $parth >>= 1;\n                $parth ^= $POLY64REVh if $rflag;\n            }\n            $CRCTableh[$i] = $parth;\n            $CRCTablel[$i] = $partl;\n        }\n    }\n\n    foreach (split '', $seq) {\n        my $shr = ($crch & 0xFF) << 24;\n        my $temp1h = $crch >> 8;\n        my $temp1l = ($crcl >> 8) | $shr;\n        my $tableindex = ($crcl ^ (unpack \"C\", $_)) & 0xFF;\n        $crch = $temp1h ^ $CRCTableh[$tableindex];\n        $crcl = $temp1l ^ $CRCTablel[$tableindex];\n    }\n    my $crc64 = sprintf(\"%08X%08X\", $crch, $crcl);\n    return $crc64;\n}\n\n=head2 _print_swissprot_FTHelper\n\n Title   : _print_swissprot_FTHelper\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _print_swissprot_FTHelper {\n    my ($self,$fth,$always_quote) = @_;\n    $always_quote ||= 0;\n    my ($start,$end) = ('?', '?');\n\n    if ( ! ref $fth || ! $fth->isa('Bio::SeqIO::FTHelper') ) {\n        $fth->warn(\"$fth is not a FTHelper class. \".\n                   \"Attempting to print, but there could be tears!\");\n    }\n    my $desc = \"\";\n\n    for my $tag ( qw(description gene note product) ) {\n        if ( exists $fth->field->{$tag} ) {\n            $desc = @{$fth->field->{$tag}}[0].\".\";\n            last;\n        }\n    }\n    $desc =~ s/\\.$//;\n\n    my $ftid = \"\";\n    if ( exists $fth->field->{'FTId'} ) {\n        $ftid = @{$fth->field->{'FTId'}}[0]. '.';\n    }\n\n    my $key =substr($fth->key,0,8);\n    my $loc = $fth->loc;\n    if ( $loc =~ /(\\?|\\d+|\\>\\d+|<\\d+)?\\.\\.(\\?|\\d+|<\\d+|>\\d+)?/ ) {\n        $start = $1 if defined $1;\n        $end = $2 if defined $2;\n\n        # to_FTString only returns one value when start == end, #JB955\n        # so if no match is found, assume it is both start and end #JB955\n    } elsif ( $loc =~ /join\\((\\d+)((?:,\\d+)+)?\\)/) {\n        my @y = ($1);\n        if ( defined( my $m = $2) ) {\n            $m =~ s/^\\,//;\n            push @y, split(/,/,$m);\n        }\n        for my $x ( @y ) {\n            $self->_write_line_swissprot_regex(\n                                               sprintf(\"FT   %-8s %6s %6s       \",\n                                                       $key,\n                                                       $x ,$x),\n                                               \"FT                                \",\n                                               $desc.'.','\\s+|$',$LINE_LENGTH);\n        }\n        return;\n    } else {\n        $start = $end = $fth->loc;\n    }\n    if ($desc) {\n        $self->_write_line_swissprot_regex(sprintf(\"FT   %-8s %6s %6s       \",\n                                                   $key,\n                                                   $start ,$end),\n                                           \"FT                                \",\n                                           $desc. '.', '\\s+|$', $LINE_LENGTH);\n    } else {                    #HELIX and STRAND do not have descriptions\n        $self->_write_line_swissprot_regex(sprintf(\"FT   %-8s %6s %6s\",\n                                                   $key,\n                                                   $start ,$end),\n                                           \"FT                         \",\n                                           ' ', '\\s+|$', $LINE_LENGTH);\n    }\n\n\n    if ($ftid) {\n        $self->_write_line_swissprot_regex(\"FT                                \",\n                                           \"FT                                \",\n                                           \"/FTId=$ftid\",'.|$',$LINE_LENGTH);\n\n    }\n\n}\n#'\n\n=head2 _read_swissprot_References\n\n Title   : _read_swissprot_References\n Usage   :\n Function: Reads references from swissprot format. Internal function really\n Example :\n Returns :\n Args    :"},"kind":12,"range":{"start":{"line":1021,"character":0},"end":{"line":1094,"character":9999}},"line":1021},{"line":1036,"name":"Bio","containerName":"Annotation::Reference","kind":12},{"line":1111,"range":{"end":{"character":9999,"line":1238},"start":{"character":0,"line":1111}},"kind":12,"signature":{"documentation":"1;\n# $Id: swiss.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::swiss\n#\n# Copyright Elia Stupka\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::swiss - Swissprot sequence input/output stream\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system:\n\n    use Bio::SeqIO;\n\n    $stream = Bio::SeqIO->new(-file => $filename,\n                              -format => 'swiss');\n\n    while ( my $seq = $stream->next_seq() ) {\n       # do something with $seq\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from Swiss-Pprot flat\nfile databases.\n\nThere is a lot of flexibility here about how to dump things which needs\nto be documented.\n\n=head2 GN (Gene name) line management details\n\nA Uniprot/Swiss-Prot entry holds information on one protein\nsequence. If that sequence is identical across genes and species, they\nare all merged into one entry. This creates complex needs for several\nannotation fields in swiss-prot format.\n\nThe latest syntax for GN line is described in the user manual:\n\n  http://www.expasy.ch/sprot/userman.html#GN_line\n\nEach of the possibly multiple genes in an entry can have Name,\nSynonyms (only if there is a name), OrderedLocusNames (names from\ngenomic sequences) and ORFNames (temporary or cosmid names). \"Name\"\nhere really means \"symbol\". This complexity is now dealt with the\nfollowing way:\n\nA new Bio::AnnotationI class was created in order to store the\ndata in tag-value pairs.  This class (Bio::Annotation::TagTree)\nis stored in the Bio::Annotation::Collection object and is\naccessed like all other annotations. The tag name is 'gene_name'.\n\nThere is a single Bio::Annotation::TagTree per sequence record, which\ncorresponds to the original class that stored this data\n(Bio::Annotation::StructuredValue).  Depending on how we progress\nthis may change to represent each group of gene names.\n\nFor now, to access the gene name tree annotation, one uses the below method:\n\n   my ($gene) = $seq->annotation->get_Annotations('gene_name');\n\nIf you are only interested in displaying the values, value() returns a\nstring with similar formatting.\n\nThere are several ways to get directly at the information you want if you\nknow the element (tag) for the data.  For gene names all data is stored with\nthe element-tag pairs:\n\n  \"element1=tag1, tag2, tag3; element2=tag4, tag5;\"\n\nThis normally means the element will be 'Name', 'Synonyms', etc. and the\ngene names the values.  Using findval(), you can do the following:\n\n  # grab a flattened list of all gene names\n  my @names = $ann->findval('Name');\n\n  # or iterated through the nodes and grab the name for each group\n  for my $node ($ann->findnode('gene_name')) {\n     my @names = $node->findval('Name');\n  }\n\nThe current method for parsing gene name data (and reconstructing gene name\noutput) is very generic. This is somewhat preemptive if, for instance, UniProt\ndecides to update and add another element name to the current ones using the\nsame formatting layout. Under those circumstances, one can iterate through the\ntag tree in a safe way and retrieve all node data like so.\n\n  # retrieve the gene name nodes (groups like names, synonyms, etc).\n  for my $ann ($seq->annotation->get_Annotations('gene_name')) {\n\n      # each gene name group\n      for my $node ($ann->findnode('gene_name')) {\n          print \"Gene name:\\n\";\n\n          # each gene name node (tag => value pair)\n          for my $n ($node->children) {\n              print \"\\t\".$n->element.\": \".$n->children.\"\\n\";\n          }\n      }\n  }\n\nFor more uses see Bio::Annotation::TagTree.\n\nSince Uniprot/Swiss-Prot format have been around for quite some time, the\nparser is also able to read in the older GN line syntax where genes\nare separated by AND and various symbols by OR. The first symbol is\ntaken to be the 'Name' and the remaining ones are stored as 'Synonyms'.\n\n=head2 Optional functions\n\n=over 3\n\n* _show_dna()\n\n(output only) shows the dna or not\n\n* _post_sort()\n\n(output only) provides a sorting func which is applied to the FTHelpers\nbefore printing\n\n* _id_generation_func()\n\nThis is function which is called as\n\n   print \"ID   \", $func($seq), \"\\n\";\n\nTo generate the ID line. If it is not there, it generates a sensible ID\nline using a number of tools.\n\nIf you want to output annotations in Swissprot format they need to be\nstored in a Bio::Annotation::Collection object which is accessible\nthrough the Bio::SeqI interface method L<annotation()|annotation>.\n\nThe following are the names of the keys which are polled from a\nL<Bio::Annotation::Collection> object.\n\n reference   - Should contain Bio::Annotation::Reference objects\n comment     - Should contain Bio::Annotation::Comment objects\n dblink      - Should contain Bio::Annotation::DBLink objects\n gene_name   - Should contain Bio::Annotation::SimpleValue object\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions,\npreferably to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Elia Stupka\n\nEmail elia@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::swiss;\nuse vars qw(@Unknown_names @Unknown_genus);\nuse strict;\nuse Bio::SeqIO::FTHelper;\nuse Bio::SeqFeature::Generic;\nuse Bio::Species;\nuse Bio::Tools::SeqStats;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::Comment;\nuse Bio::Annotation::Reference;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::TagTree;\n\nuse base qw(Bio::SeqIO);\n\nour $LINE_LENGTH = 76;\n\n# this is for doing species name parsing\n@Unknown_names=('other', 'unidentified',\n                'unknown organism', 'not specified',\n                'not shown', 'Unspecified', 'Unknown',\n                'None', 'unclassified', 'unidentified organism',\n                'not supplied'\n               );\n# dictionary of synonyms for taxid 32644\n# all above can be part of valid species name\n@Unknown_genus = qw(unknown unclassified uncultured unidentified);\n\n# if there are any other gene name tags, they are added to the end\nour @GENE_NAME_ORDER = qw(Name Synonyms OrderedLocusNames ORFNames);\n\nsub _initialize {\n    my($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    # hash for functions for decoding keys.\n    $self->{'_func_ftunit_hash'} = {};\n    # sets this to one by default. People can change it\n    $self->_show_dna(1);\n    if ( ! defined $self->sequence_factory ) {\n        $self->sequence_factory(Bio::Seq::SeqFactory->new\n                                (-verbose => $self->verbose(),\n                                 -type => 'Bio::Seq::RichSeq'));\n    }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    :\n\n\nsub next_seq {\n    my ($self,@args) = @_;\n    my ($pseq,$c,$line,$name,$desc,$acc,$seqc,$mol,$div, $sptr,$seq_div,\n        $date,$comment,@date_arr);\n    my $genename = \"\";\n    my ($annotation, %params, @features) = ( Bio::Annotation::Collection->new());\n\n    local $_;\n\n    1 while defined($_ = $self->_readline) && /^\\s+$/;\n    return unless defined $_ && /^ID\\s/;\n\n    # fixed to allow _DIVISION to be optional for bug #946\n    # see bug report for more information\n    #\n    # 9/6/06 Note: Swiss/TrEMBL sequences have no division acc. to UniProt\n    # release notes; this is fixed to simplify the regex parsing\n    # STANDARD (SwissProt) and PRELIMINARY (TrEMBL) added to namespace()\n    unless(  m{^\n               ID              \\s+     #\n               (\\S+)           \\s+     #  $1  entryname\n               ([^\\s;]+);      \\s+     #  $2  DataClass\n               (?:PRT;)?       \\s+     #  Molecule Type (optional)\n               [0-9]+[ ]AA     \\.      #  Sequencelength (capture?)\n               $\n           }ox ) {\n            # I couldn't find any new current UniProt sequences\n            # that matched this format:\n            # || m/^ID\\s+(\\S+)\\s+(_([^\\s_]+))? /ox ) {\n        $self->throw(\"swissprot stream with no ID. Not swissprot in my book\");\n    }\n    ($name, $seq_div) = ($1, $2);\n    $params{'-namespace'} =\n        ($seq_div eq 'Reviewed'   || $seq_div eq 'STANDARD')     ? 'Swiss-Prot' :\n        ($seq_div eq 'Unreviewed' || $seq_div eq 'PRELIMINARY')  ? 'TrEMBL'     :\n         $seq_div;\n    # we shouldn't be setting the division, but for now...\n    my ($junk, $division) = split q(_), $name;\n    $params{'-division'} = $division;\n    $params{'-alphabet'} = 'protein';\n    # this is important to have the id for display in e.g. FTHelper, otherwise\n    # you won't know which entry caused an error\n    $params{'-display_id'} = $name;\n\n    BEFORE_FEATURE_TABLE :\n          while ( defined($_ = $self->_readline) ) {\n              # Exit at start of Feature table and at the sequence at the\n              # latest HL 05/11/2000\n              last if( /^(FT|SQ)/ );\n\n              # Description line(s)\n              if (/^DE\\s+(\\S.*\\S)/) {\n                  $desc .= $desc ? \" $1\" : $1;\n              }\n              #Gene name\n              elsif (/^GN\\s+(.*)/) {\n                  $genename .= \" \" if $genename;\n                  $genename .= $1;\n              }\n              #accession number(s)\n              elsif ( /^AC\\s+(.+)/) {\n                  my @accs = split(/[; ]+/, $1); # allow space in addition\n                  $params{'-accession_number'} = shift @accs\n                      unless defined $params{'-accession_number'};\n                  push @{$params{'-secondary_accessions'}}, @accs;\n              }\n              #date and sequence version\n              elsif ( /^DT\\s+(.*)/ ) {\n                  my $line = $1;\n                  my ($date, $version) = split(' ', $line, 2);\n                  $date =~ tr/,//d; # remove comma if new version\n                  if ($version =~ /\\(Rel\\. (\\d+), Last sequence update\\)/ || # old\n                      /sequence version (\\d+)/) { #new\n                      my $update = Bio::Annotation::SimpleValue->new\n                          (-tagname    => 'seq_update',\n                           -value      => $1\n                          );\n                      $annotation->add_Annotation($update);\n                  } elsif ($version =~ /\\(Rel\\. (\\d+), Last annotation update\\)/ || #old\n                           /entry version (\\d+)/) { #new\n                      $params{'-version'} = $1;\n                  }\n                  push @{$params{'-dates'}}, $date;\n              }\n              # Evidence level\n              elsif ( /^PE\\s+(.*)/ ) {\n                  my $line = $1;\n                  $line =~ s/;\\s*//; # trim trailing semicolon and any spaces at the end of the line\n                  my $evidence = Bio::Annotation::SimpleValue->new\n                      (-tagname   => 'evidence',\n                       -value     => $line\n                      );\n                  $annotation->add_Annotation($evidence);\n              }\n              # Organism name and phylogenetic information\n              elsif (/^O[SCG]/) {\n                  my $species = $self->_read_swissprot_Species($_);\n                  $params{'-species'}= $species;\n                  # now we are one line ahead -- so continue without reading the next\n                  # line   HL 05/11/2000\n              }\n              # References\n              elsif (/^R/) {\n                  my $refs = $self->_read_swissprot_References($_);\n                  foreach my $r (@$refs) {\n                      $annotation->add_Annotation('reference',$r);\n                  }\n              }\n              # Comments\n              elsif (/^CC\\s{3}(.*)/) {\n                  $comment .= $1;\n                  $comment .= \"\\n\";\n                  while (defined ($_ = $self->_readline) && /^CC\\s{3}(.*)/ ) {\n                      $comment .= $1 . \"\\n\";\n                  }\n\n                  # note: don't try to process comments here -- they may contain\n                  # structure. LP 07/30/2000\n\n                  my $commobj = Bio::Annotation::Comment->new(-tagname => 'comment',\n                                                              -text    => $comment);\n                  $annotation->add_Annotation('comment',$commobj);\n                  $comment = \"\";\n                  $self->_pushback($_);\n              }\n              #DBLinks\n              # old regexp\n              # /^DR\\s+(\\S+)\\;\\s+(\\S+)\\;\\s+(\\S+)[\\;\\.](.*)$/) {\n              # new regexp from Andreas Kahari  bug #1584\n              elsif (/^DR\\s+(\\S+)\\;\\s+(\\S+)\\;\\s+([^;]+)[\\;\\.](.*)$/) {\n                  my ($database,$primaryid,$optional,$comment) = ($1,$2,$3,$4);\n\n                  # drop leading and training spaces and trailing .\n                  $comment =~ s/\\.\\s*$//;\n                  $comment =~ s/^\\s+//;\n\n                  my $dblinkobj =  Bio::Annotation::DBLink->new\n                      (-database    => $database,\n                       -primary_id  => $primaryid,\n                       -optional_id => $optional,\n                       -comment     => $comment,\n                       -tagname     => 'dblink',\n                      );\n\n                  $annotation->add_Annotation('dblink',$dblinkobj);\n              }\n              #keywords\n              elsif ( /^KW\\s+(.*)$/ ) {\n                  my @kw = split(/\\s*\\;\\s*/,$1);\n                  defined $kw[-1] && $kw[-1] =~ s/\\.$//;\n                  push @{$params{'-keywords'}}, @kw;\n              }\n          }\n    # process and parse the gene name line if there was one (note: we\n    # can't do this above b/c GN may be multi-line and we can't\n    # unequivocally determine whether we've seen the last GN line in\n    # the new format)\n    if ($genename) {\n        my @stags;\n        if ($genename =~ /\\w=\\w/) {\n            # new format (e.g., Name=RCHY1; Synonyms=ZNF363, CHIMP)\n            for my $n (split(m{\\s+and\\s+},$genename)) {\n                my @genenames;\n                for my $section (split(m{\\s*;\\s*},$n)) {\n                    my ($tag, $rest) = split(\"=\",$section);\n                    $rest ||= '';\n                    for my $val (split(m{\\s*,\\s*},$rest)) {\n                        push @genenames, [$tag => $val];\n                    }\n                }\n                push @stags, ['gene_name' => \\@genenames];\n            }\n        } else {\n            # old format\n            for my $section (split(/ AND /, $genename)) {\n                my @genenames;\n                $section =~ s/[\\(\\)\\.]//g;\n                my @names = split(m{\\s+OR\\s+}, $section);\n                push @genenames, ['Name' => shift @names];\n                push @genenames, map {['Synonyms' => $_]} @names;\n                push @stags, ['gene_name' => \\@genenames]            \n            }\n        } #use Data::Dumper; print Dumper $gn, $genename;# exit;\n        my $gn = Bio::Annotation::TagTree->new(-tagname => 'gene_name',\n                                               -value => ['gene_names' => \\@stags]);\n        $annotation->add_Annotation('gene_name', $gn);\n    }\n\n    FEATURE_TABLE :\n          # if there is no feature table, or if we've got beyond, exit loop or don't\n          # even enter    HL 05/11/2000\n          while (defined $_ && /^FT/ ) {\n              my $ftunit = $self->_read_FTHelper_swissprot($_);\n\n              # process ftunit\n              # when parsing of the line fails we get undef returned\n              if ($ftunit) {\n                  push(@features,\n                       $ftunit->_generic_seqfeature($self->location_factory(),\n                                                    $params{'-seqid'}, \"SwissProt\"));\n              } else {\n                  $self->warn(\"failed to parse feature table line for seq \" .\n                              $params{'-display_id'}. \"\\n$_\");\n              }\n              $_ = $self->_readline;\n          }\n    while ( defined($_) && ! /^SQ/ ) {\n        $_ = $self->_readline;\n    }\n    $seqc = \"\";\n    while ( defined ($_ = $self->_readline) ) {\n        last if m{^//};\n        s/[^A-Za-z]//g;\n        $seqc .= uc($_);\n    }\n\n    my $seq=  $self->sequence_factory->create\n        (-verbose  => $self->verbose,\n         %params,\n         -seq      => $seqc,\n         -desc     => $desc,\n         -features => \\@features,\n         -annotation => $annotation,\n        );\n\n    # The annotation doesn't get added by the contructor\n    $seq->annotation($annotation);\n\n    return $seq;\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq($seq)\n Function: writes the $seq object (must be seq) to the stream\n Returns : 1 for success and 0 for error\n Args    : array of 1 to n Bio::SeqI objects\n\n\n\nsub write_seq {\n    my ($self,@seqs) = @_;\n    foreach my $seq ( @seqs ) {\n        $self->throw(\"Attempting to write with no seq!\") unless defined $seq;\n\n        if ( ! ref $seq || ! $seq->isa('Bio::SeqI') ) {\n            $self->warn(\" $seq is not a SeqI compliant module. Attempting to dump, but may fail!\");\n        }\n\n        my $i;\n        my $str = $seq->seq;\n\n        my $div;\n        my $ns = ($seq->can('namespace')) && $seq->namespace();\n        my $len = $seq->length();\n\n        if ( !$seq->can('division') || ! defined ($div = $seq->division()) ) {\n            $div = 'UNK';\n        }\n\n        # namespace dictates database, takes precedent over division. Sorry!\n        if (defined($ns)) {\n            $div = ($ns eq 'Swiss-Prot') ? 'Reviewed'    :\n                ($ns eq 'TrEMBL')     ? 'Unreviewed' :\n                    $ns;\n        } else {\n            $ns = 'Swiss-Prot';\n            # division not reset; acts as fallback\n        }\n\n        $self->warn(\"No whitespace allowed in SWISS-PROT display id [\". $seq->display_id. \"]\")\n            if $seq->display_id =~ /\\s/;\n\n        my $temp_line;\n        if ( $self->_id_generation_func ) {\n            $temp_line = &{$self->_id_generation_func}($seq);\n        } else {\n            #$temp_line = sprintf (\"%10s     STANDARD;      %3s;   %d AA.\",\n            #            $seq->primary_id().\"_\".$div,$mol,$len);\n            # Reconstructing the ID relies heavily upon the input source having\n            # been in a format that is parsed as this routine expects it -- that is,\n            # by this module itself. This is bad, I think, and immediately breaks\n            # if e.g. the Bio::DB::GenPept module is used as input.\n            # Hence, switch to display_id(); _every_ sequence is supposed to have\n            # this. HL 2000/09/03\n            # Changed to reflect ID line changes in UniProt\n            # Oct 2006 - removal of molecule type - see bug 2134\n            $temp_line = sprintf (\"%-24s%-12s%9d AA.\",\n                                  $seq->display_id(), $div.';', $len);\n        }\n\n        $self->_print( \"ID   $temp_line\\n\");\n\n        # if there, write the accession line\n        local($^W) = 0;         # supressing warnings about uninitialized fields\n\n        if ( $self->_ac_generation_func ) {\n            $temp_line = &{$self->_ac_generation_func}($seq);\n            $self->_print( \"AC   $temp_line\\n\");\n        }\n        elsif ($seq->can('accession_number') ) {\n            my $ac_line = $seq->accession_number;\n            if ($seq->can('get_secondary_accessions') ) {\n                foreach my $sacc ($seq->get_secondary_accessions) {\n                    $ac_line .= \"; \". $sacc;;\n                }\n                $ac_line .= \";\";\n            }\n\n            $self->_write_line_swissprot_regex(\"AC   \",\"AC   \",$ac_line,\n                                               \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n        }\n        # otherwise - cannot print <sigh>\n\n\n        # Date lines and sequence versions (changed 6/15/2006)\n        # This is rebuilt from scratch using the current SwissProt/UniProt format\n        if ( $seq->can('get_dates') ) {\n            my @dates =  $seq->get_dates();\n            my $ct = 1;\n            my $seq_version = $seq->version;\n            my ($update_version) = $seq->annotation->get_Annotations(\"seq_update\");\n            foreach my $dt (@dates) {\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.', integrated into UniProtKB/'.$ns.'.',\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 1;\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.\", sequence version \".$update_version->display_text.'.',\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 2;\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.\", entry version $seq_version.\",\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 3;\n                $ct++;\n            }\n        }\n\n        #Definition lines\n        $self->_write_line_swissprot_regex(\"DE   \",\"DE   \",$seq->desc(),\"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n\n        #Gene name; print out new format\n        foreach my $gene ( my @genes = $seq->annotation->get_Annotations('gene_name') ) {\n            # gene is a Bio::Annotation::TagTree;\n            my @genelines;\n            for my $node ($gene->findnode('gene_name')) {\n                # check for Name and Synonym first, then the rest get tagged on\n                my $geneline = \"GN   \";\n                my %genedata = $node->hash;\n                for my $tag (@GENE_NAME_ORDER) {\n                    if (exists $genedata{$tag}) {\n                        $geneline .= (ref $genedata{$tag} eq 'ARRAY') ?\n                            \"$tag=\".join(', ',@{$genedata{$tag}}).\"; \" :\n                            \"$tag=$genedata{$tag}; \";\n                        delete $genedata{$tag};\n                    }\n                }\n                # add rest\n                for my $tag (sort keys %genedata) {\n                    $geneline .= (ref $genedata{$tag} eq 'ARRAY') ?\n                        \"$tag=\".join(', ',@{$genedata{$tag}}).\"; \" :\n                        \"$tag=$genedata{$tag}; \";\n                    delete $genedata{$tag};\n                }\n                push @genelines, \"$geneline\\n\";\n            }\n            $self->_print(join(\"GN   and\\n\",@genelines));\n        }\n\n        # Organism lines\n        if ($seq->can('species') && (my $spec = $seq->species)) {\n            my @class = $spec->classification();\n            shift(@class);\n            my $species = $spec->species;\n            my $genus = $spec->genus;\n            my $OS = $spec->scientific_name;\n            if ($class[-1] =~ /viruses/i) {\n                $OS = $species;\n                $OS .=  \" \". $spec->sub_species if $spec->sub_species;\n            }\n            foreach (($spec->variant, $spec->common_name)) {\n                $OS .= \" ($_)\" if $_;\n            }\n            $self->_print( \"OS   $OS.\\n\");\n            my $OC = join('; ', reverse(@class)) .'.';\n            $self->_write_line_swissprot_regex(\"OC   \",\"OC   \",$OC,\"\\; \\|\\$\",$LINE_LENGTH);\n            if ($spec->organelle) {\n                $self->_write_line_swissprot_regex(\"OG   \",\"OG   \",$spec->organelle,\"\\; \\|\\$\",$LINE_LENGTH);\n            }\n            if ($spec->ncbi_taxid) {\n                $self->_print(\"OX   NCBI_TaxID=\".$spec->ncbi_taxid.\";\\n\");\n            }\n        }\n\n        # Reference lines\n        my $t = 1;\n        foreach my $ref ( $seq->annotation->get_Annotations('reference') ) {\n            $self->_print( \"RN   [$t]\\n\");\n            # changed by lorenz 08/03/00\n            # j.gilbert and h.lapp agreed that the rp line in swissprot seems\n            # more like a comment than a parseable value, so print it as is\n            if ($ref->rp) {\n                $self->_write_line_swissprot_regex(\"RP   \",\"RP   \",$ref->rp,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            }\n            if ($ref->comment) {\n                $self->_write_line_swissprot_regex(\"RC   \",\"RC   \",$ref->comment,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            }\n            if ($ref->medline or $ref->pubmed or $ref->doi) {\n                # new RX format in swissprot LP 09/17/00\n                # RX line can now have a DOI, Heikki 13 Feb 2008\n\n                my $line;\n                $line .= \"MEDLINE=\". $ref->medline. '; ' if $ref->medline;\n                $line .= \"PubMed=\". $ref->pubmed. '; ' if $ref->pubmed;\n                $line .= \"DOI=\". $ref->doi. '; ' if $ref->doi;\n                chop $line;\n\n                $self->_write_line_swissprot_regex(\"RX   \",\"RX   \",\n                                                   $line,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n\n            }\n            my $author = $ref->authors .';' if($ref->authors);\n            my $title = $ref->title .';' if( $ref->title);\n            my $rg = $ref->rg . ';' if $ref->rg;\n            $author =~ s/([\\w\\.]) (\\w)/$1#$2/g;  # add word wrap protection char '#'\n\n            $self->_write_line_swissprot_regex(\"RG   \",\"RG   \",$rg,\"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $rg;\n            $self->_write_line_swissprot_regex(\"RA   \",\"RA   \",$author,\"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $author;\n            $self->_write_line_swissprot_regex(\"RT   \",\"RT   \",$title,'[\\s\\-]+|$',$LINE_LENGTH) if $title;\n            $self->_write_line_swissprot_regex(\"RL   \",\"RL   \",$ref->location,\"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            $t++;\n        }\n\n        # Comment lines\n\n        foreach my $comment ( $seq->annotation->get_Annotations('comment') ) {\n            foreach my $cline (split (\"\\n\", $comment->text)) {\n                while (length $cline > 74) {\n                    $self->_print(\"CC   \",(substr $cline,0,74),\"\\n\");\n                    $cline = substr $cline,74;\n                }\n                $self->_print(\"CC   \",$cline,\"\\n\");\n            }\n        }\n\n        # Database xref lines\n\n        foreach my $dblink ( $seq->annotation->get_Annotations('dblink') ) {\n            my ($primary_id) = $dblink->primary_id;\n\t\n            if (defined($dblink->comment) && ($dblink->comment) ) {\n                $self->_print(\"DR   \",$dblink->database,\"; \",$primary_id,\"; \",\n                              $dblink->optional_id,\"; \",$dblink->comment,\".\\n\");\n            } elsif ($dblink->optional_id) {\n                $self->_print(\"DR   \",$dblink->database,\"; \",\n                              $primary_id,\"; \",\n                              $dblink->optional_id,\".\\n\");\n            } else {\n                $self->_print(\"DR   \",$dblink->database,\n                              \"; \",$primary_id,\"; \",\"-.\\n\");\n            }\n        }\n\n        # Evidence lines\n\n        foreach my $evidence ( $seq->annotation->get_Annotations('evidence') ) {\n            $self->_print(\"PE   \",$evidence->value,\";\\n\");\n        }\n\n        # if there, write the kw line\n        {\n            my $kw;\n            if ( my $func = $self->_kw_generation_func ) {\n                $kw = &{$func}($seq);\n            } elsif ( $seq->can('keywords') ) {\n                $kw = $seq->keywords;\n                if ( ref($kw) =~ /ARRAY/i ) {\n                    $kw = join(\"; \", @$kw);\n                }\n                $kw .= '.' if $kw and $kw !~ /\\.$/ ;\n            }\n            $kw =~ s/([\\w\\.]) (\\w)/$1#$2/g;  # add word wrap protection char '#'\n            $self->_write_line_swissprot_regex(\"KW   \",\"KW   \",\n                                               $kw, \"\\\\s\\+\\|\\$\",$LINE_LENGTH)\n                if $kw;\n        }\n\n        #Check if there is seqfeatures before printing the FT line\n        my @feats = $seq->can('top_SeqFeatures') ? $seq->top_SeqFeatures : ();\n        if ($feats[0]) {\n            if ( defined $self->_post_sort ) {\n\n                # we need to read things into an array. Process. Sort them. Print 'em\n\n                my $post_sort_func = $self->_post_sort();\n                my @fth;\n\n                foreach my $sf ( @feats ) {\n                    push(@fth,Bio::SeqIO::FTHelper::from_SeqFeature($sf,$seq));\n                }\n                @fth = sort { &$post_sort_func($a,$b) } @fth;\n\n                foreach my $fth ( @fth ) {\n                    $self->_print_swissprot_FTHelper($fth);\n                }\n            } else {\n                # not post sorted. And so we can print as we get them.\n                # lower memory load...\n\n                foreach my $sf ( @feats ) {\n                    my @fth = Bio::SeqIO::FTHelper::from_SeqFeature($sf,$seq);\n                    foreach my $fth ( @fth ) {\n                        if ( ! $fth->isa('Bio::SeqIO::FTHelper') ) {\n                            $sf->throw(\"Cannot process FTHelper... $fth\");\n                        }\n                        $self->_print_swissprot_FTHelper($fth);\n                    }\n                }\n            }\n\n            if ( $self->_show_dna() == 0 ) {\n                return;\n            }\n        }\n        # finished printing features.\n\n        # molecular weight\n        my $mw = ${Bio::Tools::SeqStats->get_mol_wt($seq->primary_seq)}[0];\n        # checksum\n        # was crc32 checksum, changed it to crc64\n        my $crc64 = $self->_crc64(\\$str);\n        $self->_print( sprintf(\"SQ   SEQUENCE  %4d AA;  %d MW;  %16s CRC64;\\n\",\n                               $len,$mw,$crc64));\n        $self->_print( \"    \");\n        my $linepos;\n        for ($i = 0; $i < length($str); $i += 10) {\n            $self->_print( \" \", substr($str,$i,10));\n            $linepos += 11;\n            if ( ($i+10)%60 == 0 && (($i+10) < length($str))) {\n                $self->_print( \"\\n    \");\n            }\n        }\n        $self->_print( \"\\n//\\n\");\n\n        $self->flush if $self->_flush_on_write && defined $self->_fh;\n        return 1;\n    }\n}\n\n# Thanks to James Gilbert for the following two. LP 08/01/2000\n\n=head2 _generateCRCTable\n\n Title   : _generateCRCTable\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _generateCRCTable {\n  # 10001000001010010010001110000100\n  # 32\n    my $poly = 0xEDB88320;\n    my ($self) = shift;\n\n    $self->{'_crcTable'} = [];\n    foreach my $i (0..255) {\n        my $crc = $i;\n        for (my $j=8; $j > 0; $j--) {\n            if ($crc & 1) {\n                $crc = ($crc >> 1) ^ $poly;\n            } else {\n                $crc >>= 1;\n            }\n        }\n        ${$self->{'_crcTable'}}[$i] = $crc;\n    }\n}\n\n\n=head2 _crc32\n\n Title   : _crc32\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _crc32 {\n    my( $self, $str ) = @_;\n\n    $self->throw(\"Argument to crc32() must be ref to scalar\")\n        unless ref($str) eq 'SCALAR';\n\n    $self->_generateCRCTable() unless exists $self->{'_crcTable'};\n\n    my $len = length($$str);\n\n    my $crc = 0xFFFFFFFF;\n    for (my $i = 0; $i < $len; $i++) {\n        # Get upper case value of each letter\n        my $int = ord uc substr $$str, $i, 1;\n        $crc = (($crc >> 8) & 0x00FFFFFF) ^\n            ${$self->{'_crcTable'}}[ ($crc ^ $int) & 0xFF ];\n    }\n    return $crc;\n}\n\n=head2 _crc64\n\n Title   : _crc64\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _crc64{\n    my ($self, $sequence) = @_;\n    my $POLY64REVh = 0xd8000000;\n    my @CRCTableh = 256;\n    my @CRCTablel = 256;\n    my $initialized;\n\n    my $seq = $$sequence;\n\n    my $crcl = 0;\n    my $crch = 0;\n    if (!$initialized) {\n        $initialized = 1;\n        for (my $i=0; $i<256; $i++) {\n            my $partl = $i;\n            my $parth = 0;\n            for (my $j=0; $j<8; $j++) {\n                my $rflag = $partl & 1;\n                $partl >>= 1;\n                $partl |= (1 << 31) if $parth & 1;\n                $parth >>= 1;\n                $parth ^= $POLY64REVh if $rflag;\n            }\n            $CRCTableh[$i] = $parth;\n            $CRCTablel[$i] = $partl;\n        }\n    }\n\n    foreach (split '', $seq) {\n        my $shr = ($crch & 0xFF) << 24;\n        my $temp1h = $crch >> 8;\n        my $temp1l = ($crcl >> 8) | $shr;\n        my $tableindex = ($crcl ^ (unpack \"C\", $_)) & 0xFF;\n        $crch = $temp1h ^ $CRCTableh[$tableindex];\n        $crcl = $temp1l ^ $CRCTablel[$tableindex];\n    }\n    my $crc64 = sprintf(\"%08X%08X\", $crch, $crcl);\n    return $crc64;\n}\n\n=head2 _print_swissprot_FTHelper\n\n Title   : _print_swissprot_FTHelper\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _print_swissprot_FTHelper {\n    my ($self,$fth,$always_quote) = @_;\n    $always_quote ||= 0;\n    my ($start,$end) = ('?', '?');\n\n    if ( ! ref $fth || ! $fth->isa('Bio::SeqIO::FTHelper') ) {\n        $fth->warn(\"$fth is not a FTHelper class. \".\n                   \"Attempting to print, but there could be tears!\");\n    }\n    my $desc = \"\";\n\n    for my $tag ( qw(description gene note product) ) {\n        if ( exists $fth->field->{$tag} ) {\n            $desc = @{$fth->field->{$tag}}[0].\".\";\n            last;\n        }\n    }\n    $desc =~ s/\\.$//;\n\n    my $ftid = \"\";\n    if ( exists $fth->field->{'FTId'} ) {\n        $ftid = @{$fth->field->{'FTId'}}[0]. '.';\n    }\n\n    my $key =substr($fth->key,0,8);\n    my $loc = $fth->loc;\n    if ( $loc =~ /(\\?|\\d+|\\>\\d+|<\\d+)?\\.\\.(\\?|\\d+|<\\d+|>\\d+)?/ ) {\n        $start = $1 if defined $1;\n        $end = $2 if defined $2;\n\n        # to_FTString only returns one value when start == end, #JB955\n        # so if no match is found, assume it is both start and end #JB955\n    } elsif ( $loc =~ /join\\((\\d+)((?:,\\d+)+)?\\)/) {\n        my @y = ($1);\n        if ( defined( my $m = $2) ) {\n            $m =~ s/^\\,//;\n            push @y, split(/,/,$m);\n        }\n        for my $x ( @y ) {\n            $self->_write_line_swissprot_regex(\n                                               sprintf(\"FT   %-8s %6s %6s       \",\n                                                       $key,\n                                                       $x ,$x),\n                                               \"FT                                \",\n                                               $desc.'.','\\s+|$',$LINE_LENGTH);\n        }\n        return;\n    } else {\n        $start = $end = $fth->loc;\n    }\n    if ($desc) {\n        $self->_write_line_swissprot_regex(sprintf(\"FT   %-8s %6s %6s       \",\n                                                   $key,\n                                                   $start ,$end),\n                                           \"FT                                \",\n                                           $desc. '.', '\\s+|$', $LINE_LENGTH);\n    } else {                    #HELIX and STRAND do not have descriptions\n        $self->_write_line_swissprot_regex(sprintf(\"FT   %-8s %6s %6s\",\n                                                   $key,\n                                                   $start ,$end),\n                                           \"FT                         \",\n                                           ' ', '\\s+|$', $LINE_LENGTH);\n    }\n\n\n    if ($ftid) {\n        $self->_write_line_swissprot_regex(\"FT                                \",\n                                           \"FT                                \",\n                                           \"/FTId=$ftid\",'.|$',$LINE_LENGTH);\n\n    }\n\n}\n#'\n\n=head2 _read_swissprot_References\n\n Title   : _read_swissprot_References\n Usage   :\n Function: Reads references from swissprot format. Internal function really\n Example :\n Returns :\n Args    :\n\n\n\nsub _read_swissprot_References{\n    my ($self,$line) = @_;\n    my ($b1, $b2, $rp, $rg, $title, $loc, $au, $med, $com, $pubmed, $doi);\n    my @refs;\n    local $_ = $line;\n    while ( defined $_ ) {\n        if ( /^[^R]/ || /^RN/ ) {\n            if ( $rp ) {\n                $rg =~ s/;\\s*$//g if defined($rg);\n                if (defined($au)) {\n                    $au =~ s/;\\s*$//;\n                } else {\n                    $au = $rg;\n                }\n                $title =~ s/;\\s*$//g if defined($title);\n                push @refs, Bio::Annotation::Reference->new\n                    (-title   => $title,\n                     -start   => $b1,\n                     -end     => $b2,\n                     -authors => $au,\n                     -location=> $loc,\n                     -medline => $med,\n                     -pubmed  => $pubmed,\n                     -doi     => $doi,\n                     -comment => $com,\n                     -rp      => $rp,\n                     -rg      => $rg,\n                     -tagname => 'reference',\n                    );\n                # reset state for the next reference\n                $rp = '';\n            }\n            if (index($_,'R') != 0) {\n                $self->_pushback($_); # want this line to go back on the list\n                last;           # may be the safest exit point HL 05/11/2000\n            }\n            # don't forget to reset the state for the next reference\n            $b1 = $b2 = $rg = $med = $com = $pubmed = $doi = undef;\n            $title = $loc = $au = undef;\n        } elsif ( /^RP\\s{3}(.+? OF (\\d+)-(\\d+).*)/) {\n            $rp  .= $1;\n            $b1   = $2;\n            $b2   = $3;\n        } elsif ( /^RP\\s{3}(.*)/) {\n            if ($rp) {\n                $rp .= \" \".$1;\n            } else {\n                $rp = $1;\n            }\n        } elsif (/^RX\\s{3}(.*)/) { # each reference can have only one RX line\n            my $line = $1;\n            $med = $1 if $line =~ /MEDLINE=(\\d+);/;\n            $pubmed = $1 if $line =~ /PubMed=(\\d+);/;\n            $doi = $1 if $line =~ /DOI=(.+);/;\n        } elsif ( /^RA\\s{3}(.*)/ ) {\n            $au .= $au ? \" $1\" : $1;\n        } elsif ( /^RG\\s{3}(.*)/ ) {\n            $rg .= $rg ? \" $1\" : $1;\n        } elsif ( /^RT\\s{3}(.*)/ ) {\n            if ($title) {\n                my $tline = $1;\n                $title .= ($title =~ /[\\w;,:\\?!]$/) ? \" $tline\" : $tline;\n            } else {\n                $title = $1;\n            }\n        } elsif (/^RL\\s{3}(.*)/ ) {\n            $loc .= $loc ? \" $1\" : $1;\n        } elsif ( /^RC\\s{3}(.*)/ ) {\n            $com .= $com ? \" $1\" : $1;\n        }\n        $_ = $self->_readline;\n    }\n    return \\@refs;\n}\n\n\n=head2 _read_swissprot_Species\n\n Title   : _read_swissprot_Species\n Usage   :\n Function: Reads the swissprot Organism species and classification\n           lines.\n             Able to deal with unconventional species names.\n Example : OS Unknown prokaryotic organism\n             $genus = undef ; $species = Unknown prokaryotic organism\n Returns : A Bio::Species object\n Args    :","parameters":[{"label":"$self"},{"label":"$line"}],"label":"_read_swissprot_Species($self,$line)"},"children":[{"definition":"my","line":1112,"name":"$self","kind":13,"localvar":"my","containerName":"_read_swissprot_Species"},{"kind":13,"containerName":"_read_swissprot_Species","name":"$line","line":1112},{"name":"$org","localvar":"my","containerName":"_read_swissprot_Species","kind":13,"line":1113,"definition":"my"},{"line":1114,"kind":13,"containerName":"_read_swissprot_Species","name":"$line"},{"line":1116,"localvar":"my","kind":13,"containerName":"_read_swissprot_Species","name":"$sub_species","definition":"my"},{"line":1116,"containerName":"_read_swissprot_Species","kind":13,"name":"$species"},{"line":1116,"name":"$genus","kind":13,"containerName":"_read_swissprot_Species"},{"line":1116,"name":"$common","kind":13,"containerName":"_read_swissprot_Species"},{"name":"$variant","containerName":"_read_swissprot_Species","kind":13,"line":1116},{"kind":13,"containerName":"_read_swissprot_Species","name":"$ncbi_taxid","line":1116},{"kind":13,"containerName":"_read_swissprot_Species","name":"$sci_name","line":1116},{"kind":13,"containerName":"_read_swissprot_Species","name":"$class_lines","line":1116},{"name":"$descr","containerName":"_read_swissprot_Species","kind":13,"line":1116},{"definition":"my","name":"$osline","kind":13,"localvar":"my","containerName":"_read_swissprot_Species","line":1117},{"containerName":"_read_swissprot_Species","localvar":"my","kind":13,"name":"$do_genus_check","line":1118,"definition":"my"},{"name":"$sci_name","kind":13,"containerName":"_read_swissprot_Species","line":1123},{"kind":13,"containerName":"_read_swissprot_Species","name":"$osline","line":1124},{"name":"$osline","containerName":"_read_swissprot_Species","kind":13,"line":1124},{"line":1125,"containerName":"_read_swissprot_Species","kind":13,"name":"$osline"},{"kind":13,"containerName":"_read_swissprot_Species","name":"$osline","line":1126},{"line":1133,"kind":13,"containerName":"_read_swissprot_Species","name":"$osline"},{"name":"$sci_name","kind":13,"containerName":"_read_swissprot_Species","line":1136},{"name":"$osline","containerName":"_read_swissprot_Species","kind":13,"line":1136},{"line":1137,"containerName":"_read_swissprot_Species","kind":13,"name":"$sci_name"},{"line":1138,"name":"$descr","containerName":"_read_swissprot_Species","kind":13},{"containerName":"_read_swissprot_Species","kind":13,"name":"$do_genus_check","line":1139},{"line":1141,"containerName":"_read_swissprot_Species","kind":13,"name":"$sci_name"},{"line":1141,"name":"$descr","kind":13,"containerName":"_read_swissprot_Species"},{"containerName":"_read_swissprot_Species","kind":13,"name":"$osline","line":1141},{"line":1143,"containerName":"_read_swissprot_Species","kind":13,"name":"$sci_name"},{"line":1145,"name":"$descr","containerName":"_read_swissprot_Species","kind":13},{"definition":"my","line":1146,"localvar":"my","containerName":"_read_swissprot_Species","kind":13,"name":"$item"},{"name":"$variant","kind":13,"containerName":"_read_swissprot_Species","line":1149},{"containerName":"_read_swissprot_Species","kind":13,"name":"$item","line":1150},{"line":1151,"kind":13,"containerName":"_read_swissprot_Species","name":"$item"},{"containerName":"_read_swissprot_Species","kind":13,"name":"$variant","line":1152},{"name":"$item","kind":13,"containerName":"_read_swissprot_Species","line":1152},{"name":"$item","containerName":"_read_swissprot_Species","kind":13,"line":1153},{"kind":13,"containerName":"_read_swissprot_Species","name":"$sub_species","line":1154},{"containerName":"_read_swissprot_Species","kind":13,"name":"$sub_species","line":1155},{"containerName":"_read_swissprot_Species","kind":13,"name":"$item","line":1155},{"name":"$variant","containerName":"_read_swissprot_Species","kind":13,"line":1156},{"line":1157,"name":"$variant","kind":13,"containerName":"_read_swissprot_Species"},{"name":"$item","containerName":"_read_swissprot_Species","kind":13,"line":1157},{"name":"$common","kind":13,"containerName":"_read_swissprot_Species","line":1159},{"kind":13,"containerName":"_read_swissprot_Species","name":"$common","line":1161},{"containerName":"_read_swissprot_Species","kind":13,"name":"$item","line":1161},{"line":1162,"name":"$common","kind":13,"containerName":"_read_swissprot_Species"},{"line":1163,"kind":13,"containerName":"_read_swissprot_Species","name":"$common"},{"line":1164,"containerName":"_read_swissprot_Species","kind":13,"name":"$common"},{"name":"$class_lines","containerName":"_read_swissprot_Species","kind":13,"line":1170},{"line":1172,"name":"$org","containerName":"_read_swissprot_Species","kind":13},{"name":"$ncbi_taxid","kind":13,"containerName":"_read_swissprot_Species","line":1173},{"localvar":"my","containerName":"_read_swissprot_Species","kind":13,"name":"$taxstring","line":1174,"definition":"my"},{"line":1176,"name":"$taxstring","kind":13,"containerName":"_read_swissprot_Species"},{"name":"$ncbi_taxid","containerName":"_read_swissprot_Species","kind":13,"line":1177},{"name":"$self","kind":13,"containerName":"_read_swissprot_Species","line":1179},{"kind":12,"containerName":"_read_swissprot_Species","name":"throw","line":1179},{"line":1182,"name":"$self","containerName":"_read_swissprot_Species","kind":13},{"name":"_readline","kind":12,"containerName":"_read_swissprot_Species","line":1182},{"name":"$self","containerName":"_read_swissprot_Species","kind":13,"line":1184},{"containerName":"_read_swissprot_Species","kind":12,"name":"_pushback","line":1184},{"line":1186,"name":"$sci_name","kind":13,"containerName":"_read_swissprot_Species"},{"line":1189,"name":"$sci_name","kind":13,"containerName":"_read_swissprot_Species"},{"containerName":"_read_swissprot_Species","kind":13,"name":"@Unknown_names","line":1189},{"line":1195,"name":"$class_lines","containerName":"_read_swissprot_Species","kind":13},{"name":"@class","kind":13,"localvar":"my","containerName":"_read_swissprot_Species","line":1196,"definition":"my"},{"name":"$class_lines","containerName":"_read_swissprot_Species","kind":13,"line":1196},{"line":1198,"name":"$class","kind":13,"containerName":"_read_swissprot_Species"},{"definition":"my","name":"@virusnames","kind":13,"localvar":"my","containerName":"_read_swissprot_Species","line":1200},{"line":1200,"containerName":"_read_swissprot_Species","kind":13,"name":"$sci_name"},{"kind":13,"containerName":"_read_swissprot_Species","name":"$species","line":1201},{"line":1201,"name":"@virusnames","kind":13,"containerName":"_read_swissprot_Species"},{"line":1201,"containerName":"_read_swissprot_Species","kind":13,"name":"@virusnames"},{"name":"$genus","kind":13,"containerName":"_read_swissprot_Species","line":1202},{"line":1202,"kind":13,"containerName":"_read_swissprot_Species","name":"@virusnames"},{"name":"$sub_species","kind":13,"containerName":"_read_swissprot_Species","line":1203},{"line":1203,"containerName":"_read_swissprot_Species","kind":13,"name":"$descr"},{"line":1204,"name":"$do_genus_check","containerName":"_read_swissprot_Species","kind":13},{"line":1206,"kind":13,"localvar":"my","containerName":"_read_swissprot_Species","name":"$possible_genus","definition":"my"},{"line":1206,"name":"$class","kind":13,"containerName":"_read_swissprot_Species"},{"name":"$possible_genus","containerName":"_read_swissprot_Species","kind":13,"line":1207},{"line":1207,"containerName":"_read_swissprot_Species","kind":13,"name":"$class"},{"name":"$sci_name","containerName":"_read_swissprot_Species","kind":13,"line":1208},{"name":"$genus","containerName":"_read_swissprot_Species","kind":13,"line":1209},{"name":"$species","containerName":"_read_swissprot_Species","kind":13,"line":1210},{"line":1210,"name":"$sci_name","kind":13,"containerName":"_read_swissprot_Species"},{"name":"$species","containerName":"_read_swissprot_Species","kind":13,"line":1212},{"containerName":"_read_swissprot_Species","kind":13,"name":"$sci_name","line":1212},{"line":1216,"name":"$species","containerName":"_read_swissprot_Species","kind":13},{"containerName":"_read_swissprot_Species","kind":13,"name":"$species","line":1216},{"line":1217,"containerName":"_read_swissprot_Species","kind":13,"name":"$species"},{"line":1217,"name":"$sub_species","kind":13,"containerName":"_read_swissprot_Species"},{"name":"$species","containerName":"_read_swissprot_Species","kind":13,"line":1217},{"name":"$class","kind":13,"containerName":"_read_swissprot_Species","line":1222},{"name":"$sci_name","containerName":"_read_swissprot_Species","kind":13,"line":1222},{"kind":13,"containerName":"_read_swissprot_Species","name":"@class","line":1223},{"name":"$sci_name","containerName":"_read_swissprot_Species","kind":13,"line":1223},{"name":"@class","kind":13,"containerName":"_read_swissprot_Species","line":1225},{"line":1225,"name":"@class","containerName":"_read_swissprot_Species","kind":13},{"definition":"my","name":"$taxon","localvar":"my","containerName":"_read_swissprot_Species","kind":13,"line":1227},{"line":1227,"name":"new","containerName":"_read_swissprot_Species","kind":12},{"line":1228,"name":"$taxon","kind":13,"containerName":"_read_swissprot_Species"},{"line":1228,"kind":12,"containerName":"_read_swissprot_Species","name":"scientific_name"},{"line":1228,"containerName":"_read_swissprot_Species","kind":13,"name":"$sci_name"},{"kind":13,"containerName":"_read_swissprot_Species","name":"$taxon","line":1229},{"kind":12,"containerName":"_read_swissprot_Species","name":"classification","line":1229},{"line":1229,"containerName":"_read_swissprot_Species","kind":13,"name":"@class"},{"containerName":"_read_swissprot_Species","kind":13,"name":"$taxon","line":1230},{"containerName":"_read_swissprot_Species","kind":12,"name":"common_name","line":1230},{"line":1230,"name":"$common","kind":13,"containerName":"_read_swissprot_Species"},{"line":1230,"name":"$common","containerName":"_read_swissprot_Species","kind":13},{"line":1231,"name":"$taxon","containerName":"_read_swissprot_Species","kind":13},{"line":1231,"name":"sub_species","kind":12,"containerName":"_read_swissprot_Species"},{"name":"$sub_species","containerName":"_read_swissprot_Species","kind":13,"line":1231},{"line":1231,"name":"$sub_species","kind":13,"containerName":"_read_swissprot_Species"},{"name":"$taxon","kind":13,"containerName":"_read_swissprot_Species","line":1232},{"line":1232,"name":"organelle","containerName":"_read_swissprot_Species","kind":12},{"line":1232,"kind":13,"containerName":"_read_swissprot_Species","name":"$org"},{"line":1232,"containerName":"_read_swissprot_Species","kind":13,"name":"$org"},{"line":1233,"containerName":"_read_swissprot_Species","kind":13,"name":"$taxon"},{"kind":12,"containerName":"_read_swissprot_Species","name":"ncbi_taxid","line":1233},{"name":"$ncbi_taxid","kind":13,"containerName":"_read_swissprot_Species","line":1233},{"line":1233,"containerName":"_read_swissprot_Species","kind":13,"name":"$ncbi_taxid"},{"containerName":"_read_swissprot_Species","kind":13,"name":"$taxon","line":1234},{"line":1234,"name":"variant","kind":12,"containerName":"_read_swissprot_Species"},{"kind":13,"containerName":"_read_swissprot_Species","name":"$variant","line":1234},{"containerName":"_read_swissprot_Species","kind":13,"name":"$variant","line":1234},{"line":1237,"name":"$taxon","kind":13,"containerName":"_read_swissprot_Species"}],"name":"_read_swissprot_Species","containerName":"main::","definition":"sub","detail":"($self,$line)"},{"line":1227,"name":"Bio","kind":12,"containerName":"Species"},{"definition":"sub","detail":"($self,$line)","children":[{"line":1267,"containerName":"_read_FTHelper_swissprot","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":1267,"kind":13,"containerName":"_read_FTHelper_swissprot","name":"$line"},{"containerName":"_read_FTHelper_swissprot","kind":13,"name":"$line","line":1273},{"line":1274,"containerName":"_read_FTHelper_swissprot","localvar":"my","kind":13,"name":"$key","definition":"my"},{"line":1275,"kind":13,"containerName":"_read_FTHelper_swissprot","name":"$loc"},{"line":1276,"name":"$desc","kind":13,"containerName":"_read_FTHelper_swissprot"},{"line":1277,"name":"$ftid","containerName":"_read_FTHelper_swissprot","kind":13},{"line":1280,"containerName":"_read_FTHelper_swissprot","kind":13,"name":"$key"},{"localvar":"my","containerName":"_read_FTHelper_swissprot","kind":13,"name":"$loc1","line":1281,"definition":"my"},{"name":"$loc2","containerName":"_read_FTHelper_swissprot","localvar":"my","kind":13,"line":1282,"definition":"my"},{"line":1283,"containerName":"_read_FTHelper_swissprot","kind":13,"name":"$loc"},{"name":"$desc","containerName":"_read_FTHelper_swissprot","kind":13,"line":1285},{"line":1286,"containerName":"_read_FTHelper_swissprot","kind":13,"name":"$desc"},{"name":"$desc","containerName":"_read_FTHelper_swissprot","kind":13,"line":1288},{"containerName":"_read_FTHelper_swissprot","kind":13,"name":"$self","line":1292},{"name":"_readline","kind":12,"containerName":"_read_FTHelper_swissprot","line":1292},{"definition":"my","name":"$continuation_line","containerName":"_read_FTHelper_swissprot","localvar":"my","kind":13,"line":1293},{"line":1294,"name":"$continuation_line","containerName":"_read_FTHelper_swissprot","kind":13},{"line":1295,"kind":13,"containerName":"_read_FTHelper_swissprot","name":"$ftid"},{"name":"$desc","containerName":"_read_FTHelper_swissprot","kind":13,"line":1297},{"kind":13,"containerName":"_read_FTHelper_swissprot","name":"$desc","line":1298},{"containerName":"_read_FTHelper_swissprot","kind":13,"name":"$desc","line":1300},{"containerName":"_read_FTHelper_swissprot","kind":13,"name":"$continuation_line","line":1300},{"name":"$desc","containerName":"_read_FTHelper_swissprot","kind":13,"line":1302},{"kind":13,"containerName":"_read_FTHelper_swissprot","name":"$self","line":1304},{"line":1304,"kind":12,"containerName":"_read_FTHelper_swissprot","name":"_pushback"},{"name":"$key","containerName":"_read_FTHelper_swissprot","kind":13,"line":1305},{"line":1307,"name":"$self","kind":13,"containerName":"_read_FTHelper_swissprot"},{"line":1307,"containerName":"_read_FTHelper_swissprot","kind":12,"name":"warn"},{"definition":"my","localvar":"my","kind":13,"containerName":"_read_FTHelper_swissprot","name":"$out","line":1312},{"containerName":"_read_FTHelper_swissprot","kind":12,"name":"new","line":1312},{"line":1312,"name":"$self","containerName":"_read_FTHelper_swissprot","kind":13},{"kind":12,"containerName":"_read_FTHelper_swissprot","name":"verbose","line":1312},{"line":1313,"containerName":"_read_FTHelper_swissprot","kind":13,"name":"$out"},{"line":1313,"kind":12,"containerName":"_read_FTHelper_swissprot","name":"key"},{"line":1313,"name":"$key","kind":13,"containerName":"_read_FTHelper_swissprot"},{"containerName":"_read_FTHelper_swissprot","kind":13,"name":"$out","line":1314},{"name":"loc","containerName":"_read_FTHelper_swissprot","kind":12,"line":1314},{"line":1314,"kind":13,"containerName":"_read_FTHelper_swissprot","name":"$loc"},{"line":1317,"kind":13,"containerName":"_read_FTHelper_swissprot","name":"$desc"},{"containerName":"_read_FTHelper_swissprot","kind":13,"name":"$desc","line":1317},{"name":"$desc","containerName":"_read_FTHelper_swissprot","kind":13,"line":1318},{"kind":13,"containerName":"_read_FTHelper_swissprot","name":"$out","line":1319},{"kind":12,"containerName":"_read_FTHelper_swissprot","name":"field","line":1319},{"line":1319,"kind":13,"containerName":"_read_FTHelper_swissprot","name":"$desc"}],"name":"_read_FTHelper_swissprot","containerName":"main::","signature":{"documentation":"1;\n# $Id: swiss.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::swiss\n#\n# Copyright Elia Stupka\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::swiss - Swissprot sequence input/output stream\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system:\n\n    use Bio::SeqIO;\n\n    $stream = Bio::SeqIO->new(-file => $filename,\n                              -format => 'swiss');\n\n    while ( my $seq = $stream->next_seq() ) {\n       # do something with $seq\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from Swiss-Pprot flat\nfile databases.\n\nThere is a lot of flexibility here about how to dump things which needs\nto be documented.\n\n=head2 GN (Gene name) line management details\n\nA Uniprot/Swiss-Prot entry holds information on one protein\nsequence. If that sequence is identical across genes and species, they\nare all merged into one entry. This creates complex needs for several\nannotation fields in swiss-prot format.\n\nThe latest syntax for GN line is described in the user manual:\n\n  http://www.expasy.ch/sprot/userman.html#GN_line\n\nEach of the possibly multiple genes in an entry can have Name,\nSynonyms (only if there is a name), OrderedLocusNames (names from\ngenomic sequences) and ORFNames (temporary or cosmid names). \"Name\"\nhere really means \"symbol\". This complexity is now dealt with the\nfollowing way:\n\nA new Bio::AnnotationI class was created in order to store the\ndata in tag-value pairs.  This class (Bio::Annotation::TagTree)\nis stored in the Bio::Annotation::Collection object and is\naccessed like all other annotations. The tag name is 'gene_name'.\n\nThere is a single Bio::Annotation::TagTree per sequence record, which\ncorresponds to the original class that stored this data\n(Bio::Annotation::StructuredValue).  Depending on how we progress\nthis may change to represent each group of gene names.\n\nFor now, to access the gene name tree annotation, one uses the below method:\n\n   my ($gene) = $seq->annotation->get_Annotations('gene_name');\n\nIf you are only interested in displaying the values, value() returns a\nstring with similar formatting.\n\nThere are several ways to get directly at the information you want if you\nknow the element (tag) for the data.  For gene names all data is stored with\nthe element-tag pairs:\n\n  \"element1=tag1, tag2, tag3; element2=tag4, tag5;\"\n\nThis normally means the element will be 'Name', 'Synonyms', etc. and the\ngene names the values.  Using findval(), you can do the following:\n\n  # grab a flattened list of all gene names\n  my @names = $ann->findval('Name');\n\n  # or iterated through the nodes and grab the name for each group\n  for my $node ($ann->findnode('gene_name')) {\n     my @names = $node->findval('Name');\n  }\n\nThe current method for parsing gene name data (and reconstructing gene name\noutput) is very generic. This is somewhat preemptive if, for instance, UniProt\ndecides to update and add another element name to the current ones using the\nsame formatting layout. Under those circumstances, one can iterate through the\ntag tree in a safe way and retrieve all node data like so.\n\n  # retrieve the gene name nodes (groups like names, synonyms, etc).\n  for my $ann ($seq->annotation->get_Annotations('gene_name')) {\n\n      # each gene name group\n      for my $node ($ann->findnode('gene_name')) {\n          print \"Gene name:\\n\";\n\n          # each gene name node (tag => value pair)\n          for my $n ($node->children) {\n              print \"\\t\".$n->element.\": \".$n->children.\"\\n\";\n          }\n      }\n  }\n\nFor more uses see Bio::Annotation::TagTree.\n\nSince Uniprot/Swiss-Prot format have been around for quite some time, the\nparser is also able to read in the older GN line syntax where genes\nare separated by AND and various symbols by OR. The first symbol is\ntaken to be the 'Name' and the remaining ones are stored as 'Synonyms'.\n\n=head2 Optional functions\n\n=over 3\n\n* _show_dna()\n\n(output only) shows the dna or not\n\n* _post_sort()\n\n(output only) provides a sorting func which is applied to the FTHelpers\nbefore printing\n\n* _id_generation_func()\n\nThis is function which is called as\n\n   print \"ID   \", $func($seq), \"\\n\";\n\nTo generate the ID line. If it is not there, it generates a sensible ID\nline using a number of tools.\n\nIf you want to output annotations in Swissprot format they need to be\nstored in a Bio::Annotation::Collection object which is accessible\nthrough the Bio::SeqI interface method L<annotation()|annotation>.\n\nThe following are the names of the keys which are polled from a\nL<Bio::Annotation::Collection> object.\n\n reference   - Should contain Bio::Annotation::Reference objects\n comment     - Should contain Bio::Annotation::Comment objects\n dblink      - Should contain Bio::Annotation::DBLink objects\n gene_name   - Should contain Bio::Annotation::SimpleValue object\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions,\npreferably to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Elia Stupka\n\nEmail elia@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::swiss;\nuse vars qw(@Unknown_names @Unknown_genus);\nuse strict;\nuse Bio::SeqIO::FTHelper;\nuse Bio::SeqFeature::Generic;\nuse Bio::Species;\nuse Bio::Tools::SeqStats;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::Comment;\nuse Bio::Annotation::Reference;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::TagTree;\n\nuse base qw(Bio::SeqIO);\n\nour $LINE_LENGTH = 76;\n\n# this is for doing species name parsing\n@Unknown_names=('other', 'unidentified',\n                'unknown organism', 'not specified',\n                'not shown', 'Unspecified', 'Unknown',\n                'None', 'unclassified', 'unidentified organism',\n                'not supplied'\n               );\n# dictionary of synonyms for taxid 32644\n# all above can be part of valid species name\n@Unknown_genus = qw(unknown unclassified uncultured unidentified);\n\n# if there are any other gene name tags, they are added to the end\nour @GENE_NAME_ORDER = qw(Name Synonyms OrderedLocusNames ORFNames);\n\nsub _initialize {\n    my($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    # hash for functions for decoding keys.\n    $self->{'_func_ftunit_hash'} = {};\n    # sets this to one by default. People can change it\n    $self->_show_dna(1);\n    if ( ! defined $self->sequence_factory ) {\n        $self->sequence_factory(Bio::Seq::SeqFactory->new\n                                (-verbose => $self->verbose(),\n                                 -type => 'Bio::Seq::RichSeq'));\n    }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    :\n\n\nsub next_seq {\n    my ($self,@args) = @_;\n    my ($pseq,$c,$line,$name,$desc,$acc,$seqc,$mol,$div, $sptr,$seq_div,\n        $date,$comment,@date_arr);\n    my $genename = \"\";\n    my ($annotation, %params, @features) = ( Bio::Annotation::Collection->new());\n\n    local $_;\n\n    1 while defined($_ = $self->_readline) && /^\\s+$/;\n    return unless defined $_ && /^ID\\s/;\n\n    # fixed to allow _DIVISION to be optional for bug #946\n    # see bug report for more information\n    #\n    # 9/6/06 Note: Swiss/TrEMBL sequences have no division acc. to UniProt\n    # release notes; this is fixed to simplify the regex parsing\n    # STANDARD (SwissProt) and PRELIMINARY (TrEMBL) added to namespace()\n    unless(  m{^\n               ID              \\s+     #\n               (\\S+)           \\s+     #  $1  entryname\n               ([^\\s;]+);      \\s+     #  $2  DataClass\n               (?:PRT;)?       \\s+     #  Molecule Type (optional)\n               [0-9]+[ ]AA     \\.      #  Sequencelength (capture?)\n               $\n           }ox ) {\n            # I couldn't find any new current UniProt sequences\n            # that matched this format:\n            # || m/^ID\\s+(\\S+)\\s+(_([^\\s_]+))? /ox ) {\n        $self->throw(\"swissprot stream with no ID. Not swissprot in my book\");\n    }\n    ($name, $seq_div) = ($1, $2);\n    $params{'-namespace'} =\n        ($seq_div eq 'Reviewed'   || $seq_div eq 'STANDARD')     ? 'Swiss-Prot' :\n        ($seq_div eq 'Unreviewed' || $seq_div eq 'PRELIMINARY')  ? 'TrEMBL'     :\n         $seq_div;\n    # we shouldn't be setting the division, but for now...\n    my ($junk, $division) = split q(_), $name;\n    $params{'-division'} = $division;\n    $params{'-alphabet'} = 'protein';\n    # this is important to have the id for display in e.g. FTHelper, otherwise\n    # you won't know which entry caused an error\n    $params{'-display_id'} = $name;\n\n    BEFORE_FEATURE_TABLE :\n          while ( defined($_ = $self->_readline) ) {\n              # Exit at start of Feature table and at the sequence at the\n              # latest HL 05/11/2000\n              last if( /^(FT|SQ)/ );\n\n              # Description line(s)\n              if (/^DE\\s+(\\S.*\\S)/) {\n                  $desc .= $desc ? \" $1\" : $1;\n              }\n              #Gene name\n              elsif (/^GN\\s+(.*)/) {\n                  $genename .= \" \" if $genename;\n                  $genename .= $1;\n              }\n              #accession number(s)\n              elsif ( /^AC\\s+(.+)/) {\n                  my @accs = split(/[; ]+/, $1); # allow space in addition\n                  $params{'-accession_number'} = shift @accs\n                      unless defined $params{'-accession_number'};\n                  push @{$params{'-secondary_accessions'}}, @accs;\n              }\n              #date and sequence version\n              elsif ( /^DT\\s+(.*)/ ) {\n                  my $line = $1;\n                  my ($date, $version) = split(' ', $line, 2);\n                  $date =~ tr/,//d; # remove comma if new version\n                  if ($version =~ /\\(Rel\\. (\\d+), Last sequence update\\)/ || # old\n                      /sequence version (\\d+)/) { #new\n                      my $update = Bio::Annotation::SimpleValue->new\n                          (-tagname    => 'seq_update',\n                           -value      => $1\n                          );\n                      $annotation->add_Annotation($update);\n                  } elsif ($version =~ /\\(Rel\\. (\\d+), Last annotation update\\)/ || #old\n                           /entry version (\\d+)/) { #new\n                      $params{'-version'} = $1;\n                  }\n                  push @{$params{'-dates'}}, $date;\n              }\n              # Evidence level\n              elsif ( /^PE\\s+(.*)/ ) {\n                  my $line = $1;\n                  $line =~ s/;\\s*//; # trim trailing semicolon and any spaces at the end of the line\n                  my $evidence = Bio::Annotation::SimpleValue->new\n                      (-tagname   => 'evidence',\n                       -value     => $line\n                      );\n                  $annotation->add_Annotation($evidence);\n              }\n              # Organism name and phylogenetic information\n              elsif (/^O[SCG]/) {\n                  my $species = $self->_read_swissprot_Species($_);\n                  $params{'-species'}= $species;\n                  # now we are one line ahead -- so continue without reading the next\n                  # line   HL 05/11/2000\n              }\n              # References\n              elsif (/^R/) {\n                  my $refs = $self->_read_swissprot_References($_);\n                  foreach my $r (@$refs) {\n                      $annotation->add_Annotation('reference',$r);\n                  }\n              }\n              # Comments\n              elsif (/^CC\\s{3}(.*)/) {\n                  $comment .= $1;\n                  $comment .= \"\\n\";\n                  while (defined ($_ = $self->_readline) && /^CC\\s{3}(.*)/ ) {\n                      $comment .= $1 . \"\\n\";\n                  }\n\n                  # note: don't try to process comments here -- they may contain\n                  # structure. LP 07/30/2000\n\n                  my $commobj = Bio::Annotation::Comment->new(-tagname => 'comment',\n                                                              -text    => $comment);\n                  $annotation->add_Annotation('comment',$commobj);\n                  $comment = \"\";\n                  $self->_pushback($_);\n              }\n              #DBLinks\n              # old regexp\n              # /^DR\\s+(\\S+)\\;\\s+(\\S+)\\;\\s+(\\S+)[\\;\\.](.*)$/) {\n              # new regexp from Andreas Kahari  bug #1584\n              elsif (/^DR\\s+(\\S+)\\;\\s+(\\S+)\\;\\s+([^;]+)[\\;\\.](.*)$/) {\n                  my ($database,$primaryid,$optional,$comment) = ($1,$2,$3,$4);\n\n                  # drop leading and training spaces and trailing .\n                  $comment =~ s/\\.\\s*$//;\n                  $comment =~ s/^\\s+//;\n\n                  my $dblinkobj =  Bio::Annotation::DBLink->new\n                      (-database    => $database,\n                       -primary_id  => $primaryid,\n                       -optional_id => $optional,\n                       -comment     => $comment,\n                       -tagname     => 'dblink',\n                      );\n\n                  $annotation->add_Annotation('dblink',$dblinkobj);\n              }\n              #keywords\n              elsif ( /^KW\\s+(.*)$/ ) {\n                  my @kw = split(/\\s*\\;\\s*/,$1);\n                  defined $kw[-1] && $kw[-1] =~ s/\\.$//;\n                  push @{$params{'-keywords'}}, @kw;\n              }\n          }\n    # process and parse the gene name line if there was one (note: we\n    # can't do this above b/c GN may be multi-line and we can't\n    # unequivocally determine whether we've seen the last GN line in\n    # the new format)\n    if ($genename) {\n        my @stags;\n        if ($genename =~ /\\w=\\w/) {\n            # new format (e.g., Name=RCHY1; Synonyms=ZNF363, CHIMP)\n            for my $n (split(m{\\s+and\\s+},$genename)) {\n                my @genenames;\n                for my $section (split(m{\\s*;\\s*},$n)) {\n                    my ($tag, $rest) = split(\"=\",$section);\n                    $rest ||= '';\n                    for my $val (split(m{\\s*,\\s*},$rest)) {\n                        push @genenames, [$tag => $val];\n                    }\n                }\n                push @stags, ['gene_name' => \\@genenames];\n            }\n        } else {\n            # old format\n            for my $section (split(/ AND /, $genename)) {\n                my @genenames;\n                $section =~ s/[\\(\\)\\.]//g;\n                my @names = split(m{\\s+OR\\s+}, $section);\n                push @genenames, ['Name' => shift @names];\n                push @genenames, map {['Synonyms' => $_]} @names;\n                push @stags, ['gene_name' => \\@genenames]            \n            }\n        } #use Data::Dumper; print Dumper $gn, $genename;# exit;\n        my $gn = Bio::Annotation::TagTree->new(-tagname => 'gene_name',\n                                               -value => ['gene_names' => \\@stags]);\n        $annotation->add_Annotation('gene_name', $gn);\n    }\n\n    FEATURE_TABLE :\n          # if there is no feature table, or if we've got beyond, exit loop or don't\n          # even enter    HL 05/11/2000\n          while (defined $_ && /^FT/ ) {\n              my $ftunit = $self->_read_FTHelper_swissprot($_);\n\n              # process ftunit\n              # when parsing of the line fails we get undef returned\n              if ($ftunit) {\n                  push(@features,\n                       $ftunit->_generic_seqfeature($self->location_factory(),\n                                                    $params{'-seqid'}, \"SwissProt\"));\n              } else {\n                  $self->warn(\"failed to parse feature table line for seq \" .\n                              $params{'-display_id'}. \"\\n$_\");\n              }\n              $_ = $self->_readline;\n          }\n    while ( defined($_) && ! /^SQ/ ) {\n        $_ = $self->_readline;\n    }\n    $seqc = \"\";\n    while ( defined ($_ = $self->_readline) ) {\n        last if m{^//};\n        s/[^A-Za-z]//g;\n        $seqc .= uc($_);\n    }\n\n    my $seq=  $self->sequence_factory->create\n        (-verbose  => $self->verbose,\n         %params,\n         -seq      => $seqc,\n         -desc     => $desc,\n         -features => \\@features,\n         -annotation => $annotation,\n        );\n\n    # The annotation doesn't get added by the contructor\n    $seq->annotation($annotation);\n\n    return $seq;\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq($seq)\n Function: writes the $seq object (must be seq) to the stream\n Returns : 1 for success and 0 for error\n Args    : array of 1 to n Bio::SeqI objects\n\n\n\nsub write_seq {\n    my ($self,@seqs) = @_;\n    foreach my $seq ( @seqs ) {\n        $self->throw(\"Attempting to write with no seq!\") unless defined $seq;\n\n        if ( ! ref $seq || ! $seq->isa('Bio::SeqI') ) {\n            $self->warn(\" $seq is not a SeqI compliant module. Attempting to dump, but may fail!\");\n        }\n\n        my $i;\n        my $str = $seq->seq;\n\n        my $div;\n        my $ns = ($seq->can('namespace')) && $seq->namespace();\n        my $len = $seq->length();\n\n        if ( !$seq->can('division') || ! defined ($div = $seq->division()) ) {\n            $div = 'UNK';\n        }\n\n        # namespace dictates database, takes precedent over division. Sorry!\n        if (defined($ns)) {\n            $div = ($ns eq 'Swiss-Prot') ? 'Reviewed'    :\n                ($ns eq 'TrEMBL')     ? 'Unreviewed' :\n                    $ns;\n        } else {\n            $ns = 'Swiss-Prot';\n            # division not reset; acts as fallback\n        }\n\n        $self->warn(\"No whitespace allowed in SWISS-PROT display id [\". $seq->display_id. \"]\")\n            if $seq->display_id =~ /\\s/;\n\n        my $temp_line;\n        if ( $self->_id_generation_func ) {\n            $temp_line = &{$self->_id_generation_func}($seq);\n        } else {\n            #$temp_line = sprintf (\"%10s     STANDARD;      %3s;   %d AA.\",\n            #            $seq->primary_id().\"_\".$div,$mol,$len);\n            # Reconstructing the ID relies heavily upon the input source having\n            # been in a format that is parsed as this routine expects it -- that is,\n            # by this module itself. This is bad, I think, and immediately breaks\n            # if e.g. the Bio::DB::GenPept module is used as input.\n            # Hence, switch to display_id(); _every_ sequence is supposed to have\n            # this. HL 2000/09/03\n            # Changed to reflect ID line changes in UniProt\n            # Oct 2006 - removal of molecule type - see bug 2134\n            $temp_line = sprintf (\"%-24s%-12s%9d AA.\",\n                                  $seq->display_id(), $div.';', $len);\n        }\n\n        $self->_print( \"ID   $temp_line\\n\");\n\n        # if there, write the accession line\n        local($^W) = 0;         # supressing warnings about uninitialized fields\n\n        if ( $self->_ac_generation_func ) {\n            $temp_line = &{$self->_ac_generation_func}($seq);\n            $self->_print( \"AC   $temp_line\\n\");\n        }\n        elsif ($seq->can('accession_number') ) {\n            my $ac_line = $seq->accession_number;\n            if ($seq->can('get_secondary_accessions') ) {\n                foreach my $sacc ($seq->get_secondary_accessions) {\n                    $ac_line .= \"; \". $sacc;;\n                }\n                $ac_line .= \";\";\n            }\n\n            $self->_write_line_swissprot_regex(\"AC   \",\"AC   \",$ac_line,\n                                               \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n        }\n        # otherwise - cannot print <sigh>\n\n\n        # Date lines and sequence versions (changed 6/15/2006)\n        # This is rebuilt from scratch using the current SwissProt/UniProt format\n        if ( $seq->can('get_dates') ) {\n            my @dates =  $seq->get_dates();\n            my $ct = 1;\n            my $seq_version = $seq->version;\n            my ($update_version) = $seq->annotation->get_Annotations(\"seq_update\");\n            foreach my $dt (@dates) {\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.', integrated into UniProtKB/'.$ns.'.',\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 1;\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.\", sequence version \".$update_version->display_text.'.',\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 2;\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.\", entry version $seq_version.\",\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 3;\n                $ct++;\n            }\n        }\n\n        #Definition lines\n        $self->_write_line_swissprot_regex(\"DE   \",\"DE   \",$seq->desc(),\"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n\n        #Gene name; print out new format\n        foreach my $gene ( my @genes = $seq->annotation->get_Annotations('gene_name') ) {\n            # gene is a Bio::Annotation::TagTree;\n            my @genelines;\n            for my $node ($gene->findnode('gene_name')) {\n                # check for Name and Synonym first, then the rest get tagged on\n                my $geneline = \"GN   \";\n                my %genedata = $node->hash;\n                for my $tag (@GENE_NAME_ORDER) {\n                    if (exists $genedata{$tag}) {\n                        $geneline .= (ref $genedata{$tag} eq 'ARRAY') ?\n                            \"$tag=\".join(', ',@{$genedata{$tag}}).\"; \" :\n                            \"$tag=$genedata{$tag}; \";\n                        delete $genedata{$tag};\n                    }\n                }\n                # add rest\n                for my $tag (sort keys %genedata) {\n                    $geneline .= (ref $genedata{$tag} eq 'ARRAY') ?\n                        \"$tag=\".join(', ',@{$genedata{$tag}}).\"; \" :\n                        \"$tag=$genedata{$tag}; \";\n                    delete $genedata{$tag};\n                }\n                push @genelines, \"$geneline\\n\";\n            }\n            $self->_print(join(\"GN   and\\n\",@genelines));\n        }\n\n        # Organism lines\n        if ($seq->can('species') && (my $spec = $seq->species)) {\n            my @class = $spec->classification();\n            shift(@class);\n            my $species = $spec->species;\n            my $genus = $spec->genus;\n            my $OS = $spec->scientific_name;\n            if ($class[-1] =~ /viruses/i) {\n                $OS = $species;\n                $OS .=  \" \". $spec->sub_species if $spec->sub_species;\n            }\n            foreach (($spec->variant, $spec->common_name)) {\n                $OS .= \" ($_)\" if $_;\n            }\n            $self->_print( \"OS   $OS.\\n\");\n            my $OC = join('; ', reverse(@class)) .'.';\n            $self->_write_line_swissprot_regex(\"OC   \",\"OC   \",$OC,\"\\; \\|\\$\",$LINE_LENGTH);\n            if ($spec->organelle) {\n                $self->_write_line_swissprot_regex(\"OG   \",\"OG   \",$spec->organelle,\"\\; \\|\\$\",$LINE_LENGTH);\n            }\n            if ($spec->ncbi_taxid) {\n                $self->_print(\"OX   NCBI_TaxID=\".$spec->ncbi_taxid.\";\\n\");\n            }\n        }\n\n        # Reference lines\n        my $t = 1;\n        foreach my $ref ( $seq->annotation->get_Annotations('reference') ) {\n            $self->_print( \"RN   [$t]\\n\");\n            # changed by lorenz 08/03/00\n            # j.gilbert and h.lapp agreed that the rp line in swissprot seems\n            # more like a comment than a parseable value, so print it as is\n            if ($ref->rp) {\n                $self->_write_line_swissprot_regex(\"RP   \",\"RP   \",$ref->rp,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            }\n            if ($ref->comment) {\n                $self->_write_line_swissprot_regex(\"RC   \",\"RC   \",$ref->comment,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            }\n            if ($ref->medline or $ref->pubmed or $ref->doi) {\n                # new RX format in swissprot LP 09/17/00\n                # RX line can now have a DOI, Heikki 13 Feb 2008\n\n                my $line;\n                $line .= \"MEDLINE=\". $ref->medline. '; ' if $ref->medline;\n                $line .= \"PubMed=\". $ref->pubmed. '; ' if $ref->pubmed;\n                $line .= \"DOI=\". $ref->doi. '; ' if $ref->doi;\n                chop $line;\n\n                $self->_write_line_swissprot_regex(\"RX   \",\"RX   \",\n                                                   $line,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n\n            }\n            my $author = $ref->authors .';' if($ref->authors);\n            my $title = $ref->title .';' if( $ref->title);\n            my $rg = $ref->rg . ';' if $ref->rg;\n            $author =~ s/([\\w\\.]) (\\w)/$1#$2/g;  # add word wrap protection char '#'\n\n            $self->_write_line_swissprot_regex(\"RG   \",\"RG   \",$rg,\"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $rg;\n            $self->_write_line_swissprot_regex(\"RA   \",\"RA   \",$author,\"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $author;\n            $self->_write_line_swissprot_regex(\"RT   \",\"RT   \",$title,'[\\s\\-]+|$',$LINE_LENGTH) if $title;\n            $self->_write_line_swissprot_regex(\"RL   \",\"RL   \",$ref->location,\"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            $t++;\n        }\n\n        # Comment lines\n\n        foreach my $comment ( $seq->annotation->get_Annotations('comment') ) {\n            foreach my $cline (split (\"\\n\", $comment->text)) {\n                while (length $cline > 74) {\n                    $self->_print(\"CC   \",(substr $cline,0,74),\"\\n\");\n                    $cline = substr $cline,74;\n                }\n                $self->_print(\"CC   \",$cline,\"\\n\");\n            }\n        }\n\n        # Database xref lines\n\n        foreach my $dblink ( $seq->annotation->get_Annotations('dblink') ) {\n            my ($primary_id) = $dblink->primary_id;\n\t\n            if (defined($dblink->comment) && ($dblink->comment) ) {\n                $self->_print(\"DR   \",$dblink->database,\"; \",$primary_id,\"; \",\n                              $dblink->optional_id,\"; \",$dblink->comment,\".\\n\");\n            } elsif ($dblink->optional_id) {\n                $self->_print(\"DR   \",$dblink->database,\"; \",\n                              $primary_id,\"; \",\n                              $dblink->optional_id,\".\\n\");\n            } else {\n                $self->_print(\"DR   \",$dblink->database,\n                              \"; \",$primary_id,\"; \",\"-.\\n\");\n            }\n        }\n\n        # Evidence lines\n\n        foreach my $evidence ( $seq->annotation->get_Annotations('evidence') ) {\n            $self->_print(\"PE   \",$evidence->value,\";\\n\");\n        }\n\n        # if there, write the kw line\n        {\n            my $kw;\n            if ( my $func = $self->_kw_generation_func ) {\n                $kw = &{$func}($seq);\n            } elsif ( $seq->can('keywords') ) {\n                $kw = $seq->keywords;\n                if ( ref($kw) =~ /ARRAY/i ) {\n                    $kw = join(\"; \", @$kw);\n                }\n                $kw .= '.' if $kw and $kw !~ /\\.$/ ;\n            }\n            $kw =~ s/([\\w\\.]) (\\w)/$1#$2/g;  # add word wrap protection char '#'\n            $self->_write_line_swissprot_regex(\"KW   \",\"KW   \",\n                                               $kw, \"\\\\s\\+\\|\\$\",$LINE_LENGTH)\n                if $kw;\n        }\n\n        #Check if there is seqfeatures before printing the FT line\n        my @feats = $seq->can('top_SeqFeatures') ? $seq->top_SeqFeatures : ();\n        if ($feats[0]) {\n            if ( defined $self->_post_sort ) {\n\n                # we need to read things into an array. Process. Sort them. Print 'em\n\n                my $post_sort_func = $self->_post_sort();\n                my @fth;\n\n                foreach my $sf ( @feats ) {\n                    push(@fth,Bio::SeqIO::FTHelper::from_SeqFeature($sf,$seq));\n                }\n                @fth = sort { &$post_sort_func($a,$b) } @fth;\n\n                foreach my $fth ( @fth ) {\n                    $self->_print_swissprot_FTHelper($fth);\n                }\n            } else {\n                # not post sorted. And so we can print as we get them.\n                # lower memory load...\n\n                foreach my $sf ( @feats ) {\n                    my @fth = Bio::SeqIO::FTHelper::from_SeqFeature($sf,$seq);\n                    foreach my $fth ( @fth ) {\n                        if ( ! $fth->isa('Bio::SeqIO::FTHelper') ) {\n                            $sf->throw(\"Cannot process FTHelper... $fth\");\n                        }\n                        $self->_print_swissprot_FTHelper($fth);\n                    }\n                }\n            }\n\n            if ( $self->_show_dna() == 0 ) {\n                return;\n            }\n        }\n        # finished printing features.\n\n        # molecular weight\n        my $mw = ${Bio::Tools::SeqStats->get_mol_wt($seq->primary_seq)}[0];\n        # checksum\n        # was crc32 checksum, changed it to crc64\n        my $crc64 = $self->_crc64(\\$str);\n        $self->_print( sprintf(\"SQ   SEQUENCE  %4d AA;  %d MW;  %16s CRC64;\\n\",\n                               $len,$mw,$crc64));\n        $self->_print( \"    \");\n        my $linepos;\n        for ($i = 0; $i < length($str); $i += 10) {\n            $self->_print( \" \", substr($str,$i,10));\n            $linepos += 11;\n            if ( ($i+10)%60 == 0 && (($i+10) < length($str))) {\n                $self->_print( \"\\n    \");\n            }\n        }\n        $self->_print( \"\\n//\\n\");\n\n        $self->flush if $self->_flush_on_write && defined $self->_fh;\n        return 1;\n    }\n}\n\n# Thanks to James Gilbert for the following two. LP 08/01/2000\n\n=head2 _generateCRCTable\n\n Title   : _generateCRCTable\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _generateCRCTable {\n  # 10001000001010010010001110000100\n  # 32\n    my $poly = 0xEDB88320;\n    my ($self) = shift;\n\n    $self->{'_crcTable'} = [];\n    foreach my $i (0..255) {\n        my $crc = $i;\n        for (my $j=8; $j > 0; $j--) {\n            if ($crc & 1) {\n                $crc = ($crc >> 1) ^ $poly;\n            } else {\n                $crc >>= 1;\n            }\n        }\n        ${$self->{'_crcTable'}}[$i] = $crc;\n    }\n}\n\n\n=head2 _crc32\n\n Title   : _crc32\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _crc32 {\n    my( $self, $str ) = @_;\n\n    $self->throw(\"Argument to crc32() must be ref to scalar\")\n        unless ref($str) eq 'SCALAR';\n\n    $self->_generateCRCTable() unless exists $self->{'_crcTable'};\n\n    my $len = length($$str);\n\n    my $crc = 0xFFFFFFFF;\n    for (my $i = 0; $i < $len; $i++) {\n        # Get upper case value of each letter\n        my $int = ord uc substr $$str, $i, 1;\n        $crc = (($crc >> 8) & 0x00FFFFFF) ^\n            ${$self->{'_crcTable'}}[ ($crc ^ $int) & 0xFF ];\n    }\n    return $crc;\n}\n\n=head2 _crc64\n\n Title   : _crc64\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _crc64{\n    my ($self, $sequence) = @_;\n    my $POLY64REVh = 0xd8000000;\n    my @CRCTableh = 256;\n    my @CRCTablel = 256;\n    my $initialized;\n\n    my $seq = $$sequence;\n\n    my $crcl = 0;\n    my $crch = 0;\n    if (!$initialized) {\n        $initialized = 1;\n        for (my $i=0; $i<256; $i++) {\n            my $partl = $i;\n            my $parth = 0;\n            for (my $j=0; $j<8; $j++) {\n                my $rflag = $partl & 1;\n                $partl >>= 1;\n                $partl |= (1 << 31) if $parth & 1;\n                $parth >>= 1;\n                $parth ^= $POLY64REVh if $rflag;\n            }\n            $CRCTableh[$i] = $parth;\n            $CRCTablel[$i] = $partl;\n        }\n    }\n\n    foreach (split '', $seq) {\n        my $shr = ($crch & 0xFF) << 24;\n        my $temp1h = $crch >> 8;\n        my $temp1l = ($crcl >> 8) | $shr;\n        my $tableindex = ($crcl ^ (unpack \"C\", $_)) & 0xFF;\n        $crch = $temp1h ^ $CRCTableh[$tableindex];\n        $crcl = $temp1l ^ $CRCTablel[$tableindex];\n    }\n    my $crc64 = sprintf(\"%08X%08X\", $crch, $crcl);\n    return $crc64;\n}\n\n=head2 _print_swissprot_FTHelper\n\n Title   : _print_swissprot_FTHelper\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _print_swissprot_FTHelper {\n    my ($self,$fth,$always_quote) = @_;\n    $always_quote ||= 0;\n    my ($start,$end) = ('?', '?');\n\n    if ( ! ref $fth || ! $fth->isa('Bio::SeqIO::FTHelper') ) {\n        $fth->warn(\"$fth is not a FTHelper class. \".\n                   \"Attempting to print, but there could be tears!\");\n    }\n    my $desc = \"\";\n\n    for my $tag ( qw(description gene note product) ) {\n        if ( exists $fth->field->{$tag} ) {\n            $desc = @{$fth->field->{$tag}}[0].\".\";\n            last;\n        }\n    }\n    $desc =~ s/\\.$//;\n\n    my $ftid = \"\";\n    if ( exists $fth->field->{'FTId'} ) {\n        $ftid = @{$fth->field->{'FTId'}}[0]. '.';\n    }\n\n    my $key =substr($fth->key,0,8);\n    my $loc = $fth->loc;\n    if ( $loc =~ /(\\?|\\d+|\\>\\d+|<\\d+)?\\.\\.(\\?|\\d+|<\\d+|>\\d+)?/ ) {\n        $start = $1 if defined $1;\n        $end = $2 if defined $2;\n\n        # to_FTString only returns one value when start == end, #JB955\n        # so if no match is found, assume it is both start and end #JB955\n    } elsif ( $loc =~ /join\\((\\d+)((?:,\\d+)+)?\\)/) {\n        my @y = ($1);\n        if ( defined( my $m = $2) ) {\n            $m =~ s/^\\,//;\n            push @y, split(/,/,$m);\n        }\n        for my $x ( @y ) {\n            $self->_write_line_swissprot_regex(\n                                               sprintf(\"FT   %-8s %6s %6s       \",\n                                                       $key,\n                                                       $x ,$x),\n                                               \"FT                                \",\n                                               $desc.'.','\\s+|$',$LINE_LENGTH);\n        }\n        return;\n    } else {\n        $start = $end = $fth->loc;\n    }\n    if ($desc) {\n        $self->_write_line_swissprot_regex(sprintf(\"FT   %-8s %6s %6s       \",\n                                                   $key,\n                                                   $start ,$end),\n                                           \"FT                                \",\n                                           $desc. '.', '\\s+|$', $LINE_LENGTH);\n    } else {                    #HELIX and STRAND do not have descriptions\n        $self->_write_line_swissprot_regex(sprintf(\"FT   %-8s %6s %6s\",\n                                                   $key,\n                                                   $start ,$end),\n                                           \"FT                         \",\n                                           ' ', '\\s+|$', $LINE_LENGTH);\n    }\n\n\n    if ($ftid) {\n        $self->_write_line_swissprot_regex(\"FT                                \",\n                                           \"FT                                \",\n                                           \"/FTId=$ftid\",'.|$',$LINE_LENGTH);\n\n    }\n\n}\n#'\n\n=head2 _read_swissprot_References\n\n Title   : _read_swissprot_References\n Usage   :\n Function: Reads references from swissprot format. Internal function really\n Example :\n Returns :\n Args    :\n\n\n\nsub _read_swissprot_References{\n    my ($self,$line) = @_;\n    my ($b1, $b2, $rp, $rg, $title, $loc, $au, $med, $com, $pubmed, $doi);\n    my @refs;\n    local $_ = $line;\n    while ( defined $_ ) {\n        if ( /^[^R]/ || /^RN/ ) {\n            if ( $rp ) {\n                $rg =~ s/;\\s*$//g if defined($rg);\n                if (defined($au)) {\n                    $au =~ s/;\\s*$//;\n                } else {\n                    $au = $rg;\n                }\n                $title =~ s/;\\s*$//g if defined($title);\n                push @refs, Bio::Annotation::Reference->new\n                    (-title   => $title,\n                     -start   => $b1,\n                     -end     => $b2,\n                     -authors => $au,\n                     -location=> $loc,\n                     -medline => $med,\n                     -pubmed  => $pubmed,\n                     -doi     => $doi,\n                     -comment => $com,\n                     -rp      => $rp,\n                     -rg      => $rg,\n                     -tagname => 'reference',\n                    );\n                # reset state for the next reference\n                $rp = '';\n            }\n            if (index($_,'R') != 0) {\n                $self->_pushback($_); # want this line to go back on the list\n                last;           # may be the safest exit point HL 05/11/2000\n            }\n            # don't forget to reset the state for the next reference\n            $b1 = $b2 = $rg = $med = $com = $pubmed = $doi = undef;\n            $title = $loc = $au = undef;\n        } elsif ( /^RP\\s{3}(.+? OF (\\d+)-(\\d+).*)/) {\n            $rp  .= $1;\n            $b1   = $2;\n            $b2   = $3;\n        } elsif ( /^RP\\s{3}(.*)/) {\n            if ($rp) {\n                $rp .= \" \".$1;\n            } else {\n                $rp = $1;\n            }\n        } elsif (/^RX\\s{3}(.*)/) { # each reference can have only one RX line\n            my $line = $1;\n            $med = $1 if $line =~ /MEDLINE=(\\d+);/;\n            $pubmed = $1 if $line =~ /PubMed=(\\d+);/;\n            $doi = $1 if $line =~ /DOI=(.+);/;\n        } elsif ( /^RA\\s{3}(.*)/ ) {\n            $au .= $au ? \" $1\" : $1;\n        } elsif ( /^RG\\s{3}(.*)/ ) {\n            $rg .= $rg ? \" $1\" : $1;\n        } elsif ( /^RT\\s{3}(.*)/ ) {\n            if ($title) {\n                my $tline = $1;\n                $title .= ($title =~ /[\\w;,:\\?!]$/) ? \" $tline\" : $tline;\n            } else {\n                $title = $1;\n            }\n        } elsif (/^RL\\s{3}(.*)/ ) {\n            $loc .= $loc ? \" $1\" : $1;\n        } elsif ( /^RC\\s{3}(.*)/ ) {\n            $com .= $com ? \" $1\" : $1;\n        }\n        $_ = $self->_readline;\n    }\n    return \\@refs;\n}\n\n\n=head2 _read_swissprot_Species\n\n Title   : _read_swissprot_Species\n Usage   :\n Function: Reads the swissprot Organism species and classification\n           lines.\n             Able to deal with unconventional species names.\n Example : OS Unknown prokaryotic organism\n             $genus = undef ; $species = Unknown prokaryotic organism\n Returns : A Bio::Species object\n Args    :\n\n\nsub _read_swissprot_Species {\n    my( $self,$line ) = @_;\n    my $org;\n    local $_ = $line;\n\n    my( $sub_species, $species, $genus, $common, $variant, $ncbi_taxid, $sci_name, $class_lines, $descr );\n    my $osline = \"\";\n    my $do_genus_check = 1;\n    while ( defined $_ ) {\n        last unless /^O[SCGX]/;\n        # believe it or not, but OS may come multiple times -- at this time\n        # we can't capture multiple species\n        if (/^OS\\s+(\\S.+)/ && (! defined($sci_name))) {\n            $osline .= \" \" if $osline;\n            $osline .= $1;\n            if ($osline =~ s/(,|, and|\\.)$//) {\n                # OS lines are usually like:\n                # Homo sapiens (human)\n                # where we have $sci_name followed by $descr (common name) in\n                # brackets, but we can also have:\n                # Venerupis (Ruditapes) philippinarum\n                # where we have brackets but they don't indicate a $descr\n                if ($osline =~ /[^\\(\\)]+\\(.+\\)[^\\(\\)]+$/) {\n                    #*** Danger! no idea if this will pick up some syntaxes for\n                    #    common names as well)\n                    $sci_name = $osline;\n                    $sci_name =~ s/\\.$//;\n                    $descr = '';\n                    $do_genus_check = 0;\n                } else {\n                    ($sci_name, $descr) = $osline =~ /(\\S[^\\(]+)(.*)/;\n                }\n                $sci_name =~ s/\\s+$//;\n\n                while ($descr =~ /\\(([^\\)]+)\\)/g) {\n                    my $item = $1;\n                    # strain etc may not necessarily come first (yes, swissprot\n                    # is messy)\n                    if ((! defined($variant)) &&\n                        (($item =~ /(^|[^\\(\\w])([Ss]train|isolate|serogroup|serotype|subtype|clone)\\b/) ||\n                         ($item =~ /^(biovar|pv\\.|type\\s+)/))) {\n                        $variant = $item;\n                    } elsif ($item =~ s/^subsp\\.\\s+//) {\n                        if (! $sub_species) {\n                            $sub_species = $item;\n                        } elsif (! $variant) {\n                            $variant = $item;\n                        }\n                    } elsif (! defined($common)) {\n                        # we're only interested in the first common name\n                        $common = $item;\n                        if ((index($common, '(') >= 0) &&\n                            (index($common, ')') < 0)) {\n                            $common .= ')';\n                        }\n                    }\n                }\n            }\n        } elsif (s/^OC\\s+(\\S.+)$//) {\n            $class_lines .= $1;\n        } elsif (/^OG\\s+(.*)/) {\n            $org = $1;\n        } elsif (/^OX\\s+(.*)/ && (! defined($ncbi_taxid))) {\n            my $taxstring = $1;\n            # we only keep the first one and ignore all others\n            if ($taxstring =~ /NCBI_TaxID=([\\w\\d]+)/) {\n                $ncbi_taxid = $1;\n            } else {\n                $self->throw(\"$taxstring doesn't look like NCBI_TaxID\");\n            }\n        }\n        $_ = $self->_readline;\n    }\n    $self->_pushback($_);       # pushback the last line because we need it\n\n    $sci_name || return;\n\n    # if the organism belongs to taxid 32644 then no Bio::Species object.\n    return if grep { $_ eq $sci_name } @Unknown_names;\n\n    # Convert data in classification lines into classification array.\n    # Remove trailing . then split on ';' or '.;' so that classification that is 2\n    # or more words will still get matched, use map() to remove trailing/leading/intervening\n    # spaces\n    $class_lines=~s/\\.\\s*$//;\n    my @class = map { s/^\\s+//; s/\\s+$//; s/\\s{2,}/ /g; $_; } split /[;\\.]*;/, $class_lines;\n\n    if ($class[0] =~ /viruses/i) {\n        # viruses have different OS/OC syntax\n        my @virusnames = split(/\\s+/, $sci_name);\n        $species = (@virusnames > 1) ? pop(@virusnames) : '';\n        $genus = join(\" \", @virusnames);\n        $sub_species = $descr;\n    } elsif ($do_genus_check) {\n        # do we have a genus?\n        my $possible_genus = $class[-1];\n        $possible_genus .= \"|$class[-2]\" if $class[-2];\n        if ($sci_name =~ /^($possible_genus)/) {\n            $genus = $1;\n            ($species) = $sci_name =~ /^$genus\\s+(.+)/;\n        } else {\n            $species = $sci_name;\n        }\n        # is this organism of rank species or is it lower?\n        # (doesn't catch everything, but at least the guess isn't dangerous)\n        if ($species && $species =~ /subsp\\.|var\\./) {\n            ($species, $sub_species) = $species =~ /(.+)\\s+((?:subsp\\.|var\\.).+)/;\n        }\n    }\n\n    # Bio::Species array needs array in Species -> Kingdom direction\n    unless ($class[-1] eq $sci_name) {\n        push(@class, $sci_name);\n    }\n    @class = reverse @class;\n\n    my $taxon = Bio::Species->new();\n    $taxon->scientific_name($sci_name);\n    $taxon->classification(@class);\n    $taxon->common_name($common) if $common;\n    $taxon->sub_species($sub_species) if $sub_species;\n    $taxon->organelle($org) if $org;\n    $taxon->ncbi_taxid($ncbi_taxid) if $ncbi_taxid;\n    $taxon->variant($variant) if $variant;\n\n    # done\n    return $taxon;\n}\n\n=head2 _filehandle\n\n Title   : _filehandle\n Usage   : $obj->_filehandle($newval)\n Function:\n Example :\n Returns : value of _filehandle\n Args    : newvalue (optional)\n\n\n\n# inherited from SeqIO.pm ! HL 05/11/2000\n\n=head2 _read_FTHelper_swissprot\n\n Title   : _read_FTHelper_swissprot\n Usage   : _read_FTHelper_swissprot(\\$buffer)\n Function: reads the next FT key line\n Example :\n Returns : Bio::SeqIO::FTHelper object\n Args    :","parameters":[{"label":"$self"},{"label":"$line"}],"label":"_read_FTHelper_swissprot($self,$line)"},"line":1266,"range":{"end":{"line":1320,"character":9999},"start":{"line":1266,"character":0}},"kind":12},{"line":1312,"name":"Bio","kind":12,"containerName":"SeqIO::FTHelper"},{"line":1322,"name":"%ftid","containerName":null,"kind":13},{"name":"$out","containerName":null,"kind":13,"line":1323},{"line":1323,"name":"field","kind":12,"containerName":"main::"},{"containerName":null,"kind":13,"name":"$ftid","line":1323},{"name":"$out","containerName":null,"kind":13,"line":1325},{"range":{"start":{"character":0,"line":1341},"end":{"character":9999,"line":1359}},"kind":12,"line":1341,"signature":{"parameters":[{"label":"$self"},{"label":"$pre1"},{"label":"$pre2"},{"label":"$line"},{"label":"$length"}],"documentation":"1;\n# $Id: swiss.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::swiss\n#\n# Copyright Elia Stupka\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::swiss - Swissprot sequence input/output stream\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system:\n\n    use Bio::SeqIO;\n\n    $stream = Bio::SeqIO->new(-file => $filename,\n                              -format => 'swiss');\n\n    while ( my $seq = $stream->next_seq() ) {\n       # do something with $seq\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from Swiss-Pprot flat\nfile databases.\n\nThere is a lot of flexibility here about how to dump things which needs\nto be documented.\n\n=head2 GN (Gene name) line management details\n\nA Uniprot/Swiss-Prot entry holds information on one protein\nsequence. If that sequence is identical across genes and species, they\nare all merged into one entry. This creates complex needs for several\nannotation fields in swiss-prot format.\n\nThe latest syntax for GN line is described in the user manual:\n\n  http://www.expasy.ch/sprot/userman.html#GN_line\n\nEach of the possibly multiple genes in an entry can have Name,\nSynonyms (only if there is a name), OrderedLocusNames (names from\ngenomic sequences) and ORFNames (temporary or cosmid names). \"Name\"\nhere really means \"symbol\". This complexity is now dealt with the\nfollowing way:\n\nA new Bio::AnnotationI class was created in order to store the\ndata in tag-value pairs.  This class (Bio::Annotation::TagTree)\nis stored in the Bio::Annotation::Collection object and is\naccessed like all other annotations. The tag name is 'gene_name'.\n\nThere is a single Bio::Annotation::TagTree per sequence record, which\ncorresponds to the original class that stored this data\n(Bio::Annotation::StructuredValue).  Depending on how we progress\nthis may change to represent each group of gene names.\n\nFor now, to access the gene name tree annotation, one uses the below method:\n\n   my ($gene) = $seq->annotation->get_Annotations('gene_name');\n\nIf you are only interested in displaying the values, value() returns a\nstring with similar formatting.\n\nThere are several ways to get directly at the information you want if you\nknow the element (tag) for the data.  For gene names all data is stored with\nthe element-tag pairs:\n\n  \"element1=tag1, tag2, tag3; element2=tag4, tag5;\"\n\nThis normally means the element will be 'Name', 'Synonyms', etc. and the\ngene names the values.  Using findval(), you can do the following:\n\n  # grab a flattened list of all gene names\n  my @names = $ann->findval('Name');\n\n  # or iterated through the nodes and grab the name for each group\n  for my $node ($ann->findnode('gene_name')) {\n     my @names = $node->findval('Name');\n  }\n\nThe current method for parsing gene name data (and reconstructing gene name\noutput) is very generic. This is somewhat preemptive if, for instance, UniProt\ndecides to update and add another element name to the current ones using the\nsame formatting layout. Under those circumstances, one can iterate through the\ntag tree in a safe way and retrieve all node data like so.\n\n  # retrieve the gene name nodes (groups like names, synonyms, etc).\n  for my $ann ($seq->annotation->get_Annotations('gene_name')) {\n\n      # each gene name group\n      for my $node ($ann->findnode('gene_name')) {\n          print \"Gene name:\\n\";\n\n          # each gene name node (tag => value pair)\n          for my $n ($node->children) {\n              print \"\\t\".$n->element.\": \".$n->children.\"\\n\";\n          }\n      }\n  }\n\nFor more uses see Bio::Annotation::TagTree.\n\nSince Uniprot/Swiss-Prot format have been around for quite some time, the\nparser is also able to read in the older GN line syntax where genes\nare separated by AND and various symbols by OR. The first symbol is\ntaken to be the 'Name' and the remaining ones are stored as 'Synonyms'.\n\n=head2 Optional functions\n\n=over 3\n\n* _show_dna()\n\n(output only) shows the dna or not\n\n* _post_sort()\n\n(output only) provides a sorting func which is applied to the FTHelpers\nbefore printing\n\n* _id_generation_func()\n\nThis is function which is called as\n\n   print \"ID   \", $func($seq), \"\\n\";\n\nTo generate the ID line. If it is not there, it generates a sensible ID\nline using a number of tools.\n\nIf you want to output annotations in Swissprot format they need to be\nstored in a Bio::Annotation::Collection object which is accessible\nthrough the Bio::SeqI interface method L<annotation()|annotation>.\n\nThe following are the names of the keys which are polled from a\nL<Bio::Annotation::Collection> object.\n\n reference   - Should contain Bio::Annotation::Reference objects\n comment     - Should contain Bio::Annotation::Comment objects\n dblink      - Should contain Bio::Annotation::DBLink objects\n gene_name   - Should contain Bio::Annotation::SimpleValue object\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions,\npreferably to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Elia Stupka\n\nEmail elia@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::swiss;\nuse vars qw(@Unknown_names @Unknown_genus);\nuse strict;\nuse Bio::SeqIO::FTHelper;\nuse Bio::SeqFeature::Generic;\nuse Bio::Species;\nuse Bio::Tools::SeqStats;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::Comment;\nuse Bio::Annotation::Reference;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::TagTree;\n\nuse base qw(Bio::SeqIO);\n\nour $LINE_LENGTH = 76;\n\n# this is for doing species name parsing\n@Unknown_names=('other', 'unidentified',\n                'unknown organism', 'not specified',\n                'not shown', 'Unspecified', 'Unknown',\n                'None', 'unclassified', 'unidentified organism',\n                'not supplied'\n               );\n# dictionary of synonyms for taxid 32644\n# all above can be part of valid species name\n@Unknown_genus = qw(unknown unclassified uncultured unidentified);\n\n# if there are any other gene name tags, they are added to the end\nour @GENE_NAME_ORDER = qw(Name Synonyms OrderedLocusNames ORFNames);\n\nsub _initialize {\n    my($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    # hash for functions for decoding keys.\n    $self->{'_func_ftunit_hash'} = {};\n    # sets this to one by default. People can change it\n    $self->_show_dna(1);\n    if ( ! defined $self->sequence_factory ) {\n        $self->sequence_factory(Bio::Seq::SeqFactory->new\n                                (-verbose => $self->verbose(),\n                                 -type => 'Bio::Seq::RichSeq'));\n    }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    :\n\n\nsub next_seq {\n    my ($self,@args) = @_;\n    my ($pseq,$c,$line,$name,$desc,$acc,$seqc,$mol,$div, $sptr,$seq_div,\n        $date,$comment,@date_arr);\n    my $genename = \"\";\n    my ($annotation, %params, @features) = ( Bio::Annotation::Collection->new());\n\n    local $_;\n\n    1 while defined($_ = $self->_readline) && /^\\s+$/;\n    return unless defined $_ && /^ID\\s/;\n\n    # fixed to allow _DIVISION to be optional for bug #946\n    # see bug report for more information\n    #\n    # 9/6/06 Note: Swiss/TrEMBL sequences have no division acc. to UniProt\n    # release notes; this is fixed to simplify the regex parsing\n    # STANDARD (SwissProt) and PRELIMINARY (TrEMBL) added to namespace()\n    unless(  m{^\n               ID              \\s+     #\n               (\\S+)           \\s+     #  $1  entryname\n               ([^\\s;]+);      \\s+     #  $2  DataClass\n               (?:PRT;)?       \\s+     #  Molecule Type (optional)\n               [0-9]+[ ]AA     \\.      #  Sequencelength (capture?)\n               $\n           }ox ) {\n            # I couldn't find any new current UniProt sequences\n            # that matched this format:\n            # || m/^ID\\s+(\\S+)\\s+(_([^\\s_]+))? /ox ) {\n        $self->throw(\"swissprot stream with no ID. Not swissprot in my book\");\n    }\n    ($name, $seq_div) = ($1, $2);\n    $params{'-namespace'} =\n        ($seq_div eq 'Reviewed'   || $seq_div eq 'STANDARD')     ? 'Swiss-Prot' :\n        ($seq_div eq 'Unreviewed' || $seq_div eq 'PRELIMINARY')  ? 'TrEMBL'     :\n         $seq_div;\n    # we shouldn't be setting the division, but for now...\n    my ($junk, $division) = split q(_), $name;\n    $params{'-division'} = $division;\n    $params{'-alphabet'} = 'protein';\n    # this is important to have the id for display in e.g. FTHelper, otherwise\n    # you won't know which entry caused an error\n    $params{'-display_id'} = $name;\n\n    BEFORE_FEATURE_TABLE :\n          while ( defined($_ = $self->_readline) ) {\n              # Exit at start of Feature table and at the sequence at the\n              # latest HL 05/11/2000\n              last if( /^(FT|SQ)/ );\n\n              # Description line(s)\n              if (/^DE\\s+(\\S.*\\S)/) {\n                  $desc .= $desc ? \" $1\" : $1;\n              }\n              #Gene name\n              elsif (/^GN\\s+(.*)/) {\n                  $genename .= \" \" if $genename;\n                  $genename .= $1;\n              }\n              #accession number(s)\n              elsif ( /^AC\\s+(.+)/) {\n                  my @accs = split(/[; ]+/, $1); # allow space in addition\n                  $params{'-accession_number'} = shift @accs\n                      unless defined $params{'-accession_number'};\n                  push @{$params{'-secondary_accessions'}}, @accs;\n              }\n              #date and sequence version\n              elsif ( /^DT\\s+(.*)/ ) {\n                  my $line = $1;\n                  my ($date, $version) = split(' ', $line, 2);\n                  $date =~ tr/,//d; # remove comma if new version\n                  if ($version =~ /\\(Rel\\. (\\d+), Last sequence update\\)/ || # old\n                      /sequence version (\\d+)/) { #new\n                      my $update = Bio::Annotation::SimpleValue->new\n                          (-tagname    => 'seq_update',\n                           -value      => $1\n                          );\n                      $annotation->add_Annotation($update);\n                  } elsif ($version =~ /\\(Rel\\. (\\d+), Last annotation update\\)/ || #old\n                           /entry version (\\d+)/) { #new\n                      $params{'-version'} = $1;\n                  }\n                  push @{$params{'-dates'}}, $date;\n              }\n              # Evidence level\n              elsif ( /^PE\\s+(.*)/ ) {\n                  my $line = $1;\n                  $line =~ s/;\\s*//; # trim trailing semicolon and any spaces at the end of the line\n                  my $evidence = Bio::Annotation::SimpleValue->new\n                      (-tagname   => 'evidence',\n                       -value     => $line\n                      );\n                  $annotation->add_Annotation($evidence);\n              }\n              # Organism name and phylogenetic information\n              elsif (/^O[SCG]/) {\n                  my $species = $self->_read_swissprot_Species($_);\n                  $params{'-species'}= $species;\n                  # now we are one line ahead -- so continue without reading the next\n                  # line   HL 05/11/2000\n              }\n              # References\n              elsif (/^R/) {\n                  my $refs = $self->_read_swissprot_References($_);\n                  foreach my $r (@$refs) {\n                      $annotation->add_Annotation('reference',$r);\n                  }\n              }\n              # Comments\n              elsif (/^CC\\s{3}(.*)/) {\n                  $comment .= $1;\n                  $comment .= \"\\n\";\n                  while (defined ($_ = $self->_readline) && /^CC\\s{3}(.*)/ ) {\n                      $comment .= $1 . \"\\n\";\n                  }\n\n                  # note: don't try to process comments here -- they may contain\n                  # structure. LP 07/30/2000\n\n                  my $commobj = Bio::Annotation::Comment->new(-tagname => 'comment',\n                                                              -text    => $comment);\n                  $annotation->add_Annotation('comment',$commobj);\n                  $comment = \"\";\n                  $self->_pushback($_);\n              }\n              #DBLinks\n              # old regexp\n              # /^DR\\s+(\\S+)\\;\\s+(\\S+)\\;\\s+(\\S+)[\\;\\.](.*)$/) {\n              # new regexp from Andreas Kahari  bug #1584\n              elsif (/^DR\\s+(\\S+)\\;\\s+(\\S+)\\;\\s+([^;]+)[\\;\\.](.*)$/) {\n                  my ($database,$primaryid,$optional,$comment) = ($1,$2,$3,$4);\n\n                  # drop leading and training spaces and trailing .\n                  $comment =~ s/\\.\\s*$//;\n                  $comment =~ s/^\\s+//;\n\n                  my $dblinkobj =  Bio::Annotation::DBLink->new\n                      (-database    => $database,\n                       -primary_id  => $primaryid,\n                       -optional_id => $optional,\n                       -comment     => $comment,\n                       -tagname     => 'dblink',\n                      );\n\n                  $annotation->add_Annotation('dblink',$dblinkobj);\n              }\n              #keywords\n              elsif ( /^KW\\s+(.*)$/ ) {\n                  my @kw = split(/\\s*\\;\\s*/,$1);\n                  defined $kw[-1] && $kw[-1] =~ s/\\.$//;\n                  push @{$params{'-keywords'}}, @kw;\n              }\n          }\n    # process and parse the gene name line if there was one (note: we\n    # can't do this above b/c GN may be multi-line and we can't\n    # unequivocally determine whether we've seen the last GN line in\n    # the new format)\n    if ($genename) {\n        my @stags;\n        if ($genename =~ /\\w=\\w/) {\n            # new format (e.g., Name=RCHY1; Synonyms=ZNF363, CHIMP)\n            for my $n (split(m{\\s+and\\s+},$genename)) {\n                my @genenames;\n                for my $section (split(m{\\s*;\\s*},$n)) {\n                    my ($tag, $rest) = split(\"=\",$section);\n                    $rest ||= '';\n                    for my $val (split(m{\\s*,\\s*},$rest)) {\n                        push @genenames, [$tag => $val];\n                    }\n                }\n                push @stags, ['gene_name' => \\@genenames];\n            }\n        } else {\n            # old format\n            for my $section (split(/ AND /, $genename)) {\n                my @genenames;\n                $section =~ s/[\\(\\)\\.]//g;\n                my @names = split(m{\\s+OR\\s+}, $section);\n                push @genenames, ['Name' => shift @names];\n                push @genenames, map {['Synonyms' => $_]} @names;\n                push @stags, ['gene_name' => \\@genenames]            \n            }\n        } #use Data::Dumper; print Dumper $gn, $genename;# exit;\n        my $gn = Bio::Annotation::TagTree->new(-tagname => 'gene_name',\n                                               -value => ['gene_names' => \\@stags]);\n        $annotation->add_Annotation('gene_name', $gn);\n    }\n\n    FEATURE_TABLE :\n          # if there is no feature table, or if we've got beyond, exit loop or don't\n          # even enter    HL 05/11/2000\n          while (defined $_ && /^FT/ ) {\n              my $ftunit = $self->_read_FTHelper_swissprot($_);\n\n              # process ftunit\n              # when parsing of the line fails we get undef returned\n              if ($ftunit) {\n                  push(@features,\n                       $ftunit->_generic_seqfeature($self->location_factory(),\n                                                    $params{'-seqid'}, \"SwissProt\"));\n              } else {\n                  $self->warn(\"failed to parse feature table line for seq \" .\n                              $params{'-display_id'}. \"\\n$_\");\n              }\n              $_ = $self->_readline;\n          }\n    while ( defined($_) && ! /^SQ/ ) {\n        $_ = $self->_readline;\n    }\n    $seqc = \"\";\n    while ( defined ($_ = $self->_readline) ) {\n        last if m{^//};\n        s/[^A-Za-z]//g;\n        $seqc .= uc($_);\n    }\n\n    my $seq=  $self->sequence_factory->create\n        (-verbose  => $self->verbose,\n         %params,\n         -seq      => $seqc,\n         -desc     => $desc,\n         -features => \\@features,\n         -annotation => $annotation,\n        );\n\n    # The annotation doesn't get added by the contructor\n    $seq->annotation($annotation);\n\n    return $seq;\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq($seq)\n Function: writes the $seq object (must be seq) to the stream\n Returns : 1 for success and 0 for error\n Args    : array of 1 to n Bio::SeqI objects\n\n\n\nsub write_seq {\n    my ($self,@seqs) = @_;\n    foreach my $seq ( @seqs ) {\n        $self->throw(\"Attempting to write with no seq!\") unless defined $seq;\n\n        if ( ! ref $seq || ! $seq->isa('Bio::SeqI') ) {\n            $self->warn(\" $seq is not a SeqI compliant module. Attempting to dump, but may fail!\");\n        }\n\n        my $i;\n        my $str = $seq->seq;\n\n        my $div;\n        my $ns = ($seq->can('namespace')) && $seq->namespace();\n        my $len = $seq->length();\n\n        if ( !$seq->can('division') || ! defined ($div = $seq->division()) ) {\n            $div = 'UNK';\n        }\n\n        # namespace dictates database, takes precedent over division. Sorry!\n        if (defined($ns)) {\n            $div = ($ns eq 'Swiss-Prot') ? 'Reviewed'    :\n                ($ns eq 'TrEMBL')     ? 'Unreviewed' :\n                    $ns;\n        } else {\n            $ns = 'Swiss-Prot';\n            # division not reset; acts as fallback\n        }\n\n        $self->warn(\"No whitespace allowed in SWISS-PROT display id [\". $seq->display_id. \"]\")\n            if $seq->display_id =~ /\\s/;\n\n        my $temp_line;\n        if ( $self->_id_generation_func ) {\n            $temp_line = &{$self->_id_generation_func}($seq);\n        } else {\n            #$temp_line = sprintf (\"%10s     STANDARD;      %3s;   %d AA.\",\n            #            $seq->primary_id().\"_\".$div,$mol,$len);\n            # Reconstructing the ID relies heavily upon the input source having\n            # been in a format that is parsed as this routine expects it -- that is,\n            # by this module itself. This is bad, I think, and immediately breaks\n            # if e.g. the Bio::DB::GenPept module is used as input.\n            # Hence, switch to display_id(); _every_ sequence is supposed to have\n            # this. HL 2000/09/03\n            # Changed to reflect ID line changes in UniProt\n            # Oct 2006 - removal of molecule type - see bug 2134\n            $temp_line = sprintf (\"%-24s%-12s%9d AA.\",\n                                  $seq->display_id(), $div.';', $len);\n        }\n\n        $self->_print( \"ID   $temp_line\\n\");\n\n        # if there, write the accession line\n        local($^W) = 0;         # supressing warnings about uninitialized fields\n\n        if ( $self->_ac_generation_func ) {\n            $temp_line = &{$self->_ac_generation_func}($seq);\n            $self->_print( \"AC   $temp_line\\n\");\n        }\n        elsif ($seq->can('accession_number') ) {\n            my $ac_line = $seq->accession_number;\n            if ($seq->can('get_secondary_accessions') ) {\n                foreach my $sacc ($seq->get_secondary_accessions) {\n                    $ac_line .= \"; \". $sacc;;\n                }\n                $ac_line .= \";\";\n            }\n\n            $self->_write_line_swissprot_regex(\"AC   \",\"AC   \",$ac_line,\n                                               \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n        }\n        # otherwise - cannot print <sigh>\n\n\n        # Date lines and sequence versions (changed 6/15/2006)\n        # This is rebuilt from scratch using the current SwissProt/UniProt format\n        if ( $seq->can('get_dates') ) {\n            my @dates =  $seq->get_dates();\n            my $ct = 1;\n            my $seq_version = $seq->version;\n            my ($update_version) = $seq->annotation->get_Annotations(\"seq_update\");\n            foreach my $dt (@dates) {\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.', integrated into UniProtKB/'.$ns.'.',\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 1;\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.\", sequence version \".$update_version->display_text.'.',\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 2;\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.\", entry version $seq_version.\",\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 3;\n                $ct++;\n            }\n        }\n\n        #Definition lines\n        $self->_write_line_swissprot_regex(\"DE   \",\"DE   \",$seq->desc(),\"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n\n        #Gene name; print out new format\n        foreach my $gene ( my @genes = $seq->annotation->get_Annotations('gene_name') ) {\n            # gene is a Bio::Annotation::TagTree;\n            my @genelines;\n            for my $node ($gene->findnode('gene_name')) {\n                # check for Name and Synonym first, then the rest get tagged on\n                my $geneline = \"GN   \";\n                my %genedata = $node->hash;\n                for my $tag (@GENE_NAME_ORDER) {\n                    if (exists $genedata{$tag}) {\n                        $geneline .= (ref $genedata{$tag} eq 'ARRAY') ?\n                            \"$tag=\".join(', ',@{$genedata{$tag}}).\"; \" :\n                            \"$tag=$genedata{$tag}; \";\n                        delete $genedata{$tag};\n                    }\n                }\n                # add rest\n                for my $tag (sort keys %genedata) {\n                    $geneline .= (ref $genedata{$tag} eq 'ARRAY') ?\n                        \"$tag=\".join(', ',@{$genedata{$tag}}).\"; \" :\n                        \"$tag=$genedata{$tag}; \";\n                    delete $genedata{$tag};\n                }\n                push @genelines, \"$geneline\\n\";\n            }\n            $self->_print(join(\"GN   and\\n\",@genelines));\n        }\n\n        # Organism lines\n        if ($seq->can('species') && (my $spec = $seq->species)) {\n            my @class = $spec->classification();\n            shift(@class);\n            my $species = $spec->species;\n            my $genus = $spec->genus;\n            my $OS = $spec->scientific_name;\n            if ($class[-1] =~ /viruses/i) {\n                $OS = $species;\n                $OS .=  \" \". $spec->sub_species if $spec->sub_species;\n            }\n            foreach (($spec->variant, $spec->common_name)) {\n                $OS .= \" ($_)\" if $_;\n            }\n            $self->_print( \"OS   $OS.\\n\");\n            my $OC = join('; ', reverse(@class)) .'.';\n            $self->_write_line_swissprot_regex(\"OC   \",\"OC   \",$OC,\"\\; \\|\\$\",$LINE_LENGTH);\n            if ($spec->organelle) {\n                $self->_write_line_swissprot_regex(\"OG   \",\"OG   \",$spec->organelle,\"\\; \\|\\$\",$LINE_LENGTH);\n            }\n            if ($spec->ncbi_taxid) {\n                $self->_print(\"OX   NCBI_TaxID=\".$spec->ncbi_taxid.\";\\n\");\n            }\n        }\n\n        # Reference lines\n        my $t = 1;\n        foreach my $ref ( $seq->annotation->get_Annotations('reference') ) {\n            $self->_print( \"RN   [$t]\\n\");\n            # changed by lorenz 08/03/00\n            # j.gilbert and h.lapp agreed that the rp line in swissprot seems\n            # more like a comment than a parseable value, so print it as is\n            if ($ref->rp) {\n                $self->_write_line_swissprot_regex(\"RP   \",\"RP   \",$ref->rp,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            }\n            if ($ref->comment) {\n                $self->_write_line_swissprot_regex(\"RC   \",\"RC   \",$ref->comment,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            }\n            if ($ref->medline or $ref->pubmed or $ref->doi) {\n                # new RX format in swissprot LP 09/17/00\n                # RX line can now have a DOI, Heikki 13 Feb 2008\n\n                my $line;\n                $line .= \"MEDLINE=\". $ref->medline. '; ' if $ref->medline;\n                $line .= \"PubMed=\". $ref->pubmed. '; ' if $ref->pubmed;\n                $line .= \"DOI=\". $ref->doi. '; ' if $ref->doi;\n                chop $line;\n\n                $self->_write_line_swissprot_regex(\"RX   \",\"RX   \",\n                                                   $line,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n\n            }\n            my $author = $ref->authors .';' if($ref->authors);\n            my $title = $ref->title .';' if( $ref->title);\n            my $rg = $ref->rg . ';' if $ref->rg;\n            $author =~ s/([\\w\\.]) (\\w)/$1#$2/g;  # add word wrap protection char '#'\n\n            $self->_write_line_swissprot_regex(\"RG   \",\"RG   \",$rg,\"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $rg;\n            $self->_write_line_swissprot_regex(\"RA   \",\"RA   \",$author,\"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $author;\n            $self->_write_line_swissprot_regex(\"RT   \",\"RT   \",$title,'[\\s\\-]+|$',$LINE_LENGTH) if $title;\n            $self->_write_line_swissprot_regex(\"RL   \",\"RL   \",$ref->location,\"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            $t++;\n        }\n\n        # Comment lines\n\n        foreach my $comment ( $seq->annotation->get_Annotations('comment') ) {\n            foreach my $cline (split (\"\\n\", $comment->text)) {\n                while (length $cline > 74) {\n                    $self->_print(\"CC   \",(substr $cline,0,74),\"\\n\");\n                    $cline = substr $cline,74;\n                }\n                $self->_print(\"CC   \",$cline,\"\\n\");\n            }\n        }\n\n        # Database xref lines\n\n        foreach my $dblink ( $seq->annotation->get_Annotations('dblink') ) {\n            my ($primary_id) = $dblink->primary_id;\n\t\n            if (defined($dblink->comment) && ($dblink->comment) ) {\n                $self->_print(\"DR   \",$dblink->database,\"; \",$primary_id,\"; \",\n                              $dblink->optional_id,\"; \",$dblink->comment,\".\\n\");\n            } elsif ($dblink->optional_id) {\n                $self->_print(\"DR   \",$dblink->database,\"; \",\n                              $primary_id,\"; \",\n                              $dblink->optional_id,\".\\n\");\n            } else {\n                $self->_print(\"DR   \",$dblink->database,\n                              \"; \",$primary_id,\"; \",\"-.\\n\");\n            }\n        }\n\n        # Evidence lines\n\n        foreach my $evidence ( $seq->annotation->get_Annotations('evidence') ) {\n            $self->_print(\"PE   \",$evidence->value,\";\\n\");\n        }\n\n        # if there, write the kw line\n        {\n            my $kw;\n            if ( my $func = $self->_kw_generation_func ) {\n                $kw = &{$func}($seq);\n            } elsif ( $seq->can('keywords') ) {\n                $kw = $seq->keywords;\n                if ( ref($kw) =~ /ARRAY/i ) {\n                    $kw = join(\"; \", @$kw);\n                }\n                $kw .= '.' if $kw and $kw !~ /\\.$/ ;\n            }\n            $kw =~ s/([\\w\\.]) (\\w)/$1#$2/g;  # add word wrap protection char '#'\n            $self->_write_line_swissprot_regex(\"KW   \",\"KW   \",\n                                               $kw, \"\\\\s\\+\\|\\$\",$LINE_LENGTH)\n                if $kw;\n        }\n\n        #Check if there is seqfeatures before printing the FT line\n        my @feats = $seq->can('top_SeqFeatures') ? $seq->top_SeqFeatures : ();\n        if ($feats[0]) {\n            if ( defined $self->_post_sort ) {\n\n                # we need to read things into an array. Process. Sort them. Print 'em\n\n                my $post_sort_func = $self->_post_sort();\n                my @fth;\n\n                foreach my $sf ( @feats ) {\n                    push(@fth,Bio::SeqIO::FTHelper::from_SeqFeature($sf,$seq));\n                }\n                @fth = sort { &$post_sort_func($a,$b) } @fth;\n\n                foreach my $fth ( @fth ) {\n                    $self->_print_swissprot_FTHelper($fth);\n                }\n            } else {\n                # not post sorted. And so we can print as we get them.\n                # lower memory load...\n\n                foreach my $sf ( @feats ) {\n                    my @fth = Bio::SeqIO::FTHelper::from_SeqFeature($sf,$seq);\n                    foreach my $fth ( @fth ) {\n                        if ( ! $fth->isa('Bio::SeqIO::FTHelper') ) {\n                            $sf->throw(\"Cannot process FTHelper... $fth\");\n                        }\n                        $self->_print_swissprot_FTHelper($fth);\n                    }\n                }\n            }\n\n            if ( $self->_show_dna() == 0 ) {\n                return;\n            }\n        }\n        # finished printing features.\n\n        # molecular weight\n        my $mw = ${Bio::Tools::SeqStats->get_mol_wt($seq->primary_seq)}[0];\n        # checksum\n        # was crc32 checksum, changed it to crc64\n        my $crc64 = $self->_crc64(\\$str);\n        $self->_print( sprintf(\"SQ   SEQUENCE  %4d AA;  %d MW;  %16s CRC64;\\n\",\n                               $len,$mw,$crc64));\n        $self->_print( \"    \");\n        my $linepos;\n        for ($i = 0; $i < length($str); $i += 10) {\n            $self->_print( \" \", substr($str,$i,10));\n            $linepos += 11;\n            if ( ($i+10)%60 == 0 && (($i+10) < length($str))) {\n                $self->_print( \"\\n    \");\n            }\n        }\n        $self->_print( \"\\n//\\n\");\n\n        $self->flush if $self->_flush_on_write && defined $self->_fh;\n        return 1;\n    }\n}\n\n# Thanks to James Gilbert for the following two. LP 08/01/2000\n\n=head2 _generateCRCTable\n\n Title   : _generateCRCTable\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _generateCRCTable {\n  # 10001000001010010010001110000100\n  # 32\n    my $poly = 0xEDB88320;\n    my ($self) = shift;\n\n    $self->{'_crcTable'} = [];\n    foreach my $i (0..255) {\n        my $crc = $i;\n        for (my $j=8; $j > 0; $j--) {\n            if ($crc & 1) {\n                $crc = ($crc >> 1) ^ $poly;\n            } else {\n                $crc >>= 1;\n            }\n        }\n        ${$self->{'_crcTable'}}[$i] = $crc;\n    }\n}\n\n\n=head2 _crc32\n\n Title   : _crc32\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _crc32 {\n    my( $self, $str ) = @_;\n\n    $self->throw(\"Argument to crc32() must be ref to scalar\")\n        unless ref($str) eq 'SCALAR';\n\n    $self->_generateCRCTable() unless exists $self->{'_crcTable'};\n\n    my $len = length($$str);\n\n    my $crc = 0xFFFFFFFF;\n    for (my $i = 0; $i < $len; $i++) {\n        # Get upper case value of each letter\n        my $int = ord uc substr $$str, $i, 1;\n        $crc = (($crc >> 8) & 0x00FFFFFF) ^\n            ${$self->{'_crcTable'}}[ ($crc ^ $int) & 0xFF ];\n    }\n    return $crc;\n}\n\n=head2 _crc64\n\n Title   : _crc64\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _crc64{\n    my ($self, $sequence) = @_;\n    my $POLY64REVh = 0xd8000000;\n    my @CRCTableh = 256;\n    my @CRCTablel = 256;\n    my $initialized;\n\n    my $seq = $$sequence;\n\n    my $crcl = 0;\n    my $crch = 0;\n    if (!$initialized) {\n        $initialized = 1;\n        for (my $i=0; $i<256; $i++) {\n            my $partl = $i;\n            my $parth = 0;\n            for (my $j=0; $j<8; $j++) {\n                my $rflag = $partl & 1;\n                $partl >>= 1;\n                $partl |= (1 << 31) if $parth & 1;\n                $parth >>= 1;\n                $parth ^= $POLY64REVh if $rflag;\n            }\n            $CRCTableh[$i] = $parth;\n            $CRCTablel[$i] = $partl;\n        }\n    }\n\n    foreach (split '', $seq) {\n        my $shr = ($crch & 0xFF) << 24;\n        my $temp1h = $crch >> 8;\n        my $temp1l = ($crcl >> 8) | $shr;\n        my $tableindex = ($crcl ^ (unpack \"C\", $_)) & 0xFF;\n        $crch = $temp1h ^ $CRCTableh[$tableindex];\n        $crcl = $temp1l ^ $CRCTablel[$tableindex];\n    }\n    my $crc64 = sprintf(\"%08X%08X\", $crch, $crcl);\n    return $crc64;\n}\n\n=head2 _print_swissprot_FTHelper\n\n Title   : _print_swissprot_FTHelper\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _print_swissprot_FTHelper {\n    my ($self,$fth,$always_quote) = @_;\n    $always_quote ||= 0;\n    my ($start,$end) = ('?', '?');\n\n    if ( ! ref $fth || ! $fth->isa('Bio::SeqIO::FTHelper') ) {\n        $fth->warn(\"$fth is not a FTHelper class. \".\n                   \"Attempting to print, but there could be tears!\");\n    }\n    my $desc = \"\";\n\n    for my $tag ( qw(description gene note product) ) {\n        if ( exists $fth->field->{$tag} ) {\n            $desc = @{$fth->field->{$tag}}[0].\".\";\n            last;\n        }\n    }\n    $desc =~ s/\\.$//;\n\n    my $ftid = \"\";\n    if ( exists $fth->field->{'FTId'} ) {\n        $ftid = @{$fth->field->{'FTId'}}[0]. '.';\n    }\n\n    my $key =substr($fth->key,0,8);\n    my $loc = $fth->loc;\n    if ( $loc =~ /(\\?|\\d+|\\>\\d+|<\\d+)?\\.\\.(\\?|\\d+|<\\d+|>\\d+)?/ ) {\n        $start = $1 if defined $1;\n        $end = $2 if defined $2;\n\n        # to_FTString only returns one value when start == end, #JB955\n        # so if no match is found, assume it is both start and end #JB955\n    } elsif ( $loc =~ /join\\((\\d+)((?:,\\d+)+)?\\)/) {\n        my @y = ($1);\n        if ( defined( my $m = $2) ) {\n            $m =~ s/^\\,//;\n            push @y, split(/,/,$m);\n        }\n        for my $x ( @y ) {\n            $self->_write_line_swissprot_regex(\n                                               sprintf(\"FT   %-8s %6s %6s       \",\n                                                       $key,\n                                                       $x ,$x),\n                                               \"FT                                \",\n                                               $desc.'.','\\s+|$',$LINE_LENGTH);\n        }\n        return;\n    } else {\n        $start = $end = $fth->loc;\n    }\n    if ($desc) {\n        $self->_write_line_swissprot_regex(sprintf(\"FT   %-8s %6s %6s       \",\n                                                   $key,\n                                                   $start ,$end),\n                                           \"FT                                \",\n                                           $desc. '.', '\\s+|$', $LINE_LENGTH);\n    } else {                    #HELIX and STRAND do not have descriptions\n        $self->_write_line_swissprot_regex(sprintf(\"FT   %-8s %6s %6s\",\n                                                   $key,\n                                                   $start ,$end),\n                                           \"FT                         \",\n                                           ' ', '\\s+|$', $LINE_LENGTH);\n    }\n\n\n    if ($ftid) {\n        $self->_write_line_swissprot_regex(\"FT                                \",\n                                           \"FT                                \",\n                                           \"/FTId=$ftid\",'.|$',$LINE_LENGTH);\n\n    }\n\n}\n#'\n\n=head2 _read_swissprot_References\n\n Title   : _read_swissprot_References\n Usage   :\n Function: Reads references from swissprot format. Internal function really\n Example :\n Returns :\n Args    :\n\n\n\nsub _read_swissprot_References{\n    my ($self,$line) = @_;\n    my ($b1, $b2, $rp, $rg, $title, $loc, $au, $med, $com, $pubmed, $doi);\n    my @refs;\n    local $_ = $line;\n    while ( defined $_ ) {\n        if ( /^[^R]/ || /^RN/ ) {\n            if ( $rp ) {\n                $rg =~ s/;\\s*$//g if defined($rg);\n                if (defined($au)) {\n                    $au =~ s/;\\s*$//;\n                } else {\n                    $au = $rg;\n                }\n                $title =~ s/;\\s*$//g if defined($title);\n                push @refs, Bio::Annotation::Reference->new\n                    (-title   => $title,\n                     -start   => $b1,\n                     -end     => $b2,\n                     -authors => $au,\n                     -location=> $loc,\n                     -medline => $med,\n                     -pubmed  => $pubmed,\n                     -doi     => $doi,\n                     -comment => $com,\n                     -rp      => $rp,\n                     -rg      => $rg,\n                     -tagname => 'reference',\n                    );\n                # reset state for the next reference\n                $rp = '';\n            }\n            if (index($_,'R') != 0) {\n                $self->_pushback($_); # want this line to go back on the list\n                last;           # may be the safest exit point HL 05/11/2000\n            }\n            # don't forget to reset the state for the next reference\n            $b1 = $b2 = $rg = $med = $com = $pubmed = $doi = undef;\n            $title = $loc = $au = undef;\n        } elsif ( /^RP\\s{3}(.+? OF (\\d+)-(\\d+).*)/) {\n            $rp  .= $1;\n            $b1   = $2;\n            $b2   = $3;\n        } elsif ( /^RP\\s{3}(.*)/) {\n            if ($rp) {\n                $rp .= \" \".$1;\n            } else {\n                $rp = $1;\n            }\n        } elsif (/^RX\\s{3}(.*)/) { # each reference can have only one RX line\n            my $line = $1;\n            $med = $1 if $line =~ /MEDLINE=(\\d+);/;\n            $pubmed = $1 if $line =~ /PubMed=(\\d+);/;\n            $doi = $1 if $line =~ /DOI=(.+);/;\n        } elsif ( /^RA\\s{3}(.*)/ ) {\n            $au .= $au ? \" $1\" : $1;\n        } elsif ( /^RG\\s{3}(.*)/ ) {\n            $rg .= $rg ? \" $1\" : $1;\n        } elsif ( /^RT\\s{3}(.*)/ ) {\n            if ($title) {\n                my $tline = $1;\n                $title .= ($title =~ /[\\w;,:\\?!]$/) ? \" $tline\" : $tline;\n            } else {\n                $title = $1;\n            }\n        } elsif (/^RL\\s{3}(.*)/ ) {\n            $loc .= $loc ? \" $1\" : $1;\n        } elsif ( /^RC\\s{3}(.*)/ ) {\n            $com .= $com ? \" $1\" : $1;\n        }\n        $_ = $self->_readline;\n    }\n    return \\@refs;\n}\n\n\n=head2 _read_swissprot_Species\n\n Title   : _read_swissprot_Species\n Usage   :\n Function: Reads the swissprot Organism species and classification\n           lines.\n             Able to deal with unconventional species names.\n Example : OS Unknown prokaryotic organism\n             $genus = undef ; $species = Unknown prokaryotic organism\n Returns : A Bio::Species object\n Args    :\n\n\nsub _read_swissprot_Species {\n    my( $self,$line ) = @_;\n    my $org;\n    local $_ = $line;\n\n    my( $sub_species, $species, $genus, $common, $variant, $ncbi_taxid, $sci_name, $class_lines, $descr );\n    my $osline = \"\";\n    my $do_genus_check = 1;\n    while ( defined $_ ) {\n        last unless /^O[SCGX]/;\n        # believe it or not, but OS may come multiple times -- at this time\n        # we can't capture multiple species\n        if (/^OS\\s+(\\S.+)/ && (! defined($sci_name))) {\n            $osline .= \" \" if $osline;\n            $osline .= $1;\n            if ($osline =~ s/(,|, and|\\.)$//) {\n                # OS lines are usually like:\n                # Homo sapiens (human)\n                # where we have $sci_name followed by $descr (common name) in\n                # brackets, but we can also have:\n                # Venerupis (Ruditapes) philippinarum\n                # where we have brackets but they don't indicate a $descr\n                if ($osline =~ /[^\\(\\)]+\\(.+\\)[^\\(\\)]+$/) {\n                    #*** Danger! no idea if this will pick up some syntaxes for\n                    #    common names as well)\n                    $sci_name = $osline;\n                    $sci_name =~ s/\\.$//;\n                    $descr = '';\n                    $do_genus_check = 0;\n                } else {\n                    ($sci_name, $descr) = $osline =~ /(\\S[^\\(]+)(.*)/;\n                }\n                $sci_name =~ s/\\s+$//;\n\n                while ($descr =~ /\\(([^\\)]+)\\)/g) {\n                    my $item = $1;\n                    # strain etc may not necessarily come first (yes, swissprot\n                    # is messy)\n                    if ((! defined($variant)) &&\n                        (($item =~ /(^|[^\\(\\w])([Ss]train|isolate|serogroup|serotype|subtype|clone)\\b/) ||\n                         ($item =~ /^(biovar|pv\\.|type\\s+)/))) {\n                        $variant = $item;\n                    } elsif ($item =~ s/^subsp\\.\\s+//) {\n                        if (! $sub_species) {\n                            $sub_species = $item;\n                        } elsif (! $variant) {\n                            $variant = $item;\n                        }\n                    } elsif (! defined($common)) {\n                        # we're only interested in the first common name\n                        $common = $item;\n                        if ((index($common, '(') >= 0) &&\n                            (index($common, ')') < 0)) {\n                            $common .= ')';\n                        }\n                    }\n                }\n            }\n        } elsif (s/^OC\\s+(\\S.+)$//) {\n            $class_lines .= $1;\n        } elsif (/^OG\\s+(.*)/) {\n            $org = $1;\n        } elsif (/^OX\\s+(.*)/ && (! defined($ncbi_taxid))) {\n            my $taxstring = $1;\n            # we only keep the first one and ignore all others\n            if ($taxstring =~ /NCBI_TaxID=([\\w\\d]+)/) {\n                $ncbi_taxid = $1;\n            } else {\n                $self->throw(\"$taxstring doesn't look like NCBI_TaxID\");\n            }\n        }\n        $_ = $self->_readline;\n    }\n    $self->_pushback($_);       # pushback the last line because we need it\n\n    $sci_name || return;\n\n    # if the organism belongs to taxid 32644 then no Bio::Species object.\n    return if grep { $_ eq $sci_name } @Unknown_names;\n\n    # Convert data in classification lines into classification array.\n    # Remove trailing . then split on ';' or '.;' so that classification that is 2\n    # or more words will still get matched, use map() to remove trailing/leading/intervening\n    # spaces\n    $class_lines=~s/\\.\\s*$//;\n    my @class = map { s/^\\s+//; s/\\s+$//; s/\\s{2,}/ /g; $_; } split /[;\\.]*;/, $class_lines;\n\n    if ($class[0] =~ /viruses/i) {\n        # viruses have different OS/OC syntax\n        my @virusnames = split(/\\s+/, $sci_name);\n        $species = (@virusnames > 1) ? pop(@virusnames) : '';\n        $genus = join(\" \", @virusnames);\n        $sub_species = $descr;\n    } elsif ($do_genus_check) {\n        # do we have a genus?\n        my $possible_genus = $class[-1];\n        $possible_genus .= \"|$class[-2]\" if $class[-2];\n        if ($sci_name =~ /^($possible_genus)/) {\n            $genus = $1;\n            ($species) = $sci_name =~ /^$genus\\s+(.+)/;\n        } else {\n            $species = $sci_name;\n        }\n        # is this organism of rank species or is it lower?\n        # (doesn't catch everything, but at least the guess isn't dangerous)\n        if ($species && $species =~ /subsp\\.|var\\./) {\n            ($species, $sub_species) = $species =~ /(.+)\\s+((?:subsp\\.|var\\.).+)/;\n        }\n    }\n\n    # Bio::Species array needs array in Species -> Kingdom direction\n    unless ($class[-1] eq $sci_name) {\n        push(@class, $sci_name);\n    }\n    @class = reverse @class;\n\n    my $taxon = Bio::Species->new();\n    $taxon->scientific_name($sci_name);\n    $taxon->classification(@class);\n    $taxon->common_name($common) if $common;\n    $taxon->sub_species($sub_species) if $sub_species;\n    $taxon->organelle($org) if $org;\n    $taxon->ncbi_taxid($ncbi_taxid) if $ncbi_taxid;\n    $taxon->variant($variant) if $variant;\n\n    # done\n    return $taxon;\n}\n\n=head2 _filehandle\n\n Title   : _filehandle\n Usage   : $obj->_filehandle($newval)\n Function:\n Example :\n Returns : value of _filehandle\n Args    : newvalue (optional)\n\n\n\n# inherited from SeqIO.pm ! HL 05/11/2000\n\n=head2 _read_FTHelper_swissprot\n\n Title   : _read_FTHelper_swissprot\n Usage   : _read_FTHelper_swissprot(\\$buffer)\n Function: reads the next FT key line\n Example :\n Returns : Bio::SeqIO::FTHelper object\n Args    :\n\n\n\nsub _read_FTHelper_swissprot {\n    my ($self,$line ) = @_;\n    # initial version implemented by HL 05/10/2000\n    # FIXME this may not be perfect, so please review\n    # lots of cleaning up by JES 2004/07/01, still may not be perfect =)\n    # FTId now sepated from description as a qualifier\n\n    local $_ = $line;\n    my ($key,                   # The key of the feature\n        $loc,                   # The location line from the feature\n        $desc,                  # The descriptive text\n        $ftid,                  # feature Id is like a qualifier but there can be only one of them\n       );\n    if ( m/^FT\\s{3}(\\w+)\\s+([\\d\\?\\<]+)\\s+([\\d\\?\\>]+)\\s*(.*)$/ox) {\n        $key = $1;\n        my $loc1 = $2;\n        my $loc2 = $3;\n        $loc = \"$loc1..$loc2\";\n        if ($4 && (length($4) > 0)) {\n            $desc = $4;\n            chomp($desc);\n        } else {\n            $desc = \"\";\n        }\n    }\n\n    while ( defined($_ = $self->_readline) && /^FT\\s{20,}(\\S.*)$/ ) {\n        my $continuation_line = $1;\n        if ( $continuation_line =~ /.FTId=(.*)\\./ ) {\n            $ftid=$1;\n        }\n        elsif ( $desc) {\n            $desc .= \" $continuation_line\";\n        } else {\n            $desc = $continuation_line;\n        }\n        chomp $desc;\n    }\n    $self->_pushback($_);\n    unless( $key ) {\n        # No feature key. What's this?\n        $self->warn(\"No feature key in putative feature table line: $line\");\n        return;\n    }\n\n    # Make the new FTHelper object\n    my $out = Bio::SeqIO::FTHelper->new(-verbose => $self->verbose());\n    $out->key($key);\n    $out->loc($loc);\n\n    # store the description if there is one\n    if ( $desc && length($desc) ) {\n        $desc =~ s/\\.$//;\n        push(@{$out->field->{\"description\"}}, $desc);\n    }\n    # Store the qualifier i.e. FTId\n    if ( $ftid ) {\n        push(@{$out->field->{\"FTId\"}}, $ftid);\n    }\n    return $out;\n}\n\n\n=head2 _write_line_swissprot\n\n Title   : _write_line_swissprot\n Usage   :\n Function: internal function\n Example :\n Returns :\n Args    :","label":"_write_line_swissprot($self,$pre1,$pre2,$line,$length)"},"containerName":"main::","name":"_write_line_swissprot","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"_write_line_swissprot","name":"$self","line":1342},{"line":1342,"containerName":"_write_line_swissprot","kind":13,"name":"$pre1"},{"kind":13,"containerName":"_write_line_swissprot","name":"$pre2","line":1342},{"name":"$line","containerName":"_write_line_swissprot","kind":13,"line":1342},{"line":1342,"containerName":"_write_line_swissprot","kind":13,"name":"$length"},{"line":1344,"name":"$length","kind":13,"containerName":"_write_line_swissprot"},{"line":1344,"name":"$self","kind":13,"containerName":"_write_line_swissprot"},{"kind":12,"containerName":"_write_line_swissprot","name":"throw","line":1344},{"definition":"my","localvar":"my","containerName":"_write_line_swissprot","kind":13,"name":"$subl","line":1345},{"name":"$length","containerName":"_write_line_swissprot","kind":13,"line":1345},{"containerName":"_write_line_swissprot","kind":13,"name":"$pre2","line":1345},{"name":"$linel","containerName":"_write_line_swissprot","localvar":"my","kind":13,"line":1346,"definition":"my"},{"name":"$line","containerName":"_write_line_swissprot","kind":13,"line":1346},{"line":1347,"name":"$i","localvar":"my","containerName":"_write_line_swissprot","kind":13,"definition":"my"},{"name":"$sub","localvar":"my","containerName":"_write_line_swissprot","kind":13,"line":1349,"definition":"my"},{"line":1349,"kind":13,"containerName":"_write_line_swissprot","name":"$line"},{"line":1349,"containerName":"_write_line_swissprot","kind":13,"name":"$length"},{"line":1349,"kind":13,"containerName":"_write_line_swissprot","name":"$pre1"},{"containerName":"_write_line_swissprot","kind":13,"name":"$self","line":1351},{"kind":12,"containerName":"_write_line_swissprot","name":"_print","line":1351},{"line":1353,"containerName":"_write_line_swissprot","kind":13,"name":"$i"},{"name":"$length","kind":13,"containerName":"_write_line_swissprot","line":1353},{"containerName":"_write_line_swissprot","kind":13,"name":"$pre1","line":1353},{"line":1353,"name":"$i","containerName":"_write_line_swissprot","kind":13},{"containerName":"_write_line_swissprot","kind":13,"name":"$linel","line":1353},{"line":1354,"kind":13,"containerName":"_write_line_swissprot","name":"$sub"},{"kind":13,"containerName":"_write_line_swissprot","name":"$line","line":1354},{"line":1354,"containerName":"_write_line_swissprot","kind":13,"name":"$i"},{"line":1354,"kind":13,"containerName":"_write_line_swissprot","name":"$subl"},{"line":1355,"name":"$self","kind":13,"containerName":"_write_line_swissprot"},{"line":1355,"containerName":"_write_line_swissprot","kind":12,"name":"_print"},{"line":1356,"name":"$i","containerName":"_write_line_swissprot","kind":13},{"name":"$subl","containerName":"_write_line_swissprot","kind":13,"line":1356}],"detail":"($self,$pre1,$pre2,$line,$length)","definition":"sub"},{"containerName":"main::","name":"_write_line_swissprot_regex","children":[{"name":"$self","localvar":"my","containerName":"_write_line_swissprot_regex","kind":13,"line":1377,"definition":"my"},{"kind":13,"containerName":"_write_line_swissprot_regex","name":"$pre1","line":1377},{"name":"$pre2","kind":13,"containerName":"_write_line_swissprot_regex","line":1377},{"line":1377,"kind":13,"containerName":"_write_line_swissprot_regex","name":"$line"},{"line":1377,"kind":13,"containerName":"_write_line_swissprot_regex","name":"$regex"},{"line":1377,"name":"$length","containerName":"_write_line_swissprot_regex","kind":13},{"containerName":"_write_line_swissprot_regex","kind":13,"name":"$length","line":1381},{"line":1381,"kind":13,"containerName":"_write_line_swissprot_regex","name":"$self"},{"line":1381,"name":"throw","containerName":"_write_line_swissprot_regex","kind":12},{"line":1383,"name":"$pre1","containerName":"_write_line_swissprot_regex","kind":13},{"line":1383,"containerName":"_write_line_swissprot_regex","kind":13,"name":"$pre2"},{"name":"$self","containerName":"_write_line_swissprot_regex","kind":13,"line":1384},{"kind":12,"containerName":"_write_line_swissprot_regex","name":"warn","line":1384},{"kind":13,"containerName":"_write_line_swissprot_regex","name":"$pre1","line":1384},{"name":"$pre2","containerName":"_write_line_swissprot_regex","kind":13,"line":1384},{"kind":13,"containerName":"_write_line_swissprot_regex","name":"$self","line":1385},{"line":1385,"kind":12,"containerName":"_write_line_swissprot_regex","name":"throw"},{"definition":"my","line":1388,"localvar":"my","containerName":"_write_line_swissprot_regex","kind":13,"name":"$subl"},{"line":1388,"name":"$length","kind":13,"containerName":"_write_line_swissprot_regex"},{"line":1388,"name":"$pre1","kind":13,"containerName":"_write_line_swissprot_regex"},{"localvar":"my","kind":13,"containerName":"_write_line_swissprot_regex","name":"$first_line","line":1390,"definition":"my"},{"line":1391,"name":"$line","containerName":"_write_line_swissprot_regex","kind":13},{"definition":"my","line":1392,"name":"$s","containerName":"_write_line_swissprot_regex","localvar":"my","kind":13},{"line":1393,"kind":13,"containerName":"_write_line_swissprot_regex","name":"$s"},{"name":"$pre1","kind":13,"containerName":"_write_line_swissprot_regex","line":1394},{"name":"$pre1","containerName":"_write_line_swissprot_regex","kind":13,"line":1394},{"name":"$s","containerName":"_write_line_swissprot_regex","kind":13,"line":1396},{"line":1396,"name":"$s","containerName":"_write_line_swissprot_regex","kind":13},{"containerName":"_write_line_swissprot_regex","kind":13,"name":"$first_line","line":1397},{"line":1398,"name":"$self","containerName":"_write_line_swissprot_regex","kind":13},{"name":"_print","kind":12,"containerName":"_write_line_swissprot_regex","line":1398},{"line":1399,"containerName":"_write_line_swissprot_regex","kind":13,"name":"$first_line"},{"containerName":"_write_line_swissprot_regex","kind":13,"name":"$self","line":1401},{"line":1401,"kind":12,"containerName":"_write_line_swissprot_regex","name":"_print"}],"detail":"($self,$pre1,$pre2,$line,$regex,$length)","definition":"sub","kind":12,"range":{"end":{"line":1405,"character":9999},"start":{"line":1376,"character":0}},"line":1376,"signature":{"label":"_write_line_swissprot_regex($self,$pre1,$pre2,$line,$regex,$length)","parameters":[{"label":"$self"},{"label":"$pre1"},{"label":"$pre2"},{"label":"$line"},{"label":"$regex"},{"label":"$length"}],"documentation":"1;\n# $Id: swiss.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::swiss\n#\n# Copyright Elia Stupka\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::swiss - Swissprot sequence input/output stream\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system:\n\n    use Bio::SeqIO;\n\n    $stream = Bio::SeqIO->new(-file => $filename,\n                              -format => 'swiss');\n\n    while ( my $seq = $stream->next_seq() ) {\n       # do something with $seq\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from Swiss-Pprot flat\nfile databases.\n\nThere is a lot of flexibility here about how to dump things which needs\nto be documented.\n\n=head2 GN (Gene name) line management details\n\nA Uniprot/Swiss-Prot entry holds information on one protein\nsequence. If that sequence is identical across genes and species, they\nare all merged into one entry. This creates complex needs for several\nannotation fields in swiss-prot format.\n\nThe latest syntax for GN line is described in the user manual:\n\n  http://www.expasy.ch/sprot/userman.html#GN_line\n\nEach of the possibly multiple genes in an entry can have Name,\nSynonyms (only if there is a name), OrderedLocusNames (names from\ngenomic sequences) and ORFNames (temporary or cosmid names). \"Name\"\nhere really means \"symbol\". This complexity is now dealt with the\nfollowing way:\n\nA new Bio::AnnotationI class was created in order to store the\ndata in tag-value pairs.  This class (Bio::Annotation::TagTree)\nis stored in the Bio::Annotation::Collection object and is\naccessed like all other annotations. The tag name is 'gene_name'.\n\nThere is a single Bio::Annotation::TagTree per sequence record, which\ncorresponds to the original class that stored this data\n(Bio::Annotation::StructuredValue).  Depending on how we progress\nthis may change to represent each group of gene names.\n\nFor now, to access the gene name tree annotation, one uses the below method:\n\n   my ($gene) = $seq->annotation->get_Annotations('gene_name');\n\nIf you are only interested in displaying the values, value() returns a\nstring with similar formatting.\n\nThere are several ways to get directly at the information you want if you\nknow the element (tag) for the data.  For gene names all data is stored with\nthe element-tag pairs:\n\n  \"element1=tag1, tag2, tag3; element2=tag4, tag5;\"\n\nThis normally means the element will be 'Name', 'Synonyms', etc. and the\ngene names the values.  Using findval(), you can do the following:\n\n  # grab a flattened list of all gene names\n  my @names = $ann->findval('Name');\n\n  # or iterated through the nodes and grab the name for each group\n  for my $node ($ann->findnode('gene_name')) {\n     my @names = $node->findval('Name');\n  }\n\nThe current method for parsing gene name data (and reconstructing gene name\noutput) is very generic. This is somewhat preemptive if, for instance, UniProt\ndecides to update and add another element name to the current ones using the\nsame formatting layout. Under those circumstances, one can iterate through the\ntag tree in a safe way and retrieve all node data like so.\n\n  # retrieve the gene name nodes (groups like names, synonyms, etc).\n  for my $ann ($seq->annotation->get_Annotations('gene_name')) {\n\n      # each gene name group\n      for my $node ($ann->findnode('gene_name')) {\n          print \"Gene name:\\n\";\n\n          # each gene name node (tag => value pair)\n          for my $n ($node->children) {\n              print \"\\t\".$n->element.\": \".$n->children.\"\\n\";\n          }\n      }\n  }\n\nFor more uses see Bio::Annotation::TagTree.\n\nSince Uniprot/Swiss-Prot format have been around for quite some time, the\nparser is also able to read in the older GN line syntax where genes\nare separated by AND and various symbols by OR. The first symbol is\ntaken to be the 'Name' and the remaining ones are stored as 'Synonyms'.\n\n=head2 Optional functions\n\n=over 3\n\n* _show_dna()\n\n(output only) shows the dna or not\n\n* _post_sort()\n\n(output only) provides a sorting func which is applied to the FTHelpers\nbefore printing\n\n* _id_generation_func()\n\nThis is function which is called as\n\n   print \"ID   \", $func($seq), \"\\n\";\n\nTo generate the ID line. If it is not there, it generates a sensible ID\nline using a number of tools.\n\nIf you want to output annotations in Swissprot format they need to be\nstored in a Bio::Annotation::Collection object which is accessible\nthrough the Bio::SeqI interface method L<annotation()|annotation>.\n\nThe following are the names of the keys which are polled from a\nL<Bio::Annotation::Collection> object.\n\n reference   - Should contain Bio::Annotation::Reference objects\n comment     - Should contain Bio::Annotation::Comment objects\n dblink      - Should contain Bio::Annotation::DBLink objects\n gene_name   - Should contain Bio::Annotation::SimpleValue object\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions,\npreferably to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Elia Stupka\n\nEmail elia@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::swiss;\nuse vars qw(@Unknown_names @Unknown_genus);\nuse strict;\nuse Bio::SeqIO::FTHelper;\nuse Bio::SeqFeature::Generic;\nuse Bio::Species;\nuse Bio::Tools::SeqStats;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::Comment;\nuse Bio::Annotation::Reference;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::TagTree;\n\nuse base qw(Bio::SeqIO);\n\nour $LINE_LENGTH = 76;\n\n# this is for doing species name parsing\n@Unknown_names=('other', 'unidentified',\n                'unknown organism', 'not specified',\n                'not shown', 'Unspecified', 'Unknown',\n                'None', 'unclassified', 'unidentified organism',\n                'not supplied'\n               );\n# dictionary of synonyms for taxid 32644\n# all above can be part of valid species name\n@Unknown_genus = qw(unknown unclassified uncultured unidentified);\n\n# if there are any other gene name tags, they are added to the end\nour @GENE_NAME_ORDER = qw(Name Synonyms OrderedLocusNames ORFNames);\n\nsub _initialize {\n    my($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    # hash for functions for decoding keys.\n    $self->{'_func_ftunit_hash'} = {};\n    # sets this to one by default. People can change it\n    $self->_show_dna(1);\n    if ( ! defined $self->sequence_factory ) {\n        $self->sequence_factory(Bio::Seq::SeqFactory->new\n                                (-verbose => $self->verbose(),\n                                 -type => 'Bio::Seq::RichSeq'));\n    }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    :\n\n\nsub next_seq {\n    my ($self,@args) = @_;\n    my ($pseq,$c,$line,$name,$desc,$acc,$seqc,$mol,$div, $sptr,$seq_div,\n        $date,$comment,@date_arr);\n    my $genename = \"\";\n    my ($annotation, %params, @features) = ( Bio::Annotation::Collection->new());\n\n    local $_;\n\n    1 while defined($_ = $self->_readline) && /^\\s+$/;\n    return unless defined $_ && /^ID\\s/;\n\n    # fixed to allow _DIVISION to be optional for bug #946\n    # see bug report for more information\n    #\n    # 9/6/06 Note: Swiss/TrEMBL sequences have no division acc. to UniProt\n    # release notes; this is fixed to simplify the regex parsing\n    # STANDARD (SwissProt) and PRELIMINARY (TrEMBL) added to namespace()\n    unless(  m{^\n               ID              \\s+     #\n               (\\S+)           \\s+     #  $1  entryname\n               ([^\\s;]+);      \\s+     #  $2  DataClass\n               (?:PRT;)?       \\s+     #  Molecule Type (optional)\n               [0-9]+[ ]AA     \\.      #  Sequencelength (capture?)\n               $\n           }ox ) {\n            # I couldn't find any new current UniProt sequences\n            # that matched this format:\n            # || m/^ID\\s+(\\S+)\\s+(_([^\\s_]+))? /ox ) {\n        $self->throw(\"swissprot stream with no ID. Not swissprot in my book\");\n    }\n    ($name, $seq_div) = ($1, $2);\n    $params{'-namespace'} =\n        ($seq_div eq 'Reviewed'   || $seq_div eq 'STANDARD')     ? 'Swiss-Prot' :\n        ($seq_div eq 'Unreviewed' || $seq_div eq 'PRELIMINARY')  ? 'TrEMBL'     :\n         $seq_div;\n    # we shouldn't be setting the division, but for now...\n    my ($junk, $division) = split q(_), $name;\n    $params{'-division'} = $division;\n    $params{'-alphabet'} = 'protein';\n    # this is important to have the id for display in e.g. FTHelper, otherwise\n    # you won't know which entry caused an error\n    $params{'-display_id'} = $name;\n\n    BEFORE_FEATURE_TABLE :\n          while ( defined($_ = $self->_readline) ) {\n              # Exit at start of Feature table and at the sequence at the\n              # latest HL 05/11/2000\n              last if( /^(FT|SQ)/ );\n\n              # Description line(s)\n              if (/^DE\\s+(\\S.*\\S)/) {\n                  $desc .= $desc ? \" $1\" : $1;\n              }\n              #Gene name\n              elsif (/^GN\\s+(.*)/) {\n                  $genename .= \" \" if $genename;\n                  $genename .= $1;\n              }\n              #accession number(s)\n              elsif ( /^AC\\s+(.+)/) {\n                  my @accs = split(/[; ]+/, $1); # allow space in addition\n                  $params{'-accession_number'} = shift @accs\n                      unless defined $params{'-accession_number'};\n                  push @{$params{'-secondary_accessions'}}, @accs;\n              }\n              #date and sequence version\n              elsif ( /^DT\\s+(.*)/ ) {\n                  my $line = $1;\n                  my ($date, $version) = split(' ', $line, 2);\n                  $date =~ tr/,//d; # remove comma if new version\n                  if ($version =~ /\\(Rel\\. (\\d+), Last sequence update\\)/ || # old\n                      /sequence version (\\d+)/) { #new\n                      my $update = Bio::Annotation::SimpleValue->new\n                          (-tagname    => 'seq_update',\n                           -value      => $1\n                          );\n                      $annotation->add_Annotation($update);\n                  } elsif ($version =~ /\\(Rel\\. (\\d+), Last annotation update\\)/ || #old\n                           /entry version (\\d+)/) { #new\n                      $params{'-version'} = $1;\n                  }\n                  push @{$params{'-dates'}}, $date;\n              }\n              # Evidence level\n              elsif ( /^PE\\s+(.*)/ ) {\n                  my $line = $1;\n                  $line =~ s/;\\s*//; # trim trailing semicolon and any spaces at the end of the line\n                  my $evidence = Bio::Annotation::SimpleValue->new\n                      (-tagname   => 'evidence',\n                       -value     => $line\n                      );\n                  $annotation->add_Annotation($evidence);\n              }\n              # Organism name and phylogenetic information\n              elsif (/^O[SCG]/) {\n                  my $species = $self->_read_swissprot_Species($_);\n                  $params{'-species'}= $species;\n                  # now we are one line ahead -- so continue without reading the next\n                  # line   HL 05/11/2000\n              }\n              # References\n              elsif (/^R/) {\n                  my $refs = $self->_read_swissprot_References($_);\n                  foreach my $r (@$refs) {\n                      $annotation->add_Annotation('reference',$r);\n                  }\n              }\n              # Comments\n              elsif (/^CC\\s{3}(.*)/) {\n                  $comment .= $1;\n                  $comment .= \"\\n\";\n                  while (defined ($_ = $self->_readline) && /^CC\\s{3}(.*)/ ) {\n                      $comment .= $1 . \"\\n\";\n                  }\n\n                  # note: don't try to process comments here -- they may contain\n                  # structure. LP 07/30/2000\n\n                  my $commobj = Bio::Annotation::Comment->new(-tagname => 'comment',\n                                                              -text    => $comment);\n                  $annotation->add_Annotation('comment',$commobj);\n                  $comment = \"\";\n                  $self->_pushback($_);\n              }\n              #DBLinks\n              # old regexp\n              # /^DR\\s+(\\S+)\\;\\s+(\\S+)\\;\\s+(\\S+)[\\;\\.](.*)$/) {\n              # new regexp from Andreas Kahari  bug #1584\n              elsif (/^DR\\s+(\\S+)\\;\\s+(\\S+)\\;\\s+([^;]+)[\\;\\.](.*)$/) {\n                  my ($database,$primaryid,$optional,$comment) = ($1,$2,$3,$4);\n\n                  # drop leading and training spaces and trailing .\n                  $comment =~ s/\\.\\s*$//;\n                  $comment =~ s/^\\s+//;\n\n                  my $dblinkobj =  Bio::Annotation::DBLink->new\n                      (-database    => $database,\n                       -primary_id  => $primaryid,\n                       -optional_id => $optional,\n                       -comment     => $comment,\n                       -tagname     => 'dblink',\n                      );\n\n                  $annotation->add_Annotation('dblink',$dblinkobj);\n              }\n              #keywords\n              elsif ( /^KW\\s+(.*)$/ ) {\n                  my @kw = split(/\\s*\\;\\s*/,$1);\n                  defined $kw[-1] && $kw[-1] =~ s/\\.$//;\n                  push @{$params{'-keywords'}}, @kw;\n              }\n          }\n    # process and parse the gene name line if there was one (note: we\n    # can't do this above b/c GN may be multi-line and we can't\n    # unequivocally determine whether we've seen the last GN line in\n    # the new format)\n    if ($genename) {\n        my @stags;\n        if ($genename =~ /\\w=\\w/) {\n            # new format (e.g., Name=RCHY1; Synonyms=ZNF363, CHIMP)\n            for my $n (split(m{\\s+and\\s+},$genename)) {\n                my @genenames;\n                for my $section (split(m{\\s*;\\s*},$n)) {\n                    my ($tag, $rest) = split(\"=\",$section);\n                    $rest ||= '';\n                    for my $val (split(m{\\s*,\\s*},$rest)) {\n                        push @genenames, [$tag => $val];\n                    }\n                }\n                push @stags, ['gene_name' => \\@genenames];\n            }\n        } else {\n            # old format\n            for my $section (split(/ AND /, $genename)) {\n                my @genenames;\n                $section =~ s/[\\(\\)\\.]//g;\n                my @names = split(m{\\s+OR\\s+}, $section);\n                push @genenames, ['Name' => shift @names];\n                push @genenames, map {['Synonyms' => $_]} @names;\n                push @stags, ['gene_name' => \\@genenames]            \n            }\n        } #use Data::Dumper; print Dumper $gn, $genename;# exit;\n        my $gn = Bio::Annotation::TagTree->new(-tagname => 'gene_name',\n                                               -value => ['gene_names' => \\@stags]);\n        $annotation->add_Annotation('gene_name', $gn);\n    }\n\n    FEATURE_TABLE :\n          # if there is no feature table, or if we've got beyond, exit loop or don't\n          # even enter    HL 05/11/2000\n          while (defined $_ && /^FT/ ) {\n              my $ftunit = $self->_read_FTHelper_swissprot($_);\n\n              # process ftunit\n              # when parsing of the line fails we get undef returned\n              if ($ftunit) {\n                  push(@features,\n                       $ftunit->_generic_seqfeature($self->location_factory(),\n                                                    $params{'-seqid'}, \"SwissProt\"));\n              } else {\n                  $self->warn(\"failed to parse feature table line for seq \" .\n                              $params{'-display_id'}. \"\\n$_\");\n              }\n              $_ = $self->_readline;\n          }\n    while ( defined($_) && ! /^SQ/ ) {\n        $_ = $self->_readline;\n    }\n    $seqc = \"\";\n    while ( defined ($_ = $self->_readline) ) {\n        last if m{^//};\n        s/[^A-Za-z]//g;\n        $seqc .= uc($_);\n    }\n\n    my $seq=  $self->sequence_factory->create\n        (-verbose  => $self->verbose,\n         %params,\n         -seq      => $seqc,\n         -desc     => $desc,\n         -features => \\@features,\n         -annotation => $annotation,\n        );\n\n    # The annotation doesn't get added by the contructor\n    $seq->annotation($annotation);\n\n    return $seq;\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq($seq)\n Function: writes the $seq object (must be seq) to the stream\n Returns : 1 for success and 0 for error\n Args    : array of 1 to n Bio::SeqI objects\n\n\n\nsub write_seq {\n    my ($self,@seqs) = @_;\n    foreach my $seq ( @seqs ) {\n        $self->throw(\"Attempting to write with no seq!\") unless defined $seq;\n\n        if ( ! ref $seq || ! $seq->isa('Bio::SeqI') ) {\n            $self->warn(\" $seq is not a SeqI compliant module. Attempting to dump, but may fail!\");\n        }\n\n        my $i;\n        my $str = $seq->seq;\n\n        my $div;\n        my $ns = ($seq->can('namespace')) && $seq->namespace();\n        my $len = $seq->length();\n\n        if ( !$seq->can('division') || ! defined ($div = $seq->division()) ) {\n            $div = 'UNK';\n        }\n\n        # namespace dictates database, takes precedent over division. Sorry!\n        if (defined($ns)) {\n            $div = ($ns eq 'Swiss-Prot') ? 'Reviewed'    :\n                ($ns eq 'TrEMBL')     ? 'Unreviewed' :\n                    $ns;\n        } else {\n            $ns = 'Swiss-Prot';\n            # division not reset; acts as fallback\n        }\n\n        $self->warn(\"No whitespace allowed in SWISS-PROT display id [\". $seq->display_id. \"]\")\n            if $seq->display_id =~ /\\s/;\n\n        my $temp_line;\n        if ( $self->_id_generation_func ) {\n            $temp_line = &{$self->_id_generation_func}($seq);\n        } else {\n            #$temp_line = sprintf (\"%10s     STANDARD;      %3s;   %d AA.\",\n            #            $seq->primary_id().\"_\".$div,$mol,$len);\n            # Reconstructing the ID relies heavily upon the input source having\n            # been in a format that is parsed as this routine expects it -- that is,\n            # by this module itself. This is bad, I think, and immediately breaks\n            # if e.g. the Bio::DB::GenPept module is used as input.\n            # Hence, switch to display_id(); _every_ sequence is supposed to have\n            # this. HL 2000/09/03\n            # Changed to reflect ID line changes in UniProt\n            # Oct 2006 - removal of molecule type - see bug 2134\n            $temp_line = sprintf (\"%-24s%-12s%9d AA.\",\n                                  $seq->display_id(), $div.';', $len);\n        }\n\n        $self->_print( \"ID   $temp_line\\n\");\n\n        # if there, write the accession line\n        local($^W) = 0;         # supressing warnings about uninitialized fields\n\n        if ( $self->_ac_generation_func ) {\n            $temp_line = &{$self->_ac_generation_func}($seq);\n            $self->_print( \"AC   $temp_line\\n\");\n        }\n        elsif ($seq->can('accession_number') ) {\n            my $ac_line = $seq->accession_number;\n            if ($seq->can('get_secondary_accessions') ) {\n                foreach my $sacc ($seq->get_secondary_accessions) {\n                    $ac_line .= \"; \". $sacc;;\n                }\n                $ac_line .= \";\";\n            }\n\n            $self->_write_line_swissprot_regex(\"AC   \",\"AC   \",$ac_line,\n                                               \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n        }\n        # otherwise - cannot print <sigh>\n\n\n        # Date lines and sequence versions (changed 6/15/2006)\n        # This is rebuilt from scratch using the current SwissProt/UniProt format\n        if ( $seq->can('get_dates') ) {\n            my @dates =  $seq->get_dates();\n            my $ct = 1;\n            my $seq_version = $seq->version;\n            my ($update_version) = $seq->annotation->get_Annotations(\"seq_update\");\n            foreach my $dt (@dates) {\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.', integrated into UniProtKB/'.$ns.'.',\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 1;\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.\", sequence version \".$update_version->display_text.'.',\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 2;\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.\", entry version $seq_version.\",\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 3;\n                $ct++;\n            }\n        }\n\n        #Definition lines\n        $self->_write_line_swissprot_regex(\"DE   \",\"DE   \",$seq->desc(),\"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n\n        #Gene name; print out new format\n        foreach my $gene ( my @genes = $seq->annotation->get_Annotations('gene_name') ) {\n            # gene is a Bio::Annotation::TagTree;\n            my @genelines;\n            for my $node ($gene->findnode('gene_name')) {\n                # check for Name and Synonym first, then the rest get tagged on\n                my $geneline = \"GN   \";\n                my %genedata = $node->hash;\n                for my $tag (@GENE_NAME_ORDER) {\n                    if (exists $genedata{$tag}) {\n                        $geneline .= (ref $genedata{$tag} eq 'ARRAY') ?\n                            \"$tag=\".join(', ',@{$genedata{$tag}}).\"; \" :\n                            \"$tag=$genedata{$tag}; \";\n                        delete $genedata{$tag};\n                    }\n                }\n                # add rest\n                for my $tag (sort keys %genedata) {\n                    $geneline .= (ref $genedata{$tag} eq 'ARRAY') ?\n                        \"$tag=\".join(', ',@{$genedata{$tag}}).\"; \" :\n                        \"$tag=$genedata{$tag}; \";\n                    delete $genedata{$tag};\n                }\n                push @genelines, \"$geneline\\n\";\n            }\n            $self->_print(join(\"GN   and\\n\",@genelines));\n        }\n\n        # Organism lines\n        if ($seq->can('species') && (my $spec = $seq->species)) {\n            my @class = $spec->classification();\n            shift(@class);\n            my $species = $spec->species;\n            my $genus = $spec->genus;\n            my $OS = $spec->scientific_name;\n            if ($class[-1] =~ /viruses/i) {\n                $OS = $species;\n                $OS .=  \" \". $spec->sub_species if $spec->sub_species;\n            }\n            foreach (($spec->variant, $spec->common_name)) {\n                $OS .= \" ($_)\" if $_;\n            }\n            $self->_print( \"OS   $OS.\\n\");\n            my $OC = join('; ', reverse(@class)) .'.';\n            $self->_write_line_swissprot_regex(\"OC   \",\"OC   \",$OC,\"\\; \\|\\$\",$LINE_LENGTH);\n            if ($spec->organelle) {\n                $self->_write_line_swissprot_regex(\"OG   \",\"OG   \",$spec->organelle,\"\\; \\|\\$\",$LINE_LENGTH);\n            }\n            if ($spec->ncbi_taxid) {\n                $self->_print(\"OX   NCBI_TaxID=\".$spec->ncbi_taxid.\";\\n\");\n            }\n        }\n\n        # Reference lines\n        my $t = 1;\n        foreach my $ref ( $seq->annotation->get_Annotations('reference') ) {\n            $self->_print( \"RN   [$t]\\n\");\n            # changed by lorenz 08/03/00\n            # j.gilbert and h.lapp agreed that the rp line in swissprot seems\n            # more like a comment than a parseable value, so print it as is\n            if ($ref->rp) {\n                $self->_write_line_swissprot_regex(\"RP   \",\"RP   \",$ref->rp,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            }\n            if ($ref->comment) {\n                $self->_write_line_swissprot_regex(\"RC   \",\"RC   \",$ref->comment,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            }\n            if ($ref->medline or $ref->pubmed or $ref->doi) {\n                # new RX format in swissprot LP 09/17/00\n                # RX line can now have a DOI, Heikki 13 Feb 2008\n\n                my $line;\n                $line .= \"MEDLINE=\". $ref->medline. '; ' if $ref->medline;\n                $line .= \"PubMed=\". $ref->pubmed. '; ' if $ref->pubmed;\n                $line .= \"DOI=\". $ref->doi. '; ' if $ref->doi;\n                chop $line;\n\n                $self->_write_line_swissprot_regex(\"RX   \",\"RX   \",\n                                                   $line,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n\n            }\n            my $author = $ref->authors .';' if($ref->authors);\n            my $title = $ref->title .';' if( $ref->title);\n            my $rg = $ref->rg . ';' if $ref->rg;\n            $author =~ s/([\\w\\.]) (\\w)/$1#$2/g;  # add word wrap protection char '#'\n\n            $self->_write_line_swissprot_regex(\"RG   \",\"RG   \",$rg,\"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $rg;\n            $self->_write_line_swissprot_regex(\"RA   \",\"RA   \",$author,\"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $author;\n            $self->_write_line_swissprot_regex(\"RT   \",\"RT   \",$title,'[\\s\\-]+|$',$LINE_LENGTH) if $title;\n            $self->_write_line_swissprot_regex(\"RL   \",\"RL   \",$ref->location,\"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            $t++;\n        }\n\n        # Comment lines\n\n        foreach my $comment ( $seq->annotation->get_Annotations('comment') ) {\n            foreach my $cline (split (\"\\n\", $comment->text)) {\n                while (length $cline > 74) {\n                    $self->_print(\"CC   \",(substr $cline,0,74),\"\\n\");\n                    $cline = substr $cline,74;\n                }\n                $self->_print(\"CC   \",$cline,\"\\n\");\n            }\n        }\n\n        # Database xref lines\n\n        foreach my $dblink ( $seq->annotation->get_Annotations('dblink') ) {\n            my ($primary_id) = $dblink->primary_id;\n\t\n            if (defined($dblink->comment) && ($dblink->comment) ) {\n                $self->_print(\"DR   \",$dblink->database,\"; \",$primary_id,\"; \",\n                              $dblink->optional_id,\"; \",$dblink->comment,\".\\n\");\n            } elsif ($dblink->optional_id) {\n                $self->_print(\"DR   \",$dblink->database,\"; \",\n                              $primary_id,\"; \",\n                              $dblink->optional_id,\".\\n\");\n            } else {\n                $self->_print(\"DR   \",$dblink->database,\n                              \"; \",$primary_id,\"; \",\"-.\\n\");\n            }\n        }\n\n        # Evidence lines\n\n        foreach my $evidence ( $seq->annotation->get_Annotations('evidence') ) {\n            $self->_print(\"PE   \",$evidence->value,\";\\n\");\n        }\n\n        # if there, write the kw line\n        {\n            my $kw;\n            if ( my $func = $self->_kw_generation_func ) {\n                $kw = &{$func}($seq);\n            } elsif ( $seq->can('keywords') ) {\n                $kw = $seq->keywords;\n                if ( ref($kw) =~ /ARRAY/i ) {\n                    $kw = join(\"; \", @$kw);\n                }\n                $kw .= '.' if $kw and $kw !~ /\\.$/ ;\n            }\n            $kw =~ s/([\\w\\.]) (\\w)/$1#$2/g;  # add word wrap protection char '#'\n            $self->_write_line_swissprot_regex(\"KW   \",\"KW   \",\n                                               $kw, \"\\\\s\\+\\|\\$\",$LINE_LENGTH)\n                if $kw;\n        }\n\n        #Check if there is seqfeatures before printing the FT line\n        my @feats = $seq->can('top_SeqFeatures') ? $seq->top_SeqFeatures : ();\n        if ($feats[0]) {\n            if ( defined $self->_post_sort ) {\n\n                # we need to read things into an array. Process. Sort them. Print 'em\n\n                my $post_sort_func = $self->_post_sort();\n                my @fth;\n\n                foreach my $sf ( @feats ) {\n                    push(@fth,Bio::SeqIO::FTHelper::from_SeqFeature($sf,$seq));\n                }\n                @fth = sort { &$post_sort_func($a,$b) } @fth;\n\n                foreach my $fth ( @fth ) {\n                    $self->_print_swissprot_FTHelper($fth);\n                }\n            } else {\n                # not post sorted. And so we can print as we get them.\n                # lower memory load...\n\n                foreach my $sf ( @feats ) {\n                    my @fth = Bio::SeqIO::FTHelper::from_SeqFeature($sf,$seq);\n                    foreach my $fth ( @fth ) {\n                        if ( ! $fth->isa('Bio::SeqIO::FTHelper') ) {\n                            $sf->throw(\"Cannot process FTHelper... $fth\");\n                        }\n                        $self->_print_swissprot_FTHelper($fth);\n                    }\n                }\n            }\n\n            if ( $self->_show_dna() == 0 ) {\n                return;\n            }\n        }\n        # finished printing features.\n\n        # molecular weight\n        my $mw = ${Bio::Tools::SeqStats->get_mol_wt($seq->primary_seq)}[0];\n        # checksum\n        # was crc32 checksum, changed it to crc64\n        my $crc64 = $self->_crc64(\\$str);\n        $self->_print( sprintf(\"SQ   SEQUENCE  %4d AA;  %d MW;  %16s CRC64;\\n\",\n                               $len,$mw,$crc64));\n        $self->_print( \"    \");\n        my $linepos;\n        for ($i = 0; $i < length($str); $i += 10) {\n            $self->_print( \" \", substr($str,$i,10));\n            $linepos += 11;\n            if ( ($i+10)%60 == 0 && (($i+10) < length($str))) {\n                $self->_print( \"\\n    \");\n            }\n        }\n        $self->_print( \"\\n//\\n\");\n\n        $self->flush if $self->_flush_on_write && defined $self->_fh;\n        return 1;\n    }\n}\n\n# Thanks to James Gilbert for the following two. LP 08/01/2000\n\n=head2 _generateCRCTable\n\n Title   : _generateCRCTable\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _generateCRCTable {\n  # 10001000001010010010001110000100\n  # 32\n    my $poly = 0xEDB88320;\n    my ($self) = shift;\n\n    $self->{'_crcTable'} = [];\n    foreach my $i (0..255) {\n        my $crc = $i;\n        for (my $j=8; $j > 0; $j--) {\n            if ($crc & 1) {\n                $crc = ($crc >> 1) ^ $poly;\n            } else {\n                $crc >>= 1;\n            }\n        }\n        ${$self->{'_crcTable'}}[$i] = $crc;\n    }\n}\n\n\n=head2 _crc32\n\n Title   : _crc32\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _crc32 {\n    my( $self, $str ) = @_;\n\n    $self->throw(\"Argument to crc32() must be ref to scalar\")\n        unless ref($str) eq 'SCALAR';\n\n    $self->_generateCRCTable() unless exists $self->{'_crcTable'};\n\n    my $len = length($$str);\n\n    my $crc = 0xFFFFFFFF;\n    for (my $i = 0; $i < $len; $i++) {\n        # Get upper case value of each letter\n        my $int = ord uc substr $$str, $i, 1;\n        $crc = (($crc >> 8) & 0x00FFFFFF) ^\n            ${$self->{'_crcTable'}}[ ($crc ^ $int) & 0xFF ];\n    }\n    return $crc;\n}\n\n=head2 _crc64\n\n Title   : _crc64\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _crc64{\n    my ($self, $sequence) = @_;\n    my $POLY64REVh = 0xd8000000;\n    my @CRCTableh = 256;\n    my @CRCTablel = 256;\n    my $initialized;\n\n    my $seq = $$sequence;\n\n    my $crcl = 0;\n    my $crch = 0;\n    if (!$initialized) {\n        $initialized = 1;\n        for (my $i=0; $i<256; $i++) {\n            my $partl = $i;\n            my $parth = 0;\n            for (my $j=0; $j<8; $j++) {\n                my $rflag = $partl & 1;\n                $partl >>= 1;\n                $partl |= (1 << 31) if $parth & 1;\n                $parth >>= 1;\n                $parth ^= $POLY64REVh if $rflag;\n            }\n            $CRCTableh[$i] = $parth;\n            $CRCTablel[$i] = $partl;\n        }\n    }\n\n    foreach (split '', $seq) {\n        my $shr = ($crch & 0xFF) << 24;\n        my $temp1h = $crch >> 8;\n        my $temp1l = ($crcl >> 8) | $shr;\n        my $tableindex = ($crcl ^ (unpack \"C\", $_)) & 0xFF;\n        $crch = $temp1h ^ $CRCTableh[$tableindex];\n        $crcl = $temp1l ^ $CRCTablel[$tableindex];\n    }\n    my $crc64 = sprintf(\"%08X%08X\", $crch, $crcl);\n    return $crc64;\n}\n\n=head2 _print_swissprot_FTHelper\n\n Title   : _print_swissprot_FTHelper\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _print_swissprot_FTHelper {\n    my ($self,$fth,$always_quote) = @_;\n    $always_quote ||= 0;\n    my ($start,$end) = ('?', '?');\n\n    if ( ! ref $fth || ! $fth->isa('Bio::SeqIO::FTHelper') ) {\n        $fth->warn(\"$fth is not a FTHelper class. \".\n                   \"Attempting to print, but there could be tears!\");\n    }\n    my $desc = \"\";\n\n    for my $tag ( qw(description gene note product) ) {\n        if ( exists $fth->field->{$tag} ) {\n            $desc = @{$fth->field->{$tag}}[0].\".\";\n            last;\n        }\n    }\n    $desc =~ s/\\.$//;\n\n    my $ftid = \"\";\n    if ( exists $fth->field->{'FTId'} ) {\n        $ftid = @{$fth->field->{'FTId'}}[0]. '.';\n    }\n\n    my $key =substr($fth->key,0,8);\n    my $loc = $fth->loc;\n    if ( $loc =~ /(\\?|\\d+|\\>\\d+|<\\d+)?\\.\\.(\\?|\\d+|<\\d+|>\\d+)?/ ) {\n        $start = $1 if defined $1;\n        $end = $2 if defined $2;\n\n        # to_FTString only returns one value when start == end, #JB955\n        # so if no match is found, assume it is both start and end #JB955\n    } elsif ( $loc =~ /join\\((\\d+)((?:,\\d+)+)?\\)/) {\n        my @y = ($1);\n        if ( defined( my $m = $2) ) {\n            $m =~ s/^\\,//;\n            push @y, split(/,/,$m);\n        }\n        for my $x ( @y ) {\n            $self->_write_line_swissprot_regex(\n                                               sprintf(\"FT   %-8s %6s %6s       \",\n                                                       $key,\n                                                       $x ,$x),\n                                               \"FT                                \",\n                                               $desc.'.','\\s+|$',$LINE_LENGTH);\n        }\n        return;\n    } else {\n        $start = $end = $fth->loc;\n    }\n    if ($desc) {\n        $self->_write_line_swissprot_regex(sprintf(\"FT   %-8s %6s %6s       \",\n                                                   $key,\n                                                   $start ,$end),\n                                           \"FT                                \",\n                                           $desc. '.', '\\s+|$', $LINE_LENGTH);\n    } else {                    #HELIX and STRAND do not have descriptions\n        $self->_write_line_swissprot_regex(sprintf(\"FT   %-8s %6s %6s\",\n                                                   $key,\n                                                   $start ,$end),\n                                           \"FT                         \",\n                                           ' ', '\\s+|$', $LINE_LENGTH);\n    }\n\n\n    if ($ftid) {\n        $self->_write_line_swissprot_regex(\"FT                                \",\n                                           \"FT                                \",\n                                           \"/FTId=$ftid\",'.|$',$LINE_LENGTH);\n\n    }\n\n}\n#'\n\n=head2 _read_swissprot_References\n\n Title   : _read_swissprot_References\n Usage   :\n Function: Reads references from swissprot format. Internal function really\n Example :\n Returns :\n Args    :\n\n\n\nsub _read_swissprot_References{\n    my ($self,$line) = @_;\n    my ($b1, $b2, $rp, $rg, $title, $loc, $au, $med, $com, $pubmed, $doi);\n    my @refs;\n    local $_ = $line;\n    while ( defined $_ ) {\n        if ( /^[^R]/ || /^RN/ ) {\n            if ( $rp ) {\n                $rg =~ s/;\\s*$//g if defined($rg);\n                if (defined($au)) {\n                    $au =~ s/;\\s*$//;\n                } else {\n                    $au = $rg;\n                }\n                $title =~ s/;\\s*$//g if defined($title);\n                push @refs, Bio::Annotation::Reference->new\n                    (-title   => $title,\n                     -start   => $b1,\n                     -end     => $b2,\n                     -authors => $au,\n                     -location=> $loc,\n                     -medline => $med,\n                     -pubmed  => $pubmed,\n                     -doi     => $doi,\n                     -comment => $com,\n                     -rp      => $rp,\n                     -rg      => $rg,\n                     -tagname => 'reference',\n                    );\n                # reset state for the next reference\n                $rp = '';\n            }\n            if (index($_,'R') != 0) {\n                $self->_pushback($_); # want this line to go back on the list\n                last;           # may be the safest exit point HL 05/11/2000\n            }\n            # don't forget to reset the state for the next reference\n            $b1 = $b2 = $rg = $med = $com = $pubmed = $doi = undef;\n            $title = $loc = $au = undef;\n        } elsif ( /^RP\\s{3}(.+? OF (\\d+)-(\\d+).*)/) {\n            $rp  .= $1;\n            $b1   = $2;\n            $b2   = $3;\n        } elsif ( /^RP\\s{3}(.*)/) {\n            if ($rp) {\n                $rp .= \" \".$1;\n            } else {\n                $rp = $1;\n            }\n        } elsif (/^RX\\s{3}(.*)/) { # each reference can have only one RX line\n            my $line = $1;\n            $med = $1 if $line =~ /MEDLINE=(\\d+);/;\n            $pubmed = $1 if $line =~ /PubMed=(\\d+);/;\n            $doi = $1 if $line =~ /DOI=(.+);/;\n        } elsif ( /^RA\\s{3}(.*)/ ) {\n            $au .= $au ? \" $1\" : $1;\n        } elsif ( /^RG\\s{3}(.*)/ ) {\n            $rg .= $rg ? \" $1\" : $1;\n        } elsif ( /^RT\\s{3}(.*)/ ) {\n            if ($title) {\n                my $tline = $1;\n                $title .= ($title =~ /[\\w;,:\\?!]$/) ? \" $tline\" : $tline;\n            } else {\n                $title = $1;\n            }\n        } elsif (/^RL\\s{3}(.*)/ ) {\n            $loc .= $loc ? \" $1\" : $1;\n        } elsif ( /^RC\\s{3}(.*)/ ) {\n            $com .= $com ? \" $1\" : $1;\n        }\n        $_ = $self->_readline;\n    }\n    return \\@refs;\n}\n\n\n=head2 _read_swissprot_Species\n\n Title   : _read_swissprot_Species\n Usage   :\n Function: Reads the swissprot Organism species and classification\n           lines.\n             Able to deal with unconventional species names.\n Example : OS Unknown prokaryotic organism\n             $genus = undef ; $species = Unknown prokaryotic organism\n Returns : A Bio::Species object\n Args    :\n\n\nsub _read_swissprot_Species {\n    my( $self,$line ) = @_;\n    my $org;\n    local $_ = $line;\n\n    my( $sub_species, $species, $genus, $common, $variant, $ncbi_taxid, $sci_name, $class_lines, $descr );\n    my $osline = \"\";\n    my $do_genus_check = 1;\n    while ( defined $_ ) {\n        last unless /^O[SCGX]/;\n        # believe it or not, but OS may come multiple times -- at this time\n        # we can't capture multiple species\n        if (/^OS\\s+(\\S.+)/ && (! defined($sci_name))) {\n            $osline .= \" \" if $osline;\n            $osline .= $1;\n            if ($osline =~ s/(,|, and|\\.)$//) {\n                # OS lines are usually like:\n                # Homo sapiens (human)\n                # where we have $sci_name followed by $descr (common name) in\n                # brackets, but we can also have:\n                # Venerupis (Ruditapes) philippinarum\n                # where we have brackets but they don't indicate a $descr\n                if ($osline =~ /[^\\(\\)]+\\(.+\\)[^\\(\\)]+$/) {\n                    #*** Danger! no idea if this will pick up some syntaxes for\n                    #    common names as well)\n                    $sci_name = $osline;\n                    $sci_name =~ s/\\.$//;\n                    $descr = '';\n                    $do_genus_check = 0;\n                } else {\n                    ($sci_name, $descr) = $osline =~ /(\\S[^\\(]+)(.*)/;\n                }\n                $sci_name =~ s/\\s+$//;\n\n                while ($descr =~ /\\(([^\\)]+)\\)/g) {\n                    my $item = $1;\n                    # strain etc may not necessarily come first (yes, swissprot\n                    # is messy)\n                    if ((! defined($variant)) &&\n                        (($item =~ /(^|[^\\(\\w])([Ss]train|isolate|serogroup|serotype|subtype|clone)\\b/) ||\n                         ($item =~ /^(biovar|pv\\.|type\\s+)/))) {\n                        $variant = $item;\n                    } elsif ($item =~ s/^subsp\\.\\s+//) {\n                        if (! $sub_species) {\n                            $sub_species = $item;\n                        } elsif (! $variant) {\n                            $variant = $item;\n                        }\n                    } elsif (! defined($common)) {\n                        # we're only interested in the first common name\n                        $common = $item;\n                        if ((index($common, '(') >= 0) &&\n                            (index($common, ')') < 0)) {\n                            $common .= ')';\n                        }\n                    }\n                }\n            }\n        } elsif (s/^OC\\s+(\\S.+)$//) {\n            $class_lines .= $1;\n        } elsif (/^OG\\s+(.*)/) {\n            $org = $1;\n        } elsif (/^OX\\s+(.*)/ && (! defined($ncbi_taxid))) {\n            my $taxstring = $1;\n            # we only keep the first one and ignore all others\n            if ($taxstring =~ /NCBI_TaxID=([\\w\\d]+)/) {\n                $ncbi_taxid = $1;\n            } else {\n                $self->throw(\"$taxstring doesn't look like NCBI_TaxID\");\n            }\n        }\n        $_ = $self->_readline;\n    }\n    $self->_pushback($_);       # pushback the last line because we need it\n\n    $sci_name || return;\n\n    # if the organism belongs to taxid 32644 then no Bio::Species object.\n    return if grep { $_ eq $sci_name } @Unknown_names;\n\n    # Convert data in classification lines into classification array.\n    # Remove trailing . then split on ';' or '.;' so that classification that is 2\n    # or more words will still get matched, use map() to remove trailing/leading/intervening\n    # spaces\n    $class_lines=~s/\\.\\s*$//;\n    my @class = map { s/^\\s+//; s/\\s+$//; s/\\s{2,}/ /g; $_; } split /[;\\.]*;/, $class_lines;\n\n    if ($class[0] =~ /viruses/i) {\n        # viruses have different OS/OC syntax\n        my @virusnames = split(/\\s+/, $sci_name);\n        $species = (@virusnames > 1) ? pop(@virusnames) : '';\n        $genus = join(\" \", @virusnames);\n        $sub_species = $descr;\n    } elsif ($do_genus_check) {\n        # do we have a genus?\n        my $possible_genus = $class[-1];\n        $possible_genus .= \"|$class[-2]\" if $class[-2];\n        if ($sci_name =~ /^($possible_genus)/) {\n            $genus = $1;\n            ($species) = $sci_name =~ /^$genus\\s+(.+)/;\n        } else {\n            $species = $sci_name;\n        }\n        # is this organism of rank species or is it lower?\n        # (doesn't catch everything, but at least the guess isn't dangerous)\n        if ($species && $species =~ /subsp\\.|var\\./) {\n            ($species, $sub_species) = $species =~ /(.+)\\s+((?:subsp\\.|var\\.).+)/;\n        }\n    }\n\n    # Bio::Species array needs array in Species -> Kingdom direction\n    unless ($class[-1] eq $sci_name) {\n        push(@class, $sci_name);\n    }\n    @class = reverse @class;\n\n    my $taxon = Bio::Species->new();\n    $taxon->scientific_name($sci_name);\n    $taxon->classification(@class);\n    $taxon->common_name($common) if $common;\n    $taxon->sub_species($sub_species) if $sub_species;\n    $taxon->organelle($org) if $org;\n    $taxon->ncbi_taxid($ncbi_taxid) if $ncbi_taxid;\n    $taxon->variant($variant) if $variant;\n\n    # done\n    return $taxon;\n}\n\n=head2 _filehandle\n\n Title   : _filehandle\n Usage   : $obj->_filehandle($newval)\n Function:\n Example :\n Returns : value of _filehandle\n Args    : newvalue (optional)\n\n\n\n# inherited from SeqIO.pm ! HL 05/11/2000\n\n=head2 _read_FTHelper_swissprot\n\n Title   : _read_FTHelper_swissprot\n Usage   : _read_FTHelper_swissprot(\\$buffer)\n Function: reads the next FT key line\n Example :\n Returns : Bio::SeqIO::FTHelper object\n Args    :\n\n\n\nsub _read_FTHelper_swissprot {\n    my ($self,$line ) = @_;\n    # initial version implemented by HL 05/10/2000\n    # FIXME this may not be perfect, so please review\n    # lots of cleaning up by JES 2004/07/01, still may not be perfect =)\n    # FTId now sepated from description as a qualifier\n\n    local $_ = $line;\n    my ($key,                   # The key of the feature\n        $loc,                   # The location line from the feature\n        $desc,                  # The descriptive text\n        $ftid,                  # feature Id is like a qualifier but there can be only one of them\n       );\n    if ( m/^FT\\s{3}(\\w+)\\s+([\\d\\?\\<]+)\\s+([\\d\\?\\>]+)\\s*(.*)$/ox) {\n        $key = $1;\n        my $loc1 = $2;\n        my $loc2 = $3;\n        $loc = \"$loc1..$loc2\";\n        if ($4 && (length($4) > 0)) {\n            $desc = $4;\n            chomp($desc);\n        } else {\n            $desc = \"\";\n        }\n    }\n\n    while ( defined($_ = $self->_readline) && /^FT\\s{20,}(\\S.*)$/ ) {\n        my $continuation_line = $1;\n        if ( $continuation_line =~ /.FTId=(.*)\\./ ) {\n            $ftid=$1;\n        }\n        elsif ( $desc) {\n            $desc .= \" $continuation_line\";\n        } else {\n            $desc = $continuation_line;\n        }\n        chomp $desc;\n    }\n    $self->_pushback($_);\n    unless( $key ) {\n        # No feature key. What's this?\n        $self->warn(\"No feature key in putative feature table line: $line\");\n        return;\n    }\n\n    # Make the new FTHelper object\n    my $out = Bio::SeqIO::FTHelper->new(-verbose => $self->verbose());\n    $out->key($key);\n    $out->loc($loc);\n\n    # store the description if there is one\n    if ( $desc && length($desc) ) {\n        $desc =~ s/\\.$//;\n        push(@{$out->field->{\"description\"}}, $desc);\n    }\n    # Store the qualifier i.e. FTId\n    if ( $ftid ) {\n        push(@{$out->field->{\"FTId\"}}, $ftid);\n    }\n    return $out;\n}\n\n\n=head2 _write_line_swissprot\n\n Title   : _write_line_swissprot\n Usage   :\n Function: internal function\n Example :\n Returns :\n Args    :\n\n\n\nsub _write_line_swissprot{\n    my ($self,$pre1,$pre2,$line,$length) = @_;\n\n    $length || $self->throw( \"Miscalled write_line_swissprot without length. Programming error!\");\n    my $subl = $length - length $pre2;\n    my $linel = length $line;\n    my $i;\n\n    my $sub = substr($line,0,$length - length $pre1);\n\n    $self->_print( \"$pre1$sub\\n\");\n\n    for ($i= ($length - length $pre1);$i < $linel;) {\n        $sub = substr($line,$i,($subl));\n        $self->_print( \"$pre2$sub\\n\");\n        $i += $subl;\n    }\n\n}\n\n=head2 _write_line_swissprot_regex\n\n Title   : _write_line_swissprot_regex\n Usage   :\n Function: internal function for writing lines of specified\n           length, with different first and the next line\n           left hand headers and split at specific points in the\n           text\n Example :\n Returns : nothing\n Args    : file handle, first header, second header, text-line, regex for line breaks, total line length"}},{"containerName":"main::","name":"_post_sort","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"_post_sort","name":"$obj","line":1419},{"definition":"my","kind":13,"localvar":"my","containerName":"_post_sort","name":"$value","line":1421},{"line":1422,"name":"$obj","containerName":"_post_sort","kind":13},{"line":1422,"name":"$value","containerName":"_post_sort","kind":13},{"line":1424,"name":"$obj","kind":13,"containerName":"_post_sort"}],"definition":"sub","range":{"end":{"character":9999,"line":1426},"start":{"line":1418,"character":0}},"kind":12,"line":1418},{"range":{"start":{"character":0,"line":1439},"end":{"character":9999,"line":1447}},"kind":12,"line":1439,"definition":"sub","name":"_show_dna","containerName":"main::","children":[{"definition":"my","containerName":"_show_dna","localvar":"my","kind":13,"name":"$obj","line":1440},{"definition":"my","line":1442,"name":"$value","localvar":"my","kind":13,"containerName":"_show_dna"},{"containerName":"_show_dna","kind":13,"name":"$obj","line":1443},{"containerName":"_show_dna","kind":13,"name":"$value","line":1443},{"kind":13,"containerName":"_show_dna","name":"$obj","line":1445}]},{"children":[{"name":"$obj","localvar":"my","kind":13,"containerName":"_id_generation_func","line":1461,"definition":"my"},{"definition":"my","containerName":"_id_generation_func","localvar":"my","kind":13,"name":"$value","line":1463},{"line":1464,"containerName":"_id_generation_func","kind":13,"name":"$obj"},{"line":1464,"name":"$value","kind":13,"containerName":"_id_generation_func"},{"line":1466,"name":"$obj","containerName":"_id_generation_func","kind":13}],"containerName":"main::","name":"_id_generation_func","definition":"sub","line":1460,"kind":12,"range":{"end":{"character":9999,"line":1468},"start":{"character":0,"line":1460}}},{"name":"_ac_generation_func","containerName":"main::","children":[{"definition":"my","containerName":"_ac_generation_func","localvar":"my","kind":13,"name":"$obj","line":1482},{"line":1484,"kind":13,"localvar":"my","containerName":"_ac_generation_func","name":"$value","definition":"my"},{"name":"$obj","kind":13,"containerName":"_ac_generation_func","line":1485},{"line":1485,"containerName":"_ac_generation_func","kind":13,"name":"$value"},{"line":1487,"containerName":"_ac_generation_func","kind":13,"name":"$obj"}],"definition":"sub","kind":12,"range":{"end":{"character":9999,"line":1489},"start":{"line":1481,"character":0}},"line":1481},{"kind":12,"range":{"start":{"character":0,"line":1502},"end":{"line":1510,"character":9999}},"line":1502,"name":"_sv_generation_func","containerName":"main::","children":[{"line":1503,"containerName":"_sv_generation_func","localvar":"my","kind":13,"name":"$obj","definition":"my"},{"line":1505,"kind":13,"localvar":"my","containerName":"_sv_generation_func","name":"$value","definition":"my"},{"line":1506,"name":"$obj","containerName":"_sv_generation_func","kind":13},{"line":1506,"name":"$value","kind":13,"containerName":"_sv_generation_func"},{"name":"$obj","kind":13,"containerName":"_sv_generation_func","line":1508}],"definition":"sub"},{"line":1523,"kind":12,"range":{"end":{"character":9999,"line":1531},"start":{"line":1523,"character":0}},"definition":"sub","children":[{"definition":"my","localvar":"my","containerName":"_kw_generation_func","kind":13,"name":"$obj","line":1524},{"definition":"my","line":1526,"containerName":"_kw_generation_func","localvar":"my","kind":13,"name":"$value"},{"name":"$obj","containerName":"_kw_generation_func","kind":13,"line":1527},{"line":1527,"kind":13,"containerName":"_kw_generation_func","name":"$value"},{"name":"$obj","kind":13,"containerName":"_kw_generation_func","line":1529}],"containerName":"main::","name":"_kw_generation_func"}],"version":5}