{"version":5,"vars":[{"containerName":"","kind":2,"name":"base","line":96},{"definition":"my","line":98,"name":"$c","kind":13,"localvar":"my","containerName":null},{"line":98,"kind":12,"name":"new"},{"line":98,"kind":12,"containerName":"Binary::C","name":"Convert"},{"line":99,"kind":12,"name":"ByteOrder"},{"kind":12,"name":"Alignment","line":100},{"line":103,"kind":13,"localvar":"my","containerName":null,"name":"%headerdef","definition":"my"},{"line":107,"kind":13,"containerName":null,"name":"$headerdef"},{"line":107,"name":"DATA","kind":12},{"line":109,"containerName":null,"kind":13,"name":"$c"},{"line":109,"name":"parse","kind":12,"containerName":"main::"},{"name":"$headerdef","containerName":null,"kind":13,"line":109},{"definition":"my","line":111,"localvar":"my","containerName":null,"kind":13,"name":"$size_F_HEADER"},{"line":113,"name":"$size_F_HEADER","containerName":null,"kind":13},{"name":"$c","containerName":null,"kind":13,"line":113},{"line":113,"name":"sizeof","containerName":"main::","kind":12},{"definition":"my","line":115,"kind":13,"localvar":"my","containerName":null,"name":"%alphabet2type"},{"kind":12,"name":"dna","line":126},{"name":"rna","kind":12,"line":127},{"name":"protein","kind":12,"line":128},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"%type2alphabet","line":131},{"line":131,"kind":13,"containerName":null,"name":"%alphabet2type"},{"definition":"sub","detail":"($self,@args)","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"_initialize","line":134,"definition":"my"},{"containerName":"_initialize","kind":13,"name":"@args","line":134},{"line":135,"kind":13,"containerName":"_initialize","name":"$self"},{"name":"@args","kind":13,"containerName":"_initialize","line":135},{"kind":13,"containerName":"_initialize","name":"$self","line":136},{"line":136,"name":"sequence_factory","containerName":"_initialize","kind":12},{"name":"$self","kind":13,"containerName":"_initialize","line":137},{"line":137,"name":"sequence_factory","kind":12,"containerName":"_initialize"},{"kind":12,"containerName":"_initialize","name":"new","line":137},{"kind":13,"containerName":"_initialize","name":"$self","line":137},{"line":137,"name":"verbose","kind":12,"containerName":"_initialize"}],"name":"_initialize","containerName":"main::","signature":{"label":"_initialize($self,@args)","documentation":"","parameters":[{"label":"$self"},{"label":"@args"}]},"line":133,"range":{"start":{"line":133,"character":0},"end":{"line":140,"character":9999}},"kind":12},{"line":135,"kind":12,"containerName":"_initialize","name":"SUPER"},{"line":137,"kind":12,"containerName":"Seq::SeqFactory","name":"Bio"},{"children":[{"definition":"my","line":153,"localvar":"my","kind":13,"containerName":"next_seq","name":"$self"},{"definition":"my","line":154,"name":"$fh","containerName":"next_seq","localvar":"my","kind":13},{"line":154,"kind":13,"containerName":"next_seq","name":"$self"},{"line":154,"containerName":"next_seq","kind":12,"name":"_fh"},{"definition":"my","name":"$header","localvar":"my","containerName":"next_seq","kind":13,"line":155},{"line":155,"name":"$sequence","containerName":"next_seq","kind":13},{"line":155,"kind":13,"containerName":"next_seq","name":"$fulldesc"},{"line":156,"name":"$fh","kind":13,"containerName":"next_seq"},{"line":156,"name":"$header","containerName":"next_seq","kind":13},{"line":156,"name":"$size_F_HEADER","kind":13,"containerName":"next_seq"},{"kind":13,"containerName":"next_seq","name":"$self","line":157},{"line":157,"kind":12,"containerName":"next_seq","name":"throw"},{"line":157,"name":"$self","containerName":"next_seq","kind":13},{"line":158,"containerName":"next_seq","kind":13,"name":"$self"},{"containerName":"next_seq","kind":12,"name":"throw","line":158},{"line":158,"name":"$self","containerName":"next_seq","kind":13},{"containerName":"next_seq","kind":13,"name":"$header","line":158},{"line":159,"kind":13,"containerName":"next_seq","name":"$size_F_HEADER"},{"line":159,"name":"$header","kind":13,"containerName":"next_seq"},{"line":160,"name":"$headerdata","localvar":"my","containerName":"next_seq","kind":13,"definition":"my"},{"line":160,"containerName":"next_seq","kind":13,"name":"$c"},{"kind":12,"containerName":"next_seq","name":"unpack","line":160},{"containerName":"next_seq","kind":13,"name":"$header","line":160},{"line":161,"kind":13,"containerName":"next_seq","name":"$fh"},{"line":161,"kind":13,"containerName":"next_seq","name":"$sequence"},{"name":"$headerdata","containerName":"next_seq","kind":13,"line":161},{"line":162,"kind":13,"containerName":"next_seq","name":"$fh"},{"line":162,"kind":13,"containerName":"next_seq","name":"$fulldesc"},{"kind":13,"containerName":"next_seq","name":"$headerdata","line":162},{"line":163,"name":"$fulldesc","kind":13,"containerName":"next_seq"},{"definition":"my","localvar":"my","containerName":"next_seq","kind":13,"name":"$seq","line":165},{"line":165,"name":"$self","containerName":"next_seq","kind":13},{"line":165,"containerName":"next_seq","kind":12,"name":"sequence_factory"},{"name":"create","containerName":"next_seq","kind":12,"line":165},{"line":167,"kind":13,"containerName":"next_seq","name":"$sequence"},{"line":168,"kind":13,"containerName":"next_seq","name":"$fulldesc"},{"name":"$type2alphabet","kind":13,"containerName":"next_seq","line":169},{"line":169,"name":"$headerdata","kind":13,"containerName":"next_seq"},{"line":172,"name":"$seq","containerName":"next_seq","kind":13}],"containerName":"main::","name":"next_seq","definition":"sub","detail":"($self)","line":152,"kind":12,"range":{"end":{"character":9999,"line":173},"start":{"line":152,"character":0}},"signature":{"label":"next_seq($self)","documentation":"};\n# $Id: strider.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::SeqIO::strider\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Malcolm Cook <mec@stowers-institute.org>\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 7th, 2005  Malcolm Cook authored\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::strider - DNA strider sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::SeqIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from strider\n'binary' format, as documented in the strider manual, in which the\nfirst 112 bytes are a header, following by the sequence, followed by a\nsequence description.\n\nNote: it does NOT assign any sequence identifier, since they are not\ncontained in the byte stream of the file; the Strider application\nsimply displays the name of the file on disk as the name of the\nsequence. The caller should set the id, probably based on the name of\nthe file (after possibly cleaning up whitespace, which ought not to be\nused as the id in most applications).\n\nNote: the strider 'comment' is mapped to the BioPerl 'description'\n(since there is no other text field, and description maps to defline\ntext).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Malcolm Cook\n\nEmail: mec@stowers-institute.org\n\n=head1 CONTRIBUTORS\n\nModelled after Bio::SeqIO::fasta by Ewan Birney E<lt>birney@ebi.ac.ukE<gt> and\nLincoln Stein E<lt>lstein@cshl.orgE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::strider;\nuse strict;\nuse warnings;\n\n\nuse Bio::Seq::SeqFactory;\nuse Convert::Binary::C;\n\nuse base qw(Bio::SeqIO);\n\nmy $c = new Convert::Binary::C (\n\t\t\t\tByteOrder => 'BigEndian',\n\t\t\t\tAlignment => 2\n\t\t\t       );\n\nmy $headerdef;\n{local ($/);\n # See this file's __DATA__ section for the c structure definitions\n # for strider binary header data.  Here we slurp it all into $headerdef.\n $headerdef = <DATA>};\n\n$c->parse($headerdef);\n\nmy $size_F_HEADER = 112;\n\ndie \"expected strider header structure size of $size_F_HEADER\" unless $size_F_HEADER eq $c->sizeof('F_HEADER');\n\nmy %alphabet2type = (\n\t\t     # map between BioPerl alphabet and strider\n\t\t     # sequence type code.\n\n\t\t     # From Strider Documentation: the sequence type:\n\t\t     # 1, 2, 3 and 4 for DNA, DNA Degenerate, RNA and\n\t\t     # Protein sequence files, respectively.  \n\n\t\t     # TODO: determine 'DNA Degenerate' based on\n\t\t     # sequence alphabet?\n\n\t\t     dna => 1,\n\t\t     rna => 3,\n\t\t     protein => 4,\n\t\t    );\n\nmy %type2alphabet = reverse %alphabet2type;\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);  \n  unless ( defined $self->sequence_factory ) {\n    $self->sequence_factory(Bio::Seq::SeqFactory->new(-verbose => $self->verbose(), \n\t\t\t\t\t\t      -type => 'Bio::Seq::RichSeq'));\n  }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    : NONE","parameters":[{"label":"$self"}]}},{"kind":12,"name":"nLength","line":161},{"kind":12,"name":"com_length","line":162},{"name":"type","kind":12,"line":169},{"signature":{"parameters":[{"label":"$self"},{"label":"@seq"}],"documentation":"};\n# $Id: strider.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::SeqIO::strider\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Malcolm Cook <mec@stowers-institute.org>\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 7th, 2005  Malcolm Cook authored\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::strider - DNA strider sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::SeqIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from strider\n'binary' format, as documented in the strider manual, in which the\nfirst 112 bytes are a header, following by the sequence, followed by a\nsequence description.\n\nNote: it does NOT assign any sequence identifier, since they are not\ncontained in the byte stream of the file; the Strider application\nsimply displays the name of the file on disk as the name of the\nsequence. The caller should set the id, probably based on the name of\nthe file (after possibly cleaning up whitespace, which ought not to be\nused as the id in most applications).\n\nNote: the strider 'comment' is mapped to the BioPerl 'description'\n(since there is no other text field, and description maps to defline\ntext).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Malcolm Cook\n\nEmail: mec@stowers-institute.org\n\n=head1 CONTRIBUTORS\n\nModelled after Bio::SeqIO::fasta by Ewan Birney E<lt>birney@ebi.ac.ukE<gt> and\nLincoln Stein E<lt>lstein@cshl.orgE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::strider;\nuse strict;\nuse warnings;\n\n\nuse Bio::Seq::SeqFactory;\nuse Convert::Binary::C;\n\nuse base qw(Bio::SeqIO);\n\nmy $c = new Convert::Binary::C (\n\t\t\t\tByteOrder => 'BigEndian',\n\t\t\t\tAlignment => 2\n\t\t\t       );\n\nmy $headerdef;\n{local ($/);\n # See this file's __DATA__ section for the c structure definitions\n # for strider binary header data.  Here we slurp it all into $headerdef.\n $headerdef = <DATA>};\n\n$c->parse($headerdef);\n\nmy $size_F_HEADER = 112;\n\ndie \"expected strider header structure size of $size_F_HEADER\" unless $size_F_HEADER eq $c->sizeof('F_HEADER');\n\nmy %alphabet2type = (\n\t\t     # map between BioPerl alphabet and strider\n\t\t     # sequence type code.\n\n\t\t     # From Strider Documentation: the sequence type:\n\t\t     # 1, 2, 3 and 4 for DNA, DNA Degenerate, RNA and\n\t\t     # Protein sequence files, respectively.  \n\n\t\t     # TODO: determine 'DNA Degenerate' based on\n\t\t     # sequence alphabet?\n\n\t\t     dna => 1,\n\t\t     rna => 3,\n\t\t     protein => 4,\n\t\t    );\n\nmy %type2alphabet = reverse %alphabet2type;\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);  \n  unless ( defined $self->sequence_factory ) {\n    $self->sequence_factory(Bio::Seq::SeqFactory->new(-verbose => $self->verbose(), \n\t\t\t\t\t\t      -type => 'Bio::Seq::RichSeq'));\n  }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    : NONE\n\n\nsub next_seq {\n  my( $self ) = @_;\n  my $fh =  $self->_fh;\n  my ($header,$sequence,$fulldesc);\n  eval {read $fh,$header,$size_F_HEADER};\n  $self->throw (\"$@  while attempting to reading strider header from \" . $self->{'_file'}) if $@; \n  $self->throw(\"required $size_F_HEADER bytes while reading strider header in \" . $self->{'_file'} . \" but found: \" . length($header))  \n    unless $size_F_HEADER == length($header);\n  my $headerdata = $c->unpack('F_HEADER',$header) or return;\n  read $fh,$sequence,$headerdata->{nLength};\n  read $fh,$fulldesc,$headerdata->{com_length};\n  $fulldesc =~ s/\\cM/ /g;\t# gratuitous replacement of mac\n                                # linefeed with space.\n  my $seq = $self->sequence_factory->create(\n\t\t\t\t\t    # -id          => $main::ARGV, #might want to set this in caller to $ARGV.\n\t\t\t\t\t    -seq         => $sequence,\n\t\t\t\t\t    -desc        => $fulldesc,\n\t\t\t\t\t    -alphabet    => $type2alphabet{$headerdata->{type}} || 'dna',\n\t\t\t\t\t   );\n\n  return $seq;\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq(@seq)\n Function: writes the $seq object into the stream\n Returns : 1 for success and 0 for error\n Args    : array of 1 to n Bio::PrimarySeqI objects","label":"write_seq($self,@seq)"},"line":186,"range":{"start":{"line":186,"character":0},"end":{"line":202,"character":9999}},"kind":12,"definition":"sub","detail":"($self,@seq)","children":[{"kind":13,"localvar":"my","containerName":"write_seq","name":"$self","line":187,"definition":"my"},{"name":"@seq","kind":13,"containerName":"write_seq","line":187},{"definition":"my","localvar":"my","containerName":"write_seq","kind":13,"name":"$fh","line":188},{"name":"$self","containerName":"write_seq","kind":13,"line":188},{"name":"_fh","kind":12,"containerName":"write_seq","line":188},{"definition":"my","name":"$seq","localvar":"my","containerName":"write_seq","kind":13,"line":189},{"line":189,"name":"@seq","kind":13,"containerName":"write_seq"},{"line":190,"kind":13,"containerName":"write_seq","name":"$self"},{"containerName":"write_seq","kind":12,"name":"throw","line":190},{"line":191,"containerName":"write_seq","kind":13,"name":"$seq"},{"containerName":"write_seq","kind":13,"name":"$seq","line":191},{"line":191,"containerName":"write_seq","kind":13,"name":"$seq"},{"kind":12,"containerName":"write_seq","name":"isa","line":191},{"definition":"my","name":"$headerdata","containerName":"write_seq","localvar":"my","kind":13,"line":192},{"name":"$c","kind":13,"containerName":"write_seq","line":192},{"line":192,"containerName":"write_seq","kind":12,"name":"pack"},{"name":"$alphabet2type","containerName":"write_seq","kind":13,"line":194},{"line":194,"name":"$seq","containerName":"write_seq","kind":13},{"line":194,"containerName":"write_seq","kind":12,"name":"alphabet"},{"name":"$alphabet2type","kind":13,"containerName":"write_seq","line":194},{"line":195,"name":"$seq","kind":13,"containerName":"write_seq"},{"line":195,"containerName":"write_seq","kind":12,"name":"is_circular"},{"name":"$seq","kind":13,"containerName":"write_seq","line":196},{"line":196,"kind":12,"containerName":"write_seq","name":"length"},{"name":"$seq","kind":13,"containerName":"write_seq","line":198},{"line":198,"name":"desc","containerName":"write_seq","kind":12},{"line":200,"name":"$fh","containerName":"write_seq","kind":13},{"line":200,"name":"$headerdata","containerName":"write_seq","kind":13},{"line":200,"containerName":"write_seq","kind":13,"name":"$seq"},{"name":"seq","kind":12,"containerName":"write_seq","line":200},{"line":200,"containerName":"write_seq","kind":13,"name":"$seq"},{"kind":12,"containerName":"write_seq","name":"desc","line":200}],"containerName":"main::","name":"write_seq"},{"name":"versionNb","kind":12,"line":193},{"kind":12,"name":"type","line":194},{"kind":12,"name":"dna","line":194},{"line":195,"name":"topology","kind":12},{"kind":12,"name":"nLength","line":196},{"kind":12,"name":"nMinus","line":197},{"line":198,"name":"com_length","kind":12}]}