{"vars":[{"line":79,"containerName":"","kind":2,"name":"vars"},{"definition":"my","line":86,"name":"$dumper","containerName":null,"localvar":"my","kind":13},{"containerName":"","kind":2,"name":"Dumpvalue","line":86},{"name":"new","kind":12,"line":86},{"kind":12,"name":"Dumpvalue","line":86},{"line":87,"name":"$dumper","containerName":null,"kind":13},{"name":"veryCompact","kind":12,"containerName":"main::","line":87},{"line":90,"name":"$DEFAULT_QUALITY","kind":13,"containerName":null},{"kind":2,"containerName":"","name":"base","line":93},{"definition":"sub","detail":"($self,@args)","children":[{"definition":"my","name":"$self","containerName":"_initialize","localvar":"my","kind":13,"line":96},{"name":"@args","kind":13,"containerName":"_initialize","line":96},{"kind":13,"containerName":"_initialize","name":"$self","line":97},{"line":97,"containerName":"_initialize","kind":13,"name":"@args"},{"line":98,"name":"$self","containerName":"_initialize","kind":13},{"line":98,"kind":12,"containerName":"_initialize","name":"sequence_factory"},{"line":99,"kind":13,"containerName":"_initialize","name":"$self"},{"line":99,"name":"sequence_factory","containerName":"_initialize","kind":12},{"line":100,"name":"new","containerName":"_initialize","kind":12},{"line":100,"kind":13,"containerName":"_initialize","name":"$self"},{"line":100,"name":"verbose","kind":12,"containerName":"_initialize"},{"containerName":"_initialize","kind":13,"name":"$self","line":103},{"line":103,"containerName":"_initialize","kind":12,"name":"_fh"}],"name":"_initialize","containerName":"main::","signature":{"label":"_initialize($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":""},"line":95,"kind":12,"range":{"start":{"line":95,"character":0},"end":{"character":9999,"line":104}}},{"line":97,"kind":12,"containerName":"_initialize","name":"SUPER"},{"kind":12,"containerName":"Seq::SeqFactory","name":"Bio","line":99},{"signature":{"parameters":[{"label":"$self"}],"documentation":"__END__\n# $Id: scf.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::scf - .scf file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly. Use it via the Bio::SeqIO class, see\nL<Bio::SeqIO> for more information.\n\n=head1 DESCRIPTION\n\nThis object can transform .scf files to and from Bio::Seq::SequenceTrace\nobjects.  Mechanisms are present to retrieve trace data from scf\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chad Matsalla\n\nChad Matsalla\nbioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\nTony Cox, avc@sanger.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nNancy Hansen, nhansen at mail.nih.gov\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::scf;\nuse vars qw($DEFAULT_QUALITY);\nuse strict;\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SequenceTrace;\nuse Bio::Annotation::Comment;\nuse Dumpvalue;\n\nmy $dumper = new Dumpvalue();\n$dumper->veryCompact(1);\n\nBEGIN {\n    $DEFAULT_QUALITY= 10;\n}\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n                  (-verbose => $self->verbose(),\n                   -type => 'Bio::Seq::Quality'));\n  }\n  binmode $self->_fh; # for the Win32/Mac crowds  \n}\n\n=head2 next_seq()\n\n Title   : next_seq()\n Usage   : $scf = $stream->next_seq()\n Function: returns the next scf sequence in the stream\n Returns : a Bio::Seq::SequenceTrace object\n Args    : NONE\n Notes   : Fills the interface specification for SeqIO.\n            The SCF specification does not provide for having more then\n           one sequence in a given scf. So once the filehandle has been open\n           and passed to SeqIO do not expect to run this function more then\n           once on a given scf unless you embraced and extended the SCF\n       standard.  SCF comments are accessible through the Bio::SeqI\n           interface method annotation().\n\n'","label":"next_seq($self)"},"kind":12,"range":{"end":{"line":210,"character":9999},"start":{"line":124,"character":0}},"line":124,"detail":"($self)","definition":"sub","containerName":"main::","name":"next_seq","children":[{"definition":"my","line":125,"name":"$self","localvar":"my","containerName":"next_seq","kind":13},{"definition":"my","name":"$seq","localvar":"my","containerName":"next_seq","kind":13,"line":126},{"name":"$seqc","kind":13,"containerName":"next_seq","line":126},{"containerName":"next_seq","kind":13,"name":"$fh","line":126},{"name":"$buffer","containerName":"next_seq","kind":13,"line":126},{"kind":13,"containerName":"next_seq","name":"$offset","line":126},{"line":126,"name":"$length","kind":13,"containerName":"next_seq"},{"line":126,"name":"$read_bytes","containerName":"next_seq","kind":13},{"line":126,"name":"@read","containerName":"next_seq","kind":13},{"kind":13,"containerName":"next_seq","name":"%names","line":127},{"line":129,"name":"$self","kind":13,"containerName":"next_seq"},{"kind":13,"containerName":"next_seq","name":"$fh","line":130},{"line":130,"name":"$self","containerName":"next_seq","kind":13},{"line":130,"name":"_fh","containerName":"next_seq","kind":12},{"containerName":"next_seq","kind":13,"name":"$fh","line":131},{"containerName":"next_seq","localvar":"my","kind":13,"name":"$ARGV","line":133,"definition":"my"},{"line":134,"name":"$ARGV","kind":13,"containerName":"next_seq"},{"name":"$self","containerName":"next_seq","kind":13,"line":135},{"name":"throw","kind":12,"containerName":"next_seq","line":135},{"containerName":"next_seq","kind":13,"name":"$fh","line":137},{"line":139,"kind":13,"containerName":"next_seq","name":"$fh"},{"line":139,"kind":13,"containerName":"next_seq","name":"$buffer"},{"definition":"my","kind":13,"localvar":"my","containerName":"next_seq","name":"$creator","line":141},{"line":147,"kind":13,"containerName":"next_seq","name":"$creator"},{"line":147,"containerName":"next_seq","kind":13,"name":"$self"},{"line":147,"name":"_get_header","containerName":"next_seq","kind":12},{"name":"$buffer","kind":13,"containerName":"next_seq","line":147},{"name":"$creator","containerName":"next_seq","kind":13,"line":148},{"line":149,"name":"$self","containerName":"next_seq","kind":13},{"line":149,"name":"debug","kind":12,"containerName":"next_seq"},{"line":151,"name":"$length","kind":13,"containerName":"next_seq"},{"line":151,"kind":13,"containerName":"next_seq","name":"$creator"},{"line":152,"name":"$creator","containerName":"next_seq","kind":13},{"name":"$buffer","kind":13,"containerName":"next_seq","line":153},{"line":153,"containerName":"next_seq","kind":13,"name":"$self"},{"name":"read_from_buffer","kind":12,"containerName":"next_seq","line":153},{"name":"$fh","kind":13,"containerName":"next_seq","line":153},{"line":153,"containerName":"next_seq","kind":13,"name":"$buffer"},{"kind":13,"containerName":"next_seq","name":"$length","line":153},{"kind":13,"containerName":"next_seq","name":"$creator","line":154},{"line":158,"name":"$creator","containerName":"next_seq","kind":13},{"line":158,"containerName":"next_seq","kind":13,"name":"$self"},{"line":158,"containerName":"next_seq","kind":12,"name":"_parse_v2_traces"},{"line":159,"kind":13,"containerName":"next_seq","name":"$buffer"},{"name":"$creator","kind":13,"containerName":"next_seq","line":159},{"name":"$offset","kind":13,"containerName":"next_seq","line":161},{"line":161,"kind":13,"containerName":"next_seq","name":"$creator"},{"name":"$length","containerName":"next_seq","kind":13,"line":162},{"name":"$creator","kind":13,"containerName":"next_seq","line":162},{"line":163,"kind":13,"containerName":"next_seq","name":"$fh"},{"line":163,"name":"$offset","containerName":"next_seq","kind":13},{"name":"$buffer","containerName":"next_seq","kind":13,"line":164},{"line":164,"kind":13,"containerName":"next_seq","name":"$self"},{"line":164,"name":"read_from_buffer","kind":12,"containerName":"next_seq"},{"line":164,"containerName":"next_seq","kind":13,"name":"$fh"},{"name":"$buffer","containerName":"next_seq","kind":13,"line":164},{"line":164,"name":"$length","kind":13,"containerName":"next_seq"},{"line":164,"kind":13,"containerName":"next_seq","name":"$creator"},{"containerName":"next_seq","kind":13,"name":"$creator","line":168},{"line":169,"kind":13,"containerName":"next_seq","name":"$creator"},{"line":170,"name":"$creator","containerName":"next_seq","kind":13},{"containerName":"next_seq","kind":13,"name":"$creator","line":171},{"line":171,"name":"$self","containerName":"next_seq","kind":13},{"name":"_parse_v2_bases","containerName":"next_seq","kind":12,"line":171},{"kind":13,"containerName":"next_seq","name":"$buffer","line":171},{"line":174,"name":"$self","containerName":"next_seq","kind":13},{"line":174,"containerName":"next_seq","kind":12,"name":"debug"},{"definition":"my","line":175,"name":"$transformed_read","kind":13,"localvar":"my","containerName":"next_seq"},{"name":"$current_read_position","localvar":"my","containerName":"next_seq","kind":13,"line":176,"definition":"my"},{"line":176,"name":"$creator","kind":13,"containerName":"next_seq"},{"line":177,"kind":13,"containerName":"next_seq","name":"$length"},{"kind":13,"containerName":"next_seq","name":"$creator","line":177},{"name":"$creator","containerName":"next_seq","kind":13,"line":178},{"line":181,"name":"$buffer","containerName":"next_seq","kind":13},{"line":181,"name":"$self","containerName":"next_seq","kind":13},{"name":"read_from_buffer","containerName":"next_seq","kind":12,"line":181},{"line":181,"kind":13,"containerName":"next_seq","name":"$fh"},{"line":181,"kind":13,"containerName":"next_seq","name":"$buffer"},{"line":181,"name":"$length","containerName":"next_seq","kind":13},{"name":"$current_read_position","kind":13,"containerName":"next_seq","line":181},{"name":"$byte","containerName":"next_seq","localvar":"my","kind":13,"line":182,"definition":"my"},{"line":183,"kind":13,"containerName":"next_seq","name":"$creator"},{"line":184,"kind":13,"containerName":"next_seq","name":"$byte"},{"kind":13,"containerName":"next_seq","name":"@read","line":186},{"line":186,"kind":13,"containerName":"next_seq","name":"$buffer"},{"line":195,"containerName":"next_seq","kind":13,"name":"@read"},{"line":200,"name":"$transformed_read","containerName":"next_seq","kind":13},{"kind":13,"containerName":"next_seq","name":"$self","line":200},{"line":200,"containerName":"next_seq","kind":12,"name":"_delta"},{"containerName":"next_seq","kind":13,"name":"@read","line":200},{"name":"$creator","kind":13,"containerName":"next_seq","line":203},{"line":204,"kind":13,"containerName":"next_seq","name":"$transformed_read"},{"name":"$current_read_position","kind":13,"containerName":"next_seq","line":208},{"line":208,"containerName":"next_seq","kind":13,"name":"$length"},{"name":"$creator","kind":13,"containerName":"next_seq","line":209},{"name":"$transformed_read","containerName":"next_seq","kind":13,"line":209}]},{"line":129,"kind":12,"name":"_readfile"},{"name":"ARGV","kind":12,"line":132},{"name":"ARGV","kind":12,"line":132},{"name":"ARGV","kind":12,"line":134},{"name":"header","kind":12,"line":147},{"name":"header","kind":12,"line":148},{"line":151,"name":"header","kind":12},{"line":152,"kind":12,"name":"header"},{"kind":12,"name":"sample_size","line":152},{"line":154,"kind":12,"name":"header"},{"line":154,"name":"samples_offset","kind":12},{"name":"traces","kind":12,"line":158},{"line":159,"name":"header","kind":12},{"name":"sample_size","kind":12,"line":159},{"name":"header","kind":12,"line":161},{"line":161,"name":"bases_offset","kind":12},{"kind":12,"name":"header","line":162},{"kind":12,"name":"bases","line":162},{"name":"header","kind":12,"line":164},{"name":"bases_offset","kind":12,"line":164},{"line":168,"name":"peak_indices","kind":12},{"name":"qualities","kind":12,"line":169},{"line":170,"kind":12,"name":"sequence"},{"kind":12,"name":"accuracies","line":171},{"name":"header","kind":12,"line":176},{"line":176,"kind":12,"name":"sample_offset"},{"kind":12,"name":"header","line":177},{"name":"header","kind":12,"line":178},{"kind":12,"name":"sample_size","line":178},{"name":"header","kind":12,"line":183},{"kind":12,"name":"sample_size","line":183},{"name":"header","kind":12,"line":203},{"line":203,"kind":12,"name":"sample_size"},{"line":213,"kind":13,"containerName":null,"name":"$offset"},{"name":"%creator","kind":13,"containerName":null,"line":213},{"name":"header","kind":12,"line":213},{"line":213,"name":"bases_offset","kind":12},{"line":214,"name":"$length","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%creator","line":214},{"line":214,"kind":12,"name":"header"},{"line":214,"kind":12,"name":"bases"},{"kind":13,"containerName":null,"name":"$buffer","line":215},{"line":215,"name":"$self","containerName":null,"kind":13},{"line":215,"name":"read_from_buffer","containerName":"main::","kind":12},{"name":"$fh","containerName":null,"kind":13,"line":215},{"name":"$buffer","kind":13,"containerName":null,"line":215},{"name":"$length","kind":13,"containerName":null,"line":215},{"kind":13,"containerName":null,"name":"$offset","line":215},{"name":"%creator","kind":13,"containerName":null,"line":216},{"name":"peak_indices","kind":12,"line":216},{"line":216,"containerName":null,"kind":13,"name":"$self"},{"name":"_get_v3_peak_indices","kind":12,"containerName":"main::","line":216},{"line":216,"kind":13,"containerName":null,"name":"$buffer"},{"containerName":null,"kind":13,"name":"$offset","line":217},{"name":"$length","containerName":null,"kind":13,"line":217},{"line":219,"kind":13,"containerName":null,"name":"$buffer"},{"line":219,"name":"$self","kind":13,"containerName":null},{"name":"read_from_buffer","containerName":"main::","kind":12,"line":219},{"containerName":null,"kind":13,"name":"$fh","line":219},{"line":219,"name":"$buffer","kind":13,"containerName":null},{"line":219,"name":"$length","kind":13,"containerName":null},{"name":"$offset","containerName":null,"kind":13,"line":219},{"kind":13,"containerName":null,"name":"%creator","line":220},{"kind":12,"name":"accuracies","line":220},{"name":"$self","containerName":null,"kind":13,"line":220},{"line":220,"containerName":"main::","kind":12,"name":"_get_v3_base_accuracies"},{"containerName":null,"kind":13,"name":"$buffer","line":220},{"name":"$offset","containerName":null,"kind":13,"line":222},{"kind":13,"containerName":null,"name":"$length","line":222},{"containerName":null,"kind":13,"name":"$length","line":223},{"line":223,"name":"%creator","containerName":null,"kind":13},{"kind":12,"name":"header","line":223},{"kind":12,"name":"bases","line":223},{"name":"$buffer","kind":13,"containerName":null,"line":224},{"line":224,"name":"$self","kind":13,"containerName":null},{"line":224,"name":"read_from_buffer","containerName":"main::","kind":12},{"line":224,"name":"$fh","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$buffer","line":224},{"line":224,"name":"$length","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$offset","line":224},{"containerName":null,"kind":13,"name":"%creator","line":225},{"name":"$buffer","containerName":null,"kind":13,"line":225},{"line":227,"containerName":null,"kind":13,"name":"%creator"},{"line":227,"kind":12,"name":"qualities"},{"line":227,"containerName":null,"kind":13,"name":"$self"},{"line":227,"name":"_get_v3_quality","kind":12,"containerName":"main::"},{"line":228,"kind":13,"containerName":null,"name":"%creator"},{"containerName":null,"kind":13,"name":"%creator","line":228},{"name":"accuracies","kind":12,"line":228},{"line":231,"kind":13,"containerName":null,"name":"$offset"},{"name":"%creator","containerName":null,"kind":13,"line":231},{"kind":12,"name":"header","line":231},{"line":231,"kind":12,"name":"comments_offset"},{"kind":13,"containerName":null,"name":"$fh","line":232},{"name":"$offset","kind":13,"containerName":null,"line":232},{"line":233,"kind":13,"containerName":null,"name":"$length"},{"line":233,"name":"%creator","kind":13,"containerName":null},{"kind":12,"name":"header","line":233},{"line":233,"kind":12,"name":"comment_size"},{"line":234,"name":"$buffer","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$self","line":234},{"line":234,"containerName":"main::","kind":12,"name":"read_from_buffer"},{"kind":13,"containerName":null,"name":"$fh","line":234},{"line":234,"containerName":null,"kind":13,"name":"$buffer"},{"line":234,"containerName":null,"kind":13,"name":"$length"},{"line":235,"kind":13,"containerName":null,"name":"%creator"},{"line":235,"kind":12,"name":"comments"},{"name":"$self","kind":13,"containerName":null,"line":235},{"line":235,"name":"_get_comments","kind":12,"containerName":"main::"},{"containerName":null,"kind":13,"name":"$buffer","line":235},{"line":236,"localvar":"my","kind":13,"containerName":null,"name":"@name_comments","definition":"my"},{"kind":12,"containerName":"main::","name":"tagname","line":236},{"line":237,"name":"%creator","kind":13,"containerName":null},{"kind":12,"name":"comments","line":237},{"containerName":"main::","kind":12,"name":"get_Annotations","line":237},{"line":238,"name":"$name_comment","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"line":239,"name":"@name_comments","containerName":null,"kind":13},{"line":240,"containerName":null,"kind":13,"name":"$name_comment"},{"name":"@name_comments","containerName":null,"kind":13,"line":240},{"name":"as_text","kind":12,"containerName":"main::","line":240},{"line":241,"kind":13,"containerName":null,"name":"$name_comment"},{"definition":"my","name":"$swq","kind":13,"localvar":"my","containerName":null,"line":244},{"line":244,"containerName":"Seq::Quality","kind":12,"name":"Bio"},{"line":244,"kind":12,"containerName":"main::","name":"new"},{"kind":13,"containerName":null,"name":"%creator","line":245},{"containerName":null,"kind":13,"name":"%creator","line":246},{"containerName":null,"kind":13,"name":"$name_comment","line":248},{"definition":"my","name":"$returner","kind":13,"localvar":"my","containerName":null,"line":249},{"line":249,"name":"Bio","containerName":"Seq::SequenceTrace","kind":12},{"line":249,"containerName":"main::","kind":12,"name":"new"},{"line":250,"kind":13,"containerName":null,"name":"$swq"},{"line":251,"name":"%creator","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"%creator","line":252},{"name":"%creator","kind":13,"containerName":null,"line":253},{"line":254,"name":"%creator","containerName":null,"kind":13},{"line":255,"containerName":null,"kind":13,"name":"%creator"},{"line":256,"name":"%creator","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"%creator","line":257},{"kind":13,"containerName":null,"name":"%creator","line":258},{"line":259,"containerName":null,"kind":13,"name":"%creator"},{"name":"$returner","containerName":null,"kind":13,"line":262},{"line":262,"name":"annotation","kind":12,"containerName":"main::"},{"kind":13,"containerName":null,"name":"%creator","line":262},{"line":263,"name":"%self","containerName":null,"kind":13},{"line":264,"name":"$returner","containerName":null,"kind":13},{"signature":{"label":"_get_v3_quality($self,$sequence,$accuracies)","parameters":[{"label":"$self"},{"label":"$sequence"},{"label":"$accuracies"}],"documentation":"__END__\n# $Id: scf.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::scf - .scf file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly. Use it via the Bio::SeqIO class, see\nL<Bio::SeqIO> for more information.\n\n=head1 DESCRIPTION\n\nThis object can transform .scf files to and from Bio::Seq::SequenceTrace\nobjects.  Mechanisms are present to retrieve trace data from scf\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chad Matsalla\n\nChad Matsalla\nbioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\nTony Cox, avc@sanger.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nNancy Hansen, nhansen at mail.nih.gov\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::scf;\nuse vars qw($DEFAULT_QUALITY);\nuse strict;\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SequenceTrace;\nuse Bio::Annotation::Comment;\nuse Dumpvalue;\n\nmy $dumper = new Dumpvalue();\n$dumper->veryCompact(1);\n\nBEGIN {\n    $DEFAULT_QUALITY= 10;\n}\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n                  (-verbose => $self->verbose(),\n                   -type => 'Bio::Seq::Quality'));\n  }\n  binmode $self->_fh; # for the Win32/Mac crowds  \n}\n\n=head2 next_seq()\n\n Title   : next_seq()\n Usage   : $scf = $stream->next_seq()\n Function: returns the next scf sequence in the stream\n Returns : a Bio::Seq::SequenceTrace object\n Args    : NONE\n Notes   : Fills the interface specification for SeqIO.\n            The SCF specification does not provide for having more then\n           one sequence in a given scf. So once the filehandle has been open\n           and passed to SeqIO do not expect to run this function more then\n           once on a given scf unless you embraced and extended the SCF\n       standard.  SCF comments are accessible through the Bio::SeqI\n           interface method annotation().\n\n\n#'\nsub next_seq {\n    my ($self) = @_;\n    my ($seq, $seqc, $fh, $buffer, $offset, $length, $read_bytes, @read,\n         %names);\n    # set up a filehandle to read in the scf\n    return if $self->{_readfile};\n    $fh = $self->_fh();\n    unless ($fh) {      # simulate the <> function\n        if ( !fileno(ARGV) or eof(ARGV) ) {\n            return unless my $ARGV = shift;\n            open(ARGV,$ARGV) or\n              $self->throw(\"Could not open $ARGV for SCF stream reading $!\");\n        }\n        $fh = \\*ARGV;\n    }\n    return unless read $fh, $buffer, 128; # no exception; probably end of file\n    # now, the master data structure will be the creator\n    my $creator;\n    # he first thing to do is parse the header. This is common\n    # among all versions of scf.\n    # the rest of the the information is different between the\n    # the different versions of scf.\n\n    $creator->{header} = $self->_get_header($buffer);\n    if ($creator->{header}->{'version'} lt \"3.00\") {\n        $self->debug(\"scf.pm is working with a version 2 scf.\\n\");\n        # first gather the trace information\n        $length = $creator->{header}->{'samples'} *\n          $creator->{header}->{sample_size}*4;\n        $buffer = $self->read_from_buffer($fh, $buffer, $length,\n                                                     $creator->{header}->{samples_offset});\n        # @read = unpack \"n$length\",$buffer;\n        # these traces need to be split\n        # returns a reference to a hash\n        $creator->{traces} = $self->_parse_v2_traces(\n                                                     $buffer,$creator->{header}->{sample_size});\n        # now go and get the base information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 12);\n        seek $fh,$offset,0;\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$creator->{header}->{bases_offset});\n        # now distill the information into its fractions.\n        # the old way : $self->_set_v2_bases($buffer);\n        # ref to an array, ref to a hash, string\n        ($creator->{peak_indices},\n         $creator->{qualities},\n         $creator->{sequence},\n         $creator->{accuracies}) = $self->_parse_v2_bases($buffer);\n\n    } else {\n        $self->debug(\"scf.pm is working with a version 3+ scf.\\n\");\n        my $transformed_read;\n        my $current_read_position = $creator->{header}->{sample_offset};\n        $length = $creator->{header}->{'samples'}*\n          $creator->{header}->{sample_size};\n        # $dumper->dumpValue($creator->{header});\n        foreach (qw(a c g t)) {\n            $buffer = $self->read_from_buffer($fh,$buffer,$length,$current_read_position);\n            my $byte = \"n\";\n            if ($creator->{header}->{sample_size} == 1) {\n                $byte = \"c\";\n            }\n            @read = unpack \"${byte}${length}\",$buffer;\n            # this little spurt of nonsense is because\n            # the trace values are given in the binary\n            # file as unsigned shorts but they really\n            # are signed deltas. 30000 is an arbitrary number\n            # (will there be any traces with a given\n            # point greater then 30000? I hope not.\n            # once the read is read, it must be changed\n            # from relative\n            foreach (@read) {\n                if ($_ > 30000) {\n                    $_ -= 65536;\n                }\n            }\n            $transformed_read = $self->_delta(\\@read,\"backward\");\n            # For 8-bit data we need to emulate a signed/unsigned\n            # cast that is implicit in the C implementations.....\n            if ($creator->{header}->{sample_size} == 1) {\n                foreach (@{$transformed_read}) {\n                    $_ += 256 if ($_ < 0);\n                }\n            }\n            $current_read_position += $length;\n            $creator->{'traces'}->{$_} = join(' ',@{$transformed_read});\n        }\n        \n        # now go and get the peak index information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 4);\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{peak_indices} = $self->_get_v3_peak_indices($buffer);\n        $offset += $length;\n        # now go and get the accuracy information\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{accuracies} = $self->_get_v3_base_accuracies($buffer);\n        # OK, now go and get the base information.\n        $offset += $length;\n        $length = $creator->{header}->{bases};\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{'sequence'} = unpack(\"a$length\",$buffer);\n        # now, finally, extract the calls from the accuracy information.\n        $creator->{qualities} = $self->_get_v3_quality(\n                                              $creator->{'sequence'},$creator->{accuracies});\n    }\n    # now go and get the comment information\n    $offset = $creator->{header}->{comments_offset};\n    seek $fh,$offset,0;\n    $length = $creator->{header}->{comment_size};\n    $buffer = $self->read_from_buffer($fh,$buffer,$length);\n    $creator->{comments} = $self->_get_comments($buffer);\n    my @name_comments = grep {$_->tagname() eq 'NAME'}\n                $creator->{comments}->get_Annotations('comment');\n    my $name_comment;\n    if (@name_comments){\n         $name_comment = $name_comments[0]->as_text();\n         $name_comment =~ s/^Comment:\\s+//;\n    }\n\n    my $swq = Bio::Seq::Quality->new(\n        -seq  =>   $creator->{'sequence'},\n        -qual =>    $creator->{'qualities'},\n        -id   =>    $name_comment\n                                              );\n    my $returner = Bio::Seq::SequenceTrace->new(\n                                           -swq      =>   $swq,\n                                            -trace_a  =>   $creator->{'traces'}->{'a'},\n                                            -trace_t  =>   $creator->{'traces'}->{'t'},\n                                           -trace_g  =>   $creator->{'traces'}->{'g'},\n                                           -trace_c  =>   $creator->{'traces'}->{'c'},\n                                       -accuracy_a    => $creator->{'accuracies'}->{'a'},\n                                   -accuracy_t    => $creator->{'accuracies'}->{'t'},\n                                      -accuracy_g    => $creator->{'accuracies'}->{'g'},\n                                    -accuracy_c    => $creator->{'accuracies'}->{'c'},\n                                 -peak_indices  => $creator->{'peak_indices'}\n                                                             );\n\n        $returner->annotation($creator->{'comments'}); # add SCF comments\n    $self->{'_readfile'} = 1;\n    return $returner;\n}\n\n\n=head2 _get_v3_quality()\n\n Title   : _get_v3_quality()\n Usage   : $self->_get_v3_quality()\n Function: Set the base qualities from version3 scf\n Returns : Nothing. Alters $self.\n Args    : None.\n Notes   :\n\n'"},"line":280,"range":{"end":{"character":9999,"line":294},"start":{"character":0,"line":280}},"kind":12,"definition":"sub","detail":"($self,$sequence,$accuracies)","children":[{"localvar":"my","kind":13,"containerName":"_get_v3_quality","name":"$self","line":281,"definition":"my"},{"line":281,"name":"$sequence","containerName":"_get_v3_quality","kind":13},{"line":281,"containerName":"_get_v3_quality","kind":13,"name":"$accuracies"},{"definition":"my","line":282,"localvar":"my","kind":13,"containerName":"_get_v3_quality","name":"@bases"},{"line":282,"kind":13,"containerName":"_get_v3_quality","name":"$sequence"},{"name":"@qualities","kind":13,"localvar":"my","containerName":"_get_v3_quality","line":283,"definition":"my"},{"kind":13,"containerName":"_get_v3_quality","name":"$currbase","line":283},{"name":"$currqual","kind":13,"containerName":"_get_v3_quality","line":283},{"containerName":"_get_v3_quality","kind":13,"name":"$counter","line":283},{"line":284,"containerName":"_get_v3_quality","kind":13,"name":"$counter"},{"line":284,"kind":13,"containerName":"_get_v3_quality","name":"$counter"},{"containerName":"_get_v3_quality","kind":13,"name":"$counter","line":284},{"containerName":"_get_v3_quality","kind":13,"name":"$currbase","line":285},{"line":285,"name":"$bases","kind":13,"containerName":"_get_v3_quality"},{"line":285,"name":"$counter","kind":13,"containerName":"_get_v3_quality"},{"line":286,"name":"$currbase","kind":13,"containerName":"_get_v3_quality"},{"name":"$currqual","containerName":"_get_v3_quality","kind":13,"line":286},{"line":286,"kind":13,"containerName":"_get_v3_quality","name":"$accuracies"},{"line":286,"name":"$counter","containerName":"_get_v3_quality","kind":13},{"line":287,"kind":13,"containerName":"_get_v3_quality","name":"$currbase"},{"line":287,"kind":13,"containerName":"_get_v3_quality","name":"$currqual"},{"name":"$accuracies","containerName":"_get_v3_quality","kind":13,"line":287},{"line":287,"kind":13,"containerName":"_get_v3_quality","name":"$counter"},{"line":288,"kind":13,"containerName":"_get_v3_quality","name":"$currbase"},{"name":"$currqual","containerName":"_get_v3_quality","kind":13,"line":288},{"name":"$accuracies","containerName":"_get_v3_quality","kind":13,"line":288},{"line":288,"kind":13,"containerName":"_get_v3_quality","name":"$counter"},{"line":289,"name":"$currbase","containerName":"_get_v3_quality","kind":13},{"name":"$currqual","containerName":"_get_v3_quality","kind":13,"line":289},{"line":289,"name":"$accuracies","containerName":"_get_v3_quality","kind":13},{"line":289,"name":"$counter","containerName":"_get_v3_quality","kind":13},{"line":290,"containerName":"_get_v3_quality","kind":13,"name":"$currqual"},{"line":291,"containerName":"_get_v3_quality","kind":13,"name":"@qualities"},{"line":291,"name":"$currqual","kind":13,"containerName":"_get_v3_quality"},{"line":293,"name":"@qualities","kind":13,"containerName":"_get_v3_quality"}],"name":"_get_v3_quality","containerName":"main::"},{"kind":12,"name":"bases","line":284},{"signature":{"label":"_get_v3_peak_indices($self,$buffer)","parameters":[{"label":"$self"},{"label":"$buffer"}],"documentation":"__END__\n# $Id: scf.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::scf - .scf file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly. Use it via the Bio::SeqIO class, see\nL<Bio::SeqIO> for more information.\n\n=head1 DESCRIPTION\n\nThis object can transform .scf files to and from Bio::Seq::SequenceTrace\nobjects.  Mechanisms are present to retrieve trace data from scf\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chad Matsalla\n\nChad Matsalla\nbioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\nTony Cox, avc@sanger.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nNancy Hansen, nhansen at mail.nih.gov\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::scf;\nuse vars qw($DEFAULT_QUALITY);\nuse strict;\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SequenceTrace;\nuse Bio::Annotation::Comment;\nuse Dumpvalue;\n\nmy $dumper = new Dumpvalue();\n$dumper->veryCompact(1);\n\nBEGIN {\n    $DEFAULT_QUALITY= 10;\n}\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n                  (-verbose => $self->verbose(),\n                   -type => 'Bio::Seq::Quality'));\n  }\n  binmode $self->_fh; # for the Win32/Mac crowds  \n}\n\n=head2 next_seq()\n\n Title   : next_seq()\n Usage   : $scf = $stream->next_seq()\n Function: returns the next scf sequence in the stream\n Returns : a Bio::Seq::SequenceTrace object\n Args    : NONE\n Notes   : Fills the interface specification for SeqIO.\n            The SCF specification does not provide for having more then\n           one sequence in a given scf. So once the filehandle has been open\n           and passed to SeqIO do not expect to run this function more then\n           once on a given scf unless you embraced and extended the SCF\n       standard.  SCF comments are accessible through the Bio::SeqI\n           interface method annotation().\n\n\n#'\nsub next_seq {\n    my ($self) = @_;\n    my ($seq, $seqc, $fh, $buffer, $offset, $length, $read_bytes, @read,\n         %names);\n    # set up a filehandle to read in the scf\n    return if $self->{_readfile};\n    $fh = $self->_fh();\n    unless ($fh) {      # simulate the <> function\n        if ( !fileno(ARGV) or eof(ARGV) ) {\n            return unless my $ARGV = shift;\n            open(ARGV,$ARGV) or\n              $self->throw(\"Could not open $ARGV for SCF stream reading $!\");\n        }\n        $fh = \\*ARGV;\n    }\n    return unless read $fh, $buffer, 128; # no exception; probably end of file\n    # now, the master data structure will be the creator\n    my $creator;\n    # he first thing to do is parse the header. This is common\n    # among all versions of scf.\n    # the rest of the the information is different between the\n    # the different versions of scf.\n\n    $creator->{header} = $self->_get_header($buffer);\n    if ($creator->{header}->{'version'} lt \"3.00\") {\n        $self->debug(\"scf.pm is working with a version 2 scf.\\n\");\n        # first gather the trace information\n        $length = $creator->{header}->{'samples'} *\n          $creator->{header}->{sample_size}*4;\n        $buffer = $self->read_from_buffer($fh, $buffer, $length,\n                                                     $creator->{header}->{samples_offset});\n        # @read = unpack \"n$length\",$buffer;\n        # these traces need to be split\n        # returns a reference to a hash\n        $creator->{traces} = $self->_parse_v2_traces(\n                                                     $buffer,$creator->{header}->{sample_size});\n        # now go and get the base information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 12);\n        seek $fh,$offset,0;\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$creator->{header}->{bases_offset});\n        # now distill the information into its fractions.\n        # the old way : $self->_set_v2_bases($buffer);\n        # ref to an array, ref to a hash, string\n        ($creator->{peak_indices},\n         $creator->{qualities},\n         $creator->{sequence},\n         $creator->{accuracies}) = $self->_parse_v2_bases($buffer);\n\n    } else {\n        $self->debug(\"scf.pm is working with a version 3+ scf.\\n\");\n        my $transformed_read;\n        my $current_read_position = $creator->{header}->{sample_offset};\n        $length = $creator->{header}->{'samples'}*\n          $creator->{header}->{sample_size};\n        # $dumper->dumpValue($creator->{header});\n        foreach (qw(a c g t)) {\n            $buffer = $self->read_from_buffer($fh,$buffer,$length,$current_read_position);\n            my $byte = \"n\";\n            if ($creator->{header}->{sample_size} == 1) {\n                $byte = \"c\";\n            }\n            @read = unpack \"${byte}${length}\",$buffer;\n            # this little spurt of nonsense is because\n            # the trace values are given in the binary\n            # file as unsigned shorts but they really\n            # are signed deltas. 30000 is an arbitrary number\n            # (will there be any traces with a given\n            # point greater then 30000? I hope not.\n            # once the read is read, it must be changed\n            # from relative\n            foreach (@read) {\n                if ($_ > 30000) {\n                    $_ -= 65536;\n                }\n            }\n            $transformed_read = $self->_delta(\\@read,\"backward\");\n            # For 8-bit data we need to emulate a signed/unsigned\n            # cast that is implicit in the C implementations.....\n            if ($creator->{header}->{sample_size} == 1) {\n                foreach (@{$transformed_read}) {\n                    $_ += 256 if ($_ < 0);\n                }\n            }\n            $current_read_position += $length;\n            $creator->{'traces'}->{$_} = join(' ',@{$transformed_read});\n        }\n        \n        # now go and get the peak index information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 4);\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{peak_indices} = $self->_get_v3_peak_indices($buffer);\n        $offset += $length;\n        # now go and get the accuracy information\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{accuracies} = $self->_get_v3_base_accuracies($buffer);\n        # OK, now go and get the base information.\n        $offset += $length;\n        $length = $creator->{header}->{bases};\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{'sequence'} = unpack(\"a$length\",$buffer);\n        # now, finally, extract the calls from the accuracy information.\n        $creator->{qualities} = $self->_get_v3_quality(\n                                              $creator->{'sequence'},$creator->{accuracies});\n    }\n    # now go and get the comment information\n    $offset = $creator->{header}->{comments_offset};\n    seek $fh,$offset,0;\n    $length = $creator->{header}->{comment_size};\n    $buffer = $self->read_from_buffer($fh,$buffer,$length);\n    $creator->{comments} = $self->_get_comments($buffer);\n    my @name_comments = grep {$_->tagname() eq 'NAME'}\n                $creator->{comments}->get_Annotations('comment');\n    my $name_comment;\n    if (@name_comments){\n         $name_comment = $name_comments[0]->as_text();\n         $name_comment =~ s/^Comment:\\s+//;\n    }\n\n    my $swq = Bio::Seq::Quality->new(\n        -seq  =>   $creator->{'sequence'},\n        -qual =>    $creator->{'qualities'},\n        -id   =>    $name_comment\n                                              );\n    my $returner = Bio::Seq::SequenceTrace->new(\n                                           -swq      =>   $swq,\n                                            -trace_a  =>   $creator->{'traces'}->{'a'},\n                                            -trace_t  =>   $creator->{'traces'}->{'t'},\n                                           -trace_g  =>   $creator->{'traces'}->{'g'},\n                                           -trace_c  =>   $creator->{'traces'}->{'c'},\n                                       -accuracy_a    => $creator->{'accuracies'}->{'a'},\n                                   -accuracy_t    => $creator->{'accuracies'}->{'t'},\n                                      -accuracy_g    => $creator->{'accuracies'}->{'g'},\n                                    -accuracy_c    => $creator->{'accuracies'}->{'c'},\n                                 -peak_indices  => $creator->{'peak_indices'}\n                                                             );\n\n        $returner->annotation($creator->{'comments'}); # add SCF comments\n    $self->{'_readfile'} = 1;\n    return $returner;\n}\n\n\n=head2 _get_v3_quality()\n\n Title   : _get_v3_quality()\n Usage   : $self->_get_v3_quality()\n Function: Set the base qualities from version3 scf\n Returns : Nothing. Alters $self.\n Args    : None.\n Notes   :\n\n\n#'\nsub _get_v3_quality {\n    my ($self,$sequence,$accuracies) = @_;\n    my @bases = split//,$sequence;\n    my (@qualities,$currbase,$currqual,$counter);\n    for ($counter=0; $counter <= $#bases ; $counter++) {\n    $currbase = lc($bases[$counter]);\n    if ($currbase eq \"a\") { $currqual = $accuracies->{'a'}->[$counter]; }\n    elsif ($currbase eq \"c\") { $currqual = $accuracies->{'c'}->[$counter]; }\n    elsif ($currbase eq \"g\") { $currqual = $accuracies->{'g'}->[$counter]; }\n    elsif ($currbase eq \"t\") { $currqual = $accuracies->{'t'}->[$counter]; }\n    else { $currqual = \"unknown\"; }\n    push @qualities,$currqual;\n    }\n    return \\@qualities;\n}\n\n=head2 _get_v3_peak_indices($buffer)\n\n Title   : _get_v3_peak_indices($buffer)\n Usage   : $self->_get_v3_peak_indices($buffer);\n Function: Unpacks the base accuracies for version3 scf\n Returns : Nothing. Alters $self\n Args    : A scalar containing binary data.\n Notes   :"},"line":307,"kind":12,"range":{"start":{"line":307,"character":0},"end":{"line":312,"character":9999}},"definition":"sub","detail":"($self,$buffer)","children":[{"line":308,"name":"$self","containerName":"_get_v3_peak_indices","localvar":"my","kind":13,"definition":"my"},{"containerName":"_get_v3_peak_indices","kind":13,"name":"$buffer","line":308},{"line":309,"name":"$length","kind":13,"localvar":"my","containerName":"_get_v3_peak_indices","definition":"my"},{"line":309,"name":"$buffer","containerName":"_get_v3_peak_indices","kind":13},{"definition":"my","name":"@read","localvar":"my","kind":13,"containerName":"_get_v3_peak_indices","line":310},{"name":"$buffer","containerName":"_get_v3_peak_indices","kind":13,"line":310},{"kind":13,"containerName":"_get_v3_peak_indices","name":"@read","line":311}],"name":"_get_v3_peak_indices","containerName":"main::"},{"signature":{"documentation":"__END__\n# $Id: scf.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::scf - .scf file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly. Use it via the Bio::SeqIO class, see\nL<Bio::SeqIO> for more information.\n\n=head1 DESCRIPTION\n\nThis object can transform .scf files to and from Bio::Seq::SequenceTrace\nobjects.  Mechanisms are present to retrieve trace data from scf\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chad Matsalla\n\nChad Matsalla\nbioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\nTony Cox, avc@sanger.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nNancy Hansen, nhansen at mail.nih.gov\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::scf;\nuse vars qw($DEFAULT_QUALITY);\nuse strict;\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SequenceTrace;\nuse Bio::Annotation::Comment;\nuse Dumpvalue;\n\nmy $dumper = new Dumpvalue();\n$dumper->veryCompact(1);\n\nBEGIN {\n    $DEFAULT_QUALITY= 10;\n}\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n                  (-verbose => $self->verbose(),\n                   -type => 'Bio::Seq::Quality'));\n  }\n  binmode $self->_fh; # for the Win32/Mac crowds  \n}\n\n=head2 next_seq()\n\n Title   : next_seq()\n Usage   : $scf = $stream->next_seq()\n Function: returns the next scf sequence in the stream\n Returns : a Bio::Seq::SequenceTrace object\n Args    : NONE\n Notes   : Fills the interface specification for SeqIO.\n            The SCF specification does not provide for having more then\n           one sequence in a given scf. So once the filehandle has been open\n           and passed to SeqIO do not expect to run this function more then\n           once on a given scf unless you embraced and extended the SCF\n       standard.  SCF comments are accessible through the Bio::SeqI\n           interface method annotation().\n\n\n#'\nsub next_seq {\n    my ($self) = @_;\n    my ($seq, $seqc, $fh, $buffer, $offset, $length, $read_bytes, @read,\n         %names);\n    # set up a filehandle to read in the scf\n    return if $self->{_readfile};\n    $fh = $self->_fh();\n    unless ($fh) {      # simulate the <> function\n        if ( !fileno(ARGV) or eof(ARGV) ) {\n            return unless my $ARGV = shift;\n            open(ARGV,$ARGV) or\n              $self->throw(\"Could not open $ARGV for SCF stream reading $!\");\n        }\n        $fh = \\*ARGV;\n    }\n    return unless read $fh, $buffer, 128; # no exception; probably end of file\n    # now, the master data structure will be the creator\n    my $creator;\n    # he first thing to do is parse the header. This is common\n    # among all versions of scf.\n    # the rest of the the information is different between the\n    # the different versions of scf.\n\n    $creator->{header} = $self->_get_header($buffer);\n    if ($creator->{header}->{'version'} lt \"3.00\") {\n        $self->debug(\"scf.pm is working with a version 2 scf.\\n\");\n        # first gather the trace information\n        $length = $creator->{header}->{'samples'} *\n          $creator->{header}->{sample_size}*4;\n        $buffer = $self->read_from_buffer($fh, $buffer, $length,\n                                                     $creator->{header}->{samples_offset});\n        # @read = unpack \"n$length\",$buffer;\n        # these traces need to be split\n        # returns a reference to a hash\n        $creator->{traces} = $self->_parse_v2_traces(\n                                                     $buffer,$creator->{header}->{sample_size});\n        # now go and get the base information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 12);\n        seek $fh,$offset,0;\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$creator->{header}->{bases_offset});\n        # now distill the information into its fractions.\n        # the old way : $self->_set_v2_bases($buffer);\n        # ref to an array, ref to a hash, string\n        ($creator->{peak_indices},\n         $creator->{qualities},\n         $creator->{sequence},\n         $creator->{accuracies}) = $self->_parse_v2_bases($buffer);\n\n    } else {\n        $self->debug(\"scf.pm is working with a version 3+ scf.\\n\");\n        my $transformed_read;\n        my $current_read_position = $creator->{header}->{sample_offset};\n        $length = $creator->{header}->{'samples'}*\n          $creator->{header}->{sample_size};\n        # $dumper->dumpValue($creator->{header});\n        foreach (qw(a c g t)) {\n            $buffer = $self->read_from_buffer($fh,$buffer,$length,$current_read_position);\n            my $byte = \"n\";\n            if ($creator->{header}->{sample_size} == 1) {\n                $byte = \"c\";\n            }\n            @read = unpack \"${byte}${length}\",$buffer;\n            # this little spurt of nonsense is because\n            # the trace values are given in the binary\n            # file as unsigned shorts but they really\n            # are signed deltas. 30000 is an arbitrary number\n            # (will there be any traces with a given\n            # point greater then 30000? I hope not.\n            # once the read is read, it must be changed\n            # from relative\n            foreach (@read) {\n                if ($_ > 30000) {\n                    $_ -= 65536;\n                }\n            }\n            $transformed_read = $self->_delta(\\@read,\"backward\");\n            # For 8-bit data we need to emulate a signed/unsigned\n            # cast that is implicit in the C implementations.....\n            if ($creator->{header}->{sample_size} == 1) {\n                foreach (@{$transformed_read}) {\n                    $_ += 256 if ($_ < 0);\n                }\n            }\n            $current_read_position += $length;\n            $creator->{'traces'}->{$_} = join(' ',@{$transformed_read});\n        }\n        \n        # now go and get the peak index information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 4);\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{peak_indices} = $self->_get_v3_peak_indices($buffer);\n        $offset += $length;\n        # now go and get the accuracy information\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{accuracies} = $self->_get_v3_base_accuracies($buffer);\n        # OK, now go and get the base information.\n        $offset += $length;\n        $length = $creator->{header}->{bases};\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{'sequence'} = unpack(\"a$length\",$buffer);\n        # now, finally, extract the calls from the accuracy information.\n        $creator->{qualities} = $self->_get_v3_quality(\n                                              $creator->{'sequence'},$creator->{accuracies});\n    }\n    # now go and get the comment information\n    $offset = $creator->{header}->{comments_offset};\n    seek $fh,$offset,0;\n    $length = $creator->{header}->{comment_size};\n    $buffer = $self->read_from_buffer($fh,$buffer,$length);\n    $creator->{comments} = $self->_get_comments($buffer);\n    my @name_comments = grep {$_->tagname() eq 'NAME'}\n                $creator->{comments}->get_Annotations('comment');\n    my $name_comment;\n    if (@name_comments){\n         $name_comment = $name_comments[0]->as_text();\n         $name_comment =~ s/^Comment:\\s+//;\n    }\n\n    my $swq = Bio::Seq::Quality->new(\n        -seq  =>   $creator->{'sequence'},\n        -qual =>    $creator->{'qualities'},\n        -id   =>    $name_comment\n                                              );\n    my $returner = Bio::Seq::SequenceTrace->new(\n                                           -swq      =>   $swq,\n                                            -trace_a  =>   $creator->{'traces'}->{'a'},\n                                            -trace_t  =>   $creator->{'traces'}->{'t'},\n                                           -trace_g  =>   $creator->{'traces'}->{'g'},\n                                           -trace_c  =>   $creator->{'traces'}->{'c'},\n                                       -accuracy_a    => $creator->{'accuracies'}->{'a'},\n                                   -accuracy_t    => $creator->{'accuracies'}->{'t'},\n                                      -accuracy_g    => $creator->{'accuracies'}->{'g'},\n                                    -accuracy_c    => $creator->{'accuracies'}->{'c'},\n                                 -peak_indices  => $creator->{'peak_indices'}\n                                                             );\n\n        $returner->annotation($creator->{'comments'}); # add SCF comments\n    $self->{'_readfile'} = 1;\n    return $returner;\n}\n\n\n=head2 _get_v3_quality()\n\n Title   : _get_v3_quality()\n Usage   : $self->_get_v3_quality()\n Function: Set the base qualities from version3 scf\n Returns : Nothing. Alters $self.\n Args    : None.\n Notes   :\n\n\n#'\nsub _get_v3_quality {\n    my ($self,$sequence,$accuracies) = @_;\n    my @bases = split//,$sequence;\n    my (@qualities,$currbase,$currqual,$counter);\n    for ($counter=0; $counter <= $#bases ; $counter++) {\n    $currbase = lc($bases[$counter]);\n    if ($currbase eq \"a\") { $currqual = $accuracies->{'a'}->[$counter]; }\n    elsif ($currbase eq \"c\") { $currqual = $accuracies->{'c'}->[$counter]; }\n    elsif ($currbase eq \"g\") { $currqual = $accuracies->{'g'}->[$counter]; }\n    elsif ($currbase eq \"t\") { $currqual = $accuracies->{'t'}->[$counter]; }\n    else { $currqual = \"unknown\"; }\n    push @qualities,$currqual;\n    }\n    return \\@qualities;\n}\n\n=head2 _get_v3_peak_indices($buffer)\n\n Title   : _get_v3_peak_indices($buffer)\n Usage   : $self->_get_v3_peak_indices($buffer);\n Function: Unpacks the base accuracies for version3 scf\n Returns : Nothing. Alters $self\n Args    : A scalar containing binary data.\n Notes   :\n\n\nsub _get_v3_peak_indices {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my @read = unpack \"N$length\",$buffer;\n     return join(' ',@read);\n}\n\n=head2 _get_v3_base_accuracies($buffer)\n\n Title   : _get_v3_base_accuracies($buffer)\n Usage   : $self->_get_v3_base_accuracies($buffer)\n Function: Set the base accuracies for version 3 scf's\n Returns : Nothing. Alters $self.\n Args    : A scalar containing binary data.\n Notes   :\n\n'","parameters":[{"label":"$self"},{"label":"$buffer"}],"label":"_get_v3_base_accuracies($self,$buffer)"},"kind":12,"range":{"end":{"line":343,"character":9999},"start":{"line":326,"character":0}},"line":326,"detail":"($self,$buffer)","definition":"sub","containerName":"main::","name":"_get_v3_base_accuracies","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"_get_v3_base_accuracies","line":327,"definition":"my"},{"kind":13,"containerName":"_get_v3_base_accuracies","name":"$buffer","line":327},{"name":"$length","containerName":"_get_v3_base_accuracies","localvar":"my","kind":13,"line":328,"definition":"my"},{"containerName":"_get_v3_base_accuracies","kind":13,"name":"$buffer","line":328},{"line":329,"name":"$qlength","localvar":"my","kind":13,"containerName":"_get_v3_base_accuracies","definition":"my"},{"kind":13,"containerName":"_get_v3_base_accuracies","name":"$length","line":329},{"containerName":"_get_v3_base_accuracies","localvar":"my","kind":13,"name":"$offset","line":330,"definition":"my"},{"name":"@qualities","kind":13,"localvar":"my","containerName":"_get_v3_base_accuracies","line":331,"definition":"my"},{"kind":13,"containerName":"_get_v3_base_accuracies","name":"@sorter","line":331},{"kind":13,"containerName":"_get_v3_base_accuracies","name":"$counter","line":331},{"line":331,"containerName":"_get_v3_base_accuracies","kind":13,"name":"$round"},{"line":331,"kind":13,"containerName":"_get_v3_base_accuracies","name":"$last_base"},{"kind":13,"containerName":"_get_v3_base_accuracies","name":"$accuracies","line":331},{"line":331,"kind":13,"containerName":"_get_v3_base_accuracies","name":"$currbase"},{"line":332,"name":"$currbase","kind":13,"containerName":"_get_v3_base_accuracies"},{"name":"@read","kind":13,"localvar":"my","containerName":"_get_v3_base_accuracies","line":333,"definition":"my"},{"kind":13,"containerName":"_get_v3_base_accuracies","name":"$last_base","line":334},{"line":334,"containerName":"_get_v3_base_accuracies","kind":13,"name":"$offset"},{"kind":13,"containerName":"_get_v3_base_accuracies","name":"$qlength","line":334},{"line":335,"containerName":"_get_v3_base_accuracies","kind":13,"name":"$offset"},{"line":335,"kind":13,"containerName":"_get_v3_base_accuracies","name":"$last_base"},{"line":335,"name":"$offset","kind":13,"containerName":"_get_v3_base_accuracies"},{"line":335,"name":"$qlength","containerName":"_get_v3_base_accuracies","kind":13},{"name":"@read","containerName":"_get_v3_base_accuracies","kind":13,"line":338},{"containerName":"_get_v3_base_accuracies","kind":13,"name":"$buffer","line":338},{"kind":13,"containerName":"_get_v3_base_accuracies","name":"$offset","line":338},{"line":338,"name":"$qlength","kind":13,"containerName":"_get_v3_base_accuracies"},{"line":339,"name":"$accuracies","containerName":"_get_v3_base_accuracies","kind":13},{"line":339,"name":"$currbase","kind":13,"containerName":"_get_v3_base_accuracies"},{"line":339,"name":"@read","containerName":"_get_v3_base_accuracies","kind":13},{"name":"$accuracies","containerName":"_get_v3_base_accuracies","kind":13,"line":342}]},{"signature":{"label":"_get_comments($self,$buffer)","parameters":[{"label":"$self"},{"label":"$buffer"}],"documentation":"__END__\n# $Id: scf.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::scf - .scf file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly. Use it via the Bio::SeqIO class, see\nL<Bio::SeqIO> for more information.\n\n=head1 DESCRIPTION\n\nThis object can transform .scf files to and from Bio::Seq::SequenceTrace\nobjects.  Mechanisms are present to retrieve trace data from scf\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chad Matsalla\n\nChad Matsalla\nbioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\nTony Cox, avc@sanger.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nNancy Hansen, nhansen at mail.nih.gov\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::scf;\nuse vars qw($DEFAULT_QUALITY);\nuse strict;\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SequenceTrace;\nuse Bio::Annotation::Comment;\nuse Dumpvalue;\n\nmy $dumper = new Dumpvalue();\n$dumper->veryCompact(1);\n\nBEGIN {\n    $DEFAULT_QUALITY= 10;\n}\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n                  (-verbose => $self->verbose(),\n                   -type => 'Bio::Seq::Quality'));\n  }\n  binmode $self->_fh; # for the Win32/Mac crowds  \n}\n\n=head2 next_seq()\n\n Title   : next_seq()\n Usage   : $scf = $stream->next_seq()\n Function: returns the next scf sequence in the stream\n Returns : a Bio::Seq::SequenceTrace object\n Args    : NONE\n Notes   : Fills the interface specification for SeqIO.\n            The SCF specification does not provide for having more then\n           one sequence in a given scf. So once the filehandle has been open\n           and passed to SeqIO do not expect to run this function more then\n           once on a given scf unless you embraced and extended the SCF\n       standard.  SCF comments are accessible through the Bio::SeqI\n           interface method annotation().\n\n\n#'\nsub next_seq {\n    my ($self) = @_;\n    my ($seq, $seqc, $fh, $buffer, $offset, $length, $read_bytes, @read,\n         %names);\n    # set up a filehandle to read in the scf\n    return if $self->{_readfile};\n    $fh = $self->_fh();\n    unless ($fh) {      # simulate the <> function\n        if ( !fileno(ARGV) or eof(ARGV) ) {\n            return unless my $ARGV = shift;\n            open(ARGV,$ARGV) or\n              $self->throw(\"Could not open $ARGV for SCF stream reading $!\");\n        }\n        $fh = \\*ARGV;\n    }\n    return unless read $fh, $buffer, 128; # no exception; probably end of file\n    # now, the master data structure will be the creator\n    my $creator;\n    # he first thing to do is parse the header. This is common\n    # among all versions of scf.\n    # the rest of the the information is different between the\n    # the different versions of scf.\n\n    $creator->{header} = $self->_get_header($buffer);\n    if ($creator->{header}->{'version'} lt \"3.00\") {\n        $self->debug(\"scf.pm is working with a version 2 scf.\\n\");\n        # first gather the trace information\n        $length = $creator->{header}->{'samples'} *\n          $creator->{header}->{sample_size}*4;\n        $buffer = $self->read_from_buffer($fh, $buffer, $length,\n                                                     $creator->{header}->{samples_offset});\n        # @read = unpack \"n$length\",$buffer;\n        # these traces need to be split\n        # returns a reference to a hash\n        $creator->{traces} = $self->_parse_v2_traces(\n                                                     $buffer,$creator->{header}->{sample_size});\n        # now go and get the base information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 12);\n        seek $fh,$offset,0;\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$creator->{header}->{bases_offset});\n        # now distill the information into its fractions.\n        # the old way : $self->_set_v2_bases($buffer);\n        # ref to an array, ref to a hash, string\n        ($creator->{peak_indices},\n         $creator->{qualities},\n         $creator->{sequence},\n         $creator->{accuracies}) = $self->_parse_v2_bases($buffer);\n\n    } else {\n        $self->debug(\"scf.pm is working with a version 3+ scf.\\n\");\n        my $transformed_read;\n        my $current_read_position = $creator->{header}->{sample_offset};\n        $length = $creator->{header}->{'samples'}*\n          $creator->{header}->{sample_size};\n        # $dumper->dumpValue($creator->{header});\n        foreach (qw(a c g t)) {\n            $buffer = $self->read_from_buffer($fh,$buffer,$length,$current_read_position);\n            my $byte = \"n\";\n            if ($creator->{header}->{sample_size} == 1) {\n                $byte = \"c\";\n            }\n            @read = unpack \"${byte}${length}\",$buffer;\n            # this little spurt of nonsense is because\n            # the trace values are given in the binary\n            # file as unsigned shorts but they really\n            # are signed deltas. 30000 is an arbitrary number\n            # (will there be any traces with a given\n            # point greater then 30000? I hope not.\n            # once the read is read, it must be changed\n            # from relative\n            foreach (@read) {\n                if ($_ > 30000) {\n                    $_ -= 65536;\n                }\n            }\n            $transformed_read = $self->_delta(\\@read,\"backward\");\n            # For 8-bit data we need to emulate a signed/unsigned\n            # cast that is implicit in the C implementations.....\n            if ($creator->{header}->{sample_size} == 1) {\n                foreach (@{$transformed_read}) {\n                    $_ += 256 if ($_ < 0);\n                }\n            }\n            $current_read_position += $length;\n            $creator->{'traces'}->{$_} = join(' ',@{$transformed_read});\n        }\n        \n        # now go and get the peak index information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 4);\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{peak_indices} = $self->_get_v3_peak_indices($buffer);\n        $offset += $length;\n        # now go and get the accuracy information\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{accuracies} = $self->_get_v3_base_accuracies($buffer);\n        # OK, now go and get the base information.\n        $offset += $length;\n        $length = $creator->{header}->{bases};\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{'sequence'} = unpack(\"a$length\",$buffer);\n        # now, finally, extract the calls from the accuracy information.\n        $creator->{qualities} = $self->_get_v3_quality(\n                                              $creator->{'sequence'},$creator->{accuracies});\n    }\n    # now go and get the comment information\n    $offset = $creator->{header}->{comments_offset};\n    seek $fh,$offset,0;\n    $length = $creator->{header}->{comment_size};\n    $buffer = $self->read_from_buffer($fh,$buffer,$length);\n    $creator->{comments} = $self->_get_comments($buffer);\n    my @name_comments = grep {$_->tagname() eq 'NAME'}\n                $creator->{comments}->get_Annotations('comment');\n    my $name_comment;\n    if (@name_comments){\n         $name_comment = $name_comments[0]->as_text();\n         $name_comment =~ s/^Comment:\\s+//;\n    }\n\n    my $swq = Bio::Seq::Quality->new(\n        -seq  =>   $creator->{'sequence'},\n        -qual =>    $creator->{'qualities'},\n        -id   =>    $name_comment\n                                              );\n    my $returner = Bio::Seq::SequenceTrace->new(\n                                           -swq      =>   $swq,\n                                            -trace_a  =>   $creator->{'traces'}->{'a'},\n                                            -trace_t  =>   $creator->{'traces'}->{'t'},\n                                           -trace_g  =>   $creator->{'traces'}->{'g'},\n                                           -trace_c  =>   $creator->{'traces'}->{'c'},\n                                       -accuracy_a    => $creator->{'accuracies'}->{'a'},\n                                   -accuracy_t    => $creator->{'accuracies'}->{'t'},\n                                      -accuracy_g    => $creator->{'accuracies'}->{'g'},\n                                    -accuracy_c    => $creator->{'accuracies'}->{'c'},\n                                 -peak_indices  => $creator->{'peak_indices'}\n                                                             );\n\n        $returner->annotation($creator->{'comments'}); # add SCF comments\n    $self->{'_readfile'} = 1;\n    return $returner;\n}\n\n\n=head2 _get_v3_quality()\n\n Title   : _get_v3_quality()\n Usage   : $self->_get_v3_quality()\n Function: Set the base qualities from version3 scf\n Returns : Nothing. Alters $self.\n Args    : None.\n Notes   :\n\n\n#'\nsub _get_v3_quality {\n    my ($self,$sequence,$accuracies) = @_;\n    my @bases = split//,$sequence;\n    my (@qualities,$currbase,$currqual,$counter);\n    for ($counter=0; $counter <= $#bases ; $counter++) {\n    $currbase = lc($bases[$counter]);\n    if ($currbase eq \"a\") { $currqual = $accuracies->{'a'}->[$counter]; }\n    elsif ($currbase eq \"c\") { $currqual = $accuracies->{'c'}->[$counter]; }\n    elsif ($currbase eq \"g\") { $currqual = $accuracies->{'g'}->[$counter]; }\n    elsif ($currbase eq \"t\") { $currqual = $accuracies->{'t'}->[$counter]; }\n    else { $currqual = \"unknown\"; }\n    push @qualities,$currqual;\n    }\n    return \\@qualities;\n}\n\n=head2 _get_v3_peak_indices($buffer)\n\n Title   : _get_v3_peak_indices($buffer)\n Usage   : $self->_get_v3_peak_indices($buffer);\n Function: Unpacks the base accuracies for version3 scf\n Returns : Nothing. Alters $self\n Args    : A scalar containing binary data.\n Notes   :\n\n\nsub _get_v3_peak_indices {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my @read = unpack \"N$length\",$buffer;\n     return join(' ',@read);\n}\n\n=head2 _get_v3_base_accuracies($buffer)\n\n Title   : _get_v3_base_accuracies($buffer)\n Usage   : $self->_get_v3_base_accuracies($buffer)\n Function: Set the base accuracies for version 3 scf's\n Returns : Nothing. Alters $self.\n Args    : A scalar containing binary data.\n Notes   :\n\n\n#'\nsub _get_v3_base_accuracies {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my $qlength = $length/4;\n    my $offset = 0;\n    my (@qualities,@sorter,$counter,$round,$last_base,$accuracies,$currbase);\n    foreach $currbase (qw(a c g t)) {\n         my @read;\n         $last_base = $offset + $qlength;\n         for (;$offset < $last_base; $offset += $qlength) {\n                    # a bioperler (perhaps me?) changed the unpack string to include 'n' rather than 'C'\n                    # on 040322 I think that 'C' is correct. please email chad if you would like to accuse me of being incorrect\n              @read = unpack \"C$qlength\", substr($buffer,$offset,$qlength);\n              $accuracies->{$currbase} = \\@read;\n         }\n    }\n     return $accuracies;\n}\n\n\n=head2 _get_comments($buffer)\n\n Title   : _get_comments($buffer)\n Usage   : $self->_get_comments($buffer);\n Function: Gather the comments section from the scf and parse it into its\n            components.\n Returns : a Bio::Annotation::Collection object\n Args    : The buffer. It is expected that the buffer contains a binary\n            string for the comments section of an scf file according to\n            the scf file specifications.\n Notes   :"},"kind":12,"range":{"start":{"character":0,"line":360},"end":{"line":382,"character":9999}},"line":360,"detail":"($self,$buffer)","definition":"sub","name":"_get_comments","containerName":"main::","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"_get_comments","name":"$self","line":361},{"line":361,"name":"$buffer","containerName":"_get_comments","kind":13},{"definition":"my","line":362,"name":"$comments","localvar":"my","containerName":"_get_comments","kind":13},{"containerName":"_get_comments","kind":12,"name":"new","line":362},{"localvar":"my","kind":13,"containerName":"_get_comments","name":"$size","line":363,"definition":"my"},{"kind":13,"containerName":"_get_comments","name":"$buffer","line":363},{"line":364,"name":"$comments_retrieved","containerName":"_get_comments","localvar":"my","kind":13,"definition":"my"},{"line":364,"kind":13,"containerName":"_get_comments","name":"$buffer"},{"line":365,"kind":13,"containerName":"_get_comments","name":"$comments_retrieved"},{"definition":"my","name":"@comments_split","kind":13,"localvar":"my","containerName":"_get_comments","line":366},{"line":366,"kind":13,"containerName":"_get_comments","name":"$comments_retrieved"},{"line":367,"containerName":"_get_comments","kind":13,"name":"@comments_split"},{"line":368,"name":"@comments_split","kind":13,"containerName":"_get_comments"},{"definition":"my","line":371,"localvar":"my","kind":13,"containerName":"_get_comments","name":"$tagname"},{"kind":13,"containerName":"_get_comments","name":"$text","line":371},{"line":372,"name":"$comment_obj","containerName":"_get_comments","localvar":"my","kind":13,"definition":"my"},{"line":372,"kind":12,"containerName":"_get_comments","name":"new"},{"containerName":"_get_comments","kind":13,"name":"$text","line":373},{"line":374,"kind":13,"containerName":"_get_comments","name":"$tagname"},{"containerName":"_get_comments","kind":13,"name":"$comments","line":376},{"line":376,"name":"add_Annotation","kind":12,"containerName":"_get_comments"},{"line":376,"kind":13,"containerName":"_get_comments","name":"$comment_obj"},{"line":380,"containerName":"_get_comments","kind":13,"name":"$self"},{"kind":13,"containerName":"_get_comments","name":"$comments","line":380},{"name":"$comments","containerName":"_get_comments","kind":13,"line":381}]},{"line":362,"name":"Bio","kind":12,"containerName":"Annotation::Collection"},{"containerName":"Annotation::Comment","kind":12,"name":"Bio","line":372},{"signature":{"label":"_get_header($self,$buffer)","parameters":[{"label":"$self"},{"label":"$buffer"}],"documentation":"__END__\n# $Id: scf.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::scf - .scf file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly. Use it via the Bio::SeqIO class, see\nL<Bio::SeqIO> for more information.\n\n=head1 DESCRIPTION\n\nThis object can transform .scf files to and from Bio::Seq::SequenceTrace\nobjects.  Mechanisms are present to retrieve trace data from scf\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chad Matsalla\n\nChad Matsalla\nbioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\nTony Cox, avc@sanger.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nNancy Hansen, nhansen at mail.nih.gov\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::scf;\nuse vars qw($DEFAULT_QUALITY);\nuse strict;\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SequenceTrace;\nuse Bio::Annotation::Comment;\nuse Dumpvalue;\n\nmy $dumper = new Dumpvalue();\n$dumper->veryCompact(1);\n\nBEGIN {\n    $DEFAULT_QUALITY= 10;\n}\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n                  (-verbose => $self->verbose(),\n                   -type => 'Bio::Seq::Quality'));\n  }\n  binmode $self->_fh; # for the Win32/Mac crowds  \n}\n\n=head2 next_seq()\n\n Title   : next_seq()\n Usage   : $scf = $stream->next_seq()\n Function: returns the next scf sequence in the stream\n Returns : a Bio::Seq::SequenceTrace object\n Args    : NONE\n Notes   : Fills the interface specification for SeqIO.\n            The SCF specification does not provide for having more then\n           one sequence in a given scf. So once the filehandle has been open\n           and passed to SeqIO do not expect to run this function more then\n           once on a given scf unless you embraced and extended the SCF\n       standard.  SCF comments are accessible through the Bio::SeqI\n           interface method annotation().\n\n\n#'\nsub next_seq {\n    my ($self) = @_;\n    my ($seq, $seqc, $fh, $buffer, $offset, $length, $read_bytes, @read,\n         %names);\n    # set up a filehandle to read in the scf\n    return if $self->{_readfile};\n    $fh = $self->_fh();\n    unless ($fh) {      # simulate the <> function\n        if ( !fileno(ARGV) or eof(ARGV) ) {\n            return unless my $ARGV = shift;\n            open(ARGV,$ARGV) or\n              $self->throw(\"Could not open $ARGV for SCF stream reading $!\");\n        }\n        $fh = \\*ARGV;\n    }\n    return unless read $fh, $buffer, 128; # no exception; probably end of file\n    # now, the master data structure will be the creator\n    my $creator;\n    # he first thing to do is parse the header. This is common\n    # among all versions of scf.\n    # the rest of the the information is different between the\n    # the different versions of scf.\n\n    $creator->{header} = $self->_get_header($buffer);\n    if ($creator->{header}->{'version'} lt \"3.00\") {\n        $self->debug(\"scf.pm is working with a version 2 scf.\\n\");\n        # first gather the trace information\n        $length = $creator->{header}->{'samples'} *\n          $creator->{header}->{sample_size}*4;\n        $buffer = $self->read_from_buffer($fh, $buffer, $length,\n                                                     $creator->{header}->{samples_offset});\n        # @read = unpack \"n$length\",$buffer;\n        # these traces need to be split\n        # returns a reference to a hash\n        $creator->{traces} = $self->_parse_v2_traces(\n                                                     $buffer,$creator->{header}->{sample_size});\n        # now go and get the base information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 12);\n        seek $fh,$offset,0;\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$creator->{header}->{bases_offset});\n        # now distill the information into its fractions.\n        # the old way : $self->_set_v2_bases($buffer);\n        # ref to an array, ref to a hash, string\n        ($creator->{peak_indices},\n         $creator->{qualities},\n         $creator->{sequence},\n         $creator->{accuracies}) = $self->_parse_v2_bases($buffer);\n\n    } else {\n        $self->debug(\"scf.pm is working with a version 3+ scf.\\n\");\n        my $transformed_read;\n        my $current_read_position = $creator->{header}->{sample_offset};\n        $length = $creator->{header}->{'samples'}*\n          $creator->{header}->{sample_size};\n        # $dumper->dumpValue($creator->{header});\n        foreach (qw(a c g t)) {\n            $buffer = $self->read_from_buffer($fh,$buffer,$length,$current_read_position);\n            my $byte = \"n\";\n            if ($creator->{header}->{sample_size} == 1) {\n                $byte = \"c\";\n            }\n            @read = unpack \"${byte}${length}\",$buffer;\n            # this little spurt of nonsense is because\n            # the trace values are given in the binary\n            # file as unsigned shorts but they really\n            # are signed deltas. 30000 is an arbitrary number\n            # (will there be any traces with a given\n            # point greater then 30000? I hope not.\n            # once the read is read, it must be changed\n            # from relative\n            foreach (@read) {\n                if ($_ > 30000) {\n                    $_ -= 65536;\n                }\n            }\n            $transformed_read = $self->_delta(\\@read,\"backward\");\n            # For 8-bit data we need to emulate a signed/unsigned\n            # cast that is implicit in the C implementations.....\n            if ($creator->{header}->{sample_size} == 1) {\n                foreach (@{$transformed_read}) {\n                    $_ += 256 if ($_ < 0);\n                }\n            }\n            $current_read_position += $length;\n            $creator->{'traces'}->{$_} = join(' ',@{$transformed_read});\n        }\n        \n        # now go and get the peak index information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 4);\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{peak_indices} = $self->_get_v3_peak_indices($buffer);\n        $offset += $length;\n        # now go and get the accuracy information\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{accuracies} = $self->_get_v3_base_accuracies($buffer);\n        # OK, now go and get the base information.\n        $offset += $length;\n        $length = $creator->{header}->{bases};\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{'sequence'} = unpack(\"a$length\",$buffer);\n        # now, finally, extract the calls from the accuracy information.\n        $creator->{qualities} = $self->_get_v3_quality(\n                                              $creator->{'sequence'},$creator->{accuracies});\n    }\n    # now go and get the comment information\n    $offset = $creator->{header}->{comments_offset};\n    seek $fh,$offset,0;\n    $length = $creator->{header}->{comment_size};\n    $buffer = $self->read_from_buffer($fh,$buffer,$length);\n    $creator->{comments} = $self->_get_comments($buffer);\n    my @name_comments = grep {$_->tagname() eq 'NAME'}\n                $creator->{comments}->get_Annotations('comment');\n    my $name_comment;\n    if (@name_comments){\n         $name_comment = $name_comments[0]->as_text();\n         $name_comment =~ s/^Comment:\\s+//;\n    }\n\n    my $swq = Bio::Seq::Quality->new(\n        -seq  =>   $creator->{'sequence'},\n        -qual =>    $creator->{'qualities'},\n        -id   =>    $name_comment\n                                              );\n    my $returner = Bio::Seq::SequenceTrace->new(\n                                           -swq      =>   $swq,\n                                            -trace_a  =>   $creator->{'traces'}->{'a'},\n                                            -trace_t  =>   $creator->{'traces'}->{'t'},\n                                           -trace_g  =>   $creator->{'traces'}->{'g'},\n                                           -trace_c  =>   $creator->{'traces'}->{'c'},\n                                       -accuracy_a    => $creator->{'accuracies'}->{'a'},\n                                   -accuracy_t    => $creator->{'accuracies'}->{'t'},\n                                      -accuracy_g    => $creator->{'accuracies'}->{'g'},\n                                    -accuracy_c    => $creator->{'accuracies'}->{'c'},\n                                 -peak_indices  => $creator->{'peak_indices'}\n                                                             );\n\n        $returner->annotation($creator->{'comments'}); # add SCF comments\n    $self->{'_readfile'} = 1;\n    return $returner;\n}\n\n\n=head2 _get_v3_quality()\n\n Title   : _get_v3_quality()\n Usage   : $self->_get_v3_quality()\n Function: Set the base qualities from version3 scf\n Returns : Nothing. Alters $self.\n Args    : None.\n Notes   :\n\n\n#'\nsub _get_v3_quality {\n    my ($self,$sequence,$accuracies) = @_;\n    my @bases = split//,$sequence;\n    my (@qualities,$currbase,$currqual,$counter);\n    for ($counter=0; $counter <= $#bases ; $counter++) {\n    $currbase = lc($bases[$counter]);\n    if ($currbase eq \"a\") { $currqual = $accuracies->{'a'}->[$counter]; }\n    elsif ($currbase eq \"c\") { $currqual = $accuracies->{'c'}->[$counter]; }\n    elsif ($currbase eq \"g\") { $currqual = $accuracies->{'g'}->[$counter]; }\n    elsif ($currbase eq \"t\") { $currqual = $accuracies->{'t'}->[$counter]; }\n    else { $currqual = \"unknown\"; }\n    push @qualities,$currqual;\n    }\n    return \\@qualities;\n}\n\n=head2 _get_v3_peak_indices($buffer)\n\n Title   : _get_v3_peak_indices($buffer)\n Usage   : $self->_get_v3_peak_indices($buffer);\n Function: Unpacks the base accuracies for version3 scf\n Returns : Nothing. Alters $self\n Args    : A scalar containing binary data.\n Notes   :\n\n\nsub _get_v3_peak_indices {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my @read = unpack \"N$length\",$buffer;\n     return join(' ',@read);\n}\n\n=head2 _get_v3_base_accuracies($buffer)\n\n Title   : _get_v3_base_accuracies($buffer)\n Usage   : $self->_get_v3_base_accuracies($buffer)\n Function: Set the base accuracies for version 3 scf's\n Returns : Nothing. Alters $self.\n Args    : A scalar containing binary data.\n Notes   :\n\n\n#'\nsub _get_v3_base_accuracies {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my $qlength = $length/4;\n    my $offset = 0;\n    my (@qualities,@sorter,$counter,$round,$last_base,$accuracies,$currbase);\n    foreach $currbase (qw(a c g t)) {\n         my @read;\n         $last_base = $offset + $qlength;\n         for (;$offset < $last_base; $offset += $qlength) {\n                    # a bioperler (perhaps me?) changed the unpack string to include 'n' rather than 'C'\n                    # on 040322 I think that 'C' is correct. please email chad if you would like to accuse me of being incorrect\n              @read = unpack \"C$qlength\", substr($buffer,$offset,$qlength);\n              $accuracies->{$currbase} = \\@read;\n         }\n    }\n     return $accuracies;\n}\n\n\n=head2 _get_comments($buffer)\n\n Title   : _get_comments($buffer)\n Usage   : $self->_get_comments($buffer);\n Function: Gather the comments section from the scf and parse it into its\n            components.\n Returns : a Bio::Annotation::Collection object\n Args    : The buffer. It is expected that the buffer contains a binary\n            string for the comments section of an scf file according to\n            the scf file specifications.\n Notes   :\n\n\nsub _get_comments {\n    my ($self,$buffer) = @_;\n    my $comments = Bio::Annotation::Collection->new();\n    my $size = length($buffer);\n    my $comments_retrieved = unpack \"a$size\",$buffer;\n    $comments_retrieved =~ s/\\0//;\n    my @comments_split = split/\\n/,$comments_retrieved;\n    if (@comments_split) {\n        foreach (@comments_split) {\n            /(\\w+)=(.*)/;\n            if ($1 && $2) {\n                my ($tagname, $text) = ($1, $2);\n                my $comment_obj = Bio::Annotation::Comment->new(\n                                     -text => $text,\n                                     -tagname => $tagname);\n\n                $comments->add_Annotation('comment', $comment_obj);\n            }\n        }\n    }\n    $self->{'comments'} = $comments;\n    return $comments;\n}\n\n=head2 _get_header()\n\n Title   : _get_header($buffer)\n Usage   : $self->_get_header($buffer);\n Function: Gather the header section from the scf and parse it into its\n           components.\n Returns : Reference to a hash containing the header components.\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the header section of an scf file according to the\n           scf file specifications.\n Notes   : None."},"range":{"start":{"character":0,"line":398},"end":{"line":413,"character":9999}},"kind":12,"line":398,"detail":"($self,$buffer)","definition":"sub","containerName":"main::","name":"_get_header","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"_get_header","line":399},{"line":399,"containerName":"_get_header","kind":13,"name":"$buffer"},{"definition":"my","line":400,"name":"$header","localvar":"my","containerName":"_get_header","kind":13},{"kind":13,"containerName":"_get_header","name":"$header","line":401},{"line":402,"kind":13,"containerName":"_get_header","name":"$header"},{"line":403,"name":"$header","containerName":"_get_header","kind":13},{"line":404,"containerName":"_get_header","kind":13,"name":"$header"},{"line":405,"name":"$header","containerName":"_get_header","kind":13},{"containerName":"_get_header","kind":13,"name":"$header","line":406},{"line":407,"kind":13,"containerName":"_get_header","name":"$header"},{"name":"$header","kind":13,"containerName":"_get_header","line":408},{"line":409,"containerName":"_get_header","kind":13,"name":"$header"},{"kind":13,"containerName":"_get_header","name":"$header","line":410},{"name":"$header","kind":13,"containerName":"_get_header","line":411},{"kind":13,"containerName":"_get_header","name":"$header","line":412},{"line":413,"name":"$header","kind":13,"containerName":"_get_header"}]},{"line":413,"name":"$buffer","containerName":null,"kind":13},{"line":415,"containerName":null,"kind":13,"name":"%self"},{"name":"$header","kind":13,"containerName":null,"line":415},{"line":416,"name":"$header","containerName":null,"kind":13},{"definition":"sub","detail":"($self,$buffer)","children":[{"line":434,"localvar":"my","kind":13,"containerName":"_parse_v2_bases","name":"$self","definition":"my"},{"line":434,"containerName":"_parse_v2_bases","kind":13,"name":"$buffer"},{"definition":"my","name":"$length","kind":13,"localvar":"my","containerName":"_parse_v2_bases","line":435},{"line":435,"name":"$buffer","containerName":"_parse_v2_bases","kind":13},{"definition":"my","line":436,"containerName":"_parse_v2_bases","localvar":"my","kind":13,"name":"$offset2"},{"name":"$currbuff","containerName":"_parse_v2_bases","kind":13,"line":436},{"kind":13,"containerName":"_parse_v2_bases","name":"$currbase","line":436},{"line":436,"name":"$currqual","containerName":"_parse_v2_bases","kind":13},{"line":436,"name":"$sequence","containerName":"_parse_v2_bases","kind":13},{"name":"@qualities","kind":13,"containerName":"_parse_v2_bases","line":436},{"containerName":"_parse_v2_bases","kind":13,"name":"@indices","line":436},{"definition":"my","line":437,"name":"@read","containerName":"_parse_v2_bases","localvar":"my","kind":13},{"containerName":"_parse_v2_bases","kind":13,"name":"$harvester","line":437},{"line":437,"name":"$accuracies","kind":13,"containerName":"_parse_v2_bases"},{"line":438,"name":"$offset2","kind":13,"containerName":"_parse_v2_bases"},{"line":438,"name":"$offset2","containerName":"_parse_v2_bases","kind":13},{"line":438,"name":"$length","containerName":"_parse_v2_bases","kind":13},{"name":"$offset2","kind":13,"containerName":"_parse_v2_bases","line":438},{"kind":13,"containerName":"_parse_v2_bases","name":"@read","line":439},{"line":439,"name":"$buffer","containerName":"_parse_v2_bases","kind":13},{"line":439,"name":"$offset2","kind":13,"containerName":"_parse_v2_bases"},{"name":"$length","kind":13,"containerName":"_parse_v2_bases","line":439},{"line":440,"name":"@indices","containerName":"_parse_v2_bases","kind":13},{"kind":13,"containerName":"_parse_v2_bases","name":"$read","line":440},{"line":441,"name":"$currbase","containerName":"_parse_v2_bases","kind":13},{"line":441,"name":"$read","containerName":"_parse_v2_bases","kind":13},{"containerName":"_parse_v2_bases","kind":13,"name":"$currbase","line":442},{"line":442,"name":"$currqual","containerName":"_parse_v2_bases","kind":13},{"line":442,"kind":13,"containerName":"_parse_v2_bases","name":"$read"},{"line":443,"containerName":"_parse_v2_bases","kind":13,"name":"$currbase"},{"line":443,"name":"$currqual","containerName":"_parse_v2_bases","kind":13},{"name":"$read","containerName":"_parse_v2_bases","kind":13,"line":443},{"line":444,"containerName":"_parse_v2_bases","kind":13,"name":"$currbase"},{"name":"$currqual","containerName":"_parse_v2_bases","kind":13,"line":444},{"line":444,"name":"$read","kind":13,"containerName":"_parse_v2_bases"},{"line":445,"kind":13,"containerName":"_parse_v2_bases","name":"$currbase"},{"line":445,"name":"$currqual","containerName":"_parse_v2_bases","kind":13},{"line":445,"name":"$read","kind":13,"containerName":"_parse_v2_bases"},{"containerName":"_parse_v2_bases","kind":13,"name":"$currqual","line":446},{"name":"$accuracies","containerName":"_parse_v2_bases","kind":13,"line":447},{"line":447,"kind":13,"containerName":"_parse_v2_bases","name":"$read"},{"containerName":"_parse_v2_bases","kind":13,"name":"$accuracies","line":448}],"containerName":"main::","name":"_parse_v2_bases","signature":{"label":"_parse_v2_bases($self,$buffer)","parameters":[{"label":"$self"},{"label":"$buffer"}],"documentation":"__END__\n# $Id: scf.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::scf - .scf file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly. Use it via the Bio::SeqIO class, see\nL<Bio::SeqIO> for more information.\n\n=head1 DESCRIPTION\n\nThis object can transform .scf files to and from Bio::Seq::SequenceTrace\nobjects.  Mechanisms are present to retrieve trace data from scf\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chad Matsalla\n\nChad Matsalla\nbioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\nTony Cox, avc@sanger.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nNancy Hansen, nhansen at mail.nih.gov\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::scf;\nuse vars qw($DEFAULT_QUALITY);\nuse strict;\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SequenceTrace;\nuse Bio::Annotation::Comment;\nuse Dumpvalue;\n\nmy $dumper = new Dumpvalue();\n$dumper->veryCompact(1);\n\nBEGIN {\n    $DEFAULT_QUALITY= 10;\n}\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n                  (-verbose => $self->verbose(),\n                   -type => 'Bio::Seq::Quality'));\n  }\n  binmode $self->_fh; # for the Win32/Mac crowds  \n}\n\n=head2 next_seq()\n\n Title   : next_seq()\n Usage   : $scf = $stream->next_seq()\n Function: returns the next scf sequence in the stream\n Returns : a Bio::Seq::SequenceTrace object\n Args    : NONE\n Notes   : Fills the interface specification for SeqIO.\n            The SCF specification does not provide for having more then\n           one sequence in a given scf. So once the filehandle has been open\n           and passed to SeqIO do not expect to run this function more then\n           once on a given scf unless you embraced and extended the SCF\n       standard.  SCF comments are accessible through the Bio::SeqI\n           interface method annotation().\n\n\n#'\nsub next_seq {\n    my ($self) = @_;\n    my ($seq, $seqc, $fh, $buffer, $offset, $length, $read_bytes, @read,\n         %names);\n    # set up a filehandle to read in the scf\n    return if $self->{_readfile};\n    $fh = $self->_fh();\n    unless ($fh) {      # simulate the <> function\n        if ( !fileno(ARGV) or eof(ARGV) ) {\n            return unless my $ARGV = shift;\n            open(ARGV,$ARGV) or\n              $self->throw(\"Could not open $ARGV for SCF stream reading $!\");\n        }\n        $fh = \\*ARGV;\n    }\n    return unless read $fh, $buffer, 128; # no exception; probably end of file\n    # now, the master data structure will be the creator\n    my $creator;\n    # he first thing to do is parse the header. This is common\n    # among all versions of scf.\n    # the rest of the the information is different between the\n    # the different versions of scf.\n\n    $creator->{header} = $self->_get_header($buffer);\n    if ($creator->{header}->{'version'} lt \"3.00\") {\n        $self->debug(\"scf.pm is working with a version 2 scf.\\n\");\n        # first gather the trace information\n        $length = $creator->{header}->{'samples'} *\n          $creator->{header}->{sample_size}*4;\n        $buffer = $self->read_from_buffer($fh, $buffer, $length,\n                                                     $creator->{header}->{samples_offset});\n        # @read = unpack \"n$length\",$buffer;\n        # these traces need to be split\n        # returns a reference to a hash\n        $creator->{traces} = $self->_parse_v2_traces(\n                                                     $buffer,$creator->{header}->{sample_size});\n        # now go and get the base information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 12);\n        seek $fh,$offset,0;\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$creator->{header}->{bases_offset});\n        # now distill the information into its fractions.\n        # the old way : $self->_set_v2_bases($buffer);\n        # ref to an array, ref to a hash, string\n        ($creator->{peak_indices},\n         $creator->{qualities},\n         $creator->{sequence},\n         $creator->{accuracies}) = $self->_parse_v2_bases($buffer);\n\n    } else {\n        $self->debug(\"scf.pm is working with a version 3+ scf.\\n\");\n        my $transformed_read;\n        my $current_read_position = $creator->{header}->{sample_offset};\n        $length = $creator->{header}->{'samples'}*\n          $creator->{header}->{sample_size};\n        # $dumper->dumpValue($creator->{header});\n        foreach (qw(a c g t)) {\n            $buffer = $self->read_from_buffer($fh,$buffer,$length,$current_read_position);\n            my $byte = \"n\";\n            if ($creator->{header}->{sample_size} == 1) {\n                $byte = \"c\";\n            }\n            @read = unpack \"${byte}${length}\",$buffer;\n            # this little spurt of nonsense is because\n            # the trace values are given in the binary\n            # file as unsigned shorts but they really\n            # are signed deltas. 30000 is an arbitrary number\n            # (will there be any traces with a given\n            # point greater then 30000? I hope not.\n            # once the read is read, it must be changed\n            # from relative\n            foreach (@read) {\n                if ($_ > 30000) {\n                    $_ -= 65536;\n                }\n            }\n            $transformed_read = $self->_delta(\\@read,\"backward\");\n            # For 8-bit data we need to emulate a signed/unsigned\n            # cast that is implicit in the C implementations.....\n            if ($creator->{header}->{sample_size} == 1) {\n                foreach (@{$transformed_read}) {\n                    $_ += 256 if ($_ < 0);\n                }\n            }\n            $current_read_position += $length;\n            $creator->{'traces'}->{$_} = join(' ',@{$transformed_read});\n        }\n        \n        # now go and get the peak index information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 4);\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{peak_indices} = $self->_get_v3_peak_indices($buffer);\n        $offset += $length;\n        # now go and get the accuracy information\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{accuracies} = $self->_get_v3_base_accuracies($buffer);\n        # OK, now go and get the base information.\n        $offset += $length;\n        $length = $creator->{header}->{bases};\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{'sequence'} = unpack(\"a$length\",$buffer);\n        # now, finally, extract the calls from the accuracy information.\n        $creator->{qualities} = $self->_get_v3_quality(\n                                              $creator->{'sequence'},$creator->{accuracies});\n    }\n    # now go and get the comment information\n    $offset = $creator->{header}->{comments_offset};\n    seek $fh,$offset,0;\n    $length = $creator->{header}->{comment_size};\n    $buffer = $self->read_from_buffer($fh,$buffer,$length);\n    $creator->{comments} = $self->_get_comments($buffer);\n    my @name_comments = grep {$_->tagname() eq 'NAME'}\n                $creator->{comments}->get_Annotations('comment');\n    my $name_comment;\n    if (@name_comments){\n         $name_comment = $name_comments[0]->as_text();\n         $name_comment =~ s/^Comment:\\s+//;\n    }\n\n    my $swq = Bio::Seq::Quality->new(\n        -seq  =>   $creator->{'sequence'},\n        -qual =>    $creator->{'qualities'},\n        -id   =>    $name_comment\n                                              );\n    my $returner = Bio::Seq::SequenceTrace->new(\n                                           -swq      =>   $swq,\n                                            -trace_a  =>   $creator->{'traces'}->{'a'},\n                                            -trace_t  =>   $creator->{'traces'}->{'t'},\n                                           -trace_g  =>   $creator->{'traces'}->{'g'},\n                                           -trace_c  =>   $creator->{'traces'}->{'c'},\n                                       -accuracy_a    => $creator->{'accuracies'}->{'a'},\n                                   -accuracy_t    => $creator->{'accuracies'}->{'t'},\n                                      -accuracy_g    => $creator->{'accuracies'}->{'g'},\n                                    -accuracy_c    => $creator->{'accuracies'}->{'c'},\n                                 -peak_indices  => $creator->{'peak_indices'}\n                                                             );\n\n        $returner->annotation($creator->{'comments'}); # add SCF comments\n    $self->{'_readfile'} = 1;\n    return $returner;\n}\n\n\n=head2 _get_v3_quality()\n\n Title   : _get_v3_quality()\n Usage   : $self->_get_v3_quality()\n Function: Set the base qualities from version3 scf\n Returns : Nothing. Alters $self.\n Args    : None.\n Notes   :\n\n\n#'\nsub _get_v3_quality {\n    my ($self,$sequence,$accuracies) = @_;\n    my @bases = split//,$sequence;\n    my (@qualities,$currbase,$currqual,$counter);\n    for ($counter=0; $counter <= $#bases ; $counter++) {\n    $currbase = lc($bases[$counter]);\n    if ($currbase eq \"a\") { $currqual = $accuracies->{'a'}->[$counter]; }\n    elsif ($currbase eq \"c\") { $currqual = $accuracies->{'c'}->[$counter]; }\n    elsif ($currbase eq \"g\") { $currqual = $accuracies->{'g'}->[$counter]; }\n    elsif ($currbase eq \"t\") { $currqual = $accuracies->{'t'}->[$counter]; }\n    else { $currqual = \"unknown\"; }\n    push @qualities,$currqual;\n    }\n    return \\@qualities;\n}\n\n=head2 _get_v3_peak_indices($buffer)\n\n Title   : _get_v3_peak_indices($buffer)\n Usage   : $self->_get_v3_peak_indices($buffer);\n Function: Unpacks the base accuracies for version3 scf\n Returns : Nothing. Alters $self\n Args    : A scalar containing binary data.\n Notes   :\n\n\nsub _get_v3_peak_indices {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my @read = unpack \"N$length\",$buffer;\n     return join(' ',@read);\n}\n\n=head2 _get_v3_base_accuracies($buffer)\n\n Title   : _get_v3_base_accuracies($buffer)\n Usage   : $self->_get_v3_base_accuracies($buffer)\n Function: Set the base accuracies for version 3 scf's\n Returns : Nothing. Alters $self.\n Args    : A scalar containing binary data.\n Notes   :\n\n\n#'\nsub _get_v3_base_accuracies {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my $qlength = $length/4;\n    my $offset = 0;\n    my (@qualities,@sorter,$counter,$round,$last_base,$accuracies,$currbase);\n    foreach $currbase (qw(a c g t)) {\n         my @read;\n         $last_base = $offset + $qlength;\n         for (;$offset < $last_base; $offset += $qlength) {\n                    # a bioperler (perhaps me?) changed the unpack string to include 'n' rather than 'C'\n                    # on 040322 I think that 'C' is correct. please email chad if you would like to accuse me of being incorrect\n              @read = unpack \"C$qlength\", substr($buffer,$offset,$qlength);\n              $accuracies->{$currbase} = \\@read;\n         }\n    }\n     return $accuracies;\n}\n\n\n=head2 _get_comments($buffer)\n\n Title   : _get_comments($buffer)\n Usage   : $self->_get_comments($buffer);\n Function: Gather the comments section from the scf and parse it into its\n            components.\n Returns : a Bio::Annotation::Collection object\n Args    : The buffer. It is expected that the buffer contains a binary\n            string for the comments section of an scf file according to\n            the scf file specifications.\n Notes   :\n\n\nsub _get_comments {\n    my ($self,$buffer) = @_;\n    my $comments = Bio::Annotation::Collection->new();\n    my $size = length($buffer);\n    my $comments_retrieved = unpack \"a$size\",$buffer;\n    $comments_retrieved =~ s/\\0//;\n    my @comments_split = split/\\n/,$comments_retrieved;\n    if (@comments_split) {\n        foreach (@comments_split) {\n            /(\\w+)=(.*)/;\n            if ($1 && $2) {\n                my ($tagname, $text) = ($1, $2);\n                my $comment_obj = Bio::Annotation::Comment->new(\n                                     -text => $text,\n                                     -tagname => $tagname);\n\n                $comments->add_Annotation('comment', $comment_obj);\n            }\n        }\n    }\n    $self->{'comments'} = $comments;\n    return $comments;\n}\n\n=head2 _get_header()\n\n Title   : _get_header($buffer)\n Usage   : $self->_get_header($buffer);\n Function: Gather the header section from the scf and parse it into its\n           components.\n Returns : Reference to a hash containing the header components.\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the header section of an scf file according to the\n           scf file specifications.\n Notes   : None.\n\n\nsub _get_header {\n    my ($self,$buffer) = @_;\n    my $header;\n    ($header->{'scf'},\n     $header->{'samples'},\n     $header->{'sample_offset'},\n     $header->{'bases'},\n     $header->{'bases_left_clip'},\n     $header->{'bases_right_clip'},\n     $header->{'bases_offset'},\n     $header->{'comment_size'},\n     $header->{'comments_offset'},\n     $header->{'version'},\n     $header->{'sample_size'},\n     $header->{'code_set'},\n     @{$header->{'header_spare'}} ) = unpack \"a4 NNNNNNNN a4 NN N20\", $buffer;\n\n    $self->{'header'} = $header;\n    return $header;\n}\n\n=head2 _parse_v2_bases($buffer)\n\n Title   : _parse_v2_bases($buffer)\n Usage   : $self->_parse_v2_bases($buffer);\n Function: Gather the bases section from the scf and parse it into its\n           components.\n Returns :\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the bases section of an scf file according to the\n           scf file specifications.\n Notes   : None."},"line":433,"range":{"end":{"character":9999,"line":448},"start":{"character":0,"line":433}},"kind":12},{"name":"@read","kind":13,"containerName":null,"line":448},{"kind":13,"containerName":null,"name":"%accuracies","line":449},{"containerName":null,"kind":13,"name":"@read","line":449},{"name":"%accuracies","kind":13,"containerName":null,"line":450},{"name":"@read","containerName":null,"kind":13,"line":450},{"name":"$sequence","containerName":null,"kind":13,"line":452},{"line":452,"kind":13,"containerName":null,"name":"$currbase"},{"name":"@qualities","kind":13,"containerName":null,"line":453},{"line":453,"name":"$currqual","containerName":null,"kind":13},{"line":455,"containerName":null,"kind":13,"name":"@indices"},{"kind":13,"containerName":null,"name":"@qualities","line":455},{"line":455,"containerName":null,"kind":13,"name":"$sequence"},{"containerName":null,"kind":13,"name":"$accuracies","line":455},{"signature":{"documentation":"__END__\n# $Id: scf.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::scf - .scf file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly. Use it via the Bio::SeqIO class, see\nL<Bio::SeqIO> for more information.\n\n=head1 DESCRIPTION\n\nThis object can transform .scf files to and from Bio::Seq::SequenceTrace\nobjects.  Mechanisms are present to retrieve trace data from scf\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chad Matsalla\n\nChad Matsalla\nbioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\nTony Cox, avc@sanger.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nNancy Hansen, nhansen at mail.nih.gov\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::scf;\nuse vars qw($DEFAULT_QUALITY);\nuse strict;\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SequenceTrace;\nuse Bio::Annotation::Comment;\nuse Dumpvalue;\n\nmy $dumper = new Dumpvalue();\n$dumper->veryCompact(1);\n\nBEGIN {\n    $DEFAULT_QUALITY= 10;\n}\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n                  (-verbose => $self->verbose(),\n                   -type => 'Bio::Seq::Quality'));\n  }\n  binmode $self->_fh; # for the Win32/Mac crowds  \n}\n\n=head2 next_seq()\n\n Title   : next_seq()\n Usage   : $scf = $stream->next_seq()\n Function: returns the next scf sequence in the stream\n Returns : a Bio::Seq::SequenceTrace object\n Args    : NONE\n Notes   : Fills the interface specification for SeqIO.\n            The SCF specification does not provide for having more then\n           one sequence in a given scf. So once the filehandle has been open\n           and passed to SeqIO do not expect to run this function more then\n           once on a given scf unless you embraced and extended the SCF\n       standard.  SCF comments are accessible through the Bio::SeqI\n           interface method annotation().\n\n\n#'\nsub next_seq {\n    my ($self) = @_;\n    my ($seq, $seqc, $fh, $buffer, $offset, $length, $read_bytes, @read,\n         %names);\n    # set up a filehandle to read in the scf\n    return if $self->{_readfile};\n    $fh = $self->_fh();\n    unless ($fh) {      # simulate the <> function\n        if ( !fileno(ARGV) or eof(ARGV) ) {\n            return unless my $ARGV = shift;\n            open(ARGV,$ARGV) or\n              $self->throw(\"Could not open $ARGV for SCF stream reading $!\");\n        }\n        $fh = \\*ARGV;\n    }\n    return unless read $fh, $buffer, 128; # no exception; probably end of file\n    # now, the master data structure will be the creator\n    my $creator;\n    # he first thing to do is parse the header. This is common\n    # among all versions of scf.\n    # the rest of the the information is different between the\n    # the different versions of scf.\n\n    $creator->{header} = $self->_get_header($buffer);\n    if ($creator->{header}->{'version'} lt \"3.00\") {\n        $self->debug(\"scf.pm is working with a version 2 scf.\\n\");\n        # first gather the trace information\n        $length = $creator->{header}->{'samples'} *\n          $creator->{header}->{sample_size}*4;\n        $buffer = $self->read_from_buffer($fh, $buffer, $length,\n                                                     $creator->{header}->{samples_offset});\n        # @read = unpack \"n$length\",$buffer;\n        # these traces need to be split\n        # returns a reference to a hash\n        $creator->{traces} = $self->_parse_v2_traces(\n                                                     $buffer,$creator->{header}->{sample_size});\n        # now go and get the base information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 12);\n        seek $fh,$offset,0;\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$creator->{header}->{bases_offset});\n        # now distill the information into its fractions.\n        # the old way : $self->_set_v2_bases($buffer);\n        # ref to an array, ref to a hash, string\n        ($creator->{peak_indices},\n         $creator->{qualities},\n         $creator->{sequence},\n         $creator->{accuracies}) = $self->_parse_v2_bases($buffer);\n\n    } else {\n        $self->debug(\"scf.pm is working with a version 3+ scf.\\n\");\n        my $transformed_read;\n        my $current_read_position = $creator->{header}->{sample_offset};\n        $length = $creator->{header}->{'samples'}*\n          $creator->{header}->{sample_size};\n        # $dumper->dumpValue($creator->{header});\n        foreach (qw(a c g t)) {\n            $buffer = $self->read_from_buffer($fh,$buffer,$length,$current_read_position);\n            my $byte = \"n\";\n            if ($creator->{header}->{sample_size} == 1) {\n                $byte = \"c\";\n            }\n            @read = unpack \"${byte}${length}\",$buffer;\n            # this little spurt of nonsense is because\n            # the trace values are given in the binary\n            # file as unsigned shorts but they really\n            # are signed deltas. 30000 is an arbitrary number\n            # (will there be any traces with a given\n            # point greater then 30000? I hope not.\n            # once the read is read, it must be changed\n            # from relative\n            foreach (@read) {\n                if ($_ > 30000) {\n                    $_ -= 65536;\n                }\n            }\n            $transformed_read = $self->_delta(\\@read,\"backward\");\n            # For 8-bit data we need to emulate a signed/unsigned\n            # cast that is implicit in the C implementations.....\n            if ($creator->{header}->{sample_size} == 1) {\n                foreach (@{$transformed_read}) {\n                    $_ += 256 if ($_ < 0);\n                }\n            }\n            $current_read_position += $length;\n            $creator->{'traces'}->{$_} = join(' ',@{$transformed_read});\n        }\n        \n        # now go and get the peak index information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 4);\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{peak_indices} = $self->_get_v3_peak_indices($buffer);\n        $offset += $length;\n        # now go and get the accuracy information\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{accuracies} = $self->_get_v3_base_accuracies($buffer);\n        # OK, now go and get the base information.\n        $offset += $length;\n        $length = $creator->{header}->{bases};\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{'sequence'} = unpack(\"a$length\",$buffer);\n        # now, finally, extract the calls from the accuracy information.\n        $creator->{qualities} = $self->_get_v3_quality(\n                                              $creator->{'sequence'},$creator->{accuracies});\n    }\n    # now go and get the comment information\n    $offset = $creator->{header}->{comments_offset};\n    seek $fh,$offset,0;\n    $length = $creator->{header}->{comment_size};\n    $buffer = $self->read_from_buffer($fh,$buffer,$length);\n    $creator->{comments} = $self->_get_comments($buffer);\n    my @name_comments = grep {$_->tagname() eq 'NAME'}\n                $creator->{comments}->get_Annotations('comment');\n    my $name_comment;\n    if (@name_comments){\n         $name_comment = $name_comments[0]->as_text();\n         $name_comment =~ s/^Comment:\\s+//;\n    }\n\n    my $swq = Bio::Seq::Quality->new(\n        -seq  =>   $creator->{'sequence'},\n        -qual =>    $creator->{'qualities'},\n        -id   =>    $name_comment\n                                              );\n    my $returner = Bio::Seq::SequenceTrace->new(\n                                           -swq      =>   $swq,\n                                            -trace_a  =>   $creator->{'traces'}->{'a'},\n                                            -trace_t  =>   $creator->{'traces'}->{'t'},\n                                           -trace_g  =>   $creator->{'traces'}->{'g'},\n                                           -trace_c  =>   $creator->{'traces'}->{'c'},\n                                       -accuracy_a    => $creator->{'accuracies'}->{'a'},\n                                   -accuracy_t    => $creator->{'accuracies'}->{'t'},\n                                      -accuracy_g    => $creator->{'accuracies'}->{'g'},\n                                    -accuracy_c    => $creator->{'accuracies'}->{'c'},\n                                 -peak_indices  => $creator->{'peak_indices'}\n                                                             );\n\n        $returner->annotation($creator->{'comments'}); # add SCF comments\n    $self->{'_readfile'} = 1;\n    return $returner;\n}\n\n\n=head2 _get_v3_quality()\n\n Title   : _get_v3_quality()\n Usage   : $self->_get_v3_quality()\n Function: Set the base qualities from version3 scf\n Returns : Nothing. Alters $self.\n Args    : None.\n Notes   :\n\n\n#'\nsub _get_v3_quality {\n    my ($self,$sequence,$accuracies) = @_;\n    my @bases = split//,$sequence;\n    my (@qualities,$currbase,$currqual,$counter);\n    for ($counter=0; $counter <= $#bases ; $counter++) {\n    $currbase = lc($bases[$counter]);\n    if ($currbase eq \"a\") { $currqual = $accuracies->{'a'}->[$counter]; }\n    elsif ($currbase eq \"c\") { $currqual = $accuracies->{'c'}->[$counter]; }\n    elsif ($currbase eq \"g\") { $currqual = $accuracies->{'g'}->[$counter]; }\n    elsif ($currbase eq \"t\") { $currqual = $accuracies->{'t'}->[$counter]; }\n    else { $currqual = \"unknown\"; }\n    push @qualities,$currqual;\n    }\n    return \\@qualities;\n}\n\n=head2 _get_v3_peak_indices($buffer)\n\n Title   : _get_v3_peak_indices($buffer)\n Usage   : $self->_get_v3_peak_indices($buffer);\n Function: Unpacks the base accuracies for version3 scf\n Returns : Nothing. Alters $self\n Args    : A scalar containing binary data.\n Notes   :\n\n\nsub _get_v3_peak_indices {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my @read = unpack \"N$length\",$buffer;\n     return join(' ',@read);\n}\n\n=head2 _get_v3_base_accuracies($buffer)\n\n Title   : _get_v3_base_accuracies($buffer)\n Usage   : $self->_get_v3_base_accuracies($buffer)\n Function: Set the base accuracies for version 3 scf's\n Returns : Nothing. Alters $self.\n Args    : A scalar containing binary data.\n Notes   :\n\n\n#'\nsub _get_v3_base_accuracies {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my $qlength = $length/4;\n    my $offset = 0;\n    my (@qualities,@sorter,$counter,$round,$last_base,$accuracies,$currbase);\n    foreach $currbase (qw(a c g t)) {\n         my @read;\n         $last_base = $offset + $qlength;\n         for (;$offset < $last_base; $offset += $qlength) {\n                    # a bioperler (perhaps me?) changed the unpack string to include 'n' rather than 'C'\n                    # on 040322 I think that 'C' is correct. please email chad if you would like to accuse me of being incorrect\n              @read = unpack \"C$qlength\", substr($buffer,$offset,$qlength);\n              $accuracies->{$currbase} = \\@read;\n         }\n    }\n     return $accuracies;\n}\n\n\n=head2 _get_comments($buffer)\n\n Title   : _get_comments($buffer)\n Usage   : $self->_get_comments($buffer);\n Function: Gather the comments section from the scf and parse it into its\n            components.\n Returns : a Bio::Annotation::Collection object\n Args    : The buffer. It is expected that the buffer contains a binary\n            string for the comments section of an scf file according to\n            the scf file specifications.\n Notes   :\n\n\nsub _get_comments {\n    my ($self,$buffer) = @_;\n    my $comments = Bio::Annotation::Collection->new();\n    my $size = length($buffer);\n    my $comments_retrieved = unpack \"a$size\",$buffer;\n    $comments_retrieved =~ s/\\0//;\n    my @comments_split = split/\\n/,$comments_retrieved;\n    if (@comments_split) {\n        foreach (@comments_split) {\n            /(\\w+)=(.*)/;\n            if ($1 && $2) {\n                my ($tagname, $text) = ($1, $2);\n                my $comment_obj = Bio::Annotation::Comment->new(\n                                     -text => $text,\n                                     -tagname => $tagname);\n\n                $comments->add_Annotation('comment', $comment_obj);\n            }\n        }\n    }\n    $self->{'comments'} = $comments;\n    return $comments;\n}\n\n=head2 _get_header()\n\n Title   : _get_header($buffer)\n Usage   : $self->_get_header($buffer);\n Function: Gather the header section from the scf and parse it into its\n           components.\n Returns : Reference to a hash containing the header components.\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the header section of an scf file according to the\n           scf file specifications.\n Notes   : None.\n\n\nsub _get_header {\n    my ($self,$buffer) = @_;\n    my $header;\n    ($header->{'scf'},\n     $header->{'samples'},\n     $header->{'sample_offset'},\n     $header->{'bases'},\n     $header->{'bases_left_clip'},\n     $header->{'bases_right_clip'},\n     $header->{'bases_offset'},\n     $header->{'comment_size'},\n     $header->{'comments_offset'},\n     $header->{'version'},\n     $header->{'sample_size'},\n     $header->{'code_set'},\n     @{$header->{'header_spare'}} ) = unpack \"a4 NNNNNNNN a4 NN N20\", $buffer;\n\n    $self->{'header'} = $header;\n    return $header;\n}\n\n=head2 _parse_v2_bases($buffer)\n\n Title   : _parse_v2_bases($buffer)\n Usage   : $self->_parse_v2_bases($buffer);\n Function: Gather the bases section from the scf and parse it into its\n           components.\n Returns :\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the bases section of an scf file according to the\n           scf file specifications.\n Notes   : None.\n\n\nsub _parse_v2_bases {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my ($offset2,$currbuff,$currbase,$currqual,$sequence,@qualities,@indices);\n    my (@read,$harvester,$accuracies);\n    for ($offset2=0;$offset2<$length;$offset2+=12) {\n         @read = unpack \"N C C C C a C3\", substr($buffer,$offset2,$length);\n         push @indices,$read[0];\n         $currbase = lc($read[5]);\n         if ($currbase eq \"a\") { $currqual = $read[1]; }\n         elsif ($currbase eq \"c\") { $currqual = $read[2]; }\n         elsif ($currbase eq \"g\") { $currqual = $read[3]; }\n         elsif ($currbase eq \"t\") { $currqual = $read[4]; }\n         else { $currqual = \"UNKNOWN\"; }\n         push @{$accuracies->{\"a\"}},$read[1];\n         push @{$accuracies->{\"c\"}},$read[2];\n         push @{$accuracies->{\"g\"}},$read[3];\n         push @{$accuracies->{\"t\"}},$read[4];\n\n         $sequence .= $currbase;\n         push @qualities,$currqual;\n    }\n     return (\\@indices,\\@qualities,$sequence,$accuracies)\n}\n\n=head2 _parse_v2_traces(\\@traces_array)\n\n Title   : _pares_v2_traces(\\@traces_array)\n Usage   : $self->_parse_v2_traces(\\@traces_array);\n Function: Parses an scf Version2 trace array into its base components.\n Returns : Nothing. Modifies $self.\n Args    : A reference to an array of the unpacked traces section of an\n           scf version2 file.","parameters":[{"label":"$self"},{"label":"$buffer"},{"label":"$sample_size"}],"label":"_parse_v2_traces($self,$buffer,$sample_size)"},"range":{"end":{"line":481,"character":9999},"start":{"character":0,"line":469}},"kind":12,"line":469,"detail":"($self,$buffer,$sample_size)","definition":"sub","name":"_parse_v2_traces","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"_parse_v2_traces","name":"$self","line":470,"definition":"my"},{"line":470,"containerName":"_parse_v2_traces","kind":13,"name":"$buffer"},{"line":470,"name":"$sample_size","kind":13,"containerName":"_parse_v2_traces"},{"definition":"my","line":471,"name":"$byte","localvar":"my","containerName":"_parse_v2_traces","kind":13},{"line":472,"name":"$sample_size","kind":13,"containerName":"_parse_v2_traces"},{"containerName":"_parse_v2_traces","kind":13,"name":"$byte","line":472},{"kind":13,"containerName":"_parse_v2_traces","name":"$byte","line":473},{"line":474,"localvar":"my","containerName":"_parse_v2_traces","kind":13,"name":"$length","definition":"my"},{"line":474,"containerName":"_parse_v2_traces","kind":13,"name":"$buffer"},{"name":"@read","containerName":"_parse_v2_traces","localvar":"my","kind":13,"line":475,"definition":"my"},{"line":475,"containerName":"_parse_v2_traces","kind":13,"name":"$buffer"},{"definition":"my","kind":13,"localvar":"my","containerName":"_parse_v2_traces","name":"$traces","line":477},{"definition":"my","name":"$array","localvar":"my","containerName":"_parse_v2_traces","kind":13,"line":478},{"definition":"my","line":479,"kind":13,"localvar":"my","containerName":"_parse_v2_traces","name":"$offset2"},{"line":479,"containerName":"_parse_v2_traces","kind":13,"name":"$offset2"},{"kind":13,"containerName":"_parse_v2_traces","name":"@read","line":479},{"name":"$offset2","kind":13,"containerName":"_parse_v2_traces","line":479},{"containerName":"_parse_v2_traces","kind":13,"name":"$traces","line":480},{"kind":13,"containerName":"_parse_v2_traces","name":"$read","line":480},{"line":480,"name":"$offset2","containerName":"_parse_v2_traces","kind":13},{"name":"$traces","containerName":"_parse_v2_traces","kind":13,"line":481}]},{"line":474,"name":"CORE","kind":12,"containerName":"length"},{"line":481,"containerName":null,"kind":13,"name":"@read"},{"line":481,"containerName":null,"kind":13,"name":"$offset2"},{"name":"%traces","kind":13,"containerName":null,"line":482},{"name":"@read","containerName":null,"kind":13,"line":482},{"line":482,"containerName":null,"kind":13,"name":"$offset2"},{"kind":13,"containerName":null,"name":"%traces","line":483},{"name":"@read","kind":13,"containerName":null,"line":483},{"kind":13,"containerName":null,"name":"$offset2","line":483},{"containerName":null,"kind":13,"name":"$traces","line":485},{"definition":"sub","containerName":"main::","name":"get_trace_deprecated_use_the_sequencetrace_object_instead","children":[],"range":{"start":{"character":0,"line":489},"end":{"character":9999,"line":498}},"kind":12,"line":489},{"definition":"sub","containerName":"main::","name":"_deprecated_get_peak_indices_deprecated_use_the_sequencetrace_object_instead","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"_deprecated_get_peak_indices_deprecated_use_the_sequencetrace_object_instead","line":501},{"definition":"my","name":"@temp","localvar":"my","containerName":"_deprecated_get_peak_indices_deprecated_use_the_sequencetrace_object_instead","kind":13,"line":502},{"name":"$self","kind":13,"containerName":"_deprecated_get_peak_indices_deprecated_use_the_sequencetrace_object_instead","line":502},{"line":503,"kind":13,"containerName":"_deprecated_get_peak_indices_deprecated_use_the_sequencetrace_object_instead","name":"@temp"}],"kind":12,"range":{"end":{"character":9999,"line":504},"start":{"character":0,"line":500}},"line":500},{"name":"get_header","containerName":"main::","children":[{"definition":"my","line":519,"name":"$self","localvar":"my","kind":13,"containerName":"get_header"},{"line":520,"containerName":"get_header","kind":13,"name":"$self"}],"definition":"sub","range":{"end":{"line":521,"character":9999},"start":{"character":0,"line":518}},"kind":12,"line":518},{"line":534,"kind":12,"range":{"end":{"line":537,"character":9999},"start":{"line":534,"character":0}},"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"get_comments","line":535,"definition":"my"},{"name":"$self","kind":13,"containerName":"get_comments","line":536}],"name":"get_comments","containerName":"main::","definition":"sub"},{"signature":{"parameters":[{"label":"$self"},{"label":"$transformed"}],"documentation":"","label":"_dump_traces_outgoing_deprecated_use_the_sequencetrace_object($self,$transformed)"},"range":{"end":{"line":544,"character":9999},"start":{"line":539,"character":0}},"kind":12,"line":539,"detail":"($self,$transformed)","definition":"sub","name":"_dump_traces_outgoing_deprecated_use_the_sequencetrace_object","containerName":"main::","children":[{"definition":"my","line":540,"kind":13,"localvar":"my","containerName":"_dump_traces_outgoing_deprecated_use_the_sequencetrace_object","name":"$self"},{"line":540,"kind":13,"containerName":"_dump_traces_outgoing_deprecated_use_the_sequencetrace_object","name":"$transformed"},{"definition":"my","line":541,"localvar":"my","kind":13,"containerName":"_dump_traces_outgoing_deprecated_use_the_sequencetrace_object","name":"@sA"},{"line":541,"name":"@sT","containerName":"_dump_traces_outgoing_deprecated_use_the_sequencetrace_object","kind":13},{"containerName":"_dump_traces_outgoing_deprecated_use_the_sequencetrace_object","kind":13,"name":"@sG","line":541},{"line":541,"containerName":"_dump_traces_outgoing_deprecated_use_the_sequencetrace_object","kind":13,"name":"@sC"},{"containerName":"_dump_traces_outgoing_deprecated_use_the_sequencetrace_object","kind":13,"name":"$transformed","line":542},{"kind":13,"containerName":"_dump_traces_outgoing_deprecated_use_the_sequencetrace_object","name":"@sA","line":543},{"line":543,"containerName":"_dump_traces_outgoing_deprecated_use_the_sequencetrace_object","kind":13,"name":"$self"},{"line":544,"name":"@sC","kind":13,"containerName":"_dump_traces_outgoing_deprecated_use_the_sequencetrace_object"},{"kind":13,"containerName":"_dump_traces_outgoing_deprecated_use_the_sequencetrace_object","name":"$self","line":544}]},{"line":545,"name":"@sG","kind":13,"containerName":null},{"name":"%self","kind":13,"containerName":null,"line":545},{"line":546,"name":"@sT","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%self","line":546},{"line":549,"name":"@sA","kind":13,"containerName":null},{"line":549,"containerName":null,"kind":13,"name":"%self"},{"name":"@sC","containerName":null,"kind":13,"line":550},{"line":550,"name":"%self","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"@sG","line":551},{"line":551,"containerName":null,"kind":13,"name":"%self"},{"line":552,"kind":13,"containerName":null,"name":"@sT"},{"containerName":null,"kind":13,"name":"%self","line":552},{"definition":"my","line":555,"name":"$curr","localvar":"my","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$curr","line":555},{"kind":13,"containerName":null,"name":"@sG","line":555},{"containerName":null,"kind":13,"name":"%curr","line":555},{"line":561,"range":{"end":{"character":9999,"line":577},"start":{"line":561,"character":0}},"kind":12,"children":[],"containerName":"main::","name":"_dump_traces_incoming_deprecated_use_the_sequencetrace_object","definition":"sub"},{"children":[{"kind":13,"localvar":"my","containerName":"write_seq","name":"$self","line":610,"definition":"my"},{"line":610,"kind":13,"containerName":"write_seq","name":"%args"},{"line":611,"containerName":"write_seq","localvar":"my","kind":13,"name":"%comments","definition":"my"},{"name":"$label","localvar":"my","containerName":"write_seq","kind":13,"line":612,"definition":"my"},{"line":612,"containerName":"write_seq","kind":13,"name":"$arg"},{"line":613,"name":"$swq","containerName":"write_seq","localvar":"my","kind":13,"definition":"my"},{"line":613,"kind":13,"containerName":"write_seq","name":"$self"},{"line":613,"kind":12,"containerName":"write_seq","name":"_rearrange"},{"line":613,"name":"%args","kind":13,"containerName":"write_seq"},{"line":614,"kind":13,"localvar":"my","containerName":"write_seq","name":"$writer_fodder","definition":"my"},{"line":615,"name":"$swq","containerName":"write_seq","kind":13},{"line":616,"name":"$swq","kind":13,"containerName":"write_seq"},{"name":"$swq","kind":13,"containerName":"write_seq","line":619},{"line":619,"containerName":"write_seq","kind":12,"name":"new"},{"line":621,"containerName":"write_seq","kind":13,"name":"$swq"},{"line":625,"name":"$self","containerName":"write_seq","kind":13},{"line":625,"kind":12,"containerName":"write_seq","name":"throw"},{"containerName":"write_seq","kind":13,"name":"$arg","line":628},{"containerName":"write_seq","kind":13,"name":"%args","line":628},{"line":629,"name":"$arg","containerName":"write_seq","kind":13},{"line":630,"name":"$label","kind":13,"containerName":"write_seq"},{"containerName":"write_seq","kind":13,"name":"$arg","line":630},{"line":631,"name":"$writer_fodder","containerName":"write_seq","kind":13},{"name":"$label","kind":13,"containerName":"write_seq","line":631},{"line":631,"kind":13,"containerName":"write_seq","name":"$args"},{"line":631,"name":"$arg","containerName":"write_seq","kind":13},{"kind":13,"containerName":"write_seq","name":"$comments","line":633},{"line":633,"containerName":"write_seq","kind":13,"name":"$comments"},{"line":633,"kind":13,"containerName":"write_seq","name":"$swq"},{"line":633,"name":"id","kind":12,"containerName":"write_seq"},{"line":635,"containerName":"write_seq","kind":13,"name":"$writer_fodder"},{"containerName":"write_seq","kind":13,"name":"$comments","line":635},{"kind":13,"containerName":"write_seq","name":"$writer_fodder","line":637},{"containerName":"write_seq","kind":13,"name":"$writer_fodder","line":638},{"line":638,"name":"$writer_fodder","kind":13,"containerName":"write_seq"},{"line":639,"containerName":"write_seq","kind":13,"name":"$self"},{"line":639,"name":"warn","kind":12,"containerName":"write_seq"},{"name":"$writer_fodder","containerName":"write_seq","kind":13,"line":640},{"line":642,"kind":13,"containerName":"write_seq","name":"$writer_fodder"},{"line":643,"name":"$writer_fodder","kind":13,"containerName":"write_seq"},{"line":646,"containerName":"write_seq","kind":13,"name":"$writer_fodder"},{"line":650,"containerName":"write_seq","kind":13,"name":"$writer_fodder"},{"line":653,"containerName":"write_seq","kind":13,"name":"$writer_fodder"},{"line":654,"kind":13,"containerName":"write_seq","name":"$writer_fodder"},{"line":655,"kind":13,"containerName":"write_seq","name":"$writer_fodder"},{"line":655,"containerName":"write_seq","kind":13,"name":"$swq"},{"line":655,"kind":12,"containerName":"write_seq","name":"seq"},{"line":656,"kind":13,"containerName":"write_seq","name":"$writer_fodder"},{"kind":13,"containerName":"write_seq","name":"$writer_fodder","line":657},{"kind":13,"containerName":"write_seq","name":"$writer_fodder","line":658},{"line":659,"kind":13,"containerName":"write_seq","name":"$writer_fodder"},{"line":660,"name":"$writer_fodder","containerName":"write_seq","kind":13}],"name":"write_seq","containerName":"main::","definition":"sub","detail":"($self,%args)","line":609,"kind":12,"range":{"end":{"character":9999,"line":660},"start":{"character":0,"line":609}},"signature":{"documentation":"__END__\n# $Id: scf.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::scf - .scf file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly. Use it via the Bio::SeqIO class, see\nL<Bio::SeqIO> for more information.\n\n=head1 DESCRIPTION\n\nThis object can transform .scf files to and from Bio::Seq::SequenceTrace\nobjects.  Mechanisms are present to retrieve trace data from scf\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chad Matsalla\n\nChad Matsalla\nbioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\nTony Cox, avc@sanger.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nNancy Hansen, nhansen at mail.nih.gov\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::scf;\nuse vars qw($DEFAULT_QUALITY);\nuse strict;\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SequenceTrace;\nuse Bio::Annotation::Comment;\nuse Dumpvalue;\n\nmy $dumper = new Dumpvalue();\n$dumper->veryCompact(1);\n\nBEGIN {\n    $DEFAULT_QUALITY= 10;\n}\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n                  (-verbose => $self->verbose(),\n                   -type => 'Bio::Seq::Quality'));\n  }\n  binmode $self->_fh; # for the Win32/Mac crowds  \n}\n\n=head2 next_seq()\n\n Title   : next_seq()\n Usage   : $scf = $stream->next_seq()\n Function: returns the next scf sequence in the stream\n Returns : a Bio::Seq::SequenceTrace object\n Args    : NONE\n Notes   : Fills the interface specification for SeqIO.\n            The SCF specification does not provide for having more then\n           one sequence in a given scf. So once the filehandle has been open\n           and passed to SeqIO do not expect to run this function more then\n           once on a given scf unless you embraced and extended the SCF\n       standard.  SCF comments are accessible through the Bio::SeqI\n           interface method annotation().\n\n\n#'\nsub next_seq {\n    my ($self) = @_;\n    my ($seq, $seqc, $fh, $buffer, $offset, $length, $read_bytes, @read,\n         %names);\n    # set up a filehandle to read in the scf\n    return if $self->{_readfile};\n    $fh = $self->_fh();\n    unless ($fh) {      # simulate the <> function\n        if ( !fileno(ARGV) or eof(ARGV) ) {\n            return unless my $ARGV = shift;\n            open(ARGV,$ARGV) or\n              $self->throw(\"Could not open $ARGV for SCF stream reading $!\");\n        }\n        $fh = \\*ARGV;\n    }\n    return unless read $fh, $buffer, 128; # no exception; probably end of file\n    # now, the master data structure will be the creator\n    my $creator;\n    # he first thing to do is parse the header. This is common\n    # among all versions of scf.\n    # the rest of the the information is different between the\n    # the different versions of scf.\n\n    $creator->{header} = $self->_get_header($buffer);\n    if ($creator->{header}->{'version'} lt \"3.00\") {\n        $self->debug(\"scf.pm is working with a version 2 scf.\\n\");\n        # first gather the trace information\n        $length = $creator->{header}->{'samples'} *\n          $creator->{header}->{sample_size}*4;\n        $buffer = $self->read_from_buffer($fh, $buffer, $length,\n                                                     $creator->{header}->{samples_offset});\n        # @read = unpack \"n$length\",$buffer;\n        # these traces need to be split\n        # returns a reference to a hash\n        $creator->{traces} = $self->_parse_v2_traces(\n                                                     $buffer,$creator->{header}->{sample_size});\n        # now go and get the base information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 12);\n        seek $fh,$offset,0;\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$creator->{header}->{bases_offset});\n        # now distill the information into its fractions.\n        # the old way : $self->_set_v2_bases($buffer);\n        # ref to an array, ref to a hash, string\n        ($creator->{peak_indices},\n         $creator->{qualities},\n         $creator->{sequence},\n         $creator->{accuracies}) = $self->_parse_v2_bases($buffer);\n\n    } else {\n        $self->debug(\"scf.pm is working with a version 3+ scf.\\n\");\n        my $transformed_read;\n        my $current_read_position = $creator->{header}->{sample_offset};\n        $length = $creator->{header}->{'samples'}*\n          $creator->{header}->{sample_size};\n        # $dumper->dumpValue($creator->{header});\n        foreach (qw(a c g t)) {\n            $buffer = $self->read_from_buffer($fh,$buffer,$length,$current_read_position);\n            my $byte = \"n\";\n            if ($creator->{header}->{sample_size} == 1) {\n                $byte = \"c\";\n            }\n            @read = unpack \"${byte}${length}\",$buffer;\n            # this little spurt of nonsense is because\n            # the trace values are given in the binary\n            # file as unsigned shorts but they really\n            # are signed deltas. 30000 is an arbitrary number\n            # (will there be any traces with a given\n            # point greater then 30000? I hope not.\n            # once the read is read, it must be changed\n            # from relative\n            foreach (@read) {\n                if ($_ > 30000) {\n                    $_ -= 65536;\n                }\n            }\n            $transformed_read = $self->_delta(\\@read,\"backward\");\n            # For 8-bit data we need to emulate a signed/unsigned\n            # cast that is implicit in the C implementations.....\n            if ($creator->{header}->{sample_size} == 1) {\n                foreach (@{$transformed_read}) {\n                    $_ += 256 if ($_ < 0);\n                }\n            }\n            $current_read_position += $length;\n            $creator->{'traces'}->{$_} = join(' ',@{$transformed_read});\n        }\n        \n        # now go and get the peak index information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 4);\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{peak_indices} = $self->_get_v3_peak_indices($buffer);\n        $offset += $length;\n        # now go and get the accuracy information\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{accuracies} = $self->_get_v3_base_accuracies($buffer);\n        # OK, now go and get the base information.\n        $offset += $length;\n        $length = $creator->{header}->{bases};\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{'sequence'} = unpack(\"a$length\",$buffer);\n        # now, finally, extract the calls from the accuracy information.\n        $creator->{qualities} = $self->_get_v3_quality(\n                                              $creator->{'sequence'},$creator->{accuracies});\n    }\n    # now go and get the comment information\n    $offset = $creator->{header}->{comments_offset};\n    seek $fh,$offset,0;\n    $length = $creator->{header}->{comment_size};\n    $buffer = $self->read_from_buffer($fh,$buffer,$length);\n    $creator->{comments} = $self->_get_comments($buffer);\n    my @name_comments = grep {$_->tagname() eq 'NAME'}\n                $creator->{comments}->get_Annotations('comment');\n    my $name_comment;\n    if (@name_comments){\n         $name_comment = $name_comments[0]->as_text();\n         $name_comment =~ s/^Comment:\\s+//;\n    }\n\n    my $swq = Bio::Seq::Quality->new(\n        -seq  =>   $creator->{'sequence'},\n        -qual =>    $creator->{'qualities'},\n        -id   =>    $name_comment\n                                              );\n    my $returner = Bio::Seq::SequenceTrace->new(\n                                           -swq      =>   $swq,\n                                            -trace_a  =>   $creator->{'traces'}->{'a'},\n                                            -trace_t  =>   $creator->{'traces'}->{'t'},\n                                           -trace_g  =>   $creator->{'traces'}->{'g'},\n                                           -trace_c  =>   $creator->{'traces'}->{'c'},\n                                       -accuracy_a    => $creator->{'accuracies'}->{'a'},\n                                   -accuracy_t    => $creator->{'accuracies'}->{'t'},\n                                      -accuracy_g    => $creator->{'accuracies'}->{'g'},\n                                    -accuracy_c    => $creator->{'accuracies'}->{'c'},\n                                 -peak_indices  => $creator->{'peak_indices'}\n                                                             );\n\n        $returner->annotation($creator->{'comments'}); # add SCF comments\n    $self->{'_readfile'} = 1;\n    return $returner;\n}\n\n\n=head2 _get_v3_quality()\n\n Title   : _get_v3_quality()\n Usage   : $self->_get_v3_quality()\n Function: Set the base qualities from version3 scf\n Returns : Nothing. Alters $self.\n Args    : None.\n Notes   :\n\n\n#'\nsub _get_v3_quality {\n    my ($self,$sequence,$accuracies) = @_;\n    my @bases = split//,$sequence;\n    my (@qualities,$currbase,$currqual,$counter);\n    for ($counter=0; $counter <= $#bases ; $counter++) {\n    $currbase = lc($bases[$counter]);\n    if ($currbase eq \"a\") { $currqual = $accuracies->{'a'}->[$counter]; }\n    elsif ($currbase eq \"c\") { $currqual = $accuracies->{'c'}->[$counter]; }\n    elsif ($currbase eq \"g\") { $currqual = $accuracies->{'g'}->[$counter]; }\n    elsif ($currbase eq \"t\") { $currqual = $accuracies->{'t'}->[$counter]; }\n    else { $currqual = \"unknown\"; }\n    push @qualities,$currqual;\n    }\n    return \\@qualities;\n}\n\n=head2 _get_v3_peak_indices($buffer)\n\n Title   : _get_v3_peak_indices($buffer)\n Usage   : $self->_get_v3_peak_indices($buffer);\n Function: Unpacks the base accuracies for version3 scf\n Returns : Nothing. Alters $self\n Args    : A scalar containing binary data.\n Notes   :\n\n\nsub _get_v3_peak_indices {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my @read = unpack \"N$length\",$buffer;\n     return join(' ',@read);\n}\n\n=head2 _get_v3_base_accuracies($buffer)\n\n Title   : _get_v3_base_accuracies($buffer)\n Usage   : $self->_get_v3_base_accuracies($buffer)\n Function: Set the base accuracies for version 3 scf's\n Returns : Nothing. Alters $self.\n Args    : A scalar containing binary data.\n Notes   :\n\n\n#'\nsub _get_v3_base_accuracies {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my $qlength = $length/4;\n    my $offset = 0;\n    my (@qualities,@sorter,$counter,$round,$last_base,$accuracies,$currbase);\n    foreach $currbase (qw(a c g t)) {\n         my @read;\n         $last_base = $offset + $qlength;\n         for (;$offset < $last_base; $offset += $qlength) {\n                    # a bioperler (perhaps me?) changed the unpack string to include 'n' rather than 'C'\n                    # on 040322 I think that 'C' is correct. please email chad if you would like to accuse me of being incorrect\n              @read = unpack \"C$qlength\", substr($buffer,$offset,$qlength);\n              $accuracies->{$currbase} = \\@read;\n         }\n    }\n     return $accuracies;\n}\n\n\n=head2 _get_comments($buffer)\n\n Title   : _get_comments($buffer)\n Usage   : $self->_get_comments($buffer);\n Function: Gather the comments section from the scf and parse it into its\n            components.\n Returns : a Bio::Annotation::Collection object\n Args    : The buffer. It is expected that the buffer contains a binary\n            string for the comments section of an scf file according to\n            the scf file specifications.\n Notes   :\n\n\nsub _get_comments {\n    my ($self,$buffer) = @_;\n    my $comments = Bio::Annotation::Collection->new();\n    my $size = length($buffer);\n    my $comments_retrieved = unpack \"a$size\",$buffer;\n    $comments_retrieved =~ s/\\0//;\n    my @comments_split = split/\\n/,$comments_retrieved;\n    if (@comments_split) {\n        foreach (@comments_split) {\n            /(\\w+)=(.*)/;\n            if ($1 && $2) {\n                my ($tagname, $text) = ($1, $2);\n                my $comment_obj = Bio::Annotation::Comment->new(\n                                     -text => $text,\n                                     -tagname => $tagname);\n\n                $comments->add_Annotation('comment', $comment_obj);\n            }\n        }\n    }\n    $self->{'comments'} = $comments;\n    return $comments;\n}\n\n=head2 _get_header()\n\n Title   : _get_header($buffer)\n Usage   : $self->_get_header($buffer);\n Function: Gather the header section from the scf and parse it into its\n           components.\n Returns : Reference to a hash containing the header components.\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the header section of an scf file according to the\n           scf file specifications.\n Notes   : None.\n\n\nsub _get_header {\n    my ($self,$buffer) = @_;\n    my $header;\n    ($header->{'scf'},\n     $header->{'samples'},\n     $header->{'sample_offset'},\n     $header->{'bases'},\n     $header->{'bases_left_clip'},\n     $header->{'bases_right_clip'},\n     $header->{'bases_offset'},\n     $header->{'comment_size'},\n     $header->{'comments_offset'},\n     $header->{'version'},\n     $header->{'sample_size'},\n     $header->{'code_set'},\n     @{$header->{'header_spare'}} ) = unpack \"a4 NNNNNNNN a4 NN N20\", $buffer;\n\n    $self->{'header'} = $header;\n    return $header;\n}\n\n=head2 _parse_v2_bases($buffer)\n\n Title   : _parse_v2_bases($buffer)\n Usage   : $self->_parse_v2_bases($buffer);\n Function: Gather the bases section from the scf and parse it into its\n           components.\n Returns :\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the bases section of an scf file according to the\n           scf file specifications.\n Notes   : None.\n\n\nsub _parse_v2_bases {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my ($offset2,$currbuff,$currbase,$currqual,$sequence,@qualities,@indices);\n    my (@read,$harvester,$accuracies);\n    for ($offset2=0;$offset2<$length;$offset2+=12) {\n         @read = unpack \"N C C C C a C3\", substr($buffer,$offset2,$length);\n         push @indices,$read[0];\n         $currbase = lc($read[5]);\n         if ($currbase eq \"a\") { $currqual = $read[1]; }\n         elsif ($currbase eq \"c\") { $currqual = $read[2]; }\n         elsif ($currbase eq \"g\") { $currqual = $read[3]; }\n         elsif ($currbase eq \"t\") { $currqual = $read[4]; }\n         else { $currqual = \"UNKNOWN\"; }\n         push @{$accuracies->{\"a\"}},$read[1];\n         push @{$accuracies->{\"c\"}},$read[2];\n         push @{$accuracies->{\"g\"}},$read[3];\n         push @{$accuracies->{\"t\"}},$read[4];\n\n         $sequence .= $currbase;\n         push @qualities,$currqual;\n    }\n     return (\\@indices,\\@qualities,$sequence,$accuracies)\n}\n\n=head2 _parse_v2_traces(\\@traces_array)\n\n Title   : _pares_v2_traces(\\@traces_array)\n Usage   : $self->_parse_v2_traces(\\@traces_array);\n Function: Parses an scf Version2 trace array into its base components.\n Returns : Nothing. Modifies $self.\n Args    : A reference to an array of the unpacked traces section of an\n           scf version2 file.\n\n\nsub _parse_v2_traces {\n    my ($self,$buffer,$sample_size) = @_;\n     my $byte;\n     if ($sample_size == 1) { $byte = \"c\"; }\n     else { $byte = \"n\"; }\n     my $length = CORE::length($buffer);\n     my @read = unpack \"${byte}${length}\",$buffer;\n          # this will be an array to the reference holding the array\n     my $traces;\n     my $array = 0;\n     for (my $offset2 = 0; $offset2< scalar(@read); $offset2+=4) {\n              push @{$traces->{'a'}},$read[$offset2];\n              push @{$traces->{'t'}},$read[$offset2+1];\n              push @{$traces->{'g'}},$read[$offset2+3];\n              push @{$traces->{'c'}},$read[$offset2+2];\n    }\n    return $traces;\n}\n\n\nsub get_trace_deprecated_use_the_sequencetrace_object_instead {\n    # my ($self,$base_channel,$traces) = @_;\n    # $base_channel =~ tr/a-z/A-Z/;\n    # if ($base_channel !~ /A|T|G|C/) {\n    #   $self->throw(\"You tried to ask for a base channel that wasn't A,T,G, or C. Ask for one of those next time.\");\n    ##} elsif ($base_channel) {\n     #  my @temp = split(' ',$self->{'traces'}->{$base_channel});\n    #return \\@temp;\n    #}\n}\n\nsub _deprecated_get_peak_indices_deprecated_use_the_sequencetrace_object_instead {\n    my ($self) = shift;\n    my @temp = split(' ',$self->{'parsed'}->{'peak_indices'});\n    return \\@temp;\n}\n\n\n=head2 get_header()\n\n Title   : get_header()\n Usage   : %header = %{$obj->get_header()};\n Function: Return the header for this scf.\n Returns : A reference to a hash containing the header for this scf.\n Args    : None.\n Notes   :\n\n\nsub get_header {\n    my ($self) = shift;\n    return $self->{'header'};\n}\n\n=head2 get_comments()\n\n Title   : get_comments()\n Usage   : %comments = %{$obj->get_comments()};\n Function: Return the comments for this scf.\n Returns : A Bio::Annotation::Collection object\n Args    : None.\n Notes   :\n\n\nsub get_comments {\n    my ($self) = shift;\n    return $self->{'comments'};\n}\n\nsub _dump_traces_outgoing_deprecated_use_the_sequencetrace_object {\n    my ($self,$transformed) = @_;\n    my (@sA,@sT,@sG,@sC);\n    if ($transformed) {\n    @sA = @{$self->{'text'}->{'t_samples_a'}};\n    @sC = @{$self->{'text'}->{'t_samples_c'}};\n    @sG = @{$self->{'text'}->{'t_samples_g'}};\n    @sT = @{$self->{'text'}->{'t_samples_t'}};\n    }\n    else {\n    @sA = @{$self->{'text'}->{'samples_a'}};\n    @sC = @{$self->{'text'}->{'samples_c'}};\n    @sG = @{$self->{'text'}->{'samples_g'}};\n    @sT = @{$self->{'text'}->{'samples_t'}};\n    }\n    print (\"Count\\ta\\tc\\tg\\tt\\n\");\n    for (my $curr=0; $curr < scalar(@sG); $curr++) {\n    print(\"$curr\\t$sA[$curr]\\t$sC[$curr]\\t$sG[$curr]\\t$sT[$curr]\\n\");\n    }\n    return;\n}\n\nsub _dump_traces_incoming_deprecated_use_the_sequencetrace_object {\n    # my ($self) = @_;\n    # my (@sA,@sT,@sG,@sC);\n    # @sA = @{$self->{'traces'}->{'A'}};\n    # @sC = @{$self->{'traces'}->{'C'}};\n    # @sG = @{$self->{'traces'}->{'G'}};\n    # @sT = @{$self->{'traces'}->{'T'}};\n    # @sA = @{$self->get_trace('A')};\n    # @sC = @{$self->get_trace('C')};\n    # @sG = @{$self->get_trace('G')};\n    # @sT = @{$self->get_trace('t')};\n    # print (\"Count\\ta\\tc\\tg\\tt\\n\");\n    # for (my $curr=0; $curr < scalar(@sG); $curr++) {\n    #   print(\"$curr\\t$sA[$curr]\\t$sC[$curr]\\t$sG[$curr]\\t$sT[$curr]\\n\");\n    #}\n    #return;\n}\n\n=head2 write_seq\n\n Title   : write_seq(-target => $swq, <comments>)\n Usage   : $obj->write_seq(\n               -target => $swq,\n            -version => 2,\n            -CONV => \"Bioperl-Chads Mighty SCF writer.\");\n Function: Write out an scf.\n Returns : Nothing.\n Args    : Requires: a reference to a Bio::Seq::Quality object to form the\n           basis for the scf.\n       if -version is provided, it should be \"2\" or \"3\". A SCF of that\n       version will be written.\n       Any other arguments are assumed to be comments and are put into\n       the comments section of the scf. Read the specifications for scf\n       to decide what might be good to put in here.\n\n Notes   :\n          For best results, use a SequenceTrace object.\n          The things that you need to write an scf:\n          a) sequence\n          b) quality\n          c) peak indices\n          d) traces\n          - You _can_ write an scf with just a and b by passing in a\n               Bio::Seq::Quality object- false traces will be synthesized\n               for you.","parameters":[{"label":"$self"},{"label":"%args"}],"label":"write_seq($self,%args)"}},{"name":"Bio","kind":12,"containerName":"Seq::SequenceTrace","line":619},{"line":631,"name":"comments","kind":12},{"line":635,"kind":12,"name":"comments"},{"kind":12,"name":"comments","line":637},{"kind":12,"name":"version","line":637},{"name":"comments","kind":12,"line":638},{"kind":12,"name":"version","line":638},{"name":"comments","kind":12,"line":638},{"kind":12,"name":"version","line":638},{"name":"header","kind":12,"line":640},{"name":"version","kind":12,"line":640},{"line":642,"kind":12,"name":"comments"},{"line":643,"kind":12,"name":"header"},{"kind":12,"name":"header","line":646},{"line":646,"name":"version","kind":12},{"kind":12,"name":"header","line":650},{"line":662,"containerName":null,"kind":13,"name":"%writer_fodder"},{"line":663,"containerName":null,"kind":13,"name":"%writer_fodder"},{"name":"$swq","containerName":null,"kind":13,"line":663},{"kind":12,"containerName":"main::","name":"trace_length","line":663},{"line":665,"name":"%writer_fodder","containerName":null,"kind":13},{"name":"comments","kind":12,"line":665},{"name":"$self","kind":13,"containerName":null,"line":665},{"line":665,"name":"_get_binary_comments","kind":12,"containerName":"main::"},{"containerName":null,"kind":13,"name":"%writer_fodder","line":666},{"kind":12,"name":"comments","line":666},{"line":669,"name":"%writer_fodder","kind":13,"containerName":null},{"line":669,"name":"traces","kind":12},{"containerName":null,"kind":13,"name":"$self","line":669},{"line":669,"kind":12,"containerName":"main::","name":"_get_binary_traces"},{"containerName":null,"kind":13,"name":"%writer_fodder","line":670},{"line":671,"containerName":null,"kind":13,"name":"$swq"},{"line":671,"containerName":null,"kind":13,"name":"%writer_fodder"},{"line":672,"containerName":null,"localvar":"my","kind":13,"name":"$b_base_offsets","definition":"my"},{"line":672,"name":"$b_base_accuracies","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$samples_size","line":672},{"line":672,"name":"$bases_size","kind":13,"containerName":null},{"line":676,"name":"%writer_fodder","kind":13,"containerName":null},{"line":677,"kind":13,"containerName":null,"name":"%writer_fodder"},{"line":677,"name":"bases","kind":12},{"line":677,"containerName":null,"kind":13,"name":"$self"},{"kind":12,"containerName":"main::","name":"_get_binary_bases","line":677},{"line":679,"name":"$swq","kind":13,"containerName":null},{"name":"%writer_fodder","kind":13,"containerName":null,"line":680},{"containerName":null,"kind":13,"name":"$samples_size","line":681},{"name":"CORE","containerName":"length","kind":12,"line":681},{"line":681,"containerName":null,"kind":13,"name":"%writer_fodder"},{"kind":12,"name":"traces","line":681},{"line":682,"kind":13,"containerName":null,"name":"$bases_size"},{"line":682,"name":"CORE","containerName":"length","kind":12},{"line":682,"containerName":null,"kind":13,"name":"%writer_fodder"},{"kind":12,"name":"bases","line":682},{"line":682,"kind":12,"name":"binary"},{"line":683,"name":"%writer_fodder","containerName":null,"kind":13},{"line":683,"name":"$samples_size","kind":13,"containerName":null},{"line":684,"name":"%writer_fodder","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$samples_size","line":685},{"line":685,"kind":13,"containerName":null,"name":"$bases_size"},{"line":686,"name":"%writer_fodder","kind":13,"containerName":null},{"line":687,"containerName":null,"kind":13,"name":"%writer_fodder"},{"kind":12,"name":"binary","line":687},{"kind":13,"containerName":null,"name":"%writer_fodder","line":688},{"containerName":null,"kind":13,"name":"%writer_fodder","line":689},{"line":690,"name":"$samples_size","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$bases_size","line":690},{"line":691,"name":"%writer_fodder","containerName":null,"kind":13},{"name":"%writer_fodder","containerName":null,"kind":13,"line":692},{"line":693,"kind":13,"containerName":null,"name":"$self"},{"line":693,"containerName":"main::","kind":12,"name":"_get_binary_header"},{"line":693,"kind":13,"containerName":null,"name":"%writer_fodder"},{"line":693,"name":"header","kind":12},{"line":694,"name":"$dumper","containerName":null,"kind":13},{"line":694,"kind":12,"containerName":"main::","name":"dumpValue"},{"line":694,"containerName":null,"kind":13,"name":"$writer_fodder"},{"name":"$self","kind":13,"containerName":null,"line":694},{"line":694,"kind":12,"containerName":"main::","name":"verbose"},{"name":"$self","containerName":null,"kind":13,"line":695},{"line":695,"containerName":"main::","kind":12,"name":"_print"},{"line":695,"containerName":null,"kind":13,"name":"%writer_fodder"},{"kind":13,"containerName":null,"name":"$self","line":697},{"name":"_print","kind":12,"containerName":"main::","line":697},{"name":"%writer_fodder","containerName":null,"kind":13,"line":697},{"line":699,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"containerName":"main::","name":"_print","line":699},{"kind":13,"containerName":null,"name":"%writer_fodder","line":699},{"line":701,"name":"$self","kind":13,"containerName":null},{"name":"_print","kind":12,"containerName":"main::","line":701},{"containerName":null,"kind":13,"name":"%writer_fodder","line":701},{"line":705,"containerName":null,"kind":13,"name":"%writer_fodder"},{"kind":12,"name":"peak_indices","line":705},{"containerName":null,"kind":13,"name":"%writer_fodder","line":706},{"kind":12,"name":"accuracies","line":706},{"line":707,"containerName":null,"kind":13,"name":"%writer_fodder"},{"line":707,"kind":12,"name":"bases"},{"kind":13,"containerName":null,"name":"%writer_fodder","line":708},{"name":"reserved","kind":12,"line":708},{"containerName":null,"kind":13,"name":"$self","line":709},{"line":709,"name":"_get_binary_bases","kind":12,"containerName":"main::"},{"kind":13,"containerName":null,"name":"$swq","line":711},{"name":"%writer_fodder","containerName":null,"kind":13,"line":712},{"line":714,"kind":13,"containerName":null,"name":"%writer_fodder"},{"name":"%writer_fodder","containerName":null,"kind":13,"line":715},{"line":716,"name":"%writer_fodder","kind":13,"containerName":null},{"line":717,"containerName":null,"kind":13,"name":"%writer_fodder"},{"containerName":null,"kind":13,"name":"%writer_fodder","line":721},{"name":"%writer_fodder","containerName":null,"kind":13,"line":723},{"line":724,"name":"%writer_fodder","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%writer_fodder","line":725},{"kind":13,"containerName":null,"name":"%writer_fodder","line":726},{"kind":13,"containerName":null,"name":"%writer_fodder","line":727},{"line":728,"kind":13,"containerName":null,"name":"%writer_fodder"},{"kind":13,"containerName":null,"name":"%writer_fodder","line":729},{"line":730,"name":"%writer_fodder","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"%writer_fodder","line":731},{"name":"%writer_fodder","kind":13,"containerName":null,"line":732},{"kind":13,"containerName":null,"name":"%writer_fodder","line":733},{"line":734,"name":"%writer_fodder","kind":13,"containerName":null},{"line":735,"containerName":null,"kind":13,"name":"%writer_fodder"},{"line":735,"kind":12,"name":"header"},{"line":735,"name":"binary","kind":12},{"line":736,"name":"$self","containerName":null,"kind":13},{"containerName":"main::","kind":12,"name":"_get_binary_header","line":736},{"line":736,"name":"%writer_fodder","kind":13,"containerName":null},{"name":"header","kind":12,"line":736},{"containerName":null,"kind":13,"name":"$self","line":737},{"containerName":"main::","kind":12,"name":"_print","line":737},{"containerName":null,"kind":13,"name":"%writer_fodder","line":737},{"kind":13,"containerName":null,"name":"$self","line":739},{"name":"_print","containerName":"main::","kind":12,"line":739},{"name":"%writer_fodder","containerName":null,"kind":13,"line":739},{"line":741,"name":"$self","kind":13,"containerName":null},{"kind":12,"containerName":"main::","name":"_print","line":741},{"line":741,"containerName":null,"kind":13,"name":"%writer_fodder"},{"name":"$self","kind":13,"containerName":null,"line":743},{"line":743,"name":"_print","containerName":"main::","kind":12},{"line":743,"kind":13,"containerName":null,"name":"%writer_fodder"},{"kind":13,"containerName":null,"name":"$self","line":745},{"name":"_print","containerName":"main::","kind":12,"line":745},{"line":745,"name":"%writer_fodder","containerName":null,"kind":13},{"line":747,"name":"$self","kind":13,"containerName":null},{"line":747,"containerName":"main::","kind":12,"name":"_print"},{"name":"%writer_fodder","kind":13,"containerName":null,"line":747},{"containerName":null,"kind":13,"name":"$self","line":749},{"kind":12,"containerName":"main::","name":"_print","line":749},{"name":"%writer_fodder","containerName":null,"kind":13,"line":749},{"line":755,"kind":13,"containerName":null,"name":"$self"},{"line":755,"kind":12,"containerName":"main::","name":"flush"},{"line":755,"containerName":null,"kind":13,"name":"$self"},{"containerName":"main::","kind":12,"name":"_flush_on_write","line":755},{"line":755,"containerName":null,"kind":13,"name":"$self"},{"line":755,"kind":12,"containerName":"main::","name":"_fh"},{"line":757,"kind":13,"containerName":null,"name":"$self"},{"line":757,"name":"close","containerName":"main::","kind":12},{"containerName":"main::","name":"_get_binary_header","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"_get_binary_header","line":779,"definition":"my"},{"name":"$header","kind":13,"containerName":"_get_binary_header","line":779},{"line":780,"localvar":"my","kind":13,"containerName":"_get_binary_header","name":"$binary","definition":"my"},{"line":782,"name":"$header","kind":13,"containerName":"_get_binary_header"},{"line":783,"name":"$header","kind":13,"containerName":"_get_binary_header"},{"name":"$header","containerName":"_get_binary_header","kind":13,"line":784},{"line":785,"name":"$header","kind":13,"containerName":"_get_binary_header"},{"line":786,"name":"$header","containerName":"_get_binary_header","kind":13},{"line":787,"name":"$header","kind":13,"containerName":"_get_binary_header"},{"line":788,"containerName":"_get_binary_header","kind":13,"name":"$header"},{"containerName":"_get_binary_header","kind":13,"name":"$header","line":789},{"line":790,"containerName":"_get_binary_header","kind":13,"name":"$header"},{"line":791,"containerName":"_get_binary_header","kind":13,"name":"$header"},{"line":792,"name":"$header","kind":13,"containerName":"_get_binary_header"},{"kind":13,"containerName":"_get_binary_header","name":"$header","line":793},{"line":794,"name":"$header","kind":13,"containerName":"_get_binary_header"}],"detail":"($self,$header)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":794},"start":{"character":0,"line":778}},"line":778,"signature":{"parameters":[{"label":"$self"},{"label":"$header"}],"documentation":"__END__\n# $Id: scf.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::scf - .scf file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly. Use it via the Bio::SeqIO class, see\nL<Bio::SeqIO> for more information.\n\n=head1 DESCRIPTION\n\nThis object can transform .scf files to and from Bio::Seq::SequenceTrace\nobjects.  Mechanisms are present to retrieve trace data from scf\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chad Matsalla\n\nChad Matsalla\nbioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\nTony Cox, avc@sanger.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nNancy Hansen, nhansen at mail.nih.gov\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::scf;\nuse vars qw($DEFAULT_QUALITY);\nuse strict;\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SequenceTrace;\nuse Bio::Annotation::Comment;\nuse Dumpvalue;\n\nmy $dumper = new Dumpvalue();\n$dumper->veryCompact(1);\n\nBEGIN {\n    $DEFAULT_QUALITY= 10;\n}\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n                  (-verbose => $self->verbose(),\n                   -type => 'Bio::Seq::Quality'));\n  }\n  binmode $self->_fh; # for the Win32/Mac crowds  \n}\n\n=head2 next_seq()\n\n Title   : next_seq()\n Usage   : $scf = $stream->next_seq()\n Function: returns the next scf sequence in the stream\n Returns : a Bio::Seq::SequenceTrace object\n Args    : NONE\n Notes   : Fills the interface specification for SeqIO.\n            The SCF specification does not provide for having more then\n           one sequence in a given scf. So once the filehandle has been open\n           and passed to SeqIO do not expect to run this function more then\n           once on a given scf unless you embraced and extended the SCF\n       standard.  SCF comments are accessible through the Bio::SeqI\n           interface method annotation().\n\n\n#'\nsub next_seq {\n    my ($self) = @_;\n    my ($seq, $seqc, $fh, $buffer, $offset, $length, $read_bytes, @read,\n         %names);\n    # set up a filehandle to read in the scf\n    return if $self->{_readfile};\n    $fh = $self->_fh();\n    unless ($fh) {      # simulate the <> function\n        if ( !fileno(ARGV) or eof(ARGV) ) {\n            return unless my $ARGV = shift;\n            open(ARGV,$ARGV) or\n              $self->throw(\"Could not open $ARGV for SCF stream reading $!\");\n        }\n        $fh = \\*ARGV;\n    }\n    return unless read $fh, $buffer, 128; # no exception; probably end of file\n    # now, the master data structure will be the creator\n    my $creator;\n    # he first thing to do is parse the header. This is common\n    # among all versions of scf.\n    # the rest of the the information is different between the\n    # the different versions of scf.\n\n    $creator->{header} = $self->_get_header($buffer);\n    if ($creator->{header}->{'version'} lt \"3.00\") {\n        $self->debug(\"scf.pm is working with a version 2 scf.\\n\");\n        # first gather the trace information\n        $length = $creator->{header}->{'samples'} *\n          $creator->{header}->{sample_size}*4;\n        $buffer = $self->read_from_buffer($fh, $buffer, $length,\n                                                     $creator->{header}->{samples_offset});\n        # @read = unpack \"n$length\",$buffer;\n        # these traces need to be split\n        # returns a reference to a hash\n        $creator->{traces} = $self->_parse_v2_traces(\n                                                     $buffer,$creator->{header}->{sample_size});\n        # now go and get the base information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 12);\n        seek $fh,$offset,0;\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$creator->{header}->{bases_offset});\n        # now distill the information into its fractions.\n        # the old way : $self->_set_v2_bases($buffer);\n        # ref to an array, ref to a hash, string\n        ($creator->{peak_indices},\n         $creator->{qualities},\n         $creator->{sequence},\n         $creator->{accuracies}) = $self->_parse_v2_bases($buffer);\n\n    } else {\n        $self->debug(\"scf.pm is working with a version 3+ scf.\\n\");\n        my $transformed_read;\n        my $current_read_position = $creator->{header}->{sample_offset};\n        $length = $creator->{header}->{'samples'}*\n          $creator->{header}->{sample_size};\n        # $dumper->dumpValue($creator->{header});\n        foreach (qw(a c g t)) {\n            $buffer = $self->read_from_buffer($fh,$buffer,$length,$current_read_position);\n            my $byte = \"n\";\n            if ($creator->{header}->{sample_size} == 1) {\n                $byte = \"c\";\n            }\n            @read = unpack \"${byte}${length}\",$buffer;\n            # this little spurt of nonsense is because\n            # the trace values are given in the binary\n            # file as unsigned shorts but they really\n            # are signed deltas. 30000 is an arbitrary number\n            # (will there be any traces with a given\n            # point greater then 30000? I hope not.\n            # once the read is read, it must be changed\n            # from relative\n            foreach (@read) {\n                if ($_ > 30000) {\n                    $_ -= 65536;\n                }\n            }\n            $transformed_read = $self->_delta(\\@read,\"backward\");\n            # For 8-bit data we need to emulate a signed/unsigned\n            # cast that is implicit in the C implementations.....\n            if ($creator->{header}->{sample_size} == 1) {\n                foreach (@{$transformed_read}) {\n                    $_ += 256 if ($_ < 0);\n                }\n            }\n            $current_read_position += $length;\n            $creator->{'traces'}->{$_} = join(' ',@{$transformed_read});\n        }\n        \n        # now go and get the peak index information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 4);\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{peak_indices} = $self->_get_v3_peak_indices($buffer);\n        $offset += $length;\n        # now go and get the accuracy information\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{accuracies} = $self->_get_v3_base_accuracies($buffer);\n        # OK, now go and get the base information.\n        $offset += $length;\n        $length = $creator->{header}->{bases};\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{'sequence'} = unpack(\"a$length\",$buffer);\n        # now, finally, extract the calls from the accuracy information.\n        $creator->{qualities} = $self->_get_v3_quality(\n                                              $creator->{'sequence'},$creator->{accuracies});\n    }\n    # now go and get the comment information\n    $offset = $creator->{header}->{comments_offset};\n    seek $fh,$offset,0;\n    $length = $creator->{header}->{comment_size};\n    $buffer = $self->read_from_buffer($fh,$buffer,$length);\n    $creator->{comments} = $self->_get_comments($buffer);\n    my @name_comments = grep {$_->tagname() eq 'NAME'}\n                $creator->{comments}->get_Annotations('comment');\n    my $name_comment;\n    if (@name_comments){\n         $name_comment = $name_comments[0]->as_text();\n         $name_comment =~ s/^Comment:\\s+//;\n    }\n\n    my $swq = Bio::Seq::Quality->new(\n        -seq  =>   $creator->{'sequence'},\n        -qual =>    $creator->{'qualities'},\n        -id   =>    $name_comment\n                                              );\n    my $returner = Bio::Seq::SequenceTrace->new(\n                                           -swq      =>   $swq,\n                                            -trace_a  =>   $creator->{'traces'}->{'a'},\n                                            -trace_t  =>   $creator->{'traces'}->{'t'},\n                                           -trace_g  =>   $creator->{'traces'}->{'g'},\n                                           -trace_c  =>   $creator->{'traces'}->{'c'},\n                                       -accuracy_a    => $creator->{'accuracies'}->{'a'},\n                                   -accuracy_t    => $creator->{'accuracies'}->{'t'},\n                                      -accuracy_g    => $creator->{'accuracies'}->{'g'},\n                                    -accuracy_c    => $creator->{'accuracies'}->{'c'},\n                                 -peak_indices  => $creator->{'peak_indices'}\n                                                             );\n\n        $returner->annotation($creator->{'comments'}); # add SCF comments\n    $self->{'_readfile'} = 1;\n    return $returner;\n}\n\n\n=head2 _get_v3_quality()\n\n Title   : _get_v3_quality()\n Usage   : $self->_get_v3_quality()\n Function: Set the base qualities from version3 scf\n Returns : Nothing. Alters $self.\n Args    : None.\n Notes   :\n\n\n#'\nsub _get_v3_quality {\n    my ($self,$sequence,$accuracies) = @_;\n    my @bases = split//,$sequence;\n    my (@qualities,$currbase,$currqual,$counter);\n    for ($counter=0; $counter <= $#bases ; $counter++) {\n    $currbase = lc($bases[$counter]);\n    if ($currbase eq \"a\") { $currqual = $accuracies->{'a'}->[$counter]; }\n    elsif ($currbase eq \"c\") { $currqual = $accuracies->{'c'}->[$counter]; }\n    elsif ($currbase eq \"g\") { $currqual = $accuracies->{'g'}->[$counter]; }\n    elsif ($currbase eq \"t\") { $currqual = $accuracies->{'t'}->[$counter]; }\n    else { $currqual = \"unknown\"; }\n    push @qualities,$currqual;\n    }\n    return \\@qualities;\n}\n\n=head2 _get_v3_peak_indices($buffer)\n\n Title   : _get_v3_peak_indices($buffer)\n Usage   : $self->_get_v3_peak_indices($buffer);\n Function: Unpacks the base accuracies for version3 scf\n Returns : Nothing. Alters $self\n Args    : A scalar containing binary data.\n Notes   :\n\n\nsub _get_v3_peak_indices {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my @read = unpack \"N$length\",$buffer;\n     return join(' ',@read);\n}\n\n=head2 _get_v3_base_accuracies($buffer)\n\n Title   : _get_v3_base_accuracies($buffer)\n Usage   : $self->_get_v3_base_accuracies($buffer)\n Function: Set the base accuracies for version 3 scf's\n Returns : Nothing. Alters $self.\n Args    : A scalar containing binary data.\n Notes   :\n\n\n#'\nsub _get_v3_base_accuracies {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my $qlength = $length/4;\n    my $offset = 0;\n    my (@qualities,@sorter,$counter,$round,$last_base,$accuracies,$currbase);\n    foreach $currbase (qw(a c g t)) {\n         my @read;\n         $last_base = $offset + $qlength;\n         for (;$offset < $last_base; $offset += $qlength) {\n                    # a bioperler (perhaps me?) changed the unpack string to include 'n' rather than 'C'\n                    # on 040322 I think that 'C' is correct. please email chad if you would like to accuse me of being incorrect\n              @read = unpack \"C$qlength\", substr($buffer,$offset,$qlength);\n              $accuracies->{$currbase} = \\@read;\n         }\n    }\n     return $accuracies;\n}\n\n\n=head2 _get_comments($buffer)\n\n Title   : _get_comments($buffer)\n Usage   : $self->_get_comments($buffer);\n Function: Gather the comments section from the scf and parse it into its\n            components.\n Returns : a Bio::Annotation::Collection object\n Args    : The buffer. It is expected that the buffer contains a binary\n            string for the comments section of an scf file according to\n            the scf file specifications.\n Notes   :\n\n\nsub _get_comments {\n    my ($self,$buffer) = @_;\n    my $comments = Bio::Annotation::Collection->new();\n    my $size = length($buffer);\n    my $comments_retrieved = unpack \"a$size\",$buffer;\n    $comments_retrieved =~ s/\\0//;\n    my @comments_split = split/\\n/,$comments_retrieved;\n    if (@comments_split) {\n        foreach (@comments_split) {\n            /(\\w+)=(.*)/;\n            if ($1 && $2) {\n                my ($tagname, $text) = ($1, $2);\n                my $comment_obj = Bio::Annotation::Comment->new(\n                                     -text => $text,\n                                     -tagname => $tagname);\n\n                $comments->add_Annotation('comment', $comment_obj);\n            }\n        }\n    }\n    $self->{'comments'} = $comments;\n    return $comments;\n}\n\n=head2 _get_header()\n\n Title   : _get_header($buffer)\n Usage   : $self->_get_header($buffer);\n Function: Gather the header section from the scf and parse it into its\n           components.\n Returns : Reference to a hash containing the header components.\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the header section of an scf file according to the\n           scf file specifications.\n Notes   : None.\n\n\nsub _get_header {\n    my ($self,$buffer) = @_;\n    my $header;\n    ($header->{'scf'},\n     $header->{'samples'},\n     $header->{'sample_offset'},\n     $header->{'bases'},\n     $header->{'bases_left_clip'},\n     $header->{'bases_right_clip'},\n     $header->{'bases_offset'},\n     $header->{'comment_size'},\n     $header->{'comments_offset'},\n     $header->{'version'},\n     $header->{'sample_size'},\n     $header->{'code_set'},\n     @{$header->{'header_spare'}} ) = unpack \"a4 NNNNNNNN a4 NN N20\", $buffer;\n\n    $self->{'header'} = $header;\n    return $header;\n}\n\n=head2 _parse_v2_bases($buffer)\n\n Title   : _parse_v2_bases($buffer)\n Usage   : $self->_parse_v2_bases($buffer);\n Function: Gather the bases section from the scf and parse it into its\n           components.\n Returns :\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the bases section of an scf file according to the\n           scf file specifications.\n Notes   : None.\n\n\nsub _parse_v2_bases {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my ($offset2,$currbuff,$currbase,$currqual,$sequence,@qualities,@indices);\n    my (@read,$harvester,$accuracies);\n    for ($offset2=0;$offset2<$length;$offset2+=12) {\n         @read = unpack \"N C C C C a C3\", substr($buffer,$offset2,$length);\n         push @indices,$read[0];\n         $currbase = lc($read[5]);\n         if ($currbase eq \"a\") { $currqual = $read[1]; }\n         elsif ($currbase eq \"c\") { $currqual = $read[2]; }\n         elsif ($currbase eq \"g\") { $currqual = $read[3]; }\n         elsif ($currbase eq \"t\") { $currqual = $read[4]; }\n         else { $currqual = \"UNKNOWN\"; }\n         push @{$accuracies->{\"a\"}},$read[1];\n         push @{$accuracies->{\"c\"}},$read[2];\n         push @{$accuracies->{\"g\"}},$read[3];\n         push @{$accuracies->{\"t\"}},$read[4];\n\n         $sequence .= $currbase;\n         push @qualities,$currqual;\n    }\n     return (\\@indices,\\@qualities,$sequence,$accuracies)\n}\n\n=head2 _parse_v2_traces(\\@traces_array)\n\n Title   : _pares_v2_traces(\\@traces_array)\n Usage   : $self->_parse_v2_traces(\\@traces_array);\n Function: Parses an scf Version2 trace array into its base components.\n Returns : Nothing. Modifies $self.\n Args    : A reference to an array of the unpacked traces section of an\n           scf version2 file.\n\n\nsub _parse_v2_traces {\n    my ($self,$buffer,$sample_size) = @_;\n     my $byte;\n     if ($sample_size == 1) { $byte = \"c\"; }\n     else { $byte = \"n\"; }\n     my $length = CORE::length($buffer);\n     my @read = unpack \"${byte}${length}\",$buffer;\n          # this will be an array to the reference holding the array\n     my $traces;\n     my $array = 0;\n     for (my $offset2 = 0; $offset2< scalar(@read); $offset2+=4) {\n              push @{$traces->{'a'}},$read[$offset2];\n              push @{$traces->{'t'}},$read[$offset2+1];\n              push @{$traces->{'g'}},$read[$offset2+3];\n              push @{$traces->{'c'}},$read[$offset2+2];\n    }\n    return $traces;\n}\n\n\nsub get_trace_deprecated_use_the_sequencetrace_object_instead {\n    # my ($self,$base_channel,$traces) = @_;\n    # $base_channel =~ tr/a-z/A-Z/;\n    # if ($base_channel !~ /A|T|G|C/) {\n    #   $self->throw(\"You tried to ask for a base channel that wasn't A,T,G, or C. Ask for one of those next time.\");\n    ##} elsif ($base_channel) {\n     #  my @temp = split(' ',$self->{'traces'}->{$base_channel});\n    #return \\@temp;\n    #}\n}\n\nsub _deprecated_get_peak_indices_deprecated_use_the_sequencetrace_object_instead {\n    my ($self) = shift;\n    my @temp = split(' ',$self->{'parsed'}->{'peak_indices'});\n    return \\@temp;\n}\n\n\n=head2 get_header()\n\n Title   : get_header()\n Usage   : %header = %{$obj->get_header()};\n Function: Return the header for this scf.\n Returns : A reference to a hash containing the header for this scf.\n Args    : None.\n Notes   :\n\n\nsub get_header {\n    my ($self) = shift;\n    return $self->{'header'};\n}\n\n=head2 get_comments()\n\n Title   : get_comments()\n Usage   : %comments = %{$obj->get_comments()};\n Function: Return the comments for this scf.\n Returns : A Bio::Annotation::Collection object\n Args    : None.\n Notes   :\n\n\nsub get_comments {\n    my ($self) = shift;\n    return $self->{'comments'};\n}\n\nsub _dump_traces_outgoing_deprecated_use_the_sequencetrace_object {\n    my ($self,$transformed) = @_;\n    my (@sA,@sT,@sG,@sC);\n    if ($transformed) {\n    @sA = @{$self->{'text'}->{'t_samples_a'}};\n    @sC = @{$self->{'text'}->{'t_samples_c'}};\n    @sG = @{$self->{'text'}->{'t_samples_g'}};\n    @sT = @{$self->{'text'}->{'t_samples_t'}};\n    }\n    else {\n    @sA = @{$self->{'text'}->{'samples_a'}};\n    @sC = @{$self->{'text'}->{'samples_c'}};\n    @sG = @{$self->{'text'}->{'samples_g'}};\n    @sT = @{$self->{'text'}->{'samples_t'}};\n    }\n    print (\"Count\\ta\\tc\\tg\\tt\\n\");\n    for (my $curr=0; $curr < scalar(@sG); $curr++) {\n    print(\"$curr\\t$sA[$curr]\\t$sC[$curr]\\t$sG[$curr]\\t$sT[$curr]\\n\");\n    }\n    return;\n}\n\nsub _dump_traces_incoming_deprecated_use_the_sequencetrace_object {\n    # my ($self) = @_;\n    # my (@sA,@sT,@sG,@sC);\n    # @sA = @{$self->{'traces'}->{'A'}};\n    # @sC = @{$self->{'traces'}->{'C'}};\n    # @sG = @{$self->{'traces'}->{'G'}};\n    # @sT = @{$self->{'traces'}->{'T'}};\n    # @sA = @{$self->get_trace('A')};\n    # @sC = @{$self->get_trace('C')};\n    # @sG = @{$self->get_trace('G')};\n    # @sT = @{$self->get_trace('t')};\n    # print (\"Count\\ta\\tc\\tg\\tt\\n\");\n    # for (my $curr=0; $curr < scalar(@sG); $curr++) {\n    #   print(\"$curr\\t$sA[$curr]\\t$sC[$curr]\\t$sG[$curr]\\t$sT[$curr]\\n\");\n    #}\n    #return;\n}\n\n=head2 write_seq\n\n Title   : write_seq(-target => $swq, <comments>)\n Usage   : $obj->write_seq(\n               -target => $swq,\n            -version => 2,\n            -CONV => \"Bioperl-Chads Mighty SCF writer.\");\n Function: Write out an scf.\n Returns : Nothing.\n Args    : Requires: a reference to a Bio::Seq::Quality object to form the\n           basis for the scf.\n       if -version is provided, it should be \"2\" or \"3\". A SCF of that\n       version will be written.\n       Any other arguments are assumed to be comments and are put into\n       the comments section of the scf. Read the specifications for scf\n       to decide what might be good to put in here.\n\n Notes   :\n          For best results, use a SequenceTrace object.\n          The things that you need to write an scf:\n          a) sequence\n          b) quality\n          c) peak indices\n          d) traces\n          - You _can_ write an scf with just a and b by passing in a\n               Bio::Seq::Quality object- false traces will be synthesized\n               for you.\n\n\nsub write_seq {\n    my ($self,%args) = @_;\n    my %comments;\n    my ($label,$arg);\n    my ($swq) = $self->_rearrange([qw(TARGET)], %args);\n     my $writer_fodder;\n     if (ref($swq) =~ /Bio::Seq::SequenceTrace|Bio::Seq::Quality/) {\n               if (ref($swq) eq \"Bio::Seq::Quality\") {\n                         # this means that the object *has no trace data*\n                         # we might as well synthesize some now, ok?\n                    $swq = Bio::Seq::SequenceTrace->new(\n                         -swq     =>   $swq\n                    );\n               }\n     }\n    else  {\n    $self->throw(\"You must pass a Bio::Seq::Quality or a Bio::Seq::SequenceTrace object to write_seq as a parameter named \\\"target\\\"\");\n    }\n          # all of the rest of the arguments are comments for the scf\n    foreach $arg (sort keys %args) {\n    next if ($arg =~ /target/i);\n    ($label = $arg) =~ s/^\\-//;\n    $writer_fodder->{comments}->{$label} = $args{$arg};\n    }\n    if (!$comments{'NAME'}) { $comments{'NAME'} = $swq->id(); }\n          # HA! Bwahahahaha.\n    $writer_fodder->{comments}->{'CONV'} = \"Bioperl-Chads Mighty SCF writer.\" unless defined $comments{'CONV'};\n          # now deal with the version of scf they want to write\n    if ($writer_fodder->{comments}->{version}) {\n         if ($writer_fodder->{comments}->{version} != 2 && $writer_fodder->{comments}->{version} != 3) {\n              $self->warn(\"This module can only write version 2.0 or 3.0 scf's. Writing a version 2.0 scf by default.\");\n              $writer_fodder->{header}->{version} = \"2.00\";\n         }\n         elsif ($writer_fodder->{comments}->{'version'} > 2) {\n              $writer_fodder->{header}->{'version'} = \"3.00\";\n         }\n          else {\n               $writer_fodder->{header}->{version} = \"2\";\n          }\n    }\n    else {\n         $writer_fodder->{header}->{'version'} = \"3.00\";\n    }\n          # set a few things in the header\n    $writer_fodder->{'header'}->{'magic'} = \".scf\";\n    $writer_fodder->{'header'}->{'sample_size'} = \"2\";\n    $writer_fodder->{'header'}->{'bases'} = length($swq->seq());\n    $writer_fodder->{'header'}->{'bases_left_clip'} = \"0\";\n    $writer_fodder->{'header'}->{'bases_right_clip'} = \"0\";\n    $writer_fodder->{'header'}->{'sample_size'} = \"2\";\n    $writer_fodder->{'header'}->{'code_set'} = \"9\";\n    @{$writer_fodder->{'header'}->{'spare'}} = qw(0 0 0 0 0 0 0 0 0 0\n                     0 0 0 0 0 0 0 0 0 0);\n    $writer_fodder->{'header'}->{'samples_offset'} = \"128\";\n     $writer_fodder->{'header'}->{'samples'} = $swq->trace_length();\n          # create the binary for the comments and file it in writer_fodder\n    $writer_fodder->{comments} =  $self->_get_binary_comments(\n               $writer_fodder->{comments});\n          # create the binary and the strings for the traces, bases,\n          # offsets (if necessary), and accuracies (if necessary)\n    $writer_fodder->{traces} = $self->_get_binary_traces(\n               $writer_fodder->{'header'}->{'version'},\n               $swq,$writer_fodder->{'header'}->{'sample_size'});\n    my ($b_base_offsets,$b_base_accuracies,$samples_size,$bases_size);\n    #\n    # version 2\n    #\n    if ($writer_fodder->{'header'}->{'version'} == 2) {\n          $writer_fodder->{bases} = $self->_get_binary_bases(\n                         2,\n                         $swq,\n                         $writer_fodder->{'header'}->{'sample_size'});\n         $samples_size = CORE::length($writer_fodder->{traces}->{'binary'});\n         $bases_size = CORE::length($writer_fodder->{bases}->{binary});\n         $writer_fodder->{'header'}->{'bases_offset'} = 128 + $samples_size;\n         $writer_fodder->{'header'}->{'comments_offset'} = 128 +\n               $samples_size + $bases_size;\n         $writer_fodder->{'header'}->{'comments_size'} =\n               length($writer_fodder->{'comments'}->{binary});\n         $writer_fodder->{'header'}->{'private_size'} = \"0\";\n         $writer_fodder->{'header'}->{'private_offset'} = 128 +\n               $samples_size + $bases_size +\n               $writer_fodder->{'header'}->{'comments_size'};\n          $writer_fodder->{'header'}->{'binary'} =\n          $self->_get_binary_header($writer_fodder->{header});\n          $dumper->dumpValue($writer_fodder) if $self->verbose > 0;\n         $self->_print ($writer_fodder->{'header'}->{'binary'})\n               or print(\"Could not write binary header...\\n\");\n         $self->_print ($writer_fodder->{'traces'}->{'binary'})\n               or print(\"Could not write binary traces...\\n\");\n         $self->_print ($writer_fodder->{'bases'}->{'binary'})\n               or print(\"Could not write binary base structures...\\n\");\n         $self->_print ($writer_fodder->{'comments'}->{'binary'})\n               or print(\"Could not write binary comments...\\n\");\n    }\n    else {\n          ($writer_fodder->{peak_indices},\n           $writer_fodder->{accuracies},\n           $writer_fodder->{bases},\n           $writer_fodder->{reserved} ) =\n               $self->_get_binary_bases(\n                    3,\n                    $swq,\n                    $writer_fodder->{'header'}->{'sample_size'}\n               );\n         $writer_fodder->{'header'}->{'bases_offset'} = 128 +\n               length($writer_fodder->{'traces'}->{'binary'});\n         $writer_fodder->{'header'}->{'comments_size'} =\n               length($writer_fodder->{'comments'}->{'binary'});\n              # this is:\n              # bases_offset + base_offsets + accuracies + called_bases +\n               # reserved\n         $writer_fodder->{'header'}->{'private_size'} = \"0\";\n\n         $writer_fodder->{'header'}->{'comments_offset'} =\n              128+length($writer_fodder->{'traces'}->{'binary'})+\n                 length($writer_fodder->{'peak_indices'}->{'binary'})+\n                 length($writer_fodder->{'accuracies'}->{'binary'})+\n                length($writer_fodder->{'bases'}->{'binary'})+\n                length($writer_fodder->{'reserved'}->{'binary'});\n    $writer_fodder->{'header'}->{'private_offset'} =\n          $writer_fodder->{'header'}->{'comments_offset'} +\n               $writer_fodder->{'header'}->{'comments_size'};\n    $writer_fodder->{'header'}->{'spare'}->[1] =\n         $writer_fodder->{'header'}->{'comments_offset'} +\n             length($writer_fodder->{'comments'}->{'binary'});\n     $writer_fodder->{header}->{binary} =\n          $self->_get_binary_header($writer_fodder->{header});\n    $self->_print ($writer_fodder->{'header'}->{'binary'})\n          or print(\"Couldn't write header\\n\");\n    $self->_print ($writer_fodder->{'traces'}->{'binary'})\n          or print(\"Couldn't write samples\\n\");\n    $self->_print ($writer_fodder->{'peak_indices'}->{'binary'})\n          or print(\"Couldn't write peak offsets\\n\");\n    $self->_print ($writer_fodder->{'accuracies'}->{'binary'})\n          or print(\"Couldn't write accuracies\\n\");\n    $self->_print ($writer_fodder->{'bases'}->{'binary'})\n          or print(\"Couldn't write called_bases\\n\");\n    $self->_print ($writer_fodder->{'reserved'}->{'binary'})\n          or print(\"Couldn't write reserved\\n\");\n    $self->_print ($writer_fodder->{'comments'}->{'binary'})\n          or print (\"Couldn't write comments\\n\");\n    }\n\n    # kinda unnecessary, given the close() below, but maybe that'll go\n    # away someday.\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n\n    $self->close();\n    return 1;\n}\n\n\n\n\n\n=head2 _get_binary_header()\n\n Title   : _get_binary_header();\n Usage   : $self->_get_binary_header();\n Function: Provide the binary string that will be used as the header for\n            a scfv2 document.\n Returns : A binary string.\n Args    : None. Uses the entries in the $self->{'header'} hash. These\n            are set on construction of the object (hopefully correctly!).\n Notes   :","label":"_get_binary_header($self,$header)"}},{"line":796,"name":"$binary","kind":13,"containerName":null},{"signature":{"parameters":[{"label":"$self"},{"label":"$version"},{"label":"$ref"},{"label":"$sample_size"}],"documentation":"__END__\n# $Id: scf.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::scf - .scf file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly. Use it via the Bio::SeqIO class, see\nL<Bio::SeqIO> for more information.\n\n=head1 DESCRIPTION\n\nThis object can transform .scf files to and from Bio::Seq::SequenceTrace\nobjects.  Mechanisms are present to retrieve trace data from scf\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chad Matsalla\n\nChad Matsalla\nbioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\nTony Cox, avc@sanger.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nNancy Hansen, nhansen at mail.nih.gov\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::scf;\nuse vars qw($DEFAULT_QUALITY);\nuse strict;\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SequenceTrace;\nuse Bio::Annotation::Comment;\nuse Dumpvalue;\n\nmy $dumper = new Dumpvalue();\n$dumper->veryCompact(1);\n\nBEGIN {\n    $DEFAULT_QUALITY= 10;\n}\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n                  (-verbose => $self->verbose(),\n                   -type => 'Bio::Seq::Quality'));\n  }\n  binmode $self->_fh; # for the Win32/Mac crowds  \n}\n\n=head2 next_seq()\n\n Title   : next_seq()\n Usage   : $scf = $stream->next_seq()\n Function: returns the next scf sequence in the stream\n Returns : a Bio::Seq::SequenceTrace object\n Args    : NONE\n Notes   : Fills the interface specification for SeqIO.\n            The SCF specification does not provide for having more then\n           one sequence in a given scf. So once the filehandle has been open\n           and passed to SeqIO do not expect to run this function more then\n           once on a given scf unless you embraced and extended the SCF\n       standard.  SCF comments are accessible through the Bio::SeqI\n           interface method annotation().\n\n\n#'\nsub next_seq {\n    my ($self) = @_;\n    my ($seq, $seqc, $fh, $buffer, $offset, $length, $read_bytes, @read,\n         %names);\n    # set up a filehandle to read in the scf\n    return if $self->{_readfile};\n    $fh = $self->_fh();\n    unless ($fh) {      # simulate the <> function\n        if ( !fileno(ARGV) or eof(ARGV) ) {\n            return unless my $ARGV = shift;\n            open(ARGV,$ARGV) or\n              $self->throw(\"Could not open $ARGV for SCF stream reading $!\");\n        }\n        $fh = \\*ARGV;\n    }\n    return unless read $fh, $buffer, 128; # no exception; probably end of file\n    # now, the master data structure will be the creator\n    my $creator;\n    # he first thing to do is parse the header. This is common\n    # among all versions of scf.\n    # the rest of the the information is different between the\n    # the different versions of scf.\n\n    $creator->{header} = $self->_get_header($buffer);\n    if ($creator->{header}->{'version'} lt \"3.00\") {\n        $self->debug(\"scf.pm is working with a version 2 scf.\\n\");\n        # first gather the trace information\n        $length = $creator->{header}->{'samples'} *\n          $creator->{header}->{sample_size}*4;\n        $buffer = $self->read_from_buffer($fh, $buffer, $length,\n                                                     $creator->{header}->{samples_offset});\n        # @read = unpack \"n$length\",$buffer;\n        # these traces need to be split\n        # returns a reference to a hash\n        $creator->{traces} = $self->_parse_v2_traces(\n                                                     $buffer,$creator->{header}->{sample_size});\n        # now go and get the base information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 12);\n        seek $fh,$offset,0;\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$creator->{header}->{bases_offset});\n        # now distill the information into its fractions.\n        # the old way : $self->_set_v2_bases($buffer);\n        # ref to an array, ref to a hash, string\n        ($creator->{peak_indices},\n         $creator->{qualities},\n         $creator->{sequence},\n         $creator->{accuracies}) = $self->_parse_v2_bases($buffer);\n\n    } else {\n        $self->debug(\"scf.pm is working with a version 3+ scf.\\n\");\n        my $transformed_read;\n        my $current_read_position = $creator->{header}->{sample_offset};\n        $length = $creator->{header}->{'samples'}*\n          $creator->{header}->{sample_size};\n        # $dumper->dumpValue($creator->{header});\n        foreach (qw(a c g t)) {\n            $buffer = $self->read_from_buffer($fh,$buffer,$length,$current_read_position);\n            my $byte = \"n\";\n            if ($creator->{header}->{sample_size} == 1) {\n                $byte = \"c\";\n            }\n            @read = unpack \"${byte}${length}\",$buffer;\n            # this little spurt of nonsense is because\n            # the trace values are given in the binary\n            # file as unsigned shorts but they really\n            # are signed deltas. 30000 is an arbitrary number\n            # (will there be any traces with a given\n            # point greater then 30000? I hope not.\n            # once the read is read, it must be changed\n            # from relative\n            foreach (@read) {\n                if ($_ > 30000) {\n                    $_ -= 65536;\n                }\n            }\n            $transformed_read = $self->_delta(\\@read,\"backward\");\n            # For 8-bit data we need to emulate a signed/unsigned\n            # cast that is implicit in the C implementations.....\n            if ($creator->{header}->{sample_size} == 1) {\n                foreach (@{$transformed_read}) {\n                    $_ += 256 if ($_ < 0);\n                }\n            }\n            $current_read_position += $length;\n            $creator->{'traces'}->{$_} = join(' ',@{$transformed_read});\n        }\n        \n        # now go and get the peak index information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 4);\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{peak_indices} = $self->_get_v3_peak_indices($buffer);\n        $offset += $length;\n        # now go and get the accuracy information\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{accuracies} = $self->_get_v3_base_accuracies($buffer);\n        # OK, now go and get the base information.\n        $offset += $length;\n        $length = $creator->{header}->{bases};\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{'sequence'} = unpack(\"a$length\",$buffer);\n        # now, finally, extract the calls from the accuracy information.\n        $creator->{qualities} = $self->_get_v3_quality(\n                                              $creator->{'sequence'},$creator->{accuracies});\n    }\n    # now go and get the comment information\n    $offset = $creator->{header}->{comments_offset};\n    seek $fh,$offset,0;\n    $length = $creator->{header}->{comment_size};\n    $buffer = $self->read_from_buffer($fh,$buffer,$length);\n    $creator->{comments} = $self->_get_comments($buffer);\n    my @name_comments = grep {$_->tagname() eq 'NAME'}\n                $creator->{comments}->get_Annotations('comment');\n    my $name_comment;\n    if (@name_comments){\n         $name_comment = $name_comments[0]->as_text();\n         $name_comment =~ s/^Comment:\\s+//;\n    }\n\n    my $swq = Bio::Seq::Quality->new(\n        -seq  =>   $creator->{'sequence'},\n        -qual =>    $creator->{'qualities'},\n        -id   =>    $name_comment\n                                              );\n    my $returner = Bio::Seq::SequenceTrace->new(\n                                           -swq      =>   $swq,\n                                            -trace_a  =>   $creator->{'traces'}->{'a'},\n                                            -trace_t  =>   $creator->{'traces'}->{'t'},\n                                           -trace_g  =>   $creator->{'traces'}->{'g'},\n                                           -trace_c  =>   $creator->{'traces'}->{'c'},\n                                       -accuracy_a    => $creator->{'accuracies'}->{'a'},\n                                   -accuracy_t    => $creator->{'accuracies'}->{'t'},\n                                      -accuracy_g    => $creator->{'accuracies'}->{'g'},\n                                    -accuracy_c    => $creator->{'accuracies'}->{'c'},\n                                 -peak_indices  => $creator->{'peak_indices'}\n                                                             );\n\n        $returner->annotation($creator->{'comments'}); # add SCF comments\n    $self->{'_readfile'} = 1;\n    return $returner;\n}\n\n\n=head2 _get_v3_quality()\n\n Title   : _get_v3_quality()\n Usage   : $self->_get_v3_quality()\n Function: Set the base qualities from version3 scf\n Returns : Nothing. Alters $self.\n Args    : None.\n Notes   :\n\n\n#'\nsub _get_v3_quality {\n    my ($self,$sequence,$accuracies) = @_;\n    my @bases = split//,$sequence;\n    my (@qualities,$currbase,$currqual,$counter);\n    for ($counter=0; $counter <= $#bases ; $counter++) {\n    $currbase = lc($bases[$counter]);\n    if ($currbase eq \"a\") { $currqual = $accuracies->{'a'}->[$counter]; }\n    elsif ($currbase eq \"c\") { $currqual = $accuracies->{'c'}->[$counter]; }\n    elsif ($currbase eq \"g\") { $currqual = $accuracies->{'g'}->[$counter]; }\n    elsif ($currbase eq \"t\") { $currqual = $accuracies->{'t'}->[$counter]; }\n    else { $currqual = \"unknown\"; }\n    push @qualities,$currqual;\n    }\n    return \\@qualities;\n}\n\n=head2 _get_v3_peak_indices($buffer)\n\n Title   : _get_v3_peak_indices($buffer)\n Usage   : $self->_get_v3_peak_indices($buffer);\n Function: Unpacks the base accuracies for version3 scf\n Returns : Nothing. Alters $self\n Args    : A scalar containing binary data.\n Notes   :\n\n\nsub _get_v3_peak_indices {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my @read = unpack \"N$length\",$buffer;\n     return join(' ',@read);\n}\n\n=head2 _get_v3_base_accuracies($buffer)\n\n Title   : _get_v3_base_accuracies($buffer)\n Usage   : $self->_get_v3_base_accuracies($buffer)\n Function: Set the base accuracies for version 3 scf's\n Returns : Nothing. Alters $self.\n Args    : A scalar containing binary data.\n Notes   :\n\n\n#'\nsub _get_v3_base_accuracies {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my $qlength = $length/4;\n    my $offset = 0;\n    my (@qualities,@sorter,$counter,$round,$last_base,$accuracies,$currbase);\n    foreach $currbase (qw(a c g t)) {\n         my @read;\n         $last_base = $offset + $qlength;\n         for (;$offset < $last_base; $offset += $qlength) {\n                    # a bioperler (perhaps me?) changed the unpack string to include 'n' rather than 'C'\n                    # on 040322 I think that 'C' is correct. please email chad if you would like to accuse me of being incorrect\n              @read = unpack \"C$qlength\", substr($buffer,$offset,$qlength);\n              $accuracies->{$currbase} = \\@read;\n         }\n    }\n     return $accuracies;\n}\n\n\n=head2 _get_comments($buffer)\n\n Title   : _get_comments($buffer)\n Usage   : $self->_get_comments($buffer);\n Function: Gather the comments section from the scf and parse it into its\n            components.\n Returns : a Bio::Annotation::Collection object\n Args    : The buffer. It is expected that the buffer contains a binary\n            string for the comments section of an scf file according to\n            the scf file specifications.\n Notes   :\n\n\nsub _get_comments {\n    my ($self,$buffer) = @_;\n    my $comments = Bio::Annotation::Collection->new();\n    my $size = length($buffer);\n    my $comments_retrieved = unpack \"a$size\",$buffer;\n    $comments_retrieved =~ s/\\0//;\n    my @comments_split = split/\\n/,$comments_retrieved;\n    if (@comments_split) {\n        foreach (@comments_split) {\n            /(\\w+)=(.*)/;\n            if ($1 && $2) {\n                my ($tagname, $text) = ($1, $2);\n                my $comment_obj = Bio::Annotation::Comment->new(\n                                     -text => $text,\n                                     -tagname => $tagname);\n\n                $comments->add_Annotation('comment', $comment_obj);\n            }\n        }\n    }\n    $self->{'comments'} = $comments;\n    return $comments;\n}\n\n=head2 _get_header()\n\n Title   : _get_header($buffer)\n Usage   : $self->_get_header($buffer);\n Function: Gather the header section from the scf and parse it into its\n           components.\n Returns : Reference to a hash containing the header components.\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the header section of an scf file according to the\n           scf file specifications.\n Notes   : None.\n\n\nsub _get_header {\n    my ($self,$buffer) = @_;\n    my $header;\n    ($header->{'scf'},\n     $header->{'samples'},\n     $header->{'sample_offset'},\n     $header->{'bases'},\n     $header->{'bases_left_clip'},\n     $header->{'bases_right_clip'},\n     $header->{'bases_offset'},\n     $header->{'comment_size'},\n     $header->{'comments_offset'},\n     $header->{'version'},\n     $header->{'sample_size'},\n     $header->{'code_set'},\n     @{$header->{'header_spare'}} ) = unpack \"a4 NNNNNNNN a4 NN N20\", $buffer;\n\n    $self->{'header'} = $header;\n    return $header;\n}\n\n=head2 _parse_v2_bases($buffer)\n\n Title   : _parse_v2_bases($buffer)\n Usage   : $self->_parse_v2_bases($buffer);\n Function: Gather the bases section from the scf and parse it into its\n           components.\n Returns :\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the bases section of an scf file according to the\n           scf file specifications.\n Notes   : None.\n\n\nsub _parse_v2_bases {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my ($offset2,$currbuff,$currbase,$currqual,$sequence,@qualities,@indices);\n    my (@read,$harvester,$accuracies);\n    for ($offset2=0;$offset2<$length;$offset2+=12) {\n         @read = unpack \"N C C C C a C3\", substr($buffer,$offset2,$length);\n         push @indices,$read[0];\n         $currbase = lc($read[5]);\n         if ($currbase eq \"a\") { $currqual = $read[1]; }\n         elsif ($currbase eq \"c\") { $currqual = $read[2]; }\n         elsif ($currbase eq \"g\") { $currqual = $read[3]; }\n         elsif ($currbase eq \"t\") { $currqual = $read[4]; }\n         else { $currqual = \"UNKNOWN\"; }\n         push @{$accuracies->{\"a\"}},$read[1];\n         push @{$accuracies->{\"c\"}},$read[2];\n         push @{$accuracies->{\"g\"}},$read[3];\n         push @{$accuracies->{\"t\"}},$read[4];\n\n         $sequence .= $currbase;\n         push @qualities,$currqual;\n    }\n     return (\\@indices,\\@qualities,$sequence,$accuracies)\n}\n\n=head2 _parse_v2_traces(\\@traces_array)\n\n Title   : _pares_v2_traces(\\@traces_array)\n Usage   : $self->_parse_v2_traces(\\@traces_array);\n Function: Parses an scf Version2 trace array into its base components.\n Returns : Nothing. Modifies $self.\n Args    : A reference to an array of the unpacked traces section of an\n           scf version2 file.\n\n\nsub _parse_v2_traces {\n    my ($self,$buffer,$sample_size) = @_;\n     my $byte;\n     if ($sample_size == 1) { $byte = \"c\"; }\n     else { $byte = \"n\"; }\n     my $length = CORE::length($buffer);\n     my @read = unpack \"${byte}${length}\",$buffer;\n          # this will be an array to the reference holding the array\n     my $traces;\n     my $array = 0;\n     for (my $offset2 = 0; $offset2< scalar(@read); $offset2+=4) {\n              push @{$traces->{'a'}},$read[$offset2];\n              push @{$traces->{'t'}},$read[$offset2+1];\n              push @{$traces->{'g'}},$read[$offset2+3];\n              push @{$traces->{'c'}},$read[$offset2+2];\n    }\n    return $traces;\n}\n\n\nsub get_trace_deprecated_use_the_sequencetrace_object_instead {\n    # my ($self,$base_channel,$traces) = @_;\n    # $base_channel =~ tr/a-z/A-Z/;\n    # if ($base_channel !~ /A|T|G|C/) {\n    #   $self->throw(\"You tried to ask for a base channel that wasn't A,T,G, or C. Ask for one of those next time.\");\n    ##} elsif ($base_channel) {\n     #  my @temp = split(' ',$self->{'traces'}->{$base_channel});\n    #return \\@temp;\n    #}\n}\n\nsub _deprecated_get_peak_indices_deprecated_use_the_sequencetrace_object_instead {\n    my ($self) = shift;\n    my @temp = split(' ',$self->{'parsed'}->{'peak_indices'});\n    return \\@temp;\n}\n\n\n=head2 get_header()\n\n Title   : get_header()\n Usage   : %header = %{$obj->get_header()};\n Function: Return the header for this scf.\n Returns : A reference to a hash containing the header for this scf.\n Args    : None.\n Notes   :\n\n\nsub get_header {\n    my ($self) = shift;\n    return $self->{'header'};\n}\n\n=head2 get_comments()\n\n Title   : get_comments()\n Usage   : %comments = %{$obj->get_comments()};\n Function: Return the comments for this scf.\n Returns : A Bio::Annotation::Collection object\n Args    : None.\n Notes   :\n\n\nsub get_comments {\n    my ($self) = shift;\n    return $self->{'comments'};\n}\n\nsub _dump_traces_outgoing_deprecated_use_the_sequencetrace_object {\n    my ($self,$transformed) = @_;\n    my (@sA,@sT,@sG,@sC);\n    if ($transformed) {\n    @sA = @{$self->{'text'}->{'t_samples_a'}};\n    @sC = @{$self->{'text'}->{'t_samples_c'}};\n    @sG = @{$self->{'text'}->{'t_samples_g'}};\n    @sT = @{$self->{'text'}->{'t_samples_t'}};\n    }\n    else {\n    @sA = @{$self->{'text'}->{'samples_a'}};\n    @sC = @{$self->{'text'}->{'samples_c'}};\n    @sG = @{$self->{'text'}->{'samples_g'}};\n    @sT = @{$self->{'text'}->{'samples_t'}};\n    }\n    print (\"Count\\ta\\tc\\tg\\tt\\n\");\n    for (my $curr=0; $curr < scalar(@sG); $curr++) {\n    print(\"$curr\\t$sA[$curr]\\t$sC[$curr]\\t$sG[$curr]\\t$sT[$curr]\\n\");\n    }\n    return;\n}\n\nsub _dump_traces_incoming_deprecated_use_the_sequencetrace_object {\n    # my ($self) = @_;\n    # my (@sA,@sT,@sG,@sC);\n    # @sA = @{$self->{'traces'}->{'A'}};\n    # @sC = @{$self->{'traces'}->{'C'}};\n    # @sG = @{$self->{'traces'}->{'G'}};\n    # @sT = @{$self->{'traces'}->{'T'}};\n    # @sA = @{$self->get_trace('A')};\n    # @sC = @{$self->get_trace('C')};\n    # @sG = @{$self->get_trace('G')};\n    # @sT = @{$self->get_trace('t')};\n    # print (\"Count\\ta\\tc\\tg\\tt\\n\");\n    # for (my $curr=0; $curr < scalar(@sG); $curr++) {\n    #   print(\"$curr\\t$sA[$curr]\\t$sC[$curr]\\t$sG[$curr]\\t$sT[$curr]\\n\");\n    #}\n    #return;\n}\n\n=head2 write_seq\n\n Title   : write_seq(-target => $swq, <comments>)\n Usage   : $obj->write_seq(\n               -target => $swq,\n            -version => 2,\n            -CONV => \"Bioperl-Chads Mighty SCF writer.\");\n Function: Write out an scf.\n Returns : Nothing.\n Args    : Requires: a reference to a Bio::Seq::Quality object to form the\n           basis for the scf.\n       if -version is provided, it should be \"2\" or \"3\". A SCF of that\n       version will be written.\n       Any other arguments are assumed to be comments and are put into\n       the comments section of the scf. Read the specifications for scf\n       to decide what might be good to put in here.\n\n Notes   :\n          For best results, use a SequenceTrace object.\n          The things that you need to write an scf:\n          a) sequence\n          b) quality\n          c) peak indices\n          d) traces\n          - You _can_ write an scf with just a and b by passing in a\n               Bio::Seq::Quality object- false traces will be synthesized\n               for you.\n\n\nsub write_seq {\n    my ($self,%args) = @_;\n    my %comments;\n    my ($label,$arg);\n    my ($swq) = $self->_rearrange([qw(TARGET)], %args);\n     my $writer_fodder;\n     if (ref($swq) =~ /Bio::Seq::SequenceTrace|Bio::Seq::Quality/) {\n               if (ref($swq) eq \"Bio::Seq::Quality\") {\n                         # this means that the object *has no trace data*\n                         # we might as well synthesize some now, ok?\n                    $swq = Bio::Seq::SequenceTrace->new(\n                         -swq     =>   $swq\n                    );\n               }\n     }\n    else  {\n    $self->throw(\"You must pass a Bio::Seq::Quality or a Bio::Seq::SequenceTrace object to write_seq as a parameter named \\\"target\\\"\");\n    }\n          # all of the rest of the arguments are comments for the scf\n    foreach $arg (sort keys %args) {\n    next if ($arg =~ /target/i);\n    ($label = $arg) =~ s/^\\-//;\n    $writer_fodder->{comments}->{$label} = $args{$arg};\n    }\n    if (!$comments{'NAME'}) { $comments{'NAME'} = $swq->id(); }\n          # HA! Bwahahahaha.\n    $writer_fodder->{comments}->{'CONV'} = \"Bioperl-Chads Mighty SCF writer.\" unless defined $comments{'CONV'};\n          # now deal with the version of scf they want to write\n    if ($writer_fodder->{comments}->{version}) {\n         if ($writer_fodder->{comments}->{version} != 2 && $writer_fodder->{comments}->{version} != 3) {\n              $self->warn(\"This module can only write version 2.0 or 3.0 scf's. Writing a version 2.0 scf by default.\");\n              $writer_fodder->{header}->{version} = \"2.00\";\n         }\n         elsif ($writer_fodder->{comments}->{'version'} > 2) {\n              $writer_fodder->{header}->{'version'} = \"3.00\";\n         }\n          else {\n               $writer_fodder->{header}->{version} = \"2\";\n          }\n    }\n    else {\n         $writer_fodder->{header}->{'version'} = \"3.00\";\n    }\n          # set a few things in the header\n    $writer_fodder->{'header'}->{'magic'} = \".scf\";\n    $writer_fodder->{'header'}->{'sample_size'} = \"2\";\n    $writer_fodder->{'header'}->{'bases'} = length($swq->seq());\n    $writer_fodder->{'header'}->{'bases_left_clip'} = \"0\";\n    $writer_fodder->{'header'}->{'bases_right_clip'} = \"0\";\n    $writer_fodder->{'header'}->{'sample_size'} = \"2\";\n    $writer_fodder->{'header'}->{'code_set'} = \"9\";\n    @{$writer_fodder->{'header'}->{'spare'}} = qw(0 0 0 0 0 0 0 0 0 0\n                     0 0 0 0 0 0 0 0 0 0);\n    $writer_fodder->{'header'}->{'samples_offset'} = \"128\";\n     $writer_fodder->{'header'}->{'samples'} = $swq->trace_length();\n          # create the binary for the comments and file it in writer_fodder\n    $writer_fodder->{comments} =  $self->_get_binary_comments(\n               $writer_fodder->{comments});\n          # create the binary and the strings for the traces, bases,\n          # offsets (if necessary), and accuracies (if necessary)\n    $writer_fodder->{traces} = $self->_get_binary_traces(\n               $writer_fodder->{'header'}->{'version'},\n               $swq,$writer_fodder->{'header'}->{'sample_size'});\n    my ($b_base_offsets,$b_base_accuracies,$samples_size,$bases_size);\n    #\n    # version 2\n    #\n    if ($writer_fodder->{'header'}->{'version'} == 2) {\n          $writer_fodder->{bases} = $self->_get_binary_bases(\n                         2,\n                         $swq,\n                         $writer_fodder->{'header'}->{'sample_size'});\n         $samples_size = CORE::length($writer_fodder->{traces}->{'binary'});\n         $bases_size = CORE::length($writer_fodder->{bases}->{binary});\n         $writer_fodder->{'header'}->{'bases_offset'} = 128 + $samples_size;\n         $writer_fodder->{'header'}->{'comments_offset'} = 128 +\n               $samples_size + $bases_size;\n         $writer_fodder->{'header'}->{'comments_size'} =\n               length($writer_fodder->{'comments'}->{binary});\n         $writer_fodder->{'header'}->{'private_size'} = \"0\";\n         $writer_fodder->{'header'}->{'private_offset'} = 128 +\n               $samples_size + $bases_size +\n               $writer_fodder->{'header'}->{'comments_size'};\n          $writer_fodder->{'header'}->{'binary'} =\n          $self->_get_binary_header($writer_fodder->{header});\n          $dumper->dumpValue($writer_fodder) if $self->verbose > 0;\n         $self->_print ($writer_fodder->{'header'}->{'binary'})\n               or print(\"Could not write binary header...\\n\");\n         $self->_print ($writer_fodder->{'traces'}->{'binary'})\n               or print(\"Could not write binary traces...\\n\");\n         $self->_print ($writer_fodder->{'bases'}->{'binary'})\n               or print(\"Could not write binary base structures...\\n\");\n         $self->_print ($writer_fodder->{'comments'}->{'binary'})\n               or print(\"Could not write binary comments...\\n\");\n    }\n    else {\n          ($writer_fodder->{peak_indices},\n           $writer_fodder->{accuracies},\n           $writer_fodder->{bases},\n           $writer_fodder->{reserved} ) =\n               $self->_get_binary_bases(\n                    3,\n                    $swq,\n                    $writer_fodder->{'header'}->{'sample_size'}\n               );\n         $writer_fodder->{'header'}->{'bases_offset'} = 128 +\n               length($writer_fodder->{'traces'}->{'binary'});\n         $writer_fodder->{'header'}->{'comments_size'} =\n               length($writer_fodder->{'comments'}->{'binary'});\n              # this is:\n              # bases_offset + base_offsets + accuracies + called_bases +\n               # reserved\n         $writer_fodder->{'header'}->{'private_size'} = \"0\";\n\n         $writer_fodder->{'header'}->{'comments_offset'} =\n              128+length($writer_fodder->{'traces'}->{'binary'})+\n                 length($writer_fodder->{'peak_indices'}->{'binary'})+\n                 length($writer_fodder->{'accuracies'}->{'binary'})+\n                length($writer_fodder->{'bases'}->{'binary'})+\n                length($writer_fodder->{'reserved'}->{'binary'});\n    $writer_fodder->{'header'}->{'private_offset'} =\n          $writer_fodder->{'header'}->{'comments_offset'} +\n               $writer_fodder->{'header'}->{'comments_size'};\n    $writer_fodder->{'header'}->{'spare'}->[1] =\n         $writer_fodder->{'header'}->{'comments_offset'} +\n             length($writer_fodder->{'comments'}->{'binary'});\n     $writer_fodder->{header}->{binary} =\n          $self->_get_binary_header($writer_fodder->{header});\n    $self->_print ($writer_fodder->{'header'}->{'binary'})\n          or print(\"Couldn't write header\\n\");\n    $self->_print ($writer_fodder->{'traces'}->{'binary'})\n          or print(\"Couldn't write samples\\n\");\n    $self->_print ($writer_fodder->{'peak_indices'}->{'binary'})\n          or print(\"Couldn't write peak offsets\\n\");\n    $self->_print ($writer_fodder->{'accuracies'}->{'binary'})\n          or print(\"Couldn't write accuracies\\n\");\n    $self->_print ($writer_fodder->{'bases'}->{'binary'})\n          or print(\"Couldn't write called_bases\\n\");\n    $self->_print ($writer_fodder->{'reserved'}->{'binary'})\n          or print(\"Couldn't write reserved\\n\");\n    $self->_print ($writer_fodder->{'comments'}->{'binary'})\n          or print (\"Couldn't write comments\\n\");\n    }\n\n    # kinda unnecessary, given the close() below, but maybe that'll go\n    # away someday.\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n\n    $self->close();\n    return 1;\n}\n\n\n\n\n\n=head2 _get_binary_header()\n\n Title   : _get_binary_header();\n Usage   : $self->_get_binary_header();\n Function: Provide the binary string that will be used as the header for\n            a scfv2 document.\n Returns : A binary string.\n Args    : None. Uses the entries in the $self->{'header'} hash. These\n            are set on construction of the object (hopefully correctly!).\n Notes   :\n\n\nsub _get_binary_header {\n    my ($self,$header) = @_;\n    my $binary = pack \"a4 NNNNNNNN a4 NN N20\",\n    (\n     $header->{'magic'},\n     $header->{'samples'},\n     $header->{'samples_offset'},\n     $header->{'bases'},\n     $header->{'bases_left_clip'},\n     $header->{'bases_right_clip'},\n     $header->{'bases_offset'},\n     $header->{'comments_size'},\n     $header->{'comments_offset'},\n     $header->{'version'},\n     $header->{'sample_size'},\n     $header->{'code_set'},\n     @{$header->{'spare'}}\n     );\n    return $binary;\n}\n\n=head2 _get_binary_traces($version,$ref)\n\n Title   : _set_binary_tracesbases($version,$ref)\n Usage   : $self->_set_binary_tracesbases($version,$ref);\n Function: Constructs the trace and base strings for all scfs\n Returns : Nothing. Alters self.\n Args    : $version - \"2\" or \"3\"\n       $sequence - a scalar containing arbitrary sequence data\n       $ref - a reference to either a SequenceTraces or a\n          SequenceWithQuality object.\n Notes   : This is a really complicated thing.","label":"_get_binary_traces($self,$version,$ref,$sample_size)"},"range":{"start":{"character":0,"line":813},"end":{"line":854,"character":9999}},"kind":12,"line":813,"detail":"($self,$version,$ref,$sample_size)","definition":"sub","name":"_get_binary_traces","containerName":"main::","children":[{"line":814,"containerName":"_get_binary_traces","localvar":"my","kind":13,"name":"$self","definition":"my"},{"name":"$version","kind":13,"containerName":"_get_binary_traces","line":814},{"name":"$ref","kind":13,"containerName":"_get_binary_traces","line":814},{"containerName":"_get_binary_traces","kind":13,"name":"$sample_size","line":814},{"line":817,"name":"$returner","containerName":"_get_binary_traces","localvar":"my","kind":13,"definition":"my"},{"definition":"my","line":818,"name":"$sequence","containerName":"_get_binary_traces","localvar":"my","kind":13},{"line":818,"containerName":"_get_binary_traces","kind":13,"name":"$ref"},{"line":818,"name":"seq","kind":12,"containerName":"_get_binary_traces"},{"name":"$sequence_length","localvar":"my","kind":13,"containerName":"_get_binary_traces","line":819,"definition":"my"},{"name":"$sequence","kind":13,"containerName":"_get_binary_traces","line":819},{"definition":"my","name":"$traceobj","localvar":"my","containerName":"_get_binary_traces","kind":13,"line":822},{"name":"@traces","containerName":"_get_binary_traces","kind":13,"line":822},{"name":"$current","containerName":"_get_binary_traces","kind":13,"line":822},{"line":823,"kind":13,"containerName":"_get_binary_traces","name":"$ref"},{"name":"$traceobj","kind":13,"containerName":"_get_binary_traces","line":824},{"line":824,"name":"new","kind":12,"containerName":"_get_binary_traces"},{"name":"$ref","containerName":"_get_binary_traces","kind":13,"line":826},{"containerName":"_get_binary_traces","kind":13,"name":"$traceobj","line":827},{"name":"_synthesize_traces","kind":12,"containerName":"_get_binary_traces","line":827},{"line":830,"containerName":"_get_binary_traces","kind":13,"name":"$traceobj"},{"line":830,"containerName":"_get_binary_traces","kind":13,"name":"$ref"},{"containerName":"_get_binary_traces","kind":13,"name":"$version","line":831},{"localvar":"my","containerName":"_get_binary_traces","kind":13,"name":"$trace_length","line":832,"definition":"my"},{"kind":13,"containerName":"_get_binary_traces","name":"$traceobj","line":832},{"containerName":"_get_binary_traces","kind":12,"name":"trace_length","line":832},{"name":"$current","containerName":"_get_binary_traces","kind":13,"line":833},{"kind":13,"containerName":"_get_binary_traces","name":"$current","line":833},{"line":833,"kind":13,"containerName":"_get_binary_traces","name":"$trace_length"},{"line":833,"name":"$current","containerName":"_get_binary_traces","kind":13},{"kind":13,"containerName":"_get_binary_traces","name":"@traces","line":835},{"name":"$traceobj","containerName":"_get_binary_traces","kind":13,"line":835},{"containerName":"_get_binary_traces","kind":12,"name":"trace_value_at","line":835},{"name":"$current","kind":13,"containerName":"_get_binary_traces","line":835},{"name":"$version","containerName":"_get_binary_traces","kind":13,"line":839},{"line":840,"localvar":"my","kind":13,"containerName":"_get_binary_traces","name":"$current_trace","definition":"my"},{"definition":"my","line":841,"name":"@trace","localvar":"my","kind":13,"containerName":"_get_binary_traces"},{"line":841,"name":"$traceobj","containerName":"_get_binary_traces","kind":13},{"line":841,"name":"trace","kind":12,"containerName":"_get_binary_traces"},{"name":"$current_trace","kind":13,"containerName":"_get_binary_traces","line":841},{"line":842,"name":"@trace","kind":13,"containerName":"_get_binary_traces"},{"line":847,"name":"$transformed","containerName":"_get_binary_traces","localvar":"my","kind":13,"definition":"my"},{"line":847,"containerName":"_get_binary_traces","kind":13,"name":"$self"},{"containerName":"_get_binary_traces","kind":12,"name":"_delta","line":847},{"name":"@trace","containerName":"_get_binary_traces","kind":13,"line":847},{"kind":13,"containerName":"_get_binary_traces","name":"$sample_size","line":848},{"line":849,"name":"$transformed","kind":13,"containerName":"_get_binary_traces"},{"containerName":"_get_binary_traces","kind":13,"name":"@traces","line":853},{"kind":13,"containerName":"_get_binary_traces","name":"$transformed","line":853}]},{"line":824,"name":"Bio","kind":12,"containerName":"Seq::Quality"},{"line":857,"kind":13,"containerName":null,"name":"%returner"},{"line":857,"kind":12,"name":"version"},{"line":857,"containerName":null,"kind":13,"name":"$version"},{"name":"%returner","kind":13,"containerName":null,"line":858},{"name":"string","kind":12,"line":858},{"line":858,"containerName":null,"kind":13,"name":"@traces"},{"definition":"my","line":859,"name":"$length_of_traces","kind":13,"localvar":"my","containerName":null},{"line":859,"name":"@traces","kind":13,"containerName":null},{"definition":"my","name":"$byte","containerName":null,"localvar":"my","kind":13,"line":860},{"kind":13,"containerName":null,"name":"%sample_size","line":861},{"containerName":null,"kind":13,"name":"%byte","line":861},{"containerName":null,"kind":13,"name":"$byte","line":861},{"line":864,"kind":13,"containerName":null,"name":"%returner"},{"line":864,"name":"binary","kind":12},{"name":"@traces","containerName":null,"kind":13,"line":864},{"kind":13,"containerName":null,"name":"%returner","line":865},{"line":865,"kind":12,"name":"length"},{"name":"CORE","containerName":"length","kind":12,"line":865},{"kind":13,"containerName":null,"name":"%returner","line":865},{"name":"binary","kind":12,"line":865},{"kind":13,"containerName":null,"name":"$returner","line":866},{"signature":{"parameters":[{"label":"$self"},{"label":"$version"},{"label":"$trace"},{"label":"$sample_size"}],"documentation":"","label":"_get_binary_bases($self,$version,$trace,$sample_size)"},"line":870,"range":{"start":{"line":870,"character":0},"end":{"line":891,"character":9999}},"kind":12,"definition":"sub","detail":"($self,$version,$trace,$sample_size)","children":[{"definition":"my","line":871,"localvar":"my","containerName":"_get_binary_bases","kind":13,"name":"$self"},{"name":"$version","containerName":"_get_binary_bases","kind":13,"line":871},{"line":871,"containerName":"_get_binary_bases","kind":13,"name":"$trace"},{"line":871,"name":"$sample_size","kind":13,"containerName":"_get_binary_bases"},{"line":872,"name":"$byte","containerName":"_get_binary_bases","localvar":"my","kind":13,"definition":"my"},{"name":"$sample_size","containerName":"_get_binary_bases","kind":13,"line":873},{"containerName":"_get_binary_bases","kind":13,"name":"$byte","line":873},{"containerName":"_get_binary_bases","kind":13,"name":"$byte","line":873},{"definition":"my","line":874,"localvar":"my","containerName":"_get_binary_bases","kind":13,"name":"$returner"},{"line":874,"name":"@current_row","kind":13,"containerName":"_get_binary_bases"},{"containerName":"_get_binary_bases","kind":13,"name":"$current_base","line":874},{"line":874,"name":"$string","containerName":"_get_binary_bases","kind":13},{"line":874,"kind":13,"containerName":"_get_binary_bases","name":"$binary"},{"definition":"my","localvar":"my","kind":13,"containerName":"_get_binary_bases","name":"$length","line":875},{"line":875,"name":"$trace","kind":13,"containerName":"_get_binary_bases"},{"name":"length","containerName":"_get_binary_bases","kind":12,"line":875},{"name":"$version","containerName":"_get_binary_bases","kind":13,"line":876},{"kind":13,"containerName":"_get_binary_bases","name":"$returner","line":877},{"line":878,"containerName":"_get_binary_bases","localvar":"my","kind":13,"name":"$current_base","definition":"my"},{"containerName":"_get_binary_bases","kind":13,"name":"$current_base","line":878},{"name":"$length","kind":13,"containerName":"_get_binary_bases","line":878},{"line":878,"containerName":"_get_binary_bases","kind":13,"name":"$current_base"},{"definition":"my","line":879,"containerName":"_get_binary_bases","localvar":"my","kind":13,"name":"@current_row"},{"line":880,"name":"@current_row","kind":13,"containerName":"_get_binary_bases"},{"kind":13,"containerName":"_get_binary_bases","name":"$trace","line":880},{"containerName":"_get_binary_bases","kind":12,"name":"peak_index_at","line":880},{"line":880,"kind":13,"containerName":"_get_binary_bases","name":"$current_base"},{"containerName":"_get_binary_bases","kind":13,"name":"@current_row","line":881},{"containerName":"_get_binary_bases","kind":13,"name":"$trace","line":881},{"line":881,"name":"accuracy_at","kind":12,"containerName":"_get_binary_bases"},{"line":881,"kind":13,"containerName":"_get_binary_bases","name":"$current_base"},{"containerName":"_get_binary_bases","kind":13,"name":"@current_row","line":882},{"line":882,"kind":13,"containerName":"_get_binary_bases","name":"$trace"},{"line":882,"name":"accuracy_at","containerName":"_get_binary_bases","kind":12},{"name":"$current_base","containerName":"_get_binary_bases","kind":13,"line":882},{"name":"@current_row","containerName":"_get_binary_bases","kind":13,"line":883},{"kind":13,"containerName":"_get_binary_bases","name":"$trace","line":883},{"containerName":"_get_binary_bases","kind":12,"name":"accuracy_at","line":883},{"line":883,"name":"$current_base","containerName":"_get_binary_bases","kind":13},{"kind":13,"containerName":"_get_binary_bases","name":"@current_row","line":884},{"name":"$trace","containerName":"_get_binary_bases","kind":13,"line":884},{"line":884,"name":"accuracy_at","containerName":"_get_binary_bases","kind":12},{"line":884,"name":"$current_base","containerName":"_get_binary_bases","kind":13},{"line":885,"name":"@current_row","kind":13,"containerName":"_get_binary_bases"},{"line":885,"containerName":"_get_binary_bases","kind":13,"name":"$trace"},{"line":885,"name":"baseat","kind":12,"containerName":"_get_binary_bases"},{"line":885,"name":"$current_base","kind":13,"containerName":"_get_binary_bases"},{"line":886,"containerName":"_get_binary_bases","kind":13,"name":"@current_row"},{"line":887,"name":"$returner","containerName":"_get_binary_bases","kind":13},{"line":887,"name":"@current_row","kind":13,"containerName":"_get_binary_bases"},{"kind":13,"containerName":"_get_binary_bases","name":"$returner","line":888},{"line":888,"name":"@current_row","kind":13,"containerName":"_get_binary_bases"},{"containerName":"_get_binary_bases","kind":13,"name":"$returner","line":890}],"name":"_get_binary_bases","containerName":"main::"},{"line":887,"name":"string","kind":12},{"line":888,"name":"binary","kind":12},{"line":893,"containerName":null,"kind":13,"name":"%returner"},{"line":894,"kind":13,"containerName":null,"name":"%returner"},{"kind":12,"name":"peak_indices","line":894},{"line":894,"name":"string","kind":12},{"line":894,"name":"$trace","containerName":null,"kind":13},{"kind":12,"containerName":"main::","name":"peak_indices","line":894},{"localvar":"my","containerName":null,"kind":13,"name":"$length","line":895,"definition":"my"},{"line":895,"kind":13,"containerName":null,"name":"%returner"},{"line":895,"name":"peak_indices","kind":12},{"line":895,"name":"string","kind":12},{"line":896,"containerName":null,"kind":13,"name":"%returner"},{"kind":12,"name":"peak_indices","line":896},{"line":896,"kind":12,"name":"binary"},{"name":"%returner","kind":13,"containerName":null,"line":897},{"kind":12,"name":"peak_indices","line":897},{"line":897,"kind":12,"name":"string"},{"line":898,"containerName":null,"kind":13,"name":"%returner"},{"kind":12,"name":"peak_indices","line":898},{"name":"length","kind":12,"line":898},{"containerName":"length","kind":12,"name":"CORE","line":899},{"line":899,"name":"%returner","kind":13,"containerName":null},{"name":"peak_indices","kind":12,"line":899},{"line":899,"name":"binary","kind":12},{"name":"@accuracies","localvar":"my","containerName":null,"kind":13,"line":900,"definition":"my"},{"definition":"my","line":901,"localvar":"my","containerName":null,"kind":13,"name":"%base"},{"name":"%returner","containerName":null,"kind":13,"line":902},{"kind":12,"name":"accuracies","line":902},{"kind":13,"containerName":null,"name":"$base","line":902},{"line":902,"containerName":null,"kind":13,"name":"$trace"},{"line":902,"name":"accuracies","containerName":"main::","kind":12},{"kind":13,"containerName":null,"name":"$base","line":902},{"name":"@accuracies","kind":13,"containerName":null,"line":903},{"name":"$trace","containerName":null,"kind":13,"line":903},{"kind":12,"containerName":"main::","name":"accuracies","line":903},{"name":"$base","containerName":null,"kind":13,"line":903},{"line":905,"containerName":null,"kind":13,"name":"%returner"},{"kind":12,"name":"sequence","line":905},{"line":905,"name":"$trace","kind":13,"containerName":null},{"line":905,"name":"seq","containerName":"main::","kind":12},{"kind":13,"containerName":null,"name":"$length","line":906},{"line":906,"name":"@accuracies","containerName":null,"kind":13},{"line":908,"kind":13,"containerName":null,"name":"%returner"},{"name":"accuracies","kind":12,"line":908},{"line":908,"kind":12,"name":"binary"},{"name":"@accuracies","containerName":null,"kind":13,"line":908},{"name":"%returner","containerName":null,"kind":13,"line":909},{"line":909,"name":"accuracies","kind":12},{"kind":12,"name":"length","line":909},{"name":"CORE","kind":12,"containerName":"length","line":910},{"line":910,"name":"%returner","kind":13,"containerName":null},{"kind":12,"name":"accuracies","line":910},{"line":910,"kind":12,"name":"binary"},{"line":911,"name":"$length","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$trace","line":911},{"name":"seq_obj","kind":12,"containerName":"main::","line":911},{"name":"length","containerName":"main::","kind":12,"line":911},{"name":"$count","containerName":null,"localvar":"my","kind":13,"line":912,"definition":"my"},{"kind":13,"containerName":null,"name":"$count","line":912},{"line":912,"name":"$length","containerName":null,"kind":13},{"line":912,"kind":13,"containerName":null,"name":"%count"},{"line":913,"name":"%returner","containerName":null,"kind":13},{"kind":12,"name":"reserved","line":913},{"line":913,"kind":12,"name":"string"},{"name":"$length","containerName":null,"kind":13,"line":916},{"line":916,"containerName":null,"kind":13,"name":"%returner"},{"name":"reserved","kind":12,"line":916},{"name":"string","kind":12,"line":916},{"name":"%returner","kind":13,"containerName":null,"line":918},{"name":"%returner","containerName":null,"kind":13,"line":919},{"line":919,"name":"reserved","kind":12},{"line":919,"kind":12,"name":"string"},{"line":920,"containerName":null,"kind":13,"name":"%returner"},{"line":921,"kind":12,"containerName":"length","name":"CORE"},{"name":"%returner","containerName":null,"kind":13,"line":921},{"definition":"my","line":923,"name":"@bases","localvar":"my","containerName":null,"kind":13},{"line":923,"kind":13,"containerName":null,"name":"$trace"},{"line":923,"containerName":"main::","kind":12,"name":"seq"},{"kind":13,"containerName":null,"name":"$length","line":924},{"kind":13,"containerName":null,"name":"$trace","line":924},{"name":"length","containerName":"main::","kind":12,"line":924},{"name":"%returner","containerName":null,"kind":13,"line":925},{"kind":13,"containerName":null,"name":"$trace","line":925},{"name":"seq","kind":12,"containerName":"main::","line":925},{"name":"%returner","kind":13,"containerName":null,"line":928},{"name":"peak_indices","kind":12,"line":928},{"name":"%returner","containerName":null,"kind":13,"line":929},{"kind":12,"name":"accuracies","line":929},{"containerName":null,"kind":13,"name":"%returner","line":930},{"line":930,"name":"bases","kind":12},{"name":"%returner","kind":13,"containerName":null,"line":931},{"line":931,"kind":12,"name":"reserved"},{"signature":{"parameters":[{"label":"$self"},{"label":"$version"}],"documentation":"__END__\n# $Id: scf.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::scf - .scf file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly. Use it via the Bio::SeqIO class, see\nL<Bio::SeqIO> for more information.\n\n=head1 DESCRIPTION\n\nThis object can transform .scf files to and from Bio::Seq::SequenceTrace\nobjects.  Mechanisms are present to retrieve trace data from scf\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chad Matsalla\n\nChad Matsalla\nbioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\nTony Cox, avc@sanger.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nNancy Hansen, nhansen at mail.nih.gov\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::scf;\nuse vars qw($DEFAULT_QUALITY);\nuse strict;\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SequenceTrace;\nuse Bio::Annotation::Comment;\nuse Dumpvalue;\n\nmy $dumper = new Dumpvalue();\n$dumper->veryCompact(1);\n\nBEGIN {\n    $DEFAULT_QUALITY= 10;\n}\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n                  (-verbose => $self->verbose(),\n                   -type => 'Bio::Seq::Quality'));\n  }\n  binmode $self->_fh; # for the Win32/Mac crowds  \n}\n\n=head2 next_seq()\n\n Title   : next_seq()\n Usage   : $scf = $stream->next_seq()\n Function: returns the next scf sequence in the stream\n Returns : a Bio::Seq::SequenceTrace object\n Args    : NONE\n Notes   : Fills the interface specification for SeqIO.\n            The SCF specification does not provide for having more then\n           one sequence in a given scf. So once the filehandle has been open\n           and passed to SeqIO do not expect to run this function more then\n           once on a given scf unless you embraced and extended the SCF\n       standard.  SCF comments are accessible through the Bio::SeqI\n           interface method annotation().\n\n\n#'\nsub next_seq {\n    my ($self) = @_;\n    my ($seq, $seqc, $fh, $buffer, $offset, $length, $read_bytes, @read,\n         %names);\n    # set up a filehandle to read in the scf\n    return if $self->{_readfile};\n    $fh = $self->_fh();\n    unless ($fh) {      # simulate the <> function\n        if ( !fileno(ARGV) or eof(ARGV) ) {\n            return unless my $ARGV = shift;\n            open(ARGV,$ARGV) or\n              $self->throw(\"Could not open $ARGV for SCF stream reading $!\");\n        }\n        $fh = \\*ARGV;\n    }\n    return unless read $fh, $buffer, 128; # no exception; probably end of file\n    # now, the master data structure will be the creator\n    my $creator;\n    # he first thing to do is parse the header. This is common\n    # among all versions of scf.\n    # the rest of the the information is different between the\n    # the different versions of scf.\n\n    $creator->{header} = $self->_get_header($buffer);\n    if ($creator->{header}->{'version'} lt \"3.00\") {\n        $self->debug(\"scf.pm is working with a version 2 scf.\\n\");\n        # first gather the trace information\n        $length = $creator->{header}->{'samples'} *\n          $creator->{header}->{sample_size}*4;\n        $buffer = $self->read_from_buffer($fh, $buffer, $length,\n                                                     $creator->{header}->{samples_offset});\n        # @read = unpack \"n$length\",$buffer;\n        # these traces need to be split\n        # returns a reference to a hash\n        $creator->{traces} = $self->_parse_v2_traces(\n                                                     $buffer,$creator->{header}->{sample_size});\n        # now go and get the base information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 12);\n        seek $fh,$offset,0;\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$creator->{header}->{bases_offset});\n        # now distill the information into its fractions.\n        # the old way : $self->_set_v2_bases($buffer);\n        # ref to an array, ref to a hash, string\n        ($creator->{peak_indices},\n         $creator->{qualities},\n         $creator->{sequence},\n         $creator->{accuracies}) = $self->_parse_v2_bases($buffer);\n\n    } else {\n        $self->debug(\"scf.pm is working with a version 3+ scf.\\n\");\n        my $transformed_read;\n        my $current_read_position = $creator->{header}->{sample_offset};\n        $length = $creator->{header}->{'samples'}*\n          $creator->{header}->{sample_size};\n        # $dumper->dumpValue($creator->{header});\n        foreach (qw(a c g t)) {\n            $buffer = $self->read_from_buffer($fh,$buffer,$length,$current_read_position);\n            my $byte = \"n\";\n            if ($creator->{header}->{sample_size} == 1) {\n                $byte = \"c\";\n            }\n            @read = unpack \"${byte}${length}\",$buffer;\n            # this little spurt of nonsense is because\n            # the trace values are given in the binary\n            # file as unsigned shorts but they really\n            # are signed deltas. 30000 is an arbitrary number\n            # (will there be any traces with a given\n            # point greater then 30000? I hope not.\n            # once the read is read, it must be changed\n            # from relative\n            foreach (@read) {\n                if ($_ > 30000) {\n                    $_ -= 65536;\n                }\n            }\n            $transformed_read = $self->_delta(\\@read,\"backward\");\n            # For 8-bit data we need to emulate a signed/unsigned\n            # cast that is implicit in the C implementations.....\n            if ($creator->{header}->{sample_size} == 1) {\n                foreach (@{$transformed_read}) {\n                    $_ += 256 if ($_ < 0);\n                }\n            }\n            $current_read_position += $length;\n            $creator->{'traces'}->{$_} = join(' ',@{$transformed_read});\n        }\n        \n        # now go and get the peak index information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 4);\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{peak_indices} = $self->_get_v3_peak_indices($buffer);\n        $offset += $length;\n        # now go and get the accuracy information\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{accuracies} = $self->_get_v3_base_accuracies($buffer);\n        # OK, now go and get the base information.\n        $offset += $length;\n        $length = $creator->{header}->{bases};\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{'sequence'} = unpack(\"a$length\",$buffer);\n        # now, finally, extract the calls from the accuracy information.\n        $creator->{qualities} = $self->_get_v3_quality(\n                                              $creator->{'sequence'},$creator->{accuracies});\n    }\n    # now go and get the comment information\n    $offset = $creator->{header}->{comments_offset};\n    seek $fh,$offset,0;\n    $length = $creator->{header}->{comment_size};\n    $buffer = $self->read_from_buffer($fh,$buffer,$length);\n    $creator->{comments} = $self->_get_comments($buffer);\n    my @name_comments = grep {$_->tagname() eq 'NAME'}\n                $creator->{comments}->get_Annotations('comment');\n    my $name_comment;\n    if (@name_comments){\n         $name_comment = $name_comments[0]->as_text();\n         $name_comment =~ s/^Comment:\\s+//;\n    }\n\n    my $swq = Bio::Seq::Quality->new(\n        -seq  =>   $creator->{'sequence'},\n        -qual =>    $creator->{'qualities'},\n        -id   =>    $name_comment\n                                              );\n    my $returner = Bio::Seq::SequenceTrace->new(\n                                           -swq      =>   $swq,\n                                            -trace_a  =>   $creator->{'traces'}->{'a'},\n                                            -trace_t  =>   $creator->{'traces'}->{'t'},\n                                           -trace_g  =>   $creator->{'traces'}->{'g'},\n                                           -trace_c  =>   $creator->{'traces'}->{'c'},\n                                       -accuracy_a    => $creator->{'accuracies'}->{'a'},\n                                   -accuracy_t    => $creator->{'accuracies'}->{'t'},\n                                      -accuracy_g    => $creator->{'accuracies'}->{'g'},\n                                    -accuracy_c    => $creator->{'accuracies'}->{'c'},\n                                 -peak_indices  => $creator->{'peak_indices'}\n                                                             );\n\n        $returner->annotation($creator->{'comments'}); # add SCF comments\n    $self->{'_readfile'} = 1;\n    return $returner;\n}\n\n\n=head2 _get_v3_quality()\n\n Title   : _get_v3_quality()\n Usage   : $self->_get_v3_quality()\n Function: Set the base qualities from version3 scf\n Returns : Nothing. Alters $self.\n Args    : None.\n Notes   :\n\n\n#'\nsub _get_v3_quality {\n    my ($self,$sequence,$accuracies) = @_;\n    my @bases = split//,$sequence;\n    my (@qualities,$currbase,$currqual,$counter);\n    for ($counter=0; $counter <= $#bases ; $counter++) {\n    $currbase = lc($bases[$counter]);\n    if ($currbase eq \"a\") { $currqual = $accuracies->{'a'}->[$counter]; }\n    elsif ($currbase eq \"c\") { $currqual = $accuracies->{'c'}->[$counter]; }\n    elsif ($currbase eq \"g\") { $currqual = $accuracies->{'g'}->[$counter]; }\n    elsif ($currbase eq \"t\") { $currqual = $accuracies->{'t'}->[$counter]; }\n    else { $currqual = \"unknown\"; }\n    push @qualities,$currqual;\n    }\n    return \\@qualities;\n}\n\n=head2 _get_v3_peak_indices($buffer)\n\n Title   : _get_v3_peak_indices($buffer)\n Usage   : $self->_get_v3_peak_indices($buffer);\n Function: Unpacks the base accuracies for version3 scf\n Returns : Nothing. Alters $self\n Args    : A scalar containing binary data.\n Notes   :\n\n\nsub _get_v3_peak_indices {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my @read = unpack \"N$length\",$buffer;\n     return join(' ',@read);\n}\n\n=head2 _get_v3_base_accuracies($buffer)\n\n Title   : _get_v3_base_accuracies($buffer)\n Usage   : $self->_get_v3_base_accuracies($buffer)\n Function: Set the base accuracies for version 3 scf's\n Returns : Nothing. Alters $self.\n Args    : A scalar containing binary data.\n Notes   :\n\n\n#'\nsub _get_v3_base_accuracies {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my $qlength = $length/4;\n    my $offset = 0;\n    my (@qualities,@sorter,$counter,$round,$last_base,$accuracies,$currbase);\n    foreach $currbase (qw(a c g t)) {\n         my @read;\n         $last_base = $offset + $qlength;\n         for (;$offset < $last_base; $offset += $qlength) {\n                    # a bioperler (perhaps me?) changed the unpack string to include 'n' rather than 'C'\n                    # on 040322 I think that 'C' is correct. please email chad if you would like to accuse me of being incorrect\n              @read = unpack \"C$qlength\", substr($buffer,$offset,$qlength);\n              $accuracies->{$currbase} = \\@read;\n         }\n    }\n     return $accuracies;\n}\n\n\n=head2 _get_comments($buffer)\n\n Title   : _get_comments($buffer)\n Usage   : $self->_get_comments($buffer);\n Function: Gather the comments section from the scf and parse it into its\n            components.\n Returns : a Bio::Annotation::Collection object\n Args    : The buffer. It is expected that the buffer contains a binary\n            string for the comments section of an scf file according to\n            the scf file specifications.\n Notes   :\n\n\nsub _get_comments {\n    my ($self,$buffer) = @_;\n    my $comments = Bio::Annotation::Collection->new();\n    my $size = length($buffer);\n    my $comments_retrieved = unpack \"a$size\",$buffer;\n    $comments_retrieved =~ s/\\0//;\n    my @comments_split = split/\\n/,$comments_retrieved;\n    if (@comments_split) {\n        foreach (@comments_split) {\n            /(\\w+)=(.*)/;\n            if ($1 && $2) {\n                my ($tagname, $text) = ($1, $2);\n                my $comment_obj = Bio::Annotation::Comment->new(\n                                     -text => $text,\n                                     -tagname => $tagname);\n\n                $comments->add_Annotation('comment', $comment_obj);\n            }\n        }\n    }\n    $self->{'comments'} = $comments;\n    return $comments;\n}\n\n=head2 _get_header()\n\n Title   : _get_header($buffer)\n Usage   : $self->_get_header($buffer);\n Function: Gather the header section from the scf and parse it into its\n           components.\n Returns : Reference to a hash containing the header components.\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the header section of an scf file according to the\n           scf file specifications.\n Notes   : None.\n\n\nsub _get_header {\n    my ($self,$buffer) = @_;\n    my $header;\n    ($header->{'scf'},\n     $header->{'samples'},\n     $header->{'sample_offset'},\n     $header->{'bases'},\n     $header->{'bases_left_clip'},\n     $header->{'bases_right_clip'},\n     $header->{'bases_offset'},\n     $header->{'comment_size'},\n     $header->{'comments_offset'},\n     $header->{'version'},\n     $header->{'sample_size'},\n     $header->{'code_set'},\n     @{$header->{'header_spare'}} ) = unpack \"a4 NNNNNNNN a4 NN N20\", $buffer;\n\n    $self->{'header'} = $header;\n    return $header;\n}\n\n=head2 _parse_v2_bases($buffer)\n\n Title   : _parse_v2_bases($buffer)\n Usage   : $self->_parse_v2_bases($buffer);\n Function: Gather the bases section from the scf and parse it into its\n           components.\n Returns :\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the bases section of an scf file according to the\n           scf file specifications.\n Notes   : None.\n\n\nsub _parse_v2_bases {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my ($offset2,$currbuff,$currbase,$currqual,$sequence,@qualities,@indices);\n    my (@read,$harvester,$accuracies);\n    for ($offset2=0;$offset2<$length;$offset2+=12) {\n         @read = unpack \"N C C C C a C3\", substr($buffer,$offset2,$length);\n         push @indices,$read[0];\n         $currbase = lc($read[5]);\n         if ($currbase eq \"a\") { $currqual = $read[1]; }\n         elsif ($currbase eq \"c\") { $currqual = $read[2]; }\n         elsif ($currbase eq \"g\") { $currqual = $read[3]; }\n         elsif ($currbase eq \"t\") { $currqual = $read[4]; }\n         else { $currqual = \"UNKNOWN\"; }\n         push @{$accuracies->{\"a\"}},$read[1];\n         push @{$accuracies->{\"c\"}},$read[2];\n         push @{$accuracies->{\"g\"}},$read[3];\n         push @{$accuracies->{\"t\"}},$read[4];\n\n         $sequence .= $currbase;\n         push @qualities,$currqual;\n    }\n     return (\\@indices,\\@qualities,$sequence,$accuracies)\n}\n\n=head2 _parse_v2_traces(\\@traces_array)\n\n Title   : _pares_v2_traces(\\@traces_array)\n Usage   : $self->_parse_v2_traces(\\@traces_array);\n Function: Parses an scf Version2 trace array into its base components.\n Returns : Nothing. Modifies $self.\n Args    : A reference to an array of the unpacked traces section of an\n           scf version2 file.\n\n\nsub _parse_v2_traces {\n    my ($self,$buffer,$sample_size) = @_;\n     my $byte;\n     if ($sample_size == 1) { $byte = \"c\"; }\n     else { $byte = \"n\"; }\n     my $length = CORE::length($buffer);\n     my @read = unpack \"${byte}${length}\",$buffer;\n          # this will be an array to the reference holding the array\n     my $traces;\n     my $array = 0;\n     for (my $offset2 = 0; $offset2< scalar(@read); $offset2+=4) {\n              push @{$traces->{'a'}},$read[$offset2];\n              push @{$traces->{'t'}},$read[$offset2+1];\n              push @{$traces->{'g'}},$read[$offset2+3];\n              push @{$traces->{'c'}},$read[$offset2+2];\n    }\n    return $traces;\n}\n\n\nsub get_trace_deprecated_use_the_sequencetrace_object_instead {\n    # my ($self,$base_channel,$traces) = @_;\n    # $base_channel =~ tr/a-z/A-Z/;\n    # if ($base_channel !~ /A|T|G|C/) {\n    #   $self->throw(\"You tried to ask for a base channel that wasn't A,T,G, or C. Ask for one of those next time.\");\n    ##} elsif ($base_channel) {\n     #  my @temp = split(' ',$self->{'traces'}->{$base_channel});\n    #return \\@temp;\n    #}\n}\n\nsub _deprecated_get_peak_indices_deprecated_use_the_sequencetrace_object_instead {\n    my ($self) = shift;\n    my @temp = split(' ',$self->{'parsed'}->{'peak_indices'});\n    return \\@temp;\n}\n\n\n=head2 get_header()\n\n Title   : get_header()\n Usage   : %header = %{$obj->get_header()};\n Function: Return the header for this scf.\n Returns : A reference to a hash containing the header for this scf.\n Args    : None.\n Notes   :\n\n\nsub get_header {\n    my ($self) = shift;\n    return $self->{'header'};\n}\n\n=head2 get_comments()\n\n Title   : get_comments()\n Usage   : %comments = %{$obj->get_comments()};\n Function: Return the comments for this scf.\n Returns : A Bio::Annotation::Collection object\n Args    : None.\n Notes   :\n\n\nsub get_comments {\n    my ($self) = shift;\n    return $self->{'comments'};\n}\n\nsub _dump_traces_outgoing_deprecated_use_the_sequencetrace_object {\n    my ($self,$transformed) = @_;\n    my (@sA,@sT,@sG,@sC);\n    if ($transformed) {\n    @sA = @{$self->{'text'}->{'t_samples_a'}};\n    @sC = @{$self->{'text'}->{'t_samples_c'}};\n    @sG = @{$self->{'text'}->{'t_samples_g'}};\n    @sT = @{$self->{'text'}->{'t_samples_t'}};\n    }\n    else {\n    @sA = @{$self->{'text'}->{'samples_a'}};\n    @sC = @{$self->{'text'}->{'samples_c'}};\n    @sG = @{$self->{'text'}->{'samples_g'}};\n    @sT = @{$self->{'text'}->{'samples_t'}};\n    }\n    print (\"Count\\ta\\tc\\tg\\tt\\n\");\n    for (my $curr=0; $curr < scalar(@sG); $curr++) {\n    print(\"$curr\\t$sA[$curr]\\t$sC[$curr]\\t$sG[$curr]\\t$sT[$curr]\\n\");\n    }\n    return;\n}\n\nsub _dump_traces_incoming_deprecated_use_the_sequencetrace_object {\n    # my ($self) = @_;\n    # my (@sA,@sT,@sG,@sC);\n    # @sA = @{$self->{'traces'}->{'A'}};\n    # @sC = @{$self->{'traces'}->{'C'}};\n    # @sG = @{$self->{'traces'}->{'G'}};\n    # @sT = @{$self->{'traces'}->{'T'}};\n    # @sA = @{$self->get_trace('A')};\n    # @sC = @{$self->get_trace('C')};\n    # @sG = @{$self->get_trace('G')};\n    # @sT = @{$self->get_trace('t')};\n    # print (\"Count\\ta\\tc\\tg\\tt\\n\");\n    # for (my $curr=0; $curr < scalar(@sG); $curr++) {\n    #   print(\"$curr\\t$sA[$curr]\\t$sC[$curr]\\t$sG[$curr]\\t$sT[$curr]\\n\");\n    #}\n    #return;\n}\n\n=head2 write_seq\n\n Title   : write_seq(-target => $swq, <comments>)\n Usage   : $obj->write_seq(\n               -target => $swq,\n            -version => 2,\n            -CONV => \"Bioperl-Chads Mighty SCF writer.\");\n Function: Write out an scf.\n Returns : Nothing.\n Args    : Requires: a reference to a Bio::Seq::Quality object to form the\n           basis for the scf.\n       if -version is provided, it should be \"2\" or \"3\". A SCF of that\n       version will be written.\n       Any other arguments are assumed to be comments and are put into\n       the comments section of the scf. Read the specifications for scf\n       to decide what might be good to put in here.\n\n Notes   :\n          For best results, use a SequenceTrace object.\n          The things that you need to write an scf:\n          a) sequence\n          b) quality\n          c) peak indices\n          d) traces\n          - You _can_ write an scf with just a and b by passing in a\n               Bio::Seq::Quality object- false traces will be synthesized\n               for you.\n\n\nsub write_seq {\n    my ($self,%args) = @_;\n    my %comments;\n    my ($label,$arg);\n    my ($swq) = $self->_rearrange([qw(TARGET)], %args);\n     my $writer_fodder;\n     if (ref($swq) =~ /Bio::Seq::SequenceTrace|Bio::Seq::Quality/) {\n               if (ref($swq) eq \"Bio::Seq::Quality\") {\n                         # this means that the object *has no trace data*\n                         # we might as well synthesize some now, ok?\n                    $swq = Bio::Seq::SequenceTrace->new(\n                         -swq     =>   $swq\n                    );\n               }\n     }\n    else  {\n    $self->throw(\"You must pass a Bio::Seq::Quality or a Bio::Seq::SequenceTrace object to write_seq as a parameter named \\\"target\\\"\");\n    }\n          # all of the rest of the arguments are comments for the scf\n    foreach $arg (sort keys %args) {\n    next if ($arg =~ /target/i);\n    ($label = $arg) =~ s/^\\-//;\n    $writer_fodder->{comments}->{$label} = $args{$arg};\n    }\n    if (!$comments{'NAME'}) { $comments{'NAME'} = $swq->id(); }\n          # HA! Bwahahahaha.\n    $writer_fodder->{comments}->{'CONV'} = \"Bioperl-Chads Mighty SCF writer.\" unless defined $comments{'CONV'};\n          # now deal with the version of scf they want to write\n    if ($writer_fodder->{comments}->{version}) {\n         if ($writer_fodder->{comments}->{version} != 2 && $writer_fodder->{comments}->{version} != 3) {\n              $self->warn(\"This module can only write version 2.0 or 3.0 scf's. Writing a version 2.0 scf by default.\");\n              $writer_fodder->{header}->{version} = \"2.00\";\n         }\n         elsif ($writer_fodder->{comments}->{'version'} > 2) {\n              $writer_fodder->{header}->{'version'} = \"3.00\";\n         }\n          else {\n               $writer_fodder->{header}->{version} = \"2\";\n          }\n    }\n    else {\n         $writer_fodder->{header}->{'version'} = \"3.00\";\n    }\n          # set a few things in the header\n    $writer_fodder->{'header'}->{'magic'} = \".scf\";\n    $writer_fodder->{'header'}->{'sample_size'} = \"2\";\n    $writer_fodder->{'header'}->{'bases'} = length($swq->seq());\n    $writer_fodder->{'header'}->{'bases_left_clip'} = \"0\";\n    $writer_fodder->{'header'}->{'bases_right_clip'} = \"0\";\n    $writer_fodder->{'header'}->{'sample_size'} = \"2\";\n    $writer_fodder->{'header'}->{'code_set'} = \"9\";\n    @{$writer_fodder->{'header'}->{'spare'}} = qw(0 0 0 0 0 0 0 0 0 0\n                     0 0 0 0 0 0 0 0 0 0);\n    $writer_fodder->{'header'}->{'samples_offset'} = \"128\";\n     $writer_fodder->{'header'}->{'samples'} = $swq->trace_length();\n          # create the binary for the comments and file it in writer_fodder\n    $writer_fodder->{comments} =  $self->_get_binary_comments(\n               $writer_fodder->{comments});\n          # create the binary and the strings for the traces, bases,\n          # offsets (if necessary), and accuracies (if necessary)\n    $writer_fodder->{traces} = $self->_get_binary_traces(\n               $writer_fodder->{'header'}->{'version'},\n               $swq,$writer_fodder->{'header'}->{'sample_size'});\n    my ($b_base_offsets,$b_base_accuracies,$samples_size,$bases_size);\n    #\n    # version 2\n    #\n    if ($writer_fodder->{'header'}->{'version'} == 2) {\n          $writer_fodder->{bases} = $self->_get_binary_bases(\n                         2,\n                         $swq,\n                         $writer_fodder->{'header'}->{'sample_size'});\n         $samples_size = CORE::length($writer_fodder->{traces}->{'binary'});\n         $bases_size = CORE::length($writer_fodder->{bases}->{binary});\n         $writer_fodder->{'header'}->{'bases_offset'} = 128 + $samples_size;\n         $writer_fodder->{'header'}->{'comments_offset'} = 128 +\n               $samples_size + $bases_size;\n         $writer_fodder->{'header'}->{'comments_size'} =\n               length($writer_fodder->{'comments'}->{binary});\n         $writer_fodder->{'header'}->{'private_size'} = \"0\";\n         $writer_fodder->{'header'}->{'private_offset'} = 128 +\n               $samples_size + $bases_size +\n               $writer_fodder->{'header'}->{'comments_size'};\n          $writer_fodder->{'header'}->{'binary'} =\n          $self->_get_binary_header($writer_fodder->{header});\n          $dumper->dumpValue($writer_fodder) if $self->verbose > 0;\n         $self->_print ($writer_fodder->{'header'}->{'binary'})\n               or print(\"Could not write binary header...\\n\");\n         $self->_print ($writer_fodder->{'traces'}->{'binary'})\n               or print(\"Could not write binary traces...\\n\");\n         $self->_print ($writer_fodder->{'bases'}->{'binary'})\n               or print(\"Could not write binary base structures...\\n\");\n         $self->_print ($writer_fodder->{'comments'}->{'binary'})\n               or print(\"Could not write binary comments...\\n\");\n    }\n    else {\n          ($writer_fodder->{peak_indices},\n           $writer_fodder->{accuracies},\n           $writer_fodder->{bases},\n           $writer_fodder->{reserved} ) =\n               $self->_get_binary_bases(\n                    3,\n                    $swq,\n                    $writer_fodder->{'header'}->{'sample_size'}\n               );\n         $writer_fodder->{'header'}->{'bases_offset'} = 128 +\n               length($writer_fodder->{'traces'}->{'binary'});\n         $writer_fodder->{'header'}->{'comments_size'} =\n               length($writer_fodder->{'comments'}->{'binary'});\n              # this is:\n              # bases_offset + base_offsets + accuracies + called_bases +\n               # reserved\n         $writer_fodder->{'header'}->{'private_size'} = \"0\";\n\n         $writer_fodder->{'header'}->{'comments_offset'} =\n              128+length($writer_fodder->{'traces'}->{'binary'})+\n                 length($writer_fodder->{'peak_indices'}->{'binary'})+\n                 length($writer_fodder->{'accuracies'}->{'binary'})+\n                length($writer_fodder->{'bases'}->{'binary'})+\n                length($writer_fodder->{'reserved'}->{'binary'});\n    $writer_fodder->{'header'}->{'private_offset'} =\n          $writer_fodder->{'header'}->{'comments_offset'} +\n               $writer_fodder->{'header'}->{'comments_size'};\n    $writer_fodder->{'header'}->{'spare'}->[1] =\n         $writer_fodder->{'header'}->{'comments_offset'} +\n             length($writer_fodder->{'comments'}->{'binary'});\n     $writer_fodder->{header}->{binary} =\n          $self->_get_binary_header($writer_fodder->{header});\n    $self->_print ($writer_fodder->{'header'}->{'binary'})\n          or print(\"Couldn't write header\\n\");\n    $self->_print ($writer_fodder->{'traces'}->{'binary'})\n          or print(\"Couldn't write samples\\n\");\n    $self->_print ($writer_fodder->{'peak_indices'}->{'binary'})\n          or print(\"Couldn't write peak offsets\\n\");\n    $self->_print ($writer_fodder->{'accuracies'}->{'binary'})\n          or print(\"Couldn't write accuracies\\n\");\n    $self->_print ($writer_fodder->{'bases'}->{'binary'})\n          or print(\"Couldn't write called_bases\\n\");\n    $self->_print ($writer_fodder->{'reserved'}->{'binary'})\n          or print(\"Couldn't write reserved\\n\");\n    $self->_print ($writer_fodder->{'comments'}->{'binary'})\n          or print (\"Couldn't write comments\\n\");\n    }\n\n    # kinda unnecessary, given the close() below, but maybe that'll go\n    # away someday.\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n\n    $self->close();\n    return 1;\n}\n\n\n\n\n\n=head2 _get_binary_header()\n\n Title   : _get_binary_header();\n Usage   : $self->_get_binary_header();\n Function: Provide the binary string that will be used as the header for\n            a scfv2 document.\n Returns : A binary string.\n Args    : None. Uses the entries in the $self->{'header'} hash. These\n            are set on construction of the object (hopefully correctly!).\n Notes   :\n\n\nsub _get_binary_header {\n    my ($self,$header) = @_;\n    my $binary = pack \"a4 NNNNNNNN a4 NN N20\",\n    (\n     $header->{'magic'},\n     $header->{'samples'},\n     $header->{'samples_offset'},\n     $header->{'bases'},\n     $header->{'bases_left_clip'},\n     $header->{'bases_right_clip'},\n     $header->{'bases_offset'},\n     $header->{'comments_size'},\n     $header->{'comments_offset'},\n     $header->{'version'},\n     $header->{'sample_size'},\n     $header->{'code_set'},\n     @{$header->{'spare'}}\n     );\n    return $binary;\n}\n\n=head2 _get_binary_traces($version,$ref)\n\n Title   : _set_binary_tracesbases($version,$ref)\n Usage   : $self->_set_binary_tracesbases($version,$ref);\n Function: Constructs the trace and base strings for all scfs\n Returns : Nothing. Alters self.\n Args    : $version - \"2\" or \"3\"\n       $sequence - a scalar containing arbitrary sequence data\n       $ref - a reference to either a SequenceTraces or a\n          SequenceWithQuality object.\n Notes   : This is a really complicated thing.\n\n\nsub _get_binary_traces {\n    my ($self,$version,$ref,$sample_size) = @_;\n          # ref _should_ be a Bio::Seq::SequenceTrace, but might be a\n          # Bio::Seq::Quality\n     my $returner;\n     my $sequence = $ref->seq();\n     my $sequence_length = length($sequence);\n          # first of all, do we need to synthesize the trace?\n          # if so, call synthesize_base\n     my ($traceobj,@traces,$current);\n     if ( ref($ref) eq \"Bio::Seq::Quality\" ) {\n          $traceobj = Bio::Seq::Quality->new(\n               -target   =>   $ref\n          );\n          $traceobj->_synthesize_traces();\n     }\n     else {\n          $traceobj = $ref;\n          if ($version eq \"2\") {\n               my $trace_length = $traceobj->trace_length();\n               for ($current = 1; $current <= $trace_length; $current++) {\n                    foreach (qw(a c g t)) {\n                         push @traces,$traceobj->trace_value_at($_,$current);\n                    }\n               }\n          }\n          elsif ($version == 3) {\n               foreach my $current_trace (qw(a c g t)) {\n                    my @trace = @{$traceobj->trace($current_trace)};\n                    foreach (@trace) {\n                         if ($_ > 30000) {\n                              $_ -= 65536;\n                         }\n                    }\n                    my $transformed = $self->_delta(\\@trace,\"forward\");\n                    if($sample_size == 1){\n                         foreach (@{$transformed}) {\n                              $_ += 256 if ($_ < 0);\n                         }\n                    }\n                    push @traces,@{$transformed};\n               }\n          }\n     }\n     $returner->{version} = $version;\n     $returner->{string} = \\@traces;\n     my $length_of_traces = scalar(@traces);\n     my $byte;\n     if ($sample_size == 1) { $byte = \"c\"; } else { $byte = \"n\"; }\n          # an unsigned integer should be I, but this is too long\n          #\n     $returner->{binary} = pack \"n${length_of_traces}\",@traces;\n     $returner->{length} = CORE::length($returner->{binary});\n     return $returner;\n}\n\n\nsub _get_binary_bases {\n     my ($self,$version,$trace,$sample_size) = @_;\n     my $byte;\n     if ($sample_size == 1) { $byte = \"c\"; } else { $byte = \"n\"; }\n     my ($returner,@current_row,$current_base,$string,$binary);\n     my $length = $trace->length();\n     if ($version == 2) {\n          $returner->{'version'} = \"2\";\n         for (my $current_base =1; $current_base <= $length; $current_base++) {\n               my @current_row;\n               push @current_row,$trace->peak_index_at($current_base);\n               push @current_row,$trace->accuracy_at(\"a\",$current_base);\n               push @current_row,$trace->accuracy_at(\"c\",$current_base);\n               push @current_row,$trace->accuracy_at(\"g\",$current_base);\n               push @current_row,$trace->accuracy_at(\"t\",$current_base);\n               push @current_row,$trace->baseat($current_base);\n               push @current_row,0,0,0;\n               push @{$returner->{string}},@current_row;\n               $returner->{binary} .= pack \"N C C C C a C3\",@current_row;\n          }\n          return $returner;\n     }\n     else {\n          $returner->{'version'} = \"3.00\";\n          $returner->{peak_indices}->{string} = $trace->peak_indices();\n          my $length = scalar(@{$returner->{peak_indices}->{string}});\n          $returner->{peak_indices}->{binary} =\n               pack \"N$length\",@{$returner->{peak_indices}->{string}};\n          $returner->{peak_indices}->{length} =\n               CORE::length($returner->{peak_indices}->{binary});\n          my @accuracies;\n          foreach my $base (qw(a c g t)) {\n               $returner->{accuracies}->{$base} = $trace->accuracies($base);\n               push @accuracies,@{$trace->accuracies($base)};\n          }\n          $returner->{sequence} = $trace->seq();\n          $length = scalar(@accuracies);\n               # this really is \"c\" for samplesize == 2\n          $returner->{accuracies}->{binary} = pack \"C${length}\",@accuracies;\n          $returner->{accuracies}->{length} =\n               CORE::length($returner->{accuracies}->{binary});\n          $length = $trace->seq_obj()->length();\n          for (my $count=0; $count< $length; $count++) {\n               push @{$returner->{reserved}->{string}},0,0,0;\n          }\n     }\n     $length = scalar(@{$returner->{reserved}->{string}});\n               # this _must_ be \"c\"\n     $returner->{'reserved'}->{'binary'} =\n          pack \"c$length\",@{$returner->{reserved}->{string}};\n     $returner->{'reserved'}->{'length'} =\n          CORE::length($returner->{'reserved'}->{'binary'});\n          # $returner->{'bases'}->{'string'} = $trace->seq();\n     my @bases = split('',$trace->seq());\n     $length = $trace->length();\n     $returner->{'bases'}->{'binary'} = $trace->seq();\n          # print(\"Returning this:\\n\");\n          # $dumper->dumpValue($returner);\n     return ($returner->{peak_indices},\n             $returner->{accuracies},\n             $returner->{bases},\n             $returner->{reserved});\n\n}\n\n\n=head2 _make_trace_string($version)\n\n Title   : _make_trace_string($version)\n Usage   : $self->_make_trace_string($version)\n Function: Merges trace data for the four bases to produce an scf\n       trace string. _requires_ $version\n Returns : Nothing. Alters $self.\n Args    : $version - a version number. \"2\" or \"3\"\n Notes   :","label":"_make_trace_string($self,$version)"},"kind":12,"range":{"start":{"character":0,"line":948},"end":{"line":952,"character":9999}},"line":948,"detail":"($self,$version)","definition":"sub","containerName":"main::","name":"_make_trace_string","children":[{"line":949,"localvar":"my","containerName":"_make_trace_string","kind":13,"name":"$self","definition":"my"},{"line":949,"name":"$version","kind":13,"containerName":"_make_trace_string"},{"definition":"my","localvar":"my","kind":13,"containerName":"_make_trace_string","name":"@traces","line":950},{"line":951,"localvar":"my","containerName":"_make_trace_string","kind":13,"name":"@traces_view","definition":"my"},{"definition":"my","line":952,"localvar":"my","containerName":"_make_trace_string","kind":13,"name":"@as"},{"line":952,"kind":13,"containerName":"_make_trace_string","name":"$self"}]},{"definition":"my","line":953,"localvar":"my","containerName":null,"kind":13,"name":"@cs"},{"name":"%self","kind":13,"containerName":null,"line":953},{"definition":"my","name":"@gs","localvar":"my","kind":13,"containerName":null,"line":954},{"kind":13,"containerName":null,"name":"%self","line":954},{"definition":"my","line":955,"localvar":"my","containerName":null,"kind":13,"name":"@ts"},{"line":955,"name":"%self","kind":13,"containerName":null},{"name":"%version","containerName":null,"kind":13,"line":956},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"$curr","line":957},{"line":957,"name":"$curr","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"@as","line":957},{"containerName":null,"kind":13,"name":"%curr","line":957},{"kind":13,"containerName":null,"name":"@as","line":958},{"line":958,"name":"$curr","kind":13,"containerName":null},{"name":"$DEFAULT_QUALITY","kind":13,"containerName":null,"line":958},{"name":"@as","containerName":null,"kind":13,"line":958},{"name":"$curr","kind":13,"containerName":null,"line":958},{"line":959,"name":"@cs","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$curr","line":959},{"line":959,"name":"$DEFAULT_QUALITY","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"@cs","line":959},{"name":"$curr","kind":13,"containerName":null,"line":959},{"name":"@gs","kind":13,"containerName":null,"line":960},{"line":960,"name":"$curr","kind":13,"containerName":null},{"line":960,"name":"$DEFAULT_QUALITY","containerName":null,"kind":13},{"name":"@gs","kind":13,"containerName":null,"line":960},{"line":960,"name":"$curr","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"@ts","line":961},{"line":961,"name":"$curr","containerName":null,"kind":13},{"name":"$DEFAULT_QUALITY","kind":13,"containerName":null,"line":961},{"kind":13,"containerName":null,"name":"@ts","line":961},{"line":961,"containerName":null,"kind":13,"name":"$curr"},{"line":962,"name":"@traces","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"@as","line":962},{"line":962,"kind":13,"containerName":null,"name":"$curr"},{"line":962,"containerName":null,"kind":13,"name":"@cs"},{"containerName":null,"kind":13,"name":"$curr","line":962},{"name":"@gs","kind":13,"containerName":null,"line":962},{"containerName":null,"kind":13,"name":"$curr","line":962},{"line":962,"name":"@ts","containerName":null,"kind":13},{"name":"$curr","kind":13,"containerName":null,"line":962},{"name":"%version","kind":13,"containerName":null,"line":965},{"kind":13,"containerName":null,"name":"@traces","line":966},{"name":"@as","containerName":null,"kind":13,"line":966},{"line":966,"kind":13,"containerName":null,"name":"@cs"},{"containerName":null,"kind":13,"name":"@gs","line":966},{"kind":13,"containerName":null,"name":"@ts","line":966},{"containerName":null,"kind":13,"name":"$self","line":969},{"line":969,"containerName":"main::","kind":12,"name":"throw"},{"name":"$length","kind":13,"localvar":"my","containerName":null,"line":971,"definition":"my"},{"line":971,"name":"@traces","containerName":null,"kind":13},{"line":972,"name":"%self","containerName":null,"kind":13},{"line":972,"containerName":null,"kind":13,"name":"@traces"},{"signature":{"parameters":[{"label":"$self"},{"label":"$rcomments"}],"documentation":"__END__\n# $Id: scf.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::scf - .scf file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly. Use it via the Bio::SeqIO class, see\nL<Bio::SeqIO> for more information.\n\n=head1 DESCRIPTION\n\nThis object can transform .scf files to and from Bio::Seq::SequenceTrace\nobjects.  Mechanisms are present to retrieve trace data from scf\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chad Matsalla\n\nChad Matsalla\nbioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\nTony Cox, avc@sanger.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nNancy Hansen, nhansen at mail.nih.gov\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::scf;\nuse vars qw($DEFAULT_QUALITY);\nuse strict;\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SequenceTrace;\nuse Bio::Annotation::Comment;\nuse Dumpvalue;\n\nmy $dumper = new Dumpvalue();\n$dumper->veryCompact(1);\n\nBEGIN {\n    $DEFAULT_QUALITY= 10;\n}\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n                  (-verbose => $self->verbose(),\n                   -type => 'Bio::Seq::Quality'));\n  }\n  binmode $self->_fh; # for the Win32/Mac crowds  \n}\n\n=head2 next_seq()\n\n Title   : next_seq()\n Usage   : $scf = $stream->next_seq()\n Function: returns the next scf sequence in the stream\n Returns : a Bio::Seq::SequenceTrace object\n Args    : NONE\n Notes   : Fills the interface specification for SeqIO.\n            The SCF specification does not provide for having more then\n           one sequence in a given scf. So once the filehandle has been open\n           and passed to SeqIO do not expect to run this function more then\n           once on a given scf unless you embraced and extended the SCF\n       standard.  SCF comments are accessible through the Bio::SeqI\n           interface method annotation().\n\n\n#'\nsub next_seq {\n    my ($self) = @_;\n    my ($seq, $seqc, $fh, $buffer, $offset, $length, $read_bytes, @read,\n         %names);\n    # set up a filehandle to read in the scf\n    return if $self->{_readfile};\n    $fh = $self->_fh();\n    unless ($fh) {      # simulate the <> function\n        if ( !fileno(ARGV) or eof(ARGV) ) {\n            return unless my $ARGV = shift;\n            open(ARGV,$ARGV) or\n              $self->throw(\"Could not open $ARGV for SCF stream reading $!\");\n        }\n        $fh = \\*ARGV;\n    }\n    return unless read $fh, $buffer, 128; # no exception; probably end of file\n    # now, the master data structure will be the creator\n    my $creator;\n    # he first thing to do is parse the header. This is common\n    # among all versions of scf.\n    # the rest of the the information is different between the\n    # the different versions of scf.\n\n    $creator->{header} = $self->_get_header($buffer);\n    if ($creator->{header}->{'version'} lt \"3.00\") {\n        $self->debug(\"scf.pm is working with a version 2 scf.\\n\");\n        # first gather the trace information\n        $length = $creator->{header}->{'samples'} *\n          $creator->{header}->{sample_size}*4;\n        $buffer = $self->read_from_buffer($fh, $buffer, $length,\n                                                     $creator->{header}->{samples_offset});\n        # @read = unpack \"n$length\",$buffer;\n        # these traces need to be split\n        # returns a reference to a hash\n        $creator->{traces} = $self->_parse_v2_traces(\n                                                     $buffer,$creator->{header}->{sample_size});\n        # now go and get the base information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 12);\n        seek $fh,$offset,0;\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$creator->{header}->{bases_offset});\n        # now distill the information into its fractions.\n        # the old way : $self->_set_v2_bases($buffer);\n        # ref to an array, ref to a hash, string\n        ($creator->{peak_indices},\n         $creator->{qualities},\n         $creator->{sequence},\n         $creator->{accuracies}) = $self->_parse_v2_bases($buffer);\n\n    } else {\n        $self->debug(\"scf.pm is working with a version 3+ scf.\\n\");\n        my $transformed_read;\n        my $current_read_position = $creator->{header}->{sample_offset};\n        $length = $creator->{header}->{'samples'}*\n          $creator->{header}->{sample_size};\n        # $dumper->dumpValue($creator->{header});\n        foreach (qw(a c g t)) {\n            $buffer = $self->read_from_buffer($fh,$buffer,$length,$current_read_position);\n            my $byte = \"n\";\n            if ($creator->{header}->{sample_size} == 1) {\n                $byte = \"c\";\n            }\n            @read = unpack \"${byte}${length}\",$buffer;\n            # this little spurt of nonsense is because\n            # the trace values are given in the binary\n            # file as unsigned shorts but they really\n            # are signed deltas. 30000 is an arbitrary number\n            # (will there be any traces with a given\n            # point greater then 30000? I hope not.\n            # once the read is read, it must be changed\n            # from relative\n            foreach (@read) {\n                if ($_ > 30000) {\n                    $_ -= 65536;\n                }\n            }\n            $transformed_read = $self->_delta(\\@read,\"backward\");\n            # For 8-bit data we need to emulate a signed/unsigned\n            # cast that is implicit in the C implementations.....\n            if ($creator->{header}->{sample_size} == 1) {\n                foreach (@{$transformed_read}) {\n                    $_ += 256 if ($_ < 0);\n                }\n            }\n            $current_read_position += $length;\n            $creator->{'traces'}->{$_} = join(' ',@{$transformed_read});\n        }\n        \n        # now go and get the peak index information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 4);\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{peak_indices} = $self->_get_v3_peak_indices($buffer);\n        $offset += $length;\n        # now go and get the accuracy information\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{accuracies} = $self->_get_v3_base_accuracies($buffer);\n        # OK, now go and get the base information.\n        $offset += $length;\n        $length = $creator->{header}->{bases};\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{'sequence'} = unpack(\"a$length\",$buffer);\n        # now, finally, extract the calls from the accuracy information.\n        $creator->{qualities} = $self->_get_v3_quality(\n                                              $creator->{'sequence'},$creator->{accuracies});\n    }\n    # now go and get the comment information\n    $offset = $creator->{header}->{comments_offset};\n    seek $fh,$offset,0;\n    $length = $creator->{header}->{comment_size};\n    $buffer = $self->read_from_buffer($fh,$buffer,$length);\n    $creator->{comments} = $self->_get_comments($buffer);\n    my @name_comments = grep {$_->tagname() eq 'NAME'}\n                $creator->{comments}->get_Annotations('comment');\n    my $name_comment;\n    if (@name_comments){\n         $name_comment = $name_comments[0]->as_text();\n         $name_comment =~ s/^Comment:\\s+//;\n    }\n\n    my $swq = Bio::Seq::Quality->new(\n        -seq  =>   $creator->{'sequence'},\n        -qual =>    $creator->{'qualities'},\n        -id   =>    $name_comment\n                                              );\n    my $returner = Bio::Seq::SequenceTrace->new(\n                                           -swq      =>   $swq,\n                                            -trace_a  =>   $creator->{'traces'}->{'a'},\n                                            -trace_t  =>   $creator->{'traces'}->{'t'},\n                                           -trace_g  =>   $creator->{'traces'}->{'g'},\n                                           -trace_c  =>   $creator->{'traces'}->{'c'},\n                                       -accuracy_a    => $creator->{'accuracies'}->{'a'},\n                                   -accuracy_t    => $creator->{'accuracies'}->{'t'},\n                                      -accuracy_g    => $creator->{'accuracies'}->{'g'},\n                                    -accuracy_c    => $creator->{'accuracies'}->{'c'},\n                                 -peak_indices  => $creator->{'peak_indices'}\n                                                             );\n\n        $returner->annotation($creator->{'comments'}); # add SCF comments\n    $self->{'_readfile'} = 1;\n    return $returner;\n}\n\n\n=head2 _get_v3_quality()\n\n Title   : _get_v3_quality()\n Usage   : $self->_get_v3_quality()\n Function: Set the base qualities from version3 scf\n Returns : Nothing. Alters $self.\n Args    : None.\n Notes   :\n\n\n#'\nsub _get_v3_quality {\n    my ($self,$sequence,$accuracies) = @_;\n    my @bases = split//,$sequence;\n    my (@qualities,$currbase,$currqual,$counter);\n    for ($counter=0; $counter <= $#bases ; $counter++) {\n    $currbase = lc($bases[$counter]);\n    if ($currbase eq \"a\") { $currqual = $accuracies->{'a'}->[$counter]; }\n    elsif ($currbase eq \"c\") { $currqual = $accuracies->{'c'}->[$counter]; }\n    elsif ($currbase eq \"g\") { $currqual = $accuracies->{'g'}->[$counter]; }\n    elsif ($currbase eq \"t\") { $currqual = $accuracies->{'t'}->[$counter]; }\n    else { $currqual = \"unknown\"; }\n    push @qualities,$currqual;\n    }\n    return \\@qualities;\n}\n\n=head2 _get_v3_peak_indices($buffer)\n\n Title   : _get_v3_peak_indices($buffer)\n Usage   : $self->_get_v3_peak_indices($buffer);\n Function: Unpacks the base accuracies for version3 scf\n Returns : Nothing. Alters $self\n Args    : A scalar containing binary data.\n Notes   :\n\n\nsub _get_v3_peak_indices {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my @read = unpack \"N$length\",$buffer;\n     return join(' ',@read);\n}\n\n=head2 _get_v3_base_accuracies($buffer)\n\n Title   : _get_v3_base_accuracies($buffer)\n Usage   : $self->_get_v3_base_accuracies($buffer)\n Function: Set the base accuracies for version 3 scf's\n Returns : Nothing. Alters $self.\n Args    : A scalar containing binary data.\n Notes   :\n\n\n#'\nsub _get_v3_base_accuracies {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my $qlength = $length/4;\n    my $offset = 0;\n    my (@qualities,@sorter,$counter,$round,$last_base,$accuracies,$currbase);\n    foreach $currbase (qw(a c g t)) {\n         my @read;\n         $last_base = $offset + $qlength;\n         for (;$offset < $last_base; $offset += $qlength) {\n                    # a bioperler (perhaps me?) changed the unpack string to include 'n' rather than 'C'\n                    # on 040322 I think that 'C' is correct. please email chad if you would like to accuse me of being incorrect\n              @read = unpack \"C$qlength\", substr($buffer,$offset,$qlength);\n              $accuracies->{$currbase} = \\@read;\n         }\n    }\n     return $accuracies;\n}\n\n\n=head2 _get_comments($buffer)\n\n Title   : _get_comments($buffer)\n Usage   : $self->_get_comments($buffer);\n Function: Gather the comments section from the scf and parse it into its\n            components.\n Returns : a Bio::Annotation::Collection object\n Args    : The buffer. It is expected that the buffer contains a binary\n            string for the comments section of an scf file according to\n            the scf file specifications.\n Notes   :\n\n\nsub _get_comments {\n    my ($self,$buffer) = @_;\n    my $comments = Bio::Annotation::Collection->new();\n    my $size = length($buffer);\n    my $comments_retrieved = unpack \"a$size\",$buffer;\n    $comments_retrieved =~ s/\\0//;\n    my @comments_split = split/\\n/,$comments_retrieved;\n    if (@comments_split) {\n        foreach (@comments_split) {\n            /(\\w+)=(.*)/;\n            if ($1 && $2) {\n                my ($tagname, $text) = ($1, $2);\n                my $comment_obj = Bio::Annotation::Comment->new(\n                                     -text => $text,\n                                     -tagname => $tagname);\n\n                $comments->add_Annotation('comment', $comment_obj);\n            }\n        }\n    }\n    $self->{'comments'} = $comments;\n    return $comments;\n}\n\n=head2 _get_header()\n\n Title   : _get_header($buffer)\n Usage   : $self->_get_header($buffer);\n Function: Gather the header section from the scf and parse it into its\n           components.\n Returns : Reference to a hash containing the header components.\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the header section of an scf file according to the\n           scf file specifications.\n Notes   : None.\n\n\nsub _get_header {\n    my ($self,$buffer) = @_;\n    my $header;\n    ($header->{'scf'},\n     $header->{'samples'},\n     $header->{'sample_offset'},\n     $header->{'bases'},\n     $header->{'bases_left_clip'},\n     $header->{'bases_right_clip'},\n     $header->{'bases_offset'},\n     $header->{'comment_size'},\n     $header->{'comments_offset'},\n     $header->{'version'},\n     $header->{'sample_size'},\n     $header->{'code_set'},\n     @{$header->{'header_spare'}} ) = unpack \"a4 NNNNNNNN a4 NN N20\", $buffer;\n\n    $self->{'header'} = $header;\n    return $header;\n}\n\n=head2 _parse_v2_bases($buffer)\n\n Title   : _parse_v2_bases($buffer)\n Usage   : $self->_parse_v2_bases($buffer);\n Function: Gather the bases section from the scf and parse it into its\n           components.\n Returns :\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the bases section of an scf file according to the\n           scf file specifications.\n Notes   : None.\n\n\nsub _parse_v2_bases {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my ($offset2,$currbuff,$currbase,$currqual,$sequence,@qualities,@indices);\n    my (@read,$harvester,$accuracies);\n    for ($offset2=0;$offset2<$length;$offset2+=12) {\n         @read = unpack \"N C C C C a C3\", substr($buffer,$offset2,$length);\n         push @indices,$read[0];\n         $currbase = lc($read[5]);\n         if ($currbase eq \"a\") { $currqual = $read[1]; }\n         elsif ($currbase eq \"c\") { $currqual = $read[2]; }\n         elsif ($currbase eq \"g\") { $currqual = $read[3]; }\n         elsif ($currbase eq \"t\") { $currqual = $read[4]; }\n         else { $currqual = \"UNKNOWN\"; }\n         push @{$accuracies->{\"a\"}},$read[1];\n         push @{$accuracies->{\"c\"}},$read[2];\n         push @{$accuracies->{\"g\"}},$read[3];\n         push @{$accuracies->{\"t\"}},$read[4];\n\n         $sequence .= $currbase;\n         push @qualities,$currqual;\n    }\n     return (\\@indices,\\@qualities,$sequence,$accuracies)\n}\n\n=head2 _parse_v2_traces(\\@traces_array)\n\n Title   : _pares_v2_traces(\\@traces_array)\n Usage   : $self->_parse_v2_traces(\\@traces_array);\n Function: Parses an scf Version2 trace array into its base components.\n Returns : Nothing. Modifies $self.\n Args    : A reference to an array of the unpacked traces section of an\n           scf version2 file.\n\n\nsub _parse_v2_traces {\n    my ($self,$buffer,$sample_size) = @_;\n     my $byte;\n     if ($sample_size == 1) { $byte = \"c\"; }\n     else { $byte = \"n\"; }\n     my $length = CORE::length($buffer);\n     my @read = unpack \"${byte}${length}\",$buffer;\n          # this will be an array to the reference holding the array\n     my $traces;\n     my $array = 0;\n     for (my $offset2 = 0; $offset2< scalar(@read); $offset2+=4) {\n              push @{$traces->{'a'}},$read[$offset2];\n              push @{$traces->{'t'}},$read[$offset2+1];\n              push @{$traces->{'g'}},$read[$offset2+3];\n              push @{$traces->{'c'}},$read[$offset2+2];\n    }\n    return $traces;\n}\n\n\nsub get_trace_deprecated_use_the_sequencetrace_object_instead {\n    # my ($self,$base_channel,$traces) = @_;\n    # $base_channel =~ tr/a-z/A-Z/;\n    # if ($base_channel !~ /A|T|G|C/) {\n    #   $self->throw(\"You tried to ask for a base channel that wasn't A,T,G, or C. Ask for one of those next time.\");\n    ##} elsif ($base_channel) {\n     #  my @temp = split(' ',$self->{'traces'}->{$base_channel});\n    #return \\@temp;\n    #}\n}\n\nsub _deprecated_get_peak_indices_deprecated_use_the_sequencetrace_object_instead {\n    my ($self) = shift;\n    my @temp = split(' ',$self->{'parsed'}->{'peak_indices'});\n    return \\@temp;\n}\n\n\n=head2 get_header()\n\n Title   : get_header()\n Usage   : %header = %{$obj->get_header()};\n Function: Return the header for this scf.\n Returns : A reference to a hash containing the header for this scf.\n Args    : None.\n Notes   :\n\n\nsub get_header {\n    my ($self) = shift;\n    return $self->{'header'};\n}\n\n=head2 get_comments()\n\n Title   : get_comments()\n Usage   : %comments = %{$obj->get_comments()};\n Function: Return the comments for this scf.\n Returns : A Bio::Annotation::Collection object\n Args    : None.\n Notes   :\n\n\nsub get_comments {\n    my ($self) = shift;\n    return $self->{'comments'};\n}\n\nsub _dump_traces_outgoing_deprecated_use_the_sequencetrace_object {\n    my ($self,$transformed) = @_;\n    my (@sA,@sT,@sG,@sC);\n    if ($transformed) {\n    @sA = @{$self->{'text'}->{'t_samples_a'}};\n    @sC = @{$self->{'text'}->{'t_samples_c'}};\n    @sG = @{$self->{'text'}->{'t_samples_g'}};\n    @sT = @{$self->{'text'}->{'t_samples_t'}};\n    }\n    else {\n    @sA = @{$self->{'text'}->{'samples_a'}};\n    @sC = @{$self->{'text'}->{'samples_c'}};\n    @sG = @{$self->{'text'}->{'samples_g'}};\n    @sT = @{$self->{'text'}->{'samples_t'}};\n    }\n    print (\"Count\\ta\\tc\\tg\\tt\\n\");\n    for (my $curr=0; $curr < scalar(@sG); $curr++) {\n    print(\"$curr\\t$sA[$curr]\\t$sC[$curr]\\t$sG[$curr]\\t$sT[$curr]\\n\");\n    }\n    return;\n}\n\nsub _dump_traces_incoming_deprecated_use_the_sequencetrace_object {\n    # my ($self) = @_;\n    # my (@sA,@sT,@sG,@sC);\n    # @sA = @{$self->{'traces'}->{'A'}};\n    # @sC = @{$self->{'traces'}->{'C'}};\n    # @sG = @{$self->{'traces'}->{'G'}};\n    # @sT = @{$self->{'traces'}->{'T'}};\n    # @sA = @{$self->get_trace('A')};\n    # @sC = @{$self->get_trace('C')};\n    # @sG = @{$self->get_trace('G')};\n    # @sT = @{$self->get_trace('t')};\n    # print (\"Count\\ta\\tc\\tg\\tt\\n\");\n    # for (my $curr=0; $curr < scalar(@sG); $curr++) {\n    #   print(\"$curr\\t$sA[$curr]\\t$sC[$curr]\\t$sG[$curr]\\t$sT[$curr]\\n\");\n    #}\n    #return;\n}\n\n=head2 write_seq\n\n Title   : write_seq(-target => $swq, <comments>)\n Usage   : $obj->write_seq(\n               -target => $swq,\n            -version => 2,\n            -CONV => \"Bioperl-Chads Mighty SCF writer.\");\n Function: Write out an scf.\n Returns : Nothing.\n Args    : Requires: a reference to a Bio::Seq::Quality object to form the\n           basis for the scf.\n       if -version is provided, it should be \"2\" or \"3\". A SCF of that\n       version will be written.\n       Any other arguments are assumed to be comments and are put into\n       the comments section of the scf. Read the specifications for scf\n       to decide what might be good to put in here.\n\n Notes   :\n          For best results, use a SequenceTrace object.\n          The things that you need to write an scf:\n          a) sequence\n          b) quality\n          c) peak indices\n          d) traces\n          - You _can_ write an scf with just a and b by passing in a\n               Bio::Seq::Quality object- false traces will be synthesized\n               for you.\n\n\nsub write_seq {\n    my ($self,%args) = @_;\n    my %comments;\n    my ($label,$arg);\n    my ($swq) = $self->_rearrange([qw(TARGET)], %args);\n     my $writer_fodder;\n     if (ref($swq) =~ /Bio::Seq::SequenceTrace|Bio::Seq::Quality/) {\n               if (ref($swq) eq \"Bio::Seq::Quality\") {\n                         # this means that the object *has no trace data*\n                         # we might as well synthesize some now, ok?\n                    $swq = Bio::Seq::SequenceTrace->new(\n                         -swq     =>   $swq\n                    );\n               }\n     }\n    else  {\n    $self->throw(\"You must pass a Bio::Seq::Quality or a Bio::Seq::SequenceTrace object to write_seq as a parameter named \\\"target\\\"\");\n    }\n          # all of the rest of the arguments are comments for the scf\n    foreach $arg (sort keys %args) {\n    next if ($arg =~ /target/i);\n    ($label = $arg) =~ s/^\\-//;\n    $writer_fodder->{comments}->{$label} = $args{$arg};\n    }\n    if (!$comments{'NAME'}) { $comments{'NAME'} = $swq->id(); }\n          # HA! Bwahahahaha.\n    $writer_fodder->{comments}->{'CONV'} = \"Bioperl-Chads Mighty SCF writer.\" unless defined $comments{'CONV'};\n          # now deal with the version of scf they want to write\n    if ($writer_fodder->{comments}->{version}) {\n         if ($writer_fodder->{comments}->{version} != 2 && $writer_fodder->{comments}->{version} != 3) {\n              $self->warn(\"This module can only write version 2.0 or 3.0 scf's. Writing a version 2.0 scf by default.\");\n              $writer_fodder->{header}->{version} = \"2.00\";\n         }\n         elsif ($writer_fodder->{comments}->{'version'} > 2) {\n              $writer_fodder->{header}->{'version'} = \"3.00\";\n         }\n          else {\n               $writer_fodder->{header}->{version} = \"2\";\n          }\n    }\n    else {\n         $writer_fodder->{header}->{'version'} = \"3.00\";\n    }\n          # set a few things in the header\n    $writer_fodder->{'header'}->{'magic'} = \".scf\";\n    $writer_fodder->{'header'}->{'sample_size'} = \"2\";\n    $writer_fodder->{'header'}->{'bases'} = length($swq->seq());\n    $writer_fodder->{'header'}->{'bases_left_clip'} = \"0\";\n    $writer_fodder->{'header'}->{'bases_right_clip'} = \"0\";\n    $writer_fodder->{'header'}->{'sample_size'} = \"2\";\n    $writer_fodder->{'header'}->{'code_set'} = \"9\";\n    @{$writer_fodder->{'header'}->{'spare'}} = qw(0 0 0 0 0 0 0 0 0 0\n                     0 0 0 0 0 0 0 0 0 0);\n    $writer_fodder->{'header'}->{'samples_offset'} = \"128\";\n     $writer_fodder->{'header'}->{'samples'} = $swq->trace_length();\n          # create the binary for the comments and file it in writer_fodder\n    $writer_fodder->{comments} =  $self->_get_binary_comments(\n               $writer_fodder->{comments});\n          # create the binary and the strings for the traces, bases,\n          # offsets (if necessary), and accuracies (if necessary)\n    $writer_fodder->{traces} = $self->_get_binary_traces(\n               $writer_fodder->{'header'}->{'version'},\n               $swq,$writer_fodder->{'header'}->{'sample_size'});\n    my ($b_base_offsets,$b_base_accuracies,$samples_size,$bases_size);\n    #\n    # version 2\n    #\n    if ($writer_fodder->{'header'}->{'version'} == 2) {\n          $writer_fodder->{bases} = $self->_get_binary_bases(\n                         2,\n                         $swq,\n                         $writer_fodder->{'header'}->{'sample_size'});\n         $samples_size = CORE::length($writer_fodder->{traces}->{'binary'});\n         $bases_size = CORE::length($writer_fodder->{bases}->{binary});\n         $writer_fodder->{'header'}->{'bases_offset'} = 128 + $samples_size;\n         $writer_fodder->{'header'}->{'comments_offset'} = 128 +\n               $samples_size + $bases_size;\n         $writer_fodder->{'header'}->{'comments_size'} =\n               length($writer_fodder->{'comments'}->{binary});\n         $writer_fodder->{'header'}->{'private_size'} = \"0\";\n         $writer_fodder->{'header'}->{'private_offset'} = 128 +\n               $samples_size + $bases_size +\n               $writer_fodder->{'header'}->{'comments_size'};\n          $writer_fodder->{'header'}->{'binary'} =\n          $self->_get_binary_header($writer_fodder->{header});\n          $dumper->dumpValue($writer_fodder) if $self->verbose > 0;\n         $self->_print ($writer_fodder->{'header'}->{'binary'})\n               or print(\"Could not write binary header...\\n\");\n         $self->_print ($writer_fodder->{'traces'}->{'binary'})\n               or print(\"Could not write binary traces...\\n\");\n         $self->_print ($writer_fodder->{'bases'}->{'binary'})\n               or print(\"Could not write binary base structures...\\n\");\n         $self->_print ($writer_fodder->{'comments'}->{'binary'})\n               or print(\"Could not write binary comments...\\n\");\n    }\n    else {\n          ($writer_fodder->{peak_indices},\n           $writer_fodder->{accuracies},\n           $writer_fodder->{bases},\n           $writer_fodder->{reserved} ) =\n               $self->_get_binary_bases(\n                    3,\n                    $swq,\n                    $writer_fodder->{'header'}->{'sample_size'}\n               );\n         $writer_fodder->{'header'}->{'bases_offset'} = 128 +\n               length($writer_fodder->{'traces'}->{'binary'});\n         $writer_fodder->{'header'}->{'comments_size'} =\n               length($writer_fodder->{'comments'}->{'binary'});\n              # this is:\n              # bases_offset + base_offsets + accuracies + called_bases +\n               # reserved\n         $writer_fodder->{'header'}->{'private_size'} = \"0\";\n\n         $writer_fodder->{'header'}->{'comments_offset'} =\n              128+length($writer_fodder->{'traces'}->{'binary'})+\n                 length($writer_fodder->{'peak_indices'}->{'binary'})+\n                 length($writer_fodder->{'accuracies'}->{'binary'})+\n                length($writer_fodder->{'bases'}->{'binary'})+\n                length($writer_fodder->{'reserved'}->{'binary'});\n    $writer_fodder->{'header'}->{'private_offset'} =\n          $writer_fodder->{'header'}->{'comments_offset'} +\n               $writer_fodder->{'header'}->{'comments_size'};\n    $writer_fodder->{'header'}->{'spare'}->[1] =\n         $writer_fodder->{'header'}->{'comments_offset'} +\n             length($writer_fodder->{'comments'}->{'binary'});\n     $writer_fodder->{header}->{binary} =\n          $self->_get_binary_header($writer_fodder->{header});\n    $self->_print ($writer_fodder->{'header'}->{'binary'})\n          or print(\"Couldn't write header\\n\");\n    $self->_print ($writer_fodder->{'traces'}->{'binary'})\n          or print(\"Couldn't write samples\\n\");\n    $self->_print ($writer_fodder->{'peak_indices'}->{'binary'})\n          or print(\"Couldn't write peak offsets\\n\");\n    $self->_print ($writer_fodder->{'accuracies'}->{'binary'})\n          or print(\"Couldn't write accuracies\\n\");\n    $self->_print ($writer_fodder->{'bases'}->{'binary'})\n          or print(\"Couldn't write called_bases\\n\");\n    $self->_print ($writer_fodder->{'reserved'}->{'binary'})\n          or print(\"Couldn't write reserved\\n\");\n    $self->_print ($writer_fodder->{'comments'}->{'binary'})\n          or print (\"Couldn't write comments\\n\");\n    }\n\n    # kinda unnecessary, given the close() below, but maybe that'll go\n    # away someday.\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n\n    $self->close();\n    return 1;\n}\n\n\n\n\n\n=head2 _get_binary_header()\n\n Title   : _get_binary_header();\n Usage   : $self->_get_binary_header();\n Function: Provide the binary string that will be used as the header for\n            a scfv2 document.\n Returns : A binary string.\n Args    : None. Uses the entries in the $self->{'header'} hash. These\n            are set on construction of the object (hopefully correctly!).\n Notes   :\n\n\nsub _get_binary_header {\n    my ($self,$header) = @_;\n    my $binary = pack \"a4 NNNNNNNN a4 NN N20\",\n    (\n     $header->{'magic'},\n     $header->{'samples'},\n     $header->{'samples_offset'},\n     $header->{'bases'},\n     $header->{'bases_left_clip'},\n     $header->{'bases_right_clip'},\n     $header->{'bases_offset'},\n     $header->{'comments_size'},\n     $header->{'comments_offset'},\n     $header->{'version'},\n     $header->{'sample_size'},\n     $header->{'code_set'},\n     @{$header->{'spare'}}\n     );\n    return $binary;\n}\n\n=head2 _get_binary_traces($version,$ref)\n\n Title   : _set_binary_tracesbases($version,$ref)\n Usage   : $self->_set_binary_tracesbases($version,$ref);\n Function: Constructs the trace and base strings for all scfs\n Returns : Nothing. Alters self.\n Args    : $version - \"2\" or \"3\"\n       $sequence - a scalar containing arbitrary sequence data\n       $ref - a reference to either a SequenceTraces or a\n          SequenceWithQuality object.\n Notes   : This is a really complicated thing.\n\n\nsub _get_binary_traces {\n    my ($self,$version,$ref,$sample_size) = @_;\n          # ref _should_ be a Bio::Seq::SequenceTrace, but might be a\n          # Bio::Seq::Quality\n     my $returner;\n     my $sequence = $ref->seq();\n     my $sequence_length = length($sequence);\n          # first of all, do we need to synthesize the trace?\n          # if so, call synthesize_base\n     my ($traceobj,@traces,$current);\n     if ( ref($ref) eq \"Bio::Seq::Quality\" ) {\n          $traceobj = Bio::Seq::Quality->new(\n               -target   =>   $ref\n          );\n          $traceobj->_synthesize_traces();\n     }\n     else {\n          $traceobj = $ref;\n          if ($version eq \"2\") {\n               my $trace_length = $traceobj->trace_length();\n               for ($current = 1; $current <= $trace_length; $current++) {\n                    foreach (qw(a c g t)) {\n                         push @traces,$traceobj->trace_value_at($_,$current);\n                    }\n               }\n          }\n          elsif ($version == 3) {\n               foreach my $current_trace (qw(a c g t)) {\n                    my @trace = @{$traceobj->trace($current_trace)};\n                    foreach (@trace) {\n                         if ($_ > 30000) {\n                              $_ -= 65536;\n                         }\n                    }\n                    my $transformed = $self->_delta(\\@trace,\"forward\");\n                    if($sample_size == 1){\n                         foreach (@{$transformed}) {\n                              $_ += 256 if ($_ < 0);\n                         }\n                    }\n                    push @traces,@{$transformed};\n               }\n          }\n     }\n     $returner->{version} = $version;\n     $returner->{string} = \\@traces;\n     my $length_of_traces = scalar(@traces);\n     my $byte;\n     if ($sample_size == 1) { $byte = \"c\"; } else { $byte = \"n\"; }\n          # an unsigned integer should be I, but this is too long\n          #\n     $returner->{binary} = pack \"n${length_of_traces}\",@traces;\n     $returner->{length} = CORE::length($returner->{binary});\n     return $returner;\n}\n\n\nsub _get_binary_bases {\n     my ($self,$version,$trace,$sample_size) = @_;\n     my $byte;\n     if ($sample_size == 1) { $byte = \"c\"; } else { $byte = \"n\"; }\n     my ($returner,@current_row,$current_base,$string,$binary);\n     my $length = $trace->length();\n     if ($version == 2) {\n          $returner->{'version'} = \"2\";\n         for (my $current_base =1; $current_base <= $length; $current_base++) {\n               my @current_row;\n               push @current_row,$trace->peak_index_at($current_base);\n               push @current_row,$trace->accuracy_at(\"a\",$current_base);\n               push @current_row,$trace->accuracy_at(\"c\",$current_base);\n               push @current_row,$trace->accuracy_at(\"g\",$current_base);\n               push @current_row,$trace->accuracy_at(\"t\",$current_base);\n               push @current_row,$trace->baseat($current_base);\n               push @current_row,0,0,0;\n               push @{$returner->{string}},@current_row;\n               $returner->{binary} .= pack \"N C C C C a C3\",@current_row;\n          }\n          return $returner;\n     }\n     else {\n          $returner->{'version'} = \"3.00\";\n          $returner->{peak_indices}->{string} = $trace->peak_indices();\n          my $length = scalar(@{$returner->{peak_indices}->{string}});\n          $returner->{peak_indices}->{binary} =\n               pack \"N$length\",@{$returner->{peak_indices}->{string}};\n          $returner->{peak_indices}->{length} =\n               CORE::length($returner->{peak_indices}->{binary});\n          my @accuracies;\n          foreach my $base (qw(a c g t)) {\n               $returner->{accuracies}->{$base} = $trace->accuracies($base);\n               push @accuracies,@{$trace->accuracies($base)};\n          }\n          $returner->{sequence} = $trace->seq();\n          $length = scalar(@accuracies);\n               # this really is \"c\" for samplesize == 2\n          $returner->{accuracies}->{binary} = pack \"C${length}\",@accuracies;\n          $returner->{accuracies}->{length} =\n               CORE::length($returner->{accuracies}->{binary});\n          $length = $trace->seq_obj()->length();\n          for (my $count=0; $count< $length; $count++) {\n               push @{$returner->{reserved}->{string}},0,0,0;\n          }\n     }\n     $length = scalar(@{$returner->{reserved}->{string}});\n               # this _must_ be \"c\"\n     $returner->{'reserved'}->{'binary'} =\n          pack \"c$length\",@{$returner->{reserved}->{string}};\n     $returner->{'reserved'}->{'length'} =\n          CORE::length($returner->{'reserved'}->{'binary'});\n          # $returner->{'bases'}->{'string'} = $trace->seq();\n     my @bases = split('',$trace->seq());\n     $length = $trace->length();\n     $returner->{'bases'}->{'binary'} = $trace->seq();\n          # print(\"Returning this:\\n\");\n          # $dumper->dumpValue($returner);\n     return ($returner->{peak_indices},\n             $returner->{accuracies},\n             $returner->{bases},\n             $returner->{reserved});\n\n}\n\n\n=head2 _make_trace_string($version)\n\n Title   : _make_trace_string($version)\n Usage   : $self->_make_trace_string($version)\n Function: Merges trace data for the four bases to produce an scf\n       trace string. _requires_ $version\n Returns : Nothing. Alters $self.\n Args    : $version - a version number. \"2\" or \"3\"\n Notes   :\n\n\nsub _make_trace_string {\n    my ($self,$version) = @_;\n    my @traces;\n    my @traces_view;\n    my @as = @{$self->{'text'}->{'samples_a'}};\n    my @cs = @{$self->{'text'}->{'samples_c'}};\n    my @gs = @{$self->{'text'}->{'samples_g'}};\n    my @ts = @{$self->{'text'}->{'samples_t'}};\n    if ($version == 2) {\n        for (my $curr=0; $curr < scalar(@as); $curr++) {\n        $as[$curr] = $DEFAULT_QUALITY unless defined $as[$curr];\n        $cs[$curr] = $DEFAULT_QUALITY unless defined $cs[$curr];\n        $gs[$curr] = $DEFAULT_QUALITY unless defined $gs[$curr];\n        $ts[$curr] = $DEFAULT_QUALITY unless defined $ts[$curr];\n        push @traces,($as[$curr],$cs[$curr],$gs[$curr],$ts[$curr]);\n        }\n    }\n    elsif ($version == 3) {\n        @traces = (@as,@cs,@gs,@ts);\n    }\n    else {\n        $self->throw(\"No idea what version required to make traces here. You gave #$version#  Bailing.\");\n    }\n    my $length = scalar(@traces);\n    $self->{'text'}->{'samples_all'} = \\@traces;\n\n}\n\n=head2 _get_binary_comments(\\@comments)\n\n Title   : _get_binary_comments(\\@comments)\n Usage   : $self->_get_binary_comments(\\@comments);\n Function: Provide a binary string that will be the comments section of\n       the scf file. See the scf specifications for detailed\n       specifications for the comments section of an scf file. Hint:\n       CODE=something\\nBODE=something\\n\\0\n Returns :\n Args    : A reference to an array containing comments.\n Notes   : None.","label":"_get_binary_comments($self,$rcomments)"},"kind":12,"range":{"end":{"character":9999,"line":1005},"start":{"character":0,"line":990}},"line":990,"detail":"($self,$rcomments)","definition":"sub","name":"_get_binary_comments","containerName":"main::","children":[{"definition":"my","localvar":"my","containerName":"_get_binary_comments","kind":13,"name":"$self","line":991},{"containerName":"_get_binary_comments","kind":13,"name":"$rcomments","line":991},{"definition":"my","line":992,"kind":13,"localvar":"my","containerName":"_get_binary_comments","name":"$returner"},{"line":993,"name":"$comments_string","containerName":"_get_binary_comments","localvar":"my","kind":13,"definition":"my"},{"definition":"my","localvar":"my","containerName":"_get_binary_comments","kind":13,"name":"%comments","line":994},{"line":994,"kind":13,"containerName":"_get_binary_comments","name":"$rcomments"},{"name":"$key","containerName":"_get_binary_comments","localvar":"my","kind":13,"line":995,"definition":"my"},{"name":"%comments","containerName":"_get_binary_comments","kind":13,"line":995},{"kind":13,"containerName":"_get_binary_comments","name":"$comments","line":996},{"line":996,"name":"$key","containerName":"_get_binary_comments","kind":13},{"line":997,"containerName":"_get_binary_comments","kind":13,"name":"$comments_string"},{"kind":13,"containerName":"_get_binary_comments","name":"$comments_string","line":999},{"name":"$length","kind":13,"localvar":"my","containerName":"_get_binary_comments","line":1000,"definition":"my"},{"name":"$comments_string","kind":13,"containerName":"_get_binary_comments","line":1000},{"containerName":"_get_binary_comments","kind":13,"name":"$returner","line":1001},{"line":1001,"kind":13,"containerName":"_get_binary_comments","name":"$length"},{"line":1002,"name":"$returner","containerName":"_get_binary_comments","kind":13},{"name":"$comments_string","kind":13,"containerName":"_get_binary_comments","line":1002},{"line":1003,"kind":13,"containerName":"_get_binary_comments","name":"$returner"},{"line":1003,"name":"$comments_string","kind":13,"containerName":"_get_binary_comments"},{"line":1004,"kind":13,"containerName":"_get_binary_comments","name":"$returner"}]},{"line":1000,"name":"CORE","containerName":"length","kind":12},{"kind":12,"name":"length","line":1001},{"line":1002,"name":"string","kind":12},{"line":1003,"kind":12,"name":"binary"},{"name":"_delta","containerName":"main::","children":[{"kind":13,"localvar":"my","containerName":"_delta","name":"$self","line":1052,"definition":"my"},{"line":1052,"name":"$rsamples","containerName":"_delta","kind":13},{"line":1052,"name":"$direction","containerName":"_delta","kind":13},{"definition":"my","kind":13,"localvar":"my","containerName":"_delta","name":"@samples","line":1053},{"name":"$rsamples","containerName":"_delta","kind":13,"line":1053},{"definition":"my","line":1065,"localvar":"my","kind":13,"containerName":"_delta","name":"$i"},{"kind":13,"containerName":"_delta","name":"$num_samples","line":1065},{"name":"$p_delta","kind":13,"containerName":"_delta","line":1065},{"kind":13,"containerName":"_delta","name":"$p_sample","line":1065},{"kind":13,"containerName":"_delta","name":"@samples_converted","line":1065},{"line":1065,"containerName":"_delta","kind":13,"name":"$p_sample1"},{"line":1065,"kind":13,"containerName":"_delta","name":"$p_sample2"},{"line":1066,"name":"$SLOW_BUT_CLEAR","kind":13,"localvar":"my","containerName":"_delta","definition":"my"},{"name":"$num_samples","containerName":"_delta","kind":13,"line":1067},{"line":1067,"name":"@samples","containerName":"_delta","kind":13},{"kind":13,"containerName":"_delta","name":"$direction","line":1070},{"line":1071,"containerName":"_delta","kind":13,"name":"$SLOW_BUT_CLEAR"},{"line":1072,"name":"$p_delta","containerName":"_delta","kind":13},{"line":1073,"kind":13,"containerName":"_delta","name":"$i"},{"line":1073,"name":"$i","containerName":"_delta","kind":13},{"name":"$num_samples","containerName":"_delta","kind":13,"line":1073},{"line":1073,"name":"$i","containerName":"_delta","kind":13},{"line":1074,"containerName":"_delta","kind":13,"name":"$p_sample"},{"kind":13,"containerName":"_delta","name":"$samples","line":1074},{"line":1074,"name":"$i","containerName":"_delta","kind":13},{"kind":13,"containerName":"_delta","name":"$samples","line":1075},{"containerName":"_delta","kind":13,"name":"$i","line":1075},{"line":1075,"name":"$samples","containerName":"_delta","kind":13},{"line":1075,"kind":13,"containerName":"_delta","name":"$i"},{"line":1075,"name":"$p_delta","containerName":"_delta","kind":13},{"name":"$p_delta","kind":13,"containerName":"_delta","line":1076},{"kind":13,"containerName":"_delta","name":"$p_sample","line":1076},{"line":1078,"containerName":"_delta","kind":13,"name":"$p_delta"},{"line":1079,"kind":13,"containerName":"_delta","name":"$i"},{"name":"$i","containerName":"_delta","kind":13,"line":1079},{"line":1079,"name":"$num_samples","kind":13,"containerName":"_delta"},{"containerName":"_delta","kind":13,"name":"$i","line":1079},{"line":1080,"name":"$p_sample","containerName":"_delta","kind":13},{"line":1080,"name":"$samples","containerName":"_delta","kind":13},{"kind":13,"containerName":"_delta","name":"$i","line":1080},{"kind":13,"containerName":"_delta","name":"$samples","line":1081},{"line":1081,"name":"$i","containerName":"_delta","kind":13},{"name":"$samples","kind":13,"containerName":"_delta","line":1081},{"containerName":"_delta","kind":13,"name":"$i","line":1081},{"line":1081,"name":"$p_delta","kind":13,"containerName":"_delta"},{"line":1082,"kind":13,"containerName":"_delta","name":"$p_delta"},{"containerName":"_delta","kind":13,"name":"$p_sample","line":1082},{"kind":13,"containerName":"_delta","name":"$i","line":1085},{"name":"$num_samples","containerName":"_delta","kind":13,"line":1085},{"name":"$i","kind":13,"containerName":"_delta","line":1085},{"containerName":"_delta","kind":13,"name":"$i","line":1085},{"line":1086,"name":"$samples","containerName":"_delta","kind":13},{"kind":13,"containerName":"_delta","name":"$i","line":1086},{"line":1086,"kind":13,"containerName":"_delta","name":"$samples"},{"line":1086,"kind":13,"containerName":"_delta","name":"$i"},{"line":1086,"name":"$samples","kind":13,"containerName":"_delta"},{"line":1086,"kind":13,"containerName":"_delta","name":"$i"},{"line":1086,"kind":13,"containerName":"_delta","name":"$samples"},{"line":1086,"kind":13,"containerName":"_delta","name":"$i"},{"line":1088,"name":"$samples","kind":13,"containerName":"_delta"},{"line":1088,"name":"$samples","kind":13,"containerName":"_delta"},{"name":"$samples","kind":13,"containerName":"_delta","line":1088},{"kind":13,"containerName":"_delta","name":"$direction","line":1091},{"line":1092,"name":"$SLOW_BUT_CLEAR","kind":13,"containerName":"_delta"},{"name":"$p_sample","kind":13,"containerName":"_delta","line":1093},{"line":1094,"kind":13,"containerName":"_delta","name":"$i"},{"name":"$i","containerName":"_delta","kind":13,"line":1094},{"line":1094,"kind":13,"containerName":"_delta","name":"$num_samples"},{"name":"$i","containerName":"_delta","kind":13,"line":1094},{"kind":13,"containerName":"_delta","name":"$samples","line":1095},{"name":"$i","kind":13,"containerName":"_delta","line":1095},{"kind":13,"containerName":"_delta","name":"$samples","line":1095},{"line":1095,"name":"$i","kind":13,"containerName":"_delta"},{"name":"$p_sample","containerName":"_delta","kind":13,"line":1095},{"line":1096,"name":"$p_sample","kind":13,"containerName":"_delta"},{"line":1096,"name":"$samples","kind":13,"containerName":"_delta"},{"line":1096,"name":"$i","kind":13,"containerName":"_delta"},{"line":1098,"containerName":"_delta","kind":13,"name":"$p_sample"},{"name":"$i","containerName":"_delta","kind":13,"line":1099},{"kind":13,"containerName":"_delta","name":"$i","line":1099},{"line":1099,"name":"$num_samples","containerName":"_delta","kind":13},{"line":1099,"name":"$i","containerName":"_delta","kind":13},{"name":"$samples","kind":13,"containerName":"_delta","line":1100},{"name":"$i","containerName":"_delta","kind":13,"line":1100},{"line":1100,"containerName":"_delta","kind":13,"name":"$samples"},{"line":1100,"containerName":"_delta","kind":13,"name":"$i"},{"name":"$p_sample","containerName":"_delta","kind":13,"line":1100},{"name":"$p_sample","kind":13,"containerName":"_delta","line":1101},{"name":"$samples","containerName":"_delta","kind":13,"line":1101},{"line":1101,"kind":13,"containerName":"_delta","name":"$i"},{"line":1104,"containerName":"_delta","kind":13,"name":"$p_sample1"},{"name":"$p_sample2","containerName":"_delta","kind":13,"line":1104},{"kind":13,"containerName":"_delta","name":"$i","line":1105},{"line":1105,"containerName":"_delta","kind":13,"name":"$i"},{"kind":13,"containerName":"_delta","name":"$num_samples","line":1105},{"name":"$i","kind":13,"containerName":"_delta","line":1105},{"line":1106,"containerName":"_delta","kind":13,"name":"$p_sample1"},{"name":"$p_sample1","kind":13,"containerName":"_delta","line":1106},{"line":1106,"name":"$samples","containerName":"_delta","kind":13},{"name":"$i","kind":13,"containerName":"_delta","line":1106},{"line":1107,"containerName":"_delta","kind":13,"name":"$samples"},{"line":1107,"name":"$i","containerName":"_delta","kind":13},{"line":1107,"name":"$p_sample1","containerName":"_delta","kind":13},{"kind":13,"containerName":"_delta","name":"$p_sample2","line":1107},{"line":1108,"name":"$p_sample2","kind":13,"containerName":"_delta"},{"line":1108,"containerName":"_delta","kind":13,"name":"$samples"},{"kind":13,"containerName":"_delta","name":"$i","line":1108},{"name":"$self","containerName":"_delta","kind":13,"line":1114},{"line":1114,"name":"warn","kind":12,"containerName":"_delta"},{"name":"@samples","kind":13,"containerName":"_delta","line":1116}],"detail":"($self,$rsamples,$direction)","definition":"sub","range":{"start":{"character":0,"line":1051},"end":{"line":1117,"character":9999}},"kind":12,"line":1051,"signature":{"label":"_delta($self,$rsamples,$direction)","documentation":"__END__\n# $Id: scf.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::scf - .scf file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly. Use it via the Bio::SeqIO class, see\nL<Bio::SeqIO> for more information.\n\n=head1 DESCRIPTION\n\nThis object can transform .scf files to and from Bio::Seq::SequenceTrace\nobjects.  Mechanisms are present to retrieve trace data from scf\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chad Matsalla\n\nChad Matsalla\nbioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\nTony Cox, avc@sanger.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nNancy Hansen, nhansen at mail.nih.gov\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::scf;\nuse vars qw($DEFAULT_QUALITY);\nuse strict;\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SequenceTrace;\nuse Bio::Annotation::Comment;\nuse Dumpvalue;\n\nmy $dumper = new Dumpvalue();\n$dumper->veryCompact(1);\n\nBEGIN {\n    $DEFAULT_QUALITY= 10;\n}\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n                  (-verbose => $self->verbose(),\n                   -type => 'Bio::Seq::Quality'));\n  }\n  binmode $self->_fh; # for the Win32/Mac crowds  \n}\n\n=head2 next_seq()\n\n Title   : next_seq()\n Usage   : $scf = $stream->next_seq()\n Function: returns the next scf sequence in the stream\n Returns : a Bio::Seq::SequenceTrace object\n Args    : NONE\n Notes   : Fills the interface specification for SeqIO.\n            The SCF specification does not provide for having more then\n           one sequence in a given scf. So once the filehandle has been open\n           and passed to SeqIO do not expect to run this function more then\n           once on a given scf unless you embraced and extended the SCF\n       standard.  SCF comments are accessible through the Bio::SeqI\n           interface method annotation().\n\n\n#'\nsub next_seq {\n    my ($self) = @_;\n    my ($seq, $seqc, $fh, $buffer, $offset, $length, $read_bytes, @read,\n         %names);\n    # set up a filehandle to read in the scf\n    return if $self->{_readfile};\n    $fh = $self->_fh();\n    unless ($fh) {      # simulate the <> function\n        if ( !fileno(ARGV) or eof(ARGV) ) {\n            return unless my $ARGV = shift;\n            open(ARGV,$ARGV) or\n              $self->throw(\"Could not open $ARGV for SCF stream reading $!\");\n        }\n        $fh = \\*ARGV;\n    }\n    return unless read $fh, $buffer, 128; # no exception; probably end of file\n    # now, the master data structure will be the creator\n    my $creator;\n    # he first thing to do is parse the header. This is common\n    # among all versions of scf.\n    # the rest of the the information is different between the\n    # the different versions of scf.\n\n    $creator->{header} = $self->_get_header($buffer);\n    if ($creator->{header}->{'version'} lt \"3.00\") {\n        $self->debug(\"scf.pm is working with a version 2 scf.\\n\");\n        # first gather the trace information\n        $length = $creator->{header}->{'samples'} *\n          $creator->{header}->{sample_size}*4;\n        $buffer = $self->read_from_buffer($fh, $buffer, $length,\n                                                     $creator->{header}->{samples_offset});\n        # @read = unpack \"n$length\",$buffer;\n        # these traces need to be split\n        # returns a reference to a hash\n        $creator->{traces} = $self->_parse_v2_traces(\n                                                     $buffer,$creator->{header}->{sample_size});\n        # now go and get the base information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 12);\n        seek $fh,$offset,0;\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$creator->{header}->{bases_offset});\n        # now distill the information into its fractions.\n        # the old way : $self->_set_v2_bases($buffer);\n        # ref to an array, ref to a hash, string\n        ($creator->{peak_indices},\n         $creator->{qualities},\n         $creator->{sequence},\n         $creator->{accuracies}) = $self->_parse_v2_bases($buffer);\n\n    } else {\n        $self->debug(\"scf.pm is working with a version 3+ scf.\\n\");\n        my $transformed_read;\n        my $current_read_position = $creator->{header}->{sample_offset};\n        $length = $creator->{header}->{'samples'}*\n          $creator->{header}->{sample_size};\n        # $dumper->dumpValue($creator->{header});\n        foreach (qw(a c g t)) {\n            $buffer = $self->read_from_buffer($fh,$buffer,$length,$current_read_position);\n            my $byte = \"n\";\n            if ($creator->{header}->{sample_size} == 1) {\n                $byte = \"c\";\n            }\n            @read = unpack \"${byte}${length}\",$buffer;\n            # this little spurt of nonsense is because\n            # the trace values are given in the binary\n            # file as unsigned shorts but they really\n            # are signed deltas. 30000 is an arbitrary number\n            # (will there be any traces with a given\n            # point greater then 30000? I hope not.\n            # once the read is read, it must be changed\n            # from relative\n            foreach (@read) {\n                if ($_ > 30000) {\n                    $_ -= 65536;\n                }\n            }\n            $transformed_read = $self->_delta(\\@read,\"backward\");\n            # For 8-bit data we need to emulate a signed/unsigned\n            # cast that is implicit in the C implementations.....\n            if ($creator->{header}->{sample_size} == 1) {\n                foreach (@{$transformed_read}) {\n                    $_ += 256 if ($_ < 0);\n                }\n            }\n            $current_read_position += $length;\n            $creator->{'traces'}->{$_} = join(' ',@{$transformed_read});\n        }\n        \n        # now go and get the peak index information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 4);\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{peak_indices} = $self->_get_v3_peak_indices($buffer);\n        $offset += $length;\n        # now go and get the accuracy information\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{accuracies} = $self->_get_v3_base_accuracies($buffer);\n        # OK, now go and get the base information.\n        $offset += $length;\n        $length = $creator->{header}->{bases};\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{'sequence'} = unpack(\"a$length\",$buffer);\n        # now, finally, extract the calls from the accuracy information.\n        $creator->{qualities} = $self->_get_v3_quality(\n                                              $creator->{'sequence'},$creator->{accuracies});\n    }\n    # now go and get the comment information\n    $offset = $creator->{header}->{comments_offset};\n    seek $fh,$offset,0;\n    $length = $creator->{header}->{comment_size};\n    $buffer = $self->read_from_buffer($fh,$buffer,$length);\n    $creator->{comments} = $self->_get_comments($buffer);\n    my @name_comments = grep {$_->tagname() eq 'NAME'}\n                $creator->{comments}->get_Annotations('comment');\n    my $name_comment;\n    if (@name_comments){\n         $name_comment = $name_comments[0]->as_text();\n         $name_comment =~ s/^Comment:\\s+//;\n    }\n\n    my $swq = Bio::Seq::Quality->new(\n        -seq  =>   $creator->{'sequence'},\n        -qual =>    $creator->{'qualities'},\n        -id   =>    $name_comment\n                                              );\n    my $returner = Bio::Seq::SequenceTrace->new(\n                                           -swq      =>   $swq,\n                                            -trace_a  =>   $creator->{'traces'}->{'a'},\n                                            -trace_t  =>   $creator->{'traces'}->{'t'},\n                                           -trace_g  =>   $creator->{'traces'}->{'g'},\n                                           -trace_c  =>   $creator->{'traces'}->{'c'},\n                                       -accuracy_a    => $creator->{'accuracies'}->{'a'},\n                                   -accuracy_t    => $creator->{'accuracies'}->{'t'},\n                                      -accuracy_g    => $creator->{'accuracies'}->{'g'},\n                                    -accuracy_c    => $creator->{'accuracies'}->{'c'},\n                                 -peak_indices  => $creator->{'peak_indices'}\n                                                             );\n\n        $returner->annotation($creator->{'comments'}); # add SCF comments\n    $self->{'_readfile'} = 1;\n    return $returner;\n}\n\n\n=head2 _get_v3_quality()\n\n Title   : _get_v3_quality()\n Usage   : $self->_get_v3_quality()\n Function: Set the base qualities from version3 scf\n Returns : Nothing. Alters $self.\n Args    : None.\n Notes   :\n\n\n#'\nsub _get_v3_quality {\n    my ($self,$sequence,$accuracies) = @_;\n    my @bases = split//,$sequence;\n    my (@qualities,$currbase,$currqual,$counter);\n    for ($counter=0; $counter <= $#bases ; $counter++) {\n    $currbase = lc($bases[$counter]);\n    if ($currbase eq \"a\") { $currqual = $accuracies->{'a'}->[$counter]; }\n    elsif ($currbase eq \"c\") { $currqual = $accuracies->{'c'}->[$counter]; }\n    elsif ($currbase eq \"g\") { $currqual = $accuracies->{'g'}->[$counter]; }\n    elsif ($currbase eq \"t\") { $currqual = $accuracies->{'t'}->[$counter]; }\n    else { $currqual = \"unknown\"; }\n    push @qualities,$currqual;\n    }\n    return \\@qualities;\n}\n\n=head2 _get_v3_peak_indices($buffer)\n\n Title   : _get_v3_peak_indices($buffer)\n Usage   : $self->_get_v3_peak_indices($buffer);\n Function: Unpacks the base accuracies for version3 scf\n Returns : Nothing. Alters $self\n Args    : A scalar containing binary data.\n Notes   :\n\n\nsub _get_v3_peak_indices {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my @read = unpack \"N$length\",$buffer;\n     return join(' ',@read);\n}\n\n=head2 _get_v3_base_accuracies($buffer)\n\n Title   : _get_v3_base_accuracies($buffer)\n Usage   : $self->_get_v3_base_accuracies($buffer)\n Function: Set the base accuracies for version 3 scf's\n Returns : Nothing. Alters $self.\n Args    : A scalar containing binary data.\n Notes   :\n\n\n#'\nsub _get_v3_base_accuracies {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my $qlength = $length/4;\n    my $offset = 0;\n    my (@qualities,@sorter,$counter,$round,$last_base,$accuracies,$currbase);\n    foreach $currbase (qw(a c g t)) {\n         my @read;\n         $last_base = $offset + $qlength;\n         for (;$offset < $last_base; $offset += $qlength) {\n                    # a bioperler (perhaps me?) changed the unpack string to include 'n' rather than 'C'\n                    # on 040322 I think that 'C' is correct. please email chad if you would like to accuse me of being incorrect\n              @read = unpack \"C$qlength\", substr($buffer,$offset,$qlength);\n              $accuracies->{$currbase} = \\@read;\n         }\n    }\n     return $accuracies;\n}\n\n\n=head2 _get_comments($buffer)\n\n Title   : _get_comments($buffer)\n Usage   : $self->_get_comments($buffer);\n Function: Gather the comments section from the scf and parse it into its\n            components.\n Returns : a Bio::Annotation::Collection object\n Args    : The buffer. It is expected that the buffer contains a binary\n            string for the comments section of an scf file according to\n            the scf file specifications.\n Notes   :\n\n\nsub _get_comments {\n    my ($self,$buffer) = @_;\n    my $comments = Bio::Annotation::Collection->new();\n    my $size = length($buffer);\n    my $comments_retrieved = unpack \"a$size\",$buffer;\n    $comments_retrieved =~ s/\\0//;\n    my @comments_split = split/\\n/,$comments_retrieved;\n    if (@comments_split) {\n        foreach (@comments_split) {\n            /(\\w+)=(.*)/;\n            if ($1 && $2) {\n                my ($tagname, $text) = ($1, $2);\n                my $comment_obj = Bio::Annotation::Comment->new(\n                                     -text => $text,\n                                     -tagname => $tagname);\n\n                $comments->add_Annotation('comment', $comment_obj);\n            }\n        }\n    }\n    $self->{'comments'} = $comments;\n    return $comments;\n}\n\n=head2 _get_header()\n\n Title   : _get_header($buffer)\n Usage   : $self->_get_header($buffer);\n Function: Gather the header section from the scf and parse it into its\n           components.\n Returns : Reference to a hash containing the header components.\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the header section of an scf file according to the\n           scf file specifications.\n Notes   : None.\n\n\nsub _get_header {\n    my ($self,$buffer) = @_;\n    my $header;\n    ($header->{'scf'},\n     $header->{'samples'},\n     $header->{'sample_offset'},\n     $header->{'bases'},\n     $header->{'bases_left_clip'},\n     $header->{'bases_right_clip'},\n     $header->{'bases_offset'},\n     $header->{'comment_size'},\n     $header->{'comments_offset'},\n     $header->{'version'},\n     $header->{'sample_size'},\n     $header->{'code_set'},\n     @{$header->{'header_spare'}} ) = unpack \"a4 NNNNNNNN a4 NN N20\", $buffer;\n\n    $self->{'header'} = $header;\n    return $header;\n}\n\n=head2 _parse_v2_bases($buffer)\n\n Title   : _parse_v2_bases($buffer)\n Usage   : $self->_parse_v2_bases($buffer);\n Function: Gather the bases section from the scf and parse it into its\n           components.\n Returns :\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the bases section of an scf file according to the\n           scf file specifications.\n Notes   : None.\n\n\nsub _parse_v2_bases {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my ($offset2,$currbuff,$currbase,$currqual,$sequence,@qualities,@indices);\n    my (@read,$harvester,$accuracies);\n    for ($offset2=0;$offset2<$length;$offset2+=12) {\n         @read = unpack \"N C C C C a C3\", substr($buffer,$offset2,$length);\n         push @indices,$read[0];\n         $currbase = lc($read[5]);\n         if ($currbase eq \"a\") { $currqual = $read[1]; }\n         elsif ($currbase eq \"c\") { $currqual = $read[2]; }\n         elsif ($currbase eq \"g\") { $currqual = $read[3]; }\n         elsif ($currbase eq \"t\") { $currqual = $read[4]; }\n         else { $currqual = \"UNKNOWN\"; }\n         push @{$accuracies->{\"a\"}},$read[1];\n         push @{$accuracies->{\"c\"}},$read[2];\n         push @{$accuracies->{\"g\"}},$read[3];\n         push @{$accuracies->{\"t\"}},$read[4];\n\n         $sequence .= $currbase;\n         push @qualities,$currqual;\n    }\n     return (\\@indices,\\@qualities,$sequence,$accuracies)\n}\n\n=head2 _parse_v2_traces(\\@traces_array)\n\n Title   : _pares_v2_traces(\\@traces_array)\n Usage   : $self->_parse_v2_traces(\\@traces_array);\n Function: Parses an scf Version2 trace array into its base components.\n Returns : Nothing. Modifies $self.\n Args    : A reference to an array of the unpacked traces section of an\n           scf version2 file.\n\n\nsub _parse_v2_traces {\n    my ($self,$buffer,$sample_size) = @_;\n     my $byte;\n     if ($sample_size == 1) { $byte = \"c\"; }\n     else { $byte = \"n\"; }\n     my $length = CORE::length($buffer);\n     my @read = unpack \"${byte}${length}\",$buffer;\n          # this will be an array to the reference holding the array\n     my $traces;\n     my $array = 0;\n     for (my $offset2 = 0; $offset2< scalar(@read); $offset2+=4) {\n              push @{$traces->{'a'}},$read[$offset2];\n              push @{$traces->{'t'}},$read[$offset2+1];\n              push @{$traces->{'g'}},$read[$offset2+3];\n              push @{$traces->{'c'}},$read[$offset2+2];\n    }\n    return $traces;\n}\n\n\nsub get_trace_deprecated_use_the_sequencetrace_object_instead {\n    # my ($self,$base_channel,$traces) = @_;\n    # $base_channel =~ tr/a-z/A-Z/;\n    # if ($base_channel !~ /A|T|G|C/) {\n    #   $self->throw(\"You tried to ask for a base channel that wasn't A,T,G, or C. Ask for one of those next time.\");\n    ##} elsif ($base_channel) {\n     #  my @temp = split(' ',$self->{'traces'}->{$base_channel});\n    #return \\@temp;\n    #}\n}\n\nsub _deprecated_get_peak_indices_deprecated_use_the_sequencetrace_object_instead {\n    my ($self) = shift;\n    my @temp = split(' ',$self->{'parsed'}->{'peak_indices'});\n    return \\@temp;\n}\n\n\n=head2 get_header()\n\n Title   : get_header()\n Usage   : %header = %{$obj->get_header()};\n Function: Return the header for this scf.\n Returns : A reference to a hash containing the header for this scf.\n Args    : None.\n Notes   :\n\n\nsub get_header {\n    my ($self) = shift;\n    return $self->{'header'};\n}\n\n=head2 get_comments()\n\n Title   : get_comments()\n Usage   : %comments = %{$obj->get_comments()};\n Function: Return the comments for this scf.\n Returns : A Bio::Annotation::Collection object\n Args    : None.\n Notes   :\n\n\nsub get_comments {\n    my ($self) = shift;\n    return $self->{'comments'};\n}\n\nsub _dump_traces_outgoing_deprecated_use_the_sequencetrace_object {\n    my ($self,$transformed) = @_;\n    my (@sA,@sT,@sG,@sC);\n    if ($transformed) {\n    @sA = @{$self->{'text'}->{'t_samples_a'}};\n    @sC = @{$self->{'text'}->{'t_samples_c'}};\n    @sG = @{$self->{'text'}->{'t_samples_g'}};\n    @sT = @{$self->{'text'}->{'t_samples_t'}};\n    }\n    else {\n    @sA = @{$self->{'text'}->{'samples_a'}};\n    @sC = @{$self->{'text'}->{'samples_c'}};\n    @sG = @{$self->{'text'}->{'samples_g'}};\n    @sT = @{$self->{'text'}->{'samples_t'}};\n    }\n    print (\"Count\\ta\\tc\\tg\\tt\\n\");\n    for (my $curr=0; $curr < scalar(@sG); $curr++) {\n    print(\"$curr\\t$sA[$curr]\\t$sC[$curr]\\t$sG[$curr]\\t$sT[$curr]\\n\");\n    }\n    return;\n}\n\nsub _dump_traces_incoming_deprecated_use_the_sequencetrace_object {\n    # my ($self) = @_;\n    # my (@sA,@sT,@sG,@sC);\n    # @sA = @{$self->{'traces'}->{'A'}};\n    # @sC = @{$self->{'traces'}->{'C'}};\n    # @sG = @{$self->{'traces'}->{'G'}};\n    # @sT = @{$self->{'traces'}->{'T'}};\n    # @sA = @{$self->get_trace('A')};\n    # @sC = @{$self->get_trace('C')};\n    # @sG = @{$self->get_trace('G')};\n    # @sT = @{$self->get_trace('t')};\n    # print (\"Count\\ta\\tc\\tg\\tt\\n\");\n    # for (my $curr=0; $curr < scalar(@sG); $curr++) {\n    #   print(\"$curr\\t$sA[$curr]\\t$sC[$curr]\\t$sG[$curr]\\t$sT[$curr]\\n\");\n    #}\n    #return;\n}\n\n=head2 write_seq\n\n Title   : write_seq(-target => $swq, <comments>)\n Usage   : $obj->write_seq(\n               -target => $swq,\n            -version => 2,\n            -CONV => \"Bioperl-Chads Mighty SCF writer.\");\n Function: Write out an scf.\n Returns : Nothing.\n Args    : Requires: a reference to a Bio::Seq::Quality object to form the\n           basis for the scf.\n       if -version is provided, it should be \"2\" or \"3\". A SCF of that\n       version will be written.\n       Any other arguments are assumed to be comments and are put into\n       the comments section of the scf. Read the specifications for scf\n       to decide what might be good to put in here.\n\n Notes   :\n          For best results, use a SequenceTrace object.\n          The things that you need to write an scf:\n          a) sequence\n          b) quality\n          c) peak indices\n          d) traces\n          - You _can_ write an scf with just a and b by passing in a\n               Bio::Seq::Quality object- false traces will be synthesized\n               for you.\n\n\nsub write_seq {\n    my ($self,%args) = @_;\n    my %comments;\n    my ($label,$arg);\n    my ($swq) = $self->_rearrange([qw(TARGET)], %args);\n     my $writer_fodder;\n     if (ref($swq) =~ /Bio::Seq::SequenceTrace|Bio::Seq::Quality/) {\n               if (ref($swq) eq \"Bio::Seq::Quality\") {\n                         # this means that the object *has no trace data*\n                         # we might as well synthesize some now, ok?\n                    $swq = Bio::Seq::SequenceTrace->new(\n                         -swq     =>   $swq\n                    );\n               }\n     }\n    else  {\n    $self->throw(\"You must pass a Bio::Seq::Quality or a Bio::Seq::SequenceTrace object to write_seq as a parameter named \\\"target\\\"\");\n    }\n          # all of the rest of the arguments are comments for the scf\n    foreach $arg (sort keys %args) {\n    next if ($arg =~ /target/i);\n    ($label = $arg) =~ s/^\\-//;\n    $writer_fodder->{comments}->{$label} = $args{$arg};\n    }\n    if (!$comments{'NAME'}) { $comments{'NAME'} = $swq->id(); }\n          # HA! Bwahahahaha.\n    $writer_fodder->{comments}->{'CONV'} = \"Bioperl-Chads Mighty SCF writer.\" unless defined $comments{'CONV'};\n          # now deal with the version of scf they want to write\n    if ($writer_fodder->{comments}->{version}) {\n         if ($writer_fodder->{comments}->{version} != 2 && $writer_fodder->{comments}->{version} != 3) {\n              $self->warn(\"This module can only write version 2.0 or 3.0 scf's. Writing a version 2.0 scf by default.\");\n              $writer_fodder->{header}->{version} = \"2.00\";\n         }\n         elsif ($writer_fodder->{comments}->{'version'} > 2) {\n              $writer_fodder->{header}->{'version'} = \"3.00\";\n         }\n          else {\n               $writer_fodder->{header}->{version} = \"2\";\n          }\n    }\n    else {\n         $writer_fodder->{header}->{'version'} = \"3.00\";\n    }\n          # set a few things in the header\n    $writer_fodder->{'header'}->{'magic'} = \".scf\";\n    $writer_fodder->{'header'}->{'sample_size'} = \"2\";\n    $writer_fodder->{'header'}->{'bases'} = length($swq->seq());\n    $writer_fodder->{'header'}->{'bases_left_clip'} = \"0\";\n    $writer_fodder->{'header'}->{'bases_right_clip'} = \"0\";\n    $writer_fodder->{'header'}->{'sample_size'} = \"2\";\n    $writer_fodder->{'header'}->{'code_set'} = \"9\";\n    @{$writer_fodder->{'header'}->{'spare'}} = qw(0 0 0 0 0 0 0 0 0 0\n                     0 0 0 0 0 0 0 0 0 0);\n    $writer_fodder->{'header'}->{'samples_offset'} = \"128\";\n     $writer_fodder->{'header'}->{'samples'} = $swq->trace_length();\n          # create the binary for the comments and file it in writer_fodder\n    $writer_fodder->{comments} =  $self->_get_binary_comments(\n               $writer_fodder->{comments});\n          # create the binary and the strings for the traces, bases,\n          # offsets (if necessary), and accuracies (if necessary)\n    $writer_fodder->{traces} = $self->_get_binary_traces(\n               $writer_fodder->{'header'}->{'version'},\n               $swq,$writer_fodder->{'header'}->{'sample_size'});\n    my ($b_base_offsets,$b_base_accuracies,$samples_size,$bases_size);\n    #\n    # version 2\n    #\n    if ($writer_fodder->{'header'}->{'version'} == 2) {\n          $writer_fodder->{bases} = $self->_get_binary_bases(\n                         2,\n                         $swq,\n                         $writer_fodder->{'header'}->{'sample_size'});\n         $samples_size = CORE::length($writer_fodder->{traces}->{'binary'});\n         $bases_size = CORE::length($writer_fodder->{bases}->{binary});\n         $writer_fodder->{'header'}->{'bases_offset'} = 128 + $samples_size;\n         $writer_fodder->{'header'}->{'comments_offset'} = 128 +\n               $samples_size + $bases_size;\n         $writer_fodder->{'header'}->{'comments_size'} =\n               length($writer_fodder->{'comments'}->{binary});\n         $writer_fodder->{'header'}->{'private_size'} = \"0\";\n         $writer_fodder->{'header'}->{'private_offset'} = 128 +\n               $samples_size + $bases_size +\n               $writer_fodder->{'header'}->{'comments_size'};\n          $writer_fodder->{'header'}->{'binary'} =\n          $self->_get_binary_header($writer_fodder->{header});\n          $dumper->dumpValue($writer_fodder) if $self->verbose > 0;\n         $self->_print ($writer_fodder->{'header'}->{'binary'})\n               or print(\"Could not write binary header...\\n\");\n         $self->_print ($writer_fodder->{'traces'}->{'binary'})\n               or print(\"Could not write binary traces...\\n\");\n         $self->_print ($writer_fodder->{'bases'}->{'binary'})\n               or print(\"Could not write binary base structures...\\n\");\n         $self->_print ($writer_fodder->{'comments'}->{'binary'})\n               or print(\"Could not write binary comments...\\n\");\n    }\n    else {\n          ($writer_fodder->{peak_indices},\n           $writer_fodder->{accuracies},\n           $writer_fodder->{bases},\n           $writer_fodder->{reserved} ) =\n               $self->_get_binary_bases(\n                    3,\n                    $swq,\n                    $writer_fodder->{'header'}->{'sample_size'}\n               );\n         $writer_fodder->{'header'}->{'bases_offset'} = 128 +\n               length($writer_fodder->{'traces'}->{'binary'});\n         $writer_fodder->{'header'}->{'comments_size'} =\n               length($writer_fodder->{'comments'}->{'binary'});\n              # this is:\n              # bases_offset + base_offsets + accuracies + called_bases +\n               # reserved\n         $writer_fodder->{'header'}->{'private_size'} = \"0\";\n\n         $writer_fodder->{'header'}->{'comments_offset'} =\n              128+length($writer_fodder->{'traces'}->{'binary'})+\n                 length($writer_fodder->{'peak_indices'}->{'binary'})+\n                 length($writer_fodder->{'accuracies'}->{'binary'})+\n                length($writer_fodder->{'bases'}->{'binary'})+\n                length($writer_fodder->{'reserved'}->{'binary'});\n    $writer_fodder->{'header'}->{'private_offset'} =\n          $writer_fodder->{'header'}->{'comments_offset'} +\n               $writer_fodder->{'header'}->{'comments_size'};\n    $writer_fodder->{'header'}->{'spare'}->[1] =\n         $writer_fodder->{'header'}->{'comments_offset'} +\n             length($writer_fodder->{'comments'}->{'binary'});\n     $writer_fodder->{header}->{binary} =\n          $self->_get_binary_header($writer_fodder->{header});\n    $self->_print ($writer_fodder->{'header'}->{'binary'})\n          or print(\"Couldn't write header\\n\");\n    $self->_print ($writer_fodder->{'traces'}->{'binary'})\n          or print(\"Couldn't write samples\\n\");\n    $self->_print ($writer_fodder->{'peak_indices'}->{'binary'})\n          or print(\"Couldn't write peak offsets\\n\");\n    $self->_print ($writer_fodder->{'accuracies'}->{'binary'})\n          or print(\"Couldn't write accuracies\\n\");\n    $self->_print ($writer_fodder->{'bases'}->{'binary'})\n          or print(\"Couldn't write called_bases\\n\");\n    $self->_print ($writer_fodder->{'reserved'}->{'binary'})\n          or print(\"Couldn't write reserved\\n\");\n    $self->_print ($writer_fodder->{'comments'}->{'binary'})\n          or print (\"Couldn't write comments\\n\");\n    }\n\n    # kinda unnecessary, given the close() below, but maybe that'll go\n    # away someday.\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n\n    $self->close();\n    return 1;\n}\n\n\n\n\n\n=head2 _get_binary_header()\n\n Title   : _get_binary_header();\n Usage   : $self->_get_binary_header();\n Function: Provide the binary string that will be used as the header for\n            a scfv2 document.\n Returns : A binary string.\n Args    : None. Uses the entries in the $self->{'header'} hash. These\n            are set on construction of the object (hopefully correctly!).\n Notes   :\n\n\nsub _get_binary_header {\n    my ($self,$header) = @_;\n    my $binary = pack \"a4 NNNNNNNN a4 NN N20\",\n    (\n     $header->{'magic'},\n     $header->{'samples'},\n     $header->{'samples_offset'},\n     $header->{'bases'},\n     $header->{'bases_left_clip'},\n     $header->{'bases_right_clip'},\n     $header->{'bases_offset'},\n     $header->{'comments_size'},\n     $header->{'comments_offset'},\n     $header->{'version'},\n     $header->{'sample_size'},\n     $header->{'code_set'},\n     @{$header->{'spare'}}\n     );\n    return $binary;\n}\n\n=head2 _get_binary_traces($version,$ref)\n\n Title   : _set_binary_tracesbases($version,$ref)\n Usage   : $self->_set_binary_tracesbases($version,$ref);\n Function: Constructs the trace and base strings for all scfs\n Returns : Nothing. Alters self.\n Args    : $version - \"2\" or \"3\"\n       $sequence - a scalar containing arbitrary sequence data\n       $ref - a reference to either a SequenceTraces or a\n          SequenceWithQuality object.\n Notes   : This is a really complicated thing.\n\n\nsub _get_binary_traces {\n    my ($self,$version,$ref,$sample_size) = @_;\n          # ref _should_ be a Bio::Seq::SequenceTrace, but might be a\n          # Bio::Seq::Quality\n     my $returner;\n     my $sequence = $ref->seq();\n     my $sequence_length = length($sequence);\n          # first of all, do we need to synthesize the trace?\n          # if so, call synthesize_base\n     my ($traceobj,@traces,$current);\n     if ( ref($ref) eq \"Bio::Seq::Quality\" ) {\n          $traceobj = Bio::Seq::Quality->new(\n               -target   =>   $ref\n          );\n          $traceobj->_synthesize_traces();\n     }\n     else {\n          $traceobj = $ref;\n          if ($version eq \"2\") {\n               my $trace_length = $traceobj->trace_length();\n               for ($current = 1; $current <= $trace_length; $current++) {\n                    foreach (qw(a c g t)) {\n                         push @traces,$traceobj->trace_value_at($_,$current);\n                    }\n               }\n          }\n          elsif ($version == 3) {\n               foreach my $current_trace (qw(a c g t)) {\n                    my @trace = @{$traceobj->trace($current_trace)};\n                    foreach (@trace) {\n                         if ($_ > 30000) {\n                              $_ -= 65536;\n                         }\n                    }\n                    my $transformed = $self->_delta(\\@trace,\"forward\");\n                    if($sample_size == 1){\n                         foreach (@{$transformed}) {\n                              $_ += 256 if ($_ < 0);\n                         }\n                    }\n                    push @traces,@{$transformed};\n               }\n          }\n     }\n     $returner->{version} = $version;\n     $returner->{string} = \\@traces;\n     my $length_of_traces = scalar(@traces);\n     my $byte;\n     if ($sample_size == 1) { $byte = \"c\"; } else { $byte = \"n\"; }\n          # an unsigned integer should be I, but this is too long\n          #\n     $returner->{binary} = pack \"n${length_of_traces}\",@traces;\n     $returner->{length} = CORE::length($returner->{binary});\n     return $returner;\n}\n\n\nsub _get_binary_bases {\n     my ($self,$version,$trace,$sample_size) = @_;\n     my $byte;\n     if ($sample_size == 1) { $byte = \"c\"; } else { $byte = \"n\"; }\n     my ($returner,@current_row,$current_base,$string,$binary);\n     my $length = $trace->length();\n     if ($version == 2) {\n          $returner->{'version'} = \"2\";\n         for (my $current_base =1; $current_base <= $length; $current_base++) {\n               my @current_row;\n               push @current_row,$trace->peak_index_at($current_base);\n               push @current_row,$trace->accuracy_at(\"a\",$current_base);\n               push @current_row,$trace->accuracy_at(\"c\",$current_base);\n               push @current_row,$trace->accuracy_at(\"g\",$current_base);\n               push @current_row,$trace->accuracy_at(\"t\",$current_base);\n               push @current_row,$trace->baseat($current_base);\n               push @current_row,0,0,0;\n               push @{$returner->{string}},@current_row;\n               $returner->{binary} .= pack \"N C C C C a C3\",@current_row;\n          }\n          return $returner;\n     }\n     else {\n          $returner->{'version'} = \"3.00\";\n          $returner->{peak_indices}->{string} = $trace->peak_indices();\n          my $length = scalar(@{$returner->{peak_indices}->{string}});\n          $returner->{peak_indices}->{binary} =\n               pack \"N$length\",@{$returner->{peak_indices}->{string}};\n          $returner->{peak_indices}->{length} =\n               CORE::length($returner->{peak_indices}->{binary});\n          my @accuracies;\n          foreach my $base (qw(a c g t)) {\n               $returner->{accuracies}->{$base} = $trace->accuracies($base);\n               push @accuracies,@{$trace->accuracies($base)};\n          }\n          $returner->{sequence} = $trace->seq();\n          $length = scalar(@accuracies);\n               # this really is \"c\" for samplesize == 2\n          $returner->{accuracies}->{binary} = pack \"C${length}\",@accuracies;\n          $returner->{accuracies}->{length} =\n               CORE::length($returner->{accuracies}->{binary});\n          $length = $trace->seq_obj()->length();\n          for (my $count=0; $count< $length; $count++) {\n               push @{$returner->{reserved}->{string}},0,0,0;\n          }\n     }\n     $length = scalar(@{$returner->{reserved}->{string}});\n               # this _must_ be \"c\"\n     $returner->{'reserved'}->{'binary'} =\n          pack \"c$length\",@{$returner->{reserved}->{string}};\n     $returner->{'reserved'}->{'length'} =\n          CORE::length($returner->{'reserved'}->{'binary'});\n          # $returner->{'bases'}->{'string'} = $trace->seq();\n     my @bases = split('',$trace->seq());\n     $length = $trace->length();\n     $returner->{'bases'}->{'binary'} = $trace->seq();\n          # print(\"Returning this:\\n\");\n          # $dumper->dumpValue($returner);\n     return ($returner->{peak_indices},\n             $returner->{accuracies},\n             $returner->{bases},\n             $returner->{reserved});\n\n}\n\n\n=head2 _make_trace_string($version)\n\n Title   : _make_trace_string($version)\n Usage   : $self->_make_trace_string($version)\n Function: Merges trace data for the four bases to produce an scf\n       trace string. _requires_ $version\n Returns : Nothing. Alters $self.\n Args    : $version - a version number. \"2\" or \"3\"\n Notes   :\n\n\nsub _make_trace_string {\n    my ($self,$version) = @_;\n    my @traces;\n    my @traces_view;\n    my @as = @{$self->{'text'}->{'samples_a'}};\n    my @cs = @{$self->{'text'}->{'samples_c'}};\n    my @gs = @{$self->{'text'}->{'samples_g'}};\n    my @ts = @{$self->{'text'}->{'samples_t'}};\n    if ($version == 2) {\n        for (my $curr=0; $curr < scalar(@as); $curr++) {\n        $as[$curr] = $DEFAULT_QUALITY unless defined $as[$curr];\n        $cs[$curr] = $DEFAULT_QUALITY unless defined $cs[$curr];\n        $gs[$curr] = $DEFAULT_QUALITY unless defined $gs[$curr];\n        $ts[$curr] = $DEFAULT_QUALITY unless defined $ts[$curr];\n        push @traces,($as[$curr],$cs[$curr],$gs[$curr],$ts[$curr]);\n        }\n    }\n    elsif ($version == 3) {\n        @traces = (@as,@cs,@gs,@ts);\n    }\n    else {\n        $self->throw(\"No idea what version required to make traces here. You gave #$version#  Bailing.\");\n    }\n    my $length = scalar(@traces);\n    $self->{'text'}->{'samples_all'} = \\@traces;\n\n}\n\n=head2 _get_binary_comments(\\@comments)\n\n Title   : _get_binary_comments(\\@comments)\n Usage   : $self->_get_binary_comments(\\@comments);\n Function: Provide a binary string that will be the comments section of\n       the scf file. See the scf specifications for detailed\n       specifications for the comments section of an scf file. Hint:\n       CODE=something\\nBODE=something\\n\\0\n Returns :\n Args    : A reference to an array containing comments.\n Notes   : None.\n\n\nsub _get_binary_comments {\n    my ($self,$rcomments) = @_;\n     my $returner;\n    my $comments_string = '';\n    my %comments = %$rcomments;\n    foreach my $key (sort keys %comments) {\n    $comments{$key} ||= '';\n    $comments_string .= \"$key=$comments{$key}\\n\";\n    }\n    $comments_string .= \"\\n\\0\";\n     my $length = CORE::length($comments_string);\n     $returner->{length} = $length;\n     $returner->{string} = $comments_string;\n     $returner->{binary} = pack \"A$length\",$comments_string;\n     return $returner;\n}\n\n#=head2 _fill_missing_data($swq)\n#\n# Title   : _fill_missing_data($swq)\n# Usage   : $self->_fill_missing_data($swq);\n# Function: If the $swq with quality has no qualities, set all qualities\n#      to 0.\n#      If the $swq has no sequence, set the sequence to N's.\n# Returns : Nothing. Modifies the Bio::Seq::Quality that was passed as an\n#      argument.\n# Args    : A reference to a Bio::Seq::Quality\n# Notes   : None.\n#\n#=cut\n#\n##'\n#sub _fill_missing_data {\n#    my ($self,$swq) = @_;\n#    my $qual_obj = $swq->qual_obj();\n#    my $seq_obj = $swq->seq_obj();\n#    if ($qual_obj->length() == 0 && $seq_obj->length() != 0) {\n#   my $fake_qualities = (\"$DEFAULT_QUALITY \")x$seq_obj->length();\n#   $swq->qual($fake_qualities);\n#    }\n#    if ($seq_obj->length() == 0 && $qual_obj->length != 0) {\n#   my $sequence = (\"N\")x$qual_obj->length();\n#   $swq->seq($sequence);\n#    }\n#}\n\n=head2 _delta(\\@trace_data,$direction)\n\n Title   : _delta(\\@trace_data,$direction)\n Usage   : $self->_delta(\\@trace_data,$direction);\n Function:\n Returns : A reference to an array containing modified trace values.\n Args    : A reference to an array containing trace data and a string\n       indicating the direction of conversion. (\"forward\" or\n       \"backward\").\n Notes   : This code is taken from the specification for SCF3.2.\n       http://www.mrc-lmb.cam.ac.uk/pubseq/manual/formats_unix_4.html","parameters":[{"label":"$self"},{"label":"$rsamples"},{"label":"$direction"}]}},{"containerName":"main::","name":"_unpack_magik","children":[{"definition":"my","line":1132,"name":"$self","containerName":"_unpack_magik","localvar":"my","kind":13},{"name":"$buffer","containerName":"_unpack_magik","kind":13,"line":1132},{"definition":"my","kind":13,"localvar":"my","containerName":"_unpack_magik","name":"$length","line":1133},{"kind":13,"containerName":"_unpack_magik","name":"$buffer","line":1133},{"line":1134,"kind":13,"localvar":"my","containerName":"_unpack_magik","name":"@read","definition":"my"},{"kind":13,"containerName":"_unpack_magik","name":"$counter","line":1134},{"kind":13,"containerName":"_unpack_magik","name":"@read","line":1136},{"kind":13,"containerName":"_unpack_magik","name":"$buffer","line":1136},{"line":1137,"kind":13,"containerName":"_unpack_magik","name":"$counter"},{"name":"$counter","kind":13,"containerName":"_unpack_magik","line":1137},{"line":1137,"kind":13,"containerName":"_unpack_magik","name":"$counter"}],"detail":"($self,$buffer)","definition":"sub","range":{"start":{"character":0,"line":1131},"end":{"line":1141,"character":9999}},"kind":12,"line":1131,"signature":{"label":"_unpack_magik($self,$buffer)","documentation":"__END__\n# $Id: scf.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::scf - .scf file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly. Use it via the Bio::SeqIO class, see\nL<Bio::SeqIO> for more information.\n\n=head1 DESCRIPTION\n\nThis object can transform .scf files to and from Bio::Seq::SequenceTrace\nobjects.  Mechanisms are present to retrieve trace data from scf\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chad Matsalla\n\nChad Matsalla\nbioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\nTony Cox, avc@sanger.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nNancy Hansen, nhansen at mail.nih.gov\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::scf;\nuse vars qw($DEFAULT_QUALITY);\nuse strict;\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SequenceTrace;\nuse Bio::Annotation::Comment;\nuse Dumpvalue;\n\nmy $dumper = new Dumpvalue();\n$dumper->veryCompact(1);\n\nBEGIN {\n    $DEFAULT_QUALITY= 10;\n}\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n                  (-verbose => $self->verbose(),\n                   -type => 'Bio::Seq::Quality'));\n  }\n  binmode $self->_fh; # for the Win32/Mac crowds  \n}\n\n=head2 next_seq()\n\n Title   : next_seq()\n Usage   : $scf = $stream->next_seq()\n Function: returns the next scf sequence in the stream\n Returns : a Bio::Seq::SequenceTrace object\n Args    : NONE\n Notes   : Fills the interface specification for SeqIO.\n            The SCF specification does not provide for having more then\n           one sequence in a given scf. So once the filehandle has been open\n           and passed to SeqIO do not expect to run this function more then\n           once on a given scf unless you embraced and extended the SCF\n       standard.  SCF comments are accessible through the Bio::SeqI\n           interface method annotation().\n\n\n#'\nsub next_seq {\n    my ($self) = @_;\n    my ($seq, $seqc, $fh, $buffer, $offset, $length, $read_bytes, @read,\n         %names);\n    # set up a filehandle to read in the scf\n    return if $self->{_readfile};\n    $fh = $self->_fh();\n    unless ($fh) {      # simulate the <> function\n        if ( !fileno(ARGV) or eof(ARGV) ) {\n            return unless my $ARGV = shift;\n            open(ARGV,$ARGV) or\n              $self->throw(\"Could not open $ARGV for SCF stream reading $!\");\n        }\n        $fh = \\*ARGV;\n    }\n    return unless read $fh, $buffer, 128; # no exception; probably end of file\n    # now, the master data structure will be the creator\n    my $creator;\n    # he first thing to do is parse the header. This is common\n    # among all versions of scf.\n    # the rest of the the information is different between the\n    # the different versions of scf.\n\n    $creator->{header} = $self->_get_header($buffer);\n    if ($creator->{header}->{'version'} lt \"3.00\") {\n        $self->debug(\"scf.pm is working with a version 2 scf.\\n\");\n        # first gather the trace information\n        $length = $creator->{header}->{'samples'} *\n          $creator->{header}->{sample_size}*4;\n        $buffer = $self->read_from_buffer($fh, $buffer, $length,\n                                                     $creator->{header}->{samples_offset});\n        # @read = unpack \"n$length\",$buffer;\n        # these traces need to be split\n        # returns a reference to a hash\n        $creator->{traces} = $self->_parse_v2_traces(\n                                                     $buffer,$creator->{header}->{sample_size});\n        # now go and get the base information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 12);\n        seek $fh,$offset,0;\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$creator->{header}->{bases_offset});\n        # now distill the information into its fractions.\n        # the old way : $self->_set_v2_bases($buffer);\n        # ref to an array, ref to a hash, string\n        ($creator->{peak_indices},\n         $creator->{qualities},\n         $creator->{sequence},\n         $creator->{accuracies}) = $self->_parse_v2_bases($buffer);\n\n    } else {\n        $self->debug(\"scf.pm is working with a version 3+ scf.\\n\");\n        my $transformed_read;\n        my $current_read_position = $creator->{header}->{sample_offset};\n        $length = $creator->{header}->{'samples'}*\n          $creator->{header}->{sample_size};\n        # $dumper->dumpValue($creator->{header});\n        foreach (qw(a c g t)) {\n            $buffer = $self->read_from_buffer($fh,$buffer,$length,$current_read_position);\n            my $byte = \"n\";\n            if ($creator->{header}->{sample_size} == 1) {\n                $byte = \"c\";\n            }\n            @read = unpack \"${byte}${length}\",$buffer;\n            # this little spurt of nonsense is because\n            # the trace values are given in the binary\n            # file as unsigned shorts but they really\n            # are signed deltas. 30000 is an arbitrary number\n            # (will there be any traces with a given\n            # point greater then 30000? I hope not.\n            # once the read is read, it must be changed\n            # from relative\n            foreach (@read) {\n                if ($_ > 30000) {\n                    $_ -= 65536;\n                }\n            }\n            $transformed_read = $self->_delta(\\@read,\"backward\");\n            # For 8-bit data we need to emulate a signed/unsigned\n            # cast that is implicit in the C implementations.....\n            if ($creator->{header}->{sample_size} == 1) {\n                foreach (@{$transformed_read}) {\n                    $_ += 256 if ($_ < 0);\n                }\n            }\n            $current_read_position += $length;\n            $creator->{'traces'}->{$_} = join(' ',@{$transformed_read});\n        }\n        \n        # now go and get the peak index information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 4);\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{peak_indices} = $self->_get_v3_peak_indices($buffer);\n        $offset += $length;\n        # now go and get the accuracy information\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{accuracies} = $self->_get_v3_base_accuracies($buffer);\n        # OK, now go and get the base information.\n        $offset += $length;\n        $length = $creator->{header}->{bases};\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{'sequence'} = unpack(\"a$length\",$buffer);\n        # now, finally, extract the calls from the accuracy information.\n        $creator->{qualities} = $self->_get_v3_quality(\n                                              $creator->{'sequence'},$creator->{accuracies});\n    }\n    # now go and get the comment information\n    $offset = $creator->{header}->{comments_offset};\n    seek $fh,$offset,0;\n    $length = $creator->{header}->{comment_size};\n    $buffer = $self->read_from_buffer($fh,$buffer,$length);\n    $creator->{comments} = $self->_get_comments($buffer);\n    my @name_comments = grep {$_->tagname() eq 'NAME'}\n                $creator->{comments}->get_Annotations('comment');\n    my $name_comment;\n    if (@name_comments){\n         $name_comment = $name_comments[0]->as_text();\n         $name_comment =~ s/^Comment:\\s+//;\n    }\n\n    my $swq = Bio::Seq::Quality->new(\n        -seq  =>   $creator->{'sequence'},\n        -qual =>    $creator->{'qualities'},\n        -id   =>    $name_comment\n                                              );\n    my $returner = Bio::Seq::SequenceTrace->new(\n                                           -swq      =>   $swq,\n                                            -trace_a  =>   $creator->{'traces'}->{'a'},\n                                            -trace_t  =>   $creator->{'traces'}->{'t'},\n                                           -trace_g  =>   $creator->{'traces'}->{'g'},\n                                           -trace_c  =>   $creator->{'traces'}->{'c'},\n                                       -accuracy_a    => $creator->{'accuracies'}->{'a'},\n                                   -accuracy_t    => $creator->{'accuracies'}->{'t'},\n                                      -accuracy_g    => $creator->{'accuracies'}->{'g'},\n                                    -accuracy_c    => $creator->{'accuracies'}->{'c'},\n                                 -peak_indices  => $creator->{'peak_indices'}\n                                                             );\n\n        $returner->annotation($creator->{'comments'}); # add SCF comments\n    $self->{'_readfile'} = 1;\n    return $returner;\n}\n\n\n=head2 _get_v3_quality()\n\n Title   : _get_v3_quality()\n Usage   : $self->_get_v3_quality()\n Function: Set the base qualities from version3 scf\n Returns : Nothing. Alters $self.\n Args    : None.\n Notes   :\n\n\n#'\nsub _get_v3_quality {\n    my ($self,$sequence,$accuracies) = @_;\n    my @bases = split//,$sequence;\n    my (@qualities,$currbase,$currqual,$counter);\n    for ($counter=0; $counter <= $#bases ; $counter++) {\n    $currbase = lc($bases[$counter]);\n    if ($currbase eq \"a\") { $currqual = $accuracies->{'a'}->[$counter]; }\n    elsif ($currbase eq \"c\") { $currqual = $accuracies->{'c'}->[$counter]; }\n    elsif ($currbase eq \"g\") { $currqual = $accuracies->{'g'}->[$counter]; }\n    elsif ($currbase eq \"t\") { $currqual = $accuracies->{'t'}->[$counter]; }\n    else { $currqual = \"unknown\"; }\n    push @qualities,$currqual;\n    }\n    return \\@qualities;\n}\n\n=head2 _get_v3_peak_indices($buffer)\n\n Title   : _get_v3_peak_indices($buffer)\n Usage   : $self->_get_v3_peak_indices($buffer);\n Function: Unpacks the base accuracies for version3 scf\n Returns : Nothing. Alters $self\n Args    : A scalar containing binary data.\n Notes   :\n\n\nsub _get_v3_peak_indices {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my @read = unpack \"N$length\",$buffer;\n     return join(' ',@read);\n}\n\n=head2 _get_v3_base_accuracies($buffer)\n\n Title   : _get_v3_base_accuracies($buffer)\n Usage   : $self->_get_v3_base_accuracies($buffer)\n Function: Set the base accuracies for version 3 scf's\n Returns : Nothing. Alters $self.\n Args    : A scalar containing binary data.\n Notes   :\n\n\n#'\nsub _get_v3_base_accuracies {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my $qlength = $length/4;\n    my $offset = 0;\n    my (@qualities,@sorter,$counter,$round,$last_base,$accuracies,$currbase);\n    foreach $currbase (qw(a c g t)) {\n         my @read;\n         $last_base = $offset + $qlength;\n         for (;$offset < $last_base; $offset += $qlength) {\n                    # a bioperler (perhaps me?) changed the unpack string to include 'n' rather than 'C'\n                    # on 040322 I think that 'C' is correct. please email chad if you would like to accuse me of being incorrect\n              @read = unpack \"C$qlength\", substr($buffer,$offset,$qlength);\n              $accuracies->{$currbase} = \\@read;\n         }\n    }\n     return $accuracies;\n}\n\n\n=head2 _get_comments($buffer)\n\n Title   : _get_comments($buffer)\n Usage   : $self->_get_comments($buffer);\n Function: Gather the comments section from the scf and parse it into its\n            components.\n Returns : a Bio::Annotation::Collection object\n Args    : The buffer. It is expected that the buffer contains a binary\n            string for the comments section of an scf file according to\n            the scf file specifications.\n Notes   :\n\n\nsub _get_comments {\n    my ($self,$buffer) = @_;\n    my $comments = Bio::Annotation::Collection->new();\n    my $size = length($buffer);\n    my $comments_retrieved = unpack \"a$size\",$buffer;\n    $comments_retrieved =~ s/\\0//;\n    my @comments_split = split/\\n/,$comments_retrieved;\n    if (@comments_split) {\n        foreach (@comments_split) {\n            /(\\w+)=(.*)/;\n            if ($1 && $2) {\n                my ($tagname, $text) = ($1, $2);\n                my $comment_obj = Bio::Annotation::Comment->new(\n                                     -text => $text,\n                                     -tagname => $tagname);\n\n                $comments->add_Annotation('comment', $comment_obj);\n            }\n        }\n    }\n    $self->{'comments'} = $comments;\n    return $comments;\n}\n\n=head2 _get_header()\n\n Title   : _get_header($buffer)\n Usage   : $self->_get_header($buffer);\n Function: Gather the header section from the scf and parse it into its\n           components.\n Returns : Reference to a hash containing the header components.\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the header section of an scf file according to the\n           scf file specifications.\n Notes   : None.\n\n\nsub _get_header {\n    my ($self,$buffer) = @_;\n    my $header;\n    ($header->{'scf'},\n     $header->{'samples'},\n     $header->{'sample_offset'},\n     $header->{'bases'},\n     $header->{'bases_left_clip'},\n     $header->{'bases_right_clip'},\n     $header->{'bases_offset'},\n     $header->{'comment_size'},\n     $header->{'comments_offset'},\n     $header->{'version'},\n     $header->{'sample_size'},\n     $header->{'code_set'},\n     @{$header->{'header_spare'}} ) = unpack \"a4 NNNNNNNN a4 NN N20\", $buffer;\n\n    $self->{'header'} = $header;\n    return $header;\n}\n\n=head2 _parse_v2_bases($buffer)\n\n Title   : _parse_v2_bases($buffer)\n Usage   : $self->_parse_v2_bases($buffer);\n Function: Gather the bases section from the scf and parse it into its\n           components.\n Returns :\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the bases section of an scf file according to the\n           scf file specifications.\n Notes   : None.\n\n\nsub _parse_v2_bases {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my ($offset2,$currbuff,$currbase,$currqual,$sequence,@qualities,@indices);\n    my (@read,$harvester,$accuracies);\n    for ($offset2=0;$offset2<$length;$offset2+=12) {\n         @read = unpack \"N C C C C a C3\", substr($buffer,$offset2,$length);\n         push @indices,$read[0];\n         $currbase = lc($read[5]);\n         if ($currbase eq \"a\") { $currqual = $read[1]; }\n         elsif ($currbase eq \"c\") { $currqual = $read[2]; }\n         elsif ($currbase eq \"g\") { $currqual = $read[3]; }\n         elsif ($currbase eq \"t\") { $currqual = $read[4]; }\n         else { $currqual = \"UNKNOWN\"; }\n         push @{$accuracies->{\"a\"}},$read[1];\n         push @{$accuracies->{\"c\"}},$read[2];\n         push @{$accuracies->{\"g\"}},$read[3];\n         push @{$accuracies->{\"t\"}},$read[4];\n\n         $sequence .= $currbase;\n         push @qualities,$currqual;\n    }\n     return (\\@indices,\\@qualities,$sequence,$accuracies)\n}\n\n=head2 _parse_v2_traces(\\@traces_array)\n\n Title   : _pares_v2_traces(\\@traces_array)\n Usage   : $self->_parse_v2_traces(\\@traces_array);\n Function: Parses an scf Version2 trace array into its base components.\n Returns : Nothing. Modifies $self.\n Args    : A reference to an array of the unpacked traces section of an\n           scf version2 file.\n\n\nsub _parse_v2_traces {\n    my ($self,$buffer,$sample_size) = @_;\n     my $byte;\n     if ($sample_size == 1) { $byte = \"c\"; }\n     else { $byte = \"n\"; }\n     my $length = CORE::length($buffer);\n     my @read = unpack \"${byte}${length}\",$buffer;\n          # this will be an array to the reference holding the array\n     my $traces;\n     my $array = 0;\n     for (my $offset2 = 0; $offset2< scalar(@read); $offset2+=4) {\n              push @{$traces->{'a'}},$read[$offset2];\n              push @{$traces->{'t'}},$read[$offset2+1];\n              push @{$traces->{'g'}},$read[$offset2+3];\n              push @{$traces->{'c'}},$read[$offset2+2];\n    }\n    return $traces;\n}\n\n\nsub get_trace_deprecated_use_the_sequencetrace_object_instead {\n    # my ($self,$base_channel,$traces) = @_;\n    # $base_channel =~ tr/a-z/A-Z/;\n    # if ($base_channel !~ /A|T|G|C/) {\n    #   $self->throw(\"You tried to ask for a base channel that wasn't A,T,G, or C. Ask for one of those next time.\");\n    ##} elsif ($base_channel) {\n     #  my @temp = split(' ',$self->{'traces'}->{$base_channel});\n    #return \\@temp;\n    #}\n}\n\nsub _deprecated_get_peak_indices_deprecated_use_the_sequencetrace_object_instead {\n    my ($self) = shift;\n    my @temp = split(' ',$self->{'parsed'}->{'peak_indices'});\n    return \\@temp;\n}\n\n\n=head2 get_header()\n\n Title   : get_header()\n Usage   : %header = %{$obj->get_header()};\n Function: Return the header for this scf.\n Returns : A reference to a hash containing the header for this scf.\n Args    : None.\n Notes   :\n\n\nsub get_header {\n    my ($self) = shift;\n    return $self->{'header'};\n}\n\n=head2 get_comments()\n\n Title   : get_comments()\n Usage   : %comments = %{$obj->get_comments()};\n Function: Return the comments for this scf.\n Returns : A Bio::Annotation::Collection object\n Args    : None.\n Notes   :\n\n\nsub get_comments {\n    my ($self) = shift;\n    return $self->{'comments'};\n}\n\nsub _dump_traces_outgoing_deprecated_use_the_sequencetrace_object {\n    my ($self,$transformed) = @_;\n    my (@sA,@sT,@sG,@sC);\n    if ($transformed) {\n    @sA = @{$self->{'text'}->{'t_samples_a'}};\n    @sC = @{$self->{'text'}->{'t_samples_c'}};\n    @sG = @{$self->{'text'}->{'t_samples_g'}};\n    @sT = @{$self->{'text'}->{'t_samples_t'}};\n    }\n    else {\n    @sA = @{$self->{'text'}->{'samples_a'}};\n    @sC = @{$self->{'text'}->{'samples_c'}};\n    @sG = @{$self->{'text'}->{'samples_g'}};\n    @sT = @{$self->{'text'}->{'samples_t'}};\n    }\n    print (\"Count\\ta\\tc\\tg\\tt\\n\");\n    for (my $curr=0; $curr < scalar(@sG); $curr++) {\n    print(\"$curr\\t$sA[$curr]\\t$sC[$curr]\\t$sG[$curr]\\t$sT[$curr]\\n\");\n    }\n    return;\n}\n\nsub _dump_traces_incoming_deprecated_use_the_sequencetrace_object {\n    # my ($self) = @_;\n    # my (@sA,@sT,@sG,@sC);\n    # @sA = @{$self->{'traces'}->{'A'}};\n    # @sC = @{$self->{'traces'}->{'C'}};\n    # @sG = @{$self->{'traces'}->{'G'}};\n    # @sT = @{$self->{'traces'}->{'T'}};\n    # @sA = @{$self->get_trace('A')};\n    # @sC = @{$self->get_trace('C')};\n    # @sG = @{$self->get_trace('G')};\n    # @sT = @{$self->get_trace('t')};\n    # print (\"Count\\ta\\tc\\tg\\tt\\n\");\n    # for (my $curr=0; $curr < scalar(@sG); $curr++) {\n    #   print(\"$curr\\t$sA[$curr]\\t$sC[$curr]\\t$sG[$curr]\\t$sT[$curr]\\n\");\n    #}\n    #return;\n}\n\n=head2 write_seq\n\n Title   : write_seq(-target => $swq, <comments>)\n Usage   : $obj->write_seq(\n               -target => $swq,\n            -version => 2,\n            -CONV => \"Bioperl-Chads Mighty SCF writer.\");\n Function: Write out an scf.\n Returns : Nothing.\n Args    : Requires: a reference to a Bio::Seq::Quality object to form the\n           basis for the scf.\n       if -version is provided, it should be \"2\" or \"3\". A SCF of that\n       version will be written.\n       Any other arguments are assumed to be comments and are put into\n       the comments section of the scf. Read the specifications for scf\n       to decide what might be good to put in here.\n\n Notes   :\n          For best results, use a SequenceTrace object.\n          The things that you need to write an scf:\n          a) sequence\n          b) quality\n          c) peak indices\n          d) traces\n          - You _can_ write an scf with just a and b by passing in a\n               Bio::Seq::Quality object- false traces will be synthesized\n               for you.\n\n\nsub write_seq {\n    my ($self,%args) = @_;\n    my %comments;\n    my ($label,$arg);\n    my ($swq) = $self->_rearrange([qw(TARGET)], %args);\n     my $writer_fodder;\n     if (ref($swq) =~ /Bio::Seq::SequenceTrace|Bio::Seq::Quality/) {\n               if (ref($swq) eq \"Bio::Seq::Quality\") {\n                         # this means that the object *has no trace data*\n                         # we might as well synthesize some now, ok?\n                    $swq = Bio::Seq::SequenceTrace->new(\n                         -swq     =>   $swq\n                    );\n               }\n     }\n    else  {\n    $self->throw(\"You must pass a Bio::Seq::Quality or a Bio::Seq::SequenceTrace object to write_seq as a parameter named \\\"target\\\"\");\n    }\n          # all of the rest of the arguments are comments for the scf\n    foreach $arg (sort keys %args) {\n    next if ($arg =~ /target/i);\n    ($label = $arg) =~ s/^\\-//;\n    $writer_fodder->{comments}->{$label} = $args{$arg};\n    }\n    if (!$comments{'NAME'}) { $comments{'NAME'} = $swq->id(); }\n          # HA! Bwahahahaha.\n    $writer_fodder->{comments}->{'CONV'} = \"Bioperl-Chads Mighty SCF writer.\" unless defined $comments{'CONV'};\n          # now deal with the version of scf they want to write\n    if ($writer_fodder->{comments}->{version}) {\n         if ($writer_fodder->{comments}->{version} != 2 && $writer_fodder->{comments}->{version} != 3) {\n              $self->warn(\"This module can only write version 2.0 or 3.0 scf's. Writing a version 2.0 scf by default.\");\n              $writer_fodder->{header}->{version} = \"2.00\";\n         }\n         elsif ($writer_fodder->{comments}->{'version'} > 2) {\n              $writer_fodder->{header}->{'version'} = \"3.00\";\n         }\n          else {\n               $writer_fodder->{header}->{version} = \"2\";\n          }\n    }\n    else {\n         $writer_fodder->{header}->{'version'} = \"3.00\";\n    }\n          # set a few things in the header\n    $writer_fodder->{'header'}->{'magic'} = \".scf\";\n    $writer_fodder->{'header'}->{'sample_size'} = \"2\";\n    $writer_fodder->{'header'}->{'bases'} = length($swq->seq());\n    $writer_fodder->{'header'}->{'bases_left_clip'} = \"0\";\n    $writer_fodder->{'header'}->{'bases_right_clip'} = \"0\";\n    $writer_fodder->{'header'}->{'sample_size'} = \"2\";\n    $writer_fodder->{'header'}->{'code_set'} = \"9\";\n    @{$writer_fodder->{'header'}->{'spare'}} = qw(0 0 0 0 0 0 0 0 0 0\n                     0 0 0 0 0 0 0 0 0 0);\n    $writer_fodder->{'header'}->{'samples_offset'} = \"128\";\n     $writer_fodder->{'header'}->{'samples'} = $swq->trace_length();\n          # create the binary for the comments and file it in writer_fodder\n    $writer_fodder->{comments} =  $self->_get_binary_comments(\n               $writer_fodder->{comments});\n          # create the binary and the strings for the traces, bases,\n          # offsets (if necessary), and accuracies (if necessary)\n    $writer_fodder->{traces} = $self->_get_binary_traces(\n               $writer_fodder->{'header'}->{'version'},\n               $swq,$writer_fodder->{'header'}->{'sample_size'});\n    my ($b_base_offsets,$b_base_accuracies,$samples_size,$bases_size);\n    #\n    # version 2\n    #\n    if ($writer_fodder->{'header'}->{'version'} == 2) {\n          $writer_fodder->{bases} = $self->_get_binary_bases(\n                         2,\n                         $swq,\n                         $writer_fodder->{'header'}->{'sample_size'});\n         $samples_size = CORE::length($writer_fodder->{traces}->{'binary'});\n         $bases_size = CORE::length($writer_fodder->{bases}->{binary});\n         $writer_fodder->{'header'}->{'bases_offset'} = 128 + $samples_size;\n         $writer_fodder->{'header'}->{'comments_offset'} = 128 +\n               $samples_size + $bases_size;\n         $writer_fodder->{'header'}->{'comments_size'} =\n               length($writer_fodder->{'comments'}->{binary});\n         $writer_fodder->{'header'}->{'private_size'} = \"0\";\n         $writer_fodder->{'header'}->{'private_offset'} = 128 +\n               $samples_size + $bases_size +\n               $writer_fodder->{'header'}->{'comments_size'};\n          $writer_fodder->{'header'}->{'binary'} =\n          $self->_get_binary_header($writer_fodder->{header});\n          $dumper->dumpValue($writer_fodder) if $self->verbose > 0;\n         $self->_print ($writer_fodder->{'header'}->{'binary'})\n               or print(\"Could not write binary header...\\n\");\n         $self->_print ($writer_fodder->{'traces'}->{'binary'})\n               or print(\"Could not write binary traces...\\n\");\n         $self->_print ($writer_fodder->{'bases'}->{'binary'})\n               or print(\"Could not write binary base structures...\\n\");\n         $self->_print ($writer_fodder->{'comments'}->{'binary'})\n               or print(\"Could not write binary comments...\\n\");\n    }\n    else {\n          ($writer_fodder->{peak_indices},\n           $writer_fodder->{accuracies},\n           $writer_fodder->{bases},\n           $writer_fodder->{reserved} ) =\n               $self->_get_binary_bases(\n                    3,\n                    $swq,\n                    $writer_fodder->{'header'}->{'sample_size'}\n               );\n         $writer_fodder->{'header'}->{'bases_offset'} = 128 +\n               length($writer_fodder->{'traces'}->{'binary'});\n         $writer_fodder->{'header'}->{'comments_size'} =\n               length($writer_fodder->{'comments'}->{'binary'});\n              # this is:\n              # bases_offset + base_offsets + accuracies + called_bases +\n               # reserved\n         $writer_fodder->{'header'}->{'private_size'} = \"0\";\n\n         $writer_fodder->{'header'}->{'comments_offset'} =\n              128+length($writer_fodder->{'traces'}->{'binary'})+\n                 length($writer_fodder->{'peak_indices'}->{'binary'})+\n                 length($writer_fodder->{'accuracies'}->{'binary'})+\n                length($writer_fodder->{'bases'}->{'binary'})+\n                length($writer_fodder->{'reserved'}->{'binary'});\n    $writer_fodder->{'header'}->{'private_offset'} =\n          $writer_fodder->{'header'}->{'comments_offset'} +\n               $writer_fodder->{'header'}->{'comments_size'};\n    $writer_fodder->{'header'}->{'spare'}->[1] =\n         $writer_fodder->{'header'}->{'comments_offset'} +\n             length($writer_fodder->{'comments'}->{'binary'});\n     $writer_fodder->{header}->{binary} =\n          $self->_get_binary_header($writer_fodder->{header});\n    $self->_print ($writer_fodder->{'header'}->{'binary'})\n          or print(\"Couldn't write header\\n\");\n    $self->_print ($writer_fodder->{'traces'}->{'binary'})\n          or print(\"Couldn't write samples\\n\");\n    $self->_print ($writer_fodder->{'peak_indices'}->{'binary'})\n          or print(\"Couldn't write peak offsets\\n\");\n    $self->_print ($writer_fodder->{'accuracies'}->{'binary'})\n          or print(\"Couldn't write accuracies\\n\");\n    $self->_print ($writer_fodder->{'bases'}->{'binary'})\n          or print(\"Couldn't write called_bases\\n\");\n    $self->_print ($writer_fodder->{'reserved'}->{'binary'})\n          or print(\"Couldn't write reserved\\n\");\n    $self->_print ($writer_fodder->{'comments'}->{'binary'})\n          or print (\"Couldn't write comments\\n\");\n    }\n\n    # kinda unnecessary, given the close() below, but maybe that'll go\n    # away someday.\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n\n    $self->close();\n    return 1;\n}\n\n\n\n\n\n=head2 _get_binary_header()\n\n Title   : _get_binary_header();\n Usage   : $self->_get_binary_header();\n Function: Provide the binary string that will be used as the header for\n            a scfv2 document.\n Returns : A binary string.\n Args    : None. Uses the entries in the $self->{'header'} hash. These\n            are set on construction of the object (hopefully correctly!).\n Notes   :\n\n\nsub _get_binary_header {\n    my ($self,$header) = @_;\n    my $binary = pack \"a4 NNNNNNNN a4 NN N20\",\n    (\n     $header->{'magic'},\n     $header->{'samples'},\n     $header->{'samples_offset'},\n     $header->{'bases'},\n     $header->{'bases_left_clip'},\n     $header->{'bases_right_clip'},\n     $header->{'bases_offset'},\n     $header->{'comments_size'},\n     $header->{'comments_offset'},\n     $header->{'version'},\n     $header->{'sample_size'},\n     $header->{'code_set'},\n     @{$header->{'spare'}}\n     );\n    return $binary;\n}\n\n=head2 _get_binary_traces($version,$ref)\n\n Title   : _set_binary_tracesbases($version,$ref)\n Usage   : $self->_set_binary_tracesbases($version,$ref);\n Function: Constructs the trace and base strings for all scfs\n Returns : Nothing. Alters self.\n Args    : $version - \"2\" or \"3\"\n       $sequence - a scalar containing arbitrary sequence data\n       $ref - a reference to either a SequenceTraces or a\n          SequenceWithQuality object.\n Notes   : This is a really complicated thing.\n\n\nsub _get_binary_traces {\n    my ($self,$version,$ref,$sample_size) = @_;\n          # ref _should_ be a Bio::Seq::SequenceTrace, but might be a\n          # Bio::Seq::Quality\n     my $returner;\n     my $sequence = $ref->seq();\n     my $sequence_length = length($sequence);\n          # first of all, do we need to synthesize the trace?\n          # if so, call synthesize_base\n     my ($traceobj,@traces,$current);\n     if ( ref($ref) eq \"Bio::Seq::Quality\" ) {\n          $traceobj = Bio::Seq::Quality->new(\n               -target   =>   $ref\n          );\n          $traceobj->_synthesize_traces();\n     }\n     else {\n          $traceobj = $ref;\n          if ($version eq \"2\") {\n               my $trace_length = $traceobj->trace_length();\n               for ($current = 1; $current <= $trace_length; $current++) {\n                    foreach (qw(a c g t)) {\n                         push @traces,$traceobj->trace_value_at($_,$current);\n                    }\n               }\n          }\n          elsif ($version == 3) {\n               foreach my $current_trace (qw(a c g t)) {\n                    my @trace = @{$traceobj->trace($current_trace)};\n                    foreach (@trace) {\n                         if ($_ > 30000) {\n                              $_ -= 65536;\n                         }\n                    }\n                    my $transformed = $self->_delta(\\@trace,\"forward\");\n                    if($sample_size == 1){\n                         foreach (@{$transformed}) {\n                              $_ += 256 if ($_ < 0);\n                         }\n                    }\n                    push @traces,@{$transformed};\n               }\n          }\n     }\n     $returner->{version} = $version;\n     $returner->{string} = \\@traces;\n     my $length_of_traces = scalar(@traces);\n     my $byte;\n     if ($sample_size == 1) { $byte = \"c\"; } else { $byte = \"n\"; }\n          # an unsigned integer should be I, but this is too long\n          #\n     $returner->{binary} = pack \"n${length_of_traces}\",@traces;\n     $returner->{length} = CORE::length($returner->{binary});\n     return $returner;\n}\n\n\nsub _get_binary_bases {\n     my ($self,$version,$trace,$sample_size) = @_;\n     my $byte;\n     if ($sample_size == 1) { $byte = \"c\"; } else { $byte = \"n\"; }\n     my ($returner,@current_row,$current_base,$string,$binary);\n     my $length = $trace->length();\n     if ($version == 2) {\n          $returner->{'version'} = \"2\";\n         for (my $current_base =1; $current_base <= $length; $current_base++) {\n               my @current_row;\n               push @current_row,$trace->peak_index_at($current_base);\n               push @current_row,$trace->accuracy_at(\"a\",$current_base);\n               push @current_row,$trace->accuracy_at(\"c\",$current_base);\n               push @current_row,$trace->accuracy_at(\"g\",$current_base);\n               push @current_row,$trace->accuracy_at(\"t\",$current_base);\n               push @current_row,$trace->baseat($current_base);\n               push @current_row,0,0,0;\n               push @{$returner->{string}},@current_row;\n               $returner->{binary} .= pack \"N C C C C a C3\",@current_row;\n          }\n          return $returner;\n     }\n     else {\n          $returner->{'version'} = \"3.00\";\n          $returner->{peak_indices}->{string} = $trace->peak_indices();\n          my $length = scalar(@{$returner->{peak_indices}->{string}});\n          $returner->{peak_indices}->{binary} =\n               pack \"N$length\",@{$returner->{peak_indices}->{string}};\n          $returner->{peak_indices}->{length} =\n               CORE::length($returner->{peak_indices}->{binary});\n          my @accuracies;\n          foreach my $base (qw(a c g t)) {\n               $returner->{accuracies}->{$base} = $trace->accuracies($base);\n               push @accuracies,@{$trace->accuracies($base)};\n          }\n          $returner->{sequence} = $trace->seq();\n          $length = scalar(@accuracies);\n               # this really is \"c\" for samplesize == 2\n          $returner->{accuracies}->{binary} = pack \"C${length}\",@accuracies;\n          $returner->{accuracies}->{length} =\n               CORE::length($returner->{accuracies}->{binary});\n          $length = $trace->seq_obj()->length();\n          for (my $count=0; $count< $length; $count++) {\n               push @{$returner->{reserved}->{string}},0,0,0;\n          }\n     }\n     $length = scalar(@{$returner->{reserved}->{string}});\n               # this _must_ be \"c\"\n     $returner->{'reserved'}->{'binary'} =\n          pack \"c$length\",@{$returner->{reserved}->{string}};\n     $returner->{'reserved'}->{'length'} =\n          CORE::length($returner->{'reserved'}->{'binary'});\n          # $returner->{'bases'}->{'string'} = $trace->seq();\n     my @bases = split('',$trace->seq());\n     $length = $trace->length();\n     $returner->{'bases'}->{'binary'} = $trace->seq();\n          # print(\"Returning this:\\n\");\n          # $dumper->dumpValue($returner);\n     return ($returner->{peak_indices},\n             $returner->{accuracies},\n             $returner->{bases},\n             $returner->{reserved});\n\n}\n\n\n=head2 _make_trace_string($version)\n\n Title   : _make_trace_string($version)\n Usage   : $self->_make_trace_string($version)\n Function: Merges trace data for the four bases to produce an scf\n       trace string. _requires_ $version\n Returns : Nothing. Alters $self.\n Args    : $version - a version number. \"2\" or \"3\"\n Notes   :\n\n\nsub _make_trace_string {\n    my ($self,$version) = @_;\n    my @traces;\n    my @traces_view;\n    my @as = @{$self->{'text'}->{'samples_a'}};\n    my @cs = @{$self->{'text'}->{'samples_c'}};\n    my @gs = @{$self->{'text'}->{'samples_g'}};\n    my @ts = @{$self->{'text'}->{'samples_t'}};\n    if ($version == 2) {\n        for (my $curr=0; $curr < scalar(@as); $curr++) {\n        $as[$curr] = $DEFAULT_QUALITY unless defined $as[$curr];\n        $cs[$curr] = $DEFAULT_QUALITY unless defined $cs[$curr];\n        $gs[$curr] = $DEFAULT_QUALITY unless defined $gs[$curr];\n        $ts[$curr] = $DEFAULT_QUALITY unless defined $ts[$curr];\n        push @traces,($as[$curr],$cs[$curr],$gs[$curr],$ts[$curr]);\n        }\n    }\n    elsif ($version == 3) {\n        @traces = (@as,@cs,@gs,@ts);\n    }\n    else {\n        $self->throw(\"No idea what version required to make traces here. You gave #$version#  Bailing.\");\n    }\n    my $length = scalar(@traces);\n    $self->{'text'}->{'samples_all'} = \\@traces;\n\n}\n\n=head2 _get_binary_comments(\\@comments)\n\n Title   : _get_binary_comments(\\@comments)\n Usage   : $self->_get_binary_comments(\\@comments);\n Function: Provide a binary string that will be the comments section of\n       the scf file. See the scf specifications for detailed\n       specifications for the comments section of an scf file. Hint:\n       CODE=something\\nBODE=something\\n\\0\n Returns :\n Args    : A reference to an array containing comments.\n Notes   : None.\n\n\nsub _get_binary_comments {\n    my ($self,$rcomments) = @_;\n     my $returner;\n    my $comments_string = '';\n    my %comments = %$rcomments;\n    foreach my $key (sort keys %comments) {\n    $comments{$key} ||= '';\n    $comments_string .= \"$key=$comments{$key}\\n\";\n    }\n    $comments_string .= \"\\n\\0\";\n     my $length = CORE::length($comments_string);\n     $returner->{length} = $length;\n     $returner->{string} = $comments_string;\n     $returner->{binary} = pack \"A$length\",$comments_string;\n     return $returner;\n}\n\n#=head2 _fill_missing_data($swq)\n#\n# Title   : _fill_missing_data($swq)\n# Usage   : $self->_fill_missing_data($swq);\n# Function: If the $swq with quality has no qualities, set all qualities\n#      to 0.\n#      If the $swq has no sequence, set the sequence to N's.\n# Returns : Nothing. Modifies the Bio::Seq::Quality that was passed as an\n#      argument.\n# Args    : A reference to a Bio::Seq::Quality\n# Notes   : None.\n#\n#=cut\n#\n##'\n#sub _fill_missing_data {\n#    my ($self,$swq) = @_;\n#    my $qual_obj = $swq->qual_obj();\n#    my $seq_obj = $swq->seq_obj();\n#    if ($qual_obj->length() == 0 && $seq_obj->length() != 0) {\n#   my $fake_qualities = (\"$DEFAULT_QUALITY \")x$seq_obj->length();\n#   $swq->qual($fake_qualities);\n#    }\n#    if ($seq_obj->length() == 0 && $qual_obj->length != 0) {\n#   my $sequence = (\"N\")x$qual_obj->length();\n#   $swq->seq($sequence);\n#    }\n#}\n\n=head2 _delta(\\@trace_data,$direction)\n\n Title   : _delta(\\@trace_data,$direction)\n Usage   : $self->_delta(\\@trace_data,$direction);\n Function:\n Returns : A reference to an array containing modified trace values.\n Args    : A reference to an array containing trace data and a string\n       indicating the direction of conversion. (\"forward\" or\n       \"backward\").\n Notes   : This code is taken from the specification for SCF3.2.\n       http://www.mrc-lmb.cam.ac.uk/pubseq/manual/formats_unix_4.html\n\n\n\nsub _delta {\n    my ($self,$rsamples,$direction) = @_;\n    my @samples = @$rsamples;\n        # /* If job == DELTA_IT:\n        # *  change a series of sample points to a series of delta delta values:\n        # *  ie change them in two steps:\n        # *  first: delta = current_value - previous_value\n        # *  then: delta_delta = delta - previous_delta\n        # * else\n        # *  do the reverse\n        # */\n        # int i;\n        # uint_2 p_delta, p_sample;\n\n    my ($i,$num_samples,$p_delta,$p_sample,@samples_converted,$p_sample1,$p_sample2);\n        my $SLOW_BUT_CLEAR = 0;\n        $num_samples = scalar(@samples);\n    # c-programmers are funny people with their single-letter variables\n\n    if ( $direction eq \"forward\" ) {\n            if($SLOW_BUT_CLEAR){\n        $p_delta  = 0;\n        for ($i=0; $i < $num_samples; $i++) {\n            $p_sample = $samples[$i];\n            $samples[$i] = $samples[$i] - $p_delta;\n            $p_delta  = $p_sample;\n        }\n        $p_delta  = 0;\n        for ($i=0; $i < $num_samples; $i++) {\n            $p_sample = $samples[$i];\n            $samples[$i] = $samples[$i] - $p_delta;\n            $p_delta  = $p_sample;\n        }\n            } else {\n                for ($i = $num_samples-1; $i > 1; $i--){\n                    $samples[$i] = $samples[$i] - 2*$samples[$i-1] + $samples[$i-2];\n                }\n                $samples[1] = $samples[1] - 2*$samples[0];\n            }\n    }\n    elsif ($direction eq \"backward\") {\n            if($SLOW_BUT_CLEAR){\n        $p_sample = 0;\n        for ($i=0; $i < $num_samples; $i++) {\n            $samples[$i] = $samples[$i] + $p_sample;\n            $p_sample = $samples[$i];\n        }\n        $p_sample = 0;\n        for ($i=0; $i < $num_samples; $i++) {\n            $samples[$i] = $samples[$i] + $p_sample;\n            $p_sample = $samples[$i];\n        }\n            } else {\n                $p_sample1 = $p_sample2 = 0;\n                for ($i = 0; $i < $num_samples; $i++){\n                    $p_sample1 = $p_sample1 + $samples[$i];\n                    $samples[$i] = $p_sample1 + $p_sample2;\n                    $p_sample2 = $samples[$i];\n                }\n\n            }\n    }\n    else {\n        $self->warn(\"Bad direction. Use \\\"forward\\\" or \\\"backward\\\".\");\n    }\n    return \\@samples;\n}\n\n=head2 _unpack_magik($buffer)\n\n Title   : _unpack_magik($buffer)\n Usage   : $self->_unpack_magik($buffer)\n Function: What unpack specification should be used? Try them all.\n Returns : Nothing.\n Args    : A buffer containing arbitrary binary data.\n Notes   : Eliminate the ambiguity and the guesswork. Used in the\n       adaptation of _delta(), mostly.","parameters":[{"label":"$self"},{"label":"$buffer"}]}},{"detail":"($self,$fh,$buffer,$length,$start_position)","definition":"sub","containerName":"main::","name":"read_from_buffer","children":[{"definition":"my","name":"$self","containerName":"read_from_buffer","localvar":"my","kind":13,"line":1156},{"line":1156,"name":"$fh","kind":13,"containerName":"read_from_buffer"},{"line":1156,"name":"$buffer","kind":13,"containerName":"read_from_buffer"},{"kind":13,"containerName":"read_from_buffer","name":"$length","line":1156},{"line":1156,"containerName":"read_from_buffer","kind":13,"name":"$start_position"},{"containerName":"read_from_buffer","kind":13,"name":"$start_position","line":1158},{"name":"$start_position","kind":13,"containerName":"read_from_buffer","line":1162},{"name":"$fh","containerName":"read_from_buffer","kind":13,"line":1164},{"name":"$start_position","containerName":"read_from_buffer","kind":13,"line":1164},{"line":1170,"kind":13,"containerName":"read_from_buffer","name":"$fh"},{"line":1170,"name":"$buffer","containerName":"read_from_buffer","kind":13},{"line":1170,"containerName":"read_from_buffer","kind":13,"name":"$length"},{"line":1171,"name":"$buffer","kind":13,"containerName":"read_from_buffer"},{"line":1171,"name":"$length","containerName":"read_from_buffer","kind":13},{"kind":13,"containerName":"read_from_buffer","name":"$self","line":1172},{"name":"warn","kind":12,"containerName":"read_from_buffer","line":1172},{"definition":"my","line":1173,"containerName":"read_from_buffer","localvar":"my","kind":13,"name":"$missing_length"},{"line":1173,"kind":13,"containerName":"read_from_buffer","name":"$length"},{"name":"$buffer","kind":13,"containerName":"read_from_buffer","line":1173},{"definition":"my","name":"$buffer2","localvar":"my","kind":13,"containerName":"read_from_buffer","line":1174},{"line":1175,"name":"$fh","containerName":"read_from_buffer","kind":13},{"line":1175,"containerName":"read_from_buffer","kind":13,"name":"$buffer2"},{"line":1175,"containerName":"read_from_buffer","kind":13,"name":"$missing_length"},{"name":"$buffer","containerName":"read_from_buffer","kind":13,"line":1176},{"containerName":"read_from_buffer","kind":13,"name":"$buffer2","line":1176},{"name":"$buffer","containerName":"read_from_buffer","kind":13,"line":1177},{"line":1177,"name":"$length","containerName":"read_from_buffer","kind":13},{"name":"$self","containerName":"read_from_buffer","kind":13,"line":1178},{"line":1178,"name":"throw","containerName":"read_from_buffer","kind":12},{"line":1178,"name":"$buffer","kind":13,"containerName":"read_from_buffer"},{"name":"$fh","kind":13,"containerName":"read_from_buffer","line":1178},{"containerName":"read_from_buffer","kind":13,"name":"$buffer","line":1182}],"signature":{"parameters":[{"label":"$self"},{"label":"$fh"},{"label":"$buffer"},{"label":"$length"},{"label":"$start_position"}],"documentation":"__END__\n# $Id: scf.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::scf - .scf file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly. Use it via the Bio::SeqIO class, see\nL<Bio::SeqIO> for more information.\n\n=head1 DESCRIPTION\n\nThis object can transform .scf files to and from Bio::Seq::SequenceTrace\nobjects.  Mechanisms are present to retrieve trace data from scf\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chad Matsalla\n\nChad Matsalla\nbioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\nTony Cox, avc@sanger.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nNancy Hansen, nhansen at mail.nih.gov\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::scf;\nuse vars qw($DEFAULT_QUALITY);\nuse strict;\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SequenceTrace;\nuse Bio::Annotation::Comment;\nuse Dumpvalue;\n\nmy $dumper = new Dumpvalue();\n$dumper->veryCompact(1);\n\nBEGIN {\n    $DEFAULT_QUALITY= 10;\n}\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n                  (-verbose => $self->verbose(),\n                   -type => 'Bio::Seq::Quality'));\n  }\n  binmode $self->_fh; # for the Win32/Mac crowds  \n}\n\n=head2 next_seq()\n\n Title   : next_seq()\n Usage   : $scf = $stream->next_seq()\n Function: returns the next scf sequence in the stream\n Returns : a Bio::Seq::SequenceTrace object\n Args    : NONE\n Notes   : Fills the interface specification for SeqIO.\n            The SCF specification does not provide for having more then\n           one sequence in a given scf. So once the filehandle has been open\n           and passed to SeqIO do not expect to run this function more then\n           once on a given scf unless you embraced and extended the SCF\n       standard.  SCF comments are accessible through the Bio::SeqI\n           interface method annotation().\n\n\n#'\nsub next_seq {\n    my ($self) = @_;\n    my ($seq, $seqc, $fh, $buffer, $offset, $length, $read_bytes, @read,\n         %names);\n    # set up a filehandle to read in the scf\n    return if $self->{_readfile};\n    $fh = $self->_fh();\n    unless ($fh) {      # simulate the <> function\n        if ( !fileno(ARGV) or eof(ARGV) ) {\n            return unless my $ARGV = shift;\n            open(ARGV,$ARGV) or\n              $self->throw(\"Could not open $ARGV for SCF stream reading $!\");\n        }\n        $fh = \\*ARGV;\n    }\n    return unless read $fh, $buffer, 128; # no exception; probably end of file\n    # now, the master data structure will be the creator\n    my $creator;\n    # he first thing to do is parse the header. This is common\n    # among all versions of scf.\n    # the rest of the the information is different between the\n    # the different versions of scf.\n\n    $creator->{header} = $self->_get_header($buffer);\n    if ($creator->{header}->{'version'} lt \"3.00\") {\n        $self->debug(\"scf.pm is working with a version 2 scf.\\n\");\n        # first gather the trace information\n        $length = $creator->{header}->{'samples'} *\n          $creator->{header}->{sample_size}*4;\n        $buffer = $self->read_from_buffer($fh, $buffer, $length,\n                                                     $creator->{header}->{samples_offset});\n        # @read = unpack \"n$length\",$buffer;\n        # these traces need to be split\n        # returns a reference to a hash\n        $creator->{traces} = $self->_parse_v2_traces(\n                                                     $buffer,$creator->{header}->{sample_size});\n        # now go and get the base information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 12);\n        seek $fh,$offset,0;\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$creator->{header}->{bases_offset});\n        # now distill the information into its fractions.\n        # the old way : $self->_set_v2_bases($buffer);\n        # ref to an array, ref to a hash, string\n        ($creator->{peak_indices},\n         $creator->{qualities},\n         $creator->{sequence},\n         $creator->{accuracies}) = $self->_parse_v2_bases($buffer);\n\n    } else {\n        $self->debug(\"scf.pm is working with a version 3+ scf.\\n\");\n        my $transformed_read;\n        my $current_read_position = $creator->{header}->{sample_offset};\n        $length = $creator->{header}->{'samples'}*\n          $creator->{header}->{sample_size};\n        # $dumper->dumpValue($creator->{header});\n        foreach (qw(a c g t)) {\n            $buffer = $self->read_from_buffer($fh,$buffer,$length,$current_read_position);\n            my $byte = \"n\";\n            if ($creator->{header}->{sample_size} == 1) {\n                $byte = \"c\";\n            }\n            @read = unpack \"${byte}${length}\",$buffer;\n            # this little spurt of nonsense is because\n            # the trace values are given in the binary\n            # file as unsigned shorts but they really\n            # are signed deltas. 30000 is an arbitrary number\n            # (will there be any traces with a given\n            # point greater then 30000? I hope not.\n            # once the read is read, it must be changed\n            # from relative\n            foreach (@read) {\n                if ($_ > 30000) {\n                    $_ -= 65536;\n                }\n            }\n            $transformed_read = $self->_delta(\\@read,\"backward\");\n            # For 8-bit data we need to emulate a signed/unsigned\n            # cast that is implicit in the C implementations.....\n            if ($creator->{header}->{sample_size} == 1) {\n                foreach (@{$transformed_read}) {\n                    $_ += 256 if ($_ < 0);\n                }\n            }\n            $current_read_position += $length;\n            $creator->{'traces'}->{$_} = join(' ',@{$transformed_read});\n        }\n        \n        # now go and get the peak index information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 4);\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{peak_indices} = $self->_get_v3_peak_indices($buffer);\n        $offset += $length;\n        # now go and get the accuracy information\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{accuracies} = $self->_get_v3_base_accuracies($buffer);\n        # OK, now go and get the base information.\n        $offset += $length;\n        $length = $creator->{header}->{bases};\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{'sequence'} = unpack(\"a$length\",$buffer);\n        # now, finally, extract the calls from the accuracy information.\n        $creator->{qualities} = $self->_get_v3_quality(\n                                              $creator->{'sequence'},$creator->{accuracies});\n    }\n    # now go and get the comment information\n    $offset = $creator->{header}->{comments_offset};\n    seek $fh,$offset,0;\n    $length = $creator->{header}->{comment_size};\n    $buffer = $self->read_from_buffer($fh,$buffer,$length);\n    $creator->{comments} = $self->_get_comments($buffer);\n    my @name_comments = grep {$_->tagname() eq 'NAME'}\n                $creator->{comments}->get_Annotations('comment');\n    my $name_comment;\n    if (@name_comments){\n         $name_comment = $name_comments[0]->as_text();\n         $name_comment =~ s/^Comment:\\s+//;\n    }\n\n    my $swq = Bio::Seq::Quality->new(\n        -seq  =>   $creator->{'sequence'},\n        -qual =>    $creator->{'qualities'},\n        -id   =>    $name_comment\n                                              );\n    my $returner = Bio::Seq::SequenceTrace->new(\n                                           -swq      =>   $swq,\n                                            -trace_a  =>   $creator->{'traces'}->{'a'},\n                                            -trace_t  =>   $creator->{'traces'}->{'t'},\n                                           -trace_g  =>   $creator->{'traces'}->{'g'},\n                                           -trace_c  =>   $creator->{'traces'}->{'c'},\n                                       -accuracy_a    => $creator->{'accuracies'}->{'a'},\n                                   -accuracy_t    => $creator->{'accuracies'}->{'t'},\n                                      -accuracy_g    => $creator->{'accuracies'}->{'g'},\n                                    -accuracy_c    => $creator->{'accuracies'}->{'c'},\n                                 -peak_indices  => $creator->{'peak_indices'}\n                                                             );\n\n        $returner->annotation($creator->{'comments'}); # add SCF comments\n    $self->{'_readfile'} = 1;\n    return $returner;\n}\n\n\n=head2 _get_v3_quality()\n\n Title   : _get_v3_quality()\n Usage   : $self->_get_v3_quality()\n Function: Set the base qualities from version3 scf\n Returns : Nothing. Alters $self.\n Args    : None.\n Notes   :\n\n\n#'\nsub _get_v3_quality {\n    my ($self,$sequence,$accuracies) = @_;\n    my @bases = split//,$sequence;\n    my (@qualities,$currbase,$currqual,$counter);\n    for ($counter=0; $counter <= $#bases ; $counter++) {\n    $currbase = lc($bases[$counter]);\n    if ($currbase eq \"a\") { $currqual = $accuracies->{'a'}->[$counter]; }\n    elsif ($currbase eq \"c\") { $currqual = $accuracies->{'c'}->[$counter]; }\n    elsif ($currbase eq \"g\") { $currqual = $accuracies->{'g'}->[$counter]; }\n    elsif ($currbase eq \"t\") { $currqual = $accuracies->{'t'}->[$counter]; }\n    else { $currqual = \"unknown\"; }\n    push @qualities,$currqual;\n    }\n    return \\@qualities;\n}\n\n=head2 _get_v3_peak_indices($buffer)\n\n Title   : _get_v3_peak_indices($buffer)\n Usage   : $self->_get_v3_peak_indices($buffer);\n Function: Unpacks the base accuracies for version3 scf\n Returns : Nothing. Alters $self\n Args    : A scalar containing binary data.\n Notes   :\n\n\nsub _get_v3_peak_indices {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my @read = unpack \"N$length\",$buffer;\n     return join(' ',@read);\n}\n\n=head2 _get_v3_base_accuracies($buffer)\n\n Title   : _get_v3_base_accuracies($buffer)\n Usage   : $self->_get_v3_base_accuracies($buffer)\n Function: Set the base accuracies for version 3 scf's\n Returns : Nothing. Alters $self.\n Args    : A scalar containing binary data.\n Notes   :\n\n\n#'\nsub _get_v3_base_accuracies {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my $qlength = $length/4;\n    my $offset = 0;\n    my (@qualities,@sorter,$counter,$round,$last_base,$accuracies,$currbase);\n    foreach $currbase (qw(a c g t)) {\n         my @read;\n         $last_base = $offset + $qlength;\n         for (;$offset < $last_base; $offset += $qlength) {\n                    # a bioperler (perhaps me?) changed the unpack string to include 'n' rather than 'C'\n                    # on 040322 I think that 'C' is correct. please email chad if you would like to accuse me of being incorrect\n              @read = unpack \"C$qlength\", substr($buffer,$offset,$qlength);\n              $accuracies->{$currbase} = \\@read;\n         }\n    }\n     return $accuracies;\n}\n\n\n=head2 _get_comments($buffer)\n\n Title   : _get_comments($buffer)\n Usage   : $self->_get_comments($buffer);\n Function: Gather the comments section from the scf and parse it into its\n            components.\n Returns : a Bio::Annotation::Collection object\n Args    : The buffer. It is expected that the buffer contains a binary\n            string for the comments section of an scf file according to\n            the scf file specifications.\n Notes   :\n\n\nsub _get_comments {\n    my ($self,$buffer) = @_;\n    my $comments = Bio::Annotation::Collection->new();\n    my $size = length($buffer);\n    my $comments_retrieved = unpack \"a$size\",$buffer;\n    $comments_retrieved =~ s/\\0//;\n    my @comments_split = split/\\n/,$comments_retrieved;\n    if (@comments_split) {\n        foreach (@comments_split) {\n            /(\\w+)=(.*)/;\n            if ($1 && $2) {\n                my ($tagname, $text) = ($1, $2);\n                my $comment_obj = Bio::Annotation::Comment->new(\n                                     -text => $text,\n                                     -tagname => $tagname);\n\n                $comments->add_Annotation('comment', $comment_obj);\n            }\n        }\n    }\n    $self->{'comments'} = $comments;\n    return $comments;\n}\n\n=head2 _get_header()\n\n Title   : _get_header($buffer)\n Usage   : $self->_get_header($buffer);\n Function: Gather the header section from the scf and parse it into its\n           components.\n Returns : Reference to a hash containing the header components.\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the header section of an scf file according to the\n           scf file specifications.\n Notes   : None.\n\n\nsub _get_header {\n    my ($self,$buffer) = @_;\n    my $header;\n    ($header->{'scf'},\n     $header->{'samples'},\n     $header->{'sample_offset'},\n     $header->{'bases'},\n     $header->{'bases_left_clip'},\n     $header->{'bases_right_clip'},\n     $header->{'bases_offset'},\n     $header->{'comment_size'},\n     $header->{'comments_offset'},\n     $header->{'version'},\n     $header->{'sample_size'},\n     $header->{'code_set'},\n     @{$header->{'header_spare'}} ) = unpack \"a4 NNNNNNNN a4 NN N20\", $buffer;\n\n    $self->{'header'} = $header;\n    return $header;\n}\n\n=head2 _parse_v2_bases($buffer)\n\n Title   : _parse_v2_bases($buffer)\n Usage   : $self->_parse_v2_bases($buffer);\n Function: Gather the bases section from the scf and parse it into its\n           components.\n Returns :\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the bases section of an scf file according to the\n           scf file specifications.\n Notes   : None.\n\n\nsub _parse_v2_bases {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my ($offset2,$currbuff,$currbase,$currqual,$sequence,@qualities,@indices);\n    my (@read,$harvester,$accuracies);\n    for ($offset2=0;$offset2<$length;$offset2+=12) {\n         @read = unpack \"N C C C C a C3\", substr($buffer,$offset2,$length);\n         push @indices,$read[0];\n         $currbase = lc($read[5]);\n         if ($currbase eq \"a\") { $currqual = $read[1]; }\n         elsif ($currbase eq \"c\") { $currqual = $read[2]; }\n         elsif ($currbase eq \"g\") { $currqual = $read[3]; }\n         elsif ($currbase eq \"t\") { $currqual = $read[4]; }\n         else { $currqual = \"UNKNOWN\"; }\n         push @{$accuracies->{\"a\"}},$read[1];\n         push @{$accuracies->{\"c\"}},$read[2];\n         push @{$accuracies->{\"g\"}},$read[3];\n         push @{$accuracies->{\"t\"}},$read[4];\n\n         $sequence .= $currbase;\n         push @qualities,$currqual;\n    }\n     return (\\@indices,\\@qualities,$sequence,$accuracies)\n}\n\n=head2 _parse_v2_traces(\\@traces_array)\n\n Title   : _pares_v2_traces(\\@traces_array)\n Usage   : $self->_parse_v2_traces(\\@traces_array);\n Function: Parses an scf Version2 trace array into its base components.\n Returns : Nothing. Modifies $self.\n Args    : A reference to an array of the unpacked traces section of an\n           scf version2 file.\n\n\nsub _parse_v2_traces {\n    my ($self,$buffer,$sample_size) = @_;\n     my $byte;\n     if ($sample_size == 1) { $byte = \"c\"; }\n     else { $byte = \"n\"; }\n     my $length = CORE::length($buffer);\n     my @read = unpack \"${byte}${length}\",$buffer;\n          # this will be an array to the reference holding the array\n     my $traces;\n     my $array = 0;\n     for (my $offset2 = 0; $offset2< scalar(@read); $offset2+=4) {\n              push @{$traces->{'a'}},$read[$offset2];\n              push @{$traces->{'t'}},$read[$offset2+1];\n              push @{$traces->{'g'}},$read[$offset2+3];\n              push @{$traces->{'c'}},$read[$offset2+2];\n    }\n    return $traces;\n}\n\n\nsub get_trace_deprecated_use_the_sequencetrace_object_instead {\n    # my ($self,$base_channel,$traces) = @_;\n    # $base_channel =~ tr/a-z/A-Z/;\n    # if ($base_channel !~ /A|T|G|C/) {\n    #   $self->throw(\"You tried to ask for a base channel that wasn't A,T,G, or C. Ask for one of those next time.\");\n    ##} elsif ($base_channel) {\n     #  my @temp = split(' ',$self->{'traces'}->{$base_channel});\n    #return \\@temp;\n    #}\n}\n\nsub _deprecated_get_peak_indices_deprecated_use_the_sequencetrace_object_instead {\n    my ($self) = shift;\n    my @temp = split(' ',$self->{'parsed'}->{'peak_indices'});\n    return \\@temp;\n}\n\n\n=head2 get_header()\n\n Title   : get_header()\n Usage   : %header = %{$obj->get_header()};\n Function: Return the header for this scf.\n Returns : A reference to a hash containing the header for this scf.\n Args    : None.\n Notes   :\n\n\nsub get_header {\n    my ($self) = shift;\n    return $self->{'header'};\n}\n\n=head2 get_comments()\n\n Title   : get_comments()\n Usage   : %comments = %{$obj->get_comments()};\n Function: Return the comments for this scf.\n Returns : A Bio::Annotation::Collection object\n Args    : None.\n Notes   :\n\n\nsub get_comments {\n    my ($self) = shift;\n    return $self->{'comments'};\n}\n\nsub _dump_traces_outgoing_deprecated_use_the_sequencetrace_object {\n    my ($self,$transformed) = @_;\n    my (@sA,@sT,@sG,@sC);\n    if ($transformed) {\n    @sA = @{$self->{'text'}->{'t_samples_a'}};\n    @sC = @{$self->{'text'}->{'t_samples_c'}};\n    @sG = @{$self->{'text'}->{'t_samples_g'}};\n    @sT = @{$self->{'text'}->{'t_samples_t'}};\n    }\n    else {\n    @sA = @{$self->{'text'}->{'samples_a'}};\n    @sC = @{$self->{'text'}->{'samples_c'}};\n    @sG = @{$self->{'text'}->{'samples_g'}};\n    @sT = @{$self->{'text'}->{'samples_t'}};\n    }\n    print (\"Count\\ta\\tc\\tg\\tt\\n\");\n    for (my $curr=0; $curr < scalar(@sG); $curr++) {\n    print(\"$curr\\t$sA[$curr]\\t$sC[$curr]\\t$sG[$curr]\\t$sT[$curr]\\n\");\n    }\n    return;\n}\n\nsub _dump_traces_incoming_deprecated_use_the_sequencetrace_object {\n    # my ($self) = @_;\n    # my (@sA,@sT,@sG,@sC);\n    # @sA = @{$self->{'traces'}->{'A'}};\n    # @sC = @{$self->{'traces'}->{'C'}};\n    # @sG = @{$self->{'traces'}->{'G'}};\n    # @sT = @{$self->{'traces'}->{'T'}};\n    # @sA = @{$self->get_trace('A')};\n    # @sC = @{$self->get_trace('C')};\n    # @sG = @{$self->get_trace('G')};\n    # @sT = @{$self->get_trace('t')};\n    # print (\"Count\\ta\\tc\\tg\\tt\\n\");\n    # for (my $curr=0; $curr < scalar(@sG); $curr++) {\n    #   print(\"$curr\\t$sA[$curr]\\t$sC[$curr]\\t$sG[$curr]\\t$sT[$curr]\\n\");\n    #}\n    #return;\n}\n\n=head2 write_seq\n\n Title   : write_seq(-target => $swq, <comments>)\n Usage   : $obj->write_seq(\n               -target => $swq,\n            -version => 2,\n            -CONV => \"Bioperl-Chads Mighty SCF writer.\");\n Function: Write out an scf.\n Returns : Nothing.\n Args    : Requires: a reference to a Bio::Seq::Quality object to form the\n           basis for the scf.\n       if -version is provided, it should be \"2\" or \"3\". A SCF of that\n       version will be written.\n       Any other arguments are assumed to be comments and are put into\n       the comments section of the scf. Read the specifications for scf\n       to decide what might be good to put in here.\n\n Notes   :\n          For best results, use a SequenceTrace object.\n          The things that you need to write an scf:\n          a) sequence\n          b) quality\n          c) peak indices\n          d) traces\n          - You _can_ write an scf with just a and b by passing in a\n               Bio::Seq::Quality object- false traces will be synthesized\n               for you.\n\n\nsub write_seq {\n    my ($self,%args) = @_;\n    my %comments;\n    my ($label,$arg);\n    my ($swq) = $self->_rearrange([qw(TARGET)], %args);\n     my $writer_fodder;\n     if (ref($swq) =~ /Bio::Seq::SequenceTrace|Bio::Seq::Quality/) {\n               if (ref($swq) eq \"Bio::Seq::Quality\") {\n                         # this means that the object *has no trace data*\n                         # we might as well synthesize some now, ok?\n                    $swq = Bio::Seq::SequenceTrace->new(\n                         -swq     =>   $swq\n                    );\n               }\n     }\n    else  {\n    $self->throw(\"You must pass a Bio::Seq::Quality or a Bio::Seq::SequenceTrace object to write_seq as a parameter named \\\"target\\\"\");\n    }\n          # all of the rest of the arguments are comments for the scf\n    foreach $arg (sort keys %args) {\n    next if ($arg =~ /target/i);\n    ($label = $arg) =~ s/^\\-//;\n    $writer_fodder->{comments}->{$label} = $args{$arg};\n    }\n    if (!$comments{'NAME'}) { $comments{'NAME'} = $swq->id(); }\n          # HA! Bwahahahaha.\n    $writer_fodder->{comments}->{'CONV'} = \"Bioperl-Chads Mighty SCF writer.\" unless defined $comments{'CONV'};\n          # now deal with the version of scf they want to write\n    if ($writer_fodder->{comments}->{version}) {\n         if ($writer_fodder->{comments}->{version} != 2 && $writer_fodder->{comments}->{version} != 3) {\n              $self->warn(\"This module can only write version 2.0 or 3.0 scf's. Writing a version 2.0 scf by default.\");\n              $writer_fodder->{header}->{version} = \"2.00\";\n         }\n         elsif ($writer_fodder->{comments}->{'version'} > 2) {\n              $writer_fodder->{header}->{'version'} = \"3.00\";\n         }\n          else {\n               $writer_fodder->{header}->{version} = \"2\";\n          }\n    }\n    else {\n         $writer_fodder->{header}->{'version'} = \"3.00\";\n    }\n          # set a few things in the header\n    $writer_fodder->{'header'}->{'magic'} = \".scf\";\n    $writer_fodder->{'header'}->{'sample_size'} = \"2\";\n    $writer_fodder->{'header'}->{'bases'} = length($swq->seq());\n    $writer_fodder->{'header'}->{'bases_left_clip'} = \"0\";\n    $writer_fodder->{'header'}->{'bases_right_clip'} = \"0\";\n    $writer_fodder->{'header'}->{'sample_size'} = \"2\";\n    $writer_fodder->{'header'}->{'code_set'} = \"9\";\n    @{$writer_fodder->{'header'}->{'spare'}} = qw(0 0 0 0 0 0 0 0 0 0\n                     0 0 0 0 0 0 0 0 0 0);\n    $writer_fodder->{'header'}->{'samples_offset'} = \"128\";\n     $writer_fodder->{'header'}->{'samples'} = $swq->trace_length();\n          # create the binary for the comments and file it in writer_fodder\n    $writer_fodder->{comments} =  $self->_get_binary_comments(\n               $writer_fodder->{comments});\n          # create the binary and the strings for the traces, bases,\n          # offsets (if necessary), and accuracies (if necessary)\n    $writer_fodder->{traces} = $self->_get_binary_traces(\n               $writer_fodder->{'header'}->{'version'},\n               $swq,$writer_fodder->{'header'}->{'sample_size'});\n    my ($b_base_offsets,$b_base_accuracies,$samples_size,$bases_size);\n    #\n    # version 2\n    #\n    if ($writer_fodder->{'header'}->{'version'} == 2) {\n          $writer_fodder->{bases} = $self->_get_binary_bases(\n                         2,\n                         $swq,\n                         $writer_fodder->{'header'}->{'sample_size'});\n         $samples_size = CORE::length($writer_fodder->{traces}->{'binary'});\n         $bases_size = CORE::length($writer_fodder->{bases}->{binary});\n         $writer_fodder->{'header'}->{'bases_offset'} = 128 + $samples_size;\n         $writer_fodder->{'header'}->{'comments_offset'} = 128 +\n               $samples_size + $bases_size;\n         $writer_fodder->{'header'}->{'comments_size'} =\n               length($writer_fodder->{'comments'}->{binary});\n         $writer_fodder->{'header'}->{'private_size'} = \"0\";\n         $writer_fodder->{'header'}->{'private_offset'} = 128 +\n               $samples_size + $bases_size +\n               $writer_fodder->{'header'}->{'comments_size'};\n          $writer_fodder->{'header'}->{'binary'} =\n          $self->_get_binary_header($writer_fodder->{header});\n          $dumper->dumpValue($writer_fodder) if $self->verbose > 0;\n         $self->_print ($writer_fodder->{'header'}->{'binary'})\n               or print(\"Could not write binary header...\\n\");\n         $self->_print ($writer_fodder->{'traces'}->{'binary'})\n               or print(\"Could not write binary traces...\\n\");\n         $self->_print ($writer_fodder->{'bases'}->{'binary'})\n               or print(\"Could not write binary base structures...\\n\");\n         $self->_print ($writer_fodder->{'comments'}->{'binary'})\n               or print(\"Could not write binary comments...\\n\");\n    }\n    else {\n          ($writer_fodder->{peak_indices},\n           $writer_fodder->{accuracies},\n           $writer_fodder->{bases},\n           $writer_fodder->{reserved} ) =\n               $self->_get_binary_bases(\n                    3,\n                    $swq,\n                    $writer_fodder->{'header'}->{'sample_size'}\n               );\n         $writer_fodder->{'header'}->{'bases_offset'} = 128 +\n               length($writer_fodder->{'traces'}->{'binary'});\n         $writer_fodder->{'header'}->{'comments_size'} =\n               length($writer_fodder->{'comments'}->{'binary'});\n              # this is:\n              # bases_offset + base_offsets + accuracies + called_bases +\n               # reserved\n         $writer_fodder->{'header'}->{'private_size'} = \"0\";\n\n         $writer_fodder->{'header'}->{'comments_offset'} =\n              128+length($writer_fodder->{'traces'}->{'binary'})+\n                 length($writer_fodder->{'peak_indices'}->{'binary'})+\n                 length($writer_fodder->{'accuracies'}->{'binary'})+\n                length($writer_fodder->{'bases'}->{'binary'})+\n                length($writer_fodder->{'reserved'}->{'binary'});\n    $writer_fodder->{'header'}->{'private_offset'} =\n          $writer_fodder->{'header'}->{'comments_offset'} +\n               $writer_fodder->{'header'}->{'comments_size'};\n    $writer_fodder->{'header'}->{'spare'}->[1] =\n         $writer_fodder->{'header'}->{'comments_offset'} +\n             length($writer_fodder->{'comments'}->{'binary'});\n     $writer_fodder->{header}->{binary} =\n          $self->_get_binary_header($writer_fodder->{header});\n    $self->_print ($writer_fodder->{'header'}->{'binary'})\n          or print(\"Couldn't write header\\n\");\n    $self->_print ($writer_fodder->{'traces'}->{'binary'})\n          or print(\"Couldn't write samples\\n\");\n    $self->_print ($writer_fodder->{'peak_indices'}->{'binary'})\n          or print(\"Couldn't write peak offsets\\n\");\n    $self->_print ($writer_fodder->{'accuracies'}->{'binary'})\n          or print(\"Couldn't write accuracies\\n\");\n    $self->_print ($writer_fodder->{'bases'}->{'binary'})\n          or print(\"Couldn't write called_bases\\n\");\n    $self->_print ($writer_fodder->{'reserved'}->{'binary'})\n          or print(\"Couldn't write reserved\\n\");\n    $self->_print ($writer_fodder->{'comments'}->{'binary'})\n          or print (\"Couldn't write comments\\n\");\n    }\n\n    # kinda unnecessary, given the close() below, but maybe that'll go\n    # away someday.\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n\n    $self->close();\n    return 1;\n}\n\n\n\n\n\n=head2 _get_binary_header()\n\n Title   : _get_binary_header();\n Usage   : $self->_get_binary_header();\n Function: Provide the binary string that will be used as the header for\n            a scfv2 document.\n Returns : A binary string.\n Args    : None. Uses the entries in the $self->{'header'} hash. These\n            are set on construction of the object (hopefully correctly!).\n Notes   :\n\n\nsub _get_binary_header {\n    my ($self,$header) = @_;\n    my $binary = pack \"a4 NNNNNNNN a4 NN N20\",\n    (\n     $header->{'magic'},\n     $header->{'samples'},\n     $header->{'samples_offset'},\n     $header->{'bases'},\n     $header->{'bases_left_clip'},\n     $header->{'bases_right_clip'},\n     $header->{'bases_offset'},\n     $header->{'comments_size'},\n     $header->{'comments_offset'},\n     $header->{'version'},\n     $header->{'sample_size'},\n     $header->{'code_set'},\n     @{$header->{'spare'}}\n     );\n    return $binary;\n}\n\n=head2 _get_binary_traces($version,$ref)\n\n Title   : _set_binary_tracesbases($version,$ref)\n Usage   : $self->_set_binary_tracesbases($version,$ref);\n Function: Constructs the trace and base strings for all scfs\n Returns : Nothing. Alters self.\n Args    : $version - \"2\" or \"3\"\n       $sequence - a scalar containing arbitrary sequence data\n       $ref - a reference to either a SequenceTraces or a\n          SequenceWithQuality object.\n Notes   : This is a really complicated thing.\n\n\nsub _get_binary_traces {\n    my ($self,$version,$ref,$sample_size) = @_;\n          # ref _should_ be a Bio::Seq::SequenceTrace, but might be a\n          # Bio::Seq::Quality\n     my $returner;\n     my $sequence = $ref->seq();\n     my $sequence_length = length($sequence);\n          # first of all, do we need to synthesize the trace?\n          # if so, call synthesize_base\n     my ($traceobj,@traces,$current);\n     if ( ref($ref) eq \"Bio::Seq::Quality\" ) {\n          $traceobj = Bio::Seq::Quality->new(\n               -target   =>   $ref\n          );\n          $traceobj->_synthesize_traces();\n     }\n     else {\n          $traceobj = $ref;\n          if ($version eq \"2\") {\n               my $trace_length = $traceobj->trace_length();\n               for ($current = 1; $current <= $trace_length; $current++) {\n                    foreach (qw(a c g t)) {\n                         push @traces,$traceobj->trace_value_at($_,$current);\n                    }\n               }\n          }\n          elsif ($version == 3) {\n               foreach my $current_trace (qw(a c g t)) {\n                    my @trace = @{$traceobj->trace($current_trace)};\n                    foreach (@trace) {\n                         if ($_ > 30000) {\n                              $_ -= 65536;\n                         }\n                    }\n                    my $transformed = $self->_delta(\\@trace,\"forward\");\n                    if($sample_size == 1){\n                         foreach (@{$transformed}) {\n                              $_ += 256 if ($_ < 0);\n                         }\n                    }\n                    push @traces,@{$transformed};\n               }\n          }\n     }\n     $returner->{version} = $version;\n     $returner->{string} = \\@traces;\n     my $length_of_traces = scalar(@traces);\n     my $byte;\n     if ($sample_size == 1) { $byte = \"c\"; } else { $byte = \"n\"; }\n          # an unsigned integer should be I, but this is too long\n          #\n     $returner->{binary} = pack \"n${length_of_traces}\",@traces;\n     $returner->{length} = CORE::length($returner->{binary});\n     return $returner;\n}\n\n\nsub _get_binary_bases {\n     my ($self,$version,$trace,$sample_size) = @_;\n     my $byte;\n     if ($sample_size == 1) { $byte = \"c\"; } else { $byte = \"n\"; }\n     my ($returner,@current_row,$current_base,$string,$binary);\n     my $length = $trace->length();\n     if ($version == 2) {\n          $returner->{'version'} = \"2\";\n         for (my $current_base =1; $current_base <= $length; $current_base++) {\n               my @current_row;\n               push @current_row,$trace->peak_index_at($current_base);\n               push @current_row,$trace->accuracy_at(\"a\",$current_base);\n               push @current_row,$trace->accuracy_at(\"c\",$current_base);\n               push @current_row,$trace->accuracy_at(\"g\",$current_base);\n               push @current_row,$trace->accuracy_at(\"t\",$current_base);\n               push @current_row,$trace->baseat($current_base);\n               push @current_row,0,0,0;\n               push @{$returner->{string}},@current_row;\n               $returner->{binary} .= pack \"N C C C C a C3\",@current_row;\n          }\n          return $returner;\n     }\n     else {\n          $returner->{'version'} = \"3.00\";\n          $returner->{peak_indices}->{string} = $trace->peak_indices();\n          my $length = scalar(@{$returner->{peak_indices}->{string}});\n          $returner->{peak_indices}->{binary} =\n               pack \"N$length\",@{$returner->{peak_indices}->{string}};\n          $returner->{peak_indices}->{length} =\n               CORE::length($returner->{peak_indices}->{binary});\n          my @accuracies;\n          foreach my $base (qw(a c g t)) {\n               $returner->{accuracies}->{$base} = $trace->accuracies($base);\n               push @accuracies,@{$trace->accuracies($base)};\n          }\n          $returner->{sequence} = $trace->seq();\n          $length = scalar(@accuracies);\n               # this really is \"c\" for samplesize == 2\n          $returner->{accuracies}->{binary} = pack \"C${length}\",@accuracies;\n          $returner->{accuracies}->{length} =\n               CORE::length($returner->{accuracies}->{binary});\n          $length = $trace->seq_obj()->length();\n          for (my $count=0; $count< $length; $count++) {\n               push @{$returner->{reserved}->{string}},0,0,0;\n          }\n     }\n     $length = scalar(@{$returner->{reserved}->{string}});\n               # this _must_ be \"c\"\n     $returner->{'reserved'}->{'binary'} =\n          pack \"c$length\",@{$returner->{reserved}->{string}};\n     $returner->{'reserved'}->{'length'} =\n          CORE::length($returner->{'reserved'}->{'binary'});\n          # $returner->{'bases'}->{'string'} = $trace->seq();\n     my @bases = split('',$trace->seq());\n     $length = $trace->length();\n     $returner->{'bases'}->{'binary'} = $trace->seq();\n          # print(\"Returning this:\\n\");\n          # $dumper->dumpValue($returner);\n     return ($returner->{peak_indices},\n             $returner->{accuracies},\n             $returner->{bases},\n             $returner->{reserved});\n\n}\n\n\n=head2 _make_trace_string($version)\n\n Title   : _make_trace_string($version)\n Usage   : $self->_make_trace_string($version)\n Function: Merges trace data for the four bases to produce an scf\n       trace string. _requires_ $version\n Returns : Nothing. Alters $self.\n Args    : $version - a version number. \"2\" or \"3\"\n Notes   :\n\n\nsub _make_trace_string {\n    my ($self,$version) = @_;\n    my @traces;\n    my @traces_view;\n    my @as = @{$self->{'text'}->{'samples_a'}};\n    my @cs = @{$self->{'text'}->{'samples_c'}};\n    my @gs = @{$self->{'text'}->{'samples_g'}};\n    my @ts = @{$self->{'text'}->{'samples_t'}};\n    if ($version == 2) {\n        for (my $curr=0; $curr < scalar(@as); $curr++) {\n        $as[$curr] = $DEFAULT_QUALITY unless defined $as[$curr];\n        $cs[$curr] = $DEFAULT_QUALITY unless defined $cs[$curr];\n        $gs[$curr] = $DEFAULT_QUALITY unless defined $gs[$curr];\n        $ts[$curr] = $DEFAULT_QUALITY unless defined $ts[$curr];\n        push @traces,($as[$curr],$cs[$curr],$gs[$curr],$ts[$curr]);\n        }\n    }\n    elsif ($version == 3) {\n        @traces = (@as,@cs,@gs,@ts);\n    }\n    else {\n        $self->throw(\"No idea what version required to make traces here. You gave #$version#  Bailing.\");\n    }\n    my $length = scalar(@traces);\n    $self->{'text'}->{'samples_all'} = \\@traces;\n\n}\n\n=head2 _get_binary_comments(\\@comments)\n\n Title   : _get_binary_comments(\\@comments)\n Usage   : $self->_get_binary_comments(\\@comments);\n Function: Provide a binary string that will be the comments section of\n       the scf file. See the scf specifications for detailed\n       specifications for the comments section of an scf file. Hint:\n       CODE=something\\nBODE=something\\n\\0\n Returns :\n Args    : A reference to an array containing comments.\n Notes   : None.\n\n\nsub _get_binary_comments {\n    my ($self,$rcomments) = @_;\n     my $returner;\n    my $comments_string = '';\n    my %comments = %$rcomments;\n    foreach my $key (sort keys %comments) {\n    $comments{$key} ||= '';\n    $comments_string .= \"$key=$comments{$key}\\n\";\n    }\n    $comments_string .= \"\\n\\0\";\n     my $length = CORE::length($comments_string);\n     $returner->{length} = $length;\n     $returner->{string} = $comments_string;\n     $returner->{binary} = pack \"A$length\",$comments_string;\n     return $returner;\n}\n\n#=head2 _fill_missing_data($swq)\n#\n# Title   : _fill_missing_data($swq)\n# Usage   : $self->_fill_missing_data($swq);\n# Function: If the $swq with quality has no qualities, set all qualities\n#      to 0.\n#      If the $swq has no sequence, set the sequence to N's.\n# Returns : Nothing. Modifies the Bio::Seq::Quality that was passed as an\n#      argument.\n# Args    : A reference to a Bio::Seq::Quality\n# Notes   : None.\n#\n#=cut\n#\n##'\n#sub _fill_missing_data {\n#    my ($self,$swq) = @_;\n#    my $qual_obj = $swq->qual_obj();\n#    my $seq_obj = $swq->seq_obj();\n#    if ($qual_obj->length() == 0 && $seq_obj->length() != 0) {\n#   my $fake_qualities = (\"$DEFAULT_QUALITY \")x$seq_obj->length();\n#   $swq->qual($fake_qualities);\n#    }\n#    if ($seq_obj->length() == 0 && $qual_obj->length != 0) {\n#   my $sequence = (\"N\")x$qual_obj->length();\n#   $swq->seq($sequence);\n#    }\n#}\n\n=head2 _delta(\\@trace_data,$direction)\n\n Title   : _delta(\\@trace_data,$direction)\n Usage   : $self->_delta(\\@trace_data,$direction);\n Function:\n Returns : A reference to an array containing modified trace values.\n Args    : A reference to an array containing trace data and a string\n       indicating the direction of conversion. (\"forward\" or\n       \"backward\").\n Notes   : This code is taken from the specification for SCF3.2.\n       http://www.mrc-lmb.cam.ac.uk/pubseq/manual/formats_unix_4.html\n\n\n\nsub _delta {\n    my ($self,$rsamples,$direction) = @_;\n    my @samples = @$rsamples;\n        # /* If job == DELTA_IT:\n        # *  change a series of sample points to a series of delta delta values:\n        # *  ie change them in two steps:\n        # *  first: delta = current_value - previous_value\n        # *  then: delta_delta = delta - previous_delta\n        # * else\n        # *  do the reverse\n        # */\n        # int i;\n        # uint_2 p_delta, p_sample;\n\n    my ($i,$num_samples,$p_delta,$p_sample,@samples_converted,$p_sample1,$p_sample2);\n        my $SLOW_BUT_CLEAR = 0;\n        $num_samples = scalar(@samples);\n    # c-programmers are funny people with their single-letter variables\n\n    if ( $direction eq \"forward\" ) {\n            if($SLOW_BUT_CLEAR){\n        $p_delta  = 0;\n        for ($i=0; $i < $num_samples; $i++) {\n            $p_sample = $samples[$i];\n            $samples[$i] = $samples[$i] - $p_delta;\n            $p_delta  = $p_sample;\n        }\n        $p_delta  = 0;\n        for ($i=0; $i < $num_samples; $i++) {\n            $p_sample = $samples[$i];\n            $samples[$i] = $samples[$i] - $p_delta;\n            $p_delta  = $p_sample;\n        }\n            } else {\n                for ($i = $num_samples-1; $i > 1; $i--){\n                    $samples[$i] = $samples[$i] - 2*$samples[$i-1] + $samples[$i-2];\n                }\n                $samples[1] = $samples[1] - 2*$samples[0];\n            }\n    }\n    elsif ($direction eq \"backward\") {\n            if($SLOW_BUT_CLEAR){\n        $p_sample = 0;\n        for ($i=0; $i < $num_samples; $i++) {\n            $samples[$i] = $samples[$i] + $p_sample;\n            $p_sample = $samples[$i];\n        }\n        $p_sample = 0;\n        for ($i=0; $i < $num_samples; $i++) {\n            $samples[$i] = $samples[$i] + $p_sample;\n            $p_sample = $samples[$i];\n        }\n            } else {\n                $p_sample1 = $p_sample2 = 0;\n                for ($i = 0; $i < $num_samples; $i++){\n                    $p_sample1 = $p_sample1 + $samples[$i];\n                    $samples[$i] = $p_sample1 + $p_sample2;\n                    $p_sample2 = $samples[$i];\n                }\n\n            }\n    }\n    else {\n        $self->warn(\"Bad direction. Use \\\"forward\\\" or \\\"backward\\\".\");\n    }\n    return \\@samples;\n}\n\n=head2 _unpack_magik($buffer)\n\n Title   : _unpack_magik($buffer)\n Usage   : $self->_unpack_magik($buffer)\n Function: What unpack specification should be used? Try them all.\n Returns : Nothing.\n Args    : A buffer containing arbitrary binary data.\n Notes   : Eliminate the ambiguity and the guesswork. Used in the\n       adaptation of _delta(), mostly.\n\n\nsub _unpack_magik {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my (@read,$counter);\n    foreach (qw(c C s S i I l L n N v V)) {\n        @read = unpack \"$_$length\", $buffer;\n        for ($counter=0; $counter < 20; $counter++) {\n            print(\"$read[$counter]\\n\");\n        }\n    }\n}\n\n=head2 read_from_buffer($filehandle,$buffer,$length)\n\n Title   : read_from_buffer($filehandle,$buffer,$length)\n Usage   : $self->read_from_buffer($filehandle,$buffer,$length);\n Function: Read from the buffer.\n Returns : $buffer, containing a read of $length\n Args    : a filehandle, a buffer, and a read length\n Notes   : I just got tired of typing\n       \"unless (length($buffer) == $length)\" so I put it here.","label":"read_from_buffer($self,$fh,$buffer,$length,$start_position)"},"range":{"end":{"line":1183,"character":9999},"start":{"character":0,"line":1155}},"kind":12,"line":1155},{"children":[{"definition":"my","name":"$rhash","localvar":"my","kind":13,"containerName":"_dump_keys","line":1197},{"name":"$rhash","containerName":"_dump_keys","kind":13,"line":1198},{"name":"$rhash","containerName":"_dump_keys","kind":13,"line":1199},{"name":"$rhash","kind":13,"containerName":"_dump_keys","line":1203}],"containerName":"main::","name":"_dump_keys","definition":"sub","line":1196,"kind":12,"range":{"end":{"line":1206,"character":9999},"start":{"line":1196,"character":0}}},{"line":1219,"range":{"end":{"character":9999,"line":1223},"start":{"character":0,"line":1219}},"kind":12,"children":[{"name":"$self","containerName":"_dump_base_accuracies","localvar":"my","kind":13,"line":1220,"definition":"my"},{"line":1223,"containerName":"_dump_base_accuracies","kind":13,"name":"$self"}],"containerName":"main::","name":"_dump_base_accuracies","definition":"sub"},{"kind":13,"containerName":null,"name":"%self","line":1223},{"name":"%self","kind":13,"containerName":null,"line":1223},{"containerName":null,"kind":13,"name":"%self","line":1223},{"definition":"my","name":"$number_traces","kind":13,"localvar":"my","containerName":null,"line":1224},{"name":"%self","containerName":null,"kind":13,"line":1224},{"line":1225,"name":"$counter","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"line":1225,"containerName":null,"kind":13,"name":"$counter"},{"containerName":null,"kind":13,"name":"$number_traces","line":1225},{"line":1225,"name":"%counter","containerName":null,"kind":13},{"name":"%self","kind":13,"containerName":null,"line":1227},{"containerName":null,"kind":13,"name":"$counter","line":1227},{"kind":13,"containerName":null,"name":"%self","line":1228},{"containerName":null,"kind":13,"name":"$counter","line":1228},{"name":"%self","kind":13,"containerName":null,"line":1229},{"line":1229,"name":"$counter","containerName":null,"kind":13},{"line":1230,"name":"%self","containerName":null,"kind":13},{"name":"$counter","kind":13,"containerName":null,"line":1230},{"definition":"sub","children":[{"definition":"my","line":1247,"name":"$self","localvar":"my","containerName":"_dump_peak_indices_incoming","kind":13},{"line":1249,"containerName":"_dump_peak_indices_incoming","localvar":"my","kind":13,"name":"$length","definition":"my"},{"line":1249,"name":"$self","kind":13,"containerName":"_dump_peak_indices_incoming"},{"definition":"my","line":1251,"name":"$count","localvar":"my","kind":13,"containerName":"_dump_peak_indices_incoming"},{"kind":13,"containerName":"_dump_peak_indices_incoming","name":"$count","line":1251},{"kind":13,"containerName":"_dump_peak_indices_incoming","name":"$length","line":1251},{"containerName":"_dump_peak_indices_incoming","kind":13,"name":"$count","line":1251}],"containerName":"main::","name":"_dump_peak_indices_incoming","line":1246,"range":{"end":{"line":1254,"character":9999},"start":{"character":0,"line":1246}},"kind":12},{"definition":"sub","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"_dump_base_accuracies_incoming","name":"$self","line":1268},{"line":1272,"name":"$number_traces","localvar":"my","kind":13,"containerName":"_dump_base_accuracies_incoming","definition":"my"},{"name":"$self","containerName":"_dump_base_accuracies_incoming","kind":13,"line":1272},{"line":1273,"localvar":"my","containerName":"_dump_base_accuracies_incoming","kind":13,"name":"$counter","definition":"my"},{"line":1273,"containerName":"_dump_base_accuracies_incoming","kind":13,"name":"$counter"},{"kind":13,"containerName":"_dump_base_accuracies_incoming","name":"$number_traces","line":1273},{"line":1273,"containerName":"_dump_base_accuracies_incoming","kind":13,"name":"$counter"},{"line":1276,"name":"$self","containerName":"_dump_base_accuracies_incoming","kind":13},{"line":1276,"name":"$counter","kind":13,"containerName":"_dump_base_accuracies_incoming"}],"name":"_dump_base_accuracies_incoming","containerName":"main::","line":1267,"kind":12,"range":{"end":{"line":1280,"character":9999},"start":{"character":0,"line":1267}}},{"signature":{"documentation":"__END__\n# $Id: scf.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# Copyright (c) 1997-2001 bioperl, Chad Matsalla. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::scf - .scf file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly. Use it via the Bio::SeqIO class, see\nL<Bio::SeqIO> for more information.\n\n=head1 DESCRIPTION\n\nThis object can transform .scf files to and from Bio::Seq::SequenceTrace\nobjects.  Mechanisms are present to retrieve trace data from scf\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chad Matsalla\n\nChad Matsalla\nbioinformatics@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\nTony Cox, avc@sanger.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\nNancy Hansen, nhansen at mail.nih.gov\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::scf;\nuse vars qw($DEFAULT_QUALITY);\nuse strict;\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SequenceTrace;\nuse Bio::Annotation::Comment;\nuse Dumpvalue;\n\nmy $dumper = new Dumpvalue();\n$dumper->veryCompact(1);\n\nBEGIN {\n    $DEFAULT_QUALITY= 10;\n}\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n                  (-verbose => $self->verbose(),\n                   -type => 'Bio::Seq::Quality'));\n  }\n  binmode $self->_fh; # for the Win32/Mac crowds  \n}\n\n=head2 next_seq()\n\n Title   : next_seq()\n Usage   : $scf = $stream->next_seq()\n Function: returns the next scf sequence in the stream\n Returns : a Bio::Seq::SequenceTrace object\n Args    : NONE\n Notes   : Fills the interface specification for SeqIO.\n            The SCF specification does not provide for having more then\n           one sequence in a given scf. So once the filehandle has been open\n           and passed to SeqIO do not expect to run this function more then\n           once on a given scf unless you embraced and extended the SCF\n       standard.  SCF comments are accessible through the Bio::SeqI\n           interface method annotation().\n\n\n#'\nsub next_seq {\n    my ($self) = @_;\n    my ($seq, $seqc, $fh, $buffer, $offset, $length, $read_bytes, @read,\n         %names);\n    # set up a filehandle to read in the scf\n    return if $self->{_readfile};\n    $fh = $self->_fh();\n    unless ($fh) {      # simulate the <> function\n        if ( !fileno(ARGV) or eof(ARGV) ) {\n            return unless my $ARGV = shift;\n            open(ARGV,$ARGV) or\n              $self->throw(\"Could not open $ARGV for SCF stream reading $!\");\n        }\n        $fh = \\*ARGV;\n    }\n    return unless read $fh, $buffer, 128; # no exception; probably end of file\n    # now, the master data structure will be the creator\n    my $creator;\n    # he first thing to do is parse the header. This is common\n    # among all versions of scf.\n    # the rest of the the information is different between the\n    # the different versions of scf.\n\n    $creator->{header} = $self->_get_header($buffer);\n    if ($creator->{header}->{'version'} lt \"3.00\") {\n        $self->debug(\"scf.pm is working with a version 2 scf.\\n\");\n        # first gather the trace information\n        $length = $creator->{header}->{'samples'} *\n          $creator->{header}->{sample_size}*4;\n        $buffer = $self->read_from_buffer($fh, $buffer, $length,\n                                                     $creator->{header}->{samples_offset});\n        # @read = unpack \"n$length\",$buffer;\n        # these traces need to be split\n        # returns a reference to a hash\n        $creator->{traces} = $self->_parse_v2_traces(\n                                                     $buffer,$creator->{header}->{sample_size});\n        # now go and get the base information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 12);\n        seek $fh,$offset,0;\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$creator->{header}->{bases_offset});\n        # now distill the information into its fractions.\n        # the old way : $self->_set_v2_bases($buffer);\n        # ref to an array, ref to a hash, string\n        ($creator->{peak_indices},\n         $creator->{qualities},\n         $creator->{sequence},\n         $creator->{accuracies}) = $self->_parse_v2_bases($buffer);\n\n    } else {\n        $self->debug(\"scf.pm is working with a version 3+ scf.\\n\");\n        my $transformed_read;\n        my $current_read_position = $creator->{header}->{sample_offset};\n        $length = $creator->{header}->{'samples'}*\n          $creator->{header}->{sample_size};\n        # $dumper->dumpValue($creator->{header});\n        foreach (qw(a c g t)) {\n            $buffer = $self->read_from_buffer($fh,$buffer,$length,$current_read_position);\n            my $byte = \"n\";\n            if ($creator->{header}->{sample_size} == 1) {\n                $byte = \"c\";\n            }\n            @read = unpack \"${byte}${length}\",$buffer;\n            # this little spurt of nonsense is because\n            # the trace values are given in the binary\n            # file as unsigned shorts but they really\n            # are signed deltas. 30000 is an arbitrary number\n            # (will there be any traces with a given\n            # point greater then 30000? I hope not.\n            # once the read is read, it must be changed\n            # from relative\n            foreach (@read) {\n                if ($_ > 30000) {\n                    $_ -= 65536;\n                }\n            }\n            $transformed_read = $self->_delta(\\@read,\"backward\");\n            # For 8-bit data we need to emulate a signed/unsigned\n            # cast that is implicit in the C implementations.....\n            if ($creator->{header}->{sample_size} == 1) {\n                foreach (@{$transformed_read}) {\n                    $_ += 256 if ($_ < 0);\n                }\n            }\n            $current_read_position += $length;\n            $creator->{'traces'}->{$_} = join(' ',@{$transformed_read});\n        }\n        \n        # now go and get the peak index information\n        $offset = $creator->{header}->{bases_offset};\n        $length = ($creator->{header}->{bases} * 4);\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{peak_indices} = $self->_get_v3_peak_indices($buffer);\n        $offset += $length;\n        # now go and get the accuracy information\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{accuracies} = $self->_get_v3_base_accuracies($buffer);\n        # OK, now go and get the base information.\n        $offset += $length;\n        $length = $creator->{header}->{bases};\n        $buffer = $self->read_from_buffer($fh,$buffer,$length,$offset);\n        $creator->{'sequence'} = unpack(\"a$length\",$buffer);\n        # now, finally, extract the calls from the accuracy information.\n        $creator->{qualities} = $self->_get_v3_quality(\n                                              $creator->{'sequence'},$creator->{accuracies});\n    }\n    # now go and get the comment information\n    $offset = $creator->{header}->{comments_offset};\n    seek $fh,$offset,0;\n    $length = $creator->{header}->{comment_size};\n    $buffer = $self->read_from_buffer($fh,$buffer,$length);\n    $creator->{comments} = $self->_get_comments($buffer);\n    my @name_comments = grep {$_->tagname() eq 'NAME'}\n                $creator->{comments}->get_Annotations('comment');\n    my $name_comment;\n    if (@name_comments){\n         $name_comment = $name_comments[0]->as_text();\n         $name_comment =~ s/^Comment:\\s+//;\n    }\n\n    my $swq = Bio::Seq::Quality->new(\n        -seq  =>   $creator->{'sequence'},\n        -qual =>    $creator->{'qualities'},\n        -id   =>    $name_comment\n                                              );\n    my $returner = Bio::Seq::SequenceTrace->new(\n                                           -swq      =>   $swq,\n                                            -trace_a  =>   $creator->{'traces'}->{'a'},\n                                            -trace_t  =>   $creator->{'traces'}->{'t'},\n                                           -trace_g  =>   $creator->{'traces'}->{'g'},\n                                           -trace_c  =>   $creator->{'traces'}->{'c'},\n                                       -accuracy_a    => $creator->{'accuracies'}->{'a'},\n                                   -accuracy_t    => $creator->{'accuracies'}->{'t'},\n                                      -accuracy_g    => $creator->{'accuracies'}->{'g'},\n                                    -accuracy_c    => $creator->{'accuracies'}->{'c'},\n                                 -peak_indices  => $creator->{'peak_indices'}\n                                                             );\n\n        $returner->annotation($creator->{'comments'}); # add SCF comments\n    $self->{'_readfile'} = 1;\n    return $returner;\n}\n\n\n=head2 _get_v3_quality()\n\n Title   : _get_v3_quality()\n Usage   : $self->_get_v3_quality()\n Function: Set the base qualities from version3 scf\n Returns : Nothing. Alters $self.\n Args    : None.\n Notes   :\n\n\n#'\nsub _get_v3_quality {\n    my ($self,$sequence,$accuracies) = @_;\n    my @bases = split//,$sequence;\n    my (@qualities,$currbase,$currqual,$counter);\n    for ($counter=0; $counter <= $#bases ; $counter++) {\n    $currbase = lc($bases[$counter]);\n    if ($currbase eq \"a\") { $currqual = $accuracies->{'a'}->[$counter]; }\n    elsif ($currbase eq \"c\") { $currqual = $accuracies->{'c'}->[$counter]; }\n    elsif ($currbase eq \"g\") { $currqual = $accuracies->{'g'}->[$counter]; }\n    elsif ($currbase eq \"t\") { $currqual = $accuracies->{'t'}->[$counter]; }\n    else { $currqual = \"unknown\"; }\n    push @qualities,$currqual;\n    }\n    return \\@qualities;\n}\n\n=head2 _get_v3_peak_indices($buffer)\n\n Title   : _get_v3_peak_indices($buffer)\n Usage   : $self->_get_v3_peak_indices($buffer);\n Function: Unpacks the base accuracies for version3 scf\n Returns : Nothing. Alters $self\n Args    : A scalar containing binary data.\n Notes   :\n\n\nsub _get_v3_peak_indices {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my @read = unpack \"N$length\",$buffer;\n     return join(' ',@read);\n}\n\n=head2 _get_v3_base_accuracies($buffer)\n\n Title   : _get_v3_base_accuracies($buffer)\n Usage   : $self->_get_v3_base_accuracies($buffer)\n Function: Set the base accuracies for version 3 scf's\n Returns : Nothing. Alters $self.\n Args    : A scalar containing binary data.\n Notes   :\n\n\n#'\nsub _get_v3_base_accuracies {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my $qlength = $length/4;\n    my $offset = 0;\n    my (@qualities,@sorter,$counter,$round,$last_base,$accuracies,$currbase);\n    foreach $currbase (qw(a c g t)) {\n         my @read;\n         $last_base = $offset + $qlength;\n         for (;$offset < $last_base; $offset += $qlength) {\n                    # a bioperler (perhaps me?) changed the unpack string to include 'n' rather than 'C'\n                    # on 040322 I think that 'C' is correct. please email chad if you would like to accuse me of being incorrect\n              @read = unpack \"C$qlength\", substr($buffer,$offset,$qlength);\n              $accuracies->{$currbase} = \\@read;\n         }\n    }\n     return $accuracies;\n}\n\n\n=head2 _get_comments($buffer)\n\n Title   : _get_comments($buffer)\n Usage   : $self->_get_comments($buffer);\n Function: Gather the comments section from the scf and parse it into its\n            components.\n Returns : a Bio::Annotation::Collection object\n Args    : The buffer. It is expected that the buffer contains a binary\n            string for the comments section of an scf file according to\n            the scf file specifications.\n Notes   :\n\n\nsub _get_comments {\n    my ($self,$buffer) = @_;\n    my $comments = Bio::Annotation::Collection->new();\n    my $size = length($buffer);\n    my $comments_retrieved = unpack \"a$size\",$buffer;\n    $comments_retrieved =~ s/\\0//;\n    my @comments_split = split/\\n/,$comments_retrieved;\n    if (@comments_split) {\n        foreach (@comments_split) {\n            /(\\w+)=(.*)/;\n            if ($1 && $2) {\n                my ($tagname, $text) = ($1, $2);\n                my $comment_obj = Bio::Annotation::Comment->new(\n                                     -text => $text,\n                                     -tagname => $tagname);\n\n                $comments->add_Annotation('comment', $comment_obj);\n            }\n        }\n    }\n    $self->{'comments'} = $comments;\n    return $comments;\n}\n\n=head2 _get_header()\n\n Title   : _get_header($buffer)\n Usage   : $self->_get_header($buffer);\n Function: Gather the header section from the scf and parse it into its\n           components.\n Returns : Reference to a hash containing the header components.\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the header section of an scf file according to the\n           scf file specifications.\n Notes   : None.\n\n\nsub _get_header {\n    my ($self,$buffer) = @_;\n    my $header;\n    ($header->{'scf'},\n     $header->{'samples'},\n     $header->{'sample_offset'},\n     $header->{'bases'},\n     $header->{'bases_left_clip'},\n     $header->{'bases_right_clip'},\n     $header->{'bases_offset'},\n     $header->{'comment_size'},\n     $header->{'comments_offset'},\n     $header->{'version'},\n     $header->{'sample_size'},\n     $header->{'code_set'},\n     @{$header->{'header_spare'}} ) = unpack \"a4 NNNNNNNN a4 NN N20\", $buffer;\n\n    $self->{'header'} = $header;\n    return $header;\n}\n\n=head2 _parse_v2_bases($buffer)\n\n Title   : _parse_v2_bases($buffer)\n Usage   : $self->_parse_v2_bases($buffer);\n Function: Gather the bases section from the scf and parse it into its\n           components.\n Returns :\n Args    : The buffer. It is expected that the buffer contains a binary\n           string for the bases section of an scf file according to the\n           scf file specifications.\n Notes   : None.\n\n\nsub _parse_v2_bases {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my ($offset2,$currbuff,$currbase,$currqual,$sequence,@qualities,@indices);\n    my (@read,$harvester,$accuracies);\n    for ($offset2=0;$offset2<$length;$offset2+=12) {\n         @read = unpack \"N C C C C a C3\", substr($buffer,$offset2,$length);\n         push @indices,$read[0];\n         $currbase = lc($read[5]);\n         if ($currbase eq \"a\") { $currqual = $read[1]; }\n         elsif ($currbase eq \"c\") { $currqual = $read[2]; }\n         elsif ($currbase eq \"g\") { $currqual = $read[3]; }\n         elsif ($currbase eq \"t\") { $currqual = $read[4]; }\n         else { $currqual = \"UNKNOWN\"; }\n         push @{$accuracies->{\"a\"}},$read[1];\n         push @{$accuracies->{\"c\"}},$read[2];\n         push @{$accuracies->{\"g\"}},$read[3];\n         push @{$accuracies->{\"t\"}},$read[4];\n\n         $sequence .= $currbase;\n         push @qualities,$currqual;\n    }\n     return (\\@indices,\\@qualities,$sequence,$accuracies)\n}\n\n=head2 _parse_v2_traces(\\@traces_array)\n\n Title   : _pares_v2_traces(\\@traces_array)\n Usage   : $self->_parse_v2_traces(\\@traces_array);\n Function: Parses an scf Version2 trace array into its base components.\n Returns : Nothing. Modifies $self.\n Args    : A reference to an array of the unpacked traces section of an\n           scf version2 file.\n\n\nsub _parse_v2_traces {\n    my ($self,$buffer,$sample_size) = @_;\n     my $byte;\n     if ($sample_size == 1) { $byte = \"c\"; }\n     else { $byte = \"n\"; }\n     my $length = CORE::length($buffer);\n     my @read = unpack \"${byte}${length}\",$buffer;\n          # this will be an array to the reference holding the array\n     my $traces;\n     my $array = 0;\n     for (my $offset2 = 0; $offset2< scalar(@read); $offset2+=4) {\n              push @{$traces->{'a'}},$read[$offset2];\n              push @{$traces->{'t'}},$read[$offset2+1];\n              push @{$traces->{'g'}},$read[$offset2+3];\n              push @{$traces->{'c'}},$read[$offset2+2];\n    }\n    return $traces;\n}\n\n\nsub get_trace_deprecated_use_the_sequencetrace_object_instead {\n    # my ($self,$base_channel,$traces) = @_;\n    # $base_channel =~ tr/a-z/A-Z/;\n    # if ($base_channel !~ /A|T|G|C/) {\n    #   $self->throw(\"You tried to ask for a base channel that wasn't A,T,G, or C. Ask for one of those next time.\");\n    ##} elsif ($base_channel) {\n     #  my @temp = split(' ',$self->{'traces'}->{$base_channel});\n    #return \\@temp;\n    #}\n}\n\nsub _deprecated_get_peak_indices_deprecated_use_the_sequencetrace_object_instead {\n    my ($self) = shift;\n    my @temp = split(' ',$self->{'parsed'}->{'peak_indices'});\n    return \\@temp;\n}\n\n\n=head2 get_header()\n\n Title   : get_header()\n Usage   : %header = %{$obj->get_header()};\n Function: Return the header for this scf.\n Returns : A reference to a hash containing the header for this scf.\n Args    : None.\n Notes   :\n\n\nsub get_header {\n    my ($self) = shift;\n    return $self->{'header'};\n}\n\n=head2 get_comments()\n\n Title   : get_comments()\n Usage   : %comments = %{$obj->get_comments()};\n Function: Return the comments for this scf.\n Returns : A Bio::Annotation::Collection object\n Args    : None.\n Notes   :\n\n\nsub get_comments {\n    my ($self) = shift;\n    return $self->{'comments'};\n}\n\nsub _dump_traces_outgoing_deprecated_use_the_sequencetrace_object {\n    my ($self,$transformed) = @_;\n    my (@sA,@sT,@sG,@sC);\n    if ($transformed) {\n    @sA = @{$self->{'text'}->{'t_samples_a'}};\n    @sC = @{$self->{'text'}->{'t_samples_c'}};\n    @sG = @{$self->{'text'}->{'t_samples_g'}};\n    @sT = @{$self->{'text'}->{'t_samples_t'}};\n    }\n    else {\n    @sA = @{$self->{'text'}->{'samples_a'}};\n    @sC = @{$self->{'text'}->{'samples_c'}};\n    @sG = @{$self->{'text'}->{'samples_g'}};\n    @sT = @{$self->{'text'}->{'samples_t'}};\n    }\n    print (\"Count\\ta\\tc\\tg\\tt\\n\");\n    for (my $curr=0; $curr < scalar(@sG); $curr++) {\n    print(\"$curr\\t$sA[$curr]\\t$sC[$curr]\\t$sG[$curr]\\t$sT[$curr]\\n\");\n    }\n    return;\n}\n\nsub _dump_traces_incoming_deprecated_use_the_sequencetrace_object {\n    # my ($self) = @_;\n    # my (@sA,@sT,@sG,@sC);\n    # @sA = @{$self->{'traces'}->{'A'}};\n    # @sC = @{$self->{'traces'}->{'C'}};\n    # @sG = @{$self->{'traces'}->{'G'}};\n    # @sT = @{$self->{'traces'}->{'T'}};\n    # @sA = @{$self->get_trace('A')};\n    # @sC = @{$self->get_trace('C')};\n    # @sG = @{$self->get_trace('G')};\n    # @sT = @{$self->get_trace('t')};\n    # print (\"Count\\ta\\tc\\tg\\tt\\n\");\n    # for (my $curr=0; $curr < scalar(@sG); $curr++) {\n    #   print(\"$curr\\t$sA[$curr]\\t$sC[$curr]\\t$sG[$curr]\\t$sT[$curr]\\n\");\n    #}\n    #return;\n}\n\n=head2 write_seq\n\n Title   : write_seq(-target => $swq, <comments>)\n Usage   : $obj->write_seq(\n               -target => $swq,\n            -version => 2,\n            -CONV => \"Bioperl-Chads Mighty SCF writer.\");\n Function: Write out an scf.\n Returns : Nothing.\n Args    : Requires: a reference to a Bio::Seq::Quality object to form the\n           basis for the scf.\n       if -version is provided, it should be \"2\" or \"3\". A SCF of that\n       version will be written.\n       Any other arguments are assumed to be comments and are put into\n       the comments section of the scf. Read the specifications for scf\n       to decide what might be good to put in here.\n\n Notes   :\n          For best results, use a SequenceTrace object.\n          The things that you need to write an scf:\n          a) sequence\n          b) quality\n          c) peak indices\n          d) traces\n          - You _can_ write an scf with just a and b by passing in a\n               Bio::Seq::Quality object- false traces will be synthesized\n               for you.\n\n\nsub write_seq {\n    my ($self,%args) = @_;\n    my %comments;\n    my ($label,$arg);\n    my ($swq) = $self->_rearrange([qw(TARGET)], %args);\n     my $writer_fodder;\n     if (ref($swq) =~ /Bio::Seq::SequenceTrace|Bio::Seq::Quality/) {\n               if (ref($swq) eq \"Bio::Seq::Quality\") {\n                         # this means that the object *has no trace data*\n                         # we might as well synthesize some now, ok?\n                    $swq = Bio::Seq::SequenceTrace->new(\n                         -swq     =>   $swq\n                    );\n               }\n     }\n    else  {\n    $self->throw(\"You must pass a Bio::Seq::Quality or a Bio::Seq::SequenceTrace object to write_seq as a parameter named \\\"target\\\"\");\n    }\n          # all of the rest of the arguments are comments for the scf\n    foreach $arg (sort keys %args) {\n    next if ($arg =~ /target/i);\n    ($label = $arg) =~ s/^\\-//;\n    $writer_fodder->{comments}->{$label} = $args{$arg};\n    }\n    if (!$comments{'NAME'}) { $comments{'NAME'} = $swq->id(); }\n          # HA! Bwahahahaha.\n    $writer_fodder->{comments}->{'CONV'} = \"Bioperl-Chads Mighty SCF writer.\" unless defined $comments{'CONV'};\n          # now deal with the version of scf they want to write\n    if ($writer_fodder->{comments}->{version}) {\n         if ($writer_fodder->{comments}->{version} != 2 && $writer_fodder->{comments}->{version} != 3) {\n              $self->warn(\"This module can only write version 2.0 or 3.0 scf's. Writing a version 2.0 scf by default.\");\n              $writer_fodder->{header}->{version} = \"2.00\";\n         }\n         elsif ($writer_fodder->{comments}->{'version'} > 2) {\n              $writer_fodder->{header}->{'version'} = \"3.00\";\n         }\n          else {\n               $writer_fodder->{header}->{version} = \"2\";\n          }\n    }\n    else {\n         $writer_fodder->{header}->{'version'} = \"3.00\";\n    }\n          # set a few things in the header\n    $writer_fodder->{'header'}->{'magic'} = \".scf\";\n    $writer_fodder->{'header'}->{'sample_size'} = \"2\";\n    $writer_fodder->{'header'}->{'bases'} = length($swq->seq());\n    $writer_fodder->{'header'}->{'bases_left_clip'} = \"0\";\n    $writer_fodder->{'header'}->{'bases_right_clip'} = \"0\";\n    $writer_fodder->{'header'}->{'sample_size'} = \"2\";\n    $writer_fodder->{'header'}->{'code_set'} = \"9\";\n    @{$writer_fodder->{'header'}->{'spare'}} = qw(0 0 0 0 0 0 0 0 0 0\n                     0 0 0 0 0 0 0 0 0 0);\n    $writer_fodder->{'header'}->{'samples_offset'} = \"128\";\n     $writer_fodder->{'header'}->{'samples'} = $swq->trace_length();\n          # create the binary for the comments and file it in writer_fodder\n    $writer_fodder->{comments} =  $self->_get_binary_comments(\n               $writer_fodder->{comments});\n          # create the binary and the strings for the traces, bases,\n          # offsets (if necessary), and accuracies (if necessary)\n    $writer_fodder->{traces} = $self->_get_binary_traces(\n               $writer_fodder->{'header'}->{'version'},\n               $swq,$writer_fodder->{'header'}->{'sample_size'});\n    my ($b_base_offsets,$b_base_accuracies,$samples_size,$bases_size);\n    #\n    # version 2\n    #\n    if ($writer_fodder->{'header'}->{'version'} == 2) {\n          $writer_fodder->{bases} = $self->_get_binary_bases(\n                         2,\n                         $swq,\n                         $writer_fodder->{'header'}->{'sample_size'});\n         $samples_size = CORE::length($writer_fodder->{traces}->{'binary'});\n         $bases_size = CORE::length($writer_fodder->{bases}->{binary});\n         $writer_fodder->{'header'}->{'bases_offset'} = 128 + $samples_size;\n         $writer_fodder->{'header'}->{'comments_offset'} = 128 +\n               $samples_size + $bases_size;\n         $writer_fodder->{'header'}->{'comments_size'} =\n               length($writer_fodder->{'comments'}->{binary});\n         $writer_fodder->{'header'}->{'private_size'} = \"0\";\n         $writer_fodder->{'header'}->{'private_offset'} = 128 +\n               $samples_size + $bases_size +\n               $writer_fodder->{'header'}->{'comments_size'};\n          $writer_fodder->{'header'}->{'binary'} =\n          $self->_get_binary_header($writer_fodder->{header});\n          $dumper->dumpValue($writer_fodder) if $self->verbose > 0;\n         $self->_print ($writer_fodder->{'header'}->{'binary'})\n               or print(\"Could not write binary header...\\n\");\n         $self->_print ($writer_fodder->{'traces'}->{'binary'})\n               or print(\"Could not write binary traces...\\n\");\n         $self->_print ($writer_fodder->{'bases'}->{'binary'})\n               or print(\"Could not write binary base structures...\\n\");\n         $self->_print ($writer_fodder->{'comments'}->{'binary'})\n               or print(\"Could not write binary comments...\\n\");\n    }\n    else {\n          ($writer_fodder->{peak_indices},\n           $writer_fodder->{accuracies},\n           $writer_fodder->{bases},\n           $writer_fodder->{reserved} ) =\n               $self->_get_binary_bases(\n                    3,\n                    $swq,\n                    $writer_fodder->{'header'}->{'sample_size'}\n               );\n         $writer_fodder->{'header'}->{'bases_offset'} = 128 +\n               length($writer_fodder->{'traces'}->{'binary'});\n         $writer_fodder->{'header'}->{'comments_size'} =\n               length($writer_fodder->{'comments'}->{'binary'});\n              # this is:\n              # bases_offset + base_offsets + accuracies + called_bases +\n               # reserved\n         $writer_fodder->{'header'}->{'private_size'} = \"0\";\n\n         $writer_fodder->{'header'}->{'comments_offset'} =\n              128+length($writer_fodder->{'traces'}->{'binary'})+\n                 length($writer_fodder->{'peak_indices'}->{'binary'})+\n                 length($writer_fodder->{'accuracies'}->{'binary'})+\n                length($writer_fodder->{'bases'}->{'binary'})+\n                length($writer_fodder->{'reserved'}->{'binary'});\n    $writer_fodder->{'header'}->{'private_offset'} =\n          $writer_fodder->{'header'}->{'comments_offset'} +\n               $writer_fodder->{'header'}->{'comments_size'};\n    $writer_fodder->{'header'}->{'spare'}->[1] =\n         $writer_fodder->{'header'}->{'comments_offset'} +\n             length($writer_fodder->{'comments'}->{'binary'});\n     $writer_fodder->{header}->{binary} =\n          $self->_get_binary_header($writer_fodder->{header});\n    $self->_print ($writer_fodder->{'header'}->{'binary'})\n          or print(\"Couldn't write header\\n\");\n    $self->_print ($writer_fodder->{'traces'}->{'binary'})\n          or print(\"Couldn't write samples\\n\");\n    $self->_print ($writer_fodder->{'peak_indices'}->{'binary'})\n          or print(\"Couldn't write peak offsets\\n\");\n    $self->_print ($writer_fodder->{'accuracies'}->{'binary'})\n          or print(\"Couldn't write accuracies\\n\");\n    $self->_print ($writer_fodder->{'bases'}->{'binary'})\n          or print(\"Couldn't write called_bases\\n\");\n    $self->_print ($writer_fodder->{'reserved'}->{'binary'})\n          or print(\"Couldn't write reserved\\n\");\n    $self->_print ($writer_fodder->{'comments'}->{'binary'})\n          or print (\"Couldn't write comments\\n\");\n    }\n\n    # kinda unnecessary, given the close() below, but maybe that'll go\n    # away someday.\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n\n    $self->close();\n    return 1;\n}\n\n\n\n\n\n=head2 _get_binary_header()\n\n Title   : _get_binary_header();\n Usage   : $self->_get_binary_header();\n Function: Provide the binary string that will be used as the header for\n            a scfv2 document.\n Returns : A binary string.\n Args    : None. Uses the entries in the $self->{'header'} hash. These\n            are set on construction of the object (hopefully correctly!).\n Notes   :\n\n\nsub _get_binary_header {\n    my ($self,$header) = @_;\n    my $binary = pack \"a4 NNNNNNNN a4 NN N20\",\n    (\n     $header->{'magic'},\n     $header->{'samples'},\n     $header->{'samples_offset'},\n     $header->{'bases'},\n     $header->{'bases_left_clip'},\n     $header->{'bases_right_clip'},\n     $header->{'bases_offset'},\n     $header->{'comments_size'},\n     $header->{'comments_offset'},\n     $header->{'version'},\n     $header->{'sample_size'},\n     $header->{'code_set'},\n     @{$header->{'spare'}}\n     );\n    return $binary;\n}\n\n=head2 _get_binary_traces($version,$ref)\n\n Title   : _set_binary_tracesbases($version,$ref)\n Usage   : $self->_set_binary_tracesbases($version,$ref);\n Function: Constructs the trace and base strings for all scfs\n Returns : Nothing. Alters self.\n Args    : $version - \"2\" or \"3\"\n       $sequence - a scalar containing arbitrary sequence data\n       $ref - a reference to either a SequenceTraces or a\n          SequenceWithQuality object.\n Notes   : This is a really complicated thing.\n\n\nsub _get_binary_traces {\n    my ($self,$version,$ref,$sample_size) = @_;\n          # ref _should_ be a Bio::Seq::SequenceTrace, but might be a\n          # Bio::Seq::Quality\n     my $returner;\n     my $sequence = $ref->seq();\n     my $sequence_length = length($sequence);\n          # first of all, do we need to synthesize the trace?\n          # if so, call synthesize_base\n     my ($traceobj,@traces,$current);\n     if ( ref($ref) eq \"Bio::Seq::Quality\" ) {\n          $traceobj = Bio::Seq::Quality->new(\n               -target   =>   $ref\n          );\n          $traceobj->_synthesize_traces();\n     }\n     else {\n          $traceobj = $ref;\n          if ($version eq \"2\") {\n               my $trace_length = $traceobj->trace_length();\n               for ($current = 1; $current <= $trace_length; $current++) {\n                    foreach (qw(a c g t)) {\n                         push @traces,$traceobj->trace_value_at($_,$current);\n                    }\n               }\n          }\n          elsif ($version == 3) {\n               foreach my $current_trace (qw(a c g t)) {\n                    my @trace = @{$traceobj->trace($current_trace)};\n                    foreach (@trace) {\n                         if ($_ > 30000) {\n                              $_ -= 65536;\n                         }\n                    }\n                    my $transformed = $self->_delta(\\@trace,\"forward\");\n                    if($sample_size == 1){\n                         foreach (@{$transformed}) {\n                              $_ += 256 if ($_ < 0);\n                         }\n                    }\n                    push @traces,@{$transformed};\n               }\n          }\n     }\n     $returner->{version} = $version;\n     $returner->{string} = \\@traces;\n     my $length_of_traces = scalar(@traces);\n     my $byte;\n     if ($sample_size == 1) { $byte = \"c\"; } else { $byte = \"n\"; }\n          # an unsigned integer should be I, but this is too long\n          #\n     $returner->{binary} = pack \"n${length_of_traces}\",@traces;\n     $returner->{length} = CORE::length($returner->{binary});\n     return $returner;\n}\n\n\nsub _get_binary_bases {\n     my ($self,$version,$trace,$sample_size) = @_;\n     my $byte;\n     if ($sample_size == 1) { $byte = \"c\"; } else { $byte = \"n\"; }\n     my ($returner,@current_row,$current_base,$string,$binary);\n     my $length = $trace->length();\n     if ($version == 2) {\n          $returner->{'version'} = \"2\";\n         for (my $current_base =1; $current_base <= $length; $current_base++) {\n               my @current_row;\n               push @current_row,$trace->peak_index_at($current_base);\n               push @current_row,$trace->accuracy_at(\"a\",$current_base);\n               push @current_row,$trace->accuracy_at(\"c\",$current_base);\n               push @current_row,$trace->accuracy_at(\"g\",$current_base);\n               push @current_row,$trace->accuracy_at(\"t\",$current_base);\n               push @current_row,$trace->baseat($current_base);\n               push @current_row,0,0,0;\n               push @{$returner->{string}},@current_row;\n               $returner->{binary} .= pack \"N C C C C a C3\",@current_row;\n          }\n          return $returner;\n     }\n     else {\n          $returner->{'version'} = \"3.00\";\n          $returner->{peak_indices}->{string} = $trace->peak_indices();\n          my $length = scalar(@{$returner->{peak_indices}->{string}});\n          $returner->{peak_indices}->{binary} =\n               pack \"N$length\",@{$returner->{peak_indices}->{string}};\n          $returner->{peak_indices}->{length} =\n               CORE::length($returner->{peak_indices}->{binary});\n          my @accuracies;\n          foreach my $base (qw(a c g t)) {\n               $returner->{accuracies}->{$base} = $trace->accuracies($base);\n               push @accuracies,@{$trace->accuracies($base)};\n          }\n          $returner->{sequence} = $trace->seq();\n          $length = scalar(@accuracies);\n               # this really is \"c\" for samplesize == 2\n          $returner->{accuracies}->{binary} = pack \"C${length}\",@accuracies;\n          $returner->{accuracies}->{length} =\n               CORE::length($returner->{accuracies}->{binary});\n          $length = $trace->seq_obj()->length();\n          for (my $count=0; $count< $length; $count++) {\n               push @{$returner->{reserved}->{string}},0,0,0;\n          }\n     }\n     $length = scalar(@{$returner->{reserved}->{string}});\n               # this _must_ be \"c\"\n     $returner->{'reserved'}->{'binary'} =\n          pack \"c$length\",@{$returner->{reserved}->{string}};\n     $returner->{'reserved'}->{'length'} =\n          CORE::length($returner->{'reserved'}->{'binary'});\n          # $returner->{'bases'}->{'string'} = $trace->seq();\n     my @bases = split('',$trace->seq());\n     $length = $trace->length();\n     $returner->{'bases'}->{'binary'} = $trace->seq();\n          # print(\"Returning this:\\n\");\n          # $dumper->dumpValue($returner);\n     return ($returner->{peak_indices},\n             $returner->{accuracies},\n             $returner->{bases},\n             $returner->{reserved});\n\n}\n\n\n=head2 _make_trace_string($version)\n\n Title   : _make_trace_string($version)\n Usage   : $self->_make_trace_string($version)\n Function: Merges trace data for the four bases to produce an scf\n       trace string. _requires_ $version\n Returns : Nothing. Alters $self.\n Args    : $version - a version number. \"2\" or \"3\"\n Notes   :\n\n\nsub _make_trace_string {\n    my ($self,$version) = @_;\n    my @traces;\n    my @traces_view;\n    my @as = @{$self->{'text'}->{'samples_a'}};\n    my @cs = @{$self->{'text'}->{'samples_c'}};\n    my @gs = @{$self->{'text'}->{'samples_g'}};\n    my @ts = @{$self->{'text'}->{'samples_t'}};\n    if ($version == 2) {\n        for (my $curr=0; $curr < scalar(@as); $curr++) {\n        $as[$curr] = $DEFAULT_QUALITY unless defined $as[$curr];\n        $cs[$curr] = $DEFAULT_QUALITY unless defined $cs[$curr];\n        $gs[$curr] = $DEFAULT_QUALITY unless defined $gs[$curr];\n        $ts[$curr] = $DEFAULT_QUALITY unless defined $ts[$curr];\n        push @traces,($as[$curr],$cs[$curr],$gs[$curr],$ts[$curr]);\n        }\n    }\n    elsif ($version == 3) {\n        @traces = (@as,@cs,@gs,@ts);\n    }\n    else {\n        $self->throw(\"No idea what version required to make traces here. You gave #$version#  Bailing.\");\n    }\n    my $length = scalar(@traces);\n    $self->{'text'}->{'samples_all'} = \\@traces;\n\n}\n\n=head2 _get_binary_comments(\\@comments)\n\n Title   : _get_binary_comments(\\@comments)\n Usage   : $self->_get_binary_comments(\\@comments);\n Function: Provide a binary string that will be the comments section of\n       the scf file. See the scf specifications for detailed\n       specifications for the comments section of an scf file. Hint:\n       CODE=something\\nBODE=something\\n\\0\n Returns :\n Args    : A reference to an array containing comments.\n Notes   : None.\n\n\nsub _get_binary_comments {\n    my ($self,$rcomments) = @_;\n     my $returner;\n    my $comments_string = '';\n    my %comments = %$rcomments;\n    foreach my $key (sort keys %comments) {\n    $comments{$key} ||= '';\n    $comments_string .= \"$key=$comments{$key}\\n\";\n    }\n    $comments_string .= \"\\n\\0\";\n     my $length = CORE::length($comments_string);\n     $returner->{length} = $length;\n     $returner->{string} = $comments_string;\n     $returner->{binary} = pack \"A$length\",$comments_string;\n     return $returner;\n}\n\n#=head2 _fill_missing_data($swq)\n#\n# Title   : _fill_missing_data($swq)\n# Usage   : $self->_fill_missing_data($swq);\n# Function: If the $swq with quality has no qualities, set all qualities\n#      to 0.\n#      If the $swq has no sequence, set the sequence to N's.\n# Returns : Nothing. Modifies the Bio::Seq::Quality that was passed as an\n#      argument.\n# Args    : A reference to a Bio::Seq::Quality\n# Notes   : None.\n#\n#=cut\n#\n##'\n#sub _fill_missing_data {\n#    my ($self,$swq) = @_;\n#    my $qual_obj = $swq->qual_obj();\n#    my $seq_obj = $swq->seq_obj();\n#    if ($qual_obj->length() == 0 && $seq_obj->length() != 0) {\n#   my $fake_qualities = (\"$DEFAULT_QUALITY \")x$seq_obj->length();\n#   $swq->qual($fake_qualities);\n#    }\n#    if ($seq_obj->length() == 0 && $qual_obj->length != 0) {\n#   my $sequence = (\"N\")x$qual_obj->length();\n#   $swq->seq($sequence);\n#    }\n#}\n\n=head2 _delta(\\@trace_data,$direction)\n\n Title   : _delta(\\@trace_data,$direction)\n Usage   : $self->_delta(\\@trace_data,$direction);\n Function:\n Returns : A reference to an array containing modified trace values.\n Args    : A reference to an array containing trace data and a string\n       indicating the direction of conversion. (\"forward\" or\n       \"backward\").\n Notes   : This code is taken from the specification for SCF3.2.\n       http://www.mrc-lmb.cam.ac.uk/pubseq/manual/formats_unix_4.html\n\n\n\nsub _delta {\n    my ($self,$rsamples,$direction) = @_;\n    my @samples = @$rsamples;\n        # /* If job == DELTA_IT:\n        # *  change a series of sample points to a series of delta delta values:\n        # *  ie change them in two steps:\n        # *  first: delta = current_value - previous_value\n        # *  then: delta_delta = delta - previous_delta\n        # * else\n        # *  do the reverse\n        # */\n        # int i;\n        # uint_2 p_delta, p_sample;\n\n    my ($i,$num_samples,$p_delta,$p_sample,@samples_converted,$p_sample1,$p_sample2);\n        my $SLOW_BUT_CLEAR = 0;\n        $num_samples = scalar(@samples);\n    # c-programmers are funny people with their single-letter variables\n\n    if ( $direction eq \"forward\" ) {\n            if($SLOW_BUT_CLEAR){\n        $p_delta  = 0;\n        for ($i=0; $i < $num_samples; $i++) {\n            $p_sample = $samples[$i];\n            $samples[$i] = $samples[$i] - $p_delta;\n            $p_delta  = $p_sample;\n        }\n        $p_delta  = 0;\n        for ($i=0; $i < $num_samples; $i++) {\n            $p_sample = $samples[$i];\n            $samples[$i] = $samples[$i] - $p_delta;\n            $p_delta  = $p_sample;\n        }\n            } else {\n                for ($i = $num_samples-1; $i > 1; $i--){\n                    $samples[$i] = $samples[$i] - 2*$samples[$i-1] + $samples[$i-2];\n                }\n                $samples[1] = $samples[1] - 2*$samples[0];\n            }\n    }\n    elsif ($direction eq \"backward\") {\n            if($SLOW_BUT_CLEAR){\n        $p_sample = 0;\n        for ($i=0; $i < $num_samples; $i++) {\n            $samples[$i] = $samples[$i] + $p_sample;\n            $p_sample = $samples[$i];\n        }\n        $p_sample = 0;\n        for ($i=0; $i < $num_samples; $i++) {\n            $samples[$i] = $samples[$i] + $p_sample;\n            $p_sample = $samples[$i];\n        }\n            } else {\n                $p_sample1 = $p_sample2 = 0;\n                for ($i = 0; $i < $num_samples; $i++){\n                    $p_sample1 = $p_sample1 + $samples[$i];\n                    $samples[$i] = $p_sample1 + $p_sample2;\n                    $p_sample2 = $samples[$i];\n                }\n\n            }\n    }\n    else {\n        $self->warn(\"Bad direction. Use \\\"forward\\\" or \\\"backward\\\".\");\n    }\n    return \\@samples;\n}\n\n=head2 _unpack_magik($buffer)\n\n Title   : _unpack_magik($buffer)\n Usage   : $self->_unpack_magik($buffer)\n Function: What unpack specification should be used? Try them all.\n Returns : Nothing.\n Args    : A buffer containing arbitrary binary data.\n Notes   : Eliminate the ambiguity and the guesswork. Used in the\n       adaptation of _delta(), mostly.\n\n\nsub _unpack_magik {\n    my ($self,$buffer) = @_;\n    my $length = length($buffer);\n    my (@read,$counter);\n    foreach (qw(c C s S i I l L n N v V)) {\n        @read = unpack \"$_$length\", $buffer;\n        for ($counter=0; $counter < 20; $counter++) {\n            print(\"$read[$counter]\\n\");\n        }\n    }\n}\n\n=head2 read_from_buffer($filehandle,$buffer,$length)\n\n Title   : read_from_buffer($filehandle,$buffer,$length)\n Usage   : $self->read_from_buffer($filehandle,$buffer,$length);\n Function: Read from the buffer.\n Returns : $buffer, containing a read of $length\n Args    : a filehandle, a buffer, and a read length\n Notes   : I just got tired of typing\n       \"unless (length($buffer) == $length)\" so I put it here.\n\n\nsub read_from_buffer {\n    my ($self,$fh,$buffer,$length,$start_position) = @_;\n          # print(\"Reading from a buffer!!! length($length) \");\n     if ($start_position) {\n               # print(\" startposition($start_position)(\".sprintf(\"%X\", $start_position).\")\\n\");\n     }\n          # print(\"\\n\");\n     if ($start_position) {\n               # print(\"seeking to this position in the file: (\".$start_position.\")\\n\");\n          seek ($fh,$start_position,0);\n               # print(\"done. here is where I am now: (\".tell($fh).\")\\n\");\n     }\n     else {\n          # print(\"You did not specify a start position. Going from this position (the current position) (\".tell($fh).\")\\n\");\n     }\n    read $fh, $buffer, $length;\n    unless (length($buffer) == $length) {\n        $self->warn(\"The read was incomplete! Trying harder.\");\n        my $missing_length = $length - length($buffer);\n        my $buffer2;\n        read $fh,$buffer2,$missing_length;\n        $buffer .= $buffer2;\n        if (length($buffer) != $length) {\n            $self->throw(\"Unexpected end of file while reading from SCF file. I should have read $length but instead got \".length($buffer).\"! Current file position is \".tell($fh).\".\");\n        }\n    }\n\n    return $buffer;\n}\n\n=head2 _dump_keys()\n\n Title   : _dump_keys()\n Usage   : &_dump_keys($a_reference_to_some_hash)\n Function: Dump out the keys in a hash.\n Returns : Nothing.\n Args    : A reference to a hash.\n Notes   : A debugging method.\n\n\nsub _dump_keys {\n    my $rhash = shift;\n    if ($rhash !~ /HASH/) {\n        print(\"_dump_keys: that was not a hash.\\nIt was #$rhash# which was this reference:\".ref($rhash).\"\\n\");\n        return;\n    }\n    print(\"_dump_keys: The keys for $rhash are:\\n\");\n    foreach (sort keys %$rhash) {\n        print(\"$_\\n\");\n    }\n}\n\n=head2 _dump_base_accuracies()\n\n Title   : _dump_base_accuracies()\n Usage   : $self->_dump_base_accuracies();\n Function: Dump out the v3 base accuracies in an easy to read format.\n Returns : Nothing.\n Args    : None.\n Notes   : A debugging method.\n\n\nsub _dump_base_accuracies {\n    my $self = shift;\n    print(\"Dumping base accuracies! for v3\\n\");\n    print(\"There are this many elements in a,c,g,t:\\n\");\n    print(scalar(@{$self->{'text'}->{'v3_base_accuracy_a'}}).\",\".scalar(@{$self->{'text'}->{'v3_base_accuracy_c'}}).\",\".scalar(@{$self->{'text'}->{'v3_base_accuracy_g'}}).\",\".scalar(@{$self->{'text'}->{'v3_base_accuracy_t'}}).\"\\n\");\n    my $number_traces = scalar(@{$self->{'text'}->{'v3_base_accuracy_a'}});\n    for (my $counter=0; $counter < $number_traces; $counter++ ) {\n        print(\"$counter\\t\");\n        print $self->{'text'}->{'v3_base_accuracy_a'}->[$counter].\"\\t\";\n        print $self->{'text'}->{'v3_base_accuracy_c'}->[$counter].\"\\t\";\n        print $self->{'text'}->{'v3_base_accuracy_g'}->[$counter].\"\\t\";\n        print $self->{'text'}->{'v3_base_accuracy_t'}->[$counter].\"\\t\";\n        print(\"\\n\");\n    }\n}\n\n=head2 _dump_peak_indices_incoming()\n\n Title   : _dump_peak_indices_incoming()\n Usage   : $self->_dump_peak_indices_incoming();\n Function: Dump out the v3 peak indices in an easy to read format.\n Returns : Nothing.\n Args    : None.\n Notes   : A debugging method.\n\n\nsub _dump_peak_indices_incoming {\n    my $self = shift;\n    print(\"Dump peak indices incoming!\\n\");\n    my $length = $self->{'bases'};\n    print(\"The length is $length\\n\");\n    for (my $count=0; $count < $length; $count++) {\n        print(\"$count\\t$self->{parsed}->{peak_indices}->[$count]\\n\");\n    }\n}\n\n=head2 _dump_base_accuracies_incoming()\n\n Title   : _dump_base_accuracies_incoming()\n Usage   : $self->_dump_base_accuracies_incoming();\n Function: Dump out the v3 base accuracies in an easy to read format.\n Returns : Nothing.\n Args    : None.\n Notes   : A debugging method.\n\n\nsub _dump_base_accuracies_incoming {\n    my $self = shift;\n    print(\"Dumping base accuracies! for v3\\n\");\n        # print(\"There are this many elements in a,c,g,t:\\n\");\n        # print(scalar(@{$self->{'parsed'}->{'v3_base_accuracy_a'}}).\",\".scalar(@{$self->{'text'}->{'v3_base_accuracy_c'}}).\",\".scalar(@{$self->{'text'}->{'v3_base_accuracy_g'}}).\",\".scalar(@{$self->{'text'}->{'v3_base_accuracy_t'}}).\"\\n\");\n    my $number_traces = $self->{'bases'};\n    for (my $counter=0; $counter < $number_traces; $counter++ ) {\n        print(\"$counter\\t\");\n        foreach (qw(A T G C)) {\n            print $self->{'parsed'}->{'base_accuracies'}->{$_}->[$counter].\"\\t\";\n        }\n        print(\"\\n\");\n    }\n}\n\n\n=head2 _dump_comments()\n\n Title   : _dump_comments()\n Usage   : $self->_dump_comments();\n Function: Debug dump the comments section from the scf.\n Returns : Nothing.\n Args    : Nothing.\n Notes   : None.","parameters":[{"label":"$self"}],"label":"_dump_comments($self)"},"line":1294,"kind":12,"range":{"end":{"character":9999,"line":1297},"start":{"character":0,"line":1294}},"definition":"sub","detail":"($self)","children":[{"line":1295,"name":"$self","localvar":"my","kind":13,"containerName":"_dump_comments","definition":"my"},{"line":1297,"kind":13,"localvar":"my","containerName":"_dump_comments","name":"$k","definition":"my"},{"line":1297,"name":"$self","containerName":"_dump_comments","kind":13}],"containerName":"main::","name":"_dump_comments"},{"line":1298,"kind":13,"containerName":null,"name":"%self"},{"containerName":null,"kind":13,"name":"$k","line":1298}],"version":5}