{"vars":[{"line":113,"containerName":"","kind":2,"name":"base"},{"range":{"start":{"line":133,"character":0},"end":{"line":145,"character":9999}},"kind":12,"line":133,"signature":{"label":"_initialize($self,@args)","documentation":"1;\n# $Id: excel.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::excel\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2005.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2005.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::excel - sequence input/output stream from a\n                    MSExcel-formatted table\n\n=head1 SYNOPSIS\n\n  #It is probably best not to use this object directly, but\n  #rather go through the SeqIO handler system. Go:\n\n  $stream = Bio::SeqIO->new(-file => $filename, -format => 'excel');\n\n  while ( my $seq = $stream->next_seq() ) {\n\t# do something with $seq\n  }\n\n=head1 DESCRIPTION\n\nThis class transforms records in a MS Excel workbook file into\nBio::Seq objects. It is derived from the table format module and\nmerely defines additional properties and overrides the way to get data\nfrom the file and advance to the next record.\n\nThe module permits specifying which columns hold which type of\nannotation. The semantics of certain attributes, if present, are\npre-defined, e.g., accession number and sequence. Additional\nattributes may be added to the annotation bundle. See\nL<Bio::SeqIO::table> for a complete list of parameters and\ncapabilities.\n\nYou may also specify the worksheet from which to obtain the data, and\nafter finishing one worksheet you may change the name to keep reading\nfrom another worksheet (in the same file).\n\nThis module depends on Spreadsheet::ParseExcel to parse the underlying\nExcel file.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\n\nBug reports can be submitted via email or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::excel;\nuse strict;\n\nuse Bio::SeqIO;\nuse Spreadsheet::ParseExcel;\n#use Spreadsheet::ParseExcel::Workbook;\n\nuse base qw(Bio::SeqIO::table);\n\n=head2 new\n\n Title   : new\n Usage   : $stream = Bio::SeqIO->new(-file => $filename, -format => 'excel')\n Function: Returns a new seqstream\n Returns : A Bio::SeqIO stream for a MS Excel format\n\n Args    : Supports the same named parameters as Bio::SeqIO::table,\n           except -delim, which obviously does not apply to a binary\n           format. In addition, the following parameters are supported.\n\n             -worksheet the name of the worksheet holding the table;\n                        if unspecified the first worksheet will be\n                        used","parameters":[{"label":"$self"},{"label":"@args"}]},"name":"_initialize","containerName":"main::","children":[{"definition":"my","line":134,"name":"$self","localvar":"my","containerName":"_initialize","kind":13},{"line":134,"name":"@args","kind":13,"containerName":"_initialize"},{"line":137,"name":"$self","kind":13,"containerName":"_initialize"},{"line":137,"name":"@args","kind":13,"containerName":"_initialize"},{"kind":13,"localvar":"my","containerName":"_initialize","name":"$worksheet","line":140,"definition":"my"},{"line":140,"kind":13,"containerName":"_initialize","name":"$self"},{"line":140,"name":"_rearrange","kind":12,"containerName":"_initialize"},{"kind":13,"containerName":"_initialize","name":"@args","line":140},{"kind":13,"containerName":"_initialize","name":"$self","line":143},{"name":"worksheet","kind":12,"containerName":"_initialize","line":143},{"line":143,"kind":13,"containerName":"_initialize","name":"$worksheet"}],"detail":"($self,@args)","definition":"sub"},{"kind":12,"containerName":"_initialize","name":"SUPER","line":137},{"children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"worksheet","line":166},{"definition":"my","line":169,"name":"$sheetname","kind":13,"localvar":"my","containerName":"worksheet"},{"kind":13,"containerName":"worksheet","name":"$self","line":172},{"kind":12,"containerName":"worksheet","name":"_worksheet","line":172},{"line":172,"containerName":"worksheet","kind":13,"name":"$sheetname"},{"kind":13,"containerName":"worksheet","name":"$self","line":173},{"name":"$sheetname","kind":13,"containerName":"worksheet","line":173},{"line":175,"containerName":"worksheet","kind":13,"name":"$self"}],"name":"worksheet","containerName":"main::","definition":"sub","line":165,"range":{"end":{"line":176,"character":9999},"start":{"character":0,"line":165}},"kind":12},{"children":[{"name":"$self","localvar":"my","kind":13,"containerName":"close","line":195,"definition":"my"},{"line":197,"containerName":"close","kind":13,"name":"$self"},{"line":197,"name":"_worksheet","kind":12,"containerName":"close"},{"name":"$self","kind":13,"containerName":"close","line":199}],"containerName":"main::","name":"close","definition":"sub","line":194,"range":{"start":{"character":0,"line":194},"end":{"character":9999,"line":200}},"kind":12},{"name":"SUPER","kind":12,"containerName":"close","line":199},{"line":223,"kind":12,"range":{"end":{"character":9999,"line":228},"start":{"line":223,"character":0}},"children":[{"line":224,"name":"$self","localvar":"my","kind":13,"containerName":"_worksheet","definition":"my"},{"line":226,"name":"$self","containerName":"_worksheet","kind":13},{"name":"$self","containerName":"_worksheet","kind":13,"line":227}],"name":"_worksheet","containerName":"main::","definition":"sub"},{"children":[{"definition":"my","localvar":"my","kind":13,"containerName":"_next_record","name":"$self","line":249},{"definition":"my","line":251,"name":"$wsheet","kind":13,"localvar":"my","containerName":"_next_record"},{"line":251,"name":"$self","containerName":"_next_record","kind":13},{"name":"_worksheet","kind":12,"containerName":"_next_record","line":251},{"containerName":"_next_record","kind":13,"name":"$wsheet","line":252},{"name":"$wbook","localvar":"my","containerName":"_next_record","kind":13,"line":254,"definition":"my"},{"line":254,"kind":12,"containerName":"_next_record","name":"Parse"},{"line":254,"kind":13,"containerName":"_next_record","name":"$self"},{"containerName":"_next_record","kind":12,"name":"_fh","line":254},{"name":"$wsheet","containerName":"_next_record","kind":13,"line":255},{"containerName":"_next_record","kind":13,"name":"$wbook","line":255},{"line":255,"name":"Worksheet","kind":12,"containerName":"_next_record"},{"line":255,"containerName":"_next_record","kind":13,"name":"$self"},{"line":255,"containerName":"_next_record","kind":12,"name":"worksheet"},{"kind":13,"containerName":"_next_record","name":"$self","line":257},{"name":"_worksheet","containerName":"_next_record","kind":12,"line":257},{"containerName":"_next_record","kind":13,"name":"$wsheet","line":257},{"line":259,"kind":13,"containerName":"_next_record","name":"$self"},{"line":263,"name":"$wsheet","kind":13,"containerName":"_next_record"},{"definition":"my","line":266,"localvar":"my","kind":13,"containerName":"_next_record","name":"$minrow"},{"line":266,"containerName":"_next_record","kind":13,"name":"$maxrow"},{"line":266,"name":"$wsheet","kind":13,"containerName":"_next_record"},{"line":266,"name":"RowRange","containerName":"_next_record","kind":12},{"containerName":"_next_record","kind":13,"name":"$self","line":267},{"line":267,"name":"$maxrow","kind":13,"containerName":"_next_record"},{"kind":13,"containerName":"_next_record","name":"$self","line":272}],"name":"_next_record","containerName":"main::","definition":"sub","line":248,"kind":12,"range":{"start":{"line":248,"character":0},"end":{"character":9999,"line":276}}},{"line":254,"containerName":"ParseExcel::Workbook","kind":12,"name":"Spreadsheet"},{"containerName":"main::","name":"_get_row_values","children":[{"definition":"my","line":296,"name":"$self","kind":13,"localvar":"my","containerName":"_get_row_values"},{"definition":"my","localvar":"my","containerName":"_get_row_values","kind":13,"name":"$wsheet","line":299},{"name":"$self","containerName":"_get_row_values","kind":13,"line":299},{"name":"_worksheet","kind":12,"containerName":"_get_row_values","line":299},{"name":"$colmin","kind":13,"localvar":"my","containerName":"_get_row_values","line":300,"definition":"my"},{"containerName":"_get_row_values","kind":13,"name":"$colmax","line":300},{"name":"$wsheet","containerName":"_get_row_values","kind":13,"line":300},{"containerName":"_get_row_values","kind":12,"name":"ColRange","line":300},{"line":303,"localvar":"my","kind":13,"containerName":"_get_row_values","name":"@cols","definition":"my"},{"definition":"my","line":304,"containerName":"_get_row_values","localvar":"my","kind":13,"name":"$row"},{"line":304,"kind":13,"containerName":"_get_row_values","name":"$self"},{"name":"$i","kind":13,"localvar":"my","containerName":"_get_row_values","line":305,"definition":"my"},{"line":305,"containerName":"_get_row_values","kind":13,"name":"$colmin"},{"containerName":"_get_row_values","kind":13,"name":"$i","line":305},{"line":305,"name":"$colmax","kind":13,"containerName":"_get_row_values"},{"line":305,"kind":13,"containerName":"_get_row_values","name":"$i"},{"containerName":"_get_row_values","localvar":"my","kind":13,"name":"$cell","line":306,"definition":"my"},{"line":306,"kind":13,"containerName":"_get_row_values","name":"$wsheet"},{"line":306,"name":"Cell","containerName":"_get_row_values","kind":12},{"line":306,"name":"$row","kind":13,"containerName":"_get_row_values"},{"containerName":"_get_row_values","kind":13,"name":"$i","line":306},{"kind":13,"containerName":"_get_row_values","name":"@cols","line":307},{"containerName":"_get_row_values","kind":13,"name":"$cell","line":307},{"name":"$cell","kind":13,"containerName":"_get_row_values","line":307},{"line":307,"containerName":"_get_row_values","kind":12,"name":"Value"},{"line":307,"containerName":"_get_row_values","kind":13,"name":"$cell"},{"line":310,"name":"@cols","kind":13,"containerName":"_get_row_values"}],"definition":"sub","range":{"start":{"character":0,"line":295},"end":{"line":311,"character":9999}},"kind":12,"line":295}],"version":5}