{"version":5,"vars":[{"name":"base","containerName":"","kind":2,"line":78},{"kind":12,"range":{"start":{"character":0,"line":92},"end":{"character":9999,"line":102}},"line":92,"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: IDHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::SeqFeature::Tools::IDHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Mungall <cjm@fruitfly.org>\n#\n# Copyright Chris Mungall\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Tools::IDHandler - maps $seq_feature-E<gt>primary_tag\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n  use Bio::SeqFeature::Tools::IDHandler;\n\n\n=head1 DESCRIPTION\n\nClass to map $seq_feature-E<gt>primary_tag\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Mungall\n\nEmail:  cjm@fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Tools::IDHandler;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $unflattener = Bio::SeqFeature::Tools::IDHandler->new();\n Function: constructor\n Example : \n Returns : a new Bio::SeqFeature::Tools::IDHandler\n Args    : see below"},"name":"new","containerName":"main::","children":[{"definition":"my","line":93,"name":"$class","localvar":"my","kind":13,"containerName":"new"},{"name":"@args","containerName":"new","kind":13,"line":93},{"line":94,"containerName":"new","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":94,"name":"$class","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"@args","line":94},{"line":96,"localvar":"my","kind":13,"containerName":"new","name":"$generate_id_sub","definition":"my"},{"line":97,"kind":13,"containerName":"new","name":"$self"},{"line":97,"name":"_rearrange","kind":12,"containerName":"new"},{"line":99,"name":"@args","containerName":"new","kind":13},{"name":"$self","kind":13,"containerName":"new","line":101}],"detail":"($class,@args)","definition":"sub"},{"kind":12,"containerName":"new","name":"SUPER","line":94},{"signature":{"parameters":[],"documentation":"1;\n# $Id: IDHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::SeqFeature::Tools::IDHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Mungall <cjm@fruitfly.org>\n#\n# Copyright Chris Mungall\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Tools::IDHandler - maps $seq_feature-E<gt>primary_tag\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n  use Bio::SeqFeature::Tools::IDHandler;\n\n\n=head1 DESCRIPTION\n\nClass to map $seq_feature-E<gt>primary_tag\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Mungall\n\nEmail:  cjm@fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Tools::IDHandler;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $unflattener = Bio::SeqFeature::Tools::IDHandler->new();\n Function: constructor\n Example : \n Returns : a new Bio::SeqFeature::Tools::IDHandler\n Args    : see below\n\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($generate_id_sub) =\n\t$self->_rearrange([qw(GENERATE_ID_SUB\n\t\t\t     )],\n                          @args);\n\n    return $self; # success - we hope!\n}\n\n=head2 set_ParentIDs_from_hierarchy()\n\n Title   : set_ParentIDs_from_hierarchy()\n Usage   : $idhandler->set_ParentIDs_from_hierarchy($fholder)\n Function: populates tags Parent and ID via holder hierarchy\n Example :\n Returns : \n Args    : Bio::featureHolderI (either a SeqFeature or a Seq)\n\nThis is mainly for GFF3 export\n\nGFF3 uses the tags ID and Parent to represent the feature containment\nhierarchy; it does NOT use the feature holder tree\n\nThis method sets Parent (and ID for any parents not set) based on\nfeature holder/containement hierarchy, ready for GFF3 output\n\n method author: cjm@fruitfly.org","label":"set_ParentIDs_from_hierarchy()"},"kind":12,"range":{"start":{"character":0,"line":124},"end":{"line":165,"character":9999}},"line":124,"detail":"()","definition":"sub","containerName":"main::","name":"set_ParentIDs_from_hierarchy","children":[{"definition":"my","line":125,"localvar":"my","containerName":"set_ParentIDs_from_hierarchy","kind":13,"name":"$self"},{"localvar":"my","kind":13,"containerName":"set_ParentIDs_from_hierarchy","name":"$featholder","line":126,"definition":"my"},{"line":132,"kind":13,"localvar":"my","containerName":"set_ParentIDs_from_hierarchy","name":"@sfs","definition":"my"},{"line":132,"kind":13,"containerName":"set_ParentIDs_from_hierarchy","name":"$featholder"},{"line":132,"containerName":"set_ParentIDs_from_hierarchy","kind":12,"name":"get_SeqFeatures"},{"localvar":"my","containerName":"set_ParentIDs_from_hierarchy","kind":13,"name":"@all_sfs","line":136,"definition":"my"},{"line":136,"containerName":"set_ParentIDs_from_hierarchy","kind":13,"name":"$featholder"},{"line":136,"name":"get_all_SeqFeatures","kind":12,"containerName":"set_ParentIDs_from_hierarchy"},{"line":137,"kind":13,"containerName":"set_ParentIDs_from_hierarchy","name":"@all_sfs"},{"line":138,"containerName":"set_ParentIDs_from_hierarchy","kind":12,"name":"has_tag"},{"line":139,"kind":12,"containerName":"set_ParentIDs_from_hierarchy","name":"remove_tag"},{"line":145,"name":"@sfs","containerName":"set_ParentIDs_from_hierarchy","kind":13},{"definition":"my","localvar":"my","kind":13,"containerName":"set_ParentIDs_from_hierarchy","name":"$sf","line":146},{"line":146,"name":"@sfs","containerName":"set_ParentIDs_from_hierarchy","kind":13},{"line":147,"kind":13,"localvar":"my","containerName":"set_ParentIDs_from_hierarchy","name":"@subsfs","definition":"my"},{"containerName":"set_ParentIDs_from_hierarchy","kind":13,"name":"$sf","line":147},{"line":147,"name":"get_SeqFeatures","kind":12,"containerName":"set_ParentIDs_from_hierarchy"},{"line":150,"containerName":"set_ParentIDs_from_hierarchy","localvar":"my","kind":13,"name":"$id","definition":"my"},{"line":150,"name":"$sf","kind":13,"containerName":"set_ParentIDs_from_hierarchy"},{"name":"primary_id","containerName":"set_ParentIDs_from_hierarchy","kind":12,"line":150},{"name":"$id","kind":13,"containerName":"set_ParentIDs_from_hierarchy","line":151},{"name":"$id","containerName":"set_ParentIDs_from_hierarchy","kind":13,"line":155},{"line":155,"containerName":"set_ParentIDs_from_hierarchy","kind":13,"name":"$sf"},{"containerName":"set_ParentIDs_from_hierarchy","kind":12,"name":"generate_unique_persistent_id","line":155},{"definition":"my","line":157,"name":"$subsf","localvar":"my","containerName":"set_ParentIDs_from_hierarchy","kind":13},{"name":"@subsfs","containerName":"set_ParentIDs_from_hierarchy","kind":13,"line":157},{"line":158,"kind":13,"containerName":"set_ParentIDs_from_hierarchy","name":"$subsf"},{"line":158,"kind":12,"containerName":"set_ParentIDs_from_hierarchy","name":"add_tag_value"},{"name":"$id","containerName":"set_ParentIDs_from_hierarchy","kind":13,"line":158},{"line":162,"containerName":"set_ParentIDs_from_hierarchy","kind":13,"name":"@sfs"},{"kind":13,"containerName":"set_ParentIDs_from_hierarchy","name":"@subsfs","line":162}]},{"line":179,"range":{"start":{"line":179,"character":0},"end":{"line":212,"character":9999}},"kind":12,"signature":{"label":"create_hierarchy_from_ParentIDs($self,$featholder,@args)","documentation":"1;\n# $Id: IDHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::SeqFeature::Tools::IDHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Mungall <cjm@fruitfly.org>\n#\n# Copyright Chris Mungall\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Tools::IDHandler - maps $seq_feature-E<gt>primary_tag\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n  use Bio::SeqFeature::Tools::IDHandler;\n\n\n=head1 DESCRIPTION\n\nClass to map $seq_feature-E<gt>primary_tag\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Mungall\n\nEmail:  cjm@fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Tools::IDHandler;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $unflattener = Bio::SeqFeature::Tools::IDHandler->new();\n Function: constructor\n Example : \n Returns : a new Bio::SeqFeature::Tools::IDHandler\n Args    : see below\n\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($generate_id_sub) =\n\t$self->_rearrange([qw(GENERATE_ID_SUB\n\t\t\t     )],\n                          @args);\n\n    return $self; # success - we hope!\n}\n\n=head2 set_ParentIDs_from_hierarchy()\n\n Title   : set_ParentIDs_from_hierarchy()\n Usage   : $idhandler->set_ParentIDs_from_hierarchy($fholder)\n Function: populates tags Parent and ID via holder hierarchy\n Example :\n Returns : \n Args    : Bio::featureHolderI (either a SeqFeature or a Seq)\n\nThis is mainly for GFF3 export\n\nGFF3 uses the tags ID and Parent to represent the feature containment\nhierarchy; it does NOT use the feature holder tree\n\nThis method sets Parent (and ID for any parents not set) based on\nfeature holder/containement hierarchy, ready for GFF3 output\n\n\n# method author: cjm@fruitfly.org\nsub set_ParentIDs_from_hierarchy(){\n   my $self = shift;\n   my ($featholder) = @_;\n\n   # we will traverse the tree of contained seqfeatures\n   # (a seqfeature is itself a holder)\n\n   # start with the top-level features\n   my @sfs = $featholder->get_SeqFeatures;\n\n   # clear existing parent tags\n   # (we assume this is the desired behaviour)\n   my @all_sfs = $featholder->get_all_SeqFeatures;\n   foreach (@all_sfs) {\n       if ($_->has_tag('Parent')) {\n           $_->remove_tag('Parent');\n       }\n   }\n   \n\n   # iterate until entire tree traversed\n   while (@sfs) {\n       my $sf = shift @sfs;\n       my @subsfs = $sf->get_SeqFeatures;\n\n       # see if the ID tag \n       my $id = $sf->primary_id;\n       if (!$id) {\n           # the skolem function feature(seq,start,end,type)\n           # is presumed to uniquely identify this feature, and\n           # to also be persistent\n           $id = $sf->generate_unique_persistent_id;\n       }\n       foreach my $subsf (@subsfs) {\n           $subsf->add_tag_value('Parent', $id);\n       }\n       \n       # push children on to end of stack (breadth first search)\n       push(@sfs, @subsfs);\n   }\n   return;\n}\n\n=head2 create_hierarchy_from_ParentIDs\n\n Title   : create_hierarchy_from_ParentIDs\n Usage   : $idhandler->set_ParentIDs_from_hierarchy($fholder)\n Function: inverse of set_ParentIDs_from_hierarchy\n Example :\n Returns : list of top SeqFeatures\n Args    :","parameters":[{"label":"$self"},{"label":"$featholder"},{"label":"@args"}]},"children":[{"name":"$self","localvar":"my","kind":13,"containerName":"create_hierarchy_from_ParentIDs","line":180,"definition":"my"},{"name":"$featholder","kind":13,"containerName":"create_hierarchy_from_ParentIDs","line":180},{"name":"@args","containerName":"create_hierarchy_from_ParentIDs","kind":13,"line":180},{"definition":"my","name":"@sfs","kind":13,"localvar":"my","containerName":"create_hierarchy_from_ParentIDs","line":182},{"name":"$featholder","kind":13,"containerName":"create_hierarchy_from_ParentIDs","line":182},{"kind":12,"containerName":"create_hierarchy_from_ParentIDs","name":"get_all_SeqFeatures","line":182},{"definition":"my","line":183,"localvar":"my","kind":13,"containerName":"create_hierarchy_from_ParentIDs","name":"%sf_by_ID"},{"name":"@sfs","kind":13,"containerName":"create_hierarchy_from_ParentIDs","line":184},{"definition":"my","localvar":"my","kind":13,"containerName":"create_hierarchy_from_ParentIDs","name":"$id","line":185},{"line":185,"containerName":"create_hierarchy_from_ParentIDs","kind":12,"name":"primary_id"},{"containerName":"create_hierarchy_from_ParentIDs","kind":13,"name":"$id","line":186},{"line":187,"name":"$sf_by_ID","kind":13,"containerName":"create_hierarchy_from_ParentIDs"},{"line":187,"name":"$id","containerName":"create_hierarchy_from_ParentIDs","kind":13},{"line":188,"containerName":"create_hierarchy_from_ParentIDs","kind":13,"name":"$featholder"},{"name":"throw","containerName":"create_hierarchy_from_ParentIDs","kind":12,"line":188},{"name":"$sf_by_ID","containerName":"create_hierarchy_from_ParentIDs","kind":13,"line":190},{"line":190,"name":"$id","containerName":"create_hierarchy_from_ParentIDs","kind":13},{"kind":12,"containerName":"create_hierarchy_from_ParentIDs","name":"remove_SeqFeatures","line":191},{"name":"%sf_by_ID","containerName":"create_hierarchy_from_ParentIDs","kind":13,"line":193},{"line":200,"name":"@topsfs","kind":13,"localvar":"my","containerName":"create_hierarchy_from_ParentIDs","definition":"my"},{"definition":"my","line":202,"name":"@parents","localvar":"my","kind":13,"containerName":"create_hierarchy_from_ParentIDs"},{"line":202,"containerName":"create_hierarchy_from_ParentIDs","kind":12,"name":"get_tagset_values"},{"line":203,"name":"$parent","localvar":"my","containerName":"create_hierarchy_from_ParentIDs","kind":13,"definition":"my"},{"kind":13,"containerName":"create_hierarchy_from_ParentIDs","name":"@parents","line":203},{"kind":13,"containerName":"create_hierarchy_from_ParentIDs","name":"$sf_by_ID","line":204},{"kind":13,"containerName":"create_hierarchy_from_ParentIDs","name":"$parent","line":204},{"line":204,"containerName":"create_hierarchy_from_ParentIDs","kind":12,"name":"add_SeqFeature"},{"containerName":"create_hierarchy_from_ParentIDs","kind":13,"name":"$sf_by_ID","line":205},{"name":"$parent","containerName":"create_hierarchy_from_ParentIDs","kind":13,"line":205},{"line":207,"name":"@parents","kind":13,"containerName":"create_hierarchy_from_ParentIDs"},{"line":208,"kind":13,"containerName":"create_hierarchy_from_ParentIDs","name":"@sfs"},{"containerName":"create_hierarchy_from_ParentIDs","kind":13,"name":"$featholder","line":209},{"name":"remove_SeqFeatures","kind":12,"containerName":"create_hierarchy_from_ParentIDs","line":209},{"name":"$featholder","containerName":"create_hierarchy_from_ParentIDs","kind":13,"line":210},{"name":"add_SeqFeature","containerName":"create_hierarchy_from_ParentIDs","kind":12,"line":210},{"line":210,"kind":13,"containerName":"create_hierarchy_from_ParentIDs","name":"@topsfs"},{"name":"@topsfs","containerName":"create_hierarchy_from_ParentIDs","kind":13,"line":211}],"name":"create_hierarchy_from_ParentIDs","containerName":"main::","definition":"sub","detail":"($self,$featholder,@args)"},{"children":[{"localvar":"my","kind":13,"containerName":"generate_unique_persistent_id","name":"$self","line":248,"definition":"my"},{"line":248,"name":"$sf","containerName":"generate_unique_persistent_id","kind":13},{"name":"@args","containerName":"generate_unique_persistent_id","kind":13,"line":248},{"definition":"my","containerName":"generate_unique_persistent_id","localvar":"my","kind":13,"name":"$id","line":250},{"kind":13,"containerName":"generate_unique_persistent_id","name":"$sf","line":251},{"line":251,"name":"isa","kind":12,"containerName":"generate_unique_persistent_id"},{"line":252,"name":"$sf","containerName":"generate_unique_persistent_id","kind":13},{"line":252,"name":"throw","containerName":"generate_unique_persistent_id","kind":12},{"definition":"my","name":"$seq_id","containerName":"generate_unique_persistent_id","localvar":"my","kind":13,"line":254},{"kind":13,"containerName":"generate_unique_persistent_id","name":"$sf","line":254},{"kind":12,"containerName":"generate_unique_persistent_id","name":"seq_id","line":254},{"name":"$sf","containerName":"generate_unique_persistent_id","kind":13,"line":254},{"kind":12,"containerName":"generate_unique_persistent_id","name":"throw","line":254},{"line":256,"kind":13,"containerName":"generate_unique_persistent_id","name":"$sf"},{"line":256,"name":"has_tag","kind":12,"containerName":"generate_unique_persistent_id"},{"name":"$id","kind":13,"containerName":"generate_unique_persistent_id","line":257},{"name":"$sf","kind":13,"containerName":"generate_unique_persistent_id","line":257},{"name":"get_tag_values","kind":12,"containerName":"generate_unique_persistent_id","line":257},{"line":259,"kind":13,"containerName":"generate_unique_persistent_id","name":"$sf"},{"line":259,"name":"has_tag","kind":12,"containerName":"generate_unique_persistent_id"},{"containerName":"generate_unique_persistent_id","kind":13,"name":"$id","line":260},{"kind":13,"containerName":"generate_unique_persistent_id","name":"$sf","line":260},{"line":260,"kind":12,"containerName":"generate_unique_persistent_id","name":"get_tag_values"},{"definition":"my","line":263,"name":"$source","localvar":"my","containerName":"generate_unique_persistent_id","kind":13},{"line":263,"name":"$sf","containerName":"generate_unique_persistent_id","kind":13},{"kind":12,"containerName":"generate_unique_persistent_id","name":"source_tag","line":263},{"containerName":"generate_unique_persistent_id","kind":13,"name":"$sf","line":263},{"containerName":"generate_unique_persistent_id","kind":12,"name":"throw","line":263},{"definition":"my","line":265,"name":"$start","containerName":"generate_unique_persistent_id","localvar":"my","kind":13},{"name":"$sf","kind":13,"containerName":"generate_unique_persistent_id","line":265},{"name":"start","kind":12,"containerName":"generate_unique_persistent_id","line":265},{"line":265,"kind":13,"containerName":"generate_unique_persistent_id","name":"$sf"},{"kind":12,"containerName":"generate_unique_persistent_id","name":"throw","line":265},{"definition":"my","line":266,"containerName":"generate_unique_persistent_id","localvar":"my","kind":13,"name":"$end"},{"line":266,"containerName":"generate_unique_persistent_id","kind":13,"name":"$sf"},{"containerName":"generate_unique_persistent_id","kind":12,"name":"end","line":266},{"line":266,"containerName":"generate_unique_persistent_id","kind":13,"name":"$sf"},{"line":266,"name":"throw","containerName":"generate_unique_persistent_id","kind":12},{"definition":"my","name":"$type","localvar":"my","kind":13,"containerName":"generate_unique_persistent_id","line":267},{"kind":13,"containerName":"generate_unique_persistent_id","name":"$sf","line":267},{"name":"primary_tag","containerName":"generate_unique_persistent_id","kind":12,"line":267},{"name":"$sf","kind":13,"containerName":"generate_unique_persistent_id","line":267},{"line":267,"containerName":"generate_unique_persistent_id","kind":12,"name":"throw"},{"line":269,"containerName":"generate_unique_persistent_id","kind":13,"name":"$id"},{"line":271,"containerName":"generate_unique_persistent_id","kind":13,"name":"$sf"},{"line":271,"containerName":"generate_unique_persistent_id","kind":12,"name":"primary_id"},{"line":271,"name":"$id","containerName":"generate_unique_persistent_id","kind":13},{"line":272,"name":"$id","kind":13,"containerName":"generate_unique_persistent_id"}],"containerName":"main::","name":"generate_unique_persistent_id","definition":"sub","detail":"($self,$sf,@args)","line":247,"range":{"end":{"line":273,"character":9999},"start":{"line":247,"character":0}},"kind":12,"signature":{"documentation":"1;\n# $Id: IDHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::SeqFeature::Tools::IDHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Mungall <cjm@fruitfly.org>\n#\n# Copyright Chris Mungall\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Tools::IDHandler - maps $seq_feature-E<gt>primary_tag\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n  use Bio::SeqFeature::Tools::IDHandler;\n\n\n=head1 DESCRIPTION\n\nClass to map $seq_feature-E<gt>primary_tag\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Mungall\n\nEmail:  cjm@fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Tools::IDHandler;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $unflattener = Bio::SeqFeature::Tools::IDHandler->new();\n Function: constructor\n Example : \n Returns : a new Bio::SeqFeature::Tools::IDHandler\n Args    : see below\n\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($generate_id_sub) =\n\t$self->_rearrange([qw(GENERATE_ID_SUB\n\t\t\t     )],\n                          @args);\n\n    return $self; # success - we hope!\n}\n\n=head2 set_ParentIDs_from_hierarchy()\n\n Title   : set_ParentIDs_from_hierarchy()\n Usage   : $idhandler->set_ParentIDs_from_hierarchy($fholder)\n Function: populates tags Parent and ID via holder hierarchy\n Example :\n Returns : \n Args    : Bio::featureHolderI (either a SeqFeature or a Seq)\n\nThis is mainly for GFF3 export\n\nGFF3 uses the tags ID and Parent to represent the feature containment\nhierarchy; it does NOT use the feature holder tree\n\nThis method sets Parent (and ID for any parents not set) based on\nfeature holder/containement hierarchy, ready for GFF3 output\n\n\n# method author: cjm@fruitfly.org\nsub set_ParentIDs_from_hierarchy(){\n   my $self = shift;\n   my ($featholder) = @_;\n\n   # we will traverse the tree of contained seqfeatures\n   # (a seqfeature is itself a holder)\n\n   # start with the top-level features\n   my @sfs = $featholder->get_SeqFeatures;\n\n   # clear existing parent tags\n   # (we assume this is the desired behaviour)\n   my @all_sfs = $featholder->get_all_SeqFeatures;\n   foreach (@all_sfs) {\n       if ($_->has_tag('Parent')) {\n           $_->remove_tag('Parent');\n       }\n   }\n   \n\n   # iterate until entire tree traversed\n   while (@sfs) {\n       my $sf = shift @sfs;\n       my @subsfs = $sf->get_SeqFeatures;\n\n       # see if the ID tag \n       my $id = $sf->primary_id;\n       if (!$id) {\n           # the skolem function feature(seq,start,end,type)\n           # is presumed to uniquely identify this feature, and\n           # to also be persistent\n           $id = $sf->generate_unique_persistent_id;\n       }\n       foreach my $subsf (@subsfs) {\n           $subsf->add_tag_value('Parent', $id);\n       }\n       \n       # push children on to end of stack (breadth first search)\n       push(@sfs, @subsfs);\n   }\n   return;\n}\n\n=head2 create_hierarchy_from_ParentIDs\n\n Title   : create_hierarchy_from_ParentIDs\n Usage   : $idhandler->set_ParentIDs_from_hierarchy($fholder)\n Function: inverse of set_ParentIDs_from_hierarchy\n Example :\n Returns : list of top SeqFeatures\n Args    :\n\n\n\nsub create_hierarchy_from_ParentIDs{\n   my ($self,$featholder,@args) = @_;\n\n   my @sfs = $featholder->get_all_SeqFeatures;\n   my %sf_by_ID = ();\n   foreach (@sfs) {\n       my $id = $_->primary_id;\n       next unless $id;\n       if ($sf_by_ID{$id}) {\n           $featholder->throw(\"DUPLICATE ID: $id\");\n       }\n       $sf_by_ID{$id} = $_;\n       $_->remove_SeqFeatures; # clear existing hierarchy (assume this is desired)\n   }\n   if (!%sf_by_ID) {\n       # warn??\n       # this is actually expected behaviour for some kinds of data;\n       # eg lists of STSs - no containment hierarchy\n       return;\n   }\n\n   my @topsfs = \n     grep {\n         my @parents = $_->get_tagset_values('Parent');\n         foreach my $parent (@parents) {\n             $sf_by_ID{$parent}->add_SeqFeature($_)\n\t\t if exists $sf_by_ID{$parent};\n         }\n         !@parents;\n     } @sfs;\n   $featholder->remove_SeqFeatures;\n   $featholder->add_SeqFeature($_) foreach @topsfs;\n   return @topsfs;\n}\n\n\n=head2 generate_unique_persistent_id\n\n Title   : generate_unique_persistent_id\n Usage   :\n Function: generates a unique and persistent identifier for this\n Example :\n Returns : value of primary_id (a scalar)\n Args    :\n\nWill generate an ID, B<and> set primary_id() (see above)\n\nThe ID is a string generated from \n\n  seq_id\n  primary_tag\n  start\n  end\n\nThere are three underlying assumptions: that all the above accessors\nare set; that seq_id is a persistent and unique identifier for the\nsequence containing this feature; and that \n\n  (seq_id, primary_tag, start, end) \n\nis a \"unique constraint\" over features\n\nThe ID is persistent, so long as none of these values change - if they\ndo, it is considered a seperate entity\n\n method author: cjm@fruitfly.org","parameters":[{"label":"$self"},{"label":"$sf"},{"label":"@args"}],"label":"generate_unique_persistent_id($self,$sf,@args)"}}]}