{"version":5,"vars":[{"line":76,"containerName":"","kind":2,"name":"vars"},{"kind":2,"containerName":"","name":"strict","line":81},{"line":82,"name":"$Bio","containerName":null,"kind":13},{"name":"SeqFeature","kind":12,"containerName":"Gene::GeneStructure::WeakRefs","line":82},{"line":83,"containerName":null,"kind":13,"name":"$Bio"},{"line":83,"kind":12,"containerName":"Gene::GeneStructure::WeakRefs","name":"SeqFeature"},{"containerName":"","kind":2,"name":"base","line":87},{"name":"new","containerName":"main::","children":[{"line":91,"name":"$caller","containerName":"new","localvar":"my","kind":13,"definition":"my"},{"line":91,"containerName":"new","kind":13,"name":"@args"},{"containerName":"new","localvar":"my","kind":13,"name":"$self","line":92,"definition":"my"},{"line":92,"containerName":"new","kind":13,"name":"$caller"},{"containerName":"new","kind":13,"name":"@args","line":92},{"line":93,"containerName":"new","kind":13,"name":"$self"},{"line":93,"name":"_register_for_cleanup","containerName":"new","kind":12},{"name":"$primary","localvar":"my","kind":13,"containerName":"new","line":94,"definition":"my"},{"line":95,"name":"$self","containerName":"new","kind":13},{"kind":12,"containerName":"new","name":"_rearrange","line":95},{"line":96,"kind":13,"containerName":"new","name":"@args"},{"line":98,"name":"$primary","containerName":"new","kind":13},{"name":"$primary","kind":13,"containerName":"new","line":98},{"line":99,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"containerName":"new","name":"primary_tag","line":99},{"line":99,"name":"$primary","containerName":"new","kind":13},{"name":"$self","kind":13,"containerName":"new","line":100},{"line":100,"kind":12,"containerName":"new","name":"strand"},{"name":"$self","kind":13,"containerName":"new","line":100},{"name":"strand","kind":12,"containerName":"new","line":100},{"kind":13,"containerName":"new","name":"$self","line":101}],"detail":"($caller,@args)","definition":"sub","range":{"end":{"line":102,"character":9999},"start":{"character":0,"line":90}},"kind":12,"line":90,"signature":{"documentation":"","parameters":[{"label":"$caller"},{"label":"@args"}],"label":"new($caller,@args)"}},{"name":"SUPER","kind":12,"containerName":"new","line":92},{"name":"gene_cleanup","kind":12,"line":93},{"children":[],"containerName":"main::","name":"transcripts","definition":"sub","line":117,"range":{"end":{"line":118,"character":9999},"start":{"line":117,"character":0}},"kind":12},{"name":"shift","kind":12,"line":118},{"signature":{"parameters":[{"label":"$self"},{"label":"$fea"}],"documentation":"1;\n# $Id: GeneStructure.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::GeneStructure\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::GeneStructure - A feature representing an arbitrarily complex structure of a gene\n\n=head1 SYNOPSIS\n\n  # See documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing a gene structure. As of now, a gene structure\nreally is only a collection of transcripts. See\nL<Bio::SeqFeature::Gene::TranscriptI> (interface) and\nL<Bio::SeqFeature::Gene::Transcript> (implementation) for the features\nof such objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\n the bugs and their resolution. Bug reports can be submitted via the\n web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::GeneStructure;\nuse vars qw($WeakRefs);\nuse strict;\n\nBEGIN {\n    eval \"use Scalar::Util qw(weaken);\";\n    if ($@) {\n\t$Bio::SeqFeature::Gene::GeneStructure::WeakRefs = 0;  \n    } else { $Bio::SeqFeature::Gene::GeneStructure::WeakRefs = 1; }\n}\n\n\nuse base qw(Bio::SeqFeature::Generic Bio::SeqFeature::Gene::GeneStructureI);\n\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&gene_cleanup);\n    my ($primary) =\n\t$self->_rearrange([qw(PRIMARY\n\t\t\t      )],@args);\n    \n    $primary = 'genestructure' unless $primary;\n    $self->primary_tag($primary);\n    $self->strand(0) if(! defined($self->strand()));\n    return $self;\n}\n\n=head2 transcripts\n\n Title   : transcripts\n Usage   : @transcripts = $gene->transcripts();\n Function: Get the transcripts of this gene structure. Many gene structures\n           will have only one transcript.\n\n Returns : An array of Bio::SeqFeature::Gene::TranscriptI implementing objects.\n Args    : \n\n\n\nsub transcripts {\n    return @{shift->{'_transcripts'} || []};\n}\n\n=head2 add_transcript\n\n Title   : add_transcript()\n Usage   : $gene->add_transcript($transcript);\n Function: Add a transcript to this gene structure.\n Returns : \n Args    : A Bio::SeqFeature::Gene::TranscriptI implementing object.","label":"add_transcript($self,$fea)"},"kind":12,"range":{"start":{"character":0,"line":132},"end":{"line":147,"character":9999}},"line":132,"detail":"($self,$fea)","definition":"sub","containerName":"main::","name":"add_transcript","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"add_transcript","line":133,"definition":"my"},{"name":"$fea","kind":13,"containerName":"add_transcript","line":133},{"name":"$fea","containerName":"add_transcript","kind":13,"line":135},{"containerName":"add_transcript","kind":13,"name":"$fea","line":135},{"name":"isa","kind":12,"containerName":"add_transcript","line":135},{"line":136,"name":"$self","containerName":"add_transcript","kind":13},{"containerName":"add_transcript","kind":12,"name":"throw","line":136},{"name":"$self","kind":13,"containerName":"add_transcript","line":138},{"name":"$self","containerName":"add_transcript","kind":13,"line":139},{"kind":13,"containerName":"add_transcript","name":"$self","line":141},{"name":"_expand_region","containerName":"add_transcript","kind":12,"line":141},{"containerName":"add_transcript","kind":13,"name":"$fea","line":141},{"containerName":"add_transcript","kind":13,"name":"$Bio","line":142},{"line":143,"containerName":"add_transcript","kind":13,"name":"$fea"},{"line":143,"name":"parent","kind":12,"containerName":"add_transcript"},{"name":"$self","kind":13,"containerName":"add_transcript","line":143},{"name":"$fea","containerName":"add_transcript","kind":13,"line":145},{"line":145,"containerName":"add_transcript","kind":12,"name":"parent"},{"line":145,"kind":13,"containerName":"add_transcript","name":"$self"},{"containerName":"add_transcript","kind":13,"name":"$self","line":147}]},{"name":"SeqFeature","kind":12,"containerName":"Gene::GeneStructure::WeakRefs","line":142},{"line":143,"kind":12,"name":"weaken"},{"line":147,"containerName":null,"kind":13,"name":"$fea"},{"definition":"sub","detail":"($self)","children":[{"definition":"my","line":162,"kind":13,"localvar":"my","containerName":"flush_transcripts","name":"$self"},{"name":"$self","kind":13,"containerName":"flush_transcripts","line":163},{"containerName":"flush_transcripts","localvar":"my","kind":13,"name":"$t","line":164,"definition":"my"},{"line":164,"name":"$self","kind":13,"containerName":"flush_transcripts"},{"name":"$t","containerName":"flush_transcripts","kind":13,"line":165},{"line":165,"containerName":"flush_transcripts","kind":12,"name":"parent"},{"name":"$t","kind":13,"containerName":"flush_transcripts","line":166},{"kind":13,"containerName":"flush_transcripts","name":"$self","line":168}],"name":"flush_transcripts","containerName":"main::","signature":{"label":"flush_transcripts($self)","documentation":"1;\n# $Id: GeneStructure.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::GeneStructure\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::GeneStructure - A feature representing an arbitrarily complex structure of a gene\n\n=head1 SYNOPSIS\n\n  # See documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing a gene structure. As of now, a gene structure\nreally is only a collection of transcripts. See\nL<Bio::SeqFeature::Gene::TranscriptI> (interface) and\nL<Bio::SeqFeature::Gene::Transcript> (implementation) for the features\nof such objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\n the bugs and their resolution. Bug reports can be submitted via the\n web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::GeneStructure;\nuse vars qw($WeakRefs);\nuse strict;\n\nBEGIN {\n    eval \"use Scalar::Util qw(weaken);\";\n    if ($@) {\n\t$Bio::SeqFeature::Gene::GeneStructure::WeakRefs = 0;  \n    } else { $Bio::SeqFeature::Gene::GeneStructure::WeakRefs = 1; }\n}\n\n\nuse base qw(Bio::SeqFeature::Generic Bio::SeqFeature::Gene::GeneStructureI);\n\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&gene_cleanup);\n    my ($primary) =\n\t$self->_rearrange([qw(PRIMARY\n\t\t\t      )],@args);\n    \n    $primary = 'genestructure' unless $primary;\n    $self->primary_tag($primary);\n    $self->strand(0) if(! defined($self->strand()));\n    return $self;\n}\n\n=head2 transcripts\n\n Title   : transcripts\n Usage   : @transcripts = $gene->transcripts();\n Function: Get the transcripts of this gene structure. Many gene structures\n           will have only one transcript.\n\n Returns : An array of Bio::SeqFeature::Gene::TranscriptI implementing objects.\n Args    : \n\n\n\nsub transcripts {\n    return @{shift->{'_transcripts'} || []};\n}\n\n=head2 add_transcript\n\n Title   : add_transcript()\n Usage   : $gene->add_transcript($transcript);\n Function: Add a transcript to this gene structure.\n Returns : \n Args    : A Bio::SeqFeature::Gene::TranscriptI implementing object.\n\n\n\nsub add_transcript {\n    my ($self, $fea) = @_;\n\n    if(!$fea || ! $fea->isa('Bio::SeqFeature::Gene::TranscriptI') ) {\n\t$self->throw(\"$fea does not implement Bio::SeqFeature::Gene::TranscriptI\");\n    }\n    unless( exists $self->{'_transcripts'}  ) {\n\t$self->{'_transcripts'} = [];\n    }\n    $self->_expand_region($fea);\n    if( $Bio::SeqFeature::Gene::GeneStructure::WeakRefs ) {\n\t$fea->parent(weaken $self);\n    } else {\n\t$fea->parent($self);\n    }\n    push(@{$self->{'_transcripts'}}, $fea);\n}\n\n=head2 flush_transcripts\n\n Title   : flush_transcripts()\n Usage   : $gene->flush_transcripts();\n Function: Remove all transcripts from this gene structure.\n Returns : \n Args    :","parameters":[{"label":"$self"}]},"line":161,"range":{"start":{"line":161,"character":0},"end":{"line":169,"character":9999}},"kind":12},{"kind":12,"name":"defined","line":164},{"signature":{"label":"add_transcript_as_features($self,@features)","documentation":"1;\n# $Id: GeneStructure.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::GeneStructure\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::GeneStructure - A feature representing an arbitrarily complex structure of a gene\n\n=head1 SYNOPSIS\n\n  # See documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing a gene structure. As of now, a gene structure\nreally is only a collection of transcripts. See\nL<Bio::SeqFeature::Gene::TranscriptI> (interface) and\nL<Bio::SeqFeature::Gene::Transcript> (implementation) for the features\nof such objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\n the bugs and their resolution. Bug reports can be submitted via the\n web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::GeneStructure;\nuse vars qw($WeakRefs);\nuse strict;\n\nBEGIN {\n    eval \"use Scalar::Util qw(weaken);\";\n    if ($@) {\n\t$Bio::SeqFeature::Gene::GeneStructure::WeakRefs = 0;  \n    } else { $Bio::SeqFeature::Gene::GeneStructure::WeakRefs = 1; }\n}\n\n\nuse base qw(Bio::SeqFeature::Generic Bio::SeqFeature::Gene::GeneStructureI);\n\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&gene_cleanup);\n    my ($primary) =\n\t$self->_rearrange([qw(PRIMARY\n\t\t\t      )],@args);\n    \n    $primary = 'genestructure' unless $primary;\n    $self->primary_tag($primary);\n    $self->strand(0) if(! defined($self->strand()));\n    return $self;\n}\n\n=head2 transcripts\n\n Title   : transcripts\n Usage   : @transcripts = $gene->transcripts();\n Function: Get the transcripts of this gene structure. Many gene structures\n           will have only one transcript.\n\n Returns : An array of Bio::SeqFeature::Gene::TranscriptI implementing objects.\n Args    : \n\n\n\nsub transcripts {\n    return @{shift->{'_transcripts'} || []};\n}\n\n=head2 add_transcript\n\n Title   : add_transcript()\n Usage   : $gene->add_transcript($transcript);\n Function: Add a transcript to this gene structure.\n Returns : \n Args    : A Bio::SeqFeature::Gene::TranscriptI implementing object.\n\n\n\nsub add_transcript {\n    my ($self, $fea) = @_;\n\n    if(!$fea || ! $fea->isa('Bio::SeqFeature::Gene::TranscriptI') ) {\n\t$self->throw(\"$fea does not implement Bio::SeqFeature::Gene::TranscriptI\");\n    }\n    unless( exists $self->{'_transcripts'}  ) {\n\t$self->{'_transcripts'} = [];\n    }\n    $self->_expand_region($fea);\n    if( $Bio::SeqFeature::Gene::GeneStructure::WeakRefs ) {\n\t$fea->parent(weaken $self);\n    } else {\n\t$fea->parent($self);\n    }\n    push(@{$self->{'_transcripts'}}, $fea);\n}\n\n=head2 flush_transcripts\n\n Title   : flush_transcripts()\n Usage   : $gene->flush_transcripts();\n Function: Remove all transcripts from this gene structure.\n Returns : \n Args    :\n\n\n\nsub flush_transcripts {\n    my ($self) = @_;    \n    if( defined $self->{'_transcripts'} ) {\n\tforeach my $t ( grep {defined} @{$self->{'_transcripts'} || []} ) {\n\t    $t->parent(undef); # remove bkwds pointers\n\t    $t = undef;\n\t}\n\tdelete($self->{'_transcripts'});\t\n    }\n}\n\n=head2 add_transcript_as_features\n\n Title   : add_transcript_as_features\n Usage   : $gene->add_transcript_as_features(@featurelist);\n Function: take a list of Bio::SeqFeatureI objects and turn them into a\n           Bio::SeqFeature::Gene::Transcript object.  Add that transcript to the gene.\n Returns : nothing\n Args    : a list of Bio::SeqFeatureI compliant objects","parameters":[{"label":"$self"},{"label":"@features"}]},"range":{"start":{"character":0,"line":184},"end":{"line":199,"character":9999}},"kind":12,"line":184,"detail":"($self,@features)","definition":"sub","containerName":"main::","name":"add_transcript_as_features","children":[{"definition":"my","line":185,"name":"$self","localvar":"my","containerName":"add_transcript_as_features","kind":13},{"line":185,"kind":13,"containerName":"add_transcript_as_features","name":"@features"},{"line":186,"name":"$transcript","containerName":"add_transcript_as_features","localvar":"my","kind":13,"definition":"my"},{"line":186,"name":"new","kind":12,"containerName":"add_transcript_as_features"},{"line":187,"name":"$fea","kind":13,"localvar":"my","containerName":"add_transcript_as_features","definition":"my"},{"name":"@features","containerName":"add_transcript_as_features","kind":13,"line":187},{"line":188,"name":"$fea","containerName":"add_transcript_as_features","kind":13},{"line":188,"kind":12,"containerName":"add_transcript_as_features","name":"primary_tag"},{"name":"$transcript","containerName":"add_transcript_as_features","kind":13,"line":189},{"line":189,"containerName":"add_transcript_as_features","kind":12,"name":"add_utr"},{"name":"$fea","containerName":"add_transcript_as_features","kind":13,"line":189},{"containerName":"add_transcript_as_features","kind":13,"name":"$fea","line":190},{"name":"primary_tag","containerName":"add_transcript_as_features","kind":12,"line":190},{"name":"$transcript","kind":13,"containerName":"add_transcript_as_features","line":191},{"line":191,"containerName":"add_transcript_as_features","kind":12,"name":"add_promoter"},{"kind":13,"containerName":"add_transcript_as_features","name":"$fea","line":191},{"kind":13,"containerName":"add_transcript_as_features","name":"$fea","line":192},{"line":192,"containerName":"add_transcript_as_features","kind":12,"name":"primary_tag"},{"line":193,"kind":13,"containerName":"add_transcript_as_features","name":"$transcript"},{"line":193,"containerName":"add_transcript_as_features","kind":12,"name":"poly_A_site"},{"name":"$fea","containerName":"add_transcript_as_features","kind":13,"line":193},{"name":"$transcript","containerName":"add_transcript_as_features","kind":13,"line":195},{"kind":12,"containerName":"add_transcript_as_features","name":"add_exon","line":195},{"name":"$fea","kind":13,"containerName":"add_transcript_as_features","line":195},{"name":"$self","containerName":"add_transcript_as_features","kind":13,"line":198},{"containerName":"add_transcript_as_features","kind":12,"name":"add_transcript","line":198},{"line":198,"kind":13,"containerName":"add_transcript_as_features","name":"$transcript"}]},{"line":186,"name":"Bio","kind":12,"containerName":"SeqFeature::Gene::Transcript"},{"detail":"($self)","definition":"sub","name":"promoters","containerName":"main::","children":[{"line":221,"localvar":"my","containerName":"promoters","kind":13,"name":"$self","definition":"my"},{"definition":"my","name":"@transcripts","localvar":"my","containerName":"promoters","kind":13,"line":222},{"name":"$self","kind":13,"containerName":"promoters","line":222},{"name":"transcripts","kind":12,"containerName":"promoters","line":222},{"definition":"my","line":223,"name":"@feas","localvar":"my","containerName":"promoters","kind":13},{"containerName":"promoters","localvar":"my","kind":13,"name":"$tr","line":225,"definition":"my"},{"line":225,"containerName":"promoters","kind":13,"name":"@transcripts"},{"line":226,"containerName":"promoters","kind":13,"name":"@feas"},{"name":"$tr","containerName":"promoters","kind":13,"line":226},{"containerName":"promoters","kind":12,"name":"promoters","line":226},{"line":228,"name":"@feas","kind":13,"containerName":"promoters"}],"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: GeneStructure.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::GeneStructure\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::GeneStructure - A feature representing an arbitrarily complex structure of a gene\n\n=head1 SYNOPSIS\n\n  # See documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing a gene structure. As of now, a gene structure\nreally is only a collection of transcripts. See\nL<Bio::SeqFeature::Gene::TranscriptI> (interface) and\nL<Bio::SeqFeature::Gene::Transcript> (implementation) for the features\nof such objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\n the bugs and their resolution. Bug reports can be submitted via the\n web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::GeneStructure;\nuse vars qw($WeakRefs);\nuse strict;\n\nBEGIN {\n    eval \"use Scalar::Util qw(weaken);\";\n    if ($@) {\n\t$Bio::SeqFeature::Gene::GeneStructure::WeakRefs = 0;  \n    } else { $Bio::SeqFeature::Gene::GeneStructure::WeakRefs = 1; }\n}\n\n\nuse base qw(Bio::SeqFeature::Generic Bio::SeqFeature::Gene::GeneStructureI);\n\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&gene_cleanup);\n    my ($primary) =\n\t$self->_rearrange([qw(PRIMARY\n\t\t\t      )],@args);\n    \n    $primary = 'genestructure' unless $primary;\n    $self->primary_tag($primary);\n    $self->strand(0) if(! defined($self->strand()));\n    return $self;\n}\n\n=head2 transcripts\n\n Title   : transcripts\n Usage   : @transcripts = $gene->transcripts();\n Function: Get the transcripts of this gene structure. Many gene structures\n           will have only one transcript.\n\n Returns : An array of Bio::SeqFeature::Gene::TranscriptI implementing objects.\n Args    : \n\n\n\nsub transcripts {\n    return @{shift->{'_transcripts'} || []};\n}\n\n=head2 add_transcript\n\n Title   : add_transcript()\n Usage   : $gene->add_transcript($transcript);\n Function: Add a transcript to this gene structure.\n Returns : \n Args    : A Bio::SeqFeature::Gene::TranscriptI implementing object.\n\n\n\nsub add_transcript {\n    my ($self, $fea) = @_;\n\n    if(!$fea || ! $fea->isa('Bio::SeqFeature::Gene::TranscriptI') ) {\n\t$self->throw(\"$fea does not implement Bio::SeqFeature::Gene::TranscriptI\");\n    }\n    unless( exists $self->{'_transcripts'}  ) {\n\t$self->{'_transcripts'} = [];\n    }\n    $self->_expand_region($fea);\n    if( $Bio::SeqFeature::Gene::GeneStructure::WeakRefs ) {\n\t$fea->parent(weaken $self);\n    } else {\n\t$fea->parent($self);\n    }\n    push(@{$self->{'_transcripts'}}, $fea);\n}\n\n=head2 flush_transcripts\n\n Title   : flush_transcripts()\n Usage   : $gene->flush_transcripts();\n Function: Remove all transcripts from this gene structure.\n Returns : \n Args    :\n\n\n\nsub flush_transcripts {\n    my ($self) = @_;    \n    if( defined $self->{'_transcripts'} ) {\n\tforeach my $t ( grep {defined} @{$self->{'_transcripts'} || []} ) {\n\t    $t->parent(undef); # remove bkwds pointers\n\t    $t = undef;\n\t}\n\tdelete($self->{'_transcripts'});\t\n    }\n}\n\n=head2 add_transcript_as_features\n\n Title   : add_transcript_as_features\n Usage   : $gene->add_transcript_as_features(@featurelist);\n Function: take a list of Bio::SeqFeatureI objects and turn them into a\n           Bio::SeqFeature::Gene::Transcript object.  Add that transcript to the gene.\n Returns : nothing\n Args    : a list of Bio::SeqFeatureI compliant objects\n\n\n\nsub add_transcript_as_features {\n    my ($self,@features) = @_;\n    my $transcript=Bio::SeqFeature::Gene::Transcript->new;\n    foreach my $fea (@features) {\n\tif ($fea->primary_tag =~ /utr/i) { #UTR / utr/ 3' utr / utr5 etc.\n\t    $transcript->add_utr($fea);\n\t} elsif ($fea->primary_tag =~ /promot/i) { #allow for spelling differences\n\t    $transcript->add_promoter($fea);\n\t} elsif ($fea->primary_tag =~ /poly.*A/i) { #polyA, POLY_A, etc.\n\t    $transcript->poly_A_site($fea);\n\t} else {\t\t#assume the rest are exons\n\t    $transcript->add_exon($fea);\n\t}\n    }\n    $self->add_transcript($transcript);\n}\n\n\n=head2 promoters\n\n Title   : promoters\n Usage   : @prom_sites = $gene->promoters();\n Function: Get the promoter features of this gene structure.\n\n           This method basically merges the promoters returned by transcripts.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects.\n Args    : ","label":"promoters($self)"},"kind":12,"range":{"start":{"line":220,"character":0},"end":{"line":229,"character":9999}},"line":220},{"definition":"sub","detail":"($self,@args)","children":[{"line":255,"name":"$self","localvar":"my","kind":13,"containerName":"exons","definition":"my"},{"containerName":"exons","kind":13,"name":"@args","line":255},{"definition":"my","line":256,"name":"@transcripts","kind":13,"localvar":"my","containerName":"exons"},{"line":256,"name":"$self","kind":13,"containerName":"exons"},{"line":256,"containerName":"exons","kind":12,"name":"transcripts"},{"line":257,"name":"@feas","kind":13,"localvar":"my","containerName":"exons","definition":"my"},{"localvar":"my","kind":13,"containerName":"exons","name":"$tr","line":259,"definition":"my"},{"name":"@transcripts","containerName":"exons","kind":13,"line":259},{"name":"@feas","kind":13,"containerName":"exons","line":260},{"name":"$tr","containerName":"exons","kind":13,"line":260},{"line":260,"kind":12,"containerName":"exons","name":"exons"},{"kind":13,"containerName":"exons","name":"@args","line":260},{"line":262,"name":"@feas","kind":13,"containerName":"exons"}],"name":"exons","containerName":"main::","signature":{"label":"exons($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: GeneStructure.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::GeneStructure\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::GeneStructure - A feature representing an arbitrarily complex structure of a gene\n\n=head1 SYNOPSIS\n\n  # See documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing a gene structure. As of now, a gene structure\nreally is only a collection of transcripts. See\nL<Bio::SeqFeature::Gene::TranscriptI> (interface) and\nL<Bio::SeqFeature::Gene::Transcript> (implementation) for the features\nof such objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\n the bugs and their resolution. Bug reports can be submitted via the\n web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::GeneStructure;\nuse vars qw($WeakRefs);\nuse strict;\n\nBEGIN {\n    eval \"use Scalar::Util qw(weaken);\";\n    if ($@) {\n\t$Bio::SeqFeature::Gene::GeneStructure::WeakRefs = 0;  \n    } else { $Bio::SeqFeature::Gene::GeneStructure::WeakRefs = 1; }\n}\n\n\nuse base qw(Bio::SeqFeature::Generic Bio::SeqFeature::Gene::GeneStructureI);\n\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&gene_cleanup);\n    my ($primary) =\n\t$self->_rearrange([qw(PRIMARY\n\t\t\t      )],@args);\n    \n    $primary = 'genestructure' unless $primary;\n    $self->primary_tag($primary);\n    $self->strand(0) if(! defined($self->strand()));\n    return $self;\n}\n\n=head2 transcripts\n\n Title   : transcripts\n Usage   : @transcripts = $gene->transcripts();\n Function: Get the transcripts of this gene structure. Many gene structures\n           will have only one transcript.\n\n Returns : An array of Bio::SeqFeature::Gene::TranscriptI implementing objects.\n Args    : \n\n\n\nsub transcripts {\n    return @{shift->{'_transcripts'} || []};\n}\n\n=head2 add_transcript\n\n Title   : add_transcript()\n Usage   : $gene->add_transcript($transcript);\n Function: Add a transcript to this gene structure.\n Returns : \n Args    : A Bio::SeqFeature::Gene::TranscriptI implementing object.\n\n\n\nsub add_transcript {\n    my ($self, $fea) = @_;\n\n    if(!$fea || ! $fea->isa('Bio::SeqFeature::Gene::TranscriptI') ) {\n\t$self->throw(\"$fea does not implement Bio::SeqFeature::Gene::TranscriptI\");\n    }\n    unless( exists $self->{'_transcripts'}  ) {\n\t$self->{'_transcripts'} = [];\n    }\n    $self->_expand_region($fea);\n    if( $Bio::SeqFeature::Gene::GeneStructure::WeakRefs ) {\n\t$fea->parent(weaken $self);\n    } else {\n\t$fea->parent($self);\n    }\n    push(@{$self->{'_transcripts'}}, $fea);\n}\n\n=head2 flush_transcripts\n\n Title   : flush_transcripts()\n Usage   : $gene->flush_transcripts();\n Function: Remove all transcripts from this gene structure.\n Returns : \n Args    :\n\n\n\nsub flush_transcripts {\n    my ($self) = @_;    \n    if( defined $self->{'_transcripts'} ) {\n\tforeach my $t ( grep {defined} @{$self->{'_transcripts'} || []} ) {\n\t    $t->parent(undef); # remove bkwds pointers\n\t    $t = undef;\n\t}\n\tdelete($self->{'_transcripts'});\t\n    }\n}\n\n=head2 add_transcript_as_features\n\n Title   : add_transcript_as_features\n Usage   : $gene->add_transcript_as_features(@featurelist);\n Function: take a list of Bio::SeqFeatureI objects and turn them into a\n           Bio::SeqFeature::Gene::Transcript object.  Add that transcript to the gene.\n Returns : nothing\n Args    : a list of Bio::SeqFeatureI compliant objects\n\n\n\nsub add_transcript_as_features {\n    my ($self,@features) = @_;\n    my $transcript=Bio::SeqFeature::Gene::Transcript->new;\n    foreach my $fea (@features) {\n\tif ($fea->primary_tag =~ /utr/i) { #UTR / utr/ 3' utr / utr5 etc.\n\t    $transcript->add_utr($fea);\n\t} elsif ($fea->primary_tag =~ /promot/i) { #allow for spelling differences\n\t    $transcript->add_promoter($fea);\n\t} elsif ($fea->primary_tag =~ /poly.*A/i) { #polyA, POLY_A, etc.\n\t    $transcript->poly_A_site($fea);\n\t} else {\t\t#assume the rest are exons\n\t    $transcript->add_exon($fea);\n\t}\n    }\n    $self->add_transcript($transcript);\n}\n\n\n=head2 promoters\n\n Title   : promoters\n Usage   : @prom_sites = $gene->promoters();\n Function: Get the promoter features of this gene structure.\n\n           This method basically merges the promoters returned by transcripts.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects.\n Args    : \n\n\n\nsub promoters {\n    my ($self) = @_;\n    my @transcripts = $self->transcripts();\n    my @feas = ();\n\n    foreach my $tr (@transcripts) {\n\tpush(@feas, $tr->promoters());\n    }\n    return @feas;\n}\n\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $gene->exons();\n           @inital_exons = $gene->exons('Initial');\n Function: Get all exon features or all exons of a specified type of this gene\n           structure.\n\n           Exon type is treated as a case-insensitive regular expression and \n           optional. For consistency, use only the following types: \n           initial, internal, terminal, utr, utr5prime, and utr3prime. \n           A special and virtual type is 'coding', which refers to all types\n           except utr.\n\n           This method basically merges the exons returned by transcripts.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects.\n Args    : An optional string specifying the type of exon."},"line":254,"range":{"end":{"character":9999,"line":263},"start":{"line":254,"character":0}},"kind":12},{"signature":{"label":"introns($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: GeneStructure.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::GeneStructure\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::GeneStructure - A feature representing an arbitrarily complex structure of a gene\n\n=head1 SYNOPSIS\n\n  # See documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing a gene structure. As of now, a gene structure\nreally is only a collection of transcripts. See\nL<Bio::SeqFeature::Gene::TranscriptI> (interface) and\nL<Bio::SeqFeature::Gene::Transcript> (implementation) for the features\nof such objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\n the bugs and their resolution. Bug reports can be submitted via the\n web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::GeneStructure;\nuse vars qw($WeakRefs);\nuse strict;\n\nBEGIN {\n    eval \"use Scalar::Util qw(weaken);\";\n    if ($@) {\n\t$Bio::SeqFeature::Gene::GeneStructure::WeakRefs = 0;  \n    } else { $Bio::SeqFeature::Gene::GeneStructure::WeakRefs = 1; }\n}\n\n\nuse base qw(Bio::SeqFeature::Generic Bio::SeqFeature::Gene::GeneStructureI);\n\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&gene_cleanup);\n    my ($primary) =\n\t$self->_rearrange([qw(PRIMARY\n\t\t\t      )],@args);\n    \n    $primary = 'genestructure' unless $primary;\n    $self->primary_tag($primary);\n    $self->strand(0) if(! defined($self->strand()));\n    return $self;\n}\n\n=head2 transcripts\n\n Title   : transcripts\n Usage   : @transcripts = $gene->transcripts();\n Function: Get the transcripts of this gene structure. Many gene structures\n           will have only one transcript.\n\n Returns : An array of Bio::SeqFeature::Gene::TranscriptI implementing objects.\n Args    : \n\n\n\nsub transcripts {\n    return @{shift->{'_transcripts'} || []};\n}\n\n=head2 add_transcript\n\n Title   : add_transcript()\n Usage   : $gene->add_transcript($transcript);\n Function: Add a transcript to this gene structure.\n Returns : \n Args    : A Bio::SeqFeature::Gene::TranscriptI implementing object.\n\n\n\nsub add_transcript {\n    my ($self, $fea) = @_;\n\n    if(!$fea || ! $fea->isa('Bio::SeqFeature::Gene::TranscriptI') ) {\n\t$self->throw(\"$fea does not implement Bio::SeqFeature::Gene::TranscriptI\");\n    }\n    unless( exists $self->{'_transcripts'}  ) {\n\t$self->{'_transcripts'} = [];\n    }\n    $self->_expand_region($fea);\n    if( $Bio::SeqFeature::Gene::GeneStructure::WeakRefs ) {\n\t$fea->parent(weaken $self);\n    } else {\n\t$fea->parent($self);\n    }\n    push(@{$self->{'_transcripts'}}, $fea);\n}\n\n=head2 flush_transcripts\n\n Title   : flush_transcripts()\n Usage   : $gene->flush_transcripts();\n Function: Remove all transcripts from this gene structure.\n Returns : \n Args    :\n\n\n\nsub flush_transcripts {\n    my ($self) = @_;    \n    if( defined $self->{'_transcripts'} ) {\n\tforeach my $t ( grep {defined} @{$self->{'_transcripts'} || []} ) {\n\t    $t->parent(undef); # remove bkwds pointers\n\t    $t = undef;\n\t}\n\tdelete($self->{'_transcripts'});\t\n    }\n}\n\n=head2 add_transcript_as_features\n\n Title   : add_transcript_as_features\n Usage   : $gene->add_transcript_as_features(@featurelist);\n Function: take a list of Bio::SeqFeatureI objects and turn them into a\n           Bio::SeqFeature::Gene::Transcript object.  Add that transcript to the gene.\n Returns : nothing\n Args    : a list of Bio::SeqFeatureI compliant objects\n\n\n\nsub add_transcript_as_features {\n    my ($self,@features) = @_;\n    my $transcript=Bio::SeqFeature::Gene::Transcript->new;\n    foreach my $fea (@features) {\n\tif ($fea->primary_tag =~ /utr/i) { #UTR / utr/ 3' utr / utr5 etc.\n\t    $transcript->add_utr($fea);\n\t} elsif ($fea->primary_tag =~ /promot/i) { #allow for spelling differences\n\t    $transcript->add_promoter($fea);\n\t} elsif ($fea->primary_tag =~ /poly.*A/i) { #polyA, POLY_A, etc.\n\t    $transcript->poly_A_site($fea);\n\t} else {\t\t#assume the rest are exons\n\t    $transcript->add_exon($fea);\n\t}\n    }\n    $self->add_transcript($transcript);\n}\n\n\n=head2 promoters\n\n Title   : promoters\n Usage   : @prom_sites = $gene->promoters();\n Function: Get the promoter features of this gene structure.\n\n           This method basically merges the promoters returned by transcripts.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects.\n Args    : \n\n\n\nsub promoters {\n    my ($self) = @_;\n    my @transcripts = $self->transcripts();\n    my @feas = ();\n\n    foreach my $tr (@transcripts) {\n\tpush(@feas, $tr->promoters());\n    }\n    return @feas;\n}\n\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $gene->exons();\n           @inital_exons = $gene->exons('Initial');\n Function: Get all exon features or all exons of a specified type of this gene\n           structure.\n\n           Exon type is treated as a case-insensitive regular expression and \n           optional. For consistency, use only the following types: \n           initial, internal, terminal, utr, utr5prime, and utr3prime. \n           A special and virtual type is 'coding', which refers to all types\n           except utr.\n\n           This method basically merges the exons returned by transcripts.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects.\n Args    : An optional string specifying the type of exon.\n\n\n\nsub exons {\n    my ($self, @args) = @_;\n    my @transcripts = $self->transcripts();\n    my @feas = ();\n\n    foreach my $tr (@transcripts) {\n\tpush(@feas, $tr->exons(@args));\n    }\n    return @feas;\n}\n\n=head2 introns\n\n Title   : introns()\n Usage   : @introns = $gene->introns();\n Function: Get all introns of this gene structure.\n\n           Note that this class currently generates these features on-the-fly,\n           that is, it simply treats all regions between exons as introns.\n           It assumes that the exons in the transcripts do not overlap.\n\n           This method basically merges the introns returned by transcripts.\n\n Returns : An array of Bio::SeqFeatureI implementing objects.\n Args    : "},"line":283,"range":{"end":{"line":292,"character":9999},"start":{"line":283,"character":0}},"kind":12,"definition":"sub","detail":"($self)","children":[{"line":284,"localvar":"my","containerName":"introns","kind":13,"name":"$self","definition":"my"},{"definition":"my","name":"@transcripts","localvar":"my","containerName":"introns","kind":13,"line":285},{"line":285,"kind":13,"containerName":"introns","name":"$self"},{"containerName":"introns","kind":12,"name":"transcripts","line":285},{"line":286,"name":"@feas","localvar":"my","kind":13,"containerName":"introns","definition":"my"},{"definition":"my","kind":13,"localvar":"my","containerName":"introns","name":"$tr","line":288},{"line":288,"kind":13,"containerName":"introns","name":"@transcripts"},{"name":"@feas","containerName":"introns","kind":13,"line":289},{"line":289,"kind":13,"containerName":"introns","name":"$tr"},{"kind":12,"containerName":"introns","name":"introns","line":289},{"name":"@feas","containerName":"introns","kind":13,"line":291}],"containerName":"main::","name":"introns"},{"name":"poly_A_sites","containerName":"main::","children":[{"containerName":"poly_A_sites","localvar":"my","kind":13,"name":"$self","line":310,"definition":"my"},{"definition":"my","line":311,"name":"@transcripts","kind":13,"localvar":"my","containerName":"poly_A_sites"},{"name":"$self","containerName":"poly_A_sites","kind":13,"line":311},{"name":"transcripts","containerName":"poly_A_sites","kind":12,"line":311},{"definition":"my","line":312,"localvar":"my","kind":13,"containerName":"poly_A_sites","name":"@feas"},{"line":314,"containerName":"poly_A_sites","localvar":"my","kind":13,"name":"$tr","definition":"my"},{"name":"@transcripts","containerName":"poly_A_sites","kind":13,"line":314},{"name":"@feas","containerName":"poly_A_sites","kind":13,"line":315},{"line":315,"kind":13,"containerName":"poly_A_sites","name":"$tr"},{"line":315,"name":"poly_A_site","kind":12,"containerName":"poly_A_sites"},{"containerName":"poly_A_sites","kind":13,"name":"@feas","line":317}],"detail":"($self)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":318},"start":{"line":309,"character":0}},"line":309,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: GeneStructure.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::GeneStructure\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::GeneStructure - A feature representing an arbitrarily complex structure of a gene\n\n=head1 SYNOPSIS\n\n  # See documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing a gene structure. As of now, a gene structure\nreally is only a collection of transcripts. See\nL<Bio::SeqFeature::Gene::TranscriptI> (interface) and\nL<Bio::SeqFeature::Gene::Transcript> (implementation) for the features\nof such objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\n the bugs and their resolution. Bug reports can be submitted via the\n web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::GeneStructure;\nuse vars qw($WeakRefs);\nuse strict;\n\nBEGIN {\n    eval \"use Scalar::Util qw(weaken);\";\n    if ($@) {\n\t$Bio::SeqFeature::Gene::GeneStructure::WeakRefs = 0;  \n    } else { $Bio::SeqFeature::Gene::GeneStructure::WeakRefs = 1; }\n}\n\n\nuse base qw(Bio::SeqFeature::Generic Bio::SeqFeature::Gene::GeneStructureI);\n\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&gene_cleanup);\n    my ($primary) =\n\t$self->_rearrange([qw(PRIMARY\n\t\t\t      )],@args);\n    \n    $primary = 'genestructure' unless $primary;\n    $self->primary_tag($primary);\n    $self->strand(0) if(! defined($self->strand()));\n    return $self;\n}\n\n=head2 transcripts\n\n Title   : transcripts\n Usage   : @transcripts = $gene->transcripts();\n Function: Get the transcripts of this gene structure. Many gene structures\n           will have only one transcript.\n\n Returns : An array of Bio::SeqFeature::Gene::TranscriptI implementing objects.\n Args    : \n\n\n\nsub transcripts {\n    return @{shift->{'_transcripts'} || []};\n}\n\n=head2 add_transcript\n\n Title   : add_transcript()\n Usage   : $gene->add_transcript($transcript);\n Function: Add a transcript to this gene structure.\n Returns : \n Args    : A Bio::SeqFeature::Gene::TranscriptI implementing object.\n\n\n\nsub add_transcript {\n    my ($self, $fea) = @_;\n\n    if(!$fea || ! $fea->isa('Bio::SeqFeature::Gene::TranscriptI') ) {\n\t$self->throw(\"$fea does not implement Bio::SeqFeature::Gene::TranscriptI\");\n    }\n    unless( exists $self->{'_transcripts'}  ) {\n\t$self->{'_transcripts'} = [];\n    }\n    $self->_expand_region($fea);\n    if( $Bio::SeqFeature::Gene::GeneStructure::WeakRefs ) {\n\t$fea->parent(weaken $self);\n    } else {\n\t$fea->parent($self);\n    }\n    push(@{$self->{'_transcripts'}}, $fea);\n}\n\n=head2 flush_transcripts\n\n Title   : flush_transcripts()\n Usage   : $gene->flush_transcripts();\n Function: Remove all transcripts from this gene structure.\n Returns : \n Args    :\n\n\n\nsub flush_transcripts {\n    my ($self) = @_;    \n    if( defined $self->{'_transcripts'} ) {\n\tforeach my $t ( grep {defined} @{$self->{'_transcripts'} || []} ) {\n\t    $t->parent(undef); # remove bkwds pointers\n\t    $t = undef;\n\t}\n\tdelete($self->{'_transcripts'});\t\n    }\n}\n\n=head2 add_transcript_as_features\n\n Title   : add_transcript_as_features\n Usage   : $gene->add_transcript_as_features(@featurelist);\n Function: take a list of Bio::SeqFeatureI objects and turn them into a\n           Bio::SeqFeature::Gene::Transcript object.  Add that transcript to the gene.\n Returns : nothing\n Args    : a list of Bio::SeqFeatureI compliant objects\n\n\n\nsub add_transcript_as_features {\n    my ($self,@features) = @_;\n    my $transcript=Bio::SeqFeature::Gene::Transcript->new;\n    foreach my $fea (@features) {\n\tif ($fea->primary_tag =~ /utr/i) { #UTR / utr/ 3' utr / utr5 etc.\n\t    $transcript->add_utr($fea);\n\t} elsif ($fea->primary_tag =~ /promot/i) { #allow for spelling differences\n\t    $transcript->add_promoter($fea);\n\t} elsif ($fea->primary_tag =~ /poly.*A/i) { #polyA, POLY_A, etc.\n\t    $transcript->poly_A_site($fea);\n\t} else {\t\t#assume the rest are exons\n\t    $transcript->add_exon($fea);\n\t}\n    }\n    $self->add_transcript($transcript);\n}\n\n\n=head2 promoters\n\n Title   : promoters\n Usage   : @prom_sites = $gene->promoters();\n Function: Get the promoter features of this gene structure.\n\n           This method basically merges the promoters returned by transcripts.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects.\n Args    : \n\n\n\nsub promoters {\n    my ($self) = @_;\n    my @transcripts = $self->transcripts();\n    my @feas = ();\n\n    foreach my $tr (@transcripts) {\n\tpush(@feas, $tr->promoters());\n    }\n    return @feas;\n}\n\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $gene->exons();\n           @inital_exons = $gene->exons('Initial');\n Function: Get all exon features or all exons of a specified type of this gene\n           structure.\n\n           Exon type is treated as a case-insensitive regular expression and \n           optional. For consistency, use only the following types: \n           initial, internal, terminal, utr, utr5prime, and utr3prime. \n           A special and virtual type is 'coding', which refers to all types\n           except utr.\n\n           This method basically merges the exons returned by transcripts.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects.\n Args    : An optional string specifying the type of exon.\n\n\n\nsub exons {\n    my ($self, @args) = @_;\n    my @transcripts = $self->transcripts();\n    my @feas = ();\n\n    foreach my $tr (@transcripts) {\n\tpush(@feas, $tr->exons(@args));\n    }\n    return @feas;\n}\n\n=head2 introns\n\n Title   : introns()\n Usage   : @introns = $gene->introns();\n Function: Get all introns of this gene structure.\n\n           Note that this class currently generates these features on-the-fly,\n           that is, it simply treats all regions between exons as introns.\n           It assumes that the exons in the transcripts do not overlap.\n\n           This method basically merges the introns returned by transcripts.\n\n Returns : An array of Bio::SeqFeatureI implementing objects.\n Args    : \n\n\n\nsub introns {\n    my ($self) = @_;\n    my @transcripts = $self->transcripts();\n    my @feas = ();\n\n    foreach my $tr (@transcripts) {\n\tpush(@feas, $tr->introns());\n    }\n    return @feas;\n}\n\n=head2 poly_A_sites\n\n Title   : poly_A_sites()\n Usage   : @polyAsites = $gene->poly_A_sites();\n Function: Get the poly-adenylation sites of this gene structure.\n\n           This method basically merges the poly-adenylation sites returned by\n           transcripts.\n\n Returns : An array of Bio::SeqFeatureI implementing objects.\n Args    : ","label":"poly_A_sites($self)"}},{"line":343,"kind":12,"range":{"end":{"line":352,"character":9999},"start":{"line":343,"character":0}},"signature":{"label":"utrs($self,@args)","documentation":"1;\n# $Id: GeneStructure.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::GeneStructure\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::GeneStructure - A feature representing an arbitrarily complex structure of a gene\n\n=head1 SYNOPSIS\n\n  # See documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing a gene structure. As of now, a gene structure\nreally is only a collection of transcripts. See\nL<Bio::SeqFeature::Gene::TranscriptI> (interface) and\nL<Bio::SeqFeature::Gene::Transcript> (implementation) for the features\nof such objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\n the bugs and their resolution. Bug reports can be submitted via the\n web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::GeneStructure;\nuse vars qw($WeakRefs);\nuse strict;\n\nBEGIN {\n    eval \"use Scalar::Util qw(weaken);\";\n    if ($@) {\n\t$Bio::SeqFeature::Gene::GeneStructure::WeakRefs = 0;  \n    } else { $Bio::SeqFeature::Gene::GeneStructure::WeakRefs = 1; }\n}\n\n\nuse base qw(Bio::SeqFeature::Generic Bio::SeqFeature::Gene::GeneStructureI);\n\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&gene_cleanup);\n    my ($primary) =\n\t$self->_rearrange([qw(PRIMARY\n\t\t\t      )],@args);\n    \n    $primary = 'genestructure' unless $primary;\n    $self->primary_tag($primary);\n    $self->strand(0) if(! defined($self->strand()));\n    return $self;\n}\n\n=head2 transcripts\n\n Title   : transcripts\n Usage   : @transcripts = $gene->transcripts();\n Function: Get the transcripts of this gene structure. Many gene structures\n           will have only one transcript.\n\n Returns : An array of Bio::SeqFeature::Gene::TranscriptI implementing objects.\n Args    : \n\n\n\nsub transcripts {\n    return @{shift->{'_transcripts'} || []};\n}\n\n=head2 add_transcript\n\n Title   : add_transcript()\n Usage   : $gene->add_transcript($transcript);\n Function: Add a transcript to this gene structure.\n Returns : \n Args    : A Bio::SeqFeature::Gene::TranscriptI implementing object.\n\n\n\nsub add_transcript {\n    my ($self, $fea) = @_;\n\n    if(!$fea || ! $fea->isa('Bio::SeqFeature::Gene::TranscriptI') ) {\n\t$self->throw(\"$fea does not implement Bio::SeqFeature::Gene::TranscriptI\");\n    }\n    unless( exists $self->{'_transcripts'}  ) {\n\t$self->{'_transcripts'} = [];\n    }\n    $self->_expand_region($fea);\n    if( $Bio::SeqFeature::Gene::GeneStructure::WeakRefs ) {\n\t$fea->parent(weaken $self);\n    } else {\n\t$fea->parent($self);\n    }\n    push(@{$self->{'_transcripts'}}, $fea);\n}\n\n=head2 flush_transcripts\n\n Title   : flush_transcripts()\n Usage   : $gene->flush_transcripts();\n Function: Remove all transcripts from this gene structure.\n Returns : \n Args    :\n\n\n\nsub flush_transcripts {\n    my ($self) = @_;    \n    if( defined $self->{'_transcripts'} ) {\n\tforeach my $t ( grep {defined} @{$self->{'_transcripts'} || []} ) {\n\t    $t->parent(undef); # remove bkwds pointers\n\t    $t = undef;\n\t}\n\tdelete($self->{'_transcripts'});\t\n    }\n}\n\n=head2 add_transcript_as_features\n\n Title   : add_transcript_as_features\n Usage   : $gene->add_transcript_as_features(@featurelist);\n Function: take a list of Bio::SeqFeatureI objects and turn them into a\n           Bio::SeqFeature::Gene::Transcript object.  Add that transcript to the gene.\n Returns : nothing\n Args    : a list of Bio::SeqFeatureI compliant objects\n\n\n\nsub add_transcript_as_features {\n    my ($self,@features) = @_;\n    my $transcript=Bio::SeqFeature::Gene::Transcript->new;\n    foreach my $fea (@features) {\n\tif ($fea->primary_tag =~ /utr/i) { #UTR / utr/ 3' utr / utr5 etc.\n\t    $transcript->add_utr($fea);\n\t} elsif ($fea->primary_tag =~ /promot/i) { #allow for spelling differences\n\t    $transcript->add_promoter($fea);\n\t} elsif ($fea->primary_tag =~ /poly.*A/i) { #polyA, POLY_A, etc.\n\t    $transcript->poly_A_site($fea);\n\t} else {\t\t#assume the rest are exons\n\t    $transcript->add_exon($fea);\n\t}\n    }\n    $self->add_transcript($transcript);\n}\n\n\n=head2 promoters\n\n Title   : promoters\n Usage   : @prom_sites = $gene->promoters();\n Function: Get the promoter features of this gene structure.\n\n           This method basically merges the promoters returned by transcripts.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects.\n Args    : \n\n\n\nsub promoters {\n    my ($self) = @_;\n    my @transcripts = $self->transcripts();\n    my @feas = ();\n\n    foreach my $tr (@transcripts) {\n\tpush(@feas, $tr->promoters());\n    }\n    return @feas;\n}\n\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $gene->exons();\n           @inital_exons = $gene->exons('Initial');\n Function: Get all exon features or all exons of a specified type of this gene\n           structure.\n\n           Exon type is treated as a case-insensitive regular expression and \n           optional. For consistency, use only the following types: \n           initial, internal, terminal, utr, utr5prime, and utr3prime. \n           A special and virtual type is 'coding', which refers to all types\n           except utr.\n\n           This method basically merges the exons returned by transcripts.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects.\n Args    : An optional string specifying the type of exon.\n\n\n\nsub exons {\n    my ($self, @args) = @_;\n    my @transcripts = $self->transcripts();\n    my @feas = ();\n\n    foreach my $tr (@transcripts) {\n\tpush(@feas, $tr->exons(@args));\n    }\n    return @feas;\n}\n\n=head2 introns\n\n Title   : introns()\n Usage   : @introns = $gene->introns();\n Function: Get all introns of this gene structure.\n\n           Note that this class currently generates these features on-the-fly,\n           that is, it simply treats all regions between exons as introns.\n           It assumes that the exons in the transcripts do not overlap.\n\n           This method basically merges the introns returned by transcripts.\n\n Returns : An array of Bio::SeqFeatureI implementing objects.\n Args    : \n\n\n\nsub introns {\n    my ($self) = @_;\n    my @transcripts = $self->transcripts();\n    my @feas = ();\n\n    foreach my $tr (@transcripts) {\n\tpush(@feas, $tr->introns());\n    }\n    return @feas;\n}\n\n=head2 poly_A_sites\n\n Title   : poly_A_sites()\n Usage   : @polyAsites = $gene->poly_A_sites();\n Function: Get the poly-adenylation sites of this gene structure.\n\n           This method basically merges the poly-adenylation sites returned by\n           transcripts.\n\n Returns : An array of Bio::SeqFeatureI implementing objects.\n Args    : \n\n\n\nsub poly_A_sites {\n    my ($self) = @_;\n    my @transcripts = $self->transcripts();\n    my @feas = ();\n\n    foreach my $tr (@transcripts) {\n\tpush(@feas, $tr->poly_A_site());\n    }\n    return @feas;\n}\n\n=head2 utrs\n\n Title   : utrs()\n Usage   : @utr_sites = $gene->utrs('3prime');\n           @utr_sites = $gene->utrs('5prime');\n           @utr_sites = $gene->utrs();\n Function: Get the features representing untranslated regions (UTR) of this\n           gene structure.\n\n           You may provide an argument specifying the type of UTR. Currently\n           the following types are recognized: 5prime 3prime for UTR on the\n           5' and 3' end of the CDS, respectively.\n\n           This method basically merges the UTRs returned by transcripts.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects\n           representing the UTR regions or sites.\n Args    : Optionally, either 3prime, or 5prime for the the type of UTR\n           feature.","parameters":[{"label":"$self"},{"label":"@args"}]},"children":[{"definition":"my","kind":13,"localvar":"my","containerName":"utrs","name":"$self","line":344},{"containerName":"utrs","kind":13,"name":"@args","line":344},{"definition":"my","containerName":"utrs","localvar":"my","kind":13,"name":"@transcripts","line":345},{"kind":13,"containerName":"utrs","name":"$self","line":345},{"line":345,"name":"transcripts","kind":12,"containerName":"utrs"},{"kind":13,"localvar":"my","containerName":"utrs","name":"@feas","line":346,"definition":"my"},{"definition":"my","line":348,"localvar":"my","containerName":"utrs","kind":13,"name":"$tr"},{"kind":13,"containerName":"utrs","name":"@transcripts","line":348},{"line":349,"kind":13,"containerName":"utrs","name":"@feas"},{"line":349,"name":"$tr","containerName":"utrs","kind":13},{"kind":12,"containerName":"utrs","name":"utrs","line":349},{"line":349,"name":"@args","kind":13,"containerName":"utrs"},{"line":351,"containerName":"utrs","kind":13,"name":"@feas"}],"containerName":"main::","name":"utrs","definition":"sub","detail":"($self,@args)"},{"line":369,"kind":12,"range":{"start":{"line":369,"character":0},"end":{"character":9999,"line":377}},"signature":{"label":"sub_SeqFeature($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: GeneStructure.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::GeneStructure\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::GeneStructure - A feature representing an arbitrarily complex structure of a gene\n\n=head1 SYNOPSIS\n\n  # See documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing a gene structure. As of now, a gene structure\nreally is only a collection of transcripts. See\nL<Bio::SeqFeature::Gene::TranscriptI> (interface) and\nL<Bio::SeqFeature::Gene::Transcript> (implementation) for the features\nof such objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\n the bugs and their resolution. Bug reports can be submitted via the\n web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::GeneStructure;\nuse vars qw($WeakRefs);\nuse strict;\n\nBEGIN {\n    eval \"use Scalar::Util qw(weaken);\";\n    if ($@) {\n\t$Bio::SeqFeature::Gene::GeneStructure::WeakRefs = 0;  \n    } else { $Bio::SeqFeature::Gene::GeneStructure::WeakRefs = 1; }\n}\n\n\nuse base qw(Bio::SeqFeature::Generic Bio::SeqFeature::Gene::GeneStructureI);\n\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&gene_cleanup);\n    my ($primary) =\n\t$self->_rearrange([qw(PRIMARY\n\t\t\t      )],@args);\n    \n    $primary = 'genestructure' unless $primary;\n    $self->primary_tag($primary);\n    $self->strand(0) if(! defined($self->strand()));\n    return $self;\n}\n\n=head2 transcripts\n\n Title   : transcripts\n Usage   : @transcripts = $gene->transcripts();\n Function: Get the transcripts of this gene structure. Many gene structures\n           will have only one transcript.\n\n Returns : An array of Bio::SeqFeature::Gene::TranscriptI implementing objects.\n Args    : \n\n\n\nsub transcripts {\n    return @{shift->{'_transcripts'} || []};\n}\n\n=head2 add_transcript\n\n Title   : add_transcript()\n Usage   : $gene->add_transcript($transcript);\n Function: Add a transcript to this gene structure.\n Returns : \n Args    : A Bio::SeqFeature::Gene::TranscriptI implementing object.\n\n\n\nsub add_transcript {\n    my ($self, $fea) = @_;\n\n    if(!$fea || ! $fea->isa('Bio::SeqFeature::Gene::TranscriptI') ) {\n\t$self->throw(\"$fea does not implement Bio::SeqFeature::Gene::TranscriptI\");\n    }\n    unless( exists $self->{'_transcripts'}  ) {\n\t$self->{'_transcripts'} = [];\n    }\n    $self->_expand_region($fea);\n    if( $Bio::SeqFeature::Gene::GeneStructure::WeakRefs ) {\n\t$fea->parent(weaken $self);\n    } else {\n\t$fea->parent($self);\n    }\n    push(@{$self->{'_transcripts'}}, $fea);\n}\n\n=head2 flush_transcripts\n\n Title   : flush_transcripts()\n Usage   : $gene->flush_transcripts();\n Function: Remove all transcripts from this gene structure.\n Returns : \n Args    :\n\n\n\nsub flush_transcripts {\n    my ($self) = @_;    \n    if( defined $self->{'_transcripts'} ) {\n\tforeach my $t ( grep {defined} @{$self->{'_transcripts'} || []} ) {\n\t    $t->parent(undef); # remove bkwds pointers\n\t    $t = undef;\n\t}\n\tdelete($self->{'_transcripts'});\t\n    }\n}\n\n=head2 add_transcript_as_features\n\n Title   : add_transcript_as_features\n Usage   : $gene->add_transcript_as_features(@featurelist);\n Function: take a list of Bio::SeqFeatureI objects and turn them into a\n           Bio::SeqFeature::Gene::Transcript object.  Add that transcript to the gene.\n Returns : nothing\n Args    : a list of Bio::SeqFeatureI compliant objects\n\n\n\nsub add_transcript_as_features {\n    my ($self,@features) = @_;\n    my $transcript=Bio::SeqFeature::Gene::Transcript->new;\n    foreach my $fea (@features) {\n\tif ($fea->primary_tag =~ /utr/i) { #UTR / utr/ 3' utr / utr5 etc.\n\t    $transcript->add_utr($fea);\n\t} elsif ($fea->primary_tag =~ /promot/i) { #allow for spelling differences\n\t    $transcript->add_promoter($fea);\n\t} elsif ($fea->primary_tag =~ /poly.*A/i) { #polyA, POLY_A, etc.\n\t    $transcript->poly_A_site($fea);\n\t} else {\t\t#assume the rest are exons\n\t    $transcript->add_exon($fea);\n\t}\n    }\n    $self->add_transcript($transcript);\n}\n\n\n=head2 promoters\n\n Title   : promoters\n Usage   : @prom_sites = $gene->promoters();\n Function: Get the promoter features of this gene structure.\n\n           This method basically merges the promoters returned by transcripts.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects.\n Args    : \n\n\n\nsub promoters {\n    my ($self) = @_;\n    my @transcripts = $self->transcripts();\n    my @feas = ();\n\n    foreach my $tr (@transcripts) {\n\tpush(@feas, $tr->promoters());\n    }\n    return @feas;\n}\n\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $gene->exons();\n           @inital_exons = $gene->exons('Initial');\n Function: Get all exon features or all exons of a specified type of this gene\n           structure.\n\n           Exon type is treated as a case-insensitive regular expression and \n           optional. For consistency, use only the following types: \n           initial, internal, terminal, utr, utr5prime, and utr3prime. \n           A special and virtual type is 'coding', which refers to all types\n           except utr.\n\n           This method basically merges the exons returned by transcripts.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects.\n Args    : An optional string specifying the type of exon.\n\n\n\nsub exons {\n    my ($self, @args) = @_;\n    my @transcripts = $self->transcripts();\n    my @feas = ();\n\n    foreach my $tr (@transcripts) {\n\tpush(@feas, $tr->exons(@args));\n    }\n    return @feas;\n}\n\n=head2 introns\n\n Title   : introns()\n Usage   : @introns = $gene->introns();\n Function: Get all introns of this gene structure.\n\n           Note that this class currently generates these features on-the-fly,\n           that is, it simply treats all regions between exons as introns.\n           It assumes that the exons in the transcripts do not overlap.\n\n           This method basically merges the introns returned by transcripts.\n\n Returns : An array of Bio::SeqFeatureI implementing objects.\n Args    : \n\n\n\nsub introns {\n    my ($self) = @_;\n    my @transcripts = $self->transcripts();\n    my @feas = ();\n\n    foreach my $tr (@transcripts) {\n\tpush(@feas, $tr->introns());\n    }\n    return @feas;\n}\n\n=head2 poly_A_sites\n\n Title   : poly_A_sites()\n Usage   : @polyAsites = $gene->poly_A_sites();\n Function: Get the poly-adenylation sites of this gene structure.\n\n           This method basically merges the poly-adenylation sites returned by\n           transcripts.\n\n Returns : An array of Bio::SeqFeatureI implementing objects.\n Args    : \n\n\n\nsub poly_A_sites {\n    my ($self) = @_;\n    my @transcripts = $self->transcripts();\n    my @feas = ();\n\n    foreach my $tr (@transcripts) {\n\tpush(@feas, $tr->poly_A_site());\n    }\n    return @feas;\n}\n\n=head2 utrs\n\n Title   : utrs()\n Usage   : @utr_sites = $gene->utrs('3prime');\n           @utr_sites = $gene->utrs('5prime');\n           @utr_sites = $gene->utrs();\n Function: Get the features representing untranslated regions (UTR) of this\n           gene structure.\n\n           You may provide an argument specifying the type of UTR. Currently\n           the following types are recognized: 5prime 3prime for UTR on the\n           5' and 3' end of the CDS, respectively.\n\n           This method basically merges the UTRs returned by transcripts.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects\n           representing the UTR regions or sites.\n Args    : Optionally, either 3prime, or 5prime for the the type of UTR\n           feature.\n\n\n\nsub utrs {\n    my ($self,@args) = @_;\n    my @transcripts = $self->transcripts();\n    my @feas = ();\n\n    foreach my $tr (@transcripts) {\n\tpush(@feas, $tr->utrs(@args));\n    }\n    return @feas;\n}\n\n=head2 sub_SeqFeature\n\n Title   : sub_SeqFeature\n Usage   : @feats = $gene->sub_SeqFeature();\n Function: Returns an array of all subfeatures.\n\n           This method is defined in Bio::SeqFeatureI. We override this here\n           to include the transcripts.\n\n Returns : An array Bio::SeqFeatureI implementing objects.\n Args    : none"},"children":[{"definition":"my","line":370,"name":"$self","localvar":"my","containerName":"sub_SeqFeature","kind":13},{"containerName":"sub_SeqFeature","localvar":"my","kind":13,"name":"@feas","line":371,"definition":"my"},{"line":374,"kind":13,"containerName":"sub_SeqFeature","name":"@feas"},{"line":374,"name":"$self","kind":13,"containerName":"sub_SeqFeature"},{"kind":13,"containerName":"sub_SeqFeature","name":"@feas","line":375},{"line":375,"containerName":"sub_SeqFeature","kind":13,"name":"$self"},{"containerName":"sub_SeqFeature","kind":12,"name":"transcripts","line":375},{"containerName":"sub_SeqFeature","kind":13,"name":"@feas","line":376}],"name":"sub_SeqFeature","containerName":"main::","definition":"sub","detail":"($self)"},{"name":"SUPER","kind":12,"containerName":"sub_SeqFeature","line":374},{"kind":12,"range":{"end":{"line":407,"character":9999},"start":{"character":0,"line":400}},"line":400,"signature":{"label":"flush_sub_SeqFeature($self,$fea_only)","documentation":"1;\n# $Id: GeneStructure.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::GeneStructure\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::GeneStructure - A feature representing an arbitrarily complex structure of a gene\n\n=head1 SYNOPSIS\n\n  # See documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing a gene structure. As of now, a gene structure\nreally is only a collection of transcripts. See\nL<Bio::SeqFeature::Gene::TranscriptI> (interface) and\nL<Bio::SeqFeature::Gene::Transcript> (implementation) for the features\nof such objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\n the bugs and their resolution. Bug reports can be submitted via the\n web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::GeneStructure;\nuse vars qw($WeakRefs);\nuse strict;\n\nBEGIN {\n    eval \"use Scalar::Util qw(weaken);\";\n    if ($@) {\n\t$Bio::SeqFeature::Gene::GeneStructure::WeakRefs = 0;  \n    } else { $Bio::SeqFeature::Gene::GeneStructure::WeakRefs = 1; }\n}\n\n\nuse base qw(Bio::SeqFeature::Generic Bio::SeqFeature::Gene::GeneStructureI);\n\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&gene_cleanup);\n    my ($primary) =\n\t$self->_rearrange([qw(PRIMARY\n\t\t\t      )],@args);\n    \n    $primary = 'genestructure' unless $primary;\n    $self->primary_tag($primary);\n    $self->strand(0) if(! defined($self->strand()));\n    return $self;\n}\n\n=head2 transcripts\n\n Title   : transcripts\n Usage   : @transcripts = $gene->transcripts();\n Function: Get the transcripts of this gene structure. Many gene structures\n           will have only one transcript.\n\n Returns : An array of Bio::SeqFeature::Gene::TranscriptI implementing objects.\n Args    : \n\n\n\nsub transcripts {\n    return @{shift->{'_transcripts'} || []};\n}\n\n=head2 add_transcript\n\n Title   : add_transcript()\n Usage   : $gene->add_transcript($transcript);\n Function: Add a transcript to this gene structure.\n Returns : \n Args    : A Bio::SeqFeature::Gene::TranscriptI implementing object.\n\n\n\nsub add_transcript {\n    my ($self, $fea) = @_;\n\n    if(!$fea || ! $fea->isa('Bio::SeqFeature::Gene::TranscriptI') ) {\n\t$self->throw(\"$fea does not implement Bio::SeqFeature::Gene::TranscriptI\");\n    }\n    unless( exists $self->{'_transcripts'}  ) {\n\t$self->{'_transcripts'} = [];\n    }\n    $self->_expand_region($fea);\n    if( $Bio::SeqFeature::Gene::GeneStructure::WeakRefs ) {\n\t$fea->parent(weaken $self);\n    } else {\n\t$fea->parent($self);\n    }\n    push(@{$self->{'_transcripts'}}, $fea);\n}\n\n=head2 flush_transcripts\n\n Title   : flush_transcripts()\n Usage   : $gene->flush_transcripts();\n Function: Remove all transcripts from this gene structure.\n Returns : \n Args    :\n\n\n\nsub flush_transcripts {\n    my ($self) = @_;    \n    if( defined $self->{'_transcripts'} ) {\n\tforeach my $t ( grep {defined} @{$self->{'_transcripts'} || []} ) {\n\t    $t->parent(undef); # remove bkwds pointers\n\t    $t = undef;\n\t}\n\tdelete($self->{'_transcripts'});\t\n    }\n}\n\n=head2 add_transcript_as_features\n\n Title   : add_transcript_as_features\n Usage   : $gene->add_transcript_as_features(@featurelist);\n Function: take a list of Bio::SeqFeatureI objects and turn them into a\n           Bio::SeqFeature::Gene::Transcript object.  Add that transcript to the gene.\n Returns : nothing\n Args    : a list of Bio::SeqFeatureI compliant objects\n\n\n\nsub add_transcript_as_features {\n    my ($self,@features) = @_;\n    my $transcript=Bio::SeqFeature::Gene::Transcript->new;\n    foreach my $fea (@features) {\n\tif ($fea->primary_tag =~ /utr/i) { #UTR / utr/ 3' utr / utr5 etc.\n\t    $transcript->add_utr($fea);\n\t} elsif ($fea->primary_tag =~ /promot/i) { #allow for spelling differences\n\t    $transcript->add_promoter($fea);\n\t} elsif ($fea->primary_tag =~ /poly.*A/i) { #polyA, POLY_A, etc.\n\t    $transcript->poly_A_site($fea);\n\t} else {\t\t#assume the rest are exons\n\t    $transcript->add_exon($fea);\n\t}\n    }\n    $self->add_transcript($transcript);\n}\n\n\n=head2 promoters\n\n Title   : promoters\n Usage   : @prom_sites = $gene->promoters();\n Function: Get the promoter features of this gene structure.\n\n           This method basically merges the promoters returned by transcripts.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects.\n Args    : \n\n\n\nsub promoters {\n    my ($self) = @_;\n    my @transcripts = $self->transcripts();\n    my @feas = ();\n\n    foreach my $tr (@transcripts) {\n\tpush(@feas, $tr->promoters());\n    }\n    return @feas;\n}\n\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $gene->exons();\n           @inital_exons = $gene->exons('Initial');\n Function: Get all exon features or all exons of a specified type of this gene\n           structure.\n\n           Exon type is treated as a case-insensitive regular expression and \n           optional. For consistency, use only the following types: \n           initial, internal, terminal, utr, utr5prime, and utr3prime. \n           A special and virtual type is 'coding', which refers to all types\n           except utr.\n\n           This method basically merges the exons returned by transcripts.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects.\n Args    : An optional string specifying the type of exon.\n\n\n\nsub exons {\n    my ($self, @args) = @_;\n    my @transcripts = $self->transcripts();\n    my @feas = ();\n\n    foreach my $tr (@transcripts) {\n\tpush(@feas, $tr->exons(@args));\n    }\n    return @feas;\n}\n\n=head2 introns\n\n Title   : introns()\n Usage   : @introns = $gene->introns();\n Function: Get all introns of this gene structure.\n\n           Note that this class currently generates these features on-the-fly,\n           that is, it simply treats all regions between exons as introns.\n           It assumes that the exons in the transcripts do not overlap.\n\n           This method basically merges the introns returned by transcripts.\n\n Returns : An array of Bio::SeqFeatureI implementing objects.\n Args    : \n\n\n\nsub introns {\n    my ($self) = @_;\n    my @transcripts = $self->transcripts();\n    my @feas = ();\n\n    foreach my $tr (@transcripts) {\n\tpush(@feas, $tr->introns());\n    }\n    return @feas;\n}\n\n=head2 poly_A_sites\n\n Title   : poly_A_sites()\n Usage   : @polyAsites = $gene->poly_A_sites();\n Function: Get the poly-adenylation sites of this gene structure.\n\n           This method basically merges the poly-adenylation sites returned by\n           transcripts.\n\n Returns : An array of Bio::SeqFeatureI implementing objects.\n Args    : \n\n\n\nsub poly_A_sites {\n    my ($self) = @_;\n    my @transcripts = $self->transcripts();\n    my @feas = ();\n\n    foreach my $tr (@transcripts) {\n\tpush(@feas, $tr->poly_A_site());\n    }\n    return @feas;\n}\n\n=head2 utrs\n\n Title   : utrs()\n Usage   : @utr_sites = $gene->utrs('3prime');\n           @utr_sites = $gene->utrs('5prime');\n           @utr_sites = $gene->utrs();\n Function: Get the features representing untranslated regions (UTR) of this\n           gene structure.\n\n           You may provide an argument specifying the type of UTR. Currently\n           the following types are recognized: 5prime 3prime for UTR on the\n           5' and 3' end of the CDS, respectively.\n\n           This method basically merges the UTRs returned by transcripts.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects\n           representing the UTR regions or sites.\n Args    : Optionally, either 3prime, or 5prime for the the type of UTR\n           feature.\n\n\n\nsub utrs {\n    my ($self,@args) = @_;\n    my @transcripts = $self->transcripts();\n    my @feas = ();\n\n    foreach my $tr (@transcripts) {\n\tpush(@feas, $tr->utrs(@args));\n    }\n    return @feas;\n}\n\n=head2 sub_SeqFeature\n\n Title   : sub_SeqFeature\n Usage   : @feats = $gene->sub_SeqFeature();\n Function: Returns an array of all subfeatures.\n\n           This method is defined in Bio::SeqFeatureI. We override this here\n           to include the transcripts.\n\n Returns : An array Bio::SeqFeatureI implementing objects.\n Args    : none\n\n\n\nsub sub_SeqFeature {\n    my ($self) = @_;   \n    my @feas = ();\n\n    # get what the parent already has\n    @feas = $self->SUPER::sub_SeqFeature();\n    push(@feas, $self->transcripts());\n    return @feas;\n}\n\n=head2 flush_sub_SeqFeature\n\n Title   : flush_sub_SeqFeature\n Usage   : $gene->flush_sub_SeqFeature();\n           $gene->flush_sub_SeqFeature(1);\n Function: Removes all subfeatures.\n\n           This method is overridden from Bio::SeqFeature::Generic to flush\n           all additional subfeatures, i.e., transcripts, which is\n           almost certainly not what you want. To remove only features added\n           through $gene->add_sub_SeqFeature($feature) pass any\n           argument evaluating to TRUE.\n\n Example :\n Returns : none\n Args    : Optionally, an argument evaluating to TRUE will suppress flushing\n           of all gene structure-specific subfeatures (transcripts).","parameters":[{"label":"$self"},{"label":"$fea_only"}]},"containerName":"main::","name":"flush_sub_SeqFeature","children":[{"definition":"my","containerName":"flush_sub_SeqFeature","localvar":"my","kind":13,"name":"$self","line":401},{"name":"$fea_only","kind":13,"containerName":"flush_sub_SeqFeature","line":401},{"line":403,"name":"$self","kind":13,"containerName":"flush_sub_SeqFeature"},{"line":404,"name":"$fea_only","kind":13,"containerName":"flush_sub_SeqFeature"},{"line":405,"containerName":"flush_sub_SeqFeature","kind":13,"name":"$self"},{"containerName":"flush_sub_SeqFeature","kind":12,"name":"flush_transcripts","line":405}],"detail":"($self,$fea_only)","definition":"sub"},{"name":"SUPER","containerName":"flush_sub_SeqFeature","kind":12,"line":403},{"line":409,"range":{"start":{"character":0,"line":409},"end":{"character":9999,"line":412}},"kind":12,"children":[{"name":"$self","containerName":"gene_cleanup","localvar":"my","kind":13,"line":410,"definition":"my"},{"name":"$self","containerName":"gene_cleanup","kind":13,"line":411},{"line":411,"kind":12,"containerName":"gene_cleanup","name":"flush_transcripts"}],"name":"gene_cleanup","containerName":"main::","definition":"sub"}]}