{"vars":[{"containerName":"","kind":2,"name":"base","line":101},{"definition":"our","line":106,"name":"%tagclass","kind":13,"containerName":"main::"},{"kind":12,"name":"comment","line":107},{"name":"dblink","kind":12,"line":108},{"name":"description","kind":12,"line":109},{"name":"gene_name","kind":12,"line":110},{"kind":12,"name":"ontology_term","line":111},{"name":"reference","kind":12,"line":112},{"line":113,"kind":12,"name":"__DEFAULT__"},{"containerName":"main::","kind":13,"name":"%tag2text","line":116,"definition":"our"},{"kind":12,"name":"__DEFAULT__","line":123},{"signature":{"label":"new($caller,@args)","documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq","parameters":[{"label":"$caller"},{"label":"@args"}]},"line":218,"kind":12,"range":{"end":{"line":225,"character":9999},"start":{"line":218,"character":0}},"definition":"sub","detail":"($caller,@args)","children":[{"definition":"my","line":219,"kind":13,"localvar":"my","containerName":"new","name":"$caller"},{"line":219,"containerName":"new","kind":13,"name":"@args"},{"containerName":"new","localvar":"my","kind":13,"name":"$self","line":220,"definition":"my"},{"containerName":"new","kind":13,"name":"$caller","line":220},{"containerName":"new","kind":13,"name":"@args","line":220},{"line":222,"containerName":"new","kind":13,"name":"$self"},{"containerName":"new","kind":12,"name":"_initialize","line":222},{"name":"@args","containerName":"new","kind":13,"line":222},{"name":"$self","kind":13,"containerName":"new","line":224}],"containerName":"main::","name":"new"},{"line":220,"containerName":"new","kind":12,"name":"SUPER"},{"range":{"start":{"character":0,"line":227},"end":{"character":9999,"line":266}},"kind":12,"line":227,"signature":{"label":"_initialize($self,@args)","documentation":"","parameters":[{"label":"$self"},{"label":"@args"}]},"containerName":"main::","name":"_initialize","children":[{"kind":13,"localvar":"my","containerName":"_initialize","name":"$self","line":228,"definition":"my"},{"line":228,"kind":13,"containerName":"_initialize","name":"@args"},{"containerName":"_initialize","localvar":"my","kind":13,"name":"$start","line":229,"definition":"my"},{"kind":13,"containerName":"_initialize","name":"$end","line":229},{"name":"$strand","containerName":"_initialize","kind":13,"line":229},{"name":"$frame","containerName":"_initialize","kind":13,"line":229},{"line":229,"containerName":"_initialize","kind":13,"name":"$phase"},{"line":229,"name":"$score","containerName":"_initialize","kind":13},{"name":"$name","kind":13,"containerName":"_initialize","line":230},{"line":230,"kind":13,"containerName":"_initialize","name":"$annot"},{"line":230,"kind":13,"containerName":"_initialize","name":"$location"},{"line":231,"name":"$display_name","containerName":"_initialize","kind":13},{"line":232,"name":"$seq_id","containerName":"_initialize","kind":13},{"line":232,"kind":13,"containerName":"_initialize","name":"$type"},{"name":"$source","kind":13,"containerName":"_initialize","line":232},{"name":"$feature","containerName":"_initialize","kind":13,"line":233},{"line":234,"name":"$self","kind":13,"containerName":"_initialize"},{"kind":12,"containerName":"_initialize","name":"_rearrange","line":234},{"line":248,"containerName":"_initialize","kind":13,"name":"@args"},{"name":"$start","kind":13,"containerName":"_initialize","line":249},{"line":249,"containerName":"_initialize","kind":13,"name":"$self"},{"containerName":"_initialize","kind":12,"name":"start","line":249},{"line":249,"kind":13,"containerName":"_initialize","name":"$start"},{"line":250,"name":"$end","kind":13,"containerName":"_initialize"},{"line":250,"name":"$self","kind":13,"containerName":"_initialize"},{"line":250,"name":"end","containerName":"_initialize","kind":12},{"line":250,"name":"$end","kind":13,"containerName":"_initialize"},{"name":"$strand","kind":13,"containerName":"_initialize","line":251},{"containerName":"_initialize","kind":13,"name":"$self","line":251},{"line":251,"kind":12,"containerName":"_initialize","name":"strand"},{"line":251,"kind":13,"containerName":"_initialize","name":"$strand"},{"containerName":"_initialize","kind":13,"name":"$frame","line":252},{"line":252,"name":"$self","kind":13,"containerName":"_initialize"},{"name":"frame","containerName":"_initialize","kind":12,"line":252},{"name":"$frame","containerName":"_initialize","kind":13,"line":252},{"kind":13,"containerName":"_initialize","name":"$phase","line":253},{"name":"$self","kind":13,"containerName":"_initialize","line":253},{"containerName":"_initialize","kind":12,"name":"phase","line":253},{"name":"$phase","containerName":"_initialize","kind":13,"line":253},{"name":"$score","containerName":"_initialize","kind":13,"line":254},{"line":254,"name":"$self","containerName":"_initialize","kind":13},{"line":254,"containerName":"_initialize","kind":12,"name":"score"},{"line":254,"kind":13,"containerName":"_initialize","name":"$score"},{"kind":13,"containerName":"_initialize","name":"$source","line":255},{"line":255,"name":"$source","containerName":"_initialize","kind":13},{"line":255,"name":"$self","containerName":"_initialize","kind":13},{"line":255,"kind":12,"containerName":"_initialize","name":"source"},{"line":255,"name":"$source","kind":13,"containerName":"_initialize"},{"line":255,"containerName":"_initialize","kind":13,"name":"$self"},{"containerName":"_initialize","kind":12,"name":"source_tag","line":255},{"line":255,"kind":13,"containerName":"_initialize","name":"$source"},{"line":256,"name":"$type","kind":13,"containerName":"_initialize"},{"line":256,"name":"$type","containerName":"_initialize","kind":13},{"name":"$self","containerName":"_initialize","kind":13,"line":256},{"name":"type","kind":12,"containerName":"_initialize","line":256},{"name":"$type","kind":13,"containerName":"_initialize","line":256},{"line":256,"name":"$self","kind":13,"containerName":"_initialize"},{"line":256,"name":"primary_tag","containerName":"_initialize","kind":12},{"name":"$type","kind":13,"containerName":"_initialize","line":256},{"line":257,"kind":13,"containerName":"_initialize","name":"$location"},{"kind":13,"containerName":"_initialize","name":"$self","line":257},{"line":257,"kind":12,"containerName":"_initialize","name":"location"},{"name":"$location","kind":13,"containerName":"_initialize","line":257},{"name":"$annot","kind":13,"containerName":"_initialize","line":258},{"name":"$self","kind":13,"containerName":"_initialize","line":258},{"containerName":"_initialize","kind":12,"name":"annotation","line":258},{"name":"$annot","kind":13,"containerName":"_initialize","line":258},{"line":259,"name":"$feature","kind":13,"containerName":"_initialize"},{"line":259,"containerName":"_initialize","kind":13,"name":"$self"},{"name":"from_feature","containerName":"_initialize","kind":12,"line":259},{"line":259,"containerName":"_initialize","kind":13,"name":"$feature"},{"containerName":"_initialize","kind":13,"name":"$display_name","line":261},{"kind":13,"containerName":"_initialize","name":"$name","line":261},{"name":"$self","kind":13,"containerName":"_initialize","line":262},{"kind":12,"containerName":"_initialize","name":"throw","line":262},{"containerName":"_initialize","kind":13,"name":"$seq_id","line":264},{"line":264,"containerName":"_initialize","kind":13,"name":"$self"},{"name":"seq_id","kind":12,"containerName":"_initialize","line":264},{"line":264,"kind":13,"containerName":"_initialize","name":"$seq_id"},{"name":"$name","containerName":"_initialize","kind":13,"line":265},{"kind":13,"containerName":"_initialize","name":"$display_name","line":265},{"line":265,"kind":13,"containerName":"_initialize","name":"$self"},{"name":"name","containerName":"_initialize","kind":12,"line":265},{"line":265,"name":"$name","kind":13,"containerName":"_initialize"},{"containerName":"_initialize","kind":13,"name":"$display_name","line":265}],"detail":"($self,@args)","definition":"sub"},{"line":285,"range":{"start":{"line":285,"character":0},"end":{"character":9999,"line":315}},"kind":12,"signature":{"label":"from_feature($self,$feat,%opts)","documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:","parameters":[{"label":"$self"},{"label":"$feat"},{"label":"%opts"}]},"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"from_feature","line":286,"definition":"my"},{"line":286,"containerName":"from_feature","kind":13,"name":"$feat"},{"line":286,"kind":13,"containerName":"from_feature","name":"%opts"},{"line":290,"name":"$feat","containerName":"from_feature","kind":13},{"name":"$feat","kind":13,"containerName":"from_feature","line":290},{"name":"isa","containerName":"from_feature","kind":12,"line":290},{"line":291,"name":"$self","containerName":"from_feature","kind":13},{"name":"throw","kind":12,"containerName":"from_feature","line":291},{"definition":"my","line":297,"localvar":"my","kind":13,"containerName":"from_feature","name":"$fieldname"},{"line":299,"containerName":"from_feature","kind":13,"name":"$self"},{"containerName":"from_feature","kind":13,"name":"$fieldname","line":299},{"line":299,"name":"$feat","containerName":"from_feature","kind":13},{"line":299,"name":"$fieldname","containerName":"from_feature","kind":13},{"definition":"my","kind":13,"localvar":"my","containerName":"from_feature","name":"%no_copy","line":305},{"line":306,"name":"$adaptor","localvar":"my","containerName":"from_feature","kind":13,"definition":"my"},{"kind":12,"containerName":"from_feature","name":"new","line":306},{"line":306,"containerName":"from_feature","kind":13,"name":"$feat"},{"definition":"my","line":307,"containerName":"from_feature","localvar":"my","kind":13,"name":"$key"},{"name":"$adaptor","kind":13,"containerName":"from_feature","line":307},{"line":307,"containerName":"from_feature","kind":12,"name":"get_all_annotation_keys"},{"line":308,"containerName":"from_feature","kind":13,"name":"$no_copy"},{"line":308,"name":"$key","kind":13,"containerName":"from_feature"},{"definition":"my","line":309,"kind":13,"localvar":"my","containerName":"from_feature","name":"@values"},{"name":"$adaptor","kind":13,"containerName":"from_feature","line":309},{"line":309,"containerName":"from_feature","kind":12,"name":"get_Annotations"},{"line":309,"name":"$key","containerName":"from_feature","kind":13},{"kind":13,"containerName":"from_feature","name":"@values","line":310},{"containerName":"from_feature","kind":13,"name":"%opts","line":310},{"line":310,"name":"$key","kind":13,"containerName":"from_feature"},{"kind":13,"containerName":"from_feature","name":"@values","line":310},{"definition":"my","line":311,"containerName":"from_feature","localvar":"my","kind":13,"name":"$val"},{"kind":13,"containerName":"from_feature","name":"@values","line":311},{"line":312,"name":"$self","kind":13,"containerName":"from_feature"},{"line":312,"name":"add_Annotation","containerName":"from_feature","kind":12},{"name":"$key","kind":13,"containerName":"from_feature","line":312},{"name":"$val","kind":13,"containerName":"from_feature","line":312}],"name":"from_feature","containerName":"main::","definition":"sub","detail":"($self,$feat,%opts)"},{"kind":12,"containerName":"SeqFeature::AnnotationAdaptor","name":"Bio","line":306},{"name":"_aggregate_scalar_annotations","kind":12,"line":310},{"signature":{"label":"_aggregate_scalar_annotations($opts,$key,@values)","parameters":[{"label":"$opts"},{"label":"$key"},{"label":"@values"}],"documentation":"given a key and its values, make the values into\nBio::Annotation::\\w+ objects"},"range":{"start":{"character":0,"line":319},"end":{"character":9999,"line":369}},"kind":12,"line":319,"detail":"($opts,$key,@values)","definition":"sub","containerName":"main::","name":"_aggregate_scalar_annotations","children":[{"localvar":"my","kind":13,"containerName":"_aggregate_scalar_annotations","name":"$opts","line":320,"definition":"my"},{"line":320,"name":"$key","kind":13,"containerName":"_aggregate_scalar_annotations"},{"name":"@values","kind":13,"containerName":"_aggregate_scalar_annotations","line":320},{"line":323,"name":"@values","kind":13,"containerName":"_aggregate_scalar_annotations"},{"kind":12,"containerName":"_aggregate_scalar_annotations","name":"new","line":323},{"kind":13,"containerName":"_aggregate_scalar_annotations","name":"@values","line":323},{"containerName":"_aggregate_scalar_annotations","kind":13,"name":"$key","line":326},{"name":"@values","kind":13,"containerName":"_aggregate_scalar_annotations","line":326},{"line":326,"name":"@values","containerName":"_aggregate_scalar_annotations","kind":13},{"line":327,"containerName":"_aggregate_scalar_annotations","kind":13,"name":"@values"},{"name":"isa","kind":12,"containerName":"_aggregate_scalar_annotations","line":327},{"line":328,"containerName":"_aggregate_scalar_annotations","kind":13,"name":"@values"},{"kind":13,"containerName":"_aggregate_scalar_annotations","name":"@values","line":329},{"line":329,"name":"value","kind":12,"containerName":"_aggregate_scalar_annotations"},{"line":329,"kind":13,"containerName":"_aggregate_scalar_annotations","name":"@values"},{"line":331,"kind":13,"containerName":"_aggregate_scalar_annotations","name":"@values"},{"line":332,"name":"$values","containerName":"_aggregate_scalar_annotations","kind":13},{"name":"$values","kind":13,"containerName":"_aggregate_scalar_annotations","line":332},{"containerName":"_aggregate_scalar_annotations","kind":13,"name":"$values","line":333},{"containerName":"_aggregate_scalar_annotations","kind":13,"name":"@values","line":335},{"kind":13,"containerName":"_aggregate_scalar_annotations","name":"@values","line":335},{"kind":13,"containerName":"_aggregate_scalar_annotations","name":"$values","line":336},{"line":339,"name":"new","containerName":"_aggregate_scalar_annotations","kind":12},{"name":"$values","containerName":"_aggregate_scalar_annotations","kind":13,"line":339},{"line":340,"name":"$values","containerName":"_aggregate_scalar_annotations","kind":13},{"containerName":"_aggregate_scalar_annotations","kind":13,"name":"$values","line":341},{"name":"$values","kind":13,"containerName":"_aggregate_scalar_annotations","line":342},{"line":347,"name":"$key","kind":13,"containerName":"_aggregate_scalar_annotations"},{"containerName":"_aggregate_scalar_annotations","kind":13,"name":"$key","line":347},{"definition":"my","line":350,"name":"$db","localvar":"my","kind":13,"containerName":"_aggregate_scalar_annotations"},{"containerName":"_aggregate_scalar_annotations","kind":13,"name":"$id","line":350},{"line":350,"kind":12,"containerName":"_aggregate_scalar_annotations","name":"value"},{"containerName":"_aggregate_scalar_annotations","kind":12,"name":"new","line":351},{"line":351,"name":"$db","containerName":"_aggregate_scalar_annotations","kind":13},{"name":"$id","containerName":"_aggregate_scalar_annotations","kind":13,"line":352},{"containerName":"_aggregate_scalar_annotations","kind":13,"name":"@values","line":357},{"kind":13,"containerName":"_aggregate_scalar_annotations","name":"$key","line":360},{"line":361,"name":"new","kind":12,"containerName":"_aggregate_scalar_annotations"},{"line":361,"name":"value","kind":12,"containerName":"_aggregate_scalar_annotations"},{"line":362,"containerName":"_aggregate_scalar_annotations","kind":13,"name":"@values"},{"line":364,"name":"$key","kind":13,"containerName":"_aggregate_scalar_annotations"},{"name":"new","kind":12,"containerName":"_aggregate_scalar_annotations","line":365},{"line":365,"name":"value","containerName":"_aggregate_scalar_annotations","kind":12},{"line":365,"name":"@values","containerName":"_aggregate_scalar_annotations","kind":13},{"line":368,"containerName":"_aggregate_scalar_annotations","kind":13,"name":"@values"}]},{"name":"Bio","containerName":"Annotation::SimpleValue","kind":12,"line":323},{"line":339,"name":"Bio","containerName":"Annotation::Target","kind":12},{"line":351,"name":"Bio","containerName":"Annotation::DBLink","kind":12},{"line":361,"name":"Bio","containerName":"Annotation::OntologyTerm","kind":12},{"line":365,"name":"Bio","kind":12,"containerName":"Annotation::Comment"},{"kind":12,"range":{"start":{"character":0,"line":383},"end":{"character":9999,"line":402}},"line":383,"signature":{"parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.","label":"seq_id($self,$val)"},"containerName":"main::","name":"seq_id","children":[{"line":384,"name":"$self","kind":13,"localvar":"my","containerName":"seq_id","definition":"my"},{"line":384,"containerName":"seq_id","kind":13,"name":"$val"},{"kind":13,"containerName":"seq_id","name":"$val","line":385},{"definition":"my","line":386,"name":"$term","localvar":"my","containerName":"seq_id","kind":13},{"name":"$val","containerName":"seq_id","kind":13,"line":387},{"line":388,"containerName":"seq_id","kind":13,"name":"$term"},{"containerName":"seq_id","kind":12,"name":"new","line":388},{"name":"$val","kind":13,"containerName":"seq_id","line":388},{"line":389,"name":"$val","containerName":"seq_id","kind":13},{"name":"$val","kind":13,"containerName":"seq_id","line":389},{"line":389,"kind":12,"containerName":"seq_id","name":"isa"},{"containerName":"seq_id","kind":13,"name":"$term","line":390},{"name":"$val","kind":13,"containerName":"seq_id","line":390},{"name":"$term","containerName":"seq_id","kind":13,"line":392},{"containerName":"seq_id","kind":13,"name":"$term","line":392},{"line":392,"kind":12,"containerName":"seq_id","name":"value"},{"line":393,"name":"$self","containerName":"seq_id","kind":13},{"line":393,"name":"throw","kind":12,"containerName":"seq_id"},{"name":"$val","kind":13,"containerName":"seq_id","line":393},{"kind":13,"containerName":"seq_id","name":"$self","line":395},{"line":395,"name":"remove_Annotations","kind":12,"containerName":"seq_id"},{"containerName":"seq_id","kind":13,"name":"$self","line":396},{"name":"add_Annotation","kind":12,"containerName":"seq_id","line":396},{"line":396,"containerName":"seq_id","kind":13,"name":"$term"},{"containerName":"seq_id","kind":13,"name":"$self","line":399},{"kind":12,"containerName":"seq_id","name":"seq_id","line":399},{"name":"$self","kind":13,"containerName":"seq_id","line":399},{"line":399,"containerName":"seq_id","kind":12,"name":"get_Annotations"},{"line":401,"containerName":"seq_id","kind":13,"name":"$self"},{"line":401,"containerName":"seq_id","kind":12,"name":"get_Annotations"},{"line":401,"kind":12,"containerName":"seq_id","name":"value"}],"detail":"($self,$val)","definition":"sub"},{"line":388,"name":"Bio","kind":12,"containerName":"Annotation::SimpleValue"},{"kind":12,"name":"uri_unescape","line":388},{"definition":"sub","detail":"($self,$val)","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"name","line":414,"definition":"my"},{"line":414,"kind":13,"containerName":"name","name":"$val"},{"line":415,"name":"$self","containerName":"name","kind":13},{"name":"$val","containerName":"name","kind":13,"line":415},{"line":415,"containerName":"name","kind":13,"name":"$val"},{"line":416,"name":"$self","kind":13,"containerName":"name"}],"name":"name","containerName":"main::","signature":{"label":"name($self,$val)","documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.\n\n\nsub seq_id {\n  my($self,$val) = @_;\n  if (defined($val)) {\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value =~ /^>/)) {\n\t  $self->throw('give seq_id() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('seq_id');\n      $self->add_Annotation('seq_id', $term);\n  }\n\n  $self->seq_id('.') unless $self->get_Annotations('seq_id'); # make sure we always have something\n\n  return ($self->get_Annotations('seq_id'))[0]->value;\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: human-readable name for the feature.\n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)","parameters":[{"label":"$self"},{"label":"$val"}]},"line":413,"range":{"end":{"character":9999,"line":417},"start":{"line":413,"character":0}},"kind":12},{"definition":1,"line":430,"kind":14,"containerName":"main::","name":"MAX_TYPE_CACHE_MEMBERS"},{"children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"type","line":432},{"line":432,"name":"$val","kind":13,"containerName":"type"},{"line":433,"containerName":"type","kind":13,"name":"$val"},{"line":434,"kind":13,"localvar":"my","containerName":"type","name":"$term","definition":"my"},{"line":436,"containerName":"type","kind":13,"name":"$val"},{"containerName":"type","kind":13,"name":"$self","line":437},{"line":437,"name":"throw","kind":12,"containerName":"type"},{"line":439,"kind":13,"containerName":"type","name":"$val"},{"line":439,"containerName":"type","kind":13,"name":"$val"},{"containerName":"type","kind":12,"name":"isa","line":439},{"line":440,"containerName":"type","kind":13,"name":"$term"},{"line":440,"name":"$val","kind":13,"containerName":"type"},{"line":444,"name":"$self","containerName":"type","kind":13},{"line":444,"name":"throw","containerName":"type","kind":12},{"containerName":"type","kind":13,"name":"$val","line":444},{"name":"$self","kind":13,"containerName":"type","line":446},{"line":446,"name":"remove_Annotations","containerName":"type","kind":12},{"kind":13,"containerName":"type","name":"$self","line":447},{"kind":12,"containerName":"type","name":"add_Annotation","line":447},{"name":"$term","containerName":"type","kind":13,"line":447},{"line":450,"name":"$self","containerName":"type","kind":13},{"kind":12,"containerName":"type","name":"get_Annotations","line":450}],"containerName":"main::","name":"type","definition":"sub","detail":"($self,$val)","line":431,"range":{"start":{"character":0,"line":431},"end":{"character":9999,"line":451}},"kind":12,"signature":{"label":"type($self,$val)","documentation":"","parameters":[{"label":"$self"},{"label":"$val"}]}},{"line":464,"range":{"end":{"line":485,"character":9999},"start":{"line":464,"character":0}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.\n\n\nsub seq_id {\n  my($self,$val) = @_;\n  if (defined($val)) {\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value =~ /^>/)) {\n\t  $self->throw('give seq_id() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('seq_id');\n      $self->add_Annotation('seq_id', $term);\n  }\n\n  $self->seq_id('.') unless $self->get_Annotations('seq_id'); # make sure we always have something\n\n  return ($self->get_Annotations('seq_id'))[0]->value;\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: human-readable name for the feature.\n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 type()\n\n Usage   : $obj->type($newval)\n Function: a SOFA type for the feature.\n Returns : Bio::Annotation::OntologyTerm object representing the type.\n           NB: to get a string, use primary_tag().\n Args    : on set, Bio::Annotation::OntologyTerm object.\n           NB: to set a string (SOFA name or identifier), use primary_tag()\n\n\nuse constant MAX_TYPE_CACHE_MEMBERS => 20;\nsub type {\n  my($self,$val) = @_;\n  if(defined($val)){\n    my $term = undef;\n\n    if(!ref($val)){\n      $self->throw(\"give type() a Bio::Annotation::OntologyTerm object, not a string\");\n    }\n    elsif(ref($val) && $val->isa('Bio::Annotation::OntologyTerm')){\n      $term = $val;\n    }\n    else {\n      #we have the wrong type of object\n      $self->throw('give type() a SOFA term name, identifier, or Bio::Annotation::OntologyTerm object, not '.$val);\n    }\n    $self->remove_Annotations('type');\n    $self->add_Annotation('type',$term);\n  }\n  \n  return $self->get_Annotations('type');\n}\n\n=head2 source()\n\n Usage   : $obj->source($newval)\n Function: holds the source of the feature.\n Returns : a Bio::Annotation::SimpleValue representing the source.\n           NB: to get a string, use source_tag()\n Args    : on set, a Bio::Annotation::SimpleValue object.\n           NB: to set a string, use source_tag()","label":"source($self,$val)"},"children":[{"line":465,"kind":13,"localvar":"my","containerName":"source","name":"$self","definition":"my"},{"line":465,"name":"$val","containerName":"source","kind":13},{"line":467,"kind":13,"containerName":"source","name":"$val"},{"kind":13,"localvar":"my","containerName":"source","name":"$term","line":468,"definition":"my"},{"line":469,"containerName":"source","kind":13,"name":"$val"},{"name":"$self","kind":13,"containerName":"source","line":470},{"line":470,"containerName":"source","kind":12,"name":"throw"},{"line":472,"name":"$val","containerName":"source","kind":13},{"line":472,"name":"$val","kind":13,"containerName":"source"},{"containerName":"source","kind":12,"name":"isa","line":472},{"line":473,"kind":13,"containerName":"source","name":"$term"},{"line":473,"kind":13,"containerName":"source","name":"$val"},{"line":475,"containerName":"source","kind":13,"name":"$self"},{"line":475,"kind":12,"containerName":"source","name":"throw"},{"name":"$val","containerName":"source","kind":13,"line":475},{"name":"$self","kind":13,"containerName":"source","line":477},{"containerName":"source","kind":12,"name":"remove_Annotations","line":477},{"name":"$self","containerName":"source","kind":13,"line":478},{"line":478,"containerName":"source","kind":12,"name":"add_Annotation"},{"line":478,"name":"$term","containerName":"source","kind":13},{"line":481,"kind":13,"containerName":"source","name":"$self"},{"line":481,"name":"get_Annotations","containerName":"source","kind":12},{"kind":13,"containerName":"source","name":"$self","line":482},{"kind":12,"containerName":"source","name":"source","line":482},{"name":"new","kind":12,"containerName":"source","line":482},{"name":"$self","containerName":"source","kind":13,"line":484},{"line":484,"containerName":"source","kind":12,"name":"get_Annotations"}],"name":"source","containerName":"main::","definition":"sub","detail":"($self,$val)"},{"kind":12,"containerName":"Annotation::SimpleValue","name":"Bio","line":482},{"definition":"sub","children":[{"line":498,"localvar":"my","containerName":"score","kind":13,"name":"$self","definition":"my"},{"line":499,"localvar":"my","containerName":"score","kind":13,"name":"$val","definition":"my"},{"line":501,"containerName":"score","kind":13,"name":"$val"},{"name":"$term","kind":13,"localvar":"my","containerName":"score","line":502,"definition":"my"},{"line":503,"kind":13,"containerName":"score","name":"$val"},{"name":"$term","kind":13,"containerName":"score","line":504},{"kind":12,"containerName":"score","name":"new","line":504},{"line":504,"containerName":"score","kind":13,"name":"$val"},{"name":"$val","kind":13,"containerName":"score","line":505},{"line":505,"kind":13,"containerName":"score","name":"$val"},{"line":505,"kind":12,"containerName":"score","name":"isa"},{"line":506,"name":"$term","containerName":"score","kind":13},{"name":"$val","kind":13,"containerName":"score","line":506},{"line":509,"name":"$term","kind":13,"containerName":"score"},{"kind":12,"containerName":"score","name":"value","line":509},{"name":"$term","containerName":"score","kind":13,"line":510},{"line":510,"kind":13,"containerName":"score","name":"$term"},{"line":510,"name":"value","kind":12,"containerName":"score"},{"name":"$self","kind":13,"containerName":"score","line":511},{"name":"throw","containerName":"score","kind":12,"line":511},{"containerName":"score","kind":13,"name":"$self","line":513},{"kind":12,"containerName":"score","name":"remove_Annotations","line":513},{"kind":13,"containerName":"score","name":"$self","line":514},{"name":"add_Annotation","kind":12,"containerName":"score","line":514},{"line":514,"name":"$term","containerName":"score","kind":13},{"name":"$self","kind":13,"containerName":"score","line":517},{"containerName":"score","kind":12,"name":"score","line":517},{"line":517,"name":"$self","containerName":"score","kind":13},{"line":517,"name":"get_Annotations","kind":12,"containerName":"score"},{"line":519,"kind":13,"containerName":"score","name":"$self"},{"name":"get_Annotations","containerName":"score","kind":12,"line":519},{"line":519,"kind":12,"containerName":"score","name":"display_text"}],"containerName":"main::","name":"score","line":497,"kind":12,"range":{"start":{"line":497,"character":0},"end":{"character":9999,"line":520}}},{"line":504,"kind":12,"containerName":"Annotation::SimpleValue","name":"Bio"},{"line":533,"kind":12,"range":{"start":{"character":0,"line":533},"end":{"character":9999,"line":554}},"children":[{"definition":"my","containerName":"phase","localvar":"my","kind":13,"name":"$self","line":534},{"definition":"my","containerName":"phase","localvar":"my","kind":13,"name":"$val","line":535},{"kind":13,"containerName":"phase","name":"$val","line":537},{"name":"$term","containerName":"phase","localvar":"my","kind":13,"line":538,"definition":"my"},{"containerName":"phase","kind":13,"name":"$val","line":539},{"name":"$term","kind":13,"containerName":"phase","line":540},{"line":540,"containerName":"phase","kind":12,"name":"new"},{"containerName":"phase","kind":13,"name":"$val","line":540},{"containerName":"phase","kind":13,"name":"$val","line":541},{"line":541,"kind":13,"containerName":"phase","name":"$val"},{"containerName":"phase","kind":12,"name":"isa","line":541},{"kind":13,"containerName":"phase","name":"$term","line":542},{"line":542,"name":"$val","kind":13,"containerName":"phase"},{"line":544,"kind":13,"containerName":"phase","name":"$term"},{"name":"$term","kind":13,"containerName":"phase","line":544},{"line":544,"containerName":"phase","kind":12,"name":"value"},{"line":545,"name":"$self","containerName":"phase","kind":13},{"containerName":"phase","kind":12,"name":"throw","line":545},{"kind":13,"containerName":"phase","name":"$self","line":547},{"containerName":"phase","kind":12,"name":"remove_Annotations","line":547},{"name":"$self","containerName":"phase","kind":13,"line":548},{"name":"add_Annotation","containerName":"phase","kind":12,"line":548},{"line":548,"containerName":"phase","kind":13,"name":"$term"},{"name":"$self","kind":13,"containerName":"phase","line":551},{"name":"phase","kind":12,"containerName":"phase","line":551},{"line":551,"name":"$self","containerName":"phase","kind":13},{"kind":12,"containerName":"phase","name":"get_Annotations","line":551},{"line":553,"kind":13,"containerName":"phase","name":"$self"},{"containerName":"phase","kind":12,"name":"get_Annotations","line":553},{"line":553,"kind":12,"containerName":"phase","name":"value"}],"containerName":"main::","name":"phase","definition":"sub"},{"containerName":"Annotation::SimpleValue","kind":12,"name":"Bio","line":540},{"line":568,"kind":12,"range":{"start":{"character":0,"line":568},"end":{"line":589,"character":9999}},"definition":"sub","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"frame","name":"$self","line":569},{"line":570,"localvar":"my","containerName":"frame","kind":13,"name":"$val","definition":"my"},{"line":572,"name":"$val","containerName":"frame","kind":13},{"definition":"my","name":"$term","containerName":"frame","localvar":"my","kind":13,"line":573},{"kind":13,"containerName":"frame","name":"$val","line":574},{"name":"$term","kind":13,"containerName":"frame","line":575},{"line":575,"name":"new","containerName":"frame","kind":12},{"name":"$val","containerName":"frame","kind":13,"line":575},{"name":"$val","containerName":"frame","kind":13,"line":576},{"name":"$val","containerName":"frame","kind":13,"line":576},{"line":576,"containerName":"frame","kind":12,"name":"isa"},{"line":577,"name":"$term","containerName":"frame","kind":13},{"containerName":"frame","kind":13,"name":"$val","line":577},{"line":579,"name":"$term","kind":13,"containerName":"frame"},{"kind":13,"containerName":"frame","name":"$term","line":579},{"name":"value","containerName":"frame","kind":12,"line":579},{"containerName":"frame","kind":13,"name":"$self","line":580},{"name":"throw","containerName":"frame","kind":12,"line":580},{"containerName":"frame","kind":13,"name":"$self","line":582},{"kind":12,"containerName":"frame","name":"remove_Annotations","line":582},{"line":583,"name":"$self","containerName":"frame","kind":13},{"containerName":"frame","kind":12,"name":"add_Annotation","line":583},{"line":583,"kind":13,"containerName":"frame","name":"$term"},{"name":"$self","kind":13,"containerName":"frame","line":586},{"line":586,"containerName":"frame","kind":12,"name":"frame"},{"line":586,"name":"$self","containerName":"frame","kind":13},{"line":586,"kind":12,"containerName":"frame","name":"get_Annotations"},{"kind":13,"containerName":"frame","name":"$self","line":588},{"kind":12,"containerName":"frame","name":"get_Annotations","line":588},{"name":"value","containerName":"frame","kind":12,"line":588}],"containerName":"main::","name":"frame"},{"name":"Bio","containerName":"Annotation::SimpleValue","kind":12,"line":575},{"definition":"sub","detail":"($self,@args)","children":[{"definition":"my","line":607,"containerName":"add_Annotation","localvar":"my","kind":13,"name":"$self"},{"kind":13,"containerName":"add_Annotation","name":"@args","line":607},{"line":608,"containerName":"add_Annotation","kind":13,"name":"$self"},{"line":608,"name":"annotation","kind":12,"containerName":"add_Annotation"},{"containerName":"add_Annotation","kind":12,"name":"add_Annotation","line":608},{"line":608,"name":"@args","kind":13,"containerName":"add_Annotation"}],"containerName":"main::","name":"add_Annotation","signature":{"label":"add_Annotation($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.\n\n\nsub seq_id {\n  my($self,$val) = @_;\n  if (defined($val)) {\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value =~ /^>/)) {\n\t  $self->throw('give seq_id() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('seq_id');\n      $self->add_Annotation('seq_id', $term);\n  }\n\n  $self->seq_id('.') unless $self->get_Annotations('seq_id'); # make sure we always have something\n\n  return ($self->get_Annotations('seq_id'))[0]->value;\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: human-readable name for the feature.\n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 type()\n\n Usage   : $obj->type($newval)\n Function: a SOFA type for the feature.\n Returns : Bio::Annotation::OntologyTerm object representing the type.\n           NB: to get a string, use primary_tag().\n Args    : on set, Bio::Annotation::OntologyTerm object.\n           NB: to set a string (SOFA name or identifier), use primary_tag()\n\n\nuse constant MAX_TYPE_CACHE_MEMBERS => 20;\nsub type {\n  my($self,$val) = @_;\n  if(defined($val)){\n    my $term = undef;\n\n    if(!ref($val)){\n      $self->throw(\"give type() a Bio::Annotation::OntologyTerm object, not a string\");\n    }\n    elsif(ref($val) && $val->isa('Bio::Annotation::OntologyTerm')){\n      $term = $val;\n    }\n    else {\n      #we have the wrong type of object\n      $self->throw('give type() a SOFA term name, identifier, or Bio::Annotation::OntologyTerm object, not '.$val);\n    }\n    $self->remove_Annotations('type');\n    $self->add_Annotation('type',$term);\n  }\n  \n  return $self->get_Annotations('type');\n}\n\n=head2 source()\n\n Usage   : $obj->source($newval)\n Function: holds the source of the feature.\n Returns : a Bio::Annotation::SimpleValue representing the source.\n           NB: to get a string, use source_tag()\n Args    : on set, a Bio::Annotation::SimpleValue object.\n           NB: to set a string, use source_tag()\n\n\nsub source {\n  my($self,$val) = @_;\n\n  if (defined($val)) {\n      my $term;\n      if (!ref($val)) {\n        $self->throw(\"give source() a Bio::Annotation::SimpleValue object, not a string\");\n        #$term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      } else {\n\t  $self->throw('give source() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('source');\n      $self->add_Annotation('source', $term);\n  }\n  \n  unless ($self->get_Annotations('source')) {\n    $self->source(Bio::Annotation::SimpleValue->new(-value => '.'));\n  }\n  return $self->get_Annotations('source');\n}\n\n=head2 score()\n\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: holds a value corresponding to the score of the feature.\n Returns : a string representing the score.\n Args    : on set, a scalar or a Bio::Annotation::SimpleValue object.\n\n\nsub score {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n\n      if ($term->value ne '.' &&\n           (!defined($term) || ($term->value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/))) {\n\t  $self->throw(\"'$val' is not a valid score\");\n      }\n      $self->remove_Annotations('score');\n      $self->add_Annotation('score', $term);\n  }\n\n  $self->score('.') unless scalar($self->get_Annotations('score')); # make sure we always have something\n\n  return ($self->get_Annotations('score'))[0]->display_text;\n}\n\n=head2 phase()\n\n Usage   : $phase = $feat->phase()\n           $feat->phase($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub phase {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid phase\");\n      }\n      $self->remove_Annotations('phase');\n      $self->add_Annotation('phase', $term);\n  }\n\n  $self->phase('.') unless $self->get_Annotations('phase'); # make sure we always have something\n  \n  return ($self->get_Annotations('phase'))[0]->value;\n}\n\n\n=head2 frame()\n\n Usage   : $frame = $feat->frame()\n           $feat->frame($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub frame {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid frame\");\n      }\n      $self->remove_Annotations('frame');\n      $self->add_Annotation('frame', $term);\n  }\n\n  $self->frame('.') unless $self->get_Annotations('frame'); # make sure we always have something\n  \n  return ($self->get_Annotations('frame'))[0]->value;\n}\n\n############################################################\n\n=head1 SHORTCUT METHODS TO ACCESS Bio::AnnotatableI INTERFACE METHODS\n\n\n=head2 add_Annotation()\n\n Usage   :\n Function: $obj->add_Annotation() is a shortcut to $obj->annotation->add_Annotation\n Returns : \n Args    :"},"line":606,"kind":12,"range":{"start":{"character":0,"line":606},"end":{"character":9999,"line":609}}},{"containerName":"main::","name":"remove_Annotations","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"remove_Annotations","name":"$self","line":621},{"line":621,"name":"@args","kind":13,"containerName":"remove_Annotations"},{"line":622,"name":"$self","containerName":"remove_Annotations","kind":13},{"kind":12,"containerName":"remove_Annotations","name":"annotation","line":622},{"kind":12,"containerName":"remove_Annotations","name":"remove_Annotations","line":622},{"name":"@args","containerName":"remove_Annotations","kind":13,"line":622}],"detail":"($self,@args)","definition":"sub","kind":12,"range":{"end":{"line":623,"character":9999},"start":{"line":620,"character":0}},"line":620,"signature":{"documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.\n\n\nsub seq_id {\n  my($self,$val) = @_;\n  if (defined($val)) {\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value =~ /^>/)) {\n\t  $self->throw('give seq_id() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('seq_id');\n      $self->add_Annotation('seq_id', $term);\n  }\n\n  $self->seq_id('.') unless $self->get_Annotations('seq_id'); # make sure we always have something\n\n  return ($self->get_Annotations('seq_id'))[0]->value;\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: human-readable name for the feature.\n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 type()\n\n Usage   : $obj->type($newval)\n Function: a SOFA type for the feature.\n Returns : Bio::Annotation::OntologyTerm object representing the type.\n           NB: to get a string, use primary_tag().\n Args    : on set, Bio::Annotation::OntologyTerm object.\n           NB: to set a string (SOFA name or identifier), use primary_tag()\n\n\nuse constant MAX_TYPE_CACHE_MEMBERS => 20;\nsub type {\n  my($self,$val) = @_;\n  if(defined($val)){\n    my $term = undef;\n\n    if(!ref($val)){\n      $self->throw(\"give type() a Bio::Annotation::OntologyTerm object, not a string\");\n    }\n    elsif(ref($val) && $val->isa('Bio::Annotation::OntologyTerm')){\n      $term = $val;\n    }\n    else {\n      #we have the wrong type of object\n      $self->throw('give type() a SOFA term name, identifier, or Bio::Annotation::OntologyTerm object, not '.$val);\n    }\n    $self->remove_Annotations('type');\n    $self->add_Annotation('type',$term);\n  }\n  \n  return $self->get_Annotations('type');\n}\n\n=head2 source()\n\n Usage   : $obj->source($newval)\n Function: holds the source of the feature.\n Returns : a Bio::Annotation::SimpleValue representing the source.\n           NB: to get a string, use source_tag()\n Args    : on set, a Bio::Annotation::SimpleValue object.\n           NB: to set a string, use source_tag()\n\n\nsub source {\n  my($self,$val) = @_;\n\n  if (defined($val)) {\n      my $term;\n      if (!ref($val)) {\n        $self->throw(\"give source() a Bio::Annotation::SimpleValue object, not a string\");\n        #$term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      } else {\n\t  $self->throw('give source() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('source');\n      $self->add_Annotation('source', $term);\n  }\n  \n  unless ($self->get_Annotations('source')) {\n    $self->source(Bio::Annotation::SimpleValue->new(-value => '.'));\n  }\n  return $self->get_Annotations('source');\n}\n\n=head2 score()\n\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: holds a value corresponding to the score of the feature.\n Returns : a string representing the score.\n Args    : on set, a scalar or a Bio::Annotation::SimpleValue object.\n\n\nsub score {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n\n      if ($term->value ne '.' &&\n           (!defined($term) || ($term->value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/))) {\n\t  $self->throw(\"'$val' is not a valid score\");\n      }\n      $self->remove_Annotations('score');\n      $self->add_Annotation('score', $term);\n  }\n\n  $self->score('.') unless scalar($self->get_Annotations('score')); # make sure we always have something\n\n  return ($self->get_Annotations('score'))[0]->display_text;\n}\n\n=head2 phase()\n\n Usage   : $phase = $feat->phase()\n           $feat->phase($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub phase {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid phase\");\n      }\n      $self->remove_Annotations('phase');\n      $self->add_Annotation('phase', $term);\n  }\n\n  $self->phase('.') unless $self->get_Annotations('phase'); # make sure we always have something\n  \n  return ($self->get_Annotations('phase'))[0]->value;\n}\n\n\n=head2 frame()\n\n Usage   : $frame = $feat->frame()\n           $feat->frame($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub frame {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid frame\");\n      }\n      $self->remove_Annotations('frame');\n      $self->add_Annotation('frame', $term);\n  }\n\n  $self->frame('.') unless $self->get_Annotations('frame'); # make sure we always have something\n  \n  return ($self->get_Annotations('frame'))[0]->value;\n}\n\n############################################################\n\n=head1 SHORTCUT METHODS TO ACCESS Bio::AnnotatableI INTERFACE METHODS\n\n\n=head2 add_Annotation()\n\n Usage   :\n Function: $obj->add_Annotation() is a shortcut to $obj->annotation->add_Annotation\n Returns : \n Args    :\n\n\nsub add_Annotation {\n  my ($self,@args) = @_;\n  return $self->annotation->add_Annotation(@args);\n}\n\n=head2 remove_Annotations()\n\n Usage   :\n Function: $obj->remove_Annotations() is a shortcut to $obj->annotation->remove_Annotations\n Returns : \n Args    :","parameters":[{"label":"$self"},{"label":"@args"}],"label":"remove_Annotations($self,@args)"}},{"name":"display_name","containerName":"main::","children":[{"definition":"my","line":639,"name":"$self","localvar":"my","kind":13,"containerName":"display_name"},{"line":640,"kind":13,"containerName":"display_name","name":"$self"},{"line":640,"name":"name","containerName":"display_name","kind":12}],"definition":"sub","range":{"end":{"character":9999,"line":641},"start":{"character":0,"line":638}},"kind":12,"line":638},{"definition":"sub","children":[{"definition":"my","line":648,"name":"$self","containerName":"primary_tag","localvar":"my","kind":13},{"definition":"my","containerName":"primary_tag","localvar":"my","kind":13,"name":"$val","line":650},{"definition":"my","line":651,"kind":13,"localvar":"my","containerName":"primary_tag","name":"$term"},{"line":652,"name":"$val","containerName":"primary_tag","kind":13},{"name":"$val","containerName":"primary_tag","kind":13,"line":652},{"kind":13,"containerName":"primary_tag","name":"%__type_cache","line":658},{"line":659,"kind":13,"containerName":"primary_tag","name":"%__type_cache"},{"definition":"my","line":664,"name":"$anntext","localvar":"my","containerName":"primary_tag","kind":13},{"containerName":"primary_tag","kind":13,"name":"$val","line":664},{"name":"$__type_cache","containerName":"primary_tag","kind":13,"line":665},{"name":"$anntext","kind":13,"containerName":"primary_tag","line":665},{"line":666,"containerName":"primary_tag","kind":13,"name":"$term"},{"line":666,"name":"$__type_cache","kind":13,"containerName":"primary_tag"},{"containerName":"primary_tag","kind":13,"name":"$anntext","line":666},{"definition":"my","line":668,"name":"$sofa","localvar":"my","containerName":"primary_tag","kind":13},{"containerName":"primary_tag","kind":12,"name":"get_instance","line":668},{"kind":12,"containerName":"primary_tag","name":"get_ontology","line":668},{"definition":"my","line":669,"containerName":"primary_tag","localvar":"my","kind":13,"name":"$soterm"},{"line":669,"name":"$anntext","containerName":"primary_tag","kind":13},{"line":670,"kind":13,"containerName":"primary_tag","name":"$sofa"},{"line":670,"kind":12,"containerName":"primary_tag","name":"find_terms"},{"containerName":"primary_tag","kind":13,"name":"$anntext","line":670},{"containerName":"primary_tag","kind":13,"name":"$sofa","line":671},{"containerName":"primary_tag","kind":12,"name":"find_terms","line":671},{"name":"$anntext","containerName":"primary_tag","kind":13,"line":671},{"line":673,"containerName":"primary_tag","kind":13,"name":"$soterm"},{"name":"$self","containerName":"primary_tag","kind":13,"line":674},{"name":"throw","containerName":"primary_tag","kind":12,"line":674},{"containerName":"primary_tag","localvar":"my","kind":13,"name":"$newterm","line":676,"definition":"my"},{"name":"new","kind":12,"containerName":"primary_tag","line":676},{"line":677,"kind":13,"containerName":"primary_tag","name":"$newterm"},{"line":677,"containerName":"primary_tag","kind":12,"name":"term"},{"name":"$soterm","kind":13,"containerName":"primary_tag","line":677},{"line":678,"name":"$term","containerName":"primary_tag","kind":13},{"line":678,"containerName":"primary_tag","kind":13,"name":"$newterm"},{"line":681,"name":"$self","kind":13,"containerName":"primary_tag"},{"line":681,"containerName":"primary_tag","kind":12,"name":"type"},{"containerName":"primary_tag","kind":13,"name":"$term","line":681},{"line":685,"name":"$t","localvar":"my","containerName":"primary_tag","kind":13,"definition":"my"},{"containerName":"primary_tag","kind":13,"name":"$self","line":685},{"line":685,"name":"type","containerName":"primary_tag","kind":12},{"name":"$t","kind":13,"containerName":"primary_tag","line":686},{"name":"name","containerName":"primary_tag","kind":12,"line":686}],"name":"primary_tag","containerName":"main::","line":647,"range":{"end":{"character":9999,"line":687},"start":{"character":0,"line":647}},"kind":12},{"definition":"our","kind":13,"containerName":"main::","name":"%__type_cache","line":655},{"line":658,"kind":12,"name":"MAX_TYPE_CACHE_MEMBERS"},{"name":"Bio","containerName":"Ontology::OntologyStore","kind":12,"line":668},{"line":676,"kind":12,"containerName":"Annotation::OntologyTerm","name":"Bio"},{"range":{"end":{"character":9999,"line":704},"start":{"line":693,"character":0}},"kind":12,"line":693,"definition":"sub","name":"source_tag","containerName":"main::","children":[{"name":"$self","containerName":"source_tag","localvar":"my","kind":13,"line":694,"definition":"my"},{"line":696,"name":"$val","containerName":"source_tag","localvar":"my","kind":13,"definition":"my"},{"name":"$val","kind":13,"containerName":"source_tag","line":697},{"containerName":"source_tag","kind":13,"name":"$val","line":697},{"line":698,"name":"$term","localvar":"my","kind":13,"containerName":"source_tag","definition":"my"},{"line":698,"kind":12,"containerName":"source_tag","name":"new"},{"line":698,"name":"$val","kind":13,"containerName":"source_tag"},{"containerName":"source_tag","kind":13,"name":"$self","line":699},{"line":699,"name":"source","containerName":"source_tag","kind":12},{"name":"$term","kind":13,"containerName":"source_tag","line":699},{"definition":"my","line":702,"name":"$t","kind":13,"localvar":"my","containerName":"source_tag"},{"containerName":"source_tag","kind":13,"name":"$self","line":702},{"containerName":"source_tag","kind":12,"name":"source","line":702},{"line":703,"containerName":"source_tag","kind":13,"name":"$t"},{"name":"display_text","containerName":"source_tag","kind":12,"line":703}]},{"line":698,"kind":12,"containerName":"Annotation::SimpleValue","name":"Bio"},{"kind":12,"name":"uri_unescape","line":698},{"name":"attach_seq","containerName":"main::","children":[{"line":719,"name":"$self","localvar":"my","containerName":"attach_seq","kind":13,"definition":"my"},{"line":719,"name":"$seq","kind":13,"containerName":"attach_seq"},{"name":"$seq","containerName":"attach_seq","kind":13,"line":721},{"line":721,"containerName":"attach_seq","kind":13,"name":"$seq"},{"line":721,"name":"$seq","containerName":"attach_seq","kind":13},{"containerName":"attach_seq","kind":12,"name":"isa","line":721},{"kind":13,"containerName":"attach_seq","name":"$self","line":722},{"line":722,"kind":12,"containerName":"attach_seq","name":"throw"},{"line":725,"name":"$self","containerName":"attach_seq","kind":13},{"line":725,"name":"$seq","kind":13,"containerName":"attach_seq"},{"name":"$self","containerName":"attach_seq","kind":13,"line":728},{"name":"get_SeqFeatures","containerName":"attach_seq","kind":12,"line":728},{"line":729,"containerName":"attach_seq","kind":12,"name":"attach_seq"},{"name":"$seq","kind":13,"containerName":"attach_seq","line":729}],"detail":"($self,$seq)","definition":"sub","range":{"start":{"line":718,"character":0},"end":{"character":9999,"line":732}},"kind":12,"line":718,"signature":{"label":"attach_seq($self,$seq)","documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.\n\n\nsub seq_id {\n  my($self,$val) = @_;\n  if (defined($val)) {\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value =~ /^>/)) {\n\t  $self->throw('give seq_id() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('seq_id');\n      $self->add_Annotation('seq_id', $term);\n  }\n\n  $self->seq_id('.') unless $self->get_Annotations('seq_id'); # make sure we always have something\n\n  return ($self->get_Annotations('seq_id'))[0]->value;\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: human-readable name for the feature.\n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 type()\n\n Usage   : $obj->type($newval)\n Function: a SOFA type for the feature.\n Returns : Bio::Annotation::OntologyTerm object representing the type.\n           NB: to get a string, use primary_tag().\n Args    : on set, Bio::Annotation::OntologyTerm object.\n           NB: to set a string (SOFA name or identifier), use primary_tag()\n\n\nuse constant MAX_TYPE_CACHE_MEMBERS => 20;\nsub type {\n  my($self,$val) = @_;\n  if(defined($val)){\n    my $term = undef;\n\n    if(!ref($val)){\n      $self->throw(\"give type() a Bio::Annotation::OntologyTerm object, not a string\");\n    }\n    elsif(ref($val) && $val->isa('Bio::Annotation::OntologyTerm')){\n      $term = $val;\n    }\n    else {\n      #we have the wrong type of object\n      $self->throw('give type() a SOFA term name, identifier, or Bio::Annotation::OntologyTerm object, not '.$val);\n    }\n    $self->remove_Annotations('type');\n    $self->add_Annotation('type',$term);\n  }\n  \n  return $self->get_Annotations('type');\n}\n\n=head2 source()\n\n Usage   : $obj->source($newval)\n Function: holds the source of the feature.\n Returns : a Bio::Annotation::SimpleValue representing the source.\n           NB: to get a string, use source_tag()\n Args    : on set, a Bio::Annotation::SimpleValue object.\n           NB: to set a string, use source_tag()\n\n\nsub source {\n  my($self,$val) = @_;\n\n  if (defined($val)) {\n      my $term;\n      if (!ref($val)) {\n        $self->throw(\"give source() a Bio::Annotation::SimpleValue object, not a string\");\n        #$term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      } else {\n\t  $self->throw('give source() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('source');\n      $self->add_Annotation('source', $term);\n  }\n  \n  unless ($self->get_Annotations('source')) {\n    $self->source(Bio::Annotation::SimpleValue->new(-value => '.'));\n  }\n  return $self->get_Annotations('source');\n}\n\n=head2 score()\n\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: holds a value corresponding to the score of the feature.\n Returns : a string representing the score.\n Args    : on set, a scalar or a Bio::Annotation::SimpleValue object.\n\n\nsub score {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n\n      if ($term->value ne '.' &&\n           (!defined($term) || ($term->value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/))) {\n\t  $self->throw(\"'$val' is not a valid score\");\n      }\n      $self->remove_Annotations('score');\n      $self->add_Annotation('score', $term);\n  }\n\n  $self->score('.') unless scalar($self->get_Annotations('score')); # make sure we always have something\n\n  return ($self->get_Annotations('score'))[0]->display_text;\n}\n\n=head2 phase()\n\n Usage   : $phase = $feat->phase()\n           $feat->phase($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub phase {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid phase\");\n      }\n      $self->remove_Annotations('phase');\n      $self->add_Annotation('phase', $term);\n  }\n\n  $self->phase('.') unless $self->get_Annotations('phase'); # make sure we always have something\n  \n  return ($self->get_Annotations('phase'))[0]->value;\n}\n\n\n=head2 frame()\n\n Usage   : $frame = $feat->frame()\n           $feat->frame($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub frame {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid frame\");\n      }\n      $self->remove_Annotations('frame');\n      $self->add_Annotation('frame', $term);\n  }\n\n  $self->frame('.') unless $self->get_Annotations('frame'); # make sure we always have something\n  \n  return ($self->get_Annotations('frame'))[0]->value;\n}\n\n############################################################\n\n=head1 SHORTCUT METHODS TO ACCESS Bio::AnnotatableI INTERFACE METHODS\n\n\n=head2 add_Annotation()\n\n Usage   :\n Function: $obj->add_Annotation() is a shortcut to $obj->annotation->add_Annotation\n Returns : \n Args    :\n\n\nsub add_Annotation {\n  my ($self,@args) = @_;\n  return $self->annotation->add_Annotation(@args);\n}\n\n=head2 remove_Annotations()\n\n Usage   :\n Function: $obj->remove_Annotations() is a shortcut to $obj->annotation->remove_Annotations\n Returns : \n Args    :\n\n\nsub remove_Annotations {\n  my ($self,@args) = @_;\n  return $self->annotation->remove_Annotations(@args);\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::SeqFeatureI\n\nNote that no methods are deprecated.  Any SeqFeatureI methods must return\nstrings (no objects).\n\n\n=head2 display_name()\n\n\nsub display_name {\n  my $self = shift;\n  return $self->name(@_);\n}\n\n=head2 primary_tag()\n\n\nsub primary_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    my $term;\n    if(!ref($val) && $val){\n      #we have a plain text annotation coming in.  try to map it to SOFA.\n\n      our %__type_cache; #a little cache of plaintext types we've already seen\n\n      #clear our cache if it gets too big\n      if(scalar(keys %__type_cache) > MAX_TYPE_CACHE_MEMBERS) {\n        %__type_cache = ();\n      }\n\n      #set $term to either a cached value, or look up a new one, throwing\n      #up if not found\n      my $anntext = $val;\n      if ($__type_cache{$anntext}) {\n        $term = $__type_cache{$anntext};\n      } else {\n        my $sofa = Bio::Ontology::OntologyStore->get_instance->get_ontology('Sequence Ontology OBO');\n        my ($soterm) = $anntext =~ /^\\D+:\\d+$/ #does it look like an ident?\n          ? ($sofa->find_terms(-identifier => $anntext))[0] #yes, lookup by ident\n          : ($sofa->find_terms(-name => $anntext))[0];      #no, lookup by name\n        #throw if it's not in SOFA\n        unless($soterm){\n          $self->throw(\"couldn't find a SOFA term matching type '$val'.\");\n        }\n        my $newterm = Bio::Annotation::OntologyTerm->new;\n        $newterm->term($soterm);\n        $term = $newterm;\n      }\n      \n      $self->type($term);\n    }\n  }\n  \n  my $t = $self->type() || return;\n  return $t->name;\n}\n\n=head2 source_tag()\n\n\nsub source_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    if(!ref($val) && $val){\n      my $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      $self->source($term);\n    }\n  }\n  my $t = $self->source() || return;\n  return $t->display_text;\n}\n\n\n=head2 attach_seq()\n\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object","parameters":[{"label":"$self"},{"label":"$seq"}]}},{"kind":12,"range":{"start":{"character":0,"line":744},"end":{"character":9999,"line":756}},"line":744,"signature":{"label":"seq($self)","documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.\n\n\nsub seq_id {\n  my($self,$val) = @_;\n  if (defined($val)) {\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value =~ /^>/)) {\n\t  $self->throw('give seq_id() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('seq_id');\n      $self->add_Annotation('seq_id', $term);\n  }\n\n  $self->seq_id('.') unless $self->get_Annotations('seq_id'); # make sure we always have something\n\n  return ($self->get_Annotations('seq_id'))[0]->value;\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: human-readable name for the feature.\n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 type()\n\n Usage   : $obj->type($newval)\n Function: a SOFA type for the feature.\n Returns : Bio::Annotation::OntologyTerm object representing the type.\n           NB: to get a string, use primary_tag().\n Args    : on set, Bio::Annotation::OntologyTerm object.\n           NB: to set a string (SOFA name or identifier), use primary_tag()\n\n\nuse constant MAX_TYPE_CACHE_MEMBERS => 20;\nsub type {\n  my($self,$val) = @_;\n  if(defined($val)){\n    my $term = undef;\n\n    if(!ref($val)){\n      $self->throw(\"give type() a Bio::Annotation::OntologyTerm object, not a string\");\n    }\n    elsif(ref($val) && $val->isa('Bio::Annotation::OntologyTerm')){\n      $term = $val;\n    }\n    else {\n      #we have the wrong type of object\n      $self->throw('give type() a SOFA term name, identifier, or Bio::Annotation::OntologyTerm object, not '.$val);\n    }\n    $self->remove_Annotations('type');\n    $self->add_Annotation('type',$term);\n  }\n  \n  return $self->get_Annotations('type');\n}\n\n=head2 source()\n\n Usage   : $obj->source($newval)\n Function: holds the source of the feature.\n Returns : a Bio::Annotation::SimpleValue representing the source.\n           NB: to get a string, use source_tag()\n Args    : on set, a Bio::Annotation::SimpleValue object.\n           NB: to set a string, use source_tag()\n\n\nsub source {\n  my($self,$val) = @_;\n\n  if (defined($val)) {\n      my $term;\n      if (!ref($val)) {\n        $self->throw(\"give source() a Bio::Annotation::SimpleValue object, not a string\");\n        #$term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      } else {\n\t  $self->throw('give source() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('source');\n      $self->add_Annotation('source', $term);\n  }\n  \n  unless ($self->get_Annotations('source')) {\n    $self->source(Bio::Annotation::SimpleValue->new(-value => '.'));\n  }\n  return $self->get_Annotations('source');\n}\n\n=head2 score()\n\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: holds a value corresponding to the score of the feature.\n Returns : a string representing the score.\n Args    : on set, a scalar or a Bio::Annotation::SimpleValue object.\n\n\nsub score {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n\n      if ($term->value ne '.' &&\n           (!defined($term) || ($term->value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/))) {\n\t  $self->throw(\"'$val' is not a valid score\");\n      }\n      $self->remove_Annotations('score');\n      $self->add_Annotation('score', $term);\n  }\n\n  $self->score('.') unless scalar($self->get_Annotations('score')); # make sure we always have something\n\n  return ($self->get_Annotations('score'))[0]->display_text;\n}\n\n=head2 phase()\n\n Usage   : $phase = $feat->phase()\n           $feat->phase($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub phase {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid phase\");\n      }\n      $self->remove_Annotations('phase');\n      $self->add_Annotation('phase', $term);\n  }\n\n  $self->phase('.') unless $self->get_Annotations('phase'); # make sure we always have something\n  \n  return ($self->get_Annotations('phase'))[0]->value;\n}\n\n\n=head2 frame()\n\n Usage   : $frame = $feat->frame()\n           $feat->frame($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub frame {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid frame\");\n      }\n      $self->remove_Annotations('frame');\n      $self->add_Annotation('frame', $term);\n  }\n\n  $self->frame('.') unless $self->get_Annotations('frame'); # make sure we always have something\n  \n  return ($self->get_Annotations('frame'))[0]->value;\n}\n\n############################################################\n\n=head1 SHORTCUT METHODS TO ACCESS Bio::AnnotatableI INTERFACE METHODS\n\n\n=head2 add_Annotation()\n\n Usage   :\n Function: $obj->add_Annotation() is a shortcut to $obj->annotation->add_Annotation\n Returns : \n Args    :\n\n\nsub add_Annotation {\n  my ($self,@args) = @_;\n  return $self->annotation->add_Annotation(@args);\n}\n\n=head2 remove_Annotations()\n\n Usage   :\n Function: $obj->remove_Annotations() is a shortcut to $obj->annotation->remove_Annotations\n Returns : \n Args    :\n\n\nsub remove_Annotations {\n  my ($self,@args) = @_;\n  return $self->annotation->remove_Annotations(@args);\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::SeqFeatureI\n\nNote that no methods are deprecated.  Any SeqFeatureI methods must return\nstrings (no objects).\n\n\n=head2 display_name()\n\n\nsub display_name {\n  my $self = shift;\n  return $self->name(@_);\n}\n\n=head2 primary_tag()\n\n\nsub primary_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    my $term;\n    if(!ref($val) && $val){\n      #we have a plain text annotation coming in.  try to map it to SOFA.\n\n      our %__type_cache; #a little cache of plaintext types we've already seen\n\n      #clear our cache if it gets too big\n      if(scalar(keys %__type_cache) > MAX_TYPE_CACHE_MEMBERS) {\n        %__type_cache = ();\n      }\n\n      #set $term to either a cached value, or look up a new one, throwing\n      #up if not found\n      my $anntext = $val;\n      if ($__type_cache{$anntext}) {\n        $term = $__type_cache{$anntext};\n      } else {\n        my $sofa = Bio::Ontology::OntologyStore->get_instance->get_ontology('Sequence Ontology OBO');\n        my ($soterm) = $anntext =~ /^\\D+:\\d+$/ #does it look like an ident?\n          ? ($sofa->find_terms(-identifier => $anntext))[0] #yes, lookup by ident\n          : ($sofa->find_terms(-name => $anntext))[0];      #no, lookup by name\n        #throw if it's not in SOFA\n        unless($soterm){\n          $self->throw(\"couldn't find a SOFA term matching type '$val'.\");\n        }\n        my $newterm = Bio::Annotation::OntologyTerm->new;\n        $newterm->term($soterm);\n        $term = $newterm;\n      }\n      \n      $self->type($term);\n    }\n  }\n  \n  my $t = $self->type() || return;\n  return $t->name;\n}\n\n=head2 source_tag()\n\n\nsub source_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    if(!ref($val) && $val){\n      my $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      $self->source($term);\n    }\n  }\n  my $t = $self->source() || return;\n  return $t->display_text;\n}\n\n\n=head2 attach_seq()\n\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( ! ($seq && ref($seq) && $seq->isa(\"Bio::PrimarySeqI\")) ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'seq'} = $seq;\n\n   # attach to sub features if they want it\n   foreach ( $self->get_SeqFeatures() ) {\n       $_->attach_seq($seq);\n   }\n   return 1;\n}\n\n=head2 seq()\n\n Usage   : $tseq = $sf->seq()\n Function: returns a truncated version of seq() with bounds matching this feature\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none","parameters":[{"label":"$self"}]},"name":"seq","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"seq","line":745},{"kind":13,"containerName":"seq","name":"$self","line":747},{"line":747,"containerName":"seq","kind":12,"name":"entire_seq"},{"kind":13,"localvar":"my","containerName":"seq","name":"$seq","line":749,"definition":"my"},{"name":"$self","kind":13,"containerName":"seq","line":749},{"name":"entire_seq","containerName":"seq","kind":12,"line":749},{"name":"trunc","containerName":"seq","kind":12,"line":749},{"name":"$self","kind":13,"containerName":"seq","line":749},{"kind":12,"containerName":"seq","name":"start","line":749},{"line":749,"containerName":"seq","kind":13,"name":"$self"},{"containerName":"seq","kind":12,"name":"end","line":749},{"name":"$self","kind":13,"containerName":"seq","line":751},{"line":751,"name":"strand","containerName":"seq","kind":12},{"containerName":"seq","kind":13,"name":"$self","line":751},{"name":"strand","kind":12,"containerName":"seq","line":751},{"name":"$seq","kind":13,"containerName":"seq","line":752},{"containerName":"seq","kind":13,"name":"$seq","line":752},{"line":752,"name":"revcom","kind":12,"containerName":"seq"},{"line":755,"containerName":"seq","kind":13,"name":"$seq"}],"detail":"($self)","definition":"sub"},{"definition":"sub","children":[],"name":"entire_seq","containerName":"main::","line":768,"kind":12,"range":{"end":{"character":9999,"line":770},"start":{"line":768,"character":0}}},{"children":[{"containerName":"length","localvar":"my","kind":13,"name":"$self","line":790,"definition":"my"},{"line":791,"name":"$self","containerName":"length","kind":13},{"line":791,"containerName":"length","kind":12,"name":"end"},{"line":791,"containerName":"length","kind":13,"name":"$self"},{"line":791,"containerName":"length","kind":12,"name":"start"}],"name":"length","containerName":"main::","definition":"sub","line":789,"kind":12,"range":{"end":{"character":9999,"line":792},"start":{"line":789,"character":0}}},{"signature":{"label":"start($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.\n\n\nsub seq_id {\n  my($self,$val) = @_;\n  if (defined($val)) {\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value =~ /^>/)) {\n\t  $self->throw('give seq_id() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('seq_id');\n      $self->add_Annotation('seq_id', $term);\n  }\n\n  $self->seq_id('.') unless $self->get_Annotations('seq_id'); # make sure we always have something\n\n  return ($self->get_Annotations('seq_id'))[0]->value;\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: human-readable name for the feature.\n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 type()\n\n Usage   : $obj->type($newval)\n Function: a SOFA type for the feature.\n Returns : Bio::Annotation::OntologyTerm object representing the type.\n           NB: to get a string, use primary_tag().\n Args    : on set, Bio::Annotation::OntologyTerm object.\n           NB: to set a string (SOFA name or identifier), use primary_tag()\n\n\nuse constant MAX_TYPE_CACHE_MEMBERS => 20;\nsub type {\n  my($self,$val) = @_;\n  if(defined($val)){\n    my $term = undef;\n\n    if(!ref($val)){\n      $self->throw(\"give type() a Bio::Annotation::OntologyTerm object, not a string\");\n    }\n    elsif(ref($val) && $val->isa('Bio::Annotation::OntologyTerm')){\n      $term = $val;\n    }\n    else {\n      #we have the wrong type of object\n      $self->throw('give type() a SOFA term name, identifier, or Bio::Annotation::OntologyTerm object, not '.$val);\n    }\n    $self->remove_Annotations('type');\n    $self->add_Annotation('type',$term);\n  }\n  \n  return $self->get_Annotations('type');\n}\n\n=head2 source()\n\n Usage   : $obj->source($newval)\n Function: holds the source of the feature.\n Returns : a Bio::Annotation::SimpleValue representing the source.\n           NB: to get a string, use source_tag()\n Args    : on set, a Bio::Annotation::SimpleValue object.\n           NB: to set a string, use source_tag()\n\n\nsub source {\n  my($self,$val) = @_;\n\n  if (defined($val)) {\n      my $term;\n      if (!ref($val)) {\n        $self->throw(\"give source() a Bio::Annotation::SimpleValue object, not a string\");\n        #$term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      } else {\n\t  $self->throw('give source() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('source');\n      $self->add_Annotation('source', $term);\n  }\n  \n  unless ($self->get_Annotations('source')) {\n    $self->source(Bio::Annotation::SimpleValue->new(-value => '.'));\n  }\n  return $self->get_Annotations('source');\n}\n\n=head2 score()\n\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: holds a value corresponding to the score of the feature.\n Returns : a string representing the score.\n Args    : on set, a scalar or a Bio::Annotation::SimpleValue object.\n\n\nsub score {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n\n      if ($term->value ne '.' &&\n           (!defined($term) || ($term->value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/))) {\n\t  $self->throw(\"'$val' is not a valid score\");\n      }\n      $self->remove_Annotations('score');\n      $self->add_Annotation('score', $term);\n  }\n\n  $self->score('.') unless scalar($self->get_Annotations('score')); # make sure we always have something\n\n  return ($self->get_Annotations('score'))[0]->display_text;\n}\n\n=head2 phase()\n\n Usage   : $phase = $feat->phase()\n           $feat->phase($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub phase {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid phase\");\n      }\n      $self->remove_Annotations('phase');\n      $self->add_Annotation('phase', $term);\n  }\n\n  $self->phase('.') unless $self->get_Annotations('phase'); # make sure we always have something\n  \n  return ($self->get_Annotations('phase'))[0]->value;\n}\n\n\n=head2 frame()\n\n Usage   : $frame = $feat->frame()\n           $feat->frame($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub frame {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid frame\");\n      }\n      $self->remove_Annotations('frame');\n      $self->add_Annotation('frame', $term);\n  }\n\n  $self->frame('.') unless $self->get_Annotations('frame'); # make sure we always have something\n  \n  return ($self->get_Annotations('frame'))[0]->value;\n}\n\n############################################################\n\n=head1 SHORTCUT METHODS TO ACCESS Bio::AnnotatableI INTERFACE METHODS\n\n\n=head2 add_Annotation()\n\n Usage   :\n Function: $obj->add_Annotation() is a shortcut to $obj->annotation->add_Annotation\n Returns : \n Args    :\n\n\nsub add_Annotation {\n  my ($self,@args) = @_;\n  return $self->annotation->add_Annotation(@args);\n}\n\n=head2 remove_Annotations()\n\n Usage   :\n Function: $obj->remove_Annotations() is a shortcut to $obj->annotation->remove_Annotations\n Returns : \n Args    :\n\n\nsub remove_Annotations {\n  my ($self,@args) = @_;\n  return $self->annotation->remove_Annotations(@args);\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::SeqFeatureI\n\nNote that no methods are deprecated.  Any SeqFeatureI methods must return\nstrings (no objects).\n\n\n=head2 display_name()\n\n\nsub display_name {\n  my $self = shift;\n  return $self->name(@_);\n}\n\n=head2 primary_tag()\n\n\nsub primary_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    my $term;\n    if(!ref($val) && $val){\n      #we have a plain text annotation coming in.  try to map it to SOFA.\n\n      our %__type_cache; #a little cache of plaintext types we've already seen\n\n      #clear our cache if it gets too big\n      if(scalar(keys %__type_cache) > MAX_TYPE_CACHE_MEMBERS) {\n        %__type_cache = ();\n      }\n\n      #set $term to either a cached value, or look up a new one, throwing\n      #up if not found\n      my $anntext = $val;\n      if ($__type_cache{$anntext}) {\n        $term = $__type_cache{$anntext};\n      } else {\n        my $sofa = Bio::Ontology::OntologyStore->get_instance->get_ontology('Sequence Ontology OBO');\n        my ($soterm) = $anntext =~ /^\\D+:\\d+$/ #does it look like an ident?\n          ? ($sofa->find_terms(-identifier => $anntext))[0] #yes, lookup by ident\n          : ($sofa->find_terms(-name => $anntext))[0];      #no, lookup by name\n        #throw if it's not in SOFA\n        unless($soterm){\n          $self->throw(\"couldn't find a SOFA term matching type '$val'.\");\n        }\n        my $newterm = Bio::Annotation::OntologyTerm->new;\n        $newterm->term($soterm);\n        $term = $newterm;\n      }\n      \n      $self->type($term);\n    }\n  }\n  \n  my $t = $self->type() || return;\n  return $t->name;\n}\n\n=head2 source_tag()\n\n\nsub source_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    if(!ref($val) && $val){\n      my $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      $self->source($term);\n    }\n  }\n  my $t = $self->source() || return;\n  return $t->display_text;\n}\n\n\n=head2 attach_seq()\n\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( ! ($seq && ref($seq) && $seq->isa(\"Bio::PrimarySeqI\")) ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'seq'} = $seq;\n\n   # attach to sub features if they want it\n   foreach ( $self->get_SeqFeatures() ) {\n       $_->attach_seq($seq);\n   }\n   return 1;\n}\n\n=head2 seq()\n\n Usage   : $tseq = $sf->seq()\n Function: returns a truncated version of seq() with bounds matching this feature\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\nsub seq {\n  my ($self) = @_;\n\n  return unless defined($self->entire_seq());\n\n  my $seq = $self->entire_seq->trunc($self->start(), $self->end());\n\n  if ( defined $self->strand && $self->strand == -1 ) {\n    $seq = $seq->revcom;\n  }\n\n  return $seq;\n}\n\n=head2 entire_seq()\n\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    : none\n\n\nsub entire_seq {\n  return shift->{'seq'};\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::RangeI\n\n as inherited via Bio::SeqFeatureI\n\n\n=head2 length()\n\n Usage   : $feature->length()\n Function: Get the feature length computed as $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\nsub length {\n  my $self = shift;\n  return $self->end() - $self->start() + 1;\n}\n\n=head2 start()\n\n Usage   : $obj->start($newval)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)"},"line":803,"kind":12,"range":{"end":{"character":9999,"line":806},"start":{"character":0,"line":803}},"definition":"sub","detail":"($self,$value)","children":[{"definition":"my","line":804,"name":"$self","localvar":"my","containerName":"start","kind":13},{"line":804,"kind":13,"containerName":"start","name":"$value"},{"line":805,"name":"$self","containerName":"start","kind":13},{"line":805,"name":"location","containerName":"start","kind":12},{"name":"start","containerName":"start","kind":12,"line":805},{"line":805,"name":"$value","containerName":"start","kind":13}],"name":"start","containerName":"main::"},{"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"end","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"end","line":818},{"line":818,"containerName":"end","kind":13,"name":"$value"},{"line":819,"name":"$self","kind":13,"containerName":"end"},{"line":819,"kind":12,"containerName":"end","name":"location"},{"name":"end","containerName":"end","kind":12,"line":819},{"containerName":"end","kind":13,"name":"$value","line":819}],"signature":{"documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.\n\n\nsub seq_id {\n  my($self,$val) = @_;\n  if (defined($val)) {\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value =~ /^>/)) {\n\t  $self->throw('give seq_id() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('seq_id');\n      $self->add_Annotation('seq_id', $term);\n  }\n\n  $self->seq_id('.') unless $self->get_Annotations('seq_id'); # make sure we always have something\n\n  return ($self->get_Annotations('seq_id'))[0]->value;\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: human-readable name for the feature.\n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 type()\n\n Usage   : $obj->type($newval)\n Function: a SOFA type for the feature.\n Returns : Bio::Annotation::OntologyTerm object representing the type.\n           NB: to get a string, use primary_tag().\n Args    : on set, Bio::Annotation::OntologyTerm object.\n           NB: to set a string (SOFA name or identifier), use primary_tag()\n\n\nuse constant MAX_TYPE_CACHE_MEMBERS => 20;\nsub type {\n  my($self,$val) = @_;\n  if(defined($val)){\n    my $term = undef;\n\n    if(!ref($val)){\n      $self->throw(\"give type() a Bio::Annotation::OntologyTerm object, not a string\");\n    }\n    elsif(ref($val) && $val->isa('Bio::Annotation::OntologyTerm')){\n      $term = $val;\n    }\n    else {\n      #we have the wrong type of object\n      $self->throw('give type() a SOFA term name, identifier, or Bio::Annotation::OntologyTerm object, not '.$val);\n    }\n    $self->remove_Annotations('type');\n    $self->add_Annotation('type',$term);\n  }\n  \n  return $self->get_Annotations('type');\n}\n\n=head2 source()\n\n Usage   : $obj->source($newval)\n Function: holds the source of the feature.\n Returns : a Bio::Annotation::SimpleValue representing the source.\n           NB: to get a string, use source_tag()\n Args    : on set, a Bio::Annotation::SimpleValue object.\n           NB: to set a string, use source_tag()\n\n\nsub source {\n  my($self,$val) = @_;\n\n  if (defined($val)) {\n      my $term;\n      if (!ref($val)) {\n        $self->throw(\"give source() a Bio::Annotation::SimpleValue object, not a string\");\n        #$term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      } else {\n\t  $self->throw('give source() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('source');\n      $self->add_Annotation('source', $term);\n  }\n  \n  unless ($self->get_Annotations('source')) {\n    $self->source(Bio::Annotation::SimpleValue->new(-value => '.'));\n  }\n  return $self->get_Annotations('source');\n}\n\n=head2 score()\n\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: holds a value corresponding to the score of the feature.\n Returns : a string representing the score.\n Args    : on set, a scalar or a Bio::Annotation::SimpleValue object.\n\n\nsub score {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n\n      if ($term->value ne '.' &&\n           (!defined($term) || ($term->value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/))) {\n\t  $self->throw(\"'$val' is not a valid score\");\n      }\n      $self->remove_Annotations('score');\n      $self->add_Annotation('score', $term);\n  }\n\n  $self->score('.') unless scalar($self->get_Annotations('score')); # make sure we always have something\n\n  return ($self->get_Annotations('score'))[0]->display_text;\n}\n\n=head2 phase()\n\n Usage   : $phase = $feat->phase()\n           $feat->phase($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub phase {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid phase\");\n      }\n      $self->remove_Annotations('phase');\n      $self->add_Annotation('phase', $term);\n  }\n\n  $self->phase('.') unless $self->get_Annotations('phase'); # make sure we always have something\n  \n  return ($self->get_Annotations('phase'))[0]->value;\n}\n\n\n=head2 frame()\n\n Usage   : $frame = $feat->frame()\n           $feat->frame($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub frame {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid frame\");\n      }\n      $self->remove_Annotations('frame');\n      $self->add_Annotation('frame', $term);\n  }\n\n  $self->frame('.') unless $self->get_Annotations('frame'); # make sure we always have something\n  \n  return ($self->get_Annotations('frame'))[0]->value;\n}\n\n############################################################\n\n=head1 SHORTCUT METHODS TO ACCESS Bio::AnnotatableI INTERFACE METHODS\n\n\n=head2 add_Annotation()\n\n Usage   :\n Function: $obj->add_Annotation() is a shortcut to $obj->annotation->add_Annotation\n Returns : \n Args    :\n\n\nsub add_Annotation {\n  my ($self,@args) = @_;\n  return $self->annotation->add_Annotation(@args);\n}\n\n=head2 remove_Annotations()\n\n Usage   :\n Function: $obj->remove_Annotations() is a shortcut to $obj->annotation->remove_Annotations\n Returns : \n Args    :\n\n\nsub remove_Annotations {\n  my ($self,@args) = @_;\n  return $self->annotation->remove_Annotations(@args);\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::SeqFeatureI\n\nNote that no methods are deprecated.  Any SeqFeatureI methods must return\nstrings (no objects).\n\n\n=head2 display_name()\n\n\nsub display_name {\n  my $self = shift;\n  return $self->name(@_);\n}\n\n=head2 primary_tag()\n\n\nsub primary_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    my $term;\n    if(!ref($val) && $val){\n      #we have a plain text annotation coming in.  try to map it to SOFA.\n\n      our %__type_cache; #a little cache of plaintext types we've already seen\n\n      #clear our cache if it gets too big\n      if(scalar(keys %__type_cache) > MAX_TYPE_CACHE_MEMBERS) {\n        %__type_cache = ();\n      }\n\n      #set $term to either a cached value, or look up a new one, throwing\n      #up if not found\n      my $anntext = $val;\n      if ($__type_cache{$anntext}) {\n        $term = $__type_cache{$anntext};\n      } else {\n        my $sofa = Bio::Ontology::OntologyStore->get_instance->get_ontology('Sequence Ontology OBO');\n        my ($soterm) = $anntext =~ /^\\D+:\\d+$/ #does it look like an ident?\n          ? ($sofa->find_terms(-identifier => $anntext))[0] #yes, lookup by ident\n          : ($sofa->find_terms(-name => $anntext))[0];      #no, lookup by name\n        #throw if it's not in SOFA\n        unless($soterm){\n          $self->throw(\"couldn't find a SOFA term matching type '$val'.\");\n        }\n        my $newterm = Bio::Annotation::OntologyTerm->new;\n        $newterm->term($soterm);\n        $term = $newterm;\n      }\n      \n      $self->type($term);\n    }\n  }\n  \n  my $t = $self->type() || return;\n  return $t->name;\n}\n\n=head2 source_tag()\n\n\nsub source_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    if(!ref($val) && $val){\n      my $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      $self->source($term);\n    }\n  }\n  my $t = $self->source() || return;\n  return $t->display_text;\n}\n\n\n=head2 attach_seq()\n\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( ! ($seq && ref($seq) && $seq->isa(\"Bio::PrimarySeqI\")) ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'seq'} = $seq;\n\n   # attach to sub features if they want it\n   foreach ( $self->get_SeqFeatures() ) {\n       $_->attach_seq($seq);\n   }\n   return 1;\n}\n\n=head2 seq()\n\n Usage   : $tseq = $sf->seq()\n Function: returns a truncated version of seq() with bounds matching this feature\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\nsub seq {\n  my ($self) = @_;\n\n  return unless defined($self->entire_seq());\n\n  my $seq = $self->entire_seq->trunc($self->start(), $self->end());\n\n  if ( defined $self->strand && $self->strand == -1 ) {\n    $seq = $seq->revcom;\n  }\n\n  return $seq;\n}\n\n=head2 entire_seq()\n\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    : none\n\n\nsub entire_seq {\n  return shift->{'seq'};\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::RangeI\n\n as inherited via Bio::SeqFeatureI\n\n\n=head2 length()\n\n Usage   : $feature->length()\n Function: Get the feature length computed as $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\nsub length {\n  my $self = shift;\n  return $self->end() - $self->start() + 1;\n}\n\n=head2 start()\n\n Usage   : $obj->start($newval)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub start {\n  my ($self,$value) = @_;\n  return $self->location->start($value);\n}\n\n=head2 end()\n\n Usage   : $obj->end($newval)\n Function: Get/set on the end coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"end($self,$value)"},"range":{"end":{"character":9999,"line":820},"start":{"character":0,"line":817}},"kind":12,"line":817},{"line":831,"kind":12,"range":{"start":{"line":831,"character":0},"end":{"line":834,"character":9999}},"definition":"sub","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"strand","name":"$self","line":832},{"line":833,"name":"$self","containerName":"strand","kind":13},{"line":833,"name":"location","containerName":"strand","kind":12},{"line":833,"name":"strand","containerName":"strand","kind":12}],"containerName":"main::","name":"strand"},{"range":{"start":{"character":0,"line":856},"end":{"line":857,"character":9999}},"kind":12,"line":856,"definition":"sub","name":"get_SeqFeatures","containerName":"main::","children":[]},{"name":"shift","kind":12,"line":857},{"kind":12,"range":{"start":{"character":0,"line":878},"end":{"character":9999,"line":897}},"line":878,"signature":{"label":"add_SeqFeature($self,$val,$expand)","documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.\n\n\nsub seq_id {\n  my($self,$val) = @_;\n  if (defined($val)) {\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value =~ /^>/)) {\n\t  $self->throw('give seq_id() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('seq_id');\n      $self->add_Annotation('seq_id', $term);\n  }\n\n  $self->seq_id('.') unless $self->get_Annotations('seq_id'); # make sure we always have something\n\n  return ($self->get_Annotations('seq_id'))[0]->value;\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: human-readable name for the feature.\n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 type()\n\n Usage   : $obj->type($newval)\n Function: a SOFA type for the feature.\n Returns : Bio::Annotation::OntologyTerm object representing the type.\n           NB: to get a string, use primary_tag().\n Args    : on set, Bio::Annotation::OntologyTerm object.\n           NB: to set a string (SOFA name or identifier), use primary_tag()\n\n\nuse constant MAX_TYPE_CACHE_MEMBERS => 20;\nsub type {\n  my($self,$val) = @_;\n  if(defined($val)){\n    my $term = undef;\n\n    if(!ref($val)){\n      $self->throw(\"give type() a Bio::Annotation::OntologyTerm object, not a string\");\n    }\n    elsif(ref($val) && $val->isa('Bio::Annotation::OntologyTerm')){\n      $term = $val;\n    }\n    else {\n      #we have the wrong type of object\n      $self->throw('give type() a SOFA term name, identifier, or Bio::Annotation::OntologyTerm object, not '.$val);\n    }\n    $self->remove_Annotations('type');\n    $self->add_Annotation('type',$term);\n  }\n  \n  return $self->get_Annotations('type');\n}\n\n=head2 source()\n\n Usage   : $obj->source($newval)\n Function: holds the source of the feature.\n Returns : a Bio::Annotation::SimpleValue representing the source.\n           NB: to get a string, use source_tag()\n Args    : on set, a Bio::Annotation::SimpleValue object.\n           NB: to set a string, use source_tag()\n\n\nsub source {\n  my($self,$val) = @_;\n\n  if (defined($val)) {\n      my $term;\n      if (!ref($val)) {\n        $self->throw(\"give source() a Bio::Annotation::SimpleValue object, not a string\");\n        #$term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      } else {\n\t  $self->throw('give source() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('source');\n      $self->add_Annotation('source', $term);\n  }\n  \n  unless ($self->get_Annotations('source')) {\n    $self->source(Bio::Annotation::SimpleValue->new(-value => '.'));\n  }\n  return $self->get_Annotations('source');\n}\n\n=head2 score()\n\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: holds a value corresponding to the score of the feature.\n Returns : a string representing the score.\n Args    : on set, a scalar or a Bio::Annotation::SimpleValue object.\n\n\nsub score {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n\n      if ($term->value ne '.' &&\n           (!defined($term) || ($term->value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/))) {\n\t  $self->throw(\"'$val' is not a valid score\");\n      }\n      $self->remove_Annotations('score');\n      $self->add_Annotation('score', $term);\n  }\n\n  $self->score('.') unless scalar($self->get_Annotations('score')); # make sure we always have something\n\n  return ($self->get_Annotations('score'))[0]->display_text;\n}\n\n=head2 phase()\n\n Usage   : $phase = $feat->phase()\n           $feat->phase($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub phase {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid phase\");\n      }\n      $self->remove_Annotations('phase');\n      $self->add_Annotation('phase', $term);\n  }\n\n  $self->phase('.') unless $self->get_Annotations('phase'); # make sure we always have something\n  \n  return ($self->get_Annotations('phase'))[0]->value;\n}\n\n\n=head2 frame()\n\n Usage   : $frame = $feat->frame()\n           $feat->frame($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub frame {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid frame\");\n      }\n      $self->remove_Annotations('frame');\n      $self->add_Annotation('frame', $term);\n  }\n\n  $self->frame('.') unless $self->get_Annotations('frame'); # make sure we always have something\n  \n  return ($self->get_Annotations('frame'))[0]->value;\n}\n\n############################################################\n\n=head1 SHORTCUT METHODS TO ACCESS Bio::AnnotatableI INTERFACE METHODS\n\n\n=head2 add_Annotation()\n\n Usage   :\n Function: $obj->add_Annotation() is a shortcut to $obj->annotation->add_Annotation\n Returns : \n Args    :\n\n\nsub add_Annotation {\n  my ($self,@args) = @_;\n  return $self->annotation->add_Annotation(@args);\n}\n\n=head2 remove_Annotations()\n\n Usage   :\n Function: $obj->remove_Annotations() is a shortcut to $obj->annotation->remove_Annotations\n Returns : \n Args    :\n\n\nsub remove_Annotations {\n  my ($self,@args) = @_;\n  return $self->annotation->remove_Annotations(@args);\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::SeqFeatureI\n\nNote that no methods are deprecated.  Any SeqFeatureI methods must return\nstrings (no objects).\n\n\n=head2 display_name()\n\n\nsub display_name {\n  my $self = shift;\n  return $self->name(@_);\n}\n\n=head2 primary_tag()\n\n\nsub primary_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    my $term;\n    if(!ref($val) && $val){\n      #we have a plain text annotation coming in.  try to map it to SOFA.\n\n      our %__type_cache; #a little cache of plaintext types we've already seen\n\n      #clear our cache if it gets too big\n      if(scalar(keys %__type_cache) > MAX_TYPE_CACHE_MEMBERS) {\n        %__type_cache = ();\n      }\n\n      #set $term to either a cached value, or look up a new one, throwing\n      #up if not found\n      my $anntext = $val;\n      if ($__type_cache{$anntext}) {\n        $term = $__type_cache{$anntext};\n      } else {\n        my $sofa = Bio::Ontology::OntologyStore->get_instance->get_ontology('Sequence Ontology OBO');\n        my ($soterm) = $anntext =~ /^\\D+:\\d+$/ #does it look like an ident?\n          ? ($sofa->find_terms(-identifier => $anntext))[0] #yes, lookup by ident\n          : ($sofa->find_terms(-name => $anntext))[0];      #no, lookup by name\n        #throw if it's not in SOFA\n        unless($soterm){\n          $self->throw(\"couldn't find a SOFA term matching type '$val'.\");\n        }\n        my $newterm = Bio::Annotation::OntologyTerm->new;\n        $newterm->term($soterm);\n        $term = $newterm;\n      }\n      \n      $self->type($term);\n    }\n  }\n  \n  my $t = $self->type() || return;\n  return $t->name;\n}\n\n=head2 source_tag()\n\n\nsub source_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    if(!ref($val) && $val){\n      my $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      $self->source($term);\n    }\n  }\n  my $t = $self->source() || return;\n  return $t->display_text;\n}\n\n\n=head2 attach_seq()\n\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( ! ($seq && ref($seq) && $seq->isa(\"Bio::PrimarySeqI\")) ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'seq'} = $seq;\n\n   # attach to sub features if they want it\n   foreach ( $self->get_SeqFeatures() ) {\n       $_->attach_seq($seq);\n   }\n   return 1;\n}\n\n=head2 seq()\n\n Usage   : $tseq = $sf->seq()\n Function: returns a truncated version of seq() with bounds matching this feature\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\nsub seq {\n  my ($self) = @_;\n\n  return unless defined($self->entire_seq());\n\n  my $seq = $self->entire_seq->trunc($self->start(), $self->end());\n\n  if ( defined $self->strand && $self->strand == -1 ) {\n    $seq = $seq->revcom;\n  }\n\n  return $seq;\n}\n\n=head2 entire_seq()\n\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    : none\n\n\nsub entire_seq {\n  return shift->{'seq'};\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::RangeI\n\n as inherited via Bio::SeqFeatureI\n\n\n=head2 length()\n\n Usage   : $feature->length()\n Function: Get the feature length computed as $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\nsub length {\n  my $self = shift;\n  return $self->end() - $self->start() + 1;\n}\n\n=head2 start()\n\n Usage   : $obj->start($newval)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub start {\n  my ($self,$value) = @_;\n  return $self->location->start($value);\n}\n\n=head2 end()\n\n Usage   : $obj->end($newval)\n Function: Get/set on the end coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub end {\n  my ($self,$value) = @_;\n  return $self->location->end($value);\n}\n\n=head2 strand()\n\n Usage   : $strand = $feat->strand($newval)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub strand {\n  my $self = shift;\n  return $self->location->strand(@_);\n}\n\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::FeatureHolderI\n\nThis includes methods for retrieving, adding, and removing\nfeatures. Since this is already a feature, features held by this\nfeature holder are essentially sub-features.\n\n\n=head2 get_SeqFeatures\n\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of Bio::SeqFeatureI objects\n Returns : An array\n Args    : none\n\n\nsub get_SeqFeatures {\n  return @{ shift->{'sub_array'} || []};\n}\n\n=head2 add_SeqFeature()\n\n Usage   : $feat->add_SeqFeature($subfeat);\n           $feat->add_SeqFeature($subfeat,'EXPAND')\n Function: adds a SeqFeature into the subSeqFeature array.\n           with no 'EXPAND' qualifer, subfeat will be tested\n           as to whether it lies inside the parent, and throw\n           an exception if not.\n\n           If EXPAND is used, the parent''s start/end/strand will\n           be adjusted so that it grows to accommodate the new\n           subFeature\n Example :\n Returns : nothing\n Args    : a Bio::SeqFeatureI object","parameters":[{"label":"$self"},{"label":"$val"},{"label":"$expand"}]},"containerName":"main::","name":"add_SeqFeature","children":[{"kind":13,"localvar":"my","containerName":"add_SeqFeature","name":"$self","line":879,"definition":"my"},{"line":879,"containerName":"add_SeqFeature","kind":13,"name":"$val"},{"containerName":"add_SeqFeature","kind":13,"name":"$expand","line":879},{"line":881,"kind":13,"containerName":"add_SeqFeature","name":"$val"},{"line":883,"name":"$val","containerName":"add_SeqFeature","kind":13},{"line":883,"name":"$val","containerName":"add_SeqFeature","kind":13},{"line":883,"kind":12,"containerName":"add_SeqFeature","name":"isa"},{"name":"$self","containerName":"add_SeqFeature","kind":13,"line":884},{"containerName":"add_SeqFeature","kind":12,"name":"throw","line":884},{"line":884,"name":"$val","containerName":"add_SeqFeature","kind":13},{"line":884,"name":"$val","containerName":"add_SeqFeature","kind":13},{"name":"$val","containerName":"add_SeqFeature","kind":13,"line":884},{"name":"$expand","containerName":"add_SeqFeature","kind":13,"line":888},{"name":"$expand","containerName":"add_SeqFeature","kind":13,"line":888},{"line":889,"name":"$self","kind":13,"containerName":"add_SeqFeature"},{"line":889,"name":"_expand_region","containerName":"add_SeqFeature","kind":12},{"line":889,"containerName":"add_SeqFeature","kind":13,"name":"$val"},{"line":891,"containerName":"add_SeqFeature","kind":13,"name":"$self"},{"containerName":"add_SeqFeature","kind":12,"name":"contains","line":891},{"line":891,"name":"$val","kind":13,"containerName":"add_SeqFeature"},{"line":892,"containerName":"add_SeqFeature","kind":13,"name":"$self"},{"line":892,"name":"warn","kind":12,"containerName":"add_SeqFeature"},{"name":"$self","kind":13,"containerName":"add_SeqFeature","line":897}],"detail":"($self,$val,$expand)","definition":"sub"},{"line":897,"name":"$val","containerName":null,"kind":13},{"name":"remove_SeqFeatures","containerName":"main::","children":[{"line":912,"name":"$self","localvar":"my","containerName":"remove_SeqFeatures","kind":13,"definition":"my"},{"definition":"my","name":"@subfeats","localvar":"my","kind":13,"containerName":"remove_SeqFeatures","line":914},{"line":914,"name":"$self","kind":13,"containerName":"remove_SeqFeatures"}],"detail":"($self)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":914},"start":{"character":0,"line":911}},"line":911,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.\n\n\nsub seq_id {\n  my($self,$val) = @_;\n  if (defined($val)) {\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value =~ /^>/)) {\n\t  $self->throw('give seq_id() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('seq_id');\n      $self->add_Annotation('seq_id', $term);\n  }\n\n  $self->seq_id('.') unless $self->get_Annotations('seq_id'); # make sure we always have something\n\n  return ($self->get_Annotations('seq_id'))[0]->value;\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: human-readable name for the feature.\n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 type()\n\n Usage   : $obj->type($newval)\n Function: a SOFA type for the feature.\n Returns : Bio::Annotation::OntologyTerm object representing the type.\n           NB: to get a string, use primary_tag().\n Args    : on set, Bio::Annotation::OntologyTerm object.\n           NB: to set a string (SOFA name or identifier), use primary_tag()\n\n\nuse constant MAX_TYPE_CACHE_MEMBERS => 20;\nsub type {\n  my($self,$val) = @_;\n  if(defined($val)){\n    my $term = undef;\n\n    if(!ref($val)){\n      $self->throw(\"give type() a Bio::Annotation::OntologyTerm object, not a string\");\n    }\n    elsif(ref($val) && $val->isa('Bio::Annotation::OntologyTerm')){\n      $term = $val;\n    }\n    else {\n      #we have the wrong type of object\n      $self->throw('give type() a SOFA term name, identifier, or Bio::Annotation::OntologyTerm object, not '.$val);\n    }\n    $self->remove_Annotations('type');\n    $self->add_Annotation('type',$term);\n  }\n  \n  return $self->get_Annotations('type');\n}\n\n=head2 source()\n\n Usage   : $obj->source($newval)\n Function: holds the source of the feature.\n Returns : a Bio::Annotation::SimpleValue representing the source.\n           NB: to get a string, use source_tag()\n Args    : on set, a Bio::Annotation::SimpleValue object.\n           NB: to set a string, use source_tag()\n\n\nsub source {\n  my($self,$val) = @_;\n\n  if (defined($val)) {\n      my $term;\n      if (!ref($val)) {\n        $self->throw(\"give source() a Bio::Annotation::SimpleValue object, not a string\");\n        #$term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      } else {\n\t  $self->throw('give source() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('source');\n      $self->add_Annotation('source', $term);\n  }\n  \n  unless ($self->get_Annotations('source')) {\n    $self->source(Bio::Annotation::SimpleValue->new(-value => '.'));\n  }\n  return $self->get_Annotations('source');\n}\n\n=head2 score()\n\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: holds a value corresponding to the score of the feature.\n Returns : a string representing the score.\n Args    : on set, a scalar or a Bio::Annotation::SimpleValue object.\n\n\nsub score {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n\n      if ($term->value ne '.' &&\n           (!defined($term) || ($term->value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/))) {\n\t  $self->throw(\"'$val' is not a valid score\");\n      }\n      $self->remove_Annotations('score');\n      $self->add_Annotation('score', $term);\n  }\n\n  $self->score('.') unless scalar($self->get_Annotations('score')); # make sure we always have something\n\n  return ($self->get_Annotations('score'))[0]->display_text;\n}\n\n=head2 phase()\n\n Usage   : $phase = $feat->phase()\n           $feat->phase($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub phase {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid phase\");\n      }\n      $self->remove_Annotations('phase');\n      $self->add_Annotation('phase', $term);\n  }\n\n  $self->phase('.') unless $self->get_Annotations('phase'); # make sure we always have something\n  \n  return ($self->get_Annotations('phase'))[0]->value;\n}\n\n\n=head2 frame()\n\n Usage   : $frame = $feat->frame()\n           $feat->frame($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub frame {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid frame\");\n      }\n      $self->remove_Annotations('frame');\n      $self->add_Annotation('frame', $term);\n  }\n\n  $self->frame('.') unless $self->get_Annotations('frame'); # make sure we always have something\n  \n  return ($self->get_Annotations('frame'))[0]->value;\n}\n\n############################################################\n\n=head1 SHORTCUT METHODS TO ACCESS Bio::AnnotatableI INTERFACE METHODS\n\n\n=head2 add_Annotation()\n\n Usage   :\n Function: $obj->add_Annotation() is a shortcut to $obj->annotation->add_Annotation\n Returns : \n Args    :\n\n\nsub add_Annotation {\n  my ($self,@args) = @_;\n  return $self->annotation->add_Annotation(@args);\n}\n\n=head2 remove_Annotations()\n\n Usage   :\n Function: $obj->remove_Annotations() is a shortcut to $obj->annotation->remove_Annotations\n Returns : \n Args    :\n\n\nsub remove_Annotations {\n  my ($self,@args) = @_;\n  return $self->annotation->remove_Annotations(@args);\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::SeqFeatureI\n\nNote that no methods are deprecated.  Any SeqFeatureI methods must return\nstrings (no objects).\n\n\n=head2 display_name()\n\n\nsub display_name {\n  my $self = shift;\n  return $self->name(@_);\n}\n\n=head2 primary_tag()\n\n\nsub primary_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    my $term;\n    if(!ref($val) && $val){\n      #we have a plain text annotation coming in.  try to map it to SOFA.\n\n      our %__type_cache; #a little cache of plaintext types we've already seen\n\n      #clear our cache if it gets too big\n      if(scalar(keys %__type_cache) > MAX_TYPE_CACHE_MEMBERS) {\n        %__type_cache = ();\n      }\n\n      #set $term to either a cached value, or look up a new one, throwing\n      #up if not found\n      my $anntext = $val;\n      if ($__type_cache{$anntext}) {\n        $term = $__type_cache{$anntext};\n      } else {\n        my $sofa = Bio::Ontology::OntologyStore->get_instance->get_ontology('Sequence Ontology OBO');\n        my ($soterm) = $anntext =~ /^\\D+:\\d+$/ #does it look like an ident?\n          ? ($sofa->find_terms(-identifier => $anntext))[0] #yes, lookup by ident\n          : ($sofa->find_terms(-name => $anntext))[0];      #no, lookup by name\n        #throw if it's not in SOFA\n        unless($soterm){\n          $self->throw(\"couldn't find a SOFA term matching type '$val'.\");\n        }\n        my $newterm = Bio::Annotation::OntologyTerm->new;\n        $newterm->term($soterm);\n        $term = $newterm;\n      }\n      \n      $self->type($term);\n    }\n  }\n  \n  my $t = $self->type() || return;\n  return $t->name;\n}\n\n=head2 source_tag()\n\n\nsub source_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    if(!ref($val) && $val){\n      my $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      $self->source($term);\n    }\n  }\n  my $t = $self->source() || return;\n  return $t->display_text;\n}\n\n\n=head2 attach_seq()\n\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( ! ($seq && ref($seq) && $seq->isa(\"Bio::PrimarySeqI\")) ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'seq'} = $seq;\n\n   # attach to sub features if they want it\n   foreach ( $self->get_SeqFeatures() ) {\n       $_->attach_seq($seq);\n   }\n   return 1;\n}\n\n=head2 seq()\n\n Usage   : $tseq = $sf->seq()\n Function: returns a truncated version of seq() with bounds matching this feature\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\nsub seq {\n  my ($self) = @_;\n\n  return unless defined($self->entire_seq());\n\n  my $seq = $self->entire_seq->trunc($self->start(), $self->end());\n\n  if ( defined $self->strand && $self->strand == -1 ) {\n    $seq = $seq->revcom;\n  }\n\n  return $seq;\n}\n\n=head2 entire_seq()\n\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    : none\n\n\nsub entire_seq {\n  return shift->{'seq'};\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::RangeI\n\n as inherited via Bio::SeqFeatureI\n\n\n=head2 length()\n\n Usage   : $feature->length()\n Function: Get the feature length computed as $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\nsub length {\n  my $self = shift;\n  return $self->end() - $self->start() + 1;\n}\n\n=head2 start()\n\n Usage   : $obj->start($newval)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub start {\n  my ($self,$value) = @_;\n  return $self->location->start($value);\n}\n\n=head2 end()\n\n Usage   : $obj->end($newval)\n Function: Get/set on the end coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub end {\n  my ($self,$value) = @_;\n  return $self->location->end($value);\n}\n\n=head2 strand()\n\n Usage   : $strand = $feat->strand($newval)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub strand {\n  my $self = shift;\n  return $self->location->strand(@_);\n}\n\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::FeatureHolderI\n\nThis includes methods for retrieving, adding, and removing\nfeatures. Since this is already a feature, features held by this\nfeature holder are essentially sub-features.\n\n\n=head2 get_SeqFeatures\n\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of Bio::SeqFeatureI objects\n Returns : An array\n Args    : none\n\n\nsub get_SeqFeatures {\n  return @{ shift->{'sub_array'} || []};\n}\n\n=head2 add_SeqFeature()\n\n Usage   : $feat->add_SeqFeature($subfeat);\n           $feat->add_SeqFeature($subfeat,'EXPAND')\n Function: adds a SeqFeature into the subSeqFeature array.\n           with no 'EXPAND' qualifer, subfeat will be tested\n           as to whether it lies inside the parent, and throw\n           an exception if not.\n\n           If EXPAND is used, the parent''s start/end/strand will\n           be adjusted so that it grows to accommodate the new\n           subFeature\n Example :\n Returns : nothing\n Args    : a Bio::SeqFeatureI object\n\n\nsub add_SeqFeature {\n  my ($self,$val, $expand) = @_;\n\n  return unless $val;\n\n  if ((!ref($val)) || !$val->isa('Bio::SeqFeatureI') ) {\n      $self->throw((ref($val) ? ref($val) : $val)\n                   .\" does not implement Bio::SeqFeatureI.\");\n  }\n\n  if($expand && ($expand eq 'EXPAND')) {\n      $self->_expand_region($val);\n  } else {\n      if ( !$self->contains($val) ) {\n\t  $self->warn(\"$val is not contained within parent feature, and expansion is not valid, ignoring.\");\n\t  return;\n      }\n  }\n\n  push(@{$self->{'sub_array'}},$val);\n}\n\n=head2 remove_SeqFeatures()\n\n Usage   : $obj->remove_SeqFeatures\n Function: Removes all sub SeqFeatures.  If you want to remove only a subset,\n           remove that subset from the returned array, and add back the rest.\n Returns : The array of Bio::SeqFeatureI implementing sub-features that was\n           deleted from this feature.\n Args    : none","label":"remove_SeqFeatures($self)"}},{"name":"%self","kind":13,"containerName":null,"line":915},{"name":"@subfeats","containerName":null,"kind":13,"line":916},{"signature":{"parameters":[{"label":"$obj"},{"label":"$value"}],"documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.\n\n\nsub seq_id {\n  my($self,$val) = @_;\n  if (defined($val)) {\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value =~ /^>/)) {\n\t  $self->throw('give seq_id() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('seq_id');\n      $self->add_Annotation('seq_id', $term);\n  }\n\n  $self->seq_id('.') unless $self->get_Annotations('seq_id'); # make sure we always have something\n\n  return ($self->get_Annotations('seq_id'))[0]->value;\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: human-readable name for the feature.\n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 type()\n\n Usage   : $obj->type($newval)\n Function: a SOFA type for the feature.\n Returns : Bio::Annotation::OntologyTerm object representing the type.\n           NB: to get a string, use primary_tag().\n Args    : on set, Bio::Annotation::OntologyTerm object.\n           NB: to set a string (SOFA name or identifier), use primary_tag()\n\n\nuse constant MAX_TYPE_CACHE_MEMBERS => 20;\nsub type {\n  my($self,$val) = @_;\n  if(defined($val)){\n    my $term = undef;\n\n    if(!ref($val)){\n      $self->throw(\"give type() a Bio::Annotation::OntologyTerm object, not a string\");\n    }\n    elsif(ref($val) && $val->isa('Bio::Annotation::OntologyTerm')){\n      $term = $val;\n    }\n    else {\n      #we have the wrong type of object\n      $self->throw('give type() a SOFA term name, identifier, or Bio::Annotation::OntologyTerm object, not '.$val);\n    }\n    $self->remove_Annotations('type');\n    $self->add_Annotation('type',$term);\n  }\n  \n  return $self->get_Annotations('type');\n}\n\n=head2 source()\n\n Usage   : $obj->source($newval)\n Function: holds the source of the feature.\n Returns : a Bio::Annotation::SimpleValue representing the source.\n           NB: to get a string, use source_tag()\n Args    : on set, a Bio::Annotation::SimpleValue object.\n           NB: to set a string, use source_tag()\n\n\nsub source {\n  my($self,$val) = @_;\n\n  if (defined($val)) {\n      my $term;\n      if (!ref($val)) {\n        $self->throw(\"give source() a Bio::Annotation::SimpleValue object, not a string\");\n        #$term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      } else {\n\t  $self->throw('give source() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('source');\n      $self->add_Annotation('source', $term);\n  }\n  \n  unless ($self->get_Annotations('source')) {\n    $self->source(Bio::Annotation::SimpleValue->new(-value => '.'));\n  }\n  return $self->get_Annotations('source');\n}\n\n=head2 score()\n\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: holds a value corresponding to the score of the feature.\n Returns : a string representing the score.\n Args    : on set, a scalar or a Bio::Annotation::SimpleValue object.\n\n\nsub score {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n\n      if ($term->value ne '.' &&\n           (!defined($term) || ($term->value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/))) {\n\t  $self->throw(\"'$val' is not a valid score\");\n      }\n      $self->remove_Annotations('score');\n      $self->add_Annotation('score', $term);\n  }\n\n  $self->score('.') unless scalar($self->get_Annotations('score')); # make sure we always have something\n\n  return ($self->get_Annotations('score'))[0]->display_text;\n}\n\n=head2 phase()\n\n Usage   : $phase = $feat->phase()\n           $feat->phase($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub phase {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid phase\");\n      }\n      $self->remove_Annotations('phase');\n      $self->add_Annotation('phase', $term);\n  }\n\n  $self->phase('.') unless $self->get_Annotations('phase'); # make sure we always have something\n  \n  return ($self->get_Annotations('phase'))[0]->value;\n}\n\n\n=head2 frame()\n\n Usage   : $frame = $feat->frame()\n           $feat->frame($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub frame {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid frame\");\n      }\n      $self->remove_Annotations('frame');\n      $self->add_Annotation('frame', $term);\n  }\n\n  $self->frame('.') unless $self->get_Annotations('frame'); # make sure we always have something\n  \n  return ($self->get_Annotations('frame'))[0]->value;\n}\n\n############################################################\n\n=head1 SHORTCUT METHODS TO ACCESS Bio::AnnotatableI INTERFACE METHODS\n\n\n=head2 add_Annotation()\n\n Usage   :\n Function: $obj->add_Annotation() is a shortcut to $obj->annotation->add_Annotation\n Returns : \n Args    :\n\n\nsub add_Annotation {\n  my ($self,@args) = @_;\n  return $self->annotation->add_Annotation(@args);\n}\n\n=head2 remove_Annotations()\n\n Usage   :\n Function: $obj->remove_Annotations() is a shortcut to $obj->annotation->remove_Annotations\n Returns : \n Args    :\n\n\nsub remove_Annotations {\n  my ($self,@args) = @_;\n  return $self->annotation->remove_Annotations(@args);\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::SeqFeatureI\n\nNote that no methods are deprecated.  Any SeqFeatureI methods must return\nstrings (no objects).\n\n\n=head2 display_name()\n\n\nsub display_name {\n  my $self = shift;\n  return $self->name(@_);\n}\n\n=head2 primary_tag()\n\n\nsub primary_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    my $term;\n    if(!ref($val) && $val){\n      #we have a plain text annotation coming in.  try to map it to SOFA.\n\n      our %__type_cache; #a little cache of plaintext types we've already seen\n\n      #clear our cache if it gets too big\n      if(scalar(keys %__type_cache) > MAX_TYPE_CACHE_MEMBERS) {\n        %__type_cache = ();\n      }\n\n      #set $term to either a cached value, or look up a new one, throwing\n      #up if not found\n      my $anntext = $val;\n      if ($__type_cache{$anntext}) {\n        $term = $__type_cache{$anntext};\n      } else {\n        my $sofa = Bio::Ontology::OntologyStore->get_instance->get_ontology('Sequence Ontology OBO');\n        my ($soterm) = $anntext =~ /^\\D+:\\d+$/ #does it look like an ident?\n          ? ($sofa->find_terms(-identifier => $anntext))[0] #yes, lookup by ident\n          : ($sofa->find_terms(-name => $anntext))[0];      #no, lookup by name\n        #throw if it's not in SOFA\n        unless($soterm){\n          $self->throw(\"couldn't find a SOFA term matching type '$val'.\");\n        }\n        my $newterm = Bio::Annotation::OntologyTerm->new;\n        $newterm->term($soterm);\n        $term = $newterm;\n      }\n      \n      $self->type($term);\n    }\n  }\n  \n  my $t = $self->type() || return;\n  return $t->name;\n}\n\n=head2 source_tag()\n\n\nsub source_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    if(!ref($val) && $val){\n      my $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      $self->source($term);\n    }\n  }\n  my $t = $self->source() || return;\n  return $t->display_text;\n}\n\n\n=head2 attach_seq()\n\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( ! ($seq && ref($seq) && $seq->isa(\"Bio::PrimarySeqI\")) ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'seq'} = $seq;\n\n   # attach to sub features if they want it\n   foreach ( $self->get_SeqFeatures() ) {\n       $_->attach_seq($seq);\n   }\n   return 1;\n}\n\n=head2 seq()\n\n Usage   : $tseq = $sf->seq()\n Function: returns a truncated version of seq() with bounds matching this feature\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\nsub seq {\n  my ($self) = @_;\n\n  return unless defined($self->entire_seq());\n\n  my $seq = $self->entire_seq->trunc($self->start(), $self->end());\n\n  if ( defined $self->strand && $self->strand == -1 ) {\n    $seq = $seq->revcom;\n  }\n\n  return $seq;\n}\n\n=head2 entire_seq()\n\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    : none\n\n\nsub entire_seq {\n  return shift->{'seq'};\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::RangeI\n\n as inherited via Bio::SeqFeatureI\n\n\n=head2 length()\n\n Usage   : $feature->length()\n Function: Get the feature length computed as $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\nsub length {\n  my $self = shift;\n  return $self->end() - $self->start() + 1;\n}\n\n=head2 start()\n\n Usage   : $obj->start($newval)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub start {\n  my ($self,$value) = @_;\n  return $self->location->start($value);\n}\n\n=head2 end()\n\n Usage   : $obj->end($newval)\n Function: Get/set on the end coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub end {\n  my ($self,$value) = @_;\n  return $self->location->end($value);\n}\n\n=head2 strand()\n\n Usage   : $strand = $feat->strand($newval)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub strand {\n  my $self = shift;\n  return $self->location->strand(@_);\n}\n\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::FeatureHolderI\n\nThis includes methods for retrieving, adding, and removing\nfeatures. Since this is already a feature, features held by this\nfeature holder are essentially sub-features.\n\n\n=head2 get_SeqFeatures\n\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of Bio::SeqFeatureI objects\n Returns : An array\n Args    : none\n\n\nsub get_SeqFeatures {\n  return @{ shift->{'sub_array'} || []};\n}\n\n=head2 add_SeqFeature()\n\n Usage   : $feat->add_SeqFeature($subfeat);\n           $feat->add_SeqFeature($subfeat,'EXPAND')\n Function: adds a SeqFeature into the subSeqFeature array.\n           with no 'EXPAND' qualifer, subfeat will be tested\n           as to whether it lies inside the parent, and throw\n           an exception if not.\n\n           If EXPAND is used, the parent''s start/end/strand will\n           be adjusted so that it grows to accommodate the new\n           subFeature\n Example :\n Returns : nothing\n Args    : a Bio::SeqFeatureI object\n\n\nsub add_SeqFeature {\n  my ($self,$val, $expand) = @_;\n\n  return unless $val;\n\n  if ((!ref($val)) || !$val->isa('Bio::SeqFeatureI') ) {\n      $self->throw((ref($val) ? ref($val) : $val)\n                   .\" does not implement Bio::SeqFeatureI.\");\n  }\n\n  if($expand && ($expand eq 'EXPAND')) {\n      $self->_expand_region($val);\n  } else {\n      if ( !$self->contains($val) ) {\n\t  $self->warn(\"$val is not contained within parent feature, and expansion is not valid, ignoring.\");\n\t  return;\n      }\n  }\n\n  push(@{$self->{'sub_array'}},$val);\n}\n\n=head2 remove_SeqFeatures()\n\n Usage   : $obj->remove_SeqFeatures\n Function: Removes all sub SeqFeatures.  If you want to remove only a subset,\n           remove that subset from the returned array, and add back the rest.\n Returns : The array of Bio::SeqFeatureI implementing sub-features that was\n           deleted from this feature.\n Args    : none\n\n\nsub remove_SeqFeatures {\n  my ($self) = @_;\n\n  my @subfeats = @{$self->{'sub_array'} || []};\n  $self->{'sub_array'} = []; # zap the array.\n  return @subfeats;\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::AnnotatableI\n\n\n=head2 annotation()\n\n Usage   : $obj->annotation($annot_obj)\n Function: Get/set the annotation collection object for annotating this\n           feature.\n Returns : A Bio::AnnotationCollectionI object\n Args    : newvalue (optional)","label":"annotation($obj,$value)"},"line":935,"range":{"end":{"character":9999,"line":945},"start":{"character":0,"line":935}},"kind":12,"definition":"sub","detail":"($obj,$value)","children":[{"definition":"my","line":936,"name":"$obj","containerName":"annotation","localvar":"my","kind":13},{"kind":13,"containerName":"annotation","name":"$value","line":936},{"line":940,"name":"$value","kind":13,"containerName":"annotation"},{"line":940,"name":"$obj","kind":13,"containerName":"annotation"},{"line":941,"containerName":"annotation","kind":13,"name":"$value"},{"line":941,"name":"new","kind":12,"containerName":"annotation"},{"name":"$value","kind":13,"containerName":"annotation","line":941},{"line":942,"containerName":"annotation","kind":13,"name":"$obj"},{"line":942,"containerName":"annotation","kind":13,"name":"$value"},{"name":"$obj","containerName":"annotation","kind":13,"line":944}],"name":"annotation","containerName":"main::"},{"name":"Bio","kind":12,"containerName":"Annotation::Collection","line":941},{"name":"location","containerName":"main::","children":[{"localvar":"my","containerName":"location","kind":13,"name":"$self","line":960,"definition":"my"},{"name":"$value","kind":13,"containerName":"location","line":960},{"name":"$value","kind":13,"containerName":"location","line":962},{"name":"$value","kind":13,"containerName":"location","line":963},{"containerName":"location","kind":13,"name":"$value","line":963},{"line":963,"kind":12,"containerName":"location","name":"isa"},{"name":"$self","containerName":"location","kind":13,"line":964},{"line":964,"kind":12,"containerName":"location","name":"throw"},{"name":"$self","containerName":"location","kind":13,"line":967},{"name":"$value","containerName":"location","kind":13,"line":967},{"line":969,"name":"$self","kind":13,"containerName":"location"},{"line":971,"kind":13,"containerName":"location","name":"$self"},{"line":971,"kind":12,"containerName":"location","name":"new"},{"kind":13,"containerName":"location","name":"$self","line":973}],"detail":"($self,$value)","definition":"sub","range":{"end":{"line":974,"character":9999},"start":{"character":0,"line":959}},"kind":12,"line":959,"signature":{"label":"location($self,$value)","documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.\n\n\nsub seq_id {\n  my($self,$val) = @_;\n  if (defined($val)) {\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value =~ /^>/)) {\n\t  $self->throw('give seq_id() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('seq_id');\n      $self->add_Annotation('seq_id', $term);\n  }\n\n  $self->seq_id('.') unless $self->get_Annotations('seq_id'); # make sure we always have something\n\n  return ($self->get_Annotations('seq_id'))[0]->value;\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: human-readable name for the feature.\n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 type()\n\n Usage   : $obj->type($newval)\n Function: a SOFA type for the feature.\n Returns : Bio::Annotation::OntologyTerm object representing the type.\n           NB: to get a string, use primary_tag().\n Args    : on set, Bio::Annotation::OntologyTerm object.\n           NB: to set a string (SOFA name or identifier), use primary_tag()\n\n\nuse constant MAX_TYPE_CACHE_MEMBERS => 20;\nsub type {\n  my($self,$val) = @_;\n  if(defined($val)){\n    my $term = undef;\n\n    if(!ref($val)){\n      $self->throw(\"give type() a Bio::Annotation::OntologyTerm object, not a string\");\n    }\n    elsif(ref($val) && $val->isa('Bio::Annotation::OntologyTerm')){\n      $term = $val;\n    }\n    else {\n      #we have the wrong type of object\n      $self->throw('give type() a SOFA term name, identifier, or Bio::Annotation::OntologyTerm object, not '.$val);\n    }\n    $self->remove_Annotations('type');\n    $self->add_Annotation('type',$term);\n  }\n  \n  return $self->get_Annotations('type');\n}\n\n=head2 source()\n\n Usage   : $obj->source($newval)\n Function: holds the source of the feature.\n Returns : a Bio::Annotation::SimpleValue representing the source.\n           NB: to get a string, use source_tag()\n Args    : on set, a Bio::Annotation::SimpleValue object.\n           NB: to set a string, use source_tag()\n\n\nsub source {\n  my($self,$val) = @_;\n\n  if (defined($val)) {\n      my $term;\n      if (!ref($val)) {\n        $self->throw(\"give source() a Bio::Annotation::SimpleValue object, not a string\");\n        #$term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      } else {\n\t  $self->throw('give source() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('source');\n      $self->add_Annotation('source', $term);\n  }\n  \n  unless ($self->get_Annotations('source')) {\n    $self->source(Bio::Annotation::SimpleValue->new(-value => '.'));\n  }\n  return $self->get_Annotations('source');\n}\n\n=head2 score()\n\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: holds a value corresponding to the score of the feature.\n Returns : a string representing the score.\n Args    : on set, a scalar or a Bio::Annotation::SimpleValue object.\n\n\nsub score {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n\n      if ($term->value ne '.' &&\n           (!defined($term) || ($term->value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/))) {\n\t  $self->throw(\"'$val' is not a valid score\");\n      }\n      $self->remove_Annotations('score');\n      $self->add_Annotation('score', $term);\n  }\n\n  $self->score('.') unless scalar($self->get_Annotations('score')); # make sure we always have something\n\n  return ($self->get_Annotations('score'))[0]->display_text;\n}\n\n=head2 phase()\n\n Usage   : $phase = $feat->phase()\n           $feat->phase($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub phase {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid phase\");\n      }\n      $self->remove_Annotations('phase');\n      $self->add_Annotation('phase', $term);\n  }\n\n  $self->phase('.') unless $self->get_Annotations('phase'); # make sure we always have something\n  \n  return ($self->get_Annotations('phase'))[0]->value;\n}\n\n\n=head2 frame()\n\n Usage   : $frame = $feat->frame()\n           $feat->frame($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub frame {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid frame\");\n      }\n      $self->remove_Annotations('frame');\n      $self->add_Annotation('frame', $term);\n  }\n\n  $self->frame('.') unless $self->get_Annotations('frame'); # make sure we always have something\n  \n  return ($self->get_Annotations('frame'))[0]->value;\n}\n\n############################################################\n\n=head1 SHORTCUT METHODS TO ACCESS Bio::AnnotatableI INTERFACE METHODS\n\n\n=head2 add_Annotation()\n\n Usage   :\n Function: $obj->add_Annotation() is a shortcut to $obj->annotation->add_Annotation\n Returns : \n Args    :\n\n\nsub add_Annotation {\n  my ($self,@args) = @_;\n  return $self->annotation->add_Annotation(@args);\n}\n\n=head2 remove_Annotations()\n\n Usage   :\n Function: $obj->remove_Annotations() is a shortcut to $obj->annotation->remove_Annotations\n Returns : \n Args    :\n\n\nsub remove_Annotations {\n  my ($self,@args) = @_;\n  return $self->annotation->remove_Annotations(@args);\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::SeqFeatureI\n\nNote that no methods are deprecated.  Any SeqFeatureI methods must return\nstrings (no objects).\n\n\n=head2 display_name()\n\n\nsub display_name {\n  my $self = shift;\n  return $self->name(@_);\n}\n\n=head2 primary_tag()\n\n\nsub primary_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    my $term;\n    if(!ref($val) && $val){\n      #we have a plain text annotation coming in.  try to map it to SOFA.\n\n      our %__type_cache; #a little cache of plaintext types we've already seen\n\n      #clear our cache if it gets too big\n      if(scalar(keys %__type_cache) > MAX_TYPE_CACHE_MEMBERS) {\n        %__type_cache = ();\n      }\n\n      #set $term to either a cached value, or look up a new one, throwing\n      #up if not found\n      my $anntext = $val;\n      if ($__type_cache{$anntext}) {\n        $term = $__type_cache{$anntext};\n      } else {\n        my $sofa = Bio::Ontology::OntologyStore->get_instance->get_ontology('Sequence Ontology OBO');\n        my ($soterm) = $anntext =~ /^\\D+:\\d+$/ #does it look like an ident?\n          ? ($sofa->find_terms(-identifier => $anntext))[0] #yes, lookup by ident\n          : ($sofa->find_terms(-name => $anntext))[0];      #no, lookup by name\n        #throw if it's not in SOFA\n        unless($soterm){\n          $self->throw(\"couldn't find a SOFA term matching type '$val'.\");\n        }\n        my $newterm = Bio::Annotation::OntologyTerm->new;\n        $newterm->term($soterm);\n        $term = $newterm;\n      }\n      \n      $self->type($term);\n    }\n  }\n  \n  my $t = $self->type() || return;\n  return $t->name;\n}\n\n=head2 source_tag()\n\n\nsub source_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    if(!ref($val) && $val){\n      my $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      $self->source($term);\n    }\n  }\n  my $t = $self->source() || return;\n  return $t->display_text;\n}\n\n\n=head2 attach_seq()\n\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( ! ($seq && ref($seq) && $seq->isa(\"Bio::PrimarySeqI\")) ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'seq'} = $seq;\n\n   # attach to sub features if they want it\n   foreach ( $self->get_SeqFeatures() ) {\n       $_->attach_seq($seq);\n   }\n   return 1;\n}\n\n=head2 seq()\n\n Usage   : $tseq = $sf->seq()\n Function: returns a truncated version of seq() with bounds matching this feature\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\nsub seq {\n  my ($self) = @_;\n\n  return unless defined($self->entire_seq());\n\n  my $seq = $self->entire_seq->trunc($self->start(), $self->end());\n\n  if ( defined $self->strand && $self->strand == -1 ) {\n    $seq = $seq->revcom;\n  }\n\n  return $seq;\n}\n\n=head2 entire_seq()\n\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    : none\n\n\nsub entire_seq {\n  return shift->{'seq'};\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::RangeI\n\n as inherited via Bio::SeqFeatureI\n\n\n=head2 length()\n\n Usage   : $feature->length()\n Function: Get the feature length computed as $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\nsub length {\n  my $self = shift;\n  return $self->end() - $self->start() + 1;\n}\n\n=head2 start()\n\n Usage   : $obj->start($newval)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub start {\n  my ($self,$value) = @_;\n  return $self->location->start($value);\n}\n\n=head2 end()\n\n Usage   : $obj->end($newval)\n Function: Get/set on the end coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub end {\n  my ($self,$value) = @_;\n  return $self->location->end($value);\n}\n\n=head2 strand()\n\n Usage   : $strand = $feat->strand($newval)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub strand {\n  my $self = shift;\n  return $self->location->strand(@_);\n}\n\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::FeatureHolderI\n\nThis includes methods for retrieving, adding, and removing\nfeatures. Since this is already a feature, features held by this\nfeature holder are essentially sub-features.\n\n\n=head2 get_SeqFeatures\n\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of Bio::SeqFeatureI objects\n Returns : An array\n Args    : none\n\n\nsub get_SeqFeatures {\n  return @{ shift->{'sub_array'} || []};\n}\n\n=head2 add_SeqFeature()\n\n Usage   : $feat->add_SeqFeature($subfeat);\n           $feat->add_SeqFeature($subfeat,'EXPAND')\n Function: adds a SeqFeature into the subSeqFeature array.\n           with no 'EXPAND' qualifer, subfeat will be tested\n           as to whether it lies inside the parent, and throw\n           an exception if not.\n\n           If EXPAND is used, the parent''s start/end/strand will\n           be adjusted so that it grows to accommodate the new\n           subFeature\n Example :\n Returns : nothing\n Args    : a Bio::SeqFeatureI object\n\n\nsub add_SeqFeature {\n  my ($self,$val, $expand) = @_;\n\n  return unless $val;\n\n  if ((!ref($val)) || !$val->isa('Bio::SeqFeatureI') ) {\n      $self->throw((ref($val) ? ref($val) : $val)\n                   .\" does not implement Bio::SeqFeatureI.\");\n  }\n\n  if($expand && ($expand eq 'EXPAND')) {\n      $self->_expand_region($val);\n  } else {\n      if ( !$self->contains($val) ) {\n\t  $self->warn(\"$val is not contained within parent feature, and expansion is not valid, ignoring.\");\n\t  return;\n      }\n  }\n\n  push(@{$self->{'sub_array'}},$val);\n}\n\n=head2 remove_SeqFeatures()\n\n Usage   : $obj->remove_SeqFeatures\n Function: Removes all sub SeqFeatures.  If you want to remove only a subset,\n           remove that subset from the returned array, and add back the rest.\n Returns : The array of Bio::SeqFeatureI implementing sub-features that was\n           deleted from this feature.\n Args    : none\n\n\nsub remove_SeqFeatures {\n  my ($self) = @_;\n\n  my @subfeats = @{$self->{'sub_array'} || []};\n  $self->{'sub_array'} = []; # zap the array.\n  return @subfeats;\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::AnnotatableI\n\n\n=head2 annotation()\n\n Usage   : $obj->annotation($annot_obj)\n Function: Get/set the annotation collection object for annotating this\n           feature.\n Returns : A Bio::AnnotationCollectionI object\n Args    : newvalue (optional)\n\n\nsub annotation {\n    my ($obj,$value) = @_;\n\n    # we are smart if someone references the object and there hasn't been\n    # one set yet\n    if(defined $value || ! defined $obj->{'annotation'} ) {\n        $value = Bio::Annotation::Collection->new() unless ( defined $value );\n        $obj->{'annotation'} = $value;\n    }\n    return $obj->{'annotation'};\n}\n\n############################################################\n\n=head2 location()\n\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n           of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : [optional] Bio::LocationI object to set the value to.","parameters":[{"label":"$self"},{"label":"$value"}]}},{"line":971,"kind":12,"containerName":"Location::Simple","name":"Bio"},{"definition":"sub","detail":"($self,$seq)","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"add_target","line":986},{"kind":13,"containerName":"add_target","name":"$seq","line":986},{"kind":13,"containerName":"add_target","name":"$self","line":987},{"line":987,"name":"throw","kind":12,"containerName":"add_target"},{"name":"$seq","containerName":"add_target","kind":13,"line":987},{"kind":12,"containerName":"add_target","name":"isa","line":987},{"name":"$self","containerName":"add_target","kind":13,"line":988}],"name":"add_target","containerName":"main::","signature":{"label":"add_target($self,$seq)","documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.\n\n\nsub seq_id {\n  my($self,$val) = @_;\n  if (defined($val)) {\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value =~ /^>/)) {\n\t  $self->throw('give seq_id() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('seq_id');\n      $self->add_Annotation('seq_id', $term);\n  }\n\n  $self->seq_id('.') unless $self->get_Annotations('seq_id'); # make sure we always have something\n\n  return ($self->get_Annotations('seq_id'))[0]->value;\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: human-readable name for the feature.\n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 type()\n\n Usage   : $obj->type($newval)\n Function: a SOFA type for the feature.\n Returns : Bio::Annotation::OntologyTerm object representing the type.\n           NB: to get a string, use primary_tag().\n Args    : on set, Bio::Annotation::OntologyTerm object.\n           NB: to set a string (SOFA name or identifier), use primary_tag()\n\n\nuse constant MAX_TYPE_CACHE_MEMBERS => 20;\nsub type {\n  my($self,$val) = @_;\n  if(defined($val)){\n    my $term = undef;\n\n    if(!ref($val)){\n      $self->throw(\"give type() a Bio::Annotation::OntologyTerm object, not a string\");\n    }\n    elsif(ref($val) && $val->isa('Bio::Annotation::OntologyTerm')){\n      $term = $val;\n    }\n    else {\n      #we have the wrong type of object\n      $self->throw('give type() a SOFA term name, identifier, or Bio::Annotation::OntologyTerm object, not '.$val);\n    }\n    $self->remove_Annotations('type');\n    $self->add_Annotation('type',$term);\n  }\n  \n  return $self->get_Annotations('type');\n}\n\n=head2 source()\n\n Usage   : $obj->source($newval)\n Function: holds the source of the feature.\n Returns : a Bio::Annotation::SimpleValue representing the source.\n           NB: to get a string, use source_tag()\n Args    : on set, a Bio::Annotation::SimpleValue object.\n           NB: to set a string, use source_tag()\n\n\nsub source {\n  my($self,$val) = @_;\n\n  if (defined($val)) {\n      my $term;\n      if (!ref($val)) {\n        $self->throw(\"give source() a Bio::Annotation::SimpleValue object, not a string\");\n        #$term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      } else {\n\t  $self->throw('give source() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('source');\n      $self->add_Annotation('source', $term);\n  }\n  \n  unless ($self->get_Annotations('source')) {\n    $self->source(Bio::Annotation::SimpleValue->new(-value => '.'));\n  }\n  return $self->get_Annotations('source');\n}\n\n=head2 score()\n\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: holds a value corresponding to the score of the feature.\n Returns : a string representing the score.\n Args    : on set, a scalar or a Bio::Annotation::SimpleValue object.\n\n\nsub score {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n\n      if ($term->value ne '.' &&\n           (!defined($term) || ($term->value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/))) {\n\t  $self->throw(\"'$val' is not a valid score\");\n      }\n      $self->remove_Annotations('score');\n      $self->add_Annotation('score', $term);\n  }\n\n  $self->score('.') unless scalar($self->get_Annotations('score')); # make sure we always have something\n\n  return ($self->get_Annotations('score'))[0]->display_text;\n}\n\n=head2 phase()\n\n Usage   : $phase = $feat->phase()\n           $feat->phase($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub phase {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid phase\");\n      }\n      $self->remove_Annotations('phase');\n      $self->add_Annotation('phase', $term);\n  }\n\n  $self->phase('.') unless $self->get_Annotations('phase'); # make sure we always have something\n  \n  return ($self->get_Annotations('phase'))[0]->value;\n}\n\n\n=head2 frame()\n\n Usage   : $frame = $feat->frame()\n           $feat->frame($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub frame {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid frame\");\n      }\n      $self->remove_Annotations('frame');\n      $self->add_Annotation('frame', $term);\n  }\n\n  $self->frame('.') unless $self->get_Annotations('frame'); # make sure we always have something\n  \n  return ($self->get_Annotations('frame'))[0]->value;\n}\n\n############################################################\n\n=head1 SHORTCUT METHODS TO ACCESS Bio::AnnotatableI INTERFACE METHODS\n\n\n=head2 add_Annotation()\n\n Usage   :\n Function: $obj->add_Annotation() is a shortcut to $obj->annotation->add_Annotation\n Returns : \n Args    :\n\n\nsub add_Annotation {\n  my ($self,@args) = @_;\n  return $self->annotation->add_Annotation(@args);\n}\n\n=head2 remove_Annotations()\n\n Usage   :\n Function: $obj->remove_Annotations() is a shortcut to $obj->annotation->remove_Annotations\n Returns : \n Args    :\n\n\nsub remove_Annotations {\n  my ($self,@args) = @_;\n  return $self->annotation->remove_Annotations(@args);\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::SeqFeatureI\n\nNote that no methods are deprecated.  Any SeqFeatureI methods must return\nstrings (no objects).\n\n\n=head2 display_name()\n\n\nsub display_name {\n  my $self = shift;\n  return $self->name(@_);\n}\n\n=head2 primary_tag()\n\n\nsub primary_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    my $term;\n    if(!ref($val) && $val){\n      #we have a plain text annotation coming in.  try to map it to SOFA.\n\n      our %__type_cache; #a little cache of plaintext types we've already seen\n\n      #clear our cache if it gets too big\n      if(scalar(keys %__type_cache) > MAX_TYPE_CACHE_MEMBERS) {\n        %__type_cache = ();\n      }\n\n      #set $term to either a cached value, or look up a new one, throwing\n      #up if not found\n      my $anntext = $val;\n      if ($__type_cache{$anntext}) {\n        $term = $__type_cache{$anntext};\n      } else {\n        my $sofa = Bio::Ontology::OntologyStore->get_instance->get_ontology('Sequence Ontology OBO');\n        my ($soterm) = $anntext =~ /^\\D+:\\d+$/ #does it look like an ident?\n          ? ($sofa->find_terms(-identifier => $anntext))[0] #yes, lookup by ident\n          : ($sofa->find_terms(-name => $anntext))[0];      #no, lookup by name\n        #throw if it's not in SOFA\n        unless($soterm){\n          $self->throw(\"couldn't find a SOFA term matching type '$val'.\");\n        }\n        my $newterm = Bio::Annotation::OntologyTerm->new;\n        $newterm->term($soterm);\n        $term = $newterm;\n      }\n      \n      $self->type($term);\n    }\n  }\n  \n  my $t = $self->type() || return;\n  return $t->name;\n}\n\n=head2 source_tag()\n\n\nsub source_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    if(!ref($val) && $val){\n      my $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      $self->source($term);\n    }\n  }\n  my $t = $self->source() || return;\n  return $t->display_text;\n}\n\n\n=head2 attach_seq()\n\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( ! ($seq && ref($seq) && $seq->isa(\"Bio::PrimarySeqI\")) ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'seq'} = $seq;\n\n   # attach to sub features if they want it\n   foreach ( $self->get_SeqFeatures() ) {\n       $_->attach_seq($seq);\n   }\n   return 1;\n}\n\n=head2 seq()\n\n Usage   : $tseq = $sf->seq()\n Function: returns a truncated version of seq() with bounds matching this feature\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\nsub seq {\n  my ($self) = @_;\n\n  return unless defined($self->entire_seq());\n\n  my $seq = $self->entire_seq->trunc($self->start(), $self->end());\n\n  if ( defined $self->strand && $self->strand == -1 ) {\n    $seq = $seq->revcom;\n  }\n\n  return $seq;\n}\n\n=head2 entire_seq()\n\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    : none\n\n\nsub entire_seq {\n  return shift->{'seq'};\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::RangeI\n\n as inherited via Bio::SeqFeatureI\n\n\n=head2 length()\n\n Usage   : $feature->length()\n Function: Get the feature length computed as $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\nsub length {\n  my $self = shift;\n  return $self->end() - $self->start() + 1;\n}\n\n=head2 start()\n\n Usage   : $obj->start($newval)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub start {\n  my ($self,$value) = @_;\n  return $self->location->start($value);\n}\n\n=head2 end()\n\n Usage   : $obj->end($newval)\n Function: Get/set on the end coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub end {\n  my ($self,$value) = @_;\n  return $self->location->end($value);\n}\n\n=head2 strand()\n\n Usage   : $strand = $feat->strand($newval)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub strand {\n  my $self = shift;\n  return $self->location->strand(@_);\n}\n\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::FeatureHolderI\n\nThis includes methods for retrieving, adding, and removing\nfeatures. Since this is already a feature, features held by this\nfeature holder are essentially sub-features.\n\n\n=head2 get_SeqFeatures\n\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of Bio::SeqFeatureI objects\n Returns : An array\n Args    : none\n\n\nsub get_SeqFeatures {\n  return @{ shift->{'sub_array'} || []};\n}\n\n=head2 add_SeqFeature()\n\n Usage   : $feat->add_SeqFeature($subfeat);\n           $feat->add_SeqFeature($subfeat,'EXPAND')\n Function: adds a SeqFeature into the subSeqFeature array.\n           with no 'EXPAND' qualifer, subfeat will be tested\n           as to whether it lies inside the parent, and throw\n           an exception if not.\n\n           If EXPAND is used, the parent''s start/end/strand will\n           be adjusted so that it grows to accommodate the new\n           subFeature\n Example :\n Returns : nothing\n Args    : a Bio::SeqFeatureI object\n\n\nsub add_SeqFeature {\n  my ($self,$val, $expand) = @_;\n\n  return unless $val;\n\n  if ((!ref($val)) || !$val->isa('Bio::SeqFeatureI') ) {\n      $self->throw((ref($val) ? ref($val) : $val)\n                   .\" does not implement Bio::SeqFeatureI.\");\n  }\n\n  if($expand && ($expand eq 'EXPAND')) {\n      $self->_expand_region($val);\n  } else {\n      if ( !$self->contains($val) ) {\n\t  $self->warn(\"$val is not contained within parent feature, and expansion is not valid, ignoring.\");\n\t  return;\n      }\n  }\n\n  push(@{$self->{'sub_array'}},$val);\n}\n\n=head2 remove_SeqFeatures()\n\n Usage   : $obj->remove_SeqFeatures\n Function: Removes all sub SeqFeatures.  If you want to remove only a subset,\n           remove that subset from the returned array, and add back the rest.\n Returns : The array of Bio::SeqFeatureI implementing sub-features that was\n           deleted from this feature.\n Args    : none\n\n\nsub remove_SeqFeatures {\n  my ($self) = @_;\n\n  my @subfeats = @{$self->{'sub_array'} || []};\n  $self->{'sub_array'} = []; # zap the array.\n  return @subfeats;\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::AnnotatableI\n\n\n=head2 annotation()\n\n Usage   : $obj->annotation($annot_obj)\n Function: Get/set the annotation collection object for annotating this\n           feature.\n Returns : A Bio::AnnotationCollectionI object\n Args    : newvalue (optional)\n\n\nsub annotation {\n    my ($obj,$value) = @_;\n\n    # we are smart if someone references the object and there hasn't been\n    # one set yet\n    if(defined $value || ! defined $obj->{'annotation'} ) {\n        $value = Bio::Annotation::Collection->new() unless ( defined $value );\n        $obj->{'annotation'} = $value;\n    }\n    return $obj->{'annotation'};\n}\n\n############################################################\n\n=head2 location()\n\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n           of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : [optional] Bio::LocationI object to set the value to.\n\n\nsub location {\n  my($self, $value ) = @_;\n\n  if (defined($value)) {\n    unless (ref($value) and $value->isa('Bio::LocationI')) {\n      $self->throw(\"object $value pretends to be a location but \".\n                   \"does not implement Bio::LocationI\");\n    }\n    $self->{'location'} = $value;\n  }\n  elsif (! $self->{'location'}) {\n    # guarantees a real location object is returned every time\n    $self->{'location'} = Bio::Location::Simple->new();\n  }\n  return $self->{'location'};\n}\n\n=head2 add_target()\n\n Usage   : $seqfeature->add_target(Bio::LocatableSeq->new(...));\n Function: adds a target location on another reference sequence for this feature\n Returns : true on success\n Args    : a Bio::LocatableSeq object","parameters":[{"label":"$self"},{"label":"$seq"}]},"line":985,"range":{"start":{"line":985,"character":0},"end":{"line":988,"character":9999}},"kind":12},{"line":988,"name":"$seq","containerName":null,"kind":13},{"line":989,"name":"$seq","kind":13,"containerName":null},{"signature":{"documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.\n\n\nsub seq_id {\n  my($self,$val) = @_;\n  if (defined($val)) {\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value =~ /^>/)) {\n\t  $self->throw('give seq_id() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('seq_id');\n      $self->add_Annotation('seq_id', $term);\n  }\n\n  $self->seq_id('.') unless $self->get_Annotations('seq_id'); # make sure we always have something\n\n  return ($self->get_Annotations('seq_id'))[0]->value;\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: human-readable name for the feature.\n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 type()\n\n Usage   : $obj->type($newval)\n Function: a SOFA type for the feature.\n Returns : Bio::Annotation::OntologyTerm object representing the type.\n           NB: to get a string, use primary_tag().\n Args    : on set, Bio::Annotation::OntologyTerm object.\n           NB: to set a string (SOFA name or identifier), use primary_tag()\n\n\nuse constant MAX_TYPE_CACHE_MEMBERS => 20;\nsub type {\n  my($self,$val) = @_;\n  if(defined($val)){\n    my $term = undef;\n\n    if(!ref($val)){\n      $self->throw(\"give type() a Bio::Annotation::OntologyTerm object, not a string\");\n    }\n    elsif(ref($val) && $val->isa('Bio::Annotation::OntologyTerm')){\n      $term = $val;\n    }\n    else {\n      #we have the wrong type of object\n      $self->throw('give type() a SOFA term name, identifier, or Bio::Annotation::OntologyTerm object, not '.$val);\n    }\n    $self->remove_Annotations('type');\n    $self->add_Annotation('type',$term);\n  }\n  \n  return $self->get_Annotations('type');\n}\n\n=head2 source()\n\n Usage   : $obj->source($newval)\n Function: holds the source of the feature.\n Returns : a Bio::Annotation::SimpleValue representing the source.\n           NB: to get a string, use source_tag()\n Args    : on set, a Bio::Annotation::SimpleValue object.\n           NB: to set a string, use source_tag()\n\n\nsub source {\n  my($self,$val) = @_;\n\n  if (defined($val)) {\n      my $term;\n      if (!ref($val)) {\n        $self->throw(\"give source() a Bio::Annotation::SimpleValue object, not a string\");\n        #$term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      } else {\n\t  $self->throw('give source() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('source');\n      $self->add_Annotation('source', $term);\n  }\n  \n  unless ($self->get_Annotations('source')) {\n    $self->source(Bio::Annotation::SimpleValue->new(-value => '.'));\n  }\n  return $self->get_Annotations('source');\n}\n\n=head2 score()\n\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: holds a value corresponding to the score of the feature.\n Returns : a string representing the score.\n Args    : on set, a scalar or a Bio::Annotation::SimpleValue object.\n\n\nsub score {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n\n      if ($term->value ne '.' &&\n           (!defined($term) || ($term->value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/))) {\n\t  $self->throw(\"'$val' is not a valid score\");\n      }\n      $self->remove_Annotations('score');\n      $self->add_Annotation('score', $term);\n  }\n\n  $self->score('.') unless scalar($self->get_Annotations('score')); # make sure we always have something\n\n  return ($self->get_Annotations('score'))[0]->display_text;\n}\n\n=head2 phase()\n\n Usage   : $phase = $feat->phase()\n           $feat->phase($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub phase {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid phase\");\n      }\n      $self->remove_Annotations('phase');\n      $self->add_Annotation('phase', $term);\n  }\n\n  $self->phase('.') unless $self->get_Annotations('phase'); # make sure we always have something\n  \n  return ($self->get_Annotations('phase'))[0]->value;\n}\n\n\n=head2 frame()\n\n Usage   : $frame = $feat->frame()\n           $feat->frame($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub frame {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid frame\");\n      }\n      $self->remove_Annotations('frame');\n      $self->add_Annotation('frame', $term);\n  }\n\n  $self->frame('.') unless $self->get_Annotations('frame'); # make sure we always have something\n  \n  return ($self->get_Annotations('frame'))[0]->value;\n}\n\n############################################################\n\n=head1 SHORTCUT METHODS TO ACCESS Bio::AnnotatableI INTERFACE METHODS\n\n\n=head2 add_Annotation()\n\n Usage   :\n Function: $obj->add_Annotation() is a shortcut to $obj->annotation->add_Annotation\n Returns : \n Args    :\n\n\nsub add_Annotation {\n  my ($self,@args) = @_;\n  return $self->annotation->add_Annotation(@args);\n}\n\n=head2 remove_Annotations()\n\n Usage   :\n Function: $obj->remove_Annotations() is a shortcut to $obj->annotation->remove_Annotations\n Returns : \n Args    :\n\n\nsub remove_Annotations {\n  my ($self,@args) = @_;\n  return $self->annotation->remove_Annotations(@args);\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::SeqFeatureI\n\nNote that no methods are deprecated.  Any SeqFeatureI methods must return\nstrings (no objects).\n\n\n=head2 display_name()\n\n\nsub display_name {\n  my $self = shift;\n  return $self->name(@_);\n}\n\n=head2 primary_tag()\n\n\nsub primary_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    my $term;\n    if(!ref($val) && $val){\n      #we have a plain text annotation coming in.  try to map it to SOFA.\n\n      our %__type_cache; #a little cache of plaintext types we've already seen\n\n      #clear our cache if it gets too big\n      if(scalar(keys %__type_cache) > MAX_TYPE_CACHE_MEMBERS) {\n        %__type_cache = ();\n      }\n\n      #set $term to either a cached value, or look up a new one, throwing\n      #up if not found\n      my $anntext = $val;\n      if ($__type_cache{$anntext}) {\n        $term = $__type_cache{$anntext};\n      } else {\n        my $sofa = Bio::Ontology::OntologyStore->get_instance->get_ontology('Sequence Ontology OBO');\n        my ($soterm) = $anntext =~ /^\\D+:\\d+$/ #does it look like an ident?\n          ? ($sofa->find_terms(-identifier => $anntext))[0] #yes, lookup by ident\n          : ($sofa->find_terms(-name => $anntext))[0];      #no, lookup by name\n        #throw if it's not in SOFA\n        unless($soterm){\n          $self->throw(\"couldn't find a SOFA term matching type '$val'.\");\n        }\n        my $newterm = Bio::Annotation::OntologyTerm->new;\n        $newterm->term($soterm);\n        $term = $newterm;\n      }\n      \n      $self->type($term);\n    }\n  }\n  \n  my $t = $self->type() || return;\n  return $t->name;\n}\n\n=head2 source_tag()\n\n\nsub source_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    if(!ref($val) && $val){\n      my $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      $self->source($term);\n    }\n  }\n  my $t = $self->source() || return;\n  return $t->display_text;\n}\n\n\n=head2 attach_seq()\n\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( ! ($seq && ref($seq) && $seq->isa(\"Bio::PrimarySeqI\")) ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'seq'} = $seq;\n\n   # attach to sub features if they want it\n   foreach ( $self->get_SeqFeatures() ) {\n       $_->attach_seq($seq);\n   }\n   return 1;\n}\n\n=head2 seq()\n\n Usage   : $tseq = $sf->seq()\n Function: returns a truncated version of seq() with bounds matching this feature\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\nsub seq {\n  my ($self) = @_;\n\n  return unless defined($self->entire_seq());\n\n  my $seq = $self->entire_seq->trunc($self->start(), $self->end());\n\n  if ( defined $self->strand && $self->strand == -1 ) {\n    $seq = $seq->revcom;\n  }\n\n  return $seq;\n}\n\n=head2 entire_seq()\n\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    : none\n\n\nsub entire_seq {\n  return shift->{'seq'};\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::RangeI\n\n as inherited via Bio::SeqFeatureI\n\n\n=head2 length()\n\n Usage   : $feature->length()\n Function: Get the feature length computed as $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\nsub length {\n  my $self = shift;\n  return $self->end() - $self->start() + 1;\n}\n\n=head2 start()\n\n Usage   : $obj->start($newval)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub start {\n  my ($self,$value) = @_;\n  return $self->location->start($value);\n}\n\n=head2 end()\n\n Usage   : $obj->end($newval)\n Function: Get/set on the end coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub end {\n  my ($self,$value) = @_;\n  return $self->location->end($value);\n}\n\n=head2 strand()\n\n Usage   : $strand = $feat->strand($newval)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub strand {\n  my $self = shift;\n  return $self->location->strand(@_);\n}\n\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::FeatureHolderI\n\nThis includes methods for retrieving, adding, and removing\nfeatures. Since this is already a feature, features held by this\nfeature holder are essentially sub-features.\n\n\n=head2 get_SeqFeatures\n\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of Bio::SeqFeatureI objects\n Returns : An array\n Args    : none\n\n\nsub get_SeqFeatures {\n  return @{ shift->{'sub_array'} || []};\n}\n\n=head2 add_SeqFeature()\n\n Usage   : $feat->add_SeqFeature($subfeat);\n           $feat->add_SeqFeature($subfeat,'EXPAND')\n Function: adds a SeqFeature into the subSeqFeature array.\n           with no 'EXPAND' qualifer, subfeat will be tested\n           as to whether it lies inside the parent, and throw\n           an exception if not.\n\n           If EXPAND is used, the parent''s start/end/strand will\n           be adjusted so that it grows to accommodate the new\n           subFeature\n Example :\n Returns : nothing\n Args    : a Bio::SeqFeatureI object\n\n\nsub add_SeqFeature {\n  my ($self,$val, $expand) = @_;\n\n  return unless $val;\n\n  if ((!ref($val)) || !$val->isa('Bio::SeqFeatureI') ) {\n      $self->throw((ref($val) ? ref($val) : $val)\n                   .\" does not implement Bio::SeqFeatureI.\");\n  }\n\n  if($expand && ($expand eq 'EXPAND')) {\n      $self->_expand_region($val);\n  } else {\n      if ( !$self->contains($val) ) {\n\t  $self->warn(\"$val is not contained within parent feature, and expansion is not valid, ignoring.\");\n\t  return;\n      }\n  }\n\n  push(@{$self->{'sub_array'}},$val);\n}\n\n=head2 remove_SeqFeatures()\n\n Usage   : $obj->remove_SeqFeatures\n Function: Removes all sub SeqFeatures.  If you want to remove only a subset,\n           remove that subset from the returned array, and add back the rest.\n Returns : The array of Bio::SeqFeatureI implementing sub-features that was\n           deleted from this feature.\n Args    : none\n\n\nsub remove_SeqFeatures {\n  my ($self) = @_;\n\n  my @subfeats = @{$self->{'sub_array'} || []};\n  $self->{'sub_array'} = []; # zap the array.\n  return @subfeats;\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::AnnotatableI\n\n\n=head2 annotation()\n\n Usage   : $obj->annotation($annot_obj)\n Function: Get/set the annotation collection object for annotating this\n           feature.\n Returns : A Bio::AnnotationCollectionI object\n Args    : newvalue (optional)\n\n\nsub annotation {\n    my ($obj,$value) = @_;\n\n    # we are smart if someone references the object and there hasn't been\n    # one set yet\n    if(defined $value || ! defined $obj->{'annotation'} ) {\n        $value = Bio::Annotation::Collection->new() unless ( defined $value );\n        $obj->{'annotation'} = $value;\n    }\n    return $obj->{'annotation'};\n}\n\n############################################################\n\n=head2 location()\n\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n           of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : [optional] Bio::LocationI object to set the value to.\n\n\nsub location {\n  my($self, $value ) = @_;\n\n  if (defined($value)) {\n    unless (ref($value) and $value->isa('Bio::LocationI')) {\n      $self->throw(\"object $value pretends to be a location but \".\n                   \"does not implement Bio::LocationI\");\n    }\n    $self->{'location'} = $value;\n  }\n  elsif (! $self->{'location'}) {\n    # guarantees a real location object is returned every time\n    $self->{'location'} = Bio::Location::Simple->new();\n  }\n  return $self->{'location'};\n}\n\n=head2 add_target()\n\n Usage   : $seqfeature->add_target(Bio::LocatableSeq->new(...));\n Function: adds a target location on another reference sequence for this feature\n Returns : true on success\n Args    : a Bio::LocatableSeq object\n\n\nsub add_target {\n  my ($self,$seq) = @_;\n  $self->throw(\"$seq is not a Bio::LocatableSeq, bailing out\") unless ref($seq) and seq->isa('Bio::LocatableSeq');\n  push @{ $self->{'targets'} }, $seq;\n  return $seq;\n}\n\n=head2 each_target()\n\n Usage   : @targets = $seqfeature->each_target();\n Function: Returns a list of Bio::LocatableSeqs which are the locations of this object.\n           To obtain the \"primary\" location, see L</location()>.\n Returns : a list of 0..N Bio::LocatableSeq objects\n Args    : none","parameters":[{"label":"$self"}],"label":"each_target($self)"},"line":1002,"kind":12,"range":{"end":{"character":9999,"line":1004},"start":{"character":0,"line":1002}},"definition":"sub","detail":"($self)","children":[{"definition":"my","line":1003,"localvar":"my","containerName":"each_target","kind":13,"name":"$self"},{"name":"$self","containerName":"each_target","kind":13,"line":1004},{"name":"$self","containerName":"each_target","kind":13,"line":1004}],"name":"each_target","containerName":"main::"},{"definition":"sub","detail":"($self,$feat)","children":[{"line":1022,"kind":13,"localvar":"my","containerName":"_expand_region","name":"$self","definition":"my"},{"line":1022,"name":"$feat","kind":13,"containerName":"_expand_region"},{"line":1023,"name":"$feat","kind":13,"containerName":"_expand_region"},{"line":1023,"kind":12,"containerName":"_expand_region","name":"isa"},{"line":1024,"containerName":"_expand_region","kind":13,"name":"$self"},{"line":1024,"name":"warn","containerName":"_expand_region","kind":12},{"line":1027,"kind":13,"containerName":"_expand_region","name":"$self"},{"line":1027,"name":"start","containerName":"_expand_region","kind":12},{"containerName":"_expand_region","kind":13,"name":"$self","line":1027},{"kind":12,"containerName":"_expand_region","name":"end","line":1027},{"name":"$self","containerName":"_expand_region","kind":13,"line":1028},{"name":"start","kind":12,"containerName":"_expand_region","line":1028},{"line":1028,"kind":13,"containerName":"_expand_region","name":"$feat"},{"kind":12,"containerName":"_expand_region","name":"start","line":1028},{"line":1029,"kind":13,"containerName":"_expand_region","name":"$self"},{"line":1029,"name":"end","containerName":"_expand_region","kind":12},{"line":1029,"containerName":"_expand_region","kind":13,"name":"$feat"},{"line":1029,"name":"end","kind":12,"containerName":"_expand_region"},{"line":1030,"name":"$self","kind":13,"containerName":"_expand_region"},{"kind":12,"containerName":"_expand_region","name":"strand","line":1030},{"line":1030,"name":"$feat","containerName":"_expand_region","kind":13},{"line":1030,"name":"strand","containerName":"_expand_region","kind":12},{"name":"$self","kind":13,"containerName":"_expand_region","line":1030},{"kind":12,"containerName":"_expand_region","name":"strand","line":1030},{"line":1033,"name":"$range","localvar":"my","kind":13,"containerName":"_expand_region","definition":"my"},{"name":"$self","kind":13,"containerName":"_expand_region","line":1033},{"name":"union","kind":12,"containerName":"_expand_region","line":1033},{"line":1033,"name":"$feat","containerName":"_expand_region","kind":13},{"line":1034,"name":"$self","kind":13,"containerName":"_expand_region"},{"name":"start","containerName":"_expand_region","kind":12,"line":1034},{"line":1034,"name":"$range","containerName":"_expand_region","kind":13},{"line":1034,"containerName":"_expand_region","kind":12,"name":"start"},{"line":1035,"name":"$self","kind":13,"containerName":"_expand_region"},{"line":1035,"name":"end","containerName":"_expand_region","kind":12},{"line":1035,"kind":13,"containerName":"_expand_region","name":"$range"},{"line":1035,"kind":12,"containerName":"_expand_region","name":"end"},{"line":1036,"name":"$self","containerName":"_expand_region","kind":13},{"line":1036,"containerName":"_expand_region","kind":12,"name":"strand"},{"line":1036,"name":"$range","kind":13,"containerName":"_expand_region"},{"name":"strand","kind":12,"containerName":"_expand_region","line":1036}],"containerName":"main::","name":"_expand_region","signature":{"documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.\n\n\nsub seq_id {\n  my($self,$val) = @_;\n  if (defined($val)) {\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value =~ /^>/)) {\n\t  $self->throw('give seq_id() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('seq_id');\n      $self->add_Annotation('seq_id', $term);\n  }\n\n  $self->seq_id('.') unless $self->get_Annotations('seq_id'); # make sure we always have something\n\n  return ($self->get_Annotations('seq_id'))[0]->value;\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: human-readable name for the feature.\n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 type()\n\n Usage   : $obj->type($newval)\n Function: a SOFA type for the feature.\n Returns : Bio::Annotation::OntologyTerm object representing the type.\n           NB: to get a string, use primary_tag().\n Args    : on set, Bio::Annotation::OntologyTerm object.\n           NB: to set a string (SOFA name or identifier), use primary_tag()\n\n\nuse constant MAX_TYPE_CACHE_MEMBERS => 20;\nsub type {\n  my($self,$val) = @_;\n  if(defined($val)){\n    my $term = undef;\n\n    if(!ref($val)){\n      $self->throw(\"give type() a Bio::Annotation::OntologyTerm object, not a string\");\n    }\n    elsif(ref($val) && $val->isa('Bio::Annotation::OntologyTerm')){\n      $term = $val;\n    }\n    else {\n      #we have the wrong type of object\n      $self->throw('give type() a SOFA term name, identifier, or Bio::Annotation::OntologyTerm object, not '.$val);\n    }\n    $self->remove_Annotations('type');\n    $self->add_Annotation('type',$term);\n  }\n  \n  return $self->get_Annotations('type');\n}\n\n=head2 source()\n\n Usage   : $obj->source($newval)\n Function: holds the source of the feature.\n Returns : a Bio::Annotation::SimpleValue representing the source.\n           NB: to get a string, use source_tag()\n Args    : on set, a Bio::Annotation::SimpleValue object.\n           NB: to set a string, use source_tag()\n\n\nsub source {\n  my($self,$val) = @_;\n\n  if (defined($val)) {\n      my $term;\n      if (!ref($val)) {\n        $self->throw(\"give source() a Bio::Annotation::SimpleValue object, not a string\");\n        #$term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      } else {\n\t  $self->throw('give source() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('source');\n      $self->add_Annotation('source', $term);\n  }\n  \n  unless ($self->get_Annotations('source')) {\n    $self->source(Bio::Annotation::SimpleValue->new(-value => '.'));\n  }\n  return $self->get_Annotations('source');\n}\n\n=head2 score()\n\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: holds a value corresponding to the score of the feature.\n Returns : a string representing the score.\n Args    : on set, a scalar or a Bio::Annotation::SimpleValue object.\n\n\nsub score {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n\n      if ($term->value ne '.' &&\n           (!defined($term) || ($term->value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/))) {\n\t  $self->throw(\"'$val' is not a valid score\");\n      }\n      $self->remove_Annotations('score');\n      $self->add_Annotation('score', $term);\n  }\n\n  $self->score('.') unless scalar($self->get_Annotations('score')); # make sure we always have something\n\n  return ($self->get_Annotations('score'))[0]->display_text;\n}\n\n=head2 phase()\n\n Usage   : $phase = $feat->phase()\n           $feat->phase($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub phase {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid phase\");\n      }\n      $self->remove_Annotations('phase');\n      $self->add_Annotation('phase', $term);\n  }\n\n  $self->phase('.') unless $self->get_Annotations('phase'); # make sure we always have something\n  \n  return ($self->get_Annotations('phase'))[0]->value;\n}\n\n\n=head2 frame()\n\n Usage   : $frame = $feat->frame()\n           $feat->frame($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub frame {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid frame\");\n      }\n      $self->remove_Annotations('frame');\n      $self->add_Annotation('frame', $term);\n  }\n\n  $self->frame('.') unless $self->get_Annotations('frame'); # make sure we always have something\n  \n  return ($self->get_Annotations('frame'))[0]->value;\n}\n\n############################################################\n\n=head1 SHORTCUT METHODS TO ACCESS Bio::AnnotatableI INTERFACE METHODS\n\n\n=head2 add_Annotation()\n\n Usage   :\n Function: $obj->add_Annotation() is a shortcut to $obj->annotation->add_Annotation\n Returns : \n Args    :\n\n\nsub add_Annotation {\n  my ($self,@args) = @_;\n  return $self->annotation->add_Annotation(@args);\n}\n\n=head2 remove_Annotations()\n\n Usage   :\n Function: $obj->remove_Annotations() is a shortcut to $obj->annotation->remove_Annotations\n Returns : \n Args    :\n\n\nsub remove_Annotations {\n  my ($self,@args) = @_;\n  return $self->annotation->remove_Annotations(@args);\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::SeqFeatureI\n\nNote that no methods are deprecated.  Any SeqFeatureI methods must return\nstrings (no objects).\n\n\n=head2 display_name()\n\n\nsub display_name {\n  my $self = shift;\n  return $self->name(@_);\n}\n\n=head2 primary_tag()\n\n\nsub primary_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    my $term;\n    if(!ref($val) && $val){\n      #we have a plain text annotation coming in.  try to map it to SOFA.\n\n      our %__type_cache; #a little cache of plaintext types we've already seen\n\n      #clear our cache if it gets too big\n      if(scalar(keys %__type_cache) > MAX_TYPE_CACHE_MEMBERS) {\n        %__type_cache = ();\n      }\n\n      #set $term to either a cached value, or look up a new one, throwing\n      #up if not found\n      my $anntext = $val;\n      if ($__type_cache{$anntext}) {\n        $term = $__type_cache{$anntext};\n      } else {\n        my $sofa = Bio::Ontology::OntologyStore->get_instance->get_ontology('Sequence Ontology OBO');\n        my ($soterm) = $anntext =~ /^\\D+:\\d+$/ #does it look like an ident?\n          ? ($sofa->find_terms(-identifier => $anntext))[0] #yes, lookup by ident\n          : ($sofa->find_terms(-name => $anntext))[0];      #no, lookup by name\n        #throw if it's not in SOFA\n        unless($soterm){\n          $self->throw(\"couldn't find a SOFA term matching type '$val'.\");\n        }\n        my $newterm = Bio::Annotation::OntologyTerm->new;\n        $newterm->term($soterm);\n        $term = $newterm;\n      }\n      \n      $self->type($term);\n    }\n  }\n  \n  my $t = $self->type() || return;\n  return $t->name;\n}\n\n=head2 source_tag()\n\n\nsub source_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    if(!ref($val) && $val){\n      my $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      $self->source($term);\n    }\n  }\n  my $t = $self->source() || return;\n  return $t->display_text;\n}\n\n\n=head2 attach_seq()\n\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( ! ($seq && ref($seq) && $seq->isa(\"Bio::PrimarySeqI\")) ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'seq'} = $seq;\n\n   # attach to sub features if they want it\n   foreach ( $self->get_SeqFeatures() ) {\n       $_->attach_seq($seq);\n   }\n   return 1;\n}\n\n=head2 seq()\n\n Usage   : $tseq = $sf->seq()\n Function: returns a truncated version of seq() with bounds matching this feature\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\nsub seq {\n  my ($self) = @_;\n\n  return unless defined($self->entire_seq());\n\n  my $seq = $self->entire_seq->trunc($self->start(), $self->end());\n\n  if ( defined $self->strand && $self->strand == -1 ) {\n    $seq = $seq->revcom;\n  }\n\n  return $seq;\n}\n\n=head2 entire_seq()\n\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    : none\n\n\nsub entire_seq {\n  return shift->{'seq'};\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::RangeI\n\n as inherited via Bio::SeqFeatureI\n\n\n=head2 length()\n\n Usage   : $feature->length()\n Function: Get the feature length computed as $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\nsub length {\n  my $self = shift;\n  return $self->end() - $self->start() + 1;\n}\n\n=head2 start()\n\n Usage   : $obj->start($newval)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub start {\n  my ($self,$value) = @_;\n  return $self->location->start($value);\n}\n\n=head2 end()\n\n Usage   : $obj->end($newval)\n Function: Get/set on the end coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub end {\n  my ($self,$value) = @_;\n  return $self->location->end($value);\n}\n\n=head2 strand()\n\n Usage   : $strand = $feat->strand($newval)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub strand {\n  my $self = shift;\n  return $self->location->strand(@_);\n}\n\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::FeatureHolderI\n\nThis includes methods for retrieving, adding, and removing\nfeatures. Since this is already a feature, features held by this\nfeature holder are essentially sub-features.\n\n\n=head2 get_SeqFeatures\n\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of Bio::SeqFeatureI objects\n Returns : An array\n Args    : none\n\n\nsub get_SeqFeatures {\n  return @{ shift->{'sub_array'} || []};\n}\n\n=head2 add_SeqFeature()\n\n Usage   : $feat->add_SeqFeature($subfeat);\n           $feat->add_SeqFeature($subfeat,'EXPAND')\n Function: adds a SeqFeature into the subSeqFeature array.\n           with no 'EXPAND' qualifer, subfeat will be tested\n           as to whether it lies inside the parent, and throw\n           an exception if not.\n\n           If EXPAND is used, the parent''s start/end/strand will\n           be adjusted so that it grows to accommodate the new\n           subFeature\n Example :\n Returns : nothing\n Args    : a Bio::SeqFeatureI object\n\n\nsub add_SeqFeature {\n  my ($self,$val, $expand) = @_;\n\n  return unless $val;\n\n  if ((!ref($val)) || !$val->isa('Bio::SeqFeatureI') ) {\n      $self->throw((ref($val) ? ref($val) : $val)\n                   .\" does not implement Bio::SeqFeatureI.\");\n  }\n\n  if($expand && ($expand eq 'EXPAND')) {\n      $self->_expand_region($val);\n  } else {\n      if ( !$self->contains($val) ) {\n\t  $self->warn(\"$val is not contained within parent feature, and expansion is not valid, ignoring.\");\n\t  return;\n      }\n  }\n\n  push(@{$self->{'sub_array'}},$val);\n}\n\n=head2 remove_SeqFeatures()\n\n Usage   : $obj->remove_SeqFeatures\n Function: Removes all sub SeqFeatures.  If you want to remove only a subset,\n           remove that subset from the returned array, and add back the rest.\n Returns : The array of Bio::SeqFeatureI implementing sub-features that was\n           deleted from this feature.\n Args    : none\n\n\nsub remove_SeqFeatures {\n  my ($self) = @_;\n\n  my @subfeats = @{$self->{'sub_array'} || []};\n  $self->{'sub_array'} = []; # zap the array.\n  return @subfeats;\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::AnnotatableI\n\n\n=head2 annotation()\n\n Usage   : $obj->annotation($annot_obj)\n Function: Get/set the annotation collection object for annotating this\n           feature.\n Returns : A Bio::AnnotationCollectionI object\n Args    : newvalue (optional)\n\n\nsub annotation {\n    my ($obj,$value) = @_;\n\n    # we are smart if someone references the object and there hasn't been\n    # one set yet\n    if(defined $value || ! defined $obj->{'annotation'} ) {\n        $value = Bio::Annotation::Collection->new() unless ( defined $value );\n        $obj->{'annotation'} = $value;\n    }\n    return $obj->{'annotation'};\n}\n\n############################################################\n\n=head2 location()\n\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n           of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : [optional] Bio::LocationI object to set the value to.\n\n\nsub location {\n  my($self, $value ) = @_;\n\n  if (defined($value)) {\n    unless (ref($value) and $value->isa('Bio::LocationI')) {\n      $self->throw(\"object $value pretends to be a location but \".\n                   \"does not implement Bio::LocationI\");\n    }\n    $self->{'location'} = $value;\n  }\n  elsif (! $self->{'location'}) {\n    # guarantees a real location object is returned every time\n    $self->{'location'} = Bio::Location::Simple->new();\n  }\n  return $self->{'location'};\n}\n\n=head2 add_target()\n\n Usage   : $seqfeature->add_target(Bio::LocatableSeq->new(...));\n Function: adds a target location on another reference sequence for this feature\n Returns : true on success\n Args    : a Bio::LocatableSeq object\n\n\nsub add_target {\n  my ($self,$seq) = @_;\n  $self->throw(\"$seq is not a Bio::LocatableSeq, bailing out\") unless ref($seq) and seq->isa('Bio::LocatableSeq');\n  push @{ $self->{'targets'} }, $seq;\n  return $seq;\n}\n\n=head2 each_target()\n\n Usage   : @targets = $seqfeature->each_target();\n Function: Returns a list of Bio::LocatableSeqs which are the locations of this object.\n           To obtain the \"primary\" location, see L</location()>.\n Returns : a list of 0..N Bio::LocatableSeq objects\n Args    : none\n\n\nsub each_target {\n  my ($self) = @_;\n  return $self->{'targets'} ? @{ $self->{'targets'} } : ();\n}\n\n=head2 _expand_region\n\n Title   : _expand_region\n Usage   : $self->_expand_region($feature);\n Function: Expand the total region covered by this feature to\n           accomodate for the given feature.\n\n           May be called whenever any kind of subfeature is added to this\n           feature. add_SeqFeature() already does this.\n Returns : \n Args    : A Bio::SeqFeatureI implementing object.","parameters":[{"label":"$self"},{"label":"$feat"}],"label":"_expand_region($self,$feat)"},"line":1021,"range":{"start":{"line":1021,"character":0},"end":{"character":9999,"line":1038}},"kind":12},{"containerName":"main::","name":"get_Annotations","children":[{"localvar":"my","containerName":"get_Annotations","kind":13,"name":"$self","line":1065,"definition":"my"},{"definition":"my","line":1067,"containerName":"get_Annotations","localvar":"my","kind":13,"name":"@annotations"},{"line":1067,"name":"$self","containerName":"get_Annotations","kind":13},{"name":"annotation","containerName":"get_Annotations","kind":12,"line":1067},{"line":1067,"name":"get_Annotations","containerName":"get_Annotations","kind":12},{"name":"@annotations","kind":13,"containerName":"get_Annotations","line":1070},{"kind":13,"containerName":"get_Annotations","name":"@annotations","line":1071},{"containerName":"get_Annotations","kind":13,"name":"$annotations","line":1072},{"line":1074,"containerName":"get_Annotations","kind":13,"name":"@annotations"}],"definition":"sub","range":{"start":{"character":0,"line":1064},"end":{"character":9999,"line":1076}},"kind":12,"line":1064},{"signature":{"documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.\n\n\nsub seq_id {\n  my($self,$val) = @_;\n  if (defined($val)) {\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value =~ /^>/)) {\n\t  $self->throw('give seq_id() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('seq_id');\n      $self->add_Annotation('seq_id', $term);\n  }\n\n  $self->seq_id('.') unless $self->get_Annotations('seq_id'); # make sure we always have something\n\n  return ($self->get_Annotations('seq_id'))[0]->value;\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: human-readable name for the feature.\n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 type()\n\n Usage   : $obj->type($newval)\n Function: a SOFA type for the feature.\n Returns : Bio::Annotation::OntologyTerm object representing the type.\n           NB: to get a string, use primary_tag().\n Args    : on set, Bio::Annotation::OntologyTerm object.\n           NB: to set a string (SOFA name or identifier), use primary_tag()\n\n\nuse constant MAX_TYPE_CACHE_MEMBERS => 20;\nsub type {\n  my($self,$val) = @_;\n  if(defined($val)){\n    my $term = undef;\n\n    if(!ref($val)){\n      $self->throw(\"give type() a Bio::Annotation::OntologyTerm object, not a string\");\n    }\n    elsif(ref($val) && $val->isa('Bio::Annotation::OntologyTerm')){\n      $term = $val;\n    }\n    else {\n      #we have the wrong type of object\n      $self->throw('give type() a SOFA term name, identifier, or Bio::Annotation::OntologyTerm object, not '.$val);\n    }\n    $self->remove_Annotations('type');\n    $self->add_Annotation('type',$term);\n  }\n  \n  return $self->get_Annotations('type');\n}\n\n=head2 source()\n\n Usage   : $obj->source($newval)\n Function: holds the source of the feature.\n Returns : a Bio::Annotation::SimpleValue representing the source.\n           NB: to get a string, use source_tag()\n Args    : on set, a Bio::Annotation::SimpleValue object.\n           NB: to set a string, use source_tag()\n\n\nsub source {\n  my($self,$val) = @_;\n\n  if (defined($val)) {\n      my $term;\n      if (!ref($val)) {\n        $self->throw(\"give source() a Bio::Annotation::SimpleValue object, not a string\");\n        #$term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      } else {\n\t  $self->throw('give source() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('source');\n      $self->add_Annotation('source', $term);\n  }\n  \n  unless ($self->get_Annotations('source')) {\n    $self->source(Bio::Annotation::SimpleValue->new(-value => '.'));\n  }\n  return $self->get_Annotations('source');\n}\n\n=head2 score()\n\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: holds a value corresponding to the score of the feature.\n Returns : a string representing the score.\n Args    : on set, a scalar or a Bio::Annotation::SimpleValue object.\n\n\nsub score {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n\n      if ($term->value ne '.' &&\n           (!defined($term) || ($term->value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/))) {\n\t  $self->throw(\"'$val' is not a valid score\");\n      }\n      $self->remove_Annotations('score');\n      $self->add_Annotation('score', $term);\n  }\n\n  $self->score('.') unless scalar($self->get_Annotations('score')); # make sure we always have something\n\n  return ($self->get_Annotations('score'))[0]->display_text;\n}\n\n=head2 phase()\n\n Usage   : $phase = $feat->phase()\n           $feat->phase($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub phase {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid phase\");\n      }\n      $self->remove_Annotations('phase');\n      $self->add_Annotation('phase', $term);\n  }\n\n  $self->phase('.') unless $self->get_Annotations('phase'); # make sure we always have something\n  \n  return ($self->get_Annotations('phase'))[0]->value;\n}\n\n\n=head2 frame()\n\n Usage   : $frame = $feat->frame()\n           $feat->frame($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub frame {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid frame\");\n      }\n      $self->remove_Annotations('frame');\n      $self->add_Annotation('frame', $term);\n  }\n\n  $self->frame('.') unless $self->get_Annotations('frame'); # make sure we always have something\n  \n  return ($self->get_Annotations('frame'))[0]->value;\n}\n\n############################################################\n\n=head1 SHORTCUT METHODS TO ACCESS Bio::AnnotatableI INTERFACE METHODS\n\n\n=head2 add_Annotation()\n\n Usage   :\n Function: $obj->add_Annotation() is a shortcut to $obj->annotation->add_Annotation\n Returns : \n Args    :\n\n\nsub add_Annotation {\n  my ($self,@args) = @_;\n  return $self->annotation->add_Annotation(@args);\n}\n\n=head2 remove_Annotations()\n\n Usage   :\n Function: $obj->remove_Annotations() is a shortcut to $obj->annotation->remove_Annotations\n Returns : \n Args    :\n\n\nsub remove_Annotations {\n  my ($self,@args) = @_;\n  return $self->annotation->remove_Annotations(@args);\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::SeqFeatureI\n\nNote that no methods are deprecated.  Any SeqFeatureI methods must return\nstrings (no objects).\n\n\n=head2 display_name()\n\n\nsub display_name {\n  my $self = shift;\n  return $self->name(@_);\n}\n\n=head2 primary_tag()\n\n\nsub primary_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    my $term;\n    if(!ref($val) && $val){\n      #we have a plain text annotation coming in.  try to map it to SOFA.\n\n      our %__type_cache; #a little cache of plaintext types we've already seen\n\n      #clear our cache if it gets too big\n      if(scalar(keys %__type_cache) > MAX_TYPE_CACHE_MEMBERS) {\n        %__type_cache = ();\n      }\n\n      #set $term to either a cached value, or look up a new one, throwing\n      #up if not found\n      my $anntext = $val;\n      if ($__type_cache{$anntext}) {\n        $term = $__type_cache{$anntext};\n      } else {\n        my $sofa = Bio::Ontology::OntologyStore->get_instance->get_ontology('Sequence Ontology OBO');\n        my ($soterm) = $anntext =~ /^\\D+:\\d+$/ #does it look like an ident?\n          ? ($sofa->find_terms(-identifier => $anntext))[0] #yes, lookup by ident\n          : ($sofa->find_terms(-name => $anntext))[0];      #no, lookup by name\n        #throw if it's not in SOFA\n        unless($soterm){\n          $self->throw(\"couldn't find a SOFA term matching type '$val'.\");\n        }\n        my $newterm = Bio::Annotation::OntologyTerm->new;\n        $newterm->term($soterm);\n        $term = $newterm;\n      }\n      \n      $self->type($term);\n    }\n  }\n  \n  my $t = $self->type() || return;\n  return $t->name;\n}\n\n=head2 source_tag()\n\n\nsub source_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    if(!ref($val) && $val){\n      my $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      $self->source($term);\n    }\n  }\n  my $t = $self->source() || return;\n  return $t->display_text;\n}\n\n\n=head2 attach_seq()\n\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( ! ($seq && ref($seq) && $seq->isa(\"Bio::PrimarySeqI\")) ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'seq'} = $seq;\n\n   # attach to sub features if they want it\n   foreach ( $self->get_SeqFeatures() ) {\n       $_->attach_seq($seq);\n   }\n   return 1;\n}\n\n=head2 seq()\n\n Usage   : $tseq = $sf->seq()\n Function: returns a truncated version of seq() with bounds matching this feature\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\nsub seq {\n  my ($self) = @_;\n\n  return unless defined($self->entire_seq());\n\n  my $seq = $self->entire_seq->trunc($self->start(), $self->end());\n\n  if ( defined $self->strand && $self->strand == -1 ) {\n    $seq = $seq->revcom;\n  }\n\n  return $seq;\n}\n\n=head2 entire_seq()\n\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    : none\n\n\nsub entire_seq {\n  return shift->{'seq'};\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::RangeI\n\n as inherited via Bio::SeqFeatureI\n\n\n=head2 length()\n\n Usage   : $feature->length()\n Function: Get the feature length computed as $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\nsub length {\n  my $self = shift;\n  return $self->end() - $self->start() + 1;\n}\n\n=head2 start()\n\n Usage   : $obj->start($newval)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub start {\n  my ($self,$value) = @_;\n  return $self->location->start($value);\n}\n\n=head2 end()\n\n Usage   : $obj->end($newval)\n Function: Get/set on the end coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub end {\n  my ($self,$value) = @_;\n  return $self->location->end($value);\n}\n\n=head2 strand()\n\n Usage   : $strand = $feat->strand($newval)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub strand {\n  my $self = shift;\n  return $self->location->strand(@_);\n}\n\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::FeatureHolderI\n\nThis includes methods for retrieving, adding, and removing\nfeatures. Since this is already a feature, features held by this\nfeature holder are essentially sub-features.\n\n\n=head2 get_SeqFeatures\n\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of Bio::SeqFeatureI objects\n Returns : An array\n Args    : none\n\n\nsub get_SeqFeatures {\n  return @{ shift->{'sub_array'} || []};\n}\n\n=head2 add_SeqFeature()\n\n Usage   : $feat->add_SeqFeature($subfeat);\n           $feat->add_SeqFeature($subfeat,'EXPAND')\n Function: adds a SeqFeature into the subSeqFeature array.\n           with no 'EXPAND' qualifer, subfeat will be tested\n           as to whether it lies inside the parent, and throw\n           an exception if not.\n\n           If EXPAND is used, the parent''s start/end/strand will\n           be adjusted so that it grows to accommodate the new\n           subFeature\n Example :\n Returns : nothing\n Args    : a Bio::SeqFeatureI object\n\n\nsub add_SeqFeature {\n  my ($self,$val, $expand) = @_;\n\n  return unless $val;\n\n  if ((!ref($val)) || !$val->isa('Bio::SeqFeatureI') ) {\n      $self->throw((ref($val) ? ref($val) : $val)\n                   .\" does not implement Bio::SeqFeatureI.\");\n  }\n\n  if($expand && ($expand eq 'EXPAND')) {\n      $self->_expand_region($val);\n  } else {\n      if ( !$self->contains($val) ) {\n\t  $self->warn(\"$val is not contained within parent feature, and expansion is not valid, ignoring.\");\n\t  return;\n      }\n  }\n\n  push(@{$self->{'sub_array'}},$val);\n}\n\n=head2 remove_SeqFeatures()\n\n Usage   : $obj->remove_SeqFeatures\n Function: Removes all sub SeqFeatures.  If you want to remove only a subset,\n           remove that subset from the returned array, and add back the rest.\n Returns : The array of Bio::SeqFeatureI implementing sub-features that was\n           deleted from this feature.\n Args    : none\n\n\nsub remove_SeqFeatures {\n  my ($self) = @_;\n\n  my @subfeats = @{$self->{'sub_array'} || []};\n  $self->{'sub_array'} = []; # zap the array.\n  return @subfeats;\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::AnnotatableI\n\n\n=head2 annotation()\n\n Usage   : $obj->annotation($annot_obj)\n Function: Get/set the annotation collection object for annotating this\n           feature.\n Returns : A Bio::AnnotationCollectionI object\n Args    : newvalue (optional)\n\n\nsub annotation {\n    my ($obj,$value) = @_;\n\n    # we are smart if someone references the object and there hasn't been\n    # one set yet\n    if(defined $value || ! defined $obj->{'annotation'} ) {\n        $value = Bio::Annotation::Collection->new() unless ( defined $value );\n        $obj->{'annotation'} = $value;\n    }\n    return $obj->{'annotation'};\n}\n\n############################################################\n\n=head2 location()\n\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n           of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : [optional] Bio::LocationI object to set the value to.\n\n\nsub location {\n  my($self, $value ) = @_;\n\n  if (defined($value)) {\n    unless (ref($value) and $value->isa('Bio::LocationI')) {\n      $self->throw(\"object $value pretends to be a location but \".\n                   \"does not implement Bio::LocationI\");\n    }\n    $self->{'location'} = $value;\n  }\n  elsif (! $self->{'location'}) {\n    # guarantees a real location object is returned every time\n    $self->{'location'} = Bio::Location::Simple->new();\n  }\n  return $self->{'location'};\n}\n\n=head2 add_target()\n\n Usage   : $seqfeature->add_target(Bio::LocatableSeq->new(...));\n Function: adds a target location on another reference sequence for this feature\n Returns : true on success\n Args    : a Bio::LocatableSeq object\n\n\nsub add_target {\n  my ($self,$seq) = @_;\n  $self->throw(\"$seq is not a Bio::LocatableSeq, bailing out\") unless ref($seq) and seq->isa('Bio::LocatableSeq');\n  push @{ $self->{'targets'} }, $seq;\n  return $seq;\n}\n\n=head2 each_target()\n\n Usage   : @targets = $seqfeature->each_target();\n Function: Returns a list of Bio::LocatableSeqs which are the locations of this object.\n           To obtain the \"primary\" location, see L</location()>.\n Returns : a list of 0..N Bio::LocatableSeq objects\n Args    : none\n\n\nsub each_target {\n  my ($self) = @_;\n  return $self->{'targets'} ? @{ $self->{'targets'} } : ();\n}\n\n=head2 _expand_region\n\n Title   : _expand_region\n Usage   : $self->_expand_region($feature);\n Function: Expand the total region covered by this feature to\n           accomodate for the given feature.\n\n           May be called whenever any kind of subfeature is added to this\n           feature. add_SeqFeature() already does this.\n Returns : \n Args    : A Bio::SeqFeatureI implementing object.\n\n\nsub _expand_region {\n    my ($self, $feat) = @_;\n    if(! $feat->isa('Bio::SeqFeatureI')) {\n        $self->warn(\"$feat does not implement Bio::SeqFeatureI\");\n    }\n    # if this doesn't have start/end set - forget it!\n    if((! defined($self->start())) && (! defined $self->end())) {\n        $self->start($feat->start());\n        $self->end($feat->end());\n        $self->strand($feat->strand) unless defined($self->strand());\n#        $self->strand($feat->strand) unless $self->strand();\n    } else {\n        my $range = $self->union($feat);\n        $self->start($range->start);\n        $self->end($range->end);\n        $self->strand($range->strand);\n    }\n}\n\n=head2 get_Annotations\n\n Usage   : my $parent   = $obj->get_Annotations('Parent');\n           my @parents = $obj->get_Annotations('Parent');\n Function: a wrapper around Bio::Annotation::Collection::get_Annotations().\n Returns : returns annotations as\n           Bio::Annotation::Collection::get_Annotations() does, but\n           additionally returns a single scalar in scalar context\n           instead of list context so that if an annotation tag\n           contains only a single value, you can do:\n\n           $parent = $feature->get_Annotations('Parent');\n\n           instead of:\n\n           ($parent) = ($feature->get_Annotations('Parent'))[0];\n\n           if the 'Parent' tag has multiple values and is called in a\n           scalar context, the number of annotations is returned.\n\n Args    : an annotation tag name.\n\n\nsub get_Annotations {\n    my $self = shift;\n\n    my @annotations = $self->annotation->get_Annotations(@_);\n\n    if(wantarray){\n        return @annotations;\n    } elsif(scalar(@annotations) == 1){\n        return $annotations[0];\n    } else {\n        return scalar(@annotations);\n    }\n}\n\n=head1 Bio::SeqFeatureI implemented methods\n\nThese are specialized implementations of SeqFeatureI methods which call the\ninternal Bio::Annotation::AnnotationCollection object. Just prior to the 1.5\nrelease the below methods were moved from Bio::SeqFeatureI to Bio::AnnotatableI,\nand having Bio::SeqFeatureI inherit Bio::AnnotatableI. This behavior forced all\nBio::SeqFeatureI-implementing classes to use Bio::AnnotationI objects for any\ndata. It is the consensus of the core developers that this be rolled back in\nfavor of a more flexible approach by rolling back the above changes and making\nthis class Bio::AnnotatableI. The SeqFeatureI tag-related methods are\nreimplemented in order to approximate the same behavior as before.\n\nThe methods below allow mapping of the \"get_tag_values()\"-style annotation\naccess to Bio::AnnotationCollectionI. These need not be implemented in a\nBio::AnnotationCollectionI compliant class, as they are built on top of the\nmethods.  For usage, see Bio::SeqFeatureI.\n\n\n=head2 has_tag","parameters":[{"label":"$self"},{"label":"$tag"}],"label":"has_tag($self,$tag)"},"line":1101,"range":{"end":{"character":9999,"line":1104},"start":{"character":0,"line":1101}},"kind":12,"definition":"sub","detail":"($self,$tag)","children":[{"definition":"my","line":1102,"kind":13,"localvar":"my","containerName":"has_tag","name":"$self"},{"name":"$tag","containerName":"has_tag","kind":13,"line":1102},{"line":1103,"name":"$self","kind":13,"containerName":"has_tag"},{"line":1103,"name":"annotation","kind":12,"containerName":"has_tag"},{"name":"get_Annotations","containerName":"has_tag","kind":12,"line":1103},{"line":1103,"name":"$tag","containerName":"has_tag","kind":13}],"name":"has_tag","containerName":"main::"},{"kind":12,"range":{"end":{"character":9999,"line":1124},"start":{"line":1110,"character":0}},"line":1110,"signature":{"parameters":[{"label":"$self"},{"label":"$tag"},{"label":"@vals"}],"documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.\n\n\nsub seq_id {\n  my($self,$val) = @_;\n  if (defined($val)) {\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value =~ /^>/)) {\n\t  $self->throw('give seq_id() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('seq_id');\n      $self->add_Annotation('seq_id', $term);\n  }\n\n  $self->seq_id('.') unless $self->get_Annotations('seq_id'); # make sure we always have something\n\n  return ($self->get_Annotations('seq_id'))[0]->value;\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: human-readable name for the feature.\n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 type()\n\n Usage   : $obj->type($newval)\n Function: a SOFA type for the feature.\n Returns : Bio::Annotation::OntologyTerm object representing the type.\n           NB: to get a string, use primary_tag().\n Args    : on set, Bio::Annotation::OntologyTerm object.\n           NB: to set a string (SOFA name or identifier), use primary_tag()\n\n\nuse constant MAX_TYPE_CACHE_MEMBERS => 20;\nsub type {\n  my($self,$val) = @_;\n  if(defined($val)){\n    my $term = undef;\n\n    if(!ref($val)){\n      $self->throw(\"give type() a Bio::Annotation::OntologyTerm object, not a string\");\n    }\n    elsif(ref($val) && $val->isa('Bio::Annotation::OntologyTerm')){\n      $term = $val;\n    }\n    else {\n      #we have the wrong type of object\n      $self->throw('give type() a SOFA term name, identifier, or Bio::Annotation::OntologyTerm object, not '.$val);\n    }\n    $self->remove_Annotations('type');\n    $self->add_Annotation('type',$term);\n  }\n  \n  return $self->get_Annotations('type');\n}\n\n=head2 source()\n\n Usage   : $obj->source($newval)\n Function: holds the source of the feature.\n Returns : a Bio::Annotation::SimpleValue representing the source.\n           NB: to get a string, use source_tag()\n Args    : on set, a Bio::Annotation::SimpleValue object.\n           NB: to set a string, use source_tag()\n\n\nsub source {\n  my($self,$val) = @_;\n\n  if (defined($val)) {\n      my $term;\n      if (!ref($val)) {\n        $self->throw(\"give source() a Bio::Annotation::SimpleValue object, not a string\");\n        #$term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      } else {\n\t  $self->throw('give source() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('source');\n      $self->add_Annotation('source', $term);\n  }\n  \n  unless ($self->get_Annotations('source')) {\n    $self->source(Bio::Annotation::SimpleValue->new(-value => '.'));\n  }\n  return $self->get_Annotations('source');\n}\n\n=head2 score()\n\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: holds a value corresponding to the score of the feature.\n Returns : a string representing the score.\n Args    : on set, a scalar or a Bio::Annotation::SimpleValue object.\n\n\nsub score {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n\n      if ($term->value ne '.' &&\n           (!defined($term) || ($term->value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/))) {\n\t  $self->throw(\"'$val' is not a valid score\");\n      }\n      $self->remove_Annotations('score');\n      $self->add_Annotation('score', $term);\n  }\n\n  $self->score('.') unless scalar($self->get_Annotations('score')); # make sure we always have something\n\n  return ($self->get_Annotations('score'))[0]->display_text;\n}\n\n=head2 phase()\n\n Usage   : $phase = $feat->phase()\n           $feat->phase($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub phase {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid phase\");\n      }\n      $self->remove_Annotations('phase');\n      $self->add_Annotation('phase', $term);\n  }\n\n  $self->phase('.') unless $self->get_Annotations('phase'); # make sure we always have something\n  \n  return ($self->get_Annotations('phase'))[0]->value;\n}\n\n\n=head2 frame()\n\n Usage   : $frame = $feat->frame()\n           $feat->frame($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub frame {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid frame\");\n      }\n      $self->remove_Annotations('frame');\n      $self->add_Annotation('frame', $term);\n  }\n\n  $self->frame('.') unless $self->get_Annotations('frame'); # make sure we always have something\n  \n  return ($self->get_Annotations('frame'))[0]->value;\n}\n\n############################################################\n\n=head1 SHORTCUT METHODS TO ACCESS Bio::AnnotatableI INTERFACE METHODS\n\n\n=head2 add_Annotation()\n\n Usage   :\n Function: $obj->add_Annotation() is a shortcut to $obj->annotation->add_Annotation\n Returns : \n Args    :\n\n\nsub add_Annotation {\n  my ($self,@args) = @_;\n  return $self->annotation->add_Annotation(@args);\n}\n\n=head2 remove_Annotations()\n\n Usage   :\n Function: $obj->remove_Annotations() is a shortcut to $obj->annotation->remove_Annotations\n Returns : \n Args    :\n\n\nsub remove_Annotations {\n  my ($self,@args) = @_;\n  return $self->annotation->remove_Annotations(@args);\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::SeqFeatureI\n\nNote that no methods are deprecated.  Any SeqFeatureI methods must return\nstrings (no objects).\n\n\n=head2 display_name()\n\n\nsub display_name {\n  my $self = shift;\n  return $self->name(@_);\n}\n\n=head2 primary_tag()\n\n\nsub primary_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    my $term;\n    if(!ref($val) && $val){\n      #we have a plain text annotation coming in.  try to map it to SOFA.\n\n      our %__type_cache; #a little cache of plaintext types we've already seen\n\n      #clear our cache if it gets too big\n      if(scalar(keys %__type_cache) > MAX_TYPE_CACHE_MEMBERS) {\n        %__type_cache = ();\n      }\n\n      #set $term to either a cached value, or look up a new one, throwing\n      #up if not found\n      my $anntext = $val;\n      if ($__type_cache{$anntext}) {\n        $term = $__type_cache{$anntext};\n      } else {\n        my $sofa = Bio::Ontology::OntologyStore->get_instance->get_ontology('Sequence Ontology OBO');\n        my ($soterm) = $anntext =~ /^\\D+:\\d+$/ #does it look like an ident?\n          ? ($sofa->find_terms(-identifier => $anntext))[0] #yes, lookup by ident\n          : ($sofa->find_terms(-name => $anntext))[0];      #no, lookup by name\n        #throw if it's not in SOFA\n        unless($soterm){\n          $self->throw(\"couldn't find a SOFA term matching type '$val'.\");\n        }\n        my $newterm = Bio::Annotation::OntologyTerm->new;\n        $newterm->term($soterm);\n        $term = $newterm;\n      }\n      \n      $self->type($term);\n    }\n  }\n  \n  my $t = $self->type() || return;\n  return $t->name;\n}\n\n=head2 source_tag()\n\n\nsub source_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    if(!ref($val) && $val){\n      my $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      $self->source($term);\n    }\n  }\n  my $t = $self->source() || return;\n  return $t->display_text;\n}\n\n\n=head2 attach_seq()\n\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( ! ($seq && ref($seq) && $seq->isa(\"Bio::PrimarySeqI\")) ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'seq'} = $seq;\n\n   # attach to sub features if they want it\n   foreach ( $self->get_SeqFeatures() ) {\n       $_->attach_seq($seq);\n   }\n   return 1;\n}\n\n=head2 seq()\n\n Usage   : $tseq = $sf->seq()\n Function: returns a truncated version of seq() with bounds matching this feature\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\nsub seq {\n  my ($self) = @_;\n\n  return unless defined($self->entire_seq());\n\n  my $seq = $self->entire_seq->trunc($self->start(), $self->end());\n\n  if ( defined $self->strand && $self->strand == -1 ) {\n    $seq = $seq->revcom;\n  }\n\n  return $seq;\n}\n\n=head2 entire_seq()\n\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    : none\n\n\nsub entire_seq {\n  return shift->{'seq'};\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::RangeI\n\n as inherited via Bio::SeqFeatureI\n\n\n=head2 length()\n\n Usage   : $feature->length()\n Function: Get the feature length computed as $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\nsub length {\n  my $self = shift;\n  return $self->end() - $self->start() + 1;\n}\n\n=head2 start()\n\n Usage   : $obj->start($newval)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub start {\n  my ($self,$value) = @_;\n  return $self->location->start($value);\n}\n\n=head2 end()\n\n Usage   : $obj->end($newval)\n Function: Get/set on the end coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub end {\n  my ($self,$value) = @_;\n  return $self->location->end($value);\n}\n\n=head2 strand()\n\n Usage   : $strand = $feat->strand($newval)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub strand {\n  my $self = shift;\n  return $self->location->strand(@_);\n}\n\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::FeatureHolderI\n\nThis includes methods for retrieving, adding, and removing\nfeatures. Since this is already a feature, features held by this\nfeature holder are essentially sub-features.\n\n\n=head2 get_SeqFeatures\n\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of Bio::SeqFeatureI objects\n Returns : An array\n Args    : none\n\n\nsub get_SeqFeatures {\n  return @{ shift->{'sub_array'} || []};\n}\n\n=head2 add_SeqFeature()\n\n Usage   : $feat->add_SeqFeature($subfeat);\n           $feat->add_SeqFeature($subfeat,'EXPAND')\n Function: adds a SeqFeature into the subSeqFeature array.\n           with no 'EXPAND' qualifer, subfeat will be tested\n           as to whether it lies inside the parent, and throw\n           an exception if not.\n\n           If EXPAND is used, the parent''s start/end/strand will\n           be adjusted so that it grows to accommodate the new\n           subFeature\n Example :\n Returns : nothing\n Args    : a Bio::SeqFeatureI object\n\n\nsub add_SeqFeature {\n  my ($self,$val, $expand) = @_;\n\n  return unless $val;\n\n  if ((!ref($val)) || !$val->isa('Bio::SeqFeatureI') ) {\n      $self->throw((ref($val) ? ref($val) : $val)\n                   .\" does not implement Bio::SeqFeatureI.\");\n  }\n\n  if($expand && ($expand eq 'EXPAND')) {\n      $self->_expand_region($val);\n  } else {\n      if ( !$self->contains($val) ) {\n\t  $self->warn(\"$val is not contained within parent feature, and expansion is not valid, ignoring.\");\n\t  return;\n      }\n  }\n\n  push(@{$self->{'sub_array'}},$val);\n}\n\n=head2 remove_SeqFeatures()\n\n Usage   : $obj->remove_SeqFeatures\n Function: Removes all sub SeqFeatures.  If you want to remove only a subset,\n           remove that subset from the returned array, and add back the rest.\n Returns : The array of Bio::SeqFeatureI implementing sub-features that was\n           deleted from this feature.\n Args    : none\n\n\nsub remove_SeqFeatures {\n  my ($self) = @_;\n\n  my @subfeats = @{$self->{'sub_array'} || []};\n  $self->{'sub_array'} = []; # zap the array.\n  return @subfeats;\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::AnnotatableI\n\n\n=head2 annotation()\n\n Usage   : $obj->annotation($annot_obj)\n Function: Get/set the annotation collection object for annotating this\n           feature.\n Returns : A Bio::AnnotationCollectionI object\n Args    : newvalue (optional)\n\n\nsub annotation {\n    my ($obj,$value) = @_;\n\n    # we are smart if someone references the object and there hasn't been\n    # one set yet\n    if(defined $value || ! defined $obj->{'annotation'} ) {\n        $value = Bio::Annotation::Collection->new() unless ( defined $value );\n        $obj->{'annotation'} = $value;\n    }\n    return $obj->{'annotation'};\n}\n\n############################################################\n\n=head2 location()\n\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n           of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : [optional] Bio::LocationI object to set the value to.\n\n\nsub location {\n  my($self, $value ) = @_;\n\n  if (defined($value)) {\n    unless (ref($value) and $value->isa('Bio::LocationI')) {\n      $self->throw(\"object $value pretends to be a location but \".\n                   \"does not implement Bio::LocationI\");\n    }\n    $self->{'location'} = $value;\n  }\n  elsif (! $self->{'location'}) {\n    # guarantees a real location object is returned every time\n    $self->{'location'} = Bio::Location::Simple->new();\n  }\n  return $self->{'location'};\n}\n\n=head2 add_target()\n\n Usage   : $seqfeature->add_target(Bio::LocatableSeq->new(...));\n Function: adds a target location on another reference sequence for this feature\n Returns : true on success\n Args    : a Bio::LocatableSeq object\n\n\nsub add_target {\n  my ($self,$seq) = @_;\n  $self->throw(\"$seq is not a Bio::LocatableSeq, bailing out\") unless ref($seq) and seq->isa('Bio::LocatableSeq');\n  push @{ $self->{'targets'} }, $seq;\n  return $seq;\n}\n\n=head2 each_target()\n\n Usage   : @targets = $seqfeature->each_target();\n Function: Returns a list of Bio::LocatableSeqs which are the locations of this object.\n           To obtain the \"primary\" location, see L</location()>.\n Returns : a list of 0..N Bio::LocatableSeq objects\n Args    : none\n\n\nsub each_target {\n  my ($self) = @_;\n  return $self->{'targets'} ? @{ $self->{'targets'} } : ();\n}\n\n=head2 _expand_region\n\n Title   : _expand_region\n Usage   : $self->_expand_region($feature);\n Function: Expand the total region covered by this feature to\n           accomodate for the given feature.\n\n           May be called whenever any kind of subfeature is added to this\n           feature. add_SeqFeature() already does this.\n Returns : \n Args    : A Bio::SeqFeatureI implementing object.\n\n\nsub _expand_region {\n    my ($self, $feat) = @_;\n    if(! $feat->isa('Bio::SeqFeatureI')) {\n        $self->warn(\"$feat does not implement Bio::SeqFeatureI\");\n    }\n    # if this doesn't have start/end set - forget it!\n    if((! defined($self->start())) && (! defined $self->end())) {\n        $self->start($feat->start());\n        $self->end($feat->end());\n        $self->strand($feat->strand) unless defined($self->strand());\n#        $self->strand($feat->strand) unless $self->strand();\n    } else {\n        my $range = $self->union($feat);\n        $self->start($range->start);\n        $self->end($range->end);\n        $self->strand($range->strand);\n    }\n}\n\n=head2 get_Annotations\n\n Usage   : my $parent   = $obj->get_Annotations('Parent');\n           my @parents = $obj->get_Annotations('Parent');\n Function: a wrapper around Bio::Annotation::Collection::get_Annotations().\n Returns : returns annotations as\n           Bio::Annotation::Collection::get_Annotations() does, but\n           additionally returns a single scalar in scalar context\n           instead of list context so that if an annotation tag\n           contains only a single value, you can do:\n\n           $parent = $feature->get_Annotations('Parent');\n\n           instead of:\n\n           ($parent) = ($feature->get_Annotations('Parent'))[0];\n\n           if the 'Parent' tag has multiple values and is called in a\n           scalar context, the number of annotations is returned.\n\n Args    : an annotation tag name.\n\n\nsub get_Annotations {\n    my $self = shift;\n\n    my @annotations = $self->annotation->get_Annotations(@_);\n\n    if(wantarray){\n        return @annotations;\n    } elsif(scalar(@annotations) == 1){\n        return $annotations[0];\n    } else {\n        return scalar(@annotations);\n    }\n}\n\n=head1 Bio::SeqFeatureI implemented methods\n\nThese are specialized implementations of SeqFeatureI methods which call the\ninternal Bio::Annotation::AnnotationCollection object. Just prior to the 1.5\nrelease the below methods were moved from Bio::SeqFeatureI to Bio::AnnotatableI,\nand having Bio::SeqFeatureI inherit Bio::AnnotatableI. This behavior forced all\nBio::SeqFeatureI-implementing classes to use Bio::AnnotationI objects for any\ndata. It is the consensus of the core developers that this be rolled back in\nfavor of a more flexible approach by rolling back the above changes and making\nthis class Bio::AnnotatableI. The SeqFeatureI tag-related methods are\nreimplemented in order to approximate the same behavior as before.\n\nThe methods below allow mapping of the \"get_tag_values()\"-style annotation\naccess to Bio::AnnotationCollectionI. These need not be implemented in a\nBio::AnnotationCollectionI compliant class, as they are built on top of the\nmethods.  For usage, see Bio::SeqFeatureI.\n\n\n=head2 has_tag\n\n\nsub has_tag {\n  my ($self,$tag) = @_;\n  return scalar($self->annotation->get_Annotations($tag));\n}\n\n=head2 add_tag_value","label":"add_tag_value($self,$tag,@vals)"},"name":"add_tag_value","containerName":"main::","children":[{"definition":"my","line":1111,"name":"$self","containerName":"add_tag_value","localvar":"my","kind":13},{"containerName":"add_tag_value","kind":13,"name":"$tag","line":1111},{"line":1111,"kind":13,"containerName":"add_tag_value","name":"@vals"},{"line":1113,"containerName":"add_tag_value","localvar":"my","kind":13,"name":"$val","definition":"my"},{"line":1113,"kind":13,"containerName":"add_tag_value","name":"@vals"},{"definition":"my","name":"$class","localvar":"my","kind":13,"containerName":"add_tag_value","line":1114},{"kind":13,"containerName":"add_tag_value","name":"$tagclass","line":1114},{"line":1114,"name":"$tag","containerName":"add_tag_value","kind":13},{"line":1114,"containerName":"add_tag_value","kind":13,"name":"$tagclass"},{"line":1115,"name":"$slot","containerName":"add_tag_value","localvar":"my","kind":13,"definition":"my"},{"line":1115,"containerName":"add_tag_value","kind":13,"name":"$tag2text"},{"name":"$class","containerName":"add_tag_value","kind":13,"line":1115},{"definition":"my","containerName":"add_tag_value","localvar":"my","kind":13,"name":"$a","line":1117},{"line":1117,"name":"$class","kind":13,"containerName":"add_tag_value"},{"line":1117,"kind":12,"containerName":"add_tag_value","name":"new"},{"kind":13,"containerName":"add_tag_value","name":"$a","line":1118},{"line":1118,"containerName":"add_tag_value","kind":13,"name":"$slot"},{"name":"$val","kind":13,"containerName":"add_tag_value","line":1118},{"line":1120,"name":"$self","containerName":"add_tag_value","kind":13},{"line":1120,"name":"annotation","containerName":"add_tag_value","kind":12},{"line":1120,"containerName":"add_tag_value","kind":12,"name":"add_Annotation"},{"name":"$tag","containerName":"add_tag_value","kind":13,"line":1120},{"line":1120,"kind":13,"containerName":"add_tag_value","name":"$a"}],"detail":"($self,$tag,@vals)","definition":"sub"},{"line":1114,"name":"__DEFAULT__","kind":12},{"signature":{"label":"get_tag_values($self,$tag)","documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.\n\n\nsub seq_id {\n  my($self,$val) = @_;\n  if (defined($val)) {\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value =~ /^>/)) {\n\t  $self->throw('give seq_id() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('seq_id');\n      $self->add_Annotation('seq_id', $term);\n  }\n\n  $self->seq_id('.') unless $self->get_Annotations('seq_id'); # make sure we always have something\n\n  return ($self->get_Annotations('seq_id'))[0]->value;\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: human-readable name for the feature.\n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 type()\n\n Usage   : $obj->type($newval)\n Function: a SOFA type for the feature.\n Returns : Bio::Annotation::OntologyTerm object representing the type.\n           NB: to get a string, use primary_tag().\n Args    : on set, Bio::Annotation::OntologyTerm object.\n           NB: to set a string (SOFA name or identifier), use primary_tag()\n\n\nuse constant MAX_TYPE_CACHE_MEMBERS => 20;\nsub type {\n  my($self,$val) = @_;\n  if(defined($val)){\n    my $term = undef;\n\n    if(!ref($val)){\n      $self->throw(\"give type() a Bio::Annotation::OntologyTerm object, not a string\");\n    }\n    elsif(ref($val) && $val->isa('Bio::Annotation::OntologyTerm')){\n      $term = $val;\n    }\n    else {\n      #we have the wrong type of object\n      $self->throw('give type() a SOFA term name, identifier, or Bio::Annotation::OntologyTerm object, not '.$val);\n    }\n    $self->remove_Annotations('type');\n    $self->add_Annotation('type',$term);\n  }\n  \n  return $self->get_Annotations('type');\n}\n\n=head2 source()\n\n Usage   : $obj->source($newval)\n Function: holds the source of the feature.\n Returns : a Bio::Annotation::SimpleValue representing the source.\n           NB: to get a string, use source_tag()\n Args    : on set, a Bio::Annotation::SimpleValue object.\n           NB: to set a string, use source_tag()\n\n\nsub source {\n  my($self,$val) = @_;\n\n  if (defined($val)) {\n      my $term;\n      if (!ref($val)) {\n        $self->throw(\"give source() a Bio::Annotation::SimpleValue object, not a string\");\n        #$term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      } else {\n\t  $self->throw('give source() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('source');\n      $self->add_Annotation('source', $term);\n  }\n  \n  unless ($self->get_Annotations('source')) {\n    $self->source(Bio::Annotation::SimpleValue->new(-value => '.'));\n  }\n  return $self->get_Annotations('source');\n}\n\n=head2 score()\n\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: holds a value corresponding to the score of the feature.\n Returns : a string representing the score.\n Args    : on set, a scalar or a Bio::Annotation::SimpleValue object.\n\n\nsub score {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n\n      if ($term->value ne '.' &&\n           (!defined($term) || ($term->value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/))) {\n\t  $self->throw(\"'$val' is not a valid score\");\n      }\n      $self->remove_Annotations('score');\n      $self->add_Annotation('score', $term);\n  }\n\n  $self->score('.') unless scalar($self->get_Annotations('score')); # make sure we always have something\n\n  return ($self->get_Annotations('score'))[0]->display_text;\n}\n\n=head2 phase()\n\n Usage   : $phase = $feat->phase()\n           $feat->phase($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub phase {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid phase\");\n      }\n      $self->remove_Annotations('phase');\n      $self->add_Annotation('phase', $term);\n  }\n\n  $self->phase('.') unless $self->get_Annotations('phase'); # make sure we always have something\n  \n  return ($self->get_Annotations('phase'))[0]->value;\n}\n\n\n=head2 frame()\n\n Usage   : $frame = $feat->frame()\n           $feat->frame($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub frame {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid frame\");\n      }\n      $self->remove_Annotations('frame');\n      $self->add_Annotation('frame', $term);\n  }\n\n  $self->frame('.') unless $self->get_Annotations('frame'); # make sure we always have something\n  \n  return ($self->get_Annotations('frame'))[0]->value;\n}\n\n############################################################\n\n=head1 SHORTCUT METHODS TO ACCESS Bio::AnnotatableI INTERFACE METHODS\n\n\n=head2 add_Annotation()\n\n Usage   :\n Function: $obj->add_Annotation() is a shortcut to $obj->annotation->add_Annotation\n Returns : \n Args    :\n\n\nsub add_Annotation {\n  my ($self,@args) = @_;\n  return $self->annotation->add_Annotation(@args);\n}\n\n=head2 remove_Annotations()\n\n Usage   :\n Function: $obj->remove_Annotations() is a shortcut to $obj->annotation->remove_Annotations\n Returns : \n Args    :\n\n\nsub remove_Annotations {\n  my ($self,@args) = @_;\n  return $self->annotation->remove_Annotations(@args);\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::SeqFeatureI\n\nNote that no methods are deprecated.  Any SeqFeatureI methods must return\nstrings (no objects).\n\n\n=head2 display_name()\n\n\nsub display_name {\n  my $self = shift;\n  return $self->name(@_);\n}\n\n=head2 primary_tag()\n\n\nsub primary_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    my $term;\n    if(!ref($val) && $val){\n      #we have a plain text annotation coming in.  try to map it to SOFA.\n\n      our %__type_cache; #a little cache of plaintext types we've already seen\n\n      #clear our cache if it gets too big\n      if(scalar(keys %__type_cache) > MAX_TYPE_CACHE_MEMBERS) {\n        %__type_cache = ();\n      }\n\n      #set $term to either a cached value, or look up a new one, throwing\n      #up if not found\n      my $anntext = $val;\n      if ($__type_cache{$anntext}) {\n        $term = $__type_cache{$anntext};\n      } else {\n        my $sofa = Bio::Ontology::OntologyStore->get_instance->get_ontology('Sequence Ontology OBO');\n        my ($soterm) = $anntext =~ /^\\D+:\\d+$/ #does it look like an ident?\n          ? ($sofa->find_terms(-identifier => $anntext))[0] #yes, lookup by ident\n          : ($sofa->find_terms(-name => $anntext))[0];      #no, lookup by name\n        #throw if it's not in SOFA\n        unless($soterm){\n          $self->throw(\"couldn't find a SOFA term matching type '$val'.\");\n        }\n        my $newterm = Bio::Annotation::OntologyTerm->new;\n        $newterm->term($soterm);\n        $term = $newterm;\n      }\n      \n      $self->type($term);\n    }\n  }\n  \n  my $t = $self->type() || return;\n  return $t->name;\n}\n\n=head2 source_tag()\n\n\nsub source_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    if(!ref($val) && $val){\n      my $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      $self->source($term);\n    }\n  }\n  my $t = $self->source() || return;\n  return $t->display_text;\n}\n\n\n=head2 attach_seq()\n\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( ! ($seq && ref($seq) && $seq->isa(\"Bio::PrimarySeqI\")) ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'seq'} = $seq;\n\n   # attach to sub features if they want it\n   foreach ( $self->get_SeqFeatures() ) {\n       $_->attach_seq($seq);\n   }\n   return 1;\n}\n\n=head2 seq()\n\n Usage   : $tseq = $sf->seq()\n Function: returns a truncated version of seq() with bounds matching this feature\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\nsub seq {\n  my ($self) = @_;\n\n  return unless defined($self->entire_seq());\n\n  my $seq = $self->entire_seq->trunc($self->start(), $self->end());\n\n  if ( defined $self->strand && $self->strand == -1 ) {\n    $seq = $seq->revcom;\n  }\n\n  return $seq;\n}\n\n=head2 entire_seq()\n\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    : none\n\n\nsub entire_seq {\n  return shift->{'seq'};\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::RangeI\n\n as inherited via Bio::SeqFeatureI\n\n\n=head2 length()\n\n Usage   : $feature->length()\n Function: Get the feature length computed as $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\nsub length {\n  my $self = shift;\n  return $self->end() - $self->start() + 1;\n}\n\n=head2 start()\n\n Usage   : $obj->start($newval)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub start {\n  my ($self,$value) = @_;\n  return $self->location->start($value);\n}\n\n=head2 end()\n\n Usage   : $obj->end($newval)\n Function: Get/set on the end coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub end {\n  my ($self,$value) = @_;\n  return $self->location->end($value);\n}\n\n=head2 strand()\n\n Usage   : $strand = $feat->strand($newval)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub strand {\n  my $self = shift;\n  return $self->location->strand(@_);\n}\n\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::FeatureHolderI\n\nThis includes methods for retrieving, adding, and removing\nfeatures. Since this is already a feature, features held by this\nfeature holder are essentially sub-features.\n\n\n=head2 get_SeqFeatures\n\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of Bio::SeqFeatureI objects\n Returns : An array\n Args    : none\n\n\nsub get_SeqFeatures {\n  return @{ shift->{'sub_array'} || []};\n}\n\n=head2 add_SeqFeature()\n\n Usage   : $feat->add_SeqFeature($subfeat);\n           $feat->add_SeqFeature($subfeat,'EXPAND')\n Function: adds a SeqFeature into the subSeqFeature array.\n           with no 'EXPAND' qualifer, subfeat will be tested\n           as to whether it lies inside the parent, and throw\n           an exception if not.\n\n           If EXPAND is used, the parent''s start/end/strand will\n           be adjusted so that it grows to accommodate the new\n           subFeature\n Example :\n Returns : nothing\n Args    : a Bio::SeqFeatureI object\n\n\nsub add_SeqFeature {\n  my ($self,$val, $expand) = @_;\n\n  return unless $val;\n\n  if ((!ref($val)) || !$val->isa('Bio::SeqFeatureI') ) {\n      $self->throw((ref($val) ? ref($val) : $val)\n                   .\" does not implement Bio::SeqFeatureI.\");\n  }\n\n  if($expand && ($expand eq 'EXPAND')) {\n      $self->_expand_region($val);\n  } else {\n      if ( !$self->contains($val) ) {\n\t  $self->warn(\"$val is not contained within parent feature, and expansion is not valid, ignoring.\");\n\t  return;\n      }\n  }\n\n  push(@{$self->{'sub_array'}},$val);\n}\n\n=head2 remove_SeqFeatures()\n\n Usage   : $obj->remove_SeqFeatures\n Function: Removes all sub SeqFeatures.  If you want to remove only a subset,\n           remove that subset from the returned array, and add back the rest.\n Returns : The array of Bio::SeqFeatureI implementing sub-features that was\n           deleted from this feature.\n Args    : none\n\n\nsub remove_SeqFeatures {\n  my ($self) = @_;\n\n  my @subfeats = @{$self->{'sub_array'} || []};\n  $self->{'sub_array'} = []; # zap the array.\n  return @subfeats;\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::AnnotatableI\n\n\n=head2 annotation()\n\n Usage   : $obj->annotation($annot_obj)\n Function: Get/set the annotation collection object for annotating this\n           feature.\n Returns : A Bio::AnnotationCollectionI object\n Args    : newvalue (optional)\n\n\nsub annotation {\n    my ($obj,$value) = @_;\n\n    # we are smart if someone references the object and there hasn't been\n    # one set yet\n    if(defined $value || ! defined $obj->{'annotation'} ) {\n        $value = Bio::Annotation::Collection->new() unless ( defined $value );\n        $obj->{'annotation'} = $value;\n    }\n    return $obj->{'annotation'};\n}\n\n############################################################\n\n=head2 location()\n\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n           of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : [optional] Bio::LocationI object to set the value to.\n\n\nsub location {\n  my($self, $value ) = @_;\n\n  if (defined($value)) {\n    unless (ref($value) and $value->isa('Bio::LocationI')) {\n      $self->throw(\"object $value pretends to be a location but \".\n                   \"does not implement Bio::LocationI\");\n    }\n    $self->{'location'} = $value;\n  }\n  elsif (! $self->{'location'}) {\n    # guarantees a real location object is returned every time\n    $self->{'location'} = Bio::Location::Simple->new();\n  }\n  return $self->{'location'};\n}\n\n=head2 add_target()\n\n Usage   : $seqfeature->add_target(Bio::LocatableSeq->new(...));\n Function: adds a target location on another reference sequence for this feature\n Returns : true on success\n Args    : a Bio::LocatableSeq object\n\n\nsub add_target {\n  my ($self,$seq) = @_;\n  $self->throw(\"$seq is not a Bio::LocatableSeq, bailing out\") unless ref($seq) and seq->isa('Bio::LocatableSeq');\n  push @{ $self->{'targets'} }, $seq;\n  return $seq;\n}\n\n=head2 each_target()\n\n Usage   : @targets = $seqfeature->each_target();\n Function: Returns a list of Bio::LocatableSeqs which are the locations of this object.\n           To obtain the \"primary\" location, see L</location()>.\n Returns : a list of 0..N Bio::LocatableSeq objects\n Args    : none\n\n\nsub each_target {\n  my ($self) = @_;\n  return $self->{'targets'} ? @{ $self->{'targets'} } : ();\n}\n\n=head2 _expand_region\n\n Title   : _expand_region\n Usage   : $self->_expand_region($feature);\n Function: Expand the total region covered by this feature to\n           accomodate for the given feature.\n\n           May be called whenever any kind of subfeature is added to this\n           feature. add_SeqFeature() already does this.\n Returns : \n Args    : A Bio::SeqFeatureI implementing object.\n\n\nsub _expand_region {\n    my ($self, $feat) = @_;\n    if(! $feat->isa('Bio::SeqFeatureI')) {\n        $self->warn(\"$feat does not implement Bio::SeqFeatureI\");\n    }\n    # if this doesn't have start/end set - forget it!\n    if((! defined($self->start())) && (! defined $self->end())) {\n        $self->start($feat->start());\n        $self->end($feat->end());\n        $self->strand($feat->strand) unless defined($self->strand());\n#        $self->strand($feat->strand) unless $self->strand();\n    } else {\n        my $range = $self->union($feat);\n        $self->start($range->start);\n        $self->end($range->end);\n        $self->strand($range->strand);\n    }\n}\n\n=head2 get_Annotations\n\n Usage   : my $parent   = $obj->get_Annotations('Parent');\n           my @parents = $obj->get_Annotations('Parent');\n Function: a wrapper around Bio::Annotation::Collection::get_Annotations().\n Returns : returns annotations as\n           Bio::Annotation::Collection::get_Annotations() does, but\n           additionally returns a single scalar in scalar context\n           instead of list context so that if an annotation tag\n           contains only a single value, you can do:\n\n           $parent = $feature->get_Annotations('Parent');\n\n           instead of:\n\n           ($parent) = ($feature->get_Annotations('Parent'))[0];\n\n           if the 'Parent' tag has multiple values and is called in a\n           scalar context, the number of annotations is returned.\n\n Args    : an annotation tag name.\n\n\nsub get_Annotations {\n    my $self = shift;\n\n    my @annotations = $self->annotation->get_Annotations(@_);\n\n    if(wantarray){\n        return @annotations;\n    } elsif(scalar(@annotations) == 1){\n        return $annotations[0];\n    } else {\n        return scalar(@annotations);\n    }\n}\n\n=head1 Bio::SeqFeatureI implemented methods\n\nThese are specialized implementations of SeqFeatureI methods which call the\ninternal Bio::Annotation::AnnotationCollection object. Just prior to the 1.5\nrelease the below methods were moved from Bio::SeqFeatureI to Bio::AnnotatableI,\nand having Bio::SeqFeatureI inherit Bio::AnnotatableI. This behavior forced all\nBio::SeqFeatureI-implementing classes to use Bio::AnnotationI objects for any\ndata. It is the consensus of the core developers that this be rolled back in\nfavor of a more flexible approach by rolling back the above changes and making\nthis class Bio::AnnotatableI. The SeqFeatureI tag-related methods are\nreimplemented in order to approximate the same behavior as before.\n\nThe methods below allow mapping of the \"get_tag_values()\"-style annotation\naccess to Bio::AnnotationCollectionI. These need not be implemented in a\nBio::AnnotationCollectionI compliant class, as they are built on top of the\nmethods.  For usage, see Bio::SeqFeatureI.\n\n\n=head2 has_tag\n\n\nsub has_tag {\n  my ($self,$tag) = @_;\n  return scalar($self->annotation->get_Annotations($tag));\n}\n\n=head2 add_tag_value\n\n\nsub add_tag_value {\n  my ($self,$tag,@vals) = @_;\n\n  foreach my $val (@vals){\n    my $class = $tagclass{$tag}   || $tagclass{__DEFAULT__};\n    my $slot  = $tag2text{$class};\n\n    my $a = $class->new();\n    $a->$slot($val);\n\n    $self->annotation->add_Annotation($tag,$a);\n  }\n\n  return 1;\n}\n\n=head2 get_tag_values\n\n Usage   : @annotations = $obj->get_tag_values($tag)\n Function: returns annotations corresponding to $tag\n Returns : a list of scalars\n Args    : tag name","parameters":[{"label":"$self"},{"label":"$tag"}]},"line":1135,"kind":12,"range":{"start":{"line":1135,"character":0},"end":{"character":9999,"line":1149}},"definition":"sub","detail":"($self,$tag)","children":[{"kind":13,"localvar":"my","containerName":"get_tag_values","name":"$self","line":1136,"definition":"my"},{"line":1136,"containerName":"get_tag_values","kind":13,"name":"$tag"},{"line":1137,"name":"$tagclass","kind":13,"containerName":"get_tag_values"},{"name":"$tag","containerName":"get_tag_values","kind":13,"line":1137},{"kind":13,"containerName":"get_tag_values","name":"$self","line":1137},{"name":"annotation","kind":12,"containerName":"get_tag_values","line":1137},{"kind":12,"containerName":"get_tag_values","name":"get_Annotations","line":1137},{"line":1137,"kind":13,"containerName":"get_tag_values","name":"$tag"},{"name":"$proto","localvar":"my","kind":13,"containerName":"get_tag_values","line":1139,"definition":"my"},{"line":1139,"name":"$self","kind":13,"containerName":"get_tag_values"},{"kind":12,"containerName":"get_tag_values","name":"annotation","line":1139},{"line":1139,"name":"get_Annotations","kind":12,"containerName":"get_tag_values"},{"kind":13,"containerName":"get_tag_values","name":"$tag","line":1139},{"line":1141,"name":"$tag2text","containerName":"get_tag_values","kind":13},{"kind":13,"containerName":"get_tag_values","name":"$proto","line":1141},{"kind":13,"containerName":"get_tag_values","name":"$tagclass","line":1142},{"line":1142,"kind":13,"containerName":"get_tag_values","name":"$tag"},{"name":"$proto","containerName":"get_tag_values","kind":13,"line":1142},{"line":1146,"kind":13,"localvar":"my","containerName":"get_tag_values","name":"$slot","definition":"my"},{"line":1146,"kind":13,"containerName":"get_tag_values","name":"$tag2text"},{"line":1146,"name":"$tagclass","kind":13,"containerName":"get_tag_values"},{"name":"$tag","kind":13,"containerName":"get_tag_values","line":1146},{"name":"$tagclass","kind":13,"containerName":"get_tag_values","line":1146},{"kind":13,"containerName":"get_tag_values","name":"$slot","line":1148},{"line":1148,"containerName":"get_tag_values","kind":13,"name":"$self"},{"name":"annotation","containerName":"get_tag_values","kind":12,"line":1148},{"name":"get_Annotations","kind":12,"containerName":"get_tag_values","line":1148},{"name":"$tag","containerName":"get_tag_values","kind":13,"line":1148}],"containerName":"main::","name":"get_tag_values"},{"kind":12,"name":"__DEFAULT__","line":1146},{"line":1162,"kind":12,"range":{"start":{"character":0,"line":1162},"end":{"line":1170,"character":9999}},"signature":{"label":"get_tagset_values($self,@tags)","parameters":[{"label":"$self"},{"label":"@tags"}],"documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.\n\n\nsub seq_id {\n  my($self,$val) = @_;\n  if (defined($val)) {\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value =~ /^>/)) {\n\t  $self->throw('give seq_id() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('seq_id');\n      $self->add_Annotation('seq_id', $term);\n  }\n\n  $self->seq_id('.') unless $self->get_Annotations('seq_id'); # make sure we always have something\n\n  return ($self->get_Annotations('seq_id'))[0]->value;\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: human-readable name for the feature.\n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 type()\n\n Usage   : $obj->type($newval)\n Function: a SOFA type for the feature.\n Returns : Bio::Annotation::OntologyTerm object representing the type.\n           NB: to get a string, use primary_tag().\n Args    : on set, Bio::Annotation::OntologyTerm object.\n           NB: to set a string (SOFA name or identifier), use primary_tag()\n\n\nuse constant MAX_TYPE_CACHE_MEMBERS => 20;\nsub type {\n  my($self,$val) = @_;\n  if(defined($val)){\n    my $term = undef;\n\n    if(!ref($val)){\n      $self->throw(\"give type() a Bio::Annotation::OntologyTerm object, not a string\");\n    }\n    elsif(ref($val) && $val->isa('Bio::Annotation::OntologyTerm')){\n      $term = $val;\n    }\n    else {\n      #we have the wrong type of object\n      $self->throw('give type() a SOFA term name, identifier, or Bio::Annotation::OntologyTerm object, not '.$val);\n    }\n    $self->remove_Annotations('type');\n    $self->add_Annotation('type',$term);\n  }\n  \n  return $self->get_Annotations('type');\n}\n\n=head2 source()\n\n Usage   : $obj->source($newval)\n Function: holds the source of the feature.\n Returns : a Bio::Annotation::SimpleValue representing the source.\n           NB: to get a string, use source_tag()\n Args    : on set, a Bio::Annotation::SimpleValue object.\n           NB: to set a string, use source_tag()\n\n\nsub source {\n  my($self,$val) = @_;\n\n  if (defined($val)) {\n      my $term;\n      if (!ref($val)) {\n        $self->throw(\"give source() a Bio::Annotation::SimpleValue object, not a string\");\n        #$term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      } else {\n\t  $self->throw('give source() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('source');\n      $self->add_Annotation('source', $term);\n  }\n  \n  unless ($self->get_Annotations('source')) {\n    $self->source(Bio::Annotation::SimpleValue->new(-value => '.'));\n  }\n  return $self->get_Annotations('source');\n}\n\n=head2 score()\n\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: holds a value corresponding to the score of the feature.\n Returns : a string representing the score.\n Args    : on set, a scalar or a Bio::Annotation::SimpleValue object.\n\n\nsub score {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n\n      if ($term->value ne '.' &&\n           (!defined($term) || ($term->value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/))) {\n\t  $self->throw(\"'$val' is not a valid score\");\n      }\n      $self->remove_Annotations('score');\n      $self->add_Annotation('score', $term);\n  }\n\n  $self->score('.') unless scalar($self->get_Annotations('score')); # make sure we always have something\n\n  return ($self->get_Annotations('score'))[0]->display_text;\n}\n\n=head2 phase()\n\n Usage   : $phase = $feat->phase()\n           $feat->phase($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub phase {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid phase\");\n      }\n      $self->remove_Annotations('phase');\n      $self->add_Annotation('phase', $term);\n  }\n\n  $self->phase('.') unless $self->get_Annotations('phase'); # make sure we always have something\n  \n  return ($self->get_Annotations('phase'))[0]->value;\n}\n\n\n=head2 frame()\n\n Usage   : $frame = $feat->frame()\n           $feat->frame($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub frame {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid frame\");\n      }\n      $self->remove_Annotations('frame');\n      $self->add_Annotation('frame', $term);\n  }\n\n  $self->frame('.') unless $self->get_Annotations('frame'); # make sure we always have something\n  \n  return ($self->get_Annotations('frame'))[0]->value;\n}\n\n############################################################\n\n=head1 SHORTCUT METHODS TO ACCESS Bio::AnnotatableI INTERFACE METHODS\n\n\n=head2 add_Annotation()\n\n Usage   :\n Function: $obj->add_Annotation() is a shortcut to $obj->annotation->add_Annotation\n Returns : \n Args    :\n\n\nsub add_Annotation {\n  my ($self,@args) = @_;\n  return $self->annotation->add_Annotation(@args);\n}\n\n=head2 remove_Annotations()\n\n Usage   :\n Function: $obj->remove_Annotations() is a shortcut to $obj->annotation->remove_Annotations\n Returns : \n Args    :\n\n\nsub remove_Annotations {\n  my ($self,@args) = @_;\n  return $self->annotation->remove_Annotations(@args);\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::SeqFeatureI\n\nNote that no methods are deprecated.  Any SeqFeatureI methods must return\nstrings (no objects).\n\n\n=head2 display_name()\n\n\nsub display_name {\n  my $self = shift;\n  return $self->name(@_);\n}\n\n=head2 primary_tag()\n\n\nsub primary_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    my $term;\n    if(!ref($val) && $val){\n      #we have a plain text annotation coming in.  try to map it to SOFA.\n\n      our %__type_cache; #a little cache of plaintext types we've already seen\n\n      #clear our cache if it gets too big\n      if(scalar(keys %__type_cache) > MAX_TYPE_CACHE_MEMBERS) {\n        %__type_cache = ();\n      }\n\n      #set $term to either a cached value, or look up a new one, throwing\n      #up if not found\n      my $anntext = $val;\n      if ($__type_cache{$anntext}) {\n        $term = $__type_cache{$anntext};\n      } else {\n        my $sofa = Bio::Ontology::OntologyStore->get_instance->get_ontology('Sequence Ontology OBO');\n        my ($soterm) = $anntext =~ /^\\D+:\\d+$/ #does it look like an ident?\n          ? ($sofa->find_terms(-identifier => $anntext))[0] #yes, lookup by ident\n          : ($sofa->find_terms(-name => $anntext))[0];      #no, lookup by name\n        #throw if it's not in SOFA\n        unless($soterm){\n          $self->throw(\"couldn't find a SOFA term matching type '$val'.\");\n        }\n        my $newterm = Bio::Annotation::OntologyTerm->new;\n        $newterm->term($soterm);\n        $term = $newterm;\n      }\n      \n      $self->type($term);\n    }\n  }\n  \n  my $t = $self->type() || return;\n  return $t->name;\n}\n\n=head2 source_tag()\n\n\nsub source_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    if(!ref($val) && $val){\n      my $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      $self->source($term);\n    }\n  }\n  my $t = $self->source() || return;\n  return $t->display_text;\n}\n\n\n=head2 attach_seq()\n\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( ! ($seq && ref($seq) && $seq->isa(\"Bio::PrimarySeqI\")) ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'seq'} = $seq;\n\n   # attach to sub features if they want it\n   foreach ( $self->get_SeqFeatures() ) {\n       $_->attach_seq($seq);\n   }\n   return 1;\n}\n\n=head2 seq()\n\n Usage   : $tseq = $sf->seq()\n Function: returns a truncated version of seq() with bounds matching this feature\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\nsub seq {\n  my ($self) = @_;\n\n  return unless defined($self->entire_seq());\n\n  my $seq = $self->entire_seq->trunc($self->start(), $self->end());\n\n  if ( defined $self->strand && $self->strand == -1 ) {\n    $seq = $seq->revcom;\n  }\n\n  return $seq;\n}\n\n=head2 entire_seq()\n\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    : none\n\n\nsub entire_seq {\n  return shift->{'seq'};\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::RangeI\n\n as inherited via Bio::SeqFeatureI\n\n\n=head2 length()\n\n Usage   : $feature->length()\n Function: Get the feature length computed as $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\nsub length {\n  my $self = shift;\n  return $self->end() - $self->start() + 1;\n}\n\n=head2 start()\n\n Usage   : $obj->start($newval)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub start {\n  my ($self,$value) = @_;\n  return $self->location->start($value);\n}\n\n=head2 end()\n\n Usage   : $obj->end($newval)\n Function: Get/set on the end coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub end {\n  my ($self,$value) = @_;\n  return $self->location->end($value);\n}\n\n=head2 strand()\n\n Usage   : $strand = $feat->strand($newval)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub strand {\n  my $self = shift;\n  return $self->location->strand(@_);\n}\n\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::FeatureHolderI\n\nThis includes methods for retrieving, adding, and removing\nfeatures. Since this is already a feature, features held by this\nfeature holder are essentially sub-features.\n\n\n=head2 get_SeqFeatures\n\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of Bio::SeqFeatureI objects\n Returns : An array\n Args    : none\n\n\nsub get_SeqFeatures {\n  return @{ shift->{'sub_array'} || []};\n}\n\n=head2 add_SeqFeature()\n\n Usage   : $feat->add_SeqFeature($subfeat);\n           $feat->add_SeqFeature($subfeat,'EXPAND')\n Function: adds a SeqFeature into the subSeqFeature array.\n           with no 'EXPAND' qualifer, subfeat will be tested\n           as to whether it lies inside the parent, and throw\n           an exception if not.\n\n           If EXPAND is used, the parent''s start/end/strand will\n           be adjusted so that it grows to accommodate the new\n           subFeature\n Example :\n Returns : nothing\n Args    : a Bio::SeqFeatureI object\n\n\nsub add_SeqFeature {\n  my ($self,$val, $expand) = @_;\n\n  return unless $val;\n\n  if ((!ref($val)) || !$val->isa('Bio::SeqFeatureI') ) {\n      $self->throw((ref($val) ? ref($val) : $val)\n                   .\" does not implement Bio::SeqFeatureI.\");\n  }\n\n  if($expand && ($expand eq 'EXPAND')) {\n      $self->_expand_region($val);\n  } else {\n      if ( !$self->contains($val) ) {\n\t  $self->warn(\"$val is not contained within parent feature, and expansion is not valid, ignoring.\");\n\t  return;\n      }\n  }\n\n  push(@{$self->{'sub_array'}},$val);\n}\n\n=head2 remove_SeqFeatures()\n\n Usage   : $obj->remove_SeqFeatures\n Function: Removes all sub SeqFeatures.  If you want to remove only a subset,\n           remove that subset from the returned array, and add back the rest.\n Returns : The array of Bio::SeqFeatureI implementing sub-features that was\n           deleted from this feature.\n Args    : none\n\n\nsub remove_SeqFeatures {\n  my ($self) = @_;\n\n  my @subfeats = @{$self->{'sub_array'} || []};\n  $self->{'sub_array'} = []; # zap the array.\n  return @subfeats;\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::AnnotatableI\n\n\n=head2 annotation()\n\n Usage   : $obj->annotation($annot_obj)\n Function: Get/set the annotation collection object for annotating this\n           feature.\n Returns : A Bio::AnnotationCollectionI object\n Args    : newvalue (optional)\n\n\nsub annotation {\n    my ($obj,$value) = @_;\n\n    # we are smart if someone references the object and there hasn't been\n    # one set yet\n    if(defined $value || ! defined $obj->{'annotation'} ) {\n        $value = Bio::Annotation::Collection->new() unless ( defined $value );\n        $obj->{'annotation'} = $value;\n    }\n    return $obj->{'annotation'};\n}\n\n############################################################\n\n=head2 location()\n\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n           of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : [optional] Bio::LocationI object to set the value to.\n\n\nsub location {\n  my($self, $value ) = @_;\n\n  if (defined($value)) {\n    unless (ref($value) and $value->isa('Bio::LocationI')) {\n      $self->throw(\"object $value pretends to be a location but \".\n                   \"does not implement Bio::LocationI\");\n    }\n    $self->{'location'} = $value;\n  }\n  elsif (! $self->{'location'}) {\n    # guarantees a real location object is returned every time\n    $self->{'location'} = Bio::Location::Simple->new();\n  }\n  return $self->{'location'};\n}\n\n=head2 add_target()\n\n Usage   : $seqfeature->add_target(Bio::LocatableSeq->new(...));\n Function: adds a target location on another reference sequence for this feature\n Returns : true on success\n Args    : a Bio::LocatableSeq object\n\n\nsub add_target {\n  my ($self,$seq) = @_;\n  $self->throw(\"$seq is not a Bio::LocatableSeq, bailing out\") unless ref($seq) and seq->isa('Bio::LocatableSeq');\n  push @{ $self->{'targets'} }, $seq;\n  return $seq;\n}\n\n=head2 each_target()\n\n Usage   : @targets = $seqfeature->each_target();\n Function: Returns a list of Bio::LocatableSeqs which are the locations of this object.\n           To obtain the \"primary\" location, see L</location()>.\n Returns : a list of 0..N Bio::LocatableSeq objects\n Args    : none\n\n\nsub each_target {\n  my ($self) = @_;\n  return $self->{'targets'} ? @{ $self->{'targets'} } : ();\n}\n\n=head2 _expand_region\n\n Title   : _expand_region\n Usage   : $self->_expand_region($feature);\n Function: Expand the total region covered by this feature to\n           accomodate for the given feature.\n\n           May be called whenever any kind of subfeature is added to this\n           feature. add_SeqFeature() already does this.\n Returns : \n Args    : A Bio::SeqFeatureI implementing object.\n\n\nsub _expand_region {\n    my ($self, $feat) = @_;\n    if(! $feat->isa('Bio::SeqFeatureI')) {\n        $self->warn(\"$feat does not implement Bio::SeqFeatureI\");\n    }\n    # if this doesn't have start/end set - forget it!\n    if((! defined($self->start())) && (! defined $self->end())) {\n        $self->start($feat->start());\n        $self->end($feat->end());\n        $self->strand($feat->strand) unless defined($self->strand());\n#        $self->strand($feat->strand) unless $self->strand();\n    } else {\n        my $range = $self->union($feat);\n        $self->start($range->start);\n        $self->end($range->end);\n        $self->strand($range->strand);\n    }\n}\n\n=head2 get_Annotations\n\n Usage   : my $parent   = $obj->get_Annotations('Parent');\n           my @parents = $obj->get_Annotations('Parent');\n Function: a wrapper around Bio::Annotation::Collection::get_Annotations().\n Returns : returns annotations as\n           Bio::Annotation::Collection::get_Annotations() does, but\n           additionally returns a single scalar in scalar context\n           instead of list context so that if an annotation tag\n           contains only a single value, you can do:\n\n           $parent = $feature->get_Annotations('Parent');\n\n           instead of:\n\n           ($parent) = ($feature->get_Annotations('Parent'))[0];\n\n           if the 'Parent' tag has multiple values and is called in a\n           scalar context, the number of annotations is returned.\n\n Args    : an annotation tag name.\n\n\nsub get_Annotations {\n    my $self = shift;\n\n    my @annotations = $self->annotation->get_Annotations(@_);\n\n    if(wantarray){\n        return @annotations;\n    } elsif(scalar(@annotations) == 1){\n        return $annotations[0];\n    } else {\n        return scalar(@annotations);\n    }\n}\n\n=head1 Bio::SeqFeatureI implemented methods\n\nThese are specialized implementations of SeqFeatureI methods which call the\ninternal Bio::Annotation::AnnotationCollection object. Just prior to the 1.5\nrelease the below methods were moved from Bio::SeqFeatureI to Bio::AnnotatableI,\nand having Bio::SeqFeatureI inherit Bio::AnnotatableI. This behavior forced all\nBio::SeqFeatureI-implementing classes to use Bio::AnnotationI objects for any\ndata. It is the consensus of the core developers that this be rolled back in\nfavor of a more flexible approach by rolling back the above changes and making\nthis class Bio::AnnotatableI. The SeqFeatureI tag-related methods are\nreimplemented in order to approximate the same behavior as before.\n\nThe methods below allow mapping of the \"get_tag_values()\"-style annotation\naccess to Bio::AnnotationCollectionI. These need not be implemented in a\nBio::AnnotationCollectionI compliant class, as they are built on top of the\nmethods.  For usage, see Bio::SeqFeatureI.\n\n\n=head2 has_tag\n\n\nsub has_tag {\n  my ($self,$tag) = @_;\n  return scalar($self->annotation->get_Annotations($tag));\n}\n\n=head2 add_tag_value\n\n\nsub add_tag_value {\n  my ($self,$tag,@vals) = @_;\n\n  foreach my $val (@vals){\n    my $class = $tagclass{$tag}   || $tagclass{__DEFAULT__};\n    my $slot  = $tag2text{$class};\n\n    my $a = $class->new();\n    $a->$slot($val);\n\n    $self->annotation->add_Annotation($tag,$a);\n  }\n\n  return 1;\n}\n\n=head2 get_tag_values\n\n Usage   : @annotations = $obj->get_tag_values($tag)\n Function: returns annotations corresponding to $tag\n Returns : a list of scalars\n Args    : tag name\n\n\nsub get_tag_values {\n    my ($self,$tag) = @_;\n    if(!$tagclass{$tag} && $self->annotation->get_Annotations($tag)){\n        #new tag, haven't seen it yet but it exists.  add to registry\n        my($proto) = $self->annotation->get_Annotations($tag);\n        # we can only register if there's a method known for obtaining the value\n        if (exists($tag2text{ref($proto)})) {\n            $tagclass{$tag} = ref($proto);\n        }\n    }\n\n    my $slot  = $tag2text{ $tagclass{$tag} || $tagclass{__DEFAULT__} };\n    \n    return map { $_->$slot } $self->annotation->get_Annotations($tag);\n}\n\n=head2 get_tagset_values\n\n Usage   : @annotations = $obj->get_tagset_values($tag1,$tag2)\n Function: returns annotations corresponding to a list of tags.\n           this is a convenience method equivalent to multiple calls\n           to get_tag_values with each tag in the list.\n Returns : a list of Bio::AnnotationI objects.\n Args    : a list of tag names"},"children":[{"definition":"my","line":1163,"name":"$self","containerName":"get_tagset_values","localvar":"my","kind":13},{"line":1163,"containerName":"get_tagset_values","kind":13,"name":"@tags"},{"line":1164,"name":"@r","localvar":"my","containerName":"get_tagset_values","kind":13,"definition":"my"},{"definition":"my","line":1165,"name":"$tag","containerName":"get_tagset_values","localvar":"my","kind":13},{"line":1165,"name":"@tags","kind":13,"containerName":"get_tagset_values"},{"definition":"my","line":1166,"name":"$slot","containerName":"get_tagset_values","localvar":"my","kind":13},{"line":1166,"name":"$tag2text","kind":13,"containerName":"get_tagset_values"},{"containerName":"get_tagset_values","kind":13,"name":"$tagclass","line":1166},{"name":"$tag","kind":13,"containerName":"get_tagset_values","line":1166},{"line":1166,"containerName":"get_tagset_values","kind":13,"name":"$tagclass"},{"line":1167,"name":"@r","kind":13,"containerName":"get_tagset_values"},{"name":"$slot","containerName":"get_tagset_values","kind":13,"line":1167},{"name":"$self","kind":13,"containerName":"get_tagset_values","line":1167},{"name":"annotation","kind":12,"containerName":"get_tagset_values","line":1167},{"line":1167,"containerName":"get_tagset_values","kind":12,"name":"get_Annotations"},{"name":"$tag","kind":13,"containerName":"get_tagset_values","line":1167},{"name":"@r","containerName":"get_tagset_values","kind":13,"line":1169}],"containerName":"main::","name":"get_tagset_values","definition":"sub","detail":"($self,@tags)"},{"line":1166,"name":"__DEFAULT__","kind":12},{"detail":"($self,@args)","definition":"sub","containerName":"main::","name":"get_all_tags","children":[{"definition":"my","line":1182,"name":"$self","kind":13,"localvar":"my","containerName":"get_all_tags"},{"line":1182,"containerName":"get_all_tags","kind":13,"name":"@args"},{"name":"$self","kind":13,"containerName":"get_all_tags","line":1183},{"line":1183,"kind":12,"containerName":"get_all_tags","name":"annotation"},{"name":"get_all_annotation_keys","kind":12,"containerName":"get_all_tags","line":1183},{"kind":13,"containerName":"get_all_tags","name":"@args","line":1183}],"signature":{"documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.\n\n\nsub seq_id {\n  my($self,$val) = @_;\n  if (defined($val)) {\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value =~ /^>/)) {\n\t  $self->throw('give seq_id() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('seq_id');\n      $self->add_Annotation('seq_id', $term);\n  }\n\n  $self->seq_id('.') unless $self->get_Annotations('seq_id'); # make sure we always have something\n\n  return ($self->get_Annotations('seq_id'))[0]->value;\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: human-readable name for the feature.\n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 type()\n\n Usage   : $obj->type($newval)\n Function: a SOFA type for the feature.\n Returns : Bio::Annotation::OntologyTerm object representing the type.\n           NB: to get a string, use primary_tag().\n Args    : on set, Bio::Annotation::OntologyTerm object.\n           NB: to set a string (SOFA name or identifier), use primary_tag()\n\n\nuse constant MAX_TYPE_CACHE_MEMBERS => 20;\nsub type {\n  my($self,$val) = @_;\n  if(defined($val)){\n    my $term = undef;\n\n    if(!ref($val)){\n      $self->throw(\"give type() a Bio::Annotation::OntologyTerm object, not a string\");\n    }\n    elsif(ref($val) && $val->isa('Bio::Annotation::OntologyTerm')){\n      $term = $val;\n    }\n    else {\n      #we have the wrong type of object\n      $self->throw('give type() a SOFA term name, identifier, or Bio::Annotation::OntologyTerm object, not '.$val);\n    }\n    $self->remove_Annotations('type');\n    $self->add_Annotation('type',$term);\n  }\n  \n  return $self->get_Annotations('type');\n}\n\n=head2 source()\n\n Usage   : $obj->source($newval)\n Function: holds the source of the feature.\n Returns : a Bio::Annotation::SimpleValue representing the source.\n           NB: to get a string, use source_tag()\n Args    : on set, a Bio::Annotation::SimpleValue object.\n           NB: to set a string, use source_tag()\n\n\nsub source {\n  my($self,$val) = @_;\n\n  if (defined($val)) {\n      my $term;\n      if (!ref($val)) {\n        $self->throw(\"give source() a Bio::Annotation::SimpleValue object, not a string\");\n        #$term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      } else {\n\t  $self->throw('give source() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('source');\n      $self->add_Annotation('source', $term);\n  }\n  \n  unless ($self->get_Annotations('source')) {\n    $self->source(Bio::Annotation::SimpleValue->new(-value => '.'));\n  }\n  return $self->get_Annotations('source');\n}\n\n=head2 score()\n\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: holds a value corresponding to the score of the feature.\n Returns : a string representing the score.\n Args    : on set, a scalar or a Bio::Annotation::SimpleValue object.\n\n\nsub score {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n\n      if ($term->value ne '.' &&\n           (!defined($term) || ($term->value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/))) {\n\t  $self->throw(\"'$val' is not a valid score\");\n      }\n      $self->remove_Annotations('score');\n      $self->add_Annotation('score', $term);\n  }\n\n  $self->score('.') unless scalar($self->get_Annotations('score')); # make sure we always have something\n\n  return ($self->get_Annotations('score'))[0]->display_text;\n}\n\n=head2 phase()\n\n Usage   : $phase = $feat->phase()\n           $feat->phase($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub phase {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid phase\");\n      }\n      $self->remove_Annotations('phase');\n      $self->add_Annotation('phase', $term);\n  }\n\n  $self->phase('.') unless $self->get_Annotations('phase'); # make sure we always have something\n  \n  return ($self->get_Annotations('phase'))[0]->value;\n}\n\n\n=head2 frame()\n\n Usage   : $frame = $feat->frame()\n           $feat->frame($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub frame {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid frame\");\n      }\n      $self->remove_Annotations('frame');\n      $self->add_Annotation('frame', $term);\n  }\n\n  $self->frame('.') unless $self->get_Annotations('frame'); # make sure we always have something\n  \n  return ($self->get_Annotations('frame'))[0]->value;\n}\n\n############################################################\n\n=head1 SHORTCUT METHODS TO ACCESS Bio::AnnotatableI INTERFACE METHODS\n\n\n=head2 add_Annotation()\n\n Usage   :\n Function: $obj->add_Annotation() is a shortcut to $obj->annotation->add_Annotation\n Returns : \n Args    :\n\n\nsub add_Annotation {\n  my ($self,@args) = @_;\n  return $self->annotation->add_Annotation(@args);\n}\n\n=head2 remove_Annotations()\n\n Usage   :\n Function: $obj->remove_Annotations() is a shortcut to $obj->annotation->remove_Annotations\n Returns : \n Args    :\n\n\nsub remove_Annotations {\n  my ($self,@args) = @_;\n  return $self->annotation->remove_Annotations(@args);\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::SeqFeatureI\n\nNote that no methods are deprecated.  Any SeqFeatureI methods must return\nstrings (no objects).\n\n\n=head2 display_name()\n\n\nsub display_name {\n  my $self = shift;\n  return $self->name(@_);\n}\n\n=head2 primary_tag()\n\n\nsub primary_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    my $term;\n    if(!ref($val) && $val){\n      #we have a plain text annotation coming in.  try to map it to SOFA.\n\n      our %__type_cache; #a little cache of plaintext types we've already seen\n\n      #clear our cache if it gets too big\n      if(scalar(keys %__type_cache) > MAX_TYPE_CACHE_MEMBERS) {\n        %__type_cache = ();\n      }\n\n      #set $term to either a cached value, or look up a new one, throwing\n      #up if not found\n      my $anntext = $val;\n      if ($__type_cache{$anntext}) {\n        $term = $__type_cache{$anntext};\n      } else {\n        my $sofa = Bio::Ontology::OntologyStore->get_instance->get_ontology('Sequence Ontology OBO');\n        my ($soterm) = $anntext =~ /^\\D+:\\d+$/ #does it look like an ident?\n          ? ($sofa->find_terms(-identifier => $anntext))[0] #yes, lookup by ident\n          : ($sofa->find_terms(-name => $anntext))[0];      #no, lookup by name\n        #throw if it's not in SOFA\n        unless($soterm){\n          $self->throw(\"couldn't find a SOFA term matching type '$val'.\");\n        }\n        my $newterm = Bio::Annotation::OntologyTerm->new;\n        $newterm->term($soterm);\n        $term = $newterm;\n      }\n      \n      $self->type($term);\n    }\n  }\n  \n  my $t = $self->type() || return;\n  return $t->name;\n}\n\n=head2 source_tag()\n\n\nsub source_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    if(!ref($val) && $val){\n      my $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      $self->source($term);\n    }\n  }\n  my $t = $self->source() || return;\n  return $t->display_text;\n}\n\n\n=head2 attach_seq()\n\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( ! ($seq && ref($seq) && $seq->isa(\"Bio::PrimarySeqI\")) ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'seq'} = $seq;\n\n   # attach to sub features if they want it\n   foreach ( $self->get_SeqFeatures() ) {\n       $_->attach_seq($seq);\n   }\n   return 1;\n}\n\n=head2 seq()\n\n Usage   : $tseq = $sf->seq()\n Function: returns a truncated version of seq() with bounds matching this feature\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\nsub seq {\n  my ($self) = @_;\n\n  return unless defined($self->entire_seq());\n\n  my $seq = $self->entire_seq->trunc($self->start(), $self->end());\n\n  if ( defined $self->strand && $self->strand == -1 ) {\n    $seq = $seq->revcom;\n  }\n\n  return $seq;\n}\n\n=head2 entire_seq()\n\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    : none\n\n\nsub entire_seq {\n  return shift->{'seq'};\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::RangeI\n\n as inherited via Bio::SeqFeatureI\n\n\n=head2 length()\n\n Usage   : $feature->length()\n Function: Get the feature length computed as $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\nsub length {\n  my $self = shift;\n  return $self->end() - $self->start() + 1;\n}\n\n=head2 start()\n\n Usage   : $obj->start($newval)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub start {\n  my ($self,$value) = @_;\n  return $self->location->start($value);\n}\n\n=head2 end()\n\n Usage   : $obj->end($newval)\n Function: Get/set on the end coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub end {\n  my ($self,$value) = @_;\n  return $self->location->end($value);\n}\n\n=head2 strand()\n\n Usage   : $strand = $feat->strand($newval)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub strand {\n  my $self = shift;\n  return $self->location->strand(@_);\n}\n\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::FeatureHolderI\n\nThis includes methods for retrieving, adding, and removing\nfeatures. Since this is already a feature, features held by this\nfeature holder are essentially sub-features.\n\n\n=head2 get_SeqFeatures\n\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of Bio::SeqFeatureI objects\n Returns : An array\n Args    : none\n\n\nsub get_SeqFeatures {\n  return @{ shift->{'sub_array'} || []};\n}\n\n=head2 add_SeqFeature()\n\n Usage   : $feat->add_SeqFeature($subfeat);\n           $feat->add_SeqFeature($subfeat,'EXPAND')\n Function: adds a SeqFeature into the subSeqFeature array.\n           with no 'EXPAND' qualifer, subfeat will be tested\n           as to whether it lies inside the parent, and throw\n           an exception if not.\n\n           If EXPAND is used, the parent''s start/end/strand will\n           be adjusted so that it grows to accommodate the new\n           subFeature\n Example :\n Returns : nothing\n Args    : a Bio::SeqFeatureI object\n\n\nsub add_SeqFeature {\n  my ($self,$val, $expand) = @_;\n\n  return unless $val;\n\n  if ((!ref($val)) || !$val->isa('Bio::SeqFeatureI') ) {\n      $self->throw((ref($val) ? ref($val) : $val)\n                   .\" does not implement Bio::SeqFeatureI.\");\n  }\n\n  if($expand && ($expand eq 'EXPAND')) {\n      $self->_expand_region($val);\n  } else {\n      if ( !$self->contains($val) ) {\n\t  $self->warn(\"$val is not contained within parent feature, and expansion is not valid, ignoring.\");\n\t  return;\n      }\n  }\n\n  push(@{$self->{'sub_array'}},$val);\n}\n\n=head2 remove_SeqFeatures()\n\n Usage   : $obj->remove_SeqFeatures\n Function: Removes all sub SeqFeatures.  If you want to remove only a subset,\n           remove that subset from the returned array, and add back the rest.\n Returns : The array of Bio::SeqFeatureI implementing sub-features that was\n           deleted from this feature.\n Args    : none\n\n\nsub remove_SeqFeatures {\n  my ($self) = @_;\n\n  my @subfeats = @{$self->{'sub_array'} || []};\n  $self->{'sub_array'} = []; # zap the array.\n  return @subfeats;\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::AnnotatableI\n\n\n=head2 annotation()\n\n Usage   : $obj->annotation($annot_obj)\n Function: Get/set the annotation collection object for annotating this\n           feature.\n Returns : A Bio::AnnotationCollectionI object\n Args    : newvalue (optional)\n\n\nsub annotation {\n    my ($obj,$value) = @_;\n\n    # we are smart if someone references the object and there hasn't been\n    # one set yet\n    if(defined $value || ! defined $obj->{'annotation'} ) {\n        $value = Bio::Annotation::Collection->new() unless ( defined $value );\n        $obj->{'annotation'} = $value;\n    }\n    return $obj->{'annotation'};\n}\n\n############################################################\n\n=head2 location()\n\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n           of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : [optional] Bio::LocationI object to set the value to.\n\n\nsub location {\n  my($self, $value ) = @_;\n\n  if (defined($value)) {\n    unless (ref($value) and $value->isa('Bio::LocationI')) {\n      $self->throw(\"object $value pretends to be a location but \".\n                   \"does not implement Bio::LocationI\");\n    }\n    $self->{'location'} = $value;\n  }\n  elsif (! $self->{'location'}) {\n    # guarantees a real location object is returned every time\n    $self->{'location'} = Bio::Location::Simple->new();\n  }\n  return $self->{'location'};\n}\n\n=head2 add_target()\n\n Usage   : $seqfeature->add_target(Bio::LocatableSeq->new(...));\n Function: adds a target location on another reference sequence for this feature\n Returns : true on success\n Args    : a Bio::LocatableSeq object\n\n\nsub add_target {\n  my ($self,$seq) = @_;\n  $self->throw(\"$seq is not a Bio::LocatableSeq, bailing out\") unless ref($seq) and seq->isa('Bio::LocatableSeq');\n  push @{ $self->{'targets'} }, $seq;\n  return $seq;\n}\n\n=head2 each_target()\n\n Usage   : @targets = $seqfeature->each_target();\n Function: Returns a list of Bio::LocatableSeqs which are the locations of this object.\n           To obtain the \"primary\" location, see L</location()>.\n Returns : a list of 0..N Bio::LocatableSeq objects\n Args    : none\n\n\nsub each_target {\n  my ($self) = @_;\n  return $self->{'targets'} ? @{ $self->{'targets'} } : ();\n}\n\n=head2 _expand_region\n\n Title   : _expand_region\n Usage   : $self->_expand_region($feature);\n Function: Expand the total region covered by this feature to\n           accomodate for the given feature.\n\n           May be called whenever any kind of subfeature is added to this\n           feature. add_SeqFeature() already does this.\n Returns : \n Args    : A Bio::SeqFeatureI implementing object.\n\n\nsub _expand_region {\n    my ($self, $feat) = @_;\n    if(! $feat->isa('Bio::SeqFeatureI')) {\n        $self->warn(\"$feat does not implement Bio::SeqFeatureI\");\n    }\n    # if this doesn't have start/end set - forget it!\n    if((! defined($self->start())) && (! defined $self->end())) {\n        $self->start($feat->start());\n        $self->end($feat->end());\n        $self->strand($feat->strand) unless defined($self->strand());\n#        $self->strand($feat->strand) unless $self->strand();\n    } else {\n        my $range = $self->union($feat);\n        $self->start($range->start);\n        $self->end($range->end);\n        $self->strand($range->strand);\n    }\n}\n\n=head2 get_Annotations\n\n Usage   : my $parent   = $obj->get_Annotations('Parent');\n           my @parents = $obj->get_Annotations('Parent');\n Function: a wrapper around Bio::Annotation::Collection::get_Annotations().\n Returns : returns annotations as\n           Bio::Annotation::Collection::get_Annotations() does, but\n           additionally returns a single scalar in scalar context\n           instead of list context so that if an annotation tag\n           contains only a single value, you can do:\n\n           $parent = $feature->get_Annotations('Parent');\n\n           instead of:\n\n           ($parent) = ($feature->get_Annotations('Parent'))[0];\n\n           if the 'Parent' tag has multiple values and is called in a\n           scalar context, the number of annotations is returned.\n\n Args    : an annotation tag name.\n\n\nsub get_Annotations {\n    my $self = shift;\n\n    my @annotations = $self->annotation->get_Annotations(@_);\n\n    if(wantarray){\n        return @annotations;\n    } elsif(scalar(@annotations) == 1){\n        return $annotations[0];\n    } else {\n        return scalar(@annotations);\n    }\n}\n\n=head1 Bio::SeqFeatureI implemented methods\n\nThese are specialized implementations of SeqFeatureI methods which call the\ninternal Bio::Annotation::AnnotationCollection object. Just prior to the 1.5\nrelease the below methods were moved from Bio::SeqFeatureI to Bio::AnnotatableI,\nand having Bio::SeqFeatureI inherit Bio::AnnotatableI. This behavior forced all\nBio::SeqFeatureI-implementing classes to use Bio::AnnotationI objects for any\ndata. It is the consensus of the core developers that this be rolled back in\nfavor of a more flexible approach by rolling back the above changes and making\nthis class Bio::AnnotatableI. The SeqFeatureI tag-related methods are\nreimplemented in order to approximate the same behavior as before.\n\nThe methods below allow mapping of the \"get_tag_values()\"-style annotation\naccess to Bio::AnnotationCollectionI. These need not be implemented in a\nBio::AnnotationCollectionI compliant class, as they are built on top of the\nmethods.  For usage, see Bio::SeqFeatureI.\n\n\n=head2 has_tag\n\n\nsub has_tag {\n  my ($self,$tag) = @_;\n  return scalar($self->annotation->get_Annotations($tag));\n}\n\n=head2 add_tag_value\n\n\nsub add_tag_value {\n  my ($self,$tag,@vals) = @_;\n\n  foreach my $val (@vals){\n    my $class = $tagclass{$tag}   || $tagclass{__DEFAULT__};\n    my $slot  = $tag2text{$class};\n\n    my $a = $class->new();\n    $a->$slot($val);\n\n    $self->annotation->add_Annotation($tag,$a);\n  }\n\n  return 1;\n}\n\n=head2 get_tag_values\n\n Usage   : @annotations = $obj->get_tag_values($tag)\n Function: returns annotations corresponding to $tag\n Returns : a list of scalars\n Args    : tag name\n\n\nsub get_tag_values {\n    my ($self,$tag) = @_;\n    if(!$tagclass{$tag} && $self->annotation->get_Annotations($tag)){\n        #new tag, haven't seen it yet but it exists.  add to registry\n        my($proto) = $self->annotation->get_Annotations($tag);\n        # we can only register if there's a method known for obtaining the value\n        if (exists($tag2text{ref($proto)})) {\n            $tagclass{$tag} = ref($proto);\n        }\n    }\n\n    my $slot  = $tag2text{ $tagclass{$tag} || $tagclass{__DEFAULT__} };\n    \n    return map { $_->$slot } $self->annotation->get_Annotations($tag);\n}\n\n=head2 get_tagset_values\n\n Usage   : @annotations = $obj->get_tagset_values($tag1,$tag2)\n Function: returns annotations corresponding to a list of tags.\n           this is a convenience method equivalent to multiple calls\n           to get_tag_values with each tag in the list.\n Returns : a list of Bio::AnnotationI objects.\n Args    : a list of tag names\n\n\nsub get_tagset_values {\n  my ($self,@tags) = @_;\n  my @r = ();\n  foreach my $tag (@tags){\n    my $slot  = $tag2text{ $tagclass{$tag} || $tagclass{__DEFAULT__} };\n    push @r, map { $_->$slot } $self->annotation->get_Annotations($tag);\n  }\n  return @r;\n}\n\n=head2 get_all_tags\n\n Usage   : @tags = $obj->get_all_tags()\n Function: returns a list of annotation tag names.\n Returns : a list of tag names\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}],"label":"get_all_tags($self,@args)"},"kind":12,"range":{"end":{"character":9999,"line":1184},"start":{"line":1181,"character":0}},"line":1181},{"range":{"start":{"line":1198,"character":0},"end":{"character":9999,"line":1201}},"kind":12,"line":1198,"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Annotated.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Annotated\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday at ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Annotated - PLEASE PUT SOMETHING HERE\n\n=head1 SYNOPSIS\n\n    # none yet, complain to authors\n\n=head1 DESCRIPTION\n\nNone yet, complain to authors.\n\n=head1 Implemented Interfaces\n\nThis class implements the following interfaces.\n\n=over 4\n\n* Bio::SeqFeatureI\n\nNote that this includes implementing Bio::RangeI.\n\n* Bio::AnnotatableI\n\n* Bio::FeatureHolderI\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nAllen Day E<lt>allenday at ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\npackage Bio::SeqFeature::Annotated;\n\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::Target;\nuse Bio::LocatableSeq;\nuse Bio::Location::Simple;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Tools::GFF;\nuse Bio::SeqFeature::AnnotationAdaptor;\nuse Data::Dumper;\nuse URI::Escape;\n\nuse base qw(Bio::Root::Root\n    Bio::SeqFeature::TypedSeqFeatureI\n    Bio::AnnotatableI\n    Bio::FeatureHolderI);\n\nour %tagclass = (\n  comment        => 'Bio::Annotation::Comment',\n  dblink         => 'Bio::Annotation::DBLink',\n  description    => 'Bio::Annotation::SimpleValue',\n  gene_name      => 'Bio::Annotation::SimpleValue',\n  ontology_term  => 'Bio::Annotation::OntologyTerm',\n  reference      => 'Bio::Annotation::Reference',\n  __DEFAULT__    => 'Bio::Annotation::SimpleValue',\n);\n\nour %tag2text = (\n  'Bio::Annotation::Comment'        => 'text',\n  'Bio::Annotation::DBLink'         => 'primary_id',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::SimpleValue'    => 'value',\n  'Bio::Annotation::OntologyTerm'   => 'name',\n  'Bio::Annotation::Reference'      => 'title',\n  __DEFAULT__                       => 'value',\n);\n\n######################################\n#get_SeqFeatures\n#display_name\n#primary_tag\n#source_tag                       x with warning\n#has_tag\n#get_tag_values\n#get_tagset_values\n#get_all_tags\n#attach_seq\n#seq                              x\n#entire_seq                       x\n#seq_id\n#gff_string\n#_static_gff_handler\n#start                            x\n#end                              x\n#strand                           x\n#location\n#primary_id\n\n=head1 PREAMBLE\n\nOkay, where to start...\n\nThe original idea for this class appears to lump all SeqFeatureI data\n(primary_tag, source_tag, etc) into AnnotationI objects into an\nBio::Annotation::Collection. The type is then checked against SOFA.\n\nThere have been several requests to have type checking be optionally run. \n\nBio::FeatureHolderI::create_hierarchy_from_ParentIDs\nBio::FeatureHolderI::feature_count\nBio::FeatureHolderI::get_all_SeqFeatures\nBio::FeatureHolderI::set_ParentIDs_from_hierarchy\nBio::RangeI::contains\nBio::RangeI::disconnected_ranges\nBio::RangeI::equals\nBio::RangeI::intersection\nBio::RangeI::offsetStranded\nBio::RangeI::overlap_extent\nBio::RangeI::overlaps\nBio::RangeI::subtract\nBio::RangeI::union\nBio::SeqFeature::Annotated::Dumper\nBio::SeqFeature::Annotated::MAX_TYPE_CACHE_MEMBERS\nBio::SeqFeature::Annotated::add_Annotation\nBio::SeqFeature::Annotated::add_SeqFeature\nBio::SeqFeature::Annotated::add_tag_value\nBio::SeqFeature::Annotated::add_target\nBio::SeqFeature::Annotated::annotation\nBio::SeqFeature::Annotated::attach_seq\nBio::SeqFeature::Annotated::display_name\nBio::SeqFeature::Annotated::each_target\nBio::SeqFeature::Annotated::end\nBio::SeqFeature::Annotated::entire_seq\nBio::SeqFeature::Annotated::frame\nBio::SeqFeature::Annotated::from_feature\nBio::SeqFeature::Annotated::get_Annotations\nBio::SeqFeature::Annotated::get_SeqFeatures\nBio::SeqFeature::Annotated::get_all_tags\nBio::SeqFeature::Annotated::get_tag_values\nBio::SeqFeature::Annotated::get_tagset_values\nBio::SeqFeature::Annotated::has_tag\nBio::SeqFeature::Annotated::length\nBio::SeqFeature::Annotated::location\nBio::SeqFeature::Annotated::name\nBio::SeqFeature::Annotated::new\nBio::SeqFeature::Annotated::phase\nBio::SeqFeature::Annotated::primary_tag\nBio::SeqFeature::Annotated::remove_Annotations\nBio::SeqFeature::Annotated::remove_SeqFeatures\nBio::SeqFeature::Annotated::remove_tag\nBio::SeqFeature::Annotated::score\nBio::SeqFeature::Annotated::seq\nBio::SeqFeature::Annotated::seq_id\nBio::SeqFeature::Annotated::source\nBio::SeqFeature::Annotated::source_tag\nBio::SeqFeature::Annotated::start\nBio::SeqFeature::Annotated::strand\nBio::SeqFeature::Annotated::type\nBio::SeqFeature::Annotated::uri_escape\nBio::SeqFeature::Annotated::uri_unescape\nBio::SeqFeature::TypedSeqFeatureI::croak\nBio::SeqFeature::TypedSeqFeatureI::ontology_term\nBio::SeqFeatureI::generate_unique_persistent_id\nBio::SeqFeatureI::gff_string\nBio::SeqFeatureI::primary_id\nBio::SeqFeatureI::spliced_seq\n\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args); \n\n    $self->_initialize(@args);\n\n    return $self;\n}\n\nsub _initialize {\n  my ($self,@args) = @_;\n  my ($start, $end, $strand, $frame, $phase, $score,\n      $name, $annot, $location,\n      $display_name, # deprecate\n      $seq_id, $type,$source,$feature\n     ) =\n        $self->_rearrange([qw(START\n                              END\n                              STRAND\n                              FRAME\n                              PHASE\n                              SCORE\n                              NAME\n                              ANNOTATION\n                              LOCATION\n                              DISPLAY_NAME\n                              SEQ_ID\n                              TYPE\n                              SOURCE\n\t\t\t      FEATURE\n                             )], @args);\n  defined $start        && $self->start($start);\n  defined $end          && $self->end($end);\n  defined $strand       && $self->strand($strand);\n  defined $frame        && $self->frame($frame);\n  defined $phase        && $self->phase($phase);\n  defined $score        && $self->score($score);\n  defined $source       && ref($source) ? $self->source($source) : $self->source_tag($source);\n  defined $type         && ref($type) ? $self->type($type) : $self->primary_tag($type);\n  defined $location     && $self->location($location);\n  defined $annot        && $self->annotation($annot);\n  defined $feature      && $self->from_feature($feature);\n\n  if( defined($display_name) && defined($name) ){\n\t  $self->throw('Cannot define (-id and -seq_id) or (-name and -display_name) attributes');\n  }\n  defined $seq_id                   && $self->seq_id($seq_id);\n  defined ($name || $display_name)  && $self->name($name || $display_name);\n}\n\n=head1 ATTRIBUTE ACCESSORS FOR Bio::SeqFeature::Annotated\n\n\n=head2 from_feature\n\n  Usage: $obj->from_feature($myfeature);\n  Desc : initialize this object with the contents of another feature\n         object.  Useful for converting objects like\n         L<Bio::SeqFeature::Generic> to this class\n  Ret  : nothing meaningful\n  Args : a single object of some other feature type,\n  Side Effects: throws error on failure\n  Example:\n\n\nsub from_feature {\n    my ($self,$feat,%opts) = @_;\n  \n    # should deal with any SeqFeatureI implementation (i.e. we don't want to\n    # automatically force a OO-heavy implementation on all classes)\n    ref($feat) && ($feat->isa('Bio::SeqFeatureI')) \n      or $self->throw('invalid arguments to from_feature');\n  \n    #TODO: add overrides in opts for these values, so people don't have to screw up their feature object\n    #if they don't want to\n  \n    ### set most of the data\n    foreach my $fieldname (qw/ start end strand frame score location seq_id source_tag primary_tag/) {\n      #no strict 'refs'; #using symbolic refs, yes, but using them for methods is allowed now\n      $self->$fieldname( $feat->$fieldname );\n    }\n\n    # now pick up the annotations/tags of the other feature\n    # We'll use AnnotationAdaptor to convert everything over\n\n    my %no_copy = map {$_ => 1} qw/seq_id source type frame phase score/;\n    my $adaptor = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n    for my $key ( $adaptor->get_all_annotation_keys() ) {\n        next if $no_copy{$key};\n        my @values = $adaptor->get_Annotations($key);\n        @values = _aggregate_scalar_annotations(\\%opts,$key,@values);\n        foreach my $val (@values) {\n            $self->add_Annotation($key,$val)\n        }\n    }\n}\n#given a key and its values, make the values into\n#Bio::Annotation::\\w+ objects\n\nsub _aggregate_scalar_annotations {\n  my ($opts,$key,@values) = @_;\n\n  #anything that's not an object, make it a SimpleValue\n  @values = map { ref($_) ? $_ : Bio::Annotation::SimpleValue->new(-value => $_) } @values;\n\n  #try to make Target objects\n  if($key eq 'Target' && (@values == 3 || @values == 4)\n     && @values == grep {$_->isa('Bio::Annotation::SimpleValue')} @values\n    ) {\n    @values = map {$_->value} @values;\n    #make a strand if it doesn't have one, enforcing start <= end\n    if(@values == 3) {\n      if($values[1] <= $values[2]) {\n\t$values[3] = '+';\n      } else {\n\t@values[1,2] = @values[2,1];\n\t$values[3] = '-';\n      }\n    }\n    return ( Bio::Annotation::Target->new( -target_id => $values[0],\n\t\t\t\t\t   -start     => $values[1],\n\t\t\t\t\t   -end       => $values[2],\n\t\t\t\t\t   -strand    => $values[3],\n\t\t\t\t\t )\n\t   );\n  }\n  #try to make DBLink objects\n  elsif($key eq 'dblink' || $key eq 'Dbxref') {\n    return map {\n      if( /:/ ) { #convert to a DBLink if it has a colon in it\n\tmy ($db,$id) = split /:/,$_->value;\n\tBio::Annotation::DBLink->new( -database   => $db,\n\t\t\t\t      -primary_id => $id,\n\t\t\t\t    );\n      } else { #otherwise leave as a SimpleValue\n\t$_\n      }\n    } @values;\n  }\n  #make OntologyTerm objects\n  elsif($key eq 'Ontology_term') {\n    return map { Bio::Annotation::OntologyTerm->new(-identifier => $_->value) } @values\n  }\n  #make Comment objects\n  elsif($key eq 'comment') {\n    return map { Bio::Annotation::Comment->new( -text => $_->value ) } @values;\n  }\n\n  return @values;\n}\n\n\n=head2 seq_id()\n\n Usage   : $obj->seq_id($newval)\n Function: holds a string corresponding to the unique\n           seq_id of the sequence underlying the feature\n           (e.g. database accession or primary key).\n Returns : string representing the seq_id.\n Args    : on set, some string or a Bio::Annotation::SimpleValue object.\n\n\nsub seq_id {\n  my($self,$val) = @_;\n  if (defined($val)) {\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value =~ /^>/)) {\n\t  $self->throw('give seq_id() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('seq_id');\n      $self->add_Annotation('seq_id', $term);\n  }\n\n  $self->seq_id('.') unless $self->get_Annotations('seq_id'); # make sure we always have something\n\n  return ($self->get_Annotations('seq_id'))[0]->value;\n}\n\n=head2 name()\n\n Usage   : $obj->name($newval)\n Function: human-readable name for the feature.\n Returns : value of name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub name {\n  my($self,$val) = @_;\n  $self->{'name'} = $val if defined($val);\n  return $self->{'name'};\n}\n\n=head2 type()\n\n Usage   : $obj->type($newval)\n Function: a SOFA type for the feature.\n Returns : Bio::Annotation::OntologyTerm object representing the type.\n           NB: to get a string, use primary_tag().\n Args    : on set, Bio::Annotation::OntologyTerm object.\n           NB: to set a string (SOFA name or identifier), use primary_tag()\n\n\nuse constant MAX_TYPE_CACHE_MEMBERS => 20;\nsub type {\n  my($self,$val) = @_;\n  if(defined($val)){\n    my $term = undef;\n\n    if(!ref($val)){\n      $self->throw(\"give type() a Bio::Annotation::OntologyTerm object, not a string\");\n    }\n    elsif(ref($val) && $val->isa('Bio::Annotation::OntologyTerm')){\n      $term = $val;\n    }\n    else {\n      #we have the wrong type of object\n      $self->throw('give type() a SOFA term name, identifier, or Bio::Annotation::OntologyTerm object, not '.$val);\n    }\n    $self->remove_Annotations('type');\n    $self->add_Annotation('type',$term);\n  }\n  \n  return $self->get_Annotations('type');\n}\n\n=head2 source()\n\n Usage   : $obj->source($newval)\n Function: holds the source of the feature.\n Returns : a Bio::Annotation::SimpleValue representing the source.\n           NB: to get a string, use source_tag()\n Args    : on set, a Bio::Annotation::SimpleValue object.\n           NB: to set a string, use source_tag()\n\n\nsub source {\n  my($self,$val) = @_;\n\n  if (defined($val)) {\n      my $term;\n      if (!ref($val)) {\n        $self->throw(\"give source() a Bio::Annotation::SimpleValue object, not a string\");\n        #$term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      } else {\n\t  $self->throw('give source() a scalar or Bio::Annotation::SimpleValue object, not '.$val);\n      }\n      $self->remove_Annotations('source');\n      $self->add_Annotation('source', $term);\n  }\n  \n  unless ($self->get_Annotations('source')) {\n    $self->source(Bio::Annotation::SimpleValue->new(-value => '.'));\n  }\n  return $self->get_Annotations('source');\n}\n\n=head2 score()\n\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: holds a value corresponding to the score of the feature.\n Returns : a string representing the score.\n Args    : on set, a scalar or a Bio::Annotation::SimpleValue object.\n\n\nsub score {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n\n      if ($term->value ne '.' &&\n           (!defined($term) || ($term->value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/))) {\n\t  $self->throw(\"'$val' is not a valid score\");\n      }\n      $self->remove_Annotations('score');\n      $self->add_Annotation('score', $term);\n  }\n\n  $self->score('.') unless scalar($self->get_Annotations('score')); # make sure we always have something\n\n  return ($self->get_Annotations('score'))[0]->display_text;\n}\n\n=head2 phase()\n\n Usage   : $phase = $feat->phase()\n           $feat->phase($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub phase {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid phase\");\n      }\n      $self->remove_Annotations('phase');\n      $self->add_Annotation('phase', $term);\n  }\n\n  $self->phase('.') unless $self->get_Annotations('phase'); # make sure we always have something\n  \n  return ($self->get_Annotations('phase'))[0]->value;\n}\n\n\n=head2 frame()\n\n Usage   : $frame = $feat->frame()\n           $feat->frame($phase)\n Function: get/set on phase information\n Returns : a string 0,1,2,'.'\n Args    : on set, one of 0,1,2,'.' or a Bio::Annotation::SimpleValue\n           object holding one of 0,1,2,'.' as its value.\n\n\nsub frame {\n  my $self = shift;\n  my $val = shift;\n\n  if(defined($val)){\n      my $term = undef;\n      if (!ref($val)) {\n\t  $term = Bio::Annotation::SimpleValue->new(-value => $val);\n      } elsif (ref($val) && $val->isa('Bio::Annotation::SimpleValue')) {\n\t  $term = $val;\n      }\n      if (!defined($term) || ($term->value !~ /^[0-2.]$/)) {\n\t  $self->throw(\"'$val' is not a valid frame\");\n      }\n      $self->remove_Annotations('frame');\n      $self->add_Annotation('frame', $term);\n  }\n\n  $self->frame('.') unless $self->get_Annotations('frame'); # make sure we always have something\n  \n  return ($self->get_Annotations('frame'))[0]->value;\n}\n\n############################################################\n\n=head1 SHORTCUT METHODS TO ACCESS Bio::AnnotatableI INTERFACE METHODS\n\n\n=head2 add_Annotation()\n\n Usage   :\n Function: $obj->add_Annotation() is a shortcut to $obj->annotation->add_Annotation\n Returns : \n Args    :\n\n\nsub add_Annotation {\n  my ($self,@args) = @_;\n  return $self->annotation->add_Annotation(@args);\n}\n\n=head2 remove_Annotations()\n\n Usage   :\n Function: $obj->remove_Annotations() is a shortcut to $obj->annotation->remove_Annotations\n Returns : \n Args    :\n\n\nsub remove_Annotations {\n  my ($self,@args) = @_;\n  return $self->annotation->remove_Annotations(@args);\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::SeqFeatureI\n\nNote that no methods are deprecated.  Any SeqFeatureI methods must return\nstrings (no objects).\n\n\n=head2 display_name()\n\n\nsub display_name {\n  my $self = shift;\n  return $self->name(@_);\n}\n\n=head2 primary_tag()\n\n\nsub primary_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    my $term;\n    if(!ref($val) && $val){\n      #we have a plain text annotation coming in.  try to map it to SOFA.\n\n      our %__type_cache; #a little cache of plaintext types we've already seen\n\n      #clear our cache if it gets too big\n      if(scalar(keys %__type_cache) > MAX_TYPE_CACHE_MEMBERS) {\n        %__type_cache = ();\n      }\n\n      #set $term to either a cached value, or look up a new one, throwing\n      #up if not found\n      my $anntext = $val;\n      if ($__type_cache{$anntext}) {\n        $term = $__type_cache{$anntext};\n      } else {\n        my $sofa = Bio::Ontology::OntologyStore->get_instance->get_ontology('Sequence Ontology OBO');\n        my ($soterm) = $anntext =~ /^\\D+:\\d+$/ #does it look like an ident?\n          ? ($sofa->find_terms(-identifier => $anntext))[0] #yes, lookup by ident\n          : ($sofa->find_terms(-name => $anntext))[0];      #no, lookup by name\n        #throw if it's not in SOFA\n        unless($soterm){\n          $self->throw(\"couldn't find a SOFA term matching type '$val'.\");\n        }\n        my $newterm = Bio::Annotation::OntologyTerm->new;\n        $newterm->term($soterm);\n        $term = $newterm;\n      }\n      \n      $self->type($term);\n    }\n  }\n  \n  my $t = $self->type() || return;\n  return $t->name;\n}\n\n=head2 source_tag()\n\n\nsub source_tag {\n  my $self = shift;\n  if (@_) {\n    my $val = shift;\n    if(!ref($val) && $val){\n      my $term = Bio::Annotation::SimpleValue->new(-value => uri_unescape($val));\n      $self->source($term);\n    }\n  }\n  my $t = $self->source() || return;\n  return $t->display_text;\n}\n\n\n=head2 attach_seq()\n\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( ! ($seq && ref($seq) && $seq->isa(\"Bio::PrimarySeqI\")) ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'seq'} = $seq;\n\n   # attach to sub features if they want it\n   foreach ( $self->get_SeqFeatures() ) {\n       $_->attach_seq($seq);\n   }\n   return 1;\n}\n\n=head2 seq()\n\n Usage   : $tseq = $sf->seq()\n Function: returns a truncated version of seq() with bounds matching this feature\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\nsub seq {\n  my ($self) = @_;\n\n  return unless defined($self->entire_seq());\n\n  my $seq = $self->entire_seq->trunc($self->start(), $self->end());\n\n  if ( defined $self->strand && $self->strand == -1 ) {\n    $seq = $seq->revcom;\n  }\n\n  return $seq;\n}\n\n=head2 entire_seq()\n\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    : none\n\n\nsub entire_seq {\n  return shift->{'seq'};\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::RangeI\n\n as inherited via Bio::SeqFeatureI\n\n\n=head2 length()\n\n Usage   : $feature->length()\n Function: Get the feature length computed as $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\nsub length {\n  my $self = shift;\n  return $self->end() - $self->start() + 1;\n}\n\n=head2 start()\n\n Usage   : $obj->start($newval)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub start {\n  my ($self,$value) = @_;\n  return $self->location->start($value);\n}\n\n=head2 end()\n\n Usage   : $obj->end($newval)\n Function: Get/set on the end coordinate of the feature\n Returns : integer\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub end {\n  my ($self,$value) = @_;\n  return $self->location->end($value);\n}\n\n=head2 strand()\n\n Usage   : $strand = $feat->strand($newval)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub strand {\n  my $self = shift;\n  return $self->location->strand(@_);\n}\n\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::FeatureHolderI\n\nThis includes methods for retrieving, adding, and removing\nfeatures. Since this is already a feature, features held by this\nfeature holder are essentially sub-features.\n\n\n=head2 get_SeqFeatures\n\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of Bio::SeqFeatureI objects\n Returns : An array\n Args    : none\n\n\nsub get_SeqFeatures {\n  return @{ shift->{'sub_array'} || []};\n}\n\n=head2 add_SeqFeature()\n\n Usage   : $feat->add_SeqFeature($subfeat);\n           $feat->add_SeqFeature($subfeat,'EXPAND')\n Function: adds a SeqFeature into the subSeqFeature array.\n           with no 'EXPAND' qualifer, subfeat will be tested\n           as to whether it lies inside the parent, and throw\n           an exception if not.\n\n           If EXPAND is used, the parent''s start/end/strand will\n           be adjusted so that it grows to accommodate the new\n           subFeature\n Example :\n Returns : nothing\n Args    : a Bio::SeqFeatureI object\n\n\nsub add_SeqFeature {\n  my ($self,$val, $expand) = @_;\n\n  return unless $val;\n\n  if ((!ref($val)) || !$val->isa('Bio::SeqFeatureI') ) {\n      $self->throw((ref($val) ? ref($val) : $val)\n                   .\" does not implement Bio::SeqFeatureI.\");\n  }\n\n  if($expand && ($expand eq 'EXPAND')) {\n      $self->_expand_region($val);\n  } else {\n      if ( !$self->contains($val) ) {\n\t  $self->warn(\"$val is not contained within parent feature, and expansion is not valid, ignoring.\");\n\t  return;\n      }\n  }\n\n  push(@{$self->{'sub_array'}},$val);\n}\n\n=head2 remove_SeqFeatures()\n\n Usage   : $obj->remove_SeqFeatures\n Function: Removes all sub SeqFeatures.  If you want to remove only a subset,\n           remove that subset from the returned array, and add back the rest.\n Returns : The array of Bio::SeqFeatureI implementing sub-features that was\n           deleted from this feature.\n Args    : none\n\n\nsub remove_SeqFeatures {\n  my ($self) = @_;\n\n  my @subfeats = @{$self->{'sub_array'} || []};\n  $self->{'sub_array'} = []; # zap the array.\n  return @subfeats;\n}\n\n############################################################\n\n=head1 INTERFACE METHODS FOR Bio::AnnotatableI\n\n\n=head2 annotation()\n\n Usage   : $obj->annotation($annot_obj)\n Function: Get/set the annotation collection object for annotating this\n           feature.\n Returns : A Bio::AnnotationCollectionI object\n Args    : newvalue (optional)\n\n\nsub annotation {\n    my ($obj,$value) = @_;\n\n    # we are smart if someone references the object and there hasn't been\n    # one set yet\n    if(defined $value || ! defined $obj->{'annotation'} ) {\n        $value = Bio::Annotation::Collection->new() unless ( defined $value );\n        $obj->{'annotation'} = $value;\n    }\n    return $obj->{'annotation'};\n}\n\n############################################################\n\n=head2 location()\n\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n           of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : [optional] Bio::LocationI object to set the value to.\n\n\nsub location {\n  my($self, $value ) = @_;\n\n  if (defined($value)) {\n    unless (ref($value) and $value->isa('Bio::LocationI')) {\n      $self->throw(\"object $value pretends to be a location but \".\n                   \"does not implement Bio::LocationI\");\n    }\n    $self->{'location'} = $value;\n  }\n  elsif (! $self->{'location'}) {\n    # guarantees a real location object is returned every time\n    $self->{'location'} = Bio::Location::Simple->new();\n  }\n  return $self->{'location'};\n}\n\n=head2 add_target()\n\n Usage   : $seqfeature->add_target(Bio::LocatableSeq->new(...));\n Function: adds a target location on another reference sequence for this feature\n Returns : true on success\n Args    : a Bio::LocatableSeq object\n\n\nsub add_target {\n  my ($self,$seq) = @_;\n  $self->throw(\"$seq is not a Bio::LocatableSeq, bailing out\") unless ref($seq) and seq->isa('Bio::LocatableSeq');\n  push @{ $self->{'targets'} }, $seq;\n  return $seq;\n}\n\n=head2 each_target()\n\n Usage   : @targets = $seqfeature->each_target();\n Function: Returns a list of Bio::LocatableSeqs which are the locations of this object.\n           To obtain the \"primary\" location, see L</location()>.\n Returns : a list of 0..N Bio::LocatableSeq objects\n Args    : none\n\n\nsub each_target {\n  my ($self) = @_;\n  return $self->{'targets'} ? @{ $self->{'targets'} } : ();\n}\n\n=head2 _expand_region\n\n Title   : _expand_region\n Usage   : $self->_expand_region($feature);\n Function: Expand the total region covered by this feature to\n           accomodate for the given feature.\n\n           May be called whenever any kind of subfeature is added to this\n           feature. add_SeqFeature() already does this.\n Returns : \n Args    : A Bio::SeqFeatureI implementing object.\n\n\nsub _expand_region {\n    my ($self, $feat) = @_;\n    if(! $feat->isa('Bio::SeqFeatureI')) {\n        $self->warn(\"$feat does not implement Bio::SeqFeatureI\");\n    }\n    # if this doesn't have start/end set - forget it!\n    if((! defined($self->start())) && (! defined $self->end())) {\n        $self->start($feat->start());\n        $self->end($feat->end());\n        $self->strand($feat->strand) unless defined($self->strand());\n#        $self->strand($feat->strand) unless $self->strand();\n    } else {\n        my $range = $self->union($feat);\n        $self->start($range->start);\n        $self->end($range->end);\n        $self->strand($range->strand);\n    }\n}\n\n=head2 get_Annotations\n\n Usage   : my $parent   = $obj->get_Annotations('Parent');\n           my @parents = $obj->get_Annotations('Parent');\n Function: a wrapper around Bio::Annotation::Collection::get_Annotations().\n Returns : returns annotations as\n           Bio::Annotation::Collection::get_Annotations() does, but\n           additionally returns a single scalar in scalar context\n           instead of list context so that if an annotation tag\n           contains only a single value, you can do:\n\n           $parent = $feature->get_Annotations('Parent');\n\n           instead of:\n\n           ($parent) = ($feature->get_Annotations('Parent'))[0];\n\n           if the 'Parent' tag has multiple values and is called in a\n           scalar context, the number of annotations is returned.\n\n Args    : an annotation tag name.\n\n\nsub get_Annotations {\n    my $self = shift;\n\n    my @annotations = $self->annotation->get_Annotations(@_);\n\n    if(wantarray){\n        return @annotations;\n    } elsif(scalar(@annotations) == 1){\n        return $annotations[0];\n    } else {\n        return scalar(@annotations);\n    }\n}\n\n=head1 Bio::SeqFeatureI implemented methods\n\nThese are specialized implementations of SeqFeatureI methods which call the\ninternal Bio::Annotation::AnnotationCollection object. Just prior to the 1.5\nrelease the below methods were moved from Bio::SeqFeatureI to Bio::AnnotatableI,\nand having Bio::SeqFeatureI inherit Bio::AnnotatableI. This behavior forced all\nBio::SeqFeatureI-implementing classes to use Bio::AnnotationI objects for any\ndata. It is the consensus of the core developers that this be rolled back in\nfavor of a more flexible approach by rolling back the above changes and making\nthis class Bio::AnnotatableI. The SeqFeatureI tag-related methods are\nreimplemented in order to approximate the same behavior as before.\n\nThe methods below allow mapping of the \"get_tag_values()\"-style annotation\naccess to Bio::AnnotationCollectionI. These need not be implemented in a\nBio::AnnotationCollectionI compliant class, as they are built on top of the\nmethods.  For usage, see Bio::SeqFeatureI.\n\n\n=head2 has_tag\n\n\nsub has_tag {\n  my ($self,$tag) = @_;\n  return scalar($self->annotation->get_Annotations($tag));\n}\n\n=head2 add_tag_value\n\n\nsub add_tag_value {\n  my ($self,$tag,@vals) = @_;\n\n  foreach my $val (@vals){\n    my $class = $tagclass{$tag}   || $tagclass{__DEFAULT__};\n    my $slot  = $tag2text{$class};\n\n    my $a = $class->new();\n    $a->$slot($val);\n\n    $self->annotation->add_Annotation($tag,$a);\n  }\n\n  return 1;\n}\n\n=head2 get_tag_values\n\n Usage   : @annotations = $obj->get_tag_values($tag)\n Function: returns annotations corresponding to $tag\n Returns : a list of scalars\n Args    : tag name\n\n\nsub get_tag_values {\n    my ($self,$tag) = @_;\n    if(!$tagclass{$tag} && $self->annotation->get_Annotations($tag)){\n        #new tag, haven't seen it yet but it exists.  add to registry\n        my($proto) = $self->annotation->get_Annotations($tag);\n        # we can only register if there's a method known for obtaining the value\n        if (exists($tag2text{ref($proto)})) {\n            $tagclass{$tag} = ref($proto);\n        }\n    }\n\n    my $slot  = $tag2text{ $tagclass{$tag} || $tagclass{__DEFAULT__} };\n    \n    return map { $_->$slot } $self->annotation->get_Annotations($tag);\n}\n\n=head2 get_tagset_values\n\n Usage   : @annotations = $obj->get_tagset_values($tag1,$tag2)\n Function: returns annotations corresponding to a list of tags.\n           this is a convenience method equivalent to multiple calls\n           to get_tag_values with each tag in the list.\n Returns : a list of Bio::AnnotationI objects.\n Args    : a list of tag names\n\n\nsub get_tagset_values {\n  my ($self,@tags) = @_;\n  my @r = ();\n  foreach my $tag (@tags){\n    my $slot  = $tag2text{ $tagclass{$tag} || $tagclass{__DEFAULT__} };\n    push @r, map { $_->$slot } $self->annotation->get_Annotations($tag);\n  }\n  return @r;\n}\n\n=head2 get_all_tags\n\n Usage   : @tags = $obj->get_all_tags()\n Function: returns a list of annotation tag names.\n Returns : a list of tag names\n Args    : none\n\n\nsub get_all_tags {\n  my ($self,@args) = @_;\n  return $self->annotation->get_all_annotation_keys(@args);\n}\n\n=head2 remove_tag\n\n Usage   : See remove_Annotations().\n Function:\n Returns : \n Args    : \n Note    : Contrary to what the name suggests, this method removes\n           all annotations corresponding to $tag, not just a\n           single anntoation.","label":"remove_tag($self,@args)"},"name":"remove_tag","containerName":"main::","children":[{"definition":"my","line":1199,"name":"$self","containerName":"remove_tag","localvar":"my","kind":13},{"containerName":"remove_tag","kind":13,"name":"@args","line":1199},{"name":"$self","containerName":"remove_tag","kind":13,"line":1200},{"line":1200,"name":"annotation","kind":12,"containerName":"remove_tag"},{"line":1200,"name":"remove_Annotations","containerName":"remove_tag","kind":12},{"name":"@args","kind":13,"containerName":"remove_tag","line":1200}],"detail":"($self,@args)","definition":"sub"}],"version":5}