{"version":5,"vars":[{"name":"base","containerName":"","kind":2,"line":82},{"line":102,"range":{"start":{"line":102,"character":0},"end":{"line":107,"character":9999}},"kind":12,"signature":{"label":"get_secondary_accessions($self,@args)","documentation":"1;\n# $Id: RichSeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::RichSeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::RichSeqI - interface for sequences from rich data sources, mostly databases\n\n=head1 SYNOPSIS\n\n    @secondary   = $richseq->get_secondary_accessions;\n    $division    = $richseq->division;\n    $mol         = $richseq->molecule;\n    @dates       = $richseq->get_dates;\n    $seq_version = $richseq->seq_version;\n    $pid         = $richseq->pid;\n    @keywords    = $richseq->get_keywords;\n\n=head1 DESCRIPTION\n\nThis interface extends the Bio::SeqI interface to give additional functionality\nto sequences with richer data sources, in particular from database sequences \n(EMBL, GenBank and Swissprot).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::RichSeqI;\nuse strict;\n\nuse base qw(Bio::SeqI);\n\n\n=head2 get_secondary_accessions\n\n Title   : get_secondary_accessions\n Usage   : \n Function: Get the secondary accessions for a sequence.\n\n           An implementation that allows modification of this array\n           property should provide the methods add_secondary_accession\n           and remove_secondary_accessions, with obvious purpose.\n\n Example :\n Returns : an array of strings\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}]},"children":[{"definition":"my","line":103,"containerName":"get_secondary_accessions","localvar":"my","kind":13,"name":"$self"},{"containerName":"get_secondary_accessions","kind":13,"name":"@args","line":103},{"line":105,"containerName":"get_secondary_accessions","kind":13,"name":"$self"},{"name":"throw","kind":12,"containerName":"get_secondary_accessions","line":105}],"name":"get_secondary_accessions","containerName":"main::","definition":"sub","detail":"($self,@args)"},{"kind":12,"range":{"start":{"line":125,"character":0},"end":{"line":130,"character":9999}},"line":125,"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: RichSeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::RichSeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::RichSeqI - interface for sequences from rich data sources, mostly databases\n\n=head1 SYNOPSIS\n\n    @secondary   = $richseq->get_secondary_accessions;\n    $division    = $richseq->division;\n    $mol         = $richseq->molecule;\n    @dates       = $richseq->get_dates;\n    $seq_version = $richseq->seq_version;\n    $pid         = $richseq->pid;\n    @keywords    = $richseq->get_keywords;\n\n=head1 DESCRIPTION\n\nThis interface extends the Bio::SeqI interface to give additional functionality\nto sequences with richer data sources, in particular from database sequences \n(EMBL, GenBank and Swissprot).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::RichSeqI;\nuse strict;\n\nuse base qw(Bio::SeqI);\n\n\n=head2 get_secondary_accessions\n\n Title   : get_secondary_accessions\n Usage   : \n Function: Get the secondary accessions for a sequence.\n\n           An implementation that allows modification of this array\n           property should provide the methods add_secondary_accession\n           and remove_secondary_accessions, with obvious purpose.\n\n Example :\n Returns : an array of strings\n Args    : none\n\n\n\nsub get_secondary_accessions{\n   my ($self,@args) = @_;\n\n   $self->throw(\"hit get_secondary_accessions in interface definition - error\");\n\n}\n\n\n=head2 division\n\n Title   : division\n Usage   :\n Function: Get (and set, depending on the implementation) the divison for\n           a sequence.\n\n           Examples from GenBank are PLN (plants), PRI (primates), etc.\n Example :\n Returns : a string\n Args    :","label":"division($self,@args)"},"containerName":"main::","name":"division","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"division","name":"$self","line":126},{"name":"@args","kind":13,"containerName":"division","line":126},{"containerName":"division","kind":13,"name":"$self","line":128},{"line":128,"containerName":"division","kind":12,"name":"throw"}],"detail":"($self,@args)","definition":"sub"},{"detail":"($self,@args)","definition":"sub","name":"molecule","containerName":"main::","children":[{"name":"$self","containerName":"molecule","localvar":"my","kind":13,"line":150,"definition":"my"},{"containerName":"molecule","kind":13,"name":"@args","line":150},{"name":"$self","containerName":"molecule","kind":13,"line":152},{"containerName":"molecule","kind":12,"name":"throw","line":152}],"signature":{"documentation":"1;\n# $Id: RichSeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::RichSeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::RichSeqI - interface for sequences from rich data sources, mostly databases\n\n=head1 SYNOPSIS\n\n    @secondary   = $richseq->get_secondary_accessions;\n    $division    = $richseq->division;\n    $mol         = $richseq->molecule;\n    @dates       = $richseq->get_dates;\n    $seq_version = $richseq->seq_version;\n    $pid         = $richseq->pid;\n    @keywords    = $richseq->get_keywords;\n\n=head1 DESCRIPTION\n\nThis interface extends the Bio::SeqI interface to give additional functionality\nto sequences with richer data sources, in particular from database sequences \n(EMBL, GenBank and Swissprot).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::RichSeqI;\nuse strict;\n\nuse base qw(Bio::SeqI);\n\n\n=head2 get_secondary_accessions\n\n Title   : get_secondary_accessions\n Usage   : \n Function: Get the secondary accessions for a sequence.\n\n           An implementation that allows modification of this array\n           property should provide the methods add_secondary_accession\n           and remove_secondary_accessions, with obvious purpose.\n\n Example :\n Returns : an array of strings\n Args    : none\n\n\n\nsub get_secondary_accessions{\n   my ($self,@args) = @_;\n\n   $self->throw(\"hit get_secondary_accessions in interface definition - error\");\n\n}\n\n\n=head2 division\n\n Title   : division\n Usage   :\n Function: Get (and set, depending on the implementation) the divison for\n           a sequence.\n\n           Examples from GenBank are PLN (plants), PRI (primates), etc.\n Example :\n Returns : a string\n Args    :\n\n\n\nsub division{\n   my ($self,@args) = @_;\n\n   $self->throw(\"hit division in interface definition - error\");\n\n}\n\n\n=head2 molecule\n\n Title   : molecule\n Usage   :\n Function: Get (and set, depending on the implementation) the molecule\n           type for the sequence.\n\n           This is not necessarily the same as Bio::PrimarySeqI::alphabet(),\n           because it is databank-specific.\n Example :\n Returns : a string\n Args    :","parameters":[{"label":"$self"},{"label":"@args"}],"label":"molecule($self,@args)"},"kind":12,"range":{"start":{"character":0,"line":149},"end":{"character":9999,"line":153}},"line":149},{"children":[{"definition":"my","line":169,"name":"$self","localvar":"my","containerName":"pid","kind":13},{"name":"@args","containerName":"pid","kind":13,"line":169},{"line":171,"kind":13,"containerName":"pid","name":"$self"},{"line":171,"kind":12,"containerName":"pid","name":"throw"}],"name":"pid","containerName":"main::","definition":"sub","detail":"($self,@args)","line":168,"kind":12,"range":{"start":{"character":0,"line":168},"end":{"line":172,"character":9999}},"signature":{"documentation":"1;\n# $Id: RichSeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::RichSeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::RichSeqI - interface for sequences from rich data sources, mostly databases\n\n=head1 SYNOPSIS\n\n    @secondary   = $richseq->get_secondary_accessions;\n    $division    = $richseq->division;\n    $mol         = $richseq->molecule;\n    @dates       = $richseq->get_dates;\n    $seq_version = $richseq->seq_version;\n    $pid         = $richseq->pid;\n    @keywords    = $richseq->get_keywords;\n\n=head1 DESCRIPTION\n\nThis interface extends the Bio::SeqI interface to give additional functionality\nto sequences with richer data sources, in particular from database sequences \n(EMBL, GenBank and Swissprot).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::RichSeqI;\nuse strict;\n\nuse base qw(Bio::SeqI);\n\n\n=head2 get_secondary_accessions\n\n Title   : get_secondary_accessions\n Usage   : \n Function: Get the secondary accessions for a sequence.\n\n           An implementation that allows modification of this array\n           property should provide the methods add_secondary_accession\n           and remove_secondary_accessions, with obvious purpose.\n\n Example :\n Returns : an array of strings\n Args    : none\n\n\n\nsub get_secondary_accessions{\n   my ($self,@args) = @_;\n\n   $self->throw(\"hit get_secondary_accessions in interface definition - error\");\n\n}\n\n\n=head2 division\n\n Title   : division\n Usage   :\n Function: Get (and set, depending on the implementation) the divison for\n           a sequence.\n\n           Examples from GenBank are PLN (plants), PRI (primates), etc.\n Example :\n Returns : a string\n Args    :\n\n\n\nsub division{\n   my ($self,@args) = @_;\n\n   $self->throw(\"hit division in interface definition - error\");\n\n}\n\n\n=head2 molecule\n\n Title   : molecule\n Usage   :\n Function: Get (and set, depending on the implementation) the molecule\n           type for the sequence.\n\n           This is not necessarily the same as Bio::PrimarySeqI::alphabet(),\n           because it is databank-specific.\n Example :\n Returns : a string\n Args    :\n\n\n\nsub molecule{\n   my ($self,@args) = @_;\n\n   $self->throw(\"hit molecule in interface definition - error\");\n}\n\n=head2 pid\n\n Title   : pid\n Usage   :\n Function: Get (and set, depending on the implementation) the PID property\n           for the sequence.\n Example :\n Returns : a string\n Args    :","parameters":[{"label":"$self"},{"label":"@args"}],"label":"pid($self,@args)"}},{"signature":{"documentation":"1;\n# $Id: RichSeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::RichSeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::RichSeqI - interface for sequences from rich data sources, mostly databases\n\n=head1 SYNOPSIS\n\n    @secondary   = $richseq->get_secondary_accessions;\n    $division    = $richseq->division;\n    $mol         = $richseq->molecule;\n    @dates       = $richseq->get_dates;\n    $seq_version = $richseq->seq_version;\n    $pid         = $richseq->pid;\n    @keywords    = $richseq->get_keywords;\n\n=head1 DESCRIPTION\n\nThis interface extends the Bio::SeqI interface to give additional functionality\nto sequences with richer data sources, in particular from database sequences \n(EMBL, GenBank and Swissprot).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::RichSeqI;\nuse strict;\n\nuse base qw(Bio::SeqI);\n\n\n=head2 get_secondary_accessions\n\n Title   : get_secondary_accessions\n Usage   : \n Function: Get the secondary accessions for a sequence.\n\n           An implementation that allows modification of this array\n           property should provide the methods add_secondary_accession\n           and remove_secondary_accessions, with obvious purpose.\n\n Example :\n Returns : an array of strings\n Args    : none\n\n\n\nsub get_secondary_accessions{\n   my ($self,@args) = @_;\n\n   $self->throw(\"hit get_secondary_accessions in interface definition - error\");\n\n}\n\n\n=head2 division\n\n Title   : division\n Usage   :\n Function: Get (and set, depending on the implementation) the divison for\n           a sequence.\n\n           Examples from GenBank are PLN (plants), PRI (primates), etc.\n Example :\n Returns : a string\n Args    :\n\n\n\nsub division{\n   my ($self,@args) = @_;\n\n   $self->throw(\"hit division in interface definition - error\");\n\n}\n\n\n=head2 molecule\n\n Title   : molecule\n Usage   :\n Function: Get (and set, depending on the implementation) the molecule\n           type for the sequence.\n\n           This is not necessarily the same as Bio::PrimarySeqI::alphabet(),\n           because it is databank-specific.\n Example :\n Returns : a string\n Args    :\n\n\n\nsub molecule{\n   my ($self,@args) = @_;\n\n   $self->throw(\"hit molecule in interface definition - error\");\n}\n\n=head2 pid\n\n Title   : pid\n Usage   :\n Function: Get (and set, depending on the implementation) the PID property\n           for the sequence.\n Example :\n Returns : a string\n Args    :\n\n\n\nsub pid {\n   my ($self,@args) = @_;\n\n   $self->throw(\"hit pid in interface definition - error\");\n}\n\n=head2 get_dates\n\n Title   : get_dates\n Usage   :\n Function: Get (and set, depending on the implementation) the dates the\n           databank entry specified for the sequence\n\n           An implementation that allows modification of this array\n           property should provide the methods add_date and\n           remove_dates, with obvious purpose.\n\n Example :\n Returns : an array of strings\n Args    :","parameters":[{"label":"$self"},{"label":"@args"}],"label":"get_dates($self,@args)"},"line":192,"range":{"end":{"line":197,"character":9999},"start":{"character":0,"line":192}},"kind":12,"definition":"sub","detail":"($self,@args)","children":[{"definition":"my","line":193,"name":"$self","localvar":"my","kind":13,"containerName":"get_dates"},{"containerName":"get_dates","kind":13,"name":"@args","line":193},{"containerName":"get_dates","kind":13,"name":"$self","line":195},{"kind":12,"containerName":"get_dates","name":"throw","line":195}],"containerName":"main::","name":"get_dates"},{"signature":{"label":"seq_version($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: RichSeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::RichSeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::RichSeqI - interface for sequences from rich data sources, mostly databases\n\n=head1 SYNOPSIS\n\n    @secondary   = $richseq->get_secondary_accessions;\n    $division    = $richseq->division;\n    $mol         = $richseq->molecule;\n    @dates       = $richseq->get_dates;\n    $seq_version = $richseq->seq_version;\n    $pid         = $richseq->pid;\n    @keywords    = $richseq->get_keywords;\n\n=head1 DESCRIPTION\n\nThis interface extends the Bio::SeqI interface to give additional functionality\nto sequences with richer data sources, in particular from database sequences \n(EMBL, GenBank and Swissprot).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::RichSeqI;\nuse strict;\n\nuse base qw(Bio::SeqI);\n\n\n=head2 get_secondary_accessions\n\n Title   : get_secondary_accessions\n Usage   : \n Function: Get the secondary accessions for a sequence.\n\n           An implementation that allows modification of this array\n           property should provide the methods add_secondary_accession\n           and remove_secondary_accessions, with obvious purpose.\n\n Example :\n Returns : an array of strings\n Args    : none\n\n\n\nsub get_secondary_accessions{\n   my ($self,@args) = @_;\n\n   $self->throw(\"hit get_secondary_accessions in interface definition - error\");\n\n}\n\n\n=head2 division\n\n Title   : division\n Usage   :\n Function: Get (and set, depending on the implementation) the divison for\n           a sequence.\n\n           Examples from GenBank are PLN (plants), PRI (primates), etc.\n Example :\n Returns : a string\n Args    :\n\n\n\nsub division{\n   my ($self,@args) = @_;\n\n   $self->throw(\"hit division in interface definition - error\");\n\n}\n\n\n=head2 molecule\n\n Title   : molecule\n Usage   :\n Function: Get (and set, depending on the implementation) the molecule\n           type for the sequence.\n\n           This is not necessarily the same as Bio::PrimarySeqI::alphabet(),\n           because it is databank-specific.\n Example :\n Returns : a string\n Args    :\n\n\n\nsub molecule{\n   my ($self,@args) = @_;\n\n   $self->throw(\"hit molecule in interface definition - error\");\n}\n\n=head2 pid\n\n Title   : pid\n Usage   :\n Function: Get (and set, depending on the implementation) the PID property\n           for the sequence.\n Example :\n Returns : a string\n Args    :\n\n\n\nsub pid {\n   my ($self,@args) = @_;\n\n   $self->throw(\"hit pid in interface definition - error\");\n}\n\n=head2 get_dates\n\n Title   : get_dates\n Usage   :\n Function: Get (and set, depending on the implementation) the dates the\n           databank entry specified for the sequence\n\n           An implementation that allows modification of this array\n           property should provide the methods add_date and\n           remove_dates, with obvious purpose.\n\n Example :\n Returns : an array of strings\n Args    :\n\n\n\nsub get_dates{\n   my ($self,@args) = @_;\n\n   $self->throw(\"hit get_dates in interface definition - error\");\n\n}\n\n\n=head2 seq_version\n\n Title   : seq_version\n Usage   :\n Function: Get (and set, depending on the implementation) the version string\n           of the sequence.\n Example :\n Returns : a string\n Args    :"},"line":213,"range":{"start":{"character":0,"line":213},"end":{"character":9999,"line":218}},"kind":12,"definition":"sub","detail":"($self,@args)","children":[{"kind":13,"localvar":"my","containerName":"seq_version","name":"$self","line":214,"definition":"my"},{"line":214,"containerName":"seq_version","kind":13,"name":"@args"},{"line":216,"containerName":"seq_version","kind":13,"name":"$self"},{"containerName":"seq_version","kind":12,"name":"throw","line":216}],"name":"seq_version","containerName":"main::"},{"detail":"($self)","definition":"sub","name":"get_keywords","containerName":"main::","children":[{"line":237,"localvar":"my","containerName":"get_keywords","kind":13,"name":"$self","definition":"my"},{"kind":13,"containerName":"get_keywords","name":"$self","line":238},{"line":238,"kind":12,"containerName":"get_keywords","name":"throw"}],"signature":{"label":"get_keywords($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: RichSeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::RichSeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::RichSeqI - interface for sequences from rich data sources, mostly databases\n\n=head1 SYNOPSIS\n\n    @secondary   = $richseq->get_secondary_accessions;\n    $division    = $richseq->division;\n    $mol         = $richseq->molecule;\n    @dates       = $richseq->get_dates;\n    $seq_version = $richseq->seq_version;\n    $pid         = $richseq->pid;\n    @keywords    = $richseq->get_keywords;\n\n=head1 DESCRIPTION\n\nThis interface extends the Bio::SeqI interface to give additional functionality\nto sequences with richer data sources, in particular from database sequences \n(EMBL, GenBank and Swissprot).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::RichSeqI;\nuse strict;\n\nuse base qw(Bio::SeqI);\n\n\n=head2 get_secondary_accessions\n\n Title   : get_secondary_accessions\n Usage   : \n Function: Get the secondary accessions for a sequence.\n\n           An implementation that allows modification of this array\n           property should provide the methods add_secondary_accession\n           and remove_secondary_accessions, with obvious purpose.\n\n Example :\n Returns : an array of strings\n Args    : none\n\n\n\nsub get_secondary_accessions{\n   my ($self,@args) = @_;\n\n   $self->throw(\"hit get_secondary_accessions in interface definition - error\");\n\n}\n\n\n=head2 division\n\n Title   : division\n Usage   :\n Function: Get (and set, depending on the implementation) the divison for\n           a sequence.\n\n           Examples from GenBank are PLN (plants), PRI (primates), etc.\n Example :\n Returns : a string\n Args    :\n\n\n\nsub division{\n   my ($self,@args) = @_;\n\n   $self->throw(\"hit division in interface definition - error\");\n\n}\n\n\n=head2 molecule\n\n Title   : molecule\n Usage   :\n Function: Get (and set, depending on the implementation) the molecule\n           type for the sequence.\n\n           This is not necessarily the same as Bio::PrimarySeqI::alphabet(),\n           because it is databank-specific.\n Example :\n Returns : a string\n Args    :\n\n\n\nsub molecule{\n   my ($self,@args) = @_;\n\n   $self->throw(\"hit molecule in interface definition - error\");\n}\n\n=head2 pid\n\n Title   : pid\n Usage   :\n Function: Get (and set, depending on the implementation) the PID property\n           for the sequence.\n Example :\n Returns : a string\n Args    :\n\n\n\nsub pid {\n   my ($self,@args) = @_;\n\n   $self->throw(\"hit pid in interface definition - error\");\n}\n\n=head2 get_dates\n\n Title   : get_dates\n Usage   :\n Function: Get (and set, depending on the implementation) the dates the\n           databank entry specified for the sequence\n\n           An implementation that allows modification of this array\n           property should provide the methods add_date and\n           remove_dates, with obvious purpose.\n\n Example :\n Returns : an array of strings\n Args    :\n\n\n\nsub get_dates{\n   my ($self,@args) = @_;\n\n   $self->throw(\"hit get_dates in interface definition - error\");\n\n}\n\n\n=head2 seq_version\n\n Title   : seq_version\n Usage   :\n Function: Get (and set, depending on the implementation) the version string\n           of the sequence.\n Example :\n Returns : a string\n Args    :\n\n\n\nsub seq_version{\n   my ($self,@args) = @_;\n\n   $self->throw(\"hit seq_version in interface definition - error\");\n\n}\n\n=head2 get_keywords\n\n Title   : get_keywords\n Usage   : $obj->get_keywords()\n Function: Get the keywords for this sequence object.\n\n           An implementation that allows modification of this array\n           property should provide the methods add_keyword and\n           remove_keywords, with obvious purpose.\n\n Returns : an array of strings\n Args    : "},"range":{"start":{"line":236,"character":0},"end":{"line":239,"character":9999}},"kind":12,"line":236}]}