{"version":5,"vars":[{"line":137,"kind":2,"containerName":"","name":"vars"},{"line":142,"containerName":"","kind":2,"name":"base"},{"kind":13,"containerName":null,"name":"$DEFAULT_NAME","line":146},{"name":"$GAP","kind":13,"containerName":null,"line":147},{"kind":13,"containerName":null,"name":"$META_GAP","line":148},{"children":[{"definition":"my","localvar":"my","containerName":"new","kind":13,"name":"$class","line":167},{"containerName":"new","kind":13,"name":"%args","line":167},{"kind":13,"containerName":"new","name":"$args","line":170},{"containerName":"new","kind":13,"name":"@ISA","line":171},{"line":171,"name":"$args","kind":13,"containerName":"new"},{"line":174,"name":"@ISA","containerName":"new","kind":13},{"definition":"my","name":"$self","containerName":"new","localvar":"my","kind":13,"line":177},{"name":"$class","containerName":"new","kind":13,"line":177},{"name":"%args","kind":13,"containerName":"new","line":177},{"definition":"my","line":179,"containerName":"new","localvar":"my","kind":13,"name":"$meta"},{"line":179,"kind":13,"containerName":"new","name":"$forceflush"},{"line":180,"containerName":"new","kind":13,"name":"$self"},{"name":"_rearrange","kind":12,"containerName":"new","line":180},{"name":"%args","kind":13,"containerName":"new","line":183},{"kind":13,"containerName":"new","name":"$self","line":185},{"containerName":"new","kind":13,"name":"$DEFAULT_NAME","line":185},{"containerName":"new","kind":13,"name":"$meta","line":187},{"line":187,"name":"$self","containerName":"new","kind":13},{"line":187,"containerName":"new","kind":12,"name":"meta"},{"kind":13,"containerName":"new","name":"$meta","line":187},{"name":"$forceflush","kind":13,"containerName":"new","line":188},{"line":188,"name":"$self","containerName":"new","kind":13},{"line":188,"containerName":"new","kind":12,"name":"force_flush"},{"name":"$forceflush","kind":13,"containerName":"new","line":188},{"line":190,"containerName":"new","kind":13,"name":"$self"}],"name":"new","containerName":"main::","definition":"sub","detail":"($class,%args)","line":166,"kind":12,"range":{"start":{"character":0,"line":166},"end":{"character":9999,"line":191}},"signature":{"documentation":"1;\n# $Id: Array.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::Meta::Array\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::Meta::Array - array-based generic implementation of a\nsequence class with residue-based meta information\n\n=head1 SYNOPSIS\n\n  use Bio::LocatableSeq;\n  use Bio::Seq::Meta::Array;\n\n  my $seq = Bio::Seq::Meta::Array->new(-id=>'test',\n                                   -seq=>'ACTGCTAGCT',\n                                   -start=>2434,\n                                   -start=>2443,\n                                   -strand=>1,\n                                   -varbose=>1, # to see warnings\n                                  );\n\n  # to test this is a meta seq object\n  $seq->isa(\"Bio::Seq::Meta::Array\")\n      || $seq->throw(\"$seq is not a Bio::Seq::Meta::Array\");\n\n  $seq->meta('1 2 3 4 5 6 7 8 9 10');\n\n  # or you could create the Meta object directly\n  $seq = Bio::Seq::Meta::Array->new(-id=>'test',\n                                    -seq=>'ACTGCTAGCT',\n                                    -start=>2434,\n                                    -start=>2443,\n                                    -strand=>1,\n                                    -meta=>'1 2 3 4 5 6 7 8 9 10',\n                                    -varbose=>1, # to see warnings\n                                   );\n\n\n  # accessors\n  $arrayref   = $seq->meta();\n  $string     = $seq->meta_text();\n  $substring  = $seq->submeta_text(2,5);\n  $unique_key = $seq->accession_number();\n\n=head1 DESCRIPTION\n\nThis class implements generic methods for sequences with residue-based\nmeta information. Meta sequences with meta data are Bio::LocatableSeq\nobjects with additional methods to store that meta information. See\nL<Bio::LocatableSeq> and L<Bio::Seq::MetaI>.\n\nThe meta information in this class can be a string of variable length\nand can be a complex structure.  Blank values are undef or zero.\n\nApplication specific implementations should inherit from this class to\noverride and add to these methods.\n\nThis class can be used for storing sequence quality values but\nBio::Seq::Quality has named methods that make it easier.\n\n=head1 SEE ALSO\n\nL<Bio::LocatableSeq>,\nL<Bio::Seq::MetaI>,\nL<Bio::Seq::Meta>,\nL<Bio::Seq::Quality>\n\n=head1 NOTE\n\nThis Bio::Seq::MetaI implementation inherits from Bio::LocatableSeq, which\nitself inherits from Bio::PrimarySeq. It is not a Bio::SeqI, so bless-ing\nobjects of this class into a Bio::SeqI or vice versa and will not work as\nexpected (see bug 2262). This may be addressed in a future refactor of\nBio::LocatableSeq.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nChad Matsalla, bioinformatics@dieselwurks.com\nAaron Mackey, amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::Meta::Array;\nuse vars qw(@ISA $DEFAULT_NAME $GAP $META_GAP);\nuse strict;\n\n#use overload '\"\"' => \\&to_string;\n\nuse base qw(Bio::LocatableSeq Bio::Seq Bio::Seq::MetaI);\n\nBEGIN {\n\n    $DEFAULT_NAME = 'DEFAULT';\n    $GAP = '-';\n    $META_GAP = 0;\n}\n\n=head2 new\n\n Title   : new\n Usage   : $metaseq = Bio::Seq::Meta::Array->new\n\t        ( -meta => 'aaaaaaaabbbbbbbb',\n                  -seq =>  'TKLMILVSHIVILSRM'\n\t          -id  => 'human_id',\n\t          -accession_number => 'S000012',\n\t        );\n Function: Constructor for Bio::Seq::Meta::Array class, meta data being in a\n           string. Note that you can provide an empty quality string.\n Returns : a new Bio::Seq::Meta::Array object","parameters":[{"label":"$class"},{"label":"%args"}],"label":"new($class,%args)"}},{"line":177,"containerName":"new","kind":12,"name":"SUPER"},{"range":{"start":{"character":0,"line":212},"end":{"line":214,"character":9999}},"kind":12,"line":212,"definition":"sub","containerName":"main::","name":"meta","children":[{"name":"named_meta","containerName":"meta","kind":12,"line":213},{"kind":13,"containerName":"meta","name":"$DEFAULT_NAME","line":213}]},{"children":[{"kind":12,"containerName":"meta_text","name":"meta","line":228}],"name":"meta_text","containerName":"main::","definition":"sub","line":227,"range":{"start":{"line":227,"character":0},"end":{"line":228,"character":9999}},"kind":12},{"kind":12,"name":"shift","line":228},{"name":"named_meta","containerName":"main::","children":[{"definition":"my","line":244,"name":"$self","containerName":"named_meta","localvar":"my","kind":13},{"containerName":"named_meta","kind":13,"name":"$name","line":244},{"name":"$value","containerName":"named_meta","kind":13,"line":244},{"line":246,"kind":13,"containerName":"named_meta","name":"$name"},{"line":246,"name":"$DEFAULT_NAME","kind":13,"containerName":"named_meta"},{"name":"$value","containerName":"named_meta","kind":13,"line":248},{"localvar":"my","containerName":"named_meta","kind":13,"name":"$arrayref","line":249,"definition":"my"},{"name":"$value","kind":13,"containerName":"named_meta","line":251},{"line":252,"containerName":"named_meta","kind":13,"name":"$arrayref"},{"line":252,"name":"$value","containerName":"named_meta","kind":13},{"line":254,"name":"$value","containerName":"named_meta","kind":13},{"containerName":"named_meta","kind":13,"name":"$arrayref","line":255},{"line":255,"name":"$value","containerName":"named_meta","kind":13},{"line":257,"name":"$self","containerName":"named_meta","kind":13},{"kind":12,"containerName":"named_meta","name":"throw","line":257},{"line":257,"kind":13,"containerName":"named_meta","name":"$value"},{"definition":"my","line":261,"name":"$diff","localvar":"my","containerName":"named_meta","kind":13},{"name":"$self","kind":13,"containerName":"named_meta","line":261},{"line":261,"name":"length","containerName":"named_meta","kind":12},{"line":261,"kind":13,"containerName":"named_meta","name":"$arrayref"},{"name":"$diff","containerName":"named_meta","kind":13,"line":262},{"kind":13,"containerName":"named_meta","name":"$diff","line":263},{"name":"$arrayref","kind":13,"containerName":"named_meta","line":263}],"detail":"($self,$name,$value)","definition":"sub","kind":12,"range":{"start":{"line":243,"character":0},"end":{"line":264,"character":9999}},"line":243,"signature":{"label":"named_meta($self,$name,$value)","documentation":"1;\n# $Id: Array.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::Meta::Array\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::Meta::Array - array-based generic implementation of a\nsequence class with residue-based meta information\n\n=head1 SYNOPSIS\n\n  use Bio::LocatableSeq;\n  use Bio::Seq::Meta::Array;\n\n  my $seq = Bio::Seq::Meta::Array->new(-id=>'test',\n                                   -seq=>'ACTGCTAGCT',\n                                   -start=>2434,\n                                   -start=>2443,\n                                   -strand=>1,\n                                   -varbose=>1, # to see warnings\n                                  );\n\n  # to test this is a meta seq object\n  $seq->isa(\"Bio::Seq::Meta::Array\")\n      || $seq->throw(\"$seq is not a Bio::Seq::Meta::Array\");\n\n  $seq->meta('1 2 3 4 5 6 7 8 9 10');\n\n  # or you could create the Meta object directly\n  $seq = Bio::Seq::Meta::Array->new(-id=>'test',\n                                    -seq=>'ACTGCTAGCT',\n                                    -start=>2434,\n                                    -start=>2443,\n                                    -strand=>1,\n                                    -meta=>'1 2 3 4 5 6 7 8 9 10',\n                                    -varbose=>1, # to see warnings\n                                   );\n\n\n  # accessors\n  $arrayref   = $seq->meta();\n  $string     = $seq->meta_text();\n  $substring  = $seq->submeta_text(2,5);\n  $unique_key = $seq->accession_number();\n\n=head1 DESCRIPTION\n\nThis class implements generic methods for sequences with residue-based\nmeta information. Meta sequences with meta data are Bio::LocatableSeq\nobjects with additional methods to store that meta information. See\nL<Bio::LocatableSeq> and L<Bio::Seq::MetaI>.\n\nThe meta information in this class can be a string of variable length\nand can be a complex structure.  Blank values are undef or zero.\n\nApplication specific implementations should inherit from this class to\noverride and add to these methods.\n\nThis class can be used for storing sequence quality values but\nBio::Seq::Quality has named methods that make it easier.\n\n=head1 SEE ALSO\n\nL<Bio::LocatableSeq>,\nL<Bio::Seq::MetaI>,\nL<Bio::Seq::Meta>,\nL<Bio::Seq::Quality>\n\n=head1 NOTE\n\nThis Bio::Seq::MetaI implementation inherits from Bio::LocatableSeq, which\nitself inherits from Bio::PrimarySeq. It is not a Bio::SeqI, so bless-ing\nobjects of this class into a Bio::SeqI or vice versa and will not work as\nexpected (see bug 2262). This may be addressed in a future refactor of\nBio::LocatableSeq.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nChad Matsalla, bioinformatics@dieselwurks.com\nAaron Mackey, amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::Meta::Array;\nuse vars qw(@ISA $DEFAULT_NAME $GAP $META_GAP);\nuse strict;\n\n#use overload '\"\"' => \\&to_string;\n\nuse base qw(Bio::LocatableSeq Bio::Seq Bio::Seq::MetaI);\n\nBEGIN {\n\n    $DEFAULT_NAME = 'DEFAULT';\n    $GAP = '-';\n    $META_GAP = 0;\n}\n\n=head2 new\n\n Title   : new\n Usage   : $metaseq = Bio::Seq::Meta::Array->new\n\t        ( -meta => 'aaaaaaaabbbbbbbb',\n                  -seq =>  'TKLMILVSHIVILSRM'\n\t          -id  => 'human_id',\n\t          -accession_number => 'S000012',\n\t        );\n Function: Constructor for Bio::Seq::Meta::Array class, meta data being in a\n           string. Note that you can provide an empty quality string.\n Returns : a new Bio::Seq::Meta::Array object\n\n\nsub new {\n    my ($class, %args) = @_;\n\t#defined inheritance according to stated baseclass,\n\t#if undefined then will be PrimarySeq\n\tif (defined($args{'-baseclass'})) {\n\t\t@ISA = ($args{'-baseclass'},\"Bio::Seq::MetaI\");\n\t\t}\n\telse {\n\t\t@ISA = qw( Bio::LocatableSeq Bio::Seq Bio::Seq::MetaI );\n\t\t}\n\n    my $self = $class->SUPER::new(%args);\n\n    my($meta, $forceflush) =\n        $self->_rearrange([qw(META\n                              FORCE_FLUSH\n                              )],\n                          %args);\n\n    $self->{'_meta'}->{$DEFAULT_NAME} = [];\n\n    $meta && $self->meta($meta);\n    $forceflush && $self->force_flush($forceflush);\n\n    return $self;\n}\n\n\n=head2 meta\n\n Title   : meta\n Usage   : $meta_values  = $obj->meta($values_string);\n Function:\n\n           Get and set method for the meta data starting from residue\n           position one. Since it is dependent on the length of the\n           sequence, it needs to be manipulated after the sequence.\n\n           The length of the returned value always matches the length\n           of the sequence.\n\n Returns : reference to an array of meta data\n Args    : new value, string or array ref, optional\n\n\nsub meta {\n   shift->named_meta($DEFAULT_NAME, shift);\n}\n\n=head2 meta_text\n\n Title   : meta_text\n Usage   : $meta_values  = $obj->meta_text($values_arrayref);\n Function: Variant of meta() guarantied to return a string\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, string or array ref, optional\n\n\nsub meta_text {\n    return join ' ',  map {0 unless $_} @{shift->meta(shift)};\n}\n\n=head2 named_meta\n\n Title   : named_meta()\n Usage   : $meta_values  = $obj->named_meta($name, $values_arrayref);\n Function: A more general version of meta(). Each meta data set needs\n           to be named. See also L<meta_names>.\n Returns : reference to an array of meta data\n Args    : scalar, name of the meta data set\n           new value, string or array ref, optional","parameters":[{"label":"$self"},{"label":"$name"},{"label":"$value"}]}},{"containerName":null,"kind":13,"name":"%self","line":266},{"line":266,"kind":13,"containerName":null,"name":"$name"},{"line":266,"name":"$arrayref","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$self","line":271},{"line":271,"name":"_do_flush","containerName":"main::","kind":12},{"line":271,"name":"$self","containerName":null,"kind":13},{"line":271,"name":"force_flush","kind":12,"containerName":"main::"},{"line":273,"name":"%self","kind":13,"containerName":null},{"line":273,"containerName":null,"kind":13,"name":"$name"},{"line":273,"name":"$self","kind":13,"containerName":null},{"name":"length","containerName":"main::","kind":12,"line":273},{"line":295,"kind":12,"range":{"start":{"character":0,"line":295},"end":{"line":310,"character":9999}},"children":[{"line":296,"name":"$self","containerName":"_test_gap_positions","localvar":"my","kind":13,"definition":"my"},{"name":"$name","kind":13,"localvar":"my","containerName":"_test_gap_positions","line":297,"definition":"my"},{"line":298,"name":"$success","kind":13,"localvar":"my","containerName":"_test_gap_positions","definition":"my"},{"name":"$self","kind":13,"containerName":"_test_gap_positions","line":300},{"line":300,"containerName":"_test_gap_positions","kind":12,"name":"seq"},{"name":"$success","kind":13,"containerName":"_test_gap_positions","line":300},{"line":301,"localvar":"my","kind":13,"containerName":"_test_gap_positions","name":"$len","definition":"my"},{"line":301,"name":"$self","kind":13,"containerName":"_test_gap_positions"},{"name":"seq","containerName":"_test_gap_positions","kind":12,"line":301},{"name":"$i","containerName":"_test_gap_positions","localvar":"my","kind":13,"line":302,"definition":"my"},{"line":302,"name":"$i","kind":13,"containerName":"_test_gap_positions"},{"line":302,"name":"$len","containerName":"_test_gap_positions","kind":13},{"line":302,"kind":13,"containerName":"_test_gap_positions","name":"$i"},{"name":"$s","containerName":"_test_gap_positions","localvar":"my","kind":13,"line":303,"definition":"my"},{"line":303,"kind":13,"containerName":"_test_gap_positions","name":"$self"},{"containerName":"_test_gap_positions","kind":13,"name":"$i","line":303},{"line":304,"name":"$m","localvar":"my","containerName":"_test_gap_positions","kind":13,"definition":"my"},{"line":304,"name":"$self","kind":13,"containerName":"_test_gap_positions"},{"name":"$name","kind":13,"containerName":"_test_gap_positions","line":304},{"line":304,"containerName":"_test_gap_positions","kind":13,"name":"$i"},{"name":"$self","kind":13,"containerName":"_test_gap_positions","line":305},{"kind":12,"containerName":"_test_gap_positions","name":"warn","line":305},{"line":305,"name":"$i","kind":13,"containerName":"_test_gap_positions"},{"containerName":"_test_gap_positions","kind":13,"name":"$self","line":305},{"line":305,"name":"id","containerName":"_test_gap_positions","kind":12},{"name":"$success","containerName":"_test_gap_positions","kind":13,"line":306},{"line":307,"kind":13,"containerName":"_test_gap_positions","name":"$m"},{"name":"$s","containerName":"_test_gap_positions","kind":13,"line":307},{"line":307,"containerName":"_test_gap_positions","kind":13,"name":"$m"},{"line":309,"name":"$success","containerName":"_test_gap_positions","kind":13}],"containerName":"main::","name":"_test_gap_positions","definition":"sub"},{"line":301,"containerName":"length","kind":12,"name":"CORE"},{"line":303,"name":"seq","kind":12},{"kind":12,"name":"_meta","line":304},{"line":325,"kind":12,"range":{"end":{"line":326,"character":9999},"start":{"line":325,"character":0}},"children":[{"containerName":"named_meta_text","kind":12,"name":"named_meta","line":326}],"name":"named_meta_text","containerName":"main::","definition":"sub"},{"line":326,"kind":12,"name":"shift"},{"line":358,"range":{"end":{"line":360,"character":9999},"start":{"line":358,"character":0}},"kind":12,"definition":"sub","children":[{"line":359,"name":"named_submeta","kind":12,"containerName":"submeta"},{"kind":13,"containerName":"submeta","name":"$DEFAULT_NAME","line":359}],"name":"submeta","containerName":"main::"},{"children":[{"line":375,"containerName":"submeta_text","kind":12,"name":"named_submeta"},{"line":375,"name":"$DEFAULT_NAME","kind":13,"containerName":"submeta_text"}],"containerName":"main::","name":"submeta_text","definition":"sub","line":374,"range":{"end":{"line":375,"character":9999},"start":{"line":374,"character":0}},"kind":12},{"kind":12,"name":"shift","line":375},{"name":"named_submeta","containerName":"main::","children":[{"definition":"my","line":395,"localvar":"my","kind":13,"containerName":"named_submeta","name":"$self"},{"name":"$name","kind":13,"containerName":"named_submeta","line":395},{"line":395,"kind":13,"containerName":"named_submeta","name":"$start"},{"kind":13,"containerName":"named_submeta","name":"$end","line":395},{"name":"$value","kind":13,"containerName":"named_submeta","line":395},{"line":397,"kind":13,"containerName":"named_submeta","name":"$name"},{"name":"$DEFAULT_NAME","containerName":"named_submeta","kind":13,"line":397},{"line":398,"name":"$start","containerName":"named_submeta","kind":13},{"name":"$start","containerName":"named_submeta","kind":13,"line":399},{"containerName":"named_submeta","kind":13,"name":"$start","line":399},{"line":400,"name":"$self","kind":13,"containerName":"named_submeta"},{"name":"throw","containerName":"named_submeta","kind":12,"line":400},{"name":"$start","containerName":"named_submeta","kind":13,"line":401},{"definition":"my","line":402,"kind":13,"localvar":"my","containerName":"named_submeta","name":"$meta_len"},{"name":"$self","containerName":"named_submeta","kind":13,"line":402},{"line":402,"kind":13,"containerName":"named_submeta","name":"$name"}],"detail":"($self,$name,$start,$end,$value)","definition":"sub","range":{"start":{"character":0,"line":394},"end":{"line":402,"character":9999}},"kind":12,"line":394,"signature":{"label":"named_submeta($self,$name,$start,$end,$value)","documentation":"1;\n# $Id: Array.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::Meta::Array\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::Meta::Array - array-based generic implementation of a\nsequence class with residue-based meta information\n\n=head1 SYNOPSIS\n\n  use Bio::LocatableSeq;\n  use Bio::Seq::Meta::Array;\n\n  my $seq = Bio::Seq::Meta::Array->new(-id=>'test',\n                                   -seq=>'ACTGCTAGCT',\n                                   -start=>2434,\n                                   -start=>2443,\n                                   -strand=>1,\n                                   -varbose=>1, # to see warnings\n                                  );\n\n  # to test this is a meta seq object\n  $seq->isa(\"Bio::Seq::Meta::Array\")\n      || $seq->throw(\"$seq is not a Bio::Seq::Meta::Array\");\n\n  $seq->meta('1 2 3 4 5 6 7 8 9 10');\n\n  # or you could create the Meta object directly\n  $seq = Bio::Seq::Meta::Array->new(-id=>'test',\n                                    -seq=>'ACTGCTAGCT',\n                                    -start=>2434,\n                                    -start=>2443,\n                                    -strand=>1,\n                                    -meta=>'1 2 3 4 5 6 7 8 9 10',\n                                    -varbose=>1, # to see warnings\n                                   );\n\n\n  # accessors\n  $arrayref   = $seq->meta();\n  $string     = $seq->meta_text();\n  $substring  = $seq->submeta_text(2,5);\n  $unique_key = $seq->accession_number();\n\n=head1 DESCRIPTION\n\nThis class implements generic methods for sequences with residue-based\nmeta information. Meta sequences with meta data are Bio::LocatableSeq\nobjects with additional methods to store that meta information. See\nL<Bio::LocatableSeq> and L<Bio::Seq::MetaI>.\n\nThe meta information in this class can be a string of variable length\nand can be a complex structure.  Blank values are undef or zero.\n\nApplication specific implementations should inherit from this class to\noverride and add to these methods.\n\nThis class can be used for storing sequence quality values but\nBio::Seq::Quality has named methods that make it easier.\n\n=head1 SEE ALSO\n\nL<Bio::LocatableSeq>,\nL<Bio::Seq::MetaI>,\nL<Bio::Seq::Meta>,\nL<Bio::Seq::Quality>\n\n=head1 NOTE\n\nThis Bio::Seq::MetaI implementation inherits from Bio::LocatableSeq, which\nitself inherits from Bio::PrimarySeq. It is not a Bio::SeqI, so bless-ing\nobjects of this class into a Bio::SeqI or vice versa and will not work as\nexpected (see bug 2262). This may be addressed in a future refactor of\nBio::LocatableSeq.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nChad Matsalla, bioinformatics@dieselwurks.com\nAaron Mackey, amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::Meta::Array;\nuse vars qw(@ISA $DEFAULT_NAME $GAP $META_GAP);\nuse strict;\n\n#use overload '\"\"' => \\&to_string;\n\nuse base qw(Bio::LocatableSeq Bio::Seq Bio::Seq::MetaI);\n\nBEGIN {\n\n    $DEFAULT_NAME = 'DEFAULT';\n    $GAP = '-';\n    $META_GAP = 0;\n}\n\n=head2 new\n\n Title   : new\n Usage   : $metaseq = Bio::Seq::Meta::Array->new\n\t        ( -meta => 'aaaaaaaabbbbbbbb',\n                  -seq =>  'TKLMILVSHIVILSRM'\n\t          -id  => 'human_id',\n\t          -accession_number => 'S000012',\n\t        );\n Function: Constructor for Bio::Seq::Meta::Array class, meta data being in a\n           string. Note that you can provide an empty quality string.\n Returns : a new Bio::Seq::Meta::Array object\n\n\nsub new {\n    my ($class, %args) = @_;\n\t#defined inheritance according to stated baseclass,\n\t#if undefined then will be PrimarySeq\n\tif (defined($args{'-baseclass'})) {\n\t\t@ISA = ($args{'-baseclass'},\"Bio::Seq::MetaI\");\n\t\t}\n\telse {\n\t\t@ISA = qw( Bio::LocatableSeq Bio::Seq Bio::Seq::MetaI );\n\t\t}\n\n    my $self = $class->SUPER::new(%args);\n\n    my($meta, $forceflush) =\n        $self->_rearrange([qw(META\n                              FORCE_FLUSH\n                              )],\n                          %args);\n\n    $self->{'_meta'}->{$DEFAULT_NAME} = [];\n\n    $meta && $self->meta($meta);\n    $forceflush && $self->force_flush($forceflush);\n\n    return $self;\n}\n\n\n=head2 meta\n\n Title   : meta\n Usage   : $meta_values  = $obj->meta($values_string);\n Function:\n\n           Get and set method for the meta data starting from residue\n           position one. Since it is dependent on the length of the\n           sequence, it needs to be manipulated after the sequence.\n\n           The length of the returned value always matches the length\n           of the sequence.\n\n Returns : reference to an array of meta data\n Args    : new value, string or array ref, optional\n\n\nsub meta {\n   shift->named_meta($DEFAULT_NAME, shift);\n}\n\n=head2 meta_text\n\n Title   : meta_text\n Usage   : $meta_values  = $obj->meta_text($values_arrayref);\n Function: Variant of meta() guarantied to return a string\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, string or array ref, optional\n\n\nsub meta_text {\n    return join ' ',  map {0 unless $_} @{shift->meta(shift)};\n}\n\n=head2 named_meta\n\n Title   : named_meta()\n Usage   : $meta_values  = $obj->named_meta($name, $values_arrayref);\n Function: A more general version of meta(). Each meta data set needs\n           to be named. See also L<meta_names>.\n Returns : reference to an array of meta data\n Args    : scalar, name of the meta data set\n           new value, string or array ref, optional\n\n\nsub named_meta {\n   my ($self, $name, $value) = @_;\n\n   $name ||= $DEFAULT_NAME;\n\n   if (defined $value) {\n       my ($arrayref);\n\n       if (ref $value eq 'ARRAY' ) { # array ref\n           $arrayref = $value;\n       }\n       elsif (not ref($value)) { # scalar\n           $arrayref = [split /\\s+/, $value];\n       } else {\n           $self->throw(\"I need a scalar or array ref, not [\". ref($value). \"]\");\n       }\n\n       # test for length\n       my $diff = $self->length - @{$arrayref};\n       if ($diff > 0) {\n           foreach (1..$diff) { push @{$arrayref}, 0;}\n       }\n\n       $self->{'_meta'}->{$name} = $arrayref;\n\n       #$self->_test_gap_positions($name) if $self->verbose > 0;\n   }\n\n   $self->_do_flush if $self->force_flush;\n\n   return $self->{'_meta'}->{$name} || (\" \" x $self->length);\n\n}\n\n=head2 _test_gap_positions\n\n Title   : _test_gap_positions\n Usage   : $meta_values  = $obj->_test_gap_positions($name);\n Function: Internal test for correct position of gap characters.\n           Gap being only '-' this time.\n\n           This method is called from named_meta() when setting meta\n           data but only if verbose is positive as this can be an\n           expensive process on very long sequences. Set verbose(1) to\n           see warnings when gaps do not align in sequence and meta\n           data and turn them into errors by setting verbose(2).\n\n Returns : true on success, prints warnings\n Args    : none\n\n\nsub _test_gap_positions {\n    my $self = shift;\n    my $name = shift;\n    my $success = 1;\n\n    $self->seq || return $success;\n    my $len = CORE::length($self->seq);\n    for (my $i=0; $i < $len; $i++) {\n        my $s = substr $self->{seq}, $i, 1;\n        my $m = substr $self->{_meta}->{$name}, $i, 1;\n        $self->warn(\"Gap mismatch in column [\". ($i+1). \"] of [$name] meta data in seq [\". $self->id. \"]\")\n            and $success = 0\n                if ($m eq '-') && $s ne $m;\n    }\n    return $success;\n}\n\n=head2 named_meta_text\n\n Title   : named_meta_text()\n Usage   : $meta_values  = $obj->named_meta_text($name, $values_arrayref);\n Function: Variant of named_meta() guarantied to return a textual\n           representation  of the named meta data.\n           For details, see L<meta>.\n Returns : a string\n Args    : scalar, name of the meta data set\n           new value, string or array ref, optional\n\n\nsub named_meta_text {\n    return join ' ', @{shift->named_meta(@_)};\n\n}\n\n=head2 submeta\n\n Title   : submeta\n Usage   : $subset_of_meta_values = $obj->submeta(10, 20, $value_string);\n           $subset_of_meta_values = $obj->submeta(10, undef, $value_string);\n Function:\n\n           Get and set method for meta data for subsequences.\n\n           Numbering starts from 1 and the number is inclusive, ie 1-2\n           are the first two residue of the sequence. Start cannot be\n           larger than end but can be equal.\n\n           If the second argument is missing the returned values\n           should extend to the end of the sequence.\n\n           The return value may be a string or an array reference,\n           depending on the implentation. If in doubt, use\n           submeta_text() which is a variant guarantied to return a\n           string.  See L<submeta_text>.\n\n Returns : A reference to an array or a string\n Args    : integer, start position\n           integer, end position, optional when a third argument present\n           new value, string or array ref, optional\n\n\nsub submeta {\n   shift->named_submeta($DEFAULT_NAME, @_);\n}\n\n=head2 submeta_text\n\n Title   : submeta_text\n Usage   : $meta_values  = $obj->submeta_text(20, $value_string);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, string or array ref, optional\n\n\n\nsub submeta_text {\n    return join ' ', @{shift->named_submeta($DEFAULT_NAME, @_)};\n}\n\n=head2 named_submeta\n\n Title   : named_submeta\n Usage   : $subset_of_meta_values = $obj->named_submeta($name, 10, 20, $value_string);\n           $subset_of_meta_values = $obj->named_submeta($name, 10);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : A reference to an array or a string\n Args    : scalar, name of the meta data set\n           integer, start position\n           integer, end position, optional when a third argument present (can be undef)\n           new value, string or array ref, optional","parameters":[{"label":"$self"},{"label":"$name"},{"label":"$start"},{"label":"$end"},{"label":"$value"}]}},{"name":"_meta","kind":12,"line":402},{"name":"%value","containerName":null,"kind":13,"line":403},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"$arrayref","line":404},{"line":406,"kind":13,"containerName":null,"name":"%value"},{"kind":13,"containerName":null,"name":"$arrayref","line":407},{"name":"$value","kind":13,"containerName":null,"line":407},{"line":409,"name":"%value","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"@arrayref","line":410},{"kind":13,"containerName":null,"name":"%value","line":410},{"name":"$self","kind":13,"containerName":null,"line":412},{"line":412,"name":"throw","containerName":"main::","kind":12},{"name":"$value","kind":13,"containerName":null,"line":412},{"line":415,"kind":13,"containerName":null,"name":"$self"},{"line":415,"containerName":"main::","kind":12,"name":"warn"},{"kind":13,"containerName":null,"name":"$self","line":416},{"line":416,"name":"seq","kind":12,"containerName":"main::"},{"name":"$self","kind":13,"containerName":null,"line":416},{"line":416,"kind":12,"containerName":"main::","name":"id"},{"name":"$start","kind":13,"containerName":null,"line":417},{"line":417,"kind":13,"containerName":null,"name":"$arrayref"},{"line":417,"name":"$self","containerName":null,"kind":13},{"containerName":"main::","kind":12,"name":"length","line":417},{"line":420,"name":"$end","kind":13,"containerName":null},{"line":420,"kind":13,"containerName":null,"name":"$end"},{"name":"$arrayref","kind":13,"containerName":null,"line":420},{"line":420,"name":"$start","kind":13,"containerName":null},{"line":421,"kind":13,"containerName":null,"name":"$end"},{"line":424,"name":"$diff","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"line":424,"name":"$end","kind":13,"containerName":null},{"line":424,"name":"$start","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$arrayref","line":424},{"containerName":null,"kind":13,"name":"%diff","line":425},{"containerName":null,"kind":13,"name":"%diff","line":426},{"name":"$arrayref","kind":13,"containerName":null,"line":426},{"line":426,"name":"$META_GAP","containerName":null,"kind":13},{"line":429,"containerName":null,"kind":13,"name":"%self"},{"line":429,"kind":12,"name":"_meta"},{"containerName":null,"kind":13,"name":"@name","line":429},{"kind":13,"containerName":null,"name":"$start","line":429},{"line":429,"name":"$end","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$arrayref","line":429},{"line":431,"name":"$self","containerName":null,"kind":13},{"line":431,"name":"_do_flush","kind":12,"containerName":"main::"},{"line":431,"name":"$self","kind":13,"containerName":null},{"line":431,"name":"force_flush","containerName":"main::","kind":12},{"line":433,"kind":13,"containerName":null,"name":"%arrayref"},{"line":437,"kind":13,"containerName":null,"name":"$end"},{"name":"$meta_len","containerName":null,"kind":13,"line":437},{"line":438,"containerName":null,"kind":13,"name":"$end"},{"line":438,"name":"%meta_len","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$self","line":439},{"line":439,"name":"warn","kind":12,"containerName":"main::"},{"line":440,"kind":13,"containerName":null,"name":"$end"},{"name":"$meta_len","containerName":null,"kind":13,"line":440},{"line":443,"name":"$self","containerName":null,"kind":13},{"line":443,"name":"warn","containerName":"main::","kind":12},{"line":444,"containerName":null,"kind":13,"name":"$end"},{"name":"$self","kind":13,"containerName":null,"line":444},{"containerName":"main::","kind":12,"name":"length","line":444},{"line":445,"name":"@end","containerName":null,"kind":13},{"line":446,"name":"%self","kind":13,"containerName":null},{"line":446,"name":"_meta","kind":12},{"line":446,"name":"@name","kind":13,"containerName":null},{"line":446,"containerName":null,"kind":13,"name":"$start"},{"line":446,"name":"$end","kind":13,"containerName":null},{"line":465,"range":{"start":{"character":0,"line":465},"end":{"line":466,"character":9999}},"kind":12,"children":[{"name":"named_submeta","kind":12,"containerName":"named_submeta_text","line":466}],"containerName":"main::","name":"named_submeta_text","definition":"sub"},{"kind":12,"name":"shift","line":466},{"line":481,"range":{"end":{"character":9999,"line":485},"start":{"line":481,"character":0}},"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Array.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::Meta::Array\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::Meta::Array - array-based generic implementation of a\nsequence class with residue-based meta information\n\n=head1 SYNOPSIS\n\n  use Bio::LocatableSeq;\n  use Bio::Seq::Meta::Array;\n\n  my $seq = Bio::Seq::Meta::Array->new(-id=>'test',\n                                   -seq=>'ACTGCTAGCT',\n                                   -start=>2434,\n                                   -start=>2443,\n                                   -strand=>1,\n                                   -varbose=>1, # to see warnings\n                                  );\n\n  # to test this is a meta seq object\n  $seq->isa(\"Bio::Seq::Meta::Array\")\n      || $seq->throw(\"$seq is not a Bio::Seq::Meta::Array\");\n\n  $seq->meta('1 2 3 4 5 6 7 8 9 10');\n\n  # or you could create the Meta object directly\n  $seq = Bio::Seq::Meta::Array->new(-id=>'test',\n                                    -seq=>'ACTGCTAGCT',\n                                    -start=>2434,\n                                    -start=>2443,\n                                    -strand=>1,\n                                    -meta=>'1 2 3 4 5 6 7 8 9 10',\n                                    -varbose=>1, # to see warnings\n                                   );\n\n\n  # accessors\n  $arrayref   = $seq->meta();\n  $string     = $seq->meta_text();\n  $substring  = $seq->submeta_text(2,5);\n  $unique_key = $seq->accession_number();\n\n=head1 DESCRIPTION\n\nThis class implements generic methods for sequences with residue-based\nmeta information. Meta sequences with meta data are Bio::LocatableSeq\nobjects with additional methods to store that meta information. See\nL<Bio::LocatableSeq> and L<Bio::Seq::MetaI>.\n\nThe meta information in this class can be a string of variable length\nand can be a complex structure.  Blank values are undef or zero.\n\nApplication specific implementations should inherit from this class to\noverride and add to these methods.\n\nThis class can be used for storing sequence quality values but\nBio::Seq::Quality has named methods that make it easier.\n\n=head1 SEE ALSO\n\nL<Bio::LocatableSeq>,\nL<Bio::Seq::MetaI>,\nL<Bio::Seq::Meta>,\nL<Bio::Seq::Quality>\n\n=head1 NOTE\n\nThis Bio::Seq::MetaI implementation inherits from Bio::LocatableSeq, which\nitself inherits from Bio::PrimarySeq. It is not a Bio::SeqI, so bless-ing\nobjects of this class into a Bio::SeqI or vice versa and will not work as\nexpected (see bug 2262). This may be addressed in a future refactor of\nBio::LocatableSeq.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nChad Matsalla, bioinformatics@dieselwurks.com\nAaron Mackey, amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::Meta::Array;\nuse vars qw(@ISA $DEFAULT_NAME $GAP $META_GAP);\nuse strict;\n\n#use overload '\"\"' => \\&to_string;\n\nuse base qw(Bio::LocatableSeq Bio::Seq Bio::Seq::MetaI);\n\nBEGIN {\n\n    $DEFAULT_NAME = 'DEFAULT';\n    $GAP = '-';\n    $META_GAP = 0;\n}\n\n=head2 new\n\n Title   : new\n Usage   : $metaseq = Bio::Seq::Meta::Array->new\n\t        ( -meta => 'aaaaaaaabbbbbbbb',\n                  -seq =>  'TKLMILVSHIVILSRM'\n\t          -id  => 'human_id',\n\t          -accession_number => 'S000012',\n\t        );\n Function: Constructor for Bio::Seq::Meta::Array class, meta data being in a\n           string. Note that you can provide an empty quality string.\n Returns : a new Bio::Seq::Meta::Array object\n\n\nsub new {\n    my ($class, %args) = @_;\n\t#defined inheritance according to stated baseclass,\n\t#if undefined then will be PrimarySeq\n\tif (defined($args{'-baseclass'})) {\n\t\t@ISA = ($args{'-baseclass'},\"Bio::Seq::MetaI\");\n\t\t}\n\telse {\n\t\t@ISA = qw( Bio::LocatableSeq Bio::Seq Bio::Seq::MetaI );\n\t\t}\n\n    my $self = $class->SUPER::new(%args);\n\n    my($meta, $forceflush) =\n        $self->_rearrange([qw(META\n                              FORCE_FLUSH\n                              )],\n                          %args);\n\n    $self->{'_meta'}->{$DEFAULT_NAME} = [];\n\n    $meta && $self->meta($meta);\n    $forceflush && $self->force_flush($forceflush);\n\n    return $self;\n}\n\n\n=head2 meta\n\n Title   : meta\n Usage   : $meta_values  = $obj->meta($values_string);\n Function:\n\n           Get and set method for the meta data starting from residue\n           position one. Since it is dependent on the length of the\n           sequence, it needs to be manipulated after the sequence.\n\n           The length of the returned value always matches the length\n           of the sequence.\n\n Returns : reference to an array of meta data\n Args    : new value, string or array ref, optional\n\n\nsub meta {\n   shift->named_meta($DEFAULT_NAME, shift);\n}\n\n=head2 meta_text\n\n Title   : meta_text\n Usage   : $meta_values  = $obj->meta_text($values_arrayref);\n Function: Variant of meta() guarantied to return a string\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, string or array ref, optional\n\n\nsub meta_text {\n    return join ' ',  map {0 unless $_} @{shift->meta(shift)};\n}\n\n=head2 named_meta\n\n Title   : named_meta()\n Usage   : $meta_values  = $obj->named_meta($name, $values_arrayref);\n Function: A more general version of meta(). Each meta data set needs\n           to be named. See also L<meta_names>.\n Returns : reference to an array of meta data\n Args    : scalar, name of the meta data set\n           new value, string or array ref, optional\n\n\nsub named_meta {\n   my ($self, $name, $value) = @_;\n\n   $name ||= $DEFAULT_NAME;\n\n   if (defined $value) {\n       my ($arrayref);\n\n       if (ref $value eq 'ARRAY' ) { # array ref\n           $arrayref = $value;\n       }\n       elsif (not ref($value)) { # scalar\n           $arrayref = [split /\\s+/, $value];\n       } else {\n           $self->throw(\"I need a scalar or array ref, not [\". ref($value). \"]\");\n       }\n\n       # test for length\n       my $diff = $self->length - @{$arrayref};\n       if ($diff > 0) {\n           foreach (1..$diff) { push @{$arrayref}, 0;}\n       }\n\n       $self->{'_meta'}->{$name} = $arrayref;\n\n       #$self->_test_gap_positions($name) if $self->verbose > 0;\n   }\n\n   $self->_do_flush if $self->force_flush;\n\n   return $self->{'_meta'}->{$name} || (\" \" x $self->length);\n\n}\n\n=head2 _test_gap_positions\n\n Title   : _test_gap_positions\n Usage   : $meta_values  = $obj->_test_gap_positions($name);\n Function: Internal test for correct position of gap characters.\n           Gap being only '-' this time.\n\n           This method is called from named_meta() when setting meta\n           data but only if verbose is positive as this can be an\n           expensive process on very long sequences. Set verbose(1) to\n           see warnings when gaps do not align in sequence and meta\n           data and turn them into errors by setting verbose(2).\n\n Returns : true on success, prints warnings\n Args    : none\n\n\nsub _test_gap_positions {\n    my $self = shift;\n    my $name = shift;\n    my $success = 1;\n\n    $self->seq || return $success;\n    my $len = CORE::length($self->seq);\n    for (my $i=0; $i < $len; $i++) {\n        my $s = substr $self->{seq}, $i, 1;\n        my $m = substr $self->{_meta}->{$name}, $i, 1;\n        $self->warn(\"Gap mismatch in column [\". ($i+1). \"] of [$name] meta data in seq [\". $self->id. \"]\")\n            and $success = 0\n                if ($m eq '-') && $s ne $m;\n    }\n    return $success;\n}\n\n=head2 named_meta_text\n\n Title   : named_meta_text()\n Usage   : $meta_values  = $obj->named_meta_text($name, $values_arrayref);\n Function: Variant of named_meta() guarantied to return a textual\n           representation  of the named meta data.\n           For details, see L<meta>.\n Returns : a string\n Args    : scalar, name of the meta data set\n           new value, string or array ref, optional\n\n\nsub named_meta_text {\n    return join ' ', @{shift->named_meta(@_)};\n\n}\n\n=head2 submeta\n\n Title   : submeta\n Usage   : $subset_of_meta_values = $obj->submeta(10, 20, $value_string);\n           $subset_of_meta_values = $obj->submeta(10, undef, $value_string);\n Function:\n\n           Get and set method for meta data for subsequences.\n\n           Numbering starts from 1 and the number is inclusive, ie 1-2\n           are the first two residue of the sequence. Start cannot be\n           larger than end but can be equal.\n\n           If the second argument is missing the returned values\n           should extend to the end of the sequence.\n\n           The return value may be a string or an array reference,\n           depending on the implentation. If in doubt, use\n           submeta_text() which is a variant guarantied to return a\n           string.  See L<submeta_text>.\n\n Returns : A reference to an array or a string\n Args    : integer, start position\n           integer, end position, optional when a third argument present\n           new value, string or array ref, optional\n\n\nsub submeta {\n   shift->named_submeta($DEFAULT_NAME, @_);\n}\n\n=head2 submeta_text\n\n Title   : submeta_text\n Usage   : $meta_values  = $obj->submeta_text(20, $value_string);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, string or array ref, optional\n\n\n\nsub submeta_text {\n    return join ' ', @{shift->named_submeta($DEFAULT_NAME, @_)};\n}\n\n=head2 named_submeta\n\n Title   : named_submeta\n Usage   : $subset_of_meta_values = $obj->named_submeta($name, 10, 20, $value_string);\n           $subset_of_meta_values = $obj->named_submeta($name, 10);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : A reference to an array or a string\n Args    : scalar, name of the meta data set\n           integer, start position\n           integer, end position, optional when a third argument present (can be undef)\n           new value, string or array ref, optional\n\n\n\nsub named_submeta {\n    my ($self, $name, $start, $end, $value) = @_;\n\n    $name ||= $DEFAULT_NAME;\n    $start ||=1;\n    $start =~ /^[+]?\\d+$/ and $start > 0 or\n        $self->throw(\"Need at least a positive integer start value\");\n    $start--;\n    my $meta_len = scalar(@{$self->{_meta}->{$name}});\n    if (defined $value) {\n        my $arrayref;\n\n        if (ref $value eq 'ARRAY' ) { # array ref\n            $arrayref = $value;\n        }\n        elsif (not ref($value)) { # scalar\n            $arrayref = [split /\\s+/, $value];\n        } else {\n            $self->throw(\"I need a space separated scalar or array ref, not [\". ref($value). \"]\");\n        }\n\n        $self->warn(\"You are setting meta values beyond the length of the sequence\\n\".\n                    \"[$start > \". length($self->seq).\"] in sequence \". $self->id)\n            if $start + scalar @{$arrayref} -1 > $self->length;\n\n\n        $end or $end = @{$arrayref} + $start;\n        $end--;\n\n        # test for length; pad if needed\n        my $diff = $end - $start - scalar @{$arrayref};\n        if ($diff > 0) {\n            foreach (1..$diff) { push @{$arrayref}, $META_GAP}\n        }\n\n        @{$self->{_meta}->{$name}}[$start..$end] = @{$arrayref};\n\n        $self->_do_flush if $self->force_flush;\n\n        return $arrayref;\n\n    } else {\n        # don't set by seq length; use meta array length instead; bug 2478\n        $end ||= $meta_len;\n        if ($end > $meta_len) {\n            $self->warn(\"End is longer than meta sequence $name length; resetting to $meta_len\");\n            $end = $meta_len;\n        }\n        # warn but don't reset (push use of trunc() instead)\n        $self->warn(\"End is longer than sequence length; use trunc() \\n\".\n                    \"if you want a fully truncated object\") if $end > $self->length;\n        $end--;\n        return [@{$self->{_meta}->{$name}}[$start..$end]];\n    }\n}\n\n\n=head2 named_submeta_text\n\n Title   : named_submeta_text\n Usage   : $meta_values  = $obj->named_submeta_text($name, 20, $value_string);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : scalar, name of the meta data\n Args    : integer, start position, optional\n           integer, end position, optional\n           new value, string or array ref, optional\n\n\nsub named_submeta_text {\n    return join ' ', @{shift->named_submeta(@_)};\n}\n\n=head2 meta_names\n\n Title   : meta_names\n Usage   : @meta_names  = $obj->meta_names()\n Function: Retrives an array of meta data set names. The default\n           (unnamed) set name is guarantied to be the first name if it\n           contains any data.\n Returns : an array of names\n Args    : none","label":"meta_names($self)"},"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"meta_names","line":482,"definition":"my"},{"definition":"my","line":484,"name":"@r","kind":13,"localvar":"my","containerName":"meta_names"},{"name":"$self","kind":13,"containerName":"meta_names","line":485}],"name":"meta_names","containerName":"main::","definition":"sub","detail":"($self)"},{"line":486,"name":"@r","kind":13,"containerName":null},{"name":"$DEFAULT_NAME","kind":13,"containerName":null,"line":486},{"line":488,"name":"@r","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$DEFAULT_NAME","line":488},{"name":"%self","containerName":null,"kind":13,"line":488},{"name":"$DEFAULT_NAME","kind":13,"containerName":null,"line":488},{"kind":13,"containerName":null,"name":"@r","line":489},{"signature":{"label":"meta_length($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Array.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::Meta::Array\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::Meta::Array - array-based generic implementation of a\nsequence class with residue-based meta information\n\n=head1 SYNOPSIS\n\n  use Bio::LocatableSeq;\n  use Bio::Seq::Meta::Array;\n\n  my $seq = Bio::Seq::Meta::Array->new(-id=>'test',\n                                   -seq=>'ACTGCTAGCT',\n                                   -start=>2434,\n                                   -start=>2443,\n                                   -strand=>1,\n                                   -varbose=>1, # to see warnings\n                                  );\n\n  # to test this is a meta seq object\n  $seq->isa(\"Bio::Seq::Meta::Array\")\n      || $seq->throw(\"$seq is not a Bio::Seq::Meta::Array\");\n\n  $seq->meta('1 2 3 4 5 6 7 8 9 10');\n\n  # or you could create the Meta object directly\n  $seq = Bio::Seq::Meta::Array->new(-id=>'test',\n                                    -seq=>'ACTGCTAGCT',\n                                    -start=>2434,\n                                    -start=>2443,\n                                    -strand=>1,\n                                    -meta=>'1 2 3 4 5 6 7 8 9 10',\n                                    -varbose=>1, # to see warnings\n                                   );\n\n\n  # accessors\n  $arrayref   = $seq->meta();\n  $string     = $seq->meta_text();\n  $substring  = $seq->submeta_text(2,5);\n  $unique_key = $seq->accession_number();\n\n=head1 DESCRIPTION\n\nThis class implements generic methods for sequences with residue-based\nmeta information. Meta sequences with meta data are Bio::LocatableSeq\nobjects with additional methods to store that meta information. See\nL<Bio::LocatableSeq> and L<Bio::Seq::MetaI>.\n\nThe meta information in this class can be a string of variable length\nand can be a complex structure.  Blank values are undef or zero.\n\nApplication specific implementations should inherit from this class to\noverride and add to these methods.\n\nThis class can be used for storing sequence quality values but\nBio::Seq::Quality has named methods that make it easier.\n\n=head1 SEE ALSO\n\nL<Bio::LocatableSeq>,\nL<Bio::Seq::MetaI>,\nL<Bio::Seq::Meta>,\nL<Bio::Seq::Quality>\n\n=head1 NOTE\n\nThis Bio::Seq::MetaI implementation inherits from Bio::LocatableSeq, which\nitself inherits from Bio::PrimarySeq. It is not a Bio::SeqI, so bless-ing\nobjects of this class into a Bio::SeqI or vice versa and will not work as\nexpected (see bug 2262). This may be addressed in a future refactor of\nBio::LocatableSeq.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nChad Matsalla, bioinformatics@dieselwurks.com\nAaron Mackey, amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::Meta::Array;\nuse vars qw(@ISA $DEFAULT_NAME $GAP $META_GAP);\nuse strict;\n\n#use overload '\"\"' => \\&to_string;\n\nuse base qw(Bio::LocatableSeq Bio::Seq Bio::Seq::MetaI);\n\nBEGIN {\n\n    $DEFAULT_NAME = 'DEFAULT';\n    $GAP = '-';\n    $META_GAP = 0;\n}\n\n=head2 new\n\n Title   : new\n Usage   : $metaseq = Bio::Seq::Meta::Array->new\n\t        ( -meta => 'aaaaaaaabbbbbbbb',\n                  -seq =>  'TKLMILVSHIVILSRM'\n\t          -id  => 'human_id',\n\t          -accession_number => 'S000012',\n\t        );\n Function: Constructor for Bio::Seq::Meta::Array class, meta data being in a\n           string. Note that you can provide an empty quality string.\n Returns : a new Bio::Seq::Meta::Array object\n\n\nsub new {\n    my ($class, %args) = @_;\n\t#defined inheritance according to stated baseclass,\n\t#if undefined then will be PrimarySeq\n\tif (defined($args{'-baseclass'})) {\n\t\t@ISA = ($args{'-baseclass'},\"Bio::Seq::MetaI\");\n\t\t}\n\telse {\n\t\t@ISA = qw( Bio::LocatableSeq Bio::Seq Bio::Seq::MetaI );\n\t\t}\n\n    my $self = $class->SUPER::new(%args);\n\n    my($meta, $forceflush) =\n        $self->_rearrange([qw(META\n                              FORCE_FLUSH\n                              )],\n                          %args);\n\n    $self->{'_meta'}->{$DEFAULT_NAME} = [];\n\n    $meta && $self->meta($meta);\n    $forceflush && $self->force_flush($forceflush);\n\n    return $self;\n}\n\n\n=head2 meta\n\n Title   : meta\n Usage   : $meta_values  = $obj->meta($values_string);\n Function:\n\n           Get and set method for the meta data starting from residue\n           position one. Since it is dependent on the length of the\n           sequence, it needs to be manipulated after the sequence.\n\n           The length of the returned value always matches the length\n           of the sequence.\n\n Returns : reference to an array of meta data\n Args    : new value, string or array ref, optional\n\n\nsub meta {\n   shift->named_meta($DEFAULT_NAME, shift);\n}\n\n=head2 meta_text\n\n Title   : meta_text\n Usage   : $meta_values  = $obj->meta_text($values_arrayref);\n Function: Variant of meta() guarantied to return a string\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, string or array ref, optional\n\n\nsub meta_text {\n    return join ' ',  map {0 unless $_} @{shift->meta(shift)};\n}\n\n=head2 named_meta\n\n Title   : named_meta()\n Usage   : $meta_values  = $obj->named_meta($name, $values_arrayref);\n Function: A more general version of meta(). Each meta data set needs\n           to be named. See also L<meta_names>.\n Returns : reference to an array of meta data\n Args    : scalar, name of the meta data set\n           new value, string or array ref, optional\n\n\nsub named_meta {\n   my ($self, $name, $value) = @_;\n\n   $name ||= $DEFAULT_NAME;\n\n   if (defined $value) {\n       my ($arrayref);\n\n       if (ref $value eq 'ARRAY' ) { # array ref\n           $arrayref = $value;\n       }\n       elsif (not ref($value)) { # scalar\n           $arrayref = [split /\\s+/, $value];\n       } else {\n           $self->throw(\"I need a scalar or array ref, not [\". ref($value). \"]\");\n       }\n\n       # test for length\n       my $diff = $self->length - @{$arrayref};\n       if ($diff > 0) {\n           foreach (1..$diff) { push @{$arrayref}, 0;}\n       }\n\n       $self->{'_meta'}->{$name} = $arrayref;\n\n       #$self->_test_gap_positions($name) if $self->verbose > 0;\n   }\n\n   $self->_do_flush if $self->force_flush;\n\n   return $self->{'_meta'}->{$name} || (\" \" x $self->length);\n\n}\n\n=head2 _test_gap_positions\n\n Title   : _test_gap_positions\n Usage   : $meta_values  = $obj->_test_gap_positions($name);\n Function: Internal test for correct position of gap characters.\n           Gap being only '-' this time.\n\n           This method is called from named_meta() when setting meta\n           data but only if verbose is positive as this can be an\n           expensive process on very long sequences. Set verbose(1) to\n           see warnings when gaps do not align in sequence and meta\n           data and turn them into errors by setting verbose(2).\n\n Returns : true on success, prints warnings\n Args    : none\n\n\nsub _test_gap_positions {\n    my $self = shift;\n    my $name = shift;\n    my $success = 1;\n\n    $self->seq || return $success;\n    my $len = CORE::length($self->seq);\n    for (my $i=0; $i < $len; $i++) {\n        my $s = substr $self->{seq}, $i, 1;\n        my $m = substr $self->{_meta}->{$name}, $i, 1;\n        $self->warn(\"Gap mismatch in column [\". ($i+1). \"] of [$name] meta data in seq [\". $self->id. \"]\")\n            and $success = 0\n                if ($m eq '-') && $s ne $m;\n    }\n    return $success;\n}\n\n=head2 named_meta_text\n\n Title   : named_meta_text()\n Usage   : $meta_values  = $obj->named_meta_text($name, $values_arrayref);\n Function: Variant of named_meta() guarantied to return a textual\n           representation  of the named meta data.\n           For details, see L<meta>.\n Returns : a string\n Args    : scalar, name of the meta data set\n           new value, string or array ref, optional\n\n\nsub named_meta_text {\n    return join ' ', @{shift->named_meta(@_)};\n\n}\n\n=head2 submeta\n\n Title   : submeta\n Usage   : $subset_of_meta_values = $obj->submeta(10, 20, $value_string);\n           $subset_of_meta_values = $obj->submeta(10, undef, $value_string);\n Function:\n\n           Get and set method for meta data for subsequences.\n\n           Numbering starts from 1 and the number is inclusive, ie 1-2\n           are the first two residue of the sequence. Start cannot be\n           larger than end but can be equal.\n\n           If the second argument is missing the returned values\n           should extend to the end of the sequence.\n\n           The return value may be a string or an array reference,\n           depending on the implentation. If in doubt, use\n           submeta_text() which is a variant guarantied to return a\n           string.  See L<submeta_text>.\n\n Returns : A reference to an array or a string\n Args    : integer, start position\n           integer, end position, optional when a third argument present\n           new value, string or array ref, optional\n\n\nsub submeta {\n   shift->named_submeta($DEFAULT_NAME, @_);\n}\n\n=head2 submeta_text\n\n Title   : submeta_text\n Usage   : $meta_values  = $obj->submeta_text(20, $value_string);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, string or array ref, optional\n\n\n\nsub submeta_text {\n    return join ' ', @{shift->named_submeta($DEFAULT_NAME, @_)};\n}\n\n=head2 named_submeta\n\n Title   : named_submeta\n Usage   : $subset_of_meta_values = $obj->named_submeta($name, 10, 20, $value_string);\n           $subset_of_meta_values = $obj->named_submeta($name, 10);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : A reference to an array or a string\n Args    : scalar, name of the meta data set\n           integer, start position\n           integer, end position, optional when a third argument present (can be undef)\n           new value, string or array ref, optional\n\n\n\nsub named_submeta {\n    my ($self, $name, $start, $end, $value) = @_;\n\n    $name ||= $DEFAULT_NAME;\n    $start ||=1;\n    $start =~ /^[+]?\\d+$/ and $start > 0 or\n        $self->throw(\"Need at least a positive integer start value\");\n    $start--;\n    my $meta_len = scalar(@{$self->{_meta}->{$name}});\n    if (defined $value) {\n        my $arrayref;\n\n        if (ref $value eq 'ARRAY' ) { # array ref\n            $arrayref = $value;\n        }\n        elsif (not ref($value)) { # scalar\n            $arrayref = [split /\\s+/, $value];\n        } else {\n            $self->throw(\"I need a space separated scalar or array ref, not [\". ref($value). \"]\");\n        }\n\n        $self->warn(\"You are setting meta values beyond the length of the sequence\\n\".\n                    \"[$start > \". length($self->seq).\"] in sequence \". $self->id)\n            if $start + scalar @{$arrayref} -1 > $self->length;\n\n\n        $end or $end = @{$arrayref} + $start;\n        $end--;\n\n        # test for length; pad if needed\n        my $diff = $end - $start - scalar @{$arrayref};\n        if ($diff > 0) {\n            foreach (1..$diff) { push @{$arrayref}, $META_GAP}\n        }\n\n        @{$self->{_meta}->{$name}}[$start..$end] = @{$arrayref};\n\n        $self->_do_flush if $self->force_flush;\n\n        return $arrayref;\n\n    } else {\n        # don't set by seq length; use meta array length instead; bug 2478\n        $end ||= $meta_len;\n        if ($end > $meta_len) {\n            $self->warn(\"End is longer than meta sequence $name length; resetting to $meta_len\");\n            $end = $meta_len;\n        }\n        # warn but don't reset (push use of trunc() instead)\n        $self->warn(\"End is longer than sequence length; use trunc() \\n\".\n                    \"if you want a fully truncated object\") if $end > $self->length;\n        $end--;\n        return [@{$self->{_meta}->{$name}}[$start..$end]];\n    }\n}\n\n\n=head2 named_submeta_text\n\n Title   : named_submeta_text\n Usage   : $meta_values  = $obj->named_submeta_text($name, 20, $value_string);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : scalar, name of the meta data\n Args    : integer, start position, optional\n           integer, end position, optional\n           new value, string or array ref, optional\n\n\nsub named_submeta_text {\n    return join ' ', @{shift->named_submeta(@_)};\n}\n\n=head2 meta_names\n\n Title   : meta_names\n Usage   : @meta_names  = $obj->meta_names()\n Function: Retrives an array of meta data set names. The default\n           (unnamed) set name is guarantied to be the first name if it\n           contains any data.\n Returns : an array of names\n Args    : none\n\n\nsub meta_names {\n    my ($self) = @_;\n\n    my @r;\n    foreach  ( sort keys %{$self->{'_meta'}} ) {\n        push (@r, $_) unless $_ eq $DEFAULT_NAME;\n    }\n    unshift @r, $DEFAULT_NAME if $self->{'_meta'}->{$DEFAULT_NAME};\n    return @r;\n}\n\n\n=head2 meta_length\n\n Title   : meta_length()\n Usage   : $meta_len  = $obj->meta_length();\n Function: return the number of elements in the meta set\n Returns : integer\n Args    : -"},"line":503,"kind":12,"range":{"start":{"line":503,"character":0},"end":{"character":9999,"line":506}},"definition":"sub","detail":"($self)","children":[{"line":504,"name":"$self","kind":13,"localvar":"my","containerName":"meta_length","definition":"my"},{"containerName":"meta_length","kind":13,"name":"$self","line":505},{"containerName":"meta_length","kind":12,"name":"named_meta_length","line":505},{"line":505,"name":"$DEFAULT_NAME","kind":13,"containerName":"meta_length"}],"name":"meta_length","containerName":"main::"},{"name":"named_meta_length","containerName":"main::","children":[{"definition":"my","containerName":"named_meta_length","localvar":"my","kind":13,"name":"$self","line":520},{"line":520,"name":"$name","containerName":"named_meta_length","kind":13},{"line":521,"name":"$name","kind":13,"containerName":"named_meta_length"},{"line":521,"kind":13,"containerName":"named_meta_length","name":"$DEFAULT_NAME"},{"line":522,"kind":13,"containerName":"named_meta_length","name":"$self"},{"line":522,"kind":13,"containerName":"named_meta_length","name":"$name"}],"detail":"($self,$name)","definition":"sub","range":{"end":{"character":9999,"line":522},"start":{"line":519,"character":0}},"kind":12,"line":519,"signature":{"label":"named_meta_length($self,$name)","parameters":[{"label":"$self"},{"label":"$name"}],"documentation":"1;\n# $Id: Array.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::Meta::Array\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::Meta::Array - array-based generic implementation of a\nsequence class with residue-based meta information\n\n=head1 SYNOPSIS\n\n  use Bio::LocatableSeq;\n  use Bio::Seq::Meta::Array;\n\n  my $seq = Bio::Seq::Meta::Array->new(-id=>'test',\n                                   -seq=>'ACTGCTAGCT',\n                                   -start=>2434,\n                                   -start=>2443,\n                                   -strand=>1,\n                                   -varbose=>1, # to see warnings\n                                  );\n\n  # to test this is a meta seq object\n  $seq->isa(\"Bio::Seq::Meta::Array\")\n      || $seq->throw(\"$seq is not a Bio::Seq::Meta::Array\");\n\n  $seq->meta('1 2 3 4 5 6 7 8 9 10');\n\n  # or you could create the Meta object directly\n  $seq = Bio::Seq::Meta::Array->new(-id=>'test',\n                                    -seq=>'ACTGCTAGCT',\n                                    -start=>2434,\n                                    -start=>2443,\n                                    -strand=>1,\n                                    -meta=>'1 2 3 4 5 6 7 8 9 10',\n                                    -varbose=>1, # to see warnings\n                                   );\n\n\n  # accessors\n  $arrayref   = $seq->meta();\n  $string     = $seq->meta_text();\n  $substring  = $seq->submeta_text(2,5);\n  $unique_key = $seq->accession_number();\n\n=head1 DESCRIPTION\n\nThis class implements generic methods for sequences with residue-based\nmeta information. Meta sequences with meta data are Bio::LocatableSeq\nobjects with additional methods to store that meta information. See\nL<Bio::LocatableSeq> and L<Bio::Seq::MetaI>.\n\nThe meta information in this class can be a string of variable length\nand can be a complex structure.  Blank values are undef or zero.\n\nApplication specific implementations should inherit from this class to\noverride and add to these methods.\n\nThis class can be used for storing sequence quality values but\nBio::Seq::Quality has named methods that make it easier.\n\n=head1 SEE ALSO\n\nL<Bio::LocatableSeq>,\nL<Bio::Seq::MetaI>,\nL<Bio::Seq::Meta>,\nL<Bio::Seq::Quality>\n\n=head1 NOTE\n\nThis Bio::Seq::MetaI implementation inherits from Bio::LocatableSeq, which\nitself inherits from Bio::PrimarySeq. It is not a Bio::SeqI, so bless-ing\nobjects of this class into a Bio::SeqI or vice versa and will not work as\nexpected (see bug 2262). This may be addressed in a future refactor of\nBio::LocatableSeq.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nChad Matsalla, bioinformatics@dieselwurks.com\nAaron Mackey, amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::Meta::Array;\nuse vars qw(@ISA $DEFAULT_NAME $GAP $META_GAP);\nuse strict;\n\n#use overload '\"\"' => \\&to_string;\n\nuse base qw(Bio::LocatableSeq Bio::Seq Bio::Seq::MetaI);\n\nBEGIN {\n\n    $DEFAULT_NAME = 'DEFAULT';\n    $GAP = '-';\n    $META_GAP = 0;\n}\n\n=head2 new\n\n Title   : new\n Usage   : $metaseq = Bio::Seq::Meta::Array->new\n\t        ( -meta => 'aaaaaaaabbbbbbbb',\n                  -seq =>  'TKLMILVSHIVILSRM'\n\t          -id  => 'human_id',\n\t          -accession_number => 'S000012',\n\t        );\n Function: Constructor for Bio::Seq::Meta::Array class, meta data being in a\n           string. Note that you can provide an empty quality string.\n Returns : a new Bio::Seq::Meta::Array object\n\n\nsub new {\n    my ($class, %args) = @_;\n\t#defined inheritance according to stated baseclass,\n\t#if undefined then will be PrimarySeq\n\tif (defined($args{'-baseclass'})) {\n\t\t@ISA = ($args{'-baseclass'},\"Bio::Seq::MetaI\");\n\t\t}\n\telse {\n\t\t@ISA = qw( Bio::LocatableSeq Bio::Seq Bio::Seq::MetaI );\n\t\t}\n\n    my $self = $class->SUPER::new(%args);\n\n    my($meta, $forceflush) =\n        $self->_rearrange([qw(META\n                              FORCE_FLUSH\n                              )],\n                          %args);\n\n    $self->{'_meta'}->{$DEFAULT_NAME} = [];\n\n    $meta && $self->meta($meta);\n    $forceflush && $self->force_flush($forceflush);\n\n    return $self;\n}\n\n\n=head2 meta\n\n Title   : meta\n Usage   : $meta_values  = $obj->meta($values_string);\n Function:\n\n           Get and set method for the meta data starting from residue\n           position one. Since it is dependent on the length of the\n           sequence, it needs to be manipulated after the sequence.\n\n           The length of the returned value always matches the length\n           of the sequence.\n\n Returns : reference to an array of meta data\n Args    : new value, string or array ref, optional\n\n\nsub meta {\n   shift->named_meta($DEFAULT_NAME, shift);\n}\n\n=head2 meta_text\n\n Title   : meta_text\n Usage   : $meta_values  = $obj->meta_text($values_arrayref);\n Function: Variant of meta() guarantied to return a string\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, string or array ref, optional\n\n\nsub meta_text {\n    return join ' ',  map {0 unless $_} @{shift->meta(shift)};\n}\n\n=head2 named_meta\n\n Title   : named_meta()\n Usage   : $meta_values  = $obj->named_meta($name, $values_arrayref);\n Function: A more general version of meta(). Each meta data set needs\n           to be named. See also L<meta_names>.\n Returns : reference to an array of meta data\n Args    : scalar, name of the meta data set\n           new value, string or array ref, optional\n\n\nsub named_meta {\n   my ($self, $name, $value) = @_;\n\n   $name ||= $DEFAULT_NAME;\n\n   if (defined $value) {\n       my ($arrayref);\n\n       if (ref $value eq 'ARRAY' ) { # array ref\n           $arrayref = $value;\n       }\n       elsif (not ref($value)) { # scalar\n           $arrayref = [split /\\s+/, $value];\n       } else {\n           $self->throw(\"I need a scalar or array ref, not [\". ref($value). \"]\");\n       }\n\n       # test for length\n       my $diff = $self->length - @{$arrayref};\n       if ($diff > 0) {\n           foreach (1..$diff) { push @{$arrayref}, 0;}\n       }\n\n       $self->{'_meta'}->{$name} = $arrayref;\n\n       #$self->_test_gap_positions($name) if $self->verbose > 0;\n   }\n\n   $self->_do_flush if $self->force_flush;\n\n   return $self->{'_meta'}->{$name} || (\" \" x $self->length);\n\n}\n\n=head2 _test_gap_positions\n\n Title   : _test_gap_positions\n Usage   : $meta_values  = $obj->_test_gap_positions($name);\n Function: Internal test for correct position of gap characters.\n           Gap being only '-' this time.\n\n           This method is called from named_meta() when setting meta\n           data but only if verbose is positive as this can be an\n           expensive process on very long sequences. Set verbose(1) to\n           see warnings when gaps do not align in sequence and meta\n           data and turn them into errors by setting verbose(2).\n\n Returns : true on success, prints warnings\n Args    : none\n\n\nsub _test_gap_positions {\n    my $self = shift;\n    my $name = shift;\n    my $success = 1;\n\n    $self->seq || return $success;\n    my $len = CORE::length($self->seq);\n    for (my $i=0; $i < $len; $i++) {\n        my $s = substr $self->{seq}, $i, 1;\n        my $m = substr $self->{_meta}->{$name}, $i, 1;\n        $self->warn(\"Gap mismatch in column [\". ($i+1). \"] of [$name] meta data in seq [\". $self->id. \"]\")\n            and $success = 0\n                if ($m eq '-') && $s ne $m;\n    }\n    return $success;\n}\n\n=head2 named_meta_text\n\n Title   : named_meta_text()\n Usage   : $meta_values  = $obj->named_meta_text($name, $values_arrayref);\n Function: Variant of named_meta() guarantied to return a textual\n           representation  of the named meta data.\n           For details, see L<meta>.\n Returns : a string\n Args    : scalar, name of the meta data set\n           new value, string or array ref, optional\n\n\nsub named_meta_text {\n    return join ' ', @{shift->named_meta(@_)};\n\n}\n\n=head2 submeta\n\n Title   : submeta\n Usage   : $subset_of_meta_values = $obj->submeta(10, 20, $value_string);\n           $subset_of_meta_values = $obj->submeta(10, undef, $value_string);\n Function:\n\n           Get and set method for meta data for subsequences.\n\n           Numbering starts from 1 and the number is inclusive, ie 1-2\n           are the first two residue of the sequence. Start cannot be\n           larger than end but can be equal.\n\n           If the second argument is missing the returned values\n           should extend to the end of the sequence.\n\n           The return value may be a string or an array reference,\n           depending on the implentation. If in doubt, use\n           submeta_text() which is a variant guarantied to return a\n           string.  See L<submeta_text>.\n\n Returns : A reference to an array or a string\n Args    : integer, start position\n           integer, end position, optional when a third argument present\n           new value, string or array ref, optional\n\n\nsub submeta {\n   shift->named_submeta($DEFAULT_NAME, @_);\n}\n\n=head2 submeta_text\n\n Title   : submeta_text\n Usage   : $meta_values  = $obj->submeta_text(20, $value_string);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, string or array ref, optional\n\n\n\nsub submeta_text {\n    return join ' ', @{shift->named_submeta($DEFAULT_NAME, @_)};\n}\n\n=head2 named_submeta\n\n Title   : named_submeta\n Usage   : $subset_of_meta_values = $obj->named_submeta($name, 10, 20, $value_string);\n           $subset_of_meta_values = $obj->named_submeta($name, 10);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : A reference to an array or a string\n Args    : scalar, name of the meta data set\n           integer, start position\n           integer, end position, optional when a third argument present (can be undef)\n           new value, string or array ref, optional\n\n\n\nsub named_submeta {\n    my ($self, $name, $start, $end, $value) = @_;\n\n    $name ||= $DEFAULT_NAME;\n    $start ||=1;\n    $start =~ /^[+]?\\d+$/ and $start > 0 or\n        $self->throw(\"Need at least a positive integer start value\");\n    $start--;\n    my $meta_len = scalar(@{$self->{_meta}->{$name}});\n    if (defined $value) {\n        my $arrayref;\n\n        if (ref $value eq 'ARRAY' ) { # array ref\n            $arrayref = $value;\n        }\n        elsif (not ref($value)) { # scalar\n            $arrayref = [split /\\s+/, $value];\n        } else {\n            $self->throw(\"I need a space separated scalar or array ref, not [\". ref($value). \"]\");\n        }\n\n        $self->warn(\"You are setting meta values beyond the length of the sequence\\n\".\n                    \"[$start > \". length($self->seq).\"] in sequence \". $self->id)\n            if $start + scalar @{$arrayref} -1 > $self->length;\n\n\n        $end or $end = @{$arrayref} + $start;\n        $end--;\n\n        # test for length; pad if needed\n        my $diff = $end - $start - scalar @{$arrayref};\n        if ($diff > 0) {\n            foreach (1..$diff) { push @{$arrayref}, $META_GAP}\n        }\n\n        @{$self->{_meta}->{$name}}[$start..$end] = @{$arrayref};\n\n        $self->_do_flush if $self->force_flush;\n\n        return $arrayref;\n\n    } else {\n        # don't set by seq length; use meta array length instead; bug 2478\n        $end ||= $meta_len;\n        if ($end > $meta_len) {\n            $self->warn(\"End is longer than meta sequence $name length; resetting to $meta_len\");\n            $end = $meta_len;\n        }\n        # warn but don't reset (push use of trunc() instead)\n        $self->warn(\"End is longer than sequence length; use trunc() \\n\".\n                    \"if you want a fully truncated object\") if $end > $self->length;\n        $end--;\n        return [@{$self->{_meta}->{$name}}[$start..$end]];\n    }\n}\n\n\n=head2 named_submeta_text\n\n Title   : named_submeta_text\n Usage   : $meta_values  = $obj->named_submeta_text($name, 20, $value_string);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : scalar, name of the meta data\n Args    : integer, start position, optional\n           integer, end position, optional\n           new value, string or array ref, optional\n\n\nsub named_submeta_text {\n    return join ' ', @{shift->named_submeta(@_)};\n}\n\n=head2 meta_names\n\n Title   : meta_names\n Usage   : @meta_names  = $obj->meta_names()\n Function: Retrives an array of meta data set names. The default\n           (unnamed) set name is guarantied to be the first name if it\n           contains any data.\n Returns : an array of names\n Args    : none\n\n\nsub meta_names {\n    my ($self) = @_;\n\n    my @r;\n    foreach  ( sort keys %{$self->{'_meta'}} ) {\n        push (@r, $_) unless $_ eq $DEFAULT_NAME;\n    }\n    unshift @r, $DEFAULT_NAME if $self->{'_meta'}->{$DEFAULT_NAME};\n    return @r;\n}\n\n\n=head2 meta_length\n\n Title   : meta_length()\n Usage   : $meta_len  = $obj->meta_length();\n Function: return the number of elements in the meta set\n Returns : integer\n Args    : -\n\n\nsub meta_length {\n   my ($self) = @_;\n   return $self->named_meta_length($DEFAULT_NAME);\n}\n\n\n=head2 named_meta_length\n\n Title   : named_meta_length()\n Usage   : $meeta_len  = $obj->named_meta_length($name);\n Function: return the number of elements in the named meta set\n Returns : integer\n Args    : -"}},{"children":[{"definition":"my","line":542,"name":"$self","localvar":"my","kind":13,"containerName":"force_flush"},{"line":542,"containerName":"force_flush","kind":13,"name":"$value"},{"line":544,"name":"$value","containerName":"force_flush","kind":13},{"line":545,"name":"$value","containerName":"force_flush","kind":13},{"kind":13,"containerName":"force_flush","name":"$self","line":546},{"line":547,"containerName":"force_flush","kind":13,"name":"$self"},{"kind":12,"containerName":"force_flush","name":"_do_flush","line":547},{"containerName":"force_flush","kind":13,"name":"$self","line":549},{"kind":13,"containerName":"force_flush","name":"$self","line":552}],"name":"force_flush","containerName":"main::","definition":"sub","detail":"($self,$value)","line":541,"range":{"start":{"character":0,"line":541},"end":{"character":9999,"line":553}},"kind":12,"signature":{"documentation":"1;\n# $Id: Array.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::Meta::Array\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::Meta::Array - array-based generic implementation of a\nsequence class with residue-based meta information\n\n=head1 SYNOPSIS\n\n  use Bio::LocatableSeq;\n  use Bio::Seq::Meta::Array;\n\n  my $seq = Bio::Seq::Meta::Array->new(-id=>'test',\n                                   -seq=>'ACTGCTAGCT',\n                                   -start=>2434,\n                                   -start=>2443,\n                                   -strand=>1,\n                                   -varbose=>1, # to see warnings\n                                  );\n\n  # to test this is a meta seq object\n  $seq->isa(\"Bio::Seq::Meta::Array\")\n      || $seq->throw(\"$seq is not a Bio::Seq::Meta::Array\");\n\n  $seq->meta('1 2 3 4 5 6 7 8 9 10');\n\n  # or you could create the Meta object directly\n  $seq = Bio::Seq::Meta::Array->new(-id=>'test',\n                                    -seq=>'ACTGCTAGCT',\n                                    -start=>2434,\n                                    -start=>2443,\n                                    -strand=>1,\n                                    -meta=>'1 2 3 4 5 6 7 8 9 10',\n                                    -varbose=>1, # to see warnings\n                                   );\n\n\n  # accessors\n  $arrayref   = $seq->meta();\n  $string     = $seq->meta_text();\n  $substring  = $seq->submeta_text(2,5);\n  $unique_key = $seq->accession_number();\n\n=head1 DESCRIPTION\n\nThis class implements generic methods for sequences with residue-based\nmeta information. Meta sequences with meta data are Bio::LocatableSeq\nobjects with additional methods to store that meta information. See\nL<Bio::LocatableSeq> and L<Bio::Seq::MetaI>.\n\nThe meta information in this class can be a string of variable length\nand can be a complex structure.  Blank values are undef or zero.\n\nApplication specific implementations should inherit from this class to\noverride and add to these methods.\n\nThis class can be used for storing sequence quality values but\nBio::Seq::Quality has named methods that make it easier.\n\n=head1 SEE ALSO\n\nL<Bio::LocatableSeq>,\nL<Bio::Seq::MetaI>,\nL<Bio::Seq::Meta>,\nL<Bio::Seq::Quality>\n\n=head1 NOTE\n\nThis Bio::Seq::MetaI implementation inherits from Bio::LocatableSeq, which\nitself inherits from Bio::PrimarySeq. It is not a Bio::SeqI, so bless-ing\nobjects of this class into a Bio::SeqI or vice versa and will not work as\nexpected (see bug 2262). This may be addressed in a future refactor of\nBio::LocatableSeq.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nChad Matsalla, bioinformatics@dieselwurks.com\nAaron Mackey, amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::Meta::Array;\nuse vars qw(@ISA $DEFAULT_NAME $GAP $META_GAP);\nuse strict;\n\n#use overload '\"\"' => \\&to_string;\n\nuse base qw(Bio::LocatableSeq Bio::Seq Bio::Seq::MetaI);\n\nBEGIN {\n\n    $DEFAULT_NAME = 'DEFAULT';\n    $GAP = '-';\n    $META_GAP = 0;\n}\n\n=head2 new\n\n Title   : new\n Usage   : $metaseq = Bio::Seq::Meta::Array->new\n\t        ( -meta => 'aaaaaaaabbbbbbbb',\n                  -seq =>  'TKLMILVSHIVILSRM'\n\t          -id  => 'human_id',\n\t          -accession_number => 'S000012',\n\t        );\n Function: Constructor for Bio::Seq::Meta::Array class, meta data being in a\n           string. Note that you can provide an empty quality string.\n Returns : a new Bio::Seq::Meta::Array object\n\n\nsub new {\n    my ($class, %args) = @_;\n\t#defined inheritance according to stated baseclass,\n\t#if undefined then will be PrimarySeq\n\tif (defined($args{'-baseclass'})) {\n\t\t@ISA = ($args{'-baseclass'},\"Bio::Seq::MetaI\");\n\t\t}\n\telse {\n\t\t@ISA = qw( Bio::LocatableSeq Bio::Seq Bio::Seq::MetaI );\n\t\t}\n\n    my $self = $class->SUPER::new(%args);\n\n    my($meta, $forceflush) =\n        $self->_rearrange([qw(META\n                              FORCE_FLUSH\n                              )],\n                          %args);\n\n    $self->{'_meta'}->{$DEFAULT_NAME} = [];\n\n    $meta && $self->meta($meta);\n    $forceflush && $self->force_flush($forceflush);\n\n    return $self;\n}\n\n\n=head2 meta\n\n Title   : meta\n Usage   : $meta_values  = $obj->meta($values_string);\n Function:\n\n           Get and set method for the meta data starting from residue\n           position one. Since it is dependent on the length of the\n           sequence, it needs to be manipulated after the sequence.\n\n           The length of the returned value always matches the length\n           of the sequence.\n\n Returns : reference to an array of meta data\n Args    : new value, string or array ref, optional\n\n\nsub meta {\n   shift->named_meta($DEFAULT_NAME, shift);\n}\n\n=head2 meta_text\n\n Title   : meta_text\n Usage   : $meta_values  = $obj->meta_text($values_arrayref);\n Function: Variant of meta() guarantied to return a string\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, string or array ref, optional\n\n\nsub meta_text {\n    return join ' ',  map {0 unless $_} @{shift->meta(shift)};\n}\n\n=head2 named_meta\n\n Title   : named_meta()\n Usage   : $meta_values  = $obj->named_meta($name, $values_arrayref);\n Function: A more general version of meta(). Each meta data set needs\n           to be named. See also L<meta_names>.\n Returns : reference to an array of meta data\n Args    : scalar, name of the meta data set\n           new value, string or array ref, optional\n\n\nsub named_meta {\n   my ($self, $name, $value) = @_;\n\n   $name ||= $DEFAULT_NAME;\n\n   if (defined $value) {\n       my ($arrayref);\n\n       if (ref $value eq 'ARRAY' ) { # array ref\n           $arrayref = $value;\n       }\n       elsif (not ref($value)) { # scalar\n           $arrayref = [split /\\s+/, $value];\n       } else {\n           $self->throw(\"I need a scalar or array ref, not [\". ref($value). \"]\");\n       }\n\n       # test for length\n       my $diff = $self->length - @{$arrayref};\n       if ($diff > 0) {\n           foreach (1..$diff) { push @{$arrayref}, 0;}\n       }\n\n       $self->{'_meta'}->{$name} = $arrayref;\n\n       #$self->_test_gap_positions($name) if $self->verbose > 0;\n   }\n\n   $self->_do_flush if $self->force_flush;\n\n   return $self->{'_meta'}->{$name} || (\" \" x $self->length);\n\n}\n\n=head2 _test_gap_positions\n\n Title   : _test_gap_positions\n Usage   : $meta_values  = $obj->_test_gap_positions($name);\n Function: Internal test for correct position of gap characters.\n           Gap being only '-' this time.\n\n           This method is called from named_meta() when setting meta\n           data but only if verbose is positive as this can be an\n           expensive process on very long sequences. Set verbose(1) to\n           see warnings when gaps do not align in sequence and meta\n           data and turn them into errors by setting verbose(2).\n\n Returns : true on success, prints warnings\n Args    : none\n\n\nsub _test_gap_positions {\n    my $self = shift;\n    my $name = shift;\n    my $success = 1;\n\n    $self->seq || return $success;\n    my $len = CORE::length($self->seq);\n    for (my $i=0; $i < $len; $i++) {\n        my $s = substr $self->{seq}, $i, 1;\n        my $m = substr $self->{_meta}->{$name}, $i, 1;\n        $self->warn(\"Gap mismatch in column [\". ($i+1). \"] of [$name] meta data in seq [\". $self->id. \"]\")\n            and $success = 0\n                if ($m eq '-') && $s ne $m;\n    }\n    return $success;\n}\n\n=head2 named_meta_text\n\n Title   : named_meta_text()\n Usage   : $meta_values  = $obj->named_meta_text($name, $values_arrayref);\n Function: Variant of named_meta() guarantied to return a textual\n           representation  of the named meta data.\n           For details, see L<meta>.\n Returns : a string\n Args    : scalar, name of the meta data set\n           new value, string or array ref, optional\n\n\nsub named_meta_text {\n    return join ' ', @{shift->named_meta(@_)};\n\n}\n\n=head2 submeta\n\n Title   : submeta\n Usage   : $subset_of_meta_values = $obj->submeta(10, 20, $value_string);\n           $subset_of_meta_values = $obj->submeta(10, undef, $value_string);\n Function:\n\n           Get and set method for meta data for subsequences.\n\n           Numbering starts from 1 and the number is inclusive, ie 1-2\n           are the first two residue of the sequence. Start cannot be\n           larger than end but can be equal.\n\n           If the second argument is missing the returned values\n           should extend to the end of the sequence.\n\n           The return value may be a string or an array reference,\n           depending on the implentation. If in doubt, use\n           submeta_text() which is a variant guarantied to return a\n           string.  See L<submeta_text>.\n\n Returns : A reference to an array or a string\n Args    : integer, start position\n           integer, end position, optional when a third argument present\n           new value, string or array ref, optional\n\n\nsub submeta {\n   shift->named_submeta($DEFAULT_NAME, @_);\n}\n\n=head2 submeta_text\n\n Title   : submeta_text\n Usage   : $meta_values  = $obj->submeta_text(20, $value_string);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, string or array ref, optional\n\n\n\nsub submeta_text {\n    return join ' ', @{shift->named_submeta($DEFAULT_NAME, @_)};\n}\n\n=head2 named_submeta\n\n Title   : named_submeta\n Usage   : $subset_of_meta_values = $obj->named_submeta($name, 10, 20, $value_string);\n           $subset_of_meta_values = $obj->named_submeta($name, 10);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : A reference to an array or a string\n Args    : scalar, name of the meta data set\n           integer, start position\n           integer, end position, optional when a third argument present (can be undef)\n           new value, string or array ref, optional\n\n\n\nsub named_submeta {\n    my ($self, $name, $start, $end, $value) = @_;\n\n    $name ||= $DEFAULT_NAME;\n    $start ||=1;\n    $start =~ /^[+]?\\d+$/ and $start > 0 or\n        $self->throw(\"Need at least a positive integer start value\");\n    $start--;\n    my $meta_len = scalar(@{$self->{_meta}->{$name}});\n    if (defined $value) {\n        my $arrayref;\n\n        if (ref $value eq 'ARRAY' ) { # array ref\n            $arrayref = $value;\n        }\n        elsif (not ref($value)) { # scalar\n            $arrayref = [split /\\s+/, $value];\n        } else {\n            $self->throw(\"I need a space separated scalar or array ref, not [\". ref($value). \"]\");\n        }\n\n        $self->warn(\"You are setting meta values beyond the length of the sequence\\n\".\n                    \"[$start > \". length($self->seq).\"] in sequence \". $self->id)\n            if $start + scalar @{$arrayref} -1 > $self->length;\n\n\n        $end or $end = @{$arrayref} + $start;\n        $end--;\n\n        # test for length; pad if needed\n        my $diff = $end - $start - scalar @{$arrayref};\n        if ($diff > 0) {\n            foreach (1..$diff) { push @{$arrayref}, $META_GAP}\n        }\n\n        @{$self->{_meta}->{$name}}[$start..$end] = @{$arrayref};\n\n        $self->_do_flush if $self->force_flush;\n\n        return $arrayref;\n\n    } else {\n        # don't set by seq length; use meta array length instead; bug 2478\n        $end ||= $meta_len;\n        if ($end > $meta_len) {\n            $self->warn(\"End is longer than meta sequence $name length; resetting to $meta_len\");\n            $end = $meta_len;\n        }\n        # warn but don't reset (push use of trunc() instead)\n        $self->warn(\"End is longer than sequence length; use trunc() \\n\".\n                    \"if you want a fully truncated object\") if $end > $self->length;\n        $end--;\n        return [@{$self->{_meta}->{$name}}[$start..$end]];\n    }\n}\n\n\n=head2 named_submeta_text\n\n Title   : named_submeta_text\n Usage   : $meta_values  = $obj->named_submeta_text($name, 20, $value_string);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : scalar, name of the meta data\n Args    : integer, start position, optional\n           integer, end position, optional\n           new value, string or array ref, optional\n\n\nsub named_submeta_text {\n    return join ' ', @{shift->named_submeta(@_)};\n}\n\n=head2 meta_names\n\n Title   : meta_names\n Usage   : @meta_names  = $obj->meta_names()\n Function: Retrives an array of meta data set names. The default\n           (unnamed) set name is guarantied to be the first name if it\n           contains any data.\n Returns : an array of names\n Args    : none\n\n\nsub meta_names {\n    my ($self) = @_;\n\n    my @r;\n    foreach  ( sort keys %{$self->{'_meta'}} ) {\n        push (@r, $_) unless $_ eq $DEFAULT_NAME;\n    }\n    unshift @r, $DEFAULT_NAME if $self->{'_meta'}->{$DEFAULT_NAME};\n    return @r;\n}\n\n\n=head2 meta_length\n\n Title   : meta_length()\n Usage   : $meta_len  = $obj->meta_length();\n Function: return the number of elements in the meta set\n Returns : integer\n Args    : -\n\n\nsub meta_length {\n   my ($self) = @_;\n   return $self->named_meta_length($DEFAULT_NAME);\n}\n\n\n=head2 named_meta_length\n\n Title   : named_meta_length()\n Usage   : $meeta_len  = $obj->named_meta_length($name);\n Function: return the number of elements in the named meta set\n Returns : integer\n Args    : -\n\n\nsub named_meta_length {\n   my ($self, $name) = @_;\n   $name ||= $DEFAULT_NAME;\n   return scalar @{$self->{'_meta'}->{$name}};\n}\n\n\n\n=head2 force_flush\n\n Title   : force_flush()\n Usage   : $force_flush = $obj->force_flush(1);\n Function: Automatically pad with empty values or truncate meta values\n           to sequence length. Not done by default.\n Returns : boolean 1 or 0\n Args    : optional boolean value\n\nNote that if you turn this forced padding off, the previously padded\nvalues are not changed.","parameters":[{"label":"$self"},{"label":"$value"}],"label":"force_flush($self,$value)"}},{"name":"force_flush","kind":12,"line":546},{"kind":12,"name":"force_flush","line":549},{"name":"force_flush","kind":12,"line":552},{"signature":{"documentation":"1;\n# $Id: Array.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::Meta::Array\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::Meta::Array - array-based generic implementation of a\nsequence class with residue-based meta information\n\n=head1 SYNOPSIS\n\n  use Bio::LocatableSeq;\n  use Bio::Seq::Meta::Array;\n\n  my $seq = Bio::Seq::Meta::Array->new(-id=>'test',\n                                   -seq=>'ACTGCTAGCT',\n                                   -start=>2434,\n                                   -start=>2443,\n                                   -strand=>1,\n                                   -varbose=>1, # to see warnings\n                                  );\n\n  # to test this is a meta seq object\n  $seq->isa(\"Bio::Seq::Meta::Array\")\n      || $seq->throw(\"$seq is not a Bio::Seq::Meta::Array\");\n\n  $seq->meta('1 2 3 4 5 6 7 8 9 10');\n\n  # or you could create the Meta object directly\n  $seq = Bio::Seq::Meta::Array->new(-id=>'test',\n                                    -seq=>'ACTGCTAGCT',\n                                    -start=>2434,\n                                    -start=>2443,\n                                    -strand=>1,\n                                    -meta=>'1 2 3 4 5 6 7 8 9 10',\n                                    -varbose=>1, # to see warnings\n                                   );\n\n\n  # accessors\n  $arrayref   = $seq->meta();\n  $string     = $seq->meta_text();\n  $substring  = $seq->submeta_text(2,5);\n  $unique_key = $seq->accession_number();\n\n=head1 DESCRIPTION\n\nThis class implements generic methods for sequences with residue-based\nmeta information. Meta sequences with meta data are Bio::LocatableSeq\nobjects with additional methods to store that meta information. See\nL<Bio::LocatableSeq> and L<Bio::Seq::MetaI>.\n\nThe meta information in this class can be a string of variable length\nand can be a complex structure.  Blank values are undef or zero.\n\nApplication specific implementations should inherit from this class to\noverride and add to these methods.\n\nThis class can be used for storing sequence quality values but\nBio::Seq::Quality has named methods that make it easier.\n\n=head1 SEE ALSO\n\nL<Bio::LocatableSeq>,\nL<Bio::Seq::MetaI>,\nL<Bio::Seq::Meta>,\nL<Bio::Seq::Quality>\n\n=head1 NOTE\n\nThis Bio::Seq::MetaI implementation inherits from Bio::LocatableSeq, which\nitself inherits from Bio::PrimarySeq. It is not a Bio::SeqI, so bless-ing\nobjects of this class into a Bio::SeqI or vice versa and will not work as\nexpected (see bug 2262). This may be addressed in a future refactor of\nBio::LocatableSeq.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nChad Matsalla, bioinformatics@dieselwurks.com\nAaron Mackey, amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::Meta::Array;\nuse vars qw(@ISA $DEFAULT_NAME $GAP $META_GAP);\nuse strict;\n\n#use overload '\"\"' => \\&to_string;\n\nuse base qw(Bio::LocatableSeq Bio::Seq Bio::Seq::MetaI);\n\nBEGIN {\n\n    $DEFAULT_NAME = 'DEFAULT';\n    $GAP = '-';\n    $META_GAP = 0;\n}\n\n=head2 new\n\n Title   : new\n Usage   : $metaseq = Bio::Seq::Meta::Array->new\n\t        ( -meta => 'aaaaaaaabbbbbbbb',\n                  -seq =>  'TKLMILVSHIVILSRM'\n\t          -id  => 'human_id',\n\t          -accession_number => 'S000012',\n\t        );\n Function: Constructor for Bio::Seq::Meta::Array class, meta data being in a\n           string. Note that you can provide an empty quality string.\n Returns : a new Bio::Seq::Meta::Array object\n\n\nsub new {\n    my ($class, %args) = @_;\n\t#defined inheritance according to stated baseclass,\n\t#if undefined then will be PrimarySeq\n\tif (defined($args{'-baseclass'})) {\n\t\t@ISA = ($args{'-baseclass'},\"Bio::Seq::MetaI\");\n\t\t}\n\telse {\n\t\t@ISA = qw( Bio::LocatableSeq Bio::Seq Bio::Seq::MetaI );\n\t\t}\n\n    my $self = $class->SUPER::new(%args);\n\n    my($meta, $forceflush) =\n        $self->_rearrange([qw(META\n                              FORCE_FLUSH\n                              )],\n                          %args);\n\n    $self->{'_meta'}->{$DEFAULT_NAME} = [];\n\n    $meta && $self->meta($meta);\n    $forceflush && $self->force_flush($forceflush);\n\n    return $self;\n}\n\n\n=head2 meta\n\n Title   : meta\n Usage   : $meta_values  = $obj->meta($values_string);\n Function:\n\n           Get and set method for the meta data starting from residue\n           position one. Since it is dependent on the length of the\n           sequence, it needs to be manipulated after the sequence.\n\n           The length of the returned value always matches the length\n           of the sequence.\n\n Returns : reference to an array of meta data\n Args    : new value, string or array ref, optional\n\n\nsub meta {\n   shift->named_meta($DEFAULT_NAME, shift);\n}\n\n=head2 meta_text\n\n Title   : meta_text\n Usage   : $meta_values  = $obj->meta_text($values_arrayref);\n Function: Variant of meta() guarantied to return a string\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, string or array ref, optional\n\n\nsub meta_text {\n    return join ' ',  map {0 unless $_} @{shift->meta(shift)};\n}\n\n=head2 named_meta\n\n Title   : named_meta()\n Usage   : $meta_values  = $obj->named_meta($name, $values_arrayref);\n Function: A more general version of meta(). Each meta data set needs\n           to be named. See also L<meta_names>.\n Returns : reference to an array of meta data\n Args    : scalar, name of the meta data set\n           new value, string or array ref, optional\n\n\nsub named_meta {\n   my ($self, $name, $value) = @_;\n\n   $name ||= $DEFAULT_NAME;\n\n   if (defined $value) {\n       my ($arrayref);\n\n       if (ref $value eq 'ARRAY' ) { # array ref\n           $arrayref = $value;\n       }\n       elsif (not ref($value)) { # scalar\n           $arrayref = [split /\\s+/, $value];\n       } else {\n           $self->throw(\"I need a scalar or array ref, not [\". ref($value). \"]\");\n       }\n\n       # test for length\n       my $diff = $self->length - @{$arrayref};\n       if ($diff > 0) {\n           foreach (1..$diff) { push @{$arrayref}, 0;}\n       }\n\n       $self->{'_meta'}->{$name} = $arrayref;\n\n       #$self->_test_gap_positions($name) if $self->verbose > 0;\n   }\n\n   $self->_do_flush if $self->force_flush;\n\n   return $self->{'_meta'}->{$name} || (\" \" x $self->length);\n\n}\n\n=head2 _test_gap_positions\n\n Title   : _test_gap_positions\n Usage   : $meta_values  = $obj->_test_gap_positions($name);\n Function: Internal test for correct position of gap characters.\n           Gap being only '-' this time.\n\n           This method is called from named_meta() when setting meta\n           data but only if verbose is positive as this can be an\n           expensive process on very long sequences. Set verbose(1) to\n           see warnings when gaps do not align in sequence and meta\n           data and turn them into errors by setting verbose(2).\n\n Returns : true on success, prints warnings\n Args    : none\n\n\nsub _test_gap_positions {\n    my $self = shift;\n    my $name = shift;\n    my $success = 1;\n\n    $self->seq || return $success;\n    my $len = CORE::length($self->seq);\n    for (my $i=0; $i < $len; $i++) {\n        my $s = substr $self->{seq}, $i, 1;\n        my $m = substr $self->{_meta}->{$name}, $i, 1;\n        $self->warn(\"Gap mismatch in column [\". ($i+1). \"] of [$name] meta data in seq [\". $self->id. \"]\")\n            and $success = 0\n                if ($m eq '-') && $s ne $m;\n    }\n    return $success;\n}\n\n=head2 named_meta_text\n\n Title   : named_meta_text()\n Usage   : $meta_values  = $obj->named_meta_text($name, $values_arrayref);\n Function: Variant of named_meta() guarantied to return a textual\n           representation  of the named meta data.\n           For details, see L<meta>.\n Returns : a string\n Args    : scalar, name of the meta data set\n           new value, string or array ref, optional\n\n\nsub named_meta_text {\n    return join ' ', @{shift->named_meta(@_)};\n\n}\n\n=head2 submeta\n\n Title   : submeta\n Usage   : $subset_of_meta_values = $obj->submeta(10, 20, $value_string);\n           $subset_of_meta_values = $obj->submeta(10, undef, $value_string);\n Function:\n\n           Get and set method for meta data for subsequences.\n\n           Numbering starts from 1 and the number is inclusive, ie 1-2\n           are the first two residue of the sequence. Start cannot be\n           larger than end but can be equal.\n\n           If the second argument is missing the returned values\n           should extend to the end of the sequence.\n\n           The return value may be a string or an array reference,\n           depending on the implentation. If in doubt, use\n           submeta_text() which is a variant guarantied to return a\n           string.  See L<submeta_text>.\n\n Returns : A reference to an array or a string\n Args    : integer, start position\n           integer, end position, optional when a third argument present\n           new value, string or array ref, optional\n\n\nsub submeta {\n   shift->named_submeta($DEFAULT_NAME, @_);\n}\n\n=head2 submeta_text\n\n Title   : submeta_text\n Usage   : $meta_values  = $obj->submeta_text(20, $value_string);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, string or array ref, optional\n\n\n\nsub submeta_text {\n    return join ' ', @{shift->named_submeta($DEFAULT_NAME, @_)};\n}\n\n=head2 named_submeta\n\n Title   : named_submeta\n Usage   : $subset_of_meta_values = $obj->named_submeta($name, 10, 20, $value_string);\n           $subset_of_meta_values = $obj->named_submeta($name, 10);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : A reference to an array or a string\n Args    : scalar, name of the meta data set\n           integer, start position\n           integer, end position, optional when a third argument present (can be undef)\n           new value, string or array ref, optional\n\n\n\nsub named_submeta {\n    my ($self, $name, $start, $end, $value) = @_;\n\n    $name ||= $DEFAULT_NAME;\n    $start ||=1;\n    $start =~ /^[+]?\\d+$/ and $start > 0 or\n        $self->throw(\"Need at least a positive integer start value\");\n    $start--;\n    my $meta_len = scalar(@{$self->{_meta}->{$name}});\n    if (defined $value) {\n        my $arrayref;\n\n        if (ref $value eq 'ARRAY' ) { # array ref\n            $arrayref = $value;\n        }\n        elsif (not ref($value)) { # scalar\n            $arrayref = [split /\\s+/, $value];\n        } else {\n            $self->throw(\"I need a space separated scalar or array ref, not [\". ref($value). \"]\");\n        }\n\n        $self->warn(\"You are setting meta values beyond the length of the sequence\\n\".\n                    \"[$start > \". length($self->seq).\"] in sequence \". $self->id)\n            if $start + scalar @{$arrayref} -1 > $self->length;\n\n\n        $end or $end = @{$arrayref} + $start;\n        $end--;\n\n        # test for length; pad if needed\n        my $diff = $end - $start - scalar @{$arrayref};\n        if ($diff > 0) {\n            foreach (1..$diff) { push @{$arrayref}, $META_GAP}\n        }\n\n        @{$self->{_meta}->{$name}}[$start..$end] = @{$arrayref};\n\n        $self->_do_flush if $self->force_flush;\n\n        return $arrayref;\n\n    } else {\n        # don't set by seq length; use meta array length instead; bug 2478\n        $end ||= $meta_len;\n        if ($end > $meta_len) {\n            $self->warn(\"End is longer than meta sequence $name length; resetting to $meta_len\");\n            $end = $meta_len;\n        }\n        # warn but don't reset (push use of trunc() instead)\n        $self->warn(\"End is longer than sequence length; use trunc() \\n\".\n                    \"if you want a fully truncated object\") if $end > $self->length;\n        $end--;\n        return [@{$self->{_meta}->{$name}}[$start..$end]];\n    }\n}\n\n\n=head2 named_submeta_text\n\n Title   : named_submeta_text\n Usage   : $meta_values  = $obj->named_submeta_text($name, 20, $value_string);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : scalar, name of the meta data\n Args    : integer, start position, optional\n           integer, end position, optional\n           new value, string or array ref, optional\n\n\nsub named_submeta_text {\n    return join ' ', @{shift->named_submeta(@_)};\n}\n\n=head2 meta_names\n\n Title   : meta_names\n Usage   : @meta_names  = $obj->meta_names()\n Function: Retrives an array of meta data set names. The default\n           (unnamed) set name is guarantied to be the first name if it\n           contains any data.\n Returns : an array of names\n Args    : none\n\n\nsub meta_names {\n    my ($self) = @_;\n\n    my @r;\n    foreach  ( sort keys %{$self->{'_meta'}} ) {\n        push (@r, $_) unless $_ eq $DEFAULT_NAME;\n    }\n    unshift @r, $DEFAULT_NAME if $self->{'_meta'}->{$DEFAULT_NAME};\n    return @r;\n}\n\n\n=head2 meta_length\n\n Title   : meta_length()\n Usage   : $meta_len  = $obj->meta_length();\n Function: return the number of elements in the meta set\n Returns : integer\n Args    : -\n\n\nsub meta_length {\n   my ($self) = @_;\n   return $self->named_meta_length($DEFAULT_NAME);\n}\n\n\n=head2 named_meta_length\n\n Title   : named_meta_length()\n Usage   : $meeta_len  = $obj->named_meta_length($name);\n Function: return the number of elements in the named meta set\n Returns : integer\n Args    : -\n\n\nsub named_meta_length {\n   my ($self, $name) = @_;\n   $name ||= $DEFAULT_NAME;\n   return scalar @{$self->{'_meta'}->{$name}};\n}\n\n\n\n=head2 force_flush\n\n Title   : force_flush()\n Usage   : $force_flush = $obj->force_flush(1);\n Function: Automatically pad with empty values or truncate meta values\n           to sequence length. Not done by default.\n Returns : boolean 1 or 0\n Args    : optional boolean value\n\nNote that if you turn this forced padding off, the previously padded\nvalues are not changed.\n\n\nsub force_flush {\n    my ($self, $value) = @_;\n\n    if (defined $value) {\n        if ($value) {\n            $self->{force_flush} = 1;\n            $self->_do_flush;\n        } else {\n            $self->{force_flush} = 0;\n        }\n    }\n    return $self->{force_flush};\n}\n\n\n=head2 _do_flush\n\n Title   : _do_flush\n Usage   : \n Function: internal method to do the force that meta values are same\n           length as sequence . Called from L<force_flush>\n Returns : \n Args    : ","parameters":[{"label":"$self"}],"label":"_do_flush($self)"},"line":568,"range":{"end":{"character":9999,"line":582},"start":{"line":568,"character":0}},"kind":12,"definition":"sub","detail":"($self)","children":[{"definition":"my","line":569,"containerName":"_do_flush","localvar":"my","kind":13,"name":"$self"},{"name":"$name","localvar":"my","containerName":"_do_flush","kind":13,"line":571,"definition":"my"},{"kind":13,"containerName":"_do_flush","name":"$self","line":571},{"name":"meta_names","kind":12,"containerName":"_do_flush","line":571},{"kind":13,"containerName":"_do_flush","name":"$self","line":575},{"name":"length","containerName":"_do_flush","kind":12,"line":575},{"line":575,"name":"$self","kind":13,"containerName":"_do_flush"},{"line":575,"containerName":"_do_flush","kind":12,"name":"named_meta_length"},{"line":575,"name":"$name","kind":13,"containerName":"_do_flush"},{"definition":"my","line":576,"containerName":"_do_flush","localvar":"my","kind":13,"name":"$diff"},{"containerName":"_do_flush","kind":13,"name":"$self","line":576},{"line":576,"kind":12,"containerName":"_do_flush","name":"length"},{"name":"$self","kind":13,"containerName":"_do_flush","line":576},{"name":"named_meta_length","kind":12,"containerName":"_do_flush","line":576},{"line":576,"kind":13,"containerName":"_do_flush","name":"$name"},{"line":577,"containerName":"_do_flush","kind":13,"name":"$diff"},{"name":"$self","kind":13,"containerName":"_do_flush","line":577},{"line":577,"name":"$name","containerName":"_do_flush","kind":13},{"line":577,"name":"$META_GAP","kind":13,"containerName":"_do_flush"},{"line":580,"name":"$self","kind":13,"containerName":"_do_flush"},{"kind":12,"containerName":"_do_flush","name":"length","line":580},{"line":580,"containerName":"_do_flush","kind":13,"name":"$self"},{"name":"named_meta_length","containerName":"_do_flush","kind":12,"line":580},{"name":"$name","containerName":"_do_flush","kind":13,"line":580},{"containerName":"_do_flush","kind":13,"name":"$self","line":581},{"kind":13,"containerName":"_do_flush","name":"$name","line":581},{"name":"$self","containerName":"_do_flush","kind":13,"line":581},{"line":581,"containerName":"_do_flush","kind":13,"name":"$name"},{"line":581,"kind":13,"containerName":"_do_flush","name":"$self"},{"name":"length","containerName":"_do_flush","kind":12,"line":581}],"name":"_do_flush","containerName":"main::"},{"kind":12,"name":"_meta","line":581},{"line":581,"kind":12,"name":"_meta"},{"children":[{"containerName":"is_flush","localvar":"my","kind":13,"name":"$self","line":604,"definition":"my"},{"name":"$name","kind":13,"containerName":"is_flush","line":604},{"line":606,"name":"$self","kind":13,"containerName":"is_flush"},{"line":606,"kind":12,"containerName":"is_flush","name":"force_flush"},{"definition":"my","name":"$sticky","kind":13,"localvar":"my","containerName":"is_flush","line":608},{"line":611,"name":"$name","containerName":"is_flush","kind":13},{"name":"$sticky","containerName":"is_flush","kind":13,"line":612},{"line":612,"containerName":"is_flush","kind":13,"name":"$self"},{"line":612,"name":"length","kind":12,"containerName":"is_flush"},{"line":612,"containerName":"is_flush","kind":13,"name":"$self"},{"containerName":"is_flush","kind":12,"name":"named_meta_length","line":612},{"name":"$name","containerName":"is_flush","kind":13,"line":612},{"line":614,"kind":13,"localvar":"my","containerName":"is_flush","name":"$m","definition":"my"},{"line":614,"name":"$self","kind":13,"containerName":"is_flush"},{"kind":12,"containerName":"is_flush","name":"meta_names","line":614},{"name":"$sticky","containerName":"is_flush","kind":13,"line":615},{"kind":13,"containerName":"is_flush","name":"$self","line":615},{"line":615,"containerName":"is_flush","kind":12,"name":"length"},{"name":"$self","kind":13,"containerName":"is_flush","line":615},{"name":"named_meta_length","kind":12,"containerName":"is_flush","line":615},{"containerName":"is_flush","kind":13,"name":"$m","line":615},{"kind":13,"containerName":"is_flush","name":"$sticky","line":619},{"line":620,"name":"$self","kind":13,"containerName":"is_flush"},{"line":620,"name":"verbose","containerName":"is_flush","kind":12}],"containerName":"main::","name":"is_flush","definition":"sub","line":602,"kind":12,"range":{"end":{"character":9999,"line":625},"start":{"line":602,"character":0}}},{"range":{"end":{"character":9999,"line":654},"start":{"character":0,"line":644}},"kind":12,"line":644,"name":"revcom","containerName":"main::","children":[{"name":"$self","containerName":"revcom","localvar":"my","kind":13,"line":645,"definition":"my"},{"line":647,"name":"$self","kind":13,"containerName":"revcom"},{"name":"throw","kind":12,"containerName":"revcom","line":647},{"name":"$self","containerName":"revcom","kind":13,"line":648},{"name":"is_flush","kind":12,"containerName":"revcom","line":648},{"containerName":"revcom","localvar":"my","kind":13,"name":"$new","line":650,"definition":"my"},{"containerName":"revcom","kind":13,"name":"$self","line":650},{"name":"$end","localvar":"my","kind":13,"containerName":"revcom","line":651,"definition":"my"},{"line":651,"kind":13,"containerName":"revcom","name":"$self"},{"line":651,"kind":12,"containerName":"revcom","name":"length"},{"name":"$new","kind":13,"containerName":"revcom","line":653},{"line":653,"containerName":"revcom","kind":13,"name":"$self"},{"line":653,"kind":13,"containerName":"revcom","name":"$end"}],"definition":"sub"},{"line":651,"kind":12,"containerName":"revcom","name":"SUPER"},{"kind":12,"name":"_meta","line":653},{"line":653,"kind":12,"name":"_meta"},{"line":654,"kind":13,"containerName":null,"name":"%self"},{"kind":12,"name":"_meta","line":654},{"line":656,"containerName":null,"kind":13,"name":"$new"},{"line":669,"range":{"start":{"character":0,"line":669},"end":{"character":9999,"line":687}},"kind":12,"signature":{"documentation":"1;\n# $Id: Array.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::Meta::Array\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::Meta::Array - array-based generic implementation of a\nsequence class with residue-based meta information\n\n=head1 SYNOPSIS\n\n  use Bio::LocatableSeq;\n  use Bio::Seq::Meta::Array;\n\n  my $seq = Bio::Seq::Meta::Array->new(-id=>'test',\n                                   -seq=>'ACTGCTAGCT',\n                                   -start=>2434,\n                                   -start=>2443,\n                                   -strand=>1,\n                                   -varbose=>1, # to see warnings\n                                  );\n\n  # to test this is a meta seq object\n  $seq->isa(\"Bio::Seq::Meta::Array\")\n      || $seq->throw(\"$seq is not a Bio::Seq::Meta::Array\");\n\n  $seq->meta('1 2 3 4 5 6 7 8 9 10');\n\n  # or you could create the Meta object directly\n  $seq = Bio::Seq::Meta::Array->new(-id=>'test',\n                                    -seq=>'ACTGCTAGCT',\n                                    -start=>2434,\n                                    -start=>2443,\n                                    -strand=>1,\n                                    -meta=>'1 2 3 4 5 6 7 8 9 10',\n                                    -varbose=>1, # to see warnings\n                                   );\n\n\n  # accessors\n  $arrayref   = $seq->meta();\n  $string     = $seq->meta_text();\n  $substring  = $seq->submeta_text(2,5);\n  $unique_key = $seq->accession_number();\n\n=head1 DESCRIPTION\n\nThis class implements generic methods for sequences with residue-based\nmeta information. Meta sequences with meta data are Bio::LocatableSeq\nobjects with additional methods to store that meta information. See\nL<Bio::LocatableSeq> and L<Bio::Seq::MetaI>.\n\nThe meta information in this class can be a string of variable length\nand can be a complex structure.  Blank values are undef or zero.\n\nApplication specific implementations should inherit from this class to\noverride and add to these methods.\n\nThis class can be used for storing sequence quality values but\nBio::Seq::Quality has named methods that make it easier.\n\n=head1 SEE ALSO\n\nL<Bio::LocatableSeq>,\nL<Bio::Seq::MetaI>,\nL<Bio::Seq::Meta>,\nL<Bio::Seq::Quality>\n\n=head1 NOTE\n\nThis Bio::Seq::MetaI implementation inherits from Bio::LocatableSeq, which\nitself inherits from Bio::PrimarySeq. It is not a Bio::SeqI, so bless-ing\nobjects of this class into a Bio::SeqI or vice versa and will not work as\nexpected (see bug 2262). This may be addressed in a future refactor of\nBio::LocatableSeq.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nChad Matsalla, bioinformatics@dieselwurks.com\nAaron Mackey, amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::Meta::Array;\nuse vars qw(@ISA $DEFAULT_NAME $GAP $META_GAP);\nuse strict;\n\n#use overload '\"\"' => \\&to_string;\n\nuse base qw(Bio::LocatableSeq Bio::Seq Bio::Seq::MetaI);\n\nBEGIN {\n\n    $DEFAULT_NAME = 'DEFAULT';\n    $GAP = '-';\n    $META_GAP = 0;\n}\n\n=head2 new\n\n Title   : new\n Usage   : $metaseq = Bio::Seq::Meta::Array->new\n\t        ( -meta => 'aaaaaaaabbbbbbbb',\n                  -seq =>  'TKLMILVSHIVILSRM'\n\t          -id  => 'human_id',\n\t          -accession_number => 'S000012',\n\t        );\n Function: Constructor for Bio::Seq::Meta::Array class, meta data being in a\n           string. Note that you can provide an empty quality string.\n Returns : a new Bio::Seq::Meta::Array object\n\n\nsub new {\n    my ($class, %args) = @_;\n\t#defined inheritance according to stated baseclass,\n\t#if undefined then will be PrimarySeq\n\tif (defined($args{'-baseclass'})) {\n\t\t@ISA = ($args{'-baseclass'},\"Bio::Seq::MetaI\");\n\t\t}\n\telse {\n\t\t@ISA = qw( Bio::LocatableSeq Bio::Seq Bio::Seq::MetaI );\n\t\t}\n\n    my $self = $class->SUPER::new(%args);\n\n    my($meta, $forceflush) =\n        $self->_rearrange([qw(META\n                              FORCE_FLUSH\n                              )],\n                          %args);\n\n    $self->{'_meta'}->{$DEFAULT_NAME} = [];\n\n    $meta && $self->meta($meta);\n    $forceflush && $self->force_flush($forceflush);\n\n    return $self;\n}\n\n\n=head2 meta\n\n Title   : meta\n Usage   : $meta_values  = $obj->meta($values_string);\n Function:\n\n           Get and set method for the meta data starting from residue\n           position one. Since it is dependent on the length of the\n           sequence, it needs to be manipulated after the sequence.\n\n           The length of the returned value always matches the length\n           of the sequence.\n\n Returns : reference to an array of meta data\n Args    : new value, string or array ref, optional\n\n\nsub meta {\n   shift->named_meta($DEFAULT_NAME, shift);\n}\n\n=head2 meta_text\n\n Title   : meta_text\n Usage   : $meta_values  = $obj->meta_text($values_arrayref);\n Function: Variant of meta() guarantied to return a string\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, string or array ref, optional\n\n\nsub meta_text {\n    return join ' ',  map {0 unless $_} @{shift->meta(shift)};\n}\n\n=head2 named_meta\n\n Title   : named_meta()\n Usage   : $meta_values  = $obj->named_meta($name, $values_arrayref);\n Function: A more general version of meta(). Each meta data set needs\n           to be named. See also L<meta_names>.\n Returns : reference to an array of meta data\n Args    : scalar, name of the meta data set\n           new value, string or array ref, optional\n\n\nsub named_meta {\n   my ($self, $name, $value) = @_;\n\n   $name ||= $DEFAULT_NAME;\n\n   if (defined $value) {\n       my ($arrayref);\n\n       if (ref $value eq 'ARRAY' ) { # array ref\n           $arrayref = $value;\n       }\n       elsif (not ref($value)) { # scalar\n           $arrayref = [split /\\s+/, $value];\n       } else {\n           $self->throw(\"I need a scalar or array ref, not [\". ref($value). \"]\");\n       }\n\n       # test for length\n       my $diff = $self->length - @{$arrayref};\n       if ($diff > 0) {\n           foreach (1..$diff) { push @{$arrayref}, 0;}\n       }\n\n       $self->{'_meta'}->{$name} = $arrayref;\n\n       #$self->_test_gap_positions($name) if $self->verbose > 0;\n   }\n\n   $self->_do_flush if $self->force_flush;\n\n   return $self->{'_meta'}->{$name} || (\" \" x $self->length);\n\n}\n\n=head2 _test_gap_positions\n\n Title   : _test_gap_positions\n Usage   : $meta_values  = $obj->_test_gap_positions($name);\n Function: Internal test for correct position of gap characters.\n           Gap being only '-' this time.\n\n           This method is called from named_meta() when setting meta\n           data but only if verbose is positive as this can be an\n           expensive process on very long sequences. Set verbose(1) to\n           see warnings when gaps do not align in sequence and meta\n           data and turn them into errors by setting verbose(2).\n\n Returns : true on success, prints warnings\n Args    : none\n\n\nsub _test_gap_positions {\n    my $self = shift;\n    my $name = shift;\n    my $success = 1;\n\n    $self->seq || return $success;\n    my $len = CORE::length($self->seq);\n    for (my $i=0; $i < $len; $i++) {\n        my $s = substr $self->{seq}, $i, 1;\n        my $m = substr $self->{_meta}->{$name}, $i, 1;\n        $self->warn(\"Gap mismatch in column [\". ($i+1). \"] of [$name] meta data in seq [\". $self->id. \"]\")\n            and $success = 0\n                if ($m eq '-') && $s ne $m;\n    }\n    return $success;\n}\n\n=head2 named_meta_text\n\n Title   : named_meta_text()\n Usage   : $meta_values  = $obj->named_meta_text($name, $values_arrayref);\n Function: Variant of named_meta() guarantied to return a textual\n           representation  of the named meta data.\n           For details, see L<meta>.\n Returns : a string\n Args    : scalar, name of the meta data set\n           new value, string or array ref, optional\n\n\nsub named_meta_text {\n    return join ' ', @{shift->named_meta(@_)};\n\n}\n\n=head2 submeta\n\n Title   : submeta\n Usage   : $subset_of_meta_values = $obj->submeta(10, 20, $value_string);\n           $subset_of_meta_values = $obj->submeta(10, undef, $value_string);\n Function:\n\n           Get and set method for meta data for subsequences.\n\n           Numbering starts from 1 and the number is inclusive, ie 1-2\n           are the first two residue of the sequence. Start cannot be\n           larger than end but can be equal.\n\n           If the second argument is missing the returned values\n           should extend to the end of the sequence.\n\n           The return value may be a string or an array reference,\n           depending on the implentation. If in doubt, use\n           submeta_text() which is a variant guarantied to return a\n           string.  See L<submeta_text>.\n\n Returns : A reference to an array or a string\n Args    : integer, start position\n           integer, end position, optional when a third argument present\n           new value, string or array ref, optional\n\n\nsub submeta {\n   shift->named_submeta($DEFAULT_NAME, @_);\n}\n\n=head2 submeta_text\n\n Title   : submeta_text\n Usage   : $meta_values  = $obj->submeta_text(20, $value_string);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, string or array ref, optional\n\n\n\nsub submeta_text {\n    return join ' ', @{shift->named_submeta($DEFAULT_NAME, @_)};\n}\n\n=head2 named_submeta\n\n Title   : named_submeta\n Usage   : $subset_of_meta_values = $obj->named_submeta($name, 10, 20, $value_string);\n           $subset_of_meta_values = $obj->named_submeta($name, 10);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : A reference to an array or a string\n Args    : scalar, name of the meta data set\n           integer, start position\n           integer, end position, optional when a third argument present (can be undef)\n           new value, string or array ref, optional\n\n\n\nsub named_submeta {\n    my ($self, $name, $start, $end, $value) = @_;\n\n    $name ||= $DEFAULT_NAME;\n    $start ||=1;\n    $start =~ /^[+]?\\d+$/ and $start > 0 or\n        $self->throw(\"Need at least a positive integer start value\");\n    $start--;\n    my $meta_len = scalar(@{$self->{_meta}->{$name}});\n    if (defined $value) {\n        my $arrayref;\n\n        if (ref $value eq 'ARRAY' ) { # array ref\n            $arrayref = $value;\n        }\n        elsif (not ref($value)) { # scalar\n            $arrayref = [split /\\s+/, $value];\n        } else {\n            $self->throw(\"I need a space separated scalar or array ref, not [\". ref($value). \"]\");\n        }\n\n        $self->warn(\"You are setting meta values beyond the length of the sequence\\n\".\n                    \"[$start > \". length($self->seq).\"] in sequence \". $self->id)\n            if $start + scalar @{$arrayref} -1 > $self->length;\n\n\n        $end or $end = @{$arrayref} + $start;\n        $end--;\n\n        # test for length; pad if needed\n        my $diff = $end - $start - scalar @{$arrayref};\n        if ($diff > 0) {\n            foreach (1..$diff) { push @{$arrayref}, $META_GAP}\n        }\n\n        @{$self->{_meta}->{$name}}[$start..$end] = @{$arrayref};\n\n        $self->_do_flush if $self->force_flush;\n\n        return $arrayref;\n\n    } else {\n        # don't set by seq length; use meta array length instead; bug 2478\n        $end ||= $meta_len;\n        if ($end > $meta_len) {\n            $self->warn(\"End is longer than meta sequence $name length; resetting to $meta_len\");\n            $end = $meta_len;\n        }\n        # warn but don't reset (push use of trunc() instead)\n        $self->warn(\"End is longer than sequence length; use trunc() \\n\".\n                    \"if you want a fully truncated object\") if $end > $self->length;\n        $end--;\n        return [@{$self->{_meta}->{$name}}[$start..$end]];\n    }\n}\n\n\n=head2 named_submeta_text\n\n Title   : named_submeta_text\n Usage   : $meta_values  = $obj->named_submeta_text($name, 20, $value_string);\n Function: Variant of submeta() guarantied to return a textual\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : scalar, name of the meta data\n Args    : integer, start position, optional\n           integer, end position, optional\n           new value, string or array ref, optional\n\n\nsub named_submeta_text {\n    return join ' ', @{shift->named_submeta(@_)};\n}\n\n=head2 meta_names\n\n Title   : meta_names\n Usage   : @meta_names  = $obj->meta_names()\n Function: Retrives an array of meta data set names. The default\n           (unnamed) set name is guarantied to be the first name if it\n           contains any data.\n Returns : an array of names\n Args    : none\n\n\nsub meta_names {\n    my ($self) = @_;\n\n    my @r;\n    foreach  ( sort keys %{$self->{'_meta'}} ) {\n        push (@r, $_) unless $_ eq $DEFAULT_NAME;\n    }\n    unshift @r, $DEFAULT_NAME if $self->{'_meta'}->{$DEFAULT_NAME};\n    return @r;\n}\n\n\n=head2 meta_length\n\n Title   : meta_length()\n Usage   : $meta_len  = $obj->meta_length();\n Function: return the number of elements in the meta set\n Returns : integer\n Args    : -\n\n\nsub meta_length {\n   my ($self) = @_;\n   return $self->named_meta_length($DEFAULT_NAME);\n}\n\n\n=head2 named_meta_length\n\n Title   : named_meta_length()\n Usage   : $meeta_len  = $obj->named_meta_length($name);\n Function: return the number of elements in the named meta set\n Returns : integer\n Args    : -\n\n\nsub named_meta_length {\n   my ($self, $name) = @_;\n   $name ||= $DEFAULT_NAME;\n   return scalar @{$self->{'_meta'}->{$name}};\n}\n\n\n\n=head2 force_flush\n\n Title   : force_flush()\n Usage   : $force_flush = $obj->force_flush(1);\n Function: Automatically pad with empty values or truncate meta values\n           to sequence length. Not done by default.\n Returns : boolean 1 or 0\n Args    : optional boolean value\n\nNote that if you turn this forced padding off, the previously padded\nvalues are not changed.\n\n\nsub force_flush {\n    my ($self, $value) = @_;\n\n    if (defined $value) {\n        if ($value) {\n            $self->{force_flush} = 1;\n            $self->_do_flush;\n        } else {\n            $self->{force_flush} = 0;\n        }\n    }\n    return $self->{force_flush};\n}\n\n\n=head2 _do_flush\n\n Title   : _do_flush\n Usage   : \n Function: internal method to do the force that meta values are same\n           length as sequence . Called from L<force_flush>\n Returns : \n Args    : \n\n\n\nsub _do_flush {\n    my ($self) = @_;\n\n    foreach my $name ($self->meta_names) {\n        #print \"seq: \", $self->length , \"  \", $name, \": \", $self->named_meta_length($name), \"======\\n\";\n        \n        # elongnation\n        if ($self->length > $self->named_meta_length($name)) {\n            my $diff = $self->length - $self->named_meta_length($name);\n            foreach (1..$diff) { push @{$self->{'_meta'}->{$name}}, $META_GAP}\n        }\n        # truncation\n        elsif ( $self->length < $self->named_meta_length($name) ) {\n            $self->{_meta}->{$name} = [@{$self->{_meta}->{$name}}[0..($self->length-1)]]\n        }\n    }\n}\n\n\n\n=head2 is_flush\n\n Title   : is_flush\n Usage   : $is_flush  = $obj->is_flush()\n           or  $is_flush = $obj->is_flush($my_meta_name)\n Function: Boolean to tell if all meta values are in\n           flush with the sequence length.\n           Returns true if force_flush() is set\n           Set verbosity to a positive value to see failed meta sets\n Returns : boolean 1 or 0\n Args    : optional name of the meta set\n\n\nsub is_flush {\n\n    my ($self, $name) = shift;\n\n    return 1 if $self->force_flush;\n\n    my $sticky = '';\n\n\n    if ($name) {\n        $sticky .= \"$name \" if $self->length != $self->named_meta_length($name);\n    } else {\n        foreach my $m ($self->meta_names) {\n            $sticky .= \"$m \" if $self->length != $self->named_meta_length($m);\n        }\n    }\n\n    if ($sticky) {\n        print \"These meta set are not flush: $sticky\\n\" if $self->verbose; \n        return 0;\n    }\n\n    return 1;\n}\n\n\n=head1 Bio::PrimarySeqI methods\n\n=head2 revcom\n\n Title   : revcom\n Usage   : $newseq = $seq->revcom();\n Function: Produces a new Bio::Seq::MetaI implementing object where\n           the order of residues and their meta information is reversed.\n Returns : A new (fresh) Bio::Seq::Meta object\n Args    : none\n Throws  : if the object returns false on is_flush()\n\nNote: The method does nothing to meta values, it reorders them, only.\n\n\nsub revcom {\n    my $self = shift;\n\n    $self->throw(\"Can not get a reverse complement. The object is not flush.\")\n        unless $self->is_flush;\n\n    my $new = $self->SUPER::revcom;\n    my $end = $self->length - 1;\n    map {\n        $new->{_meta}->{$_} = [ reverse @{$self->{_meta}->{$_}}[0..$end]]\n    } keys %{$self->{_meta}};\n\n    return $new;\n}\n\n=head2 trunc\n\n Title   : trunc\n Usage   : $subseq = $seq->trunc(10,100);\n Function: Provides a truncation of a sequence together with meta data\n Returns : a fresh Bio::Seq::Meta implementing object\n Args    : Two integers denoting first and last residue of the sub-sequence.","parameters":[{"label":"$self"},{"label":"$start"},{"label":"$end"}],"label":"trunc($self,$start,$end)"},"children":[{"definition":"my","containerName":"trunc","localvar":"my","kind":13,"name":"$self","line":670},{"line":670,"name":"$start","containerName":"trunc","kind":13},{"line":670,"kind":13,"containerName":"trunc","name":"$end"},{"kind":13,"containerName":"trunc","name":"$start","line":673},{"line":673,"kind":13,"containerName":"trunc","name":"$start"},{"line":674,"name":"$self","kind":13,"containerName":"trunc"},{"line":674,"containerName":"trunc","kind":12,"name":"throw"},{"name":"$end","kind":13,"containerName":"trunc","line":675},{"line":675,"containerName":"trunc","kind":13,"name":"$end"},{"line":676,"kind":13,"containerName":"trunc","name":"$self"},{"containerName":"trunc","kind":12,"name":"throw","line":676},{"line":677,"name":"$end","kind":13,"containerName":"trunc"},{"line":677,"name":"$start","containerName":"trunc","kind":13},{"name":"$self","kind":13,"containerName":"trunc","line":678},{"line":678,"containerName":"trunc","kind":12,"name":"throw"},{"containerName":"trunc","kind":13,"name":"$end","line":679},{"kind":13,"containerName":"trunc","name":"$self","line":679},{"line":679,"name":"length","containerName":"trunc","kind":12},{"line":680,"containerName":"trunc","kind":13,"name":"$self"},{"name":"throw","containerName":"trunc","kind":12,"line":680},{"line":682,"localvar":"my","kind":13,"containerName":"trunc","name":"$new","definition":"my"},{"line":682,"name":"$self","containerName":"trunc","kind":13},{"containerName":"trunc","kind":13,"name":"$start","line":682},{"kind":13,"containerName":"trunc","name":"$end","line":682},{"kind":13,"containerName":"trunc","name":"$start","line":683},{"name":"$end","kind":13,"containerName":"trunc","line":684},{"containerName":"trunc","kind":13,"name":"$new","line":686},{"line":686,"kind":13,"containerName":"trunc","name":"$self"},{"line":686,"containerName":"trunc","kind":13,"name":"$start"},{"line":686,"containerName":"trunc","kind":13,"name":"$end"}],"name":"trunc","containerName":"main::","definition":"sub","detail":"($self,$start,$end)"},{"containerName":"trunc","kind":12,"name":"SUPER","line":682},{"name":"_meta","kind":12,"line":686},{"name":"_meta","kind":12,"line":686},{"containerName":null,"kind":13,"name":"%self","line":687},{"line":687,"name":"_meta","kind":12},{"containerName":null,"kind":13,"name":"$new","line":688}]}