{"version":5,"vars":[{"name":"vars","containerName":"","kind":2,"line":92},{"line":98,"kind":2,"containerName":"","name":"base"},{"line":100,"containerName":null,"kind":13,"name":"$DEFAULTFORMAT"},{"line":101,"name":"$DEFAULT_WRITER_CLASS","kind":13,"containerName":null},{"line":103,"kind":13,"containerName":null,"name":"%ALIGN_TYPES"},{"line":110,"name":"%MODEMAP","kind":13,"containerName":null},{"name":"%MAPPING","containerName":null,"kind":13,"line":116},{"signature":{"label":"next_result($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: sim4.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::sim4\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::sim4 - parser for Sim4 alignments\n\n=head1 SYNOPSIS\n\n  # do not use this module directly, it is a driver for SearchIO\n  use Bio::SearchIO;\n  my $searchio = Bio::SearchIO->new(-file => 'results.sim4',\n                                   -format => 'sim4');\n\n  while ( my $result = $searchio->next_result ) {\n      while ( my $hit = $result->next_hit ) {\n\t  while ( my $hsp = $hit->next_hsp ) {\n              # ...\n\t  }\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis is a driver for the SearchIO system for parsing Sim4.\nhttp://globin.cse.psu.edu/html/docs/sim4.html\n\nCannot parse LAV or 'exon file' formats (A=2 or A=5)\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nLuc Gauthier (lgauthie@hotmail.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::sim4;\n\nuse strict;\nuse vars qw($DEFAULTFORMAT %ALIGN_TYPES\n            %MAPPING %MODEMAP $DEFAULT_WRITER_CLASS);\n\nuse POSIX;\nuse Bio::SearchIO::SearchResultEventBuilder;\n\nuse base qw(Bio::SearchIO);\n\n$DEFAULTFORMAT = 'SIM4';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n%ALIGN_TYPES = (\n    0 => 'Ruler',\n    1 => 'Query', \n    2 => 'Mid', \n    3 => 'Sbjct'\n);\n\n%MODEMAP = (\n    'Sim4Output' => 'result',\n    'Hit'        => 'hit',\n    'Hsp'        => 'hsp'\n);\n\n%MAPPING = (\n    'Hsp_query-from'=>  'HSP-query_start',\n    'Hsp_query-to'  =>  'HSP-query_end',\n    'Hsp_qseq'      =>  'HSP-query_seq',\n    'Hsp_qlength'   =>  'HSP-query_length',\n    'Hsp_querygaps'  => 'HSP-query_gaps',\n    'Hsp_hit-from'  =>  'HSP-hit_start',\n    'Hsp_hit-to'    =>  'HSP-hit_end',\n    'Hsp_hseq'      =>  'HSP-hit_seq',\n    'Hsp_hlength'   =>  'HSP-hit_length',\n    'Hsp_hitgaps'    => 'HSP-hit_gaps',\n    'Hsp_midline'   =>  'HSP-homology_seq',\n    'Hsp_score'     =>  'HSP-score',\n    'Hsp_align-len' =>  'HSP-hsp_length',\n    'Hsp_identity'  =>  'HSP-identical',\n\n    'Hit_id'        => 'HIT-name',\n    'Hit_desc'      => 'HIT-description',\n    'Hit_len'       => 'HIT-length',\n\n    'Sim4Output_program'   => 'RESULT-algorithm_name',\n    'Sim4Output_query-def' => 'RESULT-query_name',\n    'Sim4Output_query-desc'=> 'RESULT-query_description',\n    'Sim4Output_query-len' => 'RESULT-query_length',\n);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::sim4->new();\n Function: Builds a new Bio::SearchIO::sim4 object\n Returns : an instance of Bio::SearchIO::sim4\n Args    :\n\n\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none"},"range":{"start":{"character":0,"line":166},"end":{"line":385,"character":9999}},"kind":12,"line":166,"detail":"($self)","definition":"sub","containerName":"main::","name":"next_result","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"next_result","line":167},{"containerName":"next_result","kind":13,"name":"$self","line":172},{"definition":"my","name":"$seentop","kind":13,"localvar":"my","containerName":"next_result","line":173},{"line":173,"name":"$qfull","containerName":"next_result","kind":13},{"line":173,"containerName":"next_result","kind":13,"name":"@hsps"},{"name":"%alignment","containerName":"next_result","kind":13,"line":173},{"kind":13,"containerName":"next_result","name":"$format","line":173},{"localvar":"my","containerName":"next_result","kind":13,"name":"$hit_direction","line":174,"definition":"my"},{"name":"$self","containerName":"next_result","kind":13,"line":177},{"containerName":"next_result","kind":12,"name":"start_document","line":177},{"line":178,"containerName":"next_result","kind":13,"name":"$self"},{"kind":12,"containerName":"next_result","name":"start_element","line":178},{"definition":"my","line":179,"kind":13,"localvar":"my","containerName":"next_result","name":"$lastquery"},{"line":181,"name":"$self","kind":13,"containerName":"next_result"},{"line":181,"name":"_readline","kind":12,"containerName":"next_result"},{"line":186,"name":"$seentop","containerName":"next_result","kind":13},{"line":187,"name":"$format","kind":13,"containerName":"next_result"},{"kind":13,"containerName":"next_result","name":"$format","line":188},{"line":189,"name":"$self","containerName":"next_result","kind":13},{"name":"throw","containerName":"next_result","kind":12,"line":189},{"name":"$format","kind":13,"containerName":"next_result","line":189},{"line":194,"localvar":"my","kind":13,"containerName":"next_result","name":"$nm","definition":"my"},{"name":"$desc","containerName":"next_result","kind":13,"line":194},{"line":196,"kind":13,"containerName":"next_result","name":"$seentop"},{"line":197,"kind":13,"containerName":"next_result","name":"$self"},{"kind":12,"containerName":"next_result","name":"element","line":197},{"line":198,"name":"$nm","kind":13,"containerName":"next_result"},{"line":199,"name":"$self","containerName":"next_result","kind":13},{"name":"element","kind":12,"containerName":"next_result","line":199},{"line":200,"name":"$desc","kind":13,"containerName":"next_result"},{"line":201,"name":"$seentop","containerName":"next_result","kind":13},{"line":202,"name":"$nm","kind":13,"containerName":"next_result"},{"line":202,"name":"$lastquery","kind":13,"containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":203},{"kind":12,"containerName":"next_result","name":"_pushback","line":203},{"line":206,"name":"$lastquery","kind":13,"containerName":"next_result"},{"line":206,"kind":13,"containerName":"next_result","name":"$nm"},{"containerName":"next_result","kind":13,"name":"$self","line":208},{"line":208,"containerName":"next_result","kind":12,"name":"end_element"},{"line":208,"name":"$self","containerName":"next_result","kind":13},{"name":"in_element","containerName":"next_result","kind":12,"line":208},{"kind":13,"containerName":"next_result","name":"$self","line":210},{"name":"in_element","kind":12,"containerName":"next_result","line":210},{"kind":13,"containerName":"next_result","name":"@hsps","line":211},{"line":212,"containerName":"next_result","kind":13,"name":"$self"},{"name":"start_element","containerName":"next_result","kind":12,"line":212},{"definition":"my","line":213,"name":"$name","localvar":"my","containerName":"next_result","kind":13},{"kind":13,"containerName":"next_result","name":"$data","line":213},{"line":213,"name":"$_","containerName":"next_result","kind":13},{"line":214,"name":"$self","containerName":"next_result","kind":13},{"name":"$name","kind":13,"containerName":"next_result","line":214},{"containerName":"next_result","kind":13,"name":"$data","line":214},{"line":216,"kind":13,"containerName":"next_result","name":"$self"},{"name":"end_element","containerName":"next_result","kind":12,"line":216},{"name":"$self","containerName":"next_result","kind":13,"line":217},{"line":219,"name":"$format","kind":13,"containerName":"next_result"},{"name":"@hsps","containerName":"next_result","kind":13,"line":219},{"line":220,"name":"@hsps","containerName":"next_result","kind":13},{"kind":13,"containerName":"next_result","name":"%alignment","line":221},{"containerName":"next_result","kind":13,"name":"$qfull","line":222},{"containerName":"next_result","kind":13,"name":"$hit_direction","line":223},{"name":"$self","kind":13,"containerName":"next_result","line":224},{"name":"end_element","kind":12,"containerName":"next_result","line":224},{"line":229,"containerName":"next_result","kind":13,"name":"$self"},{"containerName":"next_result","kind":12,"name":"start_element","line":229},{"containerName":"next_result","kind":13,"name":"$self","line":230},{"line":230,"kind":12,"containerName":"next_result","name":"element"},{"name":"$self","containerName":"next_result","kind":13,"line":231},{"line":231,"name":"element","containerName":"next_result","kind":12},{"containerName":"next_result","kind":13,"name":"$self","line":232},{"line":232,"name":"element","containerName":"next_result","kind":12},{"line":237,"name":"$qfull","containerName":"next_result","kind":13},{"name":"$format","kind":13,"containerName":"next_result","line":238},{"kind":13,"containerName":"next_result","name":"$format","line":238},{"line":239,"name":"$self","kind":13,"containerName":"next_result"},{"kind":12,"containerName":"next_result","name":"element","line":239},{"line":242,"name":"$self","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":12,"name":"element","line":242},{"name":"$qfull","kind":13,"containerName":"next_result","line":243},{"name":"$hit_direction","kind":13,"containerName":"next_result","line":248},{"definition":"my","line":252,"name":"$qs","localvar":"my","containerName":"next_result","kind":13},{"line":252,"kind":13,"containerName":"next_result","name":"$qe"},{"line":252,"kind":13,"containerName":"next_result","name":"$hs"},{"line":252,"name":"$he","containerName":"next_result","kind":13},{"containerName":"next_result","kind":13,"name":"$pid","line":252},{"kind":13,"containerName":"next_result","name":"@hsps","line":253},{"line":254,"kind":13,"containerName":"next_result","name":"$qs"},{"line":255,"kind":13,"containerName":"next_result","name":"$qe"},{"name":"$hit_direction","kind":13,"containerName":"next_result","line":256},{"line":256,"name":"$hs","containerName":"next_result","kind":13},{"line":256,"name":"$he","kind":13,"containerName":"next_result"},{"line":257,"name":"$hit_direction","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"$he","line":257},{"line":257,"kind":13,"containerName":"next_result","name":"$hs"},{"name":"$qe","kind":13,"containerName":"next_result","line":259},{"containerName":"next_result","kind":13,"name":"$qs","line":259},{"line":260,"name":"$he","kind":13,"containerName":"next_result"},{"line":260,"name":"$hs","kind":13,"containerName":"next_result"},{"name":"$qe","kind":13,"containerName":"next_result","line":261},{"line":261,"name":"$qs","containerName":"next_result","kind":13},{"definition":"my","line":267,"name":"$i","localvar":"my","containerName":"next_result","kind":13},{"line":267,"containerName":"next_result","kind":13,"name":"$i"},{"line":267,"name":"$i","kind":13,"containerName":"next_result"},{"line":268,"name":"$start","kind":13,"localvar":"my","containerName":"next_result","definition":"my"},{"name":"$string","containerName":"next_result","kind":13,"line":268},{"name":"$alignment","containerName":"next_result","kind":13,"line":269},{"line":269,"name":"$ALIGN_TYPES","containerName":"next_result","kind":13},{"containerName":"next_result","kind":13,"name":"$i","line":269},{"kind":13,"containerName":"next_result","name":"$start","line":269},{"line":269,"name":"$i","containerName":"next_result","kind":13},{"containerName":"next_result","kind":13,"name":"$string","line":271},{"name":"$alignment","kind":13,"containerName":"next_result","line":271},{"name":"$ALIGN_TYPES","containerName":"next_result","kind":13,"line":271},{"line":271,"name":"$i","kind":13,"containerName":"next_result"},{"line":271,"name":"$string","containerName":"next_result","kind":13},{"line":272,"containerName":"next_result","kind":13,"name":"$string"},{"name":"$self","kind":13,"containerName":"next_result","line":273},{"name":"_readline","containerName":"next_result","kind":12,"line":273},{"name":"$alignment","containerName":"next_result","kind":13,"line":277},{"line":278,"kind":13,"containerName":"next_result","name":"$format"},{"line":278,"name":"@hsps","containerName":"next_result","kind":13},{"name":"$format","containerName":"next_result","kind":13,"line":278},{"name":"$self","kind":13,"containerName":"next_result","line":280},{"line":280,"kind":12,"containerName":"next_result","name":"end_element"},{"name":"$self","containerName":"next_result","kind":13,"line":280},{"name":"in_element","containerName":"next_result","kind":12,"line":280},{"containerName":"next_result","kind":13,"name":"$self","line":282},{"line":282,"kind":12,"containerName":"next_result","name":"start_element"},{"line":283,"containerName":"next_result","kind":13,"name":"$self"},{"name":"@hsps","containerName":"next_result","kind":13,"line":283},{"name":"@hsps","containerName":"next_result","kind":13,"line":283},{"line":284,"containerName":"next_result","kind":13,"name":"$alignment"},{"containerName":"next_result","kind":13,"name":"$alignment","line":285},{"line":290,"kind":13,"containerName":"next_result","name":"$alignment"},{"kind":13,"localvar":"my","containerName":"next_result","name":"$hsp_start","line":291,"definition":"my"},{"kind":13,"containerName":"next_result","name":"$hsp_end","line":291},{"line":293,"kind":13,"containerName":"next_result","name":"$self"},{"containerName":"next_result","kind":12,"name":"in_element","line":293},{"name":"$hsp_end","kind":13,"containerName":"next_result","line":295},{"line":295,"name":"$alignment","kind":13,"containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":296},{"name":"$self","containerName":"next_result","kind":13,"line":297},{"name":"$alignment","kind":13,"containerName":"next_result","line":297},{"kind":13,"containerName":"next_result","name":"$hsp_end","line":297},{"name":"$self","containerName":"next_result","kind":13,"line":298},{"line":299,"name":"$self","containerName":"next_result","kind":13},{"kind":13,"containerName":"next_result","name":"$alignment","line":299},{"kind":13,"containerName":"next_result","name":"$hsp_end","line":299},{"line":300,"name":"$self","kind":13,"containerName":"next_result"},{"name":"$alignment","kind":13,"containerName":"next_result","line":300},{"line":300,"containerName":"next_result","kind":13,"name":"$hsp_end"},{"line":301,"kind":13,"containerName":"next_result","name":"$self"},{"line":301,"name":"end_element","kind":12,"containerName":"next_result"},{"line":304,"containerName":"next_result","kind":13,"name":"$alignment"},{"name":"$hsp_start","kind":13,"containerName":"next_result","line":306},{"line":306,"kind":13,"containerName":"next_result","name":"$alignment"},{"containerName":"next_result","kind":13,"name":"$self","line":307},{"line":307,"name":"start_element","kind":12,"containerName":"next_result"},{"kind":13,"containerName":"next_result","name":"$self","line":308},{"line":308,"kind":13,"containerName":"next_result","name":"@hsps"},{"line":308,"name":"@hsps","containerName":"next_result","kind":13},{"name":"$self","containerName":"next_result","kind":13,"line":309},{"containerName":"next_result","kind":13,"name":"$self","line":310},{"containerName":"next_result","kind":13,"name":"$alignment","line":310},{"kind":13,"containerName":"next_result","name":"$hsp_start","line":310},{"name":"$self","kind":13,"containerName":"next_result","line":311},{"line":312,"kind":13,"containerName":"next_result","name":"$self"},{"containerName":"next_result","kind":13,"name":"$alignment","line":312},{"containerName":"next_result","kind":13,"name":"$hsp_start","line":312},{"name":"$self","containerName":"next_result","kind":13,"line":313},{"line":313,"name":"$alignment","containerName":"next_result","kind":13},{"line":313,"kind":13,"containerName":"next_result","name":"$hsp_start"},{"line":320,"name":"$hsp_start","containerName":"next_result","kind":13},{"name":"$alignment","containerName":"next_result","kind":13,"line":320},{"line":321,"name":"$self","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":12,"name":"start_element","line":321},{"name":"$self","kind":13,"containerName":"next_result","line":322},{"line":322,"name":"@hsps","containerName":"next_result","kind":13},{"containerName":"next_result","kind":13,"name":"@hsps","line":322},{"name":"$alignment","kind":13,"containerName":"next_result","line":323},{"line":325,"containerName":"next_result","kind":13,"name":"$self"},{"containerName":"next_result","kind":13,"name":"$self","line":326},{"line":326,"name":"$alignment","kind":13,"containerName":"next_result"},{"name":"$hsp_start","containerName":"next_result","kind":13,"line":326},{"line":327,"name":"$self","containerName":"next_result","kind":13},{"kind":13,"containerName":"next_result","name":"$self","line":328},{"line":328,"name":"$alignment","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"$hsp_start","line":328},{"line":329,"name":"$self","containerName":"next_result","kind":13},{"name":"$alignment","containerName":"next_result","kind":13,"line":329},{"name":"$hsp_start","kind":13,"containerName":"next_result","line":329},{"containerName":"next_result","kind":13,"name":"$self","line":337},{"line":337,"name":"in_element","containerName":"next_result","kind":12},{"name":"$self","containerName":"next_result","kind":13,"line":338},{"line":338,"containerName":"next_result","kind":12,"name":"start_element"},{"name":"$self","containerName":"next_result","kind":13,"line":339},{"kind":13,"containerName":"next_result","name":"@hsps","line":339},{"name":"@hsps","kind":13,"containerName":"next_result","line":339},{"line":340,"name":"$alignment","kind":13,"containerName":"next_result"},{"line":341,"kind":13,"containerName":"next_result","name":"$alignment"},{"line":345,"kind":13,"containerName":"next_result","name":"$self"},{"containerName":"next_result","kind":13,"name":"$alignment","line":346},{"line":347,"name":"$self","kind":13,"containerName":"next_result"},{"line":348,"name":"$self","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"$alignment","line":349},{"line":350,"name":"$self","containerName":"next_result","kind":13},{"line":351,"kind":13,"containerName":"next_result","name":"$self"},{"name":"$self","kind":13,"containerName":"next_result","line":352},{"line":353,"containerName":"next_result","kind":13,"name":"$alignment"},{"name":"$self","containerName":"next_result","kind":13,"line":354},{"line":355,"name":"$self","kind":13,"containerName":"next_result"},{"line":356,"name":"$alignment","kind":13,"containerName":"next_result"},{"kind":13,"containerName":"next_result","name":"$self","line":357},{"line":358,"name":"$alignment","kind":13,"containerName":"next_result"},{"name":"$seentop","containerName":"next_result","kind":13,"line":364},{"line":366,"name":"$self","kind":13,"containerName":"next_result"},{"name":"end_element","kind":12,"containerName":"next_result","line":366},{"line":366,"name":"$self","containerName":"next_result","kind":13},{"name":"in_element","kind":12,"containerName":"next_result","line":366},{"kind":13,"containerName":"next_result","name":"$self","line":368},{"line":368,"name":"in_element","containerName":"next_result","kind":12},{"line":369,"name":"@hsps","kind":13,"containerName":"next_result"},{"kind":13,"containerName":"next_result","name":"$self","line":370},{"line":370,"name":"start_element","kind":12,"containerName":"next_result"},{"definition":"my","localvar":"my","containerName":"next_result","kind":13,"name":"$name","line":371},{"line":371,"containerName":"next_result","kind":13,"name":"$data"},{"line":371,"name":"$_","containerName":"next_result","kind":13},{"line":372,"kind":13,"containerName":"next_result","name":"$self"},{"name":"$name","kind":13,"containerName":"next_result","line":372},{"line":372,"name":"$data","kind":13,"containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":374},{"name":"end_element","containerName":"next_result","kind":12,"line":374},{"containerName":"next_result","kind":13,"name":"$self","line":376},{"line":376,"containerName":"next_result","kind":12,"name":"end_element"},{"kind":13,"containerName":"next_result","name":"$self","line":379},{"containerName":"next_result","kind":12,"name":"element","line":379},{"name":"$DEFAULTFORMAT","containerName":"next_result","kind":13,"line":380},{"line":380,"kind":13,"containerName":"next_result","name":"$format"},{"containerName":"next_result","kind":13,"name":"$format","line":380},{"line":381,"kind":13,"containerName":"next_result","name":"$self"},{"name":"end_element","containerName":"next_result","kind":12,"line":381},{"line":382,"name":"$self","containerName":"next_result","kind":13},{"line":382,"name":"end_document","kind":12,"containerName":"next_result"}]},{"kind":12,"name":"start","line":269},{"line":269,"name":"string","kind":12},{"kind":12,"name":"string","line":271},{"line":277,"name":"Ruler","kind":12},{"line":277,"kind":12,"name":"start"},{"line":284,"name":"Query","kind":12},{"line":284,"name":"start","kind":12},{"line":285,"name":"Sbjct","kind":12},{"kind":12,"name":"start","line":285},{"kind":12,"name":"Mid","line":290},{"line":290,"kind":12,"name":"string"},{"line":295,"name":"Mid","kind":12},{"name":"string","kind":12,"line":295},{"kind":12,"name":"Query","line":297},{"name":"string","kind":12,"line":297},{"kind":12,"name":"Sbjct","line":299},{"kind":12,"name":"string","line":299},{"kind":12,"name":"Mid","line":300},{"kind":12,"name":"string","line":300},{"line":304,"kind":12,"name":"Mid"},{"name":"string","kind":12,"line":304},{"line":306,"name":"Mid","kind":12},{"kind":12,"name":"string","line":306},{"line":310,"name":"Query","kind":12},{"kind":12,"name":"string","line":310},{"name":"Sbjct","kind":12,"line":312},{"line":312,"kind":12,"name":"string"},{"kind":12,"name":"Mid","line":313},{"kind":12,"name":"string","line":313},{"line":320,"kind":12,"name":"Mid"},{"line":320,"kind":12,"name":"string"},{"line":323,"kind":12,"name":"Query"},{"name":"start","kind":12,"line":323},{"line":326,"name":"Query","kind":12},{"kind":12,"name":"string","line":326},{"line":328,"name":"Sbjct","kind":12},{"line":328,"kind":12,"name":"string"},{"name":"Mid","kind":12,"line":329},{"line":329,"kind":12,"name":"string"},{"line":340,"name":"Query","kind":12},{"line":340,"kind":12,"name":"start"},{"line":341,"kind":12,"name":"Sbjct"},{"line":341,"kind":12,"name":"start"},{"line":346,"kind":12,"name":"Query"},{"kind":12,"name":"start","line":346},{"line":349,"kind":12,"name":"Sbjct"},{"line":349,"name":"start","kind":12},{"name":"Query","kind":12,"line":353},{"line":353,"name":"string","kind":12},{"name":"Sbjct","kind":12,"line":356},{"line":356,"name":"string","kind":12},{"kind":12,"name":"Mid","line":358},{"kind":12,"name":"string","line":358},{"name":"start_element","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"start_element","name":"$self","line":399,"definition":"my"},{"line":399,"containerName":"start_element","kind":13,"name":"$data"},{"name":"$nm","containerName":"start_element","localvar":"my","kind":13,"line":401,"definition":"my"},{"line":401,"containerName":"start_element","kind":13,"name":"$data"},{"line":402,"name":"$type","localvar":"my","containerName":"start_element","kind":13,"definition":"my"},{"line":402,"name":"$MODEMAP","containerName":"start_element","kind":13},{"name":"$nm","containerName":"start_element","kind":13,"line":402},{"line":404,"name":"$type","kind":13,"containerName":"start_element"},{"kind":13,"containerName":"start_element","name":"$self","line":405},{"line":405,"name":"_will_handle","kind":12,"containerName":"start_element"},{"line":405,"kind":13,"containerName":"start_element","name":"$type"},{"line":406,"localvar":"my","kind":13,"containerName":"start_element","name":"$func","definition":"my"},{"kind":13,"containerName":"start_element","name":"$type","line":406},{"line":407,"kind":13,"containerName":"start_element","name":"$self"},{"containerName":"start_element","kind":12,"name":"_eventHandler","line":407},{"line":407,"name":"$func","containerName":"start_element","kind":13},{"name":"$data","kind":13,"containerName":"start_element","line":407},{"name":"$self","kind":13,"containerName":"start_element","line":409},{"line":409,"name":"$type","containerName":"start_element","kind":13},{"line":411,"name":"$type","containerName":"start_element","kind":13},{"name":"$self","kind":13,"containerName":"start_element","line":412},{"kind":13,"containerName":"start_element","name":"$self","line":413}],"detail":"($self,$data)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":415},"start":{"character":0,"line":398}},"line":398,"signature":{"parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: sim4.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::sim4\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::sim4 - parser for Sim4 alignments\n\n=head1 SYNOPSIS\n\n  # do not use this module directly, it is a driver for SearchIO\n  use Bio::SearchIO;\n  my $searchio = Bio::SearchIO->new(-file => 'results.sim4',\n                                   -format => 'sim4');\n\n  while ( my $result = $searchio->next_result ) {\n      while ( my $hit = $result->next_hit ) {\n\t  while ( my $hsp = $hit->next_hsp ) {\n              # ...\n\t  }\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis is a driver for the SearchIO system for parsing Sim4.\nhttp://globin.cse.psu.edu/html/docs/sim4.html\n\nCannot parse LAV or 'exon file' formats (A=2 or A=5)\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nLuc Gauthier (lgauthie@hotmail.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::sim4;\n\nuse strict;\nuse vars qw($DEFAULTFORMAT %ALIGN_TYPES\n            %MAPPING %MODEMAP $DEFAULT_WRITER_CLASS);\n\nuse POSIX;\nuse Bio::SearchIO::SearchResultEventBuilder;\n\nuse base qw(Bio::SearchIO);\n\n$DEFAULTFORMAT = 'SIM4';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n%ALIGN_TYPES = (\n    0 => 'Ruler',\n    1 => 'Query', \n    2 => 'Mid', \n    3 => 'Sbjct'\n);\n\n%MODEMAP = (\n    'Sim4Output' => 'result',\n    'Hit'        => 'hit',\n    'Hsp'        => 'hsp'\n);\n\n%MAPPING = (\n    'Hsp_query-from'=>  'HSP-query_start',\n    'Hsp_query-to'  =>  'HSP-query_end',\n    'Hsp_qseq'      =>  'HSP-query_seq',\n    'Hsp_qlength'   =>  'HSP-query_length',\n    'Hsp_querygaps'  => 'HSP-query_gaps',\n    'Hsp_hit-from'  =>  'HSP-hit_start',\n    'Hsp_hit-to'    =>  'HSP-hit_end',\n    'Hsp_hseq'      =>  'HSP-hit_seq',\n    'Hsp_hlength'   =>  'HSP-hit_length',\n    'Hsp_hitgaps'    => 'HSP-hit_gaps',\n    'Hsp_midline'   =>  'HSP-homology_seq',\n    'Hsp_score'     =>  'HSP-score',\n    'Hsp_align-len' =>  'HSP-hsp_length',\n    'Hsp_identity'  =>  'HSP-identical',\n\n    'Hit_id'        => 'HIT-name',\n    'Hit_desc'      => 'HIT-description',\n    'Hit_len'       => 'HIT-length',\n\n    'Sim4Output_program'   => 'RESULT-algorithm_name',\n    'Sim4Output_query-def' => 'RESULT-query_name',\n    'Sim4Output_query-desc'=> 'RESULT-query_description',\n    'Sim4Output_query-len' => 'RESULT-query_length',\n);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::sim4->new();\n Function: Builds a new Bio::SearchIO::sim4 object\n Returns : an instance of Bio::SearchIO::sim4\n Args    :\n\n\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    # Declare/adjust needed variables\n    $self->{'_last_data'} = '';\n    my ($seentop, $qfull, @hsps, %alignment, $format);\n    my $hit_direction = 1;\n\n    # Start document and main element\n    $self->start_document();\n    $self->start_element({'Name' => 'Sim4Output'});\n    my $lastquery = '';\n    # Read output report until EOF\n    while( defined($_ = $self->_readline) ) {       \n        # Skip empty lines, chomp filled ones\n\tnext if( /^\\s+$/); chomp;\n\n        # Make sure sim4 output format is not 2 or 5\n        if (!$seentop) {\n\t    if ( /^\\#:lav/ ) { $format = 2; }\n            elsif ( /^<|>/ ) { $format = 5; }\n            $self->throw(\"Bio::SearchIO::sim4 module cannot parse 'type $format' outputs.\") if $format;\n\t}\n\n        # This line indicates the start of a new hit\n\tif( /^seq1\\s*=\\s*(\\S+),\\s+(\\d+)/ ) {\n\t    my ($nm,$desc) = ($1,$2);\n            # First hit? Adjust some parameters if so\n\t    if ( ! $seentop ) {\n\t        $self->element( {'Name' => 'Sim4Output_query-def', \n\t\t\t\t 'Data' => $nm} );\n\t        $self->element( {'Name' => 'Sim4Output_query-len', \n\t\t\t\t 'Data' => $desc} );\n                $seentop = 1;\n\t    } elsif( $nm ne $lastquery ) {\n\t\t$self->_pushback($_);\n\t\tlast;\n\t    }\n\t    $lastquery = $nm;\n            # A previous HSP may need to be ended\n            $self->end_element({'Name' => 'Hsp'}) if ( $self->in_element('hsp') );\n            # A previous hit exists? End it and reset needed variables\n            if ( $self->in_element('hit') ) {\n\t        foreach (@hsps) {\n                    $self->start_element({'Name' => 'Hsp'});\n                    while (my ($name, $data) = each %$_) {\n                        $self->{'_currentHSP'}{$name} = $data;\n\t\t    }\n\t\t    $self->end_element({'Name' => 'Hsp'});\n                    $self->{'_currentHSP'} = {};\n\t        }\n                $format = 0 if @hsps;\n                @hsps = ();\n                %alignment = ();\n                $qfull = 0;\n                $hit_direction = 1;\n                $self->end_element({'Name' => 'Hit'});\n\t    }\n\n        # This line describes the current hit... so let's start it\n\t} elsif( /^seq2\\s*=\\s*(\\S+)\\s+\\(>?(\\S+)\\s*\\),\\s*(\\d+)/ ) {\n            $self->start_element({'Name' => 'Hit'});\n\t    $self->element( {'Name' => 'Hit_id', 'Data' => $2} );\n\t    $self->element( {'Name' => 'Hit_desc', 'Data' => $1} );\n\t    $self->element( {'Name' => 'Hit_len', 'Data' => $3} );\n\n        # This line may give additional details about query or subject\n\t} elsif( /^>(\\S+)\\s*(.*)?/ ) {\n            # Previous line was query details... this time subject details\n\t    if( $qfull )  {\n                $format = 4 if !$format;\n\t\t$self->element({'Name' => 'Hit_desc', 'Data' => $2});\n            # First line of this type is always query details for a given hit\n\t    } else { \n\t\t$self->element({'Name' => 'Sim4Output_query-desc', 'Data' => $2});\n\t\t$qfull = 1;\n\t    }\n\n        # This line indicates that subject is on reverse strand\n\t} elsif( /^\\(complement\\)/ ) {\n\t    $hit_direction = -1;\n\n        # This line describes the current HSP... so add it to @hsps array\n\t} elsif( /^\\(?(\\d+)\\-(\\d+)\\)?\\s+\\(?(\\d+)\\-(\\d+)\\)?\\s+(\\d+)/ ) {\n\t\tmy ($qs,$qe,$hs,$he,$pid) = ($1,$2,$3,$4,$5);\n                push @hsps, {\n                    'Hsp_query-from' => $qs,\n                    'Hsp_query-to' => $qe,\n                    'Hsp_hit-from' => $hit_direction >= 0 ? $hs : $he,\n                    'Hsp_hit-to' => $hit_direction >= 0 ? $he : $hs,\n                    'Hsp_identity' => 0, #can't determine correctly from raw pct\n                    'Hsp_qlength' => abs($qe - $qs) + 1,\n                    'Hsp_hlength' => abs($he - $hs) + 1,\n                    'Hsp_align-len' => abs($qe - $qs) + 1,\n\t        };\n\n        # This line indicates the start of an alignment block\n        } elsif( /^\\s+(\\d+)\\s/ ) {\n            # Store the current alignment block in a hash\n\t    for( my $i = 0; defined($_) && $i < 4; $i++ ) {\n                my ($start, $string) = /^\\s+(\\d*)\\s(.*)/;\n                $alignment{$ALIGN_TYPES{$i}} = { start => $start, string => $i != 2\n                    ? $string\n                    : (' ' x (length($alignment{$ALIGN_TYPES{$i-1}}{string}) - length($string))) . $string\n                };\n                $_ = $self->_readline();\n\t    }\n\n            # 'Ruler' line indicates the start of a new HSP\n            if ($alignment{Ruler}{start} == 0) {\n                $format = @hsps ? 3 : 1 if !$format;\n                # A previous HSP may need to be ended\n                $self->end_element({'Name' => 'Hsp'}) if ( $self->in_element('hsp') );\n                # Start the new HSP and fill the '_currentHSP' property with available details\n     \t        $self->start_element({'Name' => 'Hsp'});\n                $self->{'_currentHSP'} = @hsps ? shift @hsps : {\n                    'Hsp_query-from' => $alignment{Query}{start},\n                    'Hsp_hit-from' => $alignment{Sbjct}{start},\n     \t        }\n\t    }\n\n            # Midline indicates a boundary between two HSPs\n\t    if ( $alignment{Mid}{string} =~ /<|>/g ) {\n                my ($hsp_start, $hsp_end);\n                # Are we currently in an open HSP?\n    \t        if ( $self->in_element('hsp') ) {\n                    # Find end pos, adjust 'gaps', 'seq' and 'midline' properties... then close HSP\n                    $hsp_end = (pos $alignment{Mid}{string}) - 1;\n                    $self->{'_currentHSP'}{'Hsp_querygaps'} +=\n                        ($self->{'_currentHSP'}{'Hsp_qseq'} .= substr($alignment{Query}{string}, 0, $hsp_end)) =~ s/ /-/g;\n                    $self->{'_currentHSP'}{'Hsp_hitgaps'} +=\n                        ($self->{'_currentHSP'}{'Hsp_hseq'} .= substr($alignment{Sbjct}{string}, 0, $hsp_end)) =~ s/ /-/g;\n                    ($self->{'_currentHSP'}{'Hsp_midline'} .= substr($alignment{Mid}{string}, 0, $hsp_end)) =~ s/-/ /g;\n                    $self->end_element({'Name' => 'Hsp'});\n\n                    # Does a new HSP start in the current alignment block?\n                    if ( $alignment{Mid}{string} =~ /\\|/g ) {\n                        # Find start pos, start new HSP and fill it with available details\n                        $hsp_start = (pos $alignment{Mid}{string}) - 1;\n                        $self->start_element({'Name' => 'Hsp'});\n                        $self->{'_currentHSP'} = @hsps ? shift @hsps : {};\n                        $self->{'_currentHSP'}{'Hsp_querygaps'} +=\n                            ($self->{'_currentHSP'}{'Hsp_qseq'} = substr($alignment{Query}{string}, $hsp_start)) =~ s/ /-/g;\n                        $self->{'_currentHSP'}{'Hsp_hitgaps'} +=\n                            ($self->{'_currentHSP'}{'Hsp_hseq'} = substr($alignment{Sbjct}{string}, $hsp_start)) =~ s/ /-/g;\n                        ($self->{'_currentHSP'}{'Hsp_midline'} = substr($alignment{Mid}{string}, $hsp_start)) =~ s/-/ /g;\n\t\t    }\n\t\t}\n                # No HSP is currently open...\n                else {\n                    # Find start pos, start new HSP and fill it with available\n                    # details then skip to next alignment block\n\t\t    $hsp_start = index($alignment{Mid}{string}, '|');\n\t            $self->start_element({'Name' => 'Hsp'});\n                    $self->{'_currentHSP'} = @hsps ? shift @hsps : {\n                        'Hsp_query-from' => $alignment{Query}{start},\n    \t            };\n                    $self->{'_currentHSP'}{'Hsp_querygaps'} +=\n                        ($self->{'_currentHSP'}{'Hsp_qseq'} = substr($alignment{Query}{string}, $hsp_start)) =~ s/ /-/g;\n                    $self->{'_currentHSP'}{'Hsp_hitgaps'} +=\n                        ($self->{'_currentHSP'}{'Hsp_hseq'} = substr($alignment{Sbjct}{string}, $hsp_start)) =~ s/ /-/g;\n                    ($self->{'_currentHSP'}{'Hsp_midline'} = substr($alignment{Mid}{string}, $hsp_start)) =~ s/-/ /g;\n                    next;\n\t\t}\n\t    }\n            # Current alignment block does not contain HSPs boundary\n            else {\n                # Start a new HSP if none is currently open\n\t        # (Happens if last boundary finished at the very end of previous block)\n\t        if ( !$self->in_element('hsp') ) {\n     \t            $self->start_element({'Name' => 'Hsp'});\n                    $self->{'_currentHSP'} = @hsps ? shift @hsps : {\n                        'Hsp_query-from' => $alignment{Query}{start},\n                        'Hsp_hit-from' => $alignment{Sbjct}{start},\n     \t            }\n\t\t}\n                # Adjust details of the current HSP\n                $self->{'_currentHSP'}{'Hsp_query-from'} ||= \n\t\t    $alignment{Query}{start} - \n\t\t    length($self->{'_currentHSP'}{'Hsp_qseq'} || '');\n                $self->{'_currentHSP'}{'Hsp_hit-from'} ||= \n\t\t    $alignment{Sbjct}{start} - \n\t\t    length($self->{'_currentHSP'}{'Hsp_hseq'} || '');\n                $self->{'_currentHSP'}{'Hsp_querygaps'} +=\n                    ($self->{'_currentHSP'}{'Hsp_qseq'} .= \n\t\t     $alignment{Query}{string}) =~ s/ /-/g;\n                $self->{'_currentHSP'}{'Hsp_hitgaps'} +=\n                    ($self->{'_currentHSP'}{'Hsp_hseq'} .= \n\t\t     $alignment{Sbjct}{string}) =~ s/ /-/g;\n                ($self->{'_currentHSP'}{'Hsp_midline'} .= \n\t\t $alignment{Mid}{string}) =~ s/-/ /g;\n\t    }\n\t}\n    }\n\n    # We are done reading the sim4 report, end everything and return\n    if( $seentop ) {\n        # end HSP if needed\n        $self->end_element({'Name' => 'Hsp'}) if ( $self->in_element('hsp') );\n        # end Hit if needed\n        if ( $self->in_element('hit') ) {\n            foreach (@hsps) {\n                $self->start_element({'Name' => 'Hsp'});\n                while (my ($name, $data) = each %$_) {\n                    $self->{'_currentHSP'}{$name} = $data;\n    \t        }\n    \t        $self->end_element({'Name' => 'Hsp'});\n            }\n            $self->end_element({'Name' => 'Hit'});\n\t}\n        # adjust result's algorithm name, end output and return\n        $self->element({'Name' => 'Sim4Output_program',\n                        'Data' => $DEFAULTFORMAT . ' (A=' . (defined $format ? $format : '?') . ')'});\n\t$self->end_element({'Name' => 'Sim4Output'});\n\treturn $self->end_document();\n    } \n    return;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'","label":"start_element($self,$data)"}},{"line":430,"range":{"end":{"line":450,"character":9999},"start":{"character":0,"line":430}},"kind":12,"signature":{"label":"end_element($self,$data)","parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: sim4.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::sim4\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::sim4 - parser for Sim4 alignments\n\n=head1 SYNOPSIS\n\n  # do not use this module directly, it is a driver for SearchIO\n  use Bio::SearchIO;\n  my $searchio = Bio::SearchIO->new(-file => 'results.sim4',\n                                   -format => 'sim4');\n\n  while ( my $result = $searchio->next_result ) {\n      while ( my $hit = $result->next_hit ) {\n\t  while ( my $hsp = $hit->next_hsp ) {\n              # ...\n\t  }\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis is a driver for the SearchIO system for parsing Sim4.\nhttp://globin.cse.psu.edu/html/docs/sim4.html\n\nCannot parse LAV or 'exon file' formats (A=2 or A=5)\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nLuc Gauthier (lgauthie@hotmail.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::sim4;\n\nuse strict;\nuse vars qw($DEFAULTFORMAT %ALIGN_TYPES\n            %MAPPING %MODEMAP $DEFAULT_WRITER_CLASS);\n\nuse POSIX;\nuse Bio::SearchIO::SearchResultEventBuilder;\n\nuse base qw(Bio::SearchIO);\n\n$DEFAULTFORMAT = 'SIM4';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n%ALIGN_TYPES = (\n    0 => 'Ruler',\n    1 => 'Query', \n    2 => 'Mid', \n    3 => 'Sbjct'\n);\n\n%MODEMAP = (\n    'Sim4Output' => 'result',\n    'Hit'        => 'hit',\n    'Hsp'        => 'hsp'\n);\n\n%MAPPING = (\n    'Hsp_query-from'=>  'HSP-query_start',\n    'Hsp_query-to'  =>  'HSP-query_end',\n    'Hsp_qseq'      =>  'HSP-query_seq',\n    'Hsp_qlength'   =>  'HSP-query_length',\n    'Hsp_querygaps'  => 'HSP-query_gaps',\n    'Hsp_hit-from'  =>  'HSP-hit_start',\n    'Hsp_hit-to'    =>  'HSP-hit_end',\n    'Hsp_hseq'      =>  'HSP-hit_seq',\n    'Hsp_hlength'   =>  'HSP-hit_length',\n    'Hsp_hitgaps'    => 'HSP-hit_gaps',\n    'Hsp_midline'   =>  'HSP-homology_seq',\n    'Hsp_score'     =>  'HSP-score',\n    'Hsp_align-len' =>  'HSP-hsp_length',\n    'Hsp_identity'  =>  'HSP-identical',\n\n    'Hit_id'        => 'HIT-name',\n    'Hit_desc'      => 'HIT-description',\n    'Hit_len'       => 'HIT-length',\n\n    'Sim4Output_program'   => 'RESULT-algorithm_name',\n    'Sim4Output_query-def' => 'RESULT-query_name',\n    'Sim4Output_query-desc'=> 'RESULT-query_description',\n    'Sim4Output_query-len' => 'RESULT-query_length',\n);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::sim4->new();\n Function: Builds a new Bio::SearchIO::sim4 object\n Returns : an instance of Bio::SearchIO::sim4\n Args    :\n\n\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    # Declare/adjust needed variables\n    $self->{'_last_data'} = '';\n    my ($seentop, $qfull, @hsps, %alignment, $format);\n    my $hit_direction = 1;\n\n    # Start document and main element\n    $self->start_document();\n    $self->start_element({'Name' => 'Sim4Output'});\n    my $lastquery = '';\n    # Read output report until EOF\n    while( defined($_ = $self->_readline) ) {       \n        # Skip empty lines, chomp filled ones\n\tnext if( /^\\s+$/); chomp;\n\n        # Make sure sim4 output format is not 2 or 5\n        if (!$seentop) {\n\t    if ( /^\\#:lav/ ) { $format = 2; }\n            elsif ( /^<|>/ ) { $format = 5; }\n            $self->throw(\"Bio::SearchIO::sim4 module cannot parse 'type $format' outputs.\") if $format;\n\t}\n\n        # This line indicates the start of a new hit\n\tif( /^seq1\\s*=\\s*(\\S+),\\s+(\\d+)/ ) {\n\t    my ($nm,$desc) = ($1,$2);\n            # First hit? Adjust some parameters if so\n\t    if ( ! $seentop ) {\n\t        $self->element( {'Name' => 'Sim4Output_query-def', \n\t\t\t\t 'Data' => $nm} );\n\t        $self->element( {'Name' => 'Sim4Output_query-len', \n\t\t\t\t 'Data' => $desc} );\n                $seentop = 1;\n\t    } elsif( $nm ne $lastquery ) {\n\t\t$self->_pushback($_);\n\t\tlast;\n\t    }\n\t    $lastquery = $nm;\n            # A previous HSP may need to be ended\n            $self->end_element({'Name' => 'Hsp'}) if ( $self->in_element('hsp') );\n            # A previous hit exists? End it and reset needed variables\n            if ( $self->in_element('hit') ) {\n\t        foreach (@hsps) {\n                    $self->start_element({'Name' => 'Hsp'});\n                    while (my ($name, $data) = each %$_) {\n                        $self->{'_currentHSP'}{$name} = $data;\n\t\t    }\n\t\t    $self->end_element({'Name' => 'Hsp'});\n                    $self->{'_currentHSP'} = {};\n\t        }\n                $format = 0 if @hsps;\n                @hsps = ();\n                %alignment = ();\n                $qfull = 0;\n                $hit_direction = 1;\n                $self->end_element({'Name' => 'Hit'});\n\t    }\n\n        # This line describes the current hit... so let's start it\n\t} elsif( /^seq2\\s*=\\s*(\\S+)\\s+\\(>?(\\S+)\\s*\\),\\s*(\\d+)/ ) {\n            $self->start_element({'Name' => 'Hit'});\n\t    $self->element( {'Name' => 'Hit_id', 'Data' => $2} );\n\t    $self->element( {'Name' => 'Hit_desc', 'Data' => $1} );\n\t    $self->element( {'Name' => 'Hit_len', 'Data' => $3} );\n\n        # This line may give additional details about query or subject\n\t} elsif( /^>(\\S+)\\s*(.*)?/ ) {\n            # Previous line was query details... this time subject details\n\t    if( $qfull )  {\n                $format = 4 if !$format;\n\t\t$self->element({'Name' => 'Hit_desc', 'Data' => $2});\n            # First line of this type is always query details for a given hit\n\t    } else { \n\t\t$self->element({'Name' => 'Sim4Output_query-desc', 'Data' => $2});\n\t\t$qfull = 1;\n\t    }\n\n        # This line indicates that subject is on reverse strand\n\t} elsif( /^\\(complement\\)/ ) {\n\t    $hit_direction = -1;\n\n        # This line describes the current HSP... so add it to @hsps array\n\t} elsif( /^\\(?(\\d+)\\-(\\d+)\\)?\\s+\\(?(\\d+)\\-(\\d+)\\)?\\s+(\\d+)/ ) {\n\t\tmy ($qs,$qe,$hs,$he,$pid) = ($1,$2,$3,$4,$5);\n                push @hsps, {\n                    'Hsp_query-from' => $qs,\n                    'Hsp_query-to' => $qe,\n                    'Hsp_hit-from' => $hit_direction >= 0 ? $hs : $he,\n                    'Hsp_hit-to' => $hit_direction >= 0 ? $he : $hs,\n                    'Hsp_identity' => 0, #can't determine correctly from raw pct\n                    'Hsp_qlength' => abs($qe - $qs) + 1,\n                    'Hsp_hlength' => abs($he - $hs) + 1,\n                    'Hsp_align-len' => abs($qe - $qs) + 1,\n\t        };\n\n        # This line indicates the start of an alignment block\n        } elsif( /^\\s+(\\d+)\\s/ ) {\n            # Store the current alignment block in a hash\n\t    for( my $i = 0; defined($_) && $i < 4; $i++ ) {\n                my ($start, $string) = /^\\s+(\\d*)\\s(.*)/;\n                $alignment{$ALIGN_TYPES{$i}} = { start => $start, string => $i != 2\n                    ? $string\n                    : (' ' x (length($alignment{$ALIGN_TYPES{$i-1}}{string}) - length($string))) . $string\n                };\n                $_ = $self->_readline();\n\t    }\n\n            # 'Ruler' line indicates the start of a new HSP\n            if ($alignment{Ruler}{start} == 0) {\n                $format = @hsps ? 3 : 1 if !$format;\n                # A previous HSP may need to be ended\n                $self->end_element({'Name' => 'Hsp'}) if ( $self->in_element('hsp') );\n                # Start the new HSP and fill the '_currentHSP' property with available details\n     \t        $self->start_element({'Name' => 'Hsp'});\n                $self->{'_currentHSP'} = @hsps ? shift @hsps : {\n                    'Hsp_query-from' => $alignment{Query}{start},\n                    'Hsp_hit-from' => $alignment{Sbjct}{start},\n     \t        }\n\t    }\n\n            # Midline indicates a boundary between two HSPs\n\t    if ( $alignment{Mid}{string} =~ /<|>/g ) {\n                my ($hsp_start, $hsp_end);\n                # Are we currently in an open HSP?\n    \t        if ( $self->in_element('hsp') ) {\n                    # Find end pos, adjust 'gaps', 'seq' and 'midline' properties... then close HSP\n                    $hsp_end = (pos $alignment{Mid}{string}) - 1;\n                    $self->{'_currentHSP'}{'Hsp_querygaps'} +=\n                        ($self->{'_currentHSP'}{'Hsp_qseq'} .= substr($alignment{Query}{string}, 0, $hsp_end)) =~ s/ /-/g;\n                    $self->{'_currentHSP'}{'Hsp_hitgaps'} +=\n                        ($self->{'_currentHSP'}{'Hsp_hseq'} .= substr($alignment{Sbjct}{string}, 0, $hsp_end)) =~ s/ /-/g;\n                    ($self->{'_currentHSP'}{'Hsp_midline'} .= substr($alignment{Mid}{string}, 0, $hsp_end)) =~ s/-/ /g;\n                    $self->end_element({'Name' => 'Hsp'});\n\n                    # Does a new HSP start in the current alignment block?\n                    if ( $alignment{Mid}{string} =~ /\\|/g ) {\n                        # Find start pos, start new HSP and fill it with available details\n                        $hsp_start = (pos $alignment{Mid}{string}) - 1;\n                        $self->start_element({'Name' => 'Hsp'});\n                        $self->{'_currentHSP'} = @hsps ? shift @hsps : {};\n                        $self->{'_currentHSP'}{'Hsp_querygaps'} +=\n                            ($self->{'_currentHSP'}{'Hsp_qseq'} = substr($alignment{Query}{string}, $hsp_start)) =~ s/ /-/g;\n                        $self->{'_currentHSP'}{'Hsp_hitgaps'} +=\n                            ($self->{'_currentHSP'}{'Hsp_hseq'} = substr($alignment{Sbjct}{string}, $hsp_start)) =~ s/ /-/g;\n                        ($self->{'_currentHSP'}{'Hsp_midline'} = substr($alignment{Mid}{string}, $hsp_start)) =~ s/-/ /g;\n\t\t    }\n\t\t}\n                # No HSP is currently open...\n                else {\n                    # Find start pos, start new HSP and fill it with available\n                    # details then skip to next alignment block\n\t\t    $hsp_start = index($alignment{Mid}{string}, '|');\n\t            $self->start_element({'Name' => 'Hsp'});\n                    $self->{'_currentHSP'} = @hsps ? shift @hsps : {\n                        'Hsp_query-from' => $alignment{Query}{start},\n    \t            };\n                    $self->{'_currentHSP'}{'Hsp_querygaps'} +=\n                        ($self->{'_currentHSP'}{'Hsp_qseq'} = substr($alignment{Query}{string}, $hsp_start)) =~ s/ /-/g;\n                    $self->{'_currentHSP'}{'Hsp_hitgaps'} +=\n                        ($self->{'_currentHSP'}{'Hsp_hseq'} = substr($alignment{Sbjct}{string}, $hsp_start)) =~ s/ /-/g;\n                    ($self->{'_currentHSP'}{'Hsp_midline'} = substr($alignment{Mid}{string}, $hsp_start)) =~ s/-/ /g;\n                    next;\n\t\t}\n\t    }\n            # Current alignment block does not contain HSPs boundary\n            else {\n                # Start a new HSP if none is currently open\n\t        # (Happens if last boundary finished at the very end of previous block)\n\t        if ( !$self->in_element('hsp') ) {\n     \t            $self->start_element({'Name' => 'Hsp'});\n                    $self->{'_currentHSP'} = @hsps ? shift @hsps : {\n                        'Hsp_query-from' => $alignment{Query}{start},\n                        'Hsp_hit-from' => $alignment{Sbjct}{start},\n     \t            }\n\t\t}\n                # Adjust details of the current HSP\n                $self->{'_currentHSP'}{'Hsp_query-from'} ||= \n\t\t    $alignment{Query}{start} - \n\t\t    length($self->{'_currentHSP'}{'Hsp_qseq'} || '');\n                $self->{'_currentHSP'}{'Hsp_hit-from'} ||= \n\t\t    $alignment{Sbjct}{start} - \n\t\t    length($self->{'_currentHSP'}{'Hsp_hseq'} || '');\n                $self->{'_currentHSP'}{'Hsp_querygaps'} +=\n                    ($self->{'_currentHSP'}{'Hsp_qseq'} .= \n\t\t     $alignment{Query}{string}) =~ s/ /-/g;\n                $self->{'_currentHSP'}{'Hsp_hitgaps'} +=\n                    ($self->{'_currentHSP'}{'Hsp_hseq'} .= \n\t\t     $alignment{Sbjct}{string}) =~ s/ /-/g;\n                ($self->{'_currentHSP'}{'Hsp_midline'} .= \n\t\t $alignment{Mid}{string}) =~ s/-/ /g;\n\t    }\n\t}\n    }\n\n    # We are done reading the sim4 report, end everything and return\n    if( $seentop ) {\n        # end HSP if needed\n        $self->end_element({'Name' => 'Hsp'}) if ( $self->in_element('hsp') );\n        # end Hit if needed\n        if ( $self->in_element('hit') ) {\n            foreach (@hsps) {\n                $self->start_element({'Name' => 'Hsp'});\n                while (my ($name, $data) = each %$_) {\n                    $self->{'_currentHSP'}{$name} = $data;\n    \t        }\n    \t        $self->end_element({'Name' => 'Hsp'});\n            }\n            $self->end_element({'Name' => 'Hit'});\n\t}\n        # adjust result's algorithm name, end output and return\n        $self->element({'Name' => 'Sim4Output_program',\n                        'Data' => $DEFAULTFORMAT . ' (A=' . (defined $format ? $format : '?') . ')'});\n\t$self->end_element({'Name' => 'Sim4Output'});\n\treturn $self->end_document();\n    } \n    return;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n   # we currently don't care about attributes\n   my $nm = $data->{'Name'};\n   my $type = $MODEMAP{$nm};\n\n   if( $type ) {\n       if( $self->_will_handle($type) ) {\n\t   my $func = sprintf(\"start_%s\",lc $type);\n\t   $self->_eventHandler->$func($data->{'Attributes'});\n       }\n       unshift @{$self->{'_elements'}}, $type;\n\n       if($type eq 'result') {\n\t   $self->{'_values'} = {};\n\t   $self->{'_result'}= undef;\n       }\n   }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'"},"children":[{"definition":"my","line":431,"name":"$self","containerName":"end_element","localvar":"my","kind":13},{"line":431,"name":"$data","kind":13,"containerName":"end_element"},{"containerName":"end_element","localvar":"my","kind":13,"name":"$nm","line":432,"definition":"my"},{"name":"$data","kind":13,"containerName":"end_element","line":432},{"name":"$type","kind":13,"localvar":"my","containerName":"end_element","line":433,"definition":"my"},{"containerName":"end_element","kind":13,"name":"$MODEMAP","line":433},{"containerName":"end_element","kind":13,"name":"$nm","line":433},{"definition":"my","localvar":"my","containerName":"end_element","kind":13,"name":"$rc","line":434},{"name":"$nm","containerName":"end_element","kind":13,"line":436},{"line":437,"containerName":"end_element","kind":13,"name":"$self"},{"line":438,"kind":13,"containerName":"end_element","name":"$self"},{"line":439,"containerName":"end_element","kind":13,"name":"$self"},{"line":439,"containerName":"end_element","kind":13,"name":"$self"},{"containerName":"end_element","kind":13,"name":"$self","line":439},{"line":440,"name":"$self","containerName":"end_element","kind":13},{"kind":13,"containerName":"end_element","name":"$self","line":441},{"line":441,"containerName":"end_element","kind":13,"name":"$self"},{"line":441,"containerName":"end_element","kind":13,"name":"$self"},{"line":442,"containerName":"end_element","kind":13,"name":"$self"},{"line":443,"kind":13,"containerName":"end_element","name":"$self"},{"line":444,"name":"$self","kind":13,"containerName":"end_element"},{"name":"$self","kind":13,"containerName":"end_element","line":444},{"name":"$self","containerName":"end_element","kind":13,"line":444},{"kind":13,"containerName":"end_element","name":"$self","line":445},{"line":445,"name":"$self","kind":13,"containerName":"end_element"},{"kind":13,"containerName":"end_element","name":"$self","line":445},{"line":446,"name":"$self","kind":13,"containerName":"end_element"},{"kind":13,"containerName":"end_element","name":"$self","line":446},{"name":"$self","containerName":"end_element","kind":13,"line":446},{"containerName":"end_element","kind":13,"name":"$self","line":447},{"line":447,"containerName":"end_element","kind":13,"name":"$self"},{"containerName":"end_element","kind":13,"name":"$self","line":447},{"line":448,"name":"$self","kind":13,"containerName":"end_element"},{"name":"$self","containerName":"end_element","kind":13,"line":449},{"line":449,"name":"element","containerName":"end_element","kind":12},{"line":449,"name":"$self","kind":13,"containerName":"end_element"}],"containerName":"main::","name":"end_element","definition":"sub","detail":"($self,$data)"},{"name":"$type","kind":13,"containerName":null,"line":453},{"kind":13,"containerName":null,"name":"%MODEMAP","line":453},{"kind":13,"containerName":null,"name":"%nm","line":453},{"line":454,"containerName":null,"kind":13,"name":"$self"},{"line":454,"containerName":"main::","kind":12,"name":"_will_handle"},{"line":454,"kind":13,"containerName":null,"name":"%type"},{"definition":"my","line":455,"name":"$func","containerName":null,"localvar":"my","kind":13},{"kind":13,"containerName":null,"name":"$type","line":455},{"name":"$rc","kind":13,"containerName":null,"line":456},{"name":"$self","containerName":null,"kind":13,"line":456},{"line":456,"containerName":"main::","kind":12,"name":"_eventHandler"},{"line":456,"name":"$func","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"%self","line":456},{"line":457,"name":"%self","kind":13,"containerName":null},{"line":459,"containerName":null,"kind":13,"name":"%self"},{"name":"%MAPPING","containerName":null,"kind":13,"line":461},{"kind":13,"containerName":null,"name":"%nm","line":461},{"line":463,"name":"%MAPPING","containerName":null,"kind":13},{"line":463,"kind":13,"containerName":null,"name":"%nm"},{"definition":"my","line":464,"localvar":"my","kind":13,"containerName":null,"name":"$key"},{"line":464,"name":"%MAPPING","kind":13,"containerName":null},{"line":464,"containerName":null,"kind":13,"name":"@nm"},{"name":"%self","containerName":null,"kind":13,"line":465},{"line":465,"containerName":null,"kind":13,"name":"%key"},{"name":"%MAPPING","containerName":null,"kind":13,"line":465},{"line":465,"name":"%nm","containerName":null,"kind":13},{"name":"$key","kind":13,"containerName":null,"line":465},{"line":465,"kind":13,"containerName":null,"name":"%self"},{"kind":13,"containerName":null,"name":"%self","line":467},{"name":"%MAPPING","kind":13,"containerName":null,"line":467},{"line":467,"containerName":null,"kind":13,"name":"$nm"},{"containerName":null,"kind":13,"name":"%self","line":467},{"line":470,"name":"$self","containerName":null,"kind":13},{"line":470,"containerName":"main::","kind":12,"name":"debug"},{"line":472,"containerName":null,"kind":13,"name":"%self"},{"name":"%self","containerName":null,"kind":13,"line":474},{"name":"$rc","kind":13,"containerName":null,"line":474},{"line":474,"containerName":null,"kind":13,"name":"$type"},{"name":"$type","containerName":null,"kind":13,"line":474},{"containerName":null,"kind":13,"name":"$rc","line":475},{"containerName":"main::","name":"element","children":[{"definition":"my","localvar":"my","containerName":"element","kind":13,"name":"$self","line":490},{"line":490,"containerName":"element","kind":13,"name":"$data"},{"line":491,"name":"$self","kind":13,"containerName":"element"},{"name":"start_element","kind":12,"containerName":"element","line":491},{"line":491,"name":"$data","kind":13,"containerName":"element"},{"kind":13,"containerName":"element","name":"$self","line":492},{"line":492,"name":"characters","kind":12,"containerName":"element"},{"line":492,"containerName":"element","kind":13,"name":"$data"},{"line":493,"name":"$self","containerName":"element","kind":13},{"containerName":"element","kind":12,"name":"end_element","line":493},{"name":"$data","containerName":"element","kind":13,"line":493}],"detail":"($self,$data)","definition":"sub","range":{"end":{"character":9999,"line":494},"start":{"line":489,"character":0}},"kind":12,"line":489,"signature":{"parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: sim4.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::sim4\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::sim4 - parser for Sim4 alignments\n\n=head1 SYNOPSIS\n\n  # do not use this module directly, it is a driver for SearchIO\n  use Bio::SearchIO;\n  my $searchio = Bio::SearchIO->new(-file => 'results.sim4',\n                                   -format => 'sim4');\n\n  while ( my $result = $searchio->next_result ) {\n      while ( my $hit = $result->next_hit ) {\n\t  while ( my $hsp = $hit->next_hsp ) {\n              # ...\n\t  }\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis is a driver for the SearchIO system for parsing Sim4.\nhttp://globin.cse.psu.edu/html/docs/sim4.html\n\nCannot parse LAV or 'exon file' formats (A=2 or A=5)\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nLuc Gauthier (lgauthie@hotmail.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::sim4;\n\nuse strict;\nuse vars qw($DEFAULTFORMAT %ALIGN_TYPES\n            %MAPPING %MODEMAP $DEFAULT_WRITER_CLASS);\n\nuse POSIX;\nuse Bio::SearchIO::SearchResultEventBuilder;\n\nuse base qw(Bio::SearchIO);\n\n$DEFAULTFORMAT = 'SIM4';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n%ALIGN_TYPES = (\n    0 => 'Ruler',\n    1 => 'Query', \n    2 => 'Mid', \n    3 => 'Sbjct'\n);\n\n%MODEMAP = (\n    'Sim4Output' => 'result',\n    'Hit'        => 'hit',\n    'Hsp'        => 'hsp'\n);\n\n%MAPPING = (\n    'Hsp_query-from'=>  'HSP-query_start',\n    'Hsp_query-to'  =>  'HSP-query_end',\n    'Hsp_qseq'      =>  'HSP-query_seq',\n    'Hsp_qlength'   =>  'HSP-query_length',\n    'Hsp_querygaps'  => 'HSP-query_gaps',\n    'Hsp_hit-from'  =>  'HSP-hit_start',\n    'Hsp_hit-to'    =>  'HSP-hit_end',\n    'Hsp_hseq'      =>  'HSP-hit_seq',\n    'Hsp_hlength'   =>  'HSP-hit_length',\n    'Hsp_hitgaps'    => 'HSP-hit_gaps',\n    'Hsp_midline'   =>  'HSP-homology_seq',\n    'Hsp_score'     =>  'HSP-score',\n    'Hsp_align-len' =>  'HSP-hsp_length',\n    'Hsp_identity'  =>  'HSP-identical',\n\n    'Hit_id'        => 'HIT-name',\n    'Hit_desc'      => 'HIT-description',\n    'Hit_len'       => 'HIT-length',\n\n    'Sim4Output_program'   => 'RESULT-algorithm_name',\n    'Sim4Output_query-def' => 'RESULT-query_name',\n    'Sim4Output_query-desc'=> 'RESULT-query_description',\n    'Sim4Output_query-len' => 'RESULT-query_length',\n);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::sim4->new();\n Function: Builds a new Bio::SearchIO::sim4 object\n Returns : an instance of Bio::SearchIO::sim4\n Args    :\n\n\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    # Declare/adjust needed variables\n    $self->{'_last_data'} = '';\n    my ($seentop, $qfull, @hsps, %alignment, $format);\n    my $hit_direction = 1;\n\n    # Start document and main element\n    $self->start_document();\n    $self->start_element({'Name' => 'Sim4Output'});\n    my $lastquery = '';\n    # Read output report until EOF\n    while( defined($_ = $self->_readline) ) {       \n        # Skip empty lines, chomp filled ones\n\tnext if( /^\\s+$/); chomp;\n\n        # Make sure sim4 output format is not 2 or 5\n        if (!$seentop) {\n\t    if ( /^\\#:lav/ ) { $format = 2; }\n            elsif ( /^<|>/ ) { $format = 5; }\n            $self->throw(\"Bio::SearchIO::sim4 module cannot parse 'type $format' outputs.\") if $format;\n\t}\n\n        # This line indicates the start of a new hit\n\tif( /^seq1\\s*=\\s*(\\S+),\\s+(\\d+)/ ) {\n\t    my ($nm,$desc) = ($1,$2);\n            # First hit? Adjust some parameters if so\n\t    if ( ! $seentop ) {\n\t        $self->element( {'Name' => 'Sim4Output_query-def', \n\t\t\t\t 'Data' => $nm} );\n\t        $self->element( {'Name' => 'Sim4Output_query-len', \n\t\t\t\t 'Data' => $desc} );\n                $seentop = 1;\n\t    } elsif( $nm ne $lastquery ) {\n\t\t$self->_pushback($_);\n\t\tlast;\n\t    }\n\t    $lastquery = $nm;\n            # A previous HSP may need to be ended\n            $self->end_element({'Name' => 'Hsp'}) if ( $self->in_element('hsp') );\n            # A previous hit exists? End it and reset needed variables\n            if ( $self->in_element('hit') ) {\n\t        foreach (@hsps) {\n                    $self->start_element({'Name' => 'Hsp'});\n                    while (my ($name, $data) = each %$_) {\n                        $self->{'_currentHSP'}{$name} = $data;\n\t\t    }\n\t\t    $self->end_element({'Name' => 'Hsp'});\n                    $self->{'_currentHSP'} = {};\n\t        }\n                $format = 0 if @hsps;\n                @hsps = ();\n                %alignment = ();\n                $qfull = 0;\n                $hit_direction = 1;\n                $self->end_element({'Name' => 'Hit'});\n\t    }\n\n        # This line describes the current hit... so let's start it\n\t} elsif( /^seq2\\s*=\\s*(\\S+)\\s+\\(>?(\\S+)\\s*\\),\\s*(\\d+)/ ) {\n            $self->start_element({'Name' => 'Hit'});\n\t    $self->element( {'Name' => 'Hit_id', 'Data' => $2} );\n\t    $self->element( {'Name' => 'Hit_desc', 'Data' => $1} );\n\t    $self->element( {'Name' => 'Hit_len', 'Data' => $3} );\n\n        # This line may give additional details about query or subject\n\t} elsif( /^>(\\S+)\\s*(.*)?/ ) {\n            # Previous line was query details... this time subject details\n\t    if( $qfull )  {\n                $format = 4 if !$format;\n\t\t$self->element({'Name' => 'Hit_desc', 'Data' => $2});\n            # First line of this type is always query details for a given hit\n\t    } else { \n\t\t$self->element({'Name' => 'Sim4Output_query-desc', 'Data' => $2});\n\t\t$qfull = 1;\n\t    }\n\n        # This line indicates that subject is on reverse strand\n\t} elsif( /^\\(complement\\)/ ) {\n\t    $hit_direction = -1;\n\n        # This line describes the current HSP... so add it to @hsps array\n\t} elsif( /^\\(?(\\d+)\\-(\\d+)\\)?\\s+\\(?(\\d+)\\-(\\d+)\\)?\\s+(\\d+)/ ) {\n\t\tmy ($qs,$qe,$hs,$he,$pid) = ($1,$2,$3,$4,$5);\n                push @hsps, {\n                    'Hsp_query-from' => $qs,\n                    'Hsp_query-to' => $qe,\n                    'Hsp_hit-from' => $hit_direction >= 0 ? $hs : $he,\n                    'Hsp_hit-to' => $hit_direction >= 0 ? $he : $hs,\n                    'Hsp_identity' => 0, #can't determine correctly from raw pct\n                    'Hsp_qlength' => abs($qe - $qs) + 1,\n                    'Hsp_hlength' => abs($he - $hs) + 1,\n                    'Hsp_align-len' => abs($qe - $qs) + 1,\n\t        };\n\n        # This line indicates the start of an alignment block\n        } elsif( /^\\s+(\\d+)\\s/ ) {\n            # Store the current alignment block in a hash\n\t    for( my $i = 0; defined($_) && $i < 4; $i++ ) {\n                my ($start, $string) = /^\\s+(\\d*)\\s(.*)/;\n                $alignment{$ALIGN_TYPES{$i}} = { start => $start, string => $i != 2\n                    ? $string\n                    : (' ' x (length($alignment{$ALIGN_TYPES{$i-1}}{string}) - length($string))) . $string\n                };\n                $_ = $self->_readline();\n\t    }\n\n            # 'Ruler' line indicates the start of a new HSP\n            if ($alignment{Ruler}{start} == 0) {\n                $format = @hsps ? 3 : 1 if !$format;\n                # A previous HSP may need to be ended\n                $self->end_element({'Name' => 'Hsp'}) if ( $self->in_element('hsp') );\n                # Start the new HSP and fill the '_currentHSP' property with available details\n     \t        $self->start_element({'Name' => 'Hsp'});\n                $self->{'_currentHSP'} = @hsps ? shift @hsps : {\n                    'Hsp_query-from' => $alignment{Query}{start},\n                    'Hsp_hit-from' => $alignment{Sbjct}{start},\n     \t        }\n\t    }\n\n            # Midline indicates a boundary between two HSPs\n\t    if ( $alignment{Mid}{string} =~ /<|>/g ) {\n                my ($hsp_start, $hsp_end);\n                # Are we currently in an open HSP?\n    \t        if ( $self->in_element('hsp') ) {\n                    # Find end pos, adjust 'gaps', 'seq' and 'midline' properties... then close HSP\n                    $hsp_end = (pos $alignment{Mid}{string}) - 1;\n                    $self->{'_currentHSP'}{'Hsp_querygaps'} +=\n                        ($self->{'_currentHSP'}{'Hsp_qseq'} .= substr($alignment{Query}{string}, 0, $hsp_end)) =~ s/ /-/g;\n                    $self->{'_currentHSP'}{'Hsp_hitgaps'} +=\n                        ($self->{'_currentHSP'}{'Hsp_hseq'} .= substr($alignment{Sbjct}{string}, 0, $hsp_end)) =~ s/ /-/g;\n                    ($self->{'_currentHSP'}{'Hsp_midline'} .= substr($alignment{Mid}{string}, 0, $hsp_end)) =~ s/-/ /g;\n                    $self->end_element({'Name' => 'Hsp'});\n\n                    # Does a new HSP start in the current alignment block?\n                    if ( $alignment{Mid}{string} =~ /\\|/g ) {\n                        # Find start pos, start new HSP and fill it with available details\n                        $hsp_start = (pos $alignment{Mid}{string}) - 1;\n                        $self->start_element({'Name' => 'Hsp'});\n                        $self->{'_currentHSP'} = @hsps ? shift @hsps : {};\n                        $self->{'_currentHSP'}{'Hsp_querygaps'} +=\n                            ($self->{'_currentHSP'}{'Hsp_qseq'} = substr($alignment{Query}{string}, $hsp_start)) =~ s/ /-/g;\n                        $self->{'_currentHSP'}{'Hsp_hitgaps'} +=\n                            ($self->{'_currentHSP'}{'Hsp_hseq'} = substr($alignment{Sbjct}{string}, $hsp_start)) =~ s/ /-/g;\n                        ($self->{'_currentHSP'}{'Hsp_midline'} = substr($alignment{Mid}{string}, $hsp_start)) =~ s/-/ /g;\n\t\t    }\n\t\t}\n                # No HSP is currently open...\n                else {\n                    # Find start pos, start new HSP and fill it with available\n                    # details then skip to next alignment block\n\t\t    $hsp_start = index($alignment{Mid}{string}, '|');\n\t            $self->start_element({'Name' => 'Hsp'});\n                    $self->{'_currentHSP'} = @hsps ? shift @hsps : {\n                        'Hsp_query-from' => $alignment{Query}{start},\n    \t            };\n                    $self->{'_currentHSP'}{'Hsp_querygaps'} +=\n                        ($self->{'_currentHSP'}{'Hsp_qseq'} = substr($alignment{Query}{string}, $hsp_start)) =~ s/ /-/g;\n                    $self->{'_currentHSP'}{'Hsp_hitgaps'} +=\n                        ($self->{'_currentHSP'}{'Hsp_hseq'} = substr($alignment{Sbjct}{string}, $hsp_start)) =~ s/ /-/g;\n                    ($self->{'_currentHSP'}{'Hsp_midline'} = substr($alignment{Mid}{string}, $hsp_start)) =~ s/-/ /g;\n                    next;\n\t\t}\n\t    }\n            # Current alignment block does not contain HSPs boundary\n            else {\n                # Start a new HSP if none is currently open\n\t        # (Happens if last boundary finished at the very end of previous block)\n\t        if ( !$self->in_element('hsp') ) {\n     \t            $self->start_element({'Name' => 'Hsp'});\n                    $self->{'_currentHSP'} = @hsps ? shift @hsps : {\n                        'Hsp_query-from' => $alignment{Query}{start},\n                        'Hsp_hit-from' => $alignment{Sbjct}{start},\n     \t            }\n\t\t}\n                # Adjust details of the current HSP\n                $self->{'_currentHSP'}{'Hsp_query-from'} ||= \n\t\t    $alignment{Query}{start} - \n\t\t    length($self->{'_currentHSP'}{'Hsp_qseq'} || '');\n                $self->{'_currentHSP'}{'Hsp_hit-from'} ||= \n\t\t    $alignment{Sbjct}{start} - \n\t\t    length($self->{'_currentHSP'}{'Hsp_hseq'} || '');\n                $self->{'_currentHSP'}{'Hsp_querygaps'} +=\n                    ($self->{'_currentHSP'}{'Hsp_qseq'} .= \n\t\t     $alignment{Query}{string}) =~ s/ /-/g;\n                $self->{'_currentHSP'}{'Hsp_hitgaps'} +=\n                    ($self->{'_currentHSP'}{'Hsp_hseq'} .= \n\t\t     $alignment{Sbjct}{string}) =~ s/ /-/g;\n                ($self->{'_currentHSP'}{'Hsp_midline'} .= \n\t\t $alignment{Mid}{string}) =~ s/-/ /g;\n\t    }\n\t}\n    }\n\n    # We are done reading the sim4 report, end everything and return\n    if( $seentop ) {\n        # end HSP if needed\n        $self->end_element({'Name' => 'Hsp'}) if ( $self->in_element('hsp') );\n        # end Hit if needed\n        if ( $self->in_element('hit') ) {\n            foreach (@hsps) {\n                $self->start_element({'Name' => 'Hsp'});\n                while (my ($name, $data) = each %$_) {\n                    $self->{'_currentHSP'}{$name} = $data;\n    \t        }\n    \t        $self->end_element({'Name' => 'Hsp'});\n            }\n            $self->end_element({'Name' => 'Hit'});\n\t}\n        # adjust result's algorithm name, end output and return\n        $self->element({'Name' => 'Sim4Output_program',\n                        'Data' => $DEFAULTFORMAT . ' (A=' . (defined $format ? $format : '?') . ')'});\n\t$self->end_element({'Name' => 'Sim4Output'});\n\treturn $self->end_document();\n    } \n    return;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n   # we currently don't care about attributes\n   my $nm = $data->{'Name'};\n   my $type = $MODEMAP{$nm};\n\n   if( $type ) {\n       if( $self->_will_handle($type) ) {\n\t   my $func = sprintf(\"start_%s\",lc $type);\n\t   $self->_eventHandler->$func($data->{'Attributes'});\n       }\n       unshift @{$self->{'_elements'}}, $type;\n\n       if($type eq 'result') {\n\t   $self->{'_values'} = {};\n\t   $self->{'_result'}= undef;\n       }\n   }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n    \n    if( $nm eq 'Hsp' ) {\n        $self->{'_currentHSP'}{'Hsp_midline'} ||= '';\n\t$self->{'_currentHSP'}{'Hsp_query-to'} ||=\n            $self->{'_currentHSP'}{'Hsp_query-from'} + length($self->{'_currentHSP'}{'Hsp_qseq'}) - 1 - $self->{'_currentHSP'}{'Hsp_querygaps'};\n        $self->{'_currentHSP'}{'Hsp_hit-to'} ||=\n            $self->{'_currentHSP'}{'Hsp_hit-from'} + length($self->{'_currentHSP'}{'Hsp_hseq'}) - 1 - $self->{'_currentHSP'}{'Hsp_hitgaps'};\n        $self->{'_currentHSP'}{'Hsp_identity'} ||= \n\t    ($self->{'_currentHSP'}{'Hsp_midline'} =~ tr/\\|//);\n        $self->{'_currentHSP'}{'Hsp_qlength'} ||= abs($self->{'_currentHSP'}{'Hsp_query-to'} - $self->{'_currentHSP'}{'Hsp_query-from'}) + 1;\n        $self->{'_currentHSP'}{'Hsp_hlength'} ||= abs($self->{'_currentHSP'}{'Hsp_hit-to'} - $self->{'_currentHSP'}{'Hsp_hit-from'}) + 1;\n        $self->{'_currentHSP'}{'Hsp_align-len'} ||= abs($self->{'_currentHSP'}{'Hsp_query-to'} - $self->{'_currentHSP'}{'Hsp_query-from'}) + 1;\n        $self->{'_currentHSP'}{'Hsp_score'} ||= int(100 * ($self->{'_currentHSP'}{'Hsp_identity'} / $self->{'_currentHSP'}{'Hsp_align-len'}));\n        foreach (keys %{$self->{'_currentHSP'}}) {\n            $self->element({'Name' => $_, 'Data' => delete ${$self->{'_currentHSP'}}{$_}});\n\t}\n    }\n\n    if( $type = $MODEMAP{$nm} ) {\n\tif( $self->_will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) {\n\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else {\n\t$self->debug( \"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at\n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'","label":"element($self,$data)"}},{"signature":{"parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: sim4.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::sim4\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::sim4 - parser for Sim4 alignments\n\n=head1 SYNOPSIS\n\n  # do not use this module directly, it is a driver for SearchIO\n  use Bio::SearchIO;\n  my $searchio = Bio::SearchIO->new(-file => 'results.sim4',\n                                   -format => 'sim4');\n\n  while ( my $result = $searchio->next_result ) {\n      while ( my $hit = $result->next_hit ) {\n\t  while ( my $hsp = $hit->next_hsp ) {\n              # ...\n\t  }\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis is a driver for the SearchIO system for parsing Sim4.\nhttp://globin.cse.psu.edu/html/docs/sim4.html\n\nCannot parse LAV or 'exon file' formats (A=2 or A=5)\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nLuc Gauthier (lgauthie@hotmail.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::sim4;\n\nuse strict;\nuse vars qw($DEFAULTFORMAT %ALIGN_TYPES\n            %MAPPING %MODEMAP $DEFAULT_WRITER_CLASS);\n\nuse POSIX;\nuse Bio::SearchIO::SearchResultEventBuilder;\n\nuse base qw(Bio::SearchIO);\n\n$DEFAULTFORMAT = 'SIM4';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n%ALIGN_TYPES = (\n    0 => 'Ruler',\n    1 => 'Query', \n    2 => 'Mid', \n    3 => 'Sbjct'\n);\n\n%MODEMAP = (\n    'Sim4Output' => 'result',\n    'Hit'        => 'hit',\n    'Hsp'        => 'hsp'\n);\n\n%MAPPING = (\n    'Hsp_query-from'=>  'HSP-query_start',\n    'Hsp_query-to'  =>  'HSP-query_end',\n    'Hsp_qseq'      =>  'HSP-query_seq',\n    'Hsp_qlength'   =>  'HSP-query_length',\n    'Hsp_querygaps'  => 'HSP-query_gaps',\n    'Hsp_hit-from'  =>  'HSP-hit_start',\n    'Hsp_hit-to'    =>  'HSP-hit_end',\n    'Hsp_hseq'      =>  'HSP-hit_seq',\n    'Hsp_hlength'   =>  'HSP-hit_length',\n    'Hsp_hitgaps'    => 'HSP-hit_gaps',\n    'Hsp_midline'   =>  'HSP-homology_seq',\n    'Hsp_score'     =>  'HSP-score',\n    'Hsp_align-len' =>  'HSP-hsp_length',\n    'Hsp_identity'  =>  'HSP-identical',\n\n    'Hit_id'        => 'HIT-name',\n    'Hit_desc'      => 'HIT-description',\n    'Hit_len'       => 'HIT-length',\n\n    'Sim4Output_program'   => 'RESULT-algorithm_name',\n    'Sim4Output_query-def' => 'RESULT-query_name',\n    'Sim4Output_query-desc'=> 'RESULT-query_description',\n    'Sim4Output_query-len' => 'RESULT-query_length',\n);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::sim4->new();\n Function: Builds a new Bio::SearchIO::sim4 object\n Returns : an instance of Bio::SearchIO::sim4\n Args    :\n\n\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    # Declare/adjust needed variables\n    $self->{'_last_data'} = '';\n    my ($seentop, $qfull, @hsps, %alignment, $format);\n    my $hit_direction = 1;\n\n    # Start document and main element\n    $self->start_document();\n    $self->start_element({'Name' => 'Sim4Output'});\n    my $lastquery = '';\n    # Read output report until EOF\n    while( defined($_ = $self->_readline) ) {       \n        # Skip empty lines, chomp filled ones\n\tnext if( /^\\s+$/); chomp;\n\n        # Make sure sim4 output format is not 2 or 5\n        if (!$seentop) {\n\t    if ( /^\\#:lav/ ) { $format = 2; }\n            elsif ( /^<|>/ ) { $format = 5; }\n            $self->throw(\"Bio::SearchIO::sim4 module cannot parse 'type $format' outputs.\") if $format;\n\t}\n\n        # This line indicates the start of a new hit\n\tif( /^seq1\\s*=\\s*(\\S+),\\s+(\\d+)/ ) {\n\t    my ($nm,$desc) = ($1,$2);\n            # First hit? Adjust some parameters if so\n\t    if ( ! $seentop ) {\n\t        $self->element( {'Name' => 'Sim4Output_query-def', \n\t\t\t\t 'Data' => $nm} );\n\t        $self->element( {'Name' => 'Sim4Output_query-len', \n\t\t\t\t 'Data' => $desc} );\n                $seentop = 1;\n\t    } elsif( $nm ne $lastquery ) {\n\t\t$self->_pushback($_);\n\t\tlast;\n\t    }\n\t    $lastquery = $nm;\n            # A previous HSP may need to be ended\n            $self->end_element({'Name' => 'Hsp'}) if ( $self->in_element('hsp') );\n            # A previous hit exists? End it and reset needed variables\n            if ( $self->in_element('hit') ) {\n\t        foreach (@hsps) {\n                    $self->start_element({'Name' => 'Hsp'});\n                    while (my ($name, $data) = each %$_) {\n                        $self->{'_currentHSP'}{$name} = $data;\n\t\t    }\n\t\t    $self->end_element({'Name' => 'Hsp'});\n                    $self->{'_currentHSP'} = {};\n\t        }\n                $format = 0 if @hsps;\n                @hsps = ();\n                %alignment = ();\n                $qfull = 0;\n                $hit_direction = 1;\n                $self->end_element({'Name' => 'Hit'});\n\t    }\n\n        # This line describes the current hit... so let's start it\n\t} elsif( /^seq2\\s*=\\s*(\\S+)\\s+\\(>?(\\S+)\\s*\\),\\s*(\\d+)/ ) {\n            $self->start_element({'Name' => 'Hit'});\n\t    $self->element( {'Name' => 'Hit_id', 'Data' => $2} );\n\t    $self->element( {'Name' => 'Hit_desc', 'Data' => $1} );\n\t    $self->element( {'Name' => 'Hit_len', 'Data' => $3} );\n\n        # This line may give additional details about query or subject\n\t} elsif( /^>(\\S+)\\s*(.*)?/ ) {\n            # Previous line was query details... this time subject details\n\t    if( $qfull )  {\n                $format = 4 if !$format;\n\t\t$self->element({'Name' => 'Hit_desc', 'Data' => $2});\n            # First line of this type is always query details for a given hit\n\t    } else { \n\t\t$self->element({'Name' => 'Sim4Output_query-desc', 'Data' => $2});\n\t\t$qfull = 1;\n\t    }\n\n        # This line indicates that subject is on reverse strand\n\t} elsif( /^\\(complement\\)/ ) {\n\t    $hit_direction = -1;\n\n        # This line describes the current HSP... so add it to @hsps array\n\t} elsif( /^\\(?(\\d+)\\-(\\d+)\\)?\\s+\\(?(\\d+)\\-(\\d+)\\)?\\s+(\\d+)/ ) {\n\t\tmy ($qs,$qe,$hs,$he,$pid) = ($1,$2,$3,$4,$5);\n                push @hsps, {\n                    'Hsp_query-from' => $qs,\n                    'Hsp_query-to' => $qe,\n                    'Hsp_hit-from' => $hit_direction >= 0 ? $hs : $he,\n                    'Hsp_hit-to' => $hit_direction >= 0 ? $he : $hs,\n                    'Hsp_identity' => 0, #can't determine correctly from raw pct\n                    'Hsp_qlength' => abs($qe - $qs) + 1,\n                    'Hsp_hlength' => abs($he - $hs) + 1,\n                    'Hsp_align-len' => abs($qe - $qs) + 1,\n\t        };\n\n        # This line indicates the start of an alignment block\n        } elsif( /^\\s+(\\d+)\\s/ ) {\n            # Store the current alignment block in a hash\n\t    for( my $i = 0; defined($_) && $i < 4; $i++ ) {\n                my ($start, $string) = /^\\s+(\\d*)\\s(.*)/;\n                $alignment{$ALIGN_TYPES{$i}} = { start => $start, string => $i != 2\n                    ? $string\n                    : (' ' x (length($alignment{$ALIGN_TYPES{$i-1}}{string}) - length($string))) . $string\n                };\n                $_ = $self->_readline();\n\t    }\n\n            # 'Ruler' line indicates the start of a new HSP\n            if ($alignment{Ruler}{start} == 0) {\n                $format = @hsps ? 3 : 1 if !$format;\n                # A previous HSP may need to be ended\n                $self->end_element({'Name' => 'Hsp'}) if ( $self->in_element('hsp') );\n                # Start the new HSP and fill the '_currentHSP' property with available details\n     \t        $self->start_element({'Name' => 'Hsp'});\n                $self->{'_currentHSP'} = @hsps ? shift @hsps : {\n                    'Hsp_query-from' => $alignment{Query}{start},\n                    'Hsp_hit-from' => $alignment{Sbjct}{start},\n     \t        }\n\t    }\n\n            # Midline indicates a boundary between two HSPs\n\t    if ( $alignment{Mid}{string} =~ /<|>/g ) {\n                my ($hsp_start, $hsp_end);\n                # Are we currently in an open HSP?\n    \t        if ( $self->in_element('hsp') ) {\n                    # Find end pos, adjust 'gaps', 'seq' and 'midline' properties... then close HSP\n                    $hsp_end = (pos $alignment{Mid}{string}) - 1;\n                    $self->{'_currentHSP'}{'Hsp_querygaps'} +=\n                        ($self->{'_currentHSP'}{'Hsp_qseq'} .= substr($alignment{Query}{string}, 0, $hsp_end)) =~ s/ /-/g;\n                    $self->{'_currentHSP'}{'Hsp_hitgaps'} +=\n                        ($self->{'_currentHSP'}{'Hsp_hseq'} .= substr($alignment{Sbjct}{string}, 0, $hsp_end)) =~ s/ /-/g;\n                    ($self->{'_currentHSP'}{'Hsp_midline'} .= substr($alignment{Mid}{string}, 0, $hsp_end)) =~ s/-/ /g;\n                    $self->end_element({'Name' => 'Hsp'});\n\n                    # Does a new HSP start in the current alignment block?\n                    if ( $alignment{Mid}{string} =~ /\\|/g ) {\n                        # Find start pos, start new HSP and fill it with available details\n                        $hsp_start = (pos $alignment{Mid}{string}) - 1;\n                        $self->start_element({'Name' => 'Hsp'});\n                        $self->{'_currentHSP'} = @hsps ? shift @hsps : {};\n                        $self->{'_currentHSP'}{'Hsp_querygaps'} +=\n                            ($self->{'_currentHSP'}{'Hsp_qseq'} = substr($alignment{Query}{string}, $hsp_start)) =~ s/ /-/g;\n                        $self->{'_currentHSP'}{'Hsp_hitgaps'} +=\n                            ($self->{'_currentHSP'}{'Hsp_hseq'} = substr($alignment{Sbjct}{string}, $hsp_start)) =~ s/ /-/g;\n                        ($self->{'_currentHSP'}{'Hsp_midline'} = substr($alignment{Mid}{string}, $hsp_start)) =~ s/-/ /g;\n\t\t    }\n\t\t}\n                # No HSP is currently open...\n                else {\n                    # Find start pos, start new HSP and fill it with available\n                    # details then skip to next alignment block\n\t\t    $hsp_start = index($alignment{Mid}{string}, '|');\n\t            $self->start_element({'Name' => 'Hsp'});\n                    $self->{'_currentHSP'} = @hsps ? shift @hsps : {\n                        'Hsp_query-from' => $alignment{Query}{start},\n    \t            };\n                    $self->{'_currentHSP'}{'Hsp_querygaps'} +=\n                        ($self->{'_currentHSP'}{'Hsp_qseq'} = substr($alignment{Query}{string}, $hsp_start)) =~ s/ /-/g;\n                    $self->{'_currentHSP'}{'Hsp_hitgaps'} +=\n                        ($self->{'_currentHSP'}{'Hsp_hseq'} = substr($alignment{Sbjct}{string}, $hsp_start)) =~ s/ /-/g;\n                    ($self->{'_currentHSP'}{'Hsp_midline'} = substr($alignment{Mid}{string}, $hsp_start)) =~ s/-/ /g;\n                    next;\n\t\t}\n\t    }\n            # Current alignment block does not contain HSPs boundary\n            else {\n                # Start a new HSP if none is currently open\n\t        # (Happens if last boundary finished at the very end of previous block)\n\t        if ( !$self->in_element('hsp') ) {\n     \t            $self->start_element({'Name' => 'Hsp'});\n                    $self->{'_currentHSP'} = @hsps ? shift @hsps : {\n                        'Hsp_query-from' => $alignment{Query}{start},\n                        'Hsp_hit-from' => $alignment{Sbjct}{start},\n     \t            }\n\t\t}\n                # Adjust details of the current HSP\n                $self->{'_currentHSP'}{'Hsp_query-from'} ||= \n\t\t    $alignment{Query}{start} - \n\t\t    length($self->{'_currentHSP'}{'Hsp_qseq'} || '');\n                $self->{'_currentHSP'}{'Hsp_hit-from'} ||= \n\t\t    $alignment{Sbjct}{start} - \n\t\t    length($self->{'_currentHSP'}{'Hsp_hseq'} || '');\n                $self->{'_currentHSP'}{'Hsp_querygaps'} +=\n                    ($self->{'_currentHSP'}{'Hsp_qseq'} .= \n\t\t     $alignment{Query}{string}) =~ s/ /-/g;\n                $self->{'_currentHSP'}{'Hsp_hitgaps'} +=\n                    ($self->{'_currentHSP'}{'Hsp_hseq'} .= \n\t\t     $alignment{Sbjct}{string}) =~ s/ /-/g;\n                ($self->{'_currentHSP'}{'Hsp_midline'} .= \n\t\t $alignment{Mid}{string}) =~ s/-/ /g;\n\t    }\n\t}\n    }\n\n    # We are done reading the sim4 report, end everything and return\n    if( $seentop ) {\n        # end HSP if needed\n        $self->end_element({'Name' => 'Hsp'}) if ( $self->in_element('hsp') );\n        # end Hit if needed\n        if ( $self->in_element('hit') ) {\n            foreach (@hsps) {\n                $self->start_element({'Name' => 'Hsp'});\n                while (my ($name, $data) = each %$_) {\n                    $self->{'_currentHSP'}{$name} = $data;\n    \t        }\n    \t        $self->end_element({'Name' => 'Hsp'});\n            }\n            $self->end_element({'Name' => 'Hit'});\n\t}\n        # adjust result's algorithm name, end output and return\n        $self->element({'Name' => 'Sim4Output_program',\n                        'Data' => $DEFAULTFORMAT . ' (A=' . (defined $format ? $format : '?') . ')'});\n\t$self->end_element({'Name' => 'Sim4Output'});\n\treturn $self->end_document();\n    } \n    return;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n   # we currently don't care about attributes\n   my $nm = $data->{'Name'};\n   my $type = $MODEMAP{$nm};\n\n   if( $type ) {\n       if( $self->_will_handle($type) ) {\n\t   my $func = sprintf(\"start_%s\",lc $type);\n\t   $self->_eventHandler->$func($data->{'Attributes'});\n       }\n       unshift @{$self->{'_elements'}}, $type;\n\n       if($type eq 'result') {\n\t   $self->{'_values'} = {};\n\t   $self->{'_result'}= undef;\n       }\n   }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n    \n    if( $nm eq 'Hsp' ) {\n        $self->{'_currentHSP'}{'Hsp_midline'} ||= '';\n\t$self->{'_currentHSP'}{'Hsp_query-to'} ||=\n            $self->{'_currentHSP'}{'Hsp_query-from'} + length($self->{'_currentHSP'}{'Hsp_qseq'}) - 1 - $self->{'_currentHSP'}{'Hsp_querygaps'};\n        $self->{'_currentHSP'}{'Hsp_hit-to'} ||=\n            $self->{'_currentHSP'}{'Hsp_hit-from'} + length($self->{'_currentHSP'}{'Hsp_hseq'}) - 1 - $self->{'_currentHSP'}{'Hsp_hitgaps'};\n        $self->{'_currentHSP'}{'Hsp_identity'} ||= \n\t    ($self->{'_currentHSP'}{'Hsp_midline'} =~ tr/\\|//);\n        $self->{'_currentHSP'}{'Hsp_qlength'} ||= abs($self->{'_currentHSP'}{'Hsp_query-to'} - $self->{'_currentHSP'}{'Hsp_query-from'}) + 1;\n        $self->{'_currentHSP'}{'Hsp_hlength'} ||= abs($self->{'_currentHSP'}{'Hsp_hit-to'} - $self->{'_currentHSP'}{'Hsp_hit-from'}) + 1;\n        $self->{'_currentHSP'}{'Hsp_align-len'} ||= abs($self->{'_currentHSP'}{'Hsp_query-to'} - $self->{'_currentHSP'}{'Hsp_query-from'}) + 1;\n        $self->{'_currentHSP'}{'Hsp_score'} ||= int(100 * ($self->{'_currentHSP'}{'Hsp_identity'} / $self->{'_currentHSP'}{'Hsp_align-len'}));\n        foreach (keys %{$self->{'_currentHSP'}}) {\n            $self->element({'Name' => $_, 'Data' => delete ${$self->{'_currentHSP'}}{$_}});\n\t}\n    }\n\n    if( $type = $MODEMAP{$nm} ) {\n\tif( $self->_will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) {\n\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else {\n\t$self->debug( \"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at\n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string","label":"characters($self,$data)"},"range":{"end":{"character":9999,"line":517},"start":{"line":507,"character":0}},"kind":12,"line":507,"detail":"($self,$data)","definition":"sub","name":"characters","containerName":"main::","children":[{"containerName":"characters","localvar":"my","kind":13,"name":"$self","line":508,"definition":"my"},{"name":"$data","kind":13,"containerName":"characters","line":508},{"kind":13,"containerName":"characters","name":"$data","line":509},{"line":509,"containerName":"characters","kind":13,"name":"$data"},{"kind":13,"containerName":"characters","name":"$self","line":511},{"kind":12,"containerName":"characters","name":"in_element","line":511},{"line":512,"kind":13,"containerName":"characters","name":"$data"},{"name":"$self","containerName":"characters","kind":13,"line":513},{"containerName":"characters","kind":13,"name":"$data","line":513},{"line":513,"kind":13,"containerName":"characters","name":"$data"},{"line":516,"kind":13,"containerName":"characters","name":"$self"},{"kind":13,"containerName":"characters","name":"$data","line":516}]},{"range":{"start":{"character":0,"line":532},"end":{"character":9999,"line":536}},"kind":12,"line":532,"signature":{"documentation":"1;\n# $Id: sim4.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::sim4\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::sim4 - parser for Sim4 alignments\n\n=head1 SYNOPSIS\n\n  # do not use this module directly, it is a driver for SearchIO\n  use Bio::SearchIO;\n  my $searchio = Bio::SearchIO->new(-file => 'results.sim4',\n                                   -format => 'sim4');\n\n  while ( my $result = $searchio->next_result ) {\n      while ( my $hit = $result->next_hit ) {\n\t  while ( my $hsp = $hit->next_hsp ) {\n              # ...\n\t  }\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis is a driver for the SearchIO system for parsing Sim4.\nhttp://globin.cse.psu.edu/html/docs/sim4.html\n\nCannot parse LAV or 'exon file' formats (A=2 or A=5)\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nLuc Gauthier (lgauthie@hotmail.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::sim4;\n\nuse strict;\nuse vars qw($DEFAULTFORMAT %ALIGN_TYPES\n            %MAPPING %MODEMAP $DEFAULT_WRITER_CLASS);\n\nuse POSIX;\nuse Bio::SearchIO::SearchResultEventBuilder;\n\nuse base qw(Bio::SearchIO);\n\n$DEFAULTFORMAT = 'SIM4';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n%ALIGN_TYPES = (\n    0 => 'Ruler',\n    1 => 'Query', \n    2 => 'Mid', \n    3 => 'Sbjct'\n);\n\n%MODEMAP = (\n    'Sim4Output' => 'result',\n    'Hit'        => 'hit',\n    'Hsp'        => 'hsp'\n);\n\n%MAPPING = (\n    'Hsp_query-from'=>  'HSP-query_start',\n    'Hsp_query-to'  =>  'HSP-query_end',\n    'Hsp_qseq'      =>  'HSP-query_seq',\n    'Hsp_qlength'   =>  'HSP-query_length',\n    'Hsp_querygaps'  => 'HSP-query_gaps',\n    'Hsp_hit-from'  =>  'HSP-hit_start',\n    'Hsp_hit-to'    =>  'HSP-hit_end',\n    'Hsp_hseq'      =>  'HSP-hit_seq',\n    'Hsp_hlength'   =>  'HSP-hit_length',\n    'Hsp_hitgaps'    => 'HSP-hit_gaps',\n    'Hsp_midline'   =>  'HSP-homology_seq',\n    'Hsp_score'     =>  'HSP-score',\n    'Hsp_align-len' =>  'HSP-hsp_length',\n    'Hsp_identity'  =>  'HSP-identical',\n\n    'Hit_id'        => 'HIT-name',\n    'Hit_desc'      => 'HIT-description',\n    'Hit_len'       => 'HIT-length',\n\n    'Sim4Output_program'   => 'RESULT-algorithm_name',\n    'Sim4Output_query-def' => 'RESULT-query_name',\n    'Sim4Output_query-desc'=> 'RESULT-query_description',\n    'Sim4Output_query-len' => 'RESULT-query_length',\n);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::sim4->new();\n Function: Builds a new Bio::SearchIO::sim4 object\n Returns : an instance of Bio::SearchIO::sim4\n Args    :\n\n\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    # Declare/adjust needed variables\n    $self->{'_last_data'} = '';\n    my ($seentop, $qfull, @hsps, %alignment, $format);\n    my $hit_direction = 1;\n\n    # Start document and main element\n    $self->start_document();\n    $self->start_element({'Name' => 'Sim4Output'});\n    my $lastquery = '';\n    # Read output report until EOF\n    while( defined($_ = $self->_readline) ) {       \n        # Skip empty lines, chomp filled ones\n\tnext if( /^\\s+$/); chomp;\n\n        # Make sure sim4 output format is not 2 or 5\n        if (!$seentop) {\n\t    if ( /^\\#:lav/ ) { $format = 2; }\n            elsif ( /^<|>/ ) { $format = 5; }\n            $self->throw(\"Bio::SearchIO::sim4 module cannot parse 'type $format' outputs.\") if $format;\n\t}\n\n        # This line indicates the start of a new hit\n\tif( /^seq1\\s*=\\s*(\\S+),\\s+(\\d+)/ ) {\n\t    my ($nm,$desc) = ($1,$2);\n            # First hit? Adjust some parameters if so\n\t    if ( ! $seentop ) {\n\t        $self->element( {'Name' => 'Sim4Output_query-def', \n\t\t\t\t 'Data' => $nm} );\n\t        $self->element( {'Name' => 'Sim4Output_query-len', \n\t\t\t\t 'Data' => $desc} );\n                $seentop = 1;\n\t    } elsif( $nm ne $lastquery ) {\n\t\t$self->_pushback($_);\n\t\tlast;\n\t    }\n\t    $lastquery = $nm;\n            # A previous HSP may need to be ended\n            $self->end_element({'Name' => 'Hsp'}) if ( $self->in_element('hsp') );\n            # A previous hit exists? End it and reset needed variables\n            if ( $self->in_element('hit') ) {\n\t        foreach (@hsps) {\n                    $self->start_element({'Name' => 'Hsp'});\n                    while (my ($name, $data) = each %$_) {\n                        $self->{'_currentHSP'}{$name} = $data;\n\t\t    }\n\t\t    $self->end_element({'Name' => 'Hsp'});\n                    $self->{'_currentHSP'} = {};\n\t        }\n                $format = 0 if @hsps;\n                @hsps = ();\n                %alignment = ();\n                $qfull = 0;\n                $hit_direction = 1;\n                $self->end_element({'Name' => 'Hit'});\n\t    }\n\n        # This line describes the current hit... so let's start it\n\t} elsif( /^seq2\\s*=\\s*(\\S+)\\s+\\(>?(\\S+)\\s*\\),\\s*(\\d+)/ ) {\n            $self->start_element({'Name' => 'Hit'});\n\t    $self->element( {'Name' => 'Hit_id', 'Data' => $2} );\n\t    $self->element( {'Name' => 'Hit_desc', 'Data' => $1} );\n\t    $self->element( {'Name' => 'Hit_len', 'Data' => $3} );\n\n        # This line may give additional details about query or subject\n\t} elsif( /^>(\\S+)\\s*(.*)?/ ) {\n            # Previous line was query details... this time subject details\n\t    if( $qfull )  {\n                $format = 4 if !$format;\n\t\t$self->element({'Name' => 'Hit_desc', 'Data' => $2});\n            # First line of this type is always query details for a given hit\n\t    } else { \n\t\t$self->element({'Name' => 'Sim4Output_query-desc', 'Data' => $2});\n\t\t$qfull = 1;\n\t    }\n\n        # This line indicates that subject is on reverse strand\n\t} elsif( /^\\(complement\\)/ ) {\n\t    $hit_direction = -1;\n\n        # This line describes the current HSP... so add it to @hsps array\n\t} elsif( /^\\(?(\\d+)\\-(\\d+)\\)?\\s+\\(?(\\d+)\\-(\\d+)\\)?\\s+(\\d+)/ ) {\n\t\tmy ($qs,$qe,$hs,$he,$pid) = ($1,$2,$3,$4,$5);\n                push @hsps, {\n                    'Hsp_query-from' => $qs,\n                    'Hsp_query-to' => $qe,\n                    'Hsp_hit-from' => $hit_direction >= 0 ? $hs : $he,\n                    'Hsp_hit-to' => $hit_direction >= 0 ? $he : $hs,\n                    'Hsp_identity' => 0, #can't determine correctly from raw pct\n                    'Hsp_qlength' => abs($qe - $qs) + 1,\n                    'Hsp_hlength' => abs($he - $hs) + 1,\n                    'Hsp_align-len' => abs($qe - $qs) + 1,\n\t        };\n\n        # This line indicates the start of an alignment block\n        } elsif( /^\\s+(\\d+)\\s/ ) {\n            # Store the current alignment block in a hash\n\t    for( my $i = 0; defined($_) && $i < 4; $i++ ) {\n                my ($start, $string) = /^\\s+(\\d*)\\s(.*)/;\n                $alignment{$ALIGN_TYPES{$i}} = { start => $start, string => $i != 2\n                    ? $string\n                    : (' ' x (length($alignment{$ALIGN_TYPES{$i-1}}{string}) - length($string))) . $string\n                };\n                $_ = $self->_readline();\n\t    }\n\n            # 'Ruler' line indicates the start of a new HSP\n            if ($alignment{Ruler}{start} == 0) {\n                $format = @hsps ? 3 : 1 if !$format;\n                # A previous HSP may need to be ended\n                $self->end_element({'Name' => 'Hsp'}) if ( $self->in_element('hsp') );\n                # Start the new HSP and fill the '_currentHSP' property with available details\n     \t        $self->start_element({'Name' => 'Hsp'});\n                $self->{'_currentHSP'} = @hsps ? shift @hsps : {\n                    'Hsp_query-from' => $alignment{Query}{start},\n                    'Hsp_hit-from' => $alignment{Sbjct}{start},\n     \t        }\n\t    }\n\n            # Midline indicates a boundary between two HSPs\n\t    if ( $alignment{Mid}{string} =~ /<|>/g ) {\n                my ($hsp_start, $hsp_end);\n                # Are we currently in an open HSP?\n    \t        if ( $self->in_element('hsp') ) {\n                    # Find end pos, adjust 'gaps', 'seq' and 'midline' properties... then close HSP\n                    $hsp_end = (pos $alignment{Mid}{string}) - 1;\n                    $self->{'_currentHSP'}{'Hsp_querygaps'} +=\n                        ($self->{'_currentHSP'}{'Hsp_qseq'} .= substr($alignment{Query}{string}, 0, $hsp_end)) =~ s/ /-/g;\n                    $self->{'_currentHSP'}{'Hsp_hitgaps'} +=\n                        ($self->{'_currentHSP'}{'Hsp_hseq'} .= substr($alignment{Sbjct}{string}, 0, $hsp_end)) =~ s/ /-/g;\n                    ($self->{'_currentHSP'}{'Hsp_midline'} .= substr($alignment{Mid}{string}, 0, $hsp_end)) =~ s/-/ /g;\n                    $self->end_element({'Name' => 'Hsp'});\n\n                    # Does a new HSP start in the current alignment block?\n                    if ( $alignment{Mid}{string} =~ /\\|/g ) {\n                        # Find start pos, start new HSP and fill it with available details\n                        $hsp_start = (pos $alignment{Mid}{string}) - 1;\n                        $self->start_element({'Name' => 'Hsp'});\n                        $self->{'_currentHSP'} = @hsps ? shift @hsps : {};\n                        $self->{'_currentHSP'}{'Hsp_querygaps'} +=\n                            ($self->{'_currentHSP'}{'Hsp_qseq'} = substr($alignment{Query}{string}, $hsp_start)) =~ s/ /-/g;\n                        $self->{'_currentHSP'}{'Hsp_hitgaps'} +=\n                            ($self->{'_currentHSP'}{'Hsp_hseq'} = substr($alignment{Sbjct}{string}, $hsp_start)) =~ s/ /-/g;\n                        ($self->{'_currentHSP'}{'Hsp_midline'} = substr($alignment{Mid}{string}, $hsp_start)) =~ s/-/ /g;\n\t\t    }\n\t\t}\n                # No HSP is currently open...\n                else {\n                    # Find start pos, start new HSP and fill it with available\n                    # details then skip to next alignment block\n\t\t    $hsp_start = index($alignment{Mid}{string}, '|');\n\t            $self->start_element({'Name' => 'Hsp'});\n                    $self->{'_currentHSP'} = @hsps ? shift @hsps : {\n                        'Hsp_query-from' => $alignment{Query}{start},\n    \t            };\n                    $self->{'_currentHSP'}{'Hsp_querygaps'} +=\n                        ($self->{'_currentHSP'}{'Hsp_qseq'} = substr($alignment{Query}{string}, $hsp_start)) =~ s/ /-/g;\n                    $self->{'_currentHSP'}{'Hsp_hitgaps'} +=\n                        ($self->{'_currentHSP'}{'Hsp_hseq'} = substr($alignment{Sbjct}{string}, $hsp_start)) =~ s/ /-/g;\n                    ($self->{'_currentHSP'}{'Hsp_midline'} = substr($alignment{Mid}{string}, $hsp_start)) =~ s/-/ /g;\n                    next;\n\t\t}\n\t    }\n            # Current alignment block does not contain HSPs boundary\n            else {\n                # Start a new HSP if none is currently open\n\t        # (Happens if last boundary finished at the very end of previous block)\n\t        if ( !$self->in_element('hsp') ) {\n     \t            $self->start_element({'Name' => 'Hsp'});\n                    $self->{'_currentHSP'} = @hsps ? shift @hsps : {\n                        'Hsp_query-from' => $alignment{Query}{start},\n                        'Hsp_hit-from' => $alignment{Sbjct}{start},\n     \t            }\n\t\t}\n                # Adjust details of the current HSP\n                $self->{'_currentHSP'}{'Hsp_query-from'} ||= \n\t\t    $alignment{Query}{start} - \n\t\t    length($self->{'_currentHSP'}{'Hsp_qseq'} || '');\n                $self->{'_currentHSP'}{'Hsp_hit-from'} ||= \n\t\t    $alignment{Sbjct}{start} - \n\t\t    length($self->{'_currentHSP'}{'Hsp_hseq'} || '');\n                $self->{'_currentHSP'}{'Hsp_querygaps'} +=\n                    ($self->{'_currentHSP'}{'Hsp_qseq'} .= \n\t\t     $alignment{Query}{string}) =~ s/ /-/g;\n                $self->{'_currentHSP'}{'Hsp_hitgaps'} +=\n                    ($self->{'_currentHSP'}{'Hsp_hseq'} .= \n\t\t     $alignment{Sbjct}{string}) =~ s/ /-/g;\n                ($self->{'_currentHSP'}{'Hsp_midline'} .= \n\t\t $alignment{Mid}{string}) =~ s/-/ /g;\n\t    }\n\t}\n    }\n\n    # We are done reading the sim4 report, end everything and return\n    if( $seentop ) {\n        # end HSP if needed\n        $self->end_element({'Name' => 'Hsp'}) if ( $self->in_element('hsp') );\n        # end Hit if needed\n        if ( $self->in_element('hit') ) {\n            foreach (@hsps) {\n                $self->start_element({'Name' => 'Hsp'});\n                while (my ($name, $data) = each %$_) {\n                    $self->{'_currentHSP'}{$name} = $data;\n    \t        }\n    \t        $self->end_element({'Name' => 'Hsp'});\n            }\n            $self->end_element({'Name' => 'Hit'});\n\t}\n        # adjust result's algorithm name, end output and return\n        $self->element({'Name' => 'Sim4Output_program',\n                        'Data' => $DEFAULTFORMAT . ' (A=' . (defined $format ? $format : '?') . ')'});\n\t$self->end_element({'Name' => 'Sim4Output'});\n\treturn $self->end_document();\n    } \n    return;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n   # we currently don't care about attributes\n   my $nm = $data->{'Name'};\n   my $type = $MODEMAP{$nm};\n\n   if( $type ) {\n       if( $self->_will_handle($type) ) {\n\t   my $func = sprintf(\"start_%s\",lc $type);\n\t   $self->_eventHandler->$func($data->{'Attributes'});\n       }\n       unshift @{$self->{'_elements'}}, $type;\n\n       if($type eq 'result') {\n\t   $self->{'_values'} = {};\n\t   $self->{'_result'}= undef;\n       }\n   }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n    \n    if( $nm eq 'Hsp' ) {\n        $self->{'_currentHSP'}{'Hsp_midline'} ||= '';\n\t$self->{'_currentHSP'}{'Hsp_query-to'} ||=\n            $self->{'_currentHSP'}{'Hsp_query-from'} + length($self->{'_currentHSP'}{'Hsp_qseq'}) - 1 - $self->{'_currentHSP'}{'Hsp_querygaps'};\n        $self->{'_currentHSP'}{'Hsp_hit-to'} ||=\n            $self->{'_currentHSP'}{'Hsp_hit-from'} + length($self->{'_currentHSP'}{'Hsp_hseq'}) - 1 - $self->{'_currentHSP'}{'Hsp_hitgaps'};\n        $self->{'_currentHSP'}{'Hsp_identity'} ||= \n\t    ($self->{'_currentHSP'}{'Hsp_midline'} =~ tr/\\|//);\n        $self->{'_currentHSP'}{'Hsp_qlength'} ||= abs($self->{'_currentHSP'}{'Hsp_query-to'} - $self->{'_currentHSP'}{'Hsp_query-from'}) + 1;\n        $self->{'_currentHSP'}{'Hsp_hlength'} ||= abs($self->{'_currentHSP'}{'Hsp_hit-to'} - $self->{'_currentHSP'}{'Hsp_hit-from'}) + 1;\n        $self->{'_currentHSP'}{'Hsp_align-len'} ||= abs($self->{'_currentHSP'}{'Hsp_query-to'} - $self->{'_currentHSP'}{'Hsp_query-from'}) + 1;\n        $self->{'_currentHSP'}{'Hsp_score'} ||= int(100 * ($self->{'_currentHSP'}{'Hsp_identity'} / $self->{'_currentHSP'}{'Hsp_align-len'}));\n        foreach (keys %{$self->{'_currentHSP'}}) {\n            $self->element({'Name' => $_, 'Data' => delete ${$self->{'_currentHSP'}}{$_}});\n\t}\n    }\n\n    if( $type = $MODEMAP{$nm} ) {\n\tif( $self->_will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) {\n\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else {\n\t$self->debug( \"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at\n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;\n   return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/ );\n   \n   if( $self->in_element('hsp') && \n       $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ ) {\n       $self->{'_last_hspdata'}->{$data->{'Name'}} .= $data->{'Data'};\n   }  \n\n   $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name","parameters":[{"label":"$self"},{"label":"$name"}],"label":"within_element($self,$name)"},"containerName":"main::","name":"within_element","children":[{"definition":"my","localvar":"my","containerName":"within_element","kind":13,"name":"$self","line":533},{"kind":13,"containerName":"within_element","name":"$name","line":533},{"line":534,"kind":13,"containerName":"within_element","name":"$name"},{"name":"$self","kind":13,"containerName":"within_element","line":535},{"line":536,"name":"$self","kind":13,"containerName":"within_element"}],"detail":"($self,$name)","definition":"sub"},{"kind":13,"containerName":null,"name":"%self","line":537},{"kind":13,"containerName":null,"name":"%name","line":538},{"children":[{"localvar":"my","kind":13,"containerName":"in_element","name":"$self","line":560,"definition":"my"},{"line":560,"name":"$name","kind":13,"containerName":"in_element"},{"line":561,"name":"$self","kind":13,"containerName":"in_element"},{"line":562,"containerName":"in_element","kind":13,"name":"$self"},{"line":562,"name":"$name","kind":13,"containerName":"in_element"}],"name":"in_element","containerName":"main::","definition":"sub","detail":"($self,$name)","line":559,"range":{"end":{"character":9999,"line":563},"start":{"line":559,"character":0}},"kind":12,"signature":{"documentation":"1;\n# $Id: sim4.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::sim4\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::sim4 - parser for Sim4 alignments\n\n=head1 SYNOPSIS\n\n  # do not use this module directly, it is a driver for SearchIO\n  use Bio::SearchIO;\n  my $searchio = Bio::SearchIO->new(-file => 'results.sim4',\n                                   -format => 'sim4');\n\n  while ( my $result = $searchio->next_result ) {\n      while ( my $hit = $result->next_hit ) {\n\t  while ( my $hsp = $hit->next_hsp ) {\n              # ...\n\t  }\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis is a driver for the SearchIO system for parsing Sim4.\nhttp://globin.cse.psu.edu/html/docs/sim4.html\n\nCannot parse LAV or 'exon file' formats (A=2 or A=5)\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nLuc Gauthier (lgauthie@hotmail.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::sim4;\n\nuse strict;\nuse vars qw($DEFAULTFORMAT %ALIGN_TYPES\n            %MAPPING %MODEMAP $DEFAULT_WRITER_CLASS);\n\nuse POSIX;\nuse Bio::SearchIO::SearchResultEventBuilder;\n\nuse base qw(Bio::SearchIO);\n\n$DEFAULTFORMAT = 'SIM4';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n%ALIGN_TYPES = (\n    0 => 'Ruler',\n    1 => 'Query', \n    2 => 'Mid', \n    3 => 'Sbjct'\n);\n\n%MODEMAP = (\n    'Sim4Output' => 'result',\n    'Hit'        => 'hit',\n    'Hsp'        => 'hsp'\n);\n\n%MAPPING = (\n    'Hsp_query-from'=>  'HSP-query_start',\n    'Hsp_query-to'  =>  'HSP-query_end',\n    'Hsp_qseq'      =>  'HSP-query_seq',\n    'Hsp_qlength'   =>  'HSP-query_length',\n    'Hsp_querygaps'  => 'HSP-query_gaps',\n    'Hsp_hit-from'  =>  'HSP-hit_start',\n    'Hsp_hit-to'    =>  'HSP-hit_end',\n    'Hsp_hseq'      =>  'HSP-hit_seq',\n    'Hsp_hlength'   =>  'HSP-hit_length',\n    'Hsp_hitgaps'    => 'HSP-hit_gaps',\n    'Hsp_midline'   =>  'HSP-homology_seq',\n    'Hsp_score'     =>  'HSP-score',\n    'Hsp_align-len' =>  'HSP-hsp_length',\n    'Hsp_identity'  =>  'HSP-identical',\n\n    'Hit_id'        => 'HIT-name',\n    'Hit_desc'      => 'HIT-description',\n    'Hit_len'       => 'HIT-length',\n\n    'Sim4Output_program'   => 'RESULT-algorithm_name',\n    'Sim4Output_query-def' => 'RESULT-query_name',\n    'Sim4Output_query-desc'=> 'RESULT-query_description',\n    'Sim4Output_query-len' => 'RESULT-query_length',\n);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::sim4->new();\n Function: Builds a new Bio::SearchIO::sim4 object\n Returns : an instance of Bio::SearchIO::sim4\n Args    :\n\n\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    # Declare/adjust needed variables\n    $self->{'_last_data'} = '';\n    my ($seentop, $qfull, @hsps, %alignment, $format);\n    my $hit_direction = 1;\n\n    # Start document and main element\n    $self->start_document();\n    $self->start_element({'Name' => 'Sim4Output'});\n    my $lastquery = '';\n    # Read output report until EOF\n    while( defined($_ = $self->_readline) ) {       \n        # Skip empty lines, chomp filled ones\n\tnext if( /^\\s+$/); chomp;\n\n        # Make sure sim4 output format is not 2 or 5\n        if (!$seentop) {\n\t    if ( /^\\#:lav/ ) { $format = 2; }\n            elsif ( /^<|>/ ) { $format = 5; }\n            $self->throw(\"Bio::SearchIO::sim4 module cannot parse 'type $format' outputs.\") if $format;\n\t}\n\n        # This line indicates the start of a new hit\n\tif( /^seq1\\s*=\\s*(\\S+),\\s+(\\d+)/ ) {\n\t    my ($nm,$desc) = ($1,$2);\n            # First hit? Adjust some parameters if so\n\t    if ( ! $seentop ) {\n\t        $self->element( {'Name' => 'Sim4Output_query-def', \n\t\t\t\t 'Data' => $nm} );\n\t        $self->element( {'Name' => 'Sim4Output_query-len', \n\t\t\t\t 'Data' => $desc} );\n                $seentop = 1;\n\t    } elsif( $nm ne $lastquery ) {\n\t\t$self->_pushback($_);\n\t\tlast;\n\t    }\n\t    $lastquery = $nm;\n            # A previous HSP may need to be ended\n            $self->end_element({'Name' => 'Hsp'}) if ( $self->in_element('hsp') );\n            # A previous hit exists? End it and reset needed variables\n            if ( $self->in_element('hit') ) {\n\t        foreach (@hsps) {\n                    $self->start_element({'Name' => 'Hsp'});\n                    while (my ($name, $data) = each %$_) {\n                        $self->{'_currentHSP'}{$name} = $data;\n\t\t    }\n\t\t    $self->end_element({'Name' => 'Hsp'});\n                    $self->{'_currentHSP'} = {};\n\t        }\n                $format = 0 if @hsps;\n                @hsps = ();\n                %alignment = ();\n                $qfull = 0;\n                $hit_direction = 1;\n                $self->end_element({'Name' => 'Hit'});\n\t    }\n\n        # This line describes the current hit... so let's start it\n\t} elsif( /^seq2\\s*=\\s*(\\S+)\\s+\\(>?(\\S+)\\s*\\),\\s*(\\d+)/ ) {\n            $self->start_element({'Name' => 'Hit'});\n\t    $self->element( {'Name' => 'Hit_id', 'Data' => $2} );\n\t    $self->element( {'Name' => 'Hit_desc', 'Data' => $1} );\n\t    $self->element( {'Name' => 'Hit_len', 'Data' => $3} );\n\n        # This line may give additional details about query or subject\n\t} elsif( /^>(\\S+)\\s*(.*)?/ ) {\n            # Previous line was query details... this time subject details\n\t    if( $qfull )  {\n                $format = 4 if !$format;\n\t\t$self->element({'Name' => 'Hit_desc', 'Data' => $2});\n            # First line of this type is always query details for a given hit\n\t    } else { \n\t\t$self->element({'Name' => 'Sim4Output_query-desc', 'Data' => $2});\n\t\t$qfull = 1;\n\t    }\n\n        # This line indicates that subject is on reverse strand\n\t} elsif( /^\\(complement\\)/ ) {\n\t    $hit_direction = -1;\n\n        # This line describes the current HSP... so add it to @hsps array\n\t} elsif( /^\\(?(\\d+)\\-(\\d+)\\)?\\s+\\(?(\\d+)\\-(\\d+)\\)?\\s+(\\d+)/ ) {\n\t\tmy ($qs,$qe,$hs,$he,$pid) = ($1,$2,$3,$4,$5);\n                push @hsps, {\n                    'Hsp_query-from' => $qs,\n                    'Hsp_query-to' => $qe,\n                    'Hsp_hit-from' => $hit_direction >= 0 ? $hs : $he,\n                    'Hsp_hit-to' => $hit_direction >= 0 ? $he : $hs,\n                    'Hsp_identity' => 0, #can't determine correctly from raw pct\n                    'Hsp_qlength' => abs($qe - $qs) + 1,\n                    'Hsp_hlength' => abs($he - $hs) + 1,\n                    'Hsp_align-len' => abs($qe - $qs) + 1,\n\t        };\n\n        # This line indicates the start of an alignment block\n        } elsif( /^\\s+(\\d+)\\s/ ) {\n            # Store the current alignment block in a hash\n\t    for( my $i = 0; defined($_) && $i < 4; $i++ ) {\n                my ($start, $string) = /^\\s+(\\d*)\\s(.*)/;\n                $alignment{$ALIGN_TYPES{$i}} = { start => $start, string => $i != 2\n                    ? $string\n                    : (' ' x (length($alignment{$ALIGN_TYPES{$i-1}}{string}) - length($string))) . $string\n                };\n                $_ = $self->_readline();\n\t    }\n\n            # 'Ruler' line indicates the start of a new HSP\n            if ($alignment{Ruler}{start} == 0) {\n                $format = @hsps ? 3 : 1 if !$format;\n                # A previous HSP may need to be ended\n                $self->end_element({'Name' => 'Hsp'}) if ( $self->in_element('hsp') );\n                # Start the new HSP and fill the '_currentHSP' property with available details\n     \t        $self->start_element({'Name' => 'Hsp'});\n                $self->{'_currentHSP'} = @hsps ? shift @hsps : {\n                    'Hsp_query-from' => $alignment{Query}{start},\n                    'Hsp_hit-from' => $alignment{Sbjct}{start},\n     \t        }\n\t    }\n\n            # Midline indicates a boundary between two HSPs\n\t    if ( $alignment{Mid}{string} =~ /<|>/g ) {\n                my ($hsp_start, $hsp_end);\n                # Are we currently in an open HSP?\n    \t        if ( $self->in_element('hsp') ) {\n                    # Find end pos, adjust 'gaps', 'seq' and 'midline' properties... then close HSP\n                    $hsp_end = (pos $alignment{Mid}{string}) - 1;\n                    $self->{'_currentHSP'}{'Hsp_querygaps'} +=\n                        ($self->{'_currentHSP'}{'Hsp_qseq'} .= substr($alignment{Query}{string}, 0, $hsp_end)) =~ s/ /-/g;\n                    $self->{'_currentHSP'}{'Hsp_hitgaps'} +=\n                        ($self->{'_currentHSP'}{'Hsp_hseq'} .= substr($alignment{Sbjct}{string}, 0, $hsp_end)) =~ s/ /-/g;\n                    ($self->{'_currentHSP'}{'Hsp_midline'} .= substr($alignment{Mid}{string}, 0, $hsp_end)) =~ s/-/ /g;\n                    $self->end_element({'Name' => 'Hsp'});\n\n                    # Does a new HSP start in the current alignment block?\n                    if ( $alignment{Mid}{string} =~ /\\|/g ) {\n                        # Find start pos, start new HSP and fill it with available details\n                        $hsp_start = (pos $alignment{Mid}{string}) - 1;\n                        $self->start_element({'Name' => 'Hsp'});\n                        $self->{'_currentHSP'} = @hsps ? shift @hsps : {};\n                        $self->{'_currentHSP'}{'Hsp_querygaps'} +=\n                            ($self->{'_currentHSP'}{'Hsp_qseq'} = substr($alignment{Query}{string}, $hsp_start)) =~ s/ /-/g;\n                        $self->{'_currentHSP'}{'Hsp_hitgaps'} +=\n                            ($self->{'_currentHSP'}{'Hsp_hseq'} = substr($alignment{Sbjct}{string}, $hsp_start)) =~ s/ /-/g;\n                        ($self->{'_currentHSP'}{'Hsp_midline'} = substr($alignment{Mid}{string}, $hsp_start)) =~ s/-/ /g;\n\t\t    }\n\t\t}\n                # No HSP is currently open...\n                else {\n                    # Find start pos, start new HSP and fill it with available\n                    # details then skip to next alignment block\n\t\t    $hsp_start = index($alignment{Mid}{string}, '|');\n\t            $self->start_element({'Name' => 'Hsp'});\n                    $self->{'_currentHSP'} = @hsps ? shift @hsps : {\n                        'Hsp_query-from' => $alignment{Query}{start},\n    \t            };\n                    $self->{'_currentHSP'}{'Hsp_querygaps'} +=\n                        ($self->{'_currentHSP'}{'Hsp_qseq'} = substr($alignment{Query}{string}, $hsp_start)) =~ s/ /-/g;\n                    $self->{'_currentHSP'}{'Hsp_hitgaps'} +=\n                        ($self->{'_currentHSP'}{'Hsp_hseq'} = substr($alignment{Sbjct}{string}, $hsp_start)) =~ s/ /-/g;\n                    ($self->{'_currentHSP'}{'Hsp_midline'} = substr($alignment{Mid}{string}, $hsp_start)) =~ s/-/ /g;\n                    next;\n\t\t}\n\t    }\n            # Current alignment block does not contain HSPs boundary\n            else {\n                # Start a new HSP if none is currently open\n\t        # (Happens if last boundary finished at the very end of previous block)\n\t        if ( !$self->in_element('hsp') ) {\n     \t            $self->start_element({'Name' => 'Hsp'});\n                    $self->{'_currentHSP'} = @hsps ? shift @hsps : {\n                        'Hsp_query-from' => $alignment{Query}{start},\n                        'Hsp_hit-from' => $alignment{Sbjct}{start},\n     \t            }\n\t\t}\n                # Adjust details of the current HSP\n                $self->{'_currentHSP'}{'Hsp_query-from'} ||= \n\t\t    $alignment{Query}{start} - \n\t\t    length($self->{'_currentHSP'}{'Hsp_qseq'} || '');\n                $self->{'_currentHSP'}{'Hsp_hit-from'} ||= \n\t\t    $alignment{Sbjct}{start} - \n\t\t    length($self->{'_currentHSP'}{'Hsp_hseq'} || '');\n                $self->{'_currentHSP'}{'Hsp_querygaps'} +=\n                    ($self->{'_currentHSP'}{'Hsp_qseq'} .= \n\t\t     $alignment{Query}{string}) =~ s/ /-/g;\n                $self->{'_currentHSP'}{'Hsp_hitgaps'} +=\n                    ($self->{'_currentHSP'}{'Hsp_hseq'} .= \n\t\t     $alignment{Sbjct}{string}) =~ s/ /-/g;\n                ($self->{'_currentHSP'}{'Hsp_midline'} .= \n\t\t $alignment{Mid}{string}) =~ s/-/ /g;\n\t    }\n\t}\n    }\n\n    # We are done reading the sim4 report, end everything and return\n    if( $seentop ) {\n        # end HSP if needed\n        $self->end_element({'Name' => 'Hsp'}) if ( $self->in_element('hsp') );\n        # end Hit if needed\n        if ( $self->in_element('hit') ) {\n            foreach (@hsps) {\n                $self->start_element({'Name' => 'Hsp'});\n                while (my ($name, $data) = each %$_) {\n                    $self->{'_currentHSP'}{$name} = $data;\n    \t        }\n    \t        $self->end_element({'Name' => 'Hsp'});\n            }\n            $self->end_element({'Name' => 'Hit'});\n\t}\n        # adjust result's algorithm name, end output and return\n        $self->element({'Name' => 'Sim4Output_program',\n                        'Data' => $DEFAULTFORMAT . ' (A=' . (defined $format ? $format : '?') . ')'});\n\t$self->end_element({'Name' => 'Sim4Output'});\n\treturn $self->end_document();\n    } \n    return;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n   # we currently don't care about attributes\n   my $nm = $data->{'Name'};\n   my $type = $MODEMAP{$nm};\n\n   if( $type ) {\n       if( $self->_will_handle($type) ) {\n\t   my $func = sprintf(\"start_%s\",lc $type);\n\t   $self->_eventHandler->$func($data->{'Attributes'});\n       }\n       unshift @{$self->{'_elements'}}, $type;\n\n       if($type eq 'result') {\n\t   $self->{'_values'} = {};\n\t   $self->{'_result'}= undef;\n       }\n   }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n    \n    if( $nm eq 'Hsp' ) {\n        $self->{'_currentHSP'}{'Hsp_midline'} ||= '';\n\t$self->{'_currentHSP'}{'Hsp_query-to'} ||=\n            $self->{'_currentHSP'}{'Hsp_query-from'} + length($self->{'_currentHSP'}{'Hsp_qseq'}) - 1 - $self->{'_currentHSP'}{'Hsp_querygaps'};\n        $self->{'_currentHSP'}{'Hsp_hit-to'} ||=\n            $self->{'_currentHSP'}{'Hsp_hit-from'} + length($self->{'_currentHSP'}{'Hsp_hseq'}) - 1 - $self->{'_currentHSP'}{'Hsp_hitgaps'};\n        $self->{'_currentHSP'}{'Hsp_identity'} ||= \n\t    ($self->{'_currentHSP'}{'Hsp_midline'} =~ tr/\\|//);\n        $self->{'_currentHSP'}{'Hsp_qlength'} ||= abs($self->{'_currentHSP'}{'Hsp_query-to'} - $self->{'_currentHSP'}{'Hsp_query-from'}) + 1;\n        $self->{'_currentHSP'}{'Hsp_hlength'} ||= abs($self->{'_currentHSP'}{'Hsp_hit-to'} - $self->{'_currentHSP'}{'Hsp_hit-from'}) + 1;\n        $self->{'_currentHSP'}{'Hsp_align-len'} ||= abs($self->{'_currentHSP'}{'Hsp_query-to'} - $self->{'_currentHSP'}{'Hsp_query-from'}) + 1;\n        $self->{'_currentHSP'}{'Hsp_score'} ||= int(100 * ($self->{'_currentHSP'}{'Hsp_identity'} / $self->{'_currentHSP'}{'Hsp_align-len'}));\n        foreach (keys %{$self->{'_currentHSP'}}) {\n            $self->element({'Name' => $_, 'Data' => delete ${$self->{'_currentHSP'}}{$_}});\n\t}\n    }\n\n    if( $type = $MODEMAP{$nm} ) {\n\tif( $self->_will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) {\n\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else {\n\t$self->debug( \"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at\n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;\n   return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/ );\n   \n   if( $self->in_element('hsp') && \n       $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ ) {\n       $self->{'_last_hspdata'}->{$data->{'Name'}} .= $data->{'Data'};\n   }  \n\n   $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name\n\n\n\nsub within_element{\n   my ($self,$name) = @_;\n   return 0 if ( ! defined $name &&\n\t\t ! defined  $self->{'_elements'} ||\n\t\t scalar @{$self->{'_elements'}} == 0) ;\n   foreach (  @{$self->{'_elements'}} ) {\n       if( $_ eq $name  ) {\n\t   return 1;\n       }\n   }\n   return 0;\n}\n\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name","parameters":[{"label":"$self"},{"label":"$name"}],"label":"in_element($self,$name)"}},{"line":576,"kind":12,"range":{"start":{"line":576,"character":0},"end":{"character":9999,"line":583}},"signature":{"label":"start_document($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: sim4.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::sim4\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::sim4 - parser for Sim4 alignments\n\n=head1 SYNOPSIS\n\n  # do not use this module directly, it is a driver for SearchIO\n  use Bio::SearchIO;\n  my $searchio = Bio::SearchIO->new(-file => 'results.sim4',\n                                   -format => 'sim4');\n\n  while ( my $result = $searchio->next_result ) {\n      while ( my $hit = $result->next_hit ) {\n\t  while ( my $hsp = $hit->next_hsp ) {\n              # ...\n\t  }\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis is a driver for the SearchIO system for parsing Sim4.\nhttp://globin.cse.psu.edu/html/docs/sim4.html\n\nCannot parse LAV or 'exon file' formats (A=2 or A=5)\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nLuc Gauthier (lgauthie@hotmail.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::sim4;\n\nuse strict;\nuse vars qw($DEFAULTFORMAT %ALIGN_TYPES\n            %MAPPING %MODEMAP $DEFAULT_WRITER_CLASS);\n\nuse POSIX;\nuse Bio::SearchIO::SearchResultEventBuilder;\n\nuse base qw(Bio::SearchIO);\n\n$DEFAULTFORMAT = 'SIM4';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n%ALIGN_TYPES = (\n    0 => 'Ruler',\n    1 => 'Query', \n    2 => 'Mid', \n    3 => 'Sbjct'\n);\n\n%MODEMAP = (\n    'Sim4Output' => 'result',\n    'Hit'        => 'hit',\n    'Hsp'        => 'hsp'\n);\n\n%MAPPING = (\n    'Hsp_query-from'=>  'HSP-query_start',\n    'Hsp_query-to'  =>  'HSP-query_end',\n    'Hsp_qseq'      =>  'HSP-query_seq',\n    'Hsp_qlength'   =>  'HSP-query_length',\n    'Hsp_querygaps'  => 'HSP-query_gaps',\n    'Hsp_hit-from'  =>  'HSP-hit_start',\n    'Hsp_hit-to'    =>  'HSP-hit_end',\n    'Hsp_hseq'      =>  'HSP-hit_seq',\n    'Hsp_hlength'   =>  'HSP-hit_length',\n    'Hsp_hitgaps'    => 'HSP-hit_gaps',\n    'Hsp_midline'   =>  'HSP-homology_seq',\n    'Hsp_score'     =>  'HSP-score',\n    'Hsp_align-len' =>  'HSP-hsp_length',\n    'Hsp_identity'  =>  'HSP-identical',\n\n    'Hit_id'        => 'HIT-name',\n    'Hit_desc'      => 'HIT-description',\n    'Hit_len'       => 'HIT-length',\n\n    'Sim4Output_program'   => 'RESULT-algorithm_name',\n    'Sim4Output_query-def' => 'RESULT-query_name',\n    'Sim4Output_query-desc'=> 'RESULT-query_description',\n    'Sim4Output_query-len' => 'RESULT-query_length',\n);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::sim4->new();\n Function: Builds a new Bio::SearchIO::sim4 object\n Returns : an instance of Bio::SearchIO::sim4\n Args    :\n\n\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    # Declare/adjust needed variables\n    $self->{'_last_data'} = '';\n    my ($seentop, $qfull, @hsps, %alignment, $format);\n    my $hit_direction = 1;\n\n    # Start document and main element\n    $self->start_document();\n    $self->start_element({'Name' => 'Sim4Output'});\n    my $lastquery = '';\n    # Read output report until EOF\n    while( defined($_ = $self->_readline) ) {       \n        # Skip empty lines, chomp filled ones\n\tnext if( /^\\s+$/); chomp;\n\n        # Make sure sim4 output format is not 2 or 5\n        if (!$seentop) {\n\t    if ( /^\\#:lav/ ) { $format = 2; }\n            elsif ( /^<|>/ ) { $format = 5; }\n            $self->throw(\"Bio::SearchIO::sim4 module cannot parse 'type $format' outputs.\") if $format;\n\t}\n\n        # This line indicates the start of a new hit\n\tif( /^seq1\\s*=\\s*(\\S+),\\s+(\\d+)/ ) {\n\t    my ($nm,$desc) = ($1,$2);\n            # First hit? Adjust some parameters if so\n\t    if ( ! $seentop ) {\n\t        $self->element( {'Name' => 'Sim4Output_query-def', \n\t\t\t\t 'Data' => $nm} );\n\t        $self->element( {'Name' => 'Sim4Output_query-len', \n\t\t\t\t 'Data' => $desc} );\n                $seentop = 1;\n\t    } elsif( $nm ne $lastquery ) {\n\t\t$self->_pushback($_);\n\t\tlast;\n\t    }\n\t    $lastquery = $nm;\n            # A previous HSP may need to be ended\n            $self->end_element({'Name' => 'Hsp'}) if ( $self->in_element('hsp') );\n            # A previous hit exists? End it and reset needed variables\n            if ( $self->in_element('hit') ) {\n\t        foreach (@hsps) {\n                    $self->start_element({'Name' => 'Hsp'});\n                    while (my ($name, $data) = each %$_) {\n                        $self->{'_currentHSP'}{$name} = $data;\n\t\t    }\n\t\t    $self->end_element({'Name' => 'Hsp'});\n                    $self->{'_currentHSP'} = {};\n\t        }\n                $format = 0 if @hsps;\n                @hsps = ();\n                %alignment = ();\n                $qfull = 0;\n                $hit_direction = 1;\n                $self->end_element({'Name' => 'Hit'});\n\t    }\n\n        # This line describes the current hit... so let's start it\n\t} elsif( /^seq2\\s*=\\s*(\\S+)\\s+\\(>?(\\S+)\\s*\\),\\s*(\\d+)/ ) {\n            $self->start_element({'Name' => 'Hit'});\n\t    $self->element( {'Name' => 'Hit_id', 'Data' => $2} );\n\t    $self->element( {'Name' => 'Hit_desc', 'Data' => $1} );\n\t    $self->element( {'Name' => 'Hit_len', 'Data' => $3} );\n\n        # This line may give additional details about query or subject\n\t} elsif( /^>(\\S+)\\s*(.*)?/ ) {\n            # Previous line was query details... this time subject details\n\t    if( $qfull )  {\n                $format = 4 if !$format;\n\t\t$self->element({'Name' => 'Hit_desc', 'Data' => $2});\n            # First line of this type is always query details for a given hit\n\t    } else { \n\t\t$self->element({'Name' => 'Sim4Output_query-desc', 'Data' => $2});\n\t\t$qfull = 1;\n\t    }\n\n        # This line indicates that subject is on reverse strand\n\t} elsif( /^\\(complement\\)/ ) {\n\t    $hit_direction = -1;\n\n        # This line describes the current HSP... so add it to @hsps array\n\t} elsif( /^\\(?(\\d+)\\-(\\d+)\\)?\\s+\\(?(\\d+)\\-(\\d+)\\)?\\s+(\\d+)/ ) {\n\t\tmy ($qs,$qe,$hs,$he,$pid) = ($1,$2,$3,$4,$5);\n                push @hsps, {\n                    'Hsp_query-from' => $qs,\n                    'Hsp_query-to' => $qe,\n                    'Hsp_hit-from' => $hit_direction >= 0 ? $hs : $he,\n                    'Hsp_hit-to' => $hit_direction >= 0 ? $he : $hs,\n                    'Hsp_identity' => 0, #can't determine correctly from raw pct\n                    'Hsp_qlength' => abs($qe - $qs) + 1,\n                    'Hsp_hlength' => abs($he - $hs) + 1,\n                    'Hsp_align-len' => abs($qe - $qs) + 1,\n\t        };\n\n        # This line indicates the start of an alignment block\n        } elsif( /^\\s+(\\d+)\\s/ ) {\n            # Store the current alignment block in a hash\n\t    for( my $i = 0; defined($_) && $i < 4; $i++ ) {\n                my ($start, $string) = /^\\s+(\\d*)\\s(.*)/;\n                $alignment{$ALIGN_TYPES{$i}} = { start => $start, string => $i != 2\n                    ? $string\n                    : (' ' x (length($alignment{$ALIGN_TYPES{$i-1}}{string}) - length($string))) . $string\n                };\n                $_ = $self->_readline();\n\t    }\n\n            # 'Ruler' line indicates the start of a new HSP\n            if ($alignment{Ruler}{start} == 0) {\n                $format = @hsps ? 3 : 1 if !$format;\n                # A previous HSP may need to be ended\n                $self->end_element({'Name' => 'Hsp'}) if ( $self->in_element('hsp') );\n                # Start the new HSP and fill the '_currentHSP' property with available details\n     \t        $self->start_element({'Name' => 'Hsp'});\n                $self->{'_currentHSP'} = @hsps ? shift @hsps : {\n                    'Hsp_query-from' => $alignment{Query}{start},\n                    'Hsp_hit-from' => $alignment{Sbjct}{start},\n     \t        }\n\t    }\n\n            # Midline indicates a boundary between two HSPs\n\t    if ( $alignment{Mid}{string} =~ /<|>/g ) {\n                my ($hsp_start, $hsp_end);\n                # Are we currently in an open HSP?\n    \t        if ( $self->in_element('hsp') ) {\n                    # Find end pos, adjust 'gaps', 'seq' and 'midline' properties... then close HSP\n                    $hsp_end = (pos $alignment{Mid}{string}) - 1;\n                    $self->{'_currentHSP'}{'Hsp_querygaps'} +=\n                        ($self->{'_currentHSP'}{'Hsp_qseq'} .= substr($alignment{Query}{string}, 0, $hsp_end)) =~ s/ /-/g;\n                    $self->{'_currentHSP'}{'Hsp_hitgaps'} +=\n                        ($self->{'_currentHSP'}{'Hsp_hseq'} .= substr($alignment{Sbjct}{string}, 0, $hsp_end)) =~ s/ /-/g;\n                    ($self->{'_currentHSP'}{'Hsp_midline'} .= substr($alignment{Mid}{string}, 0, $hsp_end)) =~ s/-/ /g;\n                    $self->end_element({'Name' => 'Hsp'});\n\n                    # Does a new HSP start in the current alignment block?\n                    if ( $alignment{Mid}{string} =~ /\\|/g ) {\n                        # Find start pos, start new HSP and fill it with available details\n                        $hsp_start = (pos $alignment{Mid}{string}) - 1;\n                        $self->start_element({'Name' => 'Hsp'});\n                        $self->{'_currentHSP'} = @hsps ? shift @hsps : {};\n                        $self->{'_currentHSP'}{'Hsp_querygaps'} +=\n                            ($self->{'_currentHSP'}{'Hsp_qseq'} = substr($alignment{Query}{string}, $hsp_start)) =~ s/ /-/g;\n                        $self->{'_currentHSP'}{'Hsp_hitgaps'} +=\n                            ($self->{'_currentHSP'}{'Hsp_hseq'} = substr($alignment{Sbjct}{string}, $hsp_start)) =~ s/ /-/g;\n                        ($self->{'_currentHSP'}{'Hsp_midline'} = substr($alignment{Mid}{string}, $hsp_start)) =~ s/-/ /g;\n\t\t    }\n\t\t}\n                # No HSP is currently open...\n                else {\n                    # Find start pos, start new HSP and fill it with available\n                    # details then skip to next alignment block\n\t\t    $hsp_start = index($alignment{Mid}{string}, '|');\n\t            $self->start_element({'Name' => 'Hsp'});\n                    $self->{'_currentHSP'} = @hsps ? shift @hsps : {\n                        'Hsp_query-from' => $alignment{Query}{start},\n    \t            };\n                    $self->{'_currentHSP'}{'Hsp_querygaps'} +=\n                        ($self->{'_currentHSP'}{'Hsp_qseq'} = substr($alignment{Query}{string}, $hsp_start)) =~ s/ /-/g;\n                    $self->{'_currentHSP'}{'Hsp_hitgaps'} +=\n                        ($self->{'_currentHSP'}{'Hsp_hseq'} = substr($alignment{Sbjct}{string}, $hsp_start)) =~ s/ /-/g;\n                    ($self->{'_currentHSP'}{'Hsp_midline'} = substr($alignment{Mid}{string}, $hsp_start)) =~ s/-/ /g;\n                    next;\n\t\t}\n\t    }\n            # Current alignment block does not contain HSPs boundary\n            else {\n                # Start a new HSP if none is currently open\n\t        # (Happens if last boundary finished at the very end of previous block)\n\t        if ( !$self->in_element('hsp') ) {\n     \t            $self->start_element({'Name' => 'Hsp'});\n                    $self->{'_currentHSP'} = @hsps ? shift @hsps : {\n                        'Hsp_query-from' => $alignment{Query}{start},\n                        'Hsp_hit-from' => $alignment{Sbjct}{start},\n     \t            }\n\t\t}\n                # Adjust details of the current HSP\n                $self->{'_currentHSP'}{'Hsp_query-from'} ||= \n\t\t    $alignment{Query}{start} - \n\t\t    length($self->{'_currentHSP'}{'Hsp_qseq'} || '');\n                $self->{'_currentHSP'}{'Hsp_hit-from'} ||= \n\t\t    $alignment{Sbjct}{start} - \n\t\t    length($self->{'_currentHSP'}{'Hsp_hseq'} || '');\n                $self->{'_currentHSP'}{'Hsp_querygaps'} +=\n                    ($self->{'_currentHSP'}{'Hsp_qseq'} .= \n\t\t     $alignment{Query}{string}) =~ s/ /-/g;\n                $self->{'_currentHSP'}{'Hsp_hitgaps'} +=\n                    ($self->{'_currentHSP'}{'Hsp_hseq'} .= \n\t\t     $alignment{Sbjct}{string}) =~ s/ /-/g;\n                ($self->{'_currentHSP'}{'Hsp_midline'} .= \n\t\t $alignment{Mid}{string}) =~ s/-/ /g;\n\t    }\n\t}\n    }\n\n    # We are done reading the sim4 report, end everything and return\n    if( $seentop ) {\n        # end HSP if needed\n        $self->end_element({'Name' => 'Hsp'}) if ( $self->in_element('hsp') );\n        # end Hit if needed\n        if ( $self->in_element('hit') ) {\n            foreach (@hsps) {\n                $self->start_element({'Name' => 'Hsp'});\n                while (my ($name, $data) = each %$_) {\n                    $self->{'_currentHSP'}{$name} = $data;\n    \t        }\n    \t        $self->end_element({'Name' => 'Hsp'});\n            }\n            $self->end_element({'Name' => 'Hit'});\n\t}\n        # adjust result's algorithm name, end output and return\n        $self->element({'Name' => 'Sim4Output_program',\n                        'Data' => $DEFAULTFORMAT . ' (A=' . (defined $format ? $format : '?') . ')'});\n\t$self->end_element({'Name' => 'Sim4Output'});\n\treturn $self->end_document();\n    } \n    return;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n   # we currently don't care about attributes\n   my $nm = $data->{'Name'};\n   my $type = $MODEMAP{$nm};\n\n   if( $type ) {\n       if( $self->_will_handle($type) ) {\n\t   my $func = sprintf(\"start_%s\",lc $type);\n\t   $self->_eventHandler->$func($data->{'Attributes'});\n       }\n       unshift @{$self->{'_elements'}}, $type;\n\n       if($type eq 'result') {\n\t   $self->{'_values'} = {};\n\t   $self->{'_result'}= undef;\n       }\n   }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n    \n    if( $nm eq 'Hsp' ) {\n        $self->{'_currentHSP'}{'Hsp_midline'} ||= '';\n\t$self->{'_currentHSP'}{'Hsp_query-to'} ||=\n            $self->{'_currentHSP'}{'Hsp_query-from'} + length($self->{'_currentHSP'}{'Hsp_qseq'}) - 1 - $self->{'_currentHSP'}{'Hsp_querygaps'};\n        $self->{'_currentHSP'}{'Hsp_hit-to'} ||=\n            $self->{'_currentHSP'}{'Hsp_hit-from'} + length($self->{'_currentHSP'}{'Hsp_hseq'}) - 1 - $self->{'_currentHSP'}{'Hsp_hitgaps'};\n        $self->{'_currentHSP'}{'Hsp_identity'} ||= \n\t    ($self->{'_currentHSP'}{'Hsp_midline'} =~ tr/\\|//);\n        $self->{'_currentHSP'}{'Hsp_qlength'} ||= abs($self->{'_currentHSP'}{'Hsp_query-to'} - $self->{'_currentHSP'}{'Hsp_query-from'}) + 1;\n        $self->{'_currentHSP'}{'Hsp_hlength'} ||= abs($self->{'_currentHSP'}{'Hsp_hit-to'} - $self->{'_currentHSP'}{'Hsp_hit-from'}) + 1;\n        $self->{'_currentHSP'}{'Hsp_align-len'} ||= abs($self->{'_currentHSP'}{'Hsp_query-to'} - $self->{'_currentHSP'}{'Hsp_query-from'}) + 1;\n        $self->{'_currentHSP'}{'Hsp_score'} ||= int(100 * ($self->{'_currentHSP'}{'Hsp_identity'} / $self->{'_currentHSP'}{'Hsp_align-len'}));\n        foreach (keys %{$self->{'_currentHSP'}}) {\n            $self->element({'Name' => $_, 'Data' => delete ${$self->{'_currentHSP'}}{$_}});\n\t}\n    }\n\n    if( $type = $MODEMAP{$nm} ) {\n\tif( $self->_will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) {\n\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else {\n\t$self->debug( \"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at\n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;\n   return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/ );\n   \n   if( $self->in_element('hsp') && \n       $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ ) {\n       $self->{'_last_hspdata'}->{$data->{'Name'}} .= $data->{'Data'};\n   }  \n\n   $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name\n\n\n\nsub within_element{\n   my ($self,$name) = @_;\n   return 0 if ( ! defined $name &&\n\t\t ! defined  $self->{'_elements'} ||\n\t\t scalar @{$self->{'_elements'}} == 0) ;\n   foreach (  @{$self->{'_elements'}} ) {\n       if( $_ eq $name  ) {\n\t   return 1;\n       }\n   }\n   return 0;\n}\n\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name\n\n\n\nsub in_element{\n   my ($self,$name) = @_;\n   return 0 if ! defined $self->{'_elements'}->[0];\n   return ( $self->{'_elements'}->[0] eq $name)\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handle a start document event\n Returns : none\n Args    : none"},"children":[{"definition":"my","containerName":"start_document","localvar":"my","kind":13,"name":"$self","line":577},{"containerName":"start_document","kind":13,"name":"$self","line":578},{"name":"$self","containerName":"start_document","kind":13,"line":579},{"name":"$self","kind":13,"containerName":"start_document","line":580},{"line":581,"name":"$self","kind":13,"containerName":"start_document"},{"name":"$self","containerName":"start_document","kind":13,"line":582},{"containerName":"start_document","kind":13,"name":"$DEFAULTFORMAT","line":582}],"containerName":"main::","name":"start_document","definition":"sub","detail":"($self)"},{"detail":"($self,@args)","definition":"sub","name":"end_document","containerName":"main::","children":[{"line":598,"localvar":"my","containerName":"end_document","kind":13,"name":"$self","definition":"my"},{"name":"@args","containerName":"end_document","kind":13,"line":598},{"containerName":"end_document","kind":13,"name":"$self","line":599}],"signature":{"label":"end_document($self,@args)","documentation":"1;\n# $Id: sim4.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::sim4\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::sim4 - parser for Sim4 alignments\n\n=head1 SYNOPSIS\n\n  # do not use this module directly, it is a driver for SearchIO\n  use Bio::SearchIO;\n  my $searchio = Bio::SearchIO->new(-file => 'results.sim4',\n                                   -format => 'sim4');\n\n  while ( my $result = $searchio->next_result ) {\n      while ( my $hit = $result->next_hit ) {\n\t  while ( my $hsp = $hit->next_hsp ) {\n              # ...\n\t  }\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis is a driver for the SearchIO system for parsing Sim4.\nhttp://globin.cse.psu.edu/html/docs/sim4.html\n\nCannot parse LAV or 'exon file' formats (A=2 or A=5)\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nLuc Gauthier (lgauthie@hotmail.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::sim4;\n\nuse strict;\nuse vars qw($DEFAULTFORMAT %ALIGN_TYPES\n            %MAPPING %MODEMAP $DEFAULT_WRITER_CLASS);\n\nuse POSIX;\nuse Bio::SearchIO::SearchResultEventBuilder;\n\nuse base qw(Bio::SearchIO);\n\n$DEFAULTFORMAT = 'SIM4';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n%ALIGN_TYPES = (\n    0 => 'Ruler',\n    1 => 'Query', \n    2 => 'Mid', \n    3 => 'Sbjct'\n);\n\n%MODEMAP = (\n    'Sim4Output' => 'result',\n    'Hit'        => 'hit',\n    'Hsp'        => 'hsp'\n);\n\n%MAPPING = (\n    'Hsp_query-from'=>  'HSP-query_start',\n    'Hsp_query-to'  =>  'HSP-query_end',\n    'Hsp_qseq'      =>  'HSP-query_seq',\n    'Hsp_qlength'   =>  'HSP-query_length',\n    'Hsp_querygaps'  => 'HSP-query_gaps',\n    'Hsp_hit-from'  =>  'HSP-hit_start',\n    'Hsp_hit-to'    =>  'HSP-hit_end',\n    'Hsp_hseq'      =>  'HSP-hit_seq',\n    'Hsp_hlength'   =>  'HSP-hit_length',\n    'Hsp_hitgaps'    => 'HSP-hit_gaps',\n    'Hsp_midline'   =>  'HSP-homology_seq',\n    'Hsp_score'     =>  'HSP-score',\n    'Hsp_align-len' =>  'HSP-hsp_length',\n    'Hsp_identity'  =>  'HSP-identical',\n\n    'Hit_id'        => 'HIT-name',\n    'Hit_desc'      => 'HIT-description',\n    'Hit_len'       => 'HIT-length',\n\n    'Sim4Output_program'   => 'RESULT-algorithm_name',\n    'Sim4Output_query-def' => 'RESULT-query_name',\n    'Sim4Output_query-desc'=> 'RESULT-query_description',\n    'Sim4Output_query-len' => 'RESULT-query_length',\n);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::sim4->new();\n Function: Builds a new Bio::SearchIO::sim4 object\n Returns : an instance of Bio::SearchIO::sim4\n Args    :\n\n\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    # Declare/adjust needed variables\n    $self->{'_last_data'} = '';\n    my ($seentop, $qfull, @hsps, %alignment, $format);\n    my $hit_direction = 1;\n\n    # Start document and main element\n    $self->start_document();\n    $self->start_element({'Name' => 'Sim4Output'});\n    my $lastquery = '';\n    # Read output report until EOF\n    while( defined($_ = $self->_readline) ) {       \n        # Skip empty lines, chomp filled ones\n\tnext if( /^\\s+$/); chomp;\n\n        # Make sure sim4 output format is not 2 or 5\n        if (!$seentop) {\n\t    if ( /^\\#:lav/ ) { $format = 2; }\n            elsif ( /^<|>/ ) { $format = 5; }\n            $self->throw(\"Bio::SearchIO::sim4 module cannot parse 'type $format' outputs.\") if $format;\n\t}\n\n        # This line indicates the start of a new hit\n\tif( /^seq1\\s*=\\s*(\\S+),\\s+(\\d+)/ ) {\n\t    my ($nm,$desc) = ($1,$2);\n            # First hit? Adjust some parameters if so\n\t    if ( ! $seentop ) {\n\t        $self->element( {'Name' => 'Sim4Output_query-def', \n\t\t\t\t 'Data' => $nm} );\n\t        $self->element( {'Name' => 'Sim4Output_query-len', \n\t\t\t\t 'Data' => $desc} );\n                $seentop = 1;\n\t    } elsif( $nm ne $lastquery ) {\n\t\t$self->_pushback($_);\n\t\tlast;\n\t    }\n\t    $lastquery = $nm;\n            # A previous HSP may need to be ended\n            $self->end_element({'Name' => 'Hsp'}) if ( $self->in_element('hsp') );\n            # A previous hit exists? End it and reset needed variables\n            if ( $self->in_element('hit') ) {\n\t        foreach (@hsps) {\n                    $self->start_element({'Name' => 'Hsp'});\n                    while (my ($name, $data) = each %$_) {\n                        $self->{'_currentHSP'}{$name} = $data;\n\t\t    }\n\t\t    $self->end_element({'Name' => 'Hsp'});\n                    $self->{'_currentHSP'} = {};\n\t        }\n                $format = 0 if @hsps;\n                @hsps = ();\n                %alignment = ();\n                $qfull = 0;\n                $hit_direction = 1;\n                $self->end_element({'Name' => 'Hit'});\n\t    }\n\n        # This line describes the current hit... so let's start it\n\t} elsif( /^seq2\\s*=\\s*(\\S+)\\s+\\(>?(\\S+)\\s*\\),\\s*(\\d+)/ ) {\n            $self->start_element({'Name' => 'Hit'});\n\t    $self->element( {'Name' => 'Hit_id', 'Data' => $2} );\n\t    $self->element( {'Name' => 'Hit_desc', 'Data' => $1} );\n\t    $self->element( {'Name' => 'Hit_len', 'Data' => $3} );\n\n        # This line may give additional details about query or subject\n\t} elsif( /^>(\\S+)\\s*(.*)?/ ) {\n            # Previous line was query details... this time subject details\n\t    if( $qfull )  {\n                $format = 4 if !$format;\n\t\t$self->element({'Name' => 'Hit_desc', 'Data' => $2});\n            # First line of this type is always query details for a given hit\n\t    } else { \n\t\t$self->element({'Name' => 'Sim4Output_query-desc', 'Data' => $2});\n\t\t$qfull = 1;\n\t    }\n\n        # This line indicates that subject is on reverse strand\n\t} elsif( /^\\(complement\\)/ ) {\n\t    $hit_direction = -1;\n\n        # This line describes the current HSP... so add it to @hsps array\n\t} elsif( /^\\(?(\\d+)\\-(\\d+)\\)?\\s+\\(?(\\d+)\\-(\\d+)\\)?\\s+(\\d+)/ ) {\n\t\tmy ($qs,$qe,$hs,$he,$pid) = ($1,$2,$3,$4,$5);\n                push @hsps, {\n                    'Hsp_query-from' => $qs,\n                    'Hsp_query-to' => $qe,\n                    'Hsp_hit-from' => $hit_direction >= 0 ? $hs : $he,\n                    'Hsp_hit-to' => $hit_direction >= 0 ? $he : $hs,\n                    'Hsp_identity' => 0, #can't determine correctly from raw pct\n                    'Hsp_qlength' => abs($qe - $qs) + 1,\n                    'Hsp_hlength' => abs($he - $hs) + 1,\n                    'Hsp_align-len' => abs($qe - $qs) + 1,\n\t        };\n\n        # This line indicates the start of an alignment block\n        } elsif( /^\\s+(\\d+)\\s/ ) {\n            # Store the current alignment block in a hash\n\t    for( my $i = 0; defined($_) && $i < 4; $i++ ) {\n                my ($start, $string) = /^\\s+(\\d*)\\s(.*)/;\n                $alignment{$ALIGN_TYPES{$i}} = { start => $start, string => $i != 2\n                    ? $string\n                    : (' ' x (length($alignment{$ALIGN_TYPES{$i-1}}{string}) - length($string))) . $string\n                };\n                $_ = $self->_readline();\n\t    }\n\n            # 'Ruler' line indicates the start of a new HSP\n            if ($alignment{Ruler}{start} == 0) {\n                $format = @hsps ? 3 : 1 if !$format;\n                # A previous HSP may need to be ended\n                $self->end_element({'Name' => 'Hsp'}) if ( $self->in_element('hsp') );\n                # Start the new HSP and fill the '_currentHSP' property with available details\n     \t        $self->start_element({'Name' => 'Hsp'});\n                $self->{'_currentHSP'} = @hsps ? shift @hsps : {\n                    'Hsp_query-from' => $alignment{Query}{start},\n                    'Hsp_hit-from' => $alignment{Sbjct}{start},\n     \t        }\n\t    }\n\n            # Midline indicates a boundary between two HSPs\n\t    if ( $alignment{Mid}{string} =~ /<|>/g ) {\n                my ($hsp_start, $hsp_end);\n                # Are we currently in an open HSP?\n    \t        if ( $self->in_element('hsp') ) {\n                    # Find end pos, adjust 'gaps', 'seq' and 'midline' properties... then close HSP\n                    $hsp_end = (pos $alignment{Mid}{string}) - 1;\n                    $self->{'_currentHSP'}{'Hsp_querygaps'} +=\n                        ($self->{'_currentHSP'}{'Hsp_qseq'} .= substr($alignment{Query}{string}, 0, $hsp_end)) =~ s/ /-/g;\n                    $self->{'_currentHSP'}{'Hsp_hitgaps'} +=\n                        ($self->{'_currentHSP'}{'Hsp_hseq'} .= substr($alignment{Sbjct}{string}, 0, $hsp_end)) =~ s/ /-/g;\n                    ($self->{'_currentHSP'}{'Hsp_midline'} .= substr($alignment{Mid}{string}, 0, $hsp_end)) =~ s/-/ /g;\n                    $self->end_element({'Name' => 'Hsp'});\n\n                    # Does a new HSP start in the current alignment block?\n                    if ( $alignment{Mid}{string} =~ /\\|/g ) {\n                        # Find start pos, start new HSP and fill it with available details\n                        $hsp_start = (pos $alignment{Mid}{string}) - 1;\n                        $self->start_element({'Name' => 'Hsp'});\n                        $self->{'_currentHSP'} = @hsps ? shift @hsps : {};\n                        $self->{'_currentHSP'}{'Hsp_querygaps'} +=\n                            ($self->{'_currentHSP'}{'Hsp_qseq'} = substr($alignment{Query}{string}, $hsp_start)) =~ s/ /-/g;\n                        $self->{'_currentHSP'}{'Hsp_hitgaps'} +=\n                            ($self->{'_currentHSP'}{'Hsp_hseq'} = substr($alignment{Sbjct}{string}, $hsp_start)) =~ s/ /-/g;\n                        ($self->{'_currentHSP'}{'Hsp_midline'} = substr($alignment{Mid}{string}, $hsp_start)) =~ s/-/ /g;\n\t\t    }\n\t\t}\n                # No HSP is currently open...\n                else {\n                    # Find start pos, start new HSP and fill it with available\n                    # details then skip to next alignment block\n\t\t    $hsp_start = index($alignment{Mid}{string}, '|');\n\t            $self->start_element({'Name' => 'Hsp'});\n                    $self->{'_currentHSP'} = @hsps ? shift @hsps : {\n                        'Hsp_query-from' => $alignment{Query}{start},\n    \t            };\n                    $self->{'_currentHSP'}{'Hsp_querygaps'} +=\n                        ($self->{'_currentHSP'}{'Hsp_qseq'} = substr($alignment{Query}{string}, $hsp_start)) =~ s/ /-/g;\n                    $self->{'_currentHSP'}{'Hsp_hitgaps'} +=\n                        ($self->{'_currentHSP'}{'Hsp_hseq'} = substr($alignment{Sbjct}{string}, $hsp_start)) =~ s/ /-/g;\n                    ($self->{'_currentHSP'}{'Hsp_midline'} = substr($alignment{Mid}{string}, $hsp_start)) =~ s/-/ /g;\n                    next;\n\t\t}\n\t    }\n            # Current alignment block does not contain HSPs boundary\n            else {\n                # Start a new HSP if none is currently open\n\t        # (Happens if last boundary finished at the very end of previous block)\n\t        if ( !$self->in_element('hsp') ) {\n     \t            $self->start_element({'Name' => 'Hsp'});\n                    $self->{'_currentHSP'} = @hsps ? shift @hsps : {\n                        'Hsp_query-from' => $alignment{Query}{start},\n                        'Hsp_hit-from' => $alignment{Sbjct}{start},\n     \t            }\n\t\t}\n                # Adjust details of the current HSP\n                $self->{'_currentHSP'}{'Hsp_query-from'} ||= \n\t\t    $alignment{Query}{start} - \n\t\t    length($self->{'_currentHSP'}{'Hsp_qseq'} || '');\n                $self->{'_currentHSP'}{'Hsp_hit-from'} ||= \n\t\t    $alignment{Sbjct}{start} - \n\t\t    length($self->{'_currentHSP'}{'Hsp_hseq'} || '');\n                $self->{'_currentHSP'}{'Hsp_querygaps'} +=\n                    ($self->{'_currentHSP'}{'Hsp_qseq'} .= \n\t\t     $alignment{Query}{string}) =~ s/ /-/g;\n                $self->{'_currentHSP'}{'Hsp_hitgaps'} +=\n                    ($self->{'_currentHSP'}{'Hsp_hseq'} .= \n\t\t     $alignment{Sbjct}{string}) =~ s/ /-/g;\n                ($self->{'_currentHSP'}{'Hsp_midline'} .= \n\t\t $alignment{Mid}{string}) =~ s/-/ /g;\n\t    }\n\t}\n    }\n\n    # We are done reading the sim4 report, end everything and return\n    if( $seentop ) {\n        # end HSP if needed\n        $self->end_element({'Name' => 'Hsp'}) if ( $self->in_element('hsp') );\n        # end Hit if needed\n        if ( $self->in_element('hit') ) {\n            foreach (@hsps) {\n                $self->start_element({'Name' => 'Hsp'});\n                while (my ($name, $data) = each %$_) {\n                    $self->{'_currentHSP'}{$name} = $data;\n    \t        }\n    \t        $self->end_element({'Name' => 'Hsp'});\n            }\n            $self->end_element({'Name' => 'Hit'});\n\t}\n        # adjust result's algorithm name, end output and return\n        $self->element({'Name' => 'Sim4Output_program',\n                        'Data' => $DEFAULTFORMAT . ' (A=' . (defined $format ? $format : '?') . ')'});\n\t$self->end_element({'Name' => 'Sim4Output'});\n\treturn $self->end_document();\n    } \n    return;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n   # we currently don't care about attributes\n   my $nm = $data->{'Name'};\n   my $type = $MODEMAP{$nm};\n\n   if( $type ) {\n       if( $self->_will_handle($type) ) {\n\t   my $func = sprintf(\"start_%s\",lc $type);\n\t   $self->_eventHandler->$func($data->{'Attributes'});\n       }\n       unshift @{$self->{'_elements'}}, $type;\n\n       if($type eq 'result') {\n\t   $self->{'_values'} = {};\n\t   $self->{'_result'}= undef;\n       }\n   }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n    \n    if( $nm eq 'Hsp' ) {\n        $self->{'_currentHSP'}{'Hsp_midline'} ||= '';\n\t$self->{'_currentHSP'}{'Hsp_query-to'} ||=\n            $self->{'_currentHSP'}{'Hsp_query-from'} + length($self->{'_currentHSP'}{'Hsp_qseq'}) - 1 - $self->{'_currentHSP'}{'Hsp_querygaps'};\n        $self->{'_currentHSP'}{'Hsp_hit-to'} ||=\n            $self->{'_currentHSP'}{'Hsp_hit-from'} + length($self->{'_currentHSP'}{'Hsp_hseq'}) - 1 - $self->{'_currentHSP'}{'Hsp_hitgaps'};\n        $self->{'_currentHSP'}{'Hsp_identity'} ||= \n\t    ($self->{'_currentHSP'}{'Hsp_midline'} =~ tr/\\|//);\n        $self->{'_currentHSP'}{'Hsp_qlength'} ||= abs($self->{'_currentHSP'}{'Hsp_query-to'} - $self->{'_currentHSP'}{'Hsp_query-from'}) + 1;\n        $self->{'_currentHSP'}{'Hsp_hlength'} ||= abs($self->{'_currentHSP'}{'Hsp_hit-to'} - $self->{'_currentHSP'}{'Hsp_hit-from'}) + 1;\n        $self->{'_currentHSP'}{'Hsp_align-len'} ||= abs($self->{'_currentHSP'}{'Hsp_query-to'} - $self->{'_currentHSP'}{'Hsp_query-from'}) + 1;\n        $self->{'_currentHSP'}{'Hsp_score'} ||= int(100 * ($self->{'_currentHSP'}{'Hsp_identity'} / $self->{'_currentHSP'}{'Hsp_align-len'}));\n        foreach (keys %{$self->{'_currentHSP'}}) {\n            $self->element({'Name' => $_, 'Data' => delete ${$self->{'_currentHSP'}}{$_}});\n\t}\n    }\n\n    if( $type = $MODEMAP{$nm} ) {\n\tif( $self->_will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) {\n\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else {\n\t$self->debug( \"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at\n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;\n   return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/ );\n   \n   if( $self->in_element('hsp') && \n       $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ ) {\n       $self->{'_last_hspdata'}->{$data->{'Name'}} .= $data->{'Data'};\n   }  \n\n   $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name\n\n\n\nsub within_element{\n   my ($self,$name) = @_;\n   return 0 if ( ! defined $name &&\n\t\t ! defined  $self->{'_elements'} ||\n\t\t scalar @{$self->{'_elements'}} == 0) ;\n   foreach (  @{$self->{'_elements'}} ) {\n       if( $_ eq $name  ) {\n\t   return 1;\n       }\n   }\n   return 0;\n}\n\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name\n\n\n\nsub in_element{\n   my ($self,$name) = @_;\n   return 0 if ! defined $self->{'_elements'}->[0];\n   return ( $self->{'_elements'}->[0] eq $name)\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handle a start document event\n Returns : none\n Args    : none\n\n\n\nsub start_document{\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'} = {};\n    $self->{'_result'}= undef;\n    $self->{'_elements'} = [];\n    $self->{'_reporttype'} = $DEFAULTFORMAT;\n}\n\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $eventgenerator->end_document\n Function: Handles an end document event\n Returns : Bio::Search::Result::ResultI object\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}]},"range":{"start":{"line":597,"character":0},"end":{"character":9999,"line":600}},"kind":12,"line":597},{"signature":{"parameters":[{"label":"$self"},{"label":"$blast"},{"label":"@args"}],"documentation":"","label":"write_result($self,$blast,@args)"},"range":{"end":{"character":9999,"line":611},"start":{"character":0,"line":603}},"kind":12,"line":603,"detail":"($self,$blast,@args)","definition":"sub","name":"write_result","containerName":"main::","children":[{"line":604,"name":"$self","containerName":"write_result","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"write_result","name":"$blast","line":604},{"line":604,"kind":13,"containerName":"write_result","name":"@args"},{"line":606,"containerName":"write_result","kind":13,"name":"$self"},{"line":606,"containerName":"write_result","kind":12,"name":"writer"},{"name":"$self","kind":13,"containerName":"write_result","line":607},{"line":607,"kind":12,"containerName":"write_result","name":"warn"},{"name":"$self","containerName":"write_result","kind":13,"line":608},{"name":"writer","containerName":"write_result","kind":12,"line":608},{"line":608,"kind":13,"containerName":"write_result","name":"$DEFAULT_WRITER_CLASS"},{"name":"new","kind":12,"containerName":"write_result","line":608},{"containerName":"write_result","kind":13,"name":"$self","line":610},{"line":610,"kind":13,"containerName":"write_result","name":"$blast"},{"containerName":"write_result","kind":13,"name":"@args","line":610}]},{"line":610,"containerName":"write_result","kind":12,"name":"SUPER"},{"children":[],"containerName":"main::","name":"result_count","definition":"sub","line":613,"kind":12,"range":{"end":{"line":615,"character":9999},"start":{"line":613,"character":0}}},{"name":"report_count","containerName":"main::","children":[{"line":617,"name":"result_count","containerName":"report_count","kind":12}],"definition":"sub","kind":12,"range":{"end":{"character":9999,"line":617},"start":{"character":0,"line":617}},"line":617},{"signature":{"parameters":[{"label":"$self"},{"label":"$type"}],"documentation":"1;\n# $Id: sim4.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::sim4\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::sim4 - parser for Sim4 alignments\n\n=head1 SYNOPSIS\n\n  # do not use this module directly, it is a driver for SearchIO\n  use Bio::SearchIO;\n  my $searchio = Bio::SearchIO->new(-file => 'results.sim4',\n                                   -format => 'sim4');\n\n  while ( my $result = $searchio->next_result ) {\n      while ( my $hit = $result->next_hit ) {\n\t  while ( my $hsp = $hit->next_hsp ) {\n              # ...\n\t  }\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis is a driver for the SearchIO system for parsing Sim4.\nhttp://globin.cse.psu.edu/html/docs/sim4.html\n\nCannot parse LAV or 'exon file' formats (A=2 or A=5)\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nLuc Gauthier (lgauthie@hotmail.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::sim4;\n\nuse strict;\nuse vars qw($DEFAULTFORMAT %ALIGN_TYPES\n            %MAPPING %MODEMAP $DEFAULT_WRITER_CLASS);\n\nuse POSIX;\nuse Bio::SearchIO::SearchResultEventBuilder;\n\nuse base qw(Bio::SearchIO);\n\n$DEFAULTFORMAT = 'SIM4';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n%ALIGN_TYPES = (\n    0 => 'Ruler',\n    1 => 'Query', \n    2 => 'Mid', \n    3 => 'Sbjct'\n);\n\n%MODEMAP = (\n    'Sim4Output' => 'result',\n    'Hit'        => 'hit',\n    'Hsp'        => 'hsp'\n);\n\n%MAPPING = (\n    'Hsp_query-from'=>  'HSP-query_start',\n    'Hsp_query-to'  =>  'HSP-query_end',\n    'Hsp_qseq'      =>  'HSP-query_seq',\n    'Hsp_qlength'   =>  'HSP-query_length',\n    'Hsp_querygaps'  => 'HSP-query_gaps',\n    'Hsp_hit-from'  =>  'HSP-hit_start',\n    'Hsp_hit-to'    =>  'HSP-hit_end',\n    'Hsp_hseq'      =>  'HSP-hit_seq',\n    'Hsp_hlength'   =>  'HSP-hit_length',\n    'Hsp_hitgaps'    => 'HSP-hit_gaps',\n    'Hsp_midline'   =>  'HSP-homology_seq',\n    'Hsp_score'     =>  'HSP-score',\n    'Hsp_align-len' =>  'HSP-hsp_length',\n    'Hsp_identity'  =>  'HSP-identical',\n\n    'Hit_id'        => 'HIT-name',\n    'Hit_desc'      => 'HIT-description',\n    'Hit_len'       => 'HIT-length',\n\n    'Sim4Output_program'   => 'RESULT-algorithm_name',\n    'Sim4Output_query-def' => 'RESULT-query_name',\n    'Sim4Output_query-desc'=> 'RESULT-query_description',\n    'Sim4Output_query-len' => 'RESULT-query_length',\n);\n\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::sim4->new();\n Function: Builds a new Bio::SearchIO::sim4 object\n Returns : an instance of Bio::SearchIO::sim4\n Args    :\n\n\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n\n    # Declare/adjust needed variables\n    $self->{'_last_data'} = '';\n    my ($seentop, $qfull, @hsps, %alignment, $format);\n    my $hit_direction = 1;\n\n    # Start document and main element\n    $self->start_document();\n    $self->start_element({'Name' => 'Sim4Output'});\n    my $lastquery = '';\n    # Read output report until EOF\n    while( defined($_ = $self->_readline) ) {       \n        # Skip empty lines, chomp filled ones\n\tnext if( /^\\s+$/); chomp;\n\n        # Make sure sim4 output format is not 2 or 5\n        if (!$seentop) {\n\t    if ( /^\\#:lav/ ) { $format = 2; }\n            elsif ( /^<|>/ ) { $format = 5; }\n            $self->throw(\"Bio::SearchIO::sim4 module cannot parse 'type $format' outputs.\") if $format;\n\t}\n\n        # This line indicates the start of a new hit\n\tif( /^seq1\\s*=\\s*(\\S+),\\s+(\\d+)/ ) {\n\t    my ($nm,$desc) = ($1,$2);\n            # First hit? Adjust some parameters if so\n\t    if ( ! $seentop ) {\n\t        $self->element( {'Name' => 'Sim4Output_query-def', \n\t\t\t\t 'Data' => $nm} );\n\t        $self->element( {'Name' => 'Sim4Output_query-len', \n\t\t\t\t 'Data' => $desc} );\n                $seentop = 1;\n\t    } elsif( $nm ne $lastquery ) {\n\t\t$self->_pushback($_);\n\t\tlast;\n\t    }\n\t    $lastquery = $nm;\n            # A previous HSP may need to be ended\n            $self->end_element({'Name' => 'Hsp'}) if ( $self->in_element('hsp') );\n            # A previous hit exists? End it and reset needed variables\n            if ( $self->in_element('hit') ) {\n\t        foreach (@hsps) {\n                    $self->start_element({'Name' => 'Hsp'});\n                    while (my ($name, $data) = each %$_) {\n                        $self->{'_currentHSP'}{$name} = $data;\n\t\t    }\n\t\t    $self->end_element({'Name' => 'Hsp'});\n                    $self->{'_currentHSP'} = {};\n\t        }\n                $format = 0 if @hsps;\n                @hsps = ();\n                %alignment = ();\n                $qfull = 0;\n                $hit_direction = 1;\n                $self->end_element({'Name' => 'Hit'});\n\t    }\n\n        # This line describes the current hit... so let's start it\n\t} elsif( /^seq2\\s*=\\s*(\\S+)\\s+\\(>?(\\S+)\\s*\\),\\s*(\\d+)/ ) {\n            $self->start_element({'Name' => 'Hit'});\n\t    $self->element( {'Name' => 'Hit_id', 'Data' => $2} );\n\t    $self->element( {'Name' => 'Hit_desc', 'Data' => $1} );\n\t    $self->element( {'Name' => 'Hit_len', 'Data' => $3} );\n\n        # This line may give additional details about query or subject\n\t} elsif( /^>(\\S+)\\s*(.*)?/ ) {\n            # Previous line was query details... this time subject details\n\t    if( $qfull )  {\n                $format = 4 if !$format;\n\t\t$self->element({'Name' => 'Hit_desc', 'Data' => $2});\n            # First line of this type is always query details for a given hit\n\t    } else { \n\t\t$self->element({'Name' => 'Sim4Output_query-desc', 'Data' => $2});\n\t\t$qfull = 1;\n\t    }\n\n        # This line indicates that subject is on reverse strand\n\t} elsif( /^\\(complement\\)/ ) {\n\t    $hit_direction = -1;\n\n        # This line describes the current HSP... so add it to @hsps array\n\t} elsif( /^\\(?(\\d+)\\-(\\d+)\\)?\\s+\\(?(\\d+)\\-(\\d+)\\)?\\s+(\\d+)/ ) {\n\t\tmy ($qs,$qe,$hs,$he,$pid) = ($1,$2,$3,$4,$5);\n                push @hsps, {\n                    'Hsp_query-from' => $qs,\n                    'Hsp_query-to' => $qe,\n                    'Hsp_hit-from' => $hit_direction >= 0 ? $hs : $he,\n                    'Hsp_hit-to' => $hit_direction >= 0 ? $he : $hs,\n                    'Hsp_identity' => 0, #can't determine correctly from raw pct\n                    'Hsp_qlength' => abs($qe - $qs) + 1,\n                    'Hsp_hlength' => abs($he - $hs) + 1,\n                    'Hsp_align-len' => abs($qe - $qs) + 1,\n\t        };\n\n        # This line indicates the start of an alignment block\n        } elsif( /^\\s+(\\d+)\\s/ ) {\n            # Store the current alignment block in a hash\n\t    for( my $i = 0; defined($_) && $i < 4; $i++ ) {\n                my ($start, $string) = /^\\s+(\\d*)\\s(.*)/;\n                $alignment{$ALIGN_TYPES{$i}} = { start => $start, string => $i != 2\n                    ? $string\n                    : (' ' x (length($alignment{$ALIGN_TYPES{$i-1}}{string}) - length($string))) . $string\n                };\n                $_ = $self->_readline();\n\t    }\n\n            # 'Ruler' line indicates the start of a new HSP\n            if ($alignment{Ruler}{start} == 0) {\n                $format = @hsps ? 3 : 1 if !$format;\n                # A previous HSP may need to be ended\n                $self->end_element({'Name' => 'Hsp'}) if ( $self->in_element('hsp') );\n                # Start the new HSP and fill the '_currentHSP' property with available details\n     \t        $self->start_element({'Name' => 'Hsp'});\n                $self->{'_currentHSP'} = @hsps ? shift @hsps : {\n                    'Hsp_query-from' => $alignment{Query}{start},\n                    'Hsp_hit-from' => $alignment{Sbjct}{start},\n     \t        }\n\t    }\n\n            # Midline indicates a boundary between two HSPs\n\t    if ( $alignment{Mid}{string} =~ /<|>/g ) {\n                my ($hsp_start, $hsp_end);\n                # Are we currently in an open HSP?\n    \t        if ( $self->in_element('hsp') ) {\n                    # Find end pos, adjust 'gaps', 'seq' and 'midline' properties... then close HSP\n                    $hsp_end = (pos $alignment{Mid}{string}) - 1;\n                    $self->{'_currentHSP'}{'Hsp_querygaps'} +=\n                        ($self->{'_currentHSP'}{'Hsp_qseq'} .= substr($alignment{Query}{string}, 0, $hsp_end)) =~ s/ /-/g;\n                    $self->{'_currentHSP'}{'Hsp_hitgaps'} +=\n                        ($self->{'_currentHSP'}{'Hsp_hseq'} .= substr($alignment{Sbjct}{string}, 0, $hsp_end)) =~ s/ /-/g;\n                    ($self->{'_currentHSP'}{'Hsp_midline'} .= substr($alignment{Mid}{string}, 0, $hsp_end)) =~ s/-/ /g;\n                    $self->end_element({'Name' => 'Hsp'});\n\n                    # Does a new HSP start in the current alignment block?\n                    if ( $alignment{Mid}{string} =~ /\\|/g ) {\n                        # Find start pos, start new HSP and fill it with available details\n                        $hsp_start = (pos $alignment{Mid}{string}) - 1;\n                        $self->start_element({'Name' => 'Hsp'});\n                        $self->{'_currentHSP'} = @hsps ? shift @hsps : {};\n                        $self->{'_currentHSP'}{'Hsp_querygaps'} +=\n                            ($self->{'_currentHSP'}{'Hsp_qseq'} = substr($alignment{Query}{string}, $hsp_start)) =~ s/ /-/g;\n                        $self->{'_currentHSP'}{'Hsp_hitgaps'} +=\n                            ($self->{'_currentHSP'}{'Hsp_hseq'} = substr($alignment{Sbjct}{string}, $hsp_start)) =~ s/ /-/g;\n                        ($self->{'_currentHSP'}{'Hsp_midline'} = substr($alignment{Mid}{string}, $hsp_start)) =~ s/-/ /g;\n\t\t    }\n\t\t}\n                # No HSP is currently open...\n                else {\n                    # Find start pos, start new HSP and fill it with available\n                    # details then skip to next alignment block\n\t\t    $hsp_start = index($alignment{Mid}{string}, '|');\n\t            $self->start_element({'Name' => 'Hsp'});\n                    $self->{'_currentHSP'} = @hsps ? shift @hsps : {\n                        'Hsp_query-from' => $alignment{Query}{start},\n    \t            };\n                    $self->{'_currentHSP'}{'Hsp_querygaps'} +=\n                        ($self->{'_currentHSP'}{'Hsp_qseq'} = substr($alignment{Query}{string}, $hsp_start)) =~ s/ /-/g;\n                    $self->{'_currentHSP'}{'Hsp_hitgaps'} +=\n                        ($self->{'_currentHSP'}{'Hsp_hseq'} = substr($alignment{Sbjct}{string}, $hsp_start)) =~ s/ /-/g;\n                    ($self->{'_currentHSP'}{'Hsp_midline'} = substr($alignment{Mid}{string}, $hsp_start)) =~ s/-/ /g;\n                    next;\n\t\t}\n\t    }\n            # Current alignment block does not contain HSPs boundary\n            else {\n                # Start a new HSP if none is currently open\n\t        # (Happens if last boundary finished at the very end of previous block)\n\t        if ( !$self->in_element('hsp') ) {\n     \t            $self->start_element({'Name' => 'Hsp'});\n                    $self->{'_currentHSP'} = @hsps ? shift @hsps : {\n                        'Hsp_query-from' => $alignment{Query}{start},\n                        'Hsp_hit-from' => $alignment{Sbjct}{start},\n     \t            }\n\t\t}\n                # Adjust details of the current HSP\n                $self->{'_currentHSP'}{'Hsp_query-from'} ||= \n\t\t    $alignment{Query}{start} - \n\t\t    length($self->{'_currentHSP'}{'Hsp_qseq'} || '');\n                $self->{'_currentHSP'}{'Hsp_hit-from'} ||= \n\t\t    $alignment{Sbjct}{start} - \n\t\t    length($self->{'_currentHSP'}{'Hsp_hseq'} || '');\n                $self->{'_currentHSP'}{'Hsp_querygaps'} +=\n                    ($self->{'_currentHSP'}{'Hsp_qseq'} .= \n\t\t     $alignment{Query}{string}) =~ s/ /-/g;\n                $self->{'_currentHSP'}{'Hsp_hitgaps'} +=\n                    ($self->{'_currentHSP'}{'Hsp_hseq'} .= \n\t\t     $alignment{Sbjct}{string}) =~ s/ /-/g;\n                ($self->{'_currentHSP'}{'Hsp_midline'} .= \n\t\t $alignment{Mid}{string}) =~ s/-/ /g;\n\t    }\n\t}\n    }\n\n    # We are done reading the sim4 report, end everything and return\n    if( $seentop ) {\n        # end HSP if needed\n        $self->end_element({'Name' => 'Hsp'}) if ( $self->in_element('hsp') );\n        # end Hit if needed\n        if ( $self->in_element('hit') ) {\n            foreach (@hsps) {\n                $self->start_element({'Name' => 'Hsp'});\n                while (my ($name, $data) = each %$_) {\n                    $self->{'_currentHSP'}{$name} = $data;\n    \t        }\n    \t        $self->end_element({'Name' => 'Hsp'});\n            }\n            $self->end_element({'Name' => 'Hit'});\n\t}\n        # adjust result's algorithm name, end output and return\n        $self->element({'Name' => 'Sim4Output_program',\n                        'Data' => $DEFAULTFORMAT . ' (A=' . (defined $format ? $format : '?') . ')'});\n\t$self->end_element({'Name' => 'Sim4Output'});\n\treturn $self->end_document();\n    } \n    return;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n   # we currently don't care about attributes\n   my $nm = $data->{'Name'};\n   my $type = $MODEMAP{$nm};\n\n   if( $type ) {\n       if( $self->_will_handle($type) ) {\n\t   my $func = sprintf(\"start_%s\",lc $type);\n\t   $self->_eventHandler->$func($data->{'Attributes'});\n       }\n       unshift @{$self->{'_elements'}}, $type;\n\n       if($type eq 'result') {\n\t   $self->{'_values'} = {};\n\t   $self->{'_result'}= undef;\n       }\n   }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n    \n    if( $nm eq 'Hsp' ) {\n        $self->{'_currentHSP'}{'Hsp_midline'} ||= '';\n\t$self->{'_currentHSP'}{'Hsp_query-to'} ||=\n            $self->{'_currentHSP'}{'Hsp_query-from'} + length($self->{'_currentHSP'}{'Hsp_qseq'}) - 1 - $self->{'_currentHSP'}{'Hsp_querygaps'};\n        $self->{'_currentHSP'}{'Hsp_hit-to'} ||=\n            $self->{'_currentHSP'}{'Hsp_hit-from'} + length($self->{'_currentHSP'}{'Hsp_hseq'}) - 1 - $self->{'_currentHSP'}{'Hsp_hitgaps'};\n        $self->{'_currentHSP'}{'Hsp_identity'} ||= \n\t    ($self->{'_currentHSP'}{'Hsp_midline'} =~ tr/\\|//);\n        $self->{'_currentHSP'}{'Hsp_qlength'} ||= abs($self->{'_currentHSP'}{'Hsp_query-to'} - $self->{'_currentHSP'}{'Hsp_query-from'}) + 1;\n        $self->{'_currentHSP'}{'Hsp_hlength'} ||= abs($self->{'_currentHSP'}{'Hsp_hit-to'} - $self->{'_currentHSP'}{'Hsp_hit-from'}) + 1;\n        $self->{'_currentHSP'}{'Hsp_align-len'} ||= abs($self->{'_currentHSP'}{'Hsp_query-to'} - $self->{'_currentHSP'}{'Hsp_query-from'}) + 1;\n        $self->{'_currentHSP'}{'Hsp_score'} ||= int(100 * ($self->{'_currentHSP'}{'Hsp_identity'} / $self->{'_currentHSP'}{'Hsp_align-len'}));\n        foreach (keys %{$self->{'_currentHSP'}}) {\n            $self->element({'Name' => $_, 'Data' => delete ${$self->{'_currentHSP'}}{$_}});\n\t}\n    }\n\n    if( $type = $MODEMAP{$nm} ) {\n\tif( $self->_will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) {\n\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else {\n\t$self->debug( \"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at\n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;\n   return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/ );\n   \n   if( $self->in_element('hsp') && \n       $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ ) {\n       $self->{'_last_hspdata'}->{$data->{'Name'}} .= $data->{'Data'};\n   }  \n\n   $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name\n\n\n\nsub within_element{\n   my ($self,$name) = @_;\n   return 0 if ( ! defined $name &&\n\t\t ! defined  $self->{'_elements'} ||\n\t\t scalar @{$self->{'_elements'}} == 0) ;\n   foreach (  @{$self->{'_elements'}} ) {\n       if( $_ eq $name  ) {\n\t   return 1;\n       }\n   }\n   return 0;\n}\n\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name\n\n\n\nsub in_element{\n   my ($self,$name) = @_;\n   return 0 if ! defined $self->{'_elements'}->[0];\n   return ( $self->{'_elements'}->[0] eq $name)\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handle a start document event\n Returns : none\n Args    : none\n\n\n\nsub start_document{\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'} = {};\n    $self->{'_result'}= undef;\n    $self->{'_elements'} = [];\n    $self->{'_reporttype'} = $DEFAULTFORMAT;\n}\n\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $eventgenerator->end_document\n Function: Handles an end document event\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\n\nsub end_document{\n   my ($self,@args) = @_;\n   return $self->{'_result'};\n}\n\n\nsub write_result {\n   my ($self, $blast, @args) = @_;\n\n   if( not defined($self->writer) ) {\n       $self->warn(\"Writer not defined. Using a $DEFAULT_WRITER_CLASS\");\n       $self->writer( $DEFAULT_WRITER_CLASS->new() );\n   }\n   $self->SUPER::write_result( $blast, @args );\n}\n\nsub result_count {\n    return 1; # can a sim4 report contain more than one result?\n}\n\nsub report_count { shift->result_count }\n\n=head2 _will_handle\n\n Title   : _will_handle\n Usage   : Private method. For internal use only.\n              if( $self->_will_handle($type) ) { ... }\n Function: Provides an optimized way to check whether or not an element of a \n           given type is to be handled.\n Returns : Reference to EventHandler object if the element type is to be handled.\n           undef if the element type is not to be handled.\n Args    : string containing type of element.\n\nOptimizations:\n\n  1. Using the cached pointer to the EventHandler to minimize repeated lookups.\n  2. Caching the will_handle status for each type that is encountered\n     so that it only need be checked by calling handler->will_handle($type) once.\n\nThis does not lead to a major savings by itself (only 5-10%).\nIn combination with other optimizations, or for large parse jobs, the\nsavings good be significant.\n\nTo test against the unoptimized version, remove the parentheses from\naround the third term in the ternary \" ? : \" operator and add two\ncalls to $self-E<gt>_eventHandler().","label":"_will_handle($self,$type)"},"range":{"start":{"line":646,"character":0},"end":{"character":9999,"line":656}},"kind":12,"line":646,"detail":"($self,$type)","definition":"sub","containerName":"main::","name":"_will_handle","children":[{"localvar":"my","kind":13,"containerName":"_will_handle","name":"$self","line":647,"definition":"my"},{"line":647,"name":"$type","kind":13,"containerName":"_will_handle"},{"definition":"my","localvar":"my","kind":13,"containerName":"_will_handle","name":"$handler","line":648},{"containerName":"_will_handle","kind":13,"name":"$self","line":648},{"containerName":"_will_handle","kind":13,"name":"$self","line":648},{"kind":12,"containerName":"_will_handle","name":"_eventHandler","line":648},{"name":"$will_handle","localvar":"my","kind":13,"containerName":"_will_handle","line":650,"definition":"my"},{"containerName":"_will_handle","kind":13,"name":"$self","line":650},{"line":650,"name":"$type","containerName":"_will_handle","kind":13},{"containerName":"_will_handle","kind":13,"name":"$self","line":651},{"containerName":"_will_handle","kind":13,"name":"$type","line":651},{"name":"$self","containerName":"_will_handle","kind":13,"line":652},{"line":652,"name":"$type","containerName":"_will_handle","kind":13},{"name":"$handler","containerName":"_will_handle","kind":13,"line":653},{"kind":12,"containerName":"_will_handle","name":"will_handle","line":653},{"line":653,"name":"$type","kind":13,"containerName":"_will_handle"},{"line":655,"name":"$will_handle","kind":13,"containerName":"_will_handle"},{"line":655,"name":"$handler","containerName":"_will_handle","kind":13}]}]}