{"version":5,"vars":[{"containerName":"","kind":2,"name":"base","line":75},{"name":"%MODEMAP","kind":13,"localvar":"my","containerName":null,"line":77,"definition":"my"},{"name":"%MAPPING","localvar":"my","kind":13,"containerName":null,"line":83,"definition":"my"},{"definition":"my","line":125,"name":"@VALID_SYMBOLS","localvar":"my","kind":13,"containerName":null},{"localvar":"my","containerName":null,"kind":13,"name":"%STRUCTURE_SYMBOLS","line":126,"definition":"my"},{"definition":"my","line":134,"localvar":"my","kind":13,"containerName":null,"name":"$DEFAULT_VERSION"},{"line":154,"kind":12,"range":{"start":{"character":0,"line":154},"end":{"character":9999,"line":199}},"signature":{"label":"_initialize($self,@args)","documentation":"1;\n# $Id: rnamotif.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::rnamotif\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::rnamotif - SearchIO-based RNAMotif parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is a highly experimental SearchIO-based parser for output from the rnamotif\nprogram (one of the programs in the RNAMotif suite). It currently parses only\nraw rnamotif output for RNAMotif versions 3.0 and above; older versions may work\nbut will not be supported. rmfmt output will not be supported at this time.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::rnamotif;\nuse strict;\n\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        # commented out tags have not been assigned\n        \n        'Hsp_score'        => 'HSP-score',\n        'Hsp_custom-data'  => 'HSP-custom_score',\n        \n        # rnamotif has no evalue\n        \n        # descriptor has no start, end; same as hit start, end\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', \n        'Hsp_hit-to'      => 'HSP-hit_end',\n        \n        # descriptor has no start, end\n        \n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        \n        # build this from scratch, simple WUSS-format\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_stranded'    => 'HSP-stranded',        \n        \n        # not supported for RNAMotif\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_def'       => 'HIT-description',\n        'Hit_score'     => 'HIT-score', # best HSP score\n \n        'RNAMotif_program'  => 'RESULT-algorithm_name', # get/set \n        'RNAMotif_version'  => 'RESULT-algorithm_version', # get/set \n        'RNAMotif_query-def'=> 'RESULT-query_name', # get/set\n        # No length (query is a descriptor)\n        'RNAMotif_query-acc'=> 'RESULT-query_accession', # get/set \n        'RNAMotif_querydesc'=> 'RESULT-query_description', # get/set\n        'RNAMotif_db'       => 'RESULT-database_name',  # get/set \n\t     );\n\n# use structure_delimiters to set custom delimiters\n\nmy @VALID_SYMBOLS = qw(5-prime 3-prime single-strand unknown);\nmy %STRUCTURE_SYMBOLS = (\n                   '5-prime'        => '<',\n                   '3-prime'        => '>',\n                   'single-strand'  => '.',\n                   'unknown'        => '?'\n                    # may add more for quartets, triplets\n                  );\n\nmy $DEFAULT_VERSION = '3.0.3';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO::rnamotif object \n Returns : Bio::SearchIO::rnamotif parser\n Args    : -fh/-file     => RNAMotif filename\n           -format       => 'rnamotif'\n           -model        => query model (or descriptor, in this case)\n           -database     => database name (default undef)\n           -query_acc    => query accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -hsp_maxscore => maximum HSP score cutoff\n           -symbols      => hash ref of structure symbols to use\n                            (default symbols in %STRUCTURE_SYMBOLS hash)","parameters":[{"label":"$self"},{"label":"@args"}]},"children":[{"line":155,"name":"$self","localvar":"my","kind":13,"containerName":"_initialize","definition":"my"},{"line":155,"containerName":"_initialize","kind":13,"name":"@args"},{"kind":13,"containerName":"_initialize","name":"$self","line":156},{"line":156,"name":"@args","kind":13,"containerName":"_initialize"},{"containerName":"_initialize","localvar":"my","kind":13,"name":"$version","line":157,"definition":"my"},{"kind":13,"containerName":"_initialize","name":"$model","line":157},{"line":157,"name":"$database","containerName":"_initialize","kind":13},{"line":157,"name":"$maxcutoff","containerName":"_initialize","kind":13},{"name":"$mincutoff","containerName":"_initialize","kind":13,"line":157},{"line":157,"kind":13,"containerName":"_initialize","name":"$seqdistance"},{"line":158,"name":"$accession","kind":13,"containerName":"_initialize"},{"line":158,"kind":13,"containerName":"_initialize","name":"$symbols"},{"name":"$self","kind":13,"containerName":"_initialize","line":159},{"line":159,"containerName":"_initialize","kind":12,"name":"_rearrange"},{"kind":13,"containerName":"_initialize","name":"@args","line":160},{"line":161,"name":"$handler","kind":13,"localvar":"my","containerName":"_initialize","definition":"my"},{"kind":13,"containerName":"_initialize","name":"$self","line":161},{"line":161,"name":"_eventHandler","kind":12,"containerName":"_initialize"},{"line":162,"kind":13,"containerName":"_initialize","name":"$handler"},{"name":"register_factory","kind":12,"containerName":"_initialize","line":162},{"name":"new","containerName":"_initialize","kind":12,"line":164},{"containerName":"_initialize","kind":13,"name":"$self","line":167},{"name":"verbose","containerName":"_initialize","kind":12,"line":168},{"line":171,"kind":13,"containerName":"_initialize","name":"$handler"},{"line":171,"containerName":"_initialize","kind":12,"name":"register_factory"},{"kind":12,"containerName":"_initialize","name":"new","line":173},{"line":176,"name":"$self","containerName":"_initialize","kind":13},{"line":177,"name":"verbose","kind":12,"containerName":"_initialize"},{"name":"$handler","containerName":"_initialize","kind":13,"line":180},{"line":180,"kind":12,"containerName":"_initialize","name":"register_factory"},{"line":182,"name":"new","kind":12,"containerName":"_initialize"},{"line":185,"name":"$self","containerName":"_initialize","kind":13},{"line":186,"kind":12,"containerName":"_initialize","name":"verbose"},{"line":188,"name":"$model","kind":13,"containerName":"_initialize"},{"line":188,"name":"$self","kind":13,"containerName":"_initialize"},{"name":"model","containerName":"_initialize","kind":12,"line":188},{"line":188,"name":"$model","containerName":"_initialize","kind":13},{"line":189,"containerName":"_initialize","kind":13,"name":"$database"},{"line":189,"name":"$self","containerName":"_initialize","kind":13},{"kind":12,"containerName":"_initialize","name":"database","line":189},{"line":189,"name":"$database","containerName":"_initialize","kind":13},{"kind":13,"containerName":"_initialize","name":"$accession","line":190},{"line":190,"name":"$self","kind":13,"containerName":"_initialize"},{"name":"query_accession","containerName":"_initialize","kind":12,"line":190},{"line":190,"name":"$accession","kind":13,"containerName":"_initialize"},{"line":191,"kind":13,"containerName":"_initialize","name":"$version"},{"line":191,"containerName":"_initialize","kind":13,"name":"$DEFAULT_VERSION"},{"name":"$self","containerName":"_initialize","kind":13,"line":192},{"line":192,"containerName":"_initialize","kind":12,"name":"algorithm_version"},{"containerName":"_initialize","kind":13,"name":"$version","line":192},{"line":193,"name":"$self","kind":13,"containerName":"_initialize"},{"line":193,"name":"throw","kind":12,"containerName":"_initialize"},{"kind":13,"containerName":"_initialize","name":"$mincutoff","line":194},{"name":"$maxcutoff","containerName":"_initialize","kind":13,"line":194},{"name":"$mincutoff","containerName":"_initialize","kind":13,"line":195},{"line":195,"kind":13,"containerName":"_initialize","name":"$self"},{"line":195,"kind":12,"containerName":"_initialize","name":"hsp_minscore"},{"line":195,"name":"$mincutoff","containerName":"_initialize","kind":13},{"line":196,"containerName":"_initialize","kind":13,"name":"$maxcutoff"},{"name":"$self","kind":13,"containerName":"_initialize","line":196},{"name":"hsp_maxscore","kind":12,"containerName":"_initialize","line":196},{"line":196,"containerName":"_initialize","kind":13,"name":"$maxcutoff"},{"line":197,"kind":13,"containerName":"_initialize","name":"$symbols"},{"line":197,"containerName":"_initialize","kind":13,"name":"%STRUCTURE_SYMBOLS"},{"kind":13,"containerName":"_initialize","name":"$self","line":198},{"line":198,"kind":12,"containerName":"_initialize","name":"structure_symbols"},{"line":198,"containerName":"_initialize","kind":13,"name":"$symbols"}],"name":"_initialize","containerName":"main::","definition":"sub","detail":"($self,@args)"},{"line":156,"name":"SUPER","containerName":"_initialize","kind":12},{"line":164,"name":"Bio","containerName":"Factory::ObjectFactory","kind":12},{"line":173,"kind":12,"containerName":"Factory::ObjectFactory","name":"Bio"},{"containerName":"Factory::ObjectFactory","kind":12,"name":"Bio","line":182},{"name":"next_result","containerName":"main::","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"next_result","line":212},{"name":"$seentop","kind":13,"localvar":"my","containerName":"next_result","line":213,"definition":"my"},{"name":"$rm","kind":13,"localvar":"my","containerName":"next_result","line":216,"definition":"my"},{"kind":13,"containerName":"next_result","name":"$d","line":216},{"line":216,"name":"$descriptor","kind":13,"containerName":"next_result"},{"name":"$file","containerName":"next_result","kind":13,"line":216},{"containerName":"next_result","kind":13,"name":"$oktobuild","line":216},{"definition":"my","line":217,"name":"$hitid","localvar":"my","containerName":"next_result","kind":13},{"line":217,"name":"$hitdesc","kind":13,"containerName":"next_result"},{"line":217,"name":"$hspid","containerName":"next_result","kind":13},{"name":"$lastid","kind":13,"containerName":"next_result","line":217},{"name":"$lastscore","kind":13,"containerName":"next_result","line":217},{"line":218,"name":"$sprintf","containerName":"next_result","localvar":"my","kind":13,"definition":"my"},{"definition":"my","containerName":"next_result","localvar":"my","kind":13,"name":"$accession","line":221},{"name":"$db","containerName":"next_result","kind":13,"line":221},{"line":221,"name":"$model","kind":13,"containerName":"next_result"},{"line":222,"name":"$self","containerName":"next_result","kind":13},{"line":222,"name":"query_accession","kind":12,"containerName":"next_result"},{"name":"$self","kind":13,"containerName":"next_result","line":222},{"kind":12,"containerName":"next_result","name":"database","line":222},{"containerName":"next_result","kind":13,"name":"$self","line":222},{"line":222,"containerName":"next_result","kind":12,"name":"model"},{"definition":"my","line":224,"name":"$hsp_min","containerName":"next_result","localvar":"my","kind":13},{"line":224,"name":"$self","containerName":"next_result","kind":13},{"kind":12,"containerName":"next_result","name":"hsp_minscore","line":224},{"definition":"my","line":225,"name":"$hsp_max","localvar":"my","containerName":"next_result","kind":13},{"line":225,"name":"$self","containerName":"next_result","kind":13},{"line":225,"kind":12,"containerName":"next_result","name":"hsp_maxscore"},{"line":226,"kind":13,"localvar":"my","containerName":"next_result","name":"$version","definition":"my"},{"containerName":"next_result","kind":13,"name":"$self","line":226},{"name":"algorithm_version","containerName":"next_result","kind":12,"line":226},{"line":227,"name":"$laststart","kind":13,"localvar":"my","containerName":"next_result","definition":"my"},{"localvar":"my","containerName":"next_result","kind":13,"name":"$verbose","line":229,"definition":"my"},{"name":"$self","containerName":"next_result","kind":13,"line":229},{"line":229,"kind":12,"containerName":"next_result","name":"verbose"},{"line":230,"containerName":"next_result","kind":13,"name":"$self"},{"name":"start_document","kind":12,"containerName":"next_result","line":230},{"definition":"my","localvar":"my","containerName":"next_result","kind":13,"name":"$line","line":232},{"line":232,"kind":13,"containerName":"next_result","name":"$self"},{"name":"_readline","containerName":"next_result","kind":12,"line":232},{"line":234,"name":"$line","containerName":"next_result","kind":13},{"kind":13,"containerName":"next_result","name":"$line","line":235},{"name":"$line","containerName":"next_result","kind":13,"line":236},{"line":237,"kind":13,"containerName":"next_result","name":"$seentop"},{"kind":13,"containerName":"next_result","name":"$self","line":238},{"line":238,"kind":12,"containerName":"next_result","name":"_pushback"},{"kind":13,"containerName":"next_result","name":"$line","line":238},{"name":"$self","containerName":"next_result","kind":13,"line":241},{"line":241,"kind":12,"containerName":"next_result","name":"start_element"},{"line":242,"name":"$self","containerName":"next_result","kind":13},{"line":242,"name":"element_hash","containerName":"next_result","kind":12},{"containerName":"next_result","kind":13,"name":"$version","line":244},{"name":"$accession","containerName":"next_result","kind":13,"line":245},{"line":247,"name":"$db","kind":13,"containerName":"next_result"},{"line":248,"kind":13,"containerName":"next_result","name":"$seentop"},{"line":250,"name":"$line","kind":13,"containerName":"next_result"},{"line":251,"kind":13,"containerName":"next_result","name":"$rm"},{"line":251,"name":"$d","kind":13,"containerName":"next_result"},{"line":251,"kind":13,"containerName":"next_result","name":"$descriptor"},{"line":251,"kind":13,"containerName":"next_result","name":"$line"},{"containerName":"next_result","kind":13,"name":"$descriptor","line":253},{"containerName":"next_result","kind":13,"name":"$self","line":254},{"line":254,"containerName":"next_result","kind":13,"name":"$descriptor"},{"name":"$self","containerName":"next_result","kind":13,"line":255},{"name":"element","kind":12,"containerName":"next_result","line":255},{"line":257,"name":"$descriptor","containerName":"next_result","kind":13},{"kind":13,"containerName":"next_result","name":"$line","line":259},{"line":260,"name":"$rm","kind":13,"containerName":"next_result"},{"line":260,"name":"$d","containerName":"next_result","kind":13},{"line":260,"kind":13,"containerName":"next_result","name":"$file"},{"containerName":"next_result","kind":13,"name":"$line","line":260},{"name":"$file","kind":13,"containerName":"next_result","line":262},{"line":263,"containerName":"next_result","kind":13,"name":"$self"},{"name":"element","kind":12,"containerName":"next_result","line":263},{"name":"$file","containerName":"next_result","kind":13,"line":265},{"line":268,"kind":13,"containerName":"next_result","name":"$self"},{"kind":12,"containerName":"next_result","name":"debug","line":268},{"line":270,"name":"$line","kind":13,"containerName":"next_result"},{"line":271,"name":"$line","containerName":"next_result","kind":13},{"line":272,"name":"$hitid","containerName":"next_result","kind":13},{"name":"$hitdesc","containerName":"next_result","kind":13,"line":272},{"line":272,"kind":13,"containerName":"next_result","name":"$line"},{"line":274,"containerName":"next_result","kind":13,"name":"$self"},{"line":274,"kind":12,"containerName":"next_result","name":"within_element"},{"line":274,"name":"$hitid","containerName":"next_result","kind":13},{"line":274,"containerName":"next_result","kind":13,"name":"$lastid"},{"name":"$self","containerName":"next_result","kind":13,"line":275},{"kind":12,"containerName":"next_result","name":"element","line":275},{"name":"$lastscore","kind":13,"containerName":"next_result","line":277},{"kind":13,"containerName":"next_result","name":"$lastscore","line":278},{"containerName":"next_result","kind":13,"name":"$self","line":279},{"containerName":"next_result","kind":12,"name":"end_element","line":279},{"name":"$self","kind":13,"containerName":"next_result","line":280},{"name":"start_element","kind":12,"containerName":"next_result","line":280},{"name":"$self","containerName":"next_result","kind":13,"line":281},{"name":"within_element","containerName":"next_result","kind":12,"line":281},{"containerName":"next_result","kind":13,"name":"$self","line":282},{"kind":12,"containerName":"next_result","name":"start_element","line":282},{"definition":"my","containerName":"next_result","localvar":"my","kind":13,"name":"$gi","line":284},{"name":"$acc","containerName":"next_result","kind":13,"line":284},{"containerName":"next_result","kind":13,"name":"$ver","line":284},{"line":284,"name":"$self","kind":13,"containerName":"next_result"},{"line":284,"name":"_get_seq_identifiers","containerName":"next_result","kind":12},{"containerName":"next_result","kind":13,"name":"$hitid","line":284},{"line":286,"kind":13,"containerName":"next_result","name":"$self"},{"line":286,"containerName":"next_result","kind":12,"name":"element_hash"},{"name":"$hitid","kind":13,"containerName":"next_result","line":287},{"kind":13,"containerName":"next_result","name":"$gi","line":288},{"kind":13,"containerName":"next_result","name":"$ver","line":289},{"line":290,"kind":13,"containerName":"next_result","name":"$acc"},{"name":"$acc","containerName":"next_result","kind":13,"line":290},{"kind":13,"containerName":"next_result","name":"$hitid","line":290},{"line":291,"containerName":"next_result","kind":13,"name":"$hitdesc"},{"line":293,"name":"$lastid","containerName":"next_result","kind":13},{"line":293,"name":"$hitid","containerName":"next_result","kind":13},{"containerName":"next_result","kind":13,"name":"$line","line":294},{"line":295,"name":"$line","kind":13,"containerName":"next_result"},{"definition":"my","kind":13,"localvar":"my","containerName":"next_result","name":"$hspid","line":296},{"kind":13,"localvar":"my","containerName":"next_result","name":"$score","line":297,"definition":"my"},{"line":297,"name":"$strand","kind":13,"containerName":"next_result"},{"line":297,"kind":13,"containerName":"next_result","name":"$start"},{"containerName":"next_result","kind":13,"name":"$length","line":297},{"containerName":"next_result","kind":13,"name":"$seq","line":297},{"line":298,"name":"$score","containerName":"next_result","kind":13},{"line":300,"containerName":"next_result","kind":13,"name":"$hitid"},{"kind":13,"containerName":"next_result","name":"$hspid","line":300},{"line":301,"containerName":"next_result","kind":13,"name":"$self"},{"line":301,"name":"throw","kind":12,"containerName":"next_result"},{"line":304,"name":"$sprintf","kind":13,"containerName":"next_result"},{"line":305,"containerName":"next_result","kind":13,"name":"$score"},{"line":306,"kind":13,"containerName":"next_result","name":"$hsp_min"},{"line":306,"containerName":"next_result","kind":13,"name":"$hsp_max"},{"line":307,"kind":13,"containerName":"next_result","name":"$self"},{"containerName":"next_result","kind":12,"name":"warn","line":307},{"line":310,"kind":13,"containerName":"next_result","name":"$sprintf"},{"line":310,"name":"$oktobuild","containerName":"next_result","kind":13},{"kind":13,"containerName":"next_result","name":"$sprintf","line":312},{"line":316,"name":"$sprintf","kind":13,"containerName":"next_result"},{"line":317,"name":"$hsp_min","kind":13,"containerName":"next_result"},{"name":"$score","containerName":"next_result","kind":13,"line":317},{"containerName":"next_result","kind":13,"name":"$hsp_min","line":317},{"name":"$hsp_max","containerName":"next_result","kind":13,"line":318},{"line":318,"kind":13,"containerName":"next_result","name":"$score"},{"line":318,"containerName":"next_result","kind":13,"name":"$hsp_max"},{"name":"$oktobuild","kind":13,"containerName":"next_result","line":320},{"name":"$oktobuild","containerName":"next_result","kind":13,"line":322},{"line":325,"name":"$hsp_min","containerName":"next_result","kind":13},{"line":325,"containerName":"next_result","kind":13,"name":"$score"},{"line":325,"kind":13,"containerName":"next_result","name":"$hsp_min"},{"line":326,"name":"$lastscore","kind":13,"containerName":"next_result"},{"line":326,"kind":13,"containerName":"next_result","name":"$score"},{"containerName":"next_result","kind":13,"name":"$lastscore","line":326},{"line":326,"containerName":"next_result","kind":13,"name":"$score"},{"line":326,"name":"$lastscore","kind":13,"containerName":"next_result"},{"name":"$hsp_max","kind":13,"containerName":"next_result","line":327},{"name":"$score","containerName":"next_result","kind":13,"line":327},{"line":327,"name":"$hsp_max","containerName":"next_result","kind":13},{"line":328,"containerName":"next_result","kind":13,"name":"$lastscore"},{"line":328,"name":"$score","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"$lastscore","line":328},{"name":"$score","kind":13,"containerName":"next_result","line":328},{"name":"$lastscore","containerName":"next_result","kind":13,"line":328},{"line":334,"containerName":"next_result","kind":13,"name":"$oktobuild"},{"line":335,"localvar":"my","kind":13,"containerName":"next_result","name":"$end","definition":"my"},{"line":337,"containerName":"next_result","kind":13,"name":"$strand"},{"line":338,"kind":13,"containerName":"next_result","name":"$end"},{"containerName":"next_result","kind":13,"name":"$start","line":338},{"kind":13,"containerName":"next_result","name":"$length","line":338},{"kind":13,"containerName":"next_result","name":"$end","line":340},{"line":340,"kind":13,"containerName":"next_result","name":"$start"},{"kind":13,"containerName":"next_result","name":"$length","line":340},{"containerName":"next_result","localvar":"my","kind":13,"name":"$rna","line":343,"definition":"my"},{"line":343,"name":"$meta","containerName":"next_result","kind":13},{"name":"$self","containerName":"next_result","kind":13,"line":343},{"containerName":"next_result","kind":12,"name":"_motif2meta","line":343},{"name":"$seq","containerName":"next_result","kind":13,"line":343},{"line":343,"name":"$descriptor","kind":13,"containerName":"next_result"},{"line":345,"name":"$self","kind":13,"containerName":"next_result"},{"line":345,"kind":12,"containerName":"next_result","name":"start_element"},{"kind":13,"localvar":"my","containerName":"next_result","name":"$rnalen","line":346,"definition":"my"},{"kind":13,"containerName":"next_result","name":"$rna","line":346},{"line":347,"name":"$self","kind":13,"containerName":"next_result"},{"name":"element_hash","containerName":"next_result","kind":12,"line":347},{"containerName":"next_result","kind":13,"name":"$rna","line":349},{"line":351,"containerName":"next_result","kind":13,"name":"$rna"},{"containerName":"next_result","kind":13,"name":"$start","line":352},{"line":353,"kind":13,"containerName":"next_result","name":"$end"},{"line":354,"containerName":"next_result","kind":13,"name":"$meta"},{"line":355,"kind":13,"containerName":"next_result","name":"$rna"},{"line":356,"name":"$sprintf","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"$score","line":356},{"line":357,"kind":13,"containerName":"next_result","name":"$sprintf"},{"containerName":"next_result","kind":13,"name":"$score","line":357},{"name":"$self","kind":13,"containerName":"next_result","line":359},{"name":"end_element","containerName":"next_result","kind":12,"line":359},{"line":360,"kind":13,"containerName":"next_result","name":"$oktobuild"},{"name":"$sprintf","containerName":"next_result","kind":13,"line":360},{"name":"$self","kind":13,"containerName":"next_result","line":364},{"name":"within_element","kind":12,"containerName":"next_result","line":364},{"line":365,"name":"$self","kind":13,"containerName":"next_result"},{"line":365,"name":"element","containerName":"next_result","kind":12},{"line":367,"name":"$lastscore","containerName":"next_result","kind":13},{"line":368,"containerName":"next_result","kind":13,"name":"$lastscore"},{"name":"$self","kind":13,"containerName":"next_result","line":369},{"containerName":"next_result","kind":12,"name":"end_element","line":369},{"kind":13,"containerName":"next_result","name":"$seentop","line":371},{"containerName":"next_result","kind":13,"name":"$self","line":372},{"line":372,"containerName":"next_result","kind":12,"name":"end_element"},{"line":374,"name":"$self","containerName":"next_result","kind":13},{"name":"end_document","kind":12,"containerName":"next_result","line":374}],"detail":"($self)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":211},"end":{"character":9999,"line":375}},"line":211,"signature":{"documentation":"1;\n# $Id: rnamotif.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::rnamotif\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::rnamotif - SearchIO-based RNAMotif parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is a highly experimental SearchIO-based parser for output from the rnamotif\nprogram (one of the programs in the RNAMotif suite). It currently parses only\nraw rnamotif output for RNAMotif versions 3.0 and above; older versions may work\nbut will not be supported. rmfmt output will not be supported at this time.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::rnamotif;\nuse strict;\n\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        # commented out tags have not been assigned\n        \n        'Hsp_score'        => 'HSP-score',\n        'Hsp_custom-data'  => 'HSP-custom_score',\n        \n        # rnamotif has no evalue\n        \n        # descriptor has no start, end; same as hit start, end\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', \n        'Hsp_hit-to'      => 'HSP-hit_end',\n        \n        # descriptor has no start, end\n        \n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        \n        # build this from scratch, simple WUSS-format\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_stranded'    => 'HSP-stranded',        \n        \n        # not supported for RNAMotif\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_def'       => 'HIT-description',\n        'Hit_score'     => 'HIT-score', # best HSP score\n \n        'RNAMotif_program'  => 'RESULT-algorithm_name', # get/set \n        'RNAMotif_version'  => 'RESULT-algorithm_version', # get/set \n        'RNAMotif_query-def'=> 'RESULT-query_name', # get/set\n        # No length (query is a descriptor)\n        'RNAMotif_query-acc'=> 'RESULT-query_accession', # get/set \n        'RNAMotif_querydesc'=> 'RESULT-query_description', # get/set\n        'RNAMotif_db'       => 'RESULT-database_name',  # get/set \n\t     );\n\n# use structure_delimiters to set custom delimiters\n\nmy @VALID_SYMBOLS = qw(5-prime 3-prime single-strand unknown);\nmy %STRUCTURE_SYMBOLS = (\n                   '5-prime'        => '<',\n                   '3-prime'        => '>',\n                   'single-strand'  => '.',\n                   'unknown'        => '?'\n                    # may add more for quartets, triplets\n                  );\n\nmy $DEFAULT_VERSION = '3.0.3';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO::rnamotif object \n Returns : Bio::SearchIO::rnamotif parser\n Args    : -fh/-file     => RNAMotif filename\n           -format       => 'rnamotif'\n           -model        => query model (or descriptor, in this case)\n           -database     => database name (default undef)\n           -query_acc    => query accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -hsp_maxscore => maximum HSP score cutoff\n           -symbols      => hash ref of structure symbols to use\n                            (default symbols in %STRUCTURE_SYMBOLS hash)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($version, $model, $database, $maxcutoff, $mincutoff, $seqdistance,\n        $accession, $symbols) =\n       $self->_rearrange([qw(VERSION MODEL DATABASE HSP_MAXSCORE \n                          HSP_MINSCORE SEQ_DISTANCE QUERY_ACC SYMBOLS)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose => $self->verbose\n        )\n    );\n    $model      && $self->model($model);\n    $database   && $self->database($database);\n    $accession  && $self->query_accession($accession);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n    $self->throw(\"Cannot define both a minimal and maximal cutoff\")\n           if (defined($mincutoff) && defined($maxcutoff));\n    defined($mincutoff)   && $self->hsp_minscore($mincutoff);\n    defined($maxcutoff)   && $self->hsp_maxscore($maxcutoff);\n    $symbols  ||= \\%STRUCTURE_SYMBOLS;\n    $self->structure_symbols($symbols);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none","parameters":[{"label":"$self"}],"label":"next_result($self)"}},{"line":231,"name":"PARSER","kind":12},{"name":"PARSER","kind":12,"line":239},{"children":[{"localvar":"my","containerName":"start_element","kind":13,"name":"$self","line":389,"definition":"my"},{"kind":13,"containerName":"start_element","name":"$data","line":389},{"definition":"my","name":"$nm","localvar":"my","kind":13,"containerName":"start_element","line":392},{"line":392,"name":"$data","kind":13,"containerName":"start_element"},{"line":393,"name":"$type","localvar":"my","containerName":"start_element","kind":13,"definition":"my"},{"line":393,"name":"$MODEMAP","kind":13,"containerName":"start_element"},{"name":"$nm","containerName":"start_element","kind":13,"line":393},{"line":394,"containerName":"start_element","kind":13,"name":"$type"},{"line":395,"kind":13,"containerName":"start_element","name":"$self"},{"name":"_eventHandler","containerName":"start_element","kind":12,"line":395},{"name":"will_handle","kind":12,"containerName":"start_element","line":395},{"line":395,"kind":13,"containerName":"start_element","name":"$type"},{"kind":13,"localvar":"my","containerName":"start_element","name":"$func","line":396,"definition":"my"},{"line":396,"name":"$type","containerName":"start_element","kind":13},{"line":397,"kind":13,"containerName":"start_element","name":"$self"},{"containerName":"start_element","kind":12,"name":"_eventHandler","line":397},{"line":397,"name":"$func","containerName":"start_element","kind":13},{"containerName":"start_element","kind":13,"name":"$data","line":397},{"line":399,"name":"$self","containerName":"start_element","kind":13},{"name":"$type","kind":13,"containerName":"start_element","line":399}],"containerName":"main::","name":"start_element","definition":"sub","detail":"($self,$data)","line":388,"range":{"start":{"line":388,"character":0},"end":{"line":400,"character":9999}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: rnamotif.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::rnamotif\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::rnamotif - SearchIO-based RNAMotif parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is a highly experimental SearchIO-based parser for output from the rnamotif\nprogram (one of the programs in the RNAMotif suite). It currently parses only\nraw rnamotif output for RNAMotif versions 3.0 and above; older versions may work\nbut will not be supported. rmfmt output will not be supported at this time.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::rnamotif;\nuse strict;\n\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        # commented out tags have not been assigned\n        \n        'Hsp_score'        => 'HSP-score',\n        'Hsp_custom-data'  => 'HSP-custom_score',\n        \n        # rnamotif has no evalue\n        \n        # descriptor has no start, end; same as hit start, end\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', \n        'Hsp_hit-to'      => 'HSP-hit_end',\n        \n        # descriptor has no start, end\n        \n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        \n        # build this from scratch, simple WUSS-format\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_stranded'    => 'HSP-stranded',        \n        \n        # not supported for RNAMotif\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_def'       => 'HIT-description',\n        'Hit_score'     => 'HIT-score', # best HSP score\n \n        'RNAMotif_program'  => 'RESULT-algorithm_name', # get/set \n        'RNAMotif_version'  => 'RESULT-algorithm_version', # get/set \n        'RNAMotif_query-def'=> 'RESULT-query_name', # get/set\n        # No length (query is a descriptor)\n        'RNAMotif_query-acc'=> 'RESULT-query_accession', # get/set \n        'RNAMotif_querydesc'=> 'RESULT-query_description', # get/set\n        'RNAMotif_db'       => 'RESULT-database_name',  # get/set \n\t     );\n\n# use structure_delimiters to set custom delimiters\n\nmy @VALID_SYMBOLS = qw(5-prime 3-prime single-strand unknown);\nmy %STRUCTURE_SYMBOLS = (\n                   '5-prime'        => '<',\n                   '3-prime'        => '>',\n                   'single-strand'  => '.',\n                   'unknown'        => '?'\n                    # may add more for quartets, triplets\n                  );\n\nmy $DEFAULT_VERSION = '3.0.3';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO::rnamotif object \n Returns : Bio::SearchIO::rnamotif parser\n Args    : -fh/-file     => RNAMotif filename\n           -format       => 'rnamotif'\n           -model        => query model (or descriptor, in this case)\n           -database     => database name (default undef)\n           -query_acc    => query accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -hsp_maxscore => maximum HSP score cutoff\n           -symbols      => hash ref of structure symbols to use\n                            (default symbols in %STRUCTURE_SYMBOLS hash)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($version, $model, $database, $maxcutoff, $mincutoff, $seqdistance,\n        $accession, $symbols) =\n       $self->_rearrange([qw(VERSION MODEL DATABASE HSP_MAXSCORE \n                          HSP_MINSCORE SEQ_DISTANCE QUERY_ACC SYMBOLS)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose => $self->verbose\n        )\n    );\n    $model      && $self->model($model);\n    $database   && $self->database($database);\n    $accession  && $self->query_accession($accession);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n    $self->throw(\"Cannot define both a minimal and maximal cutoff\")\n           if (defined($mincutoff) && defined($maxcutoff));\n    defined($mincutoff)   && $self->hsp_minscore($mincutoff);\n    defined($maxcutoff)   && $self->hsp_maxscore($maxcutoff);\n    $symbols  ||= \\%STRUCTURE_SYMBOLS;\n    $self->structure_symbols($symbols);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    local $/ = \"\\n\";\n    local $_;\n    my ($rm, $d, $descriptor, $file, $oktobuild);\n    my ($hitid, $hitdesc, $hspid, $lastid, $lastscore);\n    my $sprintf;\n    \n    # user-determined Result data\n    my ($accession, $db, $model) =\n       ($self->query_accession, $self->database, $self->model);\n    # HSP building options\n    my $hsp_min = $self->hsp_minscore;\n    my $hsp_max = $self->hsp_maxscore;\n    my $version = $self->algorithm_version;\n    my $laststart;\n    \n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    PARSER:\n    while ( defined( my $line = $self->_readline ) ) {\n        # start of report\n        next if $line =~ m{^\\s+$};\n        if (index($line,'#RM') == 0) {\n            if (index($line,'#RM scored') == 0 ) {\n                if ($seentop) {\n                    $self->_pushback($line);\n                    last PARSER;\n                }\n                $self->start_element({'Name' => 'Result'});\n                $self->element_hash({\n                    'RNAMotif_program'      => 'rnamotif',\n                    'RNAMotif_version'      => $version,\n                    'RNAMotif_query-acc'    => $accession,\n                    'RNAMotif_db'           => $db\n                    });                \n                $seentop = 1;\n                #$self->debug(\"Start result\\n\");\n            } elsif (index($line,'#RM descr') == 0) {\n                ($rm, $d, $descriptor) = split ' ', $line, 3;\n                # toss $rm, $d; keep $descr\n                chomp $descriptor;\n                $self->{'_descriptor'} = $descriptor;\n                $self->element(\n                               {'Name' => 'RNAMotif_querydesc',\n                                'Data' => $descriptor}\n                              );\n            } elsif(index($line,'#RM dfile') == 0) {\n                ($rm, $d, $file) = split ' ', $line, 3;\n                # toss $rm, $d; keep $file\n                chomp $file;\n                $self->element(\n                               {'Name' => 'RNAMotif_query-def',\n                                'Data' => $file}\n                              );\n            } else {\n                $self->debug(\"Unrecognized line: $line\");\n            }\n        } elsif ($line =~ s{^>}{}) {\n            chomp $line;\n            ($hitid, $hitdesc) = split ' ',$line,2;\n            \n            if ($self->within_element('hit') && ($hitid ne $lastid)) {\n                $self->element(\n                       {'Name' => 'Hit_score',\n                        'Data' => $lastscore}\n                      ) if $lastscore;\n                $self->end_element({'Name' => 'Hit'});\n                $self->start_element({'Name' => 'Hit'});\n            } elsif (!$self->within_element('hit')) {\n                $self->start_element({'Name' => 'Hit'});\n            }\n            my ($gi, $acc, $ver) = $self->_get_seq_identifiers($hitid);\n            \n            $self->element_hash({\n                'Hit_id'        => $hitid,\n                'Hit_gi'        => $gi,\n                'Hit_accession' => $ver ? \"$acc.$ver\" :\n                                    $acc ? $acc : $hitid,\n                'Hit_def'       => $hitdesc}\n              );\n            $lastid = $hitid;\n        } elsif ($line =~ m{^(\\S+)\\s+(.+?)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s(.*)$}xm) {\n            chomp $line;\n            my $hspid = $1;\n            my ($score, $strand, $start, $length , $seq) = ($2, $3, $4, $5, $6);\n            $score *= 1;  # implicitly cast any odd '0.000' to float\n            # sanity check ids\n            unless ($hitid eq $hspid) {\n                $self->throw(\"IDs do not match!\");\n            }\n            # check score for possible sprintf data, mark as such, cache result\n            if (!defined($sprintf)) {\n                if ($score =~ m{[^0-9.-]+}gxms) {\n                    if (defined $hsp_min || defined $hsp_max ) {\n                        $self->warn(\"HSP data likely contains custom score; \".\n                                    \"ignoring min/maxscore\");\n                    }\n                    $sprintf = $oktobuild = 1;\n                } else {\n                    $sprintf = 0;\n                }\n            }\n            \n            if (!$sprintf) {\n                if (($hsp_min && $score <= $hsp_min) \n                          || ($hsp_max && ($score >= $hsp_max)) ) {\n                    # do not build HSP\n                    $oktobuild = 0;\n                } else {\n                    $oktobuild = 1;\n                    \n                    # store best hit score based on the hsp min/maxscore only\n                    if (defined $hsp_min && $score > $hsp_min) {\n                        $lastscore = $score if !$lastscore || $score > $lastscore;\n                    } elsif (defined $hsp_max && $score < $hsp_max) {\n                        $lastscore = $score if !$lastscore || $score < $lastscore;\n                    } \n                }\n            }\n            \n            # build HSP\n            if ($oktobuild) {\n                my $end;\n                # calculate start/end\n                if( $strand==0 ) {\n                    $end = $start + $length -1;\n                } else {\n                    $end = $start - $length + 1;\n                }\n                \n                my ($rna, $meta) = $self->_motif2meta($seq, $descriptor);\n                \n                $self->start_element({'Name' => 'Hsp'});\n                my $rnalen = $rna =~ tr{ATGCatgc}{ATGCatgc};\n                $self->element_hash({\n                        'Hsp_stranded'      => 'HIT', \n                        'Hsp_hseq'          => $rna,\n                        'Hsp_query-from'    => 1,\n                        'Hsp_query-to'      =>length($rna),\n                        'Hsp_hit-from'      => $start,\n                        'Hsp_hit-to'        => $end,\n                        'Hsp_structure'     => $meta,\n                        'Hsp_align-len'     => length($rna),\n                        'Hsp_score'         => $sprintf ? undef : $score,\n                        'Hsp_custom-data'   => $sprintf ? $score : undef,\n                        });\n                $self->end_element({'Name' => 'Hsp'});\n                $oktobuild = 0 if (!$sprintf);\n            }\n        }\n    }\n    if ($self->within_element('hit')) {\n        $self->element(\n               {'Name' => 'Hit_score',\n                'Data' => $lastscore}\n              ) if $lastscore;\n        $self->end_element( { 'Name' => 'Hit' } );\n    }\n    if ($seentop) {\n        $self->end_element( { 'Name' => 'Result' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'","label":"start_element($self,$data)"}},{"line":402,"name":"$type","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"%type","line":402},{"name":"%self","kind":13,"containerName":null,"line":404},{"name":"%self","kind":13,"containerName":null,"line":405},{"signature":{"label":"end_element($self,$data)","documentation":"1;\n# $Id: rnamotif.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::rnamotif\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::rnamotif - SearchIO-based RNAMotif parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is a highly experimental SearchIO-based parser for output from the rnamotif\nprogram (one of the programs in the RNAMotif suite). It currently parses only\nraw rnamotif output for RNAMotif versions 3.0 and above; older versions may work\nbut will not be supported. rmfmt output will not be supported at this time.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::rnamotif;\nuse strict;\n\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        # commented out tags have not been assigned\n        \n        'Hsp_score'        => 'HSP-score',\n        'Hsp_custom-data'  => 'HSP-custom_score',\n        \n        # rnamotif has no evalue\n        \n        # descriptor has no start, end; same as hit start, end\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', \n        'Hsp_hit-to'      => 'HSP-hit_end',\n        \n        # descriptor has no start, end\n        \n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        \n        # build this from scratch, simple WUSS-format\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_stranded'    => 'HSP-stranded',        \n        \n        # not supported for RNAMotif\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_def'       => 'HIT-description',\n        'Hit_score'     => 'HIT-score', # best HSP score\n \n        'RNAMotif_program'  => 'RESULT-algorithm_name', # get/set \n        'RNAMotif_version'  => 'RESULT-algorithm_version', # get/set \n        'RNAMotif_query-def'=> 'RESULT-query_name', # get/set\n        # No length (query is a descriptor)\n        'RNAMotif_query-acc'=> 'RESULT-query_accession', # get/set \n        'RNAMotif_querydesc'=> 'RESULT-query_description', # get/set\n        'RNAMotif_db'       => 'RESULT-database_name',  # get/set \n\t     );\n\n# use structure_delimiters to set custom delimiters\n\nmy @VALID_SYMBOLS = qw(5-prime 3-prime single-strand unknown);\nmy %STRUCTURE_SYMBOLS = (\n                   '5-prime'        => '<',\n                   '3-prime'        => '>',\n                   'single-strand'  => '.',\n                   'unknown'        => '?'\n                    # may add more for quartets, triplets\n                  );\n\nmy $DEFAULT_VERSION = '3.0.3';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO::rnamotif object \n Returns : Bio::SearchIO::rnamotif parser\n Args    : -fh/-file     => RNAMotif filename\n           -format       => 'rnamotif'\n           -model        => query model (or descriptor, in this case)\n           -database     => database name (default undef)\n           -query_acc    => query accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -hsp_maxscore => maximum HSP score cutoff\n           -symbols      => hash ref of structure symbols to use\n                            (default symbols in %STRUCTURE_SYMBOLS hash)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($version, $model, $database, $maxcutoff, $mincutoff, $seqdistance,\n        $accession, $symbols) =\n       $self->_rearrange([qw(VERSION MODEL DATABASE HSP_MAXSCORE \n                          HSP_MINSCORE SEQ_DISTANCE QUERY_ACC SYMBOLS)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose => $self->verbose\n        )\n    );\n    $model      && $self->model($model);\n    $database   && $self->database($database);\n    $accession  && $self->query_accession($accession);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n    $self->throw(\"Cannot define both a minimal and maximal cutoff\")\n           if (defined($mincutoff) && defined($maxcutoff));\n    defined($mincutoff)   && $self->hsp_minscore($mincutoff);\n    defined($maxcutoff)   && $self->hsp_maxscore($maxcutoff);\n    $symbols  ||= \\%STRUCTURE_SYMBOLS;\n    $self->structure_symbols($symbols);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    local $/ = \"\\n\";\n    local $_;\n    my ($rm, $d, $descriptor, $file, $oktobuild);\n    my ($hitid, $hitdesc, $hspid, $lastid, $lastscore);\n    my $sprintf;\n    \n    # user-determined Result data\n    my ($accession, $db, $model) =\n       ($self->query_accession, $self->database, $self->model);\n    # HSP building options\n    my $hsp_min = $self->hsp_minscore;\n    my $hsp_max = $self->hsp_maxscore;\n    my $version = $self->algorithm_version;\n    my $laststart;\n    \n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    PARSER:\n    while ( defined( my $line = $self->_readline ) ) {\n        # start of report\n        next if $line =~ m{^\\s+$};\n        if (index($line,'#RM') == 0) {\n            if (index($line,'#RM scored') == 0 ) {\n                if ($seentop) {\n                    $self->_pushback($line);\n                    last PARSER;\n                }\n                $self->start_element({'Name' => 'Result'});\n                $self->element_hash({\n                    'RNAMotif_program'      => 'rnamotif',\n                    'RNAMotif_version'      => $version,\n                    'RNAMotif_query-acc'    => $accession,\n                    'RNAMotif_db'           => $db\n                    });                \n                $seentop = 1;\n                #$self->debug(\"Start result\\n\");\n            } elsif (index($line,'#RM descr') == 0) {\n                ($rm, $d, $descriptor) = split ' ', $line, 3;\n                # toss $rm, $d; keep $descr\n                chomp $descriptor;\n                $self->{'_descriptor'} = $descriptor;\n                $self->element(\n                               {'Name' => 'RNAMotif_querydesc',\n                                'Data' => $descriptor}\n                              );\n            } elsif(index($line,'#RM dfile') == 0) {\n                ($rm, $d, $file) = split ' ', $line, 3;\n                # toss $rm, $d; keep $file\n                chomp $file;\n                $self->element(\n                               {'Name' => 'RNAMotif_query-def',\n                                'Data' => $file}\n                              );\n            } else {\n                $self->debug(\"Unrecognized line: $line\");\n            }\n        } elsif ($line =~ s{^>}{}) {\n            chomp $line;\n            ($hitid, $hitdesc) = split ' ',$line,2;\n            \n            if ($self->within_element('hit') && ($hitid ne $lastid)) {\n                $self->element(\n                       {'Name' => 'Hit_score',\n                        'Data' => $lastscore}\n                      ) if $lastscore;\n                $self->end_element({'Name' => 'Hit'});\n                $self->start_element({'Name' => 'Hit'});\n            } elsif (!$self->within_element('hit')) {\n                $self->start_element({'Name' => 'Hit'});\n            }\n            my ($gi, $acc, $ver) = $self->_get_seq_identifiers($hitid);\n            \n            $self->element_hash({\n                'Hit_id'        => $hitid,\n                'Hit_gi'        => $gi,\n                'Hit_accession' => $ver ? \"$acc.$ver\" :\n                                    $acc ? $acc : $hitid,\n                'Hit_def'       => $hitdesc}\n              );\n            $lastid = $hitid;\n        } elsif ($line =~ m{^(\\S+)\\s+(.+?)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s(.*)$}xm) {\n            chomp $line;\n            my $hspid = $1;\n            my ($score, $strand, $start, $length , $seq) = ($2, $3, $4, $5, $6);\n            $score *= 1;  # implicitly cast any odd '0.000' to float\n            # sanity check ids\n            unless ($hitid eq $hspid) {\n                $self->throw(\"IDs do not match!\");\n            }\n            # check score for possible sprintf data, mark as such, cache result\n            if (!defined($sprintf)) {\n                if ($score =~ m{[^0-9.-]+}gxms) {\n                    if (defined $hsp_min || defined $hsp_max ) {\n                        $self->warn(\"HSP data likely contains custom score; \".\n                                    \"ignoring min/maxscore\");\n                    }\n                    $sprintf = $oktobuild = 1;\n                } else {\n                    $sprintf = 0;\n                }\n            }\n            \n            if (!$sprintf) {\n                if (($hsp_min && $score <= $hsp_min) \n                          || ($hsp_max && ($score >= $hsp_max)) ) {\n                    # do not build HSP\n                    $oktobuild = 0;\n                } else {\n                    $oktobuild = 1;\n                    \n                    # store best hit score based on the hsp min/maxscore only\n                    if (defined $hsp_min && $score > $hsp_min) {\n                        $lastscore = $score if !$lastscore || $score > $lastscore;\n                    } elsif (defined $hsp_max && $score < $hsp_max) {\n                        $lastscore = $score if !$lastscore || $score < $lastscore;\n                    } \n                }\n            }\n            \n            # build HSP\n            if ($oktobuild) {\n                my $end;\n                # calculate start/end\n                if( $strand==0 ) {\n                    $end = $start + $length -1;\n                } else {\n                    $end = $start - $length + 1;\n                }\n                \n                my ($rna, $meta) = $self->_motif2meta($seq, $descriptor);\n                \n                $self->start_element({'Name' => 'Hsp'});\n                my $rnalen = $rna =~ tr{ATGCatgc}{ATGCatgc};\n                $self->element_hash({\n                        'Hsp_stranded'      => 'HIT', \n                        'Hsp_hseq'          => $rna,\n                        'Hsp_query-from'    => 1,\n                        'Hsp_query-to'      =>length($rna),\n                        'Hsp_hit-from'      => $start,\n                        'Hsp_hit-to'        => $end,\n                        'Hsp_structure'     => $meta,\n                        'Hsp_align-len'     => length($rna),\n                        'Hsp_score'         => $sprintf ? undef : $score,\n                        'Hsp_custom-data'   => $sprintf ? $score : undef,\n                        });\n                $self->end_element({'Name' => 'Hsp'});\n                $oktobuild = 0 if (!$sprintf);\n            }\n        }\n    }\n    if ($self->within_element('hit')) {\n        $self->element(\n               {'Name' => 'Hit_score',\n                'Data' => $lastscore}\n              ) if $lastscore;\n        $self->end_element( { 'Name' => 'Hit' } );\n    }\n    if ($seentop) {\n        $self->end_element( { 'Name' => 'Result' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'","parameters":[{"label":"$self"},{"label":"$data"}]},"kind":12,"range":{"end":{"line":433,"character":9999},"start":{"line":420,"character":0}},"line":420,"detail":"($self,$data)","definition":"sub","name":"end_element","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"end_element","kind":13,"line":421},{"kind":13,"containerName":"end_element","name":"$data","line":421},{"definition":"my","line":422,"localvar":"my","kind":13,"containerName":"end_element","name":"$nm"},{"line":422,"containerName":"end_element","kind":13,"name":"$data"},{"line":423,"containerName":"end_element","localvar":"my","kind":13,"name":"$type","definition":"my"},{"line":423,"kind":13,"containerName":"end_element","name":"$MODEMAP"},{"line":423,"name":"$nm","containerName":"end_element","kind":13},{"name":"$rc","kind":13,"localvar":"my","containerName":"end_element","line":424,"definition":"my"},{"name":"$type","kind":13,"containerName":"end_element","line":426},{"line":427,"name":"$self","kind":13,"containerName":"end_element"},{"kind":12,"containerName":"end_element","name":"_eventHandler","line":427},{"kind":12,"containerName":"end_element","name":"will_handle","line":427},{"containerName":"end_element","kind":13,"name":"$type","line":427},{"definition":"my","line":428,"localvar":"my","containerName":"end_element","kind":13,"name":"$func"},{"line":428,"name":"$type","kind":13,"containerName":"end_element"},{"line":429,"kind":13,"containerName":"end_element","name":"$rc"},{"containerName":"end_element","kind":13,"name":"$self","line":429},{"name":"_eventHandler","kind":12,"containerName":"end_element","line":429},{"kind":13,"containerName":"end_element","name":"$func","line":429},{"line":429,"kind":13,"containerName":"end_element","name":"$self"},{"line":430,"containerName":"end_element","kind":13,"name":"$self"},{"localvar":"my","containerName":"end_element","kind":13,"name":"$lastelem","line":432,"definition":"my"},{"line":432,"name":"$self","containerName":"end_element","kind":13}]},{"line":434,"containerName":null,"kind":13,"name":"%MAPPING"},{"kind":13,"containerName":null,"name":"%nm","line":434},{"containerName":null,"kind":13,"name":"%MAPPING","line":435},{"kind":13,"containerName":null,"name":"%nm","line":435},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"$key","line":436},{"name":"%MAPPING","kind":13,"containerName":null,"line":436},{"kind":13,"containerName":null,"name":"@nm","line":436},{"line":437,"kind":13,"containerName":null,"name":"%self"},{"containerName":null,"kind":13,"name":"%key","line":437},{"kind":13,"containerName":null,"name":"%MAPPING","line":437},{"containerName":null,"kind":13,"name":"%nm","line":437},{"line":437,"containerName":null,"kind":13,"name":"$key"},{"line":438,"kind":13,"containerName":null,"name":"%self"},{"name":"%self","containerName":null,"kind":13,"line":441},{"name":"%MAPPING","containerName":null,"kind":13,"line":441},{"name":"$nm","kind":13,"containerName":null,"line":441},{"name":"%self","containerName":null,"kind":13,"line":441},{"kind":13,"containerName":null,"name":"$self","line":445},{"kind":12,"containerName":"main::","name":"debug","line":445},{"line":447,"kind":13,"containerName":null,"name":"%self"},{"line":449,"name":"%self","kind":13,"containerName":null},{"name":"$rc","kind":13,"containerName":null,"line":449},{"kind":13,"containerName":null,"name":"$type","line":449},{"line":449,"containerName":null,"kind":13,"name":"$type"},{"line":450,"kind":13,"containerName":null,"name":"$rc"},{"line":464,"range":{"start":{"line":464,"character":0},"end":{"line":469,"character":9999}},"kind":12,"signature":{"documentation":"1;\n# $Id: rnamotif.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::rnamotif\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::rnamotif - SearchIO-based RNAMotif parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is a highly experimental SearchIO-based parser for output from the rnamotif\nprogram (one of the programs in the RNAMotif suite). It currently parses only\nraw rnamotif output for RNAMotif versions 3.0 and above; older versions may work\nbut will not be supported. rmfmt output will not be supported at this time.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::rnamotif;\nuse strict;\n\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        # commented out tags have not been assigned\n        \n        'Hsp_score'        => 'HSP-score',\n        'Hsp_custom-data'  => 'HSP-custom_score',\n        \n        # rnamotif has no evalue\n        \n        # descriptor has no start, end; same as hit start, end\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', \n        'Hsp_hit-to'      => 'HSP-hit_end',\n        \n        # descriptor has no start, end\n        \n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        \n        # build this from scratch, simple WUSS-format\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_stranded'    => 'HSP-stranded',        \n        \n        # not supported for RNAMotif\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_def'       => 'HIT-description',\n        'Hit_score'     => 'HIT-score', # best HSP score\n \n        'RNAMotif_program'  => 'RESULT-algorithm_name', # get/set \n        'RNAMotif_version'  => 'RESULT-algorithm_version', # get/set \n        'RNAMotif_query-def'=> 'RESULT-query_name', # get/set\n        # No length (query is a descriptor)\n        'RNAMotif_query-acc'=> 'RESULT-query_accession', # get/set \n        'RNAMotif_querydesc'=> 'RESULT-query_description', # get/set\n        'RNAMotif_db'       => 'RESULT-database_name',  # get/set \n\t     );\n\n# use structure_delimiters to set custom delimiters\n\nmy @VALID_SYMBOLS = qw(5-prime 3-prime single-strand unknown);\nmy %STRUCTURE_SYMBOLS = (\n                   '5-prime'        => '<',\n                   '3-prime'        => '>',\n                   'single-strand'  => '.',\n                   'unknown'        => '?'\n                    # may add more for quartets, triplets\n                  );\n\nmy $DEFAULT_VERSION = '3.0.3';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO::rnamotif object \n Returns : Bio::SearchIO::rnamotif parser\n Args    : -fh/-file     => RNAMotif filename\n           -format       => 'rnamotif'\n           -model        => query model (or descriptor, in this case)\n           -database     => database name (default undef)\n           -query_acc    => query accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -hsp_maxscore => maximum HSP score cutoff\n           -symbols      => hash ref of structure symbols to use\n                            (default symbols in %STRUCTURE_SYMBOLS hash)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($version, $model, $database, $maxcutoff, $mincutoff, $seqdistance,\n        $accession, $symbols) =\n       $self->_rearrange([qw(VERSION MODEL DATABASE HSP_MAXSCORE \n                          HSP_MINSCORE SEQ_DISTANCE QUERY_ACC SYMBOLS)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose => $self->verbose\n        )\n    );\n    $model      && $self->model($model);\n    $database   && $self->database($database);\n    $accession  && $self->query_accession($accession);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n    $self->throw(\"Cannot define both a minimal and maximal cutoff\")\n           if (defined($mincutoff) && defined($maxcutoff));\n    defined($mincutoff)   && $self->hsp_minscore($mincutoff);\n    defined($maxcutoff)   && $self->hsp_maxscore($maxcutoff);\n    $symbols  ||= \\%STRUCTURE_SYMBOLS;\n    $self->structure_symbols($symbols);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    local $/ = \"\\n\";\n    local $_;\n    my ($rm, $d, $descriptor, $file, $oktobuild);\n    my ($hitid, $hitdesc, $hspid, $lastid, $lastscore);\n    my $sprintf;\n    \n    # user-determined Result data\n    my ($accession, $db, $model) =\n       ($self->query_accession, $self->database, $self->model);\n    # HSP building options\n    my $hsp_min = $self->hsp_minscore;\n    my $hsp_max = $self->hsp_maxscore;\n    my $version = $self->algorithm_version;\n    my $laststart;\n    \n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    PARSER:\n    while ( defined( my $line = $self->_readline ) ) {\n        # start of report\n        next if $line =~ m{^\\s+$};\n        if (index($line,'#RM') == 0) {\n            if (index($line,'#RM scored') == 0 ) {\n                if ($seentop) {\n                    $self->_pushback($line);\n                    last PARSER;\n                }\n                $self->start_element({'Name' => 'Result'});\n                $self->element_hash({\n                    'RNAMotif_program'      => 'rnamotif',\n                    'RNAMotif_version'      => $version,\n                    'RNAMotif_query-acc'    => $accession,\n                    'RNAMotif_db'           => $db\n                    });                \n                $seentop = 1;\n                #$self->debug(\"Start result\\n\");\n            } elsif (index($line,'#RM descr') == 0) {\n                ($rm, $d, $descriptor) = split ' ', $line, 3;\n                # toss $rm, $d; keep $descr\n                chomp $descriptor;\n                $self->{'_descriptor'} = $descriptor;\n                $self->element(\n                               {'Name' => 'RNAMotif_querydesc',\n                                'Data' => $descriptor}\n                              );\n            } elsif(index($line,'#RM dfile') == 0) {\n                ($rm, $d, $file) = split ' ', $line, 3;\n                # toss $rm, $d; keep $file\n                chomp $file;\n                $self->element(\n                               {'Name' => 'RNAMotif_query-def',\n                                'Data' => $file}\n                              );\n            } else {\n                $self->debug(\"Unrecognized line: $line\");\n            }\n        } elsif ($line =~ s{^>}{}) {\n            chomp $line;\n            ($hitid, $hitdesc) = split ' ',$line,2;\n            \n            if ($self->within_element('hit') && ($hitid ne $lastid)) {\n                $self->element(\n                       {'Name' => 'Hit_score',\n                        'Data' => $lastscore}\n                      ) if $lastscore;\n                $self->end_element({'Name' => 'Hit'});\n                $self->start_element({'Name' => 'Hit'});\n            } elsif (!$self->within_element('hit')) {\n                $self->start_element({'Name' => 'Hit'});\n            }\n            my ($gi, $acc, $ver) = $self->_get_seq_identifiers($hitid);\n            \n            $self->element_hash({\n                'Hit_id'        => $hitid,\n                'Hit_gi'        => $gi,\n                'Hit_accession' => $ver ? \"$acc.$ver\" :\n                                    $acc ? $acc : $hitid,\n                'Hit_def'       => $hitdesc}\n              );\n            $lastid = $hitid;\n        } elsif ($line =~ m{^(\\S+)\\s+(.+?)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s(.*)$}xm) {\n            chomp $line;\n            my $hspid = $1;\n            my ($score, $strand, $start, $length , $seq) = ($2, $3, $4, $5, $6);\n            $score *= 1;  # implicitly cast any odd '0.000' to float\n            # sanity check ids\n            unless ($hitid eq $hspid) {\n                $self->throw(\"IDs do not match!\");\n            }\n            # check score for possible sprintf data, mark as such, cache result\n            if (!defined($sprintf)) {\n                if ($score =~ m{[^0-9.-]+}gxms) {\n                    if (defined $hsp_min || defined $hsp_max ) {\n                        $self->warn(\"HSP data likely contains custom score; \".\n                                    \"ignoring min/maxscore\");\n                    }\n                    $sprintf = $oktobuild = 1;\n                } else {\n                    $sprintf = 0;\n                }\n            }\n            \n            if (!$sprintf) {\n                if (($hsp_min && $score <= $hsp_min) \n                          || ($hsp_max && ($score >= $hsp_max)) ) {\n                    # do not build HSP\n                    $oktobuild = 0;\n                } else {\n                    $oktobuild = 1;\n                    \n                    # store best hit score based on the hsp min/maxscore only\n                    if (defined $hsp_min && $score > $hsp_min) {\n                        $lastscore = $score if !$lastscore || $score > $lastscore;\n                    } elsif (defined $hsp_max && $score < $hsp_max) {\n                        $lastscore = $score if !$lastscore || $score < $lastscore;\n                    } \n                }\n            }\n            \n            # build HSP\n            if ($oktobuild) {\n                my $end;\n                # calculate start/end\n                if( $strand==0 ) {\n                    $end = $start + $length -1;\n                } else {\n                    $end = $start - $length + 1;\n                }\n                \n                my ($rna, $meta) = $self->_motif2meta($seq, $descriptor);\n                \n                $self->start_element({'Name' => 'Hsp'});\n                my $rnalen = $rna =~ tr{ATGCatgc}{ATGCatgc};\n                $self->element_hash({\n                        'Hsp_stranded'      => 'HIT', \n                        'Hsp_hseq'          => $rna,\n                        'Hsp_query-from'    => 1,\n                        'Hsp_query-to'      =>length($rna),\n                        'Hsp_hit-from'      => $start,\n                        'Hsp_hit-to'        => $end,\n                        'Hsp_structure'     => $meta,\n                        'Hsp_align-len'     => length($rna),\n                        'Hsp_score'         => $sprintf ? undef : $score,\n                        'Hsp_custom-data'   => $sprintf ? $score : undef,\n                        });\n                $self->end_element({'Name' => 'Hsp'});\n                $oktobuild = 0 if (!$sprintf);\n            }\n        }\n    }\n    if ($self->within_element('hit')) {\n        $self->element(\n               {'Name' => 'Hit_score',\n                'Data' => $lastscore}\n              ) if $lastscore;\n        $self->end_element( { 'Name' => 'Hit' } );\n    }\n    if ($seentop) {\n        $self->end_element( { 'Name' => 'Result' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'","parameters":[{"label":"$self"},{"label":"$data"}],"label":"element($self,$data)"},"children":[{"localvar":"my","containerName":"element","kind":13,"name":"$self","line":465,"definition":"my"},{"containerName":"element","kind":13,"name":"$data","line":465},{"kind":13,"containerName":"element","name":"$self","line":467},{"containerName":"element","kind":12,"name":"characters","line":467},{"kind":13,"containerName":"element","name":"$data","line":467},{"kind":13,"containerName":"element","name":"$self","line":468},{"line":468,"name":"end_element","containerName":"element","kind":12},{"line":468,"containerName":"element","kind":13,"name":"$data"}],"name":"element","containerName":"main::","definition":"sub","detail":"($self,$data)"},{"line":485,"range":{"end":{"line":488,"character":9999},"start":{"character":0,"line":485}},"kind":12,"signature":{"documentation":"1;\n# $Id: rnamotif.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::rnamotif\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::rnamotif - SearchIO-based RNAMotif parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is a highly experimental SearchIO-based parser for output from the rnamotif\nprogram (one of the programs in the RNAMotif suite). It currently parses only\nraw rnamotif output for RNAMotif versions 3.0 and above; older versions may work\nbut will not be supported. rmfmt output will not be supported at this time.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::rnamotif;\nuse strict;\n\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        # commented out tags have not been assigned\n        \n        'Hsp_score'        => 'HSP-score',\n        'Hsp_custom-data'  => 'HSP-custom_score',\n        \n        # rnamotif has no evalue\n        \n        # descriptor has no start, end; same as hit start, end\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', \n        'Hsp_hit-to'      => 'HSP-hit_end',\n        \n        # descriptor has no start, end\n        \n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        \n        # build this from scratch, simple WUSS-format\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_stranded'    => 'HSP-stranded',        \n        \n        # not supported for RNAMotif\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_def'       => 'HIT-description',\n        'Hit_score'     => 'HIT-score', # best HSP score\n \n        'RNAMotif_program'  => 'RESULT-algorithm_name', # get/set \n        'RNAMotif_version'  => 'RESULT-algorithm_version', # get/set \n        'RNAMotif_query-def'=> 'RESULT-query_name', # get/set\n        # No length (query is a descriptor)\n        'RNAMotif_query-acc'=> 'RESULT-query_accession', # get/set \n        'RNAMotif_querydesc'=> 'RESULT-query_description', # get/set\n        'RNAMotif_db'       => 'RESULT-database_name',  # get/set \n\t     );\n\n# use structure_delimiters to set custom delimiters\n\nmy @VALID_SYMBOLS = qw(5-prime 3-prime single-strand unknown);\nmy %STRUCTURE_SYMBOLS = (\n                   '5-prime'        => '<',\n                   '3-prime'        => '>',\n                   'single-strand'  => '.',\n                   'unknown'        => '?'\n                    # may add more for quartets, triplets\n                  );\n\nmy $DEFAULT_VERSION = '3.0.3';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO::rnamotif object \n Returns : Bio::SearchIO::rnamotif parser\n Args    : -fh/-file     => RNAMotif filename\n           -format       => 'rnamotif'\n           -model        => query model (or descriptor, in this case)\n           -database     => database name (default undef)\n           -query_acc    => query accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -hsp_maxscore => maximum HSP score cutoff\n           -symbols      => hash ref of structure symbols to use\n                            (default symbols in %STRUCTURE_SYMBOLS hash)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($version, $model, $database, $maxcutoff, $mincutoff, $seqdistance,\n        $accession, $symbols) =\n       $self->_rearrange([qw(VERSION MODEL DATABASE HSP_MAXSCORE \n                          HSP_MINSCORE SEQ_DISTANCE QUERY_ACC SYMBOLS)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose => $self->verbose\n        )\n    );\n    $model      && $self->model($model);\n    $database   && $self->database($database);\n    $accession  && $self->query_accession($accession);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n    $self->throw(\"Cannot define both a minimal and maximal cutoff\")\n           if (defined($mincutoff) && defined($maxcutoff));\n    defined($mincutoff)   && $self->hsp_minscore($mincutoff);\n    defined($maxcutoff)   && $self->hsp_maxscore($maxcutoff);\n    $symbols  ||= \\%STRUCTURE_SYMBOLS;\n    $self->structure_symbols($symbols);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    local $/ = \"\\n\";\n    local $_;\n    my ($rm, $d, $descriptor, $file, $oktobuild);\n    my ($hitid, $hitdesc, $hspid, $lastid, $lastscore);\n    my $sprintf;\n    \n    # user-determined Result data\n    my ($accession, $db, $model) =\n       ($self->query_accession, $self->database, $self->model);\n    # HSP building options\n    my $hsp_min = $self->hsp_minscore;\n    my $hsp_max = $self->hsp_maxscore;\n    my $version = $self->algorithm_version;\n    my $laststart;\n    \n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    PARSER:\n    while ( defined( my $line = $self->_readline ) ) {\n        # start of report\n        next if $line =~ m{^\\s+$};\n        if (index($line,'#RM') == 0) {\n            if (index($line,'#RM scored') == 0 ) {\n                if ($seentop) {\n                    $self->_pushback($line);\n                    last PARSER;\n                }\n                $self->start_element({'Name' => 'Result'});\n                $self->element_hash({\n                    'RNAMotif_program'      => 'rnamotif',\n                    'RNAMotif_version'      => $version,\n                    'RNAMotif_query-acc'    => $accession,\n                    'RNAMotif_db'           => $db\n                    });                \n                $seentop = 1;\n                #$self->debug(\"Start result\\n\");\n            } elsif (index($line,'#RM descr') == 0) {\n                ($rm, $d, $descriptor) = split ' ', $line, 3;\n                # toss $rm, $d; keep $descr\n                chomp $descriptor;\n                $self->{'_descriptor'} = $descriptor;\n                $self->element(\n                               {'Name' => 'RNAMotif_querydesc',\n                                'Data' => $descriptor}\n                              );\n            } elsif(index($line,'#RM dfile') == 0) {\n                ($rm, $d, $file) = split ' ', $line, 3;\n                # toss $rm, $d; keep $file\n                chomp $file;\n                $self->element(\n                               {'Name' => 'RNAMotif_query-def',\n                                'Data' => $file}\n                              );\n            } else {\n                $self->debug(\"Unrecognized line: $line\");\n            }\n        } elsif ($line =~ s{^>}{}) {\n            chomp $line;\n            ($hitid, $hitdesc) = split ' ',$line,2;\n            \n            if ($self->within_element('hit') && ($hitid ne $lastid)) {\n                $self->element(\n                       {'Name' => 'Hit_score',\n                        'Data' => $lastscore}\n                      ) if $lastscore;\n                $self->end_element({'Name' => 'Hit'});\n                $self->start_element({'Name' => 'Hit'});\n            } elsif (!$self->within_element('hit')) {\n                $self->start_element({'Name' => 'Hit'});\n            }\n            my ($gi, $acc, $ver) = $self->_get_seq_identifiers($hitid);\n            \n            $self->element_hash({\n                'Hit_id'        => $hitid,\n                'Hit_gi'        => $gi,\n                'Hit_accession' => $ver ? \"$acc.$ver\" :\n                                    $acc ? $acc : $hitid,\n                'Hit_def'       => $hitdesc}\n              );\n            $lastid = $hitid;\n        } elsif ($line =~ m{^(\\S+)\\s+(.+?)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s(.*)$}xm) {\n            chomp $line;\n            my $hspid = $1;\n            my ($score, $strand, $start, $length , $seq) = ($2, $3, $4, $5, $6);\n            $score *= 1;  # implicitly cast any odd '0.000' to float\n            # sanity check ids\n            unless ($hitid eq $hspid) {\n                $self->throw(\"IDs do not match!\");\n            }\n            # check score for possible sprintf data, mark as such, cache result\n            if (!defined($sprintf)) {\n                if ($score =~ m{[^0-9.-]+}gxms) {\n                    if (defined $hsp_min || defined $hsp_max ) {\n                        $self->warn(\"HSP data likely contains custom score; \".\n                                    \"ignoring min/maxscore\");\n                    }\n                    $sprintf = $oktobuild = 1;\n                } else {\n                    $sprintf = 0;\n                }\n            }\n            \n            if (!$sprintf) {\n                if (($hsp_min && $score <= $hsp_min) \n                          || ($hsp_max && ($score >= $hsp_max)) ) {\n                    # do not build HSP\n                    $oktobuild = 0;\n                } else {\n                    $oktobuild = 1;\n                    \n                    # store best hit score based on the hsp min/maxscore only\n                    if (defined $hsp_min && $score > $hsp_min) {\n                        $lastscore = $score if !$lastscore || $score > $lastscore;\n                    } elsif (defined $hsp_max && $score < $hsp_max) {\n                        $lastscore = $score if !$lastscore || $score < $lastscore;\n                    } \n                }\n            }\n            \n            # build HSP\n            if ($oktobuild) {\n                my $end;\n                # calculate start/end\n                if( $strand==0 ) {\n                    $end = $start + $length -1;\n                } else {\n                    $end = $start - $length + 1;\n                }\n                \n                my ($rna, $meta) = $self->_motif2meta($seq, $descriptor);\n                \n                $self->start_element({'Name' => 'Hsp'});\n                my $rnalen = $rna =~ tr{ATGCatgc}{ATGCatgc};\n                $self->element_hash({\n                        'Hsp_stranded'      => 'HIT', \n                        'Hsp_hseq'          => $rna,\n                        'Hsp_query-from'    => 1,\n                        'Hsp_query-to'      =>length($rna),\n                        'Hsp_hit-from'      => $start,\n                        'Hsp_hit-to'        => $end,\n                        'Hsp_structure'     => $meta,\n                        'Hsp_align-len'     => length($rna),\n                        'Hsp_score'         => $sprintf ? undef : $score,\n                        'Hsp_custom-data'   => $sprintf ? $score : undef,\n                        });\n                $self->end_element({'Name' => 'Hsp'});\n                $oktobuild = 0 if (!$sprintf);\n            }\n        }\n    }\n    if ($self->within_element('hit')) {\n        $self->element(\n               {'Name' => 'Hit_score',\n                'Data' => $lastscore}\n              ) if $lastscore;\n        $self->end_element( { 'Name' => 'Hit' } );\n    }\n    if ($seentop) {\n        $self->end_element( { 'Name' => 'Result' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # simple data calls (%MAPPING) do not need start_element\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n\n=head2 element_hash\n\n Title   : element\n Usage   : $eventhandler->element_hash({'Hsp_hit-from' => $start,\n                                        'Hsp_hit-to'   => $end,\n                                        'Hsp_score'    => $lastscore});\n Function: Convenience method that takes multiple simple data elements and\n           maps to appropriate parameters\n Returns : none\n Args    : Hash ref with the mapped key (in %MAPPING) and value","parameters":[{"label":"$self"},{"label":"$data"}],"label":"element_hash($self,$data)"},"children":[{"definition":"my","localvar":"my","kind":13,"containerName":"element_hash","name":"$self","line":486},{"line":486,"kind":13,"containerName":"element_hash","name":"$data"},{"line":487,"kind":13,"containerName":"element_hash","name":"$self"},{"containerName":"element_hash","kind":12,"name":"throw","line":487},{"line":487,"name":"$data","containerName":"element_hash","kind":13},{"line":487,"name":"$data","containerName":"element_hash","kind":13},{"name":"$nm","kind":13,"localvar":"my","containerName":"element_hash","line":488,"definition":"my"},{"name":"$data","containerName":"element_hash","kind":13,"line":488}],"containerName":"main::","name":"element_hash","definition":"sub","detail":"($self,$data)"},{"kind":13,"containerName":null,"name":"%data","line":489},{"name":"$nm","kind":13,"containerName":null,"line":489},{"kind":13,"containerName":null,"name":"%data","line":489},{"containerName":null,"kind":13,"name":"$nm","line":489},{"line":490,"name":"%MAPPING","containerName":null,"kind":13},{"name":"%nm","containerName":null,"kind":13,"line":490},{"line":491,"kind":13,"containerName":null,"name":"%MAPPING"},{"line":491,"name":"%nm","containerName":null,"kind":13},{"line":492,"localvar":"my","kind":13,"containerName":null,"name":"$key","definition":"my"},{"line":492,"kind":13,"containerName":null,"name":"%MAPPING"},{"line":492,"name":"@nm","kind":13,"containerName":null},{"line":493,"containerName":null,"kind":13,"name":"%self"},{"name":"%key","kind":13,"containerName":null,"line":493},{"line":493,"kind":13,"containerName":null,"name":"%MAPPING"},{"line":493,"name":"%nm","kind":13,"containerName":null},{"name":"$key","kind":13,"containerName":null,"line":493},{"containerName":null,"kind":13,"name":"%data","line":494},{"name":"%nm","kind":13,"containerName":null,"line":494},{"containerName":null,"kind":13,"name":"%self","line":497},{"containerName":null,"kind":13,"name":"%MAPPING","line":497},{"containerName":null,"kind":13,"name":"$nm","line":497},{"name":"%data","containerName":null,"kind":13,"line":497},{"line":497,"containerName":null,"kind":13,"name":"$nm"},{"range":{"start":{"character":0,"line":514},"end":{"character":9999,"line":518}},"kind":12,"line":514,"signature":{"label":"characters($self,$data)","documentation":"1;\n# $Id: rnamotif.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::rnamotif\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::rnamotif - SearchIO-based RNAMotif parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is a highly experimental SearchIO-based parser for output from the rnamotif\nprogram (one of the programs in the RNAMotif suite). It currently parses only\nraw rnamotif output for RNAMotif versions 3.0 and above; older versions may work\nbut will not be supported. rmfmt output will not be supported at this time.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::rnamotif;\nuse strict;\n\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        # commented out tags have not been assigned\n        \n        'Hsp_score'        => 'HSP-score',\n        'Hsp_custom-data'  => 'HSP-custom_score',\n        \n        # rnamotif has no evalue\n        \n        # descriptor has no start, end; same as hit start, end\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', \n        'Hsp_hit-to'      => 'HSP-hit_end',\n        \n        # descriptor has no start, end\n        \n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        \n        # build this from scratch, simple WUSS-format\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_stranded'    => 'HSP-stranded',        \n        \n        # not supported for RNAMotif\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_def'       => 'HIT-description',\n        'Hit_score'     => 'HIT-score', # best HSP score\n \n        'RNAMotif_program'  => 'RESULT-algorithm_name', # get/set \n        'RNAMotif_version'  => 'RESULT-algorithm_version', # get/set \n        'RNAMotif_query-def'=> 'RESULT-query_name', # get/set\n        # No length (query is a descriptor)\n        'RNAMotif_query-acc'=> 'RESULT-query_accession', # get/set \n        'RNAMotif_querydesc'=> 'RESULT-query_description', # get/set\n        'RNAMotif_db'       => 'RESULT-database_name',  # get/set \n\t     );\n\n# use structure_delimiters to set custom delimiters\n\nmy @VALID_SYMBOLS = qw(5-prime 3-prime single-strand unknown);\nmy %STRUCTURE_SYMBOLS = (\n                   '5-prime'        => '<',\n                   '3-prime'        => '>',\n                   'single-strand'  => '.',\n                   'unknown'        => '?'\n                    # may add more for quartets, triplets\n                  );\n\nmy $DEFAULT_VERSION = '3.0.3';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO::rnamotif object \n Returns : Bio::SearchIO::rnamotif parser\n Args    : -fh/-file     => RNAMotif filename\n           -format       => 'rnamotif'\n           -model        => query model (or descriptor, in this case)\n           -database     => database name (default undef)\n           -query_acc    => query accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -hsp_maxscore => maximum HSP score cutoff\n           -symbols      => hash ref of structure symbols to use\n                            (default symbols in %STRUCTURE_SYMBOLS hash)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($version, $model, $database, $maxcutoff, $mincutoff, $seqdistance,\n        $accession, $symbols) =\n       $self->_rearrange([qw(VERSION MODEL DATABASE HSP_MAXSCORE \n                          HSP_MINSCORE SEQ_DISTANCE QUERY_ACC SYMBOLS)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose => $self->verbose\n        )\n    );\n    $model      && $self->model($model);\n    $database   && $self->database($database);\n    $accession  && $self->query_accession($accession);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n    $self->throw(\"Cannot define both a minimal and maximal cutoff\")\n           if (defined($mincutoff) && defined($maxcutoff));\n    defined($mincutoff)   && $self->hsp_minscore($mincutoff);\n    defined($maxcutoff)   && $self->hsp_maxscore($maxcutoff);\n    $symbols  ||= \\%STRUCTURE_SYMBOLS;\n    $self->structure_symbols($symbols);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    local $/ = \"\\n\";\n    local $_;\n    my ($rm, $d, $descriptor, $file, $oktobuild);\n    my ($hitid, $hitdesc, $hspid, $lastid, $lastscore);\n    my $sprintf;\n    \n    # user-determined Result data\n    my ($accession, $db, $model) =\n       ($self->query_accession, $self->database, $self->model);\n    # HSP building options\n    my $hsp_min = $self->hsp_minscore;\n    my $hsp_max = $self->hsp_maxscore;\n    my $version = $self->algorithm_version;\n    my $laststart;\n    \n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    PARSER:\n    while ( defined( my $line = $self->_readline ) ) {\n        # start of report\n        next if $line =~ m{^\\s+$};\n        if (index($line,'#RM') == 0) {\n            if (index($line,'#RM scored') == 0 ) {\n                if ($seentop) {\n                    $self->_pushback($line);\n                    last PARSER;\n                }\n                $self->start_element({'Name' => 'Result'});\n                $self->element_hash({\n                    'RNAMotif_program'      => 'rnamotif',\n                    'RNAMotif_version'      => $version,\n                    'RNAMotif_query-acc'    => $accession,\n                    'RNAMotif_db'           => $db\n                    });                \n                $seentop = 1;\n                #$self->debug(\"Start result\\n\");\n            } elsif (index($line,'#RM descr') == 0) {\n                ($rm, $d, $descriptor) = split ' ', $line, 3;\n                # toss $rm, $d; keep $descr\n                chomp $descriptor;\n                $self->{'_descriptor'} = $descriptor;\n                $self->element(\n                               {'Name' => 'RNAMotif_querydesc',\n                                'Data' => $descriptor}\n                              );\n            } elsif(index($line,'#RM dfile') == 0) {\n                ($rm, $d, $file) = split ' ', $line, 3;\n                # toss $rm, $d; keep $file\n                chomp $file;\n                $self->element(\n                               {'Name' => 'RNAMotif_query-def',\n                                'Data' => $file}\n                              );\n            } else {\n                $self->debug(\"Unrecognized line: $line\");\n            }\n        } elsif ($line =~ s{^>}{}) {\n            chomp $line;\n            ($hitid, $hitdesc) = split ' ',$line,2;\n            \n            if ($self->within_element('hit') && ($hitid ne $lastid)) {\n                $self->element(\n                       {'Name' => 'Hit_score',\n                        'Data' => $lastscore}\n                      ) if $lastscore;\n                $self->end_element({'Name' => 'Hit'});\n                $self->start_element({'Name' => 'Hit'});\n            } elsif (!$self->within_element('hit')) {\n                $self->start_element({'Name' => 'Hit'});\n            }\n            my ($gi, $acc, $ver) = $self->_get_seq_identifiers($hitid);\n            \n            $self->element_hash({\n                'Hit_id'        => $hitid,\n                'Hit_gi'        => $gi,\n                'Hit_accession' => $ver ? \"$acc.$ver\" :\n                                    $acc ? $acc : $hitid,\n                'Hit_def'       => $hitdesc}\n              );\n            $lastid = $hitid;\n        } elsif ($line =~ m{^(\\S+)\\s+(.+?)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s(.*)$}xm) {\n            chomp $line;\n            my $hspid = $1;\n            my ($score, $strand, $start, $length , $seq) = ($2, $3, $4, $5, $6);\n            $score *= 1;  # implicitly cast any odd '0.000' to float\n            # sanity check ids\n            unless ($hitid eq $hspid) {\n                $self->throw(\"IDs do not match!\");\n            }\n            # check score for possible sprintf data, mark as such, cache result\n            if (!defined($sprintf)) {\n                if ($score =~ m{[^0-9.-]+}gxms) {\n                    if (defined $hsp_min || defined $hsp_max ) {\n                        $self->warn(\"HSP data likely contains custom score; \".\n                                    \"ignoring min/maxscore\");\n                    }\n                    $sprintf = $oktobuild = 1;\n                } else {\n                    $sprintf = 0;\n                }\n            }\n            \n            if (!$sprintf) {\n                if (($hsp_min && $score <= $hsp_min) \n                          || ($hsp_max && ($score >= $hsp_max)) ) {\n                    # do not build HSP\n                    $oktobuild = 0;\n                } else {\n                    $oktobuild = 1;\n                    \n                    # store best hit score based on the hsp min/maxscore only\n                    if (defined $hsp_min && $score > $hsp_min) {\n                        $lastscore = $score if !$lastscore || $score > $lastscore;\n                    } elsif (defined $hsp_max && $score < $hsp_max) {\n                        $lastscore = $score if !$lastscore || $score < $lastscore;\n                    } \n                }\n            }\n            \n            # build HSP\n            if ($oktobuild) {\n                my $end;\n                # calculate start/end\n                if( $strand==0 ) {\n                    $end = $start + $length -1;\n                } else {\n                    $end = $start - $length + 1;\n                }\n                \n                my ($rna, $meta) = $self->_motif2meta($seq, $descriptor);\n                \n                $self->start_element({'Name' => 'Hsp'});\n                my $rnalen = $rna =~ tr{ATGCatgc}{ATGCatgc};\n                $self->element_hash({\n                        'Hsp_stranded'      => 'HIT', \n                        'Hsp_hseq'          => $rna,\n                        'Hsp_query-from'    => 1,\n                        'Hsp_query-to'      =>length($rna),\n                        'Hsp_hit-from'      => $start,\n                        'Hsp_hit-to'        => $end,\n                        'Hsp_structure'     => $meta,\n                        'Hsp_align-len'     => length($rna),\n                        'Hsp_score'         => $sprintf ? undef : $score,\n                        'Hsp_custom-data'   => $sprintf ? $score : undef,\n                        });\n                $self->end_element({'Name' => 'Hsp'});\n                $oktobuild = 0 if (!$sprintf);\n            }\n        }\n    }\n    if ($self->within_element('hit')) {\n        $self->element(\n               {'Name' => 'Hit_score',\n                'Data' => $lastscore}\n              ) if $lastscore;\n        $self->end_element( { 'Name' => 'Hit' } );\n    }\n    if ($seentop) {\n        $self->end_element( { 'Name' => 'Result' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # simple data calls (%MAPPING) do not need start_element\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n\n=head2 element_hash\n\n Title   : element\n Usage   : $eventhandler->element_hash({'Hsp_hit-from' => $start,\n                                        'Hsp_hit-to'   => $end,\n                                        'Hsp_score'    => $lastscore});\n Function: Convenience method that takes multiple simple data elements and\n           maps to appropriate parameters\n Returns : none\n Args    : Hash ref with the mapped key (in %MAPPING) and value\n\n\nsub element_hash {\n    my ($self, $data) = @_;\n    $self->throw(\"Must provide data hash ref\") if !$data || !ref($data);\n    for my $nm (sort keys %{$data}) {\n        next if $data->{$nm} && $data->{$nm} =~ m{^\\s*$}o;\n        if ( $MAPPING{$nm} ) {\n            if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n                my $key = ( keys %{ $MAPPING{$nm} } )[0];\n                $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n                  $data->{$nm};\n            }\n            else {\n                $self->{'_values'}->{ $MAPPING{$nm} } = $data->{$nm};\n            }\n        }\n    }\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string","parameters":[{"label":"$self"},{"label":"$data"}]},"containerName":"main::","name":"characters","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"characters","name":"$self","line":515},{"containerName":"characters","kind":13,"name":"$data","line":515},{"kind":13,"containerName":"characters","name":"$data","line":516},{"kind":13,"containerName":"characters","name":"$data","line":516},{"containerName":"characters","kind":13,"name":"$self","line":517},{"line":517,"containerName":"characters","kind":13,"name":"$data"}],"detail":"($self,$data)","definition":"sub"},{"definition":"sub","detail":"($self,$name)","children":[{"definition":"my","name":"$self","containerName":"within_element","localvar":"my","kind":13,"line":533},{"name":"$name","kind":13,"containerName":"within_element","line":533},{"name":"$name","containerName":"within_element","kind":13,"line":536},{"containerName":"within_element","kind":13,"name":"$self","line":536},{"containerName":"within_element","kind":13,"name":"$self","line":537}],"containerName":"main::","name":"within_element","signature":{"parameters":[{"label":"$self"},{"label":"$name"}],"documentation":"1;\n# $Id: rnamotif.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::rnamotif\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::rnamotif - SearchIO-based RNAMotif parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is a highly experimental SearchIO-based parser for output from the rnamotif\nprogram (one of the programs in the RNAMotif suite). It currently parses only\nraw rnamotif output for RNAMotif versions 3.0 and above; older versions may work\nbut will not be supported. rmfmt output will not be supported at this time.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::rnamotif;\nuse strict;\n\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        # commented out tags have not been assigned\n        \n        'Hsp_score'        => 'HSP-score',\n        'Hsp_custom-data'  => 'HSP-custom_score',\n        \n        # rnamotif has no evalue\n        \n        # descriptor has no start, end; same as hit start, end\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', \n        'Hsp_hit-to'      => 'HSP-hit_end',\n        \n        # descriptor has no start, end\n        \n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        \n        # build this from scratch, simple WUSS-format\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_stranded'    => 'HSP-stranded',        \n        \n        # not supported for RNAMotif\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_def'       => 'HIT-description',\n        'Hit_score'     => 'HIT-score', # best HSP score\n \n        'RNAMotif_program'  => 'RESULT-algorithm_name', # get/set \n        'RNAMotif_version'  => 'RESULT-algorithm_version', # get/set \n        'RNAMotif_query-def'=> 'RESULT-query_name', # get/set\n        # No length (query is a descriptor)\n        'RNAMotif_query-acc'=> 'RESULT-query_accession', # get/set \n        'RNAMotif_querydesc'=> 'RESULT-query_description', # get/set\n        'RNAMotif_db'       => 'RESULT-database_name',  # get/set \n\t     );\n\n# use structure_delimiters to set custom delimiters\n\nmy @VALID_SYMBOLS = qw(5-prime 3-prime single-strand unknown);\nmy %STRUCTURE_SYMBOLS = (\n                   '5-prime'        => '<',\n                   '3-prime'        => '>',\n                   'single-strand'  => '.',\n                   'unknown'        => '?'\n                    # may add more for quartets, triplets\n                  );\n\nmy $DEFAULT_VERSION = '3.0.3';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO::rnamotif object \n Returns : Bio::SearchIO::rnamotif parser\n Args    : -fh/-file     => RNAMotif filename\n           -format       => 'rnamotif'\n           -model        => query model (or descriptor, in this case)\n           -database     => database name (default undef)\n           -query_acc    => query accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -hsp_maxscore => maximum HSP score cutoff\n           -symbols      => hash ref of structure symbols to use\n                            (default symbols in %STRUCTURE_SYMBOLS hash)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($version, $model, $database, $maxcutoff, $mincutoff, $seqdistance,\n        $accession, $symbols) =\n       $self->_rearrange([qw(VERSION MODEL DATABASE HSP_MAXSCORE \n                          HSP_MINSCORE SEQ_DISTANCE QUERY_ACC SYMBOLS)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose => $self->verbose\n        )\n    );\n    $model      && $self->model($model);\n    $database   && $self->database($database);\n    $accession  && $self->query_accession($accession);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n    $self->throw(\"Cannot define both a minimal and maximal cutoff\")\n           if (defined($mincutoff) && defined($maxcutoff));\n    defined($mincutoff)   && $self->hsp_minscore($mincutoff);\n    defined($maxcutoff)   && $self->hsp_maxscore($maxcutoff);\n    $symbols  ||= \\%STRUCTURE_SYMBOLS;\n    $self->structure_symbols($symbols);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    local $/ = \"\\n\";\n    local $_;\n    my ($rm, $d, $descriptor, $file, $oktobuild);\n    my ($hitid, $hitdesc, $hspid, $lastid, $lastscore);\n    my $sprintf;\n    \n    # user-determined Result data\n    my ($accession, $db, $model) =\n       ($self->query_accession, $self->database, $self->model);\n    # HSP building options\n    my $hsp_min = $self->hsp_minscore;\n    my $hsp_max = $self->hsp_maxscore;\n    my $version = $self->algorithm_version;\n    my $laststart;\n    \n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    PARSER:\n    while ( defined( my $line = $self->_readline ) ) {\n        # start of report\n        next if $line =~ m{^\\s+$};\n        if (index($line,'#RM') == 0) {\n            if (index($line,'#RM scored') == 0 ) {\n                if ($seentop) {\n                    $self->_pushback($line);\n                    last PARSER;\n                }\n                $self->start_element({'Name' => 'Result'});\n                $self->element_hash({\n                    'RNAMotif_program'      => 'rnamotif',\n                    'RNAMotif_version'      => $version,\n                    'RNAMotif_query-acc'    => $accession,\n                    'RNAMotif_db'           => $db\n                    });                \n                $seentop = 1;\n                #$self->debug(\"Start result\\n\");\n            } elsif (index($line,'#RM descr') == 0) {\n                ($rm, $d, $descriptor) = split ' ', $line, 3;\n                # toss $rm, $d; keep $descr\n                chomp $descriptor;\n                $self->{'_descriptor'} = $descriptor;\n                $self->element(\n                               {'Name' => 'RNAMotif_querydesc',\n                                'Data' => $descriptor}\n                              );\n            } elsif(index($line,'#RM dfile') == 0) {\n                ($rm, $d, $file) = split ' ', $line, 3;\n                # toss $rm, $d; keep $file\n                chomp $file;\n                $self->element(\n                               {'Name' => 'RNAMotif_query-def',\n                                'Data' => $file}\n                              );\n            } else {\n                $self->debug(\"Unrecognized line: $line\");\n            }\n        } elsif ($line =~ s{^>}{}) {\n            chomp $line;\n            ($hitid, $hitdesc) = split ' ',$line,2;\n            \n            if ($self->within_element('hit') && ($hitid ne $lastid)) {\n                $self->element(\n                       {'Name' => 'Hit_score',\n                        'Data' => $lastscore}\n                      ) if $lastscore;\n                $self->end_element({'Name' => 'Hit'});\n                $self->start_element({'Name' => 'Hit'});\n            } elsif (!$self->within_element('hit')) {\n                $self->start_element({'Name' => 'Hit'});\n            }\n            my ($gi, $acc, $ver) = $self->_get_seq_identifiers($hitid);\n            \n            $self->element_hash({\n                'Hit_id'        => $hitid,\n                'Hit_gi'        => $gi,\n                'Hit_accession' => $ver ? \"$acc.$ver\" :\n                                    $acc ? $acc : $hitid,\n                'Hit_def'       => $hitdesc}\n              );\n            $lastid = $hitid;\n        } elsif ($line =~ m{^(\\S+)\\s+(.+?)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s(.*)$}xm) {\n            chomp $line;\n            my $hspid = $1;\n            my ($score, $strand, $start, $length , $seq) = ($2, $3, $4, $5, $6);\n            $score *= 1;  # implicitly cast any odd '0.000' to float\n            # sanity check ids\n            unless ($hitid eq $hspid) {\n                $self->throw(\"IDs do not match!\");\n            }\n            # check score for possible sprintf data, mark as such, cache result\n            if (!defined($sprintf)) {\n                if ($score =~ m{[^0-9.-]+}gxms) {\n                    if (defined $hsp_min || defined $hsp_max ) {\n                        $self->warn(\"HSP data likely contains custom score; \".\n                                    \"ignoring min/maxscore\");\n                    }\n                    $sprintf = $oktobuild = 1;\n                } else {\n                    $sprintf = 0;\n                }\n            }\n            \n            if (!$sprintf) {\n                if (($hsp_min && $score <= $hsp_min) \n                          || ($hsp_max && ($score >= $hsp_max)) ) {\n                    # do not build HSP\n                    $oktobuild = 0;\n                } else {\n                    $oktobuild = 1;\n                    \n                    # store best hit score based on the hsp min/maxscore only\n                    if (defined $hsp_min && $score > $hsp_min) {\n                        $lastscore = $score if !$lastscore || $score > $lastscore;\n                    } elsif (defined $hsp_max && $score < $hsp_max) {\n                        $lastscore = $score if !$lastscore || $score < $lastscore;\n                    } \n                }\n            }\n            \n            # build HSP\n            if ($oktobuild) {\n                my $end;\n                # calculate start/end\n                if( $strand==0 ) {\n                    $end = $start + $length -1;\n                } else {\n                    $end = $start - $length + 1;\n                }\n                \n                my ($rna, $meta) = $self->_motif2meta($seq, $descriptor);\n                \n                $self->start_element({'Name' => 'Hsp'});\n                my $rnalen = $rna =~ tr{ATGCatgc}{ATGCatgc};\n                $self->element_hash({\n                        'Hsp_stranded'      => 'HIT', \n                        'Hsp_hseq'          => $rna,\n                        'Hsp_query-from'    => 1,\n                        'Hsp_query-to'      =>length($rna),\n                        'Hsp_hit-from'      => $start,\n                        'Hsp_hit-to'        => $end,\n                        'Hsp_structure'     => $meta,\n                        'Hsp_align-len'     => length($rna),\n                        'Hsp_score'         => $sprintf ? undef : $score,\n                        'Hsp_custom-data'   => $sprintf ? $score : undef,\n                        });\n                $self->end_element({'Name' => 'Hsp'});\n                $oktobuild = 0 if (!$sprintf);\n            }\n        }\n    }\n    if ($self->within_element('hit')) {\n        $self->element(\n               {'Name' => 'Hit_score',\n                'Data' => $lastscore}\n              ) if $lastscore;\n        $self->end_element( { 'Name' => 'Hit' } );\n    }\n    if ($seentop) {\n        $self->end_element( { 'Name' => 'Result' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # simple data calls (%MAPPING) do not need start_element\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n\n=head2 element_hash\n\n Title   : element\n Usage   : $eventhandler->element_hash({'Hsp_hit-from' => $start,\n                                        'Hsp_hit-to'   => $end,\n                                        'Hsp_score'    => $lastscore});\n Function: Convenience method that takes multiple simple data elements and\n           maps to appropriate parameters\n Returns : none\n Args    : Hash ref with the mapped key (in %MAPPING) and value\n\n\nsub element_hash {\n    my ($self, $data) = @_;\n    $self->throw(\"Must provide data hash ref\") if !$data || !ref($data);\n    for my $nm (sort keys %{$data}) {\n        next if $data->{$nm} && $data->{$nm} =~ m{^\\s*$}o;\n        if ( $MAPPING{$nm} ) {\n            if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n                my $key = ( keys %{ $MAPPING{$nm} } )[0];\n                $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n                  $data->{$nm};\n            }\n            else {\n                $self->{'_values'}->{ $MAPPING{$nm} } = $data->{$nm};\n            }\n        }\n    }\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n    return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/o );\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name ","label":"within_element($self,$name)"},"line":532,"kind":12,"range":{"start":{"character":0,"line":532},"end":{"character":9999,"line":537}}},{"containerName":null,"kind":13,"name":"%self","line":538},{"containerName":null,"kind":13,"name":"$name","line":539},{"definition":"sub","detail":"($self,$name)","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"in_element","kind":13,"line":557},{"name":"$name","kind":13,"containerName":"in_element","line":557},{"kind":13,"containerName":"in_element","name":"$self","line":558},{"line":559,"name":"$self","containerName":"in_element","kind":13},{"line":559,"name":"$name","containerName":"in_element","kind":13}],"name":"in_element","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$name"}],"documentation":"1;\n# $Id: rnamotif.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::rnamotif\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::rnamotif - SearchIO-based RNAMotif parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is a highly experimental SearchIO-based parser for output from the rnamotif\nprogram (one of the programs in the RNAMotif suite). It currently parses only\nraw rnamotif output for RNAMotif versions 3.0 and above; older versions may work\nbut will not be supported. rmfmt output will not be supported at this time.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::rnamotif;\nuse strict;\n\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        # commented out tags have not been assigned\n        \n        'Hsp_score'        => 'HSP-score',\n        'Hsp_custom-data'  => 'HSP-custom_score',\n        \n        # rnamotif has no evalue\n        \n        # descriptor has no start, end; same as hit start, end\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', \n        'Hsp_hit-to'      => 'HSP-hit_end',\n        \n        # descriptor has no start, end\n        \n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        \n        # build this from scratch, simple WUSS-format\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_stranded'    => 'HSP-stranded',        \n        \n        # not supported for RNAMotif\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_def'       => 'HIT-description',\n        'Hit_score'     => 'HIT-score', # best HSP score\n \n        'RNAMotif_program'  => 'RESULT-algorithm_name', # get/set \n        'RNAMotif_version'  => 'RESULT-algorithm_version', # get/set \n        'RNAMotif_query-def'=> 'RESULT-query_name', # get/set\n        # No length (query is a descriptor)\n        'RNAMotif_query-acc'=> 'RESULT-query_accession', # get/set \n        'RNAMotif_querydesc'=> 'RESULT-query_description', # get/set\n        'RNAMotif_db'       => 'RESULT-database_name',  # get/set \n\t     );\n\n# use structure_delimiters to set custom delimiters\n\nmy @VALID_SYMBOLS = qw(5-prime 3-prime single-strand unknown);\nmy %STRUCTURE_SYMBOLS = (\n                   '5-prime'        => '<',\n                   '3-prime'        => '>',\n                   'single-strand'  => '.',\n                   'unknown'        => '?'\n                    # may add more for quartets, triplets\n                  );\n\nmy $DEFAULT_VERSION = '3.0.3';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO::rnamotif object \n Returns : Bio::SearchIO::rnamotif parser\n Args    : -fh/-file     => RNAMotif filename\n           -format       => 'rnamotif'\n           -model        => query model (or descriptor, in this case)\n           -database     => database name (default undef)\n           -query_acc    => query accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -hsp_maxscore => maximum HSP score cutoff\n           -symbols      => hash ref of structure symbols to use\n                            (default symbols in %STRUCTURE_SYMBOLS hash)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($version, $model, $database, $maxcutoff, $mincutoff, $seqdistance,\n        $accession, $symbols) =\n       $self->_rearrange([qw(VERSION MODEL DATABASE HSP_MAXSCORE \n                          HSP_MINSCORE SEQ_DISTANCE QUERY_ACC SYMBOLS)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose => $self->verbose\n        )\n    );\n    $model      && $self->model($model);\n    $database   && $self->database($database);\n    $accession  && $self->query_accession($accession);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n    $self->throw(\"Cannot define both a minimal and maximal cutoff\")\n           if (defined($mincutoff) && defined($maxcutoff));\n    defined($mincutoff)   && $self->hsp_minscore($mincutoff);\n    defined($maxcutoff)   && $self->hsp_maxscore($maxcutoff);\n    $symbols  ||= \\%STRUCTURE_SYMBOLS;\n    $self->structure_symbols($symbols);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    local $/ = \"\\n\";\n    local $_;\n    my ($rm, $d, $descriptor, $file, $oktobuild);\n    my ($hitid, $hitdesc, $hspid, $lastid, $lastscore);\n    my $sprintf;\n    \n    # user-determined Result data\n    my ($accession, $db, $model) =\n       ($self->query_accession, $self->database, $self->model);\n    # HSP building options\n    my $hsp_min = $self->hsp_minscore;\n    my $hsp_max = $self->hsp_maxscore;\n    my $version = $self->algorithm_version;\n    my $laststart;\n    \n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    PARSER:\n    while ( defined( my $line = $self->_readline ) ) {\n        # start of report\n        next if $line =~ m{^\\s+$};\n        if (index($line,'#RM') == 0) {\n            if (index($line,'#RM scored') == 0 ) {\n                if ($seentop) {\n                    $self->_pushback($line);\n                    last PARSER;\n                }\n                $self->start_element({'Name' => 'Result'});\n                $self->element_hash({\n                    'RNAMotif_program'      => 'rnamotif',\n                    'RNAMotif_version'      => $version,\n                    'RNAMotif_query-acc'    => $accession,\n                    'RNAMotif_db'           => $db\n                    });                \n                $seentop = 1;\n                #$self->debug(\"Start result\\n\");\n            } elsif (index($line,'#RM descr') == 0) {\n                ($rm, $d, $descriptor) = split ' ', $line, 3;\n                # toss $rm, $d; keep $descr\n                chomp $descriptor;\n                $self->{'_descriptor'} = $descriptor;\n                $self->element(\n                               {'Name' => 'RNAMotif_querydesc',\n                                'Data' => $descriptor}\n                              );\n            } elsif(index($line,'#RM dfile') == 0) {\n                ($rm, $d, $file) = split ' ', $line, 3;\n                # toss $rm, $d; keep $file\n                chomp $file;\n                $self->element(\n                               {'Name' => 'RNAMotif_query-def',\n                                'Data' => $file}\n                              );\n            } else {\n                $self->debug(\"Unrecognized line: $line\");\n            }\n        } elsif ($line =~ s{^>}{}) {\n            chomp $line;\n            ($hitid, $hitdesc) = split ' ',$line,2;\n            \n            if ($self->within_element('hit') && ($hitid ne $lastid)) {\n                $self->element(\n                       {'Name' => 'Hit_score',\n                        'Data' => $lastscore}\n                      ) if $lastscore;\n                $self->end_element({'Name' => 'Hit'});\n                $self->start_element({'Name' => 'Hit'});\n            } elsif (!$self->within_element('hit')) {\n                $self->start_element({'Name' => 'Hit'});\n            }\n            my ($gi, $acc, $ver) = $self->_get_seq_identifiers($hitid);\n            \n            $self->element_hash({\n                'Hit_id'        => $hitid,\n                'Hit_gi'        => $gi,\n                'Hit_accession' => $ver ? \"$acc.$ver\" :\n                                    $acc ? $acc : $hitid,\n                'Hit_def'       => $hitdesc}\n              );\n            $lastid = $hitid;\n        } elsif ($line =~ m{^(\\S+)\\s+(.+?)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s(.*)$}xm) {\n            chomp $line;\n            my $hspid = $1;\n            my ($score, $strand, $start, $length , $seq) = ($2, $3, $4, $5, $6);\n            $score *= 1;  # implicitly cast any odd '0.000' to float\n            # sanity check ids\n            unless ($hitid eq $hspid) {\n                $self->throw(\"IDs do not match!\");\n            }\n            # check score for possible sprintf data, mark as such, cache result\n            if (!defined($sprintf)) {\n                if ($score =~ m{[^0-9.-]+}gxms) {\n                    if (defined $hsp_min || defined $hsp_max ) {\n                        $self->warn(\"HSP data likely contains custom score; \".\n                                    \"ignoring min/maxscore\");\n                    }\n                    $sprintf = $oktobuild = 1;\n                } else {\n                    $sprintf = 0;\n                }\n            }\n            \n            if (!$sprintf) {\n                if (($hsp_min && $score <= $hsp_min) \n                          || ($hsp_max && ($score >= $hsp_max)) ) {\n                    # do not build HSP\n                    $oktobuild = 0;\n                } else {\n                    $oktobuild = 1;\n                    \n                    # store best hit score based on the hsp min/maxscore only\n                    if (defined $hsp_min && $score > $hsp_min) {\n                        $lastscore = $score if !$lastscore || $score > $lastscore;\n                    } elsif (defined $hsp_max && $score < $hsp_max) {\n                        $lastscore = $score if !$lastscore || $score < $lastscore;\n                    } \n                }\n            }\n            \n            # build HSP\n            if ($oktobuild) {\n                my $end;\n                # calculate start/end\n                if( $strand==0 ) {\n                    $end = $start + $length -1;\n                } else {\n                    $end = $start - $length + 1;\n                }\n                \n                my ($rna, $meta) = $self->_motif2meta($seq, $descriptor);\n                \n                $self->start_element({'Name' => 'Hsp'});\n                my $rnalen = $rna =~ tr{ATGCatgc}{ATGCatgc};\n                $self->element_hash({\n                        'Hsp_stranded'      => 'HIT', \n                        'Hsp_hseq'          => $rna,\n                        'Hsp_query-from'    => 1,\n                        'Hsp_query-to'      =>length($rna),\n                        'Hsp_hit-from'      => $start,\n                        'Hsp_hit-to'        => $end,\n                        'Hsp_structure'     => $meta,\n                        'Hsp_align-len'     => length($rna),\n                        'Hsp_score'         => $sprintf ? undef : $score,\n                        'Hsp_custom-data'   => $sprintf ? $score : undef,\n                        });\n                $self->end_element({'Name' => 'Hsp'});\n                $oktobuild = 0 if (!$sprintf);\n            }\n        }\n    }\n    if ($self->within_element('hit')) {\n        $self->element(\n               {'Name' => 'Hit_score',\n                'Data' => $lastscore}\n              ) if $lastscore;\n        $self->end_element( { 'Name' => 'Hit' } );\n    }\n    if ($seentop) {\n        $self->end_element( { 'Name' => 'Result' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # simple data calls (%MAPPING) do not need start_element\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n\n=head2 element_hash\n\n Title   : element\n Usage   : $eventhandler->element_hash({'Hsp_hit-from' => $start,\n                                        'Hsp_hit-to'   => $end,\n                                        'Hsp_score'    => $lastscore});\n Function: Convenience method that takes multiple simple data elements and\n           maps to appropriate parameters\n Returns : none\n Args    : Hash ref with the mapped key (in %MAPPING) and value\n\n\nsub element_hash {\n    my ($self, $data) = @_;\n    $self->throw(\"Must provide data hash ref\") if !$data || !ref($data);\n    for my $nm (sort keys %{$data}) {\n        next if $data->{$nm} && $data->{$nm} =~ m{^\\s*$}o;\n        if ( $MAPPING{$nm} ) {\n            if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n                my $key = ( keys %{ $MAPPING{$nm} } )[0];\n                $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n                  $data->{$nm};\n            }\n            else {\n                $self->{'_values'}->{ $MAPPING{$nm} } = $data->{$nm};\n            }\n        }\n    }\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n    return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/o );\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if ( !defined $name\n        || !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        return 1 if ( $_ eq $name );\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'within' because 'in' only \n           tests its immediate parent.\n Returns : boolean\n Args    : string element name ","label":"in_element($self,$name)"},"line":556,"range":{"end":{"character":9999,"line":560},"start":{"character":0,"line":556}},"kind":12},{"name":"start_document","containerName":"main::","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"start_document","name":"$self","line":573},{"line":574,"name":"$self","kind":13,"containerName":"start_document"},{"name":"$self","containerName":"start_document","kind":13,"line":575},{"name":"$self","kind":13,"containerName":"start_document","line":576},{"line":577,"kind":13,"containerName":"start_document","name":"$self"}],"detail":"($self)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":572},"end":{"character":9999,"line":578}},"line":572,"signature":{"label":"start_document($self)","documentation":"1;\n# $Id: rnamotif.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::rnamotif\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::rnamotif - SearchIO-based RNAMotif parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is a highly experimental SearchIO-based parser for output from the rnamotif\nprogram (one of the programs in the RNAMotif suite). It currently parses only\nraw rnamotif output for RNAMotif versions 3.0 and above; older versions may work\nbut will not be supported. rmfmt output will not be supported at this time.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::rnamotif;\nuse strict;\n\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        # commented out tags have not been assigned\n        \n        'Hsp_score'        => 'HSP-score',\n        'Hsp_custom-data'  => 'HSP-custom_score',\n        \n        # rnamotif has no evalue\n        \n        # descriptor has no start, end; same as hit start, end\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', \n        'Hsp_hit-to'      => 'HSP-hit_end',\n        \n        # descriptor has no start, end\n        \n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        \n        # build this from scratch, simple WUSS-format\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_stranded'    => 'HSP-stranded',        \n        \n        # not supported for RNAMotif\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_def'       => 'HIT-description',\n        'Hit_score'     => 'HIT-score', # best HSP score\n \n        'RNAMotif_program'  => 'RESULT-algorithm_name', # get/set \n        'RNAMotif_version'  => 'RESULT-algorithm_version', # get/set \n        'RNAMotif_query-def'=> 'RESULT-query_name', # get/set\n        # No length (query is a descriptor)\n        'RNAMotif_query-acc'=> 'RESULT-query_accession', # get/set \n        'RNAMotif_querydesc'=> 'RESULT-query_description', # get/set\n        'RNAMotif_db'       => 'RESULT-database_name',  # get/set \n\t     );\n\n# use structure_delimiters to set custom delimiters\n\nmy @VALID_SYMBOLS = qw(5-prime 3-prime single-strand unknown);\nmy %STRUCTURE_SYMBOLS = (\n                   '5-prime'        => '<',\n                   '3-prime'        => '>',\n                   'single-strand'  => '.',\n                   'unknown'        => '?'\n                    # may add more for quartets, triplets\n                  );\n\nmy $DEFAULT_VERSION = '3.0.3';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO::rnamotif object \n Returns : Bio::SearchIO::rnamotif parser\n Args    : -fh/-file     => RNAMotif filename\n           -format       => 'rnamotif'\n           -model        => query model (or descriptor, in this case)\n           -database     => database name (default undef)\n           -query_acc    => query accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -hsp_maxscore => maximum HSP score cutoff\n           -symbols      => hash ref of structure symbols to use\n                            (default symbols in %STRUCTURE_SYMBOLS hash)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($version, $model, $database, $maxcutoff, $mincutoff, $seqdistance,\n        $accession, $symbols) =\n       $self->_rearrange([qw(VERSION MODEL DATABASE HSP_MAXSCORE \n                          HSP_MINSCORE SEQ_DISTANCE QUERY_ACC SYMBOLS)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose => $self->verbose\n        )\n    );\n    $model      && $self->model($model);\n    $database   && $self->database($database);\n    $accession  && $self->query_accession($accession);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n    $self->throw(\"Cannot define both a minimal and maximal cutoff\")\n           if (defined($mincutoff) && defined($maxcutoff));\n    defined($mincutoff)   && $self->hsp_minscore($mincutoff);\n    defined($maxcutoff)   && $self->hsp_maxscore($maxcutoff);\n    $symbols  ||= \\%STRUCTURE_SYMBOLS;\n    $self->structure_symbols($symbols);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    local $/ = \"\\n\";\n    local $_;\n    my ($rm, $d, $descriptor, $file, $oktobuild);\n    my ($hitid, $hitdesc, $hspid, $lastid, $lastscore);\n    my $sprintf;\n    \n    # user-determined Result data\n    my ($accession, $db, $model) =\n       ($self->query_accession, $self->database, $self->model);\n    # HSP building options\n    my $hsp_min = $self->hsp_minscore;\n    my $hsp_max = $self->hsp_maxscore;\n    my $version = $self->algorithm_version;\n    my $laststart;\n    \n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    PARSER:\n    while ( defined( my $line = $self->_readline ) ) {\n        # start of report\n        next if $line =~ m{^\\s+$};\n        if (index($line,'#RM') == 0) {\n            if (index($line,'#RM scored') == 0 ) {\n                if ($seentop) {\n                    $self->_pushback($line);\n                    last PARSER;\n                }\n                $self->start_element({'Name' => 'Result'});\n                $self->element_hash({\n                    'RNAMotif_program'      => 'rnamotif',\n                    'RNAMotif_version'      => $version,\n                    'RNAMotif_query-acc'    => $accession,\n                    'RNAMotif_db'           => $db\n                    });                \n                $seentop = 1;\n                #$self->debug(\"Start result\\n\");\n            } elsif (index($line,'#RM descr') == 0) {\n                ($rm, $d, $descriptor) = split ' ', $line, 3;\n                # toss $rm, $d; keep $descr\n                chomp $descriptor;\n                $self->{'_descriptor'} = $descriptor;\n                $self->element(\n                               {'Name' => 'RNAMotif_querydesc',\n                                'Data' => $descriptor}\n                              );\n            } elsif(index($line,'#RM dfile') == 0) {\n                ($rm, $d, $file) = split ' ', $line, 3;\n                # toss $rm, $d; keep $file\n                chomp $file;\n                $self->element(\n                               {'Name' => 'RNAMotif_query-def',\n                                'Data' => $file}\n                              );\n            } else {\n                $self->debug(\"Unrecognized line: $line\");\n            }\n        } elsif ($line =~ s{^>}{}) {\n            chomp $line;\n            ($hitid, $hitdesc) = split ' ',$line,2;\n            \n            if ($self->within_element('hit') && ($hitid ne $lastid)) {\n                $self->element(\n                       {'Name' => 'Hit_score',\n                        'Data' => $lastscore}\n                      ) if $lastscore;\n                $self->end_element({'Name' => 'Hit'});\n                $self->start_element({'Name' => 'Hit'});\n            } elsif (!$self->within_element('hit')) {\n                $self->start_element({'Name' => 'Hit'});\n            }\n            my ($gi, $acc, $ver) = $self->_get_seq_identifiers($hitid);\n            \n            $self->element_hash({\n                'Hit_id'        => $hitid,\n                'Hit_gi'        => $gi,\n                'Hit_accession' => $ver ? \"$acc.$ver\" :\n                                    $acc ? $acc : $hitid,\n                'Hit_def'       => $hitdesc}\n              );\n            $lastid = $hitid;\n        } elsif ($line =~ m{^(\\S+)\\s+(.+?)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s(.*)$}xm) {\n            chomp $line;\n            my $hspid = $1;\n            my ($score, $strand, $start, $length , $seq) = ($2, $3, $4, $5, $6);\n            $score *= 1;  # implicitly cast any odd '0.000' to float\n            # sanity check ids\n            unless ($hitid eq $hspid) {\n                $self->throw(\"IDs do not match!\");\n            }\n            # check score for possible sprintf data, mark as such, cache result\n            if (!defined($sprintf)) {\n                if ($score =~ m{[^0-9.-]+}gxms) {\n                    if (defined $hsp_min || defined $hsp_max ) {\n                        $self->warn(\"HSP data likely contains custom score; \".\n                                    \"ignoring min/maxscore\");\n                    }\n                    $sprintf = $oktobuild = 1;\n                } else {\n                    $sprintf = 0;\n                }\n            }\n            \n            if (!$sprintf) {\n                if (($hsp_min && $score <= $hsp_min) \n                          || ($hsp_max && ($score >= $hsp_max)) ) {\n                    # do not build HSP\n                    $oktobuild = 0;\n                } else {\n                    $oktobuild = 1;\n                    \n                    # store best hit score based on the hsp min/maxscore only\n                    if (defined $hsp_min && $score > $hsp_min) {\n                        $lastscore = $score if !$lastscore || $score > $lastscore;\n                    } elsif (defined $hsp_max && $score < $hsp_max) {\n                        $lastscore = $score if !$lastscore || $score < $lastscore;\n                    } \n                }\n            }\n            \n            # build HSP\n            if ($oktobuild) {\n                my $end;\n                # calculate start/end\n                if( $strand==0 ) {\n                    $end = $start + $length -1;\n                } else {\n                    $end = $start - $length + 1;\n                }\n                \n                my ($rna, $meta) = $self->_motif2meta($seq, $descriptor);\n                \n                $self->start_element({'Name' => 'Hsp'});\n                my $rnalen = $rna =~ tr{ATGCatgc}{ATGCatgc};\n                $self->element_hash({\n                        'Hsp_stranded'      => 'HIT', \n                        'Hsp_hseq'          => $rna,\n                        'Hsp_query-from'    => 1,\n                        'Hsp_query-to'      =>length($rna),\n                        'Hsp_hit-from'      => $start,\n                        'Hsp_hit-to'        => $end,\n                        'Hsp_structure'     => $meta,\n                        'Hsp_align-len'     => length($rna),\n                        'Hsp_score'         => $sprintf ? undef : $score,\n                        'Hsp_custom-data'   => $sprintf ? $score : undef,\n                        });\n                $self->end_element({'Name' => 'Hsp'});\n                $oktobuild = 0 if (!$sprintf);\n            }\n        }\n    }\n    if ($self->within_element('hit')) {\n        $self->element(\n               {'Name' => 'Hit_score',\n                'Data' => $lastscore}\n              ) if $lastscore;\n        $self->end_element( { 'Name' => 'Hit' } );\n    }\n    if ($seentop) {\n        $self->end_element( { 'Name' => 'Result' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # simple data calls (%MAPPING) do not need start_element\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n\n=head2 element_hash\n\n Title   : element\n Usage   : $eventhandler->element_hash({'Hsp_hit-from' => $start,\n                                        'Hsp_hit-to'   => $end,\n                                        'Hsp_score'    => $lastscore});\n Function: Convenience method that takes multiple simple data elements and\n           maps to appropriate parameters\n Returns : none\n Args    : Hash ref with the mapped key (in %MAPPING) and value\n\n\nsub element_hash {\n    my ($self, $data) = @_;\n    $self->throw(\"Must provide data hash ref\") if !$data || !ref($data);\n    for my $nm (sort keys %{$data}) {\n        next if $data->{$nm} && $data->{$nm} =~ m{^\\s*$}o;\n        if ( $MAPPING{$nm} ) {\n            if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n                my $key = ( keys %{ $MAPPING{$nm} } )[0];\n                $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n                  $data->{$nm};\n            }\n            else {\n                $self->{'_values'}->{ $MAPPING{$nm} } = $data->{$nm};\n            }\n        }\n    }\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n    return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/o );\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if ( !defined $name\n        || !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        return 1 if ( $_ eq $name );\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'within' because 'in' only \n           tests its immediate parent.\n Returns : boolean\n Args    : string element name \n\n\nsub in_element {\n    my ( $self, $name ) = @_;\n    return 0 if !defined $self->{'_elements'}->[0];\n    return ( $self->{'_elements'}->[0] eq $name );\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handle a start document event\n Returns : none\n Args    : none","parameters":[{"label":"$self"}]}},{"signature":{"label":"end_document($self)","documentation":"1;\n# $Id: rnamotif.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::rnamotif\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::rnamotif - SearchIO-based RNAMotif parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is a highly experimental SearchIO-based parser for output from the rnamotif\nprogram (one of the programs in the RNAMotif suite). It currently parses only\nraw rnamotif output for RNAMotif versions 3.0 and above; older versions may work\nbut will not be supported. rmfmt output will not be supported at this time.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::rnamotif;\nuse strict;\n\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        # commented out tags have not been assigned\n        \n        'Hsp_score'        => 'HSP-score',\n        'Hsp_custom-data'  => 'HSP-custom_score',\n        \n        # rnamotif has no evalue\n        \n        # descriptor has no start, end; same as hit start, end\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', \n        'Hsp_hit-to'      => 'HSP-hit_end',\n        \n        # descriptor has no start, end\n        \n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        \n        # build this from scratch, simple WUSS-format\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_stranded'    => 'HSP-stranded',        \n        \n        # not supported for RNAMotif\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_def'       => 'HIT-description',\n        'Hit_score'     => 'HIT-score', # best HSP score\n \n        'RNAMotif_program'  => 'RESULT-algorithm_name', # get/set \n        'RNAMotif_version'  => 'RESULT-algorithm_version', # get/set \n        'RNAMotif_query-def'=> 'RESULT-query_name', # get/set\n        # No length (query is a descriptor)\n        'RNAMotif_query-acc'=> 'RESULT-query_accession', # get/set \n        'RNAMotif_querydesc'=> 'RESULT-query_description', # get/set\n        'RNAMotif_db'       => 'RESULT-database_name',  # get/set \n\t     );\n\n# use structure_delimiters to set custom delimiters\n\nmy @VALID_SYMBOLS = qw(5-prime 3-prime single-strand unknown);\nmy %STRUCTURE_SYMBOLS = (\n                   '5-prime'        => '<',\n                   '3-prime'        => '>',\n                   'single-strand'  => '.',\n                   'unknown'        => '?'\n                    # may add more for quartets, triplets\n                  );\n\nmy $DEFAULT_VERSION = '3.0.3';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO::rnamotif object \n Returns : Bio::SearchIO::rnamotif parser\n Args    : -fh/-file     => RNAMotif filename\n           -format       => 'rnamotif'\n           -model        => query model (or descriptor, in this case)\n           -database     => database name (default undef)\n           -query_acc    => query accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -hsp_maxscore => maximum HSP score cutoff\n           -symbols      => hash ref of structure symbols to use\n                            (default symbols in %STRUCTURE_SYMBOLS hash)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($version, $model, $database, $maxcutoff, $mincutoff, $seqdistance,\n        $accession, $symbols) =\n       $self->_rearrange([qw(VERSION MODEL DATABASE HSP_MAXSCORE \n                          HSP_MINSCORE SEQ_DISTANCE QUERY_ACC SYMBOLS)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose => $self->verbose\n        )\n    );\n    $model      && $self->model($model);\n    $database   && $self->database($database);\n    $accession  && $self->query_accession($accession);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n    $self->throw(\"Cannot define both a minimal and maximal cutoff\")\n           if (defined($mincutoff) && defined($maxcutoff));\n    defined($mincutoff)   && $self->hsp_minscore($mincutoff);\n    defined($maxcutoff)   && $self->hsp_maxscore($maxcutoff);\n    $symbols  ||= \\%STRUCTURE_SYMBOLS;\n    $self->structure_symbols($symbols);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    local $/ = \"\\n\";\n    local $_;\n    my ($rm, $d, $descriptor, $file, $oktobuild);\n    my ($hitid, $hitdesc, $hspid, $lastid, $lastscore);\n    my $sprintf;\n    \n    # user-determined Result data\n    my ($accession, $db, $model) =\n       ($self->query_accession, $self->database, $self->model);\n    # HSP building options\n    my $hsp_min = $self->hsp_minscore;\n    my $hsp_max = $self->hsp_maxscore;\n    my $version = $self->algorithm_version;\n    my $laststart;\n    \n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    PARSER:\n    while ( defined( my $line = $self->_readline ) ) {\n        # start of report\n        next if $line =~ m{^\\s+$};\n        if (index($line,'#RM') == 0) {\n            if (index($line,'#RM scored') == 0 ) {\n                if ($seentop) {\n                    $self->_pushback($line);\n                    last PARSER;\n                }\n                $self->start_element({'Name' => 'Result'});\n                $self->element_hash({\n                    'RNAMotif_program'      => 'rnamotif',\n                    'RNAMotif_version'      => $version,\n                    'RNAMotif_query-acc'    => $accession,\n                    'RNAMotif_db'           => $db\n                    });                \n                $seentop = 1;\n                #$self->debug(\"Start result\\n\");\n            } elsif (index($line,'#RM descr') == 0) {\n                ($rm, $d, $descriptor) = split ' ', $line, 3;\n                # toss $rm, $d; keep $descr\n                chomp $descriptor;\n                $self->{'_descriptor'} = $descriptor;\n                $self->element(\n                               {'Name' => 'RNAMotif_querydesc',\n                                'Data' => $descriptor}\n                              );\n            } elsif(index($line,'#RM dfile') == 0) {\n                ($rm, $d, $file) = split ' ', $line, 3;\n                # toss $rm, $d; keep $file\n                chomp $file;\n                $self->element(\n                               {'Name' => 'RNAMotif_query-def',\n                                'Data' => $file}\n                              );\n            } else {\n                $self->debug(\"Unrecognized line: $line\");\n            }\n        } elsif ($line =~ s{^>}{}) {\n            chomp $line;\n            ($hitid, $hitdesc) = split ' ',$line,2;\n            \n            if ($self->within_element('hit') && ($hitid ne $lastid)) {\n                $self->element(\n                       {'Name' => 'Hit_score',\n                        'Data' => $lastscore}\n                      ) if $lastscore;\n                $self->end_element({'Name' => 'Hit'});\n                $self->start_element({'Name' => 'Hit'});\n            } elsif (!$self->within_element('hit')) {\n                $self->start_element({'Name' => 'Hit'});\n            }\n            my ($gi, $acc, $ver) = $self->_get_seq_identifiers($hitid);\n            \n            $self->element_hash({\n                'Hit_id'        => $hitid,\n                'Hit_gi'        => $gi,\n                'Hit_accession' => $ver ? \"$acc.$ver\" :\n                                    $acc ? $acc : $hitid,\n                'Hit_def'       => $hitdesc}\n              );\n            $lastid = $hitid;\n        } elsif ($line =~ m{^(\\S+)\\s+(.+?)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s(.*)$}xm) {\n            chomp $line;\n            my $hspid = $1;\n            my ($score, $strand, $start, $length , $seq) = ($2, $3, $4, $5, $6);\n            $score *= 1;  # implicitly cast any odd '0.000' to float\n            # sanity check ids\n            unless ($hitid eq $hspid) {\n                $self->throw(\"IDs do not match!\");\n            }\n            # check score for possible sprintf data, mark as such, cache result\n            if (!defined($sprintf)) {\n                if ($score =~ m{[^0-9.-]+}gxms) {\n                    if (defined $hsp_min || defined $hsp_max ) {\n                        $self->warn(\"HSP data likely contains custom score; \".\n                                    \"ignoring min/maxscore\");\n                    }\n                    $sprintf = $oktobuild = 1;\n                } else {\n                    $sprintf = 0;\n                }\n            }\n            \n            if (!$sprintf) {\n                if (($hsp_min && $score <= $hsp_min) \n                          || ($hsp_max && ($score >= $hsp_max)) ) {\n                    # do not build HSP\n                    $oktobuild = 0;\n                } else {\n                    $oktobuild = 1;\n                    \n                    # store best hit score based on the hsp min/maxscore only\n                    if (defined $hsp_min && $score > $hsp_min) {\n                        $lastscore = $score if !$lastscore || $score > $lastscore;\n                    } elsif (defined $hsp_max && $score < $hsp_max) {\n                        $lastscore = $score if !$lastscore || $score < $lastscore;\n                    } \n                }\n            }\n            \n            # build HSP\n            if ($oktobuild) {\n                my $end;\n                # calculate start/end\n                if( $strand==0 ) {\n                    $end = $start + $length -1;\n                } else {\n                    $end = $start - $length + 1;\n                }\n                \n                my ($rna, $meta) = $self->_motif2meta($seq, $descriptor);\n                \n                $self->start_element({'Name' => 'Hsp'});\n                my $rnalen = $rna =~ tr{ATGCatgc}{ATGCatgc};\n                $self->element_hash({\n                        'Hsp_stranded'      => 'HIT', \n                        'Hsp_hseq'          => $rna,\n                        'Hsp_query-from'    => 1,\n                        'Hsp_query-to'      =>length($rna),\n                        'Hsp_hit-from'      => $start,\n                        'Hsp_hit-to'        => $end,\n                        'Hsp_structure'     => $meta,\n                        'Hsp_align-len'     => length($rna),\n                        'Hsp_score'         => $sprintf ? undef : $score,\n                        'Hsp_custom-data'   => $sprintf ? $score : undef,\n                        });\n                $self->end_element({'Name' => 'Hsp'});\n                $oktobuild = 0 if (!$sprintf);\n            }\n        }\n    }\n    if ($self->within_element('hit')) {\n        $self->element(\n               {'Name' => 'Hit_score',\n                'Data' => $lastscore}\n              ) if $lastscore;\n        $self->end_element( { 'Name' => 'Hit' } );\n    }\n    if ($seentop) {\n        $self->end_element( { 'Name' => 'Result' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # simple data calls (%MAPPING) do not need start_element\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n\n=head2 element_hash\n\n Title   : element\n Usage   : $eventhandler->element_hash({'Hsp_hit-from' => $start,\n                                        'Hsp_hit-to'   => $end,\n                                        'Hsp_score'    => $lastscore});\n Function: Convenience method that takes multiple simple data elements and\n           maps to appropriate parameters\n Returns : none\n Args    : Hash ref with the mapped key (in %MAPPING) and value\n\n\nsub element_hash {\n    my ($self, $data) = @_;\n    $self->throw(\"Must provide data hash ref\") if !$data || !ref($data);\n    for my $nm (sort keys %{$data}) {\n        next if $data->{$nm} && $data->{$nm} =~ m{^\\s*$}o;\n        if ( $MAPPING{$nm} ) {\n            if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n                my $key = ( keys %{ $MAPPING{$nm} } )[0];\n                $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n                  $data->{$nm};\n            }\n            else {\n                $self->{'_values'}->{ $MAPPING{$nm} } = $data->{$nm};\n            }\n        }\n    }\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n    return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/o );\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if ( !defined $name\n        || !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        return 1 if ( $_ eq $name );\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'within' because 'in' only \n           tests its immediate parent.\n Returns : boolean\n Args    : string element name \n\n\nsub in_element {\n    my ( $self, $name ) = @_;\n    return 0 if !defined $self->{'_elements'}->[0];\n    return ( $self->{'_elements'}->[0] eq $name );\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handle a start document event\n Returns : none\n Args    : none\n\n\nsub start_document {\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'}   = {};\n    $self->{'_result'}   = undef;\n    $self->{'_elements'} = [];\n}\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $eventgenerator->end_document\n Function: Handles an end document event\n Returns : Bio::Search::Result::ResultI object\n Args    : none","parameters":[{"label":"$self"}]},"kind":12,"range":{"start":{"line":590,"character":0},"end":{"line":593,"character":9999}},"line":590,"detail":"($self)","definition":"sub","name":"end_document","containerName":"main::","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"end_document","line":591,"definition":"my"},{"containerName":"end_document","kind":13,"name":"$self","line":592}]},{"kind":12,"range":{"end":{"character":9999,"line":608},"start":{"character":0,"line":605}},"line":605,"definition":"sub","containerName":"main::","name":"result_count","children":[{"definition":"my","line":606,"name":"$self","localvar":"my","containerName":"result_count","kind":13},{"name":"$self","kind":13,"containerName":"result_count","line":607}]},{"name":"descriptor","containerName":"main::","children":[{"definition":"my","line":623,"name":"$self","localvar":"my","kind":13,"containerName":"descriptor"},{"name":"$self","containerName":"descriptor","kind":13,"line":624},{"line":625,"containerName":"descriptor","kind":13,"name":"$self"}],"definition":"sub","range":{"end":{"line":626,"character":9999},"start":{"line":622,"character":0}},"kind":12,"line":622},{"name":"model","containerName":"main::","children":[{"line":640,"name":"descriptor","containerName":"model","kind":12}],"definition":"sub","kind":12,"range":{"start":{"character":0,"line":640},"end":{"line":640,"character":9999}},"line":640},{"definition":"sub","name":"database","containerName":"main::","children":[{"line":654,"name":"$self","containerName":"database","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"database","name":"$self","line":655},{"line":656,"kind":13,"containerName":"database","name":"$self"}],"range":{"end":{"character":9999,"line":657},"start":{"line":653,"character":0}},"kind":12,"line":653},{"definition":"sub","name":"query_accession","containerName":"main::","children":[{"definition":"my","line":671,"kind":13,"localvar":"my","containerName":"query_accession","name":"$self"},{"line":672,"containerName":"query_accession","kind":13,"name":"$self"},{"line":673,"name":"$self","kind":13,"containerName":"query_accession"}],"range":{"end":{"line":674,"character":9999},"start":{"line":670,"character":0}},"kind":12,"line":670},{"definition":"sub","containerName":"main::","name":"algorithm_version","children":[{"line":687,"containerName":"algorithm_version","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":688,"name":"$self","containerName":"algorithm_version","kind":13},{"containerName":"algorithm_version","kind":13,"name":"$self","line":689}],"range":{"end":{"line":690,"character":9999},"start":{"character":0,"line":686}},"kind":12,"line":686},{"line":703,"range":{"end":{"line":709,"character":9999},"start":{"character":0,"line":703}},"kind":12,"children":[{"definition":"my","name":"$self","localvar":"my","containerName":"hsp_minscore","kind":13,"line":704},{"line":704,"kind":13,"containerName":"hsp_minscore","name":"$score"},{"name":"$self","kind":13,"containerName":"hsp_minscore","line":705},{"name":"throw","containerName":"hsp_minscore","kind":12,"line":705},{"kind":13,"containerName":"hsp_minscore","name":"$score","line":706},{"line":706,"name":"$score","kind":13,"containerName":"hsp_minscore"},{"line":707,"kind":13,"containerName":"hsp_minscore","name":"$self"},{"kind":13,"containerName":"hsp_minscore","name":"$self","line":708}],"containerName":"main::","name":"hsp_minscore","definition":"sub"},{"definition":"sub","name":"hsp_maxscore","containerName":"main::","children":[{"line":723,"name":"$self","localvar":"my","kind":13,"containerName":"hsp_maxscore","definition":"my"},{"line":723,"containerName":"hsp_maxscore","kind":13,"name":"$score"},{"line":724,"kind":13,"containerName":"hsp_maxscore","name":"$self"},{"kind":12,"containerName":"hsp_maxscore","name":"throw","line":724},{"line":725,"name":"$score","kind":13,"containerName":"hsp_maxscore"},{"name":"$score","containerName":"hsp_maxscore","kind":13,"line":725},{"name":"$self","containerName":"hsp_maxscore","kind":13,"line":726},{"line":727,"name":"$self","containerName":"hsp_maxscore","kind":13}],"range":{"end":{"line":728,"character":9999},"start":{"line":722,"character":0}},"kind":12,"line":722},{"signature":{"label":"structure_symbols($self,$delim)","parameters":[{"label":"$self"},{"label":"$delim"}],"documentation":"1;\n# $Id: rnamotif.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::rnamotif\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::rnamotif - SearchIO-based RNAMotif parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is a highly experimental SearchIO-based parser for output from the rnamotif\nprogram (one of the programs in the RNAMotif suite). It currently parses only\nraw rnamotif output for RNAMotif versions 3.0 and above; older versions may work\nbut will not be supported. rmfmt output will not be supported at this time.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::rnamotif;\nuse strict;\n\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        # commented out tags have not been assigned\n        \n        'Hsp_score'        => 'HSP-score',\n        'Hsp_custom-data'  => 'HSP-custom_score',\n        \n        # rnamotif has no evalue\n        \n        # descriptor has no start, end; same as hit start, end\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', \n        'Hsp_hit-to'      => 'HSP-hit_end',\n        \n        # descriptor has no start, end\n        \n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        \n        # build this from scratch, simple WUSS-format\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_stranded'    => 'HSP-stranded',        \n        \n        # not supported for RNAMotif\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_def'       => 'HIT-description',\n        'Hit_score'     => 'HIT-score', # best HSP score\n \n        'RNAMotif_program'  => 'RESULT-algorithm_name', # get/set \n        'RNAMotif_version'  => 'RESULT-algorithm_version', # get/set \n        'RNAMotif_query-def'=> 'RESULT-query_name', # get/set\n        # No length (query is a descriptor)\n        'RNAMotif_query-acc'=> 'RESULT-query_accession', # get/set \n        'RNAMotif_querydesc'=> 'RESULT-query_description', # get/set\n        'RNAMotif_db'       => 'RESULT-database_name',  # get/set \n\t     );\n\n# use structure_delimiters to set custom delimiters\n\nmy @VALID_SYMBOLS = qw(5-prime 3-prime single-strand unknown);\nmy %STRUCTURE_SYMBOLS = (\n                   '5-prime'        => '<',\n                   '3-prime'        => '>',\n                   'single-strand'  => '.',\n                   'unknown'        => '?'\n                    # may add more for quartets, triplets\n                  );\n\nmy $DEFAULT_VERSION = '3.0.3';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO::rnamotif object \n Returns : Bio::SearchIO::rnamotif parser\n Args    : -fh/-file     => RNAMotif filename\n           -format       => 'rnamotif'\n           -model        => query model (or descriptor, in this case)\n           -database     => database name (default undef)\n           -query_acc    => query accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -hsp_maxscore => maximum HSP score cutoff\n           -symbols      => hash ref of structure symbols to use\n                            (default symbols in %STRUCTURE_SYMBOLS hash)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($version, $model, $database, $maxcutoff, $mincutoff, $seqdistance,\n        $accession, $symbols) =\n       $self->_rearrange([qw(VERSION MODEL DATABASE HSP_MAXSCORE \n                          HSP_MINSCORE SEQ_DISTANCE QUERY_ACC SYMBOLS)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose => $self->verbose\n        )\n    );\n    $model      && $self->model($model);\n    $database   && $self->database($database);\n    $accession  && $self->query_accession($accession);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n    $self->throw(\"Cannot define both a minimal and maximal cutoff\")\n           if (defined($mincutoff) && defined($maxcutoff));\n    defined($mincutoff)   && $self->hsp_minscore($mincutoff);\n    defined($maxcutoff)   && $self->hsp_maxscore($maxcutoff);\n    $symbols  ||= \\%STRUCTURE_SYMBOLS;\n    $self->structure_symbols($symbols);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    local $/ = \"\\n\";\n    local $_;\n    my ($rm, $d, $descriptor, $file, $oktobuild);\n    my ($hitid, $hitdesc, $hspid, $lastid, $lastscore);\n    my $sprintf;\n    \n    # user-determined Result data\n    my ($accession, $db, $model) =\n       ($self->query_accession, $self->database, $self->model);\n    # HSP building options\n    my $hsp_min = $self->hsp_minscore;\n    my $hsp_max = $self->hsp_maxscore;\n    my $version = $self->algorithm_version;\n    my $laststart;\n    \n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    PARSER:\n    while ( defined( my $line = $self->_readline ) ) {\n        # start of report\n        next if $line =~ m{^\\s+$};\n        if (index($line,'#RM') == 0) {\n            if (index($line,'#RM scored') == 0 ) {\n                if ($seentop) {\n                    $self->_pushback($line);\n                    last PARSER;\n                }\n                $self->start_element({'Name' => 'Result'});\n                $self->element_hash({\n                    'RNAMotif_program'      => 'rnamotif',\n                    'RNAMotif_version'      => $version,\n                    'RNAMotif_query-acc'    => $accession,\n                    'RNAMotif_db'           => $db\n                    });                \n                $seentop = 1;\n                #$self->debug(\"Start result\\n\");\n            } elsif (index($line,'#RM descr') == 0) {\n                ($rm, $d, $descriptor) = split ' ', $line, 3;\n                # toss $rm, $d; keep $descr\n                chomp $descriptor;\n                $self->{'_descriptor'} = $descriptor;\n                $self->element(\n                               {'Name' => 'RNAMotif_querydesc',\n                                'Data' => $descriptor}\n                              );\n            } elsif(index($line,'#RM dfile') == 0) {\n                ($rm, $d, $file) = split ' ', $line, 3;\n                # toss $rm, $d; keep $file\n                chomp $file;\n                $self->element(\n                               {'Name' => 'RNAMotif_query-def',\n                                'Data' => $file}\n                              );\n            } else {\n                $self->debug(\"Unrecognized line: $line\");\n            }\n        } elsif ($line =~ s{^>}{}) {\n            chomp $line;\n            ($hitid, $hitdesc) = split ' ',$line,2;\n            \n            if ($self->within_element('hit') && ($hitid ne $lastid)) {\n                $self->element(\n                       {'Name' => 'Hit_score',\n                        'Data' => $lastscore}\n                      ) if $lastscore;\n                $self->end_element({'Name' => 'Hit'});\n                $self->start_element({'Name' => 'Hit'});\n            } elsif (!$self->within_element('hit')) {\n                $self->start_element({'Name' => 'Hit'});\n            }\n            my ($gi, $acc, $ver) = $self->_get_seq_identifiers($hitid);\n            \n            $self->element_hash({\n                'Hit_id'        => $hitid,\n                'Hit_gi'        => $gi,\n                'Hit_accession' => $ver ? \"$acc.$ver\" :\n                                    $acc ? $acc : $hitid,\n                'Hit_def'       => $hitdesc}\n              );\n            $lastid = $hitid;\n        } elsif ($line =~ m{^(\\S+)\\s+(.+?)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s(.*)$}xm) {\n            chomp $line;\n            my $hspid = $1;\n            my ($score, $strand, $start, $length , $seq) = ($2, $3, $4, $5, $6);\n            $score *= 1;  # implicitly cast any odd '0.000' to float\n            # sanity check ids\n            unless ($hitid eq $hspid) {\n                $self->throw(\"IDs do not match!\");\n            }\n            # check score for possible sprintf data, mark as such, cache result\n            if (!defined($sprintf)) {\n                if ($score =~ m{[^0-9.-]+}gxms) {\n                    if (defined $hsp_min || defined $hsp_max ) {\n                        $self->warn(\"HSP data likely contains custom score; \".\n                                    \"ignoring min/maxscore\");\n                    }\n                    $sprintf = $oktobuild = 1;\n                } else {\n                    $sprintf = 0;\n                }\n            }\n            \n            if (!$sprintf) {\n                if (($hsp_min && $score <= $hsp_min) \n                          || ($hsp_max && ($score >= $hsp_max)) ) {\n                    # do not build HSP\n                    $oktobuild = 0;\n                } else {\n                    $oktobuild = 1;\n                    \n                    # store best hit score based on the hsp min/maxscore only\n                    if (defined $hsp_min && $score > $hsp_min) {\n                        $lastscore = $score if !$lastscore || $score > $lastscore;\n                    } elsif (defined $hsp_max && $score < $hsp_max) {\n                        $lastscore = $score if !$lastscore || $score < $lastscore;\n                    } \n                }\n            }\n            \n            # build HSP\n            if ($oktobuild) {\n                my $end;\n                # calculate start/end\n                if( $strand==0 ) {\n                    $end = $start + $length -1;\n                } else {\n                    $end = $start - $length + 1;\n                }\n                \n                my ($rna, $meta) = $self->_motif2meta($seq, $descriptor);\n                \n                $self->start_element({'Name' => 'Hsp'});\n                my $rnalen = $rna =~ tr{ATGCatgc}{ATGCatgc};\n                $self->element_hash({\n                        'Hsp_stranded'      => 'HIT', \n                        'Hsp_hseq'          => $rna,\n                        'Hsp_query-from'    => 1,\n                        'Hsp_query-to'      =>length($rna),\n                        'Hsp_hit-from'      => $start,\n                        'Hsp_hit-to'        => $end,\n                        'Hsp_structure'     => $meta,\n                        'Hsp_align-len'     => length($rna),\n                        'Hsp_score'         => $sprintf ? undef : $score,\n                        'Hsp_custom-data'   => $sprintf ? $score : undef,\n                        });\n                $self->end_element({'Name' => 'Hsp'});\n                $oktobuild = 0 if (!$sprintf);\n            }\n        }\n    }\n    if ($self->within_element('hit')) {\n        $self->element(\n               {'Name' => 'Hit_score',\n                'Data' => $lastscore}\n              ) if $lastscore;\n        $self->end_element( { 'Name' => 'Hit' } );\n    }\n    if ($seentop) {\n        $self->end_element( { 'Name' => 'Result' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # simple data calls (%MAPPING) do not need start_element\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n\n=head2 element_hash\n\n Title   : element\n Usage   : $eventhandler->element_hash({'Hsp_hit-from' => $start,\n                                        'Hsp_hit-to'   => $end,\n                                        'Hsp_score'    => $lastscore});\n Function: Convenience method that takes multiple simple data elements and\n           maps to appropriate parameters\n Returns : none\n Args    : Hash ref with the mapped key (in %MAPPING) and value\n\n\nsub element_hash {\n    my ($self, $data) = @_;\n    $self->throw(\"Must provide data hash ref\") if !$data || !ref($data);\n    for my $nm (sort keys %{$data}) {\n        next if $data->{$nm} && $data->{$nm} =~ m{^\\s*$}o;\n        if ( $MAPPING{$nm} ) {\n            if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n                my $key = ( keys %{ $MAPPING{$nm} } )[0];\n                $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n                  $data->{$nm};\n            }\n            else {\n                $self->{'_values'}->{ $MAPPING{$nm} } = $data->{$nm};\n            }\n        }\n    }\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n    return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/o );\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if ( !defined $name\n        || !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        return 1 if ( $_ eq $name );\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'within' because 'in' only \n           tests its immediate parent.\n Returns : boolean\n Args    : string element name \n\n\nsub in_element {\n    my ( $self, $name ) = @_;\n    return 0 if !defined $self->{'_elements'}->[0];\n    return ( $self->{'_elements'}->[0] eq $name );\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handle a start document event\n Returns : none\n Args    : none\n\n\nsub start_document {\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'}   = {};\n    $self->{'_result'}   = undef;\n    $self->{'_elements'} = [];\n}\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $eventgenerator->end_document\n Function: Handles an end document event\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub end_document {\n    my ($self) = @_;\n    return $self->{'_result'};\n}\n\n=head2 result_count\n\n Title   : result_count\n Usage   : my $count = $searchio->result_count\n Function: Returns the number of results we have processed\n Returns : integer\n Args    : none\n\n\nsub result_count {\n    my $self = shift;\n    return $self->{'_result_count'};\n}\n\n=head2 descriptor\n\n Title   : descriptor\n Usage   : my $descr = $parser->descriptor();\n Function: Get/Set descriptor name.  Some versions of RNAMotif do not add the\n           descriptor name to the output.  This also overrides any name found\n           while parsing.\n Returns : String (name of model)\n Args    : [optional] String (name of model)\n\n\nsub descriptor {\n    my $self = shift;\n    return $self->{'_descriptor'} = shift if @_;\n    return $self->{'_descriptor'};\n}\n\n=head2 model\n\n Title   : model\n Usage   : my $model = $parser->model();\n Function: Get/Set model; Infernal currently does not output\n           the model name (Rfam ID)\n Returns : String (name of model)\n Args    : [optional] String (name of model)\n Note    : this is a synonym for descriptor()\n\n\nsub model { shift->descriptor(@_) }\n\n=head2 database\n\n Title   : database\n Usage   : my $database = $parser->database();\n Function: Get/Set database; Infernal currently does not output\n           the database name\n Returns : String (database name)\n Args    : [optional] String (database name)\n\n\nsub database {\n    my $self = shift;\n    return $self->{'_database'} = shift if @_;\n    return $self->{'_database'};\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : my $acc = $parser->query_accession();\n Function: Get/Set query (model) accession; RNAMotif currently does not output\n           the accession number\n Returns : String (accession)\n Args    : [optional] String (accession)\n\n\nsub query_accession {\n    my $self = shift;\n    return $self->{'_query_accession'} = shift if @_;\n    return $self->{'_query_accession'};\n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $ver = $parser->algorithm_version();\n Function: Get/Set algorithm version (not defined in RNAMotif output)\n Returns : String (accession)\n Args    : [optional] String (accession)\n\n\nsub algorithm_version {\n    my $self = shift;\n    return $self->{'_algorithm'} = shift if @_;\n    return $self->{'_algorithm'};\n}\n\n=head2 hsp_minscore\n\n Title   : hsp_minscore\n Usage   : my $cutoff = $parser->hsp_minscore();\n Function: Get/Set min score cutoff (for generating Hits/HSPs).\n Returns : score (number)\n Args    : [optional] score (number)\n Note    : Cannot be set along with hsp_maxscore()\n\n\nsub hsp_minscore {\n    my ($self, $score) = shift;\n    $self->throw('Minscore not set to a number') if\n        ($score && $score !~ m{[0-9.]+});\n    return $self->{'_hsp_minscore'} = shift if @_;\n    return $self->{'_hsp_minscore'};\n}\n\n=head2 hsp_maxscore\n\n Title   : hsp_maxscore\n Usage   : my $cutoff = $parser->hsp_maxscore();\n Function: Get/Set max score cutoff (for generating Hits/HSPs).\n Returns : score (number)\n Args    : [optional] score (number)\n Note    : Cannot be set along with hsp_minscore()\n\n\nsub hsp_maxscore {\n    my ($self, $score) = shift;\n    $self->throw('Maxscore not set to a number') if\n        ($score && $score !~ m{[0-9.]+});\n    return $self->{'_hsp_maxscore'} = shift if @_;\n    return $self->{'_hsp_maxscore'};\n}\n\n=head2 structure_symbols\n\n Title   : structure_symbols\n Usage   : my $hashref = $parser->structure_symbols();\n Function: Get/Set RNA structure symbols\n Returns : Hash ref of delimiters (5' stem, 3' stem, single-strand, etc)\n         : default = < (5-prime)\n                     > (3-prime)\n                     . (single-strand)\n                     ? (unknown) \n Args    : Hash ref of substitute delimiters, using above keys."},"line":744,"kind":12,"range":{"end":{"character":9999,"line":757},"start":{"line":744,"character":0}},"definition":"sub","detail":"($self,$delim)","children":[{"line":745,"kind":13,"localvar":"my","containerName":"structure_symbols","name":"$self","definition":"my"},{"name":"$delim","kind":13,"containerName":"structure_symbols","line":745},{"line":746,"name":"$delim","kind":13,"containerName":"structure_symbols"},{"line":747,"name":"$delim","kind":13,"containerName":"structure_symbols"},{"line":748,"name":"%data","containerName":"structure_symbols","localvar":"my","kind":13,"definition":"my"},{"line":748,"containerName":"structure_symbols","kind":13,"name":"$delim"},{"definition":"my","name":"$d","localvar":"my","kind":13,"containerName":"structure_symbols","line":749},{"name":"@VALID_SYMBOLS","containerName":"structure_symbols","kind":13,"line":749},{"containerName":"structure_symbols","kind":13,"name":"$data","line":750},{"containerName":"structure_symbols","kind":13,"name":"$d","line":750},{"kind":13,"containerName":"structure_symbols","name":"$self","line":751},{"line":751,"name":"$d","containerName":"structure_symbols","kind":13},{"line":751,"name":"$data","containerName":"structure_symbols","kind":13},{"line":751,"containerName":"structure_symbols","kind":13,"name":"$d"},{"line":755,"kind":13,"containerName":"structure_symbols","name":"$self"},{"name":"throw","containerName":"structure_symbols","kind":12,"line":755}],"containerName":"main::","name":"structure_symbols"},{"name":"%self","containerName":null,"kind":13,"line":758},{"definition":"sub","detail":"($self,$str,$descriptor)","children":[{"containerName":"_motif2meta","localvar":"my","kind":13,"name":"$self","line":779,"definition":"my"},{"line":779,"containerName":"_motif2meta","kind":13,"name":"$str"},{"kind":13,"containerName":"_motif2meta","name":"$descriptor","line":779},{"definition":"my","localvar":"my","kind":13,"containerName":"_motif2meta","name":"$rna","line":780},{"kind":13,"containerName":"_motif2meta","name":"$meta","line":780},{"line":781,"name":"@desc_el","containerName":"_motif2meta","localvar":"my","kind":13,"definition":"my"},{"name":"$descriptor","kind":13,"containerName":"_motif2meta","line":781},{"name":"@seq_el","localvar":"my","containerName":"_motif2meta","kind":13,"line":782,"definition":"my"},{"line":782,"containerName":"_motif2meta","kind":13,"name":"$str"},{"name":"$symbol","kind":13,"localvar":"my","containerName":"_motif2meta","line":783,"definition":"my"},{"line":783,"name":"$self","kind":13,"containerName":"_motif2meta"},{"line":783,"name":"structure_symbols","containerName":"_motif2meta","kind":12},{"line":785,"name":"$self","kind":13,"containerName":"_motif2meta"},{"line":785,"name":"throw","kind":12,"containerName":"_motif2meta"},{"line":787,"kind":13,"containerName":"_motif2meta","name":"@desc_el"},{"definition":"my","name":"$struct","localvar":"my","kind":13,"containerName":"_motif2meta","line":788},{"definition":"my","kind":13,"localvar":"my","containerName":"_motif2meta","name":"$seq","line":789},{"name":"$motif","kind":13,"containerName":"_motif2meta","line":789},{"line":789,"containerName":"_motif2meta","kind":13,"name":"@seq_el"},{"line":789,"name":"@desc_el","kind":13,"containerName":"_motif2meta"},{"containerName":"_motif2meta","kind":13,"name":"$struct","line":790},{"name":"$motif","kind":13,"containerName":"_motif2meta","line":790},{"name":"$symbol","containerName":"_motif2meta","kind":13,"line":790},{"name":"$motif","containerName":"_motif2meta","kind":13,"line":791},{"name":"$symbol","kind":13,"containerName":"_motif2meta","line":791},{"line":792,"name":"$motif","containerName":"_motif2meta","kind":13},{"containerName":"_motif2meta","kind":13,"name":"$symbol","line":792},{"name":"$motif","kind":13,"containerName":"_motif2meta","line":793},{"line":793,"name":"$symbol","containerName":"_motif2meta","kind":13},{"name":"$symbol","kind":13,"containerName":"_motif2meta","line":794},{"line":795,"containerName":"_motif2meta","kind":13,"name":"$meta"},{"line":795,"name":"$struct","containerName":"_motif2meta","kind":13},{"name":"$seq","containerName":"_motif2meta","kind":13,"line":795},{"line":796,"containerName":"_motif2meta","kind":13,"name":"$rna"},{"line":796,"name":"$seq","kind":13,"containerName":"_motif2meta"},{"line":798,"name":"$rna","containerName":"_motif2meta","kind":13},{"line":798,"name":"$meta","kind":13,"containerName":"_motif2meta"}],"name":"_motif2meta","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$str"},{"label":"$descriptor"}],"documentation":"1;\n# $Id: rnamotif.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::rnamotif\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::rnamotif - SearchIO-based RNAMotif parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is a highly experimental SearchIO-based parser for output from the rnamotif\nprogram (one of the programs in the RNAMotif suite). It currently parses only\nraw rnamotif output for RNAMotif versions 3.0 and above; older versions may work\nbut will not be supported. rmfmt output will not be supported at this time.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::rnamotif;\nuse strict;\n\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        # commented out tags have not been assigned\n        \n        'Hsp_score'        => 'HSP-score',\n        'Hsp_custom-data'  => 'HSP-custom_score',\n        \n        # rnamotif has no evalue\n        \n        # descriptor has no start, end; same as hit start, end\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', \n        'Hsp_hit-to'      => 'HSP-hit_end',\n        \n        # descriptor has no start, end\n        \n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        \n        # build this from scratch, simple WUSS-format\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_stranded'    => 'HSP-stranded',        \n        \n        # not supported for RNAMotif\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_def'       => 'HIT-description',\n        'Hit_score'     => 'HIT-score', # best HSP score\n \n        'RNAMotif_program'  => 'RESULT-algorithm_name', # get/set \n        'RNAMotif_version'  => 'RESULT-algorithm_version', # get/set \n        'RNAMotif_query-def'=> 'RESULT-query_name', # get/set\n        # No length (query is a descriptor)\n        'RNAMotif_query-acc'=> 'RESULT-query_accession', # get/set \n        'RNAMotif_querydesc'=> 'RESULT-query_description', # get/set\n        'RNAMotif_db'       => 'RESULT-database_name',  # get/set \n\t     );\n\n# use structure_delimiters to set custom delimiters\n\nmy @VALID_SYMBOLS = qw(5-prime 3-prime single-strand unknown);\nmy %STRUCTURE_SYMBOLS = (\n                   '5-prime'        => '<',\n                   '3-prime'        => '>',\n                   'single-strand'  => '.',\n                   'unknown'        => '?'\n                    # may add more for quartets, triplets\n                  );\n\nmy $DEFAULT_VERSION = '3.0.3';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO::rnamotif object \n Returns : Bio::SearchIO::rnamotif parser\n Args    : -fh/-file     => RNAMotif filename\n           -format       => 'rnamotif'\n           -model        => query model (or descriptor, in this case)\n           -database     => database name (default undef)\n           -query_acc    => query accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -hsp_maxscore => maximum HSP score cutoff\n           -symbols      => hash ref of structure symbols to use\n                            (default symbols in %STRUCTURE_SYMBOLS hash)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($version, $model, $database, $maxcutoff, $mincutoff, $seqdistance,\n        $accession, $symbols) =\n       $self->_rearrange([qw(VERSION MODEL DATABASE HSP_MAXSCORE \n                          HSP_MINSCORE SEQ_DISTANCE QUERY_ACC SYMBOLS)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose => $self->verbose\n        )\n    );\n    $model      && $self->model($model);\n    $database   && $self->database($database);\n    $accession  && $self->query_accession($accession);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n    $self->throw(\"Cannot define both a minimal and maximal cutoff\")\n           if (defined($mincutoff) && defined($maxcutoff));\n    defined($mincutoff)   && $self->hsp_minscore($mincutoff);\n    defined($maxcutoff)   && $self->hsp_maxscore($maxcutoff);\n    $symbols  ||= \\%STRUCTURE_SYMBOLS;\n    $self->structure_symbols($symbols);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    local $/ = \"\\n\";\n    local $_;\n    my ($rm, $d, $descriptor, $file, $oktobuild);\n    my ($hitid, $hitdesc, $hspid, $lastid, $lastscore);\n    my $sprintf;\n    \n    # user-determined Result data\n    my ($accession, $db, $model) =\n       ($self->query_accession, $self->database, $self->model);\n    # HSP building options\n    my $hsp_min = $self->hsp_minscore;\n    my $hsp_max = $self->hsp_maxscore;\n    my $version = $self->algorithm_version;\n    my $laststart;\n    \n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    PARSER:\n    while ( defined( my $line = $self->_readline ) ) {\n        # start of report\n        next if $line =~ m{^\\s+$};\n        if (index($line,'#RM') == 0) {\n            if (index($line,'#RM scored') == 0 ) {\n                if ($seentop) {\n                    $self->_pushback($line);\n                    last PARSER;\n                }\n                $self->start_element({'Name' => 'Result'});\n                $self->element_hash({\n                    'RNAMotif_program'      => 'rnamotif',\n                    'RNAMotif_version'      => $version,\n                    'RNAMotif_query-acc'    => $accession,\n                    'RNAMotif_db'           => $db\n                    });                \n                $seentop = 1;\n                #$self->debug(\"Start result\\n\");\n            } elsif (index($line,'#RM descr') == 0) {\n                ($rm, $d, $descriptor) = split ' ', $line, 3;\n                # toss $rm, $d; keep $descr\n                chomp $descriptor;\n                $self->{'_descriptor'} = $descriptor;\n                $self->element(\n                               {'Name' => 'RNAMotif_querydesc',\n                                'Data' => $descriptor}\n                              );\n            } elsif(index($line,'#RM dfile') == 0) {\n                ($rm, $d, $file) = split ' ', $line, 3;\n                # toss $rm, $d; keep $file\n                chomp $file;\n                $self->element(\n                               {'Name' => 'RNAMotif_query-def',\n                                'Data' => $file}\n                              );\n            } else {\n                $self->debug(\"Unrecognized line: $line\");\n            }\n        } elsif ($line =~ s{^>}{}) {\n            chomp $line;\n            ($hitid, $hitdesc) = split ' ',$line,2;\n            \n            if ($self->within_element('hit') && ($hitid ne $lastid)) {\n                $self->element(\n                       {'Name' => 'Hit_score',\n                        'Data' => $lastscore}\n                      ) if $lastscore;\n                $self->end_element({'Name' => 'Hit'});\n                $self->start_element({'Name' => 'Hit'});\n            } elsif (!$self->within_element('hit')) {\n                $self->start_element({'Name' => 'Hit'});\n            }\n            my ($gi, $acc, $ver) = $self->_get_seq_identifiers($hitid);\n            \n            $self->element_hash({\n                'Hit_id'        => $hitid,\n                'Hit_gi'        => $gi,\n                'Hit_accession' => $ver ? \"$acc.$ver\" :\n                                    $acc ? $acc : $hitid,\n                'Hit_def'       => $hitdesc}\n              );\n            $lastid = $hitid;\n        } elsif ($line =~ m{^(\\S+)\\s+(.+?)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s(.*)$}xm) {\n            chomp $line;\n            my $hspid = $1;\n            my ($score, $strand, $start, $length , $seq) = ($2, $3, $4, $5, $6);\n            $score *= 1;  # implicitly cast any odd '0.000' to float\n            # sanity check ids\n            unless ($hitid eq $hspid) {\n                $self->throw(\"IDs do not match!\");\n            }\n            # check score for possible sprintf data, mark as such, cache result\n            if (!defined($sprintf)) {\n                if ($score =~ m{[^0-9.-]+}gxms) {\n                    if (defined $hsp_min || defined $hsp_max ) {\n                        $self->warn(\"HSP data likely contains custom score; \".\n                                    \"ignoring min/maxscore\");\n                    }\n                    $sprintf = $oktobuild = 1;\n                } else {\n                    $sprintf = 0;\n                }\n            }\n            \n            if (!$sprintf) {\n                if (($hsp_min && $score <= $hsp_min) \n                          || ($hsp_max && ($score >= $hsp_max)) ) {\n                    # do not build HSP\n                    $oktobuild = 0;\n                } else {\n                    $oktobuild = 1;\n                    \n                    # store best hit score based on the hsp min/maxscore only\n                    if (defined $hsp_min && $score > $hsp_min) {\n                        $lastscore = $score if !$lastscore || $score > $lastscore;\n                    } elsif (defined $hsp_max && $score < $hsp_max) {\n                        $lastscore = $score if !$lastscore || $score < $lastscore;\n                    } \n                }\n            }\n            \n            # build HSP\n            if ($oktobuild) {\n                my $end;\n                # calculate start/end\n                if( $strand==0 ) {\n                    $end = $start + $length -1;\n                } else {\n                    $end = $start - $length + 1;\n                }\n                \n                my ($rna, $meta) = $self->_motif2meta($seq, $descriptor);\n                \n                $self->start_element({'Name' => 'Hsp'});\n                my $rnalen = $rna =~ tr{ATGCatgc}{ATGCatgc};\n                $self->element_hash({\n                        'Hsp_stranded'      => 'HIT', \n                        'Hsp_hseq'          => $rna,\n                        'Hsp_query-from'    => 1,\n                        'Hsp_query-to'      =>length($rna),\n                        'Hsp_hit-from'      => $start,\n                        'Hsp_hit-to'        => $end,\n                        'Hsp_structure'     => $meta,\n                        'Hsp_align-len'     => length($rna),\n                        'Hsp_score'         => $sprintf ? undef : $score,\n                        'Hsp_custom-data'   => $sprintf ? $score : undef,\n                        });\n                $self->end_element({'Name' => 'Hsp'});\n                $oktobuild = 0 if (!$sprintf);\n            }\n        }\n    }\n    if ($self->within_element('hit')) {\n        $self->element(\n               {'Name' => 'Hit_score',\n                'Data' => $lastscore}\n              ) if $lastscore;\n        $self->end_element( { 'Name' => 'Hit' } );\n    }\n    if ($seentop) {\n        $self->end_element( { 'Name' => 'Result' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # simple data calls (%MAPPING) do not need start_element\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n\n=head2 element_hash\n\n Title   : element\n Usage   : $eventhandler->element_hash({'Hsp_hit-from' => $start,\n                                        'Hsp_hit-to'   => $end,\n                                        'Hsp_score'    => $lastscore});\n Function: Convenience method that takes multiple simple data elements and\n           maps to appropriate parameters\n Returns : none\n Args    : Hash ref with the mapped key (in %MAPPING) and value\n\n\nsub element_hash {\n    my ($self, $data) = @_;\n    $self->throw(\"Must provide data hash ref\") if !$data || !ref($data);\n    for my $nm (sort keys %{$data}) {\n        next if $data->{$nm} && $data->{$nm} =~ m{^\\s*$}o;\n        if ( $MAPPING{$nm} ) {\n            if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n                my $key = ( keys %{ $MAPPING{$nm} } )[0];\n                $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n                  $data->{$nm};\n            }\n            else {\n                $self->{'_values'}->{ $MAPPING{$nm} } = $data->{$nm};\n            }\n        }\n    }\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n    return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/o );\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if ( !defined $name\n        || !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        return 1 if ( $_ eq $name );\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'within' because 'in' only \n           tests its immediate parent.\n Returns : boolean\n Args    : string element name \n\n\nsub in_element {\n    my ( $self, $name ) = @_;\n    return 0 if !defined $self->{'_elements'}->[0];\n    return ( $self->{'_elements'}->[0] eq $name );\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handle a start document event\n Returns : none\n Args    : none\n\n\nsub start_document {\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'}   = {};\n    $self->{'_result'}   = undef;\n    $self->{'_elements'} = [];\n}\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $eventgenerator->end_document\n Function: Handles an end document event\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub end_document {\n    my ($self) = @_;\n    return $self->{'_result'};\n}\n\n=head2 result_count\n\n Title   : result_count\n Usage   : my $count = $searchio->result_count\n Function: Returns the number of results we have processed\n Returns : integer\n Args    : none\n\n\nsub result_count {\n    my $self = shift;\n    return $self->{'_result_count'};\n}\n\n=head2 descriptor\n\n Title   : descriptor\n Usage   : my $descr = $parser->descriptor();\n Function: Get/Set descriptor name.  Some versions of RNAMotif do not add the\n           descriptor name to the output.  This also overrides any name found\n           while parsing.\n Returns : String (name of model)\n Args    : [optional] String (name of model)\n\n\nsub descriptor {\n    my $self = shift;\n    return $self->{'_descriptor'} = shift if @_;\n    return $self->{'_descriptor'};\n}\n\n=head2 model\n\n Title   : model\n Usage   : my $model = $parser->model();\n Function: Get/Set model; Infernal currently does not output\n           the model name (Rfam ID)\n Returns : String (name of model)\n Args    : [optional] String (name of model)\n Note    : this is a synonym for descriptor()\n\n\nsub model { shift->descriptor(@_) }\n\n=head2 database\n\n Title   : database\n Usage   : my $database = $parser->database();\n Function: Get/Set database; Infernal currently does not output\n           the database name\n Returns : String (database name)\n Args    : [optional] String (database name)\n\n\nsub database {\n    my $self = shift;\n    return $self->{'_database'} = shift if @_;\n    return $self->{'_database'};\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : my $acc = $parser->query_accession();\n Function: Get/Set query (model) accession; RNAMotif currently does not output\n           the accession number\n Returns : String (accession)\n Args    : [optional] String (accession)\n\n\nsub query_accession {\n    my $self = shift;\n    return $self->{'_query_accession'} = shift if @_;\n    return $self->{'_query_accession'};\n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $ver = $parser->algorithm_version();\n Function: Get/Set algorithm version (not defined in RNAMotif output)\n Returns : String (accession)\n Args    : [optional] String (accession)\n\n\nsub algorithm_version {\n    my $self = shift;\n    return $self->{'_algorithm'} = shift if @_;\n    return $self->{'_algorithm'};\n}\n\n=head2 hsp_minscore\n\n Title   : hsp_minscore\n Usage   : my $cutoff = $parser->hsp_minscore();\n Function: Get/Set min score cutoff (for generating Hits/HSPs).\n Returns : score (number)\n Args    : [optional] score (number)\n Note    : Cannot be set along with hsp_maxscore()\n\n\nsub hsp_minscore {\n    my ($self, $score) = shift;\n    $self->throw('Minscore not set to a number') if\n        ($score && $score !~ m{[0-9.]+});\n    return $self->{'_hsp_minscore'} = shift if @_;\n    return $self->{'_hsp_minscore'};\n}\n\n=head2 hsp_maxscore\n\n Title   : hsp_maxscore\n Usage   : my $cutoff = $parser->hsp_maxscore();\n Function: Get/Set max score cutoff (for generating Hits/HSPs).\n Returns : score (number)\n Args    : [optional] score (number)\n Note    : Cannot be set along with hsp_minscore()\n\n\nsub hsp_maxscore {\n    my ($self, $score) = shift;\n    $self->throw('Maxscore not set to a number') if\n        ($score && $score !~ m{[0-9.]+});\n    return $self->{'_hsp_maxscore'} = shift if @_;\n    return $self->{'_hsp_maxscore'};\n}\n\n=head2 structure_symbols\n\n Title   : structure_symbols\n Usage   : my $hashref = $parser->structure_symbols();\n Function: Get/Set RNA structure symbols\n Returns : Hash ref of delimiters (5' stem, 3' stem, single-strand, etc)\n         : default = < (5-prime)\n                     > (3-prime)\n                     . (single-strand)\n                     ? (unknown) \n Args    : Hash ref of substitute delimiters, using above keys.\n\n\nsub structure_symbols {\n    my ($self, $delim) = @_;\n    if ($delim) {\n        if (ref($delim) =~ m{HASH}) {\n            my %data = %{ $delim };\n            for my $d (@VALID_SYMBOLS) {\n                if ( exists $data{$d} ) {\n                    $self->{'_delimiter'}->{$d} = $data{$d};\n                }\n            }\n        } else {\n            $self->throw(\"Args to helix_delimiters() should be in a hash reference\");\n        }\n    }\n    return $self->{'_delimiter'};\n}\n\n#Private methods\n\n=head2 _motif2meta\n\n Title   : _motif2meta\n Usage   : my ($rna, $meta) = $parser->_motif2meta($str, $descr);\n Function: Creates meta string from sequence and descriptor\n Returns : array of sequence, meta strings\n Args    : Array of string data and descriptor data\n\n Note: This is currently a quick and simple way of making simple\n RNA structures (stem-loops, helices, etc) from RNAMotif descriptor\n data in the output file.  It does not currently work with pseudoknots,\n triplets, G-quartets, or other more complex RNA structural motifs.","label":"_motif2meta($self,$str,$descriptor)"},"line":778,"kind":12,"range":{"start":{"line":778,"character":0},"end":{"character":9999,"line":799}}},{"line":784,"name":"desc_el","kind":12},{"kind":12,"name":"seq_el","line":784}]}