{"version":5,"vars":[{"line":119,"kind":2,"containerName":"","name":"vars"},{"line":121,"name":"base","containerName":"","kind":2},{"line":123,"name":"%MODEMAP","containerName":null,"kind":13},{"name":"%MAPPING","kind":13,"containerName":null,"line":128},{"name":"$DEFAULT_WRITER_CLASS","kind":13,"containerName":null,"line":157},{"line":159,"name":"$MIN_INTRON","kind":13,"containerName":null},{"line":179,"kind":12,"range":{"start":{"line":179,"character":0},"end":{"character":9999,"line":197}},"definition":"sub","children":[{"line":180,"name":"$class","localvar":"my","kind":13,"containerName":"new","definition":"my"},{"line":181,"localvar":"my","containerName":"new","kind":13,"name":"$self","definition":"my"},{"line":181,"containerName":"new","kind":13,"name":"$class"},{"line":183,"name":"$min_intron","localvar":"my","containerName":"new","kind":13,"definition":"my"},{"name":"$cigar","kind":13,"containerName":"new","line":183},{"name":"$vulgar","containerName":"new","kind":13,"line":184},{"line":184,"containerName":"new","kind":13,"name":"$self"},{"name":"_rearrange","containerName":"new","kind":12,"line":184},{"line":187,"name":"$min_intron","kind":13,"containerName":"new"},{"line":188,"containerName":"new","kind":13,"name":"$MIN_INTRON"},{"line":188,"name":"$min_intron","kind":13,"containerName":"new"},{"name":"$cigar","kind":13,"containerName":"new","line":190},{"line":190,"name":"$vulgar","containerName":"new","kind":13},{"line":191,"containerName":"new","kind":13,"name":"$self"},{"name":"warn","containerName":"new","kind":12,"line":191},{"line":192,"kind":13,"containerName":"new","name":"$cigar"},{"name":"$vulgar","kind":13,"containerName":"new","line":192},{"line":194,"kind":13,"containerName":"new","name":"$self"},{"name":"cigar","kind":12,"containerName":"new","line":194},{"kind":13,"containerName":"new","name":"$cigar","line":194},{"kind":13,"containerName":"new","name":"$self","line":195},{"line":195,"kind":12,"containerName":"new","name":"vulgar"},{"line":195,"name":"$vulgar","containerName":"new","kind":13},{"name":"$self","containerName":"new","kind":13,"line":196}],"name":"new","containerName":"main::"},{"name":"SUPER","kind":12,"containerName":"new","line":181},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: exonerate.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::exonerate\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::exonerate - parser for Exonerate\n\n=head1 SYNOPSIS\n\n  # do not use this module directly, it is a driver for SearchIO\n\n  use Bio::SearchIO;\n  my $searchio = Bio::SearchIO->new(-file => 'file.exonerate',\n                                   -format => 'exonerate');\n\n\n  while( my $r = $searchio->next_result ) {\n    print $r->query_name, \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis is a driver for the SearchIO system for parsing Exonerate (Guy\nSlater) output.  You can get Exonerate at\nhttp://www.ebi.ac.uk/~guy/exonerate/\n[until Guy puts up a Web reference,publication for it.]).\n\nAn optional parameter -min_intron is supported by the L<new>\ninitialization method.  This is if you run Exonerate with a different\nminimum intron length (default is 30) the parser will be able to\ndetect the difference between standard deletions and an intron.  Still\nsome room to play with there that might cause this to get\nmisinterpreted that has not been fully tested or explored.\n\nThe VULGAR and CIGAR formats should be parsed okay now creating HSPs\nwhere appropriate (so merging match states where appropriate rather\nthan breaking an HSP at each indel as it may have done in the past).\nThe GFF that comes from exonerate is still probably a better way to go\nif you are doing protein2genome or est2genome mapping.\nFor example you can see this script:\n\n### TODO: Jason, this link is dead, do we have an updated one?\nhttp://fungal.genome.duke.edu/~jes12/software/scripts/process_exonerate_gff3.perl.txt\n\nIf your report contains both CIGAR and VULGAR lines only the first one\nwill processed for a given Query/Target pair.  If you preferentially\nwant to use VULGAR or CIGAR add one of these options when initializing\nthe SearchIO object.\n\n    -cigar  => 1\nOR\n    -vulgar => 1\n\nOr set them via these methods.\n\n    $parser->cigar(1)\nOR\n    $parser->vulgar(1)\n\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::exonerate;\nuse strict;\nuse vars qw(@STATES %MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $MIN_INTRON);\n\nuse base qw(Bio::SearchIO);\n\n%MODEMAP = ( 'ExonerateOutput' => 'result',\n    'Hit'             => 'hit',\n    'Hsp'             => 'hsp'\n    );\n\n%MAPPING =\n    (\n    'Hsp_query-from'=>  'HSP-query_start',\n    'Hsp_query-to'  =>  'HSP-query_end',\n    'Hsp_hit-from'  =>  'HSP-hit_start',\n    'Hsp_hit-to'    =>  'HSP-hit_end',\n    'Hsp_qseq'      =>  'HSP-query_seq',\n    'Hsp_hseq'      =>  'HSP-hit_seq',\n    'Hsp_midline'   =>  'HSP-homology_seq',\n    'Hsp_score'     =>  'HSP-score',\n    'Hsp_qlength'   =>  'HSP-query_length',\n    'Hsp_hlength'   =>  'HSP-hit_length',\n    'Hsp_align-len' =>  'HSP-hsp_length',\n    'Hsp_identity'  =>  'HSP-identical',\n    'Hsp_gaps'       => 'HSP-hsp_gaps',\n    'Hsp_hitgaps'    => 'HSP-hit_gaps',\n    'Hsp_querygaps'  => 'HSP-query_gaps',\n\n    'Hit_id'        => 'HIT-name',\n    'Hit_desc'      => 'HIT-description',\n    'Hit_len'       => 'HIT-length',\n    'Hit_score'     => 'HIT-score',\n\n    'ExonerateOutput_program'   => 'RESULT-algorithm_name',\n    'ExonerateOutput_query-def' => 'RESULT-query_name',\n    'ExonerateOutput_query-desc'=> 'RESULT-query_description',\n    'ExonerateOutput_query-len' => 'RESULT-query_length',\n    );\n\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n$MIN_INTRON=30; # This is the minimum intron size\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::exonerate->new();\n Function: Builds a new Bio::SearchIO::exonerate object\n Returns : an instance of Bio::SearchIO::exonerate\n Args    : -min_intron => somewhat obselete option, how to determine if a\n                          an indel is an intron or a local gap.  Use VULGAR\n                          rather than CIGAR to avoid this heuristic,default 30.\n           -cigar       => 1   set this to 1 if you want to parse\n                               CIGAR exclusively.\n           -vulgar      => 1   set this to 1 if you want to parse VULGAR\n                               exclusively, setting both to 1 will revert\n                               to the default behavior of just parsing the\n                               first line that it sees.\n\n\nsub new {\n    my ($class) = shift;\n    my $self = $class->SUPER::new(@_);\n\n    my ($min_intron,$cigar,\n\t$vulgar) = $self->_rearrange([qw(MIN_INTRON\n\t\t\t\t\t CIGAR\n\t\t\t\t\t VULGAR)], @_);\n    if( $min_intron ) {\n\t$MIN_INTRON = $min_intron;\n    }\n    if( $cigar && $vulgar ) {\n\t$self->warn(\"cannot get HSPs from both CIGAR and VULGAR lines, will just choose whichever comes first (same as if you had chosen neither\");\n\t$cigar = 0; $vulgar=0;\n    }\n    $self->cigar($cigar);\n    $self->vulgar($vulgar);\n    $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none","label":"next_result($self)"},"line":209,"kind":12,"range":{"start":{"line":209,"character":0},"end":{"character":9999,"line":543}},"definition":"sub","detail":"($self)","children":[{"localvar":"my","containerName":"next_result","kind":13,"name":"$self","line":210,"definition":"my"},{"kind":13,"containerName":"next_result","name":"$self","line":214},{"definition":"my","name":"$reporttype","localvar":"my","kind":13,"containerName":"next_result","line":215},{"containerName":"next_result","kind":13,"name":"$seenquery","line":215},{"line":215,"name":"$reportline","containerName":"next_result","kind":13},{"line":216,"kind":13,"containerName":"next_result","name":"$self"},{"line":216,"name":"start_document","containerName":"next_result","kind":12},{"definition":"my","name":"@hit_signifs","containerName":"next_result","localvar":"my","kind":13,"line":217},{"name":"$seentop","kind":13,"localvar":"my","containerName":"next_result","line":218,"definition":"my"},{"name":"@q_ex","containerName":"next_result","localvar":"my","kind":13,"line":219,"definition":"my"},{"line":219,"kind":13,"containerName":"next_result","name":"@m_ex"},{"containerName":"next_result","kind":13,"name":"@h_ex","line":219},{"name":"$self","containerName":"next_result","kind":13,"line":220},{"name":"_readline","containerName":"next_result","kind":12,"line":220},{"line":223,"name":"$seentop","kind":13,"containerName":"next_result"},{"line":224,"containerName":"next_result","kind":13,"name":"$self"},{"line":224,"name":"end_element","kind":12,"containerName":"next_result"},{"line":225,"name":"$self","containerName":"next_result","kind":13},{"line":225,"containerName":"next_result","kind":12,"name":"_pushback"},{"line":226,"containerName":"next_result","kind":13,"name":"$self"},{"line":226,"name":"end_document","kind":12,"containerName":"next_result"},{"line":228,"name":"$seentop","kind":13,"containerName":"next_result"},{"definition":"my","name":"$nm","localvar":"my","containerName":"next_result","kind":13,"line":229},{"line":229,"name":"$desc","kind":13,"containerName":"next_result"},{"line":230,"name":"$desc","containerName":"next_result","kind":13},{"containerName":"next_result","kind":13,"name":"$desc","line":230},{"line":231,"kind":13,"containerName":"next_result","name":"$self"},{"containerName":"next_result","kind":13,"name":"$self","line":232},{"line":232,"kind":12,"containerName":"next_result","name":"start_element"},{"name":"$self","containerName":"next_result","kind":13,"line":233},{"line":233,"name":"element","kind":12,"containerName":"next_result"},{"name":"$nm","kind":13,"containerName":"next_result","line":234},{"kind":13,"containerName":"next_result","name":"$self","line":235},{"name":"element","containerName":"next_result","kind":12,"line":235},{"name":"$desc","containerName":"next_result","kind":13,"line":236},{"kind":13,"containerName":"next_result","name":"$self","line":237},{"line":237,"kind":12,"containerName":"next_result","name":"element"},{"kind":13,"containerName":"next_result","name":"$self","line":239},{"containerName":"next_result","kind":13,"name":"$self","line":240},{"definition":"my","line":243,"name":"$nm","localvar":"my","containerName":"next_result","kind":13},{"line":243,"name":"$desc","kind":13,"containerName":"next_result"},{"line":244,"name":"$desc","containerName":"next_result","kind":13},{"line":244,"name":"$desc","containerName":"next_result","kind":13},{"line":245,"containerName":"next_result","kind":13,"name":"$self"},{"name":"start_element","containerName":"next_result","kind":12,"line":245},{"kind":13,"containerName":"next_result","name":"$self","line":246},{"line":246,"name":"element","containerName":"next_result","kind":12},{"line":247,"containerName":"next_result","kind":13,"name":"$nm"},{"kind":13,"containerName":"next_result","name":"$self","line":248},{"line":248,"kind":12,"containerName":"next_result","name":"element"},{"name":"$desc","containerName":"next_result","kind":13,"line":249},{"line":250,"name":"$self","containerName":"next_result","kind":13},{"name":"$self","kind":13,"containerName":"next_result","line":251},{"containerName":"next_result","kind":13,"name":"$self","line":258},{"name":"cigar","containerName":"next_result","kind":12,"line":258},{"line":258,"kind":13,"containerName":"next_result","name":"$self"},{"containerName":"next_result","kind":13,"name":"$self","line":259},{"name":"$self","kind":13,"containerName":"next_result","line":264},{"name":"within_element","containerName":"next_result","kind":12,"line":264},{"line":265,"name":"$self","kind":13,"containerName":"next_result"},{"kind":12,"containerName":"next_result","name":"start_element","line":265},{"name":"$self","containerName":"next_result","kind":13,"line":266},{"name":"element","containerName":"next_result","kind":12,"line":266},{"line":269,"containerName":"next_result","kind":13,"name":"$self"},{"kind":12,"containerName":"next_result","name":"within_element","line":269},{"line":270,"containerName":"next_result","kind":13,"name":"$self"},{"line":270,"containerName":"next_result","kind":12,"name":"start_element"},{"line":271,"name":"$self","kind":13,"containerName":"next_result"},{"line":271,"kind":12,"containerName":"next_result","name":"element"},{"localvar":"my","kind":13,"containerName":"next_result","name":"$qs","line":278,"definition":"my"},{"name":"$qe","kind":13,"containerName":"next_result","line":278},{"name":"$qstrand","kind":13,"containerName":"next_result","line":278},{"definition":"my","line":279,"localvar":"my","containerName":"next_result","kind":13,"name":"$hs"},{"containerName":"next_result","kind":13,"name":"$he","line":279},{"line":279,"name":"$hstrand","kind":13,"containerName":"next_result"},{"definition":"my","name":"$score","containerName":"next_result","localvar":"my","kind":13,"line":280},{"localvar":"my","containerName":"next_result","kind":13,"name":"@rest","line":290,"definition":"my"},{"containerName":"next_result","localvar":"my","kind":13,"name":"$qbegin","line":291,"definition":"my"},{"line":291,"name":"$qend","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"$qstrand","line":293},{"line":294,"name":"$qstrand","containerName":"next_result","kind":13},{"line":294,"kind":13,"containerName":"next_result","name":"$qe"},{"containerName":"next_result","kind":13,"name":"$qstrand","line":296},{"line":297,"name":"$qs","containerName":"next_result","kind":13},{"definition":"my","line":299,"name":"$hbegin","localvar":"my","kind":13,"containerName":"next_result"},{"name":"$hend","kind":13,"containerName":"next_result","line":299},{"name":"$hstrand","containerName":"next_result","kind":13,"line":301},{"line":302,"name":"$hstrand","kind":13,"containerName":"next_result"},{"name":"$he","kind":13,"containerName":"next_result","line":303},{"line":305,"name":"$hstrand","kind":13,"containerName":"next_result"},{"name":"$hs","containerName":"next_result","kind":13,"line":306},{"definition":"my","name":"$aln_len","containerName":"next_result","localvar":"my","kind":13,"line":311},{"line":311,"name":"$inserts","kind":13,"containerName":"next_result"},{"name":"$deletes","kind":13,"containerName":"next_result","line":311},{"definition":"my","line":312,"name":"$laststate","localvar":"my","containerName":"next_result","kind":13},{"line":312,"containerName":"next_result","kind":13,"name":"@events"},{"name":"$gaps","kind":13,"containerName":"next_result","line":312},{"name":"@rest","containerName":"next_result","kind":13,"line":313},{"definition":"my","line":314,"localvar":"my","containerName":"next_result","kind":13,"name":"$state"},{"name":"$len1","containerName":"next_result","kind":13,"line":314},{"line":314,"kind":13,"containerName":"next_result","name":"$len2"},{"name":"@rest","containerName":"next_result","kind":13,"line":314},{"line":314,"containerName":"next_result","kind":13,"name":"@rest"},{"line":314,"kind":13,"containerName":"next_result","name":"@rest"},{"name":"$state","kind":13,"containerName":"next_result","line":320},{"line":321,"containerName":"next_result","kind":13,"name":"$laststate"},{"name":"$events","containerName":"next_result","kind":13,"line":324},{"kind":13,"containerName":"next_result","name":"$qend","line":324},{"name":"$qs","containerName":"next_result","kind":13,"line":324},{"name":"$len1","containerName":"next_result","kind":13,"line":324},{"line":324,"name":"$qstrand","kind":13,"containerName":"next_result"},{"line":324,"name":"$qstrand","containerName":"next_result","kind":13},{"line":325,"kind":13,"containerName":"next_result","name":"$events"},{"line":325,"name":"$hend","containerName":"next_result","kind":13},{"line":325,"name":"$hs","kind":13,"containerName":"next_result"},{"line":325,"name":"$len2","kind":13,"containerName":"next_result"},{"line":325,"name":"$hstrand","containerName":"next_result","kind":13},{"line":325,"name":"$hstrand","containerName":"next_result","kind":13},{"line":326,"name":"$events","containerName":"next_result","kind":13},{"kind":13,"containerName":"next_result","name":"$gaps","line":326},{"name":"@events","containerName":"next_result","kind":13,"line":328},{"containerName":"next_result","kind":13,"name":"$score","line":329},{"kind":13,"containerName":"next_result","name":"$len1","line":330},{"name":"$qbegin","kind":13,"containerName":"next_result","line":331},{"name":"$qs","kind":13,"containerName":"next_result","line":331},{"line":332,"name":"$qend","containerName":"next_result","kind":13},{"kind":13,"containerName":"next_result","name":"$qs","line":332},{"kind":13,"containerName":"next_result","name":"$len1","line":332},{"line":332,"containerName":"next_result","kind":13,"name":"$qstrand"},{"line":332,"name":"$qstrand","containerName":"next_result","kind":13},{"line":333,"containerName":"next_result","kind":13,"name":"$hbegin"},{"line":333,"name":"$hs","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"$hend","line":334},{"line":334,"name":"$hs","kind":13,"containerName":"next_result"},{"name":"$len2","containerName":"next_result","kind":13,"line":334},{"line":334,"containerName":"next_result","kind":13,"name":"$hstrand"},{"line":334,"containerName":"next_result","kind":13,"name":"$hstrand"},{"kind":13,"containerName":"next_result","name":"$gaps","line":337},{"line":339,"name":"$gaps","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"$len1","line":339},{"line":339,"name":"$len2","containerName":"next_result","kind":13},{"line":339,"name":"$state","kind":13,"containerName":"next_result"},{"name":"$qs","containerName":"next_result","kind":13,"line":341},{"name":"$len1","containerName":"next_result","kind":13,"line":341},{"line":341,"kind":13,"containerName":"next_result","name":"$qstrand"},{"containerName":"next_result","kind":13,"name":"$hs","line":342},{"line":342,"kind":13,"containerName":"next_result","name":"$len2"},{"containerName":"next_result","kind":13,"name":"$hstrand","line":342},{"kind":13,"containerName":"next_result","name":"$laststate","line":343},{"name":"$state","kind":13,"containerName":"next_result","line":343},{"localvar":"my","kind":13,"containerName":"next_result","name":"$event","line":345,"definition":"my"},{"line":345,"containerName":"next_result","kind":13,"name":"@events"},{"line":346,"name":"$self","kind":13,"containerName":"next_result"},{"kind":12,"containerName":"next_result","name":"start_element","line":346},{"definition":"my","name":"$key","localvar":"my","kind":13,"containerName":"next_result","line":347},{"line":347,"containerName":"next_result","kind":13,"name":"$val"},{"line":347,"name":"$event","containerName":"next_result","kind":13},{"line":348,"name":"$self","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":12,"name":"element","line":348},{"line":349,"name":"$val","containerName":"next_result","kind":13},{"line":351,"name":"$self","containerName":"next_result","kind":13},{"line":351,"name":"element","containerName":"next_result","kind":12},{"kind":13,"containerName":"next_result","name":"$self","line":353},{"containerName":"next_result","kind":12,"name":"end_element","line":353},{"line":357,"name":"$self","containerName":"next_result","kind":13},{"name":"element","kind":12,"containerName":"next_result","line":357},{"name":"$score","kind":13,"containerName":"next_result","line":358},{"containerName":"next_result","kind":13,"name":"$self","line":360},{"containerName":"next_result","kind":12,"name":"end_element","line":360},{"line":361,"name":"$self","kind":13,"containerName":"next_result"},{"line":361,"containerName":"next_result","kind":12,"name":"end_element"},{"containerName":"next_result","kind":13,"name":"$self","line":363},{"kind":12,"containerName":"next_result","name":"end_document","line":363},{"line":371,"name":"$self","containerName":"next_result","kind":13},{"kind":12,"containerName":"next_result","name":"vulgar","line":371},{"containerName":"next_result","kind":13,"name":"$self","line":371},{"kind":13,"containerName":"next_result","name":"$self","line":372},{"kind":13,"containerName":"next_result","name":"$self","line":374},{"containerName":"next_result","kind":12,"name":"within_element","line":374},{"line":375,"containerName":"next_result","kind":13,"name":"$self"},{"name":"start_element","containerName":"next_result","kind":12,"line":375},{"kind":13,"containerName":"next_result","name":"$self","line":376},{"containerName":"next_result","kind":12,"name":"element","line":376},{"name":"$self","containerName":"next_result","kind":13,"line":379},{"line":379,"name":"within_element","kind":12,"containerName":"next_result"},{"line":380,"kind":13,"containerName":"next_result","name":"$self"},{"kind":12,"containerName":"next_result","name":"start_element","line":380},{"line":381,"name":"$self","containerName":"next_result","kind":13},{"line":381,"name":"element","kind":12,"containerName":"next_result"},{"name":"$qs","localvar":"my","kind":13,"containerName":"next_result","line":387,"definition":"my"},{"containerName":"next_result","kind":13,"name":"$qe","line":387},{"line":387,"containerName":"next_result","kind":13,"name":"$qstrand"},{"definition":"my","name":"$hs","localvar":"my","kind":13,"containerName":"next_result","line":388},{"kind":13,"containerName":"next_result","name":"$he","line":388},{"name":"$hstrand","containerName":"next_result","kind":13,"line":388},{"definition":"my","name":"$score","localvar":"my","containerName":"next_result","kind":13,"line":389},{"name":"@rest","kind":13,"localvar":"my","containerName":"next_result","line":395,"definition":"my"},{"name":"$qstrand","containerName":"next_result","kind":13,"line":396},{"line":397,"containerName":"next_result","kind":13,"name":"$qstrand"},{"line":398,"kind":13,"containerName":"next_result","name":"$qs"},{"line":398,"name":"$qe","containerName":"next_result","kind":13},{"name":"$qe","containerName":"next_result","kind":13,"line":398},{"kind":13,"containerName":"next_result","name":"$qs","line":398},{"containerName":"next_result","kind":13,"name":"$qs","line":399},{"line":399,"kind":13,"containerName":"next_result","name":"$qe"},{"containerName":"next_result","kind":13,"name":"$qstrand","line":400},{"line":401,"kind":13,"containerName":"next_result","name":"$hstrand"},{"line":402,"name":"$hstrand","kind":13,"containerName":"next_result"},{"line":403,"kind":13,"containerName":"next_result","name":"$hs"},{"name":"$he","containerName":"next_result","kind":13,"line":403},{"line":403,"containerName":"next_result","kind":13,"name":"$he"},{"line":403,"kind":13,"containerName":"next_result","name":"$hs"},{"kind":13,"containerName":"next_result","name":"$hs","line":404},{"kind":13,"containerName":"next_result","name":"$he","line":404},{"line":405,"name":"$hstrand","containerName":"next_result","kind":13},{"name":"$qs","containerName":"next_result","kind":13,"line":413},{"line":413,"name":"$hs","containerName":"next_result","kind":13},{"name":"$aln_len","localvar":"my","kind":13,"containerName":"next_result","line":415,"definition":"my"},{"line":415,"name":"$inserts","containerName":"next_result","kind":13},{"line":415,"containerName":"next_result","kind":13,"name":"$deletes"},{"containerName":"next_result","kind":13,"name":"@rest","line":416},{"definition":"my","line":417,"name":"$state","localvar":"my","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"$len","line":417},{"line":417,"name":"@rest","kind":13,"containerName":"next_result"},{"kind":13,"containerName":"next_result","name":"@rest","line":417},{"line":418,"containerName":"next_result","kind":13,"name":"$state"},{"line":419,"containerName":"next_result","kind":13,"name":"$inserts"},{"line":419,"kind":13,"containerName":"next_result","name":"$len"},{"line":420,"containerName":"next_result","kind":13,"name":"$state"},{"containerName":"next_result","kind":13,"name":"$len","line":421},{"line":421,"kind":13,"containerName":"next_result","name":"$MIN_INTRON"},{"line":422,"name":"$self","containerName":"next_result","kind":13},{"name":"start_element","kind":12,"containerName":"next_result","line":422},{"name":"$self","containerName":"next_result","kind":13,"line":424},{"line":424,"kind":12,"containerName":"next_result","name":"element"},{"line":425,"name":"$score","kind":13,"containerName":"next_result"},{"line":426,"containerName":"next_result","kind":13,"name":"$self"},{"line":426,"name":"element","containerName":"next_result","kind":12},{"containerName":"next_result","kind":13,"name":"$aln_len","line":427},{"line":428,"kind":13,"containerName":"next_result","name":"$self"},{"containerName":"next_result","kind":12,"name":"element","line":428},{"containerName":"next_result","kind":13,"name":"$aln_len","line":429},{"line":430,"name":"$inserts","kind":13,"containerName":"next_result"},{"kind":13,"containerName":"next_result","name":"$deletes","line":430},{"name":"$self","kind":13,"containerName":"next_result","line":433},{"line":433,"name":"element","containerName":"next_result","kind":12},{"kind":13,"containerName":"next_result","name":"$qs","line":434},{"kind":13,"containerName":"next_result","name":"$qs","line":439},{"line":439,"containerName":"next_result","kind":13,"name":"$aln_len"},{"line":439,"containerName":"next_result","kind":13,"name":"$qstrand"},{"containerName":"next_result","kind":13,"name":"$self","line":440},{"line":440,"name":"element","kind":12,"containerName":"next_result"},{"name":"$qs","containerName":"next_result","kind":13,"line":441},{"kind":13,"containerName":"next_result","name":"$qstrand","line":441},{"name":"$hs","containerName":"next_result","kind":13,"line":443},{"line":443,"containerName":"next_result","kind":13,"name":"$deletes"},{"name":"$hstrand","containerName":"next_result","kind":13,"line":443},{"line":444,"name":"$self","kind":13,"containerName":"next_result"},{"line":444,"kind":12,"containerName":"next_result","name":"element"},{"name":"$hs","containerName":"next_result","kind":13,"line":445},{"line":446,"containerName":"next_result","kind":13,"name":"$hs"},{"line":446,"name":"$aln_len","kind":13,"containerName":"next_result"},{"line":446,"name":"$hstrand","containerName":"next_result","kind":13},{"name":"$self","containerName":"next_result","kind":13,"line":447},{"line":447,"name":"element","kind":12,"containerName":"next_result"},{"line":448,"name":"$hs","containerName":"next_result","kind":13},{"line":448,"name":"$hstrand","kind":13,"containerName":"next_result"},{"line":450,"containerName":"next_result","kind":13,"name":"$self"},{"line":450,"name":"element","kind":12,"containerName":"next_result"},{"name":"$aln_len","kind":13,"containerName":"next_result","line":451},{"line":452,"name":"$inserts","kind":13,"containerName":"next_result"},{"line":452,"name":"$deletes","containerName":"next_result","kind":13},{"line":453,"name":"$self","containerName":"next_result","kind":13},{"name":"element","kind":12,"containerName":"next_result","line":453},{"name":"$aln_len","kind":13,"containerName":"next_result","line":454},{"line":456,"kind":13,"containerName":"next_result","name":"$self"},{"line":456,"name":"element","containerName":"next_result","kind":12},{"line":457,"containerName":"next_result","kind":13,"name":"$inserts"},{"containerName":"next_result","kind":13,"name":"$deletes","line":457},{"name":"$self","kind":13,"containerName":"next_result","line":458},{"line":458,"name":"element","containerName":"next_result","kind":12},{"containerName":"next_result","kind":13,"name":"$inserts","line":459},{"line":460,"name":"$self","containerName":"next_result","kind":13},{"line":460,"name":"element","containerName":"next_result","kind":12},{"line":461,"kind":13,"containerName":"next_result","name":"$deletes"},{"line":465,"name":"$self","containerName":"next_result","kind":13},{"line":465,"containerName":"next_result","kind":12,"name":"element"},{"line":466,"kind":13,"containerName":"next_result","name":"@q_ex"},{"line":468,"name":"$self","kind":13,"containerName":"next_result"},{"line":468,"containerName":"next_result","kind":12,"name":"element"},{"containerName":"next_result","kind":13,"name":"@h_ex","line":469},{"line":471,"kind":13,"containerName":"next_result","name":"$self"},{"line":471,"containerName":"next_result","kind":12,"name":"element"},{"line":472,"containerName":"next_result","kind":13,"name":"@m_ex"},{"line":475,"name":"$self","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":12,"name":"end_element","line":475},{"name":"$aln_len","kind":13,"containerName":"next_result","line":477},{"name":"$inserts","containerName":"next_result","kind":13,"line":477},{"line":477,"name":"$deletes","kind":13,"containerName":"next_result"},{"line":479,"name":"$deletes","kind":13,"containerName":"next_result"},{"line":479,"containerName":"next_result","kind":13,"name":"$len"},{"name":"$aln_len","containerName":"next_result","kind":13,"line":481},{"line":481,"containerName":"next_result","kind":13,"name":"$len"},{"kind":13,"containerName":"next_result","name":"$self","line":484},{"line":484,"name":"start_element","containerName":"next_result","kind":12},{"name":"$self","containerName":"next_result","kind":13,"line":488},{"kind":12,"containerName":"next_result","name":"element","line":488},{"kind":13,"containerName":"next_result","name":"@q_ex","line":489},{"line":491,"name":"$self","kind":13,"containerName":"next_result"},{"line":491,"containerName":"next_result","kind":12,"name":"element"},{"name":"@h_ex","kind":13,"containerName":"next_result","line":492},{"line":494,"kind":13,"containerName":"next_result","name":"$self"},{"name":"element","containerName":"next_result","kind":12,"line":494},{"line":495,"containerName":"next_result","kind":13,"name":"@m_ex"},{"line":499,"name":"$self","containerName":"next_result","kind":13},{"name":"element","kind":12,"containerName":"next_result","line":499},{"name":"$score","containerName":"next_result","kind":13,"line":500},{"name":"$self","kind":13,"containerName":"next_result","line":502},{"line":502,"containerName":"next_result","kind":12,"name":"element"},{"name":"$qs","containerName":"next_result","kind":13,"line":503},{"line":505,"name":"$qs","containerName":"next_result","kind":13},{"kind":13,"containerName":"next_result","name":"$aln_len","line":505},{"name":"$qstrand","kind":13,"containerName":"next_result","line":505},{"line":506,"name":"$self","containerName":"next_result","kind":13},{"line":506,"name":"element","containerName":"next_result","kind":12},{"kind":13,"containerName":"next_result","name":"$qs","line":507},{"containerName":"next_result","kind":13,"name":"$qstrand","line":507},{"name":"$hs","containerName":"next_result","kind":13,"line":509},{"line":509,"kind":13,"containerName":"next_result","name":"$deletes"},{"containerName":"next_result","kind":13,"name":"$hstrand","line":509},{"line":510,"name":"$self","kind":13,"containerName":"next_result"},{"line":510,"containerName":"next_result","kind":12,"name":"element"},{"line":511,"name":"$hs","kind":13,"containerName":"next_result"},{"line":512,"name":"$hs","kind":13,"containerName":"next_result"},{"kind":13,"containerName":"next_result","name":"$aln_len","line":512},{"name":"$hstrand","containerName":"next_result","kind":13,"line":512},{"line":513,"name":"$self","containerName":"next_result","kind":13},{"line":513,"name":"element","kind":12,"containerName":"next_result"},{"name":"$hs","kind":13,"containerName":"next_result","line":514},{"name":"$hstrand","kind":13,"containerName":"next_result","line":514},{"line":516,"name":"$self","containerName":"next_result","kind":13},{"containerName":"next_result","kind":12,"name":"element","line":516},{"line":517,"name":"$aln_len","containerName":"next_result","kind":13},{"line":519,"kind":13,"containerName":"next_result","name":"$self"},{"name":"element","containerName":"next_result","kind":12,"line":519},{"containerName":"next_result","kind":13,"name":"$aln_len","line":520},{"containerName":"next_result","kind":13,"name":"$inserts","line":520},{"name":"$deletes","containerName":"next_result","kind":13,"line":520},{"line":522,"name":"$self","kind":13,"containerName":"next_result"},{"name":"element","containerName":"next_result","kind":12,"line":522},{"line":523,"name":"$inserts","containerName":"next_result","kind":13},{"kind":13,"containerName":"next_result","name":"$deletes","line":523},{"kind":13,"containerName":"next_result","name":"$self","line":525},{"name":"element","containerName":"next_result","kind":12,"line":525},{"line":526,"name":"$inserts","containerName":"next_result","kind":13},{"name":"$self","kind":13,"containerName":"next_result","line":527},{"line":527,"name":"element","containerName":"next_result","kind":12},{"line":528,"name":"$deletes","containerName":"next_result","kind":13},{"kind":13,"containerName":"next_result","name":"$self","line":529},{"name":"end_element","containerName":"next_result","kind":12,"line":529},{"kind":13,"containerName":"next_result","name":"$self","line":531},{"line":531,"containerName":"next_result","kind":12,"name":"element"},{"name":"$score","kind":13,"containerName":"next_result","line":532},{"line":534,"name":"$self","kind":13,"containerName":"next_result"},{"line":534,"name":"end_element","containerName":"next_result","kind":12},{"name":"$self","containerName":"next_result","kind":13,"line":535},{"line":535,"containerName":"next_result","kind":12,"name":"end_element"},{"line":537,"kind":13,"containerName":"next_result","name":"$self"},{"line":537,"name":"end_document","containerName":"next_result","kind":12},{"line":542,"name":"$self","containerName":"next_result","kind":13},{"line":542,"kind":12,"containerName":"next_result","name":"end_document"},{"line":542,"name":"$seentop","kind":13,"containerName":"next_result"}],"containerName":"main::","name":"next_result"},{"detail":"($self,$data)","definition":"sub","containerName":"main::","name":"start_element","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"start_element","name":"$self","line":557},{"name":"$data","containerName":"start_element","kind":13,"line":557},{"line":559,"localvar":"my","kind":13,"containerName":"start_element","name":"$nm","definition":"my"},{"line":559,"containerName":"start_element","kind":13,"name":"$data"},{"line":560,"name":"$type","containerName":"start_element","localvar":"my","kind":13,"definition":"my"},{"line":560,"name":"$MODEMAP","kind":13,"containerName":"start_element"},{"line":560,"containerName":"start_element","kind":13,"name":"$nm"},{"name":"$type","containerName":"start_element","kind":13,"line":562},{"line":563,"kind":13,"containerName":"start_element","name":"$self"},{"line":563,"containerName":"start_element","kind":12,"name":"_eventHandler"},{"name":"will_handle","containerName":"start_element","kind":12,"line":563},{"line":563,"kind":13,"containerName":"start_element","name":"$type"},{"containerName":"start_element","localvar":"my","kind":13,"name":"$func","line":564,"definition":"my"},{"name":"$type","containerName":"start_element","kind":13,"line":564},{"kind":13,"containerName":"start_element","name":"$self","line":565},{"name":"_eventHandler","kind":12,"containerName":"start_element","line":565},{"line":565,"name":"$func","kind":13,"containerName":"start_element"},{"line":565,"name":"$data","containerName":"start_element","kind":13},{"line":567,"name":"$self","containerName":"start_element","kind":13},{"line":567,"name":"$type","kind":13,"containerName":"start_element"},{"kind":13,"containerName":"start_element","name":"$type","line":568},{"name":"$self","kind":13,"containerName":"start_element","line":569},{"line":570,"containerName":"start_element","kind":13,"name":"$self"}],"signature":{"parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: exonerate.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::exonerate\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::exonerate - parser for Exonerate\n\n=head1 SYNOPSIS\n\n  # do not use this module directly, it is a driver for SearchIO\n\n  use Bio::SearchIO;\n  my $searchio = Bio::SearchIO->new(-file => 'file.exonerate',\n                                   -format => 'exonerate');\n\n\n  while( my $r = $searchio->next_result ) {\n    print $r->query_name, \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis is a driver for the SearchIO system for parsing Exonerate (Guy\nSlater) output.  You can get Exonerate at\nhttp://www.ebi.ac.uk/~guy/exonerate/\n[until Guy puts up a Web reference,publication for it.]).\n\nAn optional parameter -min_intron is supported by the L<new>\ninitialization method.  This is if you run Exonerate with a different\nminimum intron length (default is 30) the parser will be able to\ndetect the difference between standard deletions and an intron.  Still\nsome room to play with there that might cause this to get\nmisinterpreted that has not been fully tested or explored.\n\nThe VULGAR and CIGAR formats should be parsed okay now creating HSPs\nwhere appropriate (so merging match states where appropriate rather\nthan breaking an HSP at each indel as it may have done in the past).\nThe GFF that comes from exonerate is still probably a better way to go\nif you are doing protein2genome or est2genome mapping.\nFor example you can see this script:\n\n### TODO: Jason, this link is dead, do we have an updated one?\nhttp://fungal.genome.duke.edu/~jes12/software/scripts/process_exonerate_gff3.perl.txt\n\nIf your report contains both CIGAR and VULGAR lines only the first one\nwill processed for a given Query/Target pair.  If you preferentially\nwant to use VULGAR or CIGAR add one of these options when initializing\nthe SearchIO object.\n\n    -cigar  => 1\nOR\n    -vulgar => 1\n\nOr set them via these methods.\n\n    $parser->cigar(1)\nOR\n    $parser->vulgar(1)\n\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::exonerate;\nuse strict;\nuse vars qw(@STATES %MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $MIN_INTRON);\n\nuse base qw(Bio::SearchIO);\n\n%MODEMAP = ( 'ExonerateOutput' => 'result',\n    'Hit'             => 'hit',\n    'Hsp'             => 'hsp'\n    );\n\n%MAPPING =\n    (\n    'Hsp_query-from'=>  'HSP-query_start',\n    'Hsp_query-to'  =>  'HSP-query_end',\n    'Hsp_hit-from'  =>  'HSP-hit_start',\n    'Hsp_hit-to'    =>  'HSP-hit_end',\n    'Hsp_qseq'      =>  'HSP-query_seq',\n    'Hsp_hseq'      =>  'HSP-hit_seq',\n    'Hsp_midline'   =>  'HSP-homology_seq',\n    'Hsp_score'     =>  'HSP-score',\n    'Hsp_qlength'   =>  'HSP-query_length',\n    'Hsp_hlength'   =>  'HSP-hit_length',\n    'Hsp_align-len' =>  'HSP-hsp_length',\n    'Hsp_identity'  =>  'HSP-identical',\n    'Hsp_gaps'       => 'HSP-hsp_gaps',\n    'Hsp_hitgaps'    => 'HSP-hit_gaps',\n    'Hsp_querygaps'  => 'HSP-query_gaps',\n\n    'Hit_id'        => 'HIT-name',\n    'Hit_desc'      => 'HIT-description',\n    'Hit_len'       => 'HIT-length',\n    'Hit_score'     => 'HIT-score',\n\n    'ExonerateOutput_program'   => 'RESULT-algorithm_name',\n    'ExonerateOutput_query-def' => 'RESULT-query_name',\n    'ExonerateOutput_query-desc'=> 'RESULT-query_description',\n    'ExonerateOutput_query-len' => 'RESULT-query_length',\n    );\n\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n$MIN_INTRON=30; # This is the minimum intron size\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::exonerate->new();\n Function: Builds a new Bio::SearchIO::exonerate object\n Returns : an instance of Bio::SearchIO::exonerate\n Args    : -min_intron => somewhat obselete option, how to determine if a\n                          an indel is an intron or a local gap.  Use VULGAR\n                          rather than CIGAR to avoid this heuristic,default 30.\n           -cigar       => 1   set this to 1 if you want to parse\n                               CIGAR exclusively.\n           -vulgar      => 1   set this to 1 if you want to parse VULGAR\n                               exclusively, setting both to 1 will revert\n                               to the default behavior of just parsing the\n                               first line that it sees.\n\n\nsub new {\n    my ($class) = shift;\n    my $self = $class->SUPER::new(@_);\n\n    my ($min_intron,$cigar,\n\t$vulgar) = $self->_rearrange([qw(MIN_INTRON\n\t\t\t\t\t CIGAR\n\t\t\t\t\t VULGAR)], @_);\n    if( $min_intron ) {\n\t$MIN_INTRON = $min_intron;\n    }\n    if( $cigar && $vulgar ) {\n\t$self->warn(\"cannot get HSPs from both CIGAR and VULGAR lines, will just choose whichever comes first (same as if you had chosen neither\");\n\t$cigar = 0; $vulgar=0;\n    }\n    $self->cigar($cigar);\n    $self->vulgar($vulgar);\n    $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n   my ($self) = @_;\n   local $/ = \"\\n\";\n   local $_;\n\n   $self->{'_last_data'} = '';\n   my ($reporttype,$seenquery,$reportline);\n   $self->start_document();\n   my @hit_signifs;\n   my $seentop;\n   my (@q_ex, @m_ex, @h_ex); ## gc addition\n   while( defined($_ = $self->_readline) ) {\n       # warn( \"Reading $_\");\n       if( /^Query:\\s+(\\S+)\\s*(.+)?/ ) {\n\t   if( $seentop ) {\n\t       $self->end_element({'Name' => 'ExonerateOutput'});\n\t       $self->_pushback($_);\n\t       return $self->end_document();\n\t   }\n\t   $seentop = 1;\n\t   my ($nm,$desc) = ($1,$2);\n\t   chomp($desc) if defined $desc;\n\t   $self->{'_result_count'}++;\n\t   $self->start_element({'Name' => 'ExonerateOutput'});\n\t   $self->element({'Name' => 'ExonerateOutput_query-def',\n\t\t\t   'Data' => $nm });\n\t   $self->element({'Name' => 'ExonerateOutput_query-desc',\n\t\t\t   'Data' => $desc });\n\t   $self->element({'Name' => 'ExonerateOutput_program',\n\t\t\t   'Data' => 'Exonerate' });\n\t   $self->{'_seencigar'} = 0;\n\t   $self->{'_vulgar'}    = 0;\n\n       } elsif ( /^Target:\\s+(\\S+)\\s*(.+)?/ ) {\n\t   my ($nm,$desc) = ($1,$2);\n\t   chomp($desc) if defined $desc;\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $nm});\n\t   $self->element({'Name' => 'Hit_desc',\n\t\t\t   'Data' => $desc});\n\t   $self->{'_seencigar'} = 0;\n\t   $self->{'_vulgar'}    = 0;\n       } elsif(  s/^vulgar:\\s+(\\S+)\\s+         # query sequence id\n\t\t (\\d+)\\s+(\\d+)\\s+([\\-\\+\\.])\\s+ # query start-end-strand\n\t\t (\\S+)\\s+                      # target sequence id\n\t\t (\\d+)\\s+(\\d+)\\s+([\\-\\+])\\s+   # target start-end-strand\n\t\t (\\d+)\\s+                      # score\n\t\t //ox ) {\n\t   next if( $self->cigar || $self->{'_seencigar'});\n\t   $self->{'_vulgar'}++;\n\t   #\n\t   # Note from Ewan. This is ugly - copy and paste from\n\t   # cigar line parsing. Should unify somehow...\n\t   #\n\t   if( ! $self->within_element('result') ) {\n\t       $self->start_element({'Name' => 'ExonerateOutput'});\n\t       $self->element({'Name' => 'ExonerateOutput_query-def',\n\t\t\t       'Data' => $1 });\n\t   }\n\t   if( ! $self->within_element('hit') ) {\n\t       $self->start_element({'Name' => 'Hit'});\n\t       $self->element({'Name' => 'Hit_id',\n\t\t\t       'Data' => $5});\n\t   }\n\n\t   ## gc note:\n\t   ## $qe and $he are no longer used for calculating the ends,\n\t   ## just the $qs and $hs values and the alignment and insert lenghts\n\t   my ($qs,$qe,$qstrand) = ($2,$3,$4);\n\t   my ($hs,$he,$hstrand) = ($6,$7,$8);\n\t   my $score = $9;\n#\t   $self->element({'Name' => 'ExonerateOutput_query-len',\n#\t\t\t   'Data' => $qe});\n#\t   $self->element({'Name' => 'Hit_len',\n#\t\t\t   'Data' => $he});\n\n\t   ## gc note:\n\t   ## add one because these values are zero-based\n\t   ## this calculation was originally done lower in the code,\n\t   ## but it's clearer to do it just once at the start\n\t   my @rest = split;\n\t   my ($qbegin,$qend) = ('query-from', 'query-to');\n\n\t   if( $qstrand eq '-' ) {\n\t       $qstrand = -1; $qe++;\n\t   } else {\n\t       $qstrand = 1;\n\t       $qs++;\n\t   }\n\t   my ($hbegin,$hend) = ('hit-from', 'hit-to');\n\n\t   if( $hstrand eq '-' ) {\n\t       $hstrand = -1;\n\t       $he++;\n\t   } else {\n\t       $hstrand = 1;\n\t       $hs++;\n\t   }\n\t   # okay let's do this right and generate a set of HSPs\n\t   # from the cigar line/home/bio1/jes12/bin/exonerate  --model est2genome --bestn 1 t/data/exonerate_cdna.fa t/data/exonerate_genomic_rev.fa\n\n\t   my ($aln_len,$inserts,$deletes) = (0,0,0);\n\t   my ($laststate,@events,$gaps) =( '' );\n\t   while( @rest >= 3 ) {\n\t       my ($state,$len1,$len2) = (shift @rest, shift @rest, shift @rest);\n\t       #\n\t       # HSPs are only the Match cases; otherwise we just\n\t       # move the coordinates on by the correct amount\n\t       #\n\n\t       if( $state eq 'M' ) {\n\t\t   if( $laststate eq 'G' ) {\n\t\t       # merge gaps across Match states so the HSP\n\t\t       # goes across\n\t\t       $events[-1]->{$qend} = $qs + $len1*$qstrand - $qstrand;\n\t\t       $events[-1]->{$hend}   = $hs + $len2*$hstrand - $hstrand;\n\t\t       $events[-1]->{'gaps'} = $gaps;\n\t\t   } else {\n\t\t       push @events,\n\t\t       { 'score'     => $score,\n\t\t\t 'align-len' => $len1,\n\t\t\t $qbegin => $qs,\n\t\t\t $qend  => ($qs + $len1*$qstrand - $qstrand),\n\t\t\t $hbegin => $hs,\n\t\t\t $hend   => ($hs + $len2*$hstrand - $hstrand),\n\t\t     };\n\t\t   }\n\t\t   $gaps = 0;\n\t       } else {\n\t\t   $gaps = $len1 + $len2 if $state eq 'G';\n\t       }\n\t       $qs += $len1*$qstrand;\n\t       $hs += $len2*$hstrand;\n\t       $laststate= $state;\n\t   }\n\t   for my $event ( @events ) {\n\t       $self->start_element({'Name' => 'Hsp'});\n\t       while( my ($key,$val) = each %$event ) {\n\t\t   $self->element({'Name' => \"Hsp_$key\",\n\t\t\t\t   'Data' => $val});\n\t       }\n\t       $self->element({'Name' => 'Hsp_identity',\n\t\t\t       'Data' => 0});\n\t       $self->end_element({'Name' => 'Hsp'});\n\t   }\n\n\t   # end of hit\n\t   $self->element({'Name' => 'Hit_score',\n\t\t\t   'Data' => $score});\n\t   # issued end...\n\t   $self->end_element({'Name' => 'Hit'});\n\t   $self->end_element({'Name' => 'ExonerateOutput'});\n\n\t   return $self->end_document();\n\n       } elsif(  s/^cigar:\\s+(\\S+)\\s+          # query sequence id\n\t\t (\\d+)\\s+(\\d+)\\s+([\\-\\+])\\s+   # query start-end-strand\n\t\t (\\S+)\\s+                      # target sequence id\n\t\t (\\d+)\\s+(\\d+)\\s+([\\-\\+])\\s+   # target start-end-strand\n\t\t (\\d+)\\s+                      # score\n\t\t //ox ) {\n\t   next if( $self->vulgar || $self->{'_seenvulgar'});\n\t   $self->{'_cigar'}++;\n\n\t   if( ! $self->within_element('result') ) {\n\t       $self->start_element({'Name' => 'ExonerateOutput'});\n\t       $self->element({'Name' => 'ExonerateOutput_query-def',\n\t\t\t       'Data' => $1 });\n\t   }\n\t   if( ! $self->within_element('hit') ) {\n\t       $self->start_element({'Name' => 'Hit'});\n\t       $self->element({'Name' => 'Hit_id',\n\t\t\t       'Data' => $5});\n\t   }\n\t   ## gc note:\n\t   ## $qe and $he are no longer used for calculating the ends,\n\t   ## just the $qs and $hs values and the alignment and insert lenghts\n\t   my ($qs,$qe,$qstrand) = ($2,$3,$4);\n\t   my ($hs,$he,$hstrand) = ($6,$7,$8);\n\t   my $score = $9;\n#\t   $self->element({'Name' => 'ExonerateOutput_query-len',\n#\t\t\t   'Data' => $qe});\n#\t   $self->element({'Name' => 'Hit_len',\n#\t\t\t   'Data' => $he});\n\n\t   my @rest = split;\n\t   if( $qstrand eq '-' ) {\n\t       $qstrand = -1;\n\t       ($qs,$qe) = ($qe,$qs); # flip-flop if we're on opp strand\n\t       $qs--; $qe++;\n\t   } else { $qstrand = 1; }\n\t   if( $hstrand eq '-' ) {\n\t       $hstrand = -1;\n\t       ($hs,$he) = ($he,$hs); # flip-flop if we're on opp strand\n\t       $hs--; $he++;\n\t   } else { $hstrand = 1; }\n\t   # okay let's do this right and generate a set of HSPs\n\t   # from the cigar line\n\n\t   ## gc note:\n\t   ## add one because these values are zero-based\n\t   ## this calculation was originally done lower in the code,\n\t   ## but it's clearer to do it just once at the start\n\t   $qs++; $hs++;\n\n\t   my ($aln_len,$inserts,$deletes) = (0,0,0);\n\t   while( @rest >= 2 ) {\n\t       my ($state,$len) = (shift @rest, shift @rest);\n\t       if( $state eq 'I' ) {\n\t\t   $inserts+=$len;\n\t       } elsif( $state eq 'D' ) {\n\t\t   if( $len >= $MIN_INTRON ) {\n\t\t       $self->start_element({'Name' => 'Hsp'});\n\n\t\t       $self->element({'Name' => 'Hsp_score',\n\t\t\t\t       'Data' => $score});\n\t\t       $self->element({'Name' => 'Hsp_align-len',\n\t\t\t\t       'Data' => $aln_len});\n\t\t       $self->element({'Name' => 'Hsp_identity',\n\t\t\t\t       'Data' => $aln_len -\n\t\t\t\t\t   ($inserts + $deletes)});\n\n\t\t       # HSP ends where the other begins\n\t\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t\t       'Data' => $qs});\n\t\t       ## gc note:\n\t\t       ## $qs is now the start of the next hsp\n\t\t       ## the end of this hsp is 1 before this position\n\t\t       ## (or 1 after in case of reverse strand)\n\t\t       $qs += $aln_len*$qstrand;\n\t\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t\t       'Data' => $qs - ($qstrand*1)});\n\n\t\t       $hs += $deletes*$hstrand;\n\t\t       $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t\t       'Data' => $hs});\n\t\t       $hs += $aln_len*$hstrand;\n\t\t       $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t\t       'Data' => $hs-($hstrand*1)});\n\n\t\t       $self->element({'Name' => 'Hsp_align-len',\n\t\t\t\t       'Data' => $aln_len + $inserts\n\t\t\t\t\t   + $deletes});\n\t\t       $self->element({'Name' => 'Hsp_identity',\n\t\t\t\t       'Data' => $aln_len });\n\n\t\t       $self->element({'Name' => 'Hsp_gaps',\n\t\t\t\t       'Data' => $inserts + $deletes});\n\t\t       $self->element({'Name' => 'Hsp_querygaps',\n\t\t\t\t       'Data' => $inserts});\n\t\t       $self->element({'Name' => 'Hsp_hitgaps',\n\t\t\t\t       'Data' => $deletes});\n\n## gc addition start\n\n\t\t       $self->element({'Name' => 'Hsp_qseq',\n\t\t\t\t       'Data' => shift @q_ex,\n\t\t\t\t   });\n\t\t       $self->element({'Name' => 'Hsp_hseq',\n\t\t\t\t       'Data' => shift @h_ex,\n\t\t\t\t   });\n\t\t       $self->element({'Name' => 'Hsp_midline',\n\t\t\t\t       'Data' => shift @m_ex,\n\t\t\t\t   });\n## gc addition end\n\t\t       $self->end_element({'Name' => 'Hsp'});\n\n\t\t       $aln_len = $inserts = $deletes = 0;\n\t\t   }\n\t\t   $deletes+=$len;\n\t       } else {\n\t\t   $aln_len += $len;\n\t       }\n\t   }\n\t   $self->start_element({'Name' => 'Hsp'});\n\n## gc addition start\n\n\t   $self->element({'Name' => 'Hsp_qseq',\n\t\t\t   'Data' => shift @q_ex,\n\t\t       });\n\t   $self->element({'Name' => 'Hsp_hseq',\n\t\t\t   'Data' => shift @h_ex,\n\t\t       });\n\t   $self->element({'Name' => 'Hsp_midline',\n\t\t\t   'Data' => shift @m_ex,\n\t\t       });\n## gc addition end\n\n\t   $self->element({'Name' => 'Hsp_score',\n\t\t\t   'Data' => $score});\n\n\t   $self->element({'Name' => 'Hsp_query-from',\n\t\t\t   'Data' => $qs});\n\n\t   $qs += $aln_len*$qstrand;\n\t   $self->element({'Name' => 'Hsp_query-to',\n\t\t\t   'Data' => $qs - ($qstrand*1)});\n\n\t   $hs += $deletes*$hstrand;\n\t   $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t   'Data' => $hs});\n\t   $hs += $aln_len*$hstrand;\n\t   $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t   'Data' => $hs -($hstrand*1)});\n\n\t   $self->element({'Name' => 'Hsp_align-len',\n\t\t\t   'Data' => $aln_len});\n\n\t   $self->element({'Name' => 'Hsp_identity',\n\t\t\t   'Data' => $aln_len - ($inserts + $deletes)});\n\n\t   $self->element({'Name' => 'Hsp_gaps',\n\t\t\t   'Data' => $inserts + $deletes});\n\n\t   $self->element({'Name' => 'Hsp_querygaps',\n\t\t\t   'Data' => $inserts});\n\t   $self->element({'Name' => 'Hsp_hitgaps',\n\t\t\t   'Data' => $deletes});\n\t   $self->end_element({'Name' => 'Hsp'});\n\n\t   $self->element({'Name' => 'Hit_score',\n\t\t\t   'Data' => $score});\n\n\t   $self->end_element({'Name' => 'Hit'});\n\t   $self->end_element({'Name' => 'ExonerateOutput'});\n\n\t   return $self->end_document();\n       } else {\n\t   # skipping this line\n       }\n   }\n   return $self->end_document() if( $seentop );\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'","label":"start_element($self,$data)"},"range":{"end":{"character":9999,"line":572},"start":{"character":0,"line":556}},"kind":12,"line":556},{"detail":"($self,$data)","definition":"sub","containerName":"main::","name":"end_element","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"end_element","line":588,"definition":"my"},{"line":588,"containerName":"end_element","kind":13,"name":"$data"},{"line":589,"localvar":"my","containerName":"end_element","kind":13,"name":"$nm","definition":"my"},{"line":589,"kind":13,"containerName":"end_element","name":"$data"},{"line":590,"name":"$type","localvar":"my","containerName":"end_element","kind":13,"definition":"my"},{"line":590,"name":"$MODEMAP","kind":13,"containerName":"end_element"},{"name":"$nm","containerName":"end_element","kind":13,"line":590},{"name":"$rc","containerName":"end_element","localvar":"my","kind":13,"line":591,"definition":"my"},{"line":593,"containerName":"end_element","kind":13,"name":"$type"},{"line":593,"name":"$MODEMAP","kind":13,"containerName":"end_element"},{"line":593,"name":"$nm","containerName":"end_element","kind":13},{"kind":13,"containerName":"end_element","name":"$self","line":594},{"line":594,"name":"_eventHandler","kind":12,"containerName":"end_element"},{"kind":12,"containerName":"end_element","name":"will_handle","line":594},{"name":"$type","containerName":"end_element","kind":13,"line":594},{"name":"$func","containerName":"end_element","localvar":"my","kind":13,"line":595,"definition":"my"},{"line":595,"containerName":"end_element","kind":13,"name":"$type"},{"name":"$rc","containerName":"end_element","kind":13,"line":596},{"line":596,"kind":13,"containerName":"end_element","name":"$self"},{"line":596,"kind":12,"containerName":"end_element","name":"_eventHandler"},{"line":596,"kind":13,"containerName":"end_element","name":"$func"},{"kind":13,"containerName":"end_element","name":"$self","line":596},{"line":597,"containerName":"end_element","kind":13,"name":"$self"},{"line":599,"kind":13,"containerName":"end_element","name":"$self"}],"signature":{"label":"end_element($self,$data)","parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: exonerate.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::exonerate\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::exonerate - parser for Exonerate\n\n=head1 SYNOPSIS\n\n  # do not use this module directly, it is a driver for SearchIO\n\n  use Bio::SearchIO;\n  my $searchio = Bio::SearchIO->new(-file => 'file.exonerate',\n                                   -format => 'exonerate');\n\n\n  while( my $r = $searchio->next_result ) {\n    print $r->query_name, \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis is a driver for the SearchIO system for parsing Exonerate (Guy\nSlater) output.  You can get Exonerate at\nhttp://www.ebi.ac.uk/~guy/exonerate/\n[until Guy puts up a Web reference,publication for it.]).\n\nAn optional parameter -min_intron is supported by the L<new>\ninitialization method.  This is if you run Exonerate with a different\nminimum intron length (default is 30) the parser will be able to\ndetect the difference between standard deletions and an intron.  Still\nsome room to play with there that might cause this to get\nmisinterpreted that has not been fully tested or explored.\n\nThe VULGAR and CIGAR formats should be parsed okay now creating HSPs\nwhere appropriate (so merging match states where appropriate rather\nthan breaking an HSP at each indel as it may have done in the past).\nThe GFF that comes from exonerate is still probably a better way to go\nif you are doing protein2genome or est2genome mapping.\nFor example you can see this script:\n\n### TODO: Jason, this link is dead, do we have an updated one?\nhttp://fungal.genome.duke.edu/~jes12/software/scripts/process_exonerate_gff3.perl.txt\n\nIf your report contains both CIGAR and VULGAR lines only the first one\nwill processed for a given Query/Target pair.  If you preferentially\nwant to use VULGAR or CIGAR add one of these options when initializing\nthe SearchIO object.\n\n    -cigar  => 1\nOR\n    -vulgar => 1\n\nOr set them via these methods.\n\n    $parser->cigar(1)\nOR\n    $parser->vulgar(1)\n\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::exonerate;\nuse strict;\nuse vars qw(@STATES %MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $MIN_INTRON);\n\nuse base qw(Bio::SearchIO);\n\n%MODEMAP = ( 'ExonerateOutput' => 'result',\n    'Hit'             => 'hit',\n    'Hsp'             => 'hsp'\n    );\n\n%MAPPING =\n    (\n    'Hsp_query-from'=>  'HSP-query_start',\n    'Hsp_query-to'  =>  'HSP-query_end',\n    'Hsp_hit-from'  =>  'HSP-hit_start',\n    'Hsp_hit-to'    =>  'HSP-hit_end',\n    'Hsp_qseq'      =>  'HSP-query_seq',\n    'Hsp_hseq'      =>  'HSP-hit_seq',\n    'Hsp_midline'   =>  'HSP-homology_seq',\n    'Hsp_score'     =>  'HSP-score',\n    'Hsp_qlength'   =>  'HSP-query_length',\n    'Hsp_hlength'   =>  'HSP-hit_length',\n    'Hsp_align-len' =>  'HSP-hsp_length',\n    'Hsp_identity'  =>  'HSP-identical',\n    'Hsp_gaps'       => 'HSP-hsp_gaps',\n    'Hsp_hitgaps'    => 'HSP-hit_gaps',\n    'Hsp_querygaps'  => 'HSP-query_gaps',\n\n    'Hit_id'        => 'HIT-name',\n    'Hit_desc'      => 'HIT-description',\n    'Hit_len'       => 'HIT-length',\n    'Hit_score'     => 'HIT-score',\n\n    'ExonerateOutput_program'   => 'RESULT-algorithm_name',\n    'ExonerateOutput_query-def' => 'RESULT-query_name',\n    'ExonerateOutput_query-desc'=> 'RESULT-query_description',\n    'ExonerateOutput_query-len' => 'RESULT-query_length',\n    );\n\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n$MIN_INTRON=30; # This is the minimum intron size\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::exonerate->new();\n Function: Builds a new Bio::SearchIO::exonerate object\n Returns : an instance of Bio::SearchIO::exonerate\n Args    : -min_intron => somewhat obselete option, how to determine if a\n                          an indel is an intron or a local gap.  Use VULGAR\n                          rather than CIGAR to avoid this heuristic,default 30.\n           -cigar       => 1   set this to 1 if you want to parse\n                               CIGAR exclusively.\n           -vulgar      => 1   set this to 1 if you want to parse VULGAR\n                               exclusively, setting both to 1 will revert\n                               to the default behavior of just parsing the\n                               first line that it sees.\n\n\nsub new {\n    my ($class) = shift;\n    my $self = $class->SUPER::new(@_);\n\n    my ($min_intron,$cigar,\n\t$vulgar) = $self->_rearrange([qw(MIN_INTRON\n\t\t\t\t\t CIGAR\n\t\t\t\t\t VULGAR)], @_);\n    if( $min_intron ) {\n\t$MIN_INTRON = $min_intron;\n    }\n    if( $cigar && $vulgar ) {\n\t$self->warn(\"cannot get HSPs from both CIGAR and VULGAR lines, will just choose whichever comes first (same as if you had chosen neither\");\n\t$cigar = 0; $vulgar=0;\n    }\n    $self->cigar($cigar);\n    $self->vulgar($vulgar);\n    $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n   my ($self) = @_;\n   local $/ = \"\\n\";\n   local $_;\n\n   $self->{'_last_data'} = '';\n   my ($reporttype,$seenquery,$reportline);\n   $self->start_document();\n   my @hit_signifs;\n   my $seentop;\n   my (@q_ex, @m_ex, @h_ex); ## gc addition\n   while( defined($_ = $self->_readline) ) {\n       # warn( \"Reading $_\");\n       if( /^Query:\\s+(\\S+)\\s*(.+)?/ ) {\n\t   if( $seentop ) {\n\t       $self->end_element({'Name' => 'ExonerateOutput'});\n\t       $self->_pushback($_);\n\t       return $self->end_document();\n\t   }\n\t   $seentop = 1;\n\t   my ($nm,$desc) = ($1,$2);\n\t   chomp($desc) if defined $desc;\n\t   $self->{'_result_count'}++;\n\t   $self->start_element({'Name' => 'ExonerateOutput'});\n\t   $self->element({'Name' => 'ExonerateOutput_query-def',\n\t\t\t   'Data' => $nm });\n\t   $self->element({'Name' => 'ExonerateOutput_query-desc',\n\t\t\t   'Data' => $desc });\n\t   $self->element({'Name' => 'ExonerateOutput_program',\n\t\t\t   'Data' => 'Exonerate' });\n\t   $self->{'_seencigar'} = 0;\n\t   $self->{'_vulgar'}    = 0;\n\n       } elsif ( /^Target:\\s+(\\S+)\\s*(.+)?/ ) {\n\t   my ($nm,$desc) = ($1,$2);\n\t   chomp($desc) if defined $desc;\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $nm});\n\t   $self->element({'Name' => 'Hit_desc',\n\t\t\t   'Data' => $desc});\n\t   $self->{'_seencigar'} = 0;\n\t   $self->{'_vulgar'}    = 0;\n       } elsif(  s/^vulgar:\\s+(\\S+)\\s+         # query sequence id\n\t\t (\\d+)\\s+(\\d+)\\s+([\\-\\+\\.])\\s+ # query start-end-strand\n\t\t (\\S+)\\s+                      # target sequence id\n\t\t (\\d+)\\s+(\\d+)\\s+([\\-\\+])\\s+   # target start-end-strand\n\t\t (\\d+)\\s+                      # score\n\t\t //ox ) {\n\t   next if( $self->cigar || $self->{'_seencigar'});\n\t   $self->{'_vulgar'}++;\n\t   #\n\t   # Note from Ewan. This is ugly - copy and paste from\n\t   # cigar line parsing. Should unify somehow...\n\t   #\n\t   if( ! $self->within_element('result') ) {\n\t       $self->start_element({'Name' => 'ExonerateOutput'});\n\t       $self->element({'Name' => 'ExonerateOutput_query-def',\n\t\t\t       'Data' => $1 });\n\t   }\n\t   if( ! $self->within_element('hit') ) {\n\t       $self->start_element({'Name' => 'Hit'});\n\t       $self->element({'Name' => 'Hit_id',\n\t\t\t       'Data' => $5});\n\t   }\n\n\t   ## gc note:\n\t   ## $qe and $he are no longer used for calculating the ends,\n\t   ## just the $qs and $hs values and the alignment and insert lenghts\n\t   my ($qs,$qe,$qstrand) = ($2,$3,$4);\n\t   my ($hs,$he,$hstrand) = ($6,$7,$8);\n\t   my $score = $9;\n#\t   $self->element({'Name' => 'ExonerateOutput_query-len',\n#\t\t\t   'Data' => $qe});\n#\t   $self->element({'Name' => 'Hit_len',\n#\t\t\t   'Data' => $he});\n\n\t   ## gc note:\n\t   ## add one because these values are zero-based\n\t   ## this calculation was originally done lower in the code,\n\t   ## but it's clearer to do it just once at the start\n\t   my @rest = split;\n\t   my ($qbegin,$qend) = ('query-from', 'query-to');\n\n\t   if( $qstrand eq '-' ) {\n\t       $qstrand = -1; $qe++;\n\t   } else {\n\t       $qstrand = 1;\n\t       $qs++;\n\t   }\n\t   my ($hbegin,$hend) = ('hit-from', 'hit-to');\n\n\t   if( $hstrand eq '-' ) {\n\t       $hstrand = -1;\n\t       $he++;\n\t   } else {\n\t       $hstrand = 1;\n\t       $hs++;\n\t   }\n\t   # okay let's do this right and generate a set of HSPs\n\t   # from the cigar line/home/bio1/jes12/bin/exonerate  --model est2genome --bestn 1 t/data/exonerate_cdna.fa t/data/exonerate_genomic_rev.fa\n\n\t   my ($aln_len,$inserts,$deletes) = (0,0,0);\n\t   my ($laststate,@events,$gaps) =( '' );\n\t   while( @rest >= 3 ) {\n\t       my ($state,$len1,$len2) = (shift @rest, shift @rest, shift @rest);\n\t       #\n\t       # HSPs are only the Match cases; otherwise we just\n\t       # move the coordinates on by the correct amount\n\t       #\n\n\t       if( $state eq 'M' ) {\n\t\t   if( $laststate eq 'G' ) {\n\t\t       # merge gaps across Match states so the HSP\n\t\t       # goes across\n\t\t       $events[-1]->{$qend} = $qs + $len1*$qstrand - $qstrand;\n\t\t       $events[-1]->{$hend}   = $hs + $len2*$hstrand - $hstrand;\n\t\t       $events[-1]->{'gaps'} = $gaps;\n\t\t   } else {\n\t\t       push @events,\n\t\t       { 'score'     => $score,\n\t\t\t 'align-len' => $len1,\n\t\t\t $qbegin => $qs,\n\t\t\t $qend  => ($qs + $len1*$qstrand - $qstrand),\n\t\t\t $hbegin => $hs,\n\t\t\t $hend   => ($hs + $len2*$hstrand - $hstrand),\n\t\t     };\n\t\t   }\n\t\t   $gaps = 0;\n\t       } else {\n\t\t   $gaps = $len1 + $len2 if $state eq 'G';\n\t       }\n\t       $qs += $len1*$qstrand;\n\t       $hs += $len2*$hstrand;\n\t       $laststate= $state;\n\t   }\n\t   for my $event ( @events ) {\n\t       $self->start_element({'Name' => 'Hsp'});\n\t       while( my ($key,$val) = each %$event ) {\n\t\t   $self->element({'Name' => \"Hsp_$key\",\n\t\t\t\t   'Data' => $val});\n\t       }\n\t       $self->element({'Name' => 'Hsp_identity',\n\t\t\t       'Data' => 0});\n\t       $self->end_element({'Name' => 'Hsp'});\n\t   }\n\n\t   # end of hit\n\t   $self->element({'Name' => 'Hit_score',\n\t\t\t   'Data' => $score});\n\t   # issued end...\n\t   $self->end_element({'Name' => 'Hit'});\n\t   $self->end_element({'Name' => 'ExonerateOutput'});\n\n\t   return $self->end_document();\n\n       } elsif(  s/^cigar:\\s+(\\S+)\\s+          # query sequence id\n\t\t (\\d+)\\s+(\\d+)\\s+([\\-\\+])\\s+   # query start-end-strand\n\t\t (\\S+)\\s+                      # target sequence id\n\t\t (\\d+)\\s+(\\d+)\\s+([\\-\\+])\\s+   # target start-end-strand\n\t\t (\\d+)\\s+                      # score\n\t\t //ox ) {\n\t   next if( $self->vulgar || $self->{'_seenvulgar'});\n\t   $self->{'_cigar'}++;\n\n\t   if( ! $self->within_element('result') ) {\n\t       $self->start_element({'Name' => 'ExonerateOutput'});\n\t       $self->element({'Name' => 'ExonerateOutput_query-def',\n\t\t\t       'Data' => $1 });\n\t   }\n\t   if( ! $self->within_element('hit') ) {\n\t       $self->start_element({'Name' => 'Hit'});\n\t       $self->element({'Name' => 'Hit_id',\n\t\t\t       'Data' => $5});\n\t   }\n\t   ## gc note:\n\t   ## $qe and $he are no longer used for calculating the ends,\n\t   ## just the $qs and $hs values and the alignment and insert lenghts\n\t   my ($qs,$qe,$qstrand) = ($2,$3,$4);\n\t   my ($hs,$he,$hstrand) = ($6,$7,$8);\n\t   my $score = $9;\n#\t   $self->element({'Name' => 'ExonerateOutput_query-len',\n#\t\t\t   'Data' => $qe});\n#\t   $self->element({'Name' => 'Hit_len',\n#\t\t\t   'Data' => $he});\n\n\t   my @rest = split;\n\t   if( $qstrand eq '-' ) {\n\t       $qstrand = -1;\n\t       ($qs,$qe) = ($qe,$qs); # flip-flop if we're on opp strand\n\t       $qs--; $qe++;\n\t   } else { $qstrand = 1; }\n\t   if( $hstrand eq '-' ) {\n\t       $hstrand = -1;\n\t       ($hs,$he) = ($he,$hs); # flip-flop if we're on opp strand\n\t       $hs--; $he++;\n\t   } else { $hstrand = 1; }\n\t   # okay let's do this right and generate a set of HSPs\n\t   # from the cigar line\n\n\t   ## gc note:\n\t   ## add one because these values are zero-based\n\t   ## this calculation was originally done lower in the code,\n\t   ## but it's clearer to do it just once at the start\n\t   $qs++; $hs++;\n\n\t   my ($aln_len,$inserts,$deletes) = (0,0,0);\n\t   while( @rest >= 2 ) {\n\t       my ($state,$len) = (shift @rest, shift @rest);\n\t       if( $state eq 'I' ) {\n\t\t   $inserts+=$len;\n\t       } elsif( $state eq 'D' ) {\n\t\t   if( $len >= $MIN_INTRON ) {\n\t\t       $self->start_element({'Name' => 'Hsp'});\n\n\t\t       $self->element({'Name' => 'Hsp_score',\n\t\t\t\t       'Data' => $score});\n\t\t       $self->element({'Name' => 'Hsp_align-len',\n\t\t\t\t       'Data' => $aln_len});\n\t\t       $self->element({'Name' => 'Hsp_identity',\n\t\t\t\t       'Data' => $aln_len -\n\t\t\t\t\t   ($inserts + $deletes)});\n\n\t\t       # HSP ends where the other begins\n\t\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t\t       'Data' => $qs});\n\t\t       ## gc note:\n\t\t       ## $qs is now the start of the next hsp\n\t\t       ## the end of this hsp is 1 before this position\n\t\t       ## (or 1 after in case of reverse strand)\n\t\t       $qs += $aln_len*$qstrand;\n\t\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t\t       'Data' => $qs - ($qstrand*1)});\n\n\t\t       $hs += $deletes*$hstrand;\n\t\t       $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t\t       'Data' => $hs});\n\t\t       $hs += $aln_len*$hstrand;\n\t\t       $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t\t       'Data' => $hs-($hstrand*1)});\n\n\t\t       $self->element({'Name' => 'Hsp_align-len',\n\t\t\t\t       'Data' => $aln_len + $inserts\n\t\t\t\t\t   + $deletes});\n\t\t       $self->element({'Name' => 'Hsp_identity',\n\t\t\t\t       'Data' => $aln_len });\n\n\t\t       $self->element({'Name' => 'Hsp_gaps',\n\t\t\t\t       'Data' => $inserts + $deletes});\n\t\t       $self->element({'Name' => 'Hsp_querygaps',\n\t\t\t\t       'Data' => $inserts});\n\t\t       $self->element({'Name' => 'Hsp_hitgaps',\n\t\t\t\t       'Data' => $deletes});\n\n## gc addition start\n\n\t\t       $self->element({'Name' => 'Hsp_qseq',\n\t\t\t\t       'Data' => shift @q_ex,\n\t\t\t\t   });\n\t\t       $self->element({'Name' => 'Hsp_hseq',\n\t\t\t\t       'Data' => shift @h_ex,\n\t\t\t\t   });\n\t\t       $self->element({'Name' => 'Hsp_midline',\n\t\t\t\t       'Data' => shift @m_ex,\n\t\t\t\t   });\n## gc addition end\n\t\t       $self->end_element({'Name' => 'Hsp'});\n\n\t\t       $aln_len = $inserts = $deletes = 0;\n\t\t   }\n\t\t   $deletes+=$len;\n\t       } else {\n\t\t   $aln_len += $len;\n\t       }\n\t   }\n\t   $self->start_element({'Name' => 'Hsp'});\n\n## gc addition start\n\n\t   $self->element({'Name' => 'Hsp_qseq',\n\t\t\t   'Data' => shift @q_ex,\n\t\t       });\n\t   $self->element({'Name' => 'Hsp_hseq',\n\t\t\t   'Data' => shift @h_ex,\n\t\t       });\n\t   $self->element({'Name' => 'Hsp_midline',\n\t\t\t   'Data' => shift @m_ex,\n\t\t       });\n## gc addition end\n\n\t   $self->element({'Name' => 'Hsp_score',\n\t\t\t   'Data' => $score});\n\n\t   $self->element({'Name' => 'Hsp_query-from',\n\t\t\t   'Data' => $qs});\n\n\t   $qs += $aln_len*$qstrand;\n\t   $self->element({'Name' => 'Hsp_query-to',\n\t\t\t   'Data' => $qs - ($qstrand*1)});\n\n\t   $hs += $deletes*$hstrand;\n\t   $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t   'Data' => $hs});\n\t   $hs += $aln_len*$hstrand;\n\t   $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t   'Data' => $hs -($hstrand*1)});\n\n\t   $self->element({'Name' => 'Hsp_align-len',\n\t\t\t   'Data' => $aln_len});\n\n\t   $self->element({'Name' => 'Hsp_identity',\n\t\t\t   'Data' => $aln_len - ($inserts + $deletes)});\n\n\t   $self->element({'Name' => 'Hsp_gaps',\n\t\t\t   'Data' => $inserts + $deletes});\n\n\t   $self->element({'Name' => 'Hsp_querygaps',\n\t\t\t   'Data' => $inserts});\n\t   $self->element({'Name' => 'Hsp_hitgaps',\n\t\t\t   'Data' => $deletes});\n\t   $self->end_element({'Name' => 'Hsp'});\n\n\t   $self->element({'Name' => 'Hit_score',\n\t\t\t   'Data' => $score});\n\n\t   $self->end_element({'Name' => 'Hit'});\n\t   $self->end_element({'Name' => 'ExonerateOutput'});\n\n\t   return $self->end_document();\n       } else {\n\t   # skipping this line\n       }\n   }\n   return $self->end_document() if( $seentop );\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n   # we currently don't care about attributes\n   my $nm = $data->{'Name'};\n   my $type = $MODEMAP{$nm};\n\n   if( $type ) {\n       if( $self->_eventHandler->will_handle($type) ) {\n\t   my $func = sprintf(\"start_%s\",lc $type);\n\t   $self->_eventHandler->$func($data->{'Attributes'});\n       }\n       unshift @{$self->{'_elements'}}, $type;\n       if($type eq 'result') {\n\t   $self->{'_values'} = {};\n\t   $self->{'_result'}= undef;\n       }\n   }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'"},"kind":12,"range":{"start":{"character":0,"line":587},"end":{"line":601,"character":9999}},"line":587},{"line":601,"kind":13,"containerName":null,"name":"%MAPPING"},{"kind":13,"containerName":null,"name":"%nm","line":601},{"name":"%MAPPING","containerName":null,"kind":13,"line":603},{"line":603,"name":"%nm","containerName":null,"kind":13},{"line":604,"kind":13,"localvar":"my","containerName":null,"name":"$key","definition":"my"},{"line":604,"name":"%MAPPING","containerName":null,"kind":13},{"line":604,"kind":13,"containerName":null,"name":"@nm"},{"kind":13,"containerName":null,"name":"%self","line":605},{"line":605,"name":"%key","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%MAPPING","line":605},{"name":"%nm","kind":13,"containerName":null,"line":605},{"line":605,"containerName":null,"kind":13,"name":"$key"},{"name":"%self","containerName":null,"kind":13,"line":605},{"name":"%self","kind":13,"containerName":null,"line":607},{"name":"%MAPPING","containerName":null,"kind":13,"line":607},{"name":"$nm","kind":13,"containerName":null,"line":607},{"containerName":null,"kind":13,"name":"%self","line":607},{"line":610,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"containerName":"main::","name":"debug","line":610},{"kind":13,"containerName":null,"name":"%self","line":612},{"line":614,"name":"%self","containerName":null,"kind":13},{"line":614,"containerName":null,"kind":13,"name":"$rc"},{"kind":13,"containerName":null,"name":"$type","line":614},{"containerName":null,"kind":13,"name":"$type","line":614},{"line":615,"name":"$rc","containerName":null,"kind":13},{"definition":"sub","detail":"($self,$data)","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"element","name":"$self","line":630},{"name":"$data","containerName":"element","kind":13,"line":630},{"kind":13,"containerName":"element","name":"$self","line":631},{"line":631,"name":"start_element","containerName":"element","kind":12},{"line":631,"containerName":"element","kind":13,"name":"$data"},{"containerName":"element","kind":13,"name":"$self","line":632},{"containerName":"element","kind":12,"name":"characters","line":632},{"name":"$data","kind":13,"containerName":"element","line":632},{"line":633,"name":"$self","containerName":"element","kind":13},{"line":633,"containerName":"element","kind":12,"name":"end_element"},{"kind":13,"containerName":"element","name":"$data","line":633}],"containerName":"main::","name":"element","signature":{"label":"element($self,$data)","parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: exonerate.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::exonerate\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::exonerate - parser for Exonerate\n\n=head1 SYNOPSIS\n\n  # do not use this module directly, it is a driver for SearchIO\n\n  use Bio::SearchIO;\n  my $searchio = Bio::SearchIO->new(-file => 'file.exonerate',\n                                   -format => 'exonerate');\n\n\n  while( my $r = $searchio->next_result ) {\n    print $r->query_name, \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis is a driver for the SearchIO system for parsing Exonerate (Guy\nSlater) output.  You can get Exonerate at\nhttp://www.ebi.ac.uk/~guy/exonerate/\n[until Guy puts up a Web reference,publication for it.]).\n\nAn optional parameter -min_intron is supported by the L<new>\ninitialization method.  This is if you run Exonerate with a different\nminimum intron length (default is 30) the parser will be able to\ndetect the difference between standard deletions and an intron.  Still\nsome room to play with there that might cause this to get\nmisinterpreted that has not been fully tested or explored.\n\nThe VULGAR and CIGAR formats should be parsed okay now creating HSPs\nwhere appropriate (so merging match states where appropriate rather\nthan breaking an HSP at each indel as it may have done in the past).\nThe GFF that comes from exonerate is still probably a better way to go\nif you are doing protein2genome or est2genome mapping.\nFor example you can see this script:\n\n### TODO: Jason, this link is dead, do we have an updated one?\nhttp://fungal.genome.duke.edu/~jes12/software/scripts/process_exonerate_gff3.perl.txt\n\nIf your report contains both CIGAR and VULGAR lines only the first one\nwill processed for a given Query/Target pair.  If you preferentially\nwant to use VULGAR or CIGAR add one of these options when initializing\nthe SearchIO object.\n\n    -cigar  => 1\nOR\n    -vulgar => 1\n\nOr set them via these methods.\n\n    $parser->cigar(1)\nOR\n    $parser->vulgar(1)\n\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::exonerate;\nuse strict;\nuse vars qw(@STATES %MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $MIN_INTRON);\n\nuse base qw(Bio::SearchIO);\n\n%MODEMAP = ( 'ExonerateOutput' => 'result',\n    'Hit'             => 'hit',\n    'Hsp'             => 'hsp'\n    );\n\n%MAPPING =\n    (\n    'Hsp_query-from'=>  'HSP-query_start',\n    'Hsp_query-to'  =>  'HSP-query_end',\n    'Hsp_hit-from'  =>  'HSP-hit_start',\n    'Hsp_hit-to'    =>  'HSP-hit_end',\n    'Hsp_qseq'      =>  'HSP-query_seq',\n    'Hsp_hseq'      =>  'HSP-hit_seq',\n    'Hsp_midline'   =>  'HSP-homology_seq',\n    'Hsp_score'     =>  'HSP-score',\n    'Hsp_qlength'   =>  'HSP-query_length',\n    'Hsp_hlength'   =>  'HSP-hit_length',\n    'Hsp_align-len' =>  'HSP-hsp_length',\n    'Hsp_identity'  =>  'HSP-identical',\n    'Hsp_gaps'       => 'HSP-hsp_gaps',\n    'Hsp_hitgaps'    => 'HSP-hit_gaps',\n    'Hsp_querygaps'  => 'HSP-query_gaps',\n\n    'Hit_id'        => 'HIT-name',\n    'Hit_desc'      => 'HIT-description',\n    'Hit_len'       => 'HIT-length',\n    'Hit_score'     => 'HIT-score',\n\n    'ExonerateOutput_program'   => 'RESULT-algorithm_name',\n    'ExonerateOutput_query-def' => 'RESULT-query_name',\n    'ExonerateOutput_query-desc'=> 'RESULT-query_description',\n    'ExonerateOutput_query-len' => 'RESULT-query_length',\n    );\n\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n$MIN_INTRON=30; # This is the minimum intron size\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::exonerate->new();\n Function: Builds a new Bio::SearchIO::exonerate object\n Returns : an instance of Bio::SearchIO::exonerate\n Args    : -min_intron => somewhat obselete option, how to determine if a\n                          an indel is an intron or a local gap.  Use VULGAR\n                          rather than CIGAR to avoid this heuristic,default 30.\n           -cigar       => 1   set this to 1 if you want to parse\n                               CIGAR exclusively.\n           -vulgar      => 1   set this to 1 if you want to parse VULGAR\n                               exclusively, setting both to 1 will revert\n                               to the default behavior of just parsing the\n                               first line that it sees.\n\n\nsub new {\n    my ($class) = shift;\n    my $self = $class->SUPER::new(@_);\n\n    my ($min_intron,$cigar,\n\t$vulgar) = $self->_rearrange([qw(MIN_INTRON\n\t\t\t\t\t CIGAR\n\t\t\t\t\t VULGAR)], @_);\n    if( $min_intron ) {\n\t$MIN_INTRON = $min_intron;\n    }\n    if( $cigar && $vulgar ) {\n\t$self->warn(\"cannot get HSPs from both CIGAR and VULGAR lines, will just choose whichever comes first (same as if you had chosen neither\");\n\t$cigar = 0; $vulgar=0;\n    }\n    $self->cigar($cigar);\n    $self->vulgar($vulgar);\n    $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n   my ($self) = @_;\n   local $/ = \"\\n\";\n   local $_;\n\n   $self->{'_last_data'} = '';\n   my ($reporttype,$seenquery,$reportline);\n   $self->start_document();\n   my @hit_signifs;\n   my $seentop;\n   my (@q_ex, @m_ex, @h_ex); ## gc addition\n   while( defined($_ = $self->_readline) ) {\n       # warn( \"Reading $_\");\n       if( /^Query:\\s+(\\S+)\\s*(.+)?/ ) {\n\t   if( $seentop ) {\n\t       $self->end_element({'Name' => 'ExonerateOutput'});\n\t       $self->_pushback($_);\n\t       return $self->end_document();\n\t   }\n\t   $seentop = 1;\n\t   my ($nm,$desc) = ($1,$2);\n\t   chomp($desc) if defined $desc;\n\t   $self->{'_result_count'}++;\n\t   $self->start_element({'Name' => 'ExonerateOutput'});\n\t   $self->element({'Name' => 'ExonerateOutput_query-def',\n\t\t\t   'Data' => $nm });\n\t   $self->element({'Name' => 'ExonerateOutput_query-desc',\n\t\t\t   'Data' => $desc });\n\t   $self->element({'Name' => 'ExonerateOutput_program',\n\t\t\t   'Data' => 'Exonerate' });\n\t   $self->{'_seencigar'} = 0;\n\t   $self->{'_vulgar'}    = 0;\n\n       } elsif ( /^Target:\\s+(\\S+)\\s*(.+)?/ ) {\n\t   my ($nm,$desc) = ($1,$2);\n\t   chomp($desc) if defined $desc;\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $nm});\n\t   $self->element({'Name' => 'Hit_desc',\n\t\t\t   'Data' => $desc});\n\t   $self->{'_seencigar'} = 0;\n\t   $self->{'_vulgar'}    = 0;\n       } elsif(  s/^vulgar:\\s+(\\S+)\\s+         # query sequence id\n\t\t (\\d+)\\s+(\\d+)\\s+([\\-\\+\\.])\\s+ # query start-end-strand\n\t\t (\\S+)\\s+                      # target sequence id\n\t\t (\\d+)\\s+(\\d+)\\s+([\\-\\+])\\s+   # target start-end-strand\n\t\t (\\d+)\\s+                      # score\n\t\t //ox ) {\n\t   next if( $self->cigar || $self->{'_seencigar'});\n\t   $self->{'_vulgar'}++;\n\t   #\n\t   # Note from Ewan. This is ugly - copy and paste from\n\t   # cigar line parsing. Should unify somehow...\n\t   #\n\t   if( ! $self->within_element('result') ) {\n\t       $self->start_element({'Name' => 'ExonerateOutput'});\n\t       $self->element({'Name' => 'ExonerateOutput_query-def',\n\t\t\t       'Data' => $1 });\n\t   }\n\t   if( ! $self->within_element('hit') ) {\n\t       $self->start_element({'Name' => 'Hit'});\n\t       $self->element({'Name' => 'Hit_id',\n\t\t\t       'Data' => $5});\n\t   }\n\n\t   ## gc note:\n\t   ## $qe and $he are no longer used for calculating the ends,\n\t   ## just the $qs and $hs values and the alignment and insert lenghts\n\t   my ($qs,$qe,$qstrand) = ($2,$3,$4);\n\t   my ($hs,$he,$hstrand) = ($6,$7,$8);\n\t   my $score = $9;\n#\t   $self->element({'Name' => 'ExonerateOutput_query-len',\n#\t\t\t   'Data' => $qe});\n#\t   $self->element({'Name' => 'Hit_len',\n#\t\t\t   'Data' => $he});\n\n\t   ## gc note:\n\t   ## add one because these values are zero-based\n\t   ## this calculation was originally done lower in the code,\n\t   ## but it's clearer to do it just once at the start\n\t   my @rest = split;\n\t   my ($qbegin,$qend) = ('query-from', 'query-to');\n\n\t   if( $qstrand eq '-' ) {\n\t       $qstrand = -1; $qe++;\n\t   } else {\n\t       $qstrand = 1;\n\t       $qs++;\n\t   }\n\t   my ($hbegin,$hend) = ('hit-from', 'hit-to');\n\n\t   if( $hstrand eq '-' ) {\n\t       $hstrand = -1;\n\t       $he++;\n\t   } else {\n\t       $hstrand = 1;\n\t       $hs++;\n\t   }\n\t   # okay let's do this right and generate a set of HSPs\n\t   # from the cigar line/home/bio1/jes12/bin/exonerate  --model est2genome --bestn 1 t/data/exonerate_cdna.fa t/data/exonerate_genomic_rev.fa\n\n\t   my ($aln_len,$inserts,$deletes) = (0,0,0);\n\t   my ($laststate,@events,$gaps) =( '' );\n\t   while( @rest >= 3 ) {\n\t       my ($state,$len1,$len2) = (shift @rest, shift @rest, shift @rest);\n\t       #\n\t       # HSPs are only the Match cases; otherwise we just\n\t       # move the coordinates on by the correct amount\n\t       #\n\n\t       if( $state eq 'M' ) {\n\t\t   if( $laststate eq 'G' ) {\n\t\t       # merge gaps across Match states so the HSP\n\t\t       # goes across\n\t\t       $events[-1]->{$qend} = $qs + $len1*$qstrand - $qstrand;\n\t\t       $events[-1]->{$hend}   = $hs + $len2*$hstrand - $hstrand;\n\t\t       $events[-1]->{'gaps'} = $gaps;\n\t\t   } else {\n\t\t       push @events,\n\t\t       { 'score'     => $score,\n\t\t\t 'align-len' => $len1,\n\t\t\t $qbegin => $qs,\n\t\t\t $qend  => ($qs + $len1*$qstrand - $qstrand),\n\t\t\t $hbegin => $hs,\n\t\t\t $hend   => ($hs + $len2*$hstrand - $hstrand),\n\t\t     };\n\t\t   }\n\t\t   $gaps = 0;\n\t       } else {\n\t\t   $gaps = $len1 + $len2 if $state eq 'G';\n\t       }\n\t       $qs += $len1*$qstrand;\n\t       $hs += $len2*$hstrand;\n\t       $laststate= $state;\n\t   }\n\t   for my $event ( @events ) {\n\t       $self->start_element({'Name' => 'Hsp'});\n\t       while( my ($key,$val) = each %$event ) {\n\t\t   $self->element({'Name' => \"Hsp_$key\",\n\t\t\t\t   'Data' => $val});\n\t       }\n\t       $self->element({'Name' => 'Hsp_identity',\n\t\t\t       'Data' => 0});\n\t       $self->end_element({'Name' => 'Hsp'});\n\t   }\n\n\t   # end of hit\n\t   $self->element({'Name' => 'Hit_score',\n\t\t\t   'Data' => $score});\n\t   # issued end...\n\t   $self->end_element({'Name' => 'Hit'});\n\t   $self->end_element({'Name' => 'ExonerateOutput'});\n\n\t   return $self->end_document();\n\n       } elsif(  s/^cigar:\\s+(\\S+)\\s+          # query sequence id\n\t\t (\\d+)\\s+(\\d+)\\s+([\\-\\+])\\s+   # query start-end-strand\n\t\t (\\S+)\\s+                      # target sequence id\n\t\t (\\d+)\\s+(\\d+)\\s+([\\-\\+])\\s+   # target start-end-strand\n\t\t (\\d+)\\s+                      # score\n\t\t //ox ) {\n\t   next if( $self->vulgar || $self->{'_seenvulgar'});\n\t   $self->{'_cigar'}++;\n\n\t   if( ! $self->within_element('result') ) {\n\t       $self->start_element({'Name' => 'ExonerateOutput'});\n\t       $self->element({'Name' => 'ExonerateOutput_query-def',\n\t\t\t       'Data' => $1 });\n\t   }\n\t   if( ! $self->within_element('hit') ) {\n\t       $self->start_element({'Name' => 'Hit'});\n\t       $self->element({'Name' => 'Hit_id',\n\t\t\t       'Data' => $5});\n\t   }\n\t   ## gc note:\n\t   ## $qe and $he are no longer used for calculating the ends,\n\t   ## just the $qs and $hs values and the alignment and insert lenghts\n\t   my ($qs,$qe,$qstrand) = ($2,$3,$4);\n\t   my ($hs,$he,$hstrand) = ($6,$7,$8);\n\t   my $score = $9;\n#\t   $self->element({'Name' => 'ExonerateOutput_query-len',\n#\t\t\t   'Data' => $qe});\n#\t   $self->element({'Name' => 'Hit_len',\n#\t\t\t   'Data' => $he});\n\n\t   my @rest = split;\n\t   if( $qstrand eq '-' ) {\n\t       $qstrand = -1;\n\t       ($qs,$qe) = ($qe,$qs); # flip-flop if we're on opp strand\n\t       $qs--; $qe++;\n\t   } else { $qstrand = 1; }\n\t   if( $hstrand eq '-' ) {\n\t       $hstrand = -1;\n\t       ($hs,$he) = ($he,$hs); # flip-flop if we're on opp strand\n\t       $hs--; $he++;\n\t   } else { $hstrand = 1; }\n\t   # okay let's do this right and generate a set of HSPs\n\t   # from the cigar line\n\n\t   ## gc note:\n\t   ## add one because these values are zero-based\n\t   ## this calculation was originally done lower in the code,\n\t   ## but it's clearer to do it just once at the start\n\t   $qs++; $hs++;\n\n\t   my ($aln_len,$inserts,$deletes) = (0,0,0);\n\t   while( @rest >= 2 ) {\n\t       my ($state,$len) = (shift @rest, shift @rest);\n\t       if( $state eq 'I' ) {\n\t\t   $inserts+=$len;\n\t       } elsif( $state eq 'D' ) {\n\t\t   if( $len >= $MIN_INTRON ) {\n\t\t       $self->start_element({'Name' => 'Hsp'});\n\n\t\t       $self->element({'Name' => 'Hsp_score',\n\t\t\t\t       'Data' => $score});\n\t\t       $self->element({'Name' => 'Hsp_align-len',\n\t\t\t\t       'Data' => $aln_len});\n\t\t       $self->element({'Name' => 'Hsp_identity',\n\t\t\t\t       'Data' => $aln_len -\n\t\t\t\t\t   ($inserts + $deletes)});\n\n\t\t       # HSP ends where the other begins\n\t\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t\t       'Data' => $qs});\n\t\t       ## gc note:\n\t\t       ## $qs is now the start of the next hsp\n\t\t       ## the end of this hsp is 1 before this position\n\t\t       ## (or 1 after in case of reverse strand)\n\t\t       $qs += $aln_len*$qstrand;\n\t\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t\t       'Data' => $qs - ($qstrand*1)});\n\n\t\t       $hs += $deletes*$hstrand;\n\t\t       $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t\t       'Data' => $hs});\n\t\t       $hs += $aln_len*$hstrand;\n\t\t       $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t\t       'Data' => $hs-($hstrand*1)});\n\n\t\t       $self->element({'Name' => 'Hsp_align-len',\n\t\t\t\t       'Data' => $aln_len + $inserts\n\t\t\t\t\t   + $deletes});\n\t\t       $self->element({'Name' => 'Hsp_identity',\n\t\t\t\t       'Data' => $aln_len });\n\n\t\t       $self->element({'Name' => 'Hsp_gaps',\n\t\t\t\t       'Data' => $inserts + $deletes});\n\t\t       $self->element({'Name' => 'Hsp_querygaps',\n\t\t\t\t       'Data' => $inserts});\n\t\t       $self->element({'Name' => 'Hsp_hitgaps',\n\t\t\t\t       'Data' => $deletes});\n\n## gc addition start\n\n\t\t       $self->element({'Name' => 'Hsp_qseq',\n\t\t\t\t       'Data' => shift @q_ex,\n\t\t\t\t   });\n\t\t       $self->element({'Name' => 'Hsp_hseq',\n\t\t\t\t       'Data' => shift @h_ex,\n\t\t\t\t   });\n\t\t       $self->element({'Name' => 'Hsp_midline',\n\t\t\t\t       'Data' => shift @m_ex,\n\t\t\t\t   });\n## gc addition end\n\t\t       $self->end_element({'Name' => 'Hsp'});\n\n\t\t       $aln_len = $inserts = $deletes = 0;\n\t\t   }\n\t\t   $deletes+=$len;\n\t       } else {\n\t\t   $aln_len += $len;\n\t       }\n\t   }\n\t   $self->start_element({'Name' => 'Hsp'});\n\n## gc addition start\n\n\t   $self->element({'Name' => 'Hsp_qseq',\n\t\t\t   'Data' => shift @q_ex,\n\t\t       });\n\t   $self->element({'Name' => 'Hsp_hseq',\n\t\t\t   'Data' => shift @h_ex,\n\t\t       });\n\t   $self->element({'Name' => 'Hsp_midline',\n\t\t\t   'Data' => shift @m_ex,\n\t\t       });\n## gc addition end\n\n\t   $self->element({'Name' => 'Hsp_score',\n\t\t\t   'Data' => $score});\n\n\t   $self->element({'Name' => 'Hsp_query-from',\n\t\t\t   'Data' => $qs});\n\n\t   $qs += $aln_len*$qstrand;\n\t   $self->element({'Name' => 'Hsp_query-to',\n\t\t\t   'Data' => $qs - ($qstrand*1)});\n\n\t   $hs += $deletes*$hstrand;\n\t   $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t   'Data' => $hs});\n\t   $hs += $aln_len*$hstrand;\n\t   $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t   'Data' => $hs -($hstrand*1)});\n\n\t   $self->element({'Name' => 'Hsp_align-len',\n\t\t\t   'Data' => $aln_len});\n\n\t   $self->element({'Name' => 'Hsp_identity',\n\t\t\t   'Data' => $aln_len - ($inserts + $deletes)});\n\n\t   $self->element({'Name' => 'Hsp_gaps',\n\t\t\t   'Data' => $inserts + $deletes});\n\n\t   $self->element({'Name' => 'Hsp_querygaps',\n\t\t\t   'Data' => $inserts});\n\t   $self->element({'Name' => 'Hsp_hitgaps',\n\t\t\t   'Data' => $deletes});\n\t   $self->end_element({'Name' => 'Hsp'});\n\n\t   $self->element({'Name' => 'Hit_score',\n\t\t\t   'Data' => $score});\n\n\t   $self->end_element({'Name' => 'Hit'});\n\t   $self->end_element({'Name' => 'ExonerateOutput'});\n\n\t   return $self->end_document();\n       } else {\n\t   # skipping this line\n       }\n   }\n   return $self->end_document() if( $seentop );\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n   # we currently don't care about attributes\n   my $nm = $data->{'Name'};\n   my $type = $MODEMAP{$nm};\n\n   if( $type ) {\n       if( $self->_eventHandler->will_handle($type) ) {\n\t   my $func = sprintf(\"start_%s\",lc $type);\n\t   $self->_eventHandler->$func($data->{'Attributes'});\n       }\n       unshift @{$self->{'_elements'}}, $type;\n       if($type eq 'result') {\n\t   $self->{'_values'} = {};\n\t   $self->{'_result'}= undef;\n       }\n   }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if( $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) {\n\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else {\n\t$self->debug( \"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at\n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'"},"line":629,"range":{"end":{"character":9999,"line":634},"start":{"line":629,"character":0}},"kind":12},{"children":[{"line":648,"name":"$self","localvar":"my","kind":13,"containerName":"characters","definition":"my"},{"kind":13,"containerName":"characters","name":"$data","line":648},{"line":650,"name":"$data","containerName":"characters","kind":13},{"name":"$data","containerName":"characters","kind":13,"line":650},{"kind":13,"containerName":"characters","name":"$self","line":652},{"name":"$data","containerName":"characters","kind":13,"line":652}],"name":"characters","containerName":"main::","definition":"sub","detail":"($self,$data)","line":647,"range":{"end":{"line":653,"character":9999},"start":{"character":0,"line":647}},"kind":12,"signature":{"documentation":"1;\n# $Id: exonerate.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::exonerate\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::exonerate - parser for Exonerate\n\n=head1 SYNOPSIS\n\n  # do not use this module directly, it is a driver for SearchIO\n\n  use Bio::SearchIO;\n  my $searchio = Bio::SearchIO->new(-file => 'file.exonerate',\n                                   -format => 'exonerate');\n\n\n  while( my $r = $searchio->next_result ) {\n    print $r->query_name, \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis is a driver for the SearchIO system for parsing Exonerate (Guy\nSlater) output.  You can get Exonerate at\nhttp://www.ebi.ac.uk/~guy/exonerate/\n[until Guy puts up a Web reference,publication for it.]).\n\nAn optional parameter -min_intron is supported by the L<new>\ninitialization method.  This is if you run Exonerate with a different\nminimum intron length (default is 30) the parser will be able to\ndetect the difference between standard deletions and an intron.  Still\nsome room to play with there that might cause this to get\nmisinterpreted that has not been fully tested or explored.\n\nThe VULGAR and CIGAR formats should be parsed okay now creating HSPs\nwhere appropriate (so merging match states where appropriate rather\nthan breaking an HSP at each indel as it may have done in the past).\nThe GFF that comes from exonerate is still probably a better way to go\nif you are doing protein2genome or est2genome mapping.\nFor example you can see this script:\n\n### TODO: Jason, this link is dead, do we have an updated one?\nhttp://fungal.genome.duke.edu/~jes12/software/scripts/process_exonerate_gff3.perl.txt\n\nIf your report contains both CIGAR and VULGAR lines only the first one\nwill processed for a given Query/Target pair.  If you preferentially\nwant to use VULGAR or CIGAR add one of these options when initializing\nthe SearchIO object.\n\n    -cigar  => 1\nOR\n    -vulgar => 1\n\nOr set them via these methods.\n\n    $parser->cigar(1)\nOR\n    $parser->vulgar(1)\n\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::exonerate;\nuse strict;\nuse vars qw(@STATES %MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $MIN_INTRON);\n\nuse base qw(Bio::SearchIO);\n\n%MODEMAP = ( 'ExonerateOutput' => 'result',\n    'Hit'             => 'hit',\n    'Hsp'             => 'hsp'\n    );\n\n%MAPPING =\n    (\n    'Hsp_query-from'=>  'HSP-query_start',\n    'Hsp_query-to'  =>  'HSP-query_end',\n    'Hsp_hit-from'  =>  'HSP-hit_start',\n    'Hsp_hit-to'    =>  'HSP-hit_end',\n    'Hsp_qseq'      =>  'HSP-query_seq',\n    'Hsp_hseq'      =>  'HSP-hit_seq',\n    'Hsp_midline'   =>  'HSP-homology_seq',\n    'Hsp_score'     =>  'HSP-score',\n    'Hsp_qlength'   =>  'HSP-query_length',\n    'Hsp_hlength'   =>  'HSP-hit_length',\n    'Hsp_align-len' =>  'HSP-hsp_length',\n    'Hsp_identity'  =>  'HSP-identical',\n    'Hsp_gaps'       => 'HSP-hsp_gaps',\n    'Hsp_hitgaps'    => 'HSP-hit_gaps',\n    'Hsp_querygaps'  => 'HSP-query_gaps',\n\n    'Hit_id'        => 'HIT-name',\n    'Hit_desc'      => 'HIT-description',\n    'Hit_len'       => 'HIT-length',\n    'Hit_score'     => 'HIT-score',\n\n    'ExonerateOutput_program'   => 'RESULT-algorithm_name',\n    'ExonerateOutput_query-def' => 'RESULT-query_name',\n    'ExonerateOutput_query-desc'=> 'RESULT-query_description',\n    'ExonerateOutput_query-len' => 'RESULT-query_length',\n    );\n\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n$MIN_INTRON=30; # This is the minimum intron size\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::exonerate->new();\n Function: Builds a new Bio::SearchIO::exonerate object\n Returns : an instance of Bio::SearchIO::exonerate\n Args    : -min_intron => somewhat obselete option, how to determine if a\n                          an indel is an intron or a local gap.  Use VULGAR\n                          rather than CIGAR to avoid this heuristic,default 30.\n           -cigar       => 1   set this to 1 if you want to parse\n                               CIGAR exclusively.\n           -vulgar      => 1   set this to 1 if you want to parse VULGAR\n                               exclusively, setting both to 1 will revert\n                               to the default behavior of just parsing the\n                               first line that it sees.\n\n\nsub new {\n    my ($class) = shift;\n    my $self = $class->SUPER::new(@_);\n\n    my ($min_intron,$cigar,\n\t$vulgar) = $self->_rearrange([qw(MIN_INTRON\n\t\t\t\t\t CIGAR\n\t\t\t\t\t VULGAR)], @_);\n    if( $min_intron ) {\n\t$MIN_INTRON = $min_intron;\n    }\n    if( $cigar && $vulgar ) {\n\t$self->warn(\"cannot get HSPs from both CIGAR and VULGAR lines, will just choose whichever comes first (same as if you had chosen neither\");\n\t$cigar = 0; $vulgar=0;\n    }\n    $self->cigar($cigar);\n    $self->vulgar($vulgar);\n    $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n   my ($self) = @_;\n   local $/ = \"\\n\";\n   local $_;\n\n   $self->{'_last_data'} = '';\n   my ($reporttype,$seenquery,$reportline);\n   $self->start_document();\n   my @hit_signifs;\n   my $seentop;\n   my (@q_ex, @m_ex, @h_ex); ## gc addition\n   while( defined($_ = $self->_readline) ) {\n       # warn( \"Reading $_\");\n       if( /^Query:\\s+(\\S+)\\s*(.+)?/ ) {\n\t   if( $seentop ) {\n\t       $self->end_element({'Name' => 'ExonerateOutput'});\n\t       $self->_pushback($_);\n\t       return $self->end_document();\n\t   }\n\t   $seentop = 1;\n\t   my ($nm,$desc) = ($1,$2);\n\t   chomp($desc) if defined $desc;\n\t   $self->{'_result_count'}++;\n\t   $self->start_element({'Name' => 'ExonerateOutput'});\n\t   $self->element({'Name' => 'ExonerateOutput_query-def',\n\t\t\t   'Data' => $nm });\n\t   $self->element({'Name' => 'ExonerateOutput_query-desc',\n\t\t\t   'Data' => $desc });\n\t   $self->element({'Name' => 'ExonerateOutput_program',\n\t\t\t   'Data' => 'Exonerate' });\n\t   $self->{'_seencigar'} = 0;\n\t   $self->{'_vulgar'}    = 0;\n\n       } elsif ( /^Target:\\s+(\\S+)\\s*(.+)?/ ) {\n\t   my ($nm,$desc) = ($1,$2);\n\t   chomp($desc) if defined $desc;\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $nm});\n\t   $self->element({'Name' => 'Hit_desc',\n\t\t\t   'Data' => $desc});\n\t   $self->{'_seencigar'} = 0;\n\t   $self->{'_vulgar'}    = 0;\n       } elsif(  s/^vulgar:\\s+(\\S+)\\s+         # query sequence id\n\t\t (\\d+)\\s+(\\d+)\\s+([\\-\\+\\.])\\s+ # query start-end-strand\n\t\t (\\S+)\\s+                      # target sequence id\n\t\t (\\d+)\\s+(\\d+)\\s+([\\-\\+])\\s+   # target start-end-strand\n\t\t (\\d+)\\s+                      # score\n\t\t //ox ) {\n\t   next if( $self->cigar || $self->{'_seencigar'});\n\t   $self->{'_vulgar'}++;\n\t   #\n\t   # Note from Ewan. This is ugly - copy and paste from\n\t   # cigar line parsing. Should unify somehow...\n\t   #\n\t   if( ! $self->within_element('result') ) {\n\t       $self->start_element({'Name' => 'ExonerateOutput'});\n\t       $self->element({'Name' => 'ExonerateOutput_query-def',\n\t\t\t       'Data' => $1 });\n\t   }\n\t   if( ! $self->within_element('hit') ) {\n\t       $self->start_element({'Name' => 'Hit'});\n\t       $self->element({'Name' => 'Hit_id',\n\t\t\t       'Data' => $5});\n\t   }\n\n\t   ## gc note:\n\t   ## $qe and $he are no longer used for calculating the ends,\n\t   ## just the $qs and $hs values and the alignment and insert lenghts\n\t   my ($qs,$qe,$qstrand) = ($2,$3,$4);\n\t   my ($hs,$he,$hstrand) = ($6,$7,$8);\n\t   my $score = $9;\n#\t   $self->element({'Name' => 'ExonerateOutput_query-len',\n#\t\t\t   'Data' => $qe});\n#\t   $self->element({'Name' => 'Hit_len',\n#\t\t\t   'Data' => $he});\n\n\t   ## gc note:\n\t   ## add one because these values are zero-based\n\t   ## this calculation was originally done lower in the code,\n\t   ## but it's clearer to do it just once at the start\n\t   my @rest = split;\n\t   my ($qbegin,$qend) = ('query-from', 'query-to');\n\n\t   if( $qstrand eq '-' ) {\n\t       $qstrand = -1; $qe++;\n\t   } else {\n\t       $qstrand = 1;\n\t       $qs++;\n\t   }\n\t   my ($hbegin,$hend) = ('hit-from', 'hit-to');\n\n\t   if( $hstrand eq '-' ) {\n\t       $hstrand = -1;\n\t       $he++;\n\t   } else {\n\t       $hstrand = 1;\n\t       $hs++;\n\t   }\n\t   # okay let's do this right and generate a set of HSPs\n\t   # from the cigar line/home/bio1/jes12/bin/exonerate  --model est2genome --bestn 1 t/data/exonerate_cdna.fa t/data/exonerate_genomic_rev.fa\n\n\t   my ($aln_len,$inserts,$deletes) = (0,0,0);\n\t   my ($laststate,@events,$gaps) =( '' );\n\t   while( @rest >= 3 ) {\n\t       my ($state,$len1,$len2) = (shift @rest, shift @rest, shift @rest);\n\t       #\n\t       # HSPs are only the Match cases; otherwise we just\n\t       # move the coordinates on by the correct amount\n\t       #\n\n\t       if( $state eq 'M' ) {\n\t\t   if( $laststate eq 'G' ) {\n\t\t       # merge gaps across Match states so the HSP\n\t\t       # goes across\n\t\t       $events[-1]->{$qend} = $qs + $len1*$qstrand - $qstrand;\n\t\t       $events[-1]->{$hend}   = $hs + $len2*$hstrand - $hstrand;\n\t\t       $events[-1]->{'gaps'} = $gaps;\n\t\t   } else {\n\t\t       push @events,\n\t\t       { 'score'     => $score,\n\t\t\t 'align-len' => $len1,\n\t\t\t $qbegin => $qs,\n\t\t\t $qend  => ($qs + $len1*$qstrand - $qstrand),\n\t\t\t $hbegin => $hs,\n\t\t\t $hend   => ($hs + $len2*$hstrand - $hstrand),\n\t\t     };\n\t\t   }\n\t\t   $gaps = 0;\n\t       } else {\n\t\t   $gaps = $len1 + $len2 if $state eq 'G';\n\t       }\n\t       $qs += $len1*$qstrand;\n\t       $hs += $len2*$hstrand;\n\t       $laststate= $state;\n\t   }\n\t   for my $event ( @events ) {\n\t       $self->start_element({'Name' => 'Hsp'});\n\t       while( my ($key,$val) = each %$event ) {\n\t\t   $self->element({'Name' => \"Hsp_$key\",\n\t\t\t\t   'Data' => $val});\n\t       }\n\t       $self->element({'Name' => 'Hsp_identity',\n\t\t\t       'Data' => 0});\n\t       $self->end_element({'Name' => 'Hsp'});\n\t   }\n\n\t   # end of hit\n\t   $self->element({'Name' => 'Hit_score',\n\t\t\t   'Data' => $score});\n\t   # issued end...\n\t   $self->end_element({'Name' => 'Hit'});\n\t   $self->end_element({'Name' => 'ExonerateOutput'});\n\n\t   return $self->end_document();\n\n       } elsif(  s/^cigar:\\s+(\\S+)\\s+          # query sequence id\n\t\t (\\d+)\\s+(\\d+)\\s+([\\-\\+])\\s+   # query start-end-strand\n\t\t (\\S+)\\s+                      # target sequence id\n\t\t (\\d+)\\s+(\\d+)\\s+([\\-\\+])\\s+   # target start-end-strand\n\t\t (\\d+)\\s+                      # score\n\t\t //ox ) {\n\t   next if( $self->vulgar || $self->{'_seenvulgar'});\n\t   $self->{'_cigar'}++;\n\n\t   if( ! $self->within_element('result') ) {\n\t       $self->start_element({'Name' => 'ExonerateOutput'});\n\t       $self->element({'Name' => 'ExonerateOutput_query-def',\n\t\t\t       'Data' => $1 });\n\t   }\n\t   if( ! $self->within_element('hit') ) {\n\t       $self->start_element({'Name' => 'Hit'});\n\t       $self->element({'Name' => 'Hit_id',\n\t\t\t       'Data' => $5});\n\t   }\n\t   ## gc note:\n\t   ## $qe and $he are no longer used for calculating the ends,\n\t   ## just the $qs and $hs values and the alignment and insert lenghts\n\t   my ($qs,$qe,$qstrand) = ($2,$3,$4);\n\t   my ($hs,$he,$hstrand) = ($6,$7,$8);\n\t   my $score = $9;\n#\t   $self->element({'Name' => 'ExonerateOutput_query-len',\n#\t\t\t   'Data' => $qe});\n#\t   $self->element({'Name' => 'Hit_len',\n#\t\t\t   'Data' => $he});\n\n\t   my @rest = split;\n\t   if( $qstrand eq '-' ) {\n\t       $qstrand = -1;\n\t       ($qs,$qe) = ($qe,$qs); # flip-flop if we're on opp strand\n\t       $qs--; $qe++;\n\t   } else { $qstrand = 1; }\n\t   if( $hstrand eq '-' ) {\n\t       $hstrand = -1;\n\t       ($hs,$he) = ($he,$hs); # flip-flop if we're on opp strand\n\t       $hs--; $he++;\n\t   } else { $hstrand = 1; }\n\t   # okay let's do this right and generate a set of HSPs\n\t   # from the cigar line\n\n\t   ## gc note:\n\t   ## add one because these values are zero-based\n\t   ## this calculation was originally done lower in the code,\n\t   ## but it's clearer to do it just once at the start\n\t   $qs++; $hs++;\n\n\t   my ($aln_len,$inserts,$deletes) = (0,0,0);\n\t   while( @rest >= 2 ) {\n\t       my ($state,$len) = (shift @rest, shift @rest);\n\t       if( $state eq 'I' ) {\n\t\t   $inserts+=$len;\n\t       } elsif( $state eq 'D' ) {\n\t\t   if( $len >= $MIN_INTRON ) {\n\t\t       $self->start_element({'Name' => 'Hsp'});\n\n\t\t       $self->element({'Name' => 'Hsp_score',\n\t\t\t\t       'Data' => $score});\n\t\t       $self->element({'Name' => 'Hsp_align-len',\n\t\t\t\t       'Data' => $aln_len});\n\t\t       $self->element({'Name' => 'Hsp_identity',\n\t\t\t\t       'Data' => $aln_len -\n\t\t\t\t\t   ($inserts + $deletes)});\n\n\t\t       # HSP ends where the other begins\n\t\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t\t       'Data' => $qs});\n\t\t       ## gc note:\n\t\t       ## $qs is now the start of the next hsp\n\t\t       ## the end of this hsp is 1 before this position\n\t\t       ## (or 1 after in case of reverse strand)\n\t\t       $qs += $aln_len*$qstrand;\n\t\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t\t       'Data' => $qs - ($qstrand*1)});\n\n\t\t       $hs += $deletes*$hstrand;\n\t\t       $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t\t       'Data' => $hs});\n\t\t       $hs += $aln_len*$hstrand;\n\t\t       $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t\t       'Data' => $hs-($hstrand*1)});\n\n\t\t       $self->element({'Name' => 'Hsp_align-len',\n\t\t\t\t       'Data' => $aln_len + $inserts\n\t\t\t\t\t   + $deletes});\n\t\t       $self->element({'Name' => 'Hsp_identity',\n\t\t\t\t       'Data' => $aln_len });\n\n\t\t       $self->element({'Name' => 'Hsp_gaps',\n\t\t\t\t       'Data' => $inserts + $deletes});\n\t\t       $self->element({'Name' => 'Hsp_querygaps',\n\t\t\t\t       'Data' => $inserts});\n\t\t       $self->element({'Name' => 'Hsp_hitgaps',\n\t\t\t\t       'Data' => $deletes});\n\n## gc addition start\n\n\t\t       $self->element({'Name' => 'Hsp_qseq',\n\t\t\t\t       'Data' => shift @q_ex,\n\t\t\t\t   });\n\t\t       $self->element({'Name' => 'Hsp_hseq',\n\t\t\t\t       'Data' => shift @h_ex,\n\t\t\t\t   });\n\t\t       $self->element({'Name' => 'Hsp_midline',\n\t\t\t\t       'Data' => shift @m_ex,\n\t\t\t\t   });\n## gc addition end\n\t\t       $self->end_element({'Name' => 'Hsp'});\n\n\t\t       $aln_len = $inserts = $deletes = 0;\n\t\t   }\n\t\t   $deletes+=$len;\n\t       } else {\n\t\t   $aln_len += $len;\n\t       }\n\t   }\n\t   $self->start_element({'Name' => 'Hsp'});\n\n## gc addition start\n\n\t   $self->element({'Name' => 'Hsp_qseq',\n\t\t\t   'Data' => shift @q_ex,\n\t\t       });\n\t   $self->element({'Name' => 'Hsp_hseq',\n\t\t\t   'Data' => shift @h_ex,\n\t\t       });\n\t   $self->element({'Name' => 'Hsp_midline',\n\t\t\t   'Data' => shift @m_ex,\n\t\t       });\n## gc addition end\n\n\t   $self->element({'Name' => 'Hsp_score',\n\t\t\t   'Data' => $score});\n\n\t   $self->element({'Name' => 'Hsp_query-from',\n\t\t\t   'Data' => $qs});\n\n\t   $qs += $aln_len*$qstrand;\n\t   $self->element({'Name' => 'Hsp_query-to',\n\t\t\t   'Data' => $qs - ($qstrand*1)});\n\n\t   $hs += $deletes*$hstrand;\n\t   $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t   'Data' => $hs});\n\t   $hs += $aln_len*$hstrand;\n\t   $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t   'Data' => $hs -($hstrand*1)});\n\n\t   $self->element({'Name' => 'Hsp_align-len',\n\t\t\t   'Data' => $aln_len});\n\n\t   $self->element({'Name' => 'Hsp_identity',\n\t\t\t   'Data' => $aln_len - ($inserts + $deletes)});\n\n\t   $self->element({'Name' => 'Hsp_gaps',\n\t\t\t   'Data' => $inserts + $deletes});\n\n\t   $self->element({'Name' => 'Hsp_querygaps',\n\t\t\t   'Data' => $inserts});\n\t   $self->element({'Name' => 'Hsp_hitgaps',\n\t\t\t   'Data' => $deletes});\n\t   $self->end_element({'Name' => 'Hsp'});\n\n\t   $self->element({'Name' => 'Hit_score',\n\t\t\t   'Data' => $score});\n\n\t   $self->end_element({'Name' => 'Hit'});\n\t   $self->end_element({'Name' => 'ExonerateOutput'});\n\n\t   return $self->end_document();\n       } else {\n\t   # skipping this line\n       }\n   }\n   return $self->end_document() if( $seentop );\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n   # we currently don't care about attributes\n   my $nm = $data->{'Name'};\n   my $type = $MODEMAP{$nm};\n\n   if( $type ) {\n       if( $self->_eventHandler->will_handle($type) ) {\n\t   my $func = sprintf(\"start_%s\",lc $type);\n\t   $self->_eventHandler->$func($data->{'Attributes'});\n       }\n       unshift @{$self->{'_elements'}}, $type;\n       if($type eq 'result') {\n\t   $self->{'_values'} = {};\n\t   $self->{'_result'}= undef;\n       }\n   }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if( $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) {\n\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else {\n\t$self->debug( \"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at\n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string","parameters":[{"label":"$self"},{"label":"$data"}],"label":"characters($self,$data)"}},{"detail":"($self,$name)","definition":"sub","name":"within_element","containerName":"main::","children":[{"line":669,"kind":13,"localvar":"my","containerName":"within_element","name":"$self","definition":"my"},{"name":"$name","kind":13,"containerName":"within_element","line":669},{"line":670,"name":"$name","kind":13,"containerName":"within_element"},{"name":"$self","containerName":"within_element","kind":13,"line":671},{"kind":13,"containerName":"within_element","name":"$self","line":672}],"signature":{"parameters":[{"label":"$self"},{"label":"$name"}],"documentation":"1;\n# $Id: exonerate.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::exonerate\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::exonerate - parser for Exonerate\n\n=head1 SYNOPSIS\n\n  # do not use this module directly, it is a driver for SearchIO\n\n  use Bio::SearchIO;\n  my $searchio = Bio::SearchIO->new(-file => 'file.exonerate',\n                                   -format => 'exonerate');\n\n\n  while( my $r = $searchio->next_result ) {\n    print $r->query_name, \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis is a driver for the SearchIO system for parsing Exonerate (Guy\nSlater) output.  You can get Exonerate at\nhttp://www.ebi.ac.uk/~guy/exonerate/\n[until Guy puts up a Web reference,publication for it.]).\n\nAn optional parameter -min_intron is supported by the L<new>\ninitialization method.  This is if you run Exonerate with a different\nminimum intron length (default is 30) the parser will be able to\ndetect the difference between standard deletions and an intron.  Still\nsome room to play with there that might cause this to get\nmisinterpreted that has not been fully tested or explored.\n\nThe VULGAR and CIGAR formats should be parsed okay now creating HSPs\nwhere appropriate (so merging match states where appropriate rather\nthan breaking an HSP at each indel as it may have done in the past).\nThe GFF that comes from exonerate is still probably a better way to go\nif you are doing protein2genome or est2genome mapping.\nFor example you can see this script:\n\n### TODO: Jason, this link is dead, do we have an updated one?\nhttp://fungal.genome.duke.edu/~jes12/software/scripts/process_exonerate_gff3.perl.txt\n\nIf your report contains both CIGAR and VULGAR lines only the first one\nwill processed for a given Query/Target pair.  If you preferentially\nwant to use VULGAR or CIGAR add one of these options when initializing\nthe SearchIO object.\n\n    -cigar  => 1\nOR\n    -vulgar => 1\n\nOr set them via these methods.\n\n    $parser->cigar(1)\nOR\n    $parser->vulgar(1)\n\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::exonerate;\nuse strict;\nuse vars qw(@STATES %MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $MIN_INTRON);\n\nuse base qw(Bio::SearchIO);\n\n%MODEMAP = ( 'ExonerateOutput' => 'result',\n    'Hit'             => 'hit',\n    'Hsp'             => 'hsp'\n    );\n\n%MAPPING =\n    (\n    'Hsp_query-from'=>  'HSP-query_start',\n    'Hsp_query-to'  =>  'HSP-query_end',\n    'Hsp_hit-from'  =>  'HSP-hit_start',\n    'Hsp_hit-to'    =>  'HSP-hit_end',\n    'Hsp_qseq'      =>  'HSP-query_seq',\n    'Hsp_hseq'      =>  'HSP-hit_seq',\n    'Hsp_midline'   =>  'HSP-homology_seq',\n    'Hsp_score'     =>  'HSP-score',\n    'Hsp_qlength'   =>  'HSP-query_length',\n    'Hsp_hlength'   =>  'HSP-hit_length',\n    'Hsp_align-len' =>  'HSP-hsp_length',\n    'Hsp_identity'  =>  'HSP-identical',\n    'Hsp_gaps'       => 'HSP-hsp_gaps',\n    'Hsp_hitgaps'    => 'HSP-hit_gaps',\n    'Hsp_querygaps'  => 'HSP-query_gaps',\n\n    'Hit_id'        => 'HIT-name',\n    'Hit_desc'      => 'HIT-description',\n    'Hit_len'       => 'HIT-length',\n    'Hit_score'     => 'HIT-score',\n\n    'ExonerateOutput_program'   => 'RESULT-algorithm_name',\n    'ExonerateOutput_query-def' => 'RESULT-query_name',\n    'ExonerateOutput_query-desc'=> 'RESULT-query_description',\n    'ExonerateOutput_query-len' => 'RESULT-query_length',\n    );\n\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n$MIN_INTRON=30; # This is the minimum intron size\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::exonerate->new();\n Function: Builds a new Bio::SearchIO::exonerate object\n Returns : an instance of Bio::SearchIO::exonerate\n Args    : -min_intron => somewhat obselete option, how to determine if a\n                          an indel is an intron or a local gap.  Use VULGAR\n                          rather than CIGAR to avoid this heuristic,default 30.\n           -cigar       => 1   set this to 1 if you want to parse\n                               CIGAR exclusively.\n           -vulgar      => 1   set this to 1 if you want to parse VULGAR\n                               exclusively, setting both to 1 will revert\n                               to the default behavior of just parsing the\n                               first line that it sees.\n\n\nsub new {\n    my ($class) = shift;\n    my $self = $class->SUPER::new(@_);\n\n    my ($min_intron,$cigar,\n\t$vulgar) = $self->_rearrange([qw(MIN_INTRON\n\t\t\t\t\t CIGAR\n\t\t\t\t\t VULGAR)], @_);\n    if( $min_intron ) {\n\t$MIN_INTRON = $min_intron;\n    }\n    if( $cigar && $vulgar ) {\n\t$self->warn(\"cannot get HSPs from both CIGAR and VULGAR lines, will just choose whichever comes first (same as if you had chosen neither\");\n\t$cigar = 0; $vulgar=0;\n    }\n    $self->cigar($cigar);\n    $self->vulgar($vulgar);\n    $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n   my ($self) = @_;\n   local $/ = \"\\n\";\n   local $_;\n\n   $self->{'_last_data'} = '';\n   my ($reporttype,$seenquery,$reportline);\n   $self->start_document();\n   my @hit_signifs;\n   my $seentop;\n   my (@q_ex, @m_ex, @h_ex); ## gc addition\n   while( defined($_ = $self->_readline) ) {\n       # warn( \"Reading $_\");\n       if( /^Query:\\s+(\\S+)\\s*(.+)?/ ) {\n\t   if( $seentop ) {\n\t       $self->end_element({'Name' => 'ExonerateOutput'});\n\t       $self->_pushback($_);\n\t       return $self->end_document();\n\t   }\n\t   $seentop = 1;\n\t   my ($nm,$desc) = ($1,$2);\n\t   chomp($desc) if defined $desc;\n\t   $self->{'_result_count'}++;\n\t   $self->start_element({'Name' => 'ExonerateOutput'});\n\t   $self->element({'Name' => 'ExonerateOutput_query-def',\n\t\t\t   'Data' => $nm });\n\t   $self->element({'Name' => 'ExonerateOutput_query-desc',\n\t\t\t   'Data' => $desc });\n\t   $self->element({'Name' => 'ExonerateOutput_program',\n\t\t\t   'Data' => 'Exonerate' });\n\t   $self->{'_seencigar'} = 0;\n\t   $self->{'_vulgar'}    = 0;\n\n       } elsif ( /^Target:\\s+(\\S+)\\s*(.+)?/ ) {\n\t   my ($nm,$desc) = ($1,$2);\n\t   chomp($desc) if defined $desc;\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $nm});\n\t   $self->element({'Name' => 'Hit_desc',\n\t\t\t   'Data' => $desc});\n\t   $self->{'_seencigar'} = 0;\n\t   $self->{'_vulgar'}    = 0;\n       } elsif(  s/^vulgar:\\s+(\\S+)\\s+         # query sequence id\n\t\t (\\d+)\\s+(\\d+)\\s+([\\-\\+\\.])\\s+ # query start-end-strand\n\t\t (\\S+)\\s+                      # target sequence id\n\t\t (\\d+)\\s+(\\d+)\\s+([\\-\\+])\\s+   # target start-end-strand\n\t\t (\\d+)\\s+                      # score\n\t\t //ox ) {\n\t   next if( $self->cigar || $self->{'_seencigar'});\n\t   $self->{'_vulgar'}++;\n\t   #\n\t   # Note from Ewan. This is ugly - copy and paste from\n\t   # cigar line parsing. Should unify somehow...\n\t   #\n\t   if( ! $self->within_element('result') ) {\n\t       $self->start_element({'Name' => 'ExonerateOutput'});\n\t       $self->element({'Name' => 'ExonerateOutput_query-def',\n\t\t\t       'Data' => $1 });\n\t   }\n\t   if( ! $self->within_element('hit') ) {\n\t       $self->start_element({'Name' => 'Hit'});\n\t       $self->element({'Name' => 'Hit_id',\n\t\t\t       'Data' => $5});\n\t   }\n\n\t   ## gc note:\n\t   ## $qe and $he are no longer used for calculating the ends,\n\t   ## just the $qs and $hs values and the alignment and insert lenghts\n\t   my ($qs,$qe,$qstrand) = ($2,$3,$4);\n\t   my ($hs,$he,$hstrand) = ($6,$7,$8);\n\t   my $score = $9;\n#\t   $self->element({'Name' => 'ExonerateOutput_query-len',\n#\t\t\t   'Data' => $qe});\n#\t   $self->element({'Name' => 'Hit_len',\n#\t\t\t   'Data' => $he});\n\n\t   ## gc note:\n\t   ## add one because these values are zero-based\n\t   ## this calculation was originally done lower in the code,\n\t   ## but it's clearer to do it just once at the start\n\t   my @rest = split;\n\t   my ($qbegin,$qend) = ('query-from', 'query-to');\n\n\t   if( $qstrand eq '-' ) {\n\t       $qstrand = -1; $qe++;\n\t   } else {\n\t       $qstrand = 1;\n\t       $qs++;\n\t   }\n\t   my ($hbegin,$hend) = ('hit-from', 'hit-to');\n\n\t   if( $hstrand eq '-' ) {\n\t       $hstrand = -1;\n\t       $he++;\n\t   } else {\n\t       $hstrand = 1;\n\t       $hs++;\n\t   }\n\t   # okay let's do this right and generate a set of HSPs\n\t   # from the cigar line/home/bio1/jes12/bin/exonerate  --model est2genome --bestn 1 t/data/exonerate_cdna.fa t/data/exonerate_genomic_rev.fa\n\n\t   my ($aln_len,$inserts,$deletes) = (0,0,0);\n\t   my ($laststate,@events,$gaps) =( '' );\n\t   while( @rest >= 3 ) {\n\t       my ($state,$len1,$len2) = (shift @rest, shift @rest, shift @rest);\n\t       #\n\t       # HSPs are only the Match cases; otherwise we just\n\t       # move the coordinates on by the correct amount\n\t       #\n\n\t       if( $state eq 'M' ) {\n\t\t   if( $laststate eq 'G' ) {\n\t\t       # merge gaps across Match states so the HSP\n\t\t       # goes across\n\t\t       $events[-1]->{$qend} = $qs + $len1*$qstrand - $qstrand;\n\t\t       $events[-1]->{$hend}   = $hs + $len2*$hstrand - $hstrand;\n\t\t       $events[-1]->{'gaps'} = $gaps;\n\t\t   } else {\n\t\t       push @events,\n\t\t       { 'score'     => $score,\n\t\t\t 'align-len' => $len1,\n\t\t\t $qbegin => $qs,\n\t\t\t $qend  => ($qs + $len1*$qstrand - $qstrand),\n\t\t\t $hbegin => $hs,\n\t\t\t $hend   => ($hs + $len2*$hstrand - $hstrand),\n\t\t     };\n\t\t   }\n\t\t   $gaps = 0;\n\t       } else {\n\t\t   $gaps = $len1 + $len2 if $state eq 'G';\n\t       }\n\t       $qs += $len1*$qstrand;\n\t       $hs += $len2*$hstrand;\n\t       $laststate= $state;\n\t   }\n\t   for my $event ( @events ) {\n\t       $self->start_element({'Name' => 'Hsp'});\n\t       while( my ($key,$val) = each %$event ) {\n\t\t   $self->element({'Name' => \"Hsp_$key\",\n\t\t\t\t   'Data' => $val});\n\t       }\n\t       $self->element({'Name' => 'Hsp_identity',\n\t\t\t       'Data' => 0});\n\t       $self->end_element({'Name' => 'Hsp'});\n\t   }\n\n\t   # end of hit\n\t   $self->element({'Name' => 'Hit_score',\n\t\t\t   'Data' => $score});\n\t   # issued end...\n\t   $self->end_element({'Name' => 'Hit'});\n\t   $self->end_element({'Name' => 'ExonerateOutput'});\n\n\t   return $self->end_document();\n\n       } elsif(  s/^cigar:\\s+(\\S+)\\s+          # query sequence id\n\t\t (\\d+)\\s+(\\d+)\\s+([\\-\\+])\\s+   # query start-end-strand\n\t\t (\\S+)\\s+                      # target sequence id\n\t\t (\\d+)\\s+(\\d+)\\s+([\\-\\+])\\s+   # target start-end-strand\n\t\t (\\d+)\\s+                      # score\n\t\t //ox ) {\n\t   next if( $self->vulgar || $self->{'_seenvulgar'});\n\t   $self->{'_cigar'}++;\n\n\t   if( ! $self->within_element('result') ) {\n\t       $self->start_element({'Name' => 'ExonerateOutput'});\n\t       $self->element({'Name' => 'ExonerateOutput_query-def',\n\t\t\t       'Data' => $1 });\n\t   }\n\t   if( ! $self->within_element('hit') ) {\n\t       $self->start_element({'Name' => 'Hit'});\n\t       $self->element({'Name' => 'Hit_id',\n\t\t\t       'Data' => $5});\n\t   }\n\t   ## gc note:\n\t   ## $qe and $he are no longer used for calculating the ends,\n\t   ## just the $qs and $hs values and the alignment and insert lenghts\n\t   my ($qs,$qe,$qstrand) = ($2,$3,$4);\n\t   my ($hs,$he,$hstrand) = ($6,$7,$8);\n\t   my $score = $9;\n#\t   $self->element({'Name' => 'ExonerateOutput_query-len',\n#\t\t\t   'Data' => $qe});\n#\t   $self->element({'Name' => 'Hit_len',\n#\t\t\t   'Data' => $he});\n\n\t   my @rest = split;\n\t   if( $qstrand eq '-' ) {\n\t       $qstrand = -1;\n\t       ($qs,$qe) = ($qe,$qs); # flip-flop if we're on opp strand\n\t       $qs--; $qe++;\n\t   } else { $qstrand = 1; }\n\t   if( $hstrand eq '-' ) {\n\t       $hstrand = -1;\n\t       ($hs,$he) = ($he,$hs); # flip-flop if we're on opp strand\n\t       $hs--; $he++;\n\t   } else { $hstrand = 1; }\n\t   # okay let's do this right and generate a set of HSPs\n\t   # from the cigar line\n\n\t   ## gc note:\n\t   ## add one because these values are zero-based\n\t   ## this calculation was originally done lower in the code,\n\t   ## but it's clearer to do it just once at the start\n\t   $qs++; $hs++;\n\n\t   my ($aln_len,$inserts,$deletes) = (0,0,0);\n\t   while( @rest >= 2 ) {\n\t       my ($state,$len) = (shift @rest, shift @rest);\n\t       if( $state eq 'I' ) {\n\t\t   $inserts+=$len;\n\t       } elsif( $state eq 'D' ) {\n\t\t   if( $len >= $MIN_INTRON ) {\n\t\t       $self->start_element({'Name' => 'Hsp'});\n\n\t\t       $self->element({'Name' => 'Hsp_score',\n\t\t\t\t       'Data' => $score});\n\t\t       $self->element({'Name' => 'Hsp_align-len',\n\t\t\t\t       'Data' => $aln_len});\n\t\t       $self->element({'Name' => 'Hsp_identity',\n\t\t\t\t       'Data' => $aln_len -\n\t\t\t\t\t   ($inserts + $deletes)});\n\n\t\t       # HSP ends where the other begins\n\t\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t\t       'Data' => $qs});\n\t\t       ## gc note:\n\t\t       ## $qs is now the start of the next hsp\n\t\t       ## the end of this hsp is 1 before this position\n\t\t       ## (or 1 after in case of reverse strand)\n\t\t       $qs += $aln_len*$qstrand;\n\t\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t\t       'Data' => $qs - ($qstrand*1)});\n\n\t\t       $hs += $deletes*$hstrand;\n\t\t       $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t\t       'Data' => $hs});\n\t\t       $hs += $aln_len*$hstrand;\n\t\t       $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t\t       'Data' => $hs-($hstrand*1)});\n\n\t\t       $self->element({'Name' => 'Hsp_align-len',\n\t\t\t\t       'Data' => $aln_len + $inserts\n\t\t\t\t\t   + $deletes});\n\t\t       $self->element({'Name' => 'Hsp_identity',\n\t\t\t\t       'Data' => $aln_len });\n\n\t\t       $self->element({'Name' => 'Hsp_gaps',\n\t\t\t\t       'Data' => $inserts + $deletes});\n\t\t       $self->element({'Name' => 'Hsp_querygaps',\n\t\t\t\t       'Data' => $inserts});\n\t\t       $self->element({'Name' => 'Hsp_hitgaps',\n\t\t\t\t       'Data' => $deletes});\n\n## gc addition start\n\n\t\t       $self->element({'Name' => 'Hsp_qseq',\n\t\t\t\t       'Data' => shift @q_ex,\n\t\t\t\t   });\n\t\t       $self->element({'Name' => 'Hsp_hseq',\n\t\t\t\t       'Data' => shift @h_ex,\n\t\t\t\t   });\n\t\t       $self->element({'Name' => 'Hsp_midline',\n\t\t\t\t       'Data' => shift @m_ex,\n\t\t\t\t   });\n## gc addition end\n\t\t       $self->end_element({'Name' => 'Hsp'});\n\n\t\t       $aln_len = $inserts = $deletes = 0;\n\t\t   }\n\t\t   $deletes+=$len;\n\t       } else {\n\t\t   $aln_len += $len;\n\t       }\n\t   }\n\t   $self->start_element({'Name' => 'Hsp'});\n\n## gc addition start\n\n\t   $self->element({'Name' => 'Hsp_qseq',\n\t\t\t   'Data' => shift @q_ex,\n\t\t       });\n\t   $self->element({'Name' => 'Hsp_hseq',\n\t\t\t   'Data' => shift @h_ex,\n\t\t       });\n\t   $self->element({'Name' => 'Hsp_midline',\n\t\t\t   'Data' => shift @m_ex,\n\t\t       });\n## gc addition end\n\n\t   $self->element({'Name' => 'Hsp_score',\n\t\t\t   'Data' => $score});\n\n\t   $self->element({'Name' => 'Hsp_query-from',\n\t\t\t   'Data' => $qs});\n\n\t   $qs += $aln_len*$qstrand;\n\t   $self->element({'Name' => 'Hsp_query-to',\n\t\t\t   'Data' => $qs - ($qstrand*1)});\n\n\t   $hs += $deletes*$hstrand;\n\t   $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t   'Data' => $hs});\n\t   $hs += $aln_len*$hstrand;\n\t   $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t   'Data' => $hs -($hstrand*1)});\n\n\t   $self->element({'Name' => 'Hsp_align-len',\n\t\t\t   'Data' => $aln_len});\n\n\t   $self->element({'Name' => 'Hsp_identity',\n\t\t\t   'Data' => $aln_len - ($inserts + $deletes)});\n\n\t   $self->element({'Name' => 'Hsp_gaps',\n\t\t\t   'Data' => $inserts + $deletes});\n\n\t   $self->element({'Name' => 'Hsp_querygaps',\n\t\t\t   'Data' => $inserts});\n\t   $self->element({'Name' => 'Hsp_hitgaps',\n\t\t\t   'Data' => $deletes});\n\t   $self->end_element({'Name' => 'Hsp'});\n\n\t   $self->element({'Name' => 'Hit_score',\n\t\t\t   'Data' => $score});\n\n\t   $self->end_element({'Name' => 'Hit'});\n\t   $self->end_element({'Name' => 'ExonerateOutput'});\n\n\t   return $self->end_document();\n       } else {\n\t   # skipping this line\n       }\n   }\n   return $self->end_document() if( $seentop );\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n   # we currently don't care about attributes\n   my $nm = $data->{'Name'};\n   my $type = $MODEMAP{$nm};\n\n   if( $type ) {\n       if( $self->_eventHandler->will_handle($type) ) {\n\t   my $func = sprintf(\"start_%s\",lc $type);\n\t   $self->_eventHandler->$func($data->{'Attributes'});\n       }\n       unshift @{$self->{'_elements'}}, $type;\n       if($type eq 'result') {\n\t   $self->{'_values'} = {};\n\t   $self->{'_result'}= undef;\n       }\n   }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if( $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) {\n\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else {\n\t$self->debug( \"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at\n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;\n\n   return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/ );\n\n   $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name","label":"within_element($self,$name)"},"range":{"start":{"line":668,"character":0},"end":{"character":9999,"line":672}},"kind":12,"line":668},{"name":"%self","containerName":null,"kind":13,"line":673},{"name":"%name","kind":13,"containerName":null,"line":674},{"definition":"sub","detail":"($self,$name)","children":[{"name":"$self","containerName":"in_element","localvar":"my","kind":13,"line":696,"definition":"my"},{"name":"$name","kind":13,"containerName":"in_element","line":696},{"kind":13,"containerName":"in_element","name":"$self","line":697},{"kind":13,"containerName":"in_element","name":"$self","line":698},{"line":698,"containerName":"in_element","kind":13,"name":"$name"}],"containerName":"main::","name":"in_element","signature":{"parameters":[{"label":"$self"},{"label":"$name"}],"documentation":"1;\n# $Id: exonerate.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::exonerate\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::exonerate - parser for Exonerate\n\n=head1 SYNOPSIS\n\n  # do not use this module directly, it is a driver for SearchIO\n\n  use Bio::SearchIO;\n  my $searchio = Bio::SearchIO->new(-file => 'file.exonerate',\n                                   -format => 'exonerate');\n\n\n  while( my $r = $searchio->next_result ) {\n    print $r->query_name, \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis is a driver for the SearchIO system for parsing Exonerate (Guy\nSlater) output.  You can get Exonerate at\nhttp://www.ebi.ac.uk/~guy/exonerate/\n[until Guy puts up a Web reference,publication for it.]).\n\nAn optional parameter -min_intron is supported by the L<new>\ninitialization method.  This is if you run Exonerate with a different\nminimum intron length (default is 30) the parser will be able to\ndetect the difference between standard deletions and an intron.  Still\nsome room to play with there that might cause this to get\nmisinterpreted that has not been fully tested or explored.\n\nThe VULGAR and CIGAR formats should be parsed okay now creating HSPs\nwhere appropriate (so merging match states where appropriate rather\nthan breaking an HSP at each indel as it may have done in the past).\nThe GFF that comes from exonerate is still probably a better way to go\nif you are doing protein2genome or est2genome mapping.\nFor example you can see this script:\n\n### TODO: Jason, this link is dead, do we have an updated one?\nhttp://fungal.genome.duke.edu/~jes12/software/scripts/process_exonerate_gff3.perl.txt\n\nIf your report contains both CIGAR and VULGAR lines only the first one\nwill processed for a given Query/Target pair.  If you preferentially\nwant to use VULGAR or CIGAR add one of these options when initializing\nthe SearchIO object.\n\n    -cigar  => 1\nOR\n    -vulgar => 1\n\nOr set them via these methods.\n\n    $parser->cigar(1)\nOR\n    $parser->vulgar(1)\n\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::exonerate;\nuse strict;\nuse vars qw(@STATES %MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $MIN_INTRON);\n\nuse base qw(Bio::SearchIO);\n\n%MODEMAP = ( 'ExonerateOutput' => 'result',\n    'Hit'             => 'hit',\n    'Hsp'             => 'hsp'\n    );\n\n%MAPPING =\n    (\n    'Hsp_query-from'=>  'HSP-query_start',\n    'Hsp_query-to'  =>  'HSP-query_end',\n    'Hsp_hit-from'  =>  'HSP-hit_start',\n    'Hsp_hit-to'    =>  'HSP-hit_end',\n    'Hsp_qseq'      =>  'HSP-query_seq',\n    'Hsp_hseq'      =>  'HSP-hit_seq',\n    'Hsp_midline'   =>  'HSP-homology_seq',\n    'Hsp_score'     =>  'HSP-score',\n    'Hsp_qlength'   =>  'HSP-query_length',\n    'Hsp_hlength'   =>  'HSP-hit_length',\n    'Hsp_align-len' =>  'HSP-hsp_length',\n    'Hsp_identity'  =>  'HSP-identical',\n    'Hsp_gaps'       => 'HSP-hsp_gaps',\n    'Hsp_hitgaps'    => 'HSP-hit_gaps',\n    'Hsp_querygaps'  => 'HSP-query_gaps',\n\n    'Hit_id'        => 'HIT-name',\n    'Hit_desc'      => 'HIT-description',\n    'Hit_len'       => 'HIT-length',\n    'Hit_score'     => 'HIT-score',\n\n    'ExonerateOutput_program'   => 'RESULT-algorithm_name',\n    'ExonerateOutput_query-def' => 'RESULT-query_name',\n    'ExonerateOutput_query-desc'=> 'RESULT-query_description',\n    'ExonerateOutput_query-len' => 'RESULT-query_length',\n    );\n\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n$MIN_INTRON=30; # This is the minimum intron size\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::exonerate->new();\n Function: Builds a new Bio::SearchIO::exonerate object\n Returns : an instance of Bio::SearchIO::exonerate\n Args    : -min_intron => somewhat obselete option, how to determine if a\n                          an indel is an intron or a local gap.  Use VULGAR\n                          rather than CIGAR to avoid this heuristic,default 30.\n           -cigar       => 1   set this to 1 if you want to parse\n                               CIGAR exclusively.\n           -vulgar      => 1   set this to 1 if you want to parse VULGAR\n                               exclusively, setting both to 1 will revert\n                               to the default behavior of just parsing the\n                               first line that it sees.\n\n\nsub new {\n    my ($class) = shift;\n    my $self = $class->SUPER::new(@_);\n\n    my ($min_intron,$cigar,\n\t$vulgar) = $self->_rearrange([qw(MIN_INTRON\n\t\t\t\t\t CIGAR\n\t\t\t\t\t VULGAR)], @_);\n    if( $min_intron ) {\n\t$MIN_INTRON = $min_intron;\n    }\n    if( $cigar && $vulgar ) {\n\t$self->warn(\"cannot get HSPs from both CIGAR and VULGAR lines, will just choose whichever comes first (same as if you had chosen neither\");\n\t$cigar = 0; $vulgar=0;\n    }\n    $self->cigar($cigar);\n    $self->vulgar($vulgar);\n    $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n   my ($self) = @_;\n   local $/ = \"\\n\";\n   local $_;\n\n   $self->{'_last_data'} = '';\n   my ($reporttype,$seenquery,$reportline);\n   $self->start_document();\n   my @hit_signifs;\n   my $seentop;\n   my (@q_ex, @m_ex, @h_ex); ## gc addition\n   while( defined($_ = $self->_readline) ) {\n       # warn( \"Reading $_\");\n       if( /^Query:\\s+(\\S+)\\s*(.+)?/ ) {\n\t   if( $seentop ) {\n\t       $self->end_element({'Name' => 'ExonerateOutput'});\n\t       $self->_pushback($_);\n\t       return $self->end_document();\n\t   }\n\t   $seentop = 1;\n\t   my ($nm,$desc) = ($1,$2);\n\t   chomp($desc) if defined $desc;\n\t   $self->{'_result_count'}++;\n\t   $self->start_element({'Name' => 'ExonerateOutput'});\n\t   $self->element({'Name' => 'ExonerateOutput_query-def',\n\t\t\t   'Data' => $nm });\n\t   $self->element({'Name' => 'ExonerateOutput_query-desc',\n\t\t\t   'Data' => $desc });\n\t   $self->element({'Name' => 'ExonerateOutput_program',\n\t\t\t   'Data' => 'Exonerate' });\n\t   $self->{'_seencigar'} = 0;\n\t   $self->{'_vulgar'}    = 0;\n\n       } elsif ( /^Target:\\s+(\\S+)\\s*(.+)?/ ) {\n\t   my ($nm,$desc) = ($1,$2);\n\t   chomp($desc) if defined $desc;\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $nm});\n\t   $self->element({'Name' => 'Hit_desc',\n\t\t\t   'Data' => $desc});\n\t   $self->{'_seencigar'} = 0;\n\t   $self->{'_vulgar'}    = 0;\n       } elsif(  s/^vulgar:\\s+(\\S+)\\s+         # query sequence id\n\t\t (\\d+)\\s+(\\d+)\\s+([\\-\\+\\.])\\s+ # query start-end-strand\n\t\t (\\S+)\\s+                      # target sequence id\n\t\t (\\d+)\\s+(\\d+)\\s+([\\-\\+])\\s+   # target start-end-strand\n\t\t (\\d+)\\s+                      # score\n\t\t //ox ) {\n\t   next if( $self->cigar || $self->{'_seencigar'});\n\t   $self->{'_vulgar'}++;\n\t   #\n\t   # Note from Ewan. This is ugly - copy and paste from\n\t   # cigar line parsing. Should unify somehow...\n\t   #\n\t   if( ! $self->within_element('result') ) {\n\t       $self->start_element({'Name' => 'ExonerateOutput'});\n\t       $self->element({'Name' => 'ExonerateOutput_query-def',\n\t\t\t       'Data' => $1 });\n\t   }\n\t   if( ! $self->within_element('hit') ) {\n\t       $self->start_element({'Name' => 'Hit'});\n\t       $self->element({'Name' => 'Hit_id',\n\t\t\t       'Data' => $5});\n\t   }\n\n\t   ## gc note:\n\t   ## $qe and $he are no longer used for calculating the ends,\n\t   ## just the $qs and $hs values and the alignment and insert lenghts\n\t   my ($qs,$qe,$qstrand) = ($2,$3,$4);\n\t   my ($hs,$he,$hstrand) = ($6,$7,$8);\n\t   my $score = $9;\n#\t   $self->element({'Name' => 'ExonerateOutput_query-len',\n#\t\t\t   'Data' => $qe});\n#\t   $self->element({'Name' => 'Hit_len',\n#\t\t\t   'Data' => $he});\n\n\t   ## gc note:\n\t   ## add one because these values are zero-based\n\t   ## this calculation was originally done lower in the code,\n\t   ## but it's clearer to do it just once at the start\n\t   my @rest = split;\n\t   my ($qbegin,$qend) = ('query-from', 'query-to');\n\n\t   if( $qstrand eq '-' ) {\n\t       $qstrand = -1; $qe++;\n\t   } else {\n\t       $qstrand = 1;\n\t       $qs++;\n\t   }\n\t   my ($hbegin,$hend) = ('hit-from', 'hit-to');\n\n\t   if( $hstrand eq '-' ) {\n\t       $hstrand = -1;\n\t       $he++;\n\t   } else {\n\t       $hstrand = 1;\n\t       $hs++;\n\t   }\n\t   # okay let's do this right and generate a set of HSPs\n\t   # from the cigar line/home/bio1/jes12/bin/exonerate  --model est2genome --bestn 1 t/data/exonerate_cdna.fa t/data/exonerate_genomic_rev.fa\n\n\t   my ($aln_len,$inserts,$deletes) = (0,0,0);\n\t   my ($laststate,@events,$gaps) =( '' );\n\t   while( @rest >= 3 ) {\n\t       my ($state,$len1,$len2) = (shift @rest, shift @rest, shift @rest);\n\t       #\n\t       # HSPs are only the Match cases; otherwise we just\n\t       # move the coordinates on by the correct amount\n\t       #\n\n\t       if( $state eq 'M' ) {\n\t\t   if( $laststate eq 'G' ) {\n\t\t       # merge gaps across Match states so the HSP\n\t\t       # goes across\n\t\t       $events[-1]->{$qend} = $qs + $len1*$qstrand - $qstrand;\n\t\t       $events[-1]->{$hend}   = $hs + $len2*$hstrand - $hstrand;\n\t\t       $events[-1]->{'gaps'} = $gaps;\n\t\t   } else {\n\t\t       push @events,\n\t\t       { 'score'     => $score,\n\t\t\t 'align-len' => $len1,\n\t\t\t $qbegin => $qs,\n\t\t\t $qend  => ($qs + $len1*$qstrand - $qstrand),\n\t\t\t $hbegin => $hs,\n\t\t\t $hend   => ($hs + $len2*$hstrand - $hstrand),\n\t\t     };\n\t\t   }\n\t\t   $gaps = 0;\n\t       } else {\n\t\t   $gaps = $len1 + $len2 if $state eq 'G';\n\t       }\n\t       $qs += $len1*$qstrand;\n\t       $hs += $len2*$hstrand;\n\t       $laststate= $state;\n\t   }\n\t   for my $event ( @events ) {\n\t       $self->start_element({'Name' => 'Hsp'});\n\t       while( my ($key,$val) = each %$event ) {\n\t\t   $self->element({'Name' => \"Hsp_$key\",\n\t\t\t\t   'Data' => $val});\n\t       }\n\t       $self->element({'Name' => 'Hsp_identity',\n\t\t\t       'Data' => 0});\n\t       $self->end_element({'Name' => 'Hsp'});\n\t   }\n\n\t   # end of hit\n\t   $self->element({'Name' => 'Hit_score',\n\t\t\t   'Data' => $score});\n\t   # issued end...\n\t   $self->end_element({'Name' => 'Hit'});\n\t   $self->end_element({'Name' => 'ExonerateOutput'});\n\n\t   return $self->end_document();\n\n       } elsif(  s/^cigar:\\s+(\\S+)\\s+          # query sequence id\n\t\t (\\d+)\\s+(\\d+)\\s+([\\-\\+])\\s+   # query start-end-strand\n\t\t (\\S+)\\s+                      # target sequence id\n\t\t (\\d+)\\s+(\\d+)\\s+([\\-\\+])\\s+   # target start-end-strand\n\t\t (\\d+)\\s+                      # score\n\t\t //ox ) {\n\t   next if( $self->vulgar || $self->{'_seenvulgar'});\n\t   $self->{'_cigar'}++;\n\n\t   if( ! $self->within_element('result') ) {\n\t       $self->start_element({'Name' => 'ExonerateOutput'});\n\t       $self->element({'Name' => 'ExonerateOutput_query-def',\n\t\t\t       'Data' => $1 });\n\t   }\n\t   if( ! $self->within_element('hit') ) {\n\t       $self->start_element({'Name' => 'Hit'});\n\t       $self->element({'Name' => 'Hit_id',\n\t\t\t       'Data' => $5});\n\t   }\n\t   ## gc note:\n\t   ## $qe and $he are no longer used for calculating the ends,\n\t   ## just the $qs and $hs values and the alignment and insert lenghts\n\t   my ($qs,$qe,$qstrand) = ($2,$3,$4);\n\t   my ($hs,$he,$hstrand) = ($6,$7,$8);\n\t   my $score = $9;\n#\t   $self->element({'Name' => 'ExonerateOutput_query-len',\n#\t\t\t   'Data' => $qe});\n#\t   $self->element({'Name' => 'Hit_len',\n#\t\t\t   'Data' => $he});\n\n\t   my @rest = split;\n\t   if( $qstrand eq '-' ) {\n\t       $qstrand = -1;\n\t       ($qs,$qe) = ($qe,$qs); # flip-flop if we're on opp strand\n\t       $qs--; $qe++;\n\t   } else { $qstrand = 1; }\n\t   if( $hstrand eq '-' ) {\n\t       $hstrand = -1;\n\t       ($hs,$he) = ($he,$hs); # flip-flop if we're on opp strand\n\t       $hs--; $he++;\n\t   } else { $hstrand = 1; }\n\t   # okay let's do this right and generate a set of HSPs\n\t   # from the cigar line\n\n\t   ## gc note:\n\t   ## add one because these values are zero-based\n\t   ## this calculation was originally done lower in the code,\n\t   ## but it's clearer to do it just once at the start\n\t   $qs++; $hs++;\n\n\t   my ($aln_len,$inserts,$deletes) = (0,0,0);\n\t   while( @rest >= 2 ) {\n\t       my ($state,$len) = (shift @rest, shift @rest);\n\t       if( $state eq 'I' ) {\n\t\t   $inserts+=$len;\n\t       } elsif( $state eq 'D' ) {\n\t\t   if( $len >= $MIN_INTRON ) {\n\t\t       $self->start_element({'Name' => 'Hsp'});\n\n\t\t       $self->element({'Name' => 'Hsp_score',\n\t\t\t\t       'Data' => $score});\n\t\t       $self->element({'Name' => 'Hsp_align-len',\n\t\t\t\t       'Data' => $aln_len});\n\t\t       $self->element({'Name' => 'Hsp_identity',\n\t\t\t\t       'Data' => $aln_len -\n\t\t\t\t\t   ($inserts + $deletes)});\n\n\t\t       # HSP ends where the other begins\n\t\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t\t       'Data' => $qs});\n\t\t       ## gc note:\n\t\t       ## $qs is now the start of the next hsp\n\t\t       ## the end of this hsp is 1 before this position\n\t\t       ## (or 1 after in case of reverse strand)\n\t\t       $qs += $aln_len*$qstrand;\n\t\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t\t       'Data' => $qs - ($qstrand*1)});\n\n\t\t       $hs += $deletes*$hstrand;\n\t\t       $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t\t       'Data' => $hs});\n\t\t       $hs += $aln_len*$hstrand;\n\t\t       $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t\t       'Data' => $hs-($hstrand*1)});\n\n\t\t       $self->element({'Name' => 'Hsp_align-len',\n\t\t\t\t       'Data' => $aln_len + $inserts\n\t\t\t\t\t   + $deletes});\n\t\t       $self->element({'Name' => 'Hsp_identity',\n\t\t\t\t       'Data' => $aln_len });\n\n\t\t       $self->element({'Name' => 'Hsp_gaps',\n\t\t\t\t       'Data' => $inserts + $deletes});\n\t\t       $self->element({'Name' => 'Hsp_querygaps',\n\t\t\t\t       'Data' => $inserts});\n\t\t       $self->element({'Name' => 'Hsp_hitgaps',\n\t\t\t\t       'Data' => $deletes});\n\n## gc addition start\n\n\t\t       $self->element({'Name' => 'Hsp_qseq',\n\t\t\t\t       'Data' => shift @q_ex,\n\t\t\t\t   });\n\t\t       $self->element({'Name' => 'Hsp_hseq',\n\t\t\t\t       'Data' => shift @h_ex,\n\t\t\t\t   });\n\t\t       $self->element({'Name' => 'Hsp_midline',\n\t\t\t\t       'Data' => shift @m_ex,\n\t\t\t\t   });\n## gc addition end\n\t\t       $self->end_element({'Name' => 'Hsp'});\n\n\t\t       $aln_len = $inserts = $deletes = 0;\n\t\t   }\n\t\t   $deletes+=$len;\n\t       } else {\n\t\t   $aln_len += $len;\n\t       }\n\t   }\n\t   $self->start_element({'Name' => 'Hsp'});\n\n## gc addition start\n\n\t   $self->element({'Name' => 'Hsp_qseq',\n\t\t\t   'Data' => shift @q_ex,\n\t\t       });\n\t   $self->element({'Name' => 'Hsp_hseq',\n\t\t\t   'Data' => shift @h_ex,\n\t\t       });\n\t   $self->element({'Name' => 'Hsp_midline',\n\t\t\t   'Data' => shift @m_ex,\n\t\t       });\n## gc addition end\n\n\t   $self->element({'Name' => 'Hsp_score',\n\t\t\t   'Data' => $score});\n\n\t   $self->element({'Name' => 'Hsp_query-from',\n\t\t\t   'Data' => $qs});\n\n\t   $qs += $aln_len*$qstrand;\n\t   $self->element({'Name' => 'Hsp_query-to',\n\t\t\t   'Data' => $qs - ($qstrand*1)});\n\n\t   $hs += $deletes*$hstrand;\n\t   $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t   'Data' => $hs});\n\t   $hs += $aln_len*$hstrand;\n\t   $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t   'Data' => $hs -($hstrand*1)});\n\n\t   $self->element({'Name' => 'Hsp_align-len',\n\t\t\t   'Data' => $aln_len});\n\n\t   $self->element({'Name' => 'Hsp_identity',\n\t\t\t   'Data' => $aln_len - ($inserts + $deletes)});\n\n\t   $self->element({'Name' => 'Hsp_gaps',\n\t\t\t   'Data' => $inserts + $deletes});\n\n\t   $self->element({'Name' => 'Hsp_querygaps',\n\t\t\t   'Data' => $inserts});\n\t   $self->element({'Name' => 'Hsp_hitgaps',\n\t\t\t   'Data' => $deletes});\n\t   $self->end_element({'Name' => 'Hsp'});\n\n\t   $self->element({'Name' => 'Hit_score',\n\t\t\t   'Data' => $score});\n\n\t   $self->end_element({'Name' => 'Hit'});\n\t   $self->end_element({'Name' => 'ExonerateOutput'});\n\n\t   return $self->end_document();\n       } else {\n\t   # skipping this line\n       }\n   }\n   return $self->end_document() if( $seentop );\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n   # we currently don't care about attributes\n   my $nm = $data->{'Name'};\n   my $type = $MODEMAP{$nm};\n\n   if( $type ) {\n       if( $self->_eventHandler->will_handle($type) ) {\n\t   my $func = sprintf(\"start_%s\",lc $type);\n\t   $self->_eventHandler->$func($data->{'Attributes'});\n       }\n       unshift @{$self->{'_elements'}}, $type;\n       if($type eq 'result') {\n\t   $self->{'_values'} = {};\n\t   $self->{'_result'}= undef;\n       }\n   }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if( $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) {\n\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else {\n\t$self->debug( \"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at\n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;\n\n   return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/ );\n\n   $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name\n\n\n\nsub within_element{\n   my ($self,$name) = @_;\n   return 0 if ( ! defined $name &&\n\t\t ! defined  $self->{'_elements'} ||\n\t\t scalar @{$self->{'_elements'}} == 0) ;\n   foreach (  @{$self->{'_elements'}} ) {\n       if( $_ eq $name  ) {\n\t   return 1;\n       }\n   }\n   return 0;\n}\n\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name","label":"in_element($self,$name)"},"line":695,"kind":12,"range":{"end":{"line":699,"character":9999},"start":{"character":0,"line":695}}},{"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"start_document","line":713,"definition":"my"},{"kind":13,"containerName":"start_document","name":"$self","line":714},{"name":"$self","containerName":"start_document","kind":13,"line":715},{"line":716,"name":"$self","containerName":"start_document","kind":13},{"name":"$self","containerName":"start_document","kind":13,"line":717},{"name":"$self","kind":13,"containerName":"start_document","line":718}],"name":"start_document","containerName":"main::","definition":"sub","detail":"($self)","line":712,"range":{"start":{"character":0,"line":712},"end":{"character":9999,"line":719}},"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: exonerate.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::exonerate\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::exonerate - parser for Exonerate\n\n=head1 SYNOPSIS\n\n  # do not use this module directly, it is a driver for SearchIO\n\n  use Bio::SearchIO;\n  my $searchio = Bio::SearchIO->new(-file => 'file.exonerate',\n                                   -format => 'exonerate');\n\n\n  while( my $r = $searchio->next_result ) {\n    print $r->query_name, \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis is a driver for the SearchIO system for parsing Exonerate (Guy\nSlater) output.  You can get Exonerate at\nhttp://www.ebi.ac.uk/~guy/exonerate/\n[until Guy puts up a Web reference,publication for it.]).\n\nAn optional parameter -min_intron is supported by the L<new>\ninitialization method.  This is if you run Exonerate with a different\nminimum intron length (default is 30) the parser will be able to\ndetect the difference between standard deletions and an intron.  Still\nsome room to play with there that might cause this to get\nmisinterpreted that has not been fully tested or explored.\n\nThe VULGAR and CIGAR formats should be parsed okay now creating HSPs\nwhere appropriate (so merging match states where appropriate rather\nthan breaking an HSP at each indel as it may have done in the past).\nThe GFF that comes from exonerate is still probably a better way to go\nif you are doing protein2genome or est2genome mapping.\nFor example you can see this script:\n\n### TODO: Jason, this link is dead, do we have an updated one?\nhttp://fungal.genome.duke.edu/~jes12/software/scripts/process_exonerate_gff3.perl.txt\n\nIf your report contains both CIGAR and VULGAR lines only the first one\nwill processed for a given Query/Target pair.  If you preferentially\nwant to use VULGAR or CIGAR add one of these options when initializing\nthe SearchIO object.\n\n    -cigar  => 1\nOR\n    -vulgar => 1\n\nOr set them via these methods.\n\n    $parser->cigar(1)\nOR\n    $parser->vulgar(1)\n\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::exonerate;\nuse strict;\nuse vars qw(@STATES %MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $MIN_INTRON);\n\nuse base qw(Bio::SearchIO);\n\n%MODEMAP = ( 'ExonerateOutput' => 'result',\n    'Hit'             => 'hit',\n    'Hsp'             => 'hsp'\n    );\n\n%MAPPING =\n    (\n    'Hsp_query-from'=>  'HSP-query_start',\n    'Hsp_query-to'  =>  'HSP-query_end',\n    'Hsp_hit-from'  =>  'HSP-hit_start',\n    'Hsp_hit-to'    =>  'HSP-hit_end',\n    'Hsp_qseq'      =>  'HSP-query_seq',\n    'Hsp_hseq'      =>  'HSP-hit_seq',\n    'Hsp_midline'   =>  'HSP-homology_seq',\n    'Hsp_score'     =>  'HSP-score',\n    'Hsp_qlength'   =>  'HSP-query_length',\n    'Hsp_hlength'   =>  'HSP-hit_length',\n    'Hsp_align-len' =>  'HSP-hsp_length',\n    'Hsp_identity'  =>  'HSP-identical',\n    'Hsp_gaps'       => 'HSP-hsp_gaps',\n    'Hsp_hitgaps'    => 'HSP-hit_gaps',\n    'Hsp_querygaps'  => 'HSP-query_gaps',\n\n    'Hit_id'        => 'HIT-name',\n    'Hit_desc'      => 'HIT-description',\n    'Hit_len'       => 'HIT-length',\n    'Hit_score'     => 'HIT-score',\n\n    'ExonerateOutput_program'   => 'RESULT-algorithm_name',\n    'ExonerateOutput_query-def' => 'RESULT-query_name',\n    'ExonerateOutput_query-desc'=> 'RESULT-query_description',\n    'ExonerateOutput_query-len' => 'RESULT-query_length',\n    );\n\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n$MIN_INTRON=30; # This is the minimum intron size\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::exonerate->new();\n Function: Builds a new Bio::SearchIO::exonerate object\n Returns : an instance of Bio::SearchIO::exonerate\n Args    : -min_intron => somewhat obselete option, how to determine if a\n                          an indel is an intron or a local gap.  Use VULGAR\n                          rather than CIGAR to avoid this heuristic,default 30.\n           -cigar       => 1   set this to 1 if you want to parse\n                               CIGAR exclusively.\n           -vulgar      => 1   set this to 1 if you want to parse VULGAR\n                               exclusively, setting both to 1 will revert\n                               to the default behavior of just parsing the\n                               first line that it sees.\n\n\nsub new {\n    my ($class) = shift;\n    my $self = $class->SUPER::new(@_);\n\n    my ($min_intron,$cigar,\n\t$vulgar) = $self->_rearrange([qw(MIN_INTRON\n\t\t\t\t\t CIGAR\n\t\t\t\t\t VULGAR)], @_);\n    if( $min_intron ) {\n\t$MIN_INTRON = $min_intron;\n    }\n    if( $cigar && $vulgar ) {\n\t$self->warn(\"cannot get HSPs from both CIGAR and VULGAR lines, will just choose whichever comes first (same as if you had chosen neither\");\n\t$cigar = 0; $vulgar=0;\n    }\n    $self->cigar($cigar);\n    $self->vulgar($vulgar);\n    $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n   my ($self) = @_;\n   local $/ = \"\\n\";\n   local $_;\n\n   $self->{'_last_data'} = '';\n   my ($reporttype,$seenquery,$reportline);\n   $self->start_document();\n   my @hit_signifs;\n   my $seentop;\n   my (@q_ex, @m_ex, @h_ex); ## gc addition\n   while( defined($_ = $self->_readline) ) {\n       # warn( \"Reading $_\");\n       if( /^Query:\\s+(\\S+)\\s*(.+)?/ ) {\n\t   if( $seentop ) {\n\t       $self->end_element({'Name' => 'ExonerateOutput'});\n\t       $self->_pushback($_);\n\t       return $self->end_document();\n\t   }\n\t   $seentop = 1;\n\t   my ($nm,$desc) = ($1,$2);\n\t   chomp($desc) if defined $desc;\n\t   $self->{'_result_count'}++;\n\t   $self->start_element({'Name' => 'ExonerateOutput'});\n\t   $self->element({'Name' => 'ExonerateOutput_query-def',\n\t\t\t   'Data' => $nm });\n\t   $self->element({'Name' => 'ExonerateOutput_query-desc',\n\t\t\t   'Data' => $desc });\n\t   $self->element({'Name' => 'ExonerateOutput_program',\n\t\t\t   'Data' => 'Exonerate' });\n\t   $self->{'_seencigar'} = 0;\n\t   $self->{'_vulgar'}    = 0;\n\n       } elsif ( /^Target:\\s+(\\S+)\\s*(.+)?/ ) {\n\t   my ($nm,$desc) = ($1,$2);\n\t   chomp($desc) if defined $desc;\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $nm});\n\t   $self->element({'Name' => 'Hit_desc',\n\t\t\t   'Data' => $desc});\n\t   $self->{'_seencigar'} = 0;\n\t   $self->{'_vulgar'}    = 0;\n       } elsif(  s/^vulgar:\\s+(\\S+)\\s+         # query sequence id\n\t\t (\\d+)\\s+(\\d+)\\s+([\\-\\+\\.])\\s+ # query start-end-strand\n\t\t (\\S+)\\s+                      # target sequence id\n\t\t (\\d+)\\s+(\\d+)\\s+([\\-\\+])\\s+   # target start-end-strand\n\t\t (\\d+)\\s+                      # score\n\t\t //ox ) {\n\t   next if( $self->cigar || $self->{'_seencigar'});\n\t   $self->{'_vulgar'}++;\n\t   #\n\t   # Note from Ewan. This is ugly - copy and paste from\n\t   # cigar line parsing. Should unify somehow...\n\t   #\n\t   if( ! $self->within_element('result') ) {\n\t       $self->start_element({'Name' => 'ExonerateOutput'});\n\t       $self->element({'Name' => 'ExonerateOutput_query-def',\n\t\t\t       'Data' => $1 });\n\t   }\n\t   if( ! $self->within_element('hit') ) {\n\t       $self->start_element({'Name' => 'Hit'});\n\t       $self->element({'Name' => 'Hit_id',\n\t\t\t       'Data' => $5});\n\t   }\n\n\t   ## gc note:\n\t   ## $qe and $he are no longer used for calculating the ends,\n\t   ## just the $qs and $hs values and the alignment and insert lenghts\n\t   my ($qs,$qe,$qstrand) = ($2,$3,$4);\n\t   my ($hs,$he,$hstrand) = ($6,$7,$8);\n\t   my $score = $9;\n#\t   $self->element({'Name' => 'ExonerateOutput_query-len',\n#\t\t\t   'Data' => $qe});\n#\t   $self->element({'Name' => 'Hit_len',\n#\t\t\t   'Data' => $he});\n\n\t   ## gc note:\n\t   ## add one because these values are zero-based\n\t   ## this calculation was originally done lower in the code,\n\t   ## but it's clearer to do it just once at the start\n\t   my @rest = split;\n\t   my ($qbegin,$qend) = ('query-from', 'query-to');\n\n\t   if( $qstrand eq '-' ) {\n\t       $qstrand = -1; $qe++;\n\t   } else {\n\t       $qstrand = 1;\n\t       $qs++;\n\t   }\n\t   my ($hbegin,$hend) = ('hit-from', 'hit-to');\n\n\t   if( $hstrand eq '-' ) {\n\t       $hstrand = -1;\n\t       $he++;\n\t   } else {\n\t       $hstrand = 1;\n\t       $hs++;\n\t   }\n\t   # okay let's do this right and generate a set of HSPs\n\t   # from the cigar line/home/bio1/jes12/bin/exonerate  --model est2genome --bestn 1 t/data/exonerate_cdna.fa t/data/exonerate_genomic_rev.fa\n\n\t   my ($aln_len,$inserts,$deletes) = (0,0,0);\n\t   my ($laststate,@events,$gaps) =( '' );\n\t   while( @rest >= 3 ) {\n\t       my ($state,$len1,$len2) = (shift @rest, shift @rest, shift @rest);\n\t       #\n\t       # HSPs are only the Match cases; otherwise we just\n\t       # move the coordinates on by the correct amount\n\t       #\n\n\t       if( $state eq 'M' ) {\n\t\t   if( $laststate eq 'G' ) {\n\t\t       # merge gaps across Match states so the HSP\n\t\t       # goes across\n\t\t       $events[-1]->{$qend} = $qs + $len1*$qstrand - $qstrand;\n\t\t       $events[-1]->{$hend}   = $hs + $len2*$hstrand - $hstrand;\n\t\t       $events[-1]->{'gaps'} = $gaps;\n\t\t   } else {\n\t\t       push @events,\n\t\t       { 'score'     => $score,\n\t\t\t 'align-len' => $len1,\n\t\t\t $qbegin => $qs,\n\t\t\t $qend  => ($qs + $len1*$qstrand - $qstrand),\n\t\t\t $hbegin => $hs,\n\t\t\t $hend   => ($hs + $len2*$hstrand - $hstrand),\n\t\t     };\n\t\t   }\n\t\t   $gaps = 0;\n\t       } else {\n\t\t   $gaps = $len1 + $len2 if $state eq 'G';\n\t       }\n\t       $qs += $len1*$qstrand;\n\t       $hs += $len2*$hstrand;\n\t       $laststate= $state;\n\t   }\n\t   for my $event ( @events ) {\n\t       $self->start_element({'Name' => 'Hsp'});\n\t       while( my ($key,$val) = each %$event ) {\n\t\t   $self->element({'Name' => \"Hsp_$key\",\n\t\t\t\t   'Data' => $val});\n\t       }\n\t       $self->element({'Name' => 'Hsp_identity',\n\t\t\t       'Data' => 0});\n\t       $self->end_element({'Name' => 'Hsp'});\n\t   }\n\n\t   # end of hit\n\t   $self->element({'Name' => 'Hit_score',\n\t\t\t   'Data' => $score});\n\t   # issued end...\n\t   $self->end_element({'Name' => 'Hit'});\n\t   $self->end_element({'Name' => 'ExonerateOutput'});\n\n\t   return $self->end_document();\n\n       } elsif(  s/^cigar:\\s+(\\S+)\\s+          # query sequence id\n\t\t (\\d+)\\s+(\\d+)\\s+([\\-\\+])\\s+   # query start-end-strand\n\t\t (\\S+)\\s+                      # target sequence id\n\t\t (\\d+)\\s+(\\d+)\\s+([\\-\\+])\\s+   # target start-end-strand\n\t\t (\\d+)\\s+                      # score\n\t\t //ox ) {\n\t   next if( $self->vulgar || $self->{'_seenvulgar'});\n\t   $self->{'_cigar'}++;\n\n\t   if( ! $self->within_element('result') ) {\n\t       $self->start_element({'Name' => 'ExonerateOutput'});\n\t       $self->element({'Name' => 'ExonerateOutput_query-def',\n\t\t\t       'Data' => $1 });\n\t   }\n\t   if( ! $self->within_element('hit') ) {\n\t       $self->start_element({'Name' => 'Hit'});\n\t       $self->element({'Name' => 'Hit_id',\n\t\t\t       'Data' => $5});\n\t   }\n\t   ## gc note:\n\t   ## $qe and $he are no longer used for calculating the ends,\n\t   ## just the $qs and $hs values and the alignment and insert lenghts\n\t   my ($qs,$qe,$qstrand) = ($2,$3,$4);\n\t   my ($hs,$he,$hstrand) = ($6,$7,$8);\n\t   my $score = $9;\n#\t   $self->element({'Name' => 'ExonerateOutput_query-len',\n#\t\t\t   'Data' => $qe});\n#\t   $self->element({'Name' => 'Hit_len',\n#\t\t\t   'Data' => $he});\n\n\t   my @rest = split;\n\t   if( $qstrand eq '-' ) {\n\t       $qstrand = -1;\n\t       ($qs,$qe) = ($qe,$qs); # flip-flop if we're on opp strand\n\t       $qs--; $qe++;\n\t   } else { $qstrand = 1; }\n\t   if( $hstrand eq '-' ) {\n\t       $hstrand = -1;\n\t       ($hs,$he) = ($he,$hs); # flip-flop if we're on opp strand\n\t       $hs--; $he++;\n\t   } else { $hstrand = 1; }\n\t   # okay let's do this right and generate a set of HSPs\n\t   # from the cigar line\n\n\t   ## gc note:\n\t   ## add one because these values are zero-based\n\t   ## this calculation was originally done lower in the code,\n\t   ## but it's clearer to do it just once at the start\n\t   $qs++; $hs++;\n\n\t   my ($aln_len,$inserts,$deletes) = (0,0,0);\n\t   while( @rest >= 2 ) {\n\t       my ($state,$len) = (shift @rest, shift @rest);\n\t       if( $state eq 'I' ) {\n\t\t   $inserts+=$len;\n\t       } elsif( $state eq 'D' ) {\n\t\t   if( $len >= $MIN_INTRON ) {\n\t\t       $self->start_element({'Name' => 'Hsp'});\n\n\t\t       $self->element({'Name' => 'Hsp_score',\n\t\t\t\t       'Data' => $score});\n\t\t       $self->element({'Name' => 'Hsp_align-len',\n\t\t\t\t       'Data' => $aln_len});\n\t\t       $self->element({'Name' => 'Hsp_identity',\n\t\t\t\t       'Data' => $aln_len -\n\t\t\t\t\t   ($inserts + $deletes)});\n\n\t\t       # HSP ends where the other begins\n\t\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t\t       'Data' => $qs});\n\t\t       ## gc note:\n\t\t       ## $qs is now the start of the next hsp\n\t\t       ## the end of this hsp is 1 before this position\n\t\t       ## (or 1 after in case of reverse strand)\n\t\t       $qs += $aln_len*$qstrand;\n\t\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t\t       'Data' => $qs - ($qstrand*1)});\n\n\t\t       $hs += $deletes*$hstrand;\n\t\t       $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t\t       'Data' => $hs});\n\t\t       $hs += $aln_len*$hstrand;\n\t\t       $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t\t       'Data' => $hs-($hstrand*1)});\n\n\t\t       $self->element({'Name' => 'Hsp_align-len',\n\t\t\t\t       'Data' => $aln_len + $inserts\n\t\t\t\t\t   + $deletes});\n\t\t       $self->element({'Name' => 'Hsp_identity',\n\t\t\t\t       'Data' => $aln_len });\n\n\t\t       $self->element({'Name' => 'Hsp_gaps',\n\t\t\t\t       'Data' => $inserts + $deletes});\n\t\t       $self->element({'Name' => 'Hsp_querygaps',\n\t\t\t\t       'Data' => $inserts});\n\t\t       $self->element({'Name' => 'Hsp_hitgaps',\n\t\t\t\t       'Data' => $deletes});\n\n## gc addition start\n\n\t\t       $self->element({'Name' => 'Hsp_qseq',\n\t\t\t\t       'Data' => shift @q_ex,\n\t\t\t\t   });\n\t\t       $self->element({'Name' => 'Hsp_hseq',\n\t\t\t\t       'Data' => shift @h_ex,\n\t\t\t\t   });\n\t\t       $self->element({'Name' => 'Hsp_midline',\n\t\t\t\t       'Data' => shift @m_ex,\n\t\t\t\t   });\n## gc addition end\n\t\t       $self->end_element({'Name' => 'Hsp'});\n\n\t\t       $aln_len = $inserts = $deletes = 0;\n\t\t   }\n\t\t   $deletes+=$len;\n\t       } else {\n\t\t   $aln_len += $len;\n\t       }\n\t   }\n\t   $self->start_element({'Name' => 'Hsp'});\n\n## gc addition start\n\n\t   $self->element({'Name' => 'Hsp_qseq',\n\t\t\t   'Data' => shift @q_ex,\n\t\t       });\n\t   $self->element({'Name' => 'Hsp_hseq',\n\t\t\t   'Data' => shift @h_ex,\n\t\t       });\n\t   $self->element({'Name' => 'Hsp_midline',\n\t\t\t   'Data' => shift @m_ex,\n\t\t       });\n## gc addition end\n\n\t   $self->element({'Name' => 'Hsp_score',\n\t\t\t   'Data' => $score});\n\n\t   $self->element({'Name' => 'Hsp_query-from',\n\t\t\t   'Data' => $qs});\n\n\t   $qs += $aln_len*$qstrand;\n\t   $self->element({'Name' => 'Hsp_query-to',\n\t\t\t   'Data' => $qs - ($qstrand*1)});\n\n\t   $hs += $deletes*$hstrand;\n\t   $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t   'Data' => $hs});\n\t   $hs += $aln_len*$hstrand;\n\t   $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t   'Data' => $hs -($hstrand*1)});\n\n\t   $self->element({'Name' => 'Hsp_align-len',\n\t\t\t   'Data' => $aln_len});\n\n\t   $self->element({'Name' => 'Hsp_identity',\n\t\t\t   'Data' => $aln_len - ($inserts + $deletes)});\n\n\t   $self->element({'Name' => 'Hsp_gaps',\n\t\t\t   'Data' => $inserts + $deletes});\n\n\t   $self->element({'Name' => 'Hsp_querygaps',\n\t\t\t   'Data' => $inserts});\n\t   $self->element({'Name' => 'Hsp_hitgaps',\n\t\t\t   'Data' => $deletes});\n\t   $self->end_element({'Name' => 'Hsp'});\n\n\t   $self->element({'Name' => 'Hit_score',\n\t\t\t   'Data' => $score});\n\n\t   $self->end_element({'Name' => 'Hit'});\n\t   $self->end_element({'Name' => 'ExonerateOutput'});\n\n\t   return $self->end_document();\n       } else {\n\t   # skipping this line\n       }\n   }\n   return $self->end_document() if( $seentop );\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n   # we currently don't care about attributes\n   my $nm = $data->{'Name'};\n   my $type = $MODEMAP{$nm};\n\n   if( $type ) {\n       if( $self->_eventHandler->will_handle($type) ) {\n\t   my $func = sprintf(\"start_%s\",lc $type);\n\t   $self->_eventHandler->$func($data->{'Attributes'});\n       }\n       unshift @{$self->{'_elements'}}, $type;\n       if($type eq 'result') {\n\t   $self->{'_values'} = {};\n\t   $self->{'_result'}= undef;\n       }\n   }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if( $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) {\n\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else {\n\t$self->debug( \"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at\n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;\n\n   return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/ );\n\n   $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name\n\n\n\nsub within_element{\n   my ($self,$name) = @_;\n   return 0 if ( ! defined $name &&\n\t\t ! defined  $self->{'_elements'} ||\n\t\t scalar @{$self->{'_elements'}} == 0) ;\n   foreach (  @{$self->{'_elements'}} ) {\n       if( $_ eq $name  ) {\n\t   return 1;\n       }\n   }\n   return 0;\n}\n\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name\n\n\n\nsub in_element{\n   my ($self,$name) = @_;\n   return 0 if ! defined $self->{'_elements'}->[0];\n   return ( $self->{'_elements'}->[0] eq $name)\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handle a start document event\n Returns : none\n Args    : none","label":"start_document($self)"}},{"signature":{"label":"end_document($self,@args)","documentation":"1;\n# $Id: exonerate.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::exonerate\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::exonerate - parser for Exonerate\n\n=head1 SYNOPSIS\n\n  # do not use this module directly, it is a driver for SearchIO\n\n  use Bio::SearchIO;\n  my $searchio = Bio::SearchIO->new(-file => 'file.exonerate',\n                                   -format => 'exonerate');\n\n\n  while( my $r = $searchio->next_result ) {\n    print $r->query_name, \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis is a driver for the SearchIO system for parsing Exonerate (Guy\nSlater) output.  You can get Exonerate at\nhttp://www.ebi.ac.uk/~guy/exonerate/\n[until Guy puts up a Web reference,publication for it.]).\n\nAn optional parameter -min_intron is supported by the L<new>\ninitialization method.  This is if you run Exonerate with a different\nminimum intron length (default is 30) the parser will be able to\ndetect the difference between standard deletions and an intron.  Still\nsome room to play with there that might cause this to get\nmisinterpreted that has not been fully tested or explored.\n\nThe VULGAR and CIGAR formats should be parsed okay now creating HSPs\nwhere appropriate (so merging match states where appropriate rather\nthan breaking an HSP at each indel as it may have done in the past).\nThe GFF that comes from exonerate is still probably a better way to go\nif you are doing protein2genome or est2genome mapping.\nFor example you can see this script:\n\n### TODO: Jason, this link is dead, do we have an updated one?\nhttp://fungal.genome.duke.edu/~jes12/software/scripts/process_exonerate_gff3.perl.txt\n\nIf your report contains both CIGAR and VULGAR lines only the first one\nwill processed for a given Query/Target pair.  If you preferentially\nwant to use VULGAR or CIGAR add one of these options when initializing\nthe SearchIO object.\n\n    -cigar  => 1\nOR\n    -vulgar => 1\n\nOr set them via these methods.\n\n    $parser->cigar(1)\nOR\n    $parser->vulgar(1)\n\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::exonerate;\nuse strict;\nuse vars qw(@STATES %MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $MIN_INTRON);\n\nuse base qw(Bio::SearchIO);\n\n%MODEMAP = ( 'ExonerateOutput' => 'result',\n    'Hit'             => 'hit',\n    'Hsp'             => 'hsp'\n    );\n\n%MAPPING =\n    (\n    'Hsp_query-from'=>  'HSP-query_start',\n    'Hsp_query-to'  =>  'HSP-query_end',\n    'Hsp_hit-from'  =>  'HSP-hit_start',\n    'Hsp_hit-to'    =>  'HSP-hit_end',\n    'Hsp_qseq'      =>  'HSP-query_seq',\n    'Hsp_hseq'      =>  'HSP-hit_seq',\n    'Hsp_midline'   =>  'HSP-homology_seq',\n    'Hsp_score'     =>  'HSP-score',\n    'Hsp_qlength'   =>  'HSP-query_length',\n    'Hsp_hlength'   =>  'HSP-hit_length',\n    'Hsp_align-len' =>  'HSP-hsp_length',\n    'Hsp_identity'  =>  'HSP-identical',\n    'Hsp_gaps'       => 'HSP-hsp_gaps',\n    'Hsp_hitgaps'    => 'HSP-hit_gaps',\n    'Hsp_querygaps'  => 'HSP-query_gaps',\n\n    'Hit_id'        => 'HIT-name',\n    'Hit_desc'      => 'HIT-description',\n    'Hit_len'       => 'HIT-length',\n    'Hit_score'     => 'HIT-score',\n\n    'ExonerateOutput_program'   => 'RESULT-algorithm_name',\n    'ExonerateOutput_query-def' => 'RESULT-query_name',\n    'ExonerateOutput_query-desc'=> 'RESULT-query_description',\n    'ExonerateOutput_query-len' => 'RESULT-query_length',\n    );\n\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n$MIN_INTRON=30; # This is the minimum intron size\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::exonerate->new();\n Function: Builds a new Bio::SearchIO::exonerate object\n Returns : an instance of Bio::SearchIO::exonerate\n Args    : -min_intron => somewhat obselete option, how to determine if a\n                          an indel is an intron or a local gap.  Use VULGAR\n                          rather than CIGAR to avoid this heuristic,default 30.\n           -cigar       => 1   set this to 1 if you want to parse\n                               CIGAR exclusively.\n           -vulgar      => 1   set this to 1 if you want to parse VULGAR\n                               exclusively, setting both to 1 will revert\n                               to the default behavior of just parsing the\n                               first line that it sees.\n\n\nsub new {\n    my ($class) = shift;\n    my $self = $class->SUPER::new(@_);\n\n    my ($min_intron,$cigar,\n\t$vulgar) = $self->_rearrange([qw(MIN_INTRON\n\t\t\t\t\t CIGAR\n\t\t\t\t\t VULGAR)], @_);\n    if( $min_intron ) {\n\t$MIN_INTRON = $min_intron;\n    }\n    if( $cigar && $vulgar ) {\n\t$self->warn(\"cannot get HSPs from both CIGAR and VULGAR lines, will just choose whichever comes first (same as if you had chosen neither\");\n\t$cigar = 0; $vulgar=0;\n    }\n    $self->cigar($cigar);\n    $self->vulgar($vulgar);\n    $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n   my ($self) = @_;\n   local $/ = \"\\n\";\n   local $_;\n\n   $self->{'_last_data'} = '';\n   my ($reporttype,$seenquery,$reportline);\n   $self->start_document();\n   my @hit_signifs;\n   my $seentop;\n   my (@q_ex, @m_ex, @h_ex); ## gc addition\n   while( defined($_ = $self->_readline) ) {\n       # warn( \"Reading $_\");\n       if( /^Query:\\s+(\\S+)\\s*(.+)?/ ) {\n\t   if( $seentop ) {\n\t       $self->end_element({'Name' => 'ExonerateOutput'});\n\t       $self->_pushback($_);\n\t       return $self->end_document();\n\t   }\n\t   $seentop = 1;\n\t   my ($nm,$desc) = ($1,$2);\n\t   chomp($desc) if defined $desc;\n\t   $self->{'_result_count'}++;\n\t   $self->start_element({'Name' => 'ExonerateOutput'});\n\t   $self->element({'Name' => 'ExonerateOutput_query-def',\n\t\t\t   'Data' => $nm });\n\t   $self->element({'Name' => 'ExonerateOutput_query-desc',\n\t\t\t   'Data' => $desc });\n\t   $self->element({'Name' => 'ExonerateOutput_program',\n\t\t\t   'Data' => 'Exonerate' });\n\t   $self->{'_seencigar'} = 0;\n\t   $self->{'_vulgar'}    = 0;\n\n       } elsif ( /^Target:\\s+(\\S+)\\s*(.+)?/ ) {\n\t   my ($nm,$desc) = ($1,$2);\n\t   chomp($desc) if defined $desc;\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $nm});\n\t   $self->element({'Name' => 'Hit_desc',\n\t\t\t   'Data' => $desc});\n\t   $self->{'_seencigar'} = 0;\n\t   $self->{'_vulgar'}    = 0;\n       } elsif(  s/^vulgar:\\s+(\\S+)\\s+         # query sequence id\n\t\t (\\d+)\\s+(\\d+)\\s+([\\-\\+\\.])\\s+ # query start-end-strand\n\t\t (\\S+)\\s+                      # target sequence id\n\t\t (\\d+)\\s+(\\d+)\\s+([\\-\\+])\\s+   # target start-end-strand\n\t\t (\\d+)\\s+                      # score\n\t\t //ox ) {\n\t   next if( $self->cigar || $self->{'_seencigar'});\n\t   $self->{'_vulgar'}++;\n\t   #\n\t   # Note from Ewan. This is ugly - copy and paste from\n\t   # cigar line parsing. Should unify somehow...\n\t   #\n\t   if( ! $self->within_element('result') ) {\n\t       $self->start_element({'Name' => 'ExonerateOutput'});\n\t       $self->element({'Name' => 'ExonerateOutput_query-def',\n\t\t\t       'Data' => $1 });\n\t   }\n\t   if( ! $self->within_element('hit') ) {\n\t       $self->start_element({'Name' => 'Hit'});\n\t       $self->element({'Name' => 'Hit_id',\n\t\t\t       'Data' => $5});\n\t   }\n\n\t   ## gc note:\n\t   ## $qe and $he are no longer used for calculating the ends,\n\t   ## just the $qs and $hs values and the alignment and insert lenghts\n\t   my ($qs,$qe,$qstrand) = ($2,$3,$4);\n\t   my ($hs,$he,$hstrand) = ($6,$7,$8);\n\t   my $score = $9;\n#\t   $self->element({'Name' => 'ExonerateOutput_query-len',\n#\t\t\t   'Data' => $qe});\n#\t   $self->element({'Name' => 'Hit_len',\n#\t\t\t   'Data' => $he});\n\n\t   ## gc note:\n\t   ## add one because these values are zero-based\n\t   ## this calculation was originally done lower in the code,\n\t   ## but it's clearer to do it just once at the start\n\t   my @rest = split;\n\t   my ($qbegin,$qend) = ('query-from', 'query-to');\n\n\t   if( $qstrand eq '-' ) {\n\t       $qstrand = -1; $qe++;\n\t   } else {\n\t       $qstrand = 1;\n\t       $qs++;\n\t   }\n\t   my ($hbegin,$hend) = ('hit-from', 'hit-to');\n\n\t   if( $hstrand eq '-' ) {\n\t       $hstrand = -1;\n\t       $he++;\n\t   } else {\n\t       $hstrand = 1;\n\t       $hs++;\n\t   }\n\t   # okay let's do this right and generate a set of HSPs\n\t   # from the cigar line/home/bio1/jes12/bin/exonerate  --model est2genome --bestn 1 t/data/exonerate_cdna.fa t/data/exonerate_genomic_rev.fa\n\n\t   my ($aln_len,$inserts,$deletes) = (0,0,0);\n\t   my ($laststate,@events,$gaps) =( '' );\n\t   while( @rest >= 3 ) {\n\t       my ($state,$len1,$len2) = (shift @rest, shift @rest, shift @rest);\n\t       #\n\t       # HSPs are only the Match cases; otherwise we just\n\t       # move the coordinates on by the correct amount\n\t       #\n\n\t       if( $state eq 'M' ) {\n\t\t   if( $laststate eq 'G' ) {\n\t\t       # merge gaps across Match states so the HSP\n\t\t       # goes across\n\t\t       $events[-1]->{$qend} = $qs + $len1*$qstrand - $qstrand;\n\t\t       $events[-1]->{$hend}   = $hs + $len2*$hstrand - $hstrand;\n\t\t       $events[-1]->{'gaps'} = $gaps;\n\t\t   } else {\n\t\t       push @events,\n\t\t       { 'score'     => $score,\n\t\t\t 'align-len' => $len1,\n\t\t\t $qbegin => $qs,\n\t\t\t $qend  => ($qs + $len1*$qstrand - $qstrand),\n\t\t\t $hbegin => $hs,\n\t\t\t $hend   => ($hs + $len2*$hstrand - $hstrand),\n\t\t     };\n\t\t   }\n\t\t   $gaps = 0;\n\t       } else {\n\t\t   $gaps = $len1 + $len2 if $state eq 'G';\n\t       }\n\t       $qs += $len1*$qstrand;\n\t       $hs += $len2*$hstrand;\n\t       $laststate= $state;\n\t   }\n\t   for my $event ( @events ) {\n\t       $self->start_element({'Name' => 'Hsp'});\n\t       while( my ($key,$val) = each %$event ) {\n\t\t   $self->element({'Name' => \"Hsp_$key\",\n\t\t\t\t   'Data' => $val});\n\t       }\n\t       $self->element({'Name' => 'Hsp_identity',\n\t\t\t       'Data' => 0});\n\t       $self->end_element({'Name' => 'Hsp'});\n\t   }\n\n\t   # end of hit\n\t   $self->element({'Name' => 'Hit_score',\n\t\t\t   'Data' => $score});\n\t   # issued end...\n\t   $self->end_element({'Name' => 'Hit'});\n\t   $self->end_element({'Name' => 'ExonerateOutput'});\n\n\t   return $self->end_document();\n\n       } elsif(  s/^cigar:\\s+(\\S+)\\s+          # query sequence id\n\t\t (\\d+)\\s+(\\d+)\\s+([\\-\\+])\\s+   # query start-end-strand\n\t\t (\\S+)\\s+                      # target sequence id\n\t\t (\\d+)\\s+(\\d+)\\s+([\\-\\+])\\s+   # target start-end-strand\n\t\t (\\d+)\\s+                      # score\n\t\t //ox ) {\n\t   next if( $self->vulgar || $self->{'_seenvulgar'});\n\t   $self->{'_cigar'}++;\n\n\t   if( ! $self->within_element('result') ) {\n\t       $self->start_element({'Name' => 'ExonerateOutput'});\n\t       $self->element({'Name' => 'ExonerateOutput_query-def',\n\t\t\t       'Data' => $1 });\n\t   }\n\t   if( ! $self->within_element('hit') ) {\n\t       $self->start_element({'Name' => 'Hit'});\n\t       $self->element({'Name' => 'Hit_id',\n\t\t\t       'Data' => $5});\n\t   }\n\t   ## gc note:\n\t   ## $qe and $he are no longer used for calculating the ends,\n\t   ## just the $qs and $hs values and the alignment and insert lenghts\n\t   my ($qs,$qe,$qstrand) = ($2,$3,$4);\n\t   my ($hs,$he,$hstrand) = ($6,$7,$8);\n\t   my $score = $9;\n#\t   $self->element({'Name' => 'ExonerateOutput_query-len',\n#\t\t\t   'Data' => $qe});\n#\t   $self->element({'Name' => 'Hit_len',\n#\t\t\t   'Data' => $he});\n\n\t   my @rest = split;\n\t   if( $qstrand eq '-' ) {\n\t       $qstrand = -1;\n\t       ($qs,$qe) = ($qe,$qs); # flip-flop if we're on opp strand\n\t       $qs--; $qe++;\n\t   } else { $qstrand = 1; }\n\t   if( $hstrand eq '-' ) {\n\t       $hstrand = -1;\n\t       ($hs,$he) = ($he,$hs); # flip-flop if we're on opp strand\n\t       $hs--; $he++;\n\t   } else { $hstrand = 1; }\n\t   # okay let's do this right and generate a set of HSPs\n\t   # from the cigar line\n\n\t   ## gc note:\n\t   ## add one because these values are zero-based\n\t   ## this calculation was originally done lower in the code,\n\t   ## but it's clearer to do it just once at the start\n\t   $qs++; $hs++;\n\n\t   my ($aln_len,$inserts,$deletes) = (0,0,0);\n\t   while( @rest >= 2 ) {\n\t       my ($state,$len) = (shift @rest, shift @rest);\n\t       if( $state eq 'I' ) {\n\t\t   $inserts+=$len;\n\t       } elsif( $state eq 'D' ) {\n\t\t   if( $len >= $MIN_INTRON ) {\n\t\t       $self->start_element({'Name' => 'Hsp'});\n\n\t\t       $self->element({'Name' => 'Hsp_score',\n\t\t\t\t       'Data' => $score});\n\t\t       $self->element({'Name' => 'Hsp_align-len',\n\t\t\t\t       'Data' => $aln_len});\n\t\t       $self->element({'Name' => 'Hsp_identity',\n\t\t\t\t       'Data' => $aln_len -\n\t\t\t\t\t   ($inserts + $deletes)});\n\n\t\t       # HSP ends where the other begins\n\t\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t\t       'Data' => $qs});\n\t\t       ## gc note:\n\t\t       ## $qs is now the start of the next hsp\n\t\t       ## the end of this hsp is 1 before this position\n\t\t       ## (or 1 after in case of reverse strand)\n\t\t       $qs += $aln_len*$qstrand;\n\t\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t\t       'Data' => $qs - ($qstrand*1)});\n\n\t\t       $hs += $deletes*$hstrand;\n\t\t       $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t\t       'Data' => $hs});\n\t\t       $hs += $aln_len*$hstrand;\n\t\t       $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t\t       'Data' => $hs-($hstrand*1)});\n\n\t\t       $self->element({'Name' => 'Hsp_align-len',\n\t\t\t\t       'Data' => $aln_len + $inserts\n\t\t\t\t\t   + $deletes});\n\t\t       $self->element({'Name' => 'Hsp_identity',\n\t\t\t\t       'Data' => $aln_len });\n\n\t\t       $self->element({'Name' => 'Hsp_gaps',\n\t\t\t\t       'Data' => $inserts + $deletes});\n\t\t       $self->element({'Name' => 'Hsp_querygaps',\n\t\t\t\t       'Data' => $inserts});\n\t\t       $self->element({'Name' => 'Hsp_hitgaps',\n\t\t\t\t       'Data' => $deletes});\n\n## gc addition start\n\n\t\t       $self->element({'Name' => 'Hsp_qseq',\n\t\t\t\t       'Data' => shift @q_ex,\n\t\t\t\t   });\n\t\t       $self->element({'Name' => 'Hsp_hseq',\n\t\t\t\t       'Data' => shift @h_ex,\n\t\t\t\t   });\n\t\t       $self->element({'Name' => 'Hsp_midline',\n\t\t\t\t       'Data' => shift @m_ex,\n\t\t\t\t   });\n## gc addition end\n\t\t       $self->end_element({'Name' => 'Hsp'});\n\n\t\t       $aln_len = $inserts = $deletes = 0;\n\t\t   }\n\t\t   $deletes+=$len;\n\t       } else {\n\t\t   $aln_len += $len;\n\t       }\n\t   }\n\t   $self->start_element({'Name' => 'Hsp'});\n\n## gc addition start\n\n\t   $self->element({'Name' => 'Hsp_qseq',\n\t\t\t   'Data' => shift @q_ex,\n\t\t       });\n\t   $self->element({'Name' => 'Hsp_hseq',\n\t\t\t   'Data' => shift @h_ex,\n\t\t       });\n\t   $self->element({'Name' => 'Hsp_midline',\n\t\t\t   'Data' => shift @m_ex,\n\t\t       });\n## gc addition end\n\n\t   $self->element({'Name' => 'Hsp_score',\n\t\t\t   'Data' => $score});\n\n\t   $self->element({'Name' => 'Hsp_query-from',\n\t\t\t   'Data' => $qs});\n\n\t   $qs += $aln_len*$qstrand;\n\t   $self->element({'Name' => 'Hsp_query-to',\n\t\t\t   'Data' => $qs - ($qstrand*1)});\n\n\t   $hs += $deletes*$hstrand;\n\t   $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t   'Data' => $hs});\n\t   $hs += $aln_len*$hstrand;\n\t   $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t   'Data' => $hs -($hstrand*1)});\n\n\t   $self->element({'Name' => 'Hsp_align-len',\n\t\t\t   'Data' => $aln_len});\n\n\t   $self->element({'Name' => 'Hsp_identity',\n\t\t\t   'Data' => $aln_len - ($inserts + $deletes)});\n\n\t   $self->element({'Name' => 'Hsp_gaps',\n\t\t\t   'Data' => $inserts + $deletes});\n\n\t   $self->element({'Name' => 'Hsp_querygaps',\n\t\t\t   'Data' => $inserts});\n\t   $self->element({'Name' => 'Hsp_hitgaps',\n\t\t\t   'Data' => $deletes});\n\t   $self->end_element({'Name' => 'Hsp'});\n\n\t   $self->element({'Name' => 'Hit_score',\n\t\t\t   'Data' => $score});\n\n\t   $self->end_element({'Name' => 'Hit'});\n\t   $self->end_element({'Name' => 'ExonerateOutput'});\n\n\t   return $self->end_document();\n       } else {\n\t   # skipping this line\n       }\n   }\n   return $self->end_document() if( $seentop );\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n   # we currently don't care about attributes\n   my $nm = $data->{'Name'};\n   my $type = $MODEMAP{$nm};\n\n   if( $type ) {\n       if( $self->_eventHandler->will_handle($type) ) {\n\t   my $func = sprintf(\"start_%s\",lc $type);\n\t   $self->_eventHandler->$func($data->{'Attributes'});\n       }\n       unshift @{$self->{'_elements'}}, $type;\n       if($type eq 'result') {\n\t   $self->{'_values'} = {};\n\t   $self->{'_result'}= undef;\n       }\n   }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if( $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) {\n\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else {\n\t$self->debug( \"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at\n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;\n\n   return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/ );\n\n   $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name\n\n\n\nsub within_element{\n   my ($self,$name) = @_;\n   return 0 if ( ! defined $name &&\n\t\t ! defined  $self->{'_elements'} ||\n\t\t scalar @{$self->{'_elements'}} == 0) ;\n   foreach (  @{$self->{'_elements'}} ) {\n       if( $_ eq $name  ) {\n\t   return 1;\n       }\n   }\n   return 0;\n}\n\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name\n\n\n\nsub in_element{\n   my ($self,$name) = @_;\n   return 0 if ! defined $self->{'_elements'}->[0];\n   return ( $self->{'_elements'}->[0] eq $name)\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handle a start document event\n Returns : none\n Args    : none\n\n\n\nsub start_document{\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'} = {};\n    $self->{'_result'}= undef;\n    $self->{'_elements'} = [];\n    $self->{'_reporttype'} = 'exonerate';\n}\n\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $eventgenerator->end_document\n Function: Handles an end document event\n Returns : Bio::Search::Result::ResultI object\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}]},"line":733,"kind":12,"range":{"end":{"character":9999,"line":736},"start":{"character":0,"line":733}},"definition":"sub","detail":"($self,@args)","children":[{"localvar":"my","containerName":"end_document","kind":13,"name":"$self","line":734,"definition":"my"},{"name":"@args","kind":13,"containerName":"end_document","line":734},{"name":"$self","containerName":"end_document","kind":13,"line":735}],"containerName":"main::","name":"end_document"},{"signature":{"parameters":[{"label":"$self"},{"label":"$blast"},{"label":"@args"}],"documentation":"","label":"write_result($self,$blast,@args)"},"kind":12,"range":{"start":{"line":739,"character":0},"end":{"line":747,"character":9999}},"line":739,"detail":"($self,$blast,@args)","definition":"sub","name":"write_result","containerName":"main::","children":[{"line":740,"name":"$self","kind":13,"localvar":"my","containerName":"write_result","definition":"my"},{"kind":13,"containerName":"write_result","name":"$blast","line":740},{"name":"@args","kind":13,"containerName":"write_result","line":740},{"name":"$self","kind":13,"containerName":"write_result","line":742},{"line":742,"name":"writer","kind":12,"containerName":"write_result"},{"containerName":"write_result","kind":13,"name":"$self","line":743},{"line":743,"kind":12,"containerName":"write_result","name":"warn"},{"line":744,"name":"$self","containerName":"write_result","kind":13},{"containerName":"write_result","kind":12,"name":"writer","line":744},{"kind":13,"containerName":"write_result","name":"$DEFAULT_WRITER_CLASS","line":744},{"name":"new","kind":12,"containerName":"write_result","line":744},{"line":746,"kind":13,"containerName":"write_result","name":"$self"},{"containerName":"write_result","kind":13,"name":"$blast","line":746},{"line":746,"kind":13,"containerName":"write_result","name":"@args"}]},{"line":746,"kind":12,"containerName":"write_result","name":"SUPER"},{"definition":"sub","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"result_count","line":750,"definition":"my"},{"line":751,"name":"$self","kind":13,"containerName":"result_count"}],"name":"result_count","containerName":"main::","line":749,"range":{"end":{"character":9999,"line":752},"start":{"line":749,"character":0}},"kind":12},{"children":[{"containerName":"report_count","kind":12,"name":"result_count","line":754}],"name":"report_count","containerName":"main::","definition":"sub","line":754,"range":{"start":{"line":754,"character":0},"end":{"line":754,"character":9999}},"kind":12},{"name":"vulgar","containerName":"main::","children":[{"definition":"my","line":768,"name":"$self","localvar":"my","kind":13,"containerName":"vulgar"},{"line":769,"name":"$x","kind":13,"localvar":"my","containerName":"vulgar","definition":"my"},{"containerName":"vulgar","kind":13,"name":"$self","line":771},{"line":772,"containerName":"vulgar","kind":13,"name":"$self"},{"line":772,"name":"warn","kind":12,"containerName":"vulgar"},{"line":773,"name":"$self","containerName":"vulgar","kind":13},{"line":774,"name":"$self","containerName":"vulgar","kind":13},{"name":"$self","kind":13,"containerName":"vulgar","line":777}],"definition":"sub","kind":12,"range":{"start":{"character":0,"line":767},"end":{"character":9999,"line":778}},"line":767},{"definition":"sub","children":[{"definition":"my","line":792,"localvar":"my","kind":13,"containerName":"cigar","name":"$self"},{"line":793,"localvar":"my","containerName":"cigar","kind":13,"name":"$x","definition":"my"},{"name":"$self","containerName":"cigar","kind":13,"line":795},{"containerName":"cigar","kind":13,"name":"$self","line":796},{"kind":12,"containerName":"cigar","name":"warn","line":796},{"line":797,"containerName":"cigar","kind":13,"name":"$self"},{"line":798,"name":"$self","containerName":"cigar","kind":13},{"name":"$self","containerName":"cigar","kind":13,"line":801}],"containerName":"main::","name":"cigar","line":791,"kind":12,"range":{"start":{"character":0,"line":791},"end":{"line":802,"character":9999}}}]}