{"version":5,"vars":[{"containerName":"","kind":2,"name":"base","line":98},{"signature":{"parameters":[{"label":"$self"}],"documentation":"#$Header$\n# $Id: cross_match.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::cross_match\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shin Leong <sleong@watson.wustl.edu>\n#\n# Copyright Shin Leong\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::cross_match - CrossMatch-specific subclass of Bio::SearchIO\n\n=head1 SYNOPSIS\n\n    # Working with iterations (CrossMatch results)\n    my $searchIO = Bio::SearchIO->new( -format => 'cross_match',\n                            -file   => \"$file.screen.out\" )\n    while(my $r = $searchIO->next_result) {\n      while(my $hit = $r->next_hit) {\n\twhile(my $hsp = $hit->next_hsp) {\n           #Do the processing here.\n        }\n      }\n    }\n# See Bio::SearchIO for information about working with Results.\n\n# See L<Bio::SearchIO>\n# for details about working with Bio::SearchIO.\n\n\n=head1 DESCRIPTION\n\nThis object is a subclass of Bio::SearchIO\nand provides some operations that facilitate working with CrossMatch\nand CrossMatch results.\n\nFor general information about working with Results, see \nL<Bio::Search::Result::GenericResult>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shin Leong\n\nEmail sleong@watson.wustl.edu\n\n=head1 CONTRIBUTORS\n\nAdditional contributors names and emails here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::cross_match;\nuse Bio::Search::Result::CrossMatchResult;\nuse Bio::SearchIO;\nuse Bio::Search::Hit::GenericHit;\nuse Bio::Search::HSP::GenericHSP;\nuse base qw(Bio::SearchIO);\n\n=head2 next_result\n\n Title   : next_result\n Usage   : $result = stream->next_result\n Function: Reads the next ResultI object from the stream and returns it.\n\n           Certain driver modules may encounter entries in the stream that\n           are either misformatted or that use syntax not yet understood\n           by the driver. If such an incident is recoverable, e.g., by\n           dismissing a feature of a feature table or some other non-mandatory\n           part of an entry, the driver will issue a warning. In the case\n           of a non-recoverable situation an exception will be thrown.\n           Do not assume that you can resume parsing the same stream after\n           catching the exception. Note that you can always turn recoverable\n           errors into exceptions by calling $stream->verbose(2) (see\n           Bio::Root::RootI POD page).\n Returns : A Bio::Search::Result::ResultI object\n Args    : n/a\n\nSee L<Bio::Root::RootI>","label":"next_result($self)"},"line":123,"kind":12,"range":{"end":{"line":159,"character":9999},"start":{"line":123,"character":0}},"definition":"sub","detail":"($self)","children":[{"definition":"my","line":124,"name":"$self","containerName":"next_result","localvar":"my","kind":13},{"definition":"my","localvar":"my","kind":13,"containerName":"next_result","name":"$start","line":125},{"line":126,"containerName":"next_result","kind":13,"name":"$self"},{"line":126,"name":"_readline","containerName":"next_result","kind":12},{"kind":13,"containerName":"next_result","name":"$self","line":127},{"line":129,"name":"$self","containerName":"next_result","kind":13},{"name":"$start","kind":13,"containerName":"next_result","line":131},{"containerName":"next_result","kind":13,"name":"$self","line":133},{"name":"$start","kind":13,"containerName":"next_result","line":135},{"name":"$self","kind":13,"containerName":"next_result","line":135},{"name":"$self","containerName":"next_result","kind":13,"line":136},{"containerName":"next_result","kind":13,"name":"$self","line":137},{"line":137,"name":"_parse","containerName":"next_result","kind":12},{"line":138,"containerName":"next_result","kind":13,"name":"$self"},{"definition":"my","line":140,"name":"$p","localvar":"my","containerName":"next_result","kind":13},{"name":"@pp","localvar":"my","kind":13,"containerName":"next_result","line":141,"definition":"my"},{"name":"$p","containerName":"next_result","kind":13,"line":141},{"definition":"my","line":142,"name":"$i","localvar":"my","containerName":"next_result","kind":13},{"kind":13,"containerName":"next_result","name":"$i","line":142},{"line":142,"containerName":"next_result","kind":13,"name":"@pp"},{"line":142,"name":"$i","kind":13,"containerName":"next_result"},{"name":"$pp","containerName":"next_result","kind":13,"line":143},{"name":"$i","kind":13,"containerName":"next_result","line":143},{"line":144,"name":"$pp","containerName":"next_result","kind":13},{"containerName":"next_result","kind":13,"name":"$i","line":144},{"line":144,"name":"$pp","kind":13,"containerName":"next_result"},{"line":144,"name":"$i","containerName":"next_result","kind":13},{"kind":13,"containerName":"next_result","name":"$self","line":145},{"kind":13,"containerName":"next_result","name":"$pp","line":145},{"line":145,"kind":13,"containerName":"next_result","name":"$i"},{"name":"$pp","kind":13,"containerName":"next_result","line":145},{"containerName":"next_result","kind":13,"name":"$i","line":145},{"line":146,"kind":13,"containerName":"next_result","name":"$i"},{"line":148,"containerName":"next_result","kind":13,"name":"$self"},{"containerName":"next_result","kind":13,"name":"$pp","line":148},{"line":148,"name":"$i","containerName":"next_result","kind":13},{"containerName":"next_result","kind":13,"name":"$self","line":154},{"line":156,"name":"$self","kind":13,"containerName":"next_result"}],"name":"next_result","containerName":"main::"},{"line":129,"kind":12,"name":"_algorithm_version"},{"kind":12,"name":"_parameters","line":138},{"name":"_parameters","kind":12,"line":145},{"line":148,"name":"_parameters","kind":12},{"name":"_query_name","kind":12,"line":154},{"name":"_subject_name","kind":12,"line":156},{"kind":12,"range":{"end":{"character":9999,"line":216},"start":{"character":0,"line":168}},"line":168,"definition":"sub","name":"_alignment","containerName":"main::","children":[{"line":169,"name":"$self","localvar":"my","containerName":"_alignment","kind":13,"definition":"my"},{"localvar":"my","containerName":"_alignment","kind":13,"name":"$blank","line":194,"definition":"my"},{"line":194,"name":"$self","containerName":"_alignment","kind":13},{"kind":12,"containerName":"_alignment","name":"_readline","line":194},{"kind":13,"containerName":"_alignment","name":"$blank","line":195},{"definition":"my","kind":13,"localvar":"my","containerName":"_alignment","name":"@data","line":198},{"containerName":"_alignment","localvar":"my","kind":13,"name":"@pad","line":199,"definition":"my"},{"line":200,"kind":13,"containerName":"_alignment","name":"$count"},{"containerName":"_alignment","kind":13,"name":"$self","line":201},{"kind":12,"containerName":"_alignment","name":"_readline","line":201},{"line":202,"name":"$count","containerName":"_alignment","kind":13},{"containerName":"_alignment","kind":13,"name":"$count","line":202},{"name":"$count","kind":13,"containerName":"_alignment","line":205},{"name":"$pad","containerName":"_alignment","kind":13,"line":207},{"line":207,"name":"$count","kind":13,"containerName":"_alignment"},{"line":208,"containerName":"_alignment","kind":13,"name":"$data"},{"line":208,"name":"$count","containerName":"_alignment","kind":13},{"name":"$data","kind":13,"containerName":"_alignment","line":211},{"line":211,"name":"$count","containerName":"_alignment","kind":13},{"line":213,"name":"$self","containerName":"_alignment","kind":13},{"name":"throw","containerName":"_alignment","kind":12,"line":213}]},{"name":"@data","containerName":null,"kind":13,"line":220},{"children":[{"name":"$self","localvar":"my","containerName":"_parse","kind":13,"line":231,"definition":"my"},{"name":"$line","localvar":"my","containerName":"_parse","kind":13,"line":232,"definition":"my"},{"line":233,"name":"$is_alignment","localvar":"my","containerName":"_parse","kind":13,"definition":"my"},{"definition":"my","line":234,"localvar":"my","kind":13,"containerName":"_parse","name":"$hit_seq"},{"line":234,"containerName":"_parse","kind":13,"name":"$homology_seq"},{"name":"$query_seq","containerName":"_parse","kind":13,"line":234},{"line":238,"name":"$line","containerName":"_parse","kind":13},{"name":"@r","localvar":"my","kind":13,"containerName":"_parse","line":239,"definition":"my"},{"line":239,"kind":13,"containerName":"_parse","name":"$line"},{"containerName":"_parse","kind":13,"name":"$r","line":240},{"name":"$is_alignment","kind":13,"containerName":"_parse","line":241},{"containerName":"_parse","kind":13,"name":"@r","line":242},{"containerName":"_parse","kind":13,"name":"$hit_seq","line":243},{"line":243,"kind":13,"containerName":"_parse","name":"$homology_seq"},{"line":243,"containerName":"_parse","kind":13,"name":"$query_seq"},{"line":243,"kind":13,"containerName":"_parse","name":"$self"},{"line":243,"name":"_alignment","kind":12,"containerName":"_parse"},{"definition":"my","name":"$subject_seq_id","kind":13,"localvar":"my","containerName":"_parse","line":245},{"line":246,"containerName":"_parse","localvar":"my","kind":13,"name":"$query_seq_id","definition":"my"},{"name":"$r","containerName":"_parse","kind":13,"line":246},{"line":247,"name":"$query_start","localvar":"my","kind":13,"containerName":"_parse","definition":"my"},{"line":247,"kind":13,"containerName":"_parse","name":"$r"},{"name":"$query_end","containerName":"_parse","localvar":"my","kind":13,"line":248,"definition":"my"},{"line":248,"name":"$r","containerName":"_parse","kind":13},{"definition":"my","name":"$is_complement","kind":13,"localvar":"my","containerName":"_parse","line":249},{"definition":"my","kind":13,"localvar":"my","containerName":"_parse","name":"$subject_start","line":250},{"localvar":"my","containerName":"_parse","kind":13,"name":"$subject_end","line":251,"definition":"my"},{"containerName":"_parse","kind":13,"name":"$r","line":252},{"name":"$r","kind":13,"containerName":"_parse","line":252},{"name":"$subject_seq_id","containerName":"_parse","kind":13,"line":253},{"name":"$r","kind":13,"containerName":"_parse","line":253},{"line":254,"name":"$is_complement","containerName":"_parse","kind":13},{"kind":13,"containerName":"_parse","name":"$subject_start","line":255},{"line":255,"name":"$r","kind":13,"containerName":"_parse"},{"line":256,"name":"$subject_end","containerName":"_parse","kind":13},{"kind":13,"containerName":"_parse","name":"$r","line":256},{"line":258,"name":"$subject_seq_id","containerName":"_parse","kind":13},{"name":"$r","containerName":"_parse","kind":13,"line":258},{"line":259,"name":"$subject_start","kind":13,"containerName":"_parse"},{"line":259,"name":"$r","containerName":"_parse","kind":13},{"line":260,"containerName":"_parse","kind":13,"name":"$subject_end"},{"line":260,"name":"$r","containerName":"_parse","kind":13},{"definition":"my","line":262,"containerName":"_parse","localvar":"my","kind":13,"name":"$hit"},{"line":262,"containerName":"_parse","kind":12,"name":"new"},{"name":"$subject_seq_id","kind":13,"containerName":"_parse","line":262},{"line":263,"kind":12,"containerName":"_parse","name":"new"},{"name":"$query_seq_id","containerName":"_parse","kind":13,"line":263},{"name":"$query_start","kind":13,"containerName":"_parse","line":264},{"name":"$query_end","kind":13,"containerName":"_parse","line":265},{"name":"$subject_seq_id","containerName":"_parse","kind":13,"line":266},{"line":267,"containerName":"_parse","kind":13,"name":"$subject_start"},{"line":268,"containerName":"_parse","kind":13,"name":"$subject_end"},{"line":271,"name":"$r","containerName":"_parse","kind":13},{"line":272,"containerName":"_parse","kind":13,"name":"$r"},{"name":"$query_seq","containerName":"_parse","kind":13,"line":273},{"line":273,"name":"$query_seq","kind":13,"containerName":"_parse"},{"line":274,"name":"$hit_seq","containerName":"_parse","kind":13},{"name":"$hit_seq","containerName":"_parse","kind":13,"line":274},{"containerName":"_parse","kind":13,"name":"$homology_seq","line":275},{"line":275,"name":"$homology_seq","containerName":"_parse","kind":13},{"name":"$result","localvar":"my","kind":13,"containerName":"_parse","line":279,"definition":"my"},{"containerName":"_parse","kind":12,"name":"new","line":279},{"line":279,"name":"$self","kind":13,"containerName":"_parse"},{"line":283,"containerName":"_parse","kind":13,"name":"$self"},{"line":286,"name":"$self","containerName":"_parse","kind":13},{"kind":13,"containerName":"_parse","name":"$self","line":289},{"line":291,"name":"$result","containerName":"_parse","kind":13},{"line":291,"name":"add_hit","kind":12,"containerName":"_parse"},{"name":"$hit","kind":13,"containerName":"_parse","line":291},{"line":292,"name":"$result","kind":13,"containerName":"_parse"}],"name":"_parse","containerName":"main::","definition":"sub","line":230,"kind":12,"range":{"end":{"line":293,"character":9999},"start":{"line":230,"character":0}}},{"name":"Bio","kind":12,"containerName":"Search::Hit::GenericHit","line":262},{"line":263,"kind":12,"containerName":"Search::HSP::GenericHSP","name":"Bio"},{"kind":12,"containerName":"Search::Result::CrossMatchResult","name":"Bio","line":279},{"name":"_query_name","kind":12,"line":279},{"line":283,"kind":12,"name":"_subject_name"},{"kind":12,"name":"_parameters","line":286},{"kind":12,"name":"_algorithm_version","line":289},{"containerName":"main::","name":"result_count","children":[{"name":"$self","containerName":"result_count","localvar":"my","kind":13,"line":307,"definition":"my"},{"line":308,"containerName":"result_count","kind":13,"name":"$self"}],"definition":"sub","range":{"end":{"line":309,"character":9999},"start":{"character":0,"line":306}},"kind":12,"line":306}]}