{"version":5,"vars":[{"containerName":"","kind":2,"name":"vars","line":78},{"name":"$DefaultProgramName","kind":13,"containerName":null,"line":84},{"line":84,"containerName":"strict::Bio::Search::Result::ResultFactory::Bio::Search::Hit::HitFactory::Bio::Search::HSP","kind":2,"name":"HSPFactory"},{"line":85,"name":"$DEFAULT_WRITER_CLASS","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%MODEMAP","line":88},{"name":"%MAPPING","kind":13,"containerName":null,"line":94},{"containerName":"","kind":2,"name":"base","line":133},{"kind":12,"range":{"start":{"character":0,"line":146},"end":{"line":156,"character":9999}},"line":146,"signature":{"label":"_initialize($self,@args)","documentation":"1;\n# $Id: blasttable.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blasttable\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::blasttable - Driver module for SearchIO for parsing NCBI -m 8/9 format\n\n=head1 SYNOPSIS\n\n  # do not use this module directly\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => $file,\n                                 -format => 'blasttable');\n\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis module will support parsing NCBI -m 8 or -m 9 tabular output\nand WU-BLAST -mformat 2 or -mformat 3 tabular output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::blasttable;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\nuse strict;\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::HSP::HSPFactory;\n\n$DefaultProgramName = 'BLASTN';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\n%MAPPING = ( \n\t     'Hsp_bit-score'  => 'HSP-bits',\n\t     'Hsp_score'      => 'HSP-score',\n\t     'Hsp_evalue'     => 'HSP-evalue',\n\t     'Hsp_query-from' => 'HSP-query_start',\n\t     'Hsp_query-to'   => 'HSP-query_end',\n\t     'Hsp_hit-from'   => 'HSP-hit_start',\n\t     'Hsp_hit-to'     => 'HSP-hit_end',\n\t     'Hsp_positive'   => 'HSP-conserved',\n\t     'Hsp_identity'   => 'HSP-identical',\n\t     'Hsp_mismatches' => 'HSP-mismatches',\n\t     'Hsp_qgapblocks' => 'HSP-query_gapblocks',\n\t     'Hsp_hgapblocks' => 'HSP-hit_gapblocks',\n\t     'Hsp_gaps'       => 'HSP-hsp_gaps',\n\t     'Hsp_hitgaps'    => 'HSP-hit_gaps',\n\t     'Hsp_querygaps'  => 'HSP-query_gaps',\n\t     'Hsp_align-len'  => 'HSP-hsp_length',\n\t     'Hsp_query-frame'=> 'HSP-query_frame',\n\t     'Hsp_hit-frame'  => 'HSP-hit_frame',\n\n\t     'Hit_id'        => 'HIT-name',\n\t     'Hit_len'       => 'HIT-length',\n\t     'Hit_accession' => 'HIT-accession',\n\t     'Hit_def'       => 'HIT-description',\n\t     'Hit_signif'    => 'HIT-significance',\n\t     'Hit_score'     => 'HIT-score',\n\t     'Hit_bits'      => 'HIT-bits',\n\n\t     'Result_program'  => 'RESULT-algorithm_name',\n\t     'Result_version'  => 'RESULT-algorithm_version',\n\t     'Result_query-def'=> 'RESULT-query_name',\n\t     'Result_query-len'=> 'RESULT-query_length',\n\t     'Result_query-acc'=> 'RESULT-query_accession',\n\t     'Result_querydesc'=> 'RESULT-query_description',\n\t     'Result_db'       => 'RESULT-database_name',\n\t     'Result_db-len'   => 'RESULT-database_entries',\n\t     'Result_db-let'   => 'RESULT-database_letters',\n\t     );\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blasttable->new();\n Function: Builds a new Bio::SearchIO::blasttable object \n Returns : an instance of Bio::SearchIO::blasttable\n Args    :","parameters":[{"label":"$self"},{"label":"@args"}]},"name":"_initialize","containerName":"main::","children":[{"line":147,"name":"$self","kind":13,"localvar":"my","containerName":"_initialize","definition":"my"},{"kind":13,"containerName":"_initialize","name":"@args","line":147},{"containerName":"_initialize","kind":13,"name":"$self","line":148},{"line":148,"name":"@args","kind":13,"containerName":"_initialize"},{"definition":"my","line":150,"name":"$pname","kind":13,"localvar":"my","containerName":"_initialize"},{"name":"$self","kind":13,"containerName":"_initialize","line":150},{"line":150,"containerName":"_initialize","kind":12,"name":"_rearrange"},{"kind":13,"containerName":"_initialize","name":"@args","line":151},{"line":152,"name":"$self","kind":13,"containerName":"_initialize"},{"name":"program_name","containerName":"_initialize","kind":12,"line":152},{"line":152,"name":"$pname","kind":13,"containerName":"_initialize"},{"kind":13,"containerName":"_initialize","name":"$DefaultProgramName","line":152},{"line":153,"kind":13,"containerName":"_initialize","name":"$self"},{"line":153,"name":"_eventHandler","containerName":"_initialize","kind":12},{"name":"register_factory","kind":12,"containerName":"_initialize","line":153},{"line":153,"name":"new","containerName":"_initialize","kind":12},{"line":154,"name":"$self","containerName":"_initialize","kind":13},{"containerName":"_initialize","kind":12,"name":"_eventHandler","line":154},{"name":"register_factory","kind":12,"containerName":"_initialize","line":154},{"line":154,"kind":12,"containerName":"_initialize","name":"new"},{"line":155,"name":"$self","containerName":"_initialize","kind":13},{"line":155,"name":"_eventHandler","containerName":"_initialize","kind":12},{"line":155,"containerName":"_initialize","kind":12,"name":"register_factory"},{"line":155,"name":"new","containerName":"_initialize","kind":12}],"detail":"($self,@args)","definition":"sub"},{"containerName":"_initialize","kind":12,"name":"SUPER","line":148},{"containerName":"Search::Result::ResultFactory","kind":12,"name":"Bio","line":153},{"kind":12,"containerName":"Search::Hit::HitFactory","name":"Bio","line":154},{"name":"Bio","kind":12,"containerName":"Search::HSP::HSPFactory","line":155},{"signature":{"label":"next_result($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: blasttable.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blasttable\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::blasttable - Driver module for SearchIO for parsing NCBI -m 8/9 format\n\n=head1 SYNOPSIS\n\n  # do not use this module directly\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => $file,\n                                 -format => 'blasttable');\n\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis module will support parsing NCBI -m 8 or -m 9 tabular output\nand WU-BLAST -mformat 2 or -mformat 3 tabular output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::blasttable;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\nuse strict;\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::HSP::HSPFactory;\n\n$DefaultProgramName = 'BLASTN';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\n%MAPPING = ( \n\t     'Hsp_bit-score'  => 'HSP-bits',\n\t     'Hsp_score'      => 'HSP-score',\n\t     'Hsp_evalue'     => 'HSP-evalue',\n\t     'Hsp_query-from' => 'HSP-query_start',\n\t     'Hsp_query-to'   => 'HSP-query_end',\n\t     'Hsp_hit-from'   => 'HSP-hit_start',\n\t     'Hsp_hit-to'     => 'HSP-hit_end',\n\t     'Hsp_positive'   => 'HSP-conserved',\n\t     'Hsp_identity'   => 'HSP-identical',\n\t     'Hsp_mismatches' => 'HSP-mismatches',\n\t     'Hsp_qgapblocks' => 'HSP-query_gapblocks',\n\t     'Hsp_hgapblocks' => 'HSP-hit_gapblocks',\n\t     'Hsp_gaps'       => 'HSP-hsp_gaps',\n\t     'Hsp_hitgaps'    => 'HSP-hit_gaps',\n\t     'Hsp_querygaps'  => 'HSP-query_gaps',\n\t     'Hsp_align-len'  => 'HSP-hsp_length',\n\t     'Hsp_query-frame'=> 'HSP-query_frame',\n\t     'Hsp_hit-frame'  => 'HSP-hit_frame',\n\n\t     'Hit_id'        => 'HIT-name',\n\t     'Hit_len'       => 'HIT-length',\n\t     'Hit_accession' => 'HIT-accession',\n\t     'Hit_def'       => 'HIT-description',\n\t     'Hit_signif'    => 'HIT-significance',\n\t     'Hit_score'     => 'HIT-score',\n\t     'Hit_bits'      => 'HIT-bits',\n\n\t     'Result_program'  => 'RESULT-algorithm_name',\n\t     'Result_version'  => 'RESULT-algorithm_version',\n\t     'Result_query-def'=> 'RESULT-query_name',\n\t     'Result_query-len'=> 'RESULT-query_length',\n\t     'Result_query-acc'=> 'RESULT-query_accession',\n\t     'Result_querydesc'=> 'RESULT-query_description',\n\t     'Result_db'       => 'RESULT-database_name',\n\t     'Result_db-len'   => 'RESULT-database_entries',\n\t     'Result_db-let'   => 'RESULT-database_letters',\n\t     );\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blasttable->new();\n Function: Builds a new Bio::SearchIO::blasttable object \n Returns : an instance of Bio::SearchIO::blasttable\n Args    :\n\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n\n    my ($pname) = $self->_rearrange([qw(PROGRAM_NAME)],\n\t\t\t\t    @args);\n    $self->program_name($pname || $DefaultProgramName);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::GenericResult'));\n    $self->_eventHandler->register_factory('hit', Bio::Search::Hit::HitFactory->new(-type => 'Bio::Search::Hit::GenericHit'));\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::GenericHSP'));\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $parser->next_result\n Function: Parse the next result from the data stream\n Returns : L<Bio::Search::Result::ResultI>\n Args    : none"},"line":170,"range":{"start":{"line":170,"character":0},"end":{"character":9999,"line":297}},"kind":12,"definition":"sub","detail":"($self)","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"next_result","line":171,"definition":"my"},{"definition":"my","name":"$lastquery","localvar":"my","containerName":"next_result","kind":13,"line":172},{"line":172,"kind":13,"containerName":"next_result","name":"$lasthit"},{"definition":"my","localvar":"my","kind":13,"containerName":"next_result","name":"$alg","line":175},{"line":175,"name":"$ver","containerName":"next_result","kind":13},{"line":176,"name":"$self","containerName":"next_result","kind":13},{"line":176,"containerName":"next_result","kind":12,"name":"_readline"},{"line":179,"containerName":"next_result","kind":13,"name":"$alg"},{"containerName":"next_result","kind":13,"name":"$ver","line":179},{"containerName":"next_result","kind":13,"name":"$self","line":183},{"containerName":"next_result","kind":12,"name":"program_name","line":183},{"line":183,"name":"$alg","containerName":"next_result","kind":13},{"line":183,"name":"$alg","containerName":"next_result","kind":13},{"name":"$self","containerName":"next_result","kind":13,"line":184},{"line":184,"kind":12,"containerName":"next_result","name":"element"},{"line":185,"containerName":"next_result","kind":13,"name":"$ver"},{"name":"$ver","containerName":"next_result","kind":13,"line":185},{"containerName":"next_result","kind":13,"name":"$alg","line":190},{"line":190,"kind":13,"containerName":"next_result","name":"$ver"},{"localvar":"my","containerName":"next_result","kind":13,"name":"@fields","line":195,"definition":"my"},{"line":196,"name":"@fields","containerName":"next_result","kind":13},{"definition":"my","localvar":"my","kind":13,"containerName":"next_result","name":"$qname","line":197},{"line":197,"name":"$hname","containerName":"next_result","kind":13},{"line":197,"kind":13,"containerName":"next_result","name":"$percent_id"},{"line":197,"containerName":"next_result","kind":13,"name":"$hsp_len"},{"kind":13,"containerName":"next_result","name":"$mismatches","line":197},{"line":197,"name":"$gapsm","kind":13,"containerName":"next_result"},{"line":198,"name":"$qstart","kind":13,"containerName":"next_result"},{"name":"$qend","containerName":"next_result","kind":13,"line":198},{"line":198,"containerName":"next_result","kind":13,"name":"$hstart"},{"line":198,"kind":13,"containerName":"next_result","name":"$hend"},{"name":"$evalue","kind":13,"containerName":"next_result","line":198},{"name":"$bits","containerName":"next_result","kind":13,"line":198},{"definition":"my","name":"$num_scores","localvar":"my","containerName":"next_result","kind":13,"line":200},{"line":200,"name":"$raw_score","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"$identities","line":200},{"kind":13,"containerName":"next_result","name":"$positives","line":200},{"kind":13,"containerName":"next_result","name":"$percent_pos","line":200},{"line":201,"containerName":"next_result","kind":13,"name":"$qgap_blocks"},{"name":"$qgaps","containerName":"next_result","kind":13,"line":201},{"containerName":"next_result","kind":13,"name":"$sgap_blocks","line":201},{"name":"$sgaps","containerName":"next_result","kind":13,"line":201},{"name":"$qframe","kind":13,"containerName":"next_result","line":201},{"line":202,"containerName":"next_result","kind":13,"name":"$sframe"},{"name":"@fields","kind":13,"containerName":"next_result","line":204},{"name":"$qname","containerName":"next_result","kind":13,"line":205},{"name":"$hname","kind":13,"containerName":"next_result","line":205},{"line":205,"name":"$percent_id","containerName":"next_result","kind":13},{"name":"$hsp_len","kind":13,"containerName":"next_result","line":205},{"line":205,"containerName":"next_result","kind":13,"name":"$mismatches"},{"line":205,"name":"$gapsm","containerName":"next_result","kind":13},{"line":206,"name":"$qstart","containerName":"next_result","kind":13},{"name":"$qend","kind":13,"containerName":"next_result","line":206},{"line":206,"containerName":"next_result","kind":13,"name":"$hstart"},{"name":"$hend","kind":13,"containerName":"next_result","line":206},{"line":206,"containerName":"next_result","kind":13,"name":"$evalue"},{"line":206,"containerName":"next_result","kind":13,"name":"$bits"},{"line":206,"name":"@fields","containerName":"next_result","kind":13},{"line":208,"name":"@fields","kind":13,"containerName":"next_result"},{"name":"$qname","containerName":"next_result","kind":13,"line":209},{"containerName":"next_result","kind":13,"name":"$hname","line":209},{"line":209,"containerName":"next_result","kind":13,"name":"$percent_id"},{"line":209,"name":"$percent_pos","kind":13,"containerName":"next_result"},{"line":209,"name":"$hsp_len","kind":13,"containerName":"next_result"},{"line":209,"name":"$mismatches","containerName":"next_result","kind":13},{"containerName":"next_result","kind":13,"name":"$gapsm","line":209},{"containerName":"next_result","kind":13,"name":"$qstart","line":210},{"name":"$qend","containerName":"next_result","kind":13,"line":210},{"line":210,"containerName":"next_result","kind":13,"name":"$hstart"},{"name":"$hend","containerName":"next_result","kind":13,"line":210},{"line":210,"name":"$evalue","containerName":"next_result","kind":13},{"containerName":"next_result","kind":13,"name":"$bits","line":210},{"line":210,"containerName":"next_result","kind":13,"name":"@fields"},{"line":213,"containerName":"next_result","kind":13,"name":"@fields"},{"line":213,"name":"@fields","containerName":"next_result","kind":13},{"line":214,"kind":13,"containerName":"next_result","name":"$qname"},{"line":214,"name":"$hname","containerName":"next_result","kind":13},{"line":214,"name":"$evalue","containerName":"next_result","kind":13},{"name":"$num_scores","containerName":"next_result","kind":13,"line":214},{"line":214,"name":"$bits","kind":13,"containerName":"next_result"},{"name":"$raw_score","containerName":"next_result","kind":13,"line":214},{"name":"$hsp_len","containerName":"next_result","kind":13,"line":214},{"line":215,"containerName":"next_result","kind":13,"name":"$identities"},{"name":"$positives","kind":13,"containerName":"next_result","line":215},{"line":215,"containerName":"next_result","kind":13,"name":"$mismatches"},{"line":215,"name":"$percent_id","containerName":"next_result","kind":13},{"kind":13,"containerName":"next_result","name":"$percent_pos","line":215},{"name":"$qgap_blocks","containerName":"next_result","kind":13,"line":216},{"kind":13,"containerName":"next_result","name":"$qgaps","line":216},{"line":216,"name":"$sgap_blocks","kind":13,"containerName":"next_result"},{"name":"$sgaps","kind":13,"containerName":"next_result","line":216},{"line":216,"containerName":"next_result","kind":13,"name":"$qframe"},{"name":"$qstart","containerName":"next_result","kind":13,"line":216},{"name":"$qend","kind":13,"containerName":"next_result","line":217},{"line":217,"name":"$sframe","kind":13,"containerName":"next_result"},{"line":217,"containerName":"next_result","kind":13,"name":"$hstart"},{"name":"$hend","containerName":"next_result","kind":13,"line":217},{"name":"@fields","containerName":"next_result","kind":13,"line":217},{"line":219,"kind":13,"containerName":"next_result","name":"$gapsm"},{"line":219,"containerName":"next_result","kind":13,"name":"$qgaps"},{"kind":13,"containerName":"next_result","name":"$sgaps","line":219},{"kind":13,"containerName":"next_result","name":"$lastquery","line":223},{"line":224,"containerName":"next_result","kind":13,"name":"$lastquery"},{"line":224,"containerName":"next_result","kind":13,"name":"$qname"},{"name":"$self","containerName":"next_result","kind":13,"line":225},{"line":225,"name":"end_element","containerName":"next_result","kind":12},{"kind":13,"containerName":"next_result","name":"$self","line":226},{"name":"end_element","containerName":"next_result","kind":12,"line":226},{"kind":13,"containerName":"next_result","name":"$self","line":227},{"name":"_pushback","containerName":"next_result","kind":12,"line":227},{"line":228,"name":"$self","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":12,"name":"end_document","line":228},{"line":229,"kind":13,"containerName":"next_result","name":"$lastquery"},{"line":230,"containerName":"next_result","kind":13,"name":"$self"},{"containerName":"next_result","kind":13,"name":"$self","line":231},{"containerName":"next_result","kind":12,"name":"start_element","line":231},{"name":"$self","kind":13,"containerName":"next_result","line":232},{"line":232,"name":"element","containerName":"next_result","kind":12},{"name":"$alg","kind":13,"containerName":"next_result","line":233},{"containerName":"next_result","kind":13,"name":"$self","line":233},{"line":233,"name":"program_name","containerName":"next_result","kind":12},{"line":234,"containerName":"next_result","kind":13,"name":"$self"},{"line":234,"kind":12,"containerName":"next_result","name":"element"},{"line":235,"containerName":"next_result","kind":13,"name":"$ver"},{"containerName":"next_result","kind":13,"name":"$ver","line":235},{"line":236,"containerName":"next_result","kind":13,"name":"$self"},{"line":236,"kind":12,"containerName":"next_result","name":"element"},{"kind":13,"containerName":"next_result","name":"$qname","line":237},{"name":"$self","containerName":"next_result","kind":13,"line":238},{"name":"start_element","containerName":"next_result","kind":12,"line":238},{"line":239,"name":"$self","containerName":"next_result","kind":13},{"containerName":"next_result","kind":12,"name":"element","line":239},{"containerName":"next_result","kind":13,"name":"$hname","line":240},{"line":242,"containerName":"next_result","kind":13,"name":"$self"},{"line":242,"name":"element","containerName":"next_result","kind":12},{"containerName":"next_result","kind":13,"name":"$bits","line":243},{"line":245,"containerName":"next_result","kind":13,"name":"$self"},{"line":245,"name":"element","containerName":"next_result","kind":12},{"containerName":"next_result","kind":13,"name":"$evalue","line":246},{"line":248,"kind":13,"containerName":"next_result","name":"$lasthit"},{"name":"$hname","containerName":"next_result","kind":13,"line":248},{"containerName":"next_result","kind":13,"name":"$self","line":249},{"containerName":"next_result","kind":12,"name":"in_element","line":249},{"kind":13,"containerName":"next_result","name":"$self","line":250},{"containerName":"next_result","kind":12,"name":"end_element","line":250},{"line":252,"name":"$self","containerName":"next_result","kind":13},{"containerName":"next_result","kind":12,"name":"start_element","line":252},{"line":253,"name":"$self","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":12,"name":"element","line":253},{"containerName":"next_result","kind":13,"name":"$hname","line":254},{"line":256,"kind":13,"containerName":"next_result","name":"$self"},{"name":"element","containerName":"next_result","kind":12,"line":256},{"line":257,"kind":13,"containerName":"next_result","name":"$bits"},{"line":259,"kind":13,"containerName":"next_result","name":"$self"},{"line":259,"name":"element","kind":12,"containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"$evalue","line":260},{"containerName":"next_result","localvar":"my","kind":13,"name":"$identical","line":262,"definition":"my"},{"line":262,"name":"$hsp_len","kind":13,"containerName":"next_result"},{"line":262,"containerName":"next_result","kind":13,"name":"$mismatches"},{"containerName":"next_result","kind":13,"name":"$gapsm","line":262},{"line":263,"name":"$self","containerName":"next_result","kind":13},{"kind":12,"containerName":"next_result","name":"start_element","line":263},{"containerName":"next_result","kind":13,"name":"$self","line":264},{"line":264,"name":"element","kind":12,"containerName":"next_result"},{"kind":13,"containerName":"next_result","name":"$evalue","line":265},{"line":266,"name":"$self","containerName":"next_result","kind":13},{"line":266,"name":"element","containerName":"next_result","kind":12},{"line":267,"name":"$bits","containerName":"next_result","kind":13},{"line":268,"name":"$self","containerName":"next_result","kind":13},{"kind":12,"containerName":"next_result","name":"element","line":268},{"line":269,"containerName":"next_result","kind":13,"name":"$identical"},{"kind":13,"containerName":"next_result","name":"$self","line":270},{"line":270,"containerName":"next_result","kind":12,"name":"element"},{"line":271,"kind":13,"containerName":"next_result","name":"$positives"},{"line":272,"name":"$self","containerName":"next_result","kind":13},{"name":"element","kind":12,"containerName":"next_result","line":272},{"line":273,"name":"$gapsm","containerName":"next_result","kind":13},{"containerName":"next_result","kind":13,"name":"$self","line":274},{"line":274,"name":"element","containerName":"next_result","kind":12},{"kind":13,"containerName":"next_result","name":"$qstart","line":275},{"line":276,"containerName":"next_result","kind":13,"name":"$self"},{"name":"element","kind":12,"containerName":"next_result","line":276},{"containerName":"next_result","kind":13,"name":"$qend","line":277},{"containerName":"next_result","kind":13,"name":"$self","line":279},{"containerName":"next_result","kind":12,"name":"element","line":279},{"line":280,"kind":13,"containerName":"next_result","name":"$hstart"},{"containerName":"next_result","kind":13,"name":"$self","line":281},{"name":"element","containerName":"next_result","kind":12,"line":281},{"containerName":"next_result","kind":13,"name":"$hend","line":282},{"name":"$self","kind":13,"containerName":"next_result","line":283},{"kind":12,"containerName":"next_result","name":"element","line":283},{"containerName":"next_result","kind":13,"name":"$hsp_len","line":284},{"name":"$self","containerName":"next_result","kind":13,"line":285},{"line":285,"containerName":"next_result","kind":12,"name":"end_element"},{"name":"$lastquery","containerName":"next_result","kind":13,"line":286},{"containerName":"next_result","kind":13,"name":"$qname","line":286},{"line":287,"name":"$lasthit","containerName":"next_result","kind":13},{"name":"$hname","containerName":"next_result","kind":13,"line":287},{"name":"$lasthit","containerName":"next_result","kind":13,"line":290},{"containerName":"next_result","kind":13,"name":"$lastquery","line":290},{"line":291,"containerName":"next_result","kind":13,"name":"$self"},{"line":291,"containerName":"next_result","kind":12,"name":"in_element"},{"line":292,"kind":13,"containerName":"next_result","name":"$self"},{"name":"end_element","containerName":"next_result","kind":12,"line":292},{"containerName":"next_result","kind":13,"name":"$self","line":294},{"line":294,"name":"end_element","containerName":"next_result","kind":12},{"kind":13,"containerName":"next_result","name":"$self","line":295},{"line":295,"containerName":"next_result","kind":12,"name":"end_document"}],"name":"next_result","containerName":"main::"},{"children":[{"localvar":"my","kind":13,"containerName":"start_element","name":"$self","line":311,"definition":"my"},{"name":"$data","containerName":"start_element","kind":13,"line":311},{"definition":"my","line":313,"localvar":"my","kind":13,"containerName":"start_element","name":"$nm"},{"name":"$data","containerName":"start_element","kind":13,"line":313},{"line":314,"name":"$type","kind":13,"localvar":"my","containerName":"start_element","definition":"my"},{"containerName":"start_element","kind":13,"name":"$MODEMAP","line":314},{"line":314,"name":"$nm","containerName":"start_element","kind":13},{"name":"$self","containerName":"start_element","kind":13,"line":315},{"line":315,"kind":12,"containerName":"start_element","name":"_mode"},{"name":"$type","containerName":"start_element","kind":13,"line":315},{"line":316,"name":"$self","kind":13,"containerName":"start_element"},{"kind":12,"containerName":"start_element","name":"_will_handle","line":316},{"name":"$type","containerName":"start_element","kind":13,"line":316},{"definition":"my","line":317,"localvar":"my","containerName":"start_element","kind":13,"name":"$func"},{"name":"$type","containerName":"start_element","kind":13,"line":317},{"kind":13,"containerName":"start_element","name":"$self","line":318},{"line":318,"containerName":"start_element","kind":12,"name":"_eventHandler"},{"kind":13,"containerName":"start_element","name":"$func","line":318},{"line":318,"containerName":"start_element","kind":13,"name":"$data"},{"line":320,"kind":13,"containerName":"start_element","name":"$self"},{"name":"$type","containerName":"start_element","kind":13,"line":320}],"containerName":"main::","name":"start_element","definition":"sub","detail":"($self,$data)","line":310,"range":{"end":{"line":321,"character":9999},"start":{"character":0,"line":310}},"kind":12,"signature":{"documentation":"1;\n# $Id: blasttable.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blasttable\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::blasttable - Driver module for SearchIO for parsing NCBI -m 8/9 format\n\n=head1 SYNOPSIS\n\n  # do not use this module directly\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => $file,\n                                 -format => 'blasttable');\n\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis module will support parsing NCBI -m 8 or -m 9 tabular output\nand WU-BLAST -mformat 2 or -mformat 3 tabular output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::blasttable;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\nuse strict;\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::HSP::HSPFactory;\n\n$DefaultProgramName = 'BLASTN';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\n%MAPPING = ( \n\t     'Hsp_bit-score'  => 'HSP-bits',\n\t     'Hsp_score'      => 'HSP-score',\n\t     'Hsp_evalue'     => 'HSP-evalue',\n\t     'Hsp_query-from' => 'HSP-query_start',\n\t     'Hsp_query-to'   => 'HSP-query_end',\n\t     'Hsp_hit-from'   => 'HSP-hit_start',\n\t     'Hsp_hit-to'     => 'HSP-hit_end',\n\t     'Hsp_positive'   => 'HSP-conserved',\n\t     'Hsp_identity'   => 'HSP-identical',\n\t     'Hsp_mismatches' => 'HSP-mismatches',\n\t     'Hsp_qgapblocks' => 'HSP-query_gapblocks',\n\t     'Hsp_hgapblocks' => 'HSP-hit_gapblocks',\n\t     'Hsp_gaps'       => 'HSP-hsp_gaps',\n\t     'Hsp_hitgaps'    => 'HSP-hit_gaps',\n\t     'Hsp_querygaps'  => 'HSP-query_gaps',\n\t     'Hsp_align-len'  => 'HSP-hsp_length',\n\t     'Hsp_query-frame'=> 'HSP-query_frame',\n\t     'Hsp_hit-frame'  => 'HSP-hit_frame',\n\n\t     'Hit_id'        => 'HIT-name',\n\t     'Hit_len'       => 'HIT-length',\n\t     'Hit_accession' => 'HIT-accession',\n\t     'Hit_def'       => 'HIT-description',\n\t     'Hit_signif'    => 'HIT-significance',\n\t     'Hit_score'     => 'HIT-score',\n\t     'Hit_bits'      => 'HIT-bits',\n\n\t     'Result_program'  => 'RESULT-algorithm_name',\n\t     'Result_version'  => 'RESULT-algorithm_version',\n\t     'Result_query-def'=> 'RESULT-query_name',\n\t     'Result_query-len'=> 'RESULT-query_length',\n\t     'Result_query-acc'=> 'RESULT-query_accession',\n\t     'Result_querydesc'=> 'RESULT-query_description',\n\t     'Result_db'       => 'RESULT-database_name',\n\t     'Result_db-len'   => 'RESULT-database_entries',\n\t     'Result_db-let'   => 'RESULT-database_letters',\n\t     );\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blasttable->new();\n Function: Builds a new Bio::SearchIO::blasttable object \n Returns : an instance of Bio::SearchIO::blasttable\n Args    :\n\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n\n    my ($pname) = $self->_rearrange([qw(PROGRAM_NAME)],\n\t\t\t\t    @args);\n    $self->program_name($pname || $DefaultProgramName);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::GenericResult'));\n    $self->_eventHandler->register_factory('hit', Bio::Search::Hit::HitFactory->new(-type => 'Bio::Search::Hit::GenericHit'));\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::GenericHSP'));\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $parser->next_result\n Function: Parse the next result from the data stream\n Returns : L<Bio::Search::Result::ResultI>\n Args    : none\n\n\n\nsub next_result{\n   my ($self) = @_;\n   my ($lastquery,$lasthit);\n   local $/ = \"\\n\";\n   local $_;\n   my ($alg, $ver);\n   while( defined ($_ = $self->_readline) ) {\n\t  # WU-BLAST -mformat 3 only\n\t  if(m{^#\\s((?:\\S+?)?BLAST[NPX])\\s(\\d+\\.\\d+.+\\d{4}\\])}) {\n            ($alg, $ver) = ($1, $2);\n\t\t\t# only one header for whole file with WU-BLAST\n\t\t\t# so $alg and $ver won't get set properly for\n\t\t\t# each result\n\t\t\t$self->program_name($alg) if $alg;\n\t\t\t$self->element({'Name' => 'Result_version',\n\t\t\t\t\t   \t\t'Data' => $ver}) if $ver;\n            next;\n\t  }\n      # -m 9 only\n      elsif(m{^#\\s+((?:\\S+?)?BLAST[NPX])\\s+(.+)}) {\n            ($alg, $ver) = ($1, $2);\n            next;\n       }\n       next if /^#/ || /^\\s*$/;\n\n\t  my @fields = split;\n      next if @fields == 1;\n\t  my ($qname,$hname, $percent_id, $hsp_len, $mismatches,$gapsm,\n\t      $qstart,$qend,$hstart,$hend,$evalue,$bits);\n\t  # WU-BLAST-specific\n\t  my ($num_scores, $raw_score, $identities, $positives, $percent_pos,\n\t      $qgap_blocks,$qgaps, $sgap_blocks, $sgaps, $qframe,\n\t      $sframe);\n\t  # NCBI -m8 and -m9\n\t  if (@fields == 12) {\n\t      ($qname,$hname, $percent_id, $hsp_len, $mismatches,$gapsm,\n\t       $qstart,$qend,$hstart,$hend,$evalue,$bits) = @fields;\n\t  # NCBI -m8 and -m9, v 2.2.18+\n\t  } elsif (@fields == 13) {\n          ($qname, $hname, $percent_id, $percent_pos, $hsp_len, $mismatches, $gapsm,\n\t       $qstart,$qend,$hstart,$hend,$evalue,$bits) = @fields;\n      }\n\t  # WU-BLAST -mformat 2 and 3\n\t  elsif ((@fields == 22) or (@fields == 24)) {\n\t      ($qname,$hname,$evalue,$num_scores, $bits, $raw_score, $hsp_len,\n\t       $identities, $positives,$mismatches, $percent_id, $percent_pos,\n\t       $qgap_blocks, $qgaps, $sgap_blocks, $sgaps, $qframe, $qstart,\n\t       $qend, $sframe, $hstart,$hend,) = @fields;\n\t      # we need total gaps in the alignment\n\t      $gapsm=$qgaps+$sgaps;\n\t  }\n\n       # Remember Jim's code is 0 based\n       if( defined $lastquery && \n\t   $lastquery ne $qname ) {\n\t   $self->end_element({'Name' => 'Hit'});\n\t   $self->end_element({'Name' => 'Result'});\n\t   $self->_pushback($_);\n\t   return $self->end_document;\n       } elsif( ! defined $lastquery ) {\n\t   $self->{'_result_count'}++;\n\t   $self->start_element({'Name' => 'Result'});\n\t   $self->element({'Name' => 'Result_program',\n\t\t\t   'Data' => $alg || $self->program_name});\n       $self->element({'Name' => 'Result_version',\n\t\t\t   'Data' => $ver}) if $ver;\n\t   $self->element({'Name' => 'Result_query-def',\n\t\t\t   'Data' => $qname});\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $hname});\n\t   # we'll store the 1st hsp bits as the hit bits\n\t   $self->element({'Name' => 'Hit_bits',\t\t\t   \n\t\t\t   'Data' => $bits});\t   \n           # we'll store the 1st hsp value as the hit evalue\n\t   $self->element({'Name' => 'Hit_signif',\t\t\t   \n\t\t\t   'Data' => $evalue});\n\t   \n       } elsif( $lasthit ne $hname ) {\n\t   if( $self->in_element('hit') ) {\t       \n\t       $self->end_element({'Name' => 'Hit'});\n\t   }\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $hname});\n\t   # we'll store the 1st hsp bits as the hit bits\n\t   $self->element({'Name' => 'Hit_bits',\t\t\t   \n\t\t\t   'Data' => $bits});\t   \n           # we'll store the 1st hsp value as the hit evalue\n\t   $self->element({'Name' => 'Hit_signif',\t\t\t   \n\t\t\t   'Data' => $evalue});\n       }\n       my $identical = $hsp_len - $mismatches - $gapsm;\n       $self->start_element({'Name' => 'Hsp'});\n       $self->element({'Name' => 'Hsp_evalue',\t\t\t   \n\t\t       'Data' => $evalue});       \n       $self->element({'Name' => 'Hsp_bit-score',\n\t\t       'Data' => $bits});\n       $self->element({'Name' => 'Hsp_identity',\n\t\t       'Data' => $identical});\n       $self->element({'Name' => 'Hsp_positive',\n\t\t       'Data' => $positives});\n       $self->element({'Name' => 'Hsp_gaps',\n\t\t       'Data' => $gapsm});\n       $self->element({'Name' => 'Hsp_query-from',\n\t\t       'Data' => $qstart});\n       $self->element({'Name' => 'Hsp_query-to',\n\t\t       'Data' => $qend});\n\n       $self->element({'Name' => 'Hsp_hit-from',\n\t\t       'Data' => $hstart });\n       $self->element({'Name' => 'Hsp_hit-to',\n\t\t       'Data' => $hend });\n       $self->element({'Name' => 'Hsp_align-len',\n\t\t       'Data' => $hsp_len});\n       $self->end_element({'Name' => 'Hsp'});\n       $lastquery = $qname;\n       $lasthit   = $hname;\n   }\n   # fencepost\n   if( defined $lasthit && defined $lastquery ) {\n       if( $self->in_element('hit') ) {\n\t   $self->end_element({'Name' => 'Hit'});\n       }\n       $self->end_element({'Name' => 'Result'});\n       return $self->end_document;\n   }\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'","parameters":[{"label":"$self"},{"label":"$data"}],"label":"start_element($self,$data)"}},{"name":"%nm","kind":13,"containerName":null,"line":322},{"line":323,"containerName":null,"kind":13,"name":"%self"},{"line":324,"name":"%self","containerName":null,"kind":13},{"line":325,"name":"%self","containerName":null,"kind":13},{"signature":{"parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: blasttable.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blasttable\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::blasttable - Driver module for SearchIO for parsing NCBI -m 8/9 format\n\n=head1 SYNOPSIS\n\n  # do not use this module directly\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => $file,\n                                 -format => 'blasttable');\n\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis module will support parsing NCBI -m 8 or -m 9 tabular output\nand WU-BLAST -mformat 2 or -mformat 3 tabular output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::blasttable;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\nuse strict;\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::HSP::HSPFactory;\n\n$DefaultProgramName = 'BLASTN';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\n%MAPPING = ( \n\t     'Hsp_bit-score'  => 'HSP-bits',\n\t     'Hsp_score'      => 'HSP-score',\n\t     'Hsp_evalue'     => 'HSP-evalue',\n\t     'Hsp_query-from' => 'HSP-query_start',\n\t     'Hsp_query-to'   => 'HSP-query_end',\n\t     'Hsp_hit-from'   => 'HSP-hit_start',\n\t     'Hsp_hit-to'     => 'HSP-hit_end',\n\t     'Hsp_positive'   => 'HSP-conserved',\n\t     'Hsp_identity'   => 'HSP-identical',\n\t     'Hsp_mismatches' => 'HSP-mismatches',\n\t     'Hsp_qgapblocks' => 'HSP-query_gapblocks',\n\t     'Hsp_hgapblocks' => 'HSP-hit_gapblocks',\n\t     'Hsp_gaps'       => 'HSP-hsp_gaps',\n\t     'Hsp_hitgaps'    => 'HSP-hit_gaps',\n\t     'Hsp_querygaps'  => 'HSP-query_gaps',\n\t     'Hsp_align-len'  => 'HSP-hsp_length',\n\t     'Hsp_query-frame'=> 'HSP-query_frame',\n\t     'Hsp_hit-frame'  => 'HSP-hit_frame',\n\n\t     'Hit_id'        => 'HIT-name',\n\t     'Hit_len'       => 'HIT-length',\n\t     'Hit_accession' => 'HIT-accession',\n\t     'Hit_def'       => 'HIT-description',\n\t     'Hit_signif'    => 'HIT-significance',\n\t     'Hit_score'     => 'HIT-score',\n\t     'Hit_bits'      => 'HIT-bits',\n\n\t     'Result_program'  => 'RESULT-algorithm_name',\n\t     'Result_version'  => 'RESULT-algorithm_version',\n\t     'Result_query-def'=> 'RESULT-query_name',\n\t     'Result_query-len'=> 'RESULT-query_length',\n\t     'Result_query-acc'=> 'RESULT-query_accession',\n\t     'Result_querydesc'=> 'RESULT-query_description',\n\t     'Result_db'       => 'RESULT-database_name',\n\t     'Result_db-len'   => 'RESULT-database_entries',\n\t     'Result_db-let'   => 'RESULT-database_letters',\n\t     );\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blasttable->new();\n Function: Builds a new Bio::SearchIO::blasttable object \n Returns : an instance of Bio::SearchIO::blasttable\n Args    :\n\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n\n    my ($pname) = $self->_rearrange([qw(PROGRAM_NAME)],\n\t\t\t\t    @args);\n    $self->program_name($pname || $DefaultProgramName);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::GenericResult'));\n    $self->_eventHandler->register_factory('hit', Bio::Search::Hit::HitFactory->new(-type => 'Bio::Search::Hit::GenericHit'));\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::GenericHSP'));\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $parser->next_result\n Function: Parse the next result from the data stream\n Returns : L<Bio::Search::Result::ResultI>\n Args    : none\n\n\n\nsub next_result{\n   my ($self) = @_;\n   my ($lastquery,$lasthit);\n   local $/ = \"\\n\";\n   local $_;\n   my ($alg, $ver);\n   while( defined ($_ = $self->_readline) ) {\n\t  # WU-BLAST -mformat 3 only\n\t  if(m{^#\\s((?:\\S+?)?BLAST[NPX])\\s(\\d+\\.\\d+.+\\d{4}\\])}) {\n            ($alg, $ver) = ($1, $2);\n\t\t\t# only one header for whole file with WU-BLAST\n\t\t\t# so $alg and $ver won't get set properly for\n\t\t\t# each result\n\t\t\t$self->program_name($alg) if $alg;\n\t\t\t$self->element({'Name' => 'Result_version',\n\t\t\t\t\t   \t\t'Data' => $ver}) if $ver;\n            next;\n\t  }\n      # -m 9 only\n      elsif(m{^#\\s+((?:\\S+?)?BLAST[NPX])\\s+(.+)}) {\n            ($alg, $ver) = ($1, $2);\n            next;\n       }\n       next if /^#/ || /^\\s*$/;\n\n\t  my @fields = split;\n      next if @fields == 1;\n\t  my ($qname,$hname, $percent_id, $hsp_len, $mismatches,$gapsm,\n\t      $qstart,$qend,$hstart,$hend,$evalue,$bits);\n\t  # WU-BLAST-specific\n\t  my ($num_scores, $raw_score, $identities, $positives, $percent_pos,\n\t      $qgap_blocks,$qgaps, $sgap_blocks, $sgaps, $qframe,\n\t      $sframe);\n\t  # NCBI -m8 and -m9\n\t  if (@fields == 12) {\n\t      ($qname,$hname, $percent_id, $hsp_len, $mismatches,$gapsm,\n\t       $qstart,$qend,$hstart,$hend,$evalue,$bits) = @fields;\n\t  # NCBI -m8 and -m9, v 2.2.18+\n\t  } elsif (@fields == 13) {\n          ($qname, $hname, $percent_id, $percent_pos, $hsp_len, $mismatches, $gapsm,\n\t       $qstart,$qend,$hstart,$hend,$evalue,$bits) = @fields;\n      }\n\t  # WU-BLAST -mformat 2 and 3\n\t  elsif ((@fields == 22) or (@fields == 24)) {\n\t      ($qname,$hname,$evalue,$num_scores, $bits, $raw_score, $hsp_len,\n\t       $identities, $positives,$mismatches, $percent_id, $percent_pos,\n\t       $qgap_blocks, $qgaps, $sgap_blocks, $sgaps, $qframe, $qstart,\n\t       $qend, $sframe, $hstart,$hend,) = @fields;\n\t      # we need total gaps in the alignment\n\t      $gapsm=$qgaps+$sgaps;\n\t  }\n\n       # Remember Jim's code is 0 based\n       if( defined $lastquery && \n\t   $lastquery ne $qname ) {\n\t   $self->end_element({'Name' => 'Hit'});\n\t   $self->end_element({'Name' => 'Result'});\n\t   $self->_pushback($_);\n\t   return $self->end_document;\n       } elsif( ! defined $lastquery ) {\n\t   $self->{'_result_count'}++;\n\t   $self->start_element({'Name' => 'Result'});\n\t   $self->element({'Name' => 'Result_program',\n\t\t\t   'Data' => $alg || $self->program_name});\n       $self->element({'Name' => 'Result_version',\n\t\t\t   'Data' => $ver}) if $ver;\n\t   $self->element({'Name' => 'Result_query-def',\n\t\t\t   'Data' => $qname});\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $hname});\n\t   # we'll store the 1st hsp bits as the hit bits\n\t   $self->element({'Name' => 'Hit_bits',\t\t\t   \n\t\t\t   'Data' => $bits});\t   \n           # we'll store the 1st hsp value as the hit evalue\n\t   $self->element({'Name' => 'Hit_signif',\t\t\t   \n\t\t\t   'Data' => $evalue});\n\t   \n       } elsif( $lasthit ne $hname ) {\n\t   if( $self->in_element('hit') ) {\t       \n\t       $self->end_element({'Name' => 'Hit'});\n\t   }\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $hname});\n\t   # we'll store the 1st hsp bits as the hit bits\n\t   $self->element({'Name' => 'Hit_bits',\t\t\t   \n\t\t\t   'Data' => $bits});\t   \n           # we'll store the 1st hsp value as the hit evalue\n\t   $self->element({'Name' => 'Hit_signif',\t\t\t   \n\t\t\t   'Data' => $evalue});\n       }\n       my $identical = $hsp_len - $mismatches - $gapsm;\n       $self->start_element({'Name' => 'Hsp'});\n       $self->element({'Name' => 'Hsp_evalue',\t\t\t   \n\t\t       'Data' => $evalue});       \n       $self->element({'Name' => 'Hsp_bit-score',\n\t\t       'Data' => $bits});\n       $self->element({'Name' => 'Hsp_identity',\n\t\t       'Data' => $identical});\n       $self->element({'Name' => 'Hsp_positive',\n\t\t       'Data' => $positives});\n       $self->element({'Name' => 'Hsp_gaps',\n\t\t       'Data' => $gapsm});\n       $self->element({'Name' => 'Hsp_query-from',\n\t\t       'Data' => $qstart});\n       $self->element({'Name' => 'Hsp_query-to',\n\t\t       'Data' => $qend});\n\n       $self->element({'Name' => 'Hsp_hit-from',\n\t\t       'Data' => $hstart });\n       $self->element({'Name' => 'Hsp_hit-to',\n\t\t       'Data' => $hend });\n       $self->element({'Name' => 'Hsp_align-len',\n\t\t       'Data' => $hsp_len});\n       $self->end_element({'Name' => 'Hsp'});\n       $lastquery = $qname;\n       $lasthit   = $hname;\n   }\n   # fencepost\n   if( defined $lasthit && defined $lastquery ) {\n       if( $self->in_element('hit') ) {\n\t   $self->end_element({'Name' => 'Hit'});\n       }\n       $self->end_element({'Name' => 'Result'});\n       return $self->end_document;\n   }\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'Result') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'","label":"end_element($self,$data)"},"line":341,"kind":12,"range":{"end":{"character":9999,"line":356},"start":{"character":0,"line":341}},"definition":"sub","detail":"($self,$data)","children":[{"definition":"my","line":342,"kind":13,"localvar":"my","containerName":"end_element","name":"$self"},{"line":342,"name":"$data","kind":13,"containerName":"end_element"},{"definition":"my","localvar":"my","kind":13,"containerName":"end_element","name":"$nm","line":343},{"kind":13,"containerName":"end_element","name":"$data","line":343},{"line":344,"containerName":"end_element","localvar":"my","kind":13,"name":"$rc","definition":"my"},{"definition":"my","line":348,"name":"$type","containerName":"end_element","localvar":"my","kind":13},{"line":348,"name":"$MODEMAP","kind":13,"containerName":"end_element"},{"name":"$nm","kind":13,"containerName":"end_element","line":348},{"name":"$self","containerName":"end_element","kind":13,"line":349},{"line":349,"name":"_will_handle","kind":12,"containerName":"end_element"},{"line":349,"containerName":"end_element","kind":13,"name":"$type"},{"line":350,"localvar":"my","kind":13,"containerName":"end_element","name":"$func","definition":"my"},{"containerName":"end_element","kind":13,"name":"$type","line":350},{"containerName":"end_element","kind":13,"name":"$rc","line":351},{"line":351,"name":"$self","containerName":"end_element","kind":13},{"line":351,"kind":12,"containerName":"end_element","name":"_eventHandler"},{"containerName":"end_element","kind":13,"name":"$func","line":351},{"containerName":"end_element","kind":13,"name":"$self","line":351},{"name":"$self","containerName":"end_element","kind":13,"line":352},{"kind":13,"containerName":"end_element","name":"$self","line":354}],"containerName":"main::","name":"end_element"},{"name":"%MAPPING","containerName":null,"kind":13,"line":356},{"line":356,"kind":13,"containerName":null,"name":"%nm"},{"line":357,"containerName":null,"kind":13,"name":"%MAPPING"},{"line":357,"kind":13,"containerName":null,"name":"%nm"},{"name":"$key","localvar":"my","containerName":null,"kind":13,"line":358,"definition":"my"},{"name":"%MAPPING","containerName":null,"kind":13,"line":358},{"name":"@nm","containerName":null,"kind":13,"line":358},{"line":359,"containerName":null,"kind":13,"name":"%self"},{"kind":13,"containerName":null,"name":"%key","line":359},{"line":359,"containerName":null,"kind":13,"name":"%MAPPING"},{"kind":13,"containerName":null,"name":"%nm","line":359},{"line":359,"name":"$key","containerName":null,"kind":13},{"line":359,"name":"%self","kind":13,"containerName":null},{"line":361,"containerName":null,"kind":13,"name":"%self"},{"containerName":null,"kind":13,"name":"%MAPPING","line":361},{"line":361,"kind":13,"containerName":null,"name":"$nm"},{"line":361,"name":"%self","containerName":null,"kind":13},{"name":"$self","containerName":null,"kind":13,"line":364},{"line":364,"kind":12,"containerName":"main::","name":"warn"},{"containerName":null,"kind":13,"name":"%self","line":366},{"line":368,"kind":13,"containerName":null,"name":"%self"},{"containerName":null,"kind":13,"name":"$rc","line":368},{"name":"$nm","containerName":null,"kind":13,"line":368},{"containerName":null,"kind":13,"name":"$rc","line":369},{"signature":{"label":"element($self,$data)","parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: blasttable.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blasttable\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::blasttable - Driver module for SearchIO for parsing NCBI -m 8/9 format\n\n=head1 SYNOPSIS\n\n  # do not use this module directly\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => $file,\n                                 -format => 'blasttable');\n\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis module will support parsing NCBI -m 8 or -m 9 tabular output\nand WU-BLAST -mformat 2 or -mformat 3 tabular output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::blasttable;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\nuse strict;\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::HSP::HSPFactory;\n\n$DefaultProgramName = 'BLASTN';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\n%MAPPING = ( \n\t     'Hsp_bit-score'  => 'HSP-bits',\n\t     'Hsp_score'      => 'HSP-score',\n\t     'Hsp_evalue'     => 'HSP-evalue',\n\t     'Hsp_query-from' => 'HSP-query_start',\n\t     'Hsp_query-to'   => 'HSP-query_end',\n\t     'Hsp_hit-from'   => 'HSP-hit_start',\n\t     'Hsp_hit-to'     => 'HSP-hit_end',\n\t     'Hsp_positive'   => 'HSP-conserved',\n\t     'Hsp_identity'   => 'HSP-identical',\n\t     'Hsp_mismatches' => 'HSP-mismatches',\n\t     'Hsp_qgapblocks' => 'HSP-query_gapblocks',\n\t     'Hsp_hgapblocks' => 'HSP-hit_gapblocks',\n\t     'Hsp_gaps'       => 'HSP-hsp_gaps',\n\t     'Hsp_hitgaps'    => 'HSP-hit_gaps',\n\t     'Hsp_querygaps'  => 'HSP-query_gaps',\n\t     'Hsp_align-len'  => 'HSP-hsp_length',\n\t     'Hsp_query-frame'=> 'HSP-query_frame',\n\t     'Hsp_hit-frame'  => 'HSP-hit_frame',\n\n\t     'Hit_id'        => 'HIT-name',\n\t     'Hit_len'       => 'HIT-length',\n\t     'Hit_accession' => 'HIT-accession',\n\t     'Hit_def'       => 'HIT-description',\n\t     'Hit_signif'    => 'HIT-significance',\n\t     'Hit_score'     => 'HIT-score',\n\t     'Hit_bits'      => 'HIT-bits',\n\n\t     'Result_program'  => 'RESULT-algorithm_name',\n\t     'Result_version'  => 'RESULT-algorithm_version',\n\t     'Result_query-def'=> 'RESULT-query_name',\n\t     'Result_query-len'=> 'RESULT-query_length',\n\t     'Result_query-acc'=> 'RESULT-query_accession',\n\t     'Result_querydesc'=> 'RESULT-query_description',\n\t     'Result_db'       => 'RESULT-database_name',\n\t     'Result_db-len'   => 'RESULT-database_entries',\n\t     'Result_db-let'   => 'RESULT-database_letters',\n\t     );\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blasttable->new();\n Function: Builds a new Bio::SearchIO::blasttable object \n Returns : an instance of Bio::SearchIO::blasttable\n Args    :\n\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n\n    my ($pname) = $self->_rearrange([qw(PROGRAM_NAME)],\n\t\t\t\t    @args);\n    $self->program_name($pname || $DefaultProgramName);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::GenericResult'));\n    $self->_eventHandler->register_factory('hit', Bio::Search::Hit::HitFactory->new(-type => 'Bio::Search::Hit::GenericHit'));\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::GenericHSP'));\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $parser->next_result\n Function: Parse the next result from the data stream\n Returns : L<Bio::Search::Result::ResultI>\n Args    : none\n\n\n\nsub next_result{\n   my ($self) = @_;\n   my ($lastquery,$lasthit);\n   local $/ = \"\\n\";\n   local $_;\n   my ($alg, $ver);\n   while( defined ($_ = $self->_readline) ) {\n\t  # WU-BLAST -mformat 3 only\n\t  if(m{^#\\s((?:\\S+?)?BLAST[NPX])\\s(\\d+\\.\\d+.+\\d{4}\\])}) {\n            ($alg, $ver) = ($1, $2);\n\t\t\t# only one header for whole file with WU-BLAST\n\t\t\t# so $alg and $ver won't get set properly for\n\t\t\t# each result\n\t\t\t$self->program_name($alg) if $alg;\n\t\t\t$self->element({'Name' => 'Result_version',\n\t\t\t\t\t   \t\t'Data' => $ver}) if $ver;\n            next;\n\t  }\n      # -m 9 only\n      elsif(m{^#\\s+((?:\\S+?)?BLAST[NPX])\\s+(.+)}) {\n            ($alg, $ver) = ($1, $2);\n            next;\n       }\n       next if /^#/ || /^\\s*$/;\n\n\t  my @fields = split;\n      next if @fields == 1;\n\t  my ($qname,$hname, $percent_id, $hsp_len, $mismatches,$gapsm,\n\t      $qstart,$qend,$hstart,$hend,$evalue,$bits);\n\t  # WU-BLAST-specific\n\t  my ($num_scores, $raw_score, $identities, $positives, $percent_pos,\n\t      $qgap_blocks,$qgaps, $sgap_blocks, $sgaps, $qframe,\n\t      $sframe);\n\t  # NCBI -m8 and -m9\n\t  if (@fields == 12) {\n\t      ($qname,$hname, $percent_id, $hsp_len, $mismatches,$gapsm,\n\t       $qstart,$qend,$hstart,$hend,$evalue,$bits) = @fields;\n\t  # NCBI -m8 and -m9, v 2.2.18+\n\t  } elsif (@fields == 13) {\n          ($qname, $hname, $percent_id, $percent_pos, $hsp_len, $mismatches, $gapsm,\n\t       $qstart,$qend,$hstart,$hend,$evalue,$bits) = @fields;\n      }\n\t  # WU-BLAST -mformat 2 and 3\n\t  elsif ((@fields == 22) or (@fields == 24)) {\n\t      ($qname,$hname,$evalue,$num_scores, $bits, $raw_score, $hsp_len,\n\t       $identities, $positives,$mismatches, $percent_id, $percent_pos,\n\t       $qgap_blocks, $qgaps, $sgap_blocks, $sgaps, $qframe, $qstart,\n\t       $qend, $sframe, $hstart,$hend,) = @fields;\n\t      # we need total gaps in the alignment\n\t      $gapsm=$qgaps+$sgaps;\n\t  }\n\n       # Remember Jim's code is 0 based\n       if( defined $lastquery && \n\t   $lastquery ne $qname ) {\n\t   $self->end_element({'Name' => 'Hit'});\n\t   $self->end_element({'Name' => 'Result'});\n\t   $self->_pushback($_);\n\t   return $self->end_document;\n       } elsif( ! defined $lastquery ) {\n\t   $self->{'_result_count'}++;\n\t   $self->start_element({'Name' => 'Result'});\n\t   $self->element({'Name' => 'Result_program',\n\t\t\t   'Data' => $alg || $self->program_name});\n       $self->element({'Name' => 'Result_version',\n\t\t\t   'Data' => $ver}) if $ver;\n\t   $self->element({'Name' => 'Result_query-def',\n\t\t\t   'Data' => $qname});\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $hname});\n\t   # we'll store the 1st hsp bits as the hit bits\n\t   $self->element({'Name' => 'Hit_bits',\t\t\t   \n\t\t\t   'Data' => $bits});\t   \n           # we'll store the 1st hsp value as the hit evalue\n\t   $self->element({'Name' => 'Hit_signif',\t\t\t   \n\t\t\t   'Data' => $evalue});\n\t   \n       } elsif( $lasthit ne $hname ) {\n\t   if( $self->in_element('hit') ) {\t       \n\t       $self->end_element({'Name' => 'Hit'});\n\t   }\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $hname});\n\t   # we'll store the 1st hsp bits as the hit bits\n\t   $self->element({'Name' => 'Hit_bits',\t\t\t   \n\t\t\t   'Data' => $bits});\t   \n           # we'll store the 1st hsp value as the hit evalue\n\t   $self->element({'Name' => 'Hit_signif',\t\t\t   \n\t\t\t   'Data' => $evalue});\n       }\n       my $identical = $hsp_len - $mismatches - $gapsm;\n       $self->start_element({'Name' => 'Hsp'});\n       $self->element({'Name' => 'Hsp_evalue',\t\t\t   \n\t\t       'Data' => $evalue});       \n       $self->element({'Name' => 'Hsp_bit-score',\n\t\t       'Data' => $bits});\n       $self->element({'Name' => 'Hsp_identity',\n\t\t       'Data' => $identical});\n       $self->element({'Name' => 'Hsp_positive',\n\t\t       'Data' => $positives});\n       $self->element({'Name' => 'Hsp_gaps',\n\t\t       'Data' => $gapsm});\n       $self->element({'Name' => 'Hsp_query-from',\n\t\t       'Data' => $qstart});\n       $self->element({'Name' => 'Hsp_query-to',\n\t\t       'Data' => $qend});\n\n       $self->element({'Name' => 'Hsp_hit-from',\n\t\t       'Data' => $hstart });\n       $self->element({'Name' => 'Hsp_hit-to',\n\t\t       'Data' => $hend });\n       $self->element({'Name' => 'Hsp_align-len',\n\t\t       'Data' => $hsp_len});\n       $self->end_element({'Name' => 'Hsp'});\n       $lastquery = $qname;\n       $lasthit   = $hname;\n   }\n   # fencepost\n   if( defined $lasthit && defined $lastquery ) {\n       if( $self->in_element('hit') ) {\n\t   $self->end_element({'Name' => 'Hit'});\n       }\n       $self->end_element({'Name' => 'Result'});\n       return $self->end_document;\n   }\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'Result') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n        \n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'Result' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'"},"range":{"start":{"line":384,"character":0},"end":{"character":9999,"line":389}},"kind":12,"line":384,"detail":"($self,$data)","definition":"sub","name":"element","containerName":"main::","children":[{"line":385,"localvar":"my","kind":13,"containerName":"element","name":"$self","definition":"my"},{"name":"$data","containerName":"element","kind":13,"line":385},{"line":386,"name":"$self","containerName":"element","kind":13},{"kind":12,"containerName":"element","name":"start_element","line":386},{"kind":13,"containerName":"element","name":"$data","line":386},{"line":387,"name":"$self","containerName":"element","kind":13},{"name":"characters","kind":12,"containerName":"element","line":387},{"containerName":"element","kind":13,"name":"$data","line":387},{"name":"$self","containerName":"element","kind":13,"line":388},{"containerName":"element","kind":12,"name":"end_element","line":388},{"name":"$data","kind":13,"containerName":"element","line":388}]},{"line":403,"range":{"end":{"line":430,"character":9999},"start":{"character":0,"line":403}},"kind":12,"signature":{"label":"characters($self,$data)","parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: blasttable.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blasttable\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::blasttable - Driver module for SearchIO for parsing NCBI -m 8/9 format\n\n=head1 SYNOPSIS\n\n  # do not use this module directly\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => $file,\n                                 -format => 'blasttable');\n\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis module will support parsing NCBI -m 8 or -m 9 tabular output\nand WU-BLAST -mformat 2 or -mformat 3 tabular output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::blasttable;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\nuse strict;\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::HSP::HSPFactory;\n\n$DefaultProgramName = 'BLASTN';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\n%MAPPING = ( \n\t     'Hsp_bit-score'  => 'HSP-bits',\n\t     'Hsp_score'      => 'HSP-score',\n\t     'Hsp_evalue'     => 'HSP-evalue',\n\t     'Hsp_query-from' => 'HSP-query_start',\n\t     'Hsp_query-to'   => 'HSP-query_end',\n\t     'Hsp_hit-from'   => 'HSP-hit_start',\n\t     'Hsp_hit-to'     => 'HSP-hit_end',\n\t     'Hsp_positive'   => 'HSP-conserved',\n\t     'Hsp_identity'   => 'HSP-identical',\n\t     'Hsp_mismatches' => 'HSP-mismatches',\n\t     'Hsp_qgapblocks' => 'HSP-query_gapblocks',\n\t     'Hsp_hgapblocks' => 'HSP-hit_gapblocks',\n\t     'Hsp_gaps'       => 'HSP-hsp_gaps',\n\t     'Hsp_hitgaps'    => 'HSP-hit_gaps',\n\t     'Hsp_querygaps'  => 'HSP-query_gaps',\n\t     'Hsp_align-len'  => 'HSP-hsp_length',\n\t     'Hsp_query-frame'=> 'HSP-query_frame',\n\t     'Hsp_hit-frame'  => 'HSP-hit_frame',\n\n\t     'Hit_id'        => 'HIT-name',\n\t     'Hit_len'       => 'HIT-length',\n\t     'Hit_accession' => 'HIT-accession',\n\t     'Hit_def'       => 'HIT-description',\n\t     'Hit_signif'    => 'HIT-significance',\n\t     'Hit_score'     => 'HIT-score',\n\t     'Hit_bits'      => 'HIT-bits',\n\n\t     'Result_program'  => 'RESULT-algorithm_name',\n\t     'Result_version'  => 'RESULT-algorithm_version',\n\t     'Result_query-def'=> 'RESULT-query_name',\n\t     'Result_query-len'=> 'RESULT-query_length',\n\t     'Result_query-acc'=> 'RESULT-query_accession',\n\t     'Result_querydesc'=> 'RESULT-query_description',\n\t     'Result_db'       => 'RESULT-database_name',\n\t     'Result_db-len'   => 'RESULT-database_entries',\n\t     'Result_db-let'   => 'RESULT-database_letters',\n\t     );\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blasttable->new();\n Function: Builds a new Bio::SearchIO::blasttable object \n Returns : an instance of Bio::SearchIO::blasttable\n Args    :\n\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n\n    my ($pname) = $self->_rearrange([qw(PROGRAM_NAME)],\n\t\t\t\t    @args);\n    $self->program_name($pname || $DefaultProgramName);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::GenericResult'));\n    $self->_eventHandler->register_factory('hit', Bio::Search::Hit::HitFactory->new(-type => 'Bio::Search::Hit::GenericHit'));\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::GenericHSP'));\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $parser->next_result\n Function: Parse the next result from the data stream\n Returns : L<Bio::Search::Result::ResultI>\n Args    : none\n\n\n\nsub next_result{\n   my ($self) = @_;\n   my ($lastquery,$lasthit);\n   local $/ = \"\\n\";\n   local $_;\n   my ($alg, $ver);\n   while( defined ($_ = $self->_readline) ) {\n\t  # WU-BLAST -mformat 3 only\n\t  if(m{^#\\s((?:\\S+?)?BLAST[NPX])\\s(\\d+\\.\\d+.+\\d{4}\\])}) {\n            ($alg, $ver) = ($1, $2);\n\t\t\t# only one header for whole file with WU-BLAST\n\t\t\t# so $alg and $ver won't get set properly for\n\t\t\t# each result\n\t\t\t$self->program_name($alg) if $alg;\n\t\t\t$self->element({'Name' => 'Result_version',\n\t\t\t\t\t   \t\t'Data' => $ver}) if $ver;\n            next;\n\t  }\n      # -m 9 only\n      elsif(m{^#\\s+((?:\\S+?)?BLAST[NPX])\\s+(.+)}) {\n            ($alg, $ver) = ($1, $2);\n            next;\n       }\n       next if /^#/ || /^\\s*$/;\n\n\t  my @fields = split;\n      next if @fields == 1;\n\t  my ($qname,$hname, $percent_id, $hsp_len, $mismatches,$gapsm,\n\t      $qstart,$qend,$hstart,$hend,$evalue,$bits);\n\t  # WU-BLAST-specific\n\t  my ($num_scores, $raw_score, $identities, $positives, $percent_pos,\n\t      $qgap_blocks,$qgaps, $sgap_blocks, $sgaps, $qframe,\n\t      $sframe);\n\t  # NCBI -m8 and -m9\n\t  if (@fields == 12) {\n\t      ($qname,$hname, $percent_id, $hsp_len, $mismatches,$gapsm,\n\t       $qstart,$qend,$hstart,$hend,$evalue,$bits) = @fields;\n\t  # NCBI -m8 and -m9, v 2.2.18+\n\t  } elsif (@fields == 13) {\n          ($qname, $hname, $percent_id, $percent_pos, $hsp_len, $mismatches, $gapsm,\n\t       $qstart,$qend,$hstart,$hend,$evalue,$bits) = @fields;\n      }\n\t  # WU-BLAST -mformat 2 and 3\n\t  elsif ((@fields == 22) or (@fields == 24)) {\n\t      ($qname,$hname,$evalue,$num_scores, $bits, $raw_score, $hsp_len,\n\t       $identities, $positives,$mismatches, $percent_id, $percent_pos,\n\t       $qgap_blocks, $qgaps, $sgap_blocks, $sgaps, $qframe, $qstart,\n\t       $qend, $sframe, $hstart,$hend,) = @fields;\n\t      # we need total gaps in the alignment\n\t      $gapsm=$qgaps+$sgaps;\n\t  }\n\n       # Remember Jim's code is 0 based\n       if( defined $lastquery && \n\t   $lastquery ne $qname ) {\n\t   $self->end_element({'Name' => 'Hit'});\n\t   $self->end_element({'Name' => 'Result'});\n\t   $self->_pushback($_);\n\t   return $self->end_document;\n       } elsif( ! defined $lastquery ) {\n\t   $self->{'_result_count'}++;\n\t   $self->start_element({'Name' => 'Result'});\n\t   $self->element({'Name' => 'Result_program',\n\t\t\t   'Data' => $alg || $self->program_name});\n       $self->element({'Name' => 'Result_version',\n\t\t\t   'Data' => $ver}) if $ver;\n\t   $self->element({'Name' => 'Result_query-def',\n\t\t\t   'Data' => $qname});\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $hname});\n\t   # we'll store the 1st hsp bits as the hit bits\n\t   $self->element({'Name' => 'Hit_bits',\t\t\t   \n\t\t\t   'Data' => $bits});\t   \n           # we'll store the 1st hsp value as the hit evalue\n\t   $self->element({'Name' => 'Hit_signif',\t\t\t   \n\t\t\t   'Data' => $evalue});\n\t   \n       } elsif( $lasthit ne $hname ) {\n\t   if( $self->in_element('hit') ) {\t       \n\t       $self->end_element({'Name' => 'Hit'});\n\t   }\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $hname});\n\t   # we'll store the 1st hsp bits as the hit bits\n\t   $self->element({'Name' => 'Hit_bits',\t\t\t   \n\t\t\t   'Data' => $bits});\t   \n           # we'll store the 1st hsp value as the hit evalue\n\t   $self->element({'Name' => 'Hit_signif',\t\t\t   \n\t\t\t   'Data' => $evalue});\n       }\n       my $identical = $hsp_len - $mismatches - $gapsm;\n       $self->start_element({'Name' => 'Hsp'});\n       $self->element({'Name' => 'Hsp_evalue',\t\t\t   \n\t\t       'Data' => $evalue});       \n       $self->element({'Name' => 'Hsp_bit-score',\n\t\t       'Data' => $bits});\n       $self->element({'Name' => 'Hsp_identity',\n\t\t       'Data' => $identical});\n       $self->element({'Name' => 'Hsp_positive',\n\t\t       'Data' => $positives});\n       $self->element({'Name' => 'Hsp_gaps',\n\t\t       'Data' => $gapsm});\n       $self->element({'Name' => 'Hsp_query-from',\n\t\t       'Data' => $qstart});\n       $self->element({'Name' => 'Hsp_query-to',\n\t\t       'Data' => $qend});\n\n       $self->element({'Name' => 'Hsp_hit-from',\n\t\t       'Data' => $hstart });\n       $self->element({'Name' => 'Hsp_hit-to',\n\t\t       'Data' => $hend });\n       $self->element({'Name' => 'Hsp_align-len',\n\t\t       'Data' => $hsp_len});\n       $self->end_element({'Name' => 'Hsp'});\n       $lastquery = $qname;\n       $lasthit   = $hname;\n   }\n   # fencepost\n   if( defined $lasthit && defined $lastquery ) {\n       if( $self->in_element('hit') ) {\n\t   $self->end_element({'Name' => 'Hit'});\n       }\n       $self->end_element({'Name' => 'Result'});\n       return $self->end_document;\n   }\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'Result') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n        \n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'Result' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string"},"children":[{"definition":"my","name":"$self","containerName":"characters","localvar":"my","kind":13,"line":404},{"line":404,"name":"$data","containerName":"characters","kind":13},{"line":414,"name":"$data","kind":13,"containerName":"characters"},{"line":415,"containerName":"characters","kind":13,"name":"$data"},{"kind":13,"containerName":"characters","name":"$self","line":416},{"line":419,"containerName":"characters","kind":13,"name":"$data"},{"name":"$data","containerName":"characters","kind":13,"line":420},{"name":"$self","containerName":"characters","kind":13,"line":423},{"line":423,"name":"in_element","containerName":"characters","kind":12},{"line":424,"name":"$data","kind":13,"containerName":"characters"},{"line":426,"name":"$self","containerName":"characters","kind":13},{"line":426,"name":"$data","containerName":"characters","kind":13},{"name":"$data","containerName":"characters","kind":13,"line":426},{"line":429,"name":"$self","kind":13,"containerName":"characters"},{"name":"$data","kind":13,"containerName":"characters","line":429}],"containerName":"main::","name":"characters","definition":"sub","detail":"($self,$data)"},{"name":"_mode","containerName":"main::","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"_mode","line":445,"definition":"my"},{"line":445,"kind":13,"containerName":"_mode","name":"$value"},{"kind":13,"containerName":"_mode","name":"$value","line":446},{"line":447,"name":"$self","kind":13,"containerName":"_mode"},{"name":"$value","kind":13,"containerName":"_mode","line":447},{"kind":13,"containerName":"_mode","name":"$self","line":449}],"detail":"($self,$value)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":450},"start":{"character":0,"line":444}},"line":444,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: blasttable.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blasttable\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::blasttable - Driver module for SearchIO for parsing NCBI -m 8/9 format\n\n=head1 SYNOPSIS\n\n  # do not use this module directly\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => $file,\n                                 -format => 'blasttable');\n\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis module will support parsing NCBI -m 8 or -m 9 tabular output\nand WU-BLAST -mformat 2 or -mformat 3 tabular output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::blasttable;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\nuse strict;\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::HSP::HSPFactory;\n\n$DefaultProgramName = 'BLASTN';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\n%MAPPING = ( \n\t     'Hsp_bit-score'  => 'HSP-bits',\n\t     'Hsp_score'      => 'HSP-score',\n\t     'Hsp_evalue'     => 'HSP-evalue',\n\t     'Hsp_query-from' => 'HSP-query_start',\n\t     'Hsp_query-to'   => 'HSP-query_end',\n\t     'Hsp_hit-from'   => 'HSP-hit_start',\n\t     'Hsp_hit-to'     => 'HSP-hit_end',\n\t     'Hsp_positive'   => 'HSP-conserved',\n\t     'Hsp_identity'   => 'HSP-identical',\n\t     'Hsp_mismatches' => 'HSP-mismatches',\n\t     'Hsp_qgapblocks' => 'HSP-query_gapblocks',\n\t     'Hsp_hgapblocks' => 'HSP-hit_gapblocks',\n\t     'Hsp_gaps'       => 'HSP-hsp_gaps',\n\t     'Hsp_hitgaps'    => 'HSP-hit_gaps',\n\t     'Hsp_querygaps'  => 'HSP-query_gaps',\n\t     'Hsp_align-len'  => 'HSP-hsp_length',\n\t     'Hsp_query-frame'=> 'HSP-query_frame',\n\t     'Hsp_hit-frame'  => 'HSP-hit_frame',\n\n\t     'Hit_id'        => 'HIT-name',\n\t     'Hit_len'       => 'HIT-length',\n\t     'Hit_accession' => 'HIT-accession',\n\t     'Hit_def'       => 'HIT-description',\n\t     'Hit_signif'    => 'HIT-significance',\n\t     'Hit_score'     => 'HIT-score',\n\t     'Hit_bits'      => 'HIT-bits',\n\n\t     'Result_program'  => 'RESULT-algorithm_name',\n\t     'Result_version'  => 'RESULT-algorithm_version',\n\t     'Result_query-def'=> 'RESULT-query_name',\n\t     'Result_query-len'=> 'RESULT-query_length',\n\t     'Result_query-acc'=> 'RESULT-query_accession',\n\t     'Result_querydesc'=> 'RESULT-query_description',\n\t     'Result_db'       => 'RESULT-database_name',\n\t     'Result_db-len'   => 'RESULT-database_entries',\n\t     'Result_db-let'   => 'RESULT-database_letters',\n\t     );\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blasttable->new();\n Function: Builds a new Bio::SearchIO::blasttable object \n Returns : an instance of Bio::SearchIO::blasttable\n Args    :\n\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n\n    my ($pname) = $self->_rearrange([qw(PROGRAM_NAME)],\n\t\t\t\t    @args);\n    $self->program_name($pname || $DefaultProgramName);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::GenericResult'));\n    $self->_eventHandler->register_factory('hit', Bio::Search::Hit::HitFactory->new(-type => 'Bio::Search::Hit::GenericHit'));\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::GenericHSP'));\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $parser->next_result\n Function: Parse the next result from the data stream\n Returns : L<Bio::Search::Result::ResultI>\n Args    : none\n\n\n\nsub next_result{\n   my ($self) = @_;\n   my ($lastquery,$lasthit);\n   local $/ = \"\\n\";\n   local $_;\n   my ($alg, $ver);\n   while( defined ($_ = $self->_readline) ) {\n\t  # WU-BLAST -mformat 3 only\n\t  if(m{^#\\s((?:\\S+?)?BLAST[NPX])\\s(\\d+\\.\\d+.+\\d{4}\\])}) {\n            ($alg, $ver) = ($1, $2);\n\t\t\t# only one header for whole file with WU-BLAST\n\t\t\t# so $alg and $ver won't get set properly for\n\t\t\t# each result\n\t\t\t$self->program_name($alg) if $alg;\n\t\t\t$self->element({'Name' => 'Result_version',\n\t\t\t\t\t   \t\t'Data' => $ver}) if $ver;\n            next;\n\t  }\n      # -m 9 only\n      elsif(m{^#\\s+((?:\\S+?)?BLAST[NPX])\\s+(.+)}) {\n            ($alg, $ver) = ($1, $2);\n            next;\n       }\n       next if /^#/ || /^\\s*$/;\n\n\t  my @fields = split;\n      next if @fields == 1;\n\t  my ($qname,$hname, $percent_id, $hsp_len, $mismatches,$gapsm,\n\t      $qstart,$qend,$hstart,$hend,$evalue,$bits);\n\t  # WU-BLAST-specific\n\t  my ($num_scores, $raw_score, $identities, $positives, $percent_pos,\n\t      $qgap_blocks,$qgaps, $sgap_blocks, $sgaps, $qframe,\n\t      $sframe);\n\t  # NCBI -m8 and -m9\n\t  if (@fields == 12) {\n\t      ($qname,$hname, $percent_id, $hsp_len, $mismatches,$gapsm,\n\t       $qstart,$qend,$hstart,$hend,$evalue,$bits) = @fields;\n\t  # NCBI -m8 and -m9, v 2.2.18+\n\t  } elsif (@fields == 13) {\n          ($qname, $hname, $percent_id, $percent_pos, $hsp_len, $mismatches, $gapsm,\n\t       $qstart,$qend,$hstart,$hend,$evalue,$bits) = @fields;\n      }\n\t  # WU-BLAST -mformat 2 and 3\n\t  elsif ((@fields == 22) or (@fields == 24)) {\n\t      ($qname,$hname,$evalue,$num_scores, $bits, $raw_score, $hsp_len,\n\t       $identities, $positives,$mismatches, $percent_id, $percent_pos,\n\t       $qgap_blocks, $qgaps, $sgap_blocks, $sgaps, $qframe, $qstart,\n\t       $qend, $sframe, $hstart,$hend,) = @fields;\n\t      # we need total gaps in the alignment\n\t      $gapsm=$qgaps+$sgaps;\n\t  }\n\n       # Remember Jim's code is 0 based\n       if( defined $lastquery && \n\t   $lastquery ne $qname ) {\n\t   $self->end_element({'Name' => 'Hit'});\n\t   $self->end_element({'Name' => 'Result'});\n\t   $self->_pushback($_);\n\t   return $self->end_document;\n       } elsif( ! defined $lastquery ) {\n\t   $self->{'_result_count'}++;\n\t   $self->start_element({'Name' => 'Result'});\n\t   $self->element({'Name' => 'Result_program',\n\t\t\t   'Data' => $alg || $self->program_name});\n       $self->element({'Name' => 'Result_version',\n\t\t\t   'Data' => $ver}) if $ver;\n\t   $self->element({'Name' => 'Result_query-def',\n\t\t\t   'Data' => $qname});\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $hname});\n\t   # we'll store the 1st hsp bits as the hit bits\n\t   $self->element({'Name' => 'Hit_bits',\t\t\t   \n\t\t\t   'Data' => $bits});\t   \n           # we'll store the 1st hsp value as the hit evalue\n\t   $self->element({'Name' => 'Hit_signif',\t\t\t   \n\t\t\t   'Data' => $evalue});\n\t   \n       } elsif( $lasthit ne $hname ) {\n\t   if( $self->in_element('hit') ) {\t       \n\t       $self->end_element({'Name' => 'Hit'});\n\t   }\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $hname});\n\t   # we'll store the 1st hsp bits as the hit bits\n\t   $self->element({'Name' => 'Hit_bits',\t\t\t   \n\t\t\t   'Data' => $bits});\t   \n           # we'll store the 1st hsp value as the hit evalue\n\t   $self->element({'Name' => 'Hit_signif',\t\t\t   \n\t\t\t   'Data' => $evalue});\n       }\n       my $identical = $hsp_len - $mismatches - $gapsm;\n       $self->start_element({'Name' => 'Hsp'});\n       $self->element({'Name' => 'Hsp_evalue',\t\t\t   \n\t\t       'Data' => $evalue});       \n       $self->element({'Name' => 'Hsp_bit-score',\n\t\t       'Data' => $bits});\n       $self->element({'Name' => 'Hsp_identity',\n\t\t       'Data' => $identical});\n       $self->element({'Name' => 'Hsp_positive',\n\t\t       'Data' => $positives});\n       $self->element({'Name' => 'Hsp_gaps',\n\t\t       'Data' => $gapsm});\n       $self->element({'Name' => 'Hsp_query-from',\n\t\t       'Data' => $qstart});\n       $self->element({'Name' => 'Hsp_query-to',\n\t\t       'Data' => $qend});\n\n       $self->element({'Name' => 'Hsp_hit-from',\n\t\t       'Data' => $hstart });\n       $self->element({'Name' => 'Hsp_hit-to',\n\t\t       'Data' => $hend });\n       $self->element({'Name' => 'Hsp_align-len',\n\t\t       'Data' => $hsp_len});\n       $self->end_element({'Name' => 'Hsp'});\n       $lastquery = $qname;\n       $lasthit   = $hname;\n   }\n   # fencepost\n   if( defined $lasthit && defined $lastquery ) {\n       if( $self->in_element('hit') ) {\n\t   $self->end_element({'Name' => 'Hit'});\n       }\n       $self->end_element({'Name' => 'Result'});\n       return $self->end_document;\n   }\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'Result') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n        \n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'Result' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;   \n\n# deep bug fix: set $self->{'_last_data'} to undef if $$data{Data} is \n# a valid slot, whose value is undef --\n# allows an undef to be propagated to object constructors and\n# handled there as desired; in particular, when Hsp_postive => -conserved\n# is not defined (in BLASTN, e.g.), the value of hsp's {CONSERVED} property is \n# set to the value of {IDENTICAL}.\n#/maj\n#   return unless ( defined $data->{'Data'} ); \n   return unless ( grep /Data/, keys %$data );\n   if ( !defined $data->{'Data'} ) {\n       $self->{'_last_data'} = undef;\n       return;\n   }\n   if( $data->{'Data'} =~ /^\\s+$/ ) {\n       return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n   }\n\n   if( $self->in_element('hsp') && \n       $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ ) {\n       \n       $self->{'_last_hspdata'}->{$data->{'Name'}} .= $data->{'Data'};\n   }  \n   \n   $self->{'_last_data'} = $data->{'Data'}; \n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)","label":"_mode($self,$value)"}},{"kind":12,"range":{"end":{"line":469,"character":9999},"start":{"character":0,"line":465}},"line":465,"signature":{"parameters":[{"label":"$self"},{"label":"$name"}],"documentation":"1;\n# $Id: blasttable.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blasttable\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::blasttable - Driver module for SearchIO for parsing NCBI -m 8/9 format\n\n=head1 SYNOPSIS\n\n  # do not use this module directly\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => $file,\n                                 -format => 'blasttable');\n\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis module will support parsing NCBI -m 8 or -m 9 tabular output\nand WU-BLAST -mformat 2 or -mformat 3 tabular output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::blasttable;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\nuse strict;\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::HSP::HSPFactory;\n\n$DefaultProgramName = 'BLASTN';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\n%MAPPING = ( \n\t     'Hsp_bit-score'  => 'HSP-bits',\n\t     'Hsp_score'      => 'HSP-score',\n\t     'Hsp_evalue'     => 'HSP-evalue',\n\t     'Hsp_query-from' => 'HSP-query_start',\n\t     'Hsp_query-to'   => 'HSP-query_end',\n\t     'Hsp_hit-from'   => 'HSP-hit_start',\n\t     'Hsp_hit-to'     => 'HSP-hit_end',\n\t     'Hsp_positive'   => 'HSP-conserved',\n\t     'Hsp_identity'   => 'HSP-identical',\n\t     'Hsp_mismatches' => 'HSP-mismatches',\n\t     'Hsp_qgapblocks' => 'HSP-query_gapblocks',\n\t     'Hsp_hgapblocks' => 'HSP-hit_gapblocks',\n\t     'Hsp_gaps'       => 'HSP-hsp_gaps',\n\t     'Hsp_hitgaps'    => 'HSP-hit_gaps',\n\t     'Hsp_querygaps'  => 'HSP-query_gaps',\n\t     'Hsp_align-len'  => 'HSP-hsp_length',\n\t     'Hsp_query-frame'=> 'HSP-query_frame',\n\t     'Hsp_hit-frame'  => 'HSP-hit_frame',\n\n\t     'Hit_id'        => 'HIT-name',\n\t     'Hit_len'       => 'HIT-length',\n\t     'Hit_accession' => 'HIT-accession',\n\t     'Hit_def'       => 'HIT-description',\n\t     'Hit_signif'    => 'HIT-significance',\n\t     'Hit_score'     => 'HIT-score',\n\t     'Hit_bits'      => 'HIT-bits',\n\n\t     'Result_program'  => 'RESULT-algorithm_name',\n\t     'Result_version'  => 'RESULT-algorithm_version',\n\t     'Result_query-def'=> 'RESULT-query_name',\n\t     'Result_query-len'=> 'RESULT-query_length',\n\t     'Result_query-acc'=> 'RESULT-query_accession',\n\t     'Result_querydesc'=> 'RESULT-query_description',\n\t     'Result_db'       => 'RESULT-database_name',\n\t     'Result_db-len'   => 'RESULT-database_entries',\n\t     'Result_db-let'   => 'RESULT-database_letters',\n\t     );\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blasttable->new();\n Function: Builds a new Bio::SearchIO::blasttable object \n Returns : an instance of Bio::SearchIO::blasttable\n Args    :\n\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n\n    my ($pname) = $self->_rearrange([qw(PROGRAM_NAME)],\n\t\t\t\t    @args);\n    $self->program_name($pname || $DefaultProgramName);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::GenericResult'));\n    $self->_eventHandler->register_factory('hit', Bio::Search::Hit::HitFactory->new(-type => 'Bio::Search::Hit::GenericHit'));\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::GenericHSP'));\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $parser->next_result\n Function: Parse the next result from the data stream\n Returns : L<Bio::Search::Result::ResultI>\n Args    : none\n\n\n\nsub next_result{\n   my ($self) = @_;\n   my ($lastquery,$lasthit);\n   local $/ = \"\\n\";\n   local $_;\n   my ($alg, $ver);\n   while( defined ($_ = $self->_readline) ) {\n\t  # WU-BLAST -mformat 3 only\n\t  if(m{^#\\s((?:\\S+?)?BLAST[NPX])\\s(\\d+\\.\\d+.+\\d{4}\\])}) {\n            ($alg, $ver) = ($1, $2);\n\t\t\t# only one header for whole file with WU-BLAST\n\t\t\t# so $alg and $ver won't get set properly for\n\t\t\t# each result\n\t\t\t$self->program_name($alg) if $alg;\n\t\t\t$self->element({'Name' => 'Result_version',\n\t\t\t\t\t   \t\t'Data' => $ver}) if $ver;\n            next;\n\t  }\n      # -m 9 only\n      elsif(m{^#\\s+((?:\\S+?)?BLAST[NPX])\\s+(.+)}) {\n            ($alg, $ver) = ($1, $2);\n            next;\n       }\n       next if /^#/ || /^\\s*$/;\n\n\t  my @fields = split;\n      next if @fields == 1;\n\t  my ($qname,$hname, $percent_id, $hsp_len, $mismatches,$gapsm,\n\t      $qstart,$qend,$hstart,$hend,$evalue,$bits);\n\t  # WU-BLAST-specific\n\t  my ($num_scores, $raw_score, $identities, $positives, $percent_pos,\n\t      $qgap_blocks,$qgaps, $sgap_blocks, $sgaps, $qframe,\n\t      $sframe);\n\t  # NCBI -m8 and -m9\n\t  if (@fields == 12) {\n\t      ($qname,$hname, $percent_id, $hsp_len, $mismatches,$gapsm,\n\t       $qstart,$qend,$hstart,$hend,$evalue,$bits) = @fields;\n\t  # NCBI -m8 and -m9, v 2.2.18+\n\t  } elsif (@fields == 13) {\n          ($qname, $hname, $percent_id, $percent_pos, $hsp_len, $mismatches, $gapsm,\n\t       $qstart,$qend,$hstart,$hend,$evalue,$bits) = @fields;\n      }\n\t  # WU-BLAST -mformat 2 and 3\n\t  elsif ((@fields == 22) or (@fields == 24)) {\n\t      ($qname,$hname,$evalue,$num_scores, $bits, $raw_score, $hsp_len,\n\t       $identities, $positives,$mismatches, $percent_id, $percent_pos,\n\t       $qgap_blocks, $qgaps, $sgap_blocks, $sgaps, $qframe, $qstart,\n\t       $qend, $sframe, $hstart,$hend,) = @fields;\n\t      # we need total gaps in the alignment\n\t      $gapsm=$qgaps+$sgaps;\n\t  }\n\n       # Remember Jim's code is 0 based\n       if( defined $lastquery && \n\t   $lastquery ne $qname ) {\n\t   $self->end_element({'Name' => 'Hit'});\n\t   $self->end_element({'Name' => 'Result'});\n\t   $self->_pushback($_);\n\t   return $self->end_document;\n       } elsif( ! defined $lastquery ) {\n\t   $self->{'_result_count'}++;\n\t   $self->start_element({'Name' => 'Result'});\n\t   $self->element({'Name' => 'Result_program',\n\t\t\t   'Data' => $alg || $self->program_name});\n       $self->element({'Name' => 'Result_version',\n\t\t\t   'Data' => $ver}) if $ver;\n\t   $self->element({'Name' => 'Result_query-def',\n\t\t\t   'Data' => $qname});\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $hname});\n\t   # we'll store the 1st hsp bits as the hit bits\n\t   $self->element({'Name' => 'Hit_bits',\t\t\t   \n\t\t\t   'Data' => $bits});\t   \n           # we'll store the 1st hsp value as the hit evalue\n\t   $self->element({'Name' => 'Hit_signif',\t\t\t   \n\t\t\t   'Data' => $evalue});\n\t   \n       } elsif( $lasthit ne $hname ) {\n\t   if( $self->in_element('hit') ) {\t       \n\t       $self->end_element({'Name' => 'Hit'});\n\t   }\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $hname});\n\t   # we'll store the 1st hsp bits as the hit bits\n\t   $self->element({'Name' => 'Hit_bits',\t\t\t   \n\t\t\t   'Data' => $bits});\t   \n           # we'll store the 1st hsp value as the hit evalue\n\t   $self->element({'Name' => 'Hit_signif',\t\t\t   \n\t\t\t   'Data' => $evalue});\n       }\n       my $identical = $hsp_len - $mismatches - $gapsm;\n       $self->start_element({'Name' => 'Hsp'});\n       $self->element({'Name' => 'Hsp_evalue',\t\t\t   \n\t\t       'Data' => $evalue});       \n       $self->element({'Name' => 'Hsp_bit-score',\n\t\t       'Data' => $bits});\n       $self->element({'Name' => 'Hsp_identity',\n\t\t       'Data' => $identical});\n       $self->element({'Name' => 'Hsp_positive',\n\t\t       'Data' => $positives});\n       $self->element({'Name' => 'Hsp_gaps',\n\t\t       'Data' => $gapsm});\n       $self->element({'Name' => 'Hsp_query-from',\n\t\t       'Data' => $qstart});\n       $self->element({'Name' => 'Hsp_query-to',\n\t\t       'Data' => $qend});\n\n       $self->element({'Name' => 'Hsp_hit-from',\n\t\t       'Data' => $hstart });\n       $self->element({'Name' => 'Hsp_hit-to',\n\t\t       'Data' => $hend });\n       $self->element({'Name' => 'Hsp_align-len',\n\t\t       'Data' => $hsp_len});\n       $self->end_element({'Name' => 'Hsp'});\n       $lastquery = $qname;\n       $lasthit   = $hname;\n   }\n   # fencepost\n   if( defined $lasthit && defined $lastquery ) {\n       if( $self->in_element('hit') ) {\n\t   $self->end_element({'Name' => 'Hit'});\n       }\n       $self->end_element({'Name' => 'Result'});\n       return $self->end_document;\n   }\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'Result') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n        \n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'Result' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;   \n\n# deep bug fix: set $self->{'_last_data'} to undef if $$data{Data} is \n# a valid slot, whose value is undef --\n# allows an undef to be propagated to object constructors and\n# handled there as desired; in particular, when Hsp_postive => -conserved\n# is not defined (in BLASTN, e.g.), the value of hsp's {CONSERVED} property is \n# set to the value of {IDENTICAL}.\n#/maj\n#   return unless ( defined $data->{'Data'} ); \n   return unless ( grep /Data/, keys %$data );\n   if ( !defined $data->{'Data'} ) {\n       $self->{'_last_data'} = undef;\n       return;\n   }\n   if( $data->{'Data'} =~ /^\\s+$/ ) {\n       return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n   }\n\n   if( $self->in_element('hsp') && \n       $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ ) {\n       \n       $self->{'_last_hspdata'}->{$data->{'Name'}} .= $data->{'Data'};\n   }  \n   \n   $self->{'_last_data'} = $data->{'Data'}; \n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name ","label":"within_element($self,$name)"},"containerName":"main::","name":"within_element","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"within_element","kind":13,"line":466},{"line":466,"name":"$name","containerName":"within_element","kind":13},{"line":467,"name":"$name","containerName":"within_element","kind":13},{"containerName":"within_element","kind":13,"name":"$self","line":468},{"kind":13,"containerName":"within_element","name":"$self","line":469}],"detail":"($self,$name)","definition":"sub"},{"line":470,"kind":13,"containerName":null,"name":"%self"},{"line":471,"name":"%name","containerName":null,"kind":13},{"name":"in_element","containerName":"main::","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"in_element","line":492},{"line":492,"containerName":"in_element","kind":13,"name":"$name"},{"line":493,"kind":13,"containerName":"in_element","name":"$self"},{"name":"$self","containerName":"in_element","kind":13,"line":494},{"line":494,"kind":13,"containerName":"in_element","name":"$name"}],"detail":"($self,$name)","definition":"sub","range":{"start":{"character":0,"line":491},"end":{"character":9999,"line":495}},"kind":12,"line":491,"signature":{"label":"in_element($self,$name)","documentation":"1;\n# $Id: blasttable.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blasttable\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::blasttable - Driver module for SearchIO for parsing NCBI -m 8/9 format\n\n=head1 SYNOPSIS\n\n  # do not use this module directly\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => $file,\n                                 -format => 'blasttable');\n\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis module will support parsing NCBI -m 8 or -m 9 tabular output\nand WU-BLAST -mformat 2 or -mformat 3 tabular output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::blasttable;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\nuse strict;\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::HSP::HSPFactory;\n\n$DefaultProgramName = 'BLASTN';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\n%MAPPING = ( \n\t     'Hsp_bit-score'  => 'HSP-bits',\n\t     'Hsp_score'      => 'HSP-score',\n\t     'Hsp_evalue'     => 'HSP-evalue',\n\t     'Hsp_query-from' => 'HSP-query_start',\n\t     'Hsp_query-to'   => 'HSP-query_end',\n\t     'Hsp_hit-from'   => 'HSP-hit_start',\n\t     'Hsp_hit-to'     => 'HSP-hit_end',\n\t     'Hsp_positive'   => 'HSP-conserved',\n\t     'Hsp_identity'   => 'HSP-identical',\n\t     'Hsp_mismatches' => 'HSP-mismatches',\n\t     'Hsp_qgapblocks' => 'HSP-query_gapblocks',\n\t     'Hsp_hgapblocks' => 'HSP-hit_gapblocks',\n\t     'Hsp_gaps'       => 'HSP-hsp_gaps',\n\t     'Hsp_hitgaps'    => 'HSP-hit_gaps',\n\t     'Hsp_querygaps'  => 'HSP-query_gaps',\n\t     'Hsp_align-len'  => 'HSP-hsp_length',\n\t     'Hsp_query-frame'=> 'HSP-query_frame',\n\t     'Hsp_hit-frame'  => 'HSP-hit_frame',\n\n\t     'Hit_id'        => 'HIT-name',\n\t     'Hit_len'       => 'HIT-length',\n\t     'Hit_accession' => 'HIT-accession',\n\t     'Hit_def'       => 'HIT-description',\n\t     'Hit_signif'    => 'HIT-significance',\n\t     'Hit_score'     => 'HIT-score',\n\t     'Hit_bits'      => 'HIT-bits',\n\n\t     'Result_program'  => 'RESULT-algorithm_name',\n\t     'Result_version'  => 'RESULT-algorithm_version',\n\t     'Result_query-def'=> 'RESULT-query_name',\n\t     'Result_query-len'=> 'RESULT-query_length',\n\t     'Result_query-acc'=> 'RESULT-query_accession',\n\t     'Result_querydesc'=> 'RESULT-query_description',\n\t     'Result_db'       => 'RESULT-database_name',\n\t     'Result_db-len'   => 'RESULT-database_entries',\n\t     'Result_db-let'   => 'RESULT-database_letters',\n\t     );\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blasttable->new();\n Function: Builds a new Bio::SearchIO::blasttable object \n Returns : an instance of Bio::SearchIO::blasttable\n Args    :\n\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n\n    my ($pname) = $self->_rearrange([qw(PROGRAM_NAME)],\n\t\t\t\t    @args);\n    $self->program_name($pname || $DefaultProgramName);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::GenericResult'));\n    $self->_eventHandler->register_factory('hit', Bio::Search::Hit::HitFactory->new(-type => 'Bio::Search::Hit::GenericHit'));\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::GenericHSP'));\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $parser->next_result\n Function: Parse the next result from the data stream\n Returns : L<Bio::Search::Result::ResultI>\n Args    : none\n\n\n\nsub next_result{\n   my ($self) = @_;\n   my ($lastquery,$lasthit);\n   local $/ = \"\\n\";\n   local $_;\n   my ($alg, $ver);\n   while( defined ($_ = $self->_readline) ) {\n\t  # WU-BLAST -mformat 3 only\n\t  if(m{^#\\s((?:\\S+?)?BLAST[NPX])\\s(\\d+\\.\\d+.+\\d{4}\\])}) {\n            ($alg, $ver) = ($1, $2);\n\t\t\t# only one header for whole file with WU-BLAST\n\t\t\t# so $alg and $ver won't get set properly for\n\t\t\t# each result\n\t\t\t$self->program_name($alg) if $alg;\n\t\t\t$self->element({'Name' => 'Result_version',\n\t\t\t\t\t   \t\t'Data' => $ver}) if $ver;\n            next;\n\t  }\n      # -m 9 only\n      elsif(m{^#\\s+((?:\\S+?)?BLAST[NPX])\\s+(.+)}) {\n            ($alg, $ver) = ($1, $2);\n            next;\n       }\n       next if /^#/ || /^\\s*$/;\n\n\t  my @fields = split;\n      next if @fields == 1;\n\t  my ($qname,$hname, $percent_id, $hsp_len, $mismatches,$gapsm,\n\t      $qstart,$qend,$hstart,$hend,$evalue,$bits);\n\t  # WU-BLAST-specific\n\t  my ($num_scores, $raw_score, $identities, $positives, $percent_pos,\n\t      $qgap_blocks,$qgaps, $sgap_blocks, $sgaps, $qframe,\n\t      $sframe);\n\t  # NCBI -m8 and -m9\n\t  if (@fields == 12) {\n\t      ($qname,$hname, $percent_id, $hsp_len, $mismatches,$gapsm,\n\t       $qstart,$qend,$hstart,$hend,$evalue,$bits) = @fields;\n\t  # NCBI -m8 and -m9, v 2.2.18+\n\t  } elsif (@fields == 13) {\n          ($qname, $hname, $percent_id, $percent_pos, $hsp_len, $mismatches, $gapsm,\n\t       $qstart,$qend,$hstart,$hend,$evalue,$bits) = @fields;\n      }\n\t  # WU-BLAST -mformat 2 and 3\n\t  elsif ((@fields == 22) or (@fields == 24)) {\n\t      ($qname,$hname,$evalue,$num_scores, $bits, $raw_score, $hsp_len,\n\t       $identities, $positives,$mismatches, $percent_id, $percent_pos,\n\t       $qgap_blocks, $qgaps, $sgap_blocks, $sgaps, $qframe, $qstart,\n\t       $qend, $sframe, $hstart,$hend,) = @fields;\n\t      # we need total gaps in the alignment\n\t      $gapsm=$qgaps+$sgaps;\n\t  }\n\n       # Remember Jim's code is 0 based\n       if( defined $lastquery && \n\t   $lastquery ne $qname ) {\n\t   $self->end_element({'Name' => 'Hit'});\n\t   $self->end_element({'Name' => 'Result'});\n\t   $self->_pushback($_);\n\t   return $self->end_document;\n       } elsif( ! defined $lastquery ) {\n\t   $self->{'_result_count'}++;\n\t   $self->start_element({'Name' => 'Result'});\n\t   $self->element({'Name' => 'Result_program',\n\t\t\t   'Data' => $alg || $self->program_name});\n       $self->element({'Name' => 'Result_version',\n\t\t\t   'Data' => $ver}) if $ver;\n\t   $self->element({'Name' => 'Result_query-def',\n\t\t\t   'Data' => $qname});\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $hname});\n\t   # we'll store the 1st hsp bits as the hit bits\n\t   $self->element({'Name' => 'Hit_bits',\t\t\t   \n\t\t\t   'Data' => $bits});\t   \n           # we'll store the 1st hsp value as the hit evalue\n\t   $self->element({'Name' => 'Hit_signif',\t\t\t   \n\t\t\t   'Data' => $evalue});\n\t   \n       } elsif( $lasthit ne $hname ) {\n\t   if( $self->in_element('hit') ) {\t       \n\t       $self->end_element({'Name' => 'Hit'});\n\t   }\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $hname});\n\t   # we'll store the 1st hsp bits as the hit bits\n\t   $self->element({'Name' => 'Hit_bits',\t\t\t   \n\t\t\t   'Data' => $bits});\t   \n           # we'll store the 1st hsp value as the hit evalue\n\t   $self->element({'Name' => 'Hit_signif',\t\t\t   \n\t\t\t   'Data' => $evalue});\n       }\n       my $identical = $hsp_len - $mismatches - $gapsm;\n       $self->start_element({'Name' => 'Hsp'});\n       $self->element({'Name' => 'Hsp_evalue',\t\t\t   \n\t\t       'Data' => $evalue});       \n       $self->element({'Name' => 'Hsp_bit-score',\n\t\t       'Data' => $bits});\n       $self->element({'Name' => 'Hsp_identity',\n\t\t       'Data' => $identical});\n       $self->element({'Name' => 'Hsp_positive',\n\t\t       'Data' => $positives});\n       $self->element({'Name' => 'Hsp_gaps',\n\t\t       'Data' => $gapsm});\n       $self->element({'Name' => 'Hsp_query-from',\n\t\t       'Data' => $qstart});\n       $self->element({'Name' => 'Hsp_query-to',\n\t\t       'Data' => $qend});\n\n       $self->element({'Name' => 'Hsp_hit-from',\n\t\t       'Data' => $hstart });\n       $self->element({'Name' => 'Hsp_hit-to',\n\t\t       'Data' => $hend });\n       $self->element({'Name' => 'Hsp_align-len',\n\t\t       'Data' => $hsp_len});\n       $self->end_element({'Name' => 'Hsp'});\n       $lastquery = $qname;\n       $lasthit   = $hname;\n   }\n   # fencepost\n   if( defined $lasthit && defined $lastquery ) {\n       if( $self->in_element('hit') ) {\n\t   $self->end_element({'Name' => 'Hit'});\n       }\n       $self->end_element({'Name' => 'Result'});\n       return $self->end_document;\n   }\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'Result') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n        \n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'Result' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;   \n\n# deep bug fix: set $self->{'_last_data'} to undef if $$data{Data} is \n# a valid slot, whose value is undef --\n# allows an undef to be propagated to object constructors and\n# handled there as desired; in particular, when Hsp_postive => -conserved\n# is not defined (in BLASTN, e.g.), the value of hsp's {CONSERVED} property is \n# set to the value of {IDENTICAL}.\n#/maj\n#   return unless ( defined $data->{'Data'} ); \n   return unless ( grep /Data/, keys %$data );\n   if ( !defined $data->{'Data'} ) {\n       $self->{'_last_data'} = undef;\n       return;\n   }\n   if( $data->{'Data'} =~ /^\\s+$/ ) {\n       return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n   }\n\n   if( $self->in_element('hsp') && \n       $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ ) {\n       \n       $self->{'_last_hspdata'}->{$data->{'Name'}} .= $data->{'Data'};\n   }  \n   \n   $self->{'_last_data'} = $data->{'Data'}; \n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub within_element{\n   my ($self,$name) = @_;  \n   return 0 if ( ! defined $name &&\n\t\t ! defined  $self->{'_elements'} ||\n\t\t scalar @{$self->{'_elements'}} == 0) ;\n   foreach (  @{$self->{'_elements'}} ) {\n       if( $_ eq $name  ) {\n\t   return 1;\n       } \n   }\n   return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name ","parameters":[{"label":"$self"},{"label":"$name"}]}},{"definition":"sub","detail":"($self)","children":[{"definition":"my","line":510,"name":"$self","containerName":"start_document","localvar":"my","kind":13},{"line":511,"name":"$self","kind":13,"containerName":"start_document"},{"line":512,"containerName":"start_document","kind":13,"name":"$self"},{"line":513,"kind":13,"containerName":"start_document","name":"$self"},{"containerName":"start_document","kind":13,"name":"$self","line":514},{"line":515,"kind":13,"containerName":"start_document","name":"$self"}],"name":"start_document","containerName":"main::","signature":{"documentation":"1;\n# $Id: blasttable.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blasttable\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::blasttable - Driver module for SearchIO for parsing NCBI -m 8/9 format\n\n=head1 SYNOPSIS\n\n  # do not use this module directly\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => $file,\n                                 -format => 'blasttable');\n\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis module will support parsing NCBI -m 8 or -m 9 tabular output\nand WU-BLAST -mformat 2 or -mformat 3 tabular output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::blasttable;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\nuse strict;\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::HSP::HSPFactory;\n\n$DefaultProgramName = 'BLASTN';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\n%MAPPING = ( \n\t     'Hsp_bit-score'  => 'HSP-bits',\n\t     'Hsp_score'      => 'HSP-score',\n\t     'Hsp_evalue'     => 'HSP-evalue',\n\t     'Hsp_query-from' => 'HSP-query_start',\n\t     'Hsp_query-to'   => 'HSP-query_end',\n\t     'Hsp_hit-from'   => 'HSP-hit_start',\n\t     'Hsp_hit-to'     => 'HSP-hit_end',\n\t     'Hsp_positive'   => 'HSP-conserved',\n\t     'Hsp_identity'   => 'HSP-identical',\n\t     'Hsp_mismatches' => 'HSP-mismatches',\n\t     'Hsp_qgapblocks' => 'HSP-query_gapblocks',\n\t     'Hsp_hgapblocks' => 'HSP-hit_gapblocks',\n\t     'Hsp_gaps'       => 'HSP-hsp_gaps',\n\t     'Hsp_hitgaps'    => 'HSP-hit_gaps',\n\t     'Hsp_querygaps'  => 'HSP-query_gaps',\n\t     'Hsp_align-len'  => 'HSP-hsp_length',\n\t     'Hsp_query-frame'=> 'HSP-query_frame',\n\t     'Hsp_hit-frame'  => 'HSP-hit_frame',\n\n\t     'Hit_id'        => 'HIT-name',\n\t     'Hit_len'       => 'HIT-length',\n\t     'Hit_accession' => 'HIT-accession',\n\t     'Hit_def'       => 'HIT-description',\n\t     'Hit_signif'    => 'HIT-significance',\n\t     'Hit_score'     => 'HIT-score',\n\t     'Hit_bits'      => 'HIT-bits',\n\n\t     'Result_program'  => 'RESULT-algorithm_name',\n\t     'Result_version'  => 'RESULT-algorithm_version',\n\t     'Result_query-def'=> 'RESULT-query_name',\n\t     'Result_query-len'=> 'RESULT-query_length',\n\t     'Result_query-acc'=> 'RESULT-query_accession',\n\t     'Result_querydesc'=> 'RESULT-query_description',\n\t     'Result_db'       => 'RESULT-database_name',\n\t     'Result_db-len'   => 'RESULT-database_entries',\n\t     'Result_db-let'   => 'RESULT-database_letters',\n\t     );\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blasttable->new();\n Function: Builds a new Bio::SearchIO::blasttable object \n Returns : an instance of Bio::SearchIO::blasttable\n Args    :\n\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n\n    my ($pname) = $self->_rearrange([qw(PROGRAM_NAME)],\n\t\t\t\t    @args);\n    $self->program_name($pname || $DefaultProgramName);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::GenericResult'));\n    $self->_eventHandler->register_factory('hit', Bio::Search::Hit::HitFactory->new(-type => 'Bio::Search::Hit::GenericHit'));\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::GenericHSP'));\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $parser->next_result\n Function: Parse the next result from the data stream\n Returns : L<Bio::Search::Result::ResultI>\n Args    : none\n\n\n\nsub next_result{\n   my ($self) = @_;\n   my ($lastquery,$lasthit);\n   local $/ = \"\\n\";\n   local $_;\n   my ($alg, $ver);\n   while( defined ($_ = $self->_readline) ) {\n\t  # WU-BLAST -mformat 3 only\n\t  if(m{^#\\s((?:\\S+?)?BLAST[NPX])\\s(\\d+\\.\\d+.+\\d{4}\\])}) {\n            ($alg, $ver) = ($1, $2);\n\t\t\t# only one header for whole file with WU-BLAST\n\t\t\t# so $alg and $ver won't get set properly for\n\t\t\t# each result\n\t\t\t$self->program_name($alg) if $alg;\n\t\t\t$self->element({'Name' => 'Result_version',\n\t\t\t\t\t   \t\t'Data' => $ver}) if $ver;\n            next;\n\t  }\n      # -m 9 only\n      elsif(m{^#\\s+((?:\\S+?)?BLAST[NPX])\\s+(.+)}) {\n            ($alg, $ver) = ($1, $2);\n            next;\n       }\n       next if /^#/ || /^\\s*$/;\n\n\t  my @fields = split;\n      next if @fields == 1;\n\t  my ($qname,$hname, $percent_id, $hsp_len, $mismatches,$gapsm,\n\t      $qstart,$qend,$hstart,$hend,$evalue,$bits);\n\t  # WU-BLAST-specific\n\t  my ($num_scores, $raw_score, $identities, $positives, $percent_pos,\n\t      $qgap_blocks,$qgaps, $sgap_blocks, $sgaps, $qframe,\n\t      $sframe);\n\t  # NCBI -m8 and -m9\n\t  if (@fields == 12) {\n\t      ($qname,$hname, $percent_id, $hsp_len, $mismatches,$gapsm,\n\t       $qstart,$qend,$hstart,$hend,$evalue,$bits) = @fields;\n\t  # NCBI -m8 and -m9, v 2.2.18+\n\t  } elsif (@fields == 13) {\n          ($qname, $hname, $percent_id, $percent_pos, $hsp_len, $mismatches, $gapsm,\n\t       $qstart,$qend,$hstart,$hend,$evalue,$bits) = @fields;\n      }\n\t  # WU-BLAST -mformat 2 and 3\n\t  elsif ((@fields == 22) or (@fields == 24)) {\n\t      ($qname,$hname,$evalue,$num_scores, $bits, $raw_score, $hsp_len,\n\t       $identities, $positives,$mismatches, $percent_id, $percent_pos,\n\t       $qgap_blocks, $qgaps, $sgap_blocks, $sgaps, $qframe, $qstart,\n\t       $qend, $sframe, $hstart,$hend,) = @fields;\n\t      # we need total gaps in the alignment\n\t      $gapsm=$qgaps+$sgaps;\n\t  }\n\n       # Remember Jim's code is 0 based\n       if( defined $lastquery && \n\t   $lastquery ne $qname ) {\n\t   $self->end_element({'Name' => 'Hit'});\n\t   $self->end_element({'Name' => 'Result'});\n\t   $self->_pushback($_);\n\t   return $self->end_document;\n       } elsif( ! defined $lastquery ) {\n\t   $self->{'_result_count'}++;\n\t   $self->start_element({'Name' => 'Result'});\n\t   $self->element({'Name' => 'Result_program',\n\t\t\t   'Data' => $alg || $self->program_name});\n       $self->element({'Name' => 'Result_version',\n\t\t\t   'Data' => $ver}) if $ver;\n\t   $self->element({'Name' => 'Result_query-def',\n\t\t\t   'Data' => $qname});\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $hname});\n\t   # we'll store the 1st hsp bits as the hit bits\n\t   $self->element({'Name' => 'Hit_bits',\t\t\t   \n\t\t\t   'Data' => $bits});\t   \n           # we'll store the 1st hsp value as the hit evalue\n\t   $self->element({'Name' => 'Hit_signif',\t\t\t   \n\t\t\t   'Data' => $evalue});\n\t   \n       } elsif( $lasthit ne $hname ) {\n\t   if( $self->in_element('hit') ) {\t       \n\t       $self->end_element({'Name' => 'Hit'});\n\t   }\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $hname});\n\t   # we'll store the 1st hsp bits as the hit bits\n\t   $self->element({'Name' => 'Hit_bits',\t\t\t   \n\t\t\t   'Data' => $bits});\t   \n           # we'll store the 1st hsp value as the hit evalue\n\t   $self->element({'Name' => 'Hit_signif',\t\t\t   \n\t\t\t   'Data' => $evalue});\n       }\n       my $identical = $hsp_len - $mismatches - $gapsm;\n       $self->start_element({'Name' => 'Hsp'});\n       $self->element({'Name' => 'Hsp_evalue',\t\t\t   \n\t\t       'Data' => $evalue});       \n       $self->element({'Name' => 'Hsp_bit-score',\n\t\t       'Data' => $bits});\n       $self->element({'Name' => 'Hsp_identity',\n\t\t       'Data' => $identical});\n       $self->element({'Name' => 'Hsp_positive',\n\t\t       'Data' => $positives});\n       $self->element({'Name' => 'Hsp_gaps',\n\t\t       'Data' => $gapsm});\n       $self->element({'Name' => 'Hsp_query-from',\n\t\t       'Data' => $qstart});\n       $self->element({'Name' => 'Hsp_query-to',\n\t\t       'Data' => $qend});\n\n       $self->element({'Name' => 'Hsp_hit-from',\n\t\t       'Data' => $hstart });\n       $self->element({'Name' => 'Hsp_hit-to',\n\t\t       'Data' => $hend });\n       $self->element({'Name' => 'Hsp_align-len',\n\t\t       'Data' => $hsp_len});\n       $self->end_element({'Name' => 'Hsp'});\n       $lastquery = $qname;\n       $lasthit   = $hname;\n   }\n   # fencepost\n   if( defined $lasthit && defined $lastquery ) {\n       if( $self->in_element('hit') ) {\n\t   $self->end_element({'Name' => 'Hit'});\n       }\n       $self->end_element({'Name' => 'Result'});\n       return $self->end_document;\n   }\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'Result') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n        \n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'Result' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;   \n\n# deep bug fix: set $self->{'_last_data'} to undef if $$data{Data} is \n# a valid slot, whose value is undef --\n# allows an undef to be propagated to object constructors and\n# handled there as desired; in particular, when Hsp_postive => -conserved\n# is not defined (in BLASTN, e.g.), the value of hsp's {CONSERVED} property is \n# set to the value of {IDENTICAL}.\n#/maj\n#   return unless ( defined $data->{'Data'} ); \n   return unless ( grep /Data/, keys %$data );\n   if ( !defined $data->{'Data'} ) {\n       $self->{'_last_data'} = undef;\n       return;\n   }\n   if( $data->{'Data'} =~ /^\\s+$/ ) {\n       return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n   }\n\n   if( $self->in_element('hsp') && \n       $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ ) {\n       \n       $self->{'_last_hspdata'}->{$data->{'Name'}} .= $data->{'Data'};\n   }  \n   \n   $self->{'_last_data'} = $data->{'Data'}; \n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub within_element{\n   my ($self,$name) = @_;  \n   return 0 if ( ! defined $name &&\n\t\t ! defined  $self->{'_elements'} ||\n\t\t scalar @{$self->{'_elements'}} == 0) ;\n   foreach (  @{$self->{'_elements'}} ) {\n       if( $_ eq $name  ) {\n\t   return 1;\n       } \n   }\n   return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub in_element{\n   my ($self,$name) = @_;  \n   return 0 if ! defined $self->{'_elements'}->[0];\n   return ( $self->{'_elements'}->[0] eq $name)\n}\n\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handles a start document event\n Returns : none\n Args    : none","parameters":[{"label":"$self"}],"label":"start_document($self)"},"line":509,"kind":12,"range":{"start":{"line":509,"character":0},"end":{"character":9999,"line":516}}},{"range":{"start":{"line":530,"character":0},"end":{"character":9999,"line":533}},"kind":12,"line":530,"signature":{"label":"end_document($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: blasttable.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blasttable\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::blasttable - Driver module for SearchIO for parsing NCBI -m 8/9 format\n\n=head1 SYNOPSIS\n\n  # do not use this module directly\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => $file,\n                                 -format => 'blasttable');\n\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis module will support parsing NCBI -m 8 or -m 9 tabular output\nand WU-BLAST -mformat 2 or -mformat 3 tabular output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::blasttable;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\nuse strict;\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::HSP::HSPFactory;\n\n$DefaultProgramName = 'BLASTN';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\n%MAPPING = ( \n\t     'Hsp_bit-score'  => 'HSP-bits',\n\t     'Hsp_score'      => 'HSP-score',\n\t     'Hsp_evalue'     => 'HSP-evalue',\n\t     'Hsp_query-from' => 'HSP-query_start',\n\t     'Hsp_query-to'   => 'HSP-query_end',\n\t     'Hsp_hit-from'   => 'HSP-hit_start',\n\t     'Hsp_hit-to'     => 'HSP-hit_end',\n\t     'Hsp_positive'   => 'HSP-conserved',\n\t     'Hsp_identity'   => 'HSP-identical',\n\t     'Hsp_mismatches' => 'HSP-mismatches',\n\t     'Hsp_qgapblocks' => 'HSP-query_gapblocks',\n\t     'Hsp_hgapblocks' => 'HSP-hit_gapblocks',\n\t     'Hsp_gaps'       => 'HSP-hsp_gaps',\n\t     'Hsp_hitgaps'    => 'HSP-hit_gaps',\n\t     'Hsp_querygaps'  => 'HSP-query_gaps',\n\t     'Hsp_align-len'  => 'HSP-hsp_length',\n\t     'Hsp_query-frame'=> 'HSP-query_frame',\n\t     'Hsp_hit-frame'  => 'HSP-hit_frame',\n\n\t     'Hit_id'        => 'HIT-name',\n\t     'Hit_len'       => 'HIT-length',\n\t     'Hit_accession' => 'HIT-accession',\n\t     'Hit_def'       => 'HIT-description',\n\t     'Hit_signif'    => 'HIT-significance',\n\t     'Hit_score'     => 'HIT-score',\n\t     'Hit_bits'      => 'HIT-bits',\n\n\t     'Result_program'  => 'RESULT-algorithm_name',\n\t     'Result_version'  => 'RESULT-algorithm_version',\n\t     'Result_query-def'=> 'RESULT-query_name',\n\t     'Result_query-len'=> 'RESULT-query_length',\n\t     'Result_query-acc'=> 'RESULT-query_accession',\n\t     'Result_querydesc'=> 'RESULT-query_description',\n\t     'Result_db'       => 'RESULT-database_name',\n\t     'Result_db-len'   => 'RESULT-database_entries',\n\t     'Result_db-let'   => 'RESULT-database_letters',\n\t     );\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blasttable->new();\n Function: Builds a new Bio::SearchIO::blasttable object \n Returns : an instance of Bio::SearchIO::blasttable\n Args    :\n\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n\n    my ($pname) = $self->_rearrange([qw(PROGRAM_NAME)],\n\t\t\t\t    @args);\n    $self->program_name($pname || $DefaultProgramName);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::GenericResult'));\n    $self->_eventHandler->register_factory('hit', Bio::Search::Hit::HitFactory->new(-type => 'Bio::Search::Hit::GenericHit'));\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::GenericHSP'));\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $parser->next_result\n Function: Parse the next result from the data stream\n Returns : L<Bio::Search::Result::ResultI>\n Args    : none\n\n\n\nsub next_result{\n   my ($self) = @_;\n   my ($lastquery,$lasthit);\n   local $/ = \"\\n\";\n   local $_;\n   my ($alg, $ver);\n   while( defined ($_ = $self->_readline) ) {\n\t  # WU-BLAST -mformat 3 only\n\t  if(m{^#\\s((?:\\S+?)?BLAST[NPX])\\s(\\d+\\.\\d+.+\\d{4}\\])}) {\n            ($alg, $ver) = ($1, $2);\n\t\t\t# only one header for whole file with WU-BLAST\n\t\t\t# so $alg and $ver won't get set properly for\n\t\t\t# each result\n\t\t\t$self->program_name($alg) if $alg;\n\t\t\t$self->element({'Name' => 'Result_version',\n\t\t\t\t\t   \t\t'Data' => $ver}) if $ver;\n            next;\n\t  }\n      # -m 9 only\n      elsif(m{^#\\s+((?:\\S+?)?BLAST[NPX])\\s+(.+)}) {\n            ($alg, $ver) = ($1, $2);\n            next;\n       }\n       next if /^#/ || /^\\s*$/;\n\n\t  my @fields = split;\n      next if @fields == 1;\n\t  my ($qname,$hname, $percent_id, $hsp_len, $mismatches,$gapsm,\n\t      $qstart,$qend,$hstart,$hend,$evalue,$bits);\n\t  # WU-BLAST-specific\n\t  my ($num_scores, $raw_score, $identities, $positives, $percent_pos,\n\t      $qgap_blocks,$qgaps, $sgap_blocks, $sgaps, $qframe,\n\t      $sframe);\n\t  # NCBI -m8 and -m9\n\t  if (@fields == 12) {\n\t      ($qname,$hname, $percent_id, $hsp_len, $mismatches,$gapsm,\n\t       $qstart,$qend,$hstart,$hend,$evalue,$bits) = @fields;\n\t  # NCBI -m8 and -m9, v 2.2.18+\n\t  } elsif (@fields == 13) {\n          ($qname, $hname, $percent_id, $percent_pos, $hsp_len, $mismatches, $gapsm,\n\t       $qstart,$qend,$hstart,$hend,$evalue,$bits) = @fields;\n      }\n\t  # WU-BLAST -mformat 2 and 3\n\t  elsif ((@fields == 22) or (@fields == 24)) {\n\t      ($qname,$hname,$evalue,$num_scores, $bits, $raw_score, $hsp_len,\n\t       $identities, $positives,$mismatches, $percent_id, $percent_pos,\n\t       $qgap_blocks, $qgaps, $sgap_blocks, $sgaps, $qframe, $qstart,\n\t       $qend, $sframe, $hstart,$hend,) = @fields;\n\t      # we need total gaps in the alignment\n\t      $gapsm=$qgaps+$sgaps;\n\t  }\n\n       # Remember Jim's code is 0 based\n       if( defined $lastquery && \n\t   $lastquery ne $qname ) {\n\t   $self->end_element({'Name' => 'Hit'});\n\t   $self->end_element({'Name' => 'Result'});\n\t   $self->_pushback($_);\n\t   return $self->end_document;\n       } elsif( ! defined $lastquery ) {\n\t   $self->{'_result_count'}++;\n\t   $self->start_element({'Name' => 'Result'});\n\t   $self->element({'Name' => 'Result_program',\n\t\t\t   'Data' => $alg || $self->program_name});\n       $self->element({'Name' => 'Result_version',\n\t\t\t   'Data' => $ver}) if $ver;\n\t   $self->element({'Name' => 'Result_query-def',\n\t\t\t   'Data' => $qname});\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $hname});\n\t   # we'll store the 1st hsp bits as the hit bits\n\t   $self->element({'Name' => 'Hit_bits',\t\t\t   \n\t\t\t   'Data' => $bits});\t   \n           # we'll store the 1st hsp value as the hit evalue\n\t   $self->element({'Name' => 'Hit_signif',\t\t\t   \n\t\t\t   'Data' => $evalue});\n\t   \n       } elsif( $lasthit ne $hname ) {\n\t   if( $self->in_element('hit') ) {\t       \n\t       $self->end_element({'Name' => 'Hit'});\n\t   }\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $hname});\n\t   # we'll store the 1st hsp bits as the hit bits\n\t   $self->element({'Name' => 'Hit_bits',\t\t\t   \n\t\t\t   'Data' => $bits});\t   \n           # we'll store the 1st hsp value as the hit evalue\n\t   $self->element({'Name' => 'Hit_signif',\t\t\t   \n\t\t\t   'Data' => $evalue});\n       }\n       my $identical = $hsp_len - $mismatches - $gapsm;\n       $self->start_element({'Name' => 'Hsp'});\n       $self->element({'Name' => 'Hsp_evalue',\t\t\t   \n\t\t       'Data' => $evalue});       \n       $self->element({'Name' => 'Hsp_bit-score',\n\t\t       'Data' => $bits});\n       $self->element({'Name' => 'Hsp_identity',\n\t\t       'Data' => $identical});\n       $self->element({'Name' => 'Hsp_positive',\n\t\t       'Data' => $positives});\n       $self->element({'Name' => 'Hsp_gaps',\n\t\t       'Data' => $gapsm});\n       $self->element({'Name' => 'Hsp_query-from',\n\t\t       'Data' => $qstart});\n       $self->element({'Name' => 'Hsp_query-to',\n\t\t       'Data' => $qend});\n\n       $self->element({'Name' => 'Hsp_hit-from',\n\t\t       'Data' => $hstart });\n       $self->element({'Name' => 'Hsp_hit-to',\n\t\t       'Data' => $hend });\n       $self->element({'Name' => 'Hsp_align-len',\n\t\t       'Data' => $hsp_len});\n       $self->end_element({'Name' => 'Hsp'});\n       $lastquery = $qname;\n       $lasthit   = $hname;\n   }\n   # fencepost\n   if( defined $lasthit && defined $lastquery ) {\n       if( $self->in_element('hit') ) {\n\t   $self->end_element({'Name' => 'Hit'});\n       }\n       $self->end_element({'Name' => 'Result'});\n       return $self->end_document;\n   }\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'Result') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n        \n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'Result' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;   \n\n# deep bug fix: set $self->{'_last_data'} to undef if $$data{Data} is \n# a valid slot, whose value is undef --\n# allows an undef to be propagated to object constructors and\n# handled there as desired; in particular, when Hsp_postive => -conserved\n# is not defined (in BLASTN, e.g.), the value of hsp's {CONSERVED} property is \n# set to the value of {IDENTICAL}.\n#/maj\n#   return unless ( defined $data->{'Data'} ); \n   return unless ( grep /Data/, keys %$data );\n   if ( !defined $data->{'Data'} ) {\n       $self->{'_last_data'} = undef;\n       return;\n   }\n   if( $data->{'Data'} =~ /^\\s+$/ ) {\n       return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n   }\n\n   if( $self->in_element('hsp') && \n       $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ ) {\n       \n       $self->{'_last_hspdata'}->{$data->{'Name'}} .= $data->{'Data'};\n   }  \n   \n   $self->{'_last_data'} = $data->{'Data'}; \n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub within_element{\n   my ($self,$name) = @_;  \n   return 0 if ( ! defined $name &&\n\t\t ! defined  $self->{'_elements'} ||\n\t\t scalar @{$self->{'_elements'}} == 0) ;\n   foreach (  @{$self->{'_elements'}} ) {\n       if( $_ eq $name  ) {\n\t   return 1;\n       } \n   }\n   return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub in_element{\n   my ($self,$name) = @_;  \n   return 0 if ! defined $self->{'_elements'}->[0];\n   return ( $self->{'_elements'}->[0] eq $name)\n}\n\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handles a start document event\n Returns : none\n Args    : none\n\n\n\nsub start_document{\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'} = {};\n    $self->{'_result'}= undef;\n    $self->{'_mode'} = '';\n    $self->{'_elements'} = [];\n}\n\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $eventgenerator->end_document\n Function: Handles an end document event\n Returns : Bio::Search::Result::ResultI object\n Args    : none"},"containerName":"main::","name":"end_document","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"end_document","line":531},{"line":531,"containerName":"end_document","kind":13,"name":"@args"},{"containerName":"end_document","kind":13,"name":"$self","line":532}],"detail":"($self,@args)","definition":"sub"},{"line":546,"range":{"end":{"line":549,"character":9999},"start":{"line":546,"character":0}},"kind":12,"children":[{"definition":"my","line":547,"name":"$self","kind":13,"localvar":"my","containerName":"result_count"},{"containerName":"result_count","kind":13,"name":"$self","line":548}],"name":"result_count","containerName":"main::","definition":"sub"},{"line":551,"kind":12,"range":{"end":{"line":551,"character":9999},"start":{"line":551,"character":0}},"children":[{"containerName":"report_count","kind":12,"name":"result_count","line":551}],"containerName":"main::","name":"report_count","definition":"sub"},{"name":"program_name","containerName":"main::","children":[{"containerName":"program_name","localvar":"my","kind":13,"name":"$self","line":566,"definition":"my"},{"kind":13,"containerName":"program_name","name":"$self","line":568},{"kind":13,"containerName":"program_name","name":"$self","line":569},{"line":569,"name":"$DefaultProgramName","containerName":"program_name","kind":13}],"definition":"sub","range":{"start":{"line":565,"character":0},"end":{"character":9999,"line":570}},"kind":12,"line":565},{"name":"_will_handle","containerName":"main::","children":[{"line":612,"localvar":"my","kind":13,"containerName":"_will_handle","name":"$self","definition":"my"},{"line":612,"name":"$type","kind":13,"containerName":"_will_handle"},{"definition":"my","kind":13,"localvar":"my","containerName":"_will_handle","name":"$handler","line":613},{"name":"$self","containerName":"_will_handle","kind":13,"line":613},{"definition":"my","localvar":"my","containerName":"_will_handle","kind":13,"name":"$will_handle","line":614},{"name":"$self","kind":13,"containerName":"_will_handle","line":614},{"line":614,"name":"$type","containerName":"_will_handle","kind":13},{"kind":13,"containerName":"_will_handle","name":"$self","line":615},{"kind":13,"containerName":"_will_handle","name":"$type","line":615},{"line":616,"name":"$self","containerName":"_will_handle","kind":13},{"kind":13,"containerName":"_will_handle","name":"$type","line":616},{"name":"$handler","containerName":"_will_handle","kind":13,"line":617},{"line":617,"name":"will_handle","containerName":"_will_handle","kind":12},{"line":617,"name":"$type","containerName":"_will_handle","kind":13},{"line":619,"containerName":"_will_handle","kind":13,"name":"$will_handle"},{"kind":13,"containerName":"_will_handle","name":"$handler","line":619}],"detail":"($self,$type)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":620},"start":{"character":0,"line":611}},"line":611,"signature":{"parameters":[{"label":"$self"},{"label":"$type"}],"documentation":"1;\n# $Id: blasttable.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::blasttable\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::blasttable - Driver module for SearchIO for parsing NCBI -m 8/9 format\n\n=head1 SYNOPSIS\n\n  # do not use this module directly\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => $file,\n                                 -format => 'blasttable');\n\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis module will support parsing NCBI -m 8 or -m 9 tabular output\nand WU-BLAST -mformat 2 or -mformat 3 tabular output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::blasttable;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\nuse strict;\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::HSP::HSPFactory;\n\n$DefaultProgramName = 'BLASTN';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\n%MAPPING = ( \n\t     'Hsp_bit-score'  => 'HSP-bits',\n\t     'Hsp_score'      => 'HSP-score',\n\t     'Hsp_evalue'     => 'HSP-evalue',\n\t     'Hsp_query-from' => 'HSP-query_start',\n\t     'Hsp_query-to'   => 'HSP-query_end',\n\t     'Hsp_hit-from'   => 'HSP-hit_start',\n\t     'Hsp_hit-to'     => 'HSP-hit_end',\n\t     'Hsp_positive'   => 'HSP-conserved',\n\t     'Hsp_identity'   => 'HSP-identical',\n\t     'Hsp_mismatches' => 'HSP-mismatches',\n\t     'Hsp_qgapblocks' => 'HSP-query_gapblocks',\n\t     'Hsp_hgapblocks' => 'HSP-hit_gapblocks',\n\t     'Hsp_gaps'       => 'HSP-hsp_gaps',\n\t     'Hsp_hitgaps'    => 'HSP-hit_gaps',\n\t     'Hsp_querygaps'  => 'HSP-query_gaps',\n\t     'Hsp_align-len'  => 'HSP-hsp_length',\n\t     'Hsp_query-frame'=> 'HSP-query_frame',\n\t     'Hsp_hit-frame'  => 'HSP-hit_frame',\n\n\t     'Hit_id'        => 'HIT-name',\n\t     'Hit_len'       => 'HIT-length',\n\t     'Hit_accession' => 'HIT-accession',\n\t     'Hit_def'       => 'HIT-description',\n\t     'Hit_signif'    => 'HIT-significance',\n\t     'Hit_score'     => 'HIT-score',\n\t     'Hit_bits'      => 'HIT-bits',\n\n\t     'Result_program'  => 'RESULT-algorithm_name',\n\t     'Result_version'  => 'RESULT-algorithm_version',\n\t     'Result_query-def'=> 'RESULT-query_name',\n\t     'Result_query-len'=> 'RESULT-query_length',\n\t     'Result_query-acc'=> 'RESULT-query_accession',\n\t     'Result_querydesc'=> 'RESULT-query_description',\n\t     'Result_db'       => 'RESULT-database_name',\n\t     'Result_db-len'   => 'RESULT-database_entries',\n\t     'Result_db-let'   => 'RESULT-database_letters',\n\t     );\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blasttable->new();\n Function: Builds a new Bio::SearchIO::blasttable object \n Returns : an instance of Bio::SearchIO::blasttable\n Args    :\n\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n\n    my ($pname) = $self->_rearrange([qw(PROGRAM_NAME)],\n\t\t\t\t    @args);\n    $self->program_name($pname || $DefaultProgramName);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::GenericResult'));\n    $self->_eventHandler->register_factory('hit', Bio::Search::Hit::HitFactory->new(-type => 'Bio::Search::Hit::GenericHit'));\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::GenericHSP'));\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $parser->next_result\n Function: Parse the next result from the data stream\n Returns : L<Bio::Search::Result::ResultI>\n Args    : none\n\n\n\nsub next_result{\n   my ($self) = @_;\n   my ($lastquery,$lasthit);\n   local $/ = \"\\n\";\n   local $_;\n   my ($alg, $ver);\n   while( defined ($_ = $self->_readline) ) {\n\t  # WU-BLAST -mformat 3 only\n\t  if(m{^#\\s((?:\\S+?)?BLAST[NPX])\\s(\\d+\\.\\d+.+\\d{4}\\])}) {\n            ($alg, $ver) = ($1, $2);\n\t\t\t# only one header for whole file with WU-BLAST\n\t\t\t# so $alg and $ver won't get set properly for\n\t\t\t# each result\n\t\t\t$self->program_name($alg) if $alg;\n\t\t\t$self->element({'Name' => 'Result_version',\n\t\t\t\t\t   \t\t'Data' => $ver}) if $ver;\n            next;\n\t  }\n      # -m 9 only\n      elsif(m{^#\\s+((?:\\S+?)?BLAST[NPX])\\s+(.+)}) {\n            ($alg, $ver) = ($1, $2);\n            next;\n       }\n       next if /^#/ || /^\\s*$/;\n\n\t  my @fields = split;\n      next if @fields == 1;\n\t  my ($qname,$hname, $percent_id, $hsp_len, $mismatches,$gapsm,\n\t      $qstart,$qend,$hstart,$hend,$evalue,$bits);\n\t  # WU-BLAST-specific\n\t  my ($num_scores, $raw_score, $identities, $positives, $percent_pos,\n\t      $qgap_blocks,$qgaps, $sgap_blocks, $sgaps, $qframe,\n\t      $sframe);\n\t  # NCBI -m8 and -m9\n\t  if (@fields == 12) {\n\t      ($qname,$hname, $percent_id, $hsp_len, $mismatches,$gapsm,\n\t       $qstart,$qend,$hstart,$hend,$evalue,$bits) = @fields;\n\t  # NCBI -m8 and -m9, v 2.2.18+\n\t  } elsif (@fields == 13) {\n          ($qname, $hname, $percent_id, $percent_pos, $hsp_len, $mismatches, $gapsm,\n\t       $qstart,$qend,$hstart,$hend,$evalue,$bits) = @fields;\n      }\n\t  # WU-BLAST -mformat 2 and 3\n\t  elsif ((@fields == 22) or (@fields == 24)) {\n\t      ($qname,$hname,$evalue,$num_scores, $bits, $raw_score, $hsp_len,\n\t       $identities, $positives,$mismatches, $percent_id, $percent_pos,\n\t       $qgap_blocks, $qgaps, $sgap_blocks, $sgaps, $qframe, $qstart,\n\t       $qend, $sframe, $hstart,$hend,) = @fields;\n\t      # we need total gaps in the alignment\n\t      $gapsm=$qgaps+$sgaps;\n\t  }\n\n       # Remember Jim's code is 0 based\n       if( defined $lastquery && \n\t   $lastquery ne $qname ) {\n\t   $self->end_element({'Name' => 'Hit'});\n\t   $self->end_element({'Name' => 'Result'});\n\t   $self->_pushback($_);\n\t   return $self->end_document;\n       } elsif( ! defined $lastquery ) {\n\t   $self->{'_result_count'}++;\n\t   $self->start_element({'Name' => 'Result'});\n\t   $self->element({'Name' => 'Result_program',\n\t\t\t   'Data' => $alg || $self->program_name});\n       $self->element({'Name' => 'Result_version',\n\t\t\t   'Data' => $ver}) if $ver;\n\t   $self->element({'Name' => 'Result_query-def',\n\t\t\t   'Data' => $qname});\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $hname});\n\t   # we'll store the 1st hsp bits as the hit bits\n\t   $self->element({'Name' => 'Hit_bits',\t\t\t   \n\t\t\t   'Data' => $bits});\t   \n           # we'll store the 1st hsp value as the hit evalue\n\t   $self->element({'Name' => 'Hit_signif',\t\t\t   \n\t\t\t   'Data' => $evalue});\n\t   \n       } elsif( $lasthit ne $hname ) {\n\t   if( $self->in_element('hit') ) {\t       \n\t       $self->end_element({'Name' => 'Hit'});\n\t   }\n\t   $self->start_element({'Name' => 'Hit'});\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $hname});\n\t   # we'll store the 1st hsp bits as the hit bits\n\t   $self->element({'Name' => 'Hit_bits',\t\t\t   \n\t\t\t   'Data' => $bits});\t   \n           # we'll store the 1st hsp value as the hit evalue\n\t   $self->element({'Name' => 'Hit_signif',\t\t\t   \n\t\t\t   'Data' => $evalue});\n       }\n       my $identical = $hsp_len - $mismatches - $gapsm;\n       $self->start_element({'Name' => 'Hsp'});\n       $self->element({'Name' => 'Hsp_evalue',\t\t\t   \n\t\t       'Data' => $evalue});       \n       $self->element({'Name' => 'Hsp_bit-score',\n\t\t       'Data' => $bits});\n       $self->element({'Name' => 'Hsp_identity',\n\t\t       'Data' => $identical});\n       $self->element({'Name' => 'Hsp_positive',\n\t\t       'Data' => $positives});\n       $self->element({'Name' => 'Hsp_gaps',\n\t\t       'Data' => $gapsm});\n       $self->element({'Name' => 'Hsp_query-from',\n\t\t       'Data' => $qstart});\n       $self->element({'Name' => 'Hsp_query-to',\n\t\t       'Data' => $qend});\n\n       $self->element({'Name' => 'Hsp_hit-from',\n\t\t       'Data' => $hstart });\n       $self->element({'Name' => 'Hsp_hit-to',\n\t\t       'Data' => $hend });\n       $self->element({'Name' => 'Hsp_align-len',\n\t\t       'Data' => $hsp_len});\n       $self->end_element({'Name' => 'Hsp'});\n       $lastquery = $qname;\n       $lasthit   = $hname;\n   }\n   # fencepost\n   if( defined $lasthit && defined $lastquery ) {\n       if( $self->in_element('hit') ) {\n\t   $self->end_element({'Name' => 'Hit'});\n       }\n       $self->end_element({'Name' => 'Result'});\n       return $self->end_document;\n   }\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'Result') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n        \n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'Result' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;   \n\n# deep bug fix: set $self->{'_last_data'} to undef if $$data{Data} is \n# a valid slot, whose value is undef --\n# allows an undef to be propagated to object constructors and\n# handled there as desired; in particular, when Hsp_postive => -conserved\n# is not defined (in BLASTN, e.g.), the value of hsp's {CONSERVED} property is \n# set to the value of {IDENTICAL}.\n#/maj\n#   return unless ( defined $data->{'Data'} ); \n   return unless ( grep /Data/, keys %$data );\n   if ( !defined $data->{'Data'} ) {\n       $self->{'_last_data'} = undef;\n       return;\n   }\n   if( $data->{'Data'} =~ /^\\s+$/ ) {\n       return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n   }\n\n   if( $self->in_element('hsp') && \n       $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ ) {\n       \n       $self->{'_last_hspdata'}->{$data->{'Name'}} .= $data->{'Data'};\n   }  \n   \n   $self->{'_last_data'} = $data->{'Data'}; \n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub within_element{\n   my ($self,$name) = @_;  \n   return 0 if ( ! defined $name &&\n\t\t ! defined  $self->{'_elements'} ||\n\t\t scalar @{$self->{'_elements'}} == 0) ;\n   foreach (  @{$self->{'_elements'}} ) {\n       if( $_ eq $name  ) {\n\t   return 1;\n       } \n   }\n   return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub in_element{\n   my ($self,$name) = @_;  \n   return 0 if ! defined $self->{'_elements'}->[0];\n   return ( $self->{'_elements'}->[0] eq $name)\n}\n\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handles a start document event\n Returns : none\n Args    : none\n\n\n\nsub start_document{\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'} = {};\n    $self->{'_result'}= undef;\n    $self->{'_mode'} = '';\n    $self->{'_elements'} = [];\n}\n\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $eventgenerator->end_document\n Function: Handles an end document event\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\n\nsub end_document{\n   my ($self,@args) = @_;\n   return $self->{'_result'};\n}\n\n=head2 result_count\n\n Title   : result_count\n Usage   : my $count = $searchio->result_count\n Function: Returns the number of results we have processed\n Returns : integer\n Args    : none\n\n\n\nsub result_count {\n    my $self = shift;\n    return $self->{'_result_count'};\n}\n\nsub report_count { shift->result_count }\n\n\n=head2 program_name\n\n Title   : program_name\n Usage   : $obj->program_name($newval)\n Function: Get/Set the program name\n Returns : value of program_name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub program_name{\n    my $self = shift;\n\n    $self->{'program_name'} = shift if @_;\n    return $self->{'program_name'} || $DefaultProgramName;\n}\n\n\n=head2 _will_handle\n\n Title   : _will_handle\n Usage   : Private method. For internal use only.\n              if( $self->_will_handle($type) ) { ... }\n Function: Provides an optimized way to check whether or not an element of a \n           given type is to be handled.\n Returns : Reference to EventHandler object if the element type is to be handled.\n           undef if the element type is not to be handled.\n Args    : string containing type of element.\n\nOptimizations:\n\n=over 2\n\n* 1\n\nUsing the cached pointer to the EventHandler to minimize repeated\nlookups.\n\n* 2\n\nCaching the will_handle status for each type that is encountered so\nthat it only need be checked by calling\nhandler-E<gt>will_handle($type) once.\n\n\nThis does not lead to a major savings by itself (only 5-10%).  In\ncombination with other optimizations, or for large parse jobs, the\nsavings good be significant.\n\nTo test against the unoptimized version, remove the parentheses from\naround the third term in the ternary \" ? : \" operator and add two\ncalls to $self-E<gt>_eventHandler().","label":"_will_handle($self,$type)"}}]}