{"version":5,"vars":[{"line":84,"kind":2,"containerName":"","name":"base"},{"definition":"sub","detail":"($class,@args)","children":[{"definition":"my","line":99,"containerName":"new","localvar":"my","kind":13,"name":"$class"},{"kind":13,"containerName":"new","name":"@args","line":99},{"definition":"my","line":101,"name":"$self","kind":13,"localvar":"my","containerName":"new"},{"name":"$class","containerName":"new","kind":13,"line":101},{"line":101,"kind":13,"containerName":"new","name":"@args"},{"line":102,"kind":13,"containerName":"new","name":"$self"}],"containerName":"main::","name":"new","signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: BSMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::Writer::BSMLResultWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::Writer::BSMLResultWriter - BSML output writer\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $in = Bio::SearchIO->new(-file   => 'result.blast',\n                             -format => 'blast');\n  my $out = Bio::SearchIO->new(-output_format  => 'BSMLResultWriter',\n                              -file           => \">result.bsml\");\n  while( my $r = $in->next_result ) {\n    $out->write_result($r);\n  }\n\n=head1 DESCRIPTION\n\nThis is a writer to produce BSML for a search result.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::Writer::BSMLResultWriter;\nuse strict;\n\nuse XML::Writer;\nuse IO::String;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::SearchWriterI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Writer::BSMLResultWriter->new();\n Function: Builds a new Bio::SearchIO::Writer::BSMLResultWriter object \n Returns : an instance of Bio::SearchIO::Writer::BSMLResultWriter\n Args    :","label":"new($class,@args)"},"line":98,"range":{"start":{"character":0,"line":98},"end":{"line":103,"character":9999}},"kind":12},{"name":"SUPER","containerName":"new","kind":12,"line":101},{"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"to_string","line":124,"definition":"my"},{"name":"$result","containerName":"to_string","kind":13,"line":124},{"kind":13,"containerName":"to_string","name":"$num","line":124},{"definition":"my","name":"$str","kind":13,"localvar":"my","containerName":"to_string","line":125},{"definition":"my","line":126,"kind":13,"localvar":"my","containerName":"to_string","name":"$writer"},{"name":"$str","containerName":"to_string","kind":13,"line":126},{"line":129,"name":"$writer","containerName":"to_string","kind":13},{"kind":12,"containerName":"to_string","name":"xmlDecl","line":129},{"line":130,"name":"$writer","containerName":"to_string","kind":13},{"line":130,"name":"doctype","containerName":"to_string","kind":12},{"kind":13,"containerName":"to_string","name":"$writer","line":132},{"name":"startTag","containerName":"to_string","kind":12,"line":132},{"kind":13,"containerName":"to_string","name":"$writer","line":133},{"name":"startTag","containerName":"to_string","kind":12,"line":133},{"line":134,"name":"$writer","containerName":"to_string","kind":13},{"line":134,"name":"startTag","containerName":"to_string","kind":12},{"localvar":"my","containerName":"to_string","kind":13,"name":"$reporttype","line":135,"definition":"my"},{"kind":13,"containerName":"to_string","name":"$result","line":135},{"containerName":"to_string","kind":12,"name":"algorithm","line":135},{"definition":"my","name":"$qmoltype","localvar":"my","kind":13,"containerName":"to_string","line":136},{"kind":13,"containerName":"to_string","name":"$hmoltype","line":136},{"definition":"my","name":"$hit","localvar":"my","kind":13,"containerName":"to_string","line":137},{"line":137,"name":"$result","containerName":"to_string","kind":13},{"line":137,"containerName":"to_string","kind":12,"name":"next_hit"},{"definition":"my","line":138,"name":"$hsp","kind":13,"localvar":"my","containerName":"to_string"},{"line":138,"containerName":"to_string","kind":13,"name":"$hit"},{"line":138,"kind":12,"containerName":"to_string","name":"next_hsp"},{"name":"$hsp","containerName":"to_string","kind":13,"line":139},{"kind":12,"containerName":"to_string","name":"query","line":139},{"line":139,"containerName":"to_string","kind":12,"name":"strand"},{"line":139,"kind":13,"containerName":"to_string","name":"$qmoltype"},{"kind":13,"containerName":"to_string","name":"$qmoltype","line":140},{"line":142,"kind":13,"containerName":"to_string","name":"$hsp"},{"line":142,"name":"hit","kind":12,"containerName":"to_string"},{"name":"strand","containerName":"to_string","kind":12,"line":142},{"line":142,"containerName":"to_string","kind":13,"name":"$hmoltype"},{"kind":13,"containerName":"to_string","name":"$hmoltype","line":143},{"line":145,"name":"$writer","kind":13,"containerName":"to_string"},{"line":145,"name":"startTag","kind":12,"containerName":"to_string"},{"name":"$result","containerName":"to_string","kind":13,"line":146},{"name":"query_length","kind":12,"containerName":"to_string","line":146},{"line":147,"name":"$result","containerName":"to_string","kind":13},{"line":147,"name":"query_name","containerName":"to_string","kind":12},{"kind":13,"containerName":"to_string","name":"$result","line":147},{"line":147,"containerName":"to_string","kind":12,"name":"query_description"},{"kind":13,"containerName":"to_string","name":"$qmoltype","line":148},{"name":"$result","containerName":"to_string","kind":13,"line":150},{"line":151,"name":"query_name","containerName":"to_string","kind":12},{"name":"$writer","kind":13,"containerName":"to_string","line":154},{"containerName":"to_string","kind":12,"name":"startTag","line":154},{"line":155,"kind":13,"containerName":"to_string","name":"$writer"},{"containerName":"to_string","kind":12,"name":"startTag","line":155},{"line":157,"containerName":"to_string","kind":13,"name":"$reporttype"},{"name":"$hitnum","localvar":"my","kind":13,"containerName":"to_string","line":158,"definition":"my"},{"line":158,"name":"$hspnum","containerName":"to_string","kind":13},{"localvar":"my","kind":13,"containerName":"to_string","name":"$hit","line":159,"definition":"my"},{"line":159,"name":"$result","containerName":"to_string","kind":13},{"line":159,"name":"hits","kind":12,"containerName":"to_string"},{"name":"$hspnum","kind":13,"containerName":"to_string","line":160},{"definition":"my","line":161,"containerName":"to_string","localvar":"my","kind":13,"name":"$hsp"},{"line":161,"name":"$hit","kind":13,"containerName":"to_string"},{"line":161,"kind":12,"containerName":"to_string","name":"hsps"},{"line":162,"name":"$writer","containerName":"to_string","kind":13},{"containerName":"to_string","kind":12,"name":"startTag","line":162},{"line":163,"name":"$reporttype","kind":13,"containerName":"to_string"},{"line":165,"containerName":"to_string","kind":13,"name":"$hit"},{"name":"name","containerName":"to_string","kind":12,"line":165},{"line":165,"name":"$hit","kind":13,"containerName":"to_string"},{"containerName":"to_string","kind":12,"name":"description","line":165},{"line":168,"kind":13,"containerName":"to_string","name":"$writer"},{"containerName":"to_string","kind":12,"name":"emptyTag","line":168},{"containerName":"to_string","kind":13,"name":"$hsp","line":169},{"line":169,"containerName":"to_string","kind":12,"name":"query"},{"containerName":"to_string","kind":12,"name":"start","line":169},{"line":170,"name":"$hsp","containerName":"to_string","kind":13},{"line":170,"name":"query","kind":12,"containerName":"to_string"},{"line":170,"name":"end","containerName":"to_string","kind":12},{"kind":13,"containerName":"to_string","name":"$writer","line":171},{"line":171,"name":"emptyTag","containerName":"to_string","kind":12},{"line":173,"name":"$hsp","kind":13,"containerName":"to_string"},{"name":"score","kind":12,"containerName":"to_string","line":173},{"containerName":"to_string","kind":13,"name":"$writer","line":176},{"line":176,"name":"emptyTag","containerName":"to_string","kind":12},{"line":178,"containerName":"to_string","kind":13,"name":"$hsp"},{"kind":12,"containerName":"to_string","name":"hit","line":178},{"line":178,"name":"start","kind":12,"containerName":"to_string"},{"line":180,"containerName":"to_string","kind":13,"name":"$writer"},{"name":"emptyTag","kind":12,"containerName":"to_string","line":180},{"line":182,"containerName":"to_string","kind":13,"name":"$hsp"},{"line":182,"name":"hit","kind":12,"containerName":"to_string"},{"name":"end","containerName":"to_string","kind":12,"line":182},{"line":184,"kind":13,"containerName":"to_string","name":"$writer"},{"name":"emptyTag","kind":12,"containerName":"to_string","line":184},{"line":186,"kind":13,"containerName":"to_string","name":"$hitnum"},{"line":186,"kind":13,"containerName":"to_string","name":"$hspnum"},{"name":"$hsp","containerName":"to_string","kind":13,"line":189},{"line":189,"containerName":"to_string","kind":12,"name":"hit"},{"name":"strand","kind":12,"containerName":"to_string","line":189},{"name":"$writer","kind":13,"containerName":"to_string","line":190},{"kind":12,"containerName":"to_string","name":"emptyTag","line":190},{"line":195,"name":"$hspnum","containerName":"to_string","kind":13},{"line":196,"kind":13,"containerName":"to_string","name":"$writer"},{"name":"endTag","containerName":"to_string","kind":12,"line":196},{"line":198,"containerName":"to_string","kind":13,"name":"$hitnum"},{"name":"$writer","kind":13,"containerName":"to_string","line":200},{"name":"endTag","containerName":"to_string","kind":12,"line":200},{"line":201,"name":"$writer","kind":13,"containerName":"to_string"},{"name":"endTag","containerName":"to_string","kind":12,"line":201},{"line":202,"containerName":"to_string","kind":13,"name":"$writer"},{"line":202,"name":"endTag","kind":12,"containerName":"to_string"},{"line":203,"name":"$writer","containerName":"to_string","kind":13},{"line":203,"kind":12,"containerName":"to_string","name":"endTag"},{"containerName":"to_string","kind":13,"name":"$writer","line":205},{"containerName":"to_string","kind":12,"name":"startTag","line":205},{"kind":13,"containerName":"to_string","name":"$writer","line":206},{"containerName":"to_string","kind":12,"name":"startTag","line":206},{"line":207,"name":"$reporttype","containerName":"to_string","kind":13},{"name":"$result","kind":13,"containerName":"to_string","line":208},{"line":208,"containerName":"to_string","kind":12,"name":"query_length"},{"line":209,"name":"$hitnum","containerName":"to_string","kind":13},{"line":209,"name":"$hspnum","kind":13,"containerName":"to_string"},{"definition":"my","name":"$hit","localvar":"my","kind":13,"containerName":"to_string","line":210},{"line":210,"name":"$result","kind":13,"containerName":"to_string"},{"name":"hits","kind":12,"containerName":"to_string","line":210},{"kind":13,"containerName":"to_string","name":"$hspnum","line":211},{"line":212,"localvar":"my","containerName":"to_string","kind":13,"name":"$hsp","definition":"my"},{"name":"$hit","kind":13,"containerName":"to_string","line":212},{"containerName":"to_string","kind":12,"name":"hsps","line":212},{"name":"$writer","containerName":"to_string","kind":13,"line":213},{"name":"startTag","kind":12,"containerName":"to_string","line":213},{"line":214,"name":"$hitnum","containerName":"to_string","kind":13},{"name":"$hspnum","kind":13,"containerName":"to_string","line":214},{"name":"$result","containerName":"to_string","kind":13,"line":215},{"line":215,"containerName":"to_string","kind":12,"name":"algorithm"},{"line":217,"name":"$result","containerName":"to_string","kind":13},{"containerName":"to_string","kind":12,"name":"query_name","line":217},{"containerName":"to_string","kind":13,"name":"$result","line":219},{"line":219,"kind":12,"containerName":"to_string","name":"database_name"},{"name":"$hit","containerName":"to_string","kind":13,"line":220},{"line":220,"name":"name","kind":12,"containerName":"to_string"},{"line":221,"name":"$hit","containerName":"to_string","kind":13},{"line":221,"name":"name","kind":12,"containerName":"to_string"},{"kind":13,"containerName":"to_string","name":"$result","line":222},{"containerName":"to_string","kind":12,"name":"query_name","line":222},{"containerName":"to_string","kind":13,"name":"$result","line":223},{"containerName":"to_string","kind":12,"name":"query_name","line":223},{"line":224,"kind":13,"containerName":"to_string","name":"$result"},{"line":224,"name":"query_name","kind":12,"containerName":"to_string"},{"name":"$result","containerName":"to_string","kind":13,"line":225},{"line":225,"kind":12,"containerName":"to_string","name":"query_description"},{"containerName":"to_string","kind":13,"name":"$hit","line":226},{"line":226,"kind":12,"containerName":"to_string","name":"name"},{"line":227,"containerName":"to_string","kind":13,"name":"$hit"},{"kind":12,"containerName":"to_string","name":"description","line":227},{"name":"$hsp","kind":13,"containerName":"to_string","line":228},{"kind":12,"containerName":"to_string","name":"score","line":228},{"name":"$hsp","kind":13,"containerName":"to_string","line":229},{"name":"query","containerName":"to_string","kind":12,"line":229},{"line":229,"containerName":"to_string","kind":12,"name":"start"},{"line":230,"kind":13,"containerName":"to_string","name":"$hsp"},{"line":230,"name":"query","kind":12,"containerName":"to_string"},{"line":230,"name":"end","kind":12,"containerName":"to_string"},{"line":231,"containerName":"to_string","kind":13,"name":"$hsp"},{"line":231,"name":"hit","kind":12,"containerName":"to_string"},{"line":231,"name":"start","containerName":"to_string","kind":12},{"containerName":"to_string","kind":13,"name":"$hsp","line":232},{"line":232,"kind":12,"containerName":"to_string","name":"hit"},{"containerName":"to_string","kind":12,"name":"end","line":232},{"kind":13,"containerName":"to_string","name":"$hit","line":233},{"line":233,"name":"length","containerName":"to_string","kind":12},{"line":234,"name":"$result","containerName":"to_string","kind":13},{"name":"query_length","kind":12,"containerName":"to_string","line":234},{"containerName":"to_string","kind":13,"name":"$writer","line":236},{"line":236,"name":"emptyTag","kind":12,"containerName":"to_string"},{"line":238,"name":"$hitnum","containerName":"to_string","kind":13},{"containerName":"to_string","kind":13,"name":"$writer","line":239},{"line":239,"name":"emptyTag","kind":12,"containerName":"to_string"},{"name":"$hit","containerName":"to_string","kind":13,"line":241},{"containerName":"to_string","kind":12,"name":"name","line":241},{"kind":13,"containerName":"to_string","name":"$writer","line":242},{"containerName":"to_string","kind":12,"name":"emptyTag","line":242},{"containerName":"to_string","kind":13,"name":"$hspnum","line":244},{"line":245,"kind":13,"containerName":"to_string","name":"$writer"},{"line":245,"kind":12,"containerName":"to_string","name":"emptyTag"},{"line":247,"containerName":"to_string","kind":13,"name":"$hsp"},{"line":247,"kind":12,"containerName":"to_string","name":"bits"},{"name":"$writer","kind":13,"containerName":"to_string","line":248},{"kind":12,"containerName":"to_string","name":"emptyTag","line":248},{"line":250,"name":"$hsp","containerName":"to_string","kind":13},{"name":"evalue","containerName":"to_string","kind":12,"line":250},{"line":251,"kind":13,"containerName":"to_string","name":"$writer"},{"containerName":"to_string","kind":12,"name":"emptyTag","line":251},{"name":"$writer","containerName":"to_string","kind":13,"line":254},{"line":254,"kind":12,"containerName":"to_string","name":"emptyTag"},{"line":257,"name":"$writer","containerName":"to_string","kind":13},{"name":"emptyTag","kind":12,"containerName":"to_string","line":257},{"containerName":"to_string","kind":13,"name":"$hsp","line":259},{"containerName":"to_string","kind":12,"name":"query","line":259},{"line":259,"containerName":"to_string","kind":12,"name":"frame"},{"name":"$writer","containerName":"to_string","kind":13,"line":260},{"line":260,"containerName":"to_string","kind":12,"name":"emptyTag"},{"line":262,"name":"$hsp","kind":13,"containerName":"to_string"},{"line":262,"name":"hit","containerName":"to_string","kind":12},{"line":262,"kind":12,"containerName":"to_string","name":"frame"},{"name":"$hsp","containerName":"to_string","kind":13,"line":262},{"kind":12,"containerName":"to_string","name":"hit","line":262},{"kind":12,"containerName":"to_string","name":"strand","line":262},{"containerName":"to_string","kind":13,"name":"$writer","line":263},{"line":263,"name":"emptyTag","containerName":"to_string","kind":12},{"line":265,"containerName":"to_string","kind":13,"name":"$hsp"},{"line":265,"kind":12,"containerName":"to_string","name":"percent_identity"},{"line":266,"name":"$writer","kind":13,"containerName":"to_string"},{"line":266,"containerName":"to_string","kind":12,"name":"emptyTag"},{"name":"$hsp","kind":13,"containerName":"to_string","line":268},{"containerName":"to_string","kind":12,"name":"frac_conserved","line":268},{"definition":"my","line":269,"localvar":"my","kind":13,"containerName":"to_string","name":"$cons"},{"name":"$hsp","kind":13,"containerName":"to_string","line":269},{"kind":12,"containerName":"to_string","name":"frac_conserved","line":269},{"line":269,"kind":13,"containerName":"to_string","name":"$hsp"},{"line":269,"kind":12,"containerName":"to_string","name":"length"},{"line":270,"localvar":"my","containerName":"to_string","kind":13,"name":"$ident","definition":"my"},{"line":270,"name":"$hsp","kind":13,"containerName":"to_string"},{"line":270,"kind":12,"containerName":"to_string","name":"frac_identical"},{"line":270,"kind":13,"containerName":"to_string","name":"$hsp"},{"line":270,"containerName":"to_string","kind":12,"name":"length"},{"line":272,"kind":13,"containerName":"to_string","name":"$writer"},{"line":272,"name":"emptyTag","containerName":"to_string","kind":12},{"line":274,"containerName":"to_string","kind":13,"name":"$ident"},{"name":"$writer","kind":13,"containerName":"to_string","line":275},{"line":275,"name":"emptyTag","containerName":"to_string","kind":12},{"kind":13,"containerName":"to_string","name":"$cons","line":277},{"line":278,"name":"$writer","containerName":"to_string","kind":13},{"line":278,"name":"emptyTag","containerName":"to_string","kind":12},{"line":280,"kind":13,"containerName":"to_string","name":"$hsp"},{"line":280,"containerName":"to_string","kind":12,"name":"gaps"},{"line":281,"name":"$writer","kind":13,"containerName":"to_string"},{"containerName":"to_string","kind":12,"name":"emptyTag","line":281},{"name":"$hsp","containerName":"to_string","kind":13,"line":283},{"line":283,"name":"length","kind":12,"containerName":"to_string"},{"line":284,"containerName":"to_string","kind":13,"name":"$writer"},{"containerName":"to_string","kind":12,"name":"emptyTag","line":284},{"line":287,"kind":13,"containerName":"to_string","name":"$writer"},{"line":287,"name":"emptyTag","containerName":"to_string","kind":12},{"containerName":"to_string","kind":13,"name":"$hit","line":289},{"name":"length","kind":12,"containerName":"to_string","line":289},{"definition":"my","line":290,"localvar":"my","kind":13,"containerName":"to_string","name":"@extrafields"},{"line":292,"kind":13,"containerName":"to_string","name":"$writer"},{"kind":12,"containerName":"to_string","name":"emptyTag","line":292},{"line":293,"kind":13,"containerName":"to_string","name":"$hsp"},{"containerName":"to_string","kind":12,"name":"hit","line":293},{"line":293,"name":"length","containerName":"to_string","kind":12},{"kind":13,"containerName":"to_string","name":"$hsp","line":294},{"containerName":"to_string","kind":12,"name":"hsp_length","line":294},{"line":295,"containerName":"to_string","kind":13,"name":"$hsp"},{"name":"hit","kind":12,"containerName":"to_string","line":295},{"containerName":"to_string","kind":12,"name":"length","line":295},{"kind":13,"containerName":"to_string","name":"$hsp","line":296},{"containerName":"to_string","kind":12,"name":"hit","line":296},{"line":296,"containerName":"to_string","kind":12,"name":"strand"},{"name":"$hsp","containerName":"to_string","kind":13,"line":297},{"line":297,"containerName":"to_string","kind":12,"name":"query"},{"line":297,"containerName":"to_string","kind":12,"name":"strand"},{"line":298,"kind":13,"containerName":"to_string","name":"$hsp"},{"line":298,"name":"query_string","containerName":"to_string","kind":12},{"kind":13,"containerName":"to_string","name":"$hsp","line":299},{"line":299,"containerName":"to_string","kind":12,"name":"hit_string"},{"kind":13,"containerName":"to_string","name":"$hsp","line":300},{"kind":12,"containerName":"to_string","name":"homology_string","line":300},{"line":302,"name":"$hspnum","containerName":"to_string","kind":13},{"line":303,"name":"$writer","containerName":"to_string","kind":13},{"line":303,"containerName":"to_string","kind":12,"name":"endTag"},{"kind":13,"containerName":"to_string","name":"$hitnum","line":305},{"name":"$writer","kind":13,"containerName":"to_string","line":307},{"line":307,"name":"endTag","containerName":"to_string","kind":12},{"line":308,"kind":13,"containerName":"to_string","name":"$writer"},{"line":308,"containerName":"to_string","kind":12,"name":"endTag"},{"line":310,"kind":13,"containerName":"to_string","name":"$writer"},{"containerName":"to_string","kind":12,"name":"startTag","line":310},{"line":311,"kind":13,"containerName":"to_string","name":"$writer"},{"line":311,"kind":12,"containerName":"to_string","name":"startTag"},{"line":312,"name":"$writer","kind":13,"containerName":"to_string"},{"kind":12,"containerName":"to_string","name":"startTag","line":312},{"name":"$writer","containerName":"to_string","kind":13,"line":313},{"line":313,"name":"emptyTag","containerName":"to_string","kind":12},{"line":315,"kind":13,"containerName":"to_string","name":"$reporttype"},{"name":"$writer","kind":13,"containerName":"to_string","line":316},{"line":316,"name":"emptyTag","kind":12,"containerName":"to_string"},{"containerName":"to_string","kind":13,"name":"$reporttype","line":318},{"line":319,"name":"$result","kind":13,"containerName":"to_string"},{"line":319,"containerName":"to_string","kind":12,"name":"algorithm_version"},{"line":320,"containerName":"to_string","kind":13,"name":"$writer"},{"name":"emptyTag","kind":12,"containerName":"to_string","line":320},{"name":"$result","containerName":"to_string","kind":13,"line":322},{"kind":12,"containerName":"to_string","name":"algorithm_reference","line":322},{"name":"$writer","containerName":"to_string","kind":13,"line":323},{"containerName":"to_string","kind":12,"name":"emptyTag","line":323},{"line":325,"kind":13,"containerName":"to_string","name":"$result"},{"name":"database_name","containerName":"to_string","kind":12,"line":325},{"line":326,"name":"$writer","kind":13,"containerName":"to_string"},{"name":"emptyTag","containerName":"to_string","kind":12,"line":326},{"name":"$result","containerName":"to_string","kind":13,"line":328},{"line":328,"kind":12,"containerName":"to_string","name":"database_entries"},{"line":329,"containerName":"to_string","kind":13,"name":"$writer"},{"line":329,"name":"emptyTag","containerName":"to_string","kind":12},{"line":331,"kind":13,"containerName":"to_string","name":"$result"},{"name":"database_letters","containerName":"to_string","kind":12,"line":331},{"containerName":"to_string","localvar":"my","kind":13,"name":"$attr","line":335,"definition":"my"},{"line":335,"kind":13,"containerName":"to_string","name":"$result"},{"line":335,"name":"available_parameters","containerName":"to_string","kind":12},{"name":"$writer","kind":13,"containerName":"to_string","line":336},{"kind":12,"containerName":"to_string","name":"emptyTag","line":336},{"line":337,"name":"$attr","kind":13,"containerName":"to_string"},{"name":"$result","containerName":"to_string","kind":13,"line":338},{"line":338,"name":"get_parameter","containerName":"to_string","kind":12},{"line":338,"name":"$attr","kind":13,"containerName":"to_string"},{"definition":"my","localvar":"my","containerName":"to_string","kind":13,"name":"$attr","line":340},{"kind":13,"containerName":"to_string","name":"$result","line":340},{"containerName":"to_string","kind":12,"name":"available_statistics","line":340},{"line":341,"kind":13,"containerName":"to_string","name":"$writer"},{"line":341,"name":"emptyTag","containerName":"to_string","kind":12},{"name":"$attr","containerName":"to_string","kind":13,"line":342},{"name":"$result","containerName":"to_string","kind":13,"line":343},{"containerName":"to_string","kind":12,"name":"get_statistic","line":343},{"containerName":"to_string","kind":13,"name":"$attr","line":343},{"name":"$writer","kind":13,"containerName":"to_string","line":345},{"name":"endTag","containerName":"to_string","kind":12,"line":345},{"line":346,"name":"$writer","kind":13,"containerName":"to_string"},{"line":346,"containerName":"to_string","kind":12,"name":"endTag"},{"line":347,"kind":13,"containerName":"to_string","name":"$writer"},{"name":"endTag","kind":12,"containerName":"to_string","line":347},{"containerName":"to_string","kind":13,"name":"$writer","line":349},{"line":349,"name":"endTag","containerName":"to_string","kind":12},{"line":350,"name":"$writer","containerName":"to_string","kind":13},{"line":350,"name":"endTag","kind":12,"containerName":"to_string"},{"line":351,"name":"$writer","kind":13,"containerName":"to_string"},{"line":351,"name":"end","containerName":"to_string","kind":12},{"name":"$str","kind":13,"containerName":"to_string","line":352},{"line":352,"containerName":"to_string","kind":12,"name":"string_ref"}],"containerName":"main::","name":"to_string","definition":"sub","detail":"($self,$result,$num)","line":123,"range":{"end":{"character":9999,"line":352},"start":{"character":0,"line":123}},"kind":12,"signature":{"label":"to_string($self,$result,$num)","parameters":[{"label":"$self"},{"label":"$result"},{"label":"$num"}],"documentation":"1;\n# $Id: BSMLResultWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::Writer::BSMLResultWriter\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::Writer::BSMLResultWriter - BSML output writer\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $in = Bio::SearchIO->new(-file   => 'result.blast',\n                             -format => 'blast');\n  my $out = Bio::SearchIO->new(-output_format  => 'BSMLResultWriter',\n                              -file           => \">result.bsml\");\n  while( my $r = $in->next_result ) {\n    $out->write_result($r);\n  }\n\n=head1 DESCRIPTION\n\nThis is a writer to produce BSML for a search result.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::Writer::BSMLResultWriter;\nuse strict;\n\nuse XML::Writer;\nuse IO::String;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::SearchWriterI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Writer::BSMLResultWriter->new();\n Function: Builds a new Bio::SearchIO::Writer::BSMLResultWriter object \n Returns : an instance of Bio::SearchIO::Writer::BSMLResultWriter\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  return $self;\n}\n\n=head2 to_string\n\n Purpose   : Produces data for each Search::Result::ResultI in a string.\n           : This is an abstract method. For some useful implementations,\n           : see ResultTableWriter.pm, HitTableWriter.pm, \n           : and HSPTableWriter.pm.\n Usage     : print $writer->to_string( $result_obj, @args );\n Argument  : $result_obj = A Bio::Search::Result::ResultI object\n           : @args = any additional arguments used by your implementation.\n Returns   : String containing data for each search Result or any of its\n           : sub-objects (Hits and HSPs).\n Throws    : n/a\n\n this implementation is largely adapted from the Incogen XSLT stylesheet\n to convert NCBI BLAST XML to BSML"}},{"line":125,"name":"IO","containerName":"String","kind":12},{"kind":12,"containerName":"Writer","name":"XML","line":126},{"kind":12,"name":"OUTPUT","line":126},{"name":"DATA_INDENT","kind":12,"line":127},{"kind":12,"name":"DATA_MODE","line":128}]}