{"version":5,"vars":[{"line":49,"name":"base","kind":2,"containerName":""},{"signature":{"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: SearchWriterI.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module Bio::SearchIO::SearchWriterI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n=head1 NAME\n\nBio::SearchIO::SearchWriterI - Interface for outputting parsed Search results\n\n=head1 SYNOPSIS\n\nBio::SearchIO::SearchWriterI objects cannot be instantiated since this\nmodule defines a pure interface.\n\nGiven an object that implements the Bio::SearchIO::SearchWriterI interface,\nyou can do the following things with it:\n\n    print $writer->to_string( $result_obj, @args );\n\n=head1 DESCRIPTION\n\nThis module defines abstract methods that all subclasses must implement\nto be used for outputting results from L<Bio::Search::Result::ResultI>\nobjects.\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac-at-bioperl.orgE<gt>\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::SearchIO::SearchWriterI;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head2 to_string\n\n Purpose   : Produces data for each Search::Result::ResultI in a string.\n           : This is an abstract method. For some useful implementations,\n           : see ResultTableWriter.pm, HitTableWriter.pm, \n           : and HSPTableWriter.pm.\n Usage     : print $writer->to_string( $result_obj, @args );\n Argument  : $result_obj = A Bio::Search::Result::ResultI object\n           : @args = any additional arguments used by your implementation.\n Returns   : String containing data for each search Result or any of its\n           : sub-objects (Hits and HSPs).\n Throws    : n/a","parameters":[{"label":"$self"},{"label":"$result"},{"label":"@args"}],"label":"to_string($self,$result,@args)"},"line":66,"range":{"start":{"line":66,"character":0},"end":{"character":9999,"line":69}},"kind":12,"definition":"sub","detail":"($self,$result,@args)","children":[{"line":67,"name":"$self","localvar":"my","kind":13,"containerName":"to_string","definition":"my"},{"kind":13,"containerName":"to_string","name":"$result","line":67},{"kind":13,"containerName":"to_string","name":"@args","line":67},{"line":68,"name":"$self","kind":13,"containerName":"to_string"},{"line":68,"kind":12,"containerName":"to_string","name":"throw_not_implemented"}],"name":"to_string","containerName":"main::"},{"containerName":"main::","name":"start_report","children":[],"definition":"sub","kind":12,"range":{"end":{"character":9999,"line":82},"start":{"character":0,"line":82}},"line":82},{"line":98,"kind":12,"range":{"start":{"character":0,"line":98},"end":{"character":9999,"line":98}},"children":[],"name":"end_report","containerName":"main::","definition":"sub"},{"signature":{"parameters":[{"label":"$self"},{"label":"$method"},{"label":"$code"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: SearchWriterI.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module Bio::SearchIO::SearchWriterI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n=head1 NAME\n\nBio::SearchIO::SearchWriterI - Interface for outputting parsed Search results\n\n=head1 SYNOPSIS\n\nBio::SearchIO::SearchWriterI objects cannot be instantiated since this\nmodule defines a pure interface.\n\nGiven an object that implements the Bio::SearchIO::SearchWriterI interface,\nyou can do the following things with it:\n\n    print $writer->to_string( $result_obj, @args );\n\n=head1 DESCRIPTION\n\nThis module defines abstract methods that all subclasses must implement\nto be used for outputting results from L<Bio::Search::Result::ResultI>\nobjects.\n\n=head1 AUTHOR\n\nSteve Chervitz E<lt>sac-at-bioperl.orgE<gt>\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::SearchIO::SearchWriterI;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head2 to_string\n\n Purpose   : Produces data for each Search::Result::ResultI in a string.\n           : This is an abstract method. For some useful implementations,\n           : see ResultTableWriter.pm, HitTableWriter.pm, \n           : and HSPTableWriter.pm.\n Usage     : print $writer->to_string( $result_obj, @args );\n Argument  : $result_obj = A Bio::Search::Result::ResultI object\n           : @args = any additional arguments used by your implementation.\n Returns   : String containing data for each search Result or any of its\n           : sub-objects (Hits and HSPs).\n Throws    : n/a\n\n\nsub to_string {\n    my ($self, $result, @args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 start_report\n\n Title   : start_report\n Usage   : $self->start_report()\n Function: The method to call when starting a report. You can override it\n           to make a custom header\n Returns : string\n Args    : none\n\n\nsub start_report { return '' }\n\n=head2 end_report\n\n Title   : end_report\n Usage   : $self->end_report()\n Function: The method to call when ending a report, this is\n           mostly for cleanup for formats which require you to \n           have something at the end of the document (</BODY></HTML>)\n           for HTML\n Returns : string\n Args    : none\n\n\n\nsub end_report {  return '' }\n\n=head2 filter\n\n Title   : filter\n Usage   : $writer->filter('hsp', \\&hsp_filter);\n Function: Filter out either at HSP,Hit,or Result level\n Returns : none\n Args    : string => data type,\n           CODE reference\n\n\n yes this is an implementation in the interface,\n yes it assumes that the underlying class is hash-based\n yes that might not be a good idea, but until people\n start extending the SearchWriterI interface I think\n this is an okay way to go","label":"filter($self,$method,$code)"},"range":{"end":{"line":133,"character":9999},"start":{"character":0,"line":118}},"kind":12,"line":118,"detail":"($self,$method,$code)","definition":"sub","containerName":"main::","name":"filter","children":[{"kind":13,"localvar":"my","containerName":"filter","name":"$self","line":119,"definition":"my"},{"containerName":"filter","kind":13,"name":"$method","line":119},{"line":119,"containerName":"filter","kind":13,"name":"$code"},{"line":120,"containerName":"filter","kind":13,"name":"$method"},{"line":121,"containerName":"filter","kind":13,"name":"$method"},{"containerName":"filter","kind":13,"name":"$method","line":121},{"line":122,"kind":13,"containerName":"filter","name":"$method"},{"containerName":"filter","kind":13,"name":"$method","line":123},{"name":"$method","kind":13,"containerName":"filter","line":124},{"name":"$self","kind":13,"containerName":"filter","line":125},{"kind":12,"containerName":"filter","name":"warn","line":125},{"name":"$code","kind":13,"containerName":"filter","line":128},{"containerName":"filter","kind":13,"name":"$self","line":129},{"name":"throw","containerName":"filter","kind":12,"line":129},{"line":129,"name":"$code","kind":13,"containerName":"filter"},{"kind":13,"containerName":"filter","name":"$self","line":130},{"line":130,"name":"$method","kind":13,"containerName":"filter"},{"kind":13,"containerName":"filter","name":"$code","line":130},{"line":132,"kind":13,"containerName":"filter","name":"$self"},{"line":132,"name":"$method","kind":13,"containerName":"filter"}]}]}