{"vars":[{"name":"base","containerName":"","kind":2,"line":87},{"definition":"sub","detail":"($class,@args)","children":[{"definition":"my","line":109,"kind":13,"localvar":"my","containerName":"new","name":"$class"},{"line":109,"name":"@args","kind":13,"containerName":"new"},{"definition":"my","line":110,"kind":13,"localvar":"my","containerName":"new","name":"$self"},{"line":110,"name":"$class","containerName":"new","kind":13},{"name":"@args","containerName":"new","kind":13,"line":110},{"containerName":"new","kind":13,"name":"$self","line":112},{"kind":12,"containerName":"new","name":"_setup","line":112},{"line":112,"name":"@args","containerName":"new","kind":13},{"definition":"my","line":114,"name":"$field","kind":13,"localvar":"my","containerName":"new"},{"name":"$self","kind":13,"containerName":"new","line":115},{"name":"_fields","containerName":"new","kind":12,"line":115},{"line":115,"containerName":"new","kind":13,"name":"$field"},{"name":"$self","containerName":"new","kind":13,"line":118},{"name":"_dependencies","containerName":"new","kind":12,"line":118},{"kind":13,"containerName":"new","name":"$self","line":126}],"name":"new","containerName":"main::","signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: BlastPullResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::BlastPullResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::BlastPullResult - A parser and result object for BLASTN\n                                     results\n\n=head1 SYNOPSIS\n\n    # generally we use Bio::SearchIO to build these objects\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'blast_pull',\n\t\t\t\t\t\t\t   -file   => 'result.blast');\n\n    while (my $result = $in->next_result) {\n\t\tprint $result->query_name, \" \", $result->algorithm, \" \", $result->num_hits(), \" hits\\n\";\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for NCBI BLASTN result output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 CONTRIBUTORS\n\nAdditional contributors names and emails here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Result::BlastPullResult;\n\nuse strict;\n\nuse Bio::Search::Hit::BlastPullHit;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::PullResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Result::hmmpfam->new();\n Function: Builds a new Bio::SearchIO::Result::hmmpfam object \n Returns : Bio::SearchIO::Result::hmmpfam\n Args    : -chunk  => [Bio::Root::IO, $start, $end] (required if no -parent)\n           -parent => Bio::PullParserI object (required if no -chunk)\n           -parameters => hash ref of search parameters (key => value), optional\n           -statistics => hash ref of search statistics (key => value), optional\n\n\t\t   where the array ref provided to -chunk contains an IO object\n           for a filehandle to something representing the raw data of the\n           result, and $start and $end define the tell() position within the\n           filehandle that the result data starts and ends (optional; defaults\n           to start and end of the entire thing described by the filehandle)","parameters":[{"label":"$class"},{"label":"@args"}]},"line":108,"range":{"start":{"character":0,"line":108},"end":{"character":9999,"line":127}},"kind":12},{"kind":12,"containerName":"new","name":"SUPER","line":110},{"name":"query_name","kind":12,"line":118},{"line":119,"name":"query_accession","kind":12},{"line":120,"kind":12,"name":"query_description"},{"name":"query_length","kind":12,"line":121},{"line":122,"kind":12,"name":"hit_table"},{"kind":12,"name":"num_hits","line":123},{"kind":12,"name":"no_hits_found","line":124},{"range":{"end":{"line":157,"character":9999},"start":{"line":133,"character":0}},"kind":12,"line":133,"definition":"sub","name":"_discover_header","containerName":"main::","children":[{"line":134,"localvar":"my","kind":13,"containerName":"_discover_header","name":"$self","definition":"my"},{"kind":13,"containerName":"_discover_header","name":"$self","line":135},{"line":135,"name":"_chunk_seek","containerName":"_discover_header","kind":12},{"line":136,"localvar":"my","containerName":"_discover_header","kind":13,"name":"$header","definition":"my"},{"line":136,"containerName":"_discover_header","kind":13,"name":"$self"},{"containerName":"_discover_header","kind":12,"name":"_get_chunk_by_end","line":136},{"containerName":"_discover_header","kind":13,"name":"$self","line":137},{"containerName":"_discover_header","kind":13,"name":"$self","line":137},{"name":"_chunk_tell","kind":12,"containerName":"_discover_header","line":137},{"line":139,"kind":13,"containerName":"_discover_header","name":"$self"},{"line":139,"containerName":"_discover_header","kind":12,"name":"_fields"},{"containerName":"_discover_header","kind":13,"name":"$header","line":139},{"line":140,"kind":13,"containerName":"_discover_header","name":"$self"},{"name":"_fields","containerName":"_discover_header","kind":12,"line":140},{"line":141,"name":"$self","containerName":"_discover_header","kind":13},{"containerName":"_discover_header","kind":12,"name":"_fields","line":141},{"line":143,"kind":13,"containerName":"_discover_header","name":"$header"},{"line":144,"containerName":"_discover_header","kind":13,"name":"$self"},{"line":144,"name":"_fields","containerName":"_discover_header","kind":12},{"kind":13,"containerName":"_discover_header","name":"$header","line":146},{"kind":13,"containerName":"_discover_header","name":"$self","line":148},{"kind":12,"containerName":"_discover_header","name":"_fields","line":148},{"line":150,"containerName":"_discover_header","kind":13,"name":"$header"},{"line":152,"name":"$self","containerName":"_discover_header","kind":13},{"containerName":"_discover_header","kind":12,"name":"_fields","line":152},{"containerName":"_discover_header","kind":13,"name":"$self","line":156},{"line":156,"name":"_fields","kind":12,"containerName":"_discover_header"}]},{"line":137,"name":"_after_header","kind":12},{"line":139,"kind":12,"name":"query_name"},{"kind":12,"name":"query_accession","line":140},{"kind":12,"name":"query_description","line":141},{"line":144,"name":"query_length","kind":12},{"line":148,"name":"query_length","kind":12},{"line":152,"name":"query_name","kind":12},{"line":156,"kind":12,"name":"header"},{"range":{"end":{"character":9999,"line":200},"start":{"character":0,"line":159}},"kind":12,"line":159,"name":"_discover_hit_table","containerName":"main::","children":[{"definition":"my","line":160,"containerName":"_discover_hit_table","localvar":"my","kind":13,"name":"$self"},{"containerName":"_discover_hit_table","kind":13,"name":"$self","line":162},{"line":162,"containerName":"_discover_hit_table","kind":12,"name":"_chunk_seek"},{"kind":13,"containerName":"_discover_hit_table","name":"$self","line":162},{"definition":"my","localvar":"my","containerName":"_discover_hit_table","kind":13,"name":"$table","line":163},{"line":163,"name":"$self","kind":13,"containerName":"_discover_hit_table"},{"name":"_get_chunk_by_end","kind":12,"containerName":"_discover_hit_table","line":163},{"name":"$table","kind":13,"containerName":"_discover_hit_table","line":165},{"name":"$line","kind":13,"localvar":"my","containerName":"_discover_hit_table","line":168,"definition":"my"},{"line":168,"kind":13,"containerName":"_discover_hit_table","name":"$self"},{"name":"_get_chunk_by_nol","kind":12,"containerName":"_discover_hit_table","line":168},{"line":169,"name":"$table","containerName":"_discover_hit_table","kind":13},{"line":169,"name":"$line","kind":13,"containerName":"_discover_hit_table"},{"name":"$table","containerName":"_discover_hit_table","kind":13,"line":173},{"containerName":"_discover_hit_table","kind":13,"name":"$self","line":175},{"line":175,"name":"$self","kind":13,"containerName":"_discover_hit_table"},{"containerName":"_discover_hit_table","kind":12,"name":"_chunk_tell","line":175},{"kind":13,"localvar":"my","containerName":"_discover_hit_table","name":"$evalue_cutoff","line":177,"definition":"my"},{"name":"$self","kind":13,"containerName":"_discover_hit_table","line":177},{"name":"get_field","containerName":"_discover_hit_table","kind":12,"line":177},{"containerName":"_discover_hit_table","kind":13,"name":"$evalue_cutoff","line":178},{"name":"$evalue_cutoff","containerName":"_discover_hit_table","kind":13,"line":178},{"line":179,"localvar":"my","kind":13,"containerName":"_discover_hit_table","name":"$score_cutoff","definition":"my"},{"name":"$self","containerName":"_discover_hit_table","kind":13,"line":179},{"line":179,"name":"get_field","kind":12,"containerName":"_discover_hit_table"},{"line":180,"name":"$score_cutoff","containerName":"_discover_hit_table","kind":13},{"containerName":"_discover_hit_table","kind":13,"name":"$score_cutoff","line":180},{"kind":13,"localvar":"my","containerName":"_discover_hit_table","name":"@table","line":182,"definition":"my"},{"localvar":"my","kind":13,"containerName":"_discover_hit_table","name":"$no_hit","line":183,"definition":"my"},{"line":184,"kind":13,"containerName":"_discover_hit_table","name":"$table"},{"name":"$no_hit","containerName":"_discover_hit_table","kind":13,"line":185},{"name":"$name","localvar":"my","kind":13,"containerName":"_discover_hit_table","line":186,"definition":"my"},{"line":186,"kind":13,"containerName":"_discover_hit_table","name":"$desc"},{"name":"$score","kind":13,"containerName":"_discover_hit_table","line":186},{"line":186,"containerName":"_discover_hit_table","kind":13,"name":"$evalue"},{"name":"$desc","containerName":"_discover_hit_table","kind":13,"line":187},{"containerName":"_discover_hit_table","kind":13,"name":"$evalue","line":188},{"line":189,"containerName":"_discover_hit_table","kind":13,"name":"$evalue"},{"containerName":"_discover_hit_table","kind":13,"name":"$evalue","line":189},{"line":191,"kind":13,"containerName":"_discover_hit_table","name":"$evalue_cutoff"},{"name":"$evalue","kind":13,"containerName":"_discover_hit_table","line":191},{"line":191,"name":"$evalue_cutoff","kind":13,"containerName":"_discover_hit_table"},{"line":192,"name":"$score_cutoff","kind":13,"containerName":"_discover_hit_table"},{"line":192,"containerName":"_discover_hit_table","kind":13,"name":"$score"},{"line":192,"name":"$score_cutoff","kind":13,"containerName":"_discover_hit_table"},{"name":"@table","kind":13,"containerName":"_discover_hit_table","line":193},{"line":193,"kind":13,"containerName":"_discover_hit_table","name":"$name"},{"line":193,"containerName":"_discover_hit_table","kind":13,"name":"$desc"},{"line":193,"containerName":"_discover_hit_table","kind":13,"name":"$score"},{"line":193,"name":"$evalue","kind":13,"containerName":"_discover_hit_table"},{"kind":13,"containerName":"_discover_hit_table","name":"$self","line":195},{"name":"_fields","containerName":"_discover_hit_table","kind":12,"line":195},{"line":195,"kind":13,"containerName":"_discover_hit_table","name":"@table"},{"line":196,"name":"$self","containerName":"_discover_hit_table","kind":13},{"kind":13,"containerName":"_discover_hit_table","name":"@table","line":196},{"line":198,"name":"$self","kind":13,"containerName":"_discover_hit_table"},{"name":"_fields","containerName":"_discover_hit_table","kind":12,"line":198},{"line":198,"kind":13,"containerName":"_discover_hit_table","name":"$no_hit"},{"containerName":"_discover_hit_table","kind":13,"name":"$self","line":199},{"line":199,"containerName":"_discover_hit_table","kind":12,"name":"_fields"},{"kind":13,"containerName":"_discover_hit_table","name":"@table","line":199}],"definition":"sub"},{"name":"_after_header","kind":12,"line":162},{"line":175,"kind":12,"name":"_after_hit_table"},{"name":"hit_table","kind":12,"line":195},{"line":196,"name":"_next_hit_index","kind":12},{"kind":12,"name":"no_hits_found","line":198},{"line":199,"name":"num_hits","kind":12},{"line":202,"kind":12,"range":{"start":{"character":0,"line":202},"end":{"line":206,"character":9999}},"definition":"sub","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"_discover_next_hit","line":203},{"definition":"my","line":204,"kind":13,"localvar":"my","containerName":"_discover_next_hit","name":"$hit_table"},{"line":204,"name":"$self","containerName":"_discover_next_hit","kind":13},{"name":"get_field","kind":12,"containerName":"_discover_next_hit","line":204},{"containerName":"_discover_next_hit","kind":13,"name":"$self","line":205},{"definition":"my","line":206,"name":"$hit_row","containerName":"_discover_next_hit","localvar":"my","kind":13},{"containerName":"_discover_next_hit","kind":13,"name":"$hit_table","line":206}],"name":"_discover_next_hit","containerName":"main::"},{"line":205,"kind":12,"name":"_next_hit_index"},{"line":206,"containerName":null,"kind":13,"name":"%self"},{"kind":12,"name":"_next_hit_index","line":206},{"line":208,"containerName":null,"kind":13,"name":"$self"},{"containerName":"main::","kind":12,"name":"_chunk_seek","line":208},{"kind":13,"containerName":null,"name":"%self","line":208},{"line":208,"name":"_end_of_previous_hit","kind":12},{"containerName":null,"kind":13,"name":"%self","line":208},{"name":"_after_hit_table","kind":12,"line":208},{"name":"$start","containerName":null,"localvar":"my","kind":13,"line":210,"definition":"my"},{"containerName":null,"kind":13,"name":"$end","line":210},{"line":210,"name":"$self","containerName":null,"kind":13},{"kind":12,"containerName":"main::","name":"_find_chunk_by_end","line":210},{"kind":13,"containerName":null,"name":"%end","line":211},{"kind":13,"containerName":null,"name":"$start","line":212},{"containerName":null,"kind":13,"name":"%self","line":212},{"name":"_end_of_previous_hit","kind":12,"line":212},{"kind":13,"containerName":null,"name":"%self","line":212},{"line":212,"kind":12,"name":"_after_hit_table"},{"containerName":null,"kind":13,"name":"$end","line":213},{"line":213,"name":"$self","kind":13,"containerName":null},{"line":213,"kind":12,"containerName":"main::","name":"_chunk_true_end"},{"kind":13,"containerName":null,"name":"$end","line":216},{"line":216,"name":"$self","containerName":null,"kind":13},{"line":216,"kind":12,"containerName":"main::","name":"_chunk_true_start"},{"kind":13,"containerName":null,"name":"$start","line":218},{"name":"$self","containerName":null,"kind":13,"line":218},{"containerName":"main::","kind":12,"name":"_chunk_true_start","line":218},{"name":"%self","kind":13,"containerName":null,"line":220},{"line":220,"kind":12,"name":"_end_of_previous_hit"},{"line":220,"name":"$end","containerName":null,"kind":13},{"line":220,"name":"$self","containerName":null,"kind":13},{"line":220,"name":"_chunk_true_start","kind":12,"containerName":"main::"},{"containerName":null,"kind":13,"name":"$self","line":224},{"line":224,"name":"_fields","kind":12,"containerName":"main::"},{"kind":12,"name":"next_hit","line":224},{"containerName":"Search::Hit::BlastPullHit","kind":12,"name":"Bio","line":224},{"line":224,"kind":12,"containerName":"main::","name":"new"},{"line":224,"containerName":null,"kind":13,"name":"@self"},{"line":225,"name":"$self","kind":13,"containerName":null},{"name":"chunk","containerName":"main::","kind":12,"line":225},{"line":225,"name":"$start","containerName":null,"kind":13},{"line":225,"kind":13,"containerName":null,"name":"$end"},{"line":226,"containerName":null,"kind":13,"name":"$hit_row"},{"line":228,"containerName":null,"kind":13,"name":"%self"},{"name":"_next_hit_index","kind":12,"line":228},{"name":"%self","kind":13,"containerName":null,"line":230},{"line":230,"name":"_next_hit_index","kind":12},{"name":"%hit_table","kind":13,"containerName":null,"line":230},{"line":231,"name":"%self","containerName":null,"kind":13},{"line":231,"kind":12,"name":"_next_hit_index"},{"kind":12,"range":{"start":{"line":235,"character":0},"end":{"character":9999,"line":302}},"line":235,"definition":"sub","containerName":"main::","name":"_discover_stats_and_params","children":[{"line":236,"localvar":"my","kind":13,"containerName":"_discover_stats_and_params","name":"$self","definition":"my"},{"line":237,"containerName":"_discover_stats_and_params","kind":13,"name":"$self"},{"line":237,"name":"_chunk_seek","containerName":"_discover_stats_and_params","kind":12},{"definition":"my","name":"$start","kind":13,"localvar":"my","containerName":"_discover_stats_and_params","line":238},{"name":"$end","kind":13,"containerName":"_discover_stats_and_params","line":238},{"containerName":"_discover_stats_and_params","kind":13,"name":"$self","line":238},{"containerName":"_discover_stats_and_params","kind":12,"name":"_find_chunk_by_end","line":238},{"containerName":"_discover_stats_and_params","kind":13,"name":"$self","line":239},{"containerName":"_discover_stats_and_params","kind":12,"name":"_chunk_seek","line":239},{"name":"$end","containerName":"_discover_stats_and_params","kind":13,"line":239},{"definition":"my","name":"$gapped","localvar":"my","kind":13,"containerName":"_discover_stats_and_params","line":241},{"line":242,"name":"$self","kind":13,"containerName":"_discover_stats_and_params"},{"line":242,"name":"_get_chunk_by_nol","kind":12,"containerName":"_discover_stats_and_params"},{"definition":"my","name":"$stat","localvar":"my","containerName":"_discover_stats_and_params","kind":13,"line":244},{"containerName":"_discover_stats_and_params","kind":13,"name":"$stat","line":245},{"line":246,"name":"$self","containerName":"_discover_stats_and_params","kind":13},{"line":246,"kind":12,"containerName":"_discover_stats_and_params","name":"add_statistic"},{"line":246,"name":"$stat","containerName":"_discover_stats_and_params","kind":13},{"line":249,"localvar":"my","containerName":"_discover_stats_and_params","kind":13,"name":"$stat","definition":"my"},{"line":250,"name":"$stat","kind":13,"containerName":"_discover_stats_and_params"},{"line":251,"containerName":"_discover_stats_and_params","kind":13,"name":"$self"},{"name":"add_statistic","containerName":"_discover_stats_and_params","kind":12,"line":251},{"line":251,"kind":13,"containerName":"_discover_stats_and_params","name":"$stat"},{"name":"$line","localvar":"my","containerName":"_discover_stats_and_params","kind":13,"line":254,"definition":"my"},{"name":"$self","kind":13,"containerName":"_discover_stats_and_params","line":254},{"name":"_get_chunk_by_nol","kind":12,"containerName":"_discover_stats_and_params","line":254},{"line":255,"kind":13,"containerName":"_discover_stats_and_params","name":"$line"},{"name":"$self","containerName":"_discover_stats_and_params","kind":13,"line":256},{"line":256,"name":"add_statistic","kind":12,"containerName":"_discover_stats_and_params"},{"line":256,"name":"$gapped","containerName":"_discover_stats_and_params","kind":13},{"kind":13,"containerName":"_discover_stats_and_params","name":"$self","line":257},{"kind":12,"containerName":"_discover_stats_and_params","name":"add_statistic","line":257},{"line":257,"kind":13,"containerName":"_discover_stats_and_params","name":"$gapped"},{"line":258,"containerName":"_discover_stats_and_params","kind":13,"name":"$self"},{"line":258,"kind":12,"containerName":"_discover_stats_and_params","name":"add_statistic"},{"line":258,"name":"$gapped","kind":13,"containerName":"_discover_stats_and_params"},{"line":259,"containerName":"_discover_stats_and_params","kind":13,"name":"$gapped"},{"name":"$self","containerName":"_discover_stats_and_params","kind":13,"line":262},{"name":"add_parameter","kind":12,"containerName":"_discover_stats_and_params","line":262},{"line":265,"containerName":"_discover_stats_and_params","kind":13,"name":"$self"},{"line":265,"containerName":"_discover_stats_and_params","kind":12,"name":"add_parameter"},{"name":"$self","kind":13,"containerName":"_discover_stats_and_params","line":266},{"containerName":"_discover_stats_and_params","kind":12,"name":"add_parameter","line":266},{"line":269,"name":"$self","kind":13,"containerName":"_discover_stats_and_params"},{"name":"add_statistic","containerName":"_discover_stats_and_params","kind":12,"line":269},{"kind":13,"containerName":"_discover_stats_and_params","name":"$self","line":272},{"containerName":"_discover_stats_and_params","kind":12,"name":"add_statistic","line":272},{"kind":13,"containerName":"_discover_stats_and_params","name":"$self","line":275},{"containerName":"_discover_stats_and_params","kind":12,"name":"add_statistic","line":275},{"line":278,"name":"$self","containerName":"_discover_stats_and_params","kind":13},{"name":"add_parameter","kind":12,"containerName":"_discover_stats_and_params","line":278},{"containerName":"_discover_stats_and_params","kind":13,"name":"$self","line":281},{"line":281,"name":"add_statistic","containerName":"_discover_stats_and_params","kind":12},{"line":284,"kind":13,"containerName":"_discover_stats_and_params","name":"$self"},{"line":284,"name":"add_statistic","kind":12,"containerName":"_discover_stats_and_params"},{"name":"$self","containerName":"_discover_stats_and_params","kind":13,"line":287},{"containerName":"_discover_stats_and_params","kind":12,"name":"add_statistic","line":287},{"containerName":"_discover_stats_and_params","kind":13,"name":"$self","line":290},{"kind":12,"containerName":"_discover_stats_and_params","name":"add_statistic","line":290},{"line":293,"containerName":"_discover_stats_and_params","kind":13,"name":"$self"},{"containerName":"_discover_stats_and_params","kind":12,"name":"add_statistic","line":293},{"line":296,"name":"$self","containerName":"_discover_stats_and_params","kind":13},{"kind":12,"containerName":"_discover_stats_and_params","name":"add_statistic","line":296},{"name":"$self","kind":13,"containerName":"_discover_stats_and_params","line":297},{"line":297,"kind":12,"containerName":"_discover_stats_and_params","name":"add_statistic"},{"line":301,"name":"$self","containerName":"_discover_stats_and_params","kind":13},{"containerName":"_discover_stats_and_params","kind":12,"name":"_fields","line":301}]},{"kind":12,"name":"stats_and_params","line":301},{"name":"next_hit","containerName":"main::","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"next_hit","line":316,"definition":"my"},{"definition":"my","localvar":"my","containerName":"next_hit","kind":13,"name":"$hit","line":317},{"line":317,"containerName":"next_hit","kind":13,"name":"$self"},{"line":317,"name":"get_field","containerName":"next_hit","kind":12},{"kind":13,"containerName":"next_hit","name":"$self","line":318},{"name":"_fields","containerName":"next_hit","kind":12,"line":318},{"name":"$hit","containerName":"next_hit","kind":13,"line":319}],"definition":"sub","kind":12,"range":{"start":{"character":0,"line":315},"end":{"character":9999,"line":320}},"line":315},{"kind":12,"name":"next_hit","line":318},{"range":{"start":{"character":0,"line":334},"end":{"character":9999,"line":344}},"kind":12,"line":334,"name":"hits","containerName":"main::","children":[{"localvar":"my","containerName":"hits","kind":13,"name":"$self","line":335,"definition":"my"},{"line":336,"kind":13,"localvar":"my","containerName":"hits","name":"$old","definition":"my"},{"line":336,"kind":13,"containerName":"hits","name":"$self"},{"containerName":"hits","kind":13,"name":"$self","line":337},{"kind":12,"containerName":"hits","name":"rewind","line":337},{"name":"@hits","containerName":"hits","localvar":"my","kind":13,"line":338,"definition":"my"},{"kind":13,"localvar":"my","containerName":"hits","name":"$hit","line":339,"definition":"my"},{"containerName":"hits","kind":13,"name":"$self","line":339},{"line":339,"kind":12,"containerName":"hits","name":"next_hit"},{"line":340,"name":"@hits","kind":13,"containerName":"hits"},{"containerName":"hits","kind":13,"name":"$hit","line":340},{"line":342,"name":"$self","kind":13,"containerName":"hits"},{"line":342,"kind":13,"containerName":"hits","name":"@hits"},{"line":342,"kind":13,"containerName":"hits","name":"$old"},{"name":"@hits","containerName":"hits","kind":13,"line":343}],"definition":"sub"},{"line":336,"kind":12,"name":"_next_hit_index"},{"line":342,"kind":12,"name":"_next_hit_index"},{"children":[{"definition":"my","localvar":"my","containerName":"sort_hits","kind":13,"name":"$self","line":362},{"name":"$code_ref","kind":13,"containerName":"sort_hits","line":362},{"line":363,"containerName":"sort_hits","kind":13,"name":"$self"},{"line":363,"containerName":"sort_hits","kind":12,"name":"throw"}],"containerName":"main::","name":"sort_hits","definition":"sub","detail":"($self,$code_ref)","line":361,"range":{"start":{"line":361,"character":0},"end":{"character":9999,"line":364}},"kind":12,"signature":{"label":"sort_hits($self,$code_ref)","documentation":"1;\n# $Id: BlastPullResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::BlastPullResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::BlastPullResult - A parser and result object for BLASTN\n                                     results\n\n=head1 SYNOPSIS\n\n    # generally we use Bio::SearchIO to build these objects\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'blast_pull',\n\t\t\t\t\t\t\t   -file   => 'result.blast');\n\n    while (my $result = $in->next_result) {\n\t\tprint $result->query_name, \" \", $result->algorithm, \" \", $result->num_hits(), \" hits\\n\";\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for NCBI BLASTN result output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 CONTRIBUTORS\n\nAdditional contributors names and emails here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Result::BlastPullResult;\n\nuse strict;\n\nuse Bio::Search::Hit::BlastPullHit;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::PullResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Result::hmmpfam->new();\n Function: Builds a new Bio::SearchIO::Result::hmmpfam object \n Returns : Bio::SearchIO::Result::hmmpfam\n Args    : -chunk  => [Bio::Root::IO, $start, $end] (required if no -parent)\n           -parent => Bio::PullParserI object (required if no -chunk)\n           -parameters => hash ref of search parameters (key => value), optional\n           -statistics => hash ref of search statistics (key => value), optional\n\n\t\t   where the array ref provided to -chunk contains an IO object\n           for a filehandle to something representing the raw data of the\n           result, and $start and $end define the tell() position within the\n           filehandle that the result data starts and ends (optional; defaults\n           to start and end of the entire thing described by the filehandle)\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\t\n\t$self->_setup(@args);\n\t\n\tforeach my $field (qw( header hit_table hsp_table alignments next_model models query_length stats_and_params)) {\n\t\t$self->_fields->{$field} = undef;\n\t}\n\t\n\t$self->_dependencies( { ( query_name => 'header',\n                              query_accession => 'header',\n                              query_description => 'header',\n\t\t\t\t\t\t\t  query_length => 'header',\n                              hit_table => 'header',\n\t\t\t\t\t\t\t  num_hits => 'hit_table',\n\t\t\t\t\t\t\t  no_hits_found => 'hit_table' ) } );\n    \n    return $self;\n}\n\n#\n# PullParserI discovery methods so we can answer all ResultI questions\n#\n\nsub _discover_header {\n\tmy $self = shift;\n\t$self->_chunk_seek(0);\n\tmy $header = $self->_get_chunk_by_end(\"Value\\n\");\n\t$self->{_after_header} = $self->_chunk_tell;\n\t\n\t($self->_fields->{query_name}) = $header =~ /^\\s*(\\S+)/;\n\t$self->_fields->{query_accession} = '';\n\t$self->_fields->{query_description} = '';\n\t\n\tif ($header =~ /^Length=(\\d+)/m) {\n\t\t$self->_fields->{query_length} = $1;\n\t}\n\telsif ($header =~ /\\((\\d+) letters\\)/) {\n\t\t# older form?\n\t\t$self->_fields->{query_length} = $1;\n\t\t\n\t\tif ($header =~ /^\\s*\\(\\d+ letters/) {\n\t\t\t# there wasn't a query sequence name\n\t\t\t$self->_fields->{query_name} = '';\n\t\t}\n\t}\n\t\n\t$self->_fields->{header} = 1;\n}\n\nsub _discover_hit_table {\n\tmy $self = shift;\n\t\n\t$self->_chunk_seek($self->{_after_header});\n\tmy $table = $self->_get_chunk_by_end(\"\\n>\");\n\t\n\tunless ($table) {\n\t\t# no alignments, presumably; hit table comprises the remainder of this\n\t\t# result\n\t\twhile (my $line = $self->_get_chunk_by_nol(1)) {\n\t\t\t$table .= $line;\n\t\t}\n\t}\n    \n    $table ||= '';\n    \n\t$self->{_after_hit_table} = $self->_chunk_tell;\n\t\n\tmy $evalue_cutoff = $self->get_field('evalue_cutoff');\n\tundef $evalue_cutoff if $evalue_cutoff eq '[unset]';\n\tmy $score_cutoff = $self->get_field('score_cutoff');\n\tundef $score_cutoff if $score_cutoff eq '[unset]';\n\t\n\tmy @table;\n\tmy $no_hit = 1;\n\twhile ($table =~ /^(\\S+)\\s+(\\S.*?)?\\s+(\\S+)\\s+([\\de]\\S*)\\s*\\n/gm) {\n\t\t$no_hit = 0;\n\t\tmy ($name, $desc, $score, $evalue) = ($1, $2, $3, $4);\n\t\t$desc ||= '';\n        if ($evalue =~ /^e/) {\n            $evalue = '1'.$evalue;\n        }\n\t\tnext if ($evalue_cutoff && $evalue > $evalue_cutoff);\n\t\tnext if ($score_cutoff && $score < $score_cutoff);\n\t\tpush(@table, [$name, $desc, $score, $evalue]);\n\t}\n\t$self->_fields->{hit_table} = \\@table;\n\t$self->{_next_hit_index} = @table > 0 ? 0 : -1;\n\t\n\t$self->_fields->{no_hits_found} = $no_hit;\n\t$self->_fields->{num_hits} = @table;\n}\n\nsub _discover_next_hit {\n\tmy $self = shift;\n\tmy $hit_table = $self->get_field('hit_table');\n\treturn if $self->{_next_hit_index} == -1;\n\tmy $hit_row = ${$hit_table}[$self->{_next_hit_index}];\n\t\n\t$self->_chunk_seek($self->{_end_of_previous_hit} || $self->{_after_hit_table});\n\t\n\tmy ($start, $end) = $self->_find_chunk_by_end(\"\\n>\");\n\tunless ($end) {\n\t\t$start = $self->{_end_of_previous_hit} || $self->{_after_hit_table};\n\t\t$end = $self->_chunk_true_end;\n\t}\n\telse {\n\t\t$end += $self->_chunk_true_start;\n\t}\n\t$start += $self->_chunk_true_start;\n\t\n\t$self->{_end_of_previous_hit} = $end - $self->_chunk_true_start;\n\t\n\t#*** needs to inherit piped_behaviour, and we need to deal with _sequential\n\t#    ourselves\n\t$self->_fields->{next_hit} = Bio::Search::Hit::BlastPullHit->new(-parent => $self,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-chunk => [$self->chunk, $start, $end],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t-hit_data => $hit_row);\n\t\n\t$self->{_next_hit_index}++;\n\t\n\tif ($self->{_next_hit_index} > $#{$hit_table}) {\n\t\t$self->{_next_hit_index} = -1;\n\t}\n}\n\nsub _discover_stats_and_params {\n\tmy $self = shift;\n\t$self->_chunk_seek(0);\n\tmy ($start, $end) = $self->_find_chunk_by_end(\"\\n  Database: \");\n\t$self->_chunk_seek($end);\n\t\n\tmy $gapped = 0;\n\twhile ($self->_get_chunk_by_nol(1)) {\n\t\tif (/Number of letters in database:\\s+(\\S+)/) {\n\t\t\tmy $stat = $1;\n\t\t\t$stat =~ s/,//g;\n\t\t\t$self->add_statistic('dbletters', $stat);\n\t\t}\n\t\telsif (/Number of sequences in database:\\s+(\\S+)/) {\n\t\t\tmy $stat = $1;\n\t\t\t$stat =~ s/,//g;\n\t\t\t$self->add_statistic('dbentries', $stat);\n\t\t}\n\t\telsif (/^Lambda/) {\n\t\t\tmy $line = $self->_get_chunk_by_nol(1);\n\t\t\t$line =~ /\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)/;\n\t\t\t$self->add_statistic($gapped ? 'lambda_gapped' : 'lambda', $1);\n\t\t\t$self->add_statistic($gapped ? 'kappa_gapped' : 'kappa', $2);\n\t\t\t$self->add_statistic($gapped ? 'entropy_gapped' : 'entropy', $3);\n\t\t\t$gapped = 1;\n\t\t}\n\t\telsif (/^Matrix: (.+)\\n/) {\n\t\t\t$self->add_parameter('matrix', $1);\n\t\t}\n\t\telsif (/^Gap Penalties: Existence: (\\d+), Extension: (\\d+)/) {\n\t\t\t$self->add_parameter('gapopen', $1);\n\t\t\t$self->add_parameter('gapext', $2);\n\t\t}\n\t\telsif (/^Number of Hits to DB: (\\d+)/) {\n\t\t\t$self->add_statistic('Hits_to_DB', $1);\n\t\t}\n\t\telsif (/^Number of extensions: (\\d+)/) {\n\t\t\t$self->add_statistic('num_extensions', $1);\n\t\t}\n\t\telsif (/^Number of successful extensions: (\\d+)/) {\n\t\t\t$self->add_statistic('num_successful_extensions', $1);\n\t\t}\n\t\telsif (/^Number of sequences better than (\\S+):/) {\n\t\t\t$self->add_parameter('expect', $1);\n\t\t}\n\t\telsif (/^[Ll]ength of query: (\\d+)/) {\n\t\t\t$self->add_statistic('querylength', $1);\n\t\t}\n        elsif (/^[Ee]ffective HSP length: (\\d+)/) {\n\t\t\t$self->add_statistic('effective_hsplength', $1);\n\t\t}\n\t\telsif (/^[Ee]ffective length of database: (\\d+)/) {\n\t\t\t$self->add_statistic('effectivedblength', $1);\n\t\t}\n\t\telsif (/^[Ee]ffective search space: (\\d+)/) {\n\t\t\t$self->add_statistic('effectivespace', $1);\n\t\t}\n\t\telsif (/^[Ee]ffective search space used: (\\d+)/) {\n\t\t\t$self->add_statistic('effectivespaceused', $1);\n\t\t}\n\t\telsif (/^([TAXS]\\d?): (\\d+)(?: \\((\\S+))?/) {\n\t\t\t$self->add_statistic($1, $2);\n\t\t\t$self->add_statistic($1.'_bits', $3) if $3;\n\t\t}\n\t}\n\t\n\t$self->_fields->{stats_and_params} = 1;\n}\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\nsub next_hit {\n\tmy $self = shift;\n    my $hit = $self->get_field('next_hit');\n\tundef $self->_fields->{next_hit};\n\treturn $hit;\n}\n\n=head2 hits\n\n Title   : hits\n Usage   : my @hits = $result->hits\n Function: Returns the HitI objects contained within this Result\n Returns : Array of Bio::Search::Hit::HitI objects\n Args    : none\n\nSee Also: L<Bio::Search::Hit::HitI>\n\n\nsub hits {\n\tmy $self = shift;\n\tmy $old = $self->{_next_hit_index} || 0;\n\t$self->rewind;\n\tmy @hits;\n\twhile (defined(my $hit = $self->next_hit)) {\n\t\tpush(@hits, $hit);\n\t}\n\t$self->{_next_hit_index} = @hits > 0 ? $old : -1;\n\treturn @hits;\n}\n\n=head2 sort_hits\n\n Title\t\t: sort_hits\n Usage\t\t: $result->sort_hits('<score')\n Function\t: Sorts the hits so that they come out in the desired order when\n              hits() or next_hit() is called.\n Returns\t: n/a\n Args\t\t: A coderef for the sort function. See the documentation on the Perl\n              sort() function for guidelines on writing sort functions.\n\t\t\t  By default the sort order is ascending significance value (ie.\n\t\t\t  most significant hits first).\n\t\t\t  *** example","parameters":[{"label":"$self"},{"label":"$code_ref"}]}},{"range":{"end":{"character":9999,"line":382},"start":{"line":377,"character":0}},"kind":12,"line":377,"containerName":"main::","name":"rewind","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"rewind","line":378,"definition":"my"},{"name":"$self","kind":13,"containerName":"rewind","line":379},{"name":"_fields","containerName":"rewind","kind":12,"line":379},{"kind":13,"containerName":"rewind","name":"$self","line":380},{"line":380,"kind":12,"containerName":"rewind","name":"get_field"},{"containerName":"rewind","kind":13,"name":"$self","line":382},{"line":382,"kind":13,"containerName":"rewind","name":"$self"},{"kind":12,"containerName":"rewind","name":"_fields","line":382}],"definition":"sub"},{"line":379,"name":"hit_table","kind":12},{"name":"_next_hit_index","kind":12,"line":382},{"line":382,"name":"hit_table","kind":12},{"containerName":"main::","name":"get_statistic","children":[{"line":397,"name":"$self","localvar":"my","kind":13,"containerName":"get_statistic","definition":"my"},{"name":"$self","containerName":"get_statistic","kind":13,"line":398},{"line":398,"name":"get_field","kind":12,"containerName":"get_statistic"},{"line":399,"name":"$self","containerName":"get_statistic","kind":13}],"definition":"sub","kind":12,"range":{"end":{"line":400,"character":9999},"start":{"character":0,"line":396}},"line":396},{"line":399,"kind":12,"containerName":"get_statistic","name":"SUPER"},{"definition":"sub","name":"get_parameter","containerName":"main::","children":[{"definition":"my","line":414,"name":"$self","containerName":"get_parameter","localvar":"my","kind":13},{"containerName":"get_parameter","kind":13,"name":"$self","line":415},{"name":"get_field","kind":12,"containerName":"get_parameter","line":415},{"line":416,"containerName":"get_parameter","kind":13,"name":"$self"}],"kind":12,"range":{"end":{"character":9999,"line":417},"start":{"line":413,"character":0}},"line":413},{"name":"SUPER","kind":12,"containerName":"get_parameter","line":416}],"version":5}